# Nikhyl Singhal - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Nikhyl Singhal.

---

### [00:00:00] Nikhyl Singhal

**English:**
When I was a kid and I was growing up in the Midwest, entertainment was like going to the dog tracks. The way that they motivated the dogs was they had these fake rabbits. These tails would go around faster than the dogs, which would then motivate the dogs to go around in circles. And what was interesting is the moment that the dogs, if they accidentally touched the rabbit, they would never run again because there was like, "Well, what's next? I've achieved what I was looking for." So I think this happens a ton, it's like your listeners are spending time focused on like, "Well, one day I will be X. I will be that vice president. I will have more money. I will have built something. I will have started a company." But they don't think about what happens next. What's the second thing? What's your career next look like? How do you ensure that you are always going to have something important and motivating to do with your career? Otherwise, you'll keep working because you know nothing else to do, but you'll be sadder or you'll find ways to create war when peace is needed.

**中文翻译:**
当我还是个孩子在美中西部长大时，那里的娱乐活动就是去赛狗场。他们激励赛狗的方式是使用假兔子。这些兔子的尾巴转得比狗快，从而激励狗绕圈跑。有趣的是，一旦那些狗不小心碰到了兔子，它们就再也不会跑了，因为它们会想：“好吧，接下来呢？我已经得到了我想要的东西。” 我认为这种情况经常发生，就像你的听众花时间专注于：“好吧，总有一天我会成为某某人。我会成为副总裁。我会更有钱。我会做出一些成就。我会创办一家公司。” 但他们没有思考接下来会发生什么。第二步是什么？你的职业生涯下一步是什么样子的？你如何确保你的职业生涯中总会有重要且有动力的事情可做？否则，你会因为不知道还能做什么而继续工作，但你会变得更忧郁，或者在需要和平的时候找借口挑起事端。

---

### [00:01:05] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Nikhyl Singhal. Nikhyl has worked on and led large teams on four different influential consumer products including Facebook, Credit Karma, Google Hangouts, and Google Photos. Currently, he leads product teams for the Facebook app at Meta, overseeing groups, stories, messaging, and the feed. Before that, he served as chief product officer at Credit Karma and held various leadership roles at Google. Nikhyl has also co-founded three different startups, and as you'll hear in this episode, is extremely passionate about coaching and mentoring, sharing his knowledge through his newsletter and podcast called The Skip.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我采访世界级的产品领导者和增长专家，学习他们在打造和发展当今最成功产品过程中获得的宝贵经验。今天的嘉宾是 Nikhyl Singhal。Nikhyl 曾在四个不同的具有影响力的消费级产品中工作并领导大型团队，包括 Facebook、Credit Karma、Google Hangouts 和 Google Photos。目前，他在 Meta 领导 Facebook 应用的产品团队，负责群组 (Groups)、快拍 (Stories)、消息 (Messaging) 和动态 (Feed)。在此之前，他曾担任 Credit Karma 的首席产品官 (CPO)，并在 Google 担任过多个领导职务。Nikhyl 还共同创办过三家不同的初创公司。正如你在本集中将听到的那样，他非常热衷于教练和指导工作，并通过他的时事通讯和名为《The Skip》的播客分享他的知识。

---

### [00:01:47] Lenny

**English:**
In our conversation, we cover all aspects of the PM career and what it takes to be successful at every stage of the journey, including the dangers of thinking too short term, the importance of avoiding what he calls ex-growth companies, why you're probably not getting promoted, what to focus on if you're a new manager, the rise of the senior IC path, also why top leaders often have huge development areas they don't know about and how to catch them, and also why people who make it to the top often run into serious mental health challenges. As I say at the end of this episode, this might be my new favorite episode and I'm really excited to bring it to you. With that, I bring you Nikhyl Singhal after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们涵盖了产品经理 (PM) 职业生涯的方方面面，以及在旅程的每个阶段取得成功所需的条件，包括：短期思维的危险、避开他所谓的“增长停滞型 (ex-growth)”公司的重要性、你可能没有获得晋升的原因、如果你是新任经理应该关注什么、资深个人贡献者 (Senior IC) 路径的兴起，以及为什么顶级领导者通常有自己不知道的巨大发展盲区以及如何发现它们，还有为什么爬到顶峰的人经常会遇到严重的心理健康挑战。正如我在本集结尾所说，这可能是我最喜欢的新一集，我非常激动能把它带给你们。在听完赞助商的简短介绍后，让我们开始与 Nikhyl Singhal 的对话。

---

### [00:02:28] Lenny

**English:**
This episode is brought to you by Superhuman. How much time do you spend in email each day? How about your team? You may not realize this, but your email tools are wasting your time. Superhuman is blazingly fast email for high-performing teams. Built to work with Gmail and Outlook, teams who use Superhuman spend half the time in their inboxes, respond to twice the number of emails, and save over four hours a week. That's over a month of saved time per year. With Superhuman, you can split your inbox into streams for VIPs, team members, and emails from your favorite products to reduce context switching and make sure you never miss an important email. You can start reminders if you don't hear back so that you can follow up and never drop the ball on an email thread. You can also work faster than ever before with powerful AI features like writing, editing, summarizing, and even translating. Join the ranks of the most productive teams and unleash the power of Superhuman. Try one month free at superhuman.com/lenny. That's superhuman.com/lenny.

**中文翻译:**
本集由 Superhuman 赞助。你每天花多少时间处理邮件？你的团队呢？你可能没有意识到，你的邮件工具正在浪费你的时间。Superhuman 是为高效团队打造的极速邮件工具。它兼容 Gmail 和 Outlook，使用 Superhuman 的团队在收件箱上花费的时间减少了一半，回复邮件的数量增加了一倍，每周节省超过四个小时。这相当于每年节省了一个多月的时间。通过 Superhuman，你可以将收件箱拆分为 VIP、团队成员和来自你喜爱产品的邮件流，以减少上下文切换并确保你不会错过重要邮件。如果没收到回复，你可以设置提醒，以便跟进，永远不会在邮件链中掉链子。你还可以利用强大的 AI 功能（如写作、编辑、总结甚至翻译）比以往更快地工作。加入最高效团队的行列，释放 Superhuman 的力量。在 superhuman.com/lenny 免费试用一个月。

---

### [00:03:31] Lenny

**English:**
This episode is brought to you by Microsoft Clarity, a free, easy-to-use tool that captures how real people are actually using your site. You can watch live session replays to discover where users are breezing through your flow and where they struggle. You can view instant heat maps to see what parts of your page users are engaging with and what content they're ignoring. You can also pinpoint what's bothering your users with really cool frustration metrics like rage clicks, and dead clicks, and much more.

**中文翻译:**
本集由 Microsoft Clarity 赞助。这是一款免费、易用的工具，可以捕捉真实用户是如何使用你的网站的。你可以观看实时会话回放，发现用户在哪些环节进展顺利，在哪些环节遇到困难。你可以查看即时热力图，了解用户参与了页面的哪些部分，忽略了哪些内容。你还可以通过非常酷的“挫败感指标”（如愤怒点击、无效点击等）精准定位困扰用户的问题。

---

### [00:03:56] Lenny

**English:**
If you listen to this podcast, you know how often we talk about the importance of knowing your users and by seeing how users truly experience your product, you can identify product opportunities, conversion wins, and find big gaps between how you imagine people using your product and how they actually use it. Microsoft Clarity makes it all possible with a simple yet incredibly powerful set of features. You'll be blown away by how easy Clarity is to use and it's completely free forever. You'll never run into traffic limits or be forced upgrade to a paid version. It also works across both apps and websites. Stop guessing, get clarity, check out Clarity at clarity.microsoft.com.

**中文翻译:**
如果你听过这个播客，你就知道我们经常谈论了解用户的重要性。通过观察用户真实的体验，你可以发现产品机会、转化增长点，并找到你想象中的用户行为与实际行为之间的巨大差距。Microsoft Clarity 通过一套简单但功能极其强大的功能让这一切成为可能。你会对 Clarity 的易用性感到惊讶，而且它永远完全免费。你永远不会遇到流量限制，也不会被强制升级到付费版本。它还同时支持应用和网站。停止猜测，获取清晰的洞察，请访问 clarity.microsoft.com 查看 Clarity。

---

### [00:04:40] Lenny

**English:**
Nikhyl, welcome to the podcast.

**中文翻译:**
Nikhyl，欢迎来到播客。

---

### [00:04:43] Nikhyl Singhal

**English:**
Thank you, Lenny. I appreciate it. I'm happy to be here.

**中文翻译:**
谢谢你，Lenny。很荣幸能来到这里。

---

### [00:04:45] Lenny

**English:**
So I have a very simple question to start. How many product managers have you been a mentor to if you had to put a number on it?

**中文翻译:**
首先我有一个非常简单的问题。如果你必须给出一个数字，你指导过多少位产品经理？

---

### [00:04:53] Nikhyl Singhal

**English:**
Good question. I guess I haven't thought about it from that perspective. I would say hundreds is probably the way to sort of answer the question, and a little bit has to do with whether how we define being a mentor. I know that was supposed to be a simple question and I'm going to give you a complicated answer, but I think that I started out just helping people 10, 15 years ago, trying to help them through their careers. I find the whole area really interesting. And then what happened was just I started to scale because people were always like, "Hey, can you find time?" So now what I do is I tend to help and coach hundreds of folks through transitions. So if they're in a moment where they're trying to decide between another job, if they're trying to decide to leave, if they're having sort of an alert at work, I call them 911 calls. I take a few 911 calls every week and from a relatively large group of people. So I find those are the most substantive times to help people, is when they're in moments of dilemma or forks in the road, and that's why the number is more closer to hundreds.

**中文翻译:**
好问题。我想我还没从这个角度思考过。我会说“数百个”可能是回答这个问题的方式，这在一定程度上取决于我们如何定义“导师”。我知道这本该是个简单的问题，但我会给你一个复杂的答案。我想我从 10、15 年前就开始帮助别人，试图在他们的职业生涯中提供帮助。我觉得整个领域都非常有趣。后来发生的事情是，我开始规模化这种帮助，因为人们总是问：“嘿，你能抽点时间吗？” 所以现在我所做的是，倾向于帮助和指导数百人度过转型期。如果他们正处于决定是否换工作、是否离职，或者工作中出现了某种警报，我称之为“911 电话”。我每周都会接到几个来自相对庞大群体的 911 电话。所以我发现，帮助人们最实质性的时刻就是当他们处于困境或人生十字路口时，这就是为什么这个数字更接近数百个。

---

### [00:05:54] Lenny

**English:**
Okay. Follow-up question: How many of those people you've mentored have been on this podcast?

**中文翻译:**
好的。追问一个问题：在你指导过的人中，有多少人上过这个播客？

---

### [00:05:58] Nikhyl Singhal

**English:**
Probably half dozen to kind of close to a dozen at this point.

**中文翻译:**
目前大概有半打到接近一打吧。

---

### [00:06:02] Lenny

**English:**
Oh, wow.

**中文翻译:**
噢，哇。

---

### [00:06:03] Nikhyl Singhal

**English:**
Yeah, easily half dozen.

**中文翻译:**
是的，轻轻松松就有半打。

---

### [00:06:06] Lenny

**English:**
Amazing. Okay. Is there any names you want to name or should we keep it anonymous?

**中文翻译:**
太棒了。好的。有什么你想提到的名字吗，还是我们保持匿名？

---

### [00:06:09] Nikhyl Singhal

**English:**
Yeah. We'll keep it anonymous because I want people to feel they can always call me in and not feel like that. I don't tend to share the names of most people.

**中文翻译:**
是的，我们保持匿名吧，因为我希望人们觉得他们随时可以找我，而不会有顾虑。我不倾向于分享大多数人的名字。

---

### [00:06:17] Lenny

**English:**
Okay. I know the one person that self-identified was Annie Pearl from Calendly, who is a big advocate of the stuff that you do. So we don't want-

**中文翻译:**
好的。我知道有一个公开身份的人是来自 Calendly 的 Annie Pearl，她是你的忠实拥护者。所以我们不想——

---

### [00:06:23] Nikhyl Singhal

**English:**
Yeah. Annie is someone I learned from and helped talk with, and she's also part of a community that I also build on the side where we pulled a bunch of CPOs together and they've been building community. I'm a big fan of community and learning, and she's part of that as well.

**中文翻译:**
是的。Annie 是我学习和交流的对象，她也是我业余建立的一个社区的成员，我们把一群 CPO 聚集在一起，他们一直在建设社区。我是社区和学习的忠实粉丝，她也是其中的一员。

---

### [00:06:39] Lenny

**English:**
Awesome. I definitely want to talk about that, but maybe just set a little context for our conversation. I feel like you're in the very high percentiles of people that have seen a variety of careers in product management, both good careers, bad careers, junior people, senior people. So I want to focus most of our time on talking about just the PM career path and what you've learned about what is important to have a successful, thriving, happy PM career. Does that sound good?

**中文翻译:**
太好了。我肯定想聊聊那个，但也许先为我们的对话设定一点背景。我觉得你在见过各种产品经理职业生涯的人中处于极高的百分位，无论是成功的、失败的、初级的还是资深的。所以我希望把大部分时间花在讨论 PM 职业路径上，以及你所学到的关于拥有一个成功、繁荣、快乐的 PM 职业生涯的重要因素。听起来可以吗？

---

### [00:07:07] Nikhyl Singhal

**English:**
Perfect.

**中文翻译:**
完美。

---

### [00:07:08] Lenny

**English:**
Okay. So I'm thinking we break up the chat into early career, mid-career, and late career. So within the early career section, you've talked about how people often make a mistake in their early career, specifically being very short-term focused in deciding where they're going to go. And that's a very dangerous way of thinking about it. So I'd love to hear just your take on exactly what does that mean, and why is that actually a bad idea?

**中文翻译:**
好的。我想我们可以把聊天分为职业早期、职业中期和职业晚期。在职业早期部分，你谈到过人们在职业生涯早期经常犯的一个错误，特别是决定去向时非常关注短期利益。这是一种非常危险的思维方式。所以我很想听听你对这到底意味着什么的看法，以及为什么这实际上是个坏主意？

---

### [00:07:33] Nikhyl Singhal

**English:**
Yeah. I tend to be long-term focused in most of my counsel, and maybe to give you an example of what a short-term focus career kind of framework looks like is, "I really dislike my boss. I feel like this company doesn't have it anymore. There's just too hard to ship things." Those are all maybe true statements, but they probably exist in many of the jobs that one would consider if they were to move for one to another. Lateral moves are by definition not forward moves. So what I try to tell people to think about is work backwards from your end state. Almost think of career as a product. So if you're building a good product, you think about, "Well, here's what a great product would look like," and then you break it into version one, version two, version three. Well, in some ways the reason I called my newsletter, my podcast The Skip is because I always think about not the next job, but the one after it. Maybe think about not your boss's job but your boss's boss's job and what do I need to think about to get there. And in many ways you may think, "Well, okay, if I need to found a company one day and that's my job after next," then you want to look at maybe your current job and then maybe the next job in service of that. And that may lead you to saying, "Hey, maybe I need a grit of doubt and maybe I should stay and maybe I should learn how to deal with some of this ambiguity. That's why I want people to be a bit more longer term and not so short-term focused.

**中文翻译:**
是的。在我的大多数建议中，我倾向于关注长期。举个例子，短期关注的职业框架看起来是这样的：“我真的很讨厌我的老板。我觉得这家公司已经不行了。发布产品太难了。” 这些可能都是事实，但如果你换一份工作，这些问题在很多其他工作中可能同样存在。横向移动从定义上讲并不是进步。所以我试图告诉人们去思考的是：从你的最终状态倒推。几乎要把职业生涯看作一个产品。如果你在打造一个好产品，你会想：“一个伟大的产品应该是这样的”，然后你把它分解成版本 1、版本 2、版本 3。在某种程度上，我把我的时事通讯和播客命名为《The Skip》（跳跃）的原因是，我总是考虑的不是下一份工作，而是下下份工作。也许不要考虑你老板的工作，而是考虑你老板的老板的工作，以及为了达到那个位置我需要考虑什么。在很多情况下你可能会想：“好吧，如果有一天我需要创办一家公司，那是我的下下份工作”，那么你就要审视你目前的工作，以及下一份工作如何为此服务。这可能会让你觉得：“嘿，也许我需要一点磨练，也许我应该留下来，学习如何处理这些模糊性。” 这就是为什么我希望人们眼光长远一点，不要只盯着短期。

---

### [00:09:07] Lenny

**English:**
What are some other examples of that short-term thinking? You talked about "my manager sucks, things are moving really slowly." What other examples where people maybe like, "Oh, okay, I see, this is actually short term. Let me think longer term"?

**中文翻译:**
还有哪些短期思维的例子？你提到了“我的经理很烂，事情进展太慢”。还有哪些例子能让人们意识到：“噢，好吧，我明白了，这实际上是短期的。让我考虑得长远一点”？

---

### [00:09:17] Nikhyl Singhal

**English:**
I'd say the biggest one in workplace is focusing career and promotion together. I think that there's perhaps a light connection between promotion and career addition, but I feel like too many people are, the moment we talk about career, they're like, "Well, let me talk to you. I want to have a career talk with you." And I said, "Sure, why don't you find some time?" We sit down together and they're like, "Well, what do you think I need to do to get to promotion?" And then I said, "Well, promotion is our system at this company to see you moving forward. And it's pretty clear in terms of levels and what you're doing and what the process is and who makes the decision." And that's pretty short term because you can ask, "Hey, it's two years away, how do I make it 18 months?" It's a classic. But in reality, if you're thinking career, you're thinking about the sort of long term arc and, as I said, maybe the job after next, and then you need to look at the promotion in service because how many people have you and I talked to who said, "Well then, as soon as I get promoted, I'm going to leave"? So then I'm like, "Well, okay, then what's the promotion in service of?" And you get into that conversation, which tends to be, again, very long-term focused.

**中文翻译:**
我会说职场中最大的一个误区是将“职业生涯”和“晋升”混为一谈。我认为晋升和职业增值之间可能只有微弱的联系，但我感觉太多人一谈到职业生涯，就会说：“我想和你谈谈职业发展。” 我说：“好啊，你找个时间。” 我们坐下来，他们会问：“你觉得我需要做些什么才能获得晋升？” 然后我会说：“晋升是公司衡量你进步的系统。关于职级、你的工作内容、流程以及谁做决定，这些都很明确。” 而这其实是很短期的，因为你会问：“嘿，还有两年才能晋升，我怎么能缩短到 18 个月？” 这是个经典问题。但实际上，如果你在考虑职业生涯，你考虑的是长期的弧线，正如我所说，可能是下下份工作，然后你需要审视晋升是如何为此服务的。因为你和我聊过多少人说过：“好吧，一旦我获得晋升，我就离开”？于是我会问：“那么晋升是为了什么服务的？” 然后你就会进入那种对话，而这种对话往往又是非常长期导向的。

---

### [00:10:36] Lenny

**English:**
This makes me think about this interesting two-sided challenge with thinking about your future career and where you want to go. On the one hand, it's valuable to think about getting more logos in your resume and working at Netflix and Meta and Airbnb and Uber, all these guys, there's power and value to that. On the other hand, you just keep doing that. And then what is your life turning into? You're just chasing more fancy logos and feeling better about better brands and your resume and stuff. This might be too big a question, but just how do you advise people to think about how important it's to get some of these companies in your resume and build that side of it versus just doing things you actually enjoy and having a fulfilling life and doing things that are meaningful to you?

**中文翻译:**
这让我想到了思考未来职业生涯和去向时一个有趣的双面挑战。一方面，考虑在简历中增加更多大厂标志（logos），在 Netflix、Meta、Airbnb 和 Uber 等公司工作是有价值的，这其中确实有力量和价值。但另一方面，如果你一直这样做，你的生活会变成什么样？你只是在追求更多光鲜的标志，为了简历上更好的品牌而自我感觉良好。这可能是一个太大的问题，但你如何建议人们去权衡简历中拥有这些大公司经历的重要性，与仅仅做自己真正喜欢的事情、拥有充实的生活以及做对自己有意义的事情之间的关系？

---

### [00:11:18] Nikhyl Singhal

**English:**
Yeah. I mean I think collecting labels does feel shallow to most builders because if you're a product person, you probably got into the business because you like building stuff. And frankly, not just product people want to do that, a lot of technical people want to just build stuff. And then the question is, is the things that you're working on in service of building? And then when you ask people, "Were you happy?" as they always say, "Well, when I was able to build this thing," and oftentimes they don't care whether it worked or not, which is kind of ironic. So for me, when I see people chasing logos, I think about it as well. I'm actually really a big fan of a diverse set of experiences, that I think learning about pre-product market fit then seeing smoke turn into fire and witnessing and maybe shepherding that and then taking fire and turning it into something great and being an experience set where you can see the movie in these different frames makes you just a better builder. So you can't really go wrong if you're looking at those experiences. And you're looking at inside the building problems and outside the building problems, those are maybe consumer problems and business-to-business problems. The more diverse career you have, the better builder you are. And that usually comes up being satisfied. But the idea of just doing that because you think it's going to make your chances better for the next job maybe scares me and it feels very much in service of some future dream that is not build oriented. And I think that can be leading to sadness.

**中文翻译:**
是的。我的意思是，对于大多数“建设者”来说，收集标签确实感觉很浅薄，因为如果你是一个产品人，你进入这个行业大概是因为你喜欢创造东西。坦率地说，不仅是产品人想这么做，很多技术人员也只想创造东西。那么问题就在于，你所做的事情是否是为了“创造”服务的？当你问人们“你快乐吗？”时，他们总是说：“当我能够做出这个东西的时候。” 而且通常他们并不在乎它是否成功，这有点讽刺。所以对我来说，当我看到人们追求大厂标志时，我也会思考。我其实非常推崇多样化的经验，我认为学习产品市场匹配（PMF）之前的阶段，然后看到星星之火变成燎原之势，见证并引导这个过程，再把火势转化为伟大的事业，这种能让你在不同框架下看清“电影全貌”的经验组合，会让你成为一个更好的建设者。所以如果你追求的是这些经验，你通常不会出错。你在审视“大楼内部”的问题和“大楼外部”的问题，那些可能是消费者问题或 B2B 问题。你的职业生涯越多样化，你就越是一个优秀的建设者。这通常会带来满足感。但如果仅仅因为你认为这会增加你下一份工作的机会而去做这些事，这可能会让我感到担忧，因为它感觉非常像是为了某种非建设导向的未来梦想而服务的。我认为这可能会导致不快乐。

---

### [00:12:54] Lenny

**English:**
I love that advice, and I say this often actually on this podcast, the power of a diversity of experiences for so many reasons. Maybe just to close this loop, would you agree there is a lot of value in having one of these FAANG ish companies on your resume? Like a lot of opportunity gets unlocked if you work at one of these companies that people are like, "Oh wow, okay, this person's interesting." Or not? Or do people maybe overthink that?

**中文翻译:**
我非常喜欢这个建议，实际上我也经常在播客中提到多样化经验的力量。也许为了结束这个话题，你是否同意在简历中拥有一家 FAANG 级别的公司有很大价值？比如，如果你在这些公司工作过，人们会觉得“噢哇，这个人很有趣”，从而开启很多机会。还是说人们可能想多了？

---

### [00:13:17] Nikhyl Singhal

**English:**
Generically, the answer is yes. I think it's especially important for executives. I think that many executives are hired because they are to bring expertise of the next phase of organization to this company. We're growing, we want to go after the next phase. We want someone who's has expertise. The MAGMA or FAANG companies, however you want to describe them, they really have challenges and expertise at how to build things at scale, how to manage millions or billions of users and customers. So the advantage is, to be successful at that is an endorsement. Having said that, those specific companies, experiences can be substituted for other later stage companies, but if you're coming in as an executive to bring someone to the next level and you've never experienced it, it's very difficult thing to get that executive experience and to be like a C-level for that growth company.

**中文翻译:**
总的来说，答案是肯定的。我认为这对高管来说尤其重要。我认为许多高管被聘用是因为他们能为公司带来组织下一阶段所需的专业知识。我们正在成长，我们想要进入下一阶段，我们需要有经验的人。MAGMA 或 FAANG 公司（无论你怎么称呼它们），它们在如何大规模构建产品、如何管理数百万或数十亿用户和客户方面确实面临挑战并拥有专业知识。所以优势在于，在这些公司取得成功是一种背书。话虽如此，这些特定公司的经验可以被其他后期公司的经验所取代，但如果你作为一名高管要带领公司进入下一个阶段，而你从未经历过那个阶段，那么要获得那种高管经验并成为那家成长型公司的 C 级领导是非常困难的。

---

### [00:14:30] Lenny

**English:**
To point out, FAANG is no longer accurate because Facebook is now Meta. So MAGMA is the term that you prefer.

**中文翻译:**
需要指出的是，FAANG 已经不再准确了，因为 Facebook 现在是 Meta。所以 MAGMA 是你更喜欢的术语。

---

### [00:14:33] Nikhyl Singhal

**English:**
I prefer that. I think it unfortunately kicks out Netflix, but it also doesn't pay homage to Adobe and Salesforce and a number of other great companies. So I think-

**中文翻译:**
我更喜欢那个。我觉得遗憾的是它把 Netflix 踢出去了，但它也没有向 Adobe、Salesforce 和其他许多伟大的公司致敬。所以我认为——

---

### [00:14:50] Lenny

**English:**
FAANG doesn't. Okay, I like this. Okay, let's try to make MAGMA the new thing. MAGMA, make that the title of this episode. Just joking. So the next area I want to touch on is, you wrote this kind of hot take on something you call ex-growth companies and how it's not good to be at an ex-growth company currently. So can you just talk about what is an ex-growth company and then why is that not a good place to be as a product manager for probably any kind of role?

**中文翻译:**
FAANG 确实没有。好的，我喜欢这个。好吧，让我们试着让 MAGMA 成为新潮流。MAGMA，把这个作为本集的标题。开个玩笑。接下来我想触及的领域是，你写过一个关于你称之为“增长停滞型 (ex-growth)”公司的犀利观点，以及为什么目前待在一家增长停滞型公司并不好。你能谈谈什么是增长停滞型公司，以及为什么作为产品经理（无论什么职位）待在那里不是个好选择吗？

---

### [00:15:09] Nikhyl Singhal

**English:**
I have a pretty strong opinion on this that I think that for 10 years we created the hypergrowth, blitzscaling type phenomenon, and there was a lot of good reasons for that, some of which were just distribution platforms just got so good. You could take out Facebook ads, you could grow with Google, and you could grow in 18 months that maybe took previous companies 10 years. So I think that the idea was that all of these companies could instantly grow when they found product market fit and that birthed all these unicorns. And then suddenly, 18 months ago, it almost like the music stopped. 0% interest rate went away, and it became a lot harder to find growth through just fueling it with capital. And I think that the sudden change meant that not only capital was harder to raise, but companies started to focus on their core products. You've talked about it on this podcast, just how many layoffs and restructuring and managers moving to ICs, and all of that work is happening. Well, the one funny pocket was there's these large number of growth companies who have raised substantive dollars. So they're not going to run out of capital in 2022 or 2023. What's going to happen is, they actually have quite long periods of time, so you don't see them raising new rounds, you don't see them laying off, but in some ways they're still hiring or they're still seeking the next product. The sad truth is that many of their contemporary companies that went public are worth 10% or less than what they were worth back then, and these companies are privately held and so they're sort of sleeping in the shadows. My fear is, from a career point of view, so many tech professionals are in these organizations or joining these organizations with the expectation that they'll make money on their equity, that they'll continue to do fine. And my sense is we're going to see, even in the second half of this year, lots of boards pulling back, taking their capital back, companies essentially saying, "Hey, we're capitalized. We're a scaled ocean liner, and now we need to go find product market fit." But doing that with 300 people and expectations of hitting a multi-billion dollar valuation just isn't going to happen. So that's the reason why I'm like, "Danger. This is not the company to join, this is the company to leave. Find another phase. Time's a wasting." And I worry very much that people aren't getting the message.

**中文翻译:**
我对这个问题有非常强烈的看法。我认为在过去的 10 年里，我们创造了超速增长、闪电式扩张的现象，这有很多充分的理由，其中之一就是分发平台变得太强大了。你可以投放 Facebook 广告，可以利用 Google 增长，以前的公司可能需要 10 年才能达到的增长，你 18 个月就能实现。所以当时的理念是，所有这些公司一旦找到产品市场匹配（PMF），就能瞬间增长，这催生了所有这些独角兽。然后突然间，在 18 个月前，音乐仿佛停止了。零利率时代结束了，仅仅通过资本驱动来寻求增长变得困难得多。我认为这种突然的变化意味着不仅融资变难了，公司也开始专注于核心产品。你在这个播客中也谈到过，发生了多少裁员、重组以及经理转为个人贡献者（IC），所有这些工作都在进行。然而，有一个有趣的角落：有大量成长型公司已经筹集了大量资金。所以他们在 2022 年或 2023 年不会耗尽资金。实际情况是，他们其实有相当长的一段时间，所以你没看到他们融资，也没看到他们裁员，但在某种程度上他们仍在招聘，或者仍在寻找下一个产品。悲哀的事实是，许多与他们同时代的已上市公司现在的市值只有当年的 10% 甚至更低，而这些公司是私有的，所以它们像是躲在阴影里睡觉。我的担忧是，从职业生涯的角度来看，这么多技术专业人士待在这些组织中或加入这些组织，期望能从股权中获利，期望一切都会好起来。我的感觉是，即使在今年下半年，我们也会看到许多董事会撤资、收回资本，公司基本上会说：“嘿，我们有资金。我们是一艘规模巨大的远洋客轮，现在我们需要去寻找产品市场匹配。” 但是，带着 300 人去寻找 PMF，同时还期望达到数十亿美元的估值，这根本不可能发生。这就是为什么我觉得：“危险。这不是该加入的公司，而是该离开的公司。去寻找另一个阶段吧。时间在流逝。” 我非常担心人们没有收到这个信号。

---

### [00:18:00] Lenny

**English:**
I know you probably don't want to name any names of companies, but what are some signs that may be you're at one of these companies?

**中文翻译:**
我知道你可能不想点名任何公司，但有哪些迹象表明你可能就在这样的一家公司里？

---

### [00:18:07] Nikhyl Singhal

**English:**
I think that the moment that you are reframing the core product, trying to find that product market implies that this company's valuation needs to be a pre-product market fit valuation. So the two questions you ask yourself the day after we listen to this podcast is, "Hey, are we scaling a product? We have customers that love us and we have a tremendous sucking sound? Or are we trying to find that customer sucking sound?" And if the answer is, "We're still trying to find it," and then you're like, "Is your evaluation hundreds of millions or tens of millions?" and if the answer is hundreds or more and you're still trying to find that sucking sound, you're an ex-growth company.

**中文翻译:**
我认为，当你开始重新定义核心产品、试图寻找产品市场匹配时，这意味着这家公司的估值应该是“前 PMF 阶段”的估值。所以听完这期播客后的第二天，你要问自己两个问题：“嘿，我们是在规模化一个产品吗？我们有热爱我们的客户，并且能听到巨大的市场拉力（sucking sound）吗？还是我们正在努力寻找那种客户拉力？” 如果答案是“我们还在努力寻找”，而你的估值又是数亿甚至数十亿美元，那么你就是一家增长停滞型公司。

---

### [00:19:05] Lenny

**English:**
As a founder listening to this, I bet you're like, "Damn, we don't want people leaving. This isn't the kind of message we want to hear." On the other hand, as an employee at a company, that is your advice, just generally recognize it and then you should probably leave as soon as possible because things are not going to work out for you.

**中文翻译:**
作为听这期节目的创始人，我敢打赌你会想：“该死，我们不希望员工离开。这不是我们想听到的消息。” 另一方面，作为公司的员工，你的建议是：普遍地识别出这一点，然后你应该尽快离开，因为事情对你来说不会有好的结果。

---

### [00:19:15] Nikhyl Singhal

**English:**
As an employee, I think you have almost no recourse because you almost have to start over in terms of it's a new four-year investment. I think that as a founder, you can recap your company. You can reset your stock price, you could reissue. You can make those hard decisions and you can maybe return some of the money to the board and still continue, or you can pull the plug and restart the company that maybe you really wanted to. But I think the founder is in a better position, but they also have a lot more to lose and far more constraints. But employees, they're not... If you listen to this and come to this conclusion, a lot of times, the listeners here, half or more of their compensation is an equity and we just concluded that most of their equity may not be worth anything. In which case, are you willing to take a half pay cut or work for 20% of what you can get on the market? My question is, that seems to be quite concerning, the opportunity cost is just too rich.

**中文翻译:**
作为员工，我认为你几乎没有退路，因为就四年的投入而言，你几乎必须重新开始。我认为作为创始人，你可以重组公司资本。你可以重设行权价，可以重新发行股票。你可以做出那些艰难的决定，也许可以退还一部分钱给董事会然后继续经营，或者你可以干脆关门大吉，重新创办一家你真正想做的公司。我认为创始人处于更有利的位置，但他们失去的也更多，约束也更多。但员工们……如果你听了这些并得出结论，很多时候，这里的听众有一半或更多的薪酬是股权，而我们刚刚得出结论，他们的大部分股权可能一文不值。在这种情况下，你愿意接受薪水减半，或者只拿市场价 20% 的薪水工作吗？我的问题是，这看起来非常令人担忧，机会成本实在太高了。

---

### [00:20:19] Lenny

**English:**
An important variable in this framework/piece of advice is product market fit. This might be too big of a question, but just, what tells you that something might have not have product market fit when you're at a company like this? What are signs to you and smoke signals of like, "They may not have product market fit"?

**中文翻译:**
在这个框架/建议中，一个重要的变量是产品市场匹配（PMF）。这可能是一个太大的问题，但在这样的一家公司里，什么迹象会告诉你某个东西可能没有达到 PMF？对你来说，有哪些迹象或信号表明“他们可能没有 PMF”？

---

### [00:20:36] Nikhyl Singhal

**English:**
For me, it's always around this pull that sort of how much work do you have to do to basically generate pull? So right now with OpenAI for example, we're seeing ridiculous pull, but we may not be seeing, for example, massive revenue or profitability. So that's the reason why I tend to feel like you can kind of tell by how hard it is to acquire your users. When companies are putting very little in marketing and there're people coming into the door or there's such an easy sale, you've got it. I think that this sucking pull kind of concept feels like the most appropriate way to define it as opposed to the sort of unit economics of acquisition and time to pay back. There are lots of mathy ways to do it, but early on you can tell how hard are you working to bring people in the door.

**中文翻译:**
对我来说，这总是围绕着这种“拉力”——你基本上需要做多少工作才能产生拉力？比如现在的 OpenAI，我们看到了惊人的拉力，但我们可能还没看到大规模的收入或盈利。这就是为什么我倾向于认为，你可以通过获取用户的难度来判断。当公司在营销上投入很少，却有人源源不断地找上门，或者销售变得非常容易时，你就拥有了 PMF。我认为这种“市场吸力”的概念似乎是定义它最合适的方式，而不是看获客的单位经济效益或回本周期。有很多数学方法可以计算，但在早期，你可以感觉到为了把人领进门你到底有多费劲。

---

### [00:21:32] Lenny

**English:**
Is there any reason to consider staying at a company like this?

**中文翻译:**
有什么理由考虑留在这样的一家公司吗？

---

### [00:21:35] Nikhyl Singhal

**English:**
There are counter examples. I think the counterpoint is, this is the biggest role that you feel like you could get and you have an appetite to sort of learn like, "I'm on the executive team, I'm not going to get that somewhere else. That experience is career additive. I want that moment." Great. Sometimes I see loyalty come in, "This was my baby. I feel a commitment to the team, the team that I've made, et cetera." I actually respect that. I think that you have to put bounds on that. I think that you should have that conversation. But the learning position, the loyalty tend to be the primary reasons to maybe delay the decision, but fear of finding another job is a bad reason, but is an often common reason as well.

**中文翻译:**
也有反例。我认为反向的理由是：这是你觉得能得到的最大的职位，而且你有学习的欲望，比如：“我是高管团队的一员，我在别处得不到这个机会。这段经历对职业生涯有加成。我想要那个时刻。” 太棒了。有时我也看到忠诚度在起作用，“这是我的心血。我对团队有承诺，这是我组建的团队等等。” 我其实很尊重这一点。我认为你必须为此设定界限。我认为你应该进行那样的对话。但是，学习机会和忠诚度往往是推迟决定的主要原因，而害怕找新工作是一个糟糕的理由，但也是一个非常普遍的理由。

---

### [00:22:40] Lenny

**English:**
Now that we've given many listeners an existential crisis, let me move on to another question within the early career phase and then I'm going to move on to mid-career. I guess the question is just, is there any other piece of advice, wisdom for early PMs? Maybe the question is, what do you think they should most get right in their early career?

**中文翻译:**
既然我们已经让许多听众陷入了存在主义危机，让我转到职业早期阶段的另一个问题，然后再转到职业中期。我想问的是，对于早期的 PM，还有什么其他的建议或智慧吗？也许问题应该是，你认为他们在职业生涯早期最应该做对什么？

---

### [00:22:56] Nikhyl Singhal

**English:**
There's probably two answers that I would share. One is, they want to build something that they as much as possible are world-class in. So if you think about the different types of product ambiguities that exist in industry, you can be a great crafter. You could be incredibly strong at market ambiguity. You could understand how to navigate markets and create something new that doesn't exist. You can be great at organizational ambiguity. I know how to take complex teams that have complex goals and solve an inside the building problem. You can be a domain expert. I'm an ML expert, I'm a really strong hardware PM. You can be a team expert. I just really thrive in managing managers and I just know how to get the balance right. So, being a product manager means you're confronted with maybe all five or maybe more of these. I want to know that you pick up one of these as early as possible. So maybe you become an expert in domain, maybe you become a great crafter, maybe you really think through how to manage growth. Growth is another one that I would add to the list. But picking a lane is kind of goal number one. And then maybe goal number two is having a story to tell to that next employer and that next, next. What I worry about is, sometimes when I'm in an interview, and you and I have probably done hundreds, and you're talking to someone and then they talk about those early jobs and they just sort of said they were there, this happened and it's very hard to connect, tell me exactly what you learned and what you did, I want to know that story. So it's just like Amazon talks about building the press release before they start creating a product. Think about the story, think about the skill, then solve your day to day, your week to week, your month to month, your performance review. That's my biggest advice I seize.

**中文翻译:**
我大概会分享两个答案。第一，他们要建立一些自己能尽可能达到世界级水平的东西。如果你思考行业中存在的不同类型的产品模糊性（ambiguities），你可以成为一名伟大的匠人（crafter）。你可以在处理市场模糊性方面非常强大，理解如何驾驭市场并创造出不存在的新事物。你也可以擅长处理组织模糊性，知道如何带领目标复杂的团队解决公司内部的问题。你可以成为领域专家，比如机器学习专家或强大的硬件 PM。你也可以成为团队专家，擅长管理经理并知道如何平衡。作为一名产品经理，意味着你会面临这五种甚至更多的挑战。我希望看到你尽早掌握其中之一。所以，也许你成为了领域专家，也许你成为了伟大的匠人，也许你真正思考了如何管理增长（增长是我要加入清单的另一项）。选择一条赛道是第一目标。第二目标是拥有一个可以讲给下一位雇主以及下下位雇主听的故事。我担心的是，有时我在面试时（你和我可能都面试过数百人），和某人交谈，他们谈到早期的工作，只是说他们在那里，发生了什么，很难联系起来。告诉我你到底学到了什么，做了什么，我想听那个故事。就像亚马逊谈论在开始创造产品之前先写新闻稿一样。思考故事，思考技能，然后再去解决你的日常工作、每周工作、每月工作和绩效评估。这是我对个人贡献者（IC）最大的建议。

---

### [00:25:24] Lenny

**English:**
I love that advice. It connects to your other earlier piece of advice, of just try to get a variety of experiences because that'll help you figure out which of these things is maybe best suited for what you're interested in, what you enjoy doing.

**中文翻译:**
我喜欢这个建议。它和你之前关于尝试多样化经验的建议联系在了一起，因为这会帮助你弄清楚这些事情中哪一个可能最适合你的兴趣和爱好。

---

### [00:25:25] Nikhyl Singhal

**English:**
Yep, absolutely.

**中文翻译:**
是的，绝对如此。

---

### [00:25:26] Lenny

**English:**
Awesome. So let's transition to mid-career. Let's talk about promotions. You mentioned getting promoted earlier. We chatted a bit about that. There's probably no one ever that didn't want to get promoted. It's a common topic in people's career, but a lot of times people don't understand why they're not getting promoted, they're not sure people are looking for to get promoted. You've promoted a lot of people and you've gone through a lot of promotions. What would be your advice to give people who are trying to get promoted and just haven't been promoted? What would you suggest people in that position generally do?

**中文翻译:**
太棒了。让我们转到职业中期。聊聊晋升。你之前提到了晋升，我们也聊了一点。大概没有人不想获得晋升。这是职业生涯中的一个常见话题，但很多时候人们不明白为什么自己没有获得晋升，也不确定别人在寻找什么样的晋升特质。你提拔过很多人，也经历过很多次晋升。对于那些努力争取晋升却一直没能如愿的人，你有什么建议？你会建议处于这种境地的人通常该怎么做？

---

### [00:25:57] Nikhyl Singhal

**English:**
Yeah, it's a great question. I think that we want to kind of understand why, and oftentimes asking your manager won't reveal the answer. So then you'll start with that. I think that the answer of what you do is correlated with what's the real reason. And I think that there may be, I'll suggest four kind of common things I've seen that really hold people back. And then depending on your environment, you have to decide how many of these apply. So I think the number one is that you just don't have advocacy. You need someone to see the magic in you to be promoted. There is many of your listeners who have that magic but maybe have a manager or a promotion team, it doesn't always have to be the manager itself, who doesn't see said magic. And in that case, if you have the magic, you're in a bad setting and you just need to change. That could be a shift within the project. You could find a manager who sees it. It could be leaving the company. I think the second that's very common now, Lenny, and I think it's coming up a ton, is the next role doesn't exist. So this is not as present in hypergrowth because the next role always did exist. There was always growth, there was always hiring, you're always hiring people above you, below you, et cetera. Now, I think there's lots of examples of people who are really qualified and working at the next level, but the job doesn't exist. So you can't really create that job and ask them to be working at that next job if their position is mostly the previous one. Again, I feel like it's not that satisfying because it means you're still being held back, but it's radically different than if you're unqualified. These two are sort of more, the system is not in a position to advocate. The third is when you are being impatient. And I think the hardest ones that I think I've worked with is, the highest performers have succeeded because they have set their goals to be more aggressive than what was essentially average achievable. By default, we expect you to be two years in this role. They're like, "Great, I'll see you in a year." And then they get frustrated when they can't do that, and leadership takes longer to absorb. It's more soft skills, it's more subtle. Oftentimes it's based on impact, which is a lot of times lagging, and that tends to be frustrating. So if listeners are like, "I know I'm used to being promoted annually and now I'm a leader and I'm not moving as quickly, it's time for me to go," I'm like, well, maybe that's working as intended. So impatience is a number three. And then the fourth one I think is about 50% of the cases where it's really, there is a development area but it isn't quite connected to the individual. The listener has a development area, it's substantive. The manager is poor at identifying it, perhaps even doesn't see it, but the promotion committee does, the individual refuses to hear it, which is a very common one. Or they hear it and they just don't want to change it. And they don't do it because they're arrogant, they do it because it's like, "This is who I am. You want me to be X and I'm Y, and that's what a Y is and I don't want to be X." This is the hardest one because this is where coaching and development and self-awareness come in.

**中文翻译:**
是的，这是个好问题。我认为我们需要弄清楚原因，而通常询问你的经理并不能得到真实答案。所以你可以从这里开始。我认为你该怎么做取决于真实原因是什么。我建议关注我见过的阻碍人们进步的四种常见情况。根据你的环境，你需要判断其中有多少条适用。第一，你缺乏支持者（advocacy）。你需要有人看到你身上的“魔力”才能获得晋升。你的听众中有很多拥有这种魔力的人，但可能他们的经理或晋升委员会（不一定是经理本人）没有看到这种魔力。在这种情况下，如果你确实有魔力，那么你处于一个糟糕的环境中，你需要改变。这可能是项目内的调动，寻找一个能看到你魔力的经理，或者是离开公司。第二，这在现在非常普遍，Lenny，我认为它出现得非常多，那就是“下一个职位不存在”。在超速增长时期这不常见，因为下一个职位总是存在的。总是在增长，总是在招聘，你总是在招聘你上面或下面的人。现在，我认为有很多例子表明，人们非常合格且已经在下一级别的水平上工作，但那个职位并不存在。如果他们的职位主要还是前一个，你无法凭空创造那个职位并要求他们在下一个职位上工作。同样，我觉得这不太令人满意，因为这意味着你仍然被阻碍了，但这与“不合格”有着本质的区别。这两点更多是系统无法提供支持。第三是当你表现得不耐烦时。我认为我合作过的最难处理的情况是，那些表现最出色的人之所以成功，是因为他们设定的目标比平均可实现的目标更激进。默认情况下，我们期望你在这个职位上待两年，他们会说：“太好了，一年后见。” 当他们做不到时，他们会感到沮丧。而领导力的吸收需要更长的时间，它更多是软技能，更微妙。通常它基于影响力，而影响力往往是滞后的，这往往令人沮丧。所以如果听众想：“我知道我习惯了每年晋升，现在我是领导者了，我没有动得那么快，是我该走的时候了”，我会说，也许这正是系统设计的初衷。所以不耐烦是第三点。第四点，我认为占了大约 50% 的情况，即确实存在一个发展领域（development area），但个人并没有意识到。听众有一个实质性的发展领域，经理不擅长识别它，甚至可能没看到，但晋升委员会看到了。个人拒绝听取，这非常常见；或者他们听到了，但就是不想改变。他们这样做不是因为傲慢，而是因为：“这就是我。你想让我成为 X，而我是 Y，这就是 Y 的样子，我不想成为 X。” 这是最难的一点，因为这涉及到教练、发展和自我意识。

---

### [00:30:15] Lenny

**English:**
This super resonates. So just to summarize the four reasons you may not be getting promoted: One is, there's no advocate that sees your magic and understands that you're awesome. Two is, there's no actual role that's available and so there's nothing to get promoted to. And that's so true right now, there's just not. Everyone's laying people off, they're getting rid of manager layers. I totally see that all over the place. Three is, you're probably just not being patient. Four, you actually have some work to do and you shouldn't be promoted. Maybe to follow a thread on that first one, if someone doesn't see your magic, I see a lot of people just complaining that like, "Oh, I'm doing so well, I'm so great and nobody understands it. No one gives me credit. No one really appreciates me." I don't know if there is an answer to this, but is there a way to help people see that no, you're actually not doing great versus you are and people just don't see it? What's a sign maybe? Maybe you're not as great as you think you might be.

**中文翻译:**
这超级能引起共鸣。总结一下你没能获得晋升的四个原因：一、没有支持者看到你的魔力并理解你的优秀。二、没有实际可用的职位，所以没法晋升。现在确实如此，到处都在裁员、去管理层。我完全看到了这一点。三、你可能只是不够耐心。四、你确实还有工作要做，不应该被晋升。关于第一点，如果有人没看到你的魔力，我看到很多人只是在抱怨：“噢，我做得这么好，我这么棒，却没人理解。没人给我功劳。没人真正欣赏我。” 我不知道这是否有答案，但有没有办法帮助人们看清：到底是“你其实做得并不好”，还是“你做得很好但别人没看到”？有什么迹象吗？也许你并没有自己想象的那么优秀。

---

### [00:30:41] Nikhyl Singhal

**English:**
The cheap answer is you have to get real feedback, not formal feedback. I think that the more scaled the company is, the more they have these systems in place which provide formal feedback. But honestly, we've run experiments where we said let's ignore the formal feedback, let's have a real conversation with my peers on how our teams are doing. The signal that comes out are dramatically different than the formal feedback. So what you're looking for when you feel like you're in this situation where you're not being seen, and it might be because there's a real issue, what you really want to dial into is, "Let me get the ground truth as to what people are thinking," and you have to have very strong listener skills where we all have been in the discussion, where you're giving feedback to someone and the next thing that they tell you is they justify how you're wrong, that you missed this. "Let me tell you about exactly why that situation that you're using wasn't..." You have to be great at pulling feedback, listening to it. You have to triangulate it from people that don't see you all the time, that do see you all the time, your peers. But you have to create an environment of safety where people feel like there is no worry about retaliation or concern, et cetera. And the more comfortable people are about giving feedback to you and the more you have the skills to pull it and you don't trust formal or you don't trust manager, the better shot you have of truly understanding what that real issue is and solving it.

**中文翻译:**
简单的答案是：你必须获得“真实反馈”，而不是“正式反馈”。我认为公司规模越大，就越会有这些提供正式反馈的系统。但坦率地说，我们做过实验，我们说让我们忽略正式反馈，让我们和同事进行一次关于团队表现的真实对话。出来的信号与正式反馈截然不同。所以当你觉得处于这种“没被看到”的境地时（这可能是因为确实存在问题），你真正想要深入了解的是：“让我了解人们真实想法的真相。” 你必须具备极强的倾听技巧。我们都经历过这样的讨论：你给某人反馈，而他们接下来说的话就是辩解你为什么错了，你漏掉了什么，“让我告诉你为什么你举的那个例子其实不是……” 你必须擅长获取反馈并倾听。你必须从不经常见到你的人、经常见到你的人以及你的同僚那里进行交叉验证。但你必须创造一个安全的环境，让人们觉得不用担心报复或顾虑。人们给你反馈时越感到自在，你获取反馈的技巧越强，且你不迷信正式系统或经理，你就越有机会真正理解那个核心问题并解决它。

---

### [00:32:16] Lenny

**English:**
This reminds me of Jules Walter who's on the podcast. He gave a bunch of advice. I don't know if you saw that. I've had to accept feedback and get people to give you feedback. And one of its pieces of advice is, ask people for real feedback. And no matter how much you're melting inside hearing it, just be like, "Thank you so much for that." Because then, people feel like, "All right, he's listening."

**中文翻译:**
这让我想起了上过播客的 Jules Walter。他给过很多建议，不知道你有没有看过。关于如何接受反馈以及如何让别人给你反馈。他的一个建议是：向人们寻求真实的反馈，无论你听的时候内心多么崩溃，都要表现得像：“非常感谢你告诉我这些。” 因为这样，人们会觉得：“好吧，他在听。”

---

### [00:32:34] Nikhyl Singhal

**English:**
I think Jules is a great, probably one of the world's best people in pulling feedback in my experience. I think that the one that even ones up it is, when I talk to Jules, Jules will look for feedback, then he'll repeat it back to me better than even I presented it. And then I'd say, "Well, let me now feel safer to even provide." Because anyone who's explaining it to a place that they all not only internalize it but they can articulate clearly understands and values it. And that's the really powerful way is, "So what you're saying is I just interrupt far too often and some ways it's almost to a point that it's annoying. Is that a fair assessment?" "Oh, that's actually not the words I use," but that's what really gets people comfortable in sharing with you what's really going on.

**中文翻译:**
我认为 Jules 非常出色，根据我的经验，他可能是世界上最擅长获取反馈的人之一。我认为更进一层的是，当我与 Jules 交谈时，他会寻求反馈，然后他会向我复述一遍，甚至比我表达得还要好。然后我会想：“好吧，我现在感觉更安全了，可以提供更多反馈。” 因为如果有人能把反馈内化并清晰地表达出来，说明他真正理解并重视它。这种真正强大的方式是：“所以你的意思是，我打断别人的次数太频繁了，在某种程度上甚至到了令人讨厌的地步。这个评估公平吗？” 对方可能会说：“噢，其实我没用那个词”，但这正是让人们感到自在、愿意分享真实情况的原因。

---

### [00:33:35] Lenny

**English:**
Amazing. I think we're discovering some of these people that have worked with you that have been on the podcast slowly. Maybe while we're on this topic, I didn't expect to go here, but in terms of other tips for getting good feedback, is there anything else that just comes top of mind of how to get better feedback from people? Because it's hard to do. Most people talk about getting feedback and then don't, or they just don't know how. So one is just, you said repeat back exactly what they told you and be like very appreciative. Is there anything else?

**中文翻译:**
太棒了。我想我们正在慢慢发现一些和你共事过且上过播客的人。也许趁着这个话题，我没预料到会聊到这儿，但关于获取高质量反馈的其他技巧，你脑海中还有什么关于如何从别人那里获得更好反馈的想法吗？因为这很难做到。大多数人谈论获取反馈，但实际上并没有去做，或者只是不知道怎么做。所以，一个是你说过的，准确复述他们告诉你的话并表现得非常感激。还有别的吗？

---

### [00:33:51] Nikhyl Singhal

**English:**
I'd share out feedback. It's a little easier when you are a manager, but for example, most managers that are listening have a staff discussion. Maybe it's sort of awkward, but maybe you have a standup and you are giving notes to people. So as a manager, someone will come to me and they'll give me a piece of feedback. The next Monday when I have my staff meeting, I'll make a comment about something and I'll say, "Well, lot of this came because I got this great piece of feedback from..." and I'll name the person, and I'm like, "It really helped me see this challenge." Now, that feedback could be about me or about this project or about the team. And it might be positive, it might be constructive. People hear that and they're like, "Wow, I get recognized for giving this guy feedback. Sign me up." You're always trying to find way to break down that barrier.

**中文翻译:**
我会公开分享反馈。当你是一名经理时，这会容易一些。例如，大多数正在听节目的经理都有员工会议。也许这有点尴尬，但也许你在站会中给人们做记录。作为经理，有人来找我并给了我一条反馈。下周一我开员工会时，我会对某件事发表评论，并说：“这在很大程度上是因为我从某某人那里得到了一条很棒的反馈……” 我会点出那个人的名字，然后说：“这真的帮我看到了这个挑战。” 那个反馈可能是关于我个人的，也可能是关于项目或团队的。它可能是正面的，也可能是建设性的。人们听到后会想：“哇，我给这家伙反馈还能得到认可。算我一个。” 你总是在试图寻找打破隔阂的方法。

---

### [00:34:55] Lenny

**English:**
I love that tip. You talked about managers and how often managers are not great at managers. Maybe they don't identify development areas, maybe they're bad in other areas. So maybe just a question here of just, why are managers often not great? And then two, if you're a new manager, I think a lot of listeners are maybe transitioning to management or about to transition, what's your advice for being successful as a new manager?

**中文翻译:**
我喜欢这个技巧。你谈到了经理，以及经理们往往不擅长管理。也许他们无法识别发展领域，也许他们在其他方面表现不佳。所以我想问，为什么经理们往往做得不够好？其次，如果你是一名新任经理（我想很多听众可能正在转型或即将转型做管理），你对如何成为一名成功的新任经理有什么建议？

---

### [00:35:12] Nikhyl Singhal

**English:**
I'll start by saying that, in a hundred years when the archeologists look back and they see tech in the sort of early years of tech, the first 34 years, they'll say that the biggest surprise was how much we thought it was okay to not train managers. The military probably didn't make that mistake for very long before they corrected it. And most immature industries really train managers, but boy, if you're a good coder, you are ready to manage. That's the way the industry works. If you can talk, you are ready to product manage. If you can product manage and ship something out the door, you should definitely tell people what to do. I think that there's such a loose coupling between the skills to be successful at building things and teaching people how to build. It's the difference between if you can make a good car, you must know how to make the factory that makes the car. I don't think that's true at all. I think that this is a massive epidemic, that I think there's the thousand challenges that stem from this, whether it's challenges around bias, challenges around enabling coaching and teaching and solving development areas. My hope is that one day as an industry we find ways to improve and fix it. But podcasts like yours are actually quite meaningful steps. I would say that your podcast might be more meaningful than most L&D departments in most organizations today. So that's powerful because you're having a tremendous amount of impact, and I think learning is essentially a lifelong opportunity and I think that is the type of resources that just didn't exist a decade ago. I think to answer your question around what are the common pitfalls, if you're a first time manager listening or maybe someone who's considering it, I think there are probably two quick things that I would say you have to get bravely thoughtful about as you enter into this journey. One is, your challenge is going to be to share the steering wheel with the person or the set of people you are managing. And I think that there's this three modes that people have in their head. They're like, "Oh, management is divide and conquering. You go there, I go there, we meet up." Or they'll say it's like riding a bike, or teaching to ride a bike, I should say. Someone starts out on the bicycle, I hold your hand, I let go, and then I hope that you fly. I think it's more like the sidecar on the motorcycle, where person's driving the motorcycle and I'm on the sidecar and whether I like it or not, I'm attached, but I have this relatively specific role of giving counsel. I think that that model of how do you share the steering wheel, not just say you got it or I got it or I got it for a while, and then I hand it to you is the key question. And then I think that the second miss that people tend to have is they tend to, because they have power, by the way, organizational power, not because they've earned that power, they start managing whatever they define that to be. And what I find is that you're more like the vampire knocking on the door of someone. You have to be invited in. You just can't walk through the threshold. And I think that no matter how senior the person that is the manager, you have to earn the right to be the person's manager. So maybe to be specific, well, if I start managing someone, the thing I'd like to understand is like, "Hey, well, what can I help you with?" And they can invite me in. Oftentimes, the answer is, "I don't need you. I actually wasn't excited about you as a manager. I don't need another layer between you and the CEO. Get out." And I'm like, "That's cool," because anything I say after that is just going to be annoying and it's going to backfire. Now, one day they will need help, and I will be in the sidecar waiting to say, "Perhaps I can assist." And then when you finally get to that moment where you're invited in, you pick an area or two, and then you really partner with that person on that area. I can give examples on that, but I generally think that it's this invitation picking specific and then making sure we're sharing the responsibility is the key set of notes that I would share with you.

**中文翻译:**
首先我想说，一百年后当考古学家回顾科技行业的早期阶段（前 34 年）时，他们会说最大的惊讶在于，我们竟然认为不培训经理是可以接受的。军队可能在纠正这个错误之前并没有犯太久。大多数不成熟的行业都会认真培训经理，但天哪，如果你是个好程序员，你就准备好管理了。这就是这个行业的运作方式。如果你能说会道，你就准备好做产品管理了。如果你能做产品管理并把东西发布出去，你就绝对应该告诉别人该做什么。我认为，成功打造产品的技能与教别人如何打造产品的技能之间，耦合度非常低。这就像是“如果你能造出一辆好车，你就一定知道如何建造造车的工厂”之间的区别。我认为这根本不对。我认为这是一个巨大的流行病，由此产生了成千上万的挑战，无论是关于偏见的挑战，还是关于赋能教练、教学和解决发展领域的挑战。我希望有一天，作为一个行业，我们能找到改进和修复它的方法。但像你这样的播客实际上是非常有意义的步骤。我会说，你的播客可能比当今大多数组织中的大多数学习与发展（L&D）部门更有意义。这很强大，因为你产生了巨大的影响。我认为学习本质上是一个终身的机会，而这种资源在十年前是不存在的。回答你关于常见陷阱的问题，如果你是第一次做经理的听众，或者正在考虑做经理，我想在你开启这段旅程时，有两件事你必须勇敢地去思考。第一，你的挑战将是与你管理的人或团队“共享方向盘”。人们脑子里通常有三种模式。他们会想：“噢，管理就是分而治之。你去那儿，我去这儿，然后汇合。” 或者他们会说这就像骑自行车，或者确切地说是教骑自行车。有人开始骑车，我扶着你的手，然后放开，希望你能飞驰。我认为它更像是摩托车的侧车（sidecar），那个人在开摩托车，而我在侧车里，不管我喜不喜欢，我都连在一起，但我有一个相对特定的角色，那就是提供建议。如何共享方向盘，而不是简单地说“你行了”或“我来做”或“我先做一会儿再交给你”，这是关键问题。第二点，人们往往会因为拥有权力（顺便说一下，是组织赋予的权力，而不是因为他们赢得了这种权力）就开始按照他们定义的管理方式去管理。我发现你更像是敲门的吸血鬼。你必须被邀请进去，不能直接跨过门槛。我认为无论经理的级别有多高，你都必须赢得成为某人经理的权利。具体来说，如果我开始管理某人，我想了解的是：“嘿，我能帮你什么？” 他们可以邀请我。通常答案是：“我不需要你。我其实对你当我的经理并不兴奋。我不需要在你和 CEO 之间再加一层。走开。” 我会觉得：“没关系”，因为在那之后我说的任何话都会让人讨厌，并且会适得其反。总有一天他们会需要帮助，而我会坐在侧车里等着说：“也许我可以帮忙。” 当你最终被邀请进去时，你选择一两个领域，然后在这些领域与那个人真正建立伙伴关系。我可以举例说明，但我通常认为，这种“受邀进入、选择特定领域、确保共担责任”是我要分享的关键点。

---

### [00:39:51] Lenny

**English:**
What's your take on the IC path, senior IC path, something that a lot of companies talk about? I know Meta is big on this right now, the layering managers and things like that. I find a lot of times there's a lot of talk about it and there's not really a real career opportunity there. I guess, what's your just take on as that is a real option for most people trying to basically avoid the manager out and staying in IC, PM long term?

**中文翻译:**
你对 IC（个人贡献者）路径、资深 IC 路径怎么看？很多公司都在谈论这个。我知道 Meta 现在非常重视这一点，比如减少管理层级之类的。我发现很多时候大家都在谈论它，但并没有真正提供真实的职业机会。我想知道，对于大多数想要避开管理岗、长期留在 IC 岗位的 PM 来说，这是否是一个真实的选择？

---

### [00:40:17] Nikhyl Singhal

**English:**
Yeah, I think that it's a little bit more acute now because of the backlash that we talked about between growth where management was perceived. So in this case, management was perceived as a way to drive expansion. So if you're in charge of expansion, you're managing the people that are doing the build and now we're doing a lot fewer things. So I think that's what's mandated this sort of growth in the IC track, for lack of a better term. I think it is one of the best things that happened to our industry because what's happened is, in the last 10 years, and you can tell I'm particularly hard on our managers here, they've basically been promising ICs that early promoted into management. They didn't get taught, and now they're sort of average managers and promising ICs. But now the story that they tell and what they've built is not awesome. If I'm looking to hire, if I'm in a growth company and I'm the next hottest thing and I'm looking to hire someone and someone walks into the interview and said, "Look, I've managed two people before and then I was in the charge of this thing, but they really did the details. And then by the way before that, I was early in trying to get this thing out the door and then they picked me to be manager," I'm like, "Okay, that's an interesting set of experiences. I'm looking, for me, in my company to build something." The next person walks in, it's like, "I've been an IC for that whole time. And during that time I went from learning something to demonstrating it to really being able to take it forward. And I got one of these ambiguities master. I'm an expert in domain. I'm an expert in managing organizations," I'm like, "I don't need a team ambiguous expert. That's not my hard part. My hard part is actually cracking the code on this complex market or this very complicated organization where we have two teams that have different goals. You're the type of person I want." So I think Lenny, to your question, I think the IC track is one of the best things that's going to happen for people career. But to your point, those tracks, from a promotion and from a industry, how we perceive it, they're not in cement yet. They're tender. You wait six months, you wait nine months, they'll become very, very strong and solid. And I think then, we'll be able to lean very hard into them as a real promising crack for builders.

**中文翻译:**
是的，我认为现在这个问题变得更加尖锐，因为我们谈到的增长与管理认知之间的反弹。在这种情况下，管理被视为推动扩张的一种方式。如果你负责扩张，你就在管理那些负责构建的人，而现在我们做的事情少了很多。所以，我认为这就是促使 IC 赛道（暂且这么称呼）增长的原因。我认为这是我们行业发生的最好的事情之一。因为在过去的 10 年里（你可以看出我对经理们特别严厉），他们基本上是把有前途的 IC 过早地提拔到了管理岗位。他们没有接受过培训，现在他们成了平庸的经理和曾经有前途的 IC。但现在他们讲的故事和他们建立的东西并不出色。如果我要招聘，如果我身处一家成长型公司，是下一个最热门的公司，我想招人，有人走进面试间说：“看，我以前管理过两个人，然后我负责这件事，但细节其实是他们做的。顺便说一下，在那之前，我早期尝试把这个东西推向市场，然后他们选我当了经理。” 我会觉得：“好吧，这是一组有趣的经历。但我是在我的公司里寻找能真正构建东西的人。” 下一个人走进来，说：“我一直都是 IC。在那段时间里，我从学习某件事到证明它，再到真正能够推动它向前发展。我掌握了其中一种模糊性。我是领域专家。我是管理组织的专家。” 我会觉得：“我不需要一个处理团队模糊性的专家。那不是我的难点。我的难点实际上是破解这个复杂市场的密码，或者是这个非常复杂的组织，我们有两个目标不同的团队。你就是我想要的那种人。” 所以 Lenny，回答你的问题，我认为 IC 赛道是职业生涯中发生的最好的事情之一。但正如你所说，从晋升和行业的角度来看，这些赛道还没有完全定型。它们还很稚嫩。再等六个月、九个月，它们会变得非常非常强大和稳固。我认为到那时，我们将能够非常坚定地依靠它们，作为建设者们真正有前途的突破口。

---

### [00:43:00] Lenny

**English:**
Your sense is, this is going to become more and more real as these layoffs have happened and kind of pullbacks on growth have happened.

**中文翻译:**
你的感觉是，随着裁员的发生和增长的收缩，这将变得越来越真实。

---

### [00:43:00] Nikhyl Singhal

**English:**
Yeah, I mean, if you think about it, it's the reality in engineering and design. So in engineering, you can be the sort of VP of engineering or CTO, and in a design, a lot of designers become design managers, a lot of them stay as crafters. And then for whatever reason in product managers, maybe because they were managers in our title, we just all became managers. What about the product? What about the other side? So I actually think it's a bug that has existed for a long time that actually we're going to correct permanently now.

**中文翻译:**
是的，我的意思是，如果你想想看，这在工程和设计领域已经是现实了。在工程领域，你可以是工程副总裁或 CTO；在设计领域，很多设计师成为设计经理，很多则留下来做匠人。但出于某种原因，在产品经理中，也许是因为我们的头衔里就有“经理”二字，我们全都变成了经理。那产品怎么办？另一面怎么办？所以我实际上认为这是一个存在已久的 Bug，我们现在要永久地修复它。

---

### [00:43:33] Lenny

**English:**
I wonder if part of it for PMs is, once you become a manager, this happens to me, I didn't want to be an IC anymore. It's like, "I'm done with that. I really enjoy this management layer." And I imagine with engineers, maybe they'll enjoy the coding. When I was an engineer I was like, "Oh, I don't want to just sit around and manage. I just want to code." So I wonder if there's any part of that.

**中文翻译:**
我在想，对于 PM 来说，是否有一部分原因是，一旦你成为了经理（我就是这样），我就不想再做 IC 了。就像是：“我做够了那个。我真的很享受这个管理层级。” 而我猜对于工程师来说，也许他们更享受写代码。当我还是工程师时，我想的是：“噢，我不想只是坐着管理，我只想写代码。” 所以我在想是否也有这方面的原因。

---

### [00:43:52] Nikhyl Singhal

**English:**
But a lot of your listeners like to build. And actually, when they talk to their managers, they're like, "I don't know if that job is awesome. It feels like you spend all your time writing docs and telling your boss's boss what to justify resources and headcount. I just want to build stuff. You don't build stuff." So I think there might be some of that. I think that it's not perfect, but I think hopefully builder and IC will become more synonymous.

**中文翻译:**
但你的很多听众喜欢构建。实际上，当他们和经理交谈时，他们会想：“我不知道那份工作是否很棒。感觉你把所有时间都花在写文档和告诉你老板的老板如何证明资源和猎头的合理性上。我只想构建东西。你又不构建东西。” 所以我认为可能也有这方面的原因。我认为这并不完美，但我希望“建设者”和“IC”能变得更加等同。

---

### [00:44:19] Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to waste of time building internal tools or trying to run your own experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more, delivering results quickly, avoiding knowing prolonged analytic cycles, and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic, click-through metrics and instead use your North Star metrics like activation, retention, subscription, and payments. Eppo supports test on the front end, on the back end, email marketing, even machine learning claims. Check out Eppo at geteppo.com. That's get eppo.com. And 10X your experiment velocity.

**中文翻译:**
本集由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。DraftKings、Zapier、ClickUp、Twitch 和 Cameo 等公司都依靠 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有能与现代增长团队技术栈集成的商业工具。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。当我在 Airbnb 时，我最喜欢的事情之一就是我们的实验平台，我可以在那里按设备类型、国家、用户阶段对数据进行切片分析。Eppo 实现了这一切甚至更多，它能快速交付结果，避免漫长的分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习方案的测试。请访问 geteppo.com 查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:45:27] Lenny

**English:**
Coming back to the manager life and how many managers are not great and also just how do you get better as a manager, what have you found actually is effective in helping new managers become better?

**中文翻译:**
回到经理生活，以及有多少经理做得不够好，还有如何成为更好的经理。你发现什么方法能有效帮助新任经理变得更好？

---

### [00:45:37] Nikhyl Singhal

**English:**
I think I may have come across kind of hard on managers and I think I kind of said, "Hey, your manager and your manager's manager isn't really doing much teaching. Find the right podcast, good luck." And I think that that's a pretty soulless answer. So maybe the way I describe it is, well, I think learning is changing, and there's the self-service tools that are getting better and then there's the structured teaching which I think is weak. And then there's community, which I think whether it's within your company or outside of company, I think is the answer that we'll see more and more. I think community as a way of creating safety, having authentic conversations, feeling that you're not alone, that others are going through the same thing, and then sharing best practices is so powerful. And what social software has done is it has really empowered community. And now the tools are awesome. How many great communities have Slack channels or Discord channels or Zoom calls? And we do a lot of that in the CPO community that I created. Whether you're a new manager or whether you belong to a diverse group, whether you are new to a company, I think that all of your listeners should be part of an active community where they can be very authentic and very safe. Sometimes it's hard to do that with your coworkers, and so you need to find another community. Unfortunately, those communities are not the easiest to find today, but I believe that the notion of community as a powerful propellant for learning is the critical ingredient and hopefully many people are creating these communities so that new managers can find the right services.

**中文翻译:**
我想我对经理们可能表现得有点严苛，我好像在说：“嘿，你的经理和你经理的经理其实没教你什么。找个合适的播客听听吧，祝你好运。” 我觉得那是个挺没灵魂的回答。所以也许我该这样描述：我认为学习方式正在改变。自助服务工具正在变得更好，而我认为结构化教学目前还很薄弱。然后是社区，我认为无论是在公司内部还是外部，社区都是我们将越来越多看到的答案。我认为社区作为一种创造安全感、进行真实对话、让你觉得不孤单（别人也在经历同样的事情）并分享最佳实践的方式，是非常强大的。社交软件的发展真正赋能了社区。现在的工具非常棒。有多少优秀的社区拥有 Slack 频道、Discord 频道或 Zoom 通话？在我创建的 CPO 社区中，我们就经常这样做。无论你是一名新任经理，还是属于某个多元化群体，亦或是刚加入一家公司，我认为所有的听众都应该成为一个活跃社区的一员，在那里他们可以表现得非常真实且感到非常安全。有时很难与同事做到这一点，所以你需要寻找另一个社区。不幸的是，这些社区在今天并不容易找到，但我相信，社区作为学习的强大推进器是关键要素。希望有更多人创建这些社区，让新任经理能找到合适的服务。

---

### [00:47:40] Lenny

**English:**
Can you actually talk about this community that you've built? This could be a good time to talk about it. It's called The Skip. Is that right?

**中文翻译:**
你能谈谈你建立的这个社区吗？现在是个好时机。它叫《The Skip》，对吗？

---

### [00:47:45] Nikhyl Singhal

**English:**
Yeah. It's funny, it's all kind of fun products. They were always a reaction to something. They weren't really intentional. I, as you opened the podcast, did really enjoy teaching and coaching. I learned just as much from coaching others as they learned, I think. And yet I couldn't really scale. So I had this summer where I had just come off of being a head of product, and more and more of my people I was talking to were also head of products. What would happen is, I would have these conversations and they would ask me a question. I would say, "Well, that's the same conversation I answered on Tuesday." What you realize is, it's a very lonely job. Being lonely at the top is not just an adage. Really, everyone's so busy now. It's like, how do you have time to connect? Everything's a single player, you don't really have community. So I thought, "Well, what if I took the half a dozen people I talked to this month?" And I just said, "Hey, all of you are all interested in talking through how to navigate this crazy world of year one, year two, chief product officer. I think you would really gain. I know all of you and I think you can be safe with one another. Why don't we spend some time together?" So we did a WhatsApp channel and we brought a Zoom call. This was during the pandemic, so you really couldn't meet up. And we started talking. We started talking every month, and people were so empowered by the fact that the problem they were hitting was not just them. It was, "My crazy CEO is telling me this." And the next person is like, "Oh yeah? Let me tell you what my person said." And then they would say, "Oh my gosh, that sounds worse than my situation." But then, we would sit down and say, "Hey, the third person said I actually kind of had this and now I figured out a way out, and here's what I did." And you're like, "Wow, that's amazing. I'm going to try it." The next day they come back, they're like, "It works." And we started to connect and we built this trust, and community building is interesting and powerful work. So six went to 12, and then 12 went to 15, and now we have 28 members. A lot of folks are interested in these types of communities, but I'm so worried about scaling it because it's the enemy of trust and authenticity. So for all of you that are building communities, it's like tree balancing act. But I do think that the goal is to find ways to take all of this sort of like-minded folks that are in these same situations and connect them together. Late stage chief product officer happened to be one of the ones that had some of the most substantial importance to me because of all the coaching I did for that group.

**中文翻译:**
是的。很有趣，这些都是好玩的产品。它们总是对某种情况的反应，并非刻意为之。正如你在播客开头所说，我确实非常享受教学和教练工作。我认为我从指导别人中学到的东西和他们学到的一样多。然而，我无法真正规模化。那个夏天我刚卸任产品负责人，我交谈的人中越来越多也是产品负责人。情况往往是，我进行这些对话，他们问我一个问题，我会说：“好吧，这和我周二回答的问题一模一样。” 你会意识到，这是一份非常孤独的工作。“高处不胜寒”不仅仅是一句谚语。真的，现在大家都太忙了。你怎么有时间去联系？一切都是单打独斗，你没有真正的社区。所以我心想：“如果我把这个月聊过的半打人聚在一起呢？” 我说：“嘿，你们都对如何度过首席产品官（CPO）第一年、第二年的疯狂世界感兴趣。我认为你们会大有收获。我认识你们所有人，我认为你们在一起会感到安全。我们为什么不花点时间聚聚？” 于是我们建了一个 WhatsApp 频道，开了一个 Zoom 会议。那是大流行期间，所以没法见面。我们开始聊天。我们开始每个月聊天，人们感到非常有力量，因为他们发现遇到的问题不只是他们自己。有人说：“我那个疯狂的 CEO 跟我说这个。” 另一个人说：“噢是吗？让我告诉你我的 CEO 说了什么。” 然后他们会说：“天哪，那听起来比我的情况还糟。” 但接着，我们会坐下来，第三个人会说：“嘿，我其实也遇到过这种情况，现在我找到了解决办法，我是这么做的。” 你会觉得：“哇，太棒了。我要试试。” 第二天他们回来，说：“有效。” 我们开始建立联系，建立了信任，社区建设是一项有趣且强大的工作。所以 6 个人变成了 12 个，12 个变成了 15 个，现在我们有 28 个成员。很多人对这类社区感兴趣，但我非常担心规模化，因为规模是信任和真实性的敌人。所以对于所有正在建立社区的人来说，这就像平衡木。但我确实认为，目标是找到方法，将所有这些处于相同境地的志同道合的人联系在一起。后期阶段的首席产品官社区恰好是对我最重要的社区之一，因为我为那个群体做了大量的教练工作。

---

### [00:50:35] Lenny

**English:**
If someone's listening and they're like, "Oh, I need to join this thing," how do they find out about it? How do they potentially apply and try to join?

**中文翻译:**
如果有人在听，并且想：“噢，我需要加入这个组织”，他们该如何了解它？他们如何申请并尝试加入？

---

### [00:50:41] Nikhyl Singhal

**English:**
Well, we have enough members now. There's a LinkedIn area called The Skip CPO Community, and you should contact any of the members that you know and ask them to join. My request and my requirement is that they are, number one, product leaders in their organization and a company that's not early, but that's mid to late. And the reason being is, those sets of problems tend to be the most similar. To be honest, I think this is not the only community that I want to be part of and help create, but this one happens to be the preexisting one. I think there are lots of powerful communities that can be created, but this particular one is very much focused on The Skip CPOs.

**中文翻译:**
嗯，我们现在的成员已经够多了。LinkedIn 上有一个叫“The Skip CPO Community”的板块，你应该联系你认识的任何成员并请求加入。我的要求是：第一，他们必须是组织中的产品领导者，且公司不是早期初创公司，而是中后期公司。原因在于，这些公司面临的问题往往最相似。老实说，我认为这不是我唯一想参与和帮助创建的社区，但这个是已经存在的。我认为可以创建很多强大的社区，但这个特定的社区非常专注于“The Skip CPO”。

---

### [00:51:28] Lenny

**English:**
Awesome. I'll mention the community around my newsletter just so folks are looking for a community join. I try not to promote these sorts of things, but it's a good time, may as well. If you're a paid subscriber to my newsletter, there's a Slack community you get access to. There's about 12, 13,000 people in there. There's meetups happening all over the world every month. It's amazing. Very proud of it. People are getting a lot of value of it, and it's basically open to any level of product manager. Other functions are in there too. So it's a very different sort of experience, but willing to add that also in the show notes if you want to check that.

**中文翻译:**
太棒了。我也提一下我时事通讯周围的社区，以防有人在寻找可以加入的社区。我尽量不推销这类东西，但现在是个好时机，不妨说一下。如果你是我时事通讯的付费订阅者，你可以加入一个 Slack 社区。那里大约有 1.2 到 1.3 万人。每个月世界各地都会举行线下聚会。这很棒，我为此感到自豪。人们从中获得了很多价值，它基本上对任何级别的产品经理开放。其他职能部门的人也在里面。所以这是一种非常不同的体验，如果你想查看，我也愿意把它放在节目笔记里。

---

### [00:51:59] Nikhyl Singhal

**English:**
I think that that would be my put, because so many of the managers will say, "Hey, I'm an IC," here's a greater one, "I am not being told I have the next job. I just was told to become an IC and I was a manager. I feel like my learning opportunities are stuck, but this is a bad time to look for a job." They should be in your community. They will learn more from that community than they will learn from managing one random person that they were attached to managing in some project that may or may not see the light of day, yet that's how our society is programmed. Our industry is like, "No, no, go manage that person because that's going to make you closer to the top. Forget learning." And I'm like, "Well, learning isn't happening. Learning's happening in your community. Learning is happening in our communities in general." That's why I'm pushing so hard on this.

**中文翻译:**
我认为那是我的建议，因为很多经理会说：“嘿，我是 IC”，还有一个更典型的：“没人告诉我我有下一份工作。我刚被告知要转为 IC，而我以前是经理。我觉得我的学习机会停滞了，但现在又不是找工作的好时机。” 他们应该加入你的社区。他们从那个社区学到的东西，比管理某个可能永远见不到天日的项目中的某个随机分配的人要多得多。然而，我们的社会就是这样设定的。我们的行业就像在说：“不，不，去管理那个人，因为那会让你离顶峰更近。忘掉学习吧。” 而我会说：“学习并没有发生。学习发生在你的社区里。学习普遍发生在我们的社区里。” 这就是为什么我如此努力地推动这件事。

---

### [00:52:54] Lenny

**English:**
This is a good segue to talking about the third bucket, which is kind of later career CPOs. That's the segue in my mind there. Something that I've heard you talk about is that a lot of really senior leaders have real development areas, but they're hiding behind these superpowers that they have. Plus, people don't like to give real feedback to senior people. So I'd love to hear just what you're seeing there and how maybe people can work through that and what we can learn about that issue that you've noticed.

**中文翻译:**
这是一个很好的过渡，可以谈谈第三个范畴，即职业后期的 CPO。这是我脑海中的过渡点。我听你谈到过，很多非常资深的领导者都有真实的发展盲区，但他们躲在自己拥有的“超能力”后面。此外，人们不喜欢给资深人士提供真实的反馈。所以我很想听听你在那里看到了什么，以及人们可能如何解决这个问题，还有我们可以从你注意到的这个问题中学到什么。

---

### [00:53:27] Nikhyl Singhal

**English:**
This came from my notes as I was talking to a therapist on this. They talked about the shadows of superpowers. And I thought it was an incredibly powerful phrase that everyone focuses on your superpowers, but no one ever thinks about what shadows they create. Shadows of superpowers to me is the story of a lot of executives. There's an adage that's thrown around, which is, what gets you there isn't what got you here. It's sort of the tools that have made you successful today, you need to almost rebuild or relearn to get to the next phase. And I think both of these sort of speak to the same point, that oftentimes people have a great superpower. They go into a performance review, person says, "You're getting some feedback from your peers that you struggle in collaboration." And the manager even sometimes is puzzled, but the individual will say, "Are you kidding me? My last five performance reviews told me that I was one of the best collaborators in the company. How in the world is that possible?" And then what you realize is that, "Well, you're collaborating as long as people agreed with your point of view. Now as a leader, we're asking you to be opinionated, and because you just think you're an amazing collaborator using the exact same tool set. And it turns out that when you're dealing with senior people, that may not even be in your function, they may not be product, they may not be tech, they recoil, but you're moving so fast because it's your superpower. You would never think that this needs to be rebuilt." Sometimes it could be more extreme. Great collaborators sometimes are very reticent to present their own opinions because they're so good at assimilating others. Or people that are amazing at growth struggle to be innovative. People that are world-class storytellers struggle to get in the details. People that are very taste maker, they are always the first to have point of view. They don't necessarily introduce change particularly often. You're strong politically, but your decisions are unprincipled. You're a structured thinker, but blue-sky innovations are very tough. You're an amazing listener, but you're very weak to be decisive. I can go on forever. And what I would say to you is, sometimes even in a 30-minute conversation, walking into the room, just knowing what I know about the person, I can unlock their development area faster than anyone ever before, simply because my secret is, I'll bet you, because of this person's world-class here, these are the three things they're going to hit. And they don't even realize it because it's their identity. This is what got me here. If you make me work on that, you will make me change my superpower. And I'm like, "That's why you're stuck. That's why your career is plateauing." And then they get sad and then they take a long time to process, and then the work actually begins and then they solve and they go. Almost everyone, once they have the name and the face, they're able to solve. But facing the name is hard when it's sitting in the shadows of superpowers.

**中文翻译:**
这源于我与一位治疗师交谈时的笔记。他们谈到了“超能力的阴影”。我觉得这是一个非常有力量的短语：每个人都关注你的超能力，但没人思考这些超能力会产生什么样的阴影。对我来说，超能力的阴影是许多高管的故事。有一句谚语流传很广：“带你到达那里的东西，并不能带你到达这里。” 也就是说，让你今天成功的工具，你几乎需要重新构建或重新学习才能进入下一个阶段。我认为这两点都说明了同一个问题：通常人们拥有强大的超能力。他们去参加绩效评估，有人说：“你的同事反馈说你在协作方面有困难。” 经理有时甚至也感到困惑，但当事人会说：“开玩笑吧？我过去五次的绩效评估都说我是公司里最擅长协作的人之一。这怎么可能？” 然后你会意识到：“好吧，只要别人同意你的观点，你就在协作。现在作为领导者，我们要求你有主见，而你只是认为自己在使用同样的工具集做一个了不起的协作者。结果发现，当你面对资深人士时（他们甚至可能不在你的职能部门，不是产品或技术人员），他们会退缩，但你因为超能力而行动太快。你永远不会想到这需要重新构建。” 有时情况可能更极端。伟大的协作者有时非常不愿表达自己的意见，因为他们太擅长吸收别人的意见了。或者擅长增长的人很难创新。世界级的故事讲述者很难深入细节。非常有品味的人（taste maker）总是第一个提出观点，但他们不一定经常引入变革。你政治手腕很强，但你的决定没有原则。你是结构化思维者，但天马行空的创新对你来说很难。你是一个了不起的倾听者，但你很难果断。我可以一直说下去。我想告诉你的是，有时甚至在 30 分钟的谈话中，走进房间，仅仅根据我对这个人的了解，我就能比以往任何人都更快地解锁他们的发展盲区。原因很简单，我的秘密是：我敢打赌，因为这个人在某方面是世界级的，他们肯定会遇到这三件事。而他们甚至没有意识到，因为那是他们的身份。这就是带我来到这里的原因。如果你让我改进那个，你就是在让我改变我的超能力。而我会说：“这就是你被困住的原因。这就是你职业生涯停滞不前的原因。” 然后他们会感到难过，需要很长时间来消化，接着工作真正开始，然后他们解决了问题并继续前进。几乎每个人，一旦给问题命名并看清它的面目，都能解决它。但当它坐在超能力的阴影里时，面对它很难。

---

### [00:57:08] Lenny

**English:**
Wow. That is an incredibly important point. For someone to recognize this, do you find that they need someone like you that's like a coach, mentor, person to come in, and be like, "Here's what I see"? Or is there a way, I guess, as someone that's a peer or an employee to help them recognize this without them shutting down and being like, "No, shut up. No problem'?

**中文翻译:**
哇。这是一个极其重要的观点。为了让某人意识到这一点，你觉得他们是否需要像你这样的人（教练、导师）介入并说“这就是我看到的”？或者，作为同僚或下属，有没有办法帮助他们意识到这一点，而不会让他们关上心扉说“不，闭嘴，没问题”？

---

### [00:57:28] Nikhyl Singhal

**English:**
No, you don't need a coach. What you do need is to listen to contradictory feedback. So what was the premise here is you're being told that something that you hold as your strength is actually in your way or a development area. Do not dismiss that. Recognize most likely you're doing it correctly. You just have gotten to the next level. So what I'm hoping the listener does is it goes back through all the feedback that they may even have and then looks at all the discard stuff. What's on the discard pile? Things that were discarded are anomalies because they're artifacts of my strength. And often, your managers are the ones that do the discarding, "Oh, that was just a weird... That person, they were just into it. They have it out for you. They got reorged or they were upset." I'm like, "No, no, no, no, no, no, no, no. Perception's reality. Talk to me about that one. That might be it." That's what I'm looking for.

**中文翻译:**
不，你不需要教练。你需要的是倾听“矛盾的反馈”。这里的前提是，有人告诉你，你认为的优势实际上阻碍了你，或者是一个发展盲区。不要忽视它。要意识到，很可能你做得是对的，只是你已经到了下一个级别。所以我希望听众做的是，回顾他们收到的所有反馈，然后看看那些被“丢弃”的东西。丢弃堆里有什么？那些被丢弃的东西被认为是异常情况，因为它们是我优势的副产品。通常，你的经理是那些负责丢弃的人，“噢，那只是个奇怪的……那个人，他们只是太投入了。他们针对你。他们被重组了或者他们不高兴。” 我会说：“不，不，不。认知即现实。跟我聊聊那条反馈。那可能就是关键。” 这就是我所寻找的。

---

### [00:58:29] Lenny

**English:**
Fascinating. This makes me think about companies that have the same issue, companies strengths, like say Meta for example, move fast and break things and then, "Oh, that ends up being the biggest Achilles' heel." Uber, similar. Airbnb has similar challenges like that.

**中文翻译:**
太迷人了。这让我想起那些有同样问题的公司，公司的优势，比如 Meta，“快速行动，打破常规”，然后，“噢，那最终成了最大的阿喀琉斯之踵。” Uber 也是如此。Airbnb 也有类似的挑战。

---

### [00:58:43] Nikhyl Singhal

**English:**
Absolutely. This exact thing applies to relationships. This applies to companies, this applies to a lot. And I'm so happy that I was able to learn about it. Frankly, it was a critical unlock for me because I was stuck on something for years and I just could not understand how, for me, it was, I was very opinionated about something. And then I realized being loosely held on my opinions didn't mean that I became a weaker executive, but it was my opinions that got me to be so successful and it required me to rewire who I was as an executive. And that took a lot of time and a lot of energy. But it came from this realization and then I started to apply it for other strength areas. And now, every time I have a strength area of myself for those that I coach, I immediately talk through all the things that I bet you exist and most of the time were right.

**中文翻译:**
绝对如此。这同样适用于人际关系。适用于公司，适用于很多事物。我很高兴我能学到这一点。坦率地说，这对我来说是一个关键的突破，因为我曾被某件事困扰多年，我就是无法理解。对我来说，那是关于我对某件事非常有主见。后来我意识到，“不坚持己见”并不意味着我变成了一个软弱的高管，但正是我的主见让我如此成功，这需要我重新构建我作为高管的身份。这花费了大量的时间和精力。但它源于这种认知，然后我开始将其应用于其他优势领域。现在，每当我面对自己或我指导的人的优势领域时，我都会立即讨论我敢打赌存在的那些问题，而且大多数时候都是对的。

---

### [00:59:46] Lenny

**English:**
So what is it for you that you said was your superpower and your shadow?

**中文翻译:**
那么对你来说，你所说的超能力和阴影是什么？

---

### [00:59:50] Nikhyl Singhal

**English:**
I think that I was, as an entrepreneur, very opinionated about using small amounts of information to make decisions. And then I was very good at driving those things. So when you become an entrepreneur, you're great at grit, you're great at opinion, you're great at being decisive. And then as an executive, you spend a lot of time making sure everyone has context, everyone is heard, your opinions are actually edited for good reason. And it's not just to placate, it's actually to improve. But as someone who's basically been right a lot, that requires almost a complete and you're like, "Well, that's not who I am." And I'm like, "Okay, you start with the sentence like that's not who I am." You're definitely doing it right when you hit your leadership.

**中文翻译:**
我认为，作为一名企业家，我非常坚持利用少量信息来做决定。然后我非常擅长推动这些事情。所以当你成为一名企业家时，你擅长坚韧、擅长表达观点、擅长果断。但作为一名高管，你要花很多时间确保每个人都有上下文，每个人都被倾听，你的观点实际上是为了好的理由而被修正的。这不仅仅是为了安抚，实际上是为了改进。但作为一个基本上经常正确的人，这几乎需要彻底的转变，你会觉得：“好吧，那不是我。” 而我会说：“好吧，当你用‘那不是我’这句话开头时，说明你在领导力方面确实做对了。”

---

### [01:00:40] Lenny

**English:**
What was the process like for you to work through that? You said it took a long time. What made it effective for you? Was there a coach involved? Something else?

**中文翻译:**
你解决那个问题的过程是怎样的？你说花了很长时间。是什么让它对你有效？有教练参与吗？还是别的什么？

---

### [01:00:49] Nikhyl Singhal

**English:**
I got a lot of setback. I get a lot of negative feedback. I had a lot of abrupt challenges at work where folks would say, "You're not collaborating well. Your peers don't have the same level of respect as they should." And I was like, "Are you kidding me? That's not who I am. These things that are being said about are completely ironic." I was very much struggling and that's when I said, "You know what? I can struggle and blame others, but what if they were right? I'm going to be doing this for 30 more years, it's kind of worth it to figure out if they're right. If they're wrong, then you don't lose." And that's what kind of forced it. And then the tooling starts, then you start talking through. My self-awareness was strong enough that I was able to say, "Okay, now I understand it." I had some peer feedback that helped bring it home from someone I trusted. So that was a kind of linchpin to this, but these are tough, tough things to break through. And oftentimes they don't come nicely, I guess, is the point.

**中文翻译:**
我遇到了很多挫折。我收到了很多负面反馈。我在工作中遇到了很多突如其来的挑战，人们会说：“你协作得不好。你的同事对你没有应有的尊重。” 我当时想：“开玩笑吧？那不是我。这些说法完全是讽刺。” 我当时非常挣扎，就在那时我说：“你知道吗？我可以继续挣扎并指责别人，但如果他们是对的呢？我还要做这件事 30 年，弄清楚他们是否正确是值得的。如果他们错了，你也没损失。” 这就是促使我改变的原因。然后工具开始起作用，你开始深入交谈。我的自我意识足够强，能够说：“好吧，现在我理解了。” 我从我信任的人那里得到了一些同事反馈，这帮我彻底理解了。所以那是这件事的关键，但这些都是非常、非常难以突破的事情。我想重点是，它们通常不会以温和的方式出现。

---

### [01:01:53] Lenny

**English:**
I was going to ask what that turning point for you was, and it sounds like it was direct feedback from someone you really trusted that's like, "Oh, I really need to take this seriously."

**中文翻译:**
我正想问你的转折点是什么，听起来像是来自你真正信任的人的直接反馈，让你觉得：“噢，我真的需要认真对待这件事。”

---

### [01:02:01] Nikhyl Singhal

**English:**
You got it. You got it. Because I had a lot of feedback that I was dismissing and then I had feedback from someone, I'm like, "That person I should listen to because they're giving me the feedback for the right reasons and they have the right language."

**中文翻译:**
没错。就是这样。因为我之前忽略了很多反馈，然后我从某人那里得到了反馈，我想：“那个人我应该听，因为他们给我反馈的出发点是对的，而且他们使用了正确的语言。”

---

### [01:02:13] Lenny

**English:**
Comes back to the power of getting feedback and getting good at that.

**中文翻译:**
又回到了获取反馈并擅长此道的力量上。

---

### [01:02:17] Nikhyl Singhal

**English:**
And making people feel safe and giving it.

**中文翻译:**
以及让人们在提供反馈时感到安全。

---

### [01:02:19] Lenny

**English:**
Mm-hmm. That's a good segue to maybe the last question. You told me once that a lot of the people that you work with that have kind of made it have a lot of mental health challenges, that they didn't expect their life to be the way it is necessarily when they got there. Can you just talk about what you see there in that group?

**中文翻译:**
嗯。这是一个很好的过渡，引出最后一个问题。你曾告诉我，很多与你共事过的、已经“功成名就”的人都有很多心理健康挑战，当他们到达顶峰时，他们没预料到生活必然会变成那样。你能谈谈你在那个群体中看到了什么吗？

---

### [01:02:39] Nikhyl Singhal

**English:**
Yeah. This is a story that I don't think is told very well right now, and partly because it's such a luxury problem, it's almost a little embarrassing to discuss it openly as so many people struggle with so many basic needs, going through layoffs, going through all these challenges. I mean, these are real issues. But I think that what I've noticed is that if you kind of break career as we've done in this podcast between sort of act one, act two and act three, if act one is sort of learning and being that sort of builder and then maybe building the car, and then act two is building the factory, act three is like, what's after that? What do you do after that? And I think that act three in the past wasn't as long as it is now. Before, people would proverbially retire in their 60s when they used to actually physically work. Now almost all your listeners sit at a desk all day, so they don't need to retire by any means. And health is getting better. You might see folks work until their 70s or 80s. So that means that their careers are potentially 60 years long. So even if you're 20 years or 30 years in your career, you're only halfway through. So this act three could be a thing. And I don't think we talk about act three enough. What often happens is, and this is what I've been watching for people that are at my age, is they sort of succeed and then they become lost. They almost goes hand in hand. So when I was a kid and I was growing up in the Midwest, entertainment was going to the dog tracks, and not even the horse tracks, we didn't have horses. So it was the greyhound dog tracks. So people would bet on a dog and greyhound would go around the ring and then you would see. I bet on number three and I'll make a buck or something. The way that they motivated the dogs was they had these fake rabbits, which sounds kind of cruel and horrible, so I don't want the SPCA to come after you. But the point is that they'd have these fake rabbits. And what was interesting is, the moment that the dogs, if they accidentally touched the rabbit, the sort of the tail because the machine broke, because these tails would go around faster than the dogs, which would then motivate the dogs to go around in circles. Sometimes the machines would break, the dogs would actually catch the rabbit, they would never run again. The reason why they wouldn't run again is because there was like, "Well, what's next? I've achieved what I was looking for." So I think this happens a ton. It's like, your listeners are spending time focused on like, "Well, one day I will be X. I will be that vice president. I will have more money. I will have built something. I will have started a company." But they don't think about what happens next, and when it happens, when they succeed, their North Star, their entire way of wiring their career, themselves, it has been around getting to that place. And I think that if you're going to get there 30 years in and you have a 60-year career, a lot of the discussion I've been having with myself and with others has been, you probably need to start working on that North Star now. What's the second thing? What's your career next look like? How do you ensure that you are always going to have something important and motivating to do with your career? Otherwise, you'll keep working because you had no nothing else to do, but you'll be sadder, or you'll find ways to create war when peace is needed, or you'll spend money in an attempt to earn more, or you'll find habits that are bad. And I really want us to have long 60-year, 70-year careers, not just 30-year or 10-year, which is why I enter this into the vocabulary out there.

**中文翻译:**
是的。我认为这个故事目前还没有被很好地讲述，部分原因是它像是一个“奢侈的问题”，公开讨论它甚至有点尴尬，因为有那么多人还在为基本需求而挣扎，经历裁员，经历所有这些挑战。我的意思是，那些才是现实问题。但我注意到，如果你像我们在播客中所做的那样，把职业生涯分为第一幕、第二幕和第三幕：如果第一幕是学习并成为建设者，比如造车；第二幕是建造工厂；那么第三幕就是，那之后呢？那之后你做什么？我认为过去的第三幕没有现在这么长。以前，人们在 60 多岁时退休，因为他们过去真的从事体力劳动。现在你几乎所有的听众整天都坐在办公桌前，所以他们根本不需要退休。而且健康状况正在变好，你可能会看到人们工作到 70 或 80 岁。这意味着他们的职业生涯可能有 60 年之久。所以即使你已经工作了 20 或 30 年，你也才走了一半。所以这“第三幕”可能是一个大问题。我认为我们对第三幕讨论得不够。经常发生的情况是（这也是我观察我这个年纪的人所看到的），他们获得了某种成功，然后就迷失了。成功与迷失几乎是手牵手而来的。当我还是个孩子在美中西部长大时，娱乐活动是去赛狗场，甚至不是赛马场，我们没有马。那是灰狗赛跑。人们会赌哪只狗赢，灰狗绕着圈跑，你会看到，“我赌 3 号，能赚一块钱”。他们激励狗的方式是使用假兔子，这听起来有点残忍和可怕，我不希望动物保护协会找你麻烦。但重点是他们有这些假兔子。有趣的是，一旦那些狗不小心碰到了兔子（可能是因为机器坏了，因为这些兔子的尾巴转得比狗快，从而激励狗绕圈跑），有时机器坏了，狗真的抓住了兔子，它们就再也不会跑了。它们不再跑的原因是：“好吧，接下来呢？我已经得到了我想要的东西。” 我认为这种情况经常发生。就像你的听众花时间专注于：“好吧，总有一天我会成为某某人。我会成为副总裁。我会更有钱。我会做出一些成就。我会创办一家公司。” 但他们没有思考接下来会发生什么。当它发生时，当他们成功时，他们的北极星，他们构建职业生涯和自我的整个方式，都是围绕着到达那个地方。我认为，如果你在 30 年后到达那里，而你有一个 60 年的职业生涯，我一直在与自己和他人讨论的是：你可能现在就需要开始寻找那个新的“北极星”。第二步是什么？你的职业生涯下一步是什么样子的？你如何确保你的职业生涯中总会有重要且有动力的事情可做？否则，你会因为不知道还能做什么而继续工作，但你会变得更忧郁，或者在需要和平的时候找借口挑起事端，或者为了赚更多钱而挥霍金钱，或者养成坏习惯。我真的希望我们能拥有 60 年、70 年的长青职业生涯，而不仅仅是 30 年或 10 年，这就是为什么我把这个概念引入到大众词汇中。

---

### [01:06:51] Lenny

**English:**
That is really resonating with me. I had a similar experience. I had a startup, and my whole goal was just like, "I just want to start a company." That's my goal. That's all I got in life. I want to start a company and then maybe sell it, maybe go somewhere with it. So I did and then we sold it to Airbnb and then I got to Airbnb and I was just like, "What the hell do I do now? I don't have any other goals." And it was pretty sad. Exactly how you're describing. It was just like, "I guess I'll just work here and I don't know, maybe I'll start another company, but I already did the thing I wanted to do."

**中文翻译:**
这真的引起了我的共鸣。我有过类似的经历。我创办了一家公司，我整个目标就是：“我只想创办一家公司。” 那就是我的目标，我生命中的全部。我想创办一家公司，然后也许卖掉它，也许带着它去某个地方。我做到了，然后我们把它卖给了 Airbnb。当我到了 Airbnb，我想：“我到底该做什么？我没有其他目标了。” 那真的很悲哀。正如你所描述的那样。就像是：“我想我就在这里工作吧，我不知道，也许我会再开一家公司，但我已经做完了我想做的事。”

---

### [01:07:21] Nikhyl Singhal

**English:**
Your story is I think very inspiring because what you did is you said, "I think the thing that I want to do is give, but I want to do it in my own way and I want to create something, but I want to do something that I think I can do for 30 years and I want to do it." It has lots and lots of spokes to it. So you reinvented yourself professionally, but you created a new North Star. My sense is, for every one of you, Lenny, there's a hundred that could do that, that could do giving, that could do things that could scale, but that end up falling into what got them to be successful in act two and they get stuck. So this is the reason why when you hit your skip, keep looking for the next skip, is the point I'm trying to make. And I think you're an inspiration for a lot of folks who have seen you transition and realizes life after just being a tech professional entrepreneur, there's got to be ways to do more of this for all of your listeners. And I think it's never too early to start thinking through. It's actually quite powering to think that you have such a long career. You can make mistakes and you can do some amazing things down the road.

**中文翻译:**
我认为你的故事非常鼓舞人心，因为你所做的是说：“我想做的事情是给予，但我想以我自己的方式去做，我想创造一些东西，我想做一些我认为我可以做 30 年的事情。” 它有很多很多分支。所以你在职业上重塑了自己，你创造了一个新的北极星。我的感觉是，Lenny，每有一个像你这样的人，就有一百个本可以这样做的人——他们本可以给予，本可以做一些可以规模化的事情，但最终却陷入了让他们在“第二幕”成功的模式中并停滞不前。这就是为什么我说，当你完成一次“跳跃”时，要继续寻找下一次“跳跃”。我认为你对很多人来说都是一种启发，他们看到你的转型，意识到在仅仅做一个技术专业人士或企业家之后，生活还有其他可能。对于所有的听众来说，一定有办法做更多这样的事情。我认为开始思考这些永远不会太早。想到你拥有如此漫长的职业生涯，这实际上是非常有力量的。你可以犯错，你可以在未来做一些了不起的事情。

---

### [01:08:34] Lenny

**English:**
Yeah. This is my fourth career, is what I realized. I was a engineer, then a founder, then a product manager, and now whatever this is.

**中文翻译:**
是的。我意识到这是我的第四份职业。我曾是工程师，然后是创始人，然后是产品经理，现在是……不管这叫什么。

---

### [01:08:43] Nikhyl Singhal

**English:**
Whatever this is.

**中文翻译:**
不管这叫什么。

---

### [01:08:45] Lenny

**English:**
Whatever this is. I guess, just to give people something inspiring, productive, what are maybe some examples of North Stars you've seen that people can evolve into? I guess one path is this path of content creation, helping people learn stuff. What else have you seen that might work out for people?

**中文翻译:**
不管这叫什么。我想，为了给人们一些鼓舞人心、富有成效的东西，你见过哪些人们可以演变而成的“北极星”例子？我想一条路径是内容创作，帮助人们学习。你还见过其他什么对人们有效的方式吗？

---

### [01:09:00] Nikhyl Singhal

**English:**
I think that all variations here come into two categories. One categories are ways to drive more scaled economics. I've made millions. My North Star is to now make it tens. I've made tens. My North star is to do hundreds. That's what drives people from, it's not entrepreneurship, it's investing; it's not investing, it's private equity, et cetera. Whether we describe that as a bad quest or a good quest is a decision for your listener. The other arc is around giving. Eastern philosophies that have been around for thousands of years talk about this as the sort of end state of happiness. I think that maybe to be provocative, I think that it's okay for you in act one and act two to not predicate yourself around the notion of giving to others because this is maybe the time on the planet where you need to take and you need to create. But boy, if you're going to work on an act three and you have 30 years, regardless of where you are economically, if you feel like you can take that off the table, if you can find ways to give, whatever that means to you, however that translates to you, is that content, is that volunteer, is that starting a company that is more mission based, that is not my role, but I think that if you are able to do that for 30 years and be giving, not only is that going to be more fulfilling than your act one and act two, but it's tremendous for society, very empowering. And that's where I commend you because you're giving through your passion but also making a livelihood. And I think that that's a very powerful blend that is hard to achieve in act one and act two given constraints. And that's the liberation that act three provides.

**中文翻译:**
我认为这里所有的变化都可以归为两类。一类是追求更大规模的经济效益。我已经赚了数百万，我的北极星现在是赚数千万；我已经赚了数千万，我的北极星是赚数亿。这就是驱动人们从创业转向投资，从投资转向私募股权等等的原因。我们将其描述为“坏的追求”还是“好的追求”，取决于听众自己的决定。另一类是关于给予。存在了数千年的东方哲学将此视为幸福的终极状态。我想，说得挑衅一点，我认为你在第一幕和第二幕中不以“给予他人”为前提是可以接受的，因为这可能是你在地球上需要获取和创造的时期。但是，天哪，如果你要开启第三幕，并且你有 30 年的时间，无论你的经济状况如何，如果你觉得可以放下经济负担，如果你能找到给予的方式（无论那对你意味着什么，无论那是内容创作、志愿者工作，还是创办一家更具使命感的公司），那不是我的角色，但我认为如果你能坚持给予 30 年，这不仅会比你的第一幕和第二幕更充实，而且对社会也有巨大的贡献，非常有力量。这就是我赞赏你的地方，因为你通过你的热情在给予，同时也以此谋生。我认为这是一种非常强大的结合，在第一幕和第二幕中由于种种限制很难实现。这就是第三幕带来的解放。

---

### [01:11:08] Lenny

**English:**
What do you think your act three plus ends up being?

**中文翻译:**
你认为你的“第三幕及以后”最终会是什么样子？

---

### [01:11:12] Nikhyl Singhal

**English:**
Many have asked me about this. I would say that I'll use the word, and then I'll tell you I won't use that word. So it is around my passion around coaching and giving to others. But because I'm a product person, because I've seen success in building products, thinking about scale, thinking about community, I definitively plan to devote my act three towards coaching and giving to others and lifting up those that with the right advice at the right time can change their trajectory. But scaling that and doing that in a way that is very authentic is really the hardest part and it's product problem. So that's what I'll devote 30 years to and I look forward to that every day.

**中文翻译:**
很多人问过我这个问题。我会说，我会用那个词，然后我会告诉你我不会用那个词。所以，它围绕着我对教练和给予他人的热情。但因为我是一个产品人，因为我见证了构建产品、思考规模、思考社区的成功，我明确计划将我的第三幕致力于教练和给予他人，提拔那些在正确的时间获得正确建议就能改变人生轨迹的人。但如何规模化地、以非常真实的方式做到这一点，确实是最难的部分，这是一个产品问题。所以这就是我将投入 30 年的事情，我每天都对此充满期待。

---

### [01:11:59] Lenny

**English:**
That is beautiful. That feels like an exactly correct fit for you, and I'm here to help you on that journey any way I can.

**中文翻译:**
太美好了。这感觉非常适合你，我愿意以任何方式在你的旅程中提供帮助。

---

### [01:12:05] Nikhyl Singhal

**English:**
Thank you, my friend.

**中文翻译:**
谢谢你，我的朋友。

---

### [01:12:06] Lenny

**English:**
Absolutely. Is there anything else you wanted to touch on before we get to our very exciting lightning round?

**中文翻译:**
没问题。在进入我们非常激动人心的闪电轮问答之前，你还有什么想谈的吗？

---

### [01:12:11] Nikhyl Singhal

**English:**
No, I just appreciate your genuine offer to have me attend and participate in this wonderful podcast that you created.

**中文翻译:**
没有了，我只是非常感谢你真诚地邀请我参加你创建的这个精彩播客。

---

### [01:12:18] Lenny

**English:**
It's absolutely my pleasure. And it's not over yet. We've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
绝对是我的荣幸。还没结束呢。我们进入了非常激动人心的闪电轮。我有六个问题要问你。准备好了吗？

---

### [01:12:25] Nikhyl Singhal

**English:**
I am ready.

**中文翻译:**
准备好了。

---

### [01:12:26] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:12:30] Nikhyl Singhal

**English:**
So two, and both business books. Sorry, I'm going to come across boring. But one is this sort of little bit of an old school book called Crossing the Chasm by Geoffrey Moore. I don't know if other speakers have spoken about this, but it's a book that Geoffrey Moore wrote, and it's a book that really talks about how to get your first product on base. So it's this concept of creating a beachhead. I like that concept. Marketing is something that we don't talk about in enough and product. And then the second one is a book that none of your listeners have actually probably heard of called Leadership and Self-Deception. It's a six-hour audio that I highly recommend. It's a story about a person who has hit a wall and who's getting all this feedback that they don't know what to make of, and it's around their mindset being stuck in a box. That was very powerful when I listened to it in my late 20s. So I encourage all of your listeners to grab that one. It's not one that anyone normally would hit, but it's a fun story. It's a good ride, and I think maybe you'll get something out of it.

**中文翻译:**
有两本，都是商业书。抱歉，我听起来可能有点无聊。一本是有点老派的书，叫《跨越鸿沟》（Crossing the Chasm），作者是 Geoffrey Moore。我不知道其他嘉宾是否提到过，但 Geoffrey Moore 写的这本书真正讨论了如何让你的第一个产品站稳脚跟。这就是建立“滩头阵地”的概念。我喜欢这个概念。营销是我们在产品领域讨论得不够的东西。第二本是你的听众可能都没听说过的书，叫《领导力与自我欺骗》（Leadership and Self-Deception）。这是一个 6 小时的音频，我强烈推荐。它讲述了一个人碰壁后收到各种不知所措的反馈的故事，核心是关于他们的思维模式被困在“盒子”里。我在 20 多岁快 30 岁时听了这本书，觉得非常有力量。所以我鼓励所有的听众去读读看。这不是一本大家通常会碰到的书，但它是一个有趣的故事，一段不错的旅程，我想你也许能从中有所收获。

---

### [01:13:41] Lenny

**English:**
I have not heard of that second one. I'm excited to check it out. I have Crossing the Chasm back behind me on that shelf somewhere. And you talk about how marketing isn't something product leaders and managers think about enough, and I have many marketing-oriented guests on this podcast and those episodes do the least well, but I'm just going to keep doing it because I totally agree with you. I think there's so much to learn from marketing. It's connected to growth, which is connected to product. So I agree.

**中文翻译:**
我没听说过第二本。我很期待去看看。我身后的书架上就有《跨越鸿沟》。你提到营销是产品领导者和经理思考不够的东西，我这个播客请过很多以营销为导向的嘉宾，那些集的表现最差，但我会坚持做下去，因为我完全同意你的观点。我认为从营销中学到的东西太多了。它与增长相关，而增长又与产品相关。所以我同意。

---

### [01:14:07] Nikhyl Singhal

**English:**
Yeah, and I think that marketing is a language of connecting products with people. That is what a product manager does, but we often lack the language. We lack the thinking around how to explain it, and yet we spend all our time on data and features for that. The diversity of having both playbooks can make one of just a much more powerful builder. So I agree with you. Marketing folks is probably some of the best content and the least listen to. So maybe that's a plug for people to go back to those episodes.

**中文翻译:**
是的，我认为营销是将产品与人连接起来的语言。这正是产品经理所做的，但我们往往缺乏这种语言。我们缺乏关于如何解释它的思考，然而我们却把所有时间都花在数据和功能上。同时拥有这两套剧本的多样性可以让你成为一个更强大的建设者。所以我同意你的看法。营销人员的内容可能是最好的，但听的人最少。所以也许这可以作为一个广告，让人们回去听听那些集。

---

### [01:14:39] Lenny

**English:**
100%. That's what everyone should do. I don't know if you know this, but actually, at Airbnb, the product manager function has been renamed to product marketing. So all the product managers are product marketers because Brian is so big on, you're not just building product, your job is also to make sure people use it. We'll see how that experiment goes, but that's a bold move I thought.

**中文翻译:**
100% 同意。大家都应该这么做。我不知道你是否知道，实际上在 Airbnb，产品经理职能已被更名为“产品营销”。所以所有的产品经理都是产品营销人员，因为 Brian 非常强调：你不仅是在构建产品，你的工作还包括确保人们使用它。我们将看看这个实验进行得如何，但我认为这是一个大胆的举动。

---

### [01:14:59] Nikhyl Singhal

**English:**
Very much so. Very much. But it's an homage to this concept.

**中文翻译:**
确实如此。非常大胆。但这是对这一理念的致敬。

---

### [01:15:02] Lenny

**English:**
Exactly. Okay, back to landing ground. What is a favorite recent movie or TV show?

**中文翻译:**
没错。好了，回到闪电轮。最近最喜欢的电影或电视节目是什么？

---

### [01:15:08] Nikhyl Singhal

**English:**
I'm a huge sports fan, so I have tickets to the Warriors and 49ers, and I am a big Bay Area sports fan. Giannis is my son's favorite player. He's a basketball player for the Milwaukee Bucks, and they have this Disney+ story called the Rise story, and it's a story about his childhood and how he struggled to find notoriety and how he made it into the professional leagues. It's a great Disney+ family show and it's a great kind of zero to hero type thing. So I love that story.

**中文翻译:**
我是个超级体育迷，我有勇士队和 49 人队的门票，我是湾区体育的忠实粉丝。Giannis（字母哥）是我儿子最喜欢的球员。他是密尔沃基雄鹿队的篮球运动员，Disney+ 上有一个叫《崛起》（Rise）的故事，讲述了他的童年、他如何艰难成名以及他如何进入职业联赛。这是一个很棒的 Disney+ 家庭节目，也是一个很棒的“草根变英雄”的故事。所以我很喜欢那个故事。

---

### [01:15:41] Lenny

**English:**
I feel like you're going to have a really good answer to this next one. What is a favorite interview question that you like to ask?

**中文翻译:**
我觉得你对下一个问题会有很好的回答。你最喜欢问的面试问题是什么？

---

### [01:15:47] Nikhyl Singhal

**English:**
I like the format of, what's something that everyone takes for granted that you think is essentially hogwash or inaccurate? Sometimes I'll ask a manager, "Look, you've managed hundreds of people in your career, what's conventional wisdom that you bet against that you have found is actually inaccurate?" And you can do that for what do people think about AI, that's inaccurate, that everyone believes you could do that for domains, you can do all kinds of things.

**中文翻译:**
我喜欢这种形式：有什么事情是大家都认为是理所当然的，而你认为本质上是废话或不准确的？有时我会问经理：“看，你在职业生涯中管理过数百人，有什么你反对的传统智慧，是你发现实际上是不准确的？” 你也可以针对人们对 AI 的看法来问，或者针对特定领域，你可以问各种各样的事情。

---

### [01:16:18] Lenny

**English:**
I love it. Is there something you specifically look for there, or is it just depends on what you hear?

**中文翻译:**
我喜欢这个。你会在回答中寻找特定的东西吗，还是取决于你听到了什么？

---

### [01:16:25] Nikhyl Singhal

**English:**
I'm always looking for people to break this sort of interview mindset. Everyone always prepares for interviews and then their entire conversation is predicting what you think you want me to say. And as a result, you can have high-quality people that you dismiss because they weren't genuine. There's no way to answer that question without being genuinely opinionated because it starts with, "What is the thing that you think I want to say here? And then tell me why it's inaccurate." So when I break that wall, I'm testing, is this person authentic? Because sometimes I'm dismissing them because they told me nothing new, but I don't want the interview process to penalize them. And this was my save question, but I can't use it now that I've told everyone.

**中文翻译:**
我一直在寻找能打破这种“面试思维”的人。每个人都会为面试做准备，然后他们的整个谈话都在预测你希望他们说什么。结果，你可能会解雇一些高素质的人，因为他们不真诚。如果不表达真实的见解，就无法回答那个问题，因为它始于：“你认为我在这里想听什么？然后告诉我为什么那是不准确的。” 所以当我打破那堵墙时，我是在测试：这个人真实吗？因为有时我会因为他们没告诉我任何新东西而拒绝他们，但我不想让面试过程惩罚他们。这是我的保留问题，但既然我告诉了大家，我就不能再用了。

---

### [01:17:27] Lenny

**English:**
It's going to be all over TikTok soon. Everyone's going to know this. Next question, what's a favorite recent product that you've discovered that you love?

**中文翻译:**
很快就会传遍 TikTok 的。大家都会知道的。下一个问题，最近发现并喜爱的产品是什么？

---

### [01:17:35] Nikhyl Singhal

**English:**
The geeky answer in me is the Arc Browser, which I think probably a lot of folks are starting to use and your listeners. Part of the reason is, I think it's just great for folks that have hundreds of tabs, and if you work at a scaled organization, you just have lots of tabs. But I think it's also, as a product guy, I thought Chrome was pretty good. They've got gajillions of people using it and billions of installs. So at some point, you kind of come to the conclusion that this is probably good enough. And then you see a product obviously built with a much smaller team and you're like, "Huh, there actually is opportunities to innovate." And any time you see a innovation on something that's mature, as a product person, I think that's just fascinating. And I was just blown away at how they created something that's better than something I hold as a true set.

**中文翻译:**
我内心那个极客的答案是 Arc 浏览器，我想可能很多人和你的听众都开始使用了。部分原因是，我认为它非常适合那些有数百个标签页的人，如果你在大型组织工作，你就会有很多标签页。但同时，作为一个产品人，我曾认为 Chrome 已经很好了。有无数人在使用它，有数十亿的安装量。所以在某种程度上，你会得出结论：这可能已经足够好了。然后你看到一个显然由更小团队构建的产品，你会想：“咦，实际上还有创新的机会。” 任何时候当你看到在成熟事物上的创新，作为产品人，我都觉得那非常迷人。我被他们创造出比我认为的“标准配置”更好的东西所震撼。

---

### [01:18:33] Lenny

**English:**
Yeah. We had Josh on the podcast, we talked about a lot of their philosophies. And on the tab thing, I think the key there is it closes your tabs after 24 hours unless you put them in a specific place, which I love because I was like, you think you would do that, but you don't. And then it's broke so beautiful, you wake up in the morning, everything's gone, but you can save stuff that you want. The other thing I'll mention with Arc, by the way, also huge fan, that's all I use, and I'm not an investor, just a fan, is the onboarding experience is the best onboarding experience I've seen. I was just like, I did it and I got a tweet about this. This is so good. And actually, if you go to that episode, there's a link to get past the wait list and just-

**中文翻译:**
是的。我们请 Josh 上过播客，聊了很多他们的理念。关于标签页，我认为关键在于它会在 24 小时后关闭你的标签页，除非你把它们放在特定的地方。我喜欢这个功能，因为你以为你会去关，但你其实不会。然后它以一种美妙的方式打破了现状，你早上醒来，一切都清空了，但你可以保存你想要的东西。顺便说一下，关于 Arc 我还要提一点（我也是铁粉，我只用它，我不是投资者，只是粉丝），它的新手引导（onboarding）体验是我见过的最好的。我当时就觉得，我体验完后还发了推特。这太棒了。实际上，如果你去听那一集，有一个跳过等待名单的链接，而且——

---

### [01:19:11] Nikhyl Singhal

**English:**
Oh, that's right. Yeah.

**中文翻译:**
噢，没错。是的。

---

### [01:19:12] Lenny

**English:**
Yeah. You gave me many thousands of invites. Okay, keep going. What is something relatively minor you've changed in the way you develop products and your team that's had a big impact on the team's ability to execute?

**中文翻译:**
是的。你给了我好几千个邀请码。好了，继续。在开发产品和管理团队的方式上，你做了哪些相对较小但对团队执行能力产生重大影响的改变？

---

### [01:19:26] Nikhyl Singhal

**English:**
A little bit of this is just because of scale, but oftentimes we think a lot about the products and the features and the decisions that we're working on, and then we think that meetings are a nuisance or a must-have necessary evil to be able to deliver. Sometimes I realize that at a scaled organization, the meeting operating system is as important as the products that we're building because it sort of speaks to how we scale and how we ensure we have the right degree of delegation, the right conversations, and then the right acceleration on the right decisions. So what's interesting is every quarter, in my current teams, even in my past teams, I talk about our meetings like a product. We're on version seven in my team, and so we're like, "Hey, version seven, every 90 days, these are the meetings, these are the discussions, this is how we organize, these are the attendees, and then here's how we make decisions. This is the cadence of the week. This is when people can work from home, hybrid, whatever it might be." And then I take feedback two months in and then every three months we make another route. What it finds is that people then can plan and they can make meeting time effective. And meeting time is such precious time. It's the most expensive time in a company. So when I was in a startup, I couldn't imagine doing this, but now this is like my bread and butter as a leader. It's the process part. And frankly, for new folks that are new in leadership positions in a new company, it's the one thing you can do when you have low context. When you don't know how the product works, you can look at things with fresh eyes and see inefficiencies when everyone that's been in the system can't see it. I'm a huge fan of rebooting meetings first. So process first, then people, then product, then strategy is sort of the notion I make, and this is this first thing I always do.

**中文翻译:**
这在一定程度上是因为规模的原因。但通常我们对正在开发的产品、功能和决策思考很多，然后认为会议是一种麻烦，或者是为了交付而不得不忍受的“必要之恶”。有时我意识到，在大型组织中，“会议操作系统”与我们正在构建的产品同样重要，因为它关系到我们如何规模化，如何确保我们有适当程度的授权、正确的对话，以及对正确决策的正确加速。有趣的是，每个季度，在我现在的团队，甚至过去的团队中，我都会像对待产品一样讨论我们的会议。我的团队现在用的是“版本 7”，所以我们会说：“嘿，版本 7，每 90 天更新一次，这些是会议，这些是讨论，这是我们的组织方式，这些是参加者，这是我们做决定的方式。这是每周的节奏。这是人们可以居家办公、混合办公的时间，等等。” 然后我在两个月后收集反馈，每三个月我们进行一次迭代。结果发现，人们可以据此进行计划，并使会议时间变得有效。会议时间是非常宝贵的时间，是公司里最昂贵的时间。当我在初创公司时，我无法想象这样做，但现在作为领导者，这是我的拿手好戏。这是流程部分。坦率地说，对于刚加入新公司、担任领导职务的新人来说，这是你在缺乏背景信息时可以做的一件事。当你不知道产品如何运作时，你可以用全新的眼光审视事物，看到系统内的人看不到的低效之处。我是“首先重启会议”的忠实粉丝。所以，流程第一，然后是人，然后是产品，最后是战略，这是我的理念，也是我总是做的第一件事。

---

### [01:21:29] Lenny

**English:**
Final question, what is one thing every PM listening should do to help their career?

**中文翻译:**
最后一个问题，每一位正在听节目的 PM 应该做哪一件事来帮助他们的职业生涯？

---

### [01:21:35] Nikhyl Singhal

**English:**
Ensure that the story you will tell about the work you're doing today is meaningful for your skip job. So if you sit down and you write down, "In six months, in 12 months, in 24 months, when I achieve or finish this role, here's the paragraph I'll write. Here's a problem I solved. Here's the skill I built. Here's the headwind I faced. Here's what I did to overcome it." Use I in the sentence, do not use we. We will do good things. You are who we are thinking about, your career. We're not looking for we. Master the story now. Understand the story. If the story sucks, you probably should be thinking through how to make the story not suck. But that to me is a very good career decision and I think everyone is building their story today. I want to know that story. I want that story to be incredibly compelling because whether you promote it or not, that story's compelling. You'll be promoted in career. And that's what we're here for.

**中文翻译:**
确保你关于今天所做工作的“故事”，对你的“下下份工作”（skip job）是有意义的。所以，如果你坐下来写下：“在 6 个月、12 个月、24 个月后，当我完成这个角色时，这是我要写的一段话。这是我解决的问题。这是我建立的技能。这是我面临的阻力。这是我为克服它所做的事情。” 在句子中使用“我”，不要使用“我们”。“我们”会做伟大的事情，但我们现在考虑的是你，你的职业生涯。我们不是在寻找“我们”。现在就掌握这个故事。理解这个故事。如果故事很烂，你可能应该思考如何让故事不烂。对我来说，这是一个非常好的职业决定。我认为每个人今天都在构建自己的故事。我想知道那个故事。我希望那个故事极具吸引力，因为无论你是否获得晋升，只要故事有吸引力，你的职业生涯就会获得晋升。这就是我们来到这里的目的。

---

### [01:22:48] Lenny

**English:**
Nikhyl, this is the first time we've ever met. I'm such a fan instantly. This might be my new favorite episode. I'm so excited for people to listen to this. There's so much value here. Two final questions before we wrap up. Where can folks find you online if they want to learn more? And also, talk about maybe various community, The Skip, and all that stuff that people can check out. And then how can listeners be useful to you?

**中文翻译:**
Nikhyl，这是我们第一次见面。我瞬间成了你的粉丝。这可能是我最喜欢的新一集。我非常激动能让大家听到这一集，这里有太多的价值。在结束之前还有最后两个问题。如果大家想了解更多，可以在哪里找到你？另外，谈谈各种社区、《The Skip》以及大家可以查看的内容。最后，听众可以如何帮到你？

---

### [01:23:09] Nikhyl Singhal

**English:**
I'm building this brand around The Skip because I'm so passionate. There's two outlets that people can easily connect. One is the podcast, which much like yourselves is available on Apple and Spotify and others. So I'd love for people to join my podcast and hear. What I'm now moving my podcast to is almost like coaching calls. Because I have so many of them, I'm saying like, "Hey, 30 minutes, let me walk you through a problem and hear how I'm thinking about it, whether that's a transition discussion or compensation discussion, et cetera." And then the other one is this sort of newsletter that I have on Substack, which is a bit of a mirror of the podcast. It's different forms of the same topic areas. So, would love for your listeners to connect with that. I think as far as getting in touch with me, LinkedIn is where I spend most of my time professionally. So between Twitter and LinkedIn, my presence is relatively easy to find. And then how listeners can help me, I mean, one, you can build the most fulfilling career story and be your best, but also give back and pull others forward. Whether that's through your act three or whether that's just helping others, I mean, I think that would be the most fulfilling to me. I think feedback from your listeners to me on things they wish I would spend time talking about is incredibly empowering for my content because then I can deliver more meaningful content. It's very different from yours, but I think it's all around the arc of trying to help people gain forward and be more effective tech professionals. So I would love to hear from your listeners.

**中文翻译:**
我正围绕《The Skip》建立这个品牌，因为我充满热情。人们可以通过两个渠道轻松联系。一个是播客，和你们的一样，在 Apple、Spotify 等平台上都有。我希望大家能听听我的播客。我现在正把播客转向类似于“教练电话”的形式。因为我接到的电话太多了，我会说：“嘿，花 30 分钟，让我带你分析一个问题，听听我是怎么想的，无论是转型讨论还是薪酬讨论等等。” 另一个是我在 Substack 上的时事通讯，它有点像播客的镜像，是同一主题领域的不同形式。所以，很希望你的听众能关注。至于联系我，LinkedIn 是我花费大部分专业时间的地方。所以在 Twitter 和 LinkedIn 之间，我的身影相对容易找到。至于听众如何帮助我，首先，你可以构建最充实的职业故事并做到最好，但也要回馈并提携他人。无论是通过你的“第三幕”，还是仅仅帮助他人，我认为那对我来说是最有成就感的。我认为听众给我的关于希望我花时间讨论的事情的反馈，对我的内容创作非常有帮助，因为这样我可以提供更有意义的内容。我的内容与你的非常不同，但都是围绕着帮助人们进步、成为更高效的技术专业人士这一主线。所以我很想听到听众的反馈。

---

### [01:24:48] Lenny

**English:**
Just to make sure people know where to go to do this. For feedback, do you recommend LinkedIn?

**中文翻译:**
为了确保大家知道去哪里做这些。对于反馈，你推荐 LinkedIn 吗？

---

### [01:24:53] Nikhyl Singhal

**English:**
Yeah, LinkedIn is the ideal, but you can also find me on Twitter if you are just trying to add a quick... If you're trying to follow me, follow me on LinkedIn. If you're looking for feedback, just tweet me.

**中文翻译:**
是的，LinkedIn 是理想的选择，但如果你只是想快速添加……你也可以在 Twitter 上找到我。如果你想关注我，就在 LinkedIn 上关注。如果你想提供反馈，直接发推特给我。

---

### [01:25:03] Lenny

**English:**
And then for The Skip newsletter, what is the URL to go check that out?

**中文翻译:**
那么《The Skip》时事通讯的网址是什么？

---

### [01:25:06] Nikhyl Singhal

**English:**
It's theskip.substack.com.

**中文翻译:**
是 theskip.substack.com。

---

### [01:25:09] Lenny

**English:**
Amazing. And you don't publish often, but each issue is incredibly valuable, so we'll definitely link to that all in the show notes. Nikhyl, thank you again so much for being here. I will let you go now. This was amazing.

**中文翻译:**
太棒了。你发布得不频繁，但每一期都非常有价值，所以我们一定会把链接放在节目笔记中。Nikhyl，再次感谢你来到这里。现在我让你去忙吧。这太精彩了。

---

### [01:25:21] Nikhyl Singhal

**English:**
Yeah, thank you, Lenny. Appreciate it.

**中文翻译:**
好的，谢谢你，Lenny。非常感谢。

---

### [01:25:23] Lenny

**English:**
Bye, everyone.

**中文翻译:**
再见，各位。

---

### [01:25:25] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这能真正帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。