# Nikita Bier - 双语对照

This is the complete bilingual transcript for **Lenny's Podcast** featuring **Nikita Bier**.

---

### [00:00:00] Nikita Bier

**English:**
... Honored to be on a product management podcast for a person who doesn't believe product management is real.

**中文翻译:**
……作为一个不相信“产品管理”真实存在的人，我很荣幸能参加一个关于产品管理的播客。

---

### [00:00:07] Lenny Rachitsky

**English:**
We're already getting into the hot takes. You launched tbh, went viral, you end up selling it to Facebook. What was the insight that helped you come up with this is a big idea that we should try?

**中文翻译:**
我们这就开始聊“热辣点评”了。你推出了 tbh，它迅速走红，最后你把它卖给了 Facebook。当时是怎样的洞察让你意识到这是一个值得尝试的大创意？

---

### [00:00:15] Nikita Bier

**English:**
I looked on the App Store and the number one app in the United States was an app called Surah, but the entire app was in Arabic, like the strongest signal that you could ever have that people want something.

**中文翻译:**
我看了下 App Store，当时美国排名第一的应用叫 Surah，但整个应用全是阿拉伯语。这是你能看到的最强烈的信号，表明人们极度渴望某种东西（即便语言不通也要用）。

---

### [00:00:27] Lenny Rachitsky

**English:**
This is insane. I did not know this full story.

**中文翻译:**
这太疯狂了。我以前不知道完整的故事是这样的。

---

### [00:00:30] Nikita Bier

**English:**
We launched this app, it immediately took off, servers started crashing. I looked at our numbers and I'm like, "We will be number one in the United States in six days."

**中文翻译:**
我们发布了这个应用，它立刻就火了，服务器开始崩溃。我看了看我们的数据，心想：“六天之内，我们就会成为美国排名第一的应用。”

---

### [00:00:40] Lenny Rachitsky

**English:**
A tip that you're sharing here is look for latent demand

**中文翻译:**
你在这里分享的一个秘诀是：寻找潜在需求（latent demand）。

---

### [00:00:43] Nikita Bier

**English:**
Where people are trying to obtain a particular value and going through a very distortive process. If you can actually crystallize what their motivation is, you can have this kind of intense adoption.

**中文翻译:**
也就是人们试图获得某种特定价值，但却不得不经历一个非常扭曲、繁琐的过程。如果你能准确提炼出他们的动机，你就能获得这种爆发式的用户增长。

---

### [00:00:57] Lenny Rachitsky

**English:**
I didn't know you're actually a product manager at Facebook.

**中文翻译:**
我以前不知道你居然在 Facebook 当过产品经理。

---

### [00:00:59] Nikita Bier

**English:**
The thing I didn't realize as a product manager in a large tech company is there is very little product management that you do. They're mainly just writing documents and then being the team secretary and running around getting approvals, but products live and die in the pixels. You should be designing the hierarchy, the pixels, the flows, everything. That's on you.

**中文翻译:**
在大科技公司当产品经理时我才发现，你其实很少做真正的“产品管理”。他们主要是在写文档，充当团队秘书，到处跑审批。但产品的生死取决于像素（细节）。你应该亲自设计层级、像素、流程，所有的一切。那是你的责任。

---

### [00:01:21] Lenny Rachitsky

**English:**
At some point you started tweeting like, "Hey, I'm working on new app. Everyone was going nuts." I saw a stat that you made $11 million in sales, 10 million downloads.

**中文翻译:**
在某个时间点，你开始发推特说：“嘿，我正在开发一个新应用。”大家都疯了。我看到一个数据，你的销售额达到了 1100 万美元，下载量达到 1000 万次。

---

### [00:01:28] Nikita Bier

**English:**
The thing that is hard to really understand is it is absolute chaos to keep the thing online. I was sleeping three hours a day for three months. Our team was also relentless though. They would come over to my house, 9:00 AM, stay until midnight and just do that seven days a week.

**中文翻译:**
很难让人理解的是，为了维持应用在线，当时简直是一片混乱。我有三个月时间每天只睡三小时。我们的团队也非常拼命，他们早上 9 点来我家，一直待到半夜，一周七天都是如此。

---

### [00:01:44] Lenny Rachitsky

**English:**
Is there anything else that's just like this is something that is probably going to help you with your app?

**中文翻译:**
还有什么其他的建议，是那种可能对开发应用非常有帮助的吗？

---

### [00:01:48] Nikita Bier

**English:**
With certainty, if you're good at your job, you can make an app grow and go viral. Over the years of building all these apps, I've accrued all these growth hacks that still nobody knows about.

**中文翻译:**
可以肯定的是，如果你擅长你的工作，你就能让一个应用增长并走红。在这些年开发这么多应用的过程中，我积累了许多至今仍无人知晓的增长黑客（growth hacks）技巧。

---

### [00:02:02] Lenny Rachitsky

**English:**
Today, my guest is Nikita Bier. Nikita has built, launched and helped get more apps to the top of the app store than any human I've ever come across. He sold his first big hit tbh to Facebook for over $30 million. He sold his second big app Gas to Discord for many millions more. He did this all with a tiny team and very little funding. He's also helped dozens of founders and apps, and as an advisor or investor to companies like Flow, Citizen, BeReal, LOCKit and Wealthsimple and many more. Today, he spends his time advising companies on viral growth strategies, design feedback, structuring their product development process and a lot more.

**中文翻译:**
今天的嘉宾是 Nikita Bier。Nikita 构建、发布并帮助推向 App Store 榜首的应用数量，比我见过的任何人都多。他以超过 3000 万美元的价格将他的第一个爆款 tbh 卖给了 Facebook。他又以数千万美元的价格将第二个大作 Gas 卖给了 Discord。他完成这一切只用了一个极小的团队和极少的资金。他还帮助过数十位创始人和应用，担任过 Flow、Citizen、BeReal、LOCKit 和 Wealthsimple 等多家公司的顾问或投资者。现在，他致力于为公司提供病毒式增长策略、设计反馈、构建产品开发流程等方面的咨询。

---

### [00:02:38] Lenny Rachitsky

**English:**
What I love about Nikita is that he has very strong opinions about how to build successful products that are rooted in him actually doing the work over the past decade to see for himself what works and what doesn't. Nikita has been the single most requested guests on this podcast, and you'll soon see why. This episode is packed with tactics and stories and lessons that I am sure will leave you wanting more. If you want to work with Nikita on your app, you can actually book his time at intro.co/nikitabier. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and helps the podcast tremendously. With that, I bring you Nikita Bier. Nikita, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
我最欣赏 Nikita 的一点是，他对如何打造成功产品有着非常强烈的见解，而这些见解根植于他过去十年亲手实践的经验，他亲眼见证了什么是有效的，什么是无效的。Nikita 是本播客呼声最高的嘉宾，你很快就会明白原因。这一集充满了策略、故事和教训，我相信会让你意犹未尽。如果你想让 Nikita 为你的应用提供指导，可以在 intro.co/nikitabier 预约他的时间。如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。这是避免错过后续节目的最好方式，也对我们很有帮助。现在，让我们欢迎 Nikita Bier。Nikita，非常感谢你能来，欢迎来到播客。

---

### [00:03:26] Nikita Bier

**English:**
Thanks for having me. I'm excited to dive in. I feel honored to be on a product management podcast for a person who doesn't believe product management is real.

**中文翻译:**
谢谢邀请。我很期待深入探讨。作为一个不相信“产品管理”真实存在的人，能参加一个产品管理播客，我感到很荣幸。

---

### [00:03:38] Lenny Rachitsky

**English:**
We're already getting into the hot takes. We're definitely going to chat about... Wait, and you said not real. Okay, I thought you were going to say not useful. This is good. Let's put a pin in that. I think we think this, I think everyone already feels this. I think this is going to be a very special conversation. I've been looking forward to chatting you for a long time and there's so much that I want to ask you. The way that I'm thinking we frame this conversation is we go through the story behind the apps that you've built or helped build that have hit the top of the app store, and basically here, the inside story of what it took to build those apps and to make them successful. Then through that, try to extract as many lessons as we can about what it takes to build a successful viral consumer app these days. How does that sound to you?

**中文翻译:**
我们已经开始聊“热辣点评”了。我们肯定会聊到……等等，你说“不真实存在”？好吧，我还以为你会说“没用”。这很有意思，我们先记下这一点。我想大家已经能感觉到，这将是一场非常特别的对话。我期待和你聊天很久了，有很多问题想问。我打算这样构思我们的对话：先回顾你构建或协助构建的那些冲上榜首的应用背后的故事，听听打造并让它们成功的内幕。然后从中尽可能多地总结出在当今环境下打造成功的病毒式消费级应用所需的经验。你觉得怎么样？

---

### [00:04:22] Nikita Bier

**English:**
Sounds amazing, and a lot of it was luck, but a lot of it was very, very tactical work that went into it all.

**中文翻译:**
听起来很棒。其中很多是运气，但也有非常、非常多战术层面的工作。

---

### [00:04:32] Lenny Rachitsky

**English:**
This episode is brought to you by Webflow. We're all friends here, so let's be real for a second. We all know that your website shouldn't be a static asset. It should be a dynamic part of your strategy that drives conversions, that's business 101. Here's a number for you. 54% of leaders say web updates take too long. That's over half of you listening right now. That's where Webflow comes in. Their visual-first platform allows you to build, launch, and optimize webpages fast. That means you can set ambitious business goals and your site can rise to the challenge. Learn how teams like Dropbox, IDEO and Orange Theory trust Webflow to achieve their most ambitious goals today at Webflow.com.

**中文翻译:**
本集节目由 Webflow 赞助。大家都是朋友，咱们实话实说。我们都知道网站不应该是一个静态资产，它应该是你驱动转化的动态策略的一部分，这是商业常识。给你一个数据：54% 的领导者表示网站更新耗时太长。这超过了现在正在收听节目的人的一半。这就是 Webflow 的用武之地。他们的视觉优先平台让你能够快速构建、发布和优化网页。这意味着你可以设定宏大的业务目标，而你的网站能够应对挑战。访问 Webflow.com，了解 Dropbox、IDEO 和 Orange Theory 等团队如何信任 Webflow 来实现他们最宏大的目标。

---

### [00:05:18] Lenny Rachitsky

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now you can assess risk, secure the trust of your customers and automate compliance for SOC 2, ISO 27001, HIPAA and more, with a single platform, Vanta. Vanta's market leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/lenny. That's vanta.com/lenny. First, I want to start with something that I think very few people know about you. The first thing that you built, the first product that you built was very different from what you do these days, and it's a product called Politify, which something I actually really want. It helps you decide who to vote for based on how it would impact your life. Can you just share a bit about just that part of your life and why you decided to pivot away from that into consumer apps?

**中文翻译:**
本集节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，事情很快就会变得复杂。现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，节省数小时的时间。加入成千上万家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的全球公司。访问 vanta.com/lenny 即可享受 1000 美元的优惠。首先，我想从一个我觉得很少有人知道的关于你的事情开始。你构建的第一件产品 Politify 与你现在做的非常不同，这其实是我非常想要的产品。它根据政策对你生活的影响来帮你决定投给谁。你能分享一下那段经历，以及为什么决定从那里转向消费级应用吗？

---

### [00:06:36] Nikita Bier

**English:**
When I was in college, I was really interested in this kind of thing that American voters do, which is they vote against their own financial self-interest, like people in New York and San Francisco vote for Democrats for higher taxes. People in Kansas vote for Republicans for low taxes and they make less money, and so fewer government benefits. I wanted to build this tool that would help communicate the financial impacts of these policy proposals of presidents. I built it in my last year of college and it was just a web app that we put out and it would calculate their tax proposals, the government benefits that they were proposing, and you would enter in your basic personal information, how many kids you have, your age. Then it would just tell you in dollars what the impact would be. It'd also tell you, we simulated those policies also against the tax returns of every zip code so you could see how it impacts your community.

**中文翻译:**
上大学时，我对美国选民的一种行为很感兴趣，那就是他们投票反对自己的经济利益。比如纽约和旧金山的人投票给民主党，支持加税；而堪萨斯州的人投票给共和党支持减税，但他们收入更低，政府福利也更少。我想做一个工具，来传达总统候选人政策提案对个人财务的影响。我在大四那年做了这个网页应用，它会计算税收提案和政府福利，你输入基本的个人信息，比如有几个孩子、年龄等，它就会直接告诉你以美元计算的影响。我们还针对每个邮政编码的纳税申报单模拟了这些政策，这样你就能看到它对你所在社区的影响。

---

### [00:07:40] Nikita Bier

**English:**
We went super viral. I think very few people thought of politics that way and I think we got 4 million users on it during that season, during that election. It was just like a project that we raised some grant money for, but it ended up feeding into this company that we spun up and that was called Outline. Because we had a bunch of governments reach out to us asking, "Can you build this for our budget?" The governor of Massachusetts actually reached out and I flew out there to meet with them and that was going to be our first customer. We raised some money, we won a government contract and we joined Techstars, the accelerator. We got a contract in the pipeline with the Obama administration and then we got this contract and we started building it and the government shutdown happened in the middle of like, as we were building it and we had one of our contracts canceled.

**中文翻译:**
我们彻底火了。我想当时很少有人从那个角度看待政治，那个选举季我们吸引了 400 万用户。这原本只是一个拿了点资助金的项目，但最终演变成了我们成立的一家叫 Outline 的公司。因为很多政府联系我们问：“你能为我们的预算做一个这样的工具吗？”马萨诸塞州州长甚至联系了我，我飞过去见他们，他们本打算成为我们的第一个客户。我们融了资，赢得了一份政府合同，并加入了 Techstars 加速器。我们甚至快要和奥巴马政府签合同了，结果就在我们开发过程中，政府停摆了，我们的一份合同被取消了。

---

### [00:08:51] Nikita Bier

**English:**
I realized I actually really don't like selling software to governments and my core competency all along was making things that go viral on the internet. That was what we had built, not this policy simulation tool. We went to our investors and we said, "Look, this isn't actually what we're excited about doing anymore." We offered to give the money back and said, "We're going to be building consumer apps and here's a few ideas that we have." None of them took the money back. Then we spent the next four or five years building a variety of different kind of consumer apps. We had a few mild successes during the course of those four to five years. One of them was an app called Five Labs that ingested your Facebook posts and determine your personality based on the language you use. It used this exact same model that Cambridge Analytica used, and that was super viral. I think we had tens of millions of profiles in it and it went viral in like three days.

**中文翻译:**
我意识到我其实一点也不喜欢把软件卖给政府，而我一直以来的核心竞争力是让东西在互联网上走红。这才是我们真正构建出来的能力，而不是那个政策模拟工具。我们去找投资者说：“听着，这已经不是我们感兴趣的事情了。”我们提出退还资金，并说：“我们要去开发消费级应用了，这是我们的几个想法。”结果没有一个投资者把钱拿回去。接下来的四五年里，我们开发了各种不同的消费级应用。在那期间我们取得了一些小成功。其中一个是叫 Five Labs 的应用，它读取你的 Facebook 帖子，根据你使用的语言判断你的性格。它使用的模型和后来的剑桥分析（Cambridge Analytica）一模一样，那个应用超级火，我记得有数千万份个人资料，三天之内就传疯了。

---

### [00:10:09] Nikita Bier

**English:**
We raised some more money based off the success of that and we started focusing a lot more on mobile after that first app, Five Labs. We launched basically every type of app you can imagine. We launched mapping apps, chat apps, event meetup apps. Basically, every consumer app on mobile that you could think of. That actually helped us build a muscle to understand what people want and how to actually make things grow and how to test them. Over time, we started focusing more on teens. A lot of people ask why Silicon Valley is so fixated on building apps for teens.

**中文翻译:**
基于那个应用的成功，我们又融了一些钱，并开始更加专注于移动端。我们几乎发布了你能想象到的所有类型的应用：地图应用、聊天应用、活动聚会应用。基本上你能想到的移动端消费级应用我们都做过。这实际上帮助我们锻炼了理解用户需求、如何实现增长以及如何测试产品的能力。随着时间的推移，我们开始更多地关注青少年。很多人问为什么硅谷如此痴迷于为青少年开发应用。

---

### [00:10:55] Nikita Bier

**English:**
One of the reasons is their habits are pretty malleable. As we get older, we get fixed into our habits of using certain communication products and we don't really adopt new things. Then the other thing that we discovered was that adults don't really invite people to new apps. We found that as a user got older from age 13 to 18, the number of people that they invite to an app just declines almost exponentially. Finally, and the most important thing is they see each other every day, and that is so critical. Consumer app developers sometimes say smokers are great for targeting an audience because they actually hang out serendipitously a lot outside of buildings. Not to say social apps are cigarettes, I don't really like that metaphor.

**中文翻译:**
原因之一是他们的习惯非常有可塑性。随着年龄增长，我们使用某些通讯产品的习惯会变得固定，不再接受新事物。另一个发现是，成年人不太会邀请别人使用新应用。我们发现，随着用户年龄从 13 岁增长到 18 岁，他们邀请的人数几乎呈指数级下降。最后，也是最重要的一点，他们每天都能见面，这至关重要。消费级应用开发者有时会说吸烟者是很好的目标受众，因为他们经常在建筑物外偶然聚在一起。我不是说社交应用是香烟，我不喜欢那个比喻。

---

### [00:11:50] Lenny Rachitsky

**English:**
Just on the note of you talking about why teens are important, I have this quote actually from you that I love where building on the point you made that for every social app I've ever built and the number of invitations sent per user drops 20% for every additional year of age from 13 to 18. If you build for adults, expect to acquire every user with ads, and I love that you have a very clear heuristic of per year, the amount of people they invite to the app is 20% lower.

**中文翻译:**
关于你提到的青少年为什么重要，我这儿有一段我很喜欢的你的原话，是对你刚才观点的补充：“在我构建的每一个社交应用中，从 13 岁到 18 岁，用户每增加一岁，人均发送的邀请数量就会下降 20%。如果你为成年人构建产品，那就做好用广告获取每一个用户的心理准备。”我非常喜欢你这个清晰的启发式结论：每大一岁，邀请人数就减少 20%。

---

### [00:12:18] Nikita Bier

**English:**
If your users aren't inviting people to your app, you're going to have to find another way to acquire them, and that most likely means ads. If you're targeting older cohorts like adults, you're going to have to raise a huge amount of venture capital to finance that user acquisition pipeline and it's going to be extraordinarily expensive. As a seed stage up, it's going to be basically impossible to grow that user base, especially to get density if you need actual network effects among users.

**中文翻译:**
如果你的用户不邀请别人，你就必须找其他方法获取用户，这通常意味着打广告。如果你针对的是成年人等年龄较大的群体，你就得筹集巨额风险投资来支撑用户获取渠道，而且成本会高得离谱。作为一家种子期公司，想要扩大用户群基本上是不可能的，尤其是如果你需要用户之间产生实际的网络效应，就更难达到所需的密度。

---

### [00:12:56] Lenny Rachitsky

**English:**
Basically, you're building this help me decide who to vote for app that turned into a real business with government contracts coming to you trying to help you, pushing you to build something that you end up realizing I don't want to be doing this. Why am I building this app selling government contracts. What you did is you, and this is a really interesting lesson to take away, is you just realized, I don't want to be doing this. Investors don't force me to be working on this. I'm going to stop this. I'm going to go work on some other stuff that I'm actually excited about that I think has a bigger chance of success. That's where you transition to this startup studio where you're just trying a bunch of apps and I think it was called Midnight Labs, you said, something like that, right?

**中文翻译:**
所以基本情况是，你做了一个“帮我决定投给谁”的应用，它变成了一个真正的业务，政府合同找上门来，推着你去做一些你最终意识到“我不想做”的事情。你问自己为什么要卖政府合同。你所做的——这是一个非常有趣的教训——就是意识到“我不想做这个，投资者也没强迫我做，我要停下来，去做一些我真正兴奋、且我认为成功机会更大的事情”。于是你转型到了一个初创工作室，尝试了一堆应用，我记得是叫 Midnight Labs，对吧？

---

### [00:13:34] Nikita Bier

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:13:34] Lenny Rachitsky

**English:**
Awesome. Basically, I think that's a really interesting insight of just like if you're working on something you don't enjoy, you can change that, you can pivot, you can tell your investors I want to work on something else. Is there anything there that you want to add along those lines?

**中文翻译:**
太棒了。这确实是一个很有趣的见解：如果你在做自己不喜欢的事情，你可以改变，可以转型，可以告诉投资者你想做别的。关于这一点你还有什么想补充的吗？

---

### [00:13:49] Nikita Bier

**English:**
It was really hard for us to pivot to mobile. I think that was one of the most challenging things for me personally because it was a completely different paradigm. I actually have been building web apps since I was 12 years old. I built a full e-commerce business selling pirated games on the web, and I knew everything about growing a website. As we pivoted to mobile, I had to recalibrate my whole brain on how to do that. Mobile apps have such a low margin for error when it comes to designing them. Because I have this dogmatic view that every tap on a mobile app is a miracle for you as a product developer because users will turn and bounce to their next app very quickly.

**中文翻译:**
转向移动端对我们来说非常困难。对我个人而言，这是最具挑战性的事情之一，因为这是一个完全不同的范式。我从 12 岁起就开始构建网页应用了，我曾建立过一个完整的电子商务业务，在网上卖盗版游戏，我非常了解如何让网站增长。当我们转向移动端时，我必须重新调整大脑。移动应用在设计上的容错率极低。我有一个近乎教条的观点：在移动应用上，用户的每一次点击对产品开发者来说都是一个奇迹，因为用户会非常快地流失并跳转到下一个应用。

---

### [00:14:46] Nikita Bier

**English:**
If you actually sit behind someone and watch them use their phone, they actually switch between apps at a pretty high frequency. Every tap that you get, every single one is so scarce that you should be optimizing everything. I had to change my whole brain when we started pivoting to mobile and building these mobile apps, and it took a lot of failures. 14 of the apps that we launched were basically duds, and then we started fixating on teens and building apps for them. Eventually, we figured out an interesting heuristic for identifying consumer product opportunities that ultimately led us to tbh.

**中文翻译:**
如果你坐在某人身后观察他们玩手机，你会发现他们切换应用的频率非常高。你获得的每一次点击都是如此稀缺，以至于你应该优化每一个细节。当我们开始转向移动端并构建这些应用时，我不得不彻底改变思维方式，这经历了许多失败。我们发布的 14 个应用基本上都失败了，然后我们开始专注于青少年并为他们开发应用。最终，我们找到了一种识别消费级产品机会的有趣方法，这最终引导我们做出了 tbh。

---

### [00:15:27] Lenny Rachitsky

**English:**
You spent four or five years trying a bunch of different ideas. I think people see this headline and we'll get into tbh of just like nine weeks after launch sells for $30 million to Facebook and everyone's like, "Oh, okay, that's amazing. I want that for my life." Nobody knows there's this four or five years of trying, you said 15 different apps before you got there, learning the things that actually work and don't work.

**中文翻译:**
你花了四五年的时间尝试各种不同的想法。我想人们看到头条新闻——我们待会聊 tbh——说发布九周后就以 3000 万美元卖给了 Facebook，大家都会想：“哇，太棒了，我也想要这种生活。”但没人知道在那之前有四五年的尝试，你说过在成功之前做了 15 个不同的应用，去学习哪些行得通，哪些行不通。

---

### [00:15:49] Nikita Bier

**English:**
We built 15 apps over the course of that pivot to consumer, and we built apps for every single app, map apps, chat apps, to-do lists. We just built every type of consumer app you could possibly think of. Also, we built for every audience too. We built for college students, we built for post-college. It was always very difficult to get the flywheel spinning for anyone after like 22 years old. That was the cutoff of when people just give up on adopting new products. It took us a few years to really internalize that, a lot of failures to realize no one needs another app after that age.

**中文翻译:**
在转向消费级产品的过程中，我们构建了 15 个应用，涵盖了所有类型：地图、聊天、待办事项。只要你能想到的消费级应用，我们都做过。而且我们也针对各种受众：大学生、职场新人。但我们发现，对于 22 岁以上的人，很难让增长飞轮转动起来。22 岁似乎是一个分水岭，过了这个年纪，人们就不再愿意尝试新产品了。我们花了好几年时间，经历了许多失败，才真正内化了这一点：那个年龄之后，没人再需要另一个新应用了。

---

### [00:17:04] Lenny Rachitsky

**English:**
The thing that you found there, which is really interesting because most people are building for people older than 22, that's a profound insight you had there. Every consumer app I see is trying to build for adults, and your lesson there is basically if you're trying to do that, you're probably going to need to raise money and spend a lot of money on paid ads.

**中文翻译:**
你的发现非常有趣，因为大多数人都在为 22 岁以上的人开发产品，这是一个深刻的洞察。我看到的每个消费级应用都在试图吸引成年人，而你的经验是：如果你打算这么做，你可能需要融资并花大量的钱打广告。

---

### [00:17:44] Nikita Bier

**English:**
Most likely, you'll never get network effects. There's actually an interesting study many years ago that some academics in Spain did, I think it was in Spain, and they looked at how many people you text per year of your life, and it goes up very quickly from 14 to 18. It peaks around 21, so it's growing. The number of people you text is growing up until about 21, and then it just falls, it collapses, and then it comes back up at end of life. There's a few reasons all this happens, but basically, once you exit college, you reduce the number of contacts, your daily contacts.

**中文翻译:**
而且很可能你永远无法获得网络效应。多年前西班牙的一些学者做过一项有趣的研究，他们观察了人一生中每年发短信的人数：从 14 岁到 18 岁增长非常快，在 21 岁左右达到顶峰。也就是说，发短信的人数在 21 岁之前一直在增加，然后就开始暴跌、崩溃，直到生命末期才会再次回升。这背后有几个原因，但基本上，一旦你大学毕业，你的日常联系人数量就会减少。

---

### [00:17:48] Nikita Bier

**English:**
Once you get married, it's even fewer. Then as you get older and your kids start having kids and you become a grandparent, you start texting again more or you join a retirement home. If you're building a product with network effects that's a communication tool, you want to be on that upward curve of adding connections to your social graph because then the urgency to connect is higher. If you really want to actually innovate at the edges of communication products, you really have to target that cohort that has the highest urgency to communicate, and that's teens.

**中文翻译:**
一旦结婚，联系人就更少了。然后随着年龄增长，你的孩子有了孩子，你成了祖父母，你又开始多发短信了，或者你进了养老院。如果你正在构建一个具有网络效应的通讯工具，你希望处于社交图谱连接增加的上升曲线上，因为那时连接的紧迫感更高。如果你真的想在通讯产品的边缘进行创新，你必须瞄准那些沟通紧迫感最强的群体，那就是青少年。

---

### [00:18:28] Lenny Rachitsky

**English:**
I love that you found these things out, not through just research and not through just thinking, it was through actual trying things over and over and over and trying different audiences, trying different experiences. A lot of people see your advice and they're like, "How does he know?" It's just you've done all these things yourself. You've seen them, you're sitting there watching teens use these apps. I think very few people actually do that, and they just come up with these theories that aren't based in empirical evidence.

**中文翻译:**
我喜欢你发现这些结论的方式，不是通过研究或空想，而是通过一次又一次的实际尝试，尝试不同的受众和体验。很多人看到你的建议会问：“他怎么知道的？”其实就是因为你亲手做过。你亲眼见过，你坐在那儿观察青少年如何使用这些应用。我觉得很少有人真正这样做，他们只是提出一些并非基于经验证据的理论。

---

### [00:18:55] Nikita Bier

**English:**
We got pretty good at building these apps. I think our first mobile app took us about a year, and then our last one took us about two weeks. We also got very good at testing apps. The most important thing that I often instruct teams to do is to develop a reproducible testing process, and that will actually influence the probability of your success more than anything. It's so unpredictable whether a consumer product idea will work. If you actually focus more on your process for taking many shots at bat, that's what actually reduces the risk more than anything. We figured out ways to seed apps into schools. We also, during the course of that company, we figured out how to seed it into affinity groups, hobbyists, things like that. We were on app number 15, a lot of failures during the course of this company, and I remember a lot of our team members were like, "I kind of want to leave. I think this is it for me."

**中文翻译:**
我们变得非常擅长构建这些应用。我记得第一个移动应用花了大约一年时间，而最后一个只用了两周。我们也变得非常擅长测试应用。我经常指导团队做的最重要的事情就是开发一套可重复的测试流程，这比任何事情都更能影响你成功的概率。消费级产品的创意是否行得通是极难预测的。如果你能专注于增加尝试的次数（shots at bat），这才是降低风险的关键。我们找到了将应用植入学校的方法。在那家公司期间，我们也学会了如何将其植入兴趣小组、爱好者群体等。当时我们做到了第 15 个应用，公司经历了很多失败，我记得很多团队成员都想离开了，觉得到此为止了。

---

### [00:20:08] Nikita Bier

**English:**
One of our key team members actually put in their two weeks' notice. The day before we launched our final app, we were getting kind of low on money. I was tired. I called our lawyer to ask, how do you dissolve a company? I messaged a few mentors saying like, one people that have been through it, and I said, "What are the steps to do this?" Then I had a conversation on the way out with that team member that wanted to leave, and I said, "I understand, but what if the app actually starts charting on the App Store?" He said, "What are the chances of that? You know that's not going to happen." I said, "Sure, okay." We launched this app and it was a polling app, tbh, and it immediately took off in the school that we seeded it into, in Georgia. We picked the one school that had the earliest start date in the United States because we needed to launch as soon as possible, given the state of the company.

**中文翻译:**
我们的一位核心成员甚至递交了辞职信。在发布最后一个应用的前一天，我们的资金快耗尽了。我很累，打电话给律师问怎么注销公司。我给几位经历过这些的导师发消息问注销的步骤。然后我和那位想离开的成员聊了聊，我说：“我理解，但如果这个应用真的冲上了 App Store 排行榜呢？”他说：“那几率有多大？你知道那不会发生的。”我说：“好吧。”接着我们发布了这个叫 tbh 的投票应用，它在我们植入的佐治亚州那所学校立刻火了。我们选了全美开学最早的一所学校，因为考虑到公司的财务状况，我们需要尽快发布。

---

### [00:21:26] Nikita Bier

**English:**
I think it spread to 40% of the school downloaded it in the first 24 hours and it rapidly spread to the neighboring schools. Suddenly, I was like, "Oh, we might have something here." Servers started crashing and watching it climb the charts. I looked at our numbers and I'm like, "We will be number one in the United States in six days." Then I looked at our Amazon bill and it was like 120,000. I looked at our bank account, it said 150,000. I'm like, "Okay, these two numbers don't really..." I quickly had to put together a funding round and I told my team, "Can you guys just pause for two months and just really focus on this? I think I could probably sell this thing." It turned into a pretty competitive bidding process, actually. There was a really, really great moment where there was one of the acquirers, or one of the bidders was based in LA, had told me to fly down, and they told me to fly down that day.

**中文翻译:**
我记得前 24 小时内全校 40% 的人都下载了，并迅速蔓延到邻近学校。突然间我觉得：“噢，这可能有戏。”服务器开始崩溃，我看着它在排行榜上攀升。我看了看数据说：“六天内我们会成为全美第一。”然后我看了看亚马逊（AWS）的账单，大约 12 万美元，再看银行账户，只有 15 万美元。我心想：“好吧，这两个数字不太妙……”我不得不迅速组织一轮融资，并告诉团队：“你们能不能先停下离职的念头，专注做两个月？我觉得我能把这公司卖掉。”事实上，后来演变成了一场相当激烈的竞购。有一个非常精彩的时刻，其中一个位于洛杉矶的竞购者让我当天飞过去。

---

### [00:22:40] Nikita Bier

**English:**
I got on a plane, went to the airport without a ticket, showed up. When we were rolling out this app, we were doing a state-by-state rollout strategy where every state was geo-fenced. We hadn't launched California until that morning. I arrived at this company, this founders in LA's house, and he said, "Show me the metrics. You guys are like, what? Number four or something?" Since we just launched California, it's a big state. I said, "No, we're actually number one. We're the number one app in the United States." He said, "Show me the metrics." Our CTO, Erik Hazzard, is a published author in mapping. He created an amazing dashboard that could show real-time installs on a map. It was around 4:00 PM and school had just gotten out, so I zoomed in on the block that we were having that meeting, and the entire block was lit up with installs all around us. Then that's what got the ball rolling on a... It was a really, really like, cinematic moment of showing something that you created that literally just took over the entire neighborhood around you.

**中文翻译:**
我没买票就冲到机场上了飞机。当时我们推行的是逐州发布的策略，每个州都有地理围栏。那天早上我们才刚刚开放加利福尼亚州。我到了洛杉矶那位创始人的家，他说：“给我看看数据。你们现在排第几？第四左右？”因为加州是个大州，我说：“不，我们实际上是第一，全美排名第一的应用。”他说：“给我看数据。”我们的 CTO Erik Hazzard 是地图领域的专家，他开发了一个惊人的仪表盘，可以在地图上显示实时安装情况。当时大约下午 4 点，学校刚放学，我放大到我们开会所在的那个街区，整个街区都被周围的安装点亮了。那一刻真的非常有电影感——你展示了你创造的东西，而它正实时占领你周围的整个社区。

---

### [00:24:02] Lenny Rachitsky

**English:**
That's insane. That's going to be in the movie of Nikita Bier in the future. A couple of questions here. One, you predicted the chart, you would hit number one. What does it take to hit number one? What is the number you're looking at? Is it some number downloads to get to number one in the App Store?

**中文翻译:**
太疯狂了。这以后肯定会出现在 Nikita Bier 的传记电影里。我有几个问题。第一，你预测会冲上榜首。那么冲上榜首需要什么条件？你看的是什么数据？在 App Store 拿到第一需要多少下载量？

---

### [00:24:17] Nikita Bier

**English:**
It fluctuates. It used to be like 80 to 100,000 installs, but now you have these companies that are just spending extraordinary amounts on ads and or injecting it into one of their other apps. Between Threads, Temu and all these other apps that are spending on acquisition and all that, some days it's up to 300,000.

**中文翻译:**
这个数字是波动的。以前大约是 8 万到 10 万次安装，但现在有些公司在广告上投入巨资，或者把新应用强推到他们已有的其他应用里。在 Threads、Temu 以及所有这些砸钱买量的应用竞争下，有些日子需要达到 300,000 次安装才能拿第一。

---

### [00:24:40] Lenny Rachitsky

**English:**
That's per day?

**中文翻译:**
是每天吗？

---

### [00:24:41] Nikita Bier

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:24:42] Lenny Rachitsky

**English:**
Oh, man. Amazing.

**中文翻译:**
天呐，太惊人了。

---

### [00:24:43] Nikita Bier

**English:**
At the peak of tbh, we were getting 360,000 per day.

**中文翻译:**
在 tbh 的巅峰时期，我们每天有 36 万次安装。

---

### [00:24:50] Lenny Rachitsky

**English:**
The other two things I want to spend a little time on here before we move on to the next app is, what was the insight that helped you come up with this is a big idea that we should try? Then what was the insight into how to spread this so virally? I know that one is really close.

**中文翻译:**
在聊下一个应用之前，我还想花点时间聊两件事：第一，是什么洞察让你觉得这是一个值得尝试的大创意？第二，关于如何让它实现病毒式传播，你有什么洞察？我知道这部分非常巧妙。

---

### [00:25:04] Nikita Bier

**English:**
After building all these apps, we had these kind of lingering users that stuck around and would share feedback with us on our next app. And so there were a couple, like there's a senior in high school that I would send screenshots of our products. He told me about this trend called TBH that kids were playing on Snapchat, where they would post an image of a bunch of emojis and it would say like, "I like you. Your smart. Your style is great." And you would just reply to the story with the emoji of what you felt. And I was like, "This is kind of weird. You post this on your story and then people send you feedback." And I'm like, "So teens are looking for this vehicle for disclosure essentially." And I'm like, "That's kind of cool. I wonder if you could make that into an app." We had sketched some things out. As we were sketching things out, I looked on the app store, and the number one app in the United States was an app called Sarahah. It was for sending anonymous messages by adding a link to your Snapchat story.

**中文翻译:**
在做了这么多应用后，我们有一些忠实用户会留下来为我们的下一个应用提供反馈。比如有个高中生，我会发产品截图给他。他告诉我 Snapchat 上流行一种叫 “TBH”（To Be Honest，说实话）的游戏，孩子们会发一张带有一堆表情符号的图片，上面写着“我喜欢你”、“你很聪明”、“你的风格很棒”，然后你用表情符号回复这个故事来表达你的感受。我觉得这挺奇怪的，你发动态，然后别人给你反馈。我意识到，青少年其实在寻找一种“自我表露”的载体。我觉得这很酷，想知道能不能把它做成应用。我们画了一些草图。就在那时，我看到 App Store 全美排名第一的是一个叫 Sarahah 的应用，它是通过在 Snapchat 故事里添加链接来发送匿名消息的。

---

### [00:26:17] Nikita Bier

**English:**
But the thing that was most interesting was the entire app was in Arabic. The number one app in the United States was in Arabic. And that was one of the most strongest signal that you could ever have that people want something. And so when I meet with founders, I often tell them like, "The way you should be searching for product ideas is this concept of latent demand where people are trying to obtain a particular value and going through a very distortive process to obtain that value." And if you can actually crystallize what their motivation is and build a product around and clear up what they're trying to actually do, you can have this kind of intense adoption.

**中文翻译:**
但最有趣的是，那个应用整个界面都是阿拉伯语。美国排名第一的应用居然是阿拉伯语的！这是你能得到的最强烈的信号，说明人们极度渴望某种东西。所以我见到创始人时常说：“寻找产品创意的方法应该是寻找‘潜在需求’，即人们为了获得某种价值而不得不经历一个非常扭曲的过程。”如果你能提炼出他们的动机，围绕它构建产品，并简化他们想做的事情，你就能获得这种爆发式的用户增长。

---

### [00:27:11] Nikita Bier

**English:**
When we saw what people were doing with Sarahah, I also looked at some of the tweets and comments on it. A lot of people were receiving negative messages. And so what I saw with the game that kids were playing on Snapchat TBH and then Sarahah, I realized just people want to know good things about themselves and that they don't want these bullying messages that they're getting on these anonymous apps, and I was like, "Well, what if instead of actually typing what you wanted to say about somebody, you just answered polls and we authored those polls so that we ensured everything would always be positive?"

**中文翻译:**
当我们看到人们如何使用 Sarahah 时，我也看了一些推特评论。很多人收到了负面消息。结合 Snapchat 上的 TBH 游戏和 Sarahah，我意识到人们只是想听到关于自己的好话，他们不想要匿名应用里那些霸凌信息。于是我想：“如果不是让用户自己打字，而是让他们回答我们预设的投票，并确保所有选项都是正面的呢？”

---

### [00:27:51] Nikita Bier

**English:**
I mean, in the back of my head, I always knew anonymous apps go viral, but they always lead to these awful news stories of kids committing suicide, self-harm and all that. And so I was like, "I'll never build anything like that." But when we came up with this new mechanic where you could only say positive things through polls, who has the best smile, who's most likely to be president, and then you receive it as anonymous, but your name is selected, what we discovered a couple of things is it made users feel a lot better. It actually solved what they were trying to do and they also sent a much higher volume of messages. And so it was literally explosive adoption.

**中文翻译:**
我心里清楚匿名应用容易走红，但它们总会导致那些可怕的新闻，比如自杀、自残等。所以我曾发誓绝不做那样的东西。但当我们设计出这种只能通过投票说好话的新机制时——比如“谁的笑容最美”、“谁最可能当总统”——你收到的是匿名的赞美，但你的名字是被选中的。我们发现这让用户感觉好多了，它真正解决了他们的需求，而且消息发送量也大得多。这真的是爆发式的普及。

---

### [00:28:35] Nikita Bier

**English:**
One school I was looking at, they sent 450,000 messages in the first seven days of adopting it. And when you look at day one volume of messages sent on a messaging app, you're lucky if people send three or four or something, but we were sending 60 and we couldn't even handle it, so we had to geofence the app because we needed to scale our servers, which is actually a pretty controversial decision inside of our company, because why would you turn off something that's working? But at my core, I knew if it's working at this many individual schools, we could just relaunch it any time and it'll go viral. So let's regroup and figure out what's happening here and then relaunch.

**中文翻译:**
我观察的一所学校，在使用的前七天就发送了 45 万条消息。通常通讯应用的第一天，人均能发三四条就不错了，但我们当时人均发 60 条，服务器根本扛不住。所以我们不得不对应用设置地理围栏（暂停部分地区使用）来扩容服务器。这在公司内部很有争议，因为为什么要关掉一个正火的东西？但我核心的判断是：如果它在这么多学校都行得通，我们随时可以重新发布并再次走红。所以先稳住，搞清楚状况再重新发布。

---

### [00:29:27] Lenny Rachitsky

**English:**
So you keep talking about how went viral and crazy, grew like crazy. I know that there's a little trick that you came up with to help it spread. Can you just briefly talk about what you did there and to help it spread so quickly within a school?

**中文翻译:**
你一直在说它是如何疯狂走红和增长的。我知道你发明了一个小技巧来帮助它传播。你能简要聊聊你是怎么做的，让它在学校里传播得那么快吗？

---

### [00:29:37] Nikita Bier

**English:**
I think you're referring to, there's a memo that was leaked to BuzzFeed while I was at Facebook. The main thing we found was like, to be convinced to download an app, you need to see it. You need to see the marketing message three times or so. So you basically need to saturate an area with every kind of marketing you can. So we ran ads targeted at a particular school to when we were seeding and testing these apps. And we also followed people creating a dedicated Instagram account that went to that school, because we learned that high schoolers identify their school in their bio, so it says RHS on their bio. And so that was how we tried to get the entire school to adopt synchronously. We'd follow them and then accept the followbacks.

**中文翻译:**
我想你指的是我在 Facebook 期间被泄露给 BuzzFeed 的那份备忘录。我们发现，要说服一个人下载应用，他需要看到营销信息大约三次。所以你基本上需要用各种营销手段“淹没”一个区域。在种子期测试时，我们会针对特定学校投放广告。我们还会创建一个专门针对该校的 Instagram 账号去关注学生，因为我们发现高中生喜欢在个人简介里写上学校缩写（比如 RHS）。通过这种方式，我们试图让全校同步使用。我们会关注他们，然后通过他们的回关请求。

---

### [00:30:36] Nikita Bier

**English:**
Big misunderstanding though, and I get this DM a lot of people are like, "I'm trying to replicate your strategy. We've just done it at 15 schools and it's not working anymore." This is not the way we grew the app. This is how we tested apps. Really, it's a little bit nuanced there. That's an important nuance because you need to get enough intensity of adoption and density for a social network to start to get the flywheel spinning, but the app should grow by itself after that. And people think we just went from school to school following every kid on it. You can't, that's totally unrealistic. But for the first 100 users, yes, that's how we got them. And that allowed us to know whether the product was working or not. We could get enough people on it and then we could, with conviction, say that whether the app had legs and we wouldn't have this kind of uncertainty like, "Oh, did they add enough friends? Did we get enough people on it? Did they reach the aha moment because you need friends to get on?"

**中文翻译:**
不过这里有个很大的误解，我经常收到私信说：“我试着复制你的策略，在 15 所学校都做了，但没用。”这不是我们让应用增长的方式，这是我们测试应用的方式。这之间有细微的差别。这种差别很重要，因为你需要足够的采用强度和密度来让社交网络的飞轮转起来，但之后应用应该能自动增长。人们以为我们是一家家学校跑，关注每个孩子，这不现实。但对于前 100 个用户，是的，我们是这么做的。这让我们能判断产品是否有效。一旦有了足够的人，我们就能确信应用是否有生命力，而不会陷入这种不确定性：“噢，他们加的朋友够多吗？人够多吗？他们达到‘惊喜时刻’（aha moment）了吗？”

---

### [00:31:41] Nikita Bier

**English:**
So we wanted to eliminate that confounding variable, and so we figured out a way to just get a bunch of people to adopt at once. And that's one thing I encourage a lot of founders to do, is figure out a way to eliminate all those potentially confounding variables so you can know immediately whether something's working or not. You never want to walk away from an experiment or test and say, "Well, maybe the execution was bad because it takes a lot of energy to mobilize a team to test something," and you really want to make sure your tests actually provide signal.

**中文翻译:**
所以我们想消除那个干扰变量，于是想办法让一群人同时使用。这是我鼓励很多创始人去做的一件事：想办法消除所有潜在的干扰变量，这样你就能立即知道某件事是否奏效。你绝不希望在实验或测试结束后说：“嗯，也许是执行得不好”，因为动员团队去测试某件事需要耗费大量精力，你必须确保你的测试能提供明确的信号。

---

### [00:32:18] Lenny Rachitsky

**English:**
So your advice here is when you're testing something, test the best possible version of what that could be, whether it takes manual work or something that is never going to scale, test the ideal. Because that'll tell you, " Even if this could be the best possible version, do people actually care?"

**中文翻译:**
所以你的建议是：在测试某样东西时，要测试它可能达到的最佳版本，哪怕需要人工操作或者根本无法规模化，也要测试那个理想状态。因为这会告诉你：“即使这是最好的版本，人们真的在乎吗？”

---

### [00:32:34] Nikita Bier

**English:**
Yeah, we would try to get an entire school to adopt, just to know if everyone had 10 friends, would they actually derive value from this app? We also did other things, and I recommend all companies do this, is put live chat customer support in your app 24 hours a day. It sounds insane. It's like the whole point of tech is you don't need to do that. That's the whole point of a software. But then users get this white glove experience, and that eliminates another confounding variable, like did they think their problems were solved or they were treated well? But most of all, one of the reasons I actually recommend people put live chat in their app is it's the best vehicle for getting feedback and doing user research because users will literally tell you the problem they're having. So we had our person that was running this. He's name is Michael Gutierrez. He's done it for all my companies actually. He's the community and customer support rep. He would paste any interesting feedback into Slack and then we would be like, "Oh, this user has a great idea. We should consider turning that into a feature." So you really want your finger on the pulse as you roll these things out so you can get a sense for what's working, what isn't, and also make users feel great and make sure at the end they promote your app positively to their peers.

**中文翻译:**
是的，我们会尝试让全校都使用，只是为了知道如果每个人都有 10 个朋友，他们是否真的能从这个应用中获得价值。我们还做了其他事情，我建议所有公司都这么做：在应用中加入 24 小时在线客服。这听起来很疯狂，毕竟技术的初衷就是不需要人工。但这样用户就能获得“白手套”级别的体验，这消除了另一个干扰变量——即他们是否觉得问题得到了解决或受到了良好对待。最重要的是，我推荐在线客服的原因是它是获取反馈和进行用户研究的最佳工具，因为用户会直接告诉你他们遇到的问题。我们有一个专门负责的人叫 Michael Gutierrez，他实际上为我所有的公司都做过这个。他会把任何有趣的反馈粘贴到 Slack 里，然后我们会说：“噢，这个用户有个好主意，我们应该考虑把它做成功能。”在推广时，你真的需要时刻掌握脉搏，了解什么是有效的，什么是无效的，同时让用户感觉很棒，确保他们最后会向同龄人积极推荐你的应用。

---

### [00:34:09] Lenny Rachitsky

**English:**
I love that piece of advice. (00:34:11): Okay, so to close out the TBH chapter, is there anything else that you think is important for people to know or any other lasting lessons from that part of your journey that you bring with you to new apps that you're building today?

**中文翻译:**
我非常喜欢这个建议。好，在结束 tbh 这个章节之前，你觉得还有什么重要的事情是大家需要知道的，或者那段经历中有哪些持久的教训是你带到今天正在开发的新应用中的？

---

### [00:34:25] Nikita Bier

**English:**
I think the thing that is hard to really understand for first-time founders that hit breakout success with a consumer product is how draining and how spread thin you get, because everything breaks. Everything that you built needs to be substituted almost every three days. I can just give you an example. We were just talking about this customer support system that we had. The first system broke after three days. The next one broke seven days later, we had to replace it with a different one that could scale even better. And if you think about that on every dimension of the company, it is absolute chaos to keep the thing online as it scales up. And so you have to be ruthless with prioritization as something scales up and put out the largest fires first, because that was something that I didn't really fully understand, is how many things go wrong. And if we didn't geofence the app, there would be no way we would've been able to keep that thing online because that gave us some slack to control growth.

**中文翻译:**
我认为对于第一次获得爆发式成功的消费级产品创始人来说，最难理解的是你会变得多么疲惫和分身乏术，因为一切都会崩溃。你构建的每样东西几乎每三天就需要更换一次。举个例子，刚才提到的客服系统，第一个系统三天就崩了，下一个七天后也崩了，我们不得不换一个扩展性更好的。如果你考虑到公司的每一个维度，在规模扩大时维持在线简直是一场混乱。所以你必须在规模扩大时冷酷地确定优先级，先扑灭最大的火。我以前没完全意识到会有这么多事情出错。如果我们当时没有设置地理围栏，根本无法维持在线，因为地理围栏给了我们控制增长的余地。

---

### [00:35:55] Lenny Rachitsky

**English:**
This is a good example of when people ask like, "Hey, does my app have product-market fit?" I think this is an example of this is what it looks like when things are breaking every three days when you have to geofence it to keep it from crashing.

**中文翻译:**
这是一个很好的例子。当人们问“我的应用达到产品市场匹配（PMF）了吗？”时，这就是 PMF 的样子：每三天就有东西崩溃，你不得不限制增长来防止它彻底瘫痪。

---

### [00:36:06] Nikita Bier

**English:**
A lot of people ask me like, "What's the benchmark for product-market fit?" And this founder that I'm friends with, his name's Roger Dickey, he told me this one time, "If your product's working, you'll know. And if there's any uncertainty, it's not working." And it really is a binary when it comes to consumer products. People are going to be fighting to get into it and you'll find new measures that you've never heard of like, "Our metric was hourly actives per day." Not daily active users, hourly active users. So you'll start seeing that and it'll be abundantly obvious what product-market fit is. You'll know it when you see it is the bottom line.

**中文翻译:**
很多人问我 PMF 的基准是什么。我的朋友、创始人 Roger Dickey 曾告诉我：“如果你的产品奏效了，你会知道的；如果有任何不确定，那就是没奏效。”对于消费级产品来说，这真的是非黑即白的。人们会争先恐后地使用它，你会发现一些从未听过的新指标，比如我们当时的指标是“每日每小时活跃用户”，而不是日活。当你看到这些数据时，PMF 就会变得显而易见。底线就是：当你看到它时，你就知道了。

---

### [00:36:59] Lenny Rachitsky

**English:**
Okay, so you launch TBH, it goes viral, start getting offers from companies. Nine weeks later after launch, you end up selling it to Facebook. What was it like selling your company and then what was it like working at Facebook? Which you worked at for four years. I was not expecting that when I was looking at your LinkedIn. So yeah, what was it like selling? What was it like working at Facebook?

**中文翻译:**
好，你发布了 tbh，它走红了，开始收到公司的报价。发布九周后，你把它卖给了 Facebook。卖掉公司的感觉如何？在 Facebook 工作的感觉又如何？我看你领英发现你在那儿干了四年，这真让我意外。所以，卖公司和在 Facebook 工作是什么体验？

---

### [00:37:22] Nikita Bier

**English:**
Selling your company is one of the most draining processes you could ever go through as a founder. When we met with Facebook, they told me they have 80 people assigned to this deal. And I'm like, I have one person, it's just me. They were like the SWAT team of M&A. The funniest part was they wanted to meet the team as well. And so they came out to our office in Oakland, which is a dingy old office that I got for $1,800 a month. That was our rent for the office. They arrive and they walk in. There's two engineers and one designer and me, and they're just like, "This is the whole company? This is the number one app in the United States?" I'm like, "Yeah, this is it." And when we went there, when we arrived, we joined the youth team, which was about, I don't know, 150 people just for this one division of Facebook. It was my first job effectively that I've ever had.

**中文翻译:**
卖掉公司是创始人能经历的最耗费精力的事情之一。当我们见 Facebook 时，他们告诉我他们为这笔交易指派了 80 个人。而我心想，我只有一个人，就是我自己。他们就像是并购界的特种部队。最搞笑的是他们想见见团队，于是来到了我们位于奥克兰的办公室——那是一个我每月花 1800 美元租下的阴暗旧办公室。他们走进来，看到只有两个工程师、一个设计师和我，他们惊呆了：“这就是全公司？这就是全美排名第一的应用？”我说：“对，就这些。”我们加入后进入了青少年团队，仅 Facebook 的这一个部门就有大约 150 人。这实际上是我人生中第一份正式工作。

---

### [00:38:31] Nikita Bier

**English:**
When they told me my title, they said I would be a product manager, I was like, "Okay, I don't know exactly what that is, but yeah, I guess that's what I do." I arrive and then I get access to a workplace system where people post all the things they're working on, and I realized it's kind of like this almost academic environment for social networks, like social network development. It's like the Harvard of social networks. I was reading all these studies that people were doing on like, "Oh, if we change that, this is the impact to retention and DAU." I was so impressed, like, "There's a whole science here." A lot of the stuff that we did was learned from first principles, but then we saw it actually turn into systems and processes here.

**中文翻译:**
当他们告诉我职位是“产品经理”时，我说：“好吧，我不太清楚那具体是干嘛的，但我想那就是我做的事吧。”我进去后获得了内部系统的访问权限，看到大家发布的各种项目，我意识到这简直像是一个关于社交网络的学术环境。它就像是社交网络界的哈佛。我读了所有这些研究，比如“如果我们改变那个，对留存和日活会有什么影响”。我印象非常深刻，心想：“这居然是一门科学。”我们以前做的很多事是基于第一性原理摸索的，而在这里，它们变成了系统和流程。

---

### [00:39:20] Nikita Bier

**English:**
But the thing I didn't realize as a product manager in a large tech company is there is very little product management that you do. You're actually not as involved in the product as I had assumed. I thought, "Oh, you're the person who gets in the pixels and designs the flows." Absolutely not. You're completely detached from the design process. There's a design vertical org that does all that and they don't really want you working on that. So that was very difficult for me because when people ask me like, "What do you think you're good at?" At the core, I'm a designer. I don't consider myself a product manager. I'm great at growing things, looking at mixed panel and then designing the things that make it grow. But there's a rift between those two things inside of a large tech company.

**中文翻译:**
但我没意识到的是，在大科技公司当产品经理，你其实很少做真正的产品管理。你对产品的参与程度远低于我的预期。我原以为：“噢，你就是那个钻研像素、设计流程的人。”完全不是。你与设计过程完全脱节。有一个专门的设计部门负责所有这些，他们并不真的希望你插手。这对我来说非常困难，因为当人们问我擅长什么时，我的核心身份是设计师。我不认为自己是产品经理。我擅长让事物增长，分析数据，然后设计出能促进增长的东西。但在大科技公司内部，这两者之间存在裂痕。

---

### [00:40:27] Nikita Bier

**English:**
And so I loved the academic approach to growing, but it was really hard for me personally as I became disconnected from the design process. I think that a lot of my skills atrophied over those four years. But I did stick around. I went through multiple orgs. Favorite one at the end was new product experimentation where I worked with other founders, a bunch of legends in Silicon Valley, building zero to one products, standalone apps. I mean, I was building standalone apps my entire time at Facebook. I think I built probably eight apps while I was at Facebook.

**中文翻译:**
所以我喜欢那种学术化的增长方法，但由于脱离了设计过程，我个人感觉很痛苦。我觉得在那四年里，我的很多技能都萎缩了。但我还是坚持了下来，换了几个部门。最后我最喜欢的是“新产品实验部”（NPE），在那里我与硅谷的一群传奇创始人们一起工作，构建从 0 到 1 的产品和独立应用。其实我在 Facebook 的整个期间都在构建独立应用，我想我大概做了八个应用。

---

### [00:41:11] Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:41:12] Nikita Bier

**English:**
But it is much, much more difficult to build apps at a large company. A lot of the insights that you have are not things that you can necessarily present or put in writing in a VP meeting, like, " We're building an app for teens to flirt." That probably is not what you would present to a bunch of McKinsey consultants at. So I think that makes it really difficult to be completely intellectually honest about what you're building. And when the team isn't honest about it, then it's really hard to iterate toward the right thing in that context. Having said that, there's a lot of things you don't have to deal with as a product... I don't have to deal think about money, I don't have to think about paying legal bills or doing finance and accounting. So all that's abstracted away, but there is regulatory stuff that you have to deal with that I had zero exposure to as a founder of a small company.

**中文翻译:**
但在大公司开发应用要难得多。你的很多洞察不一定能在副总裁（VP）会议上展示或写进文档，比如“我们正在做一个让青少年调情的应用”。你大概不会对着一群麦肯锡顾问展示这种东西。所以我认为这让你很难对所构建的东西保持完全的“智识诚实”。如果团队不能诚实面对，就很难在那种环境下迭代出正确的东西。话虽如此，作为大公司的 PM，有很多事你不需要操心……我不需要考虑钱，不需要付律师费，也不需要做财务会计。这些都被抽象掉了，但你必须处理监管事务，而这在我作为小公司创始人时是完全没接触过的。

---

### [00:42:37] Nikita Bier

**English:**
An insight you're sharing there potentially is the reason a company like Facebook isn't amazing at launching completely new product, zero to one stuff, is they might be a little too risk averse and it's hard to talk about stuff that people actually really, really want deeply. Is that kind of the sense there?

**中文翻译:**
你分享的一个洞察可能是：像 Facebook 这样的公司不擅长发布全新的、从 0 到 1 的产品，是因为他们可能有点太厌恶风险了，而且很难公开讨论那些人们内心深处真正渴望的东西。是这个意思吗？

---

### [00:42:37] Nikita Bier

**English:**
It's hard to really verbalize some of the things that motivate us as people. There's a tweet I put out that's kind of dogmatic in terms of how I view why people download apps and it's very simple. It's like people download apps to make or save money. Examples of that might be like WhatsApp, where free texting. And then the other reason is to find a mate, so maybe like Tinder or Snapchat, find love. And the third is to unplug from reality maybe like Netflix or Fortnite. There's a bunch of other kind of subcategories that are very utilitarian like movement, Uber or Airbnb, like shelter. And so I think putting that in a framing document and the particular nuanced reason why people are going to adopt is difficult when you're presenting that to people that are seasoned professionals and care about how something might reflect on them personally.

**中文翻译:**
很难真正用语言表达出驱动人类的一些动机。我发过一条推特，表达了我对人们为什么下载应用的看法，非常简单：人们下载应用是为了赚钱或省钱（比如 WhatsApp 免费发短信）；或者是为了找伴侣（比如 Tinder 或 Snapchat 寻找爱情）；第三是为了逃避现实（比如 Netflix 或《堡垒之夜》）。还有一些非常实用的子类别，比如出行（Uber）或住宿（Airbnb）。我认为，当你向那些资深专业人士展示时，很难在框架文档中写明这些微妙的、人性化的采用原因，因为他们更在乎这些东西会如何影响他们的个人形象。

---

### [00:43:51] Nikita Bier

**English:**
And so that's really difficult inside of a large company. You'd certainly have distribution advantages. If you want to just inject your app into one of the parent apps and get density within a community, you could do that. But that part I think is probably solvable for a startup if you just want to pay for ads. Getting your app into a dense friend graph is overall trivial. As a founder, you should be able to pull it off after enough tries. So that advantage that a big company brings, I mean it makes it easier, but it's not something that I think is something that a founder can't solve for themselves.

**中文翻译:**
所以在大型公司内部这非常困难。你确实有分发优势，如果你想把应用强推到某个母应用里，在社区内获得密度，你可以做到。但我觉得对于初创公司来说，只要愿意付广告费，这部分也是可以解决的。让你的应用进入一个密集的社交图谱总体上是简单的。作为创始人，经过足够的尝试你应该能做到。所以大公司带来的优势虽然让事情变得更容易，但并不是创始人自己无法解决的问题。

---

### [00:44:38] Lenny Rachitsky

**English:**
So an interesting takeaway it sounds like is many people feel like, "I'm going to build a social app." They probably often hear, "Facebook's going to do that. Instagram's going to copy you. Snap's going to do that." And what I'm hearing here is it's not as easy as many people think, that it might be actually a lot harder for them to try something.

**中文翻译:**
所以一个有趣的结论是：很多人觉得“我要做一个社交应用”，然后常听到别人说“Facebook 会做的，Instagram 会抄你的，Snap 会做的”。而我听到的意思是，这并不像很多人想的那么容易，对大公司来说，尝试新东西实际上可能要困难得多。

---

### [00:44:54] Nikita Bier

**English:**
It's not only harder for them to identify these opportunities and to verbalize it internally and align the company around it. It's also hard to respond to signals in the market. A lot of people think these incumbents are going to steal your ideas. And for the most part, it takes a pretty long time for them to respond to even the number one app or charting in the app because it'll start charting in the app store, a PM will make a post about it. And then the market's strategy or market research team might do a study to follow up on it. It'll kind of float around for a few months. They might put together a framing deck saying, "Hey, we should go after this opportunity. Let's put together this team. It'll go through VP reviews. And then it'll start development. Development might take six to 12 months." Realistically, I think most companies, large companies take 12 to 24 months to respond to competitive threats in the market.

**中文翻译:**
大公司不仅很难识别这些机会、在内部表达并达成共识，也很难对市场信号做出反应。很多人认为现有的巨头会偷走你的创意。但实际上，即使是面对排名第一的应用，他们也需要很长时间才能做出反应。应用开始冲榜，某个 PM 发个帖，然后市场策略或研究团队可能会做一个跟进研究。这事儿会飘荡几个月，然后他们可能会做一个框架 PPT 说：“嘿，我们应该抓住这个机会，组建个团队吧。”接着经过 VP 审核，然后开始开发。开发可能需要 6 到 12 个月。现实点说，我认为大多数大公司需要 12 到 24 个月才能对市场上的竞争威胁做出反应。

---

### [00:46:03] Lenny Rachitsky

**English:**
Do you think this is solvable? Is there something a company can change to get better at this? Are there companies that are good at this in your experience, or is this just as you grow, this is just what happens?

**中文翻译:**
你觉得这有解吗？公司有什么可以改变的吗？在你的经验中，有没有哪家公司擅长此道，还是说随着公司规模变大，这必然会发生？

---

### [00:46:13] Nikita Bier

**English:**
The incentives within large companies make this very difficult, because you don't want to present something that you have a hunch about being a good idea because if there's not market signals already, then it's hard to defend. People in companies are focused on getting their yearly bonus or they're focused on their performance reviews. It's hard to show up into a framing meeting saying like... And a framing meeting is a meeting where you are positioning the opportunity and everything, "Here's what we should go after." It's hard to just say, "Okay, by first principles, this is a good idea and here's some very vague market signals." In reality, you need to walk in and say, "Here's the number one app in the United States and we don't own it." If you present something like that, that's pretty defensible if you fail because there was market evidence. But if you fail about something that's more based on kind of vague abstract...

**中文翻译:**
大公司内部的激励机制让这变得非常困难。你不想展示一个你直觉认为是好主意的东西，因为如果没有现成的市场信号，你就很难为之辩护。公司里的人关注的是年终奖或绩效评估。你很难在框架会议（即定位机会的会议）上说：“根据第一性原理，这是一个好主意，虽然市场信号还很模糊。”现实中，你需要走进去说：“这是全美排名第一的应用，而我们还没拥有它。”如果你这样陈述，即使失败了也是可辩护的，因为有市场证据。但如果你基于某种模糊抽象的东西而失败了……

---

### [00:47:19] Nikita Bier

**English:**
So you have to, generally, the only path is to copy existing products if you want to really get momentum inside of a large organization. And for completely new concepts, it's I think very difficult to present a lot of those ideas, either to verbalize them into a document or to even get rally the organization around it.

**中文翻译:**
所以通常情况下，如果你想在大组织内部获得动力，唯一的路径就是抄袭现有产品。对于全新的概念，我认为很难展示这些想法，无论是将其写进文档，还是动员整个组织支持它。

---

### [00:47:42] Lenny Rachitsky

**English:**
That's a really interesting insight.

**中文翻译:**
这真是一个有趣的见解。

---

### [00:47:45] Lenny Rachitsky

**English:**
This episode is brought to you by Explo, a game changer for customer facing analytics and data reporting. Are your users craving more dashboards, reports, and analytics within your product? Are you tired of trying to build it yourself? As a product leader, you probably have these requests in your roadmap, but the struggle to prioritize them is real. Building analytics from scratch can be time-consuming, expensive, and a really challenging process. Enter Explo.

**中文翻译:**
本集节目由 Explo 赞助，它是面向客户的分析和数据报告领域的游戏规则改变者。你的用户是否渴望在你的产品中看到更多的仪表盘、报告和分析？你是否厌倦了尝试自己构建这些功能？作为产品负责人，你的路线图中可能有这些需求，但确定优先级确实很困难。从头开始构建分析功能既耗时又昂贵，而且过程极具挑战性。Explo 应运而生。

---

### [00:48:11] Lenny Rachitsky

**English:**
Explo is a fully white-labeled embedded analytics solution designed entirely with your user in mind. Getting started is easy. Explo connects to any relational database or warehouse, and with its low-code functionality, you can build and style dashboards in minutes. Once you're ready, simply embed the dashboard or report into your application with a tiny code snippet. The best part? Your end users can use Explo's AI features for their own report and dashboard generation, eliminating customer data requests for your support team. Build and embed a fully white analytics experience in days. Try it for free at explo.co/lenny. That's E-X-P-L-O, .C-O/Lenny.

**中文翻译:**
Explo 是一个完全白标的嵌入式分析解决方案，完全为你的用户而设计。上手非常简单：Explo 可以连接到任何关系型数据库或仓库，凭借其低代码功能，你可以在几分钟内构建并美化仪表盘。准备就绪后，只需通过一小段代码将仪表盘或报告嵌入你的应用即可。最棒的部分？你的最终用户可以使用 Explo 的 AI 功能生成自己的报告和仪表盘，从而消除对你支持团队的数据请求。在几天内构建并嵌入完全白标的分析体验。访问 explo.co/lenny 免费试用。

---

### [00:48:57] Lenny Rachitsky

**English:**
Before we move on to the next chapter, I want to come back to the very first thing you said where product management is not real. Is there anything else that you can say about your insight there? Or is it basically what you described where PMs aren't actually involved in design and a company like Facebook in your experience?

**中文翻译:**
在进入下一章之前，我想回到你最开始说的那句话——“产品管理不是真实的”。关于这个见解你还有什么想说的吗？还是说基本上就是你描述的那样，在像 Facebook 这样的公司里，PM 实际上并不参与设计？

---

### [00:49:14] Nikita Bier

**English:**
The functional organization structure of big tech has kind of separated product managers from the product development process in many ways. They're not looking at data because data scientists are doing that. They're just parsing some of the reports that they get back. They're mainly just writing documents and then kind of being the team secretary and running around, getting approvals from each cross-functional team, legal privacy, everything like that. And yeah, you're actually very much separated from the product itself. And so I think what Snapchat has done, and I think Apple too, to the same extent, is that designers run the show. And I think that's led to some very novel-

**中文翻译:**
大科技公司的职能组织结构在很多方面将产品经理与产品开发过程分离开来。他们不看原始数据，因为那是数据科学家的工作，他们只是解析拿到的报告。他们主要是在写文档，充当团队秘书，到处跑审批，找法务、隐私等跨职能团队签字。是的，你实际上与产品本身非常疏远。所以我认为 Snapchat 所做的，以及在某种程度上的 Apple，是让设计师来主导。我认为这催生了一些非常新颖的……

---

### [00:50:00] Nikita Bier

**English:**
And I think that's led to some very novel products coming out from both of those companies. But I mean that is its own host of problems because actually rolling out a product inside of a large organization, it requires a sheer force of will because it's a lot of work. I mean, there's a lot of regulatory scrutiny, scaling it up. You do need someone to project manage. And so I don't know if it's the silver bullet as to give designers the reign to run the show, but I also don't think the current traditional like Google, Facebook style of being team secretaries is also the best solution.

**中文翻译:**
我认为这让这两家公司产生了一些非常新颖的产品。但这种模式也有它自己的问题，因为在大组织内部发布产品需要极强的意志力，工作量巨大。比如监管审查、规模化扩展，你确实需要有人来做项目管理。所以我不知道让设计师掌权是否是万灵药，但我也不认为目前 Google、Facebook 那种传统的“团队秘书”式 PM 是最佳解决方案。

---

### [00:50:44] Lenny Rachitsky

**English:**
To defend product managers, I think many product managers spend a lot of time in design, spend a lot of time with data science. I think probably what you saw is like the extreme big, big, big tech version of product management. I know even PMs at Facebook can if they want to spend time with design. I think it's just obviously very different from a startup world where you're just, that's all you're doing.

**中文翻译:**
为产品经理辩护一下，我认为很多 PM 确实在设计和数据科学上花了很多时间。我想你看到的可能是大科技公司里最极端的那种产品管理版本。我知道即使在 Facebook，如果 PM 愿意，他们也可以花时间在设计上。只是这显然与初创公司世界非常不同，在初创公司，那就是你的全部工作。

---

### [00:51:05] Nikita Bier

**English:**
Yeah, it's certainly an exaggerated view, but it's particularly relevant I think for all the zero to one initiatives because if you're a product manager on a standalone app inside of a large, like you should be designing the hierarchy, the pixels, the flows, everything. And then yeah, it should be cleaned up prototype by a technical designer, but that's your idea. And products live and die in the pixels, like consumer products, so that's on you. And that's where I think for maybe larger growth initiatives, yes, you can be a little more detached from the pixels.

**中文翻译:**
是的，这确实是一个夸张的观点，但我认为它对所有“从 0 到 1”的项目特别适用。如果你是大公司里一个独立应用的产品经理，你应该亲自设计层级、像素、流程，所有的一切。然后由技术设计师来完善原型，但那是你的创意。消费级产品的生死取决于像素（细节），所以那是你的责任。我认为对于大型增长项目，你或许可以稍微脱离像素一些。

---

### [00:51:43] Lenny Rachitsky

**English:**
I love that advice. Okay, before we move on to the next phase of your journey of starting Gas, I heard there's an interesting story around where you were actually put within the Facebook office physically, where your team was put. Is there something there?

**中文翻译:**
我喜欢这个建议。好，在我们进入你创办 Gas 的下一阶段之前，我听说有一个关于你们在 Facebook 办公室物理位置的有趣故事。你们团队被安置在哪儿了？

---

### [00:51:57] Nikita Bier

**English:**
Yeah. When we joined the new product experimentation group, we were actually seated I think at basically the same desk as Mark Zuckerberg. And that was pretty cool to see how the machine runs from Zuck's view. But we had a few artifacts that we had kept with us from our old office when we were running tbh, and one of them was this kind of pop art painting that I bought on the street when I needed to get something on the walls for our office. And it was this giant painting of Tim Cook. We had been carrying it between our orgs at Facebook just because it was a funny painting. And I kind of got it because it was kind of symbolic of who actually controls our destiny, is Apple. And so when we relocated to the area where Zuck was sitting, I put up the painting on the wall and it was basically a giant painting of Tim Cook was overlooking Zuck.

**中文翻译:**
是的。当我们加入新产品实验组时，我们实际上被安排在和马克·扎克伯格（Zuck）几乎同一张桌子的位置。从 Zuck 的视角看这家机器如何运转真的很酷。但我们带了一些以前做 tbh 时的“遗物”，其中一个是由于当时办公室墙上需要装饰，我在街上买的一幅波普艺术画。那是一幅巨大的蒂姆·库克（Tim Cook）画像。我们在 Facebook 的不同部门之间一直带着它，纯粹是因为它很有趣。我买它是因为它象征着谁真正掌控着我们的命运——那就是苹果。所以当我们搬到 Zuck 坐的那个区域时，我把画挂在了墙上，基本上就是一幅巨大的蒂姆·库克画像在俯视着扎克伯格。

---

### [00:52:40] Nikita Bier

**English:**
And eventually one of the EAs there said, "Actually, do you think you could take that home?" And it kind of made sense because you can't really have a painting of another big tech executive overlooking us.

**中文翻译:**
最终，那里的一位行政助理（EA）说：“那个，你能不能把它带回家？”这其实也说得通，因为你确实不能让另一家大科技公司高管的画像在那儿俯视着我们。

---

### [00:53:20] Lenny Rachitsky

**English:**
What does it look like? Do you happen to have it?

**中文翻译:**
它长什么样？你手头有吗？

---

### [00:53:22] Nikita Bier

**English:**
Yeah, I actually do. Let me go grab it.

**中文翻译:**
有的，我去拿一下。

---

### [00:53:26] Lenny Rachitsky

**English:**
Amazing. Oh, wow. That's artistic. So that's Tim Cook. What is the idea there that he's peeking through this darkness staring at you?

**中文翻译:**
太棒了。噢，哇。很有艺术感。所以那是蒂姆·库克。这幅画的意境是他从黑暗中窥视并盯着你吗？

---

### [00:53:36] Nikita Bier

**English:**
Yeah, yeah. He's the real boss of all of us.

**中文翻译:**
没错，他才是我们所有人的真老板。

---

### [00:53:41] Lenny Rachitsky

**English:**
I could see why Zuck would not want that staring at him all day. That's amazing. And I like that you still have that with you.

**中文翻译:**
我能理解为什么 Zuck 不想整天被他盯着。太有意思了，我很高兴你还留着它。

---

### [00:53:49] Nikita Bier

**English:**
Yeah. One of the artifacts of that chapter of life. So good.

**中文翻译:**
是的，那是人生那个篇章的纪念品。

---

### [00:53:54] Lenny Rachitsky

**English:**
Okay. So that was your Facebook journey, those four years. That's wild. You left Facebook. At some point, you started, I remember this, you started tweeting like, "Hey, I'm working on new app." Everyone was going nuts. "What are you working on?" And at this point, I think you probably in your mind thought, I am this one-hit wonder, I haven't shown that I can do this again and again. And so I think you probably have this motivation. Maybe talk about that, just like this drive of like, hey, I want to do this again. Is that where your mind was at?

**中文翻译:**
好，那是你在 Facebook 的四年旅程，真疯狂。你离开了 Facebook。在某个时间点，我记得你开始发推特说：“嘿，我正在开发一个新应用。”大家都疯了，都在问：“你在做什么？”我想当时你心里可能在想：“我不想只是昙花一现，我还没证明我可以一次又一次地成功。”所以你可能有这种动力。聊聊那个吧，那种“嘿，我想再做一次”的冲动。你当时是这么想的吗？

---

### [00:54:19] Nikita Bier

**English:**
When that meme started, my intent was to start a venture-backed company and build something that would scale to be a big team and this durable thing that lasted many years and everything. And so I just made post that I was leaving Facebook and looking for some teammates. And I shared a couple of ideas with some people privately and there were some really crazy ideas that I shared. I'm not going to get into them, but then people started posting, "Oh my God, I just saw Nikita's app. It's crazy." And what happened was others saw that and then they started memeing it and it became this massive meme where they're like, "Oh, I just tried Nikita's app, it saved my marriage. Oh, I just quit drinking. My kids returned home after all these like," and it turned into this massive meme. And at the time, I didn't even have an app or anything. I wasn't even planning to launch it. It wasn't even an app, some of the ideas I was looking at.

**中文翻译:**
当那个梗（meme）开始时，我的意图是创办一家风险投资支持的公司，建立一个大团队，做一个能持续多年的长青产品。所以我发帖说我离开了 Facebook，正在寻找队友。我私下和一些人分享了几个想法，其中一些非常疯狂，我就不细说了。结果人们开始发帖说：“天呐，我刚看了 Nikita 的应用，太疯狂了。”接着其他人看到了，就开始玩梗，变成了一个巨大的梗：“噢，我刚试了 Nikita 的应用，它挽救了我的婚姻”、“噢，我戒酒了”、“我的孩子回家了”。而当时我甚至连个应用都没有，甚至没打算发布，我当时看的有些想法甚至都称不上是应用。

---

### [00:55:48] Nikita Bier

**English:**
But what happened was the market had crashed shortly thereafter, there was kind of the end of the Zerb era. The Fed started hiking rates. I think my portfolio was down like 30% or something and I was like, "Damn, this sucks. Maybe I should think about how to make money today." That's the reason we're in startups is to make money. And so there was always in the back of my head this question that I had, which was what if we had monetized tbh? Because the number one support message we received was can I pay to reveal who sent me polls? It was the number one question. And it was like, would it have made even more than the acquisition if we just monetized it? And I'm like, we could probably build this pretty fast, like probably in a month, month or two. Ended up being a lot longer, but we started rebuilding it. It was a new team. It was one of the engineers from a company called Paparazzi. His name's Zay Turner, and he started building it in my house and we had tested it to see would this new version of tbh actually resonate with kids five years later? That was actually the thing I wanted to know most of all was like would an anonymous polling app actually still be relevant five years later?

**中文翻译:**
但随后市场崩盘了，零利率时代（Zerp era）结束了，美联储开始加息。我的投资组合缩水了大约 30%，我想：“该死，这太糟了。也许我该考虑一下现在怎么赚钱。”我们创业不就是为了赚钱吗。我脑子里一直有一个疑问：如果我们当初把 tbh 变现了会怎样？因为我们收到的第一大支持请求就是“我能不能付钱看看是谁给我投的票？”。如果变现，赚的钱会不会比被收购还多？我想，我们大概能很快做出来，一两个月吧。结果花的时间长得多，但我们开始重建它。那是一个新团队，其中一位工程师来自 Paparazzi 公司，叫 Zay Turner，他在我家开始构建。我们测试了它，想看看五年后，新版 tbh 是否还能引起孩子们的共鸣。我最想知道的是：五年后，匿名投票应用是否依然有市场？

---

### [00:57:36] Lenny Rachitsky

**English:**
Was it the Georgia School again?

**中文翻译:**
还是佐治亚州那所学校吗？

---

### [00:57:38] Nikita Bier

**English:**
Yes, actually. We launched at the exact same school that we launched tbh on the exact same day five years later, in fact. And people sent a lot of messages, but it wasn't growing. So let me pedal back here a bit. So tbh grew through variety of things, people sharing their messages to Snapchat and text invites, and that was 2017. And the way you invited your friends on tbh was that you tap their name, your contact name, and there was a button that said Invite and then we used Twilio to send them a text message. And the regulatory environment actually had changed a lot over those five years. You really can't send texts from a server anymore. It has to be sent from the user's device. And just the point of clarification is a lot of people clone tbh over the years and they think that when you voted on people in the polls, it sent them a text. We never did that. That's egregiously illegal to do and also unethical at a user experience level to send texts when people don't even know what's happening.

**中文翻译:**
是的。事实上，我们在五年后的同一天，在同一所学校发布了它。人们发了很多消息，但它没有增长。让我往回退一点：tbh 的增长靠的是人们分享到 Snapchat 和短信邀请，那是 2017 年。当时邀请朋友的方式是点击联系人姓名，有个“邀请”按钮，然后我们通过 Twilio 发送短信。但这五年间监管环境发生了巨大变化，你不能再从服务器发送短信了，必须从用户设备发送。澄清一点：这些年很多人克隆 tbh，以为你在投票时系统会自动给对方发短信。我们从没那样做过，那是非常违法的，而且在用户体验层面也是不道德的。

---

### [00:58:57] Nikita Bier

**English:**
But anyway, we couldn't send texts over Twilio anymore, and that led to people not sending as many invites when we created Gas because they had to pop the Compose window and hit Send. They're going to just tap Invite on five names. So we actually had to reinvent all the growth systems and it took about I think like nine launches including renaming the app, including features that just never existed on tbh. So it was actually just in many ways like yeah, the concept on the surface was the same, but it was very much a zero to one development cycle of figuring out how to grow this thing again in this climate.

**中文翻译:**
总之，我们不能再用 Twilio 发短信了，这导致人们在用 Gas 时不再发送那么多邀请，因为他们必须弹出短信编辑窗口并点击发送，而不能只是连点五个名字。所以我们不得不重新发明所有的增长系统，大概经历了九次发布，包括重新命名应用，加入 tbh 从未有过的功能。所以从很多方面来说，虽然表面概念一样，但这完全是一个“从 0 到 1”的开发周期，去摸索如何在当下的环境下让这东西再次增长。

---

### [01:00:05] Lenny Rachitsky

**English:**
I know that point is really important to you. I think a lot of people are like Nikita just sold the same app twice. What a guy. And the point you're making here is not only was the infrastructure completely different, the team was different, you had to rethink the entire flywheel of how it worked and how it grew.

**中文翻译:**
我知道这一点对你很重要。我想很多人会觉得：“Nikita 只是把同一个应用卖了两次，这家伙真行。”而你强调的是，不仅基础设施完全不同，团队不同，你还必须重新思考它运作和增长的整个飞轮。

---

### [01:00:05] Nikita Bier

**English:**
Yeah. And there were so many layers of like we validated one thing and then the next thing we got stuck on. Like, okay, people send a lot of messages. Cool, great. The next thing was will it spread within a school? That took us a while to get right. Will it hop schools? Each of those was a very, very challenging problem in light of the new climate that we were operating in. And I always do things by the book when it comes to operating legally within the compliance framework. And that's something when I meet founders and they tell me some growth thing that they're doing, and I'm like, "You can't do that. That's going to cause way more trouble down the line. It's going to burn users too." And so we always wanted to make it abundantly clear how our growth system, how you are inviting friends and all that. You can kind of go on a whole diatribe on that because the thing that I see a lot of founders do is they in the background use user data in ways that it shouldn't be used. They invite people on your behalf and all that.

**中文翻译:**
是的。有很多层面的验证，我们验证了一件事，接着又卡在下一件事上。比如：好，人们发了很多消息，太棒了。接下来的问题是：它会在学校内部传播吗？这花了我们一段时间才搞定。它会跨校传播吗？在新的环境下，每一个都是极具挑战性的问题。在合规框架内合法运营方面，我一向循规蹈矩。当我遇到创始人告诉我他们正在做的某些增长手段时，我会说：“你不能那样做，那以后会带来大麻烦，而且会伤害用户。”所以我们总是想让增长系统、邀请方式变得非常透明。我可以就此大谈特谈，因为我看到很多创始人在后台以不当方式使用用户数据，比如代表用户发送邀请等等。

---

### [01:01:21] Nikita Bier

**English:**
And I have this kind of crazy view that the internet is this living and breathing thing. There's Wikipedia article called the Gaia Hypothesis, which is about biology. And it's basically like the earth is kind of living and breathing and can respond to threats. Okay? And when you enter the rainforest too deep, Ebola virus will be released. Okay? So I think the internet operates on a similar paradigm here where if you do the wrong thing by users, the internet will come back and get even and defend itself. And so whenever I design products, I try to do right by users because it'll always come back much worse and I think you should always operate above board with how you design your growth systems. And with Gas, we had to do things the right way and we had to figure out at each particular moment or problem that we solve, will it spread within schools? Will it hop schools? Will people pay for it? All of these things was a whole reinvention of the original product.

**中文翻译:**
我有一个疯狂的观点，认为互联网是一个有生命、有呼吸的东西。维基百科上有一个关于生物学的词条叫“盖亚假说”（Gaia Hypothesis），大意是地球是有生命、有呼吸的，能对威胁做出反应。当你深入雨林太深，埃博拉病毒就会被释放。我认为互联网也遵循类似的范式：如果你对用户做了错事，互联网会反击、报复并自我防卫。所以每当我设计产品时，我都努力对用户负责，因为违规操作总会带来更糟的后果。我认为设计增长系统时应该始终光明正大。在做 Gas 时，我们必须以正确的方式做事，解决每一个具体问题：它会在校内传播吗？会跨校吗？人们会付钱吗？所有这些都是对原始产品的彻底重塑。

---

### [01:02:36] Lenny Rachitsky

**English:**
I love that you shared that because I think a lot of people see you from the outside and they think you're doing all kinds of these skeezy growth hacks and making teens do things that aren't really mentally healthy for them. But it's clear that that's the opposite of how you think about it, that you're trying to stay very positive, like you only allow positive communication. You do things that as you just said, are going to be good long-term, the internet's not going to come and try to shut you down.

**中文翻译:**
我很高兴你分享了这些，因为我觉得很多外人看你，会觉得你在用各种卑劣的增长手段，让青少年做一些对心理健康不利的事情。但显然你的想法恰恰相反，你努力保持积极，比如只允许正面交流。你做的事情正如你所说，从长远来看是有益的，互联网不会反过来试图关闭你。

---

### [01:03:00] Nikita Bier

**English:**
The point you bring up here about wanting to build a positive thing, some people, sometimes I get criticism. It's not actually that often, but they say, "Oh, you're building an app that makes teens feeling insecure or anything." But with Gas, I think we received a message every single day from a user telling us that they reconsidered suicide or other forms of self-harm. The app sent you positive messages and affirmations. It made teens feel really good. And I think that is lost on a lot of people. Instagram can make you feel jealousy and a lot of other social networks are a mixed bag in terms of impact. But we were entirely focused on making teens feel better.

**中文翻译:**
关于想要构建积极的事物这一点，有时我会收到批评，虽然不经常，但有人会说：“噢，你在做一个让青少年感到不安的应用。”但在做 Gas 时，我想我们每天都会收到用户的消息，告诉我们他们因为这个应用而重新考虑了自杀或其他自残行为。应用发送的是正面的消息和肯定，这让青少年感觉非常好。我觉得很多人忽略了这一点。Instagram 可能会让你感到嫉妒，很多其他社交网络的影响也是毁誉参半，但我们完全专注于让青少年感觉更好。

---

### [01:03:49] Nikita Bier

**English:**
And some people might say, "Oh, what if someone doesn't get voted for something?" We actually built a system to ensure everyone got a vote. And what we did was we put your name in polls at a higher frequency if you weren't being voted on recently. So we wanted to spread the love in every way possible, and that's what really motivated me to grow this thing was watching how it was impacting 10 million kids in such a short period of time.

**中文翻译:**
有些人可能会说：“噢，如果有人没被投中怎么办？”我们实际上构建了一个系统来确保每个人都能获得投票。我们的做法是：如果你最近没被投中，我们就会提高你的名字在投票中出现的频率。我们想尽一切可能传播爱，看到它在这么短的时间内影响了 1000 万孩子，这才是真正激励我让它增长的动力。

---

### [01:04:20] Lenny Rachitsky

**English:**
I really appreciate you adding that. I didn't know all those things about the way you thought about these apps. Interestingly, I don't know how much you can go into this, but there is a lot of stuff going on with Gas around human trafficking and all this stuff where people thought people were being kidnapped through Gas, which is yeah, talk about that whatever you can because that's pretty crazy.

**中文翻译:**
非常感谢你补充这些。我以前不知道你对这些应用的思考如此深。有趣的是，我不知道你能聊多少，但 Gas 曾卷入过很多关于人口贩卖的传闻，人们以为有人通过 Gas 被绑架了。这太疯狂了，能聊聊吗？

---

### [01:04:41] Nikita Bier

**English:**
We had this hoax started where people were saying the app was used for human trafficking. And I was like, "This is so strange." This is a anonymous polling app without messaging and the only thing you could do is send compliments to your friends. And I researched into it and I saw that this is actually plaguing a lot of apps and any app that has gone viral in any way has actually had this hoax started. And part of the reason it happens is it gets you attention if you say that about an app. As a teenager, if you say, "Oh, this app is dangerous," and then you get a bunch of followers and who doesn't love followers? So it's actually a really viral piece of content if you put it out. And so we had this hoax started and we were like, "This could kill the company." And I talked to a bunch of founders that it happened to them and they said, "Yeah, we had to shut down because of that."

**中文翻译:**
当时出现了一个谣言，说这个应用被用于人口贩卖。我觉得这太奇怪了，这是一个没有私信功能的匿名投票应用，你唯一能做的就是给朋友发赞美。我研究了一下，发现这实际上困扰着很多应用，任何走红的应用几乎都会遭遇这种谣言。部分原因是，如果你说某个应用很危险，你会获得关注。作为一个青少年，如果你说“噢，这个应用很危险”，你就会涨粉，谁不喜欢涨粉呢？所以这其实是一种非常容易病毒式传播的内容。谣言开始后，我们觉得这可能会毁了公司。我联系了一些有过类似遭遇的创始人，他们说：“是的，我们因为这个不得不关门了。”

---

### [01:05:40] Nikita Bier

**English:**
And I was like, "Is this it? Is this the end of the company?" And I remember it hit number one when we started getting a few of these reports in our support channels. And I was like, "I'm just going to plant the flag on posts that we hit number one in the App Store because this thing's probably going to shut down soon." So I make this announcement on Twitter, "I just made the number one app and I thought it would just be dead in a week." And then I just had this sudden burst of energy and I was like, "I'm going to win. I'm going to fight this. This is not true. It makes no sense at all."

**中文翻译:**
我当时想：“就这样了吗？公司要完了吗？”我记得当我们开始在支持渠道收到这些报告时，应用刚好冲到第一。我想：“我得赶紧在推特上发个帖庆祝拿到第一，因为这东西可能很快就要倒闭了。”于是我发推说：“我刚做出了排名第一的应用，但我以为它一周内就会死掉。”然后我突然爆发出一股力量，我想：“我要赢，我要反击。这不是真的，这根本说不通。”

---

### [01:06:20] Nikita Bier

**English:**
And so we fought it at every vector possible, this completely made up hoax. We met with journalists, reporters to make sure that the number one match every time you search Gas app human trafficking was Gas app is not for human trafficking. And so that ended up being The Washington Post headline. We insisted that that be the headline if we do the interview. So that was the first thing that showed up on Google anytime someone searched it. There were schools and even a police station that posted that this app is used for human trafficking. I called those superintendents, I called those police chiefs and have got them to publicly retract it. And we had some of the reviews on the App Store. We asked Apple to remove them because we got review bombed.

**中文翻译:**
于是我们从每一个可能的角度反击这个彻头彻尾的谎言。我们约见记者和报道员，确保每次有人搜索“Gas app 人口贩卖”时，排名第一的结果是“Gas app 不涉及人口贩卖”。这最终成了《华盛顿邮报》的头条。我们坚持要求如果接受采访，必须用这个做标题。这样一来，任何人搜索时，谷歌显示的第一条就是这个。当时甚至有学校和警察局发帖说这个应用被用于人口贩卖。我亲自打电话给那些学区总监和警察局长，让他们公开撤回言论。我们还请求苹果删除 App Store 上的部分评论，因为我们遭到了恶意差评轰炸。

---

### [01:07:07] Nikita Bier

**English:**
But the thing that actually was the most impactful was my girlfriend made a video, a TikTok video explaining that it's not true. And anytime someone deleted their account, they could watch this video explaining it's not true. And at the peak, we had 3% of users deleting their accounts per day. So it was like a catastrophe for an app and we got it down to 0.1% through relentless, relentless effort. And it was really just an unusual thing that happens when you grow really fast is this human trafficking hoax that starts. And you don't understand how crazy it is until it happens to your company, but it was kind of hilarious to think about. This app was the most harmless benign thing you could think of.

**中文翻译:**
但真正影响最大的是我女朋友拍了一个 TikTok 视频，解释这不是真的。每当有人注销账户时，他们都能看到这个解释视频。在高峰期，我们每天有 3% 的用户注销账户，这对应用来说简直是灾难。通过不懈的努力，我们把这个比例降到了 0.1%。当你增长极快时，这种人口贩卖谣言确实是一种罕见的副作用。除非发生在你自己公司身上，否则你无法理解那有多疯狂。但回想起来也挺荒谬的，这个应用明明是你所能想到的最无害、最温和的东西。

---

### [01:08:01] Lenny Rachitsky

**English:**
This is insane. I did not know this full story. And you were doing all this while you were trying to scale the app and trying to keep the servers up and try to grow it, right? What was that like to try to manage all these things at once?

**中文翻译:**
太疯狂了。我以前不知道完整的故事。你是在努力扩展应用、维持服务器运行和推动增长的同时做这些事的，对吧？同时处理所有这些事情是什么感觉？

---

### [01:08:13] Nikita Bier

**English:**
I was sleeping three hours a day for three months. It was extraordinarily difficult to do it all. Our team was also relentless though. They would come over to my house 9:00 a.m. stay until midnight and just do that seven days a week. So yeah, it was definitely one of the most physically draining things ever, but we were just so tactical. I remember investors were asking to meet with us and I said, "If you can't get a celebrity to post that this isn't true, then we're not interested." But yeah, we went after it on every vector and it ended up being okay.

**中文翻译:**
我有三个月每天只睡三小时。要处理好这一切极其困难。但我们的团队也非常拼命，他们早上 9 点来我家，一直待到半夜，一周七天。这绝对是我经历过的最耗费体力的事之一。但我们的策略非常明确。我记得有投资者想见我们，我说：“如果你不能找个名人发帖澄清这不是真的，那我们没兴趣见面。”总之，我们从各个角度出击，最后结果还不错。

---

### [01:08:59] Lenny Rachitsky

**English:**
I love how you took your brain to this other completely different problem and thought about all the levers you could use to change the conversation around the app.

**中文翻译:**
我喜欢你把大脑转到这个完全不同的问题上，并思考所有可以用来改变舆论的杠杆。

---

### [01:09:09] Nikita Bier

**English:**
Yeah. I remember we had these TikTok videos that were made that were saying it was true and I networked my way all the way to the CEO of TikTok and I said, "Can you delete these?" And we got this information deleted. Yeah, so it was really a whole new test of our team's capacities was fighting. The key thing that you have to know though when you have a hoax spreading about your app is you really have to make sure the hoax is less viral than your app. And at a few points, the hoax was more viral than our app and we had to take this-

**中文翻译:**
是的。我记得当时有些 TikTok 视频在传谣，我通过人脉直接联系到了 TikTok 的 CEO，问他：“能删掉这些吗？”然后那些信息就被删除了。所以这真的是对我们团队能力的一次全新考验。当谣言传播时，你必须确保谣言的病毒式传播力（K-factor）低于你的应用。有几次，谣言的传播力甚至超过了应用本身，我们不得不采取行动。

---

### [01:09:49] Lenny Rachitsky

**English:**
The K-factor of the hoax.

**中文翻译:**
谣言的 K 因子（病毒传播系数）。

---

### [01:09:51] Nikita Bier

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:09:51] Lenny Rachitsky

**English:**
That's absurd. Okay. So broadly, you built this app. Again, a big success. I saw a stat that you made $11 million in sales through the app, 10 million downloads. Is that right?

**中文翻译:**
太荒谬了。好，总的来说，你又做了一个非常成功的应用。我看到数据说你通过这个应用赚了 1100 万美元，下载量 1000 万。对吗？

---

### [01:10:03] Nikita Bier

**English:**
Yeah. It was a blowout success in terms of like it grew bigger than tbh. We monetized it. We ran almost entirely on startup credits, so it was basically-

**中文翻译:**
是的。它取得了巨大的成功，增长规模甚至超过了 tbh。我们实现了变现，而且几乎完全靠初创公司抵扣额度（credits）运行，所以基本上……

---

### [01:10:17] Lenny Rachitsky

**English:**
Like Cloud Credits? Like AWS Credits?

**中文翻译:**
云服务抵扣额度？比如 AWS 抵扣额度？

---

### [01:10:20] Nikita Bier

**English:**
Yeah. AWS Credits, Mixpanel. I remember when I saw the early data, I'm like, "Okay, now it's time for me to negotiate every bill down to the last cent of margin for every vendor." And I got credits everywhere, and so we really were tactical with that. And so we ended up being all just pure cashflow for the team. We had no investors. And it was just so interesting though that the way that I started posting about it on Twitter was it kind of captured the zeitgeist of the internet. And we didn't intend on selling it. We were just going to let this thing run its course and just be this app that kind of lives in the background of our lives. But once it started capturing the zeitgeist of Twitter, I was like, "Wait a minute, we could probably sell this thing." And that's when we started engaging with some of these, we ended up getting three companies that wanted to buy it. I won't be able to say them, but ultimately we ended up selling to Discord and we joined Discord.

**中文翻译:**
是的，AWS、Mixpanel 的额度。我记得看到早期数据时，我想：“好，现在该去和每个供应商谈判，把每一分钱的利润都抠下来。”我到处拿抵扣额度，所以我们在那方面非常讲究策略。最后，这成了团队纯粹的现金流，我们没有投资者。有趣的是，我在推特上发帖的方式捕捉到了互联网的时代精神。我们原本没打算卖掉它，只是想让它顺其自然地运行，作为一个存在于我们生活背景中的应用。但一旦它开始在推特上引起轰动，我想：“等一下，我们也许能卖掉它。”于是我们开始接触买家，最后有三家公司想买。我不能说名字，但最终我们卖给了 Discord 并加入了他们。

---

### [01:11:29] Lenny Rachitsky

**English:**
Awesome. So before we move on to the next part of the journey and some of the other insights that I want to get into, is there any lasting lessons that you took away from Gas as a product that you take with you to advising startups in terms of building the product design? I know there's many, but any that stand out most that you think are really interesting to share?

**中文翻译:**
太棒了。在我们进入下一阶段和探讨其他洞察之前，关于 Gas 这个产品，有没有什么持久的教训是你现在用来指导初创公司进行产品设计的？我知道有很多，但有没有最突出的、你觉得非常值得分享的？

---

### [01:11:50] Nikita Bier

**English:**
I think I kind of touched on this before, which was trying to validate things in a sequence of like, will people use the core flow? Will people spread it within their peer group? Will it hop peer groups? And what I think the most important thing that I learned is that's actually a really great way to do zero to one product development is execute at 100% for the thing you're trying to validate at that specific stage of the product development cycle. And then you can kind of half-ass the rest just so you can get 100% signal on that one part.

**中文翻译:**
我想我之前提到过，就是按顺序验证：人们会使用核心流程吗？会在同龄人群体中传播吗？会跨群体传播吗？我学到的最重要的一点是，这是做“从 0 到 1”产品开发的极佳方式：在产品开发周期的特定阶段，为你试图验证的那件事投入 100% 的执行力，而其他部分可以先敷衍一下，这样你就能在那一个环节获得 100% 纯净的信号。

---

### [01:12:25] Nikita Bier

**English:**
And so we made the polling experience just perfect. The questions were great. Push notifications, everything worked. And then the next stage was getting sharing and virality working. And so compartmentalizing those things because ultimately you'll have too much scope creep if you try to solve everything at once and validate. And also you're not going to get signal too, like you're trying to test one thing at a time. So the way that now I approach a lot of consumer product development is if this is true, then what next needs to be true for this thing to work out? And these layers of conditional statements. And the more layers you have, the higher risk your product is, so you should try to condense it to about like four things that must be true for the thing to work.

**中文翻译:**
所以我们把投票体验做得近乎完美：问题很棒，推送通知很灵，一切都运转良好。下一阶段才是让分享和病毒式传播生效。要把这些事情隔离开来，因为如果你试图同时解决和验证所有事情，最终会导致功能蔓延（scope creep），而且你也得不到明确的信号。现在我处理消费级产品开发的方法是：如果 A 是真的，那么为了让这件事成功，下一步 B 必须是真的吗？这就像一层层的条件语句。层数越多，产品的风险就越高，所以你应该试着将其浓缩为大约四个“必须为真”的条件。

---

### [01:13:06] Lenny Rachitsky

**English:**
And this comes back to your advice of the thing you need to get good at is testing and learning and making it really quick.

**中文翻译:**
这又回到了你的建议：你需要擅长的是测试和学习，并且动作要快。

---

### [01:13:13] Nikita Bier

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:13:13] Lenny Rachitsky

**English:**
Okay. Maybe one last thing along this thread. I'm just really curious how this hoax came to be, like who's behind it? How does this happen?

**中文翻译:**
好，关于这个话题最后问一件事。我很好奇这个谣言是怎么产生的？谁在背后？它是怎么发生的？

---

### [01:13:20] Nikita Bier

**English:**
We got a original support message, which was a screenshot of a story on Snapchat and it said, "Do not download the Gas app. It's for human trafficking." Okay? And it was a screenshot that had like that mirror effect where you have like 10 people that screenshotted it. More, like 40 people because it had all the usernames. So I was looking at this and I'm like, "How many people have seen this?" And it looked like a viral thing on Snapchat. And then I went to the App Store page and I saw a review that said this app is for human trafficking. And I went to my team and I said, "This will probably kill the company. This will kill the product. I've seen this before with consumer apps and it's evident to me this is going to be 10 times bigger tomorrow." And they were like, "No. It's just one message. What do you mean?" I'm like, "No, no, it's been screenshotted 40 times and now it's on the App Store page." And we got another message four hours later.

**中文翻译:**
我们收到了一条原始的支持消息，是 Snapchat 动态的截图，上面写着：“不要下载 Gas app，它是用来人口贩卖的。”那张截图有那种“套娃”效果，显示已经有 10 个人截过图了，甚至更多，可能有 40 个人，因为上面全是用户名。我看着这个想：“有多少人看过这个了？”它看起来在 Snapchat 上传疯了。然后我去 App Store 页面，看到一条评论说这个应用是人口贩卖用的。我去找团队说：“这可能会毁了公司，毁了产品。我在其他消费级应用上见过这种情况，显而易见，明天这事会扩大 10 倍。”他们说：“不至于吧，就一条消息，你什么意思？”我说：“不，它已经被截图转发 40 次了，现在已经出现在 App Store 评论里了。”四小时后，我们又收到了另一条消息。

---

### [01:14:35] Nikita Bier

**English:**
And the next day, it was our entire App Store page was just covered with reviews saying that the app's for human trafficking. And we actually had to rebrand the app. We relaunched it once and we're like, "Let's just call it something different. Just relaunch it on the other side of the country." We did that, started going viral again. And the craziest thing was it re-emerged and what happened was one user was friends with another person in another state and they got an invitation. And that user told them, "Oh, that was in my state. It's actually for human trafficking." And then it just completely started again and then it was too late at that point to relaunch again. We just realized, " We got to fight this thing." And ultimately, I don't think we'll ever know the true origin, but it was definitely a living, breathing like hoax.

**中文翻译:**
第二天，整个 App Store 页面全是被刷的人口贩卖评论。我们甚至不得不重新命名应用。我们重新发布了一次，心想：“换个名字，在国家的另一端重新发布。”我们照做了，它又开始走红。最疯狂的是，谣言又出现了。原因是某个州的用户收到了另一个州朋友的邀请，那个用户说：“噢，这应用在我们州出现过，它是人口贩卖用的。”然后一切又重新开始了。那时再重新发布已经太晚了，我们意识到：“我们必须正面反击。”最终，我想我们永远不会知道真正的源头，但它绝对是一个有生命力的谣言。

---

### [01:15:46] Lenny Rachitsky

**English:**
That is insane. The story just gets more and more interesting. What were some of the previous names, by the way? Is that something you can share?

**中文翻译:**
太疯狂了。故事越来越精彩了。顺便问下，之前的名字有哪些？方便分享吗？

---

### [01:15:52] Nikita Bier

**English:**
Yeah, we went through a bunch. One of them was called Crush, one of them was called Melt, and another was... The interesting thing about Crush is we got a great domain. We thought this would be the name. This was between some of the re-brands. We tested it and we saw that invitations dropped significantly under the Crush name and we were like, "What's going on here?" And we found that actually when you invite someone to an app, regardless of the app, you generally... Boys invite boys, girls invite girls to apps. And boys didn't want to invite their friends to an app called Crush with a pink icon.

**中文翻译:**
是的，我们试过好几个。一个叫 Crush，一个叫 Melt，还有一个……关于 Crush 有个趣事，我们买到了一个很棒的域名，以为这就是最终名字了。在几次更名期间，我们测试了它，发现改名 Crush 后邀请量大幅下降。我们纳闷是怎么回事，后来发现：无论什么应用，通常男生邀请男生，女生邀请女生。而男生不想邀请朋友去一个叫 Crush（暗恋）、图标还是粉红色的应用。

---

### [01:16:35] Nikita Bier

**English:**
And then we looked at the data and the app. I mean this was true TBH too, which was the app indexed about 60 to 65% women. So we were just like, "Let's make the app more masculine and see what happens. We need balance on this." So we made the icon black with a flame, called it Gas and the invites rate jumped. And you think a name doesn't matter, but right at the moment of sending an invite... So that was one of the interesting insights on the naming process.

**中文翻译:**
我们看了数据，tbh 当时也是这样，女性用户占 60% 到 65%。于是我们想：“让应用看起来更阳刚一点，看看会发生什么，我们需要平衡一下。”于是我们把图标改成黑色带火焰，改名 Gas（加油/给力），邀请率立刻飙升。你可能觉得名字不重要，但在发送邀请的那一刻……这是命名过程中一个有趣的洞察。

---

### [01:17:07] Lenny Rachitsky

**English:**
Man, there's just endless stories that we could keep getting into, but we've also gone very long, so I'm going to try to move on to another topic. So I ask people on Twitter what to ask you? Just that question got a thousand likes just me asking, "What should I ask Nikita?" And the most common question, I'm sure you get this a lot, is just people wondering, do you ever want to build a durable consumer app? Is it possible to build a durable consumer app? Scott Belsky asked this, Robert at Figma asked this, and Scott actually had a really nice way of describing it about why are so many quick sensation consumer apps proving to be more akin to summer songs than enduring standalone products and businesses? So there's kind of two questions here. One is, do you aim to build a durable consumer app? And two, how possible is it?

**中文翻译:**
天呐，你的故事真是讲不完，但我们已经聊了很久了，我得换个话题。我在推特上问大家想问你什么，光是这个问题就有上千个赞。最普遍的问题——我猜你经常被问到——就是：你是否想过构建一个持久的（durable）消费级应用？构建一个长青的消费级应用可能吗？Scott Belsky 和 Figma 的 Robert 都问了这个问题。Scott 的描述很妙：为什么这么多迅速走红的消费级应用更像是“夏日神曲”，而不是持久的独立产品和业务？所以这里有两个问题：第一，你的目标是构建持久的应用吗？第二，这有多大可能性？

---

### [01:17:54] Nikita Bier

**English:**
A lot of the fundamental tools for communicating with our friends either messaging or broadcasting one-to-many like on stories or the incumbents have built pretty large motes in terms of network effects and to provide true an order of magnitude better experience is non-trivial because they've been actually improving these products so much over the years and there's not that many entry points. Not to say that it's not impossible. Snapchat was showed that there was style of messaging that people wanted that the incumbents weren't serving. But I think there's these kind of edges that you can go after with a much higher probability of success and they might not actually be something that's durable necessarily. And I think finding durability for a communication or social product, that's a black swan event. Retention for consumer social is there's a tremendous amount of randomness. There's one every decade. If it was simple, I would just be printing $1 trillion companies.

**中文翻译:**
很多与朋友沟通的基础工具，无论是私信还是像 Story 那样的一对多广播，现有的巨头已经在网络效应方面建立了巨大的护城河。要提供真正好上一个数量级的体验是非常困难的，因为这些年他们一直在改进产品，而且切入点并不多。并不是说不可能，Snapchat 证明了人们想要一种巨头没能提供的通讯方式。但我认为，去切入这些“边缘”地带会有更高的成功概率，尽管它们未必是持久的。我认为，对于通讯或社交产品来说，找到“持久性”是一个黑天鹅事件。消费级社交产品的留存存在巨大的随机性，每十年才出一个长青产品。如果这事儿简单，我每次坐下来都能印出万亿美金市值的公司了。

---

### [01:19:15] Nikita Bier

**English:**
I be printing Facebook's every time I sat down. But I think it's actually a lot of it is pure randomness. On the other hand, growing a product can be a science. With certainty, if you're good at your job, you can make an app grow and go viral. Now why haven't I tried to take the viral part and build something that has been durable or long-lasting? I'll tell you a little bit about my motivations. My favorite part about product development is you make this thing through the night. You build it and you watch it take over the internet. That is the most thrilling drug I think you could ever experience. And just watching it spread all over the country is like you drop an app in the deep south in Georgia and then you look on your analytics dashboard and 40% of the high school down your street in Los Angeles has downloaded it one week later. That's a really profound feeling. It's crazy to have that sort of impact as a three-person team, and I live for that.

**中文翻译:**
我每次坐下来都能做出一个 Facebook。但我认为这其中很大一部分是纯粹的随机性。另一方面，让产品增长可以是一门科学。可以肯定的是，如果你擅长你的工作，你就能让应用增长并走红。至于为什么我没试着利用走红的势头去做一个持久的产品？我聊聊我的动机。我最喜欢的产品开发环节是：你通宵达旦做出了一个东西，然后看着它占领互联网。那是你能体验到的最刺激的“毒品”。看着它传遍全国——你在佐治亚州的深南部投放了一个应用，一周后看仪表盘，发现洛杉矶你家街角那所高中的 40% 学生都下载了。那是一种非常深刻的感觉。作为一个三人团队能产生这种影响，简直太疯狂了，我为此而活。

---

### [01:20:26] Nikita Bier

**English:**
When I joined Facebook, here's an interesting connection. So I joined Facebook and I saw that many of my peers were looking up to VPs and they're like, "That's what I want to make it to one day. I want to run a large organization. I want to have lots of reports." And then I met with VPs and they were actually jealous of me because my quality of life was actually pretty cool. I got to build something high impact that made many teens feel better about themselves, made a decent amount of money. And then I wasn't in charge of this becoming a people manager that has to run this large organization for many years. I think one day I will run maybe a venture scale business, but I will say that I kind of like the way that I've been doing things so far in terms of quality of life and being fun. Financially, it's been great. So I think that part is what motivates me. And yeah, I don't think running a large corporation is necessarily what I described as fun.

**中文翻译:**
我在 Facebook 时发现一个有趣的现象：很多同僚仰慕副总裁（VP），觉得“那是我奋斗的目标，我想管理大组织，有很多下属”。但我见到 VP 时，他们其实很嫉妒我，因为我的生活质量非常棒。我构建了高影响力的东西，让很多青少年感觉更好，赚了不少钱，而且我不需要成为一个必须管理大组织多年的职业经理人。我想也许有一天我会经营一家风险投资规模的大企业，但目前我挺喜欢现在的做事方式，无论是生活质量还是趣味性。财务上也很成功。所以这就是我的动力。而且，经营一家大公司并不在我对“有趣”的定义里。

---

### [01:21:40] Lenny Rachitsky

**English:**
That's amazing, man. I am really happy we went here. So much of this resonates with the way I think. And obviously, a big part of this is also just it's very hard, as you said, to build a consumer app that grows first of all. Second, that actually lasts. But that is interesting that you do hope to one day build a venture funded business.

**中文翻译:**
太棒了。我很高兴我们聊到了这个。这其中很多观点都引起了我的共鸣。显然，正如你所说，构建一个能增长的消费级应用已经很难了，让它持久更是难上加难。不过，你希望有一天能构建一家风投支持的业务，这很有意思。

---

### [01:22:03] Nikita Bier

**English:**
I mean TBH was venture backed, but I just don't... I think I'm going to have to... Do I want to sign up for 10 years? And if you actually look at some of the numbers on the actual proceeds that some of these founders get after an IPO, after seven rounds of dilution, a lot of them are pretty comparable to what we get from our apps for 90 days of work. So yeah, the trade-offs there are pretty faithful.

**中文翻译:**
tbh 当时也是风投支持的，但我只是在想……我真的想签下十年的卖身契吗？如果你看看一些创始人 IPO 后的实际收益，在经历了七轮稀释后，很多人的收益其实和我们花 90 天做个应用赚到的钱差不多。所以，这种权衡是很现实的。

---

### [01:22:36] Lenny Rachitsky

**English:**
Actually, just on that note, so what would make you actually decide to go venture funded? You talked about how if you're going more mainstream, non-teens folks after 22 years old, is that why you would go that route?

**中文翻译:**
顺着这个话题，什么会让你决定去拿风投？你提到如果要面向 22 岁以上的主流人群，那是你会走这条路的原因吗？

---

### [01:22:47] Nikita Bier

**English:**
I don't think that it's necessarily that part. I think if I could keep the team lean and scale up... I think there's some actual founders that actually operate very lean teams and have reached very large scale in terms of the valuations of the company. Actually the most iconic example is Elon Musk. His teams are actually pretty thin overall and he's in the weeds doing product development. And so I think, yeah, if I was to ever do it, I would do it under very specific set of operating principles versus turning it into a big tech company.

**中文翻译:**
我不认为一定是那个原因。我觉得如果我能保持团队精简并扩大规模……现实中确实有一些创始人带着非常精简的团队，却在公司估值上达到了巨大的规模。最典型的例子是埃隆·马斯克，他的团队总体上非常精简，而且他亲自参与产品开发细节。所以我想，如果我真的要这么做，我会遵循一套非常具体的运营原则，而不是把它变成一家传统的大科技公司。

---

### [01:23:34] Lenny Rachitsky

**English:**
Queue investor is emailing you right now with term sheets. Okay. Nikita, this has been amazing. There's one last segment I want to spend a little time on, which is just kind of a rapid fire of pieces of advice you've shared that I think is incredibly insightful about how to build a successful consumer app. And so I'm thinking I'll just go through three to five and see what you think and see what you can add to the advice. How does that sound?

**中文翻译:**
估计现在已经有投资者在给你发投资意向书（term sheets）了。好，Nikita，这太精彩了。最后一个环节我想花点时间做个“快问快答”，关于你分享过的一些我认为对构建成功消费级应用非常有见地的建议。我打算挑 3 到 5 条，看看你的想法，以及你有什么补充。你觉得呢？

---

### [01:23:59] Nikita Bier

**English:**
Sounds great.

**中文翻译:**
太棒了。

---

### [01:24:00] Lenny Rachitsky

**English:**
Okay, cool. So the first is just contact permissions in iOS 18 changes the game and how people can grow apps basically makes it harder to invite your friends. Thoughts on how people should be thinking about this in their products.

**中文翻译:**
好。第一条：iOS 18 的通讯录权限改变了游戏规则，让应用增长变得更难，基本上增加了邀请朋友的难度。你认为大家在产品中应该如何思考这个问题？

---

### [01:24:15] Nikita Bier

**English:**
When I first saw it, I was really concerned.

**中文翻译:**
我第一次看到这个变化时，非常担心。

---

### [01:24:19] Lenny Rachitsky

**English:**
I saw your tweet about it. You're like, "That's the end. Game over."

**中文翻译:**
我看到你发的推特了，你说：“完蛋了，游戏结束。”

---

### [01:24:23] Nikita Bier

**English:**
Just let me frame things up for you. The contact permissions screen, you average about 65% approval rate across all apps. It's higher for teens, lower for adults, but if you have a 65% consenting to contacts access, then the next step on this new iOS 18 change is you select which contacts you want to allow the app to access. And it's an alphabetical list. And that alphabetical list for me, I have 550 contacts or something. The first 10 contacts are punctuation symbols from whatever dirty entry I put when I was driving or something. So you have to scroll down and find that name. So I have to find Lenny. I have to add you. And what if you're not an app user? So I just added you or three others. Assuming users are willing to even do that. You and then the three others never sign up, but maybe three of your friends do. But I never get connected to them because there's no over... So my expectation is it's going to be very difficult to find friends on apps going forward to invite friends on apps going forward. And that founders will need to rethink how they do it. And of the companies, I'm working with on intro, we are looking at ways to reinvent what contact sync is or what purpose it served. It's not promising, but we have some good leads and I think we'll have a whole new set of apps emerging as a consequence. But if you're betting on contact sync as a company right now, you better start thinking about plan B.

**中文翻译:**
我来解释一下背景。通讯录权限弹窗在所有应用中的平均通过率约为 65%。青少年更高，成年人更低。但在 iOS 18 的新变化下，即使这 65% 的人同意了，下一步你还得手动选择允许应用访问哪些联系人。那是一个按字母顺序排列的列表，我有 550 个联系人，前 10 个可能是我开车时随手存的带标点符号的乱码。我得往下翻找到 Lenny，把你加进去。如果你还不是这个应用的用户呢？假设用户愿意这么麻烦地操作，我加了你和其他三个人，结果你们都没注册，而你另外三个朋友注册了，但我却无法和他们建立连接。所以我预计，未来在应用中寻找和邀请朋友会变得非常困难。创始人需要重新思考。在我咨询的公司里，我们正在寻找重新定义“通讯录同步”的方法。虽然目前看起来不乐观，但我们有一些不错的线索。我认为这会导致一波全新类型的应用出现。但如果你现在的公司完全押注在通讯录同步上，你最好开始考虑 B 计划。

---

### [01:26:23] Lenny Rachitsky

**English:**
So what I take away here is just it is now much different and there's an opportunity to think of something really clever that would give you a huge advantage if you can crack it.

**中文翻译:**
所以我理解的是：现在情况大不相同了，如果你能想出某种非常聪明的办法解决它，那将是一个巨大的优势。

---

### [01:26:23] Nikita Bier

**English:**
Yes, but most likely I think most apps will not have social graphs going forward and this will entrench incumbents even more. I don't think Apple acknowledged that. I think the person that designed the feature probably has never built an app or done contact sync before because the flow is egregiously bad and it doesn't actually even, I think, benefit the user's privacy because it just completely eliminates the feature altogether.

**中文翻译:**
是的，但更有可能的是，未来大多数应用将不再拥有社交图谱，这会进一步巩固巨头的地位。我不认为苹果意识到了这一点。我觉得设计这个功能的人可能从未开发过应用，也没做过通讯录同步，因为这个流程糟糕透顶，而且我认为它甚至没有真正保护用户隐私，因为它只是彻底扼杀了这个功能。

---

### [01:26:53] Lenny Rachitsky

**English:**
Next topic. So you helped this product called Dupe succeed. It's doing incredibly well from what I can see. And I saw you tweet about one of the key things that you helped them through, which is to invert, I'm reading this quote, "Inverting the time to value so that the user experience is the aha moment in seconds." Talk about that insight and how important that is to building a successful consumer social app.

**中文翻译:**
下一个话题。你帮助了一个叫 Dupe 的产品获得成功，据我所知它做得非常好。我看到你发推说你帮他们做的一件关键的事是“反转价值实现时间（time to value）”，让用户体验在几秒钟内就达到“惊喜时刻”。聊聊这个洞察，以及它对于构建成功的消费级社交应用有多重要。

---

### [01:27:18] Nikita Bier

**English:**
This kind of concept of getting users to the aha moment is something I recurringly bring up to every company I work with. And you have to understand that in 2024, people's attention spans are like three seconds. It's really sad, but we are spread thin through so many notifications, products, everything that if you can't demonstrate value in the first three seconds, it's over. And this also leads back to the contact sync question that you talked about was you have to sign up and then the first night you have to see all of your friends on the app and experience it, otherwise you'll churn.

**中文翻译:**
让用户达到“惊喜时刻”是我对每一家合作公司都会反复提及的概念。你必须明白，在 2024 年，人们的注意力只有大约三秒钟。这很悲哀，但我们被太多的通知和产品分散了精力，如果你不能在前三秒展示价值，那就结束了。这也回到了你提到的通讯录同步问题：你必须在注册后的第一晚就让用户看到所有的朋友并体验到产品，否则他们就会流失。

---

### [01:27:55] Nikita Bier

**English:**
So this idea of inverting the value, when I was working with Dupe, they had this kind of shopping app that had a bunch of different features and there was one feature that I saw that was interesting called Deal Hop and it allowed you to just put in a product page and it would find the cheapest version of it online. Something I already do through a bunch of duct taped methods of Google image search, Google Lens. And I was like, "That should be a whole company. But how are we going to teach users to do it and how do we expose them to that aha moment as fast as possible in a memorable iconic way?"

**中文翻译:**
关于“反转价值”的想法：在我和 Dupe 合作时，他们有一个购物应用，里面有很多功能。我发现其中一个叫 Deal Hop 的功能很有趣，你只需输入一个产品页面，它就能帮你找到全网最便宜的版本。这事儿我以前得靠谷歌图片搜索、Google Lens 等一堆笨办法凑合着做。我想：“这本身就该是一家公司。但我们该如何教会用户使用，并以一种令人难忘、标志性的方式让他们尽快体验到那个‘惊喜时刻’呢？”

---

### [01:28:38] Nikita Bier

**English:**
I had this product I built a while back where you just type the domain in front of an existing URL. So I told them, "You should try this. It's very marketable, but you need to get a very short domain that matches what you're doing." And so he went out and bought Dupe.com for I don't know how much, but when he bought that I was pretty excited. I'm like, well, if this doesn't work, I'm going to feel terrible, but if it does work, it's going to be a blowout success. So we put out a couple videos about it and then it was iconic, went viral, the videos. Users remembered to do it, to type dupe.com in front of a URL. Now I think they're making millions in ARR in a matter, and I think under 60 days of launching. And that was a blowout success. And of the companies I work with, I would say it happens about 50% of the time we hit that much success, but we hit success. I think 50% of the time it's outright failure because consumer is so random.

**中文翻译:**
我以前做过一个产品，只需在现有 URL 前面输入域名即可。所以我告诉他们：“你们应该试试这个，它非常有营销卖点，但你需要一个非常短且契合业务的域名。”于是他去买了 Dupe.com，我不知道花了多少钱，但他买下来时我很兴奋。我想，如果这行不通我会感觉很糟，但如果行得通，那将是巨大的成功。我们发了几个视频，结果视频火了。用户记住了这个操作：在 URL 前加上 dupe.com。现在我想他们在发布不到 60 天内就实现了数百万美元的年经常性收入（ARR）。这是一个巨大的成功。在我合作的公司中，大约 50% 的情况下能达到这种程度的成功，另外 50% 则是彻底失败，因为消费级市场太随机了。

---

### [01:29:41] Lenny Rachitsky

**English:**
And so what I'm hearing is a big insight is just ideally get to three seconds time to value. Is that the advice?

**中文翻译:**
所以我听到的核心洞察是：理想情况下，要在三秒钟内实现价值。是这个建议吗？

---

### [01:29:50] Nikita Bier

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:29:52] Lenny Rachitsky

**English:**
Sounds great. Easy peasy.

**中文翻译:**
听起来很棒，简单明了。

---

### [01:29:55] Nikita Bier

**English:**
Yeah. You really have to craft onboarding everything to ensure that that's where the design part comes in of being a great product person.

**中文翻译:**
是的。你必须精心打磨从新手引导（onboarding）到一切细节，以确保实现这一点，这就是优秀产品人的设计功底所在。

---

### [01:30:12] Lenny Rachitsky

**English:**
I imagine a big part of this is just cutting things you think... Like killing your darlings, cutting things you think people need and just being really ruthless with that,.

**中文翻译:**
我猜其中很大一部分工作是删减那些你认为……也就是“忍痛割爱”，删掉那些你以为用户需要的东西，并且要非常冷酷无情。

---

### [01:30:20] Nikita Bier

**English:**
Really ruthless, but also being extraordinarily creative with how you use the tools available to activate a user. I think extraordinary product people are deeply aware of every possible API and how it can be used in non-traditional ways. Like this URL trick was something that I think was non-traditional that people adopted very quickly. I have a whole laundry list of iOS mechanisms that people use for a certain way today, but you could invert them. Contact sync is a great example because you sync your contacts and then it finds all the friends and then ranks the people who are not on the app yet but have a bunch of friends on it. So there's a bunch of ways that you can one tap, expose a ton of value to users that I think founders often neglect. A lot of founders will go and say, "Oh, they can just exchange usernames and that's how they can add each other." That is the most unrealistic thing ever because that means you have to see the username, type it into the app. You have to do that what 50 times to get a 50-person friend list. So we're looking at 10,000 taps versus one. So that's what I mean by trying to get people to the activation moment, the aha moment and get them to value.

**中文翻译:**
确实要冷酷，但也要在利用现有工具激活用户方面极具创意。我认为卓越的产品人对每一个可能的 API 及其非传统用法都了如指掌。比如这个 URL 小技巧就是一种非传统的、但人们接受很快的方式。我有一长串 iOS 机制清单，人们现在习惯于某种用法，但你可以反其道而行之。通讯录同步是个好例子：你同步联系人，系统找到所有朋友，然后对那些还没注册但有很多朋友已在应用里的人进行排名。有很多方法可以实现“一键展示巨大价值”，但创始人经常忽略。很多创始人会说：“噢，他们可以交换用户名来互加好友。”这简直是最不现实的想法，因为这意味着你得看到用户名，再打进应用里，要重复 50 次才能加 50 个好友。这相当于 10,000 次点击对比 1 次点击。这就是我所说的：让人们尽快到达激活时刻、惊喜时刻并获得价值。

---

### [01:31:53] Lenny Rachitsky

**English:**
I love that advice. So maybe as just a last question along these lines. When you come to a founder, a relationship that you're a startup, you're trying to help, is there one more thing that you find often ends up being really helpful to them? Any common piece of advice that's like, "Oh, this is probably what's going to help you." You talked about this aha moment step, the contact sharing stuff. I guess is there anything else that's just like this is something that's probably going to help you with your app?

**中文翻译:**
我喜欢这个建议。关于这个话题最后一个问题：当你去帮助一个创始人或初创公司时，有没有哪件事是你发现通常对他们非常有帮助的？有没有什么通用的建议，比如“噢，这可能就是能帮到你的东西”？你提到了惊喜时刻、通讯录分享，还有别的吗？

---

### [01:32:20] Nikita Bier

**English:**
Right now, I think I advise around 35, 36 companies and all of them are at different stages of challenges they're facing. Some of them are pure at the product concept stage. Some of them are venture backed billion-dollar companies and each of them faces different problems. The first thing I often do is I ask them to show me the analytics. We look at how people are distributing the app today, what is the milestone that a user must hit to become activated and what's getting in the way of that? I also take a very deep look at every funnel that users come through. And I think a lot of founders separate marketing and product growth, like top of funnel growth from the actual products growth mechanisms, but they're both the same. They both should be treated as the same. If you're targeting a community and you want them to all adopt and get saturation, you need to build marketing that shows imagery of that community or whatever. And then when you get in the app, you have to be able to join that community. When you invite people from that app, that community needs to be mentioned. You need to actually cover everything from the ads to the in-app experience. All of that needs to be aligned for a user acquisition and flywheel to spin. A lot of people really screw that up. That's my initial rough approximation of what I do when I come in and try to fix or try to help with some of the challenges these companies are facing.

**中文翻译:**
目前我大约为 35、36 家公司提供咨询，它们面临的挑战各不相同。有些纯粹处于产品概念阶段，有些是风投支持的估值十亿美元的公司。我通常做的第一件事是看数据分析。我们看用户目前是如何分发应用的，用户必须达到哪个里程碑才算被激活，以及阻碍激活的因素是什么？我还会深入研究用户进入的每一个漏斗。我认为很多创始人把营销和产品增长（即漏斗顶端增长与产品内部增长机制）分离开来，但它们其实是一回事，应该被同等对待。如果你针对某个社区并希望达到饱和渗透，你的营销素材就得展示那个社区的意象；进入应用后，用户必须能加入那个社区；从应用发出邀请时，也必须提到那个社区。从广告到应用内体验，所有环节都必须对齐，才能让用户获取和增长飞轮转起来。很多人在这方面搞砸了。这就是我介入并尝试帮助解决挑战时的初步思路。

---

### [01:34:15] Lenny Rachitsky

**English:**
So this is actually a great segue to the final thing I want to make sure people understand is you help companies through this. Talk about how you work with companies where they can find you, what kind of companies you're looking to work with and how all that works.

**中文翻译:**
这正好引出了最后一点：你确实在帮助公司解决这些问题。聊聊你是如何与公司合作的，大家在哪里可以找到你，你希望与什么样的公司合作，以及整个流程是怎样的？

---

### [01:34:29] Nikita Bier

**English:**
So I work across the gamut. Most of them are consumer mobile companies and there certainly are web ones too, but I work with companies across stages. Typically, I recommend that you don't book me unless you're venture backed because it's a little expensive. But my main goal when someone does seek my advice through intro is I try to make them 10 times back their money in the first 30 days. And so far I think I've managed to do that with anyone who's met with me. And that means get all the table stakes, grow things out of the way, at the minimum. Then identify two to three step function changes that could change their growth trajectory. These are higher scope fundamental changes to the product. So I try to couple both, explain to them which direction I believe they should go, and it's a conversation and we talk about it. And then once they settle on a direction, I tend to get in the pixels. I go into Figma and we do a live session together and clean things up. I identify, "Oh, that's going to convert at this percent." And then I just manage all that. But yeah, it's generally post-series A. Some seed stage companies, and it's been really fun. It's kept my mind sharp on where the market is headed. I've also, over the years of building all these apps, I've accrued all these growth hacks that still nobody knows about. And so I share those when it's relevant for the company and it's been great. Dupe was one of them. I was advising Saturn. I rebuilt their Friend Finder. I think believe they're number one in the productivity section above ChatGPT as of today. But I think I've generally invested in about maybe 10% of the companies that seek out my advice.

**中文翻译:**
我的合作范围很广。大多数是消费级移动应用公司，也有网页端的，涵盖各个阶段。通常我建议除非你有风投支持，否则不要预约我，因为有点贵。但当有人通过 Intro 寻求我的建议时，我的主要目标是让他们在头 30 天内获得 10 倍的回报。到目前为止，我想我做到了。这意味着至少要搞定所有的基础增长工作，然后识别出两到三个能改变增长轨迹的“阶跃式”变化——这些是对产品更深层次的根本性改变。我会解释我认为他们应该走的方向，这是一个互动的过程。一旦确定了方向，我通常会深入到像素层面：我会进入 Figma，和他们一起进行实时协作，清理设计。我会指出：“噢，这个位置的转化率大概会是这么多。”然后我来打理这些。通常是 A 轮以后的公司，也有一些种子期的，这很有趣，让我对市场走向保持敏锐。这些年我积累了很多至今无人知晓的增长黑客技巧，我会根据情况分享给公司。Dupe 就是其中之一。我还为 Saturn 提供咨询，重构了他们的好友查找功能，我想他们现在在生产力类别排名第一，甚至超过了 ChatGPT。通常我会投资大约 10% 寻求我建议的公司。

---

### [01:36:31] Lenny Rachitsky

**English:**
Amazing. Well, I know it feels expensive to some people, but if I were a company with cash, it feels like the best deal I could find someone like you to come in and actually help me think through deeply in the pixels how to make my thing work. So I think you're still undercharging and I hope you keep raising your prices because clearly there's a lot of demand. Nikita, this was incredible. I feel like people see you on Twitter and they're like, "Oh, this guy, he's such a jerk sometimes." But meeting you in person and talking to you, it's very clear. You're really a kind dude, really thoughtful. All your advice is based on real things you have done. It's not just you sitting around pontificating and I think that's incredibly valuable and I'm excited. People are tapping that knowledge and you're sharing it with people in a wider scale.

**中文翻译:**
太棒了。虽然对某些人来说可能很贵，但如果我是一家有现金的公司，能请到你这样的人深入到像素层面帮我思考如何让产品奏效，这简直是最划算的交易。我觉得你收费还是低了，希望你继续涨价，因为需求显然很大。Nikita，这太精彩了。我觉得人们在推特上看到你，可能会觉得“噢，这家伙有时挺混蛋的”，但见到你本人并交谈后，很明显你是一个非常友善、非常有思想的人。你所有的建议都基于你亲手做过的事，而不是空谈。我认为这极具价值，很高兴看到大家正在汲取这些知识，而你也在更大范围内分享它。

---

### [01:37:15] Nikita Bier

**English:**
It's been a pleasure. Thanks for having me. We covered a lot and there's plenty more. I hope to come back after the next viral hit.

**中文翻译:**
这是我的荣幸。谢谢邀请。我们聊了很多，但还有更多可以聊的。希望在下一个爆款出现后我能再回来。

---

### [01:37:26] Lenny Rachitsky

**English:**
Oh man. So I was going to ask you, is there anything you're working on now or stages, what can you share? [inaudible 01:37:33]. Stay tuned.

**中文翻译:**
天呐。我正想问你，你现在在忙什么，或者处于什么阶段，有什么能分享的吗？（Nikita：敬请期待）。好的，敬请期待。

---

### [01:37:26] Nikita Bier

**English:**
Stay tuned.

**中文翻译:**
敬请期待。

---

### [01:37:34] Lenny Rachitsky

**English:**
Here we go. Amazing. I always ask people how can listeners be useful to you? So let me just ask you that as a final question, how can listeners be useful to you?

**中文翻译:**
这就对了。太棒了。我总是问嘉宾，听众能为你做点什么？所以作为最后一个问题：听众能如何帮到你？

---

### [01:37:41] Nikita Bier

**English:**
Follow me on Twitter and enjoy my shit posts. And I hope you have as much fun as me on Twitter.

**中文翻译:**
在推特上关注我，享受我的那些“废话推文”（shit posts）。希望你们在推特上能和我一样玩得开心。

---

### [01:37:49] Lenny Rachitsky

**English:**
I do, man. I love your tweets. Nikita, thank you so much for doing this and for being here.

**中文翻译:**
我确实玩得很开心，我喜欢你的推文。Nikita，非常感谢你能来分享。

---

### [01:37:54] Nikita Bier

**English:**
Yeah, thanks a lot.

**中文翻译:**
好的，非常感谢。

---

### [01:37:55] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。