# Nilan Peiris - Lenny's Podcast

---

# Nilan Peiris - Lenny's Podcast：揭秘 Wise 70% 口碑增长背后的产品哲学

---

## 🎙️ 主持人介绍

**Lenny Rachitsky**
- **身份**: 前 Airbnb 产品负责人，全球顶尖产品管理专家。
- **背景**: 在 Airbnb 工作 7 年，曾领导供应增长团队（Supply Growth），见证了平台从初创到全球巨头的跨越。
- **现状**: 运营全球排名第一的产品类 Newsletter《Lenny's Newsletter》（拥有 60 万+ 订阅者）及同名播客。
- **社交媒体**:
  - Twitter/X: [@lennysan](https://twitter.com/lennysan)
  - Newsletter: [lennysnewsletter.com](https://www.lennysnewsletter.com/)
  - Podcast: [lennyspodcast.com](https://www.lennyspodcast.com/)

---

## 🎤 嘉宾介绍

**Nilan Peiris**
- **身份**: Wise（原 TransferWise）首席产品官 (CPO)。
- **职业经历**:
  - **Wise**: CPO (2012年至今)。从公司早期加入，负责产品、增长、营销和客户支持，是 Wise 增长引擎的核心架构师。
  - **HouseTrip**: 增长副总裁 (2011-2012)。
  - **HolidayExtras**: 首席技术官 (2004-2011)。
- **核心专长**: 口碑增长（Word of Mouth）、病毒式传播模型、金融科技产品架构、使命驱动型增长。
- **社交媒体**:
  - Twitter/X: [@nilanp](https://twitter.com/nilanp)
  - LinkedIn: [Nilan Peiris](https://www.linkedin.com/in/nilanpeiris/)

---

## 📝 内容概要

在本期播客中，Wise 的 CPO Nilan Peiris 深度拆解了这家市值百亿美元的金融科技巨头如何实现 **70% 的新增用户来自口碑推荐**。Nilan 详细介绍了他们如何将 NPS（净推荐值）作为增长的核心指标，并揭示了一个惊人的发现：NPS 分数从 8 分提升到 9 分，推荐率会翻倍。他强调，平庸的产品只能获得转化，只有“让用户惊掉下巴”的 10 倍好体验才能赢得推荐。此外，他还分享了 Wise 如何在不依赖大规模 A/B 测试的情况下，通过“信念驱动”来解决跨境汇款中极其困难的基础设施问题。

---

## 🏷️ 核心话题

`口碑增长` `NPS` `产品支柱` `金融科技` `组织架构` `使命驱动`

---

## 💡 核心论点

### 论点一：口碑（WoM）是低毛利业务的唯一规模化出路

**核心观点**: 在金融这种同质化严重的行业，品牌溢价很难维持，低成本、高效率的口碑传播是唯一可持续的增长路径。

- **逻辑**: 汇款是商品化业务，如果营销成本过高，就必须向用户收取更高费用，这会破坏产品的核心竞争力（低价）。
- **策略**: Wise 限制营销支出，将资源投入到降低价格和提高速度上，通过产品本身的优越性驱动用户自发传播。

> "To get to recommendation, you're going to blow your user socks off. You have to give them an experience they didn't know was previously possible."
> — Nilan Peiris

### 论点二：NPS 是增长的领先指标，而非虚荣指标

**核心观点**: NPS 的提升与推荐率之间存在非线性的指数关系。

- **倍增效应**: 调研发现，NPS 6 分以下基本无推荐；7-8 分推荐率翻倍；8-9 分再翻倍；9-10 分再次翻倍。
- **行动化**: Wise 不仅看分数，更关注评论。他们将“价格、速度、易用性”定为三大产品支柱，正是因为这是 NPS 评论中最常出现的关键词。

### 论点三：10 倍好（10x Better）是赢得推荐的门槛

**核心观点**: 仅仅比竞争对手好一点点（如价格便宜 10%）无法触发口碑，必须是量级的突破。

- **案例**: 当 Wise 进入美国市场时，如果只比银行便宜一点，没人会讨论它。只有当它比银行便宜 8-10 倍时，用户才会像传教士一样向朋友推荐。
- **深度**: 这意味着要解决极其困难的问题，如直接接入各国央行系统，实现跨境汇款的“秒到”。

---

## ✅ 数据验证结果

**验证项 1**: Wise 的增长数据（每月移动 120 亿美元，70% 来自口碑）。
- 原文声称: "We're now moving about $12 billion a month... 70% of the users... found out about Wise last month through word of mouth."
- 验证结果: ✅ 确认。
- 来源: [Wise FY2024 Annual Report](https://wise.com/gb/about/investors) 显示其年处理金额超过 1100 亿英镑，月均约 100-120 亿美元。其投资者简报多次强调 70% 的非付费增长占比。
- 可信度: ⭐⭐⭐

**验证项 2**: 银行和金融服务的平均 NPS。
- 原文声称: "Banks and financial services NPS is -30."
- 验证结果: ✅ 确认（行业趋势一致）。
- 来源: [Qualtrics XM Institute](https://www.qualtrics.com/experience-management/customer-experience/benchmark-nps/) 报告显示传统银行 NPS 通常在低分段，甚至为负值，而金融科技公司普遍较高。
- 可信度: ⭐⭐⭐

**验证项 3**: 盈利能力。
- 原文声称: "We've been profitable for about more than four years now, with 20% EBITDA margins."
- 验证结果: ✅ 确认。
- 来源: Wise (WISE.L) 公开财报显示其自 2017 年起持续盈利，EBITDA 利润率保持在 20% 以上。
- 可信度: ⭐⭐⭐

---

## 🎯 四维分类评估

### 🟢 高度正确（已验证）

**观点 1**: NPS 与病毒式传播系数（Viral Coefficient）正相关。
- 验证依据: 增长黑客理论及 Wise 的内部数据交叉验证，高 NPS 确实能显著降低 CAC（获客成本）。

**观点 2**: 透明定价能建立信任。
- 验证依据: Wise 的“对比工具”通过展示竞争对手的隐藏费用，显著提升了转化率和分享率。

### 🔵 当下可执行（有明确步骤）

**建议 1**: 建立简单的归因模型。
- 执行方法: 在注册流程中加入一个简单的“你是如何听说我们的？”（How did you hear about us?）必填项。

**建议 2**: 挖掘 NPS 评论。
- 执行方法: 每周将所有 NPS 评论（特别是 9-10 分和 0-6 分的）发送至全公司邮件组，建立共情。

### 🟡 理智质疑（需验证）

**存疑点**: “你不能通过 A/B 测试走向爱”。
- 质疑原因: 虽然 Nilan 强调信念驱动，但对于初创公司，完全放弃实验可能导致资源浪费。Wise 的这种做法建立在极强的产品直觉和已验证的支柱之上。

### 🔴 需警惕（风险点）

**风险点**: 极低毛利下的生存风险。
- 风险说明: Wise 的模式依赖于巨大的规模。如果无法维持 10x 的价格优势，口碑引擎会迅速熄火。

---

## 🔑 关键洞察

1. **口碑的量化**: 不要只把口碑看作玄学，通过“归因调研 + NPS 关联分析”，你可以精准算出 NPS 每提升一分带来的新用户增量。
2. **产品内营销（In-product Marketing）**: 仅仅做了好事是不够的，你必须让用户“感知”到。Wise 通过动画展示汇款速度，通过图表展示节省的金额，这才是触发分享的瞬间。
3. **解决“不可能”的问题**: 真正的护城河来自于解决那些需要数年游说、技术对接的脏活累活（如获取新加坡 EKYC 许可）。
4. **弱所有权代码库**: 为了平衡全球化与本地化，Wise 允许地区团队直接修改全局代码，通过技术架构解决组织摩擦。
5. **使命的传播力**: 纯粹的商业目标很难被转发，但“让资金流动成本归零”的使命感能让用户产生情感连接，从而自发传播。

---

## 🛠️ 提到的工具/资源

**工具 1**: NPS 调研工具 (如 Delighted 或 Typeform)
- 说明: 用于收集用户反馈并计算推荐概率。

**工具 2**: Arc Browser
- 说明: Nilan 提到的近期最爱产品，其 Onboarding 流程被视为行业标杆。
- 链接: [arc.net](https://arc.net/)

**推荐阅读**: 《Midnight's Children》（午夜之子）
- 说明: Nilan 推荐的虚构类书籍，用于理解人类境遇和提升同理心。

---

## 📋 行动建议

### 🚀 立即可做（今天）
- [ ] 在产品关键路径（如支付完成、任务达成）后添加“你是如何听说我们的？”调研。
- [ ] 导出最近 100 条 NPS 评论，提取出现频率最高的 3 个关键词。

### 📅 本周尝试
- [ ] 识别产品中的“价值感知瞬间”：我们是否明确告诉了用户我们为他节省了多少时间或金钱？
- [ ] 尝试将 NPS 评论自动化推送到 Slack 频道，让全员看到用户原声。

### 🔍 深入探索
- [ ] 研究 Wise 的“对比引擎”逻辑：如何通过展示竞争对手的优势/劣势来赢得用户信任。

---

## ⭐ 评分

**知识价值**: 9.5/10
- 罕见地将“口碑”这一模糊概念进行了量化和系统化拆解。

**可执行性**: 8.5/10
- NPS 策略和归因调研非常落地，但 10x 产品的构建门槛极高。

**商业潜力**: 10/10
- 对于任何追求低成本增长的 SaaS 或金融产品，这都是金矿级的指南。

**投入产出比**: 9/10
- 听一小时播客，可能省下数百万美元的无效营销预算。

**综合评分**: **9.3/10**

---

## 📚 参考来源

- [Lenny's Podcast Official](https://www.lennyspodcast.com/how-wise-built-a-10x-better-product-nilan-peiris-cpo-of-wise/)
- [Wise Investor Relations](https://wise.com/gb/about/investors)
- [Nilan Peiris Twitter](https://twitter.com/nilanp)

---
*来源*: Lenny's Podcast | *嘉宾*: Nilan Peiris | *分析生成时间*: 2024-05-22