# Nilan Peiris - 双语对照

# Lenny's Podcast: Nilan Peiris (CPO at Wise) - Bilingual Transcript

---

### [00:00:00] Nilan Peiris

**English:**
Some people focus on conversion rate, like, "I'm going to make this really, really slick." And that's cool. You get a bit more growth. But to get to recommendation, you're going to blow your user socks off. You have to give them an experience they didn't know was previously possible. And when you are in that place of doing something that no one has ever done before, that's when you get it.

**中文翻译:**
有些人专注于转化率，比如想：“我要把这个流程做得非常非常丝滑。”这很好，能带来一些增长。但要达到让用户主动推荐的程度，你必须让用户“惊掉下巴”（感到震撼）。你必须给他们一种以前从未想过可能实现的体验。当你处于那种“做前人所未做”的境界时，你才能真正赢得用户的推荐。

---

### [00:00:23] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard won experiences building and growing today's most successful products. Today my guest is Nilan Peiris. Nilan is chief product Officer at Wise, where he has been for over 11 years, basically from the beginning of the journey. If you're not familiar with Wise, you should be. They make it incredibly easy and cheap to send money internationally. I am a regular user and customer, and because the product is so great, they've grown primarily through word of mouth. About 70% of their growth comes through word of mouth. And in our conversation, Nilan breaks down exactly how they made word of mouth so successful for their product. I don't know any founder who wouldn't wish to have more word of mouth growth, and Nilan's advice is the most tactical, and useful advice I've ever heard for how to actually drive your word of mouth growth. I am really excited for you to hear this episode, and to learn from Nilan. And so with that, I bring you Nilan Peiris, after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中辛苦积累的经验。今天的嘉宾是 Nilan Peiris。Nilan 是 Wise 的首席产品官（CPO），他在那里工作了超过 11 年，基本上是从公司创立之初就在了。如果你还不熟悉 Wise，那你应该了解一下。他们让国际汇款变得极其简单且便宜。我是他们的常客和忠实用户，正因为产品非常出色，他们主要通过口碑传播实现增长。他们约 70% 的增长来自口碑。在我们的对话中，Nilan 详细解析了他们是如何让口碑增长在产品中发挥如此巨大作用的。我不知道有哪个创始人不希望拥有更多的口碑增长，而 Nilan 的建议是我听过的关于如何实际驱动口碑增长最具战术性、最实用的建议。我非常期待大家能听到这一集并向 Nilan 学习。在听取赞助商的简短介绍后，让我们欢迎 Nilan Peiris。

---

### [00:01:20] Lenny (Sponsorships)

**English:**
(Lenny introduces Pendo and Wix Studio - *Omitted for brevity in translation as per standard practice for podcast content, but can be included if required. Moving to the interview start.*)

**中文翻译:**
（Lenny 介绍了赞助商 Pendo 和 Wix Studio。为了保持正文紧凑，此处省略广告内容，直接进入访谈部分。）

---

### [00:02:50] Lenny

**English:**
...Find out more at wix.com/studio. Nilan, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
……欲了解更多信息，请访问 wix.com/studio。Nilan，非常感谢你能来。欢迎来到本播客。

---

### [00:03:32] Nilan Peiris

**English:**
Thanks for having me, Lenny.

**中文翻译:**
谢谢你的邀请，Lenny。

---

### [00:03:33] Lenny

**English:**
So you're chief product officer at Wise, which I don't know if you knew this, but I'm a very happy weekly active user of. To give folks a little bit of context on Wise, could you just explain, what does Wise do? And also share maybe a few stats to give people a sense of the scale that Wise has reached at this point.

**中文翻译:**
你是 Wise 的首席产品官。我不知道你是否知道，我是你们非常忠实的周活跃用户（WAU）。为了给听众提供一些背景信息，你能解释一下 Wise 是做什么的吗？另外，能否分享一些数据，让大家感受一下 Wise 目前达到的规模？

---

### [00:03:51] Nilan Peiris

**English:**
We're looking to solve the problems associated with cross-border money movement, which is that moving money across border is pretty slow. It's actually really expensive, and it can be really hard to do. We solve it with three products, our money transfer product, which is what we started with, our account, which would be like, think of trying to solve the problems of international banking with our account for people, and for businesses. And then finally we've also got an enterprise product where we take the underlying infrastructure that's powered those products that we've built, and embed them in the banks, and products that people use every day, and then zooming into the numbers. So, we've got to come a little way on the journey. So today we're now moving about $12 billion a month, growing between 30 to 40% year on year. We take about 0.65% on average across all our routes as price, and we've been profitable for about more than four years now, with 20% EBITDA margins.
(00:05:05):
But probably the stat I'm most proud of, and the hardest thing to make happen out of all of that was we acquired 70% of the users that found out about Wise last month through word of mouth. So, contextually, we have 16 million customers, and we're acquiring about a million a quarter, about 10 million actives, and yes, so out of a million that joined Wise the first time, 700,000 found out about Wise from a friend.

**中文翻译:**
我们致力于解决跨境资金流动相关的问题，即跨境转账通常非常慢、非常贵，而且操作起来非常困难。我们通过三款产品来解决这些问题：首先是我们的汇款产品，这是我们的起家业务；其次是我们的账户产品，你可以把它看作是为个人和企业解决国际银行业务问题的方案；最后，我们还有一个企业级产品，我们将构建这些产品的底层基础设施嵌入到人们日常使用的银行和其他产品中。

谈到数据，我们已经走过了一段不短的旅程。目前，我们每月的交易额约为 120 亿美元，同比增长在 30% 到 40% 之间。我们在所有航线上的平均费率约为 0.65%。我们已经连续盈利超过四年，EBITDA（税息折旧及摊销前利润）利润率达到 20%。

但可能我最自豪的数据，也是最难实现的一点是：上个月发现 Wise 的用户中，有 70% 是通过口碑传播（Word of Mouth）获得的。背景是，我们拥有 1600 万客户，每季度新增约 100 万用户，活跃用户约 1000 万。也就是说，在首次加入 Wise 的 100 万人中，有 70 万人是从朋友那里听说 Wise 的。

---

### [00:05:36] Lenny

**English:**
There's a couple stats there that really stand out to me. One is you're gaining a million new users a quarter, which is insane. Just like a million new people joining Wise every quarter. That's an astounding number. The other number is what you just shared around word of mouth, that basically more than two thirds of people are discovering Wise and joining Wise through word of mouth. Mouth. I want to spend the bulk of our conversation on this topic of word of mouth. I think it's extremely rare how you've been able to increase word of mouth, and just how much of your growth comes through word of mouth.
(00:06:08):
You've essentially developed a system for how to drive word of mouth, and how to basically structure your team, your goals, your priorities and things like that in order to lean into this growth channel. And so, I just have a million questions around how you think about word of mouth, and the first is just, how do you measure word of mouth? How do you know that say, 70% of your growth is coming through word of mouth?

**中文翻译:**
其中有几个数据让我印象深刻。一是你们每季度增加 100 万新用户，这太疯狂了。每季度都有 100 万新人加入 Wise，这是一个令人震惊的数字。另一个数字就是你刚才分享的口碑增长，基本上超过三分之二的人是通过口碑发现并加入 Wise 的。我想把我们谈话的大部分时间花在“口碑传播”这个话题上。我认为你们能够如此显著地提升口碑，并且让它占据增长的绝大部分，这是极其罕见的。

你们实际上已经开发出一套驱动口碑的系统，包括如何构建团队、设定目标、确定优先级等等，以便全力投入这个增长渠道。所以我有很多关于你们如何思考口碑的问题。第一个问题是：你们如何衡量口碑？你们怎么知道 70% 的增长来自口碑？

---

### [00:06:28] Nilan Peiris

**English:**
We ask customers, is the short answer. So, we have an attribution model, as you can imagine, and we've had one from the early days, and it overlays all the referrer data and cookie data you have on visits comes to the website. So you kind of know that. And then you obviously have the soundtrack stuff, and we sample, and ask customers a set of questions on this, and then overlay that onto the... What turns up in your web tracking as direct traffic to give us a sense of how big that word of mouth number is, and that's what gets us back to the 70% stat.

**中文翻译:**
简短的回答是：我们直接问客户。如你所料，我们有一个归因模型（Attribution Model），而且从早期就开始用了。它会叠加所有关于网站访问的推荐来源数据和 Cookie 数据，所以你大概能知道一些。然后，我们显然还有一些调研手段，我们会进行抽样，向客户询问一系列相关问题，然后将这些结果叠加到网络追踪显示的“直接流量”（Direct Traffic）上，从而让我们了解口碑增长的规模。这就是我们得出 70% 这个数据的方法。

---

### [00:07:05] Lenny

**English:**
And very practically, how do you actually ask people? Is there a little pop-up on the website?

**中文翻译:**
从实际操作层面看，你们是怎么问的？网站上会有小弹窗吗？

---

### [00:07:09] Nilan Peiris

**English:**
It's actually integrated into the flow. So when we built it originally, we thought it's quite cool, marketing and acquiring customers is part of the product, and we should actually stitch that into the experience seamlessly so that we're able to do this more effectively going forward.

**中文翻译:**
它实际上是集成在流程中的。最初构建它时，我们认为这很酷——营销和获取客户本身就是产品的一部分，我们应该将其无缝地缝合到体验中，以便今后能更有效地开展这项工作。

---

### [00:07:26] Lenny

**English:**
That's actually, at Airbnb, exactly how the team did that, to understand what percentage of growth was word of mouth. It's just a little interstitial popup when you visit say, airbnb.com, "How'd you hear about us?" You think there's some fancy ways to understand the stuff, but it's just like, just ask people, they'll tell you how they heard about it.

**中文翻译:**
这其实和我们在 Airbnb 时团队的做法完全一样，以此来了解口碑增长的比例。当你访问 airbnb.com 时，会弹出一个简单的插页式窗口问：“你是怎么听说我们的？”你可能觉得会有什么高大上的方法来了解这些，但其实就是直接问，人们会告诉你他们是怎么知道的。

---

### [00:07:40] Nilan Peiris

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:07:41] Lenny

**English:**
Awesome. Okay, so just to kind of dig into the meat of it, what has been the biggest shift in helping you significantly grow word of mouth, and make it such a huge lever of growth for Wise?

**中文翻译:**
太棒了。那么，深入探讨一下核心内容：在帮助你们显著提升口碑并使其成为 Wise 如此巨大的增长杠杆的过程中，最大的转变是什么？

---

### [00:07:53] Nilan Peiris

**English:**
Yeah, before I launch into this, let's just also take a step back, and why even focus on this? So in the early days, when I met the founders, Kristo and Tyler. It was quite funny, I got introed to them when they were just the founders, and without a team really, and with the beginnings of a product, and they said, "Nilan, you've got to meet these guys, they've got a great product, they just don't have any customers." And I sat there with them, and we kind of launched the first Google ads, and in the early days you try everything, hoping that something works. But taking a step back, think of money as the ultimate commodity. It's pretty hard to build an expensive business that moves your money somewhere, and it costs a lot, so there's less of it afterwards.
(00:08:48):
So building a brand led money transfer business, the brand's got to be pretty damn good, right? You're going to feel pretty special afterwards, in order to have less money afterwards. So what we're looking for always, but what channels out there are super scalable, and can reach our entire audience, but have an incredibly low distribution cost. So, that's one thing that led us to word of mouth and the other bit, when we get on to talk about marketing later, the other challenge with marketing which is unique is because we are lower price, but a superior product, we have less margin to spend on marketing than others in certain paid channels. So that's another reason why marketing is inherently hard. Our marketing team does amazing work at Wise, in order to work within those constraints.
(00:09:36):
But back to your question, which was like, what's the biggest thing we've done to shift word of mouth. When I joined Wise, and started wrangling with word of mouth, I spent a bunch of time with friends of mine in the US and around the world, Andrew Chen, some of the other growth gurus, this is going back 10, 12 years. It's like what mouths, who's done it? What's the system? What do you measure? There wasn't really anything out there. So we kind of had to figure our way out. So, first step was asking it, and the second step was kind of figure out how do you know what's driving it? And the best proxy we found for this was something that most people have heard of, that we actually used quite a lot is net promoter score.
(00:10:26):
So from the very early days we'd start asking customers, and you probably have seen this survey, "Would you recommend Wise to a friend?"

**中文翻译:**
在深入探讨之前，我们先退一步想：为什么要关注这个？早期我见到创始人 Kristo 和 Taavet（注：此处 Nilan 误说成了 Tyler）时，情况很有趣。我被介绍给他们时，他们还只是两个创始人，几乎没有团队，只有产品的雏形。介绍人说：“Nilan，你得见见这俩人，他们产品很棒，就是没客户。”我和他们坐在一起，投放了第一批 Google 广告。早期你会尝试一切，希望能有效果。

但退一步看，钱是终极的同质化商品（Commodity）。如果你建立一个昂贵的汇款业务，把钱转到某处却收很多费，导致用户最后拿到的钱变少了，这很难做大。要建立一个品牌驱动的汇款业务，品牌必须非常出色，对吧？你得让用户在转完账、钱变少之后，依然觉得自己获得了某种特殊的体验。所以我们一直在寻找那些既能大规模触达受众，分发成本又极低的渠道。这就是引导我们关注口碑的原因之一。

另一个原因是，我们稍后会谈到营销，营销面临的一个独特挑战是：因为我们的价格更低但产品更优，我们在某些付费渠道上的利润空间比竞争对手小。这也是为什么营销对我们来说天生就很困难。Wise 的营销团队在这些限制下做了了不起的工作。

回到你的问题：我们为了转变口碑所做的最大的事情是什么。当我加入 Wise 并开始研究口碑时，我花了很多时间咨询美国和世界各地的朋友，比如 Andrew Chen 和其他增长专家，那是 10 到 12 年前的事了。当时大家都在问：什么是口碑？谁做成了？系统是什么？衡量什么？当时并没有现成的答案。所以我们必须自己摸索。第一步是询问用户，第二步是弄清楚是什么在驱动它。我们发现最好的替代指标（Proxy）是大多数人都听过的——净推荐值（NPS，Net Promoter Score）。从很早开始，我们就问客户那个你可能见过的调查问题：“你会向朋友推荐 Wise 吗？”

---

### [00:10:34] Lenny

**English:**
Never seen that ever in my life. Never been asked that question.

**中文翻译:**
这辈子从来没见过，从来没人问过我这个问题。（注：Lenny 在开玩笑，因为 NPS 极其常见）

---

### [00:10:39] Nilan Peiris

**English:**
Exactly. There's [inaudible 00:10:41] you said. And then in the end you've got the scale, zero to 10, and the theory is nine to 10 there are promoters, and zero to seven are detractors. Zero to six, detractors, and seven to eight are kind of neutral on your product. The intriguing bet was when we overlaid this... So we have word of mouth, it's about 50 odd percent, and then we have a referral program. When we overlay the referral data over the NPS survey data, we saw something really interesting.
(00:11:13):
There's very low invite rates at one to six, and not just invite, conversion rates of users that joined for invites. But when we've got people from sixes to this seven and eight group, they doubled the number of people they told. Eight to nine, they doubled again, and nine to 10, they doubled again. So, this is pretty crazy when you see it for the first time. I'm going to get back to your question in a sec, but it's quite core buildup to it, because when you are a product manager, like you've been in your career, one of your jobs is to figure out what metric are you going to optimize for? What are you going to try to get the business to ground behind? And if you optimize for something like conversion, rate and you move conversion rate with 10%, you kind of get this one-off hit.
(00:12:00):
But if you move the NPS from 30% to 50%, you increase the viral coefficient of your customer base. So every customer that goes through tells X many more. When you model this through, the ROI on NPS increases is absolutely huge. So, it's got to say, "Okay, this is the thing to zoom in on, so how to move it?" So, then the second magic of NPS is you get the numbers, but you also get the comments underneath it. I remember in the first year we built the NPS survey, and we emailed out every week all the comments to the whole company, which was pretty small, and we kept doing that, I think up till about three or four years, everyone got the NPS comments.
(00:12:51):
And when you read the comments, and now obviously we've got all kinds of fancy models sitting on top of these things, customers kept telling us the same things, "Make it faster, make it cheaper, make it easier to use." Do you know at the beginning, when I said, "Price, speed, ease of use," we kind of figured this out by thinking hard about this question. How do we make this product so good that people will use, it but they'll recommend it?
(00:13:20):
And customers were pretty clear, the ones that were evangelical, is the word we use, are the ones that had a much... Had this cheaper experience, the ones that were talking about it had a fast experience. So it's about price, about speed, it's about ease of use. And when you generalize and take a step back, and look at consumer product companies, they have these product pillars they call it, and they usually have KPIs around them. The second insight we got, found, is when we entered markets, like when we entered the US for the first time, if we entered with a product that was priced at say 5.9%, and the alternative was six, customers would use us, but they wouldn't talk about us. We only got the advocacy when we were eight to 10 times cheaper. That's when people started talking about it.

**中文翻译:**
没错。最后你会得到一个 0 到 10 的评分。理论上，9 到 10 分是“推荐者”（Promoters），0 到 6 分是“贬损者”（Detractors），7 到 8 分是“中立者”。有趣的地方在于，当我们把这些数据叠加起来看时……当时我们的口碑增长大约是 50% 左右，同时我们有一个推荐计划。当我们把推荐数据和 NPS 调查数据对比时，发现了一些非常有趣的事情。

在 1 到 6 分的区间，邀请率非常低，不仅是邀请率，通过邀请加入的用户的转化率也很低。但当我们把用户从 6 分提升到 7、8 分这一组时，他们告诉的人数翻了一倍。从 8 分提升到 9 分，人数又翻了一倍；从 9 分到 10 分，再次翻倍。第一次看到这个结果时，感觉非常疯狂。

我马上回到你的问题，但这是核心的铺垫。因为作为产品经理，你的职责之一就是弄清楚要优化哪个指标。如果你优化转化率，提升了 10%，你得到的是一次性的增长。但如果你把 NPS 从 30% 提升到 50%，你就增加了客户群的“病毒系数”（Viral Coefficient）。这意味着每一个经过流程的客户都会告诉更多的人。当你建立模型分析时，NPS 提升带来的投资回报率（ROI）是巨大的。所以我们决定：“好，这就是我们要重点关注的东西，那么如何提升它呢？”

NPS 的第二个魔力在于，你不仅能得到数字，还能得到下面的评论。我记得在建立 NPS 调查的第一年，我们每周都会把所有评论发邮件给全公司（当时公司还很小）。我们坚持这样做，我想大概持续了三四年，每个人都能看到 NPS 评论。当你阅读这些评论时（现在我们显然有各种高级模型来处理这些），客户一直在告诉我们同样的事情：“让它更快、更便宜、更易用。”

这就是为什么我一开始提到“价格、速度、易用性”。我们通过深入思考这个问题得出了结论：我们如何让产品好到人们不仅愿意使用，还愿意推荐？客户的反馈非常明确，那些我们称之为“福音传道者”（Evangelical）的客户，是那些体验到了极低价格或极快速度的人。所以核心就是价格、速度和易用性。

当你退一步看消费类产品公司，他们通常有“产品支柱”（Product Pillars），并围绕它们设定 KPI。我们得到的第二个洞察是：当我们进入新市场（比如第一次进入美国）时，如果我们的定价是 5.9%，而竞争对手是 6%，客户会使用我们，但他们不会谈论我们。只有当我们比对手便宜 8 到 10 倍时，人们才会开始主动推荐。

---

### [00:14:11] Lenny

**English:**
Let me actually interrupt you here a bit, just to kind of set a little frame around this, because this is extremely interesting, and I think people may miss, I think, some of the really interesting insights here. What I'm hearing is essentially there's this clear sense that you had to grow through word of mouth because of the business model. You didn't make a lot of money per user, and you didn't have a lot of money to spend thus, to help grow. So essentially it's like. "How do we grow the word of mouth?" And then it's, "Okay, what do we need to convince people to share this product?" And used NPS, which I think a lot of people use, and also a lot of people probably know, "Let's make our product more awesome so that people talk about it." Those are kind of like, "Oh yeah, of course."
(00:14:49):
But I think what I'm hearing is that you did that's really unique, is one, you found this huge delta between these detractors, and even seven or... I guess it was six and below, and then seven or eight, and then nine, 10 kept kind of doubling. So one is just this focus on, how do we get someone from there to there? Two is this really big focus on the comments of the NPS survey, not just like, "Oh we have this percentage of detractors." And then also I love how you just create these pillars, essentially, of like, "We're going to work on these three things. These are the three levers to help grow word of mouth for this product." Does that sound about right?

**中文翻译:**
让我打断一下，为这段内容做一个总结，因为这非常有趣，我担心人们会错过其中的一些深刻见解。我听到的是：本质上，由于商业模式的原因，你们必须通过口碑增长。你们从每个用户身上赚的钱不多，因此也没有很多钱投入营销。所以问题变成了：“我们如何增加口碑？”以及“我们需要什么来通过说服人们分享这个产品？”

你们使用了 NPS，虽然很多人都在用，也知道“让产品更棒，人们就会谈论它”，这听起来像是理所当然。但我认为你们做的真正独特的地方在于：第一，你们发现了贬损者（6 分及以下）与 7-8 分、9-10 分之间巨大的差异，尤其是推荐人数呈翻倍增长的趋势。所以重点变成了：我们如何把用户从一个档次提升到下一个档次？第二，你们极其关注 NPS 调查中的评论，而不仅仅是看贬损者的百分比。第三，我非常喜欢你们创建的这些“支柱”，即：“我们要专注于这三件事，这是驱动口碑增长的三个杠杆。”我理解得对吗？

---

### [00:15:25] Nilan Peiris

**English:**
That all makes sense. Obviously at the time, it is also way more chaotic.
(00:15:33):
So, at the beginning, everyone thinks it's 20 different things, and then over time, slowly, you understand that it's these things again and again. And a lot of building a successful businesses kind of building conviction that these are the things that matter. So, now I'd say price, speed, ease of use, it sounds... Like, but yeah, go back to seven, eight years. But we were arguing with each other around what, "Is it trust? Is it this? Is it this?" Trying to get clear on what are the things we missed there.

**中文翻译:**
完全正确。当然，当时的情况要混乱得多。刚开始时，每个人都觉得有 20 件不同的事情要做，但随着时间的推移，你慢慢明白，核心就是这几件事。建立一家成功的企业，很大程度上在于建立一种信念（Conviction），即这些才是真正重要的事情。现在我说“价格、速度、易用性”，听起来很简单，但回到七八年前，我们内部也在争论：“是信任吗？是这个吗？还是那个？”我们试图弄清楚是否遗漏了什么。

---

### [00:16:00] Lenny

**English:**
That would be useful actually to know. It sounds like, of course, it's going to be price and speed, but what are the things you kind of realize you don't need to focus on as much, based on these surveys?

**中文翻译:**
这确实很有用。听起来价格和速度是理所当然的，但根据这些调查，有哪些事情是你们意识到其实不需要投入那么多精力的？

---

### [00:16:09] Nilan Peiris

**English:**
Oh, wow, that's a really hard one. So, then the challenge, is as you know, everything is important.
(00:16:17):
Yeah? And that things that we use... We have a bucket called convenience. And inside the convenience bucket, there are many, many things hiding in there. And actually, you can measure this on contact rate, conversion rate, whatever, many different ways, and get many slightly different answers. So, I think I've learned there isn't... I haven't got a good answer on things we haven't-

**中文翻译:**
噢，哇，这真是个难题。挑战在于，如你所知，每件事似乎都很重要。我们有一个叫“便利性”（Convenience）的分类，里面隐藏着非常非常多的细节。实际上，你可以通过联系率、转化率等各种方式来衡量，得到略有不同的答案。所以，我觉得并没有……我还没有一个关于“哪些不重要”的好答案。

---

### [00:16:42] Lenny

**English:**
Well, as you said, trust, which is interesting. Obviously trust matters, but maybe it sounds like-

**中文翻译:**
嗯，就像你提到的“信任”，这很有趣。显然信任很重要，但听起来可能……

---

### [00:16:47] Nilan Peiris

**English:**
Trust certainly matters. Yeah, trust's a good one. Let's talk about that one bit. I'll talk to you through the trust problem. So I ran into the trust problem hardest in marketing. So, just imagine, you just started out, you've got a money transfer company, it's good, your product's really good, it's really cheap. So, you put an ad out, and it says, "Move money with Wise, and really cheaply," is anyone going to click that? People did, right? Is anyone going to use it? Yeah, people did use it. And you did work all the usual trust elements. But the bit I found that really helped, the way I got my head around this, was what people trust is their friends. And this really was way stronger a trust signal than anything I could put on a landing page.
(00:17:40):
And even when people came in through marketing, they'd been told. So marketing can aid recall, and all kinds of things, because people are told by their friends. They'd have a use case later on, then Google, and like, "Ah, I remember, this guy used this." And we do definitely get users, especially today as we've got a larger brand, through marketing direct. But trust in isolation is a really hard problem to solve. You need to get under the skin of what it means. People don't think my money is safe. "I don't know if this company is reputable," to unpick each of these problems and figure out systemically how to solve them. And we've done this to some extent, but really there's a massive shortcut, which is if you deliver your customers a good experience, then figure out, how do you make it so good they'll recommend it? Then that kind of shortcut a lot of really hard trust problems.

**中文翻译:**
信任当然重要。信任是个很好的例子，我们聊聊这个。我在营销中遇到的最大挑战就是信任问题。想象一下，你刚起步，开了一家汇款公司，产品很好且非常便宜。你打了个广告说：“用 Wise 汇款，超级便宜。”有人会点吗？确实有人点。有人会用吗？也确实有人用。你做了所有常规的信任背书工作。

但我发现真正起作用的、让我理清思路的是：人们最信任的是他们的朋友。这比我在落地页上放任何东西都要强有力得多。即使人们是通过营销渠道进来的，他们通常也已经听朋友提起过了。营销可以帮助唤起记忆——当他们以后有汇款需求时，去 Google 搜索，然后想起来：“啊，我记得某某用过这个。”虽然我们现在品牌大了，确实有很多直接通过营销进来的用户，但孤立地解决信任问题是非常难的。你需要深入了解其本质：人们担心钱不安全，或者不知道这家公司是否靠谱。你需要拆解这些问题并系统性地解决。我们确实做了一些工作，但真正的捷径是：如果你给客户提供极佳的体验，并让它好到让他们愿意推荐，那么这就绕过了许多极其困难的信任难题。

---

### [00:18:28] Lenny

**English:**
What did you find most helped increase trust in that way? Is it just get more people using it and then they'll share with their friends, or is there something you did there to...

**中文翻译:**
你发现什么最有助于以这种方式增加信任？是仅仅让更多人使用，然后让他们分享给朋友，还是你们做了什么特别的事情……

---

### [00:18:36] Nilan Peiris

**English:**
No, it was literally get more people using it, and they'll share with their friends. There's obviously a bunch of learnings we've had around what specific trust sentiments matter, especially geographically, but less powerful in the macro than get more people to use it.
(00:18:52):
So coming back to that, and I'd love to get your thoughts on this one. So, as you said, lots of people go up to NPS, and they kind of heard people talk about it, heard people talk about recommendations. So my learning on this is you've got to work really hard to get recommendation. So, to get a nine or a 10, so our NPS is 70%, so it's really, really high. So it's kind of higher than the iPhone, and Google search. So really, really high, so off the scale high.
(00:19:25):
And when we launch a market, or at the beginning it was much lower, so 20s and 30s. So instead it in context, like banks and financial services NPS is -30. So, most people don't recommend banks. So it's like, comes from a low base. But, what I've found is when you build a product, most founders, and most teams kind of stop when it works. As their next step, some people focus on conversion rate like, "I'm going to make this really, really slick," and that's cool, you get a bit more growth.
(00:20:02):
But to get to recommendation, you're going to blow your users' socks off, and the phrase we use is, you have to give them an experience they didn't know was previously possible. And when you are in that place of doing something that no one has ever done before, that's where you get it.
(00:20:24):
So the bar is all the way up there. And to put that in context, that means figuring out how to move money instantly. That means figuring out how to drop the price all the way from six all the way down to 0.35. And that's because there are systemic infrastructure issues in moving money around the world, which some people haven't solved before. And these problems are just really hard to solve. They take years to solve, but they have huge kind of returns when you do it.

**中文翻译:**
不，真的就是让更多人使用，然后他们会分享给朋友。当然，我们也学到了很多关于特定信任情感在不同地理区域的重要性，但在宏观层面上，这些都不如“让更多人使用”来得有效。

回到这一点，我也想听听你的看法。正如你所说，很多人都知道 NPS，听过关于推荐的讨论。我的经验是，你必须非常努力才能获得推荐。要得到 9 分或 10 分，我们的 NPS 达到了 70%，这非常非常高，甚至高于 iPhone 和 Google 搜索。简直是高得离谱。

当我们进入一个新市场，或者在最开始的时候，NPS 只有 20 多或 30 多。作为对比，银行和金融服务的 NPS 通常是 -30。大多数人不会推荐银行。所以我们是从一个很低的基数开始的。但我发现，在构建产品时，大多数创始人和团队在产品“能用”时就停止了。下一步，有些人会专注于转化率，比如“我要把它做得非常丝滑”，这很好，能带来增长。

但要获得推荐，你必须让用户“惊掉下巴”。我们用的说法是：你必须给他们一种他们以前认为不可能实现的体验。当你处于那种“做前人所未做”的境地时，你才能赢得推荐。所以门槛非常高。具体来说，这意味着要实现即时到账，意味着要将费率从 6% 降到 0.35%。这需要解决全球资金流动的系统性基础设施问题，这些问题以前没人解决过。这些问题极其难搞，需要数年时间才能解决，但一旦解决，回报是巨大的。

---

### [00:20:52] Lenny

**English:**
I love that just as a framework, is how do... We need to blow our users' socks off. And again, it just comes back to how you can get people to want to share this product, and drive word of mouth, blow their socks off.
(00:21:02):
I want to dig into how you actually just figured out what these attributes are. Obviously you talked about this NPS survey highlighting things. How did you decide it was instant money movement, and some of the other things? Is it just basically looking at these survey results, and picking the things that come up most often?

**中文翻译:**
我非常喜欢这个框架：我们需要让用户“惊掉下巴”。这又回到了如何让人们想要分享产品、驱动口碑增长——给他们震撼的体验。我想深入了解你们是如何确定这些属性的。显然你提到了 NPS 调查突出了某些重点。你们是如何决定“即时到账”以及其他事情是核心的？是仅仅看调查结果，然后挑选出现频率最高的东西吗？

---

### [00:21:20] Nilan Peiris

**English:**
Yeah, it was talking to customers, and looking at the survey results, and then through that, in many different ways, price will come up, speed will come up, ease of use will come up, and they kind of aggregate up to that.

**中文翻译:**
是的，就是通过与客户交谈并查看调查结果。通过这些方式，价格、速度、易用性会不断出现，最终汇聚成那几个核心支柱。

---

### [00:21:31] Lenny

**English:**
I think a lot of people listening are still going to be this like, "Okay, we're just going to make our product awesome, and it's going to grow." And in a sense, yeah, in another sense what you're sharing is essentially kind of a really simple framework for how to actually do that. To kind of go a little deeper there, when you see other people trying to drive word of mouth, trying to drive virality, is there anything you think people often do wrong? Is there other missteps you've taken in trying to drive word of mouth?

**中文翻译:**
我想很多听众可能会想：“好吧，我们只要把产品做得超棒，它就会增长。”从某种意义上说是这样，但从另一个角度看，你分享的其实是一套如何实现这一目标的简单框架。再深入一点，当你看到别人试图驱动口碑或病毒式增长时，你觉得人们常犯的错误是什么？或者你们在尝试驱动口碑时走过哪些弯路？

---

### [00:21:59] Nilan Peiris

**English:**
It's this thing around growth rate. So, especially product net growth, which is what we're talking about. So you can imagine, we're going to open a new market to Indonesia, and the fastest way to do it is to take... Someone else has figured out how to move to Indonesia. We take that infrastructure, and we'll plug it into Wise,
(00:22:18):
You know what? We can do this, we'll get some users. But it doesn't grow like a hockey stick. It doesn't grow like a hockey stick because we haven't fundamentally changed the problems in moving money internationally. So, got this mantra, you've got to build a 10x better product than what's there. And if it's 10x product better, basically it doesn't exist already. So if you're plugging in something else, that's kind of a misstep.
(00:22:45):
So it comes from a very logical place, how do I get users quickly? I can take a shortcut in doing this, but that, you kind of realize is wasted effort. So the step then becomes this much harder question of these types of questions. Like what is the theoretical minimum cost for moving money into a market? What is the theoretical maximum speed? Not just make it instant, make it cheap, but what actually is the lowest it could possibly be? And instead of incrementally going, doing a jump to make it a little better, a little better, a little better, you can never get there. How do we take two years, and end up there?

**中文翻译:**
这关乎增长率，尤其是我们正在讨论的“产品驱动型增长”。想象一下，我们要开拓印尼市场，最快的方法是找一个已经搞定印尼汇款路径的合作伙伴，把他们的基础设施接入 Wise。你知道吗？这样做确实能行，能获得一些用户。但它不会像“曲棍球棒”曲线那样爆发式增长。

之所以不能爆发式增长，是因为我们没有从根本上改变国际汇款的问题。我们有一个准则：你必须构建一个比现有产品好 10 倍的产品。如果一个产品好 10 倍，那它基本上是前所未有的。所以，如果你只是接入别人的东西，那就是一种失策。

这源于一个非常逻辑化的想法：我如何快速获得用户？我可以走捷径。但你最终会意识到那是白费力气。所以，接下来的步骤就变成了更难的问题：进入某个市场的“理论最低成本”是多少？“理论最高速度”是多少？不仅仅是“让它变快、变便宜”，而是“它到底能有多低、多快”？与其通过小步快跑、每次改进一点点（这样永远达不到极致），不如思考：我们如何花两年时间，最终达到那个极致的目标？

---

### [00:23:24] Lenny

**English:**
I love that. It's something that I talk about a lot. Something I learned at Airbnb is this idea of working backwards from the ideal, instead of working forwards from how do we iterate and make this better, and better, and better. It's like, okay, if we could start again, and we could create the ideal experience, what would that look like? And then work backwards from what would it take to get there?

**中文翻译:**
我太喜欢这个观点了。这也是我经常谈论的话题。我在 Airbnb 学到的一点就是“从理想状态倒推”（Working backwards from the ideal），而不是“从现状出发向前迭代”。就像是：好吧，如果我们能重新开始，创造一个理想的体验，它会是什么样子？然后倒推需要做些什么才能达到那里。

---

### [00:23:44] Nilan Peiris

**English:**
And what's an example of that at Airbnb? What was an ideal that you guys went for and then built?

**中文翻译:**
在 Airbnb 有什么例子吗？你们追求的理想状态是什么，后来又是怎么构建的？

---

### [00:23:49] Lenny

**English:**
The ideal was, there's this whole process where the founders hired this storyboard artist from Pixar to draw out the ideal experience of a host and a guest. So, there's these storyboards sitting in the office. I think there's 12 kind of... They call them key frames of, it's just like the booking experience being really seamless, arriving in the home, and being really amazed. Going out and finding things to do.
(00:24:13):
So, this became essentially the vision of the company is let's make each of these frames, these key moments of a journey for hosting a guest as incredible as possible. That was one, and that became essentially the strategy for a few years is just make each of these frames awesome.
(00:24:29):
And then there was another project that they were working on around booking at Airbnb. I don't know if you remember this, if you used Airbnb much, but most of Airbnb back in the day was you request to book with a host, you're like, "Hey, can I stay in your home?"
(00:24:41):
And turned out 50% of the time the guest was ignored, or rejected, and the host was just like, "Nah, no thank you." Now, over 80% as far as I know of bookings are instant bookings, where you just book and it's done, just like every other place you book online. And so that was a huge transition that I worked on, and that came from, if we were to start Airbnb again today, or if someone were to disrupt Airbnb, what would it look like? And obviously it'd be you just book. You're not sitting around hoping someone is cool with you. So, that came from that idea of just like, what would be the ideal Airbnb experience?

**中文翻译:**
理想状态是这样的：创始人聘请了一位来自皮克斯（Pixar）的分镜艺术家，画出了房东和房客的理想体验。办公室里挂着这些分镜图，大概有 12 个“关键帧”。比如预订体验非常顺滑、到达房源时感到惊艳、外出寻找好玩的活动等等。

这本质上成了公司的愿景：让我们把房客旅程中的每一个关键时刻都做得尽可能不可思议。这成了几年的核心战略：把每一个分镜都做到极致。

还有一个关于预订流程的项目。不知道你记不记得，如果你以前用过 Airbnb，大部分预订都是“申请预订”，你需要问房东：“嘿，我能住你家吗？”结果发现，50% 的情况下房客会被无视或拒绝。现在，据我所知，超过 80% 的预订是“闪订”（Instant Book），就像在网上订其他东西一样，点一下就完成了。这是我参与的一个巨大转型，它源于一个想法：如果今天重新创办 Airbnb，或者有人要颠覆 Airbnb，它会是什么样子？显然应该是“即订即得”，而不是坐那儿等着看房东愿不愿意理你。所以，这源于“理想的 Airbnb 体验应该是怎样的”这个想法。

---

### [00:25:15] Nilan Peiris

**English:**
That is incredibly inspiring. I'll try and share a couple of stories, analogies from Wise. I'll talk about two things. Let's talk about price first. So, it's a good question. So, Moneytrans has been around since the [inaudible 00:25:32]. How does a few people get together? And it's evolved towards moving trillions around the world, and generally retail consumers paying about six to 7% around the world to do it. How do a small team in Europe start out and figure out how to move it? We launched at 0.5%, and now we're down to about 0.35%. So what changed?

**中文翻译:**
这非常令人振奋。我也分享几个 Wise 的故事。我谈两点，先说价格。汇款业务已经存在很久了，现在全球每年的汇款规模达数万亿，通常零售用户的费率在 6% 到 7% 左右。欧洲的一个小团队是如何起步并搞定这个问题的？我们上线时的费率是 0.5%，现在降到了 0.35% 左右。那么，改变了什么？

---

### [00:25:57] Lenny

**English:**
Yeah, I was going to ask, how did you do that? That sounds like everyone would want to do that.

**中文翻译:**
是的，我正想问，你们是怎么做到的？听起来每个人都想这么做。

---

### [00:26:02] Nilan Peiris

**English:**
Yeah, so let's try to unpick it a little bit. So, first question you'd ask is, "I know what you're doing, you're losing money on every transfer." It's like, "Especially what you're doing," but we've been profitable for five years. And one of the magical things here was we're actually profitable in every transaction. So it's probably about four or five years ago, I led this project to start to pull together our pricing.
(00:26:30):
So, every month you get bills, and they turn up in your P&L, but every single bill we got, we allocated the cost back to the customer, or the transaction that generated it. And then we add our margin on top, and that's our price. And when you look at this and you analyze it, you'll find obviously there are 20% of customers generating 80% of the costs. And what you do is you get those 20%, you give them a raise, because they should cover their costs, and you drop the price to everyone else. And then the team works really hard on reducing these costs down, and then you move into a different segment in the market as the price costs come down. Does that make sense, Lenny?

**中文翻译:**
好，我们来拆解一下。你可能会问的第一件事是：“我知道你们在干嘛，你们每笔转账都在亏钱。”但事实上，我们已经盈利五年了。最神奇的一点是，我们实际上在每一笔交易中都是盈利的。

大约四五年前，我领导了一个整合定价的项目。每个月你会收到各种账单，它们体现在损益表（P&L）中。我们将收到的每一份账单成本都分摊回产生它的客户或交易上。然后我们在成本之上加上我们的利润空间，这就是我们的价格。当你这样分析时，你会发现 20% 的客户产生了 80% 的成本。你要做的就是让这 20% 的客户多付一点钱，因为他们应该覆盖自己的成本，然后降低其他所有人的价格。接着，团队努力降低这些成本，随着成本下降，你就能进入市场的不同细分领域。这能理解吗，Lenny？

---

### [00:27:13] Lenny

**English:**
Yeah. Essentially charge the heavier users more to counteract less frequent users. And essentially that drives word of mouth.

**中文翻译:**
明白。本质上是让高成本用户支付更多，以抵消低频/低成本用户的负担。这从本质上驱动了口碑。

---

### [00:27:22] Nilan Peiris

**English:**
Totally, but it's down to this level of, if an Australian customer calls up asking, "Where is my transfer?" That cost of that call gets allocated back to the AUD/GBP route. If a Brazilian business needs like 20 documents in order to be verified before we can give them an account, the cost of verifying check those customers goes back there, so that at a very atomic level starts happening. So yeah, as you said, the more expensive customers end up paying what they cost.

**中文翻译:**
完全正确。它细化到了这种程度：如果一个澳大利亚客户打电话问“我的汇款在哪？”，那次通话的成本就会被分摊回澳元到英镑的汇款路径上。如果一家巴西企业在开户前需要审核 20 份文件，那么审核这些客户的成本就会分摊到那里。这在非常微观的原子层面发生。所以，如你所说，成本更高的客户最终支付了他们应付的成本。

---

### [00:27:51] Lenny

**English:**
And it sounds like the more expensive markets.

**中文翻译:**
听起来也包括成本更高的市场。

---

### [00:27:55] Nilan Peiris

**English:**
Indeed, and the more expensive, systemically expensive markets. But let's get to that. So, what are the costs? So if you look at our P&L, there's just three costs at transaction level. You've got people costs, you've got the cost of risk, realized risk, and then you've got partner fees.
(00:28:16):
And so if you've got this mission of moving the world's money for almost nothing, or zero, as close to zero as you can, you've got to invest as much of your cashflow in engineering to try to engineer away these three problems. So just to take them through briefly a bit, and remember, we're trying to do this 10 times better than anyone else. So how do you really change the experience on each of them?
(00:28:40):
I'll cover a couple with you. So let's do the risk one first. There's two risks we have. We have have FX risk, you come to Wise you see your rate, and then you may send us the money a little later. If you're moving a million dollars, you can't usually move it instantly. It might take you two to three days to move it. The rate's locked, could move against us, we'd lose some money.
(00:29:01):
So that cost, if you look back, so we've halved that cost over the last few years, and you can imagine through understanding the bits of the product, they generate exposure, and limiting it, and a bunch of algorithms behind that. But the more inspiring stuff is the people costs, and the partner costs, go through each of these one at a time.
(00:29:25):
So the people costs are our customer service team, operations teams. But I like to think of that as the cost of poor quality. So you bring up customer support if the products are clear, you hire lots of people in the back office. If you haven't automated it. We get like 20% improvement year on year as we're doing that. But come back to your question, how do you step change that? How do you do a 10x better experience?
(00:29:49):
I'll share with you a story from Singapore. It's quite a fun one. Because we went to Singapore about six, seven years ago, and [inaudible 00:29:58], we asked for a license. We had 20,000 people on the wait list, or so, saying, "Wise, please come to Singapore." And we went there, we asked the regular, "Hey, can you give us a license?" They gave us the license, but they said, "You have to physically meet every single customer."

**中文翻译:**
确实，还有那些系统性高成本的市场。我们来看看具体的成本。在交易层面，我们的损益表只有三项成本：人力成本、风险成本（已实现的风险）以及合作伙伴费用。

如果你拥有“以近乎零成本移动全球资金”的使命，你就必须将尽可能多的现金流投入到工程研发中，试图通过技术手段消除这三个问题。我们简单过一下，记住，我们的目标是比别人做得好 10 倍。

我先说风险成本。我们有两种风险：汇率风险（FX risk）。你来到 Wise 看到汇率，但可能过一会儿才把钱汇给我们。如果你汇 100 万美元，通常无法瞬间完成，可能需要两三天。汇率是锁定的，如果汇率波动对我们不利，我们就会亏钱。过去几年我们将这项成本减半了，你可以想象，这是通过深入理解产品中产生风险敞口的部分、对其进行限制以及背后的一系列算法实现的。

但更令人振奋的是人力成本和合作伙伴成本。人力成本主要指客服和运营团队。我喜欢把它看作是“质量不佳的成本”。如果产品不够清晰，用户就会找客服；如果没有自动化，你就得雇很多后台人员。我们每年在这方面有 20% 的改进。但回到你的问题：如何实现跨越式改进？如何做到 10 倍好的体验？

我给你讲个新加坡的故事。大约六七年前我们去新加坡申请牌照。当时有大约 2 万人在候补名单上说：“Wise，请来新加坡吧。”我们去找监管机构申请牌照，他们给了牌照，但要求：“你们必须物理上（面对面）见到每一位客户。”

---

### [00:30:13] Lenny

**English:**
Great.

**中文翻译:**
太棒了（讽刺）。

---

### [00:30:14] Nilan Peiris

**English:**
Face-to-face. And this happens, this is... Remember, they're banks that people use. So people go into banks usually, and you get face-to-face verified when you open a bank account. We're like, "You don't need to do this in Australia, in the UK, in other countries around the world." They're like, "In Singapore, for your license, you need to do this." So we actually sent a small team out to Singapore, and we opened an office through [inaudible 00:30:43], and customers... You went through this really slick flow, and then you got invited in to come see the team.

**中文翻译:**
面对面核实。记住，人们通常去银行开户时都要面对面核实。我们说：“在澳大利亚、英国和世界其他地方都不需要这样。”他们说：“在新加坡，为了拿牌照，你必须这么做。”于是我们真的派了一个小团队去新加坡，开了一个办公室。客户在网上走完流畅的流程后，会被邀请来办公室见我们的团队。

---

### [00:30:49] Lenny

**English:**
Amazing.

**中文翻译:**
真不可思议。

---

### [00:30:50] Nilan Peiris

**English:**
And customers hated it, and it was really expensive, obviously.

**中文翻译:**
客户讨厌极了，而且显然成本非常高。

---

### [00:30:56] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:30:57] Nilan Peiris

**English:**
But the magic was we got the customers not to complain to us, but to complain to the government. And it took a year of lobbying, and a year of building, doing something unscalable effectively, before we got the world's first EKYC license in Singapore. So you could take a selfie, picture of your ID, and then you could get verified.
(00:31:21):
And that's what I call a 10x better experience than anyone else in the market, and that led to advocacy and word of mouth off the back of it. And that loop of getting your customers to help was also one of the learnings of word of mouth.

**中文翻译:**
但神奇的地方在于，我们让客户不是向我们抱怨，而是向政府抱怨。经过一年的游说和一年的建设（实际上是在做一件不可规模化的事），我们获得了新加坡第一个 EKYC（电子化身份验证）牌照。这样你就可以通过自拍、拍身份证照片来完成验证。这就是我所说的比市场上其他任何人都好 10 倍的体验，这随后带来了用户的拥护和口碑。让客户参与进来提供帮助，也是我们关于口碑增长的教训之一。

---

### [00:31:35] Lenny

**English:**
Was the product team involved? Were you involved in that on the ground stuff? Or was it like [inaudible 00:31:40]?

**中文翻译:**
产品团队参与了吗？你参与了那些地面工作吗？还是说……

---

### [00:31:39] Nilan Peiris

**English:**
Yeah, yeah. Generally when we go [inaudible 00:31:43], we're running cross-functional teams, but this is a verification team. The team actually would verify the docs when you sent it to us. They went out to Singapore, verified them onsite, face-to-face.
(00:31:54):
So the fun bit here is why would customers help a company? And this is one of the other learnings on word of mouth. The way I think about this is that there are the rational reasons why people recommend, which we've covered. But there's these emotional ones as well. Softer ones people would call brand. I prefer to call it on the mission.
(00:32:19):
So we do our mission, which is to make the world's money move instantly at the touch of a button, for almost nothing. It was a very personal thing, it was like an internal company thing, to think our customers cared about it. And then we rebranded like eight, nine years ago, our first rebrand, and we wrote our mission and sent it to our customers.
(00:32:41):
We got more new customers from that email being forwarded around than any other kind of marketing. And I show this when I talk at conferences. This email broke all the rules of marketing. It didn't have a call to action, it didn't have a button to sign up, it didn't have anything in it, but people just forwarded it around saying, "You should check out Wise."
(00:32:59):
And it's not all the customer base, but there was a proportion of the customer base that this resonated in. And I think it's the authenticity within which they could see that we were genuinely trying to.... Trying to bring the prices down was a scheme to help us grow faster, which is kind of where it started out, was actually genuinely because founders, they were really upset about how much it cost to money.
(00:33:27):
They found good ways to solve that problem, and they're still really passionate about solving that problem. And they could see that authenticity flows through the whole company, because we got a... When you look at Wise, we're full of people on visas, and immigrants, and people that have worked, and live around the world, and struggled with this problem, and are passionate about solving it. And so they wanted to help us solve it. So the second part of this word of mouth engine is for us, we managed to get this mission thing to work.
(00:33:53):
So somehow we emotionally connect our cause, and then I see going, taking a step back, getting 10x better on price is through our customers helping us do it, which gets us even cheaper, which then brings more customers, that then creates this flywheel that's spins around.

**中文翻译:**
是的。通常我们运行的是跨职能团队。当时是验证团队（Verification team），也就是当你发送文件时负责审核的团队，他们亲自去了新加坡，在现场面对面验证。

有趣的地方在于：为什么客户会帮助一家公司？这是关于口碑的另一个教训。我认为推荐有理性的原因（我们已经讨论过了），但也有感性的原因。有些人称之为“品牌”，我更喜欢称之为“使命”。

我们的使命是让全球资金流动实现即时、一键操作且近乎免费。最初这更像是一种个人情怀，或者是公司内部的事情，我们没想过客户会关心。大约八九年前我们第一次品牌重塑时，我们写下了我们的使命并发送给了客户。结果，那封邮件被转发带来的新客户比任何其他营销活动都多。我在会议上分享过这个：这封邮件打破了所有营销规则。它没有行动号召（CTA），没有注册按钮，什么都没有，但人们就是转发它并说：“你应该看看 Wise。”

虽然不是所有客户都这样，但有一部分客户产生了共鸣。我认为这是因为他们看到了我们的真实性（Authenticity）。降低价格最初是为了帮助我们增长，但核心原因其实是创始人对汇款成本太高感到非常愤怒。他们找到了解决办法，并且至今仍充满激情。这种真实性贯穿了整个公司。在 Wise，到处都是拿着签证的人、移民、在世界各地工作生活过、深受汇款之苦并渴望解决它的人。客户看到了这一点，所以愿意帮助我们。所以口碑引擎的第二部分是：我们成功地让“使命”发挥了作用。我们与客户在情感上建立了联系，通过客户的帮助，我们实现了 10 倍的价格优势，这让我们更便宜，吸引更多客户，从而形成了不断旋转的飞轮。

---

### [00:34:11] Lenny

**English:**
What a flywheel you guys have built. This reminds me of a lot of different things. One is you talked about how there's the reality of the things people need, and then there's this soft, fuzzy stuff that's harder to quantify. I actually is the framework just like that on that product I talked about of instant booking.
(00:34:27):
I kind of built a roadmap around the reality of what people actually need in order to feel comfortable, guests booking instantly. And then I call it the perception, what are their fears about letting guests book instantly? And there's a lot of work to just convince them, you think you're going to get all these guests that are really scary or whatever, but in reality it never happens. It's really rare something bad happens, and if it does, we're going to cover it.
(00:34:50):
So, I think that's a really cool framework when you're trying to get people to adopt something, is think about what do they actually need? And then how do you convince them of the things that are just in their head? And it sounds like the win there was kind of this sharing your mission and your values as a business.

**中文翻译:**
你们构建的飞轮太棒了。这让我想起很多事情。一是你提到的“人们需要的现实需求”与“难以量化的感性因素”。我在做“闪订”产品时也用过类似的框架。我围绕“人们为了感到舒适而真正需要的东西”构建了路线图，然后我称之为“感知”（Perception）——他们对让房客即时预订有什么恐惧？我们需要做很多工作来通过说服他们：你以为会遇到可怕的房客，但现实中几乎从未发生。即使发生了，我们也会赔付。

所以，当你试图让人们接受某样东西时，这是一个很酷的框架：思考他们真正需要什么，以及如何消除他们脑海中的顾虑。听起来你们的成功在于分享了公司的使命和价值观。

---

### [00:35:05] Nilan Peiris

**English:**
Yeah, it just sounds, again very tweedy, right? Tweedy, like sounds very corporate, sounds like it's never going to work, but I think it's also... I mean, Airbnb, the authenticity is there. People are passionate about making that experience work for both sides of the marketplace. It's kind of clear. So, I'm kind of taking a step back, personally very passionate about customer-led growth, and how that turns into shareholder value.
(00:35:32):
So, taking a step back, where every business I've ever worked in, it's always got these two lists, a list of things to do for your customers, and then it's got a list of things to do to make money. And you generally do everything you need to do to make money, and you do two things with the customer list, and you go, "Customer led business." And then, neat thing about wise, and I'm pretty sure you'll see the same thing on Airbnb is, we just had one list, which is this list of things that you need to do to make customers happy, and it's prioritized by impact on the really hard things. And if you do these really hard things, they have an incredible impact for customers, but hence on your growth, and on your shareholder value.

**中文翻译:**
是的，这听起来可能有点“老生常谈”或者太像企业公关辞令，感觉行不通。但我认为，像 Airbnb 一样，那种真实性是存在的。人们热衷于让买卖双方的体验都变好。我个人非常痴迷于“客户驱动型增长”以及它如何转化为股东价值。

在我工作过的每一家公司，通常都有两张清单：一张是“为客户做的事”，另一张是“为了赚钱做的事”。通常你会做完所有赚钱的事，然后从客户清单里挑两件做了，就宣称自己是“客户驱动型企业”。而 Wise（我相信 Airbnb 也是）最酷的地方在于，我们只有一张清单：为了让客户开心需要做的事。我们根据对解决难题的影响力来排序。如果你解决了这些难题，会对客户产生巨大影响，进而推动增长和股东价值。

---

### [00:36:11] Lenny

**English:**
That is really interesting. Airbnb is not quite like that. It's actually become more like that with a lot of just like, "Let's build awesome products and not focus on experiments as much." So that's really interesting that prioritization basically at Wise came from, "What are people telling us?" I guess let me ask actually, how did you know what the impact would be on customers? How did you decide? Is it frequency of how often people request it? Is it, "We need to lower the cost, and so we're just going to prioritize the things that will lower prices most?"

**中文翻译:**
这很有趣。Airbnb 并不完全是那样，但最近变得更像了，更多是“让我们构建出色的产品，不要太纠结于实验”。所以 Wise 的优先级基本上来自“人们在告诉我们什么”，这很有意思。我想问，你们如何预知对客户的影响？你们如何决定？是看请求的频率，还是说“我们需要降低成本，所以优先考虑最能降价的事情”？

---

### [00:36:37] Nilan Peiris

**English:**
Definitely on the journey at the beginning, you are into split testing, right? Let's try to take apart a split test on price. So, you've systemically dropped the cost. Imagine we drop the cost. The question is, do we drop the price? Do we pass that all on to customers? And do we keep some of it? And split testing on the price thing, if the split test is going to mean you end up with more revenue, it means you drop the price by 10%, and there happened to be that day, more than 10% more customers in the market who, they saw the price at one pound, but they see the price at 90p, at 10% lower, and they're like, "I wasn't going to shift at buy at one pound but I'm going to buy it 90p."
(00:37:23):
So this is pretty hard to do this. This word around conviction is one I use a lot, where you build this conviction that price is what matters. And through this incremental split test, you will take a long time to go there, but at some point you kind of go, "Actually I've got enough conviction." So there's one kind of strategic bet at the heart of Wise. That is if we have the lowest cost platform, and it's really fast, and really high quality, the world's volume will switch to us. And just marginally getting there step by step by step, and trying to track the incremental return is actually slower. And there's a point that comes that you go, "I feel really comfortable investing in price. I feel comfortable investing in speed, because I know it's going to pay back, and not necessarily this month, but eventually it will, and I need to make gains on all three levers in order to get there." Does that make sense?

**中文翻译:**
在旅程的开始，你肯定会做 A/B 测试（Split testing）。让我们拆解一下关于价格的测试。假设你系统性地降低了成本，问题是：我们要降价吗？是全部回馈给客户，还是留一部分？如果 A/B 测试是为了增加收入，那意味着你降价 10%，当天市场上必须增加超过 10% 的客户（因为价格从 1 英镑降到 90 便士而决定购买）。

这其实很难通过测试得出结论。我经常用“信念”（Conviction）这个词。你建立起一种信念，即价格才是核心。通过增量式的 A/B 测试，你需要很长时间才能达到目标。但在某个时刻你会说：“实际上我有足够的信念了。”Wise 的核心有一个战略赌注：如果我们拥有成本最低、速度最快、质量最高的平台，全球的交易量就会转向我们。如果只是通过一步步追踪增量回报，速度反而慢。到了某个阶段，你会觉得：“我非常放心地投资于价格和速度，因为我知道它会有回报，不一定是这个月，但最终会有的。我需要在所有三个杠杆上都取得进展。”这能理解吗？

---

### [00:38:13] Lenny

**English:**
Yeah, absolutely. So essentially, in that track of work, instead of everything that you did to reduce price, there wasn't an experiment to see, "What impact does this have on growth, or revenue?" Instead, it's just, "We know reducing price is going to help us grow, and so we're just going to track how much we're cutting price." And that's essentially the goals, I imagine, were just cut the price by some amount, find a way to make it this much cheaper every, say, quarter, or year.

**中文翻译:**
完全理解。所以本质上，在降价这条工作线上，你们并没有为每一项降价举措做实验来观察对增长或收入的影响。相反，你们只是坚信“降价会帮助增长”，所以你们追踪的是“我们降了多少价”。我猜你们的目标就是每个季度或每年降低一定比例的价格。

---

### [00:38:37] Nilan Peiris

**English:**
Yeah, that's it. You got it. And that conviction is core. That extends to our product management approach on the UX. So this is a great line for use internally, I'm sure you've heard it, "You can't split test your way to love." So, this experiment led product management approach, where you throw a bunch of things on the wall, and then you kind of see what sticks, and generally we don't advocate this. Obviously there's a bit of it that happens, but generally don't advocate it. Mainly because engineering is expensive, and you can actually figure out what matters to customers through other means. Some of the techniques we've talked, and build it.
(00:39:21):
There's a story I like to share. I had a product manager join our refer a friend team, viral growth team, and invite team, and after a quarter, I said, "So what are you going to build?" And he's like, "I'm going to test everything. I'm going to test the landing page, I'm going to test the subject line, I'm going to test the program so I don't know yet till run through all the tests, then I'm going to come back and tell you what I'm going to build."
(00:39:47):
I said, "You're not going to do this. I'm going to give you three weeks and you're going to pick one thing to change, but you're going to go talk to people, and get quantitative insights, and build your own gut feel around what matters, and then launch it, and submit, test it, and see if it works." But this thing of building conviction on what matters, and I watch how teams slowly build this and you need the data there to make sure it doesn't become a hubris, right? That enables you to make much bigger changes than just experimenting away, and it forces you to get clear on what actually is the problem to solve here, and how do I solve it really, really well? Does that make sense, Lenny, Do you disagree? It's a bit provocative there. Some people are pretty strong in the expert led approach.

**中文翻译:**
没错，就是这样。这种信念是核心。这也延伸到了我们对用户体验（UX）的产品管理方法。我们内部有一句名言，我相信你也听过：“你无法通过 A/B 测试赢得用户的爱。”（You can't split test your way to love.）那种“实验驱动”的产品管理方法——往墙上扔一堆东西看哪个能粘住——通常我们不提倡。虽然也会发生，但不是主流。主要是因为工程资源很贵，而且你完全可以通过其他手段弄清楚客户在意什么。

我喜欢分享一个故事。曾有一位产品经理加入我们的“推荐好友”和病毒式增长团队。一个季度后我问他：“你打算做点什么？”他说：“我要测试一切。测试落地页、测试邮件标题、测试奖励方案。在跑完所有测试之前我不知道要做什么，等测试完了我再回来告诉你。”我说：“你不能这么做。我给你三周时间，你必须选出一件事来改变。去和人聊天，获取定量洞察，建立你对‘什么才重要’的直觉，然后上线它，再通过测试看它是否有效。”

这种建立信念的过程，能让你做出比单纯做实验大得多的改变。它迫使你搞清楚到底要解决什么问题，以及如何把它做到极致。你同意吗，Lenny？这可能有点挑衅，因为有些人非常推崇实验驱动的方法。

---

### [00:40:30] Lenny

**English:**
No, there's many ways to do it. There's no right way, and it's working. So I'm not going to argue.
(00:40:35):
(Lenny introduces Masterworks sponsorship - *Omitted for brevity*)

**中文翻译:**
不，达成目标的方法有很多种，没有绝对的对错，而且你们的方法确实奏效了。所以我不会反驳。
（Lenny 介绍了赞助商 Masterworks。此处省略。）

---

### [00:42:00] Lenny

**English:**
So, what I'm hearing essentially, the experimentation culture at Wise is instead of just run, test everything that you're thinking about, throw out a bunch of ideas and see how they go, it's more, "Let's just decide we believe in this idea, and let's go bigger there, and run an experiment. Maybe not even." Is that roughly how you think about it?

**中文翻译:**
所以我听到的是，Wise 的实验文化并不是“测试你想到的每一件事，扔出一堆想法看结果”，而是更多地倾向于“让我们决定相信这个想法，然后大干一场，甚至可能都不需要实验”。大概是这样吗？

---

### [00:42:18] Nilan Peiris

**English:**
Yeah, yeah, yeah, yeah. And is that something that you've seen yourself in practice elsewhere?

**中文翻译:**
是的，没错。你在其他地方见过这种做法吗？

---

### [00:42:23] Lenny

**English:**
It's interesting how many parallels there are to Airbnb, because this is what Airbnb is doing now. There's been a shift recently, where instead of everything is very data experiment driven, it's very just like, "Let's build really great products that the founders are really excited about, and that the execs are hearing from people. Let's just build things that are awesome and launch them, and we believe things will grow." And Airbnb is doing great.

**中文翻译:**
有趣的是，这和 Airbnb 有很多相似之处，因为 Airbnb 现在就在这么做。最近发生了一个转变，不再是事事都由数据实验驱动，而是更倾向于“让我们构建创始人真正兴奋、高管们从用户那里听到的好产品。只要把东西做得超棒并发布，我们相信它就会增长。”而且 Airbnb 现在表现得非常好。

---

### [00:42:47] Nilan Peiris

**English:**
Yeah, the challenge of this is because it does become this risk thing of where it's like, okay, it's someone's opinion, so I think it's X, right? And everyone thinks they're kind of Steve Jobs type thing.

**中文翻译:**
是的，这种做法的挑战在于它会变成一种风险，即“这只是某人的个人意见”。每个人都觉得自己是乔布斯。

---

### [00:43:00] Lenny

**English:**
Yeah. That's right.

**中文翻译:**
没错。

---

### [00:43:01] Nilan Peiris

**English:**
You have some way of using data to get this conviction, and show why this is what we should do, but try to learn how to build that faster CME, slight difference. So, it's less product managers or me saying, "Hey guys, I think it's X." It's generally data driven, and qualitative insights driven as well.

**中文翻译:**
你需要某种方式利用数据来建立这种信念，并证明为什么我们应该这样做。这并不是产品经理或我随口说“我觉得应该是 X”，它通常是数据驱动的，同时也由定性洞察驱动。

---

### [00:43:23] Lenny

**English:**
Personally, I would always index towards running experiments just to put this out there, but I think in this case, it makes sense, where you just know, "We need to do these three things, just make it cheaper, make it faster." You don't need to AB test every idea there. Probably the main downside of not testing everything is you may be hurting things along the way, and you may not know it.

**中文翻译:**
就我个人而言，我通常还是倾向于做实验，但在你们这种情况下，这是合理的。当你已经明确知道“我们需要做这三件事：更便宜、更快、更易用”时，你不需要对每一个想法都做 A/B 测试。不测试所有东西的主要风险在于，你可能会在过程中损害某些指标而自己却不知道。

---

### [00:43:42] Nilan Peiris

**English:**
I mean, yeah, so we definitely do... So you're right. But there's a very different thing to when you look at the... From a sample size perspective, you want to do a beta, and understand the negative impact. It's a holdout group that's smaller, than a test to get a significance. It's quite define the criteria to know whether something is breaking, is generally a different thing to say, is this a material result in a test? Yeah.

**中文翻译:**
是的，我们确实会……你是对的。但从样本量的角度来看，做 Beta 测试以了解负面影响（使用较小的对照组），与为了获得统计显著性而做的测试是不同的。定义“某样东西是否坏了”的标准，与“这是否是一个重大的测试结果”通常是两回事。

---

### [00:44:09] Lenny

**English:**
And along those lines, the other benefit of experimentation is you know the impact. And so, team members can understand, "Here's what I did this quarter, this year." How do you think about just like performance reviews, and people's impact, and that kind of thing?

**中文翻译:**
顺着这个思路，实验的另一个好处是你知道影响力。这样团队成员就能明白：“这是我这季度、这一年做出的贡献。”你们是如何处理绩效评估和衡量个人影响力的？

---

### [00:44:21] Nilan Peiris

**English:**
Yeah, that's a good one. This one is definitely an ongoing debate. So, I generally ask teams what's their impact? So, every quarter, every team, what... [inaudible 00:44:29] or Kristo will ask, "What did you ship?" And I generally ask, "How many people used it? What was the impact on volume?" Et cetera. And we have analyst teams that can answer this either with pre-post analysis, all kinds of techniques, or all through split tests. We generally have this, the debate is where the analysis slows us down, and we wouldn't make a decision off the back of the analysis.
(00:44:54):
And then, this generally is what you said, where the team needs a validation, mainly for themselves, and maybe a little performance, but not too much. And so, there were ways in which you can maybe get some read on it that isn't quite as strong as a split test, which we'd use in these things. It's more just getting some... You can understand that people worried when you do split tests that slow down the release of something, but in order to get impact, if you know you're not going to roll it back, then okay, you should just roll it out, and try to reduce the need for that validation.

**中文翻译:**
这是个好问题，而且确实是一个持续不断的争论。我通常会问团队：“你们的影响力是什么？”每个季度，Kristo（创始人）会问：“你们发布了什么？”而我通常会问：“有多少人用了？对交易量有什么影响？”我们的分析团队可以通过前后对比分析（Pre-post analysis）或各种技术手段来回答，不一定非要通过 A/B 测试。

争论点在于分析是否会拖慢我们的速度，以及我们是否会根据分析结果改变决策。通常团队需要一种验证，主要是为了自我肯定，也为了绩效。所以有一些不那么严谨但比 A/B 测试快的方法。如果你已经确定不会撤回某个功能，那就直接发布，尽量减少对那种“验证”的需求。

---

### [00:45:31] Lenny

**English:**
I think that there's an interesting correlation between products that grow through word of mouth, and less need to experiment with everything. Airbnb is also actually 70% of growth is word of mouth from the last stat that I heard. And then you think about all these social consumer apps, they mostly grow through people sharing with their friends, and a lot of them come from just the founder's intuition of what a great product's going to be. I think about Snapchat, and the recent mobile social apps. And so I think maybe there's something there about just as a founder, trusting your gut more often. But then it becomes difficult as you grow. You have to delegate, and then you have to trust people on your team making the right decisions. I guess, is there anything there that you've learned about just trusting individual product teams to make decisions that you can't for sure know are positive or negative without running experiments?

**中文翻译:**
我认为在“通过口碑增长的产品”与“不需要事事实验”之间存在一种有趣的关联。我听到的最新数据是，Airbnb 也有 70% 的增长来自口碑。再想想那些社交应用，它们大多通过朋友分享增长，很多都源于创始人对“什么是好产品”的直觉，比如 Snapchat。所以，作为创始人，多信任直觉可能是有道理的。但随着公司规模扩大，这变得很难，你必须授权，必须信任团队做出正确的决定。关于如何信任产品团队在没有实验数据的情况下做出决策，你有什么心得吗？

---

### [00:46:23] Nilan Peiris

**English:**
So, as I say, almost everything we do, we have some way of understanding the impact. So, that's always there. We definitely have things where the team does something where Kristo or I will say, "This is just crazy. There's no way they're going to use this." And then we have a culture where people are encouraged to do these things, if they believe in it.

**中文翻译:**
正如我所说，几乎我们做的每一件事，我们都有某种方式来理解其影响。我们确实遇到过团队做了一些 Kristo 或我觉得“这太疯狂了，绝对没人会用”的事情。但我们的文化是鼓励人们去做这些事，只要他们坚信这一点。

---

### [00:46:48] Lenny

**English:**
Is there an example of that?

**中文翻译:**
有具体的例子吗？

---

### [00:46:49] Nilan Peiris

**English:**
Yeah, a couple. So the one [inaudible 00:46:52] that my head of SEO always talks about is a currency converter. So, the Wise homepage is a pretty good currency converter. It's got a decent one on there. There's tons of traffic on currency converter. So, if you click Wise link, now it's a little bit hidden on send, it's there. It's pretty cool. Currency converter.

**中文翻译:**
有的。我的 SEO 负责人经常提到的一个例子是“汇率转换器”。Wise 的首页其实就是一个很好的汇率转换器。汇率转换器这个词有巨大的搜索流量。

---

### [00:47:10] Lenny

**English:**
Oh I see it at the bottom there. Yeah, it's like [inaudible 00:47:13].

**中文翻译:**
噢，我看到页面底部那个了。

---

### [00:47:14] Nilan Peiris

**English:**
But if you Google currency converter, there's tons of traffic, and that converter on the Wise homepage obviously includes our price, and lets you sign up. And so, should we build a currency convertor? Should we try to capture this traffic? Is it more effective to try to push our own product there? And you can kind of understand why it was Kristo, actually not me, that was like, "This is a crazy idea." And the founder, and the SEO team went out and built it, and it's huge now, in terms of visits. I think we've got a currency convertor app out there. I think we've got [inaudible 00:47:51] out there, and yeah, people discover wise through that, as an example of off-topic traffic, but that's a good example of one of those things where yeah, the founder said, "No," or, "That's' a bad idea," and we kind of went ahead, and did it anyway.

**中文翻译:**
如果你在 Google 搜索“汇率转换器”，流量非常惊人。Wise 首页的转换器显然包含我们的价格并允许注册。那么，我们应该专门做一个汇率转换器吗？我们应该尝试捕捉这些流量吗？还是直接推我们的汇款产品更有效？你可以理解为什么 Kristo（创始人）当时觉得“这是个疯狂的主意”。但 SEO 团队还是去做了，现在它的访问量巨大。人们通过它发现 Wise，这是一个“非直接相关流量”转化为用户的绝佳例子，也是一个创始人说“不”但团队坚持做下去并成功的例子。

---

### [00:48:07] Lenny

**English:**
Awesome. I'm just thinking about broadly all the things we've been talking about. There's a couple of things that were floating around in my head. One is, reminds me of Amazon, where Jeff Bezos realized there are things that are going to be always true with Amazon. People always want cheaper prices, they want faster shipping. And I think there's something else. And it feels like you guys found the same sort of thing. What are the three things people always want with a money transfer product? And let's just make those as incredible as possible, and in your eyes, make them 10 times better than what anyone else has out there.

**中文翻译:**
太棒了。回顾我们谈论的内容，我脑子里浮现出几件事。一是这让我想起亚马逊，贝索斯意识到有些事情在亚马逊永远是正确的：人们永远想要更低的价格、更快的配送。感觉你们也找到了类似的东西：人们对汇款产品永远追求的三件事。你们的目标就是把这些做到极致，比别人好 10 倍。

---

### [00:48:40] Nilan Peiris

**English:**
Yeah, totally. The business one example is relevant, and use it a lot when we talk to investors in the market, [inaudible 00:48:49] public helps validate this low cost, cutting price story. What's interesting is what changed though. So we started with transfers, but we got to account, and then we got to enterprise. Just what changed was we realized with account, if you just have to move $10, you're not going to download an app and do it. If you do it once, you're just going to do it in your bank. And so, that was a little bit of the insight behind building the Wise account, and we kind of focused on, there's a real problem with international banking.
(00:49:22):
So, really good example is for businesses. So if you are a business, say, in... Say a business in Europe, you've got a customer in Australia, and you want to get paid, you send them an invoice in Euros, and someday, some money's going to turn up in your account, you're like, "I don't know." They paid you an AUD, it got changed by three banks on the way through. You don't know what it is. What you'd love to do is invoice them in AUD, and get AUD in your bank account. You might even have people who need to pay in AUD, so you have to call to keep it there. But to get an Australian bank account, I found out, you need to fly to Australia, you need to incorporate a business in Australia, you need to go to a bank with all those papers, and then they will give you an Australian bank account number.

**中文翻译:**
完全正确。我们经常向投资者讲这个“低成本、不断降价”的故事。有趣的是我们的演变：从汇款到账户，再到企业服务。我们意识到，如果你只需要汇 10 美元，你不会专门下载个 App，你会直接用银行。这就是构建 Wise 账户的初衷——解决国际银行业务的真实痛点。

一个很好的例子是企业。假设你是一家欧洲公司，有一个澳大利亚客户。你给他们发欧元发票，某天你的账户里多了一笔钱，但你不知道那是啥，因为客户付的是澳元，中间经过三家银行转换。你最希望的是直接发澳元发票，并在账户里收到澳元。但要获得一个澳大利亚银行账户，你得飞去澳洲，在当地注册公司，带着一堆文件去银行。

---

### [00:50:06] Lenny

**English:**
Great.

**中文翻译:**
太麻烦了。

---

### [00:50:07] Nilan Peiris

**English:**
So with Wise, you can get an Australian bank account number with three clicks. Anyone can, and any business can, and you get an Australian balance, and a US, and a UK, and a Swiss bank. And this is killer for businesses that receive money internationally. And then the next big jump we did, and for consumers, so there are plenty of people, if all your banking is in the US, you probably shouldn't use Wise, but if you're somebody who uses another currency a lot, then you probably should use us as your primary bank.
(00:50:37):
There's some people, for example, who live in one country and get paid in another currency, and this is... Wise is great as an account for managing that. And we found with that, we got about... As we launched the account in markets, it was about a 20 to 30% more volume, cross-border volume coming into Wise from that market. Just a good example of how, while it's not price, not speed, you could argue is kind of ease of use, but we had to evolve it in order to get to the next tranche of the market. Does that make sense, Lenny?

**中文翻译:**
但在 Wise，你只需点三次鼠标就能获得一个澳大利亚银行账号。任何人、任何企业都可以。你可以同时拥有澳元、美元、英镑和瑞士法郎的余额。这对有国际收款需求的企业来说是杀手锏。

接下来的大动作是针对消费者的。如果你所有的银行业务都在美国，你可能不需要 Wise。但如果你经常使用另一种货币，你可能应该把我们当作主银行。比如有些人住在一个国家，但领的是另一种货币的工资。Wise 账户非常适合管理这种情况。我们发现，在市场推出账户功能后，来自该市场的跨境交易量增加了 20% 到 30%。这是一个很好的例子：虽然这不直接关乎价格或速度（你可以说它是易用性），但我们必须进化产品才能触达下一批市场受众。

---

### [00:51:07] Lenny

**English:**
Absolutely. And it all just comes back from what would be the theoretical ideal situation for people transferring money, say from Australia. And what I'm hearing is just find all the little friction points that get in the way. In this case you're like, "Okay, we'll create you an Australian bank account, and you don't even worry about it."

**中文翻译:**
完全明白。这又回到了“理论上的理想状态”：比如从澳大利亚汇款的人最想要什么。我听到的是：找出所有阻碍流程的微小摩擦点。在这种情况下，你们说：“没问题，我们直接给你开个澳洲账号，你啥都不用担心。”

---

### [00:51:25] Nilan Peiris

**English:**
Yeah, that's exactly it. And so now then you have all these other problems, because we've got about $12.5 billion in deposits now, which is like a time. And the next problem customers are at is, "I want a return." And we quite deliberately don't have a banking license. You have to figure out, how are we going to solve that? We now put customers money in government bonds, US bonds, and when you pay with your card, it dynamically sells those bonds. And that's how we give you an interest rate, in roundabout 5% right now, given where bond rates are.

**中文翻译:**
没错。现在我们又面临新的问题，因为我们现在有大约 125 亿美元的存款。客户接下来的需求是：“我想要收益。”而我们刻意没有申请银行牌照。所以我们必须想办法解决：我们现在把客户的钱投入政府债券（如美债），当你用卡消费时，系统会自动卖出这些债券。这就是我们如何为你提供约 5% 利息的方式。

---

### [00:51:58] Lenny

**English:**
Yeah, interest rates are quite high, for better or worse. Zooming out a little bit, for folks that are starting to... Their wheels are turning, they're like, "Okay, I want to think about word of mouth, driving word of mouth. I'm going to go look at my survey results. I'm going to figure out these pillars that are driving word of mouth. I'm going to think about how to make things 10 times better." Just broadly, for someone that's starting to approach this, what would you say to them? How should they approach this? Any major learnings at a higher level, of just how to drive word of mouth for a product?

**中文翻译:**
是的，现在的利率确实很高。稍微跳出来看，对于那些开始思考“我要驱动口碑增长、研究调查结果、确定增长支柱、把产品做大 10 倍”的人，你有什么建议？他们该如何着手？在更高层面上，关于如何驱动产品口碑，有什么核心心得？

---

### [00:52:30] Nilan Peiris

**English:**
I think it just comes back to talking to customers and this is the question we've kept coming back to. What would it take to make it 10x better? And then you get clear in your head what it would take, and then it's usually the thing that everyone's looked at before and thought, it's the thing that's impossible. One more example is on the partner side. So, rather than find a cheaper bank for a banking partner, you think, well, the cheapest banking partner is the central bank. And imagine you're a startup. How the hell do you get a bank account at the central bank?
(00:53:08):
But that kind of thinking, and we now have a bank account at the Bank of England, the National Bank of Singapore, Bank of Australia. And each of these was as hard as getting that face-to-face verification thing in Singapore. It took years of lobbying, and all kinds of stuff, in order to make it happen. But it's setting your goal all the way up there. That's what enables you to build a 10x better product. That's what gets you to the word of mouth. So, the first step is getting super clear on what's the problems that my customers are caring about, worrying about? And then once you're clear there, as you said, how can I solve that completely, and what's the best it could possibly be? And then the hard bit is figuring out how to move that.

**中文翻译:**
我认为还是要回到与客户交谈，以及那个核心问题：如何才能让它好 10 倍？当你理清思路后，你会发现那通常是每个人以前都看过但觉得“不可能实现”的事。

再举个合作伙伴的例子。与其找一家更便宜的银行作为合作伙伴，不如想：最便宜的银行合作伙伴其实是中央银行。想象一下你是一家创业公司，你到底怎么才能在央行开户？但正是这种思维，让我们现在在英格兰银行、新加坡国家银行、澳大利亚银行都拥有了账户。每一项都像在新加坡搞定面对面验证一样难，需要多年的游说。但正是把目标定得那么高，才让你能做出好 10 倍的产品，从而赢得口碑。所以第一步是搞清楚客户真正担心的问题，然后思考如何彻底解决它，以及它能达到的极致状态是什么。最难的部分是想办法去实现它。

---

### [00:53:48] Lenny

**English:**
A lot of these things you're talking about are just, they sound like they are either impossible, like no way we're going to achieve that, or really, really hard. And a lot of companies, and a lot of founders, teams are just like, "Okay, we're not ever going to create a bank here. We're not going to be able to create an Australian bank account for everyone." What is it about your culture, or approach to these problems that you think that's unique to Wise that's like, "No, we're going to spend three years figuring this out, because it's that important?"

**中文翻译:**
你谈到的很多事情听起来要么是不可能完成的任务，要么是极其困难。很多公司和团队会想：“好吧，我们永远不可能在这儿开银行，也不可能给每个人开澳洲账号。”在 Wise 的文化或方法论中，有什么独特之处让你们觉得：“不，我们要花三年时间搞定这个，因为它就是那么重要”？

---

### [00:54:16] Nilan Peiris

**English:**
I think it's two [inaudible 00:54:17]. So one is, definitely the founders have this philosophy that unless you're doing something hard and new, it's kind of a waste of time. So, I think that also kind of runs through the culture. So, it's quite a rude awakening when people join Wise, because they're like, "Okay, I'm going to come, and just play around with a few things." You're like, "No, actually, the culture of the product team is we're super incentivized to do the hard things, and that's what's rewarded."
(00:54:46):
And that's quite hard to create the air cover. You can imagine like then in the early days and months when growth was slow, and people turned on the money taps in marketing, and you're trying to keep focused and plugging your away up these hard things, it's quite hard also to get the management cover in order to let the teams keep doing this. And then it's also hard just to turn up to work and really keep... You can imagine being in Singapore, verifying customers face-to face, thinking, "This is going nowhere, this is going nowhere, this is going nowhere." And then suddenly it changes. So that's what progress very much feels like at Wise. And we try to recognize that, and create a culture that enables that.

**中文翻译:**
我认为有两点。一是创始人有一种哲学：除非你在做一些困难且创新的事情，否则就是在浪费时间。这种理念贯穿了整个文化。当人们加入 Wise 时，往往会感到一种“幻灭”，因为他们以为只是来随便做点小功能，但实际上，产品团队的文化是：我们非常有动力去做那些最难的事，而且那才是受奖励的。

要提供这种“空中掩护”（Air cover，指高层的支持和容错）很难。你可以想象在早期增长缓慢的时候，别人都在疯狂砸钱做营销，而你却试图保持专注，死磕这些难题。获得管理层的支持让团队坚持下去是非常难的。而且，每天上班面对那些看似毫无进展的工作也很难——比如在新加坡面对面验证客户，你会想“这根本行不通”。但突然间，局面就打开了。这就是 Wise 式的进步。我们努力认可这种模式，并创造一种支持它的文化。

---

### [00:55:21] Lenny

**English:**
It feels like there's also just a lot of patience for these things. There isn't like, "We need to hit this quarterly goal. Why aren't we creating banks in Singapore yet?"

**中文翻译:**
感觉你们对这些事情非常有耐心。不会说：“我们需要达成这个季度的目标，为什么新加坡的银行还没搞定？”

---

### [00:55:29] Nilan Peiris

**English:**
Yeah, exactly.

**中文翻译:**
没错。

---

### [00:55:31] Lenny

**English:**
Awesome. The other kind of metaphor that's rolling around my head is something Seth Godin talks about. I don't know if you've heard of this guy, he's a marketing guru, and he has this concept that you want to build something that's remarkable, because if something is remarkable, it'll spread. And if you think about the word remarkable, it's something worth remarking about, which essentially is word of mouth.

**中文翻译:**
太棒了。我脑子里闪过的另一个隐喻是 Seth Godin（营销大师）谈到的：你要构建一些“非凡”（Remarkable）的东西，因为如果东西非凡，它就会传播。如果你仔细想想 Remarkable 这个词，它的意思就是“值得被谈论”（Worth remarking about），这本质上就是口碑。

---

### [00:55:49] Nilan Peiris

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:55:49] Lenny

**English:**
And so that's his kind of mission and his, I don't know, advice to people is build something remarkable, something people will want to remark about. And clearly, you all have been doing that. And that's actually a good segue to where I wanted to go, which is around how you structure your team, and how you incentivize the team, organize teams, to achieve all these sorts of things. So, maybe just broadly, is there something unique to how you think about work structure, incentives, goals, things like that, in order to achieve these really hard things?

**中文翻译:**
所以他的建议是：构建一些非凡的东西，一些人们想要谈论的东西。显然你们一直在这样做。这正好引出了我想聊的下一个话题：你们如何构建团队、如何激励团队、如何组织团队来实现这些目标？在组织架构、激励机制、目标设定等方面，有什么独特之处吗？

---

### [00:56:17] Nilan Peiris

**English:**
There's two unique lenses on this. One is in the macro-structure and one is in the micro-structure. So at the macro level, if you look at actually international banks, they don't really exist. I'm not sure if you've moved around between countries, but say you open a bank account with Citibank in the US, and then you go to Citibank in the UK, your Citibank account doesn't exist in the UK. You have to go to Citibank in the UK, and open a Citibank account. And actually, turns out, with some of these banks, to move money between your bank accounts is an international transfer. It's crazy.
(00:56:53):
So, when you take a step back, and look at how the market looks, you have at one end, international banks which are local tech stacks. So there's a core banking system in the US, and one in the UK, and one in Europe, say for Citibank, or for HSBC, but they have deep local integrations, so they're directly integrated in the payment system. Citibank in the US has got relationships, say, with the Federal Reserve, et cetera.
(00:57:20):
Other end of the spectrum you've got something like PayPal. So it's a tech company, it's got a single global tech stack. It doesn't run a additional version of PayPal in Australia than to the US, but it doesn't have deep connections. It hasn't got five central bank accounts, it hasn't got any of that. And I'd like to think of in the middle, you've got Wise, where we have a single global tech stack, and we have deep local infrastructure.
(00:57:45):
Now, from a technological perspective, just take a step back and think through this. This is actually non-trivial to figure out how to design. So, let's take something like the onboarding flow. So, we have global product teams, one part of product teams called global product teams. So we have a single onboarding flow that will give you a Wise account, and it's the same code that runs, whether you are in Brazil, New York, or Australia.
(00:58:17):
The regulation in Australia and Brazil is really different, and it isn't black and white in any country. So, there's a bunch of... You get a bunch of things you just shouldn't do in terms of letting people get so [inaudible 00:58:31] people who shouldn't get access to accounts. And then you can need to check these people aren't using it, and different jurisdictions have completely different requirements. Example is Japan, you have to take a picture of that front of the ID, the back of the ID, and the side of your ID. It's the only country in the world that you have to do this.

**中文翻译:**
这有两个独特的视角：宏观结构和微观结构。在宏观层面，如果你观察所谓的“国际银行”，它们其实并不真正存在。如果你在不同国家间搬迁过，你会发现你在美国花旗银行开的户，到了英国花旗并不存在，你得重新开户。甚至在某些银行，在你自己不同国家的账户间转账也算国际汇款，这太疯狂了。

所以，市场现状是：一端是拥有本地技术栈的国际银行（美国、英国、欧洲各有核心系统），它们有深厚的本地集成（直接接入支付系统、与美联储有关系等）。另一端是像 PayPal 这样的公司，它是纯技术公司，拥有单一的全球技术栈，但缺乏深厚的本地连接（没有央行账户等）。而 Wise 处于中间：我们拥有单一的全球技术栈，同时拥有深厚的本地基础设施。

从技术角度看，这非常难设计。以“注册流程”（Onboarding flow）为例。我们有全球产品团队，负责单一的注册流程。无论你在巴西、纽约还是澳大利亚，运行的都是同一套代码。但巴西和澳洲的监管完全不同，而且并非非黑即白。不同司法管辖区的要求千差万别。比如日本，你是全世界唯一一个需要拍摄身份证正面、背面和侧面的国家。

---

### [00:58:47] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:58:48] Nilan Peiris

**English:**
And imagine you're the product manager for onboarding, and someone tells you, "Design the onboarding flow to give somebody a bank..." Just imagine gathering all the requirements from every country in the world, because there's very little similarity. You can't just say, "I take the US," and copy it somewhere else. It's very, very, very different.
(00:59:05):
It'd take forever to try to get that, and then normalize that into the main model, and try to figure out how you're going to structure the data around this. So, it then becomes like, what is the organization structure that enables us to discover what the domain model, let's call it that, for the onboarding flow should look like. And you end up with a global product team that owns overall KPIs around conversion rate, et cetera. And you have local, regional teams that own the conversion rate, and the cost to do KYC for their market, and they contribute to the global product code base.
(00:59:44):
So we have weak product ownership, where anyone can make code change, and pull requests, and these guys owning the vision in the center. But the only way that vision can evolve is by getting the feedback from these guys in the market, as they're constantly pushing stuff forward. And through that process, artifacts start emerging, where other markets are like Japan, and so you start splitting off that, and creating subtypes for it, and slowly the model emerges from there.
(01:00:09):
And so with this structure, the thing to optimize for is a really hard one. That problem that every global business has, is how do you get this collaboration to work between the local and the global? But unlike every other business, most businesses solve this probably as you know, is you usually have the US, and then you have international. And international is usually a bump site, where everyone's arguing to get their thing prioritized, right?

**中文翻译:**
想象一下你是负责注册的产品经理，要设计一个全球通用的流程。收集全球每个国家的需求简直是噩梦，因为几乎没有相似之处。你不能直接复制美国模式。

如果试图把所有需求标准化到一个主模型中，会花掉一辈子时间。所以，问题变成了：什么样的组织架构能让我们发现注册流程的“领域模型”（Domain Model）应该是怎样的？我们最终采用了这样的结构：一个全球产品团队负责整体 KPI（如转化率），而本地/区域团队负责该市场的转化率和 KYC（身份验证）成本，并直接向全球产品代码库贡献代码。

我们实行“弱产品所有权”（Weak product ownership），任何人都可以修改代码并提交 PR，而中心团队负责愿景。愿景进化的唯一方式是获取市场一线团队的反馈。在这个过程中，模型会逐渐演变，比如发现某些市场像日本，就为其创建子类型。这种结构解决了全球化企业最难的“全球与本地协作”问题。在大多数公司，通常是“美国总部”和“国际部”，国际部往往是个受气包，大家都在争抢优先级，对吧？

---

### [01:00:29] Lenny

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:00:30] Nilan Peiris

**English:**
Whereas here, you're kind of letting the local teams commit directly to the code base, and then this global team's got this challenge of doing this, and we over time create sub-teams around parts of the regionalization of the structure, around different objects as they emerge. But that broadly speaking is the first problem, the global problem. And the other bit with us is this is quite unique to us, because most fintechs out there are usually in one market. Like you take Robin Hood, it was in the US, it came to the UK, they went back to the US. You take Monzo, only the UK, N26 only in Europe, Up in Australia, China, and the US. And that's because their home markets are so big, and one regulator is a ton of work to manage. And the second complexity we have is we have all of these markets we have to be in, because we're international by default. So a lot of our thinking is where do we take that, turn that into competitive advantage, and which customer base really needs that? Which is what zooms us into that positioning on the international account.

**中文翻译:**
而在 Wise，我们让本地团队直接向代码库提交代码。这很独特，因为大多数金融科技公司通常只在一个市场。比如 Robinhood 主要是美国，Monzo 只有英国，N26 只有欧洲。因为本土市场足够大，搞定一个监管机构就已经够呛了。但 Wise 天生就是国际化的，我们必须在所有这些市场中存在。所以我们的思考点在于：我们如何将这种复杂性转化为竞争优势？哪些客户群真正需要这种服务？这正是我们定位“国际账户”的原因。

---

### [01:01:32] Lenny

**English:**
It just comes back to again, and again, again and again, doing the hard thing, knocking peoples' socks off, and it feels like that's the formula for Wise.

**中文翻译:**
这又一次回到了：做难事，让用户惊艳。感觉这就是 Wise 的成功公式。

---

### [01:01:41] Nilan Peiris

**English:**
I think yeah, you more or less got it. So that's one bit on structure. So this global local thing, and the second one has been a bit more of a journey. So when we started early on, we ran in autonomous independent teams, all focused on KPIs, and these KPIs rolled up to make it cheaper, make it faster, make it easier to use. You can imagine like a KPI tree, and teams around bits of their KPIs, and every quarter they talk through how they move their KPI, et cetera, and this kind of worked. And the way we ran our planning is, every quarter every team would stand up and talk through its plan, get feedback from other teams, and then move on. This worked till we got to 30 teams, and then you go from doing this in the afternoon, to doing it in two days and it's just like whoa.
(01:02:27):
So, we started heading towards the Spotify model, where we group the teams in squads, and into tribes. Today, I think that autonomy is at the squad level. So the squads are around products. So, we'll have a Wise account squad, a business squad, a Wise platform, our enterprise product squad, you'll have a North Am squad that looks after the North American product, and Lat Am squad, et cetera. And then financial crime fighting, et cetera.
(01:02:57):
And inside those squads you've got the teams, and the squad... Imagine you're the director for the Wise account, but you don't have a vision for the account. You've got to say where it's going. You've got to keep your teams on track against it. The teams aren't off doing whatever they want. They kind of need to be on track, versus the overall vision, and you're accountable for the results of that squad. And squads are in tribes, the tribe provides overall leadership, and a slight, light touch strategy on the squads. And that's more or less our structure, and how we've evolved towards it.

**中文翻译:**
是的，你基本总结到位了。这是结构的一部分：全球与本地的协作。第二部分是我们的演变历程。早期我们运行的是自主独立的团队，专注于 KPI（更便宜、更快、更易用）。你可以想象一棵 KPI 树，团队围绕各自的指标运作。每季度每个团队都会展示计划并获取反馈。当团队增加到 30 个时，这种方式就不行了，会议从一个下午变成了两天。

所以我们开始转向“Spotify 模式”，将团队分为“小队”（Squads）和“部落”（Tribes）。现在的自主权主要在小队级别。小队围绕产品划分：比如 Wise 账户小队、企业小队、平台小队、北美小队、拉美小队、金融犯罪打击小队等。在小队内部有具体的团队。作为小队负责人，你需要设定愿景并确保团队不偏离轨道。小队归属于部落，部落提供整体领导和轻量级的战略指导。这就是我们目前的结构。

---

### [01:03:26] Lenny

**English:**
Is there anything else along the word of mouth concept that you think would be useful for people to share? Either how you think about it, team structure, anything else?

**中文翻译:**
关于口碑增长这个概念，还有什么你觉得值得分享的吗？无论是思考方式、团队结构还是其他方面？

---

### [01:03:34] Nilan Peiris

**English:**
There's one tiny bit I'll share, which was around marketing and referral. This was super interesting for me. So, we've been running it, like Airbnb, we've been running referral program for now 12 years, and after 12 years, you've kind of tested everything anyway. And like I said, by this point you have literally tested everything. So when somebody comes up with something that has a 300% increase, you're like, "Whoa, that's super interesting. What just happened?"

**中文翻译:**
我分享一个小细节，是关于营销和推荐的。这对我来说非常有趣。和 Airbnb 一样，我们的推荐计划已经运行了 12 年。12 年后，你基本上已经测试过所有东西了。但当有人提出一个能带来 300% 增长的东西时，你会惊呼：“哇，这太有意思了，发生了什么？”

---

### [01:04:03] Lenny

**English:**
Wow, I'm excited for this.

**中文翻译:**
哇，我很期待这个故事。

---

### [01:04:05] Nilan Peiris

**English:**
And yeah, I'll share this one, because it's interesting. So we run many variants of refer a friend, where you'll get different kinds of benefit. We tried chocolate, we tried money, we've tried $200, $500, $10, you get some, I get some money, all kinds of things. More or less headed towards three for $100, generally it's a sweet spot. Anyway, it's a pretty creative PM there. And he was again talking to customers, and he spotted this thing, which is pretty cool, which is when you do a transfer with Wise, at the end you get this email, the email says, "Well done." Then it says, "Your money's there in the other person's account, and you saved $10 on this transfer." And he got this insight, which was pretty awesome, was he realized that people believed they saved money, but they didn't believe the number. And he then thought, what would it take to get them to believe the number?

**中文翻译:**
是的，这个很有趣。我们尝试过各种“推荐好友”的变体：送巧克力、送钱、送 200 美元、500 美元、10 美元等等。最后发现“推荐 3 人得 100 美元”通常是个甜点位。

当时有一个非常有创意的产品经理，他在和客户聊天时发现了一个很酷的洞察：当你完成 Wise 转账后，会收到一封邮件说“干得好，钱已到账，你这笔转账省了 10 美元”。他意识到，人们相信自己省了钱，但不相信那个具体的数字。于是他想：怎样才能让他们相信那个数字呢？

---

### [01:05:05] Lenny

**English:**
That seems right.

**中文翻译:**
这听起来很符合直觉。

---

### [01:05:07] Nilan Peiris

**English:**
And so the fun bit was the approach. So then him and a designer sat there and they sketched out an alternative email, and they went down to the coffee shop downstairs, and they showed it to people, and they said... Just asked them what they thought, and they kept iterating it until they got to a graph. And this graph is like this... When you go through a money transfer thing, it pops up in places, behind the compare button. And this graph shows with your bank, when you send, how much is in the rate hidden as... This is how much you're sending, this is how much they're taking in the rate in a fee, and this is how much you can see in the fee, because the fees are hidden in the rates with banks. And then this is with Wise.
(01:05:45):
And they iterate this graph to the point that people looked at like, "Oh my God, I'm never using my bank again. This number... This is crazy." And then they put this graph on the success page when you did a transfer. Saying, "You saved this." And put a share button in there, and invite your friends button, and that's what really drove it. And when you fast-forward to today, we've now got... So it's actually quite hard. So, we now have I think about 70 bank accounts around the world. So, I think the top three accounts, banks in the world, where we log onto every day, and then we log the price and the quote for a bunch of different routes into a file. You can imagine how hard is. I think I personally have about 17 of these still in my name, that I've opened up around the world to help the team get going. But that's kind of one of the biggest word of mouth growth, or referral insights. I've got to this comparison thing, made into our marketing, made into our homepage, just went everywhere up from that insight.

**中文翻译:**
有趣的是他们的方法。他和一名设计师坐下来画了一封替代邮件的草图，然后去楼下的咖啡馆展示给路人看，询问他们的想法。他们不断迭代，直到做出了一个图表。

这个图表展示了：如果你用银行汇款，有多少费用是隐藏在汇率里的，有多少是显性手续费；而用 Wise 是什么样的。他们不断优化这个图表，直到人们看了会惊呼：“天呐，我再也不用银行了，这太疯狂了。”然后他们把这个图表放在转账成功的页面上，写着“你省了这么多”，并放上分享和邀请按钮。这就是增长爆发的原因。

为了支撑这个图表，我们现在在全球拥有大约 70 个银行账户，每天登录各大银行记录不同路径的价格。你可以想象这有多难，我个人名下现在还有大约 17 个为了帮团队起步而在全球各地开的账户。这是我们最大的口碑增长洞察之一：这个对比工具后来进入了我们的营销、首页，无处不在。

---

### [01:06:46] Lenny

**English:**
And you said that that like 3x'd the sharing rate?

**中文翻译:**
你说这让分享率翻了三倍？

---

### [01:06:50] Nilan Peiris

**English:**
Yeah, that 3x'd the sharing rate. So we always had the share button after you completed a transfer. But putting that there with this graph, and that kind of got me to this, I'm curious on your take on this, on this definition of product marketing, where customers use the product, and they think they got this value, but when they actually know the value they get. So we got this on speed as well, where we're doing instant transfers, and customers wouldn't know it was instant.
(01:07:21):
So when you get an instant transfer, there's like this wizzy animation at the end, and you kind of know the money's in the other person's account, ready to spend. And again, you see this big jump in referral rate when that happens, but people need to know it's happened. And closing this delta between what you've done, and what's perceived to be done is what I call product marketing within the product. And that in its own right is a discipline, I've learned.

**中文翻译:**
是的，分享率翻了三倍。我们以前在转账后也有分享按钮，但加上这个图表后效果完全不同。这让我想到一个关于“产品营销”的定义：客户使用了产品并认为获得了价值，但他们是否真正意识到自己获得了多少价值？

我们在速度上也遇到了类似情况。我们实现了即时到账，但客户并不知道。所以我们加了一个酷炫的动画，明确告诉用户钱已经到了对方账上。每当这种“感知”被强化时，推荐率就会大幅跳升。缩小“你实际做的”与“用户感知到的”之间的差距，我称之为“产品内的产品营销”。我意识到这本身就是一门学科。

---

### [01:07:43] Lenny

**English:**
That's an awesome insight. It comes back to this framework we talked about of reality and perception, in a flip way, instead of getting people to adopt something, it's to appreciate the work you've done to make it remarkable, to make them understand how remarkable it really is.

**中文翻译:**
非常棒的洞察。这又回到了我们讨论的“现实与感知”框架，只不过是反向应用：不是为了让人们接受某样东西，而是为了让他们欣赏你为使其变得“非凡”所做的努力，让他们理解它到底有多非凡。

---

### [01:07:56] Nilan Peiris

**English:**
Yeah, that was it. And that's something I'm continuously learning about yeah, as we go, as well.

**中文翻译:**
没错，就是这样。这也是我在过程中不断学习的东西。

---

### [01:08:01] Lenny

**English:**
That is extremely interesting. Before we get to our very exciting lightning round, I know you also do a bunch of charity work, and I wanted to give you a chance to share what you're doing there.

**中文翻译:**
非常有意思。在进入激动人心的闪电轮问答之前，我知道你还做了一些慈善工作，我想给你个机会分享一下。

---

### [01:08:12] Nilan Peiris

**English:**
Thanks, Lenny. So, less charity, essentially came out of angel investing, is probably the way to say it. So I invest in startups, generally fintechs, mission led founders, word of mouth type stuff, all the stuff we've been talking about, that I'm passionate about. It is less investing, more helping, and yeah, just getting through the angel route. And then over time, I realized the thing I'm most passionate about is market failures. So generally I find that the invisible hand means most human needs get fulfilled by the market, but there are a few things that don't, and there's a couple of exciting startups out there who work really hard in this space. A couple are Beam in the UK, working on homelessness, Affinity and Neobank in Ghana. And so, this type of thing is stuff I'm most passionate about. So, if any of your listeners out there know anyone doing anything of that kind, trying to solve these kinds of hard problems, definitely reach out, always keen to talk.

**中文翻译:**
谢谢，Lenny。其实与其说是慈善，不如说是源于天使投资。我投资一些初创公司，主要是金融科技领域、使命驱动的创始人、关注口碑增长的公司，也就是我们今天聊的这些我热衷的话题。比起投资，我更多是在提供帮助。

随着时间的推移，我发现我最关注的是“市场失灵”（Market failures）。通常“看不见的手”能满足人类的大部分需求，但有些领域不行。有一些很棒的初创公司在这些领域努力，比如英国解决无家可归问题的 Beam，以及加纳的数字银行 Affinity。如果你或听众知道有人在解决这类难题，请务必联系我，我很乐意交流。

---

### [01:09:14] Lenny

**English:**
Awesome. And we'll link to those two you mentioned in the show notes just in case people want to check them out. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。我们会把这两个项目放在节目介绍里。现在进入闪电轮问答，准备好了吗？

---

### [01:09:22] Nilan Peiris

**English:**
Let's go for it.

**中文翻译:**
来吧。

---

### [01:09:23] Lenny

**English:**
Let's do it. What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:09:29] Nilan Peiris

**English:**
Two, one's at the other ends of the spectrum. So one is... This sounds terribly pretentious Crime and Punishment, and the other one is Midnight's Children by Salman Rushdie. I read a lot, I'm very passionate about reading, fiction, mainly. I don't read... Nonfiction is too much like work. And so, I generally need to read before I go to bed to decompress my brain. It's generally escapist type stuff. But I'm curious what you think of this, but for me authors are people that create people with words.
(01:10:03):
Like you say artist is a good artists if it's... Makes a good likeness to somebody, but imagine that you create somebody with words, and that person feels real, so they have some insight into the human condition. And what's amazing is if you learn something about what it means to be human from reading that. So at that end of the scale, Dostoevsky, Crime and Punishment, where this guy kills somebody, and it just eats him up. It's a pretty amazing book. It's not as heavy as it sounds, but books like that are pretty awesome. So, I recommend that a lot.
(01:10:37):
And the other end of the scale is sometimes you read a book and there's a single sentence where each word has been just stitched together, and it's like, again, a work of art, and there, Rushdie is probably the pinnacle for me, of Midnight's Children, which is about partition in India, which is pretty... Through a metaphor, it's pretty amazing.

**中文翻译:**
两本风格迥异的书。一本听起来可能有点装深沉，是《罪与罚》（Crime and Punishment）；另一本是萨尔曼·鲁西迪的《午夜之子》（Midnight's Children）。我读很多书，主要是小说。我不怎么读非虚构类，因为那太像工作了。我睡前需要读小说来减压。

对我来说，伟大的作家是用文字创造“人”的人。如果一个画家画得像某人，我们会说他是好画家；但想象一下用文字创造一个让你觉得真实存在的人，这需要对人性有极深的洞察。陀思妥耶夫斯基的《罪与罚》讲述了一个杀人者如何被内心吞噬，非常震撼。而鲁西迪的《午夜之子》关于印巴分治，文字优美得像艺术品，每一句话都像是精心缝合在一起的。

---

### [01:11:02] Lenny

**English:**
What is a favorite recent movie or TV show?

**中文翻译:**
最近喜欢的电影或电视剧？

---

### [01:11:02] Nilan Peiris

**English:**
Oh gosh, I am not... I don't love [inaudible 01:11:05] got TV, but we had rented Barbie for the kids. That one, probably the last movie.

**中文翻译:**
噢天呐，我不怎么看电视。不过我们为了孩子租了《芭比》（Barbie），那应该是最近看的一部。

---

### [01:11:12] Lenny

**English:**
I just watched that too. So good.

**中文翻译:**
我也刚看，非常棒。

---

### [01:11:13] Nilan Peiris

**English:**
Good.

**中文翻译:**
挺好的。

---

### [01:11:15] Lenny

**English:**
You can actually stream it now. I don't know when this comes out, but it just-

**中文翻译:**
现在可以流媒体观看了。

---

### [01:11:17] Nilan Peiris

**English:**
Oh wow.

**中文翻译:**
噢哇。

---

### [01:11:18] Lenny

**English:**
Yeah, you can watch it at home. But it's not cheap. I think it's like 20 bucks in the US.

**中文翻译:**
是的，在家就能看，不过不便宜，美国要 20 刀。

---

### [01:11:23] Nilan Peiris

**English:**
Oh geez.

**中文翻译:**
噢天。

---

### [01:11:24] Lenny

**English:**
What is a favorite interview question you like to ask candidates when you're interviewing them?

**中文翻译:**
面试候选人时你最喜欢问的问题？

---

### [01:11:28] Nilan Peiris

**English:**
Yeah, so I only ask two. I got down to asking just two questions over time. The first one's probably my favorite, which is, what is it that most frustrates you about... Instead of why you're leaving, what frustrates you the most about where you're working right now? And this is as people always tell you why they want to join Wise, or join whatever company you're coming to, and that's not that interesting. But what's interesting, trying to figure out, is what they're running away from. And usually there's something broken there, that's really wound them up. But what's more interesting is they've been unable to fix it. And so, in asking this question, and probing, you kind of get quite good at getting a sense of what is their limit, what's the thing they found, and what did they get stuck with? And you kind of think, "Okay, you're going to run into that here every day, every week? Or... You should be fine." And that's kind of why I ask that question.

**中文翻译:**
我只问两个问题。我最喜欢的一个是：“你现在的公司最让你感到挫败的是什么？”（而不是问你为什么要离开）。人们总是会说为什么想加入 Wise，那不怎么有趣。有趣的是弄清楚他们想逃离什么。通常是那里有些东西坏了，让他们很抓狂，更重要的是他们无法修复它。通过追问，你可以了解他们的极限在哪里，以及他们会被什么样的问题困住。然后你会想：“这种事在我们这儿天天发生，你受得了吗？”

---

### [01:12:24] Lenny

**English:**
I love that. What is a favorite product you've recently discovered that you really like?

**中文翻译:**
最近发现并非常喜欢的某个产品？

---

### [01:12:29] Nilan Peiris

**English:**
I recently switched to Arc Browser.

**中文翻译:**
我最近换成了 Arc 浏览器。

---

### [01:12:29] Lenny

**English:**
That's what I use.

**中文翻译:**
我也在用。

---

### [01:12:35] Nilan Peiris

**English:**
And yeah, the onboarding flow was mind-blowingly good.

**中文翻译:**
是的，它的新手引导流程（Onboarding）好得令人惊叹。

---

### [01:12:37] Lenny

**English:**
That's exactly how I felt. I had to tweet about it. It's like, [inaudible 01:12:41].

**中文翻译:**
我也有同感，我还专门发了推特。

---

### [01:12:40] Nilan Peiris

**English:**
Yeah, I sent it to my onboarding team, and everyone. And what I loved about it is, it's clearly like if you could try to use Arc with the same way you use Chrome, you just get really frustrated. But if you use it the way they want you to use, it'd be amazing. So, for figuring out how to get people to engage with, you need to use this fundamentally differently. They manage to almost get me to use it the right way. Still struggling a little bit with it, but that I thought was really clever.

**中文翻译:**
我也把它发给了我们的注册流程团队。我最喜欢的一点是：如果你用 Chrome 的方式用 Arc，你会很沮丧；但如果你按他们设计的方式用，它就很棒。他们成功地引导我以一种全新的方式使用浏览器，这非常聪明。

---

### [01:13:12] Lenny

**English:**
Awesome choice. We had Josh, the CEO of the Browser Company of New York, it's called, on the podcast. And if you're interested in learning about Arc's story, definitely check out that episode. All right, next question. What is a favorite life motto that you like to repeat most to yourself, that you like to share? Anything come to mind?

**中文翻译:**
很棒的选择。我们之前请过 Arc 背后公司的 CEO Josh 来过节目。下一个问题：你最常对自己说或分享的人生格言是什么？

---

### [01:13:30] Nilan Peiris

**English:**
The thing that defines success is the speed at which you pick yourself up.

**中文翻译:**
定义成功的标准，是你从挫折中重新站起来的速度。

---

### [01:13:37] Lenny

**English:**
I love that.

**中文翻译:**
太棒了。

---

### [01:13:37] Nilan Peiris

**English:**
And that's the thing that I hold onto most, because you get knocked a lot, high growth company, and it's obviously quite... Obviously knocks you, when someone says no to an offer, when somebody leaves the company, when a product doesn't work as you think it should, when you get pushback from a partner. But yeah, if you lose four hours spinning around it, or you trying and figure out, "Okay, this happened, how do I move forward?" And just learning how to shorten that time has probably been one of the most important journeys for me.

**中文翻译:**
这是我最坚守的信念。在高速增长的公司里，你会经常碰壁：候选人拒绝了 Offer、核心员工离职、产品效果不如预期、合作伙伴拒绝合作。如果你花四个小时在那儿纠结，那就输了。学会缩短从“出事了”到“如何前进”的时间，是我人生中最重要的修行之一。

---

### [01:14:11] Lenny

**English:**
That was an awesome answer. One final question, is there a fun cultural ritual at Wise that has stuck around for a while?

**中文翻译:**
非常棒的回答。最后一个问题：Wise 有什么坚持了很久的有趣文化仪式吗？

---

### [01:14:20] Nilan Peiris

**English:**
This one, my team would love to say. So, from the early days, we got everyone together from all around the world once a year. Oh, I actually did it twice a year. And the founders are from Estonia, and we have 5,000 people now, so we still have about 1,800 in Estonia. So it's cheaper to flavor on Estonia. So in the old days when it was winter, winter in Estonia is not fun, but summer in Estonia is amazing, and we still do this. And the funnest bit about this is, I have a side hustle, DJ, so I get to DJ there, and it's quite fun, and embarrassing for my kids because technically I've now DJ'd in other countries.

**中文翻译:**
我的团队肯定想让我说这个。从早期开始，我们每年（有时是两次）会把全球各地的员工聚在一起。创始人来自爱沙尼亚，我们现在有 5000 人，其中约 1800 人在爱沙尼亚。爱沙尼亚的夏天非常美，我们现在依然坚持这个聚会。最有趣的部分是，我的副业是 DJ，所以我会去现场打碟。这对我孩子来说挺尴尬的，因为从技术上讲，我现在已经是“国际 DJ”了。

---

### [01:15:03] Lenny

**English:**
International DJ.

**中文翻译:**
国际 DJ。

---

### [01:15:05] Nilan Peiris

**English:**
That's it. That's my side hustle.

**中文翻译:**
没错，那是我的副业。

---

### [01:15:07] Lenny

**English:**
Amazing.

**中文翻译:**
太酷了。

---

### [01:15:08] Nilan Peiris

**English:**
That's how I introduced myself to my 17-year old's friends. So, yeah.

**中文翻译:**
我就是这么向我 17 岁儿子的朋友们介绍我自己的。

---

### [01:15:12] Lenny

**English:**
Do you have a DJ name? Is there... Can we check you out on Spotify?

**中文翻译:**
你有 DJ 艺名吗？在 Spotify 上能搜到你吗？

---

### [01:15:15] Nilan Peiris

**English:**
No, no, you can't check me on Spotify or anything, but yeah, it's all private. [inaudible 01:15:19].

**中文翻译:**
不不，搜不到，那都是私人的。

---

### [01:15:19] Lenny

**English:**
All right. Maybe Burning Man, you could see your performance next year.

**中文翻译:**
好吧，也许明年能在火人节看到你的表演。

---

### [01:15:23] Nilan Peiris

**English:**
Maybe.

**中文翻译:**
也许吧。

---

### [01:15:24] Lenny

**English:**
Nilan, thank you so much for being here. We talked a lot about word of mouth. I feel like this episode is going to spread 100% through word of mouth. Can't wait for people to listen to it. Two final questions. Where can folks find you online if they want to reach out, and how can listeners be useful to you?

**中文翻译:**
Nilan，非常感谢你能来。我们聊了很多关于口碑的话题，我觉得这一集 100% 会通过口碑传播出去。最后两个问题：如果大家想联系你，在哪里可以找到你？以及听众可以为你做些什么？

---

### [01:15:37] Nilan Peiris

**English:**
You can find me online on Twitter, nilanp, and always love to hear product feedback by email, by tweet, by LinkedIn. Generally by tweet is best, easiest for me to pick up, and my team to reach into directly. So, hit me up that way. And most useful for me, yeah, product feedback, and as I said, other people working on hard problems that need help, do reach out.

**中文翻译:**
你可以在 Twitter 上找到我，账号是 nilanp。我非常欢迎通过邮件、推特或 LinkedIn 听取产品反馈。推特通常最方便。对我最有用的就是产品反馈，另外正如我提到的，如果你在解决那些需要帮助的难题，请联系我。

---

### [01:16:03] Nilan Peiris

**English:**
Amazing. Nilan, thank you so much for being here.

**中文翻译:**
太棒了。Nilan，非常感谢你能来。

---

### [01:16:06] Nilan Peiris

**English:**
Thank you for your time. Take care, Lenny.

**中文翻译:**
谢谢你的时间。保重，Lenny。

---

### [01:16:08] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating, or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes, or learn more about the show lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。也请考虑给我们评分或留下评论，这能帮助更多听众找到我们。你可以在 lennyspodcast.com 找到往期节目。下期见。