# Nir Eyal - 双语对照

This is a bilingual transcript of the conversation between Lenny Rachitsky and Nir Eyal on *Lenny's Podcast*, focusing on the psychology of distraction and the "Indistractable" framework.

---

### [00:00:00] Nir Eyal

**English:**
I went to Alibaba and I bought myself one of these flip phones from China like we used to have in the 1990s with no apps, no internet connection. And then I got myself a word processor off of eBay so that I could just sit down and write and do the important stuff. And even when I stopped using all the technology, even when I got rid of all the apps, I would sit down on my desk and I'd say, "Oh, you know what? There's that book that I've been meaning what to do some research in," or, "Let me just clean off my desk real quick," or, "You know what? I should take out the trash." And I kept getting distracted because the problem is not our technology. The problem is our inability to deal with discomfort. So, what I have adopted for myself and what I'd advise anyone who finds themselves in this situation is to always identify what is that internal trigger, what is that itch that you are looking to escape when you get distracted, because that is the source of 90% of our distractions. It's not the pings, dings, and rings. It's the feelings. But to me, that's incredibly empowering because once you realize, "Wait a minute, it's just a feeling." It's all it is, it's just an emotion. Then you can have tools ready to go. You can have arrows in your quiver ready to take out as soon as you feel that discomfort.

**中文翻译:**
我专门上阿里巴巴买了一个那种 90 年代风格的中国翻盖手机，没有 App，也没法上网。然后我又从 eBay 上淘了一个文字处理器，心想这样就能坐下来专心写作，处理正事了。可结果呢，即便我停用了所有科技产品，删掉了所有 App，当我坐在书桌前时，我还是会想：“哦，对了，那本书我一直想查点资料来着，”或者“我先把桌子收拾干净吧，”再或者“我该去倒个垃圾。”我依然在分心。因为问题根本不在于科技，而在于我们无法应对“不适感”。所以，我为自己总结了一套方法，也建议所有处于这种困境的人：永远去识别那个“内部触发因素（Internal Trigger）”，去识别当你分心时，你到底想逃避哪种“心痒”的感觉。因为那是 90% 分心行为的根源。分心不是因为那些手机推送音或铃声，而是因为情绪。但对我来说，意识到这一点反而让人充满力量，因为一旦你明白“等一下，这只是一种感觉”，它仅仅是一种情绪而已，你就可以准备好应对工具。就像箭筒里的箭一样，一旦感到不适，随时可以拔出来应对。

---

### [00:01:10] Lenny

**English:**
Today, my guest is Nir Eyal. Nir is the author of two bestselling books, *Hooked: How to Build Habit-Forming Products* and *Indistractable: How to Control Your Attention and Choose Your Life*. Nir spends his time teaching and consulting at the intersection of psychology, technology, and business. His books have sold over 1 million copies in over 30 languages. In our conversation, we get very tactical about how to become less distractable and how to get better at focusing on doing the work that you know need to do. Nir shares at least a dozen tools and tricks that you can put into place today to help you stay focused and avoid getting distracted. After this conversation, I've already implemented some of these tactics and they're actually working.

**中文翻译:**
今天的嘉宾是 Nir Eyal。Nir 是两本畅销书的作者，分别是《上瘾：如何打造习惯养成类产品》（Hooked）和《专注力：如何掌控注意力并选择你的人生》（Indistractable）。Nir 长期致力于心理学、科技与商业交叉领域的教学和咨询工作。他的著作已被翻译成 30 多种语言，销量突破 100 万册。在今天的对话中，我们将深入探讨如何减少分心，以及如何更好地专注于那些你明知该做的重要工作。Nir 分享了十几种今天就能上手的工具和技巧，帮你保持专注。在录完这期节目后，我已经尝试了一些策略，真的非常管用。

---

### [00:04:29] Lenny

**English:**
I feel like we have a chance to record the most valuable hour in podcast history because it could give people more time to do the things they want to do. And this is based on a book that you wrote. It's called *Indistractable*, which is all about helping people become less distracted, become better at focus, and it might be the most essential skill in the workplace today. And so, what I'm hoping to do today in our chat is just basically give people as many tactical skills and pieces of advice and tools to become less distractable and to get better at focus. How does that sound?

**中文翻译:**
我觉得我们有机会录制播客史上最有价值的一小时，因为它能让人们腾出更多时间去做自己想做的事。这都基于你写的那本书《专注力》（Indistractable），它旨在帮助人们减少分心，提升专注力。这可能是当今职场中最核心的技能。所以，我希望在今天的聊天中，尽可能多地为大家提供实操技巧、建议和工具。你觉得怎么样？

---

### [00:05:15] Nir Eyal

**English:**
I discovered that there were so many myths and tropes and just flat out harmful things that I was doing to hurt my own productivity. And when I really went down to first principles and looked at the research, I found that there were so many things that I was doing wrong. Today, with the internet, we all basically know what to do. And if you don't know what to do, Google it. But we all basically know common-sense stuff like if you want to get in shape, you have to exercise and eat right. We already know these things. What we don't know is how to get out of our own way, how to stop getting distracted.

**中文翻译:**
我发现以前有很多关于生产力的迷思和陈词滥调，甚至有些我一直在做的、损害自己效率的错误做法。当我回归“第一性原理（First Principles）”并查阅研究文献时，我发现自己错得离谱。在互联网时代，我们基本上都知道该做什么。如果你不知道，搜一下就行。我们都知道常识，比如想健身就得运动加合理饮食。这些道理大家都懂，我们不懂的是如何“不给自己使绊子”，如何停止分心。

---

### [00:08:06] Nir Eyal (Defining Traction and Distraction)

**English:**
The opposite of distraction is not focus. The opposite of distraction is traction. Both words come from the same Latin root, *trahare*, which means to pull, and they both end in the same six letters, A-C-T-I-O-N that spells action, reminding us that distraction is not something that happens to us. It is an action that we ourselves take. So, traction, by definition, is any action that pulls you towards what you say you were going to do. Now, the opposite of traction, distraction, is any action that pulls you away from what you plan to do. And what separates traction from distraction is one word, and that one word is intent.

**中文翻译:**
“分心（Distraction）”的对立面不是“专注”，而是“牵引（Traction）”。这两个词都源自同一个拉丁语词根 *trahare*，意思是“拉拽”，而且它们都以 A-C-T-I-O-N（行动）结尾。这提醒我们，分心并不是发生在我们身上的意外，而是我们自己采取的一种行动。根据定义，“牵引”是任何将你拉向预定目标的行动；而“分心”则是任何将你拉离计划、拉离目标的行动。区分“牵引”与“分心”的只有一个词，那就是“意图（Intent）”。

---

### [00:10:21] Nir Eyal (The Worst Kind of Distraction)

**English:**
I would sit down at my desk and I'd say, "Okay, I've got that big important project. I'm not going to get distracted... but first let me check some email." What I didn't realize is that distraction was tricking me into prioritizing the urgent and the easy stuff at the expense of the hard and important work I had to do. Just because it's a work-related task, doesn't mean it's not a distraction. In fact, that's the worst kind of distraction. If you're just checking work email, you feel productive even though that's a distraction because it's not what you said you want to do with your time and attention.

**中文翻译:**
我以前常坐在桌前说：“好，我要开始做那个大项目了，绝不分心……但先让我查个邮件吧。”我当时没意识到，分心正在诱骗我优先处理那些“紧急且简单”的事，代价则是牺牲了那些“艰难且重要”的工作。仅仅因为某件事与工作有关，并不代表它就不是分心。事实上，这是最糟糕的一种分心。如果你只是在查工作邮件，你会感觉自己很有产出，但其实你在分心，因为那并不是你计划中该投入时间和注意力的事。

---

### [00:11:08] Nir Eyal (The 4 Steps to Becoming Indistractable)

**English:**
Studies find that external triggers—the pings, dings, and rings—are only 10% of the reason we get distracted. What's the other 90%? It turns out 90% of the time that we get distracted, it's because of what's happening inside of us: boredom, loneliness, fatigue, uncertainty, anxiety.
Step number one: Master internal triggers.
Step number two: Make time for traction.
Step number three: Hack back the external triggers.
Step number four: Prevent distraction with pacts.

**中文翻译:**
研究发现，外部触发因素（那些提示音和铃声）只占分心原因的 10%。那剩下的 90% 是什么？事实证明，90% 的分心源于我们的内心：无聊、孤独、疲劳、不确定感、焦虑。
第一步：掌控内部触发因素。
第二步：为“牵引”留出时间（将价值观转化为时间）。
第三步：夺回外部触发因素的控制权。
第四步：用“契约（Pacts）”防止分心。

---

### [00:17:27] Nir Eyal (The 10-Minute Rule)

**English:**
Every time that I am tempted to go do something else, I will take out my phone and I'll say, "Set a timer for 10 minutes." My job is for those 10 minutes, whenever I'm ready, get back to the task at hand or do what's called "surf the urge." Surfing the urge acknowledges that these emotions are like waves. They crest and then they subside. A much healthier technique is not to tell yourself "no." It's to tell yourself "not yet." You can do just about anything for 10 minutes. What you'll find nine times out of 10 is that by the time those 10 minutes are up, you will have forgotten about that sensation.

**中文翻译:**
每当我忍不住想去做别的事时，我会拿出手机说：“设个 10 分钟的闹钟。”在这 10 分钟里，我的任务要么是回到手头的工作，要么是进行所谓的“冲动冲浪（Surf the urge）”。“冲动冲浪”是指承认情绪就像海浪，有波峰也有平息的时候。一种更健康的技巧不是对自己说“不行”，而是说“等一会儿”。任何事你都能坚持 10 分钟。你会发现，十有八九等到 10 分钟结束时，你已经忘了刚才那种想分心的冲动了。

---

### [00:20:34] Nir Eyal (The Mantra)

**English:**
What I do is I take a deep breath and I repeat a mantra that I made up for myself: "This is what it feels like to get better." Just saying that for as long as I need to until that emotion crests and subsides and then get back to work. The flip that we need to change in people's minds is this ridiculous belief that technology is hijacking our brains. It's not being stolen, we're giving it away.

**中文翻译:**
我会深呼吸，然后重复一句我为自己写的咒语：“这就是变得更强时的感觉。”一直重复到那种情绪平复，然后回到工作中。我们需要扭转人们脑中一个荒谬的念头，即“科技绑架了我们的大脑”。注意力不是被偷走的，是我们自己把它拱手相让的。