# Noah Weiss - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Noah Weiss (CPO at Slack).

---

### [00:00:00] Noah Weiss

**English:**
We have this mental metaphor that we talk a lot about, getting to the next hill. The actual wording is "Take bigger boulder bets." I think teams can often get lost crawling up that hill, not realizing that there's a huge, incredibly beautiful range behind it where we've over time freighted new teams from scratch that incubated in a new area before the areas mature.

**中文翻译:**
我们有一个经常谈论的心理隐喻，叫做“翻过下一座山丘”。确切的说法是“进行更大胆的‘巨石级’押注（Take bigger boulder bets）”。我认为团队往往会迷失在爬坡的过程中，而没有意识到后面有一片极其壮丽的山脉。随着时间的推移，我们从零开始组建了新团队，在这些领域成熟之前就进行孵化。

---

### [00:00:19] Noah Weiss

**English:**
We did that with a lot of these native audiovisual products like huddles and clips really in the pandemic because our customers were demanding it from us. I think in the AI space, we're trying to hear from customers, what do you wish Slack could do if it had these new superpowers? Let's incubate a couple teams or prototype, give them space to run and pilot and then get something to launch that's amazing. Blows people away. That's the formula that we've seen.

**中文翻译:**
在疫情期间，我们针对许多原生音视频产品（如 huddles 和 clips）就是这么做的，因为客户对我们有这些需求。在 AI 领域，我们也在倾听客户的声音：如果 Slack 拥有了这些新的“超能力”，你希望它能做什么？我们会孵化几个团队或原型，给他们空间去运行和试点，然后推出一些令人惊叹、让人眼前一亮的东西。这就是我们总结出的成功公式。

---

### [00:00:45] Lenny

**English:**
Welcome to Lenny's podcast where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Noah Weiss. Noah is chief product officer at Slack where he spent the last seven years. Prior to that he was head of product at Foursquare, which is near and dear to my heart as you'll hear at the top of this episode. Prior to that, he was a PM at Google and at Fog Creek Software.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Noah Weiss。Noah 是 Slack 的首席产品官（CPO），他在那里工作了七年。在此之前，他是 Foursquare 的产品负责人，正如你在本集开头听到的，那是我非常钟爱的公司。再之前，他曾在 Google 和 Fog Creek Software 担任产品经理（PM）。

---

### [00:01:10] Lenny

**English:**
In our conversation we cover the 10 traits of great product managers, how to work effectively with strongly opinionated and product-minded founders, what Noah has learned about working effectively with AI in your product over his last 15 years at Google and Foursquare and now Slack. We talk about a process called Complaint Storms that helps Slack build better product. Plus, what he is learned from Slack's self-service business plateauing back in 2019 and how they turned it around and what they took away from that experience.

**中文翻译:**
在我们的对话中，我们涵盖了优秀产品经理的 10 个特质、如何与极具主见且懂产品的创始人高效合作，以及 Noah 在过去 15 年里（先后在 Google、Foursquare 和现在的 Slack）关于如何在产品中有效应用 AI 的心得。我们还讨论了一个名为“抱怨风暴（Complaint Storms）”的流程，它帮助 Slack 构建更好的产品。此外，他还分享了 Slack 的自助服务业务在 2019 年陷入瓶颈时的教训，以及他们是如何扭转局面并从中获益的。

---

### [00:01:38] Lenny

**English:**
Also, how he thinks about competition with Microsoft Teams and with Discord. Also, a bunch of new data advice, which I found very helpful. This was such a great in-depth conversation about all things product and leadership, and I'm really excited for you to hear this episode. With that, I bring you Noah Weiss after a short word from our sponsors.

**中文翻译:**
此外，他还谈到了他如何看待与 Microsoft Teams 和 Discord 的竞争。他还提供了一系列关于数据的新建议，我觉得非常有用。这是一次关于产品和领导力的深度对话，我非常激动能让大家听到这一集。在听取赞助商的简短介绍后，让我们欢迎 Noah Weiss。

---

### [00:01:58] Lenny

**English:**
This episode is brought to you by Sidebar. Are you looking to land your next big career move or start your own thing? One of the most effective ways to create a big leap in your career and something that worked really well for me a few years ago is to create a personal board of directors, a trusted peer group where you can discuss challenges you're having, get career advice, and just gut check how you're thinking about your work, your career, and your life.

**中文翻译:**
本集由 Sidebar 赞助。你是否正在寻求职业生涯的下一次重大跨越，或者准备创业？实现职业飞跃最有效的方法之一（也是几年前对我非常有用的方法）就是建立一个“个人董事会”——一个值得信赖的同行群体，在这里你可以讨论面临的挑战，获取职业建议，并对你关于工作、事业和生活的想法进行直觉检查。

---

### [00:02:22] Lenny

**English:**
This has been a big trajectory changer for me, but it's hard to build this trusted group. With Sidebar, senior leaders are matched with highly vetted, private supportive peer groups to lean on for unbiased opinions, diverse perspectives and raw feedback. Everyone has their own zone of genius. Together, we're better prepared to navigate professional pitfalls leading to more responsibility, faster promotions, and bigger impact.

**中文翻译:**
这对我来说是一个重大的轨迹改变者，但建立这样一个值得信赖的群体很难。通过 Sidebar，资深领导者可以与经过严格筛选、私密且相互支持的同行群体匹配，从而获得不偏不倚的意见、多元的视角和原始的反馈。每个人都有自己的天才领域。聚在一起，我们能更好地应对职业陷阱，从而承担更多责任，获得更快的晋升和更大的影响力。

---

### [00:02:46] Lenny

**English:**
Guided by world-class programming and facilitation, Sidebar enables you to get focused tactical feedback at every step of your journey. If you're a listener of this podcast, you're likely already driven and committed to growth. A Sidebar personal board of directors is the missing piece to catalyze that journey. Why spend a decade finding your people when you can meet them at sidebar today? Jump the growing wait list of thousands of leaders from top tech companies by visiting sidebar.com/lenny to learn more. That's sidebar.com/lenny.

**中文翻译:**
在世界级项目和引导的指导下，Sidebar 让你在旅程的每一步都能获得专注的战术反馈。如果你是本播客的听众，你可能已经充满动力并致力于成长。Sidebar 的个人董事会是催化这一旅程的最后一块拼图。为什么要花十年时间去寻找志同道合的人，而今天就可以在 Sidebar 遇见他们呢？访问 sidebar.com/lenny 了解更多信息，跳过数千名来自顶尖科技公司领导者的候补名单。网址是 sidebar.com/lenny。

---

### [00:03:17] Lenny

**English:**
This episode is brought to you by Superhuman. How much time do you spend in email each day? How about your team? You may not realize this, but your email tools are wasting your time. Superhuman is blazingly fast email for high performing teams. Built to work with Gmail and Outlook, teams who use Superhuman spend half the time in their inboxes respond to twice the number of emails and save over four hours a week.

**中文翻译:**
本集由 Superhuman 赞助。你每天花多少时间处理邮件？你的团队呢？你可能没有意识到，你的邮件工具正在浪费你的时间。Superhuman 是为高效团队打造的极速邮件工具。它兼容 Gmail 和 Outlook，使用 Superhuman 的团队在收件箱上花费的时间减少了一半，处理的邮件数量翻了一倍，每周节省超过四个小时。

---

### [00:03:42] Lenny

**English:**
That's over a month of save time per year. With Superhuman, you can split your inbox into streams or VIPs, team members and emails from your favorite products to reduce context switching and make sure you never miss an important email. You can start reminders if you don't hear back so that you can follow up and never drop the ball on an email thread. You can also work faster than ever before with powerful AI features like writing, editing, summarizing and even translating.

**中文翻译:**
这相当于每年节省了一个多月的时间。使用 Superhuman，你可以将收件箱拆分为不同的流（streams），如 VIP、团队成员或来自你喜爱产品的邮件，以减少上下文切换，并确保你绝不会错过重要邮件。如果没收到回复，你可以设置提醒，以便及时跟进，绝不会在邮件往来中掉链子。你还可以利用强大的 AI 功能（如写作、编辑、总结甚至翻译）以前所未有的速度工作。

---

### [00:04:08] Lenny

**English:**
Join the ranks of the most productive teams and unleash the power of Superhuman. Try one month free at superhuman.com/lenny. That's superhuman.com/lenny. Noah, welcome to the podcast.

**中文翻译:**
加入最高效团队的行列，释放 Superhuman 的力量。在 superhuman.com/lenny 免费试用一个月。网址是 superhuman.com/lenny。Noah，欢迎来到播客。

---

### [00:04:25] Noah Weiss

**English:**
Thank you for having me. I'm excited to finally get to join and been a longtime listener.

**中文翻译:**
谢谢你的邀请。我很高兴终于能参加这个节目，我一直是你的忠实听众。

---

### [00:04:29] Lenny

**English:**
I feel the same way in reverse. I've been really excited that you're finally on the podcast. I don't know if you know this, but this is actually going to be the last podcast I'm recording before I go on pat leave. This is going to play while I'm on break. Coincidentally, you're actually just returning from pat leave is what I just learned.

**中文翻译:**
我也一样。我一直很期待你终于能上播客。不知道你知不知道，这实际上是我休陪产假（pat leave）前录制的最后一期播客。这期节目会在我休假期间播出。巧合的是，我刚刚得知你刚休完陪产假回来。

---

### [00:04:46] Noah Weiss

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:04:48] Lenny

**English:**
Let me ask you a question. What advice do you have for someone about to enter the beginning of baby life from someone that is exiting that and going back to work?

**中文翻译:**
让我问你一个问题。作为一个刚结束假期回公司上班的人，你对即将开始“带娃生活”的人有什么建议吗？

---

### [00:04:55] Noah Weiss

**English:**
First off, I mean obviously congratulations, you're about to go on. A rollercoaster of emotion, sleep and everything else. I literally went back to work two days ago. I think my, maybe, advice about being a new parent is better than my advice about being at PM right now. Here are the three ... My wife and I wind up coming up with three maxims that we want to be using throughout the first two months to keep ourselves grounded.

**中文翻译:**
首先，当然要恭喜你，你即将开启一段旅程。那将是情绪、睡眠和一切事物的过山车。我确实是两天前才回到工作岗位的。我觉得我现在关于当新手父母的建议可能比关于当产品经理的建议更好。这里有三条……我和妻子总结了三条准则，我们在前两个月一直用它们来保持心态平稳。

---

### [00:05:19] Noah Weiss

**English:**
First one, I would say a little bit better every day. No matter how many books you read and how much money ouster you consume, there's nothing like actually doing it. It's a physical thing being a new parent. Getting a little bit better every day, giving yourself permission to be like that didn't go great and that's okay. That's number one.

**中文翻译:**
第一条，我会说“每天进步一点点”。无论你读了多少书，听了多少建议，都比不上实际操作。当新手父母是一件体力活。每天进步一点点，允许自己表现得不够完美，没关系。这是第一点。

---

### [00:05:39] Noah Weiss

**English:**
Number two, don't over extrapolate from the early days. The fourth trimester is a real thing. These babies come out. They're not fully baked. They can't even support their own heads. If you try to extrapolate everything, the next 18 years are going to be the first 18 days, it's going to be sobering. Keep that perspective. They develop so much every week, part of the fun.

**中文翻译:**
第二条，不要根据最初的几天过度推断。所谓的“第四孕期（宝宝出生后的前三个月）”是真实存在的。宝宝刚出生时，他们还没完全“发育好”，甚至连头都支撑不住。如果你试图推断一切，觉得未来 18 年都会像前 18 天这样，那会让你感到绝望。保持这种视角：他们每周都在飞速成长，这也是乐趣所在。

---

### [00:06:03] Noah Weiss

**English:**
Then the third thing, which I got advice from this from a good friend is like you got to fully get into it as a parent. There's nothing that replaces. Actually, you got to change the diapers. You got to do the feeds. When they're up, even though they can't talk, you got to talk to them. You got to listen to what they're saying and just be fully present near the moment.

**中文翻译:**
第三件事，这是我从一个好朋友那里得到的建议，就是作为父母，你必须全身心投入。没有什么可以替代亲力亲为。实际上，你得换尿布，你得喂奶。当他们醒着的时候，即使他们不会说话，你也要和他们交流。你要倾听他们的声音，全身心地沉浸在那个时刻。

---

### [00:06:24] Noah Weiss

**English:**
I realized for myself, and then basically at full digital detox. You saw how long it took for me to reply to your emails. I was like, "Throw the devices away. Just fully with our daughter, [inaudible 00:06:34], and our family." I feel like it was so much more rewarding. I felt really connected with her now after these couple months. It's a crazy time. You're going to really love it. It's going to drive you mad at that times as well. That's all of it.

**中文翻译:**
我意识到对我自己来说，这基本上是一次彻底的“数字排毒”。你看到我回你邮件花了多长时间。我当时想，“把设备都扔掉。全身心地陪伴我们的女儿和家人。”我觉得这样做的回报要大得多。经过这两个月，我感到和她建立了真正的连接。这是一段疯狂的时光。你会非常爱它的，但有时它也会让你抓狂。这就是全部建议。

---

### [00:06:47] Lenny

**English:**
All right. We're going to be pivoting this podcast into a parenting podcast. This is awesome advice. I wrote everything you just said on this little post-it as you're talking. I'm going to put that up in our nursery and see how it all goes. One thing that's tough about my career path in this weird life is I don't get a nice pat leave, paid pat leave from a big company.

**中文翻译:**
好吧，我们要把这个播客转型成育儿播客了。这些建议太棒了。你说话的时候，我把你说的每一条都记在了这张便利贴上。我要把它贴在我们的育婴室里，看看效果如何。在我这种奇怪职业生涯中，困难的一点是我没有大公司提供的优厚带薪陪产假。

---

### [00:07:06] Lenny

**English:**
I've actually been working on stacking guest post and podcast ahead of my leave so that I can actually, as exactly as you said, just get fully into it.

**中文翻译:**
所以我一直在休假前拼命囤积嘉宾文章和播客录音，这样我就能像你说的，真正全身心地投入到家庭中。

---

### [00:07:14] Noah Weiss

**English:**
Smart.

**中文翻译:**
聪明。

---

### [00:07:16] Lenny

**English:**
On a totally different topic, you're ahead of product at Foursquare. I don't know if you know this. I actually built a startup on Foursquare's API. It's a company called Localmind. For folks that don't know about it, the way it worked is basically let you talk to someone, checked in on Foursquare anywhere in the world if you're thinking about going there.

**中文翻译:**
换个完全不同的话题，你曾是 Foursquare 的产品负责人。不知道你知不知道，我其实曾基于 Foursquare 的 API 创办了一家公司，叫 Localmind。对于不了解的人，它的运作方式基本上是：如果你想去世界上某个地方，它可以让你和那个正在 Foursquare 上签到的人交谈。

---

### [00:07:39] Lenny

**English:**
You could be like, "Hey, is this bar fun right now? What's happening there?" Before you actually show up. We ended up selling the company to Airbnb. Ended up not being a big problem for enough people and that's how I ended up at Airbnb. But it was quite magical and API was amazing. I guess I just want to say thank you for building an awesome product and awesome API.

**中文翻译:**
你可以在去之前问：“嘿，这家酒吧现在好玩吗？那里发生了什么？”我们最终把公司卖给了 Airbnb。结果证明，这并不是一个足够多的人面临的大问题，这就是我最终去 Airbnb 的原因。但那段经历很神奇，API 也非常棒。我想我只是想说声谢谢，感谢你们打造了如此出色的产品和 API。

---

### [00:07:58] Noah Weiss

**English:**
Thank you for being a developer on top of the ecosystem. I mean it's interesting with Foursquare. I will talk about this I'm sure later. I feel like I have more lessons learned and more scar tissue from the crazy up and down of ... I don't know what. It was 2010 to 2015 roughly. I think there's something actually where you learn more from the things that don't fully work out or don't quite achieve what you wanted to achieve.

**中文翻译:**
谢谢你成为我们生态系统中的开发者。Foursquare 的经历很有趣，我确信稍后会谈到。我觉得从 2010 年到 2015 年左右那段疯狂的起伏中，我学到了更多的教训，也留下了更多的“伤疤”。我认为，从那些没有完全成功或没有达到预期目标的事情中，你实际上能学到更多。

---

### [00:08:27] Noah Weiss

**English:**
You actually have a feedback loop where you get a lot of negative signal about like, "Okay. That didn't work. That didn't work. What can I actually learn, take away from that?" It's still great. I still love using Foursquare. I think we got caught in the death star of Instagram's ascent back in 2012, 2013. But I hope a product like that exists forever in the future and I'm glad you got to build the company, landed Airbnb through it. It's a great story.

**中文翻译:**
你实际上拥有一个反馈循环，你会收到很多负面信号，比如：“好吧，那个行不通。那个也没用。我能从中真正学到什么，带走什么？”这依然很棒。我仍然喜欢使用 Foursquare。我认为我们在 2012、2013 年左右被卷入了 Instagram 崛起的“死星”引力中。但我希望未来永远存在那样的产品，我很高兴你通过它创办了公司并最终进入了 Airbnb。这是一个很棒的故事。

---

### [00:08:52] Lenny

**English:**
Looking back at Foursquare, do you think there was a path to building a massive consumer app type business or is that just never going to work out? I know they went in direction of B2B data business. I guess was there a path or was it just like, "No. That was never going to work out?"

**中文翻译:**
回首 Foursquare，你认为当时有一条通往构建大规模消费级应用业务的路径吗？还是说那注定行不通？我知道他们后来转向了 B2B 数据业务。我想问，当时有路可走吗，还是说“不，那永远行不通”？

---

### [00:09:09] Noah Weiss

**English:**
It's tricky. I mean I'm not going to do 30-minute post, because I probably bore everyone. But it's not about this. We've all thought about this a lot on the early team there. I think the biggest probably lesson learned, frankly, is that we were really close with the Instagram folks early on. They were big developers on our platform. They used the Foursquare API before they were bought by Facebook.

**中文翻译:**
这很复杂。我不想做一个 30 分钟的复盘，因为那可能会让大家感到无聊。但早期团队确实对此思考了很多。坦率地说，最大的教训可能是：我们早期和 Instagram 的团队关系非常近。他们是我们平台上的大开发者，在被 Facebook 收购之前，他们一直在使用 Foursquare 的 API。

---

### [00:09:28] Noah Weiss

**English:**
I think in hindsight we were a little bit mistaken to believe that the idea that the atomic unit would be a person talking about a place that they're at and you have to have a physical place to tie it to versus a person sharing a moment or an experience that they're having in the world. Sometimes that might have a place connected to it.

**中文翻译:**
现在回想起来，我们当时可能犯了一个错误，认为“原子单位”应该是一个人谈论他们所在的某个地点，并且必须绑定一个物理地点；而实际上，它应该是人们分享他们在世界上经历的某个时刻或体验，虽然有时会关联一个地点。

---

### [00:09:47] Noah Weiss

**English:**
I think that one change in framer on what you would say a customer actually wanted to do, that probably was the thing that took this away on the social side. I think on the more local discovery side, it's actually what people wind up be using the product much more for over time getting personalized recommendations and getting tips when you go to a place and all the push notifications.

**中文翻译:**
我认为，对于“客户真正想做什么”的这种认知框架上的偏差，可能就是导致我们在社交方面失利的原因。而在本地探索（local discovery）方面，随着时间的推移，人们实际上更多地将其用于获取个性化推荐、到店提示和各种推送通知。

---

### [00:10:10] Noah Weiss

**English:**
Again, it was hard to stay ahead, I think specifically of Google, because they had billion plus Google Maps users distributed on Android and iOS. Even though they might only take a couple years, eventually they would wind up replicating a lot of the functionality and then I think it was hard to regain that momentum. Much of this stuff is luck and timing and just coincidences of history.

**中文翻译:**
此外，很难一直保持领先，特别是面对 Google，因为他们在 Android 和 iOS 上拥有超过 10 亿的 Google Maps 用户。即使他们可能需要几年时间，但最终他们会复制大部分功能，然后我认为就很难再重新获得势头了。很多事情取决于运气、时机和历史的巧合。

---

### [00:10:37] Noah Weiss

**English:**
I think there was a path. I think in the end we lost their social sales and then Google was able to catch up on the utility side. Now the company's built a really valuable B2B API company which offers a story. I mean Slack is in some ways a pivot, obviously, from a consumer company to a B2B company. But that that's my mini postmortem, what could have been with Foursquare.

**中文翻译:**
我认为曾经是有路径的。但最终我们在社交领域失去了机会，而 Google 在实用性方面赶了上来。现在公司已经成长为一家非常有价值的 B2B API 公司，这本身也是一个故事。我的意思是，Slack 在某种程度上也是从消费级公司向 B2B 公司的转型。这就是我对 Foursquare “如果当初……”的简短复盘。

---

### [00:11:00] Lenny

**English:**
It's interesting how many consumer companies pivot to B2B because it turns out that's where the money ends up being.

**中文翻译:**
很有趣，竟然有这么多消费级公司转向 B2B，因为事实证明，那才是赚钱的地方。

---

### [00:11:06] Noah Weiss

**English:**
Yeah. I think the feedback to you get from our people willing to pay for the product that you're building is so much faster than can I build a large-scale consumer business and when they hope to have enough reach to then slap ads onto it. That's a much more of a try to hit a home run and hope it works out. But you don't really know if you're doing it along the way. Yeah. I think B2B is a easier to have a more incremental, successfully business than pure consumer.

**中文翻译:**
是的。我认为，从“人们是否愿意为你构建的产品付费”中获得的反馈，要比“我能否建立一个大规模消费级业务，并希望达到足够的覆盖面后再投放广告”快得多。后者更像是尝试打出全垒打并寄希望于成功，但你在过程中并不真正确定自己是否走在正确的道路上。是的，我认为 B2B 比纯消费级业务更容易实现渐进式的成功。

---

### [00:11:34] Lenny

**English:**
Okay. Speaking of Foursquare, Dennis Crowley was the CEO and founder, a very strong product-minded founder. I know you've worked with a number of very strong product-minded founders including Stewart Butterfield, Dennis, obviously we just talked about, maybe others. I'm curious what you've learned as a product leader working with very opinionated founders.

**中文翻译:**
好。说到 Foursquare，Dennis Crowley 是首席执行官兼创始人，他是一位非常有产品头脑的创始人。我知道你曾与多位非常有产品头脑的创始人合作过，包括 Stewart Butterfield、Dennis（我们刚谈到的），可能还有其他人。我很想知道，作为一名产品领导者，在与非常有主见的创始人合作时，你学到了什么？

---

### [00:11:56] Lenny

**English:**
I think this is interesting not just as a product leader working with very product-minded CEOs, but also as a first PM at a startup you're often put in this tough spot of just the founders just telling you what to do and you have to go build it versus having a lot of say in agency. I'm curious what you've learned about working and being successful in that position, which is often really hard.

**中文翻译:**
我认为这不仅对于与懂产品的 CEO 合作的产品领导者很有趣，对于初创公司的第一位 PM 也是如此——你经常处于一种尴尬的境地：创始人只是告诉你该做什么，你就得去执行，而不是拥有很大的自主权。我很想知道，在那种通常非常艰难的职位上，你学到了哪些关于合作和成功的经验？

---

### [00:12:14] Noah Weiss

**English:**
I would say to folks in general, if you're joining company and the CEO does the role that is your functional area of expertise, it's probably the area where you'll learn the most because they're hopefully world class at it. But also, one will you'll be the most frustrated at times because you're going to feel like you have less agency. You should just know that going into it.

**中文翻译:**
我想对大家说，如果你加入一家公司，而 CEO 担任的角色恰好是你的专业领域，那么这可能是你学到东西最多的领域，因为他们通常在这个领域是世界级的。但同时，这也是你有时会感到最沮丧的领域，因为你会觉得自己缺乏自主权。你在加入之前就应该明白这一点。

---

### [00:12:33] Noah Weiss

**English:**
If you go to company to run by a former marketer and you're in marketing, they'll probably want to have a lot of say and influence over that. I think just going into knowing that is good. Looking back, I would say probably two main things stand out of what's really worked with both Dennis and Stewart, not just for me but I think for the teams that work with him as well.

**中文翻译:**
如果你去一家由前营销人员领导的公司做营销，他们可能会想对营销有很大的发言权和影响力。我觉得提前知道这一点是有好处的。回首往事，我认为在与 Dennis 和 Stewart 合作时，有两点非常关键，不仅对我，对与他们合作的团队也是如此。

---

### [00:12:52] Noah Weiss

**English:**
The first is, I think as much as possible, I think maybe we'll talk about this a little bit later as well, is getting to the point where you have alignment on the principles for what it means to build a great product of that company. Not just about if the intuition and tasting gut, but how do you distill that to principles that become the language of the company so that everybody else can start thinking through a similar frame or similar lens when you're designing a product.

**中文翻译:**
第一点是，尽可能在“什么才是这家公司的伟大产品”的原则上达成一致。这不仅仅关乎直觉和品味，而是如何将其提炼成原则，成为公司的通用语言，这样其他人在设计产品时就能通过类似的框架或视角来思考。

---

### [00:13:17] Noah Weiss

**English:**
Because otherwise it can feel a little bit Goldilocks every time a team builds something, they take it to the CEO. CEO is like, "No, not quite right. Again, no, not exactly that." Then you don't have the language to actually have a more constructive review. Then doing that at the little strategy as well. I think the product founder CEO is always going to be the holder of the vision for the company. I'm sure at Airbnb. I imagine Brian was very much like that as well.

**中文翻译:**
否则，每当团队做出一些东西拿给 CEO 看时，感觉就像在玩“金发姑娘”的游戏（译者注：指不断尝试直到刚好合适）。CEO 会说：“不，不太对。再来，不，不是那个意思。”这样你就缺乏进行建设性评审的共同语言。在战略层面也是如此。我认为懂产品的创始人 CEO 永远是公司愿景的持有者。我相信在 Airbnb，Brian 也是这样的。

---

### [00:13:40] Lenny

**English:**
Absolutely.

**中文翻译:**
绝对是。

---

### [00:13:41] Noah Weiss

**English:**
I think it's actually great to say, "Okay. The overall vision for the company, is it the responsibility of any one team to have everyone buy into that vision, but then to have space for teams to be able to actually do creative work, do explorations because you know that it's aligned with that high level vision."

**中文翻译:**
我认为这样说其实很好：“好的，公司的整体愿景是这样的，让每个人都认同这个愿景是某个团队的责任，但同时也要给团队留出进行创意工作和探索的空间，因为你知道这些工作是与高层愿景保持一致的。”

---

### [00:13:57] Noah Weiss

**English:**
If you can get that alignment and you can get those principles as the common language of what creative software looks like, I think you can have a really good working relationship. Then the other bit I would just say is I think when to involve the founder CEO in a project is really important. The short version I think that works the best is almost like a U-curve where the X-axis is time and the Y-axis is level of involvement.

**中文翻译:**
如果你能达成这种一致，并将这些原则作为“创意软件应该是什么样”的共同语言，我认为你们就能建立非常好的工作关系。另一部分我想说的是，在项目的什么时候让创始人 CEO 介入非常重要。我认为最有效的模式就像一条“U型曲线”，横轴是时间，纵轴是参与程度。

---

### [00:14:22] Noah Weiss

**English:**
I think you want to get the founder CEO really involved early on, especially if it's a big new project, to make sure that there's strategic buy-in that you agree on the principle strategy and approaching you agree on the goals and the anti-goals, getting that to then the team can run and explore. Then I think at the very end you want them to really be bought in that did you build something that's up to the quality ... the company?

**中文翻译:**
我认为你应该在早期让创始人 CEO 深度参与，特别是如果是重大的新项目，以确保达成战略共识，即你们在原则、策略、方法、目标和非目标（anti-goals）上达成一致，然后团队就可以去执行和探索。然后，在最后阶段，你需要他们真正认可：你构建的东西是否达到了公司的质量标准？

---

### [00:14:43] Noah Weiss

**English:**
Is this something that's going to customers, literally taste the soup. What's missing in it? I think at most companies that have a maniacally customer-focused founder, if you don't do that last step, it's going to be much more painful after you launch because they weren't part of that co-creation of the team. I think that formula winds up working pretty well if you throw in that alignment on principles and envision.

**中文翻译:**
这是要交给客户的东西，就像是“亲自尝尝这口汤”。里面缺了什么？我认为在大多数拥有极度关注客户的创始人的公司里，如果你不做最后这一步，发布后会痛苦得多，因为他们没有参与团队的共同创作。如果你能加上原则和愿景的一致性，这个公式通常会运作得很好。

---

### [00:15:08] Lenny

**English:**
That usually sounds nice in theory, but I often imagine you get to that final step and the founder is like, "What the hell is this? This is not at all what I was hoping it be." Is there an example of that, that comes to mind where you maybe went through that and then it's just like, "No. That did not work out the way we expected" and if not, no problem.

**中文翻译:**
这在理论上听起来很不错，但我经常想象，当你走到最后一步时，创始人可能会说：“这到底是什么鬼？这根本不是我想要的。”你脑海中有什么例子吗？比如你经历过这种情况，结果发现“不，这完全没按我们预期的那样发展”？如果没有也没关系。

---

### [00:15:26] Noah Weiss

**English:**
Yeah. I mean I think that does happen. The ship is maybe ... the end of the year is the level of engagement and often that last level of engagement, that's where there's actually the most rapid refinement that you're doing. I think what's important there is that hopefully you're refining in code and you're not still at static design mocks because using the software is so different than looking at what the software will visually appear.

**中文翻译:**
是的，我认为确实会发生这种情况。在项目末尾的参与度通常是最高的，而那也是进行最快速打磨的时候。我认为关键在于，希望你是在代码中进行打磨，而不是还在看静态的设计稿，因为实际使用软件与仅仅看软件的视觉外观是完全不同的。

---

### [00:15:51] Noah Weiss

**English:**
I think what we would wind up doing with Stewart at Slack, for example, is we would get the entire development team, engineers design product, user research and Stewart together in a room and we almost do a bug bash together. The idea was like, "We're doing it all together. We're trying to make the best product possible, making great softwares really messy and we're all trying to clean up the mess together."

**中文翻译:**
例如，在 Slack，我们会和 Stewart 一起，把整个开发团队（工程师、设计、产品、用户研究）和 Stewart 聚在一个房间里，几乎是大家一起进行“Bug 大扫除（bug bash）”。核心理念是：“我们在一起努力。我们试图做出最好的产品，开发伟大的软件过程是非常混乱的，我们都在努力一起清理这些混乱。”

---

### [00:16:15] Noah Weiss

**English:**
Sometimes you might find things like, "Okay. This entry point really isn't working, maybe we have to move this entry point. That's maybe a bigger change." But I think often what you'd find is just all those bits of polish and refinement and doing the little delightful things that might otherwise be missing to raise that craft bar and doing a real collective way so it doesn't just feel like the team says. "We want to ship." The founder says, "No, it's not ready."

**中文翻译:**
有时你可能会发现：“好吧，这个入口真的不行，也许我们得移动这个入口。这可能是一个较大的改动。”但通常你会发现，正是这些细微的润色、打磨和那些令人愉悦的小细节，提升了产品的工艺水平。通过这种集体协作的方式，就不会感觉像是团队在说“我们要发布”，而创始人在说“不，还没准备好”。

---

### [00:16:38] Noah Weiss

**English:**
Ideally as a group you're saying, We want to get it to a bar that's going to delight our users and here's the gap from where we are today to what we want to shift." I think that mentality winds up being a lot more constructive, but that's not always easy to do.

**中文翻译:**
理想情况下，作为一个整体，你们在说：“我们希望达到一个能让用户感到愉悦的标准，而这就是我们现状与目标之间的差距。”我认为这种心态会更有建设性，但做到这一点并不总是那么容易。

---

### [00:16:54] Lenny

**English:**
You talked about creating these principles, which is an awesome approach of just creating guardrails for the team so they think the way the founder and the head of product think. What are some examples of principles you have and had early on maybe at Foursquare or Slack?

**中文翻译:**
你谈到了制定这些原则，这是一个非常棒的方法，可以为团队建立护栏，让他们像创始人或产品负责人那样思考。你能举一些你早期在 Foursquare 或 Slack 制定过的原则例子吗？

---

### [00:17:07] Noah Weiss

**English:**
I mean Slack I think is where we enshrined them much more because we scaled the org so much, more that we needed principles. I think for us, they were really about unpacking just the mission, which for Slack is making people's working lives simpler, more pleasant, more productive. That's the mission of the company. The question is how does software help do that? That's what the principles or their answer.

**中文翻译:**
在 Slack，我们更正式地确立了这些原则，因为组织规模扩大了很多，我们非常需要原则。对我们来说，原则实际上是为了拆解公司的使命。Slack 的使命是让人们的工作生活更简单、更愉快、更高效。问题是，软件如何帮助实现这一点？原则就是答案。

---

### [00:17:31] Noah Weiss

**English:**
For us, we've got five, four principles. They've largely stayed the same. Some of the language has changed over the last couple of years. But at least for the last four or five years we've had these. The first is be a great host, which is all about that level of craft, the relentlessly saving people's steps. If you're, let's say, a host at Airbnb, it's like putting clean towels on the bed. No one has to wonder "Are these for me?" That type of foresight.

**中文翻译:**
我们有四五个原则，多年来基本保持不变，只是过去几年在措辞上有些调整。至少在过去的四五年里，我们一直遵循这些原则。第一个是“做一个伟大的主人（Be a great host）”，这关乎工艺水平，以及不遗余力地为用户节省步骤。如果你是 Airbnb 的房东，这就像是在床上放好干净的毛巾，没人需要怀疑“这些是给我的吗？”这就是那种预见性。

---

### [00:17:57] Lenny

**English:**
That's actually a value at Airbnb. Exactly.

**中文翻译:**
这实际上也是 Airbnb 的价值观。没错。

---

### [00:17:59] Noah Weiss

**English:**
Oh, really?

**中文翻译:**
哦，真的吗？

---

### [00:18:00] Lenny

**English:**
It's actually be a host at Airbnb is one of the four core values.

**中文翻译:**
“在 Airbnb 做一个主人”确实是四大核心价值观之一。

---

### [00:18:03] Noah Weiss

**English:**
Right. Maybe we borrowed that or someone was inspired by it. But be a great host. It sounded aspirational. I love that.

**中文翻译:**
对，也许我们借鉴了它，或者有人受到了启发。但“做一个伟大的主人”听起来很有感召力。我喜欢这个。

---

### [00:18:09] Lenny

**English:**
Yeah. Yeah. It's a little bigger.

**中文翻译:**
是的，它的内涵更广一些。

---

### [00:18:11] Noah Weiss

**English:**
There's a famous user design book called Don't Make Me Think, which we sold the title of for our next principle. That's really just about as people building the software, you know how it works so well. You care about all the nuances and intricacies and you really want your users to love it as much as you do. But often actually, that owner's delusion that someone else will care as much about the software that you built as you do, prevents you from actually making something that's simple, comprehensible, understandable.

**中文翻译:**
有一本著名的用户设计书叫《不要让我思考（Don't Make Me Think）》，我们借用了它的书名作为下一个原则。这主要是指，作为软件的构建者，你非常了解它的运作方式。你关注所有的细微差别和复杂之处，你真心希望用户能像你一样热爱它。但实际上，那种“所有者的错觉”——即认为别人会像你一样关心你构建的软件——往往会阻碍你做出简单、易懂、好用的东西。

---

### [00:19:03] Noah Weiss

**English:**
One of the core tenets of Slack is pretty complex under the surface, is how do we actually make people not have to think, how do we not reinvent the wheel if there's existing design patterns to use, how do we actually wind up designing for people who come from many different backgrounds and we cater to their needs in ways that don't make them have to customize it too much?

**中文翻译:**
Slack 的核心宗旨之一是，尽管底层非常复杂，但我们如何让人们不需要思考？如果有现成的设计模式，我们如何不重新发明轮子？我们如何为来自许多不同背景的人进行设计，并以一种不需要他们进行过多自定义的方式来满足他们的需求？

---

### [00:19:32] Noah Weiss

**English:**
There's a saying we also have, which is more clicks can often be okay. You'll often have in optimization experimentation circles like, "Oh, every click, remove it." But I actually think in a lot of software when it's not transactional, helping people understand what they're doing, giving them confidence, helping them have trust in the steps, we've seen that that can actually be a better experience. That's another example of don't make it stressful, help people chill out when they're using this offer. That's the idea beyond that one.

**中文翻译:**
我们还有一句话，叫做“多点几次通常也没关系”。在优化实验圈子里，你经常会听到：“哦，每一个点击都要去掉。”但我实际上认为，在许多非交易性的软件中，帮助人们理解他们在做什么，给他们信心，帮助他们对步骤建立信任，这实际上可以带来更好的体验。这是另一个例子：不要让使用过程充满压力，要帮助人们在用这款软件时感到放松。这就是那个原则背后的想法。

---

### [00:19:55] Lenny

**English:**
Shifting a little bit. I know you guys have been working on a bunch of AI stuff at Slack. I believe you've been working on AI related stuff for many years. I think at Google you worked on a lot of AI related products. I feel like a lot of people are just getting into this and trying to figure out, "How do we integrate AI and ML and LLMs into our product and how do we not just waste our time chasing things?"

**中文翻译:**
稍微换个话题。我知道你们在 Slack 一直在做很多 AI 相关的工作。我相信你多年来一直从事 AI 相关的工作。我想你在 Google 时也参与过很多 AI 产品。我觉得现在很多人才刚刚开始接触这个领域，试图弄清楚：“我们如何将 AI、机器学习（ML）和大语言模型（LLM）整合到我们的产品中，同时又不浪费时间去盲目追逐热点？”

---

### [00:20:11] Lenny

**English:**
I want to ask you just in your time working with AI over the many years you've been doing it and share a little bit about what you've been doing there. What are some things you've learned about how to be actually effective and build valuable products and not just fall for the shiny object issue and trap?

**中文翻译:**
我想请教你，在你多年从事 AI 工作的过程中，你学到了什么？能否分享一下你在这方面的心得？关于如何真正有效地构建有价值的产品，而不是仅仅陷入“追逐新鲜事物”的陷阱，你有哪些经验？

---

### [00:20:33] Noah Weiss

**English:**
I mean, it's almost 15 years ago now that I was working at Google in search on what later became called the knowledge graph. This idea of building a canonical repository of information of people, places, things in the world and relationships between them. Back then, it was a lot of the same ideas, but obviously the techniques. I have got a lot more mature.

**中文翻译:**
我是说，大约 15 年前，我在 Google 搜索部门工作，参与了后来被称为“知识图谱（Knowledge Graph）”的项目。其核心理念是构建一个关于世界上的人物、地点、事物及其相互关系的权威信息库。那时，很多想法和现在是一样的，但显然现在的技术已经成熟得多了。

---

### [00:20:53] Noah Weiss

**English:**
We used natural language processing to extract all this information from the web and try to build this database of facts. An idea then was could you take queries, people have like, "What are the tallest fountains in Europe or what of the most popular beaches in Southern California?" Be able to actually give answers not just 10 blue links.

**中文翻译:**
我们使用自然语言处理（NLP）从网络上提取所有这些信息，并尝试建立这个事实数据库。当时的一个想法是，你能否处理人们的查询，比如“欧洲最高的喷泉是什么？”或“南加州最受欢迎的海滩有哪些？”，并能够直接给出答案，而不仅仅是 10 个蓝色链接。

---

### [00:21:19] Noah Weiss

**English:**
I think the thing that's really changed, it's super exciting in the last 6, 12 months with LMs and chat GPT and everything else is the idea that now you can take not just knowledge about the world but actually have natural language generation where suddenly the computer can talk back to you in a way that feels extremely human. Then the creative applications of that are pretty massive and exciting.

**中文翻译:**
我认为在过去的 6 到 12 个月里，随着 LLM、ChatGPT 等技术的出现，真正发生改变且令人兴奋的是：现在你不仅可以获取关于世界的知识，还可以实现自然语言生成（NLG），计算机突然能以一种极具人性化的方式与你对话。随之而来的创意应用是非常巨大且令人兴奋的。

---

### [00:21:53] Noah Weiss

**English:**
That's, I guess, the lineage there. I think from over the years back at Google at Foursquare, we did a lot of personalization and recommendations at Slack we have search and ML that's coming infused throughout the product. I think a couple things come out as ... I guess the principles that we've used over the years, back then at Google, one of the big ones, was that the promise of the UI has to match the quality of the underlying data, which is to say ... I think this is actually one of the failings of the various LMs right now is they all appear supremely confident even when they're completely hallucinating.

**中文翻译:**
我想这就是其中的渊源。多年来，从 Google 到 Foursquare，我们做了很多个性化和推荐工作；在 Slack，我们的搜索和机器学习正贯穿于整个产品中。我认为有几点……我想我们在这些年里使用的一些原则，比如当年在 Google，其中一个核心原则是：UI 承诺的效果必须与底层数据的质量相匹配。也就是说……我认为这实际上是目前各种 LLM 的缺陷之一：即使它们完全在“一本正经地胡说八道（幻觉）”，它们看起来也极其自信。

---

### [00:22:11] Noah Weiss

**English:**
I think that's going to be something that people are going to have to work on a lot, which is to figure out how to be not so faultless, to acknowledge when you're not sure, because otherwise, it undermines the trust people have in the system. Using a lot of transparency about where the data comes from so people can actually build credibility and the tools is really important.

**中文翻译:**
我认为这是人们需要努力解决的问题，即如何做到不那么“完美无缺”，在不确定时承认不确定，否则会破坏人们对系统的信任。提供关于数据来源的高度透明度，让人们能够真正建立对工具的信任，这一点非常重要。

---

### [00:22:29] Noah Weiss

**English:**
Then I think making sure that as you're designing the products that you have virtuous cycles that are naturally part of the product experience where you can get training data as a byproduct of people naturally using the software and then can make the model that you're building behind the scenes smarter, more accurate, more predictive.

**中文翻译:**
此外，我认为在设计产品时，要确保拥有良性循环，使其成为产品体验的自然组成部分。这样，你可以通过人们自然使用软件的副产品来获取训练数据，进而使你在后台构建的模型变得更聪明、更准确、更具预测性。

---

### [00:22:42] Noah Weiss

**English:**
A classic example of that would be Netflix back in the day, their rating system, they actually have a feedback loop from their customers then make the system better at predicting. I think people you are still trying to figure out what does that look like in this world in LLMs?

**中文翻译:**
一个经典的例子是早期的 Netflix，他们的评分系统实际上拥有来自客户的反馈循环，从而使系统更擅长预测。我认为大家现在仍在探索，在 LLM 的世界里，这种反馈循环应该是什么样子的？

---

### [00:22:51] Lenny

**English:**
Something I hope that you're all building at Slack is a way to ask a bot questions based on all the conversations in the Slack. I've been looking for that product for a while now.

**中文翻译:**
我希望你们在 Slack 正在开发的功能是：可以根据 Slack 中的所有对话向机器人提问。我寻找这样的产品已经有一段时间了。

---

### [00:23:13] Noah Weiss

**English:**
I can safely say we have a lot of prototypes internally where we are playing with this. I think it is actually funny as a aside in one of the original Slack, I don't know, product vision decks back in 2014. There was our whole strategy, there's four parts. Then part number four, which was a joke at the time, was then do magic AI stuff on top.

**中文翻译:**
我可以负责任地说，我们内部有很多原型正在尝试这个功能。顺便提一下，这其实挺有趣的，在 2014 年 Slack 最初的一份产品愿景 PPT 中，我们的整个战略分为四个部分。第四部分在当时是个笑话，写的是“然后在上面做一些神奇的 AI 玩意儿”。

---

### [00:23:33] Noah Weiss

**English:**
We didn't even know what the state of AI would be. By the time hopefully companies have their collective knowledge in Slack and now we're finally at the period where the magic AI stuff seems finally pretty amazing, pretty magical. Yeah. We're doing a lot of prototyping internally and also trying to work with the ecosystem around as well, because there's so many companies doing amazing work in this space.

**中文翻译:**
当时我们甚至不知道 AI 会发展到什么程度。现在，很多公司都把集体知识存在了 Slack 中，而我们也终于进入了“神奇 AI 玩意儿”看起来真的非常惊艳、非常神奇的时期。是的，我们内部正在进行大量原型设计，同时也尝试与周边的生态系统合作，因为在这个领域有很多公司在做着了不起的工作。

---

### [00:23:50] Noah Weiss

**English:**
That if you work at a company where you have so much knowledge in your Slack channel repository that you can suddenly get amazing leaps in productivity to help you better do your job because that knowledge is in Slack, but it's sometimes hard to reach and I think these technologies can make that possible.

**中文翻译:**
如果你在一家公司工作，你的 Slack 频道库中存储了海量知识，如果你能突然获得生产力的巨大飞跃来帮助你更好地完成工作，那将非常棒。因为这些知识就在 Slack 里，只是有时难以获取，而我认为这些技术可以让获取变得可能。

---

### [00:24:27] Lenny

**English:**
This reminds me of something Gustav, the CPO and CTO and co-president of Spotify share that they always have a deck and a vision of just a play button within Spotify, you just play and all magic happens and it's the best music and thing exactly what you want to hear and just how that isn't actually possible and it's still not possible. Exactly to your point, you have to really think about how does it act? How close is it to the reality? If it's not actually there, he was saying how like, "We'll pick two songs that are correct at a 10 just because we don't really know exactly what you want to hear right now."

**中文翻译:**
这让我想起了 Spotify 的 CPO、CTO 兼联席总裁 Gustav 分享过的一件事：他们总有一份 PPT 和一个愿景，就是 Spotify 里只有一个“播放”按钮，你只要点一下，奇迹就会发生，播放出最棒的、正是你想听的音乐。但他也说这实际上是不可能的，现在也做不到。正如你所说，你必须认真思考它的表现如何？它离现实有多近？如果技术还没达到那一步，就像他说的：“我们会在 10 首歌里选出 2 首正确的，因为我们并不真正确切知道你现在想听什么。”

---

### [00:24:52] Noah Weiss

**English:**
Right. Yeah. I love that. Our version of that has always been that you open up Slack and suddenly instead of having to read through dozens of channels or find these mentions that magically Slack could just tell you in order that you would care about a summary of all the interesting things that have happened and then let you dig in if you want to your very own personal chief of staff who knew everything that you cared about and read everything that you could read.

**中文翻译:**
没错，我喜欢这个比喻。我们的版本一直是：你打开 Slack，突然之间，你不需要翻阅几十个频道或查找提及你的信息，Slack 就能神奇地按你关心的顺序告诉你所有发生的趣事的摘要，如果你愿意，还可以深入了解。它就像你个人的幕僚长，了解你关心的一切，并阅读了所有你能读到的信息。

---

### [00:25:02] Noah Weiss

**English:**
I don't think that's going to quite be possible anytime soon. But I think Spotify heading towards that north star you wind up developing. I hope a lot of really compelling projects experiences along the way.

**中文翻译:**
我不认为这在短期内能完全实现。但就像 Spotify 朝着那个“北极星”目标前进一样，你最终会开发出很多东西。我希望在这个过程中能产生很多真正引人入胜的项目体验。

---

### [00:25:12] Lenny

**English:**
Yeah, man. The more I think about it, the more amazing opportunities exist in Slack. It's all text. It's amazing. Okay. There's a lot of cool stuff coming I imagine.

**中文翻译:**
是啊，伙计。我越想越觉得 Slack 中存在着惊人的机会。那里全是文本，太棒了。好的，我能想象会有很多酷炫的东西问世。

---

### [00:25:29] Lenny

**English:**
On that topic, how do you think about creating teams within Slack and AI specifically? Are you recommending each team think about how AI can make their stuff better or are you dedicating, "Here's the AI team and they're going to work on stuff" and you guys just keep ship what you're shipping and keep moving your metrics?

**中文翻译:**
关于这个话题，你如何看待在 Slack 内部组建团队，特别是 AI 团队？你是建议每个团队都思考 AI 如何让他们的工作变得更好，还是专门设立一个“AI 团队”让他们去钻研，而其他团队则继续发布原有的功能并推进各自的指标？

---

### [00:25:52] Noah Weiss

**English:**
I mean the unfair answer is a hybrid of the two, which is to say we have a central machine learning and search team. But a lot of people have expertise in this field to build infrastructure that everybody can use. What we've done is because the space is evolving so quickly, literally every month, the capabilities are evolving, the risks and tradeoffs are evolving a ton.

**中文翻译:**
我想，最真实的答案是两者的结合。也就是说，我们有一个核心的机器学习和搜索团队，其中很多人拥有该领域的专业知识，负责构建每个人都能使用的基础设施。我们之所以这样做，是因为这个领域发展得太快了，字面意义上的每个月，能力都在进化，风险和权衡也在发生巨大变化。

---

### [00:26:17] Noah Weiss

**English:**
What we want to do is actually spin up a couple different teams that are focused on prototyping, using that common infrastructure but in specific directions that are all a little bit different. We've got a common ML, let's say in search team and now we have a bunch of teams that are working in parallel and different customer problems that we're trying to solve using that shared infrastructure.

**中文翻译:**
我们想做的是，实际上启动几个不同的团队，专注于原型设计，利用通用的基础设施，但在各个略有不同的特定方向上发力。我们有一个通用的机器学习（比如搜索团队），现在我们有一群团队在并行工作，利用共享的基础设施解决不同的客户问题。

---

### [00:26:37] Noah Weiss

**English:**
I think this isn't the steady state. I think over time, what it'll probably look like is that all the existing product areas, as soon as we know more of the shape of what the technology is capable of will just have AI capabilities as part of their roadmaps. Just like every product team is responsible for their own mobile roadmap. They don't outsource it to someone else.

**中文翻译:**
我认为这还不是最终的稳定状态。我想随着时间的推移，情况可能会变成：一旦我们更清楚这项技术的能力边界，所有现有的产品领域都会将 AI 能力纳入其路线图。就像每个产品团队都负责自己的移动端路线图一样，他们不会将其外包给别人。

---

### [00:26:49] Noah Weiss

**English:**
But I think today when things are moving so quickly, you actually want a little bit of a more ad hoc, flexible approach to move quickly and that's what we're doing.

**中文翻译:**
但在今天，当事情变化如此之快时，你实际上需要一种更灵活、更即时的方法来快速行动，这就是我们正在做的。

---

### [00:27:00] Lenny

**English:**
I heard that you have a process internally called Complaint-Storms. I'd love to understand what that is.

**中文翻译:**
我听说你们内部有一个叫“抱怨风暴（Complaint-Storms）”的流程。我很想了解那是什么。

---

### [00:27:05] Noah Weiss

**English:**
It something that started. I want to say back in end of 2019, maybe early 2020. The idea a little bit was how do we help as a team look at the software that we build with fresh eyes, because we've been set at Slack for a long time. Slack maybe more than almost any other company maybe like Figma is probably similar. I was listening to the podcast just earlier today where if you work on Figma, you work on Slack.

**中文翻译:**
这个流程大约始于 2019 年底或 2020 年初。初衷是：作为一个团队，我们如何用全新的眼光来看待我们构建的软件？因为我们在 Slack 待得太久了。Slack 可能比几乎任何其他公司都更特殊，也许 Figma 也是类似的。我今天早些时候还在听播客，如果你在 Figma 工作，你就在用 Slack 工作。

---

### [00:27:30] Noah Weiss

**English:**
You also live in Slack and you live in Figma all day so you can become more of a power user than anyone else on earth. What we were realizing, especially for people trying to build Slack for the next million customers, the people who have never used Slack before, it was becoming increasingly hard to have empathy for what their usage of Slack would look like. How would they look at it in a more critical way? How would they care less than we cared?

**中文翻译:**
你整天都生活在 Slack 和 Figma 中，所以你会比地球上任何人都更像是一个“超级用户”。我们意识到，特别是对于那些试图为下个一百万客户（那些从未用过 Slack 的人）构建 Slack 的人来说，越来越难对他们的使用场景产生共情。他们会如何以更挑剔的眼光看待它？他们如何能像我们一样不在意那些我们在意的小细节？

---

### [00:27:56] Noah Weiss

**English:**
What we started doing with these complaints storms and idea was really simple, which is we'd get a team together often Stewart myself would also join and we'd actually start off with other products first in adjacent spaces and we'd say, "Okay. As a group we're going to go through the customer journey from the moment you land on the website through, let's say it's a workplace product, getting your first account going, getting the first couple of users on board, getting to the point of value.

**中文翻译:**
我们开始做“抱怨风暴”，想法非常简单：我们会召集一个团队，通常 Stewart 和我也会参加。我们实际上会先从相关领域的其他产品开始，我们会说：“好的，作为一个小组，我们将体验整个客户旅程——从你进入网站的那一刻起，假设它是一个办公产品，到建立第一个账户，让前几个用户加入，直到体验到产品的价值。”

---

### [00:28:21] Noah Weiss

**English:**
We're going to do it on one screen. Someone's going to project and then people are going to fill in every issue, everything that's confusing, every pain point, not bones, but ways in which if you didn't care about the software, you don't work on it, what would actually confuse you? What would stop you in your tracks?

**中文翻译:**
我们会在一个屏幕上操作，有人负责投屏，然后大家记录下每一个问题、每一个令人困惑的地方、每一个痛点。不是找茬，而是思考：如果你不关心这个软件，也不在里面工作，什么会让你感到困惑？什么会让你停滞不前？

---

### [00:28:38] Noah Weiss

**English:**
From that you went generating a bunch of amazing inspiration by looking at someone else's product in a really critical way for things you might want to try in your own product. Once you get to that, then it becomes easier to actually do with your own software, but it is a little painful obviously. Same with watching usability tests to look at your own baby in a way that is, "Okay. I'm trying to find all the words. I'm trying to find all the problems."

**中文翻译:**
通过这种极其挑剔的方式观察别人的产品，你会产生很多奇妙的灵感，发现一些你想在自己产品中尝试的东西。一旦你习惯了这种方式，再对自己的软件进行这种操作就会变得容易一些，尽管这显然有点痛苦。这就像观看可用性测试一样，以一种“好的，我要找出所有的毛病，找出所有的问题”的方式来看待你自己的“孩子”。

---

### [00:29:03] Noah Weiss

**English:**
But that's one up being a pretty great source. Whenever a team I think either gets stuck or feels like they reach a dead end in a direction is doing complaint-storms about the product area that they're in or using adjacent products just to get inspiration. Then I think it unlocks a lot more creative views than the problem space.

**中文翻译:**
但这确实是一个非常棒的灵感来源。我认为，每当一个团队陷入困境或觉得在某个方向走到了尽头时，对他们所在的产品领域进行“抱怨风暴”，或者使用相关产品来获取灵感，都能在问题空间中解锁更多创意视角。

---

### [00:29:23] Lenny

**English:**
It's similar to a process that I learned Stripe has called friction logging. But I love the nuance here of starting with someone else's product because I could totally see how that makes you feel better looking at your product in real life. It's not like we suck. It's okay, everyone's has so much opportunity.

**中文翻译:**
这和我了解到的 Stripe 的一个叫“摩擦日志（friction logging）”的流程很像。但我很喜欢这里从别人的产品开始的细微差别，因为我完全能理解这如何让你在现实中看待自己的产品时感觉好受一些。这不代表我们很差，而是说明每个人都有很大的提升空间。

---

### [00:29:38] Noah Weiss

**English:**
Exactly. Yeah. I've heard that from Stripe, too. I think gets a similar place. I think it's the doing it ... I think the byproduct is that you also get calibration on product pace, product quality, and as a team you develop that together. Again, similar to the principles, it's like how do you get these things that are hard to actually feel collectively on the same page about and how do you calibrate? It's another good way to do it.

**中文翻译:**
没错。我也听 Stripe 的人说过。我认为效果是类似的。我认为这样做的一个副产品是，你还可以对产品节奏、产品质量进行校准，并且作为一个团队共同建立这种认知。再次强调，这与原则类似：你如何让这些难以达成共识的事情在集体层面保持一致，以及你如何进行校准？这是另一种很好的方法。

---

### [00:30:01] Lenny

**English:**
I'm imagining some PMs might be hearing this and wonder, "Okay. Great. Now the founders and the execs have all these things that they want us to fix. I have goals to hit. I got a roadmap. How do you think about prioritizing things that come up in these sorts of sessions for the team and how do they mix and match versus all the other stuff that you want to do? Or is it just like they don't actually have a huge roadmap and this is a way to inform the roadmap?

**中文翻译:**
我能想象有些 PM 听到这里可能会想：“好吧，太棒了，现在创始人和高管们有一大堆想让我们修复的东西。但我有目标要达成，我有路线图。你如何考虑在这些会议中提出的事项的优先级？它们如何与你计划做的其他事情结合？还是说他们其实并没有庞大的路线图，这只是完善路线图的一种方式？”

---

### [00:30:23] Noah Weiss

**English:**
No. I mean, more broadly, I think the way that we think about, or us to think about our roadmap for any feature team at Slack is that it's a portfolio and it's meant to be a portfolio that's diversified a couple different ways. I think one is you want to diversify things that are meant to be new capabilities versus making the thing you've already built a little bit better every day. Similar to parenting.

**中文翻译:**
不。我的意思是，从更广泛的角度来看，我们思考 Slack 任何功能团队路线图的方式是：它是一个投资组合，而且应该在几个不同方面实现多样化。我认为其中一点是，你需要在“开发新功能”和“让已有的东西每天进步一点点”之间取得平衡。这和育儿很像。

---

### [00:30:47] Noah Weiss

**English:**
Are there things that are meant to be risky that you aren't sure are going to work but might have a lot of upside versus things that are known bets. Then I think often you're balancing are you doing things that are meant to have impact that you're already very confident in versus things that are meant to learn about a new possibility space.

**中文翻译:**
是否有一些风险较高、你不确定是否奏效但可能有巨大潜力的尝试，以及一些稳扎稳打的投入？然后，你通常还要在“你非常有信心产生影响的事情”与“旨在探索新可能性空间的事情”之间进行平衡。

---

### [00:31:05] Noah Weiss

**English:**
I think for most teams, this stuff usually wind up tactically filling up that bucket of, "Let's make the existing product a little bit better every day for users." At Slack we have this thing we call customer Love Sprints, which is an interesting way team to figure out how to get this on their roadmap is it's hard to allocate that work throughout the quarter.

**中文翻译:**
我认为对于大多数团队来说，这些东西通常在战术上填补了“让现有产品每天为用户变好一点点”的那个篮子。在 Slack，我们有一个叫“客户关爱冲刺（Customer Love Sprints）”的东西。这是一个有趣的方法，因为团队很难在整个季度中分配这类工作。

---

### [00:31:26] Noah Weiss

**English:**
What we'll wind up doing often is have a team do a two-week customer love sprint, almost like a hackathon, but with that burndown list of what we think is the lowest effort, highest impact changes that we can make to generate more love from our customers and whatever that feature areas. Then people just sprint for two weeks, design product engineering, and then you have a bunch of things that you celebrate.

**中文翻译:**
我们通常会做的是让团队进行为期两周的“客户关爱冲刺”，有点像黑客马拉松，但针对的是一份待办清单，上面列出了我们认为成本最低、影响最大的改动，旨在让客户更爱我们的产品。然后，设计、产品、工程人员会一起冲刺两周，最后你会有一堆值得庆祝的成果。

---

### [00:31:48] Noah Weiss

**English:**
At the end, the goal is to ship all of them. This isn't hacks that you throw away. That's how we end up prioritizing it off in that work is actually making it this really fun total change of pace throughout the quarter to not do big feature work that may take months, but to do all these small delightful things that customers are going to love at the end. That's the other way that we figure out how to balance it in.

**中文翻译:**
最终的目标是发布所有这些改动。这些不是用完即弃的临时方案。这就是我们确定优先级的方式——在整个季度中创造一种非常有趣的节奏变换，不去纠结那些可能耗时数月的大型功能开发，而是去做所有这些客户最终会喜爱的、令人愉悦的小细节。这是我们平衡工作量的另一种方式。

---

### [00:32:11] Lenny

**English:**
I love that. How often do you do these sorts of customer Love Sprints?

**中文翻译:**
我喜欢这个。你们多久进行一次这种“客户关爱冲刺”？

---

### [00:32:14] Noah Weiss

**English:**
I would think teams that work on very user facing products do it at least once a quarter. I think other teams that work on maybe less user facing might do it maybe twice a year. But quarterly is a pretty healthy cadence.

**中文翻译:**
我认为负责直接面向用户产品的团队至少每季度做一次。其他负责非直接面向用户产品的团队可能每年做两次。但每季度一次是一个非常健康的节奏。

---

### [00:32:26] Lenny

**English:**
Wow. I didn't know about that. That connects to ... Slack has always been a very delightful product. I remember early on the animations were so awesome, the little twirly, I don't know, pounds hashtag thing. It feels like Slack has always invested in delight. How do you operationalize that? Is it these customer Love Sprints? Is there something else that's just like we need to allocate some percentage, just make things really fun even though it's not going to move any metric?

**中文翻译:**
哇，我以前不知道这个。这让我想起……Slack 一直是一款非常令人愉悦的产品。我记得早期那些动画非常棒，比如那个旋转的小井号（hashtag）。感觉 Slack 一直在“愉悦感”上投入。你们是如何将其流程化的？是靠这些“客户关爱冲刺”吗？还是有别的规定，比如“我们需要分配一定比例的精力，纯粹为了让事情变得有趣，即使它不会推动任何指标”？

---

### [00:32:51] Noah Weiss

**English:**
I would say it's a little bit good DNA of the company, honestly, which is that for co-founders trying to build a massive online role playing game for many years that was called Glitch and their background was all in building delightful, playful experiences. Glitch didn't work out. But, yeah, there's a whole long backstory. But the short version is a tool they had built internally that they then wound up spitting out a company from which became Slack.

**中文翻译:**
老实说，我认为这在一定程度上是公司的优良基因。联合创始人曾花了多年时间试图开发一款名为 Glitch 的大型在线角色扮演游戏，他们的背景全是关于构建令人愉悦、充满趣味的体验。Glitch 没成功，但有一个很长的背景故事。简而言之，Slack 最初是他们内部开发的一个工具，后来演变成了一家独立的公司。

---

### [00:33:18] Noah Weiss

**English:**
I think that DNA we're trying to build a consumer grade experience that just happens to be for work is really ingrained in the company. It's also a big part of how we hire. I would say certainly the majority of PMs designers and engineers who joined Slack had never worked at an enterprise software company before. It's not like most people had worked at Oracle or SAP, it's most people had worked at consumer companies or game companies.

**中文翻译:**
我认为那种“构建一个恰好用于工作的消费级体验”的基因已经深深植根于公司。这也是我们招聘的重要标准。我想说，加入 Slack 的大多数 PM、设计师和工程师以前从未在企业软件公司工作过。大多数人不是来自 Oracle 或 SAP，而是来自消费级公司或游戏公司。

---

### [00:33:44] Noah Weiss

**English:**
They bring that focus in the spirit and then I would say the last bit beyond kind of the principles and the complaints-storms and the customer love is that we have this amazing team that we call the CET team, the Customer Experience Team. They're in some ways the team that is doing our scale at Foursquare is most often in touch with our customers.

**中文翻译:**
他们带来了那种专注的精神。除了原则、“抱怨风暴”和“客户关爱”之外，最后一点是，我们有一支了不起的团队，叫做 CET 团队（客户体验团队）。在某种程度上，他们是与客户接触最频繁的团队。

---

### [00:34:02] Noah Weiss

**English:**
From the very early days people used to do CE shifts if you worked in products so that you can actually figure out what's frustrating, what's confusing. We have a really great pipeline for getting the insights from the CE team of what are the obstacles, the pain points, the most frequent complaints into the hands of the product teams to be able to prioritize, to figure out, yeah, not all these are going to move a given metric. They might not achieve something for the business.

**中文翻译:**
从很早开始，如果你在产品部门工作，你就要去轮值 CE（客户体验）岗位，这样你就能真正弄清楚什么是令人沮丧的，什么是令人困惑的。我们有一套非常棒的流程，将 CE 团队收集到的洞察（障碍、痛点、最频繁的投诉）传递给产品团队，以便他们确定优先级。我们明白，并非所有这些都能推动特定指标，或者为业务带来直接收益。

---

### [00:34:28] Noah Weiss

**English:**
But collectively, I think the way that Slack thinks about competition is we obsess it about customers. We build something they'll love enough to tell their coworkers and the rest takes care of itself.

**中文翻译:**
但总的来说，我认为 Slack 对待竞争的方式是：我们痴迷于客户。我们构建出让他们喜爱到愿意告诉同事的东西，剩下的自然会水到渠成。

---

### [00:34:41] Lenny

**English:**
Speaking of competition, something I wanted to ask you a bit about. Early on Slack was competing against this product called HipChat and that's actually what I used at our startup and we love HipChat. It was so hilarious, just these memes everywhere and their billboards are amazing. But then Slack ate their lunch later on. I'm just thinking out loud, discord feels like that was the big threat and how Microsoft Teams obviously.

**中文翻译:**
说到竞争，我想问你一点。早期 Slack 的竞争对手是一款叫 HipChat 的产品，那也是我们在创业公司使用的产品，我们很喜欢 HipChat。它非常搞笑，到处都是表情包，他们的广告牌也很棒。但后来 Slack 抢占了他们的市场。我还在想，Discord 感觉曾是一个巨大的威胁，当然还有现在的 Microsoft Teams。

---

### [00:35:03] Lenny

**English:**
I'm curious just how you think about competition and even just what you've learned about working in a space where there's a lot of competition and thinking about that long-term and even short-term.

**中文翻译:**
我很想知道你是如何看待竞争的，以及在竞争激烈的领域工作，你对于长期和短期竞争有哪些心得？

---

### [00:35:12] Noah Weiss

**English:**
Yeah. I mean each of those is an interesting mini lesson learned about those. I think the through line for all of them I would say is still the max that we have in trailing, which is we're customer obsessed but competitor aware. I think it's a little bit different. I think some companies are like ... I don't know, Uber for example, I think was notorious competitor obsessed and they tried to delete customers when they could.

**中文翻译:**
是的，每一个案例都是一个有趣的微型教训。我认为贯穿其中的主线仍然是我们的准则：痴迷于客户，但关注竞争对手。我认为这有点不同。有些公司，比如 Uber，曾以“痴迷于竞争对手”而闻名，他们甚至会在可能的情况下试图“删除”竞争对手的客户。

---

### [00:35:35] Noah Weiss

**English:**
I think HipChat. I don't think Slack sought out to kill HipChat. At Foursquare we used ... I think it was called Campfire back in the day for the 37 singles people. It was a whole generation of those products. I think Slack came along and I think they had a couple of innovations. One was they had a great mobile experience that synced across every client. Search actually worked and then they brought a lot of the best parts of consumer messaging into the workplace like the emoji and reactions and all those bits.

**中文翻译:**
关于 HipChat，我不认为 Slack 的目标是杀掉它。在 Foursquare，我们当时用的是 Campfire（37signals 的产品）。那是整整一代那样的产品。我认为 Slack 出现后带来了一些创新：一是它拥有出色的移动端体验，可以在所有客户端同步；二是搜索功能真的好用；三是它将消费级消息传递的许多优点带到了职场，比如表情符号、回应（reactions）等等。

---

### [00:36:04] Noah Weiss

**English:**
I think it turns out that if you're 10X better on a couple of those axes, then you can see a huge change in behavior. I think that's what happened with that move from the HipChat Campfire to Slack world. Discords interesting. I mean we keep aware of Discord. But it is so much more focused on the consumer. Originally, it was [inaudible 00:36:23] out for community space. I think at Slack the lesson I would have, I think we learned in a good way is we've always really been focused on groups of people who are trying to do work together.

**中文翻译:**
事实证明，如果你在其中几个维度上比别人好 10 倍，你就能看到用户行为的巨大转变。我认为这就是从 HipChat/Campfire 转向 Slack 世界的原因。Discord 很有趣，我们一直关注它，但它更专注于消费者。最初它是为社区空间设计的。在 Slack，我们学到的教训（也是一种正向的坚持）是：我们始终专注于那些试图一起工作的群体。

---

### [00:36:33] Noah Weiss

**English:**
That winds up being a completely different audience to build for than communities. I think that focus has been really helpful and I think Discord's amazing and many people love it and the people who use Discord certainly use it in very different way than people who use Slack at work.

**中文翻译:**
为工作群体构建产品与为社区构建产品是完全不同的受众。我认为这种专注非常有帮助。Discord 很棒，很多人喜欢它，但使用 Discord 的人与在工作中使用 Slack 的人的方式肯定大不相同。

---

### [00:36:49] Noah Weiss

**English:**
I think Microsoft obviously has become over time the biggest competitor there. I think the origin of Teams really was a defensive move for them to protect Office because Office is an incredible, very profitable monopoly in the productivity space. I think when they built Teams it was more of a covering their flank versus Slack on the ascent.

**中文翻译:**
我认为随着时间的推移，微软显然已经成为最大的竞争对手。Teams 的起源实际上是他们为了保护 Office 而采取的防御举措，因为 Office 在办公生产力领域是一个令人惊叹且利润丰厚的垄断产品。我认为当他们构建 Teams 时，更多是为了在 Slack 崛起时掩护自己的侧翼。

---

### [00:37:10] Noah Weiss

**English:**
I think as Teams has evolved over time, it's become much more of a video conferencing product that competes with Zoom and Google Meet. The people who use Teams use it completely different than Slack where you live and breathe and channels and work and workflows all day long.

**中文翻译:**
我认为随着 Teams 的演变，它已经变得更像是一款视频会议产品，与 Zoom 和 Google Meet 竞争。使用 Teams 的人与使用 Slack 的人完全不同，在 Slack 中，你整天都沉浸在频道、工作和工作流中。

---

### [00:37:25] Noah Weiss

**English:**
I think what we've seen there too is that a lot of our customers, they happily use both. Most Fortune 500 companies have either a subscription or a Google Workplace subscription and all of those customers who use those also use Slack. We like to say that Slack is this connected tissue that makes all the rest of your tools that much better.

**中文翻译:**
我们也看到，很多客户同时愉快地使用这两者。大多数财富 500 强公司要么有微软订阅，要么有 Google Workspace 订阅，而这些客户中也有很多人在使用 Slack。我们常说 Slack 是这种“连接组织”，它能让你所有的其他工具变得更好。

---

### [00:37:44] Noah Weiss

**English:**
I think there we've taken very much an open ecosystem and platform approach and we've just been focused on how do we keep building the best version of what Slack can be as a new category of software for our customers and staying aware of our competitors, but really obsessed on what are the new ways that we can delight our users as the years go by.

**中文翻译:**
在那方面，我们采取了非常开放的生态系统和平台策略。我们一直专注于如何为客户持续构建 Slack 作为一个新类别软件的最佳版本，保持对竞争对手的关注，但真正痴迷于随着时间的推移，我们能用哪些新方式来取悦我们的用户。

---

### [00:38:04] Lenny

**English:**
Slack is a big-ish company within now let's say a big company. But it feels like you still are launching really interesting stuff, you launch huddles, clips, there's this AI stuff coming, sounds like. I'm curious what you have done at Slack to enable these sorts of zero to one bets and what you've seen is important to allow for innovation along those lines.

**中文翻译:**
Slack 现在可以说是一家大公司内部的一家“准大公司”。但感觉你们仍然在发布非常有趣的东西，比如 huddles、clips，听起来还有 AI 相关的东西要推出。我很想知道，你们在 Slack 做了什么来支持这种“从 0 到 1”的押注？你认为在这些方面允许创新，什么才是最重要的？

---

### [00:38:26] Noah Weiss

**English:**
I think maybe we're all a little self-delusional, because I think everyone who works at Slack likes to think that we're still at a small startup. I think keeping that spirit alive, honestly culturally has been a big part of it. I think going back to the principles early on, one of the ones that we did talk about, literally one of the actual wording is take bigger boulder bets.

**中文翻译:**
我想也许我们都有点“自我陶醉”，因为我觉得在 Slack 工作的每个人都喜欢认为我们仍然是一家小型初创公司。老实说，在文化上保持这种精神是非常重要的一部分。回到早期的原则，我们谈论过的一个原则，字面意思就是“进行更大胆的‘巨石级’押注（Take bigger boulder bets）”。

---

### [00:38:43] Noah Weiss

**English:**
The idea there is that it's really easy to fall into the trap of just constant incrementalism. The concept, it's like a feature team and you have like a KPI and you feel like your whole life is measured by that similar KPI going up 1% a quarter and then you lose sight of what's beyond the horizon. We have this mental metaphor that we talk a lot about getting to the next hill.

**中文翻译:**
核心理念是，人们很容易陷入“持续渐进主义”的陷阱。比如一个功能团队有一个 KPI，你觉得你的一生都在被那个每季度增长 1% 的 KPI 所衡量，然后你就看不见地平线之外的东西了。我们有一个经常谈论的心理隐喻，叫做“翻过下一座山丘”。

---

### [00:39:07] Noah Weiss

**English:**
The idea is that if you're in a mountain range and you're maybe in the little valley, you can see what's right in front of you. But you have no idea how tall the mountains are behind. I think teams can often get lost crawling up that hill, not realizing that there's a huge, incredibly beautiful range behind it.

**中文翻译:**
这个想法是，如果你身处山脉之中，也许在一个小山谷里，你能看到眼前的景象。但你不知道后面的山有多高。我认为团队经常会迷失在爬坡的过程中，而没有意识到后面有一片极其壮丽的山脉。

---

### [00:39:26] Noah Weiss

**English:**
Take bigger boulder bets. Get to the next hill to see what the horizon wants around you. That's how we think about it strategically. Then I think structurally the way we've approached it is that we've over time freighted new teams from scratch that incubated in a new area before the area mature. We did that with a lot of these native audiovisual products like huddles and clips really in the pandemic because our customers were demanding it from us.

**中文翻译:**
进行更大胆的“巨石级”押注。翻过下一座山丘，看看周围的地平线是什么样的。这就是我们在战略上的思考方式。在结构上，我们的做法是，随着时间的推移，我们从零开始组建新团队，在这些领域成熟之前就进行孵化。在疫情期间，我们针对许多原生音视频产品（如 huddles 和 clips）就是这么做的，因为客户对我们有这些需求。

---

### [00:39:49] Noah Weiss

**English:**
They were like, "We love living in Slack all day. But we feel disconnected from our teammates when we can't be in the same physical place. What can you do to help us?" That's where that came from. I think in the AI space now, it's a similar thing, which is what we're trying to hear from customers. What do you wish Slack could do if it had these new superpowers? Let's incubate a couple teams, a prototype there and then figure out what can get to real product market fit.

**中文翻译:**
他们说：“我们喜欢整天待在 Slack 里。但当我们不能在同一个物理场所时，我们感到与队友失去了联系。你们能做些什么来帮助我们吗？”这就是这些功能的由来。我认为在现在的 AI 领域也是类似的情况，我们正试图倾听客户的声音：如果 Slack 拥有了这些新的“超能力”，你希望它能做什么？让我们孵化几个团队，做一个原型，然后看看什么能真正达到“产品市场匹配（PMF）”。

---

### [00:40:14] Noah Weiss

**English:**
I think when we have those teams, I think it's important to just give them space to run, to give them ... get a gel free card for maybe the normal process of, "Okay. Our planning quarterly reviews" and make it feel something that is the pace of learning is what matters. How fast are you prototyping, how fast are you learning from users and then getting to do that publicly and pilot and then get something to launch that's amazing, blows people away. That's the formula that we've seen.

**中文翻译:**
我认为当拥有这些团队时，重要的是给他们奔跑的空间，给他们一张“免死金牌”，让他们可以跳过常规的季度评审流程，让他们觉得“学习的速度”才是最重要的。你原型设计的速度有多快？你从用户那里学习的速度有多快？然后公开进行试点，最后推出一些令人惊叹、让人眼前一亮的东西。这就是我们总结出的公式。

---

### [00:40:43] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Com, Quora, and Modern Treasury trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months.

**中文翻译:**
本集由 Vanta 赞助，帮助你简化安全合规流程，加速业务增长。数千家快速成长的公司（如 Gusto、Com、Quora 和 Modern Treasury）信任 Vanta，帮助他们构建、扩展、管理和展示其安全合规计划，并在几周（而非几个月）内为审计做好准备。

---

### [00:41:01] Lenny

**English:**
By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27,001, GDPR, HIPAA, and many more, Vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time, Lenny's podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny, that's V-A-N-T-A .com/lenny to learn more and to claim your discounts. Get started today.

**中文翻译:**
通过提供最受追捧的安全和隐私框架（如 SOC 2、ISO 27001、GDPR、HIPAA 等），Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家快速成长的公司使用 Vanta 将 SOC 2 和其他框架涉及的工作自动化程度提高到 90%。在限定时间内，Lenny 播客的听众可以享受 Vanta 1000 美元的优惠。访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### [00:41:39] Lenny

**English:**
One of the things I love learning about from product teams is their unique rituals and traditions. I'm curious what's maybe the most interesting or unique or fun or funny ritual or tradition on the product team of things you all maybe do regularly?

**中文翻译:**
我最喜欢向产品团队了解的一件事就是他们独特的仪式和传统。我很想知道，在你们的产品团队中，最有趣、最独特或最搞笑的定期举行的仪式或传统是什么？

---

### [00:41:56] Noah Weiss

**English:**
One of the things that we do, which is always a little bit funny, I mean, it's more of a emotional thing rather than a practical thing is that at all hands we'll often wind up taking specific tweets that people had about the product and Twitter. People say the craziest thing sometimes. Sometimes they're really heartwarming like customer love, but often it's just the meanest, most frustrating complaints that people have.

**中文翻译:**
我们做的一件事总是有点搞笑，与其说是实用的，不如说是情感上的。在全体员工大会（All-hands）上，我们经常会挑选一些人们在 Twitter 上发布的关于产品的特定推文。人们有时会说一些很疯狂的话。有时是非常暖心的客户表扬，但通常是人们提出的最刻薄、最令人沮丧的投诉。

---

### [00:42:21] Noah Weiss

**English:**
It's honestly meant for us to just have a pulse on, we're at people actually saying and feeling in the wild and not thinking too seriously, but keeping that sense of ... I think that the distance you have from your users as your user base gets more and more diverse and larger I think can make it harder to actually develop the product because you're not designing for yourself anymore.

**中文翻译:**
老实说，这只是为了让我们把握脉搏，了解人们在现实世界中到底在说些什么、感受到了什么。我们不会太严肃地对待它，但要保持那种……我认为，随着用户群变得越来越多元和庞大，你与用户之间的距离会让你更难开发产品，因为你不再是为自己设计了。

---

### [00:42:41] Noah Weiss

**English:**
I think all the ways that we help keep people grounded in what are actual users actually saying. That's one big way. The other that reminded me of which is actually probably better, maybe delete that last one because it's kind of boring.

**中文翻译:**
我认为所有这些方式都能帮助人们脚踏实地，了解真实用户的真实想法。这是一个重要的方法。另一个我想到的方法可能更好，也许删掉刚才那个吧，因为那个有点无聊。

---

### [00:42:55] Lenny

**English:**
No. It's great. We're not deleting nothing.

**中文翻译:**
不，那个很好。我们什么都不删。

---

### [00:42:57] Noah Weiss

**English:**
Fine. Usability. I'm a big believer in you want to be data-informed, but you don't want to be so data-driven that you actually don't have a pulse of what real people feel when they're using your product. We're really big into user research, not as it gives you the answer, but it helps at least pose a lot of questions for you when you watch how someone actually uses the software.

**中文翻译:**
好吧。关于可用性，我坚信你应该“以数据为参考（data-informed）”，但不要被数据驱动到完全感受不到真实用户在使用产品时的感受。我们非常重视用户研究，不是因为它能直接给你答案，而是当你观察别人如何实际使用软件时，它至少能帮你提出很多问题。

---

### [00:43:21] Noah Weiss

**English:**
Historically, it's really hard to get PMs, let alone engineers actually attend user research sessions. What we wound up doing, especially in the pandemic when we first went remote, is now you can dial into usability sessions and to make it really attractive for the team, what we would do is have people live in a thread, write their real time thoughts of ... so painful, how they use that, or I can't believe they missed that, or, oh, that gave me this idea from seeing how they were doing that to do this other thing.

**中文翻译:**
从历史上看，很难让 PM 参加用户研究会议，更不用说工程师了。我们最终的做法是（特别是在疫情期间我们刚开始远程办公时），现在你可以拨入可用性测试会议。为了让它对团队更有吸引力，我们会让大家在一个 Slack 频道（thread）里实时写下他们的想法，比如：“太痛苦了，他们竟然那样用”，或者“我不敢相信他们漏掉了那个”，或者“哦，看到他们那样操作，给了我做另一件事的灵感”。

---

### [00:43:50] Noah Weiss

**English:**
Then you wind up having the PMs, the engineers, designers and the user researcher all in one Slack thread live, responding, reacting to usability session. Then suddenly that thread becomes actually the best source of truth for the research report that then gets written up.

**中文翻译:**
然后，你会发现 PM、工程师、设计师和用户研究员都在同一个 Slack 频道里，实时响应和反馈可用性测试。突然之间，那个频道就成了随后撰写的研究报告的最佳事实来源。

---

### [00:44:06] Noah Weiss

**English:**
But I think most importantly, it gets the team almost like the complaint-storms, but actually watching someone else do it in the shoes of an actual human being trying to use the thing that you thought was so brilliant and yet has all these flaws. It's humbling. It's filled with humor and also it's I think really constructive for the teams to do it that way.

**中文翻译:**
但最重要的是，它让团队（就像“抱怨风暴”一样）真正站在一个普通人的角度，观察别人如何尝试使用那个你认为非常出色、却充满缺陷的东西。这让人保持谦逊，充满了幽默感，而且我认为这种方式对团队非常有建设性。

---

### [00:44:27] Lenny

**English:**
I was going to ask where they actually share these thoughts. In Slack makes a lot of sense.

**中文翻译:**
我正想问他们是在哪里分享这些想法的。在 Slack 里分享确实非常合理。

---

### [00:44:31] Noah Weiss

**English:**
Yeah. I mean it turns into a report at some point, but literally just link back to the original thread and then you have 100 people's reaction as the report is ongoing.

**中文翻译:**
是的。它最终会变成一份报告，但只需链接回原始频道，你就能在报告生成过程中看到 100 个人的实时反应。

---

### [00:44:41] Lenny

**English:**
If only there was a AI tool to summarize all of your thoughts.

**中文翻译:**
要是有一个 AI 工具能总结你所有的想法就好了。

---

### [00:44:45] Noah Weiss

**English:**
We've got a prototype for that. Hopefully it'll work well enough that actually be useful for customers, too.

**中文翻译:**
我们已经有一个原型了。希望它能运行得足够好，最终也能对客户有用。

---

### [00:44:51] Lenny

**English:**
You tweeted once about how ... I think maybe around the time you joined Slack around 2019 that the self-service business of Slack basically plateaued and it wasn't clear why. I'm curious just what that period was like and how did you get to the bottom of what was going on and turn things around.

**中文翻译:**
你曾经发过一条推文，提到大约在你 2019 年加入 Slack 前后，Slack 的自助服务业务基本上陷入了停滞，而且原因不明。我很想知道那段时期是什么样的，你们是如何查明真相并扭转局面的？

---

### [00:45:09] Noah Weiss

**English:**
Yeah. It was actually a couple years after I joined, but it was a point where I was focused on the self-service business because we had this period with Slack where I would say maybe 2014 to 2017 where it was almost all self-service and it was just growing like gangbusters. Then we started spinning up the sales team and an enterprise team. We started focusing mostly on that.

**中文翻译:**
是的。那实际上是在我加入几年后。当时我专注于自助服务业务，因为 Slack 曾经历过一段时期（大约 2014 到 2017 年），几乎全是自助服务，而且增长势头极其迅猛。后来我们开始组建销售团队和企业团队，并将大部分精力转向了那里。

---

### [00:45:30] Noah Weiss

**English:**
I think we saw the team that was working on, but it was primarily the company's focus was all driving enterprise deals, getting to that next level of maturity. Then in 2019, I think we started to see that when we looked beneath the surface, the fundamentals of the self-service business weren't looking as healthy as they used to be.

**中文翻译:**
虽然还有团队在负责自助服务，但公司的重心主要是推动企业级交易，追求更高层次的成熟度。到了 2019 年，我们开始发现，透过表面看本质，自助服务业务的基本面看起来不像以前那么健康了。

---

### [00:45:50] Noah Weiss

**English:**
I think the biggest thing as we dug into it was a little bit to what we were talking about earlier with the motivation and complaints terms is it was getting harder to understand what the next generation of Slack customers really wanted from the product. Whether you're thinking about this as crossing the chasm or moving from kind of early adopters to the needs, the more majority or later adopters, I think we're at that point where not every technologically sophisticated company on earth was using Slack, but most were, and we were getting into a market that customers just had different needs. They had different levels of sophistication.

**中文翻译:**
我认为当我们深入研究时，最大的发现（有点像我们之前讨论的动机和“抱怨风暴”）是：越来越难理解下一代 Slack 客户对产品的真正需求。无论你将其视为“跨越鸿沟”，还是从早期采用者转向大众市场或后期采用者，我认为我们当时正处于这样一个节点：地球上并非每家技术先进的公司都在使用 Slack，但大多数已经在用了，而我们正在进入一个客户需求完全不同的市场。他们的技术成熟度各不相同。

---

### [00:46:24] Noah Weiss

**English:**
We did a lot of user research. We looked at all these cohort curves, which you can imagine suddenly they're like, "Huh, they're not as healthy as they used to be like. What's going on?" I think we got a bunch of insights from it. But I think really what we want to change about how we were operating was instead of to continue to try to optimize the things that had worked over the last couple years, we said, "Okay. Let's throw the whole roadmap away and instead let's come up with a bunch of hypotheses about what could be new levers that could actually help based on the insights that we now have about the next set of customers."

**中文翻译:**
我们做了大量的用户研究。我们查看了所有的留存曲线（cohort curves），你可以想象，突然发现它们不像以前那么健康了，大家都在问：“怎么回事？”我们从中获得了很多洞察。但我认为，我们真正想改变的是运营方式：我们不再继续优化过去几年行之有效的东西，而是说：“好吧，让我们扔掉整个路线图，根据我们现在对下一批客户的洞察，提出一系列关于‘哪些新杠杆可能真正起作用’的假设。”

---

### [00:46:56] Noah Weiss

**English:**
"We're going to try to quickly learn which of these levers are real and which of these are just totally off the mark." We had to say for the next six months, we're probably not going to drive any impact at all. It's only going to be about learning. But at the end of that, hopefully we wind up finding a couple different levers that had years of room run and that's what wound up happening.

**中文翻译:**
“我们将尝试快速了解哪些杠杆是真实的，哪些完全不着边际。”我们不得不说，在接下来的六个月里，我们可能根本不会产生任何业务影响，唯一的重点就是学习。但在那之后，希望我们能找到几个可以持续发挥作用多年的新杠杆。结果确实如此。

---

### [00:47:19] Noah Weiss

**English:**
We wound up doubling the rate of our new pay customer growth in the year and a couple years after that and accelerating the self-service business. I think it really came from stepping back, being humble, not feeling like we deserve to have every company on earth sign up and then figuring out how to optimize for learning. In the long term you could get the impact.

**中文翻译:**
在那一年以及随后的几年里，我们将新付费客户的增长率翻了一番，并加速了自助服务业务。我认为这真正源于退后一步，保持谦逊，不觉得地球上每家公司都理所当然应该注册，然后弄清楚如何针对“学习”进行优化。从长远来看，你最终会获得业务影响。

---

### [00:47:39] Noah Weiss

**English:**
But knowing that for the next couple quarters we're going to sacrifice impact for the sake of learning. I think that was a good muscle to build, but it was definitely not easy to do at the time.

**中文翻译:**
但要明白，在接下来的几个季度里，我们将为了学习而牺牲业务影响。我认为这是一种很好的锻炼，但在当时确实不容易做到。

---

### [00:47:49] Lenny

**English:**
Well, the story begs the question, what are the levers that worked? Whatever you can share.

**中文翻译:**
那么，这个故事引出了一个问题：哪些杠杆起作用了？在可以分享的范围内谈谈。

---

### [00:47:53] Noah Weiss

**English:**
One of the big things that we wound up focusing on is what we talk about is comprehension, desirability. The fundamental challenge I think for new users or new teams using your product once you get past the kind of tech early adopters is do they comprehend what this thing is for? Do they understand how it works? Then desirability is why should they care? Most people at work are not like," Hey. You know what I want to do today is start using an entirely new tool and convince all my coworkers to get on board.

**中文翻译:**
我们最终关注的一大重点是我们所说的“理解力（comprehension）”和“渴望度（desirability）”。我认为，一旦越过了技术早期采用者，新用户或新团队使用你产品的根本挑战在于：他们理解这东西是干什么的吗？他们明白它是如何运作的吗？而渴望度则是：他们为什么要关心它？大多数上班族不会想：“嘿，你知道我今天想做什么吗？我想开始使用一个全新的工具，并说服我所有的同事也加入进来。”

---

### [00:48:22] Noah Weiss

**English:**
That is not part of your job. Your job has goals and measurements and everything else. Really ... understanding that. How do you push on that in that new user experience? It sounds maybe a little ludicrous, but Slack always has a free product. Obviously, there's a free tier that you can use, but we had never actually figured out a trial strategy where we actually gave you a taste of the paid product.

**中文翻译:**
那不是你工作的一部分。你的工作有目标、有考核等等。真正理解这一点很重要。你如何在新的用户体验中推动这一点？这听起来可能有点荒谬，但 Slack 一直有免费产品，显然你可以使用免费层级，但我们以前从未真正制定过一种让你“尝鲜”付费产品的试用策略。

---

### [00:48:44] Noah Weiss

**English:**
Either we're on the free tier or we get to pay for the paid tier. And that wound up being one of, I think the Ripest veins is figuring out how to give people a taste of the full premium Slack experience so that they would never want to go back and doing that in a variety of different points in the customer journey. Then I'd say the other biggest thing I would call the one out is we really need to figure out a new north star metric for motivating the teams across Slack.

**中文翻译:**
以前你要么在免费层级，要么就得付钱买付费层级。我认为最有效的途径之一就是弄清楚如何让人们体验完整的 Slack 高级功能，让他们再也不想回到过去，并在客户旅程的各个不同节点实施这一策略。另一件最重要的事是，我们需要确定一个新的“北极星指标”来激励 Slack 的各个团队。

---

### [00:49:09] Noah Weiss

**English:**
At that point in time, we basically had paid customers and then we had creative teams, which is the very, very beginning, very, very end of the journey. We did a lot of quantitative research and data science and wound up coming up with this new metric we call successful teams, which is a little bit ... I feel a lot of companies have this Facebook, I'm lucky number seven or whatever it was.

**中文翻译:**
当时，我们基本上只有“付费客户”和“创建团队”这两个指标，这分别是旅程的最开始和最末尾。我们做了大量的定量研究和数据科学分析，最终提出了一个名为“成功团队（successful teams）”的新指标。这有点像很多公司都有的那种指标，比如 Facebook 的“7 天加 10 个好友”之类的。

---

### [00:49:28] Noah Weiss

**English:**
Where what we found was that if you could get five people using Slack, the majority of the work week to just communicate at all, that would be a successful team there were going to be 400% more likely to upgrade over the next six months. That seems like a very low bar, five people to use Slack throughout the work week, not even every day. But it turns out that if you could get that level of critical mass the rest would take care of itself.

**中文翻译:**
我们发现，如果你能让 5 个人在工作周的大部分时间里使用 Slack 进行任何形式的沟通，那就是一个“成功团队”，他们在接下来的六个月内升级的可能性会增加 400%。这看起来门槛很低——5 个人在工作周内使用 Slack，甚至不需要每天都用。但事实证明，如果你能达到这种程度的“关键质量（critical mass）”，剩下的事情就会自然发生。

---

### [00:49:54] Noah Weiss

**English:**
We wound up motivating not just the team that was focused on self-service but all these other feature teams across the company to drive more new successful teams, knowing that if we can move that which is much earlier in the funnel but not a top of funnel metric, then it would actually drive upgrades and paid customers and thus revenue long-term. That was a huge turning point for how we rally product teams around somebody to actually drive that self-service business.

**中文翻译:**
我们最终不仅激励了专注于自助服务的团队，还激励了全公司所有其他功能团队去推动更多新的“成功团队”。我们知道，如果我们能推动这个处于漏斗早期但又不是最顶端的指标，那么从长远来看，它将真正推动升级、增加付费客户并带来收入。这是我们如何团结产品团队来真正推动自助服务业务的一个巨大转折点。

---

### [00:50:22] Lenny

**English:**
Man, this feels like its own podcast. Just to analyze the things you learned down this journey, and there's so many takeaways here. One is just the importance of an activation metric that is predictive of retention sales. It sounds like you landed on five people in a company like DAU basically for a week, something like that. That's awesome.

**中文翻译:**
伙计，这感觉可以单独做一期播客了。仅仅分析你在这段旅程中学到的东西，就有这么多可以借鉴的地方。其中之一就是激活指标的重要性，它能预测留存和销售。听起来你确定的指标是：一家公司里有 5 个人，基本上在一周内保持活跃（DAU），类似这样。太棒了。

---

### [00:50:40] Lenny

**English:**
Then the other interesting takeaway here is I'm actually doing a bunch of interviews with founders of the most successful B2B companies and interestingly, not all, maybe half are like, "I still don't think we have product market fit. They're at a billion dollars valuation growing crazy." They're like, I feel like I have product market fit with the current users but I don't with the people I want next.

**中文翻译:**
另一个有趣的发现是，我最近采访了很多最成功的 B2B 公司的创始人。有趣的是，并非所有人，可能有一半的人会说：“我仍然不认为我们达到了产品市场匹配（PMF）。”尽管他们的估值已经达到 10 亿美元且增长疯狂。他们觉得：“我觉得我对现有用户达到了 PMF，但对我想争取的下一批用户还没有。”

---

### [00:51:08] Noah Weiss

**English:**
That's exactly right. I think that's exactly right. I think of product market fit is almost like you keep stacking these S-curves where you get product market fit in a small group and then you suddenly reach exponential growth because you can crack that coal group, that type of audience, but then you start declining because you start hitting the ceiling of, we've got in, I don't know what it might be every development team in the US to be using this product.

**中文翻译:**
完全正确。我认为 PMF 就像是不断堆叠的 S 曲线：你在一个小群体中达到了 PMF，然后因为攻克了那个核心群体或受众，你突然实现了指数级增长；但随后增长开始放缓，因为你触及了天花板，比如全美国所有的开发团队都已经在使用这个产品了。

---

### [00:51:30] Noah Weiss

**English:**
Then you jump up to the next S-curve, which is like how do we get technology savvy teams that aren't developers or how do we get people who are in large eventerprises who are outside the US. Each become new curves that you have to build product market fit for. I think it's just all a huge exercise in being self-critical, being humble, not presuming that you've cracked this thing forever and keeping kind of a very beginner's mindset of what does the next audience need. "

**中文翻译:**
然后你跳到下一条 S 曲线，比如：我们如何让非开发者的技术型团队也使用它？或者我们如何让美国以外的大型企业用户也使用它？每一条曲线都需要你重新建立 PMF。我认为这整个过程就是不断自我批评、保持谦逊、不预设自己已经永远解决了问题，并保持一种“初学者心态”，去思考下一批受众需要什么。

---

### [00:51:58] Noah Weiss

**English:**
Your previous audience. Didn't need it all.

**中文翻译:**
而你之前的受众可能根本不需要那些东西。

---

### [00:52:01] Lenny

**English:**
If you think about the pie chart of what you had to change to make it work, how much of it was it messaging, positioning, onboarding, optimization versus product features?

**中文翻译:**
如果你回想一下为了让它奏效而必须做出的改变，其中有多少比例是关于文案、定位、新手引导和优化，又有多少是关于产品功能本身的？

---

### [00:52:10] Noah Weiss

**English:**
I would say maybe 60-40 in the sense of the early journey. I mean not just obviously positioning messaging, but the entire experience of unboxing Slack if you will with your team. We called it the day one journey, but extended to really kind of day 30 in reality and it's a single player and multiplayer experience. It is really complex.

**中文翻译:**
我会说在早期旅程中大约是 60 比 40。我的意思是，不仅是定位和文案，还包括你和团队一起“拆箱”Slack 的整个体验。我们称之为“第一天旅程”，但实际上延伸到了第 30 天，这既是单人体验也是多人体验。它确实非常复杂。

---

### [00:52:33] Noah Weiss

**English:**
But then I think what we realized was you can make that incredible, but if fundamental parts of the product were missing that would make it comprehensible to the next audience, then you're going to have problems. It sounds maybe impossible to remember, but Slack used to not have wizzywig message composition.

**中文翻译:**
但后来我们意识到，你可以把引导做得非常出色，但如果产品缺少一些能让下一批受众理解的基础部分，你还是会遇到问题。现在听起来可能难以置信，但 Slack 以前是没有“所见即所得（WYSIWYG）”的消息编辑功能的。

---

### [00:52:53] Noah Weiss

**English:**
You used to have to use mar, down. Making that wizzywig was a huge boost making mobile work offline so it worked no matter where you were in the world was another big one. All the things about configuring your sidebar notification so that as you scale it you should just Slack it and become overwhelming. Those are some of the foundational product investments that we wound up making so that next generation of Slack customers could get value and not be overwhelmed or daunted by it.

**中文翻译:**
你以前必须使用 Markdown。实现“所见即所得”是一个巨大的提升；让移动端支持离线工作，使其在世界任何地方都能使用，是另一个重大改进。还有关于配置侧边栏通知的所有功能，这样当你规模扩大时，Slack 就不会变得让人应接不暇。这些都是我们最终做出的基础性产品投入，以便下一代 Slack 客户能够获得价值，而不会感到不知所措或望而生畏。

---

### [00:53:22] Lenny

**English:**
Maybe one last question along these lines, people look at Slack as maybe the first major product-led growth success story and they always look at Slack of like, "Oh, we just want to grow Slack. Let's see what they did." For people that are studying Slack's journey and success, what do you think Slack did right early on that maybe people don't recognize or don't appreciate enough that founders today should be thinking about more so versus just like let's just make a freemium product.

**中文翻译:**
关于这方面最后一个问题：人们视 Slack 为第一个重大的“产品驱动增长（PLG）”成功案例，他们总是看着 Slack 说：“哦，我们也想像 Slack 那样增长，看看他们做了什么。”对于那些研究 Slack 历程和成功的人，你认为 Slack 早期做对了什么，是人们可能没有意识到或没有给予足够重视的？今天的创始人应该更多地思考什么，而不仅仅是“让我们做一个免费增值产品”？

---

### [00:53:48] Noah Weiss

**English:**
Right. I mean, I think, maybe the most telling thing is when Slack started, certainly when I joined still, I don't think a word or acronym product-led growth existed. It wasn't like we were really good at taking this playbook and applying it. I think it was more that whole term of art became a thing as maybe many other freemium SaaS products took off.

**中文翻译:**
没错。我想，也许最能说明问题的是，当 Slack 开始时，甚至在我加入时，我都不认为“产品驱动增长（PLG）”这个词或缩写已经存在。并不是说我们非常擅长拿来这个剧本并应用它。我认为更多的是，随着许多其他免费增值 SaaS 产品的兴起，这个术语才变成了一个流行词。

---

### [00:54:13] Noah Weiss

**English:**
Not to be repetitive. But I think the core of it really was building a product that customers loved enough that they would put their own social capital on the line to get their coworkers on board 5 to 50 people." At the time the biggest company I imagined using Slack was 50 people because I don't know how this is going to work beyond that, maybe it'll become pandemonium. Obviously, that was the initial, I think real, real strong product market fit.

**中文翻译:**
不想重复，但我认为核心确实是构建了一个让客户足够喜爱的产品，以至于他们愿意押上自己的“社交资本”，去说服 5 到 50 个同事也加入进来。当时我能想象的使用 Slack 的最大公司也就是 50 人，因为我不知道超过这个规模会怎样，也许会变得一团糟。显然，那是最初真正的、非常强劲的 PMF。

---

### [00:55:11] Noah Weiss

**English:**
But the other bit which then was what powered the enterprise business was teams of 5 to 50 people who worked at larger companies. I think what wound up happening was that you would have teams that was independently at a company like IBM or Disney or Capital One or whoever it might be, or Comcast discovering Slack using it for themselves because they thought it would just make their working lives simpler, more pleasant, more productive, and maybe not even know that anyone else at the company was using Slack.

**中文翻译:**
但随后支撑起企业业务的另一部分是，那些在大型公司工作的 5 到 50 人的团队。最终发生的情况是，在 IBM、迪士尼、第一资本（Capital One）或康卡斯特（Comcast）这样的公司里，会有一些团队独立发现了 Slack 并开始使用，因为他们觉得这能让工作更简单、更愉快、更高效，而他们甚至可能不知道公司里还有其他人在用 Slack。

---

### [00:55:39] Noah Weiss

**English:**
Then by the time we then scaled our enterprise sales team, I mean, truly the exercise initially was just take customer domain, sort by number of active users and call them in the order of that which is, "Hey, by the way, you have a couple thousand people actually using Slack at your company. Do you want to think about a broader deployment or controls or analytics?"

**中文翻译:**
当我们后来扩大企业销售团队规模时，最初的做法其实就是：获取客户域名，按活跃用户数排序，然后按顺序给他们打电话：“嘿，顺便说一下，你们公司实际上有几千人在用 Slack。你们想考虑一下更大规模的部署、管控或分析功能吗？”

---

### [00:55:59] Noah Weiss

**English:**
I think that was it. That's consumer great experience that customers love enough to get their coworkers on and pay for themselves. Then at enterprise companies like having a bunch of different flowers sprouting so that eventually you could roll up an enterprise-wide deal and then was all the tactics. But I think that that was where it started.

**中文翻译:**
我认为就是这样。那是让客户喜爱到愿意拉同事进来并自掏腰包的消费级卓越体验。然后在企业内部，就像是到处都有花朵在萌芽，最终你可以将其汇总成一个全公司范围的交易。剩下的就是战术问题了，但我认为这就是一切的起点。

---

### [00:56:20] Lenny

**English:**
The way you described it at the beginning of make a product that people want to share with their colleagues reminds me of a ... I was just listening to an interview with Seth Godin who's this marketing legend. I think he has a new book. He is on every podcast. He had this really great quote that the products that win are ones that you want to tell your friends about.

**中文翻译:**
你一开始描述的“做一个人们想分享给同事的产品”，让我想起了……我刚听了对营销传奇人物 Seth Godin 的采访。我想他出了一本新书，到处参加播客。他有一句非常棒的名言：最终获胜的产品，是那些你想告诉朋友的产品。

---

### [00:56:37] Lenny

**English:**
It's a really simple concept. Basically, it's like it's word of mouth is how you have to win. But I think that's so true and every successful company I talk to ends up being like, "We just want to build something people want to share with their friends," even if it's growing in some other way, SEO paid feels like that's always at the root of it is you just want to tell your friends about it because you love it. Slack I think is a great example of that.

**中文翻译:**
这是一个非常简单的概念。基本上，口碑就是你获胜的方式。我认为这非常正确，我交谈过的每一家成功的公司最终都会说：“我们只是想做一些人们想分享给朋友的东西。”即使它是通过其他方式（如 SEO 或付费广告）增长的，其根源似乎总是在于：因为你热爱它，所以你想告诉你的朋友。我认为 Slack 就是一个很好的例子。

---

### [00:56:58] Noah Weiss

**English:**
I think that's true. I mean obviously, there are categories of enterprise software that isn't true for in security or ...

**中文翻译:**
我认为确实如此。当然，有些类别的企业软件并非如此，比如安全软件或者……

---

### [00:57:05] Lenny

**English:**
But even that I think if it's an awesome security product you're like, "Hey, you got to check out this century or whatever or sneak."

**中文翻译:**
但即使是那样，我认为如果是一款很棒的安全产品，你也会说：“嘿，你得看看 Sentry 或者 Snyk 之类的。”

---

### [00:57:13] Noah Weiss

**English:**
Yeah. Good friends with Vanta's CEO Christina. I feel like they run those stories where whoever would've thought that a compliance company would be something that people raved about to their other startup friends, like, "Oh, my God. You don't want to deal with SOC's compliance? You got in Vanta. It's amazing."

**中文翻译:**
是的。我和 Vanta 的 CEO Christina 是好朋友。我觉得他们就有这样的故事：谁能想到一家做合规的公司会让人们向其他创业朋友极力推荐，比如：“天哪，你不想处理 SOC 合规问题？用 Vanta 吧，太神奇了。”

---

### [00:57:29] Noah Weiss

**English:**
Yeah. Maybe that is true. I think especially in this day and age where all the marketing acquisition channels have been so saturated, people optimizing so much, I think it's really hard to scale a big enough business if you don't have some amount of word of mouth and customer love driven growth. I think it's hard to scale it on like, "We're going to just play the cat game and in hopes that the numbers work out."

**中文翻译:**
是的，也许确实如此。我认为特别是在营销获客渠道已经如此饱和、人们过度优化的今天，如果没有一定程度的口碑和客户热爱驱动的增长，很难扩大业务规模。很难仅仅依靠“玩流量游戏并寄希望于数字能凑效”来做大规模。

---

### [00:57:51] Lenny

**English:**
I remember Slack rolling out at Airbnb and all the designers getting so excited about it, creating their channels and everyone's just like, "What the hell are they doing as this thing?" Then it did exactly what you're describing just spread. Everyone's just like, "Whoa, this is cool." They're all telling each other that how useful it is to them and spread like crazy.

**中文翻译:**
我记得 Slack 在 Airbnb 推广时，所有的设计师都非常兴奋，创建了各种频道，其他人都在想：“他们用这玩意儿到底在干嘛？”然后它就像你描述的那样传播开了。每个人都觉得：“哇，这太酷了。”他们互相诉说这东西对自己有多有用，然后就像疯了一样传开了。

---

### [00:58:07] Noah Weiss

**English:**
I love that.

**中文翻译:**
我喜欢这个故事。

---

### [00:58:09] Lenny

**English:**
Is there anything else on Slack that you think would be interesting to share in terms of what makes it a successful product team, product business before I move on to another topic?

**中文翻译:**
在转入另一个话题之前，关于 Slack 作为一个成功的产品团队和产品业务，你觉得还有什么有趣的可以分享吗？

---

### [00:58:20] Noah Weiss

**English:**
The other thing I think is maybe a little bit interesting in terms of how we develop product and it's really different and it's changed over time, which is that obviously the easiest person to build for is yourself and the next easiest is people who look almost exactly like you or have similar preferences and sophistication. I think in the early days of Slack, that's basically what we did.

**中文翻译:**
另一件我认为在产品开发方式上很有趣的事情是（它确实非常不同，而且随着时间的推移而改变）：显然，最容易为之构建产品的人是你自己，其次是那些看起来几乎和你一模一样、或者有类似偏好和成熟度的人。我认为在 Slack 的早期，我们基本上就是这么做的。

---

### [00:58:41] Noah Weiss

**English:**
I mean it was really just trying to build for small technologically savvy teams in terms of you could build a pretty big business making a great product for them. Over the years, obviously, that's changed. One of the things I think that we've done, which has worked really well, one obviously is we've figured out how to do experimentation in a SaaS product, which is not always obvious because the metrics are much longer term than you land at a checkout page and then you hit Checkout.

**中文翻译:**
我的意思是，当时真的只是在尝试为技术精湛的小型团队构建产品，为他们做出一款伟大的产品就能建立起相当大的业务。多年来，情况显然发生了变化。我认为我们做对的一件事（效果非常好）是：我们弄清楚了如何在 SaaS 产品中进行实验。这并不总是显而易见的，因为 SaaS 的指标比“进入结算页面然后点击结账”要长期得多。

---

### [00:59:07] Noah Weiss

**English:**
But I think the other thing is we figured out how to scale up getting real customers using Slack in the wilds for new functionality. We have this really robust program that we call our pilot program where we have, I don't know, probably thousands of different customers that have all signed different agreements now where we can actually roll out to progressively larger user bases, because Slack is a multiplayer product.

**中文翻译:**
但另一件事是，我们弄清楚了如何扩大规模，让真实客户在现实场景中使用 Slack 的新功能。我们有一个非常稳健的项目，叫做“试点项目（pilot program）”。我们现在可能有成千上万个签署了不同协议的客户，我们可以向逐渐扩大的用户群推出新功能。因为 Slack 是一款多人协作产品。

---

### [00:59:30] Noah Weiss

**English:**
You often have to roll out real net new functionality to a whole company or whole team because otherwise you can't use huddles by yourself, for example. Then we have a really great program for actually getting feedback from those customers both through Slack connect itself through surveys and this winds up being a lifeblood of feature teams where you can, by the time you actually launch a big net new feature for Slack, have done so much customer feedback from people actually using in the wild to get work done and so much more confidence in what you're building from the metrics and the surveys that we do that you know can't guarantee it's going to be a hit.

**中文翻译:**
你通常必须向整个公司或整个团队推出全新的功能，否则你无法独自使用 huddles。我们有一套非常棒的程序，通过 Slack Connect 本身或调查问卷从这些客户那里获取反馈。这成了功能团队的生命线。当你真正为 Slack 发布一个重大的全新功能时，你已经从那些在现实中用它来完成工作的人那里获得了大量反馈。通过这些指标和调查，你对所构建的东西有了更多的信心。虽然不能保证一定会大获成功。

---

### [01:00:05] Noah Weiss

**English:**
But you can be really confident not because it just worked well internally, which is no longer that predictive, but because it worked well for a thousand different companies, in 50 different countries, in 20 different industries. I think not early on SaaS companies don't need to figure that out, but I think as you grow and as you have a more diverse customer base as you said all these SaaS founders who said, "Hey, you got to keep reestablishing product market fit."

**中文翻译:**
但你可以非常有信心，不是因为内部测试效果好（那已经不再具有预测性），而是因为它在 50 个国家、20 个行业的 1000 家不同公司中都运行良好。我认为早期的 SaaS 公司不需要考虑这些，但随着你的成长和客户群的多样化，就像你说的那些 SaaS 创始人所言：“嘿，你必须不断重新建立产品市场匹配。”

---

### [01:00:31] Noah Weiss

**English:**
I think that is a programmatic way of being able to do that with your product development process. That's pretty interesting.

**中文翻译:**
我认为这是一种在产品开发过程中实现这一目标的程序化方法。这非常有趣。

---

### [01:00:37] Lenny

**English:**
Any tips for how to choose who to include in this group if someone wants to build something like this for themselves?

**中文翻译:**
如果有人想为自己建立这样的群体，关于如何选择加入的人选，你有什么建议吗？

---

### [01:00:43] Noah Weiss

**English:**
I think the two most important things are you want a lot of diversity in terms of industry, company size, location and so on. I think you want to pick people who are actually motivated to want to be part of the development process and have a slightly higher risk tolerance. Not every company wants to actually be beta testing new functionality that might get removed.

**中文翻译:**
我认为最重要的两点是：一是在行业、公司规模、地理位置等方面保持高度的多样性；二是选择那些真正有动力参与开发过程、且风险承受能力稍高的人。并非每家公司都愿意对可能被移除的新功能进行 Beta 测试。

---

### [01:01:05] Noah Weiss

**English:**
Making sure we have this champion network that we built that people who love Slack enough that they're willing to put up with a little bit of pain in that rougher period are willing to have something that they try to use and then we decide actually we're going to kill that feature before we ever ship it to everybody. Diversity and pain tolerance.

**中文翻译:**
我们要确保建立起这个“拥护者网络”，这些人足够热爱 Slack，以至于愿意在产品不成熟的时期忍受一点痛苦，愿意尝试使用某些东西，即使我们最终决定在正式发布前取消该功能。多样性和痛苦承受力，这就是关键。

---

### [01:01:24] Lenny

**English:**
This reminds me of something else, the CTO Stripe shared of how they build new product, which is they pick a couple customers that need a problem solved and they just build it for them essentially and with them and in B2B. Generally, it's a lot easier to build something people really want because they are very motivated for you to solve their problem and they're going to put in the time. You don't need a thousands of people involved, you just need a couple.

**中文翻译:**
这让我想起了 Stripe 的 CTO 分享的他们构建新产品的方式：挑选几个需要解决问题的客户，基本上就是为他们、并与他们一起构建产品。在 B2B 领域，通常更容易做出人们真正想要的东西，因为他们非常有动力让你解决他们的问题，并且愿意投入时间。你不需要成千上万的人参与，只需要几个。

---

### [01:01:46] Noah Weiss

**English:**
Yeah. I definitely think it was one of those things where if you can do it away and they say I can't live without it, the classic not ... Do you like it? Sure. But can you work without this thing? If the answer is definitely not, you've built something that probably a lot of other companies will want to.

**中文翻译:**
是的。我绝对认为，如果你能做到让他们说“我离不开它”，那就成功了。经典的问法不是“你喜欢它吗？”，而是“没有这东西你还能工作吗？”如果答案是“绝对不行”，那么你构建的东西可能很多其他公司也会想要。

---

### [01:02:04] Lenny

**English:**
All right. I'm going to shift to a totally different topic, which could also be its own whole podcast, but let's just see how it goes. You're with this, I'd say famous blog post on product management called The 10 Traits of Great Product Managers. I want to just try to go through this list briefly and just see how it goes. This could be an hour of conversation. But let's just run through it, because I think it'd be useful for people to hear and I think these are all 100% true even though you wrote this number of years ago at this point and let's just see what comes up. Then I have a few follow-up questions on this list.

**中文翻译:**
好的。我要转向一个完全不同的主题，这本身也可以做一期完整的播客，但让我们先试试看。你写过一篇关于产品管理的非常著名的博文，叫《优秀产品经理的 10 个特质》。我想简要地过一遍这个清单。这本来可以聊一个小时，但让我们先快速浏览一下，因为我觉得这对听众很有用。尽管这是你几年前写的，但我认为它们仍然是 100% 正确的。让我们看看会聊出什么，然后我还有几个后续问题。

---

### [01:02:34] Noah Weiss

**English:**
These traits are ... I wrote this other thing, which is the five minutes about product management, which are all the things that people think product management is and why they switch to the job and they're disappointed by. Then I was like, "Let me actually write a positive version of this," which is the things that the job actually is about. It's not a career ladder. It's not the, "Here's the structured interview things that you should interview for."

**中文翻译:**
这些特质是……我还写过另一篇叫《关于产品管理的五分钟》的文章，讲的是人们对产品管理的误解，以及为什么他们转行做这个后会感到失望。然后我想：“让我写一个正面版本吧”，也就是这份工作真正的核心。它不是职业阶梯，也不是“你应该面试的结构化面试题”。

---

### [01:02:56] Noah Weiss

**English:**
But I think it's the actual job of product management, what is it about, what does success look like? I don't think they're really in a particular order in hindsight, but I'll read them in order. Living the future and work backwards I think is very much the idea of as a PM is one thing they're responsible for. It's having a longer-term vision and time horizon. How do you carve out time to not just be what are we doing over the next two weeks.

**中文翻译:**
我认为这是产品管理的真实工作：它是关于什么的？成功是什么样的？现在回想起来，我不认为它们有特定的顺序，但我会按顺序读。第一，**生活在未来并向后推导（Living the future and work backwards）**。我认为这是 PM 负责的一件大事：拥有长期的愿景和时间跨度。你如何挤出时间，而不仅仅是关注“未来两周我们要干什么”？

---

### [01:03:20] Noah Weiss

**English:**
But six months, a year, two years from now, how do you immerse yourself in them and bring ideas back, bring inspiration back to the team.

**中文翻译:**
而是六个月、一年、两年后会怎样？你如何沉浸其中，并将想法和灵感带回给团队？

---

### [01:03:27] Lenny

**English:**
I'm going to just going to throw comments at as you're going through them, just add to them. I love that this is exactly Amazon's approach of work backwards, working backwards process. At Airbnb, this is actually the main thing Brian want pushed everyone to do is just think about the idealized product of a magical world where this is totally solid and then work backwards from that. Then Paul Graham talks about this, too, just live in the future and build it.

**中文翻译:**
在你读的时候，我会穿插一些评论。我喜欢这一点，这正是亚马逊的“逆向工作法（working backwards）”。在 Airbnb，这也是 Brian 推动每个人去做的主线：想象一个魔法世界中完全成熟的理想产品，然后以此为起点向后推导。Paul Graham 也谈过这一点：生活在未来，然后把它造出来。

---

### [01:03:53] Noah Weiss

**English:**
I definitely riffed off at least the Paul Graham thing because I remember reading that essay of he thinks everyone thinks that you can get ideas by, I don't know, sitting with their co-founder laying in Dolores Park looking up at the sky and conjuring up the next unicorn or something. Definitely not how that works. You have to actually immerse yourself in the problem space and try to imagine what the future world looks like and then what's missing for people to get to that future state. Yeah. I agree.

**中文翻译:**
我肯定借鉴了 Paul Graham 的想法，因为我记得读过那篇文章。他认为，大家都以为只要和联合创始人躺在多洛雷斯公园（Dolores Park）仰望天空，就能变出一个独角兽点子。绝对不是那样的。你必须真正沉浸在问题空间中，尝试想象未来的世界是什么样子的，然后思考人们为了达到那个未来状态还缺少什么。是的，我同意。

---

### [01:04:20] Lenny

**English:**
I also saw a great tweet by [inaudible 01:04:21] the other day about how if you're working at a company with good leaders, they're never going to be sad that your vision is too big and too ambitious. If there's some reality to it that often they want that just like, "Let's go. Let's think bigger. How do we change the way we think about the future of all this stuff?"

**中文翻译:**
我前几天还看到一条很棒的推文，大意是：如果你在一家拥有优秀领导者的公司工作，他们绝不会因为你的愿景太大、太有野心而感到难过。只要它有一定的现实基础，他们通常会希望那样，会说：“来吧，想得更大一点。我们如何改变对这一切未来的思考方式？”

---

### [01:04:39] Noah Weiss

**English:**
Yeah. I mean that was when I was at Google, the thing I took away most from any review with Larry and Sergei was they would ask how could we get 100X the scale or how could this work for this, would seem like an outlandish use case but would push the team to think much further into the future. Yeah. I think definitely what the founders always want.

**中文翻译:**
是的。我在 Google 时，从 Larry 和 Sergey 的评审中学到最多的一点就是，他们会问：我们如何实现 100 倍的规模？或者这如何应用于某个看起来很古怪的场景？这会促使团队思考得更远。是的，我认为这绝对是创始人一直想要的。

---

### [01:04:56] Lenny

**English:**
That's what Brian Chesky always said too, just like, "How do we 10X this? What would it take to 10X this idea?

**中文翻译:**
这也是 Brian Chesky 常说的：“我们如何把这个扩大 10 倍？把这个想法扩大 10 倍需要什么？”

---

### [01:05:01] Noah Weiss

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:05:02] Noah Weiss

**English:**
Okay. The second one, which is maybe obvious, but thinking about how do you actually amplify your team? How do you facilitate ideas? How do you create energy? How do you create momentum? A PM role I think can be a little bit unsatisfying if you're useful, where you create things yourself opposed to you are the one who's amplifying what the work that's being created by everyone else is. You have to get into that more of a facilitator mindset.

**中文翻译:**
好的。第二个，可能显而易见，但要思考：**你如何真正放大你的团队（Amplify your team）**？你如何促进想法的产生？你如何创造能量？你如何创造势头？我认为，如果你习惯于自己动手创造东西，而不是去放大别人创造的工作，那么 PM 这个角色可能会让你感到有些不满足。你必须进入一种“引导者（facilitator）”的心态。

---

### [01:05:26] Lenny

**English:**
What I think about here is a lot of teams don't want PMs on their team or don't like PMs or don't think PMs are valuable. What I find is that just means your PMs not good because if you have a good PM, they're just going to help you do the best work of your life. They're going to help you clarify things, prioritize well, unblock you, all that stuff.

**中文翻译:**
我想到的是，很多团队不想要 PM，或者不喜欢 PM，或者认为 PM 没有价值。我发现这通常意味着你的 PM 不够好。因为如果你有一个好的 PM，他们会帮助你完成一生中最出色的工作。他们会帮你理清思路、做好优先级排序、为你扫清障碍，诸如此类。

---

### [01:05:45] Noah Weiss

**English:**
Totally. I wish should find out who wrote that expression early on of PM should be mini-CEOs. I think that's the most dangerous piece of advice ever in the history of product management because I think that is how you end up having PMs who try to act like dictators instead of leaders and facilitators. Because if you're acting like that, yeah, your team can completely reject you and say I never want another PM again.

**中文翻译:**
完全正确。我真想找出是谁最早提出“PM 应该是迷你 CEO”这个说法的。我认为这是产品管理历史上最危险的建议，因为它会导致 PM 试图表现得像独裁者，而不是领导者和引导者。如果你表现成那样，你的团队会完全排斥你，并说“我再也不想要 PM 了”。

---

### [01:06:09] Lenny

**English:**
Yeah. So many UPMs are just like, "I'm finally going to have the power, finally." If they move from engineering or some other role and then they get there like, "Oh, what the hell? Is that to convince everyone of all these things I want to do?"

**中文翻译:**
是的。很多新 PM 会想：“我终于要有权力了，终于。”如果他们是从工程或其他岗位转过来的，到了那儿会发现：“噢，搞什么鬼？我竟然得去说服每个人接受我想做的这些事？”

---

### [01:06:20] Noah Weiss

**English:**
That actually, I'm going to skip in a slightly different direction of the order of this post. But the fifth one that I wrote in there was your job as to facilitate the pace and quality of decision making. That is very different than you are the person who makes all the decisions. In fact, I think one of the things that PM struggled with early on is how do you actually get the team to be able to make high quality decisions quickly without you arbitrarily playing tiebreaker all the time.

**中文翻译:**
实际上，我要跳过博文的顺序，先说第五点：**你的工作是促进决策的速度和质量（Facilitate the pace and quality of decision making）**。这与“你就是那个做所有决定的人”截然不同。事实上，我认为 PM 早期面临的挑战之一是：如何让团队能够快速做出高质量的决策，而不是让你总是武断地充当“平局决胜者”。

---

### [01:06:48] Noah Weiss

**English:**
It's a soft art to be able to do that. But I think that is actually how you have a really healthy team dynamic instead of PM to want to say, "Okay. Now it's my turn to get to make the decisions." It's definitely not what the job is about.

**中文翻译:**
这是一种软技能。但我认为这才是建立健康团队动态的关键，而不是 PM 想着：“好了，现在轮到我做决定了。”这绝对不是这份工作的核心。

---

### [01:07:01] Lenny

**English:**
What that makes me think about is I taught a course on product management at one point that I paused for now of just the core job of a PM is to figure out what's next for every single person on the team. There's this meme or GIF of a dog on a train and he's just laying the tracks as the team is moving forward ahead of them just one step at a time. To do that, this is such an important part of that is just help people make decisions, unblock them.

**中文翻译:**
这让我想起我曾经教过的一门产品管理课程（现在暂停了）：PM 的核心工作就是弄清楚团队中每个人的下一步该做什么。有一个表情包或 GIF，是一只狗在火车上，火车向前开，它就在前面一节一节地铺轨道。为了做到这一点，帮助人们做决定、为他们扫清障碍是非常重要的一部分。

---

### [01:07:24] Noah Weiss

**English:**
Totally. I'll combine two of these together. One is you do have to have impeccable execution. This is more of a baseline thing. But I've never seen a PM who was disorganized or didn't do follow-up or wasn't clear about expectations or timelines. It's not high in Maslow's hierarchy of PM enjoyment. But I do think it's a baseline expectation.

**中文翻译:**
完全同意。我把其中两点结合起来说。一个是：**你必须拥有无可挑剔的执行力（Impeccable execution）**。这更像是一个底线。我从未见过一个杂乱无章、不跟进、或者对预期和时间线模糊不清的 PM。这在 PM 的“马斯洛需求层次”中可能不是最高级的享受，但我认为这是基本要求。

---

### [01:07:47] Noah Weiss

**English:**
The thing I think is more enjoyable and probably the most important thing in the long-term is focusing on impact primarily to the customer experience but also to the business. I think there's that saying growth solves all problems. I think impact solves all PM issues, which is if a team is consistently building things people love and changing the director of the business, everything else is just an input.

**中文翻译:**
我认为更有趣、且从长远来看最重要的一点是：**专注于影响力（Focus on impact）**，主要是对客户体验的影响，但也包括对业务的影响。常言道“增长解决所有问题”，我认为“影响力解决所有 PM 问题”。如果一个团队持续构建人们喜爱的产品并改变业务方向，其他一切都只是投入。

---

### [01:08:16] Noah Weiss

**English:**
I think that focus and understanding as your point about laying the tracks is what direction do you need to go as a team to actually drive that impact? That's probably the single thing that PM can most control.

**中文翻译:**
我认为，正如你提到的“铺设轨道”，这种专注和理解就是：作为一个团队，你需要朝哪个方向努力才能真正产生影响力？这可能是 PM 最能掌控的一件事。

---

### [01:08:28] Lenny

**English:**
I love that. I always recommend exactly that if your career is not going as well as you'd hoped or you're not getting promoted, it's usually you're not delivering impact, whatever that means to the company. It may be moving a metric may mean building great product that the founders really love.

**中文翻译:**
我喜欢这个。我总是建议，如果你的职业发展不如预期，或者没有得到晋升，通常是因为你没有产生影响力（无论这对公司意味着什么）。这可能是推动某个指标，也可能是构建了创始人真正喜爱的伟大产品。

---

### [01:08:43] Lenny

**English:**
Main impact can mean a lot of different things. But it's so true. On the executing impeccably bucket, the way I think about that is as a great PM you need to have this aura of "I've got this." Anytime someone puts something on your plate, it's not going to fall off. You're not going to forget about it. You're not going to let a ball drop that if the more you can create this aura of "I got this," the more responsibility people are going to give you, the more impact you'll end up having, the more people want to work with you and all that.

**中文翻译:**
影响力可以有很多种含义，但这是千真万确的。关于“无可挑剔的执行力”，我的理解是：作为一个优秀的 PM，你需要有一种“我能搞定（I've got this）”的气场。每当有人交给你一件事，它就不会石沉大海。你不会忘记它，不会让它掉在地上。你越能营造这种“我能搞定”的气场，人们就会给你越多的责任，你最终产生的影响力就越大，也就有更多的人想和你一起工作。

---

### [01:09:12] Noah Weiss

**English:**
Yeah. Ben Horowitz was a board member back at Foursquare. I remember he used to have this saying very Yoda of good leaders need to say what they're going to do and then do what they said. If they can't then they need to follow up and explain why. I mean that's like the amendment and I think that is what good execution looks like.

**中文翻译:**
是的。Ben Horowitz 曾是 Foursquare 的董事会成员。我记得他曾说过一句很有哲理的话：优秀的领导者需要“言出必行”。如果做不到，他们需要跟进并解释原因。我认为这就是执行力的真谛。

---

### [01:09:33] Lenny

**English:**
That last point is so important. You may not be able to do all the things on your plate, but just telling people. Hey, I'm not going to get to this thing. Let's reprioritize as such a small thing you could do and really creates that, or if you got this, they're not going to forget about this thing asked you to do.

**中文翻译:**
最后一点非常重要。你可能无法完成手头所有的工作，但只要告诉大家：“嘿，我处理不了这件事，让我们重新排下优先级。”这只是举手之劳，却能真正建立那种信任感，让他们知道你不会忘记他们交代的事。

---

### [01:09:47] Noah Weiss

**English:**
Yeah. You're the shock absorber for the team. You're the thing that builds people's confidence that things are going to be running smoothly and you'll get over the Navajo speed bumps and whatever else. I'll combine two or three of these that are related or just more skills. I said right well. I actually think especially as you get to more senior positions, writing is the only scalable way of having influence on a larger, larger product org.

**中文翻译:**
是的。你是团队的“减震器”。你是建立人们信心、确保事情顺利运行、并跨越各种障碍的关键。我把剩下的两三点相关的技能结合起来说。我提到了**写得好（Write well）**。我实际上认为，特别是当你进入更高级的职位时，写作是向庞大的产品组织施加影响力的唯一可扩展的方式。

---

### [01:10:15] Noah Weiss

**English:**
There's a book called On Writing by Stephen King, which I recommend to literally everybody. Stephen King, you're like ... See he's not maybe the most literary critical acclaimed author, but he's a prolific author who publishes things that people love and tell their friends about and he has a great short book on the practice of writing high-quality, high-volume production.

**中文翻译:**
有一本书叫《写作这回事（On Writing）》，作者是斯蒂芬·金，我向所有人推荐。斯蒂芬·金可能不是那种文学评论界最推崇的作家，但他是一位高产作家，他出版的作品人们非常喜爱并愿意推荐给朋友。关于如何进行高质量、高产量的写作实践，他写了一本非常棒的小书。

---

### [01:10:39] Lenny

**English:**
Before you move on, I'll throw a couple more books that I found useful in my writing. One is actually called On Writing Well. That's funny that they're so similarly titled, which basically every chapter is just another way to cut more from your writing. More and more parts you should cut. Interestingly, I do have a lot of guest posts in my newsletter and I find 90% of the time if I just cut the first paragraph of what they first took a crack at and jumps straight into the thing, immediately gets better. This book talks a lot about that.

**中文翻译:**
在你继续之前，我也推荐几本对我写作很有帮助的书。一本叫《写作法宝（On Writing Well）》，有趣的是书名如此相似。这本书基本上每一章都在教你如何删减文字，删掉越来越多的冗余部分。有趣的是，我的时事通讯中有很多嘉宾投稿，我发现 90% 的情况下，如果我直接删掉他们写的第一段，直接切入正题，文章立刻就会变好。这本书讲了很多这方面的内容。

---

### [01:11:07] Lenny

**English:**
Another book that is amazing for writing better is Nobody Wants to Read Your Shit by the guy that wrote The War of Art, forget his name. But that book is awesome and it's just like nobody wants to read what you're writing. Here's how to maybe make it something people want to read. Then recently I read one called Several Short Sentences or something like that. It's all about just writing short sentences and that helps a lot. There you go. Three more recommendations.

**中文翻译:**
另一本对提高写作水平非常有帮助的书是《没人想读你的烂东西（Nobody Wants to Read Your Shit）》，作者是写《艺术之战》的那个人，我忘了他的名字。但那本书棒极了，它的核心观点就是：没人想读你写的东西，所以这里有几种方法可以让它变得让人想读。最近我还读了一本叫《几个短句（Several Short Sentences）》之类的书，讲的是如何写短句，非常有帮助。好了，又多了三个推荐。

---

### [01:11:32] Noah Weiss

**English:**
Okay. I got to read the last two. I haven't read those, but they sound perfect. Okay. Maybe I'll throw one more. Let's say we talked about this earlier, but actually read this in the post many years ago, is optimizing for the pace of learning and knowing that long-term massive thing that's going to drive impact. I think it can be hard if you're a PM for a feature team. You're part of a big company. I don't know. I'm making this up.

**中文翻译:**
好的，我得去读读最后两本。我还没读过，但听起来很完美。好吧，我再说一个。我们之前谈过这一点，但我多年前就在博文中写过：**针对学习速度进行优化（Optimizing for the pace of learning）**，并明确什么才是能产生长期巨大影响的事情。如果你是一个功能团队的 PM，身处一家大公司，这可能会很难。

---

### [01:11:55] Noah Weiss

**English:**
You're on the AdWords team at Google and you're responsible for the bid input selector or something and probably is a whole team, honestly, now at this point. You've got such a set of blinders on that I think it can be hard to think about what else could this team become, what else could you drive beyond the thing that's right in front of you?

**中文翻译:**
比如你在 Google 的 AdWords 团队，负责出价输入选择器之类的东西，现在这可能已经是一个完整的团队了。你戴着如此沉重的“眼罩”，以至于很难去思考这个团队还能变成什么样，除了眼前的这点事，你还能推动什么？

---

### [01:12:16] Noah Weiss

**English:**
Optimizing for learning, being willing to take those bolder bets, knowing you can be wrong in the short-term, but that you'll learn new levers that will be really fruitful in the long-term. It's a portfolio approach to product, but I think a really important one.

**中文翻译:**
针对学习进行优化，愿意进行那些更大胆的押注，知道自己在短期内可能会犯错，但长远来看你会学到新的杠杆，从而获得丰厚的回报。这是一种产品投资组合的方法，但我认为非常重要。

---

### [01:12:30] Lenny

**English:**
I was just interviewing a product leader at Asana, Paige Costello. We were talking about how she's often the youngest person in the room and often manages people that are much older than her and more experienced than her and asked her just how do you that? How do you succeed in that environment?

**中文翻译:**
我最近采访了 Asana 的产品领导者 Paige Costello。我们聊到她经常是房间里最年轻的人，而且经常管理比她年长得多、经验也丰富得多的人。我问她是怎么做到的？你如何在那种环境下取得成功？

---

### [01:12:46] Lenny

**English:**
What she's found is just being the person that has the answers and the insights in meetings, people obviously run to her like, "Hey, what do you think of this?" Because she just knows what people are going to need. I think that's exactly what you're talking about here is just be the person that knows the most about the problem, the customers, the space.

**中文翻译:**
她发现，只要成为那个在会议中拥有答案和洞察的人，人们自然会跑来问她：“嘿，你觉得这个怎么样？”因为她就是知道人们需要什么。我认为这正是你在这里谈论的：成为那个最了解问题、客户和领域的人。

---

### [01:13:04] Noah Weiss

**English:**
Yeah. Then I'll combine the last two just because I know time. But the combination of ... I wrote data fluency, which is not to say that every PM needs to be a statistician. I mean it's great. I mean you've had a lot of great posts about how to understand some of the basics of experimentation, correlation, causation and statistical significance. That's all great.

**中文翻译:**
是的。考虑到时间关系，我把最后两点结合起来。我写了**数据流利度（Data fluency）**，这并不是说每个 PM 都需要成为统计学家。虽然那也很好，你有很多关于如何理解实验基础、相关性、因果关系和统计显著性的精彩文章。

---

### [01:13:23] Noah Weiss

**English:**
But by data fluency, I think it's more actually what you were just saying, which is you know enough about the insights about your customers that it can then inform making higher likelihood product bets and that data can be quantitative, that data can be survey based, it can be from doing 100 meetings with customers yourself. Those are all types of data inputs to me. Being really fluent and then maybe combining that with great product taste.

**中文翻译:**
但我所说的数据流利度，更多是指你刚才提到的：你对客户的洞察了解得足够多，从而能够指导你做出成功概率更高的产品押注。这些数据可以是定量的，可以是基于调查的，也可以是来自你亲自参加的 100 场客户会议。对我来说，这些都是数据输入。在精通数据的同时，也许还要结合出色的**产品品味（Product taste）**。

---

### [01:13:49] Noah Weiss

**English:**
I know it's a controversial statement now to say that there is taste for product. But I do think in all the love of the frameworks and the analytics and everything else and in the field of product, I think people sometimes lose sight of, "It's a creative field." It's not art on its own. But you could get all the inspiration from art and I actually think there's a lot ... there's a book, I think it's called Creative Selection, I forget the exact name of it, about some of the early iPhone development teams at Apple and working with Steve Jobs there.

**中文翻译:**
我知道现在说产品有“品味”是有争议的。但在对框架、分析和产品领域一切事物的热爱中，我认为人们有时会忽视一点：“这是一个创意领域。”它本身不是艺术，但你可以从艺术中汲取所有灵感。实际上我认为有很多……有一本书叫《创意选择（Creative Selection）》，我忘了确切的名字，讲的是苹果早期 iPhone 开发团队以及与史蒂夫·乔布斯合作的故事。

---

### [01:14:21] Noah Weiss

**English:**
I've never worked at Apple. But I actually think it's the best book I've read about the just iterating creative work of building new products and what it means to have taste, which is to say you've developed some amount of intuition for what people will likely love before you're able to test it. Anyway, I think taste plus fluency and data, that too is a combination, is a pretty powerful combo.

**中文翻译:**
我从未在苹果工作过。但我认为这是我读过的关于构建新产品的创意迭代工作，以及“拥有品味”意味着什么的最好的一本书。所谓品味，就是指在测试之前，你就已经对人们可能喜爱的东西建立了一定的直觉。总之，我认为品味加上数据流利度，这是一个非常强大的组合。

---

### [01:14:48] Lenny

**English:**
Let me ask you just a couple questions about this list before we get to a very exciting lightning round and I can let you go.

**中文翻译:**
在进入非常精彩的闪电轮问答并让你离开之前，我想就这个清单再问你几个问题。

---

### [01:14:55] Noah Weiss

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:14:56] Lenny

**English:**
Of these 10 attributes, say you're a new product manager, if you had to pick two or three that you think are most important to get right and focus on in your early career, which would you say they would be?

**中文翻译:**
在这 10 个特质中，假设你是一名新入行的产品经理，如果你必须挑选两三个你认为在职业生涯早期最重要、最需要做对并专注的特质，你会选哪些？

---

### [01:15:06] Noah Weiss

**English:**
I think for early on in your career, what I would say is getting great at execution. It's a thing that you can most control. Then I think building that news for impact, even if the impact is more local, because that's how you actually will demonstrate momentum and build credibility and then actually do think early on getting really fluent on the data and the research side that you can have insights that you can read back to your team.

**中文翻译:**
我认为在职业生涯早期，我会说要擅长执行。这是你最能掌控的事情。然后，我认为要建立对影响力的敏感度，即使这种影响力是局部的，因为那是你展示势头和建立公信力的方式。此外，早期在数据和研究方面变得非常流利，这样你就能拥有可以反馈给团队的洞察。

---

### [01:15:29] Noah Weiss

**English:**
Those are to me the most slammed up ways of becoming someone who starts to build credibility as a product manager in any organization.

**中文翻译:**
对我来说，这些是在任何组织中开始建立作为产品经理公信力的最稳妥的方式。

---

### [01:15:38] Lenny

**English:**
Awesome. That's what I always tell on new PMs too, is just get really good at execution because that creates that aura of, "Oh, this person's just killing it. They're just shipping on time. People know it's happening. They're hitting dates," things like that.

**中文翻译:**
太棒了。我也总是这样告诉新 PM：只要把执行做得非常好，因为这会营造出一种气场：“噢，这个人太厉害了。他们总是按时发布。大家都知道进展顺利，他们总能按期完成。”

---

### [01:15:48] Noah Weiss

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:15:49] Lenny

**English:**
The last question is just say more of a senior product leader, say, on director. Are there three other attributes you think are ones they should focus on most or maybe the same?

**中文翻译:**
最后一个问题是，对于更资深的产品领导者，比如总监级别，你认为他们最应该关注的三个特质是哪些？还是说和前面一样？

---

### [01:15:59] Noah Weiss

**English:**
Yeah. I mean I think this is where the pace and quality decision making starts to matter a lot more because you're still unresponsible sometimes for teams of teams and you're helping to facilitate high quality decisions, often ones that have a lot of uncertainty or risk or ambiguity. How do you keep the organization unblocked, not just a team moving well.

**中文翻译:**
是的。我认为在这个阶段，“决策的速度和质量”变得重要得多，因为你有时要负责多个团队，你需要帮助促进高质量的决策，而这些决策通常伴随着巨大的不确定性、风险或模糊性。你如何让整个组织保持畅通，而不仅仅是一个团队运行良好？

---

### [01:16:21] Noah Weiss

**English:**
I think the living in the future and working backwards, I think the more senior you get, it's always going to be the product founder who is responsible for the ultimate vision, but you become more responsible for that meeting a longer-term strategy to realize that vision. Becoming just someone who can dedicate more of your time to be out of the fray of the day-to-day and think more about the longer-term strategy that you want to pursue.

**中文翻译:**
我认为还有“生活在未来并向后推导”。你越资深，虽然最终愿景始终由产品创始人负责，但你对制定实现该愿景的长期战略负有更多责任。你要成为那个能抽出更多时间跳出日常琐事，更多思考想要追求的长期战略的人。

---

### [01:16:47] Noah Weiss

**English:**
The last one, and we talked about just earlier, but I think being a really good writer, it is just the highest leverage usage of your time. If you want to influence an organization at least for one that doesn't just spend all day in meetings, but I think it's really hard to dedicate the time to it because you're probably spending most of your day in meetings. It's the antidote to that to scale your ability to influence the product direction and maybe even the principles and how you develop product at a company.

**中文翻译:**
最后一点，我们刚才也聊过，我认为成为一名优秀的写作者是你时间杠杆率最高的使用方式。如果你想影响一个组织（至少是一个不整天开会的组织），写作就是关键。虽然很难抽出时间，因为你可能大部分时间都在开会，但它是扩大你对产品方向、原则甚至公司产品开发方式影响力的良药。

---

### [01:17:17] Lenny

**English:**
Well, with that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
好了，现在进入我们非常精彩的闪电轮问答。我有六个问题要问你。准备好了吗？

---

### [01:17:22] Noah Weiss

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### [01:17:23] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:17:27] Noah Weiss

**English:**
These may not be the most unique, but I will say them, which is Innovator's Dilemma by Clayton Christiansen, whether you're working a large company and you're suffering it or you're working a startup and you're trying to out flank an incumbent, I still do think that and innovative solution, the follow on are the best books on product strategy to read.

**中文翻译:**
这些书可能不是最独特的，但我还是要说：克莱顿·克里斯坦森的《创新者的窘境（Innovator's Dilemma）》。无论你是在大公司深受其苦，还是在初创公司试图包抄现有的巨头，我仍然认为这本书及其续作《创新者的解答》是关于产品战略的最佳读物。

---

### [01:17:47] Noah Weiss

**English:**
If you're moving into more of a leadership or management position, I think Radical Candor by Kim Scott is just incredible and worth everyone reading. Frankly, if you're a PM and you're doing soft influence, I think it's really important. Then the third one, which is maybe a little off the beat of path, there's a book called Leadership in Turbulent Times by Doris Goodwin who's a presidential historian.

**中文翻译:**
如果你正步入领导或管理岗位，我认为金·斯科特的《彻底坦率（Radical Candor）》非常棒，值得每个人阅读。坦率地说，如果你是一名 PM 并且正在进行软性影响，这本书非常重要。第三本可能有点冷门，是总统历史学家多丽丝·古德温写的《动荡时期的领导力（Leadership in Turbulent Times）》。

---

### [01:18:12] Noah Weiss

**English:**
It's this amazing book that looks at four of the most notable presidents and how their leadership style evolved when they were in really critical hard times in their presidency. I just think it's actually the best book about leadership style and how do you evolve and how do you deal with crises, which again is maybe later on in your career. But I love getting inspiration from not just reading books about tech and product and I think that's one of the best ones.

**中文翻译:**
这是一本了不起的书，它研究了四位最著名的总统，以及他们在任期内面临极其艰难的时刻时，其领导风格是如何演变的。我认为这是关于领导风格、如何进化以及如何应对危机的最好的一本书。这可能也是你职业生涯后期会遇到的问题。但我喜欢从技术和产品以外的书籍中获取灵感，我认为这是其中最好的一本。

---

### [01:18:40] Lenny

**English:**
What is a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
你最近非常喜欢的一部电影或电视剧是什么？

---

### [01:18:43] Noah Weiss

**English:**
The obvious answer, which I'm sure many people would say would be Succession. I'm not going to ruin anything for the finale because people haven't seen it all. But the writing, the Shakespearean level drama of it all, it's just incredible and just heart wrenching that you wind up loathing most of the characters. But you can't take yourself out of it.

**中文翻译:**
显而易见的答案（我相信很多人都会说）是《继承之战（Succession）》。我不会剧透大结局，因为有些人还没看完。但它的剧本编写、那种莎士比亚级别的戏剧冲突简直令人惊叹，虽然你最终会讨厌其中的大多数角色，但你却无法自拔。这太揪心了。

---

### [01:19:03] Noah Weiss

**English:**
The one that's maybe less common, and I watched right when we started paternity leave is The Bear, I don't know if you heard about it.

**中文翻译:**
另一部可能没那么大众的，是我刚开始休陪产假时看的《熊家餐馆（The Bear）》，不知道你听说过没有。

---

### [01:19:11] Lenny

**English:**
The restaurants.

**中文翻译:**
讲餐厅的那部。

---

### [01:19:12] Noah Weiss

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:19:13] Lenny

**English:**
Yeah. Seen that. Yeah.

**中文翻译:**
是的，我看过。

---

### [01:19:14] Noah Weiss

**English:**
I'm a sucker for incredible cinematography, just what they do in basically the single room of this restaurant and kitchen and just the piece of it. I think it's just an incredible piece of art. I don't know if it's the best show ever, but it is a really moving, emotionally jarring piece of TV.

**中文翻译:**
我非常迷恋出色的摄影，他们在那间餐厅和厨房的小空间里所展现的一切，以及那种节奏感。我认为它是一件了不起的艺术品。我不确定它是否是史上最好的剧集，但它确实是一部非常动人、在情感上极具冲击力的作品。

---

### [01:19:34] Lenny

**English:**
Also, quite stressful to watch.

**中文翻译:**
而且看的时候压力很大。

---

### [01:19:36] Noah Weiss

**English:**
Very sure. I would not relax to it to go to sleep.

**中文翻译:**
确实。我不会靠看它来放松入睡。

---

### [01:19:39] Lenny

**English:**
But Awesome. Okay. Favorite interview question that you'd like to ask candidates?

**中文翻译:**
太棒了。好的。你最喜欢问应聘者的面试问题是什么？

---

### [01:19:45] Noah Weiss

**English:**
That would depend a lot, I think on obviously, the seniority level and things like that. But I think the more general, and I always love to ask people is what unfair secrets have you learned to improve the velocity and energy level of a product team? When I say unfair or you in secret, I usually mean not something that you probably read on a medium input. But what did you learn? How did you learn it and how does it work and how do you apply it? You also just get amazing interesting bits of inspiration from asking that.

**中文翻译:**
我认为这很大程度上取决于职位的资深程度。但更通用的、我一直喜欢问的问题是：**为了提高产品团队的速度和能量水平，你学到了哪些“不公平的秘密”？**当我提到“不公平”或“秘密”时，我通常指的不是你在 Medium 博客上能读到的东西。而是你真正学到了什么？你是怎么学到的？它是如何运作的？你又是如何应用它的？通过问这个问题，你也能获得很多奇妙有趣的灵感。

---

### [01:20:17] Lenny

**English:**
What is a favorite product you've recently discovered that you love?

**中文翻译:**
你最近发现并喜爱的产品是什么？

---

### [01:20:21] Noah Weiss

**English:**
This will also serve for recommendations for you based on or you've not thread about parenting clients because none of the products I've learned or loved recently have been software. But they're all maybe software enabled. The Nanit, which is a weird name, but it's this AI-enabled camera for basically watching your day as they sleep. It's like incredible, look, because you sleep analytics and really helps you be a less neurotic parent. I would highly recommend it.

**中文翻译:**
这也可以作为给你的建议，基于你还没开始的育儿生活，因为我最近了解或喜爱的产品都不是纯软件，但可能都是由软件驱动的。一个是 Nanit，名字有点怪，但它是一款 AI 驱动的摄像头，主要用于观察宝宝睡觉。它非常神奇，能提供睡眠分析，真的能帮你做一个不那么焦虑的父母。我强烈推荐。

---

### [01:20:48] Noah Weiss

**English:**
The SNOO, which is basically this amazing device that can help soothe your kid when all they need is a little bit of that soothing while they sleep so that you can sleep a little bit more. You can tell the steam here is sleep. The last one is there's this chemical up baby that has this whole elaborate stroller system with interchangeable parts and, honestly, it's just an incredibly well-designed piece of hardware that works in and out of the car.

**中文翻译:**
另一个是 SNOO，它基本上是一个神奇的设备，当孩子睡觉需要一点安抚时，它能帮上忙，这样你就能多睡一会儿。你可以看出这里的主题是“睡眠”。最后一个是 Uppababy，它有一套非常精密的婴儿车系统，零件可以互换。老实说，它是一款设计极其精良的硬件，在车内车外都很好用。

---

### [01:21:16] Noah Weiss

**English:**
Yeah. I think I've re-appreciated really well-designed hard products that are not necessarily hardware from Apple and that has been what baby new parents is about.

**中文翻译:**
是的。我想我重新审视了那些设计精良的硬核产品（不一定是苹果的硬件），这就是新手父母的生活。

---

### [01:21:26] Lenny

**English:**
I have all three. Also, a huge shout-out to the Nanit team who sent me a Nanit and all the stuff around the Nanit. Thank you. I'm not going to name the specific PM who sent it to me, because I don't remember his name off the top of my head, but thank you, Nanit.

**中文翻译:**
这三样我都有。另外，非常感谢 Nanit 团队送给我一台 Nanit 及其周边产品。谢谢。我不点名那位送我礼物的 PM 了，因为我一下子想不起他的名字，但谢谢你，Nanit。

---

### [01:21:41] Noah Weiss

**English:**
Yeah. It turned out there was a whole world of baby tech, which I had no idea. I mean, it makes sense that existed, but you never know about until you're a parent. Now, I'm obsessed.

**中文翻译:**
是的。事实证明有一个完整的“婴儿科技”世界，我以前完全不知道。我的意思是，它的存在很合理，但除非你当了父母，否则你永远不会知道。现在我着迷了。

---

### [01:21:49] Lenny

**English:**
One tip that for Nanit, my wife and I have been playing with different names for our kid and we have been changing his name in the Nanit so that anytime we go into the room it sends us a push, "Hey, there's activity in the room with the names so that we could feel the different names."

**中文翻译:**
关于 Nanit 有个小技巧：我和妻子一直在为孩子尝试不同的名字，我们会在 Nanit 里更改他的名字，这样每当我们走进房间，它就会发来推送：“嘿，[名字] 的房间里有活动”，这样我们就能感受一下不同的名字听起来怎么样。

---

### [01:22:05] Noah Weiss

**English:**
I love that. Yeah. My wife and I did something similar where we had three or four final name contenders and we didn't use the Nanit for. But we literal just picked a week and said, "On Monday we're going to like refer to the future baby by that name for the entire week and give some personification to it." That helped us get down from four to one. Yeah.

**中文翻译:**
我喜欢这个。是的。我和妻子也做了类似的事情，我们有三四个备选名字。我们没用 Nanit，但我们选了一周，说：“从周一开始，我们要用这个名字称呼未来的宝宝一整周，赋予它一些人格化特征。”这帮我们把备选名字从四个减少到了一个。

---

### [01:22:28] Lenny

**English:**
What a wide-ranging set of pieces of advice we got on this podcast. Two more questions. What is something relatively minor you've changed in how you develop product at Slack that has had a lot of impact on your ability to execute?

**中文翻译:**
这期播客我们得到了非常广泛的建议。最后两个问题。在 Slack 开发产品的方式上，你做过哪些相对较小、但对执行能力产生重大影响的改变？

---

### [01:22:38] Noah Weiss

**English:**
By far, the biggest thing, which is more of a cultural shift is that we stopped spending so many cycles on design explorations of static mocks or walkthroughs and said, "How quickly can we get into prototyping the path in real software, even if it's messy and you throw it away," at least for something like Slack. You got to live and touch and smell the software. You can't just look at it. That's been a huge unlock for avoiding spending months on design debates and just getting to, well, how does the software feel? That's what matters.

**中文翻译:**
到目前为止，最大的改变（更多是一种文化转变）是：我们不再把大量精力花在静态原型或演示稿的设计探索上，而是说：“我们能多快在真实软件中进行原型路径测试？即使它很乱，用完就扔。”至少对于 Slack 这样的产品，你必须去生活在其中、触摸它、感受它。你不能只是看着它。这极大地避免了在设计辩论上浪费数月时间，而是直接进入“软件感觉如何？”这才是最重要的。

---

### [01:23:12] Lenny

**English:**
Speaking of Slack, final question, what is your favorite Slack pro tip that people may not be aware of?

**中文翻译:**
说到 Slack，最后一个问题：你最喜欢的、人们可能还不知道的 Slack 高级技巧是什么？

---

### [01:23:19] Noah Weiss

**English:**
I'm going to give two because if someone asks me this, "I'm like, these are the two things that if you're not in love with Slack, you'll fall in love with Slack." The first is obviously you have a sidebar, it can be unruly, but you can customize the sidebar into sections and each of those sections you can have settings like. "Show unread only" or "Sort by recency," or "Sort by alphabetical," whatever it might be. You can collapse the section so you don't see it all at once.

**中文翻译:**
我要给两个，因为如果有人问我这个，我会说：“如果你还没爱上 Slack，这两件事会让你爱上它。”第一，显然你有一个侧边栏，它可能会很乱，但你可以将侧边栏自定义为不同的板块（sections），每个板块都可以有设置，比如“仅显示未读”、“按最近排序”或“按字母顺序排序”等等。你可以折叠板块，这样就不会一次看到所有内容。

---

### [01:23:44] Noah Weiss

**English:**
I think having a well-managed sidebar, which doesn't actually take that long, it's like this amazing thing because then all this inbound is structured in an order and a grouping that fits how you want to view your working life. Customizing the sidebar. The second thing is just use the quick switcher for everything. Just hit Apple K and just start typing and it feels like they're playing a video game, just hopping around channels, people, files, search. Pretty much all the actions you can take are on as well.

**中文翻译:**
我认为拥有一个管理良好的侧边栏（其实花不了多少时间）是一件非常神奇的事情，因为这样所有的信息输入都会按照符合你工作生活视角的顺序和分组进行结构化。自定义侧边栏是第一点。第二点是：万事皆用“快速切换器（Quick Switcher）”。只需按下 Cmd+K（Mac）并开始输入，感觉就像在玩视频游戏，在频道、人员、文件、搜索之间来回穿梭。几乎所有的操作都可以通过它完成。

---

### [01:24:15] Noah Weiss

**English:**
I think most SaaS products now have borrowed that pattern. You can use another software, but it works particularly well in Slack.

**中文翻译:**
我想现在大多数 SaaS 产品都借鉴了这种模式。你可以在其他软件中使用，但在 Slack 中效果特别好。

---

### [01:24:23] Lenny

**English:**
No. I know the last thing you needed was to record a podcast your first week back to work. I so appreciate you making the time. It feels like we're two ships passing in the night from pat leave and to new pat leave. Two final questions. Where can folks find you online if they want to reach out and learn more and how can listeners be useful to you?

**中文翻译:**
Noah，我知道你回到工作的第一周最不需要的就是录制播客。我非常感谢你抽时间出来。感觉我们就像两艘在黑夜中交错的船，一个刚休完假，一个正要去休假。最后两个问题：如果大家想联系你并了解更多信息，可以在哪里找到你？听众们能为你做些什么？

---

### [01:24:39] Noah Weiss

**English:**
I will confess that I haven't used Twitter in months because I was doing digital detox, but still I think @Noah_Weiss is a pretty good place to find me online and whether there or anywhere else, still love to have peoples like Slack feature requests, especially about things that you wish were possible or that would get the rest of your company to join on Slack because you love it, but you can't convince them. Those are always golden nuggets.

**中文翻译:**
我得承认，因为在做“数字排毒”，我已经好几个月没用 Twitter 了。但我觉得 @Noah_Weiss 仍然是一个在线找到我的好地方。无论是在那里还是在其他地方，我仍然非常欢迎大家提出 Slack 的功能需求，特别是那些你希望实现的功能，或者那些能让你公司其他人也加入 Slack 的功能（因为你很爱它，但无法说服他们）。那些反馈总是像金子一样宝贵。

---

### [01:25:04] Lenny

**English:**
Awesome. Noah, thank you so much for being here.

**中文翻译:**
太棒了。Noah，非常感谢你来到这里。

---

### [01:25:06] Noah Weiss

**English:**
Thank you so much for having me.

**中文翻译:**
非常感谢你的邀请。

---

### [01:25:08] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。