# Oji Udezue - 双语对照

# Lenny's Podcast: Oji Udezue - Bilingual Transcript (English-Chinese)

---

### [00:00:00] Oji Udezue

**English:**
Products who try to be viral just for what I call synthetic virality that fail. Because in the end, if you're synthetically viral and people get to the product and it sucks, that's it. Slack wasn't even viral, there was no synthetic virality. Slack couldn't even connect to organizations for the longest time. You could be working on the third floor, and someone using Slack on the fourth floor and you would have no clue, there's no way to share it with them. But what happens when you went to lunch? People are like, "We got Slack and this is amazing." And people on the third floor are like, "Holy shit, when can we get it?" Boom, boom, boom. This is the bedrock of virality. Build a great product that solves a sharp problem.

**中文翻译:**
那些仅仅为了我所说的“人造病毒性”（synthetic virality）而尝试走红的产品最终都会失败。因为归根结底，如果你是靠人造手段走红的，而人们接触到产品后发现它很烂，那就玩完了。Slack 最初甚至都不是病毒式的，它没有任何人造的病毒手段。在很长一段时间里，Slack 甚至无法连接不同的组织。你可能在三楼工作，而四楼有人在使用 Slack，你却完全不知道，也没有办法和他们分享。但当你去吃午饭时发生了什么？人们会说：“我们用了 Slack，这东西太棒了。”然后三楼的人就会惊呼：“天哪，我们什么时候能用上？” 砰，砰，砰。这就是病毒式传播的基石：打造一个能解决尖锐问题的伟大产品。

---

### [00:00:37] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Oji Udezue. Oji has helped build and grow products at Microsoft. He worked on Windows, outlook, Hotmail and inner Explorer, at Atlassian where he was head of product for all their communication tools, at Calendly, where he was chief product officer, at Twitter where he was head of product for creation and conversation. He's currently chief product officer at Typeform, which I am a happy customer of. Oji has one of the broadest and most interesting careers in product, and he's also one of the most thoughtful humans I've met. In our conversation, Oji shares some of his favorite product frameworks and also why you should be really careful applying frameworks at your company. We dig into what he's learned from Calendly and Atlassian and a Typeform on how to do product led growth successfully, and also how to get really sharp with your ICP or ideal customer profile.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在打造和增长当今最成功产品过程中获得的宝贵经验。今天的嘉宾是 Oji Udezue。Oji 曾在微软参与打造和增长产品，包括 Windows、Outlook、Hotmail 和 Internet Explorer；在 Atlassian 担任过所有沟通工具的产品负责人；在 Calendly 担任过首席产品官；在 Twitter 担任过创作与对话产品负责人。他目前是 Typeform 的首席产品官，而我正是 Typeform 的忠实用户。Oji 拥有产品领域最广泛且最有趣的职业生涯之一，他也是我见过的最有思想的人之一。在我们的对话中，Oji 分享了他最喜欢的一些产品框架，以及为什么在公司应用框架时要非常小心。我们深入探讨了他在 Calendly、Atlassian 和 Typeform 学到的关于如何成功实施产品驱动增长（PLG）的经验，以及如何精准定义你的 ICP（理想客户画像）。

---

### [00:01:31] Lenny

**English:**
Also, how to increase your products virality and a concept called forest time, which I love. And even his favorite Nigerian food, which I am currently on the hunt for. With that, I bring you Oji Udezue after a short word from our sponsors.

**中文翻译:**
此外，我们还聊到了如何增加产品的病毒性，以及一个我非常喜欢的概念——“森林时间”（forest time）。甚至还聊到了他最喜欢的尼日利亚美食，我现在正到处找这种吃的。在听完赞助商的简短介绍后，让我们正式欢迎 Oji Udezue。

---

### [00:01:44] Lenny (Sponsor Message)

**English:**
You fell in love with building products for a reason, but sometimes the day-to-day reality is a little different than you imagined. Instead of dreaming up big ideas, talking to customers and crafting a strategy, you're drowning in spreadsheets and roadmap updates, and you're spending your days basically putting out fires. A better way is possible. Introducing Jira Product Discovery, the new prioritization and road mapping tool built for product teams by Atlassian. With Jira Product Discovery, you can gather all your product ideas and insights in one place and prioritize confidently, finally replacing those endless spreadsheets. Create and share custom product roadmaps with any stakeholder in seconds. And it's all built on Jira where your engineering teams already working, so true collaboration is finally possible. Great products are built by great teams, not just engineers, sales, support, leadership, even Greg from finance. Anyone that you want can contribute ideas, feedback, and insights in Jira Product Discovery for free, no catch. And it's only $10 a month for you. Say goodbye to your spreadsheets and the never ending alignment efforts. The old way of doing product management is over. Rediscover what's possible with Jira Product Discovery. Try for free at atlassian.com/lenny.

**中文翻译:**
你爱上打造产品是有原因的，但有时日常现实与你的想象略有不同。你并没有在构思伟大的创意、与客户交谈或制定战略，而是淹没在电子表格和路线图更新中，整天基本上都在“救火”。其实有更好的方法。向你介绍 Jira Product Discovery，这是 Atlassian 为产品团队打造的全新优先级排序和路线图工具。通过 Jira Product Discovery，你可以将所有的产品创意和洞察集中在一处，并充满信心地确定优先级，最终取代那些没完没了的电子表格。只需几秒钟即可创建并与任何利益相关者分享定制的产品路线图。它完全构建在 Jira 之上，而你的工程团队已经在那里工作了，因此真正的协作终于成为可能。伟大的产品是由伟大的团队打造的，不仅仅是工程师，还包括销售、支持、领导层，甚至是财务部的 Greg。你想要的任何人都可以免费在 Jira Product Discovery 中贡献创意、反馈和洞察，没有任何限制。而你每月只需支付 10 美元。告别你的电子表格和永无止境的对齐工作吧。旧的产品管理方式已经结束。通过 Jira Product Discovery 重新发现无限可能。在 atlassian.com/lenny 免费试用。

---

### [00:03:01] Lenny

**English:**
Oji, Thank you so much for being here and welcome to the podcast.

**中文翻译:**
Oji，非常感谢你能来，欢迎来到我们的播客。

---

### [00:03:12] Oji Udezue

**English:**
Thank you, Lenny. It's a pleasure to be here.

**中文翻译:**
谢谢你，Lenny。很高兴能来到这里。

---

### [00:03:14] Lenny

**English:**
It's my pleasure. You've been a PM and a product leader in so many amazing and also just very different companies, all with very different approaches to product and growth. And I think you have this very rare broad perspective on what works in product and growth across a lot of different ways of doing it. And so I have a bunch of questions for you. I hope you came ready for that.

**中文翻译:**
这是我的荣幸。你曾在这么多出色且风格迥异的公司担任过产品经理和产品领导者，这些公司在产品和增长方面的方法各不相同。我认为你拥有一种非常罕见的广阔视角，能够洞察在各种不同模式下，产品和增长中哪些是真正有效的。所以我为你准备了一堆问题，希望你已经准备好了。

---

### [00:03:34] Oji Udezue

**English:**
I am ready.

**中文翻译:**
我准备好了。

---

### [00:03:35] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:03:36] Oji Udezue

**English:**
Yes, sir.

**中文翻译:**
没问题。

---

### [00:03:37] Lenny

**English:**
I love it. Okay, so I want to start with frameworks. You've written and shared a bunch of really interesting frameworks for how to think about product and growth, and so I just want to dig into a couple of them. And one of them is around how to find big B2B SaaS ideas and it's around finding the right workflow. Could you just share this framework and also just how founders and also investors can use this idea to find big ideas?

**中文翻译:**
太棒了。我想从“框架”开始聊起。你写过并分享过很多关于如何思考产品和增长的有趣框架，我想深入探讨其中的几个。其中一个是关于如何寻找大型 B2B SaaS 创意，核心是寻找正确的工作流（workflow）。你能分享一下这个框架吗？以及创始人、投资者如何利用这个想法来发现伟大的创意？

---

### [00:04:01] Oji Udezue

**English:**
Thank you. So I think you're referring to where do you fish to find a unicorn.

**中文翻译:**
谢谢。我想你指的是“去哪里钓到独角兽”那个话题。

---

### [00:04:05] Lenny

**English:**
That's it.

**中文翻译:**
没错。

---

### [00:04:06] Oji Udezue

**English:**
And the thing behind that is people can find that on Substack and the Medium, my writings. But the premise is that there's a lot of risk in building startups, and the last decade of product management and startups has really focused on the method of building software and companies. We talk about the lean approach, we talk about fail fast, [inaudible 00:04:28] and so on and so forth. And I think that that was a necessary phase for us because a lot of innovation was just the ideas of founders unvalidated by customers, and we needed this inflection point in our discipline. People need to understand though that customer science is not the solution to everything otherwise OpenAI will never have done anything. It's also innovation. And so the problem space and the solutions to the problems space is still a big driver of success in building software companies.

**中文翻译:**
关于这个，大家可以在我的 Substack 和 Medium 文章中找到。其前提是，创建初创公司充满风险，而过去十年的产品管理和创业界非常关注构建软件和公司的方法论。我们谈论精益方法（lean approach）、快速失败（fail fast）等等。我认为那是我们必须经历的一个阶段，因为以前很多创新只是创始人未经客户验证的想法，我们需要学科上的这个转折点。但人们也需要明白，客户科学（customer science）并不是万能药，否则 OpenAI 永远不会做出任何东西。创新同样重要。因此，问题空间（problem space）以及针对该空间的解决方案，仍然是构建软件公司成功的核心驱动力。

---

### [00:05:03] Oji Udezue

**English:**
What problem are you really solving? And if you believe that the problem space is key, so what problems will predict success? In B2B SaaS especially, which is much easier to circumscribe is where I start to think about, look, how do you tell from the beginning? Because an investor as well as an operator. Now to segment this space, I think of two dimensions. One is how many departments in the company does the workflow you're trying to solve apply to? Is it just a few or is it all of them? And the second is how intense or how frequent is the workflow executed? Is it daily? Is it weekly? Is it three times a week? And so on and so forth. Now if you draw a nice quadrant of these two things, then you can start to have some predictive power. Things that are useful in every department I call every one workflows, like things like collaboration, like Slack, email, calendaring, workflows, social knowledge and Notion and so on and so forth.

**中文翻译:**
你到底在解决什么问题？如果你相信问题空间是关键，那么什么样的问题能预示成功？特别是在 B2B SaaS 领域，它的界限更容易划定。我开始思考，作为投资者和运营者，如何从一开始就做出判断？为了细分这个领域，我考虑两个维度。第一，你试图解决的工作流适用于公司里的多少个部门？是只有几个，还是所有部门？第二，该工作流执行的强度或频率如何？是每天、每周，还是每周三次？如果你把这两点画成一个象限图，你就能获得一些预测能力。那些对每个部门都有用的东西，我称之为“全员工作流”（everyone workflows），比如协作工具 Slack、电子邮件、日历、社交知识库 Notion 等等。

---

### [00:06:04] Oji Udezue

**English:**
And then things that apply to single departments, I call niche and that's what I call niche. And then the intensity is about frequency. A month is not infrequent, daily is super frequent. If you divide the market or the enterprise into frequency and into how broad the workflow is, you can actually have predictive power. And what I found by looking at the biggest company is public and private in each quadrant was that every one frequent workflows intuitively are the most profitable to work on, but also the hardest to get into because they're dominated by Microsoft and Google and very, very large companies. For example, one of my friends is the CEO of Coda. And so this is interesting, because he's in that space, for him to think about.

**中文翻译:**
而那些仅适用于单个部门的东西，我称之为“利基”（niche）。强度则是指频率。一个月一次不算频繁，每天一次则是超高频。如果你根据频率和工作流的广度来划分市场或企业需求，你就能拥有预测能力。通过观察每个象限中最大的上市和私有公司，我发现“全员高频工作流”直觉上是最赚钱的，但也是最难进入的，因为它们被微软、谷歌等巨头垄断。例如，我的一个朋友是 Coda 的 CEO，这对他来说很有趣，因为他正处于那个竞争激烈的领域。

---

### [00:06:58] Oji Udezue

**English:**
And then the place where B2B SaaS really thrives is niche workflows that are highly frequent. High ni is what I call it, high frequency niche. And then there are the other two quadrants that are a bit more challenging. And then you have to figure out how to navigate your way into one of the other two. If you are in one of the top two quadrants, high ni and high everyone and you solve a really important problem, workflow problem, you can probably turn into a billion-dollar company. If you do the other two, there's some challenges that you have to go through. And the framework talks about how you should navigate those places into success. And I think it's very important because if this is true, and by the way, like I said, I did some validation on it, founders can start to, before they invest years, start to think about what probability of success is. And if you're an investor like me or VC, you can start to think about how you deploy your money.

**中文翻译:**
B2B SaaS 真正蓬勃发展的地方是“高频利基工作流”（high frequency niche），我简称为“High Ni”。至于另外两个象限，挑战会更大一些，你必须想办法向那两个优势象限靠拢。如果你处于上方两个象限（高频利基或高频全员），并且解决了一个非常重要的工作流问题，你很可能成为一家估值十亿美元的公司。如果你在另外两个象限，你必须克服重重挑战。这个框架讨论了你该如何从这些位置走向成功。我认为这非常重要，因为如果这是真的（顺便说一下，我对此做过验证），创始人在投入多年心血之前，就可以开始思考成功的概率。如果你像我一样是投资者或 VC，你也可以据此思考如何配置资金。

---

### [00:07:57] Lenny

**English:**
What are examples of companies in each of those quadrants? If you can frame this and I don't know if you have this in your head already.

**中文翻译:**
每个象限中都有哪些代表性公司？如果你脑子里已经有这些例子的话，能不能举几个？

---

### [00:08:03] Oji Udezue

**English:**
High frequency everyone workflows tend to be things that are done by the doorman to the CEO. So it's email, it's collaboration, it is writing, it is math, all the basic things. At Atlassian, we spend a lot of time thinking about this. So Word, we've had word processing forever in the workspace. Things like Notion and Confluence are huge as sort of evolution of that, Slack, email. Companies in that space, Google, Microsoft, Atlassian, et cetera. And the high ni, which is high frequency niche, you have things like Jira, you have things like tools for recruiters, you have martech, you have sales tech.

**中文翻译:**
“高频全员工作流”往往是上至 CEO 下至门卫都要做的事情。比如邮件、协作、写作、算术，所有基础工作。在 Atlassian，我们花了很多时间思考这个问题。比如 Word，办公空间里永远需要文字处理。Notion 和 Confluence 是这类工具的巨大演进，还有 Slack 和邮件。这个领域的公司有谷歌、微软、Atlassian 等。而在“High Ni”（高频利基）领域，有 Jira、招聘工具、营销技术（martech）、销售技术（sales tech）等。

---

### [00:08:49] Oji Udezue

**English:**
And we know the companies behind them, Atlassian, Salesforce, so on and so forth. And then in the low frequency everyone, you have things like maybe form tools. And actually, they're not that many of them, low frequency everyone or even expense. Actually, the best expensing. Not everyone does it all the time, but everyone essentially has to do some of it, mostly, at least a lot of people. And then there's a low frequency niche, which is particular department. So planning, which is done by FPNA, but done infrequently, things like that.

**中文翻译:**
我们知道这些背后的公司，比如 Atlassian、Salesforce 等等。在“低频全员”象限，可能有表单工具。实际上这类工具并不多，低频全员的例子还包括报销工具。虽然不是每个人一直都在报销，但基本上每个人（至少很多人）都必须做这件事。最后是“低频利基”，针对特定部门。比如财务规划（FP&A）做的规划工作，虽然很重要但频率不高，诸如此类。

---

### [00:09:30] Lenny

**English:**
How frequent is frequent in your experience? Does it have to be once a week at least? What do you think is that minimum bar?

**中文翻译:**
根据你的经验，“高频”到底有多频？必须至少每周一次吗？你认为最低门槛是什么？

---

### [00:09:39] Oji Udezue

**English:**
Frequent is every day really or multiple times a week. Infrequent starts to be like two times a week, once a month. And of course there's a big interregnum in the middle of that.

**中文翻译:**
“高频”实际上是指每天或每周多次。“低频”则是指每周两次、每月一次这种。当然，中间还有很大的灰色地带。

---

### [00:09:51] Lenny

**English:**
It's interesting that there are examples of companies that succeeded in those lower quadrants of infrequent, say the expensing use case. Do you have a sense of what it takes to win there? Because I imagine most startups are in that area, and I imagine founders are like, what can we do to win still?

**中文翻译:**
很有意思的是，在那些低频的下部象限中也有成功的公司，比如报销场景。你觉得在那个领域获胜需要什么？因为我猜大多数初创公司都处于那个区域，创始人们肯定在想：我们该怎么做才能赢？

---

### [00:10:05] Oji Udezue

**English:**
Well, this isn't a static framework in the sense that companies are not destined to be one of these things. The essence of strategy is to navigate from the curve of travel is essentially go from the lower to the higher. Atlassian is trying to go from high niche to high everyone with Confluence and with all the tools that they have. People below are trying to get into the high frequency niche by focusing on their core customer. So what it looks like in say low frequency everyone workflows, something like that is, well, if some people are using it infrequently, but they must use it, well that's a good thing. But then maybe you provide a module that is used by the finance department every day, and so suddenly you're moving into the high frequency everyone workflow. So it's about finding a part of the organization that considers this mission-critical and then solving their problems beyond the problems for everyone for example, in that quadrant.

**中文翻译:**
嗯，这并不是一个静态的框架，公司并不是注定只能待在某个位置。战略的本质是规划路径，基本上就是从低处向高处迁移。Atlassian 正试图通过 Confluence 和他们拥有的所有工具，从“高频利基”转向“高频全员”。处于下方的公司则试图通过专注于核心客户进入“高频利基”。比如在“低频全员”工作流中，如果人们虽然用得少但必须用，那是好事。但接着你可能会提供一个财务部门每天都要用的模块，突然间你就进入了高频领域。所以关键在于找到组织中认为这项工作至关重要的部分，然后在解决全员问题的基础上，进一步解决他们的特定痛点。

---

### [00:11:08] Lenny

**English:**
Is there an example that comes to mind of either at Calendly or Typeform or Atlassian where you pushed it further up the frequency direction or the everyone direction?

**中文翻译:**
在 Calendly、Typeform 或 Atlassian，有没有哪个例子是你把产品推向更高频或更全员的方向的？

---

### [00:11:17] Oji Udezue

**English:**
For example, at Typeform, now this is real for me, Typeform technically is low frequency niche or low frequency everyone, depending on how easy it is to use and how it surrounds the customer. And one of the things that I'm trying to do as part of product strategy is to move it into high frequency niche, high ni, which is a very productive place to be. So for marketers, for salespeople, I want to make sure that they think of us first. And because we are particularly good at customer facing interactions, if they think that we are the way to win new business and to make money, then a portion of our audience, not every single one of them will consider us high ni. And I think expanding that foothold is the way to navigate a business like that. You can see that with Qualtrics, you can see that with SurveyMonkey. Lots of companies are thinking about how to further unbundle that market for a very, very specific kind of customer. And that is what they're trying to do. They're trying to hit the high ni, even for that more generic workflow.

**中文翻译:**
以 Typeform 为例，这对我来说非常现实。从技术上讲，Typeform 属于“低频利基”或“低频全员”，这取决于它的易用性以及它如何围绕客户。我作为产品战略的一部分，正在尝试做的一件事就是将其推向“高频利基”（High Ni），那是一个非常有产出的位置。对于营销人员和销售人员，我希望确保他们首先想到我们。因为我们特别擅长处理面向客户的交互，如果他们认为我们是赢得新业务和赚钱的手段，那么一部分受众（虽然不是全部）就会把我们视为“高频利基”工具。我认为扩大这个立足点是经营这类业务的方式。你可以在 Qualtrics 或 SurveyMonkey 身上看到这一点。很多公司都在思考如何针对非常特定的客户进一步拆分市场。即使是通用的工作流，他们也在努力切入“高频利基”点。

---

### [00:12:27] Lenny

**English:**
That's an awesome example. You also have this framework that I think you call the zone of benefit, which is around how much better does your solution have to be than the status quo? A lot of people are like, "Hey, look at this product, it's better than what you have now." And usually people are like, "Ah, whatever. It's good enough." And you've had some insights on just how much better it needs to be for people to care. Can you share that?

**中文翻译:**
这是一个很棒的例子。你还有一个框架，我记得叫“获益区”（zone of benefit），它是关于你的解决方案必须比现状好多少。很多人会说：“嘿，看这个产品，它比你现在用的好。”但通常人们的反应是：“啊，随便吧，现在的也够用了。”关于产品需要好到什么程度才能让人们在意，你有一些见解。能分享一下吗？

---

### [00:12:45] Oji Udezue

**English:**
Honestly, the reason I like being a product manager is on any given day, I'm drawing from anthropology, sociology, behavioral economics, leadership, communication skills. I'm trained, I have a master's in engineering, so I'm an engineer as well. I've done marketing and sales, so really pulling from so many things. And the reason I talk about the zone of benefit is ultimately what we're trying to do is impedance match technology to humans. That's it. If you really think about it, that's one essence of what we're trying to do. So the zone of benefit works as a framework because people will not pay for things that don't either really shrink the workflow that they're doing or doesn't give them superpower. So the same amount of time, but twice as much output. But the most important thing is that it has to be noticeable.

**中文翻译:**
老实说，我喜欢当产品经理的原因是，在任何一天，我都在借鉴人类学、社会学、行为经济学、领导力和沟通技巧。我受过工程学硕士培训，所以我也是一名工程师。我也做过营销和销售，所以真的是博采众长。我谈论“获益区”的原因是，归根结底，我们试图做的是让技术与人类进行“阻抗匹配”（impedance match）。就是这样。如果你仔细想想，这就是我们工作的本质。获益区作为一个框架之所以有效，是因为如果一个东西不能真正缩减工作流，或者不能给人带来“超能力”（比如同样的时间，产出翻倍），人们是不会为此买单的。但最重要的一点是，这种提升必须是显而易见的。

---

### [00:13:39] Oji Udezue

**English:**
If you do something 20% better, often people just around you, just as a human, people don't notice. And so for a product to make a difference, it has to be at least two, three more X for people to say, "You know what? This is offering enough value for me to maybe make a switch in cost," and so on and so forth. And it really comes down to look, economic theory tells us that people work for leisure, they work enough to afford their leisure. It's sort of broad, and I know some people don't necessarily do that. Especially in the tech industry, people just love to work. But that is really it, when you think about eight billion people on the planet. And there's a lot of benefit really hones in on the fact that if you're going to help me work less, make about the same amount of money, then for me to notice you, you have to accelerate me by three times for me to care.

**中文翻译:**
如果你把某件事做得好 20%，通常周围的人（作为普通人）是察觉不到的。因此，一个产品要想产生影响，必须至少提升 2 到 3 倍，人们才会说：“你知道吗？这提供了足够的价值，值得我承担切换成本。”这其实可以归结为：经济理论告诉我们，人们工作是为了休闲，他们工作到足以负担得起休闲为止。这虽然有点宽泛，而且我知道有些人不一定如此（特别是在科技行业，人们就是热爱工作）。但考虑到全球 80 亿人，事实确实如此。获益区的核心在于：如果你打算帮我减少工作量，同时赚到同样多的钱，那么为了让我注意到你，你必须让我效率提升 3 倍，我才会真正在意。

---

### [00:14:36] Lenny

**English:**
Okay, awesome. So three times. So the idea there is you should feel like this is three times more productive in the thing that I'm trying to do or saves me three times, I don't know, I do it three times faster.

**中文翻译:**
好的，太棒了。所以是 3 倍。也就是说，我应该感觉到在我尝试做的事情上，效率提高了 3 倍，或者节省了 3 倍的时间，或者我做这件事的速度快了 3 倍。

---

### [00:14:44] Oji Udezue

**English:**
Yeah, that's when people actually feel it and they feel it enough where they part with money.

**中文翻译:**
是的，只有到那个程度，人们才会真正感受到，并愿意为此掏钱。

---

### [00:14:49] Lenny

**English:**
Awesome. And I think what's cool about this is it helps you identify the ICP for your product if you're working a startup or even a new product within an existing product to figure out who exactly is going to most benefit from this. Is that part of this?

**中文翻译:**
太棒了。我觉得这个框架最酷的地方在于，无论你是在初创公司工作，还是在现有产品中开发新功能，它都能帮你识别产品的 ICP（理想客户画像），找出到底谁能从中获益最多。这是其中的一部分吗？

---

### [00:15:02] Oji Udezue

**English:**
Yes, yes. Your best customers aren't price sensitive for what you're shooting for because they get it. They fundamentally understand it. So yes, when you're shooting for ICPs, now every startup has marketing problems getting an audience problem. But once you start getting a decent audience, over 100 people or more, you should start to notice the people who are like, "You know what? This, I really care about this." And that starts to tell you a little bit about who's your target audience.

**中文翻译:**
没错。你最好的客户对你追求的目标并不敏感，因为他们“懂”。他们从根本上理解它的价值。所以是的，在寻找 ICP 时，虽然每个初创公司都有营销和获取受众的问题，但一旦你拥有了一定规模的受众（比如 100 人以上），你就应该开始注意到那些说“你知道吗？我真的很在意这个”的人。这就能告诉你谁才是你的目标受众。

---

### [00:15:33] Lenny

**English:**
Would you be up for sharing the ICP of some of the companies you worked at? Just to give people a sense of what would be a good ICP.

**中文翻译:**
你愿意分享一下你工作过的一些公司的 ICP 吗？好让大家对什么是“好的 ICP”有个概念。

---

### [00:15:40] Oji Udezue

**English:**
I think for Atlassian, it's really kind of obvious. It's developers mostly. But it's tech teams writ large because the fundamental of an R and D team is building stuff. And Jira helps the engineers who actually build stuff to track what they do and to give visibility to it so that they can be valuable to the organization. So that is incontroversial. So the ICP is really clear and have been clear for Atlassian for a very long time. Calendly is this weird company where people don't see all the value. People think it's just casual scheduling. But really the people who care about scheduling the most, and I don't mean calendaring. Calendaring is very different from scheduling.

**中文翻译:**
对于 Atlassian 来说，这其实挺明显的。主要是开发者，但广义上是整个技术团队，因为研发团队的核心就是“造东西”。Jira 帮助真正造东西的工程师跟踪他们的工作并提高可见性，从而体现他们对组织的价值。这是毫无争议的，所以 Atlassian 的 ICP 非常清晰，而且已经清晰很久了。Calendly 是一家很奇特的公司，人们往往看不到它的全部价值。大家觉得它只是随意的日程安排。但真正最在意“调度”（scheduling）的人——我指的不是“日历管理”（calendaring），这两者区别很大。

---

### [00:16:25] Oji Udezue

**English:**
The people who care about scheduling the most are salespeople because it's the lifeblood of them earning money and marketers, because it's the lifeblood of them learning about their customer. Recruiters, because it's the lifeblood of them attracting and scheduling the people that they need to do their job. So Calendly's ICPs were people who were scheduling with people who were not in the organization for some business reason. Typeform is marketers mostly because Typeform exists to make the web talkative, to make it more human. And with Typeform, you can brand that conversation and actually make it conversational because one question at a time, the beautiful design. And so marketers feel like we help their websites talk to each other. Product people think we help their web apps talk to people they care about, UX people feel the same way. So those are some, I think the interesting thing is Twitter.

**中文翻译:**
最在意调度的人是销售人员，因为那是他们赚钱的命脉；还有营销人员，因为那是他们了解客户的命脉。招聘人员也是，因为那是他们吸引和安排人才的命脉。所以 Calendly 的 ICP 是那些出于某种业务原因，需要与组织外部人员进行调度的人。Typeform 的 ICP 主要是营销人员，因为 Typeform 的存在是为了让网页变得“健谈”，更具人性化。通过 Typeform，你可以为对话打上品牌烙印，并使其真正具有对话感（一次一个问题，精美的设计）。营销人员觉得我们帮他们的网站与用户交流；产品人员觉得我们帮他们的 Web 应用与关心的用户交流；UX 人员也有同感。这些是一些例子，我觉得最有趣的是 Twitter。

---

### [00:17:27] Lenny

**English:**
I was going to ask what the ICP for Twitter might be, still.

**中文翻译:**
我正想问 Twitter 的 ICP 到底是什么，现在依然如此。

---

### [00:17:33] Oji Udezue

**English:**
So Twitter is actually more fun in terms of ICP because first of all, I'll talk about the things that's not obvious about Twitter. 30% of Twitter's customer base were unseen, they were media organizations, people like the NFL, the NBA, HBO, who wanted their content to reach more people, to be in conversational spaces. And they were essentially business customers and not seen in the conversation pool, it's not obvious. But we interacted with them all the time and we rev shared ads for their videos, because we're making content all the time. And so Twitter was a way to extend the monetization of that content, that inventory that already had. But when you go to the consumer side of Twitter, who was the ICP?

**中文翻译:**
Twitter 的 ICP 其实更有趣。首先，我说说 Twitter 那些不为人知的一面。Twitter 30% 的客户群是“隐形”的，他们是媒体机构，比如 NFL、NBA、HBO，他们希望自己的内容触达更多人，进入对话空间。他们本质上是企业客户，在普通的对话池中看不出来，并不明显。但我们一直与他们互动，并为他们的视频进行广告分成，因为我们一直在产出内容。所以 Twitter 是扩展这些已有内容库存变现的一种方式。但当你转向 Twitter 的消费者端，谁才是 ICP 呢？

---

### [00:18:25] Oji Udezue

**English:**
Well, actually Twitter understood, and this is sort of reflected in what Elon Musk is doing these days, that he doesn't seem to understand. And if you ask anyone who was at Twitter, you'll see the understanding in their eyes and the fact that he doesn't understand, because Twitter's ICP is bifurcated. On one side, it is the most accomplished people in the world, the people who have something to say. This is why there's neuro Twitter, there's weather Twitter, there is cancer Twitter, and so on and so forth. In fact, if something breaks, some new innovation happens in the world, it probably breaks on Twitter before it breaks anywhere else, because these are people in informal communities following each other and sharing their results.

**中文翻译:**
事实上，Twitter 内部很清楚这一点，而这在埃隆·马斯克最近的所作所为中有所体现——他似乎并不理解。如果你问任何曾在 Twitter 工作过的人，你会从他们的眼神中看到那种默契，以及对他不理解这一点的无奈。因为 Twitter 的 ICP 是分叉的。一端是世界上最有成就的人，那些有话要说的人。这就是为什么会有神经科学 Twitter、天气 Twitter、癌症研究 Twitter 等等。事实上，如果世界上发生了什么重大突破或创新，它很可能在其他任何地方出现之前，先在 Twitter 上爆发，因为这些非正式社区的人在互相关注并分享成果。

---

### [00:19:10] Oji Udezue

**English:**
So basically there's this big circle of experts. We break down into celebrities, we break down into luminaries, leaders and so on and so forth. That's the ICP. Now how does Twitter work? These people attract the other 90% who listen to these people, but also they need to create their own informal communities around the things they're passionate about and have this mimetic relationship with the luminaries and the experts. And that is sort of the planet Twitter, experts on one side, humans who need to connect with the things they're passionate about, the people who are like them, that is the ICP of Twitter, the people who have something to say in those two categories.

**中文翻译:**
所以基本上这里有一个巨大的专家圈。我们可以将其细分为名人、泰斗、领导者等等。这就是 ICP。那么 Twitter 是如何运作的呢？这些人吸引了另外 90% 听他们说话的人，但这些人也需要围绕自己热衷的事物建立非正式社区，并与那些泰斗和专家保持一种“模仿学习”的关系。这就是“Twitter 星球”：一端是专家，另一端是需要与热衷事物及同类人建立联系的普通人。这就是 Twitter 的 ICP——在这两个类别中“有话要说”的人。

---

### [00:19:58] Lenny

**English:**
Are you happy you're not working on Twitter anymore?

**中文翻译:**
你庆幸自己不再在 Twitter 工作了吗？

---

### [00:20:00] Oji Udezue

**English:**
I am ecstatic, I'm ecstatic. It seems like such a shitshow, no shade on anything or anyone purposely. But look, what's happening is evident. So I don't think I have much to say about that.

**中文翻译:**
我简直欣喜若狂。那里现在看起来就像一场闹剧，我不是故意要针对谁或什么事。但你看，正在发生的一切显而易见。所以我觉得我没什么好说的了。

---

### [00:20:18] Lenny

**English:**
Yeah, what a wild ride over there. Zooming out on the frameworks question, when I asked you ahead of our chat about what frameworks you love and anything you think would be interesting to share, you had a really interesting response and so I'd love for you to just share your perspective on frameworks broadly.

**中文翻译:**
是啊，那儿真是够疯狂的。回到框架的问题上，在我们聊天之前，当我问你喜欢哪些框架以及有什么有趣的分享时，你的回答非常耐人寻味。我很想听听你对“框架”这一概念的广泛看法。

---

### [00:20:34] Oji Udezue

**English:**
Yeah. Look, I'm two things simultaneously. One is actually, I like frameworks. The way that I try to express them is mental models because the essence of a framework and a mental model is that it is a shortcut. It packages some dense thinking into a way for you to approach a problem or to approach an opinion and so on and so forth. So I do collect them. But I think that what's important, I feel in product management, is to have the ability to understand the fundamentals or the empirical relationship that constructs a framework in the first place. In math, you would call it being able to derive the equation. And the reason that's important is because there's so much uncertainty in what we do. Product management isn't a science. In fact, programming isn't even a science really, because if it was, we'd treat it differently. So the art of building, say a software company that is profitable is not scientific.

**中文翻译:**
是的。听着，我同时持有两种观点。一方面，我确实喜欢框架。我更倾向于称之为“思维模型”，因为框架和思维模型的本质是一种捷径。它将一些深奥的思考打包成一种方式，让你去处理问题或形成观点。所以我确实在收集它们。但我认为，在产品管理中，最重要的是具备理解基本原理或构建框架的经验关系的能力。在数学中，这被称为“推导方程”的能力。之所以重要，是因为我们的工作充满不确定性。产品管理不是一门科学。事实上，编程甚至也不是真正的科学，否则我们会以不同的方式对待它。因此，建立一家盈利的软件公司的艺术并不是科学性的。

---

### [00:21:36] Oji Udezue

**English:**
There's a lot of uncertainty, a lot of unknowns, there's timing issues. So I guess while I love mental models, while I love frameworks, what I want people who listen to me and maybe listen to you to understand is you have to go deeper. Because as situations change, as an investor and advisor to startups, I advise differently if you are just starting, if you're in the middle, and if you're scaling. In the book that I'm writing on product, I actually make that distinction a lot in the book, which stage are you? Because then the thing that applies to you is different. If you understand the fundamentals, you'll be able to use frameworks in a much more productive way because you'll adapt it to your stage, you'll adapt it to the problem. And I think that's really important. I see lots of people using frameworks very blindly, and I think that's harmful to them and harmful to their businesses.

**中文翻译:**
这里有太多的不确定性、未知数和时机问题。所以，虽然我热爱思维模型和框架，但我希望听众明白，你必须深入挖掘。因为随着情况的变化，作为初创公司的投资者和顾问，如果你是刚起步、处于中期还是正在规模化，我的建议会完全不同。在我正在写的关于产品的书中，我经常做这种区分：你处于哪个阶段？因为适用于你的东西是不同的。如果你理解了基本原理，你就能以更高效的方式使用框架，因为你会根据你的阶段和问题来调整它。我认为这非常重要。我看到很多人盲目地套用框架，我认为这对他们个人和他们的业务都是有害的。

---

### [00:22:31] Lenny

**English:**
What a great segue to where I wanted to take us next, which is around the book that you're writing, which is my understanding is it's product management for product led growth. And I'm on your wait list to find out when it's out, and I saw that the other day you asked people for their advice on what to call the book. Do you have any favorites at this point of what you might title it?

**中文翻译:**
这真是一个完美的过渡，引出了我接下来想聊的话题——你正在写的书。据我了解，这本书是关于“产品驱动增长（PLG）中的产品管理”。我已经在你的等待名单上了，想知道什么时候出版。我看到前几天你在征求大家关于书名的建议。目前你有什么心仪的备选书名吗？

---

### [00:22:50] Oji Udezue

**English:**
Well first of all, there are two things happening with the book. One is I believe PLG is, I have maybe a different definition of PLG, but I think the way that we are basically adapting products to the consumer or to the business professional and using the product itself to sell the value proposition is really key to transitioning from what we used to do 20 years ago to today. Basically, I think even enterprise companies will tend towards a consumer type product management over the next decade than the other way around, that's my bet. And so let's call that PLG, just writ large. And also I think product management is set for growth. So obviously that's good for you, Lenny, because everyone needs to know how to do this.

**中文翻译:**
首先，关于这本书有两件事。第一，我对于 PLG 有自己的定义。我认为，将产品适配给消费者或商务专业人士，并利用产品本身来推销价值主张，是从 20 年前过渡到今天的关键。基本上，我打赌在未来十年，即使是企业级公司也会倾向于消费者型的产品管理，而不是反过来。所以广义上我们就叫它 PLG 吧。另外，我认为产品管理正处于增长期。Lenny，这对你来说显然是好事，因为每个人都需要知道怎么做。

---

### [00:23:39] Oji Udezue

**English:**
It's an integrative art within building software and software is seeding the world, the book, I want to get very practical. What matters about doing those two things well, and the best titles coming up are, my original title was Building Rocket Ships. So it's like how do you think through all the different things you need to build a really successful software company? Think about the practice, think about the business, meld those two things together. So a lot of people love that title. Well, there's a huge variation in submissions. So I think we're going to do that one more time and offer more options before we nail down the title of the book, so still TBD.

**中文翻译:**
这是构建软件过程中的一种综合艺术，而软件正在播种世界。在这本书中，我想写得非常实用。如何做好这两件事至关重要。目前最好的书名建议中，我最初的标题是《建造火箭飞船》（Building Rocket Ships）。这就像是你如何思考建立一家真正成功的软件公司所需的所有不同要素？思考实践，思考业务，并将两者融合在一起。很多人喜欢这个标题。不过，大家提交的建议差异很大。所以我想我们会再征集一次，提供更多选项，然后再最终确定书名，所以目前还是“待定”。

---

### [00:24:22] Lenny

**English:**
Cool, all right. I'm excited to see where you land. So let's just spend some time on PLG. I feel like this is your bread and butter as a product leader. You've worked at some of the most successful PLG companies and I think you have some of the most unique perspectives on what works and doesn't work. And I saw you shared a preview of what you're going to be sharing the book, and so there's a few things there that I thought were really interesting that I haven't seen other places when it comes to PLG. So I was just going to dig into it-

**中文翻译:**
酷，我很期待最终的结果。那我们花点时间聊聊 PLG 吧。我觉得作为产品领导者，这是你的拿手好戏。你曾在一些最成功的 PLG 公司工作过，我认为你对哪些有效、哪些无效有着非常独特的见解。我看到你分享了书中内容的一些预览，其中有几点我觉得非常有趣，是在其他讨论 PLG 的地方没见过的。所以我打算深入挖掘一下——

---

### [00:24:45] Oji Udezue

**English:**
Yay.

**中文翻译:**
太好了。

---

### [00:24:49] Lenny

**English:**
Absolutely. The first is this framing that you had for where to start and how to focus with your PLG problem. And you described it as starting with a sharp problem. Can you talk about what that means?

**中文翻译:**
当然。首先是你关于从哪里开始以及如何聚焦 PLG 问题的框架。你将其描述为“从一个尖锐的问题（sharp problem）开始”。你能谈谈这意味着什么吗？

---

### [00:24:59] Oji Udezue

**English:**
Yeah, so I'm trying to connect dots. The sharp problem is a little bit of that whole quadrant framework, which is what problem are you going to work on? I think that problems have predictive power of success if you actually solve the problem. And this is different from, I have an idea, yeah. I think that a lot of innovation can come from inspiration, but the best inspiration comes from understanding customers and their problems. So my advice to founders is pick a problem that is materially felt by your customers, pain points that steal their time, their energy, their money, their focus, the inability to afford their leisure. If you can solve those kinds of problems, and look, I know that it's broad, because it requires insight.

**中文翻译:**
是的，我正试图把这些点串联起来。“尖锐的问题”有点像之前那个象限框架，即你打算解决什么问题？我认为，如果你真的解决了问题，那么问题本身就具有预测成功的能力。这与“我有一个点子”是不同的。我认为很多创新可以来自灵感，但最好的灵感来自对客户及其问题的理解。所以我给创始人的建议是：选择一个客户能切身感受到的问题，那些偷走他们时间、精力、金钱、注意力的痛点，那些让他们无法享受闲暇的问题。如果你能解决这类问题——我知道这很宽泛，因为它需要洞察力。

---

### [00:26:22] Oji Udezue

**English:**
The best founders often are people who felt a problem, understand it, understand that it's really difficult, and understand that there may be like five, 10, 20 billion people who feel it and they don't want to solve that problem versus I feel a problem, but only 100,000 people care. In which case, maybe it's not that intense anyway, unless you can charge them thousands and thousands of dollars. So pick those kinds of problems. If you have the narrative in your head that if you really solve this, people will pony up. That's what I ask people to find. Too many of us just have a sharp idea. Look, I've built a startup on a non-sharp problem, and I knew how it felt. Well, I also know working in companies that are solving sharp problems how it feels, it's a huge tailwind to do that. In fact, when you work on sharp problems, it's hard to fail because you can make mistakes and the customer's obsession will carry you, but if you work on something that doesn't have a sharp problem, mistakes can kill you because essentially you're having to pay a lot for marketing, you're having to pay a lot for word of mouth. People, when they get poor, they don't care about it, like recessions.

**中文翻译:**
最好的创始人通常是那些亲身感受过问题、理解它、知道它有多难，并且明白可能有 50 亿、100 亿甚至 200 亿人也有同感，而他们迫切想要解决这个问题的人。这与“我感到一个问题，但只有 10 万人在意”是不同的，除非你能向这 10 万人每人收取数千美元，否则那个问题可能不够强烈。所以要选择那种如果你真的解决了，人们会愿意掏钱的问题。这就是我要求人们去寻找的。我们中太多人只是有一个“尖锐的点子”。听着，我曾围绕一个“不尖锐的问题”建立过初创公司，我知道那是种什么感觉。我也知道在解决“尖锐问题”的公司工作是什么感觉，那就像是拥有巨大的顺风。事实上，当你解决尖锐问题时，很难失败，因为即使你犯了错，客户对解决问题的渴望也会支撑你走下去；但如果你解决的不是尖锐问题，错误可能会致命，因为你必须支付高昂的营销费用和口碑成本。当人们变穷时（比如经济衰退），他们根本不在乎那些不痛不痒的产品。

---

### [00:27:15] Lenny

**English:**
Coming back to something you mentioned earlier about just how much pain it needs to be for people to care or how much pain it needs to solve versus the status quo, I think is a really important element of this. I think most founders like, no, I need to solve a problem. But usually it's not painful enough or it's not solving it enough, given either an example of something that you've tried or you've seen of just like that was a sharpish problem but not sharp enough and people didn't care, either a company worked or a startup you advised of just like, okay, it wasn't sharp enough.

**中文翻译:**
回到你之前提到的，关于痛苦程度需要达到多少人们才会真正在意，或者相对于现状需要解决多少痛苦，我认为这是非常关键的要素。大多数创始人都觉得“不，我是在解决问题”，但通常那个问题不够痛，或者解决得不够彻底。你能举个你尝试过或见过的例子吗？比如一个看起来有点尖锐但其实不够尖锐，导致人们不在意的问题，无论是在你工作过的公司还是你咨询过的初创公司。

---

### [00:27:46] Oji Udezue

**English:**
I don't want to create enemies because I know a lot of founders. But here's one, here's one. I don't know if you remember during the pandemic, this venture studio by I think one of the ex founders of Evernote created mmhmm camera, remember that?

**中文翻译:**
我不想树敌，因为我认识很多创始人。但这里有一个例子。不知道你还记不记得疫情期间，由 Evernote 的一位前创始人创立的风险工作室开发了一个叫 mmhmm 的相机应用，记得吗？

---

### [00:28:04] Lenny

**English:**
Oh yeah, absolutely. Yeah, great video.

**中文翻译:**
哦，当然记得。视频效果很棒。

---

### [00:28:07] Oji Udezue

**English:**
It was fun, but I don't think it was a sharp problem. It was fun, but yeah, it didn't change the world of your Zoom camera. It didn't change the world of your collaboration. And so I think that's one example of a non-sharp problem, for example, for most people.

**中文翻译:**
它很有趣，但我认为它解决的不是一个尖锐的问题。它好玩，但它并没有改变你的 Zoom 摄像头世界，也没有改变你的协作世界。所以我觉得对大多数人来说，这就是一个“非尖锐问题”的例子。

---

### [00:28:31] Lenny

**English:**
What are signs that it's sharp enough, just like in your experience? I know you talked about it steals your time, energy, money focused. What are flags that this is sharp enough in your experience?

**中文翻译:**
根据你的经验，有哪些迹象表明问题“足够尖锐”？我知道你提到过它偷走时间、精力、金钱和注意力。除此之外，还有哪些信号？

---

### [00:28:43] Oji Udezue

**English:**
I think there are two ways to think about it. If you are in the trenches as a founder, the easiest way to map out a sharp problem is draw the current approximate average workflow for your target customer, at least what you think is a target, and then draw the workflow after they've used your software and see how much shorter it is, yes or no. And then try to measure those lines. If you draw them as horizontal lines, try to measure those lines and see if it's much shorter. If it's 2X shorter, 3X shorter, so let's say pre-customer, that is the best way to hone in on it. Post customer, you should talk to the people who are most enthusiastic and derive their workflow and their workflow change and try to measure that. I think that's how you figure out if it's a sharp problem or not.

**中文翻译:**
我认为有两种思考方式。如果你是身处一线的创始人，描绘尖锐问题最简单的方法是：画出目标客户（至少是你认为的目标客户）目前的平均工作流，然后再画出他们使用你的软件后的工作流，看看是否变短了。试着测量这些线条。如果你把它们画成水平线，看看使用后的线是否短得多。如果是短了 2 倍、3 倍，那么在获取客户之前，这是最精准的判断方法。在拥有客户之后，你应该去和那些最热情的用户交谈，推导他们的工作流以及工作流的变化，并尝试量化它。我认为这就是判断问题是否尖锐的方法。

---

### [00:29:37] Oji Udezue

**English:**
The other thing that we talk about in startup super early stage world is, I call it the whites of their eyes. When you take a problem and you share it with someone who it's going to affect their workflow, and I use the word workflow a ton because I don't use specs anymore or use cases, I think workflows are the unit of productivity. When you see people's eyes get big and they expose more whites to you, you're probably onto something. It's not enough, that's not a workflow thing, that's an excitement thing. But people often react that way when you're solving a really sharp problem for them. And then people spontaneously bring up money, it's like when can I pay? When can I... Those kinds of things give you an indication.

**中文翻译:**
我们在初创公司极早期阶段谈论的另一件事，我称之为“露出眼白”（the whites of their eyes）。当你把一个问题分享给那些工作流会受此影响的人时（我大量使用“工作流”这个词，因为我不再使用“规格说明”或“用例”，我认为工作流是生产力的单位），当你看到人们瞪大眼睛，露出更多眼白时，你可能找对方向了。这还不够，这只是兴奋感，不是工作流本身。但当你在为人们解决一个非常尖锐的问题时，他们通常会有这种反应。接着，人们会自发地提到钱，比如“我什么时候能付钱？”“我什么时候能用上？”这些事情会给你明确的指示。

---

### [00:30:23] Lenny

**English:**
Two other versions of the showing more whites of your eyes, which I love. Two other versions of that I've heard is one is you see their pupils dilate and they're just like, "Whoa, I need this now." And then the other is someone described it as, you see this nod of as you're talking, they're just like, "Oh, I get it. I get this." And then they're like, "Okay, we need this in our company."

**中文翻译:**
关于“露出眼白”，我听过另外两个版本，我也很喜欢。一个是看到他们的瞳孔放大，然后惊呼：“哇，我现在就需要这个。”另一个是有人描述为，当你说话时，你看到他们不停地点头，说：“噢，我懂了，我完全理解了。”然后他们会说：“好的，我们公司需要这个。”

---

### [00:30:46] Oji Udezue

**English:**
I'm a little over those ones because sometimes it's just excitement and just noise. And so the things I said previously about workflow compression or capability inflation, I think those are more reliable, which is all about customer research and customer conversations. That's what I would focus on. Yeah, I'm saying all this from mistakes I've made, basically. So I feel like this is scar tissue, which is what I'm trying to pour into the book.

**中文翻译:**
我对那些说法持保留态度，因为有时那只是兴奋和噪音。所以我之前提到的“工作流压缩”或“能力膨胀”，我认为这些更可靠，而这些都源于客户研究和客户对话。这才是我的关注点。是的，我说的这些基本上都是从我犯过的错误中总结出来的。我觉得这些都是“疤痕组织”，也是我正努力倾注到书里的内容。

---

### [00:31:18] Lenny

**English:**
Speaking of talking to customers, another one of your big bullet points in the book is around continuous customer discovery, and I'm curious what you found to be successful in actually doing that. A lot of people talk about it when you keep talking to customers, get feedback constantly. What actually works in your experience?

**中文翻译:**
说到与客户交谈，你书中的另一个重点是“持续的客户发现”（continuous customer discovery）。我很想知道，在实际操作中，你发现哪些方法是成功的？很多人都在谈论要不断与客户交谈、不断获取反馈。根据你的经验，真正有效的方法是什么？

---

### [00:31:34] Oji Udezue

**English:**
Yeah, I feel like all of park management is about discovery these days. Everyone talks about it, and I want to make a distinction. I think discovery is when you use customer conversations to understand a very specific thing that you want to optimize further workflow that you want to optimize further. And then you call the people who are most likely to be affected and you do use various research strategies to talk to them. There's a version of that also that is what I call continuous conversations, which is a Calendly and a Typeform, which we'll do more and more of. You should organize it so that your PMs, your designers, your engineering managers and your PMMs are constantly talking to customers by default. Meaning that customer conversations show up on their calendar every week automagically, without them getting involved. And then they're trained on how to have the conversation, because the death of customer discovery is friction. If you ask individuals to do customer discovery, they will not do customer discovery.

**中文翻译:**
是的，我觉得现在的产品管理几乎全是关于“发现”。每个人都在谈论它，但我想做一个区分。我认为“发现”是指你通过客户对话来理解一个非常具体的事物，或者你想进一步优化的某个特定工作流。然后你打电话给那些最可能受影响的人，并使用各种研究策略与他们交谈。还有一种版本我称之为“持续对话”，在 Calendly 和 Typeform，我们会越来越多地这样做。你应该组织好流程，让你的 PM、设计师、工程经理和 PMM 默认就在不断地与客户交谈。这意味着客户对话每周都会“自动”出现在他们的日历上，无需他们亲自介入。然后他们接受如何进行对话的培训。因为客户发现的死穴是“摩擦”。如果你要求个人主动去做客户发现，他们是不会去做的。

---

### [00:32:49] Oji Udezue

**English:**
This is the thing that dies in an innovative company because it's very difficult to actually talk to the right customer, not talk to any customer, talk list of the right customer continuously. But there's a third thing that I like to talk about, which is customer listening. In fact, I'm going to talk about this at industry in October, the PM Conference. Customer listening is different. It's not really discovery. It is the scarfing up of customer signals that are happening constantly anyway. So people are talking on social, people are talking on app stores and G2 crowd. If you have a instrumented churn survey, people are talking. If you have NPS, people are not only giving you the scores where they're putting in the verbatims. If you have a bug report, which we had at Atlassian, people are filing bugs, developers love to file bugs, so of course we have that for that audience. And then if you go to Zendesk and customer support, people are either talking about one thing all the time or a range of things, and you can see the frequency distribution.

**中文翻译:**
在创新型公司里，这件事往往会夭折，因为持续地与“正确的”客户（而不是随便什么客户）交谈是非常困难的。但我还想谈谈第三件事，我称之为“客户倾听”（customer listening）。事实上，我将在 10 月份的 PM 大会上讨论这个话题。客户倾听是不同的，它不完全是“发现”。它是对那些无论如何都在不断发生的客户信号的“搜刮”。人们在社交媒体上议论，在应用商店和 G2 Crowd 上评价。如果你有流失调查，人们在说话；如果你有 NPS，人们不仅在打分，还在写评语。如果你有错误报告（我们在 Atlassian 就有），人们在提交 Bug，开发者最爱提 Bug 了。如果你去 Zendesk 看客户支持记录，人们要么一直在谈论一件事，要么在谈论一系列事情，你可以看到频率分布。

---

### [00:34:01] Oji Udezue

**English:**
And of course in Salesforce, you have closed one. These are all things happening no matter what you do. Whether you're listening or not, you're getting these signals. One of the big, hairy, audacious goals of product management is being able to process these signals efficiently. We did it in a certain way at Calendly, which I drew a rig together through workflows and Slack, and then having individuals triage those things. And if you can do that hard and at industry, I'll talk a little bit about how to do it. It's not exactly discovery. It is what matters. Our job is to meld customer delight with business ambition. And it feels essential beyond discovery that you are listening and you're understanding what matters from a customer delight perspective. And I think many of us do this really well. I've tried to do it everywhere I've gone, Twitter, Atlassian, Calendly, now at Typeform. But it still feels like something that the industry can get better at.

**中文翻译:**
当然，在 Salesforce 中，你有“成交”记录。无论你做什么，这些事情都在发生。无论你是否在倾听，你都在接收这些信号。产品管理中一个宏大且艰巨的目标就是能够高效地处理这些信号。我们在 Calendly 用某种方式实现了这一点，我通过工作流和 Slack 搭建了一套系统，然后让人工对这些信息进行分类。如果你能做到这一点——在大会上我会详细讲讲怎么做。这不完全是发现，但它至关重要。我们的工作是将“客户愉悦”与“业务雄心”融合在一起。在发现之外，倾听并理解从客户愉悦角度出发什么才是最重要的，这感觉非常关键。我认为我们中没多少人能做得非常好。我每去一个地方都尝试这样做，Twitter、Atlassian、Calendly，现在在 Typeform 也是。但这仍然感觉是整个行业可以做得更好的地方。

---

### [00:35:08] Lenny

**English:**
This touches on advice that Teresa Torres teaches around continuous customer discovery. And she actually had a really good tactic, that I'll share here that stuck with me, about how to actually do this. So the way she recommends companies do this is have a little popup on your site asking visitors like we'd love to talk to you and get your feedback on our product. And it just links them to a Calendly to book a meeting, and that's how it shows up on the calendar.

**中文翻译:**
这触及了 Teresa Torres 关于持续客户发现的建议。她实际上有一个非常好的策略，我在这里分享一下，这个策略一直让我印象深刻。她建议公司在网站上放一个小弹窗，询问访问者：“我们很想和你聊聊，听听你对我们产品的反馈。”然后直接链接到 Calendly 预约会议，这样会议就会自动出现在日历上。

---

### [00:35:30] Oji Udezue

**English:**
Yeah, that's what we did at Calendly. But I will say, so a couple of caveats, we did that in the community. We had community at calendly.com and we understood that that was a self-selected group. But it was still important to talk to them because they were still representative. And of course you should do it in a product. The challenge of that approach is always is it the right customer? And the pro/con of that is talking to one customer is useless, talking to 100 is super useful. And so the challenge is are you targeting the right person?

**中文翻译:**
是的，我们在 Calendly 就是这么做的。但我得说明几点：我们在社区里做了这件事，我们在 community.calendly.com 有个社区，我们知道那是一个“自我筛选”的群体。但与他们交谈仍然很重要，因为他们仍具有代表性。当然，你也应该在产品内部这样做。这种方法的挑战始终是：这是“正确的”客户吗？其利弊在于：只和一个客户聊没用，和 100 个聊就超级有用。所以挑战在于你是否瞄准了正确的人。

---

### [00:36:09] Oji Udezue

**English:**
So some intelligence upfront and who to show it to and why you're showing it to them, so that they can come is interesting. Very particularly effective by the way for growth, because if people don't activate or churn, they don't want to talk to you. But if you can present that thing in their activation or conversion journey, they might actually talk to you. And so that's really key. So I 100% agree with Teresa, that's exactly what you should do for not even, I wouldn't even call it discoveries for listening, and some of it can be discovery. Yeah, I think that's exactly what you should do.

**中文翻译:**
因此，预先进行一些智能筛选，决定向谁展示以及为什么要展示，这很有趣。顺便说一下，这对增长特别有效，因为如果人们没有激活或已经流失，他们是不想理你的。但如果你能在他们的激活或转化旅程中展示那个入口，他们可能真的会和你聊聊。所以这是关键。我 100% 同意 Teresa 的观点，这正是你应该做的——我甚至不称之为“发现”，而是为了“倾听”，当然其中一部分也可以是发现。是的，我认为这正是你应该做的。

---

### [00:36:45] Lenny

**English:**
As you're talking I'm realizing I'm using most of the products you help build. I'm on Twitter a lot. I use Calendly a lot. I use Typeform as my default survey tool.

**中文翻译:**
当你说话时，我意识到我正在使用你参与打造的大多数产品。我经常上 Twitter，我经常用 Calendly，我把 Typeform 作为我的默认调查工具。

---

### [00:36:55] Oji Udezue

**English:**
I saw that, my team is really excited that you're using Typeform.

**中文翻译:**
我看到了，我的团队听说你在用 Typeform 都非常兴奋。

---

### [00:36:59] Lenny

**English:**
You've impacted my life in so many ways, Oji.

**中文翻译:**
Oji，你在很多方面影响了我的生活。

---

### [00:37:02] Oji Udezue

**English:**
I think you owe me money, Lenny-

**中文翻译:**
我觉得你欠我钱，Lenny——

---

### [00:37:04] Lenny

**English:**
What do you need? How much? Give me your Venmo QR code, it's on [inaudible 00:37:09].

**中文翻译:**
你需要什么？多少钱？把你的 Venmo 二维码给我……

---

### [00:37:11] Lenny (Sponsor Message - Repeated)

*(Note: This is a repeat of the Jira Product Discovery sponsor message from 00:01:44. Translation omitted for brevity as it is identical.)*

---

### [00:38:32] Lenny

**English:**
Getting back on track. Another important part of the book that you're writing is around onboarding. And something that I talk a lot about on this podcast is just the power of onboarding and how impactful it's to retention and so much of the eventual success of your product and how customers use it. And so I'd love to hear just your advice on what you think is really important, I guess why onboarding is so important in success and PLG. And also just what tactics have you found to be really effective?

**中文翻译:**
回到正题。你正在写的书里另一个重要的部分是关于“新手引导”（onboarding）。我在这个播客中经常谈到新手引导的力量，以及它对留存、产品最终成功以及客户如何使用产品有多大的影响。所以我很想听听你的建议，你认为什么才是真正重要的？为什么新手引导在 PLG 的成功中如此关键？此外，你发现哪些策略是非常有效的？

---

### [00:38:59] Oji Udezue

**English:**
Let me talk about a few fundamentals. Onboarding is a substitute for sales and all these account management teams for millions of customers. The task is how do you make it approximate a human and how friendly a human is and how approachable a human is? Because if you can do that, then you can process thousands and thousands of customers very quickly. Onboarding is an exercise in understanding the mindset of a buyer, of an evaluator. It's nothing more than that. Meaning that the province of understanding is social psychology, it's not really product, it's biopsychology. And guess who knows a lot about this stuff, it's people in the offline industry. The people who stock shelves, the people who provide inventory online and so on and so forth. They are extraordinarily good at this. So the reason I say this is to divert people who are [inaudible 00:40:00] to really find where to source their inspiration from for onboarding, first of all.

**中文翻译:**
让我谈谈几个基本原理。对于数百万客户来说，新手引导是销售和所有客户管理团队的替代品。任务是：你如何让它接近于一个真人，像真人一样友好、平易近人？因为如果你能做到这一点，你就能非常快速地处理成千上万的客户。新手引导是一种理解买家、评估者心态的练习。仅此而已。这意味着理解的范畴是社会心理学，不完全是产品，而是生物心理学。猜猜谁最懂这些？是线下行业的人。那些摆放货架的人，那些在网上提供库存的人等等。他们极其擅长这个。我之所以这么说，是为了引导大家去寻找新手引导灵感的真正来源。

---

### [00:40:06] Oji Udezue

**English:**
If you think about this as intentful in that way, which is people come not knowing anything about you and in a progressively developed confidence that you are the tool of choice, you then have to break it down into how does that journey go through a mind, the average mind anyway, and how do you assist each part? One is value proposition, understanding, one is trying to see if it's simple enough and provides enough value. One is kicking tires and one is making the choice that this is something I'm going to go forward with. How does your onboarding support hit all of these things? Now I think there are two parts of onboarding. One is mandatory, the setup, it has to be spare. I try not to make it more than three screens, but it's about how do you say what this does and provide the essential setup that your customer needs to be successful?

**中文翻译:**
如果你从这个意图出发去思考——即人们来的时候对你一无所知，然后逐渐建立起“你就是首选工具”的信心——你就必须将其分解：这个旅程是如何经过大脑（至少是普通人的大脑）的？你如何协助每个环节？一是理解价值主张，二是尝试看它是否足够简单并提供足够价值，三是“试用”（kicking tires），四是做出决定“这就是我要用的东西”。你的新手引导如何覆盖所有这些环节？我认为新手引导分为两部分。一是“强制性”的设置，必须精简。我尽量不超过三个屏幕，重点在于：你如何说明这是做什么的，并提供客户成功所需的必要设置？

---

### [00:41:05] Oji Udezue

**English:**
At Calendly, for example, we asked them about connecting their calendar and setting some defaults. Is it 9:00 to 5:00 or whatever that is? Those two things set up all the future success. And if we made it optional, more people would fail. So it's information and the essential setup, and it should be as short as possible. Then there's a whole other set of things that should be optional because they're not necessary for everyone to be successful, but they're beneficial if people are curious. And also, it can be what we call a random access, so people can get back to it any time they want, if they're feeling help. And so if you divide onboarding into those two things and then figure out what to put in one and what to put in the other, I think you can be quite successful. And this is just the tip of the iceberg that I get into in the book.

**中文翻译:**
例如在 Calendly，我们会询问他们连接日历并设置一些默认值（比如是 9 点到 5 点还是别的）。这两件事为未来的所有成功奠定了基础。如果我们把这设为可选，更多的人会失败。所以，它是信息和必要的设置，而且应该尽可能短。然后还有另一套东西应该是“可选”的，因为它们不是每个人成功所必需的，但如果人们好奇，它们是有益的。而且，它可以是所谓的“随机访问”，人们可以在任何需要帮助的时候回来查看。如果你把新手引导分成这两部分，然后想清楚哪些放进第一部分，哪些放进第二部分，我认为你会非常成功。这只是我在书中探讨的冰山一角。

---

### [00:41:56] Lenny

**English:**
Are there any examples of really big onboarding wins, things that really helped with conversion or activation that come to mind?

**中文翻译:**
有没有什么特别成功的新手引导案例？比如那些真正帮助提高转化率或激活率的例子？

---

### [00:42:01] Oji Udezue

**English:**
Well, I think keep it short is one big win. The fewer things, the better, that are essential, that everyone has to go through. It's unclear if all those clickthroughs go here, go here, and all those things work-

**中文翻译:**
嗯，我认为“保持简短”就是一个巨大的胜利。必须让每个人都经历的必要步骤越少越好。目前还不清楚那些“点这里、点那里”的引导是否真的有效——

---

### [00:42:16] Lenny

**English:**
The wizards, yeah.

**中文翻译:**
你说的是那些“向导”（wizards）式引导，对吧。

---

### [00:42:18] Oji Udezue

**English:**
Yeah. The wizards have had, in my experience, limited benefit. So much as just directing people to the one thing that they need to do post mandatory onboarding. Having examples, not 10, one or two of what good looks like is particularly powerful because it's mimetic. People see, oh, okay, this is exactly what I'm shooting for, is very powerful. In terms of trial and conversion, letting people understand and being very clear about where they are in the trial cycle, whether you want them to pay for it now or they need to pay for it later, after seven days. Having them understand that really clearly so they know where they are versus they feel like they're completely at sea, I think is very important for conversion.

**中文翻译:**
是的。根据我的经验，向导式引导的作用有限。不如直接引导人们在完成强制引导后去做那件“最重要的事”。提供示例（不是 10 个，一两个就行），展示“好的样子”是什么，这特别有效，因为它具有模仿性。人们看到后会想：“噢，好的，这正是我想要达到的效果。”这非常有力。在试用和转化方面，让人们清楚地了解自己处于试用周期的哪个阶段，是现在就要付钱，还是 7 天后才付。让他们清晰地理解这一点，知道自己的处境，而不是感觉像在大海里漂泊，我认为这对转化非常重要。

---

### [00:43:07] Oji Udezue

**English:**
I think there are a few things like that, but I also want to mention that it's different for every product. Depending on where you are in the quadrant and the amount of augmentation and problem solving and how sharp the problem is, you might want to adjust your approach. And this is the kind of thing that there's some fundamentals, but it's not necessarily this one size fits all. In fact, at Typeform, we're trying to maybe invent a new twist on freemium just because of some of the things we're seeing for our particular customers. And so yeah, these are for me, some new learning as well as I go through each different product.

**中文翻译:**
我觉得类似的事情还有几件，但我也想提到，每个产品都是不同的。取决于你在象限中的位置、增强程度、问题解决方式以及问题的尖锐程度，你可能需要调整你的方法。这属于那种虽然有基本原理，但并非“一招鲜吃遍天”的事情。事实上，在 Typeform，我们正尝试在免费增值模式（freemium）上玩出新花样，正是因为我们从特定客户身上看到了一些东西。所以，对我来说，每接触一个不同的产品都是一次新的学习。

---

### [00:43:49] Lenny

**English:**
Along these lines of onboarding activation and getting a user activated is really important. And I'm curious, do you have an example of what an activation milestone was at Calendly or Twitter or a Typeform? Just to give people a sense of like here's a good example of an activated user milestone.

**中文翻译:**
顺着新手引导和激活的话题，让用户“被激活”非常重要。我很好奇，你能举个例子说明在 Calendly、Twitter 或 Typeform，激活里程碑（activation milestone）是什么吗？好让大家对“什么是好的激活用户里程碑”有个概念。

---

### [00:44:03] Oji Udezue

**English:**
I think this goes back to people, the Pendos and the Amplitudes of this world. You have to think through your aha journey. Like at Calendly and also at Typeform we have three thresholds of increasing activation. And we just try to make sure that people go through each one as many people as possible. And frankly, we try to figure the drop-off between the increasing definitions of activation. So at Calendly we want to make sure you've created your first meeting. But then if you've created five within a week, that's really much more powerful. At Typeform, it's really about have you published the form and have you gotten responses? And have you gone to look at what the responses mean in the insights page, for example.

**中文翻译:**
我认为这要回到像 Pendo 和 Amplitude 这些工具所关注的东西上。你必须思考你的“Aha 旅程”（惊喜时刻旅程）。比如在 Calendly 和 Typeform，我们有三个递增的激活门槛。我们只是努力确保尽可能多的人通过每一个门槛。坦率地说，我们会计算不同激活定义之间的流失率。在 Calendly，我们要确保你创建了第一个会议；但如果你在一周内创建了五个，那激活程度就高得多了。在 Typeform，核心在于：你发布表单了吗？你收到回复了吗？你有没有去“洞察”页面查看这些回复意味着什么？

---

### [00:44:52] Oji Udezue

**English:**
At Twitter it is are you following anyone or are you being followed? Because that verb, follow, is the way you start to construct your informal community. Remember what I said is Twitter is for people who want informal community around a topic that is not... Facebook is about who do you know, Twitter is about who do you want to know? Who's passionate about what you're passionate about? And so if you haven't set up your follow graph at all, you're not going to really activate. It's not going to be compelling for you.

**中文翻译:**
在 Twitter，激活指标是：你关注别人了吗？或者有人关注你吗？因为“关注”（follow）这个动词是你开始构建非正式社区的方式。记住我说的，Twitter 是为那些想围绕某个话题建立非正式社区的人准备的……Facebook 是关于“你认识谁”，Twitter 是关于“你想认识谁”。谁对你热衷的事物也充满热情？所以，如果你根本没有建立起你的关注图谱（follow graph），你就没有真正被激活，这个平台对你也就没有吸引力。

---

### [00:45:23] Lenny

**English:**
Awesome, those are great examples. It's funny hearing that Twitter activation milestone out of context sounds, so creepy. Have you followed anyone or is anyone following you?

**中文翻译:**
太棒了，这些例子很好。有趣的是，脱离语境听 Twitter 的激活里程碑听起来有点毛骨悚然：“你跟踪（follow）别人了吗？有人在跟踪你吗？”

---

### [00:45:31] Oji Udezue

**English:**
Yeah, because a lot of people go in and then they tweet into the void or they don't feel like they have a voice. But that's not the most important thing. Most important thing is are you getting content that you are interested in that makes you want to come back and see more of it and follow is a huge part of doing that.

**中文翻译:**
是的，因为很多人进去后只是对着虚空发推，或者觉得自己没有发言权。但这并不是最重要的。最重要的是你是否获得了感兴趣的内容，让你想回来看到更多，而“关注”是实现这一点的核心。

---

### [00:45:47] Lenny

**English:**
Yeah. Just on the point of Twitter, I don't know if this goes anywhere, but it's crazy how it keeps going no matter how much destruction is happening all around, employees-

**中文翻译:**
是的。关于 Twitter，我不知道这话题会引向何方，但令人疯狂的是，无论周围发生了多少破坏，员工流失了多少——它居然还在运行。

---

### [00:45:58] Oji Udezue

**English:**
Oh, you want me to talk about that? Because I want to talk about this.

**中文翻译:**
噢，你想让我聊聊这个吗？我正想聊聊这个。

---

### [00:45:58] Lenny

**English:**
Please, let's do it.

**中文翻译:**
请讲，开始吧。

---

### [00:46:04] Oji Udezue

**English:**
So one of the things they, I don't want to say they, one of the things I learned early on is network effects. Network effects, let me define it. Network effects is when you create value for passive members by other people joining the network. So I am by myself, I have done nothing. I'm at home, chilling, but one person joins the network and immediately I gain benefit, okay. So think about Facebook. If there are eight billion people on Facebook, it means that all of a sudden I can reach everyone on the planet. And so the more people on Facebook, the more it's valuable to me regardless of my effort. That's network effect. If I'm into Word, word processor, Microsoft Word, and the more people who use that file format, it means that the more Word documents I can read.

**中文翻译:**
我早期学到的东西之一就是“网络效应”（network effects）。让我定义一下：网络效应是指当其他人加入网络时，会为被动成员创造价值。比如我一个人待着，什么也没做，在家休息，但只要有一个人加入网络，我立刻就能获益。想想 Facebook，如果 Facebook 上有 80 亿人，这意味着我突然间可以联系到地球上的每一个人。所以 Facebook 上的人越多，对我来说价值就越大，无论我是否努力。这就是网络效应。如果我用 Microsoft Word，使用这种文件格式的人越多，意味着我能阅读的 Word 文档就越多。

---

### [00:47:05] Oji Udezue

**English:**
And so I did nothing, so by increasing the people adoption of Word, I gain benefit. Network effect, that's what it is. So Twitter and then this is the mental model of critical mass, network effect is about critical mass. You hit a critical mass and sometimes that's not mathematically defined, and then you've hit network effect because people want to come because people are already there. So Twitter has hit critical mass and lots of your favorite social networks. Network effects is a feature by itself, and it's the most powerful feature. A good way to illustrate the power of network effects is Twitter did not die because Threads came about, that's the power of network effect. In fact, the last telegram was sent in 2016, over 100 years after it was invented because of network effects. It had to be manually closed down.

**中文翻译:**
我什么也没做，但通过增加 Word 的采用人数，我获益了。这就是网络效应。Twitter 也是如此，这涉及“临界质量”（critical mass）的思维模型。网络效应的核心在于临界质量。一旦你达到临界质量（有时这在数学上很难定义），你就拥有了网络效应，因为人们想来是因为其他人已经在那儿了。Twitter 和许多你喜欢的社交网络都达到了临界质量。网络效应本身就是一个功能，而且是最强大的功能。说明网络效应力量的一个好例子是：Twitter 并没有因为 Threads 的出现而死掉。事实上，最后一封电报是在 2016 年发出的，那是它发明 100 多年后，原因就是网络效应。它必须被手动关闭。

---

### [00:48:03] Oji Udezue

**English:**
I believe Friendster is still alive, so we have to be really clear that it's really hard to kill a network effects business. Now how do you actually accomplish it if you were to accomplish it? Well, the revenue side of any social network is vulnerable to attack. So for example, if advertisers stop being on Twitter, for example, they're not gone because again, network effects affects them. They want to go where the eyeballs are. But if for some reason they disappeared, while the people will continue to come, the ability to have money to improve the network will disappear. And that is a negative spiral. What is very, very hard to kill business, it's hard to kill software that's reached network effect, although you can kill businesses that have reached network effect.

**中文翻译:**
我相信 Friendster 居然还活着，所以我们必须清楚，要杀死一个具有网络效应的业务是非常困难的。那么，如果你想实现它，该怎么做？任何社交网络的收入端都容易受到攻击。例如，如果广告商停止在 Twitter 上投放，他们并没有真正离开，因为网络效应同样影响着他们——他们想去眼球集中的地方。但如果由于某种原因他们消失了，虽然用户会继续来，但改进网络的资金能力会消失。这是一种负面螺旋。虽然很难杀死业务，但要杀死已经达到网络效应的软件是非常难的，尽管你可以杀死已经达到网络效应的企业。

---

### [00:48:56] Lenny

**English:**
That's a really important and interesting insight. I think what's even especially interesting about Twitter is Elon and the team have removed every other benefit of Twitter, like the brand, gone, employees, 80% gone. Every part of it is being cut off, except for the network effects, and so it's a really cool case study. Dan Hockenmaier tweeted this, was a previous guest, of just like it's a good case study of what is just the power of just network effects.

**中文翻译:**
这是一个非常重要且有趣的见解。我觉得 Twitter 特别有意思的一点是，埃隆和他的团队去掉了 Twitter 的所有其他优势，比如品牌没了，80% 的员工没了。每一个部分都被切断了，唯独留下了网络效应。所以这是一个非常酷的案例研究。我之前的嘉宾 Dan Hockenmaier 发推特说，这就是网络效应力量的绝佳案例。

---

### [00:49:19] Oji Udezue

**English:**
That's right. I did a really interesting course at Berkeley Business School, asked about technology companies and so on, and this is a perfect case study on network effect. The best I've ever seen. It is incredible.

**中文翻译:**
没错。我在伯克利商学院上过一门关于科技公司等的非常有趣的课程，这就是关于网络效应的完美案例研究。我见过的最好的案例，简直不可思议。

---

### [00:49:36] Lenny

**English:**
Yeah, it's wild Threads isn't able to get there quickly, unlike what it felt like initially.

**中文翻译:**
是啊，Threads 没能像最初感觉的那样迅速达到那个程度，这挺疯狂的。

---

### [00:49:43] Oji Udezue

**English:**
Threads will prosper, I believe. And again, it'll just be another click for advertisers who understand the Facebook marketplace versus Twitter ad marketplace is much harder to access. And so I think the way Threads wins is the revenue spiral versus the pure activity spiral.

**中文翻译:**
我相信 Threads 会繁荣起来。而且，对于那些了解 Facebook 广告市场的人来说，这只是多点一下鼠标的事，而 Twitter 的广告市场要难进入得多。所以我认为 Threads 获胜的方式是靠“收入螺旋”，而不是纯粹的“活跃螺旋”。

---

### [00:50:02] Lenny

**English:**
Interesting. Where essentially they find ways to, even with lower base, generate revenue, which drives advertisers, drives more investment.

**中文翻译:**
有趣。也就是说，即使基数较低，他们也能找到产生收入的方法，从而吸引广告商，带动更多投资。

---

### [00:50:10] Oji Udezue

**English:**
Correct, correct, correct.

**中文翻译:**
没错，完全正确。

---

### [00:50:11] Lenny

**English:**
Awesome. All right. That'll be fun story to watch. Kind of along those same lines, I want to chat about virality a little bit. You worked on some of those viral products out there in B2C, I guess Twitter is an example, but also in B2B, which is really rare and interesting. And I know there's no silver bullet for increasing virality, but everyone's always wondering, how do I increase the virality of my product? So I'm curious, anything you could share, any tactics that you've seen work to increase the virality, especially of a B2B product?

**中文翻译:**
太棒了。这会是一个有趣的故事。顺着这个思路，我想聊聊“病毒性”（virality）。你曾参与过一些 B2C 领域的病毒式产品（比如 Twitter），但也参与过 B2B 领域的，这非常罕见且有趣。我知道增加病毒性没有灵丹妙药，但每个人都在想：我该如何增加产品的病毒性？所以我很好奇，你有什么可以分享的吗？有没有什么你见过的、能增加病毒性的策略，特别是针对 B2B 产品的？

---

### [00:50:36] Oji Udezue

**English:**
Well, as is my style, I want people to understand what virality is in the first place because I think people have misconceptions about it. People think virality is some Hotmails tag at the bottom that says, we'll get a free account. Virality is really when the word of mouth of a product is high quality. That's really the essence of it. Let me rephrase that. It's when customers market your product. And that is incredibly powerful, but also that's incredibly actionable, if that makes sense. There are products who try to be viral just for what I call synthetic virality that fail. Because in the end, if you're synthetically viral and people get to the product and it sucks, that's it. That's the end. Even Hotmail, for example, people talk about the viral tag. I don't know, you know what I'm talking about? Because I-

**中文翻译:**
按照我的风格，我首先想让人们理解什么是病毒性，因为我觉得大家对此有误解。人们认为病毒性就是像 Hotmail 底部那个“获取免费账户”的标签。病毒性真正的含义是产品的“口碑质量极高”。这才是本质。让我换个说法：就是“客户在帮你推销产品”。这非常强大，而且非常具有可操作性。有些产品为了我所说的“人造病毒性”而尝试走红，结果都失败了。因为归根结底，如果你是人造走红，而人们发现产品很烂，那就结束了。即使是 Hotmail，人们总谈论那个病毒标签，你知道我在说什么吗？因为我——

---

### [00:51:32] Lenny

**English:**
Absolutely, at the bottom, yes [inaudible 00:51:34].

**中文翻译:**
当然，底部的那个标签，是的。

---

### [00:51:35] Oji Udezue

**English:**
Well remember, it wasn't just that. It was one of the first webmail things. And webmail was revolutionary because you didn't have to have a POP3 client and lose your email across multiple devices. It solved a lot of really good problems for customers at the time for email. And so when they arrived from the free account, it was like, holy crap, this is amazing. And so let's do that. Uber doesn't have any weird viral traps, but it compresses the workflow of getting a cab so much that it's viral, if that makes sense. In fact, it was this time where Austin kicked them out for and other apps came in and filled the void, and then it came back after the year and just crushed everybody. There was no campaign, it was just viral by itself. So that's what virality is. So then the question is how do you increase it?

**中文翻译:**
记住，不仅仅是那个标签。它是最早的 Webmail（网页邮件）之一。Webmail 是革命性的，因为你不需要 POP3 客户端，也不会在多个设备间丢失邮件。它解决了当时电子邮件客户的很多痛点。所以当他们通过免费账户进来时，会惊呼：“天哪，这太棒了。”Uber 也没有任何奇怪的病毒陷阱，但它极大地压缩了打车的工作流，以至于它具有了病毒性。事实上，有段时间奥斯汀市把 Uber 赶走了，其他应用填补了空白，但一年后 Uber 回归，直接碾压了所有人。没有任何营销活动，它就是自发走红的。这就是病毒性。那么问题来了，如何增加它？

---

### [00:52:30] Oji Udezue

**English:**
Well look, fundamentally build a great product that solves a sharp problem and build it really well. If you do this, this is the bedrock of virality. If you don't do this, there's no viral tactic that will work in a sustained way. It will fizzle. But if you do this, you can lay on synthetic virality strategies for referral, strategies for coming back into the app and creating an account. Remember before Calendly, there was Acuity scheduling, there was other things. The difference was Calendly was so well-made, so simple for schedulers, so respectful of schedulers' time, not just the creator's time that the virality worked. It did not work for others who sucked. Xted AI and other places, they weren't that good. You have to be good to be viral.

**中文翻译:**
听着，从根本上说，要打造一个能解决尖锐问题的伟大产品，并把它做得非常好。如果你做到了这一点，这就是病毒性的基石。如果你做不到，任何病毒策略都无法持续奏效，只会昙花一现。但如果你做到了，你就可以叠加人造病毒策略，比如推荐机制、引导用户返回应用并创建账户的策略。记住，在 Calendly 之前，已经有了 Acuity Scheduling 等工具。区别在于 Calendly 做得太好了，对调度者来说非常简单，非常尊重调度者的时间（不仅仅是发起者的时间），所以病毒效应起作用了。而其他做得烂的工具就没戏。Xted AI 之类的，它们不够好。你必须足够好，才能具有病毒性。

---

### [00:53:33] Lenny

**English:**
That is such an important insight, that everyone looks at Calendly like of course you're sharing calendars with everyone, it's going to go viral. That's like what a cool trick. But your point is so interesting that there's previous versions of that, but the product itself wasn't great. The experience wasn't great. It was too complicated, it didn't work, and that's what made it so viral.

**中文翻译:**
这是一个非常重要的见解。每个人看 Calendly 都觉得：“当然啦，你把日历分享给每个人，它肯定会走红。”这听起来像个很酷的技巧。但你的观点很有趣：之前就有类似的版本，但产品本身不够好，体验很差，太复杂，不好用。而 Calendly 的成功正是因为它把产品做好了。

---

### [00:53:52] Oji Udezue

**English:**
Yeah, there may be several things I think affect virality. But I think that this is the nugget that people need to take away, that is the foundation of bedrock of all of them. Customer support actually affects virality. If you have fanatical customer support, people will love it. Viral tactics like the page that says, oh, get an account, and so on. All these signing documents, Calendly and so on and so forth. Network effects as in Calendly, you have these green dots. If you and a person have, Calendly tells you when you're free, all network effects, really high quality execution, synthetic virality all contribute to net virality. But the fundamental is exactly what we just discussed.

**中文翻译:**
是的，我认为有几件事会影响病毒性。但我认为这是大家需要记住的核心：它是所有这些东西的基石。客户支持实际上也会影响病毒性。如果你有狂热的客户支持，人们会爱上它。病毒策略（比如提示“获取账户”的页面）、签署文档、Calendly 等等。Calendly 中的网络效应（比如那些绿点），如果你和另一个人都有 Calendly，它会告诉你什么时候有空。所有这些网络效应、高质量的执行、人造病毒性共同构成了最终的病毒性。但根本原因正是我们刚才讨论的。

---

### [00:54:38] Lenny

**English:**
Just got to get it all right. No big deal.

**中文翻译:**
只要把所有事情都做对就行了。没什么大不了的。（讽刺语气）

---

### [00:54:42] Oji Udezue

**English:**
Build the best product possible, honestly, if you want to be viral. Slack wasn't even viral, there was no synthetic virality. Slack couldn't even connect to organizations for the longest time. Why? You could be working on the third floor and so on, using Slack on the fourth floor, and you would have no clue. There's no way to share it with them. But what happens when you went to lunch? People are like, "We got Slack and this is amazing." And people on the third floor are like, "Holy shit, when can we get it?" Boom, boom, boom. Great product first is virality.

**中文翻译:**
老实说，如果你想具有病毒性，就去打造尽可能最好的产品。Slack 最初甚至不是病毒式的，没有任何人造病毒手段。在很长一段时间里，Slack 甚至无法连接不同组织。为什么？你可能在三楼工作，而四楼的人在用 Slack，你完全不知道，也没法和他们分享。但当你去吃午饭时发生了什么？人们会说：“我们用了 Slack，太神奇了。”三楼的人就会说：“天哪，我们什么时候能用？” 砰，砰，砰。伟大的产品本身就是病毒性。

---

### [00:55:14] Lenny

**English:**
Seth Godin has this phrase they always come back to, if you want to make your product remarkable, something people want to remark about, and that's basically the core of word of mouth.

**中文翻译:**
Seth Godin 有句话经常被提起：如果你想让你的产品“卓越”（remarkable），就要让它成为人们想要“评论”（remark）的东西，这基本上就是口碑的核心。

---

### [00:55:23] Oji Udezue

**English:**
Yes, yes, yes.

**中文翻译:**
没错，没错。

---

### [00:55:24] Lenny

**English:**
I was watching a talk you did on this kind of topic and you had this great phrase that you sort of touched on, but I think it's so good, and I just want to make sure we highlight it, which is that virality is customer augmented marketing.

**中文翻译:**
我曾看过你关于这个话题的一次演讲，你用了一个很棒的短语，你刚才也提到了，但我认为它太经典了，我想特别强调一下：病毒性就是“客户增强型营销”（customer augmented marketing）。

---

### [00:55:36] Oji Udezue

**English:**
Yeah, I think it is the thing that I started with first. It's when your marketing is essentially done by your customers because what it does, it affords you the ability to spend less on marketing. And you can either uplevel your marketing execution or save money that you can put in the product. Atlassian spends maybe like 10, 20 percentage points less on marketing than the equivalent competitors because it's viral and also because it's network effects at this point as well, say Jira. And so it's customer augmented marketing. Your customers are either forcing other people to adopt it or shaming them into adopting it or FOMOing them into adopting it. So yes, virality is essentially customer oriented marketing, which gives you options.

**中文翻译:**
是的，这就是我一开始说的。当你的营销基本上由客户完成时，它让你有能力减少营销支出。你可以提升营销执行力，或者把省下的钱投入到产品中。Atlassian 在营销上的支出可能比同类竞争对手少 10 到 20 个百分点，因为它具有病毒性，而且像 Jira 这种产品现在还具有网络效应。所以这就是客户增强型营销。你的客户要么在强迫别人采用它，要么在通过“羞辱”或制造“错失恐惧症”（FOMO）来促使别人采用它。所以是的，病毒性本质上是以客户为导向的营销，它为你提供了更多选择。

---

### [00:56:28] Lenny

**English:**
I love that phrase, I'm going to use it now. I have just a few more questions before we get to a very exciting lightning round, and these are kind of random two topics that I wanted to chat on. One is this concept that you call forest time. It's a post you wrote about the importance of forest time. Can you just describe what that is and why it's so important, and then also just how to do this?

**中文翻译:**
我太喜欢这个短语了，我现在就要开始用它。在进入令人兴奋的闪电轮提问之前，我还有几个问题，是两个我想聊的随机话题。一个是被称为“森林时间”（forest time）的概念。你写过一篇关于森林时间重要性的文章。你能描述一下那是什么，为什么它如此重要，以及如何实施吗？

---

### [00:56:49] Oji Udezue

**English:**
I operate, I'm an operator right now, meaning that I'm building things, I work for a company. But I also advise and invest, which is different. When I'm advising, I'm looking from above, from outside, I have a bird's eye view and I'm able to say, "You know what? This will work. This won't work. What have you done? Can I look at the results?" And then cycle the advice based on what you're seeing and what I'm seeing. When I'm operating, I'm building a team, I'm hiring, I'm managing all the things, Alina, shout out that hates sometimes. And that's what I'm doing. When you are operating, you have the tug of war. It is so intense that you don't have the attention to have a bird's eye view constantly.

**中文翻译:**
我现在是一名运营者（operator），这意味着我在构建东西，我在为公司工作。但我也做顾问和投资，那是不同的。当我做顾问时，我是从上方、从外部观察，我拥有鸟瞰视角，我能说：“你知道吗？这个行得通，那个行不通。你做了什么？我能看看结果吗？”然后根据你我所见循环给出建议。而当我运营时，我在组建团队、招聘、管理所有琐事（向有时讨厌这些的 Alina 致敬）。这就是我正在做的事。当你处于运营状态时，你处于一种“拉锯战”中。它是如此激烈，以至于你没有精力去时刻保持鸟瞰视角。

---

### [00:57:39] Oji Udezue

**English:**
And so forest time is the idea that you make time within your week, within your month to see the forest for the trees. Most of the time when you're operating, you're seeing the tree, which is the problem in front of you. But sometimes you need to see the forest, so you can figure out it as an alternate path, different from the one that you are currently on your campaign. And so it's time to elevate, to get some bird's eye view, to see the entire landscape and see the alternative paths through the current problems that you're escaping. And I think that it has to be very intentional. And intentionality there is, I have published a workflow, a document that helps you make that step to make that elevation.

**中文翻译:**
所以“森林时间”的想法是，你在每周或每月抽出时间，为了看清森林而暂时离开树木。大多数时候当你运营时，你看到的是“树”，即眼前的具体问题。但有时你需要看到“森林”，这样你才能找到一条替代路径，不同于你目前正在进行的战役。所以这是提升高度、获得鸟瞰视角、观察整个格局并寻找解决当前问题替代路径的时间。我认为这必须是非常有意识的行为。这种意识体现在，我发布了一个工作流文档，帮助你完成这种高度的提升。

---

### [00:58:25] Oji Udezue

**English:**
Like what are the issues? What are alternative ways to solve this potentially that I'm not seeing? Et cetera. And what I try to do is I try to create that forest time for my executive team as well because it's not just me that suffers from this, it's most everybody. In fact, it's most PMs because PMs are so influential that the spoke of the wheel of product creation and product development that we often, it's a sine wave. You are discovering and shaping problems and then you are commanding and captaining execution. And it's endless and they're endless meetings. And so you need to create time for forest time, for elevation. If you don't, you'll become less effective over time. It's just attrition.

**中文翻译:**
比如：存在哪些问题？有哪些我没看到的替代解决方案？等等。我不仅为自己，也努力为我的高管团队创造这种“森林时间”，因为不仅是我，几乎所有人都会陷入其中。事实上，大多数 PM 也是如此，因为 PM 影响力巨大，是产品创造和开发轮盘上的辐条，我们经常处于一种正弦波状态：你在发现和塑造问题，然后你在指挥和领导执行。这是无止境的，还有开不完的会。所以你需要为“森林时间”和“高度提升”创造时间。如果你不这样做，随着时间的推移，你的效率会降低。这纯粹是内耗。

---

### [00:59:14] Lenny

**English:**
And then just to make it even more concrete for people, what are examples of forest time? Is it taking time off? Is it advising on the side? Is it-

**中文翻译:**
为了让大家更明白，森林时间的具体例子是什么？是休假吗？是做兼职顾问吗？还是——

---

### [00:59:20] Oji Udezue

**English:**
It is taking a day off at the end of a month, a full day or two days. And instead of just playing golf, although that's fine, it is doing a workflow, worksheet to survey the forest specifically. And sometimes managers are like, "Wait, you're giving people a day off when they should be working harder and harder?" And I think it's completely worth it. It's not about working harder, it's working smarter. It's about seeing more options than you see. And so I'm very happy to give that time to product managers, to product executives or design executives or engineering executives.

**中文翻译:**
是在月底休假一天，完整的一天或两天。而且不是去打高尔夫球（虽然那也行），而是通过一个工作流工作表来专门审视“森林”。有时经理们会说：“等等，在大家应该更努力工作的时候，你居然给他们放假？”我认为这完全值得。这不是关于更努力地工作，而是更聪明地工作。它是关于看到比你目前看到的更多的选择。所以我非常乐意把这段时间给产品经理、产品主管、设计主管或工程主管。

---

### [01:00:01] Oji Udezue

**English:**
Because I think that if they do it properly, then we'll have better execution in the long run. Let's put it this way, in product development, we aim for maybe like 10% of the time and then we execute and build for the other side. It's not just, there's more stuff we do. If your aim is off, then you are spending one, $2 million incorrectly of people's time. And so forest time should improve your aim. That's the entire point, because your aim is a precursor to a huge amount of investment. And so I think it's well worth it.

**中文翻译:**
因为我认为如果他们做得对，从长远来看，我们将拥有更好的执行力。这么说吧，在产品开发中，我们可能用 10% 的时间来“瞄准”，然后用剩下的时间来执行和构建。如果你瞄准歪了，那么你就是在错误地挥霍价值一两百万美元的人力时间。所以森林时间应该提高你的“瞄准精度”。这就是核心点，因为你的瞄准是后续巨额投资的前提。所以我认为这非常值得。

---

### [01:00:36] Lenny

**English:**
I love this. So specifically what you do with your team is once a month, you give them a day to do this kind of worksheet that you put together?

**中文翻译:**
我喜欢这个。所以具体来说，你对你的团队做的是：每月给他们一天时间来完成你编写的那种工作表？

---

### [01:00:45] Oji Udezue

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:00:45] Lenny

**English:**
And then that worksheet is in this post that you wrote, that you point to. Is that right?

**中文翻译:**
那个工作表就在你写的那篇文章里，对吧？

---

### [01:00:49] Oji Udezue

**English:**
Correct, correct.

**中文翻译:**
没错，没错。

---

### [01:00:50] Lenny

**English:**
Amazing. Okay, great. This is very practical advice. I love it. Okay, one last question before a very exciting lightning round. You worked at Bridgewater Associates, which I didn't know until I started digging into your past. That sounds creepy. And Bridgewater Associates famous for what? Ray Dalio's hedge fund, author of Principals and all these other incredible books, and it's a very unique working environment. So I just wanted to ask about your experience there, specifically one of the craziest things there is just this thing called dots I think it's called, where people just call out mistakes that people make at the company and it's public. Is that how it actually was? Any memories of that?

**中文翻译:**
太棒了。这是非常实用的建议。好的，在进入令人兴奋的闪电轮提问之前，最后一个问题。你曾在桥水基金（Bridgewater Associates）工作过，直到我开始研究你的背景我才知道（听起来有点像跟踪狂）。桥水基金以什么闻名？瑞·达利欧（Ray Dalio）的对冲基金，《原则》及其他神作的作者，那是一个非常独特的工作环境。所以我想问问你在那里的经历，特别是那里最疯狂的事情之一——好像叫“点点评”（dots），人们会公开指出同事犯的错误。实际情况是那样的吗？有什么回忆吗？

---

### [01:01:27] Oji Udezue

**English:**
Yeah, yeah. I was a senior management, what's called an SMA, which is the management layer right under Ray's team. And we were the priests of the Church of Bridgewater. Bridgewater did things like record, this is public knowledge, I'm not saying anything-

**中文翻译:**
是的。我当时是高级管理层，也就是所谓的 SMA，即紧挨着瑞·达利欧团队下方的管理层。我们就像是“桥水教”的祭司。桥水会做录音之类的事情，这是公开信息，我没泄密——

---

### [01:01:50] Lenny

**English:**
Yeah, he writes about-

**中文翻译:**
是的，他在书里写过。

---

### [01:01:51] Oji Udezue

**English:**
... before every meeting. Eventually we created a dot collector, which allows you to rate people in real time. So I'm just having a conversation with you and before the meeting closes, in front of each other, I pull up my laptop and I rate you and rate the interaction. And in theory, the idea is that if you constantly rate people across hundreds of interactions, then you build a picture of them that is fairly accurate, statistically accurate, that will transcend maybe emotional relationship as wisdom of the crowd idea. So that's a theory. In practice, it is emotionally exhausting. And like you said, the little creepy, even the recording.

**中文翻译:**
……在每次会议之前。最终我们创建了一个“点收集器”（dot collector），它允许你实时给别人打分。比如我正在和你交谈，在会议结束前，当着对方的面，我打开笔记本电脑给你打分，并给这次互动打分。理论上，这个想法是：如果你在数百次互动中不断给人们打分，你就能建立一个相当准确、统计学上精确的画像，这能超越情感关系，类似于“群体智慧”。这是理论。在实践中，这在情感上非常令人疲惫。而且就像你说的，有点毛骨悚然，连录音也是。

---

### [01:02:38] Oji Udezue

**English:**
So I think there were things about Bridgewater that I understood intellectually in terms of the purpose that Ray had designed, but didn't quite work. It's like the way I think about this is the theory of the principles are really good. The practice and the execution can be quite off and not very human or not very empathetic. But I will say this, Bridgewater taught me things that I don't think any other organization in the world thought taught me. One example is Bridgewater thinks of people in three dimensions, their skills, their attributes, and their values. Most organizations think about people in terms of just their skills. But it makes sense that people have attributes and values, that people are timid, people are bold, people like to jump in, people like to stand back.

**中文翻译:**
所以我认为，对于桥水的某些东西，我能从理智上理解瑞设计的初衷，但实际效果并不好。我的看法是：《原则》的理论非常好，但实践和执行可能非常偏差，不够人性化，也不够感同身受。但我必须说，桥水教会了我世界上其他任何组织都教不了的东西。一个例子是，桥水从三个维度看待人：技能（skills）、特质（attributes）和价值观（values）。大多数组织只考虑技能。但人确实有特质和价值观，有人胆小，有人大胆，有人喜欢冲锋陷阵，有人喜欢退后观察。

---

### [01:03:38] Oji Udezue

**English:**
All these other things, we think about personality and proclivity. Bridgewater tries to establish and measure them and also tries to write job descriptions that say, this is the kind of attributes we're looking for, not just the skills we're looking for. And then of course values. Are you a thief or are you a principled? And so on and so forth. Now that idea of looking at talent or people in general, both in your professional life and in your personal life, is a huge addition to me as a professional from Bridgewater. So I'm saying that there were things I didn't enjoy about Bridgewater, but things that I learned that I've learned nowhere else as well.

**中文翻译:**
所有这些事情，我们称之为性格和倾向。桥水试图建立并衡量它们，并尝试在职位描述中写明：我们寻找的是这种“特质”，而不仅仅是“技能”。当然还有价值观：你是个小偷还是个有原则的人？等等。这种看待人才或普通人的方式，无论是在职业生活还是个人生活中，都是桥水带给我的巨大财富。所以我想说，虽然桥水有些东西我不喜欢，但我学到的东西在别处也学不到。

---

### [01:04:18] Lenny

**English:**
Did you take that to what you do today? Thinking of people in those three different ways and-

**中文翻译:**
你把这些应用到今天的工作中了吗？以这三种不同的方式思考人……

---

### [01:04:23] Oji Udezue

**English:**
100%. in my professional life, in my personal life, when I interview people, I am cognizant of those three things and I try to extract those three things, because I think it improves your success. Famously, all the weird skill-based interviewing at Google was only 50/50 predictive. And the reason is Google did not consider the other two things, I believe. Bridgewater was willing to endure 80% attrition to arrive at the best people. Now I don't think it works for them because some of their system was not empathetic of humans, like expecting humans to be computers. But I thought that was a very important insight.

**中文翻译:**
100%。在我的职业和个人生活中，当我面试别人时，我会意识到这三点并尝试提取它们，因为我认为这能提高成功率。众所周知，谷歌那些古怪的基于技能的面试只有 50% 的预测准确率。我相信原因就是谷歌没有考虑另外两点。桥水愿意忍受 80% 的流失率来筛选出最优秀的人。虽然我不认为这完全奏效，因为他们的某些系统对人类缺乏共情，就像把人当成电脑一样。但我认为那是一个非常重要的洞察。

---

### [01:05:08] Lenny

**English:**
Awesome. Oji, is there anything else that you want to share before we get to our very exciting lightning round?

**中文翻译:**
太棒了。Oji，在进入令人兴奋的闪电轮之前，还有什么想分享的吗？

---

### [01:05:14] Oji Udezue

**English:**
In the history of product development, we have basically started to create abstraction to guide our work versus the Wild, Wild West. So the engineers came up with agile and peer programming and all these things. The designers have come up with design thinking, design sprints, and combined with research to talk about how to do discovery of various complexity. And the question is the product abstractions, because there's code, there's product in this business. So the product and business layer, what is our abstraction? What is our crucible for organizing our work?

**中文翻译:**
在产品开发的历史中，我们基本上已经开始创建抽象概念来指导我们的工作，而不是像以前那样杂乱无章。工程师们提出了敏捷开发、结对编程等。设计师们提出了设计思维、设计冲刺，并结合研究来讨论如何进行各种复杂程度的“发现”。问题在于“产品抽象”，因为业务中既有代码，也有产品。那么在产品和业务层，我们的抽象是什么？我们组织工作的“熔炉”是什么？

---

### [01:05:52] Oji Udezue

**English:**
We don't even have one. We don't have a name for it. And so the idea of a part system is that there's an abstraction above agile and design thinking that we have to pay attention to build solid organizations and to execute well at the product and the business layer. This is a co-creative framework with me and Ezinne. And the idea here is how do you construct a good product system? And literally, you could boil it down into a checklist of the systems you need to build a really good cohesive R and D organization. So I think that's the tee up. I'm going to have to leave you thirsty because someone else is probably going to go deep into it.

**中文翻译:**
我们甚至没有一个统一的称呼。所以“产品系统”（product system）的想法是，在敏捷和设计思维之上，存在一个我们必须关注的抽象层，以便建立稳固的组织并在产品和业务层执行良好。这是我和 Ezinne 共同创造的一个框架。核心思想是：你如何构建一个好的产品系统？字面上看，你可以将其简化为一个清单，列出建立一个真正优秀的、有凝聚力的研发组织所需的系统。这就是预告。我得先卖个关子，因为以后可能会有别人深入探讨这个话题。

---

### [01:06:35] Lenny

**English:**
Amazing. And that's your wife that you mentioned who you are co-creating this framework with and who we're going to have on the podcast in the future.

**中文翻译:**
太棒了。你提到的那位和你共同创造这个框架的人就是你的妻子，我们以后也会请她来播客。

---

### [01:06:40] Oji Udezue

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:06:41] Lenny

**English:**
What is it like being married to another product leader? Would you recommend?

**中文翻译:**
和另一位产品领导者结婚是什么感觉？你会推荐吗？

---

### [01:06:45] Oji Udezue

**English:**
100%, you can have really productive conversations and you can redesign other company's applications in one conversation in the evening.

**中文翻译:**
100% 推荐。你们可以进行非常有产出的对话，甚至可以在晚上的一个谈话中就重新设计出另一家公司的应用。

---

### [01:06:57] Lenny

**English:**
Amazing. Well, that was almost the lightning round question, but I moved it up earlier. And so with that we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。这本来快成闪电轮的问题了，但我提前问了。那么，我们现在进入令人兴奋的闪电轮。准备好了吗？

---

### [01:07:06] Oji Udezue

**English:**
Yeah, I'm ready. Let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:07:07] Lenny

**English:**
Okay, great. Let's do it. What are two or three books that you've recommended most to other people?

**中文翻译:**
好，开始。你向别人推荐最多的两三本书是什么？

---

### [01:07:13] Oji Udezue

**English:**
There's one business book that I recommend, I think it's called The Halo Effect. It's basically a book that lets you call on all these business books that tell you all kinds of stupid shit. It is how to deconstruct what is important in a business and self-help book and what is not important and what is just circumstantial storytelling with random facts and form-fitting evidence. It's called The Halo Effect. Read it. Why do you need to read it? Because garbage in, garbage Out.

**中文翻译:**
我推荐一本商业书，叫《光环效应》（The Halo Effect）。它基本上是一本能让你识破那些胡说八道的商业书的书。它教你如何解构商业书和成功学书籍中哪些是重要的，哪些是不重要的，哪些只是带有随机事实和牵强证据的偶然故事。去读读《光环效应》。为什么要读？因为“垃圾进，垃圾出”。

---

### [01:07:45] Oji Udezue

**English:**
People were amazed at the Outlier Effect, Malcolm Gladwell, and then people have been tearing it down for 15 years now. But everyone ingested it and thought it was the most important thing. But how do you know what's important to take away from them and what's not? The Halo Effect will help you. And then the other thing is, I read for pleasure because I read a lot for work. And so science fiction is the thing. There's lots to recommend, but I would say that people should either read Dune, Frank Herbert or Foundation by Asimov. If you haven't read those two things and you're a science fiction person, you really should. The world building is incredible. I understand Tolkien and fantasy, but the science fiction side of it is those two books.

**中文翻译:**
人们曾对马尔科姆·格拉德威尔的《异类》感到惊叹，但过去 15 年里人们一直在拆穿它。但每个人都吸收了它，并认为它是最重要的。但你如何知道该从中吸取什么，不该吸取什么？《光环效应》会帮你。另外，因为工作读得太多，我平时为了消遣而阅读。科幻小说是我的最爱。有很多推荐，但我会说人们应该读读弗兰克·赫伯特的《沙丘》（Dune）或阿西莫夫的《基地》（Foundation）。如果你是个科幻迷却没读过这两部，那你真的该读读。其世界观构建令人叹为观止。我理解托尔金和奇幻文学，但科幻文学的巅峰就是这两本书。

---

### [01:08:32] Lenny

**English:**
There's also a TV series of Foundation now, which I can say recommend absolutely. But it's a beautiful show.

**中文翻译:**
现在也有《基地》的电视剧了，我绝对推荐，拍得很美。

---

### [01:08:39] Oji Udezue

**English:**
Yeah, no. I haven't watched Foundation yet. I just felt super weird watching it after reading it. And I could only make it through three quarters of Dune. Well one, but I will make it through them. I don't expect them... The books are glorious. If you love prose, the books are, man, crazy. But I will get through them eventually.

**中文翻译:**
还没看。读完原著后再看剧感觉怪怪的。我只看了四分之三的《沙丘》（第一部），但我会看完的。我不指望剧能……原著太辉煌了。如果你喜欢散文般的文笔，那些书简直太疯狂了。但我最终会看完它们的。

---

### [01:09:04] Lenny

**English:**
I've not actually read Dune, but the movie was incredible. I played the video game Dune where you're just mining spice all day and it's just stuck in my brain forever. Okay, next question. What is a favorite interview question that you like to ask candidates that you're interviewing?

**中文翻译:**
我其实没读过《沙丘》，但电影太棒了。我玩过《沙丘》的游戏，整天都在采矿，那画面永远留在我脑海里。好，下一个问题。你面试候选人时最喜欢问的问题是什么？

---

### [01:09:18] Oji Udezue

**English:**
I try to ask two. I feel like it's going to give people a cheat sheet when I interview them. But I try to ask two questions. So I'm not a person who does favorites, so it's hard for me to pick favorites. But I ask people to introduce themselves and I think it tells me a lot about them, how they tell about themselves, what they say about themselves and the content of it. I ask people about the things they think they're truly great at and then I ask people the things they think they need to learn. The latter too is about their professional skill, their craft. I think it tells me a lot about how they communicate, it tells me a lot about how thoughtful they are. It tells me a lot about what they're proud of and what they lead into. And those kinds of things are very important to me.

**中文翻译:**
我通常问两个。我觉得这会给以后被我面试的人提供“小抄”。我不喜欢选“最喜欢”，所以很难挑。但我会请人们介绍自己，我认为这能告诉我很多关于他们的信息：他们如何描述自己，他们说了什么，以及内容本身。我会问他们认为自己真正擅长什么，然后问他们认为自己需要学习什么。后者关乎他们的专业技能和手艺。我认为这能反映他们的沟通方式、思考深度，以及他们引以为豪和投入精力的地方。这些对我来说非常重要。

---

### [01:10:10] Lenny

**English:**
What is a favorite product you recently discovered that you love?

**中文翻译:**
你最近发现并喜爱的产品是什么？

---

### [01:10:13] Oji Udezue

**English:**
I have been optimizing my workspace a lot. So I'm on a kick right now where I use Windows. I was in the Windows PM and I still have my Windows box. But a lot of people, we use Mac at work and I've used Mac for the last few years. So even though I switched between them, I've spent a lot more time on Mac and my Windows experience is completely optimized. It is perfect. But Mac, I'm like the Windowing sucks, there's all these gaps I see. So I've been trying to figure out how to dial in my Mac experience.

**中文翻译:**
我最近一直在优化我的工作空间。我现在有点迷恋使用 Windows。我曾是 Windows 的 PM，现在还有 Windows 电脑。但很多人在工作中使用 Mac，我过去几年也一直在用 Mac。所以尽管我在两者间切换，我在 Mac 上花的时间更多，而我的 Windows 体验已经完全优化好了，非常完美。但对于 Mac，我觉得窗口管理很烂，有很多缺陷。所以我一直在尝试如何调整我的 Mac 体验。

---

### [01:10:49] Oji Udezue

**English:**
I hate the activity monitor, sucks. What's a replacement? The sound. It doesn't support sound through HDMI or sound through... I don't know, just some weird setup. So I've been optimizing that. One particular product that I like in the context of that is Unlocks. It's one man product that allows me to just look at my phone and log into my Mac when I walk up and then locks it when I walk away. And it'll actually detect my proximity. So it'll start the login process while I get close. I think that's incredible and I feel like it improves my productivity.

**中文翻译:**
我讨厌活动监视器，太难用了。有什么替代品吗？还有声音，它不支持通过 HDMI 输出声音或者……总之就是一些奇怪的设置。所以我一直在优化。在这个背景下，我特别喜欢的一个产品叫 Unlocks。这是一个独立开发者的产品，它让我只需看一眼手机，当我走近时就能登录 Mac，当我走开时它会自动锁定。它实际上能检测我的距离，当我靠近时就开始登录过程。我觉得这太不可思议了，它提高了我的生产力。

---

### [01:11:26] Lenny

**English:**
Very cool. Sounds like a lot of haterade for Macs over here.

**中文翻译:**
很酷。听起来你对 Mac 有不少怨言啊。

---

### [01:11:30] Oji Udezue

**English:**
Well, for someone who uses it a lot, no, I think pros and cons. I'm no longer paid by Microsoft, so there are things I don't like. But there are also things that the Mac isn't perfect either.

**中文翻译:**
作为一个经常使用它的人，不，我觉得各有优缺点。我现在不拿微软的工资了，所以有些东西我不喜欢。但 Mac 也并不完美。

---

### [01:11:42] Lenny

**English:**
Yeah, indeed. What is a favorite life motto that you repeat to yourself or share with other people, either in work or in life that you find valuable?

**中文翻译:**
确实。你有没有什么经常对自己说或与他人分享的人生格言？无论是在工作还是生活中，你觉得很有价值的那种。

---

### [01:11:52] Oji Udezue

**English:**
I've taken to saying that there's more knowledge outside my head than inside it. And this is a plea for curiosity. I have three main things that are my North Star personally. Obviously when I say personally, I mean everything professionally. Which is originality, curiosity, and wisdom. And so this thing about there's more knowledge outside my head than inside my head is a plea for curiosity, it's a plea for skepticism. It's a plea to be humble about what you know, no matter how old you are, about the world around you, and always be listening for more. Even when you know something, let other people speak because they might add 10% more to the 90% you know. And so being an active listener is very important.

**中文翻译:**
我常说：“我脑壳外的知识比脑壳里的多。”这是一种对好奇心的呼唤。我有三个核心的人生指南（当然也包括职业生涯）：原创性、好奇心和智慧。所以“脑外的知识比脑内多”是对好奇心和怀疑精神的呼唤。它提醒我们要对所知保持谦逊，无论你多大年纪，都要对周围的世界保持谦虚，并始终倾听更多。即使你已经知道了一些事情，也要让别人说话，因为他们可能会为你已知的 90% 增加 10% 的新见解。所以，做一个积极的倾听者非常重要。

---

### [01:12:48] Lenny

**English:**
Beautiful. Last question, you are from Nigeria. What is a Nigerian food that you think people need to find and get ASAP?

**中文翻译:**
太美了。最后一个问题，你来自尼日利亚。你认为人们应该尽快去尝试的尼日利亚美食是什么？

---

### [01:12:57] Oji Udezue

**English:**
I'll recommend two, depending on how familiar you are. So if you've never had fried plantain with beef stew-

**中文翻译:**
我会根据你的熟悉程度推荐两种。如果你从未吃过“炸大蕉配炖牛肉”（fried plantain with beef stew）——

---

### [01:13:06] Lenny

**English:**
Oh man, that sounds great.

**中文翻译:**
天哪，听起来太棒了。

---

### [01:13:08] Oji Udezue

**English:**
... then you should stop what you're doing, stop work, whatever you're doing, find your next Nigerian friend and go get some, okay? This is the food that most Nigerians will basically trade years of life to have access to, okay. So that's what I would say. And then the second thing is if you want to be in the in club in Nija, as we call it, you got to try pepper soup.

**中文翻译:**
……那你应该停下手里的一切，停止工作，不管你在做什么，去找个尼日利亚朋友带你去吃，好吗？这是大多数尼日利亚人愿意用几年寿命去换取的美味。这是第一种。第二种是，如果你想进入我们所说的尼日利亚“圈内人”俱乐部，你必须尝试“胡椒汤”（pepper soup）。

---

### [01:13:48] Lenny

**English:**
Pepper soup.

**中文翻译:**
胡椒汤。

---

### [01:13:48] Oji Udezue

**English:**
Now, if you all are not into spicy stuff, I'm sorry, the door is close to you. But pepper soup is really... And it is amazing. It'll make you sweat, but it's delicious and you should give it a shot.

**中文翻译:**
如果你不爱吃辣，那抱歉，这扇门对你关闭了。但胡椒汤真的很……太神奇了。它会让你流汗，但非常美味，你应该尝试一下。

---

### [01:14:05] Lenny

**English:**
Oji, I think we've solved many people's sharp problems. I really appreciate you making time being here. Two final questions. Where can folks find you online if they want to reach out? And how can listeners be useful to you?

**中文翻译:**
Oji，我想我们已经解决了很多人的“尖锐问题”。非常感谢你抽时间来到这里。最后两个问题：如果大家想联系你，可以在哪里找到你？以及听众可以为你做些什么？

---

### [01:14:16] Oji Udezue

**English:**
I publish on Substack when I have time, you should check it out. It's usually all about things that are beneath the surface. What's behind the thing. I believe that's how you'll find it. I'm on Twitter as well, so you can follow me because I will talk about products. How you can be useful to me is go follow me on Twitter, sign up for updates on the book. If you do, I will draw from that audience to help name the book, to help design the cover for the book. The book is intended to have a freemium because I want this book to be available to people in Africa and India, across the world.

**中文翻译:**
我有空会在 Substack 上发表文章，你可以去看看。通常是关于事物表象之下的东西，即背后的原理。我相信你能找到。我也在 Twitter 上，你可以关注我，我会聊聊产品。你可以帮我的是：去 Twitter 关注我，订阅我新书的更新。如果你这样做了，我会从受众中征求意见来帮书命名、设计封面。这本书打算采用“免费增值”模式，因为我希望非洲、印度以及全世界的人都能读到它。

---

### [01:15:29] Oji Udezue

**English:**
So there'll be a free version of it and there'll be premium versions with more tools, more help, and maybe even interviews with luminaries that you care and love as well. And so hopefully that will fund the free side of it as well. So come in, become part of the party, maybe join a pre-read, an early draft read. That is the best way you can help. So this is a call to all PMs and people of goodwill.

**中文翻译:**
所以会有一个免费版本，也会有包含更多工具、更多帮助、甚至包含你喜爱的泰斗级人物访谈的付费版本。希望能以此资助免费版。所以，来加入我们吧，也许可以参加预读或早期草稿阅读。这是你能提供的最好帮助。这是对所有 PM 和善意人士的号召。

---

### [01:14:36] Lenny

**English:**
Amazing. What a great answer to that question. I'm going to go get some pepper soup and some plantain beef meals. Thank you so much for being here, and I'm going to go get some food.

**中文翻译:**
太棒了。这个回答真好。我要去弄点胡椒汤和炸大蕉牛肉餐了。非常感谢你能来，我要去吃东西了。

---

### [01:15:41] Oji Udezue

**English:**
All right. Thank you, Lenny. It was super enjoyable and love hanging out and God speed.

**中文翻译:**
好的。谢谢你，Lenny。聊得很开心，祝一切顺利。

---

### [01:15:48] Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。