# Paige Costello - 双语对照

This is the complete bilingual transcript for **Lenny's Podcast** featuring **Paige Costello** (Product Lead at Asana).

---

### [00:00:00] Lenny

**English:**
You're often the youngest person in the room. What have you learned about how to garner trust and win over skeptics?

**中文翻译:**
你经常是房间里最年轻的人。关于如何赢得信任并说服那些持怀疑态度的人，你学到了什么？

---

### [00:00:07] Paige Costello

**English:**
The thing I would say is bring the insight. Know thy customer. Know thy market. Know thy competitors. Know thy numbers. Know thy product.

**中文翻译:**
我想说的是：带来洞见。了解你的客户，了解你的市场，了解你的竞争对手，了解你的数据，了解你的产品。

---

### [00:00:15] Lenny

**English:**
I'm curious, what you find most holds back new PMs?

**中文翻译:**
我很好奇，你发现最阻碍新任产品经理（PM）进步的因素是什么？

---

### [00:00:19] Paige Costello

**English:**
Your brain is so accustomed to having a scarcity mindset as opposed to creating alternative options or seeing a different path. Effectively, there's this notion of, "How might the opposite be true?" The moment I challenged myself and said, "How might the opposite be true?" my shoulders dropped. I felt more relaxed. I was like, "Oh, yeah, I can do both. It will be fine."

**中文翻译:**
你的大脑太习惯于“匮乏心态”（scarcity mindset），而不是去创造替代方案或看到不同的路径。实际上，有这样一个概念：“相反的情况如何可能也是真的？”当我挑战自己并问“相反的情况如何可能也是真的？”那一刻，我的肩膀放松了。我感到更轻松了。我想，“哦，是的，我可以两者兼顾。没问题的。”

---

### [00:00:45] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today, my guest is Paige Costello. Paige is a product lead at Asana overseeing teams responsible for the core product experience of Asana. Before Asana, she was Director of Product at Intercom, and prior to that, she was a group product manager at Intuit where she spent five and a half years. In our wide-ranging conversation, we dig into strategies for building trust with people who are more experienced than you or older than you, we talk about coaching product managers, including why leading by example is often the most effective strategy, we talk about Asana's product development process and how it's evolved over the years as the company has scaled, plus some of Paige's product and career missteps, and what she's learned from those moments. To prep for this interview, I got input from some of Paige's colleagues and former colleagues, and everyone I talked to loved Paige. You'll soon see why. Enjoy this episode with Paige Costello after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中辛苦换来的经验。今天的嘉宾是 Paige Costello。Paige 是 Asana 的产品负责人，负责监督 Asana 核心产品体验的团队。在加入 Asana 之前，她是 Intercom 的产品总监，在此之前，她在 Intuit 担任了五年半的团队产品经理（Group PM）。在我们广泛的对话中，我们深入探讨了如何与比你更有经验或年长的人建立信任的策略；我们讨论了如何辅导产品经理，包括为什么“以身作则”通常是最有效的策略；我们还聊到了 Asana 的产品开发流程，以及随着公司规模扩大，这一流程多年来是如何演变的；此外，我们还讨论了 Paige 在产品和职业生涯中的一些失误，以及她从这些时刻中学到了什么。为了准备这次采访，我征求了 Paige 的一些现任和前任同事的意见，我交谈过的每个人都非常喜欢 Paige。你很快就会明白原因。在听完赞助商的简短介绍后，请欣赏本期与 Paige Costello 的对话。

---

### [00:01:47] Lenny

**English:**
Today's episode is brought to you by Brave Search and their newest product, the Brave Search API, an independent global search index you can use to power your search or AI apps. If your work involves AI, then you know how important new data is to train your LLMs and to power your AI applications. You might be building an incredible AI product, but if you're using the same data sets as your competitors to train your models, you don't have much of an advantage. Brave Search is the fastest growing search engine since Bing, and it's 100% independent from the big tech companies. Its index features billions of pages of high-quality data from real humans, and it's constantly updated thanks to being the default search engine in the Brave browser. If you're building products with search capabilities, you're probably experiencing soaring API costs or lack of viable global alternatives to Bing or Google. It's only going to become harder to afford these challenges. The Brave Search API gives you access to its novel web scale data with competitive features, intuitive structuring, and affordable costs. AI devs will particularly benefit from data containing thorough coverage of recent events. Lenny's Podcast listeners can get started testing the API for free at brave.com/lenny. That's brave.com/lenny.

**中文翻译:**
本期节目由 Brave Search 及其最新产品 Brave Search API 赞助。这是一个独立的全球搜索索引，你可以用它来驱动你的搜索或 AI 应用。如果你的工作涉及 AI，那么你一定知道新数据对于训练大语言模型（LLM）和驱动 AI 应用有多重要。你可能正在构建一个了不起的 AI 产品，但如果你使用与竞争对手相同的数据集来训练模型，你就没有太多优势。Brave Search 是自 Bing 以来增长最快的搜索引擎，并且 100% 独立于大型科技公司。它的索引包含来自真实人类的数十亿页高质量数据，并且由于它是 Brave 浏览器的默认搜索引擎，因此会不断更新。如果你正在构建具有搜索功能的产品，你可能正在经历 API 成本飙升，或者缺乏除 Bing 或 Google 之外的可行全球替代方案。应对这些挑战只会变得越来越难。Brave Search API 让你能够以具有竞争力的功能、直观的结构和实惠的价格访问其新颖的网络规模数据。AI 开发者将特别受益于涵盖近期事件的详尽数据。Lenny 播客的听众可以访问 brave.com/lenny 免费开始测试该 API。网址是 brave.com/lenny。

---

### [00:03:04] Lenny

**English:**
This episode is brought to you by Attio, a new type of CRM that's powerful, flexible, and built around your data. Traditional CRMs were built for a different era with totally different speed, scale, and data demands. Attio is different. It allows you to quickly build a CRM that matches your unique workflows and data structures. Within minutes of connecting your email and calendar, you'll have a CRM that's already set up complete with customer profiles and automatic data enrichment. You'll also have real-time dynamic reporting at your fingertips. No more slow deployments, outdated user experiences, or tedious manual data input. With Attio, you can build and adapt your CRM on the fly no matter your business model or company stage. Attio is the CRM for fast-growing startups. Get started today and get 15% off your first year at attio.com/lenny. That's A-T-T-I-O.com/lenny.

**中文翻译:**
本期节目由 Attio 赞助。Attio 是一种新型 CRM，功能强大、灵活，且围绕你的数据构建。传统的 CRM 是为另一个时代构建的，其速度、规模和数据需求完全不同。Attio 则不同。它允许你快速构建一个符合你独特工作流和数据结构的 CRM。在连接你的电子邮件和日历后的几分钟内，你就会拥有一个已经设置好的 CRM，包含完整的客户档案和自动数据增强功能。你还可以随时获得实时动态报告。不再有缓慢的部署、过时的用户体验或繁琐的手动数据输入。有了 Attio，无论你的业务模式或公司处于什么阶段，你都可以随时构建和调整你的 CRM。Attio 是为快速增长的初创公司准备的 CRM。今天就开始使用，并在 attio.com/lenny 享受首年 85 折优惠。网址是 A-T-T-I-O.com/lenny。

---

### [00:04:05] Lenny

**English:**
Paige, welcome to the podcast.

**中文翻译:**
Paige，欢迎来到播客。

---

### [00:04:07] Paige Costello

**English:**
Thanks, Lenny. Great to be here.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。

---

### [00:04:08] Lenny

**English:**
So you don't know this, and I've been telling you this, but I asked a bunch of people that you worked with and maybe currently work with for questions, suggestions of things to ask you. So this is going to be really fun.

**中文翻译:**
你可能不知道，我刚才也跟你提过，我问了一群曾与你共事或目前正在共事的人，请他们提供一些想问你的问题和建议。所以接下来的对话会非常有趣。

---

### [00:04:19] Paige Costello

**English:**
Wonderful. Now, I want to know who you talked to, but we'll find out.

**中文翻译:**
太棒了。现在我想知道你都找谁聊了，不过我们待会儿就会揭晓。

---

### [00:04:23] Lenny

**English:**
I'll tell you right now. Big thank you to Jackie Bavaro, Yasmin who's on your team, and Montgomery and Steve Morin who is currently at Asana.

**中文翻译:**
我现在就告诉你。非常感谢 Jackie Bavaro、你团队中的 Yasmin，还有 Montgomery 以及目前在 Asana 的 Steve Morin。

---

### [00:04:32] Paige Costello

**English:**
Ooh, fun.

**中文翻译:**
噢，有意思。

---

### [00:04:33] Lenny

**English:**
So thank you to all of those folks for giving me a bunch of great questions, suggestions.

**中文翻译:**
所以感谢这些人给我提供了这么多棒极了的问题和建议。

---

### [00:04:37] Paige Costello

**English:**
Looking forward to it.

**中文翻译:**
非常期待。

---

### [00:04:38] Lenny

**English:**
Maybe just to settle a context, can you just talk about... At Asana, what do you work with? What is your team? What do you work on, and what is your team responsible for broadly?

**中文翻译:**
也许为了交代一下背景，你能谈谈……在 Asana，你负责什么？你的团队是什么样的？你具体做哪些工作，你的团队大致负责什么？

---

### [00:04:45] Paige Costello

**English:**
Yeah. Absolutely. So I lead the product organization that's responsible for our desktop, web, and mobile apps at Asana. The teams are composed of all the people in San Francisco and New York who are focused on creating clarity for individuals, teams, and organizations. Effectively, our goal is to help teams work together more efficiently and drive the outcomes they're going for. So you can think about the feature sets if you're an Asana user like goals, portfolios, projects, tasks, reporting, all of that. But really, we want to help people answer the question at work, "Who is doing what by when, and why?" So that notion of clarity of purpose, clarity of plan, progress, and responsibility are often so painful in people's work lives. When there is certainty there and clarity there, people can be much more efficient in getting the work done. So that's where my focus is every day. I'm a product leader for that group.

**中文翻译:**
好的，没问题。我领导的产品部门负责 Asana 的桌面端、网页端和移动端应用。团队由旧金山和纽约的所有成员组成，他们专注于为个人、团队和组织创造“清晰度”（clarity）。实际上，我们的目标是帮助团队更高效地协作，并推动他们实现预期的成果。如果你是 Asana 用户，你可以联想到这些功能集：目标（goals）、组合（portfolios）、项目（projects）、任务（tasks）、报告（reporting）等等。但本质上，我们想帮助人们回答工作中的一个问题：“谁在什么时候之前做什么，以及为什么要这么做？”这种关于目标清晰度、计划清晰度、进度和责任清晰度的概念，在人们的工作生活中往往是很痛苦的。当这些事情有了确定性和清晰度时，人们完成工作的效率会高得多。这就是我每天关注的重点。我是该部门的产品负责人。

---

### [00:05:44] Lenny

**English:**
Cool. So, basically, like the core. When people think of Asana, it's all of that stuff is what it sounds like.

**中文翻译:**
酷。所以基本上就是核心部分。听起来当人们想到 Asana 时，想到的就是这些东西。

---

### [00:05:49] Paige Costello

**English:**
Yeah, yeah. There's another group that's focused on our process management, but a lot of the core work in project management, core is in my group, and then we have a growth and enterprise scale team.

**中文翻译:**
是的。还有另一个小组专注于流程管理，但项目管理中的大部分核心工作都在我的组里，此外我们还有一个增长和企业规模化团队。

---

### [00:06:01] Lenny

**English:**
You've been at Asana for about four years now, right?

**中文翻译:**
你在 Asana 待了大约四年了吧？

---

### [00:06:03] Paige Costello

**English:**
Yes, four years this summer.

**中文翻译:**
是的，到今年夏天就满四年了。

---

### [00:06:04] Lenny

**English:**
Cool. So something I'm always curious about companies that are at this scale is just the evolution they've gone through in terms of how they develop product, and so I'm curious, just in the time you've been there, how has the product development process at Asana changed, and maybe even simpler, what are some of the bigger changes that have been made to the way product is built at Asana over the years?

**中文翻译:**
酷。对于这种规模的公司，我一直很好奇他们在产品开发方式上经历了怎样的演变。所以我很好奇，在你任职期间，Asana 的产品开发流程发生了怎样的变化？或者更简单点说，多年来 Asana 构建产品的方式有哪些重大的改变？

---

### [00:06:26] Paige Costello

**English:**
I would talk a little bit about how we set strategy and our planning process, and how that's changed in this time as well as how we actually ship product has changed in this time. On the planning front, we have really changed what altitudes we're planning at, the time horizon we're planning at. Some of the inputs have gotten a lot more precise and opinionated. So, for example, we have always had pillar plans and team plans, but maybe we didn't have an intermediary layer of an area perspective. Well, what's an area perspective? Well, as your organization grows, we've had to reorganize to create more agency and accountability close to teams that are focused on specific target customers and problems. So if you think about the way Asana is organized, we've got our R&D, the pillar structure, the areas within them, and then the working teams.

**中文翻译:**
我想谈谈我们如何制定战略和规划流程，以及这段时间里这些方面是如何变化的，还有我们实际交付产品的方式发生了哪些变化。在规划方面，我们确实改变了规划的“高度”（altitudes）和时间跨度。一些输入信息变得更加精确且具有明确的观点。例如，我们一直有“支柱计划”（pillar plans）和“团队计划”（team plans），但以前可能没有“领域视角”（area perspective）这一中间层。那么什么是领域视角呢？随着组织的发展，我们必须进行重组，以便在专注于特定目标客户和问题的团队附近创造更多的自主权和问责制。如果你思考一下 Asana 的组织方式，我们有研发部门（R&D）、支柱结构（pillar structure）、支柱内的领域（areas），然后是具体的工作团队。

---

### [00:07:23] Lenny

**English:**
It might actually help if you even describe what is a pillar, what is an area in product development.

**中文翻译:**
如果你能描述一下在产品开发中什么是“支柱”（pillar），什么是“领域”（area），可能会更有帮助。

---

### [00:07:27] Paige Costello

**English:**
Yeah. Absolutely. So when I said I'm responsible for that core product pillar, that's one pillar, but then there's also the adoption and enterprise scale pillar and the workflow pillar. Within each of those, there are subgroups, and we call those areas. Each of those areas has a very specific target customer and problem space they're solving for. We've often also dialed up the clarity of the metric at that level. So while we have an R&D set of metrics, we have pillar metrics, we have area metrics, and then at the team level, there's often one or two that they're really driving forward. So you can think of it as a nested structure around our product strategy as well as how we measure success. When I joined, we didn't have areas. We were organized around projects and around locations, and then we worked to make sure that the thinking was more durable and problem-focused so that our roadmaps were not about features, but were instead about what was most meaningful to tackle for our business growth. So that's a big thing that has changed is the altitude of planning and how that nests. Another thing that has changed is the time horizon. So, before, we planned annually primarily. Now, we plan every six months, but for a rolling 12 months. So we have higher confidence in the immediate half, lower confidence in the following half, but we just plan every 12 months, every six months because it gives our business more confidence in what's coming and a better opportunity to align our go-to-market and product planning.

**中文翻译:**
好的。当我提到我负责“核心产品支柱”时，那是其中一个支柱，此外还有“采用与企业规模化支柱”和“工作流支柱”。在每个支柱内部，都有子小组，我们称之为“领域”。每个领域都有非常明确的目标客户和他们要解决的问题空间。我们通常也会提高该层级指标的清晰度。因此，虽然我们有一套研发指标，但我们也有支柱指标、领域指标，而在团队层级，通常会有一两个他们真正推动的指标。所以你可以把它看作是一个围绕产品战略以及我们如何衡量成功的嵌套结构。我刚加入时，我们还没有“领域”。我们是围绕项目和地理位置组织的，后来我们努力确保思考更加持久且以问题为中心，这样我们的路线图就不再是关于功能，而是关于对业务增长最有意义的挑战。所以，规划的高度及其嵌套方式是一个巨大的变化。另一个变化是时间跨度。以前，我们主要进行年度规划。现在，我们每六个月规划一次，但规划的是未来滚动的 12 个月。这样我们对最近的半年有更高的信心，对后半年信心稍低，但我们每六个月就规划未来 12 个月，因为这让业务部门对未来更有信心，并能更好地对齐我们的进入市场（GTM）和产品规划。

---

### [00:09:10] Lenny

**English:**
Amazing. So I just actually was talking to one of the heads of product at Shopify, and they went through a similar transition where they used to plan yearly, and now they plan for the next six months. So it's interesting that I'm hearing this more and more, and you're saying that every six months, you revisit the plan for the next year. So it's an interesting hybrid of those two.

**中文翻译:**
太棒了。我最近刚和 Shopify 的一位产品负责人聊过，他们也经历了类似的转变，以前是年度规划，现在是规划未来六个月。很有趣，我听到越来越多公司这么做，而你是说每六个月重新审视未来一年的计划。所以这是这两者之间一个有趣的混合体。

---

### [00:09:30] Paige Costello

**English:**
Yeah. Absolutely. I think the more you try to do things in a joined up way where you have a single target customer with sales and marketing, and you want to make sure that the impact of your releases hit their mark, the more it's important to reflect on it frequently and to be able to pivot quickly because our strategy, even when we think we have a two-year vision, something will change, and then we say, "Wow, we made so much faster progress on this than we thought, and we actually believe that there's a new opportunity or a new technology that we should be leveraging. Let's go bigger on that." So it reduces the feeling of churn and thrash. It makes us all more principled, and it helps us just make sure we're making the best use of our teams.

**中文翻译:**
是的，没错。我认为，当你越是尝试以协同的方式做事——比如与销售和市场部门针对同一个目标客户，并确保发布的影响力达到预期——频繁反思并能够快速转向就越重要。因为即使我们认为自己有一个两年的愿景，战略也会发生变化，然后我们会说：“哇，我们在这方面的进展比预想的快得多，我们实际上认为有一个新的机会或新技术值得利用。让我们加大投入吧。”这样可以减少那种反复折腾和混乱的感觉。它让我们更有原则，并帮助我们确保团队得到了最有效的利用。

---

### [00:10:20] Lenny

**English:**
I like that it also admits you're not going to actually have a yearly plan, like everyone plans for year, and then halfway through, they're like, "No. Let's start rethinking everything again."

**中文翻译:**
我喜欢这种做法，因为它承认了你实际上不会有一个一成不变的年度计划。就像每个人都做年度计划，但到了一半时，他们会说：“不，让我们重新考虑一切。”

---

### [00:10:30] Paige Costello

**English:**
Yeah, yeah.

**中文翻译:**
没错。

---

### [00:10:30] Lenny

**English:**
So I like that you're upfront about that.

**中文翻译:**
所以我喜欢你对此表现得如此坦诚。

---

### [00:10:30] Paige Costello

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:10:31] Lenny

**English:**
Okay, and then within the plan, do you have quarterly plans and sprints? Is there anything more fine-grained with a detailed roadmap just while we're on the topic?

**中文翻译:**
好的，那么在计划之内，你们有季度计划和冲刺（sprints）吗？既然聊到这个话题，有没有更细颗粒度的详细路线图？

---

### [00:10:38] Paige Costello

**English:**
Yeah, not really. I mean, teams know approximately when are they expecting to do the work, but if you ask too much for a particular quarter, a particular week, or date, you will make strange choices about scope. So, really, we align on what success looks like, and the teams do their best job to ship as quickly as possibly, as iteratively as possibly, and we really encourage prototyping. So we added into our product process a notion that we might pivot or cut from stuff that we put on our roadmap because it felt like once it was on the roadmap, it had to be done, and that's just not smart.

**中文翻译:**
并没有。我的意思是，团队大致知道什么时候该做什么工作，但如果你对特定的季度、周或日期要求得太死，你就会在范围（scope）上做出奇怪的选择。所以，实际上我们是在“成功是什么样子的”这一点上达成一致，然后团队尽最大努力尽可能快地、迭代地交付产品，我们非常鼓励做原型（prototyping）。因此，我们在产品流程中加入了一个概念：我们可能会对路线图上的内容进行转向或削减。因为以前感觉一旦上了路线图就必须完成，而这并不明智。

---

### [00:11:20] Lenny

**English:**
Got it. So, essentially, there's a six-month roughly detailed plan of what each team is going to work on?

**中文翻译:**
明白了。所以本质上，每个团队都有一个大约六个月的详细计划，规定了要做什么？

---

### [00:11:25] Paige Costello

**English:**
Yeah, yeah.

**中文翻译:**
是的。

---

### [00:11:25] Lenny

**English:**
Got it. Interesting.

**中文翻译:**
明白，很有趣。

---

### [00:11:26] Paige Costello

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:11:26] Lenny

**English:**
Maybe just a couple more things just to make them super concrete for folks that might be listening. What's an example of an area? What's an actual team that would be an area? Then, the other question I have just while I'm saying questions is, are there some metrics you could share of just what some of these teams might be gold on just as examples of how you think about metrics?

**中文翻译:**
为了让听众听得更具体，我再多问几个问题。能举一个“领域”（area）的例子吗？什么样的实际团队会被称为一个领域？另外，我想顺便问一下，你能不能分享一些这些团队的目标指标（metrics），作为你们如何思考指标的例子？

---

### [00:11:45] Paige Costello

**English:**
The area that came to mind when you asked about one of our areas is something called Coordinate, and their job is effectively making sure that the slice of Asana that helps teams work together is working effectively. So that's projects, and tasks, and the data that you might put into tasks, and all of the back and forth that is required when people use Asana for their core working team. Some of the metrics that they care about are like org paying weekly active users as well as really thinking about healthy project use. So we make sure that we understand what does good look like and what is a dynamic that we want to be creating in terms of people getting real value from using the product, and we build that into our metrics to have as a guardrail to ensure that we're not driving one metric at the expense of people really getting what they need out of Asana.

**中文翻译:**
当你问到我们的一个领域时，我想到的是一个叫“Coordinate”（协作）的领域。他们的工作实际上是确保 Asana 中帮助团队协作的那部分功能有效运行。这包括项目、任务、你可能放入任务中的数据，以及人们在核心工作团队中使用 Asana 时所需的所有往复沟通。他们关注的一些指标包括组织付费周活跃用户（WAU），以及真正思考“健康的项目使用”。因此，我们确保自己理解什么是“好”，以及我们希望在用户从产品中获得真实价值方面创造什么样的动态。我们将这些纳入指标中作为护栏，以确保我们不会为了追求某个指标而牺牲用户从 Asana 中获得真正需求的能力。

---

### [00:12:41] Lenny

**English:**
Just a couple more questions along these lines. I'm nerd-sniped about process.

**中文翻译:**
关于这方面我还有几个问题。我对流程这类话题非常着迷（nerd-sniped）。

---

### [00:12:46] Paige Costello

**English:**
Yeah.

**中文翻译:**
好的。

---

### [00:12:46] Lenny

**English:**
I think you use a process called the Double Diamond Process at Asana. Okay. Cool.

**中文翻译:**
我想你们在 Asana 使用一种叫做“双钻石模型”（Double Diamond Process）的流程。对吧？酷。

---

### [00:12:49] Paige Costello

**English:**
We do.

**中文翻译:**
是的。

---

### [00:12:50] Lenny

**English:**
I've seen images of this in various places, but I don't know of any company that's actually using it as the process. Can you just describe what the Double Diamond Process is and how you use it?

**中文翻译:**
我在很多地方见过这个模型的图片，但我不知道有哪家公司真的把它作为正式流程。你能描述一下什么是双钻石模型，以及你们是如何使用它的吗？

---

### [00:13:00] Paige Costello

**English:**
So you might be familiar with lean startup concepts and Double Diamond as it relates to going broad, and then going narrow. So you go broad when you ask like, "What customer should I solve for?" and then you pick one, and then that's the narrowing. Then, you go broad, and you say, "What are the problems this customer has?" and you narrow, and you say, "This is the problem they have." Then, you go broad, and you say, "What solution should we do to this?" and then you go narrow, and you say, "This is the solution that we should start with." That process of going broad, and going narrow, and going broad, and going narrow forces people to get out of their opinion-driven lens because so often, we need to be curious quantitatively and qualitatively about what we're doing and why, and be more systematic and rigorous about getting there. It doesn't take long, but it just breaks the frame. The Double Diamond Process that Asana effectively... Each of our typical reviews or artifacts sit at different inflection points on the Double Diamond. So we actually ask people to do a kickoff where they collect different information at different scale depending on the size of the problem and the ambiguity they're solving. Some people have already done enough customer selection and research that they're starting with, "What are the possible solutions to this problem?" and then they're bringing the spec, and that's the narrowing alongside design, et cetera. But it's really mapping our artifacts against this notion to make sure that the product thinking has that quality of decision-making. Yeah.

**中文翻译:**
你可能熟悉精益创业（lean startup）的概念，双钻石模型与之相关，核心在于“发散”（going broad）然后“收敛”（going narrow）。当你问“我应该为哪个客户解决问题？”时，你是在发散；当你选定一个客户时，你是在收敛。接着你发散去问“这个客户有哪些问题？”，然后收敛说“这就是他们的问题”。再接着你发散去问“我们应该用什么方案解决它？”，最后收敛说“这就是我们要开始实施的方案”。这种发散、收敛、再发散、再收敛的过程迫使人们跳出“观点驱动”的视角，因为我们通常需要对正在做的事情及其原因保持定量和定性的好奇心，并以更系统、更严谨的方式达成目标。这花不了多少时间，但它能打破思维定式。在 Asana，双钻石流程实际上是……我们每个典型的评审或产出物都处于双钻石模型的不同拐点上。所以我们实际上要求人们进行启动会议（kickoff），根据问题的规模和要解决的模糊性，收集不同规模的信息。有些人已经做了足够的客户选择和研究，所以他们直接从“这个问题的可能解决方案是什么？”开始，然后提交规格说明书（spec），这就是与设计等部门一起进行的收敛过程。这实际上是将我们的产出物与这个概念对应起来，以确保产品思维具有决策质量。

---

### [00:14:44] Lenny

**English:**
The way you described it is it was very customer-target-oriented. Is that that the actual framework? Is it around who to build this for, and then what to build, or is it more... It is. Okay. You're not ahead?

**中文翻译:**
你描述它的方式是非常以客户目标为导向的。这就是实际的框架吗？它是围绕“为谁构建”，然后“构建什么”展开的吗？还是更多……确实是这样。好的。

---

### [00:14:44] Paige Costello

**English:**
It is. Yeah.

**中文翻译:**
是的。

---

### [00:14:44] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:14:56] Paige Costello

**English:**
It's really important because then you also know what success looks like because if you pick your success metrics as using a feature, that's it. You're teaching to the test. It's not actually driving the outcome. So while our planning process is around effectively defining category and how we win, and making sure that customers receive certain benefits from using work management, the through line to the individual project that a team might be leading is they need to know who they're solving for and what it means to have that problem solved. So it always starts with enough customer insight such that we can creatively do what they're trying to do. I mean, really inventing on behalf of customers.

**中文翻译:**
这非常重要，因为这样你也知道成功是什么样子的。如果你把成功指标设定为“使用某个功能”，那就完了，你是在“为考而教”，并没有真正推动结果。虽然我们的规划流程是围绕有效地定义类别、我们如何获胜，以及确保客户从使用工作管理中获得某些收益，但贯穿团队领导的单个项目的核心线索是：他们需要知道自己在为谁解决问题，以及解决该问题意味着什么。所以，它总是始于足够的客户洞察，这样我们才能创造性地实现他们想要做的事情。我的意思是，真正代表客户进行发明。

---

### [00:15:44] Lenny

**English:**
Can you maybe repeat if there's terms for each of those phases?

**中文翻译:**
你能重复一下这些阶段的术语吗？

---

### [00:15:49] Paige Costello

**English:**
Yeah. Absolutely.

**中文翻译:**
好的，没问题。

---

### [00:15:49] Lenny

**English:**
Then, is there an example of a feature or product that went through this that you could share? If nothing comes to mind, that's okay.

**中文翻译:**
那么，有没有一个经历了这一流程的功能或产品的例子可以分享？如果一时想不起来也没关系。

---

### [00:15:55] Paige Costello

**English:**
The inflection points are the kickoff, which is that going broad, and then customer and direction selection. So this is both the target as well as of the 10,000-foot views of how you might pursue solving this problem. Which path are you broadly going to take? Then, going broad within that path on different concepts, and then there's a design concept review. Then, the products spec. Then, the full experience review or design crit of the end-to-end experience and launch. So that launch review is often just, "Hey, here's the thing. Here's what we said. Here are the fast-follows." Most of the time, by that time, it's already been dogfooding internally for some time, and it's more of a formal, "Do we have the right metrics in place? Are we ready to ship?"

**中文翻译:**
拐点包括：启动（kickoff），也就是发散阶段；然后是客户和方向选择。这既包括目标客户，也包括关于如何解决这个问题的“万英尺高空”视角——你大致要走哪条路？接着，在那条路径内针对不同概念进行发散，然后是设计概念评审（design concept review）。再接着是产品规格说明书（product spec）。然后是全体验评审或对端到端体验的设计评审（design crit）以及发布。发布评审通常只是：“嘿，东西在这。这是我们之前说的。这是后续跟进项。”大多数情况下，到那个时候，产品已经在内部试用（dogfooding）一段时间了，这更多是一个正式的确认：“我们是否有合适的指标？我们准备好交付了吗？”

---

### [00:16:52] Lenny

**English:**
Awesome. Do these reviews happen in person, on Zoom, or asynchronous?

**中文翻译:**
太棒了。这些评审是面对面进行、在 Zoom 上进行，还是异步进行的？

---

### [00:16:56] Paige Costello

**English:**
It depends. So it depends on the complexity of the work, and it depends how much we want to talk about it. A lot of our crits happen in person on the design side. A lot of spec reviews are more asynchronous, and then we'll say, "Depending on the number of questions people have, we call a meeting." Otherwise, we do mostly async, but it's a mix. It really depends on the complexity and ambiguity of the solution and how much people have questions about asynchronously beforehand.

**中文翻译:**
视情况而定。这取决于工作的复杂程度，以及我们想讨论多少。设计方面的很多评审（crits）是面对面进行的。很多规格说明书评审更多是异步的，然后我们会说：“根据大家问题的多少，我们再决定是否开会。”否则，我们大部分时间是异步的，但这是一个混合模式。这完全取决于解决方案的复杂性和模糊性，以及大家在异步预习时有多少疑问。

---

### [00:17:27] Lenny

**English:**
I'm going to take a tangent with my questions here and talk about work from home policy at Asana. This is something that I've been wondering more and more about how it's changing because it feels like there's been a shift back to the office. So what is the current policy at Asana, and what's changed maybe over the past couple years?

**中文翻译:**
我想把话题岔开一下，聊聊 Asana 的远程办公政策。我一直在思考这方面是如何变化的，因为感觉现在有一种重返办公室的趋势。那么 Asana 目前的政策是什么？过去几年发生了哪些变化？

---

### [00:17:42] Paige Costello

**English:**
Well, we were fully remote during the pandemic, and then we came back to the office in an office-centric hybrid format. So we're in the office Monday, Tuesday, Thursday, and then work from home mostly on Wednesdays and Fridays. That dynamic has been designed from the start. We wanted to make sure that we took advantage of what's great about working together as teams, and so it's been the standard. So I would say what's unique about maybe Asana is we knew we would do that from the very beginning instead of hemming and hawing about would we be a remote workplace or not, and what would that mean, and how would we come together, and how would we budget for it. We're like, "No, this is going to be an office-centric hybrid," because we wanted to create spaces for people to work together and move quickly. It's been interesting watching people get back into the swing of things. Even though we knew, it didn't mean that on day one, people were great at being in the office. People were taking standups sitting down. Whereas before, you would walk through our office, and you could hear people at standup because there were standup chants, and people would be out on the floor. Now, people are more likely to do their standup in a room, and we're trying the next level of standing up during a standup, but it's... I'm sure it's a shared experience for other people who are working in offices to get used to using the whiteboards again, to get used to standing up during your meetings. It's bizarre that we could lose a muscle that we had that was so innate so quickly, and I think even in the last month, I would say, and it's in June of 2023, there's more vibrancy in the office, more conversation, more casual... someone eating alone at the cafeteria, and someone sitting down next to them. So it didn't happen overnight.

**中文翻译:**
嗯，我们在疫情期间是完全远程的，然后我们以“以办公室为中心的混合模式”（office-centric hybrid）回到了办公室。所以我们周一、周二、周四在办公室，周三和周五主要在家办公。这种动态从一开始就是设计好的。我们想确保利用好团队协作的优势，所以这成了标准。我想说 Asana 的独特之处在于，我们从一开始就知道会这么做，而不是犹豫不决地讨论我们要不要成为远程办公场所、那意味着什么、我们如何聚在一起、如何做预算。我们的态度是：“不，这将是以办公室为中心的混合模式”，因为我们想为人们创造共同工作和快速行动的空间。观察人们重新适应这种节奏很有趣。尽管我们早有预料，但这并不意味着第一天大家就能完美适应办公室生活。以前大家是坐着开站会（standups）。而在此之前，你走在办公室里，能听到人们开站会的声音，因为有站会口号，大家都在办公区。现在，人们更倾向于在会议室里开站会，我们正在尝试进入下一个阶段——在站会期间真正站起来。我相信对于其他在办公室工作的人来说，重新习惯使用白板、习惯在会议中站立，都是共同的经历。很奇怪，我们竟然能如此迅速地失去一种曾经如此天生的“肌肉记忆”。我想说，即使在过去的一个月里（现在是 2023 年 6 月），办公室里也更有活力了，有了更多的交谈，更多的随意性……比如有人在食堂独自吃饭，另一个人会坐到他旁边。所以，这并不是一夜之间发生的。

---

### [00:19:45] Lenny

**English:**
I've been seeing a lot of tweets of founders just being like, "Work from home has failed. It's time to go back at the office." I'm curious if that ends up rolling into more and more companies, or if it's just a few founders here and there.

**中文翻译:**
我看到很多创始人的推文都在说：“远程办公失败了，是时候回办公室了。”我很好奇这是否会波及越来越多的公司，还是只是少数创始人的看法。

---

### [00:19:56] Paige Costello

**English:**
I think it's a real thing for mental health. I do think that having social casual relationships as well as more opportunities to talk strategy with people you're not forced into a meeting room with has been super beneficial. I can say that just today, I was having lunch and sat down with my head of data science, and we had an impromptu chat about how we review our experiments and how to evaluate whether we had ROI on learning, not just the metrics. It was one of those things where if we had to schedule it, it might not have happened, and if it did happen, it would have been a couple weeks from now.

**中文翻译:**
我认为这对心理健康来说是很真实的需求。我确实认为，拥有社交性的非正式关系，以及更多机会与那些并非被迫在会议室见面的人讨论战略，是非常有益的。我可以举个例子，就在今天，我吃午饭时坐在我们的数据科学负责人旁边，我们即兴聊了聊如何评审实验，以及如何评估我们在“学习”上是否有投资回报率（ROI），而不仅仅是看指标。这类事情如果非要预约时间，可能根本不会发生；即使发生了，可能也是几周之后的事了。

---

### [00:20:36] Lenny

**English:**
It feels like just coming into the office once or twice... or sorry, being at home once or twice a week is not that different from how things used to be where there was a day of no meetings and a lot of people stayed from home. So it feels like it's almost reverting back to that.

**中文翻译:**
感觉每周只去办公室一两次……或者说，每周在家办公一两次，与过去的情况并没有太大不同。过去通常会有一天是“无会议日”，很多人也会待在家里。所以感觉现在几乎又回到了那种状态。

---

### [00:20:47] Paige Costello

**English:**
Exactly, and people are better at it than they used to be.

**中文翻译:**
没错，而且人们现在比以前更擅长这种模式了。

---

### [00:20:47] Lenny

**English:**
Right.

**中文翻译:**
对。

---

### [00:20:50] Paige Costello

**English:**
So I would say our remote days are more impactful than the days we're together where we're getting into the swing of things.

**中文翻译:**
所以我想说，我们的远程办公日比我们聚在一起找感觉的日子更有成效。

---

### [00:20:56] Lenny

**English:**
Yeah. I feel like as a PM, the only day I was productive and getting real deep work done was the No-Meeting Wednesday. It was at Airbnb.

**中文翻译:**
是的。我觉得作为一名 PM，我唯一能高效工作并进行深度思考的日子就是“无会议周三”。那是当时在 Airbnb 的做法。

---

### [00:21:04] Paige Costello

**English:**
Yes. I would encourage you to know your chronotype and to lock that time where you have the most head space to do that work. So, for me, it's mornings.

**中文翻译:**
是的。我建议你了解自己的“生物钟类型”（chronotype），并锁定你思维最清晰的时间段来做那些工作。对我来说，那是早晨。

---

### [00:21:12] Lenny

**English:**
Say more on chronotype. What is that?

**中文翻译:**
多讲讲“生物钟类型”。那是什么？

---

### [00:21:15] Paige Costello

**English:**
I'm a morning person, and so I try to make sure that I don't have any meetings before 10:00, sometimes before 11:00, and that's when I do my hardest task for the day.

**中文翻译:**
我是个“晨型人”，所以我尽量确保在 10 点之前，有时是 11 点之前不安排任何会议，那是我处理一天中最难任务的时间。

---

### [00:21:26] Lenny

**English:**
I also just thought about standups while I was at Airbnb and how not only how much energy they brought, but almost too much energy sometimes where there's like another team doing a standup, and they're just laughing and clapping, and we're just like, "Shh, we're trying to work over here." I feel like we need more of that again.

**中文翻译:**
我也想到了在 Airbnb 时的站会，它们不仅带来了很多能量，有时甚至能量过剩。比如旁边有个团队在开站会，他们又笑又鼓掌，而我们只能说：“嘘，我们这边正试着工作呢。”我觉得我们需要再次拥有更多那样的氛围。

---

### [00:21:42] Paige Costello

**English:**
Totally. Yep, yep.

**中文翻译:**
完全同意。没错。

---

### [00:21:45] Lenny

**English:**
Okay. So, moving in a slightly different direction, something I heard about you is that you're often the youngest person in the room, and you often lead people with decades more experience than you. I want to ask, what have you learned about how to garner trust and win over skeptics, especially when they're maybe more experienced or older, and especially in other functions, I don't know, execs or designers, engineers, what have you figured out there?

**中文翻译:**
好的。换个话题，我听说你经常是房间里最年轻的人，而且你经常领导那些比你多出几十年经验的人。我想问，关于如何赢得信任并说服怀疑者，你学到了什么？特别是当他们可能更有经验或更年长时，尤其是在其他职能部门，比如高管、设计师或工程师，你在这些方面有什么心得？

---

### [00:22:13] Paige Costello

**English:**
The thing I would say is bring the insight. Know thy customer. Know thy market. Know thy competitors. Know thy numbers. Know thy product. If you can be the person in the room who has watched customers use the product and has a point of view about why one tool is significantly better or worse in a given dimension, and you can do that with confidence and clarity, and you don't need to know the other person's functional domain, and you don't need the expertise in what they're experts at, you can bring insight that makes people curious, and trust you, and just immediately believe that there's an opportunity that you're not advocating for that just is true. But I think that's a really tricky and unique thing is not to pretend like you have more experience than you do, but to be willing to ask great questions, and then be curious enough that you're bringing insight to every meeting that people may or may not have, but you're always willing to share.

**中文翻译:**
我想说的是：带来洞见。了解你的客户，了解你的市场，了解你的竞争对手，了解你的数据，了解你的产品。如果你能成为房间里那个亲眼观察过客户如何使用产品，并对为什么某个工具在特定维度上明显更好或更差有独到见解的人，如果你能自信且清晰地表达出来，你就不需要了解对方的职能领域，也不需要具备他们所擅长的专业知识。你可以带来让人们感到好奇并信任你的洞见，让他们立刻相信存在一个你并非在盲目主张、而是客观存在的事实。但我认为这其中非常微妙且独特的一点是，不要假装自己比实际更有经验，而是要愿意提出很棒的问题，并保持足够的好奇心，以便在每次会议中都能带来别人可能没有的洞见，并且始终乐于分享。

---

### [00:23:21] Lenny

**English:**
That's such a good answer because it's like there's not a trick to it. It's just do the work, spend the time to become the person that has answers that people value and obviously, that will respect you, value your opinion, want to hear from you.

**中文翻译:**
这是一个非常棒的回答，因为这其中没有什么捷径。就是去下功夫，花时间让自己成为那个拥有大家看重的答案的人。显然，这样大家就会尊重你，重视你的意见，并想听听你的看法。

---

### [00:23:34] Paige Costello

**English:**
Yeah. Yeah. Our former board member, Anne Raimondi, and now our head of business wrote an article on First Round that was really great about the trust equation, and it really resonated with me. I don't know if you've heard about it, but she said that trust is equal to credibility plus reliability, plus authenticity, divided by or over perception of self-interest. I think when you're met by someone who doesn't know you, doesn't know your work, your job is to create credibility, and that's where I said bringing the insight is where you can really tip the scales here. Reliability, this is all about your say-do ratio. Authenticity is just being vulnerable, being yourself, and then making sure that people know that you're not in it for some other outcome or cause that perception of self-interest really can change whether people... how much they trust you.

**中文翻译:**
是的。我们前任董事会成员、现任业务负责人 Anne Raimondi 在 First Round 上写过一篇关于“信任公式”（trust equation）的非常棒的文章，这让我产生了强烈的共鸣。我不知道你有没有听说过，她说：信任 = (公信力 + 可靠性 + 真实性) / 自私感（perception of self-interest）。我认为当你遇到一个不认识你、不了解你工作的人时，你的任务是建立公信力，这就是我说的“带来洞见”可以真正扭转局面的地方。可靠性关乎你的“言行一致率”（say-do ratio）。真实性就是展现脆弱的一面，做你自己，并确保人们知道你不是为了某种私利。自私感真的会改变人们对你的信任程度。

---

### [00:24:46] Lenny

**English:**
In terms of knowing the insight and knowing thy customer, putting the time, I imagine, is a big element of that. Is that how you do that, or is there anything else along those lines that's just like, "Here's how I get really good at this?"

**中文翻译:**
在获取洞见和了解客户方面，我想投入时间是一个重要因素。你是这么做的吗？或者在这方面还有什么秘诀，比如“我是如何变得非常擅长这个的”？

---

### [00:24:59] Paige Costello

**English:**
When you take a new role, become best friends with a researcher, and spend time watching customers use the product firsthand because what they maybe report on or are trying to do a study about might be very different from what you observe, but you really just need that front row seat with customers, and so asking, "How do I actually set up time with customers? How do I compensate them? How do I read the tickets?" Whatever. It's amazing how little you have to do to quickly catch up to understanding who the organization is solving for well and poorly, and how people really use your product versus how your teams use your product, especially in organizations where there are heavy dogfooding cultures. It's really risky to become less sensitive to the needs and behaviors of customers because people think they are their customer, and it also becomes very navel-gazey. So I think the more you get out and break up how people are having conversations about what we should do and why, and what we shouldn't do and why, and it's not about your opinion, it's about asking questions, and then bringing insight can really change the nature of the conversation and build trust.

**中文翻译:**
当你接手一个新角色时，去和研究员交朋友，花时间亲眼观察客户如何使用产品。因为他们报告的内容或试图研究的课题，可能与你观察到的非常不同。你真的需要那个与客户面对面的“前排座位”。所以去问：“我该如何安排与客户的时间？我该如何给他们报酬？我该如何查看工单？”等等。令人惊讶的是，你只需要做很少的事情，就能迅速赶上并理解组织在为谁解决问题（解决得好或不好），以及人们是如何真实使用你的产品的，而不是你的团队如何使用它。特别是在那些有着浓厚“内部试用”（dogfooding）文化的公司，变得对客户需求和行为不敏感是非常危险的，因为人们会认为自己就是客户，这会导致过度关注内部（navel-gazey）。所以我认为，你越是走出去，打破人们关于“我们该做什么、为什么做”以及“不该做什么、为什么不做”的固有对话模式，不以个人观点为中心，而是通过提问和带来洞见，就越能真正改变对话的本质并建立信任。

---

### [00:26:18] Lenny

**English:**
I love that. In terms of confidence, you talked about the importance of communicating these things confidently. Is there anything you've learned about how to be more confident? The managing part of it is like having the answer, but is there anything there that you maybe coach your PMs around or other folks of just like, "Here's how you communicate confidence?"

**中文翻译:**
我喜欢这个观点。关于自信，你谈到了自信沟通的重要性。关于如何变得更自信，你学到了什么吗？管理的一部分是拥有答案，但在沟通自信方面，你有没有辅导过你的 PM 或其他人，比如“这就是你传达自信的方式”？

---

### [00:26:36] Paige Costello

**English:**
It's a great question. I think being brave and courageous in little moments is just what you have to do. You have to show up, and say it before you're ready to say it, and ask for forgiveness, and be vulnerable. I think when you're vulnerable, people actually trust you more than if you come with all of this armor and say, "I know this, and this is how we're going to do it." So real confidence is often conveyed by being willing to ask the question or to say, "I don't know what you mean by that. Can you say that again?" It's also just how you communicate, looking people in the eye, your body position, your body language. So much of this, I think people forget about because it's really easy to be in a meeting, and looking at your computer, and going through Slack messages. So one of the best things you can do is if you're in a meeting, be in that meeting. Continually scan the faces of everyone in the room, see if someone has a question, pause at the beginning, and welcome people, and chit-chat while people land, and then close asking questions like, "Did I get all of that? Is there anything you would've expected to cover that we missed?" It's really about being open, and that conveys confidence more than being assertive and advocating 100% of the time.

**中文翻译:**
这是一个非常好的问题。我认为在微小的时刻表现得勇敢和有胆量就是你必须做的。你必须站出来，在还没完全准备好之前就说出来，敢于请求原谅，并展现脆弱。我认为当你展现脆弱时，人们实际上会比你带着全身盔甲说“我知道这个，我们就这么办”时更信任你。所以真正的自信通常体现在愿意提问，或者说“我不明白你的意思，能再说一遍吗？”此外，还关乎你的沟通方式：眼神交流、身体姿势、肢体语言。我想很多人都忽略了这些，因为在会议中盯着电脑看 Slack 消息太容易了。所以你能做的最好的事情之一就是：如果你在开会，就全身心地投入其中。不断观察房间里每个人的脸，看看是否有人有疑问；在开始时停顿一下，欢迎大家，在大家入座时闲聊几句；结束时问一些问题，比如“我说明白了吗？有没有什么你们预期会讨论但我们遗漏的内容？”这实际上关乎开放性，这比百分之百的时间都表现得咄咄逼人和坚持主张更能传达自信。

---

### [00:28:03] Lenny

**English:**
This episode is brought to you by Round. Round is the private network built by tech leaders for tech leaders. Round combines the best of coaching, learning, and authentic relationships to help you identify where you want to go and accelerate your path to get there, which is why their wait list tops thousands of tech execs. Round is on a mission to shape the future of technology and its impact on society. Leading in tech is uniquely challenging, and doing it well is easiest when surrounded by leaders who understand your day-to-day experiences. When we're meeting and building relationships with the right people, we're more likely to learn, find new opportunities, be dynamic in our thinking, and achieve our goals. Building and managing your network doesn't have to feel like networking. Join Round to surround yourself with leaders from tech's most innovative companies. Build relationships. Be inspired. Take action. Visit round.tech/apply, and use promo code "LENNY" to skip the wait list. That's round.tech/apply.

**中文翻译:**
本期节目由 Round 赞助。Round 是由科技领袖为科技领袖建立的私人网络。Round 结合了顶尖的教练辅导、学习和真实的人际关系，帮助你确定目标并加速实现目标的路径，这就是为什么他们的候补名单上有数千名科技高管。Round 的使命是塑造技术的未来及其对社会的影响。在科技领域担任领导者具有独特的挑战性，而当你身边都是理解你日常经历的领导者时，把工作做好会变得最容易。当我们与合适的人会面并建立关系时，我们更有可能学习、发现新机会、保持思维活跃并实现目标。建立和管理你的人脉不一定非要感觉像是在“社交”。加入 Round，与来自科技界最具创新精神公司的领导者为伍。建立关系，获得启发，采取行动。访问 round.tech/apply，并使用优惠码“LENNY”跳过候补名单。网址是 round.tech/apply。

---

### [00:29:04] Lenny

**English:**
From my chats with folks that you work with, it's really clear that you put a lot of time and energy into mentoring and coaching PMs, and your team, and I think probably broadly at Asana. One thing specifically that came up is that you're very big on leading and teaching by example, not just, "Here's how you do this thing." So, if that's true, I'm curious where that came from for you and why you think that ends up being a lot more successful than like, "In a meeting, you should do X, Y, Z," versus doing it, and then letting them see.

**中文翻译:**
从我与你同事的交谈中可以清楚地看到，你投入了大量的时间和精力来指导和辅导 PM 以及你的团队，我想在 Asana 内部也是如此。特别提到的一点是，你非常推崇“以身作则”的领导和教学方式，而不仅仅是说“你应该这样做”。如果真是这样，我很好奇这种理念是从何而来的，以及为什么你认为这比直接说“在会议中你应该做 X、Y、Z”要成功得多？

---

### [00:29:34] Paige Costello

**English:**
I think the main thing is repetition. We're all students of repetition. If you see something done a few times, you're more likely to remember it and internalize it, and so it's also something that... a way that I learn, and so I think that's probably part of it. I remember hearing about a framework called the three Es: experience, exposure, and education. I think it was helpful for me to hear that as a way of growing your career or being more purposeful about your growth because I think when people are earlier in their careers, they tend to think, "Education, education, education," and then they started to think, "Experience, experience. How do I get the experience of being a manager? I need to read about it, and then be a manager." It's very linear. Exposure was such an important one where I thought like, "Okay. So you're not in the driver's seat, but you're in the car, and you hear what's happening, and you're evaluating how this is... what the impact is." This goes back to being really present and analytical, and being a learner because if you can be a learner, not just in an education or experience context, but in an exposure context, you can really grow so much more quickly and in so many more directions than you will get from just what does your day entail from what work is directly required of you.

**中文翻译:**
我认为最主要的是重复。我们都是重复的学徒。如果你看到某件事被做了几次，你更有可能记住并内化它。这也是我学习的一种方式，所以我认为这可能是部分原因。我记得听过一个叫“3E”的框架：经验（Experience）、接触（Exposure）和教育（Education）。我认为听到这个框架对于职业成长或更有目的地规划成长非常有帮助。因为我觉得人们在职业生涯早期往往只想到“教育、教育、教育”，然后开始想“经验、经验。我怎么获得当经理的经验？我得先读相关的书，然后去当经理。”这非常线性。而“接触”是非常重要的一环，我的想法是：“好吧，虽然你不在驾驶座上，但你在车里，你听到了发生了什么，你在评估这件事的影响是什么。”这又回到了保持专注、分析能力和成为一名学习者。因为如果你不仅能在教育或经验背景下学习，还能在“接触”背景下学习，你的成长速度会快得多，成长的方向也会比仅从日常工作中获得的多得多。

---

### [00:31:12] Lenny

**English:**
Is there an example of that happening either to you or you saw a manager leader do this, and you're like, "Oh, I get it now," or you doing that and it helped?

**中文翻译:**
有没有这样的例子？无论是发生在你身上，还是你看到某位经理或领导这么做，让你觉得“哦，我现在明白了”，或者是你这样做之后起到了作用？

---

### [00:31:18] Paige Costello

**English:**
So I'll give two examples. I mean, the way I run my meetings are the kind of meetings I want to be a part of. So I try to make sure that I start with a clear agenda, and I move quickly, but give time for conversation and that it's not fully just sharing information, but debating where appropriate. I think knowing how to manage the conversation and courteously pausing people who are going on too long or taking the group in a different direction than was intended, and just think about the experience of everyone there, and create the experience that you hope that they're creating in the rooms that you're not a part of. An example that I have in terms of experience is sometimes the experience is you doing the thing and getting that experience firsthand. Other times, you need an education, you need a mentor, you need a coach who will tell you what they're saying or give you advice. I was in a really high-stakes product review at Intuit, and at the end of it, everyone else had left, and the leader of the business unit as she was leaving the room said, "Always answer the question that they should have asked." "Always answer the question they should have asked." I was pretty surprised by that advice because it was very profound in the moment because I think when you're a student and you are accustomed... If you're an achiever, you like to get As. You're probably going to hear a question and answer it. You're like, "One-to-one, one-to-one, one-to-one." But what I learned from that was that there's actually another altitude, another point of strategy when you're in a meeting or in a conversation to make sure that you're covering the more important point, the bigger picture, the alternative that the person asking the question maybe didn't see or consider. So I think the mix of experience, exposure, and education really helps you make sure that you're consciously moving forward on each of those fronts or finding people who can help you there.

**中文翻译:**
我举两个例子。首先，我主持会议的方式就是我希望参加的那种会议的方式。所以我尽量确保以清晰的议程开始，节奏紧凑，但留出对话时间，而且不完全只是分享信息，而是在适当的时候进行辩论。我认为知道如何引导对话，礼貌地打断那些说得太长或把讨论引向错误方向的人，并考虑在场每个人的体验，创造出那种你希望他们在你不在场的会议室里也能创造出的体验。关于“经验”的一个例子是，有时经验是你亲自动手并获得第一手体会。而有时，你需要教育，需要导师或教练来告诉你他们的看法或给你建议。我曾在 Intuit 参加过一次非常关键的产品评审，结束时大家都走了，业务部门的领导在离开房间时说：“永远要回答他们本该问的问题。”“永远要回答他们本该问的问题。”我对这个建议感到非常惊讶，因为在那一刻它显得非常深刻。我想当你还是个学生，习惯了做一个“优等生”时，你可能会听到一个问题就回答一个问题，是一对一的对应。但我从中领悟到的是，在会议或对话中，实际上还有另一个高度、另一个战略点，那就是确保你涵盖了更重要的点、更大的图景，或者是提问者可能没有看到或考虑到的替代方案。所以我认为经验、接触和教育的结合，能真正帮助你确保在这些方面有意识地进步，或者找到能在这方面帮助你的人。

---

### [00:33:43] Lenny

**English:**
I love that piece of advice, and it makes me want to ask, are there other pieces of advice that have been really impactful to you, or are there common pieces of advice you give to your team that just is a recurring theme of advice that maybe people even make fun of like, "Oh, Paige is always saying this?"

**中文翻译:**
我非常喜欢这条建议。这让我想问，还有其他对你产生重大影响的建议吗？或者你有没有经常给团队提的建议，甚至成了大家开玩笑的梗，比如“噢，Paige 总是说这个”？

---

### [00:33:59] Paige Costello

**English:**
There are a few ways to think about advice, and my advice often meets some mark when it's for a particular person in a particular time in their career. So I would say advice I love giving to people who are early in their career is don't self-select because I think it's really easy to say, "I don't have the experience," or, "I'm not X, Y, Z enough," and not apply. So I really push people not to self-select, and I try to remind myself where that's appropriate to do the same thing. Other advice I often give is just think big, ship small. "Think big, ship small." What's the smallest thing you can do to do that thing? But let's not, because we're trying to ship all the time and in small chunks, start thinking in small ways because it's really easy to get a little too incremental, a little too wrapped around the axle around optimizing a metric and miss the bigger picture, and so think big ship small is another piece of product advice I give. The last piece of advice that I would say that I like is more of a way of thinking. So this is a little abstract, but when employees join Asana, they get a book called The 15 Commitments of a Conscious Leader. It's led by the Conscious Leadership Group. They also get two-day training on some language and tools for how to effectively work with other people, and it's a really... For me at least, it was transformational because I learned some vocabulary and methods that I could share with my peers. One of the things that you learn is to be above or below the line, and something that is this concept of like, "Where are you? Are you above the line? Are you below the line?" If you're above the line, you're committed to learning. You're open and curious. Things are funny here, more playful. If you're below the line, you're committed to winning. You're committed to being right. Things are more black and white. All of us have days where we're having a conversation and we're really in that below line space where it's like, "No, it just is this way. There's no two ways around it." That concept of understanding your personal head space, and then being mindful of how you're operating when you're in that place really was great advice for me and also recognizing where other people were when it related to decisions we were making or context. It also helped me think about rejecting false trade-offs and challenging like... Effectively, there's this notion of how might the opposite be true, and that's a piece of advice that I give myself like this morning. I think it was yesterday, actually. I was like, "How am I going to do tomorrow? Tomorrow, I have to deliver the clarity pillar brief to the area leads and make sure they understand our stack ranked metrics, and they need to know exactly what our strategic priorities are and why, and they need nudges, and they need to be able to translate our voice of business and usability lists into those plans. I need to establish a perspective and make sure this is all written down and they really understand it, and I have a great conversation with them where I get open questions and they feel like they can really challenge my thinking. I also am having a podcast with Lenny in the afternoon. Ugh." Right? At first, it was like, "This is just too much. I should try to move or cancel one of these." Then, I asked myself, "How might the opposite be true?" I was like, "I can do both." It was just enough to pop the balloon because sometimes your brain is so accustomed to having a scarcity mindset as opposed to creating alternative options or seeing a different path. The moment I challenged myself and said, "How might the opposite be true?" my shoulders dropped. I felt more relaxed. I was like, "Oh, yeah, I can do both. It will be fine. We'll have a great conversation. I'm ready to show up, and be curious, and really engage with you on the topics that you've found interesting, and we'll just do that. So, "How might the opposite be true?" has been a really helpful piece of advice or line of questioning that I use with myself to make sure that I'm not taking myself away.

**中文翻译:**
思考建议有几种方式，我的建议通常在针对特定职业阶段的特定人时最有效。我会对职业生涯早期的人说：不要“自我筛选”（don't self-select）。因为人们很容易说“我没有经验”或“我不够优秀”，然后就不去申请。所以我极力推动人们不要自我筛选，我也试着在合适的时候提醒自己做到这一点。我经常给出的另一条建议是：大处着眼，小处着手（think big, ship small）。为了做成那件事，你能做的最小的事情是什么？但我们不要因为一直在小块交付，就开始以狭隘的方式思考。因为很容易陷入过度追求增量、纠结于优化某个指标而忽略了大局。所以“大处着眼，小处着手”是我给出的另一条产品建议。最后一条我喜欢的建议更多是一种思维方式。这有点抽象，但当员工加入 Asana 时，他们会得到一本名为《觉醒领导者的 15 项承诺》（The 15 Commitments of a Conscious Leader）的书。这是由“觉醒领导力小组”发起的。他们还会接受为期两天的培训，学习如何有效地与他人合作的语言和工具。对我来说，这具有变革意义，因为我学到了一些可以与同事分享的词汇和方法。其中之一就是“在线上”还是“在线下”（above or below the line）。这个概念是问：“你在哪里？你在在线上还是在线下？”如果你在线上，你致力于学习，你是开放且好奇的，氛围更轻松有趣。如果你在线下，你致力于赢，致力于证明自己是对的，事情变得非黑即白。我们每个人都有这样的时刻：在交谈中处于“线下”状态，觉得“不，事情就是这样，没商量”。理解你个人的心理状态，并留意你在那种状态下的行为，对我来说是非常棒的建议。这也能帮我识别他人在决策或特定情境下的状态。它还帮助我拒绝虚假的权衡，并挑战自我……实际上，有这样一个概念：“相反的情况如何可能也是真的？”这就是我今天早上（实际上是昨天）给自己的一条建议。当时我想：“明天我该怎么办？明天我要向领域负责人提交‘清晰度支柱’简报，确保他们理解我们的指标优先级，他们需要确切知道我们的战略重点是什么以及为什么，他们需要引导，并且需要能够将我们的业务声音和可用性清单转化为计划。我需要建立一个视角，确保所有内容都写下来并让他们真正理解，我还要和他们进行一次深入的交流，接受他们的提问，让他们觉得可以挑战我的想法。而且下午我还要和 Lenny 录制播客。呃……”对吧？起初我觉得：“这压力太大了，我应该改期或取消其中一个。”然后我问自己：“相反的情况如何可能也是真的？”我想：“我可以两者兼顾。”这足以打破那种焦虑，因为有时你的大脑太习惯于匮乏心态，而不是去创造替代方案或看到不同的路径。当我挑战自己并说“相反的情况如何可能也是真的？”那一刻，我的肩膀放松了，感到更轻松了。我想：“噢，是的，我可以两者兼顾。没问题的。我们会有一场很棒的谈话。我准备好出席，保持好奇心，并真正与你探讨你感兴趣的话题。”所以，“相反的情况如何可能也是真的？”一直是我用来确保自己不被压力带走的非常有用的建议或提问方式。

---

### [00:38:43] Lenny

**English:**
Wow. What a fruitful question that ended up being. That was amazing. How does clarity pillars strategy go? Are people into it? Is it working?

**中文翻译:**
哇。这真是一个收获颇丰的问题。太棒了。那么“清晰度支柱”战略进展如何？大家感兴趣吗？奏效了吗？

---

### [00:38:52] Paige Costello

**English:**
Yeah. I'm pumped. It's a really interesting time to be a product leader, especially with all of the tech transform... Truly, the technological transformation on LLMs is astonishing, the pace of development, the ability of our teams to just ship quickly and ship really intelligent things. We're not in an operational "figure it out" land. We're not in a place where we're trying to decide how to do a better job and get it out to customers. We really have lots of interesting paths forward and are trying to make sure that we're on the cutting edge while really looking at like, "What does it mean to serve the companies and organizations that we want to serve with new ways of serving them?" So it was a really fun conversation, and I also had to be honest with people and say, "This is a 70% cut. 30% of this is missing or incorrect, and that's why I'm coming to you early." So I think it went really well, and it's the start of our 12-month rolling planning conversation.

**中文翻译:**
是的，我很兴奋。现在是担任产品负责人的一个非常有趣的时期，尤其是考虑到所有的技术变革……大语言模型（LLM）带来的技术变革确实令人震惊，开发速度之快，我们团队快速交付智能化产品的能力之强。我们不再处于那种“摸索如何运作”的阶段，也不再只是试图决定如何把工作做得更好并交付给客户。我们确实有很多有趣的前进路径，并努力确保自己处于最前沿，同时思考：“以新的方式服务我们想要服务的公司和组织意味着什么？”所以那是一次非常有趣的对话，我也必须对大家诚实，说：“这只是 70% 的版本。还有 30% 是缺失或不正确的，这就是为什么我这么早就来找你们。”所以我认为进展得非常顺利，这是我们 12 个月滚动规划对话的开始。

---

### [00:40:05] Lenny

**English:**
Let me pull on this AI thread because it's clearly top of mind for a lot of people. How do you think about splitting up investment in AI exploration within the product team? Are you like, "Hey, team. Everyone should be thinking about AI as part of their product," or is it there's a team where they're going to think about AI and LLM integrations and, "Everyone else, keep doing what you're doing?"

**中文翻译:**
让我顺着 AI 这个话题聊下去，因为这显然是很多人最关注的事情。你如何考虑在产品团队内部划分 AI 探索的投入？你是说“嘿，团队，每个人都应该把 AI 作为产品的一部分来思考”，还是说有一个专门的团队负责 AI 和 LLM 的集成，而“其他人继续做你们正在做的事”？

---

### [00:40:24] Paige Costello

**English:**
We've had an ML team for quite some time, making sure that we have test prioritization models and notification prioritization models, and are making our product less work for people to use. But when it came to the massive leap forward in LLMs recently, we staffed a team to really prototype quickly, and discover what was possible, and just apply hypotheses outside of the typical norms of how we work. So they went straight to prototyping instead of going through that Double Diamond I was explaining earlier. What that meant was that we were really quickly able to say, "Wow, this is just so much better than we imagined and would never have prioritized it because we thought it would take so much longer." Then, in other cases, "That sounded good in theory." So skipping a lot of that to just really try it on for a size has been key, and then what we're doing is giving the teams with the most expertise in the customer problems. For example, status and progress reporting, the keys to that car and saying like, "Here's the starter. Here's the hypothesis. Here's how far we got with it. It's dogfooding. What do you want to do?" So we're able to nudge people without wasting time and build the skills locally within the teams that then move those experiences forward.

**中文翻译:**
我们已经有一个机器学习（ML）团队很长时间了，负责确保我们有测试优先级模型和通知优先级模型，并让我们的产品使用起来更省力。但当最近 LLM 出现巨大飞跃时，我们组建了一个团队来快速制作原型，发现可能性，并在我们典型的工作规范之外应用假设。所以他们直接进入原型设计，而不是走我之前解释的那个双钻石流程。这意味着我们能够非常迅速地发现：“哇，这比我们想象的要好得多，如果我们以前认为这需要很长时间，我们根本不会优先考虑它。”而在其他情况下，有些东西“理论上听起来不错（但实际不行）”。所以跳过很多流程去实际尝试一下是关键。然后我们所做的是，把这些成果交给在客户问题上最有经验的团队。例如，状态和进度报告团队，把“车钥匙”交给他们并说：“这是启动器，这是假设，这是我们目前的进展，正在内部试用。你们想怎么做？”这样我们就能在不浪费时间的情况下推动大家，并在团队内部建立起局部技能，从而推动这些体验向前发展。

---

### [00:41:50] Lenny

**English:**
I want to come back to the coaching topic. I had a few questions there that I moved off of, but I feel like that's a rich area of exploration. You mentioned Intuit. You worked at Intuit. Intuit is famous for having a really good APM program and really good training for product managers. What did you take away from that experience that you bring with you to coaching or even I think there's an APM program at Asana, too?

**中文翻译:**
我想回到辅导这个话题。我之前跳过了几个问题，但我觉得这是一个非常值得探讨的领域。你提到了 Intuit。你在 Intuit 工作过，Intuit 以拥有非常出色的助理产品经理（APM）项目和非常棒的产品经理培训而闻名。你从那段经历中带走了什么，并应用到了现在的辅导中？我想 Asana 现在也有 APM 项目吧？

---

### [00:42:15] Paige Costello

**English:**
Intuit had excellent training programs, the APM program and their manager training. So, on the PM front, the biggest thing that they taught was around customer centricity, and it really started with the founding of the company. For anyone who works at Intuit or has worked at Intuit, they know that there's this story about Scott Cook watching his wife balancing her checkbook at the kitchen table, and staring at it, and saying, "There's got to be a better way, a software." So it was very typical for the product training at Intuit to be all about like, "How do you actually watch customers using your product or just doing the things they do, collecting the artifacts, knowing the workarounds, and using that experience to build opportunities for surprise and insight that then you can capitalize and create products around?" They also are very specific about how they define durable advantage and think about, overall, the product process from a place of customer insight through to the market landscape. So the PM program there was absolutely super thoughtful, especially for taking someone who has never PMed into being a super skilled PM. They also have a wonderful manager training program, and I think the biggest thing that I took away from their manager training was really on the feedback slide. Delivering feedback is something that I think everyone benefits from, but for managers, it's so much more critical because if you don't do it, and you don't say what you mean, and you don't do it in a way that it can be internalized and acted upon, you really don't set up your teammates, your teams for growth or success in their careers. So their program for helping you think about like, "Okay. I'm going to convey this feedback as situation, behavior, impact. The situation is on Tuesday in that meeting at 3:00. Behavior, you interrupted me while I was saying this thing. Impact, made me feel like you weren't listening to me or made me feel like your voice was more important than mine, or impact, blah, blah, blah." It doesn't matter what the impact is because the way you've set it up is it's a subjective observation. It's not what the camera recorded, it's what you experienced. Therefore, it is true and valuable feedback, and it gets the conversation started such that you can then talk about next steps. That format and framing really helped me understand that delivering feedback isn't about being right or about getting the right information to the other person. It's about sharing the impact of different decisions that they're making. So, especially if you have to give feedback about, God forbid, what someone wears to the office, or how do you feel their work is, or how they're communicating or their body language, having an enough support where you can be really clear about what you're intending and the spirit behind that, but that it's formalized enough that people can really engage with it has been enormously helpful, and I still use it today.

**中文翻译:**
Intuit 有非常出色的培训项目，包括 APM 项目和经理培训。在 PM 方面，他们教的最重要的一点是“以客户为中心”，这实际上始于公司的创立。任何在 Intuit 工作过的人都知道 Scott Cook 的故事：他看着妻子在餐桌前结算支票簿，盯着它说：“一定有更好的方法，一种软件。”所以 Intuit 的产品培训非常典型地围绕着：“你如何实际观察客户使用你的产品，或者只是观察他们做的事情，收集产出物，了解变通方法，并利用这些经验来创造惊喜和洞见的机会，然后你可以利用这些机会并围绕它们创建产品？”他们还非常明确地定义了“持久优势”，并思考从客户洞察到市场格局的整个产品流程。所以那里的 PM 项目绝对是非常周到的，特别是能把一个从未做过 PM 的人培养成一名技术精湛的 PM。他们还有一个很棒的经理培训项目，我想我从中获得的最大收获是关于“反馈”的部分。我认为每个人都能从反馈中受益，但对于经理来说，这更为关键。因为如果你不给反馈，或者不直说你的意思，或者不以一种能被内化和执行的方式给反馈，你就没有为你的队友和团队的职业成长或成功做好准备。他们的项目帮助你思考：“好吧，我要以‘情境、行为、影响’（SBI：Situation, Behavior, Impact）的方式传达这个反馈。情境是周二下午 3 点的那个会议。行为是，在我说话时你打断了我。影响是，让我觉得你没有在听我说话，或者让我觉得你的声音比我的更重要，或者影响是等等。”影响是什么并不重要，因为你设定它的方式是一种主观观察。它不是摄像机记录的内容，而是你的感受。因此，它是真实且有价值的反馈，它开启了对话，以便你们随后讨论下一步。这种格式和框架真的帮我理解了，提供反馈并不是为了证明自己是对的，也不是为了把“正确”的信息传给对方。它是关于分享他们所做的不同决定所产生的影响。所以，特别是如果你必须给反馈——哪怕是关于某人在办公室穿什么，或者你觉得他们的工作表现如何，或者他们的沟通方式或肢体语言——拥有足够的支撑让你能清晰表达意图和背后的精神，同时又足够正式让人们能真正参与其中，这对我非常有帮助，我至今仍在沿用。

---

### [00:45:35] Lenny

**English:**
It's interesting how some of the most impactful training is such soft skills.

**中文翻译:**
很有趣，一些最有影响力的培训竟然是这些软技能。

---

### [00:45:41] Paige Costello

**English:**
So basic.

**中文翻译:**
非常基础。

---

### [00:45:43] Lenny

**English:**
Basic. Yeah.

**中文翻译:**
基础，是的。

---

### [00:45:43] Paige Costello

**English:**
Yeah.

**中文翻译:**
没错。

---

### [00:45:44] Lenny

**English:**
It's just how to give someone some feedback, but it's like, "Know how to prioritize, how to do a meeting, how to give a presentation."

**中文翻译:**
这只是关于如何给某人反馈，但就像“知道如何排优先级、如何开会、如何做演示”一样重要。

---

### [00:45:48] Paige Costello

**English:**
No. Yeah.

**中文翻译:**
是的。

---

### [00:45:50] Lenny

**English:**
It's like, "Here's how you give feedbacks."

**中文翻译:**
就像是，“这就是你给反馈的方式”。

---

### [00:45:52] Paige Costello

**English:**
Yep.

**中文翻译:**
没错。

---

### [00:45:53] Lenny

**English:**
So you've worked with a lot of early product managers. I'm curious what you find most holds back new PMs and help them being successful in their career, and even on the flip side, what most helps new PMs be successful in terms of skills or behaviors, habits, things like that?

**中文翻译:**
你和很多初级产品经理合作过。我很好奇，你发现最阻碍新任 PM 并在职业生涯中取得成功的是什么？反过来说，在技能、行为、习惯等方面，什么最能帮助新任 PM 取得成功？

---

### [00:46:11] Paige Costello

**English:**
I would say this illusion that you have to be all-knowing and super confident sets you up to be in a place of advocacy instead of inquiry. So PMs who are newer in their careers or who are in a different space than they're accustomed to working really want to be pro really fast. What pro means is trying to cut that straight path, and that can reduce information and conversation that makes you smarter. So some of the challenges that some PMs face are feeling like they need to be the expert, they need to be the smartest person in the room, or God forbid, they think they're the smartest person in the room. Then, what happens is they're really doing that customer, or product discovery, or spec in a little dark room. Then, they show up, and they say, "This is it. This is right. I know it's right, and let's do this as quickly as possible." Everyone else says, "Wait. What? I don't know. I have a question," or they don't, and they still have a question, which is even worse. So I would say something that really holds PMs back is not being collaborative from a place of true curiosity like performative collaboration where they're not in a room or want to do a review, but ultimately, they don't really want the questions or the feedback. I think trying to make sure that you can be in a place of curiosity and openness because that will make your experience more successful is really important. Other people aren't always going to be right, but if you're present for it, you can ask clarifying questions. You can ask the question behind the question. You can hear the feedback, and then say, "Was that something that I must do, that I should do, or that I should consider?" You can actually develop a conversation that will move your relationship forward, and so I would say that's something that I think holds PMs back. PMs tend to be so ambitious and career-centric. There are so many good things about that, but I would say don't let the sound of your wheels drive you crazy. If you're present in your job, and you actually have fun with it and solve the problems, people will come out of the woodwork, say, "You're great, and tell your boss you should be promoted." You don't need to ask for a promotion. Your outcomes should speak for themselves. Yes, you should have sponsors and people who advocate for you, but a lot of that just comes from that raw connection to the work and to your team.

**中文翻译:**
我想说，那种“你必须无所不知且超级自信”的错觉，会让你陷入一种“主张”（advocacy）而非“探询”（inquiry）的状态。职业生涯较新的 PM，或者处于不熟悉领域的 PM，非常想快速变得专业。所谓的专业往往意味着试图走捷径，而这会减少那些能让你变得更聪明的各种信息和对话。所以一些 PM 面临的挑战是，觉得自己必须成为专家，必须是房间里最聪明的人，或者更糟的是，他们自以为是房间里最聪明的人。结果就是，他们躲在小黑屋里做客户调研、产品发现或写规格说明书。然后他们站出来说：“就是这个，这是对的，我知道它是对的，让我们尽快实施吧。”其他人会说：“等等，什么？我不知道。我有疑问。”或者他们干脆不问，但心里仍有疑问，这更糟。所以我认为真正阻碍 PM 的是缺乏基于真实好奇心的协作，而是一种“表演式协作”——他们虽然在场或要求评审，但内心并不真正想要问题或反馈。我认为，努力确保自己处于好奇和开放的状态非常重要，因为这会让你的经历更成功。别人并不总是对的，但如果你在场，你可以问澄清性的问题，问问题背后的问题。你可以听取反馈，然后说：“这是我必须做的，还是应该做的，或者是应该考虑的？”你实际上可以开展一场能推动关系发展的对话。所以我认为这是阻碍 PM 的因素。PM 往往非常有野心且以职业为中心，这有很多好处，但我想说，不要让这种急功近利的心态让你发疯。如果你专注于工作，真正享受其中并解决问题，人们自然会站出来说：“你很棒”，并告诉你的老板你应该被晋升。你不需要主动要求晋升，你的成果会说明一切。是的，你应该有支持者和为你说话的人，但很多东西都源于你与工作和团队之间那种原始的联系。

---

### [00:48:55] Lenny

**English:**
Everyone I talked to about you is like, "Oh my god, I love Paige." I could see why, but I want to ask you a question. I imagine you've made some mistakes either with a product or your career. I'd love to hear a story of something that went wrong and what you learned from that experience. This might be the last question, depending where you take it.

**中文翻译:**
我聊过的每个人提到你都会说：“天哪，我爱 Paige。”我能看出原因。但我还是想问你一个问题。我想你在产品或职业生涯中也犯过一些错误。我很想听听一个关于“搞砸了”的故事，以及你从那次经历中学到了什么。这可能是最后一个问题，取决于你的回答。

---

### [00:49:16] Paige Costello

**English:**
I would say that all of the advice I've given so far is directly related to things I've learned the hard way. So, especially as an IC moving into a management role, you aren't supposed to have all the answers. You need to ask better questions. You need to be thoughtful about direction and agency. So I would say one of the missteps here is knowing how to give guidance or direction in a way that doesn't feel like micromanagement because what you're trying to do is to teach a repeatable pattern instead of giving a precise instruction that can be used once, and then disposed of. So I think that's a pretty common manager path issue, but I think the faster you learn it, and observe it, and use techniques to manage it, the better. So, for example, I would go to my meetings with a stack of Post-Its, and I would write what I wish I was saying on Post-Its and see if someone else would say it first. Then, if by the end of the meeting, I had decided that I still had a Post-It or two that was worthwhile, I would say them. But you've got to police yourself because no one else will do it because no matter how accessible you think you are, other people know that you're the boss. They're not going to necessarily speak over you or challenge you directly. Another challenge I had is I'm a very optimistic person, and I like to look on the bright side. I'm very positive, and I think depending on the culture you're working with or depending on your team, sometimes they need to hear what's really bad, and they need you to be really real, and they need you to tell them like it is. Something I realized was that I had an experience where I didn't realize that people didn't think I was being authentic because they thought something was bad, and I wasn't talking about it, but it wasn't because I didn't think it was bad or didn't see. It was just because my nature was to say, "Well, I'm not going to talk about bad things because we're doing the things we need to do." As long as the plan is good, I wasn't really highlighting all the problems I saw or really pushing on those head on with my team, and so they felt like they didn't know what I was seeing or if we were saying the same things. That was really an interesting experience. Yeah, there were just so many. Yeah.

**中文翻译:**
我想说，我到目前为止给出的所有建议都与我辛苦换来的教训直接相关。特别是从个人贡献者（IC）转向管理岗位时，你不应该拥有所有答案。你需要提出更好的问题。你需要深思熟虑方向和自主权。所以我想说，这里的一个失误是不知道如何以一种不让人觉得是“微观管理”（micromanagement）的方式提供指导或方向。因为你试图教给他们的是一种可重复的模式，而不是给出一个用完即弃的精确指令。我认为这是经理成长路径上一个非常普遍的问题，但你学得越快、观察得越仔细并运用技巧去管理它，效果就越好。例如，我会带着一叠便利贴去开会，把我原本想说的话写在上面，看看是否有人会先说出来。如果会议结束时，我觉得还有一两张便利贴的内容值得一说，我才会说出来。但你必须自我约束，因为没人会替你做这件事。无论你觉得自己多么平易近人，别人都知道你是老板，他们不一定会抢你的话或直接挑战你。我面临的另一个挑战是，我是一个非常乐观的人，喜欢看光明的一面。我非常积极，但我认为取决于你所处的文化或团队，有时他们需要听到真正糟糕的情况，他们需要你表现得非常真实，需要你实话实说。我意识到，我曾经历过这样一件事：我没意识到大家觉得我不够真实，因为他们觉得某件事很糟糕，而我却没提。这并不是因为我不觉得它糟或没看到，只是因为我的天性是：“好吧，我不想谈论糟糕的事情，因为我们正在做该做的事。”只要计划是好的，我就没有真正强调我看到的所有问题，或者没有直接和团队一起正视这些问题。所以他们觉得不知道我看到了什么，或者我们是否在讨论同一件事。那真是一次有趣的经历。是的，这样的例子太多了。

---

### [00:51:49] Lenny

**English:**
With that second lesson, is there something you've changed in the way you lead and operate where you now found a way to communicate, "Here's wrong," in a way that's still maybe optimistic and productive?

**中文翻译:**
关于第二个教训，你在领导和运作方式上有什么改变吗？你现在是否找到了一种方式，既能沟通“这里出错了”，同时又保持乐观和高效？

---

### [00:52:00] Paige Costello

**English:**
I try to be more real with myself and others. I try to show up and say like, "Hey, this is incomplete." For example, even the thing I did this morning, the clarity brief. I said, "This is 70% finish. The 30% that I don't believe is there yet are these three things. I don't feel confident in this piece of it, and hopefully, we'll have more clarity by next week." So that's an example of just being as real with the small things as with the big things so that people can balance their perspective of you and your work, and the organization and the environment you're creating.

**中文翻译:**
我试着对自己和他人更真实。我试着站出来说：“嘿，这个还不完整。”例如，就像我今天早上做的那个“清晰度简报”。我说：“这完成了 70%。我认为还没到位的 30% 是这三件事。我对这一部分没有信心，希望到下周我们能更清晰一些。”这就是一个例子，无论大事小事都保持真实，这样人们就能平衡他们对你、你的工作、组织以及你所创造的环境的看法。

---

### [00:52:40] Lenny

**English:**
I'm curious how you think about your career going forward. How far out do you think where you want to be, and how do you plan out the future of Paige's career?

**中文翻译:**
我很好奇你如何思考未来的职业生涯。你会规划多远的目标？你如何规划 Paige 的未来职业生涯？

---

### [00:52:50] Paige Costello

**English:**
I try to be really intentional about staying as much as leaving a role. When I think about my career as a whole, I try to think about skills or experiences I want to have as opposed to roles, or companies, or specific problems. So something that I think about is... Effectively, I evaluate whether I'm in a healthy role and in a good setup by asking myself about my learning curve like, "Is the steepness of my learning curve doing me a favor here?" because sometimes you might love the organization, love the problem, and feel like you're just not learning, or learning fast enough, or being challenged. That's something that I think is really important. So thinking about the learning curve, thinking about whether the environment is positively impacting your ability to grow your career and make an impact. So, environmentally, you might have not enough staffing or tooling, or have someone in the management team who is toxic, or have a peer who is blah, blah, blah, blah, blah. That stuff matters, and I think people don't talk about it or take it seriously enough that your environment should include people who are advocating for you, and it should just be a place where you feel you've got the right ingredients to set you up to do the good work. Then, the third piece is really around just the problem, the problem your product is solving. Is it fun? Is it interesting? I often like to think about passions are made, not found because I think people... We do this with nine-year-olds. We say, "What do you want to be when you grow up?" They look cross-eyed, and they say, "An astronaut. Just getting a vet. I don't know." There's this moment of panic, and I would say that being comfortable, saying like, "Go try different things, and see if the problem is interesting to you and if the problem is fun or interesting to you." It doesn't mean it has to be sexy. It doesn't mean the company needs to have a brand name. It just has to be something that you're curious about so that you do a better job at your job. So I would say learning curve environment and problem are things that I use to assess like, "Am I still on the right path, or should I consider an alternative?" But when I think about my own career, I really think about skills and experiences as opposed to roles. So I would say that that's more my frame of reference because otherwise, I think I am living in the future and not enough trying to make the most out of the career I'm living right now.

**中文翻译:**
我试着非常有意识地对待“留下”和“离开”一个岗位。当我思考整个职业生涯时，我倾向于思考我想拥有的技能或经验，而不是具体的职位、公司或特定的问题。所以我考虑的一点是……实际上，我会通过询问自己的学习曲线来评估我是否处于一个健康的角色和良好的环境中，比如：“我学习曲线的陡峭程度是否对我有利？”因为有时你可能热爱这个组织，热爱这个问题，但感觉自己没有在学习，或者学得不够快，或者没有受到挑战。我认为这非常重要。所以要考虑学习曲线，考虑环境是否对你职业成长和产生影响有积极作用。在环境方面，你可能面临人手不足、工具匮乏，或者管理层中有害群之马，或者有个糟糕的同事等等。这些都很重要，我认为人们对此谈论得不够，或者不够重视。你的环境应该包括那些支持你的人，它应该是一个让你觉得拥有做好工作的正确要素的地方。第三点是关于问题本身，即你的产品正在解决的问题。它有趣吗？有吸引力吗？我常想，“激情是创造出来的，而不是找出来的”。我们常对九岁的孩子说：“你长大后想做什么？”他们斜着眼说：“宇航员。或者是兽医。我不知道。”那是一种恐慌时刻。我想说，要坦然面对，去尝试不同的事情，看看这个问题是否让你感兴趣，是否有趣。这并不意味着它必须很光鲜，也不意味着公司必须有名气。它只需要是你感兴趣的东西，这样你就能把工作做得更好。所以，学习曲线、环境和问题是我用来评估“我是否仍在正确的道路上，还是该考虑其他选择”的标准。但在思考我自己的职业生涯时，我真的更看重技能和经验，而不是职位。我想说这是我的参考框架，否则，我觉得自己会活在未来，而没有充分利用好当下的职业生涯。

---

### [00:55:44] Lenny

**English:**
Well, with that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
好了，接下来进入我们非常激动人心的闪电问答环节。我有六个问题要问你。准备好了吗？

---

### [00:55:49] Paige Costello

**English:**
Yeah. Let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [00:55:51] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [00:55:54] Paige Costello

**English:**
My go-to book recommendation for other PMs is inspired by Marty Cagan. I think it's a classic. The other books that I have enjoyed and recommended lately are The Blind Assassin by Margaret Atwood and The Alchemist by Paulo Coelho.

**中文翻译:**
我给其他 PM 的首选推荐书是 Marty Cagan 的《启示录》（Inspired），我认为它是经典。我最近喜欢并推荐的其他书是 Margaret Atwood 的《盲刺客》（The Blind Assassin）和 Paulo Coelho 的《牧羊少年奇幻之旅》（The Alchemist）。

---

### [00:56:11] Lenny

**English:**
What is a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视剧是什么？

---

### [00:56:14] Paige Costello

**English:**
Ooh, I'm very much enjoying The Diplomat right now, and then TV show or movie. Let's see. I just watched the Fire of Love documentary, which is about a couple who study volcanoes, and that was a great change of pace.

**中文翻译:**
噢，我现在非常喜欢《外交官》（The Diplomat）。电视剧或电影……让我想想。我刚看了纪录片《火山挚恋》（Fire of Love），讲的是一对研究火山的夫妇，那是一个很棒的节奏变换。

---

### [00:56:32] Lenny

**English:**
I saw the trailer for that. I think I got to watch that, and I finished The Diplomat. It's awesome. It ends really well.

**中文翻译:**
我看过那个预告片，我觉得我也得看看。我已经看完了《外交官》，非常棒，结局很好。

---

### [00:56:37] Paige Costello

**English:**
I'm not done. Don't spoil it.

**中文翻译:**
我还没看完呢，别剧透。

---

### [00:56:39] Lenny

**English:**
But it's just good. I'm just saying it's good. That's not spoiling.

**中文翻译:**
它就是很好看。我只是说它很好看，这不算剧透。

---

### [00:56:39] Paige Costello

**English:**
Okay.

**中文翻译:**
好吧。

---

### [00:56:45] Lenny

**English:**
Okay. Next question. What's a favorite interview question that you like to ask candidates?

**中文翻译:**
好的。下一个问题。你最喜欢问应聘者的面试问题是什么？

---

### [00:56:49] Paige Costello

**English:**
The good news is I can tell you this and still keep asking it because the answer has always come up differently. So I like to ask, "Tell me about a time something went wrong. What was it? What did you do about it? Yada, yada." Effectively, the question gets that, "When the product failed," When something about the team didn't work," just things that go wrong because that's what happens when you're doing this work, and evaluating people's mindset, and the way they talk about it, and the way they relate to evaluating the situation. I think it's a great question. Really tells you a lot about how people think and how they perceive themselves when things are not working well.

**中文翻译:**
好消息是，我可以告诉你这个问题，而且还能继续问，因为每个人的答案都不同。我喜欢问：“给我讲讲某次出状况的经历。发生了什么？你是怎么处理的？等等。”实际上，这个问题是为了了解“当产品失败时”或“当团队出现问题时”的情况，也就是那些出错的事情。因为在做这份工作时，出错是常有的事。通过这个问题可以评估人们的心态、他们谈论这件事的方式，以及他们如何评估当时的情况。我认为这是一个很棒的问题，能让你了解人们如何思考，以及在事情进展不顺时他们如何看待自己。

---

### [00:57:34] Lenny

**English:**
What is a favorite product that you've recently discovered that you love?

**中文翻译:**
你最近发现并喜爱的产品是什么？

---

### [00:57:37] Paige Costello

**English:**
I've been playing a lot with Poe.com lately. Yeah, just an opportunity to learn more about LLM capabilities in a firsthand way. It's been fun to create little bots. I'm playing with making a page bot. I can't say that the page bot could have had this conversation yet, but maybe next year at this time, you can have a conversation with the other me.

**中文翻译:**
我最近一直在玩 Poe.com。是的，这是一个亲身体验并了解 LLM 能力的机会。创建小机器人很有趣。我正在尝试做一个“Paige 机器人”。我不敢说现在的 Paige 机器人能进行这样的对话，但也许明年这个时候，你就可以和另一个我交谈了。

---

### [00:58:07] Lenny

**English:**
That's what the page bot would say if this was the page bot talking right now.

**中文翻译:**
如果现在是 Paige 机器人在说话，它也会这么说的。

---

### [00:58:10] Paige Costello

**English:**
I would say though that the advice, bits and bobs, I gave you earlier are absolutely things that I've been thinking about feeding, but I think the page bot would probably say, "Ship it."

**中文翻译:**
不过我想说，我之前给你的那些建议点滴，绝对是我考虑喂给它的内容。但我认为 Paige 机器人可能会说：“发布它（Ship it）。”

---

### [00:58:25] Lenny

**English:**
Poe. It's the Quora founder's LLM chat bot?

**中文翻译:**
Poe。是 Quora 创始人做的那个 LLM 聊天机器人吗？

---

### [00:58:30] Paige Costello

**English:**
Yeah, and so you can try the different models. So you can do four, and you play five, and Claude, and a few others. Yeah.

**中文翻译:**
是的，你可以尝试不同的模型。你可以用 GPT-4，也可以用 Claude 以及其他几个模型。

---

### [00:58:38] Lenny

**English:**
There's also a lennybot.com for folks that haven't seen this. Actually, there's a whole post on my newsletter of how it was built, and you get a lennybot.com. It is trained on all of my newsletter posts, and I think... not yet podcasts, but someday it will have podcasts.

**中文翻译:**
对于还没见过的朋友，还有一个 lennybot.com。实际上，我的时事通讯（newsletter）里有一篇关于它是如何构建的完整文章。它是在我所有的时事通讯文章上训练的，我想……目前还没有包含播客，但总有一天会有的。

---

### [00:58:55] Paige Costello

**English:**
Ooh.

**中文翻译:**
噢。

---

### [00:58:55] Lenny

**English:**
By the way, someone listening to this, we're looking for someone to maintain this bot and evolve it. So if you're really into this stuff and have done this sort of thing, please DM me on Twitter. I'm looking for someone to take over lennybot.com, make it more... Moving on. Enough about me. Next question. What is something relatively minor you've changed in your product development process that has had a big impact on your team's ability to execute?

**中文翻译:**
顺便说一下，听众朋友们，我们正在寻找能维护并改进这个机器人的人。如果你对这些东西非常感兴趣并做过类似的事情，请在 Twitter 上私信我。我正在找人接管 lennybot.com，让它变得更……好了，不说我了。下一个问题。在你的产品开发流程中，你做了哪些相对较小但对团队执行力产生重大影响的改变？

---

### [00:59:18] Paige Costello

**English:**
One of the biggest ones is just, once again, being real about how many reviews and approvals it takes for something to get done and who's actually responsible for reviewing and approving work. So we got really aggressive about, functionally, who is in charge and at what level for a given review, and pushed to say to actually have limits on the number of people per meeting, on the number of sub-task reviews for a given body of work. What this did is it created a lot more agency and pace within given working teams. So what we did was we said, "We actually don't care. We don't want a daisy chain of approvals. We just want one person with whom the buck can stop with them, and they can be responsible for how the work moves forward such that the knowledge is known and we could have connected the dots more effectively than we do or did." So that's the logic there, and it really changed the pace and quality of our work.

**中文翻译:**
其中一个最大的改变是，再次强调，真实地面对完成一件事需要多少次评审和批准，以及谁真正负责评审和批准工作。所以我们在职能上非常果断地确定了谁负责、在什么级别进行特定的评审，并强制限制了每次会议的人数，以及特定工作任务的子任务评审数量。这样做在具体的工作团队中创造了更多的自主权和更快的节奏。我们当时说：“我们其实不在乎，我们不想要那种链式的审批（daisy chain of approvals）。我们只需要一个人来最终拍板，由他负责工作的推进，这样知识是共享的，我们能比以前更有效地把点连接起来。”这就是背后的逻辑，它确实改变了我们工作的节奏和质量。

---

### [01:00:25] Lenny

**English:**
I love that. Is there any more you could share, a number? What is the maximum? Is there anything that other people maybe can take as a-

**中文翻译:**
我喜欢这个。还有什么可以分享的吗，比如一个数字？最大限制是多少？有没有什么别人可以借鉴的——

---

### [01:00:31] Paige Costello

**English:**
Yeah. So no more than three reviews on a given piece of work where people are blocking one approver. If a meeting has more than 10 people on it, we ask the person hosting the meeting to kick out the other people and write better decision notes.

**中文翻译:**
有的。对于特定的工作，评审不能超过三次，且不能有多人阻碍同一个审批人。如果一个会议超过 10 个人，我们会要求会议主持人请出多余的人，并写出更好的决策记录。

---

### [01:00:49] Lenny

**English:**
The three reviews is three meetings looking at the product as it's coming together, basically?

**中文翻译:**
这三次评审基本上是指在产品成型过程中进行三次会议查看，对吗？

---

### [01:00:54] Paige Costello

**English:**
The three reviews are three people who are assigned a task to look at something, but only one person is blocking whether it moves to the next stage.

**中文翻译:**
这三次评审是指有三个人被分配了查看某项内容的任务，但只有一个人有权决定是否进入下一个阶段。

---

### [01:01:03] Lenny

**English:**
Got it. Informed people? Stakeholders?

**中文翻译:**
明白了。知情者？利益相关者？

---

### [01:01:06] Paige Costello

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:01:06] Lenny

**English:**
Decision-makers? Okay. Great. Final question. You work at Asana. What is your favorite Asana pro tip?

**中文翻译:**
决策者？好的。太棒了。最后一个问题。你在 Asana 工作，你最喜欢的 Asana 使用秘籍（pro tip）是什么？

---

### [01:01:12] Paige Costello

**English:**
I use Asana to run all my meetings and assign pre-reads. So I use the multi-assign feature in subtasks all the time where I make a task with a due date that says, "Read this thing by this date," and then I assign it to a team or a set of individuals like that really quickly. Then, when I'm in the meeting, I take notes live in a task, and then highlight parts of those notes, and convert them into subtasks so that none of the action items get lost.

**中文翻译:**
我用 Asana 来主持我所有的会议并分配预读材料。我经常使用子任务中的“多重分配”功能，我会创建一个带有截止日期的任务，写着“在某日期前阅读此内容”，然后非常迅速地将其分配给一个团队或一组人。开会时，我会直接在任务中做记录，然后突出显示这些记录的部分内容，并将其转换为子任务，这样就不会遗漏任何行动项。

---

### [01:01:46] Lenny

**English:**
Wow. You need to make a video or blog post about this. Not only is it using Asana to build Asana, it's using Asana to run teams within Asana.

**中文翻译:**
哇。你应该为此拍个视频或写篇博客。这不仅是用 Asana 构建 Asana，还是用 Asana 来管理 Asana 内部的团队。

---

### [01:01:46] Paige Costello

**English:**
Yeah. It definitely does that, but-

**中文翻译:**
是的，确实如此，但是——

---

### [01:01:57] Lenny

**English:**
Asana all the way down.

**中文翻译:**
全程都在用 Asana。

---

### [01:01:58] Paige Costello

**English:**
People know who's responsible for what they want.

**中文翻译:**
人们知道谁该为他们想要的东西负责。

---

### [01:02:01] Lenny

**English:**
Amazing. Paige, you are awesome. Thank you so much for doing this. Two final questions. Where can folks find you online if they want to reach out and learn more, and how can listeners be useful to you?

**中文翻译:**
太棒了。Paige，你太出色了。非常感谢你参加节目。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？听众们能为你做些什么？

---

### [01:02:10] Paige Costello

**English:**
You can find me on LinkedIn and Twitter, Paige Costello, and on Twitter, @paigenow. Listeners, well, I'd love to hear how you think AI is going to shape the future of software for knowledge workers, but in particular, if you and your team use Asana, I'd love to know where you'd like to see AI playing a bigger role to drive efficiency alignment for your team. So, as you know, we offer a ton of goal management, work management pieces that help teams and orgs do their work together, and I'd love to hear from you about where you see the opportunity.

**中文翻译:**
你可以在 LinkedIn 和 Twitter 上找到我，名字是 Paige Costello，Twitter 账号是 @paigenow。听众朋友们，我很想听听你们认为 AI 将如何塑造知识工作者软件的未来。特别是，如果你和你的团队正在使用 Asana，我很想知道你们希望看到 AI 在哪些方面发挥更大作用，以推动团队的效率和对齐。如你所知，我们提供了大量的目标管理和工作管理功能来帮助团队和组织协作，我很想听听你们认为机会在哪里。

---

### [01:02:49] Lenny

**English:**
Awesome. Paige, again, thank you so much for being here.

**中文翻译:**
太棒了。Paige，再次感谢你的到来。

---

### [01:02:53] Paige Costello

**English:**
My pleasure. Thanks for having me.

**中文翻译:**
我的荣幸。谢谢你邀请我。

---

### [01:02:55] Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。