# Patrick Campbell - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Patrick Campbell.

---

### (00:00:00) Patrick Campbell

**English:**
The bratty thing here is that real professional ship. At the end of the day, real... I don't care if you're a marketer or a product person, engineer, ops person, people ops, real professional ship, and they ship at a pretty high frequency for whatever they're doing. In my opinion, your tempo framework is more important than your org design. And so if you've ever had a team that seems really, really smart, but they're always planning or they don't really ship a lot, or you've had trouble where everyone kind of gets it at the leadership level, but then the team below them and below them seems to be kind of going in a different direction, you probably don't have enough alignment and you don't have enough alignment on what good looks like in terms of tempo.

**中文翻译:**
这里有个比较尖锐的观点：真正的专业人士会交付（ship）。说到底，无论你是市场营销人员、产品经理、工程师、运营人员还是人力资源，真正的专业人士都会交付，而且无论他们做什么，交付频率都相当高。在我看来，你的“节奏框架”（tempo framework）比你的“组织设计”更重要。如果你曾遇到过这样一支团队：成员看起来都非常聪明，但他们总是在计划，或者产出并不多；或者你遇到过这种情况：领导层都明白目标，但下面的团队却似乎在朝不同的方向发展，那很可能是因为你们的共识（alignment）不够，尤其是在“什么是好的交付节奏”这一点上缺乏共识。

---

### (00:00:45) Audio (Intro)

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Patrick Campbell. Patrick is the founder and CEO of ProfitWell, which he bootstrapped and sold without any funding for over $200 million. I've been a big fan of ProfitWell and of Patrick for many years. He's one of the most insightful and smartest people that I know, constantly sharing wisdom on Twitter and in his newsletter, primarily on pricing and retention and team building and all of the elements of building a successful SaaS business.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Patrick Campbell。Patrick 是 ProfitWell 的创始人兼 CEO，他白手起家（bootstrapped），在没有任何融资的情况下将公司以超过 2 亿美元的价格售出。多年来我一直是 ProfitWell 和 Patrick 的忠实粉丝。他是我认识的最有见地、最聪明的人之一，经常在 Twitter 和他的简报中分享智慧，主要涉及定价、留存、团队建设以及构建成功 SaaS 业务的所有要素。

---

### (00:01:19) Audio (Intro Continued)

**English:**
I've been excited to get Patrick on the podcast since I launched it, and I think this may be the most action-packed signal-to-noise episode yet. We cover 10 topics in an hour, including hot takes on team building, bootstrapping, shipping, competitive analysis, user research, and of course, pricing and retention. Do not miss this episode, it is one of my new favorites. With that, I bring you Patrick Campbell, after a short word from our wonderful sponsors.

**中文翻译:**
自从我开办这个播客以来，就一直很想邀请 Patrick。我认为这可能是目前为止干货最多、信噪比最高的一集。我们在一个小时内涵盖了 10 个话题，包括关于团队建设、白手起家、交付、竞争分析、用户研究，当然还有定价和留存的犀利观点。千万不要错过这一集，它是我最喜欢的剧集之一。在听完赞助商的简短介绍后，让我们欢迎 Patrick Campbell。

---

### (00:01:45) Audio (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or are you going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table.

**中文翻译:**
本集节目由 Vanta 赞助。Vanta 帮助您简化安全合规流程，加速业务增长。如果您的企业在云端存储任何数据，那么您很可能已经被问到或即将被问到 SOC 2 合规性问题。SOC 2 是证明贵公司已采取适当安全措施保护客户数据的一种方式，有助于建立客户和合作伙伴（尤其是那些有严格安全要求的合作伙伴）的信任。此外，如果您想向企业级客户销售产品，证明安全性至关重要。SOC 2 既能为您开启更大、更好的交易之门，也可能让您的业务停滞不前。如果您没有 SOC 2，很可能连谈判桌都上不去。

---

### (00:02:31) Audio (Sponsor: Vanta Continued)

**English:**
Beginning a SOC 2 report can be a huge burden, especially for startups. It's time-consuming, tedious and expensive. Enter Vanta. Over 3,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
开始准备 SOC 2 报告可能是一项巨大的负担，尤其是对于初创公司而言。它耗时、乏味且昂贵。Vanta 应运而生。超过 3,000 家快速增长的公司使用 Vanta 自动完成高达 90% 的 SOC 2 相关工作。Vanta 可以让您在几周内（而不是几个月）做好安全审计准备，耗时不到通常时间的三分之一。在限定时间内，Lenny 播客的听众可享受 Vanta 1,000 美元的优惠。只需访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### (00:03:02) Audio (Sponsor: Amplitude)

**English:**
This episode is brought to you by Amplitude. If you're setting up your analytics stack but not using Amplitude, what are you doing? Anyone can sell you analytics while Amplitude unlocks the power of your product and guides you every step of the way. Get the right data, ask the right questions, get the right answers, and make growth happen. To get started with Amplitude for free, visit amplitude.com. Amplitude, power to your products.

**中文翻译:**
本集节目由 Amplitude 赞助。如果您正在搭建分析技术栈却没用 Amplitude，那您在想什么呢？任何人都能卖给您分析工具，但 Amplitude 能释放产品的力量，并在每一步为您提供指导。获取正确的数据，提出正确的问题，得到正确的答案，让增长发生。免费开始使用 Amplitude，请访问 amplitude.com。Amplitude，为您的产品赋能。

---

### (00:03:31) Lenny

**English:**
Patrick, welcome to the podcast.

**中文翻译:**
Patrick，欢迎来到播客。

---

### (00:03:33) Patrick Campbell

**English:**
Thanks for having me, man. Good to finally... we've been texting, chatting for years now and I just realized we've never had an actual conversation, so this is where the relationship and the friendship ends because we realize how awkward we are together, I guess.

**中文翻译:**
谢谢你的邀请，伙计。很高兴终于……我们已经发短信、聊天好几年了，我才意识到我们从未进行过真正的对话。所以我猜，这段关系和友谊可能就要在这里终结了，因为我们会发现彼此在一起有多尴尬。

---

### (00:03:48) Lenny

**English:**
I highly doubt it. I hope that doesn't happen. I've wanted to get you on this podcast ever since I started this podcast. It's always been on my list. You're just generally one of the smartest humans and most amazing humans I know, and so thank you for joining me on this podcast.

**中文翻译:**
我深表怀疑。我希望那不会发生。自从我创办这个播客以来，就一直想邀请你。你一直在我的名单上。你是我认识的最聪明、最了不起的人之一，所以感谢你参加我的播客。

---

### (00:04:02) Patrick Campbell

**English:**
We've got to introduce you to more people, but I appreciate that. I appreciate that.

**中文翻译:**
看来我得给你多介绍点人认识了，不过非常感谢，我很受用。

---

### (00:04:07) Lenny

**English:**
You're a humble, humble man. So usually what I do with these podcasts is I have this one main topic that I focus on, but I feel like you're such a renaissance man of a brain that I thought would be more fun to go through 10 different topics and power through them and see your perspective. I feel like you have all these contrarian takes on things and these interesting insights. And so what I want to do is just go through 10 topics and just get a sense of what's a big mistake founders companies make in this area, what's maybe a big opportunity they miss, or just like what's a hot take on this topic. How's that sound?

**中文翻译:**
你太谦虚了。通常在这些播客中，我会专注于一个主题，但我觉得你的大脑就像一个“文艺复兴全才”，所以我想如果能快速过一遍 10 个不同的主题，看看你的观点，会更有趣。我觉得你对很多事情都有这种反直觉的见解和有趣的洞察。所以我想做的是，过一遍 10 个话题，了解一下创始人或公司在这些领域常犯的错误、可能错过的重大机会，或者你对这些话题的犀利观点。你觉得怎么样？

---

### (00:04:43) Patrick Campbell

**English:**
Yeah, 100%. Let's do it. I'm going to change my Twitter bio to that, renaissance of a brain. That's [inaudible 00:04:50] for me. Yeah, I appreciate that.

**中文翻译:**
没问题，百分之百赞成。让我们开始吧。我要把我的 Twitter 简介改成那个——“文艺复兴式的大脑”。这对我来说太棒了。是的，谢谢。

---

### (00:04:52) Lenny

**English:**
Yeah, just renaissance [inaudible 00:04:55] that quote. That'd be hilarious. People will be like, "What the hell's he..." Anyway, let's just jump right in. First topic is building your team as a founder or just a leader of any kind. So here's the question, just what are the biggest mistakes people make building their team? What are the biggest opportunities people miss when they're building their team? Or just generally what's like your take on how to best approach building your team as a founder or just a leader of people?

**中文翻译:**
哈哈，就用那个引用。那会很有趣，人们会想，“这家伙到底在……” 无论如何，让我们直接开始吧。第一个话题是作为创始人或任何类型的领导者如何组建团队。问题是：人们在组建团队时犯的最大错误是什么？错过的最大机会是什么？或者总的来说，作为创始人或领导者，你认为组建团队的最佳方法是什么？

---

### (00:05:23) Patrick Campbell

**English:**
You always have to start answers with cliches, and I think the biggest cliche with building a team is, team is everything, right? If you're listening, you've heard that, you've probably said that to somebody or gotten mentored on that. And I was told that in the early days of building, and I actually thought it was terrible advice. I thought it was going to be the product or marketing or something that was going to hold us back. But I think that although team is everything, and I truly believe that, if you look at most data or most behaviors that most companies make, this isn't actually how we think or what we do.

**中文翻译:**
回答这类问题总得从陈词滥调开始。我认为组建团队时最大的陈词滥调就是“团队就是一切”，对吧？如果你在听，你肯定听过这句话，或者对别人说过，或者接受过这方面的指导。在我创业初期，别人也这么跟我说，当时我觉得这是个糟糕的建议。我以为阻碍我们的会是产品、营销之类的东西。但我觉得，虽然“团队就是一切”——我也确实深信不疑——但如果你观察大多数公司的数据或行为，这其实并不是我们真正的思考方式或做法。

---

### (00:05:55) Patrick Campbell (Continued)

**English:**
Let me give you two fundamental issues. I think the first one is we confuse team by being everything to all people to accommodating to every single person, and especially in tech the last couple of years, maybe that's going to change a little bit now, but it was always like, "Oh, everyone needs to be happy." And I think that's a really, really big misconception because you're not there to make everyone happy. You're there for some sort of mission and some sort of goal and you want to set up the culture and the team in a way that gets to that particular goal.

**中文翻译:**
让我指出两个根本问题。第一，我们把“团队就是一切”误解成了“要满足所有人”，去迎合每一个人。尤其是在过去几年的科技界，虽然现在可能有所改变，但以前总是强调“哦，每个人都要开心”。我认为这是一个巨大的误区，因为你的存在不是为了让每个人都开心。你的存在是为了某种使命和目标，你需要建立一种文化和团队，以实现那个特定的目标。

---

### (00:06:24) Patrick Campbell (Continued)

**English:**
And I think the little bit more actionable way to look at this is, I don't think we actually focus on our team. The average tenure of a manager in tech right now is about 15.7 months. I actually went and looked into this mainly because we got into hyperdrive about team a couple of years ago. The average time a report has the same manager in corporate tech is only about 10.8 months, so just under 11 months. And there's no way that team is everything, or at least we actually believe that when the purveyors of your team, your management only lasts that long, it's just impossible.

**中文翻译:**
从更具操作性的角度来看，我认为我们并没有真正关注团队。目前科技行业经理的平均任期约为 15.7 个月。我专门研究过这个问题，主要是因为几年前我们开始疯狂关注团队建设。在科技公司中，下属拥有同一位经理的平均时间仅为 10.8 个月，也就是不到 11 个月。如果你的团队管理者、你的管理层只能维持这么短的时间，那根本不可能实现“团队就是一切”，或者说我们根本不相信这一点。

---

### (00:06:57) Patrick Campbell (Continued)

**English:**
And I think for the most part, people ops is an afterthought. And even if you get into the history of HR, which we should not do because that's an entire podcast, it's all about reacting. It came out of the labor movement in the mid 1900s, and it was all about, "Hey, how do we CYA?" rather than, "How do we push our team forward?" And I think in tech we had the opportunity to do that, but we haven't really focused on our team as much. So I don't know if I answered your question, but that's the scope of that problem I think, is we don't actually focus on our team, we don't actually focus on our team in the context of the mission. We just hire people, hope they're really happy. And obviously I'm generalizing, but if you look at the stats and you look at what's happening, that's how it shakes out.

**中文翻译:**
我认为在大多数情况下，人力资源运营（People Ops）都是事后才想到的。如果你去研究人力资源的历史（我们不该在这里细说，因为那能讲一整集播客），你会发现它全是关于“反应性”的。它起源于 20 世纪中叶的劳工运动，核心是“嘿，我们如何免责（CYA, Cover Your Ass）？”而不是“我们如何推动团队前进？”我认为在科技界我们本有机会改变这一点，但我们并没有真正给予团队足够的关注。所以我不知道是否回答了你的问题，但我认为问题的核心在于：我们没有真正关注团队，没有在使命的背景下关注团队。我们只是雇人，然后希望他们开心。显然我是在概括，但如果你看统计数据和现状，结果就是这样。

---

### (00:07:38) Lenny

**English:**
Is there something you've done in building your company that has been counter to that, something you've learned about? Because I totally agree, people always talk about team, team, team and then that's often really sucky to work at a lot of companies and clearly they don't care that much about your experience.

**中文翻译:**
在创建公司的过程中，你有没有做过什么与此相反的事情，或者学到了什么？因为我完全同意，人们总是在谈论团队、团队、团队，但在很多公司工作体验其实很糟糕，显然他们并没那么在乎你的体验。

---

### (00:07:52) Patrick Campbell

**English:**
So super actionable things that we've done. I think, one, it comes back to the baseline feedback or advice you've probably received, or if you're listening to this before, which is you can't be everything to all people, so who are you for? Who are you for and who are you not for? I think really defining that in your values, and values aren't values unless there's an actual trade-off. And so we had things like optimize for the long-term. There's a clear trade-off when we optimize for the long-term, you probably give up short-term revenue.

**中文翻译:**
我们做过一些非常具有操作性的事情。第一，这回到了你可能听过的基础建议：你不可能满足所有人，所以你到底是为谁服务的？你适合谁，不适合谁？我认为要在价值观中明确定义这一点。而且，如果没有实际的权衡（trade-off），价值观就不是真正的价值观。比如，我们有一条是“为长期优化”。当我们为长期优化时，有一个明确的权衡，那就是你可能会放弃短期收入。

---

### (00:08:22) Patrick Campbell (Continued)

**English:**
You also have different types of people that do better at the particular company than not. One of the more controversial things we did is we talked a lot about behaviors and the one thing that we had is this concept known as the most charitable interpretation. It's not something we made up, but there's this idea that basically when there's conflict or when there's some sort of confrontation, the way that you handle that confrontation was really, really important to us. And the way that we wanted our teams or the people that we wanted to hire for basically would take the most charitable interpretation of that confrontation.

**中文翻译:**
不同类型的人在特定公司的表现也会有所不同。我们做过的比较有争议的一件事是，我们非常强调行为准则，其中一个核心概念叫做“最善意的解释”（Most Charitable Interpretation, MCI）。这不是我们发明的，但它的核心理念是：当发生冲突或某种对抗时，你处理对抗的方式对我们来说至关重要。我们希望我们的团队或我们想雇佣的人，能够对那种对抗做出最善意的解释。

---

### (00:08:53) Patrick Campbell (Continued)

**English:**
So Lenny, if you were like, "Hey, Patrick, I like your shirt," and I just didn't like when people commented on my shirt, instead of getting pissed off, going to HR, or getting mad at you, what we would do is we'd say, "Hey, the right way at ProfitWell wall to handle that was be like, 'He didn't know, so I'm not going to bring it up,' or 'Hey, Lenny. You probably didn't know, but I don't really like when people comment on my shirt.'"

**中文翻译:**
所以 Lenny，如果你说：“嘿，Patrick，我喜欢你的衬衫”，而我恰好不喜欢别人评论我的衣服。我不会生气、去找 HR 或对你发火，在 ProfitWell，正确的处理方式应该是想：“他不知道我不喜欢，所以我不打算提这件事”，或者直接说：“嘿，Lenny，你可能不知道，但我不太喜欢别人评论我的衬衫。”

---

### (00:09:14) Patrick Campbell (Continued)

**English:**
It seems super trivial, but when you have over 20 people, all of a sudden these things start to come up. And I think most of the time we infantilize our teams where we let them run to HR, we have different policies or all of these different things, when at the end of the day you're paying an exorbitant amount of money for very smart human beings to basically do stuff and you want them basically working together and not having to go in this runaround with policies and people to push things forward.

**中文翻译:**
这看起来微不足道，但当你拥有超过 20 个人时，这些问题就会突然冒出来。我认为大多数时候我们把团队“幼稚化”了，让他们一有问题就跑去找 HR，制定各种政策。但归根结底，你付了高昂的薪水请聪明人来做事，你希望他们能协作，而不是在政策和人事纠纷中打转来推动工作。

---

### (00:09:41) Lenny

**English:**
I love that. It reminds me of something at Airbnb where our head of product was always encouraging us to assume good intent from the other person that just like, "What is the good version of what they're trying to achieve? It's unlikely they're trying to cause harm."

**中文翻译:**
我喜欢这个。这让我想起在 Airbnb 的一些经历，我们的产品负责人总是鼓励我们“假设对方是出于好意”，即：“他们想要实现的好的版本是什么？他们不太可能是想造成伤害。”

---

### (00:09:54) Patrick Campbell

**English:**
But the important part is, and this is where you really care about your team, is if you believe that, and it's okay to have a culture that doesn't believe that, it's not a culture for me, and that's okay, that's the entire point, but if you believe that, then people who have trouble assuming positive intent or who have trouble taking the most charitable interpretation, they can't be at your company, and they have to go and you have to find... And we would have people, and we didn't always defend this and when we started defending it, everything got better.

**中文翻译:**
但关键在于——这也是你真正关心团队的地方——如果你相信这一点（当然，不相信这一点的文化也可以存在，只是不适合我，这正是重点），那么那些难以假设他人好意或难以做出最善意解释的人，就不能留在你的公司。他们必须离开。我们以前也有这样的人，我们并不总是坚持这一原则，但当我们开始坚持时，一切都变好了。

---

### (00:10:14) Patrick Campbell (Continued)

**English:**
But all of a sudden we would say, "Hey, it seems like this is really tough. This is how we think about things. This is how we handle this type of behavior here. If that's hard for you, let's find you another job." And thankfully we're not digging ditches here, we're all working in tech. And so it's "easy", quote-unquote, enough to find another gig even in economies like now.

**中文翻译:**
我们会突然说：“嘿，看起来这（种文化）对你来说很难。这是我们的思考方式，这是我们处理此类行为的方式。如果你觉得很难适应，那我们帮你找另一份工作吧。” 幸好我们不是在挖战壕，我们都在科技行业工作。所以即使在现在的经济环境下，找另一份工作也相对“容易”。

---

### (00:10:41) Lenny

**English:**
That reminds me of there's this guy Douglas Atkin, who I worked with for a while who helped us craft the core values at Airbnb, and he made this point that your values need to be clear, exactly like you said, who doesn't fit, who doesn't belong. Because if it's everybody, it's worthless. Integrity, trust, everyone wants that and it fits into that, but it's only valuable if it's clear who's not a fit, exactly how you're saying it.

**中文翻译:**
这让我想起和我共事过一段时间的 Douglas Atkin，他曾帮助我们制定 Airbnb 的核心价值观。他提出一个观点：价值观必须清晰，就像你说的，要明确谁不合适、谁不属于这里。因为如果价值观适用于所有人，那它就毫无价值。正直、信任，每个人都想要这些，但只有当它能明确谁不符合要求时，它才有价值，正如你所说。

---

### (00:11:07) Patrick Campbell

**English:**
Well, we get this fear of that accommodation culture, again, where it starts even in the interview process, we're like, "Oh my god, we need these hires, we need these salespeople, we need these engineers." So we don't end up being upfront with these values and these trade-offs in the interview process. And then all of a sudden you spend a lot of time and a lot of money hiring someone who just doesn't fit. And I think that's really, really bad for them, it's really bad for you.

**中文翻译:**
是的，我们常会陷入那种“迁就文化”的恐惧中。这种恐惧甚至从面试就开始了，我们会想：“天哪，我们需要这些新员工，我们需要销售，我们需要工程师。” 结果我们在面试过程中就没有坦率地说明这些价值观和权衡。然后突然间，你花了大量时间和金钱雇了一个完全不合适的人。我认为这对他们非常糟糕，对你也非常糟糕。

---

### (00:11:42) Patrick Campbell (Continued)

**English:**
And so that was the other thing is we would pull all of this forward into the interview process and talk about it and basically say like, "Hey, if this is not how you think, that's okay. We're not better than you, you're not better than us, it's just this is how we do things here." And I think a lot of times we're scared to do that because we have that founder, that exact fear of, "Hey, we have to get this thing done and the only way to do that is to do X, Y or Z Z when in reality that's actually going to make your deadline go out further than actually focusing on alignment as much as humanly possible.

**中文翻译:**
所以另一件事是，我们会把这些内容提前到面试环节，并明确表示：“嘿，如果这不是你的想法，没关系。我们不比你优越，你也不比我们优越，只是我们这里就是这么做事的。” 我觉得很多时候我们不敢这么做，是因为创始人有一种恐惧：“嘿，我们必须完成这件事，唯一的办法就是做 X、Y 或 Z”，但实际上，这种做法反而会拖慢进度，还不如尽可能地达成共识。

---

### (00:12:00) Lenny

**English:**
Next topic, bootstrapping. I feel like you're probably in the bootstrap hall of fame. You built a company-

**中文翻译:**
下一个话题，白手起家（Bootstrapping）。我觉得你大概可以进“白手起家名人堂”了。你建立了一家公司——

---

### (00:12:06) Patrick Campbell

**English:**
Here we go. That's all I've ever wanted.

**中文翻译:**
来了，这正是我梦寐以求的。

---

### (00:12:09) Lenny

**English:**
I think you're in there. So you tell me if I'm missing anything, but basically you bootstrapped a company, sold it for 200 million. I don't know if I've heard of anything like that. So what's your hot take? What are mistakes people make around bootstrapping?

**中文翻译:**
我觉得你当之无愧。如果有遗漏请纠正我，但基本上你白手起家创办了一家公司，并以 2 亿美元的价格售出。我还没听说过类似的案例。那么你的犀利观点是什么？人们在白手起家时会犯哪些错误？

---

### (00:12:22) Patrick Campbell

**English:**
The basic idea is bootstrapping is for lifestyle businesses that want to cash flow. Funding is for companies trying to create a billion dollars in annual revenue. And that answer offends everybody. That answer offends the indie friends I have, they're going to be like, "Oh, what about Basecamp [inaudible 00:12:43], ProfitWell?" And I'll tell you, ProfitWell, this was a big mistake. Yes, it was a great exit, we sold for over $200 million, et cetera, but we probably, if we had taken money, we could have had a billion-dollar exit or we could have kept going.

**中文翻译:**
基本观点是：白手起家适合追求现金流的“生活方式型业务”（lifestyle businesses）；而融资适合那些试图创造 10 亿美元年收入的公司。这个回答得罪了所有人。它得罪了我的独立开发者朋友，他们会说：“噢，那 Basecamp 和 ProfitWell 呢？” 我告诉你，ProfitWell 曾犯过一个大错。是的，那次退出很成功，我们卖了 2 亿多美元等等，但如果我们当时拿了钱，我们可能会有 10 亿美元规模的退出，或者可以继续走下去。

---

### (00:12:56) Patrick Campbell (Continued)

**English:**
And we should have taken money earlier in our life cycle. This was actually a big mistake because we got hooked on the efficiency and that was great, but we could have moved even quicker than we were. And hindsight is 20/20, and I'm obviously not crying over this, but it's one of those things that I think that you have to know who you are and you have to know what your goals are for a company. Our biggest thing was we wanted to build a big company and we were going after that, but we weren't doing the things in order to actually make that happen, which is i.e. getting funded. So yeah, that's my hot take and hopefully I offend everyone. But it's also just the end of the Twitter argument where it's like, "Yeah, it depends," but that's the thing to think about.

**中文翻译:**
我们本该在生命周期的更早阶段拿钱。这其实是个大错误，因为我们沉迷于效率，这固然很好，但我们本可以比当时跑得更快。事后诸葛亮总是容易的，我显然不是在为此哭诉，但我觉得你必须了解自己，了解你对公司的目标。我们最大的目标是建立一家大公司，我们也一直在朝这个方向努力，但我们没有做那些真正能实现目标的事，即融资。所以，这就是我的犀利观点，希望能冒犯到所有人。但这也就是 Twitter 上争论的终点，即“这取决于具体情况”，但这是值得思考的一点。

---

### (00:13:38) Lenny

**English:**
It's interesting because usually you hear from the other end, someone that raised VC money is like, "I shouldn't have raised money, I should have bootstrapped this thing longer." It's cool to hear from the other side someone that did that like, "No, we maybe should have raised the VC money along the way."

**中文翻译:**
这很有趣，因为通常你听到的是另一方的说法，某个拿了风投钱的人会说：“我不该拿钱的，我应该白手起家坚持更久。” 听到另一方的声音很酷，一个白手起家的人说：“不，我们也许应该在过程中拿点风投的钱。”

---

### (00:13:50) Patrick Campbell

**English:**
Well, I think there's a lot of ideas that should not raise money. There's a lot of ideas that should just be great cash flowing and they can be large businesses. There's large businesses cash flowing tens of millions of dollars without funding. And I think it's just one of those things that you need your goals, your model, and ultimately your funding situation all to match. And I think a lot of folks, they go in the opposite direction where they're just like, "Oh, everything on TechCrunch, everything on Twitter is like, "Hey, I need to raise money, raise money, raise money." And they don't take a step back and go like, well that idea, it's just not a very good business to get money.

**中文翻译:**
我认为有很多点子是不应该融资的。很多点子就应该做成优秀的现金流业务，它们也可以成为大公司。有很多大公司在没有融资的情况下，每年有数千万美元的现金流。我认为关键在于你的目标、你的模式以及最终的融资状况必须匹配。我觉得很多人走偏了，他们觉得：“噢，TechCrunch 和 Twitter 上都在说‘嘿，我需要融资，融资，再融资’。” 他们没有退一步想，其实那个点子并不是一个适合拿钱的好业务。

---

### (00:14:37) Lenny

**English:**
I've been thinking about writing a post on that exact topic, something like, "Your startup probably is not venture scale," because a lot of people think they could raise money and build a huge business. What's a heuristic that maybe tells a founder that they shouldn't raise money, it's never going to be a billion-dollar company?

**中文翻译:**
我一直想写一篇关于这个话题的文章，题目大概是“你的初创公司可能不具备风险投资规模（venture scale）”，因为很多人认为只要能融到钱就能做大。有没有什么启发式的标准可以告诉创始人，他们不应该融资，因为这永远不会成为一家价值 10 亿美元的公司？

---

### (00:14:53) Patrick Campbell

**English:**
I used to look at it 10 years ago you'd say, "Is this a company that can get to 100 million in annual revenue?" And now those numbers are all changed because IPOs are happening closer to 200, 250 million and the markets are all over the place depending on the day. I look at this as if you are going to be that large company, you need to get to a billion in revenue per year. It doesn't have to be overnight, it can be over 20 years, it's not something that has to happen quickly, but that's how I think about it.

**中文翻译:**
十年前，标准可能是：“这家公司年收入能达到 1 亿美金吗？” 现在这些数字都变了，因为 IPO 通常发生在年收入接近 2 亿或 2.5 亿美金的时候，而且市场每天都在波动。我的看法是，如果你想成为那样的巨头，你需要达到每年 10 亿美金的收入。这不一定是一夜之间发生的，可以是 20 年的过程，不需要很快，但我就是这么想的。

---

### (00:15:38) Patrick Campbell (Continued)

**English:**
And if I don't feel like there's a clear path to that, it doesn't mean I don't raise money. It just means that I take a step back and really think about that particular idea because when you get on that treadmill, there's plenty of ideas that will sell for 400 million, 500 million. But then if you're on the funding treadmill and you look at how much money that founder that exec team ends up getting at the end of it's like you might have been better just building a 50 million cash flowing business that you're getting more money from that and you still have the choice to sell it.

**中文翻译:**
如果我觉得没有清晰的路径能达到那个规模，并不意味着我不融资。这只是意味着我会退一步，认真思考那个特定的点子。因为一旦你踏上融资的跑步机，虽然有很多点子能卖到 4 亿或 5 亿美金，但如果你在融资的跑步机上，最后创始人或高管团队分到的钱，可能还不如你直接做一个年现金流 5000 万美金的业务，那样你赚得更多，而且你仍然可以选择卖掉它。

---

### (00:15:52) Patrick Campbell (Continued)

**English:**
So that's how I think about it. It's a spectrum and it's on the margins there. It's not a fixed rule. But the other thing I also think about when I think about building my next company, we're going to be bootstrapped for, I don't know what... It's not a timeline, but I had imagined probably the first 18 to 24 months because I don't want to give up that equity for that funding on figuring out the idea. Obviously, I had an exit so I'm able to afford that and I'm in a position where I don't have to worry about my own livelihood.

**中文翻译:**
这就是我的思考方式。这是一个光谱，处于边缘地带，不是死板的规则。但我考虑建立下一家公司时，我想我们会先白手起家一段时间，我不知道具体多久……不是一个确定的时间表，但我设想可能是前 18 到 24 个月，因为我不想在摸索点子阶段就为了融资放弃股权。显然，我有过一次成功的退出，所以我负担得起，也不必担心生计。

---

### (00:16:22) Patrick Campbell (Continued)

**English:**
But I think it's one of those things if you can bootstrap, even if you're going after a funded idea, if you can bootstrap for the initial ideation and maybe even through product market fit, which is not an easy thing to do, but that's the ideal time then to raise because then you're just going and you're going for the fences at that point.

**中文翻译:**
但我认为，如果你能白手起家，即使你追求的是一个适合融资的点子，如果你能在最初的构思阶段，甚至在达到产品市场匹配（PMF）之前保持自筹资金（这并不容易），那将是融资的理想时机。因为到那时，你就可以全力以赴，追求本垒打了。

---

### (00:16:37) Lenny

**English:**
I really like that very concrete stat you shared and that's exactly how we think about it, that if you don't think you can get to a billion dollars in revenue a year eventually that it probably is not a venture-scale business. And I think that just boils down to how large is the market. If there's not enough people that are going to pay enough money to make this a billion dollar a year in revenue business, you probably shouldn't go down the VC treadmill.

**中文翻译:**
我非常喜欢你分享的那个具体数据，这正是我们的思考方式：如果你认为最终无法达到每年 10 亿美元的收入，那么它可能就不具备风险投资规模。我认为这归根结底取决于市场有多大。如果没有足够多的人愿意支付足够的钱，让这成为一项年收入 10 亿美元的业务，你可能就不应该走上风投这条路。

---

### (00:16:59) Patrick Campbell

**English:**
And I think when you think about that, it opens up this world of options for you as someone listening to this. And so think of it this way, you don't have to have the pressure to create a billion dollars in revenue If you can take a step back and be like, "Okay, I can create a $10-million business." You're listening to this and probably you're like, "I don't know." But if you were a director level somewhere at a corporate company or you're leading product somewhere, you can go create a $10-million business. It might not happen overnight, it might take 10 years, all these other things. But that's amazing. That's insane.

**中文翻译:**
当你这样思考时，它会为你（作为听众）打开一个充满选择的世界。你可以这样想：你不需要背负创造 10 亿美元收入的压力。如果你能退一步想：“好吧，我可以创造一个 1000 万美元规模的业务。” 你听着可能会觉得：“我不确定。” 但如果你在某家公司是总监级别，或者在某处领导产品，你完全可以去创造一个 1000 万美元规模的业务。这可能不会一夜之间发生，可能需要 10 年，但那也非常了不起，简直太疯狂了。

---

### (00:17:33) Patrick Campbell (Continued)

**English:**
Think of 20, 30, 40, 50 years ago, you'd have to have a corner store and you'd have to work 18 hours a day to build that type of ability or that wealth to then hopefully retire when you're 65 and sell the business for 1X. Now you can build a software company that's doing a million a year, have an amazing life, reduce the number of hours if you want, or go all in, make it into a 10 or $100-million company over time. And I think that's amazing and we should celebrate that rather than if it's not a billion, you're failing. But we should just know our limits. I think that's the thing a lot of people fail out with funding.

**中文翻译:**
想想 20、30、40、50 年前，你必须开一家街角小店，每天工作 18 小时，才能积累那样的能力或财富，然后希望在 65 岁退休时以 1 倍的估值卖掉生意。现在，你可以建立一家年收入 100 万美元的软件公司，过上精彩的生活，如果愿意还可以减少工作时间，或者全力以赴，随着时间的推移将其做成 1000 万或 1 亿美金的公司。我认为这很棒，我们应该为此庆祝，而不是觉得“如果不到 10 亿就是失败”。我们只需要知道自己的极限。我认为这就是很多人在融资路上失败的原因。

---

### (00:18:09) Lenny

**English:**
Next topic, pricing. You are probably the most... okay, you're in the top 1% smartest, most experienced people on pricing. We could have done a whole podcast on pricing, maybe we will in the future, but as maybe one of 10 topics, what comes to mind as maybe the biggest mistake people make in pricing, biggest opportunity they miss, biggest hot take?

**中文翻译:**
下一个话题，定价。你可能是最……好吧，你是定价领域最聪明、经验最丰富的 1% 的人。我们本可以做一整集关于定价的播客，也许以后会做。但作为 10 个话题之一，你认为人们在定价方面犯的最大错误、错过的最大机会或最犀利的观点是什么？

---

**Patrick Campbell** (00:18:31):
It's super boring, but the biggest hot take is you just have to do something once a quarter. That's it. I've been trying to teach about pricing for a decade now. I've done a lot of different approaches on this, and I think the easiest thing is, listen, you have three growth levers. You have acquiring customers, monetizing them, and retaining them. You're spending a lot of time and money on acquisition. You're spending some time and money on retention. You're probably do nothing on pricing and monetization and it's because you think it's this nebulous thing and there are some nebulous aspects to it.

**中文翻译:**
这听起来超级无聊，但最犀利的观点是：你只需要每季度对定价做点什么。就这么简单。我已经尝试教定价十年了。我尝试过很多不同的方法，我认为最简单的是：听着，你有三个增长杠杆——获取客户、变现和留存。你在获取客户上花了大量时间和金钱，在留存上也花了一些。但在定价和变现上，你可能什么都没做，因为你觉得它太虚无缥缈了，确实它有一些模糊的地方。

---

**Patrick Campbell** (00:19:06):
But to make it super concrete, it is the revenue per customer. Look at that number, that one KPI, and you want that number going up and to the right, it's obviously going to go to the right over time, but you want it to going up over time every single quarter, not as high as your sales volume or your lead volume or your revenue maybe. But you want that number gradually going up and just do one thing per quarter. The least sexy thing when it comes to pricing is have a pricing committee. If it's a two-person company, it's you and your co-founder. If it's a 100,000-person company, it might be 30 people, but really it's only eight people central to that particular product.

**中文翻译:**
但为了让它变得非常具体，它就是“单客收入”（revenue per customer）。盯着这个数字，这一个 KPI，你希望这个数字向右上方增长。随着时间的推移，它显然会向右移动，但你希望它每个季度都能上升。增长速度可能不如你的销售额、线索量或总收入那么快，但你希望它稳步上升。每季度只做一件事。关于定价最不吸引人的一件事就是成立一个“定价委员会”。如果是两个人的公司，就是你和合伙人；如果是 10 万人的公司，可能是 30 人，但实际上核心成员只有 8 个。

---

**Patrick Campbell** (00:19:42):
And then just realize there's a lot of things that influence that revenue per customer. There's the actual price, your packaging, your add-on strategy, your discount strategy, your price localization, freemium. There's a whole host of different things there, but just find one thing you're going to do every three months, put a calendar invite, let it renew every three months. You're going to snooze it a couple of times, I get it, I've seen this many, many times before. But just do something, even if it's super small. I guarantee you it's just like any other thing you measure, as soon as you start measuring and caring about it, you're going to start to do some stuff, some of it is going to go poorly, some of it is going to go great. Then you're going to do more stuff, and then just over time, all of a sudden that number's going to go up into the right. But just do something. That's the basic idea.

**中文翻译:**
然后要意识到，有很多因素会影响单客收入：实际价格、包装（packaging）、增值策略、折扣策略、价格本地化、免费增值模式（freemium）等等。有很多不同的切入点，但只要每三个月找一件事来做，在日历上设个提醒，让它每三个月循环一次。你可能会推迟几次提醒，我理解，我见过太多次了。但只要做点什么，哪怕是很小的事。我向你保证，就像你衡量的任何其他指标一样，一旦你开始衡量并关注它，你就会开始采取行动，有些会失败，有些会成功。然后你会做得更多，随着时间的推移，那个数字突然就会向右上方增长。总之，动起来，这就是核心思想。

---

**Lenny** (00:20:24):
I love the simplicity of that. If I think about the pie chart of the things you will do and may change, you mentioned a few. One is raise prices. One may be lower prices. One's probably change your pricing model. There's a couple more. I guess, in your experience, where have you found the biggest opportunities end up being maybe early in the early phase of a startup in that pie chart?

**中文翻译:**
我喜欢这种简单性。如果我考虑一下你可以做和可能改变的事情的饼图，你提到了几个：一是涨价，二是降价，三可能是改变定价模式。还有其他的。我想知道，根据你的经验，在初创公司的早期阶段，那个饼图中最大的机会通常在哪里？

---

**Patrick Campbell** (00:20:47):
The number one thing to figure out when you're thinking about the different pricing pieces, pound for pound, it's the pricing metric or the value metric. That's how you charge per user, per thousand visits, per thousand what's its, whatever it is. Consumer companies, it's a little bit harder. Physical good products, it's really hard obviously because you have that physical good, the physics you can't get over. But the reason this is so powerful is because if you get everything else in your pricing wrong or not great, but you get that right, you tend to be okay when it comes to monetization.

**中文翻译:**
在考虑不同的定价组成部分时，最重要的一点——按重要性排名——是“定价指标”或“价值指标”（value metric）。也就是你按什么收费：按用户数、按每千次访问、按每千个某某东西。对于消费类公司来说，这稍微难一点。对于实物产品，显然很难，因为实物有你无法逾越的物理成本。但这个指标之所以强大，是因为即使你定价的其他方面都错了或做得不好，只要这个指标选对了，你的变现通常就不会出大问题。

---

**Patrick Campbell** (00:21:21):
And the reason is because, first, from an acquisition standpoint like acquiring customers, you end up making sure that you get Disney coming into your product, they're paying Disney prices, and then you get Johnny or Jane's startup coming in and they're paying Johnny and Jane prices. You don't want them paying the same thing because obviously the value's different, even if they're consuming almost the same amount. So this allows you to figure that line out.

**中文翻译:**
原因在于，首先，从获客的角度来看，这能确保当迪士尼使用你的产品时，他们支付的是“迪士尼级别”的价格；而当张三或李四的初创公司进来时，他们支付的是“初创公司级别”的价格。你不希望他们付同样的钱，因为显然价值是不同的，即使他们消耗的资源差不多。所以这能帮你划清界限。

---

**Patrick Campbell** (00:21:44):
And then what's really beautiful about it is churn tends to be about 20 to 25% lower because people will downgrade, but they're using... you don't get this like, "I'm paying for so much and end up not using a lot of it." It's like, "Oh, I'm using eight seats this month, I'm going to downgrade," or it's just automatic. And then your expansion revenue's typically double when you're using a particular value metric because instead of me having to resell you and being like, "Hey, Lenny, there's this really cool feature in this upper tier, do you want this?" And you're like, "I already use the product, I don't really want this." Instead, I just go, "Hey, Lenny, congratulations. You now have 100 videos in your account. That's awesome. You guys must be growing. I'm just going to bump you up to the 100-video plan. Let me know if you have any questions." It's just a very, very implicit way to get expansion revenue. So that's the thing pound for pound that's the best.

**中文翻译:**
其次，最美妙的一点是，流失率通常会降低 20% 到 25%，因为人们会降级，但他们还在使用……你不会听到这种抱怨：“我付了这么多钱，结果根本没用多少。” 而是：“噢，我这个月只用了 8 个席位，我要降级”，或者系统自动调整。此外，当你使用特定的价值指标时，你的“增购收入”（expansion revenue）通常会翻倍。因为我不需要重新向你推销说：“嘿 Lenny，高阶版本有个超酷的功能，你要吗？” 你可能会说：“我已经在使用产品了，我不需要那个。” 相反，我只需说：“嘿 Lenny，恭喜！你的账户里现在有 100 个视频了。太棒了，你们一定在增长。我要把你升级到 100 视频套餐了，有问题随时找我。” 这是一种非常含蓄的获取增购收入的方式。所以，按重要性来说，这是最棒的。

---

**Patrick Campbell** (00:22:30):
And then I would say if you have a lot of politics internally, which everyone does with pricing because it sits in the center of so many different teams, I would actually start with a price increase. You should be increasing your overall price once per year if you're building. If you're not building and your support sucks and your NPS is low, then don't worry about it. But if your NPS is over 20, which is not a very high NPS, you should raise your prices once per year. The reason I suggest that is because it gets all of the BS and all the politics on the mat. You're going to have to collect some data, you're going to have to prove it to sales, you're going to have to make sure you have the enablement, you're going to have to make sure your messaging is...

**中文翻译:**
另外我想说，如果你们内部有很多政治斗争（定价通常涉及很多团队，所以总会有斗争），我建议从“涨价”开始。如果你在持续构建产品，你应该每年提高一次整体价格。如果你没在构建产品，且支持很烂、NPS（净推荐值）很低，那就别管了。但如果你的 NPS 超过 20（这并不算高），你就应该每年涨一次价。我之所以这样建议，是因为它能把所有的废话和政治斗争都摆到台面上。你必须收集数据，向销售团队证明涨价的合理性，确保有配套的赋能工具，确保你的话术是……

---

**Patrick Campbell** (00:23:06):
But it's a tight enough non-nebulous thing that you're doing versus a value metric where you can have a bunch of debates about this metric or that metric, and should you give 10 away versus 100 away. It's a good way to rip the bandaid off. And most companies don't change their actual number that they're charging once per every three years. So if you haven't done it for three years, you're overdue for it. So it's a good one to kind of rip the bandaid off.

**中文翻译:**
涨价是一件非常具体、不模糊的事情。相比之下，讨论价值指标时，大家可能会对这个指标还是那个指标争论不休，或者争论该免费送 10 个还是 100 个。涨价是“撕掉创可贴”（长痛不如短痛）的好方法。大多数公司每三年才改一次实际收费数字。所以如果你已经三年没动过价格了，那你早就该涨价了。这是一个很好的突破口。

---

**Lenny** (00:23:30):
So this episode already pound for pound I think is up there. This is amazing. I'm excited to get to the next topic, but first I'll plug. You wrote a guest post in my newsletter about pricing and we'll link to that in the show notes, and that goes deeper into this value metric and how to think about pricing. So check that out.
Next topic, retention. So when I think Patrick Campbell, I think pricing and retention. So again, this could be its own podcast episode, but let's just pick one thing to talk about. What are the biggest mistakes people make, retention opportunities, or just hot take?

**中文翻译:**
这一集的内容密度已经非常高了，太棒了。我很期待下一个话题，但首先我要植入一下：你在我的简报中写过一篇关于定价的客座文章，我们会把链接放在节目介绍里，那篇文章深入探讨了价值指标以及如何思考定价。大家一定要去看看。
下一个话题：留存。提到 Patrick Campbell，我就会想到定价和留存。同样，这也可以单独做一集播客，但我们先挑一件事来谈。人们在留存方面犯的最大错误是什么？有哪些机会？或者你有什么犀利的观点？

---

**Patrick Campbell** (00:24:00):
The reason I started writing about retention and publishing data on it is because I didn't want to be the pricing guy. I was trying to basically differentiate myself and then I was trying to be the SaaS guy, but that's too broad. But anyway, so retention, the hottest of hottest takes, and this is the one to offend 90% of the list... no, it's not going to offend, but this is a product podcast, that's how I think about it. Product homies. You fail at realizing most of the time that there are two types of retention. There is strategic retention and then there's tactical retention.

**中文翻译:**
我之所以开始写留存并发布相关数据，是因为我不想只被当成“那个搞定价的家伙”。我当时想让自己与众不同，想成为“SaaS 专家”，但那太宽泛了。言归正传，关于留存，最最犀利的观点——这可能会得罪 90% 的听众……不，不会得罪，但这是一个产品播客，我是这么想的。产品圈的朋友们，你们大多数时候都没意识到留存有两种：战略性留存（strategic retention）和战术性留存（tactical retention）。

---

**Patrick Campbell** (00:24:38):
Strategic retention is all the stuff that you as a great product leader, a great product team are doing. Your ICPs, your time to value, road mapping, the right features, figuring out your mission metric, agonizing over every little thing, all the paper cuts of being a great product leader. But because you're so focused and so biased towards that, you miss out typically on this thing we call tactical retention, and these are things like payment failures, term optimization, cancellation flows, offboarding, et cetera.

**中文翻译:**
战略性留存是你作为优秀产品领导者或产品团队所做的一切：确定理想客户画像（ICP）、缩短价值实现时间（time to value）、制定路线图、开发正确的功能、确定核心指标、为每一个细节纠结——这些都是优秀产品领导者的日常磨炼。但正因为你太专注于这些，你通常会错过我们所谓的“战术性留存”，比如：支付失败处理、服务条款优化、取消流程设计、离职流程（offboarding）等等。

---

**Patrick Campbell** (00:25:26):
And if you're past product market fit this area, this tactical retention, it's typically about 25 to 40% of your churn problem, which is a significant amount, but you don't really look at it because again, you're like, "I've got to go focus on features, I've got to do this, and I'm going to go be this great product leader."
And so because product is so entrenched in that thinking that that problem can be solved with two months of work, it's not that much work putting in, basically, a marketing funnel when people's credit cards fail. Not that hard, not rocket science. Doing offboarding, being really smart with offboarding.

**中文翻译:**
如果你已经过了产品市场匹配阶段，这个领域——战术性留存——通常占你流失问题的 25% 到 40%，这是一个巨大的比例。但你并不怎么关注它，因为你总在想：“我要专注于功能，我要做这个，我要成为伟大的产品领导者。”
因为产品团队深陷这种思维，其实这个问题用两个月的工作就能解决。在信用卡扣款失败时加入一个营销漏斗，这并不难，不是什么高科技。还有做好离职流程，聪明地处理用户流失。

---

**Patrick Campbell** (00:25:55):
And one little tidbit. I looked at two million cancellation flows. We built some products for this, that's why I have this data, just to be clear. But looked at two million cancellation flows and we found you have about 18 to 30 seconds when someone hits that cancel button, we found you should ask two questions. One, "Why are you leaving?" Multiple choice. Don't do the free response. You get one out of 100 great responses, and the 99 are not great.

**中文翻译:**
分享一个小细节。我研究了 200 万个取消流程（说明一下，我们为此开发过产品，所以我才有这些数据）。我们发现，当有人点击取消按钮时，你大约有 18 到 30 秒的时间。我们发现你应该问两个问题。第一，“你为什么要离开？” 选多选题，不要用开放式回答。100 个回答里可能只有一个有价值，剩下的 99 个都没用。

---

**Patrick Campbell** (00:26:08):
And then the other question we found works really, really well is, "What did you like about the product?" And the reason that works so effectively is because that person's on a freight train to basically cancel. They're like, "I'm already done. Oh yeah, this is why I'm leaving." The minute you ask them what they like, you're basically tapping into this nostalgia effect and you're stopping that freight train. And then when I have that information, it's great for a product team, it's great to figure out, "What's working, what's not? What should we do more of? Was this a good customer?"

**中文翻译:**
我们发现另一个非常有效的问题是：“你喜欢这个产品的哪些地方？” 效果之所以这么好，是因为那个人正像一列货运火车一样冲向“取消”终点。他们想：“我受够了。对，这就是我要走的原因。” 但当你问他们喜欢什么时，你实际上是在利用“怀旧效应”，拦住了那列火车。一旦我获得了这些信息，对产品团队来说就太棒了，可以用来分析：“什么是有效的，什么是无效的？我们应该多做些什么？这是一个优质客户吗？”

---

**Patrick Campbell** (00:26:34):
But then based on their engagement data, their plan, whatever, all their firmographics about them plus their answers, then I can offer up a salvage offer or a pause plan or a maintenance plan or these types of things. But all this type of stuff, this is really, really powerful. And I always suggest finance teams should just take this on because product teams are always going to be thinking so much more on the future rather than fixing this right now. But that's the hottest take I've got for retention.

**中文翻译:**
然后，根据他们的参与数据、套餐类型、公司特征以及他们的回答，我可以提供一个挽留方案（salvage offer）、暂停计划或维护计划之类的。这些东西非常强大。我总是建议财务团队应该接手这件事，因为产品团队总是更关注未来，而不是修复当下的问题。这就是我对留存最犀利的观点。

---

**Lenny** (00:27:00):
That's a great, awesome take. And I want to plug ProfitWell right here, actually. I know you guys offer a product that does this and I've used it. So I don't know if that's still true, I know after an acquisition, things change. So I use ProfitWell for my newsletters. I just plug it into my Stripe account and it's the most amazing free product because it just tells me everything I want to know. And then it's got this cool feature, you just turn it on and it does these things for you like it tells people, "Your credit card is about to expire." Hey, this card failed, you should try putting in a new card." So that's a cool reason to check out ProfitWell.

**中文翻译:**
这个观点太棒了。我想顺便给 ProfitWell 打个广告。我知道你们提供这类产品，我也用过。不知道现在还是不是这样，毕竟收购后情况会有变化。我在我的简报业务中使用了 ProfitWell。我把它接入我的 Stripe 账户，它是一个非常惊艳的免费产品，能告诉我所有想知道的数据。它还有一个很酷的功能，开启后它会自动帮你做事，比如提醒用户“你的信用卡快过期了”或者“这张卡扣款失败，请尝试换一张新卡”。所以这是去体验 ProfitWell 的一个很好的理由。

---

**Patrick Campbell** (00:27:29):
Thanks, man. I appreciate that. And it's actually cool because I think for us, because the fact that product teams don't really think about this stuff, we stumbled into this whole thesis that could be a whole episode, which is all the product features are done for you. So what I mean by that is, you noticed this, but when you log in and set this up, you're not writing emails, you're not setting up the flows. And the reason is because we have all this data from $30 billion in ARR flowing through our metrics product that we can study and understand what works and what doesn't.

**中文翻译:**
谢谢，伙计。我很感激。这其实挺酷的，因为产品团队通常不考虑这些，我们偶然发现了一个理论（这又能讲一整集），那就是“为你做好的产品功能”。我的意思是，你可能注意到了，当你登录并设置它时，你不需要写邮件，不需要设置流程。原因是我们有 300 亿美元年经常性收入（ARR）的数据流经我们的指标产品，我们可以研究并了解什么是有效的，什么是无效的。

---

**Patrick Campbell** (00:28:02):
And that kind of stumbling that is useful for folks is what we discovered is this anti-active usage type product, it retains itself at a really, really high rate because people are just getting the value and they don't have to use it. And so what we found is a little bonus thing on retention. When we look at churn rates across different types of products, those products that are workflow products you use every single day or mostly every single day, or those products you don't have to log into but you still get the value, that's where the lowest churn rates are, the highest retention. Anything in the middle, it's like death. And this is why ProfitWell metrics ended up being free because we were just like, "It's terrible to build a metrics and analytics product. It's so hard because people just don't appreciate how much work goes into it, therefore they don't retain at a high rate, they're not willing to pay that much," et cetera.

**中文翻译:**
这种偶然的发现对大家很有用：我们发现这种“非活跃使用型”产品，其留存率非常高，因为人们只需获得价值，而不必亲自去操作。关于留存，我们还有一个小发现：当我们观察不同类型产品的流失率时，那些你每天或几乎每天都要使用的“工作流产品”，或者那些你不需要登录就能获得价值的产品，流失率最低，留存率最高。任何处于中间地带的产品都死得很惨。这就是为什么 ProfitWell 的指标工具最终免费了，因为我们觉得：“开发指标和分析产品太糟糕了。太难了，因为人们根本不理解背后付出了多少努力，因此留存率不高，也不愿意付那么多钱。”

---

**Lenny** (00:28:49):
I think that alone is a really interesting story, and I don't know if we should get too deep, but just to highlight what you just said, so many startups build an analytics product that it's just a better way to measure and track all the stuff that's going on. And what you've found is you won't make money doing that, people don't want to pay for a SaaS analytics tool.

**中文翻译:**
我觉得这本身就是一个非常有趣的故事。我不想扯太深，但为了强调你刚才说的话：很多初创公司都在做分析产品，只是为了提供一种更好的方式来衡量和跟踪现状。而你的发现是，这样做赚不到钱，人们不想为 SaaS 分析工具付费。

---

**Patrick Campbell** (00:29:08):
You have two options. You go up market and you pretty much become a data product with a UI or you go super niche. And even super niche, it's super hard and it's just because, I don't know, everyone's trying to kill a spreadsheet, and it's like, "You're not going to kill a spreadsheet." All real analysts will do everything in a spreadsheet. So for us it was we want to give you a clean UI and then we want to help you get this data into spreadsheets or email or whatever you're using for your databases, things like that.

**中文翻译:**
你只有两个选择：要么走高端市场，基本上变成一个带有 UI 的数据产品；要么走极度垂直的利基市场。即便走利基市场也非常难，因为，我不知道，每个人都想干掉 Excel 表格，但事实是：“你干不掉 Excel。” 所有真正的分析师都会在表格里完成所有工作。所以对我们来说，我们的目标是给你一个简洁的 UI，然后帮你把数据导入表格、邮件或任何你使用的数据库中。

---

**Lenny** (00:29:38):
Yeah. I don't want to make this an ad for ProfitWell, but it's like founders come to me with pitches of, "Hey, we've built this sweet analytics." So I'm like, "Just look up what ProfitWell is giving away for free, that's going to be a high bar to exceed."

**中文翻译:**
是的。我不想把这变成 ProfitWell 的广告，但经常有创始人来找我推销：“嘿，我们做了一个很棒的分析工具。” 我就会说：“去看看 ProfitWell 免费提供的东西吧，那是一个很难逾越的高门槛。”

---

**Patrick Campbell** (00:29:49):
Yeah. Yeah. We were going to try to sell it. We were trying to sell it in the beginning, but what ended up happening is we ran into all this, that's why we didn't.

**中文翻译:**
没错。我们最初是打算卖钱的，但后来遇到了刚才说的这些问题，所以才没卖。

---

**Lenny** (00:29:56):
All right, back on track. Topic number five, shipping. What have you learned about shipping? What are mistakes people make when trying to ship faster, ship more efficiently?

**中文翻译:**
好，回到正轨。话题五：交付（shipping）。关于交付你学到了什么？人们在尝试更快、更高效地交付时会犯哪些错误？

---

**Patrick Campbell** (00:30:05):
Yeah. The bratty thing here is that real professional ship. At the end of the day, real... I don't care what if you're a marketer or product person, engineer, ops person, people ops, real professional ship, and they ship it a pretty high frequency for whatever they're doing. And so the thing that we thought a lot about is, in my opinion, your tempo framework, and I'll explain a little bit more of what that means in a second, is more important than your org design.

**中文翻译:**
是的。这里有个比较尖锐的观点：真正的专业人士会交付。说到底，我不管你是市场人员、产品经理、工程师、运营还是 HR，真正的专业人士都会交付，而且无论做什么，交付频率都相当高。所以我们思考很多的一点是：在我看来，你的“节奏框架”（我待会儿会解释它的含义）比你的组织设计更重要。

---

**Patrick Campbell** (00:30:36):
And so if you've ever had a team that seems really, really smart, but they're always planning or they don't really ship a lot, or you've had trouble where everyone gets it at the leadership level, but then the team below them and below them seems to be kind of going in a different direction, you probably don't have enough alignment and you don't have enough alignment on what good looks like in terms of tempo.

**中文翻译:**
如果你曾遇到过一支看起来非常聪明但总在计划、产出很少的团队，或者领导层达成了一致但下属团队却各行其是，那很可能是因为你们缺乏共识，尤其是在“什么是好的交付节奏”上缺乏共识。

---

**Patrick Campbell** (00:30:56):
And so the way we looked at this was we have to establish mission metric and guiding principles at the top so, what do we do? How are we measuring it? And how we're going to get there? So for us was we automate subscription growth. Our mission metric was the amount of revenue that was on ProfitWell because that was good from acquisition, but it also meant we were doing our jobs. Then how we're going to get there. We want to be the most helpful brand in SaaS. And then we also we're going to do it for you, this whole thing that I just talked about.

**中文翻译:**
我们的做法是：在顶层建立“使命指标”和“指导原则”。即：我们做什么？我们如何衡量？我们如何实现目标？对我们来说，使命是“自动化订阅增长”。我们的使命指标是 ProfitWell 平台上的收入总额，因为这既代表了获客情况，也代表了我们履行了职责。至于如何实现，我们想成为 SaaS 领域最有帮助的品牌，并且我们要“为你代劳”（就是我刚才提到的那套逻辑）。

---

**Patrick Campbell** (00:31:25):
Then what we did is we established that at the leadership level, every org leader, so marketing, sales, et cetera, they need a framework that fits into that overall. So marketing at ProfitWell was this whole inbound media, so lots of podcast, video series, et cetera. And the most important part of that was they needed to determine what good looked like in terms of shipping. So if we're like, "Hey, we're doing sales," blah, blah, blah, blah, blah, or marketing in this case, "this many episodes per month, it's this many product launches per month, this many big product launches per quarter," whatever it is.

**中文翻译:**
然后我们在领导层确立了这一点：每个部门负责人（市场、销售等）都需要一个符合整体目标的框架。例如，ProfitWell 的市场部专注于“入站媒体”（inbound media），包括大量的播客、视频系列等。其中最关键的部分是，他们需要确定“什么是好的交付”。比如：“嘿，我们做销售”或者市场部，“每月出多少集节目，每月发布多少次产品，每季度有多少次重大产品发布”等等。

---

**Patrick Campbell** (00:31:57):
And then your leadership is basically a conversation of, "Great, that's what good looks like, we agree. How do we close that gap?" And then all of those conversations are like, "Okay, you only shipped one thing per quarter, we want to do one per month. Why?"
"Well, I don't have enough resources."
We solve that problem or we figure out how to get the more resources, then they're not doing it again. "Okay, why?"
"Well, there's this problem."

**中文翻译:**
然后，领导层的工作基本上就是对话：“太好了，这就是‘好’的标准，我们达成一致。我们如何弥补差距？” 所有的对话都会变成：“好吧，你每季度只交付了一次，但我们想要每月一次。为什么？”
“因为我资源不够。”
我们解决那个问题，或者想办法弄到更多资源。如果他们还是没做到，“好吧，为什么？”
“因为有这个那个问题。”

---

**Patrick Campbell** (00:32:18):
And then all of a sudden you start to create this very high output team across the board, and you also have this alignment so you don't wake up nine months into someone being at your company and being like, "Well, I think Tim sucks."
And it's like, "Well, why did you just all of a sudden wake up and think Tim sucks."
"Well, he's not shipping blah, blah, blah, blah."
"Well, it's probably an org problem rather than a Tim problem," because again, you vetted Tim. Tim was at this other company and apparently was a really great rockstar. So what's the difference here? You screwed up the hiring? Well, maybe because that is really, really hard, but most of the time you just haven't set an expectation of what good looks like in terms of tempo, and then you haven't had that constant conversation to make sure that Tim has what he needs in order to ship.

**中文翻译:**
然后突然间，你就建立了一支全方位的高产出团队。而且因为有了这种共识，你不会在某人入职九个月后突然醒悟说：“我觉得 Tim 很烂。”
别人会问：“你为什么突然觉得 Tim 很烂？”
“因为他没交付某某东西。”
“那很可能是组织的问题，而不是 Tim 的问题。” 因为你面试过 Tim，他在前一家公司表现非常出色。那区别在哪？是你招错人了吗？也许吧，因为招人确实很难，但大多数时候是因为你没有设定关于“节奏”的预期，也没有通过持续的沟通来确保 Tim 拥有交付所需的资源。

---

**Lenny** (00:33:00):
What was a big learning, I guess, in doing that? Is that just something you built up over time of we need to create this tempo at ProfitWell?

**中文翻译:**
在这个过程中，你最大的感悟是什么？这是你随着时间的推移逐渐意识到 ProfitWell 需要建立这种节奏的吗？

---

**Patrick Campbell** (00:33:05):
Yeah. Complete misalignment if you don't call it out on what good looks like, just complete misalignment. Like so-and-so is going and building, they think one product launch per quarter. Or I'm sitting there and I'm like, "Well, we should have a medium one per month and then we should have a big one per quarter." Complete misalignment. And if you don't have a way to talk about that, some sort of nexus to have that conversation, you end up not having it, and then you end up creating this friction and resentment on both sides because everyone thinks, again, "Tim isn't doing well." And it's like, "That's not what's happening. It's just the expectations aren't set."

**中文翻译:**
是的。如果你不明确指出什么是“好”，就会产生彻底的错位。比如某人在开发，他觉得每季度发布一次产品就行。而我坐在那想：“我们应该每月有一次中型发布，每季度有一次大型发布。” 这就是彻底的错位。如果你没有一种沟通机制或纽带去讨论这件事，你最终就不会去谈，从而在双方之间产生摩擦和怨恨。因为每个人都会觉得：“Tim 表现不好。” 但事实并非如此，只是预期没有设定好。

---

**Patrick Campbell** (00:33:40):
And then what was really cool is that you start to find out that the why they aren't hitting what good looks like is all solvable, and most of the time it's this team isn't talking to this team. "Oh, great. Well, marketing wants to do these launches, product isn't providing them stuff. All right, let's get these two people together, have this conversation because we didn't have product marketing or official product marketing."

**中文翻译:**
最酷的一点是，你会发现他们没能达到标准的原因都是可以解决的。大多数时候是因为团队之间缺乏沟通。“噢，太好了。市场部想做发布，但产品部没给他们东西。行，让这两个人聚在一起谈谈。” 因为我们当时没有专门的产品市场（Product Marketing）岗位。

---

**Patrick Campbell** (00:34:05):
They have this conversation and then all of a sudden it's like, "All right, Neil, you need to provide one thing a month. There's so much stuff we've built, a lot of it we haven't announced, you just need to provide one thing a month. Marketing will worry about how to position it in a way that isn't too far, isn't overselling it, but also gets us something per month, and you can approve that positioning." And then all of a sudden you start getting this tempo going, which obviously is the goal.

**中文翻译:**
他们谈过之后，突然间事情就变成了：“好吧 Neil，你每月需要提供一个东西。我们已经开发了这么多东西，很多还没公布，你只需每月提供一个。市场部会负责定位，既不过度吹嘘，又能保证每月有产出，你可以审核那个定位。” 然后突然间，这种节奏就带起来了，这显然就是我们的目标。

---

**Lenny** (00:34:27):
Reminds me, David Sacks has this awesome post called The Cadence around how marketing and product and sales should operate and create this kind of cadence. So being aligned but also offset schedule, which will link to them in the show notes if you haven't seen it.

**中文翻译:**
这让我想起 David Sacks 写过一篇很棒的文章叫《节奏》（The Cadence），讲的是市场、产品和销售应该如何运作并建立这种节奏。即保持一致但时间表错开。如果你没看过，我们会把链接放在节目介绍里。

---

**Patrick Campbell** (00:34:41):
Yeah, that's great.

**中文翻译:**
是的，那篇文章很棒。

---

**Lenny** (00:34:42):
Next topic. First principles thinking. As a renaissance man of a brain, I feel like you've spent a lot of time thinking about from first principles and in our conversations you always have really interesting approaches to things. What have you learned about actually implementing first principle thinking, which people are always talking about. How do I [inaudible 00:35:00] first principle?

**中文翻译:**
下一个话题：第一性原理思维（First Principles Thinking）。作为一个“文艺复兴式大脑”，我觉得你花了很多时间从第一性原理出发进行思考，在我们的交谈中，你对事情总是有非常有趣的切入点。关于如何真正“落地”人们总在谈论的第一性原理思维，你学到了什么？

---

**Patrick Campbell** (00:35:01):
Yeah, people always talk about it. And there are no good courses that I have found on first principles thinking. There are good blog posts, but the good blog posts kind of explain what it is, and then that's it. It's like, "This is what it is, and here's an example." And most of them quote Elon Musk about rockets and breaking down the different parts.

**中文翻译:**
是的，人们总在谈论它。但我还没发现任何关于第一性原理思维的好课程。有一些不错的博客文章，但它们通常只是解释一下定义，然后就没了。比如：“这就是定义，这是一个例子。” 大多数文章都会引用埃隆·马斯克关于火箭和拆解零件的例子。

---

**Patrick Campbell** (00:35:23):
So what I kind of found is there's the five whys, which I think someone's talked before or at least I've read it in the newsletter before, which is just you keep asking why. Kind of, "Well, this is this way."
"Well, why is that?"
"Well, this is this way."
"Why is that?"

**中文翻译:**
所以我发现有一种方法叫“五个为什么”（Five Whys），我想之前有人提过，或者我在简报里读过，就是不断地问为什么。比如：“嗯，事情是这样的。”
“为什么是这样？”
“因为那是那样的。”
“那又是为什么？”

---

**Patrick Campbell** (00:35:38):
I found the model that people who aren't great at first principal thinking or aren't great at talking about it that kind of helps them unlock is this thing called problem, cause, solution. So I learned this in debate in college and high school, and it basically is you have a problem that you're trying to solve. Well, you can't actually solve a problem. So if we talk about world hunger, you can't just solve world hunger because it's kind of the symptom, it's this problem that exists.

**中文翻译:**
我发现对于那些不擅长第一性原理思维或不擅长表达的人来说，有一个模型可以帮助他们开启思路，那就是“问题、原因、解决方案”（Problem, Cause, Solution）。这是我在高中和大学辩论赛中学到的。基本上，你有一个想要解决的问题。但实际上，你无法直接解决一个“问题”。比如谈到全球饥饿，你不能直接解决“全球饥饿”，因为它更像是一个症状，一个存在的问题。

---

**Patrick Campbell** (00:36:06):
Well then I want to break down what are all the causes of world hunger? And it's a little more brainstormy when you have these conversations with folks, especially again when they struggle with this. And all of a sudden I could list out all the causes, irrigation crisis, aid not getting to where it needs to be, famines, drought, et cetera. And then what I can do is I can rank those causes in terms of magnitude.

**中文翻译:**
那么，我要拆解：导致全球饥饿的所有原因是什么？当你和别人交流时，这更像是一种头脑风暴，尤其是对那些思维受阻的人。突然间，我可以列出所有原因：灌溉危机、援助物资无法送达、饥荒、干旱等等。然后，我可以根据严重程度对这些原因进行排序。

---

**Patrick Campbell** (00:36:34):
So if we're trying to solve world hunger, and for some reason we discovered irrigation was the biggest problem, if we solved irrigation, everything would be great, well then I'm going to align my solutions to all of those different causes. And you get this nice alignment between, well, I can solve a cause, and if I solve the cause that's big enough and proper enough, I'm going to eventually solve the actual problem or mitigate the problem, I should say.

**中文翻译:**
如果我们试图解决全球饥饿，并且发现灌溉是最大的问题，如果解决了灌溉，一切都会好转，那么我就会针对这些不同的原因制定解决方案。这样你就能在“解决原因”和“解决问题”之间建立良好的关联。如果我解决了一个足够大、足够关键的原因，我最终就能解决实际问题，或者准确说是缓解问题。

---

**Patrick Campbell** (00:36:50):
So that's the framework that I found really, really useful. And also, it's great for using for presentations, it's great for a mission, it's great for all of these different things because it's a little bit more actionable than just the five whys, which is more of a way to have a conversation.

**中文翻译:**
这就是我发现非常非常有用的框架。而且，它非常适合用于演示文稿、使命陈述等各种场景，因为它比“五个为什么”更具操作性，“五个为什么”更多是一种对话方式。

---

**Lenny** (00:37:06):
So the way you operationalize this, say problem, cause, solution. You're saying on strategy templates, you write out, "Here's the problem we're trying to solve, here's the source of the issue, and then here's how we're approaching it." Can you talk a bit more about how you implement this at your company and the people you work with?

**中文翻译:**
所以你落实这个“问题、原因、解决方案”的方法是：在战略模板上写下“这是我们要解决的问题，这是问题的根源，这是我们的处理方法”。你能多谈谈你是如何在公司内部以及与同事合作中实施这一点的吗？

---

**Patrick Campbell** (00:37:22):
Yeah, totally. So I'll say big, medium and small things, and I'll try to be really quick. So big things it's like, "What are we facing?"
"Oh, we're going to try to charge for this metrics product. Now there's a bunch of competitors. The customers don't really care about it."
So we have this problem and the problem is growth. How do we grow a product like this? How do we grow our company?

**中文翻译:**
当然可以。我会从大、中、小三个层面来说，尽量简短。大层面上，比如：“我们面临什么？”
“噢，我们打算对这个指标产品收费。但现在有很多竞争对手，客户似乎并不在乎。”
所以我们面临的问题是增长。我们如何让这样的产品增长？如何让公司增长？

---

**Patrick Campbell** (00:38:00):
And what's really interesting about a big problem or a nebulous problem like that is you end up having a lot of conversations about the problem, which I think is more useful sometimes about, "Well, what are we actually trying to do? Let's get alignment as much as possible." And then it's like, "Okay. Well, what are the causes of our growth problem?"
"Well, people aren't willing to pay for metrics. Getting accuracy is really, really hard. Actually, the market stance," all these other things.

**中文翻译:**
对于这样一个宏大或模糊的问题，有趣的是你会围绕问题本身进行大量讨论。我认为有时这更有用，比如：“我们到底想做什么？让我们尽可能达成共识。” 然后问：“好吧，我们增长问题的原因是什么？”
“人们不愿意为指标付费。保证数据准确性非常难。市场现状如此”等等。

---

**Patrick Campbell** (00:38:08):
"Well, what are some of the solutions?"
"Well, we could do this, could do this, could do this."
And normally what ends up happening is the solution ends up being kind of an approach. So our approach that mitigated or solved for some of these causes and mitigate the problem was freemium, and then these paid products that were all pay-for-performance because with pay-for-performance, you could charge a significant amount more in a market that only has 100,000 logos, which is a really small market. And so that kind of an example there.

**中文翻译:**
“那么，有哪些解决方案？”
“我们可以做这个，做那个。”
通常结果是，解决方案变成了一种“方法论”。我们缓解或解决这些原因并缓解问题的方法是：采用免费增值模式（freemium），然后推出按效果付费（pay-for-performance）的付费产品。因为通过按效果付费，你可以在一个只有 10 万个潜在客户（logos）的小市场中收取高得多的费用。这就是一个例子。

---

**Patrick Campbell** (00:38:37):
Medium and small, let's talk about a support ticket. This person's pissed off. They're coming in, they're pissed off. What are the causes? Well, there's a lot of different causes that were probably like, "Oh, we didn't get back to them in time, and then we gave a crappy solution, we gave this..." It just kind of allows us to look at the problem. And so it's more of a way of thinking on that level. And it's not happening. We're not going to have an hour-long conversation about a support ticket. But the support folks that I've talked to about this, they go, "Okay, cool. Why is he upset?"
"Well, we didn't get the answer in time."

**中文翻译:**
中小型层面上，比如一个客服工单。这个客户很生气。原因是什么？可能有很多原因，比如：“噢，我们没及时回复，然后给了一个很烂的方案，我们还……” 这能让我们审视问题。这更多是一种思维方式。当然，我们不会为一个工单讨论一小时。但我交流过的客服人员会想：“好，他为什么生气？”
“因为我们没及时给答复。”

---

**Patrick Campbell** (00:39:06):
Okay, my first line is going to be, "I understand we didn't get you an answer quick enough. Apologies for that." It just allows them to have a little bit of an extra second to think through things and move forward with that.

**中文翻译:**
“好，那我第一句话要说：‘我理解我们没能及时给您答复，深表歉意。’” 这让他们能多花一秒钟思考清楚，然后继续处理。

---

**Lenny** (00:39:21):
I love that. I love that big example and a small example.

**中文翻译:**
我喜欢这个，大例子和小例子都很棒。

---

**Audio** (00:39:26):
This episode is brought to you by Dovetail, the customer insights platform for teams that gets you from data to insights fast, no matter the method. There's so much customer data to get through from user interviews to NPS, sales calls, usability tests, support tickets, app reviews. It's a lot. And you know that if you're building something, hidden in that data are the insights that will lead you to building better products. And that's where Dovetail can help.

**中文翻译:**
本集节目由 Dovetail 赞助。Dovetail 是一个为团队打造的客户洞察平台，无论采用何种方法，都能帮您快速从数据中获取洞察。从用户访谈到 NPS、销售电话、可用性测试、客服工单、应用评论，有海量的客户数据需要处理。这确实很多。但您知道，如果您正在开发产品，这些数据中隐藏着能引导您开发出更好产品的洞察。这就是 Dovetail 能提供帮助的地方。

---

**Audio** (00:39:51):
Dovetail allows you to quickly analyze customer data from any source and transform it into evidence-based insights that your whole team can access. If you're a product manager who needs insights to motivate your team, a designer validating your next big feature, or a researcher who needs to analyze fast, Dovetail is the collaborative insights platform your whole team can use. Go to dovetailapp.com/lenny to get started today for free. That's dovetailapp.com/lenny.

**中文翻译:**
Dovetail 让您可以快速分析来自任何渠道的客户数据，并将其转化为整个团队都能访问的、有据可查的洞察。如果您是需要洞察来激励团队的产品经理，是正在验证下一个重大功能的设计师，或者是需要快速分析的研究员，Dovetail 都是您整个团队可以使用的协作洞察平台。访问 dovetailapp.com/lenny 即可免费开始使用。

---

**Lenny** (00:40:19):
All right. Next topic, customer research. I feel like you have a pretty interesting perspective on custom research, so let's go into it.

**中文翻译:**
好，下一个话题：客户研究。我觉得你对客户研究有非常有趣的看法，让我们深入聊聊。

---

**Patrick Campbell** (00:40:27):
I think I have the 85-year-old curmudgeonly man perspective on customer research. So here's the thing. Everything in your business, it does not matter what type of business you have, everything is used to drive someone to a point of conversion or justify the product or the price that you're offering up. That customer is a human being you're driving to that point of conversion and it's your job to understand how they perceive you, how they perceive their problem, how they perceive the world around them, around your products.

**中文翻译:**
我觉得我对客户研究的看法就像一个 85 岁脾气古怪的老头。事情是这样的：在你的业务中，无论是什么类型的业务，所有事情都是为了促使某人达到转化点，或者证明你提供的产品或价格是合理的。那个客户是一个被你推向转化点的人类，而你的工作就是理解他们如何看待你、如何看待他们的问题、以及如何看待围绕你产品的世界。

---

**Patrick Campbell** (00:41:00):
We all know this on a philosophical level, but here are some fun facts. So one, only one in five companies have buyer personas or ICPs, only one in five. So we talk about this all the time, we retweet the articles, we give the advice, so many of us give the advice. But then we look at our own companies, only one in five have some sort of segmentation ICPs. And then only one out of 10 companies actually do customer research or development on a quarterly basis.

**中文翻译:**
我们在哲学层面上都知道这一点，但这里有一些有趣的事实。第一，只有五分之一的公司拥有买家画像（Buyer Personas）或理想客户画像（ICP）。我们一直在谈论这个，转发相关文章，给出建议——我们很多人都在给建议。但看看我们自己的公司，只有五分之一做了某种形式的细分或 ICP。其次，只有十分之一的公司实际上每季度进行一次客户研究或开发。

---

**Patrick Campbell** (00:41:44):
This should be a continuous thing, it should be a monthly, weekly type thing. Not saying you're sending up surveys or having all these conversations on a weekly basis, but only one out of 10 are doing quarterly. So that means the number they're doing monthly is even smaller than that. And I just think that's insane.

**中文翻译:**
这本该是一项持续的工作，应该是每月甚至每周一次。我不是说你每周都要发调查问卷或进行访谈，但只有十分之一的公司每季度做一次，这意味着每月做一次的公司比例更小。我觉得这简直疯了。

---

**Patrick Campbell** (00:42:00):
And when we look at all data, and we have a lot of data on this, and this is something where I've been talking about customer development for a long time. Everything is better. Everything is better. NPS is higher for organizations that have customer development functions or even just ICPs or buyer personas, depending on what framework you're using. Willingness to pay is typically higher. The funnel is more efficient. LTV to CAC is normally much, much higher. All those growth numbers, you're typically growing in a much higher rate, like a 15, 20%, not a small delta, 15-20% higher rate. Retention's better. All these things are better.

**中文翻译:**
当我们查看所有数据时（我们在这方面有大量数据，我也一直在谈论客户开发），你会发现：一切都会变得更好。对于拥有客户开发职能，或者仅仅是拥有 ICP 或买家画像的组织，NPS 更高。支付意愿通常更高。漏斗效率更高。LTV（终身价值）与 CAC（获客成本）的比率通常要高得多。所有的增长指标，你的增长率通常会高出 15% 到 20%——这不是一个小差距。留存率也更好。所有这些方面都更出色。

---

**Patrick Campbell** (00:42:21):
And the thing that, I think, 20 years ago or 10 years ago you didn't have to do customer development because, and this is where Keith [inaudible 00:42:30] is just like customer research is dumb or whatever his famous quote is, but you didn't have to do it because there just wasn't a lot of stuff out there and we all were riding the wave of the internet. But now the market's harder and harder. So what are you going to do? Are you just going to keep throwing stuff up against the wall or are you going to actually do the stuff that all of us talk about doing and actually do the research?

**中文翻译:**
我认为，20 年前或 10 年前你不需要做客户开发，因为（这就是为什么 Keith Rabois 会说客户研究很蠢之类的话），当时市面上东西不多，我们都在顺着互联网的大潮前进。但现在市场竞争越来越激烈。所以你打算怎么办？是继续盲目尝试，还是真正去做我们都在谈论的那些事，真正去做研究？

---

**Patrick Campbell** (00:42:54):
And the research is hard. It's never going to be 100% accurate because you're going to have to use your judgment, but that's your job. And so that's more of a rant, I guess, than a hot take. But I also think this is one of those things that AI starts solving, especially all this generative AI because now you can just throw all that stuff into a workload and then all of a sudden you'll get back a lot of the sentiment or all that kind stuff so you don't even to do the hard part anymore. Yeah, that's my rant.

**中文翻译:**
研究很难。它永远不会 100% 准确，因为你必须运用你的判断力，但那正是你的工作。所以我觉得这更像是一番牢骚，而不是什么犀利观点。但我也认为，AI 开始解决这个问题了，尤其是生成式 AI。现在你只需把所有数据丢进工作流，突然间你就能得到大量的情感分析之类的信息，你甚至不需要再做最难的那部分工作了。这就是我的牢骚。

---

**Lenny** (00:43:14):
Love the rant. Maybe one follow-up question. Why do you think it is that companies don't do this? I love the point you made of the retweeting, "Yeah, research is great." Writing blogs that research is use useful, "We've got to do research." Why do you think companies don't do it? And then what's one thing that maybe they could do tomorrow that'll bring them closer down that path?

**中文翻译:**
我喜欢这段牢骚。也许有一个追问：你认为为什么公司不做这些？我喜欢你提到的那个点：大家都在转发“是的，研究很棒”，写博客说研究很有用，“我们必须做研究”。但为什么公司就是不做呢？还有，他们明天可以做哪一件事，能让他们离这个目标更近一步？

---

**Patrick Campbell** (00:43:35):
The one thing you can do, put a number on a whiteboard. You're going to have 10 customer conversations a month, just 10 non-sales conversations. You're just going to talk to 10 people. Or you're going to send one survey. And people are terrible at sending surveys. Surveys are actually great. You just have to be good at sending them. And good, it's not a high bar, it just means that you have 30 to 45 seconds of someone's time unless you're compensating them. And don't send 45-question surveys by email where the first question is, "What's your email?" Don't do that. But just put a number on the board.

**中文翻译:**
你可以做的一件事是：在白板上写下一个数字。比如每月进行 10 次客户访谈，只是 10 次非销售性质的谈话。或者发一份调查问卷。人们很不擅长发问卷，其实问卷很棒，你只需要擅长发送。所谓“擅长”，门槛并不高，只是意味着除非你给补偿，否则你只能占用别人 30 到 45 秒的时间。不要通过邮件发送有 45 个问题的问卷，而且第一个问题还是“你的邮箱是什么？”千万别这么干。总之，在白板上定个数字。

---

**Patrick Campbell** (00:44:09):
I think the reason we don't do it is because it was, quote-unquote, "easy" to get away with not doing it. If you really think about a funded environment... and some products are so paradigm-shifting that the biggest misconception about customer research is I have to listen to them. You don't have to listen to them at all, you just have to understand where they are, and then you're filtering all of that with all this other data and then you're making a decision and you're earning your paycheck as a product person. Typically, it's the product person, but also in marketing.

**中文翻译:**
我认为我们不做研究的原因是，以前不做研究也能“混过去”。如果你仔细想想融资环境……有些产品是如此具有范式转移的意义，以至于关于客户研究最大的误解是“我必须听他们的”。你根本不需要听他们的，你只需要了解他们所处的境况，然后结合所有其他数据进行过滤，最后做出决定，这才是你作为产品人赚工资的本分。通常是产品人，但也包括市场人员。

---

**Patrick Campbell** (00:44:37):
So I think it's just one of those things where you could get away with not doing it. Now though, the way the market's going, you're just starting to see this more and more, you're starting to see more tooling. The reason you're seeing more tooling is because they're starting to connect it to actually being useful rather than you having to set up your own customer development program. I think the other reason typically people haven't had to do this is because there's a lot of brute forcing that's done in startup land and it only lasts so long.

**中文翻译:**
所以我觉得以前是可以不做研究的。但现在，随着市场的发展，你会看到越来越多的研究，看到更多的工具。之所以出现更多工具，是因为它们开始让研究变得真正有用，而不是让你必须自己去建立一套客户开发计划。我认为另一个原因是，初创公司领域有很多“蛮力推行”（brute forcing），但这只能维持一段时间。

---

**Patrick Campbell** (00:45:06):
So all of these companies that raise a bunch of money, get the $100 million dollar exit, everyone's clapping because it's a big number, but cap table screwed, everything's bad. It's a win because it's a win, but all of those companies are ones who were able to brute force to a certain level and they never learned how to actually understand their market or their customer. And I think that that kind of story will continue to happen as long as we have a lot of capital flowing in the market. But I would rather not be that company. I would rather be the company that gets the $100 million, 200 million exit with bootstrapping, or builds the billion-dollar annual revenue company because I know my market, I know my customer so well.

**中文翻译:**
所以那些融了一大笔钱、最后以 1 亿美元卖掉的公司，大家都在鼓掌，因为数字很大，但其实股权结构表（cap table）一团糟，一切都很糟糕。虽然名义上赢了，但这些公司只是靠蛮力推到了某种程度，他们从未学会如何真正理解市场或客户。只要市场上还有大量资金流动，这种故事就会继续发生。但我宁愿不做那样的公司。我宁愿做那家通过白手起家实现 1 亿或 2 亿美元退出，或者建立年收入 10 亿美元的公司，因为我非常了解我的市场和客户。

---

**Lenny** (00:45:47):
Talking to customers is good, you should do it. Great reminder. People are going to listen to this like, "Yes, we should do this," and then we'll just move on. And then-

**中文翻译:**
与客户交谈是好事，你应该去做。很好的提醒。人们听了会想：“是的，我们应该做这个”，然后转头就忘了。然后——

---

**Patrick Campbell** (00:45:55):
My joke when I give talks is, "Only 20% of you are going to do this when I give a talk on it, and so I'm not even going to talk deeply on it. You 20%, come talk to me, I've got a whole framework for you," that type of a thing because I think people just nod their heads and they tweet it, and they just don't end up doing it.

**中文翻译:**
我演讲时常开的玩笑是：“当我讲这个话题时，你们中只有 20% 的人会去做，所以我甚至不想深谈。那 20% 的人，来找我，我有一整套框架给你们。” 诸如此类，因为我觉得人们只是点头、发推特，最后根本不去执行。

---

**Lenny** (00:46:10):
Status quo is hard to overcome sometimes. We're onto our eighth topic, we've got three to go, and it's on competitive intelligence. And this touches on a really interesting part of your background that I don't know a lot of people know.

**中文翻译:**
现状有时确实很难克服。我们进入第八个话题，还有三个，是关于竞争情报（Competitive Intelligence）。这涉及你背景中一个非常有趣的部分，我想很多人都不知道。

---

**Patrick Campbell** (00:46:24):
Yeah. So my background, I started my career... I worked in US Intelligence, I worked for NSA. And I was just a entry level intel analyst, basically, I was only there for just over a year. And what was interesting is you get taught first principles thinking in so many different ways because you're solving essentially puzzles every day. Now those puzzles are finding a bad guy or a gal or finding this piece of information. Those are all the puzzles, but you have to think through how to figure this out. And a lot of those puzzles involve, "You have these number of entities, how are they going to react?" And you're trying to predict how they're going to react, and you're also trying to help figure out how you're going to react or act in the context of them, so like node analysis, basically.

**中文翻译:**
是的。我的背景是，我职业生涯的起点是在美国情报部门，我在 NSA（美国国家安全局）工作过。我当时只是一个入门级的情报分析师，在那儿待了一年多。有趣的是，你会以各种方式被教授第一性原理思维，因为你每天都在解谜。这些谜题可能是寻找某个坏人，或者寻找某条信息。这些都是谜题，你必须思考如何解开。很多谜题涉及：“你有这些实体，他们会如何反应？” 你要预测他们的反应，还要决定在他们的背景下你该如何反应或行动，基本上就是节点分析（node analysis）。

---

**Patrick Campbell** (00:47:30):
And what's interesting from a startup or a business perspective is I think that don't focus on your competitors is terrible advice. It's amazing advice for product teams. When you have a competitive intelligence program or you have competitive intel, I try never to share that with product ever because products should just focus on the customer, they should not give two craps what's going on with competitor A or competitor B. But as an overall missive, don't focus on your competitors is terrible advice.

**中文翻译:**
从初创公司或业务的角度来看，有趣的是，我认为“不要关注竞争对手”是一个糟糕的建议。对于产品团队来说，这可能是个好建议。当你有一个竞争情报计划或情报时，我尽量从不与产品团队分享，因为产品团队应该只关注客户，他们不应该在乎竞争对手 A 或 B 在做什么。但作为一个整体策略，“不要关注竞争对手”是极坏的建议。

---

**Patrick Campbell** (00:47:50):
And if I'm being charitable, it's just outdated because some fun facts, and I alluded to some of them before, over the past decade, if you're building in tech, particularly in SaaS or subscriptions, you now have 16 times the number of competitors if you started a business today, than if you did 10 years ago, and this is because everyone and their mother can spin up a website, a server, they can drive traffic to that site.

**中文翻译:**
客气点说，这个建议已经过时了。这里有一些有趣的事实，我之前提到过一些：在过去十年里，如果你在科技领域（特别是 SaaS 或订阅领域）创业，你现在的竞争对手数量是十年前的 16 倍。这是因为现在任何人都能搭建网站、服务器，并为网站引流。

---

**Patrick Campbell** (00:48:02):
So there's just a bunch of stuff in the market. And then because of all that stuff, all these marketing channels are getting denser and denser. CAC and B2B is up about 110% over the past 10 years. Consumer, it's up 145%. If you're selling sales and marketing software, it's up 220% because there's just so much sales and marketing software doing sales and marketing things in the market. And so the other reason for this is we haven't had a brand new marketing channel since 2015, and that was Snapchat. We have TikTok, but TBD, depending on how you think about it. But we're going from brand new marketing and advertising innovation every quarter to basically every five years.

**中文翻译:**
所以市场上充斥着各种东西。正因为如此，所有的营销渠道都变得越来越拥挤。过去 10 年，B2B 的获客成本（CAC）上升了约 110%，消费类上升了 145%。如果你卖的是销售和营销软件，CAC 上升了 220%，因为市场上有太多的同类软件在做同样的事。另一个原因是，自 2015 年的 Snapchat 以来，我们还没有出现过全新的营销渠道。虽然有了 TikTok，但还有待观察。我们正从每季度都有营销创新，变成基本上每五年才有一次。

---

**Patrick Campbell** (00:48:42):
My point is, if you are not in a Blue Ocean, you're not in the Peter Teal, go to a market of one, you're not in those types of things, which is most of us, and even some of us who think we're in those things, we're actually not, you do have to focus on your competitors on some level. And the levels I particularly think are a bare minimum, just knowing who they are, having a strategy.

**中文翻译:**
我的观点是，如果你不在“蓝海”，不是彼得·蒂尔所说的“进入一个人的市场”，如果你不属于那一类（我们大多数人都不属于，甚至有些自以为属于的人其实也不属于），你就必须在某种程度上关注竞争对手。我认为最低限度是：知道他们是谁，并有一套应对策略。

---

**Patrick Campbell** (00:49:05):
So for ProfitWell we never had comparison pages because we very quickly went from a challenger in this very competitive market to the leader in the market. So all of a sudden we were going to be above the fray, that was the idea, that was the strategy that we had, which is, "We're going to have a lot of intel on what's going on with them, why people care about this product." We had white label NPS surveys and customer development surveys going to our competitors' customers. That's the level. And it was just automated. It wasn't like it was taking a lot of time, but we just wanted that intel.

**中文翻译:**
在 ProfitWell，我们从不写对比页面，因为我们很快就从竞争激烈的市场挑战者变成了领导者。所以我们的策略是“超然物外”，但我们会掌握大量关于对手的情报：他们在做什么，为什么人们关注他们的产品。我们会向竞争对手的客户发送“白标”（匿名）的 NPS 调查和客户开发调查。这就是我们的情报水平。而且这都是自动化的，不怎么花时间，但我们就是想要那些情报。

---

**Lenny** (00:49:34):
When you say white labeled, that means you're emailing your competitor's customers to see what they think of your competitors, right?

**中文翻译:**
你说的“白标”，是指你给竞争对手的客户发邮件，了解他们对竞争对手的看法，对吗？

---

**Patrick Campbell** (00:49:41):
Exactly. So we're basically, and we did it as a third party basically, which was, I think one of them was analyticssoftware.com, stuff like that. So it wasn't like we were spoofing as our competitor because I think that crosses a little bit of a line. But basically we would have this intel. There's a whole program here. Basically, I'd have sources... Basically, these customers I knew were always going to stay because they liked the founder or something like that. I would get on the phone with them every quarter or two just to be like, "Hey, what are you liking? Why haven't you switched yet?" these types of things, or I'd see them at conferences.

**中文翻译:**
没错。我们基本上是以第三方的身份做的，比如用 analyticssoftware.com 之类的域名。我们不会冒充竞争对手，因为我觉得那有点过线了。但基本上我们会掌握这些情报。这有一整套计划。我会有一些“线人”……基本上是那些我知道肯定会留下的客户，因为他们喜欢对方的创始人。我会每隔一两个季度给他们打个电话，问问：“嘿，你喜欢什么？为什么还没换产品？”之类的问题，或者在会议上见见他们。

---

**Patrick Campbell** (00:50:14):
So there's a whole program there. And again, it's not like it's distracting anything, it's just I want the intel so I can predict what's going on, I can predict who to care about, who not to care about. But even then, if you're a challenger, competitor marketing pages are really powerful. And the thing is, your customers, especially in a denser market, they know your competitors exist or they're looking at them. Don't infantilize your customers, help them, "Hey, this is how we compare to X, Y, Z competitor," and be honest as much as possible. Well, we should always be honest, but be as upfront as possible, I should say, with where you're bad at and where you're great at, those types of things.

**中文翻译:**
所以这有一整套方案。再说一次，这并不会分散注意力，我只是想要情报，这样我就可以预测动向，预测谁值得关注，谁不值得关注。即便如此，如果你是挑战者，竞争对手对比页面非常强大。事实是，你的客户（尤其是在拥挤的市场中）知道竞争对手的存在，或者正在考察他们。不要把客户当小孩，要帮助他们：“嘿，这是我们与 X、Y、Z 竞争对手的对比”，并尽可能诚实。好吧，我们应该始终诚实，但我想说的是，要尽可能坦率地说明你的短板和长处。

---

**Patrick Campbell** (00:50:55):
But long story short, having something awareness and then choosing a particular strategy, and then depending on your strategy, you might ramp up how much you actually do with the actual intelligence program.

**中文翻译:**
长话短说，先要有这种意识，然后选择特定的策略，根据策略的不同，你可能会加大实际情报计划的投入。

---

**Lenny** (00:51:06):
This is amazing. Two questions. Should every startup have a former spy on their team to help them operationalize these ideas? And then two, is there anything else that you found super valuable that you did based on your training there?

**中文翻译:**
太精彩了。两个问题：第一，是不是每家初创公司都应该在团队里配一个前间谍来落实这些想法？第二，基于你在那里的训练，还有什么你觉得非常有价值的事情吗？

---

**Patrick Campbell** (00:51:20):
We didn't have a formal program, but I love hiring veterans, either veterans of intelligence, so they're citizens, so they're not veterans from a military perspective, but people who had worked in Intel or people who were actual veterans of different military branches. There's a lot of reasons for this, but I think that the intelligence folks, it's a way of thinking. Now you ought to be careful, and this is just purely my opinion, because depending on how long they were in... the reason I left is because it's the government, it's super bureaucratic. It was one of the most fulfilling jobs I will ever have, and I was only there for a short amount of time. But it's just one of those things where it's just so bureaucratic.

**中文翻译:**
我们没有正式的计划，但我喜欢雇佣退伍军人或情报部门的老兵。他们是公民，虽然从军事角度看可能不算退伍军人，但他们曾在情报部门工作过，或者确实是不同军种的退伍军人。原因有很多，但我认为情报人员有一种独特的思维方式。不过你得小心（这纯属个人观点），取决于他们待了多久……我离开的原因是那是政府部门，极其官僚。那是我做过的最有成就感的工作之一，虽然我只待了很短时间。但那里真的太官僚了。

---

**Patrick Campbell** (00:52:01):
So the 15-year person there is not thriving, they're not trying to change the world necessarily. They have a job. So you've got to be careful with that. But yeah, I think there's these really smart people that just think in a different way. And a broader point is I think it's just really, really good to go to different industries. All this customer development stuff, you go to any major retailer or any major e-commerce company, they have entire teams just dedicated to this stuff.

**中文翻译:**
在那儿待了 15 年的人通常不会很有活力，他们不一定想改变世界，他们只是有一份工作。所以你得留意这一点。但是，确实有一些非常聪明的人，他们的思维方式与众不同。更广泛地说，我认为去了解不同的行业非常有好处。比如客户开发，你去任何大型零售商或电商公司，他们都有专门的团队在做这些事。

---

**Patrick Campbell** (00:52:30):
Hallmark was one of our first pricing customers back in the day before we went subscription focused. They had 119 people in customer insights and research. And this was one of the reason we were like, "Well, you guys don't need our help, you've got enough people." But those are great people to hire, even though they don't necessarily have the actual industry knowledge, they have a lot of domain expertise.

**中文翻译:**
在我们转向订阅领域之前，贺曼（Hallmark）是我们最早的定价客户之一。他们的客户洞察和研究部门有 119 人。这也是为什么我们当时觉得：“你们不需要我们的帮助，你们人够多了。” 但这些人是极佳的雇佣对象，即使他们不一定有具体的行业知识，但他们有大量的领域专业知识。

---

**Patrick Campbell** (00:52:50):
In terms of things I learned, I'll put it this way, not to get political, if I was in charge of budget, I would give so much more money into the intel community. I saw conflicts or heard about conflicts being stopped just because of intelligence that didn't go hot in terms of war fighting. I think it's one of those things where I would put so much more money there than the actual other side of the defense budget.

**中文翻译:**
至于我学到的东西，我这么说吧（不涉及政治）：如果我负责预算，我会给情报部门拨更多的款。我亲眼见过或听说过冲突因为情报而停止，从而避免了真正的战争。我觉得我会把更多的钱投到那里，而不是国防预算的其他方面。

---

**Patrick Campbell** (00:53:12):
And also everyone asks me about Snowden. So again, not to get political, it's a lot more complicated, I think, than a lot of people think. It's one of those things that the issues that were brought up, obviously they got really sensationalized, but they're really important conversations to have, but it's not as simple as, "Oh, stop doing this, start doing that."

**中文翻译:**
还有，每个人都会问我关于斯诺登的事。再说一次，不涉及政治，我认为这比很多人想象的要复杂得多。他提出的那些问题显然被过度炒作了，但那些对话确实非常重要。但这绝不是简单的“噢，停止做这个，开始做那个”那么简单。

---

**Patrick Campbell** (00:53:33):
You don't have to worry about the NSA, the NSA's all outward-looking. You should worry about the FBI. The FBI are the ones who get a little testy with certain things, and you're seeing that in the court cases and stuff like that. But just know there's a lot of really hardworking, very well-intentioned people who you might disagree in terms of trade-offs, in terms of safety and things like that. They're also some of the most privacy orientated people on the planet, so that's worth a whole conversation. So hopefully I didn't throw too many grenades in this part.

**中文翻译:**
你不需要担心 NSA，NSA 主要是对外看的。你应该担心 FBI。FBI 才是那些在某些事情上比较难对付的，你在法庭案件中也能看到。但请记住，那里有很多非常努力、初衷良好的人，你可能只是在安全等方面的权衡上与他们意见不一。他们也是地球上最注重隐私的人之一，这值得专门聊聊。希望我这部分没扔太多“炸弹”。

---

**Lenny** (00:54:02):
No, we need more grenades. That's the first time Snowden was brought up on this podcast, so that's cool. There you go. And this is actually a good segue to the next topic, which is around local strategies like FBI versus NSA. I think you have a strong perspective that local strategies are much more likely to [inaudible 00:54:19] so we'll just get into that one.

**中文翻译:**
不，我们需要更多“炸弹”。这是斯诺登第一次在我的播客中被提及，挺酷的。这正好引出了下一个话题：关于“本地化策略”（local strategies），就像 FBI 与 NSA 的对比。我认为你有一个强烈的观点，即本地化策略更有可能成功，让我们聊聊这个。

---

**Patrick Campbell** (00:54:21):
Yeah, yeah. Just to give you a tease, I'll tell you what I think of Snowden after the podcast. So the world doesn't get to know except that I'll tell you what my opinion is afterwards.

**中文翻译:**
哈哈，卖个关子，播客结束后我再告诉你我对斯诺登的看法。所以世人不会知道，我只会在私下告诉你。

---

**Lenny** (00:54:30):
What a tease.

**中文翻译:**
太吊胃口了。

---

**Patrick Campbell** (00:54:31):
Local strategies. Local strategies, very basic. People like to buy from people, but we as operators get so excited about the scale of the internet that we forget the basics of humanity. Here's some fun data points, we did a bunch of studies on this. So prospects who meet you in person, and this is not just for profit, all the data I've shared, it's all global-level data or segmented depending on how we did it.

**中文翻译:**
本地化策略。本地化策略非常基础：人喜欢从人那里买东西。但我们作为运营者，往往对互联网的规模感到兴奋，以至于忘记了人性的基本面。这里有一些有趣的数据，我们对此做过很多研究。亲自见过面的潜在客户（这不仅适用于 ProfitWell，我分享的所有数据都是全球层面的或经过细分的），

---

**Patrick Campbell** (00:55:05):
It's not just our findings, it's like we looked at probably a minimum of 2,000 companies per factoid and most of the time much more. But prospects who meet you in person have 10 to 30% higher willingness to pay than those who didn't. Churn for those folks who you meet in person is typically 20% lower than those folks who have never met you. Expansion revenue is typically 15 to 20% higher.

**中文翻译:**
这不只是我们的发现，我们每个事实至少研究了 2000 家公司，大多数时候更多。亲自见过面的潜在客户，其支付意愿比没见过的要高 10% 到 30%。亲自见过面的人，其流失率通常比从未见过面的人低 20%。增购收入通常高出 15% 到 20%。

---

**Patrick Campbell** (00:55:23):
And this is not only in hand-to-hand kind of sales, coffee meetings, lunches, lunch and learns this type of thing, but it's also in scaled products, so products that cost 20, 50 bucks per month. And so my suggestion is to you, especially in a post-COVID, I don't know if that's the right term, but in a world that hopefully does not see another pandemic in our lifetimes, knock on wood, do meetups, do lunches, go to conferences, unless you're Lenny who is not a big fan of conferences. But get out of the office. Make sure you get out of the office. And the budget doesn't have to be as big as you think. Breakfast and lunches are super cheap. We would push all of our P2 and P3s to a meetup, and all of our P1s, we would have one-on-one coffee dates. It's super cheap.

**中文翻译:**
这不仅适用于面对面的销售、喝咖啡、吃午餐、午餐学习会（lunch and learns）之类，也适用于规模化产品，即每月 20、50 美元的产品。所以我的建议是，尤其是在后疫情时代（如果这个词准确的话），在一个希望我们有生之年不再见到大流行的世界里（敲木头祈祷），多搞线下聚会、午餐会、参加会议（除非你是 Lenny，他不太喜欢会议）。走出办公室，一定要走出办公室。预算不需要你想象的那么大。早餐和午餐非常便宜。我们会把所有的 P2 和 P3 客户推向线下聚会，而对于所有的 P1 客户，我们会进行一对一的咖啡约会。这非常便宜。

---

**Lenny** (00:56:08):
What do the Ps mean? Is that priority?

**中文翻译:**
P 代表什么？是优先级（Priority）吗？

---

**Patrick Campbell** (00:56:10):
Priority 1, we want these people to convert, they're very good fits, all this other stuff. P2s are like, they're probably good fits, but they're just not as big. And then P3s are with a content play, they just love our content and stuff, but they're not necessarily good fits for us. And so people make the mistake, they push everyone to dinners and it's like, I don't want to spend all of my money on P2s and P3s.

**中文翻译:**
P1 是我们最希望转化的客户，他们非常契合，等等。P2 可能是契合的，但规模没那么大。P3 则是内容受众，他们喜欢我们的内容，但不一定是我们的目标客户。人们常犯的错误是请所有人吃晚饭，但我不想把钱全花在 P2 和 P3 身上。

---

**Patrick Campbell** (00:56:34):
And so breakfast and lunches are cheaper than dinners. Meetups can be extremely inexpensive, get creative. We like to do barbecue type stuff for, not dive bars, but the unique dive bar, I guess is the best way to put it. So it's not fancy. People just want to meet people, they want to talk to you, especially if you're doing content and things like that. The Lenny Newsletter, Lenny Empire Meetups, I see the pictures of those all the time. There's just an urge to learn from one another and hang out. So yeah, that's the biggest thing, get out of the office or get out of your desk at home.

**中文翻译:**
早餐和午餐比晚餐便宜。线下聚会可以非常省钱，发挥创意。我们喜欢搞烧烤之类的，或者去那种很有特色的小酒吧（dive bar）。不需要很奢华。人们只是想见见人，想和你聊聊，尤其是如果你在做内容。Lenny 的简报、Lenny 帝国的聚会，我经常看到那些照片。人们渴望互相学习、一起聚聚。所以，最重要的一点是：走出办公室，或者离开你家里的办公桌。

---

**Lenny** (00:57:07):
Yeah, that's right. You're on Zoom. And you're saying it's not just the founders, it could be anyone on the team, salespeople, that all works.

**中文翻译:**
没错，别总待在 Zoom 上。你是说不只是创始人，团队里的任何人，比如销售人员，都可以这样做。

---

**Patrick Campbell** (00:57:14):
Anyone. I led marketing as part of my role as CEO, and so I do a lot of this and I'm also the one doing a lot of the content and stuff like that, or the face of a lot of our content, so I did a lot of it. But your head of sales... and you just have to position this a little differently. If they're going to meet with a salesperson, it's the same thing as if they get a email from a BDR, they're like, "I'm not going to figure it out. I don't want to deal with this."

**中文翻译:**
任何人都可以。作为 CEO，我也负责市场营销，所以我做了很多这类工作，我也是很多内容的创作者或代言人。但你的销售主管……你只需要换个方式定位。如果客户要去见一个销售员，那感觉就像收到业务开发代表（BDR）的邮件一样，他们会想：“我不想去，我不想应付这个。”

---

**Patrick Campbell** (00:57:35):
But if it's like, "Hey, we're hosting..." We're doing these lunch and learns right now. I was in Paris, New York, and London last week, it's probably why I'm so sick this week, and all of a sudden we did these lunch and learns. People just want to hang out.
So we had 10 people, we had 20 people at one, 10 people, all priority 1 leads. And then we did these meetups with 100-plus people at each. Just think of that brand equity. And you just hang out. It wasn't just me at all of these things. I ran the content, but then all of our sales folks were hanging out and doing their thing.

**中文翻译:**
但如果是：“嘿，我们要举办……” 我们现在就在做这些午餐学习会。我上周去了巴黎、纽约和伦敦（可能这就是我这周病得这么重的原因），我们举办了这些午餐学习会。人们只是想聚聚。
我们一次有 10 个人，另一次有 20 个人，全是 P1 级别的潜在客户。然后我们举办了每场 100 多人的聚会。想想那带来的品牌资产。大家只是聚在一起。这些活动不只是我一个人参加，我负责内容，而我们的销售人员则在现场社交。

---

**Patrick Campbell** (00:58:15):
But it doesn't have to be super complicated. It's just those touchpoints that people want. And it's so high leverage because there are a lot of people who will not answer your email but will come to an event to meet you or meet someone from your team because it's something to do, especially if you're buying them breakfast or coffee or something like that. It doesn't have to be something that's extravagant.

**中文翻译:**
这不需要太复杂。人们想要的只是那些接触点。这是非常高杠杆的，因为很多人不会回你的邮件，但他们会愿意参加活动来见你或你的团队成员，因为这是一种社交活动，尤其是如果你请他们吃早餐或喝咖啡。不需要多么奢侈。

---

**Lenny** (00:58:25):
I love this advice. Basically, it's like if your sales aren't where you want it to be, find a way to meet your potential leads or someone in your team meeting your leads. That's a very actionable thing you could do like, "We're not hitting our numbers, let's just go meet some people, find opportunities to hang out in real life."

**中文翻译:**
我喜欢这个建议。基本上就是：如果你的销售额没达到预期，想办法去见见你的潜在客户，或者让你的团队成员去见他们。这是一件非常具有操作性的事，比如：“我们没达到指标，那我们就去见见人，找机会在现实生活中聚聚。”

---

**Patrick Campbell** (00:58:41):
Well, in the early days, pre-product market fit, this is all we would do too. I would stay at the worst hotels, I would stay at hostels, but just to get to, "Okay, I want to sell to these people." The best information I'm going to get isn't in a Zoom or I'm asking them questions, it's going to be like, "Hey." I gave a talk on pricing because that was a high leverage thing I could do because no one knows anything about pricing, but they know it's important, so a lot of people want to listen. But then afterwards it's like, "Oh yeah, how do you think about this? What are you doing for this? What are you doing for..." all of those fun producty questions. It's just really, really high leverage. And I think it's one of those things that... It depends on your role, it depends on your stage, but everyone can use something there.

**中文翻译:**
在早期，也就是达到产品市场匹配之前，我们也全是这么做的。我会住最烂的旅馆，甚至住青旅，只是为了能接触到客户：“好吧，我想把东西卖给这些人。” 我能得到的最好的信息不是通过 Zoom 访谈，而是面对面。我会做一个关于定价的演讲，因为那是高杠杆的事，没人懂定价但大家都知道它重要，所以很多人想听。演讲结束后，大家会问：“噢对了，你怎么看这个？你们是怎么处理那个的？” 各种有趣的产品问题。这真的是高杠杆。我认为这取决于你的角色和阶段，但每个人都能从中受益。

---

**Lenny** (00:59:21):
Great segue to our final topic. A lot of people spend time on top of funnel driving visitors, driving traffic, getting the word out. A lot of people spend time at the end of the funnel, closing customers, increasing within an organization. You have this perspective that the middle of the funnel is maybe the biggest opportunity these days. Can you talk about that?

**中文翻译:**
这很好地引出了最后一个话题。很多人把时间花在漏斗顶部（TOFU），吸引访客、引流、扩大知名度。很多人花时间在漏斗底部（BOFU），成交客户、在组织内部扩张。而你认为，如今漏斗中部（MOFU）可能是最大的机会。你能谈谈吗？

---

**Patrick Campbell** (00:59:40):
Pound for pound biggest opportunity. So take a quick step back. Demand generation exists for more than just supporting the sales team. We forget that. So sales and marketing, the past decade, it's all been the funnel, we're top of the funnel, middle of funnel, bottom of the funnel. HubSpot's trying to make it a flywheel, but marketers are still talking about funnels. And when you look at the data, it depends a little bit on the price point and a little bit on the vertical, but 80% of sales and marketing budgets tend to go to the top of the funnel and the bottom of the funnel. So sales folks and ad-type spend, field events, whatever it is, that's where it goes.

**中文翻译:**
按重要性来说，这是最大的机会。让我们先退一步看。需求生成（Demand Generation）的存在不仅仅是为了支持销售团队，我们常忘记这一点。在过去的十年里，销售和营销一直围绕着漏斗：漏斗顶、中、底。HubSpot 试图把它变成“飞轮”，但营销人员仍在谈论漏斗。看数据你会发现（取决于价格点和垂直领域），80% 的销售和营销预算往往流向了漏斗顶端和底端。也就是销售人员、广告支出、线下活动等等。

---

**Patrick Campbell** (01:00:24):
And the whole point is you're trying to move someone from a lack of awareness at the top of the funnel to being aware about you and then to a sales combo or a conversion point, if you're not doing sales. The problem is bottom of the funnel efficiency and top of the funnel efficiency has plummeted the past decade, just plummeted. And it's not only because of the factoids I was saying before about CAC and all these other things and so many competitors being in the market, it's just one of those things that the days of just hiring a bunch of BDRs, not training them, not having them in account-based marketing, not doing all these other things, those days are not here anymore. Those days are gone. Maybe in some specific verticals, in specific parts of the market.

**中文翻译:**
核心点在于，你试图让某人从顶部的“无意识”转变为“意识到你”，然后进入销售对话或转化点。问题是，过去十年，漏斗顶端和底端的效率都在暴跌。这不仅是因为我之前提到的获客成本（CAC）上升和竞争对手激增，还因为那种“随便招一堆 BDR（业务开发代表）、不培训、不做目标账号营销（ABM）”的日子已经一去不复返了。那些日子结束了，也许在某些特定领域还有效，但大环境已经变了。

---

**Patrick Campbell** (01:01:11):
But here's the other problem. Sales today is so much more about timing than it once was. Because there's so much stuff out there, it's one of those things where people are waiting until it's the right time. They're aware of you, but they're waiting. So the question we have to ask ourselves to not bury the lead any further is do we need to make this river of demand generation, basically what demand generation works? But that's table space.

**中文翻译:**
还有一个问题：今天的销售比以往任何时候都更讲究“时机”。因为市面上的选择太多了，人们会等到时机成熟才行动。他们知道你，但他们在观望。所以我们要问自己的问题是：我们是否需要建立一个需求生成的“蓄水池”？

---

**Patrick Campbell** (01:01:37):
If we want to be even increasingly more successful, that middle of the funnel needs to get bigger. That pool of users who is aware of you, interacting with you on a regular basis. What if you had leads basically hanging out there in the middle of the funnel, interacting with you on a regular basis before all of a sudden their timing was right and then all of a sudden they go to the bottom of the funnel, and even better they opt into them. You don't have to keep going after them and doing sales processes that are very kind of churn and burn. So that pool of leads.

**中文翻译:**
如果我们想获得更大的成功，漏斗中部就需要变大。建立一个意识到你并定期与你互动的用户池。如果你的潜在客户一直待在漏斗中部，定期与你互动，直到某天时机成熟，他们突然进入漏斗底部，甚至主动选择购买，那会怎样？你不需要一直追着他们跑，也不需要做那种消耗极大的销售流程。这就是潜在客户池。

---

**Patrick Campbell** (01:02:07):
And so the best way to create pools of leads, freemium. I'm a huge fan of freemium. I used to write articles about how freemium is terrible, so I'm a big convert. I wrote a book on freemium as well. The thing with freemium is CAC is still up over the past decade, but it's up a lot less than overall CAC. Customers who convert from freemium and become paid customers, their retention is typically about 10 to 20% higher than those who converted from a free trial or converted from a traditional sales process.

**中文翻译:**
建立这种客户池的最佳方式是：免费增值模式（freemium）。我是免费增值的狂热粉丝。我以前写文章说免费增值很糟糕，现在我彻底转变了，还写了一本关于它的书。免费增值模式的获客成本在过去十年虽然也在上升，但升幅远低于整体获客成本。从免费增值转化为付费客户的用户，其留存率通常比从免费试用或传统销售流程转化来的客户高 10% 到 20%。

---

**Patrick Campbell** (01:02:47):
And then on top of that, NPS or CSAT, we measured it through NPS, is typically about double because they're converting on their own timeline, not on some artificial timeline of a free trial or artificial timeline of sales. You should still have those things, but I want this pool of people who are aware of me and are using something of my product because at the end of the day, what better content do you have than your actual product? Even if you're a big enterprise solution, give them something to interact with.

**中文翻译:**
此外，他们的 NPS 或客户满意度通常是两倍，因为他们是根据自己的时间表转化的，而不是被免费试用或销售人员强加的时间表推着走。你仍然应该保留那些手段，但我想要一个意识到我并正在使用我部分产品的用户池。毕竟，还有什么内容比你的实际产品更好呢？即使你做的是大型企业解决方案，也要给他们一些可以互动的东西。

---

**Patrick Campbell** (01:03:07):
And then the other way to fill that middle of the funnel is, I think inbound marketing is just becoming SEO and eBooks. Kieran from HubSpot gets offended when I say that, but I love you, buddy. It's okay. I'm still a huge fan. And this is just because CAC and inbound marketing has gone up and it's all about a lot of SEO and we'll see what AI does to that.

**中文翻译:**
另一种填充漏斗中部的方法是：我认为入站营销（Inbound Marketing）正逐渐变成仅仅是 SEO 和电子书。HubSpot 的 Kieran 听我这么说可能会生气，但我还是爱你的，伙计。没关系，我仍然是你的粉丝。这只是因为入站营销的获客成本上升了，现在全是关于 SEO，我们还得看看 AI 会对它产生什么影响。

---

**Patrick Campbell** (01:03:21):
But this whole thing of inbound media, we got on this train about five years ago, and inbound media is just podcast video series. When we sold the company, we had eight different podcasts and video series, all very niche like Pricing Page Tear Down, which was a show about we collected data and tore down pricing pages, the good and the bad. We had Boxed Out, which was a retention focused show for the subscription e-commerce industry.

**中文翻译:**
但“入站媒体”（Inbound Media）这一整套东西，我们大约五年前就开始做了。入站媒体就是播客和视频系列。当我们卖掉公司时，我们有 8 个不同的播客和视频系列，都非常垂直。比如《定价页面拆解》（Pricing Page Tear Down），这是一个收集数据并拆解定价页面优劣的节目。我们还有《Boxed Out》，这是一个针对订阅电商行业的留存专题节目。

---

**Patrick Campbell** (01:03:44):
So all of that was to build this pool so that people were aware of us. And then over time, all of a sudden they're like, "Oh, we have a pricing problem, we should go talk to these guys. Oh, we have this content or this retention thing, we should go talk to these guys." But I think the pool is kind of the future and a lot of people are still treating it as just this gateway between the top and the bottom of the funnel.

**中文翻译:**
所有这些都是为了建立那个“池子”，让人们意识到我们的存在。随着时间的推移，突然间他们会想：“噢，我们遇到了定价问题，应该去找那帮人聊聊。噢，我们有留存问题，应该去找那帮人。” 我认为这种“池子”才是未来，而很多人仍然只是把它当作连接漏斗顶端和底端的一个过道。

---

**Lenny** (01:04:02):
Middle of the funnel is the new top of funnel. We need a bumper sticker.

**中文翻译:**
“漏斗中部就是新的漏斗顶部”。我们需要把它印成车贴。

---

**Patrick Campbell** (01:04:05):
There you go. I don't know if that's going to sell well, but I will buy one, so.

**中文翻译:**
没错。我不知道这好不好卖，但我肯定会买一个。

---

**Lenny** (01:04:09):
The most nerdiest of all bumper stickers. Patrick, we've gone through 10 topics. Is there anything else you want to touch on before we get to our very exciting lightning rounds?

**中文翻译:**
那绝对是最极客的车贴。Patrick，我们已经聊完了 10 个话题。在进入激动人心的闪电轮问答之前，你还有什么想补充的吗？

---

**Patrick Campbell** (01:04:18):
I think what I will say is this is all still hard. So I'm giving some heuristics, I'm giving some benchmarks, but your mileage is going to vary. But again, that's your job, whether you're a founder, a product person, an exec, whatever you are, your job is to take in information, your job is to analyze the problem, and then ultimately come up with the best solution. And so I think it's one of those things that there's some hard truths I think we talked about, but then there's a lot of this that you have to evaluate it for yourself. So just a general, I may come off like a know-it-all, but I understand that mileage varies I guess is the best way...

**中文翻译:**
我想说的是，这一切依然很难。我提供了一些启发式的思考和基准，但具体情况因人而异。但这正是你的工作——无论你是创始人、产品经理还是高管，你的工作就是接收信息、分析问题，并最终得出最佳解决方案。我们谈到了一些残酷的真相，但其中很多内容你必须根据自己的情况去评估。总之，我表现得可能像个“懂王”，但我明白具体情况会有所不同。

---

**Lenny** (01:04:54):
Well, with that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
好，现在进入我们非常精彩的闪电轮问答。我有六个问题要问你。准备好了吗？

---

**Patrick Campbell** (01:05:01):
I'm ready. I feel like I need a buzzer.

**中文翻译:**
准备好了。我觉得我需要一个抢答器。

---

**Lenny** (01:05:02):
I'm going to add a buzzer someday. Anyway, here we go. What are two or three books that you recommend most to other people?

**中文翻译:**
我以后会加一个的。言归正传，开始吧。你最推荐给别人的两三本书是什么？

---

**Patrick Campbell** (01:05:11):
I have read High Output Management probably 20 times in the past 10 years. I read it at least once a year now. I commissioned a bronze bust of Andy Grove, so that's being done. I'm a big Andy Grove fan.

**中文翻译:**
在过去的 10 年里，我大概读了 20 遍《高产出管理》（High Output Management）。现在我每年至少读一遍。我还定制了一个安迪·格鲁夫（Andy Grove）的青铜胸像，正在制作中。我是他的超级粉丝。

---

**Lenny** (01:05:25):
Oh, it's in progress?

**中文翻译:**
噢，正在制作中？

---

**Patrick Campbell** (01:05:26):
Yeah, yeah, yeah. It's in progress. It's not done. I'll send you a mockup after this. But yeah, High Output Management. Thinking in Bets, going to that first principles thinking. I find that a good book to share with people so that they can think about things and get on board with that.
And then Powerful by Patty McCord. Anything around HR to kind of break your brain a little bit about what you think about HR and people ops. That's the gateway drug. That was the one where I was like, "Oh, we can choose how to design our people ops teams."

**中文翻译:**
是的，还没做完。回头我给你发个模型图。除了《高产出管理》，还有《对赌》（Thinking in Bets），它涉及第一性原理思维。我觉得这是一本很好的书，可以分享给别人，让他们学会思考。
还有 Patty McCord 的《强大》（Powerful）。任何关于 HR 的书，如果能打破你对 HR 和人力资源运营的固有认知，那它就是“入门毒品”。读完那本书我才意识到：“噢，我们可以选择如何设计我们的人力资源团队。”

---

**Lenny** (01:05:55):
Okay, next question. Favorite recent movie or TV show?

**中文翻译:**
好，下一个问题。最近最喜欢的电影或电视剧？

---

**Patrick Campbell** (01:05:58):
I don't have one that's recent, but I watch The West Wing at least once per week, so I've done that for a long time. I love Sorkin, I think the writing's just so good, so I'll just throw that out.

**中文翻译:**
最近没怎么看新的，但我每周至少看一次《白宫风云》（The West Wing），我已经坚持很久了。我爱索金（Sorkin），我觉得剧本写得太棒了。

---

**Lenny** (01:06:10):
Great one. Someone was telling me there's a podcast to analyze each episode, which [inaudible 01:06:14].

**中文翻译:**
经典。有人告诉我有个播客专门分析每一集。

---

**Patrick Campbell** (01:06:13):
It is a great podcast and I've listened to most of them, so yeah.

**中文翻译:**
那是个很棒的播客，我大部分都听过。

---

**Lenny** (01:06:18):
Okay, great. You're all over it. Favorite interview question that you like to ask because you're interviewing.

**中文翻译:**
太好了，你果然很了解。你最喜欢的面试问题是什么？

---

**Patrick Campbell** (01:06:22):
I have a controversial one. I'm not going to be able to go through the entire question in a lightning round. But what I do is I do a mini... I did all the final interviews at ProfitWell, and we did a very hard culture check in the final interview. There's a mini case study, it only lasts about a couple of minutes, I'm not going to go through it, but I asked them if someone in Slack responded to someone sharing something benign, like some report they found on the internet from McKinsey, they shared it in Slack, and then someone responded to that with something indirectly offensive.

**中文翻译:**
我有一个比较有争议的问题。在闪电轮里我没法展开说。我在 ProfitWell 负责所有的终面，我们会进行非常严格的文化考核。有一个几分钟的小案例研究：我问他们，如果有人在 Slack 上分享了一些普通的东西（比如麦肯锡的一份报告），然后有人回复了一些间接带有冒犯性的话。

---

**Patrick Campbell** (01:06:55):
So it's changed over the years, sometimes I say, "Oh, they called it the R word, they said it was stupid," something indirectly offensive. And I say, "What would you do, and what do you think the company should do?" And no matter what they say, I challenge them, and I always tell them, "I've never seen that at ProfitWell," which is always good just to make sure they don't have a bunch of fear in this position.

**中文翻译:**
这些年问题会有变化，有时我会说：“噢，他们用了某个歧视性词汇，或者说这很愚蠢”，总之是间接冒犯。我会问：“你会怎么做？你认为公司应该怎么做？” 无论他们说什么，我都会挑战他们的观点。我总是告诉他们：“我在 ProfitWell 从未见过这种情况”，这有助于消除他们的恐惧。

---

**Patrick Campbell** (01:07:19):
But it gave me a really, really good opportunity to talk through our culture, particularly the most charitable interpretation piece. And I would say there were about 10% of people who had a zero tolerance policy for whatever the situation was. And I would tell them, I would say, "Hey, listen. We have zero tolerance for the obvious things, we probably all agree on those." But for this type of situation, we would ask some questions, we'd want to figure it out, we want to see, there's probably some judgment around what happened, how long if they'd been doing this for a while, that type of thing. And then we would make a decision on what would happen. And a lot of times nothing would happen except, "Hey, don't be an idiot, you're smarter than that, use better words," or something like that. And so that was a good culture check to opt them in or out.

**中文翻译:**
这给了我一个极好的机会来深入探讨我们的文化，尤其是“最善意的解释”那部分。大约 10% 的人会对任何情况都持“零容忍”态度。我会告诉他们：“听着，对于显而易见的错误，我们当然零容忍，这大家都有共识。但对于这类情况，我们会先询问、了解情况，看看发生了什么，是否是惯犯等等。然后我们再做决定。很多时候可能什么都不会发生，只是提醒一句：‘嘿，别犯傻，你比这聪明，换个好点的词。’” 这是一个很好的文化测试，用来决定他们是否合适。

---

**Lenny** (01:08:05):
That is very cool. It circles back to the value of culture and values and being aligned within your company on culture and values. And it's interesting that that's the question you ask, and not something technical or skill-based.

**中文翻译:**
这太酷了。这又回到了文化和价值观的重要性，以及公司内部达成共识的价值。有趣的是你问的是这个问题，而不是技术或技能方面的问题。

---

**Patrick Campbell** (01:08:16):
Yeah. Well, I do all the final interviews. So they've already gone through a skill-based and they've done culture screen already and stuff like that. So this is more of the, here's why you should not work here, that type of conversation basically.

**中文翻译:**
是的。因为我负责终面，他们已经通过了技能测试和初步的文化筛选。所以这更像是一种“告诉你为什么不该在这里工作”的谈话。

---

**Lenny** (01:08:30):
I love that. Next question, what are five SaaS products that you or your company uses that you love? And bonus points for ones maybe people haven't heard,

**中文翻译:**
我喜欢这个。下一个问题：你或你的公司正在使用的、你最喜欢的五个 SaaS 产品是什么？如果能说出一些大家没听过的，会有加分。

---

**Patrick Campbell** (01:08:39):
That's hard to answer too because at the end of the day, we'd all say Zoom, Google Workspace or whatever they're calling it these days because those are the things that are so central. I've got to give a shout-out to Notion, we use Notion for all of our documentation. I use Notion for my personal... all these things. I know Coda is a sponsor, so I apologize but-

**中文翻译:**
这也很难回答，因为到头来大家都会说 Zoom、Google Workspace 之类的，因为它们太核心了。我要特别提一下 Notion，我们所有的文档都用 Notion。我个人也用 Notion。我知道 Coda 是赞助商，所以我很抱歉，但是——

---

**Lenny** (01:08:59):
They're both sponsors, and so we're friends with everyone over here. Both are great-

**中文翻译:**
它们都是赞助商，所以我们和大家都是朋友。两个都很棒——

---

**Patrick Campbell** (01:09:02):
Amazing. Lenny's Podcast, friends of all products. Descript. I use Descript quite a bit. I use Descript not only for... it's like a video recording and editing tool, or you can bring in video to edit. But it's got some cool features that... I use it more than Loom a lot of times because it just works in my workflow, not only for creating, but also for those quick conversations.

**中文翻译:**
太好了。Lenny 的播客，所有产品的朋友。第二个是 Descript。我经常用 Descript。它不仅是一个视频录制和剪辑工具，你还可以导入视频进行编辑。它有一些很酷的功能……很多时候我用它比用 Loom 还多，因为它更符合我的工作流，不仅用于创作，也用于快速沟通。

---

**Patrick Campbell** (01:09:25):
K-Tool. Here's a fun one. This is an indie product, K-Tool. There's probably other products that exist like this, but I actually really like the interface of it, it's super simple. Basically if I'm online or someone sends me a PDF or something like that, I can basically choose to send that to my Kindle. So if someone sends me something I could just choose to send and then I can batch all of those things into a weekly newsletter that I can curate. So my Sundays and my Monday morning are just spent reading. So I have this weekly newsletter of someone wants me to review this thing or someone wants me to read this article or something like that. So I batch that into a little newsletter and it's just a Chrome extension that works really well.

**中文翻译:**
第三个是 K-Tool。这是一个很有趣的独立产品。可能还有其他类似产品，但我非常喜欢它的界面，非常简洁。基本上，如果我在网上看到什么，或者有人给我发了 PDF，我可以选择把它发送到我的 Kindle。这样我就可以把这些东西汇总成一份我自制的每周简报。所以我周日和周一早上的时间都花在阅读上。我会把别人想让我审阅的东西或想让我读的文章汇总起来，它只是一个非常好用的 Chrome 插件。

---

**Patrick Campbell** (01:10:03):
Tweet Hunter, I'm trying to be more on Twitter. I went through lulls, so now I'm trying to be consistent. So Tweet Hunter's pretty good. It's got some AI fun stuff into it to make discovery better. And then it's not a SaaS application, but the last one is this Apple Watch Ultra. So I don't carry my phone anymore. I just don't... I found myself being on a computer, walking away with my phone, going, doing stuff and then just never being off-screen.

**中文翻译:**
第四个是 Tweet Hunter，我正努力在 Twitter 上更活跃。我经历过低谷期，现在想保持连贯性。Tweet Hunter 挺不错的，它有一些 AI 功能让发现内容变得更容易。最后一个虽然不是 SaaS 应用，但我想说是 Apple Watch Ultra。我现在不再随身带手机了。我发现自己以前总是对着电脑，离开电脑又带着手机，结果永远离不开屏幕。

---

**Patrick Campbell** (01:10:35):
So I have this for when I'm not in front of my computer and I'm this close to also doing it when I travel to when I've been traveling, my phone will stay in my suitcase, but it connects if I need to make a phone call. It connects via Bluetooth, all that kind stuff. But just trying to take my attention away from my phone basically, so that's, that's been the unlock.

**中文翻译:**
所以当我不在电脑前时，我就用手表。我甚至打算在旅行时也这么做：手机留在行李箱里，如果需要打电话，它可以通过蓝牙连接。这基本上是为了把我的注意力从手机上移开，这对我来说是一个巨大的突破。

---

**Lenny** (01:10:51):
Damn. What a list. That was incredible. I'm going to ask just one more question. What's favorite lesson from your NSA experience that helps you in life day to day?

**中文翻译:**
哇，这份名单太棒了。我要问最后一个问题：在 NSA 的经历中，哪一个教训对你的日常生活最有帮助？

---

**Patrick Campbell** (01:11:02):
I shouldn't say everything, but most things are more complicated than it seems. And that's not like a sinister thing, it just means when that person's coming at you and super angry about something, whether it's your fault or not, something's there, they're having a bad day, on top of it, you really messed up, you tapped into a particular emotion that you didn't realize you did. Or hey, there's even the story in the news about this politician's bad or something like that. Everything's a lot more complicated, and not in a it's too hard to understand way, it's just you should always caution yourself on believing the first reaction that you have.

**中文翻译:**
我不能说所有事，但大多数事情都比看起来要复杂。这并不是什么阴暗的想法，它只是意味着：当一个人冲过来对你大发雷霆时，无论是不是你的错，背后肯定有原因——也许他今天过得很糟，而你恰好犯了个错，触动了他自己都没意识到的某种情绪。或者新闻里说某个政客很坏之类的。一切都复杂得多，这并不是说它难懂，而是说你应该时刻提醒自己，不要轻易相信自己的第一反应。

---

**Patrick Campbell** (01:11:44):
And I developed that there because there's so many things where... And it was also my first job, so a lot of this stuff happens because it's your first job, many people may have this experience at a different place, but it was like, "Oh, this geopolitical thing that's happened. Oh, here's my first instinct, that means this is bad." They're like, "Well, actually, there's this other thing going on over here and this other thing going over there, and those are actually connected. That's why this is caused." So that's helped me, one, not get so pissed off at the news. That's also helped me, I think just as a human, along with most charitable interpretation, to just be like, "Okay, let me not overreact here. Let me seek to understand and then react or respond, versus react."

**中文翻译:**
我在那里养成了这种习惯，因为那是我的第一份工作。很多人在不同地方也会有这种经历。比如：“噢，发生了这个地缘政治事件。我的第一直觉是，这很糟糕。” 但同事会说：“其实，这边还有另一件事，那边也有另一件事，它们其实是关联的。这才是原因。” 这帮了我很多：第一，不再对新闻感到那么愤怒；第二，作为一个普通人，结合“最善意的解释”，我会想：“好吧，让我先别过度反应。让我先试着去理解，然后再做出回应，而不是直接反应。”

---

**Lenny** (01:12:23):
What a beautiful way to end it. Patrick Campbell, renaissance man of a brain. This may be the most action-packed episode we've had, and I'm not surprised. Two final questions where can folks find you online if they want to ask you questions, reach out, learn more about what you're up to? And how can listeners be useful to you?

**中文翻译:**
多么完美的结尾。Patrick Campbell，文艺复兴式的大脑。这可能是我们目前为止干货最满的一集，我一点也不意外。最后两个问题：如果大家想问你问题、联系你或了解你的近况，可以在哪里找到你？以及，听众可以为你做些什么？

---

**Patrick Campbell** (01:12:38):
Yeah, so I am on Twitter @patticus, childhood nickname, P-A-T-T-I-C-U-S. LinkedIn, Patrick Campbell. I don't check my LinkedIn messages, I'm going to get around to it, it's just there's so much spam in there. But yeah, you could find me there or just pc@patticus.com, that's my personal email. So yeah, if I can be helpful or you want to see more of the data or you have this question or that question, we've probably written or recorded something on some of the things we talked about today, so I'm happy to send it over and just obviously want to be helpful, so yeah, feel free to hit me up.

**中文翻译:**
好的，我的 Twitter 是 @patticus（我小时候的绰号）。LinkedIn 是 Patrick Campbell，但我不太看 LinkedIn 私信，因为垃圾信息太多了。你也可以直接发邮件到 pc@patticus.com，那是我的个人邮箱。如果我能帮上忙，或者你想看更多数据，或者有任何问题，我们可能已经针对今天聊的内容写过文章或录过视频，我很乐意发给你。我显然很乐意提供帮助，所以随时联系我。

---

**Lenny** (01:13:08):
Amazing. Patrick, thank you again for being here.

**中文翻译:**
太棒了。Patrick，再次感谢你的到来。

---

**Patrick Campbell** (01:13:11):
Thanks for having me, man.

**中文翻译:**
谢谢你的邀请，伙计。

---

**Lenny** (01:13:12):
Bye, everyone.

**中文翻译:**
大家再见。

---

**Audio** (01:13:14):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本节目有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。