# Paul Millerd - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Paul Millerd.

---

### [00:00:00] Paul Millerd

**English:**
Take three hours during a workday. Has to be during a workday. Block off your schedule, sneak out. People can pull this off. Go for a walk without a destination or do something from your childhood that you used to do all the time. Did you use to play basketball? Did you use to paint? Did you use to play an instrument? And just pay attention. What is emerging? Do you feel bad for sneaking out of work? Where does that bad feeling come from? What does that mean about your definition of work and what work means to you?

**中文翻译:**
在工作日找三个小时。必须是在工作日。封锁你的日程，偷偷溜出去。人们是可以做到的。漫无目的地散散步，或者做一些你小时候经常做的事情。你以前打篮球吗？你以前画画吗？你以前玩乐器吗？然后只需留意：有什么感觉正在浮现？你会因为翘班而感到愧疚吗？这种负罪感从何而来？这对于你对工作的定义，以及工作对你的意义意味着什么？

---

### [00:00:30] Paul Millerd

**English:**
A lot of people have never really thought about, why do you work? People say money. Okay, that's fine. But what else? Why? Are you trying to be a good person? Do you see a good person as somebody that works every day? Maybe. These are a lot of scripts people grow up with. You're really just creating this space to get in touch with, how do I actually feel about work? How do I get to know myself more? Are there things that I've lost touch with that really bring me alive?

**中文翻译:**
很多人从未真正思考过：你为什么要工作？人们会说为了钱。好吧，这没问题。但除此之外呢？为什么？你是想做一个“好人”吗？你是否认为一个好人就是每天工作的人？也许吧。这些都是人们成长过程中遵循的“剧本”。你实际上是在创造一个空间，去接触内心：我到底对工作有什么感觉？我如何能更了解自己？是否有一些我已经生疏、但能让我真正焕发生机的事情？

---

### [00:00:59] Lenny

**English:**
Today my guest is Paul Millerd. Paul is the author of The Pathless Path: Imagining a New Story for Work and Life. His book is getting a lot of traction within the tech community, because it explores a different way of living, essentially breaking free of the default path for your work and your life that we all basically start on. What Paul describes in his book is almost exactly the path I took to figure out this very weird and wonderful work that I do now with the newsletter and podcast. And because of that, I think this is an important conversation to have, because it may inspire you to explore a different path in your own life.

**中文翻译:**
今天的嘉宾是 Paul Millerd。Paul 是《无径之路：想象工作与生活的新故事》（The Pathless Path）一书的作者。他的书在科技界引起了很大反响，因为它探索了一种不同的生活方式，本质上是摆脱我们所有人基本上都会开始的、关于工作和生活的“默认路径”。Paul 在书中描述的内容，几乎和我为了摸索出我现在从事的这份奇妙而古怪的工作（Newsletter 和播客）所走过的路一模一样。正因如此，我认为这是一场重要的对话，因为它可能会激励你在自己的生活中探索一条不同的道路。

---

### [00:01:33] Lenny

**English:**
In our conversation, Paul explains what the pathless path is, how to go about exploring your own pathless path, how to address fears we all have around money, and prestige, and safety that keep us on the default path, plus tons of stories and examples, and very tactical advice for thinking about exploring a new direction in your own life. With that, I bring you Paul Millerd after a short word from our sponsors.

**中文翻译:**
在我们的对话中，Paul 解释了什么是“无径之路”，如何去探索属于你自己的无径之路，如何应对我们所有人都有的、关于金钱、声望和安全感的恐惧（正是这些恐惧让我们留在默认路径上），此外还有大量的案例和非常实用的建议，帮助你思考如何探索生活的新方向。在简短的赞助商广告之后，让我们欢迎 Paul Millerd。

---

### [00:01:58] Lenny (Sponsor: Sanity)

**English:**
This episode is brought to you by Sanity. Your website is the heart of your growth engine. For that engine to drive big results, you need to be able to move super fast, ship new content, experiment, learn, and iterate. But most content management systems just aren't built for this. Your content teams wrestle with rigid interfaces as they build new pages. You spend endless time copying and pasting across pages, and recreating content for other channels and applications. And their ideas for new experiments are squashed when developers can't build them within the constraints of outdated tech.

**中文翻译:**
本期节目由 Sanity 赞助。你的网站是增长引擎的核心。为了让这个引擎产生巨大的成果，你需要能够快速行动、发布新内容、实验、学习并迭代。但大多数内容管理系统（CMS）并非为此而设计。你的内容团队在构建新页面时要与僵化的界面作斗争。你花费大量时间在页面之间复制粘贴，并为其他渠道和应用重新创建内容。当开发人员无法在过时技术的限制下实现新实验的想法时，这些创意就会被扼杀。

---

### [00:02:30] Lenny (Sponsor: Sanity)

**English:**
Forward-thinking companies like Figma, Amplitude, Loom, Riot Games, Linear, and more use sanity to build content growth engines that scale, drive innovation, and accelerate customer acquisition. With Sanity, your team can dream bigger and move faster. As the most powerful headless CMS on the market, you can tailor editorial workflows to match your business. Reuse content seamlessly across any pager channel and bring your ideas to market without developer friction. Sanity makes life better for your whole team. It's fast for developers to build with, intuitive for content managers, and it integrates seamlessly with the rest of your tech stack. Get started with Sanity's generous free plan. And as a Lenny's Podcast listener, you can get a boosted plan with double the monthly usage. Head over to sanity.io/lenny to get started for free. That's sanity.io/lenny.

**中文翻译:**
像 Figma、Amplitude、Loom、Riot Games、Linear 等具有前瞻性的公司都在使用 Sanity 来构建可扩展、驱动创新并加速客户获取的内容增长引擎。有了 Sanity，你的团队可以拥有更大的梦想并行动得更快。作为市场上最强大的 Headless CMS（无头内容管理系统），你可以定制编辑工作流以匹配你的业务。在任何页面或渠道无缝复用内容，并在没有开发摩擦的情况下将你的想法推向市场。Sanity 让整个团队的生活变得更美好。开发人员构建速度快，内容经理操作直观，且能与你的其他技术栈无缝集成。从 Sanity 慷慨的免费计划开始。作为 Lenny's Podcast 的听众，你可以获得双倍月度使用量的增强计划。前往 sanity.io/lenny 免费开始。

---

### [00:03:21] Lenny (Sponsor: Maui Nui Venison)

**English:**
This episode is brought to you by Maui Nui Venison, a mission-based food company bringing the healthiest red meat on the planet directly to your door. I actually joined Maui Nui Venison earlier this year, after hearing their ad on the Tim Ferriss podcast, and I'm excited to be spreading the message further. Not only does this company provide the most nutrient dense and protein dense red meat available. Their operation produces the only stress-free, 100% wild harvested red meat on the market, that is the only one of its kind in the world, actively managing Maui's invasive axis deer populations, helping to restore balance to vulnerable ecosystems, food systems, and communities in Hawaii. Also, it is seriously delicious, not at all gamey, and easy to cook. My wife and I made stew, and steaks, and all kinds of grilled goodies with the meat.

**中文翻译:**
本期节目由 Maui Nui Venison 赞助，这是一家以使命为导向的食品公司，将地球上最健康的红肉直接送到你家门口。在 Tim Ferriss 的播客中听到他们的广告后，我于今年早些时候加入了 Maui Nui Venison，很高兴能进一步传播这个消息。这家公司不仅提供营养密度和蛋白质密度最高的红肉，他们的运作还生产了市场上唯一的无压力、100% 野生捕获的红肉，这是世界上唯一的此类项目，通过积极管理茂宜岛的入侵轴鹿种群，帮助恢复夏威夷脆弱的生态系统、食物系统和社区的平衡。此外，它真的非常好吃，一点也不腥，而且很容易烹饪。我和妻子用这些肉做了炖菜、牛排和各种烧烤。

---

### [00:04:07] Lenny (Sponsor: Maui Nui Venison)

**English:**
We also feel great about it as a protein from an ethical standpoint. I highly recommend trying their all natural venison jerky sticks for an optimal protein snack, as well as a wide variety of fresh cuts all available in their online butcher shop. There are limited memberships available, but you can sign up and get 20% off your first order at mauinuivenison.com/lenny. That's mauinuivenison.com/lenny. Paul, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
从伦理角度来看，作为一种蛋白质来源，我们也感觉非常好。我强烈建议尝试他们的全天然鹿肉干条作为优质蛋白质零食，以及他们在线肉店提供的各种新鲜切割肉块。会员名额有限，但你可以在 mauinuivenison.com/lenny 注册并享受首单 8 折优惠。Paul，非常感谢你能来。欢迎来到播客。

---

### [00:04:38] Paul Millerd

**English:**
Excited to be here Lenny.

**中文翻译:**
很高兴来到这里，Lenny。

---

### [00:04:40] Lenny

**English:**
I'm more excited to have you on. You published a book called The Pathless Path, which I have right here. Last I heard you've sold over 40,000 copies of this book, which I know puts it in the top 1% of books sold, possibly in the top 0.1% of books sold. It's an absurdly high number for books sold. People don't really know this. And especially for a self-published book, it's a huge success. And I thought it would be good to start with a concept that you call the default path. What is the default path?

**中文翻译:**
我更兴奋能请到你。你出版了一本叫《无径之路》的书，就在我手里。我最后听说这本书已经卖出了超过 4 万本，据我所知，这让它进入了图书销量的前 1%，甚至可能是前 0.1%。对于图书销量来说，这是一个高得离谱的数字。人们可能不太了解这一点，尤其是对于一本自出版的书来说，这是一个巨大的成功。我想我们可以从你称之为“默认路径”（Default Path）的概念开始。什么是默认路径？

---

### [00:05:08] Paul Millerd

**English:**
Yeah, I think the default path is different for everyone and slightly different in every different culture. It's really the story in your head about what you should do. And most of us have some sort of script that we're living out. This is especially powerful when we're in our late teens and early twenties, right? We're trying to execute a script. And it can be different in every country. In the US it's sort of like go to college, get good grades, get a good job, make a good salary, buy a house, get married, have a family, things like that. And when it comes to work, the default path is get a job and work continuously for all of adulthood.

**中文翻译:**
是的，我认为默认路径对每个人来说都不同，在不同的文化中也略有差异。它实际上是你脑海中关于“你应该做什么”的故事。我们大多数人都在演某种剧本。当我们处于十几岁末到二十岁出头时，这种力量尤为强大，对吧？我们试图执行一个剧本。在每个国家可能都不一样。在美国，它大概是：上大学、拿好成绩、找份好工作、拿高薪、买房、结婚、组建家庭等等。谈到工作，默认路径就是找份工作，并在整个成年期持续不断地工作。

---

### [00:05:50] Paul Millerd

**English:**
And when you opt out of the default path, there aren't really offerings. People have a hard time even contemplating it. You'll trigger insecurities in other people by just existing outside the frame of the default path. And it's the default path in their head of their conception of how the world should work and does work, right? So a lot of what I explore is what is life beyond the default path, and what are the stories we can use to one, at minimum, feel better about what we're doing? And two, what are the stories we can adopt to thrive?

**中文翻译:**
当你选择退出默认路径时，社会并没有提供现成的选项。人们甚至很难去想象它。仅仅因为你存在于默认路径的框架之外，你就会引发他人的不安。因为在他们脑海中，默认路径就是世界“应该”如何运作以及“确实”如何运作的观念，对吧？所以我探索的很多内容是：默认路径之外的生活是什么样的？我们可以利用什么样的故事来——第一，至少让我们对自己在做的事情感觉更好；第二，我们可以采纳什么样的故事来让自己蓬勃发展？

---

### [00:06:32] Lenny

**English:**
I imagine many people listening to this are feeling like, "No way I'm on the default path. I'm doing so many interesting things. I'm doing what I want," but they probably still are on this default path. What are some signs that might tell you that you actually still are on this path, and there's such a new direction you could explore that you haven't explored?

**中文翻译:**
我想很多听众可能会觉得：“不可能，我没在默认路径上。我正在做这么多有趣的事情，我在做我想做的事。”但他们可能仍然在这条默认路径上。有哪些迹象可能表明你实际上仍然在这条路上，并且还有你尚未探索的新方向？

---

### [00:06:50] Paul Millerd

**English:**
Yeah, I think there's nothing wrong with the default path. The difference I would make is, are you conscious about what you're actually doing? What are the costs of your game? What are the trade-offs? What are the implicit contracts are you creating with yourself? A lot of times when people quit their jobs, they forget to fire the manager in their head. They don't realize they can take the afternoon off to spend it with their kids. They've created this implicit contract that Monday through Friday, eight to 10 hours a week you have to work. And that may work for people, but are you actually opting into that, or are you just sort of accepting the default?

**中文翻译:**
是的，我认为默认路径本身没有错。我想区分的是：你是否清醒地意识到你到底在做什么？你这场游戏的成本是什么？代价是什么？你与自己达成了哪些隐性契约？很多时候，当人们辞职时，他们忘了“解雇”脑子里的那个经理。他们没意识到自己可以休个下午假去陪孩子。他们创造了这种隐性契约：周一到周五，每周必须工作 8 到 10 个小时（此处 Paul 口误，应为每天）。这可能对某些人有效，但你是真的主动选择了这种方式，还是仅仅在接受默认设置？

---

### [00:07:35] Lenny

**English:**
I think it's a really important point. It's totally fine to stay on this default path. It's not for everyone to try something totally different. Can you talk a little bit about just how to think about the benefits of that and the trade-offs of, "Okay, this is great, I'm going to stay where I am"?

**中文翻译:**
我认为这是一个非常重要的观点。留在默认路径上完全没问题。尝试完全不同的东西并不适合所有人。你能谈谈如何思考其中的好处，以及“好吧，这很好，我要留在原地”这种选择的权衡吗？

---

### [00:07:48] Paul Millerd

**English:**
It's interesting. I did not think my book would resonate with people that were firmly in the traditional work role. Full-time jobs, big companies, things like that. But I've had many people reach out that say, "Wow, this sort of loosened the tightness between my identity and my work reality, and loosened it up a little bit. And I'm able to play with it a little more." I had one friend, he said, "From your book, I made a list of the four priorities. Right now I'm getting three of them. And it's helped me become more aware that I'm actually getting these three things that I prioritize. I'm missing the fourth. I'm probably going to have to make a change two years from now. Maybe another role, because I do want to lean into that fourth thing." I think it's really just about remixing your path. My hot take is that we're all on a pathless path. You were at Airbnb. Airbnb, every two years were there was a different company.

**中文翻译:**
很有趣。我原本没想过我的书会引起那些坚守传统工作角色的人的共鸣——比如全职工作、大公司之类的。但我收到很多人的反馈说：“哇，这在某种程度上松动了我的身份认同与工作现实之间的紧绷感，让我能更灵活地对待它。”我有一个朋友说：“读了你的书后，我列出了四个优先级。目前我得到了其中的三个。这让我更清楚地意识到，我确实得到了我优先考虑的这三件事。我缺了第四个。我可能在两年后需要做出改变，也许是换个角色，因为我确实想追求那第四件事。”我认为这实际上是关于“重新混编”你的路径。我的一个激进观点是，我们其实都处于“无径之路”上。你曾在 Airbnb 工作，Airbnb 每隔两年就像是一家不同的公司。

---

### [00:08:53] Lenny

**English:**
Absolutely true.

**中文翻译:**
绝对没错。

---

### [00:08:54] Paul Millerd

**English:**
Right? And so we're constantly needing to reinvent and reevaluate. And I think thinking of our lives as this smooth trajectory up this corporate ascent sort of limits the possibilities of our own life. So just acknowledging that we are being disrupted. We all have personal lives where we have relationship challenges, health challenges, external shocks, inflation, things like this, that are changing our reality all the time. And it sort of sucks that there aren't these comfortable middle class jobs that are growing and abundant. They're shrinking. David Autor, a economist from MIT, has pretty good research on this, and it's just making people a little more unsettled. It sucks, but this is the reality we're living in, especially places like the US becoming super tech heavy. And how do you navigate that? It's hard. Everyone's struggling with their relationship to work.

**中文翻译:**
对吧？所以我们不断需要重新发明和重新评估。我认为，如果把生活看作是在公司阶梯上平滑上升的轨迹，这会限制我们生活的可能性。所以要承认我们正在被颠覆。我们都有个人生活，会面临人际关系挑战、健康挑战、外部冲击、通货膨胀等等，这些都在不断改变我们的现实。遗憾的是，那些舒适的、不断增长且充足的中产阶级工作正在萎缩。麻省理工学院的经济学家 David Autor 对此有非常深入的研究，这让人们感到更加不安。这很糟糕，但这就是我们生活的现实，尤其是像美国这样技术高度密集的地区。你该如何应对？这很难。每个人都在为自己与工作的关系而挣扎。

---

### [00:09:58] Lenny

**English:**
Let's actually talk about the pathless path. You've been kind of touching on various ways of thinking about it. What's the simplest way of thinking about this concept of the pathless path?

**中文翻译:**
让我们具体谈谈“无径之路”。你刚才触及了各种思考它的方式。关于“无径之路”这个概念，最简单的理解方式是什么？

---

### [00:10:07] Paul Millerd

**English:**
I really shied away from trying to define it super clearly. I think I have this passage at the beginning of the book that it's like the pathless path is basically a shift away from the default. It's a shift away from not knowing what you're doing as a problem to be solved toward an embrace of uncomfort, discomfort, and uncertainty. And it's sort of a personal journey of shifting away from operating around scarcity towards operating from a sense of abundance, having faith that things might be okay. And on a path like yours, this is a necessary condition. You have no idea what comes next, because nobody has been on the Lenny path before.

**中文翻译:**
我其实刻意避免给它一个超级清晰的定义。我在书的开头有一段话，大意是：无径之路本质上是从“默认”状态的转变。它不再把“不知道自己在做什么”看作一个需要解决的问题，而是转向拥抱不适感和不确定性。这是一种个人旅程，从基于“匮乏感”运作转向基于“丰盈感”运作，相信事情可能会变好。在像你走的这条路上，这是一个必要条件。你完全不知道下一步会发生什么，因为以前没有人走过“Lenny 路径”。

---

### [00:10:57] Lenny

**English:**
True.

**中文翻译:**
确实。

---

### [00:10:59] Paul Millerd

**English:**
Right? And a lot of us are in this situation. Now if you're an accountant at an accounting firm in your early twenties, maybe there is a track, and you can sort of plan it, and it's pretty legible. But even still, I would argue that developing a relationship with uncertainty, not knowing what's happening, experimenting a little more, it's all of these things in one. And it's sort of my attempt to come up with a better narrative around work. And it's been pretty cool, because a lot of people are embracing this and now using the term like, "I'm on my pathless path." And it allows people to sort of name it and gives them comfort. I've had people email me that have been on a path for seven years, and they're like, "This is the first time I actually felt okay about my path," because a lot of what my book is, is an exploration of, why does it feel so weird to do your own thing? Why does it actually feel shameful to leave a full-time job? Which is an aberration in the history of the world.

**中文翻译:**
对吧？我们很多人都处于这种境地。如果你是一个二十出头的会计师事务所会计，也许有一条轨道，你可以规划它，它非常清晰。但即便如此，我仍认为，与不确定性建立关系、接受“不知道会发生什么”、多做实验，这些都是无径之路的一部分。这是我试图为工作建立一种更好的叙事。这很酷，因为很多人正在拥抱这一点，并开始使用这个词，比如“我正在我的无径之路上”。这让人们能够命名这种状态，并给他们带来安慰。有人给我发邮件说，他们已经走在自己的路上七年了，读了书后说：“这是我第一次对自己的路径感到释怀。”因为我书中的很多内容都在探索：为什么做自己的事情会感觉如此奇怪？为什么离开一份全职工作实际上会让人感到羞耻？而全职工作在世界历史上其实是一种反常现象。

---

### [00:12:06] Lenny

**English:**
I imagine a big question everyone's mind right now is, "This sounds amazing. I would love to just do the work I love and break out of this path. How do I do that?" And I want to talk about that. But before we do that, what are some examples of pathless paths people have ended up doing? Something just to make it a little more real of, here's what people have ended up doing with their life.

**中文翻译:**
我想现在大家脑子里最大的问题是：“这听起来太棒了。我也想只做我喜欢的工作，跳出这条路径。我该怎么做？”我想聊聊这个。但在那之前，有哪些人们最终走出的“无径之路”的例子？能不能举些例子让它更真实一点，看看人们最终是如何安排自己的生活的？

---

### [00:12:29] Paul Millerd

**English:**
So I think it ranges from a short sabbatical. And to someone like you or me who are sort of on this path and committed to this creator path, and things like that, there's a huge component of their creator economy. Not the creator economy from a VC perspective of all these startups that are going to save creators, but creators that are actually betting on themselves, finding some deeper satisfaction, a better relationship with work and committing to it. But it also encompasses people that are independent freelancers, that have a stable path, more predictable income than creator economy stuff. And it also includes people that are jumping from job to job. I also have examples of people that are older. I talk to a lot of people in their fifties. They've solved their financial problems, but they've lost that sense of aliveness. And they're looking to re-inject that, and they need maps of how to approach that, how to think about that, what are the models, things like that. So yeah, it's a pretty big umbrella. It's a nice way to claim everyone's path, but I think the shared ethic is really a sense of possibility, and opportunity, and optimism.

**中文翻译:**
我认为范围很广，从短期的休假（Sabbatical），到像你我这样致力于创作者路径的人。这里有很大一部分属于创作者经济——不是风投视角下那些声称要“拯救创作者”的初创公司，而是那些真正押注于自己、寻找更深层满足感、建立更好的工作关系并致力于此的创作者。它也包括独立自由职业者，他们有一条稳定的路径，比创作者经济有更可预测的收入。它还包括那些在不同工作之间跳跃的人。我也有一些年长者的例子。我经常和五十多岁的人聊天，他们已经解决了财务问题，但失去了那种“鲜活感”。他们希望重新注入这种感觉，他们需要地图来指导如何接近、如何思考、有哪些模式等等。所以，这是一个很大的范畴。这是一种涵盖每个人路径的好方法，但我认为共同的价值观是可能性、机遇和乐观精神。

---

### [00:13:54] Lenny

**English:**
So just to kind of list out some of these end, and I think what's interesting is there's no end to this. It's an endless path to continue discovering. There's actually this quote that I wrote down here that I'll read that I think is a really nice way of thinking about this pathless path. "The goal is not to find a job, make money, build a business, or achieve any other metric. It's to actively and consciously search for the work that you want to keep doing."

**中文翻译:**
所以，列举这些终点……我觉得有趣的是，这并没有终点。这是一条不断发现的无尽之路。我在这里记下了一段话，我想读一下，我认为这是思考无径之路的一种非常好的方式：“目标不是找一份工作、赚钱、建立事业或实现任何其他指标。而是积极、自觉地寻找那份你想要一直做下去的工作。”

---

### [00:14:15] Paul Millerd

**English:**
The big shift there, the big shift for me actually, when I left my job, I wanted to run away. I wanted to escape work. I wanted to not work. And I more or less accomplished that. I basically lowered my cost of living in Asia to about 1,000 per month. But then I started developing this relationship with writing, and creating, and all these things I actually really enjoyed. And I wasn't doing them to be famous or grow a following. I just really liked them and I liked doing it in public, because I was meeting others that were engaging on these ideas. The big aha for me was, "Oh, you can design around liking work." The hidden assumption I had around work for the first 32, 33 years of my life was work sucks. You have to figure out how to tolerate it.

**中文翻译:**
那里有一个巨大的转变。对我来说，当我辞职时，我想的是逃跑。我想逃避工作，我想不工作。我或多或少实现了这一点，我基本上把在亚洲的生活成本降到了每月 1000 美元左右。但随后我开始与写作、创作以及所有我真正喜欢的事情建立联系。我做这些不是为了出名或涨粉，我只是真的很喜欢它们，而且我喜欢公开去做，因为我能遇到其他对这些想法感兴趣的人。对我来说，最大的顿悟是：“噢，你可以围绕‘喜欢工作’来设计生活。”在我生命的前 32、33 年里，我对工作的隐含假设是：工作很烂，你必须想办法忍受它。

---

### [00:15:13] Paul Millerd

**English:**
And within that frame, try to do your best to enjoy some of it. But ultimately, it's a trade-off of your time. You have to suffer through it. A lot of it is going to suck, and you have to put up with that. Now, I think I'm very protective of what I do and don't do. This is why it was very easy for me to say no to Penguin. I didn't want to write a second book for them. I want to write a second book the way I did, which was super fun process. Writing a book was one of the most fun things I've ever done in my life. And so I sort of think about protecting them. And a lot of people are looking for meaning through work in a job shaped container. And I think that's just really hard to find. You can find it for short bursts, but maybe after seven or 10 years, it's just not doing it anymore.

**中文翻译:**
在那个框架下，尽力去享受其中的一小部分。但归根结底，那是你时间的交易。你必须熬过去。很多事情会很糟糕，你必须忍受。现在，我非常保护我做和不做的事情。这就是为什么我可以很轻易地拒绝企鹅出版社（Penguin）。我不想为他们写第二本书。我想按照我写第一本书的方式写第二本，那是一个超级有趣的过程。写书是我这辈子做过的最有趣的事情之一。所以我想要保护这种乐趣。很多人试图在“工作”这个形状的容器里寻找意义，我认为那真的很难找到。你可能会有短暂的获得感，但也许过了 7 年或 10 年，它就不再起作用了。

---

### [00:16:05] Lenny

**English:**
So let's talk about how to go about finding your pathless path and create the space and opportunity to do this. Because again, a lot of people listening are like, "I have bills to pay. I got kids to take care of. I got a home, I got a mortgage. I can't just go on a sabbatical, explore, travel, and find here I'm going to start a newsletter." So what have you found are ways to enable this exploration without risking everything?

**中文翻译:**
那我们来谈谈如何寻找你的无径之路，并创造空间和机会去做这件事。因为同样，很多听众会想：“我有账单要付，有孩子要照顾，有房子，有抵押贷款。我不能直接去休个假、探索、旅行，然后突然决定开始写 Newsletter。”那么，你发现了哪些方法可以在不冒所有风险的情况下开启这种探索？

---

### [00:16:31] Paul Millerd

**English:**
A three month sabbatical is much more attainable than people think. Companies are desperate to keep people and are much more open to things like this these days. And the way I frame it is if you're assuming you're going to work continuously in adulthood, that's about 500 months. Try to find three months of that where you can create space and reconnect with yourself, explore things, just see what emerges, see how you feel. I think this is so vital for people in their thirties or forties who've worked for 10 years just to reconnect with themselves.

**中文翻译:**
三个月的休假（Sabbatical）比人们想象的要容易实现得多。现在的公司为了留住人才，对这类事情的开放程度要高得多。我的逻辑是：如果你假设在成年期会持续工作，那大约是 500 个月。试着从中找出 3 个月，创造空间并重新与自己建立联系，探索事物，看看会浮现什么，看看你的感受。我认为这对于三十多岁或四十多岁、已经工作了 10 年的人来说至关重要，仅仅是为了重新找回自我。

---

### [00:17:11] Paul Millerd

**English:**
And three months in a total of 500 months, people accomplish much more impressive things than that, like saving for their dream home. That is such a powerful thing people aim for that they make it happen. Even people that don't have a ton are able to make that happen, because it is such an important priority. And for me, I think creating this space was more important than owning a house, getting married. It was the most important thing for me. And I actually quoted your piece. I pulled up the quote. It said, "Lenny Rachitsky took a sabbatical after a long career in product management, thought he would return to work. But by the end of the break, it was crystal clear to me that I was ready to move on to a new adventure." And then you said several weeks into your sabbatical, you stopped checking your email. "My heart was no longer in the work. I didn't yet know what I wanted to do next, but I knew it was time to shake things up." And you probably weren't in that state when you were still at Airbnb.

**中文翻译:**
在总共 500 个月中抽出 3 个月，人们其实能完成比这更了不起的事，比如攒钱买梦想中的房子。那是人们为之奋斗并最终实现的强大目标。即使是积蓄不多的人也能做到，因为那是极高的优先级。对我来说，创造这个空间比买房、结婚更重要。这是我生命中最重要的事情。我实际上引用了你写的一段话。我把它找出来了，上面写着：“Lenny Rachitsky 在长期的产品管理职业生涯后休了假，原以为会重返工作岗位。但到假期结束时，我非常清楚地意识到，我已经准备好开启新的冒险了。”然后你说，在休假几周后，你停止了查看邮件。“我的心不再在工作上了。我当时还不知道下一步想做什么，但我知道是时候改变一下了。”当你还在 Airbnb 时，你可能还没处于那种状态。

---

### [00:18:16] Lenny

**English:**
That's right. I was super into the work. And I think the way I thought about it is the Kool-Aid kind of exited my bloodstream, and taking that time off kind of created separation. And then I started thinking, "Man, is this really what I want to be doing?" And that visceral feeling of getting excited about the work disappeared, which was crazy and scary.

**中文翻译:**
没错。我当时非常投入工作。我想我的感觉是，那种“迷魂药”（Kool-Aid，指公司洗脑文化）从我的血液中排出了，休假创造了一种隔离感。然后我开始想：“天哪，这真的是我想做的事吗？”那种对工作感到兴奋的直觉消失了，这既疯狂又可怕。

---

### [00:18:35] Paul Millerd

**English:**
Yeah. And so you have smart listeners, and smart people are great at excuses. So they'll say, "I can't do it because of this." I always think these things are much more possible if they really are the main priority. So what I tell people is fine, don't take a sabbatical. Take an afternoon. Take three hours during a workday. Has to be during a workday. Block off your schedule, sneak out. People can pull this off. Go for a walk without a destination, or do something from your childhood that you used to do all the time. Did you use to play basketball? Did you use to paint? Did you use to play an instrument? Do one of those two things, even better if you do both.

**中文翻译:**
是的。你的听众都很聪明，而聪明人最擅长找借口。他们会说：“因为这个那个，我做不到。”我始终认为，如果某件事真的是首要任务，它就更有可能实现。所以我告诉人们：好吧，不休长假也行。找个下午。在工作日找三个小时。必须是工作日。封锁日程，溜出去。人们能做到的。漫无目的地散步，或者做一件你小时候经常做的事。你以前打篮球吗？画画吗？弹乐器吗？做这两件事中的一件，如果两件都做就更好。

---

### [00:19:19] Paul Millerd

**English:**
And just pay attention. It's a sort of form of work mindfulness. What is emerging? Do you feel bad for sneaking out of work? Where does that bad feeling come from? What does that mean about your definition of work and what work means to you? A lot of people have never really thought about, why do you work? People say money. Okay, that's fine. But what else? Why do you work? Are you trying to be a good person? Do you see a good person as somebody that works every day? Maybe. These are a lot of scripts people grow up with. Or people that don't have a full-time job, are they bad people?

**中文翻译:**
然后只需留意。这是一种“工作正念”。有什么感觉在浮现？你会因为翘班而感到糟糕吗？这种糟糕的感觉从何而来？这反映了你对工作的定义是什么？工作对你意味着什么？很多人从未真正思考过：你为什么要工作？人们说为了钱。行，没问题。但还有什么？你为什么要工作？你是想做一个好人吗？你认为好人就是每天工作的人吗？也许吧。这些都是人们成长过程中被灌输的剧本。那么，没有全职工作的人就是坏人吗？

---

### [00:20:04] Paul Millerd

**English:**
And so you're really just creating this space to get in touch with, how do I actually feel about work? How do I get to know myself more? Are there things that I've lost touch with that really bring me alive?

**中文翻译:**
所以你实际上只是在创造这个空间去接触内心：我到底对工作有什么感觉？我如何能更了解自己？是否有一些我已经生疏、但能让我真正焕发生机的事情？

---

### [00:20:19] Lenny

**English:**
It's interesting how much of what you described, we didn't know each other before we met for this podcast episode, but so much of what you say is exactly what happened in my path. I took three months off exactly. I took a sabbatical. I started poking around, exploring, doing a little writing. And basically led to what I do now, which is a crazy thing I never imagined in my wildest dreams. And so clearly this works.

**中文翻译:**
很有趣，你描述的很多内容——虽然我们在录这期播客前并不认识——但我走过的路几乎一模一样。我正好休息了三个月。我休了假，开始四处看看、探索、写点东西。这基本上导向了我现在做的事，这在我最疯狂的梦里都没想过。所以显然，这套方法是行得通的。

---

### [00:20:43] Paul Millerd

**English:**
Yeah, and I think people will say, "You can do that because you worked at Airbnb," or, "Oh, you can do that because you"... I've talked to hundreds of people. So what I did before the pandemic for years was I opened up my calendar every Wednesday and I said, anyone that wants to talk to me about work can talk to me about work. So at this point, I've probably talked to 500 plus people about their relationship to work. And the reason that's not surprising about what happened to you is it happens to almost everyone. The sabbatical almost has a 99.9% approval rating.

**中文翻译:**
是的，我想人们会说：“你能这么做是因为你在 Airbnb 工作过，”或者“你能这么做是因为你……”但我已经和几百人聊过了。在疫情之前的几年里，我每周三都会开放我的日历，我说：任何想和我聊聊工作的人都可以来聊。到目前为止，我可能已经和 500 多人聊过他们与工作的关系。之所以对发生在你身上的事不感到惊讶，是因为这几乎发生在每个人身上。休假（Sabbatical）的好评率几乎是 99.9%。

---

### [00:21:22] Paul Millerd

**English:**
I talked to one person. She was like, "I took a sabbatical, I stayed at home. My husband was still working for two months. I couldn't wait to go back to work." I was like, "Cool. You're the first person I met that didn't get anything out of a sabbatical."

**中文翻译:**
我确实遇到过一个人，她说：“我休了假，待在家里。我丈夫还在工作，两个月后，我迫不及待地想回去上班。”我说：“酷，你是我见过的第一个没从休假中获得任何东西的人。”

---

### [00:21:37] Lenny

**English:**
That's hilarious. I haven't met that person. So your advice is try to take a sabbatical, and you're also encouraging people to, you can actually probably do this at some point, but maybe it takes a bit of time to set people up for the fact that you're going to do this. Maybe you need to work at the company for a while, but in your thirties or forties, it sounds like try to find time to take three months. And is three months important? Is that what you find, that large of a block of time?

**中文翻译:**
太好笑了。我还没见过那样的人。所以你的建议是尝试休个长假，你也鼓励人们，你可能在某个时间点能做到这一点，但可能需要一点时间让周围的人适应你要这么做的事实。也许你需要在公司工作一段时间，但在三十多岁或四十多岁时，听起来应该试着找时间休三个月。三个月这个时长很重要吗？你发现必须是这么大的一块时间吗？

---

### [00:22:03] Paul Millerd

**English:**
I've found it takes six to eight weeks just to unwind.

**中文翻译:**
我发现仅仅是“放松下来”（Unwind）就需要六到八周。

---

### [00:22:09] Lenny

**English:**
Yeah, that's exactly what I found.

**中文翻译:**
是的，这正是我发现的。

---

### [00:22:11] Paul Millerd

**English:**
I think for me, there was the initial unwinding after six to eight weeks, and then a deeper unwinding after probably two to three years, where you start to trust yourself a little more, if you stay on the uncertain path that is. But yeah.

**中文翻译:**
对我来说，六到八周后是初步的放松，然后在大约两到三年后会有更深层次的放松——前提是你坚持走在不确定的道路上，那时你会开始更加信任自己。但没错。

---

### [00:22:28] Lenny

**English:**
If founders are listening to this and feeling like, "Shit, why would I give people sabbaticals? They're going to leave, start their own companies, find some other catalyst path. I want them on my default path." Is there anything you could say to a founder thinking about offering sabbatical?

**中文翻译:**
如果有创始人正在听这段，觉得：“该死，我为什么要给员工休假？他们会离开，去开自己的公司，寻找其他的‘催化路径’。我想要他们留在我的默认路径上。”对于考虑提供休假的创始人，你有什么想说的吗？

---

### [00:22:43] Paul Millerd

**English:**
I would say if that's their reaction, it sounds like they have an insecurity around work. So I would interrogate that first. What is the implicit story they have about how much people are supposed to work and such? Yeah, I don't know if it's a good employer strategy. I think a decent amount of people would leave. I know Intel, I have friends that have done the sabbatical at Intel. You get six weeks after seven years. Maybe after seven years, they're a bit burnt out that they don't have enough time in those six weeks to unwind. But I think getting creative, especially now that remote work is so much more common about these opportunities, to let people become the people they want to be. People leave companies because they don't see a path to be the person they want to be.

**中文翻译:**
我会说，如果那是他们的反应，听起来他们对工作本身缺乏安全感。所以我建议先审视一下：他们关于“人们应该工作多少”之类的隐含故事是什么？是的，我不知道这是否是一个好的雇主策略。我认为确实会有相当一部分人离开。我知道英特尔（Intel），我有朋友在英特尔休过假，工作七年后可以休六周。也许工作七年后，他们已经精疲力竭了，六周时间根本不够放松。但我认为可以发挥创意，尤其是现在远程办公如此普遍，可以利用这些机会让员工成为他们想成为的人。人们离开公司是因为他们看不到在那儿成为理想自我的路径。

---

### [00:23:40] Lenny

**English:**
Okay, so you take a sabbatical, or you take an afternoon, or you take a walk. You talked about be mindful for what comes up. What are you feeling about work? What is a thing you want to do? Do you want to go play basketball? Do you want to go draw? What else do you encourage people to do, to try to discover a potential new path?

**中文翻译:**
好，假设你休了假，或者找了个下午去散步。你提到要留意浮现的感觉。你对工作有什么感觉？你想做什么？你想去打篮球吗？想去画画吗？你还鼓励人们做些什么，来尝试发现潜在的新路径？

---

### [00:24:00] Paul Millerd

**English:**
I think meeting others. So in exercise, I'll have people do if they're curious about this... And for the most part, I don't want to convert people that like what they're doing and like traditional jobs. But a lot of people are curious, and I say have a path expert conversation. Reach out to somebody, sort of like a podcast, that's ahead of you on a similar path, and just send them a message and say, really thoughtful message. Say, "Hey, you're on a path a few years ahead of me. I'm really curious about this. I don't have people in my life that have done things like this. Can I just pick your brain? If we can't jump on a call, can I send you a list of questions?"

**中文翻译:**
我认为是结识他人。如果人们对此感到好奇，我会让他们做一个练习……大部分情况下，我不想转化那些喜欢现状、喜欢传统工作的人。但很多人很好奇，我会建议他们进行一次“路径专家对话”。找一个在类似路径上领先你几年的人，就像听播客一样，给他们发一条非常用心的信息。说：“嘿，你走的这条路领先我几年。我对此非常好奇。我的生活中没有做过这类事情的人。我能向你请教一下吗？如果我们不能通话，我能给你发一份问题清单吗？”

---

### [00:24:42] Paul Millerd

**English:**
Most people will agree to that, especially the latter if they're a writer, because writing just enables them to come up with new ideas. So I'll always agree to do the written questions. I don't do the open calendar anymore now that I have a daughter. She wins my time over random stranger's booking. But if people want to send me questions, I'll always answer them in text form.

**中文翻译:**
大多数人都会同意，尤其是后者，如果对方是作家的话，因为写作能帮助他们产生新想法。所以我总是愿意回答书面问题。自从有了女儿，我不再开放日历了。比起陌生人的预约，她更能赢得我的时间。但如果人们想给我发问题，我总是会以文字形式回答。

---

### [00:25:07] Lenny

**English:**
And again, this path doesn't have to lead to creator, artist, writer person. It could lead to starting a new business. It could probably lead to a new career. It could shift in careers. Is there anything else, again, of just where this could lead to people so they're like, "Oh, wow, that's interesting."

**中文翻译:**
再次强调，这条路不一定非要导向创作者、艺术家或作家。它可能导向创办新业务，可能导向一段新职业，或者职业转型。还有什么其他可能的去向，能让人们觉得“哇，那很有趣”？

---

### [00:25:23] Paul Millerd

**English:**
Somebody sent me an article today about this guy. I think he was a performing artist. He became a therapist. I forget his name. But I think just the possibilities for reinventing yourself and taking different paths, working online, working flexibly, it's way more possible than 25 years ago. It's also going to continue to be more possible. All the tools and technology to enable these kinds of lives are just getting better and easier. And especially this week, ChatGPT just released their new GPT. I was playing with that today and I'm like, "Oh my gosh."

**中文翻译:**
今天有人给我发了一篇关于一个人的文章。我想他以前是个表演艺术家，后来成了心理治疗师。我忘了他的名字。但我觉得，重新定义自己、走不同道路、在线工作、灵活工作的可能性，比 25 年前要大得多。而且这种可能性还会继续增加。所有支持这类生活的工具和技术都在变得更好、更简单。尤其是这周，ChatGPT 刚刚发布了他们的新 GPT，我今天试了一下，心想：“我的天呐。”

---

### [00:26:04] Lenny (Sponsor: Wix Studio)

**English:**
This episode is brought to you by Wix Studio. Your agency has just landed a dream client, and you already have big ideas for the website, but do you have the tools to bring your ambitious vision to life? Let me tell you about Wix Studio, the new platform that lets agencies deliver exceptional client sites with maximum efficiency. How? First, let's talk about advanced design capabilities. With Wix Studio, you can build unique layouts with a revolutionary grid experience, and watches elements scale proportionally by default. No-code animations at sparks of delight, while adding custom CSS gives total design control. Bring ambitious client projects to life with any industry, with a fully integrated suite of business solutions. From e-commerce to events, bookings, and more. And extend the capabilities even further with hundreds of APIs and integrations. You know what else? The workflows just make sense. There's the built-in AI tools, the on canvas collaborating, a centralized workspace, the reuse of assets across sites, the seamless client handover, and that's not all. Find out more at wix.com/studio.

**中文翻译:**
本期节目由 Wix Studio 赞助。你的代理机构刚刚签下了一个梦想客户，你对网站已经有了宏大的构思，但你是否有工具将这一雄心勃勃的愿景变为现实？让我向你介绍 Wix Studio，这是一个让代理机构能以最高效率交付卓越客户网站的新平台。怎么做到的？首先，让我们谈谈先进的设计能力。通过 Wix Studio，你可以利用革命性的网格体验构建独特的布局，并观察元素默认按比例缩放。无代码动画增添惊喜，而添加自定义 CSS 则提供完全的设计控制。通过全套集成的业务解决方案，为任何行业的雄心勃勃的客户项目注入活力。从电子商务到活动、预订等。并通过数百个 API 和集成进一步扩展功能。还有什么？工作流非常合理。内置 AI 工具、画布协作、集中式工作空间、跨站点资产复用、无缝客户移交，这还不是全部。在 wix.com/studio 了解更多。

---

### [00:27:08] Lenny

**English:**
I think when people might hear some of these professions like, "Maybe I'll become a therapist, maybe I'll become an online writer person. Maybe I'll start a business." It may feel like that assumes you'll make less money doing these things. But in my case, and I'm curious if it's in your case, I make significantly more doing what I do now. I try not to talk about the income of this stuff, but it's significantly more than I made at Airbnb as a very senior product leader. And I feel like that often happens. You discover a way to do something you love and also make a lot more money.

**中文翻译:**
我想当人们听到这些职业，比如“也许我会成为治疗师，也许我会成为在线作家，也许我会创业”时，可能会觉得这意味着赚的钱会变少。但在我的案例中——我也很好奇你的情况——我现在赚的比以前多得多。我尽量不谈论这些收入，但它确实比我在 Airbnb 担任资深产品负责人时赚得多得多。我觉得这种情况经常发生：你发现了一种做自己喜欢的事并赚更多钱的方法。

---

### [00:27:39] Paul Millerd

**English:**
I think it's easier to make money in a sustainable, long-term way doing stuff you actually like doing. That sounds so simple, but it actually would've been really hard for me to stay on my previous path. Now, in my case, it was not until my fifth year that I came close to the salary I left. For the first three years, I really optimized for exploration, creativity, just getting to know myself again. I made 50 grand the first year, because I was freelancing. Then I made 30 grand, 24 grand, and then 30 grand. So I was really optimizing for getting to know myself. I dramatically lowered my cost of living, and that is one path.

**中文翻译:**
我认为，做你真正喜欢的事情，更容易以可持续、长期的方式赚钱。这听起来很简单，但对我来说，留在之前的路径上实际上会非常困难。就我而言，直到第五年，我的收入才接近辞职前的水平。在前三年，我真正优化的是探索、创造力，以及重新认识自己。第一年我赚了 5 万美元，因为我在做自由职业。然后是 3 万、2.4 万，接着又是 3 万。所以我当时真的是在为了解自己而优化。我大幅降低了生活成本，那是其中一种路径。

---

### [00:28:26] Paul Millerd

**English:**
But this year, I'll make more than I ever made. And that is mind-blowing to me, because every single day of this year has been absolutely delightful. I've spent abundant time with my wife and my daughter. And it's so crazy. Now, if I had stayed in my previous path, I'd be making a lot more than I make now. But that path was not viable for me for becoming... I'd be so frustrated right now if I had to go back to work. An eight-month-old, I know you have a four-month-old. Wait till eight months old. They're so fun to hang out with.

**中文翻译:**
但今年，我赚的比以往任何时候都多。这让我感到不可思议，因为今年的每一天都绝对令人愉快。我花了大量时间陪伴妻子和女儿。这太疯狂了。现在，如果我留在之前的路径上，我赚的可能比现在多得多。但那条路对我来说是不可持续的……如果我现在必须回去上班，我会非常沮丧。我女儿八个月大，我知道你有一个四个月大的孩子。等到八个月大时，和他们待在一起太有趣了。

---

### [00:29:12] Lenny

**English:**
I can't wait. You talked about this lower spend, lower expense life. What other tips and tricks do you have for people to create this space where they can continue living and paying the rent, while exploring, and wandering, and exploring these things? Is it cut down on expenses? Is there anything else that one can do?

**中文翻译:**
我等不及了。你谈到了这种低支出、低成本的生活。为了创造一个既能继续生活、付房租，又能探索、徘徊的空间，你还有什么其他的建议或窍门？是削减开支吗？还有什么别的方法吗？

---

### [00:29:33] Paul Millerd

**English:**
I've talked to so many people at this point. I've seen all sorts of things. I've seen people move abroad. I've seen families with kids and a mortgage sell their house and decide to live in an RV. I've seen people dip into their retirement. I've seen people apply for grants and get those. I've seen people apply for loans. A big move that a lot of people do is turn their current job into a contract job, which a lot of employers are a lot more open than people would think. Because a contractor's very easy to fire. You can fire a contractor in a day. So if the company's struggling, boom, you're gone, right?

**中文翻译:**
到目前为止，我已经和很多人聊过了。我见过各种各样的情况。我见过有人搬到国外。我见过有孩子和房贷的家庭卖掉房子，决定住在房车里。我见过有人动用退休金。我见过有人申请并获得了资助金。我见过有人申请贷款。很多人采取的一个大动作是将目前的工作转为合同工（Contract job），很多雇主对此的开放程度超乎想象。因为合同工很容易解雇，你可以在一天内解雇一个合同工。所以如果公司遇到困难，砰，你就走了，对吧？

---

### [00:30:14] Paul Millerd

**English:**
And so there is more risk, but if you're known in the company, it can actually be a somewhat stable path to create more space in your life. You say, "Hey, I want to work three days a week. I want to be a contractor. Here's exactly what I want to do. Are you open to this?" And as soon as you're a contractor, they can't tell you where to work. You can develop a relationship and they can ask you to work in a certain place, but they don't have control over where you work.

**中文翻译:**
所以风险更大，但如果你在公司里有知名度，这实际上可以成为一条相对稳定的路径，为你的生活创造更多空间。你可以说：“嘿，我想每周工作三天。我想做合同工。这是我具体想做的事情。你们能接受吗？”一旦你成了合同工，他们就不能规定你在哪里工作。你可以建立一种合作关系，他们可以请求你在某个地方工作，但他们对你的工作地点没有控制权。

---

### [00:30:42] Lenny

**English:**
A trick that I found really useful actually for helping me feel comfortable about taking time off, I ended up taking six months off, and then it ended up being a year off because I kept trying to figure out what is the thing I wanted to do. The way that I felt good about that is I set a budget of, "Here's the runway that I'm going to give myself. Here's how much it's going to cost to do this for six months. Here's the runway I'm going to give myself. I'm just going to burn through this money, just with the bet that it'll lead to something interesting." And that made me and my wife also just feel like, okay, we were going to lose all that money probably, but the bet is it's going to lead to something really great.

**中文翻译:**
我发现一个非常有用的窍门，帮助我在休假时感到安心。我最终休了六个月，后来变成了一年，因为我一直在摸索自己到底想做什么。让我感到踏实的方法是设定一个预算：“这是我给自己设定的跑道（Runway）。做这件事六个月要花多少钱。我就打算烧掉这笔钱，赌它会导向一些有趣的事情。”这让我和妻子觉得，好吧，我们可能会损失掉那笔钱，但赌注是它会导向一些非常棒的事情。

---

### [00:31:15] Paul Millerd

**English:**
Yeah, I love this. I think this is something I've been thinking about a lot lately, and I've actually been trying to write something around this, which is that naming what you're spending money on or coming up with agreements like that, you're sort of saying, "This is money I'm investing in my life MBA." Because if somebody says, "I'm going to Stanford Business School," generally you'll receive positive praise. "Oh, that's awesome." But what they're really doing is not working for two years and spending 150 to $200,000, and not earning a salary.

**中文翻译:**
是的，我喜欢这个。这是我最近一直在思考的事情，我实际上正试图围绕这个写点东西，那就是：为你花钱的项目命名，或者达成类似的协议。你实际上是在说：“这是我投资于‘人生 MBA’的钱。”因为如果有人说“我要去斯坦福商学院”，通常会得到正面的赞扬：“噢，那太棒了。”但他们真正做的是两年不工作，花费 15 到 20 万美元，而且没有工资收入。

---

### [00:31:55] Paul Millerd

**English:**
And then to me, it was really interesting to look back at my path. Now, the first three years of my path, I broke even. But compared to being in business school, people thought business school was way better of a path for me. People were judgmental in my path, critical of my path, insulted me, projected their insecurities on me. "How could you do this? This is so crazy. What's your plan?" So coming up with these reframes is super powerful. One powerful one that worked for me was consider it a gift from your former self. So on the consulting path, I did like it for a while, but at the end I didn't like it. I was sort of just grinding through, going through the motions. I was good at it, but I really didn't want to be doing it if I had choice. And so I earned a decent income doing it. So would I gift that to my future self to be happier? Yeah. So now that I'm in the present, receive that gift and be like, "Thank you former self for working that job."

**中文翻译:**
对我来说，回顾我的路径非常有趣。在我路径的前三年，我收支平衡。但与读商学院相比，人们认为商学院对我来说是好得多的路径。人们对我的路径评头论足、充满批判、甚至侮辱我，把他们的不安全感投射到我身上：“你怎么能这么做？这太疯狂了。你的计划是什么？”所以，进行这种“重新框架”（Reframe）是非常强大的。对我有效的一个强大框架是：把它看作是“过去的自己”送给你的礼物。在咨询行业的路上，我确实喜欢过一段时间，但最后我不喜欢了。我只是在硬撑，机械地工作。我很擅长，但如果有选择，我真的不想做。我通过那份工作赚了不错的收入。那么，我愿意把那笔钱送给“未来的自己”让他更快乐吗？愿意。所以现在我处于当下，接受那份礼物并说：“谢谢过去的自己做了那份工作。”

---

### [00:33:08] Lenny

**English:**
It's interesting. I could also flip it from the other way of your future self is returning to, "Hey, here's some money to spend to help become who I've become."

**中文翻译:**
很有趣。我也可以从另一个角度来看：你的“未来自我”回来对你说：“嘿，这是给你花的钱，用来帮助你成为现在的我。”

---

### [00:33:17] Paul Millerd

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:33:19] Lenny

**English:**
So I imagine not everyone ends up on a beautiful, amazing new life. They go down this route, they spend a bunch of money, and then they're like, "God damn, I don't have anything to show for it. I've spent all this cash." Imagine there are stories of that. Is there anything you could share around those stories and how to maybe either avoid them or be okay with them?

**中文翻译:**
所以我猜并不是每个人最终都能拥有美好、惊艳的新生活。他们走上这条路，花了一大笔钱，然后觉得：“该死，我什么都没做出来，钱全花光了。”我想肯定有这样的故事。关于这些故事，你有什么可以分享的吗？以及如何避免这种情况，或者如何坦然面对？

---

### [00:33:38] Paul Millerd

**English:**
I think there are surprisingly few stories of that. I think that is people's fear of what might happen. What I've seen in reality, as soon as people are without an income or without a job, they spur into action. People, we're far more creative than we give ourselves credit for. Having a child, we have no idea what we're doing when they come out. But it makes perfect sense that you're going to figure everything out, because you have to. You have no choice. And so the ingenuity and creativity of people as soon as they bet on themselves and go off into the wilderness, is far more than people expect.

**中文翻译:**
我认为这类故事少得惊人。我觉得那只是人们对“可能发生的事”的恐惧。我在现实中看到的是，一旦人们没有了收入或工作，他们就会立刻行动起来。人类的创造力远比我们想象的要强大。就像生孩子，孩子出生时我们完全不知道该怎么办。但很自然地，你会搞定一切，因为你必须这样做，你别无选择。所以，一旦人们开始押注于自己并走向荒野，他们表现出的聪明才智和创造力远超预期。

---

### [00:34:24] Paul Millerd

**English:**
And it also has to do with regrets. People do not regret the things they do. They regret the things they didn't do. And the reason for this is if you've made a mistake, you can actually take action to correct it. But if you didn't do the thing that you're regretting, there's nothing you can do except do the thing.

**中文翻译:**
这也与遗憾有关。人们不会后悔自己做过的事，只会后悔没做过的事。原因在于，如果你犯了错，你实际上可以采取行动去纠正它。但如果你因为没做某事而后悔，除了去做那件事，你无能为力。

---

### [00:34:46] Lenny

**English:**
And it reminds me of a quote that you have in your book that I have here. The secret to doing good research, and I think it's related to this of finding a new path, a pathless path, is always to be a little underemployed. You waste years by not being able to waste hours.

**中文翻译:**
这让我想起你书里的一句话，我这里记着。做深入研究的秘诀——我认为这与寻找新路径、无径之路有关——就是始终保持一点“就业不足”（Underemployed）的状态。如果你不能浪费几个小时，你就会浪费掉好几年。

---

### [00:35:00] Paul Millerd

**English:**
Yeah. And I wonder if you've found this too. Sometimes, the best way for me to write is to go for a walk, or to take a couple days off and just sort of reset. Creative work can't be forced a lot of time. And increasingly, a lot of work is creative work. Your work at Airbnb was ultimately creative work. You're creating new products and offerings, in a whole new conception of an industry. You're making stuff up. A lot of times, I think people get fried in these companies because they're not actually given the schedules and the support systems around what actually enables creativity.

**中文翻译:**
是的。我想知道你是否也发现了这一点。有时，对我来说最好的写作方式是去散步，或者休息几天重新调整。很多时候，创造性工作是强求不来的。而且，越来越多的工作变成了创造性工作。你在 Airbnb 的工作归根结底也是创造性工作。你在一个全新的行业概念中创造新产品和新服务。你在“无中生有”。很多时候，我认为人们在这些公司里精疲力竭，是因为他们没有得到真正能激发创造力的日程安排和支持系统。

---

### [00:35:53] Lenny

**English:**
Yeah, absolutely. Although I find with writing also, there's the benefit of the opposite of, "I'm just going to sit here and write, and I'm not going to give myself a chance to go walk around. I'm just going to keep writing, even if it's terrible, because it'll maybe lead to something."

**中文翻译:**
是的，绝对如此。虽然我发现写作也有相反的好处，即：“我就坐在这儿写，不给自己去散步的机会。我就一直写，哪怕写得很烂，因为这可能会导向某些东西。”

---

### [00:36:07] Paul Millerd

**English:**
Yeah. And even that though, a lot of times, what ends up on the page surprises you. Right? So you do need a certain sense of openness to let that emerge.

**中文翻译:**
是的。即便如此，很多时候，最终呈现在纸上的内容也会让你感到惊讶，对吧？所以你确实需要某种开放的心态来让它浮现。

---

### [00:36:20] Lenny

**English:**
So kind of along the same lines, another important concept that you talk about in your book for finding this pathless path is just this idea that it's not ever like this all or nothing. I'm just going to leap into this new thing. It's kind of this, the way you put it is people quit jobs after years of awakening and safely testing changes, kind of eliminating risks along the way.

**中文翻译:**
沿着这个思路，你在书中提到的另一个寻找无径之路的重要概念是：这从来不是“全有或全无”的。不是说“我要直接跳进这件新事物里”。按照你的说法，人们是在经历了数年的觉醒和安全地测试改变、沿途消除风险之后，才辞掉工作的。

---

### [00:36:40] Paul Millerd

**English:**
So years before I left, and I'm curious if you had a similar experience, I was starting to read personal development books. I was reading Tim Ferriss. I was doing these small experiments like coaching on the side, helping people with their resumes, volunteering, helping people with careers. And so I was writing too. I was writing for fun on Quora with no goals. And all these things make perfect sense now. And even looking back further, I was always tinkering on the internet, and all these things fit my story perfectly now.

**中文翻译:**
在我离开前的几年——我也很好奇你是否有类似的经历——我开始读个人成长类的书。我在读 Tim Ferriss。我在做一些小实验，比如兼职做教练、帮人改简历、做志愿者、帮人规划职业。我也在写作，在 Quora 上漫无目的地写着玩。现在看来，所有这些事情都非常有意义。甚至再往前看，我一直在互联网上瞎折腾，所有这些现在都完美地契合了我的故事。

---

### [00:37:16] Paul Millerd

**English:**
But I didn't know why I was doing them at the time. But each one gave me the confidence to be like, "Okay, I don't love my day job, but all these random things I'm doing on the side, like writing an article and posting it on Medium and LinkedIn, and the people I'm meeting, this is really interesting and energizing. I'm going to pay attention to that energy. Something is there." And when I quit my job, I didn't really have a plan for how to deal with that, but I had experienced enough of this positive energy. I was like, "I want to chase that. I want to go after that."

**中文翻译:**
但我当时并不知道为什么要这么做。但每一件事都给了我信心，让我觉得：“好吧，我不喜欢我的日常工作，但我在业余时间做的这些乱七八糟的事，比如写文章发在 Medium 和 LinkedIn 上，还有我遇到的人，这些都非常有趣且充满活力。我要关注这种能量。那里一定有什么东西。”当我辞职时，我并没有一个真正的应对计划，但我已经体验到了足够的这种正能量。我想：“我要追随它，我要去追求它。”

---

### [00:37:53] Lenny

**English:**
That's exactly what I found. So I'll tell my story briefly on this. Some advice I got when I went on my sabbatical that ended up being incredibly powerful is essentially what you just said, which is when you're doing stuff during some period of time off, pay really close attention to what gives you energy after you do the thing. Say you have a call. Did that give you energy or did that sap you of energy? Do you feel more energized or you feel like, "I'm tired now"?

**中文翻译:**
这正是我发现的。我简短分享一下我的故事。我在休假时得到了一些非常有力的建议，本质上就是你刚才说的：当你休息一段时间做事情时，要密切关注做完那件事后什么给了你能量。比如你打了个电话，那是给了你能量，还是耗尽了你的能量？你是觉得更有活力了，还是觉得“我现在累了”？

---

### [00:38:19] Lenny

**English:**
So it's like after calls you make, after things you do with friends, after some kind of hobby you're trying to do, after you write some stuff, just pay really close attention to what energizes you, what saps you energy. And then my whole strategy was just do more of the things that energize me and do less of the things that de-energize me. So in my case, I thought I'd want to do some advising or consulting. I found after every advising call, I was de-energized. I was just like, "No, I do not enjoy this as much as I thought." But after writing and putting a piece out, I was like, "Wow, this is really cool." Even though writing's very hard and there's a lot of de-energized moments, broadly it's like, "Wow, this is cool. People seem to really value this." So I started doing that more. I thought I wanted to start a company, but that kept sucking me of energy as I was working on ideas. So that alone was really, really powerful. And it sounds like really simple advice, but it's really [inaudible 00:39:10].

**中文翻译:**
所以，在你打完电话、和朋友聚完、尝试某种爱好或写完东西后，仔细留意什么让你兴奋，什么让你疲惫。我整个策略就是：多做那些让我兴奋的事，少做那些让我疲惫的事。就我而言，我原以为我想做一些顾问或咨询工作。但我发现每次咨询电话后，我都精疲力竭。我觉得：“不，我并没有想象中那么喜欢这个。”但在写作并发布文章后，我觉得：“哇，这太酷了。”虽然写作很难，也有很多让人沮丧的时刻，但总体上我觉得：“哇，这很酷，人们似乎真的很看重这个。”所以我开始更多地做这件事。我曾以为我想开公司，但在构思想法的过程中，它不断消耗我的能量。所以，仅仅是这一点就非常非常强大。这听起来是很简单的建议，但真的很有效。

---

### [00:39:10] Paul Millerd

**English:**
It's hard too. I think the pull to create a company when you leave a big tech company is so powerful. And what you're saying is sort of crazy. You're saying, "I just feel good writing. I'm going to follow that."

**中文翻译:**
这也很难。我认为当你离开一家大科技公司时，去创办一家公司的诱惑力是如此强大。而你所说的其实有点疯狂。你在说：“我只是觉得写作感觉很好，我要追随这种感觉。”

---

### [00:39:29] Lenny

**English:**
It's not a popular path amongst my friends and family.

**中文翻译:**
在我的朋友和家人中，这可不是一条受欢迎的路。

---

### [00:39:32] Paul Millerd

**English:**
And I think the root of that is you're triggering insecurities in them. You're doing something they weren't allowed to do at your age.

**中文翻译:**
我认为根源在于你引发了他们的不安。你正在做一些他们在你这个年纪不被允许做的事情。

---

### [00:39:41] Lenny

**English:**
The thing I found really helpful there, another friend gave me this advice, just tell people you're tinkering. When they ask you, "What are you working on?" "I'm just tinkering. I'm tinkering with some writing." Because something about that word makes it sound like, "Okay, cool, it's delightful and cool. Tinker wave."

**中文翻译:**
我发现一个非常有用的方法，是另一个朋友给我的建议：就告诉别人你在“瞎折腾”（Tinkering）。当他们问你“你在忙什么？”时，回答：“我只是在瞎折腾。我在瞎折腾写点东西。”因为这个词听起来像是：“好吧，酷，这很愉快也很酷。折腾去吧。”

---

### [00:39:57] Paul Millerd

**English:**
I feel like that did not work with my parents. But yeah, trying different things. I always tell people you need a boomer compatible story for what you're up to, as just give them something. Just say, "I'm an entrepreneur," or, "I'm a business owner."

**中文翻译:**
我觉得这招对我父母没用。但是，是的，尝试不同的事情。我总是告诉人们，你需要一个“婴儿潮一代兼容”（Boomer compatible）的故事来解释你在做什么，给他们一个说法就行。就说：“我是一个创业者，”或者“我是一个企业主。”

---

### [00:40:18] Lenny

**English:**
That totally resonates. I'd be excited about that if I was a boomer. In the book, you also talk about taming fears. So we talked about a few of these things, and just the power of taming some of these fears that you have. There's success, the fear of not being successful, of money, of belonging, of loneliness, and of health. Can you just talk about either all of those or any of those, just why it's important to tame those fears, and then how one goes about taming these fears?

**中文翻译:**
这完全引起了共鸣。如果我是个婴儿潮一代，我也会为此感到兴奋。在书中，你也谈到了“驯服恐惧”。我们谈到了其中的几点，以及驯服恐惧的力量。包括对成功的渴望、对不成功的恐惧、金钱、归属感、孤独感和健康。你能谈谈这些恐惧吗？为什么驯服它们很重要，以及一个人该如何去驯服这些恐惧？

---

### [00:40:45] Paul Millerd

**English:**
Yeah. So a big source of inspiration around this is Tim Ferriss' fear setting, and he basically forces you to write down what are your fears, how could you mitigate these. But more powerfully, the second part is... And you're framing them around action. And so he reframes, what is the cost of inaction? And that was really powerful for me, and it sort of exposed a lot of the costs in the current state of what I was doing.

**中文翻译:**
是的。这方面的一个重要灵感来源是 Tim Ferriss 的“恐惧设定”（Fear setting），他基本上是强迫你写下你的恐惧是什么，以及你如何减轻这些恐惧。但更强大的是第二部分……你围绕行动来构建它们。他重新定义了：不采取行动的代价是什么？这对我有很大的触动，它揭示了我当时所处状态下的许多隐形成本。

---

### [00:41:16] Paul Millerd

**English:**
And so actually, I want to thank you. It's funny, you messaged me as I was listening to a podcast you were on. I think it was the one with David Perell.

**中文翻译:**
所以实际上，我要谢谢你。很有趣，你给我发消息时，我正听着你参加的一期播客，我想是和 David Perell 合作的那期。

---

### [00:41:26] Lenny

**English:**
Yeah, I slid into your DMs.

**中文翻译:**
是的，我直接私信了你。

---

### [00:41:31] Paul Millerd

**English:**
But I was listening to your podcast and you were talking about hiring a community manager. And this is actually something I've done in the past few weeks. And I think I was scared to commit to the community because I didn't want to create a job for myself. And one thing I've realized is that I'm scared of creating a job for myself, but I sort of reframed the cost of inaction. What's the cost of inaction is if I don't actually hire someone, I'm going to drain all my creative energy, and that's an existential risk to this path. And so that's one example of I'm always thinking about these things, and that enabled me to take very quick action on that.

**中文翻译:**
当时我正在听你的播客，你谈到了雇佣社区经理的事。这实际上是我过去几周一直在做的事情。我想我之前害怕对社区做出承诺，是因为我不想给自己创造一份“工作”。我意识到我害怕给自己找活干，但我重新定义了不采取行动的代价：如果不雇人，我会耗尽所有的创作精力，这对这条路径来说是生存风险。这就是一个例子，说明我一直在思考这些事情，这让我能够迅速采取行动。

---

### [00:42:17] Paul Millerd

**English:**
But I think it was helpful to hear from you. You were like, "I'm not a community manager." And this is a big aha for me, because I launched my community at the beginning of this year. I suck at community management. I'm not good at it, but I found somebody that actually was good at it and I was like, "There are people that like this and are good at it." So that's one thing. I think more broadly though is some fears don't disappear. So that's a very specific project-based fear.

**中文翻译:**
我觉得听你说话很有帮助。你说：“我不是社区经理。”这对我来说是一个巨大的启发，因为我在今年年初启动了我的社区。我不擅长社区管理，我做得不好，但我找到了一个真正擅长的人，我心想：“原来真的有人喜欢做这个而且做得很好。”所以这是其一。但更广泛地说，有些恐惧是不会消失的。刚才说的是非常具体的项目层面的恐惧。

---

### [00:42:47] Paul Millerd

**English:**
Existential fears around health, death, importance, money, they don't really go away. I think the great thing about this path for me is that you can't pretend like they don't exist. They sort of just punch you in the face. You'll wake up one day and you'll have an existential breakdown of, "What the heck am I doing? Is this sustainable? This is so silly. Am I going to run out of money? Next year, are my book sales going to tank?" And so the longer I've been on this path, those big worries turn into these small little daily things that pop up. And I'll sort of have a conversation with my fear and I'll say, "We're worrying about money today. Okay, I see you. Yeah, that's real. Yeah, I don't know if we can solve that, but yeah, six and a half years, let's keep going. Let's see if it works."

**中文翻译:**
关于健康、死亡、重要性、金钱的生存恐惧，它们不会真正消失。我认为这条路对我来说最棒的一点是，你无法假装它们不存在。它们就像直接打在你的脸上。某天醒来，你可能会陷入生存危机：“我到底在做什么？这可持续吗？这太傻了。我会把钱花光吗？明年我的书销量会暴跌吗？”随着我在这条路上走得越久，那些巨大的担忧变成了每天冒出来的小事。我会和我的恐惧对话，说：“今天我们在担心钱啊。好的，我看到你了。是的，这很现实。我不知道能不能解决，但嘿，已经六年半了，让我们继续走下去，看看行不行。”

---

### [00:43:48] Paul Millerd

**English:**
Yeah, that's the thing that makes me feel better every time something like that comes up is, it's worked this long. It's probably going to work for a lot longer. There's this concept of [inaudible 00:43:56], of the time something is going to last is usually as long as it's already lasted. And so that always makes me feel better. The main thing I think about, is am I going to run out of stuff with a newsletter to write about? And it's been four years now. I'm like, "Nah, it's probably going to keep going for at least four more years."

**中文翻译:**
是的，每当这种念头冒出来时，让我感觉好一点的是：它已经运作这么久了，可能还会运作更久。有一个概念（林迪效应 Lindy Effect），即一件事物预期剩下的寿命，通常与其已经存在的寿命相当。这总能让我感觉好些。我主要担心的是：我的 Newsletter 会不会没东西写了？现在已经四年了，我想：“不，它可能至少还能再写四年。”

---

### [00:44:12] Paul Millerd

**English:**
It's very important to dance with your fears and really get in with them. If I'm afraid of not making money, it's very reasonable that book sales will fall. And so I don't know if we can sustain our lifestyle on what I have set up two, three years down the road. But taking that fear and saying, "Okay, I'm going to solve that and make that fear go away by getting a job," is off the table. So I have no choice but to actually just be like, "Yeah, that fear's going to be here. It's going to be part of my life, and we're going to have to just deal with it."

**中文翻译:**
与恐惧共舞并真正深入其中是非常重要的。如果我害怕赚不到钱，书的销量下降是很合理的。所以我不知道两三年后，我建立的这套系统是否还能维持我们的生活方式。但是，通过找份工作来“解决”那个恐惧并让它消失，这个选项是不在考虑范围内的。所以我别无选择，只能说：“是的，恐惧会一直在这儿，它将是我生活的一部分，我们只能面对它。”

---

### [00:44:52] Lenny

**English:**
Along those lines, is there a path you took that was a big failure or didn't work out, something that you thought was going to be a big opportunity and wasn't?

**中文翻译:**
沿着这个思路，你有没有走过哪条路是巨大的失败，或者没能成功？某种你原以为是巨大机会但结果并非如此的事情？

---

### [00:44:59] Paul Millerd

**English:**
The first 10 years of my career, I just kept jumping from job to job. I think I was looking for my current path in job shaped containers and I couldn't find it. And I was just so desperate to find a really good situation. And there were all sorts of circumstances, like bosses who hired me, kept quitting immediately after I would join. Layoffs, all sorts of random things that happened that were very weird. And I just sort of kept searching.

**中文翻译:**
在我职业生涯的前 10 年，我一直在不停地跳槽。我想我当时是在“工作”形状的容器里寻找我现在的路径，但我找不到。我当时非常渴望找到一个真正好的环境。结果遇到了各种情况，比如招我进去的老板在我入职后立刻辞职，还有裁员，各种非常奇怪的随机事件。我只是在不停地寻找。

---

### [00:45:33] Lenny

**English:**
So I've been comfortable with trying things, and starting new things, and experimenting for a long time. And so one frame I have, I call it ship, quit, and learn, which is what is the quickest way I can ship something designed to quit, but as soon as I ship it, I learn about what to do next?

**中文翻译:**
长期以来，我一直很习惯于尝试新事物、启动新项目和做实验。我有一个框架，我称之为“发布、放弃、学习”（Ship, quit, and learn），即：我能以最快的方式发布一个原本就打算放弃的东西，但一旦发布，我就能学到下一步该做什么？

---

### [00:45:57] Paul Millerd

**English:**
And so this is how I started my podcast. I just said, "I'm going to do five episodes." I stole this from Tim Ferriss as well. I'm going to do five episodes. I'm going to see how it feels. And this is one of these things, super energizing. I love how I feel after podcast conversations. I'm going to keep doing it. I wasn't aiming at success, but it was like, "I know I can keep doing the podcast and my newsletter." I had that experience, that feeling from it, but there are things I've tried that I'm like, "Yeah, not again." A couple consulting and advisory type things early on in my path, it was like, "Whoa, I need to build in protectors such that I don't take a gig like this again."

**中文翻译:**
这就是我开始做播客的方式。我当时说：“我就做五集。”这也是我从 Tim Ferriss 那里偷师来的。做五集，看看感觉如何。结果发现这事儿超级让我兴奋。我喜欢播客对话后的那种感觉。我要继续做下去。我当时并没瞄准成功，只是觉得：“我知道我可以继续做播客和 Newsletter。”我从中获得了那种体验和感觉。但也有一些我尝试过的事情，我的反应是：“额，再也不做了。”在我路径早期做过的一些咨询和顾问类工作，让我觉得：“哇，我得建立一些保护机制，免得以后再接这种活儿。”

---

### [00:46:39] Lenny

**English:**
I connect to something you said earlier, which I super resonate with, which is you want to avoid creating jobs for yourself that you don't enjoy with this path. There's so many things you could be doing and so many pulls that often, for me, it's like writing a book is always this thing that's out there. Actually, starting a podcast with one of these for a long time, "I don't want to start a podcast. Life is good. I got this awesome newsletter. Things are going great. Why would I want more work?"

**中文翻译:**
我联想到你之前说的一点，我超级有共鸣，那就是：在这条路上，你要避免为自己创造那些你不喜欢的“工作”。有那么多你可以做的事，有那么多诱惑。对我来说，写书一直是件悬在那儿的事。实际上，开始做播客也是其中之一，很长一段时间我都想：“我不想做播客。生活很美好，我有这么棒的 Newsletter，一切都很顺利。我为什么要给自己找更多活儿？”

---

### [00:47:05] Lenny

**English:**
Eventually I crumbled, and I did it, and here we are, and I'm happy I did. But there's all these other things that are always like, "I should do these things." But I think it's really important to pay attention to what do you not enjoy and don't do that. It's easy to create bad jobs for yourself. A really clear example of that is finding a niche that you don't enjoy, spending time on in this life of writing about something you don't actually care about, or podcasting about something you don't care about. You just created a job for yourself you hate. Why would you do that? And so it comes back to paying attention to what gives you energy.

**中文翻译:**
最终我妥协了，我做了，现在我们就在这儿，我也很高兴我做了。但总有其他事情让你觉得“我应该做这些”。但我认为，关注你不喜欢什么并拒绝去做是非常重要的。给自己创造一份糟糕的工作太容易了。一个很明显的例子是，找了一个你不喜欢的利基领域，花时间写一些你根本不在乎的东西，或者做一个你不在乎的主题的播客。你只是给自己创造了一份你讨厌的工作。你为什么要那样做？所以，这又回到了关注什么能给你能量这一点上。

---

### [00:47:37] Paul Millerd

**English:**
So I've created a lot of slack in my life. So I'd say 95% of my days, I cannot work. So I don't do meetings. I don't really have employees or anything like that. I have contractors, but I hire contractors for very specific roles. And I create systems such that we can do it asynchronously. And of course, I'll have conversations with them if they want to jump on a call. But I optimize for people that want asynchronous and work on those specific things. So I'm just very conscious of that.

**中文翻译:**
所以我在生活中创造了很多“闲暇”（Slack）。我会说我 95% 的日子里都可以不工作。我不开会，也没有真正的员工。我有合同工，但我雇他们是为了非常具体的角色。我建立了一套系统，让我们能异步协作。当然，如果他们想通话，我会和他们交流。但我优先选择那些接受异步工作并专注于特定任务的人。我对此非常有意识。

---

### [00:48:15] Paul Millerd

**English:**
I think one challenge I have now is I've created so many things that I'm doing a few things really well, and then sort of ignoring a lot of them. So I actually feel like I'm in this evolution right now of trying to figure out what comes next. So we haven't even talked about this, but I started this business strategy early on in my path because I wanted to productize my consulting. And one of the consulting projects I loved early on was training people on consulting skills. I did a training program for a consulting firm in Boston, and I was like, "Ooh, I could turn this into an online course." And that has slowly built and evolved, and I do workshops now with companies. And that made most of my money from years two to five when I started moving away from project-based consulting.

**中文翻译:**
我想我现在面临的一个挑战是，我创造了太多的东西，以至于我只能把其中几件事做得很好，然后忽略了其他的。所以我感觉我现在正处于一种进化中，试图弄清楚下一步该做什么。我们还没谈到这个，但在我路径的早期，我开始了这个业务策略（StrategyU），因为我想把我的咨询服务产品化。早期我喜欢的一个咨询项目是培训人们的咨询技能。我为波士顿的一家咨询公司做了一个培训项目，当时我想：“噢，我可以把它变成一门在线课程。”它慢慢建立并演变，现在我也为公司做工作坊。在我从基于项目的咨询转型的第二到第五年里，这赚了我大部分的钱。

---

### [00:49:13] Paul Millerd

**English:**
And so the game I was playing was make money from that, don't focus on it too much, spend minimal time, don't try to maximize for success. Create a self-paced course, because I am not interested in making more money in a cohort-based course, because I just don't want to spend the time. And then use all the abundant time to write and explore, create podcasts, spend time with my wife, and do all the non-work experiments, see how I feel and write about it. Now I'm making money from the work I love, which is very weird. I'm going to make, I'll hit soon about $200,000 made for my book, which is mind-blowing. I published a book completely on my terms about what I love and loved the process of it. It's so crazy.

**中文翻译:**
所以我当时玩的策略是：从中赚钱，但不要投入太多精力，花最少的时间，不要试图追求成功最大化。创建一个自学进度的课程，因为我对通过训练营模式（Cohort-based）赚更多钱没兴趣，我只是不想花那个时间。然后利用充足的时间去写作、探索、做播客、陪妻子，做所有非工作的实验，观察自己的感受并写下来。现在我通过我热爱的工作赚钱，这感觉很奇妙。我的书很快就要赚到 20 万美元了，这太不可思议了。我完全按照自己的意愿出版了一本关于我所爱之物的书，而且我非常享受那个过程。这太疯狂了。

---

### [00:50:05] Lenny

**English:**
That's amazing.

**中文翻译:**
太棒了。

---

### [00:50:06] Paul Millerd

**English:**
And so now I'm building a community around that. That's really fun. I'm doing the podcast. I have some sponsors around that. And so that's sort of taking over. I still have this StrategyU though. So now I'm trying to figure out how to unwind some of these things. I'm actually exploring trying to find somebody that might want to start their own pathless path, like a strategy consultant that wants to leave that world, that wants to be an operator on this business. So if you're listening, I've recently come to terms with this might be the path forward.

**中文翻译:**
所以现在我围绕它建立了一个社区，非常有趣。我在做播客，也有了一些赞助商。这些事情正逐渐占据主导。但我还有 StrategyU 这个业务。所以现在我正试着弄清楚如何剥离其中一些事情。我实际上正在寻找一个可能想开启自己无径之路的人，比如一个想离开那个圈子的战略顾问，来担任这个业务的运营者。所以如果你正在听，我最近已经意识到这可能是未来的方向。

---

### [00:50:38] Paul Millerd

**English:**
But yeah, it's a constant journey of protecting your time, creating that space, going down projects you want to execute, but then stepping back and like, "Okay, I have all this maintenance I'm doing. How do I outsource this, eliminate it, restart, recreate?" And I think this path is really just a commitment to constant reinvention, which is really, really hard. And you shouldn't do it unless you get some satisfaction out of personal reflection and that journey.

**中文翻译:**
但是，是的，这是一个持续的旅程：保护你的时间，创造空间，执行你想做的项目，然后退后一步想：“好吧，我现在有很多维护工作要做。我该如何外包它、消除它、重启它、重新创造它？”我认为这条路本质上就是对“不断重塑自我”的承诺，这非常非常难。除非你能从个人反思和这段旅程中获得满足感，否则你不应该这样做。

---

### [00:51:09] Lenny

**English:**
For someone that may want to help you with that program, what's the best way to reach out to you if they're just like, "Oh shit, this is a cool opportunity"?

**中文翻译:**
如果有人想在那个项目上帮你，如果他们觉得“噢，这真是个酷机会”，联系你的最好方式是什么？

---

### [00:51:14] Paul Millerd

**English:**
Yeah, Twitter, paul@strategyu.co, or I'm very easy to find. My email is all over the place. But yeah.

**中文翻译:**
Twitter，或者发邮件到 paul@strategyu.co，我很显眼的，我的邮箱到处都是。

---

### [00:51:22] Lenny

**English:**
We'll link to it in the show notes too. Just a couple more questions. I feel like one criticism of this path is, is there anyone left to actually do work at companies and build things and scale if everyone ends up being on this pathless path, creating content, starting their own companies? Do you have any thoughts on that side of things?

**中文翻译:**
我们也会在节目介绍里放上链接。还有最后几个问题。我觉得对这条路径的一个批评是：如果每个人最终都走上这条无径之路，去创作内容、开自己的公司，那还有谁留在公司里真正干活、构建产品和扩大规模呢？你对这方面有什么看法？

---

### [00:51:42] Paul Millerd

**English:**
I don't buy that, because I've met most people and most people are like, "Hell no," when they hear about my life. I think it's an interesting critique. I also think there's a more secular trend of gigification of work. All the growth in the economy from 2005 to 2015 in the labor market came from alternative work arrangements. So if you search David Deming's work on this, it's pretty compelling. Right now, we don't really count non-traditional work that well, so it's really hard to get good data on this. But even the way companies are treating their internal talent, it's much more project-based. People are shifting around, moving to different roles a lot quicker. And I think that's going to continue.

**中文翻译:**
我不买账，因为我见过大多数人，当他们听说我的生活时，他们的反应是：“绝对不要。”我认为这是一个有趣的批评。但我也认为存在一种更长期的“工作零工化”（Gigification）趋势。从 2005 年到 2015 年，劳动力市场的所有增长都来自替代性工作安排。如果你去查 David Deming 关于这方面的研究，会发现非常有说服力。目前我们对非传统工作的统计还不够完善，所以很难获得好的数据。但即使是公司对待内部人才的方式，也变得更加基于项目。人们在不同角色间流动的速度快得多。我认为这种趋势会持续下去。

---

### [00:52:29] Paul Millerd

**English:**
So you could make an argument that people will actually be able to slot into companies more easily in the future. Right now, companies under exploit the creator economy and the freelance economy, because they're so tied to you have to hire somebody through a full-time job. So I think there's two sides to that, is one, most people would hate my life. And two, the world is becoming more giggified. So it could go back the other way actually.

**中文翻译:**
所以你可以认为，未来人们实际上会更容易地嵌入到公司中。目前，公司对创作者经济和自由职业经济的利用还不够，因为他们太执着于必须通过全职工作来雇人。所以我觉得这有两面：第一，大多数人会讨厌我的生活；第二，世界正在变得更加零工化。所以实际上可能会向另一个方向发展。

---

### [00:53:02] Lenny

**English:**
I really like that advice. Paul, is there anything else you want to leave listeners with to maybe start down this pathless path or any other piece of advice before we get to very exciting lightning round?

**中文翻译:**
我很喜欢这个建议。Paul，在进入非常令人兴奋的闪电轮环节之前，你还有什么想留给听众的吗？也许是关于如何开始这条无径之路，或者其他建议？

---

### [00:53:14] Paul Millerd

**English:**
I think the key thing that doesn't get talked about enough is it might be hard and it might suck, but it might be worth it. And I think that's a hard reframe for people, because people will say, "Well, I'm worried about not knowing what I'll do or not making money and all these things." And it's like, yeah, I felt like after quitting my job. But man, I'm so glad I did it, because it enabled me to now know that I don't have regrets about trying this and figuring it out. And a lot of people that do go back to their jobs are so much happier, because they know I tested that, I found my boundaries, I need more stability. It's not this quit your job and get rich pitch. It's very much like if you're somebody that has a sense that there's something more, there probably is, and it might be worth exploring.

**中文翻译:**
我认为最关键但被讨论得不够的一点是：这可能会很难，可能会很糟糕，但它可能是值得的。我认为这对人们来说是一个很难的重新框架，因为人们会说：“我担心不知道该做什么，或者赚不到钱等等。”是的，我辞职后也有这种感觉。但是，天哪，我太庆幸我这么做了，因为它让我现在知道，我对于尝试并摸索出这条路没有遗憾。很多最终回到职场的人也变得更快乐了，因为他们知道：“我测试过了，我找到了我的边界，我确实需要更多的稳定性。”这并不是那种“辞职致富”的推销。它更像是：如果你感觉生命中还有更多的可能性，那大概率是真的，而且可能值得去探索。

---

### [00:54:17] Lenny

**English:**
What's the next step you recommend someone take to start exploring this pathless path? What's something they could do today or tomorrow or in the next-

**中文翻译:**
你建议人们开始探索这条无径之路的下一步是什么？他们今天、明天或接下来的时间里可以做些什么？

---

### [00:54:24] Paul Millerd

**English:**
Read my book.

**中文翻译:**
读我的书。

---

### [00:54:26] Lenny

**English:**
Perfect.

**中文翻译:**
完美。

---

### [00:54:28] Paul Millerd

**English:**
So I'm very committed to creating resources for people around this. My podcast is all conversations of people on an unconventional path, and sort of the inner game of work. And I don't talk about tactics and outcomes as much as really just, how does it feel? How'd you deal with that? Things like that. And so I do that in my newsletter, my podcast, etc. But just find people that are on interesting pasts and ask them about their lives.

**中文翻译:**
我非常致力于为此创造资源。我的播客全是与走在非传统路径上的人的对话，探讨工作的“内在博弈”。我不怎么谈论战术和结果，更多是谈论：感觉如何？你是怎么应对的？诸如此类。我在 Newsletter 和播客里都这么做。总之，去寻找那些有着有趣经历的人，询问他们的生活。

---

### [00:54:59] Paul Millerd

**English:**
One interesting thing I've had happen to me over the past few years is I've just met a much more wider diversity of people. I'm friends with people that work at restaurants, and work part time, and work weird schedules, and work nine months of the year and take three months off. And now it just feels so much more normal what I'm doing, because before all I knew was full-time workers. I was working all the time, and that's all you're surrounded by. So yeah, try to find the weirdos.

**中文翻译:**
过去几年发生在我身上的一件趣事是，我结识了更多样化的人。我的朋友中有在餐厅工作的，有做兼职的，有工作时间很怪的，还有一年工作九个月休息三个月的。现在我觉得我做的事正常多了，因为以前我只认识全职工作者。我以前一直在工作，周围也全是这样的人。所以，去寻找那些“怪人”吧。

---

### [00:55:30] Lenny

**English:**
Awesome. And for folks that want to check out your book, should I just Google The Pathless Path?

**中文翻译:**
太棒了。对于想看你书的人，是直接谷歌搜索《无径之路》吗？

---

### [00:55:34] Paul Millerd

**English:**
Pathlesspath.com. I just moved over everything last month.

**中文翻译:**
Pathlesspath.com。我上个月刚把所有东西都搬过去。

---

### [00:55:39] Lenny

**English:**
Okay, great. And then we'll link to all of these things in the show notes. With that Paul, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
好的，太棒了。我们会把所有链接放在节目介绍里。Paul，现在进入我们非常令人兴奋的闪电轮环节。准备好了吗？

---

### [00:55:46] Paul Millerd

**English:**
I am ready.

**中文翻译:**
准备好了。

---

### [00:55:48] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [00:55:52] Paul Millerd

**English:**
Yeah, one is called The Great Work of Your Life. Sounds like a cheesy title, but that's actually a good resource for people that want to hear about people from history. Over the past several hundred years, different eras of people that really did design their life around work. It was really interesting, and that was a great book. A second book I'd recommend, I actually really like Luke Burgis' book Wanting. That was another great personal story/deep dive into a nerdy topic. That's my favorite kind of book. That's the kind of book I wrote, which was personal memoir plus nerdy deep dive. And Luke Burgis' is really good too, more from a tech perspective, because he went down the startup path as well. Tut that's a great book. That was my favorite read of the year.

**中文翻译:**
一本叫《你生命中的伟大工作》（The Great Work of Your Life）。听起来名字有点俗，但对于想了解历史人物的人来说，它真的是很好的资源。它讲述了过去几百年间，不同时代的人如何真正围绕工作来设计生活。非常有趣，是一本好书。第二本我推荐 Luke Burgis 的《欲望》（Wanting）。那是另一个将个人故事与硬核话题深度结合的范例。那是我最喜欢的书的类型，也是我写的那种类型：个人回忆录加硬核深度探讨。Luke Burgis 的书写得非常好，更多是从科技视角出发，因为他也走过创业之路。那是一本伟大的书，是我今年最喜欢的读物。

---

### [00:56:44] Lenny

**English:**
What is a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视剧是什么？

---

### [00:56:47] Paul Millerd

**English:**
I struggle to answer this, because I'm not watching much TV. I did watch the Anthony Bourdain documentary. That was excellent. Talk about a pathless path, and the ups and downs, and the struggles, and the dark side of it. Man, that person was bringing forth what is inside of him and grappling with his demons at the same time. That was a powerful story worth watching.

**中文翻译:**
我很难回答这个，因为我不怎么看电视。但我确实看了安东尼·波登（Anthony Bourdain）的纪录片。非常精彩。那也是一种无径之路，充满了起伏、挣扎和阴暗面。天哪，那个人在展现内心世界的同时，也在与心魔搏斗。那是一个非常震撼、值得一看的故事。

---

### [00:57:18] Lenny

**English:**
Do you have a favorite interview question that you like to ask when you interview, say, contractors or anyone else you work with or hire?

**中文翻译:**
在面试合同工或任何合作伙伴时，你有没有最喜欢问的问题？

---

### [00:57:25] Paul Millerd

**English:**
I'm always curious about, what makes you come alive? I want to work with people that are alive, and connected, and inspired. So the two people I'm working with right now, one's a podcast producer in Poland, but he's doing a bunch of other stuff around video. And he's super energized, used to be a lawyer, reinventing himself. The other person is also a former finance person in India, and she's two years into this self-employment journey. She's writing and exploring all these ideas. So yeah, I'm always looking for that energy first and skills second.

**中文翻译:**
我总是很好奇：什么能让你焕发生机（Come alive）？我想和那些充满活力、有连接感、受过启发的人一起工作。我现在合作的两个人，一个是波兰的播客制作人，他还在做很多视频相关的工作，精力充沛，以前是律师，现在正在重塑自我。另一个人以前在印度从事金融工作，现在已经开启自由职业旅程两年了，正在写作和探索各种想法。所以，我总是先看能量，再看技能。

---

### [00:58:03] Lenny

**English:**
Is there a favorite product you've recently discovered that you love?

**中文翻译:**
最近有没有发现什么你非常喜欢的产品？

---

### [00:58:07] Paul Millerd

**English:**
I really love the Nuna travel stroller. Super convenient for traveling.

**中文翻译:**
我真的很喜欢 Nuna 的旅行婴儿车。旅行时超级方便。

---

### [00:58:15] Lenny

**English:**
We don't have the travel stroller, but we have the Nuna car seat.

**中文翻译:**
我们没有旅行婴儿车，但我们有 Nuna 的汽车安全座椅。

---

### [00:58:17] Paul Millerd

**English:**
Yeah, yeah, we have that one too. It fits. So we've brought that around the world. That's been super convenient. And then more on the tech side, I just got into the esim game. That was amazing. And then ChatGPT, I just created my own GPT to do podcast show notes automatically for me today. Took me an hour to train it, and it is incredible, so that's amazing.

**中文翻译:**
是的，我们也有那个。很合适。我们带着它环游世界，非常方便。技术方面，我刚开始用 eSIM，太棒了。还有 ChatGPT，我今天刚创建了自己的 GPT，专门帮我自动生成播客的 Show Notes。花了一个小时训练它，效果惊人，太不可思议了。

---

### [00:58:44] Lenny

**English:**
That's awesome. I don't know if folks know, but there's a lennybot.com site that uses all of my podcast transcripts and newsletter to have a little bot that you could ask questions to. That's working actually, shockingly well. We're going to try using the new GPT thing that they just launched, where you can kind of train your own GPT and that'll be fun. And actually, a podcast listener reached out to me and offered to help build this thing, so that's a huge success story from this podcast. Next question, two more questions. Do you have a favorite life motto that you find yourself coming back to, sharing with friends, finding really useful in work or in life?

**中文翻译:**
太棒了。我不知道大家是否知道，有一个 lennybot.com 网站，它利用我所有的播客转录稿和 Newsletter 建立了一个小机器人，你可以向它提问。效果出奇地好。我们打算尝试他们刚推出的新 GPT 功能，可以训练自己的 GPT，那会很有趣。实际上，是一位播客听众主动联系我并提出帮我建立这个东西的，所以这是本播客的一个巨大成功案例。下一个问题，还有最后两个。你有没有最喜欢的人生格言，是你经常想起、分享给朋友，并觉得在工作或生活中非常有用的？

---

### [00:59:22] Paul Millerd

**English:**
One, coming alive over getting ahead. That's something I keep coming back to. I'm default skeptical of chasing achievement, and I use this to remind myself that it is about that personal energy versus extrinsic outcomes. I'm very convinced from my own life experience that the extrinsic outcomes aren't going to do a ton for me. Sure, I need to make enough money. But when I'm in extended states of feeling alive and connected to everything I'm doing in my life, that's it. And I basically repeated this mantra to myself right before rejecting the book deal. It was like I did not feel good in the conversation with the people. They talked down to me, they told me that I probably wouldn't succeed, and it was like coming alive over getting ahead. Don't need their prestige.

**中文翻译:**
一个是：“焕发生机胜过出人头地”（Coming alive over getting ahead）。这是我一直铭记在心的。我天生对追求成就持怀疑态度，我用这句话提醒自己，个人能量比外部结果更重要。从我的人生经验中，我深信外部结果不会给我带来太多。当然，我需要赚足够的钱。但当我处于一种持久的、感到生命鲜活并与我所做的一切紧密相连的状态时，那就足够了。在拒绝那份图书合约之前，我基本上一直在对自己重复这句咒语。当时和那些人的谈话让我感觉很糟，他们居高临下地对我说话，告诉我我可能不会成功。于是我想：焕发生机胜过出人头地。我不需要他们的声望。

---

### [01:00:21] Lenny

**English:**
Final question. You've been podcasting, I think, for six years. What's your best piece of advice for someone that wants to start podcasting, has maybe already been doing podcasting like myself, or being successful or anything along those lines?

**中文翻译:**
最后一个问题。你做播客已经六年了。对于想要开始做播客，或者像我一样已经在做、并取得了一定成功的人，你最好的建议是什么？

---

### [01:00:36] Paul Millerd

**English:**
Yeah. I think if you want to podcast to make money, it's probably not something you should get into. Even if you have an audience, it's probably not the best way. I think if you have a massive audience, it can work, but it takes a really long time. Podcast is the ultimate long game, so you need to find some intrinsic connection to what you're actually doing. If you don't love the conversations or the format you're doing, don't do it.

**中文翻译:**
是的。我认为如果你做播客是为了赚钱，那可能不该入行。即使你有受众，这可能也不是最好的变现方式。如果你有海量受众，它可能奏效，但需要很长时间。播客是终极的长线游戏，所以你需要找到你所做事情的内在联系。如果你不喜欢你正在进行的对话或形式，那就别做。

---

### [01:01:05] Paul Millerd

**English:**
But yeah, I would recommend more people start podcasts. I'm against... The New York Times says there's too many podcasts, but I take the opposing view. I don't think there's that many podcasts. If you ask people in their personal life out of tech bubbles, "How many people in your life have a podcast?" Now in Austin, a lot of people have podcasts, but yeah, most people don't have a podcast. Even if you do something like interview your parents or anything, it's such a cool, creative thing. It's free. It's free, and you can send it to everyone in the world. Podcasts and newsletters are incredible innovations. Let it rip. You had to get permission to do these things 10, 15 years ago. It's so great to be alive in today's world.

**中文翻译:**
但是，是的，我会推荐更多人开始做播客。我不赞同……《纽约时报》说播客太多了，但我持相反观点。我不认为播客有那么多。如果你问问科技圈之外的人：“你生活中认识的人里有几个做播客的？”在奥斯汀，很多人有播客，但大多数人并没有。即使你只是采访你的父母，那也是一件非常酷、非常有创意的事。它是免费的，而且你可以把它发给全世界的人。播客和 Newsletter 是令人难以置信的创新。放手去做吧。在 10 到 15 年前，做这些事是需要获得许可的。活在当今世界真是太棒了。

---

### [01:01:52] Lenny

**English:**
I feel like when people say there's too much of say newsletters, too many podcasts, my answer is always there's always room for better newsletters and better podcasts. If you can deliver more useful, valuable, interesting stuff, people are going to pay attention. The bar just keeps rising is the challenge.

**中文翻译:**
我觉得当人们说 Newsletter 或播客太多时，我的回答总是：更好的 Newsletter 和更好的播客永远有空间。如果你能提供更有用、更有价值、更有趣的东西，人们就会关注。挑战在于门槛在不断提高。

---

### [01:02:08] Paul Millerd

**English:**
Yeah. It's also like do it for the sake of itself. Do it for the creative act. The creative act can be super meaningful in and of itself. I've lost money in my podcast over the lifetime of it. Love it. I don't care. I'm going to keep doing it.

**中文翻译:**
是的。而且要为了这件事本身去做。为了创作行为本身。创作行为本身就可以非常有意义。在我的播客生涯中，我一直是亏钱的。但我爱它，我不在乎，我会继续做下去。

---

### [01:02:27] Lenny

**English:**
And also, the best stuff often comes from just doing it for yourself and then realizing, "Wow, other people might find this interesting."

**中文翻译:**
而且，最好的东西往往源于“只为自己而做”，然后才意识到：“哇，其他人可能也会觉得这很有趣。”

---

### [01:02:33] Paul Millerd

**English:**
Yeah. I didn't start getting podcast feedback until the last two years when it started growing a lot more. I was sort of just doing it into the void.

**中文翻译:**
是的。直到过去两年，当播客开始大幅增长时，我才开始收到反馈。之前我基本上是对着虚空在说话。

---

### [01:02:43] Lenny

**English:**
Speaking of that, Paul, we've been on our own pathless path. I feel like we're going to send a number of folks on their pathless path. Two final questions. Where can folks find you online if they want to reach out and learn more about what you're sharing in your journey, and how can listeners be useful to you?

**中文翻译:**
说到这儿，Paul，我们都在各自的无径之路上。我觉得我们会把不少听众也送上他们的无径之路。最后两个问题：如果大家想联系你并了解更多关于你的旅程，可以在哪里找到你？以及，听众可以如何帮到你？

---

### [01:03:01] Paul Millerd

**English:**
Yeah, so I've been compiling a lot of my more recent stuff under pathlesspath.com, that will link you to my podcast, newsletter, community, and book. And I'm always willing to gift my book to anyone in the world who wants it. Just email me. I'll even send you a printed copy, if you don't have the money to do it. And I'm always happy to send bulk orders to people that want to gift it and do book clubs or things like that. And happy to send it at the author rate, which is about $4 per book.

**中文翻译:**
是的，我把我最近的大部分内容都整合到了 pathlesspath.com，那里有我的播客、Newsletter、社区和书的链接。我一直愿意把我的书送给世界上任何想要它的人。直接给我发邮件就行。如果你没钱买，我甚至可以给你寄一本纸质版。我也很乐意为想要送人、办读书会的人提供大宗订单，并按作者价（大约每本 4 美元）寄送。

---

### [01:03:34] Paul Millerd

**English:**
And yeah, I am starting to explore the potential of selling my StrategyU business or finding an owner operator who might want to get some sort of profit sharing or something like that. It'd be interesting if there are former consultants that might be interested in something like that. I don't know. I'm so bad at asking for help. I think if you want to share my book, that would be cool, because it is pretty neat to make money doing something from something I'm really proud of.

**中文翻译:**
另外，我正开始探索出售 StrategyU 业务的可能性，或者寻找一个愿意参与利润分成之类的所有者兼运营商。如果有前咨询顾问对此感兴趣，那会很有趣。我不知道，我很不擅长请求帮助。我想如果你愿意分享我的书，那就太酷了，因为能通过做一件让我自豪的事情来赚钱，这种感觉真的很棒。

---

### [01:04:08] Lenny

**English:**
Go buy The Pathless Path, available all online bookstores, I imagine. Paul, thank you so much for being here.

**中文翻译:**
去买《无径之路》吧，我想各大在线书店都有售。Paul，非常感谢你能来。

---

### [01:04:15] Paul Millerd

**English:**
Amazing. Keep going on your path too. I'm really inspired by how you're approaching your path and sharing your reflections too.

**中文翻译:**
太棒了。也请继续走你的路。你对待自己路径的方式以及分享的反思也给了我很多启发。

---

### [01:04:23] Lenny

**English:**
I appreciate that. Bye everyone.

**中文翻译:**
谢谢。大家再见。

---

### [01:04:25] Paul Millerd

**English:**
Adios.

**中文翻译:**
再见。

---

### [01:04:28] Lenny (Outro)

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。