# Pete Kazanjy - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Pete Kazanjy.

---

### (00:00:00) Pete Kazanjy

**English:**
The thing that I just like to encourage founders and product managers and what have you is just don't be afraid of sales. There's a lot of people out there who would love to tell you a story that it's magical or like, "Oh, you've got to be a born seller," things like that and it's really not. Those people are just talking their book, if you will, and so just getting good at those behaviors, it's going to benefit you in a myriad of ways.

**中文翻译:**
我想鼓励创始人、产品经理以及所有人的一点是：不要害怕销售。外面有很多人喜欢把销售描述得很神奇，或者说“哦，你必须天生就是个销售苗子”之类的话，但事实并非如此。那些人只是在自说自话（或者说为了维护自己的利益），只要掌握了这些行为习惯，你将在无数方面受益匪浅。

---

### (00:00:26) Lenny

**English:**
Welcome to Lenny's Podcast, I'm Lenny, and my goal here is to help you get better at the craft of building and growing products. Today my guest is Pete Kazanjy. Pete is the author of my single favorite book on sales, called Founding Sales, which I point every B2B founder to. He also runs a huge community of salespeople called Modern Sales Pros. He's also the CEO and founder of Atrium, which is a SaaS product that helps you make your sales team more efficient through analytics and data. In our conversation, we focus on three things. One, why founders should be doing sales themselves for a long time before hiring your first salesperson and also when it's time to hire that first salesperson, we get into how to hire for your first salesperson, what to look for in their profile and the most common mistakes people make, and finally, we cover a bunch of tactical tips for getting better at sales. Pete didn't come from a sales background and he learned everything by just doing it, learning, researching, and repeating. I know that you'll learn a ton from this conversation. With that, I bring you Pete Kazanjy.

**中文翻译:**
欢迎来到 Lenny 的播客，我是 Lenny。我的目标是帮助你更好地打磨和增长产品。今天的嘉宾是 Pete Kazanjy。Pete 是我最喜欢的一本销售书籍《创始人销售》（Founding Sales）的作者，我会向每一位 B2B 创始人推荐这本书。他还经营着一个巨大的销售人员社区，名为 Modern Sales Pros。他还是 Atrium 的首席执行官兼创始人，这是一款通过分析和数据帮助销售团队提高效率的 SaaS 产品。在我们的对话中，我们重点讨论三件事：第一，为什么创始人在雇佣第一名销售人员之前应该亲自做很长时间的销售，以及什么时候才是雇佣第一名销售的时机；第二，我们深入探讨了如何招聘第一名销售，在他们的简历中看重什么，以及人们最常犯的错误；最后，我们介绍了一系列提高销售能力的战术技巧。Pete 并非销售出身，他通过实践、学习、研究和不断重复掌握了一切。我相信你会从这次对话中学到很多。下面，让我们欢迎 Pete Kazanjy。

---

### (00:01:28) Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Beginning a SOC to your port can be a huge burden, especially for startups. It's time-consuming, tedious, and expensive.

**中文翻译:**
本期节目由 Vanta 赞助，旨在帮助你简化安全合规流程以加速增长。如果你的企业在云端存储任何数据，那么你很可能已经被问到或即将被问到关于 SOC 2 合规性的问题。SOC 2 是一种证明你的公司采取了适当安全措施来保护客户数据的方式，它能建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业级客户销售产品，证明安全性至关重要。SOC 2 既可以为你开启更大、更好的交易之门，也可能让你的业务停滞不前。如果你没有 SOC 2，你很有可能连谈判桌都上不去。开始准备 SOC 2 报告可能是一个巨大的负担，尤其是对于初创公司来说，既耗时、繁琐又昂贵。

---

### (00:02:14) Lenny

**English:**
Enter Vanta. Over 3,000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny, that's V-A-N-T-A.com/lenny, to learn more and to claim your discount. Get started today. Hey, Ashley, head of marketing at Flatfile. How many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
Vanta 应运而生。超过 3,000 家快速增长的公司使用 Vanta 来自动化处理高达 90% 的 SOC 2 相关工作。Vanta 可以在几周内（而不是几个月）让你做好安全审计准备，时间不到通常所需的三分之一。在限定时间内，Lenny 播客的听众可以享受 Vanta 1,000 美元的优惠。只需访问 vanta.com/lenny，即 V-A-N-T-A.com/lenny，了解更多信息并领取折扣。今天就开始吧。嘿，Ashley，Flatfile 的营销负责人。你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### (00:02:53) Ashley Mulligan

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### (00:02:55) Lenny

**English:**
How many of them screw that up and what happens when they do?

**中文翻译:**
其中有多少公司会搞砸这件事？搞砸了会发生什么？

---

### (00:02:58) Ashley Mulligan

**English:**
Well, based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So, if your CSV importer doesn't work right, which is super common considering customer files are chock full of unexpected data and formatting, they'll leave.

**中文翻译:**
嗯，根据我们的数据，大约三分之一的人在入职引导（onboarding）过程中只要经历一次糟糕的体验，就会考虑更换公司。所以，如果你的 CSV 导入器运行不正常（考虑到客户文件中充满了意想不到的数据和格式，这非常普遍），他们就会离开。

---

### (00:03:17) Lenny

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding as one of the highest leverage opportunities for both signup conversion and increasing long-term retention. Getting people to their aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不意外。我一直认为，改善入职引导是提高注册转化率和长期留存率的最高杠杆机会之一。让人们更快速、更可靠地达到他们的“顿悟时刻”（aha moment）是极其重要的。

---

### (00:03:32) Ashley Mulligan

**English:**
Totally. It's incredible to see how our customers like Square, Spotify, and Zora are able to grow their businesses on top of Flatfile. It's because flawless data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zora 这样的客户如何在 Flatfile 的基础上发展业务，真是令人难以置信。这是因为完美的数据入职引导就像催化剂一样，让他们和他们的客户能更快地达到目标。

---

### (00:03:49) Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny. Pete, welcome to the podcast.

**中文翻译:**
如果你想了解更多或开始使用，请访问 flatfile.com/lenny 查看 Flatfile。Pete，欢迎来到播客。

---

### (00:04:00) Pete Kazanjy

**English:**
Hey, Lenny, super awesome to see you.

**中文翻译:**
嘿，Lenny，见到你真是太棒了。

---

### (00:04:03) Lenny

**English:**
Even more awesome on my part. Ever since I launched this podcast, I have always wanted to have you on it, we're finally here. We've been online buddies for a few years now, ever since I discovered your book, Founding Sales, which we're going to talk about, and it's just been a lot of fun knowing you, so thank you again for being here.

**中文翻译:**
我这边感觉更棒。自从我开办这个播客以来，我一直想邀请你参加，我们终于如愿以偿了。自从我发现你的书《创始人销售》以来，我们已经做了几年的网友了，我们待会儿会聊到这本书。认识你真的很有趣，再次感谢你的到来。

---

### (00:04:20) Pete Kazanjy

**English:**
The quick story was Lenny had shipped his different genres of marketplaces and how to start the liquidity and growth and whatever and I was obsessed with it, and then somehow, I ran into you at Brianne Kimmel's SaaS School. I gave a presentation on Founder-led Selling and there was a scrum of people around me and I was talking about amazing writers and amazing content online and I referenced the series, and then you raised your hand and you were like, "That was me," and I was like, "What? You're amazing." And then we got beers and now, we're happily ever after.

**中文翻译:**
简短的故事是这样的：Lenny 发布了他关于不同类型市场（marketplaces）以及如何启动流动性和增长等系列文章，我当时非常着迷。后来，不知怎么的，我在 Brianne Kimmel 的 SaaS 学校遇到了你。我做了一个关于“创始人主导销售”的演讲，当时我身边围了一群人，我正在谈论网上那些了不起的作者和内容，并引用了那个系列文章。然后你举起手说：“那是我写的。”我当时惊呼：“什么？你太牛了！”然后我们一起去喝了啤酒，现在我们就成了好朋友。

---

### (00:04:53) Lenny

**English:**
Look at us now. And then you encouraged me to make a book out of that post, which I have not yet done, maybe one day.

**中文翻译:**
看看现在的我们。当时你还鼓励我把那篇文章写成一本书，但我还没做，也许有一天会吧。

---

### (00:05:00) Pete Kazanjy

**English:**
Eventually.

**中文翻译:**
总有一天会的。

---

### (00:05:00) Lenny

**English:**
Eventually.
(00:05:01):
So, we're going to be talking a lot about sales and a lot of the stuff that you cover in your book. Before we get into it, could you just take a minute to share a little bit about your background and some of the wonderful things you've done, to give folks a sense of your experience in the sales world?

**中文翻译:**
总有一天。
(00:05:01):
所以，我们将深入探讨销售以及你在书中涵盖的很多内容。在我们开始之前，你能花一分钟分享一下你的背景和你做过的一些精彩事情吗？让大家对你在销售领域的经验有个大致了解。

---

### (00:05:14) Pete Kazanjy

**English:**
I think probably the most important thing to characterize for folks is that I don't actually have a background in sales originally, which were most sales leaders and sellers come from, they graduate from school or a BDR, become an AE, AE manager, or a BDR manager, and then go on to sales leadership. My background's actually in product marketing and product management. I started my tech career at VMware back in the day, tons of amazing, fun VMware diaspora. And then I started a software company called TalentBin, it was a recruiting software company in, geez Louise, 2009. We quickly realized that, "Man, this B2B software stuff doesn't sell itself, irrespective of maybe what people say on the internet," at least back then. So, I had to be our first seller, our sales manager, our first sales leader, and that's where I learned how to do sales.

**中文翻译:**
我想对大家来说，最重要的一点是，我最初其实并没有销售背景。大多数销售领导者和销售人员都是从学校毕业后做 BDR（销售开发代表），然后成为 AE（客户经理）、AE 经理或 BDR 经理，最后进入销售领导层。我的背景实际上是产品市场（Product Marketing）和产品管理（Product Management）。我早年在 VMware 开始了我的科技职业生涯，那里有很多优秀的 VMware 离职创业者。然后在 2009 年（天哪，时间过得真快），我创办了一家名为 TalentBin 的招聘软件公司。我们很快意识到，“伙计，不管网上的人怎么说，B2B 软件这玩意儿是不会自己卖出去的”，至少当时是这样。所以我不得不成为我们的第一名销售、销售经理和第一位销售领导，这就是我学习如何做销售的开始。

---

### (00:06:02) Pete Kazanjy

**English:**
Also, I just realized, "Man, this isn't rocket surgery, anyone can learn this. If I can learn this, other people can learn this, even though there's not documentation on it." So, the software company was eventually acquired by Monster Worldwide in 2014 and then I wrote a book on sales for founders and other first-time sellers, it's called Founding Sales. Mainly, it was the book that I wish I had, rather than having to learn by a narrative from the first round capital portfolio and what have you. And then subsequent to that, I started what became the nation's largest sales operations and leadership community, it's called Modern Sales Pros. It's 30,000 sales operations, sales leaders, et cetera. And then started a new software company called Atrium that makes data-driven sales management software, and then here I am. So, I think a little bit about sales, turns out modern sales, not that old sales, modern sales.

**中文翻译:**
同时，我也意识到，“伙计，这又不是什么高深莫测的尖端技术（rocket surgery），任何人都能学会。如果我能学会，其他人也能学会，即使当时还没有相关的文档。”后来，这家软件公司在 2014 年被 Monster Worldwide 收购。接着我为创始人和初次接触销售的人写了一本关于销售的书，叫《创始人销售》。主要是因为我希望当时自己能有这样一本书，而不是非得通过 First Round Capital 的投资组合案例之类的东西去摸索。在那之后，我创办了后来成为全美最大的销售运营和领导力社区——Modern Sales Pros。它拥有 30,000 名销售运营人员、销售领导者等。然后又创办了一家名为 Atrium 的新软件公司，开发数据驱动的销售管理软件。这就是我的经历。所以我对销售有一点思考，结果证明是“现代销售”，不是那种老派销售，是现代销售。

---

### (00:06:59) Lenny

**English:**
Ooh, I'm curious to hear what that is. But before I ask you that question, I just wanted to mention your book, Founding Sales, is the book I give every founder that is trying to figure out sales. Every time I give it to them or point them to even your site that has it all for free there, they're always just like, "Holy shit, this is exactly what I needed," so we're going to be covering a lot of that stuff in our little chat.

**中文翻译:**
哦，我很想听听那是什么。但在我问你那个问题之前，我想提一下你的书《创始人销售》，这是我送给每一位试图摸索销售的创始人的书。每当我把它交给他们，或者引导他们去你的网站（那里有全部免费内容）时，他们总是会惊呼：“天哪，这正是我需要的。”所以我们在接下来的聊天中会涵盖很多这方面的内容。

---

### (00:07:20) Pete Kazanjy

**English:**
Rad.

**中文翻译:**
太棒了。

---

### (00:07:20) Lenny

**English:**
Can you actually just briefly talk about what is modern sales versus what you called traditional sales or old-school sales?

**中文翻译:**
你能简要谈谈什么是“现代销售”，以及它与你所说的“传统销售”或“老派销售”有什么区别吗？

---

### (00:07:25) Pete Kazanjy

**English:**
Oh, I just think that there's a little bit of a mindset change. It's a little bit related to some of the reasons why founders and other folks maybe have this perception of sales be like, "Ew, sales, ugh" because people, their only experience with sales is Glengarry Glen Ross or movies with a sleazy used car salesman and stuff like that, whereas the way to think about what sellers are is they're the microeconomic agents in the market that bring supply to demand rather than waiting for demand to find supply. They have supply in their back pocket and they run around trying to find people who ought to have the demand, maybe they have the demand right now, maybe they don't realize that they have the demand, and then they elucidate to them why they ought to have the demand.

**中文翻译:**
哦，我认为这主要是心态上的转变。这与创始人和其他人对销售的负面印象有关，比如“呃，销售，真讨厌”，因为人们对销售的唯一体验来自于电影《拜金一族》（Glengarry Glen Ross）或者那些描绘卑鄙二手车推销员的电影。而你应该这样理解销售人员：他们是市场中的微观经济代理人，负责将供应带给需求，而不是坐等需求来寻找供应。他们兜里揣着供应，四处奔走，寻找那些“应该有需求”的人——也许这些人现在就有需求，也许他们还没意识到自己有需求，然后销售人员向他们阐明为什么他们应该有这种需求。

---

### (00:08:08) Pete Kazanjy

**English:**
So, A, that process is very important from a technology deployment standpoint and also, B, it's very measurable, especially in a modern environment with modern CRMs and also all the digital activity that we do, email, calendar, phone, Zoom, et cetera, all this information is now being recorded such that you can then measure, manage, and improve behavior. So, very similar to how back in the day, you do product analytics by licking your fingers and sticking it in the wind, and then Mixpanels showed up, then Amplitude showed up, then so on and so forth, and the same is the case in sales, as well. So, modern sales is a more thoughtful, operational, rigorous, analytical bent, it's been around for a while. It's one of those things, the future is here, it just wasn't widely distributed, but now it's being much more distributed and much more embraced. Like the pre-Moneyball moment in sports and baseball to the post-Moneyball moment, we're now just flipping over there, so that's the delta.

**中文翻译:**
所以，第一，从技术部署的角度来看，这个过程非常重要；第二，它是高度可衡量的，尤其是在拥有现代 CRM 以及我们所有的数字化活动（电子邮件、日历、电话、Zoom 等）的现代环境中。所有这些信息现在都被记录下来，以便你可以衡量、管理和改进行为。这非常类似于以前你通过“舔手指试风向”来做产品分析，后来 Mixpanel 出现了，Amplitude 出现了，等等。销售领域也是如此。因此，现代销售更具思考性、运营性、严谨性和分析倾向，这种趋势已经存在一段时间了。这就像是“未来已来，只是分布不均”，但现在它正被更广泛地传播和接受。就像体育和棒球界从“前《点球成金》（Moneyball）时代”向“后《点球成金》时代”转变一样，我们现在正处于这个转折点，这就是差距所在。

---

### (00:09:17) Lenny

**English:**
Awesome. I definitely want to talk about ways to get better at sales and things you've learned about just how to improve at sales, but to set a little bit foundation for that conversation, I want to talk about founder-led sales. You touched on this topic, your book is basically named after this concept of founder-led sales. Can you talk about what that is, why it's so important, and maybe why founders often get this wrong?

**中文翻译:**
太棒了。我非常想聊聊提高销售能力的方法，以及你学到的关于如何改进销售的经验。但为了给对话打下基础，我想先聊聊“创始人主导的销售”（founder-led sales）。你提到了这个话题，你的书基本上就是以这个概念命名的。你能谈谈那是什么，为什么它如此重要，以及为什么创始人经常在这方面犯错吗？

---

### (00:09:37) Pete Kazanjy

**English:**
The way that I think about the book, Founding Sales, I like to think of it as the sequel to Eric Eric Ries's The Lean Startup or Steve Blank's Four Steps to the Epiphany or Startup Owner's Manual or whatever, where if you think about the stages, and this is all B2B, if you think about the stages that a product goes through, it's one, you've got to know what problem you're solving and validate that, and it's got to be real. It can't be like, "Oh, well, I thought I had this problem," it's got to be validated. That's customer development, that's customer research, and that's more of a product management function. And then there's building the minimum feature set in order to prove that maybe technology can fit to this problem and solve it.

**中文翻译:**
我对《创始人销售》这本书的看法是，我喜欢把它看作是 Eric Ries 的《精益创业》（The Lean Startup）或 Steve Blank 的《跨越鸿沟的四步》（Four Steps to the Epiphany）或《创业者手册》的续集。如果你思考一个产品经历的阶段（这全是针对 B2B 的），第一步是你必须知道你正在解决什么问题并验证它，而且它必须是真实的。不能只是“哦，我觉得我有这个问题”，它必须经过验证。那是客户开发，是客户研究，更多是产品管理的功能。然后是构建最小功能集，以证明技术可以适配并解决这个问题。

---

### (00:10:26) Pete Kazanjy

**English:**
That's how we create value as technologists, is piecing together technology and code or bits and atoms and what have you in order to solve a problem that people have. But then the next step is like, "Cool. Now, I've got to get someone to pay for this and I've got to do that in a reliable fashion and I've got to do it in a scalable fashion," and so there's a little bit of a loop there. It's not like, "The product's done, throw it over the wall, have fun, kids." It's a loop, where the minimum viable version of your product is probably going to suck and then in order to get to the minimum valuable step, you've got to be interfacing with a lot of customers and that's a sales behavior, getting in front of people and being like, "Hey, I think you probably have this problem if you look like these other folks right here."

**中文翻译:**
这就是我们作为技术人员创造价值的方式：将技术和代码，或者比特和原子结合起来，以解决人们面临的问题。但接下来的步骤是：“酷，现在我得让人为此付钱，而且我必须以可靠且可扩展的方式做到这一点。”所以这里有一个循环。这不像“产品做好了，扔过墙去，孩子们玩得开心点”。这是一个循环，你产品的最小可行版本（MVP）可能很烂，为了达到“最小价值”阶段，你必须与大量客户接触，这就是销售行为——走到人们面前说：“嘿，如果你看起来像这里的这些人，我想你可能有这个问题。”

---

### (00:11:11) Pete Kazanjy

**English:**
The point is is that you can't outsource that behavior, the founder's got to do that stuff. A lot of people ask me that question, "Well, I suck at sales," or, "I'm afraid to talk to people," or, "Interfacing with non-friendly parties makes me uncomfortable." The way to think about it is, I forget who the person was who said, "Startups versus incumbents is a race between can innovation get to distribution before distribution can get to innovation?" So, this is a related concept where as a founder, it's going to be way easier for you to get good, or minimally viable good, at selling by having interactions with non-friendly parties and having commercial conversations and asking for money in exchange for the value delivery.

**中文翻译:**
重点在于，你不能外包这种行为，创始人必须亲自做这些事。很多人问我：“可是我不擅长销售，”或者“我害怕和人说话，”或者“与不友好的人打交道让我不舒服。”你可以这样想（我忘了是谁说的了）：“初创公司与老牌企业的竞争是一场比赛：创新能否在分销渠道掌握创新之前先掌握分销渠道？”这是一个相关的概念。作为创始人，通过与不友好的人互动、进行商业对话并要求对方为价值交付付钱，让你在销售方面变得优秀（或者达到最低限度的优秀）要容易得多。

---

### (00:11:58) Pete Kazanjy

**English:**
It's going to be easier for you to do that than it is for some third party to become as expert at the subject matter that you're tackling that you are. Because as a founder, early on, use Atrium as an example, we make data-driven sales management software, which it exists to help sales managers and teams use metrics and data to improve the performance of their reps. The way I think about it is Datadog-y Amplitude-y, but for your sales reps. I'm probably the expert in sales analytics in the world, and so back in 2016 and 2017 when we were doing this, put aside the fact that I already know how to do minimum viable selling, if I had tried to get somebody else expert at that in order for them to go out and do that in the market, that would have been not good.

**中文翻译:**
让你自己学会销售，比让第三方变得像你一样精通你所解决的领域要容易得多。因为作为创始人，在早期（以 Atrium 为例），我们开发数据驱动的销售管理软件，旨在帮助销售经理和团队利用指标和数据来提高销售代表的业绩。我的理解是，它就像是针对销售代表的 Datadog 或 Amplitude。我可能是世界上销售分析方面的专家，所以在 2016 年和 2017 年我们做这件事时，撇开我已经知道如何进行最小可行销售这一事实不谈，如果我当时试图让别人也成为这方面的专家，好让他们去市场上销售，那效果肯定不好。

---

### (00:12:46) Pete Kazanjy

**English:**
This is why Steve Blank always talks about startups can't get to scale without firing their first VP of sales, it's oftentimes because they skip that step, and so the founder's like, "Hey, man, I'm going to pour a little bit of sales on this, hire some sales leader or whatever, some sort of seller, and outsource this." You really just can't do that, not for the first couple dozen customers, it's just not tenable. You lose that feedback loop, you lose the learnings of whether or not your message fits the market, all that sort of stuff. You're playing a game of telephone with that with a third party seller versus even you just want to keep that in one brain to start, then package it, and then when you have a repeatable while loop, a selling while loop, then package it and hand it to someone else. So, that's my diatribe on why founders have to do this.

**中文翻译:**
这就是为什么 Steve Blank 总是说，初创公司如果不解雇他们的第一任销售副总裁（VP of Sales）就无法实现规模化。这通常是因为他们跳过了那个步骤，创始人会想：“嘿，伙计，我要给这事儿加点销售料，雇个销售领导或者销售员，把这事儿外包出去。”你真的不能这么做，至少在最初的几十个客户阶段不行，这根本行不通。你会失去反馈闭环，失去关于你的信息是否契合市场的学习机会，诸如此类。你是在和第三方销售玩“传声筒”游戏，而你最初应该把这些信息留在自己的大脑里，然后将其打包。当你拥有一个可重复的“While 循环”（销售循环）时，再将其打包交给别人。这就是我对为什么创始人必须亲自做销售的长篇大论。

---

### (00:13:35) Lenny

**English:**
I was going to try to summarize the reasons that you should be doing this and it sounds like there's so many. One is figure out what you should actually be building, that's a reason founders should be selling, two is learn how to position and pitch and sell, three is figure out what you could teach your salesperson when you hire them. Is that a summary of why you should be selling as a founder for a while?

**中文翻译:**
我正想试着总结一下你为什么要这么做的原因，听起来原因太多了。第一是弄清楚你到底应该构建什么，这是创始人应该做销售的一个原因；第二是学习如何定位、推销和销售；第三是弄清楚当你雇佣销售人员时，你可以教给他们什么。这是对创始人为什么要亲自销售一段时间的总结吗？

---

### (00:13:55) Pete Kazanjy

**English:**
Yeah, for sure. One, it's going to help you with your product development because you're not going to have that abstracted, for sure, two, you're going to be the person who's going to figure out how to talk about it in an effective way, and then three, it's going to make it such that you can package that up such that other human... Because that's the way that B2B startups scale, is it's not WhatsApp or Twitter or Airbnb or whatever, where you have this scalability via marketing, the way that B2B organizations scale primarily is by adding more salespeople who then have customer-facing meetings with prospects.

**中文翻译:**
是的，没错。第一，它会帮助你进行产品开发，因为你不会脱离实际；第二，你会成为那个弄清楚如何以有效方式谈论产品的人；第三，它能让你把这些经验打包，让其他人也能……因为这就是 B2B 初创公司规模化的方式。它不像 WhatsApp、Twitter 或 Airbnb 之类的公司可以通过营销实现规模化，B2B 组织规模化的主要方式是增加更多的销售人员，由他们与潜在客户进行面对面的会议。

---

### (00:14:32) Pete Kazanjy

**English:**
And then you cap out with the number of hours that are in the week, there's only four or 50 hours in the week, especially as a seller because you interface with other people during business hours, and so the way that you scale up is by just adding more salespeople. So, that's why packaging that up is really important, because then you're going to shove it into the brains of two more salespeople, and then once they're successful, you're going to go to four, and then once they're successful, you're going to go to eight, and then once they're successful, you're going to go to 16.

**中文翻译:**
然后你会受限于每周的小时数，每周只有 40 或 50 个小时，尤其是作为销售人员，因为你必须在办公时间内与他人接触。所以你规模化的方式就是不断增加销售人员。这就是为什么“打包”非常重要的原因，因为接着你会把这些东西塞进另外两名销售人员的大脑里，一旦他们成功了，你就会增加到 4 人，然后是 8 人，再然后是 16 人。

---

### (00:15:00) Lenny

**English:**
You talk about this while loop concept, which I love. What are signs that it's time to hire your first salesperson? It begs the question, when do I do this?

**中文翻译:**
你谈到了这个“While 循环”的概念，我很喜欢。那么，有哪些迹象表明是时候雇佣第一名销售人员了？这引出了一个问题：我该什么时候做这件事？

---

### (00:15:10) Pete Kazanjy

**English:**
I'm not a software engineer, but I like to use technical metaphors with technical audiences because I think it's helpful, so it's like when it runs on your local, now it's time to see if it reproduces over here, so if it reliably runs on your local and it doesn't air out, so then what would the definition of not erroring out look like? So, generally speaking, it is to contingent on your sales motion, but it's going to be that you can reliably, at a pretty okay win rate, so maybe 15% or 20% or 25%, turn first meetings into eventual customers and do that in a reliable fashion. It's not like, "I engaged 10 arms-length parties and I got two customers closed." It's like, "Hey, that's great. That's a good start. 5X that, 10X that."

**中文翻译:**
我不是软件工程师，但我喜欢对技术受众使用技术比喻，因为我觉得这很有帮助。这就像是当程序在你的“本地环境”运行成功后，现在是时候看看它是否能在“生产环境”复现了。如果它在本地运行可靠且没有报错，那么“不报错”的定义是什么呢？一般来说，这取决于你的销售动作（sales motion），但标准应该是：你能以一个相当不错的胜率（比如 15%、20% 或 25%），可靠地将初次会议转化为最终客户。这不只是“我接触了 10 个陌生客户，成交了两个”。而是“嘿，这很棒。这是一个好的开始。把它扩大 5 倍，扩大 10 倍”。

---

### (00:16:08) Pete Kazanjy

**English:**
Take 50 at-bats, take 100 at-bats, and now that you know that you reliably, for every cohort of ten first meetings, what's known in sales land as opportunities, for every cohort of 10 that you engage, are you closing 1, are you closing 1.5, are you closing 2, or are you closing 2.5, if you're in there? But if you're at like, "For every 30 I interact with, I close one," well, it seems like that's probably pretty inefficient, unless you're selling $500,000 deals or something like that. So, it's at the point where it feels like it's statistically significant, it feels like it's repeatable, because what you're going to then do is now it feels like it's a safe bet to try to abstract that out to somebody else.

**中文翻译:**
尝试 50 次“击球”（at-bats，指尝试机会），尝试 100 次。现在你知道，对于每 10 次初次会议（在销售领域被称为“机会”），你是否能成交 1 个、1.5 个、2 个或 2.5 个？如果你能达到这个水平，那就不错。但如果你是“每接触 30 个才成交 1 个”，那看起来效率相当低，除非你卖的是 50 万美元的大单。所以，当它感觉具有统计学意义且可重复时，尝试将其抽象化并交给别人就是一个稳妥的赌注了。

---

### (00:16:54) Pete Kazanjy

**English:**
Because the only way we're going to get to success is we're not going to have Lenny go and sell from morning, noon to night. What we're going to do is we're going to take the information out of Lenny's brain and we're going to put it into slides and we're going to put it into scripts and we're going to put it into email templates and all that sort of stuff, and then we're going to shove that into the brain of two more reps and see if now we can get it to run in the cloud, in the sales cloud here. And then to start out, it may fail, the same way you're like, "Cool, it runs on my local. Uh-oh, it breaks over here. Why?" And then that's the next stage is now you're figuring out how to get those other folks to sell as successfully as you have, and that becomes the next job.

**中文翻译:**
因为我们获得成功的唯一途径不是让 Lenny 从早到晚不停地卖。我们要做的，是从 Lenny 的大脑中提取信息，把它们放入幻灯片、话术脚本、邮件模板等等，然后把这些东西塞进另外两名销售代表的大脑里，看看现在能否让它在“销售云”中运行。刚开始可能会失败，就像你会说：“酷，它在本地运行正常。哎呀，在这里崩了。为什么？”接下来的阶段就是弄清楚如何让那些人像你一样成功地销售，这就是下一项工作。

---

### (00:17:39) Pete Kazanjy

**English:**
Actually, this is the presentation I gave at Brianne's SaaS School, if you Google it's just called Founder-led Selling, it's available online. Essentially, there's a bunch of stages in the B2B maturity journey and you have to go through them in order to get to the next one, if you jump stages, you're hosed. So, in this case, if you know that you can reliably sell this yourself, that's great. Then, the next thing to do is get at least a couple people reliably selling, as well as you, not 10, because you're never going to get 2 successful if you're trying to onboard 10 concurrently. And then if you get those 2 successful, now you've earned the right to go to 4, 8, et cetera.

**中文翻译:**
实际上，这就是我在 Brianne 的 SaaS 学校做的演讲，如果你去谷歌搜索，它就叫《创始人主导的销售》，网上可以找到。本质上，B2B 成熟之旅有很多阶段，你必须经历这些阶段才能进入下一个阶段，如果你跳过阶段，你就完蛋了。在这种情况下，如果你知道自己可以可靠地销售，那很好。接下来的事情是让至少几个人像你一样可靠地销售——是几个人，不是 10 个，因为如果你试图同时带 10 个人，你永远无法让其中 2 个获得成功。一旦你让那 2 个人成功了，你就赢得了扩展到 4 人、8 人等的权利。

---

### (00:18:21) Lenny

**English:**
I love this heuristic that you shared that you want to get to about 15 to 25% of contacts closing to a customer. I see you shaking your thumb. I think that's really useful. So, it's a bit less than a third and doing 50 to 100 attempts is roughly where you want to be?

**中文翻译:**
我喜欢你分享的这个启发式标准：大约 15% 到 25% 的联系人最终转化为客户。我看到你在竖大拇指。我觉得这非常有用。所以大约是不到三分之一的转化率，并且进行 50 到 100 次尝试，这就是你想要达到的目标？

---

### (00:18:39) Pete Kazanjy

**English:**
Yeah. Importantly, what you don't want to do is, and I think probably a lot of the product managers who like to listen to Lenny's Podcast here might appreciate this, is you want to bring on cohorts of users and then see what's going on, then learn, and then bring on new co cohorts of users. So, going and doing 100 at-bats and then being like, "Did it work or did it not?" Versus, "Hey, let's have 10 for prospect and try to get 10 first meetings," have all those interactions, see how your conversations land, see how the discovery questions are evoking the right response or not the right response, see how your slides land, see how your demo lands, all that sort of stuff.

**中文翻译:**
是的。重要的是，你不想做的是（我想很多喜欢听 Lenny 播客的产品经理可能会理解这一点）：你想引入一批用户，看看发生了什么，然后学习，再引入新的一批用户。这不像是一口气做 100 次尝试，然后问“成功了吗？”而是“嘿，让我们找 10 个潜在客户，尝试获得 10 次初次会议”，进行所有这些互动，看看你的谈话效果如何，看看你的“需求挖掘”（discovery）问题是否引起了正确的反应，看看你的幻灯片效果如何，看看你的演示（demo）效果如何，诸如此类。

---

### (00:19:15) Pete Kazanjy

**English:**
If it's working well and you're getting to the next stage, "This is great, I would love to introduce you to my boss," that's a good sign. If it's like, "I'm just not getting it." Cool, back to the drawing board, versus doing 100 all at once and being like, "Now, did it work?" We want to break it up and then constantly just be iterating, iterating, iterating. Again, I think your audience might appreciate this, the way to think of a sales motion, so sales motion is a fancy-pants way of describing just all the things that you do in order to take a prospect and bring them through the sales process and then eventually close them. One helpful way to think about it is kind of like software and what you want to be doing is constantly updating it. Oh, that was a really interesting question that the prospect asked right there, I didn't have a good answer for it and moreover, I didn't have a slide for it.

**中文翻译:**
如果进展顺利，你进入了下一个阶段，对方说“这太棒了，我想把你介绍给我的老板”，这就是一个好迹象。如果对方说“我还是不太明白”，那好，回到绘图板重新设计，而不是一次性做 100 个然后问“现在行了吗？”我们要把它拆开，然后不断地迭代、迭代、再迭代。同样，我想你的听众可能会喜欢这个：理解“销售动作”（sales motion）的方式——销售动作是一个花哨的词，描述的是你为了引导潜在客户完成销售过程并最终成交所做的一切。一个有用的思考方式是把它看作软件，而你想要做的就是不断更新它。比如，“哦，潜在客户刚才问了一个非常有趣的问题，我没有好的回答，而且我也没有相关的幻灯片。”

---

### (00:20:04) Pete Kazanjy

**English:**
You know what I should do? I should make a slide that handles that objection so I can show it to them visually and also, it'll help give me guardrails and a talk track and that'll be nice. So, I'm going to do that and then I'm going to update the source code. Now, my sales motion has been updated. And then the next loop through, ideally the next time that person says, "Oh, I don't know, Lenny, it doesn't really sound like X, Y, Z," you're like, "Oh, a lot of people say that, but here, if you look over here, you can see this." "Oh yeah, that's a really good point." "Wonderful. So, as the next step, let's go ahead and talk to your boss." So, now your sales motion has been updated and the collateral's been updated and now, we're being more effective sellers. You're just going to do that dozens and dozens and dozens and dozens and dozens of time before you have a repeatable sales motion.

**中文翻译:**
“你知道我该怎么做吗？我应该做一张幻灯片来处理那个异议，这样我就可以直观地展示给他们看，而且它还能为我提供引导和话术，那太好了。所以我要去做那张幻灯片，然后更新‘源代码’。”现在，我的销售动作已经更新了。在下一次循环中，理想情况下，下次有人说“哦，我不知道，Lenny，这听起来不太像 X、Y、Z”时，你会说：“哦，很多人都这么说，但你看这里，你可以看到这个。”“哦是的，这确实是个好点子。”“太棒了。那么下一步，让我们和你的老板谈谈吧。”所以，现在你的销售动作更新了，宣传材料更新了，现在我们成了更有效的销售人员。在拥有一个可重复的销售动作之前，你只需重复这样做几十次、几百次。

---

### (00:20:55) Lenny

**English:**
What's interesting is with this heuristic, two-thirds of the time, it's not going to work out.

**中文翻译:**
有趣的是，按照这个启发式标准，三分之二的情况下是行不通的。

---

### (00:20:59) Pete Kazanjy

**English:**
Nope.

**中文翻译:**
没错。

---

### (00:21:00) Lenny

**English:**
So, a lot of times, they're going to be like, "Ah, I don't get this, leave me alone." Is there other leading indicators that tell you that you're improving, knowing that only a third or maybe a fifth of the time it'll work out? Is it talking to the boss off more often, what else do you look for?

**中文翻译:**
所以很多时候，他们会说：“啊，我不明白，别烦我。”既然知道只有三分之一甚至五分之一的情况下能成功，还有没有其他“领先指标”（leading indicators）能告诉你你正在进步？是更频繁地见到对方老板吗？你还会看什么？

---

### (00:21:13) Pete Kazanjy

**English:**
Yeah, exactly. Totally. So, what are the leading indicators of success? Because if you're only looking at lagging indicators, again, it's probably a it's a funnel on a new feature, so the opportunity is an at-bat or a potential transaction, and so usually what you do is you model out the stages in your opportunity. So, generally, there will be different stages depending on the sales motion. So, use Atrium as an example, we sell on customer data. It takes five minutes to turn on an Atrium account, it's really helpful for folks. They just sign in, they OAuth with Salesforce, great. So, a really important stage in our sales motion is, we call it data light, has data been lit up? So, that's a stage, we have a discovery stage, we have a data light stage, we have what we call a preview stage, are we previewing it with the staff? Then, we get to a commercial discussion.

**中文翻译:**
是的，没错。完全正确。那么成功的领先指标是什么呢？因为如果你只看滞后指标（lagging indicators），那就太晚了。这就像新功能的漏斗，每一个“机会”就是一次尝试或潜在交易，通常你会为机会建模出不同的阶段。根据销售动作的不同，通常会有不同的阶段。以 Atrium 为例，我们基于客户数据进行销售。开启一个 Atrium 账户只需五分钟，这对人们很有帮助。他们只需登录，通过 Salesforce 进行 OAuth 授权，搞定。所以我们销售动作中一个非常重要的阶段，我们称之为“数据点亮”（data light）——数据是否已经接入？这是一个阶段。我们还有需求挖掘阶段、数据点亮阶段，以及我们所谓的“预览阶段”——我们是否正在与员工一起预览它？然后，我们进入商业讨论阶段。

---

### (00:22:08) Pete Kazanjy

**English:**
So, you can measure how you're getting to those stages, which is somebody lands on whatever page that Lenny was in charge of at Airbnb and did they click on the right thing and do they get to the next thing and did they get to the next thing, get to the next thing? So, in sales, it's kind of the same thing. So, the more sophisticated version of this is looking at stage conversions, what have you, the less sophisticated version of it, which early on, I think is an appropriate way of doing it, is like, "Hey, man, are we getting second dates?" So, just metaphorize it to Hinge or Coffee Meets Bagel or whatever the more recent one is, it's like, "Are we getting the second dates? Are we getting the third dates? Because if we're not getting the second dates, probably something's amiss there."

**中文翻译:**
所以你可以衡量你是如何到达这些阶段的，就像有人登陆了 Lenny 在 Airbnb 负责的某个页面，他们是否点击了正确的东西，是否进入了下一步，再下一步？在销售中，情况也是一样的。更高级的版本是查看阶段转化率（stage conversions）等等；而初级版本（我认为在早期这是很合适的方式）就像是：“嘿，伙计，我们约到第二次见面了吗？”把它比作 Hinge 或 Coffee Meets Bagel（约会软件）之类的，“我们有第二次约会吗？有第三次约会吗？因为如果我们连第二次约会都约不到，那肯定哪里出问题了。”

---

### (00:22:51) Pete Kazanjy

**English:**
So, what we want to do is we want to say, "Great, of all of our ten first meetings, how many gets to second meetings?" It would be great, the lagging indicator is 2 wins out of 10 or what have you, but I'm going to come into these conversations and out of my ten first meetings, I want seven of them to get to the second meeting. And then of those seven, maybe I want 4.5 of them to get to the third meeting, and then ultimately, I want 2 or 3 to win. That's the way to think about that, those are the leading indicators. So, as those conversions get better like, "Man, I'm not getting any second dates. Oh, okay, cool, you need a haircut or you need a shower," and the same applies to your sales motion, as well. Your message is not landing, you're targeting the wrong people, what's going on here? You need to think about it.

**中文翻译:**
所以我们要做的就是说：“太好了，在我们所有的 10 次初次会议中，有多少次进入了第二次会议？”滞后指标可能是 10 个里面赢了 2 个，但在这些对话中，我希望 10 个初次会议里有 7 个能进入第二次会议。在那 7 个中，也许我希望有 4.5 个进入第三次会议，最终我希望有 2 到 3 个成交。这就是思考方式，这些就是领先指标。当这些转化率变好时，就像是：“天哪，我约不到第二次约会。哦，好吧，酷，你需要理个发或者洗个澡。”这同样适用于你的销售动作。你的信息没有打动人，你找错了人，到底发生了什么？你需要思考。

---

### (00:23:42) Lenny

**English:**
You need a better pickup line.

**中文翻译:**
你需要更好的搭讪开场白。

---

### (00:23:43) Pete Kazanjy

**English:**
There you go. Now, you're not even getting first dates, man, go all the way up to you need a better Hinge profile picture. You're just not getting any matches, ew.

**中文翻译:**
没错。现在你甚至连第一次约会都约不到，伙计，甚至得追溯到你需要一张更好的 Hinge 个人资料照片。你根本没有匹配成功，额。

---

### (00:23:55) Lenny

**English:**
As a founder, do you have to get good at sales? A lot of founders are like, "Oh my God, we're going to do PLG. We're going to be self-serve, freemium, we don't need sales. I'm just going to let people figure it out." Is it a requirement of a B2B business to get good at sales as a founder?

**中文翻译:**
作为创始人，你必须擅长销售吗？很多创始人会想：“天哪，我们要走 PLG（产品驱动增长）路线。我们要走自助服务、免费增值模式，我们不需要销售。我只要让人们自己去摸索就行了。”作为创始人，擅长销售是 B2B 业务的必然要求吗？

---

### (00:24:11) Pete Kazanjy

**English:**
I would say you don't have to get good at it, you just have to get non-zero at it. There's this really great article on Lenny's newsletter on adding a sales organization to a self-serve product that Lenny had me write and then he edited the heck out of it, and it's really a fantastic asset. But what I would say there is that there are a lot of PLG or self-serve motions out there that they've stagnated themselves because they didn't add the sales piece to it. I would encourage people to read that article, I forget what it's called, you added a really cool name.

**中文翻译:**
我会说你不需要变得非常精通，你只需要做到“非零”水平。Lenny 的时事通讯中有一篇非常棒的文章，是关于如何给自助服务产品增加销售组织的，那是 Lenny 让我写的，然后他进行了大量的编辑，那真的是一份极好的资产。但我想说的是，有很多 PLG 或自助服务模式的公司因为没有加入销售环节而陷入停滞。我鼓励大家去读那篇文章，我忘了叫什么名字了，你起了一个很酷的名字。

---

### (00:24:47) Lenny

**English:**
Oh, The Transition: Layering on Sales to Product-led Growth.

**中文翻译:**
哦，《转型：在产品驱动增长之上叠加销售》（The Transition: Layering on Sales to Product-led Growth）。

---

### (00:24:51) Pete Kazanjy

**English:**
See, you're good at naming things.

**中文翻译:**
看吧，你很擅长起名字。

---

### (00:24:54) Lenny

**English:**
That's inspired by David Sack's The Cadence, which I love for how to operate.

**中文翻译:**
那是受 David Sacks 的《节奏》（The Cadence）启发，我非常喜欢他关于运营的方式。

---

### (00:24:58) Pete Kazanjy

**English:**
There you go. That is a great article. So, it's not that you have to be great, you just have to recognize that it's important. A good example of this would be, probably the most famous example of an organization that maybe didn't get sales religion as quickly as they should have would be Dropbox. Dropbox has phenomenal early sales leadership. One of our investors here at Atrium is a gentleman named Mike Marg, he's a partner at Craft Ventures, he was an early sales manager and leader there, Kyle Parrish was the head of sales at Figma, Marissa Fuhrer is over at Figma, as well. There's all these just absolutely fantastic Dropbox folks, but the problem was is that the organization, from a product standpoint, never put all as many calories behind product development that would support the ability to sell to across an entire organization.

**中文翻译:**
没错。那是一篇很棒的文章。所以，并不是说你必须变得很伟大，你只需要意识到它很重要。一个很好的例子，也许是由于没有像应有的那样迅速确立“销售信仰”而最著名的组织，就是 Dropbox。Dropbox 早期拥有非凡的销售领导力。我们在 Atrium 的一位投资者 Mike Marg 先生是 Craft Ventures 的合伙人，他曾是那里的早期销售经理和领导者；Kyle Parrish 曾是 Figma 的销售负责人，Marissa Fuhrer 现在也在 Figma。这些从 Dropbox 出来的人都非常优秀，但问题在于，从产品的角度来看，该组织从未在产品开发上投入足够的精力，以支持向整个组织进行销售的能力。

---

### (00:25:48) Pete Kazanjy

**English:**
So, the way that I try to succinctly describe that is never mistake your lead gen for your business. I think the good news is that a lot of people took a lot of lumps there and folks have learned that, maybe Slack almost missed that, but then they brought in a bunch of Salesforce folks and other folks, actually, Mike Marg was also an early sales manager at Slack, as well, and really got a religion around that. Because it turns out that people paying 19 bucks a month or 29 bucks a month or what have you is really great, but getting to a $50,000 or a $100,000 or a $250,000 contract, that's where big ARR numbers start racking up, and organizations want to talk to a human in order to navigate that.

**中文翻译:**
所以，我试着用简洁的语言来描述：永远不要把你的“线索生成”（lead gen）误认为是你的业务。我认为好消息是很多人在那方面吃过亏，大家已经吸取了教训。也许 Slack 差点也错过了这一点，但后来他们引入了一群来自 Salesforce 的人和其他人。实际上，Mike Marg 也是 Slack 的早期销售经理，并在那里真正确立了销售信仰。因为事实证明，人们每月支付 19 美元或 29 美元确实很棒，但要达到 5 万、10 万或 25 万美元的合同，那才是大额 ARR（年度经常性收入）开始累积的地方，而组织需要与人交流才能完成这种规模的交易。

---

### (00:26:34) Pete Kazanjy

**English:**
So, PLG is great for landing and permeating an organization and there's a bunch of great... Craft invests in this like crazy, so Scratchpad is a great example of very bottoms-up. Atrium's pretty bottoms up, as well. It's like, I don't know, what is the Silicon Valley joke, middle out or whatever, because we land with sales managers and SDR managers. What you're doing is you're solving the problem that the user has, but the problem is the user doesn't necessarily have large budgetary authority, so you can get them stoked up, but then you've got to talk to the person who's got the purse strings, and so that's going to require sales. That's okay.

**中文翻译:**
所以，PLG 对于进入和渗透一个组织非常有效，有很多优秀的例子……Craft Ventures 在这方面投入了大量资金，比如 Scratchpad 就是一个非常典型的自下而上（bottoms-up）的例子。Atrium 也是相当自下而上的。这就像是（我不知道硅谷那个笑话怎么说）“由内而外”（middle out）之类的，因为我们是从销售经理和 SDR 经理开始切入的。你所做的是解决用户面临的问题，但问题是用户不一定拥有巨大的预算审批权，所以你可以让他们兴奋起来，但接着你必须与掌握财权的人谈谈，这就需要销售了。这没问题。

---

### (00:27:13) Lenny

**English:**
Just to punctuate that, basically 100% of B2B companies end up building a sales team?

**中文翻译:**
简单总结一下，基本上 100% 的 B2B 公司最终都会建立销售团队？

---

### (00:27:20) Pete Kazanjy

**English:**
I would say that's the case. It's more of a question of when versus if, so even the really famous ones like Atlassian. Atlassian, they had a sales organization, they just didn't call it a sales organization and they went pretty far without a lot, but instead what they did was they just priced the product breathtakingly low. I think developer tools can oftentimes do this, where because developers are pretty technical, they can adopt product, they don't need handholding in order to adopt a product that is complicated enough to be valuable. Datadog's a good example or New Relic or AppD, but even those guys very early on had meaningful sales organizations. There's a lot of reasons why Datadog ended up winning that market, but their sales organization is no joke. Even developer tools, you might think, cool, well, the developers can just swipe their credit cards. Yeah, they can, but then you're going to be eventually capped there. Look at Snowflake. Snowflake has, I don't know, 500 salespeople, you're going to need a sales org.

**中文翻译:**
我会说是这样的。这更多是“什么时候建”而不是“要不要建”的问题。即使是像 Atlassian 这样著名的公司也是如此。Atlassian 也有销售组织，只是他们不叫这个名字，而且他们在没有太多销售人员的情况下走得很远，但他们做的是把产品价格定得低得惊人。我认为开发者工具经常可以这样做，因为开发者技术水平很高，他们可以自行采用产品，不需要手把手的指导就能使用那些足够复杂且有价值的产品。Datadog、New Relic 或 AppDynamics 都是很好的例子，但即使是这些公司，在很早期就拥有了相当规模的销售组织。Datadog 最终赢得市场有很多原因，但他们的销售组织绝非儿戏。即使是开发者工具，你可能觉得“酷，开发者直接刷信用卡就行了”。是的，他们可以，但最终你会遇到瓶颈。看看 Snowflake，Snowflake 有，我不知道，大概 500 名销售人员。你肯定需要一个销售组织。

---

### (00:28:28) Lenny

**English:**
Let's shift a bit to talking about just how to get better at sales, at the scale of sales. I think it's interesting because you don't have a sales background and so you've had to learn how to do this and you did a lot of research and building your business, you've had to get really good at sales. So, maybe a first question, what's the number one tip that you have for getting better at sales?

**中文翻译:**
让我们转向聊聊如何提高销售能力，以及销售的规模化。我觉得这很有趣，因为你没有销售背景，所以你必须学习如何做这件事，你做了大量的研究并建立了你的业务，你必须变得非常擅长销售。所以，第一个问题，你对于提高销售能力的第一条建议是什么？

---

### (00:28:50) Pete Kazanjy

**English:**
The first chapter of Founding Sales talks about what I call sales mindset changes. Because I think the big thing is it's just so weird, it's just such a weird shift in behavior. Because if you think about it as a product manager or as an engineer or whatever, how many people do you interact with day-to-day? Oh, 6, 10 maybe.

**中文翻译:**
《创始人销售》的第一章谈到了我所谓的“销售心态转变”。因为我认为最重要的一点是，这真的很奇怪，这是一种非常奇怪的行为转变。因为如果你以产品经理或工程师的身份去思考，你每天会和多少人互动？哦，6 个，也许 10 个。

---

### (00:29:10) Lenny

**English:**
Not too many.

**中文翻译:**
不太多。

---

### (00:29:11) Pete Kazanjy

**English:**
It's always the same people and so it's super comfortable, whereas in sales or anything customer facing, what ends up happening is you're meeting multiple new humans every day, if you're doing it right, and that just is such a mindset shift. You're not going to be able to remember everybody. You're going to have to write it all down. You're going to have to use the CRM for that. You're in the starting blocks on the track. You're in the starting blocks and you have 90 seconds or a couple minutes to form rapport, to make somebody feel like they should trust you and they want to be honest with you. You have to be very focused on activity orientation, whereas engineering and product management, there's does a lot of super deep work.

**中文翻译:**
而且总是那几个人，所以非常舒服。而在销售或任何面向客户的工作中，如果你做得对，结果就是你每天都要见好几个陌生人，这完全是一种心态上的转变。你不可能记住所有人。你必须把一切都记下来。你必须为此使用 CRM。你就像在田径场的起跑器上。你在起跑线上，只有 90 秒或几分钟的时间来建立融洽关系（rapport），让对方觉得他们应该信任你，并愿意对你诚实。你必须非常专注于活动导向，而工程和产品管理则有很多超深度的思考工作。

---

### (00:29:52) Pete Kazanjy

**English:**
It's like Paul Graham's Maker versus Manager Schedule. Salespeople have manager schedules, interestingly enough, where what you're doing is you're constantly contact switching, an ideal salesperson's calendar or a founder who's doing sales is 2, 3, 4, maybe 5 customer-facing meetings a day with different humans. And then moreover, then you're having incremental interactions with those folks later on, like later that week or the next week or what have you, so then you have to keep continuity of these multiple parallel conversations. It's a totally different set of skills and so it feels super weird to start out, but what ends up happening is it's just a skill. You just start doing it, you start doing it, you start doing it, and you just become used to it, you become calloused. You're like, "I'm incorrigible now. You put me in an elevator, I can talk to anyone."

**中文翻译:**
这就像 Paul Graham 说的“创作者时间表 vs 管理者时间表”。有趣的是，销售人员拥有的是管理者时间表，你所做的是不断地进行上下文切换。一个理想的销售人员或正在做销售的创始人的日历上，每天会有 2、3、4 甚至 5 场与不同人的客户会议。而且，你稍后还要与这些人进行后续互动，比如在那周晚些时候或下周，所以你必须保持这些多个并行对话的连续性。这是一套完全不同的技能，所以刚开始会觉得超级奇怪，但结果是，这只是一项技能。你只要开始做，不断地做，你就会习惯它，变得“老练”了。你会觉得：“我现在已经‘无可救药’（厚脸皮）了。你把我放进电梯里，我能和任何人聊天。”

---

### (00:30:43) Pete Kazanjy

**English:**
So, one, just recognizing it's going to be a pretty big mindset change, and then the second thing you can do is then once you know that there's going to be a mindset change, is you can focus in on making those behaviors be better. So, as an example, one of the things I challenge my staff to do is I call it turbo rapport, it needs a better name. But think about people that you interact with in the world who maybe are a little shields up, they're probably used to interacting with people who are not going to be super nice to them, maybe it's bartenders or a flight attendant or a barista, or fill in the blank. Think about how quickly you can become friends with them, how you can break that down, because that's going to be a really good skill for you to have when you're interacting with a prospect.

**中文翻译:**
所以，第一，要意识到这将是一个巨大的心态转变；第二，一旦你知道会有心态转变，你就可以专注于改进这些行为。例如，我要求员工做的一件事，我称之为“涡轮增压式融洽关系”（turbo rapport），它需要一个更好的名字。但想想你在世界上接触到的人，他们可能有点戒备心，他们可能习惯了与那些对他们不太友好的人打交道，也许是酒保、空乘人员或咖啡师等等。想想你能多快和他们成为朋友，如何打破那层隔阂，因为当你与潜在客户互动时，这将是一项非常有用的技能。

---

### (00:31:31) Pete Kazanjy

**English:**
And then what that's going to allow you to do is then ask them candid questions about their current situation that either, A, they may know about or, B, you ask provocative questions that make them think about the world in a way maybe that you want them to and realize that they have pain they didn't want or didn't know that they had. My friend, Brett Burson, had this great tweet one at one point where he said, "Think about the things that you do in your day-to-day that are like a pianist, like a piano player, playing scales like, 'Da, da, da, da, da, da.' What is the version of that for selling?" That's rapid rapport building, asking good questions, asking follow-up questions, being willing to ask uncomfortable questions, all those sort of things, and asking for money and then shutting up and waiting for them to answer, all these are very uncomfortable things, but the more you do them, you'll just get good at them.

**中文翻译:**
然后，这将允许你针对他们的现状提出坦诚的问题，要么是他们已经知道的，要么是你提出挑衅性的问题，让他们以你希望的方式思考世界，并意识到他们拥有自己不想要或以前没意识到的痛点。我的朋友 Brett Burson 曾发过一条很棒的推文，他说：“想想你日常做的事情中，哪些像钢琴家练音阶一样，‘哒、哒、哒、哒、哒、哒’。销售领域的‘练音阶’是什么？”那就是快速建立融洽关系、提出好问题、提出后续问题、愿意问令人不快的问题，以及要求对方付钱然后闭嘴等待回答。所有这些都是非常令人不舒服的事情，但你做得越多，就会越擅长。

---

### (00:32:31) Lenny

**English:**
This episode is brought to you by Merge. Every product manager knows the pain of slowing product velocity when developers struggle to build and maintain integrations with other platforms. Merge's Unified API can remove this blocker from your roadmap. With one API, your team can add over 150 HR, ATS, accounting, ticketing, and CRM integrations right into your product. You can get your first integration into production in a matter of days and save countless weeks building custom integrations, letting you get back to building your core product. Merge's integrations speed up the product development process for companies like Ramp, Drata, and many other fast-growing and established companies, allowing them to test their features at scale without having to worry about a never-ending integrations roadmap. Save your engineers countless hours and expedite your sales cycle by making integration offerings your competitive advantage with Merge. Visit merge.dev/lenny to get started and integrate up to five customers for free.

**中文翻译:**
本期节目由 Merge 赞助。每位产品经理都知道，当开发人员费力地构建和维护与其他平台的集成时，产品开发速度会变慢，这非常令人痛苦。Merge 的统一 API 可以从你的路线图中移除这个障碍。通过一个 API，你的团队可以将超过 150 个 HR、ATS（招聘管理系统）、会计、票务和 CRM 集成直接添加到你的产品中。你可以在几天内将第一个集成投入生产，节省数周构建自定义集成的时间，让你重新专注于构建核心产品。Merge 的集成为 Ramp、Drata 以及许多其他快速增长和成熟的公司加速了产品开发过程，让他们能够大规模测试功能，而无需担心永无止境的集成路线图。通过 Merge 将集成服务转化为你的竞争优势，为你的工程师节省无数小时并缩短销售周期。访问 merge.dev/lenny 开始使用，并免费为最多五个客户提供集成。

---

### (00:33:31) Lenny

**English:**
One of the things in your book that most shifted my mindset on sales was this shift from you're trying to convince someone to buy this thing to you're trying to help them and maybe this will make their life easier. Can you talk a bit about that?

**中文翻译:**
你书中有一点最能转变我对销售的看法，那就是从“试图说服某人买这个东西”转变为“试图帮助他们，也许这会让他们的生活更轻松”。你能谈谈这个吗？

---

### (00:33:44) Pete Kazanjy

**English:**
I think this is like the, remember the modern sales versus old-school sales thing?

**中文翻译:**
我觉得这就像是，还记得现代销售与老派销售的区别吗？

---

### (00:33:44) Lenny

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### (00:33:50) Pete Kazanjy

**English:**
The old-school sales thing is like, "I'm going to sell something to a mark," or the best example of this, "That guy's a great sales guy, he can sell ice to an Eskimo." It's like, "Man, if you're selling ice to an Eskimo, you're an asshole. What is wrong with you? They don't need ice," unless they're visiting Southern California. So, as a seller, the way that I like to frame it to people is that you're a consultant that has a particular predilection for a given solution, your solution. Use Atrium as an example. Atrium's minimum ICP is probably SDRs plus AEs in an organization should probably be at 10 all the way up to 300. So, if someone shows up and they're like, "Man, I've got to get really good at sales, I need to buy your software, Pete," and I'm like, "Cool. How many salespeople do you have?" They're like, "I have one." I'll be like, "Man, I'm not going to sell you Atrium. You're just going to be unhappy, it's going to be dumb, it's going to be a waste of our customer success resources, you're going to churn," all those sort of things.

**中文翻译:**
老派销售就像是“我要把东西卖给一个冤大头”，或者最好的例子是“那家伙是个伟大的销售员，他能把冰卖给爱斯基摩人”。我想说：“伙计，如果你把冰卖给爱斯基摩人，你就是个混蛋。你有什么毛病？他们不需要冰，”除非他们正在南加州旅游。所以，作为销售人员，我喜欢向人们这样表述：你是一个对特定解决方案（即你的解决方案）有特殊偏好的顾问。以 Atrium 为例，Atrium 的最小 ICP（理想客户画像）大概是一个组织中的 SDR 加上 AE 应该在 10 到 300 人之间。所以，如果有人跑来说：“伙计，我必须把销售做得很好，我需要买你的软件，Pete，”我会问：“酷，你有多少销售人员？”如果他们说：“我有一个。”我会说：“伙计，我不会把 Atrium 卖给你。你只会感到不开心，这很愚蠢，会浪费我们的客户成功资源，你最终会流失，”诸如此类。

---

### (00:34:56) Pete Kazanjy

**English:**
But if instead what you're doing is you're saying, "Hey, I'm going to go out in the market and I'm going to find the people that have a high proclivity that our technology solves and then I'm going to talk with them about how they're solving that problem right now, and ideally, through a series of questions, I'm going to reveal that to them that they're doing it probably not great. And then once I've revealed to them the fact, through this directed questioning, what's known as discovery, that they have this high magnitude problem, that it is causing them lots of money, that it is a pain in their ass, and then I reveal to them that there is a better way of approaching it and magically enough, I happen to be a representative of that solution," well, now that's an ideal transaction and everybody wins. And then scale that up across an entire economy and you can see why I was saying that sales is the grease that makes the economy work like that and also importantly, brings new technology to the market in a way that makes everything better.

**中文翻译:**
但相反，如果你做的是：“嘿，我要去市场上寻找那些极有可能需要我们技术来解决问题的人，然后我会和他们聊聊他们现在是如何解决那个问题的。理想情况下，通过一系列问题，我会向他们揭示他们现在的做法可能并不好。一旦我通过这种定向提问（即所谓的‘需求挖掘’）向他们揭示了他们面临着巨大的问题，这个问题让他们损失了很多钱，让他们很头疼，然后我再向他们揭示有一种更好的处理方式，而且神奇的是，我恰好是那个解决方案的代表，”那么，这就是一笔理想的交易，双赢。然后把这种模式推广到整个经济体系中，你就能明白为什么我说销售是让经济运转的润滑剂，而且更重要的是，它以一种让一切变得更好的方式将新技术推向市场。

---

### (00:36:01) Lenny

**English:**
If someone's listening to this and they're like, "I want to get better at sales, what's one thing I could do differently tomorrow, this week, to improve my ability to sell my product?" What would that be?

**中文翻译:**
如果有人正在听这个，他们想：“我想提高销售能力，明天或这周我可以做哪一件不同的事情来提高我销售产品的能力？”那会是什么？

---

### (00:36:12) Pete Kazanjy

**English:**
There's the non-complicated version and there's the complicated version. The non-complicated version would just be just walking down the street, make eye contact with everybody, and then every person that you stop next to at Starbucks or the crosswalk or whatever, just strike up a conversation with them, figure out a mechanism by which you can start a conversation with them. Compliment their shirt or their shoes or remark on something. Don't use the weather, because that's lazy, but figure that out, so that's the first version. Probably the more sophisticated version is just be very, very tight on your ICP, just be very, very, very crisp around who has your problem and why. Being more crisp around that and then having that understood is a great way of making sure that you're not wasting time on people who don't have your problem and that you're doing more of those loops with people who are right in the white-hot center. So, one is a behavioral thing and one is a more thoughtful thing.

**中文翻译:**
有一个简单版和一个复杂版。简单版就是走在街上，与每个人进行眼神交流，然后在星巴克或人行横道等地方停在某人身边时，就试着和他们搭讪，找个由头开始对话。赞美他们的衬衫或鞋子，或者对某事发表评论。不要聊天气，因为那太懒惰了，去想个办法。这是第一个版本。更高级的版本是：非常、非常严格地界定你的 ICP（理想客户画像），非常清晰地明确谁面临你的问题以及为什么。更清晰地界定并理解这一点，是确保你不会在没有该问题的人身上浪费时间的好方法，并确保你与那些处于“白热化中心”的人进行更多的循环。所以，一个是行为层面的，一个是思考层面的。

---

### (00:37:07) Lenny

**English:**
That's great. Can you actually explain ICP briefly, because a lot of people may not know that term?

**中文翻译:**
太棒了。你能简要解释一下 ICP 吗？因为很多人可能不知道这个术语。

---

### (00:37:11) Pete Kazanjy

**English:**
Thank you. So, ICP stands for Ideal Customer Profile. Actually, it's important to think about there's two things in a B2B sales motion, there's the characteristics of the account, which is the company that's going to buy, and then there's the characteristics of the human and the personas that you're going to be interacting with. Let's use Amplitude as an example. Amplitude's ICP would probably be organizations that make software products, that probably have at least a couple of product managers, because if there's a single product manager, it might be too much, they might be at the point where they don't need a full-blown enterprise analytics suite, and that's probably it. And then on the human side, who are the people who participate in that conversation? Well, the product managers are going to be the ones who are going to be the users, but engineering is probably involved in order to make sure that Amplitude can talk to the cloud data warehouse and so on and so forth, and then moreover, the person who owns the budget might be the VP of product, not the product manager, or it might be the VP of engineering or the CTO.

**中文翻译:**
谢谢。ICP 代表“理想客户画像”（Ideal Customer Profile）。实际上，在 B2B 销售动作中思考两件事很重要：一是“账户”特征，即要购买的公司；二是“人”的特征，即你要互动的角色（personas）。以 Amplitude 为例，Amplitude 的 ICP 可能是开发软件产品的组织，且可能至少有几个产品经理。因为如果只有一个产品经理，可能规模太小，还没到需要全套企业级分析套件的程度。这就是 ICP。而在人的方面，谁会参与对话？产品经理将是使用者，但工程部门可能也会参与，以确保 Amplitude 能与云数据仓库通信等等。此外，拥有预算的人可能是产品副总裁（VP of Product）而不是产品经理，或者是工程副总裁或 CTO。

---

### (00:38:18) Pete Kazanjy

**English:**
So, those three different folks that we talked about there, it's different humans. Ideal customer profile is understanding what those parameters look like for looking at an organization in order to say, "Man, that's an awesome op, let's go get in front of them," versus, "Eh, I don't know if that's a very good opportunity, maybe let's pass on that," and then the personas are, "Great, that's an awesome op right there. I know that I'm going to have my first conversation with Lenny, but with an intention that I'm eventually going to get to the VP of product at Airbnb, and that's Suzy over here. And then once we get validation from her, then I know that the VPE over here is Frank," and knowing who the personas are. So, that's what ICP and personas are.

**中文翻译:**
所以，我们谈到的这三类人是不同的。理想客户画像是理解一个组织的参数看起来是什么样的，以便说：“伙计，那是一个极好的机会（op），让我们去接触他们，”或者说：“呃，我不知道那是不是个好机会，也许我们该跳过。”而“角色”则是：“太好了，那是个绝佳的机会。我知道我要先和 Lenny 进行第一次谈话，但我的意图是最终接触到 Airbnb 的产品副总裁，也就是那边的 Suzy。一旦我们得到她的认可，我就知道这边的工程副总裁是 Frank。”这就是 ICP 和角色的含义。

---

### (00:39:06) Lenny

**English:**
Awesome. There's a template that you've created that helps you lay out your ICP, so we'll try to link to it in the show notes. I have to find it again.

**中文翻译:**
太棒了。你创建了一个模板来帮助规划 ICP，我们会尝试在节目介绍中附上链接。我得再去把它找出来。

---

### (00:39:13) Pete Kazanjy

**English:**
Nice. Sounds good.

**中文翻译:**
好极了，听起来不错。

---

### (00:39:15) Lenny

**English:**
So, we've talked about founder-led sales and how founders should be starting sales, we've talked about just how to get better at sales as a founder, as anyone. I want to talk now about hiring salespeople.

**中文翻译:**
我们已经聊过了创始人主导的销售，以及创始人应该如何开始销售，也聊过了作为创始人或任何人如何提高销售能力。现在我想聊聊招聘销售人员。

---

### (00:39:27) Pete Kazanjy

**English:**
Sure.

**中文翻译:**
当然可以。

---

### (00:39:28) Lenny

**English:**
Great mug, by the way, Coffee is for Closers. I love it. Can people buy that online or is that just a one-off?

**中文翻译:**
顺便说一下，你的马克杯很棒，“咖啡是给成交者喝的”（Coffee is for Closers）。我很喜欢。大家能在网上买到吗，还是说这是独一份的？

---

### (00:39:36) Pete Kazanjy

**English:**
This is a Modern Sales Pros mugs. I think we have a bunch of Yetis that we give away for Atrium, as well, but we're big onto sales jokes here because you have to... We stole this from New Relic, being very user-centric in your swag, so I've got my Sales Nerds jacket on here, I've got my Let's Get It hat here, I've got my Coffee is for Closers mug. These are all inside sales jokes that maybe your audience won't necessarily get, or maybe they will, but our audience very much gets them. They're like, "Oh man, your hat's so funny. Can you send me one?" I'm like, "No problem. You should buy our software."

**中文翻译:**
这是 Modern Sales Pros 的马克杯。我想我们还有一堆为 Atrium 准备的 Yeti 杯子作为赠品。我们这里很喜欢销售笑话，因为你必须……我们是从 New Relic 那里学来的，在周边产品（swag）上要非常以用户为中心。所以我穿着我的“销售宅男”（Sales Nerds）夹克，戴着我的“开干吧”（Let's Get It）帽子，拿着我的“咖啡是给成交者喝的”马克杯。这些都是销售圈内的笑话，也许你的听众不一定能懂，或者也许能懂，但我们的受众非常懂。他们会说：“噢伙计，你的帽子太逗了。能送我一个吗？”我会说：“没问题，你应该买我们的软件。”

---

### (00:40:11) Lenny

**English:**
Love it. So, hiring salespeople, we've talked a bit about a lot of these things, like maybe when it's time to hire a salesperson when you're closing a fourth or fifth of your opportunities when this while loop is kicking in. So, in terms of the who to find for this first sales role, and you mentioned that VP of sales are often let go, it's a very high rate of not working out, is that true?

**中文翻译:**
太喜欢了。那么，关于招聘销售人员，我们已经聊了一些，比如什么时候该招人——当你能成交四分之一或五分之一的机会，当这个“While 循环”开始运转时。那么，关于第一个销售职位该找谁，你提到销售副总裁（VP of Sales）经常被解雇，失败率很高，是真的吗？

---

### (00:40:33) Pete Kazanjy

**English:**
Yeah. Again, this is mapped out in the Founder-led Selling presentation and then also in Founding Sales, the book. Generally, what you want to do is you probably don't want to start with a VP of sales to start, a sales leader, and there's a couple of reasons why there. Even if you figured it out yourself, that's required, you have to get to that minimum sufficiency of 10, 20, 30 customers yourself first. But then the reason why I advocate for folks to hire a couple of sellers or a couple of AEs to start is because, again, you have that software in your brain. Unfortunately, there is no GitHub for sales motions, and so it's in your brain, it's in your documents, et cetera, and so now, you're going to teach these other folks. So, what you want to do is you want to hire a couple early-stage pioneer sellers to take that sales motion.

**中文翻译:**
是的。同样，这在《创始人主导的销售》演讲和《创始人销售》这本书中都有详细说明。通常情况下，你可能不想一开始就招一个销售副总裁或销售领导，原因有几个。即使你已经自己摸索清楚了（这是必须的，你必须先自己搞定最初的 10、20、30 个客户），但我主张先雇佣几个销售员或 AE 的原因是：再次强调，那套“软件”在你的大脑里。不幸的是，销售动作没有 GitHub，它在你的脑子里，在你的文档里等等，所以现在你要去教这些人。因此，你想雇佣几个早期的“开拓型销售”（pioneer sellers）来承接这套销售动作。

---

### (00:41:30) Pete Kazanjy

**English:**
The downside of seeking to hire a VP of sales or a head of sales, or what have you, who actually is a head of sales is coming out of an organization where maybe he or she is a manager of managers or manages eight reps or something like that, is that person hasn't been selling for a hot second. I think actually Jason Lemkin had a pretty funny tweet about this the other day where he was like, "Hiring the VP of sales who's been there and done that before, why exactly does she want to do it again?" Like, "Oh, you scaled up a Datadog or Figma or whatever, you should come to my crappy little startup," it's like, "I'm professionally rich." So, instead, the great folks to look at are the deputies or those early-stage sellers.

**中文翻译:**
雇佣一个真正的销售副总裁或销售负责人的弊端在于，他或她可能来自一个大型组织，在那里他可能是“经理的经理”，或者管理着 8 名销售代表之类的，那个人已经很久没有亲自上阵销售了。我想 Jason Lemkin 前几天发过一条很有趣的推文，他说：“雇佣一个‘曾经辉煌过’的销售副总裁，她到底为什么要再做一遍？”就像是：“哦，你把 Datadog 或 Figma 之类的规模做大了，你应该来我这个烂烂的小初创公司，”对方会想：“我已经功成名就（财富自由）了。”所以，相反，你应该关注的是那些“副手”或那些早期阶段的销售人员。

---

### (00:42:18) Pete Kazanjy

**English:**
So, the example I always use here, my last software company was in recruiting, so if you have a new recruiting technology, my buddy, Troy, runs this recruiting software company called Guide. They make this really cool, guided, hey, hiring process for candidates, whatever, but they sell to recruiting organizations. So the early-stage sellers that he would be interested in would probably be early people at Lever or Greenhouse who sell to the same persona, probably around the same average selling price, but ideally, not an AE who joined Greenhouse last year or two years ago.

**中文翻译:**
我常举的一个例子是：我的上一家软件公司是做招聘的。如果你有一项新的招聘技术，比如我的哥们 Troy 经营着一家名为 Guide 的招聘软件公司。他们做的是非常酷的候选人引导招聘流程，他们卖给招聘组织。那么他感兴趣的早期销售人员可能是 Lever 或 Greenhouse 的早期员工，他们向相同的角色销售，平均售价也差不多。但理想情况下，不要找去年或两年前才加入 Greenhouse 的 AE。

---

### (00:42:59) Pete Kazanjy

**English:**
Greenhouse just has a phenomenal sales organization, their sales leadership is absolutely fantastic, the gentleman who's the CRO over there is a good friend of mine, Sean Murray. But early-stage selling takes early-stage sellers or people who have been there, because you're not going to have all the collateral, slides and scripts and whatever aren't going to be all buttoned up and with a bow around them, and so looking for those early-stage, grimier, grittier sellers is a more effective way of going about that. Those are the folks that you want to look for once you've gotten to that statistical significance of your own selling capacity.

**中文翻译:**
Greenhouse 拥有非凡的销售组织，他们的销售领导层非常出色，那里的 CRO Sean Murray 是我的好朋友。但早期销售需要早期销售人员或经历过那个阶段的人，因为你还没有所有的宣传材料，幻灯片、话术脚本之类的还没准备得那么完美。所以寻找那些能吃苦、有韧劲的早期销售人员是更有效的方法。一旦你自己的销售能力达到了统计学上的显著水平，你就要找这样的人。

---

### (00:43:37) Lenny

**English:**
To make that just even clearer, the suggestion is if you're, say, a Series A founder, what's a profile of a person you look for? You said it's a deputy at a successful sales org?

**中文翻译:**
为了更清楚一点，你的建议是，如果你是一个 A 轮创始人，你会寻找什么样的人？你说是成功销售组织的副手？

---

### (00:43:48) Pete Kazanjy

**English:**
I'll give you a couple examples. I don't know, say you're doing some sort of design tool, I would go look at the Figma sales organization and I would look at some of the earlier sellers who were there maybe two years ago or three years ago or what have you, maybe you could consider getting a sales manager there who's not super far from selling. A great example of this is there's this woman, Marissa Fuhrer, who works at Figma, she's absolutely fantastic. She works on the enterprise team there and she was at Dropbox previously as a seller for a long time.

**中文翻译:**
我给你举几个例子。比如你在做一个设计工具，我会去看看 Figma 的销售组织，找找两三年前就在那里的早期销售人员，或者你可以考虑找一个离一线销售还不算太远的销售经理。一个很好的例子是 Figma 的 Marissa Fuhrer，她非常出色。她在企业团队工作，之前在 Dropbox 做了很长时间的销售。

---

### (00:44:24) Pete Kazanjy

**English:**
She would be a great profile for someone who's not too far from having sold and is willing to roll up her sleeves, but ideally, that would probably be the person who you'd want to hire after you've hired those couple of sellers and gotten them to success. Because the other thing, too, with Marissa, she's probably going to look at your organization and be like, "Cool. Prove to me that your product fits the market, because I don't want to necessarily take a bet on you," and then you would say, "Well, in addition to having a 25% win rate with me, I have these two sellers right here and they both have 20% win rates and you can see that they're both closing $50,000 of bookings a month, all I need you to do is scale it up." In which case, that early stage head of sales is like, "Let's do it."

**中文翻译:**
她就是一个非常理想的人选：离一线销售不远，且愿意卷起袖子干活。但理想情况下，这应该是你在雇佣了那几个销售员并让他们获得成功之后才去雇佣的人。因为像 Marissa 这样的人，她可能会看着你的公司说：“酷，向我证明你的产品契合市场，因为我不一定想在你身上下注。”然后你会说：“好吧，除了我自己的胜率是 25% 之外，我还有这两个销售员，他们的胜率都是 20%，你可以看到他们每月的签约额都是 5 万美元，我只需要你来把规模做大。”在这种情况下，那位早期销售负责人就会说：“干吧！”

---

### (00:45:10) Lenny

**English:**
She's about to get a bunch of LinkedIn requests.

**中文翻译:**
她估计要收到一大堆 LinkedIn 好友请求了。

---

### (00:45:13) Pete Kazanjy

**English:**
She's great. This is one of the things that we really love at Atrium, is we have really great customers. We're creating a new category of software and so it's one of those things where more advanced, more modern sales managers and leaders really get it, that's how it always is in category creation. But when you find the people who really get it and really get it, they turn out to be awesome. That's one of the things that just makes startups fantastic.

**中文翻译:**
她很棒。这也是我们在 Atrium 非常喜欢的一点：我们拥有非常棒的客户。我们正在创建一个新的软件类别，所以那些更先进、更现代的销售经理和领导者真的能理解它，品类创建（category creation）向来如此。当你找到那些真正懂行的人时，结果会非常棒。这就是让初创公司变得迷人的原因之一。

---

### (00:45:40) Lenny

**English:**
What's a sign that maybe it's not working out when you hire your either first salesperson or maybe first five, what are signs? Because you said it often does not work out, what are early signals like, "We should rethink this"?

**中文翻译:**
当你雇佣第一名销售人员或者前五名销售人员时，有哪些迹象表明可能行不通？因为你说过这经常失败，那么有哪些早期信号提示“我们应该重新考虑”？

---

### (00:45:56) Pete Kazanjy

**English:**
This is another reason why it's really important to do it yourself to start, but presuming that you've been able to close business on a reliable basis, again, with arm's length prospects, it can't be Lenny's mother-in-law buying my software-

**中文翻译:**
这是为什么最初必须亲自做销售的另一个重要原因。但假设你已经能够可靠地成交业务（再次强调，是与陌生潜在客户成交，不能是 Lenny 的岳母买我的软件——）

---

### (00:46:13) Lenny

**English:**
Huge fan, for real, actually, she is.

**中文翻译:**
她是你的超级粉丝，真的，她是。

---

### (00:46:17) Pete Kazanjy

**English:**
God bless, but she's not ICP for Atrium. This is the danger of doing revenue trades in your accelerator or whatever, it's not real. So, if you have done that and you've sold 20 or 30 deals, you know it can be done, we have an existence proof of this. So, if someone else can't do it the way that you do it, and this is why hiring two folks to start is effective, you don't want to hire just one, maybe three, but four, it's like, "Ugh, that's a lot to manage," at least to start. So, if you have done that and the person, their win rates are poor or their activity levels are poor, things like that, those are usually indicators that it's not work out, that they're not getting those second dates, they're not getting those third dates, but importantly, they have to have the materials in question.

**中文翻译:**
上帝保佑，但她不是 Atrium 的 ICP。这就是在加速器里做“收入互换”之类的危险所在，那不是真实的。所以，如果你已经卖出了 20 或 30 单，你就知道这事儿能成，我们有了存在性证明。如果别人不能像你那样做成，（这就是为什么开始时雇两个人很有效，你不想只雇一个，也许三个，但四个就太多了，很难管理），如果那个人胜率很低，或者活动量（activity levels）很低，这些通常是行不通的迹象——他们约不到第二次、第三次见面。但重要的是，他们必须拥有所需的材料。

---

### (00:47:11) Pete Kazanjy

**English:**
Did you create the slide deck? Did you take people through and did you give it to them? Did you take all the discovery questions that were in your brain and write them down into a Google Doc or a Notion page or what have you? Do you have a demo script for them? If those things are not present, then probably no one's going to be successful, or at least they're going to have to rederive all that stuff that you already did. But if you have all those precursors and it's not sticking for someone, that's probably a good leading indicator that they're not going to work out

**中文翻译:**
你做幻灯片了吗？你带他们演练过并交接给他们了吗？你把你脑子里所有的需求挖掘问题都写进 Google Doc 或 Notion 页面了吗？你有演示脚本吗？如果这些东西都不存在，那么可能没人会成功，或者至少他们必须重新推导你已经做过的一切。但如果你具备了所有这些前提条件，而某人还是做不成，那这就是一个很好的领先指标，表明他们不合适。

---

### (00:47:38) Lenny

**English:**
How much time do you give these folks before you make a decision?

**中文翻译:**
在做决定之前，你会给这些人多少时间？

---

### (00:47:42) Pete Kazanjy

**English:**
This is why it's so, so, so important to look at leading indicators. This is something that we just think about all the time here at Atrium, from a instrumentation and data-driven sales management, is if someone's not having customer-facing meetings, if they're low activity, you're never going to win anything. If you have a 50% win rate on two opportunities in a month, that's probably still not going to be super helpful unless you have a very, very, very high deal size. So, looking at those leading indicators like, "Are they having first meetings? Are they having second meetings? What does their email volume look like? Are they progressing things through, are they getting things to proposal, and then eventually, are things closing?"

**中文翻译:**
这就是为什么观察领先指标非常、非常、非常重要的原因。这是我们在 Atrium 一直在思考的事情，从工具化和数据驱动的销售管理角度来看：如果有人没有进行客户会议，如果他们的活动量很低，你永远赢不了任何单子。如果你一个月只有两个机会，即便胜率是 50%，除非你的单价极高，否则也没什么用。所以要看这些领先指标：“他们有初次会议吗？有第二次会议吗？他们的邮件量如何？他们是否在推进流程，是否进入了提案阶段，最终是否成交？”

---

### (00:48:24) Pete Kazanjy

**English:**
I do a bunch of masterclasses for Atrium on data-driven sales management and one of them is on ramping. It's called Ramping For Success, I forget the name of the masterclass, but looking at those leading indicators like opportunity inflow, "Is a person putting meetings on their calendar, are they progressing them? Are they being active in the meantime?" Those are all really good leading indicators. If somebody's not getting first meetings on the calendar, you know within a month, it's like, "Cool, this isn't working out."

**中文翻译:**
我为 Atrium 举办了一系列关于数据驱动销售管理的专家课，其中一门是关于“爬坡”（ramping，指新销售进入状态的过程）。它叫《爬坡成功》，我忘了具体名字了，但要看那些领先指标，比如机会流入量，“这个人是否在日历上安排了会议，他们是否在推进这些会议？在此期间他们是否活跃？”这些都是很好的领先指标。如果有人一个月内都没在日历上排上初次会议，你就知道：“酷，这行不通。”

---

### (00:48:54) Pete Kazanjy

**English:**
Now, if they're not getting to second or third meetings, but they are getting those first meetings, well, now you know you've got a different problem, which they're getting those first dates, but they're not getting a second date and they're not getting a second date the same way that you were, maybe that's a coaching issue or maybe it's just a behavioral problem that's that you're not going to be able to surmount. But the point is having instrumentation on the most leading indicator possible gives you eyes onto whether or not things are working or not and you can make judgements fast, because the worst possible situation is nine months in, you're like, "Man, it's not working." It's like, "Man, I bet if you looked at the leading indicators, you would have known two months in this wasn't working."

**中文翻译:**
现在，如果他们能约到第一次会议，但约不到第二次或第三次，那么你就知道遇到了不同的问题：他们能约到“第一次约会”，但约不到第二次，或者约不到像你那样成功的第二次约会。这可能是辅导（coaching）问题，也可能是你无法克服的行为问题。但重点是，对尽可能靠前的领先指标进行监测，能让你看清事情是否进展顺利，并能快速做出判断。因为最糟糕的情况是九个月后你才说：“伙计，这行不通。”其实，如果你看了领先指标，你可能在两个月的时候就知道这行不通了。

---

### (00:49:33) Lenny

**English:**
I like that you gave us a bottom end of the range like, "In a month, you should be able to know, a lot of times." What would be the max by which like, "If things are going okay, by six months, it's probably going to be good," or what is that timeframe?

**中文翻译:**
我喜欢你给出的时间范围下限，比如“很多时候，一个月你就该知道了”。那么上限是多少？比如“如果进展顺利，到六个月时可能就稳了”，那个时间框架是什么？

---

### (00:49:46) Pete Kazanjy

**English:**
Oh, where you know you're successful?

**中文翻译:**
哦，你是说什么时候能确定成功？

---

### (00:49:48) Lenny

**English:**
Yeah. It sounds like maybe from a month to some future month, this is a period where you can get a sense of this person is going to work out. What's that range, in your mind?

**中文翻译:**
是的。听起来从一个月到未来的某个月，这是一个你可以感觉到这个人是否合适的时期。在你心目中，这个范围是多少？

---

### (00:49:58) Pete Kazanjy

**English:**
It's almost like you're continuously monitoring. In the first month, maybe you spend that time onboarding the rep, teaching them, going through mock discovery conversations, mock demos, et cetera, having them ride along with you. In the second month, we would expect them to have 10 first meetings or maybe 20 first meetings and we would expect 50% of those to get to the second meetings, and we would measure those things. In the third month, we would expect some subset of those first meetings and second meetings that happened in the second month to get to a proposal, to get to a commercial conversation, and then maybe we would expect some of the deals in that month to close to win, or maybe the next month.

**中文翻译:**
这几乎就像是你一直在持续监控。在第一个月，你可能花时间带销售代表入职，教导他们，进行模拟需求挖掘对话、模拟演示等，让他们跟着你学习。在第二个月，我们期望他们有 10 次或 20 次初次会议，并期望其中 50% 能进入第二次会议，我们会衡量这些。在第三个月，我们期望第二个月发生的那些初次和二次会议中的一部分能进入提案阶段，进入商业谈判，然后也许我们期望那个月或下个月能有一些交易成交。

---

### (00:50:38) Pete Kazanjy

**English:**
It's essentially like you're looking at the leading indicators in the appropriate timeframe, such that if someone is in month three and they're getting a bunch of their deals to proposal, you can't declare victory yet because the money is not in the bank, however things are looking good. So, if you get to month four and lots of things are getting to proposal, but nothing's closing in month four and nothing's closing in month five, you still can't say "Olly olly oxen free," you should still be very concerned. But if the leading indicator is at the right level for the right period or right interval in ramp, then you can feel confident, but not declare victory yet.

**中文翻译:**
本质上，你是在合适的时间框架内观察领先指标。如果某人在第三个月已经有很多交易进入了提案阶段，你还不能宣布胜利，因为钱还没到账，但情况看起来不错。如果到了第四个月，很多交易都在提案阶段，但第四个月没成交，第五个月也没成交，你仍然不能说“大功告成”，你仍然应该非常担心。但如果领先指标在爬坡期的正确阶段处于正确水平，你可以感到有信心，但还不能宣布胜利。

---

### (00:51:20) Lenny

**English:**
Got it. Something that this is reminding me of is we are chatting ahead of this call and you mentioned that working from home is really bad for salespeople, in your experience. Can you talk about that?

**中文翻译:**
明白了。这让我想起我们在通话前聊到的，你提到根据你的经验，居家办公对销售人员非常不利。你能谈谈这个吗？

---

### (00:51:31) Pete Kazanjy

**English:**
It's primarily bad for junior salespeople. Senior salespeople have been selling out in what's known as the field for a long time, but when you think about the behavior that we're talking about, which is learning, so what needs to happen? The new sellers, they need to learn the sales motion and then they need to be audited, instrumented, so the faster the loops are on that, the better off you're going to be. If the loops are once a day of listening to their calls or maybe even a longer interval, then just the correction loops are just going to be way too slow, versus if you're sitting next to somebody or you're sitting amongst three or four people and listening to all their calls concurrently and then they get off of a call and it's like, "Hey, that was really good, correction here, correction here, correction here, correction here. Here, run it back to me."

**中文翻译:**
这主要对初级销售人员不利。资深销售人员已经在所谓的“外勤”（field）销售了很长时间。但当你思考我们正在讨论的行为——即学习——时，需要发生什么？新销售需要学习销售动作，然后需要被审计和监测，所以反馈循环越快，效果就越好。如果反馈循环是每天听一次他们的通话录音，甚至间隔更长，那么纠偏循环就太慢了。相比之下，如果你坐在某人旁边，或者坐在三四个人中间，同时听他们所有的通话，当他们挂断电话时，你可以说：“嘿，刚才那段很棒，这里要改，那里要改，这里再调一下。来，跟我演练一遍。”

---

### (00:52:28) Pete Kazanjy

**English:**
Now, the loops, the speed with which you're able to update their software and make sure that the sales motion is running appropriately on them, is quite high. In early-stage startups, that's the only thing that matters, it's a race against time to make sure that you get to success, so you can raise your next round of financing or get to profitability or what have you, and so having asynchronous distance is really problematic for that, especially for junior folks, like SDRs, junior AEs, all of that, it really is problematic. Once that sales motion is baked and can be distributed, that's potentially a different situation, but very early on, having someone being able to sit side-by-side with your sellers, t's hard to beat.

**中文翻译:**
现在，你更新他们“软件”并确保销售动作在他们身上正确运行的速度非常快。在早期初创公司，这是唯一重要的事情——这是一场与时间的赛跑，以确保你获得成功，从而可以进行下一轮融资或实现盈利。因此，异步的距离感对此非常不利，尤其是对于 SDR、初级 AE 等初级人员。一旦销售动作成熟并可以大规模分发，情况可能会有所不同，但在非常早期，能有人与销售人员并肩而坐，这种优势是难以逾越的。

---

### (00:53:17) Lenny

**English:**
So, what's the solution, if you're starting, now, a B2B company, your advice is, "Don't be remote, work in an office"?

**中文翻译:**
那么解决方案是什么？如果你现在创办一家 B2B 公司，你的建议是“不要远程办公，去办公室工作”？

---

### (00:53:25) Pete Kazanjy

**English:**
My point of view on that is, especially at early stage, from a founder's standpoint, being shoulder-to-shoulder with your co-founders certainly, but even a founder who has a couple of sellers that they're working with, being side-by-side with them in order to help them learn faster, teach them more, have accountability, and then have training loops is really what you need to do. Because the alternative is there's a whole generation of SDRs who are, it's kind of like learning loss, if you will, there's a bunch of 24 year olds who have never learned the skills that are needed at the same way, at the same clip, that they would have sitting amongst 10 others with an SDR manager sitting in the middle of them, or an AE manager sitting in the middle of them.

**中文翻译:**
我的观点是，尤其是在早期阶段，从创始人的角度来看，当然要与联合创始人并肩作战，但即使是拥有几个销售员的创始人，也应该与他们坐在一起，以帮助他们学得更快，教给他们更多，建立问责制，并建立培训循环。因为另一种情况是，整整一代 SDR 正在经历某种“学习损失”——有一群 24 岁的年轻人，他们从未像坐在 10 个人中间、中间坐着 SDR 经理或 AE 经理那样，以同样的方式、同样的节奏学到所需的技能。

---

### (00:54:20) Lenny

**English:**
Any last pieces of wisdom before we get to a very exciting lightning round?

**中文翻译:**
在进入非常令人兴奋的闪电轮问答之前，还有最后的智慧分享吗？

---

### (00:54:24) Pete Kazanjy

**English:**
I think probably the biggest thing is, the thing that I just like to encourage founders and product managers and what have you, is just don't be afraid of sales. There's a lot of people out there who would love to tell you a story that it's magical or like, "Oh, you've got to be a born seller," or things like that and it's really not. Those people are just talking their book, if you will, and so just getting good at those behaviors, it's going to benefit you in a myriad of ways. Even if you don't want to necessarily be an early-stage founder, even as a product manager within an enterprise organization or even a consumer organization, selling behaviors and good communication and persuasion and always thinking about what's in it for them, et cetera, those are really good skills for internal selling, for external selling, if you want to interface with customers, et cetera. All these skills are very important and impactful for a myriad of personas.

**中文翻译:**
我认为最重要的一点是，我只想鼓励创始人、产品经理等所有人：不要害怕销售。外面有很多人喜欢把销售说得很神奇，或者说“你必须天生就是个销售”，其实不然。那些人只是在自说自话。只要掌握了这些行为，你将在无数方面受益。即使你不想成为早期创始人，即使只是在企业组织甚至消费品组织中担任产品经理，销售行为、良好的沟通和说服力、始终思考“这对他们有什么好处”等等，这些对于内部推销、外部销售、与客户打交道等都是非常好的技能。所有这些技能对各种角色都非常重要且有影响力。

---

### (00:55:19) Lenny

**English:**
Amazing. Well, with that, we've reached the very exciting lightning round. I've got five questions for you, we're going to go through it pretty fast. Are you ready?

**中文翻译:**
太棒了。那么，我们进入了非常令人兴奋的闪电轮。我有五个问题要问你，我们会进行得很快。准备好了吗？

---

### (00:55:27) Pete Kazanjy

**English:**
I am.

**中文翻译:**
准备好了。

---

### (00:55:28) Lenny

**English:**
Question one, what are two or three books that you recommend most to other people?

**中文翻译:**
第一个问题，你最推荐给别人的两三本书是什么？

---

### (00:55:33) Pete Kazanjy

**English:**
The books that I recommend the most, there would be The Goal by Eli Goldratt. There are two books that inspired Atrium, one is the Goal, which is essentially is a novelization of the Toyota lean manufacturing system, so it's a process engineering book written as a novel, it's really fantastic. Sales organizations are just revenue factories, so if you want to think about systems thinking and processes, but in a way that's not a textbook, it's absolutely fantastic.

**中文翻译:**
我最推荐的书是 Eli Goldratt 的《目标》（The Goal）。有两本书启发了 Atrium，一本就是《目标》，它本质上是丰田精益生产系统的虚构小说化，是一本写成小说的流程工程书籍，非常精彩。销售组织其实就是收入工厂，所以如果你想以非教科书的方式思考系统思维和流程，这本书绝对棒极了。

---

### (00:56:01) Pete Kazanjy

**English:**
And then the other one is a book by Bill Walsh called The Score Takes Care of itself. Bill Walsh is a really famous football coach for the Stanford Cardinals and the San Francisco 49ers and he just broke down how you can't worry about the score in the football game, you can only worry about the things that are in front of you, that you can control, and that if you do a high quantity of high-quality actions, whatever your position is, as a quarterback or a linebacker running back or whatever, then the score will take care of itself. That's very applicable to sales, as well, if you focus on those leading indicators and make sure that you're doing it in a high quantity of high quality way, then the score will take care of itself. So, those are two great books I like to recommend to folks.

**中文翻译:**
另一本是 Bill Walsh 的《比分自然会水到渠成》（The Score Takes Care of Itself）。Bill Walsh 是斯坦福红衣主教队和旧金山 49 人队非常著名的橄榄球教练。他阐述了你不能担心橄榄球比赛的比分，你只能担心眼前你能控制的事情。如果你完成了大量高质量的动作（无论你的位置是四分卫、线卫还是跑卫），比分自然会水到渠成。这也非常适用于销售：如果你专注于那些领先指标，并确保以高质量、高频率的方式执行，那么业绩（比分）自然会好。这是我喜欢推荐给大家的两本好书。

---

### (00:56:41) Lenny

**English:**
Favorite other podcasts?

**中文翻译:**
喜欢的其他播客？

---

### (00:56:42) Pete Kazanjy

**English:**
Oh boy, I don't listen to too many. I listen to Lenny's and I listen to the All-In Podcast, just so I can get my fill of doom and gloom.

**中文翻译:**
噢天哪，我不怎么听播客。我听 Lenny 的，还听 All-In 播客，只是为了听听那些悲观论调。

---

### (00:56:52) Lenny

**English:**
And knowledge, with this one. Favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
还有这一期的知识。最近有什么非常喜欢的电影或电视节目吗？

---

### (00:56:57) Pete Kazanjy

**English:**
I've got a five-year-old, so we're all Disney all the time, so I think probably the one that's been on repeat recently has been Encanto. There you go.

**中文翻译:**
我有一个五岁的孩子，所以我们一直都在看迪士尼。我想最近一直在循环播放的是《魔法满屋》（Encanto）。就是这个。

---

### (00:57:07) Lenny

**English:**
Love that one. Favorite interview question that you like to ask folks?

**中文翻译:**
我也喜欢那个。你最喜欢问别人的面试问题是什么？

---

### (00:57:12) Pete Kazanjy

**English:**
So, I'm going to change this up on you, it's less about interview questions. One of the things I'm a really big fan of is job simulation, especially in sales, and so I'm a big fan of doing screens, so we actually have a written screen that we do with folks, where it's the Google Doc that has a dozen or so biographical questions that we allow people to answer. You'd be shocked at how well it screens people, 57% people won't do it. These are not complicated questions, it's like, "Lenny, tell me about something that you've built that you're proud of," it's a dozen of those questions.

**中文翻译:**
我要换个说法，这不太关乎面试问题。我非常推崇“工作模拟”，尤其是在销售领域。所以我非常喜欢做筛选（screens），我们实际上有一个书面筛选环节，就是一个包含十几个个人经历问题的 Google Doc，让应聘者回答。你会惊讶于它的筛选效果有多好，57% 的人根本不会去做。这些并不是复杂的问题，比如“Lenny，告诉我一件你亲手构建并引以为豪的事情”，一共十几个这类问题。

---

### (00:58:10) Pete Kazanjy

**English:**
So, one, you can filter out people who are not serious, you can filter out people who have low levels of give a shit. You also can see whether or not people can communicate in a compelling fashion with a beginning, a middle, and an end. You can also see their attention to detail, whether or not it's ridden with typos or they forget to answer some of them or what have you. So, it's not an interview question thing, but that's a huge hiring hack, from my perspective.

**中文翻译:**
所以，第一，你可以过滤掉那些不认真的人，过滤掉那些不在乎的人。你还可以看到人们是否能以引人入胜的方式进行沟通（有开头、中间和结尾）。你还可以看到他们对细节的关注，比如是否有错别字，或者是否忘了回答其中一些问题。所以，这不只是面试问题，从我的角度来看，这是一个巨大的招聘秘诀。

---

### (00:58:10) Lenny

**English:**
This is a form that folks fill out when they're trying to apply to work at Atrium, is that right?

**中文翻译:**
这是人们申请在 Atrium 工作时填写的表格，对吗？

---

### (00:58:14) Pete Kazanjy

**English:**
Yeah. Or it's just something that for all my portfolio companies, as well, that people just use it. It's a Google Doc and you just clone it, give it to them, "You have edit rights, let me know when it's done." You'd be shocked, people are like, "Oh, I didn't forgot to do it." Great, you told me everything I need.

**中文翻译:**
是的。或者我所有的投资组合公司也都在用它。它就是一个 Google Doc，你只需克隆一份发给他们：“你有编辑权限，做完了告诉我。”你会感到震惊，有人会说：“噢，我忘了做了。”太好了，你已经告诉了我所有我需要知道的信息（即你不合适）。

---

### (00:58:35) Lenny

**English:**
Amazing. Final question, do you have a favorite story of you or a salesperson closing an awesome deal, something that seemed impossible, something that you're proud of?

**中文翻译:**
太棒了。最后一个问题，你有没有关于你或某个销售员成交了一个超赞订单的故事？某种看似不可能完成、让你引以为豪的事情？

---

### (00:58:47) Pete Kazanjy

**English:**
There's a gentleman in our sales organization named Sean, who was an early seller here, he's now a sales manager, he is absolutely fantastic. I think one of the things that early-stage founders and also sellers have to remember is you're, generally speaking, not going to close the deal on the first time through the pipe. As we discussed earlier, if you have a 30% win rate, that's pretty great. If you have a 20% win rate, that's pretty solid, but that still means that four out of five are not going to close, but the next time around, they might, so win rate on the second time through the pipeline.

**中文翻译:**
我们销售组织里有一位叫 Sean 的先生，他是这里的早期销售员，现在是销售经理，他非常出色。我认为早期创始人和销售人员必须记住的一点是：一般来说，你不会在第一次跟进流程中就成交。正如我们之前讨论的，如果你有 30% 的胜率，那已经很棒了。如果你有 20% 的胜率，那也很稳固，但这仍然意味着五分之四的单子不会成交。但下一次机会来临时，它们可能会成交，这就是第二次进入销售漏斗的胜率。

---

### (00:59:21) Pete Kazanjy

**English:**
So, Sean closed, one of our biggest customers is a company called GRIN, they're absolutely fantastic. They make influencer management software for brands, very cool stuff. I think Sean probably ran three or four ops with them before we were able to get a toehold in the account a couple years ago, they were much smaller, and so now, I think they have 100 SDRs and 80 AEs that are being managed using Atrium. So, I think there's a good lesson there, which is it's not necessarily going to be the first time through the pipe and it's maybe not the second time, but you just have to keep pushing that boulder up the hill and eventually, when you do, good things happen.

**中文翻译:**
Sean 成交了我们最大的客户之一，一家名为 GRIN 的公司，他们非常出色。他们为品牌开发网红管理软件，非常酷。我想 Sean 可能跟进了三四个机会，几年前我们才在那家客户那里站稳脚跟，当时他们规模还小得多。现在，我想他们有 100 名 SDR 和 80 名 AE 正在使用 Atrium 进行管理。所以这里有一个很好的教训：不一定是第一次尝试就能成，也不一定是第二次，你只需要不断地把巨石推上山坡，最终当你做到了，好事就会发生。

---

### (00:59:59) Lenny

**English:**
What a great lesson to leave us with, very empowering. Pete, this was everything I hoped it would be. Two final questions, where can folks find you online if they want to learn more, more about Atrium, the book, and then how can folks be useful to you?

**中文翻译:**
多么棒的教训，非常有力量。Pete，这次谈话完全达到了我的预期。最后两个问题：如果大家想了解更多关于你、Atrium 或那本书的信息，可以在哪里找到你？以及大家可以如何帮到你？

---

### (01:00:12) Pete Kazanjy

**English:**
I'm pretty easy to find online, I'm the only Pete Kazanjy in the United States, as far as I can tell. Google will autocorrect my name if you Google it wrong, so that's pretty helpful. Find me on LinkedIn, find me on Twitter. You can also find Founding Sales at foundingsales.com, as Lenny notes. The whole book is available online as hypertext, you can buy a physical copy, as well, but the reason why my wife put it into a Squarespace site was because we wanted people to be able to search it and come back to it and use it as a reference and so on and so forth.

**中文翻译:**
在网上找我很简单，据我所知，全美国只有我一个 Pete Kazanjy。如果你搜错了，谷歌还会自动纠正我的名字，这很有帮助。可以在 LinkedIn 或 Twitter 上找我。正如 Lenny 提到的，你也可以在 foundingsales.com 找到《创始人销售》。整本书都以超文本形式在线发布，你也可以买纸质版。我妻子把它做成 Squarespace 网站的原因是，我们希望人们能够搜索、反复查阅并将其作为参考资料。

---

### (01:01:13) Pete Kazanjy

**English:**
And then in terms of how folks can be helpful to me, if you work for an organization that has between 10 and 300 salespeople and you're looking to manage them better via metric, make them more efficient, that's a big watch word these days, is efficient sales organizations through better management, Atrium is fantastic for that. Atriumhq.com is the domain, but you can also just Google Atrium sales and we'll be the top result, as well.

**中文翻译:**
至于大家如何帮到我：如果你所在的组织有 10 到 300 名销售人员，并且你希望通过指标更好地管理他们，提高他们的效率（“效率”是现在的关键词，即通过更好的管理建立高效的销售组织），那么 Atrium 非常适合。域名是 Atriumhq.com，你也可以直接谷歌搜索“Atrium sales”，我们排在第一位。

---

### (01:01:13) Lenny

**English:**
Amazing. Pete, thank you for being here.

**中文翻译:**
太棒了。Pete，感谢你的到来。

---

### (01:01:16) Pete Kazanjy

**English:**
It was awesome. Thanks, Lenny.

**中文翻译:**
非常愉快。谢谢，Lenny。

---

### (01:01:18) Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。