# Petra Wille - 双语对照

# Lenny's Podcast: Petra Wille Bilingual Transcript
# Lenny's Podcast：对话 Petra Wille 双语全录

---

### [00:00:00] Petra Wille

**English:**
Getting promoted is way harder if you're not good in telling stories and rallying the team behind the shared goal and all these kind of things, and you usually achieve this through good storytelling techniques. And in some teams, I've seen the product person not being really, really good at it, but then the whole team helped creating these stories and stuff like this. So you definitely could compensate to some extent, but I would consider it a bit of a career staller if you don't get to a decent level of storytelling and to a decent level of public speaking.

**中文翻译:**
如果你不擅长讲故事，不擅长围绕共同目标凝聚团队，那么获得晋升会变得困难得多。通常，你需要通过优秀的讲故事技巧来实现这些目标。在某些团队中，我见过产品负责人并不擅长此道，但整个团队会协助创作这些故事。所以，在某种程度上你确实可以弥补这一短板，但如果你无法达到一定的讲故事水平和公开演讲水平，我认为这会成为你职业生涯的一个瓶颈。

---

### [00:00:35] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny, and my aim here is to help you get better at the craft of building and growing products. Today, my guest is Petra Wille. Petra is an independent product leadership coach and author of Strong Product People. And for the past 10 years, she's been helping product teams boost their skill sets and up their game. Alongside her freelance work, Petra organizes events in Hamburg, Germany, where she's based, and does a ton of one-on-one coaching, and speaking, and writing.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你更好地掌握构建和增长产品的技能。今天，我的嘉宾是 Petra Wille。Petra 是一位独立的产品领导力教练，也是《Strong Product People》（打造强大的产品人才）一书的作者。在过去的 10 年里，她一直致力于帮助产品团队提升技能水平和业务表现。除了自由职业工作外，Petra 还在她居住的德国汉堡组织活动，并进行了大量的 1:1 教练指导、演讲和写作。

---

### [00:01:03] Lenny

**English:**
In our conversation, we focus on three things. One, how to become the best coach for PMs, which is really important if you're a new PM manager, and even if you're not a new manager. Two, how to become a better storyteller and why that's important for leaders at every stage of their career. And three, why finding a PM community is so valuable and how to go about finding one. Petra is awesome, and it was such a fun chat. And so with that, I bring you Petra Wille.

**中文翻译:**
在我们的对话中，我们重点讨论三件事。第一，如何成为产品经理（PM）的最佳教练，如果你是新任 PM 经理，甚至即使你不是新经理，这都非常重要。第二，如何成为一个更好的讲故事的人，以及为什么这对职业生涯各个阶段的领导者都至关重要。第三，为什么寻找 PM 社区如此有价值，以及如何去寻找。Petra 非常棒，这次聊天非常愉快。那么，现在让我们欢迎 Petra Wille。

---

### [00:01:32] Lenny

**English:**
Hey, Ashley, Head of Marketing at Flatfile. How many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
嘿，Ashley，Flatfile 的营销负责人。你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### [00:01:40] Ashley

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### [00:01:42] Lenny

**English:**
And how many of them screw that up, and what happens when they do?

**中文翻译:**
其中有多少公司把这件事搞砸了？搞砸后会发生什么？

---

### [00:01:44] Ashley

**English:**
Well, based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common, considering customer files are chock-full of unexpected data and formatting, they'll leave.

**中文翻译:**
嗯，根据我们的数据，大约三分之一的人在入职引导（onboarding）过程中只要经历一次糟糕的体验，就会考虑更换公司。因此，如果你的 CSV 导入工具运行不正常（这非常普遍，因为客户文件充满了意想不到的数据和格式），他们就会流失。

---

### [00:02:04] Lenny

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long-term retention. Getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不惊讶。我一直认为，改善入职引导是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地体验到“Aha Moment”（惊喜时刻）是极其重要的。

---

### [00:02:19] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify, and Zuora are able to grow their businesses on top of Flatfile. That's because flawless data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zuora 这样的客户如何在 Flatfile 的基础上发展业务，真是令人惊叹。这是因为完美的数据入职引导就像催化剂，让他们和他们的客户能更快地达到目标。

---

### [00:02:36] Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny.

**中文翻译:**
如果你想了解更多信息或开始使用，请访问 flatfile.com/lenny 查看 Flatfile。

---

### [00:02:43] Lenny

**English:**
This episode is brought to you by Mixpanel, offering powerful self-serve product analytics. If you listen to this podcast, you know that it's really hard to build great product without making compromises. And when it comes to using data, a lot of teams think that they only have two choices, make quick decisions based on gut feelings or make data-driven decisions at a snail's pace, but that's a false choice. You shouldn't have to compromise on speed to get product answers that you can trust. With Mixpanel, there are no tradeoffs. Get deep insights at the speed of thought at a fair price that scales as you grow. Mixpanel builds powerful and intuitive product analytics that everyone can trust, use, and afford. Explore plans for teams of every size and see what Mixpanel can do for you at mixpanel.com. And while you're at it, they're hiring. Check out mixpanel.com to learn more.

**中文翻译:**
本集节目由 Mixpanel 赞助，他们提供强大的自助式产品分析服务。如果你听过这个播客，你就会知道，在不妥协的情况下打造伟大的产品是非常困难的。在数据使用方面，很多团队认为只有两个选择：要么根据直觉快速决策，要么以蜗牛般的速度进行数据驱动决策。但这是一个错误的选择。你不应该为了获得值得信赖的产品答案而在速度上妥协。有了 Mixpanel，就不需要权衡。以思维的速度获得深刻洞察，价格合理且随业务增长而扩展。Mixpanel 构建了每个人都能信任、使用和负担得起的强大且直观的产品分析工具。访问 mixpanel.com 探索适合各种规模团队的方案，看看 Mixpanel 能为你做些什么。顺便说一下，他们正在招聘，访问 mixpanel.com 了解更多。

---

### [00:03:35] Lenny

**English:**
Petra, thank you for being here. Welcome to our little podcast.

**中文翻译:**
Petra，感谢你的到来。欢迎来到我们的小播客。

---

### [00:03:39] Petra Wille

**English:**
Hi, Lenny. Such an honor to be here on a Friday night.

**中文翻译:**
嗨，Lenny。很荣幸能在周五晚上来到这里。

---

### [00:03:43] Lenny

**English:**
Friday night your time, Friday morning my time. Thank you for making the time.

**中文翻译:**
你那边是周五晚上，我这边是周五早上。感谢你抽时间参加。

---

### [00:03:47] Petra Wille

**English:**
Of course.

**中文翻译:**
当然。

---

### [00:03:48] Lenny

**English:**
You're a product leadership coach. Can you just talk about what you do as a product leadership coach and then also just a bit about the numbers of PMs you work with, the number of companies you work with, the impact you had, just to set a little bit of context in your background?

**中文翻译:**
你是一位产品领导力教练。你能谈谈作为产品领导力教练具体做些什么吗？另外，能否介绍一下你合作过的 PM 数量、公司数量以及你产生的影响，以便让我们了解一下你的背景？

---

### [00:04:01] Petra Wille

**English:**
How I usually describe it is that I work with people leading product people, so that's the product leadership level that I'm looking at. So that might be a CPO in a smaller startup or a product director, a product team lead, these are the folks that I'm usually working with for the last four years, I'd say. And before that, I coached product managers, so IC level product folks. And before that, I did a lot of product discovery coaching for teams and whole product organizations. And you asked about how many people I may have influenced. That's a real hard question so to say. So in one-on-one coachings, that's what I know. I coached around 130 people so far over the last few years, which is already a lot. Most of them have, yeah, 10 to 20 sessions with me. Some really stick with me over the years so they have more sessions.

**中文翻译:**
我通常这样描述：我与“领导产品人的人”合作，这就是我关注的产品领导层。这可能是小型初创公司的 CPO，或者是产品总监、产品团队负责人，这些是我过去四年里主要合作的对象。在那之前，我辅导产品经理，也就是 IC（个人贡献者）级别的产品人员。再之前，我为团队和整个产品组织做过大量的产品探索（Product Discovery）辅导。你问我影响了多少人，这确实是个很难回答的问题。在 1:1 辅导方面，过去几年我大约辅导了 130 人，这已经很多了。他们中的大多数人会跟我进行 10 到 20 次咨询，有些人多年来一直跟我保持联系，所以次数更多。

---

### [00:04:55] Petra Wille

**English:**
So that's that. And then I have group coaching sessions and corporate and then public setups. And that's, I would say, another 150. And it's all product leads. So usually, those people are working with a team of 10 product people and there are some ripple effects. So I think I have an impact on their lives as well if I'm coaching their boss or the line manager so to say. Plus, the teams that I work with as a discovery coach, plus the people that read my book and hopefully are using some of the techniques. And in the end, yeah, I did a bit of the math and I think it might be around 50,000, 60,000 people. If we look at it from the product leadership to IC level structure, yeah, that might be the impact. So that's a pretty impressive number.

**中文翻译:**
这就是 1:1 的情况。此外，我还有小组辅导、企业内部培训和公开课。我想这部分大约还有 150 人，而且全都是产品领导者。通常，这些人管理着 10 人的产品团队，这会产生涟漪效应。所以，如果我辅导他们的老板或直属经理，我认为对这些 PM 的生活也会产生影响。再加上我作为探索教练合作过的团队，以及读过我的书并应用其中技巧的人。最后，我算了一下，影响的人数可能在 5 万到 6 万左右。如果从产品领导层到 IC 层的结构来看，这可能就是我的影响力。这是一个相当可观的数字。

---

### [00:05:35] Lenny

**English:**
Wow. That is an impressive number. And I always love chatting with folks that do the work you do because there's such a unique insight into working one on one with PMs that are trying to get better and understanding what trends are happening across PMs at different companies and different countries and things like that. So I'm excited to dig into a bunch of stuff.

**中文翻译:**
哇，这确实是个令人印象深刻的数字。我一直很喜欢和从事你这类工作的人聊天，因为在与那些努力提升的 PM 进行 1:1 合作时，你能获得非常独特的洞察，并了解不同公司、不同国家的 PM 之间正在发生的趋势。所以我很期待深入探讨这些内容。

---

### [00:05:53] Lenny

**English:**
The other thing that I love about where you're focused, there's a lot of people that focus on IC PMs and there's a lot of people that focus on senior leaders, VPs, CPOs. And I love that it feels ... And correct me if I'm wrong, but you are focused on this middle layer of first line managers, directors.

**中文翻译:**
我喜欢你关注点的另一个原因是，有很多人关注 IC 级别的 PM，也有很多人关注高级领导者、VP、CPO。而我喜欢的是……如果我没说错的话，你关注的是一线经理、总监这个中间层。

---

### [00:06:08] Petra Wille

**English:**
Exactly, yes.

**中文翻译:**
没错，是的。

---

### [00:06:08] Lenny

**English:**
Which I feel like is often the most important and influential layer of a company because they're the ones doing a lot of the work at making a lot of the decisions day to day.

**中文翻译:**
我觉得这通常是一家公司中最重要、最有影响力的阶层，因为他们是日常工作中处理大量事务并做出许多决策的人。

---

### [00:06:16] Petra Wille

**English:**
That is the case. Plus, at least with a lot of clients that I'm working with, they are not trained product people. So they often come from a marketing background, or a business background, or from the data background, so to say, or the engineering background, but they often never have worked in a product management role. So they're missing a lot of basic product management practice and a lot of empathy for the struggle of the product people to some extent. Plus, how should you help people grow if you have no clue what their role actually is all about? So that's what I actually like to help them with, to get this clarity on a strong compass how the best product organizations and product managers should be working.

**中文翻译:**
确实如此。此外，至少在我合作的许多客户中，他们并非科班出身的产品人。他们通常来自市场背景、业务背景、数据背景或工程背景，但往往从未担任过产品管理职位。因此，他们在某种程度上缺乏很多基础的产品管理实践，也缺乏对产品人员困境的同理心。而且，如果你根本不知道他们的角色到底是做什么的，你又该如何帮助他们成长呢？所以这正是我想要帮助他们的：建立一个清晰的“指南针”，明确最优秀的产品组织和产品经理应该如何工作。

---

### [00:07:02] Lenny

**English:**
Just to go a little bit on that tangent because that's an interesting point you just raised. When you work with folks that are not product people and that end up leading product people and trying to better product, what's the thing they lack most, the skill or the understanding of product? If you had to think of one or two things that these people are like, "Okay, they totally missed this part about product management, about building product."

**中文翻译:**
稍微展开一下，因为你刚才提到了一个很有趣的点。当你与那些非产品出身、但最终领导产品人员并试图改进产品的人合作时，他们最缺乏的是什么？是技能还是对产品的理解？如果你必须想出一两件这些人完全忽略的事情，关于产品管理或构建产品的，会是什么？

---

### [00:07:23] Petra Wille

**English:**
One thing that has made me sense out the most is I see product people on the IC level have to go through some of the struggles on their own, even if our product community has some best practices to it. Because as the line manager has no clue about the product community out there and the craftless product management, they often struggle to point them in the right direction to say, "Hey, I think that's a problem somebody else already had. So maybe you could watch a talk or read this blog post or there's a book about this particular thing and then go try it." So that's the first thing. So product people IC level often have done to learn a lot of things on their own, so to say, because nobody's curating their progression for them to some extent. So that is one thing.

**中文翻译:**
让我感触最深的一点是，我看到 IC 级别的产品人员不得不独自经历一些挣扎，即使我们的产品社区已经有了一些最佳实践。因为直属经理对外部的产品社区和产品管理这门手艺一无所知，他们往往难以指引正确的方向，无法说出：“嘿，我觉得这是别人已经遇到过的问题。也许你可以看个演讲，读读这篇博文，或者有一本关于这个特定问题的书，然后去尝试一下。” 这是第一点。所以 IC 级别的产品人往往必须自学很多东西，因为在某种程度上，没有人为他们的职业进阶提供指导。

---

### [00:08:13] Petra Wille

**English:**
And then I use this metaphor of the eight-legged creature because people tend to talk about T-shaped employee profiles, but T-shaped is so not enough for a product person, right? We want them to understand underlying problems of the business and the users finding solution for those, getting things out of the door with the team, doing a lot of product discovery, looking at the data, how people are using it, iterating on the products. So there's so many things that we want them to be good at and to understand that and the complexity that the role actually brings with it. That's sometimes hard for people that have never worked as a product person to really understand. So, yeah, if I would need to pick two things, then that's maybe the two biggest differences.

**中文翻译:**
然后我用了“八足生物”这个比喻，因为人们倾向于谈论 T 型人才，但对于产品人来说，T 型是远远不够的，对吧？我们希望他们理解业务和用户的底层问题并找到解决方案，与团队一起发布产品，进行大量的产品探索，查看数据了解用户如何使用，并对产品进行迭代。我们希望他们擅长的事情太多了，要理解这一点以及这个角色带来的复杂性，对于从未做过产品的人来说有时很难。所以，如果非要选两点，这可能就是最大的两个区别。

---

### [00:08:56] Lenny

**English:**
The first one is such a great one. It comes up a lot on these chats of just how much of getting better product is just doing it. You can read all the books, you can take all the courses, you can read my newsletter, you can read your book, which we'll talk about, but there's only so far you'll get without actually just doing it and just failing, doing great things that succeed. And it takes years, right? It's not like something you'll do six months, "All right, I'm feeling really good about being a product manager."

**中文翻译:**
第一点说得太好了。在这些对话中经常提到，提升产品能力很大程度上取决于“实践”。你可以读所有的书，上所有的课，读我的简报，读你的书（我们待会会聊到），但如果不亲自动手去做、去失败、去成就伟大的事业，你的进步是有限的。而且这需要数年时间，对吧？不像你做个六个月就能说：“好了，我觉得自己是个很棒的产品经理了。”

---

### [00:09:20] Petra Wille

**English:**
Yeah, I totally agree. I so often have said the sentence of, it's not a role, it's a career being in product and, really, there's so many things to learn and so many things to get good at. Yeah, I totally agree.

**中文翻译:**
是的，我完全同意。我经常说，产品不只是一个岗位，而是一项事业。真的有太多的东西要学，太多的东西要精通。我非常赞同。

---

### [00:09:32] Lenny

**English:**
Yeah, crazy ass role. Speaking of your book, you wrote a book, it's about product leadership and coaching, and we're going to touch on some of the things you wrote in the book, but can you just briefly describe the book that you wrote, who it's for, what it's about?

**中文翻译:**
是的，一个疯狂的角色。说到你的书，你写了一本关于产品领导力和教练指导的书，我们会涉及到书中的一些内容，但你能简要描述一下你写的这本书吗？它是为谁写的？主要讲什么？

---

### [00:09:42] Petra Wille

**English:**
It's quite a niche book, right? So it's focusing on people managing product people, so product leads and then the people development part of their job. So it's not another book talking about how to come up with a great product strategy. There definitely is a chapter on that to some extent, but it's more how you coach those things. So it's not so much about how you do these things on your own, it's more how you could help product people to understand hypothesis-driven product discovery a bit more, or how could you help them think about team motivation, or how could you help them get better and giving feedback, all these kind of things.

**中文翻译:**
这是一本相当小众的书。它专注于“管理产品人的人”，也就是产品领导者，以及他们工作中关于“人才培养”的部分。所以它不是另一本教你如何制定伟大产品策略的书。虽然书中确实有相关章节，但更多是关于如何“辅导”这些事情。它不怎么讲你个人如何做这些事，更多是讲你如何帮助产品人员更好地理解假设驱动的产品探索，如何帮助他们思考团队激励，或者如何帮助他们更好地提供反馈等等。

---

### [00:10:20] Petra Wille

**English:**
So this book has this meta level of helping product leads to develop their product folks. And that is actually what the book talks about in five different parts. And I think 28 chapters if I get it right.

**中文翻译:**
所以这本书是在元层面（meta level）上帮助产品领导者培养他们的产品人才。这就是书里五个不同部分所讲述的内容。如果我没记错的话，一共有 28 章。

---

### [00:10:35] Lenny

**English:**
Wow, it's a lot of chapters. What is it called? Where can people find it? Just while we're on this topic and then we'll get into some of this.

**中文翻译:**
哇，章节真多。书名是什么？大家在哪里可以找到它？趁着这个话题，我们先交代一下，然后再深入讨论。

---

### [00:10:41] Petra Wille

**English:**
It should be available on Amazon and it's Strong Product People: A Complete Guide to Developing Great Product Managers. That's actually the title and the subtitle, so to say.

**中文翻译:**
亚马逊上应该有卖，书名是《Strong Product People: A Complete Guide to Developing Great Product Managers》（强大的产品人才：培养优秀产品经理的完整指南）。这就是它的主标题和副标题。

---

### [00:10:52] Lenny

**English:**
Awesome. Strong Product People. Okay. I read parts of the book, I looked at a lot of the stuff that you write online and some of your videos, and there's three things that I want to spend our time together on to dig into. One is what you just talked about, how to become a better coach to product managers for PMs. Two is storytelling skills. You have a lot of great stuff on just becoming a better storyteller. And then three is how to find great community to become a better PM. Does that sound good?

**中文翻译:**
太棒了。《Strong Product People》。好的。我读了书的一部分，也看了很多你在网上写的文章和视频。我想利用我们的时间深入探讨三件事。第一，就是你刚才提到的，如何成为 PM 的更好教练。第二，讲故事的技巧。你有很多关于如何成为优秀讲故事者的精彩内容。第三，如何寻找优秀的社区来成为更好的 PM。听起来怎么样？

---

### [00:11:18] Petra Wille

**English:**
Yeah, that sounds amazing. That stood up.

**中文翻译:**
是的，听起来太棒了。正合我意。

---

### [00:11:21] Lenny

**English:**
Okay, great. Awesome. So the first topic, basically, the premise of your book is just how to become a better coach to product managers. And for me, actually personally, the biggest inflection in my career was having an awesome manager who helped me become a better PM, and that was the point in my career where I really accelerated. And so I fully buy into the power of having a great manager and a coach, and oftentimes those aren't the same people. And you have these five ingredients that you have to be the best coach to product managers.

**中文翻译:**
太好了。第一个话题，基本上你书的前提就是如何成为 PM 的更好教练。对我个人而言，我职业生涯最大的转折点就是遇到了一位非常棒的经理，他帮助我成为了更好的 PM，那是我职业生涯真正加速的时刻。所以我完全相信拥有一位优秀的经理和教练的力量，而且通常这两者并不是同一个人。你提出了成为 PM 最佳教练的五个要素。

---

### [00:11:52] Lenny

**English:**
And so just to start, what are these five ingredients? What do you have to get right to be a great coach to PMs?

**中文翻译:**
那么首先，这五个要素是什么？要成为 PM 的优秀教练，你必须做对哪几点？

---

### [00:11:57] Petra Wille

**English:**
Yeah, I'm glad you're asking. So I was already referencing to number one. And number one is really having a solid definition of what a good product person looks like in your context. So what is your definition of good, so to say? And a lot of the product leads that I'm working with have this as an implicit feeling based, experience-based thing. They can talk about some of the aspects, but it's often the case that they not have fully reflected on what a personality traits that I want to see in product people that are hard to develop while I'm coaching them, and what are skills, and know-how, and capabilities that I want to see in the product people that I'm working with. And some are super good and have it all written down, but most of the product folks that I'm working with haven't. So that is step number one is doing this reflection.

**中文翻译:**
我很乐意回答。我已经提到过第一点。第一点是：在你的语境下，对“优秀的产品人”有一个明确的定义。也就是说，你对“优秀”的定义是什么？我合作过的许多产品领导者对此只有一种基于经验的模糊感觉。他们能谈论其中的某些方面，但通常没有深入思考：哪些性格特质是我希望在产品人身上看到、但在辅导过程中很难培养的？哪些又是技能、知识和能力？有些人做得很好，把这些都写了下来，但我合作过的大多数产品人都没有。所以第一步就是进行这种反思。

---

### [00:12:54] Petra Wille

**English:**
Then step number two is having a clear idea where every PM currently is in their current career, in their situation, life in general, all these kind of things. So put the pin on the map, so to say, and then think about what is your vision for them in the future, so how good could it get? And I usually encourage product leads to think bigger than their current role at the current company because that's the longer term thing. And then even more important is what I call the next bigger challenge.

**中文翻译:**
第二步是清楚地了解每个 PM 目前处于职业生涯的什么阶段，他们的现状、生活情况等等。也就是说，在地图上插个大头针，然后思考你对他们未来的愿景——他们能达到多高的高度？我通常鼓励产品领导者跳出当前公司和当前职位的局限去思考，因为那是更长远的事情。然后，更重要的是我所说的“下一个更大的挑战”。

---

### [00:13:27] Petra Wille

**English:**
So what is the next bigger challenge I would love to assign this product person to if I could because I know that would help them to learn a new skill or to, yeah, again, you know how, whatever it is, right? And creating such a list once a quarter, for example, you block yourself an hour in your calendar, you write down the names of your direct reports, and then you just think about, "Okay, what would be this next bigger challenge for them?"

**中文翻译:**
如果可以的话，我最想把这个产品人安排到哪个“下一个更大的挑战”中？因为我知道那会帮助他们学习新技能或增长见识。比如，每个季度在日历上留出一小时，写下你直属下属的名字，然后思考：“好的，对他们来说，下一个更大的挑战会是什么？”

---

### [00:13:53] Petra Wille

**English:**
It's not always the case that this comes around the corner the next day. Sometimes it takes a quarter or two or three, but if you wrote it down, you will see this opportunity and then you could assign this person to the opportunity and really help them grow substantially over time. So that's number two. Then, hopefully, you share this vision you're having for them with them and do a bit of an alignment session because it's not always that they have the same things in mind. Maybe your vision for them opens up their thinking and reflection a little bit more, but you have to have this conversation where you actually see them, and that's a lot of encouragement and bringing out the best in them and these kind of things. Then it's definitely a development plan, but I think that's more on them than it is on you because you don't get the apps from other people's branches.

**中文翻译:**
这种机会并不总是第二天就会出现。有时需要一两个甚至三个季度，但如果你把它写下来，你就会留意到这个机会，然后你可以把这个人安排到这个机会中，真正帮助他们随着时间的推移实现实质性的成长。这就是第二点。然后，希望你能与他们分享你对他们的愿景，并进行一次对齐会议，因为他们的想法并不总是和你一致。也许你对他们的愿景能进一步开启他们的思考和反思，但你必须进行这次对话，让他们感受到你真正关注他们，这包含了很多鼓励和激发他们潜能的内容。接下来肯定是一个发展计划，但我认为这更多取决于他们自己而不是你，因为你不能替别人锻炼肌肉。

---

### [00:14:45] Petra Wille

**English:**
So you cannot really help them develop, but you could remind them of going to the gym, for example, which would be step number five, by the way, that's the follow-up. But the development plan is something where a lot of product managers need help with because that's the inspirational part, that's situational part. That's where you could help them to really see some of the differences between your definition of good and their current profile, and maybe they need to get better in prioritization, maybe user interviewing is something they want to get better at. And then you could help them defining steps that they could take small things that they could learn. Maybe it's a book, maybe it's giving a presentation at a conference, maybe it's reflecting on your way of prioritizing, and then look at what others are doing. So whatever it is, that is something you could help them with.

**中文翻译:**
你无法真正替他们发展，但你可以提醒他们去“健身房”，顺便说一下，这就是第五步：后续跟进。但发展计划是很多产品经理需要帮助的地方，因为那是启发性的、情境性的部分。在这里，你可以帮助他们真正看到你的“优秀定义”与他们“当前现状”之间的差距。也许他们需要提高优先级排序能力，也许他们想在用户访谈方面做得更好。然后你可以帮助他们定义可以采取的步骤，一些可以学习的小事。也许是一本书，也许是在会议上做个演讲，也许是反思自己的优先级排序方式，然后看看别人是怎么做的。无论是什么，这都是你可以提供帮助的地方。

---

### [00:15:30] Petra Wille

**English:**
And then finally, it's the follow-up. That's sometimes just a nudge every once in a while at the water cooler to say, "Hey, how is it going with your personal development plan?" And some really need the weekly reminder and some maybe need even a daily email, whatever it is, ask them how they want to be reminded of the personal development and how you could help them and the system while doing that because they still have a day job, right? So the development will never be the number one priority, and it shouldn't.

**中文翻译:**
最后是后续跟进。有时只是在饮水机旁偶尔提醒一下：“嘿，你的个人发展计划进展如何？” 有些人真的需要每周提醒，有些人甚至可能需要每天发邮件。无论如何，问问他们希望如何被提醒个人发展，以及在此过程中你和系统如何提供帮助，因为他们还有日常工作，对吧？所以发展永远不会是第一优先级，也不应该是。

---

### [00:15:58] Lenny

**English:**
Awesome. So just to summarize really quick, I have the list here in front of me. One is have a clear sense of just what it takes to be a competent PM in your role. Two is an idea of where that PM is today and one thing they could do to improve. Three is a shared vision of how they'll take that next step. Four is having a development plan of how they can move towards this vision. And then the last piece is a commitment, just following up with them and making sure they're staying on top of this.

**中文翻译:**
太棒了。快速总结一下，我面前有这个清单。第一，清楚地了解在你的职位上成为一名合格 PM 需要具备什么。第二，了解该 PM 的现状以及他们可以改进的一件事。第三，对他们如何迈出下一步达成共同愿景。第四，制定一个如何向该愿景迈进的发展计划。最后一点是承诺，即持续跟进，确保他们一直在关注这件事。

---

### [00:16:23] Petra Wille

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:16:23] Lenny

**English:**
What's interesting about this, just looking at this, it feels a lot like a roadmap and a strategy and a vision for a product. The definition where you're today is the problem, idea of where you're going to go next is like a strategy, and then there's a vision of where you're going to go together and then you check in. So it's these standups. Do you think of it that way at all or is that just something I'm noticing?

**中文翻译:**
有趣的是，看着这个清单，感觉非常像产品的路线图、策略和愿景。定义现状就像是定义问题，关于下一步去哪里的想法就像是策略，然后是共同前往的愿景，最后是检查进度。这就像是站会。你也是这么想的吗，还是只是我个人的观察？

---

### [00:16:42] Petra Wille

**English:**
I think about it that way as well, even to an extent because so many companies are lacking the real strategy bit, right, and it's similar with the people development strategy. That is something that I see not being present in so many environments as well. So even that similarity is a given, I'd say. Yeah.

**中文翻译:**
我也是这么想的，甚至在某种程度上，因为很多公司都缺乏真正的策略，人才培养策略也是如此。我发现很多环境下也缺乏这种策略。所以，我认为这种相似性是必然的。

---

### [00:17:00] Lenny

**English:**
Which of these do you find is the most lacking usually or slash where do you think the biggest ... If someone were to just like, "I want to be a better manager," where would you suggest they start? Is it right at the top, figure out what a great PM at this company is?

**中文翻译:**
你觉得通常最缺乏的是哪一点？或者说，如果有人说“我想成为一个更好的经理”，你建议他们从哪里开始？是从最上面开始，弄清楚这家公司优秀的 PM 是什么样的吗？

---

### [00:17:14] Petra Wille

**English:**
That is a great question. No, I usually advise people to start with the development plan because even if you have never done the assessment and even if you don't have your compass, your definition of what makes a good product manager, you usually have an idea or they have an idea of what they want to learn next or where they want to get better at. So I said they say something like my storytelling capabilities are maybe not as good as they could be or prioritization is people are constantly complaining behind my back that they don't get the order of the things in my backlog or whatever it is, or they think my opportunity solution freeze, and suck, or whatever it is.

**中文翻译:**
这是个好问题。不，我通常建议人们从发展计划开始。因为即使你从未做过评估，即使你还没有自己的“指南针”（即对优秀产品经理的定义），你通常也会有个想法，或者他们有个想法，知道下一步想学什么或想在哪些方面做得更好。比如他们会说，我的讲故事能力可能还不够好，或者优先级排序有问题——人们总是在背后抱怨看不懂我待办事项的顺序，或者他们觉得我的“机会解决方案树”做得很烂，诸如此类。

---

### [00:17:55] Petra Wille

**English:**
And you could use that and start helping them creating this development plan. That's not a structured assessment, but that's a perfect start. And then it's obviously the follow-up that makes a big difference and that just takes so little time from the product lead, the small notches, that's super easy. And these development plans, I usually tell people to create a new one with a new headline or topic once a quarter or every four months. So that is not a massive time invest as well. So that would be my suggestion for where to start, if that helps.

**中文翻译:**
你可以利用这些点开始帮助他们制定发展计划。这虽然不是结构化的评估，但却是一个完美的开始。显然，后续跟进会产生巨大的影响，而且这只需要产品领导者花极少的时间，小小的提醒非常容易。关于这些发展计划，我通常建议每季度或每四个月创建一个带有新标题或主题的计划。所以这也不是一项巨大的时间投入。这就是我关于从哪里开始的建议，希望能有所帮助。

---

### [00:18:29] Lenny

**English:**
Yeah, I love that advice because I can imagine a lot of people get stuck in that first one of, "I don't know all of the things that I need to know about what a great PM right now is." So that's a nice simple way to start.

**中文翻译:**
是的，我喜欢这个建议，因为我可以想象很多人会卡在第一步：“我不知道现在一个优秀的 PM 需要具备的所有素质。” 所以这是一个简单而有效的开始方式。

---

### [00:18:38] Petra Wille

**English:**
And there is another aspect to it. A lot of product leads try to create their compass. And while they do so, they think about, "Maybe I should have an aligned version with my peers." So the other product leads in the company. And then we're talking about the career levels and all these things and often takes ages until something is coming back from HR or you have a unified version. So that is something where I usually say, "No, start with your own personal team because the folks in your team usually just have you as a line manager. So grade your compass and encourage your peers to grade their compass and, a bit down the line, it might make sense to harmonize some of that, but it's better to start helping your product folks and giving them some orientation than being totally paralyzed by the fact that it's not a compass that is used in the whole company."

**中文翻译:**
还有一个方面。很多产品领导者试图创建自己的“指南针”。在做这件事时，他们会想：“也许我应该和同行（公司里其他的产品领导者）达成一致的版本。” 然后就开始讨论职业等级之类的东西，通常要等好久 HR 才会给反馈，或者才能达成统一版本。所以我通常会说：“不，先从你自己的团队开始，因为你团队的人通常只有你这一个直属经理。所以制定你的指南针，并鼓励你的同行也制定他们的。以后可能需要统一，但现在开始帮助你的产品人员并给他们一些方向，总比因为全公司没有统一的指南针而完全停滞不前要好。”

---

### [00:19:31] Lenny

**English:**
I want to talk about this compass and how to figure out what a competent PM is. And I know you have a framework around this and I have some stuff I'll actually share, too. But on this latter piece of checking in the development plan, I wrote about this once, but I'll share it here briefly. Something that I did with my PMs that was so effective was every time we did a performance review, every six months, we had a performance review, we put together a Google Doc with all of the things that we agree they should be working on and we pick, say, five themes or three themes, and then we pick very concrete things they should do over the next six months that will help them develop these things.

**中文翻译:**
我想谈谈这个“指南针”，以及如何确定什么是合格的 PM。我知道你有一个相关的框架，我也有一些东西可以分享。但关于检查发展计划这一点，我曾经写过，这里简要分享一下。我对我手下的 PM 做过一件非常有效的事：每六个月进行一次绩效评估时，我们会整理一份 Google 文档，列出我们一致认为他们应该改进的所有事项。我们会选出比如三个或五个主题，然后确定他们在接下来的六个月里应该做的非常具体的事情，以帮助他们发展这些能力。

---

### [00:20:06] Lenny

**English:**
And then more importantly to your last point is we did a monthly coaching session where we looked at the status of each of these things. So there's a color code for each of these 10 things that we all agreed you should be doing these things over the next six months and we checked in how they're going, so that the next performance review, it's not like, "Oh, I forgot all these things."

**中文翻译:**
更重要的一点是，对应你说的最后一点，我们每月进行一次辅导会议，查看每项内容的进展。我们为这 10 件（我们一致同意在六个月内完成的）事情设定了颜色代码，并检查进展情况。这样到下一次绩效评估时，就不会出现“哦，我把这些全忘了”的情况。

---

### [00:20:24] Petra Wille

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:20:24] Petra Wille

**English:**
Yeah, exactly. And really, all of us know consistency beats intensity. So, really, the smaller time investments on a weekly basis and that applies for the PM's time investment in learning new things and it applies to the product leads investment and helping their people to grow. I think for both parties, it's more likely and more pleasant if you have small chunks of people development in your calendar. And that's why I like your story, right, because you were focusing on regular check-ins more than into the big bang 360-degree reviews.

**中文翻译:**
没错。我们都知道“持之以恒胜过突击强化”。所以，每周投入少量时间，这既适用于 PM 学习新事物的时间投入，也适用于产品领导者帮助下属成长的时间投入。我认为对双方来说，如果在日历中安排小块的人才培养时间，会更容易实现也更愉快。这就是为什么我喜欢你的故事，因为你关注的是定期检查，而不是那种大张旗鼓的 360 度评估。

---

### [00:21:00] Lenny

**English:**
And it builds on what your point of the development plan is something the person develops like, "Here's what I believe I should be working on." And it's not like you inform it a bit and give them feedback and maybe this isn't or maybe [inaudible 00:21:12] this other thing. But, yeah, the fact that they own it, I think, is really powerful.

**中文翻译:**
这正好印证了你的观点：发展计划应该是个人自己制定的，比如“这是我认为我应该努力的方向”。而不是你直接告知，虽然你会提供反馈，建议调整。但是，让他们拥有所有权（ownership），我认为这非常强大。

---

### [00:21:16] Petra Wille

**English:**
Yeah, yeah.

**中文翻译:**
是的，没错。

---

### [00:21:16] Lenny

**English:**
Going back to knowing what is a competent PM at a company. Something I want to ... I'll make sure to include in the show notes for this is I actually did all this research on the career ladders at all of the biggest tech companies. So I have the spreadsheet that it's public of just the skills that every company evaluates your PMs by, but most companies don't have. They're not great. So say your company doesn't have a career ladder competency framework leveling thing, what do you suggest folks do to help figure out what is a competent PM here at our company?

**中文翻译:**
回到“了解公司里合格 PM 的标准”这个话题。我想在节目笔记中加入一点：我实际上对所有大型科技公司的职业阶梯（career ladders）做了研究。我有一份公开的电子表格，列出了每家公司评估 PM 的技能，但大多数公司并没有这些，或者做得不好。假设你的公司没有职业阶梯、胜任力框架或职级体系，你建议大家怎么做来弄清楚“我们公司合格的 PM 是什么样的”？

---

### [00:21:50] Petra Wille

**English:**
I'd say use one of the assessments that are already out there. Maybe we can include this as well. I wrote a blog post where I put all the ones that I'm aware of into, so there's the PM Daisy and, obviously, Marty Cagan has an assessment, and I created a framework called the PMwheel and there are a few others in there. Go find one that is close to what you actually think a good PM should look like and then customize it. Don't use it just by copy paste because sometimes you have just rather technical PMs in your organization and then all these assessment points about user interviews and discovery are maybe not that applicable in your situation, right?

**中文翻译:**
我会说，使用现有的评估工具。也许我们也可以把这个包含进来。我写过一篇博文，列出了我所知道的所有评估工具，比如 PM Daisy，显然 Marty Cagan 也有一个评估工具，我还创建了一个叫 PMwheel 的框架，还有其他一些。找一个最接近你心目中优秀 PM 形象的工具，然后进行定制。不要直接复制粘贴，因为有时你的组织里主要是技术型 PM，那么所有关于用户访谈和探索的评估点可能就不太适用，对吧？

---

### [00:22:33] Petra Wille

**English:**
So use one template that is close what you want to achieve, heavy customize it because it is really a great inspiration to see, "Oh, these are all the things that other people think a PM should be doing." Or maybe you could merge one or two of those and tailor it to your needs. So that will be my first suggestion. Plus, reflecting on the personality traits because I think there are some things that you better hire for and that are super hard to develop in a corporate environment. So for me, that, for example, is curiosity. I think product people need to be curious about the world, how it works, about things, no matter the topic.

**中文翻译:**
所以，找一个接近你目标的模板，进行深度定制，因为看到“哦，原来别人认为 PM 应该做这些事”是非常有启发性的。或者你可以合并一两个模板，根据你的需求进行调整。这是我的第一个建议。此外，还要反思性格特质，因为我认为有些特质最好在招聘时就筛选好，在公司环境下很难培养。对我来说，比如好奇心。我认为产品人需要对世界、对运作方式、对各种事物保持好奇，无论是什么主题。

---

### [00:23:14] Petra Wille

**English:**
The best product people that I know, whatever the topic is, they're interested and tell me more about it. So that is, for example, there's something I would always check when hiring product people because I know it's hard to build that muscle or empathy, definitely something that I want to hire for. I know that I can help them develop this muscle a bit more and stepping into shoes of users, and stakeholders, and colleagues easier. But still, if there is, yeah, not a decent level of empathy built into this person, then it's nearly impossible for me as a product lead to help them get towards a seasoned level. So that's another important thing. Think about personality traits and think about skills and know-how and to think about skills and know-how. Use some of the already established assessments.

**中文翻译:**
我认识的最优秀的产品人，无论聊什么话题，他们都感兴趣并想听更多。所以，这是我在招聘产品人时一定会检查的，因为我知道这种“肌肉”很难后天练就。还有同理心，这也是我招聘时看重的。我知道我可以帮他们进一步锻炼同理心，让他们更容易站在用户、利益相关者和同事的角度思考。但如果这个人本身缺乏基本的同理心，那么作为产品领导者，我几乎不可能帮他们达到资深水平。所以这是另一件重要的事：考虑性格特质，同时考虑技能和知识。对于技能和知识，可以使用一些现成的评估工具。

---

### [00:24:03] Lenny

**English:**
So we will try to link to as many of those that you mentioned in the show notes. Maybe talk about the PMwheel, which is the framework that you suggest for folks to understand, just like what are all the skills that a PM needs to have.

**中文翻译:**
我们会尝试在节目笔记中链接你提到的那些工具。也许可以聊聊 PMwheel，这是你建议大家用来理解 PM 需要具备哪些技能的框架。

---

### [00:24:14] Petra Wille

**English:**
It's hard to talk about that really briefly. So I split all the things that PMs usually do in eight buckets, so to say. And it starts with our day able to understand the underlying problems that users and the company actually is having. Are they good in finding solutions to those problems? Then they do some planning parts. Are they able to maybe come up with a roadmap or with good goals that are aligning the team, these kind of things. And it's get it done that's already able to actually deliver the thing to work with the team that's maybe writing backlog items and all these kind of things.

**中文翻译:**
很难简短地介绍。我把 PM 通常做的所有事情分成了八个“桶”。首先是理解用户和公司面临的底层问题的能力。他们擅长寻找这些问题的解决方案吗？然后是规划部分：他们能制定路线图或设定能让团队达成一致的目标吗？接着是“执行落地”：能够实际交付产品，与团队协作，编写待办事项等等。

---

### [00:24:51] Petra Wille

**English:**
Then it's listen and learn. So are they able to really gather a lot of data these days and then look into what customers are actually saying. So the qualitative and quantitative aftermath of stuff going live. And are they able to iterate on the solutions that they shipped?

**中文翻译:**
然后是“倾听与学习”。他们现在能收集大量数据并研究客户的真实反馈吗？也就是产品上线后的定性和定量分析。他们能对已发布的解决方案进行迭代吗？

---

### [00:25:07] Petra Wille

**English:**
And then it's another three buckets that are a bit out of the PM process, which is team. So do they know about how teams actually are different from working with individuals? Do they think they have to motivate a team? Can you motivate a team? So this whole teamwork part. Then it's personal growth. I put it on my PMwheel because I want that to be part of every conversation that I have with my PM. So that's why it's on the wheel. And then last, but not least, it's agile because when I was still coaching PMs, I often found that they never reflected on the underlying basics of agile ways of working. So they often never heard about the agile manifesto, or agile values, or agile principles, no matter what framework they're using. But I think that is key. So that's bucket number eight.

**中文翻译:**
剩下的三个“桶”稍微超出了 PM 的核心流程。首先是“团队”：他们了解团队协作与个人工作的区别吗？他们认为自己需要激励团队吗？你能激励团队吗？也就是整个团队合作部分。然后是“个人成长”：我把它放在 PMwheel 上，是因为我希望它成为我与 PM 每次对话的一部分。最后但同样重要的是“敏捷”：当我还在辅导 PM 时，我经常发现他们从未反思过敏捷工作方式的底层基础。无论使用什么框架，他们往往从未听说过敏捷宣言、敏捷价值观或敏捷原则。但我认为这是关键，所以这是第八个桶。

---

### [00:25:57] Petra Wille

**English:**
And every of those buckets comes with at least 15 framing questions. So is this person good at doing this? Is this person good in doing that? And it hopefully gives you a really nice and well-rounded picture of where this person currently is. And I usually advise people to do a self-assessment, then ask their line management for an assessment, and ideally some of your team members because they have a different perspective on you as a product management personality as well.

**中文翻译:**
每个桶都包含至少 15 个引导性问题。比如：这个人擅长做这个吗？那个人擅长做那个吗？希望能通过这些问题让你全面了解这个人的现状。我通常建议人们先进行自评，然后让直属经理进行评估，理想情况下还要让一些团队成员参与，因为他们对你作为产品管理者的性格有不同的视角。

---

### [00:26:27] Lenny

**English:**
So folks who want to see that, maybe they Google PMwheel, Petra, and also link to it. How did you develop this? I managed it and came from talking to a lot of PMs and just like, "Here's the things that I see again and again PMs need to be good at to be successful."

**中文翻译:**
想看这个框架的人可以搜索“PMwheel Petra”，我们也会提供链接。你是如何开发出这个框架的？我猜是通过与大量 PM 交流，然后总结出：“这些是我反复看到的、PM 要想成功必须擅长的事情。”

---

### [00:26:42] Petra Wille

**English:**
Yeah, it was actually ... That would have been pretty cool. It was more the personal need of me starting off as a product coach. And you had this sense of, "I need this compass," because how should you start a coaching conversation. I first have to learn about what is their perception about them and their capabilities in there and the help. And then I can help them work on some of the things they want to work on. But it is often that coaches come totally unprepared to the coaching, especially when the companies actually are paying it for them and to some extent forcing them into the coaching. And then they're just like, "Okay, they told me to show up. Petra, what should we do in these sessions?" And then that's why I created the PMwheel to have these first conversations about where they think we should invest more time in our coaching sessions. So that's how I created it.

**中文翻译:**
是的，其实……如果真是那样就太酷了。但更多是因为我刚开始做产品教练时的个人需求。我当时觉得“我需要这个指南针”，因为教练对话该如何开始呢？我首先得了解他们对自己及其能力的看法，以及他们需要的帮助。然后我才能帮他们改进想提高的地方。但通常被辅导者（coachees）来参加辅导时完全没有准备，尤其是当公司出钱并某种程度上强迫他们参加时。他们会说：“好吧，他们让我来的。Petra，我们这些课程要做什么？” 这就是为什么我创建了 PMwheel，以便进行初步对话，确定他们认为我们在辅导课程中应该把时间花在哪里。这就是它的由来。

---

### [00:27:35] Lenny

**English:**
Cool. Coming back to just the bigger question, we've been talking about just how to become a better manager lead, a coach to your product managers. It's interesting how simple it is. The way you frame this in your writing is it's like five ingredients to be the best coach your PMs have ever had. And if you look at this list of things to do, it's very straightforward and not a lot of work. Figure out what they need to do to be successful, where are they now, align on that with them, and then just give them some things to focus on to move closer to where they need to be. That doesn't take a lot of time.

**中文翻译:**
酷。回到大问题上，我们一直在讨论如何成为更好的经理、领导者和 PM 教练。有趣的是，这其实很简单。你在文章中将其描述为“成为 PM 职业生涯中最佳教练的五个要素”。如果你看这个待办清单，它非常直接，工作量也不大：弄清楚他们成功需要做什么，现状如何，与他们达成一致，然后给他们一些重点关注的事项，让他们向目标迈进。这并不需要很多时间。

---

### [00:28:11] Petra Wille

**English:**
Yeah, I totally agree. The book talks about some more aspects, actually. So that's more or less the first two parts of the book. And then there is more on onboarding and hiring, create product people. There is a lot more. So that's actually the biggest part about how to coach certain concepts of today's product management industry, so to say. Hypothesis-driven product development, for example.

**中文翻译:**
是的，我完全同意。实际上书中还讨论了更多方面。这大概只是书的前两部分。后面还有关于入职引导、招聘、培养产品人才的内容。还有很多。其实最大的篇幅是关于如何辅导当今产品管理行业的一些特定概念，比如假设驱动的产品开发。

---

### [00:28:38] Petra Wille

**English:**
How do you explain these concepts to people that are not yet familiar with these things? And really, it helps product leads to reflect, "Okay, what are the small things that I could help them to get better at certain things?" Because that's actually where a lot of the magic happens. We tend to read all the books and we tend to know all our thought leaders and all these kind of things, but our product people often need super practical advice. So maybe it's really something like explaining them the Eisenhower matrix for getting better time management because they never heard about anything that could help them prioritize their tasks because that's the reality that we find in a lot of the companies, right? So that big part of the book is really this, how do you really help them understand the small tasks and things that the daily work requests them to do.

**中文翻译:**
你如何向还不熟悉这些概念的人解释它们？这确实能帮助产品领导者反思：“好的，我可以帮他们改进哪些小事？” 因为很多奇迹就发生在这里。我们倾向于读所有的书，了解所有的思想领袖，但我们的产品人员往往需要非常实用的建议。比如，给他们解释艾森豪威尔矩阵（Eisenhower matrix）以改善时间管理，因为他们从未听说过任何能帮他们排列任务优先级的东西——这就是我们在很多公司看到的现实，对吧？所以书的大部分内容其实是：你如何真正帮助他们理解日常工作要求他们完成的那些小任务和事情。

---

### [00:29:31] Lenny

**English:**
I think a lot of that I find is when you need something, that's the time to find it, and introduce it, and read about it. There's so much content.

**中文翻译:**
我发现很多时候，当你需要某样东西时，才是寻找、引入并阅读它的最佳时机。现在的内容实在太多了。

---

### [00:29:40] Petra Wille

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:29:41] Lenny

**English:**
I'm guilty of this. Just there's a lot of stuff to read and listen to as a PM. And I find you don't need to be listening to and reading everything all the time. It's just like, I need to figure out how to prioritize. Let's see what's out there that's awesome. And maybe save it for the future, but there's so much stress, I think, that goes into like, "Oh my God, I got to read everything all the time."

**中文翻译:**
我也难辞其咎。作为 PM，有太多的东西要读、要听。我发现你不需要一直听、一直读所有的东西。应该是这样：我需要弄清楚如何排列优先级，那就看看外面有什么棒的资源。也许可以存起来以后看，但我认为“天哪，我必须时刻阅读所有东西”这种想法会带来很大压力。

---

### [00:30:00] Petra Wille

**English:**
Yeah, I totally agree. I think two weeks ago, one of my coaches told me that he stopped reading a lot of books and consuming a lot of content and he instead dedicates the whole year to using one methodology or book. So in that case, pick Teresa's Continuous Discovery Habits and that's what they read over and over again for the whole year. And I think it's an interesting way of looking at things.

**中文翻译:**
是的，我完全同意。两周前，我的一位学员告诉我，他停止了大量阅读和内容消费，转而用一整年的时间去实践一种方法论或一本书。在那个案例中，他选了 Teresa 的《Continuous Discovery Habits》（持续探索习惯），他们一整年都在反复阅读和实践。我觉得这是一种很有趣的视角。

---

### [00:30:30] Lenny

**English:**
That is interesting. That's a very committed, better pick the right book that are or whatever [inaudible 00:30:35].

**中文翻译:**
这很有趣。这需要很大的决心，而且最好选对书。

---

### [00:30:35] Petra Wille

**English:**
Yeah, that she has said is true. Yeah. But maybe some of your colleagues pick another book and then you can just share what you learned, and what works better, and a bit of a community thing.

**中文翻译:**
是的，她说得没错。但也许你的一些同事选了另一本书，然后你们可以分享学到的东西，看看什么效果更好，这有点像社区活动。

---

### [00:30:44] Lenny

**English:**
Oh, we're going to get to that. I like that. Before we get to retelling topic, is there anything else you want to share along the lines of the folks are just like, "I want to become a better coach to my PMs?" Any other thoughts you want to close with?

**中文翻译:**
噢，我们待会会聊到那个。我喜欢这个主意。在进入下一个话题之前，关于“我想成为 PM 的更好教练”，你还有什么想分享的吗？有什么想总结的想法吗？

---

### [00:30:57] Petra Wille

**English:**
Yeah. One easy tip is get yourself a list of great questions that you could ask in one on ones if you don't have the time to prepare. That will be one of my tips as well. There's several great coaching books out there. Some of questions are in my book as well. Yeah, just find some coaching questions, make your small compilation, and then really see what resonates with your team, and that often is a bit of a health check. So how are you doing? What would make you more successful in the role that you're currently having? All these kind of things could be helpful.

**中文翻译:**
有的。一个简单的技巧是：如果你没时间准备，就给自己准备一份可以在 1:1 面谈中提出的好问题清单。这也是我的建议之一。市面上有很多优秀的教练书籍，我的书里也有一些问题。找一些教练问题，做个小集锦，然后看看哪些能引起团队的共鸣。这通常像是一种“健康检查”。比如：你最近怎么样？什么能让你在目前的职位上更成功？所有这些问题都会有帮助。

---

### [00:31:38] Lenny

**English:**
Do you have any other examples of those? That's actually useful and just a few more examples of coaching questions.

**中文翻译:**
你还有其他例子吗？这非常有用，再举几个教练问题的例子吧。

---

### [00:31:44] Petra Wille

**English:**
Yeah, it really depends. So what I find super helpful is a list of emotions because people tend to find it really hard to talk about how they currently really are. And I don't know why this is the case, maybe it's stress, maybe it's not feeling comfortable to talk about this with your line manager, which is another topic, and bringing us back to the topic of company culture. But that, for example, is something that I always have handy. And if I have this notion of, "Okay, this person maybe really needs a hack to some extent," then this conversation about, "Hey, look, there is this list of 30 emotions, where do you think you currently add and why and could I help you with that?" So that could be something. And then there are ... I think you talked about Mochary the other day, right?

**中文翻译:**
这取决于具体情况。我发现非常有帮助的是一份“情绪清单”，因为人们往往觉得很难表达自己真实的现状。我不知道为什么，也许是压力，也许是觉得跟直属经理谈这个不舒服（这是另一个话题，涉及公司文化）。但我总是随身带着这个。如果我觉得“好吧，这个人可能真的需要一些突破”，那么对话就会变成：“嘿，看，这里有 30 种情绪，你觉得你现在处于哪种状态？为什么？我能帮你吗？” 这可能是一个切入点。还有……我想你前几天谈到了 Mochary，对吧？

---

### [00:32:31] Lenny

**English:**
Yeah. That episode just came out.

**中文翻译:**
是的，那集刚播。

---

### [00:32:33] Petra Wille

**English:**
Yeah, exactly. And he has a great framework as well. I would need to look the questions up, but maybe we put them in the show notes as well. That's a bit of in-house check as well and huge. First of all, it's five easy assessment questions for your folks. And then it's more of, "Okay, if you're ranking yourself a six, how could I help you to make it a seven?" So it really focuses on incremental improvements, not crazy stressing everybody out improvements, not, "What could I do to make it a 10?" It's more really, "How could I improve your situation? Really build rapport, really be there for your product folks.

**中文翻译:**
没错。他也有一个很棒的框架。我需要查一下那些问题，也许我们可以把它们也放在节目笔记里。那也是一种内部检查，非常有意义。首先，是给员工的五个简单的评估问题。然后是：“好的，如果你给自己打 6 分，我该如何帮你达到 7 分？” 它的重点在于“增量改进”，而不是那种让每个人都压力山大的改进，不是问“我该怎么做才能达到 10 分？” 更多是：“我该如何改善你的处境？” 真正建立联系，真正支持你的产品人员。

---

### [00:33:11] Petra Wille

**English:**
And I think creating this list of coaching questions as a go-to list could improve the quality of your one on ones because, let's face it, we often run into those ones. Either we ditch them or we run into those ones completely unprepared. And a development plan could help and a prepared list of coaching questions could help to make it way easier. And for your PMs to feel more valued.

**中文翻译:**
我认为创建一个教练问题清单作为常用工具，可以提高 1:1 面谈的质量。因为让我们面对现实吧，我们经常在面谈时要么取消，要么完全没准备就去了。发展计划和准备好的教练问题清单可以让这件事变得容易得多，也能让你的 PM 感到更受重视。

---

### [00:33:37] Lenny

**English:**
That's a great callback to the Matt. And by the way, his name's France, Matt Moshary, instead of Mochary. The C-H was like a sh.

**中文翻译:**
这是对 Matt 的很好回应。顺便说一下，他的名字发音是 Matt Moshary，而不是 Mochary。“C-H”发“sh”的音。

---

### [00:33:44] Petra Wille

**English:**
I see.

**中文翻译:**
明白了。

---

### [00:33:44] Lenny

**English:**
Yeah. Now, we know.

**中文翻译:**
是的，现在我们知道了。

---

### [00:33:46] Petra Wille

**English:**
[inaudible 00:33:46] learn something. Now, we know. That's good.

**中文翻译:**
学到了新东西。现在知道了，很好。

---

### [00:33:49] Lenny

**English:**
Yeah. And you pointed out in his curriculum, he has a bunch of questions that you mentioned about where are you at one to 10 on this thing and then how do we get you to ... eight or nine. So we'll link to that in the show notes also. So many more things to read from this podcast.

**中文翻译:**
是的。你指出在他的课程体系中，有很多你提到的问题，比如“这件事你打 1 到 10 分是多少”，以及“我们如何让你达到 8 分或 9 分”。我们也会在节目笔记中提供链接。这集播客要读的东西真多。

---

### [00:34:02] Petra Wille

**English:**
So many things to link. Sorry.

**中文翻译:**
要链接的东西太多了，抱歉。

---

### [00:34:06] Lenny

**English:**
Good God, poor listeners.

**中文翻译:**
天哪，可怜的听众们。

---

### [00:34:06] Lenny

**English:**
This episode is brought to you by AssemblyAI. If you're looking to build powerful AI-powered features in your audio or video products, then you need to know about AssemblyAI. AssemblyAI is the API platform for state-of-the-art AI models, the thousands of product-led growth companies like Spotify, Loom, and CallRail are using to infuse AI into their products. With simple APIs, developers and PMs can get access to powerful AI models for transcription, summarization, and dozens of other tasks that are fast, secure, and production ready. All of their models are researched and trained in-house and continuously updated by their team of AI experts, which, for PM, makes it easy to build and ship new AI-powered features.

**中文翻译:**
本集节目由 AssemblyAI 赞助。如果你想在音频或视频产品中构建强大的 AI 功能，那么你需要了解 AssemblyAI。AssemblyAI 是一个提供顶尖 AI 模型的 API 平台，成千上万的产品驱动增长型公司（如 Spotify、Loom 和 CallRail）都在使用它将 AI 注入产品中。通过简单的 API，开发人员和 PM 可以访问强大的 AI 模型，用于转录、摘要以及数十种其他任务，这些模型快速、安全且已具备生产就绪能力。他们所有的模型都是内部研发和训练的，并由 AI 专家团队持续更新，这让 PM 能够轻松构建和发布新的 AI 驱动功能。

---

### [00:34:50] Lenny

**English:**
Product teams at the startups and enterprises are using AssemblyAI to automatically transcribe and summarize phone calls and virtual meetings, detect topics in podcasts, pinpoint when sensitive content is spoken, redact PII from audio videos, and way more.

**中文翻译:**
初创公司和企业的项目团队正在使用 AssemblyAI 自动转录和总结电话及虚拟会议、检测播客主题、精准定位敏感内容、从音视频中脱敏个人身份信息（PII）等等。

---

### [00:35:06] Lenny

**English:**
Visit assembly ai.com to try AssemblyAI's API for free and start testing their models in their no-code playground. That's assembly ai.com.

**中文翻译:**
访问 assemblyai.com 免费试用 AssemblyAI 的 API，并在其无代码游乐场中开始测试他们的模型。网址是 assemblyai.com。

---

### [00:35:17] Lenny

**English:**
Well, let's get to a happier, simpler topic, maybe not, storytelling. So just setting context. It feels like as a PM, also as a founder, also as just a leader of any kind, you're always told you need to be a great storyteller. That's a big part of leadership. Be a great storyteller because that gets people excited and onboard with your building. But it feels like I've heard so many things about becoming a better storyteller. There's always feels great when you're reading it and then you get to a deck you're starting or a meeting you're about to run or a doc and like, "Shit, how do I make this a good story?" I need some conflict maybe and a ... I don't know, there's a hero's journey, there's all these things that you're like, "I don't know, I don't know what I'm doing."

**中文翻译:**
好了，让我们进入一个更愉快、更简单的话题（也许并不简单）：讲故事（Storytelling）。先设定一下背景。感觉作为 PM，或者作为创始人，或者作为任何类型的领导者，你总被告知需要成为一个优秀的讲故事的人。这是领导力的重要组成部分。成为优秀的讲故事者，因为这能让人们感到兴奋并支持你的建设。但我感觉听过太多关于如何成为优秀讲故事者的建议了。读的时候感觉很棒，但当你开始做 PPT、准备会议或写文档时，就会想：“该死，我怎么把它变成一个好故事？” 我可能需要一些冲突，还有……我不知道，还有英雄之旅，所有这些东西让你觉得：“我不知道，我不知道自己在做什么。”

---

### [00:36:02] Lenny

**English:**
So I guess just a broad question. Say you're PM who wants to get better at storytelling, do you have any things you would suggest that are just concrete things someone could do today, tomorrow, this week to become a better storyteller, to level up their storytelling skills?

**中文翻译:**
所以我有一个宽泛的问题。假设你是一个想提高讲故事能力的 PM，你有什么建议吗？有没有什么具体的事情是某人今天、明天或本周就可以做的，以此来成为更好的讲故事者，提升他们的讲故事技巧？

---

### [00:36:18] Petra Wille

**English:**
Yes, I think I would love to mention two things. So first of all, people that's starting, often they are getting a better storytelling journey. Often totally underestimate how many time actually great storytellers are investing in creating the stories and making sure they can share the story in nice ways and formats. So that's maybe the first tip, you have to plan to put in a lot of work to create your story.

**中文翻译:**
是的，我想提两点。首先，刚开始尝试提升讲故事能力的人，往往完全低估了优秀的讲故事者在创作故事以及确保以优美的方式和格式分享故事上投入了多少时间。所以这可能是第一个建议：你必须计划投入大量工作来创作你的故事。

---

### [00:36:46] Lenny

**English:**
And when you say a lot of work, what are you thinking? What's an order of magnitude of time depending on the scale of the story or a deck, or?

**中文翻译:**
当你说“大量工作”时，你指的是什么？根据故事或 PPT 的规模，时间量级大概是多少？

---

### [00:36:55] Petra Wille

**English:**
Rule of thumb. So I think if you ... Let's say you want to explain the rest of the company what you and the team are up for the next three to four months, so to say. Then I think that's two weeks of work, not eight hours a day, obviously, but two weeks of work, maybe one or two hours a day to really carve that story and think about different audiences and different framings of, when am I able to tell the story? And that is actually, I think, a rule of thumb of time investment. So it takes time because people often think, "I don't know, you just get better overnight in telling great stories." It's just not how it works. So you have to practice and you have to put in a lot of work and time to come up with a logical, compelling, motivating story that then lasts for longer than a week or two. So that's a lot of work.

**中文翻译:**
经验法则。假设你想向公司其他部门解释你和团队在未来三到四个月要做什么。我认为这需要两周的工作时间，显然不是每天 8 小时，而是两周内每天花一两个小时来打磨那个故事，思考不同的受众，以及不同的切入点：我什么时候能讲这个故事？我认为这就是时间投入的经验法则。这需要时间，因为人们常想：“我不知道，也许一夜之间就能学会讲好故事。” 事实并非如此。你必须练习，必须投入大量工作和时间，才能构思出一个逻辑严密、引人入胜、具有激励作用的故事，并且这个故事的影响力能持续超过一两周。所以这是一项繁重的工作。

---

### [00:37:48] Petra Wille

**English:**
And then the other tip would be really make sure that you're using language that speaks to the heart and the minds of the people because we constantly tend to use too much of our business lingo and it's banner blindness. Some of the words that we're using people totally overhearing them because we're using them so often. And it could be even things like product discovery. So maybe your company is already so fed up with all your product discovery stuff that you should start using different terms. Even if then, say, hypothesis-driven product management, it's more or less the same thing, and maybe it's even too complex. Maybe you can find something simpler and say, "We need to learn something about this particular thing," because studies show that's a scientific background. Stories really have an impact on our brain.

**中文翻译:**
另一个建议是，一定要确保你使用的语言能触动人们的心灵和思想。因为我们总是倾向于使用太多的商业术语，这会产生“视而不见”的效果。有些词我们用得太频繁了，以至于人们完全听不进去。甚至像“产品探索”这样的词也是如此。也许你的公司已经对你那些“产品探索”的东西感到厌烦了，那你应该开始使用不同的术语。即使你说“假设驱动的产品管理”，它或多或少是一回事，而且可能还太复杂。也许你可以找个更简单的说法，比如“我们需要了解关于这个特定事物的某些信息”。研究表明，这有科学背景，故事确实会对我们的大脑产生影响。

---

### [00:38:45] Petra Wille

**English:**
So hormones get released depending on how the story is actually formed, if they have cliffhangers or if it's really like, whoa, with the hero and think, "Where is it going to take him", or something like that. And that releases, yeah, hormones in your brain and that only happens if you're using natural world, so to say. So you could talk about smell, and sense, and how people feel, and how their life would be better if this product would be out, all these kind of things. So really make sure that you think about that really speak to their minds and to their hearts and remove all your three-letter abbreviations and all these kind of things, which is something that everybody says as well. But it is way harder to do it when you really start to create your story to remove all these terms. And that takes a lot of time, yeah, as well. So you have to really put an effort into the don't use too much [inaudible 00:39:46].

**中文翻译:**
激素的释放取决于故事的构成方式，比如是否有悬念，或者是否真的像“哇，英雄出现了，他会去哪里”之类的情节。这会在你的大脑中释放激素，而这只有在你使用“自然语言”时才会发生。所以你可以谈论气味、感觉、人们的感受，以及如果这个产品问世，他们的生活会如何变得更好。所以一定要确保你的表达能触及他们的思想和心灵，去掉所有的三字母缩写词之类的东西。虽然每个人都这么说，但当你真正开始创作故事并试图移除这些术语时，会发现这要难得多。这也需要很多时间。所以你必须真正努力不去使用太多的专业术语。

---

### [00:39:47] Lenny

**English:**
So the first point, which I love, is you think people are just good at this and naturally great at telling a great story. But a lot of it is ... Right. Some people are ... You do it enough and you're like, "It'll be quicker probably." But for most people, it's going to be just put in the time and it gets better and better and your story merges, you practice.

**中文翻译:**
我非常喜欢第一点，即人们总以为别人天生就擅长讲故事。但实际上……没错，有些人确实有天赋，或者你做得足够多，速度会变快。但对大多数人来说，就是投入时间，它会变得越来越好，故事会逐渐成型，你需要不断练习。

---

### [00:40:04] Petra Wille

**English:**
Yeah. And it's a cultural thing. So I really find in average Americans, for example, being better at it than most of us Europeans. And I think that's because even in your school system, it seems to me, I don't know, you tell me if that is the case, but storytelling and being in front of a class or something like this is something that is encouraged and valued already, where at least when I was at school, this was not part of the whole system at all. So really late it was part of what we did, but not from an early age. So it's just not something, yeah, that we trained in or that we used to. So sometimes even speaking in front of 30 people, people are freaking out because they never did that. So that's their cultural differences to that definitely as well.

**中文翻译:**
是的。这也有文化因素。例如，我发现美国人平均而言比我们大多数欧洲人更擅长这个。我认为这是因为在你们的学校系统中（我不知道是不是这样，你可以告诉我），讲故事和在全班面前演讲是受到鼓励和重视的。而至少在我上学的时候，这根本不是整个系统的一部分。直到很晚才成为我们学习内容的一部分，而不是从小就开始。所以这并不是我们训练过或习惯的事情。因此，有时即使只是在 30 人面前讲话，人们也会吓坏，因为他们从未做过。所以这其中肯定也存在文化差异。

---

### [00:40:57] Lenny

**English:**
Speaking of the idea of speaking in public and being nervous and that kind of thing, which I always get really nervous speaking in public and people don't think that when they hear me and other folks that are publicly speaking, but it's like freaks me out every time. Do you have any advice for people that want to become better public speakers/be less nervous speaking publicly?

**中文翻译:**
说到公开演讲和紧张之类的事情，我公开演讲时总是非常紧张，人们听我和其他公开演讲者说话时可能感觉不到，但其实每次都让我吓得够呛。对于那些想成为更好的公开演讲者或想在公开演讲时减少紧张感的人，你有什么建议吗？

---

### [00:41:20] Petra Wille

**English:**
I was really bad in [inaudible 00:41:21] as well, I have to tell you. And it's still not something that I love, but I know it's part of the work that we do.

**中文翻译:**
我得告诉你，我以前在这方面也很糟糕。现在我也谈不上喜欢，但我知道这是我们工作的一部分。

---

### [00:41:30] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:41:31] Petra Wille

**English:**
And so the easiest way is to get in front of really small and super friendly audiences. So that is, I think, the first starting point. And I don't know where that is. That could be your team, that's a super small audience, usually five to 10 people, or maybe you pine with your company of 80 people or 120 people, maybe the company all-hands is already something where you could actually speak. That was my first time and I had to speak in front of the whole company at a company all-hands around 90 people back at the time. And I only had to give a brief update on what we did the last two weeks and it was like five minutes on stage, but it freaked me out.

**中文翻译:**
所以最简单的方法就是面对非常小且超级友好的观众。我认为这是第一个起点。我不知道具体在哪里，可能是你的团队，那是一个非常小的受众，通常只有 5 到 10 人。或者可能是你那 80 人或 120 人的公司，也许公司全体会议（all-hands）就是你可以发言的地方。那是我的第一次，当时我必须在全公司大约 90 人的全体会议上发言。我只需要简要介绍一下过去两周我们做了什么，在台上只有五分钟，但把我吓坏了。

---

### [00:42:14] Petra Wille

**English:**
So that's where I'm coming from and it really helped me to start small. Then product tanks, for example, this local product community meetups totally helped me because friendly human beings and not too many of them. So sometimes they're just 30 people attending and then you in the summer, not so many people are coming, so why not giving a talk there? So really start small and then grow the audience over time and always make sure, because that helped me a lot, to get feedback from strangers and peers if possible. Because the peers tend to give you the harsher critique, so to say, where the strangers are more polite, but they're not so familiar with the work you do or with the story that you want to tell so they can spot some gaps in your storytelling technique or something like that.

**中文翻译:**
这就是我的经历，从小处着手真的很有帮助。然后，比如 ProductTank 这种当地的产品社区聚会，对我帮助很大，因为那里的人很友好，而且人数不多。有时只有 30 人参加，夏天人更少，为什么不在那里做个演讲呢？所以真的要从小开始，然后随着时间的推移增加受众。并且一定要确保（因为这对我帮助很大）尽可能从陌生人和同行那里获得反馈。因为同行往往会给你更严厉的批评，而陌生人更礼貌，但他们对你的工作或你想讲的故事不那么熟悉，所以他们能发现你讲故事技巧中的一些漏洞。

---

### [00:43:07] Petra Wille

**English:**
So that is something that helped me a lot to always have this friendly soul in the front row, where I know I get some feedback from later on. Plus, then having complete strangers and there's always somebody coming up after the talk, right, so they could be your first person giving you some stranger feedback, so to say.

**中文翻译:**
所以对我很有帮助的一点是，总是在前排找一个友好的面孔，我知道稍后可以从他那里得到反馈。此外，面对完全陌生的人，演讲结束后总会有人走过来，对吧？他们可以成为第一个给你提供“陌生人反馈”的人。

---

### [00:43:25] Lenny

**English:**
What about if you're just about to give a talk and you're like, "Oh my god, I'm so nervous," do you find anything that helps you get over that?

**中文翻译:**
如果你正要开始演讲，心里想“天哪，我太紧张了”，你有没有发现什么能帮你克服这种情绪的方法？

---

### [00:43:33] Petra Wille

**English:**
I think the two things that work well, it's either the Superman pose, so that is one thing. If you're standing like this looking straightly up, that is one thing that helps many people. It's not my preferred one. And then the other one is a bit of the gorilla thing, just like tapping here. There is ... I don't know what's the English-

**中文翻译:**
我认为有两件事很管用。一个是“超人姿势”，就是那样站着，直视上方，这能帮到很多人。这不是我的首选。另一个有点像大猩猩，就是拍打这里。那个……我不知道英语怎么说——

---

### [00:43:56] Lenny

**English:**
Vagus, the vagus nerve.

**中文翻译:**
迷走神经（Vagus nerve）。

---

### [00:43:57] Petra Wille

**English:**
No, it's not the vagus nerve.

**中文翻译:**
不，不是迷走神经。

---

### [00:43:57] Lenny

**English:**
Oh, a different.

**中文翻译:**
噢，那是别的。

---

### [00:43:58] Petra Wille

**English:**
I think it's thymus.

**中文翻译:**
我想是胸腺（thymus）。

---

### [00:43:58] Lenny

**English:**
Okay.

**中文翻译:**
好的。

---

### [00:43:59] Petra Wille

**English:**
I need to look it up. And if you just, yeah, hit that softly for some time ...

**中文翻译:**
我需要查一下。如果你只是轻轻地拍打它一段时间……

---

### [00:44:07] Lenny

**English:**
Yeah, I can hear it.

**中文翻译:**
是的，我能听到声音。

---

### [00:44:07] Petra Wille

**English:**
... then, yeah, that bumps your energy level, so to say. So that helps me. And again, friendly faces front row. So find people that you like and respect and that you know have the spark in their eyes when you start talking. That definitely helps as well.

**中文翻译:**
……那么，是的，这会提升你的能量水平。这对我有帮助。再次强调，前排要有友好的面孔。找一些你喜欢和尊重的人，你知道当你开始说话时，他们的眼中会有光。这绝对也有帮助。

---

### [00:44:24] Lenny

**English:**
Do you suggest doing these moves in the bathroom where no one can see you, or?

**中文翻译:**
你建议在没人看见的洗手间里做这些动作吗？

---

### [00:44:29] Petra Wille

**English:**
Yes, backstage. You're doing those ones backstage. And think about what you're wearing because if you're wearing something like that and do this before you enter the stage, people might see that.

**中文翻译:**
是的，在后台。你在后台做这些动作。还要考虑你穿的衣服，因为如果你穿着那样的衣服并在上台前做这个动作，人们可能会看到。

---

### [00:44:38] Lenny

**English:**
They might love that.

**中文翻译:**
他们可能会喜欢的。

---

### [00:44:38] Petra Wille

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:44:38] Lenny

**English:**
Just come out beating your chest. It's a power move.

**中文翻译:**
直接捶着胸口出来。这可是个霸气的动作。

---

### [00:44:38] Petra Wille

**English:**
Yeah.

**中文翻译:**
没错。

---

### [00:44:39] Lenny

**English:**
Do you think it's important for PMs and leaders in general to get great at public speaking or do you think it's okay if they are just okay?

**中文翻译:**
你认为对于 PM 和一般的领导者来说，擅长公开演讲很重要吗？还是你觉得只要表现尚可就行？

---

### [00:44:53] Petra Wille

**English:**
It really depends. So I think not being able to speak publicly and to bring your point across ... Because a lot of people do public speaking, but they never bring their point across. So if you want to achieve both things, I think it is a career solo if you can for a product person. Can do the IC level product management job, but getting promoted is way harder if you're not good in telling stories and rallying the team behind the shared goal and all these kind of things. And you usually achieve this through good storytelling techniques.

**中文翻译:**
这真的取决于具体情况。我认为如果不能公开演讲并清晰表达观点……因为很多人虽然在公开演讲，但从未把观点表达清楚。如果你想同时做到这两点，我认为对于产品人来说，这会是职业生涯的助推器。你可以做 IC 级别的产品管理工作，但如果你不擅长讲故事、不擅长围绕共同目标凝聚团队，那么晋升就会困难得多。而你通常需要通过优秀的讲故事技巧来实现这些。

---

### [00:45:33] Petra Wille

**English:**
And in some teams, I've seen the product person not being really, really good at it, but then the whole team helped creating the stories and stuff like this. So you definitely could compensate to some extent, but I would consider it a bit of a career solo if you don't get to decent level of storytelling and to a decent level of public speaking. So, yeah, I think it's important.

**中文翻译:**
在一些团队中，我见过产品负责人并不擅长此道，但整个团队会协助创作故事。所以你确实可以在一定程度上弥补，但如果你无法达到一定的讲故事水平和公开演讲水平，我认为这会阻碍你的职业发展。所以，是的，我认为这很重要。

---

### [00:45:54] Lenny

**English:**
Who's the best storyteller PM that you've met and what made them great?

**中文翻译:**
你见过的最擅长讲故事的 PM 是谁？是什么让他们如此出色？

---

### [00:45:59] Petra Wille

**English:**
That's another hard question. So who had the biggest influence on me was definitely Jason Goldberg. He was my former boss and he was the first person that came into the startup that I was working for back at the time. And he was really the first person who entered every stage that he could find to talk about the things that he wants to achieve with us as a product team and as a product organization. In a way, it was really motivational, so it really helped me to experience that and how he was using this product, evangelizing techniques, yeah, to actually really tell the whole company what we're up for currently and what the problems out there he thinks are worth solving. So that was definitely an inspiration.

**中文翻译:**
这又是另一个难题。对我影响最大的人绝对是 Jason Goldberg。他是我的前老板，也是当时我所在初创公司的第一批员工。他真的是第一个利用每一个能找到的舞台，来谈论他想和我们这个产品团队及产品组织共同实现的目标的人。在某种程度上，这非常有激励作用，它真的帮助我体验到了这一点，以及他如何利用这种“产品布道”技巧，向全公司传达我们目前的任务，以及他认为哪些问题值得解决。这绝对是一种启发。

---

### [00:46:47] Petra Wille

**English:**
And then I think another great speaker is definitely Hans Rosling. He's no longer with us. That's sad. But he gave great TED Talks, really data-heavy TED Talks because they often hear from product people, yeah, but the work we do that's so boring, how could we make a great story out of that? And I think Hans Rosling showed over and over again that you can. So that definitely is an inspiration.

**中文翻译:**
然后，我认为另一位伟大的演讲者绝对是 Hans Rosling。他已经去世了，这很令人遗憾。但他做过非常精彩的 TED 演讲，那是数据量非常大的演讲。因为产品人经常抱怨：“我们做的工作太无聊了，怎么能把它变成一个好故事呢？” 我认为 Hans Rosling 一次又一次地证明了你可以做到。所以这绝对也是一种启发。

---

### [00:47:14] Petra Wille

**English:**
And then on a totally different note, I love spoken word poetry because it really talks to the heart and minds of people. And in my coaching, I usually send people off to the TED Talk from Sarah Kay, which has the nice title, If I Should Have a Daughter. And that really helps people to understand, "Ah, okay, that's how you could be playful with words." And that's what happens to me personally and to my body and to my emotions if I listen to something like that. So that's maybe three things I could be mentioning.

**中文翻译:**
另外，从完全不同的角度来看，我喜欢口语诗（spoken word poetry），因为它真的能触及人们的心灵和思想。在我的辅导中，我通常会推荐人们去看 Sarah Kay 的 TED 演讲，题目很美，叫《If I Should Have a Daughter》（如果我有个女儿）。这真的能帮助人们理解：“啊，原来可以这样玩转文字。” 当我听那样的演讲时，我个人、我的身体和我的情绪都会产生共鸣。这就是我可以提到的三件事。

---

### [00:47:49] Lenny

**English:**
Hans Rosling's the guy with the world poverty charts and ...

**中文翻译:**
Hans Rosling 就是那个展示世界贫困图表的人，还有……

---

### [00:47:54] Petra Wille

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:47:54] Lenny

**English:**
Yeah, yeah.

**中文翻译:**
是的，是的。

---

### [00:47:57] Petra Wille

**English:**
On world and data.

**中文翻译:**
关于世界和数据。

---

### [00:47:57] Lenny

**English:**
Right.

**中文翻译:**
对。

---

### [00:47:57] Petra Wille

**English:**
Now, his son is, I think, in charge, but, yeah.

**中文翻译:**
现在我想是他儿子在负责，但是，是的。

---

### [00:48:00] Lenny

**English:**
Cool. I'm excited. I'm going to watch that one again. That's a good reminder. Maybe just another question around storytelling. Say you're a PM and you're about to start a document or a deck and you just want it to be a good story, what are two or three things you should just do to set yourself up for success?

**中文翻译:**
酷。我很兴奋，我要再看一遍那个演讲。这是一个很好的提醒。关于讲故事，可能还有另一个问题。假设你是一个 PM，正准备开始写一份文档或做一个 PPT，你希望它是一个好故事，你应该做哪两三件事来确保成功？

---

### [00:48:17] Petra Wille

**English:**
Yeah. First of all, don't sit in front of the blank page for too long, just start drafting something. I think there's a lot of beauty in story as a design tool, so to say, because it's even easier to change a story than it is to change a prototype, right? So even before you put something in writing, you could start talking about it and see how it lands and then tweak it. And I think that's the first thing, get going.

**中文翻译:**
好的。首先，不要对着空白页坐太久，先开始起草一些东西。我认为故事作为一种设计工具非常有魅力，因为修改一个故事比修改一个原型要容易得多，对吧？所以甚至在你动笔写之前，你就可以开始谈论它，看看效果如何，然后进行调整。我认为第一件事就是：动起来。

---

### [00:48:43] Petra Wille

**English:**
And then the other thing is go start talking about your story, go test it, see how it resonates, and then tweak it. And maybe you could use one of the proven story structures, find the one that helps you most. Really, even if it's super boring, but I'll use this hero's journey a lot where I think about, should I put the team in the heart of the story? Because if it's a story that should help me to motivate the team or to inspire the team to actions or something like that, then maybe it's nice if I put them in the center of the story and make them the heroes and talk about the demons and monsters they have to fight to once arrived at this brighter future.

**中文翻译:**
另一件事是开始讲述你的故事，去测试它，看看它如何引起共鸣，然后进行调整。也许你可以使用一种经过验证的故事结构，找到对你最有帮助的那种。真的，即使它听起来很无聊，但我经常使用“英雄之旅”，我会思考：我应该把团队放在故事的核心吗？如果这个故事是为了激励团队或启发团队采取行动，那么如果我把他们放在故事的中心，让他们成为英雄，讲述他们为了到达光明的未来必须与之战斗的恶魔和怪物，那可能会很棒。

---

### [00:49:25] Petra Wille

**English:**
And maybe some other times, it makes sense to put the user there and really talk about how their world and lives would have improved once this product is out and available. Or maybe it's even a feature that we're talking about or a bigger redesign or whatever you're currently working on, right? But you could use this proven story structure and see what are the things in there. So the call to adventure, what is the call to adventure? What is this bright future? And it helps you to start and to get going.

**中文翻译:**
而在其他时候，把用户放在核心位置可能更有意义，真正谈论一旦这个产品问世并可用，他们的世界和生活将如何得到改善。或者我们讨论的甚至只是一个功能，或者是一次重大的重新设计，或者你目前正在做的任何事情，对吧？但你可以使用这种经过验证的故事结构，看看其中的要素。比如“冒险的召唤”是什么？那个“光明的未来”又是什么？这能帮你开始并坚持下去。

---

### [00:49:55] Petra Wille

**English:**
And then I usually advise people to have the story handy in various formats. So spoken that you could actually talk about it. Written, because we all tend to work in remote or asynchronous environment. So just a recorded video maybe. Yeah, it's good, but maybe a written version of it is nice as well. And the next one is an illustration that helps you making some of the core points of your story visible to the audience. And that could be a whiteboard drawing, a flipchart drawing. It could be a bigger, maybe it's five slides with emotional pictures on it or whatever it is, but be visual with your story as well.

**中文翻译:**
然后，我通常建议人们准备各种格式的故事。口头形式，这样你就可以实际谈论它。书面形式，因为我们都倾向于在远程或异步环境下工作。所以可能只是一个录制的视频。是的，这很好，但书面版本可能也不错。再下一个是插图，它可以帮助你向受众展示故事的一些核心观点。这可以是白板画、挂图画。也可以是更大的东西，比如五张带有情感色彩图片的幻灯片，无论是什么，都要让你的故事具有视觉效果。

---

### [00:50:37] Petra Wille

**English:**
And then you should have it ready in three different formats in a super short 75-second elevator pitch version. In the six minutes, I can do this before we actually start planning version. And ideally, I have to go to the company all-hands and have to talk about what we will look into for the next four months. And that's maybe an 80 minutes version. And 80 minutes is the length of an average TED Talk, and there is a reason for that. It has to do with attention spans and all these kind of things. So that's why I advise people to use this three length.

**中文翻译:**
然后你应该准备三种不同长度的版本：一个超短的 75 秒电梯演讲版本；一个 6 分钟版本，可以在我们实际开始规划之前讲完；理想情况下，还有一个版本是当我必须参加公司全体会议并谈论未来四个月的工作时使用的，那可能是 18 分钟的版本。18 分钟是 TED 演讲的平均长度，这是有原因的，它与注意力持续时间等因素有关。这就是为什么我建议人们使用这三种长度。

---

### [00:51:14] Lenny

**English:**
An example you're using there is a PM designing the vision for their team potentially or their strategy for the next, say, six months, right?

**中文翻译:**
你举的例子是一个 PM 正在为他们的团队设计愿景，或者制定未来比如六个月的策略，对吧？

---

### [00:51:21] Petra Wille

**English:**
Yeah, exactly. So we don't need to create this complicated story for the next sprint, I'd say. That's too much of an effort, maybe waste of time. You need to look a bit further out to make it worth spending a lot of time on creating your story.

**中文翻译:**
是的，没错。我想说，我们不需要为下一个冲刺（sprint）创作这么复杂的故事。那太费劲了，可能是浪费时间。你需要看得更远一点，才值得花大量时间去创作故事。

---

### [00:51:38] Lenny

**English:**
If you had to pick one book or resource that helped you become a better storyteller or that you found other people coming back to that helps them level up their storytelling skills, what comes to mind? I'll share one first as you think about that. There's a recent book that you wouldn't think would be good at this, but it is really good at helping understand how to tell a story. And it's called Nobody Wants to Read Your Shit. And it's by ... Yeah. And the title alone is a great lesson, which is, nobody wants to read your stuff. Yeah. But the premise of the book is how to make it so that people find it interesting and useful. It's by Steven Pressfield who wrote The War of Art and Bagger Vance and all these things. So it's one of his new books, I think. So that's what comes to mind.

**中文翻译:**
如果你必须选择一本书或一个资源，它曾帮助你成为更好的讲故事者，或者你发现别人反复使用它来提升讲故事技巧，你会想到什么？在你思考的时候，我先分享一个。最近有一本书，你可能想不到它在这方面很有用，但它确实能很好地帮助理解如何讲故事。书名叫《Nobody Wants to Read Your Shit》（没人想看你写的烂东西）。作者是……是的，单看书名就是一个很好的教训，即没人想看你写的东西。但这本书的前提是：如何让人们觉得它有趣且有用。作者是 Steven Pressfield，他还写过《The War of Art》（艺术之战）和《Bagger Vance》（重返荣耀）等书。我想这是他的新书之一。这就是我能想到的。

---

### [00:52:22] Petra Wille

**English:**
That's pretty cool.

**中文翻译:**
那太酷了。

---

### [00:52:22] Petra Wille

**English:**
Back in the day when Marty Cagan was my product coach, he made me read Selling the Dream, which is the Macintosh story on product evangelizing by Guy Kawasaki. And it didn't help me to become a better storytelling, but it helped me realize that it's really important that I work on that skill. So that is actually the trigger and material that helped me is basically everything from Nancy Duarte and Duarte Inc. So there are even leadership books about rituals and how to ignite the spark in all the people you're having. So they're talking a lot about the leadership aspect of storytelling, but they have something for the IC level as well, 72 rules on storytelling and all these kind of things. And I have a lot of free material. I know it's not a book, but they have several books and that was great material that helped me to become better.

**中文翻译:**
以前 Marty Cagan 做我的产品教练时，他让我读了《Selling the Dream》（推销梦想），那是 Guy Kawasaki 写的关于麦金塔电脑产品布道的故事。它并没有直接帮我成为更好的讲故事者，但它让我意识到磨练这项技能非常重要。所以这其实是一个触发点。真正帮到我的材料基本上都来自 Nancy Duarte 和 Duarte 公司。甚至还有关于仪式以及如何点燃员工激情的领导力书籍。他们谈论了很多讲故事的领导力方面，但他们也有针对 IC 级别的内容，比如讲故事的 72 条规则等等。他们有很多免费材料。我知道那不是一本书，但他们出过几本书，那些都是帮我变得更好的绝佳材料。

---

### [00:53:16] Lenny

**English:**
Man, the show notes on this episode are going to be out of control. It's going to hit some limit for [inaudible 00:53:20].

**中文翻译:**
天哪，这集的节目笔记要失控了。肯定会达到某种上限。

---

### [00:53:20] Petra Wille

**English:**
Yeah, maybe we're ... Yeah, the longest show notes ever. Sorry.

**中文翻译:**
是的，也许我们……是的，史上最长的节目笔记。抱歉。

---

### [00:53:24] Lenny

**English:**
Oh my God. Yeah, it's going to be rough. I'm actually going to try to get Nancy Duarte in this podcast.

**中文翻译:**
我的天。是的，这会很辛苦。我其实正打算邀请 Nancy Duarte 来参加这个播客。

---

### [00:53:29] Petra Wille

**English:**
Ooh, yeah.

**中文翻译:**
噢，太棒了。

---

### [00:53:30] Lenny

**English:**
So that's a good ... That's-

**中文翻译:**
所以那是个好……那是——

---

### [00:53:31] Petra Wille

**English:**
Say hi if you do. Yeah, I'm a fan.

**中文翻译:**
如果你邀请到了，代我向她问好。我是她的粉丝。

---

### [00:53:34] Lenny

**English:**
Okay, I'll do that. I'll do that. Okay. So getting to our final topic, which is around community. You're a big fan of finding community and just the power of being in a community, and I know you've done a bunch of research there, you're just like pumping your fist as we talk about this. I love it. So tell us why you're such a big fan of the power of community for product managers in general.

**中文翻译:**
好的，我会的。我会的。好的。现在进入我们的最后一个话题：社区。你是寻找社区以及社区力量的忠实拥护者，我知道你在这方面做了很多研究，当我们谈到这个时，你兴奋得握紧了拳头。我喜欢这种热情。那么请告诉我们，为什么你如此推崇社区对产品经理的力量。

---

### [00:53:54] Petra Wille

**English:**
Again, the starting point was a rather egocentric starting point because I'm constantly thinking about, how could I scale the work that I do because I still see so many companies not getting a product coach or I still see so many companies where people development is not a priority, all these kind of things. And at some point, I thought, if the line manager is not taking care of the personal development, who could? And I talked to several of my colleagues about the question and, at some point, somebody said, "Yeah, that's what community of practices are often used for." So that's where a lot of people get their inspiration. And basically, I reflected on my career. And early on, I was in a super engaging product organization where, really, we tried a lot, we shared a lot. A lot of the things that we tried didn't work at all, but others really fell on fertile grounds and we could learn from each other.

**中文翻译:**
同样，起点其实是比较自我中心的，因为我一直在思考如何扩大我工作的规模。因为我仍然看到很多公司没有请产品教练，或者人才培养不是优先事项等等。在某个时刻我想，如果直属经理不负责个人发展，谁能负责呢？我和几位同事讨论了这个问题，有人说：“是的，这就是‘实践社区’（Community of Practice）通常的作用。” 很多人就是从那里获得启发的。基本上，我反思了自己的职业生涯。早期，我在一个非常投入的产品组织中，我们尝试了很多，分享了很多。我们尝试的很多东西根本行不通，但其他的确实在肥沃的土壤上生根发芽，我们可以互相学习。

---

### [00:54:55] Petra Wille

**English:**
And we invested quite some time in this sharing, but everyone got better over time because of this community being present. And so I decided to make this my topic for this year's research, so to say. And I was talking to a lot of my clients and former clients, "Hey, are you running a community of practice? If you don't run a community of practice, why is that?" Often, they have never considered running one, they don't know where to start. So that's another problem, obviously. And at some point, I decided to conduct a survey to see if random strangers can tell me about their companies and their community of practice. And it was super interesting as well.

**中文翻译:**
我们在这种分享上投入了不少时间，但由于这个社区的存在，每个人都随着时间的推移变得更好。所以我决定把这作为我今年研究的主题。我咨询了很多客户和前客户：“嘿，你们有运行实践社区吗？如果没有，那是为什么？” 通常，他们从未考虑过运行一个，或者不知道从哪里开始。显然，这是另一个问题。在某个时刻，我决定进行一项调查，看看随机的陌生人是否能告诉我关于他们公司及其实践社区的情况。结果也非常有趣。

---

### [00:55:34] Petra Wille

**English:**
For example, I found that oftentimes there is a bit of a community of practice internally, but they never heard about external product community. So they never heard of your community or to raise this community or mind the product or any of those external communities. And that is shocking to an extent as well because we're all so friendly human beings, happy to share what we learn, and they don't have to go through the same things over and over again. So that's why I think it's a super important question and I would love to help a bit more companies to start a community of practice or to mature the community of practice that they're already having.

**中文翻译:**
例如，我发现通常内部会有一些实践社区，但他们从未听说过外部的产品社区。他们从未听说过你的社区，或者 Teresa 的社区，或者 Mind the Product，或者任何那些外部社区。这在某种程度上也令人震惊，因为我们都是如此友好的人，乐于分享所学，他们不必一遍又一遍地经历同样的事情。这就是为什么我认为这是一个非常重要的问题，我很想帮助更多的公司建立实践社区，或者完善他们现有的实践社区。

---

### [00:56:14] Lenny

**English:**
What impact have you seen folks get when they join or find a great community? And then what are communities that you find are most useful? You mentioned ... And I want to get your advice on what I could do to make it even better, but maybe those two questions. What impact do you find when you find a great community and then what are some that you [inaudible 00:56:31]?

**中文翻译:**
你看到人们在加入或找到一个优秀的社区后获得了什么影响？你觉得哪些社区最有用？你提到了……我也想听听你对我如何改进社区的建议，但先回答这两个问题：当你找到一个优秀的社区时，你发现了什么影响？以及你推荐哪些社区？

---

### [00:56:31] Petra Wille

**English:**
One impact, definitely, is stickiness. So people tend to stay with companies where they're learning and growing and can, yeah, get to mastery, so to say. Hello, Daniel Pink. So that is really something that people are thriving for, and if they find this in a company and a product community of practice could be a big part of that. So that is one impact.

**中文翻译:**
一个影响绝对是“粘性”。人们倾向于留在那些能让他们学习、成长并达到精通水平的公司。向 Daniel Pink 致敬。这确实是人们所追求的，如果他们在公司里找到了这一点，产品实践社区可以成为其中的重要组成部分。这就是一个影响。

---

### [00:56:59] Petra Wille

**English:**
Then the other impact, there's less people development on the desk of the product lead if there is a good product community of practice. So product leads, your life will get so much easier if there is a product community of practice. And it's actually a pretty cheap way of doing people development because trainings are expensive, conference tickets are expensive, getting external product coach, expensive. But helping people to learn from each other by making room for that and giving them a bit of time to reflect and to share what they're learning, that's rather cheap. So I think that is the benefits that I see.

**中文翻译:**
另一个影响是，如果有一个好的产品实践社区，产品领导者在人才培养方面的负担就会减轻。所以产品领导者们，如果有了产品实践社区，你们的生活会轻松得多。这实际上是一种非常廉价的人才培养方式，因为培训很贵，会议门票很贵，请外部产品教练也很贵。但是，通过腾出空间并给他们一点时间来反思和分享所学，从而帮助人们互相学习，这是相当廉价的。我认为这就是我看到的益处。

---

### [00:57:40] Petra Wille

**English:**
Training budget impact. People tend to stay with the company a bit longer. Leadership wise, it's less a time that you have to invest in people development. And then it's just fun for a lot of people. That's another uptake, I'd say.

**中文翻译:**
对培训预算的影响。人们倾向于在公司待得更久。从领导力角度看，你需要投入到人才培养上的时间更少了。而且对很多人来说，这很有趣。我认为这是另一个好处。

---

### [00:57:54] Lenny

**English:**
What are signs that the community that you're in, say, you found? You mentioned a bunch that I think are awesome. Teresa's community, we'll talk about my Slack a little bit. Mind the Product.

**中文翻译:**
你加入的社区有哪些好的迹象？你提到了一堆我认为很棒的社区：Teresa 的社区，待会我们聊聊我的 Slack，还有 Mind the Product。

---

### [00:58:02] Petra Wille

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:58:03] Lenny

**English:**
What are signs that the community you're in is good with your time? Something you should stick with versus like, "Nah, get out of there."

**中文翻译:**
有哪些迹象表明你所在的社区值得你花时间？哪些是值得坚持的，哪些是应该“不，赶紧离开”的？

---

### [00:58:10] Petra Wille

**English:**
That is actually a good question. So I would say, if it helps you with networking, that is really something good if you meet nice, interesting people. So that is one thing I would love to mention. And then if you're learning something new every now and then, maybe not every day, maybe not every week, but every now and then, there should be some real nuggets where you think, "Oh, this is making my life easier," or "This is super interesting. I would never ever have stumbled upon this thing without the community." So learning something new and then reflecting on how much you already learned about a certain topic or know about a certain topic, which is contributing to the community.

**中文翻译:**
这确实是个好问题。我会说，如果它能帮你建立人脉，能让你遇到友善、有趣的人，那真的很棒。这是我想提到的一点。然后，如果你能不时学到新东西（也许不是每天，也不是每周，但总会有那么几次），应该会有一些真正的“金句”或“干货”，让你觉得：“噢，这让我的生活变得更轻松了，”或者“这超级有趣，如果没有这个社区，我永远不会碰到这件事。” 所以，学习新东西，然后反思你对某个主题已经学到了多少或了解多少，这也是对社区的贡献。

---

### [00:58:55] Petra Wille

**English:**
You could be a community moderator, you could be somebody organizing some of the rituals, you could be somebody just sharing what you learned. So I think that is something that could be in a good community that is possible at least to share that everybody's sharing and that there's mutual trust and then it's often just, if you enjoy being part of this community. That's, I think, another super important thing to look into. Do you like the people there? Do you like to hang out with them? Do you think they're kind, lovely human beings? And is there some level of activity in the community because there's too many dead ones out there, more or less? And I think these are the things that I, yeah, would use as a benchmark.

**中文翻译:**
你可以成为社区版主，可以成为组织某些仪式的人，也可以只是分享所学的人。我认为在一个好的社区里，至少应该可以分享，大家都在分享，并且有互信。通常还取决于你是否喜欢成为这个社区的一员。我认为这是另一个非常重要的观察点。你喜欢那里的人吗？你喜欢和他们待在一起吗？你觉得他们是善良、可爱的人吗？社区是否有一定程度的活跃度？因为外面有太多死气沉沉的社区了。我认为这些就是我会使用的基准。

---

### [00:59:37] Lenny

**English:**
When you're talking about this, initially, I was just imagining online communities, but there's also, obviously, offline communities probably somewhere in your local city.

**中文翻译:**
当你谈论这个时，起初我只想到在线社区，但显然也有线下社区，可能就在你当地的城市。

---

### [00:59:44] Petra Wille

**English:**
Yeah, product things.

**中文翻译:**
是的，比如 ProductTank。

---

### [00:59:44] Lenny

**English:**
Right. Just like ... Yeah.

**中文翻译:**
对。就像……是的。

---

### [00:59:46] Petra Wille

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:59:46] Lenny

**English:**
Yeah. So I think ... I don't know if people thought that when I was talking, but, yeah, there's probably meetups happening in your city with product managers that are meeting each other every week, every month maybe.

**中文翻译:**
是的。所以我认为……我不知道大家听我说话时是怎么想的，但确实，你所在的城市可能就有产品经理的聚会，他们可能每周或每月见面。

---

### [00:59:55] Petra Wille

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:59:56] Lenny

**English:**
That sounds awesome. And I love your point about the why of the community versus a course versus reading lots of books. It's really affordable to join some product community, especially if it's online.

**中文翻译:**
听起来很棒。我喜欢你关于“为什么选择社区”而不是课程或读很多书的观点。加入一些产品社区真的很划算，尤其是如果它是在线的话。

---

### [01:00:09] Petra Wille

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:00:10] Lenny

**English:**
And the ROI could be really high.

**中文翻译:**
而且投资回报率（ROI）可能非常高。

---

### [01:00:11] Petra Wille

**English:**
Yeah. And it brings so much clarity in your thinking if you're sharing some things you learned with the community that this is a massive uptake as well, so give back. That really makes sense for you personally as well.

**中文翻译:**
是的。如果你向社区分享你学到的东西，这会让你的思维变得非常清晰，这也是一个巨大的提升。所以要回馈社区，这对你个人也很有意义。

---

### [01:00:27] Lenny

**English:**
So you mentioned my Slack community. So if folks don't know this and they're listening, basically, if you're a paid subscriber committees letter, you get access to the Slack and there's about 10,000 people in there, mostly PMs and founders and growth leaders, and it's pretty damn incredible. It's probably the thing I'm most proud of of all the things I've done over the last few years around this newsletter and podcast.

**中文翻译:**
你提到了我的 Slack 社区。如果听众还不知道，基本上，如果你是简报的付费订阅者，你就可以加入这个 Slack。里面大约有 1 万人，主要是 PM、创始人和增长负责人，这真的非常了不起。这可能是我过去几年围绕这份简报和播客所做的所有事情中，最让我自豪的一件。

---

### [01:00:48] Lenny

**English:**
And so if you're not in there, you should definitely check it out. It's thriving. There's meetups happening all over the world every month. There's a mentorship program, there's mastermind groups, all kinds of stuff. And you're familiar with it. And so I just wanted to ask you while I have you here, do you have any advice for how to make this community even more great?

**中文翻译:**
所以如果你还没加入，一定要去看看。它非常繁荣，每个月世界各地都有聚会。还有导师计划、大师班小组等等。你对它很熟悉，所以我想趁你在这里问问，你对我如何让这个社区变得更棒有什么建议吗？

---

### [01:01:06] Petra Wille

**English:**
That is not an easy question. First of all, congratulations. I really think it's a massive achievement to start such a community and to really have such a vibrant community because I know it takes a lot of energy investment at first to get it going and then a lot of energy to keep it on a certain level, so to say.

**中文翻译:**
这可不是个简单的问题。首先，祝贺你。我真的认为建立这样一个社区并让它如此充满活力是一项巨大的成就。因为我知道，起步阶段需要投入大量精力，之后维持在一定水平也需要大量精力。

---

### [01:01:29] Petra Wille

**English:**
Yeah. What I found helpful is I have this community canvas that I use when I'm working with clients and some of these things require workshops to some extent. So it helps to reflect on what is the purpose of the community and that changes over time with the community members that are currently part of this community, right? So that is not a stable thing. So sometimes everybody has to pause for a second and then think about what is the purpose of this community, what are our values, and how will we define success?

**中文翻译:**
是的。我发现很有帮助的是我有一个“社区画布”（community canvas），我在与客户合作时会用到它，其中一些内容在某种程度上需要通过工作坊来完成。它有助于反思社区的目的是什么，而这个目的会随着当前社区成员的变化而变化，对吧？所以它不是一成不变的。有时每个人都得停下来思考一下：这个社区的目的是什么？我们的价值观是什么？我们如何定义成功？

---

### [01:02:05] Petra Wille

**English:**
It's pretty boring, I know, because it sounds so, so familiar with what we do in product management, but I think it applies for product communities as well. And then you need to find good rituals and rhythm, and you, Lenny, were already talking about some of the ones you are using. I know, for example, what Teresa is doing in her community. I interviewed her this year, so there is a blog post on that online as well where she talks about what she tried, and what did work, and what did not work. So I think that is important.

**中文翻译:**
我知道这听起来挺无聊的，因为它听起来和我们在产品管理中所做的非常相似，但我认为它同样适用于产品社区。然后你需要找到好的仪式和节奏。Lenny，你已经谈到了你正在使用的一些方法。例如，我知道 Teresa 在她的社区里是怎么做的。我今年采访了她，网上有一篇相关的博文，她在里面谈到了她尝试过什么，什么有效，什么无效。我认为这很重要。

---

### [01:02:36] Petra Wille

**English:**
Then maybe not so important for your community. Well, let's see. Let's discuss, let me hear what you think, which is incentives and sponsoring. So how do you, yeah, value contribution? Are you giving back? Is it a kudos mechanism or is it something where people really earn badges of honor or earn time, earn more training budget. That's what a lot of companies do, right? If you're playing an active role in the community, then you get more training budget to spend or something like that, or they grant you time to do so. So if you say like, "Hey, I want to be part of this product community, could I travel a quarter or something like that because I want to go and see those people?" That is something that people do. So incentives and sponsoring, then it's roles. And that will be interesting in your case as well. Is Lenny the center of the community?

**中文翻译:**
接下来这一点对你的社区可能没那么重要，但我们可以讨论一下，听听你的想法，那就是激励和赞助。你如何衡量贡献的价值？你有回馈吗？是点赞机制，还是人们可以获得荣誉徽章，或者赢得时间、赢得更多培训预算？很多公司都是这么做的，对吧？如果你在社区中扮演积极角色，你就能获得更多培训预算，或者公司会给你专门的时间。比如你说：“嘿，我想参加这个产品社区，我能出差一个季度吗，因为我想去见见那些人？” 这是人们会做的事。所以是激励和赞助，然后是角色。在你的案例中这也会很有趣：Lenny 是社区的中心吗？

---

### [01:03:34] Lenny

**English:**
Yeah, I try really hard not to do that, actually.

**中文翻译:**
是的，实际上我非常努力地不让自己成为中心。

---

### [01:03:36] Petra Wille

**English:**
Yeah, right. Yeah.

**中文翻译:**
是的，没错。

---

### [01:03:36] Lenny

**English:**
That's a [inaudible 01:03:36] try to not be the beacon of all answers. The actual goal of the community was I will not have all the answers. Let's just bring a bunch of smart people together that are already there's this interesting filter of who pays for content about product and growth and stuff.

**中文翻译:**
我努力不让自己成为所有答案的灯塔。社区的实际目标是：我不会有所有的答案。让我们把一群聪明人聚集在一起，这里有一个有趣的筛选机制，即谁愿意为关于产品和增长的内容付费。

---

### [01:03:52] Petra Wille

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:03:53] Lenny

**English:**
Filter's really interesting. So the whole idea was get out of the middle of this thing and let people help each other and it's worked out really well.

**中文翻译:**
这个筛选机制非常有趣。所以整个想法就是从中心退出来，让人们互相帮助，目前效果非常好。

---

### [01:03:59] Petra Wille

**English:**
Yeah, because that's what I would say after doing all this research, it's not sustainable if the whole community is on the shoulders of one, two, three people. So you need to distribute the workload and you need to distribute this responsibility because sometimes even things like, yeah, policing the community is not a pleasant job. And if there's only one person dealing with all of these things, then it's not really community because then it's a bit organized like a company in this pyramid scheme.

**中文翻译:**
是的，因为在做了所有这些研究后我想说，如果整个社区都压在一两三个人肩上，那是不可持续的。所以你需要分配工作量，需要分配责任。因为有时即使是像“维护社区秩序”这样的事也不是什么愉快的工作。如果只有一个人处理所有这些事情，那就不叫真正的社区，因为那样组织起来就像一家金字塔结构的公司。

---

### [01:04:30] Petra Wille

**English:**
So I think more of it as circles, different circles of interest, and then building bridges between them because maybe not everybody in your community is interested in the same topics, but maybe they are the smaller circles of 10, 15 people interested in this one topic, 10, 15 people interested in this other topic. You may be connecting the dots, you may be giving a bit of impulse and inspiration, but maybe other people are doing the exact same thing, sharing their best reads and their worthy to watch videos, and all these kind of things. So content and curation, definitely, is another thing that you should think about and reflect on once in a while.

**中文翻译:**
所以我更多地把它看作是一个个圈子，不同的兴趣圈，然后在它们之间架起桥梁。因为也许你社区里的每个人并不都对同一个话题感兴趣，但可能有 10 到 15 人的小圈子对这个话题感兴趣，另外 10 到 15 人对另一个话题感兴趣。你可能在串联这些点，提供一些动力和灵感，但也许其他人也在做同样的事情，分享他们读过的好书、值得看的视频等等。所以内容和策展（curation）绝对是你应该不时思考和反思的另一件事。

---

### [01:05:08] Lenny

**English:**
Cool. Thanks for the advice. Curious is so important. Especially early on, I found keeping the signal to noise high always. And especially early on, it was a really prayerful. So there's a lot of focus [inaudible 01:05:19] detail oriented about it all.

**中文翻译:**
酷。谢谢你的建议。好奇心非常重要。特别是在早期，我发现始终保持高信噪比非常关键。尤其是在最开始的时候，这真的是一种祈祷般的小心翼翼。所以当时非常关注细节。

---

### [01:05:21] Petra Wille

**English:**
Yeah. Plus, a lot of communities that I see use engagement as a success metric, and I'm actually not sure if this is a good success metric. So as you say, signal versus noise is maybe the better success metric, which leads us the down the rabbit hole of how to [inaudible 01:05:38]. But, yeah, engagement is maybe not the predominant success factor for a community.

**中文翻译:**
是的。此外，我看到很多社区把“参与度”作为成功指标，但我其实不确定这是否是一个好的指标。正如你所说，“信噪比”可能是更好的成功指标，虽然这会让我们陷入如何衡量它的深坑。但是，是的，参与度可能不是社区最主要的成功因素。

---

### [01:05:44] Lenny

**English:**
Yeah, that's interesting. You also said it's a lot of work. And just to give some shout-outs to folks that help me run this community that we have, I couldn't do this without them. Trey, who leads the community. Keani who-

**中文翻译:**
是的，很有趣。你也说过这是一项繁重的工作。我想向帮助我运行这个社区的人们致谢，没有他们我做不到。Trey，他负责领导社区。Keani，她——

---

### [01:05:54] Petra Wille

**English:**
Hello, Trey.

**中文翻译:**
你好，Trey。

---

### [01:05:55] Lenny

**English:**
Hello, Trey.

**中文翻译:**
你好，Trey。

---

### [01:05:56] Petra Wille

**English:**
I know Keani.

**中文翻译:**
我认识 Keani。

---

### [01:05:58] Lenny

**English:**
Keani curates the best conversations in the Slack every week and then shares them in this bonus email, Community Wisdom.

**中文翻译:**
Keani 每周都会从 Slack 中挑选出最精彩的对话，然后在“社区智慧”（Community Wisdom）这封额外邮件中分享。

---

### [01:06:04] Petra Wille

**English:**
Nice.

**中文翻译:**
真棒。

---

### [01:06:04] Lenny

**English:**
And then Ria, who's been helping out run the meetup program. And then Jess who's helping with our mentorship program and a few other things. So that's the core team that helps this whole thing run. Thank you to them all.

**中文翻译:**
还有 Ria，她一直在帮忙运行聚会计划。还有 Jess，她负责我们的导师计划和其他一些事情。这就是帮助整个社区运行的核心团队。感谢他们所有人。

---

### [01:06:15] Petra Wille

**English:**
Thank you. And it's super interesting that you're sharing that because companies often don't want to invest in, yeah, full-time community manager is maybe the wrong word because that not necessarily has to be a full-time role, but there need to be some people that really have a decent amount of time to invest in running this community because otherwise it's not working. And I still think it is still cheaper than sending everybody to trainings and conferences all the time, and it has a lot of, yeah, ripple effects and network effects.

**中文翻译:**
谢谢。你分享这些非常有趣，因为公司往往不想投资……是的，“全职社区经理”可能不是个准确的词，因为这不一定非得是全职角色，但确实需要一些人投入大量时间来运行社区，否则它就无法运作。我仍然认为，这比一直送每个人去参加培训和会议要便宜，而且它有很多涟漪效应和网络效应。

---

### [01:06:48] Lenny

**English:**
Well, guess what, we've reached our very exciting lightning round.

**中文翻译:**
好了，猜猜怎么着，我们进入了非常激动人心的闪电问答环节。

---

### [01:06:51] Petra Wille

**English:**
[inaudible 01:06:52].

**中文翻译:**
（笑声）

---

### [01:06:52] Lenny

**English:**
So I'm going to ask you a few questions. Whatever comes to mind, let me know. We'll go through it pretty fast.

**中文翻译:**
我会问你几个问题。想到什么就说什么。我们会进行得很快。

---

### [01:06:57] Petra Wille

**English:**
Yes.

**中文翻译:**
好的。

---

### [01:06:57] Lenny

**English:**
And are you ready?

**中文翻译:**
准备好了吗？

---

### [01:06:58] Petra Wille

**English:**
I'm so ready.

**中文翻译:**
准备好了。

---

### [01:06:59] Lenny

**English:**
So ready. What are two or three books that you recommend most to other people?

**中文翻译:**
太好了。你最推荐给别人的两三本书是什么？

---

### [01:07:05] Petra Wille

**English:**
The Art of Thinking Clearly by Dobelli. It talks about human biases in a really nice and illustrated way. Then what I use a lot in my coaching practice, especially with senior executive, is Outcomes Over Output because it's a super strong concept, I'd say. And then maybe I want to mention two books that are not yet written, but two concepts that I hope will make it into books, and one is Martin Eriksson's Decision Stack. And then there is another book about public speaking that hopefully might come out if some people are supporting it on Kickstarter. And that is called Present Yourself, a public speaking book.

**中文翻译:**
Dobelli 的《清醒思考的艺术》（The Art of Thinking Clearly）。它以一种非常精美且带有插图的方式讲述了人类的偏见。然后，我在教练实践中经常使用（特别是对高级管理人员）的是《Outcomes Over Output》（结果胜过产出），我认为这是一个非常强大的概念。然后我想提到两本还没写的书，或者说我希望被写成书的两个概念：一个是 Martin Eriksson 的“决策栈”（Decision Stack）；另一个是关于公开演讲的书，如果有人在 Kickstarter 上支持的话，希望它能出版，书名叫《Present Yourself》（展现自我）。

---

### [01:07:42] Lenny

**English:**
Awesome. If you can sign a link to that, we'll include it also in the show notes.

**中文翻译:**
太棒了。如果你能提供链接，我们也会把它放在节目笔记里。

---

### [01:07:45] Petra Wille

**English:**
Of course.

**中文翻译:**
当然。

---

### [01:07:46] Lenny

**English:**
The record ...

**中文翻译:**
纪录……

---

### [01:07:47] Petra Wille

**English:**
Show notes, hello.

**中文翻译:**
节目笔记，你好。

---

### [01:07:48] Lenny

**English:**
... longest-ever show notes. Speaking of that, what's another podcast that you love?

**中文翻译:**
……史上最长的节目笔记。说到这个，你还喜欢哪部播客？

---

### [01:07:52] Petra Wille

**English:**
I love the Product Experience podcast. And if you're able to speak German, then there is one that is called [foreign language 01:07:58]. That's a nice interview series.

**中文翻译:**
我喜欢《Product Experience》播客。如果你会说德语，有一个叫《Produktwerker》的，那是一个很棒的访谈系列。

---

### [01:08:02] Lenny

**English:**
[foreign language 01:08:02], I like that. I do not speak German, but I thought it'd be fun to listen to, anyway. What's a favorite recent movie or TV show that you've enjoyed?

**中文翻译:**
《Produktwerker》，我喜欢。我不会说德语，但我觉得听听也会很有趣。你最近喜欢的电影或电视剧是什么？

---

### [01:08:11] Petra Wille

**English:**
Maybe New Amsterdam. I loved it. That's actually a medical director, Matt, and he's finding very unconventional ways to solve problems and I think he's a great leader, so maybe that's a nice framing for watching the show.

**中文翻译:**
可能是《新阿姆斯特丹》（New Amsterdam）。我很喜欢。那里面有一个医疗总监 Matt，他用非常不寻常的方式解决问题，我认为他是一个伟大的领导者，所以这可能是看这部剧的一个很好的视角。

---

### [01:08:26] Lenny

**English:**
What was it called? New Amsterdam?

**中文翻译:**
叫什么名字？《新阿姆斯特丹》？

---

### [01:08:27] Petra Wille

**English:**
New Amsterdam.

**中文翻译:**
《新阿姆斯特丹》。

---

### [01:08:28] Lenny

**English:**
Sweet. What's a favorite interview question that you'd like to ask when you're interviewing folks?

**中文翻译:**
太棒了。面试别人时，你最喜欢问的问题是什么？

---

### [01:08:32] Petra Wille

**English:**
Definitely the tell me about the last time. So tell me about a time when you did your last round of user interviews. Tell me about your last time when you onboarded a new colleague because I think as a user interviewing this, tell me about the last time you really, yeah, sparks nice conversations and interviews.

**中文翻译:**
绝对是“告诉我关于上一次……”的问题。比如：告诉我你上一次进行用户访谈的情况。告诉我你上一次引导新同事入职的情况。因为我认为作为用户访谈式的提问，“告诉我关于上一次……”真的能引发很好的对话和面试交流。

---

### [01:08:54] Lenny

**English:**
What are five SaaS tools or products that help you do the work that you do now? And if there aren't enough of those, just great apps that you love right now.

**中文翻译:**
有哪些 SaaS 工具或产品能帮助你完成现在的工作？列举五个。如果没有那么多，就说说你现在喜欢的优秀 App。

---

### [01:09:04] Petra Wille

**English:**
I'm totally not into product management SaaS tool these days because as I'm just coaching people on hourly basis, I'm no longer the one looking into the SaaS tools they're using. So that's quite a tough question. Things that I use a lot in my personal work is rather boring stuff like bookkeeping software and time tracking [inaudible 01:09:25]-

**中文翻译:**
这些天我完全不怎么用产品管理的 SaaS 工具了，因为我只是按小时辅导别人，不再是那个研究他们所用 SaaS 工具的人了。所以这确实是个难题。我在个人工作中经常使用的是一些比较无聊的东西，比如记账软件和时间追踪工具……

---

### [01:09:24] Lenny

**English:**
Which ones? That's interesting.

**中文翻译:**
哪些？这很有趣。

---

### [01:09:27] Petra Wille

**English:**
Harvest is what I use for time tracking and bookkeeping, and I love that. It makes my life easier since a few years already. And then, yeah, new banking apps that are coming up that I'm using for my accounts. One is Qonto, I think it's a German bank, but they really did a great job in the user experience, super seamless in the apps and all these kind of things. Yeah. So that's two cool products that I love to use.

**中文翻译:**
我用 Harvest 来进行时间追踪和记账，我很喜欢它。几年来它一直让我的生活变得更轻松。然后，是的，还有一些新兴的银行 App，我用它们来管理账户。一个是 Qonto，我想这是一家德国银行，但他们在用户体验方面做得非常好，App 非常流畅，诸如此类。所以这是我喜欢使用的两个很酷的产品。

---

### [01:09:54] Lenny

**English:**
Great. Who else in the industry do you most respect as a thought leader, influencer-type person?

**中文翻译:**
太好了。在业内，你最尊敬的“思想领袖”或“影响力人物”还有谁？

---

### [01:10:01] Petra Wille

**English:**
As I'm a conference organizer as well for a conference that was called the Product Engage here in Hamburg, that is the super hard question for me to ask because so many people have been on that stage, that I would consider being a thought leader, they would maybe not consider them being a thought leader. I think the thought leader thing is pretty hard anyway, so there's so many different voices in our industry. And I think looking at the guest list of your podcast actually is a very good start when you think about thought leaders and getting more inspirations because they are ones that we know and some hidden gems on there.

**中文翻译:**
由于我也是汉堡 Product Engage 会议的组织者，这个问题对我来说超级难回答。因为有太多人登上过那个舞台，我认为他们是思想领袖，但他们自己可能不这么认为。我觉得“思想领袖”这个定义本身就很宽泛，我们行业有很多不同的声音。我认为看看你播客的嘉宾名单其实是一个很好的开始，如果你想寻找思想领袖并获得更多灵感的话，因为那里既有我们熟知的人，也有一些“宝藏级”的人物。

---

### [01:10:37] Lenny

**English:**
Great answer. Great answer. Petra, thank you so much for doing this. We've hit the record on show note length, I guess, so that's a milestone. Congrats.

**中文翻译:**
很棒的回答。Petra，非常感谢你参加节目。我想我们已经打破了节目笔记长度的纪录，这算是一个里程碑。恭喜。

---

### [01:10:48] Petra Wille

**English:**
Yes, thank you. Was a pleasure.

**中文翻译:**
是的，谢谢。很愉快。

---

### [01:10:51] Lenny

**English:**
Two final questions. Where can folks finding online if they want to learn more, reach out, maybe work with you and how can listeners be useful to you?

**中文翻译:**
最后两个问题。如果大家想了解更多、联系你或者想和你合作，可以在哪里找到你？听众们能为你做些什么？

---

### [01:10:58] Petra Wille

**English:**
Ooh, interesting. Yeah, the first one is easy, LinkedIn, Petra Wille, you can find me there. And then there is my website, Petra-W-I-L-L-E.com. That's my website. And how can listeners be helpful to me? Whew, that's a tough one. I think it could be mutual beneficial if you are a product manager IC level and you would love to get better supported in your personal development and go by my book and just hand it to your manager, if that's appropriate. Or just put it on their desk and just forget that it's there and hopefully they read it or something like that. I think that is how I would love to answer the last question.

**中文翻译:**
噢，很有趣。第一个很简单，LinkedIn，搜索 Petra Wille 就能找到我。还有我的网站 Petra-W-I-L-L-E.com。至于听众能帮我什么？呼，这很难回答。我认为这可以是互惠互利的：如果你是一名 IC 级别的产品经理，并且希望在个人发展方面得到更好的支持，那就去买我的书，如果合适的话，把它递给你的经理。或者直接放在他们的桌子上，然后假装忘了，希望他们能读一读。这就是我想对最后一个问题的回答。

---

### [01:11:40] Lenny

**English:**
Remind folks what the book is called and they can find on Amazon [inaudible 01:11:43].

**中文翻译:**
提醒大家书名是什么，他们可以在亚马逊上找到。

---

### [01:11:42] Petra Wille

**English:**
Strong Product People.

**中文翻译:**
《Strong Product People》。

---

### [01:11:46] Lenny

**English:**
Strong Product People. Go check it out on Amazon.

**中文翻译:**
《Strong Product People》。去亚马逊看看吧。

---

### [01:11:48] Petra Wille

**English:**
Exactly.

**中文翻译:**
没错。

---

### [01:11:48] Lenny

**English:**
Petra, thank you so much for doing this.

**中文翻译:**
Petra，非常感谢你参加节目。

---

### [01:11:50] Petra Wille

**English:**
Lenny, was a pleasure.

**中文翻译:**
Lenny，很愉快。

---

### [01:11:52] Lenny

**English:**
It's my pleasure.

**中文翻译:**
我的荣幸。

---

### [01:11:54] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。