# Raaz Herzberg - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Raaz Herzberg.

---

### [00:00:00] Lenny Rachitsky

**English:**
You're one of the first 10 employees, you're the first product manager. It was when you joined, the founders didn't really have an idea figured out yet. When they landed on an idea, and then ended up being wrong, ended up not working. Six weeks after you joined, there was a pivot.

**中文翻译:**
你是前 10 名员工之一，也是第一位产品经理。你加入时，创始人还没真正想好点子。当他们终于确定了一个想法后，结果证明是错的，根本行不通。在你加入六周后，公司就经历了转型（Pivot）。

---

### [00:07:01] Raaz Herzberg

**English:**
At the time, we didn't really have a solid product yet. We would have 10 to 15 meetings every day with potential customers. I was hired as the first product manager. I sat in on those calls. I still did not exactly understand what we were going to build, which was confusing, because I was a product manager, so I was supposed to start building it, and so, at some point, it was like, "I have to ask, what exactly are we doing here?" And that ended up pivoting us around to cloud security.

**中文翻译:**
那时候，我们还没有一个成型的产品。我们每天要和潜在客户开 10 到 15 场会议。我是作为第一位产品经理被录用的，我参加了所有的这些电话会议。但我当时还是没搞懂我们到底要造什么，这让我很困惑，因为作为产品经理，我本该开始着手构建产品了。所以到了某个时刻，我觉得：“我必须得问清楚，我们到底在这里干什么？” 这个问题最终促使我们转型到了云安全领域。

---

### [00:07:01] Lenny Rachitsky

**English:**
So things started to click a little bit more, you started seeing enthusiasm. Can you talk about just what that phase was like?

**中文翻译:**
所以事情开始变得顺理成章了，你开始看到人们的热情。你能谈谈那个阶段是什么样子的吗？

---

### [00:07:01] Raaz Herzberg

**English:**
We really felt the type of questions change, right? Silly. The call sounded like, again, "How are you pricing this, or when can we start doing a POV?" I think naturally, as human beings, you have a bias to look for affirmation, versus a bias for what you don't want to hear.

**中文翻译:**
我们确实感觉到问题的类型变了。听起来可能有点傻，但电话里的声音变成了：“你们怎么定价？”或者“我们什么时候可以开始做 POV（价值证明）测试？” 我认为作为人类，天生就有一种寻找肯定（Affirmation）的偏见，而不是去听那些你不想听到的反馈。

---

### [00:07:01] Lenny Rachitsky

**English:**
You started as an engineer, you moved into product, and now you're marketing, which is not a traditional path.

**中文翻译:**
你最初是工程师，后来转做产品，现在又在做市场营销，这可不是一条传统的职业路径。

---

### [00:07:01] Raaz Herzberg

**English:**
I had a ton to learn about marketing, with what I knew really well, with ...

**中文翻译:**
关于营销，我有太多东西要学了，尽管我对自己熟悉的领域非常了解……

---

### [00:07:01] Lenny Rachitsky

**English:**
Today, my guest is Raaz Herzberg. Raaz is chief marketing officer and VP of product strategy at Wiz. Before moving into marketing, Raaz was an engineer, and then, for most of her career, was a product manager. Prior to Wiz, Raaz led security products in Microsoft, including Azure Sentinel, and with Wiz, moved from VP of product to CMO.

**中文翻译:**
今天的嘉宾是 Raaz Herzberg。Raaz 是 Wiz 的首席营销官（CMO）兼产品策略副总裁。在转入营销领域之前，Raaz 是一名工程师，职业生涯的大部分时间都在担任产品经理。在加入 Wiz 之前，Raaz 在微软领导安全产品，包括 Azure Sentinel；在 Wiz，她从产品副总裁转任 CMO。

---

### [00:07:01] Lenny Rachitsky

**English:**
If you haven't heard of Wiz, it's not only the world's fastest growing security company, it's also the fastest growing software company in history, hitting 100 million ARR, just 18 months after founding, and then, just under five years after founding, was rumored to be exploring an acquisition by Google for over $23 billion.

**中文翻译:**
如果你还没听说过 Wiz，它不仅是全球增长最快的安全公司，也是历史上增长最快的软件公司。成立仅 18 个月，其 ARR（年度经常性收入）就达到了 1 亿美元。在成立不到五年时，传闻谷歌正探讨以超过 230 亿美元的价格收购该公司。

---

### [00:07:01] Lenny Rachitsky

**English:**
Even more wild, as you'll hear in our conversation, the team initially went in circles on what they wanted to build. And it took them awhile to actually land on the idea that is basically the most intense product market fit of any B2B company ever.

**中文翻译:**
更疯狂的是，正如你在我们的对话中将听到的，团队最初在“到底要造什么”这个问题上绕了很多圈子。他们花了好一段时间才真正确定了那个点子，而那个点子基本上是所有 B2B 公司中经历过的最强烈的“产品市场契合”（Product Market Fit）。

---

### [00:07:01] Lenny Rachitsky

**English:**
In our conversation, Raaz shares what signals told her and the team that the original idea wasn't going to work, and that what changed in their conversations, when they finally found product market fit, why she moved into marketing, and what she wished she knew as a product leader from her new marketing lens, also, her perspective on marketing, and what marketing people often get wrong, and why CMOs often fail. Also something she calls the dummy explanation. Why you need to pay attention to where the heat is within the organization.

**中文翻译:**
在对话中，Raaz 分享了哪些信号告诉她和团队原始想法行不通，以及当他们最终找到产品市场契合时，对话发生了怎样的变化。她还谈到了为什么转行做营销，以及作为产品领导者，她希望从现在的营销视角中早点知道什么。此外，她还分享了对营销的看法、营销人员常犯的错误、CMO 为何经常失败，以及她所谓的“傻瓜式解释”（Dummy Explanation）。还有，为什么你需要关注组织内部的“热度”（Heat）在哪里。

---

### [00:07:01] Lenny Rachitsky

**English:**
She shares her most contrarian take on leadership, and so much more. This was such a fun episode, and there's so much to learn here for product leaders, for marketing leaders, and for founders. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes, and helps the podcast tremendously. With that, I bring you Raaz Herzberg. Raaz, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
她分享了自己在领导力方面最反传统的见解，以及更多精彩内容。这一集非常有趣，对于产品领导者、营销领导者和创始人来说都有很多值得学习的地方。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本播客有巨大帮助。现在，让我们欢迎 Raaz Herzberg。Raaz，非常感谢你能来，欢迎来到本播客。

---

### [00:07:01] Raaz Herzberg

**English:**
Thank you for me.

**中文翻译:**
谢谢邀请。

---

### [00:07:01] Lenny Rachitsky

**English:**
So I want to start by giving a little context on Wiz, for folks that aren't super familiar with the company. You launched just under five years ago, at this point. Within 18 months, you all hit a hundred million ARR, which is the fastest growth rate in history of any software company. It's faster than the two other companies I've had on the podcast, that also claim to be the fastest growing software companies, Deel and Ramp. You guys grew even faster.

**中文翻译:**
我想先为那些不太熟悉 Wiz 的听众介绍一下背景。到目前为止，你们上线还不到五年。在 18 个月内，你们的 ARR 就达到了 1 亿美元，这是历史上任何软件公司中最快的增长速度。这比我之前请到播客上的另外两家公司 Deel 和 Ramp 还要快，它们也自称是增长最快的软件公司。你们的增长甚至超过了它们。

---

### [00:07:01] Lenny Rachitsky

**English:**
I read that you are at over 500 million ARR now. I know it's also not confirmed, but a certain company that rhymes with Loogle, offered to buy you guys for $23 billion, and y'all turned that down, decided to stay private. And also, something like 50% of Fortune 100 companies are customers of Wiz. Is there anything I missed? Anything I got wrong?

**中文翻译:**
我读到报道说你们现在的 ARR 已经超过 5 亿美元了。我知道这还没被证实，但某家名字跟“Loogle”押韵的公司曾开价 230 亿美元想收购你们，而你们拒绝了，决定保持私有化。而且，财富 100 强中约 50% 的公司都是 Wiz 的客户。我有漏掉什么吗？或者有什么说错的地方？

---

### [00:07:01] Raaz Herzberg

**English:**
Never heard of that Loogle company, but other than that, yeah.

**中文翻译:**
从没听说过那家叫 Loogle 的公司，但除此之外，你说得都对。

---

### [00:07:01] Lenny Rachitsky

**English:**
Okay. Okay, great. We're going to come back to that. What's even crazier is in spite of that, when you joined the company, you were employee, something like, number seven?

**中文翻译:**
好，太好了。我们待会儿再聊那个。更疯狂的是，尽管现在规模这么大，你加入公司时大概只是第 7 号员工？

---

### [00:07:01] Raaz Herzberg

**English:**
Yeah, we kind of started, I feel like, the founders, and the first six, seven employees, we just started at once.

**中文翻译:**
是的，我觉得就像是创始人和前六七名员工，大家基本上是同时开始工作的。

---

### [00:07:01] Lenny Rachitsky

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point, your customers will start asking for enterprise features like SAML authentication, and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，迟早你的客户会开始要求企业级功能，比如 SAML 身份验证和 SCIM 供应。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业级功能。

---

### [00:07:01] Lenny Rachitsky

**English:**
This episode is brought to you by Rippling, a single platform to build and scale your startup on. Rippling handles all the "can't get it wrong" admin work of payroll and benefits, giving you back hours every week, but it does a lot more than that.

**中文翻译:**
本集节目由 Rippling 赞助，这是一个用于构建和扩展初创公司的单一平台。Rippling 处理所有“不容出错”的行政工作，如工资发放和员工福利，每周为你节省数小时的时间，但它的功能远不止于此。

---

### [00:07:01] Lenny Rachitsky

**English:**
Okay, so for one of the first 10 employees, you're the first product manager at Wiz.

**中文翻译:**
好，作为前 10 名员工之一，你是 Wiz 的第一位产品经理。

---

### [00:07:01] Raaz Herzberg

**English:**
Yeah. Yeah.

**中文翻译:**
是的。

---

### [00:07:02] Lenny Rachitsky

**English:**
And what I read is that when you joined, the founders didn't really have an idea figured out yet, when they landed on an idea, and it ended up being wrong, ended up not working. Six weeks after you joined, there was a pivot. So the fact that that was true, and you went from this, "This isn't working," to boom, $100 million dollars AR, I want to spend some time here, because I think there's a lot people can learn here.

**中文翻译:**
我读到的是，当你加入时，创始人还没真正想好点子，等他们确定了一个想法后，结果证明是错的，根本行不通。在你加入六周后，公司就转型了。考虑到这一点，你们从“这行不通”的状态，迅速爆发到 1 亿美元 ARR，我想在这里多花点时间聊聊，因为我觉得这里有很多值得学习的地方。

---

### [00:07:13] Lenny Rachitsky

**English:**
So let me just ask, looking back at that point when the idea wasn't working to realizing, "Hey, maybe this is a better idea," what do you remember are some signals that told you this isn't working, and okay, maybe this is, because a lot of founders are in that stage with their products?

**中文翻译:**
所以我想问，回过头看，从那个想法行不通到意识到“嘿，也许这个主意更好”的转折点，你还记得有哪些信号告诉你原来的不行，而现在的可能行？因为很多创始人现在就处于产品的这个阶段。

---

### [00:07:31] Raaz Herzberg

**English:**
When we started, it wasn't even Wiz. The company was literally officially founded as Beyond Networks, because there was this idea of, "Hey, we want to do something in the network security space." Actually, myself and the founding team, and also, the other five engineers that started with us, we actually all came from a background of building cloud security products before, but this time it was like, "Okay, we actually don't want to do cloud security, we want to do network security."

**中文翻译:**
我们刚开始的时候甚至不叫 Wiz。公司正式成立时的名字是 Beyond Networks，因为当时的想法是：“嘿，我们想在网络安全领域做点什么。” 实际上，我、创始团队以及和我们一起开始的其他五名工程师，背景都是做云安全产品的，但那次我们想的是：“好吧，我们其实不想做云安全了，我们想做网络安全。”

---

### [00:08:00] Raaz Herzberg

**English:**
What happened was in those initial few weeks, it also, we started was literally, exactly, Wiz was founded together with COVID. It was that March when the whole world shut down. Suddenly, everything went terribly, terribly strange on all of us. That's when Wiz started.

**中文翻译:**
结果在最初的几周里，Wiz 的成立正好赶上了新冠疫情。那是三月，全世界都停摆了。突然之间，我们所有人的生活都变得极其诡异。Wiz 就是在那时开始的。

---

### [00:08:19] Raaz Herzberg

**English:**
So it was like, our days looked like talking to 10, 15 customers. Wiz is a B2B product, the buyer is the CISO, the people, the person that owns basically security for the entire company. So we would have 10 to 15 meetings every day, with potential customers.

**中文翻译:**
所以当时我们的日子就是每天和 10 到 15 个客户交谈。Wiz 是一个 B2B 产品，买家是 CISO（首席信息安全官），也就是负责整个公司安全的人。所以我们每天会和潜在客户开 10 到 15 场会。

---

### [00:08:39] Raaz Herzberg

**English:**
At the time, we didn't really have a solid product yet, but we had an idea, and the deck explaining our idea, and what we're going to build, and why. We were all a very technical group of people, and especially, our founding team, Assaf, our CEO at Wiz. Before Wiz, he led the entire division of all of the Microsoft cloud security products. So they're very, very impressive, very technical, very well known and respected in the industry.

**中文翻译:**
当时我们还没有真正的产品，但我们有一个想法，还有一份 PPT 解释我们的想法、我们要造什么以及为什么要造。我们都是技术背景很强的人，尤其是我们的创始团队，比如 Wiz 的 CEO Assaf。在创办 Wiz 之前，他领导着微软所有云安全产品的整个部门。所以他们非常厉害，技术精湛，在业内非常有名且受人尊敬。

---

### [00:09:09] Raaz Herzberg

**English:**
And so, we would join a call, and kind of present and walk through our idea, and the person on the other end would be like, "Oh, it sounds interesting. Oh yes, sounds interesting, we'd love to hear more. Yes, perfect. Sounds interesting, we'd love to hear more." And you finished calls with a good feeling, like the person said, "Oh yes, interesting, interesting."

**中文翻译:**
于是，我们会参加电话会议，演示并讲解我们的想法，对方会说：“哦，听起来很有趣。是的，很有趣，我们想了解更多。太棒了，很有趣，请继续保持联系。” 挂掉电话时你感觉良好，因为对方一直在说：“哦是的，很有趣，很有趣。”

---

### [00:09:32] Raaz Herzberg

**English:**
But like you said, I was hired as a first product manager. I sat in on those calls, sometimes officially participating, sometimes, even, not officially participating, but listening on all of the calls, and I finished a couple of weeks of that, which is a lot of calls, I think, two weeks or something. I still did not exactly understand what we were going to build, which was confusing, because I was a product manager, so I was supposed to start building it, in some ways, go to the dev team and start building it. And that was a point where I felt like, "I don't know what we are talking about exactly."

**中文翻译:**
但就像你说的，我是作为第一位产品经理被录用的。我参加了那些电话会议，有时是正式参与，有时甚至只是旁听。在经历了大约两周的大量会议后，我仍然不完全明白我们到底要造什么。这很让人困惑，因为我是产品经理，我应该开始着手构建它，某种程度上说，我该去找开发团队开始干活了。就在那一刻，我觉得：“我根本不知道我们到底在谈论什么。”

---

### [00:10:24] Raaz Herzberg

**English:**
At some point, it was like, "Okay, I have to ask. What exactly are we," like, In the details, right? Not in describing a big problem, in a high level, big potential approach to solving it, but what exactly are we doing here? And I think that that ended up opening a really deep discussion of, "Okay, wait, maybe we are telling a bit of a broad story, and maybe the person on the other end is not going to tell you." They're not incentivized to tell you, "You know what? I don't know what you're talking about."

**中文翻译:**
到了某个点，我觉得：“好吧，我必须得问。我们到底在做什么？” 我指的是细节，对吧？不是描述一个宏大的问题，或者一个高大上的、极具潜力的解决方案，而是我们具体在这里干什么？我认为这引发了一场非常深入的讨论：“好吧，等等，也许我们讲的故事太笼统了，而对方可能不会告诉你真相。” 他们没有动力告诉你：“你知道吗？我根本不知道你在说什么。”

---

### [00:11:14] Raaz Herzberg

**English:**
So I think that opened up a discussion for us, and we kind of understood that we were listening in the wrong way, maybe, that we were looking for positive reinforcements, but not really listening intently to signs of deep enthusiasm, and that ended up pivoting us around to cloud security.

**中文翻译:**
所以这为我们开启了讨论，我们意识到自己听取反馈的方式可能错了——我们一直在寻找正向的肯定，而没有真正专注地去听那些代表“深度热情”的信号。这最终促使我们转向了云安全。

---

### [00:11:31] Lenny Rachitsky

**English:**
There's so much to learn, just from the short story, and I want to get into what you started hearing that made it sound like, "Okay, wait, maybe this is a better idea." But first of all, just the fact that you're doing 10 to 15 calls a day, you said?

**中文翻译:**
光是这个小故事就有这么多值得学习的地方。我想深入了解一下，当你开始听到什么声音时，会觉得“好吧，等等，也许这个主意更好”。但首先，你刚才说你们每天打 10 到 15 个电话？

---

### [00:11:41] Raaz Herzberg

**English:**
That was a bit of, in some weird way ... Again, Wiz was founded in that terrible March, where the world closed down. It seemed, at the time, a really bad time to start a company. Markets were frozen, and everything. Even my mom, which knows nothing about what exactly I do or why, I mean, I left Microsoft to join Wiz, even my mom was calling me and telling me, "This is not a good time to join a startup." But it ended up being in some ways, like an advantage, because everybody were home. Suddenly, everybody were home, no meetings, no travel.

**中文翻译:**
某种程度上说，这有点奇怪……再说一次，Wiz 是在那个糟糕的三月成立的，当时世界都停摆了。那时候看起来确实不是创业的好时机，市场冻结，一切都停滞了。甚至我妈——她完全不懂我具体在做什么或为什么要这么做，我可是离开微软加入 Wiz 的——连她都打电话跟我说：“现在可不是加入初创公司的好时机。” 但结果证明，这在某种程度上反而成了优势，因为所有人都在家。突然之间，大家都在家，没有会议，没有出差。

---

### [00:12:15] Raaz Herzberg

**English:**
So suddenly, CISOs, which are busy people, and we started, originally based in Tel Aviv, so we couldn't even fly, but suddenly, it didn't matter. Because, I mean, everybody's home. So yeah, we took 10-15 calls a day, back to back to back.

**中文翻译:**
所以突然间，那些平时忙得不可开交的 CISO 们都有空了。我们最初总部在特拉维夫，当时甚至没法坐飞机，但突然间这都不重要了。因为大家都在家。所以是的，我们每天接 10 到 15 个电话，一个接一个。

---

### [00:12:30] Lenny Rachitsky

**English:**
I think that alone is a really important lesson of just, that's how you discover something that isn't working/find the thing that is working is, do many, many calls. That is a lot of calls. I don't even know how someone has time to do 10 to 15 calls a day. But again, I think that's how you do this. So I think that alone is a really important lesson for folks to take away.

**中文翻译:**
我觉得单就这一点就是一个非常重要的教训：发现行不通的东西或找到行得通的东西的方法，就是打大量的电话。那可是非常多的电话。我甚至不知道一个人怎么有时间每天打 10 到 15 个电话。但话说回来，我觉得这就是成功之道。所以我觉得单是这一点就非常值得大家借鉴。

---

### [00:12:46] Lenny Rachitsky

**English:**
I love this point, that people are going to try to be nice to you, especially if they think you're really smart, and especially if you're describing things that might be helpful to them, but what you're sharing is, you need to not trust, that often is deceiving. Talk about what it felt when it moved from just, "Oh, this is cool, this is nice, and maybe let's talk more," to, "Oh, maybe this is actually something they'll buy."

**中文翻译:**
我很喜欢你提到的这一点：人们会尽量对你客气，尤其是当他们觉得你很聪明，或者你描述的东西可能对他们有帮助时。但你分享的是，你不能轻信这些，那往往具有欺骗性。请谈谈当感觉从“哦，这很酷，不错，也许我们可以再聊聊”转变为“哦，这也许是他们真的会买的东西”时，是什么样子的？

---

### [00:13:12] Raaz Herzberg

**English:**
We really felt the type of questions change. Suddenly, the call didn't end, was like, "Oh, this sounds super interesting. Sure, please update me. I'd love to hear more." Certainly, the call sounded like, "Wait, again, how are you pricing this? How much will this cost?" Or, "Wait? When can we start doing a POV? How long is a POV?" Or somebody would finish the call, and be like, "Okay, I know exactly who I need to connect you to in my team."

**中文翻译:**
我们真切地感受到了问题类型的变化。突然间，电话不再以“哦，这听起来超级有趣。好的，请随时告知进展，我很想了解更多”结束。相反，电话里变成了：“等等，再说一遍，你们怎么定价？这要花多少钱？”或者“等等，我们什么时候可以开始做 POV？POV 要做多久？”或者有人会在通话结束时说：“好，我知道我需要把你引荐给我团队里的谁了。”

---

### [00:13:35] Raaz Herzberg

**English:**
Those are really strong indications that are the type of indications we learned to look for. Although there's something I think, at the beginning of a company, it's very scary. I think naturally, as human beings, you want to get affirmation from the other side. So you're actually, you have a bias to look for affirmation, versus a bias to look for what you don't want to hear. That's just natural, being a person.

**中文翻译:**
这些都是非常强烈的信号，也是我们学会去寻找的那种信号。虽然我觉得在公司初创期，这很吓人。我认为作为人类，天生就希望得到对方的肯定。所以实际上，你会有寻找肯定的偏见，而不是去寻找那些你不想听到的信息的偏见。作为人，这很自然。

---

### [00:14:04] Raaz Herzberg

**English:**
So I felt like, that is what we ended up really being in tune with. "No, I have to understand. They're intently interested. They want to connect me to somebody. They want to know how much this costs." If somebody just tells you, like you said, "Oh, super cool, yeah, I want to take this as a good sign, but I shouldn't."

**中文翻译:**
所以我感觉到，那才是我们最终真正需要关注的。“不，我必须明白。他们是真心感兴趣。他们想把我介绍给某人。他们想知道这多少钱。” 如果有人只是像你说的，告诉你“哦，超级酷”，是的，我很想把它当成好兆头，但我不能。

---

### [00:14:23] Lenny Rachitsky

**English:**
It's almost like you need to see them pushing for the next step is what I'm hearing is, "Let's do a POV, what's the next step to do this? I want to connect you to this person, to talk further about this," versus just, "Oh yeah, this is awesome. Thank you." And then, okay, bye.

**中文翻译:**
我听到的意思是，你几乎需要看到他们主动推进下一步，比如：“我们做个 POV 吧，下一步该怎么做？我想把你介绍给这个人，进一步聊聊，”而不是仅仅说：“哦是的，这太棒了。谢谢。”然后，好吧，再见。

---

### [00:14:34] Raaz Herzberg

**English:**
Yeah, exactly. And also, in B2B, that is really the process you have to take, after you have to get connected to the actual team that will test the tools, will deploy it. There needs to be real passion about doing something, and I guess that is the difference. It's real passion about, "Hey, I want this right now."

**中文翻译:**
是的，没错。而且在 B2B 领域，这确实是你必须经历的过程，之后你必须对接实际测试工具、部署工具的团队。必须有一种真正想做某事的激情，我想这就是区别所在。那是一种真正的激情：“嘿，我现在就想要这个。”

---

### [00:14:54] Lenny Rachitsky

**English:**
The other point you made is that you were the person, nobody was saying this thing that was this elephant in the room, almost of, "What are we even building? I don't understand what's happening here." I read somewhere that you were like, you told, "I need to quit. I don't understand what this is, and I'm not the right person for this role," and it turned out, nobody understood exactly what was going on. Can you share that story?

**中文翻译:**
你提到的另一点是，你是那个指出“房间里的大象”的人，当时几乎没人说：“我们到底在造什么？我不明白这里发生了什么。” 我在某处读到，你当时甚至说：“我得辞职。我不明白这是什么，我不是这个职位的合适人选，”结果发现，其实没人确切知道发生了什么。你能分享一下那个故事吗？

---

### [00:15:17] Raaz Herzberg

**English:**
It's funny, because it's a story that some of the founders tell, and they tell differently. They tell, "She came to us, and she was like, we have to rethink," but that was not my perspective at all, right? My perspective was genuinely, "Okay, I have to confess, that was my perspective." I was sure that I was the only one not understanding. It's hard to get the courage, I guess. Sometimes, it's hard to get the courage to say, "Actually, I don't understand." But I think by now, in my career, it's my favorite question.

**中文翻译:**
这很有趣，因为有些创始人也讲这个故事，但他们的版本不一样。他们说：“她来找我们，说我们得重新考虑，”但那根本不是我的视角，对吧？我的视角纯粹是：“好吧，我得坦白，那是我的真实想法。” 我当时确信我是唯一一个没听懂的人。我想，拿出勇气很难。有时候，说出“其实我不明白”是需要勇气的。但我想到了职业生涯的现在，这成了我最喜欢的问题。

---

### [00:15:56] Raaz Herzberg

**English:**
I feel like I say, "I don't understand," a lot of times a day. I think, if you build a company with the right type of culture, in a sense, then it's not a shame to say, "I don't understand, or please explain again." It's having that culture in place that enables it. And I also have to say, when I think of the founding team, and the founding team in Wiz, Wiz is a very flat organization, in some ways. It's not about seniority, it's really about driving impact, and everybody can have a seat on the table, and voices are heard.

**中文翻译:**
我觉得我每天会说很多次“我不明白”。我认为，如果你建立了一家拥有正确文化的公司，那么说“我不明白”或“请再解释一遍”就不是什么丢脸的事。是这种文化让这一切成为可能。我还要说，当我想到 Wiz 的创始团队时，Wiz 在某种程度上是一个非常扁平的组织。这与资历无关，真正关乎的是产生影响力，每个人都可以在桌旁占有一席之地，声音都能被听到。

---

### [00:16:41] Raaz Herzberg

**English:**
And I think it also reflects really highly about them, just giving me the seat at the table, in a sense, to be even able to say, "I don't understand." Then, when I'm saying I don't understand, not actually being open to, "Oh, maybe we have to also think again." I think that tells a lot about the culture, even, to this day. But it's definitely, for me, it's a very learned quality over my progression of my career, actually allowing myself to be more vulnerable, more easier in saying, "I don't understand, or I don't know."

**中文翻译:**
我认为这也体现了他们的高素质，某种意义上说，他们给了我一席之地，让我甚至能说出“我不明白”。而且当我这么说时，他们是真的持开放态度：“哦，也许我们也得再想想。” 我觉得这充分说明了公司的文化，直到今天依然如此。但对我来说，这绝对是职业生涯中习得的一种品质，即允许自己展现脆弱，更轻松地说出“我不明白”或“我不知道”。

---

### [00:17:05] Lenny Rachitsky

**English:**
I love this lesson so much. One, partly because you said it's really scary to be the person that's like, "I don't understand," right? That puts you, that's a very vulnerable thing to say, because you're like, "What? She doesn't get it. Maybe she is not as smart as we thought." That can't be easy, to be the person doing that. The other thing is this reminds me of Tomer Cohen, LinkedIn CPO, has this really great phrase, "We may be wrong, but we're not confused." I feel like that's exactly what you're saying here.

**中文翻译:**
我太喜欢这一课了。部分原因是你提到作为那个说“我不明白”的人真的很吓人，对吧？这会让你处于一种非常脆弱的境地，因为你会想：“什么？她没听懂。也许她没我们想象的那么聪明。” 扮演那个角色并不容易。另一件事是，这让我想起了 LinkedIn 的 CPO Tomer Cohen 的一句名言：“我们可能会错，但我们并不困惑。” 我觉得这正是你在这里表达的意思。

---

### [00:17:31] Raaz Herzberg

**English:**
Exactly, which is why I love this question to this day. I love it. I do think that if something is not easy to understand, then maybe it needs a bit more chewing on it.

**中文翻译:**
没错，这就是为什么我至今仍热爱这个问题。我真的很喜欢。我确实认为，如果某件事不容易理解，那么也许它需要再多琢磨琢磨。

---

### [00:17:46] Lenny Rachitsky

**English:**
I love that. Okay, so things started to click a little bit more. You started seeing enthusiasm. Can you talk about just what that phase was like, and any lessons from just that turn to, things are actually working?

**中文翻译:**
太棒了。好，事情开始变得顺畅了，你开始看到热情。你能谈谈那个阶段是什么样的吗？从那个转折点到事情真正开始运转，有什么教训吗？

---

### [00:17:59] Raaz Herzberg

**English:**
I have to say, I think the feeling, after we made that switch, what ended up happening is that after that big conversation that we know, I don't understand, we ended up having, and this never happens, I don't think it's ever happened since. It was almost a long, five-hour discussion, with all of the founders, where we decided to move away from that pivot to cloud security, which is what we really, in some ways, know best.

**中文翻译:**
我得说，在我们做出那个转变后的感觉……结果是，在那个著名的“我不明白”的大讨论之后，我们进行了一场长达五小时的讨论，所有的创始人都参加了——这种情况以前从未发生过，之后好像也没再发生过。在那次讨论中，我们决定转向云安全，这在某种程度上是我们最擅长的领域。

---

### [00:18:25] Raaz Herzberg

**English:**
That's our background, that's what we did before, and we felt the problems there was so big and so strong, and once we started having the conversations with the new pivot to cloud security, the room felt so different. I mean, it was all over Zoom, but our room, it felt very different. Once we found the right path, it was so easy to distinguish it from the wrong path, in some ways, because we did start getting those strong signals. And in some ways, they pushed us forward.

**中文翻译:**
那是我们的背景，是我们以前做过的事情，我们觉得那里的问题非常巨大且迫切。一旦我们开始围绕新的云安全转型进行对话，气氛就完全不同了。虽然都是通过 Zoom，但我们的感觉非常不一样。一旦找到了正确的道路，就很容易将其与错误的道路区分开来，因为我们确实开始收到那些强烈的信号。在某种程度上，是这些信号在推着我们前进。

---

### [00:19:02] Raaz Herzberg

**English:**
A customer was like, "Okay, I want to start a POV," and we're like, "Oh, okay. Of course. Let's schedule for Thursday next week, or something. We tried to even postpone it a bit, because we had to run fast." Another learning I have from that phase was, I explicitly remember that first conversation, where it was like, "Okay, let's do a POV." It was a Fortune 10 company, a really big company, and we had a beginning of a product. We wanted to buy some time, until we actually started the POV.

**中文翻译:**
有个客户说：“好，我想开始做 POV，”我们心想：“哦，好的。当然。我们约在下周四吧。” 我们甚至试图推迟一点，因为我们必须跑得飞快。我从那个阶段学到的另一个教训是，我清楚地记得第一次对话，当时对方说：“好，我们做个 POV 吧。” 那是一家财富 10 强的公司，规模非常大，而我们当时只有一个产品的雏形。我们想争取点时间，直到真正开始 POV。

---

### [00:19:33] Raaz Herzberg

**English:**
Just because of that, we said, "Okay, also we want to really understand exactly what they will connect to us as part of the POV," because everything was so initial. So we put this long list of technical questions, "What are you using for this? What are you doing here? What are you [inaudible 00:19:47]?" On the one hand, because we needed to know, to actually build a thing, on the other end, just because we wanted to buy time, and I was super scared.

**中文翻译:**
正因为如此，我们说：“好，我们也想确切了解在 POV 过程中你们会把什么连接到我们这里，”因为一切都太初期了。于是我们列了一长串技术问题：“你们用什么做这个？你们在这里怎么操作？你们……” 一方面是因为我们需要知道这些来真正构建产品，另一方面只是想争取时间。我当时超级害怕。

---

### [00:19:55] Raaz Herzberg

**English:**
I remember studying that e-mail, and being like, "Ugh, they want a POV. And now, I'm going to scare them away, with this list of things they have to do, and list of questions, like it's counterintuitive." But actually, it came back filled a day later, and I remember my lesson being, "You know what? This is actually good. I want to make sure they're committed, right? I don't want to push somebody into a POV, if he is not committed to me at this stage."

**中文翻译:**
我记得当时盯着那封邮件想：“呃，他们想要 POV，而我现在要用这一大堆待办事项和问题把他们吓跑，这太反直觉了。” 但事实上，一天后他们就填好发回来了。我记得我学到的一课是：“你知道吗？这其实是好事。我想确保他们是认真的，对吧？如果对方在这个阶段对我没有承诺，我不想强推他们做 POV。”

---

### [00:20:32] Raaz Herzberg

**English:**
I'm not trying to push something on someone, especially not at this point, and my opinion, not ever, not even today, not even when you sell at large scales. I'm not trying to push anybody to anything, I really want to make sure they want it. I have to feel that want back. So that was another learning for me. It's like, first of all, when it works, it works, and you do know when it works. And the second is, "Don't be too afraid to get the pull from the customer." It's okay. You need that pull from the other end, as well. Don't push too hard.

**中文翻译:**
我不想强迫任何人接受任何东西，尤其是在那个阶段。在我看来，永远不要强推，即使是今天，即使是大规模销售时也是如此。我不想强迫任何人做任何事，我真的想确保他们想要它。我必须感受到对方的那种渴望。所以这是我的另一个收获。首先，行得通就是行得通，你确实能感觉到。其次，“不要太害怕去获得客户的拉力（Pull）。” 没关系的。你也需要另一端的拉力。不要推得太猛。

---

### [00:21:03] Lenny Rachitsky

**English:**
I know people always talk about, "Look for pull," and I love that you're describing what pull looks like. Somebody's next day, filling out a really complicated annoying questionnaire, because they just want this product they've never heard of before you chatted with them. Now, they're like, "Just give it to me now. I'm going to do anything you need." Is there anything else along these lines, before we move into your current role and learnings there?

**中文翻译:**
我知道人们总是在谈论“寻找拉力”，我很喜欢你对拉力的描述。那就是某人在第二天就填好了一份极其复杂烦人的调查问卷，仅仅是因为他们想要这个在和你聊天之前从未听说过的产品。现在他们就像在说：“现在就给我吧，你需要什么我都配合。” 在我们转向你目前的角色和心得之前，还有什么这方面的经验吗？

---

### [00:21:23] Raaz Herzberg

**English:**
I also think that one of the things we did very, almost uniquely, it was, was that, because things started rolling so fast for us, once we found the right path, we ended up selling before we had a seller's team. We ended up, almost in some ways, always being behind, right? Okay, I'm closing contracts with people, I haven't hired my first salespersons, I don't know what we're doing here, I don't know how to have the conversations.

**中文翻译:**
我还认为，我们做得非常独特的一点是，因为一旦找到了正确的道路，事情进展得太快了，结果我们在还没有销售团队的时候就开始卖产品了。在某种程度上，我们似乎总是慢半拍，对吧？好，我正在和人签合同，但我还没招到第一个销售人员，我不知道我们在干什么，我甚至不知道该怎么谈。

---

### [00:21:49] Raaz Herzberg

**English:**
But we ended up learning so much from that, from us, ourselves, us being the founders, myself, closing the deals, actually going all the way to contracts and everything, by ourselves. We learned a lot, we learned a lot. And then, when we hired our first sales hire, it was also like, "Look, we sold a couple million of this, so you, for sure, as a salesperson, you kind of give that confidence."

**中文翻译:**
但我们最终从中获益匪浅，我们自己——创始人、我自己——亲自去谈成交易，亲自走完合同流程，搞定一切。我们学到了很多。然后，当我们招到第一个销售人员时，我们可以说：“看，我们已经卖了几百万美元了，所以你作为销售，肯定会有那种信心。”

---

### [00:22:14] Raaz Herzberg

**English:**
So I felt like there was multiple places where that ended up happening, just by accident, because of how fast things ended up happening for us. Actually, it was a really good learning experience to do it for the first time yourselves. I think, sometimes, when you start building a company, you have this wish that if you can't do something, you're going to hire the right person, and he will be able to do it.

**中文翻译:**
所以我感觉到，由于事情进展得太快，很多地方都是机缘巧合下发生的。实际上，第一次亲自动手是非常棒的学习经历。我觉得，有时候当你开始创办公司时，你会有一种愿望：如果你做不了某件事，你就去招一个合适的人，他就能搞定。

---

### [00:22:49] Raaz Herzberg

**English:**
Okay, I feel like my message is not clear enough, and we just started this company, it's okay, I'm going to hire my first product marketer, and that's going to be it. Or I feel, we can't close a deal, because I need to hire my first salesperson, and that will be it. I hardly find that, I don't think we've ever had that work for us, honestly. It's like, if you can't do it one time end to end, and you're the core, core group, the chances of just bringing somebody from the outside to solve that problem, it's wishful, in some ways, but it never ends up that way.

**中文翻译:**
比如，“我觉得我的信息传达得不够清晰，我们才刚起步，没关系，我去招第一个产品营销人员，问题就解决了。” 或者，“我觉得我们签不下单，因为我需要招第一个销售，然后就万事大吉了。” 我发现事实并非如此，老实说，我觉得这在我们身上从未奏效过。如果你作为核心团队成员，不能亲自从头到尾完成一次，那么指望从外部招个人来解决这个问题的几率，某种程度上只是痴人说梦，事情永远不会那样发展。

---

### [00:23:08] Lenny Rachitsky

**English:**
I love this advice so much. There's kind of two parallels here. If the founder can't do it, who has the most context and passion and motivation? It's unlikely an employee's going to be able to do it. And it's similar to the selling point, that if your early customers aren't pulling from you, later customers are not going to have a good time, right? It's like, the most passion comes early. How long did you all stay, doing sales as a founding team? How many millions ARR, roughly, do you remember?

**中文翻译:**
我太喜欢这个建议了。这里有两个相似之处。如果拥有最深背景、最强热情和动力的创始人做不到，员工也不太可能做得到。这和销售点很像：如果早期客户不主动拉动你，后期的客户也不会有好体验，对吧？最强烈的热情往往来自早期。作为创始团队，你们亲自做销售做了多久？大概做到了多少万 ARR，你还记得吗？

---

### [00:23:39] Raaz Herzberg

**English:**
Oh, a couple million. I don't remember the exact-

**中文翻译:**
噢，几百万美元。我不记得确切的——

---

### [00:23:41] Lenny Rachitsky

**English:**
A couple million?

**中文翻译:**
几百万美元？

---

### [00:23:41] Raaz Herzberg

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:23:43] Lenny Rachitsky

**English:**
Awesome. That's incredible. Often, the heuristic I hear is, one or two million ARR, and then you start to hire salespeople. Okay, that was an awesome lesson. I love that. I want to talk about your current role. So currently, you're CMO, and also, VP of product strategy at Wiz. You started as an engineer, you moved into product, and now you're in marketing, which is not a traditional path, especially for product people. First of all, why did you decide to move into marketing, from product?

**中文翻译:**
太棒了，这很了不起。通常我听到的经验法则是，做到一两百万 ARR 后开始招销售。好，这是非常棒的一课。我很喜欢。我想聊聊你现在的角色。目前你是 Wiz 的 CMO，也是产品策略副总裁。你从工程师起步，转到产品，现在又做营销，这可不是传统的路径，尤其是对产品人来说。首先，你为什么决定从产品转到营销？

---

### [00:24:11] Raaz Herzberg

**English:**
Yeah, it's not a traditional path for anyone, I think, also not one I would have necessarily expected myself to be on. First of all, it's not like I had this plan, right? In general, I myself, people sometimes ask me about career progression, and I never had a plan for anything. That is just, the only thing I did was follow good people around. That's it. I never had a plan for anything I do.

**中文翻译:**
是的，我觉得这对任何人来说都不是传统路径，我也没预料到自己会走这条路。首先，我并没有什么计划，对吧？总的来说，有时人们问我职业晋升的事，我其实对任何事都没有计划。我唯一做的就是追随优秀的人。仅此而已。我做任何事都没有预设的计划。

---

### [00:24:36] Raaz Herzberg

**English:**
So myself, coming to Wiz was following Assaf and Ynon in the founding team. And two and a half years into Wiz, at that time, Wiz was already, it was a very clear product market fit. Our revenues were already there. We had a sales team that was fully functioning, but at that point at Wiz, we felt marketing was still something we didn't fully figure out. It wasn't working super well for us.

**中文翻译:**
所以我来到 Wiz 是为了追随创始团队中的 Assaf 和 Ynon。在加入 Wiz 两年半后，那时 Wiz 已经有了非常明确的产品市场契合。我们的收入已经上来了，销售团队也运作良好。但在那个阶段，我们觉得营销还是我们没完全搞明白的事情，它对我们来说效果不是特别好。

---

### [00:25:13] Raaz Herzberg

**English:**
We were at this stage where, yes, if there was a POV, a proof of value happening, we would win it, versus competition. But many times, we would come to a customer, and they would be like, "Oh, I wish we heard of Wiz, we just signed with a competitor," which it breaks your heart, because I know they would have chosen me, had they heard about me in time. So you started feeling that challenge around awareness and marketing. So two and a half years into the company, basically Assaf, our CEO, asked me if I was willing to take on marketing.

**中文翻译:**
我们当时处于这样一个阶段：如果有 POV（价值证明）测试，我们肯定能赢过竞争对手。但很多时候，我们去找客户，他们会说：“噢，真希望早点听说 Wiz，我们刚和竞争对手签了约。” 这真让人心碎，因为我知道如果他们及时听说过我，一定会选我的。所以你开始感受到知名度和营销方面的挑战。于是，在公司成立两年半后，我们的 CEO Assaf 问我是否愿意接手营销。

---

### [00:25:42] Raaz Herzberg

**English:**
Originally, I thought it was, I remember, he knocked on my, bothered me while I was working on my computer, and we went into this super cold room. It was like, when you were a fast-growing startup, all of the rooms are always full, you know what I mean? We went into this server room, which is freezing cold, and I was in the middle of something, and he told me, "I think you should lead the marketing org now." I told him, "Okay." I was like, "Assaf, I'm cold, I'm going back to work. I have a lot to do." It sounded that bizarre to me.

**中文翻译:**
起初我觉得这太离谱了。我记得他敲了敲我的桌子，在我对着电脑工作时打断了我，然后我们进了一个超级冷的房间。你知道的，在快速增长的初创公司，所有的会议室永远是满的。我们进了一个冷得要命的机房，我当时正忙着呢，他跟我说：“我觉得你现在应该领导营销部门。” 我跟他说：“好吧。” 我当时想的是：“Assaf，我很冷，我要回去工作了，我还有一堆事要做。” 这对我来说听起来太荒谬了。

---

### [00:26:12] Raaz Herzberg

**English:**
It's not only, do they not know marketing, I spent my life in engineering, and in any product, it's not the go to market side, even. I was never part of the go to market, or I have never heard of a lead in my life. I did not know the word "pipeline." All of those things were very remote to me, very. It sounded like such a bizarre motion. But that was on a Thursday, and then, I spent the weekend, because he asked me to, and again, I just follow good people...

**中文翻译:**
不仅是他们不懂营销，我这辈子都在做工程和产品，甚至都没接触过 GTM（推向市场）这一端。我从未参与过 GTM，这辈子甚至没听说过“线索”（Lead）这个词。我也不知道什么是“Pipeline”（销售漏斗）。所有这些对我来说都非常遥远，非常。这听起来像是一个极其古怪的提议。但那是周四，然后我花了一个周末——因为他要求我考虑，而我总是追随优秀的人……

---

### [00:26:42] Raaz Herzberg

**English:**
So I spent the weekend listening to a ton of podcasts, talking to CMOs, just to even understand what do CMOs do, what do marketing orgs do in B2B companies? Then I ended up deciding to just give it a try, and we did not know if it was going to work. I also don't know if it's going to work forever, but we ended up deciding to give it a try.

**中文翻译:**
于是我那个周末听了大量的播客，和一些 CMO 聊天，只是为了弄明白 CMO 到底是干什么的，B2B 公司的营销部门又是干什么的。最后我决定试一试，我们当时也不知道这行不行得通。我也不知道这是否能长久奏效，但我们最终决定尝试一下。

---

### [00:27:04] Raaz Herzberg

**English:**
I think the thing that's convinced me to do it was that, in some ways, I really felt like if, in the early days of the company, finding product market fit is a major block for the company. And then, building a sales organization becomes a major block for the company. I felt like we were at the point, where you have to figure it out to scale. At some point, of every product, people start looking really heavily at brand, whether we think that way, or we don't.

**中文翻译:**
我认为说服我去做这件事的原因是，在某种程度上，我真的觉得在公司早期，寻找产品市场契合是主要的障碍。接着，建立销售组织成了主要障碍。我觉得我们当时正处于一个必须解决营销问题才能实现规模化扩张的节点。在任何产品的某个阶段，人们都会开始非常看重品牌，无论我们是否意识到这一点。

---

### [00:27:39] Raaz Herzberg

**English:**
When I buy my iPhone, I have no idea how it really is compared to an Android phone. I did not look at the specs. I truly have no idea. So why do I buy an iPhone? I just know it's the thing to buy. B2B products, even the most complex products, people are still people. They still buy it, because brand matters a lot. That was part of what convinced me that this is super important. So if I'm asked to attempt, at least try, because I do think it's really important.

**中文翻译:**
当我买 iPhone 时，我根本不知道它和安卓手机相比到底怎么样。我没看规格参数，真的完全不懂。那我为什么要买 iPhone？我只知道它是该买的东西。B2B 产品也是一样，即使是最复杂的产品，买家也还是人。他们买它是因为品牌很重要。这就是说服我这件事极其重要的原因之一。所以如果让我去尝试，至少要试一下，因为我确实认为这非常重要。

---

### [00:28:19] Raaz Herzberg

**English:**
Yeah, it's exactly that. It's like that in the early, early days when we just started with, I remember, I felt like the heat was in the product kitchen. Because it's like, everybody's waiting to have something, people want to start doing something, right? Then they felt like, "Okay, you start understanding it," and now, the heat moves a bit to the engineering side like, "Okay, build it. Somebody wants it, build it, make it work."

**中文翻译:**
是的，就是那样。就像在刚开始的极早期阶段，我记得我感觉到“热度”（Heat）是在产品厨房里。因为每个人都在等着出点东西，大家都想开始做点什么，对吧？然后大家觉得：“好，你开始理解它了，”接着热度就转移到了工程端：“好，把它造出来。有人想要它，造出来，让它跑通。”

---

### [00:28:44] Raaz Herzberg

**English:**
Then I felt, "Okay, so we close a couple of deals now," right? We had our first couple of clients. Now you bring in sales, and the heat moves to sales, because they're like, "Okay, we have this thing, now go sell it." And then, the heat starts moving to marketing, in my opinion, where it's like, "Okay, we have a product market fit. Salespeople can sell it, but they're saying, 'Give me more pipeline like, 'Hey, nobody heard of Wiz. Give me more.'" So the heat moves to marketing, at that point. That's kind of, I've always felt like, yeah, in some ways, I also naturally, I guess, follow the heat.

**中文翻译:**
接着我觉得：“好，我们现在签了几个单子，”对吧？我们有了第一批客户。现在你引入了销售，热度就转移到了销售端，因为他们会说：“好，我们有产品了，现在去卖掉它。” 然后在我看来，热度开始向营销转移，就像是：“好，我们有了产品市场契合，销售能卖出去，但他们在喊：‘给我更多 Pipeline（销售机会），嘿，没人听说过 Wiz，给我更多线索。’” 到了那个点，热度就转移到了营销。我一直觉得，是的，在某种程度上，我大概也是在自然而然地“追随热度”。

---

### [00:29:18] Lenny Rachitsky

**English:**
And I think it's actually more so, that they put the best people in the places that need the most help. Clearly, that was you, when they did that.

**中文翻译:**
我觉得实际上更多是因为，他们把最优秀的人放在了最需要帮助的地方。显然，当他们这么做时，那个人就是你。

---

### [00:30:32] Lenny Rachitsky

**English:**
I asked one of your board members, Shardul Shah, what to ask you. He's a partner at Index Ventures, and here's what he told me, speaking of this move to marketing. He said that when you were in your first board meeting, the Wiz board meeting, presenting marketing, and sharing your plan, and you asked him, "Hey, can you introduce me to all these marketing leaders, so I can learn from them," he basically did the opposite. He's like, "No, I'm going to introduce all my marketing leaders to you, because I think they need to learn from you." Why do you think that's the case?

**中文翻译:**
我问了你们的一位董事会成员 Shardul Shah 该问你什么。他是 Index Ventures 的合伙人，谈到你转行做营销时，他是这么跟我说的。他说，当你第一次参加 Wiz 的董事会会议，演示营销方案并分享计划时，你问他：“嘿，你能把我介绍给那些营销领袖吗，我想向他们学习。” 而他基本上做了相反的事。他说：“不，我要把我的所有营销领袖都介绍给你，因为我觉得他们需要向你学习。” 你觉得为什么会这样？

---

### [00:30:51] Raaz Herzberg

**English:**
I think Shardul is very kind. I deeply remember that meeting, because funny enough, it was my first board meeting ever. That is a funny thing by itself, because Wiz's board, we have Shardul on our board, we have Doug Leone, and we have Jeff from Insight. It's almost like, it's very humbling to sit down in front of those people, period. And since I decided to take marketing, and I took to the CMO role, this was also my first board meeting ever.

**中文翻译:**
我觉得 Shardul 太客气了。我深深地记得那次会议，因为很有趣，那是我人生中第一次参加董事会会议。这本身就很奇妙，因为 Wiz 的董事会有 Shardul，有 Doug Leone（红杉资本），还有 Insight 的 Jeff。坐在这些人面前本身就让人感到非常谦卑。而且自从我决定接手营销并担任 CMO 以来，那也是我的第一次董事会会议。

---

### [00:31:23] Raaz Herzberg

**English:**
And also, it was the meeting where it's, in some ways, I was not that. I was like, "Okay, we took our product manager person, she was never a CMO at any company, and now she has a CMO here." So it was just very, the whole setting was very stressful for me. I just ended up, it was like, I think we just had the meeting two months after I took over marketing. So it was more of an update of, "Hey, those are the changes I've made, and this is how I'm thinking of approaching this, and this is all the things I've done in the past two months."

**中文翻译:**
而且在某种程度上，那次会议的情况是：“好吧，我们选了一个产品经理，她从未在任何公司担任过 CMO，现在她在这里当 CMO 了。” 所以整个环境对我来说压力非常大。那次会议大概是在我接手营销两个月后开的。所以更多是一个进展汇报：“嘿，这是我做出的改变，这是我打算如何处理这件事的想法，这是我过去两个月所做的一切。”

---

### [00:31:59] Raaz Herzberg

**English:**
It's funny, because I'm a very non-traditional marketer, just because I really don't know marketing. At this point, I kind of know already, because I've been doing it for two years, and I read a lot, but at that point, I generally did not know. I could not even explain to you how untraditional my approach was, in some ways. I just really did what I thought. I mean, I had a ton to learn about marketing, but what I knew really well was the problem we solved, and I really knew our audience.

**中文翻译:**
这很有趣，因为我是一个非常非传统的营销人员，纯粹是因为我真的不懂营销。现在我大概懂一些了，因为我已经做了两年，也读了很多书，但那时我真的完全不懂。我甚至无法向你解释我的方法在某些方面是多么非传统。我只是做了我认为该做的事。我的意思是，关于营销我有太多要学的，但我非常清楚我们解决的问题，我也非常了解我们的受众。

---

### [00:32:28] Raaz Herzberg

**English:**
I myself, I come from security, I come from cloud security, I read all of the right Twitters, and I follow all of the right people on Twitter, and I read all of the right blogs. I know it's funny, I know what matters, I know it's interesting right now, generally because, this is my space. I mean, I live in that space, truly, as a customer. So I was just thinking, "Okay, what are things I could do, to start fixing the problem that mattered most?" And that was, nobody heard of Wiz at that time.

**中文翻译:**
我自己出身于安全领域，出身于云安全，我关注了所有正确的 Twitter 账号，关注了所有正确的人，读了所有正确的博客。我知道这听起来很有趣，但我知道什么重要，我知道现在什么最吸引人，主要是因为这是我的领域。我的意思是，我真的像客户一样生活在这个领域里。所以我当时就在想：“好吧，我能做些什么来开始解决那个最重要的问题？” 而那个问题就是，当时没人听说过 Wiz。

---

### [00:32:59] Raaz Herzberg

**English:**
Those were just, I was saying, "Okay, I think, in order to do that, I'm willing to take chances, I'll just focus on making a lot of noise." And I think, even in that short time of two months, we saw changes happening already, in some ways. So I think, that what's Shardul meant by that, of course, although I do think he's being very, very kind, and I have learned a lot from many, many marketing people, including my own team, by the way, which is another interesting thing., right?

**中文翻译:**
我当时说：“好吧，我认为为了实现这个目标，我愿意冒险，我将专注于制造大量的声势（Noise）。” 我觉得，即使是在那短短的两个月里，我们也已经看到了一些变化。所以我想这就是 Shardul 的意思，当然，我还是觉得他太客气了。顺便说一下，我从很多营销人员那里学到了很多，包括我自己的团队，这也是另一件有趣的事，对吧？

---

### [00:33:41] Raaz Herzberg

**English:**
I took over a large team, of people who are marketers, and I'm this person knows nothing about marketing, but will now manage this. So I learned a lot from many marketers, including my own exceptional team. But I think he meant, really looking at it differently, just thinking, "Okay, what is the end to the goal of having the right people hear the right thing about my company, ASAP," versus a ton of traditional aspects, of building pipelines and different things they really did not know how to do, at that time.

**中文翻译:**
我接管了一个由营销人员组成的大团队，而我这个对营销一窍不通的人现在要管理他们。所以我从许多营销人员那里学到了很多，包括我那卓越的团队。但我认为他的意思是，我真的在用不同的眼光看问题，只是在想：“好，为了让正确的人尽快听到关于我公司的正确信息，最终目标是什么？” 而不是纠结于当时我根本不知道怎么做的那些传统营销环节，比如建立销售漏斗之类的。

---

### [00:34:16] Raaz Herzberg

**English:**
First of all, I think CMO is a very, very hard role. And also, I think it's a role that is very hard to do without a lot of trust, and without a deep connection to the founding team. Everything you do in marketing is very visible, and you're kind of touching something that matters so deeply to the founding team, and you are the one representing it to the world. So it's very hard to build that trust, and it's very easy to break it, because one bad ad, or something that one of the founding team will say, "Oh, this is not us, this is not what I mean, this is not the right thing," it breaks the trust really easily.

**中文翻译:**
首先，我认为 CMO 是一个非常、非常难的角色。而且，我认为如果没有高度的信任，没有与创始团队的深度连接，这个角色很难胜任。你在营销中所做的一切都是非常显眼的，你触碰的是对创始团队来说至关重要的东西，而你正是向世界展示它的人。所以建立这种信任很难，而破坏它却很容易，因为一个糟糕的广告，或者创始团队成员的一句“哦，这不是我们的风格，这不是我的意思，这不对”，就能轻易破坏信任。

---

### [00:35:00] Raaz Herzberg

**English:**
And I think it's especially challenging. I mean, I really don't know how somebody that does not come from from a security background could be successful deeply, in this type of a role, for a company like Wiz, because it is really about understanding your customers, and it is really about understanding your product. I think that's very, very hard to gain. So I guess I would say, I think it's the deep trust you need with the founding team, and the really deep connection you need to the product, and to the market.

**中文翻译:**
我认为这尤其具有挑战性。我的意思是，我真的不知道一个没有安全背景的人，如何在 Wiz 这样的公司里胜任这个角色并取得深度成功，因为这真的关乎理解你的客户，关乎理解你的产品。我认为这些东西很难凭空获得。所以我大概会说，你需要与创始团队建立深厚的信任，并且需要与产品和市场建立极其深厚的连接。

---

### [00:36:05] Raaz Herzberg

**English:**
When you are a marketing leader, you manage performance marketing, which is a numbers game. You manage designers and brand, and then you manage events and field. There's nothing in between those things that is deeply correlated. Sp it's just a very, very challenging and very interesting role.

**中文翻译:**
当你是一名营销领导者时，你要管理效果营销（Performance Marketing），那是数字游戏；你要管理设计师和品牌；还要管理活动和实地营销。这些事情之间几乎没有什么深度关联。所以这真的是一个极具挑战性且非常有趣的角色。

---

### [00:36:43] Raaz Herzberg

**English:**
Yeah. Another insight I had about marketing in the early days was how different it is from product. As a product manager, I was always, and still believe, it's so important to think really hard about everything you add. Less is more. If you decide to build a feature in a product, then A, you're taking engineering time, which is the most valuable resource in every company, in my opinion, and B, in some ways, you can never take it back. It's complicated your product.

**中文翻译:**
是的。关于早期营销，我的另一个感悟是它与产品有多么不同。作为产品经理，我过去一直（现在也依然）认为，仔细思考你添加的每一项功能至关重要。少即是多。如果你决定在产品中构建一个功能，那么 A，你占用了工程时间，这在我看来是每家公司最宝贵的资源；B，在某种程度上，你永远无法收回它。它会让你的产品变得复杂。

---

### [00:37:19] Raaz Herzberg

**English:**
Every new feature you add to your product, you'll have to think about, "Okay, how does it work with that feature?" So it's like making a mistake, adding something to the product that is not the right thing, or that is not truly, truly what your customer needed, even if it's what they asked for. But if it's not what they truly needed, it has a huge cost associated with it. Marketing is quite the opposite, in my opinion. There's no cost to anything, no maintenance to anything, no technical depth, no anything.

**中文翻译:**
你为产品添加的每一个新功能，你都得考虑：“好吧，它如何与那个功能协作？” 所以，如果犯了错，添加了不正确的东西，或者不是客户真正需要的东西（即使是他们要求的），都会带来巨大的成本。而在我看来，营销恰恰相反。它几乎没有成本，不需要维护，没有技术债，什么都没有。

---

### [00:37:54] Raaz Herzberg

**English:**
If tomorrow I post a video on Wiz's LinkedIn page, and I think that video is super funny, and nobody likes that video, nothing happened. Tomorrow, I'll post a different video, no maintenance, bye-bye, forgot it ever happened. In some ways, it dawned on me how opposite those things were, and I was like, "Okay, we have to just use it to our advantage. Let's try everything, let's try everything. I'm trying to make noise."

**中文翻译:**
如果明天我在 Wiz 的 LinkedIn 页面上发了一个视频，我觉得超级搞笑，但没人点赞，那也没什么大不了的。后天我可以发个不同的视频，不需要维护，随它去吧，忘掉它发生过。在某种程度上，我意识到这两者是多么对立，于是我想：“好吧，我们必须利用这个优势。让我们尝试一切，尝试一切。我要制造声势。”

---

### [00:38:33] Raaz Herzberg

**English:**
It was right before, when I took over, it was before RSA. RSA is the Super Bowl of security companies. So it's where every vendor's come to showcase, and all of our buyers are there, and you know how those conferences go. You pay for having a space assigned to you, and it's a very expensive space to assign to yourself. And we had the exact same spot we had the year before. I said, "Okay, it's a booth at a conference. I'll just make it the weirdest booth ever, because my goal is just having people look and be like, 'Oh, what is Wiz, right? Because they've never heard of me."

**中文翻译:**
就在我接手后不久，RSA 大会快开始了。RSA 是安全公司的“超级碗”。所有的供应商都会去展示，所有的买家也都在那里。你知道这类会议是怎么回事：你付钱买一个展位，而且展位费非常贵。我们拿到了和前一年完全相同的位置。我说：“好，既然是个展位，我就要把它做成有史以来最古怪的展位，因为我的目标就是让人们看一眼然后想：‘哦，Wiz 是什么？’ 因为他们从未听说过我。”

---

### [00:39:03] Raaz Herzberg

**English:**
Instead of doing a classical cyber booth, I decided to say, "Okay, let's scrap our booth, and do a Wiz of Oz booth," which literally looked like a Wiz of Oz booth, and we had actors, like Dorothy, and all those things hanging around there. It looked nothing like any booths in the show, which is a cybersecurity show, things are red and black, and people with hoodies. And we decided to take a completely opposite approach.

**中文翻译:**
我决定不做一个传统的网络安全展位，我说：“好，把我们的展位方案扔了，做一个‘绿野仙踪’（Wizard of Oz）主题的展位。” 它看起来真的就像《绿野仙踪》里的场景，我们还有演员扮演多萝西，到处挂着那些装饰。它看起来一点也不像网络安全展会上的展位——通常那里都是红黑配色，还有穿着连帽衫的人。我们决定采取完全相反的方法。

---

### [00:39:45] Raaz Herzberg

**English:**
Half of me was like, I remember feeling so scared walking to the show, to the floor trade. Because I was like, "Is this going to be the most terrible, bizarre? Are people going to be like, 'What is she thinking?'" So I knew it could either be a failure, or a hit. And it ended up, the amount of people that stopped by our booth was five times the amount of people that stopped by the year before. It's the exact same space, the exact same investment, because you invest in the space.

**中文翻译:**
我记得当时走进展场时心里非常害怕。因为我在想：“这会不会变得非常糟糕、非常离谱？人们会不会觉得‘她到底在想什么？’” 所以我知道这要么是大失败，要么是大成功。结果是，在我们展位前驻足的人数是前一年的五倍。同样的展位空间，同样的投资（因为展位费是固定的），效果却完全不同。

---

### [00:40:46] Raaz Herzberg

**English:**
Almost every single thing I've done in my career, in some ways, even before, I never thought I was going to be successful in it. I guess there's a lot of times, it's a lot of talk about being more confident than yourself. I don't know, at least for me, I don't really know if that's a real option, okay? I just know that I'm kind of okay with being pretty sure I'm going to fail at something, and still attempting it.

**中文翻译:**
在我职业生涯中所做的几乎每一件事，某种程度上甚至在更早以前，我从未想过自己会成功。我想很多时候，人们都在谈论要比现在更有自信。我不知道，至少对我来说，我真的不知道那是否是一个真正的选项，好吗？我只知道，我能接受“确信自己会失败”这种状态，并且依然去尝试。

---

### [00:41:36] Raaz Herzberg

**English:**
I was certain that it's going to be like, "Okay, they're going to figure out that I'm not the right fit for that super smart and talented group of people," who have all worked together before, by the way, I was sure they're going to find me out. And I was pretty sure I was going to fail, but I will still take it. I thought I was going to fail the product manager role, too, although I did have the experience.

**中文翻译:**
我当时确信事情会变成：“好吧，他们会发现我不适合这群超级聪明、才华横溢的人，”顺便说一下，他们以前都共事过，我确信他们会识破我。我当时相当确定我会失败，但我还是接受了。我也曾以为我会搞砸产品经理的角色，尽管我确实有相关经验。

---

### [00:42:34] Raaz Herzberg

**English:**
Yeah, depending on what you believe in, everything comes from childhood. In some ways, I do think it has to do with, I think the way my mom raised me, my mom really believed that if you're good at something, so that's not where you should invest your energy. She really believed in pushing us to the places where we were less confident in, I guess.

**中文翻译:**
是的，取决于你相信什么，一切都源于童年。在某种程度上，我认为这与我母亲抚养我的方式有关。我母亲坚信，如果你擅长某件事，那就不应该是你投入精力的地方。我想，她真的相信要把我们推向那些我们不太自信的领域。

---

### [00:43:18] Raaz Herzberg

**English:**
But for my mom, she could have been like, "Oh, so she's really good with books and math, so let's focus. Perfect. Let her build up the skill, and be really good with that." But no, she would make me go swimming, and make me go meet other kids. In some ways, I feel, she always used to say that friction is good. If you brush your teeth, and there's a bit of blood somewhere, then you need to brush harder there. It's that idea, that friction is kind of good.

**中文翻译:**
对我母亲来说，她本可以想：“噢，她很擅长读书和数学，那我们就专注这些吧。太棒了，让她培养这项技能，变得非常厉害。” 但她没有，她会让我去游泳，让我去见其他孩子。在某种程度上，我觉得她常说“摩擦（Friction）是好事”。如果你刷牙时发现哪里有点出血，那你更需要在那儿使劲刷。就是这种理念：摩擦其实是好事。

---

### [00:44:53] Raaz Herzberg

**English:**
Having done products for many years, I really did not understand the criticality of marketing, and even of product marketing. I really did not understand deeply enough that sometimes even gap, between when you're in the product, and you really live inside the product. In the technical domain, you can sometimes not understand how far you are from a common person in your market, or a seller in your market. And marketing, in a lot of ways, bridges that gap.

**中文翻译:**
做了多年产品后，我以前真的不理解营销、甚至是产品营销的关键性。我真的没有深刻理解，当你深处产品内部、完全生活在产品世界中时，那种隔阂有多大。在技术领域，你有时无法理解你与市场上的普通人或销售人员之间的距离有多远。而营销在很多方面弥补了这一差距。

---

### [00:45:44] Raaz Herzberg

**English:**
It's like a multiplier, but the further you get away from the core engineer, than product, then in order for the messages to move correctly, they have to be crystal clear. That is something I understood only when looking at it from the other side. If you're on the product side, you can often work with things that are fluffy or blurry or gray, okay? Somebody will ask you, "Can the product do this?" You'll be like, "Yeah, not exactly, but it can do, blah, blah, blah," kind of work around something, right?

**中文翻译:**
它就像一个放大器，但当你离核心工程师和产品越远，为了让信息正确传递，信息就必须变得极其清晰。这是我只有在从另一侧观察时才明白的道理。如果你在产品端，你经常可以处理一些模糊、不确定或灰色地带的事情，对吧？有人会问你：“产品能做这个吗？” 你会说：“嗯，不完全能，但它可以做某某某，” 某种程度上是在绕弯子，对吧？

---

### [00:46:29] Raaz Herzberg

**English:**
It doesn't have to be crystal clear, because you can kind of go around things, in a way, that when you try to scale your message, you can't. It gets lost in translation. You have to be crystal clear, black and white. You have to communicate very clearly, especially as an organization scales, you have to communicate very clearly. Suddenly, you're looking at the product org from the outside, in the company that scales fast.

**中文翻译:**
它不需要非常清晰，因为你可以绕过去。但当你试图规模化传递信息时，你就不能这么做了。信息会在传递中丢失。你必须做到绝对清晰，非黑即白。你必须沟通得非常明确，尤其是当组织规模扩大时。突然之间，你在一家快速扩张的公司里从外部审视产品部门。

---

### [00:47:30] Raaz Herzberg

**English:**
There's so much. I think, for example, in our domain, it's very, almost custom, to talk in a lot of initials, and a lot of things in security are, "Use initials for them." You say CSPM, for Cloud Security Posture Management, and you use a lot of those types of initials, and you keep assuming that the world knows what you mean. But then, when actually looked at things over, from the marketing side, if you ask our product people, engineers, "Where does our product fall in terms of category," it would be CNAPP, Cloud Native Application Protection. But if you go over and you look at Google, people are not Googling that word. They're Googling, "Cloud security solution," right?

**中文翻译:**
例子太多了。比如在我们的领域，大家几乎习惯了用大量的缩写，安全领域的很多东西都是缩写。你会说 CSPM（云安全态势管理），你用了一堆这类缩写，并一直假设全世界都知道你在说什么。但当你从营销端审视时，如果你问我们的产品人员或工程师：“我们的产品属于哪个类别？” 他们会说是 CNAPP（云原生应用保护平台）。但如果你去 Google 看看，人们根本不搜那个词，他们搜的是“云安全解决方案”，对吧？

---

### [00:48:40] Raaz Herzberg

**English:**
Yes. It's when I, now in marketing, and in everything we write, and everything our team produces in terms of anything, anything written by Wiz, I keep going back to, I don't want us to forget that we are inside our own bubble. We go to work at Wiz every day. Wiz is a cloud security company. We live inside our own bubble, but reminding ourselves that customers don't live in that bubble, they're people in the world. Their life is not Wiz.

**中文翻译:**
是的。现在我在营销部门，在我们写的每一份文案、团队产出的每一件作品中，只要是 Wiz 出品的东西，我都会反复强调：我不想让我们忘记自己身处“泡沫”之中。我们每天在 Wiz 工作，Wiz 是一家云安全公司，我们生活在自己的小圈子里。但我们要提醒自己，客户并不生活在这个圈子里，他们是现实世界中的人，他们的生活中心不是 Wiz。

---

### [00:49:23] Raaz Herzberg

**English:**
So every time you write something, I wanted to not assume knowledge about Wiz, or knowledge about the product, or deep knowledge about the market. I'll give just a simple example. Wiz itself is based on, part of the deep innovation that Wiz brought to the market that enabled the scale, was a very high correlated signal that's based on a graph database. So inside Wiz, we have the Wiz graph database, for security. If you write something that says, the Wiz Graph Database, I don't like it. Because why would a common person know it is the Wiz Graph Database, right?

**中文翻译:**
所以每次写东西时，我都不想预设对方了解 Wiz，或者了解产品，或者对市场有深入了解。举个简单的例子。Wiz 本身基于一项深刻的创新，这项创新让 Wiz 能够规模化，那就是基于图数据库（Graph Database）的高度关联信号。所以在 Wiz 内部，我们有“Wiz 安全图数据库”。如果你写文案说“Wiz 图数据库”，我不喜欢。因为普通人凭什么知道什么是 Wiz 图数据库，对吧？

---

### [00:51:00] Lenny Rachitsky

**English:**
That is so funny. Okay, just a few more questions. One is, so there's four co-founders of Wiz. That right?

**中文翻译:**
太有意思了。好，最后还有几个问题。一个是，Wiz 有四位联合创始人，对吗？

---

### [00:51:08] Raaz Herzberg

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:51:38] Raaz Herzberg

**English:**
Yeah, I think the Wiz founding team is a truly incredible team. They also have a very unique story. Wiz is actually their second company together. So before Wiz, they founded Adallom, which sold to Microsoft. That's how they all ended up in Microsoft in the first place. Even before that, they all worked together in the Israeli army, so they've known each other for, they've been working together for 30 years, right?

**中文翻译:**
是的，我认为 Wiz 的创始团队真的是一支不可思议的团队。他们也有非常独特的故事。Wiz 实际上是他们共同创办的第二家公司。在 Wiz 之前，他们创办了 Adallom，后来卖给了微软。这就是他们最初都进入微软的原因。甚至在那之前，他们都在以色列军队一起服役，所以他们已经认识并共事了 30 年（或者说 20 多年）了，对吧？

---

### [00:52:31] Raaz Herzberg

**English:**
I think the unique thing about Wiz, and I truly think it defines their company's culture to this day, is exactly that they did not have to work hard, to be able to impact strategy, and get a seat at the table. I think that it's open, it's a very open culture, and an open company, that goes back to the beginning of being able to say, "I don't understand." They really believe in employees, and they really believe in giving everybody a chance to have impact.

**中文翻译:**
我认为 Wiz 的独特之处——我也真心认为这定义了公司至今的文化——正是因为员工不需要费尽心机才能影响战略或获得一席之地。我认为这是一种开放的文化，一家开放的公司，这又回到了最初提到的能够说出“我不明白”。他们真心相信员工，真心相信给每个人产生影响力的机会。

---

### [00:54:03] Raaz Herzberg

**English:**
It's so funny, because I don't think we've covered anything contrarian. I think one thing is, maybe goes back to what I was talking about before, but it was failing in confidence. I think at least, being a woman in tech, you get talked to a lot about imposter syndrome, and building up her confidence. I actually do think that my approach to it, at least for me, has been just more effective. I won't be able to build that confidence.

**中文翻译:**
这很有趣，因为我觉得我们还没聊到什么反传统的观点。我想有一点，也许可以回到我之前说的，那就是关于“缺乏自信”。我认为至少作为科技界的女性，你经常会被谈论到“冒充者综合征”（Imposter Syndrome）以及如何建立自信。但我其实觉得我的处理方式——至少对我来说——更有效。我可能永远无法建立起那种所谓的自信。

---

### [00:54:49] Raaz Herzberg

**English:**
I do feel like an imposter, and I know there's always those statistics about many people feeling that way. So I think, maybe just, "Let's embrace it. I feel like an imposter, you feel like an imposter, everybody feels like an imposter," It's kind of, maybe embrace it, but don't let that stop you from making a decision. Maybe they will find out you're an imposter, maybe let them find out. It's fine.

**中文翻译:**
我确实觉得自己像个冒充者，我知道总有统计数据说很多人都有这种感觉。所以我想，也许就“拥抱它吧。我觉得自己像冒充者，你也觉得，大家都觉得。” 某种程度上，也许该拥抱这种感觉，但不要让它阻止你做决定。也许他们会发现你是个冒充者，那就让他们发现好了。没关系的。

---

### [00:56:48] Raaz Herzberg

**English:**
So I focus like it was on the product side of things. We mentioned the heat in the kitchen. Actually, one of my most favorite business books, and I've read a lot of them, is probably Setting the Table, by Danny Meyer, which is, he owns Shake Shack, and a chain of really great restaurants in New York. And it's such an interesting business perspective, from a different domain, than obviously tech or SaaS.

**中文翻译:**
我还是关注产品方面的东西。我们提到了“厨房里的热度”。实际上，我最喜欢的商业书籍之一（我读过很多）大概是 Danny Meyer 写的《Setting the Table》。他是 Shake Shack 的老板，在纽约拥有一系列非常棒的餐厅。这是一个非常有趣的商业视角，来自一个显然不同于科技或 SaaS 的领域。

---

### [00:57:50] Raaz Herzberg

**English:**
And then, a second book I really like, I read it early on in Wiz, and so did the entire founding team, I think, the book by Netflix co-founder Reed Hastings, No Rules Rules, which also, I think, talks very clearly. Netflix has a super unique culture and story, right? Talk about pivots, they sold cassettes over mail, and somehow pivoted to what it is today. That's an insane story.

**中文翻译:**
我非常喜欢的第二本书，是我在 Wiz 早期读的，我想整个创始团队也都读了，那就是 Netflix 联合创始人 Reed Hastings 写的《不拘一格》（No Rules Rules）。我认为这本书讲得非常透彻。Netflix 有着超级独特的文化和故事，对吧？谈到转型，他们以前通过邮件寄送录像带，结果转型成了今天的样子。那是一个疯狂的故事。

---

### [01:01:29] Raaz Herzberg

**English:**
I think, keeping it simple. If you start feeling like something is too complex, or an answer is too complex, or something you're building in the product is too complex probably, or something in your life feels too complex, probably, it does mean something. But sometimes, you just have to maybe take two steps back, leave it there, until you come back to it again, and you find a simple way out.

**中文翻译:**
我认为是“保持简单”。如果你开始觉得某件事太复杂，或者一个答案太复杂，或者你在产品中构建的东西可能太复杂，或者你生活中的某些事情感觉太复杂，这通常意味着一些问题。但有时候，你只需要退后两步，把它先放一放，直到你再次回到它面前，你会找到一条简单的出路。

---

### [01:02:40] Raaz Herzberg

**English:**
Yeah, I mean, I can't address any specific offers. Obviously, Wiz over the years has gotten many acquisition offers. I can share, that I think for us, us being the founding team, the employees, the customers, the board, staying on an independent path, we all really believe that Wiz can become one of the biggest security companies in the world.

**中文翻译:**
是的，我不能谈论任何具体的报价。显然，Wiz 这些年来收到了很多收购邀约。我可以分享的是，对于我们——包括创始团队、员工、客户和董事会——来说，坚持独立发展的道路，是因为我们都坚信 Wiz 能够成为全球最大的安全公司之一。

---

### [01:04:37] Raaz Herzberg

**English:**
Find me on LinkedIn, and yeah, no apply. We'd love great people who are learners, which I think is what this podcast is all about. So definitely, the right place to find the right people.

**中文翻译:**
在 LinkedIn 上找我，还有，欢迎申请职位。我们热爱那些善于学习的优秀人才，我想这也是这个播客的宗旨所在。所以，这里绝对是寻找志同道合者的正确地方。

---

### [01:04:52] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。下期见。