# Rahul Vohra - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Rahul Vohra.

---

### [00:00:00] Lenny Rachitsky

**English:**
Let's talk about product market fit.

**中文翻译:**
让我们来聊聊产品市场契合度（Product Market Fit）。

---

### [00:00:01] Rahul Vohra

**English:**
You have to deliberately not act on the feedback of many of your early users, and this is at the same time as listening to people intensely and building what people want. That's what we're here to do, is to make something that people want, but it can't be all people. And the question becomes, how do you listen to them? And then even of what they say, what do you pay attention to and what don't you? The trick here is-

**中文翻译:**
你必须刻意地不去采纳许多早期用户的反馈，而与此同时，你又要极度认真地倾听人们的声音，并打造人们想要的东西。我们在这里要做的就是做出人们想要的东西，但这个“人们”不能是所有人。问题变成了：你如何倾听他们？即使在他们所说的话中，哪些是你需要关注的，哪些又是可以忽略的？这里的诀窍是——

---

### [00:00:26] Lenny Rachitsky

**English:**
You're not doing what a lot of CEOs think they need to be doing with their time. A lot of CEOs think they need to spend time on hiring or org building and you intentionally, "I will spend time on product and marketing design."

**中文翻译:**
你并没有做很多 CEO 认为他们应该花时间去做的事情。很多 CEO 觉得他们需要把时间花在招聘或组织建设上，而你却是有意为之：“我要把时间花在产品、营销和设计上。”

---

### [00:00:36] Rahul Vohra

**English:**
This is a technique that I call the switch log. It's born out of the observation that your calendar says what you thought you were going to do, but it's really only your trail of work that describes what you actually did. How can we capture that? So I came up with the following idea. What if I just did whatever the heck I wanted?

**中文翻译:**
这是一种我称之为“切换日志”（Switch Log）的技术。它源于一种观察：你的日历显示的是你“以为”自己要做的事，但真正描述你“实际”做了什么的，只有你的工作足迹。我们该如何捕捉这一点呢？于是我产生了一个想法：如果我完全随心所欲地做事会怎样？

---

### [00:00:56] Lenny Rachitsky

**English:**
What's the most pivotal moment in your career, in your life?

**中文翻译:**
在你职业生涯或生活中，最关键的时刻是什么？

---

### [00:00:58] Rahul Vohra

**English:**
I learned the real secret behind virality. There is no such thing as a truly viral product. What then is the true secret? It is-

**中文翻译:**
我学到了病毒式增长（Virality）背后的真正秘密。世界上根本不存在所谓的“真正病毒式”的产品。那么真正的秘密是什么呢？它是——

---

### [00:01:12] Lenny Rachitsky

**English:**
Today my guest is Rahul Vohra. Rahul is the founder and CEO of Superhuman and one of the most thoughtful and insightful and articulate founders that I've met. As you'll see in our conversation, it's hard not to be captivated by Rahul's storytelling skills and also his really insightful takes on how to build great products and teams.

**中文翻译:**
今天的嘉宾是 Rahul Vohra。Rahul 是 Superhuman 的创始人兼 CEO，也是我见过的最深思熟虑、最有见地、表达最清晰的创始人之一。正如你在我们的对话中将看到的，你很难不被 Rahul 的讲故事技巧以及他在打造卓越产品和团队方面的深刻见解所吸引。

(00:01:32):
**English:**
This episode is for anyone who's looking to build their product taste, help their teams move faster, learn how to think better from first principles. And also learn about Superhuman's very unique approach to building their company, including why they manually onboarded every single new user for years and why they decided to stop. Why they ignored most of their customer feedback on their way to finding product market fit, and also how you can use his approach to finding product market fit for your own company. Also, the power of game design in building great products, a very contrarian take on pricing strategy, what Rahul has learned about building scaled products on top of AI and LLMs and so much more.

**中文翻译:**
这一集适合所有想要提升产品品味、帮助团队加快速度、学习如何从第一性原理出发进行思考的人。你还将了解到 Superhuman 非常独特的公司建设方法，包括为什么他们多年来坚持人工引导（manually onboard）每一位新用户，以及为什么后来决定停止；为什么他们在寻找产品市场契合度的过程中忽略了大部分客户反馈，以及你如何将他的方法应用到自己的公司。此外，还有游戏设计在打造卓越产品中的力量、一种非常反传统的定价策略、Rahul 在基于 AI 和大语言模型（LLM）构建规模化产品方面的经验，以及更多精彩内容。

(00:02:07):
**English:**
A huge thank you to Ed Sims, Conrad Irwin, Bell Trenchard and Gaurav Vohra for suggesting questions and topics for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become a yearly subscriber of my newsletter, you get a year free of Superhuman that you can start using immediately. You also get a year free of Notion, Perplexity Pro, Granola and Linear. Check it out at lennysnewsletter.com. With that, I bring you Rahul Vohra.

**中文翻译:**
非常感谢 Ed Sims、Conrad Irwin、Bell Trenchard 和 Gaurav Vohra 为本次对话提供的建议问题和话题。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（Newsletter）的年度订阅者，你将获得一年的 Superhuman 免费使用权，可以立即开始使用。你还可以免费获得一年的 Notion、Perplexity Pro、Granola 和 Linear。请访问 lennysnewsletter.com 查看详情。下面，让我们欢迎 Rahul Vohra。

---

### [00:02:38] Ad Segment (Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing and feature management platform, built by alums of Airbnb and Snowflake, for modern growth teams. Companies like Twitch, Nero, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and understanding the performance of new features, and Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Nero、ClickUp 和 DraftKings 等公司都依赖 Eppo 来支持他们的实验。实验对于推动增长和了解新功能的表现越来越重要，Eppo 能帮助你提高实验速度，同时解锁其他商业工具无法提供的严谨深度分析。

(00:03:08):
**English:**
When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments, easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more, with advanced statistical methods that can help you shave weeks off experiment time and accessible UI for diving deeper into performance. And out-of-the-box reporting that helps you avoid annoying prolonged analytic cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at geteppo.com/lenny and 10x your experiment velocity. That's geteppo.com/lenny.

**中文翻译:**
当我在 Airbnb 工作时，我最喜欢的事情之一就是我们的实验平台，在那里我可以独立设置实验、排除故障并分析表现。Eppo 不仅能做到这些，还拥有先进的统计方法，可以帮你缩短数周的实验时间，并提供易用的 UI 进行深度性能挖掘。其开箱即用的报告能帮你避免烦人的漫长分析周期。Eppo 还能让你轻松与团队分享实验见解，激发 A/B 测试飞轮的新创意。Eppo 支持各种场景的实验，包括产品、增长、机器学习、商业化和邮件营销。请访问 geteppo.com/lenny 查看 Eppo，让你的实验速度提升 10 倍。网址是 geteppo.com/lenny。

---

### [00:03:56] Ad Segment (Fundrise)

**English:**
This episode is brought to you by the Fundrise Flagship Fund. Full disclosure, real estate investing is boring. Prediction markets are exciting. Meme coins are a thrill ride. Even the stock market can swing wildly on a headline. Hello, DeepSeek. But with real estate investing, there's no drama or adrenaline or excuses to refresh your portfolio every few minutes, just bland and boring stuff like diversification and dividends. So you won't be surprised to learn that the Fundrise Flagship Real Estate Fund is a complete snooze fest.

**中文翻译:**
本集节目由 Fundrise 旗舰基金赞助。坦白说，房地产投资很无聊。预测市场很刺激，模因币（Meme coins）像过山车，甚至股市也会因为一个头条新闻而剧烈波动（比如 DeepSeek）。但在房地产投资中，没有戏剧性，没有肾上腺素，也没有理由每隔几分钟就刷新一次投资组合，只有平淡无奇的多元化和分红。所以，当你听说 Fundrise 旗舰房地产基金完全是个“催眠曲”时，你一定不会感到意外。

(00:04:28):
**English:**
The fund holds $1.1 billion worth of institutional caliber real estate managed by team of pros focused on steadily growing your net worth for decades to come. See, boring. That's the point. You can start investing in minutes and with as little as $10 by visiting fundrise.com/lenny. Carefully consider the investment objectives, risks, charges, and expenses of the Fundrise Flagship Fund before investing. Find this information and more in the fund's prospectus at fundrise.com/flagship. This is a paid ad.

**中文翻译:**
该基金持有价值 11 亿美元的机构级房地产，由专业团队管理，专注于在未来几十年稳步增长你的净资产。看吧，很无聊。但这正是重点。你只需几分钟，最低只需 10 美元即可开始投资，请访问 fundrise.com/lenny。在投资前，请仔细考虑 Fundrise 旗舰基金的投资目标、风险、费用和支出。你可以在 fundrise.com/flagship 的基金招股说明书中找到这些信息。这是一则付费广告。

---

### [00:05:04] Rahul Vohra

**English:**
Rahul, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Rahul，非常感谢你能来。欢迎来到本播客。

---

### [00:05:07] Rahul Vohra

**English:**
Hello, hello and thank you for having me Lenny.

**中文翻译:**
哈喽，哈喽，谢谢你邀请我，Lenny。

---

### [00:05:10] Lenny Rachitsky

**English:**
I have so many questions for you. We're going to have so much to talk about. I actually want to start with your time before Superhuman. When I was preparing for this chat, I actually asked you, what's the most pivotal moment in your career in your life? And you told me that other than starting Superhuman, it was selling your previous company Rapportive to LinkedIn. So let me just start there. What was that experience like? What do people not know about this phase in your life and just why was it so pivotal?

**中文翻译:**
我有很多问题想问你。我们有很多话题可以聊。我想从你创立 Superhuman 之前的经历开始。在准备这次访谈时，我问过你，你职业生涯和生活中最关键的时刻是什么？你告诉我，除了创立 Superhuman 之外，就是把你之前的公司 Rapportive 卖给 LinkedIn。那我们就从这里开始吧。那段经历是怎样的？关于你生命中的那个阶段，有哪些是人们不知道的？为什么它如此关键？

---

### [00:05:37] Rahul Vohra

**English:**
So for folks that don't know, Rapportive was my last company. It was the first Gmail extension to scale to millions of users. Basically on the right-hand side of Gmail, we would show you what people look like, where they work, links to their recent tweets, their LinkedIn profile and everything else that they were doing online. So if you were hiring, marketing, selling in BD, super useful. It turns out we somehow attracted most of LinkedIn's daily active users onto this one free app, and I then ultimately ended up selling that to LinkedIn. That by far, as you said, was the most pivotal thing I'd done in my career, prior to starting Superhuman.

**中文翻译:**
对于不了解的人来说，Rapportive 是我的上一家公司。它是第一个扩展到数百万用户的 Gmail 插件。基本上，在 Gmail 的右侧，我们会显示对方的长相、工作地点、最近推文的链接、他们的 LinkedIn 个人资料以及他们在网上做的其他事情。所以如果你在做招聘、营销、销售或业务拓展（BD），它超级有用。事实证明，我们不知怎么地把 LinkedIn 的大部分日活跃用户都吸引到了这个免费应用上，最终我把它卖给了 LinkedIn。正如你所说，到目前为止，那是我在创立 Superhuman 之前职业生涯中最关键的一件事。

(00:06:22):
**English:**
Now, had I known that we'd amassed most of LinkedIn's active users onto one app, I would have sold it for far more. But the actual pivotal moment was really who I got to work with. Because I reported to LinkedIn's head of Growth, Elliot Shmukler. He was responsible for scaling LinkedIn from 25 million members to when I joined, north of 250 million members. And during my first one-on-one, I learned the real secret behind virality and big hint, it's not about viral mechanics. Overall that acquisition experience gave me the time to figure out what was next and the resources to truly swing for the fences.

**中文翻译:**
如果当时我知道我们把 LinkedIn 的大部分活跃用户都聚集到了一个应用上，我会卖出更高的价格。但真正的关键时刻其实在于我共事的人。因为当时我向 LinkedIn 的增长负责人 Elliot Shmukler 汇报。他负责将 LinkedIn 从 2500 万会员扩展到我加入时的 2.5 亿多会员。在我的第一次一对一沟通中，我学到了病毒式增长背后的真正秘密——提示一下，这与病毒机制（viral mechanics）无关。总的来说，那次收购经历给了我时间去思考下一步该做什么，也给了我资源去真正放手一搏（swing for the fences）。

---

### [00:07:02] Lenny Rachitsky

**English:**
Okay. Well, I have to follow this thread that you put out there, what the secret is to virality. What did you learn there?

**中文翻译:**
好，那我必须顺着你抛出的这个线索问下去：病毒式增长的秘密到底是什么？你在那里学到了什么？

---

### [00:07:08] Rahul Vohra

**English:**
Well, in my first one-on-one, I sat down with Elliot and I said, "Hey, I'm here to learn. Please teach me everything that you know about virality." And he said, "Okay. Well, hate to burst your bubble, but there is no such thing as a truly viral product." I said, "What do you mean? How do you explain Facebook for that matter? How do you explain LinkedIn?" And he said, "What I mean is, no app has sustained a viral factor of greater than one for any real period of time." Even Facebook in its heyday had a viral factor of about 0.7. And he told me that lasted for perhaps a year, so one person was creating about 0.7 new users.

**中文翻译:**
在我的第一次一对一中，我坐在 Elliot 面前说：“嘿，我是来学习的。请教给我你所知道的关于病毒式增长的一切。”他说：“好吧，虽然不想泼你冷水，但世界上根本没有所谓的‘真正病毒式’的产品。”我问：“你什么意思？那 Facebook 怎么解释？LinkedIn 怎么解释？”他说：“我的意思是，没有任何应用能在任何实际的时间段内维持大于 1 的病毒系数（viral factor）。即使是鼎盛时期的 Facebook，其病毒系数也只有 0.7 左右。”他告诉我，那大概持续了一年，也就是说一个人能带来大约 0.7 个新用户。

(00:07:57):
**English:**
I double-clicked again and I said, "Well Elliot, what about the address book import?" This is one of the things that LinkedIn got famous or infamous for. You could import your address book and then it would spam slash invite everyone who happens to be members of LinkedIn in your address book, and then eventually it would just invite everyone to LinkedIn. And he said, "That's an amazing feature, but you have to remember not everyone is going to use it all the time." So even that feature had a lifetime viral factor of about 0.4, and that's considered good.

**中文翻译:**
我再次追问：“Elliot，那通讯录导入功能呢？”这是 LinkedIn 成名（或声名狼藉）的功能之一。你可以导入通讯录，然后它会向通讯录中已经是 LinkedIn 会员的人发送邀请，最终甚至会邀请所有人加入 LinkedIn。他说：“那是个很棒的功能，但你要记住，并不是每个人都会一直使用它。”所以即使是那个功能，其终身病毒系数也只有 0.4 左右，而这已经被认为是很不错了。

(00:08:28):
**English:**
0.4 is good for a viral feature, 0.6 is great, something like 0.7 is absolutely incredible. You're in the stratosphere up with Facebook at that time. So I said, "Well, okay, all of these things by definition are going to Peter out. There's going to be an asymptote. None of these viral mechanics keep on compounding. Which actually makes sense, it would be a little absurd if things just kept on growing. What then is the true secret behind virality?" And he said, "It is word of mouth. It is the virality you can't measure that isn't a mechanic that isn't in a feature. It is when one user spontaneously tells another user about your product." That really colored how I think about growth and virality. Since then, it has shaped so much of what we do at Superhuman and so much of how I think about growing brands.

**中文翻译:**
对于一个病毒式功能来说，0.4 算好，0.6 算优秀，0.7 简直是不可思议——那已经是当时 Facebook 的水平了。所以我说：“好吧，按照定义，所有这些东西最终都会逐渐消失（Peter out）。会有一个渐近线。这些病毒机制都不会持续复利增长。这其实也说得通，如果东西一直无止境增长就太荒谬了。那么，病毒式增长背后的真正秘密到底是什么？”他说：“是口碑（word of mouth）。是那种你无法衡量的病毒性，它不是一种机制，也不在某个功能里。它是当一个用户自发地向另一个用户介绍你的产品时发生的。”这真正影响了我对增长和病毒性的看法。从那时起，它塑造了我们在 Superhuman 所做的很多事情，以及我对品牌成长的思考方式。

---

### [00:09:23] Lenny Rachitsky

**English:**
Wow, you're such a great storyteller. I'm just listening here, just captivated, "What is he going to say next?" That was fascinating. I actually have a post that I'm going to link to that, that very much aligns with what you're talking about, which is titled, Virality is a Myth mostly. It's based, I forget, on this book where they do all this research on actual viruses. It turns out they're not actually spreading in this exponential way, there's one person that spreads it to a lot of people and it keeps happening.

**中文翻译:**
哇，你真是个讲故事的高手。我听得入迷了，一直在想“他接下来会说什么？”这太引人入胜了。我其实有一篇博文，我会把链接放上去，它和你说的非常吻合，标题叫《病毒式增长大多是个神话》（Virality is a Myth mostly）。它是基于——我忘了哪本书了——书中对真实病毒进行了研究。结果发现，它们其实并不是以这种指数级的方式传播的，而是一个人传播给很多人，然后这种情况不断发生。

(00:09:52):
**English:**
That's actually apparently what the data shows. I'm curious if you found this same thing, which is, when people think of an app as going viral, it's one person with a massive platform sharing it and their audience adopts it and that's just one to many and then it just happens a couple of times and it looks like it's going viral, but it's a person to many people, not many people to many people. Thoughts on that?

**中文翻译:**
数据显然就是这么显示的。我很好奇你是否也发现了同样的情况，即当人们认为一个应用“走红”时，通常是一个拥有巨大平台的人分享了它，然后他们的受众采用了它，这只是一对多的传播，然后这种情况发生了几次，看起来就像是病毒式传播，但实际上是一个人对很多人，而不是很多人对很多人。你对此怎么看？

---

### [00:10:14] Rahul Vohra

**English:**
Yeah, we've definitely found that there are whales, to use the gaming terminology, that one person is going to be responsible for inviting 25, 50, 100 people, and they may have various motivations for doing that. In Superhuman, as an individual subscriber, if you refer somebody else and they sign up, you both get a free month, which is a great incentive if you're paying out of pocket.

**中文翻译:**
是的，我们确实发现存在“大鲸鱼”（whales）——借用游戏术语——即一个人会负责邀请 25、50 甚至 100 个人，他们这样做可能有各种动机。在 Superhuman，作为个人订阅者，如果你推荐别人并让他们注册，你们双方都会获得一个月的免费使用权，如果你是自费订阅，这是一个很大的激励。

(00:10:39):
**English:**
We have people who send many, many hundreds of invites and there are some people who essentially have free Superhuman for life now due to how many people they've invited. But of course that incentive doesn't necessarily work inside of a company or inside of a team where ultimately it's the company paying for the product, so you have to then come up with new motivations for those people. That's where there really isn't any substitute to having a genuinely multiplayer or a genuinely collaborative product. That's one of the huge evolutions we've taken Superhuman through over the last, probably about two years.

**中文翻译:**
我们有些用户发送了数百个邀请，有些人因为邀请的人太多，现在基本上终身免费使用 Superhuman。但当然，这种激励在公司或团队内部不一定奏效，因为最终是公司在为产品买单，所以你必须为这些人想出新的动力。这就是为什么拥有一个真正的“多玩家”或真正的协作产品是无可替代的。这是我们在过去大约两年里对 Superhuman 进行的重大演进之一。

(00:11:15):
**English:**
Early last year we launched what we call Superhuman 2.0. The basic idea is, we saw almost every single other app of note become collaborative by default, Figma, Notion, Loom. These are all multiplayer or collaborative by default. Yet email, the one tool that we all use more than anything else, even more than things like Slack, was still firmly stuck in its single-player origins.

**中文翻译:**
去年年初，我们推出了所谓的 Superhuman 2.0。基本想法是，我们看到几乎所有其他知名的应用都默认变成了协作模式，比如 Figma、Notion、Loom。这些都是默认多玩家或协作的。然而，电子邮件——这个我们所有人使用频率最高、甚至超过 Slack 的工具——仍然牢牢地困在它的“单机版”起源中。

---

### [00:11:43] Lenny Rachitsky

**English:**
I want to come back to something that you mentioned that I didn't come back to you that I think is really core to what you just shared, which is word of mouth being so important. People talk about all these viral features and sharing contact books and all these things. And your point is, that takes you to a place, but really what helps a consumer-ish product spread is word of mouth, people sharing with each other. Which, then the question is, how do you do that? We're going to talk about a lot of things that you did to make Superhuman something people want to share, but in the end it's just making something people want to share. That's the definition almost. Then it's like, what makes people want to share stuff? It's amazing, it's helping them, something that is remarkable.

**中文翻译:**
我想回到你刚才提到的一点，我认为那是你分享的核心，即口碑的重要性。人们总在谈论各种病毒式功能、分享通讯录等等。而你的观点是，这些只能带你走一段路，真正帮助消费级产品传播的是口碑，是人与人之间的分享。那么问题来了：你如何做到这一点？我们会聊到很多你为了让 Superhuman 成为人们想分享的东西而做的事，但归根结底，就是做出人们想分享的东西。这几乎就是定义。那么，是什么让人们想分享东西呢？是因为它很惊艳，能帮到他们，是一些“非凡”（remarkable）的东西。

---

### [00:12:22] Rahul Vohra

**English:**
Well, it turns out, because you mentioned remarkableness, that is one of our core company values. If you think about what a company has to do, it has to grow. How do things grow? Well, let's take Elliot's advice at face value, and I believe it's true, it's creating something that people share. You mentioned one way of doing it, which is something that people want to share. There's actually another way, which is simply creating something remarkable, and you used that word, and that is one of the core values of Superhuman.

**中文翻译:**
既然你提到了“非凡”（remarkableness），这恰好是我们公司的核心价值观之一。如果你思考一家公司必须做什么，那就是增长。东西是如何增长的？如果我们完全采纳 Elliot 的建议——我相信那是对的——那就是创造人们会分享的东西。你提到了一种方法，即做出人们“想要”分享的东西。其实还有另一种方式，就是单纯地创造出“非凡”的东西，你用了这个词，而这正是 Superhuman 的核心价值观之一。

(00:12:53):
**English:**
We have, create delight, create something that is so joyful that really truly brings people delight. We have deliver remarkable quality, something that is so striking, so compelling and worthy of attention that people can't but help tell others about it. Then we have build the extraordinary, which is a measure of the efficacy or the innovativeness of what we want to build. That's another trick, which is literally baking these raw ingredients for growth into your company values.

**中文翻译:**
我们的价值观包括：创造愉悦（create delight），创造出如此令人快乐、能真正带给人们愉悦感的东西；交付非凡品质（deliver remarkable quality），做出如此引人注目、如此有说服力且值得关注的东西，以至于人们忍不住想告诉别人；还有打造卓越（build the extraordinary），这是衡量我们想要构建的东西的效能或创新性的标准。这是另一个诀窍，就是直接将这些增长的原始素材融入到你的公司价值观中。

---

### [00:13:23] Lenny Rachitsky

**English:**
I didn't know that was one of your values. That makes so much sense. Okay, we're going to come back to that, because I think that is... There's so much to learn about how you think about product and how you think about building the company that builds the product. But I want to actually start here with how this conversation came to be.

**中文翻译:**
我以前不知道那是你们的价值观之一。这太有道理了。好，我们会回到这个话题，因为我觉得……关于你如何思考产品，以及如何思考建立一个打造产品的公司，有很多值得学习的地方。但我其实想从这次对话的由来开始聊起。

(00:13:41):
**English:**
The CEO of Product Hunt, Rajiv, tweeted months ago, he tweeted this and we're going to show this if you're on YouTube, "Superhuman's product velocity feels like it's kicked into another gear as of late. Does anyone else notice this?" I saw that, I'm like, "I completely have noticed this. It feels like there's just feature shipping left and right, AI this, AI that. It feels like it's just a new company." And I tagged you on the tweet. I'm like, "Hey Rahul, what's changed?" And you answered with a few things and it just made it clear there's a lot to learn about what you did.

**中文翻译:**
Product Hunt 的 CEO Rajiv 几个月前发了一条推文，如果你在看 YouTube 的话我们会展示出来，他说：“Superhuman 最近的产品迭代速度（product velocity）感觉进入了另一个档位。还有人注意到吗？”我看到后心想：“我完全注意到了。感觉功能一个接一个地发布，AI 这个，AI 那个。感觉就像是一家新公司。”我在推文下艾特了你，问：“嘿 Rahul，发生了什么变化？”你回答了几点，这让我意识到关于你所做的事情，有很多值得学习的地方。

(00:14:12):
**English:**
Because a lot of companies are in this phase of just, "Things aren't moving as fast as we want. We used to be so much faster, we used to ship all these features and now we don't." So I think this is a really cool real case study illustrative example that we can analyze. So let me ask you this, what did you notice that told you something needed to change at Superhuman? And then what did you change that actually had the most impact on your ability to ship and move faster?

**中文翻译:**
因为很多公司都处于这种阶段：“事情进展得不如我们预期的快。我们以前快得多，以前能发布这么多功能，现在却不行了。”所以我认为这是一个非常酷的真实案例研究，我们可以分析一下。那么我问你：你注意到了什么，让你觉得 Superhuman 需要做出改变？然后，你做了哪些改变，对你们发布产品和加快速度的能力产生了最大的影响？

---

### [00:14:37] Rahul Vohra

**English:**
I think what we noticed was this sentiment, and we felt it first ourselves, but we also started hearing it from the market, from our users, from our customers, that we'd slowed down. And as a founder, as a CEO, that's the absolute last thing you want to hear. It's our job after all to speed things up. When I ask people what do they mean by slowing down, they didn't mean the product, of course, the product wasn't working any slower, but that the pace of delivery seemed to have slowed down.

**中文翻译:**
我想我们注意到的是一种情绪，首先是我们自己感觉到了，然后我们也开始从市场、用户和客户那里听到这种声音，说我们变慢了。作为创始人，作为 CEO，这是你绝对最不想听到的话。毕竟我们的工作就是加速。当我问人们所谓的“变慢”是什么意思时，他们当然不是指产品本身运行变慢了，而是指交付的节奏似乎放缓了。

(00:15:09):
**English:**
I think to break this down, it's important to start by defining what we mean by a slowdown. There's the kind of slowdown that is unavoidable in certain spaces, and then there is the kind of slowdown that is quite avoidable. We actually had both. So starting with unavoidable slowdown, you can classify anything that you build in a company into one of two categories, solution deepening and market widening. Now, solution deepening means making your product better for its existing users, but not making it available to more users. Whereas market widening means making your product available to more users, but not making the product itself any better.

**中文翻译:**
要分析这个问题，首先定义什么是“放缓”很重要。有些放缓在某些领域是不可避免的，而有些放缓则是完全可以避免的。实际上，这两种情况我们都有。先说不可避免的放缓，你可以将公司构建的任何东西归为两类：方案深化（solution deepening）和市场拓宽（market widening）。方案深化意味着让产品对现有用户更好，但不让更多用户使用它。而市场拓宽意味着让更多用户可以使用产品，但产品本身并没有变得更好。

(00:15:50):
**English:**
There are some spaces, there are some markets, there are some platforms where market widening is really fast and really easy, and there are some spaces, email is one of them where market widening is really hard and really slow. But when we started we had a great deal of focus. We only supported Gmail, we were only on the web. In those early years, we could pour every ounce of R&D energy, every engineering dollar, into solution deepening, making the product better for existing users. And of course users loved it. It's how we got to product market fit. It's how most startups do.

**中文翻译:**
在某些领域、市场或平台，市场拓宽非常快且容易；但在某些领域——电子邮件就是其中之一——市场拓宽非常困难且缓慢。我们刚开始时非常专注，只支持 Gmail，只在网页端。在最初的几年里，我们可以把每一盎司的研发精力、每一美元的工程费用都投入到方案深化中，让产品对现有用户更好。用户当然很喜欢，这就是我们获得产品市场契合度的方式，也是大多数初创公司的做法。

(00:16:24):
**English:**
But at a certain point, almost every company then has to start investing in widening the market. For example, the market of people who will use a new Gmail front end but without a mobile app, does exist, but it is relatively small. This is something that every new email startup is going to learn sooner or later. In order to keep on growing, you are going to have to need to add an iOS app and then a MacOS app, and then a Windows app, and then an Android app. Then you'll soon want to support Office 365. But that's not one thing, that's actually three things, because you have to support Office 365 on desktop and then on iOS and then on Android. That's all much easier said than done.

**中文翻译:**
但在某个时间点，几乎每家公司都必须开始投资于拓宽市场。例如，愿意使用新的 Gmail 前端但没有移动端应用的人群确实存在，但相对较小。这是每个新的电子邮件初创公司迟早都会学到的教训。为了持续增长，你需要增加 iOS 应用，然后是 MacOS 应用，接着是 Windows 应用，最后是 Android 应用。然后你很快就会想支持 Office 365。但这不只是一件事，实际上是三件事，因为你必须在桌面端、iOS 端和 Android 端分别支持 Office 365。这些都是说起来容易做起来难。

(00:17:04):
**English:**
I think we at Superhuman now know things about these APIs that literally no other company knows, and I would not wish it upon my worst enemy. So fast-forward to today, and Superhuman now works wherever you do on every combination of Gmail, Outlook, Mac, Windows, Web, iOS, Android, and this actually turns out to be a really great technology moat. Almost no other email app can claim this. It's taken many years of intense investment. I think we'll touch on this later, but it's one of the main reasons why we can sell into the enterprise, because we now know everyone can use it.

**中文翻译:**
我想我们 Superhuman 现在对这些 API 的了解，简直是其他任何公司都不知道的，我甚至不希望我的死对头去经历这些。快进到今天，Superhuman 现在可以在你工作的任何地方运行，支持 Gmail、Outlook、Mac、Windows、Web、iOS、Android 的各种组合，这实际上成为了一个非常棒的技术护城河。几乎没有其他电子邮件应用能做到这一点。这耗费了多年的密集投资。我想我们稍后会谈到这一点，但这是我们能卖给企业客户的主要原因之一，因为我们现在知道每个人都能使用它。

(00:17:37):
**English:**
But this is the hard part, when you're doing that market widening, you're not solution deepening, so your perceived product velocity may decrease. You can avoid some of these things with some smart technology decisions, but mostly you just have to grind through it, and it is worth it to get to the other side. Then there's the kind of slowdown that is avoidable. If I remember my answer to Rajiv's tweet, that was the kind I was talking about. In that case it was our management structure, or who does what.

**中文翻译:**
但困难的部分在于，当你进行市场拓宽时，你并没有在进行方案深化，所以你被感知到的产品迭代速度可能会下降。你可以通过一些聪明的技术决策来避免其中一些问题，但大多数时候你只能硬扛过去，而到达彼岸是值得的。然后是那种可以避免的放缓。如果我没记错我对 Rajiv 推文的回复，我指的就是这种。在那个案例中，问题出在我们的管理结构，或者说谁负责什么。

(00:18:07):
**English:**
When we hired our initial executive teams, I followed very conventional wisdom. I ended up with a set of VPs and eight, I think direct reports, maybe even nine. I thought that's what you were meant to do. That's how startups are meant to scale. But as anyone who's been there knows, eight direct reports is a lot. It's a lot of hiring, it's a lot of goal setting, it's a lot of OKRs, it's a lot of accountability conversations, and fortunately also it's a lot of firing. No CEO ever gets their executive team right on the first try. That time I had for the things that I think I can genuinely be world-class at things like product and design and technology and marketing, that all began to rapidly disappear, and as a result the organization began to slow down.

**中文翻译:**
当我们招聘最初的高管团队时，我遵循了非常传统的智慧。我最终拥有了一群 VP 和 8 个——我想是 8 个，甚至可能是 9 个——直接下属。我以为这就是你应该做的，这就是初创公司规模化的方式。但任何经历过的人都知道，8 个直接下属太多了。这涉及到大量的招聘、目标设定、OKR、问责对话，幸运的话，还有大量的解雇。没有哪个 CEO 能在第一次尝试时就组建好完美的高管团队。我原本花在那些我认为自己能达到世界级水平的事情上的时间——比如产品、设计、技术和营销——开始迅速消失，结果组织开始变慢。

(00:18:54):
**English:**
Unfortunately, I was also tracking my time very closely, I had this crazy way of tracking it. At one point I noticed I was spending six to 7% of my week on these areas, these areas where I can truly be world-class at. So I had two realizations. Number one, as CEO, once you get to a certain scale, and we were definitely at that scale, you can actually define what you want the role of a CEO to be at your company. And number two, the Superhuman opportunity deserves everyone who works at the company to spend as much time as possible in their zone of genius, so that includes me as well as everybody else. What I did is, I hired a really great president, I went from eight direct reports to two, and the amount of time that I spend on product design, technology and marketing went up from six to 7% to about 60% to 70% of my week.

**中文翻译:**
不幸的是，我当时还在非常紧密地追踪我的时间，我有一种疯狂的追踪方式。在某个时刻，我注意到我每周只有 6% 到 7% 的时间花在这些领域，这些我真正能做到世界级的领域。于是我有了两个感悟：第一，作为 CEO，一旦达到一定规模（我们当时确实达到了），你其实可以定义你希望 CEO 在你的公司里扮演什么角色。第二，Superhuman 的机会值得公司里的每一个人都尽可能多地待在他们的“天才领域”（zone of genius）里，这包括我，也包括其他人。我所做的是，我聘请了一位非常优秀的总裁，我的直接下属从 8 个减少到了 2 个，而我花在产品设计、技术和营销上的时间从每周 6%-7% 增加到了 60%-70%。

---

### [00:19:49] Lenny Rachitsky

**English:**
Just to mirror back a few things. One is, people may feel like you are not shipping as much as you used to because you're actually building things they don't care about, which is support for office and all these things that they don't need, but the business needs to expand, integrations with Microsoft and Android and all these things. I think that's such a good point, that it looks like nothing's happening when there's a lot of good stuff happening for other users that aren't you.

**中文翻译:**
我想总结几点。第一，人们可能会觉得你没有以前发布得那么勤快，是因为你实际上在构建他们不关心的东西，比如对 Office 的支持，以及所有这些他们不需要但业务扩展需要的东西，比如与微软、Android 的集成等等。我觉得这一点说得太好了：当很多好事发生在其他用户身上而不是你身上时，看起来就像什么都没发生一样。

(00:20:15):
**English:**
Then there's this point about people delegate. Then a leader of delegates, hires all these execs and they're like, "This is not what I wanted. Why have I done this?" And you think it's going to speed up, but it slows down. A couple threads here that are really interesting. One is this time tracking thing, I need to know how do you do this? The fact that you knew seven to 8% or whatever the number is, to that granularity of your time you're spending on things you wanted was that low, how do you do time tracking? Let's not go super far, but just what's your approach?

**中文翻译:**
然后是关于授权的一点。一个领导者授权，雇佣了所有这些高管，然后他们会想：“这不是我想要的。我为什么要这么做？”你以为会加速，结果却减速了。这里有几个很有趣的线索。一个是时间追踪，我想知道你是怎么做的？你能知道自己花在想做的事情上的时间只有 7% 到 8% 这么细的粒度，你是怎么做时间追踪的？我们不用展开太细，但你的方法是什么？

---

### [00:20:48] Rahul Vohra

**English:**
This is a technique that I call the Switch log. It's born out of the observation that your calendar says what you thought you were going to do, but it's really only your trail of work that describes what you actually did. So how can we capture that? And actually, how can we create a system of work that isn't tethered to a calendar, where you aren't at the behest of what some timetable says you do or you don't have to do? So I came up with the following idea, what if I just did whatever the heck I wanted? What if every single time I change task I just Slack DM'd my EA, but this also works in Slackbot, it just has to go somewhere. I Slack DM'd my EA and I said, "TS:," and then a few words for the task I was doing.

**中文翻译:**
这是一种我称之为“切换日志”（Switch Log）的技术。它源于一种观察：你的日历显示的是你“以为”自己要做的事，但真正描述你“实际”做了什么的，只有你的工作足迹。我们该如何捕捉这一点呢？实际上，我们如何建立一个不束缚于日历的工作系统，让你不必听命于某个时间表告诉你该做什么或不该做什么？于是我产生了一个想法：如果我完全随心所欲地做事会怎样？如果每次我切换任务时，我就给我的行政助理（EA）发一条 Slack 私信（当然用 Slackbot 也可以，只要有个地方存就行）。我给 EA 发 Slack 说：“TS:”（任务切换），然后写几个词描述我正在做的任务。

(00:21:45):
**English:**
Well, that would create certain changes. Instead of having to constantly look at the calendar and think, "Oh, should I stop this task, start that task, I can just do what I want." If what I feel right now is, "Oh boy, I really need to prepare for Lenny's podcast, I'll go ahead and do that." And if I get bored or distracted eight minutes in, which sometimes happens because something else just bubbles up to the top of my mind, well, there's a reason that my body is bubbling it up to the top of my mind. I also practice transcendental meditation, so I'm very keen on the idea of being aware and listening to what's bubbling up.

**中文翻译:**
这会带来一些变化。我不再需要不断看日历并思考“哦，我是不是该停止这个任务，开始那个任务”，我可以只做我想做的事。如果我现在觉得“天哪，我真的需要为 Lenny 的播客做准备”，那我就去做。如果八分钟后我感到无聊或分心了（这种情况有时会发生，因为脑子里冒出了别的事），那么，我的身体把它冒出来肯定是有原因的。我也练习超觉静坐（Transcendental Meditation），所以我非常热衷于保持觉察并倾听脑子里冒出来的想法。

(00:22:20):
**English:**
So it's okay for me to then go and attend to that thought as opposed to start to expend my focus points or my discipline or willpower on the thing that I thought I was meant to be doing. All I'd have to do is I'd go back to Slack, "TS: Dealing with this other thing." And by the way, you should obviously turn up for your meetings. I'm not saying just blow through your meetings and not turn up for your one-on-ones. Definitely do those things. What I'm saying is, do what feels right for as long as it feels right to do. Then at the end of the week you can see where your time is going.

**中文翻译:**
所以，我可以去处理那个想法，而不是把我的专注力、自律或意志力耗费在那些我“以为”我该做的事情上。我只需要回到 Slack 发一条：“TS: 处理另一件事。”顺便说一下，你显然还是应该参加会议。我不是说让你翘掉所有会议，不参加一对一沟通。那些事肯定要做。我的意思是，在感觉对的时候做感觉对的事，直到感觉不再对为止。然后到周末，你就能看到你的时间都花在哪了。

(00:22:55):
**English:**
I realized at one point that I was spending only in those days 5% of my time on recruiting, whereas perhaps I should be spending 20 or 30% or more of my time on recruiting. But the biggest thing was, I saw I was only spending six to 7% of my time on product, on design, on technology and marketing. These are things where I know I'm really good at them. I should either be teaching people how to do them or doing them or some combination of both. That's probably the best thing for me. It keeps me really happy, very joyful, it keeps me sharp, but it's also scaling the organization. So that's how we had that kind of an insight. Once you have this Slack Log, you can then graph it and chart it and see where your time is actually going.

**中文翻译:**
我曾在某个阶段意识到，我当时只花了 5% 的时间在招聘上，而也许我应该花 20% 或 30% 甚至更多的时间。但最重要的一点是，我发现我只花了 6% 到 7% 的时间在产品、设计、技术和营销上。这些是我知道自己非常擅长的事情。我应该要么教别人怎么做，要么自己做，或者两者兼而有之。这对我来说可能是最好的安排。它让我保持快乐、愉悦，让我保持敏锐，同时也扩展了组织。这就是我们获得那种洞察力的方式。一旦你有了这个 Slack 日志，你就可以把它绘成图表，看看你的时间到底去哪了。

---

### [00:23:37] Lenny Rachitsky

**English:**
How cool. Clearly this is an app opportunity or an agent opportunity where you're just telling this thing every time. It's essentially tracking context, which we're always hearing, try not to avoid context which switches.

**中文翻译:**
太酷了。这显然是一个应用机会或 AI 智能体机会，你每次只要告诉它就行。这本质上是在追踪上下文切换（context switching），我们总听说要尽量避免上下文切换。

---

### [00:23:50] Rahul Vohra

**English:**
I think context switches are fine. There's definitely this idea that, for every interruption you have, the brain does take roughly 21 minutes on average to recover, to get back to the efficacy before that you were disturbed. It's a big deal, of course, I'm building productivity software, we designed Superhuman to minimize the amount of distraction and disruption that's possible within the app. But if you are working on something and at the back of your mind something bubbles up, you have to attend to it in one way or the other. Sometimes I just write it down, actually, I don't have my notebook with me, but it's really big. I have a gigantic, whatever twice the size of A4 is, I guess A3 sketchbook and I always have a 4H pencil, so whenever one of those thoughts comes up, I just scribble it down. Or I actually stop what I'm doing and I attend to that task, because there's a reason it's bubbling up right now.

**中文翻译:**
我认为上下文切换没问题。确实有一种观点认为，每次被打断，大脑平均需要大约 21 分钟才能恢复到被打扰前的效率。这当然是件大事，我正在开发生产力软件，我们设计 Superhuman 就是为了尽量减少应用内可能出现的干扰和中断。但如果你正在做某件事，脑子里突然冒出了别的事，你必须以某种方式处理它。有时我只是把它写下来，实际上，我没带笔记本，但它很大。我有一个巨大的、大概是 A4 两倍大的 A3 素描本，我总是用 4H 铅笔，所以每当有想法冒出来，我就随手记下来。或者我干脆停下正在做的事去处理那个任务，因为既然它现在冒出来，肯定是有原因的。

---

### [00:24:44] Lenny Rachitsky

**English:**
I love that you know exactly the type of paper and pencil, 4H pencil, A3 paper, [inaudible 00:24:51]. Okay, this is going to be a theme. You mentioned meditation, you said you do TM, so you do 20 minutes in the morning, 20 minutes... Do you do it that style or you do a longer session?

**中文翻译:**
我喜欢你连纸张和铅笔的型号都记得这么清楚，4H 铅笔，A3 纸。好，这会成为一个主题。你提到了冥想，你说你做超觉静坐（TM），所以你早上做 20 分钟，下午做 20 分钟……你是按那种风格做的，还是时间更长一点？

---

### [00:25:01] Rahul Vohra

**English:**
I do about half an hour in the morning, including rest time. The physical rest component of it is very important to me. So it's 20 minutes of the actual meditation, then 10 minutes of rest. I do that in the morning as well as in the afternoon at around 3:00 PM.

**中文翻译:**
我早上做大约半小时，包括休息时间。身体休息的部分对我来说非常重要。所以是 20 分钟的正式冥想，然后是 10 分钟的休息。我早上做一次，下午 3 点左右也做一次。

---

### [00:25:13] Lenny Rachitsky

**English:**
And you just carve that out in your calendar. Everyone knows Rahul at three o'clock, he's going to be out.

**中文翻译:**
你就把它在日历上空出来。大家都知道 Rahul 三点钟会消失。

---

### [00:25:17] Rahul Vohra

**English:**
Absolutely. My EA knows, they're the one who's organizing the calendar and making sure things happen when they need to happen. They also know that nothing can override this TM block. Without it I genuinely start to fall apart. But with it, I'm able to access some very deep competencies that I didn't have before. I've been doing this now for about four or five years, and initially I simply felt happier, occasionally even more euphoric coming out of a really great meditation session. But over time I found that my ability to focus was increasing. I could hold attention on something for much longer, but I also was able to become much more creative and much more expressive.

**中文翻译:**
没错。我的 EA 知道，他们负责安排日历并确保事情按时进行。他们也知道，任何事情都不能覆盖这个 TM 时段。没有它，我真的会开始崩溃。但有了它，我能够触及一些以前没有的深层能力。我已经坚持了大约四五年了，起初我只是觉得更快乐，偶尔在一次很棒的冥想后甚至会感到愉悦。但随着时间的推移，我发现我的专注力在提高。我可以更长时间地保持注意力，而且我也变得更有创造力和表现力。

(00:26:02):
**English:**
These are well-known side effects, as it were, or intended effects for some people of TM. And interestingly about TM, if you compare it to other forms of meditation, they don't have quite the same impact across quite as many executive functions. So there's something particularly interesting that's going on with transcendental meditation as opposed to other forms that folks are still trying to unravel and figure out.

**中文翻译:**
这些可以说是众所周知的副作用，或者对某些人来说是 TM 的预期效果。有趣的是，如果你将 TM 与其他形式的冥想进行比较，它们在这么多执行功能上的影响并不完全相同。所以，超觉静坐相对于其他形式，有一些特别有趣的东西，人们仍在试图解开和弄明白。

---

### [00:26:26] Lenny Rachitsky

**English:**
If folks want to, if they're inspired and they want to check out this form of meditation, any advice on where they could go learn?

**中文翻译:**
如果有人受到启发，想尝试这种形式的冥想，关于去哪里学习你有什么建议吗？

---

### [00:26:32] Rahul Vohra

**English:**
Absolutely, a lot. But in summary, have a coach teach you. I had many false starts myself with meditation, trying the various apps, learning from books. None of it really worked for me. What worked was having one-on-one teaching from someone themselves who had been taught one-on-one the Yogic or the Raja tradition of teaching. This person in particular had also been a venture-backed founder multiple times over, so they're very well aware of the kinds of stresses that I tend to be under. And all of his clients are mostly in technology as well. If you're in the Bay Area, this person's name is Laurent Valasek. They run an institution called the Peak Leadership Institute. And this is all about how we can live a more integrated and whole life. Integrating wellness practices like meditation, but for the purpose of unlocking peak performance in life and in business.

**中文翻译:**
当然，有很多建议。但总的来说，找个教练教你。我自己尝试冥想时也有过很多失败的开始，试过各种应用，看书学习，但都没用。真正起作用的是接受一对一的指导，对方本身也是接受过瑜伽或拉贾（Raja）传统一对一传授的人。特别的是，这个人本身也多次担任过风险投资支持的创始人，所以他非常清楚我所承受的那种压力。他的客户也大多在科技行业。如果你在湾区，这个人的名字叫 Laurent Valasek。他们经营着一家名为“巅峰领导力学院”（Peak Leadership Institute）的机构。这完全是关于我们如何过上更完整、更整合的生活。将冥想等健康实践整合进来，目的是解锁生活和商业中的巅峰表现。

---

### [00:27:31] Lenny Rachitsky

**English:**
Thank you for sharing that. That is very actionable. We're going to link to that in the show notes.
(00:27:35):
Okay. I'm going to try to bring us back on course. The other thing you mentioned that I think is really interesting is hiring a president. A lot of founders and leaders might be hearing this and be like, "Going from eight reports and doing all these things I don't want to, spending most of my time on the product and design and marketing, amazing." What did this president take off your plate and what is their responsibility and that allowed you to do the stuff you wanted to do?

**中文翻译:**
谢谢你的分享。这非常有操作性。我们会把链接放在节目介绍里。
好，我试着把话题拉回来。你提到的另一件我觉得很有趣的事是聘请了一位总裁。很多创始人和领导者听到这里可能会想：“从 8 个下属、做一堆不想做的事，变成把大部分时间花在产品、设计和营销上，太棒了。”这位总裁帮你分担了哪些工作？他们的职责是什么，从而让你能去做你想做的事？

---

### [00:27:58] Rahul Vohra

**English:**
The biggest thing was taking off the operations and the management of the executive team and the rest of the company. Think of the president role in Superhuman as an operationally extremely challenging and a very growthful role. It is perfect for someone who wants to go on to be a CEO in their next role. Instead of hiring and firing that team, instead of managing and setting their goals, instead of the accountability conversations, someone else who's now doing that.

**中文翻译:**
最大的事情是接手了运营以及对高管团队和公司其余部分的管理。把 Superhuman 的总裁角色想象成一个在运营上极具挑战性且非常有成长空间的职位。它非常适合那些希望在下一份工作中担任 CEO 的人。现在由另一个人来负责招聘和解雇团队、管理和设定目标、进行问责对话，而不是我。

(00:28:35):
**English:**
In addition, because that's not the only job, in addition, they're also a very strong thought partner when it comes to corporate strategy. When it comes to, where do we take act one, our email product? How far do we go down the multiplayer path? How aggressively should we lean into AI? What's a reasonable gross margin in a world with AI? Are we from a financial perspective okay dipping now and then coming back later? When should we start building our second product? How do we think about our R&D strategy? Should we keep on hiring in the Bay Area, or as we've done for many of our recent hires, should we continue hiring in Latin America? Should we consider other time zones as well? And so on and so on and so on. I'm just randomly coming up with questions, but the list is truly endless.

**中文翻译:**
此外，因为这不只是唯一的工作，他们还是公司战略方面非常强大的思想伙伴。比如：我们的“第一幕”——电子邮件产品——该往哪里走？我们在“多玩家”道路上要走多远？我们应该多激进地投入 AI？在 AI 世界里，合理的毛利率是多少？从财务角度看，我们现在利润下滑、以后再回升是否可行？我们什么时候该开始开发第二个产品？我们的研发战略是什么？我们应该继续在湾区招聘，还是像最近很多招聘那样，继续在拉美招聘？我们是否应该考虑其他时区？等等等等。我只是随口列举了一些问题，但这个清单真的是无穷无尽的。

(00:29:27):
**English:**
Another way to think about it is, it's almost like a grown-up co-founder. The two people I co-founded the company with, Comrade and Vivek, they've long since gone from Superhuman. We're now a 10-year-old organization and I'm one those rare founders that is persisting and thriving actually 10 years in. That said, the journey never gets easier, it gets different and you still need that co-founding energy around you. I have a handful of people in the organization who are in their roles providing that kind of energy, that kind of input, and who thrive off doing so. Then the president role is definitely one of them.

**中文翻译:**
另一种思考方式是，这就像是一个“成年版”的联合创始人。和我一起创立公司的两个人，Comrade 和 Vivek，早就离开 Superhuman 了。我们现在是一个成立 10 年的组织，而我是那种罕见的、在 10 年后依然坚持并蓬勃发展的创始人。即便如此，这段旅程从未变得更容易，只是变得不同了，你仍然需要身边有那种“联合创业”的能量。我在组织里有几个人，他们在各自的角色中提供这种能量和投入，并乐在其中。总裁这个角色绝对是其中之一。

---

### [00:30:07] Lenny Rachitsky

**English:**
Incredibly interesting. There's so much there. One, just a couple of things I'll share and then I want to move on to a different topic. One is just, it's cool the solution to helping you move faster and do the work you want to do is org design. That feels like a really doable thing. If you're finding you're not spending time on things you want to spend time on and things aren't moving as fast as you want, it's essentially you can find people to take on things that you don't want and shift the way that the org is structured and that could solve a lot of problems. That's what it did for you. Then I think it's also really interesting, there's this lesson here of as a founder, if you're just feeling depleted or just don't have the partner you want, you could bring someone on that could be that person.

**中文翻译:**
非常有趣。这里面信息量很大。我想分享两点，然后转到另一个话题。第一，帮助你跑得更快、做你想做的工作的解决方案竟然是“组织设计”，这很酷。这感觉是一件非常可行的事情。如果你发现自己没有把时间花在想花的地方，事情进展得不如预期快，本质上你可以找人接手你不想要的事情，并改变组织的结构，这能解决很多问题。这就是它对你的作用。第二，我觉得很有趣的一点是，这里有一个教训：作为创始人，如果你感到精疲力竭，或者身边没有你想要的伙伴，你可以找一个人来扮演那个角色。

---

### [00:30:50] Rahul Vohra

**English:**
Absolutely.

**中文翻译:**
完全正确。

---

### [00:30:52] Lenny Rachitsky

**English:**
Okay. There's so much there. That was much more of a rich area than I even expected. I want to zoom out a little bit, and there's a couple themes that came up again and again when I talked to folks that you've worked with, investors in Superhuman. The two themes are contrarian thinking, in terms of building the company, and strong attention to detail. Let's spend a little time on attention to detail. Like I said, this is one of the things that came up again and again when I was asking people about you. So I have this quote from Ed Sims, and maybe your first investor. Were they your first investor?

**中文翻译:**
好。内容太丰富了，超出了我的预期。我想稍微放大一下视角。当我与和你共事过的人以及 Superhuman 的投资者交谈时，有两个主题反复出现：一个是公司建设方面的“反向思维”（contrarian thinking），另一个是“对细节的高度关注”。让我们花点时间聊聊对细节的关注。正如我所说，这是我在向别人打听你时反复听到的。我这里有一段 Ed Sims 的话，他可能是你的第一位投资者。他是吗？

---

### [00:31:27] Rahul Vohra

**English:**
Yeah, that there's a bunch of people on Twitter who are going to fight for that. But to set the record straight, Ed Sim did actually write the first three checks into Superhuman.

**中文翻译:**
是的，推特上有一群人会为此争论不休。但为了澄清事实，Ed Sim 确实为 Superhuman 签下了前三张支票。

---

### [00:31:35] Lenny Rachitsky

**English:**
First three checks? At subsequent rounds.

**中文翻译:**
前三张支票？是在后续轮次吗？

---

### [00:31:38] Rahul Vohra

**English:**
Well, yeah. Quick sidebar on that, he runs Boldstart Ventures alongside his partner Elliot Durbin. They have a particular interest in backing second-time founders, but they'll also back first-time founders, and they love application and infrastructure areas like Superhuman, so we were like the perfect investment. He also wrote a check from his previous fund into a Rapportive, and I think I'd made him five X that money. Nothing to write home about, but definitely, "I'm going to back this guy again." So I went to him and I said, "Hey listen, this is going to sound crazy. I want to take on Gmail." He said, "Do you have a deck?" I was like, "Yeah, here it is one slide, here it is." And there was a screenshot of Gmail with most of it scribbled out, "I want to build that and it's going to be amazing."

**中文翻译:**
是的。顺便提一下，他和合伙人 Elliot Durbin 共同经营 Boldstart Ventures。他们特别喜欢支持连续创业者，但也支持首次创业者，而且他们热爱像 Superhuman 这样的应用和基础设施领域，所以我们简直是完美的投资对象。他之前的基金也给 Rapportive 投过钱，我想我让他赚了 5 倍。虽然不值得大肆宣扬，但绝对让他觉得“我要再次支持这家伙”。所以我去找他说：“嘿，听着，这听起来可能很疯狂。我想挑战 Gmail。”他说：“你有 PPT 吗？”我说：“有，就一页，给你。”那是一张 Gmail 的截图，大部分内容都被涂掉了，“我想做那个，它会很棒。”

(00:32:25):
**English:**
So he said, "Cool, we're in. Can I wire you the money?" And I said, "No, I don't even have a bank account yet." I come back two days later with a bank account and he's like, "Cool, I want to wire you 750 K." And I said, "I don't even know what I'm going to do with that money. I'm not paying myself, I won't for a while. We don't have any employees. I can't think of anything I want to spend it on. Tell you what, I'll just take 250 K." And he was like, "What?" I'm like, "Yeah, I'll just take 250 K." We start having the conversation around venture economics. I'm like, "Yeah, it's fine, we'll figure it out." Then a few months back I took another 250 K and a few months back I took another 250 K as I began inventing ways and finding channels to deploy capital properly.

**中文翻译:**
他说：“酷，我们加入了。我能给你汇款吗？”我说：“不行，我连银行账户都还没开。”两天后我带着银行账户回来，他说：“酷，我想给你汇 75 万美元。”我说：“我甚至不知道拿这笔钱干什么。我不给自己发工资，短时间内也不会发。我们没有员工。我想不出有什么要花钱的地方。这样吧，我只要 25 万。”他惊呆了：“什么？”我说：“对，我就拿 25 万。”我们开始讨论风险投资经济学，我说：“没事，我们会搞定的。”然后几个月后我又拿了 25 万，再过几个月又拿了 25 万，因为我开始想办法并寻找渠道来妥善部署这些资金。

---

### [00:33:11] Lenny Rachitsky

**English:**
I love this story. I love all these stories you're sharing I've never heard before. And by the way, it is awesome. We're talking about him coming on the podcast, maybe breaking our VC rule. So specifically the story he shared with me that is maybe an example of you and your attention to detail is, he said that you created your own font because existing fonts weren't good enough. Is that true?

**中文翻译:**
我喜欢这个故事。我喜欢你分享的所有这些我从未听过的故事。顺便说一下，这太棒了。我们正在讨论让他上播客的事，也许会打破我们不请 VC 的规则。具体来说，他跟我分享的一个关于你关注细节的例子是：他说你创造了自己的字体，因为现有的字体都不够好。是真的吗？

---

### [00:33:31] Rahul Vohra

**English:**
Kind of. Okay. The font that we use today is a modified version of Adelle Sans. The story there is, I looked at all of the major font families, and honestly none of them was what I would call truly excellent. That may sound like an odd thing to say. So let's, if you will permit me to talk about typography and email-

**中文翻译:**
算是吧。我们今天使用的字体是 Adelle Sans 的修改版。故事是这样的：我查看了所有主要的字体族，老实说，没有一个是我认为真正优秀的。这听起来可能有点奇怪。所以，如果你允许我谈谈排版和电子邮件的话——

---

### [00:33:55] Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:33:56] Rahul Vohra

**English:**
The first thing we did was, we took our UI and we laid it out in about 15 different styles using examples of the major font families. We actually printed these out and we left them on a desk in the middle of our office. Sometimes with design, you want to tune in to your immediate most visceral response, but sometimes you want to truly let a design marinate. And this was the latter. So we let these designs marinate, we let these font choices percolate. Like I said, none of them was truly excellent.

**中文翻译:**
我们做的第一件事是，把我们的 UI 用大约 15 种不同的主要字体族样式排列出来。我们把这些打印出来，放在办公室中间的一张桌子上。在设计中，有时你想要捕捉最直接、最本能的反应，但有时你想要让设计真正地“腌制”一段时间。这次属于后者。所以我们让这些设计沉淀，让这些字体选择发酵。就像我说的，没有一个是真正优秀的。

(00:34:31):
**English:**
Number one, I was looking for a font that was in and of itself gorgeous. Number two, I was looking for a font that could also convey a message of any kind, without overpowering the sentiment of that message. For example, does the font work when this is inviting you to a party? Many fonts, including almost all serif fonts, are actually too somber or too sober for that. Or to pick another extreme, does the font work if it is informing you of somebody's passing, many fonts are just too jaunty for that. You wouldn't want that kind of message in Comic Sans, for example. And number three, I was optimizing for a font that made reading speed and comprehension really fast. And number four, I was looking for a font that made email addresses themselves look great. So I discarded all the 15 because they weren't good enough, and after searching high and low, I came across a font called Adelle Sans, which is designed by a foundry called Type Together, type-together.com. They have a whole bunch of lovely fonts, go check them out.

**中文翻译:**
第一，我在寻找一种本身就很华丽的字体。第二，我在寻找一种能够传达任何类型的信息，同时又不会压过信息本身情感的字体。例如，当这封信是邀请你参加派对时，这种字体适用吗？许多字体，包括几乎所有的衬线字体（serif fonts），对于这种场合来说都太沉闷或太严肃了。或者举另一个极端的例子，如果它是通知某人去世的消息，这种字体适用吗？许多字体又太活泼了。你肯定不想用 Comic Sans 字体来发这种消息。第三，我正在优化一种能让阅读速度和理解速度变得非常快的字体。第四，我在寻找一种能让电子邮件地址本身看起来很棒的字体。所以我放弃了那 15 种，因为它们不够好。在四处寻找之后，我发现了一种叫 Adelle Sans 的字体，它是由一家叫 Type Together (type-together.com) 的字体公司设计的。他们有很多可爱的字体，大家可以去看看。

(00:35:36):
**English:**
And if you go through my list, number one, Adelle Sans is gorgeous. I think each character is a work of art. It's beautifully formed. Number two, Adelle Sans is, I would say upbeat, it's optimistic, yet it's serious enough to convey any kind of message. It has just the right amount of personality, yet not too much personality. Number three, Adelle Sans is also unusually narrow, and that actually fits email particularly well. One of my pet peeves with Gmail, which by default uses Arial, is that the lines are as wide as your window. So if you're in a wide screen, then the lines get really arbitrarily long. The problem with really wide and really long lines, is that they decrease reading speed. Because by the time you've reached the end of one line, your eyes have lost track of the start of the next line. And Arial itself has fairly wide characters, which further exacerbates that.

**中文翻译:**
如果你对照我的清单：第一，Adelle Sans 非常漂亮。我觉得每个字符都是一件艺术品，造型优美。第二，Adelle Sans 给人感觉很积极、乐观，但又足够严肃，可以传达任何信息。它的个性恰到好处，又不会太张扬。第三，Adelle Sans 也异常狭窄，这其实特别适合电子邮件。我对 Gmail（默认使用 Arial 字体）的一个不满是，它的行宽和你的窗口一样宽。所以如果你用宽屏，行就会变得特别长。宽而长的行的问题在于它们会降低阅读速度。因为当你读到一行的末尾时，你的眼睛已经找不到下一行的开头了。而 Arial 本身的字符就比较宽，这进一步加剧了问题。

(00:36:30):
**English:**
So at Superhuman we, if you've used the product, you know this, we fix the line length or the typographical measure to the optimal length for reading speed, which depending on the font is around 90 to 120 characters. And Adelle Sans is quite narrow, so it actually lets us do this on quite small windows with fairly dense line. So we get a lot of information on fairly small windows without getting a very long typographical measure, optimizing for reading speed and for comprehension. Then number four, finally Adelle Sans has very unusual treatment of the at symbol in an email address. It actually puts the base of the A in the at on the same baseline as the rest of the text.

**中文翻译:**
所以在 Superhuman，如果你用过我们的产品，你就会知道，我们将行长或排版宽度固定在最适合阅读速度的长度上，根据字体的不同，大约在 90 到 120 个字符之间。Adelle Sans 非常窄，所以它能让我们在相当小的窗口内以较密的行距实现这一点。这样我们就能在较小的窗口内获得大量信息，而不会出现过长的排版宽度，从而优化了阅读速度和理解力。最后第四点，Adelle Sans 对电子邮件地址中的 @ 符号有非常独特的处理。它实际上把 @ 符号中 'a' 的底部放在了与其他文本相同的基准线（baseline）上。

(00:37:15):
**English:**
So for example, if your name has an A, my name does Rahul at Vohra, three A's and or two A's and an at, they're all actually on the same baseline. It's a small thing, but it makes the email addresses look incredibly natural. If you look at that and then you actually look at email addresses laid out in other fonts, those other the fonts look really clunky and awkward because the A is kind of shifted around and it just looks a bit silly in my opinion. Now Adelle Sans isn't perfect. So we then worked with a type designer on some of the specific details that there are some of the glyphs, which get a little pinchy as it were, and what we use today is very close to retail Adelle Sans.

**中文翻译:**
例如，如果你的名字里有 A，我的名字 Rahul at Vohra 里有三个 A（或两个 A 和一个 @），它们实际上都在同一条基准线上。这是一件小事，但它让电子邮件地址看起来非常自然。如果你对比一下其他字体的电子邮件地址，你会发现其他字体看起来非常笨拙和尴尬，因为那个 'a' 总是错位的，在我看来有点滑稽。当然，Adelle Sans 并不完美。所以我们后来和一位字体设计师合作，调整了一些具体的细节，比如一些字形（glyphs）有点过于紧凑。我们今天使用的版本非常接近市售的 Adelle Sans。

---

### [00:37:55] Lenny Rachitsky

**English:**
And this was pre-launch or this was after you'd already launched?

**中文翻译:**
这是在发布前，还是在你们已经发布之后？

---

### [00:37:58] Rahul Vohra

**English:**
We'd probably had about 10, 15 users at the time.

**中文翻译:**
当时我们大概只有 10 到 15 个用户。

---

### [00:38:03] Lenny Rachitsky

**English:**
So I think that's pretty contrarian unique to be this focused on the font and the typeface before you even launched. This was like, "Is this even going to be a thing? Will anyone even care?" And I think this says a lot about the way you think about product.

**中文翻译:**
我觉得在发布之前就如此关注字体和字形，是非常反传统且独特的。当时你有没有想过：“这到底行不行？会有人在乎吗？”我觉得这很能说明你思考产品的方式。

---

### [00:38:17] Rahul Vohra

**English:**
Oh yeah, that thought never crossed my mind. I think we'll probably come to it later, but the idea that, is this never going to be a thing? I think that's a dangerous thought. We can't start thinking that way, because at what point do you stop second-guessing yourself?

**中文翻译:**
噢，我从来没产生过那种念头。我想我们稍后可能会谈到，但那种“这会不会根本行不通”的想法，我认为是很危险的。我们不能那样思考，因为那样的话，你什么时候才会停止自我怀疑呢？

---

### [00:38:35] Lenny Rachitsky

**English:**
Interesting. So you were confident this was going to work, so because I am so confident it'll work, I need them to get this right. There's also this trap founders fall into of just spending too much time perfecting a thing that never works and there's always advice launch early, launch often. Thoughts there? How do you find that balance? What's your advice there?

**中文翻译:**
有趣。所以你确信这会成功，正因为确信，所以你要求必须把细节做对。但创始人也容易掉进一个陷阱，就是花太多时间去完善一个永远不会成功的东西，而且总有人建议“尽早发布，频繁发布”。你对此怎么看？你如何找到平衡？有什么建议吗？

---

### [00:38:57] Rahul Vohra

**English:**
How much to spend time ahead of launch really does depend on the markets and the structure, the nature of your business model. For example, let's say you are building a marketplace in a greenfield opportunity, so imagine the Lyft or Uber in their heyday. There's a strong network effect, because the more cars you have on your platform, the shorter waiting times are, therefore people are going to preferentially use your app versus the other person's app. That's when there's no time to spare, that's when you probably shouldn't even be sleeping. You're going to hire the most aggressive maniacal people possible. You're going to work 120-hour weeks, because every marginal minute actually does matter. Every marginal minute in the market, growing compounding is going to make your next year even better.

**中文翻译:**
在发布前花多少时间，确实取决于市场、结构以及你商业模式的性质。例如，假设你是在一个空白市场（greenfield opportunity）建立一个双边市场，想象一下鼎盛时期的 Lyft 或 Uber。那里有很强的网络效应，因为平台上的车越多，等待时间就越短，因此人们会优先使用你的应用而不是别人的。那种时候分秒必争，你甚至不应该睡觉。你会雇佣最激进、最疯狂的人。你会每周工作 120 小时，因为每一分钟都很重要。在市场上增长和复利的每一分钟都会让你的明年变得更好。

(00:39:51):
**English:**
That's actually not true of all startups and it certainly isn't true of something like Superhuman. Yes, working harder is always better and we work tremendously hard at Superhuman, but not to the point where it made sense to release something that didn't work. I'm reminded of a story of a founder that was in Y Combinator, told me about their demo day experience. They used Mailbox, which some folks may remember was also a startup, and Dropbox famously acquired them for about a hundred million dollars. The reason that they were well known, apart from the acquisition, is they were the first to popularize, swipe to archive or swipe to mark down, which of course is now standard in Superhuman and every other app.

**中文翻译:**
但这并不适用于所有初创公司，肯定也不适用于 Superhuman 这样的产品。是的，努力工作总是好的，我们在 Superhuman 也非常努力，但还没到发布一个不能用的东西的地步。我想起了一个在 Y Combinator 的创始人的故事，他告诉我他的 Demo Day 经历。他们当时用 Mailbox，有些人可能记得那也是一家初创公司，后来被 Dropbox 以 1 亿美元收购。除了收购，他们出名的原因还在于他们最早普及了“滑动归档”或“滑动标记”，这现在已经是 Superhuman 和所有其他应用的标配了。

(00:40:43):
**English:**
This founder was using Mailbox and was having an amazing demo day. They're working the room, they're meeting investors, they're pitching their photography app in this case. He went home that night and went to his laptop, fired up mailbox and sent off a bunch of follow-up emails. He waited the day, didn't hear back, he waited two days, didn't hear back. On the third morning he figured something was up, so he fired up Gmail, went to his sent mail, and you guessed it, there were no sent mails there. So something had broken with mailbox. So he's cursing to himself trying to remind himself everything's going to be okay. Sent all the same emails from Gmail manually and they all came through.

**中文翻译:**
这位创始人当时用 Mailbox，Demo Day 表现得非常棒。他在场内穿梭，会见投资者，推销他的摄影应用。那天晚上他回到家，打开笔记本电脑，启动 Mailbox 发送了一堆跟进邮件。他等了一天，没回音；等了两天，还是没回音。第三天早上他觉得不对劲，于是打开 Gmail，查看已发送邮件——你猜对了，里面一封邮件都没有。Mailbox 出故障了。他一边咒骂一边安慰自己一切都会好起来的。他手动从 Gmail 重新发送了所有邮件，这次都成功了。

(00:41:37):
**English:**
But then one of the investors said, "Hey, by the way, you might want to check your email clients, because I've been getting some of your emails twice." Now he goes back into his Gmail, he sees that yes, actually the original emails that were queued up in mailbox have now indeed been sent, and some of the investors, and unfortunately most of the investors he actually pitched twice. Now, is this the end of the world? No, an investor can overlook that. Probably a good thing that you're trying new apps. But was it horrifying and was it really scary? Absolutely.

**中文翻译:**
但接着一位投资者说：“嘿，顺便说一下，你可能想检查一下你的邮件客户端，因为我收到了一些重复的邮件。”现在他回到 Gmail，发现是的，原来在 Mailbox 里排队的邮件确实发出了，不幸的是，他实际上向大多数投资者推销了两次。这是世界末日吗？不是，投资者可以原谅这一点，甚至觉得你尝试新应用是件好事。但这件事恐怖吗？吓人吗？绝对是。

(00:42:08):
**English:**
Imagine this wasn't investors, imagine this was a customer, someone who you were trying to convince to buy your thing and that you knew what you were doing and you had attention to detail and you had everything just buttoned up and under control. Well, now you've lost face, now you look foolish. That's why when you have mission-critical products like email where you are interfacing with customers, with candidates, with investors, it turns out to really matter. Email is mission-critical. It's not something where you can simply launch with a half-baked product.

**中文翻译:**
想象一下，如果对方不是投资者，而是客户呢？是你试图说服对方购买你的产品，并展示你很专业、关注细节、一切尽在掌控的人。那么，现在你丢脸了，看起来很蠢。这就是为什么当你拥有像电子邮件这样需要对接客户、候选人、投资者的关键任务产品（mission-critical products）时，细节真的很重要。电子邮件是关键任务，你不能只发布一个半成品。

---

### [00:42:40] Lenny Rachitsky

**English:**
This is such an important nuance take on, there's always this debate, how much to focus on craft and user experience, how much to focus on time to launch and get it out and speed. What I'm hearing here, which I completely agree with is, it depends on the market you're in and the criticality essentially of your product. So if it's email, it just needs to work and you need to get that right, you need to spend all the time, you need to get that right.

**中文翻译:**
这是一个非常重要的细微差别。总有这样的争论：应该花多少精力在工艺和用户体验上，花多少精力在发布时间和速度上。我在这里听到的是——我也完全同意——这取决于你所处的市场以及你产品的关键程度。如果是电子邮件，它必须能用，你必须把它做对，你必须花所有的时间把它做对。

(00:43:03):
**English:**
This reminds me of something else that when your early investors shared with me, Bill Trenchard from First-Round Capital. He talked about how speed was the thing that you just dialed up as a lever to 11. That's where you just, "We will make this the focus. Speed, speed, speed." I think maybe the lesson there is, you pick the thing that you think will most differentiate you, make you significantly better than what's out there. So just thoughts on how you decided speed was the thing you were going to obsess with, and advice for folks that are trying to decide where to dial up things to 11?

**中文翻译:**
这让我想起了你的早期投资者之一，来自 First Round Capital 的 Bill Trenchard 跟我分享的一件事。他说“速度”是你调到最高档（lever to 11）的那个杠杆。你当时就决定：“我们要以此为核心。速度，速度，还是速度。”我想这里的教训可能是：你选择那个你认为最能让你与众不同、让你显著优于现有产品的东西。那么，你是如何决定要痴迷于“速度”的？对于那些正在决定要把什么东西调到最高档的人，你有什么建议？

---

### [00:43:37] Rahul Vohra

**English:**
Bill is right and I agree with him, you have to pick something. Knowing what to pick is the trick. In the early days of Superhuman, I read a book on positioning that really influenced my thinking. It is, I believe called Positioning the Battle for Your Mind. It struck me how the most well-known brands have stood for one clear thing, they have a clear position. So in order for Superhuman to be memorable, I believed that we needed to occupy a clear position that was unique and which was available and which reinforced our product strategy.

**中文翻译:**
Bill 是对的，我也同意他的看法，你必须选择一个点。诀窍在于知道选什么。在 Superhuman 的早期，我读了一本关于定位的书，对我影响很大，我想是叫《定位：争夺用户心智》（Positioning: The Battle for Your Mind）。我被那些最著名的品牌如何代表一件清晰的事情所震撼，它们都有清晰的定位。所以为了让 Superhuman 令人难忘，我认为我们需要占据一个独特的、尚未被占领的、且能强化我们产品战略的清晰定位。

(00:44:12):
**English:**
In the first year of Superhuman, therefore, I interviewed hundreds of potential customers about their experience with Gmail and with Outlook. And predictably, almost everybody says that email takes way too much time. But interestingly, many people also said that Gmail and Outlook were way too slow. That was how I first thought that speed could be an interesting position for us. I then asked myself, "Is the position of speed unique and is it available?" And the answer was overwhelmingly yes, because almost no software was being sold or has ever been sold on the value proposition of speed. The last time I could remember anyone trying to do this, was when Google launched Chrome, and obviously that went incredibly well for them. You may remember they had slow-motion videos where they were comparing Chrome render webpages and showing that was faster than an actual strike of lightning. No one had done it since then.

**中文翻译:**
因此，在 Superhuman 的第一年，我采访了数百名潜在客户，询问他们使用 Gmail 和 Outlook 的体验。不出所料，几乎所有人都说处理邮件太费时间了。但有趣的是，很多人还提到 Gmail 和 Outlook 运行太慢了。这就是我第一次想到“速度”可以成为我们一个有趣的定位。然后我问自己：“速度这个定位是独特的吗？它是可用的吗？”答案是肯定的，因为几乎没有软件是基于“速度”这一价值主张来销售的。我能记得的上一个尝试这样做的是谷歌发布 Chrome 的时候，显然那对他们来说非常成功。你可能还记得他们拍过慢动作视频，对比 Chrome 渲染网页的速度比闪电还快。从那以后就没人这么做了。

(00:45:15):
**English:**
I then asked, "Well, does speed reinforce our product strategy?" And again, the answer was overwhelmingly yes. I knew that our competition was not going to be startups, it was incumbents. And I also knew that incumbents generally struggle with speed, because by definition they have massive scale and usually entrenched architecture. Then finally I did what I call the cocktail party test, which is to look at the cocktail parties and to watch how people pitch your product to other people. In our case the pitches were simple. People would say, "Dude, you have to use it, it's really fucking fast." And that's it. That was the pitch. That's how I knew that speed would be a really great position for us to start with.

**中文翻译:**
接着我问：“速度能强化我们的产品战略吗？”答案再次是肯定的。我知道我们的竞争对手不是初创公司，而是现有的巨头。我也知道巨头通常在速度上很挣扎，因为从定义上讲，他们规模巨大，且通常架构陈旧。最后，我做了我称之为“鸡尾酒会测试”的实验，就是观察在酒会上人们如何向别人推销你的产品。在我们的案例中，推销词很简单。人们会说：“哥们，你一定要用这个，它真的快得离谱。”就这样，这就是推销词。这就是我如何确定“速度”对我们来说是一个非常棒的切入点。

---

### [00:46:01] Ad Segment (OneSchema)

**English:**
I'm excited to chat with Christina Gilbert, the founder of OneSchema, one of our longtime podcast sponsors. Hi Christina.

**中文翻译:**
很高兴能与 OneSchema 的创始人 Christina Gilbert 交流，OneSchema 是我们播客的长期赞助商之一。你好，Christina。

(00:46:08):
**Christina Gilbert:**
Yes, thank you for having me on, Lenny.

**中文翻译:**
是的，谢谢你邀请我，Lenny。

(00:46:10):
**Lenny Rachitsky:**
What is the latest with OneSchema? I know you now work with some of my favorite companies like Ramp, Vanta, Scale and Watershed. I heard that you just launched a new product to help product teams import CSVs from especially tricky systems like ERPs.

**中文翻译:**
OneSchema 最近有什么新动态？我知道你们现在和一些我非常喜欢的公司合作，比如 Ramp、Vanta、Scale 和 Watershed。我听说你们刚刚发布了一个新产品，帮助产品团队从 ERP 等特别棘手的系统中导入 CSV 文件。

(00:46:24):
**Christina Gilbert:**
Yes, so we just launched OneSchema FileFeeds, which allows you to build an integration with any system in 15 minutes, as long as you can export a CSV to an SFTP folder. We see our customers all the time getting stuck with hacks and workarounds, and the product teams that we work with don't have to turn down prospects because their systems are too hard to integrate with. We allow our customers to offer thousands of integrations without involving their engineering team at all.

**中文翻译:**
是的，我们刚刚推出了 OneSchema FileFeeds，只要你能将 CSV 导出到 SFTP 文件夹，它就能让你在 15 分钟内建立与任何系统的集成。我们经常看到客户被各种临时方案和变通方法困扰，而与我们合作的产品团队不必因为系统太难集成而拒绝潜在客户。我们让客户能够提供成千上万种集成，而完全不需要工程团队参与。

(00:46:47):
**Lenny Rachitsky:**
I can tell you that if my team had to build integrations like this, how nice would it be to be able to take this off my roadmap and instead use something like OneSchema. Not just to build it but also to maintain it forever.

**中文翻译:**
我可以告诉你，如果我的团队必须构建这样的集成，能把它从我的路线图中拿掉，转而使用 OneSchema 这样的工具该有多好。不仅是构建，还有永久的维护。

(00:46:59):
**Christina Gilbert:**
Absolutely, Lenny. We've heard so many horror stories of multi-day outages from even just a handful of bad records. We are laser focused on integration reliability to help teams end all of those distractions that come up with integrations. We have a built-in validation layer that stops any bad data from entering your system and OneSchema will notify your team immediately of any data that looks incorrect.

**中文翻译:**
绝对如此，Lenny。我们听过太多因为几条错误记录就导致持续数天停机的惨痛故事。我们专注于集成的可靠性，帮助团队消除集成带来的所有干扰。我们有一个内置的验证层，可以阻止任何错误数据进入你的系统，OneSchema 会立即通知你的团队任何看起来不正确的数据。

(00:47:19):
**Lenny Rachitsky:**
I know that importing incorrect data can cause all kinds of pain for your customers and quickly lose their trust. Christina, thank you for joining us and if you want to learn more, head on over to OneSchema.co. That's OneSchema.co.

**中文翻译:**
我知道导入错误数据会给客户带来各种痛苦，并迅速失去他们的信任。Christina，谢谢你加入我们。如果你想了解更多，请访问 OneSchema.co。

---

### [00:47:33] Lenny Rachitsky

**English:**
The next area I want to spend time on and I imagine we'll have much insight is, some of the contrarian ways you approach building Superhuman that a lot of companies never thought about doing that you did that worked out for you. So the first is manually onboarding every single new user. Sure, startups have done this, founders bring on some folks and then cool, show it to them and then they stop doing that and then it's self-service or sales teams. How far did you scale this manual onboarding phase of your company? How many people did you have onboarding people, how many people did you manually onboard?

**中文翻译:**
我想聊的下一个领域是——我想你会有很多见解——就是你构建 Superhuman 的一些反传统方式，很多公司从未想过这样做，但你做了且成功了。首先是“人工引导（manually onboarding）每一位新用户”。当然，初创公司都做过这个，创始人拉来一些人，演示给他们看，然后就停止了，转而采用自助服务或销售团队。你们的人工引导阶段规模有多大？有多少人在负责引导，你们一共人工引导了多少人？

---

### [00:48:12] Rahul Vohra

**English:**
So for folks that don't know, in those early days we insisted on one-to-one concierge onboarding, and it was absolutely the right thing to do. You couldn't use Superhuman unless you went through the onboarding experience. Now it's almost the reverse. Almost every new Superhuman customer goes through self-service. The onboarding experience is still there, but again it is absolutely the right thing to do. To answer your question, at peak we had about 20 people doing manual onboarding.

**中文翻译:**
对于不了解的人，在早期我们坚持进行一对一的“管家式”引导，这绝对是正确的决定。除非你完成了引导体验，否则你无法使用 Superhuman。现在几乎反过来了，几乎每个新的 Superhuman 客户都通过自助服务加入。引导体验依然存在，但再次强调，当时的做法绝对是正确的。回答你的问题，在巅峰时期，我们大约有 20 个人在做人工引导。

---

### [00:48:40] Lenny Rachitsky

**English:**
Okay, so it's not that many people. That's really interesting. Because I always imagined it was like a massive team, but 20 people can handle a lot, is the takeaway there. What was the scale where you stopped manual onboarding, just for folks that are thinking about doing this and then when to stop?

**中文翻译:**
好吧，人其实并不多。这很有趣。因为我一直以为是一个庞大的团队，但 20 个人其实能处理很多事情，这是个收获。对于那些考虑这样做的人，你们是在什么规模时停止人工引导的？什么时候该停止？

---

### [00:48:55] Rahul Vohra

**English:**
I think the reason to stop is that there will always be certain personality types who do not want to go through a one-on-one onboarding. At a certain point those people will become very important, and you'll need to be ready with a world-class self-service option. When we started building self-service, it seemed nearly impossible. In fact, it was terrifying, because it's difficult to overstate how much the entire DNA of the company was built around this idea that we would onboard users manually. After all, we did so much in our one-to-one onboardings and there's only so much that software can do. Now, we did after a lot of grind and persistence eventually figure it out and we have a world-class self-service experience today, but we did not at the time.

**中文翻译:**
我认为停止的原因是，总会有某些性格类型的人不想进行一对一的引导。到了一定阶段，这些人会变得非常重要，你需要准备好世界级的自助服务选项。当我们开始构建自助服务时，感觉几乎是不可能的。事实上，这很可怕，因为很难形容公司的整个 DNA 是如何围绕“人工引导用户”这一理念建立的。毕竟，我们在的一对一引导中做了那么多事，而软件能做的有限。经过大量的磨练和坚持，我们最终解决了这个问题，现在拥有了世界级的自助服务体验，但当时并没有。

(00:49:49):
**English:**
So the flip side is, why would you even do this to begin with? What we found is two things. Number one, the user metrics are excellent for things like engagement, retention, product market fit score, MPS, virality, for all of those metrics. I think you you'll significantly beat your industry benchmarks if you go to the effort of one-on-one onboarding your early customers. It becomes so powerful to have that early cohort of super fans when it comes to things like building a brand. If folks remember that conversation from way up at the top, what is it that creates true virality? It's not viral mechanics, it's word of mouth. It is brand. This is how you can kickstart a brand.

**中文翻译:**
反过来说，为什么一开始要这样做呢？我们发现了两点：第一，用户指标在参与度、留存率、产品市场契合度得分、NPS、病毒性等方面都非常出色。如果你愿意花精力对早期客户进行一对一引导，我认为你会显著超过行业基准。在建立品牌方面，拥有那批早期的超级粉丝是非常强大的。如果大家还记得我们开头聊的内容，什么是真正的病毒式增长？不是病毒机制，是口碑，是品牌。这就是你启动品牌的方式。

(00:50:32):
**English:**
And number two, in a world where you can easily and quickly raise funding, like for example the zero interest rate phenomenon era, you can actually use dollars to avoid building a first-time user experience and all of the normal growth loops that you would then have to build. You would then instead focus all of your engineers on finding product market fit or in solution deepening or in market widening, but not for example on a first-time user experience, not for example on activation, because you have humans doing activation for you. By contrast I saw other companies often competing spend almost half their engineering dollars on those things, on self-service flows for products that ultimately did not find products market fit. So makes sense to do if you really want to create that brand, which I think all consumer-ish companies need to do. And if there is money falling off trees, for whatever reason, which we did have for a period of time, arguably AI companies have that again today. So if you can weave this into your strategy, I think you should, but you should also know when to stop.

**中文翻译:**
第二，在一个融资容易且迅速的环境下（比如零利率时代），你实际上可以用资金来避免构建“首次用户体验”和所有常规的增长循环。你可以让所有工程师专注于寻找产品市场契合度、方案深化或市场拓宽，而不是花精力在首次用户体验或激活（activation）上，因为有人工在帮你做激活。相比之下，我看到其他竞争公司往往把近一半的工程经费花在这些事情上——为那些最终没能找到 PMF 的产品构建自助服务流程。所以，如果你真的想建立品牌（我认为所有消费级公司都需要这样做），而且资金充裕（不管出于什么原因，我们确实经历过那段时期，现在的 AI 公司可能也是如此），那么这样做是有意义的。你可以把它融入你的战略，但也得知道什么时候该停。

---

### [00:51:40] Lenny Rachitsky

**English:**
Super interesting. I guess some factors to think about, because I wanted to ask you when should people consider doing this? If they're hearing this and they're like, "This is awesome, so many problems solved if I just have somebody onboarding every new user, everyone's activated. Amazing." So some of the variables you're sharing is, do you have like cheap cash to invest in say, it doesn't have to be 20 people, it could be a few people to start. Then if there's an LTV, ACV element of just are you going to make enough from a new customer? Imagine that's a variable. Is there anything else you think founders should think about?

**中文翻译:**
非常有趣。我想总结一些需要考虑的因素，因为我想问你人们什么时候该考虑这样做？如果有人听到这里觉得：“太棒了，如果我让人引导每个新用户，所有人都能被激活，问题全解决了。”你分享的一些变量包括：你是否有廉价的资金来投入（不一定要 20 人，几个人开始也行）；然后是 LTV（终身价值）或 ACV（年度合同价值）的因素，即你是否能从新客户身上赚到足够的钱？我想这是一个变量。你觉得创始人还应该考虑什么？

---

### [00:52:14] Rahul Vohra

**English:**
Absolutely. You don't want to lose money doing this. We always made money doing onboarding to be clear, it's just that at a certain point the mass market, whether it for us it's enterprise or all of the prosumers in the world, you hit a top of funnel width, it needs to be wide enough where manually onboarding no longer makes sense.

**中文翻译:**
当然。你不想在做这件事时亏钱。明确地说，我们做引导一直是赚钱的。只是到了一定阶段，面对大众市场（无论是对我们而言的企业客户还是全球的专业消费者），当你的漏斗顶部变得足够宽时，人工引导就不再合理了。

---

### [00:52:37] Lenny Rachitsky

**English:**
Awesome. Let's talk about product market fit. I know that everyone, when they think of Rahul, they think product market fit. You wrote this epic First Round post that described the way you guys approach product market fit. We're not going to spend a lot of time on describing it, because people can look it up. So let me just ask you this, what are a couple of things that you think people still don't understand about finding product market fit, getting to product market fit? Considering it's the most important thing you got to figure out as a founder. If you don't find something people want, nothing else matters. Anything there you want to share.

**中文翻译:**
太棒了。让我们聊聊产品市场契合度（PMF）。我知道大家一想到 Rahul，就会想到 PMF。你在 First Round 上写过那篇史诗级的文章，描述了你们寻找 PMF 的方法。我们不打算花太多时间去描述它，因为大家可以自己查。所以我只想问：关于寻找 PMF 或达到 PMF，你认为人们还有哪些误解？考虑到这是创始人必须解决的最重要的事情——如果你没做出人们想要的东西，其他一切都不重要。有什么想分享的吗？

---

### [00:53:12] Rahul Vohra

**English:**
The core ideas are still weird enough that I'll start there. Which is number one, you can measure product market fit. Number two, you can optimize product market fit. Number three, you can systematically, even numerically increase product market fit. And number four, you can even have an algorithm write your roadmap for you, and that is a roadmap that is guaranteed to increase product market fit. Now, if that sounds crazy, I would be the first to admit it doesn't seem like that should be true, but go check out that post. I think it is still the most widely shared post on First Round Review, it's called How Superhuman Built an Engine to Find Product Market Fit, or just Google the Superhuman Product Market Fit Engine. And you'll see the algorithm laid out there fully explained and why it works.

**中文翻译:**
核心理念依然足够“古怪”，我就从那里开始。第一，PMF 是可以衡量的。第二，PMF 是可以优化的。第三，你可以系统地、甚至通过数值来提高 PMF。第四，你甚至可以让算法为你编写路线图，而且这个路线图保证能提高 PMF。现在，如果这听起来很疯狂，我第一个承认这看起来不像是真的，但去看看那篇文章吧。我想它仍然是 First Round Review 上分享最广的文章，标题是《Superhuman 如何构建寻找 PMF 的引擎》，或者直接搜“Superhuman PMF Engine”。你会看到那里详细解释了算法及其原理。

(00:54:07):
**English:**
I'd say the second thing is to get to product market fit, you have to deliberately not act on the feedback of many of your early users. This is at the same time as listening to people intensely and building what people want. That's what we're here to do, is to make something that people want. But it can't be all people. It can't be everybody. The question becomes, how do you listen to them? And then even of what they say, what do you pay attention to and what don't you? All of that's covered in the Product Market Fit Engine.

**中文翻译:**
我想说的第二点是，为了达到 PMF，你必须刻意地不去采纳许多早期用户的反馈。与此同时，你又要极度认真地倾听人们的声音，并打造人们想要的东西。我们在这里要做的就是做出人们想要的东西。但这个“人们”不能是所有人。问题变成了：你如何倾听他们？即使在他们所说的话中，哪些是你需要关注的，哪些又是可以忽略的？所有这些都在“PMF 引擎”中涵盖了。

---

### [00:54:45] Lenny Rachitsky

**English:**
Okay, I got to follow this thought on algorithmically building your roadmap to increase product market fit. Talk about how one would do that.

**中文翻译:**
好，我得追问一下关于“通过算法构建路线图以提高 PMF”的想法。谈谈具体该怎么做。

---

### [00:54:55] Rahul Vohra

**English:**
Well, that's really the meat of the engine. Let's see if I can condense it here in a very easy to grok fashion. Let's assume for the sake of argument, that you can put a number on product market fit, and it turns out you can. Very simply, you're going to ask people, "How would you feel if you can no longer use this product?" You give them three responses. One of them is very disappointed, the other is somewhat disappointed, and the other is not disappointed. Very disappointed means, "I'd be devastated. I love this product. I need this product."

**中文翻译:**
这正是引擎的核心。我试着用一种非常容易理解的方式来浓缩一下。假设我们可以给 PMF 定一个数值，事实证明是可以的。很简单，你问用户：“如果你不能再使用这个产品，你会有什么感觉？”你给他们三个选项：1. 非常失望；2. 有点失望；3. 不失望。“非常失望”意味着：“我会崩溃。我爱这个产品，我需要它。”

(00:56:03):
**English:**
What Sean Ellis found, Sean Ellis, if you don't know him, is the guy who coined the term growth hacker, and he instrumented, benchmarked this initial question. What he found, is that the companies that struggled to grow almost always had less than 40%, very disappointed. Whereas the companies that grew the fastest almost always had more than 40%, very disappointed. And this question, this metric is way more predictive of success than something, for example, like net promoter score.

**中文翻译:**
Sean Ellis（如果你不认识他，他是“增长黑客”一词的发明者）对这个初始问题进行了工具化和基准测试。他发现，那些增长困难的公司，“非常失望”的比例几乎总是低于 40%。而那些增长最快的公司，“非常失望”的比例几乎总是高于 40%。这个问题和这个指标对成功的预测能力，远高于像 NPS（净推荐值）之类的指标。

(00:56:30):
**English:**
Okay, so far so easy. How do we make this number go up? Well, you want more people to be very disappointed without your product. The trick here is not to act too much on the feedback that the very disappointed people are giving you, because they already love your product. Also, not to act at all really on the feedback that the not disappointed people are giving, you because they're so far from loving your product that they're essentially a lost cause. But to focus on the segment of the somewhat disappointed people, they kind of love your product, but something, and I would wager something small, is holding them back.

**中文翻译:**
好，到目前为止都很简单。我们如何让这个数字上升？你需要更多的人在没有你的产品时感到“非常失望”。这里的诀窍是：不要过多地采纳那些“非常失望”的人给你的反馈，因为他们已经爱上你的产品了。同时，完全不要理会那些“不失望”的人的反馈，因为他们离爱上你的产品太远了，基本上是无可救药。你应该关注的是“有点失望”的那部分人——他们有点喜欢你的产品，但有些东西（我敢打赌是一些小东西）阻碍了他们。

(00:56:43):
**English:**
You then divide them into two camps, the camp for whom the main benefit of your product resonates and the camp for whom it doesn't. What do I mean by that? Well, you go back to the people who really love your product and you basically ask them why? What is it about my products that you really love? In the early days of Superhuman, it would have been speed and keyboard shortcuts and the overall design aesthetic as well as the time that we were saving you. You then go back to the somewhat disappointed users, and in the Superhuman example, I would simply ask, "Wait, do you like Superhuman because of its speed or for something else?" And if it's something else, well, and this is hard to do, but politely disregard those people and their feedback. Because even if you built everything that they asked for, they're still pulling you in a different direction. And the thing that they like the most from your product isn't actually what the people who en mass love it the most for, is.

**中文翻译:**
然后你把他们分成两个阵营：一个是对你产品核心价值产生共鸣的阵营，另一个则没有。这是什么意思？你回到那些真正爱你的产品的人那里，问他们：为什么？你到底喜欢我产品的哪一点？在 Superhuman 的早期，答案是速度、快捷键、整体设计美感以及我们为你节省的时间。然后你回到那些“有点失望”的用户那里，在 Superhuman 的例子中，我会问：“等等，你喜欢 Superhuman 是因为它的速度，还是因为别的？”如果是别的，那么——虽然这很难做到——请礼貌地忽略这些人及其反馈。因为即使你按照他们的要求做了一切，他们仍然在把你拉向不同的方向。而且他们最喜欢你产品的地方，其实并不是那些大众最爱它的地方。

(00:57:38):
**English:**
You have then articulated the subsegment of the subsegment that it makes sense to pay attention to, and there's another question in the engine to figure out what they don't like about the product. Now you have a list of things people love, you have a list of things people don't love, and you can work down that list to make the product market fit score go up. And basically at the start of every planning cycle, I advise spending half your time doubling down on what people really love and half your time systematically overcoming the objections of the somewhat disappointed users, but specifically those for whom the main benefit resonates.

**中文翻译:**
这样你就明确了值得关注的“细分中的细分”群体。引擎中还有另一个问题来弄清楚他们不喜欢产品的什么地方。现在你有一份人们喜欢的东西清单，也有一份人们不喜欢的东西清单，你可以按照这份清单来提高 PMF 得分。基本上，在每个规划周期开始时，我建议花一半的时间加倍投入人们真正喜欢的东西，另一半时间系统地克服那些“有点失望”用户的反对意见——但仅限于那些对核心价值产生共鸣的用户。

---

### [00:58:14] Lenny Rachitsky

**English:**
That was an excellent summary. I know I said we wouldn't spend a ton of time here, but I'm really glad we did. That was really helpful. Let me ask you this, I know you used this initially in the early days, are you still operating in this way in some form?

**中文翻译:**
这是一个非常精彩的总结。我知道我说过不会在这里花太多时间，但我很高兴我们聊了。这非常有帮助。我想问：我知道你们在早期使用了这个方法，现在你们还在以某种形式沿用这种方式吗？

---

### [00:58:24] Rahul Vohra

**English:**
We don't run the engine as is for Superhuman as a whole. There are enough subcomponents of Superhuman now that are almost individual products. For example, Superhuman for Sales, our multiplayer and collaboration features, how we think about the enterprise, AI is its whole thing, but we do sometimes run it on those individual pieces. For example, we'll ask a salesperson, the Product Market Fit Engine, as it relates to Superhuman for sales. As we think about starting new products, we would absolutely deploy the product market fit engine.

**中文翻译:**
我们不再对整个 Superhuman 运行原封不动的引擎。Superhuman 现在有很多子组件，几乎可以看作独立的产品。例如 Superhuman for Sales、我们的多玩家和协作功能、我们对企业的思考、AI 也是独立的一块，但我们有时会在这些独立部分上运行它。例如，我们会针对 Superhuman for Sales 询问销售人员 PMF 引擎的问题。当我们考虑启动新产品时，我们绝对会部署 PMF 引擎。

---

### [00:58:59] Lenny Rachitsky

**English:**
Awesome. The way you ask this question is an in-product interstitial sort of survey pop-up thing?

**中文翻译:**
太棒了。你提问的方式是产品内的插屏调查弹窗吗？

---

### [00:59:04] Rahul Vohra

**English:**
You can do it however you want. The way Sean initially benchmarked the number was via email surveys. I think email surveys work just fine. The key thing is, and this applies to any survey methodology, if you're going to change the method of surveying, all of your old numbers are invalidated. So it's just a new baseline going forwards.

**中文翻译:**
你可以用任何你想要的方式。Sean 最初做基准测试时是通过邮件调查。我认为邮件调查效果很好。关键点在于——这适用于任何调查方法——如果你改变了调查方式，你以前的所有数据就失效了。所以这只是一个新的基准。

---

### [00:59:25] Lenny Rachitsky

**English:**
Got it. We had Sean on the podcast and he describes this method in detail. So if folks want to explore the Sean Ellis test, listen to that podcast. We'll link to it.
(00:59:33):
Okay, next topic that I'm excited to get your take on, is game design versus gamification. This is one of the more unique ways you think about designing product. When people hear you talk about this, they think it's like, "Oh, gamification making things like games. Oh, it's Zynga, Farmville, I don't want to do that." But you actually have a really different perspective on why you need to think about game design as you design products. Talk about your insights there.

**中文翻译:**
明白了。我们请 Sean 上过播客，他详细描述了这个方法。所以如果大家想探索 Sean Ellis 测试，可以去听那一集，我们会放上链接。
好，下一个我很期待听你见解的话题是“游戏设计（game design）与游戏化（gamification）”。这是你思考产品设计最独特的方式之一。当人们听到你谈论这个时，他们会想：“噢，游戏化就是把东西做得像游戏一样。噢，那是 Zynga，是开心农场，我不想做那个。”但你实际上对于为什么在设计产品时需要考虑“游戏设计”有一个非常不同的视角。谈谈你的见解。

---

### [00:59:58] Rahul Vohra

**English:**
Well, I strongly believe that we should make business software like we make games, because when we make products like we make games, people find them fun. They tell their friends, they fall in love with them. It's another way actually of backing into where we open this conversation, which is you're making a brand, you are giving reason for word of mouth. It's actually an altogether different kind of product development. So how do we do this? Well, as you've said, it's not gamification, that doesn't work. Game design works, but game design is not gamification. It's not, for example, simply taking your product and adding points, levels, trophies or badges.

**中文翻译:**
我坚信我们应该像制作游戏一样制作商业软件，因为当我们像制作游戏一样制作产品时，人们会觉得它们很有趣。他们会告诉朋友，会爱上它们。这实际上是回到了我们开头聊的话题：你在打造一个品牌，你在为口碑创造理由。这实际上是一种完全不同的产品开发方式。那么我们该怎么做呢？正如你所说，不是“游戏化”，那行不通。“游戏设计”才行得通，但游戏设计不是游戏化。例如，它不是简单地在你的产品里加入积分、等级、奖杯或徽章。

(01:00:40):
**English:**
To understand why gamification does not work, we actually have to start with human motivation. There's a very interesting study from Stanford that demonstrates the difference perfectly. In the 1970s, these Stanford researchers recruited children who were aged three to four years old, and all of these kids were generally pre-interested in drawing. Some kids were told they would get a reward, a certificate with a gold seal and a ribbon. And some kids were not told about any reward and they did not even expect one or didn't know of one. Now each child was then invited into a separate room to draw for six minutes and afterwards they would either get the reward or not.

**中文翻译:**
要理解为什么游戏化行不通，我们实际上必须从人类的动机开始。斯坦福大学有一项非常有趣的研究完美地证明了这种差异。在 20 世纪 70 年代，斯坦福的研究人员招募了 3 到 4 岁的儿童，这些孩子通常都对画画有预先的兴趣。一些孩子被告知他们会得到奖励——一张带有金印和丝带的证书；而另一些孩子则没有被告知任何奖励，他们甚至没有预料到或不知道会有奖励。然后每个孩子被邀请到一个单独的房间画画 6 分钟，之后他们要么得到奖励，要么没有。

(01:01:21):
**English:**
Over the next few days, the children were observed to see how much they would continue to draw by themselves. So the children with no reward, they spent 17% of their time drawing, but the children who expected a reward, sadly they only spent 8% of their time drawing. The very presence of a reward halved their motivation. So what's happening? What's happening here, is researchers differentiate intrinsic motivation and extrinsic motivation. With intrinsic motivation we do things because they are inherently interesting and satisfying, and with extrinsic motivation, we do things to earn rewards and to achieve external goals. That's the problem with rewards, is they just massively undermine intrinsic motivation. That's why gamification doesn't work. And when gamification does work, it's because the underlying experience was already designed like a game.

**中文翻译:**
在接下来的几天里，研究人员观察这些孩子会花多少时间自发地继续画画。结果，没有奖励的孩子花了 17% 的时间画画，但那些期待奖励的孩子，遗憾的是，他们只花了 8% 的时间画画。奖励的存在使他们的动力减半。发生了什么？研究人员区分了“内在动机”（intrinsic motivation）和“外在动机”（extrinsic motivation）。内在动机是我们做某事是因为它本身有趣且令人满足；而外在动机是我们做某事是为了赢得奖励或实现外部目标。这就是奖励的问题所在：它们会极大地破坏内在动机。这就是为什么游戏化行不通。而当游戏化确实起作用时，那是因为底层体验本身就已经被设计得像游戏一样了。

---

### [01:02:19] Lenny Rachitsky

**English:**
What makes something like a game? I know Superhuman is really good at this, of just your inbox zero quest that you're on. Just to make that a little more real, what is game design? What does that mean to you? What makes it feel like a game?

**中文翻译:**
是什么让一个东西感觉像游戏？我知道 Superhuman 在这方面做得很好，比如你正在进行的“收件箱清零”（Inbox Zero）任务。为了让它更具体一点，什么是游戏设计？它对你意味着什么？是什么让它感觉像个游戏？

---

### [01:02:32] Rahul Vohra

**English:**
Well, maybe folks don't know this, but before I was a founder, you can probably tell, I was actually professionally a game designer. And as it turns out, there is no unifying theory of game design. To create games, what we need to do is draw upon the arts and the science of psychology, mathematics, storytelling, interaction design. And at Superhuman we've identified five key areas that we really care about, goals, emotions, toys, controls and flow. And across these we've identified many principles of game design. One example principle would be, make fun toys and then combine those into games.

**中文翻译:**
也许大家不知道，但在我成为创始人之前（你可能看得出来），我其实是一名职业游戏设计师。事实证明，游戏设计并没有统一的理论。为了创造游戏，我们需要借鉴心理学、数学、讲故事、交互设计等艺术和科学。在 Superhuman，我们确定了五个我们非常关心的关键领域：目标（goals）、情感（emotions）、玩具（toys）、控制（controls）和心流（flow）。在这些领域中，我们确定了许多游戏设计原则。其中一个原则就是：制作有趣的“玩具”，然后将它们组合成“游戏”。

(01:03:12):
**English:**
A question I like to ask is, are toys the same as games? They do seem different. For example, we play with toys, but we play games. A ball is a toy, but football is a game. As it turns out, the best games are constructed out of toys. Why? Because then they are fun on both levels, the toy and the game itself. So for example, in Superhuman, one of our favorite toys is the time auto-completer. If you use Superhuman, this is the thing that appears when you hit H, when you snooze or set reminders on emails. You can type whatever you want, it can be gibberish and it does its best to understand you. For example, if you type in 2D, that becomes two days, 3H is three hours, one MO is one month. The time auto-completer is fun because it indulges your playful exploration.

**中文翻译:**
我喜欢问的一个问题是：玩具和游戏是一回事吗？它们看起来确实不同。例如，我们“玩”玩具，我们也“玩”游戏。球是玩具，但足球是游戏。事实证明，最好的游戏是由玩具构成的。为什么？因为这样它们在两个层面上都很有趣：玩具层面和游戏本身层面。例如，在 Superhuman 中，我们最喜欢的玩具之一是“时间自动补全器”。如果你用 Superhuman，当你按 H 键、稍后处理或设置邮件提醒时，它就会出现。你可以输入任何你想要的东西，甚至是乱码，它会尽力理解你。例如，输入 2D 变成两天，3H 是三小时，1MO 是一个月。时间自动补全器很有趣，因为它满足了你爱玩的探索欲。

(01:04:06):
**English:**
In onboardings, it wasn't long before I saw people asking, "What can it do? Where does it break? How does it work? What happens if I keep on typing in a series of tens? Well, it turns out that's October the 10th at 10:10 PM. Well, how about a series of twos? Well, that's February the second, 2022 at 2:00 PM." Then you start trying more complex inputs like in a fortnight and a day, and that works, which is a pleasant surprise. And it's not long before you find more pleasant surprises like time zone math happens without you thinking about it. You can just type in 8:00 AM in Tokyo and it turns out that's 8:00 PM Eastern Time and you no longer have to do the time zone math.

**中文翻译:**
在引导过程中，没过多久我就看到人们在问：“它能做什么？哪里会出错？它是怎么工作的？如果我一直输入一连串的 10 会发生什么？结果发现那是 10 月 10 日晚上 10:10。那一连串的 2 呢？那是 2022 年 2 月 2 日下午 2:00。”然后你开始尝试更复杂的输入，比如“两周零一天后”（in a fortnight and a day），它也能行，这真是一个惊喜。不久你还会发现更多惊喜，比如时区换算在你不知不觉中就完成了。你只需输入“东京上午 8 点”，它就会自动显示为东部时间晚上 8 点，你不再需要自己算时区了。

(01:04:45):
**English:**
Then most people were really delighted to find out that if you really want, you can snooze emails until never, i.e. you can literally type in never, and the email will never come back. It had like a little shrug emoji at the same time. Is this toy going to win awards? Nope. But is it fun actually, surprisingly yes. So what I would encourage people to do is, think about the features of their product. Do those features indulge, playful, exploration? Are they fun even without a goal? And do they elicit moments of pleasant surprise? If so, you have a toy and you can combine that with other toys and actually start to build a game.

**中文翻译:**
然后大多数人会非常高兴地发现，如果你愿意，你可以把邮件“稍后处理”到“永远”（never），也就是说你真的可以输入“never”，那封邮件就再也不会回来了。它还会同时显示一个耸肩的表情符号。这个玩具会得奖吗？不会。但它有趣吗？出人意料地有趣。所以我鼓励大家思考一下自己产品的功能。这些功能是否满足了爱玩的探索欲？即使没有目标，它们也有趣吗？它们能引发惊喜时刻吗？如果是，你就拥有了一个玩具，你可以将它与其他玩具结合，真正开始构建一个游戏。

---

### [01:05:28] Lenny Rachitsky

**English:**
If people were to listen to this segment of the podcast, they would never guess we're talking about B2B software and email, which I love. Let's talk about pricing strategy and your approach to pricing. Another very contrarian approach that you guys took where you charge $30 a month for email that was free, that people don't need to pay for anywhere. And it's worked and now a lot of companies are thinking of it this way. You've even raised your prices recently. What have you learned about pricing strategy that you think might be helpful to folks?

**中文翻译:**
如果人们只听这一段播客，绝对猜不到我们在聊 B2B 软件和电子邮件，我太喜欢这一点了。让我们聊聊定价策略和你的定价方法。这是你们采取的另一个非常反传统的做法：你们对原本免费、人们在任何地方都不需要付钱的电子邮件收取每月 30 美元的费用。而且它成功了，现在很多公司都在效仿。你们最近甚至还涨价了。关于定价策略，你学到了哪些可能对大家有帮助的东西？

---

### [01:05:58] Rahul Vohra

**English:**
I always say the same thing when it comes to pricing, which is before you figure out pricing, you must first figure out positioning. Superhuman is the best email tool on the market. We fortunately have the metrics to show this. One of the cool things about selling an email tool, is you can compare the 30 days prior to using Superhuman to the 30 days after, or the year before to the year after. We do that obviously. We're able to show that people get through their email twice as fast with Superhuman, that they respond one to two days faster, and that they save four hours or more every single week. Because of that, we're very confident in saying that Superhuman is the best email tool on the market and that we're building it for high performing teams and high performing individuals. In other words, we serve the high end of the market.

**中文翻译:**
谈到定价，我总是说同样的话：在确定价格之前，你必须先确定定位。Superhuman 是市场上最好的电子邮件工具。幸运的是，我们有数据来证明这一点。销售电子邮件工具的一个酷点在于，你可以对比使用 Superhuman 前后的 30 天，或者前后的年份。我们确实这么做了。我们能证明人们使用 Superhuman 处理邮件的速度快了两倍，回复速度快了一到两天，而且每周能节省四小时或更多时间。正因如此，我们非常有信心说 Superhuman 是市场上最好的电子邮件工具，我们是为高效团队和高效个人打造的。换句话说，我们服务于高端市场。

(01:06:48):
**English:**
Once you understand your positioning, you can then move on to pricing. And one of the best books on this is a book called Monetizing Innovation by Madhavan Ramanujam. And Madhavan covers a lot of ways to develop pricing. We used one of the easiest methods, which is the Van Westendorp Price Sensitivity [inaudible 01:07:08]. In the early years, we asked, I think it was around a hundred of our earliest users, the following four questions. Number one, at what price would you consider Superhuman to be so expensive that you would not consider buying it? Number two, at what price would you consider Superhuman to be priced so low that you'd be worried about its quality and you wouldn't buy it? At number three, what price would you consider Superhuman to be starting to get expensive, so that it's not out of the question, but you'd have to give some thought to buying it? And number four, at what price would you consider Superhuman to be a bargain? A great buy for the money?

**中文翻译:**
一旦你理解了定位，就可以开始定价了。关于这一点，最好的书之一是 Madhavan Ramanujam 写的《货币化创新》（Monetizing Innovation）。Madhavan 介绍了很多制定价格的方法。我们使用了最简单的方法之一，即“范威斯腾多普价格敏感度测量”（Van Westendorp Price Sensitivity Meter）。在早期，我们向大约 100 名最早的用户询问了以下四个问题：1. 什么价格你会觉得 Superhuman 太贵了，以至于完全不考虑购买？2. 什么价格你会觉得 Superhuman 太便宜了，以至于担心它的质量而不会购买？3. 什么价格你会觉得 Superhuman 开始变贵了，虽然不是完全不考虑，但需要仔细想想才会买？4. 什么价格你会觉得 Superhuman 简直是捡便宜，物超所值？

(01:07:45):
**English:**
Now most startups orient around price point number four. This is especially true for greenfield opportunities, marketplaces, you've got to set the transaction value around price 0.4. Basically when you want as many people to sign up as is humanly possible, at the top of the funnel. But the price point that supports our best in class, best in category position, is actually the third one. It starts to feel expensive, but then you sit down and you think about the time that you spend in email, the ROI, and you still buy it anyway. It turns out that the median answer for the third question was $30 per month, and that's how we picked our price.

**中文翻译:**
大多数初创公司会围绕第四个价格点定价。对于空白市场的机会或双边市场来说尤其如此，你必须把交易价值设定在第四个价格点附近。基本上就是当你希望漏斗顶部有尽可能多的人注册时。但支持我们“同类最佳”、“品类最佳”定位的价格点，实际上是第三个。它让你开始觉得贵，但当你坐下来思考你在邮件上花的时间和投资回报率（ROI）时，你还是会买。结果发现，第三个问题的中位数答案是每月 30 美元，这就是我们选定价格的过程。

(01:08:27):
**English:**
And once we picked our price, we then do a quick gut check on market size. For example, we're a venture scale company, but at the time the question that we had to ask is, "Could we grow into a billion dollar valuation?" Well, let's assume that at that point our valuation is 10 times our ARR, so our ARR would have to be a hundred million dollars. Well, that would be 300,000 subscribers at $30 per month. That is conservatively assuming no other ways to increase ARP. You mentioned price increase, you can also go up market, you can sell new products and so on. We asked ourselves, without those tricks, do we think we can get to hundreds of thousands of subscribers? And we answered emphatically, yes, so we went ahead with that price.

**中文翻译:**
选定价格后，我们会对市场规模进行快速的直觉检查。例如，我们是一家风险投资规模的公司，当时我们必须问：“我们能成长到 10 亿美元的估值吗？”假设到那时我们的估值是 ARR（年度经常性收入）的 10 倍，那么我们的 ARR 必须达到 1 亿美元。按每月 30 美元计算，那就是 30 万订阅用户。这是保守估计，假设没有其他提高 ARP（每用户平均收入）的方法。你提到了涨价，我们还可以走向高端市场、销售新产品等等。我们问自己：如果不玩那些花招，我们认为能达到数十万订阅用户吗？我们的回答是坚定的“是”，所以我们就按那个价格执行了。

---

### [01:09:13] Lenny Rachitsky

**English:**
Okay, there's a couple more things I want to chat about in the time that we have and then I know you have to run. One is around AI and the work you guys are doing there. I know that's been a big unlock. And then two, the stuff you're doing in the enterprise. Then if we have time, there's a question I want to ask that I think is a really interesting way you guys operate.

**中文翻译:**
好，在剩下的时间里我还想聊几件事，我知道你待会儿得走。第一是关于 AI 以及你们在那方面做的工作，我知道那是一个巨大的突破。第二是你们在企业市场做的事情。如果还有时间，我想问一个关于你们运营方式的很有趣的问题。

(01:09:29):
**English:**
Let's talk about AI first. It feels like there's this being in the right place at the right time. It feels like you guys have been building this for a while, and then AI just unlocked another stage in what you're able to do with email. Just talk about what you've done and what how you think about AI integrating into what you're doing, how it's enabled you to kind of take off again?

**中文翻译:**
先聊聊 AI。感觉你们像是“在正确的时间出现在了正确的地方”。感觉你们已经为此准备了很久，然后 AI 刚好开启了你们处理邮件的新阶段。谈谈你们做了什么，以及你如何看待 AI 与你们业务的整合，它是如何让你们再次“起飞”的？

---

### [01:09:52] Rahul Vohra

**English:**
It's true that sometimes startups boil down to being in the right place at the right time. We actually had a massive AI launch recently about two weeks ago, but even before then we had multiple flagship AI features. Our first AI feature was write with AI, jot down a few words and we'll turn them into a fully written email. We actually match the voice and tone in the emails you've already sent. So unlike Co-pilot, unlike Gemini, unlike basically every other email app, the email sounds like you. This AI feature is way more popular than I expected it to be. On average today, users are using it 37 times per week.

**中文翻译:**
确实，初创公司有时归结为在正确的时间出现在正确的地方。我们大约两周前刚进行了一次大规模的 AI 发布，但在此之前我们已经有了多个旗舰 AI 功能。我们的第一个 AI 功能是“AI 写作”（write with AI），记下几个词，我们就能把它变成一封完整的邮件。我们实际上会匹配你已发送邮件的语气和语调。所以不像 Copilot，不像 Gemini，也不像几乎所有其他邮件应用，这封邮件听起来就像是你写的。这个 AI 功能比我预想的要受欢迎得多。目前用户平均每周使用它 37 次。

(01:10:33):
**English:**
Number two, our next AI feature was auto summarize, which shows a one line summary above every conversation. And as new emails arrive, it updates instantly. Again, unlike Co-pilot and Gemini, it's pre-computed. One of the things we do is, we go above and beyond to make these features really premium and feel amazing. The next AI feature after that was instant reply. Imagine waking up to an inbox where every email already has a draft reply. You would simply edit and then send, and sometimes you wouldn't even need to edit. I can share because we just finished this analysis, that over 2024, the percentage of emails that are AI written and sent with Superhuman has grown four times just in one year.

**中文翻译:**
第二，我们的下一个 AI 功能是“自动摘要”（auto summarize），它在每个对话上方显示一行摘要。随着新邮件的到来，它会立即更新。同样，与 Copilot 和 Gemini 不同，它是预计算好的。我们所做的一件事就是竭尽全力让这些功能感觉非常高端和惊艳。再下一个 AI 功能是“即时回复”（instant reply）。想象一下，早上醒来打开收件箱，每封邮件都已经有了草稿回复。你只需简单编辑然后发送，有时甚至不需要编辑。我可以分享一下我们刚完成的分析：在 2024 年，Superhuman 中由 AI 编写并发送的邮件比例在一年内增长了 4 倍。

(01:11:20):
**English:**
Then if I remember correctly, the feature after that was Ask AI. Email of course, is this treasure trove of critical information, things like project statuses, customer communication, meeting updates, deal execution, and so much more. And for over 40 years we've had to rely on what we hilariously call, search. You have to remember senders, guess keywords, scan subject lines, and now you can just ask, "Where is the queue one offsite?" or, "What are my flight details?" Or, "What is the top five most positive customer responses to the Ask AI launch?" A task by the way, which previously used to take me 20 or 30 minutes to read through all the emails and then create that report now happening in less than five seconds.

**中文翻译:**
如果我没记错，再之后的功能是“问 AI”（Ask AI）。电子邮件当然是关键信息的宝库，比如项目状态、客户沟通、会议更新、交易执行等等。40 多年来，我们不得不依赖我们滑稽地称之为“搜索”的功能。你得记住发件人，猜测关键词，扫描主题行。而现在你只需问：“第一季度的团建在哪里？”或者“我的航班详情是什么？”或者“关于 Ask AI 发布，客户最正面的前五个反馈是什么？”顺便说一下，以前我需要花 20 或 30 分钟阅读所有邮件并创建报告的任务，现在不到 5 秒就能完成。

(01:12:09):
**English:**
Recently we, like I said, announced our biggest evolution yet. Superhuman AI is constantly helping you. It's organizing your inbox. It's also making sure you never drop the ball. We have things that we call Auto Labels. You can now write a short prompt like job applications or requests to review work, and you can then immediately see when emails match that prompt, when people apply for a job or they ask you to review work. With Auto Reminders, if your email needs a response, Superhuman will now automatically set a reminder. You don't have to remember to do that and you'll never drop the ball again. All you need to do is hit send. With Auto Drafts, Superhuman will now automatically draft your follow-up emails for you and will soon be drafting replies to basically every email that needs a response.

**中文翻译:**
最近，正如我所说，我们宣布了迄今为止最大的演进。Superhuman AI 正在持续为你提供帮助。它在整理你的收件箱，还确保你永远不会遗漏任何事。我们有“自动标签”（Auto Labels）。你现在可以写一个简短的提示词，比如“职位申请”或“审阅工作请求”，然后你就能立即看到匹配该提示的邮件。有了“自动提醒”（Auto Reminders），如果你的邮件需要回复，Superhuman 现在会自动设置提醒。你不需要刻意去记，再也不会漏掉事情了。你唯一要做的就是点击发送。有了“自动草稿”（Auto Drafts），Superhuman 现在会自动为你起草跟进邮件，并且很快就能为几乎每封需要回复的邮件起草回复。

(01:12:59):
**English:**
And finally, with what we call Workflows, you can now turn email into repeatable automated workflows. For example, I often get emails from people who are interested in working at Superhuman, and I would normally reply to that candidate and I would let them know that the team will take a look. I'll then forward to the original message, including any resume or any letter to our head of people and operations and ask her to reach out, if interested. With Workflows, I can now automate this entire process. It's, you can imagine, creating a little flowchart of what has to happen. Not only does that save a huge amount of time, with Workflows you don't even have to be in your inbox. In fact, you don't even have to be working. You could be on vacation while Superhuman AI is working for you.

**中文翻译:**
最后，通过我们所谓的“工作流”（Workflows），你现在可以将电子邮件转变为可重复的自动化流程。例如，我经常收到对在 Superhuman 工作感兴趣的人发来的邮件，我通常会回复候选人，告诉他们团队会查看。然后我会把原始邮件（包括简历或求职信）转发给我们的 HR 和运营负责人，请她感兴趣的话联系对方。有了工作流，我现在可以自动化整个过程。你可以想象成创建一个关于后续步骤的小流程图。这不仅节省了大量时间，而且有了工作流，你甚至不需要待在收件箱里。事实上，你甚至不需要在工作。你可以在度假，而 Superhuman AI 正在为你工作。

---

### [01:13:53] Lenny Rachitsky

**English:**
This sounds like product market fit to me. This all sounds wonderful. It just makes sense. This is the stuff we've been promised, our underwater cities and flying cars and then just email that just works magically and replies for us and all these things. I love all these things you're doing.

**中文翻译:**
在我看来，这就是产品市场契合度。这一切听起来都太棒了。它非常合乎逻辑。这就是我们曾被许诺的未来：水下城市、飞行汽车，以及能神奇地工作、帮我们回复的电子邮件。我非常喜欢你们正在做的这些事。

(01:14:08):
**English:**
For folks that are building with AI. I'm curious, what's maybe been the biggest surprise, either good or bad, building so deeply on top of AI models that you think might be helpful for folks to just, "Watch out for this," or, "Hey, check this out."?

**中文翻译:**
对于那些正在基于 AI 构建产品的人，我很好奇：在如此深度地基于 AI 模型构建的过程中，最大的惊喜（无论是好是坏）是什么？你觉得有哪些是值得大家“注意”或“关注”的？

---

### [01:14:25] Rahul Vohra

**English:**
I think for me the biggest surprise has been how unpredictable the user love has been in terms of what they love and what they don't love. For example, write with AI. This sounds like a commodity feature and on all surface level it is. Every email app, every writing surface has a write with AI feature in. I would wager ours is the best at emails and surprisingly that's what we do. But the surprising thing was just how much people love it and how often it gets used. 37 times per user per week is still mind-blowing to me. I had not expected that, so that's the most surprising thing.

**中文翻译:**
对我来说，最大的惊喜在于用户对功能的喜爱是多么不可预测。例如“AI 写作”。这听起来像是一个平庸的功能，表面上看确实如此。每个邮件应用、每个写作界面都有 AI 写作功能。我敢打赌我们在处理邮件方面是做得最好的，毕竟这就是我们的本行。但令人惊讶的是人们竟然如此喜爱它，使用频率如此之高。每周每用户 37 次，这对我来说依然很震撼。我完全没料到这一点，这是最让我惊讶的。

(01:15:11):
**English:**
And on the flip side, there were certain AI features where I did expect a ton of usage, but we didn't quite get the usage that we were perhaps hoping for. Hopefully I'm not AI Kramer, but basically everything I thought would work out well, people use it less than they thought they did. And everything where I was like, "I don't know, but let's build the thing," people love that.

**中文翻译:**
反过来说，有些 AI 功能我原本预期会有极高的使用量，但结果并没有达到我们的期望。希望我不是“AI 界的吉姆·克莱默”（反向指标），但基本上我以为会大火的功能，人们用得比预想的少；而那些我觉得“不知道行不行，先做出来看看”的功能，人们反而爱得不行。

---

### [01:15:33] Lenny Rachitsky

**English:**
Interesting.

**中文翻译:**
有趣。

---

### [01:15:34] Rahul Vohra

**English:**
Maybe I should just create an anti-me to do AI road-mapping.

**中文翻译:**
也许我该弄个“反向的我”来制定 AI 路线图。

---

### [01:15:38] Lenny Rachitsky

**English:**
That's in a simple agent right there, whatever Rahul says, do the opposite.

**中文翻译:**
那只需要一个简单的 AI 智能体：无论 Rahul 说什么，反着做就行。

---

### [01:15:41] Rahul Vohra

**English:**
Yeah.

**中文翻译:**
没错。

---

### [01:15:42] Lenny Rachitsky

**English:**
Okay. Another maybe a last topic. I know that you guys are starting to move into the enterprise. When people think of Superhuman, they think of it's consumer-y, it's for people, and you guys are doing a lot of work to make it a B2B enterprise product. For founders maybe that are starting to think about this transitioning from PLG to sales led and B2B enterprising, what have you learned about just what it takes to get to that point and what does that sales motion look like for you guys?

**中文翻译:**
好。最后一个话题。我知道你们开始进军企业市场了。当人们想到 Superhuman 时，会觉得它很像消费级产品，是面向个人的，而你们正在做大量工作把它变成 B2B 企业产品。对于那些正在考虑从 PLG（产品驱动增长）转型为销售驱动和 B2B 企业化的创始人，你学到了什么？达到那个阶段需要什么？你们的销售模式是怎样的？

---

### [01:16:10] Rahul Vohra

**English:**
In some ways, it's very like selling to prosumers, except these users are not coming from Gmail where prosumers would normally come from, they're coming from Outlook. And Outlook users have very different expectations to Gmail users. For example, Outlook users expect their email app to also be a fully featured calendar app, whereas Gmail users are happy with those two things being entirely different. As a result, we've invested in calendar very heavily and we continue to do so. There's only so much I can say, but it's pretty exciting.

**中文翻译:**
在某些方面，这非常像向专业消费者（prosumers）销售，不同之处在于这些用户不是来自 Gmail（专业消费者通常来自那里），而是来自 Outlook。Outlook 用户与 Gmail 用户的期望非常不同。例如，Outlook 用户期望他们的邮件应用同时也是一个功能齐全的日历应用，而 Gmail 用户则习惯于这两者是完全分开的。因此，我们在日历功能上投入了大量精力，并且还在继续投入。我能透露的不多，但这非常令人兴奋。

(01:16:49):
**English:**
Outlook users are also used to certain safeguards, like if you've used Outlook in an enterprise, warnings when a recipient is external to your domain or what Outlook users might know as sensitivity labels. And as a result we've built support for external recipient indicators and sensitivity labels. But in some ways it's very different to selling to prosumers because there are other stakeholders involved. For example, we've built support for enterprise mobile management by implementing Microsoft Intune.

**中文翻译:**
Outlook 用户也习惯于某些安全保障，比如如果你在企业里用 Outlook，当收件人是你域名之外的外部人员时会有警告，或者 Outlook 用户熟知的“敏感度标签”。因此，我们构建了对外部收件人指示器和敏感度标签的支持。但在某些方面，这与向专业消费者销售非常不同，因为涉及其他利益相关者。例如，我们通过实施 Microsoft Intune 构建了对企业移动管理（EMM）的支持。

(01:17:22):
**English:**
We recently sold one of the big three strategy consulting firms, which is super exciting. I can't say which one, but they love Superhuman and they have thousands of people internally using Superhuman. This is after a year... They've been piloting for a year and then accelerating over the last few months. We only just got them the mobile app, believe it or not. Because, at an enterprise like that, there are significant controls on what a allowed compliant mobile app can and cannot do. For example, IT needs to be able to control which apps can save attachments or which apps you can copy and paste text into from email. And for many enterprises, those controls are super important.

**中文翻译:**
我们最近签下了三大战略咨询公司之一，这非常令人兴奋。我不能说是哪一家，但他们非常喜欢 Superhuman，内部有数千人在使用。这是在经过一年的试点，然后在过去几个月加速推进后的结果。信不信由你，我们最近才给他们提供移动端应用。因为在那样规模的企业中，对于允许的合规移动应用能做什么、不能做什么有严格的控制。例如，IT 部门需要能够控制哪些应用可以保存附件，或者你可以从邮件中把文本复制粘贴到哪些应用中。对于许多企业来说，这些控制至关重要。

---

### [01:18:14] Lenny Rachitsky

**English:**
Wow, okay. So it sounds like essentially just building all these features that large companies need, is kind of the road you're on right now.

**中文翻译:**
哇，好吧。所以听起来你现在的路线基本上就是构建大公司需要的所有这些功能。

---

### [01:18:21] Rahul Vohra

**English:**
Exactly. And there's two stakeholders. There's the users, which are actually quite different because they're Outlook users and Calendar is one of the main ways that manifests. There's a whole bunch of other stakeholders, IT is one of them, but there are others as well. For example, companies this large have workplace management groups who want to see analytics of how people are working, how they can make their teams more efficient, so it truly is a multi-threaded sale with multiple stakeholders.

**中文翻译:**
没错。这里有两类利益相关者。一类是用户，他们其实很不一样，因为他们是 Outlook 用户，日历是主要的体现方式之一。还有一大堆其他利益相关者，IT 部门是其中之一，但还有其他的。例如，这么大规模的公司有工作场所管理小组，他们想看到人们如何工作的分析数据，以及如何提高团队效率。所以这确实是一个涉及多个利益相关者的多线销售过程。

---

### [01:18:49] Lenny Rachitsky

**English:**
They had a product from Linear on the podcast [inaudible 01:18:51], and he actually, I don't know if you heard that episode, but he talks about how they decide what to prioritize, the thing they never build is middle managers needing to track how their reports are doing and things like that. That's an interesting opportunity for you guys maybe to cut stuff. I don't know.

**中文翻译:**
Linear 的产品负责人也上过这个播客，我不确定你听过没，但他谈到他们如何决定优先级时说，他们永远不会构建的功能就是“中层管理人员需要追踪下属进度”之类的。这对你们来说可能是一个精简功能的好机会，我也不确定。

(01:19:07):
**English:**
Anyway, I want to end on one more nugget. Okay, I'm glad we have time for this. You shared that you have this system internally at Superhuman for making decisions. You call it Single Decisive Reason, SDR. What is that?

**中文翻译:**
不管怎样，我想以最后一个干货结束。很高兴我们还有时间。你分享过 Superhuman 内部有一套做决策的系统，你称之为“单一决定性理由”（Single Decisive Reason, SDR）。那是什么？

---

### [01:19:22] Rahul Vohra

**English:**
SDR is a thinking tool that I picked up from Reid Hoffman during my time at LinkedIn. The idea here is that for important decisions, you should be able to identify one, one reason that on its own supports the decision. It's based on the observation that all too often we rely on a collection of weak reasons to justify decisions. It's very, very easy to do this. Imagine you are contemplating a decision, you write a list of the pros and the cons. There are three pros, but let's say there are 10 or 15 cons. The sheer number of cons, the effort of thinking them through, the time it took to write them down, is going to affect you, consciously or worse subconsciously. This is especially true, I've seen in group settings, which just in general are a little bit more risk averse and a little bit more consensus driven.

**中文翻译:**
SDR 是我在 LinkedIn 工作期间从 Reid Hoffman 那里学到的一种思维工具。核心理念是：对于重要的决策，你应该能够识别出一个理由，仅凭这一个理由就能支持该决策。它基于一种观察：我们往往依赖一堆微弱的理由来为决策辩护。这非常容易发生。想象一下你在考虑一个决定，你列出了优缺点清单。有 3 个优点，但假设有 10 到 15 个缺点。缺点的数量、思考它们所费的精力、写下它们所花的时间，都会在意识层面、甚至更糟的潜意识层面影响你。在团队环境中尤其如此，因为团队通常更倾向于规避风险和达成共识。

(01:20:17):
**English:**
So whenever anyone is making a decision and they bring that decision to me and they say, "Well, we want to do this because of X, Y, Z, and there are multiple reasons." I ask them, "What's the SDR? What's the single decisive reason?" If they can't yet isolate it, that tells me they haven't yet figured out why they want to make the decision. It doesn't mean the decision is wrong, it just means that they haven't figured out the singular reason why we should do the thing. They can then go through their list of reasons and ask, "Is this alone enough to support this decision?" Meaning if this was true and all the other things were not true, would I still do it? And sometimes we still do, but actually sometimes we don't. We realize that a collection of weak reasons alone means that, for example, the outcome is less likely than we thought it was, or it was hiding a really strong reason on the other side of the decision.

**中文翻译:**
所以，每当有人要做决定并把它带到我面前说：“我们要这样做是因为 X、Y、Z 等多个原因”时，我会问他们：“SDR 是什么？那个单一决定性理由是什么？”如果他们还无法将其分离出来，那就说明他们还没弄清楚为什么要下这个决定。这并不意味着决定是错的，只是意味着他们还没找到我们必须做这件事的唯一理由。他们可以审视理由清单并问：“仅凭这一条是否足以支持这个决定？”也就是说，如果这一条是真的，而其他所有条都是假的，我还会这样做吗？有时我们依然会做，但有时我们不会。我们会意识到，一堆微弱理由的集合往往意味着结果可能不如预想的那样，或者它掩盖了决策另一面一个非常强大的反对理由。

---

### [01:21:11] Lenny Rachitsky

**English:**
That is very cool. This is just when someone comes to you with a decision, the way you use this idea is, you ask them what's the single decisive reason?

**中文翻译:**
太酷了。所以当有人带着决策来找你时，你使用这个想法的方式就是问他们：单一决定性理由是什么？

---

### [01:21:20] Rahul Vohra

**English:**
Pretty much. Yeah. And what they can't do, obviously this happens, people are human and natural, they'll usually start mentioning three or four things, and that's fine. And then I will say, "Okay, but if only one of those was true and you're still advocating for this decision, what is it?" I think that's just a bar for a good decision.

**中文翻译:**
差不多。显然，人们通常会开始列举三四件事，这很正常。然后我会说：“好，但如果其中只有一件事是真的，而你仍然坚持这个决定，那是哪一件事？”我认为这就是衡量一个好决策的标准。

---

### [01:21:40] Lenny Rachitsky

**English:**
Why is that so important? Because you found that a bunch of low quality reasons just don't add up to a good reason to do something?

**中文翻译:**
为什么这如此重要？是因为你发现一堆低质量的理由加起来也构不成一个做某事的好理由吗？

---

### [01:21:50] Rahul Vohra

**English:**
Multiple reasons, which is ironic. But that's my SDR for why SDRs work. Which is yes, multiple low quality reasons rarely add up to a high quality reason to do something. But there are also other things as well, which is, any decision you take has an opportunity cost. Any feature you build is another feature that you didn't build. If we're going to build this for a collection of weak reasons, whereas we could build that for one strong reason, I'd much rather build that for one strong reason. Now this is all other things being equal, and these things often end up being quite complicated, but you can apply SDR all the way down. You just did that to me, what's my SDR for SDR?

**中文翻译:**
原因有很多，这挺讽刺的。但这就是我关于“为什么 SDR 有效”的 SDR（单一决定性理由）：是的，多个低质量理由很少能凑成一个高质量理由。但还有别的原因，即任何决策都有机会成本。你构建的任何功能都意味着另一个你没构建的功能。如果我们为了几个微弱的理由去构建这个，而本可以为了一个强大的理由去构建那个，我宁愿选择后者。当然，这是在其他条件相同的情况下，实际情况往往很复杂，但你可以把 SDR 应用到方方面面。你刚才就对我用了这一招：我关于 SDR 的 SDR 是什么？

---

### [01:22:30] Lenny Rachitsky

**English:**
There we go. Rahul, is there anything that we haven't covered that you wanted to cover? Is there any last piece of wisdom you want to leave listeners with before we let you go?

**中文翻译:**
哈哈。Rahul，还有什么我们没聊到但你想聊的吗？在结束之前，有什么最后的智慧想留给听众吗？

---

### [01:22:43] Rahul Vohra

**English:**
I feel good. I think we covered a lot. Thank you for asking amazing questions. This was really fun.

**中文翻译:**
我觉得很好。我想我们聊了很多。谢谢你提出这些精彩的问题，这真的很有趣。

---

### [01:22:51] Lenny Rachitsky

**English:**
This was incredible. Okay, so let me just ask you this then. Where can folks find you online? Where can they check out Superhuman? What should they know before they try it out? And then just how can listeners be useful to you?

**中文翻译:**
太棒了。那让我问你：大家可以在哪里找到你？在哪里可以了解 Superhuman？在尝试之前他们应该知道什么？听众可以如何帮到你？

---

### [01:23:02] Rahul Vohra

**English:**
If you want to find me online, I am generally on X. That is x.com/rahulvohra, R-A-H-U-L V-O-H-R-A. My DMs are open, so feel free to ping me. If you're going to do that, I would suggest also emailing me, that's rahul@superhuman.com, and hopefully I'll see your message soon.

**中文翻译:**
如果你想在网上找到我，我通常在 X 上，网址是 x.com/rahulvohra。我的私信是开放的，欢迎联系我。如果你打算联系我，我建议也给我发邮件：rahul@superhuman.com，希望能尽快看到你的消息。

(01:23:22):
**English:**
If you haven't tried Superhuman, then gosh, what are you doing? This is my call to you to do so, because your time is worth more than whatever you think it might be. So go download Superhuman and give it a shot. Invite your team. The metrics are real. I know they sound like the kind of metrics that startups make up, but getting through your email twice as fast, responding one to two days sooner, saving four hours or more every single week, they're all real.

**中文翻译:**
如果你还没试过 Superhuman，天哪，你在等什么？我呼吁你去尝试，因为你的时间比你想象的更有价值。去下载 Superhuman 试试吧，邀请你的团队。那些数据都是真实的。我知道它们听起来像是初创公司编出来的，但处理邮件快两倍、回复快一两天、每周节省四小时以上，这些都是真的。

(01:23:51):
**English:**
Actually, speaking of which, the consulting firm I mentioned earlier, because they're so into data and into analysis, they wanted to corroborate those numbers for themselves, and so they did. They ran their own internal case study on Superhuman, and they were like, "Yeah, you're saving our partners 3.3 hours per person per week. And there's only one other tool that we've bought that does that, which is ChatGPT. So thank you. We love Superhuman. We're rolling it out." If that sounds interesting to you or your company, please do give it a shot.

**中文翻译:**
事实上，说到这个，我之前提到的那家咨询公司，因为他们非常注重数据和分析，他们想亲自证实这些数字。于是他们做了。他们对 Superhuman 进行了内部案例研究，结论是：“是的，你为我们的合伙人每人每周节省了 3.3 小时。我们买过的工具里只有另一个能做到这一点，那就是 ChatGPT。所以谢谢你，我们爱 Superhuman，我们要全面推广。”如果这听起来对你或你的公司有吸引力，请务必尝试一下。

---

### [01:24:25] Lenny Rachitsky

**English:**
That is super cool. Reflecting back on what I imagine this conversation would look like, a lot of contrarian thinking and attention to detail, I think that's exactly what it was. Rahul, you're awesome. Thank you so much for being here.

**中文翻译:**
太酷了。回想我之前预想的这次对话——大量的反向思维和对细节的关注——我觉得完全符合预期。Rahul，你太棒了。非常感谢你能来。

---

### [01:24:39] Rahul Vohra

**English:**
Thank you. Bye everyone.

**中文翻译:**
谢谢。大家再见。

---

### [01:24:40] Lenny Rachitsky

**English:**
Bye everyone.
(01:24:43):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。