# Ray Cao - 双语对照

# Lenny's Podcast: Ray Cao (TikTok) - Bilingual Transcript
# Lenny's Podcast：Ray Cao (TikTok) - 中英双语对照速记

---

### [00:00:00] Lenny

**English:**
We rarely get a peek into what it's like to work at TikTok. What are some core principles or values or just how TikTok operates?

**中文翻译:**
我们很少有机会能窥见在 TikTok 工作是什么样的。TikTok 有哪些核心原则、价值观，或者说 TikTok 是如何运作的？

---

### [00:00:07] Ray Cao

**English:**
The number one thing is context, no control. That's the reason why we're always encouraging people to see themselves as a business owner.

**中文翻译:**
最重要的一点是“提供情境，而非控制”（Context, no control）。这就是为什么我们总是鼓励员工将自己视为业务所有者（Business owner）。

---

### [00:00:14] Lenny

**English:**
You give them all the information they need and then let them just do things without specific instructions.

**中文翻译:**
也就是说，你给他们提供所需的所有信息，然后让他们在没有具体指令的情况下自行开展工作。

---

### [00:00:18] Ray Cao

**English:**
How do you actually solve the puzzle by connecting all the dots together? Just like how I see some of my friends, their kids playing Legos, if you don't really see the full picture, you won't be able to make the Lego as one thing at the end of the day. You have to see the other pieces.

**中文翻译:**
你如何通过连接所有的点来解开谜题？就像我看到一些朋友的孩子玩乐高一样，如果你看不见全景，最终你就无法把乐高拼成一个整体。你必须看到其他的碎片。

---

### [00:00:31] Lenny

**English:**
What else are important cultural values of TikTok, of how TikTok operates that everyone always has in mind when they're building?

**中文翻译:**
关于 TikTok 的运作方式，还有哪些重要的文化价值观是大家在构建产品时始终铭记在心的？

---

### [00:00:36] Ray Cao

**English:**
We always have this mentality we are a startup, we're a young company, we're always hungry for growth. And a very wacky way is like, "How can I run my second half of my marathon faster than the first half?"

**中文翻译:**
我们始终保持着一种心态：我们是一家初创公司，一家年轻的公司，我们始终渴望增长。一个很奇特的比喻是：“我如何能让马拉松的后半程跑得比前半程更快？”

---

### [00:00:49] Lenny

**English:**
Today my guest is Ray Cao. Ray is the global Head of Monetization Product Strategy & Operations at TikTok where he has been for over four years. Prior to TikTok, Ray spent six years at Google helping scale Google shopping globally.
(00:01:05):
TikTok is interesting for two big reasons. One, it's one of the most successful businesses in history, last valued at over $80 billion. And its parent company is the most valuable private company in the world, last valued at over $200 billion.
(00:01:19):
Two, TikTok is quickly becoming one of the biggest advertising platforms alongside Meta and Google, and generated nearly $10 billion in advertising revenue just a couple of years ago. So for both these reasons, TikTok is a really interesting business and team to learn from. And I've seen very few podcasts and even media get a peek inside how TikTok operates.
(00:01:39):
In our conversation, we discuss TikTok's culture, their core principles and values, how they hire, how they move so fast, their emphasis on working hard, how they do OKRs and planning. We also get into how to succeed on TikTok's ad network, why you want to be testing at least 10 videos a week, how it's different from running ads on Instagram, how to make content that does well on TikTok, and so much more. This episode has a lot of interesting lessons and insights. Obviously TikTok is at the center of a lot of debate globally. Some people love it, some people hate it. But no matter your opinion of TikTok, there's a lot that we can learn from their success.

**中文翻译:**
今天的嘉宾是 Ray Cao。Ray 是 TikTok 全球商业化产品战略与运营负责人，他已经在 TikTok 工作了四年多。在加入 TikTok 之前，Ray 在 Google 工作了六年，负责帮助 Google 购物在全球范围内进行规模化扩张。
(00:01:05):
TikTok 备受关注有两个主要原因。第一，它是历史上最成功的商业案例之一，最近一次估值超过 800 亿美元。其母公司（字节跳动）是全球估值最高的私营公司，最近一次估值超过 2000 亿美元。
(00:01:19):
第二，TikTok 正在迅速成为与 Meta 和 Google 并驾齐驱的最大广告平台之一，仅在几年前其广告收入就已接近 100 亿美元。基于这两个原因，TikTok 是一个非常值得学习的商业案例和团队。我很少看到有播客甚至媒体能深入了解 TikTok 的内部运作。
(00:01:39):
在我们的对话中，我们讨论了 TikTok 的文化、核心原则和价值观、招聘方式、如何保持高速运转、对努力工作的强调，以及他们如何制定 OKR 和计划。我们还深入探讨了如何在 TikTok 广告网络上取得成功、为什么每周至少要测试 10 个视频、在 TikTok 投广告与在 Instagram 有何不同、如何制作受欢迎的内容等等。本集包含许多有趣的教训和见解。显然，TikTok 处于全球许多争议的中心，有人爱它，有人恨它。但无论你对 TikTok 的看法如何，我们都能从它的成功中学到很多。

---

### [00:02:14] Lenny

**English:**
If you enjoy this podcast, don't forget to subscribe and follow the podcast on your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you Ray Cao after a short word from our sponsors.
(00:02:29):
[Sponsor Message: WorkOS]

**中文翻译:**
如果你喜欢这个播客，请不要忘记在您常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本播客有巨大帮助。下面，在听完赞助商的简短介绍后，我们将请出 Ray Cao。
(00:02:29):
[赞助商信息：WorkOS]

---

### [00:03:35] Lenny

**English:**
[Sponsor Message: Eppo]
(00:04:55):
Ray, thank you so much for being here and welcome to the podcast.

**中文翻译:**
[赞助商信息：Eppo]
(00:04:55):
Ray，非常感谢你能来到这里，欢迎来到我们的播客。

---

### [00:05:00] Ray Cao

**English:**
Thank you Lenny for having me. It's a pleasure.

**中文翻译:**
谢谢 Lenny 的邀请，这是我的荣幸。

---

### [00:05:02] Lenny

**English:**
It's my pleasure. I am really excited to have you here because it feels like we rarely get a peek into what it's like to work at TikTok, how TikTok builds product and operates, also how to be successful in TikTok as a business, as an advertiser. So I have all these kinds of questions for you, and so I'm really happy to be chatting. I wanted to start with a little bit about your time before TikTok, which was at Google and comparing that to TikTok. So, you're at Google for six years, I believe. Now you're at TikTok. I'm curious on what stood out to you about the cultural differences between how Google operates and TikTok operates.

**中文翻译:**
我也很高兴。我非常期待这次对话，因为我们很少能了解到在 TikTok 工作是什么样的，TikTok 是如何构建产品和运作的，以及作为企业和广告主如何在 TikTok 上取得成功。我准备了很多问题想问你，很高兴能和你交流。我想先从你加入 TikTok 之前在 Google 的那段经历聊起，并将其与 TikTok 做个对比。你在 Google 待了六年，现在在 TikTok。我很好奇，在 Google 和 TikTok 的运作方式上，有哪些文化差异让你印象深刻？

---

### [00:05:37] Ray Cao

**English:**
Three major things, I would say. Number one is really how these two company thinking about innovation. So, I think Google has a very strong philosophy of we're engineering lab and that there's a lot of technology-driven, and a lot of pieces. They are not necessarily always trying to, I would say, cope with the market even, right? However, I think at the TikTok, I think besides the technology part, we do have a very keen, I would say, appetite to really understand what the markets really want and also how can we really service our clients in a better way and the clients here is not necessarily only for advertisers including our user and also creator altogether. So that's one of the things I think it's very different in terms of TikTok way of work. It's very customer-centric in a way, and again, the customer here is not necessarily only for the business partner but also for our regular user and creators on the platform.
(00:06:39):
And the second one is really thinking about how we take approach on product development. So a lot of times that we take a very rigid approach in terms of product development and oftentimes you see us that experimenting a lot of different things all the same time. And also we do have a lot of engineering and [inaudible 00:07:04] project in the backend to really understand how can we optimize better for the platform. So a lot of time, these are the things that I think TikTok is doing really, really well.
(00:07:14):
The last piece I have to say is the approach for global prioritization. A lot of times that you see a US-born company go global and oftentimes still they are really rooted with the US market and there's nothing wrong with it to be honest, because this is the biggest market for them as I would say for East-born company. I think a lot of times that we can take approach with truly how do we think about globalization and for example, we launched a lot of product not necessarily first in North America. We launched it in South Asia for example, for our shopping, really very big initiative internally for shopping and we launched our really creator fund here in North America. We launched our gaming approach, really serviced our EUI gaming advertisers. Really, really strong over there. So there are a lot of different approach in terms of how do we prioritize our go-to-market and also product development. So that's the part I feel like we're very unique in the market or unique to some of that was the tech company born in the US.

**中文翻译:**
我想主要有三点。第一，是这两家公司对创新的思考方式。Google 有一种非常强烈的“工程实验室”哲学，很多东西都是技术驱动的。他们并不总是试图去迎合市场。然而在 TikTok，除了技术部分，我们有一种非常敏锐的渴望去真正理解市场想要什么，以及我们如何能更好地服务客户——这里的客户不仅指广告主，还包括我们的用户和创作者。这是 TikTok 工作方式中非常不同的一点：它在某种程度上是非常以客户为中心的。
(00:06:39):
第二，是产品开发的方法。很多时候，我们在产品开发上采取一种非常严谨（rigid，此处指高强度、快速迭代）的方法，你会看到我们同时在实验很多不同的东西。我们在后台有很多工程项目来研究如何更好地优化平台。我认为这些是 TikTok 做得非常出色的地方。
(00:07:14):
最后一点是全球优先级的处理方式。很多时候，你会看到一家美国本土公司走向全球，但他们往往仍然根植于美国市场，这本身没错，因为那是他们最大的市场。但作为一家源自东方的公司，我们在思考全球化时采取了不同的方式。例如，我们很多产品并不一定先在北美发布。比如我们的“购物”业务（TikTok Shop），这是一个非常大的内部项目，我们先在东南亚上线。我们在北美推出了创作者基金，在欧洲则针对游戏广告主推出了专门的游戏方案。在如何确定进入市场（GTM）和产品开发的优先级方面，我们有很多不同的做法。我觉得这让我们在市场上非常独特，尤其是相对于那些诞生于美国的科技公司。

---

### [00:08:24] Lenny

**English:**
It reminds me there's this piece by this smart guy, Eugene Wei who wrote a few things about TikTok over the years and just why it's been so successful and one of his really big points is that TikTok can work really well in other markets 'cause it's basically... you don't need to know a ton about the market because it's this algorithm that figures out what people in each market want. Is there anything along those lines you've seen that just has been really fundamental to it working so well in many different markets?

**中文翻译:**
这让我想起了 Eugene Wei 写过的一些关于 TikTok 的文章，他分析了 TikTok 为什么如此成功。他的一个核心观点是，TikTok 在其他市场运作得很好，是因为你不需要对当地市场了解太多，算法会自动弄清楚每个市场的人想要什么。在你的观察中，是否有类似的因素是它在这么多不同市场取得成功的根本原因？

---

### [00:08:51] Ray Cao

**English:**
The algorithm is definitely helping because it is basically the machine is doing a lot of heavy lifting. That's actually I think across the board on a technology company today. The difference is actually how much you are willing to take the heavy lifting over there in the market. By that I mean really sending your troops into the market, hiring your local talent, understanding the culture and really understanding the behavior from those users. I understand the machine can do things, but also at the same time that we need to actually get local talent to fine tune the machine. So there are a lot of conversations about how I would say technology is able to change our life, but I do think that at the end of the day, I do believe technology is a tool.
(00:09:34):
So if we do have a ambition to go global, you have to do one more thing is actually take your step into global. Rather than having the machine do the heavy lifting, you have to really understand in local culture. I had a fun background for my first job is to really doing go-to market research in the Southeast Asia area. I think there was only one thing opened my eyes after a year and a half in this career path is different market have totally different, I would say, culture and these market behaviors are actually coming out of this culture. One of the fun example I always been using was I was doing market research for one of the suppliers for toner and also these ink cartridges for Thailand as a go-to market research. One of the things is always concern to my, at that point, the client was they cannot figure out why their premium product cannot sell in Thailand and then we just figure out because the quality of their printing machine and also their ink cartridges are premium and the quality of the paper and everything is very good.
(00:10:51):
But when you actually do talk to those consumers in those market, the answer is very eye-opening. They literally told me at that time is I don't care. I don't care if your ink cartridges or your printer is at the premium quality, maybe the printer I can use, but I can use compatible ink cartridges or toner for that because my consumer won't care about your printing quality or the majority of my consumer won't care. So in that case you should not necessarily worried about if you are a premium product, it's actually more about how durable, how reliable you're able to print things and people can read.
(00:11:30):
So I think these are the insights I think a lot of times it will be neglected from some of clients or the manufacturers or even the owner of the business because they think that we want to serve this segmentation, but, however, this segmentation is that big in this area. So that's reason why the culture is really the key part from the market. If you don't understand the culture, you won't be able to understand the behavior over there. It's more about that, I think, when we say about globalization or take the product go to market in a global scheme or even build it apart, you have to get your hands dirty and to really understand the local culture so that you can understand local behavior.

**中文翻译:**
算法肯定有帮助，因为机器承担了大量的繁重工作。我认为当今所有的科技公司都是如此。但区别在于你愿意在当地市场投入多少精力。我的意思是，真正派驻团队进入市场，招聘当地人才，理解当地文化，并真正理解用户的行为。我知道机器可以做很多事，但同时我们需要当地人才来“调优”机器。关于技术如何改变生活有很多讨论，但我认为归根结底，技术只是一个工具。
(00:09:34):
所以，如果你有全球化的雄心，你必须多做一件事：真正踏入全球市场。除了让机器干活，你必须真正理解当地文化。我的第一份工作很有趣，是在东南亚做市场调研。在那一年半的职业生涯中，最让我大开眼界的是：不同的市场有完全不同的文化，而市场行为正是源于这些文化。我常举的一个例子是，我曾为一家墨粉和墨盒供应商做泰国市场的调研。当时客户很困惑，为什么他们的高端产品在泰国卖不动，明明打印机和墨盒质量都是顶级的，纸张质量也很好。
(00:10:51):
但当你真正去和当地消费者交流时，答案令人震惊。他们当时直接告诉我：我不在乎。我不在乎你的墨盒或打印机是不是高端品质，打印机我可以用，但墨盒我会用兼容的（非原装），因为我的客户不在乎打印质量，或者说大部分人不在乎。在这种情况下，你不必担心自己是不是高端产品，更重要的是你的产品是否耐用、可靠，打印出来的东西能让人看清就行。
(00:11:30):
我认为这些洞察往往会被客户、制造商甚至企业主忽略，因为他们觉得自己想服务某个细分市场，但实际上那个细分市场在当地并没那么大。这就是为什么文化是市场的关键。如果你不理解文化，你就无法理解那里的行为。所以当我们谈论全球化或将产品推向全球市场时，你必须亲力亲为，深入了解当地文化，从而理解当地行为。

---

### [00:12:16] Lenny

**English:**
I love that advice, the way you described it, which I love also is that you kind of have to fine-tune the algorithm and the product to work in different cultures. Is there an example of how that was done with TikTok, like a tweak that had to be made or some kind of fine-tuning that happened for it to work in a different market?

**中文翻译:**
我非常喜欢这个建议。你描述的方式——必须针对不同文化对算法和产品进行微调。有没有 TikTok 的具体例子？比如为了让它在某个市场运作，必须做出的调整或微调？

---

### [00:12:32] Ray Cao

**English:**
Yeah. I think we did a lot of fine-tuning on our user product side to really think about content. So that's the number one thing going to be super different coming from each of the market and also from each of the culture. For example in Japan, how do you actually get more content that relevant for the culture? A lot of people may think, okay, are you guys only doing dancing or doing singing for Japan? The answer is not. It is actually more food on the TikTok side, like how do you actually introducing new food restaurant or new recipes and also sometimes that you're introducing a new technology. I would say 3C like consumer electronics product over there. So these are the content get really popular sometimes in Southeast Asia or even Japan area and versus in the US as everybody knows that we're starting from really lip-syncing at a very early stage but now really we're expanding to shopping behaviors and also a lot of people using us as a main platform to acquire new discovery for the product.
(00:13:40):
So these are the things I think different market definitely deserves and demand different kind of treatment and if you are able to do this a lot, you're able to find success over there.

**中文翻译:**
有的。我认为我们在用户端产品上做了很多微调，特别是在内容思考上。这是每个市场、每种文化之间差异最大的地方。例如在日本，你如何获得更多与当地文化相关的内容？很多人可能认为，你们在日本是不是只做跳舞或唱歌的内容？答案是否定的。在 TikTok 日本区，更多的是关于美食的内容，比如如何介绍新餐厅、新食谱，有时还会介绍新技术，比如 3C 消费电子产品。这些内容在东南亚或日本非常受欢迎。而在美国，大家都知道我们早期是从对口型（lip-syncing）开始的，但现在我们已经扩展到了购物行为，很多人把我们当作发现新产品的主要平台。
(00:13:40):
所以，不同的市场确实需要不同的对待方式。如果你能做到这一点，你就能在当地取得成功。

---

### [00:13:53] Lenny

**English:**
That's really interesting because you could think it's just this algorithm that figures everything out for you, but I think what you're pointing out is you have to seed it with the right sorts of use cases that that culture is most excited about.

**中文翻译:**
这很有趣，因为人们可能认为算法会自动搞定一切，但你指出的是，你必须用该文化最感兴趣的正确用例来“播种”（seed）。

---

### [00:14:04] Ray Cao

**English:**
Another good example will be creative, so it a very good example how human can work with technology together. We have a ton of creatives and we have a ton of content so, of course, we use machine to label those content use metadata to analyze those content. However, a lot of times you can find that when we're really thinking about how creative can help advertisers? Humans actually make a more interesting or more, I would say, influencing decisions over there. For some of the verticals we can say that, "Oh, you know what, maybe we can try a coupon image with a new product like a sticker on the top?" This maybe actually work better compared to some of the price promotion even. So a lot of things really depends on how do you actually interpreting the numbers and interpreting the data points but also at the same time your business acumen is going to be very important here to make a judgmental call for some of the situation like that. I think we're still rely a lot on both machine and also our own experts to analyzing those trends and give it the recommendations.

**中文翻译:**
另一个好例子是广告素材（creative），这是人类与技术协作的典范。我们有海量的素材和内容，当然，我们使用机器对这些内容进行标记，使用元数据进行分析。然而，当我们思考素材如何帮助广告主时，人类往往能做出更有趣、更有影响力的决策。对于某些垂直行业，我们可能会建议：“嘿，也许我们可以尝试在新品图片上加一个优惠券贴纸？”这可能比单纯的价格促销效果更好。所以，很多事情取决于你如何解读数据，但同时，你的商业敏锐度在做出这类判断时也非常重要。我认为我们仍然在很大程度上依赖机器和专家共同分析趋势并给出建议。

---

### [00:15:11] Lenny

**English:**
Awesome. Okay, so there's a few threads I'm going to follow later. You talked about the product development process, so I'm going to want to spend time there, also about how to be successful in TikTok both as a creator also as a business, I'm excited to hear your advice there. But I want to spend a little more time first on just what it's like to work within TikTok and the culture of TikTok. What are some core principles or values or just how TikTok operates if you had to identify, here's the ways that we all think about what we want to do and the most important to your day-to-day work, what words and concepts come to mind?

**中文翻译:**
太棒了。我有几个话题想稍后深入探讨：你提到的产品开发流程，以及作为创作者和企业如何在 TikTok 上取得成功。但在那之前，我想多花点时间聊聊在 TikTok 内部工作是什么感觉，以及 TikTok 的文化。如果你必须确定一些核心原则、价值观或运作方式，即大家在日常工作中最重要的思考方式，你会想到哪些词汇或概念？

---

### [00:15:43] Ray Cao

**English:**
The number one thing resonating really, really well with me is context, no control. Oftentimes when we are looking around companies different sizes, we're looking at how to collaborate. Oftentimes we see the behavior that a lot of people just working on a smaller piece based off their job description. So hey, you're working on go-to-market and you're working on data analytics, and you're working on this book of business and commerce, and you're working on auto industry for example. A lot of times that these human-made silos is actually slowing things down because humans are not, or our talent, they're not supposed to be categorized into different basket. They may have their own majority responsibility for sure, but we don't want to cap them into this kind of a box we created. That's really why we're always encouraging people to think out of the box and think more and think themselves as a business owner rather than a piece of machine that keep the machine running.
(00:16:49):
Oftentimes that will say context, no control. That means you actually can go above and beyond to really think about your whole business problem as your own problem and your piece is maybe one part of it to solve the puzzle, but how do you actually solve the puzzle by connecting all the dots together, we're encouraging all the people to think like that way and by that I think we kind of mentally break out those walls. So encouraging our team members to do a little bit more thinking is very important. It's a little bit more thinking because the think part is very important.
(00:17:23):
And then, now in terms of getting things into behavior or changes or getting to action, then you need to really collaborate with other teams because we don't want to necessarily creating, hey, you're on other people's working group now you're actually stepping on other people's toes now. It is not the situation we're trying to encourage in, but where it's encouraging more is context, no control, think more about how you can change it and then we you do really actually take some actions, be active. You reach out to who's supposed to be the owner of that and then have a discussion so then you you're able to connecting the dots altogether.
(00:18:00):
So that's one thing I think it's very unique to our culture. I think it's very, very important for us to continue to grow at this speed because everybody have a, I would say, full visibility towards our full ownership to their mindset, how they can contribute.

**中文翻译:**
最让我产生共鸣的一点是“提供情境，而非控制”（Context, no control）。通常在不同规模的公司里，我们会观察人们如何协作。很多时候，人们只是根据职位描述（JD）负责一小块工作。比如，你负责市场推广，你负责数据分析，你负责电商业务，你负责汽车行业。这些人为制造的“孤岛”往往会拖慢进度，因为人才不应该被归类到不同的篮子里。他们当然有主要职责，但我们不想把他们限制在人为制造的框框里。这就是为什么我们总是鼓励大家跳出框框思考，把自己看作业务所有者，而不是维持机器运转的一个零件。
(00:16:49):
“提供情境，而非控制”意味着你可以超越职责范围，把整个业务问题看作自己的问题。你的部分可能只是解开谜题的一环，但我们鼓励每个人思考如何通过连接所有的点来解开整个谜题。通过这种方式，我们在心理上打破了那些围墙。鼓励团队成员多思考一点非常重要，因为“思考”这个环节至关重要。
(00:17:23):
然后，在将想法转化为行动或变革时，你需要与其他团队协作。我们不希望造成“你进入了别人的工作组，踩到了别人的脚趾”这种局面。我们鼓励的是：在了解情境的基础上，多思考如何改变，然后积极采取行动。主动联系相关负责人进行讨论，从而把点连接起来。
(00:18:00):
我认为这是我们文化中非常独特的一点。对于我们保持这种增长速度来说，这非常重要，因为每个人都对如何贡献力量有着全局视野和主人翁意识。

---

### [00:18:16] Lenny

**English:**
And the key there is context implying you give them all the information they need and then let them just do things without giving them specific instructions, "Hey, I need you to hit this goal, work on this project, launch this thing. Here is what we know, do the things you think are best, roughly." Right now, I know it's not just like anyone does anything, but I imagine that's kind of the implication there.

**中文翻译:**
这里的关键是“情境”，意味着你给他们提供所有需要的信息，然后让他们在没有具体指令的情况下开展工作，而不是说：“嘿，我需要你达成这个目标，做这个项目，发布这个东西。” 而是说：“这是我们掌握的情况，去做你认为最好的事情。” 我知道这不代表任何人可以随心所欲，但我猜这就是其中的含义。

---

### [00:18:35] Ray Cao

**English:**
Yeah, I think it's context, no control plus proactive thinking and reactive doing so you have to do more proactive thinking with these contexts. Now reactive doing means that you need to collaborate, but when everybody has this kind of mindset, the collaboration should be very smooth because people have the context altogether. The part that I see maybe some of the other company are facing challenges is actually there's too many IOs in between and you have people that are just protecting their own thing and working their own thing and then I'm delivering. But just like how I see some of my friends, their kids playing Legos, if you don't really see the full picture, you won't be able to make the Lego as a one thing at the end of the day. You have to see the other pieces. So that's the part I think it's really powerful and reasoning really, really well when we're really thinking about product development and also product go-to-market. So it's a pretty full cycle. People have to see this and then they have the context.

**中文翻译:**
是的，我认为是“情境而非控制”加上“主动思考，响应式执行”。在了解情境后，你需要更多的主动思考。而“响应式执行”意味着你需要协作，但当每个人都有这种心态时，协作会非常顺畅，因为大家共享情境。我看到其他公司面临的挑战往往是中间环节太多，人们只顾保护和完成自己的那一小块工作。就像我刚才说的乐高例子，如果你看不见全景，你就无法拼成一个整体。你必须看到其他部分。在产品开发和市场推广中，这种全周期的视野非常强大。

---

### [00:19:35] Lenny

**English:**
I love this, and this has come up actually a few times recently when I was talking to the CTO of Netflix and also OpenAI. They're very similar in culture where it's give people a lot of autonomy and freedom and not a lot of do this, do this, do this. The key there is to hire very high quality people and very high caliber people because if not, then things won't work out too great. Is there anything along those lines you can share just like yeah, the kinds of people you end up hiring and how you hire people that can work well in that environment?

**中文翻译:**
我喜欢这个观点。最近我和 Netflix 的 CTO 以及 OpenAI 的人聊天时也提到了这一点。他们的文化非常相似：给员工极大的自主权和自由，而不是不停地下达指令。关键在于招聘高质量、高水平的人才，否则这种模式行不通。关于这一点你有什么可以分享的吗？比如你们会招什么样的人，以及如何招到能在这种环境下高效工作的人？

---

### [00:20:05] Ray Cao

**English:**
I agree with you. So the caliber of these people is actually pretty important to support the structure I just talked about, and oftentimes I can see some people that with the quality of always curious. Curiosity is a very important quality when I'm actually talking to my interviewers because I want to see that they are naturally curious to new things. They want to learn more about the new things and don't really get stuck with their own things. That's one thing. And the other thing is the discipline because like I said, it is actually a double-edged sword in this case. So it could potentially introducing some of the chaotic situation in a company because everybody is thinking everything. The discipline here is actually how you are really following the guidance on reactive doing, be always thinking about how to collaborating, and the discipline here and also the rigorous approach here is also going to be very important.
(00:21:07):
One of the good example that is the ability to prioritize because I don't believe one thing is everybody can do everything. You have to prioritize properly so that you're able to push the right agenda. So I think that's more of the quality of the people we're looking for is... it is hard, don't get me wrong. It is really hard to say that we can find everyone like that, but we would love to believe that we can train our employees like that so that they're able to even do better in their longer-term career.

**中文翻译:**
我同意。人才的水平对于支持我刚才提到的结构至关重要。我经常看到成功的人具备“始终保持好奇心”的特质。在面试时，好奇心是我非常看重的品质，我想看到他们对新事物有天然的好奇，想要学习新东西，而不是固步自封。这是其一。其二是自律（discipline），因为正如我所说，这种模式是一把双刃剑，如果每个人都在思考所有事情，可能会导致混乱。这里的自律体现在如何遵循“响应式执行”的指导，始终思考如何协作。严谨的方法论也非常重要。
(00:21:07):
另一个例子是优先级排序的能力。我不相信每个人都能做所有事情，你必须正确排序，才能推动正确的议程。所以，这些是我们寻找的人才特质。这很难，真的很难找到每个员工都具备这些特质，但我们相信可以这样培养员工，让他们在长期的职业生涯中表现得更好。

---

### [00:21:38] Lenny

**English:**
Essentially what you look for when you're hiring people is making sure they're always curious, they have high discipline, and that they prioritize well. Coming back to the cultural pieces of TikTok, so the main one you've shared so far is this idea of context, not control. What else are important cultural values of TikTok, of how TikTok operates that everyone always has in mind when they're building and new meetings, making decisions?

**中文翻译:**
本质上，你招聘时看重的是：始终保持好奇心、高度自律以及擅长排序优先级。回到 TikTok 的文化，你目前分享的核心是“情境而非控制”。还有哪些重要的文化价值观是大家在构建产品、开会或做决策时始终遵循的？

---

### [00:22:04] Ray Cao

**English:**
Yeah, another internal thing that we always say is always day one, we want to make sure that we always have this mentality we are a startup. We are a young company. We're always hungry for growth. We don't want to fall into the trap that people may think, "Oh, you guys are very successful in the market and then you are not necessarily need to worry about your existence anymore." I think it is actually something we're trying to avoid. We always want to make sure that in our team members always think like, "Okay, if this is actually a new day for you, I know what other things that you always want to keep in your mind you want to do." And also to keep that spirit is very important.
(00:22:42):
A lot of times that I can see some of the mature company, they're not necessarily losing the edge of, I would say this competition or losing the edge of being innovative. I think it's more about some of the culture has been shifted because you have a lot of new employees that live in your culture. So not necessarily it's not going to be like the old days that the co-founder is sitting among you, but I do think this company has a very interesting behavior. I see there is I can talk to anyone at any time via our internal communication system. I can ping Shuo right now. I can ping the co-founder if I want to tomorrow.
(00:23:24):
We always keep this kind of mentality internal is that we're still a young company, we want to grow and you can feel free to talk to anyone. We don't have a limitation for that as long as you have a good opinion, I would love to hear from you. Is that creating some of the, I would say chaotic situation? It might be, but I do think that this keeps the company very energetic. People are willing to share, people are willing to engage. That's very important.
(00:23:50):
I want add one more thing. We just talked about, you asked me what is actually the uniqueness of TikTok versus the other company. It's very tied up to that is I have never seen a company, the engineering team and the product team and the sales team are so close. That's definitely one of aha moments I had because if you're thinking about if your engineer does not really know what the market wants and if your PM doesn't really know what is actually the client's feedback, they won't be able to get a right product in the market. They just won't be. And they won't even tell a good go-to-market story to advertisers or even to our users because they just don't know what the end users are thinking.
(00:24:39):
So I think it's a very secret sauce for us is that our sellers and our engineering team and our product team and also data scientist team, we're all collaborating really, really closely and that's very much, I would say a such big advantage for us compared to when a company becomes too big and nobody talks to each other. So I do hope that it is the thing that we're going to continue reinforce along the years where we'll continue to grow the company.

**中文翻译:**
是的，内部常说的另一句话是“始终创业”（Always Day 1）。我们要确保始终保持初创公司的心态。我们是一家年轻的公司，始终渴望增长。我们不想掉入“我们已经在市场上非常成功，不再需要担心生存”的陷阱。这是我们要极力避免的。我们希望团队成员始终觉得：“如果今天是新的一天，你最想做的事情是什么？”保持这种精神非常重要。
(00:22:42):
很多成熟的公司未必是失去了竞争优势或创新能力，更多是文化发生了偏移，因为大量新员工进入。虽然不像早期那样联合创始人就坐在你身边，但这家公司有一种很有趣的行为：我可以通过内部通讯系统随时联系任何人。我现在就可以发消息给周受资（Shuo），明天也可以联系联合创始人。
(00:23:24):
我们内部始终保持这种心态：我们仍是一家年轻公司，我们想成长，你可以随时找任何人交流。只要你有好的想法，大家都愿意倾听。这会造成混乱吗？可能会，但我认为这让公司保持了活力。人们愿意分享和参与，这非常重要。
(00:23:50):
我还想补充一点。你问 TikTok 与其他公司的不同之处，这与此紧密相关：我从未见过哪家公司的工程团队、产品团队和销售团队如此紧密。这是我最深刻的感悟之一。如果工程师不知道市场想要什么，如果 PM 不知道客户的反馈，他们就无法做出正确的产品。他们甚至无法向广告主或用户讲好一个市场故事，因为他们不知道终端用户在想什么。
(00:24:39):
所以，我们的“秘密武器”就是销售、工程、产品和数据科学团队极其紧密地协作。相比那些规模变大后各部门互不说话的公司，这是我们的巨大优势。我希望在公司未来的成长中，我们能继续强化这一点。

---

### [00:25:09] Lenny

**English:**
What does that actually look like? I imagine people hearing this are like, "Yeah, we're going to make sales and product and hinge very close." I imagine many people don't actually do this too well. How do you actually execute that? Is it they report to the same leader, they sit next to each other or I don't know, zoom next to each other? What actually makes that work?

**中文翻译:**
这具体是怎么实现的？我想听众可能会说：“对，我们要让销售和产品紧密结合。” 但很多人其实做不好。你们是如何执行的？是汇报给同一个领导，还是坐在一起，或者在 Zoom 上频繁交流？到底是什么让这种紧密协作发挥作用的？

---

### [00:25:28] Ray Cao

**English:**
Yeah, I think a couple of things. Number one is a structure. Everything has to go at a structure. So we do have a meeting structure that we called it... it used to be by month and now it's actually a quarterly level. We get everybody together, engineering leader, product leader, and also not necessarily only the leader level. Some of the team members, we're joining the force together to have a big meeting. That meeting is 180 people-ish. It's crazy to have a meeting at that size, especially that there are different kind of functionality there. But one thing we keep really well is actually we are using a reading format of meeting. So it's a doc reading. We just read in comments and understanding the context again. It is the doc, bring everybody together, and then we discuss the things that we want to make a decision with or the things that we feel is a blocker or things that we need to celebrate.
(00:26:24):
So that meeting structure keep everybody together and consensus, again, not necessarily only for the top leaders. It's normal for the engineering leader and product leader and sales leader at the company level, they talk to each other, but we made that happen for their core team members. And the very beginning of my time here, that was literally getting to the IC level. So it is pretty eye-opening for me to join that meeting first time because I was get so used to their level of different meetings at Google, but here it's like, okay, everybody read one documentation and then you just understand what are people talking about or thinking about. It is intentional. But I do think that that structure is a very big secret sauce, I would say, not necessarily we invented it, right? We also learned from the other companies. So it is actually one of the things that we actually deployed pretty well today here to keep that structure running.
(00:27:22):
And the other thing is really feed those, I would say, first-hand market information to our PMs and RDs. That means we took them out with us. We're just inviting them together to join the force together to meet the clients and a lot of the company, if you want to meet APMs, if you want to meet the engineering leaders, it's literally once a year maybe, and also if you're investing a ton with some of the platforms. For us, I think it's always on to junior PMs, senior PMs and engineering leaders. We invited them together to these immersion trips recorded to really get face time with our clients, to really feel the heat. They are actually really facing a challenge by using our own product.
(00:28:07):
So that kind of, I would say, the aha moment is bringing a lot of, I would say, insights to them and also get them to feel the heat of the pains the sellers may feel. So that worked really well, too. I think oftentimes it is a battle. It is not necessarily the general, you have to stay in the back, you sometimes have to go to the front, but we just make sure that the general go to the front quite often in our company to do that.

**中文翻译:**
我认为有几点。第一是结构。一切都必须有结构。我们有一种会议结构，以前是按月，现在是按季度。我们会把所有人召集在一起：工程主管、产品主管，而且不仅是主管级别。一些团队成员也会加入，形成一个大约 180 人的大项目组。这种规模的跨职能会议听起来很疯狂，但我们保持得很好，因为我们采用“文档阅读”模式。大家先读文档，在文档里写评论，再次同步情境。文档把大家聚在一起，然后我们讨论需要决策的事项、阻碍因素或值得庆祝的事。
(00:26:24):
这种会议结构让大家达成共识，而且不仅限于高层。在公司层面，工程、产品和销售主管互相交流很正常，但我们让核心团队成员也参与进来。我刚加入时，这种交流甚至深入到了 IC（个人贡献者）级别。这让我大开眼界，因为我习惯了 Google 那种层级分明的会议，而在这里，所有人读同一份文档，了解大家在想什么。这是刻意设计的。虽然这种结构不是我们发明的（借鉴了其他公司），但我们执行得非常好。
(00:27:22):
第二点是将第一手的市场信息反馈给 PM 和研发（RD）。这意味着我们会带他们一起出差。我们邀请他们一起去见客户。在很多公司，如果你想见 PM 或工程主管，可能一年才一次，除非你是超级大客户。但在我们这，初级 PM、高级 PM 和工程主管经常参加我们所谓的“沉浸式考察”（immersion trips），与客户面对面，真正“感受热度”（feel the heat）。他们能亲身感受到客户在使用我们产品时面临的挑战。
(00:28:07):
这种“顿悟时刻”为他们带来了大量洞察，让他们感受到销售人员面临的痛苦。这非常奏效。这就像打仗，将军不能总待在后方，有时必须上前线。我们确保我们的“将军”经常出现在前线。

---

### [00:28:36] Lenny

**English:**
I love that concept of having them feel the heat. An interesting trend I've noticed is there's a lot of Amazon influence on the way you all operate. It's always day one idea. There's the memo culture you just described. Any idea where that comes from? Is there like a senior Amazon person that came in and helped influence those sorts of things? Is it just hey, Amazon's killing in there? I've noticed interestingly, Amazon has influenced the most companies in all of their ways of working, so it's not a surprise. I'm just curious if there's anything else there that's interesting.

**中文翻译:**
我喜欢“感受热度”这个概念。我注意到一个有趣的趋势，你们的运作方式深受 Amazon 的影响。比如“始终创业”（Always Day 1）的理念，还有你刚才描述的文档（memo）文化。你知道这是从哪来的吗？是有 Amazon 的高管加入并带来了这些影响，还是单纯觉得 Amazon 的做法很棒？我发现 Amazon 对很多公司的运作方式影响最大，所以我并不意外，只是好奇有没有什么有趣的故事。

---

### [00:29:04] Ray Cao

**English:**
I think we have the benefits to standing on the shoulder of all the giants. So we learned definitely always there when the culture that Amazon was always championing, I think we learned from them. So this is something that we, I would say, always trying to listen and trying to learn from industry. The dark fashion is also learned from Amazon, so we kind of studied, oh, this is maybe one of the best practices we can employ here, how we deploy here. So we tried it, not even mentioned we have the OKR system, so it is actually a very good learning from our early stage from Google. So all these, I think definitely we do have some of the, I would say, benefits being the newcomer to the market and then learn a lot of the best practices coming from our industry peers and really deployed here hopefully successfully.
(00:29:53):
And some of the things that we just tweaked. So for example our culture always day one is definitely very similar to Amazon, but the implementation of that could be different. And also the context, no control piece is, I believe other companies may have the similar idea, but for us I think we just really need to implement it in a way that's going to be fitting to us. I happened to listen to your podcast with the Airbnb co-founder the other day. He also mentioned that how he break out the IOs. I think it is very similar approach among industry right now trying to really make sure the team is able to talk to each other because I think a quote from him, "If your PM doesn't know how to sell the product they're creating, you won't be able to do your job better." So this is literally how we're thinking about it, too, in a lot of way.

**中文翻译:**
我认为我们受益于“站在巨人的肩膀上”。我们确实学习了 Amazon 倡导的文化。我们始终尝试倾听并向行业学习。文档文化也是向 Amazon 学习的，我们研究了这些最佳实践并思考如何在这里落地。此外，我们的 OKR 系统很大程度上借鉴了 Google 早期的经验。作为市场的后来者，我们确实有优势去吸收同行的最佳实践并成功应用。
(00:29:53):
当然，我们也做了一些微调。比如“始终创业”虽然和 Amazon 相似，但执行方式可能不同。“情境而非控制”在其他公司可能也有类似想法，但我们以适合自己的方式去实现。我前几天听了你和 Airbnb 联合创始人的播客，他也提到了如何打破部门孤岛。我认为现在行业内的趋势非常相似，都是为了确保团队之间能够顺畅交流。引用他的一句话：“如果你的 PM 不知道如何推销他们创造的产品，你就无法把工作做得更好。” 这在很大程度上也是我们的想法。

---

### [00:30:40] Lenny

**English:**
I know that you all move very fast and I want to actually talk about that next. And with that it feels like your value should be, it's always the first half of the day instead of it's always day one. It's always the morning of the first day.

**中文翻译:**
我知道你们动作非常快，接下来我想聊聊这个。感觉你们的价值观不应该是“始终创业”，而应该是“始终是第一天的上午”。

---

### [00:30:53] Ray Cao

**English:**
I think the value, if I put it in a very reactive way is, "How can I run my second half of my marathon faster than the first half?" So that's how I think about it and how do we really continue pushing for it.

**中文翻译:**
如果用一种更具挑战性的方式来表达，那就是：“我如何能让马拉松的后半程跑得比前半程更快？” 这就是我的思考方式，也是我们不断推动的方向。

---

### [00:31:09] Lenny

**English:**
Wow, that sounds very hard and painful, but I like that metaphor. Okay, so let's talk about how you set up the product org to move as fast as you move. I think there's this idea of just running fast. I don't know if that's a phrase you use, but just how is the product org set up, especially different from other teams that you've seen that allows it to move as quickly as you move and innovate as often as you all innovate?

**中文翻译:**
哇，这听起来非常辛苦且痛苦，但我喜欢这个比喻。好，那我们聊聊你是如何设置产品组织的，以实现如此快速的运转。你们的产品组织架构与你见过的其他团队有什么不同，从而让你们能如此迅速地行动和创新？

---

### [00:31:34] Ray Cao

**English:**
Our product teams are setting, I would say, very importantly is global. So we want to actually, like I said, the number one step is if we really want to do global business, we have to go global. So we set up teams really across the board in the global locations to really acquire global talent who knows the market and who knows the competition, too. So we're able to really getting the, let's say jumpstart, in the local market. So for example, we have the majority of the engineer and also PMs currently located in the west coast of North America, so Los Angeles and also San Jose. These are the key hubs we have for our tech folks and also for North America wise we do have our majority of the go-to-market leads sitting in New York to get closer with our seller and also with our clients at the same time.
(00:32:27):
Also, it is not necessarily only for North America. Like I said, we heavily invested in Southeast Asia, so you can see that a lot of our engineering and also PM resources are deployed over there in Singapore to enable them to get closer to our clients over there as well. So really deploy your resources globally and also focusing on the key markets you want to penetrate. That's the commitment. I think we're doing pretty good in this case. And the second one is to really, again, I think the PMs and the product team of settings are oftentimes I would say because we're growing so fast, oftentimes we have to do a lot of minor team adjustment to catering for that. So it is very usual or common for teams to do a little bit of work on an annual basis or even on a two years or three year cycle. The stability is important, don't get me wrong, but I do think that as a faster growing company, we need to consistently to reiterate not only the product but also our teams.
(00:33:33):
So how can we do reiteration on the PM side, on the go-to-market side, it is actually something that I have seen this company doing really, really well. Not necessarily we're bonding to one team structure. We're actually bonding to the market need and we're bounding to the growth we're looking for. So we're not afraid to break our seams. And actually I literally break out my team last year to make sure that my team having more go-to-market mindset to actually embedded them with seller directly. So these are the things that very, I would say, conventional to a size of this company, but I do think that's necessary and also that's a good mentality for the team to really run faster with this kind of a rigid approach. So yeah, these are the two things I think very unique to us, I think could also be continuously helping us in the next phase of the growth.

**中文翻译:**
我们的产品团队设置中，最重要的一点是“全球化”。正如我所说，如果我们想做全球业务，就必须真正走向全球。我们在全球各地设立团队，招聘了解当地市场和竞争情况的全球人才。这样我们就能在当地市场快速启动。例如，我们大部分工程师和 PM 位于北美西海岸（洛杉矶和圣何塞），这是我们的技术枢纽；而北美的市场推广（GTM）负责人大多在纽约，以便更接近我们的卖家和客户。
(00:32:27):
这不仅限于北美。我们在东南亚也投入巨大，很多工程和产品资源部署在新加坡。将资源部署在全球，并专注于你想渗透的关键市场，这是一种承诺。我认为我们在这方面做得很好。第二点是，由于增长太快，我们经常需要对团队进行微调。在很多公司，团队结构可能两三年不变，但在我们这，每年甚至更短时间内进行调整是很常见的。稳定性固然重要，但作为一家快速成长的公司，我们需要不断迭代——不仅迭代产品，也迭代团队。
(00:33:33):
如何对 PM 和 GTM 团队进行迭代，是这家公司做得非常出色的一点。我们不绑定于某一种团队结构，而是绑定于市场需求和增长目标。我们不害怕打破现有的结构。去年我就拆分了我的团队，以确保他们具备更强的市场思维，并直接嵌入到卖家业务中。对于这种规模的公司来说，这可能显得有些反传统，但我认为这是必要的，这种心态能让团队跑得更快。

---

### [00:34:33] Lenny

**English:**
[Sponsor Message: OneSchema]
(00:35:38):
I know you mentioned earlier when we were chatting offline is when you were trying to build the go-to-market org for this stuff, you failed in some ways and there's some things you learned from that experience. What went wrong when you first tried to approach this?

**中文翻译:**
[赞助商信息：OneSchema]
(00:35:38):
我记得我们私下聊天时你提到过，当你最初尝试建立 GTM 组织时，在某些方面失败了，并从中吸取了教训。当时出了什么问题？

---

### [00:35:51] Ray Cao

**English:**
Yeah, when I joined the company, there were only two people on the go-to-market side.
(00:35:57):
[Lenny: For the advertising business.]
(00:36:00):
There are only two people and by that time the US and plus, I would say, Europe business together, we're having less than 80 people, but the business needs to grow and we need to hire really fast. The first mistake I made was... By the way, the goal is to hiring 100 people in a six month to support the go-to-market. That is the speed we're into. So that is early 2020 to middle of 2020. So within six months I need to hire, I would say, 100 people to supporting the global go-to-market structure and build everything. Then the first mistake I made just at the right point because we're trying to grow too fast and sometimes as a hiring manager I have to compromise the standard we're trying to hire. So that's the mistakes I think I made first and I think nobody should repeat that mistake is you need to always run for the quality rather than the quantity. So it's a easy mistake. You can fall into the trap because the business demands you to go faster. If you don't have the manpower, you won't be able to.
(00:37:11):
But I would say, believe me when I say this, this is a pain, right, when you have the wrong people on the team, it's not necessarily going to make you move faster, it's going to actually slow you down. So that's one of the biggest mistake I made for my first year when I created the team and not necessarily myself only. So also the managers reporting to me, they're facing the same pressure and then it's cascading down. So it's definitely the mistakes we made at early stage.
(00:37:43):
The second thing I can think about is really on the context, no control. It is not necessarily I'm born into, to be honest, because I was trained really like, "Hey, this is your box, finish your work here and then you're good." But the reason why I value that really the attitude more today is literally I failed at the very early stage of my time here because I was trying to creating that kind of a very black and white discipline for my team, "You can do this, you cannot do that." But technically speaking, that's literally slowing things down because a lot of times you can find that, "Hey, we're delivering our go-to-market strategy and we're good." But literally what you don't know is your goal is not to deliver the go-to-market strategy. Your goal is to land your go-to-market strategy with sales together. So if your job only is delivering, no, you're failed oftentimes because you're not really getting the market context, you're not even talking to your clients. So that was literally another mistake I think taught me how to really embrace the culture. Here is context, no control.
(00:38:52):
And the third piece, I think, it's also a mistake, really a hard moment for me as well is, for the past couple of years now, I've been managing a such big global organization, oftentimes even not myself, my managers, they don't have time to go detail and to go talk to the clients, which is very scary because again, if you don't know, you don't hear what is happening in the market, you won't know the details in the market, you won't be able to take the right movement or take the right approach to go to market or even give the feedback to the engineering team.
(00:39:32):
So it's very important that the leader at any level needs to be situational. You cannot always down to the wheat and you cannot really distance yourself from the reality. So you need to find the balance to really get engaged and also see yourself out there to getting, I would say, getting deeper into the problems, to identify the problems, and then you're able to perform even better. Because I don't believe one thing is you are the pure, I was the people manager. You cannot do that because when you do that, you're very, very at the very, I would say, position to really thinking about your career because you're losing your competitive edge from the other, I would say equivalent talents in the market.

**中文翻译:**
是的，我刚加入公司时，GTM 团队只有两个人。
(00:35:57):
[Lenny: 负责广告业务。]
(00:36:00):
只有两个人，当时美国加欧洲的业务团队总共不到 80 人，但业务需要快速增长，我们需要飞速招聘。我犯的第一个错误是……顺便说一下，当时的目标是在 6 个月内招 100 人来支持 GTM。那是 2020 年上半年。为了赶进度，作为招聘经理，我有时会降低招聘标准。这是我犯的第一个错误，我不希望任何人重复这个错误：你必须始终追求质量而非数量。这是一个很容易掉进去的陷阱，因为业务逼着你跑快，没有人力你就跑不动。
(00:37:11):
但请相信我，招错人是一种痛苦。错误的人不会让你跑得更快，反而会拖慢你。这是我第一年组建团队时犯的最大错误，不仅是我，向我汇报的经理们也面临同样的压力，这种压力会向下传导。
(00:37:43):
第二点是关于“情境而非控制”。说实话，我并不是天生就适应这种方式，因为我受到的训练是：“这是你的框框，完成工作就行。” 我现在之所以如此看重这种态度，是因为我早期失败过。我曾试图为团队建立非黑即白的规矩：“你可以做这个，不能做那个。” 但从技术上讲，这拖慢了进度。很多时候你会发现，“嘿，我们交付了 GTM 策略，我们完成任务了。” 但实际上你的目标不是交付策略，而是与销售一起落地策略。如果你只负责交付，你就失败了，因为你没有获取市场情境，甚至没和客户交流。这让我学会了真正拥抱“情境而非控制”。
(00:38:52):
第三点，也是让我感触很深的一点：在过去几年管理大型全球组织的过程中，我发现有时甚至连我的经理们都没时间深入细节去和客户交谈。这很可怕，因为如果你听不到市场的声音，不知道细节，你就无法做出正确的决策，也无法给工程团队提供反馈。
(00:39:32):
所以，任何级别的领导者都需要具备“情境化”的能力。你不能总是埋头苦干，也不能脱离现实。你需要找到平衡点，深入问题，识别问题，这样你才能表现得更好。我不相信所谓的“纯粹的人事经理”。如果你只管人，你会失去竞争力，因为你脱离了业务前线。

---

### [00:40:18] Lenny

**English:**
I love these stories. I love stories of things not working out, so I appreciate you sharing these things. When someone doesn't work out at TikTok and they have a bad time and they get let go or they leave, what's the most common reason other than just they're not good enough? Is there something that just doesn't stick with people that often leads to this is not the place for me?

**中文翻译:**
我喜欢这些故事，尤其是那些关于失败的故事，感谢你的分享。当有人在 TikTok 表现不佳、过得不开心并最终离开或被解雇时，除了“能力不够”之外，最常见的原因是什么？有没有什么特质是人们难以适应，从而导致他们觉得“这里不适合我”的？

---

### [00:40:36] Ray Cao

**English:**
Yeah, I would try to really thinking about this in a different way. I can tell how people can be more successful here. So I definitely can see we're just talking about people being very curious and people are very, being nimble. They can be more successful here. At the same time, I think we have to admit one thing, join a start-up and join a rocket ship is a lifestyle. It is not necessarily a job you are working on from 9 to 5. So it is a different lifestyle and it is not built for everyone. So if you are not able to adjust your mentality towards some of the work that we are here to do and it's maybe not right fit for you. I'm not saying that that candidates is incapable. I think they could be capable in the other scenario for sure, but is the right fit? I think that is, I would say very much towards the situation or the company status in the market.
(00:41:33):
I can see a lot of people that they left and become very successful, too. So it is not necessarily that, "Oh, we think you're not good and then you're going to be not good for every single other company." That's not the case.
(00:41:46):
And one thing, and also this is my team culture I try to create is, I'm happy to say that when an employee reach out to me, say, "Hey Ray, I'm actually leaving the company," as long as they're telling me that they're going to a better place or a place that they can continue to grow their career, I'm happy for them because oftentimes my last question during my interview is, "What is actually your goal in the next three to five years?" And also I'd be really honest with them, say, "Hey, I don't think this is the job for you forever. Nobody going to work in this forever. If you can, great. But what is really your North Star?" I think that's the part that I would love to co-partner with you because I always believe one thing is it is not only about achieving the company goal, it's also achieving really the career goal or your employee's career goal together.
(00:42:41):
So I want to creating that culture here as well. So yeah, I think I'm doing so far so good. Most of my team members when they actually are moving on internally or externally, I'm able to say that, "Okay, that's a good choice. If I were you, I may probably do the same thing." It is actually a very good culture, I think, I would love to champion across.

**中文翻译:**
我想换个角度来回答。我可以告诉你什么样的人在这里更容易成功。好奇心强、灵活敏捷的人更容易成功。同时，我们必须承认一点：加入一家初创公司、登上一艘“火箭飞船”是一种生活方式，而不仅仅是一份朝九晚五的工作。这是一种不同的生活方式，并不适合所有人。如果你无法调整心态来应对我们这里的工作，那么这里可能不适合你。我不是说这些候选人没有能力，他们在其他环境下肯定很有才华，但关键在于“匹配度”。
(00:41:33):
我看到很多人离开后也变得非常成功。所以并不是说“我们觉得你不行，你在其他公司也不行”，完全不是这样。
(00:41:46):
还有一点，也是我努力在团队中建立的文化：当员工告诉我他们要离职时，只要他们是去更好的地方，或者能继续发展职业生涯的地方，我都会为他们感到高兴。在面试时，我的最后一个问题通常是：“你未来三到五年的目标是什么？” 我会很诚实地告诉他们：“我不认为这份工作是你永远的归宿，没人会永远在这里工作。但你的‘北极星’目标是什么？” 我希望能成为你的合作伙伴，因为我相信，这不仅关乎达成公司目标，也关乎达成员工的职业目标。
(00:42:41):
我想在这里建立这种文化。目前为止效果不错。当我的团队成员内部调动或外部跳槽时，我通常能说：“这是一个好选择，如果我是你，我可能也会这么做。” 我认为这是一种非常好的文化。

---

### [00:43:03] Lenny

**English:**
On that first point, I'm also a huge advocate of just, "You'll be successful if you work very hard." I know there's a bit of a backlash at working along and thinking too much about work-life balance. And I feel like it's actually really important to work a lot and work long hours often to be successful, especially at a company that's going through this 'cause that's not going to last forever.

**中文翻译:**
关于第一点，我也非常推崇“努力工作才能成功”。我知道现在对于长时间工作和过度强调工作生活平衡有一些反弹。但我认为，要取得成功，尤其是在一家处于高速发展期的公司，投入大量时间和精力是非常重要的，因为这种机会不会永远持续下去。

---

### [00:43:22] Ray Cao

**English:**
I think at the end of the day it's a personal choice. It's very much like a personal choice. If you are excited about this, if you want to grow together, yeah, this maybe is a good thing for you. And also depends on the life stage. Some of the people they want to actually getting more family time, I think that's also the right choice, too. But it just depends on your, I would say, your personal choice rather than if the company demands that. I mean, I cannot force my team to working long hours. I don't want them to working long hours. I think it's more about if you are able to deliver, right? If it requires a bit, a longer time to contribute, I think it's okay, but you'll also get rewarded very well too. So what's get in, what's get out. So I think it's, again, I do believe that this is the quality and also the value we're evaluating here as well.

**中文翻译:**
我认为归根结底这是一种个人选择。如果你对此感到兴奋，想和公司一起成长，那么这很适合你。这也取决于人生阶段，有些人想要更多的家庭时间，那也是正确的选择。这取决于个人选择，而不是公司强求。我不能强迫团队加班，我也不希望他们加班。关键在于你是否能交付成果。如果需要多花点时间来做出贡献，那没问题，你也会得到丰厚的回报。有投入就有产出。这也是我们评估人才的一种品质和价值观。

---

### [00:44:59] Lenny

**English:**
I know you mentioned you do OKRs just briefly, is there anything that you've learned about being successful doing OKRs within TikTok? Maybe is there anything different that you all do versus how other companies think about OKRs?

**中文翻译:**
你刚才简要提到了 OKR，在 TikTok 内部执行 OKR 方面你有什么心得吗？你们的做法与其它公司有什么不同吗？

---

### [00:45:06] Ray Cao

**English:**
It is definitely a company alignment that we are using OKR as our basically the system to make sure that everybody is working towards the same goal. I think definitely we have a lot of room to improve. So how often do you actually see your team able to go to OKR at the end of a quarter and also putting OKR really two weeks or one week before the beginning of a quarter? I have to say that shame on me. I sometimes delay it a little bit, but I think the goal is always there to using OKR system as our North Star to drive the behavior and also to align. Again, it's very important to align on the OKRs because I can see a lot of times the OKRs are putting in, but they are very siloed and that is not really necessarily helpful for the company want achieving really high growth. So I think it's very important that we know we don't take OKR as a shell, but we take OKR as its core is cross-functional alignment, cross-functional goal silo. So these are the things we're still continuing improving.

**中文翻译:**
OKR 确实是我们确保全公司目标一致的系统。我认为我们还有很大的改进空间。你多久能看到团队在季度末复盘 OKR，并在季度开始前一两周定好新的 OKR？坦白说，我有时也会拖延。但我们的目标始终是把 OKR 作为驱动行为和对齐目标的“北极星”。对齐非常重要，因为我见过很多时候 OKR 只是各做各的（siloed），这对追求高速增长的公司没好处。我们不把 OKR 当作一个空壳，而是将其核心视为跨职能的对齐和目标拆解。这些是我们仍在不断改进的地方。

---

### [00:46:06] Lenny

**English:**
Is the way that OKRs work at TikTok, is there an OKR per team and they all kind of trickle up to a company level OKR? Is it less structured that way and teams decide if they want to use OKRs or not? How does that roughly work?

**中文翻译:**
TikTok 的 OKR 是怎么运作的？是每个团队都有 OKR 并最终汇总到公司层面吗？还是结构没那么严密，由团队自行决定是否使用？

---

### [00:46:17] Ray Cao

**English:**
The structure is, basically the guidance is, using the key result to evaluating and then you put the steps in between. So that's how at least my team has been using this. I think the things that we can improve is the input and output. So the output is very clear, but what is actually the input sometimes is debatable, sometimes I have to say. And also oftentimes your output is other people's input. Are you able to connect the dots over there, too? Then that's actually the part that requires a lot of, I would say reinforcement alignment. Definitely we're getting better, don't get me wrong. We're totally not perfect, for sure. But I do see there is a lot of, I say momentum, to leveraging the system better. If you know other companies doing this really, really good, please shoot them my way. I would love to learn from them.

**中文翻译:**
基本的指导原则是使用关键结果（Key Results）进行评估，并制定中间步骤。至少我的团队是这么做的。我认为可以改进的是“投入与产出”（input and output）。产出通常很明确，但投入有时存在争议。而且很多时候，你的产出是别人的投入。你能不能把这些点连接起来？这需要大量的强化对齐。我们正在变好，虽然还不完美。我看到了更好地利用这个系统的势头。如果你知道哪家公司做得特别好，请告诉我，我很想学习。

---

### [00:47:07] Lenny

**English:**
One last question here. You do planning, you have OKRs. Just briefly, how often do you all do planning? Is there a yearly plan that you put together and then a quarterly detailed plan?

**中文翻译:**
最后一个关于运作的问题。你们有计划，有 OKR。你们多久做一次计划？是有一个年度计划，然后再做详细的季度计划吗？

---

### [00:47:16] Ray Cao

**English:**
Yeah, we do have annual planning cycle, but I have to say that our annual planning cycle is the baseline. We often do a lot of iterations in the middle of the year and also on a quarterly basis that we're able to pivoting really nimbly to really catering to the things that we see in the market. Some of the longer term strategy won't change, just like the platform we want to always creating, inspiring and also frictionless and immersive experiences for users. This won't change, but anything into the core of how do we realizing that you're always a consistent experiment over there. I cannot speak for the user product side, but at least from advertising product side that this is always the approach we're taking. And for the go-to-market part, that's also creating a very different behavior for us because oftentimes if we have a solid and kind of a static product roadmap, you can do go-to-market relatively easy, I would say, because everything is planned. But with a environment like that that basically make the go-to-market and also the product feedback loop much more short and faster.
(00:48:23):
So there's a lot of, I would say, pressure or actually put it nicely, there was a lot of innovative things that on the go-to-market side. Also on the sales side, the company or the teams need to actually do to make sure that we're able to catering for that. But again, this is a teamwork rather than only one side of the work. So far so good, I would say. A lot of things that we've been able to achieve within the past couple of years has been already proven that this approach has been working for us, but not necessarily they're always is perfect already, always room to improve, to make sure that we have more structural approach as well so that the market able to keep the pacing with us. We don't want to overwhelm our advertisers or our users either. So that's also the other part that we need to continue optimizing, too.

**中文翻译:**
是的，我们有年度计划周期，但年度计划只是基准。我们经常在年中和每季度进行迭代，以便根据市场变化灵活调整。一些长期战略不会变，比如我们始终想为用户创造激发灵感、无缝且沉浸式的体验。这不会变，但实现这一目标的核心手段始终在不断实验。我不能代表用户端产品，但至少在广告产品端，我们一直是这么做的。对于 GTM 来说，这导致了非常不同的行为：如果产品路线图是静态的，GTM 会相对容易，因为一切都是计划好的。但在这种环境下，GTM 和产品的反馈循环变得非常短且快。
(00:48:23):
这给 GTM 和销售团队带来了很大压力，或者说带来了很多创新的机会，以确保我们能跟上节奏。这需要团队协作。到目前为止效果不错，过去几年取得的成就证明了这种方法是有效的。当然，并不完美，仍有改进空间，我们需要更结构化的方法，让市场能跟上我们的步伐。我们不想让广告主或用户感到无所适从，这也是我们需要持续优化的部分。

---

### [00:49:12] Lenny

**English:**
Okay. Let's talk about a different topic which is being successful on TikTok. So the way I think about it in my head is, there's how to be successful is just a regular human creator person. How to be successful as a business, trying to just create viral content and then being successful as an advertiser, which I know is where you spend a lot of time. So let me just ask, is there a tip you could share for someone to be successful, say aka go viral on TikTok? I imagine your answer will be just produce something people love and want to share and like. But I guess is there anything that could be tactically useful when you're creating content in TikTok to help you go viral?

**中文翻译:**
好，我们换个话题：如何在 TikTok 上取得成功。我脑子里把它分为三类：普通创作者如何成功；企业如何通过制作病毒式内容成功；以及广告主如何成功（这是你投入精力最多的地方）。那么，你能为想要在 TikTok 上走红的人提供一些建议吗？我猜你的回答可能是“制作人们喜爱并愿意分享的内容”，但有没有什么战术上的实用技巧？

---

### [00:49:47] Ray Cao

**English:**
I think if I know that I definitely will already become a very successful creator, I have to say. Our system is very much smarter than I am. I cannot trick the system, but I have seen a couple of good cases. So number one thing is that you have to really be unfiltered. I mean, you don't really need to be perfect on this platform. I mean that's the beauty of it. You can be yourself, you can really share the things that you like. And if you're really master at one thing that you're really, really good at and you want to showcase, this is the platform for you to shine because not necessarily that we are fully saturated and also all algorithm distributing the content in a very different way. Some of the other platforms they are, I would say like a people-based or friend-based.
(00:50:32):
I think for us it's purely based on actually you're creating something that everybody want to see. So let's see if we can distribute it more. So I think continuously to bring new content to this platform and testing and finding your own competitive edge going to be very important as a successful creator. And most of our creators have been doing that. And I can see some of our biggest TikTok stars, they're literally practicing this every single day. And I do think that creativity and that part of, I would say, getting the nuances is the key part that to be more successful on the T TikTok community.
(00:51:11):
And the second thing is it's including also for brands as well, because I consider brands as our creator as well. They really need to embrace the culture and the community here to really listen and understand what are the user behaviors on the platform to understand what do they like to see. And also the messages or the presence could be very different from your other media channels, or as a creator, it could be very different from your other, I would say, platforms.
(00:51:40):
So that's the other thing that it's going to be challenging because for them to shift in the mindset. But I do think that definitely was trial. Some of the, I would say, our early adopters has already been proven that when you do embrace the culture here, you're able to acquire a ton of different kind of a user or the audience to your channel and you can show a different side of yourself as well. So yeah, I've been trying to do that. I have not really finding my competitive edge I have to say, but I'll keep trying.

**中文翻译:**
如果我知道秘诀，我肯定已经是个大网红了（笑）。我们的系统比我聪明得多，我无法欺骗系统。但我见过一些成功的案例。第一，你必须真实、不加修饰（unfiltered）。在这个平台上你不需要追求完美，这就是它的魅力。你可以做你自己，分享你喜欢的东西。如果你在某件事上非常擅长并想展示它，这就是你发光的平台。因为我们还没有完全饱和，而且算法分发内容的方式非常不同。其他平台可能是基于人际关系或朋友关系的。
(00:50:32):
而我们纯粹是基于内容：如果你创作了大家想看的东西，我们就把它分发给更多人。所以，持续带来新内容、不断测试并找到自己的竞争优势，对于成为成功的创作者至关重要。我们很多顶尖创作者每天都在练习这一点。我认为创意和对细节的捕捉是成功的关键。
(00:51:11):
第二点也适用于品牌，因为我把品牌也看作创作者。他们需要拥抱这里的文化和社区，倾听并理解用户的行为，了解他们想看什么。品牌在这里传递的信息或呈现方式应该与其它媒体渠道完全不同。
(00:51:40):
心态的转变是一个挑战。但我认为这绝对值得尝试。我们的早期采用者已经证明，当你拥抱这里的文化时，你能吸引大量不同的受众，并展示出自己不同的一面。我也在尝试，虽然还没找到我的竞争优势，但我会继续努力。

---

### [00:52:14] Lenny

**English:**
Is there an example you could share of someone that has done that really well, either be really authentic and also embrace the community of a business specifically that has done this really well and has taken off not as an advertiser?

**中文翻译:**
你能举个例子吗？比如某个品牌或企业，在不通过广告投放的情况下，通过真实表达和拥抱社区而大获成功？

---

### [00:52:25] Ray Cao

**English:**
There was one creator I remember called Sheba. She's a singer and she is able to caught my eyes because she was able to basically rap and also during some of the songs cover in a very different way because she's a minority and she was able to basically using her minority identity as actually everybody was thinking, "I'm supposed to be doing Bollywood music, but actually, you know what I'm not. I'm doing a lot of very just hip hop and also the music that people may think like I'm not good at."
(00:52:59):
So it is pretty fun to watch that kind of a comparison or the contrast between a creator and also she's able to put a lot of original music on the platform to really inspire more people to do the same thing. There's another music, I would say TikTok creator. So he was pretty big on the other platforms, but the total approach from him is he's basically changing the lyrics, make it very relatable as a personal life. Because for example, he can totally change the lyrics from a old Backstreet Boys song or Nsync song to make it related with his daily communication with his wife. Make it really relatable and fun. So these are the things I think is very unique to us. If you are able to test and find something new like that, you're able to find a new batch of audience and even go viral on the platform.

**中文翻译:**
我记得有一个叫 Sheba 的创作者。她是个歌手，引起了我的注意，因为她用一种非常独特的方式翻唱和说唱。作为少数族裔，大家可能觉得她应该唱宝莱坞风格的音乐，但她偏不，她唱了很多非常棒的嘻哈音乐，打破了人们的刻板印象。
(00:52:59):
这种反差非常有趣，她还在平台上发布了很多原创音乐，激励了很多人。还有一位音乐创作者，他在其他平台也很火，但他在 TikTok 上的做法是改歌词，让内容变得非常贴近生活。比如他会把后街男孩或 Nsync 的老歌歌词改成他和妻子的日常对话，非常接地气且有趣。这些都是 TikTok 特有的。如果你能测试并找到这种新颖的角度，你就能吸引新受众甚至走红。

---

### [00:53:49] Lenny

**English:**
So then switching to the advertising network, a lot of listeners here are thinking about, I imagine, advertising on TikTok. There's kind of classically been Facebook and Google are the two places to do run paid ads. Paid ads are a huge growth driver for tons of companies. It's one of the easiest you could say, or one of the most traditional way to grow. TikTok obviously is emerging and has already emerged as one of the newer advertising networks. So there's a lot of people thinking about how do I succeed as an advertiser on TikTok. So what advice do you have for people? One, who's it best for? I imagine TikTok isn't the best place to advertise for every sort of business. So what sort of businesses are best aligned to be successful on TikTok? And then just what advice can you share to do well as an advertiser on TikTok?

**中文翻译:**
那我们转到广告网络。很多听众可能在考虑在 TikTok 上投广告。传统上，Facebook 和 Google 是两大付费广告阵地，是很多公司的增长引擎。TikTok 显然已经崛起成为重要的新兴广告网络。那么，关于如何在 TikTok 广告上取得成功，你有什么建议？第一，它最适合什么样的企业？我猜 TikTok 并不适合所有业务。第二，为了在 TikTok 上做好广告，你有什么建议？

---

### [00:54:37] Ray Cao

**English:**
Yeah, I see a lot of really different type of advertisers already find their success on the platform. One thing that they actually can do that is really due to a couple of things that they're doing. Number one is, like I said, they're embracing this platform. They actually do a lot of things is TikTok first. I have a couple of advertisers. They have actually creating their own internal creative team just dedicated for TikTok. So they actually produce a ton of creative every single day to actually test and learn to understand the platform and understand the community they are engaging with. So I would say leaning in is the first part. It's harder, but it is not that hard. As long as you try it, you'll feel that every single day is getting easier. And also we make a lot of tools to make things easier for them as well. Like creative, we have also a lot of resources on the platform, the creative hub and also we have creative analytics to help you. So these are the things that we're able to basically help the advertiser to leaning in more.
(00:55:42):
The other angle to leaning in more is test and learn. A lot of times that people don't know how to really run ads on this platform. Google is very much search, like search fronts. They are really leading on the intent graph. And Meta is really on the people graph they're making. I mean TikTok is the content graph. It's very different, I would say machine compared to the other two. And it requires different way to optimizing and to leveraging the tools we have. So if you're applying the same logic from Meta or Google into TikTok, not necessarily you'll be able to see a great success, I have to say.
(00:56:27):
So you have to really get to the detail and to learn how you're operating this platform at the very beginning. Of course, like I said, we're trying to make things as simple as possible because we strongly believe that an advertiser's job is to taking care of their own business and our job is to service them. So we definitely make things a bit easier and along the way, but still it's a little bit learning for advertisers to change their mindset when they engage with us the first time. And I can see that again, for example, last Q4, I can see a lot of advertisers taking this approach to really listen to us and understanding what is our best practices. They actually see a very successful Q4 on the platform. So I do think that if you want to do more, just do more test and learn with us and to really understand the impact from TikTok.

**中文翻译:**
是的，我看到很多不同类型的广告主已经取得了成功。他们做对了几件事。第一，正如我所说，他们拥抱这个平台，采取“TikTok 优先”（TikTok first）的策略。我有几个客户甚至组建了专门针对 TikTok 的内部创意团队。他们每天制作大量素材进行测试和学习，以理解平台和社区。所以，“全身心投入”（leaning in）是第一步。这听起来很难，但只要你开始尝试，你会发现每天都变得更容易。我们也提供了很多工具，比如创意中心（Creative Hub）和创意分析工具，来帮助广告主。
(00:55:42):
另一个角度是“测试与学习”。很多人不知道如何在 TikTok 上跑广告。Google 主要是基于搜索，领先于“意图图谱”（intent graph）；Meta 则是基于“社交图谱”（people graph）；而 TikTok 是“内容图谱”（content graph）。这与前两者是完全不同的机器，需要不同的优化方式。如果你把 Meta 或 Google 的逻辑直接搬到 TikTok，不一定能成功。
(00:56:27):
所以你必须深入细节，学习如何操作这个平台。当然，我们也在努力简化流程，因为我们相信广告主的职责是经营业务，而我们的职责是服务他们。虽然我们一直在简化，但广告主在第一次接触我们时仍需要转变思维。比如去年第四季度，很多听取我们建议并遵循最佳实践的广告主都取得了非常成功的业绩。所以，多做测试，多学习，真正理解 TikTok 的影响力。

---

### [00:57:17] Lenny

**English:**
Just to understand this point about versus Instagram, I think a lot of people probably run on them on both platforms and try to see which one's working better. Your point is the same content won't work as well on one versus the other. So just so people understand what the main difference there is. I know you talk about there's the friend graph versus TikTok just spreads it all over and anyone can see it. You don't have to be friends and it's really good at getting content out. So what is it that you would do differently if you're making an ad video for Instagram versus TikTok?

**中文翻译:**
为了理解与 Instagram 的区别——很多人可能同时在两个平台跑广告。你的观点是，同样的内容在两个平台上的效果可能大不相同。为了让大家明白主要区别：Instagram 是基于朋友关系的图谱，而 TikTok 是把内容推向所有人，不需要是朋友。那么，如果你为 Instagram 和 TikTok 分别制作广告视频，会有什么不同的做法？

---

### [00:57:44] Ray Cao

**English:**
I think the TikTok video, it's more about the backend settings, right? So how often do you actually changing creatives? I think for us it is actually pretty... you want to actually test more creatives on this platform and see which one is actually working. And then we also have really detailed guidance on how do you set up your campaign structure to make sure that you're able to be more successful on the platform. So these are, I would say, the basic hydrangeas we talked about. You can see these guidance are very different from what Meta has today or even Google has today because we're just basically different platforms. And oftentimes you can also hear that we requires a bit more real time react on the platform due to some of the trends we have seen.
(00:58:30):
So that is the part I feel like if advertiser wants to engage more with really the sales team and they're able to provide more guidance to you and you're able to see more success there. But a lot of things will be counterintuitive I would say, because the intuitive you have learned is coming from the other platforms, but technically we're not. So a lot of things that, "Oh, this doesn't make sense to me, but why don't you try it?" And we make actually that really easy because we are sharing a lot of, I would say, added credit to intensify incentivizing our advertisers to try it at the end of the day that hopefully they can see the result is proven itself.

**中文翻译:**
我认为 TikTok 视频更多关乎后台设置。比如，你更换素材的频率是多少？在 TikTok 上，你需要测试更多的素材，看看哪一个有效。我们有非常详细的指南教你如何设置广告系列结构。这些基础准则与 Meta 或 Google 非常不同，因为平台属性不同。此外，由于趋势变化快，我们需要更多的实时响应。
(00:58:30):
如果广告主愿意多与销售团队交流，他们能提供更多指导。很多事情可能是反直觉的，因为你的直觉来自其他平台，但我们不一样。很多时候客户会说：“这对我来说不合逻辑”，但我们会建议：“为什么不试试呢？” 我们甚至会提供一些广告抵用金来激励客户尝试，最终结果往往会证明一切。

---

### [00:59:11] Lenny

**English:**
Got it. I think that's such an interesting point, this idea of testing more, which basically you're saying with Instagram certain people will see it and that's not going to be shown tons of random people. So you basically have one shot at getting this in front of the Instagram crowd versus TikTok just tries it, this explore and exploit kind of approach is like, we'll just keep trying stuff until something sticks.

**中文翻译:**
明白了。测试更多素材这个点很有趣。你的意思是，在 Instagram 上，内容通常只展示给特定人群，你基本上只有一次机会；而 TikTok 采用的是“探索与利用”（explore and exploit）的方法，不断尝试新东西，直到找到有效的内容。

---

### [00:59:33] Ray Cao

**English:**
Yeah, I think exactly like that 100%. I think a lot of times that I think advertising, especially when digital advertising becomes a thing, so we kind of think everything can be calculated because you have the data, but the beauty of advertising is never like that. The core value advertising is to tell people don't know you exist and tell them that what you're doing for them and then creating these demand, right? Discovery is the core of advertising to me because I was never expecting my wife telling me that what she going to buy when she walk into a shopping mall, if I know that I'll stop her already. She oftentimes that get out something different. So this is not planned. I think that's literally one of the behavior I would love to emphasize more is you want to be open up your door to more consumer.
(01:00:26):
Because we are a digital version of word-of-mouth, I always compare us to that because it is the way that how the digital era becomes more human because it is actually helping user to discover new things, just like what they used to do. There's a new place in a certain area, you just go explore. It is just like that. So I think that's the reason why I think at the very beginning, continue doing this kind of open-minded testing with us will be a very good approach to get some early learning and eventually that you can refine your approach. But at the beginning I would highly recommend that just be open up and also take some risks with us together and we're able to show you how much we can actually benefit in the business.

**中文翻译:**
没错，百分之百正确。在数字广告时代，人们总觉得一切皆可计算，因为有数据。但广告的魅力远不止于此。广告的核心价值是告诉那些不知道你存在的人，你在做什么，从而创造需求。对我来说，“发现”（Discovery）是广告的核心。就像我从不指望我妻子走进商场前能告诉我她要买什么，如果我知道，我早就阻止她了（笑）。她经常带回一些计划外的东西。我想强调的是：你应该向更多消费者敞开大门。
(01:00:26):
我常把 TikTok 比作“数字版的口碑传播”，因为它让数字时代变得更具人性化，帮助用户发现新事物，就像人们以前去探索新地方一样。所以，在开始阶段，保持开放心态与我们一起测试是获取早期经验的好方法。我强烈建议初期保持开放，和我们一起承担一些风险，我们会向你展示这能为业务带来多大的收益。

---

### [01:01:15] Lenny

**English:**
Awesome. And on that point, that was the other piece of advice you shared is pay attention to the trends so that you can connect your ad to things that people are already laughing at or finding really interesting. I feel like Duolingo is incredible at this. Their videos are hilarious and I think they're all just organic videos and a lot of them connected trends that are-

**中文翻译:**
太棒了。关于这一点，你分享的另一个建议是关注趋势，这样你就能把广告与人们已经在谈论或觉得有趣的事情联系起来。我觉得 Duolingo 在这方面做得非常好，他们的视频非常搞笑，而且很多都是自然流量视频，紧跟趋势。

---

### [01:01:34] Ray Cao

**English:**
Yeah. It's funny you brought up Duolingo because I'm actually now become a heavy user of Duolingo myself because-
(01:01:39):
[Lenny: Me, too.]
(01:01:40):
I watched the video on the TikTok. I think just basically kids just randomly learn a different language and make a lot of mistakes and it's really funny. And then I just download the app because I didn't know. I've been using Duolingo for the past 40 days as a New Year resolution. I'm convincing myself to learn Japanese.

**中文翻译:**
哈哈，很有趣你提到了 Duolingo，因为我现在也成了他们的重度用户。
(01:01:39):
[Lenny: 我也是。]
(01:01:40):
我在 TikTok 上看了他们的视频，就是那些随机学外语闹笑话的视频，非常有趣。然后我就下载了。作为新年计划，我已经连续用了 40 天了，我在努力学日语。

---

### [01:02:01] Lenny

**English:**
Wow, 40-day streak?
(01:02:03):
[Ray: Yeah.]
(01:02:04):
Amazing. I'm at 25 days.

**中文翻译:**
哇，连续 40 天了？
(01:02:03):
[Ray: 是的。]
(01:02:04):
厉害，我才 25 天。

---

### [01:02:06] Ray Cao

**English:**
Okay, great. We're on par pretty much.
(01:02:09):
[Lenny: Are you in the Ruby league or Emerald league? Which league are you in right now?]
(01:02:09):
Emerald, right now.

**中文翻译:**
好，我们差不多。
(01:02:09):
[Lenny: 你在红宝石联赛还是翡翠联赛？]
(01:02:09):
我现在在翡翠联赛。

---

### [01:02:13] Lenny

**English:**
Emerald. Okay. I think I'm in Emerald, too.
(01:02:15):
[Ray: So we're on par here.]

**中文翻译:**
翡翠，我也在翡翠。
(01:02:15):
[Ray: 那我们水平相当。]

---

### [01:02:17] Lenny

**English:**
Just to close the thread on this, so you're talking about one of the benefits of TikTok ads is awareness-building basically more top of funnel. I know you also focus a lot on taking action, not just brand awareness. There's also a lot of, so maybe talk a bit about that, just like that's also a big part of advertising and TikTok.

**中文翻译:**
回到正题，你提到 TikTok 广告的一个优势是建立知名度，即漏斗顶部。但我知道你也非常关注“采取行动”（转化），而不仅仅是品牌知名度。这也是 TikTok 广告的重要组成部分，能聊聊这个吗？

---

### [01:02:35] Ray Cao

**English:**
Yeah, I think the beauty of word-of-mouth is actually that word-of-mouth leads to actions. So I think TikTok, we oftentimes people are thinking that, oh, TikTok is really good for building awareness, building upper funnel or some of the discovery funnel. But I really want to say that we want to prove, and also we already proved that from the studies we have seen from third parties that we're driving actions at the same time, and this is literally the ambition we're trying to really talk to out of the advertisers, especially on the commerce front, that shopping and TikTok shop and shop ads. It is actually the proven points that we see. And also, this is not necessarily coming off of our illusion, right, because we see there was a biggest trend on TikTok is "TikTok made me buy it." We have billion level views on that.
(01:03:27):
It's continue growing and this literally inspire us to do this product. Like I said, one of the very important things here is we drive our product by listening to our user and see the behavior from them and we see the behavior and now we're trying to capture that and provide the best service to our user and also help advertisers to reshaping their product. So I do think that this year people will see us more as a full funnel solution platform rather than only building the brands because we want actually impacting on full funnel for our advertisers. Again, driving their business result is more important to us.

**中文翻译:**
是的，口碑传播的魅力在于它能转化为行动。人们常觉得 TikTok 只适合做品牌知名度或漏斗顶端。但我必须说，我们已经通过第三方研究证明，我们同时也在驱动转化。这也是我们努力向广告主传达的愿景，尤其是在电商领域，比如 TikTok Shop 和购物广告。这已经得到了验证。而且这并非我们的幻觉，因为 TikTok 上最火的趋势之一就是“#TikTokMadeMeBuyIt”（TikTok 让我买了它），这个标签有数十亿次的播放量。
(01:03:27):
这个趋势还在增长，它激励我们开发相关产品。正如我所说，我们通过倾听用户和观察行为来驱动产品开发。我们观察到了这种行为，现在正努力捕捉它，为用户提供最好的服务，并帮助广告主重塑他们的产品。我认为今年大家会看到我们更多地作为一个“全链路”（full funnel）解决方案平台，而不仅仅是品牌建设平台。驱动业务结果对我们来说至关重要。

---

### [01:04:03] Lenny

**English:**
Say a startup is starting to think about advertising on TikTok, maybe they've done some Google ads and Facebook ads. What do you recommend they plan for in order to just see if this could work for them? How much time should they give it? How many ads should they run? How much budget should they allot to just explore this as a growth channel for them?

**中文翻译:**
假设一家初创公司开始考虑在 TikTok 上投广告，他们可能已经做过 Google 和 Facebook 广告了。你建议他们如何规划，以测试这是否适合他们？他们应该给多长时间？跑多少个广告？分配多少预算来探索这个增长渠道？

---

### [01:04:23] Ray Cao

**English:**
I would say at the very beginning, the investment will be coming from their leaning into creating a business account with us. So this is actually how you're engaging with your community. But even before that, I think just do some research on a platform and be the user as a TikTok to really experiencing it and see the differences. And then you are thinking about how can you actually connecting your behavior or your desired behavior coming from a user with your business and then you're creating content around it. And that's the moment I think this first step is creating your business presence on the TikTok.

**中文翻译:**
我会说，最初的投入应该是建立一个企业账号。这是你与社区互动的方式。但在此之前，先在平台上做些调研，作为普通用户去体验 TikTok，感受它的不同。然后思考如何将用户的行为（或你期望的行为）与你的业务联系起来，并围绕它创作内容。我认为第一步是在 TikTok 上建立你的企业存在感。

---

### [01:05:00] Lenny

**English:**
And the idea there is just an organic account you create, let's say Lenny's Podcast, which I actually have... my Lenny's Podcast is on TikTok, so we can use that as an example maybe. So you're saying start off just creating free business accounts on TikTok and posting videos just to see how it feels and how it goes?

**中文翻译:**
所以你的意思是先创建一个自然流量账号，比如我的“Lenny's Podcast”在 TikTok 上就有账号。你是说先创建一个免费的企业账号，发发视频，看看感觉如何？

---

### [01:05:15] Ray Cao

**English:**
Yeah. Just see how it feels, right? So maybe some of the videos you don't get any views and some of the videos, you get more views. At the end of the day you can test some of the advertising products, drive those awareness and see if it's actually driving impact for you. And then you have to do more maybe testing with us or AB testing or geo-splitting testing eventually, depends on how big the investment is. You can see there is actually a directional impact on your business and also we are giving you reporting and insights on how you're doing on the platform, so you can optimize in towards that.
(01:05:50):
But obviously very important part is trying to get a feeling of the platform by creating your organic presence and then try to launch the ads account to make sure that you're able to drive more traffic to your desired destination or to a desired actions that you want user to take and continue refining that. Along the way, there are a lot of things that you're going to learn. For example, how can you leverage in automation solutions on the platform and how can leveraging some of the, I would say, creator trends you detected on the platform and also some of the tools that we're creating to help you to generating those scripts.
(01:06:24):
So these are all the things that you can learn from the platform. In terms of time investment, I think at the beginning of the month, definitely it's going to be, I hope it'll be a little bit more intense of learning so that you're able to get a rhythm in there and along the way that as long as gets become more automated and also get more understanding towards the business, you're able to actually creating, I would say, more relevant content for the platforms by leveraging our creators or by leveraging some of your own, I would say, resources from their third party, for example. So I think, yeah, it takes a little bit a learning curve, but I do think that the result will surprise you.

**中文翻译:**
是的，先找找感觉。可能有些视频没播放量，有些视频播放量很高。之后你可以测试一些广告产品来提升知名度，看看是否产生了实际影响。根据投入规模，你可以做 A/B 测试或地域拆分测试。你会看到对业务的趋势性影响，我们也会提供报告和洞察，帮你进行优化。
(01:05:50):
但最重要的一点是通过自然流量账号找感觉，然后开通广告账户，将流量引导至你的目标页面或期望的行动，并不断精进。在这个过程中，你会学到很多，比如如何利用自动化方案、如何利用捕捉到的趋势，以及如何使用我们提供的脚本生成工具。
(01:06:24):
在时间投入上，第一个月应该是高强度的学习期，帮你找到节奏。随着流程变得自动化，你对业务的理解加深，你可以通过与创作者合作或利用第三方资源来创作更相关的内容。虽然有学习曲线，但我相信结果会让你惊喜。

---

### [01:07:02] Lenny

**English:**
And was the implication there, give it a month? Like spend a month of running ads or is that not what you're saying?

**中文翻译:**
所以你的意思是，至少尝试一个月？跑一个月的广告，是这个意思吗？

---

### [01:07:07] Ray Cao

**English:**
I think oftentimes we'll say a month minimum to run ads because I think it's actually a learning curve for advertisers to really get into understanding the behavior and the platform.

**中文翻译:**
是的，我们通常建议至少跑一个月广告，因为广告主需要时间来理解平台行为和用户习惯。

---

### [01:07:17] Lenny

**English:**
And how many ads would you suggest, and I know there's not a rule of thumb, but just how many ads would you suggest they try to run in that month, to give you a real sense of this could work or no?

**中文翻译:**
那你建议这一个月跑多少个广告？虽然没有固定标准，但为了判断是否有效，大概需要多少？

---

### [01:07:27] Ray Cao

**English:**
The more, the better. I would say at least 10 different ad creatives will be ideal per week and the more the better.

**中文翻译:**
越多越好。理想情况下，每周至少测试 10 个不同的广告素材，越多越好。

---

### [01:07:37] Lenny

**English:**
10 per week. Oh, wow. Okay. So 40 potentially.

**中文翻译:**
每周 10 个。哇，那一个月可能要 40 个。

---

### [01:07:39] Ray Cao

**English:**
Yeah, 10 per week. Also, I would say we can see that it is a little bit of, I would like nuances there because a lot of, "Oh, I don't have that resources," but as simple as possible, it can give you a tool. We have CapCut as a tool. I created my anniversary video for my wife by using that tool. Don't tell her one-minute now everybody knows, but she thinks that-
(01:08:04):
[Lenny: She might not listen all the way this long to the end of this episode.]
(01:08:06):
She thinks it takes a lot of time. Literally the production is amazing. We are creating that tool specifically for our creator and also for our monetizer and the user in general. So you're able to do a lot of, I would say, automated and customized way in the app so you're able to generate those content on your fingertips. So it will be a really good help for advertisers that want to be more self-service. On the other hand, we also have third parties, certified TikTok service providers on the creative side to help you as well. So depends on the level of how advertiser you are.

**中文翻译:**
是的，每周 10 个。我知道有人会说“我没那么多资源”，但其实可以很简单。我们有 CapCut（剪映海外版）这个工具。我给我妻子的周年纪念视频就是用它做的。别告诉她（笑），她还以为我花了很长时间，其实效果非常惊人。我们专门为创作者、广告主和普通用户开发了这个工具，你可以非常方便地生成内容。这对于想要自助服务的广告主非常有帮助。另一方面，我们也有经过认证的第三方服务商来协助制作素材。这取决于你的规模。

---

### [01:08:42] Lenny

**English:**
Is there a most common mistake people make when they try this out where you're just often being like, "You fool, here's what you did wrong?" Is there something in there that's just like, "Just don't do this thing because a lot of people make this mistake and then they fail on TikTok?"

**中文翻译:**
人们在尝试时最常犯的错误是什么？有没有什么事是“千万别做”的，因为很多人因此在 TikTok 上失败了？

---

### [01:08:53] Ray Cao

**English:**
Yeah, the first one is I can see a lot of advertiser instantly they want to do remarketing or they want to do a very small niche targeting on the platform because you're limiting yourself. Like I said, it is more about getting to the rhythm to understand more about platform. So a broader targeting approach is actually recommended at the very early stage and most of advertisers are already doing that today because previously I can see for the first two years in the business, especially when we acquire new advertisers, oftentimes they get on the platform, say, "Hey, I want to do this and that. I want to really refine my targeting, et cetera." And then we just recommend, "Hey, why don't we do this comparison? You have a campaign set up like this going on, but this is our recommendation and you can see the difference." And literally most of them, they'll see a very big difference over there on it.

**中文翻译:**
第一点是，很多广告主一上来就想做“再营销”（remarketing）或者非常小众的精准定向，这会限制你自己。正如我所说，初期更重要的是找到节奏并理解平台。因此，在早期阶段，我们建议采用更广泛的定向方式。现在大多数广告主都这么做了。但在业务的前两年，很多新客户一上来就想做非常精细的定向，我们会建议他们做对比测试，结果通常证明我们的建议效果更好。

---

### [01:09:44] Lenny

**English:**
Amazing. Ray, I know you have to run, I'm going to skip the lightning round, but let me ask you just one question from lightning round. Do you have a favorite TikTok account that you've been just really loving these days? I'll share mine real quick and then see if anything comes to mind. There's this lady who I found recently who does silent baby product reviews where her baby's sleeping in the room and she is like, "Shh." And then she just goes through 20 different baby products very quietly and it's hilarious. I'll link to it in the show notes. If you have a kid, you'll love it. Is there anything that you love or want to highlight?

**中文翻译:**
太棒了。Ray，我知道你赶时间，我们跳过闪电问答环节，但我只想问一个问题：你最近有没有特别喜欢的 TikTok 账号？我先分享我的：最近我发现一个博主，她做“无声母婴产品测评”，因为宝宝在房间睡觉，她就一直“嘘——”，然后非常小声地测评 20 种产品，特别搞笑。我会把链接放在节目介绍里。如果你有孩子，你一定会喜欢的。你有什么想推荐的吗？

---

### [01:10:18] Ray Cao

**English:**
I do have one creator I am actually active following is on. He's a magician. He basically uses very, I would say, very normal things, just handy around him to make something that look very cool magic. I always were like, how did he make that? So I'm actually following that and getting more inspiration on myself is like, "Can I do that? No." I think that's more about my personal hobby to see something like that. It's very, very cool to see people can do these kinds of tricks by using normal stuff around them.

**中文翻译:**
我确实关注了一个创作者，他是个魔术师。他用身边非常普通的日常用品变出非常酷的魔术。我总是在想：他是怎么做到的？我关注他是为了寻找灵感，虽然我学不会（笑）。看人们用普通的东西玩出这种花样非常酷，这是我的个人爱好。

---

### [01:10:54] Lenny

**English:**
Ray, thank you so much for being here. Two last questions. How can folks reach out if they ever want to learn more about this stuff, if they can, and how can listeners be useful to you?

**中文翻译:**
Ray，非常感谢你能来。最后两个问题：如果大家想了解更多，该如何联系你？以及听众们能为你做些什么？

---

### [01:11:03] Ray Cao

**English:**
I think feel free to reach out to me on LinkedIn if you want to discuss more about some of the go-to market challenges you're facing. I think we're facing a lot of, I would say similar challenges every single day. And also in terms of on the product standpoint, different companies have a different product philosophy. I don't think we are always right. I was always recommending to receive a lot of feedbacks or recommendations and that would be really, really nice to have to form these kind, leveraging your audience, be my community to teach me a lesson sometimes. That'll be even better.

**中文翻译:**
欢迎在 LinkedIn 上联系我，讨论你们面临的市场挑战。我想我们每天面临的挑战都很相似。此外，从产品角度来看，不同公司有不同的哲学，我不认为我们永远是对的。我非常欢迎反馈和建议，希望能借助你的听众群体，让他们成为我的社区，有时甚至可以教我一些东西，那就更好了。

---

### [01:11:39] Lenny

**English:**
Amazing. Ray, again, thank you so much for being here. I feel like people don't have a ton of insight into the way TikTok operates, and I appreciate making time to do this.

**中文翻译:**
太棒了。Ray，再次感谢。我觉得大家对 TikTok 的运作方式了解不多，非常感谢你抽时间分享。

---

### [01:11:47] Ray Cao

**English:**
No, it's a pleasure, Lenny. Thank you very much for having me.

**中文翻译:**
不客气，Lenny。非常感谢你的邀请。

---

### [01:11:50] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lenny'spodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。感谢收听。如果你觉得本期节目有价值，请在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。也请考虑给我们评分或留言，这能帮助更多听众发现我们。你可以在 Lennyspodcast.com 找到往期节目或了解更多。下期见。