# Richard Rumelt - 双语对照

这是一份关于《Lenny's Podcast》采访 Richard Rumelt 的完整双语转录文档。

---

### [00:00:00] Richard Rumelt

**English:**
Don't call it strategy, call it an action agenda. It's huge numbers of people out there willing to sell you advice on mission and your vision and your values, all these things that have to be in place before you can have strategy. That's not true. Begin to try to identify the one or two key challenges that can actually be addressed and what are we going to do about it? What are the coherent actions we're going to do to take these on? Okay, we're going to go after this and here's the action steps we're going to take to do that. That's the essence of what you're doing when you're thinking strategically.

**中文翻译:**
不要把它叫做战略，叫它“行动议程”（action agenda）。现在有大把的人愿意向你推销关于使命、愿景和价值观的建议，声称在制定战略之前必须先具备这些东西。这不是真的。你应该开始尝试识别出一两个真正可以被解决的关键挑战，并思考：我们要对此采取什么行动？我们要采取哪些连贯的行动来应对这些挑战？好，我们要攻克这个目标，以下是我们要采取的具体行动步骤。这就是你进行战略思考时的本质。

---

### [00:00:42] Lenny

**English:**
Today my guest is Richard Rumelt. Richard is an absolute legend in the world of strategy. It was such an honor to have him come on the podcast. He's the author of Good Strategy Bad Strategy, which I've gifted to countless people who wanted to become more strategic. He's been mentioned so many times on this podcast. He's also the author of The Crux, his most recent book, which some consider his best book, which delves even further into his advice on how to craft a winning strategy.
(00:01:08):
Richard was a longtime professor at UCLA Anderson School of Management, was on the faculty of Harvard Business School, and he's consulted on strategy with companies like Microsoft, Apple and Intel, and also with government organizations like the US Army Special Ops Command, and folks like Donald Rumsfeld. In our conversation, Richard shares the concrete elements that make a good strategy, why we'd be better off calling them action agendas rather than strategies, why every great strategy starts with a clear diagnosis of the biggest challenge that you face. Also, how to actually lay out a strategy, why organizational dynamics are often the biggest hindrance to winning strategies and so much more. I could keep going, but let me just say we cover a lot of ground in this episode and Richard shares incredibly thoughtful and deep answers to each question. I'm excited to bring you Richard Rumelt, after a short word from our sponsors.

**中文翻译:**
今天的嘉宾是 Richard Rumelt。Richard 是战略界的绝对传奇。能邀请他参加播客是我的荣幸。他是《好战略，坏战略》（Good Strategy Bad Strategy）一书的作者，我曾把这本书送给无数想要变得更有战略眼光的人。他在本播客中被提及过很多次。他也是《关键点》（The Crux）的作者，这是他最近的一本书，有些人认为这是他写得最好的一本，书中进一步深入探讨了如何制定获胜战略的建议。
(00:01:08):
Richard 曾长期担任加州大学洛杉矶分校（UCLA）安德森管理学院的教授，也曾在哈佛商学院任教。他曾为微软、苹果、英特尔等公司提供战略咨询，也曾服务于美国陆军特种作战司令部等政府机构，以及唐纳德·拉姆斯菲尔德（Donald Rumsfeld）等政要。在我们的对话中，Richard 分享了构成好战略的具体要素，为什么我们最好将其称为“行动议程”而非战略，以及为什么每一个伟大的战略都始于对所面临最大挑战的清晰诊断。此外，他还谈到了如何实际制定战略，为什么组织动态往往是获胜战略的最大障碍等等。我可以一直说下去，但简单来说，我们在本集中涵盖了非常广泛的内容，Richard 对每个问题都给出了极其深刻且深思熟虑的回答。在听完赞助商的简短介绍后，我很激动地为大家介绍 Richard Rumelt。

---

### [00:01:58] Lenny (Sponsor: CommandBar)

**English:**
Let me tell you about CommandBar. If you're like me and most users I've built product for, you'll probably find those little in-product pop-up really annoying. Want to take a tour? Check out this new feature. And these pop-ups are becoming less and less effective since most users don't read what they say, they just want to close them as soon as possible. But every product builder knows that users need help to learn the ins and outs of your product. We use so many products every day and we can't possibly know the ins and outs of every one.
(00:02:24):
CommandBar is an AI-powered toolkit for product growth, marketing and customer teams to help users get the most out of your product without annoying them. They use AI to get closer to user intent, so they have search and chat products that let users describe what they're trying to do in their own words and then see personalized results like customer walkthroughs or actions. And they do pop-ups too, but their nudges are based on in-product behaviors like confusion or intent classification, which makes them much less annoying and much more impactful. This works for web apps, mobile apps and websites, and they work with industry-leading companies like Gusto, Freshworks, HashiCorp, and LaunchDarkly. Over 15 million end-users have interacted with CommandBar. To try out CommandBar, you can sign up at CommandBar.com/Lenny and you can unlock an extra 1,000 AI responses per month for any plan. That's CommandBar.com/Lenny.

**中文翻译:**
让我向大家介绍一下 CommandBar。如果你像我以及我曾为其开发产品的多数用户一样，你可能会觉得产品内部的那些小弹窗非常烦人。“想参观一下吗？”“看看这个新功能。”这些弹窗的效果正变得越来越差，因为大多数用户根本不看内容，只想尽快关掉它们。但每个产品开发者都知道，用户确实需要帮助来了解产品的细节。我们每天使用这么多产品，不可能了解每一个产品的方方面面。
(00:02:24):
CommandBar 是一个由 AI 驱动的工具包，专为产品增长、营销和客户团队设计，旨在帮助用户充分利用产品而不打扰他们。他们利用 AI 更贴近用户意图，因此他们拥有搜索和聊天产品，让用户可以用自己的语言描述想做的事情，然后看到个性化的结果，如客户演练或操作建议。他们也做弹窗，但他们的“微调提示”（nudges）是基于产品内行为的，比如用户表现出的困惑或意图分类，这使得它们不那么讨人厌，且更具影响力。这适用于 Web 应用、移动应用和网站，他们与 Gusto、Freshworks、HashiCorp 和 LaunchDarkly 等行业领先公司合作。超过 1500 万终端用户曾与 CommandBar 互动。要试用 CommandBar，你可以访问 CommandBar.com/Lenny 注册，任何方案都可以每月额外解锁 1000 条 AI 回复。地址是 CommandBar.com/Lenny。

---

### [00:03:21] Lenny (Sponsor: Miro)

**English:**
This episode is brought to you by Miro. Do you ever feel like your projects aren't as organized as you like them to be or it's way too hard for people on your team to find all of the documents and files and context that they need for their project? Miro helps you streamline your workflows, organize information, and get your whole team on the same page. If you want to see what Miro can do for you, check out my Miro board that the Miro team helped me create, which includes all of my favorite plug-and-play templates, like a user journey map, my favorite one-pager template plus a brainstorming guide. My board also has a place for you to share suggestions for this podcast and also answer a question that I have for you. You can then take my Miro board and easily create your own to see how it feels. Make sure to check out some of my favorite features, like the sticky notes, the inline comments and charts, and also the really cool diagramming tools.
(00:04:10):
Check it out at Miro.com/Lenny. Your first three Miro boards are free when you sign up today at Miro.com/Lenny. Find simplicity in your most complex projects with Miro. That's MIRO.com/Lenny.

**中文翻译:**
本集节目由 Miro 赞助。你是否曾觉得项目不够井井有条，或者团队成员很难找到项目所需的所有文档、文件和背景信息？Miro 帮助你简化工作流程、组织信息，并让整个团队达成共识。如果你想看看 Miro 能为你做什么，请查看 Miro 团队帮我创建的 Miro 画板，其中包含了我最喜欢的所有即插即用模板，如用户旅程图、我最喜欢的一页纸模板以及头脑风暴指南。我的画板还有一个地方供你分享对本播客的建议，并回答我向你提出的问题。你可以直接使用我的画板并轻松创建自己的画板来体验。一定要试试我最喜欢的一些功能，比如便签、行内评论和图表，还有非常酷的绘图工具。
(00:04:10):
请访问 Miro.com/Lenny 查看。今天在 Miro.com/Lenny 注册，前三个画板免费。用 Miro 在最复杂的项目中寻找简单。地址是 MIRO.com/Lenny。

---

### [00:04:29] Lenny

**English:**
Richard, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Richard，非常感谢你能来到这里，欢迎参加我们的播客。

---

### [00:04:33] Richard Rumelt

**English:**
Thank you for having me, Lenny.

**中文翻译:**
谢谢你的邀请，Lenny。

---

### [00:04:35] Lenny

**English:**
It is such an honor to have you on this podcast. So many guests on the podcast have mentioned you and mentioned the book. I probably bought your book for, I don't know, dozens of people over the years, and it is just so cool to have you on and to get to delve into the stuff that you teach. So thank you again for being here.

**中文翻译:**
能邀请到你真是太荣幸了。播客的很多嘉宾都提到过你和你的书。这些年来，我可能给几十个人买过你的书，能请到你并深入探讨你教授的内容真的太酷了。再次感谢你的到来。

---

### [00:04:51] Richard Rumelt

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:04:51] Lenny

**English:**
I thought we'd start at the beginning and then work our way up and kind of see where the conversation goes. What is the simplest way to understand a strategy? What is a strategy, and then what are the essential components of a good strategy?

**中文翻译:**
我想我们可以从最基础的开始，然后循序渐进，看看对话会如何展开。理解战略最简单的方式是什么？什么是战略？一个好战略的核心组成部分又是什么？

---

### [00:05:05] Richard Rumelt

**English:**
Well, a strategy is a design for overcoming a high-stakes challenge. It's a mixture of policy and action designed to deal with a challenge. The challenge could have an upside. It could be, "Oh geez, we were fooling around in the back 40 and we discovered oil, what we do?" Or it could be negative, could be that new innovation is driving us out of the market. But a challenge is the hardest strategy. The work comes from Strategos, which is Greek. The Greeks elected 10 Strategoi to serve as strategic leaders at Athens. And they were elected and they dealt with issues of the day, the Persians are invading, there's a plague in town, we need money for a new temple. And that's where the word comes to us from. It isn't just military, it wasn't in Athens. So strategy is always about dealing with an issue, a challenge, a problem. What are we going to do about global warring? What are we going to do about China wants to reunify with Taiwan?

**中文翻译:**
战略是为了克服高风险挑战而进行的一种设计。它是为了应对挑战而设计的政策和行动的结合。挑战可能是积极的，比如：“天哪，我们在后院闲逛时发现了石油，我们该怎么办？”也可能是消极的，比如某项创新正将我们赶出市场。但挑战是战略中最难的部分。“战略”这个词源于希腊语 *Strategos*。古希腊人选举 10 位 *Strategoi*（将军/战略官）担任雅典的战略领袖。他们被选出来处理当时的重大问题：波斯人入侵、城里发生了瘟疫、我们需要钱建新神庙。这就是这个词的来源。它不仅仅是军事层面的，在雅典时期就不是。所以战略总是关于处理一个议题、一个挑战、一个问题。我们要如何应对全球变暖？我们要如何应对中国想要统一台湾？

---

### [00:06:24] Lenny

**English:**
You obviously have these very infamous famous elements of a good strategy, something you call the colonel. Can you just talk through those pieces?

**中文翻译:**
你显然提出过那些非常著名（甚至可以说是“臭名昭著”）的好战略要素，你称之为“核心”（the kernel）。你能详细讲讲这些组成部分吗？

---

### [00:06:33] Richard Rumelt

**English:**
Right, sure. So when I used to teach strategy for many years at Harvard and then at UCLA and other places, there's lots of ways of looking at strategy. And so years and years ago, we used to look at the [inaudible 00:06:51] and the matrix and the five forces and all of those kinds of analytical tools. And it began to dawn on me at some point that this is a strategy. These are analytical tools for analyzing the problem, for thinking about things, for looking at competition. But they're not strategy. Strategy is, one, and I started to write a book and the first chapter of the book was... the first part I wrote was the David and Goliath strategy story. And my point in writing about David and Goliath was that the surprise that David is able to beat this giant warrior, and that's a strategy story. Strategy story is about discovered strength.
(00:07:43):
It's about, oh wow, look at how they did that. Look at how he got made in five moves. That's a strategy story. Look at how Steve Jobs changed the world when people couldn't expect it. That's emotionally what a strategy story is. So I want to write about strategy. And my wife Kate asked me, "Well, do you define strategy?" I said, "Oh, it's really hard. I can't define it." And she said, "Well, you can't write a book about it if you can't define it." Because I said I had this other conceptual scheme in my head that all teachers and writers had, which is that there's a bunch of analytical tools. And this is back in 2005, 2004.
(00:08:31):
And I gradually came to the realization all strategy is problem solving. It's a form of dealing with challenges, and that was a basic idea going in the book. So if that's the core of it, what's the basic activity? What are you doing when you create a strategy? Well, you're diagnosing the situation. You're trying to figure out what's going on here. What's the nature of reality that you're dealing with? Now, humans can't understand all of reality. No one can. So part of what a diagnosis is, is a decision about what you're going to pay attention to and the hypothesis for several hypotheses about what's going on, how do things connect together. And that's beginning of the diagnosis. And so diagnosis is an understanding of the situation that you're in. Well, that's not novel. And you can use any of those tools that are famous for that and you can try to find forces. You can do any one of a number of things to try to comprehend the situation. The world is more complicated than 2x2s, unfortunately. I was educated as an electrical engineer and my early years were spent designing spacecraft for NASA. And when I got into looking at business and business strategy stuff, I was always amazed at how unintellectual it was, that I was struggling to master Z-transforms and multiple, and yet these people are looking at 2x2s and little diagrams [inaudible 00:10:19], oh, that's what the company's about. So a rich diagnosis of the situation, but then a guiding policy.
(00:10:28):
The guiding policy is what are we going to do? Now, it's a simple thing to say, a guiding policy, and the guiding policy is sort of the strategy. It's the core of it. It's here's how we're dealing with the situation. And yet, when I say that, it flies in the face of, as I was writing that, I had a client who had 17 priorities. This is what we're doing. We have 17 priorities. And that's the opposite of policy. That's a laundry list of all the things we wish would happen over the next year. We're going to gain market share in China, we're going to cut our emissions, we're going to save energy, we're going to become safer, we're going to cut costs, all these different things that we're going to do. And they're all priorities. Now, lots of people need misuse the word priority when they're trying to do all that. You wouldn't want to be in a commercial airplane and hear the tower say to the pilot, "I'm giving priority to the following three planes on runway five." Right away, you know there's something wrong.
(00:11:50):
Well, that's the word priority, it means the first. It doesn't mean the grab back everything that you can think of that might matter. It means what's first. And so the guiding policy is sort at that level of what do we really have to do here and what are we doing and what are we not doing to deal with the diagnosis that we created?
(00:12:14):
And then the most important part of a strategy, the part that it's so easy to leave out because people like to think of strategy as this high level conceptual thing, is the coherent action. You have to do something. And what you do has to be coherent in several ways. The first way is it has to deal with the problem or the diagnosis and the guiding policy, it has to implement. It has to be coherent in that you shouldn't do things that fight each other.
(00:12:51):
You shouldn't say, "Oh, we are going to burn less oil and at the same time we're going to import more oil." It doesn't make any sense to do things that are self-contradictory. And yet, people do it. Most companies have strategic goals of increasing growth and increasing profit. Magically, that can happen in some cases. Growth and profit, they battle each other. Let's say we define profit as return on equity. If you're going to increase growth and increase return on equity, how do you do that? Because you're basically trying to invest less to get your return on equity up. Or you're going to grow and get your profit margin up. Well, how are you going to do that? You get your profit margin up and grow faster.
(00:13:52):
This is baby talk, but CEO after CEO will stand up and say, "Well, we're going to grow and we're going to make a profit." And so having coherent actions, actions that dump milk on one another is an important part of strategy. All three elements have to be there. There has to be an understanding of the situation. There has to be a guiding policy, how are we going to deal with it? And that could be a long-term sense of how we could change. You don't have to change your strategy every five minutes or every five years. If you're making Almond Joy candy bars or something, you don't really change your strategy constantly. If you're in the tech business, of course you have a shorter time horizon. And then the coherence and action is critical. And so these are the three, what I call basic elements, the kernel that if anyone in three is missing, something's wrong. It's not really a strategy, it's something else.

**中文翻译:**
好的，当然。我在哈佛、UCLA 以及其他地方教了很多年战略，看待战略有很多种方式。很多年前，我们习惯看矩阵、五力模型以及所有这类分析工具。但在某个时刻我突然意识到，这些并不是战略。这些是分析问题的工具，是思考事物、观察竞争的工具。但它们不是战略。战略是——我开始写一本书，书的第一章，或者说我写的第一部分，是关于大卫与歌利亚的战略故事。我写大卫与歌利亚的目的是想说明，大卫能击败这个巨人战士是令人惊讶的，这就是一个战略故事。战略故事是关于“发现力量”。
(00:07:43):
它是关于“噢，哇，看他们是怎么做到的。看他如何在五步之内将死对手。”这就是战略故事。看史蒂夫·乔布斯如何在人们意想不到的时候改变世界。从情感上讲，这就是战略故事。所以我想要写战略。我的妻子 Kate 问我：“那你怎么定义战略？”我说：“噢，这很难，我定义不了。”她说：“如果你定义不了，你就没法写书。”因为我当时脑子里有另一种所有老师和作家都有的概念体系，即一堆分析工具。那是 2004、2005 年左右。
(00:08:31):
后来我逐渐意识到，所有的战略都是解决问题。它是应对挑战的一种形式，这就是书中的基本思想。那么，如果这是核心，基本活动是什么？当你制定战略时，你在做什么？首先，你在**诊断（diagnosis）**局势。你试图弄清楚这里发生了什么。你所面对的现实本质是什么？人类无法理解现实的全部，没人能做到。所以诊断的一部分是决定你要关注什么，并对正在发生的事情以及事物如何连接提出一个或多个假设。这就是诊断的开始。诊断是对你所处局势的理解。这并不新奇，你可以使用任何著名的工具来理解局势。不幸的是，世界比 2x2 矩阵复杂得多。我受的是电气工程师教育，早年为 NASA 设计航天器。当我开始研究商业和战略时，我总是惊讶于它是多么地“非智力化”——我当时正努力掌握 Z 变换和多元分析，而这些人却在看 2x2 矩阵和小图表，然后说：“噢，这就是公司的核心。”所以，首先是对局势的深刻诊断，然后是**指导方针（guiding policy）**。
(00:10:28):
指导方针就是“我们要怎么做？”说起来简单，指导方针其实就是战略的核心。它是“我们如何应对这种情况”。然而，当我这么说时，它与现实大相径庭。我写书时有一个客户，他们有 17 个“优先事项”。这就是我们要做的，我们有 17 个优先事项。这正是政策的反面。那是一份清单，列出了所有希望在明年发生的事情：我们要在中国获得市场份额，我们要减少排放，我们要节约能源，我们要变得更安全，我们要削减成本。这些全是优先事项。很多人在做这些事时误用了“优先事项”（priority）这个词。你肯定不想在商业飞机上听到塔台对飞行员说：“我给 5 号跑道的以下三架飞机优先权。”你立刻就知道出问题了。
(00:11:50):
“优先”这个词意味着“第一”。它不是指把你认为重要的所有东西都抓过来，而是指什么是第一位的。所以指导方针就是在这个层面上：为了应对我们做出的诊断，我们真正必须做的是什么？我们在做什么，以及我们不做什么？
(00:12:14):
然后是战略中最重要的部分，也是最容易被遗漏的部分（因为人们喜欢把战略看作高大上的概念），那就是**连贯行动（coherent action）**。你必须做点什么。而且你所做的必须在几个方面保持连贯。首先，它必须应对问题、诊断和指导方针，它必须落地。连贯性还意味着你不应该做互相矛盾的事情。
(00:12:51):
你不应该说：“噢，我们要减少石油消耗，同时我们要增加石油进口。”做自相矛盾的事情毫无意义。然而，人们确实在这么做。大多数公司都有增加增长和增加利润的战略目标。在某些情况下，这能奇迹般地发生。但增长和利润往往是互相博弈的。假设我们将利润定义为净资产收益率（ROE）。如果你要增加增长并提高 ROE，你怎么做？因为你基本上是在尝试减少投资来提高 ROE。或者你要增长并提高利润率。你怎么能既提高利润率又增长得更快呢？
(00:13:52):
这听起来像儿戏，但一个又一个 CEO 站出来说：“我们要增长，我们要盈利。”因此，拥有连贯的行动——而不是互相泼冷水的行动——是战略的重要组成部分。这三个要素必须同时存在：必须有对局势的理解（诊断），必须有应对方案（指导方针），以及连贯的行动。指导方针可以是一种长期的变革感。你不需要每五分钟或每五年改变一次战略。如果你是做 Almond Joy 糖果棒之类的，你不需要经常改变战略。如果你在科技行业，时间跨度当然会短一些。连贯行动至关重要。这就是我所说的三个基本要素，即“核心”。如果其中任何一个缺失，那就出问题了，那不是真正的战略，而是别的什么东西。

---

### [00:15:04] Lenny

**English:**
Awesome. Okay. Is there an example that you could give that makes these even more concrete of just, I don't know, something that comes to mind that's a quick example of a strategy that illustrates these three components?

**中文翻译:**
太棒了。好的。你能举个例子让这些概念更具体吗？比如，有没有什么信手拈来的例子，能快速说明包含这三个要素的战略？

---

### [00:15:17] Richard Rumelt

**English:**
If you're Microsoft right now and you're trying to adapt to AI, you have a diagnosis. Well, what's going on? You see the challenge of how do we adapt to it? You create a guiding policy that you're going to invest in one of the major leaders and that you're going to begin to incorporate that into your search engine. And then you have coherent actions. You actually do some of these things. It's not rocket science. The difficulty is that companies don't do that.
(00:15:55):
There are companies that say, "Well, our future is"... let's say something that's not in a software business. That's industry 4.0 for 5.0 that we're going to have... we're investing in the future of robotics and AI and even computer vision and all that. That's going to be our future. And then you see what they're doing. They've bought this company, they've bought this company, they've bought this company, and that's it. It's strategic assembly without any synthesis. So strategy's not mysterious. What's mysterious to me, what was mysterious to me and what remains mysterious to me is how so many organizational leaders don't do it. They create bad strategy. They do something that they say is strategy and then it's not.

**中文翻译:**
如果你是现在的微软，你正试图适应 AI，你有一个诊断。发生了什么？你看到了“我们如何适应它”的挑战。你制定了一个指导方针：投资其中一个主要的领军者（指 OpenAI），并开始将其整合到你的搜索引擎中。然后你有连贯的行动：你确实去做了这些事。这并不是什么高深莫测的科学。难点在于很多公司并不这么做。
(00:15:55):
有些公司会说：“我们的未来是……”假设是一家非软件公司，“是工业 4.0 或 5.0，我们要投资机器人、AI 甚至计算机视觉的未来。那是我们的未来。”然后你看他们在做什么：他们买了这家公司，买了那家公司，又买了另一家公司，仅此而已。这只是“战略组装”，没有任何综合集成。所以战略并不神秘。对我来说，真正神秘的——过去是，现在依然是——为什么这么多组织领导者不这样做。他们制定坏战略。他们做了一些自称为战略的事情，但其实根本不是。

---

### [00:16:55] Lenny

**English:**
You have a whole chapter on this, on what is a bad strategy. Can we just touch on a few of the things you see as signs that your strategy is bad or maybe it doesn't even exist?

**中文翻译:**
你有一整章专门讲这个，关于什么是坏战略。我们能不能简单谈谈你认为的坏战略迹象，或者甚至根本不存在战略的迹象？

---

### [00:17:05] Richard Rumelt

**English:**
Sure. When I wrote Good Strategy Bad Strategy, a lot of people resonated with the bad strategy. Part of the book, they wrote emails and saying, "Oh my God, thank goodness someone just finally said that these long and terminal meetings I sit through are not actually strategy." Or these documents that the company produces are not actually strategy. And they're not. Bad strategy, the standard bad strategy for a corporation is a set of profit goals or performance goals. A set of goals. Goals are the engineering of how companies work to some extent. But abstract, high-level goals, they're not strategy, they're something else. They're ambitions. And ambitions are not a strategy. A list of all the different things you wish would happen is not strategy.
(00:18:13):
I was asked to help part of the U.S. Department of Defense create a strategy for what's 17 different intelligence agencies.

**中文翻译:**
当然。当我写《好战略，坏战略》时，很多人对“坏战略”部分产生了共鸣。他们写邮件说：“天哪，谢天谢地，终于有人说出我参加的那些没完没了的会议根本不是战略了。”或者公司产出的那些文档根本不是战略。确实不是。坏战略，对于一家公司来说，标准的坏战略就是一堆利润目标或绩效目标。一堆目标。在某种程度上，目标是公司运作的工程学。但抽象的、高层级的目标不是战略，它们是别的东西。它们是雄心（ambitions）。雄心不是战略。一份列出你希望发生的所有事情的清单也不是战略。
(00:18:13):
我曾被邀请协助美国国防部的一部分，为 17 个不同的情报机构制定战略。

---

### [00:18:26] Lenny

**English:**
Wow, how cool.

**中文翻译:**
哇，太酷了。

---

### [00:18:29] Richard Rumelt

**English:**
Yeah. There's 17 different intelligence agencies. And the strategy basically that these people had written said the 17 agencies should work together more effectively. Now, you don't have to be a Russian spy to see that what they're really saying is these guys aren't working together effectively and it's a problem. But they didn't say that. They said the strategy is they're going to work together more effectively. Just like the RV always comes out with our strategy is join us, meaning we're having trouble with coordinating.
(00:19:08):
But then there's nothing there about that other than this is what should happen, there should be more effective coordination. And oh, we'll have an office of coordination, put a person in charge of coordination. But there's no sensible... why is it hard to coordinate? What are the barriers to this? This has been going on for 34 years now. What's holding it back? What is a problem we have to solve? It's not there.
(00:19:37):
So I was hired to do a foundry for a company and they said, "Well, our diagnosis is not growing fast enough." Okay, let's get into that because that's not a diagnosis, that's a statement. It's a statement of value, you would like to grow faster than you are. I'd like to be taller than I am. I'd like to have more hair. You want to grow faster. Okay, so what's holding you back? And from [inaudible 00:20:19]. But saying, okay, we're going to grow, that's not a strategy.
(00:20:23):
Bad strategy also is fluff. People will use fancy words to describe their situation. Since I wrote that, the term word salad has become common. And there's a lot of word salad writing that people try to use to describe their situation. It sounds more abstract perhaps more abstract. Therefore, it's more strategic, incoherent stuff where we're going to do A, and we're going to B and those two things obviously fight one another. All those things are part of bad strategy. Bad strategy is a document or a set of intentions or a set of verbalizations where it's not a strategy. There's no diagnosis. Of course, I don't doubt that. Started out saying where United States is falling behind in education. And he's looking at the piece of the PISA test scores of 15 year olds around the world. And it's true, the United States is down, number of 30 countries in terms of the scores of our 15-year-old, in math and in general knowledge. Okay, correct statement, we're falling behind. A real diagnosis would say, because. We jumped immediately to therefore, we're going to have more people go to college than any other country. Well, having more people go to college doesn't solve the problem of 15 year olds not being able to do elementary math. Hopefully it doesn't screw up colleges everywhere. So that kind of gap, it's there, where you don't do the diagnosis. Why do we have this? We argue over diagnosis as part of politics and part of organizational politics. That's what we do, and that's important. To do a strategy, you have to resolve the argument. Why do we have a homeless explosion in Portland or Seattle or Los Angeles? And people argue about that. Some people say, "Oh, strokes." Some people say, "Oh no, housing is too expensive." There are different diagnosis. But to deal with the issue, you have to decide on the diagnosis. The politicians right now sort of decided for a few years that the problem is housing's too expensive, we're going to build housing at $700,000 a unit and give it to the all people. Okay. If you build it, they will come.
(00:23:28):
But then the next problem is, well, can't seem to build a housing. And so again, you need a new diagnosis. Why can't you build a housing? You're a rich, powerful country. Why can't you build some housing? So diagnosis is critical to understanding it. And in public policy, we argue over the diagnosis. And in organizations we argue. And unless you resolve it, you can't act. So lacking diagnosis is one of the key reasons for bad strategy. The other, the fluff and the incoherent actions are fun to describe, but they're less common. The second major source of bad strategy is mistaking goals for strategy, saying these goals are our strategy. And that leaves out so many of the important aspects.

**中文翻译:**
是的。有 17 个不同的情报机构。这些人写的战略基本上是说：这 17 个机构应该更有效地合作。现在，你不需要是俄罗斯间谍也能看出，他们真正想说的是“这些家伙没有有效合作，这是个问题”。但他们没这么说。他们说战略是“他们将更有效地合作”。就像房车（RV）广告总是说“我们的战略是加入我们”，意思是我们在协调上遇到了麻烦。
(00:19:08):
但除了“这应该是发生的事，应该有更有效的协调”之外，什么都没有。噢，我们会设一个协调办公室，找个人负责协调。但没有理性的分析……为什么协调很难？障碍是什么？这种情况已经持续 34 年了。是什么在阻碍它？我们需要解决的问题是什么？这些都没有。
(00:19:37):
我曾受雇为一家公司做“铸造厂”（foundry，指战略研讨会），他们说：“我们的诊断是增长不够快。”好吧，让我们深入探讨一下，因为那不是诊断，那是一个陈述。那是一个价值陈述，你希望比现在长得更快。我还想比现在更高呢，我还想头发更多呢。你想长得更快，好，那是什么在阻碍你？但是说“我们要增长”，那不是战略。
(00:20:23):
坏战略还包括“空话”（fluff）。人们会用华丽的词藻来描述他们的处境。自从我写了那本书，“文字沙拉”（word salad）这个词变得很流行。很多人试图用文字沙拉来描述局势。听起来很抽象，也许越抽象就显得越有战略性。还有不连贯的内容，比如我们要执行 A，又要执行 B，而这两件事显然是冲突的。所有这些都是坏战略的一部分。坏战略是一份文档、一系列意图或一系列言语，但它不是战略。没有诊断。当然，我不怀疑这一点。比如有人开始说美国在教育方面落后了，他看着全球 15 岁青少年的 PISA 测试成绩。确实，美国 15 岁孩子在数学和常识方面的得分在 30 个国家中排名靠后。好，陈述正确，我们落后了。但真正的诊断应该说“因为……”。我们却直接跳到了“因此，我们要让比任何其他国家更多的人上大学”。好吧，让更多人上大学并不能解决 15 岁孩子不会做初等数学的问题。希望这不会搞垮各地的大学。这种差距就在那里，因为你没有做诊断。为什么会这样？在政治和组织政治中，我们为诊断而争论。这是我们做的，这很重要。要制定战略，你必须解决争论。为什么波特兰、西雅图或洛杉矶的流浪汉爆炸式增长？人们为此争论。有人说是中风/疾病，有人说是因为房价太贵。有不同的诊断。但要处理这个问题，你必须确定一个诊断。现在的政客们几年前认定问题是房价太贵，我们要以每套 70 万美元的成本造房子给所有人住。好，“如果你造了，他们就会来”。
(00:23:28):
但接下来的问题是，好像造不出房子。所以，你又需要一个新的诊断。为什么造不出房子？你是一个富有、强大的国家，为什么造不出一些房子？所以诊断对于理解问题至关重要。在公共政策中，我们为诊断争论；在组织中，我们也争论。除非你解决了争论，否则你无法行动。所以，缺乏诊断是坏战略的关键原因之一。其他的，如空话和不连贯的行动，描述起来很有趣，但没那么普遍。坏战略的第二个主要来源是将目标误认为战略，说“这些目标就是我们的战略”。这遗漏了太多重要的方面。

---

### [00:24:22] Lenny

**English:**
Amazing. So just to summarize somewhat, if you're missing a diagnosis, trying to explain what exactly is wrong, it's a sign your strategy is incomplete or bad. If you're missing concrete actions, it's a sign that your strategy is incomplete or bad. There's also I think an element of coherence. The actions have to connect and there have to be a few, very few of them. I always like to think of three as a good number. Is that something you think about, the rule of thirds for actions you want to take or even the guiding policy, or is there a number that you think about just like no more than this?

**中文翻译:**
太棒了。稍微总结一下：如果你缺少诊断，即试图解释到底哪里出了问题，这是战略不完整或糟糕的迹象。如果你缺少具体的行动，也是战略不完整或糟糕的迹象。我认为还有一个连贯性的要素。行动必须相互关联，而且数量必须很少，非常少。我总觉得“三”是个不错的数字。你会考虑这个吗？比如行动或指导方针的“三原则”，或者你心中有没有一个“不能超过这个数”的限制？

---

### [00:24:53] Richard Rumelt

**English:**
A few. A few. Not too many. Not 17. It's hard. Numbers. We work best when we concentrate. We're more effective when we concentrate on a few things, a few people, a few... focus, it's the fundamental source of power and strategy. Trying to do too many different things is defocusing.

**中文翻译:**
几个。就几个。不要太多。绝对不是 17 个。这很难。数字很重要。当我们集中精力时，表现最好。当我们专注于少数几件事、少数几个人、少数几个……焦点（focus）时，我们更有效率。焦点是战略力量的根本来源。尝试做太多不同的事情会分散焦点。

---

### [00:25:18] Lenny

**English:**
I think there's this quote in your book that I think is, and this may be paraphrasing, each time you say yes, you risk turning a nascent good strategy into a bad strategy.

**中文翻译:**
我记得你书里有一句话，大概意思是：你每说一次“好”（yes），就有可能把一个初具雏形的好战略变成坏战略。

---

### [00:25:28] Richard Rumelt

**English:**
Yes. Focus is... when I was nine years old, I was at summer camp and I had my parents sent me a magnifying glass and I was out there using the sun to try to cook a piece of wood. I think I had a piece of cloth that I was trying to burn, wasn't having much luck. The magnifying glass focuses the sun's rays on the spot. Counselor came over and he said, "Try this," and he pulled out a black thread from his T-shirt, put it down. And I focused the sun's rays hard, popped out. So stupid little story. But to burn that black thread, there has to be a source of power, the sun. There has to be a focus, that's the magnifying that to the power. And it has to be a target that can be affected. It has to be a black thread, not white thread. And that sequence is part of strategic action. You need a source of power. I say power, I don't say advantage or efficiency.
(00:26:53):
I say power because there are different ways in which power is exhibited and you have to focus the power on a target that can actually be affected or achieved. And this is real simple logic, but it's a discipline to focus power on a target that you can affect. Take American power and say we're going to change China's trajectory and Russia's trajectory and our own and to name all the 30 countries around the world that we're trying... we're diffusing our efforts because they're not the same. They're going in different directions. Obvious when you say it, not so obvious as you live it, because like any organization, like any big organization, US government has different interests. They're pursuing different interests funded for different purposes with different clientele. And so there's gradually a diffusion-

**中文翻译:**
是的。焦点就是……我九岁在夏令营时，父母给我寄了一个放大镜。我在外面试着用太阳光去“煮”一块木头。我记得我还试着烧一块布，但运气不太好。放大镜将阳光聚焦在一个点上。辅导员走过来，说：“试试这个。”他从 T 恤上扯下一根黑线放在地上。我用力聚焦阳光，线一下子就着了。一个很傻的小故事。但要烧掉那根黑线，必须有一个能量源——太阳；必须有一个焦点——放大镜；还必须有一个可以被影响的目标——必须是黑线，而不是白线。这个序列就是战略行动的一部分。你需要一个力量源。我说的是“力量”（power），而不是“优势”或“效率”。
(00:26:53):
我说力量是因为力量有不同的表现方式，你必须将力量聚焦在一个真正可以被影响或实现的目标上。这是非常简单的逻辑，但将力量聚焦在你可以影响的目标上是一种纪律。拿美国的力量来说，如果我们说我们要改变中国的轨迹、俄罗斯的轨迹、我们自己的轨迹，还要点名世界上我们正在尝试影响的所有 30 个国家……我们就在分散精力，因为它们并不相同，它们朝着不同的方向发展。说起来很明显，但在实践中却没那么明显，因为像任何组织、任何大组织一样，美国政府有不同的利益。他们为了不同的目的、针对不同的客户群体追求不同的利益。因此，精力逐渐分散——

---

### [00:28:00] Richard Rumelt

**English:**
And so there's gradually a diffusion of effort. One of the big issues in strategy is simply the organization, complex organizations particularly. You have a hard time focusing energy because of all the different interests.

**中文翻译:**
因此，努力逐渐分散。战略中的一个大问题仅仅在于组织本身，特别是复杂的组织。由于所有不同的利益纠葛，你很难集中精力。

---

### [00:28:21] Lenny

**English:**
Yeah. Actually I want to talk about both those things, so I'm glad that you teed them up. Let's talk about power. What is this idea of power and how does that play into strategy? Why is it so important? And then what are some examples of power that people can think about when they're trying to think about implementing and adding a power to their strategy?

**中文翻译:**
是的。实际上我想谈谈这两件事，很高兴你提到了它们。让我们谈谈“力量”。这种力量的概念是什么？它如何融入战略？为什么它如此重要？当人们试图在战略中实施和增加力量时，有哪些可以参考的力量例子？

---

### [00:28:40] Richard Rumelt

**English:**
Well, in a competitive situation, the fundamental aspect of power is something that's going to give you some sort of advantage. Usually it's in asymmetry of some kind. If two fighters are equally balanced or two horses are equally fetched or two armies are equally... And they meet in competition, it's 50/50. Who knows what will happen. For a strategy you need to exploit in asymmetry of some kind. You hear a little faster. Or they're a little... Something has to be different between now and between things. So that's the beginning of power, is asymmetry. We can think of it as leverage, but sometimes think first is a source of power.
(00:29:43):
Being first to recognize something can be a source of power. Having a reputation of a certain kind gives you some power that someone doesn't have that reputation doesn't have. On the other hand, having a well-established reputation of a certain type can be the opposite of power because people don't expect you to be able to do something new. They expect you to be able to do this, but not that. Having relationships can be a source of power. When Gerstner took over IBM as it was failing in the face of the microprocessor revolution, he recognized that their primary asset, their source of power, was that they were respected and they had [inaudible 00:30:38] into every large corporation on the planet. Nobody else had that as an actual producing company. And so he said, we're going to embrace our customers. Bear hug our customers. We're going to serve our customers.
(00:30:58):
That's our source of our power. That's our leverage. That's the synergy. Now the world begins to change and computing begins to move to the cloud. And IBM's customers, the largest companies in the world, are the most hesitant to do that, because they've got the big IT departments that don't want move to cloud. And so small companies move to the cloud and the big companies are, well, it's insecure in the cloud. We'd have to lay off people. We have these big machines we like to run.
(00:31:39):
And so IBM then becomes disadvantaged in the new world because it inherits this big company orientation and that lagging behind. So the opposite side of power is what you inherit. From [inaudible 00:32:01] can be the wrong thing. But a source of power is that. A source of power can be an invention, a source of power can be a particular customer base that you have identified. It doesn't last forever, power, but all the different sources of advantage that are sometimes transitory and sometimes permanent are sources of power that a company has to use to compete and survive.

**中文翻译:**
在竞争局势中，力量的根本方面是能给你带来某种优势的东西。通常这是一种**不对称性（asymmetry）**。如果两个拳击手势均力敌，或者两匹马不相上下，或者两支军队旗鼓相当……他们在竞争中相遇，胜负就是 50/50。谁知道会发生什么。为了制定战略，你需要利用某种不对称性。你反应快一点，或者他们慢一点……事物之间必须有所不同。所以力量的开始就是不对称性。我们可以把它看作杠杆，但有时首先要考虑力量的来源。
(00:29:43):
率先意识到某件事可以成为力量源。拥有某种声誉会给你带来没有这种声誉的人所不具备的力量。另一方面，拥有某种根深蒂固的声誉也可能是力量的反面，因为人们不期望你能做新事情。他们期望你能做这个，而不是那个。拥有关系也可以是力量源。当郭士纳（Gerstner）在 IBM 面临微处理器革命失败时接手公司，他意识到他们的主要资产、他们的力量源泉是：他们受人尊敬，并且与地球上每一家大公司都有深入联系。作为一家实际的生产型公司，没有其他人拥有这一点。所以他说，我们要拥抱我们的客户，给客户一个“熊抱”，我们要服务于我们的客户。
(00:30:58):
这就是我们的力量源泉。这就是我们的杠杆。这就是协同效应。现在世界开始变化，计算开始向云端迁移。而 IBM 的客户——世界上那些最大的公司——对此最为犹豫，因为他们有庞大的 IT 部门，不想搬到云端。于是小公司搬到了云端，而大公司则说：“云端不安全，我们得裁员，我们喜欢运行这些大机器。”
(00:31:39):
于是 IBM 在新世界中变得处于劣势，因为它继承了这种大公司导向，导致了落后。所以力量的另一面是你继承的东西。继承的东西可能是错误的。但力量源就是这些：它可以是一项发明，可以是你识别出的特定客户群。力量不会永远持续，但所有这些有时是暂时的、有时是永久的优势来源，都是公司必须用来竞争和生存的力量源。

---

### [00:32:35] Lenny

**English:**
I imagine people listening are just like, oh man, I got to figure out the power, the advantage that I have with my business. Is there any advice you could share about helping people figure out where their power might lie?

**中文翻译:**
我想听众们现在肯定在想：天哪，我得弄清楚我的业务拥有什么样的力量和优势。关于如何帮助人们发现自己的力量所在，你有什么建议吗？

---

### [00:32:46] Richard Rumelt

**English:**
That's a good question, Lenny. So how do you figure it out? So I start, as I said earlier, with the symmetries. In what way is my company different than other companies? In what way is my team different? What do we know that other people don't know? What do we possess that other people don't possess? So there has to be some asymmetry to create competitive power, there has to be something different.
(00:33:17):
Sometimes you have to redefine your space down small amount. Then you can actually see it, particularly a smaller company that doesn't have worldwide power, has power in a certain marketplace or a certain set of customers or sometimes it's not customers. Sometimes the power isn't who you can bring in and hire. So if you invented ChatGPT, you can bring in the smartest AI people for a year or two because all the smart AI people want to work at the cutting edge with the current winner.
(00:33:58):
Then they'll start to arguing with each other and in fight and there'll be all sorts of embarrassing personnel things going on and someone else can grab that position, if it's not well managed. Business is exciting in that sense that it's not stable. It's not just as it was when I was first studying it. It's not just IBM and Sears and AT&T forever. There's a constant changing of the guard.

**中文翻译:**
这是个好问题，Lenny。怎么弄清楚呢？就像我之前说的，从不对称性开始。我的公司在哪些方面与其他公司不同？我的团队在哪些方面不同？我们知道哪些别人不知道的事情？我们拥有哪些别人不拥有的东西？要创造竞争力量，必须有某种不对称性，必须有不同之处。
(00:33:17):
有时你必须将你的空间重新定义得小一点，然后你才能真正看到它。特别是对于一家没有全球力量的小公司，它在某个特定市场或某组特定客户中拥有力量。有时力量不在于客户，而在于你能招到谁。如果你发明了 ChatGPT，你可以在一两年内招到最聪明的 AI 人才，因为所有聪明的 AI 人才都想在最前沿与当前的赢家一起工作。
(00:33:58):
然后他们会开始互相争论、内斗，会出现各种尴尬的人事问题，如果管理不善，别人就会夺走那个位置。从这个意义上说，商业是令人兴奋的，因为它不稳定。它不像我刚开始研究时那样，永远只有 IBM、西尔斯（Sears）和 AT&T。这里总是在不断地“换岗”。

---

### [00:34:30] Lenny

**English:**
For better or worse.

**中文翻译:**
无论好坏。

---

### [00:34:32] Richard Rumelt

**English:**
For better. Because if you look at government, there is no changing of the guard and they get stultified.

**中文翻译:**
是好事。因为如果你看政府，那里没有“换岗”，于是他们变得僵化。

---

### [00:34:38] Lenny

**English:**
Makes sense. So in your book, you have this whole list of types of power. I'll just read them real quick. Leverage, proximate, objectives, chain link systems, design, focus, growth, advantages, dynamics, inertia, entropy. There's also the book, obviously The Seven Powers, that a lot of people are aware of. I guess how do you think about just the spectrum of types of power you can have? Is this it? Are there others?

**中文翻译:**
有道理。在你的书里，你列出了一整张力量类型的清单。我快速读一下：杠杆（Leverage）、接近目标（proximate objectives）、链式系统（chain link systems）、设计（design）、焦点（focus）、增长（growth）、优势（advantages）、动态（dynamics）、惯性（inertia）、熵（entropy）。当然还有那本很多人都知道的《七大策略力量》（The Seven Powers）。你怎么看待这些力量类型的光谱？就这些吗？还有其他的吗？

---

### [00:35:02] Richard Rumelt

**English:**
I started to make a list there in the book and I wrote up a bit about chain link systems and today, I mean the power that new business models are exploiting is the power of the user base. What we called years ago, network effects, where the more users you have, the more useful a product is. So I think the idea of network effects first arose with the telehealth system, which the idea was that you don't want to be connected to a telephone system that only connects to two other people. It's not all that useful. It's got to connect to the world to be useful.
(00:35:43):
And my colleague Marvin Lieberman was taking the economics course at Harvard University at the same time that Bill Gates was a student in that classroom. Professor's going on about network effects and of course that's what catapulted him, had his software, MS DOS at the time. Not MS DOS, he had something called basic that... The network effect was huge. He got angry about the network effect because people wouldn't pay him. They kept stealing it and using it and pretty soon everybody in the microcomputer industry had M Basic.
(00:36:27):
Then we get the network effects from not just software, but user base is now with the internet and so you get network effects with big social media. No one wants to be on a social media if only three other people are on. So having a large network...
(00:36:50):
Amazon. Get big fast because the economics are amazing. So we used to say, well, in a department store, economics are that you're saving people the cost of going out of the store and walking down the street to another store. So now it's all in one place. Supermarkets, the same thing. But look at a thing like Amazon where there the ease of shopping on Amazon keeps people from leaving it and going to another website. Now other websites have gotten better and better and some of that is less strong than it used to be and this is a constant struggle with it. Nevertheless, the size of the user bench there is an important source of a symmetry and power for the people that have come out ahead and won that battle for this round, this five years to 10 years. How long does it last before some other thing begins to take precedent. And now we have two-sided markets, whether it's credit cards or places where both buyers and sellers get together.
(00:38:01):
And so here these big forces that companies are playing with right now are these network effects.
(00:38:10):
And when the new generative AI, we have the possibility of stronger effects than we've ever seen before, but we don't know yet. But the suspicion is that size is what matters, that the size of the data that you could put into the learning algorithm is going to make your AI better. And so again, a big... It's going to matter.
(00:38:43):
Just think of Google and their ability to improve search based upon all the searches that go on on their base every day. It's very hard for Bing to catch up because Bing doesn't have as much data to train on. And so unless there's some new innovation there that isn't just the amount of data, the leader again has this asymmetry working for it. Now, the way you get around all that is by being specialized, by owning a particular approach that isn't the market leader's approach. And it's always been that way in business, but our attention is often attracted by these giants.
(00:39:34):
So yeah, sources of power today where we look at the new business models that are part of the fabric are these network effects and things like that that are very, very strong. And people are trying to get those in startups and in small firms within a certain market space and build it as fast as possible to get ahead of others. There's been venture capital available to try those experiments and some of them work and some of them don't, but that's this new age we're in now, where the speed of building a market position with network effects is a dominant game in the tech space.

**中文翻译:**
我在书里列了一张清单，写了一些关于链式系统的内容。而今天，新商业模式正在利用的力量是用户群的力量。也就是我们多年前所说的“网络效应”（network effects）——用户越多，产品就越好用。我认为网络效应的概念最早出现在电话系统中，其核心思想是你不想连接到一个只能联系另外两个人的电话系统，那没多大用处，它必须连接到全世界才有用。
(00:35:43):
我的同事 Marvin Lieberman 在哈佛大学上经济学课时，比尔·盖茨也是那间教室的学生。教授在讲网络效应，当然，这正是让盖茨一飞冲天的原因。他当时有他的软件，MS-DOS 之前，他有一种叫 Basic 的东西……网络效应巨大。他曾对网络效应感到愤怒，因为人们不付钱给他，他们不断偷用它，很快微机行业的每个人都在用 M Basic。
(00:36:27):
后来我们不仅从软件中获得网络效应，现在互联网时代还从用户群中获得网络效应，比如大型社交媒体。如果只有另外三个人在上面，没人想玩社交媒体。所以拥有一个庞大的网络……
(00:36:50):
亚马逊。快速做大，因为经济效益惊人。我们过去常说，百货商店的经济效益在于你节省了人们走出商店、沿街走到另一家商店的成本，现在所有东西都在一个地方。超市也是一样。但看看亚马逊，在亚马逊购物的便利性让人们不愿离开它去另一个网站。现在其他网站也变得越来越好，这种优势不像以前那么强了，这是一场持续的斗争。尽管如此，用户规模是那些在这一轮（这 5 到 10 年）胜出的人的重要不对称性和力量来源。在其他事物开始占据主导地位之前，这能持续多久？现在我们还有双边市场，无论是信用卡还是买卖双方聚集的平台。
(00:38:01):
所以，现在公司利用的这些巨大力量就是网络效应。
(00:38:10):
在新的生成式 AI 领域，我们有可能看到比以往任何时候都更强的效应，但我们现在还不知道。但人们怀疑规模才是关键——你能输入学习算法的数据规模将使你的 AI 变得更好。所以，规模再次变得至关重要。
(00:38:43):
想想谷歌，他们有能力根据每天在其平台上进行的所有搜索来改进搜索。必应（Bing）很难追赶，因为必应没有那么多数据可供训练。因此，除非出现某种不依赖于数据量的新创新，否则领导者将再次拥有这种不对称性优势。现在，绕过这一切的方法是专业化，拥有一个不同于市场领导者的特定方法。商业一直以来都是如此，但我们的注意力往往被这些巨头所吸引。
(00:39:34):
所以，是的，今天我们看到的构成商业织锦的新力量源泉就是这些非常强大的网络效应。人们正试图在初创公司和特定市场空间的小公司中获得这些效应，并尽可能快地建立规模以领先于他人。风险投资一直支持这些实验，有些成功了，有些失败了。但这就是我们现在所处的新时代，在科技领域，利用网络效应快速建立市场地位是一场主导游戏。

---

### [00:40:25] Lenny

**English:**
I feel like Twitter is the ultimate example of the power of network effects, especially recently where if you think about it, everything about Twitter has changed and it still continues to run. You laid off 80% of people at the company, they changed the name, they changed the domain basically, the algorithms changed. I don't know what is still the same.

**中文翻译:**
我觉得 Twitter（现 X）是网络效应力量的终极例子，尤其是最近。如果你仔细想想，Twitter 的一切都变了，但它依然在运行。公司裁掉了 80% 的员工，改了名字，基本改了域名，算法也变了。我不知道还有什么是没变的。

---

### [00:40:45] Richard Rumelt

**English:**
How can you lay off 80% of the people and it still runs? I mean you got to wonder.

**中文翻译:**
你怎么能裁掉 80% 的人而它依然在运行？我是说，你肯定会感到好奇。

---

### [00:40:49] Lenny

**English:**
I love Twitter. I'm on there all the time. I feel like it's never been better, which is kind of wild.

**中文翻译:**
我喜欢 Twitter。我一直泡在上面。我觉得它从未像现在这么好过，这挺疯狂的。

---

### [00:40:54] Richard Rumelt

**English:**
Twitter's fascinating. I mean I tune into it every couple of days and see what's going on and it is just an amazing rumble of opinions and statements. It's much more interesting than it was five years ago.

**中文翻译:**
Twitter 很迷人。我是说，我每隔几天就会上去看看发生了什么，那里简直是各种观点和言论的奇妙混战。它比五年前有趣得多。

---

### [00:41:11] Lenny

**English:**
There's a lot of diagnosing and not a lot of concrete actions. But anyway, I wanted to come back to the element about power. I think when people are thinking about power, it may not be clear where that plugs into the diagnosis, the guiding policy and the coherent actions. Where should you be thinking and implementing this idea of where my power is when you're laying out your strategy?

**中文翻译:**
那里有很多诊断，但没多少具体行动。但不管怎样，我想回到关于“力量”的要素。我认为当人们思考力量时，可能不清楚它应该插入到诊断、指导方针和连贯行动的哪个环节。当你制定战略时，你应该在哪个环节思考并实施“我的力量在哪里”这个想法？

---

### [00:41:35] Richard Rumelt

**English:**
To undertake a strategy that you think will work, you've got to have a reason that it makes sense and that reason is derived from some source of power, some source of advantage. Ultimately, your power or your advantage is something based in history that has the feel of reputation, or institutional skill, or it's some kind of symmetry or knowledge that you have that others don't have. So it's a resource that you can use that your competitors or others don't have equal access to because you've either have mastered it or you own it or you inherited from the past.
(00:42:45):
All those things are sources of the power that you use to make it not an even bet. So when you walk into a casino, well maybe if you play poker with skill, you can expect to make some money, but the general casino games, you're going to expect to lose. And in business, statistically, if you come to me and you say, I'm going to open a new restaurant. What should my strategy be? My answer would be don't open a restaurant. Invest in the S&P 500 because the statistics are that new restaurants fail. So what makes you think that you can succeed? Oh, I really want to succeed. Not good enough. I trained under a chef who's been very successful. Oh, that's interesting. Tell me more.
(00:43:50):
So there, where's the asymmetry here? Where's the source of power where you go from the odds... The standard odds in this game are against people where you think the odds are in your favor.
(00:44:05):
That's the source of power we're looking for. We're looking for this information, this skill, this thing in the field, the way the resources are arranged, that's going to give you this edge. And some of that is sort of part of the situation and some of it's how you shape and focus your actions. Strategy tends to be surprising when we see it, when we see it work, and surprising because we don't expect it. We expect people to bumble around. We expect Arby's to bumble around. We expect nation states to bumble around. We don't expect them to execute coherent strategies.
(00:44:54):
The United States went to Afghanistan and it wanted to catch Osama bin Laden, but at the same time they didn't want to put an army in the shield to actually catch him because it would the embarrassing to have that many Americans in the field. That's what happened in Tora Bora. The Secretary of Defense said, no, we don't want to make it look like we're taking over the country, so they didn't try to catch him as hard as they could.
(00:45:22):
And we want to have the education of women and we want to have a democracy and we want to have a long list that we would have no opium production, but at the same time, our allies are the opiate producers. It was the Taliban that got rid of opiate. Americans didn't do it.
(00:45:44):
So we had all these different objectives. It doesn't work. You need to have a focus on something achievable. What's achievable? [inaudible 00:46:03] Nation-building is hard stuff. It takes a century. Afghanistan, I'm off on a tangent here with Afghanistan, but it's a really interesting subject. Afghanistan was a warlord society, a bunch of different warlords running the place. Well, what's a warlord society? Where else do we look for an analogies? Well, we look at [inaudible 00:46:32] in 1650. You look at France in 1300. You can look at Japan before the modern era. These are warlord societies. Well, how did they go from that to being a coherent government that maybe wasn't democratic at first, but still, there was a government instead of just as much war. It took some [inaudible 00:46:59] to conquer all the rest.
(00:47:02):
And then it took a long time for them to put in the structure itself of government and then maybe became a democracy. Maybe not, but that's the process. It's not like you just go in there and say, you're now no longer a warlord with society because we've decreed it.
(00:47:19):
I don't know. You're going to ask me more questions about what it is people should know and how do you get these sources of power? How do you get these insights? I'm a big fan of history. I'm a big fan of knowing things about what happened. Business history, biographies, war history.
(00:47:42):
If you don't have access to other times and other places and other things that have happened, it's very hard to think strategically about the situation you're in because there isn't a science of strategy. It's not like physics. It's not like engineering where we can write down the equations of stress on a beam and say, how thick does the beam have to be? It's not like that. A lot of it is based on analogy to previous human experience.

**中文翻译:**
要执行一个你认为会奏效的战略，你必须有一个它合理的理由，而这个理由源于某种力量源、某种优势源。最终，你的力量或优势是基于历史的东西，它具有声誉感、组织技能感，或者是你拥有而他人不具备的某种不对称性或知识。所以它是一种你可以利用的资源，而你的竞争对手或其他人无法平等地获得，因为你要么掌握了它，要么拥有它，要么从过去继承了它。
(00:42:45):
所有这些都是你用来让这场博弈不再是“对等赌注”的力量源泉。当你走进赌场，如果你有技巧地玩扑克，你可能期望赚点钱，但一般的赌场游戏，你注定会输。在商业中，从统计学上讲，如果你来找我说：“我要开一家新餐厅，我的战略应该是什么？”我的回答会是：“别开餐厅。去投标普 500 指数，因为统计数据显示新餐厅大多会失败。”那么，是什么让你认为你能成功？“噢，我真的很想成功。”这不够好。“我曾在一位非常成功的厨师手下受训。”噢，这很有趣，多跟我说说。
(00:43:50):
所以，这里的不对称性在哪里？力量源泉在哪里？让你从“标准赔率不利”变成“胜算在我”的东西是什么？
(00:44:05):
这就是我们要寻找的力量源泉。我们寻找的是这种信息、这种技能、这个领域里的东西、资源排列的方式，这些能给你带来优势。其中一部分是局势的一部分，另一部分是你如何塑造和聚焦你的行动。战略在奏效时往往令人惊讶，因为我们不预见它。我们预见人们会四处碰壁。我们预见 Arby's 会四处碰壁，预见民族国家会四处碰壁。我们不预见他们能执行连贯的战略。
(00:44:54):
美国去阿富汗想抓本·拉登，但同时他们不想投入军队去实地抓捕，因为在实地部署那么多美国人会很尴尬。这就是在托拉博拉（Tora Bora）发生的事情。国防部长说，不，我们不想让它看起来像是在接管那个国家，所以他们没有尽全力去抓他。
(00:45:22):
我们还想推行女性教育，想建立民主，还有一长串清单，比如禁止鸦片生产，但与此同时，我们的盟友就是鸦片生产者。是塔利班消灭了鸦片，美国人没做到。
(00:45:44):
所以我们有所有这些不同的目标。这行不通。你需要专注于可实现的目标。什么是可实现的？国家建设是很难的事情，需要一个世纪。阿富汗——我扯远了，但阿富汗是个很有趣的话题。阿富汗曾是一个军阀社会，一群不同的军阀统治着那里。什么是军阀社会？我们还能在哪里找到类比？我们可以看 1650 年的德国，看 1300 年的法国，看现代化之前的日本。这些都是军阀社会。那么，他们是如何从那里变成一个连贯的政府的？也许起初并不民主，但至少有了政府而不是连年的战争。这需要一些人去征服其余的人。
(00:47:02):
然后需要很长时间来建立政府结构，最后也许会变成民主国家。也许不会，但这就是过程。不是你进去说“因为我们颁布了法令，你们现在不再是军阀社会了”就能解决的。
(00:47:19):
我不知道。你可能会问我更多关于人们应该知道什么以及如何获得这些力量源泉的问题。如何获得这些洞察？我是历史的忠实粉丝。我非常喜欢了解发生过的事情。商业史、传记、战争史。
(00:47:42):
如果你无法接触到其他时代、其他地方和其他发生过的事情，你就很难对你所处的局势进行战略思考，因为战略并不是一门科学。它不像物理学，不像工程学，我们可以写下梁的受力方程，然后说梁需要多厚。它不是那样的。很大程度上，它是基于对以往人类经验的类比。

---

### [00:48:16] Lenny

**English:**
That is an amazing insight. Is there anything you find most rich and valuable in terms of history periods, empires, stories that you find most connects as an analogy? Is there anything you find consistently is useful or is it just read as much as you can and you'll often find something in there?

**中文翻译:**
这是一个了不起的见解。在历史时期、帝国、故事方面，你觉得哪些内容作为类比最丰富、最有价值？有没有什么你觉得始终有用的东西，还是说只要尽可能多读，总能从中发现点什么？

---

### [00:48:36] Richard Rumelt

**English:**
Yeah, the further back we go in history, the leaner. It's less rich. The best histories are written by the people at the moment it's happening or very soon after. History books and things like that are someone's opinion. But our own history here in the United States, we have pretty good documentation about what went on in the Indian War, why we had these big cycles of economic growth and then depression. We had depressions in 1840 and after the Civil War and there was another huge panic depression in the 1890s. [inaudible 00:49:26]. A lot of people don't even know that these things happen. How did they happen? And of course everybody knows about the Great Depression of 1929, 30's, but go back and how did that happen? When did that happen? And you'll hear professors opine about why it happened, but there's no agreement. The biggest economic fact of the last 150 years, you don't know why it happened.
(00:49:58):
Go back and you can go online and look at the Wall Street Journal of the New York Times from that era and start in September of 1928 and just look at the front page every day, which I've done, and you can see it unfold and it's a surprise to everyone. There goes, well, Ford just laid off the people, but it's temporary. They'll hire them back. This economist says, well, it's a temporary this. It'll come back. And it gradually gets worse and worse and worse and there's no understanding of it. There's not a lot of analysis. And so you got Milton Friedman saying, oh, it's monetary. They didn't loosen up the money supply. You got other people saying things. But put yourself back at that moment in time and see what people saw and realize that no one understood what was happening and to form their own opinions.
(00:51:10):
That's the diagnosis skill or that's the feeling. Now, let's suppose you fall off a boat. You're on a cruise ship and you fall and you're now in the ocean. It's terrifying and it's confusing and there's waves and there's water and I don't want to drown. And you look around and you see, oh, here's a floating piece of wood. Let me grab it. Wow, that feels a lot better. That's how it feels when you look at a confusing situation and the first idea of how to understand it comes to mind. Oh, yeah, I've got this piece of wood. Now I'm not drowning. But is it right?
(00:52:05):
The most important intellectual tool we have is to think again, to say, okay, I came up with this diagnosis because I thought this and I thought this. Is there another way to look at this situation? Is there a bigger piece of wood over there than I can grab onto? That's the hard thing. When I looked at the Great Depression what I saw is the [inaudible 00:52:35]. So if you look at capital goods, most capital goods that the public buys, the adoption curve goes up like this, it peaks, and it declines and then it comes back up again. Because there comes a point where everybody who can afford one has got one, and then the new sales drop off. And in my mind, that's what I saw. 1929, everybody could afford a car, had a car, and the auto industry began... First signs of the Great Depression were in the auto industry.
(00:53:15):
So that was my play that I read. Now I don't see anybody else writing about that, but that's the exercise and to exercise your mind about trying to understand complex situations. It's best to go back. You don't have to [inaudible 00:53:34] to the great Depression, but you can go and try and find situations that other people have to deal with and look at as much data as you can and to practice that. That's what education should be in a business school. It's not. They teach theories now because it's so much easier to teach a theory than intellectual structure.

**中文翻译:**
是的，历史越久远，内容就越贫乏，不够丰富。最好的历史是由当时的人或在那之后不久的人写的。历史书之类的往往是某人的观点。但在我们美国自己的历史中，关于印第安战争、关于为什么我们会有经济增长和萧条的大周期，都有很好的记录。我们在 1840 年、内战后都有过萧条，1890 年代还有过另一次巨大的恐慌性萧条。很多人甚至不知道这些事情发生过。它们是怎么发生的？当然，大家都知道 1929 年、30 年代的大萧条，但回过头看，它是怎么发生的？什么时候发生的？你会听到教授们对原因发表高见，但并没有共识。过去 150 年里最重大的经济事实，你竟然不知道它为什么发生。
(00:49:58):
你可以回到过去，在网上查看那个时代的《华尔街日报》或《纽约时报》，从 1928 年 9 月开始，每天看头版——我真的这么做过。你可以看到事情是如何展开的，这对每个人来说都是个意外。比如，“福特刚刚裁员了，但那是暂时的，他们会把人招回来的。”这位经济学家说，“这只是暂时的，会好起来的。”然后情况逐渐变得越来越糟，没人理解它，也没多少分析。于是你听到米尔顿·弗里德曼说，噢，是货币问题，他们没有放开货币供应。还有人说别的。但把你带回那个时间点，看看人们看到了什么，意识到当时没人明白发生了什么，然后形成你自己的观点。
(00:51:10):
这就是诊断技能，或者说那种感觉。现在，假设你从船上掉下去了。你在游轮上，掉进了大海。这很恐怖，很混乱，有海浪，有水，你不想淹死。你环顾四周，看到一块漂浮的木头。你抓住它。哇，感觉好多了。当你面对混乱的局面，脑子里出现第一个理解它的想法时，就是这种感觉。噢，是的，我有这块木头了，我现在没淹死。但它是对的吗？
(00:52:05):
我们拥有的最重要的智力工具是“再想一次”（think again），去说：“好吧，我得出这个诊断是因为我这么想、那么想。有没有另一种看待这个局势的方式？那边有没有一块更大的木头可以让我抓住？”这就是难点。当我研究大萧条时，我看到的是资本品。如果你看公众购买的大多数资本品，采用曲线是这样上升的，达到顶峰，然后下降，接着再回升。因为到了某个点，每个买得起的人都买了一个，然后新销量就会下降。在我看来，这就是我看到的。1929 年，每个买得起车的人都有了车，汽车行业开始……大萧条的最初迹象出现在汽车行业。
(00:53:15):
这就是我读到的剧本。现在我没看到别人写这个，但这就是一种练习，练习你的大脑去理解复杂局势。最好是回到过去。你不一定要回到大萧条，但你可以去寻找其他人必须处理的情况，查看尽可能多的数据并进行练习。这才是商学院教育应有的样子。但现在不是，他们教理论，因为教理论比教智力结构容易得多。

---

### [00:53:58] Lenny

**English:**
It's also a lot more work, reading a lot of books and history and studying and thinking.

**中文翻译:**
那也是更多的工作量，要读很多书、研究历史、学习和思考。

---

### [00:54:04] Richard Rumelt

**English:**
Oh, [inaudible 00:54:05]. I had a colleague at UCLA who assigned a book to MBA students and they went to the dean and had him kicked out of the course because of a book. He wants us to read a book.

**中文翻译:**
噢，是的。我在 UCLA 有个同事给 MBA 学生布置了一本书，结果学生们去找院长，把他从课程中踢了出去，就因为一本书。他们说：“他竟然想让我们读一本书。”

---

### [00:54:16] Lenny

**English:**
Oh man. It sounds like you have another book in you writing about the Great Depression and what really happened there.

**中文翻译:**
天哪。听起来你肚子里还有另一本书，关于大萧条以及那里到底发生了什么。

---

### [00:54:22] Richard Rumelt

**English:**
Maybe.

**中文翻译:**
也许吧。

---

### [00:54:23] Lenny

**English:**
Oh, man. Exciting.
(00:54:26):
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate your growth. Thousands of fast-growing companies like Gusto, Com, Quora and Modern Treasury, trust Vanta to help build, scale, manage, and demonstrate their security and compliance programs and get ready for audits in weeks, not months.
(00:54:45):
By offering the most in-demand security and privacy frameworks such as SOC 2, ISO 27,001, GDPR, HIPAA, and many more, vanta helps companies obtain the reports they need to accelerate growth, build efficient compliance processes, mitigate risks to their businesses, and build trust with external stakeholders. Over 5,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2 and these other frameworks. For a limited time Lenny's podcast listeners get $1,000 off Vanta. Go to vanta.com/lenny, that's V-A-N-T-A dot com slash lenny to learn more and to claim your discounts. Get started today.

**中文翻译:**
噢，伙计，真令人兴奋。
(00:54:26):
本集节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。数千家快速增长的公司，如 Gusto、Com、Quora 和 Modern Treasury，都信任 Vanta 来帮助构建、扩展、管理和展示其安全与合规计划，并在几周而非几个月内为审计做好准备。
(00:54:45):
通过提供最受追捧的安全和隐私框架，如 SOC 2、ISO 27001、GDPR、HIPAA 等，Vanta 帮助公司获得加速增长所需的报告，建立高效的合规流程，降低业务风险，并与外部利益相关者建立信任。超过 5000 家快速增长的公司使用 Vanta 自动完成 SOC 2 及其他框架高达 90% 的工作。在限定时间内，Lenny 播客的听众可以享受 Vanta 1000 美元的优惠。访问 vanta.com/lenny（V-A-N-T-A.com/lenny）了解更多信息并领取折扣。今天就开始吧。

---

### [00:55:24] Lenny

**English:**
I wanted to zoom back in on something very tactical. So say you're a product manager listening to this that has to write a strategy for their team. Say it's like they're working on the onboarding experience of their product and they're about to sit down and start to write out the strategy for their team. And say they have a general idea of what they want to do. Do you have any advice for just how to lay out a strategy? As you talk I think of there's a section. Diagnosis, a section. Guiding principles, a section. Actions, and then there's power in there and the guiding policy. Is that how you lay it out? Do you have any advice for how to write this out?

**中文翻译:**
我想回到一些非常战术性的问题上。假设你是一位正在听节目的产品经理，需要为团队制定战略。比如他们正在优化产品的入职体验（onboarding），正准备坐下来开始写战略。假设他们对自己想做的事情已经有了大致的想法。关于如何布局一份战略，你有什么建议吗？当你说话时，我想象中会有几个部分：诊断部分、指导原则部分、行动部分，其中还包含力量和指导方针。你是这样布局的吗？关于如何写出来，你有什么建议？

---

### [00:55:59] Richard Rumelt

**English:**
I wrote the crutch because I felt that.
(00:56:00):
The Crux because I felt that that kernel was not sufficiently sharp enough for peak. And even in The Crux, if I could rewrite The Crux book, I would, maybe, write it a little differently today, a whole couple of things I would change. First, it's really important to understand the challenge, the problem. Diagnosis is not merely understanding the world, it's understanding the challenge you face. What makes it hard? So the question I ask client is exactly that. What makes it hard? Client will tell me, "Oh, we want to open up business in Australia. It's a market we haven't tapped." And I'll say, "Okay, so why are you and I talking about that? You're the CEO. Just tell somebody to do it. What makes it hard?" "Oh, well, we don't know anybody in Australia and they kicked us out." If you push, he'll tell you why it's hard.
(00:57:18):
But that understanding hasn't been percolated into a strategy. Part of the problem is that the concept of strategy has been so beaten up by thousands, hundreds of books, and thousands of more websites that people have a hard time trying to figure out how to create a strategy, because they're drawn up, down, left, right. So my two pieces of advice, anybody that's actually trying to do this is, A, state the problem, and, B, don't call it a strategy, call it an action agenda, that you're not creating a strategy, you're creating an action agenda. What are we going to do about this problem? That's essence of what you're doing. When you're thinking strategically, you're recognizing the problem and you have an action agenda to deal with it. It's not five years out and 10 years out. It's not your general mission to build a better world, it's none of that.
(00:58:43):
All of that is a different literature form. There's huge numbers of people out there willing to sell you advice on how your mission, and your vision, and your values, and all these things that have to be in place before you can have a strategy. And that's not true. It's a different model. I start now with ambitions because people want to put ambitions in place. They get angry with me. I don't allow them to talk about their ambitions. So we start with ambitions, and okay, you have all these ambitions. I write in The Crux that when I was 25, I wanted to be a top business school professor. I wanted to be on Fortune directors. I wanted to drive a Morgan Drophead Plus 4. I wanted to climb the great mountains of the world. I wanted to learn to fly an aircraft. I wanted to marry a beautiful woman and have successful children. I wanted to have a townhouse on the [inaudible 01:00:00] of Paris. All and all, I had a lot of ambitions.
(01:00:05):
That's not strategy. We all have ambitions, and every company should have ambitions. If we look at all those ambitions, and let's say I'm 25 years old, well, what's keeping me from reaching them all? "Well, I'm not ready to join Fortune directors. I'm not experienced enough." Okay, so I put that over here. "I can't afford the pen." Okay, put it over here. "How about the ambitions that you have any chance of making progress?" So now, well, beautiful woman. "Yeah, I don't know any, maybe I ought to meet a few." "Well, you can do something about that."
(01:00:52):
So which of your ambitions can you begin to make progress towards reaching, and what's holding you back? What are the barriers? What are the problems? So I approach the question of the problem now through the filter of the ambition, that these ambitions, fine, let's accept them all, and which one can you actually make some progress on today? And what's making that hard? What are the challenges? So you're choosing a challenge. You're choosing, of the possible challenges you could face up to, you can't do them all. So there's a focus thing. You're choosing which challenge to focus on, and that challenge has to be, A, important, and, B, it has to be achievable.
(01:01:48):
It has to be something that you can address. It has to be an addressable challenge. And so the search for an action agenda, I'm not calling it a strategy, is this balance between problems that are important because they're close to your ambition and problems that you can actually address and do something about. And that overlap then becomes the choice you make. "Okay, we're going to go after this and here's the action steps we're going to take to do that." And if it's a big company, the action steps may extend over two or three years. Smaller company, took [inaudible 01:02:32] year, six months to a year. These are things we're going to do, not goals we're going to achieve. These are things we're going to do, action steps. That's sort of the way I put it together today, which is slightly different than the way it's put together in The Crux.

**中文翻译:**
我写了《关键点》（The Crux），因为我觉得那个“核心”对于巅峰状态来说还不够锋利。即使在《关键点》中，如果我今天重写，我可能会写得有点不同，有几处我会改动。首先，理解挑战、理解问题非常重要。诊断不仅仅是理解世界，而是理解你面临的挑战。是什么让它变得困难？所以我问客户的问题正是这个：是什么让它变得困难？客户会告诉我：“噢，我们想在澳大利亚开展业务，那是我们尚未开发的市场。”我会说：“好，那为什么你和我在这里谈论这个？你是 CEO，直接叫人去做就行了。是什么让它变得困难？”“噢，好吧，我们在澳大利亚不认识任何人，而且他们把我们赶了出来。”如果你逼问，他会告诉你为什么难。
(00:57:18):
但这种理解还没有渗透到战略中。部分问题在于，“战略”这个概念已经被成百上千本书和成千上万个网站搞烂了，人们很难弄清楚如何制定战略，因为他们被拉向上下左右各个方向。所以，对于任何真正尝试这样做的人，我有两条建议：第一，陈述问题；第二，不要把它叫做战略，叫它“行动议程”。你不是在制定战略，而是在制定行动议程。我们要针对这个问题做些什么？这就是你所做事情的本质。当你进行战略思考时，你是在识别问题，并制定一个行动议程来处理它。这不是五年后、十年的事，也不是你“建设更美好世界”的宏大愿景，都不是。
(00:58:43):
所有这些都是不同的文学形式。有大量的人愿意向你推销关于使命、愿景、价值观的建议，说在制定战略之前必须先有这些。这不是真的。那是另一种模式。我现在从“雄心”开始，因为人们想把雄心放进去。如果我不让他们谈雄心，他们会生我的气。所以我们从雄心开始，好，你有所有这些雄心。我在《关键点》中写道，当我 25 岁时，我想成为顶尖商学院教授，想进入《财富》董事会，想开一辆 Morgan Drophead Plus 4，想攀登世界名山，想学开飞机，想娶个美女并拥有成功的孩子，想在巴黎拥有一套联排别墅。总之，我有很多雄心。
(01:00:05):
那不是战略。我们都有雄心，每个公司都应该有雄心。如果我们看所有这些雄心，假设我 25 岁，是什么阻碍了我实现所有这些目标？“好吧，我还没准备好加入《财富》董事会，经验不足。”好，把这个放一边。“我买不起那辆车。”好，放一边。“那么，哪些雄心是你现在有可能取得进展的？”现在看，美女，“我不认识，也许我该去认识几个。”“好，你可以为此做点什么。”
(01:00:52):
所以，你的哪些雄心是可以开始取得进展的？是什么在阻碍你？障碍是什么？问题是什么？所以我现在通过“雄心”的过滤器来切入问题：这些雄心，好，我们全部接受，但哪一个是你今天真正能取得进展的？是什么让它变得困难？挑战是什么？所以你在选择一个挑战。在你可能面对的所有挑战中，你不能全部都做。所以这里有一个焦点问题。你在选择专注于哪个挑战，而那个挑战必须是：A，重要的；B，可实现的。
(01:01:48):
它必须是你能够应对的东西，必须是一个“可应对的挑战”。因此，寻找行动议程（我不叫它战略）就是在“因接近雄心而重要的问题”与“你真正能应对并采取行动的问题”之间寻找平衡。那个交集就是你做出的选择。“好，我们要攻克这个，以下是我们要采取的行动步骤。”如果是大公司，行动步骤可能延伸两三年；小公司可能是一年、六个月到一年。这些是我们要“做”的事情，而不是我们要“实现”的目标。这些是行动步骤。这就是我今天组合它的方式，与《关键点》中的方式略有不同。

---

### [01:02:49] Lenny

**English:**
Yeah, I love this advice. That's such a simpler way of thinking about strategy. It's an action agenda. "Here's the things we're actually going to do." And then it starts with the challenge. And just to talk about The Crux briefly, The Crux is named after this concept in mountain climbing of the hardest point of the mountain climb where people, if they get past that, it's all downhill. And I think basically the point there is focus on the most challenging, like the biggest challenge that you need to overcome to achieve these ambitions you're describing. Is that roughly the way to think about it?

**中文翻译:**
是的，我喜欢这个建议。这是一种更简单的思考战略的方式。它是一个行动议程，“这是我们实际要做的事情”。而且它始于挑战。简单谈谈《关键点》（The Crux），这个名字源于登山中的一个概念，指登山过程中最难的一点，如果人们能通过那一点，剩下的就顺理成章了。我认为核心点在于：专注于最具挑战性的、为了实现你所描述的雄心而必须克服的最大挑战。大概是这样理解吗？

---

### [01:03:21] Richard Rumelt

**English:**
Yeah, yeah, and the idea comes from a design, and it comes from climbing, because I used to be a climber, a rock climber, and a snow climber, and a crux in a climb is the hardest part, the hardest pitch or a pitch, the hardest move is the crux of that piece. And then the basic advice to a climber is if you can't do the crux, don't do the climb, because you're going to fall off there. Now that's not exactly true, because you can try it over and over again until you get it. But in general, particularly if you're looking at an alpine climb, you better not take it on a climb where you can't handle the crux. That's why people go bouldering. The [inaudible 01:04:06] still up to him [inaudible 01:04:08] crux.
(01:04:11):
And so that's what the concept of the crux comes from. Now in business, the crux is the hardest part of the problem. And from the design point of view, the skilled designers, whether they're an engineer or an architect, what else? There's usually a challenge. I. M. Pei was hired to take a look at the Louvre in Paris, and they had a dusty parking lot in the center of this giant palace that had become a museum, and they wanted an entrance to Louvre there. And the problem is he didn't want it, they didn't want a new building that would obscure the Louvre itself. The building itself is part of the story, it's part of the scene. And yet at the same time, they needed to have an entrance, because the entrance at that time was off on the side wall.
(01:05:24):
And you looked at the situation, and the competing needs, and the [inaudible 01:05:31]. And he had an insight into, "Well, build a transparent building, build a building out of glass, so that you see through to the Louvre, it doesn't obscure." And of course, if you can build a rectangular building out of glass, the top will get dirty. So [inaudible 01:05:55] out of glass. Now, that design insight is something that software engineers, hardware engineers, mechanical engineers, base science engineers like I was, experienced, when we look at a dilemma and we try to focus on what makes this hard. And then by focusing on the difficulty, we see a way around it. Elon Musk focused on, "Well, why is it so hard to reuse a rocket?" And it's so hard because as it comes back into the planet at 18,000 miles an hour, it burns up in the atmosphere, or we have to spend a lot of money on heat shields. And at some instant, he said to himself, "Well, why not, like science fiction, just turn it around and have it land on its rocket?" "Well, there's not enough fuel." "Well, why aren't we carrying more fuel?" So SpaceX, when I was designing, I was a conceptual designer, but machine that became Voyager and went out past the planets into interstellar space where it's floating around right now. Well, one of the problems is how do you know where Jupiter is? " It's right there." "Okay, but how do you know where it is, plus or minus 100 miles? How do you know exactly where it is? When we set a mission to Mars, we were off by 500 miles. So Jupiter, how do we know exactly where it is?" Because we can look at it through our telescopes so we can look at it from the right side of our orbit and the left side of our orbit. But still, there was a couple thousand miles error in that. That's too much. And then studying that problem, the simple solution suddenly flashed, and I wish I could claim it was mine, and it wasn't, which is, "Oh, take a picture of it once we're halfway there. We'll send that picture back and we'll see it against the distant stars. And now we'll have a triangulation, know where it is." So designers experience this sense of focusing on the crux of the problem, the hard part, and then seeing a way through. And that's strategy. Strategy isn't picking a strategy out of a list of common strategies. It's looking at the problem, what makes that problem hard, and seeing a way to solve it.
(01:08:54):
Now it's called insight, and insight is scary. It's scary because it's not guaranteed to happen. We want to innovate, but we're scared of insight. We want to be the first, but we'd like to pick our strategy out of a list of common strategies for being first. We want to beat the market, but we don't want to study enough to have an insight. So insight is critical. Insight is not magical. It comes from immersing yourself in the nature of the problem. And you will have, at some point, an insight about how to deal with it. It doesn't always come when we want it to. It can come while you're driving the car, it can come the next day. It can come in the shower. Charles Darwin reports that his insight into the nature of revolution came as he stepped off a carriage into the village green somewhere. Boom, suddenly, he said, "Oh, yeah, it's obvious." It's like how we raise animals, we breed the strongest. "Sure, why was that so hard for me to see?"

**中文翻译:**
是的，没错。这个想法源于设计，也源于攀登。因为我曾经是一名登山者，攀岩和雪山攀登都做过。在攀登中，“关键点”（crux）是最难的部分，最难的一段路（pitch）或一个动作就是那段路的关键点。对登山者的基本建议是：如果你做不了那个关键点，就不要去爬那座山，因为你会从那里摔下来。当然这不完全正确，因为你可以一遍又一遍地尝试直到成功。但总的来说，特别是阿尔卑斯式攀登，你最好不要去爬一座你处理不了关键点的山。这就是为什么人们去玩抱石。
(01:04:11):
这就是“关键点”概念的来源。在商业中，关键点是问题中最难的部分。从设计的角度来看，熟练的设计师——无论是工程师还是建筑师——通常都会面临一个挑战。贝聿铭（I. M. Pei）受邀改造巴黎卢浮宫，当时这座巨大的宫殿（已变成博物馆）中心有一个尘土飞扬的停车场，他们想在那里建一个入口。问题是他不想，他们也不想建一座会遮挡卢浮宫本身的建筑。建筑本身就是故事的一部分，是场景的一部分。但与此同时，他们需要一个入口，因为当时的入口在侧墙上。
(01:05:24):
你观察局势、竞争需求。他产生了一个洞察：“好吧，建一座透明的建筑，用玻璃建一座建筑，这样你就能看透它看到卢浮宫，它不会遮挡视线。”当然，如果你建一个矩形的玻璃建筑，顶部会变脏，所以他建了一个玻璃金字塔。这种设计洞察是软件工程师、硬件工程师、机械工程师、像我这样的基础科学工程师都会经历的——当我们面对困境时，我们试图专注于“是什么让这变得困难”。通过专注于难点，我们找到了绕过它的方法。埃隆·马斯克专注于“为什么回收火箭这么难？”难是因为当它以每小时 18,000 英里的速度返回地球时，它会在大气层中烧毁，或者我们必须在隔热罩上花很多钱。在某个瞬间，他对自己说：“为什么不学科幻小说那样，把它转过来，让它靠自己的火箭着陆呢？”“燃料不够。”“那为什么我们不带更多燃料呢？”再看 SpaceX，当我还在做概念设计时，那个后来成为“旅行者号”并飞出行星进入星际空间的机器。其中一个问题是：你怎么知道木星在哪里？“它就在那儿。”“好吧，但你怎么知道它的位置误差在正负 100 英里以内？你怎么确切知道它在哪？当我们执行火星任务时，我们偏离了 500 英里。那么木星，我们怎么确切知道它在哪？”因为我们可以通过望远镜看，可以从轨道的右侧和左侧看，但仍然有几千英里的误差。那太多了。在研究那个问题时，一个简单的解决方案突然闪现（我希望那是我发现的，但不是）：“噢，当我们走到一半时拍张照片。把照片传回来，我们会看到它衬托在遥远的恒星背景下。现在我们有了三角测量，就知道它在哪了。”所以设计师体验这种专注于问题的关键点（难点），然后找到出路的感觉。这就是战略。战略不是从一堆通用战略清单中挑选一个，而是观察问题，看是什么让问题变得困难，并找到解决它的方法。
(01:08:54):
这被称为“洞察”（insight），洞察是令人恐惧的。恐惧是因为它不保证一定会发生。我们想要创新，但我们害怕洞察。我们想做第一，但我们想从“如何做第一”的通用战略清单中挑选战略。我们想战胜市场，但我们不想深入研究到产生洞察的程度。所以洞察至关重要。洞察并非魔术，它源于让自己沉浸在问题的本质中。在某个时刻，你会产生如何处理它的洞察。它并不总是按我们的意愿出现。它可能在你开车时出现，可能在第二天出现，可能在洗澡时出现。查尔斯·达尔文报告说，他对进化本质的洞察是在他从马车上走下来，踏入某个村庄绿地时产生的。砰，突然间，他说：“噢，是的，这很明显。”就像我们养动物一样，我们培育最强壮的。“当然，为什么我以前觉得这很难看出来呢？”

---

### [01:10:14] Lenny

**English:**
So I think one of the big takeaways here is that if you want to get better at strategy or be more successful with how you think about strategy, spend a lot more time on diagnosing the problem and finding the biggest challenge that is keeping you from what you're trying to achieve. And your insight might come the more you immerse [inaudible 01:10:30].

**中文翻译:**
所以我认为这里的一个重要收获是：如果你想变得更擅长战略，或者在战略思考上更成功，那就花更多时间诊断问题，找出阻碍你实现目标的那个最大挑战。你越沉浸其中，洞察力就越可能出现。

---

### [01:10:30] Richard Rumelt

**English:**
Yeah, and call it an action agenda, "Here's what we're going to do." Not, "Here's all the things we wish would happen."

**中文翻译:**
是的，并称之为行动议程，“这是我们要做的”，而不是“这是我们希望发生的所有事情”。

---

### [01:10:39] Lenny

**English:**
I love it. You mentioned this point that some of the biggest challenges to executing a strategy is organizational dynamics, and politics is a part of that. Is there anything you could share for folks to help them through that? You talked about one of the biggest challenges, people just want to keep adding more priorities. There's all these needs. Everyone wants to include their thing in the strategy. Is there anything people can do to improve how this works?

**中文翻译:**
太棒了。你提到过，执行战略的最大挑战之一是组织动态，而政治是其中的一部分。关于如何帮助人们度过难关，你有什么可以分享的吗？你谈到了最大的挑战之一是人们只想不断增加更多的优先事项。有各种各样的需求，每个人都想把自己的东西塞进战略里。人们能做些什么来改善这种运作方式吗？

---

### [01:11:04] Richard Rumelt

**English:**
Typically, I'll say typically, we need hierarchy of power, because there has to be some mechanism for deciding what we're going to do. And there's people with different interests and different private interests and public interests. And somehow, there has to be a choice about putting some of these aside and doing this, that you can't say, "Our strategy is to do everything that everybody wants to do." That's what happens when you form a committee in a city and you say, "What's our city strategy?" They say, "Oh, we're going to paint the park benches. We're going to clean up the grass, we're going to build a new this, we're going to..."
(01:11:49):
They have a [inaudible 01:11:49] that stuff, everything they're going to do with that. And anybody who raised their hand and says, "Well, what about the birds? Can we..." "Oh, yeah, let's put that in, too," that doesn't go anywhere. So we, inside organizations, people have different opinions. So that's part, they have interests that they may not state clearly.
(01:12:24):
I interviewed Secretary of Defense, Donald Rumsfeld, while we were invading Iraq, second time, and I was actually interviewing about budget matters, but he asked me, "Well, what do you do, professor?" And I said, "Well, I do strategy." And he said, "Well, strategy, that's a hard subject." He said, "I've got people here in the Defense Department who have an expert on anything. You want to know the clan structure in Iraq, we've got people who know. We want to know the weather, we've got people to know. You want to know how many [inaudible 01:13:05] we can fly in 24 hours, people who know. I got anything you want to know, we've got someone who knows about it, but they all disagree. And each have their own private agenda. They have a contract they want to get, they have a company they want to support, they have a conceptual idea they want to push."
(01:13:25):
So every little bit of information comes with an agenda, sometimes obvious, sometimes hidden. And how do you put all this stuff together to come up with a strategy? He says, "Do you academics have a solution to this?" And I said, "No, we don't. We don't know much more than, what, 2,000, 3,000 years ago, which is you put five to eight smart people in a room and you tell them to come up with something." But his question is at the heart of what I call a foundry, which is how do you get a group of people to coalesce around an action agenda?
(01:14:11):
And what process would you use and how do you do that? It's a different question than, "What should our strategy be?" The question is, "Well, how should you go about creating a strategy? Should you ask the product manager to write an account, or should you ask the CEO to come up with it? Should you hire a consultant? How do you do this?" In my experience, working with companies, is that the senior executives have to do this. And my experience is that the senior executives know pretty much everything you need to know to do this, that you don't need consulting firms to come in and analyze everything that you do. Yes, you'll gain some insight if they come in and do a competitive analysis, and a customer analysis, and all of that. But the basic issues, the challenges you're facing, they know that. It's not mysterious. They know all that stuff, but they disagree about the importance of different things. And more importantly, they occupy positions of power that, if we go this way, this is going to be hurt. And if we go this way, they're [inaudible 01:15:34] more money for that.
(01:15:36):
And so their interests are not aligned, which is part of what Phil was referring to. And so the problem of strategy inside an organization is diversity of interest and fear of action. Because action, when you do something in an organization of any size, it involves people changing what they do. It involves changing power relationships among humans in some way, that someone who's been the alpha maybe is not the alpha anymore, someone else is the alpha. This is heavy stuff. And this is why we have a hierarchy, because someone in the end has to say, "It's going to be this way." And people are hesitant to do that, CEOs are hesitant to do that. More so today than when I was a young man. It's become hard for people to do this. If you go to the bookstore and look at the management section in bookstore, most of it's about leadership.
(01:16:56):
And the leadership is mostly about perfecting yourself. It's not about beating anybody, but the theory is that if you perfect yourself and somehow rays come out of your head and people will follow you, because you're so magnetic, and you're so perfect, and you're so wonderful, and you're so insightful, and that people will follow you, you won't ever have to say, "[inaudible 01:17:19], do that." It's so embarrassing to tell somebody what to do.
(01:17:24):
And so this is the world we live in today, where one of the problems in doing strategy is that it's somehow been displaced by this literary form about mission, and management is being displaced by leadership, which is the idea that the leader has a vision and people... It happened in the '80s. There's a whole literature there about transformational leadership that is percolated through the system, and those, I'm not against leadership, but you have to tell people at some point, "We're going to do this, and we're going to do it this way, and Bob's going to be in charge of this aspect, and Joan's going to be in charge of that aspect." And there's a hesitancy to make those choices, because that's part of the action agenda.

**中文翻译:**
通常情况下，我会说通常情况下，我们需要权力等级制度（hierarchy of power），因为必须有某种机制来决定我们要做什么。人们有不同的利益，有私人利益，也有公共利益。在某种程度上，必须做出选择：放下其中的一些，去做这一件。你不能说：“我们的战略是做每个人想做的每一件事。”这就是你在城市里成立一个委员会并问“我们的城市战略是什么”时会发生的情况。他们会说：“噢，我们要粉刷公园长椅，我们要清理草坪，我们要建个新设施，我们要……”
(01:11:49):
他们有一大堆要做的琐事。任何举手说“那鸟类怎么办？我们能不能……”的人，得到的回答都是“噢，好，把那个也加进去”。这哪儿也去不了。所以在组织内部，人们有不同的意见。这是部分原因，他们有利益，但可能不会明确表达。
(01:12:24):
在第二次入侵伊拉克期间，我采访了国防部长唐纳德·拉姆斯菲尔德。我当时实际上是在采访预算问题，但他问我：“教授，你是做什么的？”我说：“我研究战略。”他说：“战略，那是个很难的课题。”他说：“我在国防部这里有各种各样的专家。你想知道伊拉克的部落结构，我们有懂的人；想知道天气，我们有懂的人；想知道我们 24 小时内能飞多少架次，也有懂的人。你想知道的任何事情，我都有专家，但他们全都意见不一。而且每个人都有自己的私人议程：他们有想拿到的合同，有想支持的公司，有想推销的概念性想法。”
(01:13:25):
所以每一条信息都带着议程，有时明显，有时隐蔽。你如何把所有这些东西整合在一起形成战略？他问：“你们学术界有解决方案吗？”我说：“没有。我们知道的并不比两三千年前多多少，那就是把五到八个聪明人关在一个房间里，让他们想出点办法。”但他的问题正是我所说的“铸造厂”（foundry）的核心，即：你如何让一群人围绕一个行动议程达成共识？
(01:14:11):
你会使用什么流程？你如何做到这一点？这与“我们的战略应该是什么”是不同的问题。问题是：“你应该如何去制定战略？你应该让产品经理写一份报告，还是让 CEO 想出来？你应该雇佣顾问吗？你如何操作？”根据我与公司合作的经验，高级管理人员必须亲自参与。而且我的经验是，高级管理人员几乎知道做这件事所需的一切，你不需要咨询公司进来分析你所做的一切。是的，如果他们进来做竞争分析、客户分析等，你会获得一些洞察。但基本问题、你面临的挑战，他们是知道的。这并不神秘。他们知道所有这些，但他们对不同事情的重要性存在分歧。更重要的是，他们占据着权力的位置——如果我们走这条路，这个部门会受损；如果我们走那条路，那个部门会拿到更多钱。
(01:15:36):
所以他们的利益是不一致的，这正是拉姆斯菲尔德所指的。因此，组织内部战略的问题在于利益的多样性和对行动的恐惧。因为行动——当你在任何规模的组织中采取行动时——都涉及人们改变他们的工作方式。它涉及以某种方式改变人与人之间的权力关系：曾经是“老大”的人可能不再是老大了，别人成了老大。这是很沉重的事情。这就是为什么我们需要等级制度，因为最终必须有人说：“就这样定了。”但人们犹豫不决，CEO 们也犹豫不决。现在比我年轻时更甚。这对人们来说变得很难。如果你去书店看管理类书籍，大部分都是关于“领导力”的。
(01:16:56):
而领导力大多是关于“完善自我”。它不是关于击败任何人，其理论是：如果你完善了自我，某种光芒就会从你头上散发出来，人们就会追随你，因为你如此有魅力、如此完美、如此出色、如此有洞察力，人们会追随你，你永远不需要说：“鲍勃，去做那个。”告诉别人该做什么似乎变得很尴尬。
(01:17:24):
这就是我们今天生活的世界，制定战略的一个问题是，它在某种程度上被这种关于“使命”的文学形式所取代了，而“管理”正被“领导力”所取代——即领导者拥有愿景，然后人们……这发生在 80 年代。有一整套关于“变革型领导力”的文献渗透到了系统中。我不反对领导力，但你必须在某个时刻告诉人们：“我们要这么做，我们要以这种方式做，鲍勃负责这方面，琼负责那方面。”人们对做出这些选择感到犹豫，因为那是行动议程的一部分。

---

### [01:18:23] Lenny

**English:**
So the takeaway there is essentially have a decider. It makes me think of, actually, of George Bush. You talked about Rumsfeld, but George Bush's famous quote, " I'm the decider." I don't know if you remember that?

**中文翻译:**
所以这里的收获基本上是：必须有一个决策者。这让我想起了乔治·布什。你谈到了拉姆斯菲尔德，但乔治·布什有一句名言：“我是决策者（I'm the decider）。”不知道你还记不记得？

---

### [01:18:33] Richard Rumelt

**English:**
Yeah, that's true. One of the things we see in government particularly is presidents have a hard time getting advice, because they surround themselves with people who want to please them. Number one, we rarely.,, It used to be, I remember during Woodrow Wilson's administration, when he decided to take some hard action, the [inaudible 01:18:58], and he had to do something, [inaudible 01:19:00], and the Secretary of State disagreed and quit. "Right, that's it. Quit. I disagree." Wow, don't see that so much anymore. All the people, organizations get frozen because of the difficulty of changing positions of interest and power in [inaudible 01:19:29].

**中文翻译:**
是的，没错。我们在政府中特别看到的一点是，总统很难获得真实的建议，因为他们周围都是想讨好他们的人。首先，我们很少……我记得在伍德罗·威尔逊政府时期，当他决定采取一些强硬行动时，国务卿不同意并辞职了。“好，就这样，辞职，我不同意。”哇，现在不怎么能见到了。所有的人、所有的组织都因为难以改变利益和权力地位而陷入僵局。

---

### [01:19:30] Lenny

**English:**
Humans are complicated.

**中文翻译:**
人类很复杂。

---

### [01:19:34] Richard Rumelt

**English:**
Well, if you look at Nokia, one of the big examples of strategic errors, Nokia was the leading phone maker in the world world, and then somehow it lost its ability to compete. And interesting question, there's been a fair amount of research on this, is how did that happen? One way it happened was they replaced the engineers who used to run the company with lawyers and accountants. Nothing wrong with lawyers and accountants, but they didn't have a feel for this hardware, software set of issues. And another was they put in a matrix organization that so diffused power inside the organization that nobody was actually in charge of anything in particular. I'm exaggerating, but the CEO kept pounding the desk and saying, "Apple's coming out with a smartphone and you have a touchscreen, and somebody here should make one of those." So there was no one in authority to do such a thing.

**中文翻译:**
如果你看诺基亚，这是战略错误的重大案例之一。诺基亚曾是全球领先的手机制造商，但不知何故失去了竞争能力。一个有趣的问题（对此已有相当多的研究）是：那是怎么发生的？原因之一是他们用律师和会计师取代了曾经管理公司的工程师。律师和会计师没问题，但他们对硬件、软件这一系列问题没有感觉。另一个原因是他们实行了矩阵式组织，这极大地分散了组织内部的权力，以至于实际上没有人具体负责任何事情。我可能说得有点夸张，但 CEO 当时不断拍着桌子说：“苹果要出智能手机了，有触摸屏，我们这里得有人做一个出来。”结果却没有一个有权威的人去执行这件事。

---

### [01:20:40] Lenny

**English:**
Maybe a final question on the other end of the spectrum, from an Nokia, from a startup founder's perspective, what is a strategy and what should a strategy look like if you're just a founder, pre-product market fit, just trying to figure out where you want to go? What should a strategy look like there? Do you even need a strategy?

**中文翻译:**
也许最后一个问题是关于光谱的另一端，从初创公司创始人的角度来看。如果你只是一个创始人，处于产品市场匹配（PMF）之前，正试图弄清楚该往哪走，战略是什么？那里的战略应该是什么样子的？你甚至需要战略吗？

---

### [01:20:57] Richard Rumelt

**English:**
Well, you're dealing with a lot of uncertainty When you're a founder in a startup, you're making a bet. You're making a bet like an oil well [inaudible 01:21:09] say, "I bet there's oil under this ground. We're going to drill, we're going to find it." There's a certain amount of bet that's going on, and you should be clear about the nature of the bet. The reality is going to be revealed to you in bits and pieces as time passes, whether a certain approach is going to work or not. What we find doing research on startups, Silicon Valley startups, is they start out typically aiming at a particular product market solution. And the idea that you have in your head is, "There's a set of customers who want A, would like to have A, are being denied A, but we have a way of giving them A," something, a product or a service.
(01:22:02):
Now, some people, they aren't that even advanced. They basically say, "I know how to make something and I'm going to try to sell it." You know, [inaudible 01:22:10] approach. Well, if you have any chance of succeeding, you have [inaudible 01:22:17], you have target market, and you have a solution to the target market's problem in mind, and now you're going to go after it. And the research that we have done on the startups is that generally it doesn't work.
(01:22:33):
But the ones that survive and prosper switch. They say, "Well, it isn't that customer, it's a different customer. You should walk from that customer. Oh, and that customer wants a slightly different product," and they switch over a period of a year or two period, bang, bang, until something begins to click, and they begin to grow, and begin to add functions and assets. So there's a search, there's a search like a truffle hound searching for the truffle that's going on.
(01:23:05):
And you've got to be able to think, you've got to be of two minds. Like so many things in business, when you're doing this, you've got to be of two minds. You've got to be convinced of the certainty that you're going to win, and you've got to be willing to shift when things aren't working, and that's a double-jointed exercise that some people can do and some people can't. It's almost a human skill to both commit and to be willing to move. But it's a bet. You should be clear in your own mind about the nature of the situation, the technology that you're betting on. Now, sometimes it's evolving so fast, like generative AI is right now, that you can't be sure.

**中文翻译:**
当你是一个初创公司的创始人时，你正在处理大量的不确定性，你是在下注。就像钻油井一样，你说：“我赌这地下有油，我们要钻探，我们要找到它。”这其中包含一定程度的赌博成分，你应该清楚赌注的性质。随着时间的推移，现实会一点一点地向你揭示某种方法是否奏效。我们对硅谷初创公司的研究发现，他们通常从瞄准特定的产品市场解决方案开始。你脑子里的想法是：“有一群客户想要 A，喜欢 A，但现在得不到 A，而我们有办法给他们 A”——某种产品或服务。
(01:22:02):
现在，有些人甚至还没到那个阶段。他们基本上是说：“我知道怎么做一个东西，我打算试着把它卖出去。”好吧，如果你有任何成功的机会，你心中必须有目标市场，以及针对该市场问题的解决方案，然后你去追求它。我们对初创公司的研究表明，通常这行不通。
(01:22:33):
但那些生存下来并繁荣发展的公司会“切换”（switch）。他们说：“好吧，不是那个客户，是另一个客户。你应该离开那个客户。噢，那个客户想要稍微不同的产品。”他们在一两年的时间里不断切换，砰、砰，直到某些东西开始奏效，他们开始增长，开始增加功能和资产。所以这是一种寻找，就像松露犬寻找松露一样的寻找过程。
(01:23:05):
你必须能够思考，必须具备“双重思想”。就像商业中的很多事情一样，当你做这件事时，你必须具备双重思想：你必须坚信自己一定会赢，同时当事情进展不顺时，你必须愿意转变。这是一种“双关节”式的练习，有些人能做到，有些人做不到。这几乎是一种人类技能：既能全身心投入，又愿意随时移动。但这就是一场赌博。你应该在自己心中清楚局势的性质、你所押注的技术。现在，有时技术进化得太快了，就像现在的生成式 AI，你无法确定。

---

### [01:24:04] Richard Rumelt

**English:**
... That you're going to take a position, where do you think things are going to be in a year? And that's very, very entrepreneurial, very edgy stuff, but it's not... Go back and read about the beginnings of the electrical industry or the beginnings of aviation or the beginnings of motorize this and beginnings of cars. People had to bet about what this industry would look like. The first cars were electric cars. The first car sold in quantity in the United States were electric delivery vehicles used downtown in cities, delivery [inaudible 01:24:49] produce. They were electric, ran on batteries. That was the bet.
(01:24:53):
All that changed with the First World War. The United States built thousands and thousands of gasoline powered trucks to go to Europe, wrestled through the mud, and people came back knowing how to fix those engines, and those trucks got sold off as wholesale to farmers, who used them on their fields, and we had the gasoline to take off like a rocket. So, you cannot predict the future. There's an Arab saying that I like that says, "He who forecasts the future lies, even if he tells the truth." We're making bets. That's what business is, we're making a bet. And if we're a rich company, we can make a bet and afford to be wrong. But if we're a startup, we have to be fast, we have to adapt as the information comes in, and that's the nature of the story. The action agenda has to be quick adaptation to changing conditions.

**中文翻译:**
……你要占据一个位置，你认为一年后情况会怎样？这是非常具有创业精神、非常前卫的东西。但这不是……回过头去读读电力行业的起源，或者航空业的起源，或者汽车行业的起源。人们必须赌这个行业未来会是什么样子。最早的汽车是电动车。在美国大批量销售的第一批汽车是用于城市中心的电动送货车，运送农产品。它们是电动的，靠电池运行。那是当时的赌注。
(01:24:53):
这一切随着第一次世界大战而改变。美国制造了成千上万辆汽油动力卡车运往欧洲，在泥泞中穿行。人们回来后学会了如何修理那些发动机，那些卡车被批发卖给了农民，农民在田间使用它们，于是汽油动力像火箭一样腾飞了。所以，你无法预测未来。我喜欢一句阿拉伯谚语：“预言未来的人在撒谎，即使他说的是真话。”我们是在下注。商业就是这样，我们在下注。如果我们是一家富有的公司，我们可以下注并承担错误的代价。但如果我们是一家初创公司，我们必须快，必须随着信息的进入而调整，这就是故事的本质。行动议程必须是对不断变化的条件的快速适应。

---

### [01:26:06] Lenny

**English:**
I feel like you have another book here where you could adapt a lot of this wisdom to startups. I'm looking at my notes from what we were talking about earlier, and you have this point of when you're trying to write out a... You call it an action agenda, not a strategy, you're basically on the hunt for a big problem and an important problem and an achievable problem. And essentially you can boil that down to that is the job of a founder to find an important problem and achievable problem and then solve it for a lot of people.

**中文翻译:**
我觉得你这里又有一本书的素材，可以把这些智慧应用到初创公司。我看着我们之前谈话的笔记，你提到当你尝试写出一份……你称之为行动议程而不是战略时，你基本上是在寻找一个大问题、一个重要问题和一个可解决的问题。本质上，你可以将其归结为：创始人的工作就是找到一个重要且可解决的问题，然后为很多人解决它。

---

### [01:26:34] Richard Rumelt

**English:**
I like that. The other exercise I used to take my students through was what I called value denial. Now, what is it that you should be able to buy but you can't? And at the time I taught this stuff, I was upset because I would lose my baggage on a nonstop flight from Los Angeles to Paris, so I'd like to buy baggage... Sure, so I'd like to buy... How do you get your baggage not to be lost? Now, with security systems in place, it's less, let's call it. Can I find someone to help me remodel my home that's going to be on time and I'll bet you not available. Can't buy it at any price. If I live in Hong Kong and I'm going to the airport, I can drop my luggage off downtown and it arrives at the airport checked in. I don't have to lug it. Why can't I do that in the US? Value denial.
(01:27:44):
And then engineering, thinking about how something ought to be, a channel, salesforce.com got started was, "Well, how should this be? It shouldn't be a computer, it should be a webpage. It should be like Amazon where it has books." And so, that was the beginning of salesforce.com. I asked a group of students once to think about the perfect window because it's physical, something we could think about in the classroom without doing a lot of research. Well, what's the perfect window? A perfect window should be transparent, should let the sun in. All right, so it's let in the light, but not all the time. Sometimes you want to watch the television. So, it should also darken, drapes for shades. It should let in the air, good, but not the bugs, a screen. It should let in the air, but not the noise. That's a little harder.
(01:28:57):
So, you go down a list of things that a window should do. It should let in light, but not light. It should let in air, but not the noise. It should not let in air when we don't want it. It should not let in the bugs. It should maybe have shutters or not shutters. And so I said, "How could you design the perfect window? What would it look like?" And there's some kids at MIT that had developed this thing that lets in air, but keeps out the noise, these little auditory filters keep out noises in certain frequencies. Well, we don't have a perfect window, but think about it, windows could be better than they are.
(01:29:39):
And that's a real simple device that we're all familiar with, and look around you, look at everything you've got and say, well, "How shouldn't it be?" And there's opportunities there. Now, a lot of the times, the opportunities are blocked by the lack of certain materials or regulation. Regulators have decided that you can't sell a car in the United States unless it goes through a dealer. So, that holds back innovation in that business. And so plumbing, how should plumbing actually work?
(01:30:20):
Well, there's a whole surge of rules about how plumbing works and electrical things work. You can't innovate there very easily because of the underwriter's labs and the unions, and a lot of the stuff that's done in home construction is there to create jobs, not to reduce costs. So, how do you get around that? So, you have to look at places where it's possible to innovate first of all, but the idea of how do you make something better? How do you make it perfect? What would the perfect light switch look like, and so on? These are real simple, silly questions, but they lead to new businesses and new firms if you pursue them.

**中文翻译:**
我喜欢这个说法。我以前常带学生做的另一个练习叫“价值缺失”（value denial）。现在，有什么东西是你本该能买到但却买不到的？当时我教这些内容时，我很生气，因为我从洛杉矶飞往巴黎的直达航班竟然丢了行李。所以我希望能买到行李……当然，我希望能买到……你怎么能让行李不丢呢？现在有了安保系统，这种情况少了一些。我能找个人帮我装修房子并准时完工吗？我敢打赌你找不到。花多少钱都买不到这种服务。如果我住在香港去机场，我可以在市区托运行李，行李到达机场时已经办好手续了，我不需要自己拎着。为什么在美国做不到？这就是价值缺失。
(01:27:44):
然后是工程思维，思考事物“应该”是什么样子的。Salesforce.com 的起步就是：“好吧，这应该是什么样的？它不应该是一个电脑软件，它应该是一个网页。它应该像亚马逊卖书那样。”这就是 Salesforce 的开始。我曾让一群学生思考“完美的窗户”，因为它是实物，我们可以在教室里思考而不需要做大量研究。完美的窗户是什么样的？它应该是透明的，能让阳光进来。好，它能透光，但不能一直透光，有时你想看电视，所以它应该能变暗，有窗帘或遮光帘。它应该能通风，这很好，但不能进虫子，所以要有纱窗。它应该能通风，但不能进噪音。这有点难。
(01:28:57):
所以，你列出一张窗户应该具备的功能清单。它应该透光，但有时不透光；应该通风，但不进噪音；当我们不想通风时，它不应该漏风；不应该进虫子；也许应该有百叶窗。于是我说：“你如何设计完美的窗户？它长什么样？”麻省理工学院（MIT）有些孩子开发了一种东西，可以通风但隔绝噪音，这些小的声学过滤器可以隔绝特定频率的噪音。好吧，我们还没有完美的窗户，但想想看，窗户可以比现在做得更好。
(01:29:39):
这是一个我们都熟悉的简单设备。看看你周围，看看你拥有的每样东西，然后问：“它不应该是什么样子的？”那里就有机会。现在，很多时候机会被某些材料的缺乏或监管所阻碍。监管机构规定，在美国除非通过经销商，否则不能卖车。这阻碍了该行业的创新。还有管道，管道到底应该如何运作？
(01:30:20):
关于管道和电气如何运作有一大堆规则。你很难在那里创新，因为有实验室认证、工会，而且房屋建筑中的很多东西是为了创造就业机会，而不是为了降低成本。那么，你如何绕过这些？所以，你首先要寻找可能创新的地方。但核心思想是：你如何让某样东西变得更好？如何让它变得完美？完美的电灯开关长什么样？等等。这些都是非常简单、甚至有点傻的问题，但如果你追求它们，它们会催生新的业务和新的公司。

---

### [01:31:03] Lenny

**English:**
I love how full of startup ideas you are. I also think we came up with at least two new books that you can write. I think you're going to have a lot of work to do after this conversation. Final question, is there anything you want to leave listeners with or take away? Is there a final nugget you just want to share for folks?

**中文翻译:**
我太喜欢你满脑子创业点子的样子了。我还觉得我们至少想出了两本你可以写的新书。我想这次谈话后你会有很多工作要做。最后一个问题，你有什么想留给听众的建议或感悟吗？有没有最后的“金句”想分享给大家？

---

### [01:31:19] Richard Rumelt

**English:**
I want to share with you that strategy's not mysterious, that I've spent my life studying strategy, pursuing it, consulting on it, writing about it. It's not mysterious. It's about solving problems. It's about solving the most important problem you're facing that you actually do something about. You don't have to be Sun Tzu to come up with a strategy, but you need to be focused on something doable and be consistent about it. I have a long list of things not to do. There's a fourth book that I'm thinking about writing called Don't Do That.

**中文翻译:**
我想和大家分享的是，战略并不神秘。我花了一辈子研究战略、追求战略、提供战略咨询、撰写战略。它不神秘。它是关于解决问题的。它是关于解决你面临的、且你实际上能采取行动的最重要的问题。你不需要成为孙子（Sun Tzu）也能想出战略，但你需要专注于可执行的事情，并保持一致性。我有一长串“不要做的事”清单。我正在考虑写第四本书，名字就叫《别那样做》（Don't Do That）。

---

### [01:31:59] Lenny

**English:**
I would read that. I love that title.

**中文翻译:**
我会读那本书的。我喜欢这个书名。

---

### [01:32:02] Richard Rumelt

**English:**
Can I tell you a story?

**中文翻译:**
我能给你讲个故事吗？

---

### [01:32:05] Richard Rumelt

**English:**
My wife Kate took up skiing when we got married 24, 25 years ago, and she had this stance that she couldn't get rid of. When you make a turn, you don't turn like that, you put the ski out the step. I made her ski on one ski, I did all sorts of things to her back, she couldn't fix it. And finally we signed up with an illustrious ski teacher in Aspen, a three-day intense program, guaranteed that she would lose her stance, exceeded them all.
(01:32:45):
And so we went there... On the second day, I followed behind the instructor and her to see what was going on, and they had been through some exercises on day one, but in day two they were focusing on this and she would put out her ski like that and he'd yell at her. He'd say, "Don't do that," and after a day of being yelled at, "Don't do that," she didn't do it anymore, she was fixed. So, the secret technique that they had in this program for curing your stance was to yell at you telling you, "Don't do that." And so I'm thinking about a book called Don't Do That about business things where I'm not sure it makes sense, but you have to noodle these things for a while before they begin to gel.

**中文翻译:**
我妻子 Kate 在我们 24、25 年前结婚时开始学滑雪，她有一种改不掉的姿势。当你转弯时，你不应该那样转，你应该把滑雪板向外跨一步。我让她单脚滑雪，对她的背部做了各种调整，她就是改不了。最后，我们在阿斯彭（Aspen）报名参加了一位著名滑雪教练的三天强化课程，保证她能改掉那个姿势，超过了所有人的预期。
(01:32:45):
我们去了那里……第二天，我跟在教练和她后面看发生了什么。第一天他们做了一些练习，但第二天他们专注于这个动作，每当她那样伸出滑雪板时，教练就会对她大喊。他会喊：“别那样做！”在被吼了一整天“别那样做”之后，她再也不那样做了，她改过来了。所以，这个课程纠正姿势的秘密技术就是对着你大喊“别那样做”。所以我正在考虑写一本关于商业事务的书，名字就叫《别那样做》。我不确定这是否有意义，但在这些想法成型之前，你必须琢磨一段时间。

---

### [01:33:34] Lenny

**English:**
I love this idea. It reminds me, one of my friends is a therapist, and there's this video by Bob Newhart where he's a therapist and someone comes to him and they've got all these problems like, "I get really sad when I think about my mom and I have this chronic pain," and his advice, "Just stop it, just stop."

**中文翻译:**
我喜欢这个主意。这让我想起我的一位治疗师朋友。鲍勃·纽哈特（Bob Newhart）有个视频，他演一个治疗师，有人去找他，诉说各种问题，比如“我一想到我妈就很伤心，我还有慢性疼痛”，而他的建议是：“停下来，直接停下来。”

---

### [01:33:50] Richard Rumelt

**English:**
Don't do that, just stop thinking about your mom.

**中文翻译:**
别那样做，别再想你妈了。

---

### [01:33:50] Lenny

**English:**
"Just stop it," that's the advice. And so, I feel like there's a lot of synergy there. All right, well, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
“直接停下来”，这就是建议。所以，我觉得这很有异曲同工之妙。好了，既然如此，我们进入了非常令人兴奋的闪电问答环节。准备好了吗？

---

### [01:34:04] Richard Rumelt

**English:**
I guess so.

**中文翻译:**
我想是的。

---

### [01:34:07] Lenny

**English:**
First question, what are two or three books you've recommended most to other people? I feel like this is going to be a challenging question, but what comes to mind?

**中文翻译:**
第一个问题，你向别人推荐最多的两三本书是什么？我觉得这会是个挑战，但你脑子里首先想到的是什么？

---

### [01:34:07] Richard Rumelt

**English:**
It sort of is. The books that I'm... Clayton Christensen's stuff about The Innovator's Dilemma is always solid. Books on strategy that I recommend to other people on... There aren't that many. So, I like Playing to Win by Roger Martin. I really recommend other kinds of books, strategy books. It's easy to get a list of strategy books, but I think you should read biographies and histories. I think the book about Steve Jobs is brilliant. I like books about business leaders. I'd recommend Andy Grove's book Only the Paranoid Survive, and a few others, but I recommend that people read more broadly about people, Rockefeller's histories, it's fantastic.
(01:35:22):
The stuff about Rockefeller and how he put together... Rockefeller was a robber baron and he built an empire and all that, you learn that in school, but what you don't learn in school is he dropped the cost of a gallon of kerosene from $1 to 10 cents. That's the robber baron, and he made kerosene so inexpensive that he drove all the little mom and pop proprietors out of business, which is why they hated him. So, he was a vicious competitor, but he dropped the price of something by an order of magnitude, fascinating. So, it's important to understand stories, not just theories, but stories.

**中文翻译:**
确实有点难。我推荐的书……克莱顿·克里斯坦森（Clayton Christensen）关于《创新者的窘境》的内容总是很扎实。我推荐给别人的战略书……其实没那么多。我喜欢罗杰·马丁（Roger Martin）的《赢在战略》（Playing to Win）。我其实更推荐其他类型的书，而不是纯战略书。列出一张战略书单很容易，但我认为你应该读传记和历史。我觉得关于史蒂夫·乔布斯的那本书很精彩。我喜欢关于商业领袖的书。我会推荐安迪·格鲁夫（Andy Grove）的《只有偏执狂才能生存》，还有其他几本。但我建议人们更广泛地阅读关于人的书，洛克菲勒的历史就非常棒。
(01:35:22):
关于洛克菲勒以及他如何整合……洛克菲勒是一个“强盗大亨”，他建立了一个帝国等等，这些你在学校都能学到。但你在学校学不到的是，他把一加仑煤油的成本从 1 美元降到了 10 美分。这就是那个“强盗大亨”，他让煤油变得如此便宜，以至于把所有的小作坊主都挤出了市场，这就是为什么他们恨他。所以，他是一个残酷的竞争者，但他把某种东西的价格降低了一个数量级，这太迷人了。所以，理解故事很重要，不仅仅是理论，而是故事。

---

### [01:36:22] Lenny

**English:**
I love how this always comes back to just being steeped in history and this specific point about biographies is really interesting, and we'll link to all these books that you're mentioning in the show notes. Is there a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
我喜欢你总是回到沉浸在历史中这一点，关于传记的观点真的很有趣。我们会把你在节目中提到的所有书都放在节目笔记里。最近有没有什么你非常喜欢的电影或电视剧？

---

### [01:36:36] Richard Rumelt

**English:**
Oh yeah, sure. Well, I like Yellowstone, like everybody else. I'm fascinated by it. Recent movies other than Yellowstone? I'm not sure. We don't have a TV in the house right now, so I'm not connected.

**中文翻译:**
噢，当然。我像其他人一样喜欢《黄石》（Yellowstone），我被它迷住了。除了《黄石》之外的近作？我不确定。我们家现在没电视，所以我没怎么关注。

---

### [01:36:51] Lenny

**English:**
That's amazing, that's the dream. I wish I could do that.

**中文翻译:**
太棒了，那是梦想中的生活。我希望我也能做到。

---

### [01:36:57] Richard Rumelt

**English:**
There will be a TV, but that room is being remodeled.

**中文翻译:**
会有电视的，只是那个房间正在装修。

---

### [01:37:02] Lenny

**English:**
I see, just a matter of time. Is there a favorite interview question you'd like to ask people you interview, maybe specifically around helping you get a sense of are they good at strategic thinking?

**中文翻译:**
明白了，只是时间问题。你有没有最喜欢的面试问题？也许是专门为了帮你判断对方是否擅长战略思考？

---

### [01:37:14] Richard Rumelt

**English:**
I like to ask people about, what have you done that was hard that you're proud of? What have you done that was difficult? And what was it and why was it difficult and how did you get it done? I like to ask people about what they think was an interesting strategy from any time in the past they want to call out. Depending on the person's background, I might ask them about a particular company or situation, let's say, why do you think this worked or why didn't it work? So, I don't tend to ask questions about theory, I tend to ask questions about things that happened and part of me, I'm looking, does this person have any knowledge about the world or are they just know what the professor said last year. So, that kind of thing.

**中文翻译:**
我喜欢问人们：你做过什么让你感到自豪的难事？你做过什么困难的事情？那是什么？为什么困难？你是如何完成的？我还喜欢问人们，他们认为过去任何时期有哪些有趣的战略值得一提。根据对方的背景，我可能会问他们关于特定公司或局势的问题，比如：你认为这为什么奏效，或者为什么没奏效？所以，我不倾向于问理论问题，我倾向于问关于发生过的事情的问题。我的一部分是在观察：这个人对世界有了解吗？还是他们只知道教授去年说了什么？就是这类问题。

---

### [01:38:28] Lenny

**English:**
Is there a favorite product you've recently discovered that you really like, whether it's an app, some you bought, some in the house, some on the road?

**中文翻译:**
你最近有没有发现什么非常喜欢的“心头好”产品？无论是 App、买的东西、家里的还是路上的？

---

### [01:38:36] Richard Rumelt

**English:**
Well, we've got this new memory foam bed that we like, it's a pretty amazing innovation. I didn't think we'd like that, but we do. I really am fascinated by... I'm about to pull the trigger on buying one of these new smart telescopes.

**中文翻译:**
嗯，我们买了一个新的记忆棉床垫，非常喜欢，这是一个相当惊人的创新。我原以为我们不会喜欢，但结果很满意。我最近还对……我正准备下单买一个新型的智能望远镜。

---

### [01:38:53] Lenny

**English:**
Smart telescopes? I haven't heard of that. What makes them so smart?

**中文翻译:**
智能望远镜？我还没听说过。它们哪里智能？

---

### [01:38:56] Richard Rumelt

**English:**
It's a 12-inch reflected telescope, and it's too heavy to look around, it's too difficult to set up, but there are sort of new smart telescopes that run on a battery and you can put them outside. And the way they work is, first of all, they know where everything is in the sky, which has been around for a long time, but the new thing is, it's like astrophotography. They'll look at something for a minute, two minutes, 10 minutes, an hour, and form an image. You don't look through the telescope, you look at it on your phone or your computer, but you can see now the nebula that maybe the web telescope can see and you can see it now and you can see stuff out there that you couldn't before. And these are new things for $1,000 or $2,000 set that are remarkable in what they can do.

**中文翻译:**
那是一个 12 英寸的反射式望远镜，通常这种望远镜太重了没法搬动，安装也太难。但现在有一种新型智能望远镜，靠电池运行，你可以把它放在室外。它们的工作原理是：首先，它们知道天空中的一切位置（这技术已经存在很久了），但新奇之处在于它像天文摄影。它们会对准某个物体观察一分钟、两分钟、十分钟甚至一小时，然后合成图像。你不需要对着目镜看，而是在手机或电脑上看。但你现在可以看到韦伯望远镜（Webb Telescope）能看到的星云，你可以亲眼看到以前看不到的东西。这些新设备大约 1000 到 2000 美元一套，功能非常惊人。

---

### [01:39:56] Lenny

**English:**
Excellent choice. Next question, do you have a favorite life motto that you often find yourself coming back to, sharing with friends, either in your work or in your life?

**中文翻译:**
绝佳的选择。下一个问题，你有没有最喜欢的人生格言，是你经常回想起、或者在工作生活中分享给朋友的？

---

### [01:40:05] Richard Rumelt

**English:**
I used to have a final lecture I'd give to my MBA students about little pieces of wisdom, things not to do, things that offend people in other cultures. Don't do this if you're in Turkey, it means something else there. But I'd also say at some point your spouse or your partner will ask you, "Do you still love me?" And there's only one correct answer to that question, which is more than ever. And my wedding ring says that inside it, more than ever. So, I don't know if that's what you're looking for, but that's-

**中文翻译:**
我以前常给 MBA 学生上最后一课，讲一些智慧小贴士：不要做的事，或者在其他文化中会冒犯人的事。比如在土耳其别做这个动作，在那里有别的意思。但我也会说，在某个时刻，你的配偶或伴侣会问你：“你还爱我吗？”这个问题只有一个正确答案，那就是：“比以往任何时候都更爱（More than ever）。”我的结婚戒指内侧就刻着这句话：“More than ever”。我不知道这是不是你想听的，但那是——

---

### [01:40:57] Lenny

**English:**
Absolutely.

**中文翻译:**
绝对是。

---

### [01:40:57] Richard Rumelt

**English:**
... Getting a [inaudible 01:40:58] sense piece of wisdom.

**中文翻译:**
……一种常识性的智慧。

---

### [01:40:59] Lenny

**English:**
That is really good advice, gave me tingles. I'm going to use that, 100%. Thank you for some marriage advice. Final question, your daughter Cassandra is a writer as well in fiction. She writes fiction. Is there anything that she taught you about writing that's helped you become a better writer?

**中文翻译:**
这真的是非常好的建议，听得我起鸡皮疙瘩。我百分之百会用到它。谢谢你的婚姻建议。最后一个问题，你的女儿 Cassandra 也是一位作家，她写小说。关于写作，她有没有教过你什么，帮助你成为更好的作家？

---

### [01:41:18] Richard Rumelt

**English:**
Yeah, Cassandra is the... Oh my God, she's got like 25 books on the New York Times Bestseller list for teen fiction now. She started writing when she was 12 or 13. She had a talent for it. She's told me about the tension that you have to create and she writes novels and that it's not interesting unless there's... Well, we started talking about this when she was young, she was 14, and she asked me about, what is romance? I said, "Well, romance is a barrier. Romance is where there's a difficulty back to a couple, and there's some kind of..."
(01:42:12):
She said, "Oh, like he's rich and she's poor?" I said, "Yeah, like that." "Or he comes from the north side of town and she comes from the south." And I said, "Like that, yes." And she said, "Oh, like he's a vampire and she's not?" Okay, so she has alerted me and taught me about ways of creating that kind of tension in writing. It doesn't work as much in business writing as I'd like, but I try to create this sense of it's good strategy, bad strategy. It's a sense of there's a tension between the right way and a wrong way, or if not a right and wrong way, at least there's a tension between, should we go left or should we go right? It makes it interesting, otherwise it doesn't catch people's emotional court.

**中文翻译:**
是的，Cassandra 她……天哪，她现在大概有 25 本书登上了《纽约时报》青少年小说畅销书排行榜。她 12、13 岁就开始写作，很有天赋。她告诉过我必须创造“张力”（tension）。她写小说，如果不有趣就没人看，除非有……好吧，我们从她很小的时候就开始讨论这个，她 14 岁时问我：什么是浪漫？我说：“浪漫就是障碍。浪漫是当一对情侣之间存在困难，有某种……”
(01:42:12):
她说：“噢，就像他很穷她很富？”我说：“对，就像那样。”“或者他来自城北，她来自城南。”我说：“是的，就像那样。”然后她说：“噢，就像他是吸血鬼而她不是？”好吧，所以她提醒并教会了我如何在写作中创造那种张力。虽然在商业写作中不像我希望的那样奏效，但我尝试创造这种“好战略、坏战略”的感觉。这是一种正确方式与错误方式之间的张力，或者即使没有绝对的对错，至少在“我们该向左还是向右”之间存在张力。这让内容变得有趣，否则它无法触动人们的情感。

---

### [01:43:14] Lenny

**English:**
Amazing. Richard, thank you so much for being here. I think we're going to help a lot more people face bigger challenges and face them head-on and put together their action agendas and overcome this crux. Thank you so much for being here. Two final questions, where can folks find you if they ever want to try to reach out or learn more about the work you're doing these days? And then how can listeners be useful to you?

**中文翻译:**
太棒了。Richard，非常感谢你能来到这里。我想我们会帮助更多人面对更大的挑战，正视挑战，制定他们的行动议程，并克服这些关键点。非常感谢你的到来。最后两个问题：如果大家想联系你或了解你近期的工作，可以在哪里找到你？另外，听众们能为你做些什么？

---

### [01:43:37] Richard Rumelt

**English:**
I have a little website called thecruxbook.com that has information about me and about the books, so there. Don't write to me at UCLA. I don't pay attention to the UCLA website anymore, but if you go to thecruxbook.com, there's some email addresses where I can be reached. My little company's called General Imagination. It's like General Motors, but a lot smaller. It's just me, and you can reach me at richard@generalimagination.com. You can help me out... Oh, tell me stories. Tell me stories about your experiences, trying to create strategies, particularly inside organizations. How's it worked for you trying to get something done inside organizations? I'm happy to add more stories to my repertoire. Oh, and hire me.

**中文翻译:**
我有一个小网站叫 thecruxbook.com，上面有关于我和我的书的信息。别往 UCLA 给我写信，我不再关注 UCLA 的网站了。但如果你去 thecruxbook.com，那里有一些可以联系到我的邮箱地址。我的小公司叫“通用想象力”（General Imagination）。就像通用汽车（General Motors）一样，但小得多。公司只有我一个人，你可以通过 richard@generalimagination.com 联系我。你可以帮我的忙……噢，给我讲讲故事。给我讲讲你们在组织内部尝试制定战略的经历。在组织内部尝试推动某事对你来说效果如何？我很乐意在我的素材库里增加更多故事。噢，还有，雇佣我。

---

### [01:44:46] Lenny

**English:**
Wait, say more on that. What is it that people would hire you for?

**中文翻译:**
等等，再多说两句。人们会雇佣你做什么？

---

### [01:44:51] Richard Rumelt

**English:**
At this point in my life, I do public speaking. I speak on strategy and growth, and just got back from Korea doing it, I taught there. I do a little bit of teaching, not much. Maybe for the military people, if they want me to come in and do a day on strategy and I do foundries. A foundry is where you commit to a problem-oriented approach to strategy where the organizational leader, the CEO, usually plus another seven or eight people take two to three or four days off and we meet and we try to come up with, in the end, an action agenda and it's an interpersonal exercise.
(01:45:52):
I'm the facilitator. I don't tell them what to do, but I urge them to look more deeply and to understand what these problems actually are. It's interesting to do a foundry. You get quite focused on problems, as I do at the beginning. I'll often get 25, 50 problems up on the board or Post-It notes around, and when people look at that, they'll say, "I haven't ever done this before." When they see the 25 different problems or challenges, they realize you can't do them all. And so, they begin to get this sense of, "Oh geez, we better focus. We better focus on something. We better do something about some of these." And so, then we begin to go through this thing, "Well, which ones are really important and which ones are really addressable?" Well, sometimes we don't know if they're addressable or not. Oh, well, is there anybody in the organization who does know? Is there someone we could fly in here or have some perspective on this? So, we begin to try to identify the one or two key challenges that can actually be addressed and what are we going to do about it? What are the coherent actions we're going to do to take these on? That's the exercise.
(01:47:16):
From time to time, after the foundries, they all say to me, "Well, where's the strategy? Where's the document with the mission, vision, all that?" No, that's not what we do. We're doing an action agenda and the foundry is time-consuming and a bit expensive to some extent, and most of the times we've had foundries, they really help the company gather its wits and its resources and do something, which I'm very pleased with how the foundries work. It's not so easy to figure out how to take the foundry concept and expand it. I've talked to a couple consulting firms about, "Well, the guys like learn how to do boundaries," and they say, "How does it work? It's one guy for three days? That's not what we do. We do 10 guys for three years." It's not a business model, but that's a nice symmetry for me because they're not going to compete with me.

**中文翻译:**
在我人生的这个阶段，我做公开演讲。我谈论战略和增长，刚从韩国演讲回来，我在那里授课。我做一点教学工作，不多。也许是为军方人员，如果他们想让我去做一天的战略讲座。我还做“铸造厂”（foundries）。“铸造厂”是指你致力于一种以问题为导向的战略方法，组织领导者（通常是 CEO）加上另外七八个人，抽出两到四天时间，我们见面并尝试最终制定出一份行动议程。这是一种人际互动练习。
(01:45:52):
我是引导者。我不告诉他们该做什么，但我敦促他们更深入地观察，理解这些问题到底是什么。做“铸造厂”很有趣。你会非常专注于问题，就像我开始做的那样。我经常会在白板上列出 25 到 50 个问题，或者贴满便签纸。当人们看到这些时，他们会说：“我以前从未这样做过。”当他们看到 25 个不同的问题或挑战时，他们意识到自己无法全部解决。于是，他们开始产生这种感觉：“噢，天哪，我们最好集中精力。我们最好专注于某些事情。我们最好针对其中一些采取行动。”然后，我们开始筛选：“哪些是真正重要的？哪些是真正可应对的？”有时我们不知道它们是否可应对。噢，好吧，组织里有人知道吗？有没有我们可以请来的人，或者能提供相关视角的人？所以，我们开始尝试识别出一两个真正可以被解决的关键挑战，并思考：我们要对此采取什么行动？我们要采取哪些连贯的行动来应对这些挑战？这就是练习的内容。
(01:47:16):
不时地，在“铸造厂”结束后，他们都会问我：“那么，战略在哪？那份包含使命、愿景等的文档在哪？”不，那不是我们做的。我们做的是行动议程。“铸造厂”很耗时，在某种程度上也挺贵。大多数时候，我们举办的“铸造厂”确实帮助公司集中了智慧和资源去采取行动，我对它的运作效果非常满意。要把“铸造厂”的概念扩大并不容易。我曾和几家咨询公司谈过，他们想学怎么做，然后他们问：“它是怎么运作的？一个人做三天？那不是我们做的，我们是十个人做三年。”这不是一种（传统的）商业模式，但对我来说这是一种很好的不对称性，因为他们不会和我竞争。

---

### [01:48:32] Lenny

**English:**
I love that. I feel like you're about to get a flood of interest and requests. For everyone else, make sure to buy Richard's books, I got them right here, The Crux, Good Strategy Bad Strategy. Richard, again, thank you so much for being here.

**中文翻译:**
我喜欢这个。我觉得你马上就会收到大量的关注和请求。各位听众，记得去买 Richard 的书，我手里就有：《关键点》和《好战略，坏战略》。Richard，再次感谢你的到来。

---

### [01:48:45] Richard Rumelt

**English:**
Lenny, thank you for a really pleasant time chatting.

**中文翻译:**
Lenny，谢谢你，这次聊天非常愉快。

---

### [01:48:49] Lenny

**English:**
It was 1000% my pleasure. Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
这是我 1000% 的荣幸。再见，各位。非常感谢大家的收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。