# Robby Stein - 双语对照

以下是 Lenny Rachitsky 对话谷歌搜索产品副总裁 Robby Stein 的完整双语转录文档。

---

### (00:00:00) Lenny Rachitsky

**English:**
It feels like something has changed internally at Google. Just last week, Google Gemini hit the number one app in the App Store. I feel like nobody saw this coming.

**中文翻译:**
感觉谷歌内部发生了一些变化。就在上周，Google Gemini 登顶了 App Store 应用榜单。我觉得没人预料到这一点。

---

### (00:00:08) Robby Stein

**English:**
Google's mission around have any information be universally accessible, this very enduring, very motivating thing, and it feels like with the AI moment, we can actually achieve that more than ever before. What I'm feeling now is just an incredible sense of focus and urgency. Things have hit a tipping point where these models are now truly able to deliver for consumers.

**中文翻译:**
谷歌的使命是让任何信息都能被普遍获取，这是一个非常持久、非常有动力的目标。感觉随着 AI 时代的到来，我们比以往任何时候都更能实现这一目标。我现在的感受是，内部有一种令人难以置信的专注感和紧迫感。事情已经到了一个临界点，这些模型现在真正能够为消费者提供价值了。

---

### (00:00:26) Lenny Rachitsky

**English:**
As ChatGPT emerged over the past couple of years, as Perplexity emerged, a lot of people were just like, "Google is dead. Nobody wants to sit through search results and click links."

**中文翻译:**
随着过去几年 ChatGPT 的兴起，以及 Perplexity 的出现，很多人都在说：“谷歌死定了。没人想在那儿翻看搜索结果然后点击链接。”

---

### (00:00:35) Robby Stein

**English:**
The core Google search isn't really changing, in my opinion. We're not seeing that people come to search for just ridiculously wide set of things. They want a specific phone number, they want a price for something, they want to get directions. I think the vastness of that is underappreciated by many people. AI is expansionary. There's actually just more and more questions being asked and curiosity that can be fulfilled now with AI.

**中文翻译:**
在我看来，核心的谷歌搜索并没有真正改变。我们看到人们来搜索的东西依然极其广泛。他们想要一个特定的电话号码，想要某个东西的价格，或者想要导航。我认为这种需求的广度被很多人低估了。AI 是具有扩张性的。事实上，现在有越来越多通过 AI 才能满足的问题和好奇心被提了出来。

---

### (00:00:54) Lenny Rachitsky

**English:**
You've built a lot of very successful products. You used this phrase: embodying relentless improvement.

**中文翻译:**
你打造过很多非常成功的产品。你用过这样一个短语：身体力行地追求持续改进（embodying relentless improvement）。

---

### (00:00:59) Robby Stein

**English:**
You need to be the physical manifestation of two pieces of things. One is just relentlessness, just complete effort that is always exerted in a direction of positive productivity. And then the second is make things better. You have to always make things better. You're never content.

**中文翻译:**
你需要成为两件事的化身。第一是坚持不懈，即始终朝着积极生产力的方向付出全部努力。第二是让事情变得更好。你必须永远追求更好，永不满足。

---

### (00:01:12) Lenny Rachitsky

**English:**
You build and launch Stories at Instagram back in the day is quite controversial because it basically took what Snapchat was doing really well and then like, "Hey, let's bring it to Instagram."

**中文翻译:**
当年你在 Instagram 打造并推出 Stories 功能时颇具争议，因为这基本上是把 Snapchat 做得非常好的东西拿过来，然后说：“嘿，我们也把它带到 Instagram 上吧。”

---

### (00:01:21) Robby Stein

**English:**
Not every great thing is going to be invented by you. Facebook probably created the modern feed, but there's a feed for every single product. At the end of the day, you're just robbing your user base of the opportunity to have a better product.

**中文翻译:**
并非每一件伟大的事物都必须由你发明。Facebook 可能创造了现代的信息流（feed），但现在每个产品都有信息流。归根结底，如果你不采用更好的形式，你只是在剥夺用户拥有更好产品的机会。

---

### (00:01:33) Lenny Rachitsky

**English:**
Today my guest is Robby Stein, Robby's VP of Product for Google Search and is responsible for essentially the entire Google search experience, including the new AI Overviews, AI Mode, multimodal AI experiences like Google Lens, the ranking algorithm, and a lot more. He's at the forefront of one of the biggest shifts in Google's history, and has already made a massive dent in Google's trajectory. He's also made a massive dent in the trajectory of Instagram where he was head of product, and led the launch of Instagram Stories and Reels and Close Friends, and through that, grew Instagram to half a billion daily active users. He's also on the founding team of Artifact with Mike Krieger and Kevin Systrom. Started two companies of his own. Very few people have had this level of impact on two global consumer products at this scale. And Robby shares all of the biggest lessons that he's learned about building great and successful consumer products, along with a bunch of insights into where Google is headed in the world of AI.
(00:02:28):
A huge thank you to Bart Stein for suggesting topics for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube, it helps tremendously. And, if you become an annual subscriber of my newsletter, you get a year free of 15 incredible products including Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Whispr Flow, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD, and Mobbin. Head on over to lennysnewsletter.com and click Product Pass. With that, I bring you Robby Stein.
(00:03:00):
My podcast guests and I love talking about craft and taste and agency and product market fit. You know what we don't love talking about? SOC 2. That's where Vanta comes in. Vanta helps companies of all sizes get compliant fast and stay that way with industry-leading AI automation and continuous monitoring. Whether you're a startup tackling your first SOC 2 or ISO 27001, or an enterprise managing vendor risk, Vanta's trust management platform makes it quicker, easier, and more scalable. Vanta also helps you complete security questionnaires up to five times faster so that you can win bigger deals sooner. The result? According to a recent IDC study, Vanta customers slashed over $500,000 a year and are three times more productive. Establishing trust isn't optional. Vanta makes it automatic. Get $1,000 off at vanta.com/lenny.
(00:03:54):
This episode is brought to you by Jira Product Discovery. The hardest part of building products isn't actually building products, it's everything else. It's proving that the work matters, managing stakeholders, trying to plan ahead. Most teams spend more time reacting than learning, chasing updates, justifying roadmaps, and constantly unblocking work to keep things moving. Jira Product Discovery puts you back in control. With Jira Product Discovery, you can capture insights and prioritize high-impact ideas. It's flexible, so it adapts to the way your team works and helps you build a roadmap that drives alignment, not questions. And because it's built on Jira, you can track ideas from strategy to delivery all in one place. Less chasing, more time to think, learn and build the right thing. Get Jira Product Discovery for free at atlassian.com/lenny. That's atlassian.com/lenny.
(00:04:49):
Robby, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Robby Stein。Robby 是谷歌搜索的产品副总裁，负责谷歌搜索的几乎全部体验，包括新的 AI Overviews（AI 概览）、AI Mode（AI 模式）、像 Google Lens 这样的多模态 AI 体验、排名算法等等。他处于谷歌历史上最大变革之一的前沿，并且已经对谷歌的发展轨迹产生了巨大影响。他曾任 Instagram 的产品负责人，领导推出了 Instagram Stories、Reels 和 Close Friends（亲密朋友），并将 Instagram 的日活用户推向了 5 亿。他还是 Artifact 创始团队成员，并创办过两家自己的公司。很少有人能在两个如此规模的全球消费级产品上产生这种程度的影响。Robby 将分享他在打造成功消费级产品中学到的最重要经验，以及对谷歌在 AI 世界走向的见解。
(00:02:28):
非常感谢 Bart Stein 为本次对话建议的话题。如果你喜欢这个播客，别忘了订阅。如果你成为我 newsletter 的年度订阅者，你将免费获得 15 款不可思议产品的一年使用权，包括 Perplexity、Linear 等。请访问 lennysnewsletter.com 点击 Product Pass。现在，让我们欢迎 Robby Stein。
(00:03:00):
（广告环节：Vanta 提供的 SOC 2 合规自动化服务。Vanta 帮助各种规模的公司快速获得合规认证，通过 AI 自动化和持续监控保持合规。在 vanta.com/lenny 可获得 1000 美元折扣。）
(00:03:54):
（广告环节：Jira Product Discovery。打造产品最难的部分不是构建本身，而是证明工作的价值、管理利益相关者和规划。Jira Product Discovery 让你重新掌控局面，捕捉洞察并确定高影响力的想法。在 atlassian.com/lenny 免费获取。）
(00:04:49):
Robby，非常感谢你能来，欢迎来到播客。

---

### (00:04:53) Robby Stein

**English:**
Thanks so much for having me.

**中文翻译:**
非常感谢邀请我。

---

### (00:04:54) Lenny Rachitsky

**English:**
This is such a cool week to be recording this podcast. So just last week, Gemini, Google Gemini hit the number one app in the App Store. I have it right here, it's still number one in the App Store. It's above ChatGPT. I feel like nobody saw this coming. I feel like everyone's always like, "Google, what have you guys been doing? You guys build all this amazing tech and why didn't you have anything working in consumer? Why is ChatGPT doing? Why are all these amazing companies doing better than Google?"
(00:05:20):
So first of all, let me just say congrats on, I know this isn't all you. I imagine you had some part in this, so just congrats.

**中文翻译:**
这周录制播客的时机太酷了。就在上周，Gemini（谷歌的 AI 应用）登顶了 App Store。我现在看着它，它依然是第一名，排在 ChatGPT 前面。我觉得没人预料到这一点。以前大家总在说：“谷歌，你们在干嘛？你们开发了这么多厉害的技术，为什么在消费端没拿得出手的？为什么 ChatGPT 和其他公司做得比谷歌好？”
(00:05:20):
所以首先，我要祝贺你，我知道这不全是你的功劳，但我猜你肯定参与其中了，恭喜。

---

### (00:05:26) Robby Stein

**English:**
Many, many more people, yes.

**中文翻译:**
是的，还有很多很多人参与了。

---

### (00:05:28) Lenny Rachitsky

**English:**
It feels like something has changed internally at Google. It feels like things are starting to really work, especially on the AI consumer side. So in terms of the growth, is Nano Banana the source of a lot of this recent growth or is there something else?

**中文翻译:**
感觉谷歌内部发生了一些变化。感觉事情开始真正起作用了，特别是在 AI 消费端。那么就增长而言，Nano Banana（谷歌内部的一个 AI 图像编辑工具）是最近增长的主要来源吗，还是有别的原因？

---

### (00:05:40) Robby Stein

**English:**
People are really excited about Nano Banana to be clear, very much so, but I think also people are recognizing that there's just so many cool things that you can do across the Google set of products and they've become quite powerful. I'm always shocked, even for things in search, people, we think they're very obvious. They sit right in the core search experience and then on X, I'll go look and like, "Oh, I just found out about this AI thing," and it seems very obvious, but I think a lot of people are just discovering quite how powerful these tools are.

**中文翻译:**
明确地说，人们确实对 Nano Banana 非常兴奋，但我也认为人们开始意识到，在谷歌的一系列产品中有很多很酷的事情可以做，而且它们已经变得非常强大。我总是感到惊讶，即使是搜索中的一些功能，我们觉得很明显，就放在核心搜索体验里，但我去 X（原 Twitter）上看，人们会发：“噢，我才发现这个 AI 功能”，这看起来很显而易见，但我认为很多人才刚刚开始发现这些工具到底有多强大。

---

### (00:06:07) Lenny Rachitsky

**English:**
Now. So to go one level deeper, to your point, there's been all this incredible tech. You guys wrote the original transformers paper that have powered so much of the innovation and it's just like, "Where's Google been? And actually, why aren't they building the thing that's winning?"
(00:06:20):
What has changed? Is it just like, okay, has there been major reorgs? Has there been new leaders put in place? Is there just a new philosophy in the past couple of years that have led to this moment where Gemini is now the top app in the world?

**中文翻译:**
那么深入一点说，正如你所言，谷歌一直有这些不可思议的技术。你们写了最初的 Transformer 论文，驱动了这么多创新，但大家会问：“谷歌之前去哪了？为什么他们没做出那个赢家产品？”
(00:06:20):
到底改变了什么？是进行了重大的组织架构调整吗？是换了新的领导层？还是过去几年有了新的理念，才导致了 Gemini 成为全球排名第一的应用？

---

### (00:06:32) Robby Stein

**English:**
Yeah, I mean, look, I've been to Google now, this is my second time at Google, so I started at Google in 2007, done a bunch of things in between, and I've been back at Google now, so I can't speak to that whole period for many, many years back to today. But what I can tell you about what I'm feeling now is just an incredible sense of focus and urgency to deliver great products quickly. I think that that is in part leadership for sure. I think the people who are, we work very closely with our partners at DeepMind and Google DeepMind. We work very closely obviously across the organization and there's just an incredible group of people and also an incredible group of researchers and technical thinkers who've been thinking about this for a while. When you have that energy, and I think the product teams and the tech, the research groups are working really closely together, we're able to move and we're getting a lot done.
(00:07:19):
I don't think there's any one thing that has happened. I think that a lot of times people ascribe a lot of momentum to a one time change or a single person. I find a lot of this is actually this compounding effect when you think about just every month ruthlessly improving the product or the models and just every day getting better, and then it just hits this tipping point where people just like it, they use it more, they enjoy it. And that's more of the feeling that I've had is just we've had, I think the right investment and focus and then it just hit a moment where people are seeing the effects of that now.

**中文翻译:**
是的，你看，这是我第二次在谷歌工作了。我 2007 年加入谷歌，中间做过很多别的事，现在又回来了。所以我不能代表过去很多年的整个时期。但我能告诉你现在的感受，那就是一种难以置信的专注感和紧迫感，要快速交付伟大的产品。我认为这部分归功于领导层。我们与 DeepMind 的伙伴们合作非常紧密。显然，我们在整个组织内紧密协作，这里有一群不可思议的人，还有一群思考这些问题很久的研究人员和技术思想家。当你拥有这种能量，并且产品团队、技术团队和研究小组紧密配合时，我们就能行动起来并完成很多工作。
(00:07:19):
我不认为发生了某一件特定的事。很多时候人们把动力归功于一次性的改变或某一个人。我发现这实际上是一种复合效应（compounding effect），当你每个月都在无情地改进产品或模型，每一天都在变得更好，然后它就会达到一个临界点，人们开始喜欢它、更多地使用它。这就是我的感觉：我们有了正确的投入和专注，然后现在到了人们看到成效的时刻。

---

### (00:07:52) Lenny Rachitsky

**English:**
As ChatGPT emerged over the past couple of years, as Perplexity emerged and all these other chatbots, a lot of people were just like, "Google is dead. Nobody wants to sit through search results and click links. Why not just get your answer right there?"
(00:08:06):
And it feels like that's not at all happening. It feels like you guys are doing just fine. What can you share about just the, I don't know, the state of Google search specifically, and then we'll talk about AI Mode. Just how is traffic going, how is search going considering all these things are out there, and just what are you seeing in the data since the launch of say ChatGPT?

**中文翻译:**
随着过去几年 ChatGPT、Perplexity 和其他聊天机器人的出现，很多人说：“谷歌死定了。没人想翻看搜索结果点链接。为什么不直接在那儿得到答案呢？”
(00:08:06):
但感觉这种情况根本没发生。感觉你们做得挺好的。关于谷歌搜索的具体现状，你能分享些什么吗？稍后我们会谈谈 AI Mode。考虑到外面有这么多竞争对手，流量情况如何？搜索业务怎么样？自从 ChatGPT 发布以来，你在数据中看到了什么？

---

### (00:08:24) Robby Stein

**English:**
Yeah. Well, what's interesting is people come to search for just ridiculously wide set of things, like all kinds of things. They want specific phone number, they want a price for something, they want to get directions, they want to find a payment web page for their taxes. Every possible thing you can imagine. I think the vastness of that is underappreciated by many people. And what we see is that it's not changing. AI hasn't really changed those foundational needs in many ways, and what we're finding is that AI is expansionary, and so there's actually just more and more questions being asked and curiosity that can be fulfilled now with AI. And so that's where you get the growth.
(00:09:00):
All the core Google search isn't really changing, in my opinion. We're not seeing that, but you're getting this expansion moment. What we're seeing is a few examples is you can now take a picture of something and ask about anything you see. And Google Lens, one of the fastest growing products out there, it's growing 70% year-over-year increase in visual searches, which is already at a massive scale. It's billions and billions and billions of searching in that way.
(00:09:24):
But you can take a picture of your shoes, say, "Where can I buy this?"
(00:09:27):
Or take a picture of your homework, say, "I'm stuck on question two."
(00:09:29):
And then just take a picture of your bookshelf and say, "What are the books I should get based on these books?" And AI can help you with those things now, just an example of I think why there's so much growth left and why we're so excited.

**中文翻译:**
是的。有趣的是，人们来搜索的东西范围极其广泛。他们想要特定的电话号码，想要某个东西的价格，想要导航，想要找交税的支付页面。你能想象到的任何事情。我认为这种广度被很多人低估了。我们看到的是，这些并没有改变。AI 在很多方面并没有改变这些基础需求，我们发现 AI 是扩张性的（expansionary），所以实际上有越来越多以前无法回答的问题和好奇心现在可以通过 AI 得到满足。这就是增长的来源。
(00:09:00):
在我看来，核心的谷歌搜索并没有真正改变。我们没看到核心需求萎缩，反而看到了扩张。举几个例子：你现在可以拍一张照片，询问你看到的任何东西。Google Lens 是目前增长最快的产品之一，视觉搜索量同比增长了 70%，而这已经是在一个巨大的基数之上的——那是数十亿次的搜索。
(00:09:24):
你可以拍一张鞋子的照片问：“哪里能买到这个？”
(00:09:27):
或者拍一张作业的照片说：“我卡在第二题了。”
(00:09:29):
或者拍一下你的书架问：“根据这些书，我该买什么新书？”AI 现在可以帮你做这些事。这只是一个例子，说明为什么还有这么多增长空间，以及为什么我们如此兴奋。

---

### (00:09:41) Lenny Rachitsky

**English:**
Okay, so you're not seeing the death of search.

**中文翻译:**
好，所以你并没有看到搜索的终结。

---

### (00:09:45) Robby Stein

**English:**
No.

**中文翻译:**
没有。

---

### (00:09:45) Lenny Rachitsky

**English:**
And along the same lines, you guys recently launched AI Mode, which I don't think enough people are talking about. I think you get there at google.com/ai, is that the right URL?

**中文翻译:**
顺着这个话题，你们最近推出了 AI Mode（AI 模式），我觉得讨论这个的人还不够多。我想访问地址是 google.com/ai，对吗？

---

### (00:09:53) Robby Stein

**English:**
Yep.

**中文翻译:**
是的。

---

### (00:09:54) Lenny Rachitsky

**English:**
Okay, cool. I've been playing with it as we were prepping for this conversation. It's really incredible. I asked it what is the best newsletter on product and growth and it's very smart. Said Lenny's Newsletter. So that's my eval.

**中文翻译:**
太酷了。我在准备这次对话时一直在玩它。真的很不可思议。我问它关于产品和增长最好的 newsletter 是什么，它非常聪明，说是 Lenny's Newsletter。这就是我的评估标准（笑）。

---

### (00:10:06) Robby Stein

**English:**
Fantastic. Okay, one of one, perfect eval.

**中文翻译:**
太棒了。满分评估。

---

### (00:10:10) Lenny Rachitsky

**English:**
It's perfect. Also, just if you go to it, there's these recommendations for things to ask it that are just like, "Wait, how did you know I care about this stuff?" So it's like, "Help me switch to product management," just on the front page.
(00:10:21):
I'm like, "How did you know?" And it tells you that it's based on your Google activity. Talk about just what people should know about AI Mode, maybe what they don't really understand about the power of this thing.

**中文翻译:**
非常完美。而且，如果你访问那个页面，它会有一些推荐问题，就像是：“等等，你怎么知道我关心这些？”比如首页上就有“帮我转型做产品经理”。
(00:10:21):
我就想：“你怎么知道的？”它会告诉你这是基于你的谷歌活动。谈谈人们应该了解的 AI Mode 吧，也许有哪些他们还没意识到的强大之处？

---

### (00:10:31) Robby Stein

**English:**
I can tell you there's three big components to how we can think about AI search and the next generation of search experiences. One is obviously AI Overviews, which are the quick and fast AI you get at the top of the page many people have seen, and that's obviously been something growing very, very quickly. This is when you ask a natural question, you just put it into Google, you get this AI now, it's really helpful for people.
(00:10:51):
The second is around multimodal. This is visual search and lens. That's the other big piece. You go to the camera in the Google app and that's seeing a bunch of growth. And then really with AI Mode, it really brings it all together. It creates an end-to-end frontier search experience on state-of-the-art models to really truly let you ask anything of Google search. You can go back and forth, you can have a conversation and it taps into and is specially designed for search. What does that mean?
(00:11:16):
And one of the cool things that I think it does is it's able to understand all of this incredibly rich information that's within Google. There's 50 billion products in the Google shopping graph, for instance. They're updated 2 billion times an hour by merchants with live prices. You have 250 million places in maps. You have all of the finance information, and not to mention, you have the entire context of the web and how to connect to it so that you can get context but then go deeper. You put all of that into this brain that is effectively this way to talk to Google and get at this knowledge. And that's really what you can do now.
(00:11:52):
You can ask anything on your mind and it'll use all of this information to hopefully give you super high quality and informed information as best as we can, and you can use it directly at this google.com/ai. But it's also been integrated into our core experiences too. We announced you can get to it really easily if you can ask follow-up questions of AI Overviews right into AI Mode now. Same for the lens stuff. Take a picture takes you to AI Modes, you can have this back, you can ask follow-up questions and go there too. So it's increasingly integrated experience into the core part of the product.

**中文翻译:**
关于 AI 搜索和下一代搜索体验，我们可以从三个主要组成部分来理解。第一显然是 AI Overviews（AI 概览），就是很多人在搜索结果页面顶部看到的快速 AI 回答，这部分增长非常快。当你输入一个自然语言问题时，它会直接给出 AI 生成的回答，对人们非常有帮助。
(00:10:51):
第二是多模态（multimodal）。这就是视觉搜索和 Lens。这是另一个大头。你在谷歌 App 里打开相机，这部分业务增长迅猛。第三就是 AI Mode，它真正把一切整合在了一起。它在最先进的模型上创建了一种端到端的尖端搜索体验，让你真正能向谷歌搜索询问任何事情。你可以来回对话，它专门为搜索而设计。这意味着什么呢？
(00:11:16):
我认为它最酷的一点是，它能理解谷歌内部所有极其丰富的信息。例如，谷歌购物图谱（Shopping Graph）中有 500 亿件商品，商家每小时更新 20 亿次实时价格。地图中有 2.5 亿个地点。还有所有的金融信息，更不用说整个互联网的上下文以及如何连接到这些内容，让你获得背景信息后还能深入挖掘。你把所有这些都放入这个“大脑”中，它实际上就是一种与谷歌对话并获取知识的方式。这就是你现在能做的事。
(00:11:52):
你可以问任何你想问的问题，它会利用所有这些信息，尽力为你提供高质量、信息丰富的回答。你可以直接在 google.com/ai 使用它，但它也已经集成到了我们的核心体验中。我们宣布，你可以通过 AI Overviews 的追问功能直接进入 AI Mode。Lens 也是一样，拍张照片就能带你进入 AI Mode 进行追问。所以它正日益成为核心产品中一种无缝集成的体验。

---

### (00:12:24) Lenny Rachitsky

**English:**
I imagine much of this is wait and see how people use it, but what's the vision of how all these things connect? Is the idea continue having this AI Mode on the side, AI Overviews at the top and then this multimodal experience, or is there a vision of somehow pushing these together even more over time?

**中文翻译:**
我猜很大程度上还要看人们怎么使用它，但愿景中这些东西是如何连接的？是打算继续让 AI Mode 作为一个侧边或独立功能，AI Overviews 放在顶部，再加上多模态体验，还是说有一个愿景，随着时间的推移将它们更紧密地融合在一起？

---

### (00:12:40) Robby Stein

**English:**
I think there's an opportunity for these to come closer together. I think that's what AI Mode represents, at least for the core AI experiences, but I think of them is very complimentary to the core search product. You should be able to not have to think about where you're asking a question ultimately, you just go to Google. Today, if you put in whatever you want, we're actually starting to use much of the power behind AI Mode right in AI Overviews. So you can just ask really hard, you could put a five sentence question right into Google search. You can try it and then it should trigger AI at the top. It's a preview, and then you can go deeper into AI Mode and have this back and forth. So that's how these things connect.
(00:13:15):
Same for your camera. So if you take a picture of something, "What's this plant?" Or, "How do I buy these shoes?" It should take you to an AI little preview. And then if you go deeper, again, it's powered by AI Mode. You can have that back and forth, so you shouldn't have to think about that. It should feel like a consistent simple product experience ultimately, but obviously this is a new thing for us, and so we wanted to start it in a way that people could use and give us feedback with something like a direct entry point like google.com/ai.

**中文翻译:**
我认为它们有机会走得更近。我认为 AI Mode 就代表了这种趋势，至少对于核心 AI 体验来说是这样。但我认为它们与核心搜索产品是非常互补的。最终，你应该不需要考虑在哪里提问，你只需要去谷歌就行。今天，无论你输入什么，我们实际上已经开始在 AI Overviews 中使用 AI Mode 背后的很多能力了。所以你可以问很难的问题，甚至在谷歌搜索框里输入一个五句话长的问题。你可以试试，它应该会在顶部触发 AI。那是一个预览，然后你可以深入进入 AI Mode 进行来回对话。这就是它们的连接方式。
(00:13:15):
相机也是一样。如果你拍一张照片问：“这是什么植物？”或者“怎么买这双鞋？”，它会给你一个 AI 小预览。如果你想深入了解，它同样由 AI Mode 驱动。你可以进行对话，所以你不需要去思考背后的逻辑。最终它应该感觉像是一个一致且简单的产品体验。但显然这对我们来说是个新事物，所以我们想先通过 google.com/ai 这样一个直接入口让人们使用并给我们反馈。

---

### (00:13:41) Lenny Rachitsky

**English:**
I recently had Brian Balfour on the podcast and he showed this quote that's really stuck with me that I think about as you talk about all this, it was by Alex Rampell, this idea that startups is a game of getting distribution before incumbents can innovate fast enough.
(00:13:55):
And it feels like you guys are finally there where it's like, "Oh man, now here comes Google." I don't know if I have a question here, but it just feels like there's been all this time for people to find distribution, and now it's like, okay, now Google is coming.

**中文翻译:**
我最近请 Brian Balfour 上了播客，他分享了一句让我印象深刻的话，当你谈到这些时我也想到了它。那是 Alex Rampell 说的：初创公司的游戏是在现有的巨头（incumbents）创新速度够快之前，先获得分发渠道（distribution）。
(00:13:55):
感觉你们终于到了那个阶段，大家会觉得：“噢天哪，谷歌来了。”我这不算个问题，但感觉之前大家有时间去寻找分发渠道，而现在，谷歌开始发力了。

---

### (00:14:07) Robby Stein

**English:**
What we found is that people are asking these questions in Google. They're trying to get this out of Google. And so if you can just have an AI that's powerful enough to answer a really hard calculation someone's trying to figure out, or take a picture of multiple choice homework question for a chemistry question, people are doing this. And so now that you have this really sophisticated AI that's based on our frontier models, we can just handle increasingly more and more stuff for people and so hopefully that's the more natural on ramp here. And then we just need to make it easy enough for people to use, because these are new products, and people are used to using Google in a specific way.
(00:14:38):
They type in keywords, we call it sometimes keyword ease, but you can actually use natural language in Google. That's the biggest shift. We're seeing people asking real long, hard, complex questions. You just don't think, "Oh, I can go to Google and type in what's a great place for a date night? I already went to these four restaurants. I'm looking for outdoor dining and my friend has this allergy." You could put that into Google. And I think that's the kind of thing that we're excited to continue to make easy for people.

**中文翻译:**
我们发现人们确实在谷歌里问这些问题。他们试图从谷歌得到答案。所以，如果你能拥有一个足够强大的 AI，能回答别人正在算的难题，或者拍一张化学作业的选择题照片，人们就会这么做。现在我们有了基于前沿模型的复杂 AI，我们可以为人们处理越来越多的事情，希望这能成为一个更自然的入口。我们只需要让它足够易用，因为这些是新产品，而人们习惯了以特定的方式使用谷歌。
(00:14:38):
以前人们输入关键词，我们有时称之为“关键词式表达”，但现在你真的可以在谷歌里使用自然语言。这是最大的转变。我们看到人们在问非常长、非常难、非常复杂的问题。你以前可能不会想：“噢，我可以去谷歌输入：‘哪里适合约会？我已经去过这四家餐厅了，我想找有户外座位的，而且我朋友对这个过敏。’”现在你可以把这些都输入谷歌。这就是我们感到兴奋并致力于让它变得更简单的事情。

---

### (00:15:03) Lenny Rachitsky

**English:**
It's interesting, and we've come around to back in the day there was Ask Jeeves, which was this whole just ask a question as if you're asking a human and then it'll give you a really good answer.
(00:15:12):
And then we moved into Google just, "No, no, just type the thing you want and figure out how Google likes it."
(00:15:17):
And now we're back to, "Okay, just ask your question and it'll give you a really good answer."

**中文翻译:**
这很有趣，我们绕了一圈又回来了。以前有个 Ask Jeeves（早期的问答搜索引擎），它的理念就是像问人一样问问题，然后它给你一个很好的答案。
(00:15:12):
后来我们进入了谷歌时代：“不不，直接输入你想要的东西，去琢磨谷歌喜欢什么样的关键词。”
(00:15:17):
现在我们又回到了：“好吧，直接问你的问题，它会给你一个很好的答案。”

---

### (00:15:20) Robby Stein

**English:**
Yeah, Ask Jeeves was surprisingly prescient on that, huh? They had material, they had something way before its time that we think looks to rally around now.

**中文翻译:**
是的，Ask Jeeves 在这方面出奇地有先见之明，对吧？他们在那时就有了这种超前的想法，而我们现在正重新围绕这个理念集结。

---

### (00:15:29) Lenny Rachitsky

**English:**
Oh, man. What's your take on this whole rise of AEO, GEO, which is this evolution of SEO? I'm guessing your answer is going to be just create awesome stuff and don't worry about it, but there's a whole skill of getting to show up in these answers. Thoughts on what people should be thinking about here?

**中文翻译:**
噢天哪。你对 AEO（AI 引擎优化）、GEO（生成式引擎优化）的兴起怎么看？这是 SEO 的进化版。我猜你的回答会是“只要创作出色的内容，别担心其他的”，但要出现在这些 AI 答案里确实有一套技巧。你觉得人们在这里应该思考些什么？

---

### (00:15:47) Robby Stein

**English:**
Sure. I mean, I can give you a little bit of under the hood how this stuff works because I do think that helps people understand what to do, but when our AI constructs a response, it's actually trying to, it does something called query fan-out where the model uses Google search as a tool to find to do other querying. Maybe you're asking about specific shoes, it'll add up and append all of these other queries like maybe dozens of queries and start searching basically in the background. And it'll make requests to our data back end, so if it needs real time information, it'll go do that. And so at the end of the day, actually something searching, it's not a person, but there's searches happening and then each search is paired with content. And so if for a given search your web page is designed to be extremely helpful and you can look up Google's human rater guidelines and read, it's a very long document that's been thoughtfully crafted for decades now around what makes great information.
(00:16:40):
This is something Google has studied more than anyone, and it's like, do you satisfy the user intent, what they're trying to get? Do you have sources? Do you cite your information? Is it original or is it repeating things that have been repeated 500 times? And there's these best practices that I think still do largely apply because it's going to ultimately come down to an AI is doing research and finding information. And a lot of the core signals, is this a good piece of information for the question? They're still valid, they're still extremely valid and extremely useful, and that will produce a response where you're more likely to show up in those experiences now.
(00:17:14):
I think the only thing I would give advice to would be think about what people are using AI for. I mentioned this as an expansionary moment. It seems to be that people are asking a lot more questions now, particularly around things like advice, or how to, or more complex needs versus maybe more simple things. And so if I were a creator, I would be thinking, what kind of content is someone using AI for? And then how could my content be the best for that given set of needs now? And I think that a lot is a really tangible way of thinking about it.

**中文翻译:**
当然。我可以告诉你一些底层运作机制，因为我认为这有助于人们理解该怎么做。当我们的 AI 构建回复时，它实际上在进行一种叫做“查询扇出”（query fan-out）的操作，模型将谷歌搜索作为一个工具来执行其他查询。比如你问特定的鞋子，它会生成并追加几十个其他查询，在后台开始搜索。它会向我们的数据后端发出请求，如果需要实时信息，它就会去获取。所以归根结底，虽然不是人在搜索，但搜索确实在发生，而每次搜索都会匹配内容。
(00:16:40):
如果针对某个搜索，你的网页设计得非常有帮助——你可以去查阅谷歌的“人工评估员指南”（human rater guidelines），这是一份几十年来精心编写的长文档，关于什么是优质信息。这是谷歌研究得比谁都透彻的东西：你是否满足了用户意图？你是否有来源？你是否引用了信息？它是原创的，还是在重复已经被重复了 500 遍的东西？我认为这些最佳实践在很大程度上仍然适用，因为最终归结为 AI 在进行研究和寻找信息。很多核心信号——“这条信息对这个问题有帮助吗？”——依然有效，而且极其有用。这会让你更有可能出现在 AI 的回复中。
(00:17:14):
我唯一的建议是：思考人们在用 AI 做什么。我提到这是一个扩张时刻。人们现在似乎在问更多问题，特别是关于建议、操作指南（how-to）或更复杂的需求，而不是简单的查询。所以如果我是一个创作者，我会思考：人们会为了什么内容去使用 AI？我的内容如何才能成为满足这些需求的最佳选择？我认为这是一个非常切实的思考方式。

---

### (00:17:45) Lenny Rachitsky

**English:**
It's interesting your point about how it goes in searches. When you use it, it's searching a thousand pages or something like that. Is that just a different core mechanic to how other popular chatbots work because the others don't go search a bunch of websites as you're asking?

**中文翻译:**
你关于它如何进行搜索的观点很有趣。当你使用它时，它会搜索一千个页面之类的。这是否与其他流行的聊天机器人的核心机制不同？因为其他的机器人在你提问时似乎不会去搜索一大堆网站。

---

### (00:18:00) Robby Stein

**English:**
Yeah. This is something that we've done uniquely for our AI. It obviously has the ability to use parametric memory and thinking and reasoning and all the things a model does, but one of the things that makes it unique for designing it specifically for informational tasks, we wanted to be the best at informational needs, that's what's Google's all about, and so how does it find information? How does it know if information is right? How does it check its work? These are all things that we built into the model, and so there is a unique access to Google. Obviously, it's part of Google search, so it's Google search signals everything from spam, what's content that could be spam? And we don't want to probably use in a response all the way to, wow, this is the most authoritative helpful piece of information. We're going to link to it and we're going to explain, hey, according to this website, check out that information and then you're going to go probably go see that yourself. That's how we've thought about designing this.

**中文翻译:**
是的。这是我们专门为自己的 AI 做的独特设计。它显然具有使用参数化记忆、思考和推理的能力，但为了专门针对信息类任务进行设计，我们希望在满足信息需求方面做到最好——这也是谷歌的立身之本。所以，它如何寻找信息？它如何知道信息是否正确？它如何检查自己的工作？这些都是我们内置在模型中的。它拥有对谷歌搜索信号的独特访问权。显然，作为谷歌搜索的一部分，它能识别从垃圾信息（spam）到最权威、最有帮助的信息。我们会链接到它，并解释：“根据这个网站，查看这些信息”，然后你可能会亲自去查看。这就是我们设计它的思路。

---

### (00:18:51) Lenny Rachitsky

**English:**
You've worked on a lot of AI products at this point, and it's not just Google or Artifact and Instagram, you did a lot of AI stuff. What's something you've learned about building AI products that you find maybe people don't truly understand, maybe something that's surprised you by building successful AI products?

**中文翻译:**
到目前为止，你已经参与了很多 AI 产品，不仅是在谷歌，在 Artifact 和 Instagram 时你也做了很多 AI 相关的工作。在构建 AI 产品方面，你学到了哪些人们可能并不真正理解的东西？或者在构建成功的 AI 产品过程中，有什么让你感到惊讶的事情？

---

### (00:19:07) Robby Stein

**English:**
I think the most recent one, and this is true, something even within the last week or two, is that it's so obvious how human-like the interface is becoming with how you can communicate and steer AI. I think it used to be even just months back that you had to do a lot of work to get the AI to do the thing you're trying to get it to do, right? You had to do these incantations, you had to prompt in a really specific way. People would have all these hacks like, "Hey, act like you're a coach and you do these things," and you have to really push it, or to use a tool more on the technical side. You had to do post-training, you had to take this foundational model and you had to show it data, you had to train it and actually update its weights to do more sophisticated things.
(00:19:51):
Tell it, "Hey, here's documentation for an API. If you ever have a problem, ping this API. Here's the data," as if it's an engineer that you had that you could talk to and it would have no idea what to do with that, or it would have some idea and wouldn't really do it.
(00:20:05):
But increasingly, you can just use language. Almost if you were to write up an order, you could be like, "Wow, I'm a new startup. Here's my data internally. Here are the APIs to it. Here's the schema and the URL. Here's when to use it. By the way, make sure that if you get this kind of a question, you really make sure to get it right." And that'll end up doing a lot in the model.
(00:20:28):
The model's been now encoded to be able to say, "Okay, I'm going to use more reasoning or thinking budget for that kind of a question."
(00:20:35):
Or, "I'm going to use tools or code, use code execution in order to connect to this API I'm told about." That's a relatively new thing. So I think it's going to open up a lot of this democratization of accessing these models and building incredible things because you don't even need to do a lot. To get the most sophisticated outcomes increasingly, I don't think you need to do a lot of this heavy duty fine-tuning.

**中文翻译:**
我认为最近的一个发现——就在过去一两周内——就是 AI 的界面正变得多么像人类，你可以如此自然地与它交流并引导它。就在几个月前，你还得费很大劲才能让 AI 做你想让它做的事，对吧？你得像念咒语一样，用非常特定的方式写提示词（prompt）。人们会有各种技巧，比如“嘿，假装你是一个教练，做这些事”，你得拼命推它。或者在技术层面，你得做后期训练，拿一个基础模型，给它看数据，训练它，更新它的权重来做更复杂的事。
(00:19:51):
以前如果你告诉它：“嘿，这是 API 文档。如果你遇到问题，就调用这个 API。这是数据。”就像你跟一个工程师说话一样，但它可能完全不知道该怎么办，或者知道一点但做不到。
(00:20:05):
但现在，你越来越可以直接使用语言。就像写一份指令一样，你可以说：“哇，我是一家初创公司。这是我的内部数据。这是对应的 API、架构和 URL。这是使用时机。顺便说一下，如果遇到这类问题，一定要确保准确。”这在模型中会产生很大的作用。
(00:20:28):
现在的模型已经被编码为能够识别：“好吧，对于这类问题，我要分配更多的推理或思考预算。”
(00:20:35):
或者：“我要使用工具或代码执行，以便连接到我被告知的这个 API。”这是一个相对较新的变化。所以我认为这将开启模型访问的民主化，让人们能做出不可思议的东西，因为你甚至不需要做太多。为了获得最复杂的结果，我认为越来越不需要进行那种繁重的微调（fine-tuning）了。

---

### (00:20:58) Lenny Rachitsky

**English:**
It makes me think about, I had this recent guest, Nesrine Changuel, on the podcast. She was a PM at Google, she worked on Google Meet, she was a delight PM working on at making products more delightful. And she talked about the reason Google Meet did so well and is now feels like it's killing Zoom is they compared the experience of Google meet to a human meeting versus making it the best possible video conference, make this as good as a human experience. And that's interesting what you're talking about, how that's almost the goal here with AI is just make you feel like you're just talking to a person.

**中文翻译:**
这让我想起最近的一位嘉宾 Nesrine Changuel。她曾是谷歌的 PM，负责 Google Meet，她是一位致力于让产品更令人愉悦的“愉悦感 PM”（delight PM）。她谈到 Google Meet 表现出色、甚至感觉在超越 Zoom 的原因是，他们将 Google Meet 的体验与“人类会议”进行对比，而不是仅仅做一个最好的视频会议工具——目标是让它像人类体验一样好。你刚才说的很有趣，这几乎也是 AI 的目标：让你觉得就像在和一个人说话。

---

### (00:21:27) Robby Stein

**English:**
Exactly.

**中文翻译:**
没错。

---

### (00:21:28) Lenny Rachitsky

**English:**
Might be obvious, but think about that. Okay, let me zoom out and talk about, and let's talk about just broader lessons you've learned over the course of your career. You've built a lot of very successful products, which I've shared in the intro at this point.

**中文翻译:**
这可能显而易见，但值得深思。好吧，让我把视角放大，谈谈你在职业生涯中学到的更广泛的经验。你打造过很多非常成功的产品，我在开场白里已经介绍过了。

---

### (00:21:44) Robby Stein

**English:**
Many also on the other side of the spectrum, we got the whole portfolio.

**中文翻译:**
也有很多在光谱另一端的（失败产品），我的作品集里什么都有。

---

### (00:21:48) Lenny Rachitsky

**English:**
Okay, perfect. We'll talk about some of that. I asked you as we were getting ready for this conversation, what's one thing you wanted to get across in this conversation? What's something you think would be really helpful for product builders to hear to help them build more successful products? And you used this phrase: embodying relentless improvement. Can you just talk about that? What does that mean? Why is this so important?

**中文翻译:**
太好了，我们会聊聊那些。在准备这次对话时我问过你，你最想传达的一点是什么？你认为对产品构建者最有帮助、能帮他们做出更成功产品的东西是什么？你用了这个短语：身体力行地追求持续改进（embodying relentless improvement）。能谈谈这个吗？它意味着什么？为什么它如此重要？

---

### (00:22:08) Robby Stein

**English:**
Of course, I mean, I think that you need to be the physical manifestation of two pieces of things. One is just relentlessness, just complete effort, but is always exerted in a direction of positive productivity. And then the second is make things better. You have to always make things better, you're never content. And I think this actually came out of a story, a little bit of a funny story where I was at Instagram at the time doing a big all team meeting, one of my first, and they had this icebreaker, what's one word to describe yourself?
(00:22:35):
And so in the backstage area, I texted my wife really quick. I was like, "Hey, just one word to describe me, first thing that comes to your mind."
(00:22:42):
And she just wrote back, "Dissatisfied."
(00:22:45):
I was chuckling in the back room because I was first of all kind of offended because I was like, "It's not loving, caring, something good?" And then I saw her little bubble thing.
(00:22:56):
She's like, "Okay, there's more." And then she wrote me this really thoughtful thing that was like, "It's not that you're just unhappy. It's like you want the world to be better. You're driven out of a deep desire. It's that you feel this sense of dissatisfaction with what the world gives you. You want to make it better, and you're pushed and motivated to do that."
(00:23:17):
And I thought about that after. And it wasn't until we built a bunch of products, some that didn't do well, some that have had a lot of really large success now, billions of people use them, where it felt like one of the big differences, obviously a lot of it is just the conditions of the product and a little bit of luck here and there too. But for the things that went well, there was always this spirit of just we're going to get it eventually if we just make two more moves to make it better. And then eventually, as I talked about before earlier in our conversation, you get this tipping point where it just tips over into being net useful to people because of just that amount of compounding effort that you put into something because you're just always so... You're the harshest critic and the most dissatisfied person in the room about your own work basically.
(00:23:56):
And I think that's really meaningful. And there's this other incredible story that Tony Fadell told on a TED Talk 10 years ago. You can look it up. I think it's something around Think Younger as a title. And he talks about what it means that as we grow up in age and become grownups, I have two little kids so that's something I think about a lot. We habituate to everything. We accept and we tolerate what the world gives us everywhere, and we just go, "Oh, that kind of sucks. Oh, well," we shrug our shoulders and we move on.
(00:24:27):
But if you don't do that and you ask, "Why? This sucks, why am I tolerating this and how do I make it better?" He has this incredible story about going grocery shopping, and he goes on for 10 minutes about this story almost it felt like where he talks about getting a piece of fruit like a plum or a peach, and how it has that sticker on it and it's got that sticker and who put that sticker there?
(00:24:51):
And then when you get home, you take your fruit out of your bag, you're ready to eat it, you're all excited, you stick your thumb under the sticker, it punctures the flesh. He goes into just incredible detail about how it punctures the flesh of the fruit. The sticker comes off now, the fruit's bleeding, then you flick the sticker. The sticker misses the garbage, you bend over and pick it up, you put the sticker back in.
(00:25:17):
And I was like, "Wow, that is embodying this mentality of just why is this here? How can this be better?" And I think the best product people, the best thinkers in the space, that's how they think, in my opinion.

**中文翻译:**
当然。我认为你需要成为两件事的化身。第一是坚持不懈（relentlessness），即始终朝着积极生产力的方向付出全部努力。第二是让事情变得更好。你必须永远追求更好，永不满足。这其实源于一个有趣的故事。当时我在 Instagram 参加一次全员大会，那是我刚加入不久。有个破冰环节，问：用一个词形容你自己？
(00:22:35):
在后台，我赶紧给妻子发了条短信：“嘿，用一个词形容我，你脑子里跳出的第一个词是什么？”
(00:22:42):
她回道：“不满足（Dissatisfied）。”
(00:22:45):
我在后台笑了起来，起初有点被冒犯，我想：“难道不是‘充满爱心’、‘体贴’之类的好词吗？”然后我看到她的输入气泡还在动。
(00:22:56):
她说：“好吧，还有下文。”她给我写了一段非常深刻的话：“并不是说你只是不开心。而是你希望世界变得更好。你被一种深刻的渴望驱动着。你对世界现状感到一种不满，你想改进它，你被这种动力推着走。”
(00:23:17):
后来我思考了这段话。直到我们打造了一堆产品，有些失败了，有些获得了巨大成功（现在有数十亿人在用），我才意识到其中的巨大差别。当然，很多时候取决于产品环境和运气，但在那些成功的案例中，总有一种精神：如果我们再做两步改进，最终一定能成功。正如我之前提到的，你会达到一个临界点，由于你投入的大量复合努力，产品最终变得对人们极其有用。因为你总是自己作品最严厉的批评者，是房间里对自己工作最不满意的人。
(00:23:56):
我认为这非常有意义。Tony Fadell（iPod 之父）十年前在 TED 演讲中讲过一个不可思议的故事，题目大概叫《年轻化思考》（Think Younger）。他谈到随着我们长大成人（我有两个小孩，所以我经常想这个），我们会对一切产生“习惯化”（habituate）。我们接受并容忍世界给予我们的一切，我们会说：“噢，这有点烂，好吧，”耸耸肩就过去了。
(00:24:27):
但如果你不这样做，而是问：“为什么？这太烂了，我为什么要容忍它，我该怎么改进它？”他讲了一个去超市买水果的故事，讲了整整十分钟。他说你买了一个李子或桃子，上面贴着那个小标签，是谁把标签贴在那儿的？
(00:24:51):
当你回到家，把水果从袋子里拿出来准备吃，你兴奋地用大拇指去抠那个标签，结果指甲刺破了果肉。他描述得极其详细，标签撕下来了，水果在“流血”，然后你弹开标签，标签没进垃圾桶，你还得弯腰捡起来放回去。
(00:25:17):
我就想：“哇，这就是这种心态的体现——为什么它在那儿？它怎么能变得更好？”我认为最优秀的产品人、这个领域最优秀的思想家，都是这样思考的。

---

### (00:25:32) Lenny Rachitsky

**English:**
I imagine there are many examples of you doing this in the many products you worked on. Is there one that comes to mind as a good example of this inaction of this actually working really well and delivering something really huge?

**中文翻译:**
我猜在你参与过的众多产品中，有很多这样的例子。有没有哪一个让你觉得是这种心态在起作用，并最终交付了巨大成果的典型案例？

---

### (00:25:44) Robby Stein

**English:**
I mean, honestly, a big thing is working on AI Mode. I think a lot of it was we saw in AI Overviews that people were trying to ask harder questions and we weren't able to answer a bunch of them, or AI Overviews just didn't show up. And so a bunch of us sat around and we're like, "Why can't you just do this for everything?"
(00:26:04):
Instead of saying, "Oh, we don't need to solve for that," or, "That's not something that's in the most addressable next thing."
(00:26:12):
It's like we actually saw people in the query stream putting the words AI at the end of their queries because they're trying to get the AI to do the thing. We would look at that and be like, "This is ridiculous. We need to build something here."
(00:26:27):
And that was one of the big motivations, was actually identifying that user problem, being very disgruntled on behalf of the user. We're just failing the user every day. We are not helping them actually get their thing better understood, and we're going to go build a whole thing because of it, because that's hard to do by the way, to build all of that. But it just was so obvious that that's what we needed to do.

**中文翻译:**
坦白说，开发 AI Mode 就是一个大例子。我们在 AI Overviews 中看到人们尝试问更难的问题，而我们无法回答其中的很多问题，或者 AI Overviews 根本没出现。于是我们几个人坐在一起想：“为什么不能对所有问题都这样做呢？”
(00:26:04):
我们没有说：“噢，我们不需要解决那个问题，”或者“那不是目前最紧迫的事。”
(00:26:12):
事实上，我们在查询流中看到人们在搜索词末尾加上“AI”这个词，因为他们想让 AI 来处理。我们看着这些数据想：“这太荒谬了。我们需要在这里构建一些东西。”
(00:26:27):
那是巨大的动力之一——识别出用户的痛点，并代表用户感到非常不满。我们每天都在辜负用户。我们没有帮助他们更好地理解他们想要的东西，所以我们要为此构建一整套东西。顺便说一句，构建这一切非常难。但当时情况非常明显，这就是我们需要做的。

---

### (00:26:52) Lenny Rachitsky

**English:**
There's two buckets of people. Let's say hypothetically, one bucket is just make things better, make amazing experiences, you're going to do great. There's another bucket that's like drive metrics, drive goals, hit our KPIs. I know what you're not saying is just work on things, just make things better, relentlessly, make things better. How do you just think about, I guess that overlap of okay, makes things better, but also here's what we really, here's the strategy, here's the vision. How do you think?

**中文翻译:**
假设有两类人。一类是“只管把事情做好，创造惊人的体验，你就会成功”。另一类是“驱动指标，达成目标，完成 KPI”。我知道你并不是说漫无目的地改进。你如何看待“让事情变得更好”与“战略、愿景、指标”之间的重叠？你是怎么思考的？

---

### (00:27:18) Robby Stein

**English:**
Yeah, I don't think of them as an or. I think they have to be intersected because basically the way I think about it is you actually start with a problem or the inverse of that, which is a vision, but they're connected. Most great companies, most great products come out of a problem, but out of the problem becomes like, "Here's a better way." What if instead of this crappy thing or way of living or thing that we all tolerate and accept, some entrepreneur comes up and says, "What if we did this other thing?" So it comes out of this dissatisfaction and this sense of better that you need to make things better, but then you're going to build, and at the end of the day, you need your instrumentation to know if you're on the right track.
(00:27:58):
And that's where you bring tools like, okay, you build your first version of the product, do people like it? And then each product goes through its journey. The way understand that people like it is you scrutinize. Typically, you talk to people, but you also add some analytical tools there. You might look at something like a J-curve. This is the retention, the percentage of people still using the product day seven, day 30, day 90, and does it flatten or do people just drip out of there? Over time, it's just not exciting people. And that would go to zero if on a long enough timeline, no one's going to use it. You don't get past that, you toast right then. Okay, some people are doing it, okay, great. We need more people to do it, and it needs to be good enough that people talk about it and then it grows. And so that's another gate.
(00:28:44):
And then there's another one which is, well, how big can this get actually, is it a small thing? Is it a medium thing? And I think most companies, you have an aspiration of being big, but you can't start big. Everyone's got to go through that journey. No product has started big. Even ones that get big really quickly, even a week quickly, they had something. And then even internally, they started small. They started small with a hundred to 100 people, and so you have to be metrics focused, I think in order to know if you're doing the right thing.
(00:29:09):
And then the other thing is, on the other side of the spectrum, you're running a big thing, and there, you need metrics to be your guide. If your product, let's say, let's say our core metrics down 5% this week, it's like, well, what's going on? And so you be really close to root cause analysis there and say, "Well, actually it turns out that it's an issue. Is it in a region? Is it on a device? Is it in a demographic? Is it in a use case? Where does my problem lie?"
(00:29:33):
And then when you get to it, you understand the problem and then this improvement thing comes back where it's like, "Okay, I'm going to fix that thing. What's the treatment for that disease?" And then you're back to growth again, and so you need this and you always are looking at what's the system that I'm working on and what are my instruments? I'm a pilot to know if this thing is going and flying correctly, but then it doesn't tell you exactly what to do, you have to thank for yourself how to make it better. I can just show you a little bit of the way.

**中文翻译:**
是的，我不认为它们是“非此即彼”的关系。我认为它们必须交织在一起。我的思考方式是：你从一个问题开始，或者从它的反面——愿景开始，但它们是相连的。大多数伟大的公司和产品都源于一个问题，然后从问题中诞生出：“这里有一个更好的方法。”如果不再忍受这个糟糕的东西或生活方式，而是有创业者站出来说：“如果我们换种做法呢？”所以它源于这种“不满足感”和“追求更好”的意识。但接着你要去构建，而最终你需要“仪表盘”来知道你是否走在正确的轨道上。
(00:27:58):
这就是工具发挥作用的地方。你构建了产品的第一版，人们喜欢吗？每个产品都有自己的旅程。了解人们是否喜欢的方法是仔细审视。通常你会和用户交流，但也会加入分析工具。你可能会看 J 曲线（J-curve），即留存率：第 7 天、第 30 天、第 90 天还有多少比例的人在使用？曲线是走平了，还是人们一直在流失？如果随着时间推移它无法让人们兴奋，留存就会归零。如果过不了这一关，你就完蛋了。好，如果有人在用，太棒了，我们需要更多人，它需要好到让人们口口相传，然后增长。这是另一道关卡。
(00:28:44):
然后还有一关：这东西到底能做多大？是个小众产品，还是中等规模？大多数公司都有做大的抱负，但你不能从“大”开始。每个人都必须经历那个过程。没有产品是一开始就巨大的。即使是那些增长极快的产品，在内部也是从小规模开始的，可能只有 10 到 100 人在用。所以你必须关注指标，才能知道自己是否做对了。
(00:29:09):
另一方面，如果你在运营一个庞然大物，指标就是你的指南针。如果你的核心指标这周下降了 5%，你会问：“发生了什么？”然后你要进行根因分析（root cause analysis）：是某个地区的问题？某个设备的问题？某个用户群体？还是某个使用场景？问题出在哪？
(00:29:33):
当你找到问题，那种“改进”的本能又回来了：“好，我要修好它。治疗这个‘疾病’的药方是什么？”然后你又回到了增长轨道。所以你需要指标，你总是要看着你正在操作的系统和仪表盘。我像个飞行员，通过仪表知道飞机是否飞行正常，但仪表不会告诉你具体该怎么做，你必须自己思考如何让它变得更好。指标只是为你指路。

---

### (00:30:05) Lenny Rachitsky

**English:**
I love that you just gave a master class on just how to prioritize and pick what to work on. I want to go on a quick tangent. Speaking of products that have done really well and become really big, Stories, you build and launched Stories at Instagram. It's quite an infamous product launch back in the day, it was quite controversial because it basically took what Snapchat was doing really well and then, "Hey, let's bring it to Instagram," and it was not great for Snapchat. Now that it was so long ago and just, it's so far in the past, I'm so curious just to hear about that time reflecting on just that decision, what you guys talked about, how you decided to go ahead with that and anything just, I don't know, you think about looking back at that.

**中文翻译:**
我太喜欢你刚才关于如何确定优先级和选择工作内容的大师级讲解了。我想稍微跑个题。说到那些做得非常好且规模巨大的产品，Stories 绕不开。你在 Instagram 打造并推出了 Stories。当年那次发布相当“出名”，也很有争议，因为它基本上是把 Snapchat 做得很好的东西拿过来，说：“嘿，我们也把它带到 Instagram 吧。”这对 Snapchat 来说可不是什么好事。现在已经过去这么久了，我很想听听你对那个决定的反思：你们当时讨论了什么？你们是如何决定推进的？回过头看，你有什么想法？

---

### (00:30:47) Robby Stein

**English:**
I think there's a couple of really important lessons from that launch. And I mean we went on afterwards to launch Reels, a bunch of updates to direct messaging, we had feed rank game. There was just a huge era there when I was there between 2016 and 2021 or so where just so many new products got built. I think an interesting lesson in all of those, and particularly in Stories was you have to really understand why someone uses your product and know when something is actually an existential question because there's just a better format or a different way of doing something that has worked and works and you need to figure out what that might mean for you, because not every great thing is going to be invented by you. But I think that a lot of these things are, they can become formats that you can make your own and you need to learn from the world and what's happening out there in order for your product to always give the best thing to its users.
(00:31:41):
And so for Stories, we looked at Instagram like, what's the point of Instagram? It is sharing your life and connecting with people ultimately. And if there's a way to do that, that lowers the pressure because it doesn't have likes or it's just ephemeral format and it's optimized well for mobile because it's this full screen experience. It's a really great format and kudos to Snapchat for inventing it. We didn't think of that as a deterrent, that we had to go make Instagram photo clock. And actually, there were early versions of this idea where you try to take the core Instagram feed and make it ephemeral. And whenever you try to mix a core product that's very cemented in someone's mind and physically looks a specific way and you're trying to make, contort it to do something new, it's usually a bad recipe. And so we knew we needed to do something new and then it was so clearly was critical to the core essence of what the product could do, could fit in naturally.
(00:32:39):
But the question was how do we make it our own? And how do we build on this? And so if you think, there were a bunch of things that we did that made it Instagram. For example, it had different creative tools and it had things like neon drawing and these really sophisticated filters that people loved. We also looked at this talk about being dissatisfied. People took, a lot of times they want their main camera to take a picture of something and then they want to upload it to Instagram because they want to save it and they want it to be in a very high quality, high resolution photo, because it's a memory. And Snapchat at the time didn't allow you to upload photos, it was like you have to use the Snap camera. And so we made a bunch of decisions like that where why don't you just let people upload their photo? This is back to the dissatisfied point, that's frustrating.
(00:33:22):
Or there's another example where you couldn't pause if you were consuming a story. You couldn't pause it, it just would go through and be done because it was this ephemeral thing and you wanted to create safety. Why can't you just pause? It goes by too fast. So we added this pause, it's such a small thing, but you put your finger down to pause the story now. And so there were a whole set of those things that were shipped that made Stories feel Instagram. It wasn't like you just had some other thing. And then it turns out that worked incredibly well, and so much to the fact that someone on the team mentioned that they always felt like at the time, they didn't realize it, but it was almost like it was missing the story size holes at the top of the page and it completed the product in some weird way for them. And so that was, I think an important lesson.

**中文翻译:**
我认为那次发布有几个非常重要的教训。在那之后，我们还推出了 Reels，对私信（DM）进行了一系列更新，还有信息流排名算法。我在 2016 年到 2021 年左右在那里的那段时期，诞生了非常多的新产品。在所有这些产品中，特别是在 Stories 中，一个有趣的教训是：你必须真正理解用户为什么使用你的产品，并知道什么时候某个问题实际上是生死存亡的问题。因为如果出现了一个更好的格式或一种已经被证明有效的不同做法，你需要弄清楚这对你意味着什么，因为并非每一件伟大的事物都会由你发明。但我认为，很多东西可以成为你可以“据为己有”的格式（formats），你需要向世界学习，向正在发生的事情学习，以便让你的产品始终为用户提供最好的东西。
(00:31:41):
对于 Stories，我们审视了 Instagram：Instagram 的意义是什么？归根结底是分享生活和与人连接。如果有一种方式能降低分享压力（因为它没有点赞数，或者它是阅后即焚的格式），并且针对移动端进行了优化（全屏体验），那它就是一个非常棒的格式。向 Snapchat 发明了它致敬。我们并不认为“别人发明了它”是一个阻碍，非得把 Instagram 做成一个“照片时钟”不可。实际上，这个想法的早期版本是尝试把 Instagram 的核心信息流变成阅后即焚的。但每当你试图把一个在用户心中已经根深蒂固、外观特定的核心产品强行扭曲去做新事情时，通常都不是好主意。所以我们知道我们需要做一些全新的东西，而且它显然对产品的核心本质至关重要，可以自然地融入。
(00:32:39):
但问题是：我们如何让它具有 Instagram 的特色？我们如何在此基础上构建？如果你回想一下，我们做了很多事情让它感觉很“Instagram”。例如，它有不同的创意工具，像霓虹画笔和人们喜爱的精致滤镜。我们还考虑到了“不满足感”：很多时候人们想用主摄像头拍一张照片，然后上传到 Instagram，因为他们想保存它，想要一张高质量、高分辨率的照片作为回忆。而当时的 Snapchat 不允许你上传照片，你必须使用它的相机。于是我们做了一系列决定，比如：为什么不让人们直接上传照片呢？回到“不满足”的点，不能上传照片很令人沮丧。
(00:33:22):
还有一个例子：当时看 Story 时不能暂停。它会一直播完，因为它是阅后即焚的，想创造一种安全感。但为什么不能暂停呢？它播得太快了。于是我们增加了长按暂停的功能，这只是个小改动，但现在你按住手指就能暂停 Story。我们发布了一整套这样的功能，让 Stories 感觉很 Instagram，而不是生搬硬套。事实证明这非常奏效，团队里有人提到，他们当时甚至没意识到，页面顶部好像一直就缺了那么几个 Story 大小的圆圈，它的出现以某种奇妙的方式完整了整个产品。我认为这是一个重要的教训。

---

### (00:34:05) Lenny Rachitsky

**English:**
Instagram definitely got a lot of hate for that moment from a lot of founders. It was just like, "Hey, you guys just stole this idea and that sucks."
(00:34:13):
How did you guys just deal with that internally? It was just this is, "We got to do this. We got to focus on our shareholders and grow this thing," and that's how it goes sometimes?

**中文翻译:**
Instagram 当时确实遭到了很多创始人的痛恨。大家都在说：“嘿，你们就是偷了别人的创意，这太差劲了。”
(00:34:13):
你们内部是怎么处理这种压力的？是觉得“我们必须这么做，我们得对股东负责并实现增长”，还是觉得这就是商业竞争的常态？

---

### (00:34:19) Robby Stein

**English:**
I mean, I think it's more that we're focused on our users and the people who are loving Instagram and it's denying them the opportunity to have an easy way to just share a photo and have the thing go away. I mean, that's ultimately what we were trying to add. At the end of the day, that is a format that people adopt. In the same way that you think about feeds, I think we talked about this at the time too when we shipped it. Facebook probably created the modern feed, but there's a feed for every single product. There's a LinkedIn feed and there's a feed for DoorDash.
(00:34:53):
These things become core primitives quickly and formats, and then at the end of the day, you're just robbing your user base of the opportunity to have a better product if you're not making the best possible product for your use cases. And for Instagram, it's used differently. People use Instagram differently than they use other products. And it turns out that there were these experiences in WhatsApp and in Messenger and in many other social products over time, and they all were used differently actually, which is fascinating.

**中文翻译:**
我认为更多的是因为我们专注于我们的用户和热爱 Instagram 的人。如果不提供这个功能，就是在剥夺他们以简单方式分享照片并让其消失的机会。这才是我们最终想要增加的东西。归根结底，这是一种人们会采纳的“格式”。就像信息流（feeds）一样，我们发布时也讨论过：Facebook 可能创造了现代信息流，但现在每个产品都有信息流。LinkedIn 有，DoorDash 也有。
(00:34:53):
这些东西很快就会变成核心的“原语”（primitives）和格式。如果你不为你的使用场景打造最好的产品，你就是在剥夺用户拥有更好产品的机会。对于 Instagram 来说，它的用法是不同的。人们使用 Instagram 的方式与其他产品不同。事实证明，后来 WhatsApp、Messenger 和许多其他社交产品中也出现了类似的体验，但它们的用法其实各不相同，这非常迷人。

---

### (00:35:21) Lenny Rachitsky

**English:**
Something else I want to talk about is you came into two products that were already doing really well, Instagram and Google. And on the Instagram side, a transformative growth and improvement. Google is happening, we're in the middle of the improvement and growth you're driving. Not a lot of people get to do this where they go into an existing product, make it grow significantly. A lot of people want to do this. They have a product that's been around for a long time. Hey, how do we make this grow and be more successful? Is there anything specifically that you've learned about just coming into an existing product, figuring out where the big opportunities are and then just hockey-sticking growth? Because this is what everyone wants to do.

**中文翻译:**
我想聊聊另一件事：你加入的两个产品——Instagram 和谷歌——在当时都已经做得非常好了。在 Instagram，你实现了转型式的增长和改进；在谷歌，这种由你驱动的改进和增长正在发生。很少有人能做到这一点：进入一个现有的成熟产品，并让它显著增长。很多人都想这么做——他们有一个存在很久的产品，想知道如何让它焕发第二春。关于进入现有产品、找准大机会并实现“曲棍球棒式”增长，你有什么具体的经验吗？因为这是每个人都梦寐以求的。

---

### (00:35:57) Robby Stein

**English:**
There's a couple lessons here. And I think, by the way, the first lesson is to be humble always because it's extremely incredible to be able to work on products that have such impact on people. I view product like golf, you're always one stroke away from shanking. And as soon as you think you're good, you're not, you don't know anything. The world changes quickly. You have to always be a servant to your user base and the people that are out there and learn from them. The first thing I always do and think about is you get in touch in terms of why are people using this product, and where are the areas of growth? And so usually even in a big product or a mature in a complex system, there's a part of it that's growing. There's a part of it that's mature, there could be a part of it that's declining or isn't growing as much.
(00:36:42):
Certainly in Instagram, there's been a big shift over the years of sharing into public very large broadcast posts and feed into these more lightweight formats like Stories and DM actually private sharing as well. And so you have to observe that because every month, every year, the world changes, people's needs change. First thing you do is you get a sense of what do people want out of this product? What's its true essence? I think a lot about this job to be done framework, which is one of the things that I'm a big fan of and Clayton Christensen's book on Competing Against Luck is one of my favorite books on this topic where you have to really be a student of causation. Why is someone using this product? What are they doing with it and what are they trying to get done with it?
(00:37:26):
And that usually leads you to do bigger next stage ideas, and it removes this belief that you need to solve the problem with the current tools. In the Instagram version, it was like you have to make a square photo do more for people. That would be how you increment the product. Or in Google's example, there's something very specific with the core search experience that needs to change, it's a subtle tweak. You have to think, well, what's the big thing? Someone's trying to ask a really hard question out of Google? What's the best way to do that for them? And so it makes you think more first principled and that's the first basis of this.
(00:38:04):
And then once from first principles, you're like, "Oh, this newer thing." And it could be a shift, it could be a new form. In many ways, the AI version of Google and Stories and Reels, they're all similar in that they're new formats in the world that people are expecting and wanting more of.
(00:38:18):
And by adding them, it becomes complementary, not replacement. And in both cases, Stories didn't replace Instagram, it expanded in the same way we're seeing for AI. And so what's interesting is then you think, well, how do I bring that into my world? You have this big mature product. The best way I've seen is by making it complementary, having it be a core part of the experience, but clearly defined as a distinctive thing that has its own attributes associated with it because people think spatially. So if you have a feed and you have holes with pictures, they expect those holes to do things. And so if you make one of those holes with a little clock and that one goes away the next day or you can't like it or it operates differently than the other parts of your feed, it's going to be super confusing for people. It sucks.
(00:38:59):
And so you have to add product carefully, but it needs to feel coherent but different. Stories, it has similar aesthetic. It obviously uses your camera roll in the same way it works that you can share it in DM, it works in the system, but it has a different primitive in the same way Google AI, it's a full page experience that you can pop out now. You can have follow up conversation with it. People have a set of expectations you need to snap to for those use cases. And then you are constantly learning how to best make these new products work within your world.
(00:39:31):
You never just want to snap in something that's working, you have to make it work for your users, your expectations, and what people are trying to do with your product. It's actually one of the things I see people fail on the most is they assume something working for one system will work in your world, but someone else's system is on totally the types of users they have with the consumer expectation of that product, that's totally different set of expectations. You have to respect that and say, "What can we learn from that," and bring it here. I guess if you were to talk about the method that I've seen now or twice, I guess that's how these products have developed.

**中文翻译:**
这里有几个教训。顺便说一句，第一个教训是永远保持谦逊，因为能参与对人们产生如此大影响的产品是非常不可思议的。我把做产品看作打高尔夫球，你永远离“打偏”只有一杆之遥。一旦你觉得自己很厉害，你就完蛋了，你其实一无所知。世界变化很快。你必须永远做用户和大众的仆人，向他们学习。我做的第一件事总是去了解：人们为什么要用这个产品？增长点在哪里？通常即使在一个庞大成熟的复杂系统中，也总有一部分在增长，一部分在成熟，可能还有一部分在萎缩。
(00:36:42):
在 Instagram，这些年来发生了一个大转变：从分享公开的、广播式的帖子，转向了更轻量级的格式，如 Stories、私信（DM）以及私人分享。你必须观察到这一点，因为每个月、每年，世界都在变，人们的需求也在变。你首先要搞清楚：人们想从这个产品中得到什么？它的真正本质是什么？我经常思考“任务框架”（Job to be Done），我是这个理论的忠实粉丝。克莱顿·克里斯坦森的《跨越鸿运》（Competing Against Luck）是我最喜欢的书之一。你必须真正研究“因果关系”：为什么有人用这个产品？他们用它做什么？他们想达成什么目的？
(00:37:26):
这通常会引导你产生更大胆的下一阶段想法，并打破“必须用现有工具解决问题”的执念。在 Instagram 的例子中，如果你只想着“如何让正方形照片对人们更有用”，那只是在做产品增量。在谷歌的例子中，如果只盯着核心搜索体验做细微调整，那也只是小修小补。你得想：大招是什么？如果有人想问谷歌一个极难的问题，最好的方式是什么？这会让你更多地从第一性原理（first principles）出发思考。
(00:38:04):
一旦你从第一性原理出发，你会发现：“噢，这个新东西。”它可能是一个转变，也可能是一个新形态。在很多方面，谷歌的 AI 版本、Stories 和 Reels 都是相似的，它们都是世界上人们期待并想要更多的新格式。
(00:38:18):
通过添加它们，它们变成了互补品，而不是替代品。Stories 没有取代 Instagram，它扩张了它；AI 对搜索也是一样。有趣的是，你接着会想：我如何把它带入我的世界？你有一个巨大的成熟产品。我见过的最好方法是让它成为互补，让它成为体验的核心部分，但要明确定义为一个具有自身属性的独特事物。因为人们是空间化思考的。如果你有一个信息流，里面有放照片的格子，人们期望这些格子能做某些事。如果你把其中一个格子做成带小闹钟的，第二天就消失了，或者不能点赞，或者操作方式完全不同，人们会非常困惑。那太糟糕了。
(00:38:59):
所以你必须谨慎地添加产品，它需要感觉连贯但又有所不同。Stories 具有相似的美学，它同样使用你的相机胶卷，可以分享到私信，它在系统中运作，但它有一个不同的“原语”（primitive）。谷歌 AI 也是一样，它是一个可以弹出的全屏体验，你可以进行后续对话。你需要满足用户对这些特定场景的预期。然后你不断学习如何让这些新产品在你的世界里运作得最好。
(00:39:31):
你永远不要只是生搬硬套一个在别处行得通的东西，你必须让它适合你的用户、你的预期以及人们用你的产品想做的事。实际上，我看到人们失败最多的地方就是：他们假设在某个系统中行得通的东西在自己的世界里也行得通。但别人的系统有完全不同的用户类型和消费预期。你必须尊重这一点，问：“我们可以从中学习什么？”并把它带过来。这就是我见证过两次的产品开发方法。

---

### (00:40:09) Lenny Rachitsky

**English:**
I love this topic. It makes me think about just this balance. People always try to find between optimizing something they've already got versus trying to take a big bet on something. You've had so many examples where you've taken a big bet on something totally new and it's worked out incredibly well. Do you have just a heuristic in how you structure teams and prioritize across, okay, we have amazing Google experience today, what percentage of resources go into improving that versus trying something totally new?

**中文翻译:**
我太喜欢这个话题了。这让我想起人们总是在“优化现有产品”和“在全新事物上押大注”之间寻找平衡。你有很多在全新事物上押注并获得巨大成功的例子。在团队架构和优先级分配上，你有什么启发式的方法吗？比如，我们现在已经有了很棒的谷歌体验，百分之多少的资源应该投入到改进它，百分之多少去尝试全新的东西？

---

### (00:40:35) Robby Stein

**English:**
That's one where I actually do feel like the more analytical, systematic thinking helps a lot because you're trying to produce value in the world, you want to quantify it some way. And so if you're seeing this growth curve and you're trying to understand, wow, people are using it more and more to liken this product. And when products are young, they grow, and then eventually things mature. You can break out product suites and different features of products all along the same way. Certain features that are growing fast, other features that are not. You get to these points of just diminishing marginal return in every system where it feels like you could put 50 people on this project, it's just not going to dramatically move the needle. Part of it is this bottoms up thing with your own team being really thoughtful about what is the expected value of that investment, and knowing when it's starting to approach zero or diminishing marginal return.
(00:41:23):
And then when that happens, these are these moments that usually coincide with something fundamental changing. Either people's expectations, externally, market saturation, there's something happening where you need to adjust. You then find your next growth driver or set of drivers. That's where you need to go more first principled and try these new things more. Then when you land a new thing that creates this new little growth engine and then you put people on it and you optimize it because each change is like 10% win, 20% win, 4% win.
(00:41:57):
It's clearly still has so much value in headroom and to make it better for people, and you can see that in the data. And so that becoming, I talked about this instrumentation, it becomes your guide for knowing if you're making good calls. Otherwise, if you don't know where you're headed and you don't have a goal of what you're trying to do more quantitatively, it's really hard to know if the thing you're doing is mattering to anyone. I think I made the product better, but is anyone using it? Does anyone care? Or are we just congratulating ourselves? Ultimately you want to have impact on people and that's what matters.

**中文翻译:**
在这一点上，我确实觉得更具分析性、系统性的思维很有帮助，因为你是在创造价值，你希望以某种方式量化它。如果你看到增长曲线，你会发现当产品年轻时，它们会增长，最终会趋于成熟。你可以把产品套件和不同功能拆开来看。某些功能增长很快，另一些则不然。在每个系统中，你都会遇到边际收益递减（diminishing marginal return）的点，感觉即使在这个项目上投入 50 个人，也不会产生显著影响。这需要团队自下而上地思考：这项投资的预期价值是多少？并识别出它何时开始接近零或边际收益递减。
(00:41:23):
当这种情况发生时，通常意味着某些根本性的东西改变了。可能是外部用户的预期，或者是市场饱和，总之你需要调整。然后你会寻找下一个增长驱动力。这时你需要更多地回归第一性原理，更多地尝试新事物。一旦你落地了一个新东西，创造了一个新的增长引擎，你再投入人力去优化它，因为那时的每一次改动可能带来 10%、20% 甚至 4% 的提升。
(00:41:57):
显然，它仍然有巨大的价值和提升空间，你可以从数据中看到这一点。正如我说的“仪表盘”，它成了你判断决策是否正确的指南。否则，如果你不知道要去哪里，没有定量的目标，很难知道你所做的事情是否对任何人有意义。你可能觉得“我把产品做好了”，但有人用吗？有人在乎吗？还是我们只是在自我陶醉？最终，你希望对人产生影响，这才是最重要的。

---

### (00:42:29) Lenny Rachitsky

**English:**
So it says essentially tracking S-curves on every product and understanding if you're in the plateau and if it's time to invest heavily somewhere else.

**中文翻译:**
所以本质上是追踪每个产品的 S 曲线，了解你是否处于平台期，以及是否该重金投入到其他地方。

---

### (00:42:36) Robby Stein

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:42:37) Lenny Rachitsky

**English:**
(Ad segment for Orkes, an orchestration platform for modern enterprise apps and agentic workflows. Learn more at orkes.io/lenny.)
(00:43:39):
Maybe it would be helpful to talk about the journey of AI Mode, just how it emerged and the steps that you took to now it's just such a big part of the Google search experience. When did this start? How did you decide this is worth betting on? And then what are the steps to get it further and further rolled out?

**中文翻译:**
（广告环节：Orkes，Conductor 开源编排平台背后的公司。Orkes 提供了一个代理编排层，连接人类、AI 代理、API 和微服务。在 orkes.io/lenny 了解更多。）
(00:43:39):
也许聊聊 AI Mode 的历程会很有帮助，它是如何出现的，以及你采取了哪些步骤让它成为谷歌搜索体验中如此重要的一部分。它是从什么时候开始的？你是如何决定这值得押注的？进一步推广的步骤又是怎样的？

---

### (00:43:55) Robby Stein

**English:**
I mean, I think it probably started earlier on with AI Overviews actually, which was the first way we brought generative AI to search. In that world, we noticed that people were asking these questions and many people were actually trying to put natural language questions into search. And so how can you provide helpful context links to go deeper and make an AI that made sense for Google? That was our first version of these models that could do this for people. And then by building into that and seeing this observation around people wanting more of it, direct access to it, and then being able to ask follow-up questions. You need a new modality. It's going to be really hard to build all of that within the construct of the core search experience. And so that led us to have form a small team of folks, a few people that were technical leaders, a couple designers very small to just prove out what if there was on, almost blank screen, delete, make a little fresh doc with a blinker.
(00:44:53):
What if there's a new page and you can ask the question, you can ask whatever you want of it. You can tap right into the AI that was originally powering this top of the experience in search. But we invested in making it much more powerful in the ways I described before was in it could search for you. It had reasoning as a part of its model capability, it had multi turn context, so if you had a conversation with it could keep track of that context so it had some unique pieces to it. And what would happen if we tried that quickly. And we basically got, I mean, this was probably five to 10 people worth of people originally.

**中文翻译:**
我认为它实际上始于更早的 AI Overviews，那是我们将生成式 AI 引入搜索的第一步。在那个阶段，我们注意到人们在问这些问题，很多人尝试在搜索框里输入自然语言。那么，如何提供有用的背景链接、如何深入挖掘、如何做一个符合谷歌逻辑的 AI？那是我们第一版能为人们做这些事的模型。通过那个产品，我们观察到人们想要更多：想要直接访问，想要能问后续问题。你需要一种新的模态。在核心搜索体验的结构内很难构建所有这些。于是我们组建了一个小团队，几个技术负责人，几个设计师，非常精简，就是为了证明：如果有一个几乎空白的屏幕，像一个闪烁光标的新文档一样，会怎样？
(00:44:53):
如果有一个新页面，你可以问任何你想问的问题。你可以直接调用最初驱动搜索顶部体验的那个 AI。但我们投入资源让它变得更强大，就像我之前描述的：它可以为你搜索，它具有推理能力，它有多轮对话上下文（multi-turn context），如果你和它交谈，它可以跟踪上下文。它有一些独特的地方。如果我们快速尝试一下会发生什么？最初我们大概只有 5 到 10 个人。

---

### (00:45:29) Lenny Rachitsky

**English:**
And how long ago was this team formed?

**中文翻译:**
这个团队是多久以前组建的？

---

### (00:45:31) Robby Stein

**English:**
This was probably over the last year, last summer basically, into the fall.

**中文翻译:**
大概是去年，基本上是去年夏天到秋天之间。

---

### (00:45:34) Lenny Rachitsky

**English:**
Wow, so about a year ago.

**中文翻译:**
哇，所以大约是一年前。

---

### (00:45:37) Robby Stein

**English:**
Yeah, maybe about a year ago. It was where maybe it started. We were really plugging away on it, and then we saw this little version of it emerge that wasn't very good, but it had this moments of brilliance. It's actually, again, it's kind of like golf where you hit the perfect shot and you're like, "Oh my God." You get that feeling where it's just everything worked. And I asked it a question about, I forget, I was doing something with my daughter and I was planning an experience and it found all this incredibly useful information about park information. It had links to go to the site and confirm a bunch of things. It had Google Maps information that for my daughter, you could walk up, it was walkable. There was early examples like this where it just, it blew me away of what it could find and how helpful it was.
(00:46:27):
It gave us conviction that we should go and go further. And obviously there's lots of people involved in this type of a decision, tons of support from leaders across the organization. But it just says a little working team that initially, you got to build something and then you have to feel it yourself and it is very entrepreneurial in that way. And then when you see it tangibly, you're like, "What's a version of that? That's good and that could work?" And that gave you hope. And so then we basically built it out and built the first version that launched in Labs basically.

**中文翻译:**
是的，大约一年前开始的。我们一直在埋头苦干，然后看到一个不太成熟的版本出现了，但它有一些“天才时刻”。这又像打高尔夫球，当你打出一个完美的球时，你会想：“噢我的天。”你会有一种“一切都对了”的感觉。我问了它一个问题，我忘了具体是什么了，当时我正和女儿一起规划一次体验，它找到了关于公园的所有极其有用的信息。它有去网站确认细节的链接，有谷歌地图的信息，显示对我女儿来说那是可以步行到达的。像这样早期的例子让我大吃一惊，它能找到这么多东西，而且如此有帮助。
(00:46:27):
这让我们坚信应该走得更远。显然，这类决策涉及很多人，得到了组织内领导层的大力支持。但作为一个最初的小工作组，你必须先做出点东西，然后亲自感受它，这非常有创业精神。当你能切实看到它时，你会想：“什么样的版本才是好的、行得通的？”这给了你希望。于是我们把它开发了出来，并在 Labs（谷歌的实验性功能平台）发布了第一个版本。

---

### (00:47:01) Lenny Rachitsky

**English:**
So the first big milestone was this is working. It was just a qualitative experience of, "Oh wow, this has really, there's magic here."

**中文翻译:**
所以第一个重大里程碑是“这行得通”。那是一种定性的体验：“噢哇，这真的有魔力。”

---

### (00:47:09) Robby Stein

**English:**
Yes, it's working. And then we did bring it before labs actually to trusted tester group. There were maybe 500 people externally that we added onto it, and we had pings with them. Some of them were, we actually had friends and family. We tried to treat it a little more like a startup where, because we feel like you got to have people test it to tell you the truth, and tell you when it sucks, because it probably does.
(00:47:27):
And then they'd message you. So I had a friend who was loving it, but also hating it for lots of good reasons and would just be messaging me all the time, screenshots, "This broke, this broke, this makes no sense."
(00:47:37):
We had that for a while, and then we got to a point where it was feeling good, the trusted testers were liking it, reporting good stuff, and then we it to this Labs moment where anyone could turn it on and then we used that to make it better with real query data. We could actually see what people were using it for at more scale and so that could tune it to make it better. And then we launched it out to everyone, or at least in the US, and then we've now been on this journey to expand it to all countries and languages and have more people be able to access it.

**中文翻译:**
是的，它行得通。在进入 Labs 之前，我们实际上把它交给了一个“受信任测试者小组”（trusted tester group）。大约有 500 名外部人员，我们和他们保持沟通。其中一些是朋友和家人。我们试着像初创公司一样对待它，因为我们觉得必须有人测试并告诉你真相，告诉你它什么时候很烂——因为它可能确实很烂。
(00:47:27):
然后他们会给你发消息。我有个朋友既爱它又恨它，理由都很充分，他会一直给我发截图：“这儿坏了，那儿坏了，这根本不通。”
(00:47:37):
我们经历了一段这样的时期，直到我们觉得感觉不错了，受信任测试者们很喜欢，反馈也很好。然后我们进入了 Labs 阶段，任何人都可以开启它。我们利用真实的查询数据让它变得更好。我们可以更大规模地看到人们在用它做什么，从而进行调整。接着我们向所有人发布了它（至少在美国），现在我们正致力于将其扩展到所有国家和语言，让更多人能够使用。

---

### (00:48:05) Lenny Rachitsky

**English:**
It's incredible that Google went roughly in a year from idea to a significant change to the search experience that's AI powered. I think this is not what people imagine Google is like, and it feels like things are different and things have changed in how you guys operate. What has allowed this to happen so quickly? What's changed? Is it just top-down leadership, we need to get shit done, or is there something more?

**中文翻译:**
不可思议的是，谷歌在大约一年的时间里，就从一个想法变成了一个由 AI 驱动的搜索体验重大变革。我想这和人们想象中的谷歌不太一样。感觉你们的运作方式发生了变化。是什么让这一切发生得这么快？改变了什么？仅仅是自上而下的领导层要求“把事情搞定”，还是有更深层的原因？

---

### (00:48:30) Robby Stein

**English:**
No, I mean I think it's interesting how organizations change. I think when you feel like there is a moment in time that is clearly critical to deliver for people, people are trying to get information from Google. We are not able to answer certain things or help people in certain ways and there's this technology that can do it, that creates urgency, and obviously there's lots of people building lots of things and the market's crazy and there's lots of things shipping all the time.
(00:48:56):
There's a really exciting and healthy moment for us to build and build quickly and I think it's just exciting to be able to capture that opportunity because I think people believe, and I certainly believe that the next year or so of product is going to establish how people use the next wave of products for many years. And so at least I can only speak for myself, I feel this obligation to our users to give them the best version of Google that's powered by AI and that gives them the full knowledge of everything Google knows about the world and information to people and accessible with AI. That's driving a lot of the excitement.

**中文翻译:**
不，我觉得组织的改变很有趣。当你感觉到某个时刻对于交付产品至关重要时——人们正试图从谷歌获取信息，而我们无法回答某些问题或以某种方式帮助他们，而现在有了能做到这些的技术——这就会产生紧迫感。显然，现在有很多人在做各种东西，市场很疯狂，总有新东西发布。
(00:48:56):
对我们来说，这是一个非常令人兴奋且健康的时刻，可以快速构建。我认为能抓住这个机会非常令人振奋，因为人们相信（我也深信），未来一年左右的产品将决定人们在未来许多年里如何使用下一波产品。所以，至少对我个人而言，我感到对用户有一种责任，要给他们最好的、由 AI 驱动的谷歌版本，让他们能通过 AI 获取谷歌所知道的关于世界的所有知识和信息。这就是这种兴奋感的主要来源。

---

### (00:49:34) Lenny Rachitsky

**English:**
Yeah, it's such a good point that people are building their new habits. It's wild how many people just now rely on ChatGPT and how quickly that happened. And I could see Google being worried that, oh, shit, everyone's changing their habit from searching Google to searching ChatGPT. And the fact that now Gemini is number one. I was actually looking at the list of top, so in the top 15 apps, Google is I think five of them, a third. It's out of control, killing it. When people look at AI Mode versus ChatGPT or Claude or let's even say Perplexity, what's the way you think about the positioning of AI Mode versus these other tools? Is it trying to be a direct competitor or is it just like, "No, it's actually pretty different and here's what it's for?"

**中文翻译:**
是的，人们正在养成新习惯，这一点非常重要。现在有这么多人依赖 ChatGPT，而且发生得如此之快，这太疯狂了。我可以想象谷歌会担心：糟糕，大家都在把习惯从搜谷歌转向搜 ChatGPT。而现在 Gemini 成了第一名。我刚才看了下榜单，在前 15 名的应用里，谷歌占了 5 个，三分之一。简直是统治级的。当人们对比 AI Mode 和 ChatGPT、Claude 甚至 Perplexity 时，你是如何考虑 AI Mode 与这些工具的定位差异的？它是想成为直接竞争对手，还是说“不，它其实很不一样，它是用来做这个的”？

---

### (00:50:15) Robby Stein

**English:**
Yeah, I mean AI Mode's a way to ask search anything you want. It's designed and specially created for information. And so really, it should give incredible helpful responses for the things that people come to Google for. Think about you're planning a trip, you're trying to buy something, you're working through a question for your research project. It needs information and that's really, it's less focused on things like creativity, although there's things that can do that are nice there. It can help you. Just like any kind of core AI product, you can ask it to rewrite something for you, it'll do that. But we are less focused on creativity, productivity, upload a spreadsheet and output graphs for me, we're not focused on that.
(00:50:57):
We're really focused on what people use Google for, and making an AI for that so that you can come to Google, ask whatever you want and get effortless information about that and context and links to then also verify, dig in and go to the authoritative sources ultimately that people want, and we hear from people. So those ends up becoming the distinct qualities of this product versus more of a chatbot. Maybe you would talk to it like you maybe even have a bit of a, "Hey, how are you doing today," with that chatbot that we have some of that, we see that a little bit, but people are usually coming for information. They're trying to learn something and we focused our product on that.

**中文翻译:**
是的，AI Mode 是一种向搜索询问任何你想知道的事情的方式。它是专门为“信息”而设计的。所以，对于人们来谷歌寻找的东西，它应该提供非常有帮助的回答。想想看：你正在规划旅行，你想买东西，或者你在研究项目的一个问题。这些都需要信息。它不太专注于“创意”类任务，虽然它也能做一些。就像任何核心 AI 产品一样，你可以让它帮你重写一段话，它能做到。但我们不太关注创意、生产力（比如上传电子表格并生成图表），我们不关注那些。
(00:50:57):
我们真正关注的是人们使用谷歌的目的，并为此打造一个 AI。这样你来到谷歌，问任何你想问的，就能毫不费力地获得信息、背景和链接，进而去验证、深入挖掘并找到人们最终想要的权威来源。这就是这个产品与普通聊天机器人的区别。也许你会对聊天机器人说：“嘿，你今天怎么样？”，我们也能看到一点这种行为，但人们来这里通常是为了信息。他们想学习某些东西，我们的产品就专注于此。

---

### (00:51:30) Lenny Rachitsky

**English:**
Got it. Okay, AI Mode is not your therapist. Maybe zooming out again a little bit and reflecting on all the amazing products you've worked on, all the places you've worked, if you had to pick two or three just core product principles or philosophies that have helped you build such amazing and successful products, what would those be? What comes to mind?

**中文翻译:**
明白了。AI Mode 不是你的心理医生。让我们再次放大视角，回顾一下你参与过的所有惊人产品和工作经历。如果你必须挑选两三个核心的产品原则或理念，是它们帮你打造了这些成功的产品，那会是什么？你脑子里首先想到的是什么？

---

### (00:51:53) Robby Stein

**English:**
I mean, there's typically three things I think about. If I were to write a book about how to build great products, there'd be three chapters. I mean there'd probably more than that, but three chapters.

**中文翻译:**
我通常会想到三件事。如果我要写一本关于如何打造伟大产品的书，会有三个章节。当然可能不止三个，但核心是这三章。

---

### (00:52:08) Lenny Rachitsky

**English:**
I love that. I love how short that would be. That's the ideal book.

**中文翻译:**
我喜欢这个。这么短的书太理想了。

---

### (00:52:08) Robby Stein

**English:**
I've thought about these three areas now for a while and it's like they're always consistently the three things. The first is deeply understand people, and I think we talked about this a little bit with the jobs to be done point and Clayton Christensen's book, which I loved around Competing Against Luck. It really helps you be a student of why someone ends up, in his words, hiring a product. Don't think of users as using your product. Think of users as hiring you to do something for them.
(00:52:35):
There's this famous quote, I think it's Theodore Levitt had, "People don't want a quarter inch drill, they want a quarter inch hole." So what is someone trying to do? You have to understand that deeply and then you can build an amazing product. And also by the way, when you go back, why someone not using your product?
(00:52:57):
And so it focuses on these techniques to extract causation. So he actually talks a lot about this interview. He calls it an interrogation where you talk to a user like, "Hey, why do you use my product? Where were you? Were you in bed? Were you at work? What were you doing?"
(00:53:11):
"Oh, I was talking to my wife in the morning."
(00:53:13):
"Okay, well, what brought it up?"
(00:53:15):
"Well, I guess I was reading the newspaper."
(00:53:16):
"Okay, well why?"
(00:53:17):
And then you have this aha moment like that when they first decide to use your product, he calls it the big hire. That is information that you obtain ends up becoming the most critical because that is what caused someone to use your product. And if you can study that and understand it, you'll be much more on your way than just building things that sound cool. And so that's the first chapter is deeply understand people.
(00:53:37):
Second is really around analytical rigor and understanding your problems. You have to understand your problems. And this got is a little bit of what we were talking about about root cause analysis and understanding, okay, the metrics are dropping. Why? If someone's not using your product, why? And really being able to dissect that to get to true root causes. It's like, well, they went all the way to the end and then bailed, and then you understand what turns out that it was most, we actually learned about this and there's a story in Close Friends at Instagram where it just totally failed at first in a bunch just when we shipped it. And it turned out that we looked at the data and people were only adding one close friend to their list because it was mistranslated as best friend in many markets. So people just put one person and then the probability that person saw it and wrote back to you was zero. It's a product which is broken. So it's like you got to understand your problems.
(00:54:30):
And then the third one's around really designing for clarity instead of cleverness. A lot of people are like, "Oh, we're going to differentiate the design," and we talked about this a little bit with Stories. We're going to make a new version of something, but if something's a standard and people understand it, if you lean into it, you're going to get so much leverage than if you reinvent it, and you have to be really thoughtful around when you reinvent and where you don't.
(00:54:54):
And I think on this one, there's this great, Don Norman's book. Obviously, Design of Everyday Things is a big one, but he has this incredible chapter in there about doors, and why is it that after all of these years you walk up to a door, and based on how they're designed at times, people still don't know if you should pull or push that door because if you try to build the as beautiful symmetric two handles on each side on a glass door, it doesn't communicate in for any information to you.
(00:55:20):
And there's lots of, I've seen all the time we've designed new icons when we could have used global icons like, "Oh, wouldn't it be so cool if we used a camera that's kind of a camera but is mostly an AI looking thing and then is mostly, but then has this dots in it that connects it to this other product?"
(00:55:37):
And you're like, people just, it's a camera. Just put the camera in. Maybe you could add a little thing to it, and that's how you get people to use your products. And if you do those three things, I think you typically can do well.
(00:55:49):
And then, sorry, the fourth one would be more of the coda is be humble. Constantly and always question yourself. Listen to others, listen to users and be open to being wrong.

**中文翻译:**
我思考这三个领域已经有一段时间了，它们始终是这三件事。第一是“深度理解人”。我们刚才聊到“任务框架”（Jobs to be Done）和克莱顿·克里斯坦森的《跨越鸿运》。它能帮你研究为什么有人最终会——用他的话说——“雇佣”一个产品。不要把用户看作是在“使用”你的产品，要把用户看作是在“雇佣”你为他们做某事。
(00:52:35):
有一句名言，好像是西奥多·莱维特说的：“人们不想要一个四分之一英寸的钻头，他们想要一个四分之一英寸的洞。”所以，某人到底想做什么？你必须深刻理解这一点，然后才能打造出惊人的产品。顺便说一句，你还得反过来想：为什么有人“不”使用你的产品？
(00:52:57):
所以它专注于提取“因果关系”的技术。他谈到了这种访谈，他称之为“审讯”，你像这样和用户交谈：“嘿，你为什么要用我的产品？你当时在哪？在床上？在公司？你在做什么？”
(00:53:11):
“噢，我早上在和我妻子聊天。”
(00:53:13):
“好，是什么引起了这个话题？”
(00:53:15):
“嗯，我猜是因为我在看报纸。”
(00:53:16):
“好，为什么？”
(00:53:17):
然后你会有一个“恍然大悟”的时刻，当他们第一次决定使用你的产品时，他称之为“大雇佣”（the big hire）。你获得的这些信息最终变得至关重要，因为那是导致某人使用你产品的根本原因。如果你能研究并理解这一点，你会比只做一些听起来很酷的东西走得远得多。所以第一章是：深度理解人。
(00:53:37):
第二章是关于“分析的严谨性”和“理解你的问题”。你必须理解你的问题。这回到了我们刚才聊的根因分析：指标下降了，为什么？如果有人不用你的产品，为什么？要能够剖析并找到真正的根因。比如，他们走到了最后一步然后放弃了，你发现——我们实际上在 Instagram 的 Close Friends（亲密朋友）功能中遇到过这个，刚发布时完全失败了。结果我们看数据发现，人们只在列表里加了一个亲密朋友，因为在很多市场，这个词被误翻译成了“最好的朋友”（best friend）。所以人们只加了一个人，而那个人看到并回信的概率几乎为零。这个产品逻辑就断了。所以，你必须理解你的问题。
(00:54:30):
第三章是“为清晰而设计，而非为聪明而设计”（designing for clarity instead of cleverness）。很多人会想：“噢，我们要让设计与众不同。”我们聊 Stories 时提过，我们要做一个新版本，但如果某种形式已经是标准且人们已经理解了，顺应它会比重新发明它获得更多的杠杆效应。你必须非常仔细地考虑什么时候该重新发明，什么时候不该。
(00:54:54):
关于这一点，唐·诺曼的《设计心理学》（Design of Everyday Things）是一本名著。他在书里有一章专门讲“门”：为什么这么多年过去了，你走到一扇门前，有时还是不知道该推还是该拉？因为如果你为了美观，在玻璃门两边设计了两个完全对称的漂亮把手，它就没有向你传达任何操作信息。
(00:55:20):
我经常看到我们设计新图标，而明明可以使用全球通用的图标。有人会说：“噢，如果我们用一个看起来像相机、但又带点 AI 风格、还有点连接其他产品的圆点的图标，不是更酷吗？”
(00:55:37):
但用户只想看到相机。就放个相机图标。也许你可以加个小修饰。这就是你让人们使用产品的方法。如果你做到这三点，通常能做得很好。
(00:55:49):
最后，第四点算是一个尾声：保持谦逊。不断地、始终如一地质疑自己。倾听他人，倾听用户，并随时准备承认自己错了。

---

### (00:56:00) Lenny Rachitsky

**English:**
I love these. On that third point, I feel like AI Mode as the name is such a good example of clarity. What is this? This is AI Mode.

**中文翻译:**
我太喜欢这些原则了。关于第三点，我觉得 AI Mode 这个名字就是“清晰”的绝佳例子。这是什么？这就是 AI 模式。

---

### (00:56:07) Robby Stein

**English:**
We talked about it internally. If you look at it in the tab, it's like everyone know, it's like you see it and you'll know what it is or we could call it something random, but then what is that? And now you're working against yourself.

**中文翻译:**
我们在内部讨论过。如果你看浏览器标签页，每个人都能一眼看出它是什么。如果我们起个随机的名字，那它到底是什么？那样你就是在给自己增加阻碍。

---

### (00:56:20) Lenny Rachitsky

**English:**
If I were to reflect back these three pieces of basically this is the book you would write to help people build more successful products, it's understand the problem you're solving for people deeply. What's the job they're hiring you to do? I love the, it's lowercase jobs to be done. It's not like the rigorous whole thing that everyone-

**中文翻译:**
如果我来总结这三点——也就是你为帮助人们打造成功产品而写的书——那就是：深刻理解你为人们解决的问题。他们雇佣你去做什么任务？我喜欢你说的“小写的”任务框架（lowercase jobs to be done），而不是那种每个人都挂在嘴边的、极其严苛的一整套理论。

---

### (00:56:41) Robby Stein

**English:**
Exactly. Lowercase for sure.

**中文翻译:**
没错，绝对是“小写的”。

---

### (00:56:41) Lenny Rachitsky

**English:**
Okay. This is just like why are people hiring your product to solve a problem for them? What problem are they solving? So it's like basically figure out what problem they're having then very, through data, understand the problem and whether you are solving it. And then it's just keep it really simple. Clarity over cleverness essentially.

**中文翻译:**
好。这就像是：人们为什么要雇佣你的产品来解决问题？他们在解决什么问题？所以基本上是：找出他们遇到的问题，然后通过数据理解这个问题以及你是否解决了它。最后，保持简单。本质上是“清晰胜过聪明”。

---

### (00:57:02) Robby Stein

**English:**
Exactly, yes. And be humble.

**中文翻译:**
完全正确。还有，保持谦逊。

---

### (00:57:05) Lenny Rachitsky

**English:**
And be humble. Yes. Okay, important. Is there an example that we haven't talked about that shows this in action of just, cool, here's the problem we found. Here's how we figured out this is the solution and if we're succeeding, and then here's a very simple way of solving it?

**中文翻译:**
还有保持谦逊。是的。好，这很重要。有没有哪个我们还没聊到的例子，能体现这套原则的实际运作？比如：酷，这是我们发现的问题；这是我们如何确定解决方案以及是否成功的；这是解决它的一个非常简单的方法。

---

### (00:57:19) Robby Stein

**English:**
I mean honestly, this Close Friends example, I can give you more from Instagram days was really wild. It took two or three years to get Close Friends to work, and I think people, it totally failed originally. This is the product that lets you add a private list of people and then you can post to your story and then only those people see it. It's like this very exclusive private space so you can feel really comfortable sharing maybe more.

**中文翻译:**
坦白说，Instagram 时代的 Close Friends（亲密朋友）案例非常疯狂。我们花了两三年的时间才让它奏效，我想大家可能不知道，它最初完全失败了。这个产品让你添加一个私人列表，然后你可以发布 Story 且只有这些人能看到。它就像一个非常专属的私人空间，让你能更自在地分享更多内容。

---

### (00:57:39) Lenny Rachitsky

**English:**
Oh, green circle.

**中文翻译:**
噢，绿色圆圈。

---

### (00:57:40) Robby Stein

**English:**
Green circles, yes. It's one of the most popular, at least when I was there, was one of the most popular features of Stories and did really well, but it totally failed. And I think what we found out was that you actually used a bunch of these techniques here. So one was we first thought about it as an overall system problem and you could add a Close Friends post for anything. So you could do a feed post or a Stories post, and you also had a close friend's profile. You could see, if Lenny went to Robby's page, we were Close Friends, you would just be like, "Oh, you get to see extra stuff from me on my profile too."
(00:58:18):
So we shipped it, we thought it would be great. This is the be humble part, wasn't great, had a bunch of, it was just super confusing. You would see this really beautiful photo and then in the feed right after it, this blurry, very vulnerable moment someone's trying to share with their friends, just felt so out of place and weird for the reason people use feed. And then it was just confusing because it had an extra little green thing on it, but it was like that got a green thing and the Stories one didn't. If you open the story, it had a green thing inside the story, and people were just so confused.
(00:58:49):
And it had this other issue with the list where you're like, "Okay, the list doesn't work because it's mistranslated and people don't get it." I think it was actually called originally favorites, I want to say, and that encouraged people to just do two people on it. But then the way that it worked was, so this gets to the framework, I guess. So deeply understand people. What are people trying to do with this?
(00:59:10):
What they're trying to do is share a vulnerable thing and be like, "Hey, I'm lonely. Hey, what's going on? Are people up?" And it feels very much like a friend group thing.
(00:59:18):
And if you only have two people on it, the job that we're doing is actually connecting you to your friends. And if you don't get a DM back, it's broken. And so really what we're doing is getting you a DM and we're getting you connection. We're getting you a sense of being connected to your Close Friends. That is the job.
(00:59:33):
It's actually everything Clayton Christensen talked about in the book is there are utility jobs and there are emotional jobs. People usually discount the emotional ones a lot. This was really an emotional thing as much as it was utility one, and so product's broken, right? And people don't even know that it's a close friend story, they just see the little head because you have to click on it to see the thing. And so it just, people stopped using it.
(00:59:56):
We went through and we did these revs where we would simplify it and we would update it and we would go through this change list. Okay, take this out, take this out, change the name, here. And then we saw it was that it was working really well for people who added 20 to 30 people to their list. Because what would happen is you put 30 people on your list and then two of them would write back to you on DM and now you have closed the loop and you feel connected to those people. It's a winning thing. And so we designed the whole system around that, and also only worked in Stories. We were looking at the data, we were trying to understand where it was working and where it was failing, and then we updated the name to Close Friends so it didn't feel like favorites. So it wasn't three people, it's 20.
(01:00:34):
In the list, we built this list builder where we recommended a set of people based on some cool algo that was created by an engineer. And then we updated the design to put the green ring on the outside of the story so that this was the design for clarity. We were being cute. We thought, I think at the time it was like, "Oh, it's a secret story or something, and if you open it, you see it."
(01:00:56):
It just was not clear to people. And so we put the green ring on the outside so that users would see it in the tray and be like, "Ooh, what's that little green guy?"
(01:01:04):
And then they'd click on it and be like, "Oh, this is a private story for me." That system worked and did incredibly well, and that was the process we followed from a total flop to something that was very successful.

**中文翻译:**
绿色圆圈，是的。它是我在 Instagram 时 Stories 最受欢迎的功能之一，表现非常好，但它最初彻底失败了。我想我们当时实际上运用了刚才提到的那些技术。首先，我们最初把它看作一个整体系统问题，你可以为任何内容添加“亲密朋友”发布。所以你可以发信息流帖子，也可以发 Story，甚至还有一个“亲密朋友个人主页”。如果你去我的主页，如果我们是亲密朋友，你会看到我主页上额外的内容。
(00:58:18):
我们发布了它，觉得会很棒。这就是“保持谦逊”的部分——结果并不好，非常令人困惑。你会看到一张非常精美的照片，紧接着在信息流里看到一张模糊的、非常私密的照片，那是某人试图分享给朋友的瞬间。这在人们使用信息流的语境下显得格格不入。而且它很混乱，因为信息流帖子上有个绿色小标志，但 Story 上没有。如果你打开 Story，里面有个绿色标志。人们完全晕了。
(00:58:49):
列表也有问题。列表行不通是因为翻译错误，人们不理解。我记得最初它好像叫“收藏夹”（favorites），这鼓励人们只在里面加两个人。但它的运作逻辑是——这回到了框架，即“深度理解人”：人们想用它做什么？
(00:59:10):
他们想分享一些脆弱的、私密的东西，比如：“嘿，我好孤独。嘿，大家在干嘛？有人醒着吗？”这非常像是一个朋友圈子的行为。
(00:59:18):
如果你只加了两个人，我们实际上在做的“任务”是连接你和朋友。如果你没收到私信回复，这个逻辑就断了。所以我们真正的任务是让你收到私信，让你获得连接感。让你感到与亲密朋友紧密相连。这就是那个“任务”。
(00:59:33):
克莱顿·克里斯坦森在书里说过：有功能性任务，也有情感性任务。人们通常会大大低估情感性任务。这既是一个功能性问题，也是一个情感性问题。所以产品坏了，对吧？人们甚至不知道那是一个亲密朋友 Story，他们只看到一个小头像，必须点进去才能看到。于是，人们停止了使用。
(00:59:56):
我们进行了一轮又一轮的修改，简化它，更新它，过变更列表：去掉这个，去掉那个，改掉名字。然后我们发现，对于那些在列表里加了 20 到 30 个人的人来说，它运作得非常好。因为如果你加了 30 个人，其中两个可能会通过私信回你，这样你就完成了闭环，感到了连接。这是一个成功的模式。于是我们围绕这一点重新设计了整个系统，并且只让它在 Stories 中运作。我们观察数据，试图理解哪里行得通，哪里行不通。我们将名字改为“Close Friends”，这样它就不再感觉像只有三个人的“收藏夹”，而是 20 个人。
(01:00:34):
在列表方面，我们构建了一个列表生成器，根据工程师开发的一种酷炫算法推荐人选。然后我们更新了设计，把绿色圆环放在 Story 的外圈——这就是“为清晰而设计”。我们之前太想当然了，当时觉得：“噢，这是一个秘密 Story，你打开它才能看到。”
(01:00:56):
用户根本不明白。于是我们把绿色圆环放在外面，这样用户在 Story 栏里看到时会想：“噢，那个绿色的小家伙是什么？”
(01:01:04):
点进去后会发现：“噢，这是专门发给我的私人 Story。”这套系统奏效了，获得了巨大的成功。这就是我们从彻底失败到大获成功的全过程。

---

### (01:01:16) Lenny Rachitsky

**English:**
That is an awesome example. And this took two or three years, you said this process?

**中文翻译:**
这是一个极好的例子。你说这个过程花了多久？两三年？

---

### (01:01:19) Robby Stein

**English:**
Yeah, it took a while. That was actually one of the longest projects we worked on, but that actually came, the reason we did it was when we asked people to understand people like, "Why aren't you posting to your story? What's preventing you from doing it?"
(01:01:32):
And everyone had some version of, "Well, my ex is on it. I have a teacher on it. Oh, a friend that kind of is judgy is on it."
(01:01:39):
It was like this commonality was audience problem. Someone had an issue with people watching them. And so that gave us conviction to go this hard at it for so long because we knew that that was a core problem with the product.

**中文翻译:**
是的，花了不少时间。那实际上是我们做过的最长的项目之一。我们之所以坚持做下去，是因为当我们问用户：“你为什么不发 Story？是什么阻碍了你？”
(01:01:32):
每个人的回答大概都是：“嗯，我前任在上面。我老师在上面。噢，有个朋友特别爱评头论足。”
(01:01:39):
共同点就是“受众问题”。人们在意谁在看他们。这给了我们坚定的信念，让我们坚持了这么久，因为我们知道那是产品的核心问题。

---

### (01:01:51) Lenny Rachitsky

**English:**
Was this connected to the Finsta, Rinsta trend also?

**中文翻译:**
这和 Finsta、Rinsta（Instagram 小号）的趋势有关吗？

---

### (01:01:55) Robby Stein

**English:**
It was actually. I think that informed us. Everyone had a Finsta and there was a Binsta.

**中文翻译:**
确实有关。我认为那启发了我们。每个人都有 Finsta，还有 Binsta。

---

### (01:01:58) Lenny Rachitsky

**English:**
Was is a Binsta?

**中文翻译:**
什么是 Binsta？

---

### (01:02:00) Robby Stein

**English:**
Best friend Insta.

**中文翻译:**
“好朋友”版 Instagram。

---

### (01:02:03) Lenny Rachitsky

**English:**
I see.

**中文翻译:**
明白了。

---

### (01:02:03) Robby Stein

**English:**
Different, it's this layering of people 20 Finstas down to your partner, Pinsta, and then it's basically like, I made that up. I don't know if it's true, but I'm sure it was out there somewhere. We were like, "Wow. People clearly are trying to hack Instagram basically to create these private smaller group settings, and so we should just make a product."

**中文翻译:**
不同的人群分层，从 20 个人的 Finsta 到只有你伴侣的 Pinsta——好吧，Pinsta 是我编的，我不确定是不是真的，但我肯定当时有类似的东西。我们当时想：“哇，人们显然在尝试‘黑掉’ Instagram 的玩法，来创造这些私密的小群体环境，所以我们应该直接做一个产品。”

---

### (01:02:23) Lenny Rachitsky

**English:**
How did you actually do this testing? Was it rolled out to some percentage? Was it rolled out in New Zealand or whatever?

**中文翻译:**
你们具体是怎么测试的？是按比例灰度发布吗？是在新西兰之类的国家测试的吗？

---

### (01:02:27) Robby Stein

**English:**
Yeah, we rolled it out in a few other countries, exactly.

**中文翻译:**
是的，我们确实在其他几个国家进行了测试。

---

### (01:02:29) Lenny Rachitsky

**English:**
Okay,

**中文翻译:**
好的。

---

### (01:02:29) Robby Stein

**English:**
Got it. We had a basket of countries that we tried it in and then we would do research. I think it was Australia was one of the first ones for that one.

**中文翻译:**
是的。我们选了一组国家进行尝试，然后做研究。我记得澳大利亚是这个功能的首批测试地之一。

---

### (01:02:37) Lenny Rachitsky

**English:**
I was going to ask if you can share the country. So Australia.

**中文翻译:**
我正想问你能不能分享是哪个国家。所以是澳大利亚。

---

### (01:02:40) Robby Stein

**English:**
I think that was one of the earlier ones, yeah, but every time you ship something there's a slightly different reason why.

**中文翻译:**
我想那是较早的一个，是的。但每次发布产品，选择测试地的原因都略有不同。

---

### (01:02:46) Lenny Rachitsky

**English:**
Oh, interesting. So it's not always Australia gets all the new stuff.

**中文翻译:**
噢，有趣。所以并不总是澳大利亚先得到所有新功能。

---

### (01:02:49) Robby Stein

**English:**
No, although it sometimes is. Australia and Canada get a lot of stuff just because easier for the teams to see feedback from them.

**中文翻译:**
不一定，虽然有时确实是。澳大利亚和加拿大经常能先用到，只是因为团队更容易看到他们的反馈。

---

### (01:02:57) Lenny Rachitsky

**English:**
Yeah, speak English.

**中文翻译:**
是的，因为说英语。

---

### (01:02:59) Robby Stein

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### (01:03:00) Lenny Rachitsky

**English:**
Awesome, okay, let me go in a different direction and talk about something that you have a hot take on. There's a lot of talk these days about lean teams, small teams, just creating limited resources, not hiring at all. You have an opposite perspective of you actually need a lot of resources to build really big breakthroughs. Talk about your experience there.

**中文翻译:**
太棒了。好，让我们换个方向，聊聊你的一些独特见解。现在很多人都在谈论“精益团队”、“小团队”，主张限制资源，甚至完全不招人。你却持相反观点：你认为要实现真正的重大突破，实际上需要大量资源。谈谈你在这方面的经验。

---

### (01:03:19) Robby Stein

**English:**
Yeah, I mean I think there's obviously, depends on what you're trying to build and there's been famously small teams building big impact products, but I think there's this cult of lean, scrappy, fast, throw away your product quickly, keep moving. And I think at some level it's true for internal conviction, but to build a product that works for a lot of people that is based on a technological breakthrough. A lot of times, I see teams just give up to early or under invest in the product, and obviously the space matters. And if you're building a single product that is a way to, I don't know, do something with a digital app that's fairly straightforward, that's going to be different than building a robotics company. So what you're building does change.
(01:04:02):
But even for software, I mean I think for really hard technical problems, think about the amount of time and effort it took for teams to build a foundational model, and how many years and hundreds and hundreds of people that were needed for that to happen. And you think about these large companies that have had huge impacts on people, and I think particularly for bigger companies internally, something I've seen is it's almost too scrappy because it never gets enough momentum. The product never gets good enough internally and then it just dies on the vine. Whereas if you put more people on it, you have to be careful not to put too many too soon. But I see the opposite more true where people hold on to small teams too long and then you, either takes forever to get to the thing you're looking for.
(01:04:46):
This Close Friends example I mentioned this actually was a small team. One of the reasons it took us forever was it kept the team so small and scrappy. That loop cycle was so short and by a startup age you'd be dead probably. So you can maybe do that in a bigger company, but as a startup, I don't know if you have that leisure. And so I think you need to actually think what is the group I need to build a version that's great. And from first principles, really think about it instead of just embracing blindly, okay, we're going to be the two of us until this thing has escaped velocity market fit, which it's not always true.

**中文翻译:**
是的，我的意思是，这显然取决于你想构建什么。历史上确实有小团队做出巨大影响力产品的例子。但我认为现在有一种对“精益、简陋、快速、快速迭代、不断前进”的盲目崇拜。在某种程度上，这对于建立内部信念是真的，但要构建一个基于技术突破且能服务大众的产品，我经常看到团队过早放弃或投入不足。当然，领域很重要。如果你只是做一个相对简单的数字应用，那和创办一家机器人公司是完全不同的。所以，你构建的东西决定了资源需求。
(01:04:02):
即使是软件，对于极其困难的技术问题，想想团队构建一个基础模型需要多少时间和精力，需要多少年、几百上千人的投入。想想那些对人类产生巨大影响的大公司。我看到的一种情况是，特别是在大公司内部，有时项目做得“太简陋”了，以至于永远无法获得足够的动力。产品在内部从未达到足够好的水平，然后就中途夭折了。如果你投入更多的人力（当然要小心不要过早投入过多），情况会不同。但我看到的更多情况是：人们坚持小团队太久了，导致要么永远达不到目标，要么耗时太长。
(01:04:46):
我提到的 Close Friends 例子其实就是一个小团队。我们花了这么长时间的原因之一就是团队一直太小、太“简陋”。反馈循环太短，如果是在初创公司，你可能早就倒闭了。在大公司你也许能这么耗着，但在初创公司，我不确定你是否有这种闲暇。所以，我认为你需要真正思考：我需要什么样的团队规模才能打造出一个伟大的版本？要从第一性原理出发去思考，而不是盲目信奉“我们要一直保持两个人，直到产品达到逃逸速度或市场契合点”——这并不总是对的。

---

### (01:05:19) Lenny Rachitsky

**English:**
This is definitely counter to the narrative we see on Twitter. Anything you can share about just the heuristic you use to decide here's how long to keep it small? I know there's not going to be this step 1, 2, 3, but just like what I'm hearing is start small to prove out the concept designer PM engineer maybe. When do you find that makes sense to go big?

**中文翻译:**
这绝对与我们在 Twitter 上看到的叙事相反。关于如何决定“保持小规模多久”，你有什么启发式的方法吗？我知道不会有第一步、第二步、第三步那么简单，但我听到的是：先从小规模开始证明概念（比如一个设计师、一个 PM、一个工程师）。你什么时候觉得该扩大规模了？

---

### (01:05:40) Robby Stein

**English:**
Yeah, I think that it's mostly when you've hit the conviction moment. I think there's two big milestones. There's internal conviction. For yourself, do you believe in it? And you believe in it because there's some external validation, your friends, you put 20 friends on it. And by the way, I found out very quickly building startups that if you put 20 friends on something, they're not going to do you that many favors. They're not going to use a product every single day because they're your friend 30 days in, 60 days in, 90 days in. They're not using your product unless you're doing something that's useful to them. And so you get all of this feedback and you're seeing people really enjoy it. You get to that moment.
(01:06:17):
And then I think that's not a product that would win externally because if you were to ship it, it's broken, doesn't work great. And then you need to, I think invest enough to make the best version of it or as good a version as you can to get it out the door and to ship it. And I think that that, it's like you want to build the right product eventually is the mentality and you can only really do that with the right group.

**中文翻译:**
是的，我认为主要是当你达到“信念时刻”时。有两个重要的里程碑。一个是内部信念：你自己相信它吗？你相信它是因为有了一些外部验证，比如你让 20 个朋友试用。顺便说一句，我在创业中很快发现，如果你让 20 个朋友试用，他们不会给你太多面子。30 天、60 天、90 天后，他们不会因为是你的朋友就每天用你的产品。除非你的产品对他们真的有用，否则他们不会用。所以当你得到反馈，看到人们真的喜欢它时，你就到了那个时刻。
(01:06:17):
然后，我认为那个版本在外部可能还赢不了，因为如果你直接发布，它可能还有很多 Bug，体验不够好。这时你需要投入足够的资源，做出最好的版本，或者尽可能好的版本，然后把它推向市场。这种心态是：你最终想要构建出正确的产品，而你只有拥有正确的团队才能做到这一点。

---

### (01:06:39) Lenny Rachitsky

**English:**
I'm going to take us to a recurring segment on the podcast that I call AI Corner.

**中文翻译:**
现在进入播客的一个固定环节，我称之为“AI 角落”。

---

### (01:06:43) Robby Stein

**English:**
Okay.

**中文翻译:**
好的。

---

### (01:06:44) Lenny Rachitsky

**English:**
What's some way that you've found use for AI in your work, in your life that is really interesting, really helpful, maybe other people can be inspired by?

**中文翻译:**
在你的工作或生活中，你发现了哪些使用 AI 的方式是特别有趣、特别有帮助的，也许能给别人带来启发？

---

### (01:06:53) Robby Stein

**English:**
I think one of the coolest trends ever is how AI is affecting multimodal visual and inspirational needs for people. And we're early in this and I think this is something that I'm actually working on as a project as well, but right now if you think about what AI has done in large part, it was born and grew up in this text modality, it was chat. And so for a long time, if you were to ask it to help you, what's a cool way to redecorate your bookshelf behind you? It's going to describe that to you in text, because that's what it knows. But increasingly, AI is going to be liberated to help in every possible modality.
(01:07:29):
This is something that we've seen a lot with this explosive use of Google Lens and our image search and image features and with this deep understanding, and what I'm actually starting to use internally and some things that we're excited about more coming up that we actually announced at I/O that we're going to going to be building more of was how AI can help with inspiration, how AI can help with shopping and helping you really get things done that are more in the inspiring bucket of needs versus these core utilities like code, math, homework side of things.
(01:08:04):
And I'm really excited for things that are coming where you can ask it for inspirational tasks and it's starting to do really fascinating things in terms of what I'm seeing and hopefully we'll share more on that soon. But I think the one thing I can share is there's a visual version of AI Mode that basically we talked about at I/O, and so you can reference some of those keynotes, but that's in the process of being rolled out.

**中文翻译:**
我认为有史以来最酷的趋势之一是 AI 如何影响人们的多模态视觉和灵感需求。我们还处于早期阶段，这也是我目前正在负责的一个项目。如果你回想一下 AI 到目前为止所做的大部分工作，它诞生并成长于文本模态，也就是聊天。所以很长一段时间以来，如果你让它帮你重新装饰你身后的书架，它会用文字向你描述，因为那是它擅长的。但越来越多地，AI 将被解放出来，在每一种可能的模态中提供帮助。
(01:07:29):
我们在 Google Lens 的爆发式增长、图像搜索和图像功能中已经看到了这一点。我内部开始使用的一些东西，以及我们在 I/O 大会上宣布并将继续构建的东西，是关于 AI 如何帮助寻找灵感、如何帮助购物，以及如何帮你完成那些属于“灵感类”需求的事情，而不仅仅是代码、数学、作业这些核心工具类任务。
(01:08:04):
我非常期待即将到来的功能，你可以向它寻求灵感任务，从我目前看到的情况来看，它正在做一些非常迷人的事情，希望很快能分享更多。我能分享的一点是，AI Mode 会有一个视觉版本，我们在 I/O 大会上提到过，你可以参考那些主题演讲，它目前正在逐步推出。

---

### (01:08:34) Lenny Rachitsky

**English:**
Mysterious.

**中文翻译:**
保持神秘。

---

### (01:08:34) Robby Stein

**English:**
And so you're going to be able to now ask what's a mid-century modern beautiful office design with dark themes? It'll be able to produce this image board that's inspirational and you can do multi-turn with it. And so you'll be able to go and say, "Actually, I want more of a light theme, more creamy, more California, more coastal vibe." And it'll do that and it'll understand that and it'll actually see the images and be able to turn with you in the way that text works, which is going to be really cool. So I think that's going to be one of the more exciting things that will be new to AI soon.

**中文翻译:**
所以你现在可以问：“什么是带有深色主题的中世纪现代风格办公室设计？”它能生成一个充满灵感的图片板，而且你可以和它进行多轮对话。你可以接着说：“其实我想要更明亮的主题，更奶油色一点，更有加州海岸风情。”它能理解这一点，能真正“看到”图片，并像处理文本一样和你进行交互，这会非常酷。我认为这将是 AI 领域即将出现的更令人兴奋的新事物之一。

---

### (01:09:10) Lenny Rachitsky

**English:**
What I'm hearing is Nano Banana integrated into AI Mode. Recipe for success.

**中文翻译:**
我听到的是 Nano Banana 集成到了 AI Mode。成功的秘诀。

---

### (01:09:14) Robby Stein

**English:**
Well, it's a little different than Nano Banana because Nano Banana is an image editor. This is more like helping you find images on the web, so it's a little bit more like AI inspiration, AI image search, and allowing you to then talk with two effectively visual responses with natural language. So that's going to I think, be a little bit different than edit this photo so that it changes it. Although potentially an interesting idea too, to have an ability to take a picture of your living room. And I think AI will help with that too ultimately.

**中文翻译:**
嗯，这和 Nano Banana 有点不同，因为 Nano Banana 是一个图像编辑器。这更像是帮你寻找网络上的图片，所以更像是 AI 灵感、AI 图像搜索，并允许你用自然语言与视觉回复进行对话。所以我认为这与“编辑这张照片并改变它”有点不同。虽然拍一张你客厅的照片并让 AI 帮忙重新设计也是个有趣的想法，我想 AI 最终也会实现这一点的。

---

### (01:09:48) Lenny Rachitsky

**English:**
Pinterest is in trouble, feels like this is what people use Pinterest for. Here's all the inspiration. Now it's just AI doing it all. By the way, Nano Banana, where does this name come from?

**中文翻译:**
Pinterest 有麻烦了，感觉这就是人们使用 Pinterest 的目的——寻找灵感。现在 AI 把这些全做了。顺便问一下，Nano Banana 这个名字是怎么来的？

---

### (01:09:58) Robby Stein

**English:**
I don't actually, I forget that. There's a story somewhere. I forget it now honestly. But the team I think came from a scrappy, fun group of people building this and they wanted to go for something fun for folks to-

**中文翻译:**
我其实忘了。肯定有个故事，但我现在真的想不起来了。但我认为这个团队是由一群充满活力、有趣的人组成的，他们想做一些有趣的东西让大家……

---

### (01:10:13) Lenny Rachitsky

**English:**
Yeah, it feels like that's a part of the reason things have started to work. There's just more fun and delight and random crazy stuff coming out.

**中文翻译:**
是的，感觉这也是事情开始起作用的原因之一。现在有更多有趣、令人愉悦且随机疯狂的东西冒出来。

---

### (01:10:20) Robby Stein

**English:**
It does. It feels a little more like when I was at Google the first time through right now where you just have so much stuff and this kind of fun curiosity happening where people want to try things and ship things and yeah, hopefully that continues.

**中文翻译:**
确实。现在的感觉有点像我第一次在谷歌工作的时候，有这么多东西，有一种有趣的、充满好奇心的氛围，人们想尝试新事物、发布新东西。希望这种氛围能持续下去。

---

### (01:10:31) Lenny Rachitsky

**English:**
Yeah, it feels like Veo 3 would be even more successful if it had a wacky name. And I like that this is the opposite of your advice of clarity. I don't know what Nano Banana is, but it worked.

**中文翻译:**
是的，感觉如果 Veo 3 有个古怪的名字，可能会更成功。我喜欢这一点，因为它恰恰违背了你关于“清晰”的建议。我不知道 Nano Banana 是什么，但它奏效了。

---

### (01:10:42) Robby Stein

**English:**
Yeah, it's the other thing. No advice is right universally, right? But yeah, Nano Banana.

**中文翻译:**
是的，这就是另一回事了。没有哪条建议是放之四海而皆准的，对吧？但是，Nano Banana 确实很有趣。

---

### (01:10:49) Lenny Rachitsky

**English:**
Robby, is there anything else that you wanted to share? Anything else you want to leave listeners with as a final nugget of wisdom before we get to a very exciting lightning round?

**中文翻译:**
Robby，还有什么想分享的吗？在进入令人兴奋的闪电轮环节之前，还有什么最后的智慧结晶想留给听众吗？

---

### (01:10:58) Robby Stein

**English:**
This concept: be curious. I think of embodying everything as like it's really about curiosity. It's about wanting to know why everything is the way it is. Why is someone doing something? Why does someone have a different opinion than I do? Why might this not be working? And the people who really have that level of intense curiosity and they chase things down until they know, I think you're well served by that. That would be my only parting thought.

**中文翻译:**
这个理念：保持好奇心。我认为“身体力行”的核心其实就是好奇心。想要知道为什么一切是现在这个样子。为什么有人会做某事？为什么有人和我的观点不同？为什么这行不通？那些真正拥有强烈好奇心并追根究底直到弄明白的人，我认为会受益匪浅。这就是我最后的想法。

---

### (01:11:20) Lenny Rachitsky

**English:**
Let me follow that thread actually, because it's maybe the most trending term on the podcast over the past few months is curiosity. It comes up a lot when I ask people, what are you teaching your kids and embracing with the rise of AI and curiosity comes up all the time. Is there anything that helps you? Is it just like I am good at this and I am curious innately and I'm just, "This is valuable." Is there anything you can share that helps you or others around you embody that and actually be curious?

**中文翻译:**
我想顺着这个话题聊聊，因为“好奇心”可能是过去几个月播客中最热门的词。当我问人们“在 AI 兴起的时代，你教给孩子什么”时，好奇心总是被提及。有什么能帮助你保持好奇心吗？是你天生擅长这个，还是你觉得“这很有价值”？有什么可以分享的，能帮助你或周围的人真正做到并保持好奇心？

---

### (01:11:48) Robby Stein

**English:**
Well, I mean AI is obviously the ultimate curiosity engine, and that's what's so cool is you can now ask anything and just get information. And so I find that people just appreciate just how much they can learn about whatever they want. But also, I think that a lot of this also comes down to studying what you want to know about, and knowing where the branches of knowledge live there. A lot of times I'll read old papers and PDFs that are free online on a statistics thing if I want to learn about that and I think people under appreciate those. There's analog old school great learning and AI can help you discover them. I'm using AI, I'm particularly at Google to help discover all these cool links and things to read, but I find that that is an interesting hybrid where it's not just AI but really going to original sources more. I find that these books I mentioned on the chat here, I find that you need a blend of all of those things to ultimately really get to the bottom of things ultimately.

**中文翻译:**
嗯，AI 显然是终极的好奇心引擎，最酷的地方在于你现在可以问任何问题并获得信息。我发现人们非常感激能学到这么多他们想了解的东西。但同时，我认为很大程度上也取决于去研究你想知道的东西，并了解知识的分支在哪里。很多时候，如果我想学习统计学，我会去读网上免费的旧论文和 PDF，我觉得人们低估了这些。有一些传统的、老派的伟大知识，AI 可以帮你发现它们。我正在使用 AI（特别是在谷歌内部）来帮助发现所有这些酷炫的链接和读物，但我发现这是一种有趣的混合：不仅仅是 AI，还要更多地去寻找原始资料。我刚才提到的那些书，我认为你需要将所有这些结合起来，才能最终真正触及事物的本质。

---

### (01:12:46) Lenny Rachitsky

**English:**
Actually reading the thing, not just reading the summary of the thing.

**中文翻译:**
真正去读那个东西，而不仅仅是读它的摘要。

---

### (01:12:48) Robby Stein

**English:**
Yes.

**中文翻译:**
是的。

---

### (01:12:49) Lenny Rachitsky

**English:**
Let me actually ask you this question I've been asking all these people that are at the cutting edge of AI. You have kids, is there anything you're thinking about and leaning into helping them learn, develop as AI emerges and becomes a big part of the world?

**中文翻译:**
我想问你一个我一直在问所有处于 AI 前沿的人的问题。你有孩子，随着 AI 的兴起并成为世界的重要组成部分，你有没有在思考或倾向于帮助他们学习、发展什么？

---

### (01:13:04) Robby Stein

**English:**
The biggest thing I'm doing, I have younger kids, so the biggest thing I'm doing is they're using live versions of AI that they just talk to now much more. And so funny enough, we actually just launched search live actually out of Labs this week. And so you can talk to search in a live AI setting, which is conversational voice. Voice on when you're driving, you can just talk all the knowledge I talked about where you can do with Google, you can talk to it in a normal conversation with your voice. And I found that to be incredibly accessible for kids.
(01:13:31):
And I hear all my kids come home, they're like, "Can I talk to Google about something?"
(01:13:34):
"What do you need? What do you need to say?"
(01:13:36):
And then they go to my app, they hit the live button and they just start talking to it. They want to know about animals, they want to know about certain, I don't know, history things. They learn about something in school, and it's so natural to learn in that way that I think that that's helping them become much more AI native than any other thing I'm doing.

**中文翻译:**
我正在做的最重要的一件事——我的孩子还小——就是让他们更多地使用实时版本的 AI 进行对话。有趣的是，我们这周刚刚在 Labs 发布了“Search Live”（搜索实时对话）。你可以在实时 AI 环境中与搜索对话，这是一种对话式语音。当你开车时，你可以用语音对话。我发现这对孩子来说非常容易上手。
(01:13:31):
我听到孩子们回家说：“我能和谷歌聊聊吗？”
(01:13:34):
“你需要什么？你想说什么？”
(01:13:36):
然后他们打开我的 App，点击 Live 按钮，就开始和它说话。他们想了解动物，想了解某些历史。他们在学校学到了什么，用这种方式学习非常自然。我认为这比我做的任何其他事情都更能帮助他们成为“AI 原生代”。

---

### (01:13:56) Lenny Rachitsky

**English:**
Life as a parent is going to be way too easy now whenever kids have questions, "Just go talk to the AI," but I don't think that's bad. So this is within the Google search app. There's a live, how do you access this?

**中文翻译:**
现在当父母也太容易了，每当孩子有问题就说：“去问 AI 吧。”但我认为这不坏。所以这是在谷歌搜索 App 里的功能，有一个 Live 按钮，怎么进入？

---

### (01:14:07) Robby Stein

**English:**
Yeah, that's exactly right. You go to Google app, so there's one of the apps in the App Store you mentioned. You open Google and there's a button now that's live on it, right on the home screen. And if you tap on, it's a live version of AI Mode that you can just talk to. It's a full screen experience, and we'll say start talking.

**中文翻译:**
没错。你打开谷歌 App（就是你提到的 App Store 榜单里的那个）。打开谷歌，主屏幕上现在有一个 Live 按钮。如果你点击它，它就是 AI Mode 的实时版本，你可以直接和它说话。这是一个全屏体验，它会提示你“开始说话”。

---

### (01:14:22) Lenny Rachitsky

**English:**
In the show notes, I'm going to link to this project that somebody built, Eric Antonow, which I love. It basically shows you how to put a little speaker into a little stuffed animal and you connect the speaker to, it could be Google Live or it could be ChatGPT, whatever you like, in voice mode. And you put it on your shoulder, you get a little magnet that attaches, and your kids could talk to this parrot, for example, and you could tell it, "Talk in a pirate voice," and so they're talking to his pirate.

**中文翻译:**
在节目介绍里，我会链接到一个叫 Eric Antonow 的人做的项目，我非常喜欢。它教你如何把一个小扬声器放进毛绒玩具里，然后把扬声器连接到 Google Live 或 ChatGPT 的语音模式。你把它放在肩膀上，用磁铁固定，你的孩子就可以和这个“鹦鹉”说话。你可以告诉它“用海盗的声音说话”，然后他们就在和海盗聊天了。

---

### (01:14:49) Robby Stein

**English:**
Oh, that's really funny. Okay, that's really cute.

**中文翻译:**
噢，那太有趣了。真的很可爱。

---

### (01:14:51) Lenny Rachitsky

**English:**
It takes 15 minutes. You could get an X-Acto knife and sew it and stuff and it's fun. I made one for my nephew and he was looking for treasure with this parrot.

**中文翻译:**
只需要 15 分钟。你可以用美工刀切开缝一下，很有趣。我给我侄子做了一个，他正带着这只鹦鹉寻宝呢。

---

### (01:14:59) Robby Stein

**English:**
That's really adorable, I'm definitely going to look into that.

**中文翻译:**
太萌了，我一定要研究一下。

---

### (01:15:02) Lenny Rachitsky

**English:**
Robby, with that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
Robby，现在进入我们非常精彩的闪电轮环节。我有五个问题问你。准备好了吗？

---

### (01:15:07) Robby Stein

**English:**
All right, I'm ready.

**中文翻译:**
好，准备好了。

---

### (01:15:08) Lenny Rachitsky

**English:**
What are two or three books that you find yourself recommending most to other people?

**中文翻译:**
你最常向别人推荐的两三本书是什么？

---

### (01:15:11) Robby Stein

**English:**
I mean, definitely the two I mentioned here. Clayton Christensen, Competing Against Luck. Don Norman, Design of Everyday Things. But I also really love this for fiction, Aurora, which is this book David Koepp wrote. It's about electromagnetic pulse in the sun that knocks out, it's fiction for just fun. And it was a really fun beach read and apparently it was going to be made into a Netflix show, it didn't work out. I don't know. It was sad to see that fall apart, but so it's a really fun book.

**中文翻译:**
肯定包括我刚才提到的那两本：克莱顿·克里斯坦森的《跨越鸿运》和唐·诺曼的《设计心理学》。小说方面，我非常喜欢 David Koepp 写的《极光》（Aurora）。讲的是太阳电磁脉冲导致全球断电的故事，纯属娱乐。这是一本非常有趣的沙滩读物，据说本来要拍成 Netflix 剧集，但没成。挺遗憾的，但书真的很棒。

---

### (01:15:39) Lenny Rachitsky

**English:**
There's a book along those lines that I love, they're making a movie of it right now called Hail Mary.

**中文翻译:**
有一本类似风格的书我也很喜欢，现在正在拍电影，叫《挽救计划》（Project Hail Mary）。

---

### (01:15:43) Robby Stein

**English:**
Oh, I'm in the middle of reading that right now.

**中文翻译:**
噢，我正读到一半呢。

---

### (01:15:45) Lenny Rachitsky

**English:**
Okay, awesome.

**中文翻译:**
太棒了。

---

### (01:15:46) Robby Stein

**English:**
Yes.

**中文翻译:**
是的。

---

### (01:15:46) Lenny Rachitsky

**English:**
Of the same mind.

**中文翻译:**
英雄所见略同。

---

### (01:15:48) Robby Stein

**English:**
Yes.

**中文翻译:**
没错。

---

### (01:15:48) Lenny Rachitsky

**English:**
Yeah, they're making a movie of it. How about that?

**中文翻译:**
是的，他们正在拍电影。

---

### (01:15:50) Robby Stein

**English:**
In the middle of reading it. It's getting wacky where I am right now, but I'm excited to see where it goes.

**中文翻译:**
正读着呢。我现在读到的地方已经开始变得古怪了，我很期待后续。

---

### (01:15:54) Lenny Rachitsky

**English:**
It gets wackier. The ending especially wacky.

**中文翻译:**
会更古怪的。结局尤其古怪。

---

### (01:15:55) Robby Stein

**English:**
Oh, really? Okay.

**中文翻译:**
噢，真的吗？好吧。

---

### (01:15:56) Lenny Rachitsky

**English:**
Just prepare yourself.

**中文翻译:**
做好心理准备。

---

### (01:15:57) Robby Stein

**English:**
Okay.

**中文翻译:**
好的。

---

### (01:15:59) Lenny Rachitsky

**English:**
What is a recent movie or TV show you've really enjoyed?

**中文翻译:**
最近有什么你非常喜欢的电影或电视剧？

---

### (01:16:02) Robby Stein

**English:**
I love The Bear. I think that's just absolutely awesome show. Dune, of course. And I thought the new Top Gun is a little old now, but I think the new Top Gun was so fun and awesome.

**中文翻译:**
我喜欢《大熊餐厅》（The Bear），那绝对是一部神剧。当然还有《沙丘》。虽然《壮志凌云 2》现在有点旧了，但我认为它非常有趣且精彩。

---

### (01:16:13) Lenny Rachitsky

**English:**
Is there a product you've recently discovered that you really love? It cannot be AI Mode.

**中文翻译:**
最近有没有发现什么你非常喜欢的产品？不能是 AI Mode。

---

### (01:16:17) Robby Stein

**English:**
I'm going to use a non-digital product.

**中文翻译:**
我要说一个非数字产品。

---

### (01:16:19) Lenny Rachitsky

**English:**
Perfect.

**中文翻译:**
完美。

---

### (01:16:20) Robby Stein

**English:**
I'm super into this new pillow that I got called Purple Pillow, and I've been recommending it to everyone at work. We're on a pillow chat now. It's a thing. It's like you talk about what pillows we're getting, but it's this really cool thing where it's got this new technology of this honeycomb polymer that's inside and so it supports you and it has these little micro holes so it doesn't get hot. It's really cool. Big fan. Strongly recommend Purple Pillow.

**中文翻译:**
我最近迷上了一个叫 Purple Pillow 的新枕头，我一直在向公司的每个人推荐。我们现在甚至有一个枕头聊天群。这成了一件事。大家都在讨论买了什么枕头。它非常酷，内部采用了蜂窝聚合物新技术，能很好地支撑你，而且有微孔，不会发热。真的很棒。强烈推荐 Purple Pillow。

---

### (01:16:50) Lenny Rachitsky

**English:**
I've never heard of this thing, I am excited. I recently got an avocado pillow, focusing on low toxins.

**中文翻译:**
我从没听说过这东西，我很感兴趣。我最近买了一个 Avocado 枕头，主打低毒素。

---

### (01:16:57) Robby Stein

**English:**
Oh, those are good. I've heard good things about those too, yeah.

**中文翻译:**
噢，那些也不错。我也听过好评。

---

### (01:17:00) Lenny Rachitsky

**English:**
Okay, I got to join this pillow. Pillow talk is a great name for it by the way.

**中文翻译:**
好，我也得加入这个枕头话题。顺便说一下，“枕边谈话”（Pillow talk）这个名字起得真好。

---

### (01:17:04) Robby Stein

**English:**
You're into pillows too. That's great.

**中文翻译:**
你也对枕头感兴趣，太好了。

---

### (01:17:05) Lenny Rachitsky

**English:**
Huge.

**中文翻译:**
非常感兴趣。

---

### (01:17:06) Robby Stein

**English:**
I love bedding.

**中文翻译:**
我喜欢床上用品。

---

### (01:17:06) Lenny Rachitsky

**English:**
No, I'm just joking.

**中文翻译:**
不，我只是开玩笑。

---

### (01:17:07) Robby Stein

**English:**
Yeah, great.

**中文翻译:**
哈哈，好。

---

### (01:17:08) Lenny Rachitsky

**English:**
But I did upgrade my pillow. This is not Mr. Pillow, whatever that guy is, right? Is that guy that, there's like a controversial pillow guy. Okay.

**中文翻译:**
但我确实升级了枕头。这不是那个“枕头先生”（Mr. Pillow）做的吧？就是那个很有争议的家伙。

---

### (01:17:17) Robby Stein

**English:**
No.

**中文翻译:**
不是。

---

### (01:17:17) Lenny Rachitsky

**English:**
Okay. Purple Pillow. I'm going to ask AI Mode.

**中文翻译:**
好。Purple Pillow。我要去问问 AI Mode。

---

### (01:17:20) Robby Stein

**English:**
Yeah, you should.

**中文翻译:**
是的，你应该问问。

---

### (01:17:20) Lenny Rachitsky

**English:**
This.

**中文翻译:**
问这个。

---

### (01:17:20) Robby Stein

**English:**
Definitely.

**中文翻译:**
绝对要问。

---

### (01:17:22) Lenny Rachitsky

**English:**
Next question. Do you have a favorite life motto that you find yourself coming back to in life?

**中文翻译:**
下一个问题。你有没有最喜欢的人生格言，是你经常会想到的？

---

### (01:17:28) Robby Stein

**English:**
This is be curious. I think I almost named a company Curious. I just think it's a really awesome, there's one thing in life. It's that in terms of getting things done, in terms of understanding the world, people, your kids, your family. You always just want to know more and question things outside yourself, not feel like you have all the answers. I think that's really important.

**中文翻译:**
就是“保持好奇”。我差点把一家公司命名为“Curious”。我认为这是人生中非常重要的一点。无论是为了把事情做好，还是为了理解世界、他人、你的孩子和家人。你总是想知道更多，质疑身外之物，而不是觉得自己掌握了所有答案。我认为这非常重要。

---

### (01:17:49) Lenny Rachitsky

**English:**
I love that. Final question, okay, so speaking of startups, you started a company called Stamped back in the day, it got acquired by Yahoo. I hear there's a story where you got Justin Bieber on your app and that was a big deal and a big inflection in the success of the app. Can you just tell that story?

**中文翻译:**
我喜欢这个。最后一个问题。说到创业，你当年创办了一家叫 Stamped 的公司，后来被雅虎收购了。我听说有个故事，你让贾斯汀·比伯（Justin Bieber）入驻了你的 App，那是一件大事，也是 App 成功的重大转折点。能讲讲那个故事吗？

---

### (01:18:06) Robby Stein

**English:**
Yeah, it's a wild story. Just to scene set a little bit. I was 25 right after Google being an IC PM in New York with some Google friends building this company. So very early on, and maybe in a good way and no idea what I was doing. But basically we decided that the concept of Stamped was to put your stamp on your favorite things, get recommendations from friends and from people that you trust. And so you think of a Twitter feed, but it's all stuff that people think is cool.

**中文翻译:**
是的，那是一个疯狂的故事。先交代一下背景。当时我 25 岁，刚离开谷歌，在纽约和几个谷歌的朋友一起创办这家公司。那是很早期的时候，也许是初生牛犊不怕虎，我根本不知道自己在做什么。Stamped 的核心概念是：为你最喜欢的东西盖章（stamp），从朋友和信任的人那里获得推荐。你可以把它想象成一个 Twitter 信息流，但里面全是人们觉得酷的东西。

---

### (01:18:34) Lenny Rachitsky

**English:**
Which products.

**中文翻译:**
哪些产品？

---

### (01:18:35) Robby Stein

**English:**
It's like books, restaurants, food. Products, exactly.

**中文翻译:**
比如书、餐厅、食物。没错，还有产品。

---

### (01:18:37) Lenny Rachitsky

**English:**
Pillows, possibly.

**中文翻译:**
可能还有枕头。

---

### (01:18:37) Robby Stein

**English:**
Pillows could be on there. I would totally stamp this pillow and then you could discover it. And one of the cold star problems was obviously you want a group of people that are on it that are already using it, that could have some tastemaker type folks. We had a bunch of people that were chefs and we had people who were literary folks. And then we wanted to get a couple people that were more musicians, artists, and these influential folks.
(01:19:00):
My co-founder and I just basically got the contact of Scooter Braun, who's Justin's manager, and we just sent out an email and we were like, "Hey, we're in New York. We're going to be in LA tomorrow." I think we said something, I don't remember all the details, but it was something like tomorrow.

**中文翻译:**
枕头也可以在上面。我会给这个枕头盖章，然后你就能发现它。当时的一个冷启动问题是：你希望有一群已经在用它的人，最好是一些有品位的人（tastemakers）。我们找了一群厨师和文学界人士。然后我们想找几个音乐家、艺术家和有影响力的人。
(01:19:00):
我和我的联合创始人拿到了贾斯汀的经纪人 Scooter Braun 的联系方式，发了一封邮件说：“嘿，我们在纽约，明天要去洛杉矶。”我不记得所有细节了，但大概就是说“明天”。

---

### (01:19:15) Lenny Rachitsky

**English:**
And you were not going to be in LA tomorrow.

**中文翻译:**
而你们明天本来并不打算去洛杉矶。

---

### (01:19:16) Robby Stein

**English:**
No, no.

**中文翻译:**
是的，完全没有。

---

### (01:19:17) Lenny Rachitsky

**English:**
Okay.

**中文翻译:**
好。

---

### (01:19:17) Robby Stein

**English:**
"Do you happen to be there?"
(01:19:19):
And he just wrote back some one line thing like, "Meet me at this hotel for breakfast at something."
(01:19:25):
And we're like, "Oh, okay."
(01:19:28):
We literally went immediately to the airport. I just remember just basically going straight to the airport, flying to LA meeting with him. We gave him the whole pitch, we showed him the product, and then he was like, "Okay, I think this would be super cool. We can be involved and maybe you can help be an advisor."
(01:19:44):
And we ended up going back and meeting with Justin and showing him the product and even filming some little clips with him. It was actually really funny and it was a really fun moment. And obviously he was using it to stamp his favorite stuff. And so people would go, "Oh, Justin's into this song, or he is into this stuff," and would post that.
(01:20:02):
It was one of the ways that we got lots of people to try out and see what we were doing. That's a little extra scrappy moment in time, but I think it embodies a good lesson. Just do it now, be scrappy, be immediate. Intense urgency usually wins over thinking about it for a long time, and that's certainly proved to be true on that one.

**中文翻译:**
“你刚好在那儿吗？”
(01:19:19):
他回了一行字：“几点在某某酒店见我吃早餐。”
(01:19:25):
我们就想：“噢，好吧。”
(01:19:28):
我们真的立刻去了机场。我只记得直奔机场，飞到洛杉矶和他见面。我们做了完整的推介，展示了产品。他说：“好，我觉得这非常酷。我们可以参与进来，也许你可以做个顾问。”
(01:19:44):
最后我们回去见了贾斯汀，向他展示了产品，甚至还和他拍了一些小片段。那真的很有趣，是一个非常开心的时刻。显然，他开始用它来给他喜欢的东西盖章。于是人们会说：“噢，贾斯汀喜欢这首歌，或者他喜欢这个东西。”
(01:20:02):
这是我们让很多人尝试并了解我们在做什么的方法之一。那是一个非常“草根”的时刻，但我认为它体现了一个很好的教训：现在就做，要敢于拼搏，要迅速行动。强烈的紧迫感通常胜过长时间的思考，在那件事上确实证明了这一点。

---

### (01:20:20) Lenny Rachitsky

**English:**
Incredible story, thank you for sharing that. So many lessons to take away. Two final questions, where can folks find online if they want to reach out, maybe learn more about what you're doing and how can listeners be useful to you?

**中文翻译:**
不可思议的故事，谢谢分享。有很多值得学习的地方。最后两个问题：如果大家想联系你或者了解更多你在做的事情，可以在哪里找到你？听众可以如何帮到你？

---

### (01:20:31) Robby Stein

**English:**
Yeah, I think on X @rmstein is probably the best single place. And then to be helpful, send me feedback. DM me, just mention me, ping me, let me know problems with Google products, with AI in general, but also just anything. As I said before, you have to always listen to people understand their experiences, so ping the ideas and feedback. That's the best way to be helpful.

**中文翻译:**
是的，我想 X 上的 @rmstein 可能是最好的地方。至于如何帮到我，请给我反馈。私信我，艾特我，或者联系我，告诉我谷歌产品的问题，或者关于 AI 的任何想法。正如我之前说的，你必须始终倾听人们的声音，理解他们的体验。所以，把你的想法和反馈发给我，这就是最好的帮助。

---

### (01:20:52) Lenny Rachitsky

**English:**
Wow. What an onslaught you're about to receive of feedback on the search experience.

**中文翻译:**
哇。你即将收到排山倒海般的关于搜索体验的反馈。

---

### (01:20:56) Robby Stein

**English:**
No problem. Yes, please do.

**中文翻译:**
没问题。尽管发过来。

---

### (01:20:58) Lenny Rachitsky

**English:**
"Robby, why is this link second? Why is my site not at the top?" I can only imagine the kind of stuff people complain about. Robby, thank you so much for being here.

**中文翻译:**
“Robby，为什么这个链接排在第二？为什么我的网站不在第一？”我完全能想象人们会抱怨些什么。Robby，非常感谢你能来。

---

### (01:21:08) Robby Stein

**English:**
Thank you, it was great.

**中文翻译:**
谢谢，聊得很开心。

---

### (01:21:09) Lenny Rachitsky

**English:**
It was great. Bye, everyone.

**中文翻译:**
太棒了。大家再见。

---

### (01:21:11) Robby Stein

**English:**
Take care.

**中文翻译:**
保重。

---

### (01:21:13) Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating, or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcasts.com. See you in the next episode.

**中文翻译:**
非常感谢收听。如果你觉得有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcasts.com 找到所有往期节目或了解更多信息。下期节目见。