# Roger Martin - 双语对照

# Lenny's Podcast: Roger Martin on Strategy
## 播客访谈：Roger Martin 谈战略

---

### [00:00:00] Lenny Rachitsky

**English:**
Why are so many people bad at strategy?

**中文翻译:**
为什么有这么多的人都不擅长制定战略？

---

### [00:00:02] Roger Martin

**English:**
What's taught now in business schools generally sucks. People aren't prepared educationally, and they sure don't get prepared for it in companies. It's intellectually challenging and it's emotionally intimidating.

**中文翻译:**
现在商学院教的那套东西通常都很烂。人们在教育阶段没准备好，在公司里也肯定没得到相应的锻炼。战略在智力上极具挑战性，在情感上也让人望而生畏。

---

### [00:00:15] Lenny Rachitsky

**English:**
You have something you call the strategy choice cascade.

**中文翻译:**
你提出了一个被称为“战略选择级联”（strategy choice cascade）的理论。

---

### [00:00:18] Roger Martin

**English:**
You have to have answers to five questions. What's your winning aspiration? Where to play? How can you win? What capabilities do you have to have that your competitors don't? And then, what enabling management systems do you have to put in place? For the most part, in the leading business schools, it's illegal to teach that.

**中文翻译:**
你必须回答五个问题：你的获胜抱负是什么？在哪个领域竞争？如何获胜？你必须具备哪些竞争对手不具备的核心能力？最后，你必须建立什么样的支撑性管理系统？在大多数顶尖商学院里，教这些东西几乎是“非法”的。

---

### [00:00:35] Lenny Rachitsky

**English:**
Playing to win, you talked about, and there's kind of these two routes.

**中文翻译:**
你谈到了“为了获胜而战”（Playing to Win），而且通常有两条路径。

---

### [00:00:38] Roger Martin

**English:**
You have to be either differentiated or low cost, there's no way to protect yourself if you're not one of those two.

**中文翻译:**
你必须要么走差异化路线，要么走低成本路线。如果你不占其中之一，你就无法保护自己。

---

### [00:00:44] Lenny Rachitsky

**English:**
Is there anything else you wanted to just leave listeners with?

**中文翻译:**
最后还有什么想留给听众的建议吗？

---

### [00:00:46] Roger Martin

**English:**
I have never met this mythical beast called a great natural strategist. Great strategists have all one thing in common, they just practice.

**中文翻译:**
我从未见过所谓的“天生战略家”这种神兽。伟大的战略家都有一个共同点：他们只是不断地练习。

---

### [00:00:59] Lenny Rachitsky

**English:**
Today, my guest is Roger Martin. Roger is one of the world's most trusted strategy advisors. He's professor emeritus at the Rotman School of Management, at the University of Toronto, where he served as dean for five years. In 2013, he was named Global Dean of the Year, and in 2017 he was named the world's number one management thinker by Thinkers50. He's also the author of what many listeners consider their favorite book on strategy, called, Playing to Win. I've gotten a lot of requests to get Roger on this podcast, and I can now see why. This is the most tactical and fascinating conversation I've had on this podcast about developing a strategy, and that is a really high bar.

**中文翻译:**
今天的嘉宾是 Roger Martin。Roger 是全球最受信任的战略顾问之一。他是多伦多大学罗特曼管理学院的荣誉教授，曾担任该院院长五年。2013 年，他被评为全球年度院长；2017 年，他被 Thinkers50 评为全球排名第一的管理思想家。他还是许多听众心目中最喜爱的战略书《玩转战略》（Playing to Win）的作者。我收到了很多邀请 Roger 上节目的请求，现在我明白原因了。这是我在本播客中进行过的关于制定战略最具战术性、最迷人的对话，而这个评价标准其实已经很高了。

---

### [00:01:38] Lenny Rachitsky

**English:**
We delve into the five questions that you need to answer to help you craft your strategy. How Hamilton Helmer, Michael Porter, and Richard Rumelt's work fits into his framework and worldview, what people most often get wrong when they're developing their own strategy, the two options you have for how to win with your strategy, a very tactical and simple trick for getting started, thinking through your strategy, and so much more. This episode is for anyone who is trying to build their strategic thinking muscle. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app, or YouTube, it's the best way to avoid missing future episodes, and it helps the podcast tremendously. With that, I bring you Roger Martin. Roger, thank you so much for being here, and welcome to the podcast.

**中文翻译:**
我们深入探讨了制定战略需要回答的五个问题。Hamilton Helmer、Michael Porter 和 Richard Rumelt 的著作如何融入他的框架和世界观；人们在制定战略时最常犯的错误；获胜的两种选择；一个非常实用且简单的入门技巧，以及如何深入思考你的战略等等。这一集适合任何想要锻炼战略思维能力的人。如果你喜欢这个播客，别忘了在应用商店或 YouTube 上订阅和关注，这是避免错过未来节目的最好方式，也对我们很有帮助。现在，让我们欢迎 Roger Martin。Roger，非常感谢你能来，欢迎来到本播客。

---

### [00:02:24] Roger Martin

**English:**
It's great to be here, Lenny, thanks for having me.

**中文翻译:**
很高兴来到这里，Lenny，谢谢你的邀请。

---

### [00:02:27] Lenny Rachitsky

**English:**
What I want to try to do with our time together is to help people that are on the ground at a company, say, like the product manager, designer, engineer, data scientists, folks that aren't necessarily the CEO, or the founder or exec at company get better at product strategy. At crafting a strategy, evaluating strategy, developing a strategy. Because it feels like there's always tons of advice for the leaders of a company, but less for people on the ground doing the thing. And I feel like, luckily, your stuff applies to everyone. So, how does that sound as a lens for-

**中文翻译:**
在我们的交流中，我想尝试帮助那些在公司一线工作的人，比如产品经理、设计师、工程师、数据科学家，那些不一定是 CEO、创始人或高管的人，让他们更擅长产品战略。包括如何构思、评估和制定战略。因为感觉市面上总是有大量给领导者的建议，但给一线执行者的建议却很少。幸运的是，我觉得你的理论适用于每一个人。你觉得从这个视角切入怎么样？

---

### [00:02:55] Roger Martin

**English:**
That sounds great, and can I tell us a little story to that end?

**中文翻译:**
听起来很棒，为此我可以讲个小故事吗？

---

### [00:02:58] Lenny Rachitsky

**English:**
Please.

**中文翻译:**
请讲。

---

### [00:02:58] Roger Martin

**English:**
So, recently there was a newspaper article saying that, pointing out that 10% of the S&P 500 CEOs, 10% are ex Proctor and Gamble people. It's an amazing number, like a stunningly high, high number. Why would that possibly be? I believe it's because at Procter and Gamble there is a view that people way down the organization, like let's just say the head and shoulders brand franchise leader, who reports to the head of shampoos and conditioners, who reports to the head of beauty care, who reports to the CEO, so at least four levels down in the organization, in the guts of the organization, Proctor understands that that individual... makes super important strategic choices, and if they don't make them well, the brand does terribly.

**中文翻译:**
最近有一篇报纸文章指出，标普 500 指数公司的 CEO 中，有 10% 是宝洁（P&G）的前员工。这是一个惊人的数字，高得离谱。为什么会这样？我相信是因为在宝洁有一种观点：组织底层的人，比如海飞丝品牌的特许经营负责人，他向洗发水和护发素主管汇报，后者向美容护理主管汇报，再向上才是 CEO。所以即使是在组织内部深处、向下至少四个层级的人，宝洁也明白，正是这个个体在做极其重要的战略选择。如果他们选得不好，品牌就会表现得很糟糕。

---

### [00:04:13] Roger Martin

**English:**
And so, I believe... And not many companies have enough of that attitude. So, I'm a big believer that people down organization have to make really important strategic choices or bad things are going to happen, if they make really great ones, good things are going to happen, and they get trained to be a CEO someday. So, I'm with your thesis. But yours is counter, what I would say is normal. What is most normal is people at the top do strategy, and people down below do something, and it's usually called execution, and I hate that, I hate that term of art, for what it's worth. And so, I think you and I are singing from a bit of the same songbook, even if it's a minority songbook.

**中文翻译:**
所以我相信……而且没有多少公司有这种态度。我坚信组织底层的人必须做出非常重要的战略选择，否则坏事就会发生；如果他们做得好，好事就会发生，他们也会因此被培养成未来的 CEO。所以我同意你的论点。但你的观点与所谓的“常态”相反。最常见的情况是高层制定战略，底层负责做事，这通常被称为“执行”（execution）。我讨厌这个术语。所以，我觉得你和我志同道合，即使我们属于少数派。

---

### [00:04:57] Lenny Rachitsky

**English:**
[Sponsorship break for Webflow and WorkOS]

**中文翻译:**
[Webflow 和 WorkOS 的广告插播]

---

### [00:07:01] Lenny Rachitsky

**English:**
I just want to ask this broad question about strategy, why is strategy so hard? Why are so many people bad at strategy?

**中文翻译:**
我想问一个关于战略的宏观问题：为什么战略这么难？为什么这么多的人都不擅长战略？

---

### [00:07:09] Roger Martin

**English:**
Perhaps the thing that makes it intellectually hardest is that it is an integrative activity. It answers to a bunch of questions that have to fit together and reinforce one another. So, that just makes it a little more complicated, it's not like saying, Lenny, what do you want for lunch? It's saying, Lenny, what kind of diet do you want that'll keep you healthy? And that includes breakfast, lunch, dinners, snacks, a whole bunch of other things that you got to fit together. So, it makes that harder to do intellectually. Another aspect of it is, it is intimidating. Strategy involves making choices to do some things and not other things, and it is often intimidating to say, oh dear, I have to cut these things off, and not do them, and actually make a decision that I'll be held accountable for potentially, or I'll even hold myself accountable for.

**中文翻译:**
也许在智力上最难的一点在于它是一项“整合性”活动。它要回答一系列必须相互契合、相互强化的选择。这让它变得复杂，这不像问“Lenny，你午饭想吃什么？”，而是问“Lenny，你想要什么样的饮食习惯来保持健康？”，这包括早餐、午餐、晚餐、零食以及一堆你必须整合在一起的东西。这在智力上更难。另一个方面是，它让人感到畏惧。战略涉及做出选择——做某些事而不做另一些事。说出“天哪，我必须砍掉这些东西，不做这些事”往往是令人畏缩的，因为你必须做出一个可能要为此负责的决定，甚至是你自己对自己负责。

---

### [00:08:21] Roger Martin

**English:**
So, that's a second thing. It's harder emotionally, not harder intellectually. And then, there's the training aspect of it, the knowledge aspect of it, which is, what's taught now in strategy in business schools generally sucks. It's gone on a crazy theoretical bend, the strategy academy as a whole has fallen in love with a theory called the resource-based theory of the firm, that silly and nobody uses it out in the world. And so, students are no longer trained on useful strategy. And the other feeder into people learning strategy were the strategy consulting firms, but the strategy consulting firms, the so-called strategy consulting firms, do almost no strategy anymore because it's a little business compared to post-merger integration, digital transformation, and a bunch of other things. So, people aren't prepared educationally for it, and if they're not prepared educationally for it, then they sure don't get prepared for it in companies. It's intellectually challenging and it's emotionally intimidating.

**中文翻译:**
所以这是第二点：情感上的难度大于智力上的难度。然后是培训和知识层面的问题。现在商学院教的战略课程通常都很烂。它走向了疯狂的理论化倾向，整个战略学术界都迷恋上了一种叫做“资源基础观”（resource-based theory of the firm）的理论，这很愚蠢，现实世界中没人用它。因此，学生们不再接受实用战略的培训。另一个学习战略的渠道是战略咨询公司，但所谓的战略咨询公司现在几乎不再做战略业务了，因为与并购后整合、数字化转型等业务相比，战略业务太小了。所以，人们在教育上没准备好，在公司里也得不到锻炼。它既是智力挑战，也是情感考验。

---

### [00:09:40] Lenny Rachitsky

**English:**
On this point, you made about how schools are teaching strategy wrong, how do you describe what the wrong approach is?

**中文翻译:**
关于你提到的学校教错战略这一点，你如何描述那种错误的方法？

---

### [00:09:46] Roger Martin

**English:**
It's a theory that's sort of taken over, called the resource-based view of the firm... In the world of academics, there's a weird place where the number one emotion is jealousy, and people were massively jealous of Mike Porter, who created many of the most important concepts of strategy when he wrote a book, Competitive Strategy, in 1980. And so, they needed to counter him because they just didn't like the fact that he was so prominent, and they decided they would say he was about positioning. So, they called his the positioning school, and they caricatured what he said... they said he said it's all about finding a place that is structurally attractive, and then milking it for everything you can.

**中文翻译:**
这种主导理论叫“资源基础观”……在学术界，头号情绪往往是嫉妒。人们非常嫉妒迈克尔·波特（Michael Porter），他在 1980 年写《竞争战略》时创造了许多最重要的战略概念。因为不喜欢他如此出名，他们需要反驳他，于是他们断言波特只关注“定位”。他们称他的理论为“定位学派”，并歪曲了他的观点……他们说波特认为战略就是找到一个结构上有吸引力的位置，然后榨干它的一切价值。

---

### [00:10:43] Roger Martin

**English:**
We at the resource-based view of the firm think that strategy is all about building resources. And if you build resources, it's almost like if you build it, they will come. And that's what you should pay attention to. Now, the problem is, any resource that may be useful somewhere is not necessarily useful elsewhere. So, it begs the question, how would you think through what resources to invest in building? What would be a way of doing that, investing here, versus here, versus here? It's silent on that because it's a dumb theory, and it doesn't have anything useful to say, in my view, about that.

**中文翻译:**
“资源基础观”的人认为，战略完全在于构建资源。如果你构建了资源，就像是“筑巢引凤”，客户自然会来。这就是你应该关注的。问题在于，在某些地方有用的资源在其他地方未必有用。所以这引出了一个问题：你如何思考该投资构建哪些资源？是在这里投资，还是在那里投资？该理论对此保持沉默，因为它是个愚蠢的理论，在我看来，它在这方面没有任何有用的见解。

---

### [00:11:33] Roger Martin

**English:**
And so, when the students go out and say to their company, I'm going to do a VRIO analysis, or a VRIN, some people just roll their eyes at them, and so it doesn't get used. I've only seen it used, I've been in consulting companies for 42 years, and I've seen it used once. And the trust, as is usually the case, is that it's both. And that's why the model I use for strategies says a lot about where you play is important, that's one of the key questions, and your capabilities are important, and you've got to link those things together. But that's, for the most part in the leading business schools, it's illegal to teach that.

**中文翻译:**
所以，当学生们走出校门对公司说“我要做一个 VRIO 分析或 VRIN 分析”时，人们只会对他们翻白眼，所以这些东西根本没被使用。我在咨询行业干了 42 年，只见过它被用过一次。事实通常是两者兼而有之。这就是为什么我的战略模型强调“竞争领域”（where you play）很重要，这是关键问题之一，同时你的“核心能力”（capabilities）也很重要，你必须把它们联系起来。但在大多数顶尖商学院，教这些几乎是“非法”的。

---

### [00:12:20] Lenny Rachitsky

**English:**
Illegal to teach your approach.

**中文翻译:**
教你的方法是“非法”的？

---

### [00:12:23] Roger Martin

**English:**
Yes. I couldn't teach my approach at my own business school.

**中文翻译:**
是的。在我自己的商学院里我都不能教我的方法。

---

### [00:12:23] Lenny Rachitsky

**English:**
What?

**中文翻译:**
什么？

---

### [00:12:26] Roger Martin

**English:**
But when I was dean, the most powerful person, the departments, or areas as we call it, like strategic management is an area, they have 100% control over what's taught in strategic management, in finance, et cetera. The dean may be the most powerful person in the school, and I happened to be a super successful dean... and students would beg me, they'd say, "Roger, you have 20 years of experience, you're sort of a famous consultant in strategy, and you've got these theories, please teach a course in it." Nope. I did do extracurricular stuff... But for credit, I was not allowed. And if you try to get a job at any business... If you took the 49 other top business schools in America, and if asked the question, do you swear allegiance to the resource-based view of the firm? If you don't answer an enthusiastic yes, you have no chance of being hired, zero.

**中文翻译:**
当我担任院长时，虽然我是学校里最有权力的人，但各个系（我们称之为领域，比如战略管理领域）对教学内容拥有 100% 的控制权。学生们会求我：“Roger，你有 20 年经验，是著名的战略顾问，又有这些理论，请开门课吧。”不行。我只能做一些课外讲座。但如果是为了学分，我不被允许教这些。如果你想在任何商学院找工作……如果你去美国其他 49 所顶尖商学院面试，被问到“你是否效忠于资源基础观？”，如果你不热情地回答“是”，你被录用的机会是零。

---

### [00:13:50] Lenny Rachitsky

**English:**
Wow. This academia drama, I had no idea.

**中文翻译:**
哇，这种学术界的狗血剧，我以前完全不知道。

---

### [00:13:54] Roger Martin

**English:**
A loyalty test.

**中文翻译:**
这就是一场忠诚度测试。

---

### [00:13:55] Lenny Rachitsky

**English:**
This is unreal. Makes me even more excited to dive into your world, and your ways of seeing things. Before we do that, just we've had a few other strategy people on the podcast, it might be helpful to frame where they fit in the spectrum that you're describing. So-

**中文翻译:**
这太不可思议了。这让我更有兴趣深入了解你的世界和你的视角。在那之前，我们播客也请过其他几位战略专家，如果能把他们放在你描述的光谱中定位一下，可能会很有帮助。

---

### [00:14:09] Roger Martin

**English:**
Oh, okay. I may not know all of them, but you give me-

**中文翻译:**
噢，好。我可能不认识所有人，但你可以告诉我——

---

### [00:14:12] Lenny Rachitsky

**English:**
I imagine you do. So, we've had a Hamilton Helmer on the podcast, and then Richard Rumelt on the podcast. How do they relate, just for people to get into your stuff versus this dogma?

**中文翻译:**
我想你应该认识。我们请过 Hamilton Helmer，还有 Richard Rumelt。为了让大家区分你的理论和那些教条，他们和你是什么关系？

---

### [00:14:25] Roger Martin

**English:**
So, one of them is an academic, and one of them is a quasi-academic, or non-academic, like me. I was a tenured professor for many years, but don't consider myself an academic guy. I don't think Hamilton does... He's written a very, I think, useful book that would in some sense fit into my "how to win" box, right? I say strategy is about how to win, and he has a, what I call, a categorical model. Here are categories of things that you should think about. If you're trying to win, here are seven ways of winning, and I categorize him as a non-academic practical strategy guy.

**中文翻译:**
他们中一个是学术派，另一个是准学术派或非学术派，就像我一样。我当了很多年终身教授，但不认为自己是学术圈的人。我想 Hamilton 也不是……他写了一本非常实用的书（指《七大策略力量》），在某种意义上可以放入我模型中“如何获胜”的格子里。我说战略是关于如何获胜，而他有一个我称之为“类别模型”的东西：如果你想赢，这里有七种获胜方式。我把他归类为非学术的实战派战略专家。

---

### [00:15:54] Roger Martin

**English:**
Richard Rumelt is a now retired Tuck professor, and he is this hyper competition thing that he does. He also is of the "I'm jealous of Mike Porter" kind of thing. So, I've got to say, Mike Porter is wrong, and here's how I am so right... Mike Porter never in his entire life has said competition is stable, he's repeatedly said the opposite. But in order to say I'm not like Mike Porter... I don't know. He seemed like a fine guy. I don't think that he, like most business academics, he doesn't know much about business. He hasn't gone out and practiced a lot.

**中文翻译:**
Richard Rumelt 是塔克商学院的退休教授，他搞的是“过度竞争”那一套。他也属于那种“嫉妒迈克尔·波特”的人。所以他必须说波特是错的，而他是对的。波特这辈子从未说过竞争是稳定的，他反复强调相反的观点。但为了标榜自己和波特不同……我不确定。他看起来是个不错的人，但我认为他像大多数商学教授一样，并不太懂生意。他没有太多的实战经验。

---

### [00:16:42] Roger Martin

**English:**
He came to our school, and gave a lecture... and he gave a example of Proctor and Gamble, I've been consulting at Proctor and Gamble, and know everything about Procter and Gamble, basically. And what he said about Proctor and Gamble had zero to do with reality, like zero. It was just completely, utterly, absolutely wrong. And I asked him afterwards... "Why do you say that?" And he said, "Well, I think that's the way it worked." Are you kidding me? So, I'm not a fan of that piece of work.

**中文翻译:**
他来我们学校做过讲座……举了宝洁的例子。我一直在宝洁做咨询，基本上了解宝洁的一切。而他关于宝洁的说法与事实完全不符，一点边都不沾。那是彻头彻尾的错误。事后我问他：“你为什么那么说？”他说：“嗯，我觉得它就是那样运作的。”你在开玩笑吗？所以我不太欣赏他的那套东西。

---

### [00:17:32] Lenny Rachitsky

**English:**
This is fascinating. I love that we're spending some time on this, this is really helpful to hear the landscape of strategy minds. Okay, let's dive into your worldview, and maybe the simplest way is just, how do you define strategy? What is a strategy?

**中文翻译:**
这太有意思了。我很喜欢探讨这些，了解战略思想界的版图非常有帮助。好，让我们深入了解你的世界观，也许最简单的方式就是：你如何定义战略？什么是战略？

---

### [00:17:48] Roger Martin

**English:**
Strategy is an integrated set of choices that compels desired customer action. So, the way I think about it is, there's a whole bunch of things a company controls... Those are all the things under our control. What, Lenny, is the thing we have almost no control over? What, if we're a company?

**中文翻译:**
战略是一套能够“迫使”客户产生预期行为的整合选择。我的思考方式是：公司可以控制很多事情（工厂、研发、广告、雇人等）。但是 Lenny，作为一家公司，我们几乎完全无法控制的是什么？

---

### [00:18:19] Lenny Rachitsky

**English:**
What customers do.

**中文翻译:**
客户的行为。

---

### [00:18:21] Roger Martin

**English:**
Yeah. We would like them to take some of these out of their pocket and give them to us, can we make them? No, we can't. So, essentially, the job of strategy is to make decisions on the things we do control that will compel, we can't force, but it'll compel them. They'll say, gosh, I should take my hard-earned cash... and give it to you, rather than give it to nobody... or give it to a competitive product. So, the important pieces of it is integrated, it's the whole set of choices that has that one outcome, that it compels desired customer action.

**中文翻译:**
没错。我们希望他们从口袋里掏钱给我们，我们能强迫他们吗？不能。所以，战略的本质是在我们能控制的事情上做决定，从而去“迫使”——我们不能强求，但可以诱导——他们。让他们觉得：“天哪，我应该把辛苦赚来的钱给你，而不是留着不花，或者给竞争对手。”所以，战略的关键在于“整合”，它是为了实现那一个结果（促使客户行动）而做出的一整套选择。

---

### [00:19:11] Lenny Rachitsky

**English:**
Amazing. Okay. And to help people define their strategy, you have something you call the strategy choice cascade, which is basically five questions that you need to answer to help you think through strategy. Can you talk through this?

**中文翻译:**
太棒了。为了帮助人们定义战略，你提出了“战略选择级联”，基本上是五个需要回答的问题。你能详细讲讲吗？

---

### [00:19:23] Roger Martin

**English:**
Yeah. And this is the fruits of many, many years of doing strategy work... I started in strategy in 1981... Bruce Henderson had a theory of how strategy should... What result it should produce for you. Mike Porter then came along in 1980... neither of them was very good on... well, how would you get one of those? So, Mike Porter says you have to be either differentiated or low cost. Good. And if you look through Competitive Strategy... to say, how would you do that? There is no answer.

**中文翻译:**
是的。这是多年战略工作的成果。我从 1981 年开始做战略，那是早期阶段。布鲁斯·亨德森（Bruce Henderson，BCG 创始人）有一套关于战略应该产生什么结果的理论。迈克尔·波特在 1980 年出现了。但他们都不太擅长解释“你如何得到一个战略”。波特说你要么差异化，要么低成本。很好。但如果你翻遍《竞争战略》去寻找“如何做到这一点”，你是找不到答案的。

---

### [00:21:22] Roger Martin

**English:**
And it turned out... Between 1987 and 1995, I did all this work on, well, how could you develop a process for getting yourself one of those, one of those excellent strategies? And I came to the view that you have to have answers to five questions. You have to have an answer to the question of, what's your winning aspiration? What are you trying to accomplish? Because it'll help contextualize the kinds of choices you could make. Then there's a where to play, on what playing field... are you going to plop yourself down on? You're not going to play everywhere... you're going to pick someplace, and in that place, how can you be either better than competitors, in terms of creating customer value, or lower cost than those competitors?

**中文翻译:**
结果是……在 1987 年到 1995 年间，我一直在研究如何开发一套流程来获得那种卓越的战略。我得出的结论是你必须回答五个问题。第一，你的获胜抱负（Winning Aspiration）是什么？你想达成什么目标？这能为你的选择提供背景。第二，竞争领域（Where to Play），你打算在哪个战场扎根？你不能在所有地方、所有产品上竞争，你得选一个地方。第三，如何获胜（How to Win），在那个地方，你如何比对手更好地创造客户价值，或者拥有更低的成本？

---

### [00:22:38] Roger Martin

**English:**
To win there, where you've chosen to play to meet your winning aspirations, what capabilities do you have to have that your competitors don't, that would enable you to win that way? And then, what management systems, enabling management systems, do you have to put in place to make sure you build and maintain those must have capabilities to win, where you've chosen to play, to meet your winning aspiration? And so, I came to the conclusion... those were the five, and you had to do them together, and that is the essence of producing a strategy that compels desired customer action.

**中文翻译:**
第四，核心能力（Capabilities），为了在选定的领域获胜并实现抱负，你必须具备哪些对手没有的能力？第五，管理系统（Management Systems），你必须建立什么样的支撑性管理系统，以确保你能够构建并维持那些获胜所需的核心能力？我得出的结论是，就是这五个问题，而且你必须把它们结合起来考虑。这就是制定出能促使客户行动的战略的本质。

---

### [00:23:21] Lenny Rachitsky

**English:**
I want to go through an example of a company, but before we do that, something I think that's important to talk about is, if your book is called Playing to Win, you talked about this idea of you need to play to win, and you argue that a lot of people are just playing to play, they're playing to play the game. I'm guessing most people listening, and most people developing a strategy, don't think they're doing that... They think they're playing to win. I'm curious what are signs that you're not actually playing to win?

**中文翻译:**
我想举个公司的例子，但在那之前，我觉得有一点很重要：你的书名叫《玩转战略》（Playing to Win），你提到人们需要“为了获胜而战”，而你认为很多人只是“为了参与而战”（playing to play），只是在玩游戏。我猜大多数听众和制定战略的人都不觉得自己是在应付差事，他们觉得自己是在求胜。我很好奇，有哪些迹象表明你其实并不是在“为了获胜而战”？

---

### [00:23:49] Roger Martin

**English:**
It would be mainly signs given to you by customers. So, if you say, we're the most innovative company in our industry, and customers... look at the two products and say, I could flip a coin on this one, you are not effectively playing to win. Maybe you thought you were winning, but customers don't think you are better. Or if your competitor lowers their price compared to your price, and you say to yourself, oh my God, if we lowered our price, we would make no money, but your competitor keeps on pricing there, you may think you have the low cost position, but they do, and you have to give them whatever share they desire at that lower price because you can't compete there.

**中文翻译:**
迹象主要来自客户。如果你说“我们是行业内最具创新力的公司”，但客户看着两个产品说“我抛硬币选哪个都行”，那你其实并没有在为了获胜而战。也许你自以为在赢，但客户并不觉得你更好。或者，如果竞争对手降价了，而你心想“天哪，如果我们也降价就没钱赚了”，但对手却能维持那个价格，那你可能自以为有成本优势，但实际上优势在他们手里，你只能眼睁睁看着他们抢走份额，因为你无法在那个价位竞争。

---

### [00:24:56] Roger Martin

**English:**
So, you'll know you're playing to play if you're not aiming to, and accomplishing, having either an offer where Lenny walks into the store... and says to the person in the store, I want that brand. An example, Lego... It turns out that if you do market research on kids, a store that purports to be a toy store but that doesn't have Lego is not a toy store. They would define it as not a toy. Mom, why are we here? I wanted to go to a toy store. And she said, but it says toys on here. And the kids said, uh-huh. That's an insane brand.

**中文翻译:**
所以，如果你没有设定目标并实现以下两点之一，你就是在“为了参与而战”：一是提供一种让 Lenny 走进商店就指名道姓要买的品牌。比如乐高（Lego）。如果你对孩子做市场调研，你会发现，如果一家自称玩具店的地方没有乐高，孩子们会觉得那根本不是玩具店。“妈妈，我们为什么来这？我想去玩具店。”妈妈说：“但这上面写着玩具店啊。”孩子会说：“切。”这就是一个极其强悍的品牌。

---

### [00:25:54] Roger Martin

**English:**
And it has a price premium for anything, over any of its competitors by a long shot. It keeps growing... 80 or 90% of the entire category growth is Lego. And so, they're playing to win, to be distinctive in the minds of consumers. But Vanguard has got $9 trillion of assets under management last time I checked. Does it do anything distinctive? Not really. The customer bought, do they have the lowest cost position so they can charge the lowest AUMs? Absolutely. And so, there's different kinds of ways, but you'd know by the actions that customers take.

**中文翻译:**
乐高对任何产品都有远超竞争对手的溢价。它持续增长，过去十年中，该品类 80% 到 90% 的增长都来自乐高。他们在为了获胜而战，在消费者心中保持独特性。再看先锋领航（Vanguard），我记得他们管理着 9 万亿美元的资产。他们有什么独特之处吗？并没有。但他们拥有最低的成本地位，所以能收取最低的管理费。所以获胜的方式有很多种，但你得通过客户的行为来判断。

---

### [00:26:48] Lenny Rachitsky

**English:**
So, essentially, to mirror back what you're saying, to win, there's kind of these two routes you talk about. One is you're the lowest cost option, the second is you're differentiated. You have a differentiated brand, where it's not a coin flip, it's like, oh, I really need that for this reason.

**中文翻译:**
所以，总结一下你的观点，获胜有两条路径：一是成为成本最低的选择，二是实现差异化。你拥有一个差异化的品牌，让客户不再犹豫不决，而是觉得“我一定要买这个，因为某某原因”。

---

### [00:27:02] Roger Martin

**English:**
Yes. Yeah, you got it.

**中文翻译:**
没错，你理解得很对。

---

### [00:27:05] Lenny Rachitsky

**English:**
And if you can't do that, then the advice you share is go find a different playing field.

**中文翻译:**
如果你做不到这两点，你的建议就是换个竞争领域。

---

### [00:27:11] Roger Martin

**English:**
Well, or get out of business, whatever... It's only a matter of time until you're dead, is the sad truth of the matter, which is the competitors in your industry, who are either low cost or differentiated, can essentially jerk you around as much as they want. It's like Southwest Airlines, right? Southwest Airlines was just a tiny little airline... and now it's number one in passenger seat miles in America, and the only airline that's earned its cost of capital over the last half century... How did that happen? Well, it's just the other airlines had to step aside whenever Southwest came into a route... That's all they can do.

**中文翻译:**
或者干脆关门大吉。残酷的现实是，如果你不占其一，死亡只是时间问题。你行业里的那些低成本或差异化的竞争对手可以随意摆布你。就像西南航空（Southwest Airlines），它起初只是一家小航空公司，现在却是美国客运里程第一，也是过去半个世纪唯一一家赚回资本成本的航空公司。这是怎么做到的？每当西南航空进入一条航线，其他航空公司只能靠边站。他们别无选择。

---

### [00:28:15] Roger Martin

**English:**
They just have to seed position. And that's what happens, if you play to play, you'll end up just being... It's literally like having a bully who can just shove you, and you take one step back, then they shove you, and you take another step back... There's no way to protect yourself if you're not one of those two. You cannot bully Vanguard, you cannot bully Southwest, you cannot bully Proctor and Gamble, you cannot bully Lego. That's the way the business world works.

**中文翻译:**
他们只能让出位置。如果你只是“为了参与而战”，你最终会像遇到恶霸一样，他推你一下，你退一步；再推一下，你再退一步。如果你不是那两种类型之一，你就无法保护自己。你欺负不了先锋领航，欺负不了西南航空，欺负不了宝洁，也欺负不了乐高。商业世界就是这样运作的。

---

### [00:28:54] Lenny Rachitsky

**English:**
And in the case of Southwest, the reason they couldn't be bullied is they were the low cost provider and the other airlines couldn't meet their prices. So, they're like, all right, there's nothing we can do.

**中文翻译:**
在西南航空的案例中，他们之所以不被欺负，是因为他们是低成本提供商，其他航空公司无法匹配他们的价格。所以其他公司只能认栽。

---

### [00:29:04] Roger Martin

**English:**
Yep, yep.

**中文翻译:**
没错。

---

### [00:29:06] Roger Martin

**English:**
So, while I was living in Boston, they entered the Boston to Chicago route... the price was about, in those days, a $1000 for a round trip because it was a nice duopoly. When Southwest come in, they say, we're going to fly Providence to Midway, not Logan to O'Hare, and it's going to be $200. And they had great advertising... it takes you less time to get from your house to the gate than it does to go to Logan. Because at Logan, you park in a parking garage, and then walk a half an hour... And at Providence... you can park about 100 yards from the gates. And so, they just had to say, we can't stop that... there's nothing we can do to stop that.

**中文翻译:**
我住在波士顿的时候，他们进入了波士顿到芝加哥的航线。当时美联航和美国航空垄断了这条线，往返票价要 1000 美元。西南航空进来后说，我们飞普罗维登斯到中途机场，而不是洛根到奥黑尔，票价只要 200 美元。他们的广告也很棒：如果你住在波士顿南部或西部，从家到登机口的时间比去洛根机场还短。因为在洛根机场，你得停在车库然后走半小时；而在普罗维登斯，你停好车离登机口只有 100 码。其他公司只能说，我们阻止不了，毫无办法。

---

### [00:30:24] Lenny Rachitsky

**English:**
What I love is we're already diving into these five questions. So we've been mostly talking about how we will win, basically, here's your options to win. Low cost provider, or be differentiated, or find a different place to win. Let me summarize the five again. What is our winning aspiration? Where will we play? How will we win? What capabilities must we have in place to win? And what management systems are required to make sure the capabilities are in place?

**中文翻译:**
我很喜欢我们已经开始深入探讨这五个问题了。我们刚才主要在谈“如何获胜”，基本上就是：低成本、差异化或者换个地方。让我再总结一下这五个问题：1. 我们的获胜抱负是什么？2. 我们在哪个领域竞争？3. 我们如何获胜？4. 我们必须具备哪些核心能力？5. 需要什么样的管理系统来确保能力到位？

---

### [00:30:44] Roger Martin

**English:**
Right. You've got it.

**中文翻译:**
对，你掌握了。

---

### [00:30:45] Lenny Rachitsky

**English:**
Okay, cool.

**中文翻译:**
好的，太棒了。

---

### [00:30:46] Roger Martin

**English:**
You're a very quick study my friend.

**中文翻译:**
朋友，你学得真快。

---

### [00:30:48] Lenny Rachitsky

**English:**
I got some notes here. So, coming back to the how will we win? Because I think everyone's listening to this, okay, cool, we got two ways to win, we're going to be the cheapest or we're going to differentiate, okay. Okay, how do we differentiate? Is there a taxonomy of options that you think about or tell people, what are the ways and options for exploring, here's how we will be different?

**中文翻译:**
我做了笔记。回到“如何获胜”这个问题。听众可能会想：好，有两种赢法，要么最便宜，要么差异化。那么，我们如何实现差异化？有没有一套选项分类，或者你告诉人们有哪些探索“如何与众不同”的方法？

---

### [00:31:04] Roger Martin

**English:**
It is mainly understanding customers, as well as you can, and then saying, is there a way to be distinctive against that? And there are lots of ways to do it, but it's tied very closely to the capabilities... you've got to ask yourself the question, can I serve a particular customer need with a set of capabilities that are going to be hard to replicate by my competitors? They either can't do it, or they won't do it. And both are important questions because sometimes it won't.

**中文翻译:**
这主要在于尽可能深地理解客户，然后思考：有没有一种方式能针对这种理解做到与众不同？方法有很多，但它与“核心能力”紧密相连。你得问自己：我能否用一套竞争对手难以复制的能力来满足特定的客户需求？对手要么是“做不到”，要么是“不愿做”。这两点都很重要，因为有时候他们确实是不愿做。

---

### [00:32:20] Roger Martin

**English:**
Do you really think Walmart couldn't have built as good a website as Amazon, and at massive scale? I think they could have, right? Did they? They didn't. They said, I hope this online thing doesn't really take off because that would be a pisser because we've got 5,000 stores across America... And so, they don't do anything for 10 years, giving Amazon the scale... and network effects, and voila, you've got a competitive advantage that you didn't necessarily completely deserve. You needed the help of the player who stood to lose the most to hope that it wasn't going to happen.

**中文翻译:**
你真的认为沃尔玛（Walmart）造不出像亚马逊（Amazon）那样好的网站并实现大规模运营吗？我觉得他们能做到，对吧？但他们做了吗？没有。他们当时想：“我希望这玩意儿别火起来，否则就麻烦了，因为我们在全美有 5000 家店。”于是他们十年无所作为，给了亚马逊积累规模和网络效应的机会。瞧，你就这样获得了一个你未必完全凭实力赢得的竞争优势。你需要那个损失最大的对手去祈祷变革不会发生，从而给你留出空间。

---

### [00:33:54] Roger Martin

**English:**
Same with Tesla, Tesla got a 10 year headstart, not because the OEMs couldn't, they could have... But they couldn't figure out how the hell you make a buck on it, and so they didn't do it, giving Tesla the ability to establish a brand that people associate with that, electric vehicle equals Tesla, and allow them to jump way ahead, and then have the scale that is hard to hard for others to match.

**中文翻译:**
特斯拉（Tesla）也是一样。特斯拉获得了 10 年的领先优势，不是因为传统车企（OEM）做不到，他们能做到。但他们搞不清楚这玩意儿怎么赚钱，所以他们没做。这让特斯拉得以建立起品牌联想——电动汽车等于特斯拉，并让他们遥遥领先，获得了别人难以企及的规模。

---

### [00:34:06] Lenny Rachitsky

**English:**
You said something that's really interesting that I think is also really important, which is, you said that just being the best or better is not a solution. You can have a better pet food, you implied that's not going to get you there. Can you talk a bit about that?

**中文翻译:**
你刚才说了一点非常有趣且重要：仅仅做到“最好”或“更好”并不是解决方案。你暗示即使有更好的宠物食品，也不一定能成功。能详细说说吗？

---

### [00:34:06] Roger Martin

**English:**
Yeah. You have to answer a second question I guess, which is, here's the way I'm going to be better, and here's the way somebody else isn't going to be able to simply replicate that quickly. One of my favorite businesses... is a business called Westlaw, and it's the dominant provider of online legal searches... How does Westlaw do that? Well, for now over 100 years, they've taken every case that's come out of the US legal system, had a lawyer... write a head note that summarizes what's in the case, using these keywords so that they were searchable, and today, to do 2024, takes 1500 full-time lawyers.

**中文翻译:**
是的。你还得回答第二个问题：这是我变得更好的方式，而别人无法快速复制。我最喜欢的案例之一是 Westlaw，它是法律在线检索领域的霸主。Westlaw 是怎么做到的？100 多年来，他们记录了美国法律体系中的每一个案例，并让律师编写摘要（head note），使用特定关键词使其可搜索。到 2024 年，这项工作需要 1500 名全职律师。

---

### [00:36:14] Roger Martin

**English:**
So, if somebody else said... I'd like to be in that business... All they'd have to do is hire 150,000 lawyers full time, and you'd have to create a numbering system and a keyword system that's different than Westlaw's, and then you'd have to do what Westlaw has done for the past 50 years, which is give it free to law schools so that they teach their students before they even get out how to use Westlaw... No probs. That'll be easy, right? Nobody's even tried. Why bother? Life's too short. And that's the kind of capabilities you need...

**中文翻译:**
所以，如果有人说“我也想做这行”，他们得雇 15 万名全职律师，还得创造一套不同于 Westlaw 的编号和关键词系统，然后还得像 Westlaw 过去 50 年做的那样，把产品免费送给法学院，让学生在毕业前就学会使用它。没问题，这很容易，对吧？根本没人尝试。何必呢？人生苦短。这就是你所需要的那种能力……

---

### [00:37:02] Lenny Rachitsky

**English:**
[Sponsorship break for Cycle]

**中文翻译:**
[Cycle 的广告插播]

---

### [00:38:12] Lenny Rachitsky

**English:**
So, essentially, we're talking about moats. What are some moats that you can create where people can't just copy what you're doing?

**中文翻译:**
所以，本质上我们是在谈论“护城河”。你能创造哪些让别人无法轻易复制的护城河？

---

### [00:38:18] Roger Martin

**English:**
And Warren Buffett likes that terminology, right? That's what he says, he invests in moats.

**中文翻译:**
沃伦·巴菲特很喜欢这个术语，对吧？他说他只投资有护城河的公司。

---

### [00:38:25] Lenny Rachitsky

**English:**
Yeah. I'll find the quote we used in a recent podcast episode, but he's like, castles with moats. And maybe along those lines, is there a way you think about types of barriers to recreate capabilities? It's like, here's the options we have, is it like... Essentially, the seven powers I think talks about this.

**中文翻译:**
是的。我找一下我们在最近一集播客里用过的引言，他说的是“带护城河的城堡”。沿着这个思路，你如何思考重建能力的障碍类型？就像 Hamilton Helmer 的《七大策略力量》里提到的那样。

---

### [00:38:43] Roger Martin

**English:**
Yeah. Yeah. That's why I like Helmer, because he categorizes them. And I've got to look into it some more because I haven't studied it to say whether I would concur that there are just seven, or there are more. My suspicion might be that there are more... But I don't, myself, have a categorization scheme that says, here's how you search for the moat.

**中文翻译:**
是的。这就是我喜欢 Helmer 的原因，因为他把它们分类了。我得再深入研究一下，因为我还没研究到能断定是否只有七种。我怀疑可能更多。但我自己并没有一套专门的分类方案来教你“如何寻找护城河”。

---

### [00:39:20] Lenny Rachitsky

**English:**
Great. That would be nice. So, here's the quote from Buffet, by the way, "I look for economic castles protected by unbreachable moats."

**中文翻译:**
太好了。顺便说一下，巴菲特的原话是：“我寻找的是由无法逾越的护城河保护的经济城堡。”

---

### [00:39:27] Roger Martin

**English:**
Yes, I like that.

**中文翻译:**
是的，我喜欢这个说法。

---

### [00:39:30] Roger Martin

**English:**
And he's smart, he's consistent. Though, everybody makes mistakes, right? And he did too. Solomon Brothers, US Air... Anybody who thinks they can be perfect on strategy is delusional. And so, even the very, very best, like a Warren Buffet... is going to sort of think, I think this is a moat, and it's going to be ephemeral. But any of us should be pleased to have a track record that would be anywhere close to that...

**中文翻译:**
他很聪明，也很专注。虽然每个人都会犯错，他也一样，比如所罗门兄弟、全美航空。任何认为自己能在战略上做到完美的人都是在幻想。即使是像巴菲特这样顶尖的天才，有时也会误判护城河的持久性。但如果我们能拥有接近他那样的战绩，就该谢天谢地了。

---

### [00:40:11] Lenny Rachitsky

**English:**
We talked about that with Hamilton Helmer, that every startup deck has, here's our moats, here's how we're going to have barriers to entry, and they're all delusional, rarely is there ever an actual moat, especially in the early stages.

**中文翻译:**
我们和 Hamilton Helmer 讨论过，每个创业公司的融资计划书里都会写“这是我们的护城河”、“这是我们的准入门槛”，但大多是幻想，很少有真正的护城河，尤其是在早期阶段。

---

### [00:40:22] Roger Martin

**English:**
Yes. Yes.

**中文翻译:**
没错。

---

### [00:40:23] Lenny Rachitsky

**English:**
Let's go back to the five questions again, because that's so core to the way you think about strategy. What do you think about using, say this FigJam as an example, as a hypothetical, just to think through questions that they might ask to think about strategy...

**中文翻译:**
让我们回到那五个问题，因为那是你战略思维的核心。我们拿 FigJam（Figma 旗下的白板工具）做一个假设性的案例，来看看他们可能会问哪些战略问题。

---

### [00:40:38] Roger Martin

**English:**
Sure, sure. I do not know that product-

**中文翻译:**
当然可以。我不了解那个产品——

---

### [00:40:40] Lenny Rachitsky

**English:**
Okay. It's basically a visual whiteboard collaboration tool, where people can put in sticky notes, and put little mocks, and kind of play around with all the cursors. And so, it's for brainstorming, and ideation, and things like that, and laying out concept.

**中文翻译:**
好。它基本上是一个视觉白板协作工具，人们可以在上面贴便签、画草图、移动光标。它用于头脑风暴、构思以及展示概念。

---

### [00:40:52] Roger Martin

**English:**
Gotcha. Okay, that would make sense for Figma.

**中文翻译:**
明白了。对 Figma 来说这很合理。

---

### [00:40:55] Roger Martin

**English:**
So, you'd asked the question, what are we trying to accomplish? Are we attempting to create something where nothing digital exists, people do this in pen and paper, and so we're trying to invent a category and then be transformative by making the user experience better? Is that what we're trying to do? Or are there players already doing this and they're just not doing it very well? You'd want to say, well, what are we trying to accomplish? ... What do you think their reason for thinking FigJam is worth investing in is?

**中文翻译:**
那么，你要问：我们想要达成什么？我们是想在目前还是纯纸笔办公的领域创造数字化工具，从而开创一个品类并通过提升体验来实现变革吗？还是说已经有玩家在做了，只是做得不够好？你得明确目标。你觉得他们认为 FigJam 值得投资的原因是什么？

---

### [00:42:03] Lenny Rachitsky

**English:**
If I had to get to it, I think they're trying to expand their market and they have a stronghold in design tooling, and there's this adjacent market for product teams broadly to be using Figma more. And there are existing tools similar to that, that are good.

**中文翻译:**
如果让我猜，我觉得他们是想扩张市场。他们在设计工具领域有稳固的地位，而产品团队这个相邻市场有潜力让更多人使用 Figma。目前已经有一些类似的不错工具了。

---

### [00:42:21] Roger Martin

**English:**
Okay. So, I don't love it to start.

**中文翻译:**
好吧。作为开端，我不怎么喜欢这个理由。

---

### [00:42:25] Lenny Rachitsky

**English:**
Say more.

**中文翻译:**
展开说说。

---

### [00:42:26] Roger Martin

**English:**
So, "there's a big market over there, we'd like to get some," is a terrible reason in my view. The reason should be, customers are bereft, customers are lacking something that we can provide. This is why I hate... And most entries by foreign companies into China, they get their faces shot off. And the reason is the rationale is, "it's big, we could get some of that." So, I don't love it, for starters.

**中文翻译:**
在我看来，“那里有个大市场，我们也想分一杯羹”是个糟糕的理由。理由应该是：客户感到匮乏，客户缺少某些只有我们能提供的东西。这就是为什么我讨厌……大多数外国公司进入中国市场时都会碰壁，原因就是他们的逻辑是“那里市场很大，我们可以分一点”。所以，我不看好这个出发点。

---

### [00:43:13] Lenny Rachitsky

**English:**
Well, I imagine you can also frame it in other terms, like our customers are demanding more ways to work within Figma with their teams...

**中文翻译:**
我想也可以换种说法，比如“我们的客户要求在 Figma 内部有更多与团队协作的方式”……

---

### [00:43:22] Roger Martin

**English:**
Yeah. So, that would be a better one... What's our aspiration? It's to satisfy core customers, who love what we do, but think it's too narrow, that if we could broaden that for them, into this market, our customers would be very happy.

**中文翻译:**
是的，这个理由好多了。我们的抱负是什么？是满足那些热爱我们、但觉得我们功能太窄的核心客户。如果我们能为他们拓宽领域，进入这个市场，客户会非常高兴。

---

### [00:43:47] Lenny Rachitsky

**English:**
That is really cool. And so, you want to frame it in the words of how customers would benefit, essentially.

**中文翻译:**
这很酷。本质上，你要用“客户如何获益”的语言来描述它。

---

### [00:43:52] Roger Martin

**English:**
I just think those tend to be stronger... Because remember, what is strategy about? Compelling desired customer action. So, everything ties back to that. So, then the where to play would be, you just want to say, okay, what customers are we talking about... Through what distribution channel would we sell this?

**中文翻译:**
我觉得这样的理由更有力。记住，战略是关于什么的？是促使客户产生预期行为。所以一切都要回归到这一点。接下来的“竞争领域”就是：我们在谈论哪些客户？通过什么渠道销售？

---

### [00:44:42] Lenny Rachitsky

**English:**
Before we get to that real quick... So, the things you mentioned there is who specifically are the customers? So, in this case it'd be like product managers, engineers, and other functions, and then there's the distribution channels, how we'd actually get to them?

**中文翻译:**
在进入下一步之前……你提到的点是：具体的客户是谁？在这个案例中，可能是产品经理、工程师等。然后是分销渠道，我们如何触达他们？

---

### [00:44:56] Roger Martin

**English:**
Get to them, yeah.

**中文翻译:**
触达他们，没错。

---

### [00:44:56] Lenny Rachitsky

**English:**
And then, what other questions are there within this where we will play?

**中文翻译:**
那么在“竞争领域”中还有哪些其他问题？

---

### [00:45:02] Roger Martin

**English:**
To what extent is it a finished product or a component? ... At what vertical stage? Is it an integrated product, where it's the whole thing from soup to nuts? ... Those are all important where to play choices... Like Four Seasons the hotel company... back in the 80s, they said we're going to get out of real estate development... We're even going to get out of the business of owning the land or the hotel, so that we can be awesome at hotel management.

**中文翻译:**
它在多大程度上是一个成品或是一个组件？处于垂直链条的哪个阶段？是一个从头到尾的整合产品吗？这些都是重要的“竞争领域”选择。比如四季酒店（Four Seasons），在 80 年代，他们决定退出房地产开发，甚至不再持有土地或酒店物业，这样他们就能专注于做到极致的酒店管理。

---

### [00:47:07] Lenny Rachitsky

**English:**
So, it's like a value chain question. Where in the value chain are you going to play?

**中文翻译:**
所以这就像是一个价值链问题。你打算在价值链的哪个环节竞争？

---

### [00:47:13] Roger Martin

**English:**
Value chain. Yeah. Where in the value chain? That's exactly right. And everybody has value chain questions. They often complain, after the fact, like all the apps complain about what cut Apple is taking, but they made a choice, a value chain choice.

**中文翻译:**
价值链，没错。每个人都会面临价值链问题。人们常在事后抱怨，比如所有 App 都在抱怨苹果的抽成，但那是他们自己做的价值链选择。

---

### [00:48:28] Lenny Rachitsky

**English:**
Okay, so we've talked about the winning aspirations... and then, where will we play? ... And then, it's how will we win? How do you think about that?

**中文翻译:**
好，我们谈过了获胜抱负，以及竞争领域。接下来是“如何获胜”，你怎么看？

---

### [00:48:57] Roger Martin

**English:**
Yeah, yeah. Well, you ask the question, how can we solve... that problem at a much lower cost... Or there are other selections, but they make the user do all these things, and it's ponderous... We have shortcuts, we use AI... Or we're more integrated... Is it better integrated into their workflow that makes their life easier? ... Essentially, you've got to have a theory there, of how are you going to be better or lower cost.

**中文翻译:**
你要问：我们能否以更低的成本解决问题？或者，现有的选择很笨重，用户操作繁琐，而我们有快捷方式，我们用 AI。或者我们整合得更好，能无缝嵌入他们的工作流，让生活更轻松？本质上，你得有一套理论，说明你如何做到更好或成本更低。

---

### [00:50:34] Lenny Rachitsky

**English:**
On the lower cost front, I think generally the advice is you don't want to go that route, that's a very difficult route. What's your thinking of just when to go that route that you might actually win at lower costs?

**中文翻译:**
关于低成本，通常的建议是不要走这条路，因为太难了。你觉得什么时候走低成本路线才可能真正获胜？

---

### [00:50:45] Roger Martin

**English:**
That's not advice I give. I think they're both completely legitimate strategies. They have implications. So, if you want to be the cost leader, it is rare that you can be the cost leader without having dominant scale in the territory in which you're operating. So, if you want to be a niche cost leader, good luck to you, that's almost never going to happen.

**中文翻译:**
我从不给这种建议。我认为两者都是完全合理的战略，只是影响不同。如果你想成为成本领先者，如果你在所处的领域没有占据主导地位的规模，那是很难实现的。如果你想做一个“小众的成本领先者”，祝你好运，那几乎不可能发生。

---

### [00:52:35] Lenny Rachitsky

**English:**
I think it's also important to say, either path is very hard, it's very hard to build a business that makes money and is profitable and survives just broadly.

**中文翻译:**
我觉得也得说明一下，无论哪条路都很难。建立一个能赚钱、盈利并生存下来的企业本身就极其困难。

---

### [00:52:43] Roger Martin

**English:**
Yes, yes, I agree.

**中文翻译:**
是的，我同意。

---

### [00:53:16] Lenny Rachitsky

**English:**
Okay. So, now we're at the capability step of trying to figure out what capabilities you need to win. Can you talk about, say with FigJam, what are the sorts of things you think about here?

**中文翻译:**
好。现在到了“核心能力”这一步，要弄清楚获胜需要什么能力。以 FigJam 为例，你会考虑哪些方面？

---

### [00:53:26] Roger Martin

**English:**
Well, I guess I'd ask myself questions, like, is there a learning curve to this... Is there a way that we've figured out how to serve customers that make them feel tended to better by us? ... How to win is a theory of how customers are going to perceive us better... And then, it's what capabilities would we have to have to make that theory come true, rather than just be a wish.

**中文翻译:**
我会问：这是否存在学习曲线？我们是否找到了一种让客户感到被照顾得更好的服务方式？“如何获胜”是一套关于客户如何感知我们更好的理论；而“核心能力”则是为了让这套理论成真（而不仅仅是个愿望）你必须具备的能力。

---

### [00:54:47] Roger Martin

**English:**
It's just like again, Four Seasons... their how to win was they said... we're going to define it as a service that makes up for what you left at home or at the office. Because people would rather be... at the office than in a hotel because they can be more productive. So, we need capabilities, we need staff that can deliver on that capability. What's the problem, for that? The problem is turnover in the hotel industry globally is 80% a year...

**中文翻译:**
再以四季酒店为例。他们的获胜方式是：将豪华定义为一种弥补你离开家或办公室后的缺失的服务。因为人们更愿意待在办公室而不是酒店，因为那里效率更高。所以我们需要能提供这种服务的人员。问题在哪？全球酒店业的人员流动率高达每年 80%。

---

### [00:56:26] Roger Martin

**English:**
You have to have a different way of recruiting, a different way of onboarding, a different way of career development. And if you do all of those things, you end up with a 10% turnover rate... and you can then get them trained up to deliver that kind of service. So, that's the capability that you build... to be able to take more decision-making at a lower level, and treat the guests in a customized way...

**中文翻译:**
你必须有不同的招聘、入职和职业发展方式。如果你做到了这些，你的流动率会降到 10%，你就能训练他们提供那种服务。这就是你构建的能力：让底层员工拥有更多决策权，以个性化的方式对待客人。

---

### [00:57:01] Lenny Rachitsky

**English:**
It's interesting that these capabilities and even the management systems, which is step five, relate to your moat. Which is the thing you need to achieve, also, ideally is the thing that other people, it'll make it hard for them to do.

**中文翻译:**
很有意思，这些能力甚至第五步的管理系统，都与你的“护城河”有关。你想要实现的目标，理想情况下也应该是让别人很难做到的事情。

---

### [00:57:14] Roger Martin

**English:**
Yep. So, you're exactly right. You can call if you want, how to win, moat, right? Definition of your moat. And so, capabilities and management systems are what both build and maintain the moat...

**中文翻译:**
没错。如果你愿意，你可以把“如何获胜”称为护城河的定义。而核心能力和管理系统则是构建和维护护城河的工具。

---

### [00:58:16] Roger Martin

**English:**
But at Four Seasons, you got to sell off all your hotels, you got to fire all the people involved in hotel development... you have to essentially get rid of your entire staff, start from scratch... with the hopes that maybe someday you'll be able to produce the kind of services Four Seasons does. The competitors basically say, life's too short.

**中文翻译:**
但在四季酒店的案例中，对手得卖掉所有酒店，解雇所有开发人员，基本上要裁掉所有员工从头开始，还得寄希望于有一天能提供四季那样的服务。竞争对手基本上会说：“人生苦短，何必呢。”

---

### [01:00:27] Roger Martin

**English:**
And so, if you have completely different capabilities and management systems, it'll encourage people to choose a different where to play, how to win. If your capabilities and management systems are very similar to your competitors... they're going to drive straight to your where to play and try to win exactly the same place and wreck your market for both of you. That's what you don't want.

**中文翻译:**
所以，如果你拥有完全不同的能力和管理系统，就会促使别人选择不同的竞争领域和获胜方式。如果你的能力和系统与对手非常相似，他们就会直接冲进你的领地，在同一个地方竞争，最后把两家的市场都搞垮。这正是你要避免的。

---

### [01:02:38] Lenny Rachitsky

**English:**
Wow, that's a great quote. This story about Southwest makes me think about Hamilton Helmer's counter-positioning... basically, you position yourself in a way where the competitor can't do the thing that you're doing because of the way their business is already structured.

**中文翻译:**
哇，这段话太棒了。西南航空的故事让我想起 Hamilton Helmer 的“逆向定位”（counter-positioning）——基本上，你定位自己的方式让竞争对手无法效仿，因为他们的业务结构已经定型了。

---

### [01:02:57] Roger Martin

**English:**
Ah, that sounds right. The "can't" thing.

**中文翻译:**
啊，听起来没错。就是那个“做不到”的点。

---

### [01:03:00] Lenny Rachitsky

**English:**
Yeah, can't.

**中文翻译:**
是的，做不到。

---

### [01:03:00] Roger Martin

**English:**
The can't thing. Awesome. Yeah, and Mike Porter... was very big on that. He said, it's fault lines. You're trying to find fault lines, where it is so painful for your competitor to come across that fault line, into your side. And so, a great example of that would be Olay, at P&G...

**中文翻译:**
“做不到”这一点。太棒了。迈克尔·波特也非常看重这一点。他说这叫“断层线”。你要寻找那些让对手跨越过来会感到极其痛苦的断层线。宝洁的玉兰油（Olay）就是一个绝佳的例子。

---

### [01:04:05] Roger Martin

**English:**
If Estée Lauder would've taken their Clinique brand and brought it into mass, they would've killed what we were doing. Simple as that... But Estée Lauder also has Bobby Brown, and Mac... all in prestige, and the prestige channel, if they'd have taken Clinique, and taken it over into mass, would've done what? Shot them in the face. Killed them, right?

**中文翻译:**
如果雅诗兰黛（Estée Lauder）把倩碧（Clinique）品牌引入大众市场，他们就能轻易击败我们。就这么简单。但雅诗兰黛旗下还有芭比波朗、魅可等高端品牌。如果他们把倩碧下放到大众渠道，高端渠道的零售商会怎么做？会直接翻脸，毁掉他们的生意。

---

### [01:05:38] Lenny Rachitsky

**English:**
I love that I'm learning all this strategic thinking about makeup and skincare...

**中文翻译:**
我太喜欢了，我竟然在学习关于化妆品和护肤品的战略思维。

---

### [01:06:02] Lenny Rachitsky

**English:**
I don't know if you're following the AI Google stuff that's happening, where there's search engines competing with Google by just answering the question versus giving you a bunch of blue links? And there's this question of, will Google shift... versus they're making trillions of dollars running ads when they share blue links...

**中文翻译:**
不知道你有没有关注谷歌的 AI 动态？现在有些搜索引擎通过直接回答问题来竞争，而不是给出一堆蓝色链接。问题是，谷歌会转型吗？毕竟他们靠蓝色链接里的广告赚了几万亿。

---

### [01:06:14] Roger Martin

**English:**
Yeah, no, no, I am very interested in what's going on in AI... But my general advice is always the same, which is, it can take a while, but in the end the customers will triumph. A.G. Lafley... was very good on this. And one of his big customers... came to him and said, if you don't stop cooperating with Amazon, we're going to de-list all your products.

**中文翻译:**
是的，我对 AI 的进展非常感兴趣。但我的一般建议总是一样的：虽然可能需要时间，但最终客户会获胜。雷富礼（A.G. Lafley，宝洁前 CEO）在这方面很擅长。他的一位大客户曾威胁他：“如果你不停止与亚马逊合作，我们就下架你所有的产品。”

---

### [01:07:35] Roger Martin

**English:**
And A.G. just said, "If customers want to shop there, we just can't not be where our customers want to shop... But we're not boycotting a place that customers have shown they want to shop." ... You can't hold back the tide. Maybe you can for a while, but you can't forever. So, you just have to figure out where are the customers going.

**中文翻译:**
雷富礼只是说：“如果客户想在那里购物，我们就不能不在那里。我们不会抵制一个客户已经证明他们想去的地方。”你无法阻挡潮流（tide）。也许你能阻挡一时，但不能永远阻挡。所以你必须弄清楚客户要去哪里。

---

### [01:11:09] Roger Martin

**English:**
Think about Microsoft and its monopoly on PC operating systems... I often asked people, when's the last Windows update that got you as a customer excited? ... The answer, I think is really clear, Windows 95, right? ... Their share of people staring at a smart screen has plummeted. Why? Because water finds its own level.

**中文翻译:**
想想微软在 PC 操作系统上的垄断。我常问人：“上一次让你感到兴奋的 Windows 更新是什么时候？”答案很明确：Windows 95。现在，他们在“智能屏幕关注时长”中的份额已经暴跌。为什么？因为水往低处流，人们找到了其他替代方案。

---

### [01:13:59] Lenny Rachitsky

**English:**
And it may take time, but eventually the customer tide pulls, that's a, I think that's really important.

**中文翻译:**
可能需要时间，但最终客户的潮流会拉动一切，我觉得这非常重要。

---

### [01:14:04] Roger Martin

**English:**
But yeah, start now. If you don't start now, it's too late.

**中文翻译:**
是的，现在就开始。如果不现在开始，就太晚了。

---

### [01:14:11] Lenny Rachitsky

**English:**
I want to end with one very tactical question for people... You have this really cool idea called betterment... thinking betterment over perfection. Can you just talk about that approach?

**中文翻译:**
我想以一个非常具有战术性的问题结束。你有一个很酷的想法叫“改进”（betterment），即追求改进而非完美。你能谈谈这个方法吗？

---

### [01:14:32] Roger Martin

**English:**
So, for me, strategy... I just think of it as a problem solving tool. And what problem should you attempt to solve? You should attempt to solve something where your current outcomes... are lower than the outcomes you wish you were getting. That's what I call a gap. ... You're going to need to make a different set of choices to make that gap go away. That's what I would work on.

**中文翻译:**
对我来说，战略就是一个解决问题的工具。你应该尝试解决什么问题？你应该解决那些现状与预期结果之间的差距。我称之为“缺口”（gap）。你需要做出一套不同的选择来消除这个缺口。这就是我要做的工作。

---

### [01:15:31] Roger Martin

**English:**
I would just ask the question, what is the single most painful gap currently that I'm facing? ... And then just tackle that. And say, what different choices could I make? ... Don't try to solve the problems of the world... that's perfection. Betterment is making that gap go away. And guess what happens if you make that gap go away? You can turn your attention to the next gap...

**中文翻译:**
我会问：目前我面临的最痛苦的缺口是什么？然后去解决它。思考：我可以做出哪些不同的选择？不要试图解决全世界的问题，那是追求完美。改进就是消除那个缺口。一旦缺口消失了，你就可以转向下一个缺口。

---

### [01:18:21] Roger Martin

**English:**
... betterment, it doesn't make purists feel awesome, but I'm not here to make purists feel awesome, I'm here to help people get better.

**中文翻译:**
……“改进”可能不会让原教旨主义者觉得了不起，但我不是为了让他们开心，我是为了帮助人们变得更好。

---

### [01:18:58] Roger Martin

**English:**
Well, on strategy, there's one piece of advice I'd say... I have never met this mythical beast called a great natural strategist. ... Great strategists that I have met have all one thing in common. They just practice. And anybody... who is willing to practice strategy, who will end up saying, I'm operational, I don't do strategy well. ... Just work on making different choices to solve problems. ... If you do that, you'll be a great strategist.

**中文翻译:**
关于战略，我还有一条建议。我从未见过所谓的“天生战略家”。我见过的所有伟大战略家都有一个共同点：他们只是不断练习。任何愿意练习战略的人，最终都不会再说“我只是个搞执行的，我不擅长战略”。只要致力于通过不同的选择来解决问题，你就会成为一名伟大的战略家。

---

### [01:21:22] Lenny Rachitsky

**English:**
Wow. I love this, I love how empowering it is, I love the real talk. Roger, you're awesome. Thank you so much for being here.

**中文翻译:**
哇。我太喜欢这段话了，非常有力量，而且很真诚。Roger，你太棒了。非常感谢你能来。

---

### [01:21:29] Roger Martin

**English:**
You're most welcome. Thank you for making it a fun journey for me.

**中文翻译:**
不客气。谢谢你带给我这段愉快的旅程。

---

### [01:21:32] Lenny Rachitsky

**English:**
I learned a ton, and that's always a good sign, and it was a lot of fun. Thanks, Roger.

**中文翻译:**
我学到了很多，这总是好兆头，而且过程很有趣。谢谢，Roger。

---

### [01:21:39] Lenny Rachitsky

**English:**
Thank you so much for listening... See you in the next episode.

**中文翻译:**
感谢收听……下期节目再见。