# Sachin Monga - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Sachin Monga, Head of Product at Substack.

---

### [00:00:00] Sachin Monga

**English:**
I really think that we're just starting into this golden era of what it might mean to be a writer on the internet. The economic model for supporting great writing on the internet has been generally pretty terrible for the entirety of the internet's history. In the early days of Substack, there's a couple of these glimmers of hope where you'd have people like Matt Taibbi or Bill Bishop, some of the early writers on Substack that were really well established writers who were clearly just being undervalued and now could come to Substack and see their true value.

**中文翻译:**
我真的认为，我们才刚刚开启互联网写作的“黄金时代”。在整个互联网历史上，支持优秀写作的经济模式通常都非常糟糕。在 Substack 的早期，出现了一些希望的曙光，比如 Matt Taibbi 或 Bill Bishop，这些 Substack 的早期作者都是非常有成就的作家，他们显然被低估了，而现在他们可以来到 Substack 并实现其真正的价值。

---

### [00:00:33] Sachin Monga

**English:**
And that was awesome. That was really cool to see. But in the last year or so, even in the last few months, I think there's been so many really interesting success stories now from writers who might not even consider themselves writers. People who are able to make a living, maybe even make a fortune just doing great work and not needing to have millions and millions of viewers or play the attention games of other networks, but just do really high quality work and have a relatively small number of people value it highly enough to pay for it.

**中文翻译:**
那太棒了，看到这些真的很酷。但在过去一年左右，甚至就在过去的几个月里，我认为出现了很多非常有趣的成功案例，这些作者甚至可能不认为自己是“作家”。这些人能够维持生计，甚至赚大钱，仅仅是因为他们做出了优秀的作品，而不需要拥有数百万的观众，也不需要去玩其他社交网络的“注意力游戏”。他们只需创作高质量的内容，并让相对少数的人对其产生足够的认可并愿意为此付费。

---

### [00:01:07] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny, and my goal here is to help you get better at the craft of building and growing products. Today, my guest is Sachin Monga, who is currently the head of product at Substack. Before Substack, he had a startup called Cocoon that he sold to Substack. And before that, he spent over seven years at Facebook working on the video and camera products, building out the developer platform, and leading the ads growth team. In our conversation, we dig into all things Substack, what it's like to build product at Substack, how different it is to work at a startup versus a big company like Facebook, the future of the Substack product.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你更好地掌握构建和增长产品的技能。今天，我的嘉宾是 Sachin Monga，他目前是 Substack 的产品负责人。在加入 Substack 之前，他创办了一家名为 Cocoon 的初创公司，后来卖给了 Substack。在此之前，他在 Facebook 工作了七年多，负责视频和相机产品，构建开发者平台，并领导广告增长团队。在我们的对话中，我们将深入探讨 Substack 的方方面面，包括在 Substack 构建产品是什么感觉，在初创公司工作与在 Facebook 这样的大公司工作有什么不同，以及 Substack 产品的未来。

---

### [00:01:42] Lenny

**English:**
We also spent a lot of time on what I venture to say will go down in history as one of the most legendary growth features ever created, the Substack recommendations feature. Substack as a product and a company has changed my life and allowed me to do the work that I do now, and it was such a treat to be able to chat with Sachin. I hope that you find this conversation as interesting as I did. With that, I bring you Sachin Monga. Who has an opinion on internal tools? Internal tools are something you probably don't think about until you have to, or it probably didn't even occur to you to think about them.

**中文翻译:**
我们还花了很多时间讨论一个我敢说将载入史册的、有史以来最传奇的增长功能之一：Substack 的推荐功能（Recommendations）。Substack 作为一个产品和一家公司改变了我的生活，让我能够从事现在的工作。能和 Sachin 聊天真是太愉快了。我希望你们觉得这次对话和我一样有趣。下面，让我们欢迎 Sachin Monga。谁对内部工具有看法？内部工具通常是你直到不得不面对时才会去考虑的东西，或者你甚至根本没想过要去考虑它们。

---

### [00:02:18] Lenny

**English:**
But if you work at a big company, you probably have a bunch of one-off custom apps or dashboards that are laser focused on just one job to be done for one specific team or just one role, and they're always such a huge pain to build and maintain. And that's why I'm such a big fan of Retool and why I think Retool is so popular. Retool allows teams as small as just one person to build a suite of custom internal apps in a fraction of the time that you think it takes. The productivity gains of custom apps is now within reach, not just for large enterprises but for small teams as well. And as you scale, your company Retool scales with you.

**中文翻译:**
但如果你在大公司工作，你可能会有一堆一次性的定制应用或仪表板，它们只专注于为某个特定团队或某个角色完成一项任务，而且构建和维护它们总是非常痛苦。这就是为什么我是 Retool 的忠实粉丝，也是为什么我认为 Retool 如此受欢迎的原因。Retool 允许小到只有一个人的团队，在极短的时间内构建一套定制的内部应用。定制应用带来的生产力提升现在不仅大型企业可以触及，小团队也同样可以。随着你公司的规模扩大，Retool 也会随之扩展。

---

### [00:02:54] Lenny

**English:**
Snowflake saves about 26 hours a week of manual spreadsheet work with custom internal apps built on Retool. Amazon uses Retool to handle GDPR requests. Thousands of teams at companies like Coinbase, DoorDash, and NBC collaborate around custom-built Retool apps to operate with greater efficiency. Maybe you've thought about using Retool before, but just haven't and I'm here to tell you that now teams of up to five can build unlimited Retool apps for free. Get started today at Retool.com/lenny. Do you want to reduce friction in your onboarding flow? Then let me tell you about Stytch, and that's Stytch with a Y.

**中文翻译:**
Snowflake 通过在 Retool 上构建的定制内部应用，每周节省了大约 26 小时的手动电子表格工作。亚马逊使用 Retool 处理 GDPR（通用数据保护条例）请求。Coinbase、DoorDash 和 NBC 等公司的数千个团队都在围绕定制的 Retool 应用进行协作，以提高运营效率。也许你以前考虑过使用 Retool，但一直没行动，我现在告诉你，现在最多 5 人的团队可以免费构建无限量的 Retool 应用。今天就开始访问 Retool.com/lenny。你想减少入职流程（onboarding flow）中的摩擦吗？那让我给你介绍一下 Stytch，拼写是 S-T-Y-T-C-H。

---

### [00:03:34] Lenny

**English:**
Stytch is on a mission to eliminate friction from the internet. There's starting by making user authentication and onboarding more seamless and more secure. They offer super flexible out-of-the-box authentication solutions for companies of all sizes. From email magic links to SMS passcodes, one tap social logins to even biometrics, Stytch is your all-in-one platform for authentication. Stytch customers have been able to increase conversion by over 60% after spending just one day integrating. And with their API and SDKs, you can improve user conversion and retention and security all while saving valuable engineering time.

**中文翻译:**
Stytch 的使命是消除互联网上的摩擦。他们从让用户身份验证和入职变得更无缝、更安全开始。他们为各种规模的公司提供超级灵活的开箱即用身份验证解决方案。从电子邮件魔法链接（magic links）到短信验证码，从一键社交登录到甚至生物识别，Stytch 是你的全方位身份验证平台。Stytch 的客户在仅花一天时间集成后，转化率就提高了 60% 以上。通过他们的 API 和 SDK，你可以在节省宝贵工程时间的同时，提高用户转化率、留存率和安全性。

---

### [00:04:13] Lenny

**English:**
Your engineers will come and thank you for using Stytch, because Stytch keeps you from having to build authentication in house and the integration process is super fast and super smooth. To get $1,000 in free credits, just go to Stytch.com/lenny to sign up, and that's Stytch with a Y. Sachin, welcome to the podcast.

**中文翻译:**
你的工程师会因为你使用了 Stytch 而感谢你，因为 Stytch 让你不必在内部构建身份验证系统，而且集成过程超级快、超级顺畅。要获得 1000 美元的免费额度，只需前往 Stytch.com/lenny 注册即可。Sachin，欢迎来到播客。

---

### [00:04:36] Sachin Monga

**English:**
Thanks for having me.

**中文翻译:**
谢谢邀请我。

---

### [00:04:37] Lenny

**English:**
I'm actually really excited to have you on. I've told you this before, I've told the founders before, Substack has changed my life in so many ways. There's no way that I would be doing what I'm doing now if not for Substack and just like the magical combination of features that you all built. I'm also just really curious about how you all build the platform, where it's going, how it all works behind the scenes. Again, thank you for being here.

**中文翻译:**
其实我非常兴奋能请到你。我以前跟你说过，也跟创始人说过，Substack 在很多方面改变了我的生活。如果没有 Substack 以及你们构建的那些神奇的功能组合，我绝对不可能从事现在的工作。我也非常好奇你们是如何构建这个平台的，它的走向如何，以及幕后是如何运作的。再次感谢你的到来。

---

### [00:05:01] Sachin Monga

**English:**
I'm so happy to be here, and that's so great to hear.

**中文翻译:**
很高兴来到这里，听到这些真是太好了。

---

### [00:05:03] Lenny

**English:**
Just to set a little context for folks, can you just talk about how you got to Substack? You're currently head of product at Substack. What was that journey to Substack?

**中文翻译:**
为了给大家提供一些背景信息，你能谈谈你是如何加入 Substack 的吗？你目前是 Substack 的产品负责人。加入 Substack 的历程是怎样的？

---

### [00:05:12] Sachin Monga

**English:**
I joined Substack around a year ago now exactly through an acquisition. I'd started a company called Cocoon about three years prior to that with my good friend Alex Cornell. Cocoon is not like Substack. It was essentially a little photo sharing app for close friends and family, but there is a common thread which led us to Substack, which was prior to starting Cocoon, Alex and I had both worked at Facebook for a number of years and had worked on effectively the same problem of helping people share more with their friends and family and had all these ideas for what an idealized experience might look like. We just kept running into the wall that you run into when ultimately advertising is the business model that is powering this whole thing, and what that means is you need to accumulate a lot of time spent and attention and convert that into basically sellable eyeballs. But it's not that hard to imagine what a better solution would be. It's just that ads as the business model made it really hard to pull that off. Cocoon was in a lot of ways like a journey to explore what that might look like for this one particular use case of just helping you feel close to a handful of people.

**中文翻译:**
我大约在一年前通过一次收购加入了 Substack。在那之前大约三年，我和好朋友 Alex Cornell 创办了一家名为 Cocoon 的公司。Cocoon 和 Substack 不太一样，它本质上是一个面向亲密朋友和家人的照片共享应用。但有一个共同点引导我们走向了 Substack：在创办 Cocoon 之前，Alex 和我都曾在 Facebook 工作多年，处理的实际上是同一个问题，即帮助人们与亲友分享更多内容，并对理想化的体验有很多想法。但我们总是会遇到那堵墙——当广告最终成为支撑这一切的商业模式时，这意味着你需要积累大量的用户时长和注意力，并将其转化为可销售的“眼球”。想象一个更好的解决方案并不难，只是广告模式让实现它变得非常困难。Cocoon 在很多方面就像是一场探索之旅，探索在“帮助你与少数人保持亲密关系”这一特定用例下，理想的体验会是什么样子。

---

### [00:06:14] Sachin Monga

**English:**
We always looked up to Substack as a really good example of basically that same principle, which is if you imagine rewiring the internet around paid subscriptions, direct subscriptions between, in Substack's case, readers and writers, what could that unlock and could it unlock a clearly better user experience? We looked at Substack as a real inspiration and an example of that really working out and got to know the founders pretty well and had a few conversations and realized that even though the blogging software and the photo sharing app are pretty different, our underlying motivations were really consistent.

**中文翻译:**
我们一直把 Substack 看作是一个非常好的榜样，它体现了同样的原则：如果你想象围绕付费订阅重新构建互联网，即读者和作者之间的直接订阅（以 Substack 为例），这能释放出什么？它能否带来明显更好的用户体验？我们将 Substack 视为真正的灵感来源和成功的典范。我们后来深入了解了创始人，进行了几次交谈，意识到尽管博客软件和照片共享应用大不相同，但我们的底层动机是非常一致的。

---

### [00:06:46] Sachin Monga

**English:**
It was a bit of a match made in heaven and the whole team joined Substack a year ago. I've been privileged enough to get to lead the product and design teams, and it's been a blast so far.

**中文翻译:**
这简直是天作之合，整个团队在一年前加入了 Substack。我有幸能够领导产品和设计团队，到目前为止，这段经历非常愉快。

---

### [00:06:57] Lenny

**English:**
Before your startup, you're at Facebook for a number of years, is that right?

**中文翻译:**
在你创业之前，你在 Facebook 工作了几年，对吧？

---

### [00:07:00] Sachin Monga

**English:**
Yes. I started in 2011 there on the growth team and had the chance to work on a bunch of different teams there, growth, platform, ads, and then eventually the team we called Sharing, which was helping people share more in the main Facebook app.

**中文翻译:**
是的。我 2011 年加入 Facebook 的增长团队，之后有机会在多个不同的团队工作，包括增长、平台、广告，最后是一个我们称之为“分享”（Sharing）的团队，负责帮助人们在 Facebook 主应用中分享更多内容。

---

### [00:07:12] Lenny

**English:**
Sweet. I want to spend a little time on that, but coming back to Substack, I'm curious just how the product team runs. How many PMs do y'all have? How is it structured? How are you thinking it'll evolve as you scale? What can you share there?

**中文翻译:**
太棒了。我想在那上面花点时间，但回到 Substack，我很好奇你们的产品团队是如何运作的。你们有多少个产品经理（PM）？结构是怎样的？随着规模的扩大，你认为它会如何演变？你能分享一下吗？

---

### [00:07:25] Sachin Monga

**English:**
Sure. Maybe to start from when I started at Substack, we had zero PMs. We had a handful of designers. We had maybe 15 or so engineers. I think we're coming to the close of this kind of one-time inflection point of becoming a product driven company and having a product process and structure and PMs and full stack product teams. When I started at Substack, there was really not much of this. We're still pretty early, but we have something going now.

**中文翻译:**
当然。也许可以从我刚加入 Substack 时说起，那时我们一个 PM 都没有。我们只有几个设计师，大约 15 个左右的工程师。我认为我们正接近完成一个“一次性拐点”，即转变为一家产品驱动型公司，拥有产品流程、结构、PM 和全栈产品团队。我刚开始在 Substack 工作时，这些几乎都不存在。我们现在仍处于早期阶段，但已经初具规模了。

---

### [00:07:51] Sachin Monga

**English:**
We have four product managers in addition to myself, and we have three essentially kind of full stack product teams now that have a PM and an engineering manager, a data person or a designer, engineers and things are starting to roll. We're finally emerging from this transition phase and it's been super fun.

**中文翻译:**
除了我之外，我们还有四名产品经理，现在我们有三个基本上是全栈的产品团队，每个团队都有一名 PM、一名工程经理、一名数据人员或设计师，以及工程师，一切都开始步入正轨。我们终于走出了这个过渡阶段，这非常有趣。

---

### [00:08:10] Lenny

**English:**
What are these three teams?

**中文翻译:**
这三个团队分别是什么？

---

### [00:08:11] Sachin Monga

**English:**
The three teams are: we have a writer team that serves writers, we have a reader team that serves readers, and we have a growth team that does growthy things. I should mention, we have a fourth engineering team that's like the systems team that doesn't have a product manager on it, but is keeping the lights on and helping us scale.

**中文翻译:**
这三个团队是：服务作者的作者团队（Writer team），服务读者的读者团队（Reader team），以及负责增长相关事务的增长团队（Growth team）。我应该提一下，我们还有第四个工程团队，类似于系统团队，它没有配备产品经理，但负责维持系统运行并帮助我们扩展。

---

### [00:08:28] Lenny

**English:**
Awesome. That makes sense. You currently align it around the type of user plus the platform stuff. Do you have a sense of where this might evolve over the next few years just structure wise? Do you think it'll stick to that? Do you have a plan of how this might radically shift as you grow?

**中文翻译:**
太棒了。这很有道理。你们目前是围绕用户类型加上平台事务来调整结构的。你对未来几年在结构上可能如何演变有感觉吗？你认为会坚持这种结构吗？你有没有计划随着增长，这种结构可能会发生激进的转变？

---

### [00:08:43] Sachin Monga

**English:**
Yeah. I'm actually kind of shocked that it's lasted this long and stayed consistent. I remember at Facebook, we would change our team structure what felt like every three months or six months and just have a reorg every once in a while. Part of why I think it's remained pretty consistent is exactly what you mentioned, which is the teams aren't oriented around product surfaces. We don't have a team that's like the app team or a team that's like the dashboard team or the podcasting team. We have teams that are oriented around customers and solving bit of a timeless customer problem. We'll never be done serving writers.

**中文翻译:**
是的。实际上我也挺惊讶这种结构能维持这么久并保持一致。我记得在 Facebook，我们感觉每三个月或六个月就会调整一次团队结构，时不时就来一次重组（reorg）。我认为它之所以能保持一致，部分原因正是你提到的：团队不是围绕“产品表面”组织的。我们没有所谓的“App 团队”、“仪表板团队”或“播客团队”。我们的团队是围绕客户和解决某种“永恒的客户问题”来组织的。我们服务作者的工作永远不会结束。

---

### [00:09:16] Sachin Monga

**English:**
We just started honestly having a concerted focus on serving readers. Growth is never a problem that you check the box off on. I hope that we are able to maintain this general structure. I think as Substack grows and expands, I'm sure we'll have more than three teams. This is where we're at right now, but I really like the focus on a customer and a timeless mission really rather than orienting around what might be a bit more of an ephemeral surface area or product de jour.

**中文翻译:**
老实说，我们才刚刚开始集中精力服务读者。增长也永远不是一个可以“勾选完成”的任务。我希望我们能够维持这种总体结构。我想随着 Substack 的成长和扩张，我们肯定会有超过三个团队。这是我们目前的现状，但我真的很喜欢这种专注于客户和永恒使命的方式，而不是围绕那些可能比较短暂的功能领域或“当日热门产品”来组织。

---

### [00:09:46] Lenny

**English:**
Awesome. Shout out to the writer team. Thanks for building all the awesome stuff that I get to use. It makes sense why you are more recently investing in the reader team because Substack has this magical advantage platforms have where your supply drives all your demand. I go out and promote my newsletter, people sign up for Substack. It makes sense why there's not initially a huge focus on the demand growth, but makes sense to get there. It sounds like your app is awesome.

**中文翻译:**
太棒了。向作者团队致敬，感谢你们构建了我正在使用的所有出色功能。你们最近开始投资读者团队也是有道理的，因为 Substack 拥有平台特有的神奇优势：供应驱动需求。我出去推广我的 Newsletter，人们就会注册 Substack。这解释了为什么最初没有把重点放在需求增长上，但现在开始关注也是合理的。听起来你们的 App 很棒。

---

### [00:10:11] Lenny

**English:**
One thing I wanted to touch on is you're kind of in this interesting position as a head of product at a small-ish company with a founder who's very product sense strong, and that's a classic challenge for a product leader to be in, where it's a smallish company, either a first PM or even a head of product, where the founder's very opinionated about the product. I'm curious what you've learned about how to work in that environment as a PM.

**中文翻译:**
我想谈的一点是，你处于一个非常有趣的位置：在一家规模较小的公司担任产品负责人，而创始人又具有非常强的产品感。对于产品领导者来说，这是一个经典的挑战——在一家小公司，无论是作为第一名 PM 还是产品负责人，创始人对产品都非常有主见。我很想知道，作为一名 PM，你在这种环境下学到了什么。

---

### [00:10:36] Sachin Monga

**English:**
That's a great question. I don't know if I have the recipe for this, but I can just maybe share a few of the things that come to mind. I think the first thing was really treating my role in the beginning more as a facilitator than a decision maker when it comes to product. I think the team was also small enough that everyone in theory could have a good sense of what everyone else was up to. A specific problem we had I think when I joined was that we were just getting to the point where we wouldn't have one weekly meeting where Chris could be in the room, Chris is the CEO of Substack and the person you're mentioning, and decide what we're doing in the next two weeks.

**中文翻译:**
这是一个好问题。我不知道我是否有现成的秘诀，但我可以分享一些想到的点。我认为第一件事是，在开始阶段，在涉及产品时，更多地将我的角色视为“协调者”而非“决策者”。我认为当时团队足够小，理论上每个人都能很好地了解其他人在做什么。我加入时遇到的一个具体问题是，我们正处于一个转折点：不再能通过一个有 Chris（Substack 的 CEO，也就是你提到的那位）在场的周会来决定未来两周要做什么。

---

### [00:11:13] Sachin Monga

**English:**
We were just emerging from that phase. We had this problem which was all of a sudden, Chris didn't really know what all the teams were doing and the teams didn't really know what Chris had in mind for what they should do and what the vision was. We were hiring really quickly and hiring people who might not have all of the context of being in the room with him for years and being in all of the all-hands meetings. When I first joined, I felt like my main role was actually just solving that. And if nothing else, if Chris could have a really good sense of what all the teams are doing and if the teams knew where he was coming from and could start to get better at modeling him and his vision, that would be a win.

**中文翻译:**
我们当时正处于那个阶段的末尾。我们面临的问题是：突然之间，Chris 不太清楚所有团队在做什么，而团队也不太清楚 Chris 对他们的期望以及愿景是什么。我们招聘速度很快，新员工可能没有那种与他共事多年、参加过所有全员会议的背景信息。当我刚加入时，我觉得我的主要角色其实就是解决这个问题。如果 Chris 能清楚地了解团队动态，而团队也能理解他的出发点并开始更好地模拟他的思维和愿景，那就是胜利。

---

### [00:11:43] Sachin Monga

**English:**
For the first couple months I'd say, that was all I tried to do. I think now Chris and I have some reps under our belt and the teams have some reps under their belts too, and that trust just starts to form. We start the week, Chris and I, we sit down for an hour. We go through what do we feel like are the big problems to focus on this week, what are the things we're worried about. We sit down at the end of the week and we check in again. There's just a lot of open communication. I think that helps a lot.

**中文翻译:**
在最初的几个月里，这就是我尝试做的全部。我想现在 Chris 和我之间已经有了一些默契，团队也有了经验，信任感就开始建立了。我们每周开始时，Chris 和我会坐下来聊一个小时。我们会讨论本周需要关注的重大问题是什么，我们担心的事情是什么。周末我们还会再次坐下来沟通。这里有很多开放的交流，我认为这非常有帮助。

---

### [00:12:07] Lenny

**English:**
Got it. It sounds like the core of this is building trust, which makes sense. The way that you've been building trust, one is just do it again and again and then Chris starts to trust, "Okay, Sachin's going to do the things that I think are probably the right things." And then you said you have this weekly meeting. Is there anything else that either tactically you find as a really important component of this relationship or any other lessons you've learned about just how to keep this relationship healthy and constructive?

**中文翻译:**
明白了。听起来核心是建立信任，这很有道理。你建立信任的方式，一是通过一次又一次的实践，让 Chris 开始相信：“好吧，Sachin 会做我认为正确的事情。”然后你提到了周会。在战术上，你是否发现还有其他重要的组成部分，或者关于如何保持这种关系健康且建设性的其他经验？

---

### [00:12:34] Sachin Monga

**English:**
One thing that I think about a little bit because like any startup, there's going to be times that are really difficult, times that are really fun. Substack is certainly going through this really transformative time, but we're really evolving in a lot of ways from a tool into a network. We're in the thick of seeing this vision through in a lot of ways Chris has had in his mind for five years. We did a thing at an all-hands a little while ago where Substack went through Y Combinator I think it was maybe now six years ago and we watched the 60 second demo they pitched from 2017.

**中文翻译:**
我思考的一件事是，像任何初创公司一样，总会有非常艰难的时刻，也会有非常有趣的时刻。Substack 确实正在经历这个变革时期，我们在很多方面正从一个“工具”演变为一个“网络”。我们在很多方面正处于实现 Chris 脑海中构思了五年的愿景的关键阶段。不久前我们在全员会议上做了一件事：Substack 大约六年前参加了 Y Combinator，我们观看了他们 2017 年投递的 60 秒演示视频。

---

### [00:13:04] Sachin Monga

**English:**
What was so cool about that was we're actually doing all those things now that Chris got up on stage and talked about like, "One day in the future, Substack is going to get into podcasting, and we're going to have this network effect that helps writers grow by virtue of there being other writers in the platform." There's all these things that we kind of couldn't do until we earned our place at the table and the right to be able to do those things that we're doing now. To go back to your question, I think a thing that I really try to be mindful of right now is, how do I catch up?

**中文翻译:**
最酷的地方在于，我们现在实际上正在做 Chris 当年上台所说的所有事情，比如：“未来的某一天，Substack 将进入播客领域，我们将拥有这种网络效应，通过平台上的其他作者来帮助作者成长。”有很多事情，直到我们赢得了在牌桌上的位置和做这些事情的权利，我们才能开始做。回到你的问题，我认为我现在非常注意的一点是：我该如何“赶上”？

---

### [00:13:35] Sachin Monga

**English:**
Chris has been thinking about this problem for five times as long as I have. If I can get a good sense of where his vision starts from and catch up those few years and help the teams do the same, that'll go a long way. Because at the same time, everyone now is coming at it from a different perspective. We've a lot more data and evidence. It's really good to have people on the team that have come from other companies and comply that perspective. It's a lot of, again, facilitation and I view that as a big part of my role.

**中文翻译:**
Chris 思考这个问题的时间是我的五倍。如果我能很好地理解他的愿景从何而来，补上那几年的差距，并帮助团队也做到这一点，那将大有裨益。因为与此同时，现在每个人都从不同的角度来看待问题。我们有了更多的数据和证据。团队中有来自其他公司的人并提供不同的视角是非常好的。这再次涉及大量的协调工作，我认为这是我角色的重要组成部分。

---

### [00:14:01] Lenny

**English:**
Awesome. I'm curious, what are the biggest challenges with being in the position you're in? Are there any examples of a man that sucked? Or if you want to go in a different direction, is there a certain type of person that just isn't a good fit for this kind of role, had a product at a smallish company with a very product minded founder?

**中文翻译:**
太棒了。我很好奇，在你这个位置上最大的挑战是什么？有没有什么让你觉得“天哪，这太糟糕了”的例子？或者换个方向，是否有一种特定类型的人根本不适合这种角色——即在一家拥有非常有产品头脑的创始人的小公司担任产品负责人？

---

### [00:14:19] Sachin Monga

**English:**
Oh, let's start with the first one. I think the biggest challenge with this role/company phase, like I mentioned, we're going through this one-time transition from not really having a product function or a product process to having one, is almost by definition any time you figure out how to do a thing, you'll now reach this next phase of growth and it'll be obsolete. Something that I've repeated a bunch of the teams is I'm never too worried if we have the perfect planning process or the perfect execution cadence or the perfect communication process, whatever our process is, we're never going to have a perfect one.

**中文翻译:**
噢，让我们从第一个问题开始。我认为这个角色/公司阶段最大的挑战是，正如我提到的，我们正在经历从没有产品职能或流程到建立流程的转型。几乎从定义上讲，每当你弄清楚如何做一件事时，你就会进入下一个增长阶段，而之前的方法就会过时。我向团队重复过很多次：我从不担心我们是否拥有完美的规划流程、完美的执行节奏或完美的沟通流程。无论我们的流程是什么，我们永远不会有一个完美的流程。

---

### [00:14:52] Sachin Monga

**English:**
And even if we did, it would soon be obsolete because we did a really good job and now we've grown 2X or something and we have more people and the process needs to change. The main thing I care about is are we just getting better every week, every month, certainly every year. I think that's easier said than done. It sounds good in theory, but then when you're in the thick of it. you're constantly basically feeling like you don't know how to do the thing. Because as soon as you figure it out, it's obsolete. It's just really hard. I think that's true of basically just startups in general, high growth companies. Doing the thing well means that you're not going to know what you're doing.

**中文翻译:**
即使我们有了完美的流程，它很快也会过时，因为我们做得很好，现在规模扩大了两倍，人更多了，流程必须改变。我最关心的是我们是否每周、每月、每年都在变得更好。我认为这说起来容易做起来难。理论上听起来不错，但当你身处其中时，你基本上会不断感到自己不知道该怎么做。因为一旦你弄清楚了，它就过时了。这真的很辛苦。我认为这基本上是所有初创公司、高增长公司的通病。把事情做好意味着你将处于一种“不知道自己在做什么”的状态。

---

### [00:15:24] Sachin Monga

**English:**
Maybe that leads into my answer to the second question, which is that's not really for everyone. I think there's almost like a personality type that has to be okay with being humbled all the time and feeling like you don't know what you're doing. I think you could be an amazing product manager at a company that is a bit more stable and consistent and get really good at what you're doing and someone who's going to be really good at a company that is on a bit of this trajectory, for folks who aren't watching the video, making a motion with my hand, that's not growing too fast, it's kind of a different job. The rate of change is a huge factor.

**中文翻译:**
这也许引出了我对第二个问题的回答，即这种工作并不适合所有人。我认为这几乎需要一种特定的人格类型，必须能够接受不断被“打击”，并接受那种觉得自己不知道在做什么的感觉。你可能在一家相对稳定、一致的公司里是一名出色的产品经理，并且对自己的工作非常精通；但在一家处于这种轨迹（我正用手势比划，指增长极快）的公司里，那是完全不同的工作。变化的速率是一个巨大的因素。

---

### [00:16:03] Lenny

**English:**
The point you made about how things are going to keep changing as you grow is such an important point that I don't feel like comes up as much as I thought would come up on this podcast. People are always asking me for advice. How do I structure my product team? How do I prioritize? How do I do planning? The main thing I've learned is no matter what you end up with, it's going to change in three to six months anyway because you'll learn more. The advice is just do the best thing you can think of right now. Don't assume this will last anyway, and that's good enough. There's never the perfect way to do it. It's always the best way you could do it at this moment, and then you learn how to evolve it.

**中文翻译:**
你提到的关于事情会随着增长而不断变化这一点非常重要，我觉得在我的播客中这一点出现的频率没有我想象的那么高。人们总是向我寻求建议：我该如何构建产品团队？如何确定优先级？如何做计划？我学到的最主要的一点是，无论你最终采用什么方案，三到六个月后它都会改变，因为你会学到更多。建议就是：做你现在能想到的最好的事情。不要假设这会永远持续下去，这就足够了。永远没有完美的方法，只有在这一刻你能做出的最佳选择，然后你再学习如何去演进它。

---

### [00:16:35] Sachin Monga

**English:**
100% agree.

**中文翻译:**
百分之百同意。

---

### [00:16:37] Lenny

**English:**
You worked at Facebook for I think it was seven years. I'm curious what were you able to take from that experience about how Facebook, in a massive company like that, builds product to a smaller company like Substack. What translates well and then what just doesn't?

**中文翻译:**
你在 Facebook 工作了大约七年。我很好奇，你能从 Facebook 这样的大公司构建产品的经验中，带给像 Substack 这样的小公司什么？哪些是可以很好转化的，哪些又是行不通的？

---

### [00:16:51] Sachin Monga

**English:**
Over time, I'm finding that less translates than I thought. I don't know how much of that has to do with Facebook specifically though. I'll maybe mention one thing. Working on the core Facebook app, which was what I was working on for the bulk of my time there, Facebook may be the most extreme example of trying to solve so many different problems for so many different people in one tiny rectangle basically, that a big part of the product manager's job in a situation like that is going to be managing trade-offs. It's a super fascinating intellectual problem.

**中文翻译:**
随着时间的推移，我发现能转化的东西比我想象的要少。不过我不知道这在多大程度上与 Facebook 本身有关。我可能想提一件事：在 Facebook 主应用工作（这是我大部分时间所在的地方），Facebook 可能是最极端的例子——试图在一个小小的矩形框里为这么多不同的人解决这么多不同的问题。在这种情况下，产品经理很大一部分工作就是管理“权衡”（trade-offs）。这是一个超级迷人的智力难题。

---

### [00:17:22] Sachin Monga

**English:**
I think going back to the previous point, a lot of people really thrive in that kind of environment, where if we do this thing really well, it is going to directly trade-off against doing this other thing. It's not even a sequencing thing. When you think about prioritization, sometimes you think, we will do this, and then we'll do this, and then we'll do this. In Facebook's case, sometimes it's, "Oh, if we do this, we just can't do this. It's going to be bad for this other thing. If we put a watch tab at the bottom, will that mean that people don't get a marketplace tab? What does that mean for this whole org and what the product is?" I think when it comes to something like prioritization, it's a very different ballgame.

**中文翻译:**
回到之前的观点，很多人在那种环境下如鱼得水，即如果我们把这件事做得非常好，它会直接牺牲掉另一件事。这甚至不是一个先后顺序的问题。当你考虑优先级时，有时你会想：我们会先做这个，然后做那个。但在 Facebook 的案例中，有时是：“噢，如果我们做这个，我们就根本不能做那个。这对另一件事会有负面影响。如果我们把 Watch 标签放在底部，是否意味着人们就看不到 Marketplace 标签了？这对整个组织和产品意味着什么？”我认为在优先级排序方面，这是完全不同的游戏规则。

---

### [00:17:56] Sachin Monga

**English:**
There's certainly some things that are consistent. You generally want to prioritize things that are going to be high impact, low effort. These types of product management frameworks, I think a lot of it can hold constant. But when you really get into the object level like what does your day look like, I think being a PM at a high growth... I can't generalize this, but the job at Substack right now, it looks quite different than what I recognized as my job from Facebook circa 2018. I think it's maybe even gotten more the case that the PM's job in a situation like that will be navigating these types of internal trade-offs. I think on something like prioritization, very different.

**中文翻译:**
当然，有些东西是一致的。你通常希望优先处理那些高影响力、低成本的事情。这类产品管理框架在很大程度上是通用的。但当你真正深入到执行层面，比如你的一天是怎么过的，我认为在高增长公司的 PM……我不能一概而论，但 Substack 目前的工作与我 2018 年左右在 Facebook 的工作看起来大不相同。我想在那种大公司环境下，PM 的工作更多地变成了处理这些内部权衡。在优先级排序上，两者非常不同。

---

### [00:18:31] Lenny

**English:**
Just to double click on that a little bit, the main difference you're saying is that at a Facebook, it's not like whether we do a thing, it's just like what comes first, second, third. At a Substack, it's like we probably won't get to this for a year if we don't prioritize it now. Is that how you think about it, just like the time scale on your trade-offs?

**中文翻译:**
稍微深入探讨一下，你说的主要区别是：在 Facebook，不是“做不做”的问题，而是“第一、第二、第三步做什么”的问题。而在 Substack，如果你现在不优先处理某件事，可能一年内都轮不到它。你是这样想的吗，就像是权衡的时间尺度不同？

---

### [00:18:46] Sachin Monga

**English:**
No. I think actually at Facebook, it's not necessarily whether we do a thing. It's not like we do this now or we do this later. It's doing this thing might mean we can't do this other thing at all, or it'll mean that instead of that chart being steady until we make the number go up, it might go down. By doing A, it might mean B is harder to do forever. Whereas at a startup, a lot of it is time. Time is the main variable. We can do this now and that means that we can't do this other thing until later. There's also an element of sequencing that matters I think a lot at a company like Substack that is in this formative stage of becoming an entirely new thing in a lot of ways.

**中文翻译:**
不，我认为在 Facebook，不一定是“做不做”的问题。不是“现在做还是以后做”，而是“做这件事可能意味着我们根本不能做另一件事”，或者意味着某个图表原本很平稳，结果因为这件事而下跌。做了 A，可能意味着 B 永远变得更难做了。而在初创公司，很大程度上是时间问题。时间是主要变量。我们现在做这个，意味着那个要推迟。此外，我认为在像 Substack 这样处于“成型阶段”的公司，执行顺序（sequencing）非常重要，因为它在很多方面正在变成一个全新的事物。

---

### [00:19:21] Sachin Monga

**English:**
Substack started off like a single player tool for writers. It was like software for writers. If you describe Substack now as simply a newsletter tool, that would be reductive. It's really now much more of this ecosystem that's evolving in all sorts of interesting ways. There is a bit of an order of operations at play here where doing something right now might unlock our ability to do something later. That matters a lot in a situation like we're in at Substack.

**中文翻译:**
Substack 最初像是作者的“单机工具”，是为作者准备的软件。如果你现在把 Substack 仅仅描述为一个 Newsletter 工具，那就太片面了。它现在更像是一个以各种有趣方式演进的生态系统。这里存在一种“操作顺序”，即现在做某件事可能会开启我们以后做另一件事的能力。在我们 Substack 所处的这种情况下，这非常重要。

---

### [00:19:49] Lenny

**English:**
Got it. Essentially there's a lot more one-way doors at a larger company. Here, you can make decisions more quickly partly, but also you can go back and there's not all these second order effects of decision you're making.

**中文翻译:**
明白了。本质上，大公司有更多的“单向门”（不可逆决策）。在这里，一方面你可以更快地做决定，另一方面你也可以回头，而且你的决定不会产生那么多复杂的二阶效应。

---

### [00:20:00] Sachin Monga

**English:**
I think that's right, or at least there are different types of second order effects.

**中文翻译:**
我认为是对的，或者至少二阶效应的类型不同。

---

### [00:20:03] Lenny

**English:**
Got it. I know at Substack writers are like the beacon and the vision of making writers successful, helping people make a living writing. I imagine writers are the North Star or helping writers be successful, but is there anything where you can share about how you prioritize things that you work on within Substack? How do you think about the North Star?

**中文翻译:**
明白。我知道在 Substack，作者就像是灯塔，愿景是让作者成功，帮助人们通过写作谋生。我猜作者就是你们的“北极星”，或者说帮助作者成功就是目标。但你能分享一下你们在 Substack 内部是如何确定工作优先级的吗？你们是如何思考北极星指标的？

---

### [00:20:20] Sachin Monga

**English:**
Going back to your question about Chris too, I think Chris and Hamish and Jay, the founders I think really start from a place of principle in a lot of ways. Why are we even doing this thing? It's not just to help writers make money. It's not just to unlock these cool things. It starts with an opinion for how the internet should work, where people should be in control over their destiny to a much greater extent than has ever really been the case over at least the last 10, 15 years, where all of a sudden, everyone just started spending all of their time in a handful of these public squares that were powered by ads.

**中文翻译:**
回到你关于 Chris 的问题，我认为 Chris、Hamish 和 Jay 这几位创始人，在很多方面真的是从原则出发的。我们为什么要干这件事？不仅仅是为了帮作者赚钱，也不仅仅是为了开启这些酷炫的功能。它始于对互联网应该如何运作的一种观点：人们应该在更大程度上掌控自己的命运，而不是像过去 10 到 15 年那样——突然之间，每个人都开始把所有时间花在少数几个由广告驱动的“公共广场”上。

---

### [00:20:57] Sachin Monga

**English:**
When you think about what that means for Substack right now, that that means writers are in control over being able to deliver their best work on their terms to their audience, make money directly from their subscribers, and also that readers should be in control over their experience. When you show up to Substack.com, that experience should be something that you have a much greater degree of agency over or if you download the app than if you maybe opened up TikTok or something.

**中文翻译:**
当你思考这对现在的 Substack 意味着什么时，它意味着作者可以按照自己的方式向受众交付最好的作品，直接从订阅者那里赚钱；同时也意味着读者应该掌控自己的体验。当你访问 Substack.com 或下载 App 时，那种体验应该让你拥有比打开 TikTok 之类的应用大得多的自主权。

---

### [00:21:20] Sachin Monga

**English:**
I think where that leads you down from a prioritization standpoint is often starting from, okay, if we could do something in a bunch of different ways, is there a way that provides more control to the writer or more control over the experience that the reader has to them? Is there a way that provides much less control? All things equal, do the one that holds constant this principle of control. We could talk about a few other examples like this, but I think from a prioritization standpoint and from a strategic standpoint, Substack is a pretty principled company, and I think it's been really fun and interesting to get to work in an environment like this and also see how it actually can work.

**中文翻译:**
我认为从优先级排序的角度来看，这通常会引导你思考：如果我们可以用多种方式做一件事，是否有一种方式能给作者更多的控制权，或者给读者更多的体验控制权？是否有一种方式提供的控制权要少得多？在其他条件相同的情况下，选择那个坚持“控制权”原则的方案。我们可以谈谈其他类似的例子，但从优先级和战略的角度来看，Substack 是一家非常有原则的公司。在这样的环境下工作，并看到这些原则如何真正发挥作用，是非常有趣且有意义的。

---

### [00:21:57] Sachin Monga

**English:**
You are excited about recommendations, the recommendations feature, and we can talk about that in more detail. I think that's a good example where there's certainly a way to do that where writers have the max amount of control. We picked that way even if it might seem harder to pull off. And then that feedback loop of, "Oh, that actually worked," is really awesome to get to experience.

**中文翻译:**
你对推荐功能（Recommendations）很感兴趣，我们可以详细聊聊。我认为这是一个很好的例子：肯定有一种方式可以让作者拥有最大的控制权。即使这种方式看起来更难实现，我们也选择了它。然后，那种“噢，这真的行得通”的反馈循环，体验起来真的很棒。

---

### [00:22:17] Lenny

**English:**
Yes, I definitely wanted to talk about this recommendation feature. I feel like it's maybe the most underappreciated radical shift in Substack and just platforms in general. I think this is going to go down as one of the most legendary impactful features of any platform or marketplace. I'm just putting this out there. It's such a huge deal and I don't think people appreciate this. Just to quickly summarize what this is, essentially you allowed writers like me to recommend other newsletters that I specifically pick. I pick 10 newsletters that I think are awesome. Once someone subscribes to my newsletter, they see these 10 as, "Hey, you should check these out. I think these are awesome."

**中文翻译:**
是的，我绝对想谈谈这个推荐功能。我觉得这可能是 Substack 乃至整个平台领域中最被低估的激进变革。我认为这将作为任何平台或市场中最具传奇色彩和影响力的功能之一载入史册。我就是这么认为的。这是一件大事，但我觉得人们还没有充分意识到它的价值。简单总结一下：本质上，你们允许像我这样的作者推荐我专门挑选的其他 Newsletter。我选出 10 个我觉得很棒的 Newsletter。一旦有人订阅了我的 Newsletter，他们就会看到这 10 个推荐：“嘿，你应该看看这些，我觉得它们很棒。”

---

### [00:22:55] Lenny

**English:**
It's very curated. There's no algorithm involved, which to your point is Substack's I think vision and mission is just avoid algorithms as much as possible. The reason I think this is crazy and amazing is at this point, 70% of my growth is coming from this one feature. There's something like 500 other newsletters recommending me. As soon as the feature launched and you look at my growth chart, it's just a hockey stick starting that day. I don't think people appreciate this enough, and I'm really excited to just chat about how this feature came to be.

**中文翻译:**
这是高度人工筛选的，没有算法参与。正如你所说，我认为 Substack 的愿景和使命就是尽可能避免算法。我认为这很疯狂也很神奇的原因是，目前我 70% 的增长都来自这一个功能。大约有 500 个其他的 Newsletter 在推荐我。该功能一上线，你看我的增长图表，从那天起就是一个“曲棍球棒”式的飙升。我觉得人们对这个功能的重视程度还不够，我非常兴奋能聊聊这个功能是怎么诞生的。

---

### [00:23:26] Lenny

**English:**
Coming back to a point we talked about earlier of Chris having a very strong opinion about how to build product, something I heard through a birdie is that Chris was not excited about this feature when it was proposed and it took a bit of pushing to get it out. Maybe we start there. How did this come to be?

**中文翻译:**
回到我们之前讨论的 Chris 对构建产品有非常强烈的主见这一点，我听小道消息说，当初提议这个功能时，Chris 并不兴奋，花了不少力气才推行下去。也许我们可以从这里开始，它是怎么诞生的？

---

### [00:23:39] Sachin Monga

**English:**
Sure. The way it came to be was that we noticed this organic behavior emerging, which was that a lot of readers of Substacks were starting to discover Substacks, but the way that was happening was typically through the lens of that original writer. This could happen in a bunch of different ways, right? I think you've used the guest post feature to have guests write post on your newsletter. Obviously that is a really good way for your readers to go and discover some of these other writers in a way that you're curating. There's some less obvious ways that this happens too.

**中文翻译:**
当然。它的诞生是因为我们注意到了一种自发的行为：很多 Substack 的读者开始发现其他的 Substack，但这种发现通常是通过“原始作者”的视角发生的。这可以通过多种方式实现，对吧？我想你用过“客座文章”（guest post）功能，让嘉宾在你的 Newsletter 上写文章。显然，这是一种非常好的方式，让你的读者通过你的筛选去发现其他作者。还有一些不太明显的方式。

---

### [00:24:10] Sachin Monga

**English:**
If you have comments on, which I think you do, if I scroll down and click on the profile of someone who's commenting on your post, it'll show me the other Substack that person reads too. Again, this is a very personalized and very writer centric way of doing discovery. At the same time, we talked about the supply and demand side of the marketplace. The supply side of Substack has just grown over time consistently to the point where now there's a huge amount of amazing writers on the platform and a huge number of collective readers on the platform too that we knew that this sort of like cross-pollination, this discovery loop could be a really powerful thing.

**中文翻译:**
如果你开启了评论（我想你开了），如果我向下滚动并点击某个评论者的个人资料，它也会显示该人阅读的其他 Substack。同样，这是一种非常个性化、以作者为中心的发现方式。与此同时，我们谈到了市场的供需双方。Substack 的供应端一直在持续增长，现在平台上已经有大量优秀的作者和庞大的读者群体，我们知道这种“交叉授粉”式的发现循环可能会非常强大。

---

### [00:24:47] Sachin Monga

**English:**
If you'd start from the first principles, you're like, "All right, how do we help readers discover more things?' The most obvious way to do this would be something like, "Here are some Substacks you might. Based on what we know about your reading habits, here's like a few that Substack is just going to recommend you." This is the thing that worked really well. At Facebook in particular, I think when I joined in 2011, it was definitely still during the era... I think Facebook maybe had just over 500 million users and was on this path to a billion and beyond.

**中文翻译:**
如果你从第一性原理出发，你会想：“好吧，我们如何帮助读者发现更多内容？”最显而易见的方法是：“这里有一些你可能喜欢的 Substack。根据我们了解的你的阅读习惯，Substack 会直接推荐几个给你。”这种方法在很多地方都很奏效。特别是在 Facebook，我 2011 年加入时，正处于那个时代……我想 Facebook 当时可能刚刚超过 5 亿用户，正朝着 10 亿甚至更多迈进。

---

### [00:25:13] Sachin Monga

**English:**
This thing that we called PYMK, which was People You May Know, this little unit that would show up in the newsfeed and it would just tell you that eight other people that you obviously know because you have million mutual friends. That kind of thing drove a very non-trivial amount of Facebook growth in the early days. Of course, lots of other products have done things like this. We could have done something like that.

**中文翻译:**
我们称之为 PYMK（你可能认识的人）的功能，就是那个出现在信息流里的小单元，它会告诉你另外八个你显然认识的人，因为你们有成百上千个共同好友。这种东西在早期为 Facebook 带来了非常可观的增长。当然，很多其他产品也做过类似的事情。我们本可以也做那样的事情。

---

### [00:25:32] Sachin Monga

**English:**
But then going back to that principle of like, okay, well, if we were to do that, let's say we were to insert it at the bottom of our post or in an email or something, it's clearly a thing now where the writer who owns that space is not really in control over what the experiences that they're offering their readers. The reader who signed up for Lenny is now seeing these other things that have nothing to do with Lenny. Does that break this control principle, like putting writers in charge, putting readers in charge? Okay, so then back to the drawing board, what would be the most obvious maximal way to just put writers in control? What is the simplest version of this?

**中文翻译:**
但回到那个原则：如果我们那样做，比如把它插入到文章底部或电子邮件里，那么拥有那个空间的作者就无法真正控制他们提供给读者的体验了。订阅 Lenny 的读者现在看到了与 Lenny 无关的其他东西。这是否破坏了“让作者掌控、让读者掌控”的控制原则？好吧，回到草稿箱，最明显的、能让作者拥有最大控制权的方式是什么？最简单的版本是什么？

---

### [00:26:05] Sachin Monga

**English:**
What if we just ask writers, who do you recommend? What if we just put that in the subscribe flow and just made it as simple as possible? I think Chris' reaction to that originally when that idea came up was that's probably just going to be really hard to pull off. There's a lot more things that have to be true. You need writers to opt in. You need to pick good people. You need to find a way to surface those recommendations to the readers in a way that's going to generate a good amount of surface area. I think it was a bit of skepticism that something like that could work, but we tried it and it took off really quickly.

**中文翻译:**
如果我们直接问作者：“你推荐谁？”如果我们直接把它放在订阅流程中，并让它尽可能简单呢？我想 Chris 最初听到这个想法时的反应是：这可能很难实现。需要满足很多前提条件：你需要作者主动加入，你需要挑选合适的人，你需要找到一种方式向读者展示这些推荐，并产生足够的曝光。我想当时大家对这种方式能否奏效是持怀疑态度的，但我们尝试了，它迅速火了起来。

---

### [00:26:39] Sachin Monga

**English:**
There was this virality at play now where when you recommend a bunch of people, those people will get an email that say, "Hey, Lenny's recommending you and here's all the readers that he's sending you." It created this goodwill viral loop, which was really interesting to see play out. I think there was a bunch of interesting lessons in there. We could stick into anything that seems interesting, but I think Chris' skepticism was not, should we do cross-pollination discovery? Clearly this is something that's working, but is this kind of thing going to work given how many steps are required for it to be true that this becomes really impactful? It turned out that it took off way faster than I think we had imagined.

**中文翻译:**
这里产生了一种病毒式传播：当你推荐一群人时，那些人会收到一封邮件说：“嘿，Lenny 正在推荐你，这是他带给你的所有读者。”这创造了一个基于善意的病毒式循环，观察它的运作非常有趣。我认为其中有很多有趣的教训。我们可以深入探讨任何有趣的点，但我认为 Chris 的怀疑并不是“我们是否应该做交叉发现”——显然这是有效的——而是“考虑到要让它产生巨大影响力需要这么多步骤，这种方式真的能行吗？”结果证明，它的爆发速度比我们想象的要快得多。

---

### [00:27:13] Lenny

**English:**
Is there any stats you can share about just the impact it's having, what it's done to Substack?

**中文翻译:**
有没有什么数据可以分享一下它的影响，以及它对 Substack 产生了什么作用？

---

### [00:27:17] Sachin Monga

**English:**
Yeah, sure. Recommendations specifically now have driven in the millions of new subscriptions for writers across the board, across I think like tens of thousands of unique writers that have received subscriptions from the recommendations feature. Of course, recommendations in particular are still just one component in this broader basket of network driven discovery.

**中文翻译:**
是的，当然。具体来说，推荐功能现在已经为全平台的作者带来了数百万次的新订阅，我想有数万名不同的作者通过推荐功能获得了订阅。当然，推荐功能本身只是更广泛的“网络驱动发现”组合中的一个组成部分。

---

### [00:27:39] Sachin Monga

**English:**
I think we recently shared the stat, more than one in three new subscriptions across Substack are coming from the Substack network and around one in 10 paid subscriptions now too. But these numbers are just, as you can imagine, growing up and to the right, getting stronger every day, and I think we'll have some more interesting stats to share on that soon.

**中文翻译:**
我想我们最近分享过一个数据：Substack 上超过三分之一的新订阅来自 Substack 网络，现在大约十分之一的付费订阅也是如此。正如你所料，这些数字正在持续增长，每天都在变得更强，我想我们很快会有更多有趣的统计数据可以分享。

---

### [00:27:58] Lenny

**English:**
Awesome. One thing I wanted to acknowledge, I think some people worry about this feature that it drives lower intent users. I find that not to be true. They're definitely lower intent, but it's not meaningfully and significantly. The fact that 70% of my user growth comes from this feature and my open rates have only come down a little bit, it says a lot about it. It's like useful really in tenfold people as much as it can be from someone that hasn't actually been planning to subscribe and just recently found out about it. It's really impressive how high intent they are all things considered.

**中文翻译:**
太棒了。我想承认一点，我认为有些人担心这个功能会带来意向较低的用户。但我发现事实并非如此。他们的意向确实稍低一些，但并没有达到显著或严重的程度。事实上，我 70% 的用户增长来自这个功能，而我的打开率（open rates）只下降了一点点，这说明了很多问题。对于那些原本没打算订阅、刚刚才发现你的人来说，它的效果非常好。考虑到所有因素，这些用户的意向之高令人印象深刻。

---

### [00:28:31] Sachin Monga

**English:**
You bring up a point too that leads into some of the next things we're thinking about here, which is that right now most of the subscriptions that come from recommendations are coming from one particular flow in the product, which is when someone subscribes to someone else on Substack, they will then see a recommendation for Lenny. It's being serviced to people at a moment where not only are they just hearing about you for the first time, but they might just be hearing about the recommending writer for the first time too. They are new subscribers. They don't have this long standing trusted relationship built up yet.

**中文翻译:**
你提到的这一点也引出了我们正在思考的下一步：目前大多数来自推荐的订阅都源于产品中的一个特定流程，即当有人订阅 Substack 上的其他人时，他们会看到 Lenny 的推荐。它是在人们不仅是第一次听说你，甚至可能也是第一次听说那位推荐作者的时刻展示的。他们是新订阅者，还没有建立起长期的信任关系。

---

### [00:29:04] Sachin Monga

**English:**
Of course, you have people now who've been subscribing to you for years and who trust you greatly and would probably take your recommendation very seriously, but the people that you're recommending are only getting these subscribers at the first moment that someone finds out about Lenny in many cases. A big part of the next step of this product now is thinking about recommendations less as a step of the flow and more like a really interesting social graph that is being built of goodwill and of influence. You now recommend a bunch of other writers. There's much more that could be done in the network than just show some of those writers in the subscribe flow of lennysnewsletter.com.

**中文翻译:**
当然，你现在有一些订阅了你很多年的人，他们非常信任你，可能会非常认真地对待你的推荐。但在很多情况下，你推荐的人只有在别人第一次发现 Lenny 的那一刻才会获得这些订阅者。现在，这个产品的下一步很大程度上是将推荐不再仅仅视为流程中的一个步骤，而是一个正在建立的、基于善意和影响力的有趣的社交图谱。你现在推荐了一群其他作者，在网络中能做的事情远不止在 lennysnewsletter.com 的订阅流程中展示这些作者。

---

### [00:29:43] Sachin Monga

**English:**
There's a lot more we could do there. I'm curious if you have any ideas, but we've got a bunch of ideas that we're cooking up that I think will not only drive more subscriptions, but also probably higher intent ones as well, because these are going to be people that might already have been reading you for years who never right now would know who you're recommending.

**中文翻译:**
我们还有很多可以做的。我很好奇你有没有什么想法，但我们已经酝酿了一堆主意，我认为这些主意不仅会带来更多订阅，而且可能会带来意向更高的订阅，因为这些人可能是已经读了你很多年的人，而他们目前根本不知道你在推荐谁。

---

### [00:29:58] Lenny

**English:**
No great ideas to share. I do find since it's only free subscribers, I have to do more work to upsell them to try paid. On the other hand, having a huge pool of interested people that aren't ready to convert yet is only beneficial. When I send a free post and mention, "Hey, I have a paid subscription. You can get more," it works really well.

**中文翻译:**
没有什么伟大的想法可以分享。我确实发现，由于这些只是免费订阅者，我必须做更多的工作来引导他们尝试付费。另一方面，拥有一个庞大的、虽然还没准备好转化但感兴趣的人群，只有好处。当我发送免费文章并提到“嘿，我有付费订阅，你可以获得更多内容”时，效果非常好。

---

### [00:30:17] Lenny

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals, or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的企业在云端存储任何数据，那么你很可能被问到或将被问到关于 SOC 2 合规性的问题。SOC 2 是证明你的公司采取了适当安全措施来保护客户数据的一种方式，它能建立客户和合作伙伴的信任，尤其是那些有严格安全要求的客户。此外，如果你想向企业销售产品，证明安全性至关重要。SOC 2 既可以为你打开更大、更好交易的大门，也可能让你的业务停滞不前。如果你没有 SOC 2，很有可能你连谈判桌都上不去。

---

### [00:30:56] Lenny

**English:**
Beginning a SOC 2 report can be a huge burden, especially for startups. It's time consuming, tedious, and expensive. Enter Vanta. Over 3,000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny. That's V-A-N-T-A.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
开始一份 SOC 2 报告可能是一个巨大的负担，尤其是对于初创公司。它耗时、乏味且昂贵。Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 来自动化高达 90% 的 SOC 2 相关工作。Vanta 可以在几周而不是几个月内让你准备好接受安全审计，时间不到通常所需的三分之一。在有限的时间内，Lenny 的播客听众可以获得 Vanta 1000 美元的优惠。只需前往 vanta.com/lenny。即 V-A-N-T-A.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### [00:31:34] Lenny

**English:**
Something else I'll mention that I've learned to do is I feel so fortunate being early on Substack and having this thing grow so much, especially from this recommendation feature that I'm actually getting pings from people regularly now of, "Hey, can you recommend my newsletter?" It's like a really good growth hack on Substack right now to try to get a lot of subscribers to recommend you. My system right now is I want to share the wealth as much as I can, so I rotate through different newsletters.

**中文翻译:**
我还想提一点我学到的东西：我觉得自己很幸运能早早加入 Substack，并看到它成长这么多，尤其是通过这个推荐功能。现在我经常收到人们的消息：“嘿，你能推荐我的 Newsletter 吗？”在 Substack 上，尝试让很多订阅者推荐你确实是一个非常好的增长黑客手段。我现在的系统是尽可能地分享财富，所以我会在不同的 Newsletter 之间轮换推荐。

---

### [00:31:59] Lenny

**English:**
I help get them say a thousand subscribers, and then move on to the next one, assuming I like them. It's not just any random user. So I can share the wealth with a lot of different newsletters and give people a platform, because I have this platform now and that's been working really well.

**中文翻译:**
我会帮他们获得大约一千个订阅者，然后转向下一个，前提是我喜欢他们的内容。这不只是针对随机用户。这样我可以与许多不同的 Newsletter 分享财富，并给人们一个平台，因为我现在拥有了这个平台，而且效果一直很好。

---

### [00:32:12] Sachin Monga

**English:**
The Robin Hood of Substack.

**中文翻译:**
Substack 的罗宾汉。

---

### [00:32:14] Lenny

**English:**
Yeah, now I'm going to get all these DMs to recommend people. If I'm unable to, I'm sorry. You talked about how Chris was worried that this would not work. That's interesting. His point of there's so many steps that have to happen for this to be adopted is such a good one. In my experience, getting users to do anything is so hard. To get them to click some buttons and fill things out, that rarely works. It's cool that it really did work.

**中文翻译:**
是啊，现在我肯定会收到一堆求推荐的私信。如果我没法推荐，先说声抱歉。你提到 Chris 曾担心这行不通，这很有趣。他认为要让这个功能被采用需要经过太多步骤，这个观点非常好。根据我的经验，让用户做任何事情都很难。让他们点击按钮、填写信息，这很少能奏效。它真的成功了，这很酷。

---

### [00:32:38] Lenny

**English:**
I think it was part of the early beta, and I found that it was a really thoughtful approach to how it was all rolled out where there was a small group of users and writers that tried it out, see how went, see what the impact was, see if there was any negative impact. Is there anything you could share by just the way this was rolled out that you've learned about how to do this sort of thing?

**中文翻译:**
我想这是早期测试的一部分，我发现它的推出方式非常周到：有一小群用户和作者先试用，看看效果如何，看看影响是什么，看看是否有任何负面影响。关于这种功能的推出方式，你有什么可以分享的经验吗？

---

### [00:32:56] Sachin Monga

**English:**
I mentioned that we're going through this one-time transition of figuring out how to become a product driven company and how to ship products faster, better, et cetera. One of the principles I guess in this playbook that we're trying to write is we call it build with writers, build with readers. In some ways now that I think about it, it's almost like a sub principle of the put readers in charge, put writers in charge. How do you build product responsibly if you care deeply about that? One way to do it would be to almost as a strong default, anytime we're going to make a fundamental change to how Substack works, do it in a way where we bring writers along.

**中文翻译:**
我提到过，我们正在经历一次转型，学习如何成为一家产品驱动的公司，如何更快、更好地发布产品等等。我想在我们尝试编写的这本“剧本”中，有一个原则我们称之为“与作者共同构建，与读者共同构建”。现在想来，这在某种程度上几乎是“让读者掌控，让作者掌控”的一个子原则。如果你深切关注这一点，你该如何负责任地构建产品？一种方法是将其作为一种强有力的默认设置：每当我们打算对 Substack 的运作方式做出根本性改变时，都要以一种能带着作者一起参与的方式来进行。

---

### [00:33:32] Sachin Monga

**English:**
This is still an optional thing. This isn't changing how Substack works for everyone, but this is we think a potentially profound enough thing that the way we did this was not just roll it out for everyone, put a little dialogue in the dashboard that says, "Hey, everyone, now go do this thing," it was like, okay, why don't we call up 10 writers who we think might be interested in this." It's not that hard to just mock up what this could look like, get some feedback. This is the kind of thing that I think a lot of product teams would do. But then maybe a lot of product teams would be like, "Okay, we got good feedback. Let's just build the thing, ship the thing."

**中文翻译:**
这仍然是一个可选方案。它并没有改变 Substack 对所有人的运作方式，但我们认为这可能是一件意义深远的事情，所以我们的做法不是直接向所有人推出，在仪表板上放个对话框说：“嘿，大家，现在去做这件事。”而是：“好吧，我们为什么不给 10 位我们认为可能感兴趣的作者打个电话呢？”制作一个原型并获取反馈并不难。我想很多产品团队都会这样做。但随后，很多产品团队可能会说：“好吧，我们得到了很好的反馈，那就开始构建并发布吧。”

---

### [00:33:59] Sachin Monga

**English:**
Instead, we just ran a little pilot. You and a few other writers were gracious enough to lend your time and talk us through how you would see this working and what you would want. We actually have now we've set up something called the Product Lab, which I'm really excited about. I think you're a part of it. I hope we asked you.

**中文翻译:**
相反，我们只是进行了一个小规模的试点。你和其他几位作者非常慷慨地抽出时间，向我们讲述了你认为这应该如何运作以及你想要什么。实际上，我们现在已经建立了一个名为“产品实验室”（Product Lab）的东西，我对此感到非常兴奋。我想你也是其中的一员，希望我们当时邀请过你。

---

### [00:34:16] Lenny

**English:**
I'm curious to see where this all goes.

**中文翻译:**
我很想看看这一切会走向何方。

---

### [00:34:19] Sachin Monga

**English:**
This is just an invite only little group of a hundred or so writers that we know are interested in being on the bleeding edge of what Substack is becoming. We're investing a lot in just tools to help writers grow. Now we've got this little lab where we can take a feature recommendations to writers and get quick feedback and ensure that we're never just rolling something out to everyone without going through this step first. It's just been super helpful to have a bit of this infrastructure in place. Often the thing that we end up shipping on day one tends to be pretty different from what we had in mind before we went through this process.

**中文翻译:**
这只是一个仅限邀请的小群体，由大约 100 名作者组成，我们知道他们有兴趣站在 Substack 变革的最前沿。我们在帮助作者增长的工具上投入了很多。现在我们有了这个小实验室，我们可以把功能推荐给作者，获得快速反馈，并确保在没有经过这一步之前，我们绝不会直接向所有人推出任何东西。拥有这种基础设施非常有帮助。通常，我们在第一天发布的东西，往往与我们进入这个流程之前所想的截然不同。

---

### [00:34:54] Lenny

**English:**
I've been through a bunch of those experiences and it always goes super well. I've been through a few features that just didn't go anywhere and then they, "Nope, we're going to move on and not try this thing." Something else that always comes to mind with Substack is it's often in the news. Substack is a very popular topic amongst reporters.

**中文翻译:**
我经历过很多次这样的过程，效果总是非常好。我也经历过一些功能最后无疾而终，然后他们说：“不，我们要继续前进，不尝试这个了。”关于 Substack，我总是想到的一点是它经常出现在新闻中。Substack 是记者们非常热门的话题。

---

### [00:35:10] Sachin Monga

**English:**
Writers like to talk about writers.

**中文翻译:**
作者喜欢谈论作者。

---

### [00:35:11] Lenny

**English:**
That's right, especially a platform that might disrupt them someday or friends have gone on and they're maybe jealous about. I'm curious, as a product leader, how you deal with bad press, angry attention, things like that, just keeping people focused, keeping people motivated. Do you discuss stuff? How do you approach stuff that comes out of like, "Oh man," and keep people excited?

**中文翻译:**
没错，尤其是对于一个有一天可能会颠覆他们的平台，或者他们的朋友已经加入其中，他们可能会感到嫉妒。我很想知道，作为一名产品领导者，你如何处理负面报道、愤怒的关注之类的事情，如何让人们保持专注和动力？你会讨论这些事吗？你如何处理那些让人感叹“天哪”的消息，并让大家保持兴奋？

---

### [00:35:33] Sachin Monga

**English:**
The whole thing here is just parsing out the signal from the noise. There's very little chatter in the blogosphere media sphere that would actually impact our day-to-day when I think about it. It's not zero, right? Sometimes there'll be something that ends up blowing up or that people are talking about that we should really take seriously and see how that might impact our strategy. But I'd say 90% of the chatter about Substack is going to probably ultimately just be a distraction to our product team at the end of the day that should just be focused on executing on the vision.

**中文翻译:**
这里的关键在于从噪音中解析出信号。当我思考这个问题时，博客圈和媒体圈的闲言碎语中，很少有真正会影响我们日常工作的。当然，也不是零，对吧？有时会有一些事情闹大，或者人们在讨论一些我们确实应该认真对待的事情，看看它可能如何影响我们的战略。但我敢说，关于 Substack 的闲言碎语中，90% 最终可能只是对我们产品团队的干扰，而团队本应专注于执行愿景。

---

### [00:36:02] Sachin Monga

**English:**
Maybe my skin got thickened from working at Facebook during a bunch of years that... Actually when I started at Facebook, generally things were quite rosy in the press, but we certainly went through a bunch of different phases and a lot of the stuff. I worked on myself that Facebook ended up getting talked about a ton in the press negatively most of the time. You just learn to just keep your heads down and keep shipping. Ultimately, that's all that matters. I feel proud of the way that I think our culture is internally being formed right now. We tend to not get distracted.

**中文翻译:**
也许是因为我在 Facebook 工作的那几年磨练出了“厚脸皮”……实际上，当我刚开始在 Facebook 工作时，媒体上的评价通常都很美好，但我们确实经历了很多不同的阶段。我在 Facebook 负责的很多东西最终在媒体上被大量讨论，而且大部分时间都是负面的。你只需学会埋头苦干，持续发布产品。最终，这才是最重要的。我为我们目前内部形成的文化感到自豪。我们往往不会分心。

---

### [00:36:37] Lenny

**English:**
It seems to be the case. I'm curious where you see Substack going as a product long-term. What are you excited about? Where are things heading?

**中文翻译:**
看起来确实如此。我很想知道你认为 Substack 作为一个产品的长期走向。你对什么感到兴奋？事情正朝着什么方向发展？

---

### [00:36:45] Sachin Monga

**English:**
Maybe I'll answer that in two parts, one from a writer centric lens and one from a reader centric lens, which I mentioned is a bit of a newer thing for us. From a writer centric lens, I really think that we're just starting into this golden era of what it might mean to be a writer on the internet. Like I mentioned before, the economic model for supporting great writing on the internet has been generally pretty terrible for the entirety of the internet's history.

**中文翻译:**
也许我可以分两部分来回答，一部分从以作者为中心的视角，另一部分从以读者为中心的视角（正如我提到的，这对我们来说是一个比较新的领域）。从作者的角度来看，我真的认为我们才刚刚开始进入互联网写作的黄金时代。正如我之前提到的，在整个互联网历史上，支持优秀写作的经济模式通常都非常糟糕。

---

### [00:37:13] Sachin Monga

**English:**
In the early days of Substack, there's a couple of these glimmers of hope where you'd have people like Matt Taibbi or Bill Bishop, some of the early writers on Substack that were really well established writers who were clearly just being undervalued and now could come to Substack and see their true value. That was awesome. That was really cool to see. But in the last year or so, even in the last few months, I think there's been so many really interesting success stories now from writers who might not even consider themselves writers, let alone well established writers like Matt Taibbi or someone like that.

**中文翻译:**
在 Substack 的早期，有一些希望的曙光，比如 Matt Taibbi 或 Bill Bishop，这些早期作者都是非常有成就的作家，他们显然被低估了，现在可以来到 Substack 实现其价值。那太棒了，看到这些真的很酷。但在过去一年左右，甚至就在过去的几个月里，我认为出现了很多非常有趣的成功案例，这些作者甚至可能不认为自己是作家，更不用说像 Matt Taibbi 那样成名的作家了。

---

### [00:37:46] Sachin Monga

**English:**
People who are able to make a living, maybe even make a fortune just doing great work and not needing to have millions and millions of viewers or play the attention games of other networks, but just do really high quality work and have a relatively small number of people value it highly enough to pay for it. That's like a new thing. When I see the next one to two years play out for the writer side of the equation, a lot of what we're going to try to do is just make it much simpler to get started, to have your Substack.

**中文翻译:**
这些人能够维持生计，甚至赚大钱，仅仅是因为他们做出了优秀的作品，而不需要拥有数百万的观众，也不需要去玩其他社交网络的注意力游戏。他们只需创作高质量的内容，并让相对少数的人对其产生足够的认可并愿意为此付费。这就像是一件新鲜事。当我展望未来一两年作者端的发展时，我们要做的很多事情就是让开始创建自己的 Substack 变得更加简单。

---

### [00:38:15] Sachin Monga

**English:**
If you have an audience anywhere, Substack's never going to be the place where have the biggest audience probably, but it certainly should be the place where your most valuable audience comes home to, where they get your best work. We're seeing a lot of really interesting success stories now of people that might have a big Instagram following or YouTube following and certainly Twitter following were able to use Substack now as this home base, this place to try to accumulate their most valuable audience that they own in the sense that they get their email address, they can export them at any time, and just build really simple tools to just help them deliver their best work.

**中文翻译:**
如果你在任何地方拥有受众，Substack 可能永远不会是你拥有最大受众的地方，但它绝对应该是你最有价值的受众“回家”的地方，是他们获取你最好作品的地方。我们现在看到很多有趣的成功案例，那些在 Instagram、YouTube 或 Twitter 上拥有大量粉丝的人，现在能够将 Substack 作为大本营。在这里，他们可以积累自己真正拥有的最有价值的受众——因为他们拥有受众的电子邮件地址，可以随时导出，并且我们可以构建简单的工具来帮助他们交付最好的作品。

---

### [00:38:47] Sachin Monga

**English:**
It could be writing, could be a podcast, could be video. We're investing a lot in some really interesting community features as well. You're a great example of this. To call Lenny's Newsletter simply a newsletter would be hilariously wrong at this point, right? I think you mentioned to me you had 30 meetups around the world last month or something like that.

**中文翻译:**
这可以是写作，可以是播客，也可以是视频。我们还在投入大量精力开发一些非常有趣的社区功能。你就是一个很好的例子。如果现在还把 Lenny's Newsletter 仅仅称为一个 Newsletter，那就大错特错了，对吧？我想你跟我提过，上个月你在全球举办了 30 场线下聚会（meetups）之类的。

---

### [00:39:03] Lenny

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:39:04] Sachin Monga

**English:**
It's an impressive of run rate of meetups. I think seeing that unfold and seeing how the platform can support that type of community behavior as well is a big thing that I'm excited about. Just more. On the reader's side, I think maybe to segue into that, I think we're again entering this little potential golden age of the internet for how you experience it as a consumer. Where instead of just having a handful of feeds that are basically the same, that you could just scroll through and consume videos of random people doing random things. Not to say that's bad and that should go away.

**中文翻译:**
这种聚会的频率非常惊人。我认为看到这一切的展开，以及平台如何支持这种类型的社区行为，是我感到兴奋的一件大事。还有更多。在读者方面，我想以此为过渡，我认为我们再次进入了一个潜在的互联网黄金时代，即作为消费者你如何体验互联网。在这里，你不再只是面对几个基本相同的 Feed 流，只能不断滚动观看随机的人做随机的事。并不是说那不好或者应该消失。

---

### [00:39:37] Sachin Monga

**English:**
I do my fair share of just scrolling through my phone and watching random videos too, but it'd be kind of nice to have another place you could go to as well where the best culture is being made and you have an extreme degree of control over what you see and who you choose to lead into that space. You might not spend two hours a day in there, and that's fine, but it might be the first place you go because it's where all the best stuff is and it's where your best communities are going to live too. We kind of see Substack evolving not as some new type of social media, but true alternative to how you might spend that most valuable slice of your time.

**中文翻译:**
我也会花不少时间刷手机看随机视频，但如果能有另一个地方，那里正在创造最好的文化，而且你对自己看到的内容以及选择谁进入那个空间拥有极高的控制权，那就太好了。你可能每天不会在那里花两个小时，这没关系，但它可能是你第一个想去的地方，因为那里有最好的东西，也是你最好的社区所在地。我们认为 Substack 的演进不是某种新型社交媒体，而是你如何度过那段最有价值时间的真正替代方案。

---

### [00:40:13] Sachin Monga

**English:**
We just launched an iPhone app, I guess now it's been six months ago, and it's going really well. We're going to launch an Android app very shortly. We're pushing really hard on this reader experience as well. I think it'll be radically different and much better one or two years from now too.

**中文翻译:**
我们大约六个月前推出了 iPhone 应用，目前进展非常顺利。我们很快就会推出 Android 应用。我们也在努力提升读者体验。我认为一两年后，它会变得截然不同且好得多。

---

### [00:40:28] Lenny

**English:**
It's been interesting to see a growing percentage of the great content that I come across be on Substack, and so I think that's a cool trend for y'all. For writers that are thinking about starting a newsletter, thinking about joining Substack, what sorts of advice, tips, guidance do you have for folks that are thinking about getting into the Substack world?

**中文翻译:**
看到我接触到的优秀内容中，在 Substack 上的比例越来越高，这很有趣，我认为这对你们来说是一个很酷的趋势。对于那些考虑开始写 Newsletter、考虑加入 Substack 的作者，你对那些想进入 Substack 世界的人有什么建议、技巧或指导吗？

---

### [00:40:50] Sachin Monga

**English:**
My first piece of advice would be to just start it and see what happens. Start it. Have a way to start gathering subscribers. Put a link to it somewhere. Write one or two things. If you're not much of a writer, try posting a video, recording some audio, turn into a little podcast. Just start basically and see what happens and see what kind of interest there might be out there for what you have to say, especially if you already have a following on other platforms as well.

**中文翻译:**
我的第一条建议就是：直接开始，看看会发生什么。开始做，找个方法开始收集订阅者。在某个地方放个链接。写一两篇东西。如果你不擅长写作，试着发个视频，录段音频，把它变成一个小播客。基本上就是先开始，看看会发生什么，看看人们对你想说的话有什么样的兴趣，特别是如果你在其他平台上已经有粉丝的话。

---

### [00:41:17] Sachin Monga

**English:**
I think that there's a real risk that if your entire following is locked into one platform where you don't have a ton of control over, your ability to reach those people deterministically and certainly to monetize that in some way, it seems like it's a tenuous place to be in the current age of the internet. I'd say just start. It should be really easy. Go to Substack.com, press the start your Substack button, and see what happens.

**中文翻译:**
我认为存在一种真正的风险：如果你的所有粉丝都锁定在一个你没有太大控制权的平台上，那么你确定性地触达这些人以及以某种方式变现的能力就会受到限制。在当前的互联网时代，这似乎是一个不稳固的处境。我想说，直接开始吧。这应该很容易。去 Substack.com，点击“开始你的 Substack”按钮，看看会发生什么。

---

### [00:41:41] Lenny

**English:**
That advice may sound to people like, "Oh yeah, that's not actual advice." But I will say that is exactly what I did and that's exactly how I got to what I do now. I had zero intention of ever doing this. Charging for writing that I'm writing, that's crazy. Just the fact that Substack existed and let me try stuff out for free. You sign up. You start it. My newsletter, it's called Lenny's Newsletter because that was like the default recommendation when I signed up, because I told them my name's Lenny and it's like Lenny's Newsletter, because I had no plan to do this. It was just like, let me just sign up and try blogging here for a little bit and that little path.

**中文翻译:**
这个建议对某些人来说可能听起来像“噢，这不算真正的建议”。但我必须说，这正是我所做的，也正是我如何走到今天这一步的。我以前完全没打算做这个。为我写的文章收费？这太疯狂了。但 Substack 的存在让我可以免费尝试。你注册，你开始。我的 Newsletter 叫 Lenny's Newsletter，是因为我注册时那是默认推荐的名字，因为我告诉他们我叫 Lenny，它就自动生成了 Lenny's Newsletter，因为我当时根本没计划。当时只是想，让我注册一下，在这里写一段时间博客试试，就是这样一小段路。

---

### [00:42:21] Lenny

**English:**
I think about Chris and Hamish and the founders mapping out a user journey of a vision of how somebody onboards to Substack, to go from never writing to doing it full-time. I feel like I went through that exactly, if they even had that, where I sign up just to try it out. I start writing consistently. It starts going well, then I think about charging, and then I launch the paid plan, and then that goes well. It keeps growing, and then I do it full-time. That's exactly what I went down and there's no world where I would've done this if not for those magical combination of features of just a really simple blog a d newsletter and collecting emails and maybe monetizing down the road.

**中文翻译:**
我在想 Chris、Hamish 和创始人们是否规划过一个用户旅程的愿景：一个人如何加入 Substack，从从未写作到全职写作。我觉得我完全经历了那个过程（如果他们真的规划过的话）：我注册只是为了尝试，我开始坚持写作，情况开始好转，然后我考虑收费，接着我推出了付费计划，然后进展顺利。它持续增长，最后我开始全职做这件事。这就是我走过的路。如果没有那些神奇的功能组合——一个非常简单的博客和 Newsletter 系统、收集电子邮件的功能以及未来的变现可能——我绝对不会做这件事。

---

### [00:43:01] Sachin Monga

**English:**
Yeah, that's amazing to hear.

**中文翻译:**
是的，听你这么说真是太棒了。

---

### [00:43:03] Lenny

**English:**
I think that just start advice is really spot on. Just try it out, see if it's something you want to do. I will say, it's easy to start a newsletter, it's hard to continue a newsletter. The continuing is the most important part, as Seinfeld would say in that clip, who rings the bell.

**中文翻译:**
我认为“直接开始”的建议非常中肯。试一试，看看这是否是你想要做的事情。我要说的是，开始一个 Newsletter 很容易，但坚持下去很难。坚持是最重要的部分，就像 Seinfeld 在那个片段里说的，“谁能坚持到最后”。

---

### [00:43:17] Sachin Monga

**English:**
I will say though to that point too that I'm really excited for what Substack can do in the product to make that easier in a way that doesn't cheapen the experience. There's a bunch of things we could do to. We could automatically post stuff to your readers. We could do a lot of things. Going back to the how do we do discovery, there's a bunch of things that would probably just work, but they would eventually kill what Substack is or have all these nasty second order effects and ruin this promise of putting writers in charge, putting readers in charge.

**中文翻译:**
关于这一点，我也想说，我非常兴奋 Substack 可以在产品上做些什么，让坚持写作变得更容易，同时又不降低体验的质量。我们可以做很多事情，比如自动向读者推送内容。回到“我们如何做发现”这个问题，有很多方法可能直接见效，但它们最终会扼杀 Substack 的本质，或者产生糟糕的二阶效应，破坏“让作者掌控、让读者掌控”的承诺。

---

### [00:43:45] Sachin Monga

**English:**
I'm really excited and I actually view your Substack as a vanguard, as a very leading edge example of this, of you have turned your Substack into not just this thriving community of readers, but also of contributors and creators. You've got these amazing people coming and doing guest posts. You've got the podcast going. You've got these meetups. You've I think in a lot of ways alleviated the burden of how hard it would be to just be writing a long form thing every day and doing that for the rest of your life. That would be really hard. That would make it certainly much harder to keep going.

**中文翻译:**
我真的很兴奋，实际上我把你的 Substack 视为先锋，一个非常前沿的例子。你不仅把你的 Substack 变成了一个蓬勃发展的读者社区，还变成了一个贡献者和创作者的社区。你有这么多优秀的人来写客座文章，你有播客，你有线下聚会。我认为你在很多方面减轻了那种“余生每天都要写长篇大论”的负担。那会非常辛苦，肯定会让坚持下去变得困难得多。

---

### [00:44:19] Sachin Monga

**English:**
Not to say that it's easy now, I know how hard it is to do what you do. But I think Substack can do more to turn this ecosystem to funnel this energy into ways for people like you to feel more like a leader of a space and a curator in a lot of ways and still deliver this really valuable service to your audience without having to do all the work yourself. I think we can do a lot more to support that kind of thing.

**中文翻译:**
并不是说现在就很容易，我知道你所做的事情有多难。但我认为 Substack 可以做更多工作，将这个生态系统的能量引导到某些方式上，让你这样的人感觉更像是一个空间的领导者和策展人（curator），在不需要亲力亲为所有工作的情况下，依然能为受众提供极具价值的服务。我认为我们可以做更多来支持这类事情。

---

### [00:44:45] Lenny

**English:**
Is there anything you could share about what sorts of things you're thinking there and what might be possible?

**中文翻译:**
关于你正在思考的内容以及未来可能实现的目标，有什么可以分享的吗？

---

### [00:44:49] Sachin Monga

**English:**
Let's see. Guest posts are working really well, and I'll say that we have a bunch of ideas for how to make guest posts a much bigger thing. Right now, the way guest posts work, kind of like an op-ed or something, like you invite someone to come and just write a post on your Substack. I think there's much more we can do without getting into some of the specifics and scooping the product team that we're working on that I think could make it feel more like you've got a bunch of people who are somewhat more fluidly able to contribute to your Substack and deliver value to your audience.

**中文翻译:**
让我想想。客座文章（Guest posts）效果非常好，我想说我们有很多想法可以让客座文章发挥更大的作用。目前客座文章的运作方式有点像特约评论，你邀请某人来你的 Substack 写一篇文章。我认为我们还可以做更多，在不透露具体细节和抢先发布产品团队工作内容的情况下，我认为我们可以让它感觉更像是有一群人能够更灵活地为你的 Substack 贡献内容，并为你的受众提供价值。

---

### [00:45:18] Sachin Monga

**English:**
I've teased this community stuff that we're working on a little bit, but we're piloting a feature right now that's been working really well where writers can get a little bit of like a... We view it as the pub at the back of your Substack where people can hang out and chat and the writer is still in control and sets the tone and sets the rules and norms for the space, but can create space for their subscribers to participate and hang out themselves too. Those are two areas that we're investing in a fair bit right now.

**中文翻译:**
我稍微透露过我们正在开发的社区功能，我们现在正在试点一个效果非常好的功能，作者可以拥有一个……我们把它看作是你 Substack 后院的一个“小酒馆”，人们可以在那里闲逛聊天。作者仍然拥有控制权，设定基调、规则和规范，但可以为订阅者创造一个参与和互动的空间。这是我们目前投入较多的两个领域。

---

### [00:45:45] Lenny

**English:**
Something that I imagine somebody suggested that I'd suggest you all look into a little bit is open AI assisted writing. I was playing with this product that is called Jasper and there's also Copy.ai. I put in the title of the post I was about to write and it just generated a pretty good paragraph summary of what it could have been. They have this whole feature where you just start typing and it autocompletes things smartly.

**中文翻译:**
我想肯定有人建议过，我也建议你们研究一下：OpenAI 辅助写作。我一直在试用一个叫 Jasper 的产品，还有 Copy.ai。我输入了我要写的文章标题，它就生成了一段相当不错的摘要。他们还有个功能，你只要开始打字，它就会智能地自动补全。

---

### [00:46:11] Sachin Monga

**English:**
That's crazy.

**中文翻译:**
那太疯狂了。

---

### [00:46:11] Lenny

**English:**
That would be cool. I don't know if you want to go there, but it's pretty good.

**中文翻译:**
那会很酷。我不知道你们想不想往那个方向发展，但它确实挺好用的。

---

### [00:46:15] Sachin Monga

**English:**
That seems like an interesting can of worms.

**中文翻译:**
那听起来像是一个有趣的、但也可能带来麻烦的话题（can of worms）。

---

### [00:46:17] Lenny

**English:**
Right, an interesting can of worms.

**中文翻译:**
没错，一个有趣的话题。

---

### [00:46:18] Sachin Monga

**English:**
We did talk about whether we should change our default publication. You know how your default name was just like Lenny's Newsletter and we probably gave you a little red square or something as your default publication logo originally. A DALL-E generated publication logo service would be pretty cool.

**中文翻译:**
我们确实讨论过是否应该更改默认的出版物设置。你知道你的默认名字就是 Lenny's Newsletter，我们最初可能还给了你一个小红方块之类的作为默认 Logo。如果有一个 DALL-E 生成的出版物 Logo 服务，那应该会很酷。

---

### [00:46:33] Lenny

**English:**
That would be cool. If nothing else, it's just for ideas, but I would love that. Coming back to the idea of someone starting a Substack, we talked about advice, which is the core advice is just start and see how you like it. A big part of this is like, do you want to keep doing this? Because again, it's easy to start, hard to keep going, and also you may realize, "I've created this job for myself I don't like." That's something they should be thoughtful about. But on the flip side, do you see any common mistakes people make when they're starting on Substack that you suggest they try to avoid?

**中文翻译:**
那会很酷。即使只是为了提供灵感，我也会很喜欢。回到开始写 Substack 的话题，我们谈到了建议，核心建议就是“开始做，看看你是否喜欢”。其中很大一部分是：你想一直做下去吗？因为再次强调，开始容易，坚持难，而且你可能会意识到：“我为自己创造了一份我不喜欢的工作。”这是他们应该深思熟虑的事情。但另一方面，你有没有看到人们在 Substack 开始时常犯的错误，是你建议他们尽量避免的？

---

### [00:47:02] Sachin Monga

**English:**
One thing that's interesting here that I think we have a big opportunity to improve in the product is that there's going to be obviously varying levels of intent that people have when they hit that start your Substack button. Some people might come in being like, "This is going to be my full-time job. I want to make this work. I want to not just be a full-time writer, I want to build a media empire on Substack." There's certainly examples of that happening now. You can imagine a version of our onboarding and set up flow that's like the media empire version of it.

**中文翻译:**
这里有一件有趣的事，我认为我们在产品上有很大的改进机会：当人们点击“开始你的 Substack”按钮时，他们的意图显然是各不相同的。有些人可能会想：“这将是我的全职工作，我要把它做成。我不只想当全职作者，我还想在 Substack 上建立一个媒体帝国。”现在确实有这样的例子。你可以想象我们的入职和设置流程有一个“媒体帝国版”。

---

### [00:47:28] Sachin Monga

**English:**
You could also imagine the version that's just, "Let me just write one thing. Don't make me make all these decisions. I just want to get in the game." I think that in general, a mistake that people might make is... I'll maybe flip it back to an anecdote related to what I heard from Chris when I was chatting with him the other day, that he had to convince you pretty hard to turn on payments at all. Correct me if I'm spreading misinformation, but is that right?

**中文翻译:**
你也可以想象另一个版本，只是：“让我先写一篇文章。别让我做这么多决定，我只想先入场。”我认为通常情况下，人们可能会犯的一个错误是……我把它转回到我前几天和 Chris 聊天时听到的一个轶事：他费了好大劲才说服你开启付费功能。如果我说错了请纠正我，是这样吗？

---

### [00:47:51] Lenny

**English:**
Yeah. And Hamish too. Especially on how often I can take a break, he's always given me advice of, "You can take a break more often than you think," because I feel like I can never not do a week. Both those pieces of advice. It took me a while to get over, maybe I could charge for this and then maybe I could take some weeks off.

**中文翻译:**
是的，还有 Hamish 也是。特别是在我多久可以休息一次的问题上，他总是建议我：“你可以比你想象中更频繁地休息。”因为我觉得我不能有一周不更新。这两条建议都是。我花了一段时间才克服心理障碍，意识到也许我可以为此收费，也许我可以休息几周。

---

### [00:48:10] Sachin Monga

**English:**
Right, right. I think there's a generalizable piece of advice here that might be my answer to the question of what's a common pitfall, which is people are really worried about how their audience will perceive them and really ultimately their own worth, right? Should I send a newsletter three times a week into people's inbox? Is that too much? Should I ask anyone to pay me ever? Is that crazy? Am I allowed to take a vacation ever given that I've got people paying on an ongoing basis? And is that a bad service to provide if I'm taking a two week summer vacation?

**中文翻译:**
对，没错。我认为这里有一条普适的建议，这可能就是我对“常见陷阱”的回答：人们非常担心受众会如何看待他们，归根结底是担心自己的价值。我应该每周发三次 Newsletter 到别人的收件箱吗？会不会太多了？我应该要求别人付钱吗？这会不会太疯狂？既然有人在持续付钱，我还能休假吗？如果我休两周暑假，这算不算提供了糟糕的服务？

---

### [00:48:42] Sachin Monga

**English:**
I think almost in all of those cases, and then you could imagine five more things like that, readers, especially the people that are subscribed to you who are paying you, are pretty forgiving and are really there to support you and want you to take that vacation. There's probably more people who would want to pay for you that just don't even know about you that would totally pay if they could. Go back to that spectrum of, am I just trying to write a blog post? Am I trying to start a media empire? It's kind of like many people won't know yet. Just open up optionality for yourself and see what happens. Maybe don't be too worried about what your audience might think.

**中文翻译:**
我认为在几乎所有这些情况下（你还可以想象出另外五种类似的情况），读者，尤其是那些订阅并付钱给你的人，其实是非常宽容的。他们是真的在支持你，并且希望你能去度假。可能还有更多想为你付钱的人，只是他们还不知道你，如果可以的话他们完全愿意付钱。回到那个光谱：我只是想写篇博客，还是想建立媒体帝国？很多人可能还没想好。那就为自己开启各种可能性，看看会发生什么。也许不要太担心你的受众会怎么想。

---

### [00:49:20] Sachin Monga

**English:**
I think that maybe is one difference between Substack than something like Twitter or Instagram or something. Subscribe as an action is pretty heavyweight. It's like a costly signal, right? It's not as easy as just matching the follow button on a bunch of accounts on Twitter or something like that. If someone is subscribed to you, they're granting you write access to their brain is maybe the way I view it in a nerdy sense. What that means is not just like, "I'll let you write your one long form thing once a week," but, "hey, you've got this other person that you think might have something interesting to say? Cool, let me know. I'm here for it." I think writers underestimate that.

**中文翻译:**
我认为这也许是 Substack 与 Twitter 或 Instagram 之类平台的一个区别。“订阅”这个动作是非常有分量的，它是一个“高成本信号”，对吧？它不像在 Twitter 上随手点一堆关注按钮那么简单。如果有人订阅了你，用极客的话说，他们就是授予了你“对其大脑的写入权限”。这意味着不仅是“我允许你每周写一篇长文”，还意味着“嘿，如果你觉得另一个人有有趣的话要说，太棒了，告诉我，我愿意听”。我认为作者们低估了这一点。

---

### [00:49:57] Lenny

**English:**
Maybe three things I'll add to this just for folks that are thinking about, should I try this out? Should I not? One, when I joined Substack, I already felt like it was too late, and this was three years ago. I was like, "Nah, it's too late. Everyone's already got their big newsletters. There's no way I'm going to make any dent." I think people feel that now, and I think it's also not true. I think there's so much opportunity.

**中文翻译:**
对于那些在纠结“我该不该尝试”的人，我再补充三点。第一，当我加入 Substack 时，我已经觉得太晚了，那是三年前。我当时想：“不，太晚了，每个人都已经有了大型 Newsletter，我不可能产生任何影响。”我想现在的人也有这种感觉，但我认为这不是真的。我认为机会还有很多。

---

### [00:50:18] Sachin Monga

**English:**
100%.

**中文翻译:**
百分之百正确。

---

### [00:50:19] Lenny

**English:**
Two, when I got to a thousand paid subscribers, which feels very doable, I was making around a 100K, which is exactly... I think it was Kevin Kelly's 1000 True Fans. It was exactly like, "Oh wow! I could make a living with a thousand true fans for real." It's shocking how much you could make with so few people that really care about what you're doing. Think about is there a niche or something you're excited about that you can find a thousand people to pay you 10 bucks a month.

**中文翻译:**
第二，当我达到 1000 个付费订阅者时（这感觉是非常可行的），我的年收入大约是 10 万美元。这正应了凯文·凯利（Kevin Kelly）的“1000 个真粉丝”理论。当时的感觉就是：“哇！我真的可以靠 1000 个真粉丝维持生计。”令人惊讶的是，只要有这么一小群真正关心你所做事情的人，你就能赚到这么多钱。想想看，是否有一个你感兴趣的小众领域，能让你找到 1000 个人每月付你 10 美元。

---

### [00:50:52] Sachin Monga

**English:**
What's cool about that I think now with Substack and with the network effect is if there's a thousand people who are going to pay you 10 bucks a month, there's probably 2,000 and 5,000 and 10,000.

**中文翻译:**
我认为现在 Substack 及其网络效应最酷的地方在于：如果有 1000 个人愿意每月付你 10 美元，那么很可能也会有 2000 个、5000 个甚至 10000 个。

---

### [00:50:58] Lenny

**English:**
That's exactly what happened to me. I'm like, "If I hit a 100K, holy moly, I am good," and then it just kept growing. That's exactly right. You think there's an out, but the markets for these things are huge. The last point maybe is it took me nine months of doing it every week for free to get to a point where I felt like I can keep doing this. I enjoy doing this. People continue to value it, where I decided to turn on paid. It's a very slow and steady thing initially.

**中文翻译:**
这正是我身上发生的事。我当时想：“如果我能赚到 10 万美元，天哪，我就心满意足了。”然后它就一直在增长。没错，你以为市场有限，但这些东西的市场其实非常庞大。最后一点可能是：我花了九个月时间，每周免费写作，直到我觉得我可以坚持下去，我喜欢做这件事，而且人们持续认可它的价值，我才决定开启付费。最初这是一个非常缓慢且稳健的过程。

---

### [00:51:24] Lenny

**English:**
Don't expect it to just blow up. Just do it every week. See how it goes. See if you like it. See people like it. And if they do, keep going. If not, you can stop. When I launched my newsletter, I tweeted. I'm just going to experiment this thing. No idea where it's going to go. Just try it out, so you don't have to set the stakes high when you're starting out.

**中文翻译:**
不要指望它会突然爆发。只需每周坚持做。看看效果如何，看看你是否喜欢，看看人们是否喜欢。如果大家都喜欢，就继续；如果不喜欢，你可以停止。当我发布我的 Newsletter 时，我发了条推特说：“我只是想实验一下这个东西，不知道会走向何方。”只是尝试一下，所以你开始时不必把赌注定得太高。

---

### [00:51:41] Sachin Monga

**English:**
I think that's exactly right. You mentioned Kevin Kelly's 1000 True Fans, which has become this canonical piece of writing on the internet now. My favorite Kevin Kelly blog post, that's my second favorite, my first favorite is a post that he wrote called You Are Not Late, which is exactly what you... You can probably picture what he says, but it's such a compelling, persuasive argument for the thing you mentioned, which is like... Obviously he wasn't talking about Substack in his post, but he was talking about the internet and how in the grand scheme of things, how lucky we are to...

**中文翻译:**
我认为完全正确。你提到了凯文·凯利的《1000 个真粉丝》，这已经成为互联网上的经典文章。但我最喜欢的凯文·凯利的博客文章（那是我的第二喜欢），我最喜欢的是他写的一篇叫《你并没有迟到》（You Are Not Late）的文章。这正是你……你大概能想象他说了什么，但对于你提到的那点，它是一个非常有说服力的论点。显然，他在文章中不是在谈论 Substack，而是在谈论互联网，以及从宏观角度来看，我们是多么幸运……

---

### [00:52:13] Sachin Monga

**English:**
I don't even know when he wrote it, maybe it was probably 10 years ago at this point, but certainly at a time where a lot of people were feeling, "Oh, Facebook and Google and the internet's done. The battles have been won. I wish I was coming of age. I wish I had graduated from Harvard in 2004 or something." It's just so wrong. We are so early when it comes to how the internet will play out that I think getting to work on that in any capacity right now, getting to shape how the internet is going to play out over the next 10, 20 years is so fun because we are not late.

**中文翻译:**
我甚至不知道他是哪年写的，大概是 10 年前吧。但那肯定是在很多人觉得“噢，Facebook、Google 和互联网已经定型了，战斗已经结束了。我真希望我早生几年，真希望我 2004 年从哈佛毕业”的时候。这种想法大错特错。在互联网的发展进程中，我们还处于非常早期的阶段。我认为现在以任何身份参与其中，去塑造互联网未来 10 到 20 年的发展，都是非常有趣的，因为我们并没有迟到。

---

### [00:52:40] Lenny

**English:**
Here, here. I know Marc Andreessen mentioned those too when he moved to Silicon Valley in the '80s, "It's all over. It's too late. I missed the gold rush of tech," and it was just the beginning. Well, we've reached our very exciting lightning round where I'm just going to ask you a bunch of questions real quick, share whatever comes up. Sound good?

**中文翻译:**
完全同意。我知道 Marc Andreessen 也提到过，当他在 80 年代搬到硅谷时，人们说：“一切都结束了，太晚了，我错过了科技淘金热。”而那仅仅是个开始。好了，我们进入了非常令人兴奋的闪电问答环节，我会快速问你一堆问题，想到什么就说什么。准备好了吗？

---

### [00:52:59] Sachin Monga

**English:**
Sure, let's do it.

**中文翻译:**
当然，开始吧。

---

### [00:53:00] Lenny

**English:**
What are two or three books that you recommend most to other people?

**中文翻译:**
你最推荐给别人的两三本书是什么？

---

### [00:53:04] Sachin Monga

**English:**
I will plug some books that have nothing to do with the internet or software or tech, but have been the most informative or instructive books for me I think in my career as a product person working on software, which are books about architecture and urban planning. The reason why I find this field so fascinating is because for thousands of years, people have been figuring out how to build spaces that help people interact with each other and build good spaces to occupy. We've only been doing this for, going back to the Kevin Kelly thing, for basically the blink of an eye on the internet and in the digital realm.

**中文翻译:**
我会推荐一些与互联网、软件或科技完全无关的书，但它们在我作为软件产品经理的职业生涯中，是对我最有启发或指导意义的书，那就是关于建筑和城市规划的书。我之所以觉得这个领域如此迷人，是因为几千年来，人们一直在探索如何建造能帮助人们互动的空间，以及如何建造宜居的空间。而回到凯文·凯利的话题，我们在互联网和数字领域做这件事的时间，基本上只是眨眼之间。

---

### [00:53:35] Sachin Monga

**English:**
There's one book in particular by an architect named Christopher Alexander who sadly just passed away earlier this year. He wrote this book in the '70s. It's called The Timeless Way of Building. This is the book that I recommend to the most people I have. I buy it in bulk and I just give it away to people. The basic premise of the book is that in the '70s, we had just gone through a couple of decades of just mass produced cookie cutter suburban house development in the US. His premise was like we've basically just lost the plot on this. No one likes living in these houses.

**中文翻译:**
有一本书特别值得一提，作者是建筑师克里斯托弗·亚历山大（Christopher Alexander），遗憾的是他今年早些时候去世了。他在 70 年代写了这本书，叫《建筑的永恒之道》（The Timeless Way of Building）。这是我向最多人推荐的书。我会批量购买，然后送给别人。这本书的基本前提是：在 70 年代，美国刚刚经历了数十年的大规模生产、千篇一律的郊区住宅开发。他的观点是，我们基本上已经迷失了方向，没有人喜欢住在这些房子里。

---

### [00:54:06] Sachin Monga

**English:**
If you think about why these houses all feel bad to live in, it's because the people building the houses now for the first time ever are different than the people living in the house. It's these developers, these real estate developers, these big companies, mass producing these houses. But for thousands of years, we've figured out what makes a good house. The people building the house are the people living in it and they get that, but now the incentive structure got changed and they messed everything up.

**中文翻译:**
如果你思考为什么这些房子住起来感觉很糟糕，那是因为有史以来第一次，造房子的人和住房子的人不是同一群人。是那些开发商、房地产商、大公司在批量生产这些房子。但在几千年的时间里，我们已经弄清楚了什么是好房子：造房子的人就是住房子的人，他们明白这一点。但现在激励结构改变了，他们把一切都搞砸了。

---

### [00:54:27] Sachin Monga

**English:**
I think there's a really interesting parallel there with the internet, specifically how the last decade or so has played out, where the people building the spaces that we occupy are operating under a very complicated incentive structure and it's leading to these suboptimal user experiences. This is what we work on at Substack. This is what I think is fun to work on right now. If you're working on something like this, I would highly recommend The Timeless Way of Building by Christopher Alexander.

**中文翻译:**
我认为这与互联网有一个非常有趣的类比，特别是过去十年左右的发展：构建我们所占据的数字空间的人，是在非常复杂的激励结构下运作的，这导致了次优的用户体验。这就是我们在 Substack 所做的工作。这也是我认为目前工作中最有趣的地方。如果你也在从事类似的工作，我强烈推荐克里斯托弗·亚历山大的《建筑的永恒之道》。

---

### [00:54:51] Lenny

**English:**
Awesome. We're going to include that in the show notes for sure. What are two or three Substacks that you recommend most speaking of recommendation features?

**中文翻译:**
太棒了。我们一定会把它包含在节目笔记中。说到推荐功能，你最推荐的两三个 Substack 是什么？

---

### [00:54:59] Sachin Monga

**English:**
I was just thinking about this as I don't write on stack certainly frequently, and so I don't use the recommendations feature, but who would I recommend if I did besides Lenny, of course? I'll share a couple of random examples maybe, again, outside of maybe the tech product world. There's this guy named Darryl Cooper who has a podcast on Substack called The Martyr Made Podcast that I've gone super deep into lately. It's hard to describe. He basically takes a topic and he will produce the single best explanation of that topic you will ever find, because you'll spend an insane amount, probably 10,000 hours per topic, figuring out getting to the bottom of this story.

**中文翻译:**
我刚才还在想这个，因为我不经常在 Substack 上写东西，所以我不用推荐功能。但如果我用的话，除了 Lenny 之外我会推荐谁呢？我会分享几个随机的例子，同样是在科技产品领域之外。有个叫 Darryl Cooper 的人，他在 Substack 上有一个播客叫《The Martyr Made Podcast》，我最近听得很入迷。很难描述，他基本上是选一个主题，然后制作出你所能找到的关于该主题最好的解释，因为他会为每个主题花费惊人的时间（可能每个主题 10,000 小时）去挖掘故事的真相。

---

### [00:55:38] Sachin Monga

**English:**
He's doing a series right now in the labor movement in America. It sounds like a boring topic maybe, but he's just such an amazing storyteller. He's I think a good example too of this could only really work if he finds his thousand true fans as people who are just like, "Yeah, I'll just pay for this." It would be a very bad advertising business for sure. He publishes pretty infrequently, inconsistently, but it's just the highest quality stuff. That's The Martyr Made Podcast. Since I know this is supposed to be a lightning round and I spent too much time on that, the two others that I'll just quickly throw out there, Colin Meloy is one of my favorite musicians.

**中文翻译:**
他现在正在做一个关于美国劳工运动的系列。这听起来可能是一个无聊的话题，但他是一个非常了不起的讲故事的人。我认为他也是一个很好的例子：只有当他找到那 1000 个愿意说“是的，我愿意为此付钱”的真粉丝时，这种模式才能真正奏效。如果做广告业务，这肯定会很糟糕。他发布频率很低，也不固定，但内容质量极高。这就是《The Martyr Made Podcast》。既然这是闪电问答，我刚才花的时间太长了，另外两个我快速提一下：Colin Meloy 是我最喜欢的音乐家之一。

---

### [00:56:10] Sachin Monga

**English:**
He's the lead singer of The Decemberists. He's doing a really cool thing on his Substack right now of just a lot of interesting behind the scenes stuff on tour, publishing, audio and video. It's been really good. If you're a fan of The Decemberists, I highly recommend. One more, let's see, I have been really excited about Ethan Strauss lately. He writes a Substack called the House of Strauss. He's a basketball writer, but I think it's a cool example of like he just has subscribers now. He can write whatever he wants. He writes about a wide range of topics and they're all just really fascinating. I love to see that kind of thing happen on Substack and in general.

**中文翻译:**
他是 The Decemberists 乐队的主唱。他现在在他的 Substack 上做一件很酷的事情，发布很多巡演中有趣的幕后故事、音频和视频。内容非常棒。如果你是 The Decemberists 的粉丝，我强烈推荐。还有一个，让我想想，我最近对 Ethan Strauss 很感兴趣。他写一个叫《House of Strauss》的 Substack。他是一名篮球作家，但我认为这是一个很酷的例子：他现在有了订阅者，他可以写任何他想写的东西。他涉及的话题非常广泛，而且都非常迷人。我喜欢看到这类事情在 Substack 上以及在整个行业发生。

---

### [00:56:41] Lenny

**English:**
That's just reminding me, Kareem Abdul-Jabbar just recommended my newsletter in his Substack.

**中文翻译:**
这让我想起来，贾巴尔（Kareem Abdul-Jabbar）刚刚在他的 Substack 里推荐了我的 Newsletter。

---

### [00:56:45] Sachin Monga

**English:**
Oh man, congrats! That must be a life achievement right there.

**中文翻译:**
天哪，恭喜！那绝对是一项人生巅峰成就。

---

### [00:56:50] Lenny

**English:**
Yeah. I'm like, what the hell?

**中文翻译:**
是啊，我当时想，这怎么可能？

---

### [00:56:52] Sachin Monga

**English:**
Congrats!

**中文翻译:**
恭喜！

---

### [00:56:53] Lenny

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:56:54] Sachin Monga

**English:**
He's a great writer. .

**中文翻译:**
他是个伟大的作家。

---

### [00:56:54] Lenny

**English:**
I don't know if he reads it. I don't know. I don't know what's going on. I love it. He has got a great Substack, by the way. I think if you just Google Kareem Abdul-Jabbar Substack, you'll find it. On the recommendation feature, I was just thinking, do you want to shout out the folks that built it, the team?

**中文翻译:**
我不知道他读不读我的文章，我不知道发生了什么，但我很喜欢。顺便说一下，他的 Substack 办得很棒。我想只要谷歌搜索“Kareem Abdul-Jabbar Substack”就能找到。关于推荐功能，我刚才在想，你想向构建它的团队致敬吗？

---

### [00:57:07] Sachin Monga

**English:**
I would love to.

**中文翻译:**
我很乐意。

---

### [00:57:08] Lenny

**English:**
Let's do it.

**中文翻译:**
那就开始吧。

---

### [00:57:09] Sachin Monga

**English:**
It's too many. It ended up being a company wide effort, but the product manager on my team, Dayne Rathbone, was specifically I think the spearhead behind the way that we built it, like you mentioned, that we went into. He was a really big proponent for that. Gabriel on our design team designed it and many engineers worked on it. It'll be hard to shout them all out, but I'd shout out Dayne on my team because he ensured that we built it in the way that we ultimately needed to build it for it to work.

**中文翻译:**
人太多了，这最终成了一项全公司范围的努力。但我团队的产品经理 Dayne Rathbone 特别是这项功能的带头人，就像你提到的，他推动了我们构建它的方式。他是该功能的坚定支持者。我们设计团队的 Gabriel 负责设计，还有很多工程师参与其中。很难一一列举，但我特别想向我团队的 Dayne 致敬，因为他确保了我们以最终能奏效的方式构建了它。

---

### [00:57:36] Lenny

**English:**
Thank you, Dayne and Gabriel. Two final questions. Do you have any favorite recent movies or TV shows that you watched that you love?

**中文翻译:**
谢谢 Dayne 和 Gabriel。最后两个问题。你最近有没有看过什么非常喜欢的电影或电视剧？

---

### [00:57:44] Sachin Monga

**English:**
Yeah. I just finished the latest season of For All Mankind and loved it.

**中文翻译:**
有的。我刚看完《为全人类》（For All Mankind）的最新一季，非常喜欢。

---

### [00:57:49] Lenny

**English:**
So good.

**中文翻译:**
太棒了。

---

### [00:57:50] Sachin Monga

**English:**
Did you watch it all?

**中文翻译:**
你全看完了吗？

---

### [00:57:52] Lenny

**English:**
Yes. Oh my God! The last couple episodes, you're sitting on the edge of your seat.

**中文翻译:**
是的。天哪！最后几集简直让人坐立难安。

---

### [00:57:55] Sachin Monga

**English:**
I feel like in this season, every episode was like its own standalone movie or something. It started slow the whole show. I think the first season was a bit slow. When I recommend it to people, I'm like, "Just power through it," but they really found their groove. I don't know. I'm stoked for the next season.

**中文翻译:**
我觉得在这一季中，每一集都像是一部独立的电影。整部剧开头比较慢，第一季有点平淡。当我向别人推荐时，我会说：“坚持看下去。”但他们真的找到了节奏。我不知道，我非常期待下一季。

---

### [00:58:10] Lenny

**English:**
Same. Final question, what's a favorite interview question you like to ask folks when you're interviewing them?

**中文翻译:**
我也是。最后一个问题：你在面试别人时最喜欢问的问题是什么？

---

### [00:58:16] Sachin Monga

**English:**
I have a tough time answering this question because I have found that there's not one question that will get me the signal I actually want given how diverse the candidate's experiences might be in their context. If you're coming from a Facebook type place or coming from a startup, I might need to ask different questions in order to get the signal I want. Maybe I'll answer it in that way, which is like these days, especially for Substack, what is the signal that I'm trying to get?

**中文翻译:**
我很难回答这个问题，因为我发现没有哪一个问题能让我获得我真正想要的信号，毕竟候选人的背景和经历非常多样化。如果你来自 Facebook 这样的公司，或者来自初创公司，我可能需要问不同的问题才能得到我想要的信号。也许我可以换个方式回答：这些天，特别是对于 Substack 来说，我试图获取的信号是什么？

---

### [00:58:43] Sachin Monga

**English:**
I think really for early stage, fast growing startup, we talked so much about how different that is, we just need people who can run through walls to accomplish big goals. Maybe grit and endurance in some ways and drive are the words I would throw out there. I find it's really hard to have one question that will get that signal. We need to tailor it to that person's background.

**中文翻译:**
我认为对于早期、快速增长的初创公司（我们谈过这有多么不同），我们只需要那些能够“破墙而出”去实现宏大目标的人。也许“坚韧”、“耐力”和“驱动力”是我会用到的词。我发现很难用一个问题就获得这种信号，我们需要根据那个人的背景来定制问题。

---

### [00:59:07] Lenny

**English:**
All right, I'll accept that meta answer. Sachin, thank you so much for being here. As you I've shared, Substack is very near and dear to my heart, and I'm really thankful that you spent the time to dig into a lot of these things that have been on my mind. I imagine it will be helpful to a lot of other people. Two final questions. Where can folks find you online if they want to reach out, learn more? Are y'all hiring? And then how can listeners be useful to you?

**中文翻译:**
好吧，我接受这个“元回答”。Sachin，非常感谢你能来。正如我分享过的，Substack 对我来说非常重要，我真的很感谢你花时间深入探讨这些我一直思考的问题。我想这对很多人都会有帮助。最后两个问题：如果人们想联系你或了解更多信息，可以在哪里找到你？你们在招人吗？听众可以为你提供什么帮助？

---

### [00:59:31] Sachin Monga

**English:**
First of all, thank you, Lenny, for being such an amazing Substack example setter. We talk about you all the time, as you can imagine internally, and you've been so helpful to the company and to our product team. It's been a real honor to get to come onto the pod and keep doing what you're doing. You can find me on all the various social media platforms. I'm not super active on them, I must admit, but maybe Twitter would be the one where I spend the most time, which is just Sachin Monga, my first name and last name, is my handle.

**中文翻译:**
首先，谢谢你，Lenny，你是一个非常出色的 Substack 榜样。你可以想象，我们在内部经常谈论你，你对公司和我们的产品团队提供了巨大的帮助。能参加你的播客是我的荣幸，请继续保持。你可以在各种社交媒体平台上找到我。我必须承认我不太活跃，但 Twitter 可能是我花时间最多的地方，我的账号就是 Sachin Monga（我的名字和姓氏）。

---

### [00:59:58] Sachin Monga

**English:**
I'll make one plug for a role that we're hiring for right at Substack, which is a senior data role with a product and growth analytics bent would be the specific archetype we're looking for in this role. If you are listening to the pod and feel like that might be you, I would love to chat. I think my email address too, I don't know if it would get shared, but it's just Sachin, my first name, @substackinc.com. Feel free to send me a note anytime.

**中文翻译:**
我想为 Substack 正在招聘的一个职位打个广告：我们需要一个高级数据职位，具体要求是具有产品和增长分析倾向的人才。如果你正在听播客并觉得这可能适合你，我很乐意聊聊。我的电子邮件地址是 Sachin（我的名字）@substackinc.com。欢迎随时给我发邮件。

---

### [01:00:24] Lenny

**English:**
Awesome. We'll include that in the show notes. Sounds like y'all are building some cool analytics features maybe based on that role. I'm excited for that. Awesome, man. Thank you for being here.

**中文翻译:**
太棒了。我们会把它包含在节目笔记中。听起来你们可能正基于这个职位构建一些很酷的分析功能。我很期待。太棒了，伙计，谢谢你的到来。

---

### [01:00:33] Sachin Monga

**English:**
My pleasure. Thank you so much for having me.

**中文翻译:**
我的荣幸。非常感谢邀请我。

---

### [01:00:37] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，因为这能真正帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。