# Sahil Mansuri - 双语对照

This is the complete bilingual transcript for **Lenny’s Podcast** featuring **Sahil Mansuri**.

---

### [00:00:00] Sahil Mansuri

**English:**
It's hard to plan what you should do for all of 2023. I think the advice that most founders are getting from their boards is when you have limited visibility, you have to plan in the most conservative way. On the one hand, of course that's true, you have to be conservative. But on the other hand, you don't want to be unreasonably conservative because you don't want to be floundering from like, oh, we're screwed to everything's better, to we're screwed, everything's better. So the way I think about setting up a plan when you have limited visibility and some major headwinds is setting up a really conservative plan and then having milestones, short term milestones that unlock the ability to lean into growth and spend based on hitting those targets.

**中文翻译:**
很难规划 2023 年全年的工作。我认为大多数创始人从董事会那里得到的建议是：当可见性有限时，你必须以最保守的方式进行规划。一方面，这当然是对的，你必须保守。但另一方面，你又不想过于保守，因为你不想在“噢，我们要完蛋了”到“一切都好起来了”，再到“我们要完蛋了”、“一切都好起来了”之间反复横跳。因此，在可见性有限且面临重大阻力时，我对于制定计划的想法是：设定一个非常保守的计划，然后设立里程碑——即短期里程碑，一旦达到这些目标，就可以解锁加大增长投入和支出的能力。

---

### [00:00:49] Lenny

**English:**
Welcome to Lenny's Podcast. I'm Lenny, and my aim here is to help you get better at the craft of building and growing products. Today my guest is Sahil Mansuri. Sahil is the CEO and founder of Bravado, which has built the world's largest online sales community of over 300,000 salespeople, and they're now building SaaS products for salespeople. Sahil has one of the most unique perspectives on the art and skill of sales, partly because of the community and the company that he runs, and partly because he was a longtime salesperson himself. As you'll hear in this episode, he has closed some incredible deals, including a wild story about cold emailing Sheryl Sandberg at Facebook and what that led to. In this episode, we focus on what founders should change and how they do sales during this market downturn, including how you should approach sales quotas, how you should rethink the way you do comp plans for salespeople, how you do forecasting, also why you should refocus on retention and your existing customers, how to improve your sales technique in general no matter what role you're in. As someone without a lot of depth in sales, I always find it fascinating to learn how to get better at sales. This episode has something for everyone. With that, I bring you Sahil Mansuri. Hey, Ashley, head of marketing and Flatfile. How many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你更好地掌握构建和增长产品的技能。今天的嘉宾是 Sahil Mansuri。Sahil 是 Bravado 的首席执行官兼创始人，该公司建立了全球最大的在线销售社区，拥有超过 30 万名销售人员，目前他们正在为销售人员开发 SaaS 产品。Sahil 对销售艺术和技巧有着非常独特的见解，部分原因在于他经营的社区和公司，部分原因在于他本人曾长期担任销售。正如你在本集中将听到的，他曾达成过一些令人难以置信的交易，包括一个关于给 Facebook 的 Sheryl Sandberg 发冷启动邮件（Cold Email）的疯狂故事以及随之而来的结果。在本集中，我们重点讨论在市场低迷时期，创始人应该在销售方式上做出哪些改变，包括如何处理销售配额（Quotas）、如何重新思考销售人员的薪酬计划（Comp Plans）、如何进行预测，以及为什么你应该重新关注留存和现有客户，以及无论你担任什么角色，如何总体提高销售技巧。作为一个在销售方面没有太多深厚背景的人，我总是觉得学习如何提高销售水平非常迷人。这一集内容老少皆宜。下面，让我们欢迎 Sahil Mansuri。嘿，Ashley（Flatfile 营销负责人），你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### [00:02:13] Ashley

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### [00:02:15] Lenny

**English:**
How many of them screw that up? What happens when they do?

**中文翻译:**
其中有多少公司把这件事搞砸了？搞砸了会发生什么？

---

### [00:02:18] Ashley

**English:**
Well, based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common, considering customer files are chock full of unexpected data and formatting, they'll leave.

**中文翻译:**
嗯，根据我们的数据，大约三分之一的人在入职引导（Onboarding）过程中只要有一次糟糕的体验，就会考虑更换公司。因此，如果你的 CSV 导入器运行不正常（这非常普遍，因为客户文件充满了意想不到的数据和格式），他们就会流失。

---

### [00:02:38] Lenny

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing longterm retention. Getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不意外。我一直认为，改善入职引导是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地达到“顿悟时刻”（Aha Moment）是极其重要的。

---

### [00:02:52] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify and Zora are able to grow their businesses on top of Flatfile, this because flawless data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zora 这样的客户能够在 Flatfile 之上实现业务增长，真是令人难以置信。这是因为完美的数据入职引导就像催化剂一样，能让他们和他们的客户更快地达到目标。

---

### [00:03:09] Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny. This episode is brought to you by Merge. Every product manager knows the pain of slowing product velocity when developers struggle to build and maintain integrations with other platforms. Merge's unified API can remove this blocker from your roadmap. With one API, your team can add over 150 HR, ATS, accounting, ticketing and CRM integrations right into your product. You can get your first integration into production in a matter of days and save countless weeks building custom integrations, letting you get back to building your core product. Merge's integrations speed up the product development process for companies like Ramp, Drada and many other fast growing and established companies, allowing them to test their features at scale without having to worry about a never ending integrations roadmap. Save your engineers countless hours and expedite your sales cycle by making integration offerings your competitive advantage with Merge. Visit merge.dev/lenny to get started and integrate up to five customers for free. Sahil, welcome to the podcast.

**中文翻译:**
如果你想了解更多信息或开始使用，请访问 flatfile.com/lenny 查看 Flatfile。本集由 Merge 赞助。每位产品经理都知道，当开发人员费力地构建和维护与其他平台的集成时，产品开发速度就会减慢，这非常痛苦。Merge 的统一 API 可以从你的路线图中移除这一障碍。通过一个 API，你的团队就可以将 150 多个 HR、ATS（招聘管理系统）、会计、工单和 CRM 集成直接添加到你的产品中。你可以在几天内将第一个集成投入生产，节省数周构建自定义集成的时间，让你重新专注于构建核心产品。Merge 的集成为 Ramp、Drada 以及许多其他快速增长和成熟的公司加速了产品开发过程，让他们能够大规模测试功能，而无需担心永无止境的集成路线图。通过 Merge 将集成服务转化为你的竞争优势，为你的工程师节省无数时间并缩短销售周期。访问 merge.dev/lenny 开始使用，并免费集成多达五个客户。Sahil，欢迎来到播客。

---

### [00:04:21] Sahil Mansuri

**English:**
Thanks Lenny. Thanks for having me.

**中文翻译:**
谢谢 Lenny。感谢邀请我。

---

### [00:04:23] Lenny

**English:**
So we're going to be talking about sales and in particular what you should be adjusting in your company during these very turbulent market conditions. But I thought first it'd be helpful if you just gave a little background on yourself to kind of give folks a sense of why you have such unique insights into the sales world. So maybe just talk about a little bit of your background and then what you do now, the company that you run now.

**中文翻译:**
我们将讨论销售，特别是在这些动荡的市场条件下，你应该在公司中做出哪些调整。但我认为，如果你先介绍一下自己的背景，让大家了解为什么你对销售领域有如此独特的见解，会很有帮助。所以，请谈谈你的背景，以及你现在在做什么，也就是你现在经营的公司。

---

### [00:04:46] Sahil Mansuri

**English:**
I've spent my whole career in sales. I started out in sales when I was in college. I worked on the Obama campaign. We didn't call it sales, right? We called it turning out the votes or street teamwork or field ops or phone banking, but it was sales. We were just selling the dream, literally the American dream as it were. So I've been in some sort of a role where my primary responsibility was to cold call, send emails, have conversations, objection handle, and try to get someone to sign a contract for my entire career. I started selling in September of 2008 was my first month with a quota. So I started selling in the middle of the last financial crisis. In 2009, the company that I used to do sales for, which is called Meltwater, this company, it's a pretty crazy story. It's one of the few companies that has made it to $100 million in recurring revenue without a drop of venture funding. It's a Norwegian company actually. If I remember correctly, don't quote me on the exact numbers here, but the company had basically gone 10 million to 30 million to 50 million to 70 million, and then in 2009, they went from 70 million to 69 million. It was the first year that they hadn't not only increased revenue, but revenue had gone down. In that year, in 2009, I broke the company record for the most sales by any individual person in one year in the history of the company. I say that not out of hubris or out of pride, I say that because I've literally sold in a downturn. In the middle of a recession, I have been an account executive selling, carrying a quota and have been successful in doing it. Then went on to be a sales leader at a bunch of different places, probably most notably at Glassdoor, where I joined as one of the first 20, 25 employees. Was responsible for enterprise sales there. Personally closed Facebook, Google, Amazon, Microsoft, Ford, Visa, Bank of America, JP Morgan, Walmart. At its peak, at one point I think Glassdoor had about 100 of the Fortune 500 customers and I'd sold about 60 of them myself. I've done a lot of selling in my career, also a decent amount of sales management and sales leadership. But really my forte is selling. I love to sell. I love to talk to customers. I love to train salespeople. I've been a VP of sales and CRO in a couple different places. Then for the last five years I've been building a community for salespeople that's called Bravado. Bravado is a network of about 300,000 B2B tech sales. That's about 50,000 VPs of sales and CROs, about 150,000 account executives, another like 40 to 50,000 SDRs. Then the rest of it are kind of customer success, sales engineers, sales ops, sales enablement, et cetera. So it's a network that purely focuses on sales, and much akin to your business, I suppose, marries community learning, upskilling, recruiting as this one place that a salesperson can go in order to beat the odds, be successful in their career, find a great job, or hit and crush quota in their role.

**中文翻译:**
我的整个职业生涯都在做销售。我从大学时代就开始做销售了。我曾在奥巴马的竞选团队工作。我们当时不叫它“销售”，对吧？我们称之为“催票”、街头团队合作、外勤操作或电话银行，但本质上就是销售。我们是在推销梦想，字面意义上的“美国梦”。所以，在我的整个职业生涯中，我一直担任某种角色，其主要职责是打冷启动电话（Cold Call）、发邮件、进行对话、处理异议，并努力让某人签署合同。我从 2008 年 9 月开始正式背负销售配额（Quota）。所以我是在上一次金融危机中期开始做销售的。2009 年，我当时供职的销售公司叫 Meltwater，这家公司的故事挺疯狂的。它是少数几家在没有任何风险投资的情况下，经常性收入（ARR）达到 1 亿美元的公司之一。它实际上是一家挪威公司。如果我没记错的话（别拿确切数字考究我），这家公司的收入基本上是从 1000 万增长到 3000 万、5000 万、7000 万，然后在 2009 年，他们从 7000 万降到了 6900 万。那是他们不仅没有增加收入，反而收入下降的第一年。就在那一年，即 2009 年，我打破了公司历史上单人单年销售额的最高纪录。我说这些不是出于傲慢或自豪，而是因为我确实在经济低迷时期做过销售。在经济衰退中期，我曾是一名背负配额的客户经理（Account Executive），并且取得了成功。后来我在很多不同的地方担任销售负责人，最著名的可能是在 Glassdoor，我是前 20-25 名员工之一。我在那里负责企业级销售。我个人签下了 Facebook、Google、亚马逊、微软、福特、Visa、美国银行、摩根大通、沃尔玛。在巅峰时期，我想 Glassdoor 大约拥有 100 家财富 500 强客户，其中约 60 家是我亲自谈下来的。在我的职业生涯中，我做了大量的销售工作，也有相当一部分销售管理和领导经验。但说实话，我的强项是销售。我热爱销售。我喜欢与客户交谈。我喜欢培训销售人员。我在几个不同的地方担任过销售副总裁（VP of Sales）和首席营收官（CRO）。在过去的五年里，我一直在建立一个名为 Bravado 的销售人员社区。Bravado 是一个拥有约 30 万名 B2B 技术销售人员的网络。其中包括约 5 万名销售副总裁和 CRO，约 15 万名客户经理（AE），还有约 4 到 5 万名销售开发代表（SDR）。剩下的则是客户成功（CS）、销售工程师、销售运营、销售赋能等。所以这是一个纯粹专注于销售的网络，我想这与你的业务非常相似，它结合了社区学习、技能提升、招聘，是销售人员为了战胜困难、在职业生涯中取得成功、找到好工作或在岗位上完成并超越配额而可以去的一个地方。

---

### [00:08:22] Lenny

**English:**
Awesome. I think that gives a clear picture of why you have such unique insights. I don't know if there's anyone that has such a broad access to so many salespeople and what they're doing, what they're thinking about. The core part of the Bravado product, just to make it even clear, is a community or people ask questions, help each other through sales issues, things like that, right?

**中文翻译:**
太棒了。我想这清楚地说明了为什么你拥有如此独特的见解。我不知道还有谁能接触到这么多销售人员，了解他们在做什么、在想什么。为了更清楚起见，Bravado 产品的核心部分是一个社区，人们可以在那里提问、互相帮助解决销售问题，对吧？

---

### [00:08:41] Sahil Mansuri

**English:**
Yeah. So if you're familiar with Stack Overflow and what that network and community means to engineering, Bravado has a product that's affectionately known as the War Room, which does the same thing. So you have 50,000 companies, sales teams that are on Bravado. We get a realtime pulse of which companies are hitting quota, which ones are missing quota, which sales reps are closing deals with which organizations, which industries are doing better or worse. So we do get a really interesting perspective within the world of B2B tech sales, to be clear, a really interesting perspective on what's happening in terms of companies and revenue and forecast and quota, which gives us hopefully an opportunity to serve those members and the general tech community at large in terms of how they can beat the odds, especially as we're back to that 2008 crunch that we saw then as well.

**中文翻译:**
是的。如果你熟悉 Stack Overflow 以及该网络和社区对工程界的意义，Bravado 有一个被亲切地称为“作战室”（War Room）的产品，它的功能是一样的。Bravado 上有 5 万家公司的销售团队。我们可以实时掌握哪些公司达到了配额，哪些没有达到，哪些销售代表正在与哪些机构达成交易，哪些行业表现较好或较差。所以，在 B2B 技术销售领域，我们确实拥有一个非常有趣的视角——确切地说，是对公司、收入、预测和配额方面正在发生的事情的有趣视角。这让我们有机会为这些成员以及整个技术社区提供服务，告诉他们如何战胜困难，尤其是当我们回到像 2008 年那样的危机时刻时。

---

### [00:09:39] Lenny

**English:**
Awesome. Just to put this out there, I'm a very small investor in Bravado. I'm just a fan of these kinds of companies, community led SaaS tooling. I was really impressed with the way you're building and the way you're approaching it. Also, I don't have a lot of depth in sales, and so I loved this opportunity to learn about how sales works by participating. So thank you for letting me join the journey of Bravado. It's a really unique company and I'm excited to see where it all goes. So with this podcast, we were planning to talk about sales. Initially, it was going to be how to get better at sales, how to be a better salesperson. But you had this great suggestion that we instead focus more specifically on what founders should change in the coming year knowing the conditions of the market and how things are turbulent and how people are spending less and things like that. So we're going to talk about five things that you can do right now to change the way your sales process works starting now for the next year. The idea is once you listen to this conversation, you can go and do these things immediately with your team. So that sound good?

**中文翻译:**
太棒了。顺便提一下，我是 Bravado 的一个小投资者。我只是这类公司——社区驱动的 SaaS 工具——的粉丝。你构建公司的方式和处理问题的方式给我留下了深刻印象。此外，我在销售方面没有太深的造诣，所以我很珍惜这次通过参与来了解销售运作方式的机会。所以，感谢你让我加入 Bravado 的旅程。这确实是一家非常独特的公司，我很期待它的未来发展。关于这次播客，我们原计划讨论销售。最初的主题是如何提高销售水平，如何成为更好的销售人员。但你提出了一个很好的建议，即我们应该更具体地关注：在了解市场状况、动荡局势以及人们支出减少等情况后，创始人明年应该做出哪些改变。因此，我们将讨论你现在就可以做的五件事，从现在开始改变你明年的销售流程。我们的想法是，一旦你听完这段对话，你就可以立即和你的团队一起去执行这些事情。听起来不错吧？

---

### [00:11:18] Sahil Mansuri

**English:**
Yeah, it sounds great. I mean, I think, inherent in this conversation will be things that you can do to be better at sales, but I think the way in which you sell has to be different based on market condition. So if we had done this podcast eight months ago or 18 months ago or 28 months ago or 38 months ago, I think we would've had one set of conversation. We would've talked about growing top line revenue. We would've talked about how to get your first 20 customers. We would've talked about how to build and scale a sales team. We would've talked about setting quotas and whatnot. I think that today, the market has shifted because we know that the cost of capital has gone up. We know that funding has dried up. We know that investors today are only interested in companies that have strong unit economics and have high retention rates. Cold prospecting goes down in favor of cross-selling and upselling your existing customer base because it's hard to break into new accounts when companies have budget freezes and hiring freezes and layoffs, and everyone is watching really closely the capital outflow of their business. So your sale strategy has to fundamentally change in order to meet the moment and meet the market to where it is.

**中文翻译:**
是的，听起来很棒。我的意思是，这次对话中自然会包含一些让你更擅长销售的内容，但我认为你销售的方式必须根据市场状况而有所不同。如果我们是在 8 个月前、18 个月前、28 个月前或 38 个月前做这个播客，我想我们会有一套完全不同的对话内容。我们会讨论如何增加总收入（Top-line Revenue）。我们会讨论如何获得前 20 个客户。我们会讨论如何建立和扩大销售团队。我们会讨论设定配额之类的事情。我认为今天市场已经发生了变化，因为我们知道资本成本上升了。我们知道融资已经枯竭。我们知道今天的投资者只对具有强大单位经济效益（Unit Economics）和高留存率的公司感兴趣。冷启动开发（Cold Prospecting）正在减少，取而代之的是对现有客户群的交叉销售（Cross-selling）和增购销售（Upselling），因为当公司面临预算冻结、招聘冻结和裁员时，很难打入新账户，而且每个人都在密切关注业务的资本流出。因此，你的销售策略必须从根本上改变，以适应当前的时刻和市场现状。

---

### [00:12:00] Lenny

**English:**
Great context setting. You touched on a few of the things we're going to talk about, so I'm excited to get into it. The first topic I wanted to chat about is forecasting and quotas. You have some advice on how founders should be thinking about adjusting their forecast plans and their quotas for next year. Can you talk about that?

**中文翻译:**
非常好的背景铺垫。你提到了我们将要讨论的几件事，所以我很期待深入探讨。我想聊的第一个话题是预测和配额。关于创始人应该如何考虑调整明年的预测计划和配额，你有一些建议。能谈谈吗？

---

### [00:12:18] Sahil Mansuri

**English:**
Yeah, so let's start with some data and then we'll talk about why this matters. So on Bravado, as I mentioned, we have 300,000 members, but only about 200,000 of them. So about 65% of the network uses a product called the Seller Portfolio. The Seller Portfolio is a realtime tracker of how you and your sales team are performing relative to quota. You can kind of think of it like mint.com, but instead of being for personal finance, it's for sales. Based on that, we're able to get a realtime perspective on which companies in specific, and then overall which industries and in which sectors are at or above or below quota. So I'll share some stats with you. So in Q3 of this year, so I guess as of last month, in Q3 of this year, 63% of sales reps missed quota, 63%. That's up from 54% in Q2 and 46% in Q1. So you've basically got 30% more of the sales team missing quota today than you did literally just six months ago. If you broaden that out to a team wide structure, 76% of companies missed their Q3 target. 76% of companies missed their Q3 target. That's up from 59% in Q2 and 51% in Q1. So you actually have 33% more companies that are missing target. Then at this point, it's gone from being like the occasional company is struggling to pretty much every tech company is struggling. We would predict, based on the data that we're seeing, that over 80% of companies will miss their Q4 goals. So in a world in which the vast majority of sales reps are missing quota and the even larger vast majority of companies are missing quota and their forecast, that on the one hand explains why you're seeing this bunch of layoffs. On the other hand though, it raises the question of what do I do for next year? On the one hand, you don't want to bring down targets too significantly because it's going to raise a lot of red flags in terms of spend and burn and probably meet a lot of really painful decision. On the other hand, it's really hard to have visibility into what the market's going to look like six months, I mean, heck, even like six weeks from now. Things are changing on a realtime basis. Something interesting that we saw is that we have quarterly tracking, but we also have monthly tracking. So something interesting we saw is that from November until March of last year, companies were basically blowing out their quota, sales reps were blowing out their quota. All of a sudden everything came to a screeching halt in April, and April, May and June were really tough times. You saw that outwardly in the market in terms of layoffs and hiring freezes and such. But we saw it on a realtime basis in terms of percentage to quota and companies missing their target. What was interesting is that a bunch of companies then revised down their forecast for the rest of the year, but then companies started beating those forecasts in July, August, September. So for a moment there, it actually looked like we might be out of the worst of it, and then came obviously a much maligned double dip recession, which then in October, November, all of a sudden everyone just started missing. Many of your listeners, I would imagine, work at VC backed SaaS companies, so they can, in the comments or whatnot, speak about whether this is also true for them. But I would imagine that for most of companies going into the middle to end of September, they probably felt pretty good. They actually thought like, "Oh, maybe we can actually squeak by in Q3. Maybe we can revise up forecast in Q4. Maybe we can hire into next year and we can go back to growing the way we were for the previous 10 years." Then October was just a bloodbath. On companies that do monthly quotas, 85% of sales reps missed quota in October for their monthly number. I think it's going to be even higher in November based on what we're seeing. So again, I share all this information with you to just kind of set the stage on what's happening realtime in the market. So given that September felt good, but today we're totally screwed, it's hard to plan what you should do for all of 2023. I think the advice that most founders are getting from their boards is when you have limited visibility, you have to plan in the most conservative way. On the one hand, of course that's true. You have to be conservative. But on the other hand, you don't want to be unreasonably conservative because you don't want to be floundering from like, oh, we're screwed to everything's better, to we're screwed, everything's better. So the way I think about setting up a plan when you have limited visibility and some major headwinds is setting up a really conservative plan and then having milestones, short term milestones that unlock the ability to lean into growth and spend based on hitting those targets. So here's an example. Let's say that you did $10 million in revenue this year and next year you have no idea what that's going to look like. Maybe you say, "Okay, let's plan like we're going to be down to 9 million. We're going to lose 10% of revenue next year despite our best efforts because the market's going to be really tough." So that would mean that in Q1 you need to hit 2.5 million in revenue. Let's say in Q1, if we hit 2.5, then we should revise up our targets for the rest of the year and we can unlock this additional budget to kind of spend off of. If we hit below 2, we should revise down our number. So kind of being comfortable with regularly reforecasting. Forecasting, you can't just forecast a quarter out every time. Obviously that's a tough way to run a business. So you got to forecast a year, but then set milestones, checkpoints and kind of make predetermined decisions that allow you to avoid the bias of then walking into Q1 and being like, "Oh, we missed in Q1, but no, no, we're really going to hit it in Q2." You got to set the targets upfront because as founders, we tend to have a bias towards optimism. That's generally how founders operate. In today's market, that's more of a disadvantage than an advantage. So my suggestion is to really think about forecasting conservatively, setting up checkpoints and milestones around what future success may or may not look like. If you hit those goals, then decelerating or accelerating into it depending upon what you get there, and coming to an agreement with your board, with your sales team, with your sales leadership in advance so that there's no debate about what to do when you actually get there.

**中文翻译:**
好，让我们先从一些数据开始，然后讨论为什么这很重要。在 Bravado 上，正如我提到的，我们有 30 万名成员，但其中只有大约 20 万人，也就是大约 65% 的网络成员使用一款名为“销售员组合”（Seller Portfolio）的产品。Seller Portfolio 是一个实时追踪器，记录你和你的销售团队相对于配额的表现。你可以把它想象成销售版的 mint.com（个人理财工具）。基于此，我们能够实时了解具体哪些公司，以及总体上哪些行业和部门达到了、超过了或低于配额。我来分享一些统计数据。在今年第三季度（也就是上个月），63% 的销售代表没有达到配额。这个比例在第二季度是 54%，第一季度是 46%。所以，现在没达到配额的销售团队成员比六个月前增加了 30%。如果把范围扩大到整个团队结构，76% 的公司没有达到第三季度的目标。这个比例在第二季度是 59%，第一季度是 51%。所以实际上没达标的公司增加了 33%。到目前为止，情况已经从“偶尔有公司在挣扎”变成了“几乎每家技术公司都在挣扎”。根据我们看到的数据，我们预测超过 80% 的公司将无法完成第四季度的目标。在绝大多数销售代表和绝大多数公司都无法完成配额和预测的世界里，这一方面解释了为什么你会看到这么多裁员。但另一方面，它提出了一个问题：明年我该怎么办？一方面，你不想把目标降得太低，因为这会在支出和烧钱率（Burn Rate）方面引发很多警报，并可能导致很多痛苦的决定。另一方面，很难预见六个月后，甚至六周后的市场会是什么样子。情况正在实时发生变化。我们发现的一件有趣的事情是，我们有季度追踪，也有月度追踪。从去年 11 月到今年 3 月，公司和销售代表基本上都在超额完成配额。突然之间，一切在 4 月戛然而止，4 月、5 月和 6 月是非常艰难的时期。你在市场上看到了裁员和招聘冻结等现象。但我们从配额完成百分比和公司未达标情况中实时看到了这一点。有趣的是，一堆公司随后下调了今年剩余时间的预测，但随后公司在 7 月、8 月、9 月开始超过这些预测。所以有那么一瞬间，看起来我们可能已经度过了最糟糕的时期，但随后显然出现了备受诟病的“双底衰退”，接着在 10 月、11 月，突然之间每个人都开始达不到标了。我想你的很多听众都在风投支持的 SaaS 公司工作，他们可以在评论区之类的地方谈谈这是否也适用于他们。但我可以想象，对于大多数公司来说，进入 9 月中下旬时，他们可能感觉还不错。他们实际上在想：“噢，也许我们真的能勉强挺过第三季度。也许我们可以上调第四季度的预测。也许我们可以为明年招聘，我们可以回到过去 10 年那样的增长轨道。”然后 10 月就是一场大屠杀。在实行月度配额的公司中，85% 的销售代表在 10 月份没有达到月度指标。根据我们目前看到的情况，我认为 11 月份的比例会更高。所以，我分享所有这些信息只是为了说明市场实时发生的状况。鉴于 9 月份感觉还不错，但今天我们彻底完蛋了，很难规划 2023 年全年该做什么。我认为大多数创始人从董事会得到的建议是：当可见性有限时，你必须以最保守的方式进行规划。一方面，这当然是对的。你必须保守。但另一方面，你又不想过于保守，因为你不想在“我们要完蛋了”和“一切都好起来了”之间反复横跳。所以我对于在可见性有限且面临重大阻力时制定计划的想法是：设定一个非常保守的计划，然后设立里程碑，即短期里程碑，一旦达到这些目标，就可以解锁加大增长投入和支出的能力。举个例子。假设你今年实现了 1000 万美元的收入，而你不知道明年会是什么样子。也许你会说：“好吧，让我们按收入下降到 900 万来计划。尽管我们尽了最大努力，但由于市场会非常艰难，明年我们将损失 10% 的收入。”这意味着在第一季度你需要达到 250 万美元的收入。假设在第一季度，如果我们达到了 250 万，那么我们就应该上调今年剩余时间的目标，并解锁这部分额外的预算用于支出。如果我们低于 200 万，我们就应该下调数字。所以要习惯于定期重新预测。你不能每次只预测一个季度。显然，那是经营业务的一种艰难方式。所以你必须预测一年，但要设定里程碑、检查点，并做出预先确定的决定，以避免在进入第一季度时产生偏见，比如：“噢，我们第一季度没达标，但不，不，我们第二季度肯定能达标。”你必须预先设定目标，因为作为创始人，我们往往有乐观偏见。这通常是创始人的运作方式。在当今的市场中，这更多是一种劣势而非优势。所以我的建议是真正考虑保守预测，围绕未来成功可能或可能不成的样子设定检查点和里程碑。如果你达到了这些目标，那么根据你达到的情况减速或加速，并提前与你的董事会、销售团队、销售领导层达成一致，这样当你真正达到那个阶段时，对于该做什么就不会有争论。

---

### [00:19:06] Lenny

**English:**
That is awesome advice. As a PM, it makes me think a little bit about moving to an agile sprint sort of system versus this long term waterfall oriented planning process. Have you seen this need happen in the past? Is this the first time we need to plan to reforecast throughout the year? Or have you been through periods where this is just the way people operate when times are super uncertain?

**中文翻译:**
这是非常棒的建议。作为一名产品经理（PM），这让我想到了从长期的瀑布式规划流程转向敏捷冲刺（Agile Sprint）式的系统。你以前见过这种需求吗？这是我们第一次需要计划在全年进行重新预测吗？还是说你经历过在极度不确定的时期，人们就是这样运作的？

---

### [00:19:28] Sahil Mansuri

**English:**
First of all, I think the vast majority of CEOs and sales leaders haven't been through a period of dramatic uncertainty in their careers. I mean, there are obviously people who have been in business for more than 15 years and who have been through other downturns. But unless you were a sales leader, a CEO, an executive in 2008, which I would imagine that not very many people were or certainly not everyone was, then you haven't seen anything like this. People try to analogize it to COVID, but I think that that's actually not a good analog for this. The reason why is because COVID was an external factor versus this is actually an internal issue, which is to say that there are actually industries that are doing much better these days except for tech. Tech is getting crushed, right? In COVID, everyone's getting crushed. So it didn't matter if you owned a yoga studio or gas pump or whatever, a hotel. There was nothing that was working well unless I guess you owned Amazon Fresh or something. There were very few businesses that were doing better as a result of COVID. But there's a bunch of companies that aren't doing that bad. I mean, if you listen to other podcasts, you've probably seen that tech is the one that is getting the most hammered in this, although I think in the last two weeks, crypto has caught up pretty quickly. But it's really kind of tech, right? So when you see a slowdown in tech that is disproportionate, you have to assume that it may last for a much longer period of time than you imagine. I think that given the lack of visibility and the amount of volatility, I think it is a unique situation for most companies, for most leaders. I think that the only response to which is to try to get really comfortable with being wrong and adding new data in in order to make decisions regularly without the fear of coming across as not knowing what you're doing.

**中文翻译:**
首先，我认为绝大多数 CEO 和销售领导者在他们的职业生涯中都没有经历过如此剧烈的不确定时期。我的意思是，显然有些人经商超过 15 年，经历过其他的低迷期。但除非你在 2008 年是销售领导、CEO 或高管（我想人数并不多，或者肯定不是每个人都是），否则你没见过这样的场面。人们试图将其类比为 COVID，但我认为这实际上不是一个好的类比。原因是 COVID 是一个外部因素，而这实际上是一个内部问题，也就是说，除了科技行业外，实际上有些行业最近表现得更好。科技行业正在遭受重创，对吧？在 COVID 期间，每个人都遭受重创。所以无论你拥有瑜伽馆、加油站还是酒店，都没关系。除非你拥有 Amazon Fresh 之类的，否则没有什么业务运行良好。很少有企业因为 COVID 而变得更好。但现在有一堆公司表现得并不差。我的意思是，如果你听其他播客，你可能已经看到科技行业是受打击最严重的，尽管我认为在过去两周里，加密货币也很快赶上来了。但这真的主要是科技行业，对吧？所以当你看到科技行业的放缓是不成比例的时候，你必须假设它持续的时间可能比你想象的要长得多。我认为，考虑到缺乏可见性和波动程度，这对大多数公司和大多数领导者来说都是一个独特的情况。我认为唯一的应对方法就是努力适应“犯错”，并不断加入新数据以便定期做出决策，而不用担心被看作是不知道自己在做什么。

---

### [00:21:49] Sahil Mansuri

**English:**
Yeah, exactly. That's right. It's a gift to get model. So the way it works is that you enter your stats, and in doing so, you get global benchmarks of how you're doing versus other reps or other companies. So there's a premium for being accurate here because otherwise you don't actually get a real sense of how you're doing versus others. So there's an incentive structure that's built in to be really precise. Then that information feeds into our kind of global leaderboard where we are able to slice and dice and say, "Okay, of companies that are headquartered in San Francisco, here's how your company's doing. Of sales reps that sell to CMOs, here's how you're doing. Of reps who carried a quota of between 500, 700K this quarter, here's how you rank." So we do global benchmarking for sales reps and sales teams and we share that information for free to anyone who is willing to participate in the ecosystem.

**中文翻译:**
是的，没错。这是一种“给予以获取”（Gift-to-get）的模式。它的运作方式是：你输入你的统计数据，作为回报，你会获得全球基准，了解你相对于其他销售代表或其他公司的表现。因此，准确性在这里是有溢价的，因为否则你无法真正了解自己与他人的对比情况。所以内置了一个激励机制，促使数据非常精确。然后，这些信息会进入我们的全球排行榜，我们可以进行切片分析，比如：“在总部位于旧金山的公司中，你的公司表现如何；在向首席营销官（CMO）销售的代表中，你的表现如何；在本季度背负 50 万到 70 万美元配额的代表中，你的排名如何。”因此，我们为销售代表和销售团队进行全球基准测试，并向任何愿意参与该生态系统的人免费分享这些信息。

---

### [00:23:00] Sahil Mansuri

**English:**
So comp plans are, or compensation plans for sales, are very different than they are for most other profession. So in most professions, yours and product management, you have a base salary that encompasses the vast majority of your cash compensation. You then often have bonuses that are either based on company or sometimes personal milestone, which are often paid out end of quarter, end of year. Then you'll have an equity grant that you vest over the course of time. That's not how it works in sales. So the way it works in sales is that you have what's known as a base and then what's known as an OET. An OTE or on target earnings is how much you make if you hit quota. The most common ratio that you see in SaaS is what's known as a 50-50 split. So let's just use some round numbers. Let's say that your OTE is $200,000. What that means is that your base salary is actually only $100,000. So unlike in most other professions, sales reps make very little base salary, but their OTEs are often higher than in most other professions because they're variable, so the second $100,000 you unlock through your performance on the sales team. Again, I'm going to use the most common examples for this, and every combines different, et cetera, but what's really common is if you have a 200K OTE, 100K base, 100K commission, then your quota will be $1 million. So the ratio between your OTE and your quota is typically five to one. So your quota is usually 5X. This comes from this idea that your cost for a sales rep fully loaded should be about 20% so you can afford to pay 20% of your salary to a sales rep. So let's talk about what that all means. So what that means is that you as a salesperson have to sell $1 million of software in order to make $200,000 of money. But that $1 million of software is only around new business. The vast majority of account executives are only responsible for new business, which means top line revenue growth. So let's pick two theoretical examples. Okay, let's say they're sales rep A and sales rep B, and they both have the same quota, same OTE, okay? We're selling for the same product, same sales team. Sales rep A closes $1.5 million in 2022. Just for easy math, let's say that's 15 100K deals. So product is 100K. They sold us 15 deals a year. They would close $1.5 million. That means that they would hit 150% of quota. When that happens, when you exceed your quota, you hit in sales what are known as accelerators. So it's not like if you hit 1 million, you make 200, but if you hit 1.2 million, you just make an extra on that 200K. You actually often make extra money for exceeding your quota. The more you exceed your quota, the more money you make. So you would imagine that if someone sold 1.5 million, they wouldn't make 300K, which would be 20% cost to sale. They might make 400K. That's pretty common in sales. So this person who closed $1.5 million in business from 15 deals ends up making $400,000 and they get taken on a free trip to Cabo because they made President's Club and they're put on the leader board and the CEO of the company gives them an award at the end of the year and they are heralded as the pinnacle of all things that are sales. The VP of sales says, "Wow, I can't wait to clone 10 of you." That's how sales teams are set up, right? Then you have sales rep B. Sales rep B only closes 12 deals for 1.2 million. So they still exceed quota, but they only exceed quota by 20%, not 50%. That sales rep ends up making let's say 250K. So they make $150,000 less money. They don't get to go on the trip to Cabo. They don't get the award at the end of the year. They're not the ones that are celebrated or championed and they're seen as a good performer but not as good as team player A. That all makes a lot of sense in a world in which companies are really focused on top line growth. Nothing is more important than the amount of ARR you're making and how fast you're growing and investors are basically demanding that you go 3, 2, 2, 2, which is common parlance for if you make 5 million this year, you should make 15 million next year, you should make 45 million the year after, and then you can slow down to going 90 then 180. This is how VCs often think about funding SaaS companies. They look for this 3, 3, 2, 2 sort of multiple growth on ARR, new business ARR. That's how the world used to function until six months ago. Then six months ago, all of a sudden the music stopped and capital got expensive and everybody started being like, "Whoa, wait a minute. We should think about things like net dollar retention and we should think about what renewal rates look like and we should think about how efficient you are at acquiring customers." All of a sudden, profitability, efficiency, retention came into focus as everybody realized that unprofitable growth was no longer going to be rewarded because you couldn't just keep spending in order to acquire customers. Acquiring new customers was going to get harder so retaining the ones you had and making sure they were happy was actually far more important. So let's go back to our example. So team player player A who closed 15 deals for 1.5 million, poster child for the company, got $400,000. Let's say out of their 15 customers, 10 of them churn next year and only five of them actually end up renewing. How much does that affect player A's compensation, their performance, their celebration, et cetera? Doesn't affect them at all. Make no difference. 99% of SaaS companies are set up this way, right? Every SaaS company of, with very small exceptions, HubSpot, monday.com, there's a handful of them, except for very few SaaS companies, no difference to the salesperson's performance. It's seen as a failure of customer success. Other people get blamed for it. Sales rep, no change in their comp work or their success. Meanwhile, sales rep B who closed fewer deals, 12 of them. Let's say all 12 renew, and not only do all 12 renew, but let's say that three of them actually are so happy with the product and service that they're willing to be featured on your website as the folks that you advertise. Let's say six of them are actually willing to be references. So they help you close even more business by getting on the phone with prospective customers and are willing to actually advocate for your product. Let's say that not only do they renew, but four of them actually upsell because they're so happy they end up spending more and they sign multi-year contracts and whatnot. How much did that affect sales rep B's performance? Do we go back and revise and say, "Well, wait a minute. Actually sales rep B's customers were way better and actually we should probably have rewarded sales rep B because they actually had done the homework of finding the right clients instead of just shoving product down people's throats." No, none of that happens. Again, that kind of made sense up until six months ago, but it makes no sense today. So sales comp plans are stuck in the stone ages. They're stuck in the world of Glengarry Glen Ross, Boiler Room, Wolf of Wall Street, get the dollar in through the door, Matthew McConaughey [inaudible 00:30:45]. That's where sales comp plans are. What we haven't done is built a modern technical sales compensation plan that actually aligns the needs and incentives of the business, the customer and the rep. So I think that for a while there, I mean, I've been writing and talking about this for years, for a while there it fell on a lot of deaf ears because no one cared. People care now because all of a sudden for the first time, all of the things that we're talking about around retention and renewal rates and stuff are coming up. So I would say that my general advice to companies is to say what are the metrics that matter and ensuring that those metrics are the ones that your sales team is rewarded for. I also call into question the notion that your sales team should have a 50-50 split on compensation. By the way, that doesn't just extend to the sales team. That's often how the VP of sales is compensated. So your executive, your chief revenue officer, your VP of sales who sits at the same table as your CMO and your CFO and your COO, that person also has a 50-50 split in most cases. Sometimes it's 60-40, but it's very rarely 90-10, which is what it is for almost every other executive on your team. So salespeople get labeled as coin operated and mercenaries and all these other adages because the way we compensate them, the way we treat them, the way we measure them is in a mercenary sort of way. Again, I would call on founders and VCs and executives to rethink that and to instead come up with compensation that aligns the incentives, again, of the customer, the business and the rep and the leader. So I think that setting up a longer horizon where if the customer you sign up today ends up renewing tomorrow, the rep should get a kicker on it. We should look at what the overall renewal rate is of the sales rep comparing it of course to the renewal of the rest of the business. If one rep is doing a better job of qualifying the right customers upfront, they should be rewarded for that. So things like that I think are missing from sales compensation and I'm excited to see them come to the front this year.

**中文翻译:**
销售薪酬计划（Comp Plans）与大多数其他职业非常不同。在大多数职业中，比如你所在的产品管理领域，你有一个基本工资，它构成了你现金报酬的绝大部分。然后你通常会有奖金，要么基于公司里程碑，要么基于个人里程碑，通常在季度末或年底发放。然后你会有股权授予，随着时间的推移而归属。销售不是这样的。销售的运作方式是你有所谓的“底薪”（Base）和所谓的“OTE”。OTE（On-target earnings，目标收入）是指如果你达到配额，你能赚多少钱。在 SaaS 领域，你看到的最常见的比例是所谓的“50-50 分成”。让我们用一些整数。假设你的 OTE 是 20 万美元。这意味着你的基本工资实际上只有 10 万美元。所以与大多数其他职业不同，销售代表的基本工资非常低，但他们的 OTE 通常比大多数其他职业高，因为它是可变的，所以第二个 10 万美元是你通过在销售团队中的表现来解锁的。我将使用最常见的例子，每家公司都不同，但非常常见的是：如果你有 20 万的 OTE，10 万底薪，10 万佣金，那么你的配额将是 100 万美元。所以你的 OTE 和配额之间的比例通常是 5 比 1。也就是说，你的配额通常是 OTE 的 5 倍。这源于这样一个想法：一个销售代表的全额成本（Fully loaded cost）应该在 20% 左右，所以你可以负担得起将销售额的 20% 作为工资支付给销售代表。让我们谈谈这意味着什么。这意味着你作为一名销售人员，必须卖出 100 万美元的软件才能赚到 20 万美元。但这 100 万美元的软件仅限于新业务。绝大多数客户经理（AE）只负责新业务，这意味着总收入的增长。让我们举两个理论上的例子。假设有销售代表 A 和销售代表 B，他们有相同的配额，相同的 OTE，卖同样的产品，在同一个销售团队。销售代表 A 在 2022 年完成了 150 万美元的销售额。为了计算方便，假设那是 15 个 10 万美元的订单。产品是 10 万，他们一年卖了 15 个单子。他们完成了 150 万美元。这意味着他们达到了配额的 150%。当这种情况发生时，当你超过配额时，你就会触发销售中所谓的“加速器”（Accelerators）。所以并不是说如果你达到 100 万，你赚 20 万，如果你达到 120 万，你只是在那 20 万的基础上多赚一点。实际上，超过配额的部分通常会让你赚到额外的钱。你超过配额越多，赚的钱就越多。所以你可以想象，如果有人卖了 150 万，他们赚的可能不是 30 万（即 20% 的销售成本），他们可能会赚 40 万。这在销售中很常见。所以这个通过 15 个订单完成 1.5 亿美元业务的人最终赚了 40 万美元，他们被带去卡波圣卢卡斯（Cabo）免费旅行，因为他们进入了“总裁俱乐部”（President's Club），他们登上了排行榜，公司 CEO 在年底给他们颁奖，他们被誉为销售界的巅峰。销售副总裁会说：“哇，我等不及要克隆 10 个像你这样的人了。”这就是销售团队的设置方式，对吧？然后你有销售代表 B。销售代表 B 只完成了 12 个订单，共 120 万美元。所以他们仍然超过了配额，但只超过了 20%，而不是 50%。那个销售代表最终赚了，假设是 25 万美元。所以他们少赚了 15 万美元。他们没去成卡波旅行。他们没有得到年终奖。他们不是被庆祝或拥护的人，他们被视为表现不错但不如 A 球员。在公司非常关注总收入增长的世界里，这一切都非常有意义。没有什么比你创造的 ARR（年度经常性收入）金额和你增长的速度更重要了，投资者基本上要求你实现 3, 2, 2, 2 的增长（这是常用术语，意思是如果你今年赚 500 万，明年应该赚 1500 万，后年应该赚 4500 万，然后你可以放慢速度到 9000 万，然后是 1.8 亿）。这就是风投通常考虑资助 SaaS 公司的方式。他们寻找 ARR（新业务 ARR）的这种 3, 3, 2, 2 倍数增长。直到六个月前，世界还是这样运作的。然后六个月前，音乐突然停止了，资本变得昂贵，每个人都开始说：“喔，等一下。我们应该考虑净金额留存（Net Dollar Retention）之类的事情，我们应该看看续约率是什么样的，我们应该看看你获取客户的效率如何。”突然之间，盈利能力、效率、留存成为了焦点，因为每个人都意识到，不盈利的增长将不再受到奖励，因为你不能为了获取客户而不断砸钱。获取新客户将变得更加困难，因此留住已有的客户并确保他们开心实际上要重要得多。让我们回到我们的例子。团队成员 A 完成了 15 个订单，共 150 万美元，是公司的典范，拿到了 40 万美元。假设在他们的 15 个客户中，有 10 个在明年流失了，只有 5 个最终续约了。这会对 A 的薪酬、表现、荣誉等产生多大影响？完全没有影响。没有任何区别。99% 的 SaaS 公司都是这样设置的，对吧？除了极少数例外（HubSpot, monday.com 等少数几家），绝大多数 SaaS 公司对销售人员的表现没有任何区别。这被视为客户成功（Customer Success）部门的失败。其他人会因此受到指责。销售代表的薪酬或成功没有任何变化。与此同时，销售代表 B 完成的订单较少，只有 12 个。假设这 12 个客户全部续约，不仅全部续约，而且假设其中有 3 个对产品和服务非常满意，以至于愿意出现在你的网站上作为广告案例。假设其中有 6 个实际上愿意担任推荐人（References）。所以他们通过与潜在客户通话并愿意为你的产品代言，帮助你达成了更多的业务。假设他们不仅续约了，而且其中 4 个实际上还增购了，因为他们太开心了，最终花了更多的钱，签署了多年合同等等。这对销售代表 B 的表现有多大影响？我们会回去修改并说：“嗯，等一下。实际上销售代表 B 的客户要好得多，实际上我们可能应该奖励销售代表 B，因为他们实际上做了寻找正确客户的功课，而不是仅仅把产品强加给别人。”不，这些都不会发生。同样，这在六个月前是有道理的，但在今天毫无道理。所以销售薪酬计划还停留在石器时代。它们停留在《格伦加里·格伦·罗斯》（Glengarry Glen Ross）、《锅炉房》（Boiler Room）、《华尔街之狼》的世界里，就是把钱拿进门，像马修·麦康纳在电影里演的那样。这就是销售薪酬计划的现状。我们还没有建立一个现代的技术销售薪酬计划，能够真正将业务、客户和代表的需求与激励措施结合起来。所以我认为在一段时间内（我的意思是，我已经就此写过并谈论过多年了），它在很大程度上被当成了耳边风，因为没人在乎。现在人们在乎了，因为突然之间，我们谈论的所有关于留存、续约率之类的事情都浮出了水面。所以我对公司的总体建议是：确定哪些指标是重要的，并确保你的销售团队是根据这些指标获得奖励的。我还质疑销售团队应该采用 50-50 薪酬比例的观念。顺便说一句，这不仅仅延伸到销售团队。销售副总裁通常也是这样获得报酬的。所以你的高管，你的首席营收官，你的销售副总裁，他们与你的 CMO、CFO 和 COO 坐在一起，在大多数情况下，那个人的薪酬也是 50-50 分成。有时是 60-40，但极少是 90-10（而你团队中几乎所有其他高管都是这个比例）。所以销售人员被贴上了“金钱驱动”（Coin operated）和“雇佣兵”之类的标签，因为我们补偿他们的方式、对待他们的方式、衡量他们的方式就是一种雇佣兵的方式。我再次呼吁创始人、风投和高管们重新思考这一点，转而制定出能够协调客户、业务、代表和领导者利益的薪酬方案。因此，我认为设定一个更长远的视野，如果今天签约的客户明天续约，代表应该得到奖励。我们应该查看销售代表的总体续约率，当然要将其与业务其余部分的续约率进行比较。如果一个代表在前期筛选正确客户方面做得更好，他们应该为此得到奖励。所以我认为销售薪酬中缺少这些东西，我很高兴看到它们在今年被推到台前。

---

### [00:33:36] Sahil Mansuri

**English:**
I'll answer the second question first because the answer to the first question is really simple. I think that there is a lack of transparency around how a lot of sales compensation plans work and companies tend to make it up as they go along. Oftentimes companies change their comp plans like each month, each quarter based on whatever is the business unit or the goal of the business. So I've seen things like, oh, company release product B after only selling product A. So we'll double the commission on product B because we want to get it in people's hands. Or we really want to target CPG customers so CPG customers are worth extra commission. So companies tend to weigh down comp plans with basically a bunch of bullshit that doesn't have anything to do with how the compensation plan should be structured, but just has to do with the whims of the executives and the board that month or that quarter. So I don't know of any organizations I think do this excellently. I just know a lot of companies that do it better than most. I think it depends on your company or business and your incentive. But I would say that in today's economy, taking a longer term view to a sales compensation, instead the short term, like you're a hunter, your job is just to close deals and doesn't really matter, a dollar is a dollar no matter where it comes from is not true anymore. So I guess that's the answer to that. Coming back to the other question though, which is why are sales comp plans not innovated off of because this seems obvious? First of all, it's obvious because of how I explained it. I'm not taking credit for it. It's just that I'm giving you a lot of context that you would not get otherwise, right? The context you would get otherwise if you just walked in and you got your traditional old school VC and CEO doesn't really know what they're doing and just listening to their board is like, here's how sales comp plans work, right? You want to grow revenue, you want to get customers, you got to pay top dollar and you got to fire them up and set aggressive quotas and you got to push them and you want to put these big spiffs out there because that's how salespeople work. A founder doesn't know. This is the problem is that people don't know because nobody really understands sales and salespeople. They just kind of are like, "Well, I can't sell and I don't really want to do that. So I'm just going to hire this 50 year old white guy who's done this at a bunch of different companies and then have him bring in because it's always a 50 year old, it's always a white person and it's always a guy, right?" Sales is one of the least diverse professions when it comes to leadership and it's one of the things that we really champion here at Bravado is this idea that 92% of sales leaders or VPs of sales are white. Over 85% of sales leaders are white. So is that representative of the total population of who should be a sales leader? No, of course not. It's just representative of the fact that like, oh, you don't want to innovate here. Just hire someone who's been there, done that before. So you get a lot of sludge in the system. You get a lot of people doing the same shit over and over again even though it doesn't work, which is kind of the opposite of that Einstein quote, right? So founders don't know how to set comp plans. They are just listening to what other people tell them should be the way they do it. There's a way it's done and it's really hard to break that. It's kind of like when you talked about waterfall versus agile. Once you do agile you're like, "Wait, why would we have ever done it the other way?" Well, it's because everyone was always doing it that way, et cetera, et cetera. No one ever got fired for buying IBM, et cetera. You get where I'm going. But the other thing Lenny that I think is problematic is everyone loves to optimize in the short run when it comes to revenue in sales. That's really I think the other big driver. If I offered you a plan that said, hey, you can grow by 20% revenue quarter over quarter or we can spike revenue by 75% this quarter though I don't know what that's going to do to the business in the future. Which of these do you want? Tell me how many founders really are willing to take option A? What do you think? Let's say I just told you those were your options. I can figure out a way to increase revenue by 75% this quarter though I can give you no promise as to what that means for the future. Or I can make you a plan where we increase revenue 20% quarter over quarter for the next six quarters. Which of those two plans would you sign up for? What do you think is a percentage of startup founder six months ago, eight months ago, 10 months ago to indefinitely that would've signed up for plans?

**中文翻译:**
我先回答第二个问题，因为第一个问题的答案非常简单。我认为很多销售薪酬计划的运作方式缺乏透明度，公司往往是随心所欲地制定。通常公司会根据业务部门或业务目标，每个月或每个季度更改薪酬计划。所以我见过这样的情况：哦，公司在只卖产品 A 之后发布了产品 B，所以我们会把产品 B 的佣金翻倍，因为我们想把它推到人们手中。或者我们真的很想针对 CPG（消费品）客户，所以 CPG 客户值得额外的佣金。因此，公司往往会在薪酬计划中塞进一堆废话，这些废话与薪酬计划应该如何构建没有任何关系，而只是与那个月或那个季度高管和董事会的突发奇想有关。所以我不知道有哪家组织在这方面做得非常好。我只知道很多公司做得比大多数公司好。我认为这取决于你的公司或业务以及你的激励措施。但我想说的是，在今天的经济形势下，对销售薪酬采取长期观点，而不是短期观点（比如你是一个猎人，你的工作只是达成交易，其他的都不重要，一美元就是一美元，不管它来自哪里），这种老观念已经不再适用了。所以我想这就是那个问题的答案。回到另一个问题，即为什么销售薪酬计划没有创新，因为这看起来很明显？首先，它之所以明显是因为我的解释方式。我不是在揽功。只是我给了你很多你平时得不到的背景信息，对吧？如果你只是走进去，遇到传统的老派风投和不太清楚自己在做什么、只是听从董事会意见的 CEO，你得到的背景信息就是：销售薪酬计划就是这么运作的，对吧？你想增加收入，你想获得客户，你就得付高薪，你就得激励他们，设定激进的配额，你就得逼他们，你想提供大额的销售奖励（Spiffs），因为销售人员就是这么工作的。创始人不知道。这就是问题所在——人们不知道，因为没有人真正理解销售和销售人员。他们只是觉得：“好吧，我不会卖东西，我也不想做那个。所以我打算雇一个在很多不同公司做过这个的 50 岁白人男性，然后让他带人进来，因为销售负责人总是 50 岁，总是白人，而且总是男性，对吧？”在领导层方面，销售是多样性最差的职业之一，这也是我们在 Bravado 真正倡导的一点：92% 的销售领导者或销售副总裁是白人。超过 85% 的销售领导者是白人。那么这能代表谁应该成为销售领导者的总人口吗？不，当然不。这只是代表了一个事实：哦，你不想在这里创新。只要雇一个曾经做过、有经验的人就行了。所以系统中会有很多淤泥。你会看到很多人一遍又一遍地做同样的事情，即使它不起作用，这有点像爱因斯坦那句名言的反面，对吧？所以创始人不知道如何设定薪酬计划。他们只是听别人告诉他们应该怎么做。有一种既定的做法，很难打破。这有点像你谈到的瀑布式与敏捷式。一旦你采用了敏捷，你就会想：“等等，我们为什么要用另一种方式呢？”嗯，那是因为每个人一直都是那样做的，等等等等。没有人因为购买 IBM 的产品而被解雇，诸如此类。你明白我的意思。但 Lenny，我认为有问题的另一件事是，在销售收入方面，每个人都喜欢在短期内进行优化。我认为这是另一个巨大的驱动因素。如果我给你提供一个计划，说：嘿，你可以实现季度环比 20% 的收入增长；或者我们可以在本季度将收入激增 75%，但我不知道这会对未来的业务产生什么影响。你想要哪一个？告诉我，有多少创始人真的愿意选择选项 A？你觉得呢？假设我刚才告诉你这就是你的选择。我可以想办法在本季度增加 75% 的收入，但我不能向你保证这对未来意味着什么。或者我可以为你制定一个计划，在接下来的六个季度里，我们每季度增加 20% 的收入。你会签署这两个计划中的哪一个？你认为六个月前、八个月前、十个月前甚至更早以前，会有百分之多少的初创公司创始人签署第一个计划？

---

### [00:38:01] Lenny

**English:**
Yeah, it's interesting. Hearing you describe the way it should be structured and then hearing you pitch this. I would definitely pick goal one. Let's grow. Let's get this. It'll work out, it'll work its way out. We'll figure it out later. Let's just keep new customers coming in. So I don't know. I guess like 99% probably choose that first one.

**中文翻译:**
是的，这很有趣。听你描述应该如何构建，然后听你推销这个。我肯定会选目标一。让我们增长吧。拿下这个。它会解决的，船到桥头自然直。我们以后再想办法。只要让新客户不断进来就行。所以我不知道。我猜大概 99% 的人可能会选第一个。

---

### [00:38:25] Sahil Mansuri

**English:**
Yeah, I think that's right. Well, I mean that is right because that's what everyone signed up for. But then all of a sudden, and again, that was okay because even if all your customers churned, it didn't matter because you could just go raise more money based on the growth and then just keep pouring more money on it, more money on it. No one gave a shit about the leaky bucket, right? Because you could just keep adding more water at the top. Now all of a sudden the faucet's off. So given this seismic change in the market, how is it that we can reverse the short term thinking and start to actually build good businesses? Because I think that's the real problem, right? The real problem isn't sales compensation plans and quotas. That's a symptom. A real problem is we all just wanted to have hyper growth instead of thinking are we actually building good businesses. I wouldn't say that we at Bravado were immune from this by the way. It's not like I'm sitting here on my golden throne pontificating to the masses. We made a bunch of decisions over the course of growing this business that were incentivized for the short term. Every single time we did that, it ended up being really expensive. Now, sometimes we caught that before money ran out and before we saw the problem. Sometimes we didn't and then we were like, "Oh, shit. It's a fire drill." But at the end of the day, there is no replacement for building a product that customers love and having a great go to market motion that brings that product and that value to your clients and ensuring that they actually are thrilled that they bought your product and are getting a lot of value from it. Yeah, it sounds so simple, but the amount of companies that actually don't really care if their customers get value from their product versus just measuring top line revenue growth numbers and logos and whatever is I think more meaningful than people are willing to admit.

**中文翻译:**
是的，我认为那是对的。我的意思是，那是事实，因为那是每个人都签署的。但随后突然之间——再次强调，那在以前是没问题的，因为即使你所有的客户都流失了，也没关系，因为你可以根据增长去筹集更多的钱，然后继续往里砸钱，砸更多的钱。没有人关心那个“漏水的桶”，对吧？因为你可以一直从顶部加水。现在突然之间，水龙头关掉了。因此，考虑到市场的这种剧烈变化，我们如何才能扭转短期思维，开始真正建立好的企业？因为我认为这才是真正的问题，对吧？真正的问题不是销售薪酬计划和配额。那只是症状。真正的问题是我们都只想要超高速增长，而不是思考我们是否真的在建立好的企业。顺便说一句，我并不是说我们 Bravado 就能置身事外。我并不是坐在我的金宝座上对大众说教。在发展这项业务的过程中，我们也做了一堆受短期激励的决定。每一次我们这样做，结果都非常昂贵。现在，有时我们在钱花光之前、在看到问题之前就发现了。有时我们没有发现，然后我们就想：“噢，该死。这是一场紧急演习。”但归根结底，没有什么能替代构建客户喜爱的产品，并拥有出色的进入市场（Go-to-market）动作，将该产品和价值带给你的客户，并确保他们真的为购买了你的产品而感到兴奋，并从中获得了巨大的价值。是的，这听起来很简单，但实际上并不关心客户是否从他们的产品中获得价值，而只是衡量总收入增长数字和客户 Logo 等的公司数量，我认为比人们愿意承认的要多得多。

---

### [00:41:28] Lenny

**English:**
That's a great segue to the third topic, which is around retaining your existing customers and putting more focus on that versus top line, or yeah, new growth. Do you have some thoughts on just how to do that and why that's so important?

**中文翻译:**
这是一个很好的过渡，引出了第三个话题，即围绕留住现有客户，并将更多精力放在这上面，而不是总收入或新增长。关于如何做到这一点以及为什么这如此重要，你有什么想法吗？

---

### [00:41:42] Sahil Mansuri

**English:**
Let's start here, which is cold call, cold email response rates have never been lower. Never been lower. I think you're seeing this across every sales team. Again, if you're listening to this and you have a sales team, you know what I'm saying is true. Top of funnel pipeline is drying fast faster than our planet's drying up in fact. Enterprise sales cycles are just getting longer and longer. We are lucky to have a couple of investors who have really, really broad exposure to the tech market. Everything from really large public IPOs all down to small startups. In conversations with them, they've been really clear that they're seeing this incredible, the average enterprise sales cycle is 62 days, it's now like 115 days or something. So customers are dragging their feet, everything's going to no decision, no decision typically means I'm not going to say yes now because I don't want to spend the money. I actually like the thing but I'm not going to buy it. Which means the same thing for you as a business, which is that you're not making any money. So in a world in which you can't sell to new customers, your only hope is to keep the ones you got for long enough to survive and then hopefully even maybe be able to upsell and cross-sell those customers into new products, as well as potentially leverage those customers to get warm intros into a potential new business. Psychologically, when times are tough people hoard, people keep their things close and people trust the safety of those they know versus those they don't. This is basic human psychology, right? So given that that's the case, if you're a company that doesn't have a lot of customers and you're trying to go out to market and sell your product, you're in a lot of trouble. If you are a company that has a large customer base and you've done a shitty job of engaging, retaining, maintaining relationships with them and prioritized top of line growth, this is your alert. This section is for you. Because what you should be doing, I will tell you the most dramatic thing you could do and then we can kind of work backwards. Take your best sales people and make them CSMs. There's no point. There's no point in having your best salespeople sell. Well, what's the point if people aren't going to buy anyway? If they do, they're going to buy in onesie, twosies, not these big enterprise deals. No one's going to sign these big accounts right now. Who in tech today is like, "Wow, I can't wait to sign a multi-year contract with a new vendor we've never tried." Right? Nobody's doing that. If people are signing things, they're signing for three month pilots or kind of like all sort... I mean, the deal sizes are coming down, et cetera. I mean, this is all very common. Make your best sales people CSMs and be like, "Your job is to make sure that all these great customers we have never, ever, ever leave."

**中文翻译:**
让我们从这里开始：冷启动电话和冷启动邮件的回复率从未如此之低。从未如此之低。我想你在每个销售团队中都能看到这一点。同样，如果你正在听这个播客并且你有一个销售团队，你就知道我说的是真的。漏斗顶部的管道（Pipeline）干涸的速度比我们星球干涸的速度还要快。企业级销售周期正变得越来越长。我们很幸运有几位投资者，他们对科技市场有着非常广泛的接触，从大型上市 IPO 到小型初创公司。在与他们的谈话中，他们非常明确地表示，他们看到了这种令人难以置信的现象：平均企业销售周期以前是 62 天，现在变成了 115 天左右。所以客户在拖延，一切都变成了“无决策”（No decision）。“无决策”通常意味着“我现在不想说好，因为我不想花钱。我其实喜欢这个东西，但我现在不买。”这对你作为一家企业来说意味着同样的事情，那就是你赚不到钱。因此，在一个你无法向新客户销售的世界里，你唯一的希望就是留住已有的客户，让他们留存足够长的时间以维持生存，然后甚至可能向这些客户增购或交叉销售新产品，并可能利用这些客户获得对潜在新业务的“温暖介绍”（Warm Intros）。从心理学上讲，当日子艰难时，人们会囤积，人们会把东西抓得很紧，人们更信任熟人的安全性，而不是陌生人。这是基本的人类心理学，对吧？既然如此，如果你是一家没有多少客户的公司，而你正试图进入市场销售你的产品，你就有大麻烦了。如果你是一家拥有庞大客户群的公司，但你在与他们互动、留存、维护关系方面做得一团糟，并且优先考虑总收入增长，那么这就是给你的警报。这一节是为你准备的。因为你应该做的是——我会告诉你你能做的最戏剧性的事情，然后我们可以反向推导：把你最好的销售人员变成客户成功经理（CSM）。没有意义。让你最好的销售人员去跑销售没有意义。既然反正人们都不打算买，那还有什么意义呢？即使他们买，也只是零星地买，而不是那种大型企业订单。现在没有人会签这些大单。今天科技界有谁会说：“哇，我等不及要和一个我们从未尝试过的新供应商签一份多年合同了。”对吧？没人会这么做。如果人们在签东西，他们签的是三个月的试点项目，或者各种……我的意思是，交易规模正在下降，等等。我的意思是，这都非常普遍。让你最好的销售人员去做 CSM，并告诉他们：“你的工作就是确保我们拥有的所有这些伟大的客户永远、永远、永远不要离开。”

---

### [00:44:33] Lenny

**English:**
CSM is a customer success manager?

**中文翻译:**
CSM 是指客户成功经理（Customer Success Manager）吗？

---

### [00:44:35] Sahil Mansuri

**English:**
Thank you. Sorry, sorry. I'm too jargony. Thank you. So typically most sales orgs are divided into pre-sales and post-sales. Pre-sales worked with companies that are not yet customers to get them to sign up. Post-sales works with companies that have already signed up to help them either find value or retain or renew or upsell. That's how most sales orgs are divided. Typically, you put your best people in pre-sales because it's harder. It's harder to sell a new customer than retain the one you have. That's always the case because you got to actually be able to build trust, build the relationship, evangelize something that they haven't bought before. So you typically take your best talent and put it in pre-sales, and then you take the people who are really good relationship builders and really caring and nurturing and not necessarily the people who are the most gifted at creating value or whatnot and you put them in CSM. That's obviously a huge generalization because I know many CSMs who are much better at sales and new business. In many businesses, it's actually harder to be a CSM because the product isn't very good. So you actually have to do a lot of selling even after the product is sold. So that was a big generalization. But it is, in broad strokes, true. I would take your best account executives, pre-sales reps and I'd put them into CSM. I'd say it doesn't matter how much new business we work on in the next six to nine months because it's going to be hard anyway. But what we cannot under any circumstances do is lose our existing customers because replacing them is going to be impossible. So it's kind of like you got your leaky bucket, you got to patch that leak really, really fast and really hard. I think putting your best people on it is one good way to start. Now, there's a lot of people who are going to listen to this and think that's crazy. Why would I take my best performer in a tough market and move them to post-sale? This is bad advice. Maybe. Maybe it's bad advice. I can't predict the future anymore than anyone else can. But I can tell you it's what we're doing. I can tell you I'm actually doing it. We're taking our best people and are moving them into CSM at Bravado. We're trying to maintain every customer we have because I believe that doing so sets us up for the best chance of success in the business. Maybe you disagree with that and you think that that's not right for you. You should do what's right for your business. But I would say that it's not just talk, it's action. I'm doing it. I'm also telling every one of my portfolio, I do a decent amount of angel investing, I'm telling everyone of my portfolio companies to do the same thing. Discussing the same thing with our investors, with our board as well.

**中文翻译:**
谢谢。抱歉，抱歉。我用了太多术语。谢谢。通常大多数销售组织分为售前（Pre-sales）和售后（Post-sales）。售前负责与尚未成为客户的公司合作，让他们签约。售后负责与已经签约的公司合作，帮助他们发现价值、留存、续约或增购。这就是大多数销售组织的划分方式。通常，你会把你最优秀的人放在售前，因为这更难。向新客户销售比留住现有客户更难。情况总是如此，因为你必须能够建立信任、建立关系、宣传他们以前从未买过的东西。所以你通常会把最优秀的人才放在售前，然后把那些非常擅长建立关系、非常有爱心和耐心，但不一定是那些在创造价值等方面最有天赋的人放在 CSM。这显然是一个巨大的概括，因为我知道很多 CSM 在销售和新业务方面做得更好。在许多企业中，做 CSM 实际上更难，因为产品不是很好。所以即使在产品售出后，你实际上也必须做大量的销售工作。所以那是一个很大的概括。但大体上是真的。我会把你最好的客户经理（AE）、售前代表放进 CSM。我会说，在接下来的六到九个月里，我们做多少新业务并不重要，因为反正也很难。但在任何情况下，我们都不能失去现有的客户，因为更换他们将是不可能的。所以这有点像你有一个漏水的桶，你必须非常、非常快、非常用力地补上那个漏洞。我认为把你最优秀的人放在这上面是一个很好的开始。现在，会有很多人听了之后觉得这太疯狂了。为什么我要在艰难的市场中把我表现最好的人调到售后？这是个坏建议。也许吧。也许这是个坏建议。我无法像其他人一样预测未来。但我可以告诉你这是我们正在做的。我可以告诉你我实际上正在这么做。在 Bravado，我们正把最优秀的人调到 CSM。我们正努力维持我们拥有的每一个客户，因为我相信这样做能让我们在业务中获得最大的成功机会。也许你不同意这一点，你认为这不适合你。你应该做对你的业务正确的事情。但我想说的是，这不仅仅是说说而已，而是行动。我正在做。我也在告诉我的每一个投资组合（我做了相当数量的天使投资），我告诉我的每一个投资组合公司都要做同样的事情。我也在和我们的投资者、我们的董事会讨论同样的事情。

---

### [00:46:58] Sahil Mansuri

**English:**
Okay so you put your best people on it. What else should you? So I think that what often goes underserved is the opportunity to help your customers themselves survive. I don't know. What's a good product example? Let's take something like a analytics product. Let's pick on Amplitude or Mixpanel or pick your favorite. If I was a company like that and I was like, "Okay, don't know how many new customers I may be able to sell, but I've got a lot of really good customers I want to keep." I would invest a tremendous amount of energy into helping product managers and product leaders get benchmarks and stats on how other product teams, what changes they're making. Because the advantage you have as a vendor, this is advantage we have in sales as Bravado, but it's the advantage that every vendor has is you get a cross-section of what everyone who fits a certain ICP is doing at the same time. How good are you at extracting value out of that and finding ways of becoming less of a tool as part of the SaaS stack and more of a value added advisor that can help you actually plan and prepare for what to do next. I think most companies are not good at it. They put out a white paper for lead gen. I want to put out a white paper for customer retention. One thing that we're actually doing is we're basically saying to all of our clients, "Hey, we'll tell you what percentage of companies that look like you are hiring or not hiring. I'll tell you how they're adjusting quotas. I'll tell you how they are changing their comp plans. I'll tell you how much they're paying. I'll tell you what percentage of their sales teams' hitting quota, et cetera, if you stick around with us as a client." I'm not just placing sales reps and say we make our business as a recruiting marketplace. So we help companies hire salespeople. Obviously that's slowed down tremendously because people are scared to hire and spend money right now. But if they're getting insights on what's happening in the market, that's still valuable. That's still something that they can't get elsewhere that I am uniquely positioned to offer to my customer base. What are you uniquely positioned to offer to your customer base? Let's pick another example that I think is really easy which is Greenhouse or Lever or another app and tracking system. If you're an ATS and all of a sudden every recruiting budget's getting slashed and recruiters are getting laid off faster than any other department because no one's hiring, et cetera, you're probably at the most risk of being ripped out or being downsized or getting downward pressure to your [inaudible 00:49:37]. Can you do that nobody else can do in order to give your customers a really good insight into how they should navigate thinking about hiring versus layoffs versus headcount versus burn per department, et cetera? You've got some really interesting data, don't you? You know exactly how many customers have paused, how many roles and whatnot. If I was Greenhouse, I would be putting out all kinds of reports that tell me, let's use me as a customer here, "Hey, of series B companies that have roughly 50 employees, they used to have eight open head count, but now they're down to four. The main area that they're investing are X, Y, and Z. Salaries are moving up and down." You could get a lot of insight from a company like Greenhouse. Then I'd be like, "Whoa, this is so valuable. I can't live without this data because this is actually helping guide my business decisioning." I think moving from a world where you're just focused on how can I jam product down your throat to how do I use my unique perspective in the customer segment we serve in order to create broader insights for the industry is something I would heavily prioritize. I'd take my product marketing team and I'd kind of shift them to be my research team. I'd take a data analyst or two and stick them on the project and start to create content that is exclusive for my customers and have them see that as another point of value that they can get that would maybe help stay off chart.

**中文翻译:**
好，所以你把你最优秀的人放在这上面。你还应该做什么？我认为，经常被忽视的机会是帮助你的客户自己生存下去。我不知道，举个好的产品例子？让我们以分析产品为例。让我们选 Amplitude 或 Mixpanel，或者你喜欢的任何一个。如果我是一家那样的公司，我会想：“好吧，不知道我能卖给多少新客户，但我有很多非常好的客户我想留住。”我会投入巨大的精力帮助产品经理和产品领导者获得关于其他产品团队正在做出哪些改变的基准和统计数据。因为作为供应商，你拥有的优势（这也是我们 Bravado 在销售方面的优势，也是每个供应商拥有的优势）是你可以同时获得符合特定 ICP（理想客户画像）的所有人都在做什么的横截面数据。你有多擅长从中提取价值，并找到方法让自己不再仅仅是 SaaS 堆栈中的一个工具，而更多地成为一个增值顾问，能够帮助客户实际规划和准备下一步该做什么？我认为大多数公司都不擅长这一点。他们发布白皮书是为了获取潜在客户（Lead Gen）。我想发布一份关于客户留存的白皮书。我们实际上正在做的一件事是，我们基本上对所有的客户说：“嘿，如果你继续作为我们的客户，我们会告诉你像你这样的公司有多少比例在招聘或不招聘。我会告诉你他们如何调整配额。我会告诉你他们如何改变薪酬计划。我会告诉你他们付多少薪水。我会告诉你他们销售团队达到配额的百分比，等等。”我不仅仅是在安置销售代表，我们把业务做成一个招聘市场。所以我们帮助公司招聘销售人员。显然，由于人们现在害怕招聘和花钱，这已经大大放缓了。但如果他们能获得关于市场正在发生什么的见解，那仍然是有价值的。那仍然是他们在其他地方得不到的东西，而我处于独特的地位，可以向我的客户群提供这些。你处于什么独特的地位可以向你的客户群提供什么？让我们再举一个我认为非常简单的例子，比如 Greenhouse 或 Lever 或其他应用和追踪系统。如果你是一个 ATS（招聘管理系统），突然之间每个招聘预算都被削减了，招聘人员被解雇的速度比任何其他部门都快，因为没有人招聘，等等，你可能面临最大的被撤换、被缩减规模或面临降价压力的风险。你能做些别人做不到的事情，给你的客户提供一个非常好的见解，告诉他们应该如何处理关于招聘、裁员、员工人数、每个部门的烧钱率等方面的思考吗？你有一些非常有趣的数据，不是吗？你确切地知道有多少客户暂停了招聘，有多少职位空缺等等。如果我是 Greenhouse，我会发布各种报告告诉我（假设我是这里的客户）：“嘿，在拥有大约 50 名员工的 B 轮公司中，他们过去有 8 个开放名额，但现在减少到了 4 个。他们投资的主要领域是 X、Y 和 Z。薪水正在上下波动。”你可以从像 Greenhouse 这样的公司获得很多见解。然后我会觉得：“哇，这太有价值了。我离不开这些数据，因为这实际上是在帮助指导我的业务决策。”我认为，从一个只关注“我如何把产品塞进你喉咙”的世界，转向“我如何利用我们在所服务的客户细分市场中的独特视角，为行业创造更广泛的见解”的世界，是我会重点优先考虑的事情。我会把我的产品营销团队转变为我的研究团队。我会找一两个数据分析师加入这个项目，开始创作专门针对我客户的内容，让他们把这看作是他们可以获得的另一个价值点，这也许能帮助防止流失。

---

### [00:51:07] Lenny

**English:**
I love that advice. Be helpful. Find ways to be helpful even if your core product isn't... Basically go above and beyond what you're already doing as a software product and find ways to help your companies be more successful. Feels like there's just a ton of nuggets you just shared. I want to make sure we also get to this other topic that I think is also going to have a lot of great nuggets, which is around just advice for closing deals in this time. You touched on a couple of these, warm intros, a couple things. Anything else you could share of just ways to increase the rate at which you close deals during this wild time in the market?

**中文翻译:**
我喜欢这个建议。要乐于助人。即使你的核心产品不是……也要想办法提供帮助。基本上要超越你作为软件产品已经在做的事情，想办法帮助你的公司变得更成功。感觉你刚才分享了大量的干货。我想确保我们也讨论另一个我认为也会有很多干货的话题，那就是关于在这个时期达成交易的建议。你提到了其中的几点，温暖介绍（Warm Intros）之类的。关于在这个疯狂的市场时期提高成交率的方法，你还有什么可以分享的吗？

---

### [00:51:40] Sahil Mansuri

**English:**
This is a good segue because it'll bridge us back to where you just came from and hopefully move us forward, which is warm intros. So if cold outreach is going to be less effective, then what increases in efficacy in this time is, again, warm intros. So one thing you got to remember as a more general statement is that companies either grow or they die. There are no middle. There's no, "Oh, we're going to cut burn and just try to survive the winter long enough so that..." That doesn't work, right? Because employees get demoralized, investors lose faith, the days become long and the nights become longer and eventually you just run out of energy as a business. I think startups in particular are effectively energy driven. The more energy, the more belief, the more momentum that you have, the more tailwinds you have, the more things grow and feel possible. But of course if you look at the odds empirically, no startup should never begin because the odds are you're going to fail. That failure meets you in the eye over and over again as you're shrinking the size of your team, as you're shrinking the size of your budget, as you're doing fewer things and you're taking things away. So I don't really believe in this like, oh, we are just going to survive mentality. I think you have to adjust, of course. I think you have to be a realist. I'm not suggesting that you be blind to reality. I'm just suggesting you also have to keep the energy going. So what I mean by keeping the energy going is to say, "Okay, let's get..." So here's a couple ideas. First is let's cut a bunch of stuff but keep some money that we're going to invest in doing an in-person customer event. Okay, why do I think that's a good idea? I think it's a good idea because, first of all, we've all been stuck in our houses for a couple years and so when we get a chance to go on a trip for free somewhere, we tend to say yes. That's nice. Secondly, I think that you could be strategic and maybe have the trip be for customers only and in February or something. So maybe you survive the budget cuts this year because people are like, "Well, I got this great trip and I really don't want to miss it. Is there a way we can just keep this tool on?" You might think, "Oh, well, are you bribing customers or whatever?" I mean, it's just psychology. I think you have to use psychology to your advantage. I would do a big customer event in February, invite all my current customers and say, "Hey, as long as you're still a customer as of Feb 10, 2023, you're invited to this all paid trip to Napa to go drink a bunch of wine for a week." I bet that would probably meaningfully change your churn rate. Yeah, it's not going to change everything but it'll change something. I bet it would. Because at the end of the day, people are people. Sales is done by people. It's a belly to belly human sport. It's not just lines of code on a piece of paper. You got to talk to another human, which is what makes it hard and unscalable and more of an art than a science. But also makes it really fun because it just plays by different rules, a different set of rules than many other things do. Recruiting being the other thing that is this. So in-person customer event. The other reason why I like in-person customer events is because they're a perfect opportunity for you to get new deals done. So how does that work? Does that mean I also invite prospects to the event? No, actually I wouldn't do that. So I think a lot of companies do this where they'll invite customers and prospects to the same event. They're like, "Oh, commingle and sell each other." Not the smartest way to do it. You want only customers in the event and you want to use that again to share thought leadership and such. But then, during all the happy hours and the lunches and the late evenings and whatnot where you start to say, "Hey look, in this market you're finding value in our product. Who are one or two other folks that you know in the same position as yourself that might also find value? Who do you know that has the same problem? Who do you know that's going through this? Who do you know that might benefit from this research paper, et cetera?" You just start collecting a bunch of warm interest. But then you don't just stop at getting the name because a lot of teams stop here. They'll basically get the name and then they'll be like, "Okay, got the name. Now I'm done." Actually not the right way to do it. You get the name and you say, "Great, can you make me an e-intro? Actually even better. Can you connect me over text?" So one tip that I have for all founders, all sales leaders, everyone out there, stop using email. Email is where deals go to die. Text message is where deals get done. So this notion that I'm going to e-intro you over email and that's how we connect is just far worse than the thing that I would really recommend, which I do all the time. We have a Webflow as a customer. I love Webflow. I know their sales leadership. We try to do a really good job for them. Anytime that their sales leader mentions a company that might be needing to hire or whatnot, my only response is, "Great, connect me over text." Then I get the text intro with the person. Here's the other fun part. I don't take the introer off the thread. So the other thing we tend to do is we CC the person who responded, but in text you don't need to do that. You can keep the person on a little bit and it holds the person's feet to the fire to actually show up for the meeting. Again, it's these little things, right? 2% here, 3% here. This is how you win in this economy. You got to do all the things right. So you keep the person on the thread long enough so that you've actually built that relationship for the first call, obviously not forever. But in the first 10, 20 messages, I'd keep the person on. That allows you to ensure that the person goes to you, which happens a lot, I'm sure you know. You get an intro and the person never responds or they cancel on you. You can't get back on their calendar. You stay with them. This happened recently where I got introed from one sales leader to another and that sales leader basically then had a family or legit situation but then got busy and was like, "I'm not taking this thing." But I just kept pinging into that group every week or two for actually nine weeks. Then by two and a half months later, the person finally is like, "I'm so sorry, et cetera." Only after my original contact was like, "Yo, you're making me look bad here." So that pressure is what forced... Then we got them as a customer and now things are good. So it just takes all that. It takes those little things. You got to build a bridge from your current customer base to future customers and parlay the goodwill, relationship, et cetera that you've earned in serving your current customers to get new ones. Because otherwise, I don't think it's just relying on a bunch of SDRs and cold emails and stuff is going to get you through the next six to 12 months.

**中文翻译:**
这是一个很好的过渡，因为它将把我们带回你刚才提到的地方，并希望能推动我们前进，那就是“温暖介绍”。如果冷启动接触的效果变差，那么在这个时期效果反而提升的是温暖介绍。作为更一般的陈述，你必须记住的一件事是，公司要么增长，要么死亡。没有中间地带。没有所谓的“噢，我们要削减开支，努力熬过冬天，直到……”那行不通，对吧？因为员工会士气低落，投资者会失去信心，日子会变得漫长，夜晚会变得更长，最终作为一家企业，你会耗尽能量。我认为初创公司尤其有效地由能量驱动。你拥有的能量越多、信念越强、势头越猛、顺风越多，事物就越能增长并感到可能。但当然，如果你从经验上看概率，任何初创公司都不应该开始，因为概率是你注定会失败。当你缩小团队规模、缩小预算规模、做更少的事情并拿走一些东西时，那种失败感会一次又一次地直视你的眼睛。所以我真的不相信这种“哦，我们只是为了生存”的心态。我认为你当然必须调整。我认为你必须是一个现实主义者。我不是建议你对现实视而不见。我只是建议你还必须保持能量。所以我所说的保持能量的意思是说：“好吧，让我们……”这里有几个主意。首先是让我们削减一堆东西，但留出一些钱，我们将投资于举办一场线下客户活动。好，为什么我认为这是个好主意？我认为这是个好主意，因为首先，我们都被困在家里好几年了，所以当我们有机会去某个地方免费旅行时，我们往往会答应。这很好。其次，我认为你可以更有策略，也许让这次旅行仅限客户参加，时间定在二月左右。所以也许你能在今年的预算削减中幸存下来，因为人们会想：“嗯，我有这次很棒的旅行，我真的不想错过。有没有办法让我们继续保留这个工具？”你可能会想：“噢，你是在贿赂客户还是怎么的？”我的意思是，这只是心理学。我认为你必须利用心理学来发挥你的优势。我会在二月份举办一场大型客户活动，邀请我所有的现有客户，并说：“嘿，只要你在 2023 年 2 月 10 日仍然是客户，你就被邀请参加这次前往纳帕（Napa）的全包旅行，去喝上一周的酒。”我敢打赌，这可能会显著改变你的流失率。是的，它不会改变一切，但它会改变一些东西。我敢打赌它会。因为归根结底，人就是人。销售是由人完成的。这是一项面对面的人类运动。它不仅仅是纸上的几行代码。你必须与另一个人交谈，这就是它难以规模化、更像是一门艺术而非科学的原因。但也让它变得非常有趣，因为它遵循不同的规则，一套与许多其他事物不同的规则。招聘也是如此。所以，线下客户活动。我喜欢线下客户活动的另一个原因是，它们是你达成新交易的绝佳机会。那么它是如何运作的呢？这是否意味着我也邀请潜在客户参加活动？不，实际上我不会那样做。我认为很多公司都这样做，他们会邀请客户和潜在客户参加同一个活动。他们想：“噢，让他们混合在一起，互相推销。”这不是最聪明的做法。你希望活动中只有客户，你想再次利用这个机会分享思想领导力等。但是，在所有的欢乐时光、午餐、深夜等等时间里，你开始说：“嘿，看，在这个市场上，你发现了我们产品的价值。你认识的一两个处于同样处境的人，是否也可能发现价值？你认识谁有同样的问题？你认识谁正在经历这些？你认识谁可能从这份研究报告中受益，等等？”你只需开始收集一堆温暖的兴趣。但你不能仅仅停留在获得名字上，因为很多团队到这里就停止了。他们基本上得到了名字，然后就想：“好，得到名字了。现在我完事了。”实际上这不是正确的方法。你得到了名字，然后说：“太棒了，你能给我发个邮件介绍（e-intro）吗？实际上更好的是，你能通过短信把我们联系起来吗？”所以，我给所有创始人、所有销售领导、所有人的一个建议是：停止使用电子邮件。电子邮件是交易走向死亡的地方。短信才是达成交易的地方。所以这种“我要通过电子邮件给你做介绍，然后我们建立联系”的想法，远不如我真正推荐的做法，而我一直在这样做。我们有一个客户是 Webflow。我喜欢 Webflow。我认识他们的销售领导层。我们努力为他们做好工作。每当他们的销售领导提到某家公司可能需要招聘或什么的，我唯一的反应就是：“太棒了，通过短信联系我。”然后我就得到了那个人的短信介绍。这里还有另一个有趣的部分。我不会把介绍人从对话中移除。我们通常倾向于在邮件中抄送（CC）那个回复的人，但在短信中你不需要那样做。你可以让那个人在群里待一会儿，这会迫使对方真的出现在会议上。同样，这就是这些小事，对吧？这里 2%，那里 3%。这就是你在这个经济环境下获胜的方式。你必须把所有事情都做对。所以你要让那个人在对话中待足够长的时间，直到你真正为第一次通话建立了那种关系，显然不是永远。但在前 10 到 20 条消息中，我会让那个人留在群里。这可以确保对方不会放你鸽子（Ghost you），这种情况经常发生，我相信你知道。你得到了一个介绍，对方却从未回应，或者他们取消了你的预约，你无法重新约到他们的时间。你和介绍人待在一起。最近就发生了这样的事，我被一个销售领导介绍给另一个销售领导，那个销售领导基本上是因为家庭或正当情况变得很忙，然后说：“我不打算接这个事了。”但我只是每隔一两周就在那个群里发消息，实际上持续了九周。两个半月后，那个人终于说：“非常抱歉，等等。”这还是在我的原始联系人说：“嘿，你让我在这里很难堪”之后。所以这种压力迫使……然后我们得到了他们这个客户，现在一切都很好。所以这需要所有的这些。需要这些小事。你必须在当前的客户群和未来的客户之间建立一座桥梁，并利用你在服务当前客户时赢得的声誉、关系等来获得新客户。因为否则，我不认为仅仅依靠一堆 SDR（销售开发代表）和冷启动邮件之类的东西能让你度过接下来的 6 到 12 个月。

---

### [00:58:14] Lenny

**English:**
I love that tip. Feel like there's probably more nuggets. I'm going to keep fishing in this well of tactical advice for closing deals. Is there anything else that you've found? I love that texting tip. I feel like I've been on the end of that one. It works great. So yeah.

**中文翻译:**
我喜欢这个建议。感觉可能还有更多干货。我要继续在这个关于成交的战术建议之井里挖掘。你还发现了什么吗？我喜欢那个发短信的技巧。我觉得我曾经就是那个接收端。它效果很好。所以，还有吗？

---

### [00:58:30] Sahil Mansuri

**English:**
From me. Yeah, that's right. That's right. For example, I didn't have your phone number and I told my wife, "Make sure you take a selfie with Lenny and then send a text message to the three of us on one grad so that I know how to get a hold of Lenny in case he calls.".

**中文翻译:**
从我这儿学的。是的，没错。没错。例如，我以前没有你的电话号码，我告诉我妻子：“一定要和 Lenny 拍张自拍，然后发短信给我们三个人，这样如果 Lenny 打电话来，我就知道怎么联系他了。”

---

### [00:58:44] Lenny

**English:**
Here we are now.

**中文翻译:**
现在我们就在这儿了。

---

### [00:58:45] Sahil Mansuri

**English:**
Here we are now. That's right. But the point is sales when done well doesn't feel weird, okay? If it ever feels weird, you're a bad salesperson, right? I've been selling now for 14 years. I've sold literally hundreds, millions of dollars worth of deals. I could pretty much call any customer I've ever sold to and have a conversation with them and it would say, "How's it going?" Whatever. That's because I put a tremendous amount of energy into investing and building a real friendship, not relationship, not business, friendship with the people that I sell to. So I'll tell you a couple of sales stories and maybe from that we can mine the nuggets that you're fishing for. I will tell you about how I sold to Facebook when I was at Glassdoor. This is a fun story. So Facebook was the Moby Dick of Glassdoor. I think the first time they tried to sell to them was end of 2008 or something like that. Facebook was one of those accounts that obviously should be on Glassdoor because the way Glassdoor's product worked is that the more people that came to your company page on Glassdoor, the more value there was for you as a recruiting firm to put branding and to put jobs and whatnot. Facebook was the most visited page on Glassdoor. So by virtue of that, it was the best account to sell to. It had gone from CEO to VP of sales to new VP of sales to rep to rep, et cetera. I finally got my hands on it Feb of 2011. The only reason I got my hands on it is because I closed Microsoft. I think I closed both Microsoft and Google at that point. But certainly at least Microsoft. Certainly at least Microsoft. Well, it's important to the story, not to brag. So I looked at it and I looked at who we are talking to, Lori Goler, who's the chief talent. I think she's still the head of talent there, but was the head of talent who we had pitched and every time we got the same response, "No, we are not interested in outside partnership at the time. No, we are not interested." I think she had a canned response for all vendors and it was just the same response in the CRM over and over again. So again, Einstein, right? Same thing over and over again, different result. So I tried something different and I sat there and I went through every single review that had been written about Facebook on Glassdoor. First I had it pulled by a data scientist and did a word cloud and did a bunch of analytics on what was being discussed there. Pulled salary ranges, pulled salary ranges for Google and Amazon and Microsoft. So Glassdoor had three types of information. They had the review of the company, they had the outlook of the company and then they had the review of the CEO. So it was like, "Do you approve of Mark's handling the company? Yes or no?" Mark had I think 96% approval rate. He was one of the highest rated CEOs on Glassdoor at the time. I have no idea what it is today, but that's what it was then. So I basically called every review, all the salaries and then Mark's approval rating, and turned it into a nine page report that broke down how Facebook employees, specifically software engineers because that's what we're specialists at recruiting for, how software engineers at Facebook talked about working at Facebook and how it compared to how Google engineers talked about working at Google and whatnot, salary band comparisons and even reviews of Mark specifically versus the other CEOs of the other big tech companies. Then sent an email to Sheryl Sandberg, a cold email to Sheryl Sandberg whose email address I did not have, but that I assumed had to be one of 15 things. So I think I put ssandberg@facebook.com in the two line and then in the BCC line put every variant I could think of, everything. I mean everything I could think of I put, underscores and dots and first name and last name and abbreviations and et cetera. The title of the email was Mark's approval rating on Glassdoor. I was like, "Hey Sheryl. I'm from Glassdoor. I was doing research on Facebook and comparing it to all the other big tech companies. I personally work with Microsoft. So I have a little bit of insight in this. Here's what your employees think about you. Here's what Mark's approval rating looks like versus others, et cetera, et cetera." This whole research report, I kind of broke out some highlights, a couple screenshots, attached the report and said, "Hey, I'd love to discuss this with you sometime." I think I sent the email around 3 or 4PM on a Sunday. By 6PM I got a response back from Sheryl Sandberg CC'ing elt@fb.com or something like that, which I later found was executiveleadershipteam@facebook.com saying, "Hi Sahil, this is super interesting. We'd love to meet with you tomorrow. Are you available to come to Facebook HQ at 10AM.' So at the time I was 22, 23 years old or something like that. It was pretty new to Glassdoor anyway. So then of course I said yes. I sent the email to the CEO. He was like, "Do you want me to come and whatever?" I just said, "No, I'll handle it." I brought a customer success person and the two of us went. We actually got to meet first with Sheryl and then I got to go to the fishbowl. I don't know if you know this story, but Mark had a famous office that was all glass in the middle so that he really played [inaudible 01:04:15] or whatever so his known as the fishbowl. So I got to go to the fishbowl. I met Mark Zuckerberg himself. As it turns out that report and that rating got added to their weekly packet because Mark wanted to know on a weekly basis how his rating and how the employees view of Facebook was, how it was changing week over week and what people were writing, et cetera, and it became a thing. I don't know if it's still a thing today, I have no idea. But I got to have this in depth strategic conversation with the executive leaders of Facebook around their reputation, what their employees thought, their pay bands, their interview questions, leadership, guidings, shared the word cloud, sentiment analysis, et cetera. Needless to say, of course, we closed a massive deal with them and whatnot. But that's the kind of shit it takes in order to close deals, right? So this idea that I'm going to go onto my CRM system and fire up a hundred cold emails and I'm going to close business, that works when capital is cheap and everyone's buying everything and every rep hits quota and every company's growing, et cetera. That shit does not work when you are in tough times and desperate measures, you got to figure out a way to build your business. So what I would say is you got to really over, over, over index in the whole I'm going to teach you something, right? It's not that I'm going to give you value because that's a really weird thing to say and it's not like my product's going to solve a problem for you because, frankly, I don't know if you know what my problems are. But I think that one thing I would advise is how can I do something that will make this worth your time in a way that it isn't about buying my software or putting job ads on my site. So that's how Facebook became a customer of Glassdoor.

**中文翻译:**
没错。但关键在于，做得好的销售不会让人觉得奇怪，好吗？如果让人觉得奇怪，那你就是一个糟糕的销售人员，对吧？我已经做了 14 年销售了。我卖出了数以亿计美元的交易。我几乎可以给任何我曾经卖过东西的客户打电话聊天，他们会说：“最近怎么样？”之类的。那是因为我投入了巨大的精力去投资并建立真正的友谊，不是关系，不是业务，而是与我销售对象建立友谊。所以我给你讲几个销售故事，也许从中我们可以挖掘出你想要的干货。我会告诉你我在 Glassdoor 时是如何向 Facebook 销售的。这是一个有趣的故事。Facebook 曾是 Glassdoor 的“白鲸”（Moby Dick，指代极难捕捉的目标）。我想他们第一次尝试向他们销售是在 2008 年底左右。Facebook 显然应该是 Glassdoor 上的账户之一，因为 Glassdoor 的产品运作方式是：访问你在 Glassdoor 上的公司页面的人越多，你作为招聘公司进行品牌推广、发布职位等的价值就越大。Facebook 是 Glassdoor 上访问量最大的页面。因此，凭借这一点，它是最值得销售的账户。它经历过 CEO、销售副总裁、新任销售副总裁、一个又一个销售代表。我终于在 2011 年 2 月接手了它。我能接手它的唯一原因是我签下了微软。我想当时我已经签下了微软和谷歌。但肯定至少有微软。肯定至少有微软。嗯，这对故事很重要，不是为了吹嘘。所以我看了看，看了看我们在和谁谈，Lori Goler，她是首席人才官。我想她现在仍然是那里的人才负责人，但当时她是我们要游说的人才负责人，每次我们都得到同样的回复：“不，我们目前对外部合作不感兴趣。不，我们不感兴趣。”我想她对所有供应商都有一个模板化的回复，CRM 系统里一遍又一遍地出现同样的回复。所以又是爱因斯坦那句话，对吧？一遍又一遍做同样的事，却期待不同的结果。所以我尝试了一些不同的方法，我坐在那里，翻遍了 Glassdoor 上关于 Facebook 的每一条评论。首先，我让一名数据科学家提取了数据，做了一个词云，并对讨论的内容进行了一系列分析。提取了薪资范围，提取了谷歌、亚马逊和微软的薪资范围。Glassdoor 有三类信息：公司评论、公司前景展望，以及对 CEO 的评价。评价内容类似于：“你赞成马克对公司的管理吗？是或否。”我想马克的支持率是 96%。他是当时 Glassdoor 上评分最高的 CEO 之一。我不知道今天是多少，但当时就是这样。所以我基本上汇总了所有的评论、所有的薪水以及马克的支持率，并将其变成了一份 9 页的报告，详细分析了 Facebook 的员工（特别是软件工程师，因为那是我们擅长招聘的领域）是如何评价在 Facebook 工作的，以及这与谷歌工程师评价在谷歌工作的情况有何对比，还有薪资等级对比，甚至还有专门针对马克与其他大型科技公司 CEO 的评价对比。然后给 Sheryl Sandberg 发了一封邮件，一封冷启动邮件。我没有她的邮箱地址，但我假设它是 15 种组合中的一种。所以我把 ssandberg@facebook.com 放在收件人栏，然后在密送（BCC）栏放了我能想到的每一个变体，每一个。我能想到的所有组合都放进去了，下划线、点、名字、姓氏、缩写等等。邮件的主题是“马克在 Glassdoor 上的支持率”。我说：“嘿，Sheryl。我是 Glassdoor 的。我正在对 Facebook 进行研究，并将其与所有其他大型科技公司进行对比。我个人与微软合作。所以我对此有一点见解。这是你的员工对你的看法。这是马克的支持率与其他人的对比，等等等等。”在这份完整的研究报告中，我列出了一些亮点，放了几张截图，附上了报告，并说：“嘿，我很想找个时间和你讨论一下。”我想我是在周日下午 3 点或 4 点左右发出的邮件。到下午 6 点，我收到了 Sheryl Sandberg 的回复，并抄送给了 elt@fb.com 之类的地址，我后来发现那是“执行领导团队”（executiveleadershipteam@facebook.com）。她说：“嗨 Sahil，这非常有趣。我们很想明天见你。你明天上午 10 点能来 Facebook 总部吗？”当时我才 22、23 岁左右。而且我在 Glassdoor 也是个新人。所以我当然答应了。我把邮件发给了 CEO。他问：“你想让我一起去吗？”我只说：“不，我能搞定。”我带了一名客户成功人员，我们两个去了。我们实际上先见到了 Sheryl，然后我去了“鱼缸”（Fishbowl）。我不知道你是否知道这个故事，但马克有一个著名的办公室，中间全是玻璃，所以他真的像在……所以被称为“鱼缸”。所以我去了“鱼缸”。我见到了马克·扎克伯格本人。事实证明，那份报告和那个评分被添加到了他们的每周简报中，因为马克想每周了解他的评分以及员工对 Facebook 的看法，了解它每周的变化，以及人们在写什么等等，这成了一件大事。我不知道今天是否还是这样，我不知道。但我得以与 Facebook 的执行领导层就他们的声誉、员工的想法、薪资等级、面试问题、领导力指南进行了深入的战略对话，分享了词云、情感分析等。不用说，我们当然和他们签下了一笔巨额交易。但这就是达成交易所需付出的努力，对吧？所以这种“我要进入我的 CRM 系统，发一百封冷启动邮件，然后我就能成交业务”的想法，在资本廉价、每个人都在买东西、每个代表都能达到配额、每个公司都在增长的时候是行得通的。但在艰难时期和采取非常手段的时候，这种做法是行不通的，你必须想办法建立你的业务。所以我想说的是，你必须在“我要教你一些东西”这件事上投入超额的精力，对吧？并不是说我要给你提供价值，因为那是一个很奇怪的说法，也不是说我的产品会为你解决问题，因为坦率地说，我不知道你是否知道我的问题是什么。但我认为我建议的一件事是：我如何做一些事情，让这件事值得你花时间，而这种方式与购买我的软件或在我的网站上投放招聘广告无关。这就是 Facebook 如何成为 Glassdoor 客户的故事。

---

### [01:08:09] Lenny

**English:**
You just mentioned that you don't do sales, that you're not a salesperson technically anymore. You run this company. Do you miss that job being a full-time salesperson?

**中文翻译:**
你刚才提到你不再做销售了，从技术上讲你不再是一名销售人员了。你经营着这家公司。你怀念全职销售员的工作吗？

---

### [01:08:19] Sahil Mansuri

**English:**
I think CEOs are full-time salespeople. I mean, think about the job of a CEO, right? Let's start from the infancy, right? Let's start from starting a company from scratch. First thing you got to do if you want to start a company is you have to convince yourself to do it. You got to sell yourself on the fact that you want to do this. This is where most people fail actually. They can't sell themselves. They're not able to convince themselves that they should take this leap. They don't believe in themselves enough to do it. So first you got to be good enough to sell yourself. Maybe that's delusional. I don't really know how to coin that, but let's just say sell yourself. You got to then sell other more talented people than yourself to join you at a time at which you have no money, often no idea, no traction, nothing. They're typically making a lot of money at a well paid... If you hire great founders, they have a choice somewhere to work and you got to convince them to believe in you, believe in your idea, believe in the future that can be. This is the second place where most people fail. Assuming you do those two things, you still got to do one more thing, which is you got to actually sell an investor to give you capital based on typically virtually nothing or maybe very little attraction. Then you have to go and convince your initial customers to believe in you. Because sure as heck no startups product is great. Everyone wants to be like, "Oh we're going to go change the world." But you're not changing the world today, right? You've got 1/100th of the feature set of any of your competitors and all you have is this dream and this energy and this belief and somebody who's willing to take a bet on you. You got to get someone to be willing to bet on you. That's sales. Then if you do all that, then maybe you need to get some press. So now you got to convince a reporter to write about you and you got to be able to do that. Then maybe you need to hire some more people. So you got to convince some candidates to come work for you. I mean, spend my whole day selling. All I do is sales. All any founder does is sales. It's kind of like venture. People misunderstand this. VCs are salespeople. 100% of VC is a salesperson because they're selling LPs to give them money and they're selling CEOs to take their money in exchange for equity. That's the job of a VC. All the analytics, all the data and the this and the that, those are just updating their CRM. The core function of a VC is to sell. The core function of a CEO is to be a great salesperson. Like any great salesperson, you have to balance cynicism with optimism. Great salespeople don't have what I call happy ears. This is a problem that people misunderstand. People think that being a great salesperson is being ever the optimist. That's actually not the case because then you'll waste your time on a bunch of deals that'll never close. Great salespeople are extremely pessimistic internally and are great at being able to then still be optimistic externally. Where they're actually trying to disqualify you. They're looking for signals that you're not going to buy and weeding those out, while still at the same time positively spinning you and selling you. That ability to juxtapose is what diverges good from great. Because good salespeople will get misled by customers who tell them they want to buy, but if you would really press harder, you'd understand that they can't or won't or whatever. So you waste your time on a bunch of companies that never buy versus great salespeople know how to prioritize and spend their time properly. The same applies in venture. If you are a CEO who's fundraising, I cannot tell you, honestly Lenny, I can't tell you how many other CEOs I know get constantly misled by VCs where the VC says one or two good things and they're like, "Oh, they're definitely going to invest." As opposed to giving that VC every out to not continue the conversation. If they still are willing to talk to you after that, then that they're for real. I think that being a CEO and being a salesperson are the same job. Different forms of it, of course, different audiences, different products, et cetera. But ultimately they're the same thing. So no, I don't miss it. I do it every single day and I love doing it. I'm learning more and more every day from the failures and shortcomings I have.

**中文翻译:**
我认为 CEO 都是全职销售。我的意思是，想想 CEO 的工作，对吧？让我们从婴儿期开始，从白手起家创办一家公司开始。如果你想创办一家公司，你首先要做的事情就是说服你自己去做。你得向自己推销“你想做这件事”这个事实。实际上，这是大多数人失败的地方。他们无法推销自己。他们无法说服自己应该迈出这一步。他们对自己不够自信。所以首先你得足够优秀，能把自己推销出去。也许这有点妄想，我不知道该怎么形容，但就叫它“推销自己”吧。然后，你得在没有钱、通常没有主意、没有牵引力（Traction）、什么都没有的时候，说服其他比你更有才华的人加入你。他们通常在薪水丰厚的地方赚很多钱……如果你雇佣伟大的联合创始人，他们有选择去哪里工作的权利，你必须说服他们相信你，相信你的想法，相信可能的未来。这是大多数人失败的第二个地方。假设你做到了这两件事，你还得做一件事，那就是你必须根据几乎为零或非常少的吸引力，说服投资者给你资金。然后你必须去说服你的初始客户相信你。因为可以肯定的是，没有哪家初创公司的产品是完美的。每个人都想说：“噢，我们要去改变世界。”但你今天并没有改变世界，对吧？你的功能集只有竞争对手的百分之一，你所拥有的只是这个梦想、这份能量和这份信念，以及愿意在你身上下注的人。你必须让某人愿意在你身上下注。这就是销售。如果你做到了所有这些，那么也许你需要获得一些媒体报道。所以现在你得说服一名记者写关于你的报道，你得有能力做到这一点。然后也许你需要再雇一些人。所以你得说服一些候选人来为你工作。我的意思是，我整天都在做销售。我所做的一切都是销售。任何创始人所做的一切都是销售。这有点像风险投资。人们误解了这一点。风投（VC）就是销售人员。100% 的风投都是销售人员，因为他们在向 LP（有限合伙人）推销，让他们给钱；他们在向 CEO 推销，让他们拿钱换股权。这就是风投的工作。所有的分析、所有的数据、这个那个，都只是在更新他们的 CRM。风投的核心功能是销售。CEO 的核心功能是成为一名伟大的销售人员。像任何伟大的销售人员一样，你必须平衡愤世嫉俗和乐观主义。伟大的销售人员没有我所说的“快乐耳朵”（Happy ears）。这是人们误解的一个问题。人们认为成为一名伟大的销售人员就是永远乐观。事实并非如此，因为那样你会把时间浪费在一堆永远不会成交的交易上。伟大的销售人员在内心是极其悲观的，但他们非常擅长在外部保持乐观。他们实际上是在试图“取消你的资格”（Disqualify）。他们在寻找你不会购买的信号并将其剔除，同时仍然积极地引导你并向你推销。这种并置的能力就是平庸与伟大的区别。因为平庸的销售人员会被那些说想买的客户误导，但如果你真的逼得更紧一点，你会明白他们不能买、不会买或者其他原因。所以你把时间浪费在一堆永远不会购买的公司身上，而伟大的销售人员知道如何确定优先级并正确分配时间。这同样适用于风险投资。如果你是一名正在融资的 CEO，我无法告诉你，老实说 Lenny，我认识多少 CEO 经常被风投误导，风投说了一两句好话，他们就觉得：“噢，他们肯定会投资。”而不是给那个风投每一个“不继续对话”的机会。如果在那之后他们仍然愿意和你谈，那他们才是认真的。我认为当 CEO 和当销售人员是同一份工作。当然形式不同，受众不同，产品不同等等。但归根结底，它们是同一回事。所以，不，我不怀念它。我每天都在做，而且我热爱做这件事。我每天都在从我的失败和不足中学习越来越多的东西。

---

### [01:12:36] Lenny

**English:**
It's very clear that you love doing it. It's so interesting just to watch the energy when you talk about sales. I rarely meet folks that do sales. So it's really fun to dive into all this stuff. We promised folks five topics, you've gone through four. The last one I wanted to touch on, and you've already talked a bit about this and maybe there's just a quick tidbit to add here is around just how important growth continues to be for companies at this stage. It's easy to be like, "No, the markets are tough. People are going to give us a little bit of a leeway because no one's going to be able to grow." Your point is it's still incredibly important. Is there something you want to add there before we get to our very exciting lightning round?

**中文翻译:**
很明显你热爱做这件事。看你谈论销售时的那种能量真的很有趣。我很少见到做销售的人。所以深入探讨这些东西真的很有趣。我们答应过大家五个话题，你已经讲了四个。我想触及的最后一个话题（你已经谈到了一点，也许这里只需要补充一点点信息）是关于在这个阶段，增长对公司来说仍然是多么重要。人们很容易想：“不，市场很艰难。人们会给我们一点余地，因为没有人能增长。”你的观点是它仍然极其重要。在进入我们非常令人兴奋的闪电轮之前，你还有什么想补充的吗？

---

### [01:13:13] Sahil Mansuri

**English:**
I guess there's just one last thing, which is innovation is often put to the side. People just try to do the things that everyone else is doing. So I'll tell you something that we did at Bravado as an example of this. So we run a recruiting marketplace and competing with LinkedIn and AngelList and hired and all the rest of it. Like all those companies, we have seen a massive slowdown in our business. Unlike those companies, we didn't take that as kind of the end of the road for growth for now. But instead said, "Okay, so let me put myself back in the perspective of my buyer, my customer who are often founders and CROs and CFOs." Those are the people that tend to buy from Bravado because they're the people who care the most about growing revenue. I can't hire anymore full-time salespeople because the market is tough right now and I can't increase my burn or what, but I still want to get new customers. It's just I can't afford to hire full-time people. In fact, I might be forced to lay off my team. What do I do? We kind of just sat there with a think whiteboard and just said, "All right, let's put ourselves in this situation. What would you do?" One of the things that I think would be really interesting is I'm actually willing to pay money to acquire customers. I just can't take the risk that I hire someone and they won't bring me customer. What if we created a 100% commission only sales role? It doesn't exist today in SaaS. It does exist in other places, it just doesn't exist in SaaS really. But what if we created a way for sales reps who can't find a full-time job because the market is slow and companies who can't hire a full-time sales rep but still want customers to work together on a commission only basis. Now a year ago, this product would not have worked, right? Because the supply-demand equilibrium was so tilted where every company needed great sales talent and every sales rep was getting multiple offers. So in that world, this product makes no sense. But in a world in which you have far more sales reps who are looking for work and far fewer companies who are hiring, maybe we can create a new model of sales. If Airbnb and Uber grew dramatically during the pandemic and actually are somewhat counter cyclical businesses, because if you can't find a full-time job then you find gig work, what would we be able to do for our community that instead of putting them in a different field, lets them use the skills, the network and the expertise they already have in order to do the thing they want to do, but be able to do it in a down market as well. So we launched something called Bravado Flex, which is a way for companies and candidates to work together in a non full-time employment way. That can mean contract hire, it can mean a hundred percent commission, it can mean fractional work, it can mean small stipend plus milestone base. There's a bunch of different ways at work. Overnight, we went from having a massive slowdown to our business to one of the best months that we've ever had in company history, which was last month, and this month will be even better than that. So while our full-time recruiting business slows, our fractional business grows. So I use that as an example of the type of innovation that companies should be thinking of. As well as if you are a company that is thinking of increasing revenue but doesn't have enough levers to pull, maybe this is one that you might want to explore. But I think it comes back down to that fundamental staring at the whiteboard being like, "If I'm a customer and I'm in this world, what can we do today to change the rules of the game?" Because sometimes the rules of the game are stacked against you. As a recruiting business, the rules to the game were now stacked against us. No one's got money. People don't want to hire. There's hiring freezes, et cetera. There's more candidates in the market than ever before. Companies are going to be less and less likely to want to pay us to recruit for them. There's nothing I can do about that. I mean, I can stick my head out the window and scream and cry and complain, but that ain't going to get me anywhere either. So what I need to do is change the rules of the game and start to think about the problem differently. I think that not enough founders do that. They just kind of bash their heads against the wall with the same kind of preconceived notions of what success may or may not look like. So I would really advise, and I'll give you some examples of where this goes beyond Bravado Flex, but change your pricing strategy. Now, let's say that you sell a product and it's $12,000 per year. Try charging a thousand dollars a month and going month to month. Try charging 20 bucks a day and going day by day. Then you might be like, "Well, wait a minute. That just changes to every..." But you have to adapt, right? If your old model is not going to work, it's asinine to just sit there and then try to make minor changes like, "Oh, instead of 12 we'll reduce price to 10 or something." People try to optimize their way out of problems. You can't optimize your way out of a problem. You got to completely change the rules of the game. In doing so, you suddenly will learn something new. Bravado Flex may not work forever. Who knows? But maybe, just maybe, as we've been doing this, we've realized that there's actually a lot of sales reps that prefer this because they can do flex for multiple companies. So all of a sudden we learn something really new, which is that our audience are the same candidates that we're replacing to full-time jobs, are actually in some cases preferring doing this fractional work. Because now they don't need to go to all the meetings and they don't need to update Salesforce. They don't need to do all the boring shit that sales reps don't like to do. Instead, they can just work for three companies, use the existing network they have, get meetings set up for all of them, pitch the best product to the right customer, and all of a sudden they feel like instead of having to pitch the one hammer that you need to use for every... They have a wide tool set that they can bring to their customers. All of a sudden companies are like, "Well, wait a minute, this is actually pretty cool because now instead of just hiring one person at a time and training them, I can hire 10 people at a time and I can have multiple kind of fish in..." So we just changed the rules of the game around sales hiring as a market. I think that's the sort of innovation that you have to bring to the market if you want to survive in the downturn, which you can't just sit there and just try to do the same stuff over and over and over again. You got to really be willing to break all preconceived notions of what success looks like, innovate something new and then take bigger swings I guess is the thing I would say.

**中文翻译:**
我想最后还有一件事，那就是创新往往被搁置一旁。人们只是试图做其他人都在做的事情。我会告诉你我们在 Bravado 做的一件事作为例子。我们经营一个招聘市场，与 LinkedIn、AngelList、Hired 等竞争。像所有这些公司一样，我们也看到了业务的大幅放缓。与那些公司不同，我们并没有把这看作是目前增长的终点。相反，我们说：“好吧，让我把自己放回到买家、客户的角度，他们通常是创始人、CRO 和 CFO。”这些人往往会从 Bravado 购买，因为他们是最关心增加收入的人。我不能再雇佣全职销售人员了，因为现在市场很艰难，我不能增加我的烧钱率，但我仍然想获得新客户。只是我雇不起全职人员。事实上，我可能被迫裁员。我该怎么办？我们只是坐在白板前想：“好吧，让我们把自己置于这种境地。你会怎么做？”我认为有一件事会非常有趣：我实际上愿意花钱去获取客户。我只是不能承担雇了一个人却带不来客户的风险。如果我们创建一个 100% 纯佣金的销售职位会怎样？这在今天的 SaaS 领域并不存在。它在其他地方确实存在，但在 SaaS 领域真的不存在。但如果我们为那些因为市场低迷而找不到全职工作的销售代表，以及那些雇不起全职销售代表但仍想要客户的公司，创造一种以纯佣金方式合作的途径呢？在一年前，这个产品是行不通的，对吧？因为供需平衡非常倾斜，每家公司都需要优秀的销售人才，每个销售代表都能拿到多个录取通知（Offer）。所以在那个世界里，这个产品没有意义。但在一个销售代表找工作的人数远多于招聘公司的世界里，也许我们可以创造一种新的销售模式。如果 Airbnb 和 Uber 在大流行期间大幅增长，并且实际上在某种程度上是反周期业务（因为如果你找不到全职工作，你就会找零工），我们能为我们的社区做些什么，让他们不用转行，而是利用他们已经拥有的技能、网络和专业知识去做他们想做的事，但也能在低迷的市场中做到这一点？所以我们推出了一个名为 Bravado Flex 的产品，这是一种让公司和候选人以非全职雇佣方式合作的方式。这可以意味着合同工、100% 佣金、碎片化工作、小额津贴加里程碑奖励。有很多不同的运作方式。一夜之间，我们的业务从大幅放缓变成了公司历史上最好的月份之一（就是上个月），而这个月会比上个月更好。所以，当我们的全职招聘业务放缓时，我们的碎片化业务却在增长。我以此为例说明公司应该考虑的创新类型。同样，如果你是一家正在考虑增加收入但没有足够杠杆可用的公司，也许这是你想要探索的一个方向。但我认为这归根结底还是要盯着白板思考：“如果我是客户，我处在这个世界里，我们今天能做些什么来改变游戏规则？”因为有时游戏规则对你不利。作为一家招聘企业，现在的游戏规则对我们不利。没人有钱。人们不想招聘。有招聘冻结等等。市场上的候选人比以往任何时候都多。公司越来越不可能愿意付钱让我们为他们招聘。对此我无能为力。我的意思是，我可以把头伸出窗外大喊大叫、哭泣抱怨，但这也不会让我有任何进展。所以我需要做的是改变游戏规则，开始以不同的方式思考问题。我认为没有足够的创始人这样做。他们只是用同样的关于成功可能或可能不成的先入为主的观念去撞墙。所以我真的建议（我会给你一些 Bravado Flex 之外的例子），改变你的定价策略。现在，假设你卖一个产品，每年 12,000 美元。尝试每月收取 1,000 美元，按月付费。尝试每天收取 20 美元，按天付费。然后你可能会想：“嗯，等一下。这只是变成了……”但你必须适应，对吧？如果你的旧模式行不通，只是坐在那里尝试做一些微小的改变（比如把 12,000 降到 10,000 之类的）是愚蠢的。人们试图通过优化来解决问题。你无法通过优化来解决根本性问题。你必须彻底改变游戏规则。在这样做的时候，你突然会学到一些新东西。Bravado Flex 可能不会永远有效。谁知道呢？但也许，仅仅是也许，在我们做这件事的过程中，我们意识到实际上有很多销售代表更喜欢这种方式，因为他们可以为多家公司做 Flex。所以突然之间我们学到了一些非常新的东西，那就是我们的受众（那些我们安置到全职岗位的候选人）在某些情况下实际上更喜欢做这种碎片化工作。因为现在他们不需要参加所有的会议，不需要更新 Salesforce。他们不需要做销售代表不喜欢做的所有无聊的事情。相反，他们可以只为三家公司工作，利用他们现有的网络，为所有公司安排会议，向正确的客户推销最好的产品，突然之间他们觉得，与其必须推销那把必须用于每一个……他们有一套广泛的工具集可以带给他们的客户。突然之间，公司也觉得：“嗯，等一下，这实际上挺酷的，因为现在我不再是一次只雇一个人并培训他们，我可以一次雇 10 个人，我可以有多个……”所以我们刚刚改变了销售招聘市场的游戏规则。我认为如果你想在低迷时期生存下来，你就必须给市场带来这种创新，你不能只是坐在那里一遍又一遍地尝试做同样的事情。你必须真的愿意打破所有关于成功的先入为主的观念，创新一些新东西，然后进行更大的尝试，我想这就是我要说的。

---

### [01:19:38] Lenny

**English:**
That's a very empowering way to close out our chat. But first, we reached the very exciting lightning round. I'm going to ask you five questions. I'll go through them pretty fast. Whatever comes to mind, fire it away. Does that sound good?

**中文翻译:**
这是一个非常有力量的结束语。但首先，我们进入了非常令人兴奋的闪电轮。我会问你五个问题。我会很快地过一遍。想到什么就说什么。听起来不错吧？

---

### [01:19:53] Sahil Mansuri

**English:**
That sounds great.

**中文翻译:**
听起来很棒。

---

### [01:19:54] Lenny

**English:**
What are some books that you recommend to other people, like two or three, maybe even one book that you most recommend to other people?

**中文翻译:**
你向别人推荐哪些书？两三本，或者甚至是你最推荐的一本书？

---

### [01:20:01] Sahil Mansuri

**English:**
There's one book that I think every person should read. It's called Stumbling Upon Happiness.

**中文翻译:**
有一本书我认为每个人都应该读。它叫《哈佛幸福课》（Stumbling Upon Happiness）。

---

### [01:20:05] Lenny

**English:**
Yeah, Dan Gilbert I think is the author.

**中文翻译:**
是的，我想作者是 Dan Gilbert。

---

### [01:20:07] Sahil Mansuri

**English:**
Yeah, that's right. That's right. It's a really fun book. A lot of interesting studies and readings. I think especially if you're a founder or an executive who wants to learn how to sell and wants to understand how your buyers make decisions, I think it's really impactful and teaches you a new way to think about sales using psychology.

**中文翻译:**
是的，没错。没错。这是一本非常有趣的书。有很多有趣的研究和读物。我认为特别是如果你是一名创始人或高管，想学习如何销售并想了解你的买家如何做决定，我认为它非常有影响力，并教你一种利用心理学思考销售的新方法。

---

### [01:20:24] Lenny

**English:**
Great pick. Second question. Favorite other podcast that you like to listen to?

**中文翻译:**
很好的选择。第二个问题。你最喜欢听的其他播客是什么？

---

### [01:20:29] Sahil Mansuri

**English:**
There's actually only two other podcasts I listen to, so it's a small choice. I listen to the All In podcast because I love the fact that they have really good show notes so I can just jump to the section that I want to hear them talk about instead of listening to like-

**中文翻译:**
实际上我只听另外两个播客，所以选择很少。我听《All In》播客，因为我喜欢他们有非常好的节目笔记（Show notes），这样我就可以直接跳到我想听他们讨论的部分，而不是听……

---

### [01:20:42] Lenny

**English:**
We got those show notes here too.

**中文翻译:**
我们这里也有节目笔记。

---

### [01:20:43] Sahil Mansuri

**English:**
That's right. I'm excited for that as well. Of course, I listen to yours, but I figured that was too on the nose.

**中文翻译:**
没错。我也为此感到兴奋。当然，我也听你的，但我觉着直接说出来太显而易见了。

---

### [01:20:48] Lenny

**English:**
It's off limits.

**中文翻译:**
这个选项排除。

---

### [01:20:50] Sahil Mansuri

**English:**
On the nose, yeah. Then the other one is the How I Built This.

**中文翻译:**
太显而易见了，是的。另一个是《How I Built This》。

---

### [01:20:54] Lenny

**English:**
Great choices. What's a recent favorite movie or a TV show that you've really enjoyed?

**中文翻译:**
很棒的选择。最近有什么你非常喜欢的电影或电视剧吗？

---

### [01:20:59] Sahil Mansuri

**English:**
I don't watch a lot of TV or movies. but I would say that a strong exception to that is I really like The Blacklist, if you've seen that show. But it's a pretty good one. James Spader. Yeah, I really love James Spader. I find him to be someone I really, really like. I'm also a big fan of Aaron Sorkin so I liked The newsroom a lot and then West Wing and whatnot. I think the thing is I really nerdy stuff like Jeopardy and Frasier. I never liked Friends. I think it's just the dork in me that I like to watch nerdy stuff.

**中文翻译:**
我不怎么看电视或电影。但我想说一个例外，我非常喜欢《罪恶黑名单》（The Blacklist），如果你看过的话。那是一部很棒的剧。詹姆斯·斯派德（James Spader）。是的，我真的很喜欢詹姆斯·斯派德。我觉得他是我非常非常喜欢的人。我也是 Aaron Sorkin 的大粉丝，所以我很喜欢《新闻编辑室》（The Newsroom），还有《白宫风云》（West Wing）之类的。我想关键是我喜欢非常书呆子的东西，比如《危险边缘》（Jeopardy）和《欢乐一家亲》（Frasier）。我从来不喜欢《老友记》。我想这只是我内心那个书呆子的一面，喜欢看些极客的东西。

---

### [01:21:34] Lenny

**English:**
Final question, what are five SaaS products that you find incredibly useful at your company, especially new ones? But if not, anything that are just I love these products.

**中文翻译:**
最后一个问题，在你的公司里，你觉得哪五个 SaaS 产品非常有用，特别是新产品？如果没有新的，任何你喜爱的产品都可以。

---

### [01:21:45] Sahil Mansuri

**English:**
I'm a huge Luddite because my favorite tools to use are pen and paper. I like to write by hand. I like to write on a whiteboard. I enjoy the tactical part of that. I've tried to use the reMarkable tablet and other stuff like that, but I don't get the same pleasure of writing on actual pen and paper. That's my favorite. I mean, in terms of tools that we use it at Bravado that are hugely impactful, I mean, Slack is the central OS of our business as I'm sure it's for many others. Obviously we use Zoom a lot to meet and that's a core one. Notion operates everything for us as well. So I don't think I'm saying anything that that's exciting here. There's a product called Grain that I really like that I think is really cool. Grain allows you to make clips of Zoom meetings and send them out. The reason I really like that is because if I have a customer call, if I have a user interview or a VC call or whatnot, I can take a snippet of something that someone said and let other people hear it from their words. I think that's really powerful and something that I really enjoy.

**中文翻译:**
我是一个坚定的“卢德分子”（Luddite，指反对新技术的人），因为我最喜欢的工具是纸和笔。我喜欢手写。我喜欢在白板上写字。我喜欢那种触感。我尝试过使用 reMarkable 平板电脑之类的东西，但我无法获得在真正的纸笔上书写的快感。那是我的最爱。我的意思是，就我们在 Bravado 使用的具有巨大影响力的工具而言，Slack 是我们业务的核心操作系统，我相信对许多其他人来说也是如此。显然，我们经常使用 Zoom 开会，这是一个核心工具。Notion 也为我们运行着一切。所以我觉得我在这里说的没什么新鲜的。有一款名为 Grain 的产品我非常喜欢，我觉得它很酷。Grain 允许你制作 Zoom 会议的剪辑并发送出去。我非常喜欢它的原因是，如果我有一个客户电话、用户访谈或风投电话之类的，我可以截取某人说的一段话，让其他人亲耳听到。我认为这非常强大，也是我非常喜欢的东西。

---

### [01:22:48] Lenny

**English:**
Great. Love it. Sahil, this was amazing. I feel like I want to be a salesperson now. You infected me, but I still would be really bad at it. But there's a lot of nuggets in this episode that would make me less bad. So thank you for that.

**中文翻译:**
太棒了。我很喜欢。Sahil，这太精彩了。我觉得我现在都想当销售员了。你感染了我，但我肯定还是做不好。不过这一集里有很多干货，能让我做得不那么差。所以，谢谢你。

---

### [01:23:02] Sahil Mansuri

**English:**
I'm going to jump in. You've said that once. you've said that once to me before and I can't let you end on that note because it's not fair because Lenny, you are a salesperson and you are one of the best that I have met. The reason why that's true is because you have built a business from the ground up. I didn't know who the heck you were a couple years ago now. Maybe you had a big brand more than a couple years ago too, and I was just the idiot. But everybody I know now knows and respects you. The reason for that is because, I mean, I think you have really deep knowledge on product. I think there's probably other people that have really deep knowledge on product too. Many, many more. But you are the best at marketing that and turning that into... You got distribution around it. You've given so much to the world of product and been kind of a bright light that so many people have gravitated around and such so that when you launch Lenny's Talent Collective or Lenny's whatever podcast or whatever's the latest Lenny thing, in fact I remember you did a poll to try to figure out what should be the name of this podcast and ultimately the thing that one was Lenny podcast I think. So I think that is the core of sales. I want to go back to the first principle, which is that sales when done well does not feel salesy. Sales when done well is a delightful experience. People love paying you money. People love consuming your content because it's good. That's what makes a great salesperson. Facebook didn't regret taking that meeting with me. Facebook didn't regret signing that contract. They enjoyed it, they liked it, they were happy for it and it felt delightful to them and that's how sales should feel. So this notion that the way you're good at sales is because you're super extroverted and pushy and willing to put yourself out there and whatever is a misguided notion. You are the future of sales. If every salesperson gave a ton of value, played the long game, nurtured their community and created products and services based on the feedback from their customers, the world would be such a better place. So don't sell yourself short, my friend. I think you are a phenomenal salesperson.

**中文翻译:**
我要插一句。你以前也跟我说过这话，我不能让你以这种基调结束，因为这不公平。Lenny，你就是一名销售人员，而且是我见过的最优秀的销售人员之一。之所以这么说，是因为你白手起家建立了一项业务。几年前我根本不知道你是谁。也许几年前你就已经很有名了，而我只是个傻瓜。但我现在认识的每个人都认识并尊重你。原因是，我的意思是，我认为你在产品方面有非常深厚的知识。我想可能还有其他人也有深厚的产品知识。但你最擅长营销这些知识并将其转化为……你围绕它建立了分发渠道。你为产品界贡献了这么多，就像一束光，吸引了这么多人的关注，以至于当你推出 Lenny's Talent Collective 或 Lenny 的播客，或者任何最新的 Lenny 产品时，事实上我记得你做过一个投票来决定这个播客的名字，最终获胜的是“Lenny's Podcast”。所以我认为这就是销售的核心。我想回到第一性原理：做得好的销售不会让人觉得有“推销感”。做得好的销售是一种令人愉悦的体验。人们乐意付钱给你。人们乐意消费你的内容，因为内容很好。这就是成就伟大销售人员的原因。Facebook 并不后悔跟我开那个会。Facebook 并不后悔签那份合同。他们很享受，很喜欢，很开心，这让他们感到愉悦，这就是销售应有的感觉。所以，这种认为“你擅长销售是因为你超级外向、咄咄逼人、愿意表现自己”之类的想法是一种误导。你才是销售的未来。如果每个销售人员都能提供大量价值，放长线钓大鱼，培育他们的社区，并根据客户的反馈创造产品和服务，世界会变得更美好。所以，我的朋友，不要低估自己。我认为你是一名非凡的销售人员。

---

### [01:25:16] Lenny

**English:**
Damn. What a way to end it. I so appreciate that. I'm going to deflect from this epic compliment and move on to closing this out, but I really appreciate that. Where can folks find you online if they want to learn more about you, Bravado and how can folks be useful to you?

**中文翻译:**
哇。这个结尾太棒了。我非常感激。我要避开这个史诗级的赞美，继续完成结尾工作，但我真的很感激。如果大家想了解更多关于你和 Bravado 的信息，可以在哪里找到你？大家能为你做些什么？

---

### [01:25:32] Sahil Mansuri

**English:**
First of all, you can just email me. I'm just sahil@bravado.co. I love responding to emails and meeting people, so I'm always down for that. Secondly, you can find me on LinkedIn where I regularly post content around sales and revenue and hitting targets and all that. Then lastly, if you want to learn more about Bravado, it's just bravado.co. Sign up and check it out. If you like something, let me know. If you don't like it, then please let me know so we can make it better.

**中文翻译:**
首先，你可以直接给我发邮件。我的邮箱是 sahil@bravado.co。我喜欢回复邮件和结识新朋友，所以我随时欢迎。其次，你可以在 LinkedIn 上找到我，我经常在那里发布关于销售、收入、达成目标等内容。最后，如果你想了解更多关于 Bravado 的信息，只需访问 bravado.co。注册并查看一下。如果你喜欢什么，请告诉我。如果你不喜欢，也请告诉我，这样我们可以做得更好。

---

### [01:25:59] Lenny

**English:**
Amazing. Sahil, thank you again for being here, for sharing all your wisdom with us.

**中文翻译:**
太棒了。Sahil，再次感谢你来到这里，与我们分享你的智慧。

---

### [01:26:04] Sahil Mansuri

**English:**
Thank you. Thanks for having me.

**中文翻译:**
谢谢。感谢邀请我。

---

### [01:26:06] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得本集内容有价值，可以在 Apple Podcast、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这确实能帮助其他听众找到这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多关于本节目的信息。下期节目见。