# Sanchan Saxena - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Sanchan Saxena.

---

### (00:00:02) Lenny

**English:**
I feel incredibly lucky to have gotten to work with Sanchan while I was at Airbnb. He joined Airbnb as a director of product and quickly moved up the ranks to head of product for all of Airbnb. Before Airbnb, he spent almost four years at Instagram as head of product for Instagram Ads, and then he created and led the Instagram Shopping product and team.

**中文翻译:**
在 Airbnb 工作期间，我感到非常幸运能与 Sanchan 共事。他最初以产品总监的身份加入 Airbnb，并迅速晋升为整个 Airbnb 的产品负责人。在加入 Airbnb 之前，他在 Instagram 工作了近四年，担任 Instagram 广告业务的产品负责人，随后创建并领导了 Instagram 购物（Instagram Shopping）产品及团队。

---

### (00:00:21) Lenny

**English:**
Before that he was director of product at Yahoo and a PM at Microsoft. And today he's the VP of product at Coinbase. I don't think I've worked with a harder working PM, particularly someone who's incredibly kind and nice and generous.

**中文翻译:**
在此之前，他曾担任雅虎（Yahoo）的产品总监和微软（Microsoft）的产品经理。如今，他是 Coinbase 的产品副总裁。在我合作过的产品经理中，我认为没有人比他更努力，尤其是他为人还极其友善、随和且慷慨。

---

### (00:00:34) Lenny

**English:**
In my conversation with Sanchan, we cover what he's learned from working with some of today's best CEOs, including Brian Chesky, Brian Armstrong, Zuck and Kevin Systrom, what it was like inside Airbnb when COVID hit and how they made it through travel completely stopping, how to set up your product development process at a startup, tips for hiring amazing product managers, when to hire your first PM, when to A/B test and when not to, and so much more.

**中文翻译:**
在与 Sanchan 的交谈中，我们探讨了他从当今最优秀的一批 CEO（包括 Brian Chesky、Brian Armstrong、扎克伯格和 Kevin Systrom）身上学到的经验；新冠疫情爆发时 Airbnb 内部的情况，以及他们如何在旅游业完全停滞的情况下挺过难关；如何在初创公司建立产品开发流程；招聘优秀产品经理的技巧；何时招聘首位产品经理；何时该进行 A/B 测试，何时不该，以及更多精彩内容。

---

### (00:00:59) Lenny

**English:**
I hope you enjoy this episode as much as I did. So many product managers are basically treated like project managers. You get higher thinking that you'll be deep in product strategy and vision, and getting to know your customers, only to wind up organizing other people's work and finding backlogs and optimizing tiny, tiny features.

**中文翻译:**
我希望你们能像我一样喜欢这一集。很多产品经理基本上被当成了项目经理。你入职时以为自己会深耕产品策略和愿景，去深入了解客户，结果最后却只是在协调别人的工作、清理积压任务（backlogs）以及优化一些微不足道的细小功能。

---

### (00:01:21) Lenny

**English:**
If this sounds familiar, you need Dovetail. Because Dovetail gets that the true heart of product management is understanding what customers want, why they want it and how to give it to them. That's why Dovetail built a suite of user research products that help you get to the core of what your customers really want and why they want it.

**中文翻译:**
如果这听起来很耳熟，那么你需要 Dovetail。因为 Dovetail 明白，产品管理的真正核心是理解客户想要什么、为什么想要，以及如何满足他们。这就是为什么 Dovetail 开发了一套用户研究产品，帮助你触达客户真实需求及其背后原因的核心。

---

### (00:01:38) Lenny

**English:**
Dovetail offers a suite of powerful analysis tools to help you identify themes, patterns and insights in your customer interviews, allowing you to make better, data informed decisions about what solutions you should build next. Organizations all over the world, like Atlassian, Canva, Datadog, GitLab, Sketch, Nielsen Norman Group, and Deloitte use Dovetail to get a better understanding of their customers and build better products.

**中文翻译:**
Dovetail 提供了一系列强大的分析工具，帮助你在客户访谈中识别主题、模式和洞察，让你能够基于数据做出更好的决策，确定下一步该构建什么解决方案。世界各地的组织，如 Atlassian、Canva、Datadog、GitLab、Sketch、尼尔森诺曼集团（Nielsen Norman Group）和德勤（Deloitte），都在使用 Dovetail 来更好地了解客户并打造更优秀的产品。

---

### (00:02:04) Lenny

**English:**
Try Dovetails products free for as long as you need. You can sign up right now and dive right in at Dovetailapp.com/lenny. This episode is brought to you by Persona. Persona helps founders, product managers and engineers easily solve any identity-related problem, including handling KYC, AML, and basically all manner of identity fraud.

**中文翻译:**
你可以根据需要免费试用 Dovetail 的产品。现在就可以在 Dovetailapp.com/lenny 注册并开始体验。本集节目由 Persona 赞助。Persona 帮助创始人、产品经理和工程师轻松解决任何与身份相关的问题，包括处理 KYC（了解您的客户）、AML（反洗钱）以及基本上所有形式的身份欺诈。

---

### (00:02:29) Lenny

**English:**
You can integrate Persona in an afternoon and personalize your flows using their SDK to meet your users on any device. Persona's identity building blocks allow you to manage your entire end-to-end onboarding flow, verifying that each new user and their data are legitimate. Persona is trusted by both startups and the world's largest companies, including Square, Block5, Gusto and Udemy.

**中文翻译:**
你可以在一个下午的时间内完成 Persona 的集成，并使用他们的 SDK 个性化你的流程，以适配任何设备上的用户。Persona 的身份构建模块允许你管理整个端到端的入职流程，验证每位新用户及其数据的合法性。Persona 深受初创公司和全球大型企业的信赖，包括 Square、Block5、Gusto 和 Udemy。

---

### (00:02:52) Lenny

**English:**
And for a limited time, Persona is offering listeners of this podcast a free, end-to-end KYC and AML solution, where you can collect the user's government ID and, or their selfie, and automatically verify that those two pieces of data are legitimate. You can also enrich that information to automatically see if the person exists on various watch lists. Just go to Withpersona.com/lenny to get started. Sanchan, welcome. Thank you so much for being here.

**中文翻译:**
在限定时间内，Persona 为本节目的听众提供免费的端到端 KYC 和 AML 解决方案。你可以收集用户的政府身份证件和/或自拍照，并自动验证这两项数据的真实性。你还可以丰富这些信息，自动查看该人是否出现在各种观察名单中。只需访问 Withpersona.com/lenny 即可开始。Sanchan，欢迎你。非常感谢你能来到这里。

---

### (00:03:26) Sanchan Saxena

**English:**
Thank you, Lenny, for inviting me. Excited to be here and chat with you today.

**中文翻译:**
谢谢你，Lenny，邀请我参加。很高兴能来到这里，今天和你一起聊聊。

---

### (00:03:29) Lenny

**English:**
Absolutely. My pleasure. I was really lucky to work with you at Airbnb for many years, where you were a beloved product leader. And then you went on to do bigger and better things now at Coinbase. And I'd love to just hear how you first got into product, and then just a little bit of your journey of how you got to where you're today, where you're basically head of product at Coinbase.

**中文翻译:**
当然，这是我的荣幸。我很幸运能在 Airbnb 与你共事多年，当时你是一位深受爱戴的产品领导者。之后你去了 Coinbase，成就了更大、更好的事业。我很想听听你最初是如何进入产品领域的，以及你如何走到今天这一步——基本上是 Coinbase 的产品负责人——这段旅程的简要经历。

---

### (00:03:49) Sanchan Saxena

**English:**
Yeah, happy to answer. Maybe I'll go back in time and start from my first job. I was in my third year of engineering where the entrepreneurial bug caught me, so to say, bit me. And I took a little bit of sabbatical from my engineering, which by the way, was in aerospace engineering.

**中文翻译:**
好的，我很乐意回答。也许我可以追溯一下，从我的第一份工作说起。当时我正在读工程专业的第三年，所谓的“创业热”抓住了我，或者说咬了我一口。于是我从工程专业休学了一段时间，顺便说一下，我当时学的是航空航天工程。

---

### (00:04:03) Sanchan Saxena

**English:**
I wanted to be an astronaut, go to space. Unfortunately back then, there wasn't an Elon Musk for SpaceX. If you wanted to go to space, you got to work for a government agency, which I didn't like. Fast forward that to my third year of engineering and I start my company, raised a bunch of money, hired some people.

**中文翻译:**
我曾想成为一名宇航员，去太空。不幸的是，那时候还没有像埃隆·马斯克和 SpaceX 这样的公司。如果你想去太空，你必须为政府机构工作，而我不喜欢那样。快进到我大三的时候，我创办了自己的公司，筹了一笔钱，雇了一些人。

---

### (00:04:18) Sanchan Saxena

**English:**
Didn't go as planned, so I [inaudible 00:04:20], came back and finished my engineering and got a job at Microsoft, which made my mom very happy. My mom said, "My son finally has a stable job. What the heck he was doing running some companies?" But jokes aside, I got a job at Microsoft, which was a great starting position.

**中文翻译:**
事情进展得并不顺利，所以我（回到了原点），回来完成了工程学位，并在微软找到了一份工作，这让我妈妈非常开心。我妈说：“我儿子终于有一份稳定的工作了。他之前开公司到底是在搞什么鬼？”不过玩笑归玩笑，我在微软得到了一份工作，那是一个非常棒的起点。

---

### (00:04:34) Sanchan Saxena

**English:**
I started in engineering. But within a year or so, I moved into product. And I moved to the Silicon Valley office of Microsoft. Never worked in Seattle, but always worked in Silicon Valley at Mountain View. And I worked for this product called Hotmail. I don't know how many people know this or not, but there's an email service called Hotmail. I was one of the product people.

**中文翻译:**
我最初是做工程的。但大约一年之内，我转到了产品岗位。我搬到了微软的硅谷办公室。我从未在西雅图工作过，一直是在山景城的硅谷办公室。我当时负责一个叫 Hotmail 的产品。我不知道现在还有多少人知道这个，但当时有一个叫 Hotmail 的电子邮件服务，我是其中的产品人员之一。

---

### (00:04:50) Lenny

**English:**
Absolutely. It's scary that people may not even know what Hotmail is at this point.

**中文翻译:**
确实。想到现在的人可能甚至都不知道 Hotmail 是什么，这挺让人感慨的（甚至有点可怕）。

---

### (00:04:55) Sanchan Saxena

**English:**
Right? It's kind of crazy. Back in the day, it was pretty cool. I worked there, and then since then have been in Silicon Valley. So moved into product back in, I think, 2005 or '06, something like that, and since then been in product. I've been very lucky and fortunate to have stumbled upon incredible opportunities all the way from Facebook and Instagram to Airbnb and Coinbase.

**中文翻译:**
对吧？挺疯狂的。在那个年代，它真的很酷。我在那里工作，从那以后就一直留在硅谷。我大概是在 2005 或 2006 年左右转入产品领域的，从那以后就一直在这个领域。我非常幸运，能够偶遇这么多不可思议的机会，从 Facebook 和 Instagram 到 Airbnb，再到现在的 Coinbase。

---

### (00:05:16) Sanchan Saxena

**English:**
And fun fact, when I joined Instagram, it was still very small. And it was less than, I think, 50 engineers or something like that. Very tiny. It was pre-revenue. We made $0 in revenue. I still remember the day when Zuck told Kevin Systrom we got to go make revenue, and we made $0 back then.

**中文翻译:**
有趣的是，当我加入 Instagram 时，它规模还非常小。我想当时不到 50 名工程师，非常袖珍。那时候还没有收入，我们的收入是 0 美元。我还记得扎克伯格告诉 Kevin Systrom 我们必须开始创造收入的那天，而那时我们的收入真的是 0。

---

### (00:05:30) Sanchan Saxena

**English:**
And was there till 2017. By the time it was like a billion monthly active users, multiple billion dollars in revenue, was my first hypergrowth experience as a product leader. And then in 2017, I joined Airbnb, which is where you and I worked together. There I had a dual role.

**中文翻译:**
我在那里一直待到 2017 年。到那时，它已经拥有约 10 亿月活跃用户和数十亿美元的收入，那是我作为产品领导者的第一次“超速增长”（hypergrowth）体验。然后在 2017 年，我加入了 Airbnb，也就是我们共事的地方。在那里我承担了双重角色。

---

### (00:05:45) Sanchan Saxena

**English:**
I was a GM of Airbnb Plus, but also the head of product helping Brian Chesky scale the product management organization, establish the culture of it, and see how best we can build a world class part organization. And then after that, I took some time off, about six months, introspective to see what do I want to do next.

**中文翻译:**
我是 Airbnb Plus 的总经理，同时也是产品负责人，协助 Brian Chesky 扩大产品管理团队的规模，建立团队文化，并探索如何打造世界一流的产品组织。在那之后，我休息了大约六个月，进行反思，看看下一步想做什么。

---

### (00:06:00) Sanchan Saxena

**English:**
And that is when I went into the Web 3.0 rabbit home, and that's when I learned more and more about Web 3.0, what's happening over there. I've always been investor in crypto since 2014, but never thought of it as a builder. I was like, "Ah, I don't know if I want to build in there. It seems cool. I can participate from the outside."

**中文翻译:**
就在那时，我掉进了 Web 3.0 的“兔子洞”，开始越来越多地了解 Web 3.0 以及那里正在发生的事情。自 2014 年以来，我一直是加密货币的投资者，但从未想过以建设者（builder）的身份参与其中。我当时想：“啊，我不知道我想不想在那里搞建设。它看起来很酷，我可以从外部参与。”

---

### (00:06:18) Sanchan Saxena

**English:**
But then the more I read, the more I realized, "Man, this is one of the biggest revolutions happening." And that's when I joined Coinbase and here I'm the VP product for ecosystems and a bunch of other stuff that I do here, and excited to be able to play a small role in this next revolution called Web 3.0.

**中文翻译:**
但读得越多，我越意识到：“天哪，这是正在发生的最伟大的革命之一。”于是我加入了 Coinbase，现在我是负责生态系统的产品副总裁，还负责其他一些事务。能在这场名为 Web 3.0 的下一代革命中扮演一个小角色，我感到非常兴奋。

---

### (00:06:31) Lenny

**English:**
Amazing. Just listening into that trajectory and places that you worked, I imagine people are wondering like, "Man, how do I follow a trajectory like that? How do I live a life like Sanchan?" Do you have any advice for someone that's maybe just starting out that may be wondering like, "How do I follow this sort of path? How do I work at all these incredible companies and get to maybe where you are now?"?

**中文翻译:**
太棒了。听着这段职业轨迹和你工作过的地方，我想人们一定会好奇：“天哪，我该如何复制这样的轨迹？我该如何像 Sanchan 一样生活？”对于那些可能刚刚起步、正在思考“我该如何走这条路？我该如何进入这些不可思议的公司，并最终达到你现在的高度？”的人，你有什么建议吗？

---

### (00:06:51) Sanchan Saxena

**English:**
Yeah, I look back at my career, one thing that is very true is that I never had that plan. I stumbled upon a lot of things. I mean, I wanted to be an aerospace engineer, didn't work out, pivoted. I started my own company, didn't work out, pivoted. I came to Silicon Valley, worked at Hotmail, didn't work out, pivoted.

**中文翻译:**
是的，回顾我的职业生涯，有一点非常真实：我从未有过那样的计划。我很多时候是“撞”上这些机会的。我的意思是，我想当航空航天工程师，没成，转型了。我创办了自己的公司，没成，转型了。我来到硅谷，在 Hotmail 工作，没成，又转型了。

---

### (00:07:07) Sanchan Saxena

**English:**
Things start to materialize when you actually take steps to do something. My biggest advice to people is, oftentimes the analysis paralysis of dotting every eye, crossing every tee sometimes chokes you out of opportunities. When you find something that gives you energy, just jump in with both feet. And try to go through that process, and pivot and learn, and pivot and learn and pivot.

**中文翻译:**
当你真正采取行动去做某事时，事情才会开始具体化。我给人们最大的建议是：很多时候，那种追求尽善尽美、事无巨细的“分析瘫痪”（analysis paralysis）会让你错失良机。当你发现某些能给你带来能量的事情时，就全身心地投入进去。尝试经历那个过程，不断转型、学习、再转型、再学习。

---

### (00:07:29) Sanchan Saxena

**English:**
That's how you would create a great career as opposed to sort of a five year career plan and working backwards from that. Those things just don't work. The other thing I would say is I read this book early on in my life called the Little Bets. It actually was a reflection of whatever I did in my life. Before that I thought I was a weirdo, I don't know what I'm doing. And then I read that book and I realized, "Oh my God, there's some method to my madness. It's called little bets."

**中文翻译:**
这就是你创造伟大职业生涯的方式，而不是制定一个所谓的五年计划然后倒推。那些东西根本行不通。另一件事是，我早年读过一本叫《小赌注》（Little Bets）的书。它实际上反映了我生活中所做的一切。在那之前，我觉得自己是个怪人，不知道自己在干什么。读完那本书后我意识到：“天哪，我的疯狂是有章可循的，这叫‘小赌注’。”

---

### (00:07:52) Sanchan Saxena

**English:**
You take little bets, you try them out. If they don't work out, you build rapid recovery and start to do something else. And that is the meta story connecting all the dots in my life, in all the career opportunities that I've had, just one piece of big advice I'll tell everybody. The second thing I'll say is product management is a very interesting discipline.

**中文翻译:**
你下一些小赌注，去尝试。如果行不通，你就建立“快速恢复”机制，然后开始做别的事情。这就是连接我生命中所有点滴、所有职业机会的底层逻辑，这是我想告诉大家的第一个重要建议。我要说的第二点是，产品管理是一个非常有趣的学科。

---

### (00:08:10) Sanchan Saxena

**English:**
You don't go to school for that. You don't get a degree for that. And most people that I know in product have stumbled upon product management. They were doing something else and like, "Oh my God, this seems cool. I want to do this." The advice I give early stage product people is you got to learn the art and the science of product management early on in your career.

**中文翻译:**
你没法去学校学这个，也没有专门的学位。我认识的大多数产品人都是偶然进入这个领域的。他们原本在做别的事情，然后觉得：“天哪，这看起来很酷，我想做这个。”我给初级产品人的建议是，你必须在职业生涯早期学会产品管理的“艺术”和“科学”。

---

### (00:08:29) Sanchan Saxena

**English:**
There's an art piece to it and then there's a science piece to it, and you got to be able to manage both of those things in your head. If you become too scientific, you miss out on opportunities because you can't see those opportunities using the scientific method of discovery, because they're too tiny or they're so farfetched that people cannot even understand them.

**中文翻译:**
它既有艺术的一面，也有科学的一面，你必须能在脑子里同时处理这两者。如果你变得过于“科学”，你会错失机会，因为你无法用科学的发现方法看到那些机会——它们可能太微小，或者太超前以至于人们甚至无法理解。

---

### (00:08:45) Sanchan Saxena

**English:**
And the art piece is really important for you to be able to sniff those out by being in the community, hanging out with people who are actually builders and learning where the next trends would be. My advice to people is go get a job which will make you the fastest learner in the field of product management.

**中文翻译:**
而“艺术”的部分非常重要，它能让你通过深入社区、与真正的建设者交流，从而嗅到未来的趋势。我给人们的建议是：去找一份能让你在产品管理领域学习速度最快的工作。

---

### (00:09:00) Sanchan Saxena

**English:**
That is what will help you a lot. No course, no degree, none of those things will help. The most important thing will be how quickly can you jump in, learn the auto product management. Some people prefer doing that at a startup. Some people prefer doing it at a established fan company, which has processes and systems as well. It's your choice. But the fastest you learn that, the better it'll get for you.

**中文翻译:**
这才是对你最有帮助的。没有课程、没有学位，这些都没用。最重要的是你能多快投入进去，学会产品管理的“艺术”。有些人喜欢在初创公司学，有些人喜欢在成熟的大厂（如 FAANG）学，那里有完善的流程和系统。这是你的选择。但你学得越快，对你就越有利。

---

### (00:09:20) Lenny

**English:**
Wow. I love so much about that advice. To go a little bit further on this last point. When people are looking for a company to go join to learn, to accelerate their career the way you're describing, what do you think they should be looking for? I know you said maybe a startup. Do you think they should join a startup? Do you think they should join a bigger company? What kind of things should you look for to find the best place to learn?

**中文翻译:**
哇。我非常喜欢这些建议。关于最后一点，我想再深入探讨一下。当人们在寻找一家公司加入，以实现你所描述的那种职业加速时，你认为他们应该寻找什么样的特质？我知道你提到了初创公司。你认为他们应该加入初创公司吗？还是应该加入大公司？为了找到最佳的学习场所，应该关注哪些方面？

---

### (00:09:41) Sanchan Saxena

**English:**
Yeah, I think there is no right recipe for one, but it matters to the individual. I'll share both stories with you. The way to think about this is let's say you want to get to a destination, whichever destination it is, you probably want to get on the faster ship. You don't want to get on a slower ship. That's one metaphor to use in your mind.

**中文翻译:**
是的，我认为没有唯一的标准答案，这取决于个人。我可以和你分享两种情况。思考这个问题的一种方式是：假设你想去某个目的地，无论那是哪里，你肯定想上一艘更快的船，而不是慢船。这是你可以记住的一个比喻。

---

### (00:09:58) Sanchan Saxena

**English:**
And then when you got to the ship, you know the ship will get there, but remember you are not going to get to your destination faster than the ship will. You got to understand what your destination is, then optimize the learnings from there. At a startup, you're going to learn a lot of things. There are three types of learning, a starter learning, meaning you can get started. You're a person who can get started. You see an idea, you see an opportunity, you can get started. Right?

**中文翻译:**
当你上了船，你知道船会到达目的地，但记住，你到达目的地的速度不会快于船速。你需要了解你的目的地是什么，然后优化在那里的学习。在初创公司，你会学到很多东西。有三种类型的学习：第一种是“启动式学习”（starter learning），意味着你能动手开始。你是一个能把事情搞起来的人，看到一个想法或机会，就能开始行动。对吧？

---

### (00:10:21) Sanchan Saxena

**English:**
That is something that a startup will teach you a lot. You see something, you want to get started to do something about it, great, you'll learn a lot over it. And there's zero to one people who can then take what they have started and scale it to one. And then there are one and beyond people who are scalers, who will scale the system that is found product market fit.

**中文翻译:**
这是初创公司会教给你很多的东西。你看到一些东西，想动手做点什么，太棒了，你会学到很多。然后是“0 到 1”的人，他们能把启动的项目推进到 1 的阶段。最后是“1 及以后”的人，他们是“规模化者”（scalers），负责扩展已经找到产品市场契合点（PMF）的系统。

---

### (00:10:38) Sanchan Saxena

**English:**
And I think depending on your journey, depending on your career, depending upon where you are, you might want to optimize for different types of learnings as well. What I advise people is there's a great way to go to Google, Facebook and Amazon and learn the scale mechanisms that these companies have built. And I look at Amazon and I get inspired by that company, because what they have figured out is how to scale innovation with 1 million employees.

**中文翻译:**
我认为根据你的职业阶段和所处位置，你可能想针对不同类型的学习进行优化。我给人们的建议是：去谷歌、Facebook 和亚马逊学习这些公司建立的规模化机制也是一种极好的方式。我观察亚马逊并深受启发，因为他们弄清楚了如何在拥有 100 万员工的情况下实现创新的规模化。

---

### (00:10:59) Sanchan Saxena

**English:**
It's a pretty different learning. And you can't potentially find that at a startup. Similarly, the ability to just get started, the ability to see an idea, start hacking at it, start building it without the encumbrances of the processes and the system that these big organizations have, you can probably learn that in a big company as well. You got to figure out what are you optimizing for, what goes well with you.

**中文翻译:**
这是一种非常不同的学习，在初创公司可能找不到。同样地，那种“直接开始”的能力，看到一个想法就开始动手尝试、开始构建，而不受大组织流程和系统束缚的能力，你在大公司可能也能学到（通过内部创业等）。你需要弄清楚你在优化什么，什么最适合你。

---

### (00:11:23) Sanchan Saxena

**English:**
I've seen many successful leaders who will get choked up in a big company environment, and I've seen many big company successful executives who want to choke up in a very startup environment. And this is not for everybody. Both sides of the games are not for everybody. First and foremost recognizing what gives you energy, recognizing where you thrive the most is really important.

**中文翻译:**
我见过许多成功的领导者在大公司环境中感到窒息，也见过许多大公司的成功高管在初创公司环境中感到不知所措。这并不适合所有人，游戏的双方都不一定适合每个人。首先，识别出什么能给你能量、你在哪里最能大展身手，这是非常重要的。

---

### (00:11:41) Sanchan Saxena

**English:**
For example, I am not the guy who can optimize a 100,000 employee company. I will never enjoy that kind of learning. I've done to some extent a large company thing, but I thrive in that starter to scale angle. But when it becomes too large, I start to lose interest in that kind of learning. Some people enjoy different things. You got to understand what it is and be able to optimize there.

**中文翻译:**
例如，我不是那种能优化 10 万人规模公司的人。我永远不会享受那种学习。我在某种程度上做过大公司的工作，但我更擅长从“启动到规模化”的阶段。当规模变得太大时，我就开始对那种学习失去兴趣。不同的人喜欢不同的东西，你必须了解自己并据此进行优化。

---

### (00:12:03) Lenny

**English:**
Where would you say you learned the most of all the companies you worked at that helped accelerate your career most?

**中文翻译:**
在你工作过的所有公司中，你认为哪一家的学习心得最多，对你的职业加速帮助最大？

---

### (00:12:09) Sanchan Saxena

**English:**
I think I would rank Airbnb probably the place that I learned the most. And I'll share with you and your audience why I feel that way. I joined Airbnb back in 2017, making decent revenue, had good product market fit. I remember when I got there, the entire product management order was like 30 people or 40 people, something like that.

**中文翻译:**
我想我会把 Airbnb 排在第一位。我会和你以及听众分享我为什么这么想。我是在 2017 年加入 Airbnb 的，当时公司收入不错，产品市场契合度也很好。我记得我刚到那里时，整个产品管理团队大概只有 30 或 40 人。

---

### (00:12:26) Sanchan Saxena

**English:**
You had three directors of product, very small still for a company that was generating a billion plus dollars in revenue. And then the context was there was this ambitious founder, Brian, who will never take no for an answer. And he would bend reality in many regards to make shit happen.

**中文翻译:**
当时只有三位产品总监，对于一家年收入超过 10 亿美元的公司来说，规模依然很小。当时的背景是，有一位雄心勃勃的创始人 Brian，他从不接受“不”这个答案。他在很多方面都会“扭曲现实”来促成事情的发生。

---

### (00:12:41) Sanchan Saxena

**English:**
And you are very familiar with those days as well, but you will have a practicability. You will leave the review thinking, "Shit, this is actually possible." The guy just inspired you that this is actually possible and you went in thinking it's not possible.

**中文翻译:**
你也非常熟悉那些日子，但你会有一种“可行性”感。你会在评审结束后心想：“该死，这居然是真的可能的。”这家伙就是能激励你，让你觉得这事儿能成，而你进去之前还觉得根本不可能。

---

### (00:12:52) Sanchan Saxena

**English:**
What I found is that at Airbnb, I learned a bunch of different things. One, I learned how to build products where software is just one part of the product. Let me explain that a little bit. The product of Airbnb isn't the app. It is a means to an end. The product of Airbnb is the memories you're going to create when you sit in that Airbnb beautiful house with your family, with your friends, and you're building those memories. That's the product. It's in real world.

**中文翻译:**
我发现，在 Airbnb 我学到了很多不同的东西。第一，我学会了如何构建“软件只是产品一部分”的产品。让我解释一下。Airbnb 的产品不是那个 App，App 只是达到目的的手段。Airbnb 的产品是当你和家人、朋友坐在那间美丽的民宿里时所创造的回忆。那是真实世界里的产品。

---

### (00:13:18) Sanchan Saxena

**English:**
And how you build a real world product which is of course powered by software, like the app, the website, et cetera, is different than just building a pure product that is purely software. I learned what is operations, how to scale operations, how to work with operations, how to create beautiful physical homes over there. The second thing I learned is just how to build great products.

**中文翻译:**
如何构建一个由软件（如 App、网站等）驱动的真实世界产品，与构建纯软件产品是完全不同的。我学习了什么是运营、如何扩展运营、如何与运营部门合作，以及如何在那里创造美丽的实体房屋。我学到的第二点就是如何打造伟大的产品。

---

### (00:13:39) Sanchan Saxena

**English:**
I mean, I got I think a masterclass from Chesky in how to build products by watching him act, behave, and make decisions as well. And we'll talk about it later today. But I learned some of my fundamental product principles from him, and working with him and the team that he had assembled, the design leaders, the engineering leaders, et cetera. I learned a lot over there.

**中文翻译:**
我的意思是，通过观察 Chesky 的行动、举止以及决策方式，我上了一堂关于如何打造产品的“大师课”。我们今天晚些时候会详细聊聊。我从他身上学到了一些基本的产品原则，通过与他以及他组建的团队（设计领导者、工程领导者等）合作，我受益匪浅。

---

### (00:13:59) Sanchan Saxena

**English:**
And last one but not least, there was still a hypergrowth thing. We were going through crazy growth. And then I learned what happens in leadership when coronavirus happens, the company starts to tank. It was a lesson in crisis management. I tell my friends I could not have gone to HBS Stanford business school to learn crisis management as much as I learned while being in the front row seat managing through that.

**中文翻译:**
最后但同样重要的一点是，当时仍处于超速增长阶段。我们经历了疯狂的增长。接着，我学到了当新冠疫情爆发、公司开始暴跌时，领导层会发生什么。这是一堂深刻的危机管理课。我告诉朋友们，即便去哈佛商学院或斯坦福商学院，也学不到我在“前排座位”亲历危机管理时学到的那么多东西。

---

### (00:14:23) Sanchan Saxena

**English:**
My learning as a product leader from Brian as a hyperscaler, taking the product management organization from 30, 40 people to 200 people, and last but not the least, managing the crisis. I felt like it all compressed into three years something that you will learn in 30.

**中文翻译:**
作为一名产品领导者，我从 Brian 身上学到了如何进行超大规模扩展（将产品团队从 30-40 人扩展到 200 人），最后也是最重要的一点，就是应对危机。我觉得这三年的经历压缩了通常需要 30 年才能学到的东西。

---

### (00:14:38) Lenny

**English:**
I imagine you had no sense of that sort of path or trajectory or learning when you joined Airbnb, it was like, "Hmm, this is going to be a great company, little [inaudible 00:14:46] things."

**中文翻译:**
我猜你加入 Airbnb 时，完全没预料到会有这样的路径、轨迹或学习机会，当时可能只是想：“嗯，这会是一家伟大的公司，做点小事情。”

---

### (00:14:47) Sanchan Saxena

**English:**
Yeah, absolutely. And oftentimes it's a joke, but I'll say it out anyhow. Oftentimes you meet leaders who are leaving Facebook, Amazon, Google, and it's like, "Hey, here's my Excel spreadsheet. Here's how I imagine the startup that I'm joining will grow. Here's the valuation. Here's my life. Here's my compensation. That's it." None of that shit is going to happen.

**中文翻译:**
是的，绝对是。这通常是个笑话，但我还是要说出来。你经常会遇到一些从 Facebook、亚马逊、谷歌离职的领导者，他们会说：“嘿，这是我的 Excel 表格。这是我设想的我要加入的初创公司的增长方式。这是估值，这是我的生活，这是我的薪酬。搞定。”但那些破事儿一件都不会按计划发生。

---

### (00:15:05) Sanchan Saxena

**English:**
The companies have a different trajectory and you can't predict those things. So yeah, you're right. When I joined Airbnb, I thought it's going to be a walk in the park, just like Instagram was. I mean, Instagram wasn't a walk in the park. But relatively speaking, Instagram never experienced this kind of rapid pivoting of the reality, right?

**中文翻译:**
公司的发展轨迹是不同的，你无法预测。所以你说得对。当我加入 Airbnb 时，我以为这会像在 Instagram 那样轻松（walk in the park）。我的意思是，Instagram 也不轻松，但相对而言，Instagram 从未经历过这种现实被如此剧烈扭转的情况，对吧？

---

### (00:15:22) Sanchan Saxena

**English:**
I'll share with you I was there when Instagram had less than a hundred million monthly active users, $0 in revenue, 50 engineers, till it had 1 billion monthly active users, billions of dollars in revenue and thousands of employees. And I don't remember a time where the reality got bended so badly that we had to pivot.

**中文翻译:**
我跟你分享一下，我在 Instagram 的时候，它月活还不到 1 亿，收入为 0，只有 50 名工程师，一直待到它拥有 10 亿月活、数十亿收入和数千名员工。我不记得有哪次现实被扭曲得如此严重，以至于我们不得不进行大转型。

---

### (00:15:41) Sanchan Saxena

**English:**
In Airbnb's time, man, one fine morning in January, Brian and us were all talking about going IPO and taking the company public. Six weeks later, we are figuring out, "Damn, how do we make this company survive?" The revenues, if I'm not wrong, dropped to less in single digits of last year's revenue.

**中文翻译:**
而在 Airbnb 时期，天哪，1 月份的一个清晨，Brian 和我们还在讨论 IPO 和上市。六周后，我们却在琢磨：“该死，我们怎么才能让这家公司活下去？”如果我没记错的话，当时的收入跌到了去年同期收入的个位数百分比。

---

### (00:16:00) Sanchan Saxena

**English:**
And there is no head of product, there is no CFO, there is no COO, whoever has a business plan to say, "Hmm, what are we going to do when our revenue drops to single digits of last year's revenue?"

**中文翻译:**
而且没有任何产品负责人、CFO 或 COO 的商业计划书里会写着：“嗯，当我们的收入跌到去年同期的个位数时，我们该怎么办？”

---

### (00:16:10) Sanchan Saxena

**English:**
I definitely didn't think that is what happened, but that's what ended up happening. Luckily, everything worked out, and I'm happy to share what we did and how we navigated through that with the audience, but it was some crazy, crazy times, man.

**中文翻译:**
我绝对没预料到会发生这种事，但它确实发生了。幸运的是，一切最终都解决了。我很乐意与听众分享我们做了什么以及如何渡过难关的，但那真的是一段非常、非常疯狂的时光。

---

### (00:16:21) Lenny

**English:**
I was on the outside of that having left Airbnb a couple years prior and I was like, "Shit, what am I going to do now? I've been taking time off. There go all my Airbnb shares. I think I can get a job soon." And that's actually what led to the newsletter and starting to charge for the newsletter. But I'm very thankful for the turnaround that you helped create. I'd actually love to hear a bit more about what it is they did that helped them through that.

**中文翻译:**
当时我作为局外人，几年前刚离开 Airbnb，我心想：“该死，我现在该怎么办？我一直在休假。我的 Airbnb 股票全泡汤了。我想我得赶紧找份工作。”这实际上促使我开始写时事通讯（newsletter）并开始收费。但我非常感谢你协助实现的华丽转身。我真的很想多听听你们到底做了什么来挺过难关。

---

### (00:16:43) Sanchan Saxena

**English:**
I'll share with you the behind the scenes story that we went through. This is January, and Brian had this idea of taking the company public in April. And we are working on the road show deck, we are working through numbers, we were crafting the story, et cetera, everything's going well.

**中文翻译:**
我跟你分享一下我们经历的幕后故事。那是 1 月份，Brian 打算在 4 月份上市。我们正在准备路演 PPT，核对数据，构思故事等等，一切进展顺利。

---

### (00:16:59) Sanchan Saxena

**English:**
And then we hear of this coronavirus crisis and all of a sudden countries are shutting down, one after the other. Italy shuts down. Japan shuts down. This country shuts down. And all of a sudden we can see on our travel map, we have this dashboard where you can see where people are traveling, and you can see travel goes down to zero in this country on a map. This goes down to zero in this country, and you're like, "Holy shit, what's happening over here?"

**中文翻译:**
接着我们听说了新冠危机，突然之间，各国相继封锁。意大利封了，日本封了，这个国家也封了。突然间，我们在旅游地图（我们有一个可以看到人们旅行去向的仪表盘）上看到，某个国家的旅行量降到了零。另一个国家也降到了零。你会惊呼：“我的天，这到底是怎么回事？”

---

### (00:17:19) Sanchan Saxena

**English:**
I remember in all-hands where Brian stood up and said, "Look, we built this company for a crisis like this. We built this company, we have $2 billion in bank." I think something like that, some ridiculous number. "We have not used a single amount of money from our last raise," because we were profitable or growing really profitable. "And we are going to survive this."

**中文翻译:**
我记得在一次全员大会上，Brian 站起来说：“听着，我们建立这家公司就是为了应对这样的危机。我们银行里有 20 亿美元。”大概是这么个惊人的数字。“我们上次融资的一分钱都没动过，”因为我们当时已经盈利了，或者增长得非常有利润。“我们会挺过去的。”

---

### (00:17:35) Sanchan Saxena

**English:**
Six weeks later, he's in the same all-hands and telling people, "This is a different world we are living in." We had to lay off 1,900 employees, just 190 of those were in my organization. We had to raise $2 billion in debt, and the valuation dropped to 50% of what the valuation was. It was one of the craziest times.

**中文翻译:**
六周后，他在同一次全员大会上告诉大家：“我们生活在一个不同的世界了。”我们不得不裁掉 1900 名员工，其中 190 人就在我的部门。我们不得不举债 20 亿美元，估值跌掉了一半。那是最疯狂的时刻之一。

---

### (00:17:53) Sanchan Saxena

**English:**
And Lenny, when you go through that, the loss of challenges you face, one is fine. You can cut costs by laying off employees for a little bit and create a little bit more runway. But remember, this is coronavirus time. I had to let go of people over Zoom. I couldn't even meet them in-person.

**中文翻译:**
Lenny，当你经历这些时，面临的挑战数不胜数。裁员缩减开支、增加现金流（runway）是一方面。但记住，那是新冠时期。我不得不通过 Zoom 裁员，甚至无法当面见到他们。

---

### (00:18:09) Sanchan Saxena

**English:**
I still remember when I actually finished my speech and I told them, "This is the last day," now, I literally shed a tear in front of everybody, because I was like, "Man, this is hard. This is really, really hard." And the company let go of 1900 people. I just had to let go of 190 in my organization, but it was still very painful, because remember, it is no fault of these employees. They just happen to be at the wrong side of the tornado that's hitting the world.

**中文翻译:**
我还记得当我结束演讲并告诉他们“今天是最后一天”时，我真的在所有人面前流下了眼泪。因为我觉得：“天哪，这太难了。这真的、真的太难了。”公司裁掉了 1900 人，我部门裁了 190 人，但这依然非常痛苦，因为记住，这并不是这些员工的错。他们只是恰好处于席卷全球的龙卷风的错误一侧。

---

### (00:18:34) Sanchan Saxena

**English:**
The second equally most important thing was the people who stayed back, how do you motivate them? One is you can let go of the people, but people who stayed back, they need a light of hope that something is going to turn around. But how do you plan when data is changing every single day? And every day we will wake up, a new country will go down and say, "No, no more travels into our market".

**中文翻译:**
第二个同样重要的事情是，对于留下来的人，你如何激励他们？裁员是一回事，但留下来的人需要看到希望之光，相信事情会有转机。但当数据每天都在变化时，你如何制定计划？每天醒来，都会有一个新国家宣布：“不行，不再允许进入我们的市场。”

---

### (00:18:56) Sanchan Saxena

**English:**
And we start predicting that our revenue will be 7, 10, some ridiculous very small percent of last years. There's panic. And this is where I would say Brian Chesky is an incredible leader. He's the Rocky Balboa of Silicon valley. You can punch him, he'll go down, he'll stand up, he'll fight again. That's the analogy. He's truly the Rocky Balboa where he took so many punches, but he stood up again and say, "One more round."

**中文翻译:**
我们开始预测收入将只有去年的 7%、10%，这些低得离谱的数字。到处都是恐慌。而这正是我要说 Brian Chesky 是一位不可思议的领导者的地方。他是硅谷的洛奇·巴尔博亚（Rocky Balboa）。你可以揍他，他会倒下，但他会站起来再次战斗。这就是那个比喻。他真的是洛奇，挨了那么多重拳，却依然站起来说：“再来一回合。”

---

### (00:19:22) Sanchan Saxena

**English:**
And that's how the company survived. From an operating principle, we went into two week planning mode. Greg Greeley, who was the president of Airbnb used to say, "Look, can't plan for a year, can't plan for a quarter. We're going to plan every two weeks. We're going to react to every two weeks." And I think this is the lesson that I try to share with a lot of product people as well and founders as well is that things are going to go all right. Things are not going to go as you plan.

**中文翻译:**
公司就是这样生存下来的。从运营原则上讲，我们进入了“两周规划模式”。当时 Airbnb 的总裁 Greg Greeley 常说：“听着，没法做年度计划，也没法做季度计划。我们要每两周做一次计划，每两周做出一次反应。”我想这也是我尝试与许多产品人和创始人分享的教训：事情总会好起来的，但事情绝不会按你的计划进行。

---

### (00:19:47) Sanchan Saxena

**English:**
The real genius isn't to dot every eye, to cross every team before you get started. The real genius is, what do you do when shit goes wrong? And I believe rapid recovery is the key to success. What you do, how quickly you can recover from failure becomes really important. Our operating model changed. We went to two weeks shipping. All right, what are we doing for the next two weeks? What is the most urgent thing for the company? For the company. Not my team, not your team, not somebody else's team.

**中文翻译:**
真正的天才不在于开始前把每一个细节都考虑周全。真正的天才在于，当事情搞砸时你该怎么办？我相信“快速恢复”是成功的关键。你做什么、你能多快从失败中恢复，变得至关重要。我们的运营模式改变了，变成了两周发布一次。好吧，接下来的两周我们要干什么？对公司来说最紧迫的事情是什么？是对“公司”而言，而不是我的团队、你的团队或别人的团队。

---

### (00:20:13) Sanchan Saxena

**English:**
And we pivoted the entire machinery down over there. And then slowly and slowly after two or three months, we got to a place where we got semblance of what is happening. I want to tell you one story. Hotels and Airbnb are competitors, right? And when this thing happened, we had a debate, "How are we going to position Airbnb against hotels?" And actually we had to figure out what are the advantages of people staying in an Airbnb.

**中文翻译:**
我们把整个机器的重心都转到了那里。慢慢地，两三个月后，我们终于对现状有了一点掌控感。我想给你讲个故事。酒店和 Airbnb 是竞争对手，对吧？当这件事发生时，我们进行了一场辩论：“我们该如何定位 Airbnb 来对抗酒店？”实际上，我们必须弄清楚人们住在 Airbnb 的优势是什么。

---

### (00:20:35) Sanchan Saxena

**English:**
And luckily for us, being in an Airbnb where the air you breathe is only you and your family turned out to be a huge secret sauce to compete. When you're in a hotel, there's a lobby. You get to be with other people. But when you're are in an Airbnb, you're safe. We pivoted our marketing as well and messaging as well. The entire company came together to become one.

**中文翻译:**
对我们来说幸运的是，住在 Airbnb 里，你呼吸的空气只属于你和你的家人，这成了竞争中的巨大“秘密武器”。在酒店里有大堂，你得和别人待在一起。但在 Airbnb，你是安全的。我们调整了营销策略和信息传递。整个公司团结一致，拧成了一股绳。

---

### (00:20:55) Sanchan Saxena

**English:**
And through this, I would say Brian's leadership was just phenomenal, everything I learned about crisis management, leading with calmness. There's a very good saying in boxing. I love sports. There's a very good saying, which is, you can have all the plan. The moment you step inside the boxing and you get a punch on your face, all your plans go out the window. And you got to stay calm when you get a punch on your face.

**中文翻译:**
在这个过程中，我要说 Brian 的领导力简直太惊人了，我学到了关于危机管理的一切，以及如何冷静地领导。拳击界有一句名言（我热爱运动），那就是：你可以制定所有的计划，但当你踏入拳击场并挨了一记重拳时，所有的计划都会被抛到九霄云外。而当你挨揍时，你必须保持冷静。

---

### (00:21:15) Sanchan Saxena

**English:**
And that is what I learned from Brian, how to stay calm, how to stay composed while at the same time, deep down you know you owe a lot to these employees, you know you owe a lot to these employees to have clarity, and for them to stick around with you and believe in you that the company can turn around. It was an amazing journey, but pretty painful.

**中文翻译:**
这就是我从 Brian 身上学到的：如何保持冷静，如何保持镇定，同时在内心深处你知道你欠这些员工很多。你知道你欠他们一个清晰的交代，让他们愿意留下来并相信公司能够扭转局面。这是一段了不起的旅程，但也相当痛苦。

---

### (00:21:32) Lenny

**English:**
I haven't heard that level of detail about what went on inside, and so thank you for sharing all that. Very tactically, I'm curious, the two week planning cycles, how did that actually happen? Was there a large meeting every two weeks with the leaders and they just kind of discuss, "Here's where we're thinking for the next two weeks."?

**中文翻译:**
我还没听过关于内部情况如此详尽的描述，谢谢你的分享。从战术层面讲，我很好奇，那两周一次的规划周期具体是怎么运作的？是每两周和领导层开一次大会，讨论“这是我们未来两周的想法”吗？

---

### (00:21:48) Sanchan Saxena

**English:**
Yeah, I think so. One of the things about Airbnb, and we'll talk about it later as well, but it's a very founder-driven company. While there are leaders over there, the founder is deeply in the trenches. He really understands the customer. He's not this executive who's so far removed from reality that they can't actually create the content.

**中文翻译:**
是的，我想是的。关于 Airbnb 有一点（我们稍后也会谈到），它是一家非常由创始人驱动的公司。虽然那里有很多领导者，但创始人是深入一线的。他非常了解客户。他不是那种脱离现实、无法真正产出实质内容（content）的高管。

---

### (00:22:04) Sanchan Saxena

**English:**
Brian was living, breathing that exercise. Execs were breathing that thing. What we'll do is we'll have a bunch of things top-down. Again, this is what we need to do guys. We need to cut this feature. We need to cut this product line. We need to cut this business unit. I literally had to shut down one full business unit because we had to cut the bleeding, so to say, and let go of those many people.

**中文翻译:**
Brian 全身心地投入到那次行动中。高管们也是如此。我们会有一系列自上而下的指令。再说一次，就是：“伙计们，这是我们需要做的。我们需要砍掉这个功能，砍掉这条产品线，砍掉这个业务部门。”我当时不得不亲手关闭一个完整的业务部门，因为我们必须“止血”，并辞退那么多人。

---

### (00:22:24) Sanchan Saxena

**English:**
It was a top-down mandate, but also it was a bottom-up. The engineers, the product managers and designers are frontline. They are in connection with the CX team who's hearing what customers are complaining about. And so there was a mixture of top-down guidance to a bottoms-up things that we are seeing on the field. And every two weeks or so, the leadership, Greg in that case, for example, would make a decision on, "Here are the things we are going to go handle." And there were no teams anymore.

**中文翻译:**
这既是自上而下的指令，也是自下而上的反馈。工程师、产品经理和设计师都在前线。他们与 CX（客户体验）团队保持联系，听取客户的抱怨。因此，这是一种自上而下的指导与我们在实地看到的自下而上的情况的结合。大约每两周，领导层（例如当时的 Greg）会做出决定：“这些是我们接下来要处理的事情。”而且当时已经没有所谓的“小团队”了。

---

### (00:22:50) Sanchan Saxena

**English:**
We basically dissolved this idea that there are sub-teams. There was one team, #Airbnb. Didn't matter whether you worked in CX or Airbnb Plus or Lax, or any of those things, we're going to move engineers wherever we have to, we're going to move PMs wherever we need to, and there's no such thing as sub-team anymore.

**中文翻译:**
我们基本上解散了“子团队”的概念。只有一个团队，就是 #Airbnb。不管你是在 CX、Airbnb Plus 还是 Lax 工作，我们都会根据需要调动工程师和 PM，不再有子团队之说了。

---

### (00:23:09) Sanchan Saxena

**English:**
A lot of engineers on my team would go on to do marketplace dynamic stuff, like pricing and all that stuff, while some of those engineers would then go on to build CX tools or something else that was needed for survival. I felt like a 4,000 people company was operating as a four people company and a 40 people company, which is one team, no sub-teams, everybody rowing in the same direction. And that was really important.

**中文翻译:**
我团队里的很多工程师会去处理市场动态方面的事情，比如定价之类的；而另一些工程师则去开发 CX 工具或其他生存所需的东西。我觉得一家 4000 人的公司就像一家 4 人或 40 人的公司一样运作：一个团队，没有子团队，每个人都朝着同一个方向划船。这非常重要。

---

### (00:23:31) Sanchan Saxena

**English:**
Because remember, employees who are at your company are looking for clarity. What should they work on? Is the thing that they're going to work on meaningful, right? Because nobody knows, right? And when people will ask you as a leader, like many people ask me, what does six months look like? What does a year look like? Where are we a year from now?

**中文翻译:**
因为记住，公司的员工在寻求清晰度。他们应该做什么？他们要做的事情有意义吗？因为没人知道答案，对吧？当人们作为领导者问你（就像很多人问我一样）：“六个月后会是什么样子？一年后呢？一年后我们在哪里？”

---

### (00:23:46) Sanchan Saxena

**English:**
The most honest answer you can tell them is, "I don't know." Because if you cook shit up, they're going to see through that lie. They're going to like, "Ah, this is just all marketing fluff." We would be very honest as leaders, would be very vulnerable as leaders, saying, "This is truly once in a lifetime thing. We don't know how we're going to navigate. But here's what we believe to be true."

**中文翻译:**
你能给出的最诚实的回答是：“我不知道。”因为如果你瞎编，他们会识破谎言。他们会觉得：“啊，这只是营销废话。”作为领导者，我们会非常诚实，也会表现出脆弱的一面，说：“这真的是一生难遇的事情。我们不知道该如何导航。但这是我们相信的事实。”

---

### (00:24:05) Sanchan Saxena

**English:**
We had to get people from feature obsession, revenue obsession, to belief obsession. What is belief obsession? When we all believe that when coronavirus is over, people will want to travel. We all believe that coronavirus will be over. You start going into first principles belief-based thinking, and you'll bring stories that will make people believe that the future that we are working toward is actually possible.

**中文翻译:**
我们必须让人们从对功能、对收入的痴迷，转向对“信念”的痴迷。什么是信念痴迷？就是我们都相信，当新冠疫情结束时，人们会想要旅行。我们都相信疫情终将结束。你开始进入基于信念的第一性原理思考，并讲述那些让人们相信我们努力的方向确实可能实现的故事。

---

### (00:24:28) Sanchan Saxena

**English:**
For example, there was a survey we did, we said, "If money wasn't a consideration, what would you do for the rest of your life?" 99.99% of the people said, "I will travel the world." Travel is in human genes. And so we had to pivot to actually making people believe why travel will be back, why Airbnb will survive, and why Airbnb will eventually thrive if the coronavirus crisis is lower.

**中文翻译:**
例如，我们做过一个调查，问：“如果不考虑金钱，你余生想做什么？”99.99% 的人说：“环游世界。”旅行深植于人类基因中。因此，我们必须转型，让人们相信为什么旅行会回归，为什么 Airbnb 会生存下来，以及为什么当新冠危机缓解时 Airbnb 最终会蓬勃发展。

---

### (00:24:51) Lenny

**English:**
These stories are incredible. I was going to ask around the morale piece. You mentioned keeping morale up. And it sounds like a big piece of that was pulling people back to the mission and the vision of Airbnb and re-inspiring them, and helping them feel like this will work out. Is that what you found to be most effective, to keep more morale up, or is there anything else that also helped keep more morale up in this very tenuous time?

**中文翻译:**
这些故事太精彩了。我正想问关于士气的问题。你提到了保持士气。听起来很大一部分工作是把人们拉回到 Airbnb 的使命和愿景中，重新激励他们，让他们觉得事情会好起来。你发现这是保持士气最有效的方法吗？还是说在这个非常艰难的时期，还有其他什么东西也有助于维持士气？

---

### (00:25:11) Sanchan Saxena

**English:**
I think in these tenuous times you will notice that you can't pay these employees better than market. When this happened, FAANG companies were at our door trying to poach our engineers. Overnight, every engineer was pinged by Facebook, Google say, "Hey, we heard Airbnb is going down. You want to come over? We'll pay you X amount of money, and that stock is stable."

**中文翻译:**
我认为在这些艰难时期，你会发现你无法给员工提供高于市场的薪水。当这件事发生时，FAANG 公司就在我们门口等着挖走我们的工程师。一夜之间，每个工程师都会收到 Facebook、谷歌的消息：“嘿，听说 Airbnb 要倒了。想过来吗？我们会付给你 X 数量的钱，而且我们的股票很稳。”

---

### (00:25:34) Sanchan Saxena

**English:**
You had vultures at the door, so to say, as a proverbial exercise where your top talent is getting poached, but you can't pay this top talent the best. Right? You can't. Because your financial situation doesn't allow you to do that, right? But you still give them something, right? Because it's at a lower price and you start to sell the vision that if the company turns around, this will be at a higher price and you'll have right compensation. But those were some of the challenges.

**中文翻译:**
可以说，门口守着一群“秃鹫”，你的顶尖人才正在被挖走，但你却无法给他们最高的薪水。对吧？你做不到，因为财务状况不允许。但你仍然会给他们一些东西（比如期权），因为现在的价格很低，你开始向他们推销愿景：如果公司好转，这些期权会涨价，你就会得到应有的补偿。但这些确实是挑战。

---

### (00:25:56) Sanchan Saxena

**English:**
The second challenge is you'll notice that people who thrive in these situations will be the one who truly believe both in the mission, but I think more importantly in the founders to make that mission come to life. Because you and I both know, right, there are many companies who have the similar mission, want to do something similar, but some succeed and some don't.

**中文翻译:**
第二个挑战是，你会发现能在这种情况下坚持并表现出色的人，是那些既真正相信使命，又（我认为更重要地）相信创始人能让使命成真的人。因为你我都知道，有很多公司有类似的使命，想做类似的事情，但有些成功了，有些没有。

---

### (00:26:17) Sanchan Saxena

**English:**
The secret sauce of that in my opinion is the founder. And if the employees do not believe in the founder, if the employees do not believe that the founder can make things happen as they talk about, and the founder is not able to connect with the employees, those companies go down in flames. The second thing I would say is the founder needs to be at the front line. And Brian Chesky was on the front line.

**中文翻译:**
在我看来，其中的“秘密武器”就是创始人。如果员工不相信创始人，不相信创始人能像他说的那样把事情办成，如果创始人无法与员工建立联系，那些公司就会灰飞烟灭。我要说的第二点是，创始人需要站在前线。而 Brian Chesky 当时就在前线。

---

### (00:26:37) Sanchan Saxena

**English:**
He was literally 24/7 available, interacting, making decisions, holding all-hands, writing emails, sending messages, and assuring people that I'm in this with you. By the way, there's a proverbial thing, right? When such situations happen, all execs take a pay cut. Every company does that, right? But then still certain companies survive, certain don't, right?

**中文翻译:**
他真的是 24/7 待命，互动、做决策、开全员会、写邮件、发信息，并向大家保证“我和你们在一起”。顺便说一下，有一种惯例，对吧？当这种情况发生时，所有高管都会降薪。每家公司都会这么做，对吧？但仍然有些公司活了下来，有些没有。

---

### (00:26:58) Sanchan Saxena

**English:**
It's primarily because of the founder. And then the third thing I would say is somehow getting people to believe in the future that they came here to create. When drastic situations like these happens, when I joined Airbnb I had a vision of what it can become, and the reality snaps and all of a sudden like, "Holy shit. Is that even possible?"

**中文翻译:**
这主要是因为创始人。我要说的第三点是，设法让人们相信他们当初为了创造而来到这里的那个未来。当这种剧烈的情况发生时——当我加入 Airbnb 时，我对它能变成什么样有一个愿景，但现实突然断裂，你会想：“天哪，那还可能吗？”

---

### (00:27:21) Sanchan Saxena

**English:**
That is the real art I learned from Brian is that the power of storytelling without any data. Your data is telling you, "You're going to die." The data is telling you, you got 7%, 10% of your revenue, whatever the number was now. I forget now. Like single digit number, right?

**中文翻译:**
这就是我从 Brian 身上学到的真正艺术：在没有任何数据支持下的讲故事的力量。你的数据告诉你：“你要完蛋了。”数据告诉你，你的收入只剩下 7%、10%，不管那个数字是多少，我忘了，反正是个位数，对吧？

---

### (00:27:36) Sanchan Saxena

**English:**
And every day you're seeing the numbers go down, right? And Brian has this incredible ability to help you see a future in a way so crystal clear that when you leave chatting with him, you're like, "Man, it's possible. We can make it happen. We can do it." That trait was really, really important that Brian invested in it, and all the three founders, by the way.

**中文翻译:**
每天你都看着数字在下跌，对吧？而 Brian 拥有一种不可思议的能力，能帮你把未来看得如此清晰，以至于当你和他聊完离开时，你会觉得：“伙计，这是可能的。我们能办到。我们能行。”这种特质非常、非常重要，Brian 在这方面投入了很多，顺便说一下，三位创始人都是如此。

---

### (00:27:59) Lenny

**English:**
This episode is brought to you by Productboard. Product leaders trust Productboard to help their teams build products that matter. From startups to industry titans, over 6,000 companies rely on Productboard to get the right products to market faster, including companies like Zoom, Volkswagen, UiPath and Vanguard.

**中文翻译:**
本集节目由 Productboard 赞助。产品领导者信任 Productboard，帮助他们的团队打造重要的产品。从初创公司到行业巨头，超过 6000 家公司依靠 Productboard 将正确的产品更快地推向市场，包括 Zoom、大众汽车、UiPath 和先锋集团（Vanguard）等公司。

---

### (00:28:19) Lenny

**English:**
Productboard can help you create a scalable, transparent and standardized process, so your PMs understand what their customers really need and then prioritize the right features to build next. Stakeholders feel the love two with an easy to view roadmap that automatically updates so everyone knows what you're building and why. Make data-driven product decisions that result in higher revenue and user adoption, and empower your product teams to create delightful customer experiences.

**中文翻译:**
Productboard 可以帮助你创建一个可扩展、透明且标准化的流程，让你的 PM 了解客户的真实需求，并优先处理下一步要构建的正确功能。利益相关者也能通过易于查看且自动更新的路线图感受到便利，从而让每个人都知道你在构建什么以及为什么。做出数据驱动的产品决策，从而带来更高的收入和用户采用率，并赋能你的产品团队创造令人愉悦的客户体验。

---

### (00:28:48) Lenny

**English:**
Visit Productboard.com to learn more. I could talk about Airbnb all day, but I'm also curious of the other places you worked at, Instagram, Microsoft, even Coinbase. What are things you've seen the leaders at those companies do that have stuck with you that you're going to take to other places that are maybe unique?

**中文翻译:**
访问 Productboard.com 了解更多信息。关于 Airbnb 我可以聊上一整天，但我对你工作过的其他地方也很感兴趣，比如 Instagram、微软，甚至 Coinbase。在这些公司的领导者身上，你看到了哪些让你印象深刻、并打算带到其他地方的独特做法？

---

### (00:29:06) Sanchan Saxena

**English:**
Yeah, I think a lot of amazing things. I tell people, I learned all things about building great products, building great businesses, building great companies from founders like Kevin Systrom and Brian Chesky, Brian Armstrong and others. Well, let me go back to Instagram days. I want to paint the picture first of what it was when I got there and the journey we were on.

**中文翻译:**
是的，我想有很多了不起的事情。我告诉人们，我从 Kevin Systrom、Brian Chesky、Brian Armstrong 等创始人那里学到了关于打造伟大产品、伟大业务和伟大公司的一切。好吧，让我回到 Instagram 时代。我想先描绘一下我刚到那里时的情景以及我们所处的历程。

---

### (00:29:23) Sanchan Saxena

**English:**
At that time, Instagram was a highly successful app that was growing really fast, but there were many questions. Only photos, you can't share anything outside. It's only from the camera. You can't share links. At Facebook they allow you to share links. Why don't you allow that, right? There's an existential question that comes at those stages, which is who do you want to be when you grow up?

**中文翻译:**
当时，Instagram 是一款非常成功的 App，增长非常快，但也面临很多问题。只能发照片，不能分享到外部。只能从相机拍摄。不能分享链接。在 Facebook，他们允许分享链接，为什么你们不允许？在那个阶段会出现一个存在主义的问题：你长大后想成为谁？

---

### (00:29:45) Sanchan Saxena

**English:**
When you're a startup, that's a big, important question for you to answer. And there were many debates. "Do we want to be the next Facebook? Do we want to be the first Instagram? Who do we want to be when we grow up?" Right? And that debate is really, really important. That clarity is really important for your employees.

**中文翻译:**
当你是一家初创公司时，这是一个需要回答的重大且重要的问题。当时有很多争论：“我们想成为下一个 Facebook 吗？还是想成为第一个 Instagram？我们长大后想成为谁？”对吧？这种辩论非常、非常重要。这种清晰度对员工来说至关重要。

---

### (00:30:02) Sanchan Saxena

**English:**
The thing that I learned from Kevin Systrom was the power of simplicity. That guy can listen to everything, hear everything, hear the noise on Twitter, here, there, all the customers complaining, and then just simplify things that makes sense for the team to operate on. That's his superpower, which is simplicity. Take all the information, but simplify your strategy, your belief, who you want to be when you grow up in a way that people can then act on it.

**中文翻译:**
我从 Kevin Systrom 身上学到的是“简约”的力量。那家伙能倾听一切，听到 Twitter 上的噪音，听到各处客户的抱怨，然后把事情简化成对团队运作有意义的东西。那是他的超能力，即简约。吸收所有信息，但简化你的策略、你的信念以及你未来想成为谁，让人们能够据此采取行动。

---

### (00:30:28) Sanchan Saxena

**English:**
The other thing I learned from him was intentionality. This is the story of Instagram Stories. When Snapchat came about, Snapchat was eating Facebook and Instagram as lunch in many regards, because the Snapchat Stories was crushing it. And there are lots of myths, by the way, in the media, how that happened.It was a mandate from Zuck.

**中文翻译:**
我从他身上学到的另一件事是“意图性”（intentionality）。这就是 Instagram Stories 的故事。当 Snapchat 出现时，Snapchat 在很多方面都在抢占 Facebook 和 Instagram 的地盘，因为 Snapchat Stories 势不可挡。顺便说一下，媒体上有很多关于这件事如何发生的传闻，说是扎克伯格下的强制命令。

---

### (00:30:47) Sanchan Saxena

**English:**
No, Zuck did not have a mandate. There was no such thing. It was something that people were experimenting. I want to tell you a story, two stories, which is stories in Facebook app and stories inside of Instagram app, and stories for your audience is the stuff that Snapchat invented, all credit to them. In product management, you always debate measure twice, cut once kind of a thinking. It's like measure the data, get all the data, right? Get all the analysis, ask customers, et cetera.

**中文翻译:**
不，扎克伯格没有下强制命令。没那回事。那是人们正在实验的东西。我想给你讲两个故事：Facebook App 里的 Stories 和 Instagram App 里的 Stories。对于听众来说，Stories 是 Snapchat 发明的，功劳归他们。在产品管理中，你总是会争论“三思而后行”（measure twice, cut once）式的思维。就像测量数据、获取所有数据、进行所有分析、询问客户等等。

---

### (00:31:12) Sanchan Saxena

**English:**
Some of the successful founders don't do that. Some of the successful founders go off of gut and instincts more than they go off of data. And that to me is a superpower of a founder is like they have this instinct, their vision. I'll tell you a story. On Instagram side, Kevin Systrom made a decision. We're going all in on this new format. There was no A/B testing that if you add stories at the top ...

**中文翻译:**
一些成功的创始人并不这样做。一些成功的创始人更多地依靠直觉和本能，而不是数据。对我来说，那是创始人的超能力，就像他们拥有这种直觉和愿景。我给你讲个故事。在 Instagram 这边，Kevin Systrom 做了一个决定：我们要全力投入这种新格式。当时并没有做 A/B 测试来验证如果你在顶部添加 Stories 会怎样……

---

### (00:31:34) Sanchan Saxena

**English:**
I mean, there were a little bit of A/B testing, but not like, "Okay, let's go measure. If you add stories at the top, the feed will go down as a result. Engagement will drop as a result. Revenue will draw. And as a result, we should not do it." There was no such thing. The founder said, "We're going all in people. This is the future. We're not going to measure and then cut. We're going to cut. And then we are going to iterate from that new baseline. We're going to continue to iterate on that on the Facebook side."

**中文翻译:**
我的意思是，有一点点 A/B 测试，但不是那种：“好吧，让我们去测量一下。如果你在顶部添加 Stories，Feed 流的点击量会因此下降。参与度会因此下降。收入会因此下降。因此，我们不应该这样做。”完全没有这回事。创始人说：“伙计们，我们要全力以赴。这就是未来。我们不会先测量再动手，我们要先动手，然后从那个新的基准线开始迭代。我们要在 Facebook 那边继续迭代。”

---

### (00:31:57) Sanchan Saxena

**English:**
And by the way, there's a very good article that some PM inside of Facebook wrote why stories didn't survive at Facebook but thrived at Instagram is because on that side there was a mathematical modeling being created, which is what are the trade-offs. And you have a successful business. And this is the innovator's dilemma. You have a successful business called feed that is generating billions of dollars.

**中文翻译:**
顺便说一下，Facebook 内部的一位 PM 写过一篇非常好的文章，解释了为什么 Stories 在 Facebook 没能存活但在 Instagram 却蓬勃发展。原因是在 Facebook 那边，他们建立了一个数学模型来权衡利弊。你已经拥有了一个成功的业务。这就是“创新者的窘境”。你有一个叫 Feed 的成功业务，它正在产生数十亿美元的收入。

---

### (00:32:16) Sanchan Saxena

**English:**
And you got to bring in this new thing, which has zero advertisers, we don't even know if the engagement will be there or not, and you got to put those things together. There was a very different approach that Facebook took for stories versus Instagram. And by the way, there was no this rumor in the media there was a top-down man. No, these teams were just experimenting. They were just trying things out.

**中文翻译:**
而你必须引入这个新东西，它没有广告商，我们甚至不知道参与度会如何，你必须把这些东西放在一起。Facebook 对 Stories 采取的方法与 Instagram 截然不同。顺便说一下，媒体上关于“自上而下强制执行”的传闻是不存在的。不，这些团队只是在实验，只是在尝试。

---

### (00:32:35) Sanchan Saxena

**English:**
We always want to look at our competition, be inspired by what's working, what's not. There's no harm in learning from somebody who's doing something great and experiment and see if that works for you or not. That was the story. And the thing that I learned from Systrom was intentionality. As a founder, one of the things you have to recognize, or even as a product leader, you have to recognize is that every product that you build should be intentional in nature.

**中文翻译:**
我们总是想观察竞争对手，从成功和失败中汲取灵感。向做得出色的人学习并进行实验，看看是否适合你，这并没有坏处。这就是那个故事。我从 Systrom 身上学到的是“意图性”。作为创始人，或者作为产品领导者，你必须认识到的一点是：你构建的每一个产品在本质上都应该是具有明确意图的。

---

### (00:32:57) Sanchan Saxena

**English:**
An intentionality doesn't come just from A/B testing. A/B testing maybe you can do that, right, as a later on, but you got to have intentionality. Where do you want to go? What is the world you want to create for your customers? And then create out A/B testing to get you the fastest route to that end state world. When I talk to product managers, oftentimes I tell them you're being either too lazy or you're trying to be too risk averse by telling me, "Here are the assumptions you have that you're going to test."

**中文翻译:**
意图性不仅仅来自 A/B 测试。A/B 测试也许你可以在后期做，但你必须先有意图。你想去哪里？你想为客户创造一个什么样的世界？然后通过 A/B 测试找到通往那个终极状态的最快路径。当我与产品经理交谈时，我经常告诉他们，如果你只是告诉我“这些是你要测试的假设”，那么你不是太懒了，就是太规避风险了。

---

### (00:33:24) Sanchan Saxena

**English:**
First tell me the intentionality of the product that you want to create. What do you want to see come true? And then let's talk about the A/B test we can run to measure that we are headed in the right direction. And it's a flipping of the mind. And that was something that Brian also taught me. By the way, it's a joke, but some degree it's reality too. A/B testing at Airbnb is a bad word.

**中文翻译:**
先告诉我你想创造的产品的“意图”是什么。你希望看到什么成真？然后我们再讨论可以运行哪些 A/B 测试来衡量我们是否正朝着正确的方向前进。这是一种思维的转变。这也是 Brian 教给我的。顺便说一下，这虽然是个笑话，但在某种程度上也是事实：在 Airbnb，“A/B 测试”是个贬义词。

---

### (00:33:44) Sanchan Saxena

**English:**
You don't go to Brian and say, "Hey Brian, here's my Excel spreadsheet. I want to run some 10 A/B tests and come back and tell you whether we are heading in the right direction." You're going to get thrown out of the window. It's like, "No, we got to figure out what the product is." The other thing I learned with Brian Chesky was you first want to create an ideal end state of the product without any constraint.

**中文翻译:**
你不能跑到 Brian 面前说：“嘿 Brian，这是我的 Excel 表格。我想运行 10 个 A/B 测试，然后回来告诉你我们是否方向正确。”你会被扔出窗外的。他会说：“不，我们得先弄清楚产品到底是什么。”我从 Brian Chesky 那里学到的另一件事是：你首先要创造一个没有任何约束的产品理想终极状态。

---

### (00:34:05) Sanchan Saxena

**English:**
Here's a good analogy that Brian will teach people. Let's say you want to build Airbnb. What is the 15 out of 10 experience you want to create? That's where Airbnb designers and PM start by the way. In most companies, the designers and PM start by saying, "Okay, 10 is perfect. We can probably do seven. Let's start at seven." It's a very constrained minded thinking. It's like, "I got this much time. I got this many resources. I got this much budget. I can only do so much." Right?

**中文翻译:**
这是 Brian 会教给人们的一个很好的类比。假设你想打造 Airbnb。你想创造的“15 分（满分 10 分）”体验是什么？顺便说一下，这就是 Airbnb 设计师和 PM 的起点。在大多数公司，设计师和 PM 的起点是：“好吧，10 分是完美的，我们大概能做到 7 分，那就从 7 分开始吧。”这是一种非常受限的思维方式。就像是：“我只有这么多时间，这么多资源，这么多预算，我只能做这么多。”对吧？

---

### (00:34:31) Sanchan Saxena

**English:**
And what Brian taught us was think unconstrained first. Think about a 15 out of 10 experience, design the ideal end state first. I'll give you a very concrete example of this. Let's say you're building Airbnb lounges. A customer's check in is at 3:00 PM, but their flight is at 6:00 AM. What are you going to do? Well, you got to build a lounge, right?

**中文翻译:**
Brian 教给我们的是：首先要进行无约束思考。思考一个 15 分的体验，先设计理想的终极状态。我给你举个具体的例子。假设你在建造 Airbnb 休息室。客户下午 3 点才能入住，但他们的航班早上 6 点就到了。你该怎么办？好吧，你得建个休息室，对吧？

---

### (00:34:50) Sanchan Saxena

**English:**
If you're traditionally trained in product management, this is what you'll do, which is, look, I don't know how to build this in 120 countries. I don't know how to scale this stuff. So I'm going to ignore some ideas and I'm going to build a MVP lounge. And then I want to say, "Okay, if I add internet access to it, customer detention went up by way. If I add coffee to it, this went up by Z.If I add cheers to it, it went up by X," and hence I'm going to justify how to build a beautiful mall.

**中文翻译:**
如果你接受过传统的产品管理培训，你会这样做：看，我不知道如何在 120 个国家建造这个，我不知道如何扩展。所以我会忽略一些想法，先建一个 MVP（最小可行性产品）休息室。然后我会说：“好吧，如果我加上网络，客户留存率提高了 Y；如果加上咖啡，提高了 Z；如果加上座椅，提高了 X，”以此来证明如何建造一个漂亮的商场。

---

### (00:35:15) Sanchan Saxena

**English:**
That's not what you will do if you're Brian Chesky. Here's what you'll do. You will pick one location because you don't know how to scale a lounge in 120 countries. Pick one location. But you know how to get in one location a barista who can create coffee, you know in one location how to get the best seats, you know in one location how to get the best air conditioning, you know that right. Build the best possible lovable product first.

**中文翻译:**
如果你是 Brian Chesky，你不会这么做。你会这样做：你会选一个地点，因为你确实不知道如何在 120 个国家扩展休息室。选一个地点。但在一个地点，你知道如何找一个能做咖啡的咖啡师，你知道如何弄到最好的座椅，你知道如何装最好的空调，对吧。先打造出最棒的、最让人喜爱的产品。

---

### (00:35:38) Sanchan Saxena

**English:**
And then from that point on, understand what worked, what did not, and then scale the pieces that actually worked. It's a very different way of thinking about things, doing things that don't scale it first. Those are different things I learned at Instagram and Airbnb.

**中文翻译:**
然后从那时起，了解哪些有效，哪些无效，再扩展那些真正有效的部分。这是一种非常不同的思考方式，即先做那些“无法规模化”的事情。这些是我在 Instagram 和 Airbnb 学到的不同的东西。

---

### (00:35:50) Lenny

**English:**
So much good stuff there that we could do a podcast at each learning. And that point about working backwards from the ideal, that's something I've absolutely taken away also from Airbnb and news often. If folks want to learn a bit more about that, if you Google Snow White Airbnb, there's a whole story about Snow White that kind of touches on where a lot of this idea came from.

**中文翻译:**
这里面有太多干货了，每一个学习点我们都能单独做一期播客。关于从理想状态倒推的那一点，我也绝对是从 Airbnb 学到的，并且经常使用。如果大家想多了解一点，可以谷歌搜索“Snow White Airbnb”，有一个关于《白雪公主》的完整故事，触及了这些想法的来源。

---

### (00:36:08) Lenny

**English:**
I want to follow up on one point you made about intentionality. See your founder or PM and you're just like, "Oh, yeah. Okay. I'm just going to figure out a vision, and this is where we need to go. And I need to be intentional, so I'm just going to tell people here's where we're going." Oftentimes you're wrong.

**中文翻译:**
我想跟进一下你提到的关于“意图性”的一点。假设你是一名创始人或 PM，你心想：“哦，好的。我就定一个愿景，这就是我们要去的地方。我需要有意图，所以我直接告诉大家我们要去哪儿。”但通常情况下，你是错的。

---

### (00:36:24) Lenny

**English:**
Do you have any thoughts for someone trying to decide how do I know if I'm going in the right direction, how do I know if I should trust this gut that I have versus running A/B test, because otherwise we don't know? Do you have any thoughts on that?

**中文翻译:**
对于那些试图决定“我怎么知道我是否走在正确的方向上，我怎么知道我该相信自己的直觉还是运行 A/B 测试（因为不测我们就不知道）”的人，你有什么想法吗？

---

### (00:36:35) Sanchan Saxena

**English:**
Absolutely. I think there are lots of things to unpack there. The first and foremost thing I'd say is that when you sit in your car, you tell your GPS, "Here's where I want to go." You never go into your car and say, "Hey, GPS, tell me where I should go." Right? At least I haven't done that. And then you use the GPS to run an A/B test, say, "Look, I want to get there in the fastest way possible."

**中文翻译:**
当然。我认为这里有很多东西可以拆解。首先我要说的是，当你坐在车里时，你会告诉 GPS：“这是我想去的地方。”你绝不会进到车里说：“嘿，GPS，告诉我该去哪儿。”对吧？至少我没这么干过。然后你利用 GPS 运行一个“A/B 测试”，说：“看，我想以最快的方式到达那里。”

---

### (00:36:58) Sanchan Saxena

**English:**
GPS then figures out the path to get there in the fastest way, or sometimes tell the GPS, "I'm low on gas. Take me a gas efficient route that I can get there, or [inaudible 00:37:07]." Those are A/B tests. But you never say to the GPS that, "I don't want to go to San Francisco. Tell me where I should go." It's a similar concept around intentionality.

**中文翻译:**
GPS 随后会计算出最快的路径，或者有时你告诉 GPS：“我快没油了，给我找条省油的路线。”这些就是 A/B 测试。但你绝不会对 GPS 说：“我不想去旧金山，你告诉我该去哪儿。”关于意图性，也是类似的道理。

---

### (00:37:19) Sanchan Saxena

**English:**
You got to start first and foremost with, where do you want to go? What is the true customer problem that you want to solve? And why does that matter? The second thing I'll say is, oftentimes, product leaders discount gut or intuition a lot. And the reason is it's a safe thing to do. You can always point to data and say, "Look, I did this because of this. And if I fail, here's the data. And don't fire me." I'm just joking.

**中文翻译:**
你首先必须从“你想去哪里”开始。你想解决的真实客户问题是什么？为什么这很重要？我要说的第二点是，产品领导者往往会极大地低估直觉。原因是这样做很安全。你总是可以指向数据说：“看，我这么做是因为这个。如果我失败了，这是数据，别开除我。”我只是在开玩笑。

---

### (00:37:44) Sanchan Saxena

**English:**
But you get the extreme of it, right? It's very hard to build a team and build your reputation and get an intuition. But the thing is, founders do exactly that. There was no document that said, "10 years later Facebook will make billions of dollars in revenue," or no document that said, "Coinbase one day will become a hundred billion dollar company if you invest in that at that point in time." You got to have gut and intuition. And founders have that and operators need to learn how to harness that as well.

**中文翻译:**
但你能理解这种极端情况，对吧？建立团队、建立声誉并获得直觉是非常困难的。但事实是，创始人正是这么做的。没有任何文件预言过“10 年后 Facebook 会产生数十亿美元的收入”，也没有文件说“如果你在那时投资 Coinbase，它有一天会成为一家千亿美元的公司”。你必须有直觉。创始人拥有直觉，而运营者也需要学会如何利用它。

---

### (00:38:07) Sanchan Saxena

**English:**
And to me, gut and intuition is data. It's just not statistically significant yet. That's all it is. You have built that intuition, that gut, because you immerse yourself in a situation, you hung out with customers, you understood what was happening. You just can't prove it that it is statistically significant yet.Don't discount your gut. That's the second point.

**中文翻译:**
对我来说，直觉也是数据，只是它目前还不具备统计学上的显著性。仅此而已。你建立了这种直觉，是因为你沉浸在某种情境中，你与客户相处，你了解正在发生的事情。你只是还无法证明它在统计上是显著的。不要轻视你的直觉，这是第二点。

---

### (00:38:28) Sanchan Saxena

**English:**
And the third point that I'll say is, once you have figured out what that experience looks like, yes, you got to validate what's happening, you got to get feedback back from the community while launching it, and then you got to constantly iterate. My advice to people is, don't do that testing up front, start with some assumption, start with a bunch of intuition, et cetera. Create that and then have the appetite to actually persist through that.

**中文翻译:**
我要说的第三点是，一旦你弄清楚了那种体验是什么样的，是的，你必须验证正在发生的事情，在发布时从社区获取反馈，然后不断迭代。我给人们的建议是：不要在最开始就做那种测试，先从一些假设、一些直觉开始。创造出东西，然后有胃口去坚持下去。

---

### (00:38:51) Sanchan Saxena

**English:**
That's another thing I learned from Brian is that oftentimes these ideas, these crazy ideas, you need persistence. He used to say, "You got to have impatience with getting started, but patience for seeing them through." Because at many other companies, you can actually kill a brilliant idea early on because you just didn't have the patience to see that through.

**中文翻译:**
这是我从 Brian 那里学到的另一件事：通常这些疯狂的想法需要坚持。他常说：“你必须对‘开始’感到迫切，但对‘完成’保持耐心。”因为在许多其他公司，你可能会在早期就扼杀一个绝妙的想法，仅仅是因为你没有耐心看到它开花结果。

---

### (00:39:11) Sanchan Saxena

**English:**
You got to start with intentionality and then you got to iterate and test, and iterate and test, and iterate and test. But don't give up too early either. And last but not the least, I'll tell a secret to all your audios.

**中文翻译:**
你必须从意图性开始，然后不断迭代和测试。但也不要过早放弃。最后但同样重要的一点，我要告诉所有听众一个秘密。

---

### (00:39:21) Lenny

**English:**
Oh boy, here we go.

**中文翻译:**
噢，天哪，开始了。

---

### (00:39:23) Sanchan Saxena

**English:**
Nobody knows everything. Right? The idea is that you can look at as much data as you want, which is still not going to feel that all the answers. What is really important? The really important thing is rapid recovery. Build a culture in your team where failure of those experiments is actually celebrated.

**中文翻译:**
没有人知道一切。对吧？关键在于，你可以看尽可能多的数据，但它仍然无法提供所有的答案。什么才是真正重要的？真正重要的是“快速恢复”。在你的团队中建立一种文化，让实验的失败实际上是被庆祝的。

---

### (00:39:41) Sanchan Saxena

**English:**
Build a culture in the team where actually people get energized when they fail, because guess what, each failure was a learning that will avoid a mistake for them in the future. Right? And I think that is the mindset and culture you want to build. Look at data, look at all the things. But at the same time, don't just look at that and say, "Look, because the data said so, that is what I'm going to do." I'm going to use a very good analogy over here.

**中文翻译:**
在团队中建立一种文化，让人们在失败时反而感到充满活力，因为你猜怎么着，每一次失败都是一次学习，能让他们在未来避免同样的错误。对吧？我认为这就是你想建立的心态和文化。看数据，看所有的东西。但与此同时，不要只是看着数据说：“看，因为数据这么说，所以我才这么做。”我在这里用一个很好的类比。

---

### (00:40:03) Sanchan Saxena

**English:**
And this story has been butchered many times, but I was right there when this happened, so my version is at least 80% accurate. There might be other versions as well. But this is Instagram Stories. Imagine you are Kevin Systrom and data science comes to you and say, "Look, I looked at data, and 99% of all photos on people's phones are actually at least a week old. Please allow Instagram Stories to let people select a photo that is at least a week or two old."

**中文翻译:**
这个故事被传得五花八门，但发生时我就在现场，所以我的版本至少有 80% 的准确度。可能还有其他版本。这是关于 Instagram Stories 的。想象你是 Kevin Systrom，数据科学团队跑来对你说：“看，我看了数据，人们手机里 99% 的照片其实都至少是一周前的。请允许 Instagram Stories 让人们选择至少一周或两周前的照片。”

---

### (00:40:30) Sanchan Saxena

**English:**
Then user research comes back and says, "We talked to a bunch of people. They said, 'Yes, I would love to share a story of my birthday about a month ago.'" Right? And Kevin Systrom says, "No, my intentionality is that story should be real time news. It should be the world's largest TV channel. You open that up and you see what's happening right now. That is the intentionality I'm going towards."

**中文翻译:**
然后用户研究团队也回来了，说：“我们和一群人聊过，他们说：‘是的，我很想分享一个月前我过生日的故事。’”对吧？而 Kevin Systrom 说：“不，我的意图是 Stories 应该是实时新闻。它应该是世界上最大的电视频道。你打开它，就能看到现在正在发生什么。这就是我努力的方向。”

---

### (00:40:51) Sanchan Saxena

**English:**
In the beginning, Instagram Stories did not let you pick anything that was not real time. You couldn't go back in your camera and pick something a month ago or two ago, because the intentionality of the product was to create the world's largest real time network of what's happening in the world right now. If that's the intentionality, you got to ignore the other customer needs that I want to share with the world what I did a month ago, and that changes the dynamics.

**中文翻译:**
在最开始，Instagram Stories 不允许你选择任何非实时的内容。你不能回到相册去选一个月或两个月前的照片，因为产品的意图是创建一个世界上最大的、关于世界上正在发生什么的实时网络。如果这就是意图，你就必须忽略“我想分享一个月前做了什么”的其他客户需求，因为那会改变产品的动态。

---

### (00:41:14) Lenny

**English:**
Essentially, intentionality is setting up vision for where you want to go, where the product's going and then working away towards it. That makes a lot of sense. An example of Instagram. It's interesting because he eventually changed his mind, because I know that you can upload old photos to stories [inaudible 00:41:28]

**中文翻译:**
本质上，意图性就是为你想要达到的目标、产品的走向设定愿景，然后朝着它努力。这很有道理。以 Instagram 为例，有趣的是他最终改变了主意，因为我知道现在可以上传旧照片到 Stories 了。

---

### (00:41:27) Sanchan Saxena

**English:**
No, that's actually after he left. But yes, you're right.

**中文翻译:**
不，那其实是在他离开之后才改的。但没错，你说得对。

---

### (00:41:29) Lenny

**English:**
Okay, I see. A different intentionality appeared.

**中文翻译:**
好的，我明白了。出现了一种不同的意图。

---

### (00:41:34) Sanchan Saxena

**English:**
And look, it's also nothing wrong with changing your mind afterwards once you push the envelope, and then you learn something new and you can pivot. And that's another beauty of founders is that they're very intentional people, very strong opinionated people, but in the face of something new, they're also the fastest to change. They don't have remorsefulness, they don't have regrets, and like, "Yeah. All right, let's pivot." And that is the culture you want to build as well as an operator.

**中文翻译:**
而且你看，在你突破极限之后改变主意也没什么错，你会学到新东西并可以转型。这也是创始人的另一个魅力所在：他们是非常有意图的人，非常有主见，但面对新事物时，他们也是改变最快的人。他们不会懊悔，不会遗憾，只会说：“行，没问题，转型吧。”作为一名运营者，这也是你想建立的文化。

---

### (00:41:57) Lenny

**English:**
I'd love to spend a little time on Coinbase and the product culture there. How A/B test driven is it at Coinbase? How do folks think about intentionally vision? And also just, what's the product development process like? I'm always curious how products is developed at different companies.

**中文翻译:**
我想花点时间聊聊 Coinbase 及其产品文化。在 Coinbase，A/B 测试的驱动程度如何？大家如何思考意图和愿景？另外，产品开发流程是怎样的？我一直很好奇不同公司的产品是如何开发出来的。

---

### (00:42:10) Sanchan Saxena

**English:**
I think all different companies that I've worked at have very different product development cultures. At Airbnb, for example, design and experience was super paramount, and you will not compromise over it. You won't cut design to ship. In other companies you will cut design to ship sometimes because you want to find something quickly.

**中文翻译:**
我认为我工作过的所有不同公司都有非常不同的产品开发文化。例如，在 Airbnb，设计和体验是至高无上的，你绝不会为此妥协。你不会为了发布而牺牲设计。在其他公司，有时你会为了快速验证而牺牲设计。

---

### (00:42:26) Sanchan Saxena

**English:**
At Coinbase, it's slightly different as well. Every company has their nuances. Coinbase is an industry which is rapidly growing. It's Web 3.0. I mean, I have not come across a Web 3.0 expert yet. There is nobody who's an expert in Web 3.0.

**中文翻译:**
在 Coinbase，情况也略有不同。每家公司都有其细微差别。Coinbase 所处的行业正在飞速增长，也就是 Web 3.0。我的意思是，我还没遇到过真正的 Web 3.0 专家。目前还没有人敢自称是 Web 3.0 的专家。

---

### (00:42:40) Lenny

**English:**
They seem to be on Twitter.

**中文翻译:**
Twitter 上好像到处都是专家。

---

### (00:42:41) Sanchan Saxena

**English:**
Yeah. There are lots of people who think they're experts on Twitter. But the reality is, man, the industry is so nascent, so early. You have good intentions and good intuition about where it could go, but it's very hard to be right all the time. The culture of Coinbase is to take big, bold bets, get started with very tiny teams.

**中文翻译:**
是的，Twitter 上有很多自以为是专家的人。但现实是，伙计，这个行业太稚嫩、太早期了。你对它的走向有良好的意图和直觉，但很难一直保持正确。Coinbase 的文化是进行大胆的豪赌，并从非常小的团队开始。

---

### (00:43:00) Sanchan Saxena

**English:**
The Coinbase NFT marketplace that we just launched, it started with five people, one product manager, one designer and other three engineers. That's how smart it start. And of course it has grown big now as we find product market fit, etcetera, et cetera. But that's the idea is take big, bold swings, but with tiny teams that can move at lightning speed and make shit happen, because that's one aspect of it.

**中文翻译:**
我们刚刚推出的 Coinbase NFT 市场，最初只有五个人：一名产品经理、一名设计师和三名工程师。它就是这样精简地启动的。当然，随着我们找到产品市场契合点，它现在已经壮大了。但核心理念是：进行大胆的尝试，但要依靠能以闪电般速度行动并促成事情发生的小型团队，这是其中的一个方面。

---

### (00:43:22) Sanchan Saxena

**English:**
The other culture that I love about Coinbase is this idea of how we make decisions. Emily, our COO, posted a blog. It's public. You guys can all read it. It's a very different mindset of making decisions, so let me unpack that. When I was at Facebook, Instagram and other companies, other tech companies, there's a saying around product and design, marketing. All these cross functional people need to come together to build a product.

**中文翻译:**
我喜欢的 Coinbase 另一种文化是我们的决策方式。我们的 COO Emily 发过一篇博客，是公开的，大家都可以读。这是一种非常不同的决策思维，让我来拆解一下。当我在 Facebook、Instagram 和其他科技公司时，有一种关于产品、设计、营销的说法：所有这些跨职能人员需要聚在一起共同打造产品。

---

### (00:43:45) Sanchan Saxena

**English:**
And oftentimes you will notice that the decision making process could get a little bit convoluted, not always, but a little bit convoluted. It's like, okay, what do you like? What do you don't like? You got to align influence, align influence. And next thing you know ... And again, I'm not saying always, but sometimes it can happen that the thing that ends up shipping is the least common denominator that annoyed everybody the least amount, right?

**中文翻译:**
你经常会发现决策过程可能会变得有点复杂，不总是这样，但有时会。就像是：“好吧，你喜欢什么？你不喜欢什么？”你得去对齐影响力，对齐再对齐。接下来的事情你懂的……我不是说总是这样，但有时最终发布的东西是“最小公分母”，也就是让所有人最不反感的东西，对吧？

---

### (00:44:09) Sanchan Saxena

**English:**
Everybody said, "Yeah, I could get comfortable with that. I could get comfortable with that." And Brian has an allergic reaction to things like committees. It's like designing by committee. The idea that we have, and you can read it in her blog, is the idea of a directly responsible individual or DRI.

**中文翻译:**
每个人都说：“是的，我可以接受那个。”而 Brian 对“委员会”之类的东西有种过敏反应。这就像是“由委员会进行设计”。我们的理念（你可以在她的博客中读到）是“直接责任人”或 DRI 的概念。

---

### (00:44:26) Sanchan Saxena

**English:**
For every project, we'll establish a DRI. It could be a person in operations, engineering, design, legal, marketing, whatever that is, depending on the nature of the project. And DRI's job is to then listen to the cross functional partners, get their input. And we have a written culture like Amazon, so every input is provided in writing. Right?

**中文翻译:**
对于每个项目，我们都会确定一个 DRI。根据项目的性质，他可能是运营、工程、设计、法务或营销人员。DRI 的工作是听取跨职能合作伙伴的意见，获取他们的输入。我们像亚马逊一样有“书面文化”，所以所有的意见都是以书面形式提供的。对吧？

---

### (00:44:45) Sanchan Saxena

**English:**
You can see what head of legal is saying. You can see what your head of operations is saying, what engineering is saying in writing. And then the DRI's job is to take all that input and make a decision. Not take all that input and do necessarily what's right by everybody, right? Still do what's right by the customer. Still do what's right by the business. Still do what's right for the user in many regards.

**中文翻译:**
你可以看到法务负责人说了什么，运营负责人说了什么，工程师在书面上说了什么。然后 DRI 的工作是吸收所有这些输入并做出决定。不是吸收所有输入然后做让每个人都满意的事，对吧？而是做对客户正确的事，做对业务正确的事，在很多方面做对用户正确的事。

---

### (00:45:07) Sanchan Saxena

**English:**
But take that input, inform yourself with all the right things, but it's your job to then make the final call. Whoever you might be, sometimes it's operations, sometimes it's engineering, sometimes it's design and product, and others then have to disagree and champion that for you. I might go in and I might write in that rapid, "I disagree with this. Here are the reasons why."

**中文翻译:**
吸收输入，用正确的信息武装自己，但最后拍板是你的职责。无论你是谁，有时是运营，有时是工程，有时是设计和产品，而其他人则必须“保留异议并全力支持”（disagree and champion）。我可能会进去在那个 RAPID（决策模型）里写道：“我不同意这个，理由如下。”

---

### (00:45:27) Sanchan Saxena

**English:**
But the decider the DRI has to make that decision. And once that decision is made, I got to disagree and commit to it and champion it with the rest of the team as if it was my decision. It's not just disagree and commit, it's disagree and champion. Go out there and evangelize that this is the right thing to do. Now, there are lots of advantages of that.

**中文翻译:**
但决策者 DRI 必须做出决定。一旦决定做出，我就必须保留异议并执行，并像这是我自己的决定一样在团队中拥护它。这不仅仅是“保留异议并执行”，而是“保留异议并拥护”。去外面宣传这是正确的事情。这样做有很多好处。

---

### (00:45:43) Sanchan Saxena

**English:**
It cuts all the passive aggressive behaviors that all of us have seen in different companies. It's like, "Ah, I got to go talk to this head of X, and I got to be nice. I got to make sure we have this relationship." And the decision gets dragged over two, three months, because the speed of decision making is directly proportional to the strength of your relationship in those companies, right?

**中文翻译:**
它消除了我们在不同公司都见过的所有“消极对抗”行为。比如：“啊，我得去跟某某部门负责人谈谈，我得表现得客气点，我得确保我们关系稳固。”结果决策被拖了两三个月，因为在那些公司里，决策速度与你的人际关系强度成正比，对吧？

---

### (00:46:02) Sanchan Saxena

**English:**
Here, the speed of decision making is directly proportional to the person who's directly responsible from making that decision happen. And it is, of course, incumbent upon that person to listen and get unsolicited advice. But at the end of the day, they're the single [inaudible 00:46:16]. They're the final DRI. It's a very different culture than any place I've worked in. And when you join Coinbase, we have to orient you by saying, "Look, this is how you operate," very different than any other company.

**中文翻译:**
在这里，决策速度与直接负责促成该决策的人直接相关。当然，那个人有责任倾听并获取主动提供的建议。但归根结底，他们是唯一的决策者，是最终的 DRI。这与我工作过的任何地方都非常不同。当你加入 Coinbase 时，我们必须对你进行入职培训，告诉你：“看，这就是你的运作方式，”这与其他任何公司都大不相同。

---

### (00:46:28) Lenny

**English:**
That's so interesting. Is that how big decisions are made or does that filter down to even individual teams where a PM or whoever is a DRI in a team makes decisions this way?

**中文翻译:**
这太有意思了。这是重大决策的制定方式，还是说它会渗透到每个团队，让 PM 或团队中的任何 DRI 都以这种方式做决策？

---

### (00:46:37) Sanchan Saxena

**English:**
Individual people as well. You will see PMs writing, engineers writing, and operations and legal writing a rapid. It's called rapid. It's for rapid decision making. And it's the same format that I would use if I want Brian to make a decision. It's the same format someone will use inside their team.

**中文翻译:**
个人也是如此。你会看到 PM 在写，工程师在写，运营和法务也在写 RAPID。它叫 RAPID，是为了快速决策。如果我想让 Brian 做决定，我会用这种格式；如果有人在团队内部做决定，也会用同样的格式。

---

### (00:46:52) Sanchan Saxena

**English:**
Let's say you are working on a particular project, you will write that rapid. It's the same exact format, same exact mechanism, and every team uses those mechanisms to actually scale. Otherwise, decision making can actually be the [inaudible 00:47:05] of hypergrowth companies.

**中文翻译:**
假设你正在负责一个特定项目，你会写那个 RAPID。完全相同的格式，完全相同的机制，每个团队都使用这些机制来实现规模化。否则，决策过程实际上会成为超速增长公司的绊脚石。

---

### (00:47:06) Lenny

**English:**
Is there anything else that's unique about how Coinbase operates that's stuck with you that you might take to a future company that you may work at if you ever leave Coinbase?

**中文翻译:**
关于 Coinbase 的运作方式，还有什么独特的点让你印象深刻，以至于如果你以后离开 Coinbase，可能会带到未来的公司去？

---

### (00:47:14) Sanchan Saxena

**English:**
Yeah. I think decision making is one. I think just the idea of how to operate in such an ambiguous industry. When I got to Airbnb, ambiguity was a lot, because it was the first time we were doing home sharing as an example, right? And it was not done before. But you had had the overall understanding of the travel industry, the customer, the regulation, et cetera, et cetera.

**中文翻译:**
是的。我认为决策方式是其中之一。另一个是在如此充满不确定性的行业中运作的理念。当我到 Airbnb 时，不确定性也很大，因为那是我们第一次做房屋共享，对吧？以前没人做过。但你对旅游业、客户、监管等有整体的了解。

---

### (00:47:33) Sanchan Saxena

**English:**
But I think [inaudible 00:47:35] is a very ridiculously new thing. People sometimes ask me what's the future of NFD, I say, "Ta-da! I don't know," I'll experiment, figure it out. I have an opinion. I'll take that opinion and start to execute against it, but nobody knows. How do you build conviction in a highly noisy world?

**中文翻译:**
但我认为（Web 3.0）是一个极其新鲜的事物。有时人们问我 NFT 的未来是什么，我说：“哒哒！我不知道。”我会去实验，去弄清楚。我有自己的看法，我会带着这个看法去执行，但没人真正知道答案。在一个高度嘈杂的世界里，你如何建立信念？

---

### (00:47:50) Sanchan Saxena

**English:**
I mean, Web 3.0, as you're probably on Twitter, everybody has an opinion on Twitter. X should do Y, and Y should do Z, and this is how it should be. Right?And the thing that I would take with me everywhere is, how do you build in that noise? How do you stay focused and still build what you believe is the right thing and still let the noise happen around you?

**中文翻译:**
我的意思是，Web 3.0 就像你在 Twitter 上看到的那样，每个人都有意见。某某应该做某事，某事应该这样做。我要带到任何地方的经验是：你如何在那种噪音中进行建设？你如何保持专注，坚持构建你认为正确的东西，同时任由噪音在周围回荡？

---

### (00:48:09) Sanchan Saxena

**English:**
And I think as Web 3.0 advances and every company becomes a Web 3.0 company, that's at least my prediction in this decade, just like every company became a mobile company, didn't have a mobile app, but became a mobile company, I think every company will become a Web 3.0 company. Everybody will have to build that muscle of operating in that level of ambiguity where there's literally no data and lot of noise.

**中文翻译:**
我认为随着 Web 3.0 的发展，每家公司都会变成 Web 3.0 公司，这至少是我对这十年的预测。就像每家公司都变成了移动公司一样（即使没有 App 也会受移动化影响），我认为每家公司都会变成 Web 3.0 公司。每个人都必须锻炼出在那种高度不确定性（几乎没有数据且充满噪音）中运作的肌肉。

---

### (00:48:28) Lenny

**English:**
Is there some way of operating at Coinbase that allows them to operate in this ambiguity and focus? Is there something that you've seen there?

**中文翻译:**
Coinbase 是否有某种运作方式，能让他们在这种不确定性中保持运作和专注？你观察到了什么吗？

---

### (00:48:36) Sanchan Saxena

**English:**
Yeah. I mean, we have our own flaws. I mean, no, company is perfect. We have our own flaws. But what we have figured out is how to operate, just the way I described before, which is a DRI mindset culture. Instead of having 15 people have 15 different perspectives, et cetera, it should all be amalgamated into one rapid.

**中文翻译:**
是的。我的意思是，我们也有自己的缺点，没有公司是完美的。但我们弄清楚了如何运作，就像我之前描述的那样，即 DRI 心态文化。与其让 15 个人有 15 种不同的观点，不如将它们全部合并到一个 RAPID 中。

---

### (00:48:51) Sanchan Saxena

**English:**
And we trust our leaders. We trust the DRI, whoever that DRI is, to make the decision. And then we start going towards the same direction. We ignore all the noise over there. Again, no company is perfect yet. We are still learning, but this is something I found to be very effective.

**中文翻译:**
我们信任我们的领导者。我们信任 DRI（无论他是谁）做出的决定。然后我们开始朝着同一个方向前进，忽略那里的所有噪音。再说一次，目前还没有公司是完美的，我们仍在学习，但我发现这非常有效。

---

### (00:49:03) Lenny

**English:**
On the thread of Web 3.0, if someone's thinking about like, "Should I get into a Web 3.0 sort of company? Should I not?" what sort of people do you find are most successful maybe on the product side specifically, but even broadly, folks that may enjoy the world of Web 3.0 and others that maybe not?

**中文翻译:**
顺着 Web 3.0 的话题，如果有人在想：“我该不该进入 Web 3.0 类型的公司？”你发现哪类人最容易成功（特别是在产品方面，但也包括更广泛的领域）？哪些人可能会喜欢 Web 3.0 的世界，而哪些人可能不会？

---

### (00:49:18) Sanchan Saxena

**English:**
Yeah, I think Web 3.0 is definitely at a stage right now where I'm seeing a lot of influx of people from Web 2.0 world. Literally, if I look at my LinkedIn post, there's somebody saying, "Ta-da! I left X and I'm joining a Web 3.0 company." So there's already.

**中文翻译:**
是的，我认为 Web 3.0 现在绝对处于一个阶段，我看到大量来自 Web 2.0 世界的人涌入。真的，如果我看我的 LinkedIn 动态，总有人在说：“哒哒！我离开了某某公司，加入了 Web 3.0 公司。”所以这种趋势已经存在了。

---

### (00:49:32) Lenny

**English:**
Or starters pivoting to Web 3.0 in your entire team.

**中文翻译:**
或者是整个初创团队转型做 Web 3.0。

---

### (00:49:35) Sanchan Saxena

**English:**
Exactly, starters pivoting to Web 3.0 as well. I feel like when I joined ... I mean, I joined very recently. I mean, not long time ago. When I joined, it was a very different conversation. I was still telling execs and others at Google and Facebook, "This is why you should join. This is what's happening," et cetera, but now I feel like the world is slightly different.

**中文翻译:**
没错，初创公司也在转向 Web 3.0。我觉得当我加入时……我是最近才加入的，没多久。当我加入时，对话还非常不同。我当时还在告诉谷歌和 Facebook 的高管们：“这就是你为什么要加入的原因，这就是正在发生的事情”等等。但现在我觉得世界已经稍微有些不同了。

---

### (00:49:52) Sanchan Saxena

**English:**
I think the people who will thrive or who thrive in Web 3.0 are people who truly are able to understand the potential and disregard the constraints of today. And here's what I mean by that. You all have seen articles written by really influential celebrities saying, "Web 3.0 sucks." And let me tell you why, because today sucks, right? We agree with the future principles of Web 3.0 of decentralization, this and that. But look at today, everything is centralized. Everything is blah, blah, blah.

**中文翻译:**
我认为能在 Web 3.0 中大展身手的人，是那些真正能够理解潜力并忽视当下约束的人。我的意思是：你们都见过一些极具影响力的名人写的文章说“Web 3.0 很烂”。让我告诉你为什么，因为“今天”确实很烂，对吧？我们认同 Web 3.0 关于去中心化之类的未来原则，但看看今天，一切都是中心化的，一切都是废话。

---

### (00:50:21) Sanchan Saxena

**English:**
I always remind those people as like the path to Web 3.0 goes, and from Web 2.0 to Web 3.0 goes through web 2.5. It doesn't go straight from Web 2.0 to Web 3.0. It goes through web 2.5. You got to go through that journey. And a lot of stuff that's happening in Web 3.0 today is web 2.5, 2.7 kind of. There's no truly decentralized stuff that is there, but the idealism is there. The closest thing is Ethereum probably, or Bitcoin.

**中文翻译:**
我总是提醒那些人，通往 Web 3.0 的道路，或者说从 Web 2.0 到 Web 3.0 的过程，必须经过“Web 2.5”。它不会直接跳过去。你必须经历这段旅程。今天 Web 3.0 发生的很多事情其实是 Web 2.5 或 2.7 级别的。目前还没有真正完全去中心化的东西，但理想主义在那儿。最接近的可能是以太坊或比特币。

---

### (00:50:42) Sanchan Saxena

**English:**
The idealism is there and we want to get to the towards that, right? The people who will thrive most are people who understand those ideals, understand the future and are builders. They want to take what it is today and then morph it into the ideals of tomorrow. I remember I'm a history buff and I love watching the history of technology.

**中文翻译:**
理想主义就在那里，我们想朝着它前进，对吧？最能成功的人是那些理解这些理想、理解未来并且是“建设者”的人。他们想把今天的东西转化成明天的理想。我记得我是一个历史迷，我喜欢看技术史。

---

### (00:51:02) Sanchan Saxena

**English:**
And there's a video on YouTube which describes someone playing with the internet back in 1986, '87, '89, right? And what you had to do was if I wanted to visit Lenny's website, here's what I'll do. I'll type 192. whatever the IP address was, and then I'm going to hit enter on a blue screen. And then there'll be things coming down and I'll pay $200 to just access his website.

**中文翻译:**
YouTube 上有个视频描述了人们在 1986、87、89 年玩互联网的情景。当时如果你想访问 Lenny 的网站，你得这么做：输入 192. 后面跟着一串 IP 地址，然后在蓝屏上按回车。接着会有东西慢慢加载出来，而你为了访问他的网站可能得付 200 美元。

---

### (00:51:23) Sanchan Saxena

**English:**
[inaudible 00:51:23] too, right? But if you can get past that and see that someday Lenny and I will actually have a podcast, video podcast or YouTube podcast over the internet, and we'll be able to see each other and record that shit, that is powerful. We are looking for people at this stage who believe in that journey.

**中文翻译:**
（当时也很烂）对吧？但如果你能看透这些，预见到有一天 Lenny 和我实际上会通过互联网做一个播客、视频播客或 YouTube 播客，我们能互相看见并录制下来，那就是力量所在。在这个阶段，我们寻找的是相信这段旅程的人。

---

### (00:51:43) Lenny

**English:**
I love that. And just the idea of hiring and joining company, I wanted to touch on hiring advice. You're really good at hiring. You've hired many people, you've interviewed tons and tons of PMs, and so I just wanted to touch on this before we wrap up.

**中文翻译:**
我喜欢这个观点。谈到招聘和加入公司，我想聊聊招聘建议。你非常擅长招聘，招过很多人，面试过无数的 PM。在结束之前，我想探讨一下这个话题。

---

### (00:51:56) Lenny

**English:**
I find that hiring and just finding people as maybe the single biggest pain point for companies these days and startups especially. Do you have any advice for our founders or product leaders or just leaders in general for hiring, including finding people and closing them, that kind of thing?

**中文翻译:**
我发现招聘和找人可能是当今公司（尤其是初创公司）最大的痛点。对于创始人、产品领导者或一般的领导者，你在招聘方面有什么建议吗？包括找人和最终“搞定”（closing）候选人。

---

### (00:52:10) Sanchan Saxena

**English:**
Yeah. I think maybe I can focus a little bit about what are some of the things that I believe are incredibly important for startups to get right when they're hiring. The couple of things to remember is that what really matters, what's highly code related to a startup success isn't that they used a process like scrum, like this, like that.

**中文翻译:**
好的。我想我可以重点谈谈我认为初创公司在招聘时必须做对的几件事。要记住的几点是：真正重要的、与初创公司成功高度相关的，并不是他们是否使用了 Scrum 之类的流程。

---

### (00:52:30) Sanchan Saxena

**English:**
Well, what's highly correlated is that somebody bloody knew what to do when. That is the most important thing. And I call that content. Content means what you do when. Process means how you do the thing that I just said. And I think there's a very easy love affection towards process.

**中文翻译:**
真正高度相关的是，有人真他妈知道什么时候该做什么。那是最重要的事。我称之为“内容”（content）。内容意味着你在什么时候做什么。流程（process）意味着你如何做我刚才说的那件事。我认为人们很容易对“流程”产生迷恋。

---

### (00:52:50) Sanchan Saxena

**English:**
And I think Reed Hastings has talked about this in their culture deck. Steve jobs has also talked about in the past is that, oftentimes we gravitate towards people who know how to avoid mistakes, who know how to create a process. Here's what a typical cycle is. You get bigger and bigger, you start making mistakes, you're like, "Oh, we got to create a process so we don't make the same mistake again."

**中文翻译:**
我想 Reed Hastings 在他们的文化手册中谈到过这一点，史蒂夫·乔布斯过去也谈过：我们往往倾向于那些知道如何避免错误、知道如何创建流程的人。典型的循环是这样的：你规模越来越大，开始犯错，然后你想：“噢，我们得建立一个流程，这样我们就不会再犯同样的错误了。”

---

### (00:53:07) Sanchan Saxena

**English:**
And next thing you know, over a period of time, the process becomes the product. Every morning you wake up, you look at your calendar, 80% of the time as an exec you are moving the process, you are managing the process, and that process becomes the product, and you lose sight of what the real product is, who your real customers are.

**中文翻译:**
接下来的事情你懂的，一段时间后，流程变成了产品。每天早上醒来，你看着日历，作为一名高管，你 80% 的时间都在推动流程、管理流程，流程成了产品，而你却忽视了真正的产品是什么，真正的客户是谁。

---

### (00:53:24) Sanchan Saxena

**English:**
My advice to people, especially in early stage startups is bring in people who know content and teach them process, as opposed to bringing in people who know process and trying to teach them content, because that's a bloody hard thing to do.

**中文翻译:**
我对人们（尤其是早期初创公司）的建议是：招那些懂“内容”的人，然后教他们流程；而不是招那些懂“流程”的人，然后试图教他们内容，因为那真他妈难。

---

### (00:53:36) Sanchan Saxena

**English:**
And this obsession about a lot of funders ask me when I consult with them is like, "Should we do scrum? Should we do X, Y, Z process?" I'm like, "You can do whatever you want. It doesn't matter. You can try any of those things. It will not be correlated to your success." And maybe to some degree, but not a lot of degree.

**中文翻译:**
很多创始人在咨询我时会纠结：“我们该用 Scrum 吗？该用某某流程吗？”我会说：“你想怎么做都行，这不重要。你可以尝试任何一种，它们与你的成功并不相关。”也许有一定程度相关，但程度不高。

---

### (00:53:52) Sanchan Saxena

**English:**
What you really need to figure out is, who do you hire, who can actually understand what the content of your product is, what the content of your customers is? How do you win in that industry that you're operating in? And make sure that you stay obsessed over there, right, as opposed to the process. This is something that Brian Chesky has grilled in me.

**中文翻译:**
你真正需要弄清楚的是：你招的人是否真的理解你产品的“内容”、你客户的“内容”？你如何在所处的行业中获胜？确保你对这些保持痴迷，而不是对流程痴迷。这是 Brian Chesky 灌输给我的理念。

---

### (00:54:09) Sanchan Saxena

**English:**
Hire executives who know how to execute. And his idea was, let's say Sanchan's entire team disappears, and then I go to Brian and say, "Hey, Brian, I got to hire this organization, I got to hire these people, and then I'll tell you what to build, or I'll then build." Right? Now I should be able to then crawl up my sleeve, if I'm a content kind of a leader, and I should do exactly what my team did.

**中文翻译:**
招聘那些懂得如何执行的高管。他的想法是，假设 Sanchan 的整个团队都消失了，然后我去找 Brian 说：“嘿 Brian，我得重新组建这个组织，招这些人，然后我再告诉你该建什么，或者我再去建。”对吧？如果我是一个“内容型”领导者，我现在应该能卷起袖子，去做我团队之前做的所有事情。

---

### (00:54:29) Sanchan Saxena

**English:**
Maybe not with the same capacity, because if I have so many people team, I can't do so many people worth of work. But at least be able to tell you, "This is what we should build. This is when we should build. This is how we should build." Right? I shouldn't be a leader who just delegates to the extent that I forgot what content is, right? And that is a very important piece.

**中文翻译:**
也许产出量没那么大，因为如果我有一个庞大的团队，我一个人干不了那么多人的活。但至少我能告诉你：“这是我们该建的东西，这是该建的时间，这是该建的方式。”对吧？我不应该是一个只会授权，授到最后连“内容”是什么都忘了的领导者。这是非常重要的一点。

---

### (00:54:46) Lenny

**English:**
When you're looking for a leader like that, because that sounds amazing, what do you look for? How do you know if there's that sort of leader when you're interviewing or just kind of evaluating?

**中文翻译:**
当你寻找那样的领导者时（因为听起来很棒），你会看重什么？在面试或评估时，你如何判断对方是否是那种领导者？

---

### (00:54:55) Sanchan Saxena

**English:**
One of the things we did at Airbnb, because this was the thesis that we had over there, we actually changed our interview process around this. We will give people a work challenge. You're very familiar with that. Most people say, "Come and do a presentation." No, we actually gave you a work challenge.

**中文翻译:**
我们在 Airbnb 做的一件事是（因为那是我们的核心论点），我们围绕这一点改变了面试流程。我们会给候选人一个“工作挑战”。你对此很熟悉。大多数公司会说：“来做个演讲吧。”不，我们是真的给你一个实际的工作挑战。

---

### (00:55:08) Sanchan Saxena

**English:**
We said, "This is the problem you're facing. How are you going to solve it?" Right. We're facing Airbnb Plus problem, we need to build millions of homes that are Airbnb Plus, but we don't know how to do that. What would you do? And we want to see the depth of thinking. They don't know the right answer because they don't have the right data. That's okay. Right?

**中文翻译:**
我们会说：“这是你面临的问题，你打算怎么解决？”比如：“我们面临 Airbnb Plus 的问题，我们需要打造数百万间 Airbnb Plus 房屋，但我们不知道该怎么做。你会怎么做？”我们想看思考的深度。他们不知道正确答案，因为没有正确的数据，这没关系。对吧？

---

### (00:55:24) Sanchan Saxena

**English:**
But they at least need to show us how they approach the problem. What are they going to do? And they need to show us the content of how they're going to do. Some people will come in and say, and have seen slides in those presentation, they'll come in and say, "Here's my process. Ideation, execution, iteration." That's okay. I want to know what you're going to do inside of ideation.

**中文翻译:**
但他们至少需要向我们展示他们如何处理问题。他们打算做什么？他们需要向我们展示他们行动的“内容”。有些人会来展示 PPT，说：“这是我的流程：构思、执行、迭代。”这没问题，但我更想知道你在“构思”阶段具体会做什么。

---

### (00:55:42) Sanchan Saxena

**English:**
Some execs will come in presenter say, "Well, the first thing I'm going to do is go out there and figure out are their third party companies who can actually scale my operations without building it in now." That is content, right? And I want to evaluate that.

**中文翻译:**
有些高管会来陈述说：“好吧，我要做的第一件事是去弄清楚是否有第三方公司可以在不依赖内部建设的情况下扩展我的运营。”这就是“内容”，对吧？这就是我想评估的东西。

---

### (00:56:11) Sanchan Saxena

**English:**
The second thing we will do is in our interview process as well, if it's an exec, Brian will spend time and I will spend time, anybody else will spend time, we will focus on whatever you did in the past, tell me the role that you played in that versus telling me everything that your team did. Right? To be precise, the role you played.

**中文翻译:**
我们要做的第二件事也是在面试流程中，如果是高管，Brian、我或者其他人都会花时间去关注你过去所做的事情。告诉我你在其中扮演的角色，而不是告诉我你团队做的所有事情。对，要精确到你扮演的角色。

---

### (00:56:11) Sanchan Saxena

**English:**
And this is something I tell a lot of my folks at Coinbase as well is like, you got to be able to bring things to me, escalate to me when you need my help and let me help you be successful. My role is such that I have a large team and I can't do everything. But what I can do is set them up for success. How? Of course, the tactical supply of resources.

**中文翻译:**
这也是我对 Coinbase 的很多同事说的话：你必须能够把事情带给我，当你需要帮助时向我汇报（escalate），让我帮你获得成功。我的角色决定了我有一个庞大的团队，我无法亲力亲为每一件事。但我能做的是为他们的成功铺路。怎么做？当然包括战术上的资源供应。

---

### (00:56:32) Sanchan Saxena

**English:**
But more importantly, when we are thinking about the content, when we think about what to do, when to do, how to do it, let's sit together and think about that. Escalate to me, bring things to me. I will go into the mud with you and I'll create that clay for you, with you. And that is how I stay relevant. But more importantly, that is the value that I get to help my team succeed as well.

**中文翻译:**
但更重要的是，当我们思考“内容”时，当我们思考做什么、什么时候做、怎么做时，让我们坐下来一起思考。向我汇报，把问题带给我。我会和你一起跳进泥潭，和你一起捏泥巴。这就是我保持敏锐的方式。但更重要的是，这也是我帮助团队成功的价值所在。

---

### (00:56:51) Lenny

**English:**
I love that. I was just thinking that the fact that you call kind of the roadmap and the plan like a content, that makes you a content creator, and how does that feel?

**中文翻译:**
我喜欢这个。我刚才在想，你把路线图和计划称为“内容”，这让你成了一名“内容创作者”，感觉如何？

---

### (00:57:00) Sanchan Saxena

**English:**
Yes, that does feel good. I mean, you should have the ability to create a roadmap and that is your creating content around that. But the thing that I want to make sure people understand is that the format of that roadmap doesn't matter. Whether you use Excel, or this, or that, it doesn't matter. That process doesn't matter.

**中文翻译:**
是的，感觉确实不错。我的意思是，你应该有能力制定路线图，那就是在围绕它创造内容。但我想要确保人们理解的是，路线图的格式并不重要。无论你用 Excel 还是别的什么，都不重要。那个流程不重要。

---

### (00:57:15) Sanchan Saxena

**English:**
What matters is that you were able to come up with the right roadmap, which is what you're going to build, at what time you're going to build. And that is a core value set of an individual or a leader that you should absolutely look for.

**中文翻译:**
重要的是你能制定出正确的路线图，即你要建什么、什么时候建。这是一个个人或领导者绝对应该具备的核心价值，也是你应该寻找的特质。

---

### (00:57:26) Sanchan Saxena

**English:**
And so otherwise, my prediction is four or five years later or whatever the time is, that company will start to attract process people, and next thing you know, everybody in the company is a process person and nobody is a content person.

**中文翻译:**
否则，我的预测是，四五年后或者不管多久，那家公司就会开始吸引“流程型”人才。接下来的事你懂的，公司里的每个人都是流程专家，却没人懂内容。

---

### (00:57:38) Sanchan Saxena

**English:**
And then what hands up happening is the founder ends up taking that burden of becoming the content person, and next thing you know, they can't scale. They just cannot scale. The company cannot scale.

**中文翻译:**
然后结果就是，创始人最终不得不承担起成为唯一“内容人”的重担。接下来的事你懂的，他们无法扩展。他们就是无法扩展，公司也无法规模化。

---

### (00:57:47) Lenny

**English:**
Yeah, because process eventually just kind of starts to break down.

**中文翻译:**
是的，因为流程最终只会开始崩塌。

---

### (00:57:50) Sanchan Saxena

**English:**
Exactly. There's a very good deck. I'll encourage your audience to watch the Netflix Culture Deck. And Reed Hastings talks about this at length, better than I did. And it's a beautiful concept, it's a beautiful argument, and I think I will encourage every follower to start looking for that.

**中文翻译:**
没错。有一份非常棒的 PPT，我鼓励听众去看看《Netflix 文化手册》。Reed Hastings 对此有详尽的论述，比我讲得好。这是一个美妙的概念，一个精彩的论点，我鼓励每一位关注者都去了解一下。

---

### (00:58:04) Sanchan Saxena

**English:**
And again, I'm not saying process shouldn't exist. You absolutely need some process. That's why you can scale. You can't scale without some process as well. But process is not the answer. Content is the answer.

**中文翻译:**
再说一次，我不是说流程不应该存在。你绝对需要一些流程，那是你能规模化的原因。没有流程你也无法规模化。但流程不是答案，“内容”才是答案。

---

### (00:58:13) Lenny

**English:**
I feel like I've taken enough of your time. And so we've gotten to the final part of our chat, which is the lightning round, where I'm going to ask you a few questions and then just tell me what first thing that comes to mind. If nothing comes to mind, that's totally cool too. Does that sound good?

**中文翻译:**
我觉得我已经占用了你够多时间了。现在进入我们聊天的最后一部分，也就是“闪电轮问答”。我会问你几个问题，你只需告诉我脑海中浮现的第一反应。如果没反应也没关系。听起来怎么样？

---

### (00:58:27) Sanchan Saxena

**English:**
Yeah, that sounds great, man.

**中文翻译:**
太棒了，伙计。

---

### (00:58:28) Lenny

**English:**
Okay. What's a book that you recommend most to other product leaders?

**中文翻译:**
好的。你最推荐给其他产品领导者的一本书是什么？

---

### (00:58:33) Sanchan Saxena

**English:**
Two books come to mind. One is The Little Bets, which is how you live your life and how you build businesses with little bets. And the other thing I would say The Innovator's Dilemma. Those are two of my favorite books and highly recommend everybody reading those.

**中文翻译:**
我脑海中浮现出两本书。一本是《小赌注》（The Little Bets），讲的是如何通过小赌注来生活和创业。另一本是《创新者的窘境》（The Innovator's Dilemma）。这是我最喜欢的两本书，强烈推荐大家阅读。

---

### (00:58:46) Lenny

**English:**
Awesome. What's a company that you recommend most to PMs that are looking for a new job other than Coinbase?

**中文翻译:**
太棒了。除了 Coinbase，你最推荐想找新工作的 PM 去哪家公司？

---

### (00:58:53) Sanchan Saxena

**English:**
Yeah. I mean, I think there are tons of Web 3.0 companies or tons of other companies. I would say amongst the companies [inaudible 00:58:58], the insights say where it is. I think Airbnb is a great company. People should definitely look at that company. It is once in a lifetime kind of a company as well, and people will enjoy working over there.

**中文翻译:**
是的。我的意思是，有很多 Web 3.0 公司或其他公司。我会说，根据内部洞察，Airbnb 是一家伟大的公司。人们绝对应该关注那家公司。它也是那种一生难遇的公司，人们会喜欢在那里工作的。

---

### (00:59:07) Lenny

**English:**
Agreed. What's your favorite app right now?

**中文翻译:**
同意。你现在最喜欢的 App 是什么？

---

### (00:59:09) Sanchan Saxena

**English:**
My favorite app right now, Coinbase NFT.

**中文翻译:**
我现在最喜欢的 App 是 Coinbase NFT。

---

### (00:59:13) Lenny

**English:**
Shit, I should have said other than Coinbase. All right, you get that.

**中文翻译:**
该死，我应该说“除了 Coinbase 以外”的。好吧，算你赢。

---

### (00:59:16) Sanchan Saxena

**English:**
I would say I love TikTok. I am on TikTok all the time. I love how entertaining it is. I love how simple it is. I'm on TikTok all the time.

**中文翻译:**
我会说我喜欢 TikTok。我一直在刷 TikTok。我喜欢它的娱乐性，喜欢它的简洁。我总是泡在上面。

---

### (00:59:27) Lenny

**English:**
Same. We're in trouble. Who is your favorite manager that you had?

**中文翻译:**
我也一样，我们都有麻烦了（刷太久）。你遇到过的最喜欢的经理是谁？

---

### (00:59:31) Sanchan Saxena

**English:**
Oh, my favorite manager. It was my first manager. His name is Sashi. He was at Microsoft. And he fundamentally helped change the trajectory of my life. He believed in me. And I was just out of college at that time. And he invested in me. The most important thing was he invested in me. If any successful person you meet in your life, one thing they will all tell you is at some point in their life, somebody believed in them and somebody invested in them, and that was that manager.

**中文翻译:**
噢，我最喜欢的经理。那是我的第一任经理，他叫 Sashi，当时在微软。他从根本上改变了我的人生轨迹。他相信我，而我当时刚大学毕业。他投资了我。最重要的一点是他投资了我。如果你在生活中遇到任何成功人士，他们都会告诉你一件事：在他们生命的某个时刻，有人相信他们并投资了他们。对我来说，那个经理就是那个人。

---

### (00:59:54) Lenny

**English:**
Amazing. And then finally, what's a favorite interview question that you like to use?

**中文翻译:**
太棒了。最后，你最喜欢用的面试问题是什么？

---

### (00:59:59) Sanchan Saxena

**English:**
Tell me the story of your career and focus more on why you did what you did. And I ask this question because the resume is full of polished shit. It's like, "Oh, I did this. I did this." Right? I want to hear the story. And tell me why you did what you did. And that tells me a lot about the person when they're answering the question, not the what. Because I can see that on the LinkedIn or the resume, but why, why they chose to do what they chose to do.

**中文翻译:**
“请讲讲你的职业故事，重点放在你为什么做那些决定上。”我问这个问题是因为简历上全是修饰过的废话，比如“哦，我做了这个，我做了那个”。我想听故事，告诉我你为什么这么做。当候选人回答这个问题时，这能让我了解很多关于这个人的信息，而不是关于他做了什么。因为“做了什么”我在 LinkedIn 或简历上就能看到，但“为什么”——他们为什么选择做那些事——才是关键。

---

### (01:00:23) Lenny

**English:**
I love that. Where can folks find you online, and then how can listeners be helpful to you?

**中文翻译:**
我喜欢这个。大家可以在哪里找到你？听众能为你提供什么帮助吗？

---

### (01:00:27) Sanchan Saxena

**English:**
Yeah. I mean, I'm pretty active on Twitter. Now that you know, I'm also active on TikTok. But Twitter is probably the best place to follow me. And yeah, if you have any suggestion, anything you want to chat about, send me a message on Twitter, DM me, or LinkedIn. One of those places and I'll be happy to chat with you.

**中文翻译:**
是的。我在 Twitter 上很活跃。现在你知道了，我也玩 TikTok。但 Twitter 可能是关注我的最佳地点。如果你有任何建议，或者想聊聊任何事情，可以在 Twitter 上给我发消息、私信我，或者在 LinkedIn 上找我。在这些地方我都很乐意和你交流。

---

### (01:00:43) Lenny

**English:**
And I imagine folks should check out Coinbase NFT and Coinbase Wallet?

**中文翻译:**
我想大家也应该去看看 Coinbase NFT 和 Coinbase 钱包？

---

### (01:00:47) Sanchan Saxena

**English:**
Absolutely, man.

**中文翻译:**
绝对的，伙计。

---

### (01:00:48) Lenny

**English:**
How do people find that?

**中文翻译:**
大家怎么找到它们？

---

### (01:00:50) Sanchan Saxena

**English:**
Nft.coinbase.com. Give it a shot and let us know what you think.

**中文翻译:**
Nft.coinbase.com。去试试吧，告诉我们你的想法。

---

### (01:00:52) Lenny

**English:**
Amazing. Thank you so much, Sanchan, for being here. This was amazing.

**中文翻译:**
太棒了。非常感谢你，Sanchan。这次对话太精彩了。

---

### (01:00:55) Sanchan Saxena

**English:**
Thank you, Lenny, for having me.

**中文翻译:**
谢谢你，Lenny，邀请我。

---

### (01:00:58) Lenny

**English:**
That was awesome. Thank you for listening. If you enjoyed the chat, don't forget to subscribe to the podcast. You could also learn more at Lennyspodcast.com. I'll see you in the next episode.

**中文翻译:**
太棒了。感谢大家的收听。如果你喜欢这次聊天，别忘了订阅本播客。你也可以在 Lennyspodcast.com 了解更多信息。我们下期再见。