# Scott Belsky - Lenny's Podcast

---

# Scott Belsky - Lenny's Podcast 深度解析报告

---

## 🎙️ 主持人介绍

**Lenny Rachitsky**
- **身份**: 前 Airbnb 产品负责人，全球顶级产品管理专家。
- **背景**: 在 Airbnb 工作 7 年，见证了平台从初创到全球巨头的过程。
- **现状**: 运营全球排名第一的产品类 Newsletter《Lenny's Newsletter》（拥有 60万+ 订阅者）和同名顶级播客。
- **社交媒体**:
  - Twitter/X: [@lennysan](https://twitter.com/lennysan)
  - Newsletter: [Lenny's Newsletter](https://www.lennysnewsletter.com/)
  - Podcast: [Lenny's Podcast](https://www.lennyspodcast.com/)

---

## 🎤 嘉宾介绍

**Scott Belsky**
- **身份**: Adobe 首席战略官 (CSO) 兼设计与新兴产品执行副总裁，Behance 创始人。
- **职业经历**:
  - **Behance** - 创始人兼 CEO (2006 - 2012)，后被 Adobe 收购。
  - **Benchmark** - 风险合伙人 (2016 - 2017)。
  - **Adobe** - 曾任首席产品官 (CPO)，现任首席战略官。
- **核心专长**: 产品心理学、创意工作流优化、早期风险投资、组织设计。
- **社交媒体**:
  - Twitter/X: [@scottbelsky](https://twitter.com/scottbelsky)
  - LinkedIn: [Scott Belsky](https://www.linkedin.com/in/scottbelsky/)
  - Newsletter: [Implications](https://www.implications.com/)
  - 著作: 《乱中求胜》(The Messy Middle)

---

## 📝 内容概要

本期访谈中，Scott Belsky 分享了他对产品感（Product Sense）、创业心理学以及 AI 如何重塑产品开发流程的深刻见解。他提出了著名的“第一英里”（First Mile）理论，强调用户在最初 30 秒内的“懒惰、虚荣和自私”。此外，他详细讨论了如何在资源受限的环境下通过“砍掉一半功能”来提升核心指标，以及 AI 如何通过“折叠技术栈”让产品经理和设计师探索更广阔的创意空间。这不仅是一场关于产品的对话，更是一场关于人类心理与技术演进的深度思辨。

---

## 🏷️ 核心话题

`产品感` `第一英里` `AI 变革` `创业心态` `极简主义` `用户心理学`

---

## 💡 核心论点

### 论点一：产品感本质上是人类心理学

**核心观点**: 优秀的产品经理不应迷恋解决方案，而应深度共情用户的痛苦。

- **用户本性**: 在接触新产品的前 30 秒，用户是“懒惰、虚荣且自私”的。他们不想学习，只想立即看起来很棒并获得成功感。
- **第一英里 (First Mile)**: 团队往往把最后的时间花在打磨功能，却忽视了用户最初的 30 秒体验（引导、默认设置、定位感）。

> "In the first 30 seconds of using a new product, you are lazy, vain, and selfish."
> — Scott Belsky

### 论点二：通过“减法”实现增长（Half-Half 规则）

**核心观点**: 减少选项和功能往往能显著提升核心业务指标。

- **优化你“想要”的问题**: 不要为了防止用户流失而堆砌功能，要优化到让用户因为喜欢你的核心功能而向你索要更多。
- **杀掉功能**: Scott 分享了在 Behance 早期通过砍掉“小贴士交换”和“群组”功能，反而让核心指标（项目发布量）增长了 10 倍的案例。

### 论点三：AI 正在“折叠”组织技术栈

**核心观点**: AI 将消除职能间的壁垒，让个人拥有跨领域的“超级权力”。

- **探索空间**: AI 不会取代创意，但会极大增加“探索表面积”。PM 可以利用 AI 快速生成 5 个方案，即使不直接使用，也能通过排除法找到最优解。
- **黄金直觉 (Golden Gut)**: 随着 AI 承担了重复性劳动，产品领导者的核心价值将转向基于心理学和经验的“直觉决策”。

---

## ✅ 数据验证结果

**验证项 1**: IBM 首席执行官称 AI 将取代 8,000 个岗位。
- 原文声称: "IBM 负责人宣布他将不再雇佣原本要雇佣的 8,000 人，因为 AI 可以完成这些工作。"
- 验证结果: ✅ 确认
- 来源: [Bloomberg (2023年5月报道)](https://www.bloomberg.com/news/articles/2023-05-01/ibm-to-pause-hiring-for-back-office-jobs-that-ai-could-kill)
- 可信度: ⭐⭐⭐

**验证项 2**: 100 多年前人类的预期寿命仅为 25 岁。
- 原文声称: "100 多年前人类的预期寿命是 25 岁。"
- 验证结果: ⚠️ 存疑（数据略有偏差）
- 来源: [Our World in Data](https://ourworldindata.org/life-expectancy)
- 分析: 1900 年全球平均寿命约为 31-32 岁。虽然 Scott 的具体数字略低，但他关于“人类生物本能追求短期反馈”的逻辑在进化心理学上是成立的。
- 可信度: ⭐⭐

**验证项 3**: Vinod Khosla 预测 AI 将取代 80% 的工作。
- 原文声称: "Vinod Khosla 预测 80% 的工作中 80% 的内容将被 AI 取代。"
- 验证结果: ✅ 确认
- 来源: [Khosla Ventures - AI's Impact on Work](https://www.khoslaventures.com/ai-and-the-future-of-work/)
- 可信度: ⭐⭐⭐

---

## 🎯 四维分类评估

### 🟢 高度正确（已验证）

**观点 1**: 第一英里（Onboarding）对留存至关重要。
- 依据: 行业公认准则，留存曲线的斜率通常在第一天就已决定。

**观点 2**: 资源匮乏（Resourcefulness）比资源（Resources）更能激发创新。
- 依据: 经典的“精益创业”理论及 Adobe 自身转型的成功实践。

### 🔵 当下可执行（有明确步骤）

**建议 1**: 创业信念测试。
- 执行方法: 问自己“如果已知现在的所有信息，我还会开始吗？”如果答案是否定的，立即转型或停止。

**建议 2**: 产品的“三问”审计。
- 执行方法: 在任何页面问自己：我怎么到这的？我现在要做什么？我下一步要去哪？

### 🟡 理智质疑（需验证）

**存疑点**: AI 真的能让 PM 完全取代数据分析师吗？
- 质疑原因: AI 目前在处理复杂、特定业务逻辑的数据时仍存在“幻觉”风险，完全脱离专家可能导致决策偏差。

### 🔴 需警惕（风险点）

**风险点**: 过度简化的“砍功能”策略。
- 风险说明: 对于 B2B 软件，某些低频功能可能是大客户签约的硬性要求（Checklist），盲目砍掉可能导致大客户流失。

---

## 🔑 关键洞察

1. **心理学 > 技术**: 产品的胜出往往不是因为技术更先进，而是因为它更顺应人类的原始本能（懒惰、虚荣）。
2. **惊喜的力量**: 用户不会传播“符合预期”的产品，只会传播“超出预期”或有“魔术感”的产品（如 Tesla 的彩蛋）。
3. **资源作为肌肉**: 资源是碳水（短期供能），资源感是肌肉（长期能力）。在经济下行期，锻炼“资源感”是团队的核心竞争力。
4. **AI 扩大探索面**: AI 的价值不在于给出最终答案，而在于将原本需要几周的方案探索缩短至几秒，从而让 PM 有更多机会找到那个“例外”。
5. **管理者的叙事职责**: 在“混乱的中期”，领导者的任务是向坐在“黑窗后座”的团队成员不断播报进度，防止他们因看不到终点而崩溃。

---

## 🛠️ 提到的工具/资源

**工具 1**: **Adobe Express / Firefly**
- 说明: Adobe 推出的生成式 AI 创意工具，旨在降低创作门槛。
- 链接: [Adobe Firefly](https://www.adobe.com/sensei/generative-ai/firefly.html)

**工具 2**: **Tome**
- 说明: Scott 投资的 AI 演示文稿工具，可根据叙述自动生成 PPT 框架。
- 链接: [Tome.app](https://tome.app/)

**工具 3**: **Queue**
- 说明: 跨平台的流媒体内容清单管理工具。
- 链接: [Queue.co](https://www.queue.co/)

**推荐阅读**: **《Build》- Tony Fadell**
- 说明: Scott 极力推荐的产品实战书籍，由 iPod 之父撰写。
- 链接: [Amazon](https://www.amazon.com/Build-Unorthodox-Guide-Making-Things/dp/0063046067)

---

## 📋 行动建议

### 🚀 立即可做（今天）
- [ ] **第一英里审计**: 亲自走一遍自己产品的注册流程，记录下每一个让你感到“费劲”或“无聊”的瞬间。
- [ ] **三问测试**: 打开产品最核心的三个页面，检查是否能清晰回答“我从哪来、我在干嘛、我去哪”。

### 📅 本周尝试
- [ ] **功能杀手清单**: 列出产品中用户使用率最低的 20% 功能，评估如果下周关掉它们，核心指标会发生什么变化。
- [ ] **AI 辅助探索**: 尝试用 ChatGPT 或 Claude 针对你正在策划的一个功能生成 5 个不同的交互方案。

### 🔍 深入探索
- [ ] **订阅 Implications**: 阅读 Scott 关于 AI 长期影响的深度思考。
- [ ] **研究“黄金直觉”**: 观察团队中资深 PM 的决策逻辑，分析他们是如何平衡数据与心理直觉的。

---

## ⭐ 评分

**知识价值**: 9.5/10
- 提供了极高维度的产品哲学和心理学框架。

**可执行性**: 8.5/10
- 无论是“第一英里”还是“三问测试”，都有极强的落地性。

**商业潜力**: 9.0/10
- 对 AI 时代的组织变革提供了前瞻性的指导。

**投入产出比**: 10/10
- 1 小时的对话涵盖了 Scott 20 年的创业与管理精华。

**综合评分**: **9.3/10**

---

## 📚 参考来源

- [Lenny's Podcast Official](https://www.lennyspodcast.com/scott-belsky-on-building-product-sense-the-messy-middle-and-how-ai-will-transform-product-management/)
- [Scott Belsky's Blog](https://www.scottbelsky.com/)
- [Adobe Strategy Updates](https://www.adobe.com/investor-relations.html)

---
*来源*: Lenny's Podcast
*嘉宾*: Scott Belsky
*生成时间*: 2024-05-20