# Scott Belsky - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Scott Belsky.

---

### [00:00:00] Scott Belsky

**English:**
Yeah. I've had this conversation quite a few times over the years with founders and friends who were running a company going sideways or worse and have had this question, "Should I continue or not?" I always have the same answer. I basically say, "How much conviction do you have in the solution you're building?" I know in the beginning, before you knew all you know now, you had tons of conviction. That's what caused you to leave your job. Now knowing all you know, do you have more or less conviction in the problem and the solution you're building?

**中文翻译:**
是的。这些年来，我曾多次与那些公司经营不善甚至陷入困境的创始人和朋友交流，他们总会问：“我该不该继续下去？”我的回答总是一样的。我基本上会说：“你对你正在构建的解决方案有多少信念（Conviction）？”我知道在刚开始的时候，在你还没了解到现在的这些情况之前，你充满了信念，那是让你辞掉工作的原因。现在，在了解了所有情况之后，你对这个痛点和你正在构建的解决方案，信念是增加了还是减少了？

---

### [00:00:31] Scott Belsky

**English:**
And I'll tell you, I get different answers. Some people are like, "Oh, Scott, I mean, I have more conviction. All that I've learned, all the validation I've received from customers, we just haven't figured it out yet. It's driving me crazy. We've tried three times, and it's still like each product fails. But I have more conviction than ever before." And for those people, I'm like, "You know what? You're just in the messy middle. Stick with it. This is par for the course." But oftentimes, I'll hear, "Honestly, if I knew then what I know now, I would not have done this. Holy shit."

**中文翻译:**
我会告诉你，我得到的答案各不相同。有些人会说：“噢，Scott，我的信念更强了。基于我学到的一切，以及从客户那里得到的验证，我们只是还没完全搞定。这快让我疯了。我们尝试了三次，每次产品都失败了，但我比以往任何时候都更有信心。”对于这些人，我会说：“你知道吗？你只是处在‘混乱的中期’（Messy Middle）。坚持下去，这是必经之路。”但通常，我也会听到：“老实说，如果我当时知道现在这些情况，我根本不会开始。天哪。”

---

### [00:01:01] Scott Belsky

**English:**
I'm like, "Then, quit. Your life is short. You have a great team. Pivot. Do something completely different." If you've lost conviction, you should not be doing what you're doing in the world of entrepreneurship.

**中文翻译:**
我会说：“那就放弃吧。人生苦短。你有一个优秀的团队，转型（Pivot）吧，去做完全不同的事情。”如果你失去了信念，你就不应该在创业的世界里继续做你现在正在做的事。

---

### [00:01:15] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today, my guest is Scott Belsky. Scott is an absolute product legend. He's a former founder, starting a company called Behance that he sold to Adobe where he worked up the ranks to chief product officer, and more recently, to chief strategy officer and executive vice president of design and emerging products. He's also an author of the beloved book, The Messy Middle. He's also an angel investor in companies like Pinterest, Uber, Airtable, Flexport, Warby Parker, and many more.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我采访世界级的产品领导者和增长专家，学习他们在构建和发展当今最成功产品过程中获得的宝贵经验。今天，我的嘉宾是 Scott Belsky。Scott 是绝对的产品界传奇。他曾是一位创始人，创办了 Behance 并将其卖给了 Adobe。在 Adobe，他一路晋升至首席产品官（CPO），最近担任首席战略官兼设计与新兴产品执行副总裁。他还是备受推崇的著作《混乱的中期》（The Messy Middle）的作者。他也是一位天使投资人，投资了 Pinterest、Uber、Airtable、Flexport、Warby Parker 等众多公司。

---

### [00:01:53] Lenny

**English:**
In our wide-ranging conversation, Scott shares his advice on how to build product sense, why you should only build half the features that you want, what it takes to build a successful consumer product. And we spend a lot of time on how AI is likely to change the world of product and the world broadly. Scott is such an insightful and articulate thinker, and I learned a lot from this conversation. With that, I bring you Scott Belsky after a short word from our sponsors.

**中文翻译:**
在我们广泛的交流中，Scott 分享了关于如何培养产品感（Product Sense）、为什么你应该只构建一半你想要的特性、以及打造成功的消费级产品需要什么。我们还花了大量时间讨论 AI 将如何改变产品界乃至整个世界。Scott 是一位非常有洞察力且表达清晰的思考者，我从这次对话中学到了很多。在听完赞助商的简短介绍后，让我们欢迎 Scott Belsky。

---

### [00:02:21] Lenny (Sponsor Ad: Braintrust)

**English:**
This episode is brought to you by Braintrust, where the world's most innovative companies go to find talent fast so that they can innovate faster. Let's be honest, it's a lot of work to build a company. And if you want to stay ahead of the game, you need to be able to hire the right talent quickly and confidently. Braintrust is the first decentralized talent network where you can find, hire and manage high quality contractors in engineering, design, and product for a fraction of the cost of agencies.

**中文翻译:**
本集节目由 Braintrust 赞助。全球最具创新力的公司都在这里快速寻找人才，以便更快地进行创新。坦白说，创办一家公司需要做大量工作。如果你想保持领先，你需要能够快速且自信地聘请到合适的人才。Braintrust 是首个去中心化的人才网络，你可以在这里找到、聘请并管理工程、设计和产品领域的高质量承包商，而成本仅为中介机构的一小部分。

---

### [00:02:48] Lenny (Sponsor Ad: Braintrust)

**English:**
Braintrust charges a flat rate of only 10%, unlike agency fees of up to 70% so you can make your budget go four times further. Plus, they're the only network that takes 0% of what the talent makes, so they're able to attract and retain the world's best tech talent. Take it from DoorDash, Airbnb, Plaid, and hundreds of other high growth startups that have shaved their hiring process from months to weeks at less than a quarter of the cost by hiring through Braintrust network of 20,000 high quality vetted candidates ready to work. Whether you're looking to fill in gaps, upskill your staff, or build a team for that dream project that finally got funded, contact Braintrust, and you'll get matched with three candidates in just 48 hours. Visit usebraintrust.com/lenny.

**中文翻译:**
Braintrust 仅收取 10% 的固定费用，而不像中介机构那样收取高达 70% 的费用，因此你可以让预算发挥四倍的作用。此外，他们是唯一一个不从人才收入中抽成的网络，因此能够吸引并留住全球顶尖的科技人才。DoorDash、Airbnb、Plaid 以及数百家其他高增长初创公司都通过 Braintrust 拥有 20,000 名高质量、经过审核的候选人网络，将招聘流程从几个月缩短到几周，成本不到四分之一。无论你是想填补空缺、提升员工技能，还是为终于获得资金的梦想项目组建团队，请联系 Braintrust，你将在 48 小时内匹配到三名候选人。请访问 usebraintrust.com/lenny。

---

### [00:03:38] Lenny (Sponsor Ad: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums from modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential. But there are no commercial tools that integrate with a modern growth team stack. This leads to waste of time building internal tools or trying to run your own experiments through a clunky marketing tool.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。DraftKings、Zapier、ClickUp、Twitch 和 Cameo 等公司都依赖 Eppo 来支持他们的实验。无论你在哪里工作，进行实验都变得越来越重要。但目前还没有商业工具能与现代增长团队的技术栈无缝集成。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具来运行实验。

---

### [00:04:25] Lenny (Sponsor Ad: Eppo)

**English:**
Eppo lets you go beyond basically through metrics and instead use your north star metrics like activation, retention, subscription and payments. Eppo supports test on the front end, on the back end, email marketing, even machine learning plans. Check out Eppo at getE-P-P-O.com. That's geteppo.com, and 10X your experiment velocity. Scott, welcome to the podcast.

**中文翻译:**
Eppo 让你能够超越基础指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习方案的测试。请访问 getE-P-P-O.com 查看 Eppo。即 geteppo.com，让你的实验速度提升 10 倍。Scott，欢迎来到播客。

---

### [00:04:52] Scott Belsky

**English:**
Hey, Lenny. And it's great to be here.

**中文翻译:**
嘿，Lenny。很高兴来到这里。

---

### [00:04:55] Lenny

**English:**
I don't know if you know this, but it's been a big goal of mine to get you on this podcast since the day I launched it. And so, I'm really excited that you're here. I wanted to start with your role at Adobe. So for the longest time, you're a chief product officer at Adobe. And then recently, I noticed you shifted to this very complicated sounding role. I'm curious what this new role is and then why you made that shift.

**中文翻译:**
我不知道你是否知道，但自从我创办这个播客的那天起，邀请你来就是我的一个大目标。所以，我非常激动你能来。我想从你在 Adobe 的角色开始谈起。在很长一段时间里，你都是 Adobe 的首席产品官。但最近，我注意到你转到了一个听起来非常复杂的职位。我很好奇这个新角色是什么，以及你为什么要做出这个转变。

---

### [00:05:18] Scott Belsky

**English:**
Well, in this new role, I'm overseeing strategy and corporate development, all of design across the company and emerging products for the business. If you look back at the last five years or so, it really has been about getting our core products to the cloud, making them collaborative, making some critical and interesting opportunistic acquisitions over the years, ensuring that we have connectivity between the products that we launched, new web apps that meet new types of creatives.

**中文翻译:**
在这个新角色中，我负责监督公司的战略和企业发展、全公司的设计工作以及业务的新兴产品。回顾过去的五年左右，我们的重点确实是让核心产品上云，实现协作化，并在这些年里进行了一些关键且有趣的机遇性收购，确保我们发布的产品之间具有连接性，并推出满足新型创意人员需求的新 Web 应用。

---

### [00:05:49] Scott Belsky

**English:**
And that was a incredible five-year-old chapter. Now with the advent of AI and new and emerging fast-growing businesses we have like the 3D and immersive space, the stock business and how that whole space is being changed by new technology, the idea of bringing that into an organization and being able to focus on that full-time was really exciting to me.

**中文翻译:**
那是令人难以置信的五年篇章。现在，随着 AI 的出现，以及我们拥有的 3D 和沉浸式空间、库存素材（Stock）业务等新兴且快速增长的业务，以及整个领域如何被新技术改变，将这些整合进组织并能够全职专注于此，对我来说非常令人兴奋。

---

### [00:06:13] Scott Belsky

**English:**
Well, I think that it's the strategy of a company always needs to be iterated. And so being tasked with developing the strategy across the entire company, there's no shortage of opportunities and people to meet and things to think about there. Corporate development, certainly like new M&A stuff and integration, all that sort of stuff falls under me as well. And I have a lot of feelings about that having been an entrepreneur that went through integration myself. So it's kind of fun to be on the other side and try to improve it from that vantage point.

**中文翻译:**
我认为公司的战略总是需要迭代的。因此，被委以制定全公司战略的任务，意味着不乏机会、需要会见的人和需要思考的事情。企业发展，当然包括新的并购（M&A）和整合，所有这些也都归我管。作为一名亲自经历过整合的创业者，我对这方面有很多感触。所以，站在另一边并尝试从那个角度去改进它，其实挺有趣的。

---

### [00:06:51] Scott Belsky

**English:**
On the design side, I spend a ton of time reviewing the design across every product and really trying to raise the bar for the experiences we're shipping. And that's a hard thing to do in a company that has a lot of legacy products and a lot of baggage that comes with them. And on the emerging products side, it's really about the new products we're bringing into the market and how to make them win.

**中文翻译:**
在设计方面，我花大量时间审查每个产品的设计，并努力提高我们交付的体验标准。在一家拥有大量遗留产品和随之而来的沉重包袱的公司里，这是一件很难的事情。而在新兴产品方面，重点在于我们将推向市场的新产品以及如何让它们获胜。

---

### [00:07:12] Lenny

**English:**
Something that comes up on this podcast a number of times is how CPOs rarely last at a company. They stay. Like Casey mentioned this and a few other people, they stay around for a couple years, and the best they can do is just take a few swings at how things work, improve a few things and then, the CEO's like, "No, this isn't great," and then find someone else. What do you think has contributed to you surviving and lasting and thriving and taking on more and more responsibility at Adobe?

**中文翻译:**
这个播客多次提到的一个话题是，首席产品官（CPO）很少能在一家公司待很久。就像 Casey 和其他几个人提到的，他们通常只待几年，能做的最好的事情就是对现有的运作方式进行几次尝试，改进一些东西，然后 CEO 可能会说：“不，这不够好”，接着就换人。你认为是什么让你在 Adobe 不仅生存了下来，而且还长久地发展、繁荣，并承担了越来越多的责任？

---

### [00:07:38] Scott Belsky

**English:**
Well, in the chief product officer role, I oversaw design, product, and engineering. And I think part of the reason I was even interested in coming into the company and taking this role is that I felt like these boundaries between these functions are at best artificial, at worst really constraining. And I always have felt like a lot of products win not because of the technology but the user's experience of the technology.

**中文翻译:**
在担任首席产品官期间，我负责监督设计、产品和工程。我想我之所以有兴趣加入公司并担任这个角色，部分原因是我觉得这些职能之间的界限充其量是人为划分的，最坏的情况则是极具约束力的。我一直觉得，很多产品的成功不是因为技术本身，而是因为用户对技术的体验。

---

### [00:08:08] Scott Belsky

**English:**
And so, if you have an aligned team that gets that and makes decisions accordingly, I think you can ship better experiences. So a lot of the work I had to do was breaking some of these boundaries down over the years. And I think that a lot of chief product officer roles traditionally don't oversee engineering and sometimes don't even oversee design. And for me, that wouldn't be interesting.

**中文翻译:**
因此，如果你有一个能够理解这一点并据此做出决策的统一团队，我认为你可以交付更好的体验。所以，这些年来我做的很多工作就是打破这些界限。我认为传统上很多首席产品官并不管工程，有时甚至不管设计。对我来说，那样的工作就没意思了。

---

### [00:08:29] Lenny

**English:**
Zooming into product, if there's a Mount Rushmore of insightful product thinkers, I feel like you'd be on it. And part of the reason is that you have this incredible product sense, whatever that means. It's clear that you have strong product sense. And PMs often talk about the importance of product sense and how to build product sense. And I'm curious, how do you feel like you built your product sense. And what advice would you give to younger PMs looking to build product sense?

**中文翻译:**
聚焦到产品上，如果有一个“富有洞察力的产品思想家”的拉什莫尔山（总统山），我觉得你一定在上面。部分原因是你拥有惊人的“产品感”（Product Sense），无论这个词具体指什么。很明显，你的产品感非常强。产品经理们经常讨论产品感的重要性以及如何培养它。我很想知道，你觉得自己是如何建立起这种产品感的？对于想要培养产品感的年轻 PM，你有什么建议？

---

### [00:08:56] Scott Belsky

**English:**
First of all, I think the biggest mistakes that teams make is they become very passionate about a solution to a problem they're trying to solve as opposed to do everything they can to develop empathy for the customer that's suffering the problem. And oftentimes, the empathy gives you the solution, whereas the passion you have for whatever you think the solution is might be 30 degrees off with the solution actually is.

**中文翻译:**
首先，我认为团队犯的最大错误是，他们对自己试图解决的问题的“解决方案”变得过于狂热，而不是尽一切努力去对遭受该问题的客户产生“同理心”（Empathy）。通常情况下，同理心会直接带给你解决方案，而你对自己认为的解决方案的热情，可能与实际所需的解决方案有 30 度的偏差。

---

### [00:09:20] Scott Belsky

**English:**
And so, this development of empathy is a key part of it. And of course, as I think about the discipline of crafting product experiences, to me, it's all about psychology. It's about understanding the natural human tendencies that people have in their most primal moments. I talk a lot about the first mile experiences that we have across any product we use, whether we're a consumer or an enterprise user. In the first 30 seconds of using a new product, you are lazy, vain, and selfish.

**中文翻译:**
因此，培养同理心是其中的关键部分。当然，当我思考打造产品体验的学科时，对我来说，这完全关乎心理学。它关乎理解人们在最原始时刻的自然人类倾向。我经常谈论我们在使用任何产品时的“第一英里”（First Mile）体验，无论我们是消费者还是企业用户。在开始使用新产品的前 30 秒内，人是懒惰、虚荣且自私的。

---

### [00:09:51] Scott Belsky

**English:**
You want to get it done super quickly. You want to look good to your colleagues or to your friends. You want to feel successful very quickly by engaging in this product. You don't want to have to watch a tour or read anything, really endure any learning curve whatsoever. Of course, if you can get people through the first 30 seconds, you have so much opportunity to build a more lasting relationship with that customer and have them understand your mission and the full potential of your product.

**中文翻译:**
你想超级快速地搞定它。你想在同事或朋友面前显得很厉害。你想通过使用这个产品迅速获得成就感。你不想看什么引导教程，不想读任何东西，真的不想忍受任何学习曲线。当然，如果你能让人们度过这前 30 秒，你就有很大的机会与客户建立更持久的关系，让他们理解你的使命和产品的全部潜力。

---

### [00:10:06] Scott Belsky

**English:**
But we need to ground ourselves with the fact that that's really hard to do. It's fascinating to me that most teams spend the final mile of their time building the product, considering the first mile of the customer's experience using the product. If you can just get more customers through that top of funnel, you are a world-class product team. Let's anchor ourselves on just doing that, and let's use psychology to do so.

**中文翻译:**
但我们需要清醒地认识到，这真的很难做到。让我感到不可思议的是，大多数团队在构建产品的“最后一英里”时间里，才去考虑客户使用产品的“第一英里”体验。如果你能让更多客户通过漏斗的最顶端，你就是一个世界级的产品团队。让我们专注于做到这一点，并利用心理学来实现它。

---

### [00:10:43] Lenny

**English:**
And just to make sure people understand, when you talk about the first mile, essentially that's the onboarding flow maybe to the activation moment.

**中文翻译:**
为了确保大家理解，当你谈论“第一英里”时，本质上是指从新手引导流程（Onboarding）到激活时刻（Activation Moment）的那段过程。

---

### [00:10:50] Scott Belsky

**English:**
I think that's right. It's the onboarding flow. It's the initial experience. It's the defaults that you see. It's the orientation of where you are. So many products you actually don't exactly know how you got to where you are and how to get home and where to get help. So I would say it's the onboarding. It's the orientation, and it's the defaults.

**中文翻译:**
我想是的。它是新手引导流程，是初始体验，是你看到的默认设置，是你对所处位置的方向感。很多产品实际上让你不知道自己是怎么到这一步的，不知道怎么回到主页，也不知道去哪里寻求帮助。所以我会说，它包括引导、定位和默认设置。

---

### [00:11:10] Lenny

**English:**
You've been a constant and early advocate of investing in that part of the funnel. And it's interesting how often that comes up on this podcast when people think about how do we improve retention, how do we improve growth. Often, the biggest wins from stories that we get on this podcast are in that part of the flow. And so, another data point to spend more time there. And I wanted to ask you, are you finding even at the stage of Adobe, there's still lots of opportunity in the first mile or do you find that it becomes less and less and less, and then it's less important?

**中文翻译:**
你一直是投资漏斗那部分环节的长期且早期的倡导者。有趣的是，当人们思考如何提高留存、如何提高增长时，这个话题在播客中经常出现。通常，我们在播客中听到的最成功的案例，其最大的突破都发生在流程的那一部分。所以，这是另一个支持在那投入更多时间的论据。我想问你，你是否发现即使在 Adobe 这个阶段，第一英里仍然有很多机会，还是说你发现它变得越来越不重要了？

---

### [00:11:41] Scott Belsky

**English:**
The answer is lots of opportunity. The reason is because the customers change. Every new cohort of new customers is different. The new customers you have in the early stages of your product are typically more willing and forgiving customers. And you might nail the onboarding process for them, and then suddenly realize that, "Wait, it's not being as effective anymore."

**中文翻译:**
答案是机会非常多。原因是客户在变化。每一批新客户都是不同的。你在产品早期阶段拥有的新客户通常更愿意尝试，也更宽容。你可能为他们设计了完美的引导流程，然后突然发现：“等等，它不再那么有效了。”

---

### [00:12:02] Scott Belsky

**English:**
And the reason is because now you're engaging more of those pragmatist customers, those later stage customers who are initially more skeptical, less forgiving, less willing to deal with your friction. And so, you have to reimagine the onboarding process all over again. I mean when you look at a product like Photoshop, for example, it used to cost hundreds and hundreds of dollars. Now, now you can get Photoshop for as little as 10 bucks a month. And so of course, the funnel's a lot larger. A lot more people come in with creative desires without the skills or the tolerance to develop them. And so, that dictates an entire change in the onboarding experience for a product like Photoshop.

**中文翻译:**
原因是你现在接触到了更多务实型客户，这些后期客户最初更怀疑、更不宽容，也不愿意处理你产品中的摩擦。因此，你必须重新构思整个引导流程。以 Photoshop 为例，它以前要花几百美元，现在每月只需 10 美元就能买到。所以理所当然地，漏斗变大了很多。更多有创意欲望但缺乏技能或耐心去培养技能的人进来了。因此，这要求像 Photoshop 这样的产品彻底改变其引导体验。

---

### [00:12:38] Lenny

**English:**
It makes me think of something Shishir, the CEO of Coda, shared about how he's like, "I don't really buy this idea of product market fit because you have product market fit with your existing users that love it and know about it, and you always don't have product market fit with the people you want to be used the product." And it's related to what you're talking about. The newest people joining have no idea what you're doing.

**中文翻译:**
这让我想起 Coda 的 CEO Shishir 分享过的一点，他说：“我不太买账‘产品市场匹配’（PMF）这个概念，因为你已经和那些热爱并了解你的现有用户达成了 PMF，但你总是还没能和那些你‘希望’使用你产品的人达成 PMF。”这和你说的很相关。新加入的人完全不知道你在做什么。

---

### [00:12:57] Scott Belsky

**English:**
I agree with that, and I actually think that the role of AI going forward will be to have applications increasingly meet us where we are. To this day, we've always had to generalize onboarding experiences for the most part for everyone. And I'm really excited about the day when kind of products meet us where we are based on what type of user we are.

**中文翻译:**
我同意这一点。实际上我认为 AI 未来的作用将是让应用越来越多地“主动适应”我们。直到今天，在大多数情况下，我们仍然不得不为所有人提供通用的引导体验。我非常期待那一天，产品能根据我们是什么类型的用户，在我们需要的地方与我们对接。

---

### [00:13:17] Lenny

**English:**
I have a billion AI-related questions for you. So I'm going to hold off just a bit. And I wanted to double click on the empathy piece. So you talk about how to become better at product sense. Empathy and understanding the user's problems is really important. Do you have any advice for someone that wants to build that? What can they actually do to become more empathetic and build that part of their skillset?

**中文翻译:**
我有无数关于 AI 的问题想问你，所以我先稍微按捺一下。我想深入探讨一下“同理心”这一点。你谈到如何提升产品感，同理心和理解用户的问题非常重要。对于想要建立这种能力的人，你有什么建议吗？他们具体可以做些什么来变得更有同理心，并构建这方面的技能？

---

### [00:13:41] Scott Belsky

**English:**
Well, the most humbling moments for me as a product leader have always been shoulder to shoulder to customers. Watching them actually go about their day, not just use my product but go about their day because what you end up getting is context for a lot of data that you're missing.

**中文翻译:**
对我来说，作为产品领导者，最让我感到谦卑的时刻总是与客户“并肩作战”。观察他们实际的一天是怎么过的，不仅仅是使用我的产品，而是他们日常生活的全貌。因为你最终会获得很多你缺失的数据背后的上下文（Context）。

---

### [00:13:56] Scott Belsky

**English:**
When customers are using your product, they're using it amidst everything else around them. In the enterprise, it's all their other meetings and other products and pings that they're getting throughout the day. And as a consumer, it's between dealing with their kids or their loved ones or watching Netflix or whatever the case might be. And in order to really understand where the customer is and where their mentality is, you have to understand the context in which they're using your product.

**中文翻译:**
当客户使用你的产品时，他们是在周围所有其他事物的包围下使用的。在企业环境中，是他们全天参加的其他会议、使用的其他产品和收到的各种消息。作为消费者，则是在照顾孩子、陪伴爱人或看 Netflix 之间的空隙。为了真正理解客户所处的位置和他们的心态，你必须理解他们使用你产品的上下文环境。

---

### [00:14:14] Scott Belsky

**English:**
So part of developing empathy is being shoulder to shoulder and just encountering that reality alongside your customer. And that time, it just gives you better intuition. It helps you understand more. And with empathy, we can then better create quote-unquote, "for ourselves" because by developing empathy for others, we're feeling what they're feeling. We can then be the customer. And, of course, we all know some of the best product customers, some of the best products in the world are made when we are the makers are the customer.

**中文翻译:**
所以，培养同理心的一部分就是与客户并肩，亲身感受他们的现实。那段时间会给你带来更好的直觉，帮助你理解更多。有了同理心，我们就能更好地“为自己”创造（加个引号），因为通过对他人产生同理心，我们能感受到他们的感受，我们就能成为那个客户。当然，我们都知道世界上一些最好的产品，正是当制造者本身就是客户时诞生的。

---

### [00:14:51] Lenny

**English:**
It makes me think of Marc Andreessen as this awesome quote that I always come back to that everyone's time is already allocated. They don't have time for your product.

**中文翻译:**
这让我想起 Marc Andreessen 的一句名言，我经常回想起它：每个人的时间都已经分配完了。他们没有时间留给你的产品。

---

### [00:14:59] Scott Belsky

**English:**
That's right. And by the way, as a related note, since I know Lenny, you talk to a lot of guests around product-led growth. And sorry, if I'm skipping around here. But I think it's also relevant because everyone's trying to get their products to grow. And the other thing that perplexes me is that product leaders expect people to talk about a product being great. And people don't talk about a product doing exactly what they expected it to do. They talk about a product doing what they didn't expect.

**中文翻译:**
没错。顺便提一下，既然我知道 Lenny 你和很多嘉宾聊过产品驱动增长（PLG）。抱歉我跳跃了一下，但我认为这也很相关，因为每个人都在努力让产品增长。另一件让我困惑的事是，产品领导者期望人们谈论一个产品有多棒。但人们不会谈论一个产品“完全符合预期”的表现，他们谈论的是一个产品做了他们“没预料到”的事情。

---

### [00:15:29] Scott Belsky

**English:**
And you look at a product like Tesla. People are not going and talking about how they had a great drive today, but they're talking about the Easter egg they discovered on the dashboard or the cool new feature that they discovered that is associated with Christmas or whatever. And so, it always is interesting to me. In consumer and even enterprise products maybe especially so, why aren't we optimizing for those things that people wouldn't expect the product to do as a way to get that surprise and delight to talk about it, to develop a relationship with our products? I think that's another piece of the puzzle.

**中文翻译:**
你看像特斯拉这样的产品。人们不会到处去说今天开车开得真顺，但他们会谈论在仪表盘上发现的彩蛋，或者发现的与圣诞节相关的酷炫新功能。所以这对我来说总是很有趣。在消费级甚至企业级产品中（也许企业级更是如此），为什么我们不针对那些“人们没预料到产品会做的事”进行优化，以此作为获得惊喜和愉悦、引发讨论、并与产品建立关系的方式呢？我认为这是拼图的另一块。

---

### [00:16:08] Lenny

**English:**
That is really interesting, and reminds me of something I just talked about with Gustav from Spotify whose episode might come out before this or after this about how every great consumer product pulls some kind of magic trick and feels like magic to you, like Spotify as an example.

**中文翻译:**
这真的很有趣，让我想起我刚和 Spotify 的 Gustav 聊过的内容（他的那一集可能在这一集之前或之后播出），关于每个伟大的消费级产品都会玩某种“魔术”，让你觉得它像魔法一样，比如 Spotify 就是个例子。

---

### [00:16:23] Scott Belsky

**English:**
I like that, magic, sort of a little mystery, a little intrigue, a little surprise. It's a classic trick that Hollywood uses all the time. Why don't we use it in our own products?

**中文翻译:**
我喜欢这个说法，魔法，带点神秘感、带点吸引力、带点惊喜。这是好莱坞一直在用的经典招数。为什么我们不在自己的产品里用呢？

---

### [00:16:34] Lenny

**English:**
So let me pull on that thread a little bit about just consumer products in general. You spent a lot of your career, maybe most of your career in consumer, imagine Adobe. There's a lot of B2B elements now as well. And you also angel invest and you help a lot of consumer companies. And tell me if you agree, but it feels like new consumer products basically never work. And if they do work, there's a period where they work, BeReal is going through this now, Clubhouse, Paparazzi went through this. And then, they fail or fade away. Maybe, they come back and then fade away again. I guess, first of all, do you generally agree that consumer is just so rarely successful in consumer products?

**中文翻译:**
那让我顺着这个话题聊聊消费级产品。你职业生涯的大部分时间都在消费领域，想象一下 Adobe，现在也有很多 B2B 元素。你也做天使投资，帮助很多消费类公司。告诉我你是否同意：感觉新的消费级产品基本上很难成功。即使成功了，也只是红极一时，比如现在的 BeReal，之前的 Clubhouse、Paparazzi。然后，它们要么失败，要么淡出视线。也许会卷土重来，然后再次淡出。我想问，你是否大致同意消费级产品极难获得持久成功？

---

### [00:17:14] Scott Belsky

**English:**
Uber was a consumer product, but it built a network effect that was never there before. It leveraged excess capacity that was always there, but never tapped. It did something under the hood that gave it lasting power. I think of Pinterest, and I was Ben's first seed angel and product advisor. And with that product, he had this unique insight into the consumer psychology where it was not as much about getting likes and portraying yourself through pictures of you and seeing pictures of friends and all of this sort of anxiety that is induced by that, but rather helping people collect and represent themselves with their interests.

**中文翻译:**
Uber 曾是一个消费级产品，但它建立了一个前所未有的网络效应。它利用了一直存在但从未被开发的闲置产能。它在底层做了一些事情，赋予了它持久的生命力。我想到了 Pinterest，我是 Ben 的第一个种子轮天使投资人和产品顾问。对于那个产品，他有一种独特的消费心理洞察：它不那么关乎获得“点赞”、通过自己的照片展示自我、或者看朋友的照片以及由此引发的各种焦虑，而是帮助人们通过自己的兴趣来收集和展示自我。

---

### [00:18:03] Scott Belsky

**English:**
And so again, that was kind of a new insight that I also think developed its own network effect that enabled it to be lasting. And there was a fascinating business component which was it drove a crapload of traffic to every source of every pin, which then got those sites to then put pin buttons themselves because they wanted more traffic. So there were underlying things under the hood again that it's sort of tilting the market in his favor. I think that a lot of these other more recent consumer products are just kind of clever momentary interfaces.

**中文翻译:**
所以，这又是一种新的洞察，我认为它也发展出了自己的网络效应，使其能够持久。还有一个迷人的商业组成部分，那就是它为每一个 Pin 图的来源网站带来了巨大的流量，这反过来促使这些网站自己主动安装 Pin 按钮，因为它们想要更多流量。所以，底层又有一些东西在起作用，让市场向他倾斜。我认为最近很多其他的消费级产品只是某种聪明的、昙花一现的界面。

---

### [00:18:50] Scott Belsky

**English:**
And they are in effect at the expense of venture capitalists, R&D for the platforms that already have the network effects and already have the distribution channels and the ad sales and everything else. And so, I think that's why we're seeing BeReal's capabilities now also in TikTok, and you're seeing a lot of flashes in the pan, especially in these creative consumer apps, which I've been paying very close attention to. They're fun and novel. But if they really work, those features are then brought into the native Apple camera, for instance.

**中文翻译:**
实际上，它们是在拿风险投资人的钱，为那些已经拥有网络效应、分发渠道、广告销售和一切资源的平台做研发（R&D）。所以我认为这就是为什么我们现在在 TikTok 中也能看到 BeReal 的功能，你会看到很多昙花一现的现象，尤其是在这些创意类消费应用中，我一直非常关注这些。它们很有趣也很新颖，但如果它们真的奏效，那些功能随后就会被引入到比如苹果的原生相机里。

---

### [00:19:09] Lenny

**English:**
So let's double click on that. I know this is a big question, but just what have you found is important for a new consumer product to work? You mentioned surprise would be great, network effects, maybe a new insight. What else do you find is important for a durable new consumer product to work?

**中文翻译:**
那我们深入探讨一下。我知道这是一个大问题，但你发现一个新的消费级产品要成功，什么才是重要的？你提到了惊喜、网络效应，也许还有新的洞察。你觉得一个持久的新消费级产品还需要什么？

---

### [00:19:30] Scott Belsky

**English:**
Yeah. And it's interesting because I think my answer 10 years ago would probably be different than my answer today. I think that there is a nimbleness. And maybe, it started in China with these super apps that were able to do everything. And that changed the idea away from the atomized experiences of a decade plus ago where you wanted a specialized product that did exactly what you wanted in a very reduced way.

**中文翻译:**
是的。这很有趣，因为我想我 10 年前的答案可能和今天的不同。我认为现在需要一种灵活性。也许这始于中国的那些无所不能的超级应用（Super Apps）。这改变了观念，让我们远离了十多年前那种“原子化”的体验——那时你想要一个专门的产品，以一种非常简化的方式精确地完成你想要的功能。

---

### [00:20:00] Scott Belsky

**English:**
I think Snapchat emerged under that world. I think Instagram became valuable to Facebook because of that phenomenon. Fast forward to today where all of us are far more technologically literate and we are able to manage a lot more cognitive load in our everyday technology lifestyles. And so suddenly, we don't mind five tabs. We don't mind features hidden and tucked away in menus because we're sort of used to that now. And so, maybe that's one of the reasons why these established platforms get away with basically copying any novel new capability as opposed to those becoming apps in and of themselves.

**中文翻译:**
我认为 Snapchat 就是在那个背景下诞生的。Instagram 对 Facebook 变得有价值也是因为那个现象。快进到今天，我们所有人的科技素养都高得多，在日常科技生活中能够处理更多的认知负荷。所以突然之间，我们不介意有五个标签页，不介意功能隐藏在菜单深处，因为我们已经习惯了。所以，这也许是为什么这些成熟平台能够通过直接复制任何新颖功能而获利，而不是让这些功能独立成为应用的原因之一。

---

### [00:20:42] Lenny

**English:**
So let me shift a little bit and talk about a tweet that you tweeted about one thing you've learned. You have this amazing thread of just things you have learned over the many years you've been thinking about products and consumer products. And one of them was about how you've learned that, you should do half the things that you want to do, half the features you plan to do, do half the features, offer half the options you want to offer, focus on half the market versus the market you're trying to go after.

**中文翻译:**
让我换个话题，谈谈你发过的一条关于你所学到的经验的推文。你有一个很棒的推特串，记录了你多年来思考产品和消费级产品所学到的东西。其中一条是关于你学到的：你应该只做你想做的事情的一半，只做你计划的功能的一半，提供你想提供的选项的一半，专注于你试图追求的市场的一半。

---

### [00:21:12] Lenny

**English:**
Can you just talk about maybe how you came upon that learning and then also just how do you actually do that? It's like, "Sure, great. We're going to do half." But then, which half? And oh, but someone wants this feature so badly, shoot. We can't do them all." So do you have any advice in just how to actually execute that sort of approach?

**中文翻译:**
你能谈谈你是如何得出这个结论的吗？以及具体该如何操作？就像，“好吧，太棒了，我们要减半。”但问题是，减掉哪一半？而且，“噢，有人非常想要这个功能，该死，我们不能全做。”那么，在如何实际执行这种方法上，你有什么建议吗？

---

### [00:21:29] Scott Belsky

**English:**
I mean one of the first comments I'll just make is whenever I'm asked by teams, what features need to be part of their MVP, how do they decide which features they need to ship first and whatever, I always tell them to optimize for the problems they want to have. You want the problem of customers getting through your funnel, feeling successful, using your product and getting value and then saying to you, "Oh, but I need it on this platform, or I need this capability, or I want to be able to share this." I mean you want those problems. So don't do those features now.

**中文翻译:**
我想说的第一点是，每当有团队问我，哪些功能应该包含在他们的 MVP（最小可行产品）中，他们该如何决定先发布哪些功能时，我总是告诉他们：要针对“你想要拥有的问题”进行优化。你想要的问题是：客户通过了你的漏斗，感到很有成就感，使用了你的产品并获得了价值，然后对你说：“噢，但我需要在另一个平台上用它”，或者“我需要这个功能”，或者“我想分享这个”。我的意思是，你想要的是“这些”问题。所以，现在先别做那些功能。

---

### [00:22:03] Scott Belsky

**English:**
Only do the things that prevent people from getting to the point where they care enough to ask you for anything. Make sure they can get through the signup flow. Make sure they can connect their account. Make sure they can use Google login if they need to, or whatever the case may be. So I always remind the teams, optimize for the problems you want to have, and make sure that you eliminate all the brick walls, the major catastrophe-type things that can happen. But in terms of the half, the half-half, I learned this the hard way.

**中文翻译:**
只做那些能防止人们在还没到“关心到想向你提要求”的程度就流失的事情。确保他们能完成注册流程，确保他们能连接账户，确保他们能在需要时使用 Google 登录，诸如此类。所以我总是提醒团队，针对你想要拥有的问题进行优化，并确保消除所有的“砖墙”——即可能发生的重大灾难性障碍。但说到那个“减半再减半”，我是通过惨痛的教训学到的。

---

### [00:22:31] Scott Belsky

**English:**
When Behance was launching back in 2008, I was always trying to hedge us with product features. I wasn't sure if people would be coming to join groups or if people would be coming for the tip exchange where creatives share best practices with one another, or if people were coming to build their portfolios or just share work in progress. Maybe, it's too much to build a whole project of your work. Maybe, we can allow people just to share snapshots of their work. And so, we actually launched with pretty much all of these features. And then, it was the most complicated form of Behance, was ironically at the beginning.

**中文翻译:**
2008 年 Behance 发布时，我总是试图用产品功能来对冲风险。我不确定人们来是为了加入小组，还是为了“技巧交流区”（创意人员互相分享最佳实践），或者是为了建立作品集，或者只是分享进行中的工作。也许构建一个完整的作品项目太累了，也许我们可以让人们只分享工作的快照。所以，我们发布时几乎包含了所有这些功能。讽刺的是，Behance 最复杂的版本竟然是在刚开始的时候。

---

### [00:23:10] Scott Belsky

**English:**
And then, what we realized is that some things were taking off, and some things weren't. So I remember when we decided to kill the Tip Exchange. And suddenly, the publishing of projects in the portfolio went up. And we're like, "Oh my gosh. Projects being published is the core metric and it's what drives the traffic back to Behance. Let's do this again. I don't know, let's kill groups." And so, we killed groups. And lo and behold, more people published more projects. And it was like, "Wow."

**中文翻译:**
然后，我们意识到有些功能火了，有些则没有。我记得当我们决定砍掉“技巧交流区”时，作品集中发布项目的数量突然增加了。我们心想：“天哪，发布项目是核心指标，也是把流量带回 Behance 的动力。让我们再试一次，砍掉小组吧。”于是我们砍掉了小组。你瞧，更多的人发布了更多的项目。当时的感觉就是：“哇。”

---

### [00:23:33] Scott Belsky

**English:**
So actually if you make the whole product about one thing, everyone does that. That core crank operates at 10X the velocity and if that's the most important metric for the business, that's gold. And so, we basically went on a killing spree. And we just started killing things. And over the years, we have actually tried to have this sort of, and I pushed this on many products, things I worked with now whenever you're adding things, consider what you can replace. Consider what you can also remove.

**中文翻译:**
所以实际上，如果你让整个产品只围绕一件事，每个人都会去做那件事。那个核心转轮会以 10 倍的速度运转，如果那是业务最重要的指标，那就是无价之宝。于是，我们基本上开始了一场“大屠杀”，开始砍掉各种功能。这些年来，我一直在许多产品中推行这种做法：每当你增加东西时，考虑一下你可以替换掉什么，或者你可以移除什么。

---

### [00:24:11] Scott Belsky

**English:**
When we updated the portfolio on Behance, I remember we used to have this ability to change the colors of your portfolio in Behance. When people clicked on your profile and saw all your projects, you could control that and add your brand element to it. And so, we know. We were like, "You know what? What would happen if we just took this away? Would people again focus more on projects?" And so, we took it away. For 24 hours, we had people reaching out to us being like, "Damn you. How could you take away these controls for color of portfolio?" After that 24 hours, we basically never heard about it again. All the portfolios look cleaner and more consistent. And people did the core metric more. And so, I just took from that, try to kill things and everything you think you need to do, you probably only need to do half of it.

**中文翻译:**
当我们更新 Behance 的作品集功能时，我记得以前可以更改作品集的颜色。当人们点击你的个人资料查看所有项目时，你可以控制颜色并加入品牌元素。我们当时想：“如果把这个功能拿掉会怎样？人们会再次更多地关注项目本身吗？”于是我们把它拿掉了。在接下来的 24 小时里，有人联系我们说：“该死的，你们怎么能拿掉作品集的颜色控制？”但过了那 24 小时，我们基本上再也没听过这种抱怨。所有的作品集看起来更干净、更统一，人们完成核心指标的次数也更多了。所以我从中得出的结论是：尝试砍掉东西，你认为你需要做的所有事情，可能只需要做一半就够了。

---

### [00:24:57] Lenny

**English:**
I wonder if in reality most of the time, you only realize this afterwards versus ahead of time. And that's just the way it is. And then, it's just the seal of sunset, things that aren't actually important.

**中文翻译:**
我在想，现实中大多数时候，你是不是只有在事后才能意识到这一点，而不是事前。事实就是这样，然后就是顺理成章地停掉那些其实并不重要的东西。

---

### [00:25:08] Scott Belsky

**English:**
I do have to say though, Lenny, some of the best product leaders that I've worked with, I do feel like they have this great reductionist or minimalistic tendency by default. They're just very much... They anchor themselves on the one thing they want people to do and do well. And they just are pretty ruthless about everything else, being like, "Okay, but only if we have a problem with doing this core thing. Okay, put on the back burner." And so, it's something I've tried to get better at over the years.

**中文翻译:**
但我必须说，Lenny，在我合作过的一些最优秀的产品领导者身上，我确实感觉到他们天生就有一种极强的“还原论”或“极简主义”倾向。他们非常专注……他们把自己锚定在希望人们去做并做好的一件事上。对其他所有事情都非常冷酷，会说：“好吧，除非我们在做这件核心事情上遇到了问题，否则先放一边。”这是我多年来一直努力改进的地方。

---

### [00:25:40] Lenny

**English:**
What's really interesting is this is exactly like Matt Mochary who is actually the number one most popular podcast episode talks about when you let people go. And he's helped a lot of CEOs let people go that 100% of the time everything just starts moving faster as soon as you have fewer people. And so, it's the same exact model in people and products.

**中文翻译:**
非常有趣的是，这和 Matt Mochary（他那一集实际上是播客最受欢迎的一集）谈论裁员时的情况完全一样。他帮助过很多 CEO 裁员，结果 100% 的情况下，一旦人少了，所有事情反而开始运行得更快。所以，在人和产品上，这完全是同一个模型。

---

### [00:26:02] Scott Belsky

**English:**
I think that's right. And that's why I always feel like tough decisions almost always afterwards feel like a relief. And that's true for the product. That's true for people on a team as well.

**中文翻译:**
我认为没错。这就是为什么我总觉得，艰难的决定在做出之后，几乎总是会让人感到一种解脱。对产品是这样，对团队中的人也是这样。

---

### [00:26:15] Lenny

**English:**
Let's shift to talking about AI, which I'm really excited about because I know you've been spending a lot of time talking with people about AI, building AI products. You all launched Firefly, which a lot of people are really excited about. You also have this newsletter where you kind of just share your implications on how AI and technology is going to impact the world. So I have a lot of questions I'm excited to ask you around this. And I'll just start really broad and maybe this is too big of a question, but just how different do you expect the world to be in, say, five years as a result of AI, both for product builders and then just people in general?

**中文翻译:**
让我们转向讨论 AI，我对此非常兴奋，因为我知道你花了很多时间与人们讨论 AI、构建 AI 产品。你们发布了 Firefly，很多人都对此感到兴奋。你还有一个时事通讯（Newsletter），分享你对 AI 和技术将如何影响世界的见解。关于这一点，我有很多问题想问。我先从一个非常宽泛的问题开始，也许这个问题太大了：你预计在未来五年内，由于 AI 的影响，世界会有多大的不同？无论是对产品构建者还是对普通大众。

---

### [00:27:15] Scott Belsky

**English:**
Listen, I'm an optimist. And I feel like our human potential has always been held back by the laws of physics essentially. The mundane, repetitive labor you need to do to get anything done is what holds back our ingenuity. It's the friction. It's the work in workflows that wouldn't it be great if we could just have flow and no work? And I think that that's what AI kind of does, is it gets us from workflow to flow. It gets us into this flow state where any idea in your mind's eye, you can start to develop it.

**中文翻译:**
听着，我是一个乐观主义者。我觉得人类的潜力本质上一直受到物理定律的束缚。为了完成任何事情而必须进行的那些单调、重复的劳动，正是阻碍我们创造力的原因。那是摩擦力。那是“工作流”（Workflow）中的“工作”（Work）。如果只有“流”（Flow）而没有“工作”不是太棒了吗？我认为 AI 正在做的就是让我们从“工作流”转向“流”。它让我们进入这种心流状态，让你脑海中的任何想法都能开始成形。

---

### [00:27:46] Scott Belsky

**English:**
I was having this discussion with Howie who runs Airtable actually just earlier today where we were talking about the leader at IBM who announced that he's not going to hire 8,000 people that he would've hired because AI is going to be able to do that work. And what we were talking about was, and Howie made the point, as engineers have become much more productive over the years, that doesn't mean that companies have wanted fewer engineers. It actually just means that they demand more of their engineers. And engineers have more possibility to do more.

**中文翻译:**
今天早些时候我刚和 Airtable 的负责人 Howie 讨论过这个问题。我们谈到了 IBM 的领导者宣布他将不再招聘原本计划招聘的 8,000 人，因为 AI 将能够完成那些工作。我们讨论的是（Howie 提出了这一点）：随着这些年来工程师的生产力大幅提高，这并不意味着公司想要的工程师变少了。实际上，这只意味着他们对工程师的要求更高了，而工程师也有更多的可能性去做更多的事情。

---

### [00:28:02] Scott Belsky

**English:**
And so, if human ingenuity goes up, maybe we actually want to hire more people because if you have more ingenuity per human being, maybe you can actually do more as a company. And maybe, companies that used to have three products will have five products or seven products or 30 products. And maybe, that's actually the trend that we're forgetting is that humans bring this level of ingenuity to every problem and every opportunity. Whereas computers remember like ChatGPT is basically just giving you what it would look like if, right? It's not truly finding edges that will become the center.

**中文翻译:**
所以，如果人类的创造力提升了，也许我们实际上想雇佣更多的人。因为如果每个人的创造力都提高了，作为一家公司，你也许能做更多的事情。也许以前只有三个产品的公司，现在会有五个、七个甚至 30 个产品。也许这才是我们遗忘的趋势：人类为每个问题和每个机会带来了这种水平的创造力。而计算机，记住，像 ChatGPT 基本上只是在告诉你“如果……会是什么样子”，对吧？它并不是真的在寻找那些将成为未来主流的边缘创新。

---

### [00:28:38] Scott Belsky

**English:**
It's actually just mining the center. And it's trying to regurgitate the center, which is also very helpful by the way. So I'm optimistic. I think that there will be far more people engaged in delivering experiences. I'm very long the experience economy because I think that there will be some people liberated to focus more on the non-scalable things that really move the needle for experiences for customers. And then, I also am excited about humans having less grudge work to do.

**中文翻译:**
它实际上只是在挖掘现有的核心知识，并尝试反刍这些核心内容，顺便说一下，这也非常有用。所以我很乐观。我认为会有更多的人参与到交付体验中。我非常看好“体验经济”，因为我认为有些人会被解放出来，去更多地关注那些不可扩展的、但真正能显著提升客户体验的事情。此外，我也为人类能减少那些苦差事而感到兴奋。

---

### [00:29:09] Lenny

**English:**
I'm also excited for that. It reminds me it might have a TikTok account, and I have this team that helps with the TikTok and we haven't shared this, but a few of the TikToks are my voice generated with AI. And they just read script. And it's me reading this story. And it sounds sort of like me. And I showed it to a friend. And I was like, "Do you see anything? You feel weird about this video?" And he is like, "No, you sound great. You sound really a great speaker." I'm like, "Okay. Say hi."

**中文翻译:**
我也为此感到兴奋。这让我想起我可能有一个 TikTok 账号，我有一个团队帮我打理。我们还没公开过，但有几个视频里的声音是用 AI 生成的我的声音。它们只是在读脚本，听起来就像我在读故事，而且听起来挺像我的。我给一个朋友看，问他：“你看出什么了吗？觉得这个视频奇怪吗？”他说：“不啊，你听起来很棒，像个优秀的演讲者。”我心想：“好吧，打个招呼吧。”

---

### [00:29:35] Scott Belsky

**English:**
While you were reading, instead of reading a script, you can be plotting the course of the next episode.

**中文翻译:**
当你“在读”的时候，你其实不用真的读脚本，你可以去策划下一集的内容。

---

### [00:29:40] Lenny

**English:**
Yeah, exactly. So I totally see what you're talking about there. In the product team, which function do you think will be the most disrupted and/or the most, I don't know, optimized through AI?

**中文翻译:**
是的，没错。所以我完全理解你所说的。在产品团队中，你认为哪个职能会被 AI 颠覆得最厉害，或者说被优化得最彻底？

---

### [00:29:52] Scott Belsky

**English:**
We're entering the era where we collapse the stack in every organization where instead of having to go to someone for anything, you can kind of do more things yourself. It's very empowering to get the answer from data as opposed to having to go to a data scientist or a data analyst in the middle. So there's going to be far less game of operator across the organization and far more empowerment for people to dig their own rabbit holes, answer their own questions and get things done.

**中文翻译:**
我们正在进入一个每个组织的“堆栈坍缩”（Collapse the stack）的时代。你不再需要为了任何事去找某个人，你可以自己做更多的事。直接从数据中获得答案，而不是必须通过中间的数据科学家或数据分析师，这是非常赋能的。因此，组织内部那种“传声筒”游戏会少得多，人们会被赋予更多权力去深入钻研、回答自己的问题并把事情办成。

---

### [00:30:24] Scott Belsky

**English:**
I happen to believe that that's the advantage typically of small teams, is that they're flat. The stack is collapsed. People all can hear each other in an audible across the room, and that's how they run circles around big stodgy old companies that are dispersed around the world. So maybe, this technology allows cross-functional work and to happen. And I'm excited about that.

**中文翻译:**
我恰好相信，这通常是小团队的优势：他们很扁平，堆栈是坍缩的。大家在房间里都能听到彼此说话，这就是为什么他们能让那些分散在全球各地的、呆板的大公司望尘莫及。所以，也许这项技术能让真正的跨职能工作得以实现。我对此感到兴奋。

---

### [00:30:51] Lenny

**English:**
That is really interesting. So essentially, what you're saying is a PM will be able to do more design, more engineering, more data potentially. And maybe, one day, it'll be just as good as having a data scientist in your team. But essentially, everyone becomes kind of this unicorn cross-functional mini-team.

**中文翻译:**
这真的很有趣。所以本质上，你的意思是 PM 将能够做更多的设计、更多的工程，潜在地还有更多的数据工作。也许有一天，这会和团队里有一个数据科学家一样好。但基本上，每个人都变成了某种“独角兽”式的跨职能迷你团队。

---

### [00:31:08] Scott Belsky

**English:**
Which sort of suggests this idea of meritocracy. It's almost like what if people get promoted an opportunity based on how creative and how much ingenuity they have as opposed to how many reports or bug things they've gone through or whatever else. So there's something about what you're saying that I do think, yes, it's disruptive to the degree that, well, you need a data analyst in the loop. But I also would suggest that again, that data analyst doesn't have to answer redundant requests all day. She can spend time on thinking of other things without the boundaries of functions like we just discussed.

**中文翻译:**
这在某种程度上暗示了“精英管理”（Meritocracy）的理念。这就像是，如果人们获得晋升和机会是基于他们的创造力和独创性，而不是基于他们管理了多少下属或处理了多少 Bug 之类的。所以你说的确实有道理，它在某种程度上是颠覆性的，比如你可能不再需要一个专门的数据分析师在流程中。但我也想说，那个数据分析师也不必整天回答重复的请求了。她可以花时间思考其他事情，不再受我们刚才讨论的职能边界的限制。

---

### [00:31:43] Lenny (Sponsor Ad: Rows.com)

**English:**
This episode is brought to you by rows.com. The world runs on spreadsheets. You probably have a tab open with a spreadsheet right now. But the spreadsheet product you're using today was designed decades ago. And it shows, they live in silos away from your business data. They weren't made to be used on a phone. And if you want to do even the simplest automation, you have to figure out complex scripts that are nightmare to maintain. Rows is different. It combines a modern spreadsheet editor, data integrations with APIs and your business tools and a slick sharing experience that turns any spreadsheet into a beautiful interactive website that you'll be proud to share. Go to rows.com/lenny.

**中文翻译:**
本集节目由 rows.com 赞助。世界运行在电子表格之上。你现在可能就打开了一个电子表格标签页。但你今天使用的电子表格产品是几十年前设计的。这显而易见：它们与你的业务数据隔绝。它们不是为手机设计的。如果你想做最简单的自动化，你必须搞清楚那些维护起来简直是噩梦的复杂脚本。Rows 则不同。它结合了现代电子表格编辑器、与 API 及业务工具的数据集成，以及流畅的分享体验，能将任何电子表格变成一个你会自豪地分享的美观交互式网站。请访问 rows.com/lenny。

---

### [00:32:36] Lenny (Sponsor Ad: Rows.com)

**English:**
I've already moved some of my favorite spreadsheet templates to Rows. Go to rows.com/lenny to check them out. That's rows.com/lenny. A lot of listeners are product managers. And so just going a little bit further, even within the product management function, how do you see the PM role changing in the next five years as a result of AI?

**中文翻译:**
我已经把我最喜欢的一些电子表格模板移到了 Rows。去 rows.com/lenny 看看吧。很多听众都是产品经理。所以再深入一点，即使在产品管理职能内部，你认为未来五年 PM 的角色会因为 AI 发生怎样的变化？

---

### [00:33:05] Scott Belsky

**English:**
Well, let me start by saying that I think that the greatest performers I've ever worked with, whether they're designers or product leaders, basically preserve the time to explore lots of possibilities. They call those possibilities down to fewer set. They get feedback on those. They refine them even further. And then, they present to the team. These are the two or three things I think we should do. And that's the way a great designer works, for example. That is a function of time.

**中文翻译:**
首先我想说，我合作过的最优秀的表现者，无论是设计师还是产品领导者，基本上都会留出时间来探索大量的可能性。他们将这些可能性筛选成较小的一组，获取反馈，然后进一步完善。最后，他们向团队展示：这是我认为我们应该做的两三件事。例如，这就是一个优秀设计师的工作方式。这其实是时间的函数。

---

### [00:33:43] Scott Belsky

**English:**
In my world, in my mind, generative AI and AI for all, when it talks to me about just product leaders exploring possibilities, this should expand the surface area. I was talking to a pretty well known director in Hollywood world, and he was telling me that he uses ChatGPT. I was like, "No. Are you serious? You do?" And he was like, "Yeah, I don't use it to write any scripts." But sometimes when I'm developing something with a writing partner, I will ask ChatGPT, "What would you do?" And I'll explain the full instance, the full situation in extreme detail. And it will spit out five scenarios. And I actually don't use any of them, but it just gives me more surface area. It tells me the things that I wouldn't want to do, which is also good data. And I just thought that response is so interesting. And so when you ask about product leaders, I think that's what we're going to have, is we're going to have the superpower of exploring far more surface area in far less time.

**中文翻译:**
在我的世界里，在我看来，生成式 AI 对所有人来说，当谈到产品领导者探索可能性时，它应该能扩大“表面积”（Surface Area）。我曾与好莱坞一位非常有名的导演聊天，他告诉我他在用 ChatGPT。我当时说：“不，你是认真的吗？你真的在用？”他说：“是的，我不拿它写剧本。但有时当我与写作伙伴开发内容时，我会问 ChatGPT：‘你会怎么做？’我会极其详细地解释整个案例和情况。它会吐出五个场景。我实际上一个都不用，但它给了我更多的‘表面积’。它告诉了我那些我‘不想’做的事情，这也是很好的数据。”我觉得这个回答太有趣了。所以当你问到产品领导者时，我认为我们将拥有这种超能力：在更短的时间内探索更广阔的可能性空间。

---

### [00:34:41] Lenny

**English:**
It reminds me of something I always share about why do you need a PM? Why do you need a designer? Why do you need a researcher? It's not necessarily that they're just very good at these specific skills. It's that they just have time to do this one thing that needs to be done. You can have engineers do the PM role, but they don't have time. They want to code and they'd rather do that. And so, this is really interesting that it connects to. It'll give everyone a little more time to get better at the thing they want to be doing.

**中文翻译:**
这让我想起我经常分享的一个观点：为什么需要 PM？为什么需要设计师？为什么需要研究员？不一定是因为他们非常擅长这些特定技能，而是因为他们“有时间”去做这件需要完成的事情。你可以让工程师做 PM 的工作，但他们没时间，他们想写代码，而且更愿意写代码。所以这很有趣，它联系到了这一点：它会让每个人有更多时间去精进他们真正想做的事情。

---

### [00:35:08] Scott Belsky

**English:**
That's true.

**中文翻译:**
没错。

---

### [00:35:09] Lenny

**English:**
Is there anything you're doing with PMs at Adobe at this point that help them leverage these tools and just the ways of working that you're actually using today?

**中文翻译:**
在 Adobe，你目前有没有采取什么措施来帮助 PM 利用这些工具，或者采用你现在实际使用的这些工作方式？

---

### [00:35:18] Scott Belsky

**English:**
One of my obsessions has been bringing design earlier into the process of product development. So it's not necessarily AI yet. But it's the idea of designers, first of all, being in the room, even being in the room with some of the customer research and some of the debates around even the value proposition to the customer and some of the things that traditionally happen only with the PMs. I just find that, again, collapsing the stack, if you will. Having the designer hear these things and contribute gives them a golden gut as they are then sitting down later and going through possible interfaces to solve the problem.

**中文翻译:**
我一直痴迷的一件事就是让设计更早地介入产品开发流程。所以这还不一定是关于 AI 的。而是让设计师首先出现在现场，甚至参与一些客户研究，参与关于客户价值主张的辩论，以及一些传统上只有 PM 参与的事情。我发现这又是某种“堆栈坍缩”。让设计师听到这些并参与贡献，会赋予他们一种“黄金直觉”（Golden Gut），当他们稍后坐下来构思解决问题的可能界面时，这种直觉会发挥作用。

---

### [00:35:57] Scott Belsky

**English:**
So I love bringing design upstream. In fact, that's probably been the cheat code of my career as a product leader, has just been disproportionately empowering design throughout the process. I think what we're going to start seeing is generative AI augmenting the designer's work in real time. So right now, I mean in Photoshop, we're experimenting with instead of just reducing an image and cropping, you can also extend an image. And that's, of course, using generative AI for outpainting.

**中文翻译:**
所以我喜欢把设计往上游推。事实上，这可能是我作为产品领导者职业生涯中的“作弊码”，就是在整个过程中不成比例地赋予设计权力。我认为我们将开始看到生成式 AI 实时增强设计师的工作。比如现在，在 Photoshop 中，我们正在实验：不仅可以缩小图像和裁剪，还可以“扩展”图像。当然，这是利用生成式 AI 进行“外绘”（Outpainting）。

---

### [00:36:47] Scott Belsky

**English:**
I think that that's going to happen far more. And hopefully, product designers, product managers will be involved to some extent in some of these decision points as designers have more options to choose from.

**中文翻译:**
我认为这种情况会发生得越来越多。希望随着设计师有更多选项可供选择，产品设计师和产品经理能在某种程度上参与到这些决策点中。

---

### [00:36:59] Lenny

**English:**
You threw out this term golden gut. What is that about?

**中文翻译:**
你提到了“黄金直觉”（Golden Gut）这个词。那是什么意思？

---

### [00:37:02] Scott Belsky

**English:**
The golden gut is when you're designing an experience and a flow. You are playing around with all kinds of options. You're moving things around. You're saying, "Actually, that's too complicated. Maybe I'll separate this one page into three steps as opposed to one page with three steps in a row. How do I break this down? How do I simplify?" You sometimes have instincts like, "Well wait, what if I just remove this all together? What if you didn't even have this whole series of steps? What if I just had a presumptuous default instead and customers could change it if they think they need to?"

**中文翻译:**
“黄金直觉”是指当你设计一个体验和流程时，你在尝试各种选项。你移动各种元素，你会说：“实际上，这太复杂了。也许我应该把这一页分成三个步骤，而不是一页排三个步骤。我该如何拆解？如何简化？”你有时会有直觉，比如：“等等，如果我把这个完全删掉呢？如果根本不需要这一系列步骤呢？如果我只提供一个预设的默认值，如果客户觉得需要再自己去改呢？”

---

### [00:37:39] Scott Belsky

**English:**
And in some of those sorts of, I wonder if, I wonder if, I wonder if, to me is the difference between a very junior product thinker and a very experienced product thinker? I think experienced product thinkers with that golden gut of, "Oh my gosh. Wait, reduction of cognitive load." Maybe even if 10% of people get confused to get 90% of people far faster through this process is a big win and a great opportunity cost trade off. I think those sorts of little micro-decisions that we make in the process of building products, that's the golden gut.

**中文翻译:**
这种“如果……会怎样”的思考，对我来说就是一个初级产品思考者和资深产品思考者之间的区别。我认为资深的产品思考者拥有那种黄金直觉，会想到：“天哪，等等，减少认知负荷。”也许即使有 10% 的人会感到困惑，但能让 90% 的人更快地完成流程，这就是一个巨大的胜利，也是一个极佳的机会成本权衡。我认为我们在构建产品过程中做出的那些微小决策，就是“黄金直觉”。

---

### [00:38:13] Lenny

**English:**
I love it. I have not heard that term before. For PMs listening and they're like, "Okay, AI's happening. I don't know what to do," what would be your advice for them to stay ahead and be aware of where things are going and not be left behind?

**中文翻译:**
太棒了，我以前没听过这个词。对于正在听播客、心想“好吧，AI 来了，但我不知道该怎么办”的 PM 们，你有什么建议能让他们保持领先、洞察趋势而不被时代抛弃？

---

### [00:38:28] Scott Belsky

**English:**
Quite simply in one word, play. We all have to be playing with this technology. We have to find ways. The risk of becoming more experienced in your career is you get stuck in your ways. And you're like, "Ah, no. I don't need to have that automatic draft in my email and get ChatGPT to suggest what I want to respond with. I'm fine without that." Make sure you try it. Make sure you play with it. Write poems for your friends. Try a lot of these various generative AI tools out there just to see what's possible and pursue every curiosity.

**中文翻译:**
很简单，就一个词：玩（Play）。我们都必须去玩这项技术。我们必须找到方法。职业生涯变得资深的风险在于你会固步自封。你会觉得：“啊，不，我不需要邮件里的自动草稿，也不需要 ChatGPT 建议我怎么回。没有那个我也行。”一定要去尝试，一定要去玩。给朋友写写诗，尝试各种生成式 AI 工具，看看什么是可能的，追随你的每一个好奇心。

---

### [00:39:06] Scott Belsky

**English:**
The reason I started the Implications newsletters is because I was seeing this high velocity of new stuff every day. And I'm like, "I have to force myself to make sure I understand all of this and think about how these implications will change my business as well as the world that I operate in." And there was no better way to do that than to have to write about it, and promise my readers I'll get a monthly thing out there. So I just think we all have to do some version of that.

**中文翻译:**
我创办《启示》（Implications）时事通讯的原因是，我看到每天都有大量新事物涌现。我想：“我必须强迫自己去理解这一切，并思考这些影响将如何改变我的业务以及我所处的世界。”而要做到这一点，没有比必须写下来并向读者承诺每月更新更好的方法了。所以我认为我们都应该做类似的事情。

---

### [00:39:33] Lenny

**English:**
Let's plug Implications while we're at it. How do people go subscribe or do they find it?

**中文翻译:**
顺便给《启示》打个广告。大家怎么订阅或者在哪里能找到它？

---

### [00:39:38] Scott Belsky

**English:**
Yeah. No. It's implications.com. So it's easy to find, but it's a monthly exercise where throughout the month, I try to capture a few things I think are important. And I really try to go deep down the rabbit hole of what the implications are for various parts of our work and life. And it's been a fun exercise. And also, I get some good polarizing feedback in the process.

**中文翻译:**
是的，就是 implications.com。很容易找到。这是一个每月的练习，在整个月中，我会尝试捕捉一些我认为重要的事情。我会深入钻研这些事情对我们工作和生活的各个方面意味着什么。这是一个有趣的练习，而且在这个过程中，我也收到了一些非常两极分化的反馈。

---

### [00:40:02] Lenny

**English:**
Oh you do? Interesting. You should share that. That'd be interesting, is here's what I'm getting in response to the stuff I'm writing. This also touches on a thread that comes up a lot on this podcast, is the power of just writing to help you think through stuff. A lot of people think my newsletters, I'm just sharing all these things I know. I'm just like, "I know it in my head. I'm just going to share it in the thing." But it's more. The writing helps me figure it out and gives me an excuse. And like you said, it's a forcing function to spend the time crystallizing it. And so, that's another reminder for that.

**中文翻译:**
噢，是吗？真有趣。你应该分享一下，看看大家对你写的东西有什么反应。这也触及了本播客经常提到的一个话题：写作在帮助你理清思绪方面的力量。很多人认为我的时事通讯只是在分享我知道的所有事情，觉得“我脑子里已经知道了，只是分享出来”。但远不止于此。写作帮助我弄清楚问题，给了我一个借口。正如你所说，它是一个“强制函数”，迫使你花时间去提炼。所以，这是对写作力量的又一次提醒。

---

### [00:40:29] Scott Belsky

**English:**
And capturing those things, I think, the thing I've kind of learned over the years with writing and also with product development is sometimes you capture these little glimpses and things or sketches, and they become relevant years later. So don't always capture and write because of a foreseeable need for that content. Consider it almost like a back burner that you're constantly tending to. And imagine that three years from now, the stars will align, and this will become invaluable content or some crucial idea for a problem you're facing at the moment.

**中文翻译:**
捕捉这些东西，我想，这些年来我在写作和产品开发中学到的是，有时你捕捉到的这些小灵感、小片段或草图，会在几年后变得非常有意义。所以，不要总是因为预见到对内容的需求才去捕捉和写作。把它看作是一个你不断照看的“后备炉灶”。想象一下，三年后，时机成熟，这些东西会变成无价的内容，或者成为解决你当时面临问题的关键想法。

---

### [00:41:03] Lenny

**English:**
There's a lot of people actually in your shoes that want to write more and put content out, but that also have a full-time job with a lot of things on your plate. Any advice for actually getting it done the way you've been getting it done?

**中文翻译:**
实际上有很多像你一样的人，想写更多东西、发布更多内容，但同时也有一份全职工作，手头有很多事。对于如何像你一样真正把这件事做成，你有什么建议吗？

---

### [00:41:15] Scott Belsky

**English:**
Listen, there's no hack to it other than ruthlessness of time and prioritization saying no to most things. This morning, I went for a run and I was like, "I have 40 minutes exactly until I have to get in the shower and I have to be somewhere in 30 minutes from that moment." I'm going to take those 40 minutes or at least 35 of them, and I'm going to write. I don't care if I write five words or five pages. And it's just a great... Without that discipline though, as you said, it's super hard to get it in the seams of the schedule.

**中文翻译:**
听着，除了对时间的冷酷管理和优先级排序（对大多数事情说“不”）之外，没有什么捷径。今天早上我去跑步，我想：“我正好有 40 分钟，然后我必须去洗澡，再过 30 分钟我得赶到某个地方。”我就利用这 40 分钟，或者至少 35 分钟，去写作。我不在乎是写了五个字还是五页纸。这很棒……但如果没有这种自律，正如你所说，很难在日程的缝隙中挤出时间。

---

### [00:42:12] Lenny

**English:**
Speaking of discipline, you wrote a book called The Messy Middle. And without even talking about what it is, title's pretty... I think people feel like, "I get it." And imagine many people listening are founders or PMs that are feeling like they're in this messy middle. What is one piece of advice for people in this period that you think might help them through the messy middle?

**中文翻译:**
说到自律，你写了一本书叫《混乱的中期》（The Messy Middle）。甚至不用解释内容，书名就很……我想人们会觉得“我懂这种感觉”。想象一下，很多听众是创始人或 PM，他们正感觉自己处于这种混乱的中期。对于处于这个阶段的人，你认为有什么建议能帮助他们度过难关？

---

### [00:42:32] Scott Belsky

**English:**
The bottom line is that these years in the middle of whether it's a venture, new startup, old turnaround within a big company, they are messy because they are full of lows. It's very volatile. When you're in those lows, you need to find a way to endure them. You need to endure the anonymity and uncertainty and anxiety. I'm sure a lot of listeners, whether they're in big companies or starting their own company, it's hard to be doing something that no one knows or cares about.

**中文翻译:**
底线是，无论是一个新项目、一家初创公司，还是大公司内部的老业务转型，中间的这些年都是混乱的，因为充满了低谷。它非常动荡。当你处于低谷时，你需要找到一种方法去忍受。你需要忍受默默无闻、不确定性和焦虑。我敢肯定很多听众，无论是在大公司还是在创业，做一件没人知道、没人关心的事是很艰难的。

---

### [00:43:01] Scott Belsky

**English:**
And I always like to remind myself that the life expectancy of humans a hundred plus years ago was 25 years old. So the idea of spending three to five years of your life on something, especially if it might fail, was a bad decision. And I think biologically, we feel the need for constant rewards and affirmation to stick with something long enough. And in fact, most of your listeners were all building things that take many, many years to defy the odds. And we have to overcome our natural human tendencies in this instance by sticking together long enough to figure it out.

**中文翻译:**
我总喜欢提醒自己，一百多年前人类的预期寿命只有 25 岁。所以，花生命中的三到五年去做某件事，尤其是如果它可能会失败，那在当时是个糟糕的决定。我认为从生物学上讲，我们需要不断的奖励和肯定才能坚持足够长的时间。事实上，你的大多数听众都在构建那些需要多年才能创造奇迹的东西。在这种情况下，我们必须克服人类的自然倾向，团结在一起足够长的时间来解决问题。

---

### [00:43:16] Scott Belsky

**English:**
So how do you do that? I mean, obviously, part of it is culture, wanting to serve the customers you serve and working with the team you are working with and that being enough to kind of stick it long enough. I think part of it is short-circuiting the reward system, finding micro goals and milestones that are mutually agreed upon. We're going to celebrate these even though in the greater scheme of things, they don't matter much. I think that's a key part of keeping the team and keeping the dream alive.

**中文翻译:**
那么该怎么做呢？显然，一部分是文化，即想要为你所服务的客户服务，并与你的团队共事，这足以让你坚持下去。我认为另一部分是“短路”奖励系统，寻找共同商定的微小目标和里程碑。我们要庆祝这些，尽管从大局来看，它们可能没那么重要。我认为这是保持团队活力和梦想不灭的关键部分。

---

### [00:43:39] Scott Belsky

**English:**
I always like to use the analogy of we're driving our teams across country as product leaders with the windows blacked out in the backseat and everyone's sitting in the backseat. And so, if they don't know what we're doing that we're making progress, this traffic is clearing, we just cross state lines. If they don't receive the narrative, they will go stir-crazy. And so there's a lot of research around progress, be getting progress and how progress is a source of motivation. And so as product leaders, we have to merchandise progress. We have to be the steward of this narrative.

**中文翻译:**
我总喜欢用这个类比：作为产品领导者，我们正载着团队横穿全国，但后座的窗户被涂黑了，大家都坐在后座。如果他们不知道我们在做什么，不知道我们在取得进展（比如堵车缓解了，或者我们刚刚跨过了州界），如果他们没有接收到这种叙事，他们会发疯的。有很多关于“进展产生进展”以及“进展如何成为动力源泉”的研究。所以作为产品领导者，我们必须“推销”进度（Merchandise progress）。我们必须成为这种叙事的守护者。

---

### [00:44:19] Lenny

**English:**
And you touched on this a bit as you were just talking, but there's also this moment where it makes sense to quit like you shouldn't stay with things endlessly. And I guess any advice on just when something is like, "Okay, you should probably move on from this." Makes me think a little bit about there's all these companies that just keep going that maybe shouldn't keep going because they have enough money or they're just like, "No, founders never quit." Any advice or thoughts that you share there?

**中文翻译:**
你刚才也提到了这一点，但也有一些时刻，放弃是合理的，你不应该无休止地坚持下去。我想问，对于什么时候该说“好吧，也许该放手了”，你有什么建议吗？这让我想起有很多公司一直在硬撑，也许它们不该继续，只是因为它们还有钱，或者因为“创始人永不言弃”这种信条。你有什么建议或想法可以分享吗？

---

### [00:45:12] Scott Belsky

**English:**
Yeah. I've had this conversation quite a few times over the years with founders and friends who were running a company going sideways or worse and have had this question, "Should I continue or not?" I always have the same answer. I basically say, and I really ask, "How much conviction do you have in the solution you're building?" I know in the beginning before you knew all you know now, you had tons of conviction. That's what caused you to leave your job. That's what caused you to take all this risk and hire people and raise money and all this stuff. Now, knowing all you know, do you have more or less conviction in the problem and the solution you're building?

**中文翻译:**
是的。这些年来，我曾多次与那些公司经营不善甚至陷入困境的创始人和朋友交流，他们总会问：“我该不该继续下去？”我的回答总是一样的。我基本上会说，而且我会认真地问：“你对你正在构建的解决方案有多少信念？”我知道在刚开始的时候，在你还没了解到现在的这些情况之前，你充满了信念。那是让你辞掉工作的原因，是让你承担所有这些风险、雇人、融资的原因。现在，在了解了所有情况之后，你对这个痛点和你正在构建的解决方案，信念是增加了还是减少了？

---

### [00:45:49] Scott Belsky

**English:**
And I'll tell you, I get different answers. So some people are like, "Oh, Scott, I mean I have more conviction. All that I've learned, all the validation I've received from customers, we just haven't figured it out yet. It's driving me crazy. We've tried three times, and it's still like each product fails, but I have more conviction than ever before." And for those people, I'm like, "You know what? You're just in the messy middle. Stick with it. This is par for the course." But oftentimes, I'll hear, "Honestly, if I knew then what I know now, I would not have done this. Holy shit." I'm like, "Then quit." Your life is short. You have a great team. Pivot. Do something completely different. If you've lost conviction, you should not be doing what you're doing in the world of entrepreneurship.

**中文翻译:**
我会告诉你，我得到的答案各不相同。有些人会说：“噢，Scott，我的信念更强了。基于我学到的一切，以及从客户那里得到的验证，我们只是还没完全搞定。这快让我疯了。我们尝试了三次，每次产品都失败了，但我比以往任何时候都更有信心。”对于这些人，我会说：“你知道吗？你只是处在‘混乱的中期’。坚持下去，这是必经之路。”但通常，我也会听到：“老实说，如果我当时知道现在这些情况，我根本不会开始。天哪。”我会说：“那就放弃吧。”人生苦短。你有一个优秀的团队，转型吧，去做完全不同的事情。如果你失去了信念，你就不应该在创业的世界里继续做你现在正在做的事。

---

### [00:46:27] Scott Belsky

**English:**
I think so. But at the same time, listen, we all have ups and downs. We all have good days and bad days. However, I do think that great founders are just... They absolutely know in their core that something needs to exist, and they will just be ruthless and relentless until it does. But if you lose that, I actually don't know if you have the fuel to continue. So listen, you're right. Don't make a bold decision on a bad day. But if the conviction generally dissipates, be open-minded about other options.

**中文翻译:**
我想是的。但与此同时，听着，我们都有起伏，都有顺境和逆境。然而，我确实认为伟大的创始人……他们从内心深处绝对相信某样东西必须存在，并且会冷酷无情、坚持不懈地直到它实现。但如果你失去了这一点，我真的不知道你是否还有动力继续下去。所以，你是对的，不要在糟糕的一天做出重大的决定。但如果信念普遍消散了，请对其他选择保持开放的心态。

---

### [00:47:03] Lenny

**English:**
You do a lot of angel investing, talked to a lot of founders. What is it that you look for? What do you think is important for a startup to show you for it to feel like a good bet that it'll likely work out? What are some of the important attributes that you look for?

**中文翻译:**
你做了很多天使投资，和很多创始人聊过。你寻找的是什么？你认为初创公司向你展示什么才是重要的，能让你觉得这是一个很可能成功的赌注？你寻找的重要特质有哪些？

---

### [00:47:22] Scott Belsky

**English:**
On team, I really value founders who listen, who really learn, who long to shake shit up a bit, and also value the mission that they're on more than the money that it yields because I do think that especially during a period of time where you don't have revenue, you're going to need to be motivated by something grander and bolder than revenue. I also have an allergic reaction to founders that are real promoters who are constantly trying to sugarcoat the truth, who like to gloss over the hard parts.

**中文翻译:**
在团队方面，我非常看重那些懂得倾听、真正学习、渴望打破常规的创始人，并且看重使命感胜过金钱回报。因为我认为，尤其是在没有收入的时期，你需要被比收入更宏大、更勇敢的东西所激励。我也对那些只会“推销”、总是试图粉饰太平、喜欢掩盖困难部分的创始人有排斥反应。

---

### [00:48:15] Scott Belsky

**English:**
I've always admired leaders that are optimistic about the future but very pragmatic and somewhat pessimistic about the present. So the founders that I have a great sort of chemistry with are people who are like, "This is how big the market is. This is how amazing this is. I know this needs to exist. But we've got a lot to figure out. There are things that are not working. We don't have these data sets. These are the major obstacles we're struggling with. These are the things that keep me up at night." Those are real people.

**中文翻译:**
我一直钦佩那些对未来乐观但对现状非常务实、甚至带点悲观的领导者。所以，与我最有默契的创始人是这样的人，他们会说：“市场有这么大，这太神奇了，我知道这必须存在。但我们还有很多事情要弄清楚。有些事情行不通。我们没有这些数据集。这些是我们正在挣扎的主要障碍。这些是让我彻夜难眠的事情。”这些人才是真实的。

---

### [00:48:37] Scott Belsky

**English:**
And you know that in that volatile messy middle that they're going to inevitably go through that their team, their investors are going to have the real truth and they're going to be able to engage and find solutions. So I really love finding those types of founders, and I'm very wary of the name-dropping overly promoting folks who are unlikely to be able to partner in that way. On the product side, I'm looking for an object model way of thinking about a product that I am confident the will scale and as they solve their problem.

**中文翻译:**
你知道，在他们不可避免要经历的动荡的“混乱中期”里，他们的团队和投资者将掌握真实的真相，并能够参与其中寻找解决方案。所以我非常喜欢寻找这类创始人，而对那些喜欢攀附名流、过度推销、不太可能以这种方式合作的人保持警惕。在产品方面，我寻找的是一种“对象模型”（Object Model）式的产品思维，让我确信它在解决问题的同时能够扩展。

---

### [00:49:11] Scott Belsky

**English:**
When I say object model, what I mean is it clear whenever you're seeing the product, how it works, where you came from, where you're going? Those are the three questions I always ask when I'm doing product reviews. It's like, "How did I get here? What do I do now? And what do I do next?" And I feel like every screen and every product experience, you should be able to answer those three questions. Sometimes, I'll be talking to a team that says they're design driven, says that they're building a incredible product, and they'll show me a demo and I'm like, "This is all over the place."

**中文翻译:**
我说的“对象模型”，是指当你看到产品时，它如何运作、你从哪里来、你要去哪里，这些是否清晰？这是我在进行产品评审时总会问的三个问题：“我是怎么到这里的？我现在要做什么？我下一步要做什么？”我觉得在每一个屏幕和每一个产品体验中，你都应该能回答这三个问题。有时我会和一些自称是设计驱动、正在构建惊人产品的团队聊天，他们给我看演示，我心想：“这简直是一团乱麻。”

---

### [00:49:53] Lenny

**English:**
And you focus primarily on consumer or do you invest all over the place?

**中文翻译:**
你主要关注消费领域，还是到处都投？

---

### [00:49:58] Scott Belsky

**English:**
Yeah. No. I'm pretty agnostic. I look for product design-oriented teams making things that need to exist. Beyond that, I try not to be too prescriptive.

**中文翻译:**
是的，我不设限。我寻找那些以产品设计为导向、制造必须存在的东西的团队。除此之外，我尽量不设定太多条条框框。

---

### [00:50:06] Lenny

**English:**
Okay. Excellent. Any last words of wisdom that you think impact the way people build product in the world that tens of thousands, hundreds of thousands of listeners listening? Is there anything else you want to share before we get to our very exciting lightning round?

**中文翻译:**
好的，太棒了。对于成千上万正在收听的听众，关于人们构建产品的方式，你还有什么最后的智慧之言吗？在进入我们非常精彩的闪电问答环节之前，还有什么想分享的吗？

---

### [00:50:20] Scott Belsky

**English:**
Two quick things. One, for the moment that we're in, and then one for why we do what we do. For the moment that we're in, we're in a resource-constrained environment. Let's face it. We're all going to have less money, fewer headcount, all that kind of stuff. And I've always found that resourcefulness brings you further than resources despite the fact that over the last seven to 10 years, we've basically thrown resources at every problem.

**中文翻译:**
两件简短的事。第一，关于我们所处的当下；第二，关于我们为什么做这些事。关于当下，我们处于一个资源受限的环境。面对现实吧，我们的钱会变少，人头数会变少，诸如此类。我一直发现，“足智多谋”（Resourcefulness）比“资源”（Resources）能让你走得更远，尽管在过去的七到十年里，我们基本上是靠砸资源来解决每一个问题的。

---

### [00:51:11] Scott Belsky

**English:**
We are in this era now where we're being forced to be resourceful and to refactor as opposed to hire and throw resources at problems. I think that's a great opportunity. I feel like this is where the best teams are going to build that muscle, that are going to go the distance. That's why all these VCs say it's so cliche that the best companies are always built in errors like these. So my point number one is capitalize on the crisis, everyone. If resources are carbs, resourcefulness is like muscle. It stays with you. It makes you stronger, and it helps you have a better intuition and better performance over time.

**中文翻译:**
我们现在正处于一个被迫变得足智多谋、被迫重构，而不是通过雇人和砸资源来解决问题的时代。我认为这是一个巨大的机会。我觉得这是最好的团队锻炼这种“肌肉”的时候，也是他们能走得更远的时候。这就是为什么所有风投都说（虽然很陈词滥调）最好的公司总是在这样的错误时代建立的。所以我的第一点是：各位，利用好危机。如果资源是碳水化合物，那么足智多谋就是肌肉。它会伴随你，让你更强大，并帮助你随着时间的推移拥有更好的直觉和表现。

---

### [00:51:33] Scott Belsky

**English:**
And then, I guess taking a step back, I would just encourage folks to recognize that anything amazing in the venture world is ultimately an exception. And with all of the best practices, Lenny, that you and I just discussed and all the stuff that we read and books and whatever else, I always try to remind myself that at the end of the day, sometimes, exceptions are the rule when it comes to doing something truly transformative and that nothing extraordinary is ever achieved through ordinary means.

**中文翻译:**
然后，退一步说，我只想鼓励大家认识到，创业世界中任何惊人的成就最终都是一个“例外”。尽管有 Lenny 你和我刚才讨论的所有最佳实践，以及我们读过的所有资料和书籍，我总是尝试提醒自己：归根结底，当涉及到做一些真正具有变革意义的事情时，有时“例外”才是常态，而且任何非凡的成就都不是通过平凡的手段实现的。

---

### [00:52:41] Lenny

**English:**
Love that. Speaking of extraordinary, I thought it'd be cool to just give you a chance to talk about what you're doing at Adobe. What are some of the products that you're working on? What should folks know about potentially what's happening in Adobe they may not be aware of?

**中文翻译:**
太棒了。说到非凡，我想给你一个机会谈谈你在 Adobe 正在做的事情。你正在开发哪些产品？关于 Adobe 正在发生的事情，有哪些是大家可能还不知道但应该了解的？

---

### [00:52:53] Scott Belsky

**English:**
Yeah. No. Thanks for asking. For us, I would say there's really three trends that are driving or three waves of transformation, I would say, that are driving the strategy right now for us. One is just that people are becoming more creatively confident. It's kind of wild that we're like most confident as five-year-olds creatively when we're drawing and our parents are like, "Oh my God, that's beautiful. That's amazing. Let's put it on the fridge." And then creative confidence kind of goes down from there for most adults, and that's really sad.

**中文翻译:**
是的，谢谢你的提问。对我来说，目前有三个趋势或三波变革浪潮正在驱动我们的战略。第一，人们正变得在创意上更加自信。挺疯狂的是，我们在五岁画画时最有创意自信，父母会说：“天哪，太漂亮了，太棒了，咱们把它贴在冰箱上吧。”但对于大多数成年人来说，创意自信从那以后就开始下降，这真的很令人难过。

---

### [00:53:22] Scott Belsky

**English:**
And with generative AI and tools, we have something called the Adobe Express in market, and our generative AI offering is called Firefly. These types of tools make people feel more creatively confident right away. It's pretty amazing to see people that would never pick up a pen and draw or suddenly feeling confident. So I would say that's like wave number one. Wave number two that we talked about a little earlier is the fact that creative professionals can now explore 10X the surface area of possibility.

**中文翻译:**
有了生成式 AI 和工具，我们推出了 Adobe Express，我们的生成式 AI 产品叫 Firefly。这类工具能让人们立刻感到更有创意自信。看到那些从不拿笔画画的人突然感到自信，这真的很神奇。所以我会说这是第一波浪潮。第二波浪潮是我们之前提到的：创意专业人士现在可以探索 10 倍的可能性空间。

---

### [00:54:10] Scott Belsky

**English:**
And then, I would say the third wave that's fascinating to me is personalization. I think we talked about this a little bit, our apps will meet us where we are. I think that every marketing experience will be increasingly personalized for each of us. Every commerce experience, they'll know who we are. They'll just show us our shoe size and no one else's. These sorts of transformations will really change the entire world of commerce, and content, and media, and everything else.

**中文翻译:**
然后，我认为对我来说非常迷人的第三波浪潮是“个性化”。我想我们谈过这一点，我们的应用将主动适应我们。我认为每一次营销体验都将对我们每个人越来越个性化。每一次商业体验，他们都会知道我们是谁，只显示我们的鞋码，而不显示别人的。这类变革将真正改变整个商业、内容、媒体以及其他所有领域。

---

### [00:54:50] Lenny

**English:**
I love that. You need a banner of that. It's been amazing to watch Adobe's rise over the last decade. It just felt like it was going nowhere. And all of a sudden, it's a juggernaut. And so, great work, Scott and everyone else involved. But with that, we've reached our very exciting lightning round. I've got six questions for you. We'll try to go through it pretty fast. Sound good?

**中文翻译:**
我喜欢这个。你应该把它印成横幅。看着 Adobe 在过去十年的崛起真的很神奇。以前感觉它停滞不前，突然之间，它变成了一个巨无霸。Scott，你和所有参与者都做得太棒了。那么，我们进入了非常令人兴奋的闪电问答环节。我有六个问题问你，我们尽量快点过。准备好了吗？

---

### [00:55:12] Scott Belsky

**English:**
Sounds good. Let's do it.

**中文翻译:**
听起来不错，开始吧。

---

### [00:55:12] Lenny

**English:**
Let's do it. What are two or three books that you've recommended most to other people?

**中文翻译:**
开始。你向别人推荐最多的两三本书是什么？

---

### [00:55:19] Scott Belsky

**English:**
First is Build by Tony Fadell. Tony is just an amazing, charismatic, deeply pragmatic, product builder. He's been brave enough to do both Atoms and Bits as he says. And his book is just chock-full of wisdom. I do appreciate some of these kind of laws of nature, laws of power type books. I love psychology books. I'm trying to think of some offhand that have really struck me. But understanding the natural human tendencies of people, I think the laws of power talks about tons of wars over centuries and what sorts of natural human tendencies or inequalities drove massive rebellions and revolutions.

**中文翻译:**
第一本是 Tony Fadell 的《创造》（Build）。Tony 是一位了不起的、充满魅力的、极其务实的产品构建者。正如他所说，他勇敢地同时涉足了“原子”和“比特”领域。他的书充满了智慧。我也很欣赏一些关于自然法则、权力法则之类的书。我喜欢心理学书籍。我在想一些让我印象深刻的书。理解人类的自然倾向，我认为《权力 48 法则》谈到了几个世纪以来的无数战争，以及什么样的自然人类倾向或不平等导致了大规模的叛乱和革命。

---

### [00:56:27] Lenny

**English:**
What is a favorite recent movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视节目是什么？

---

### [00:56:29] Scott Belsky

**English:**
What I love is these documentaries about the cosmos and about the edge of our understanding of black holes and what happens out there in space. So I don't remember. I know one is called Cosmos on Netflix. There are a few of them. But in my downtime, I get lost in some series like that.

**中文翻译:**
我喜欢那些关于宇宙、关于我们对黑洞理解的边缘以及外太空发生的事情的纪录片。我不记得具体名字了，我知道 Netflix 上有一个叫《宇宙》（Cosmos）。这类片子有好几部。在休息时间，我会沉浸在这样的系列片中。

---

### [00:56:52] Lenny

**English:**
What are you doing to help them plan for this future?

**中文翻译:**
（关于你的孩子）你正在做些什么来帮助他们为未来做规划？

---

### [00:56:54] Scott Belsky

**English:**
I think about this all the time. What are our children going to do in a world where if you believe Vinod Khosla's prediction that 80% of the work, of 80% of jobs will be replaced by AI, what will people do? As we talked about their ingenuity will be unleashed, that's great. But ultimately, I always revert back to this one belief that if people are passionate, they become successful in something. So I've always just been focused on trying to make sure that they find something they're super passionate about.

**中文翻译:**
我一直在思考这个问题。如果相信 Vinod Khosla 的预测，即 80% 的工作中 80% 的任务将被 AI 取代，那么我们的孩子在这个世界上该做什么？正如我们讨论过的，他们的创造力将被释放，这很好。但最终，我总是回到这样一个信念：如果人们充满激情，他们就会在某件事上取得成功。所以我一直专注于确保他们能找到自己超级热爱的事情。

---

### [00:58:01] Lenny

**English:**
Love that. What's a favorite interview question you like to ask when you're interviewing people?

**中文翻译:**
太棒了。面试时你最喜欢问的问题是什么？

---

### [00:58:05] Scott Belsky

**English:**
There's a real one, and there's a snarky one. So I do love trying to understand if people are introspective. And so, I like asking about something people have learned about themselves that reveal the limitation in how they work. It's a way to test introspection. And once this person hits their limits or struggles, can they be open and introspective or are they going to blame and point fingers? So I do ask that. I also like the question, like, "Do you consider yourself lucky?" I think it's a fascinating question because also some people who are super insecure about where they are and how they got there and might decline admitting luck, those who are comfortable should admit that they were lucky.

**中文翻译:**
有一个正经的，还有一个带点刁难意味的。我喜欢了解一个人是否有反思能力。所以我喜欢问：你从自己身上学到了什么，揭示了你在工作方式上的局限性？这是一种测试反思能力的方法。当这个人遇到极限或困难时，他们能保持开放和反思吗，还是会推卸责任、指责他人？所以我确实会问这个。我还喜欢问：“你觉得自己幸运吗？”我认为这是一个迷人的问题，因为有些对自己所处位置和成就感到极度不安全的人可能会拒绝承认运气，而那些坦然的人应该承认自己很幸运。

---

### [00:59:05] Lenny

**English:**
What's a favorite recent product you've discovered, app or physical product? Anything that comes to mind?

**中文翻译:**
最近发现的最喜欢的产品是什么，应用或实物产品都可以？

---

### [00:59:10] Scott Belsky

**English:**
I've been playing with a product called Queue. And it's Q-U-E-U-E, I think. And it's basically a way to keep a queue of all of this content you want to watch across every streaming platform because there's so much content across so many streaming platforms and to make your own queue and then to see your friends queues and to see what content is in most of the people you know queues, it's actually an incredible graph of kind of stuff that people want to watch or have liked that I think we're going to need in this world where there is just a billion sources of content.

**中文翻译:**
我一直在玩一个叫 Queue 的产品。我想拼写是 Q-U-E-U-E。它基本上是让你把想在各个流媒体平台上看的内容都排成一个队列，因为现在的流媒体平台和内容太多了。你可以建立自己的队列，看朋友的队列，看你认识的人里大多数都在看什么。它实际上是一个关于人们想看或喜欢的内容的惊人图谱，我认为在这个有无数内容来源的世界里，我们需要这样的东西。

---

### [00:59:44] Lenny

**English:**
I'm definitely going to check that out. What's a favorite AI tool that you've recently discovered or find useful that isn't something Adobe has made?

**中文翻译:**
我一定要去看看。除了 Adobe 做的东西，你最近发现或觉得好用的最喜欢的 AI 工具是什么？

---

### [00:59:59] Scott Belsky

**English:**
Okay. Well, I will mention if it's okay a product that I did invest in. But it's a product called Tome. And they can take a narrative that you want to put into a presentation, and with AI basically create just a draft of this presentation with imagery and compelling points. And it's almost as if you handed this off to an intern and said, "Come back to me with something I can work with." And suddenly, it's instantly there. So that's been like a fun one to play with.

**中文翻译:**
好吧，如果不介意的话，我提一个我投资的产品。它叫 Tome。它可以根据你想放在演示文稿里的叙述，利用 AI 自动生成一份包含图像和有力论点的草稿。这简直就像你把它交给一个实习生说：“给我弄个我能用的初稿出来”，然后它瞬间就完成了。玩起来挺有意思的。

---

### [01:01:00] Lenny

**English:**
Scott, this is the first time we've ever chatted. But I feel like I know you. You are wonderful. Thank you so much for being here. Two final questions, where can folks find you online if they want to reach out, learn more? And how can listeners be useful to you?

**中文翻译:**
Scott，这是我们第一次聊天，但我感觉好像已经认识你很久了。你太棒了，非常感谢你能来。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？听众们能为你做些什么？

---

### [01:01:13] Scott Belsky

**English:**
Yeah. No. Awesome. Listen, thanks, Lenny. And your podcasts and your emails are probably among my more forwarded pieces of nuggets and resources that I send to product teams I work with. So thank you for elevating the field for all of us, I should say. And it's an honor to be on this podcast. I'm easy to find, just scottbelsky.com or @scottbelsky on your favorite social network of choice. And implications.com is where I'm writing these days.

**中文翻译:**
太棒了。听着，谢谢你，Lenny。你的播客和邮件可能是我转发给合作的产品团队最多的干货和资源。所以我应该说，谢谢你提升了我们整个行业的水平。能参加这个播客是我的荣幸。找我很简单，访问 scottbelsky.com 或者在任何社交网络上搜索 @scottbelsky。implications.com 是我最近写作的地方。

---

### [01:01:45] Scott Belsky

**English:**
And then, you know what? I welcome folks to share what they're working on. I just love taking as much data points as possible. I love connecting dots for people and making introductions. I feel like that can be a contribution to this whole world of better and better products, and I welcome you to reach out.

**中文翻译:**
还有，你知道吗？我欢迎大家分享他们正在做的事情。我喜欢尽可能多地获取数据点。我喜欢为人们牵线搭桥、做介绍。我觉得这可以为创造越来越好的产品世界做出贡献，欢迎大家联系我。

---

### [01:02:04] Lenny

**English:**
Awesome. Scott, again, thank you for being here.

**中文翻译:**
太棒了。Scott，再次感谢你的到来。

---

### [01:02:06] Scott Belsky

**English:**
Thanks, Lenny.

**中文翻译:**
谢谢，Lenny。

---

### [01:02:07] Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。