# Sean Ellis - 双语对照

This bilingual document captures the key insights from Lenny Rachitsky's interview with Sean Ellis, the creator of the "Sean Ellis Test" and the person who coined the term "Growth Hacking."

---

### [00:00:00] Lenny Rachitsky

**English:**
The Sean Ellis test, such a seemingly simple idea that has had such a profound impact on the startup world.

**中文翻译:**
肖恩·埃利斯测试（Sean Ellis Test），这个看似简单的想法，却对创业界产生了如此深远的影响。

---

### [00:00:07] Sean Ellis

**English:**
The question is, how would you feel if you could no longer use this product? Once you got a high enough percentage of users saying they'd be very disappointed, most of those products did pretty well. If you felt too low, those products tended to suffer.

**中文翻译:**
核心问题是：“如果你不能再使用这个产品，你会有什么感受？”一旦有足够高比例的用户表示他们会“非常失望”，大多数这类产品都表现得很好。如果这个比例太低，这些产品往往会面临困境。

---

### [00:00:25] Sean Ellis

**English:**
Just ignore the people who say they'd be somewhat disappointed. They're telling you it's a "nice to have." If you start paying attention to what your somewhat disappointed users are telling you and then you start tweaking onboarding and product based on their feedback, maybe you're going to dilute it for your "must have" users.

**中文翻译:**
直接忽略那些说“有点失望”的人。他们其实是在告诉你，你的产品只是“有则更好”（nice to have）。如果你开始关注这些“有点失望”的用户反馈，并根据他们的意见调整新用户引导（onboarding）和产品功能，你可能会削弱产品对那些“核心必备”（must have）用户的吸引力。

---

### [00:00:45] Sean Ellis

**English:**
It's usually much more function of onboarding to the right user experience than it is about the kind of the tactical things that people try to do to improve retention.

**中文翻译:**
提升留存率（retention）通常更多地取决于如何通过新用户引导（onboarding）带给用户正确的体验，而不是人们通常尝试的那些零散的增长战术。

---

### [00:01:03] Lenny Rachitsky

**English:**
Today, my guest is Sean Ellis. Sean is one of the earliest and most influential thinkers and operators in the world of growth. He coined the term growth hacking, invented the ICE prioritization framework, was one of the earliest people to use freemium as a growth strategy, and maybe most famously developed the Sean Ellis test to help you understand if you have product market fit (PMF).

**中文翻译:**
今天的嘉宾是肖恩·埃利斯。肖恩是增长领域最早、也最具影响力的思想家和实践者之一。他提出了“增长黑客”（growth hacking）一词，发明了 ICE 优先级框架（从影响力 Impact、信心 Confidence、简易性 Ease 三个维度排序），是早期将“免费增值”（freemium）作为增长策略的先驱之一。当然，他最出名的成就还是开发了“肖恩·埃利斯测试”，用于帮助创业者判断是否达到了产品市场契合点（Product Market Fit, 简称 PMF）。

---

### [00:03:19] Sean Ellis

**English:**
It's a simple question that helps you figure out, does anyone consider your product a must-have? And so the question is, how would you feel if you could no longer use this product? And I give them the choice: very disappointed, somewhat disappointed, or not disappointed. What I'm trying to find are those people who say, "I would be very disappointed," then that's a really powerful vein to dig into.

**中文翻译:**
这是一个简单的问题，旨在帮你弄清楚：是否有人认为你的产品是必不可少的？问题是：“如果你无法再使用这个产品，你会有什么感受？”我给出的选项包括：非常失望、有点失望、或者不失望。我想要找的是那些说“我会非常失望”的人，因为那是值得深入挖掘的极具潜力的用户群体。

---

### [00:06:40] Sean Ellis

**English:**
I would say it's a leading indicator of product market fit. The lagging indicator is, do they actually keep using it? So probably retention cohorts are more accurate, but the problem is, how long do you have to look at a retention cohort before you know that you've actually long-term retained someone?

**中文翻译:**
我会说这个测试是产品市场契合点（PMF）的一个领先指标（leading indicator）。而滞后指标（lagging indicator）则是：用户是否真的在持续使用它？所以留存同类群组（retention cohorts）分析可能更准确，但问题在于，你需要观察留存数据多长时间，才能确定你真的长期留住了某个用户？

---

### [00:09:53] Sean Ellis (Case Study: Lookout)

**English:**
The company called Lookout, it's a mobile security company. When we ran this initial survey, I dug into the 7% who said they'd be very disappointed and found that most of them were focused on the antivirus functionality. So step one was just reposition the product on antivirus. Step two was we streamlined onboarding so that the first thing that they did after signing up was to set up the antivirus and then get a message "you're now protected."

**中文翻译:**
以 Lookout 公司为例，这是一家移动安全公司。当我们进行初步调查时，我深入研究了那 7% 表示“非常失望”的用户，发现他们大多关注杀毒功能。所以第一步就是将产品重新定位（reposition）为杀毒软件。第二步是精简新用户引导流程，让用户注册后的第一件事就是设置杀毒功能，并收到一条“您现在已受保护”的消息。

---

### [00:12:11] Sean Ellis

**English:**
That literally took two weeks to make those changes. Six months later, it was 60% on the score. And then I think they hit the billion dollar valuation four or five years later. Having that kind of finger on the pulse early in the business was important to build the muscle in the business to be really responsive as the market changed.

**中文翻译:**
做出这些改变只花了两个星期。六个月后，测试得分达到了 60%。我想他们在四五年后就达到了 10 亿美元的估值。在业务早期就能这样把握脉搏，对于培养企业的“肌肉记忆”至关重要，使其在市场变化时能迅速做出反应。

---

### [00:13:33] Lenny Rachitsky

**English:**
And just hearing that you can move this score so quickly without even changing the product substantially... I imagine what surprised a lot of people when you think about moving retention often is really hard.

**中文翻译:**
听到你在没有大幅改动产品的情况下就能如此迅速地提高得分……我想这会让很多人感到惊讶，因为通常大家都认为提升留存率是非常困难的。

---

### [00:13:57] Sean Ellis

**English:**
Right. And then that ultimately moving retention is really hard, but it's usually much more function of onboarding to the right user experience than it is about the kind of the tactical things that people try to do to improve retention.

**中文翻译:**
没错。提升留存确实很难，但它通常更多地取决于如何通过引导流程（onboarding）让用户体验到正确的价值，而不是靠那些人们为了提高留存而尝试的各种琐碎战术。