# Shaun Clowes - 双语对照

This is the complete bilingual transcript for **Lenny’s Podcast** featuring **Shaun Clowes**.

---

### [00:00:00] Lenny Rachitsky

**English:**
I love that you have very strong opinion about this, which is just the state of the product management career and how most PMs are not that great.

**中文翻译:**
我很喜欢你对这件事有非常强烈的观点，也就是关于产品经理职业现状的看法，以及为什么大多数 PM（产品经理）其实做得并不出色。

---

### [00:00:08] Shaun Clowes

**English:**
Why is it that product management is still such a relatively undeveloped discipline? We're like 15 to 20 years into this, and so there's something about the current state of product management that isn't getting at the truly important things, the truly value-added things. If we were doctors, you'd be like, "That's totally unacceptable."

**中文翻译:**
为什么产品管理至今仍然是一个相对不成熟的学科？我们已经发展了 15 到 20 年了，但现状中显然有些东西没有触及到真正重要、真正能产生增值的部分。如果我们是医生，这种职业发展水平会被认为是完全不可接受的。

---

### [00:00:24] Lenny Rachitsky

**English:**
What's the answer, Shaun? How do we solve this problem?

**中文翻译:**
答案是什么，Shaun？我们该如何解决这个问题？

---

### [00:00:26] Shaun Clowes

**English:**
In everything always talk from the customer's perspective, from the market's perspective, from the competitor's perspective, the very small number of PMs do that. They get dragged into internal politics, they get dragged into scrum management or scrum execution or product delivery, and you just can't win that way.

**中文翻译:**
在任何事情上，都要始终从客户的角度、市场的角度、竞争对手的角度出发，但极少数 PM 能做到这一点。他们往往被卷入内部政治，被卷入 Scrum 管理、执行或产品交付的琐事中，那样做是赢不了的。

---

### [00:00:40] Lenny Rachitsky

**English:**
You kind of have this hot take that the way AI will most impact product management is data management.

**中文翻译:**
你有一个很犀利的观点：AI 对产品管理影响最大的方式将是数据管理。

---

### [00:00:45] Shaun Clowes

**English:**
Well, you've got this synthesis machine, which is this LLM thing that's going to help you do synthesis, but if it hasn't got all that data to do synthesis on top of, it's got nothing. And so that means that LLMs can only be as good as the data they are given and how recent that data is.

**中文翻译:**
没错，你有了一个“综合机器”，也就是 LLM（大语言模型），它能帮你进行信息综合。但如果没有足够的数据供它综合，它就一无是处。这意味着 LLM 的表现上限取决于它被提供的数据质量以及数据的实时性。

---

### [00:00:58] Lenny Rachitsky

**English:**
In the future, if you can easily clone a B2B SaaS app like Salesforce or Atlassian, what happens to these businesses long-term? Do they just become, are they all in trouble?

**中文翻译:**
在未来，如果可以轻松克隆像 Salesforce 或 Atlassian 这样的 B2B SaaS 应用，这些企业的长期前景会怎样？它们会陷入困境吗？

---

### [00:01:06] Shaun Clowes

**English:**
People really underestimate where the value is created in these applications and they just kind of get it completely wrong.

**中文翻译:**
人们真的低估了这些应用创造价值的核心所在，他们完全搞错了方向。

---

### [00:01:17] Lenny Rachitsky

**English:**
Today my guest is Shaun Clowes. Shaun is chief product officer at Confluent. Previously he was chief product officer at MuleSoft, which is a billion-dollar business within Salesforce. Before that, he was chief product officer of Metromile, a public auto insurance technology company. And prior to that he spent six years at Atlassian where he ran the Jira agile and also built the first ever B2B growth team. He also created two of the most popular Reforge courses, one on retention and engagement and one on data for product managers. Shaun is awesome because he's both very tactical in execution oriented, while also being very philosophical and insightful about the craft of product and growth. In our conversation, Shaun shares why most PMs are not good, what it takes to become a good or great product manager, how he thinks about his career, like a Bingo card and why he indexes towards finding very different roles for every new job that he takes.
(00:02:12):
Why good data is the most important ingredient in AI tools and for product managers working with AI. Also, how to build a great B2B growth team, what he's learned about doing B2B growth and his really interesting take on how AI will and won't disrupt SaaS tools out in the wild. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously. With that I bring you Shaun Clowes. This episode is brought to you by Enterpret. Enterpret unifies all your customer interactions from Gong calls to Zendesk tickets, to Twitter threads, to app store reviews and makes it available for analysis. It's trusted by leading product orgs like Canva, Notion, Loom, Linear, Monday.com, and Strava to bring the voice of the customer into the product development process, helping you build best-in-class products faster.
(00:03:07):
What makes Enterpret special is its ability to build and update customer-specific AI models that provide the most granular and accurate insights into your business, connect customer insights to revenue and operational data in your CRM or data warehouse, to map the business impact of each customer need and prioritize confidently, and empower your entire team to easily take action on use cases like win-loss analysis, critical bug detection, and identifying drivers of churn with Enterpret's AI systems Wisdom. Looking to automate your feedback loops and prioritize your roadmap with confidence like Notion, Canva and Linear, visit E-N-T-E-R-P-R-E-T.com/lenny to connect with the team and to get two free months when you sign up for an annual plan. This is a limited-time offer. That's enterpret.com/lenny.
(00:03:54):
This episode is brought to you by BuildBetter.ai. Back in 2020 when AI was just a toy, BuildBetter bet that it could cut down on a product team's operational BS. Fast-forward to today, 23,000 product teams use purpose-built AI in BuildBetter every day. First, BuildBetter uses custom models to turn unstructured data like product and sales calls, support tickets, internal communications, and surveys into structured insights. It's like having a dedicated data science team. Second, BuildBetter runs those structured insights into workflows, like weekly reports about customer issues, contacts to where PRDS, and user research documents with citations, it even turns stand-ups into action items that automatically get assigned and shared into your tools. Plus, with unlimited seat pricing on all plans, BuildBetter ensures everyone at your company has access to this knowledge, truly no data silos. In a world of AI demos over-promising and under-delivering, see why BuildBetter has a 93% subscription retention. Get a personalized demo and use code Lenny for $100 credit if you sign up now at buildbetter.ai/lenny. Shaun, thank you so much for being here and welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Shaun Clowes。Shaun 是 Confluent 的首席产品官（CPO）。此前，他是 MuleSoft 的 CPO，那是 Salesforce 旗下的一项十亿美元级业务。在此之前，他是上市汽车保险科技公司 Metromile 的 CPO。更早前，他在 Atlassian 工作了六年，负责 Jira Agile，并建立了公司历史上第一个 B2B 增长团队。他还创建了两个最受欢迎的 Reforge 课程：一个是关于留存与参与度，另一个是关于产品经理的数据分析。Shaun 非常出色，因为他既注重执行层面的战术，又对产品和增长的艺术有着深刻的哲学思考和见解。在我们的对话中，Shaun 分享了为什么大多数 PM 不够优秀，成为优秀或卓越 PM 需要具备什么，他如何像玩“宾果卡”一样思考职业生涯，以及为什么他在每份新工作中都倾向于寻找截然不同的角色。
(00:02:12):
他还谈到了为什么优质数据是 AI 工具和使用 AI 的 PM 最重要的原料。此外，还有如何建立出色的 B2B 增长团队，他在 B2B 增长方面的经验，以及他关于 AI 将如何（以及不会如何）颠覆现有 SaaS 工具的有趣见解。如果你喜欢本播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最佳方式，也对本节目有巨大帮助。下面，让我们欢迎 Shaun Clowes。本集由 Enterpret 赞助。Enterpret 统一了你所有的客户互动——从 Gong 通话到 Zendesk 工单，从 Twitter 帖子到应用商店评论，并使其可供分析。它深受 Canva、Notion、Loom、Linear、Monday.com 和 Strava 等领先产品团队的信赖，将客户的声音引入产品开发过程，助你更快打造一流产品。
(00:03:07):
Enterpret 的特别之处在于它能构建并更新针对特定客户的 AI 模型，为你的业务提供最细致、最准确的洞察；它能将客户洞察与 CRM 或数据仓库中的收入和运营数据连接起来，映射每个客户需求的业务影响并自信地确定优先级；它还能让整个团队轻松应对盈亏分析、关键 Bug 检测以及识别流失驱动因素等用例。想要像 Notion、Canva 和 Linear 一样自动化反馈循环并自信地规划路线图吗？访问 enterpret.com/lenny 联系团队，年度计划可获两个月免费。这是限时优惠。
(00:03:54):
本集由 BuildBetter.ai 赞助。早在 2020 年 AI 还只是个玩具时，BuildBetter 就赌它能减少产品团队的运营琐事。快进到今天，每天有 23,000 个产品团队在 BuildBetter 中使用专用 AI。首先，BuildBetter 使用自定义模型将非结构化数据（如产品和销售电话、支持工单、内部沟通和调查）转化为结构化洞察，就像拥有一个专属的数据科学团队。其次，BuildBetter 将这些洞察转化为工作流，如关于客户问题的周报、PRD 背景信息以及带引用的用户研究文档，它甚至能将站会转化为自动分配并共享到工具中的行动项。此外，所有方案均提供无限席位定价，确保公司每个人都能访问这些知识，真正消除数据孤岛。在 AI 演示过度承诺却难以交付的时代，看看为什么 BuildBetter 拥有 93% 的订阅留存率。立即访问 buildbetter.ai/lenny 获取演示并使用代码 Lenny 领取 100 美元抵扣。Shaun，非常感谢你能来，欢迎来到播客。

---

### [00:05:12] Shaun Clowes

**English:**
Thank you, Lenny. It's really awesome to be here.

**中文翻译:**
谢谢你，Lenny。很高兴能来到这里。

---

### [00:05:14] Lenny Rachitsky

**English:**
I've had you on my radar for a long time and I am really excited to finally have you here and big bonus points for having a very beautiful, sultry Australian accent that always helps with the ratings, I think. I don't know if it's causal, but it's correlative.

**中文翻译:**
我关注你很久了，非常激动终于能请到你。另外，你那优美且富有磁性的澳大利亚口音绝对是大加分项，我觉得这对收视率很有帮助。虽然不知道是否有因果关系，但肯定是有相关性的。

---

### [00:05:28] Shaun Clowes

**English:**
I'm glad to be a bit of a curiosity.

**中文翻译:**
很高兴能成为大家好奇的对象。

---

### [00:05:31] Lenny Rachitsky

**English:**
So I want to start with something I totally believe and I love that you have very strong opinion about this, which is just the state of the product management career and how most PMs are not that great and how there's a big opportunity to level up. You just talk about what you've seen there and you're just thinking here.

**中文翻译:**
我想从一个我深信不疑的话题开始，我也很喜欢你对此有非常强烈的观点，那就是产品经理职业的现状：为什么大多数 PM 并不那么优秀，以及为什么这里存在巨大的提升空间。谈谈你所看到的现状和你的思考吧。

---

### [00:05:51] Shaun Clowes

**English:**
Yeah, it's honestly a big conundrum for me. I think it's actually part of... It's grandiose to say so, a bit of my life's work. Why is it that product management is still such a relatively undeveloped discipline? We're 15 to 20 years into this thing. You would've thought that it would be less random than it is. The outcomes are random, the behaviors are random, individual performance is random, seemingly. And so there's something about the current state of product management that isn't getting at the truly important things, the truly value-added things, the right way to think about problems, the right way to think through problems, the abstract reasoning that's needed, there's something that isn't working about it. I spent a long time trying to put my finger on it and then be like, "How do you reproducibly reproduce that?" Reproducibly produce people who can really be really great product managers.
(00:06:39):
The thing is that if you think all the way back to it, I spent a long time as an engineer and people always talk about 10 times engineers and I wanted to be a 10 times engineer. I'll leave it to others to decide to tell you whether or not I was or I wasn't, but certainly I wanted to be and I tried to be a really great engineer. And it must be true that if there's 10 times engineers, and I would argue they definitely are, they must be 10 times product managers too. But at the same time, those 10 times product managers, because product management is ultimately about leverage, so it's about helping other people have dramatically more impact than they would if they were unorganized that they didn't have somebody to organize the goals and what we're trying to achieve, then that means that a 10 times product manager has 100 times return or more because they're 10 timesing the return on 10 times resources.
(00:07:23):
So the outcomes are so wild, like wildly distributed and the benefits are so good that you would've thought that it would've behooved us. There would've been a way that this had evolved and improved and really gotten way crisper than it has, but here we are. I'm not saying that we haven't gotten better, we 100% have, but I think we could all say that we're not reliably producing 10 times product managers every day of the week.

**中文翻译:**
是的，这对我来说确实是一个巨大的谜题。我觉得这甚至可以算是我毕生事业的一部分，虽然这么说有点宏大。为什么产品管理仍然是一个相对不成熟的学科？我们已经搞了 15 到 20 年了，你本以为它会比现在更有规律。但现在，结果是随机的，行为是随机的，个人表现似乎也是随机的。所以，目前的产品管理现状中，有些东西没有触及到真正核心、真正增值的部分，比如思考问题的正确方式、深入剖析问题的逻辑、所需的抽象推理能力——这些方面都出了问题。我花了很长时间试图找出症结所在，然后思考：“如何才能可重复地培养出真正伟大的产品经理？”
(00:06:39):
回想起来，我做了很长时间的工程师。人们总在谈论“10 倍速工程师”，我也曾想成为其中一员。至于我到底是不是，留给别人去评价，但我确实努力想成为一名顶尖工程师。既然存在 10 倍速工程师（我认为绝对存在），那么必然也存在“10 倍速产品经理”。同时，由于产品管理本质上是关于“杠杆”的——即帮助他人产生比无组织状态下大得多的影响力，如果没有人来组织目标和愿景，大家就会一团糟——这意味着一个 10 倍速产品经理能带来 100 倍甚至更多的回报，因为他们是在将 10 倍资源的收益再次放大 10 倍。
(00:07:23):
所以，结果的分布是如此极端，带来的收益是如此巨大，你本以为这个行业应该已经进化得非常成熟、非常清晰了，但事实并非如此。我不是说我们没有进步，我们绝对进步了，但我想大家都会同意，我们现在还无法做到每天都稳定地培养出 10 倍速的产品经理。

---

### [00:07:49] Lenny Rachitsky

**English:**
I love this point and it's especially painful that when someone works with a PM that's not great. There's just this meme of why do I need PMs? PMs are useless, PMs suck, and it just creates that no one's ever like, "Engineers are useless or designers are useless." But there's so many people are like, "I don't need product managers on our team. Never hire a PM," and it just sets the whole profession back.

**中文翻译:**
我非常赞同这一点。尤其是当人们和一个平庸的 PM 共事时，那种痛苦是很明显的。现在有一种梗叫“为什么我需要 PM？”、“PM 没用”、“PM 很烂”。从来没有人会说“工程师没用”或“设计师没用”，但却有很多人说“我们团队不需要产品经理，千万别雇 PM”。这让整个职业的发展都倒退了。

---

### [00:08:12] Shaun Clowes

**English:**
When I first started out in PM somebody, it's obviously a chestnut, but he pointed out that realistically when you're a product manager, your job is to say no to 90% of things that get brought your way. And so that kind of makes you the bad person pretty much from the start. And so you're saying no to 90%, so you can say yes to 10% and that kind of puts you behind the eight-ball right at the very beginning, and so you have to very quickly get runs on the board. You have to prove to have the right insights, to have the right data, to make the right decisions or you don't get another go, you don't get another swing at it. So it makes sense that product managers are the easiest to single out and criticize, but that is also what makes it the funnest thing.
(00:08:52):
If you think about why do we do this? Somebody once asked me, "Would you retire? Why do people do what they do?" Because certainly at some point it isn't just about the money and at the end of the day product management is so damn fun because it's about trying to figure out an edge. It's like trying to look at the world, find the portion of the chessboard that isn't occupied, but that is valuable and find a way to get into it, invade it and destroy it. It's decisions under uncertainty and that makes it unbelievably fun. Really, really painful and very frustrating and very hard to convince people, but very, very fun. So in equal measures basically.

**中文翻译:**
当我刚开始做 PM 时，有人告诉我一个老生常谈的道理：作为产品经理，你的工作实际上是对 90% 找上门来的事情说“不”。这让你从一开始就扮演了“坏人”的角色。你拒绝 90%，是为了能对那 10% 真正重要的事情说“是”。这让你从起步阶段就处于劣势，所以你必须迅速做出成绩（get runs on the board）。你必须证明自己拥有正确的洞察力、正确的数据，并能做出正确的决策，否则你可能就没机会再试一次了。所以，产品经理最容易被挑出来批评是有道理的，但这也正是这份工作最有趣的地方。
(00:08:52):
想想我们为什么要干这行？有人问过我：“你会退休吗？人们为什么要工作？”因为到了一定阶段，这不仅仅是为了钱。归根结底，产品管理之所以有趣得要命，是因为它是在寻找“优势”（edge）。就像观察世界，在棋盘上找到那块尚未被占据但极具价值的区域，然后想办法切入、占领并颠覆它。这是在不确定性下做决策，这让它变得无比有趣。虽然过程非常痛苦、令人沮丧且难以说服他人，但也同样非常、非常有意思。基本上是痛苦与快乐并存。

---

### [00:09:33] Lenny Rachitsky

**English:**
What's the answer, Shaun? How do we solve this problem? I know you said it's your life's work. What do you find actually helps most in helping PMs level up and become say 10 X PMs?

**中文翻译:**
那答案是什么，Shaun？我们该如何解决这个问题？我知道你说这是你毕生的事业。你发现什么方法最能帮助 PM 进阶，成为所谓的“10 倍速 PM”？

---

### [00:09:43] Shaun Clowes

**English:**
I think the most important thing and the chestnut that I repeat to everybody is that at the end of the day, the time you spend looking inside the building doesn't really benefit you very much at all. And Steve Blanken, people used to talk about you should be spending 80% of your time thinking about things going on outside the building. You might not be outside the building, but you should spend 80% of your time thinking outside the building. And I would say that very small number of PMs do that. They get dragged into internal politics, they get dragged into scrum management or scrum execution or product delivery, like elements of the delivery thing and you just can't win that way. You just can't win that way. You can never get an A because you're fundamentally not solving the job. The job is not about execution or anything, it's about finding reliable, differentiated value that you can uniquely deliver into the market.
(00:10:33):
So I would say if there's one thing, two things I would say actually that I generally guide product managers to do, one is to always start from the point of view outside the building in every document in everything, always talk from the customer's perspective, from the market's perspective, from the competitor's perspective, and the people who listen to me on that I would say get better almost immediately because they're starting from a place that's easier to understand and then secondarily be data informed.
(00:10:58):
They use all of that view of the world, but don't just make up a bunch of statements, support that statements with anecdotes and bits of data. It doesn't have to be a treatise, but convince everybody of what the world really looks like and what the opportunities ahead of the company looks like and good things happen to you. And all of a sudden you go from a world where nobody wants to help you get anything done to where everybody wants you to win. They want you to win and they may not give you everything you want, but they certainly will try because they're like, "Well, of all the bets we could make, this is a good one."

**中文翻译:**
我认为最重要的一点，也是我反复对大家说的一句老话：归根结底，你花在“大楼内部”的时间对你几乎没有任何好处。Steve Blank 以前常说，你应该花 80% 的时间思考大楼外发生的事情。你人可能在大楼里，但你的思维必须 80% 都在大楼外。但我发现极少数 PM 能做到这一点。他们被卷入内部政治、Scrum 管理、执行或产品交付等琐碎环节，这样是赢不了的。你永远得不到 A，因为你根本没有在解决核心问题。这份工作的核心不是执行，而是寻找你能独特地交付给市场的、可靠的差异化价值。
(00:10:33):
所以，如果让我给 PM 两个建议：第一，在任何文档、任何事情中，始终从“大楼外”的角度出发，从客户、市场、竞争对手的角度说话。听从我这个建议的人几乎立竿见影地变强了，因为他们从一个更容易被理解的基点出发。第二，要以数据为依据（data-informed）。
(00:10:58):
利用对世界的观察，但不要只抛出空洞的陈述，要用案例和数据来支撑。不需要写成长篇大论，但要让大家相信世界真实的模样，以及公司面前的机会在哪里。这样好运就会降临。突然之间，你会从一个没人愿意帮你办事的环境，变成一个大家都希望你赢的环境。他们希望你赢，虽然不一定能给你想要的一切，但他们会尽力尝试，因为他们觉得：“在所有我们可以下的赌注中，这一个看起来很靠谱。”

---

### [00:11:30] Lenny Rachitsky

**English:**
I imagine many people listening to this are thinking, "Oh, I am that person. I talk to customers all the time. I'm always interacting, looking at research, putting data together." And what you're saying is you're probably not doing that enough. Is there anything that you could help someone recognize of, "No, you're actually not doing this enough and you think you are but you're not."

**中文翻译:**
我想很多听众可能会想：“哦，我就是那样的人啊。我经常和客户聊天，一直在互动，看研究报告，整理数据。”但你的意思是，他们做得可能还不够。你有什么办法能让某人意识到：“不，你其实做得不够，你只是自以为做得够了。”

---

### [00:11:50] Shaun Clowes

**English:**
It's one thing to say you're spending a lot of time looking outside the building. It's a whole other thing to hear from the places you don't normally hear from. So avoid availability or confirmation bias. Most of the time people go talk to the people they always talk to and they learn nothing particularly new. They don't synthesize the results that they got from that conversation. They don't seek out the counterfactual, they don't seek out the proof that they're wrong. They don't analyze what their competitors are doing and figure out what that must tell you about the market. They don't bring back the data of how their product is actually being used versus how people say it's being used. It's like all data and no analysis is not very useful. Everyone can bring back an omnibus edition of random stuff I heard on a Tuesday, but the competitive advantage is extracted out of figuring out what other people don't see, figuring out where we are wrong, figuring out where a well-placed bet could have dramatically outlandish returns.
(00:12:49):
And so I think firstly, people often say that they do a lot of this stuff, but they actually don't because they don't have any structured way of doing it. So what they really mean is every now and then I get in a customer call or every now and then I get stuck into an escalation. And so they're kind of conveniently bucketing it. So firstly they don't do it in a very structured way, then they don't bring back analysis, they get true insights from that thing, so they don't really gain very much at all. It's just more activity, no outcomes. People do far too much activity with not enough outcomes and there just isn't enough time in the day to do that to be successful.

**中文翻译:**
说自己花了很多时间观察外部是一回事，但从你平时听不到声音的地方获取信息是另一回事。要避免“易得性偏差”或“确认偏差”。大多数时候，人们只是去和那些老面孔聊天，学不到任何新东西。他们不综合对话的结果，不寻找反面证据，不寻找证明自己错误的证据。他们不分析竞争对手在做什么，也不思考这反映了市场的什么趋势。他们不带回产品实际使用情况的数据，而只是听人们怎么说。只有数据没有分析是没用的。任何人都能带回一份“周二听到的各种杂事”汇总，但竞争优势来自于发现别人看不见的东西，发现我们哪里错了，发现哪里下一个重注能获得惊人的回报。
(00:12:49):
所以我觉得，首先，人们常说自己做了很多这类工作，但其实没有，因为他们没有结构化的方法。他们所谓的“做过”其实是“偶尔参加个客户电话”或者“偶尔处理个投诉”。他们只是随手把这些事归类了。因为缺乏结构化的方法，他们带不回深刻的分析和真正的洞察，所以其实没什么收获。这只是增加了活动量，却没有产出结果。人们做了太多无效活动，产出太少，而一天的时间根本不够让你靠这种方式获得成功。

---

### [00:13:24] Lenny Rachitsky

**English:**
You as a product leader is at the Venn diagram center of the sweet spot of where this podcast has been going recently, which is product and growth and how AI helps you with all these things. And so to follow a thread there with synthesizing and understanding what people are saying, user research and surveys and all these things, have you found any tools that you and your team have found really useful to help you do this more efficiently versus traditionally just manually going through all the stuff and finding patterns?

**中文翻译:**
作为一名产品领导者，你正处于本播客近期关注焦点的交汇处：产品、增长以及 AI 如何辅助这些工作。顺着这个思路，关于综合理解用户反馈、用户研究和调查等，你和你的团队有没有发现什么特别好用的工具，能比传统的手工梳理和找规律更高效？

---

### [00:13:55] Shaun Clowes

**English:**
Yeah, so firstly, stepping back a little bit just into the motherhood and apple pie portion of qualitative research or whatever, I find that most people don't even understand or don't start with a rigorous foundation in what they're going to need to do to get the answers that they want. So for example, your listeners have probably heard about the Nielsen number before, but basically the idea is that once you interview between 7 and 14 people, you stop learning new things. Less than 7, you don't learn enough, more than 14, you start learning anything new. And so if you interviewed two people, you probably don't have enough data. If you interviewed 22, you probably had too much, so they don't even right size their efforts. So that's a problem. So they don't start that way. Then they go into these conversations asking leading questions, which really are designed to get the customer to say what they already want to be true, which is so they haven't done enough research or they've done too much and then they've blown up all of the results before they've even heard anything.
(00:14:48):
If you don't right size your research and you don't set this up to learn, then you're going to lose. No amounts of applying LLMs or any type of kind of structured reasoning is going to help you. Because you just basically you're reading back what you want to hear or some weird summarized version of what you want to hear. But stepping back from all of that, what I like to do specifically getting to LLMs is I think that we live in just the most amazing time for product managers right now in terms of being able to analyze vast quantities of information and see the common threads. And so let me give you few examples of that. One might be you can do a bunch of customer interviews, you can put a bunch of customer interviews into ChatGPT and you can say, "Hey, ChatGPT, this is my strategy. Tell me where my strategy does not fit what these customers talked about."
(00:15:40):
It's all about the not, not where it does, where it does not. People spend far too much time looking for what they're hoping to see, not for what they're not looking to see. So you can literally ask ChatGPT to help you find where the customer is probing at the edges of what you're trying to do, where it's wrong, where what you're saying is not what they believe. And you can ask it questions like that. You can ask it what your customers are saying would better fit what your competitors are saying. So you can basically say, you can copy and paste one of your competitor's positioning documents into ChatGPT and say, "Is this a better fit for what they have said than my thing?" Which is you can summarize your own strategy, you can take your competitors but public documents and you can ask it to summarize what their strategy probably is.
(00:16:22):
And it's actually supposedly good at that because mostly your public documents are actually a summary or at least they're derivative of what your strategy is. So it will give you crazy insights into what other people's, literally their product strategy at times creepy like, "Oh, they will probably do this, they will probably do that. It's more likely they would do this than they would do that." And so normally that type of insight was hard one, it took a lot of sweat work. You basically get to read a lot of stuff. You kind of had to use your brain as this big summarization machine and eventually you knew what you felt about all the things you had read, but you couldn't summarize why. LLMs let you get to that really, really, really quickly in a very structured way, but only if you push at the edges, provoke the answers you don't want to hear, provoke the problems, try and prove to yourself that you are wrong, I think is the easiest way to start trying to use some of these tools.

**中文翻译:**
好的。首先，退一步说，在定性研究这些基础层面，我发现大多数人甚至不理解、或者说没有从一个严谨的基础开始去获取他们想要的答案。例如，听众可能听说过“尼尔森数字”（Nielsen number），基本观点是：一旦你访谈了 7 到 14 个人，你就停止学到新东西了。少于 7 个学得不够，多于 14 个则开始重复。如果你只访谈了 2 个，数据不够；如果你访谈了 22 个，可能又过头了。很多人甚至不知道如何调整投入的规模。这是一个问题。此外，他们在对话中常问引导性问题，旨在让客户说出他们想听的话。所以，要么研究不足，要么研究过度，结果在听到任何真实反馈前就已经被污染了。
(00:14:48):
如果你不调整研究规模，不以“学习”为目的去设定研究，那你注定会失败。无论应用多少 LLM 或结构化推理都没用，因为你只是在读回你想听的话，或者是你想听的话的某种 AI 摘要版。但回到 LLM，我认为现在是产品经理最神奇的时代，因为我们能分析海量信息并发现共同点。举几个例子：你可以把一堆客户访谈记录输入 ChatGPT，然后说：“嘿 ChatGPT，这是我的战略。告诉我，我的战略在哪些地方与这些客户所说的**不符**。”
(00:15:40):
重点在于“不符”，而不是“符合”。人们花了太多时间寻找他们希望看到的东西，而不是他们没想到的东西。你可以让 ChatGPT 帮你找客户在哪些边缘地带质疑你的方案，哪里错了，哪里他们不认同你的说法。你还可以问：客户说的话是否更符合竞争对手的论调？你可以把竞争对手的定位文档贴进去问：“比起我的方案，他们的方案是否更契合客户的说法？”你可以总结自己的战略，也可以拿竞争对手的公开文档让 AI 总结他们的战略。
(00:16:22):
AI 在这方面表现惊人，因为公开文档通常是战略的缩影或衍生。它会给你带来关于别人产品战略的疯狂洞察，有时甚至到了令人毛骨悚然的地步，比如：“他们可能会做这个，可能会做那个，做 A 比做 B 的可能性更大。”以前这种洞察很难获得，需要大量的苦劳，你得读很多东西，把大脑当成大型总结机，最后你有一种直觉，却说不出为什么。LLM 让你能以结构化的方式极快地达到这一步。但前提是你要推向边缘，挑动那些你不想听到的答案，挑动问题，试着证明自己是错的。我认为这是开始使用这些工具最简单的方法。

---

### [00:17:15] Lenny Rachitsky

**English:**
I love that. And it sounds like in your experience you're just using straight-up OpenAI, ChatGPT, Claude, not any specific tool for user research for this specific use case.

**中文翻译:**
太棒了。听起来在你的经验中，你只是直接使用 OpenAI、ChatGPT 或 Claude，而不是针对这个特定用例使用专门的用户研究工具。

---

### [00:17:26] Shaun Clowes

**English:**
No, mostly I find that the straight-up LLMs themselves are good enough and we do have some internal tooling that we built around, I don't know if you've ever had Sachin Rekhi on the show, you may have. He was a product leader pretty well known in the gross community, and he was a leader at LinkedIn for a long time and he used to call this concept a Feedback River, and he basically said that really smart product managers are constantly swimming at a Feedback River. They set out to surround themselves by Feedback River and I really deeply believe in that. It's like, "Okay, how can I surround myself with user interview data, with direct customer feedback, with NPS data, with competitor information?" Like I'm always trying to wash myself over with information. And where I'm going with this is that LLMs and tooling based on it can be exceptionally good for this.
(00:18:20):
So for example, at Confluent we get a ton of inbound customer requests, as you can imagine coming from the field or directly from customers. We use LLMs to take in those asks to summarize what they're about, to find other asks that are like that one, really in a compelling way, a real way, like a semantic way, not other words, exactly the same, are these the same concept? So that we can look across all of the inbound demand on us and say, "Well, the most popular idea is this one and is getting more popular. The least popular idea is this one. It is getting less popular." In a really deep rich way, even across hundreds or thousands of pieces of inbound feedback. I think it's a really great time to be a product manager if you can put these types of tools to work, but they don't do the job for you, they just help you do these things that are intricate in that job of finding the gaps, finding the opportunities, finding the common threads without necessarily having to do all of it just inside your wear-wear, just inside your brain.

**中文翻译:**
是的，我发现直接用 LLM 就足够好了。我们确实围绕这个构建了一些内部工具。不知道你是否请过 Sachin Rekhi 上节目，他是增长社区很有名的产品领导者，曾在 LinkedIn 担任高管。他曾提出一个概念叫“反馈之河”（Feedback River）。他说聪明的产品经理总是游在反馈之河里，他们会有意识地让自己被反馈包围。我深信这一点。我会想：“我如何让自己被用户访谈数据、直接客户反馈、NPS 数据、竞争对手信息所包围？”我总是试图让自己沉浸在信息中。而 LLM 及其衍生工具在这方面表现卓越。
(00:18:20):
例如，在 Confluent，我们收到海量的客户请求。我们使用 LLM 来接收这些请求，总结核心内容，并以语义化的方式（而不仅仅是关键词匹配）找到类似的请求，判断它们是否属于同一个概念。这样我们就能纵观所有的入站需求并得出结论：“最受欢迎的想法是这个，而且热度在上升；最不受欢迎的是那个，热度在下降。”即使面对成千上万条反馈，也能获得深刻而丰富的洞察。如果你能利用好这些工具，现在是做产品经理的大好时机。它们不会替你完成工作，但能帮你处理那些寻找差距、机会和共同点的复杂环节，而不必全靠你的大脑硬扛。

---

### [00:19:21] Lenny Rachitsky

**English:**
I'm going to stay in this AI river that we're in right now and ask a couple more AI-related questions. And this may be what you just said, but I'm curious if there's more here. You kind of have this hot take that the way AI will most impact product management is data management and data versus models you're building or anything else. Can you talk about what you've seen there?

**中文翻译:**
我想继续待在 AI 这条河里，再问几个相关问题。这可能和你刚才说的有关，但我很好奇是否有更深层的含义。你有一个犀利的观点：AI 对产品管理影响最大的方式是数据管理，而不是你构建的模型或其他东西。能谈谈你在这方面的见解吗？

---

### [00:19:40] Shaun Clowes

**English:**
Yeah, I mean, I think there's two implications for people as they're building products based on AI and as they're thinking about AI in their workflow. So let's start with the first one, because that's how product managers do product management things. You just asked this question of should it be specific tools built to make AI easier for product managers to use? Or is it in fact more general models being put to work? At the end of the day, these models are very, very, very smart, but they're also insanely dumb and everyone knows that, insanely dumb. In other words, they really only know what they were trained on or what you bring to them right at that moment. In that millisecond, and then they will forget it immediately. And it's very easy to convince yourself that isn't true, but it is actually what really matters. And let me add one extra piece that makes that really important.
(00:20:28):
At the end of the day, information has a decay rate. So think about customer feedback, it has a decay rate or what your competitors are doing has a decay rate. So any new piece of data decays in its value to your decision-making very, very quickly, very, very quickly. You can plot your own decay chart if you want to, but the answer is very, very quickly. And so when you think about the job which is synthesizing all of this very complicated information to make good decisions, what does that mean? Well, you've got this synthesis machine, which is this LLM thing that's going to help you do synthesis, but if it hasn't got all that data to do synthesis on top of, it's got nothing. And so that means that LLMs can only be as good as the data they are given and how recent that data is. They're ultimately like information shredders.
(00:21:11):
They are limitless information eaters. You can never have enough information to give to an LLM to truly gain its value. The more things you give it, the better it gets. Broadly speaking, that's just not perfect, but that's close enough. And so what that means is as an internal product leader or putting LLMs to work, you need to figure out how to bring as much information about customers or their asks or your competitors, all of it. How much can you find all of it and bring it together and give it to the LLM either in your tooling or even in just copying and pasting or whatever your flow is going to be, that's one thing. But then if you take it beyond that and you go, "Okay, well now I'm a product leader and I'm building an app and I want to put AI in my app, what will make my AI experience really great?"
(00:21:57):
It's definitely not going to be the models because these models are mostly going to be somewhat replaceable. And you could say, "Okay, well, is it going to be the prompts?" Maybe, but certainly good prompts are better than others, and that's kind of an ongoing investment you'd probably want to make to ask better questions to get the LLM to deliver better answers. But it's obvious that the real answer is the context, all the context you're going to give it, all the data you're going to copy and paste. And so if you think about, let's say I'm building a, I have no relationship to this, but let's say I was trying to build a human capital like a HCM bot, like an AI bot. Let's say I was working at Workday and I was trying to bring an AI bot. It's pretty obvious that the smarts of the bot would really be related to all of the employee information, but not just that, it would be the benefit's information, it would be the legal situation in the country where that person is currently working.
(00:22:47):
It would be the company's policies and procedures that apply to it. So you get what I mean, by about these kind of the jumps of logic and the jumps of data and the way data is all linked together. If you want to have a smart AI experience, you'll convince yourself that all I really need to do is get a model and wire it in and I'll build a little pipeline that will suck some data in and it will whack it into the LLM. And if you think that way, you're going to be very sad, very, very sad for a very long time because you are constantly going to be wrestling with how do I get data to this thing? How do I get good data to this thing? How do we get timely data to this thing? How do I get well-structured data to this thing?
(00:23:21):
And so it's a data management problem. It's getting access to good data, getting access to high quality data, getting access to timely data and getting it to the LLM to get the LLM to make a smart decision. That's where 90% of the calories go. Maybe it's a bit like Einstein's thing, "It's 10% inspiration, 90% perspiration." Nobody wants to hear it. Everybody wants to just think about what these really cool models and how smart they are, and the next one will be even smarter. But really it's just the hard work of getting really good data to the LLMs to get them to do good things.

**中文翻译:**
是的，我认为对于正在构建 AI 产品或在工作流中考虑 AI 的人来说，有两个层面的启示。首先从 PM 如何做产品管理说起。你刚才问，是该用专门为 PM 设计的 AI 工具，还是直接用通用模型？归根结底，这些模型非常非常聪明，但也极其愚蠢——大家都知道这一点。换句话说，它们只知道训练数据里的东西，或者你那一瞬间喂给它的东西。在那一毫秒之后，它就会立刻忘记。你很容易说服自己事实并非如此，但这才是关键。还有一个非常重要的点：
(00:20:28):
信息是有衰减率的。客户反馈、竞争对手的动态，任何新数据的决策价值都会极快地衰减。你可以画一个衰减曲线，答案就是“非常快”。所以，当你的工作是综合所有复杂信息来做决策时，这意味着什么？你有了一个 LLM 综合机器，但如果没有数据供它综合，它就一无是处。LLM 的表现上限取决于数据的质量和时效性。它们本质上像是“信息粉碎机”。
(00:21:11):
它们是无限的信息吞噬者。你永远无法给 LLM 提供足够的信息来榨干它的价值。给得越多，它表现越好。所以作为产品领导者，你需要想办法把关于客户、需求、竞争对手的所有信息汇聚起来喂给 LLM。这是第一点。第二点，如果你是正在开发应用的 PM，想在应用里加入 AI，什么能让 AI 体验变得卓越？
(00:21:57):
绝对不是模型，因为模型在很大程度上是可以替换的。那是提示词（Prompts）吗？也许，好的提示词确实更有效，这也是需要持续投入的。但真正的答案显然是“上下文”（Context）——也就是你喂给它的所有数据。假设我在 Workday 开发一个人力资源（HCM）AI 机器人。这个机器人的聪明程度取决于它能获取多少员工信息，不仅如此，还有福利信息、该员工所在国的法律状况、公司的政策流程等。数据是环环相扣的。如果你觉得只要接个模型、搞个简单的 Pipeline 把数据塞进去就行了，那你以后会过得很惨。你会一直纠结于：如何把数据传给它？如何传好数据？如何传及时的数据？如何传结构化的数据？
(00:23:21):
所以这是一个数据管理问题。获取优质、高质量、及时且结构良好的数据并传给 LLM，让它做出聪明决策，这才是 90% 的精力所在。这有点像爱因斯坦说的：“10% 的灵感，90% 的汗水。”没人想听这个，大家都只想讨论模型多酷、多聪明，下一个版本会更强。但核心工作其实是把好数据喂给 LLM，让它干漂亮活。

---

### [00:23:51] Lenny Rachitsky

**English:**
It sounds really obvious as you make this case. It makes me think about at the Lenny and Friends Summit, Mikey Krieger talked about how he had the two types of PM groups within Anthropic. One was focusing on user experience product and the other was working on the model research side, and they realized that all of the success came from the model research work, like making the model and the data they provided the model was where all the value came from, not just optimizing the user experience and they're just putting more and more of their product team on just that versus tweaking UX and buttons and things like that.

**中文翻译:**
你这么一说，道理确实很显而易见。这让我想起在 Lenny and Friends 峰会上，Mikey Krieger 提到 Anthropic 内部有两种 PM 团队：一种关注用户体验，另一种关注模型研究。他们发现，所有的成功都源于模型研究工作——即构建模型和提供给模型的数据，这才是价值所在，而不仅仅是优化用户体验。于是他们把越来越多的产品团队投入到这方面，而不是去微调 UX 和按钮。

---

### [00:24:27] Shaun Clowes

**English:**
Yeah, exactly right.

**中文翻译:**
没错，正是如此。

---

### [00:24:29] Lenny Rachitsky

**English:**
Something sort of related, I'm just going to ask one more AI question. I don't want every talk to end up being just all AI, but something that's kind of been a meme recently, and I know you have a perspective on this, is that AI makes it really easy to build products. So in the future, if you can easily clone, say, a B2B SaaS app like Salesforce or Atlassian or whatever your favorite B2B SaaS app, what happens to these businesses long-term? Do they just become, are they all in trouble? Are there going to be 100 Salesforce competitors? What's your sense and prediction on what might happen there?

**中文翻译:**
还有一个相关的问题，我再问最后一个关于 AI 的问题，我不想让每次谈话都变成 AI 专场。最近有个梗，我也知道你对此有看法：AI 让开发产品变得极其容易。那么在未来，如果可以轻松克隆一个 B2B SaaS 应用，比如 Salesforce 或 Atlassian，这些企业的长期命运会如何？它们会陷入麻烦吗？会出现 100 个 Salesforce 的竞争对手吗？你的直觉和预测是什么？

---

### [00:25:03] Shaun Clowes

**English:**
Yeah, I think it's really weird. I think people really underestimate where the value is created in these applications and they just kind of get it completely wrong, and I'm not sure why that is. So if you think you bet. So I spent a long time at Atlassian, so I worked a lot on Jira, which many people know, and I spent a long time at Salesforce, so I spent a lot of time in the CRM ecosystem, the marketing ecosystem and all the rest of it. If you want it to be not charitable, you'd step back and you'd look at all those applications and you'd say, "They're all just forms on databases." You'd say, "The Jira is a form on a database, Workday is form on a database, so Salesforce." They're all forms on databases, all vertical SaaS or business SaaS is ultimately forms on databases. And you're be like, "Well, how hard can that be to replicate?"
(00:25:45):
And the answer is unbelievably hard, unbelievably hard. And people just think, "You totally get it wrong." Because it's not actually just about the data model. So if you think about, if it formed some databases, it's these beautiful user experiences that sit on top of data models. So whatever the object is, it might be a customer object or a campaign object or an employee object, you could say that, "Well, there's some elements of lock-in in the object, the object itself, like the fields of the object." I'm like, "Pretty boring. That's not very interesting." But sure, maybe. Certainly there's some value in being the system of record like the default that everybody uses. There's definitely some value in the UX. Like, "Well, I want to be the best HR-facing applications for working employee data." Yeah, there's some value there, but the real thing just staring at everybody in the face is it's all about the business rules.
(00:26:35):
That is what drives the lock-in because why do you buy Workday? You don't buy Workday for its out-of-the-box configuration. You buy Workday because you want to configure it to be Lenny Inc's HR processes. It becomes Lenny Inc's Workday. It's not Shaun Inc's Workday, it's Lenny Inc's Workday. And actually the longer you have the software, the more it becomes that, the more it becomes less and less like Workday and more and more like your specific company. Which makes sense because it was built to be configured to meet the needs of any specific company, and every company is their own precious snowflake. And as that happens, those configuration pieces, the bit that makes the application native and a fit for your organization makes it a fit for nobody else's organization and also makes it a black box to the point that you don't even understand how it works anymore.
(00:27:20):
If you went to, for example, Salesforce and you said, "Hey, could you define all of the processes by which software was sold inside Salesforce?" They couldn't tell you that without reading the code of their Salesforce instance. That's not a proprietary secret. That's obviously true because over time, that's literally how sales happened. There is no other way to do a sale other than through their internal tooling. And so what that means is that it's not the UI that matters and it's not the data model that matters, although those are both very useful. It's the years and years and years of evolution of the underlying workflows of the product to support the customers, but also the customers evolving those workflows to make them work the way they do. And so how does that impact AI companies? You could say, "It's easier than ever to build forms on a database application."
(00:28:09):
And so I'm like, "Yeah, okay, that presumably drives the incremental value of every new one of those to zero, right?" So probably leads to more power to the existing winning systems of record because there'll just be a gazillion competitors who would just more form some databases. So like, "How would you ever choose between them? You may as well just go with the winner. Nobody ever gets fired for buying Salesforce or whatever. You may as well start from the kind of the premier vendor." That's one element. You could go the other way and you could say, "I've heard a few people mount this argument," which I think is really interesting that at the end of the day, agents are going to take away most of the use of that user interface.
(00:28:44):
So let's say for example, your Salesforce with Service Cloud, I've heard people say, "Well, a lot of those service agents might end up being replaced with agentic workflows. That will mean that there is no person operating the UI. If the UI doesn't even exist anymore, then why do you even need Salesforce? We may as well just have raw database tables on who even needs forms of databases, you can literally just have databases." But that also doesn't make any sense either because the agents have to operate against the rules of the system and the rules are defined by the business processes. So think about Salesforce without a head. Imagine Salesforce had no UI, it would still have those business rules that I was talking about. And those business rules are what define what the agent should do. They're almost telling the agent what it should do and how the world can operate, what is possible, what is allowed. And so from my perspective, this idea that this just completely destroys the differentiation of these kind of business process SaaS applications just seems like a fantasy, a crazy fantasy.
(00:29:42):
The only way I could really believe it is if you said, "Well, you could have a new startup that introspected all of the rules that are configured into a Salesforce to try and reverse engineer what your actual business processes are and then kind of operate on top of that." But the best place people to do that would be Salesforce themselves or Atlassian in Atlassian's case or Workday in Workday's case. I just can't see a world in which this... I think one of two things could happen. All this moving to AI makes those applications even better, even more unassailable, they basically get stronger. It makes us stronger or it could enable some new level of applications that come from a more platform based thing, so less a domain specific thing like you ACM or ERP or engineering or less of the domain specific stuff.
(00:30:36):
It could enable a more platform like play where you have more business objects and business objects have rules. And you could imagine a world in which there's kind of a whole evolution of new more platform like SaaS applications that do more than one business function worth of the business rules and the way things move around in the enterprise, but that doesn't exist today. So you could say that that could exist and it could say it could be way better than we've ever thought of because of AI. Or you could say that the rich are going to get richer. The most likely outcome is that the currently dominant companies are going to get more dominant, but I don't think this idea that it would just cause a spring up of a whole bunch of new apps that will more easily challenge the incumbents makes any particularly, it's not straightforward to me how that would happen basically.

**中文翻译:**
是的，我觉得这很有意思。人们真的低估了这些应用创造价值的核心，完全搞错了方向。我在 Atlassian 待了很久，负责过 Jira；在 Salesforce 也待了很久，深入研究过 CRM 和营销生态。如果不客气地说，你退后一步看这些应用，会发现它们其实都是“数据库上的表单”。Jira 是，Workday 是，Salesforce 也是。所有的垂直 SaaS 或业务 SaaS 最终都是数据库上的表单。你可能会想：“那复制起来能有多难？”
(00:25:45):
答案是：难得不可思议。人们完全想错了，因为核心不在于数据模型。如果你认为它只是数据库上的表单，是数据模型之上的漂亮 UI，那么无论是客户对象、营销活动对象还是员工对象，你可能会说：“锁定效应（Lock-in）在于对象本身，比如对象的字段。”我觉得这很无聊，没什么意思。当然，作为默认的“记录系统”（System of Record）确实有价值，UI 也有价值。但真正摆在大家面前的核心是：**业务规则（Business Rules）**。
(00:26:35):
这才是驱动锁定的原因。你为什么要买 Workday？你买它不是为了它的开箱即用配置，而是为了把它配置成“Lenny 公司”的人事流程。它变成了 Lenny 公司的 Workday，而不是 Shaun 公司的。软件用得越久，它就越不像原始的 Workday，而越像你特定的公司。这很合理，因为它生来就是为了被配置以满足特定需求的，而每家公司都是独特的“雪花”。随着时间推移，这些让应用契合你组织的配置，让它变得不适合任何其他组织，甚至变成了一个黑盒，连你自己都快搞不懂它是怎么运作的了。
(00:27:20):
比如在 Salesforce 内部，如果你问：“Salesforce 内部销售软件的所有流程是什么？”如果不去读他们那个 Salesforce 实例的代码，没人能告诉你。这不是商业机密，而是事实，因为销售就是这么发生的，除了通过内部工具别无他法。这意味着重要的不是 UI，也不是数据模型，而是产品底层工作流为了支持客户而进行的数年、数十年的演进，以及客户为了适应自身而对这些工作流进行的改造。这对 AI 公司有什么影响？你可以说：“现在构建数据库表单应用比以往任何时候都容易。”
(00:28:09):
那么，每一个新竞争者的边际价值都会趋于零，对吧？这反而会让现有的“记录系统”更强大，因为会有无数个竞争对手提供类似的表单。你该怎么选？不如直接选赢家。没人会因为买了 Salesforce 而被开除。这是其一。另一种观点是：AI Agent（智能体）将取代大部分 UI 的使用。
(00:28:44):
比如 Salesforce 的 Service Cloud，有人说服务人员会被 Agent 取代，UI 消失了，那为什么还需要 Salesforce？直接用原始数据库表不就行了？但这也不成立，因为 Agent 必须根据系统的规则运行，而规则是由业务流程定义的。想象一个没有 UI 的 Salesforce，它依然拥有那些业务规则。这些规则定义了 Agent 应该做什么，告诉它世界是如何运作的，什么是可能的，什么是被允许的。所以，认为 AI 会彻底摧毁这些业务流程 SaaS 的差异化，在我看来纯属幻想。
(00:29:42):
除非有一种新初创公司能洞察 Salesforce 中配置的所有规则，逆向工程出你的实际业务流程，然后在此基础上运行。但最有能力做这件事的其实是 Salesforce、Atlassian 或 Workday 自己。我认为只有两种可能：AI 让这些应用变得更强大、更不可撼动；或者它催生了一种更底层的平台级应用，不再局限于特定领域（如 HCM 或 ERP），而是让业务对象和规则在整个企业中自由流动。但这在今天还不存在。所以，要么是强者恒强，要么是出现我们从未想象过的平台。但我认为“一堆新 App 轻松挑战巨头”的想法并不现实。

---

### [00:31:18] Lenny Rachitsky

**English:**
Wow, that was extremely fascinating and there's so much there. I can go in so many directions. One is I thought you would actually go in this direction, which is distribution advantages become even more important if it's easy to... Like today, I could sit there and hire team clone. Salesforce might take a while, but I could copy it, but by the time I'm done, they've evolved, they're moving, they're adding features, they're ahead, right? You're skating to where the puck was. And so if that's the case, one of the advantages, one of the ways to get anywhere is to have some kind of distribution advantage. It's one thing to have Salesforce as a product clone, another to get anyone to know about it, to adopt it, to sell it, procurement, all that stuff. Do you have a sense of distribution advantages being even more valuable in that world?

**中文翻译:**
哇，这太引人入胜了，信息量巨大。我可以从很多方向展开。其中一个是，我以为你会提到“分发优势”（Distribution advantages）会变得更加重要。如果开发变得容易……比如今天我可以雇个团队克隆 Salesforce，虽然要花点时间，但当我做出来时，他们已经进化了，在增加新功能，始终领先一步。你是在追逐冰球曾经停留过的地方。如果是这样，成功的关键之一就是拥有某种分发优势。克隆产品是一回事，让别人知道它、采用它、卖出去、过采购关，那是另一回事。你是否觉得在那个世界里，分发优势会变得更有价值？

---

### [00:32:05] Shaun Clowes

**English:**
Yeah, I mean, it certainly makes sense. Ultimately, at the end of the day, distribution is always an advantage because the hardest problem is to even be in the consideration set for any given problem. The world is full of problems. It's just when people have that problem, they firstly don't think they're going to solve it at all. And when they do think of solving it, they don't think of you. So distribution is always an incredible advantage. But again, in the world of AI, it seems like distribution is more likely to get hard than easy. So if you think about, for example, diminishing returns on cold email because cold email is getting easier and easier to send even worse spam, it sounds better, but it's effectively causing everybody to become desensitized to everything. I don't know if you've noticed, half the LinkedIn charts now are all basically clearly LLM generated spam.
(00:32:50):
I mean, to some degree it's actually worsening the signal-to-noise ratio. And so I think that a lot of the breakthrough distribution mechanisms that startups often use seem to be getting more crowded just in general and more expensive. That doesn't bode well for, "I'm the not as good Salesforce," "I'm the not as good Salesforce, but I'm cheaper." It has to be something different. There has to be some angle upon which you are materially better. And what I saw happening and what I've been seeing happening, and I think it's been really interesting is a lot of modern next-gen applications bringing data as a first-class citizen into the workflow. And I think that that's pretty compelling. So if you look at the next-generation of applicant management products that deal with inbound job applicants, a lot of them now like the latest core ones, they include your time to fill data, they include outcome data of who's got the best hiring outcomes, who over what period of time has the worst attrition, literally all the way back to the interviewers and where the interviews were in the interview cycle.
(00:33:58):
So basically embeds data into the whole life cycle. So I think that there are these ways in which startups can bring these experience benefits by just bringing a different approach to the world that does enable them to capitalize on traditional disruptive innovation. At the end of the day, this is just disruptive innovation. It means that most companies have overshot the utility like the average utility, so you can win by meeting the average utility and being different, meet the bar and be different. Meet the bar and be different is the way to cut through. So that makes sense if that's a half decent playbook. But even for those companies, now they're going to have all these AI competitors who are using AI to engineer faster, to build a competitor just like them as quickly as possible and start jamming it into the channel. And it's going to be interesting to see how this whole thing evolves. It kind of got race to the bottom characteristics around it. You're probably right, the distribution is still the hardest part in software, particularly when you're getting started.

**中文翻译:**
是的，这当然有道理。归根结底，分发永远是优势，因为最难的问题是进入用户解决问题的“考虑名单”。世界上到处是问题，但当人们遇到问题时，首先可能根本没想去解决；即使想解决，也想不到你。所以分发是巨大的优势。但在 AI 时代，分发似乎变得更难而非更容易。比如冷启动邮件（Cold email），因为 AI 让发垃圾邮件变得太容易，虽然听起来更高级了，但实际上让每个人都对这类信息脱敏了。不知道你注意到没，现在 LinkedIn 上一半的私信显然都是 LLM 生成的垃圾信息。
(00:32:50):
在某种程度上，信噪比正在恶化。初创公司常用的突破性分发机制正变得越来越拥挤和昂贵。这对那些“做得不如 Salesforce 好但更便宜”的模仿者来说不是好兆头。你必须与众不同，必须在某个维度上有实质性的超越。我观察到一个很有趣的趋势：很多现代下一代应用将“数据”作为工作流中的“一等公民”。这非常吸引人。比如下一代招聘管理系统（ATS），它们会包含“填补职位所需时间”数据、招聘效果数据（谁招的人表现最好、谁的流失率最低），甚至能追溯到面试官和面试周期的具体环节。
(00:33:58):
它把数据嵌入了整个生命周期。初创公司可以通过这种不同的切入点带来体验上的红利，从而利用传统的“颠覆性创新”。大多数成熟公司已经超出了平均效用，所以你可以通过满足平均效用并做到“与众不同”来获胜。达到标准且与众不同，是突围之道。如果这是一个还算不错的剧本，那就有戏。但即使是这些公司，现在也要面对 AI 竞争对手，对方利用 AI 更快地工程化，迅速克隆一个类似的产品并塞进渠道。这会演变成一场“逐底竞争”（race to the bottom）。你可能是对的，分发依然是软件行业最难的部分，尤其是刚起步时。

---

### [00:35:00] Lenny Rachitsky

**English:**
So if you have some kind of clever and fair advantage, it feels like that becomes even more powerful. Say have a platform of an audience or something like that. You mentioned this ATS product they really like. Is there one you want to give some love to that you think is really cool that you like or you want to keep it anonymous?

**中文翻译:**
所以如果你有某种聪明且公平的优势，它会变得更强大。比如拥有受众平台之类的。你提到了那个你很喜欢的 ATS 产品，想公开夸一下它吗？还是想保持匿名？

---

### [00:35:16] Shaun Clowes

**English:**
Yeah, it's Ashby. It's the one all the cool kids are talking about now. And it's funny because people literally talk about it in comparison to all, even the last generation of modern SaaS ATSs or whatever, and they talk about it in glowing ways because of the way they put data inside the actual workflow. So the actions and its outcomes are directly tieable to each other in the application you're doing the work in. I think that's a pretty compelling user experience.

**中文翻译:**
是 Ashby。现在圈子里都在谈论它。很有趣，人们拿它和上一代现代 SaaS ATS 比较，评价极高，因为它把数据放进了实际的工作流中。你在应用里做的操作和产生的结果是直接关联的。我认为这是一种非常吸引人的用户体验。

---

### [00:35:41] Lenny Rachitsky

**English:**
So just to maybe close this thread before I move in a different direction, this point you're making about how valuable data is and how that's at the core of being successful and differentiating in the future, especially with AI tooling and products, any advice you'd give to someone that wants to do that? Is it just make sure you have a, is it half proprietary data? Is it like make it a first-class citizen? What's the advice you'd give to founders who are trying to do this, which you're suggesting?

**中文翻译:**
在转向另一个话题前，总结一下：你强调了数据在未来成功和差异化中的核心价值，尤其是在 AI 工具和产品中。对于想朝这个方向努力的人，你有什么建议？是确保拥有私有数据？还是将其作为“一等公民”？你会给尝试这么做的创始人什么建议？

---

### [00:36:08] Shaun Clowes

**English:**
Yeah, I, think at the end of the day, it's kind of all of those things, isn't it? If you have first-party data but you can't bring it to bear, then it's not very much use. If you have third-party data and you bring it to bear in interesting ways, the problem with data is we're all surrounded by data all the time. So the data's everywhere. What really matters is the right data at the right time in the right place because we're all humans. And so to me, there are obviously data advantages and there are even data network effects if you can end up in a situation where you have very valuable first-party data. But in any case, it's still about being able to bring the right data at the right place, at the right time for those users, for them to be able to get advantage from it.
(00:36:48):
A little kind of segue I guess on that one is I know I spent a lot of my career, weirdly, actually I've been a product person for a long time, but weirdly I've ended up inheriting data teams. So I've actually run data teams at a lot of different companies, which is weird because product managers don't normally own data teams. I think I have just a really massive affinity for data. I used to call myself data-driven, it was kind of my jam. And in hindsight, I look back and I think data is the opposite. Data is more like a compass than a GPS. If you look at data as a way of giving you the answer, you're always wrong. You're always wrong or you're slow. Wrong or slow or sometimes both, because mostly data doesn't give you the answer. It just tells you if what you just said is ridiculous or there's potentially something there.
(00:37:44):
So it's more like about disproving whatever you think and you end up being slow because if you try and use data for everything, your brain is ultimately a data sifter or whatever. So the reason your intuition tells you something is because you've seen a ton of data that tells you that this is the most likely answer. And so being data-driven, being data obsessed is it's something you can easily overdo very, very easily overdo. So it's about right-sizing data, having the right data at your fingertips, having the right kind of view on data rather than trying to expect data to give you the answer or trying to use data as a weapon or trying to use data as a way to force people to believe you or to go in your direction. But data is kind of at the center of everything and about how to influence and be successful in products you're building and arguments you're mounting internally and everything else.

**中文翻译:**
我认为归根结底是这些因素的结合。如果你有第一手数据但无法发挥其作用，那也没用。如果你能以有趣的方式利用第三方数据，那也很好。数据的问题在于我们被它包围了，它无处不在。真正重要的是在正确的时间、正确的地点提供正确的数据，因为我们都是人类。对我来说，数据优势确实存在，如果你拥有极具价值的第一手数据，甚至会有数据网络效应。但无论如何，核心还是在正确的时间地点为用户提供正确的数据，让他们获益。
(00:36:48):
顺便说一下，我职业生涯中很奇怪的一点是，虽然我是产品人，但我经常接管数据团队。我在很多公司都领导过数据团队，这很罕见，因为 PM 通常不管理数据团队。我对数据有种天然的亲近感。我以前常说自己是“数据驱动”的，那是我的标签。但现在回想起来，我觉得数据更像是指南针，而不是 GPS。如果你指望数据直接给你答案，你总是会出错，或者反应太慢。要么错，要么慢，或者两者兼有。因为数据通常不给答案，它只是告诉你：你刚才说的话是不是很荒谬，或者那里是否潜藏着机会。
(00:37:44):
所以数据更多是用来证伪你的想法。如果你事事依赖数据，你会变得很慢。你的大脑本质上就是一个数据筛选器，你的直觉之所以告诉你某个答案，是因为你已经看过了海量数据，大脑判断这是最可能的答案。所以，“数据驱动”或“数据痴迷”很容易做过头。关键在于“适度使用数据”，让正确的数据触手可及，拥有正确的数据观，而不是指望数据给你标准答案，或者把数据当成武器去强迫别人相信你。但数据确实处于一切的核心——无论是影响他人、打造成功产品，还是在内部辩论中获胜。

---

### [00:38:34] Lenny Rachitsky

**English:**
I love that you went there. I definitely wanted to spend time on here. It's interesting you say that, there used to be data-driven, [inaudible 00:38:44] data-driven. You created the Reforge course, data for product managers and also retention, engagement course and Reforge. And by the way, we'll link to these. You're still helping with these courses. By the way, they're still running. They're awesome. People love them.

**中文翻译:**
我很喜欢你谈到这个。我确实想聊聊这个。很有趣，你以前是“数据驱动”的。你在 Reforge 创建了《产品经理的数据分析》课程，还有《留存与参与度》课程。顺便说一下，我们会附上链接。你现在还在协助这些课程，它们仍在运行，非常棒，大家都很喜欢。

---

### [00:38:56] Shaun Clowes

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:38:56] Lenny Rachitsky

**English:**
Great. So we'll point people to those. I love that you're also saying you're like, I think the way you described it to me before, this is your reform data-driven PM. A lot of people say this, they're like, "Don't just do what data tells you to do. Use your intuition, use it as a guide." It's hard on the ground to operationalize that advice. Say to your PMs and your teams when they have data telling them, "Hey, this experiment is a huge success, or there's a huge onboarding conversion opportunity here." I guess just like what's your tactical advice to folks that have data telling them one thing and maybe something else telling them something else?

**中文翻译:**
太好了，我们会推荐给大家。我很喜欢你之前的说法，你现在是一个“改良后的数据驱动型 PM”。很多人会说：“不要只听数据的，要用直觉，把数据当引导。”但在实际操作中很难。当你的 PM 或团队看到数据说“这个实验大获全胜”或“新手引导转化率有巨大机会”时，如果数据说的是一套，而直觉说的是另一套，你有什么具体的战术建议吗？

---

### [00:39:35] Shaun Clowes

**English:**
I think the first thing I always encourage people to do is to look at a piece of data. If you're looking at a piece of data and the result tells you something that your intuition tells you is insanely wrong, like they probably not right. First, believe your intuition and go and prove yourself right. Don't just take it at first glance because most of the time it's like Occam's razor. The most likely explanation for something that is insanely not intuitive is that it's just wrong, that there's a problem somewhere. Now, occasionally, sometimes you actually will be right. Now those will be paid dirt moments. Those are the moments that make it all worth it. There are times when you do find the negative goal, you're like, you're staring at it and like, "This is it. This was the problem. This was the thing we were looking for this whole time."
(00:40:18):
But you have to be very diligent about following it through, really understanding what you're looking at. Is this data representative? Is this data a good sample of the audience we care about? Is it already subject to some sort of selection bias? Oftentimes when I see analysis from different product leaders or even data teams, you can drive a truck through it, literally drive a truck through it. And if you present data with authority and that data is ridiculous or the analysis is just full of holes, you don't just not get benefit for that. You lose a whole bunch of brownie points. It would be better not to show up with an analysis that isn't clear than it would be to show up with an analysis that's dumb. And I see people self emulate on this actually relatively regularly because they just bring a knife to a gunfight or whatever, they did bring in an analysis that is just not, it doesn't hold water and they present it and then get shot down live, which is nobody's idea of a good time.
(00:41:21):
So if I give you a little bit of additional tactical things about that, it'd be okay if I'm looking at a piece of data, what was upstream of this piece of data and does that look normal? So this thing happened or whatever, which you're very, very excited about, what happened before that? And does that match what you think should have been right? So what happened before this momentous situation? And then, okay, for that thing that you're looking at, what happened after? If you have an idea of what happened before and after, that gives you some idea of whether or not this thing, is it all worth interesting to talk about? And then go one click above this data that you're looking at. So it's like, these things, let's say I'm looking at onboarding success. Let's say I'm looking at onboarding success to second week retention or something like that.
(00:42:05):
I'm like, "I have found this thing that totally crushes it. This intervention crushes it." If you go upstream and you find out that this intervention only applies to 2% of the inbound onboarding stream, it's meaningless. It's most likely just a random aberration. But even if it was not a random aberration, it's not a useful tool. And so you've got to go up and then you might go downstream and you might find, yep, they last for two in the second week, but in the third week they all churn. They're basically pointless. Why are we even talking about this? Or then you might step all the way back and go, "Okay, yes, those people do get retained for longer, but their average ASP is smaller." Because what we really care about, we do care about engagement and we care about more customers, but we want to keep the customers at a high ASP to reach a certain revenue goal.
(00:42:46):
The final goal is happy customers paying us money. So that's what I mean about going a click up. If you go a click to the left, a click to the right, so before and after and then a click up and you still see the thing that tells you the story that you want to tell, then now you've got something that's very compelling because people want to hear about that. They want to hear, "Well, what did happen before? What did happen after? And why is that outcome happening?" But you have to really do your homework and really be rigorous about it to avoid fighting fool's gold.

**中文翻译:**
我首先鼓励大家做的是：审视数据。如果你看到一个数据结果，而你的直觉告诉你这错得离谱，那它可能真的错了。首先相信你的直觉，去证明自己是对的。不要只看表面，因为大多数时候这符合“奥卡姆剃刀”原则：一个极其不符合直觉的事情，最可能的解释就是它错了，某个环节出了问题。当然，偶尔你也会发现直觉错了，而数据是对的。那些就是“淘到金子”的时刻，让一切努力都变得值得。有时你盯着数据看，心想：“就是它！这就是问题所在，我们找了这么久的东西。”
(00:40:18):
但你必须非常勤奋地跟进，真正理解你所看到的东西。数据有代表性吗？样本是我们关心的目标受众吗？是否存在选择性偏差？我经常看到一些产品领导者甚至数据团队的分析报告，简直漏洞百出（drive a truck through it）。如果你带着权威感展示一份荒谬或漏洞百出的数据分析，你不仅得不到好处，还会失去信任。与其拿出一份愚蠢的分析，不如不展示。我经常看到有人在这上面“自毁前程”，因为他们就像拿着小刀去参加枪战，分析根本站不住脚，结果在现场被打得落花流水。
(00:41:21):
所以，一些具体的战术建议：当我看一个数据点时，我会看它的**上游**是什么？看起来正常吗？你对某个结果很兴奋，但在此之前发生了什么？这符合你的预期吗？然后，看这个数据点之后的**下游**发生了什么？如果你了解了前因后果，你就能判断这件事是否值得讨论。接着，**向上跳出一层**来看。比如我在看新手引导（Onboarding）的成功率，以及它对第二周留存的影响。
(00:42:05):
我可能会说：“我发现这个改动效果炸裂！”但如果你往上游看，发现这个改动只覆盖了 2% 的新用户，那它就毫无意义，很可能只是随机偏差。即使不是偏差，它也不是个有用的工具。如果你往后看，发现他们第二周留存了，但第三周全流失了，那这改动也没意义。或者你再退后一步看：是的，这些人留存时间长了，但他们的平均售价（ASP）更低了。而我们最终关心的是高价值客户以实现收入目标。最终目标是让开心的客户付钱给我们。这就是我说的“向上看一层”。如果你向左看（前因）、向右看（后果）、向上看（全局目标），依然能讲通你的故事，那这就是一个非常有说服力的洞察。但你必须做足功课，保持严谨，避免把“愚人金”当成真金。

---

### [00:43:15] Lenny Rachitsky

**English:**
I love that advice. ASP, what does that stand for by the way?

**中文翻译:**
很棒的建议。顺便问下，ASP 代表什么？

---

### [00:43:19] Shaun Clowes

**English:**
Oh, average sale press, [inaudible 00:43:22] MRR or some other revenue metric.

**中文翻译:**
哦，平均售价（Average Selling Price），或者是 MRR（月经常性收入）之类的收入指标。

---

### [00:43:25] Lenny Rachitsky

**English:**
Got it. This point you made about how a lot of times experiments show positive and then they end up not being anything, I had the head of growth from Shopify on the podcast, and they do this really cool thing where they keep holdouts for years of cohorts and then it auto emails them I think a year or two later, "Hey, check this and see if these cohorts, this is still higher or not." And 40% of the time, it turns out neutral after a positive experiment long term.

**中文翻译:**
明白了。你提到的“实验结果起初是正向的，最后却化为乌有”这一点，我之前请过 Shopify 的增长负责人，他们做了一件很酷的事：他们会对某些用户群组保留长达数年的“对照组”（Holdouts），然后系统会在一两年后自动发邮件提醒：“嘿，检查一下这些群组，看看当年的正向指标现在是否依然领先。”结果发现，40% 的情况下，长期来看当年的正向实验最后都变成了中性（无显著差异）。

---

### [00:43:50] Shaun Clowes

**English:**
Interesting. It's really funny because the last time we did something similar, we had a global holdout group actually that was held out of all experiments. The experiment platform couldn't target that group at all. So 10% of all people never saw anything ever. So that's be really, really helpful because you can always compare them against whatever the experience was for any of the same vintage of cohort. I agree with you. But the other thing is I don't really love some of that thinking process just in general.
(00:44:14):
It's like, "Hey, let's say an experiment does show a temporary benefit. If an experiment shows a temporary benefit, but that benefit does not persist forever, does that mean the temporary benefit was never worth it? Or does that just mean the temporary benefit was an opportunity to reach another level you just didn't capitalize on?" I don't think there's a perfect answer, is what I'm trying to say. I don't think that the fact that a benefit doesn't last forever means that you failed. But I agree with you that not trying to understand, well, what has the net benefit been, what has the net lift been is also really important too. That's why growth is so hard. Growth is part of product is so especially hard.

**中文翻译:**
很有趣。我们上次也做了类似的事，我们有一个“全局对照组”，他们被排除在所有实验之外。实验平台完全无法触达这组人。所以 10% 的用户永远看不到任何实验改动。这非常有用，因为你可以随时将他们与任何同期的用户群组进行对比。我同意你的看法。但另一方面，我不太喜欢那种一概而论的思维方式。
(00:44:14):
比如，如果一个实验显示了短期收益，但这个收益没有永远持续下去，这是否意味着短期收益就不值得拥有？或者它只是意味着这个短期收益曾是一个让你达到新高度的机会，只是你没能把握住后续？我想说的是，这没有标准答案。我不认为收益没有持续到永远就代表失败。但我同意，如果不去理解净收益和净提升到底是多少，也是不对的。这就是为什么增长这么难，作为产品一部分的增长工作尤其难。

---

### [00:44:49] Lenny Rachitsky

**English:**
Marketers, I know that you love TLDRs, so let me get right to the point. Wix Studio gives you everything you need to cater to any client at any scale, all in one place. Here's how your workflow could look. Scale content with dynamic pages and reusable assets effortlessly, fast-track projects with built-in marketing integrations like Meta, CPI, Zapier, Google Ads and more, A/B test landing pages in days, not weeks with intuitive design tools, connected tracking and analytics tools like Google Analytics and Semrush can capture key business events without the hassle of manual setup, manage all your client's social media and communications from a unified dashboard, then create, schedule and post content across all their channels. If you're working on content rich sites, Wix Studio with no code CMS lets you build and manage without touching the design. And when you're ready for more, Wix Studio grows with you, add your own code, create custom integrations with Wix made APIs or leverage robust native business solutions. Drive real client growth with Wix Studio. Go to wixstudio.com. So you built the first B2B growth team when you were Atlassian, correct?

**中文翻译:**
营销人员们，我知道你们喜欢简明扼要，那我就直入主题。Wix Studio 为你提供满足任何规模客户需求所需的一切。你的工作流可以是这样的：利用动态页面和可复用资产轻松扩展内容；通过内置的营销集成（如 Meta、CPI、Zapier、Google Ads 等）加速项目进度；利用直观的设计工具在几天内（而非几周）完成落地页的 A/B 测试；连接 Google Analytics 和 Semrush 等分析工具，无需手动设置即可捕捉关键业务事件；通过统一的仪表盘管理客户的所有社交媒体和沟通，创建并发布内容。如果你在做内容丰富的网站，Wix Studio 的无代码 CMS 让你无需触碰设计即可管理内容。当你需要更多功能时，Wix Studio 随你共同成长：添加代码、使用 Wix API 创建自定义集成或利用强大的原生业务解决方案。用 Wix Studio 驱动客户增长，请访问 wixstudio.com。言归正传，你在 Atlassian 时建立了第一个 B2B 增长团队，对吗？

---

### [00:45:56] Shaun Clowes

**English:**
Yes. Yeah, it makes me feel like an old person, but yes, it was a very long time ago.

**中文翻译:**
是的。这让我觉得自己老了，但没错，那是很久以前的事了。

---

### [00:46:00] Lenny Rachitsky

**English:**
Slash maybe it's a new thing.

**中文翻译:**
或者说，这其实是个新鲜事。

---

### [00:46:01] Shaun Clowes

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:46:03] Lenny Rachitsky

**English:**
It's either a long time ago or it's just recently figured out this is a thing that you could do in a B2B is focus on growth.

**中文翻译:**
要么是很久以前的事，要么是大家最近才意识到在 B2B 领域也可以专注做增长。

---

### [00:46:11] Shaun Clowes

**English:**
Yeah, it is. So that was around about 2012, and at that time growth hacking was a thing. People don't really use that term anymore, but in B2C it was a very big deal because people could see Facebook doing their 10 friends in seven days and they could see this kind of thing that was working for people. And they're like, "Man, that's amazing." And at Atlassian we set out to go, "Okay, well, do those techniques work in B2B?" And also, it's kind of obvious now that a lot of them do and that it's worth doing. But at the time it wasn't that obvious because for a lot of B2B companies, I mean, you summarized it earlier, Lenny, distribution covers all faults. Almost all ills can be filled in by really great distribution.
(00:46:52):
If you have a really good marketing, a really good ground game, and you're kind of jamming your product into the channel, you're jamming your product in front of people and you're papering over the ugly parts with customer success people and services and consulting and whatever, that people will buy almost any software or you can certainly be successful with a lot of different software. But back in 2012, it wasn't clear of like, okay, which instead you went at this differently and you've heard them in software that sell itself, is the juice worth the squeeze? And now I would say that it's pretty clear that the juice is worth the squeeze to the point that lots of think about this all the time, but it was a bit of an interesting time at that time.

**中文翻译:**
是的。那是 2012 年左右，当时“增长黑客”（Growth Hacking）正流行。现在人们不太用这个词了，但在当时的 B2C 领域这可是件大事，大家看到 Facebook 搞“7 天加 10 个好友”之类的手段非常奏效，都觉得太神奇了。在 Atlassian，我们开始思考：“这些技术在 B2B 领域有用吗？”现在看来，很多技术显然是有用的，而且值得去做。但在当时并不明显，因为对于很多 B2B 公司来说，正如你之前总结的，分发可以掩盖一切缺点。只要分发做得好，几乎所有问题都能解决。
(00:46:52):
如果你有极强的营销和地面部队，把产品强行塞进渠道，塞到客户面前，然后用客户成功、服务和咨询团队来掩盖产品不好用的地方，人们几乎会买任何软件，或者说你靠很多平庸的软件也能成功。但在 2012 年，大家还不确定：如果走另一条路，做那种“自己会卖自己”的软件，投入产出比（is the juice worth the squeeze）划算吗？现在我认为答案很明确：非常划算，以至于大家现在一直在思考这个问题。但在当时，那是一个很有趣的探索时期。

---

### [00:47:34] Lenny Rachitsky

**English:**
And that was essentially the beginnings of product-led growth. Is that a simple way to think about it?

**中文翻译:**
那基本上就是“产品驱动增长”（PLG）的开端，可以这么简单理解吗？

---

### [00:47:38] Shaun Clowes

**English:**
Basically it's now called PLG, but yeah, at that time we didn't even know what to call it exactly.

**中文翻译:**
基本上是，现在叫 PLG，但当时我们甚至不知道该怎么称呼它。

---

### [00:47:42] Lenny Rachitsky

**English:**
Just growth. So based on that experience, a lot of B2B companies now have growth teams through investing in growth, what makes a great growth team in B2B? Any pitfalls you often find folks fall into that you think they should try to avoid?

**中文翻译:**
就叫“增长”。基于那段经验，现在很多 B2B 公司都通过投资增长建立了增长团队。那么，在 B2B 领域，什么是出色的增长团队？你发现人们常掉进哪些坑，是应该尽量避免的？

---

### [00:47:57] Shaun Clowes

**English:**
Ultimately, a lot of these types of endeavors are a matter of balance. So what I mean by that is growth teams tend to go through a set of phases. Their first phase is proving their value at all. So call that the gold rush phase. This thing's probably not worth even doing. Why are we doing this, merry band of people out there trying to prove that there's some growth effect somewhere? So that's the proof of phase. And so the advantage of that phase is life's good because there's usually a lot of growths to be found because nobody's gone looking before, so life's good. But it's pretty random because you're just literally searching across a random search phase going, "Have we tried X? Have we tried Y? Have we tried Z?" Then once you get that model going, then it starts to be, "Okay, how do we scale this thing? Is this just a flash in the pan? Do we just find a little bit of low hanging fruit and there's nothing else here, there? Is this just a project we should have done rather than an ongoing thing?"
(00:48:52):
So you have to make it a system. You have to prove that it can be repeated, and then you have to scale it. It has to become a thing. It has to become part of your DNA. You have to be taking a PLG lens to everything you do, all the way from paid acquisition to activation, retention, engagement, cross product expansion, upsells, I mean, you name it, all the different ways you can grow a product by revenue or engagement. There's many different ways to go about that. And so you end up having to scale out and be able to do all of those different things. And then you have to figure out how you fit in with the rest of the organization because there's other people who build products all day every day.
(00:49:27):
There's other people who sell that product all day, all day. There's other people who market that product all day, all day. And so growth organizations are in this interesting space, they're in between everybody else. They're in everybody else's sandpit in a little bit, in a little way, and they're kind of at the edge of everybody's full-time job and they are very valuable, but they can be complicated because of all those relationships, and because of the way they sit amongst all of the other parts of the organization. So many organizations fail because they don't really find much the wins or when they do find wins, it just seems totally random. Or they do find a lot of wins, but they all can't understand them because they seem like they're just a random walk through a bunch of potential opportunities. There's many different ways to fail to fit as you go through your growth phase from trying the ideas to success, to scaling, to operationalizing.

**中文翻译:**
归根结底，这类尝试在于“平衡”。增长团队通常会经历几个阶段。第一阶段是证明自身价值，可以称之为“淘金期”。当时大家会怀疑：“这事儿值得做吗？为什么这群人要在那里试图证明到处都有增长效应？”这是证明期。这个阶段的好处是日子很好过，因为以前没人找过增长点，所以到处都是机会。但过程很随机，你只是在随机搜索：“试过 X 吗？试过 Y 吗？试过 Z 吗？”一旦模式跑通，就开始进入第二阶段：“如何规模化？这只是昙花一现吗？我们是不是只摘了点低垂的果实就没戏了？这应该是个持续的职能还是个一次性项目？”
(00:48:52):
所以你必须把它系统化。你必须证明它是可重复的，然后规模化。它必须成为公司 DNA 的一部分。你必须用 PLG 的视角审视一切：从付费获客到激活、留存、参与度、跨产品扩张、增购等等。增长产品的方式有很多种。你最终必须扩展能力去处理所有这些环节。然后，你得搞清楚如何与组织的其他部分共处，因为还有人在整天开发产品、卖产品、做营销。
(00:49:27):
增长团队处于一个有趣的位置：在所有人之间。你在某种程度上进入了别人的领地，处于别人全职工作的边缘。增长团队很有价值，但因为这些复杂的关系以及在组织中的位置，情况会变得很复杂。很多组织失败是因为找不到明显的增长点，或者即使找到了，看起来也完全是随机的。或者他们赢了很多次，却无法理解为什么赢，看起来就像是在一堆机会中随机漫步。从尝试想法到成功，再到规模化和运营化，每个阶段都有可能因为无法融入组织而失败。

---

### [00:50:18] Lenny Rachitsky

**English:**
One of the biggest memes along these lines is a lot of companies claim there's like just PLG rarely ever works. You always, either you try it and it just doesn't work or it eventually just peters out, I guess. Any thoughts on just what are signs that your product has a chance to work, peel product-led growth versus just go straight to sales immediately and don't even worry about this?

**中文翻译:**
关于这个话题有个很大的梗：很多公司声称 PLG 很少奏效。要么试了没用，要么最终就逐渐枯竭了。你觉得有哪些迹象表明一个产品有机会通过 PLG 成功，而不是应该直接去做销售，完全不用担心增长团队的事？

---

### [00:50:44] Shaun Clowes

**English:**
First let's examine the counterfactual, right? So let's start with the opposite of your question and say, "Hey, how would the world be sadder if we all just gave up on PLG?" We just said, "Hey, there's no point in doing it in B2B SaaS." The problem is that there is not a natural force that pulls companies towards thinking about the end user's enjoyment and success early in their journey. There is no natural force, there's no natural kind of a link force. Why is that? I mean, 101, the buyer is the most important person. The economic bar is the most economic person. Their needs are the number one thing. They're usually the person driving the RFP. They're usually the person dealing with the sales organization. So the needs of the person who you hear are usually all feature-driven and they're not from the end users.
(00:51:34):
And so you're kind of sowing a seed of your own demise if you don't think about that end user. But it's one thing to say that you should think about the end user, it's a whole other thing to have a system by which you do that because people pay lip service to all sorts of things. But I'm sure you've heard this one before, but in economics, people only do what their incentives told them to do. Broadly speaking, that is what they do, that is what happens. You get what you set out to measure. You get what you give people incentives to do. If there is nobody in the organization whose true incentive is to measure their end user success, their enjoyment, their happiness, their retention, their engagement early on, it will not happen. Or at best it will be a hobby. And so then by extension, if I start from there, then I say, "Okay, let's say it doesn't exist, PLG doesn't exist and therefore it's a hobby and therefore there will be a bunch of hobby people who care about this."
(00:52:23):
Then you ask yourself, "Okay, will that mean that there will be many products for which those experiences really suck? And does that mean that that will be an opportunity for competitors of those products to be better at that? And is that a differentiated competitive advantage?" Yeah, I'd say it is. I'd say it is. And so I just work my way backwards and I go, "Okay, you can say that your PLG investment might be too high." You could be like, "Well, if I invest more, I won't get any more juice. I can't spend my life just experimenting in the onboarding. That's not the only thing that matters." And that's very, very true, but it's very hard to argue it should be turned to zero.
(00:52:59):
And so to me, therefore it's about the balance. It's about, "Okay, how does PLG fit with the other different ways that I grow in my business?" At Confluent, for example, we have a PLG function. We do grow with self-serve signups. People who sign up, literally their credit card, lots of them sign up and they're very successful, never speak to us. We also have an enterprise sales team that sells directly to very big companies, some of the biggest banks in the world, the people you would definitely know of. I don't think it has to be one or the other. I think that it's about a balance. It's about getting the motions to work and for really sophisticated companies, the people who really nail this, it's about making both motions work together. If you can get a PLG motion work to feed your sales team and a sales team motion work to feed your PLG funnel when the sales leads aren't ready yet and you can get those motions into playing with each other, you can make a lot of money.
(00:53:52):
It can be an extremely successful way to go to build a very resilient business. Why? Because you get a lot of customers and you get a lot of revenue. You can't be that successful as a company if you have a lot of revenue, but a small number of customers because you're captive, everyone knows that. You can't be that successful as a company if you have a lot of customers, but not enough revenue because you shouldn't have enough money to sustain operations. So the magic is in having both, a very large number of customers and a very large amount of revenue, it's very hard to knock over a company like that. If I look back on my time at Atlassian, and I think that they shared their most recent numbers, I can't remember what it was, but it was in the public data or whatever, something 80,000 or 100,000 customers, something like that.
(00:54:30):
That's a lot of customers. That's a lot of customers. Let's say you're going up against Jira and you're like, "Yeah, man, I'm going to pick off 1,000 customers from Atlassian." That's a lot, right? That's a lot. Obviously 1,000 customers is a lot. You only have 19, sorry, it's going to be 89,000 to go or 79,000 to go, or however many it is to go. I can't remember their exact number of customers, but it's very hard to assail a company which has a very large number of customers and a very large amount of revenue. And so that why I think that PLG as a mechanism is incredibly important for almost any type of company, if you can make the motion work. Obviously there are companies for whom the motion just isn't relevant, but for those where it does matter, it seems like the juice is worth the squeeze.

**中文翻译:**
首先我们来看看反面论证。如果全世界都放弃 PLG，世界会变得多糟糕？如果我们说 B2B SaaS 做增长没意义，问题在于：公司内部没有一种天然的力量会促使人们去关注终端用户在旅程初期的愉悦感和成功。完全没有。为什么？因为在商业常识里，买单的人（Buyer）最重要，财务决策者最重要。他们的需求是第一位的，他们驱动 RFP（招标），他们和销售对接。所以你听到的需求通常是功能驱动的，而不是来自终端用户。
(00:51:34):
如果你不考虑终端用户，你就是在埋下自我毁灭的种子。但“考虑终端用户”和“建立一套系统去关注终端用户”是两码事。人们口头上什么都答应，但经济学告诉我们：人们只做激励机制让他们做的事。你衡量什么，就得到什么。如果组织里没有人真正的激励目标是衡量终端用户的成功、愉悦感、留存和早期参与度，那这件事就不会发生，或者充其量只是个业余爱好。如果 PLG 不存在，它就成了业余爱好，只有一帮业余的人在关心。
(00:52:23):
那么问问自己：这是否意味着很多产品的用户体验会变得很烂？这是否意味着那些做得更好的竞争对手会有可乘之机？这是否是一种差异化的竞争优势？我会说是的。所以我倒推回来：你可以说 PLG 投入太高了，边际收益递减，你不能一辈子只在新手引导上做实验。这没错，但你很难论证 PLG 的投入应该降为零。
(00:52:59):
所以对我来说，关键在于平衡。PLG 如何与业务增长的其他方式结合？比如在 Confluent，我们有 PLG 职能，有自助注册，很多客户刷信用卡就能用得很好，从不跟我们说话。同时我们也有企业销售团队，直接卖给全球最大的银行。我不认为这必须是二选一，而是一种平衡。对于真正顶尖的公司，他们能让两种模式协同工作：PLG 模式为销售团队输送线索，销售模式在客户还没准备好买大单时把他们引向 PLG 漏斗。如果能让这两种模式互补，你能赚大钱。
(00:53:52):
这是一种建立极具韧性业务的成功方式。为什么？因为你既有海量客户，又有巨额收入。如果收入很高但客户很少，你会被大客户绑架；如果客户很多但收入不足，你无法维持运营。魔法在于两者兼得。很难打倒这样一家公司。回想我在 Atlassian 的时光，我记得公开数据显示他们有 8 万或 10 万客户。
(00:54:30):
那是海量的客户。假设你想挑战 Jira，你说：“我要从 Atlassian 手里抢走 1000 个客户。”1000 个很多了吧？但人家还有 8 万 9 千个。很难撼动一家拥有海量客户和巨额收入的公司。这就是为什么我认为 PLG 机制对几乎任何类型的公司都至关重要，只要你能让这个模式跑通。当然，有些公司确实不适用，但只要适用，投入产出比就非常高。

---

### [00:55:18] Lenny Rachitsky

**English:**
That was an awesome answer. I looked up last year and they have 300,000 customers.

**中文翻译:**
太棒的回答。我查了一下，去年他们已经有 30 万客户了。

---

### [00:55:23] Shaun Clowes

**English:**
Oh man, I'm so far off. When I left it must have been 80,000 customers.

**中文翻译:**
天哪，我落后太多了。我离开时大概是 8 万客户。

---

### [00:55:28] Lenny Rachitsky

**English:**
They've done good work since then. Also, you're talking about incentives and how the power of incentives. Charlie Munger has this great quote I looked up just to make sure I get it right. "Show me the incentive and I'll show you the outcome."

**中文翻译:**
从那以后他们做得很好。另外，你提到了激励的力量。查理·芒格有一句名言，我特意查了一下确保没记错：“告诉我激励机制，我就能告诉你结果。”

---

### [00:55:40] Shaun Clowes

**English:**
Yeah, exactly right. I've seen cases where a sales team was people trying to get a sales team to do a PLG motion, and you can beat them over the head as much as you like, you can get into a meeting and tell them that you really, really want them to do this, but at the end of the day, they're not going to do it. And the same is true for every other kind of function. It's just the nature of things.

**中文翻译:**
没错。我见过有人试图让销售团队去做 PLG 动作，不管你怎么苦口婆心，或者在会上强调你有多希望他们这么做，归根结底，他们就是不会去做。其他职能部门也是一样，这是天性使然。

---

### [00:56:02] Lenny Rachitsky

**English:**
I have some newsletter posts around the stuff of folks want to dig deeper. Also, Elena Verna had an awesome podcast episode talking about product-led sales and kind of the combination of these two things that we'll point to.. Just a whole other topic we can go deep, deep on, but we're not going to do that in this episode. Maybe just one more question. So you mentioned all the companies you worked at, so you've been at Salesforce, chief product officer, MuleSoft, specifically within Salesforce, Metromile, Atlassian, Confluent now, a lot of really interesting and different roles. How do you choose where to go work and how do you choose which opportunities to take? I imagine you have many options.

**中文翻译:**
我有一些关于这些内容的通讯文章，感兴趣的听众可以深挖。另外，Elena Verna 也有一集很棒的播客，讨论了“产品驱动销售”（Product-led sales）以及这两者的结合，我们会附上链接。这又是一个可以深聊的话题，但我们今天就不展开了。再问一个问题：你提到了你工作过的所有公司——Salesforce、MuleSoft 的 CPO、Metromile、Atlassian，现在在 Confluent。这些角色非常有趣且各不相同。你是如何选择去哪里工作，以及如何选择机会的？我猜你有很多选择。

---

### [00:56:42] Shaun Clowes

**English:**
I have to think of my career. So in hindsight, looking at it this way, Lenny, so I don't know if forward-looking was obvious to me this way. But looking back, my career has been a little bit like a bingo card. I've always been looking to fill in boxes I didn't have filled because I felt like that would make me a better professional. It's like if I didn't know anything about that specific type of sales model or that type of marketing or that type of product management or that type of product or that layer in the stack or that kind of thing is like, well, if I learn about that thing, I will become more versatile. So actually two things, it's fun, it's fun to learn something new. It's fun to prove to yourself that you can do those new things and then it makes you more versatile because it means that any given problem you go up against, you've seen something that pattern matches to it.
(00:57:29):
It kind of feels like you end up bringing a gun to a knife fight in a way because every problem you look at, you're like, "Oh, I have seen this from the other side. I've seen this from some other angle, and so I know that this is likely to work and this is unlikely to work." And so when I joined early on in my career, I was working for a big enterprise software company, sorry, small enterprise software company that sold to the Fortune 100. When I joined Atlassian, and like I shared with you, we had no sales force at all actually at all. Literally nobody to sell the software. It sold itself or it didn't get sold at all. And we grew to have 80,000 customers. It was just pure product. They had growth and just an incredible company. Then it was at Metromile, which was a consumer company that got acquired, made an insurance product for end consumers.
(00:58:13):
So they got nothing to do with technology products, like literally a complicated Internet of things device you installed in your car, but ultimately it's an insurance product that you'd sell to grandmothers in Florida as much as you would ever millennials. And then at MuleSoft to totally back end software that's used by IT organizations and a consulate infrastructure that's used by developers everywhere to build really interesting data-driven applications, data powered applications to do all sorts of things in real-time. And you look at across all that and you go, "It's all a bit random." But I didn't see it that way because I learned, I actually was in sales for a bit, so I ran a pre-sales engineering group, went around the world selling software. So when I joined Atlassian, I wanted to kind of understand what it was to sell software at massive scale with no sales team, can it even be done?
(00:59:01):
And so I learned a lot in my time at Atlassian. When I went to Metromile, I'm like, "Well, I've never built a consumer product before." I can say that I've actually built a product that's touched many millions of people because Jira has, so I felt pretty good about that, but I'd never built one that I could say, "Yep, a consumer, your average consumer can use this thing. It's so simple. Even my grandma can use it." I'd never built a product like that. So I got that experience at Metromile, which is really fun. I'd never worked inside an organization as big as Salesforce or an organization with as good a sales motion. You talked about distribution earlier. Salesforce is an absolutely insane distribution machine, just an incredible company with just an amazing distribution network and a fantastic marketing approach that it's like a PhD in marketing.
(00:59:44):
When you spend your time at Salesforce, you're like, "This company is just one of a kind. It's a one of kind, and it's so outlandishly good at one specific thing." And so looking back, all of these jobs have been, when I say bingo card, I've just got an outlandish education in these areas that are not obvious at all. And once you've seen them, they're like superpowers. They're superpowers to be able to bring that same experience to bear on things. And so one thing that I really I'm trying to figure out is why often people don't do that. And oftentimes people stay in a very specific domain. They prefer to stay in a domain or they prefer to stay in a specific kind of type of company or a role that works in a certain way, like companies that have the same operating model or they plan the same way or they try to stay with things that are pretty similar. But it seems obvious that the most likely way to really grow is the opposite.
(01:00:41):
It's to constantly be choosing things that are either outside that, not totally outside the lines. Don't jump out of a plane if you've never parachuted before. Obviously you want them to be in some way and adjacency, that you want them to have something in common with what you know, but you want them to stretch you and change you. I had a really transformative experience many, many years ago when I was at Atlassian and a guy called Tom Kennedy, he was our general counsel, so chief legal officer basically, and a lifelong lawyer, very smart guy. I liked him very, very much. But just a lawyer. Just a lawyer, corporate lawyer, corporate counsel, I'm sure you know what they're like. And really great guy. And I remember, so mostly in our meetings he didn't talk that much except about legal things. But I remember in one meeting we were having this vigorous debate about a product strategy question about what we should do. Should we go left or should we go right?
(01:01:39):
And as usual, he's there and he's mostly just staying silent. And then eventually the conversation's been going on for 15 minutes and he is like, "Hey, everybody, a year ago we talked about X, Y and Z," and he proceeds to lay out our product strategy at that time, and he's like, "Just recently we said the following things, and that was a product strategy, whatever. Now you are saying this. Isn't it obvious that isn't this? What you guys are saying is not congruent with that, and if you really meant what you said back then we should be doing X." And again, the room went silent, everybody kind of turned to him, kind of nodded, and then everyone went, "Yeah, okay, I guess we probably should be doing it differently." And so the meeting stopped when the GCE randomly mentioned that he deeply understood our product strategy and he knew enough to be able to contribute in that way.
(01:02:24):
And so the life-changing part for me about that was just this realization that if I'm going to be a really great professional, the type of professional I want to be is that type of person. The type of person who can contribute to the whole company in all sorts of ways, doesn't spend all of their time in everybody else's business, but understands the business and has the mental horsepower and the experience to be dangerous in all sorts of, and I mean, that in a compliment way. I don't mean that in a negative way, but to be dangerous in all sorts of situations. I think that when you have leaders like that behind you and with you, then you're just unstoppable. You're an unstoppable force in business when you have that motion happening.

**中文翻译:**
我得回顾一下我的职业生涯。Lenny，回想起来，我的职业生涯有点像一张“宾果卡”（Bingo card）。我一直在寻找填补那些我还没填上的格子，因为我觉得这会让我成为更专业的职场人。比如，如果我不了解某种特定的销售模式、营销方式、产品管理类型，或者不了解技术栈的某个层级，我会觉得：如果我学会了那个，我就会变得更全能。这有两点好处：第一，很有趣，学习新东西并证明自己能做到很有成就感；第二，它让你更全能，面对任何问题时，你都能找到匹配的模式。
(00:57:29):
这感觉就像你在刀战中带了一把枪，因为每当你看到一个问题，你会想：“哦，我从另一个角度见过这个，我知道这样做可能行，那样做可能不行。”职业生涯早期，我在一家卖给财富 100 强的小型企业软件公司工作。加入 Atlassian 时，正如我分享的，我们根本没有销售团队，软件全靠自销。我们增长到了 8 万客户，那是纯粹的产品驱动。然后是 Metromile，一家被收购的 C 端公司，做汽车保险。
(00:58:13):
那和纯技术产品完全不同，它涉及安装在车里的复杂物联网设备，最终卖给佛罗里达的老奶奶，也卖给千禧一代。接着是 MuleSoft，完全是给 IT 组织用的后端软件；现在在 Confluent，是给开发者用的基础设施，用于构建实时数据驱动的应用。横跨这些领域，看起来很随机，但我并不这么看。我甚至做过一段时间销售，管理过售前工程团队，跑遍全球卖软件。所以加入 Atlassian 时，我想理解：在没有销售团队的情况下，如何大规模卖软件？这真的可行吗？
(00:59:01):
我在 Atlassian 学到了很多。去 Metromile 时，我想：“我从没做过 C 端产品。”虽然 Jira 影响了数百万人，但我从没做过那种“连我奶奶都能用”的极简产品。所以我在 Metromile 获得了那种体验。我也从没在像 Salesforce 这么大的组织里工作过，也没见过那么强的销售机器。你之前提到分发，Salesforce 是一个极其疯狂的分发机器，拥有惊人的分发网络和营销手段，简直就是营销界的“博士后”。
(00:59:44):
在 Salesforce 工作，你会感叹这家公司真是独一无二，在某个特定领域强得离谱。所以回过头看，这些工作就像宾果卡，让我在这些不那么显见的领域获得了极好的教育。一旦你见过这些，它们就成了你的“超能力”。我一直在想，为什么很多人不这么做？人们往往倾向于留在某个特定领域、特定类型的公司或特定的角色里，寻找相似的运营模式。但显然，真正成长的最佳路径是相反的。
(01:00:41):
要不断选择那些在舒适区边缘、甚至稍微出格的机会。当然，如果你从没跳过伞，别直接跳出飞机。你希望新机会与已知领域有某种关联，但又能拉伸你、改变你。多年前在 Atlassian，我经历了一次改变认知的时刻。我们的总法律顾问 Tom Kennedy，一个非常聪明的资深律师。我很喜欢他，但他就是个典型的公司律师。在会上他通常不怎么说话，除非涉及法律。有一次，我们正在激烈争论一个产品战略问题：该往左走还是往右走？
(01:01:39):
他照例坐在那里保持沉默。争论了 15 分钟后，他开口了：“嘿各位，一年前我们讨论过 X、Y、Z，”他开始陈述当时的战略，“最近我们又说了 A、B、C。现在你们说的这些，显然与之前的战略不一致。如果你们真的坚持当时的初衷，我们现在应该做 X。”全场鸦雀无声，大家点头示意，然后说：“好吧，我想我们确实应该换个做法。”会议就这样结束了，因为一个法律顾问竟然深刻理解我们的产品战略，并能据此给出关键建议。
(01:02:24):
那一刻改变了我。我意识到，如果我想成为一名顶尖的专业人士，我就要成为那样的人：一个能以各种方式为整个公司做贡献的人。他不一定整天插手别人的业务，但他理解业务，拥有足够的脑力和经验，在各种情况下都能给出“致命”的见解（褒义）。当你身边有这样的领导者时，你们就是不可阻挡的力量。

---

### [01:03:06] Lenny Rachitsky

**English:**
Wow, that was an awesome story and an awesome perspective. It's similar to the advice I always give PMs of people always wondering, "Should I go deep on a specific subject? Should I just try different things?" And I find just variety, especially earlier in your career is really powerful, not just to help you discover the thing you like, but also to your point, just using insights from all these different parts of the product and internal tools and trust and safety and platform and consumer product side and growth and just core stuff. The more of that you have, the stronger you get. And I feel like another benefit of your approach is if you work at just B2B SaaS companies, if you have too many of that on your resume, it's very hard to get hired a consumer company. And so just having it creates a huge optionality for you if you do, which you did.

**中文翻译:**
哇，这个故事和观点太棒了。这和我给 PM 的建议很像。人们总在纠结：“我是该深耕某个领域，还是尝试不同的东西？”我发现多样性（尤其是在职业生涯早期）非常强大。不仅能帮你找到真爱，还能让你整合来自产品各个环节的洞察——内部工具、风控、平台、C 端、增长、核心业务。你接触得越多，你就越强大。而且你这种做法还有一个好处：如果你简历上全是 B2B SaaS，很难被 C 端公司录用。而你这种跨界的经历为你创造了巨大的选择权。

---

### [01:03:57] Shaun Clowes

**English:**
Yeah, it's interesting because people used to talk about people who are T-shaped or whatever, and I've never really loved the analogy because it's more like people are scribble shaped. I mean, there's the really best people you've worked with, they're more like scribbles than they are T-shaped because of course you want to be horizontally capable, so you want to be broad and you do want to be deep, but you actually want to be deep in way more than one thing. Now obviously when I say deep, I don't mean I'm not able to do the job of our finance function all day every day, but I'm 100% good enough to go three clicks below the simple financial analysis. I can go reasonably deep in our financials because I want to and because it's partly it matters. It's important to be able to do that. And so maybe a different way to think about that bingo card is I've rarely regretted going deep in something that isn't quite my job.
(01:04:51):
I've rarely regretted it. The worst case scenario is I've learned something new that I will never use, which I guess at least that made my brain slightly more agile. I don't know, there must be some potential benefit of that. But the very best case scenario is that when I least suspect it at some point in the future it will turn out to be the thing that matters. It will be the tool that I need, but I'm facing some important problem and I will be like, "Oh my god, this was worth every cent." And so if you think about it on an ROI basis, doing things that aren't in your wheelhouse, that aren't the things directly in front of you, the ROI can really be outlandish. It can be off the charts great, but I guess it's speculative. Because you don't know you're going to need it tomorrow. You don't know if it's going to be something that's going to be a regular tool you use.

**中文翻译:**
是的。很有趣，人们常说“T 型人才”，但我从不喜欢这个比喻。我觉得顶尖人才更像是“涂鸦型”（scribble shaped）。你当然希望有横向的广度，也希望有深度，但你其实希望在不止一个领域有深度。当我谈到深度时，并不是说我能全职做财务的工作，但我绝对能对财务分析进行“三次点击”深度的挖掘。我能深入研究财务报表，因为我想学，也因为这很重要。所以，关于宾果卡的另一种思考方式是：我很少后悔深入研究那些不属于我本职工作的事情。
(01:04:51):
我几乎从未后悔过。最坏的情况是我学到了永远用不到的新知识，但至少让我的大脑更灵活了。而最好的情况是，在未来的某个时刻，当我最意想不到的时候，它成了解决关键问题的关键工具。我会感叹：“天哪，当年的投入太值了。”所以从投资回报率（ROI）来看，做那些不在你职责范围内、不在你眼皮底下的事，回报可能是惊人的，甚至是爆表的。虽然这带有投机性，因为你不知道明天是否用得上，也不知道它是否会成为常用工具。

---

### [01:05:33] Lenny Rachitsky

**English:**
What's interesting is the bingo card is the analogy. Is there a bingo moment at the end of this? Is there retirement?

**中文翻译:**
有趣的是宾果卡这个比喻。最后会有“Bingo”时刻吗？比如退休？

---

### [01:05:41] Shaun Clowes

**English:**
Oh, you mean you've got everything. You've got the collectible Pokemon?

**中文翻译:**
噢，你是说集齐了所有卡片？像收集齐了宝可梦一样？

---

### [01:05:45] Lenny Rachitsky

**English:**
Yeah, you collect them all.

**中文翻译:**
对，全部集齐。

---

### [01:05:46] Shaun Clowes

**English:**
Yeah, I was working with somebody at Salesforce and he'd been there a long time, very, very, very successful person. Honestly didn't need to work anymore. And he said something that I found really useful. He's like, "Well, now I'm at the point of my life where I want to work at the intersection of things that I am good at and things that will be valuable to the company to do." So basically it feels like the reward of completing your Bingo card is actually to just get to spend more time doing things that are leverage, that you enjoy and that are high leverage. And so that seems like a good outcome to me. I don't think most people are going to work and hopefully have some sort of great financial outcome and then go, "Well, that's it. I'm picking up stumps, I'm retiring." I think for most people, achieving some sort of financial outcome or some sort of independence or whatever is really just another stage. At that point it will be, "Okay, well now what do I do? What do I do with my life?"
(01:06:49):
And so that was why I said earlier that at the end of the day, product management is at times the worst job in the world and at times easily the best. And it's both and it can be both. And so it's hard for me to think about if I think about the things that are the intersection of what I'm good at and are valuable to the world, product management is a pretty fun one to do and it's different every day. So I think we're pretty privileged. For those of you who listen, I mean, obviously your podcast reaches a lot of product people. I think we're pretty privileged to be able to operate at that intersection, but it's not easy because you got to show value. It's a very complicated job to show value in and to demonstrate value to the world, and it's constantly being attacked, like you mentioned, but it's still amazing when it all goes right. When a product is very successful in the market, it's hard to describe the joy you get from that.

**中文翻译:**
我在 Salesforce 时和一位资深同事共事过，他非常成功，其实早就不需要工作了。他说了句让我受益匪浅的话：“我现在处于人生的这样一个阶段：我只想在‘我擅长的事’和‘对公司有价值的事’的交汇点上工作。”所以，集齐宾果卡的奖励其实是：你可以花更多时间去做那些你既享受、又有高杠杆效应的事。这对我来说是个很好的结果。我不认为大多数人在获得财务自由后会直接说：“好了，收工，退休。”对大多数人来说，财务独立只是另一个阶段。到那时你会问：“好了，现在我该做什么？我的人生该怎么过？”
(01:06:49):
这就是为什么我之前说，产品管理有时是世界上最糟糕的工作，有时又是最好的。它两者兼具。如果我考虑那些“我擅长”且“对世界有价值”的交汇点，产品管理是非常有趣的选择，而且每天都不重样。我觉得我们很幸运。对于听众来说，你们大多是产品人，能在这个交汇点上工作是一种特权。但这并不容易，因为你必须证明价值。在一个不断受到质疑的岗位上证明价值是很复杂的，但当一切顺利、产品在市场上大获成功时，那种快乐是难以言表的。

---

### [01:07:46] Lenny Rachitsky

**English:**
Kind of along those lines to close out our conversation before a very exciting lightning round, I want to take us to failure corner. People listen to these podcast episodes and everyone's always just sharing all these wins, everything's always going great. The CPO of this, CPO of that, just moving on up and people will want to hear times when things didn't go right. Because those are stories people don't share as often. Can you share a story when something didn't go right, when you maybe had a failure in the course of your career? And if you learned something from that experience, what you learned.

**中文翻译:**
在进入激动人心的闪电轮环节之前，我想带大家进入“失败角落”。听众们听播客时，总看到大家在分享成功经验，一切都很顺利，从这个 CPO 升到那个 CPO。但大家也想听听那些搞砸了的时刻，因为这些故事不常被分享。你能分享一个你职业生涯中没能按计划进行的失败案例吗？以及你从中学到了什么？

---

### [01:08:18] Shaun Clowes

**English:**
I mean, there's a lot of things that didn't go exactly to plan, Lenny. Very early on in my career, I was still a developer and I accidentally deleted one of the core systems of the company that I was working at. So that's going to go down in infamy, but luckily that one's far in the rear-view mirror. That-

**中文翻译:**
Lenny，没按计划进行的事太多了。职业生涯早期，我还是个开发人员，我不小心删掉了公司的一个核心系统。这简直是奇耻大辱，幸好那已经是很久以前的事了。

---

### [01:08:38] Lenny Rachitsky

**English:**
That wasn't Atlassian?

**中文翻译:**
那不是在 Atlassian 发生的吧？

---

### [01:08:41] Shaun Clowes

**English:**
No, that was far pre-Atlassian, but very bad. Yeah, the one I like to talk about, I wasn't directly responsible for it, but I feel responsible for it. I was at a company and we launched a product. That was one of those products that in hindsight should have been really obvious it was going to fail, but for some reason we were all blinded by the potential. It was a product that was about, it was basically to measure the environmental impact of your company and to help you reduce the environmental impact of your company by doing, think about it as a power management, building power management, managing the power drawer of computers, managing the power drawer of AC and all of that stuff. That was the vision basically. It's like a manage your environmental impact of your business. The idea was pretty cool at the time, and also it was the right time for that, and it's still a thing.
(01:09:33):
It's still an area of active research and investment or whatever, but it was one of those things, talk about the wrong company, wrong place, wrong time, wrong distribution. We had literally no right to win, no right to play, just absolutely no business in hindsight being in that business. And I feel really bad because I, again, good idea, wrong company. And at the end of the day, we launched the product. We actually kept the product in market for two years, and the final straw was weird. The final straw was actually when a customer finally wanted to pay for it. It had been in market for two years, and we found ourselves with a customer who wanted to pay millions of dollars for it. They were ready to sign on the dotted line, and that was actually the moment we decided to kill the product because we were like, "If this person signs this piece of paper, we are stuck with this forever. This one customer will be bound by contracts for however long or whatever."
(01:10:29):
So we actually ended up killing it. At the moment after two years of failure when somebody wanted to pay his money for it. And I look back on that and I'm just like, "Man, that was a really big..." I feel really bad because I'm like, "It should have been obvious. It was obvious and we should have been able to call a spade a spade and I guess speak truth to power." But instead it kind of got through to the keeper and turned out to be a real accidental drain on resources for years and just a big mistake.

**中文翻译:**
不，那远在 Atlassian 之前，但非常糟糕。我想聊的是另一个案例，虽然我不是直接负责人，但我深感责任。当时我在一家公司推出了一款产品，事后看来，它的失败是显而易见的，但当时我们都被它的潜力蒙蔽了。那是一款测量并帮助减少公司环境影响的产品，比如电力管理、建筑能耗管理、电脑和空调的功耗管理等。愿景是“管理企业的环境影响”。当时这个想法很酷，时机也对，现在这依然是个热门领域。
(01:09:33):
但问题在于：错误的地点、错误的公司、错误的分发渠道。我们根本没有赢的权利，甚至没有入场的权利，事后看来我们根本不该碰那个业务。我感到很遗憾，因为那是一个“好主意放在了错误的公司”。最终我们发布了产品，并在市场上维持了两年。最后的导火索很奇怪：竟然是因为终于有一个客户想付钱了。产品上市两年后，一个客户愿意付数百万美元买它，准备签字了。就在那一刻，我们决定砍掉这个产品。因为我们意识到：“如果这个人签了字，我们就永远被套牢了。我们将被合同束缚很多年。”
(01:10:29):
所以，在失败了两年、终于有人要给钱的时候，我们把它杀了。回想起来，我觉得很糟糕，因为失败本该是显而易见的。我们本该实话实说，向权力高层说出真相。但相反，它却一直拖着，成了多年来巨大的资源黑洞。那是一个巨大的错误。

---

### [01:10:58] Lenny Rachitsky

**English:**
So is the lesson there, just be real with yourself? I like that you have this forcing function of like, "Okay, this is getting for real now." Is it like, "I wish we had an earlier forcing function to force us to make a decision?"

**中文翻译:**
所以教训是“对自己诚实”吗？我很喜欢你提到的那个强制机制：“好吧，现在动真格的了。”你是不是在想：“要是早点有这种强制机制让我们做决定就好了？”

---

### [01:11:11] Shaun Clowes

**English:**
Yeah. I think if I could do it differently, I might not have necessarily been able to 100% change the decision, but I should have tried. I mean, it was pretty obvious after six months, this thing was a bit of a zombie product walking, and the least I could have done is said, "This thing is dead." We could have called it dead way earlier, but instead we proceeded for another year and a half investing in it. And so that's the bit that makes me feel like real bummer about it.

**中文翻译:**
是的。如果能重来，我不一定能 100% 改变决定，但我应该去尝试。其实六个月后就很明显了，这东西就是个“行尸走肉”般的产品。我起码应该说：“这东西没戏了。”我们本可以早得多就止损，结果却又多投了一年半。这才是让我感到最遗憾的地方。

---

### [01:11:39] Lenny Rachitsky

**English:**
It reminds me a recent episode with Raaz who is the CMO at Wiz, and she joined us the first PM and a few weeks into it with doing tons of calls with customers she's like, "I think I need a quick... Because I don't really understand what we were building. I don't get it." And everyone's like, "I don't either." And it just, yeah, the founders just had a vague idea what they're doing, but they didn't really have an idea. And that just sparked a, "Okay, wait, no one actually does. Let's actually get more concrete." And it helped them pivot. And now, I don't know if you know about Wiz, but they ended up being the fastest growing startup in history.

**中文翻译:**
这让我想起最近的一集，嘉宾是 Wiz 的 CMO Raaz。她作为第一个 PM 加入时，做了几周客户调研后说：“我想我得辞职……因为我真的不明白我们在造什么，我搞不懂。”结果大家说：“我们也搞不懂。”创始人只有一个模糊的想法，并不具体。这引发了大家的思考：“等等，既然没人懂，那我们就把它变具体。”这帮助他们完成了转型。现在 Wiz 成了历史上增长最快的初创公司。

---

### [01:12:19] Shaun Clowes

**English:**
Yes. Isn't that amazing, right? It doesn't mean it's permanently fatal, but asking that question and going through that reckoning turns out that came out stronger.

**中文翻译:**
是的，太神奇了对吧？这并不意味着永久性的致命伤，但提出那个问题并经历那次清算，反而让他们变得更强大。

---

### [01:12:29] Lenny Rachitsky

**English:**
Scary, but it turns out it's for the best often. Before we get to very exciting lightning round, is there anything else that you want to mention or leave listeners with maybe a last nugget, something that you think might be helpful before we wrap?

**中文翻译:**
虽然过程很吓人，但通常结果是好的。在进入闪电轮之前，还有什么想对听众说的吗？最后的一点金句或建议？

---

### [01:12:41] Shaun Clowes

**English:**
Maybe a couple of different things that I think are sometimes well understood, but just repeating them I guess because they're very valuable to me. One is that if you let your calendar rule you, then nothing good will happen. I know people talk about that a lot, but it's surprisingly common in product management in particular that people end up ruled by their calendar. And so it's related to that whole look at spend 80% of your time thinking about things going on outside the business. Easy said, very hard to do, and if you don't do it, no one's going to do it for you. And so it is really hard to be successful unless you find a way to force that to happen. So to repeat that, also, somebody said this to me, I never looked up the quote, but apparently Colin Powell said that if you're making a decision with less than 30% of the available data, you're making a big mistake.
(01:13:32):
If you're making a decision only after you have 70%, either the 70% or 77%, I can't remember the exact number, when you have 77% of all the available data, you have waited far too long. And I've always found that very insightful and it relates a little bit to what we're talking about about data earlier, but at the end of the day, we get paid in product management to make decisions, good decisions, paid to make good decisions that will deliver business benefit. And a decision with too little data is fatal. A decision that takes too long and collects too much data is also fatal. So everything, it's about trying to find the balance of all of these different things to try and deliver business advantage.

**中文翻译:**
有两点，虽然大家可能都听过，但我还是想重复一下，因为它们对我很有价值。第一，如果你让日历统治你，就不会有好事发生。我知道大家常说这个，但在产品管理中，被日历支配的情况极其普遍。这和我说的“花 80% 的时间思考外部”有关。说起来容易做起来难，如果你不主动掌控，没人会替你掌控。除非你强迫自己去做，否则很难成功。第二，有人曾告诉我（我没查过出处，据说是科林·鲍威尔说的）：如果你在掌握的数据少于 30% 时做决定，那是巨大的错误；但如果你等到掌握了 70% 或 77% 的数据才做决定，那你等得太久了。我觉得这很有洞察力，也和我们之前聊的数据话题有关。归根结底，产品经理的薪水是用来做决策的，做能带来业务收益的正确决策。数据太少是致命的，等太久、收集太多数据也是致命的。一切都在于寻找平衡，以交付业务优势。

---

### [01:14:07] Lenny Rachitsky

**English:**
A great way to circle back to all the things we've been talking about. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
这很好地总结了我们今天聊的所有内容。那么，我们进入闪电轮环节。准备好了吗？

---

### [01:14:15] Shaun Clowes

**English:**
Yes. Let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:14:17] Lenny Rachitsky

**English:**
Let's do it. What are two or three books that you have recommended most to other people?

**中文翻译:**
好的。你向别人推荐最多的两三本书是什么？

---

### [01:14:23] Shaun Clowes

**English:**
Yeah, they oldies but goodies, is probably going to be The Lean Startup that I still find actually really good. And the key lessons in there I still think are very applicable to a lot of people, particularly the cohort analysis bit, which for some reason I still don't see people do anywhere near enough cohort analysis. So there you go, that's my little tip. And then INSPIRED: How to build products that people love by Marty Kagan and the Silicon Valley product group. That's an oldie but a goodie. I think it's got a lot of the key lessons of product management in it, even though it's been around for a long time.

**中文翻译:**
都是些经典老书。一本是《精益创业》（The Lean Startup），我觉得它依然非常棒，其中的核心教训非常适用，尤其是“留存分析”（Cohort analysis）部分，不知为何我发现现在很多人做得还远远不够。另一本是 Marty Cagan 的《启示录》（INSPIRED），虽然出版很久了，但它包含了产品管理的大量核心教训。

---

### [01:14:53] Lenny Rachitsky

**English:**
Those are some classics. Very cool. Do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
确实是经典。最近有什么喜欢的电影或电视剧吗？

---

### [01:14:58] Shaun Clowes

**English:**
I'm watching a program. I don't get to watch very much TV, mostly at night. I like to watch things that are extremely light, that just don't at all inspire any element of stress and that are very short. So basically short and funny is basically my thing. And there's a new program on Netflix, I think it's called Detroiters.

**中文翻译:**
我最近在看一个节目。我不常看电视，通常在晚上看。我喜欢看那种非常轻松、完全没有压力且很短的东西。短小有趣是我的首选。Netflix 上有个新节目叫《底特律往事》（Detroiters）。

---

### [01:15:18] Lenny Rachitsky

**English:**
Oh, I've been watching that.

**中文翻译:**
噢，我也在看那个。

---

### [01:15:20] Shaun Clowes

**English:**
Yeah, it's really funny. I really like that. It's so ridiculous, but very funny. So I like that.

**中文翻译:**
是的，非常搞笑。我很喜欢，虽然很荒诞，但很有趣。

---

### [01:15:24] Lenny Rachitsky

**English:**
The main guy, he's so funny. I forget his name. Tim Sweeney or something like that. Yeah, he's so good. Good one. I've been watching that, I'm loving it. It's very quirky. I think the New York Times quote on there is "Very weird," the quote.

**中文翻译:**
主角太逗了，我忘了他的名字，好像叫 Tim Robinson 之类的。非常棒。我也在看，很喜欢，非常古怪。《纽约时报》给它的评价就是“非常怪异”。

---

### [01:15:38] Shaun Clowes

**English:**
It's so weird. In the first episode I'm like, "What is this show?" It's not even clear what time it set in, and it's very weird. It's really cool.

**中文翻译:**
确实很怪。看第一集时我想：“这到底是个啥？”甚至搞不清背景年代，非常怪异，但也非常酷。

---

### [01:15:44] Lenny Rachitsky

**English:**
Yes. Well, good way to describe it. Next question, do you have a favorite product you've recently discovered that you really love?

**中文翻译:**
没错。下一个问题：最近有没有发现什么让你爱不释手的产品？

---

### [01:15:50] Shaun Clowes

**English:**
Yeah, this one, some of your listeners might be using it, but Glean, it's a pretty well-known startup now. They recently raised a ton of money. We've been using Glean at Confluent for a long time and it's just amazing. It's just amazing. I can't describe how good it is. And I don't say this lightly because I think search, like business search is probably one of the hardest problems in computing. Actually getting it right is one of the hardest problems in computing. Amazing. It's not often I use a product and I'm like, "This thing is 10 times better than anything that's come before it." It's one of those for me.

**中文翻译:**
有的，可能有些听众已经在用了，就是 Glean。它现在是一家很有名的初创公司，刚融了一大笔钱。我们在 Confluent 用 Glean 很久了，简直太神奇了。我无法形容它有多好。我不是随口夸夸，因为我认为企业搜索是计算机领域最难的问题之一。能把它做对真的很难。很少有产品能让我觉得“它比之前的任何东西都好 10 倍”，Glean 对我来说就是这样的产品。

---

### [01:16:25] Lenny Rachitsky

**English:**
What's the simplest way to understand what it does for you?

**中文翻译:**
用最简单的方式解释一下它能为你做什么？

---

### [01:16:28] Shaun Clowes

**English:**
It searches all of our organization's knowledge. So the thing you were just saying before, you're like, "What does AST mean?" If I had that in a meeting, I just open my new tab, it'll automatically take over my new tab or just like, "What does AST mean?" And it will summarize back to me what AST means and it'll give me a link to all the documents inside our company that just grab what AST means and then it will tell me who the expert in AST at our company is. It's like having a second brain. It's an insanely cool organization searching.

**中文翻译:**
它能搜索我们组织内的所有知识。比如你刚才问：“ASP 是什么意思？”如果我在开会时遇到这种问题，我只需打开一个新标签页，输入“ASP 是什么意思？”，它就会为我总结含义，提供公司内部所有相关文档的链接，甚至告诉我公司里谁是这个领域的专家。就像拥有了第二个大脑，这种组织搜索功能酷毙了。

---

### [01:16:59] Lenny Rachitsky

**English:**
Great tip. Okay, two more questions. Do you have a favorite life motto that you come back to share with folks, find useful and work during life?

**中文翻译:**
好建议。最后两个问题。你有没有什么人生格言，是你经常分享给别人，且在工作生活中觉得非常有用的？

---

### [01:17:07] Shaun Clowes

**English:**
I think about this one a lot. When I started off in my career, I was an engineer's engineer. I used to very much about technical correctness and what computers were capable of, and technical righteousness, the right answer rather than there is only one right answer and whatever. It's a long-winded way of saying that I often think about this phrase, which is people don't care what you know until they know that you care. And so I've realized that really being able to influence people, it doesn't matter about whether or not you're right or whether or not you're wrong. And at the end of the day, it's first about trust and about relationships and caring about what each other's outcomes are, what their incentives are, and all good things sit on top of that. Once you have those kind of foundations, then you can build really good partnerships and that's where good progress comes from.

**中文翻译:**
我经常思考这一句。职业生涯初期，我是个典型的工程师，非常执着于技术正确性、计算机的能力以及寻找唯一的标准答案。说得直白点，我经常想起这句话：“**除非人们知道你关心他们，否则他们不在乎你懂多少。**”（People don't care what you know until they know that you care.）我意识到，想要真正影响他人，你对不对并不重要。归根结底，首先是信任、关系，以及关心对方的目标和激励机制。所有好事都建立在这个基础之上。一旦有了这个基础，你就能建立良好的伙伴关系，这才是取得进步的源泉。

---

### [01:17:55] Lenny Rachitsky

**English:**
Wow, that is so good. It connects with Radical Candor, similar in theory of just caring. People need to feel like you care deeply about them before they take your advice. And it also connects with this parenting book I'm reading called Listen, that a previous guest recommended, which is all about how your kids have problems when they feel like your connection to them is weak. And so the solution is to build a stronger connection for them to know that you cared deeply about them. So this is really, connected so much of what I've been reading.

**中文翻译:**
哇，太棒了。这和《彻底坦率》（Radical Candor）的理论很像，核心都是“关心”。在人们接受你的建议前，他们需要感受到你深深地关心他们。这也让我想起我正在读的一本育儿书《倾听》（Listen），是一位之前的嘉宾推荐的。书里说，当孩子觉得与你的连接变弱时，就会出现问题。解决方案是建立更强的连接，让他们知道你深爱并关心他们。这和我读过的很多东西都产生了共鸣。

---

### [01:18:26] Shaun Clowes

**English:**
Yeah, exactly.

**中文翻译:**
没错，正是如此。

---

### [01:18:26] Lenny Rachitsky

**English:**
Great one. Final question. You were born in Sydney, folks can maybe guess by your accent. If someone were to visit Sydney, any tips, anything you think they should check out, favorite thing in Sydney?

**中文翻译:**
太好了。最后一个问题：你出生在悉尼，大家从你的口音也能猜出来。如果有人去悉尼旅游，你有什么建议？有什么必去的地方或你最喜欢的事？

---

### [01:18:38] Shaun Clowes

**English:**
Yeah, Sydney is a really beautiful city and it's kind of famous for its beaches and it's basically a metropolitan city. People probably be very surprised when you visit it. It's a very big city, very metropolitan, a little bit like New York, but New York with really beautiful beaches, if you want to think about it that way, it's kind of crazy. But there's actually a ton of really cool nature and beautiful things all around Sydney. And so if you want to do something like off the beaten path, you can actually go to, there's an area called the Blue Mountains, which is like an hour and a half drive from Sydney, and you can abseil down a waterfall, which is, well actually firstly you go canyoning through a canyon full of water, and then you abseil off a waterfall at the end. And if you're looking for just a really beautiful, fun kind of adventure like thing, an hour and a bit away from a massive metropolitan city, that's my sort of happy place. Really beautiful outdoors stuff while also next to a beautiful city.

**中文翻译:**
悉尼是一座非常美丽的城市，以海滩闻名，是一座大都市。你去了可能会惊讶，它非常大，非常繁华，有点像纽约，但是是“带美丽海滩版的纽约”。悉尼周边有很多超酷的自然景观。如果你想玩点不寻常的，可以去蓝山（Blue Mountains），离悉尼大约一个半小时车程。你可以去玩“溪降”（canyoning），穿过充满水的峡谷，最后从瀑布上“速降”（abseil/rappel）下来。如果你想在离大都市一小时路程的地方寻找美丽又刺激的冒险，那是我的“快乐星球”。既有绝美的户外景观，又紧邻美丽的城市。

---

### [01:19:31] Lenny Rachitsky

**English:**
And you said you sail, what sort of sail off a waterfall?

**中文翻译:**
你刚才说“sail”？什么样的帆船能从瀑布上跳下来？

---

### [01:19:34] Shaun Clowes

**English:**
Abseil. You might think of it as rappelling. Rappelling, I think. Yeah, lowering yourself down on a rope or...

**中文翻译:**
是“Abseil”（速降）。在美国你们可能叫“Rappelling”。就是用绳索把自己降下来。

---

### [01:19:41] Lenny Rachitsky

**English:**
Got it. Because when I hear sail, I'm thinking a boat just jumps through over the waterfall.

**中文翻译:**
明白了。因为我听到“sail”以为是小船直接从瀑布上飞下去。

---

### [01:19:47] Shaun Clowes

**English:**
Oh, no, abseiling which is also, I think in the States you guys call it rappelling.

**中文翻译:**
噢不，是“abseiling”，美国叫“rappelling”。

---

### [01:19:51] Lenny Rachitsky

**English:**
Rappelling, yeah. Wow. Very cool. Shaun, you're awesome. This was extremely cool. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out? Also point folks to your Reforge courses that you created. And final question, how can listeners be useful to you?

**中文翻译:**
速降啊，哇，太酷了。Shaun，你太棒了，这次谈话非常精彩。非常感谢你能来。最后两个问题：如果大家想联系你，在哪里可以找到你？另外请再介绍下你的 Reforge 课程。最后，听众们能为你做点什么？

---

### [01:20:07] Shaun Clowes

**English:**
Sure. Yeah, so my Reforge courses, you can check them all out at reforge.com, as you mentioned, the retention, engagement course and the data for product managers course, so love to see folks get some value from that. Lots of people have been through those courses already and I really get a lot of value from it because like I said, one of my goals is to help all of us be better product people. I think our leverage could be massive. Where you can get in touch with me, obviously on LinkedIn, but also ShaunMClowes on X, if you want to get in touch. And in terms of being useful to me, I mean, broadly speaking, I'm always open to new ideas. If people have ideas about how to do better B2B, PLG, better B2B product-led sales, for example, better ways of going about distribution and product-led sales and product-led growth inside enterprise companies, hey, I'm open to learn myself. We're all in one big journey learning how to do this better.

**中文翻译:**
好的。我的 Reforge 课程可以在 reforge.com 找到，包括《留存与参与度》和《产品经理的数据分析》。希望大家能从中获益。已经有很多人上过这些课了，我也很开心，因为我的目标就是帮助大家成为更好的产品人，我们的杠杆效应是巨大的。联系我的话，可以在 LinkedIn 上找我，或者在 X（原 Twitter）上关注 @ShaunMClowes。至于如何帮到我，我一直对新想法持开放态度。如果大家在 B2B PLG、产品驱动销售、或者大型企业内部的分发和增长方面有好的点子，欢迎交流。我也在不断学习，我们都在共同探索如何把这件事做得更好。

---

### [01:21:01] Lenny Rachitsky

**English:**
So true. Shaun, thank you so much for being here.

**中文翻译:**
确实如此。Shaun，非常感谢你能来。

---

### [01:21:05] Shaun Clowes

**English:**
Awesome, thank you very much, Lenny. It was great.

**中文翻译:**
太棒了，非常感谢，Lenny。这次谈话很愉快。

---

### [01:21:07] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at LennysPodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能帮助更多听众发现我们。你可以在 LennysPodcast.com 找到往期所有节目或了解更多信息。我们下期再见。