# Shishir Mehrotra - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Shishir Mehrotra.

---

### [00:00:00] Lenny Rachitsky

**English:**
I generally value the reference check over interview signals. If I had to stack rank in interviews, what is the best signal? The reference check is the top of the list. Those people, they worked with this person sometimes for years, their knowledge, what you're going to get out of 30 minutes of artificial scenarios it's just like never going to compare what a good reference check will give you.

**中文翻译:**
我通常认为背景调查（Reference Check）的价值高于面试表现。如果非要给面试中的各种信号排个序，哪个信号最准？背景调查绝对排在首位。那些人曾与候选人共事，有时长达数年，他们所拥有的了解，绝非你在 30 分钟的人为设定场景面试中能得到的；面试表现永远无法与一次高质量的背景调查所提供的信息相提并论。

---

### [00:00:25] Lenny Rachitsky

**English:**
Shishir Mehrotra is the co-founder and CEO of Coda. Before starting Coda Shishir led the YouTube product engineering and design teams at Google, where he spent over six years. Before that, he spent six years at Microsoft. He's also on the board of Spotify. As you'll hear in this episode, Shishir is an incredibly deep and very first principles thinker on all kinds of topics. And in this episode we cover growth strategy, specifically a framework that he calls Blue Loops and Black Loops.

**中文翻译:**
Shishir Mehrotra 是 Coda 的联合创始人兼 CEO。在创立 Coda 之前，Shishir 在 Google 工作了六年多，领导 YouTube 的产品、工程和设计团队。在此之前，他在微软工作了六年。他还是 Spotify 的董事会成员。正如你在本期节目中将听到的，Shishir 在各种话题上都是一位思考极其深刻、且非常坚持“第一性原理”（First Principles）的思考者。在本集中，我们将探讨增长策略，特别是他称之为“蓝环”（Blue Loops）和“黑环”（Black Loops）的框架。

---

### [00:00:51] Lenny Rachitsky

**English:**
We talk about the rituals of great teams, something that Shishir has been passionate about and has been collecting from all of the best leaders in tech for the past two years, and which will soon turn into a book. We talk about Eigenquestions, which is not a German game show. He shares how he evaluates product talent and gives some really great advice on doing reference checks. We go into so many other topics, this is the longest episode that I've recorded yet, and you'll see why. Shishir is so full of wisdom and we could have kept going for at least another hour. And so with that, I bring you Shishir Mehrotra. Hey Casey Winters, what do you love about Coda?

**中文翻译:**
我们讨论了优秀团队的“仪式感”（Rituals），这是 Shishir 过去两年一直充满热情并从科技界所有顶尖领导者那里收集的主题，这些内容很快将汇集成书。我们还聊到了“特征问题”（Eigenquestions，源自数学中的特征向量 Eigenvectors），这可不是什么德国游戏节目。他分享了自己如何评估产品人才，并就如何进行背景调查给出了一些非常棒的建议。我们还深入探讨了许多其他话题，这是我录制以来最长的一集，你很快就会明白原因。Shishir 充满了智慧，我们本可以再聊至少一个小时。那么，现在让我们欢迎 Shishir Mehrotra。嘿，Casey Winters，你喜欢 Coda 的哪一点？

---

### [00:01:29] Casey Winters

**English:**
Coda is a company that's actually near and dear to my heart because I got to work on their launch when I was at Greylock. But in terms of what I love about it, I love loops and Coda has some of the coolest and most useful content loops I've seen. How the loop works is someone can create a coda and share it publicly for the world. This can be how you create OKRs, run annual planning, build your roadmap, whatever. Every one of those codas can then be easily copied and adapted to your organization without knowing who originally even wrote it. So they're embedding the sharing of best practices of scaling companies into their core product and growth loops, which is something I'm personally passionate about.

**中文翻译:**
Coda 是一家我非常亲近的公司，因为我在 Greylock 工作时曾参与过他们的发布工作。至于我喜欢它的原因，我热爱“循环”（Loops），而 Coda 拥有我见过的最酷、最实用的内容循环。这个循环的运作方式是：有人可以创建一个 Coda 文档并向全世界公开分享。这可以是关于如何制定 OKR、进行年度规划、构建路线图等等。每一个这样的文档都可以被轻松复制并应用到你的组织中，甚至不需要知道最初是谁写的。因此，他们将成长期公司的最佳实践分享嵌入到了核心产品和增长循环中，这正是我个人非常热衷的事情。

---

### [00:02:05] Lenny Rachitsky

**English:**
I actually use Coda myself every day. It's the center of my writing and podcasting operation. I use it for first drafts to organize my content calendar, to plan each podcast episode on so many more things. Coda is giving listeners this podcast, $1,000 in free credit off their first statement. Just go to coda.io/lenny. That's coda.io/lenny. Hey Ashley, head of marketing and flat file. How many B2B SaaS companies would you estimate need to import CSV files from their customers?

**中文翻译:**
我自己每天都在用 Coda。它是我写作和播客运营的中心。我用它写初稿、整理内容日历、策划每一集播客，还有很多其他用途。Coda 为本播客的听众提供首张账单 1000 美元的免费额度。只需访问 coda.io/lenny 即可。嘿 Ashley（Flatfile 营销负责人），你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### [00:02:38] Ashley

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### [00:02:40] Lenny Rachitsky

**English:**
And how many of them screw that up and what happens when they do?

**中文翻译:**
其中有多少公司会把这件事搞砸？搞砸了会发生什么？

---

### [00:02:43] Ashley

**English:**
Well based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common considering customer files are chock-full of unexpected and formatting, they'll leave.

**中文翻译:**
根据我们的数据，大约三分之一的人在新手引导（Onboarding）过程中只要经历一次糟糕的体验，就会考虑更换服务商。所以，如果你的 CSV 导入工具运行不正常（考虑到客户文件往往充满了各种意想不到的格式问题，这非常普遍），客户就会流失。

---

### [00:03:02] Lenny Rachitsky

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long-term retention. Getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不惊讶。我一直认为，优化新手引导是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地体验到你的“顿悟时刻”（Aha Moment）是极其重要的。

---

### [00:03:17] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify and Zuora are able to grow their businesses on top of flat file. It's because flawless data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zuora 这样的客户如何在 Flatfile 的基础上发展业务，真是令人惊叹。这是因为完美的数据引导就像催化剂，能让他们和他们的客户更快地达到目标。

---

### [00:03:34] Lenny Rachitsky

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny. Shishir, welcome to the podcast.

**中文翻译:**
如果你想了解更多或开始使用，请访问 flatfile.com/lenny。Shishir，欢迎来到本播客。

---

### [00:03:48] Shishir Mehrotra

**English:**
Thank you for having me.

**中文翻译:**
谢谢你邀请我。

---

### [00:03:49] Lenny Rachitsky

**English:**
I don't think I've actually shared this with you, but you're actually the very first CEO that I've had on this podcast. I actually have a rule of no founders or CEOs on the podcast, at least at this point. And you're the first person that I've let break this rule. And so how does that feel?

**中文翻译:**
我想我还没跟你说过，你其实是我在这个播客上请到的第一位 CEO。我其实有个规定，至少目前为止不邀请创始人或 CEO。你是第一个让我打破这个规则的人。感觉如何？

---

### [00:04:04] Shishir Mehrotra

**English:**
I've always been a rule breaker.

**中文翻译:**
我一直是个打破规则的人。

---

### [00:04:08] Lenny Rachitsky

**English:**
Perfect. So bio for listeners just briefly. So you're the founder and CEO of Coda. You spend six years at Google where you're a VP of product and engineering for YouTube, basically leading the YouTube product team. Spent six years at Microsoft, you're on Spotify as board of directors, you're also a prolific online writer. And that leads to my first question, which is I hear that at Coda there's a contest internally for people who actually... So maybe a little context, you encourage people to write a lot of stuff externally within Coda. You want people to be writing and you have this contest of who gets the most views and likes of people internally. And so is that true and who's winning?

**中文翻译:**
太棒了。先为听众简要介绍一下背景。你是 Coda 的创始人兼 CEO。你在 Google 工作了六年，担任 YouTube 的产品和工程副总裁，基本上领导着 YouTube 的产品团队。在微软工作了六年，还是 Spotify 的董事会成员，同时也是一位高产的在线作家。这引出了我的第一个问题：我听说在 Coda 内部有一个比赛……背景是这样的，你鼓励 Coda 内部的人在外部写很多东西。你希望大家多写作，并且你们有一个比赛，看谁在内部获得的浏览量和点赞数最多。这是真的吗？现在谁领先？

---

### [00:04:47] Shishir Mehrotra

**English:**
By the way, yes, it's true. We did a similar thing at YouTube and YouTube creators. I mean obviously kicked our butts, but we made a good way to make sure we understood our tools and learned how it worked. And I think for a while at YouTube I had one of the top videos, it was a really cute video of my daughter taking everybody's orders when she was like three or four years old.

**中文翻译:**
顺便说一下，是的，这是真的。我们在 YouTube 时也对 YouTube 创作者做过类似的事情。我是说，创作者们显然比我们厉害得多，但这是确保我们理解自己的工具并了解其运作方式的好方法。我想在 YouTube 的一段时间里，我曾拥有最热门的视频之一，那是我女儿三四岁时帮大家点餐的一个非常可爱的视频。

---

### [00:05:11] Lenny Rachitsky

**English:**
That's not fair.

**中文翻译:**
这不公平（指用可爱的孩子骗点击）。

---

### [00:05:12] Shishir Mehrotra

**English:**
Yeah, super cute kid is an easy trick for YouTube, but I get to learn all the tools and so on here, the equivalent at Coda is you can publish Coda Docs, they show up in the gallery coda.com/gallery, you can see lots of them. And at this point, thousands of docs when published from lots of different people, it gets millions of views. And like at YouTube, the most popular ones are not ours, but it is sometimes helpful for us to make sure that we understand how the whole system works in order to do it. So I think that the current winning doc at Coda is one in a pretty deep niche. It's from a guy named Kenny Wong on our data team, and it's an orange theory workout doc. So it turns that orange theory has this deep subculture that they all hang out together on Reddit and so on. And this doc just took off as... I don't really understand the doc, I'm not in that subculture, but it's similar to YouTube in some ways. It's like the niches are actually much bigger than people think.

**中文翻译:**
是的，超级可爱的孩子是 YouTube 上的“财富密码”，但我因此学会了所有工具。在 Coda，对应的做法是你可以发布 Coda 文档，它们会出现在画廊（coda.com/gallery）中。目前，成千上万由不同人发布的文档获得了数百万次的浏览。就像在 YouTube 一样，最受欢迎的通常不是我们自己写的，但通过这种方式确保我们理解整个系统的运作是有帮助的。我想目前 Coda 最领先的文档是一个非常垂直的小众领域。它是由我们数据团队的一个叫 Kenny Wong 的人写的，是一个关于“Orange Theory”（一种健身课程）的锻炼文档。事实证明，Orange Theory 有一种深厚的亚文化，他们都在 Reddit 等地方聚集。这个文档就这么火了……我其实不太懂那个文档，我不在那个圈子里，但这在某些方面和 YouTube 很像：那些小众领域（Niches）实际上比人们想象的要大得多。

---

### [00:06:17] Shishir Mehrotra

**English:**
Of the ones that are more work related, I think Lane Stock on two-way writeup still outranks all of mine, but I have a couple of good ones on there too. And I would say this competition exists in my family too. I don't usually even win with that in my own family, my older daughter, Annika, who also had that great video on YouTube has two docs that do really well. One is Family Quarantine Olympics, which is a thing she put together at the beginning of COVID, like a fun game for families to play. And the other one is a score tracker for a game called Ticket to Ride, which I don't know if you've ever played the game, but it's...

**中文翻译:**
在那些更偏向工作的文档中，我想 Lane Stock 关于“双向书面报告”（Two-way writeup）的文档排名仍然超过了我所有的文档，不过我也有几个不错的。而且我要说，这种竞争在我家里也存在。在我自己家里我通常都赢不了，我的大女儿 Annika（就是 YouTube 视频里那个孩子）有两个文档表现非常好。一个是“家庭隔离奥林匹克”，那是她在新冠初期策划的，是一个适合家庭玩的有趣游戏。另一个是《车票之旅》（Ticket to Ride）游戏的计分器，我不知道你有没有玩过那个游戏，但是……

---

### [00:06:51] Lenny Rachitsky

**English:**
Heard of it.

**中文翻译:**
听说过。

---

### [00:06:51] Shishir Mehrotra

**English:**
It's about the most complicated scoring system on the planet because you play the whole game and you spend 10 minutes scoring it. And she built this whole scoring calculator and that turns out to be super popular too. Anyway, but my docs do okay. But yeah, the interesting variety of what people end up doing.

**中文翻译:**
那大概是地球上最复杂的计分系统了，因为你玩完整场游戏后，得花 10 分钟来计分。她做了一个完整的计分计算器，结果也非常受欢迎。总之，我的文档表现还行。但是，看到人们最终做出的各种有趣的东西真的很奇妙。

---

### [00:07:07] Lenny Rachitsky

**English:**
I love that. Which of your docs has been the most successful? Hopefully we end up talking about it.

**中文翻译:**
我喜欢这个。你写的文档中哪个最成功？希望我们待会能聊到它。

---

### [00:07:07] Shishir Mehrotra

**English:**
I think it goes back and forth between two docs I've written one called Eigenquestions, which I think you intend to talk about, so we will get back to that.

**中文翻译:**
我想是在我写的两个文档之间徘徊，一个叫《特征问题》（Eigenquestions），我想你打算聊这个，所以我们待会再谈。

---

### [00:07:20] Lenny Rachitsky

**English:**
Yeah, absolutely.

**中文翻译:**
是的，肯定要聊。

---

### [00:07:21] Shishir Mehrotra

**English:**
And the other one is one I wrote a while back called Four Mitzvot Bundling. That's all about how subscriptions work and it's how I ended up on the board of Spotify with Daniel and I geeking out on bundling theory, which is a super weird hobby, but I have normal hobbies too. But I liked it. I like to explore bundling as a fun hobby and people enjoy that doc as well.

**中文翻译:**
另一个是我很久以前写的，叫《捆绑销售的四大戒律》（Four Mitzvot of Bundling）。那是关于订阅模式如何运作的，也是我最终进入 Spotify 董事会的原因——我和 Daniel（Spotify CEO）一起钻研“捆绑理论”，这爱好挺怪的，但我也有正常的爱好。但我很喜欢它，我把探索捆绑销售当作一种有趣的爱好，大家也很喜欢那个文档。

---

### [00:07:41] Lenny Rachitsky

**English:**
Yeah, you've shared a lot of good thoughts on that and we're not going to cover that because covered that in depth in many places. But just to clarify, did you write that doc and then led you to being on the board of Spotify or is that after the fact?

**中文翻译:**
是的，你在这方面分享了很多深刻的见解，我们今天就不展开了，因为你在很多地方都深入讲过。但我想确认一下，是先写了那个文档才让你进入 Spotify 董事会的，还是之后才写的？

---

### [00:07:52] Shishir Mehrotra

**English:**
The conversation led to... It was a napkin sketch at YouTube that turned into a really fun lunch I had with Daniel, Daniel at the Spotify founder and CEO. And then he encouraged me to write it down. And for me, you write prolifically and writing for me is actually surprisingly hard. I feel like I have to think about it. You make it seem really easy. For me he's like, "Could you write that down?" It's like, "Great. Now I'm going to take a year to write this thing down." Because you think through each part of it and you kind of come up with the right framing. I have a little review process I use for my docs that allows other people to help me make it better, which is always really helpful. But yeah, so that's how that started. So it got written down after. Yeah.

**中文翻译:**
是那次对话促成的……最初是在 YouTube 时的一个“餐巾纸草图”，后来演变成我和 Daniel（Spotify 创始人兼 CEO）的一次非常有趣的午餐。然后他鼓励我把它写下来。对我来说，你写得非常高产，但写作对我来说其实出奇地难。我觉得我必须深思熟虑。你让写作看起来很容易，但对我来说，当他说“你能把它写下来吗？”时，我的反应是：“太好了，现在我要花一年时间来写这玩意儿了。”因为你要思考每一个部分，并找到合适的框架。我对自己写的文档有一个评审流程，让其他人帮我改进，这总是很有帮助。所以，事情就是这样开始的，文档是后来才写完的。

---

### [00:08:47] Lenny Rachitsky

**English:**
So we were talking about writing and content and things like that, and that's a really good segue to the first thing I wanted to talk about, which is Black Loops and Blue Loops, which to folks that haven't heard this before might sound like some ultimate fighting nightmare scenario, but it's something that is really important to you and Coda. And so to set it up, can you just talk about what Black Loops and Blue Loops are?

**中文翻译:**
我们刚才聊到了写作和内容之类的话题，这正好可以引出我想聊的第一件事，即“黑环”（Black Loops）和“蓝环”（Blue Loops）。对于没听过的人来说，这听起来可能像某种终极格斗的噩梦场景，但这对你和 Coda 来说非常重要。为了做个铺垫，你能解释一下什么是黑环和蓝环吗？

---

### [00:09:08] Shishir Mehrotra

**English:**
Yeah, and it's probably worth mentioning. I think a lot of businesses have a diagram that describes their ecosystem and how it works. Sometimes it happens a little later in a company's journey. For us, we're probably three or four years in before Matt Hudson's runs our data finance teams here. He came up with this diagram and it really stuck for people. But I highly encourage drawing a diagram like this for your business. I'll flash it up on screen for a second and I'll describe it, but this is what the diagram looks like, black loop, blue loop, and it's basically the two different ways that our product spreads. The Black Loop is someone comes in, they make a doc, they share with a group of people, some subset of the people turn around and make another doc, and the process repeats itself over and over again.

**中文翻译:**
好的，这确实值得一提。我认为很多企业都有一个描述其生态系统及运作方式的图表。有时这发生在公司发展的后期。对我们来说，大概是在公司成立三四年后，负责我们数据财务团队的 Matt Hudson 提出了这个图表，它真的深入人心。我强烈建议为你的业务画一个这样的图。我会在屏幕上闪现一下并描述它：这就是图表的样子，黑环和蓝环，它们基本上是我们产品传播的两种不同方式。**黑环**是：有人进来，创建一个文档，分享给一群人，这群人中的一部分人反过来又创建了另一个文档，这个过程周而复始。

---

### [00:09:53] Shishir Mehrotra

**English:**
The blue loop is someone comes in, makes a doc, and instead of sharing it with a team or with the collaborators, they publish it to the world. And in that process expose it to, they can choose how it should appear. What publishing in Coda is a lot like building a website. So you pick a URL, you tell us whether or not Google should be able to find it show up in the gallery and so on. And what ends up happening from that is they turn into broad promotion of Coda, but really it's about that person what they're trying to get done. And I'll stop sharing so I can talk a little about the dynamics. So I sometimes refer to them as the Microsoft Loop and the YouTube Loop because those are two inspirations for it. The Black Loop feels a lot like how documents naturally spread.

**中文翻译:**
**蓝环**是：有人进来，创建一个文档，但他不是分享给团队或协作伙伴，而是将其发布给全世界。在这个过程中，他们可以展示文档，并选择它的呈现方式。在 Coda 中发布文档很像建立一个网站：你选择一个 URL，告诉我们 Google 是否能搜索到它，是否出现在画廊中等等。最终的结果是，这些文档变成了对 Coda 的广泛推广，但核心其实是关于那个人想要完成的事情。我停止分享，来谈谈其中的动力学。我有时称它们为“微软环”和“YouTube 环”，因为那是这两个灵感的来源。黑环感觉非常像文档自然的传播方式。

---

### [00:10:36] Shishir Mehrotra

**English:**
The viral actions of a document platform are shared, create, share, create. It happens over and over and over again. The best way you learn about Office or Google Docs or so on is somebody shares one with you and you're like, "Oh, that's pretty cool. I bet I could create one." And that loop can happen very, very quickly and it really drives for us a lot of how we think about how we work mostly within companies and teams, but sometimes across them as well. And so for an example, it led to our pricing model. So our pricing model is a little different than most companies in the space that we do a thing called Maker Billing. So basically all document products, all products with the document metaphor have three personas, people who can see things, people who can change things, and people who can create new things.

**中文翻译:**
文档平台的病毒式动作是：分享、创建、分享、创建。它一遍又一遍地发生。你了解 Office 或 Google Docs 最好的方式就是有人分享了一个给你，然后你觉得“噢，这挺酷的，我打赌我也能做一个”。这个循环可以发生得非常快，它驱动了我们对工作方式的大部分思考，主要是在公司和团队内部，但有时也跨公司。例如，它决定了我们的定价模型。我们的定价模型与该领域的大多数公司略有不同，我们采用一种叫做“创作者计费”（Maker Billing）的模式。基本上所有的文档产品（以文档为隐喻的产品）都有三种角色：只能查看的人、可以修改的人、以及可以创建新内容的人。

---

### [00:11:18] Shishir Mehrotra

**English:**
Basically everybody charges for the top two. They charge for editors and makers. If you can make changes then you have to pay. And that's like every document product you can think of, including ones do drawing or so on. They all do the same thing. And we decided that we're only going to chart for people when they make a document. So you think about it, you get a Coda doc, you only need one If you are using any of our paid features, you only need one paid license for doing it. And the reason we do that in terms of that diagram is I wanted no friction on the share edge. I mean the share edge for us is like that's the moment of, "Hey look, I'm doing this thing, it's so cool." And that's the moment where the line I gave to the team is I want no dollar signs in the share dial going into that, every product has its moment of how he's for growth.

**中文翻译:**
基本上每个人都对前两种角色收费，即对编辑者（Editors）和创作者（Makers）收费。只要你能做改动，你就得付钱。你所能想到的几乎所有文档产品都是如此，包括绘图工具等。但我们决定，只在人们“创建”文档时收费。所以你想想看，你收到一个 Coda 文档，即使你使用了我们的付费功能，你也只需要一个付费许可。我们之所以这样做，回到那个图表，是因为我希望在“分享”这个环节没有任何摩擦。对我来说，分享环节就是那个“嘿你看，我正在做这个，太酷了”的时刻。我给团队定下的原则是：我不希望在分享对话框里出现任何美金符号。每个产品都有其增长的关键时刻。

---

### [00:12:04] Shishir Mehrotra

**English:**
Going back to YouTube, imagine you had to pay for people you shared with. Nobody would ever share anything. But that's how basically every productivity product works is the moment they charge you is when you share with somebody. The Blue Loop, I often call the YouTube loop because the emotions of publishing a doc are incredibly close to that of publishing a YouTube video. And people have all sorts of reasons why they do it. I mean sometimes people do it, there are people who do it for money, but a lot of people do it for exposure, for brand building. They just want to get an idea out in the world. They want to get feedback. Some people do it for fun, some people do it as a charitable contribution. There's lots of reasons why people do it, but the net effect of what happens is for YouTube, the vast majority of how people found out about YouTube was through a video that was shared with them.

**中文翻译:**
回到 YouTube，想象一下如果你必须为你分享的对象付费，那就没人会分享任何东西了。但基本上所有的生产力产品都是这么运作的：在你分享给别人的那一刻，他们就开始收你的钱。至于**蓝环**，我常称之为“YouTube 环”，因为发布文档的情绪与发布 YouTube 视频非常接近。人们发布文档有各种原因：有人是为了钱，但更多人是为了曝光、为了建立个人品牌。他们只是想把一个想法推向世界，想获得反馈。有人是为了好玩，有人是作为公益贡献。原因很多，但最终的效果是——就像 YouTube 一样，绝大多数人知道 YouTube 是通过别人分享给他们的视频。

---

### [00:12:51] Shishir Mehrotra

**English:**
That's sort of the impact, but it changes the dynamic that allows everyone who publishes a Coda doc, now it's a very natural incentive to go share it with the right population. If you're an orange theory, you share it with the orange theory population. If you're into plane ticket to ride, you share it with the ticket to ride population. But if you're into bundling, you try to find a small group of people that care about bundling, tell them all about that. And what happens for us is that then becomes a loop. That means that most people's exposure and almost a third of our users come through this loop. They're not actually exposed to Coda, they're exposed to a great idea for how to run an offsite or how to win ticket to ride or whatever it might be. And in that process, they learn about the product. And so then they come in through this vehicle.

**中文翻译:**
这就是影响力，但它改变了动力机制：现在每个发布 Coda 文档的人都有非常自然的动力去分享给特定的人群。如果你在做 Orange Theory，你会分享给那个圈子；如果你喜欢《车票之旅》，你会分享给玩家。如果你对捆绑销售感兴趣，你会找一小群关心这个的人告诉他们。对我们来说，这变成了一个循环。这意味着大多数人的接触点——我们近三分之一的用户——是通过这个循环进来的。他们最初接触的不是 Coda 这个产品，而是一个关于如何开好团建会、或者如何赢下《车票之旅》的好点子。在这个过程中，他们了解了产品，并以此为载体进入了我们的生态。

---

### [00:13:45] Shishir Mehrotra

**English:**
And one reason it's very important is because for products like ours that are very horizontal, you get different types of users. There's some users that I call the building block thinkers, they like to build up from scratch and the blank surface of Coda is really amazing for them, but for most people that's intimidating. I don't really know what to do. Most people in the world are problem solvers. And so they start not by, "Do I need a new document?" They start with, "I've got a problem, we don't make decisions fast enough at our company," or, "My family can't figure out what to do on the weekend," or whatever it might be. And then when they find a solution to that problem, they then pick the right tool. And so the blue Loop allows us to go after that and it changes how the motion of the ecosystem works as well. But that's what Blue Loop and Blue Loop is.

**中文翻译:**
这非常重要的一个原因是，对于像我们这样非常“横向”（Horizontal，指通用型）的产品，你会遇到不同类型的用户。有些用户我称之为“积木式思考者”，他们喜欢从零开始构建，Coda 的空白界面对他们来说很棒；但对大多数人来说，那是令人畏惧的，他们不知道该做什么。世界上大多数人都是“问题解决者”。他们开始时想的不是“我需要一个新文档吗？”，而是“我有个问题，我们公司的决策速度不够快”，或者“我家里人决定不了周末干什么”。当他们找到解决问题的方案时，才会选择合适的工具。蓝环让我们能够触达这些用户，并改变了生态系统的运作方式。这就是黑环和蓝环。

---

### [00:14:31] Lenny Rachitsky

**English:**
Awesome. I have a bunch of questions I want to ask. The first is for founder listening to this and they're like, "Oh man, what am I loops? What's my flywheel? How do I think about my business?" Can you talk a bit about how you came upon this way of thinking about the company? And then also how do you structure your teams to work in this way if this is the way you're thinking about growth?

**中文翻译:**
太棒了。我有几个问题想问。首先，对于正在听这段内容的创始人，他们可能会想：“天哪，我的循环是什么？我的飞轮是什么？我该如何思考我的业务？”你能谈谈你是如何想到这种思考公司的方式的吗？另外，如果你是这样思考增长的，你又是如何构建团队来以这种方式工作的？

---

### [00:14:50] Shishir Mehrotra

**English:**
Maybe on the first part, and I think you just hosted Casey Winters, he is pretty famous for talking about loops, not funnels. And I do think there's a very natural thing when you're building a product or building a business to think about your funnel and you think about things as being linear, that somebody comes in, they go up to your signup process and then they see your onboarding and then they get exposed to the first magic moment in your product and the second magic moment, so on.

**中文翻译:**
关于第一部分，我想你刚采访过 Casey Winters，他以谈论“循环”而非“漏斗”而闻名。我确实认为，当你构建产品或业务时，很自然会想到漏斗，认为事情是线性的：有人进来，完成注册，看到新手引导，然后体验到产品的第一个神奇时刻，接着是第二个，以此类推。

---

### [00:15:13] Shishir Mehrotra

**English:**
But the truth is, it doesn't really work that way. Almost all products have some form of loop. That person turns around and maybe sharing is built right in your product or maybe it's not, or maybe there's a way that it happens through advocacy, but understanding that the way products actually grow and spread happen through some type of loop not funnel, is I think pretty fundamental. So first piece of advice I'd give is you probably do have a loop. Whatever the product is, there's probably something about it that causes that loop and understanding how that works really important. I mean in terms of what it is. In our case, I'd say if you take Black Loop and Blue Loop, the Black Loop is every product in our category has that. We didn't invent it. You build a document, you put a share button on it, every product has that.

**中文翻译:**
但事实是，它并非那样运作。几乎所有产品都有某种形式的循环。那个人可能会回头分享，也许分享功能就内置在产品里，也许不是，或者通过口碑推荐发生。但理解产品实际增长和传播是通过某种循环而非漏斗发生的，我认为这是非常基础的。所以我给的第一条建议是：你可能确实有一个循环。无论产品是什么，可能都有某种因素导致了循环，理解它是如何运作的至关重要。就我们而言，如果你看黑环和蓝环，黑环是同类产品都有的。我们没有发明它：你创建一个文档，放一个分享按钮，每个产品都有。

---

### [00:16:01] Shishir Mehrotra

**English:**
Sometimes it's just recognizing what's there. It's not that interesting. The Blue Loop on the other hand, is not something that every product in our category has. It's not really a thing that you expect to do with Google Docs or Office or so on. It's our unique take on, "Hey, we're going to build a publishing platform that isn't just for sharing ideas and building things with your team, therefore putting things out in the world." I mean, one of the best compliments we hear about the Coda Gallery is I had this user tell me, this line I really love is said that the Coda Gallery feels halfway between Medium and an app store. And you can come and you can read about anything interesting in the world and you can go shopping and say, "I need one of those. I need one of those and I need one of those."

**中文翻译:**
有时只是识别出已有的东西，这并不那么有趣。另一方面，蓝环并不是我们这类产品中每个都有的。你通常不会指望用 Google Docs 或 Office 来做这种事。这是我们的独特见解：“嘿，我们要建立一个发布平台，它不仅是为了分享想法和与团队协作，更是为了把东西推向世界。”关于 Coda 画廊，我听过最好的赞美之一是，一位用户告诉我——我非常喜欢这句话——他说 Coda 画廊感觉介于 Medium 和应用商店之间。你可以来这里阅读世界上任何有趣的东西，也可以像购物一样说：“我需要那个模板，我需要这个，我还需要那个。”

---

### [00:16:40] Shishir Mehrotra

**English:**
And it's my view that this category, we call the all-in-one doc category, I think this is going to be critical. I don't think that there's enough people out there that are looking for a horizontal new blinking cursor. I mean, they exist and you can get through your first million users that way. But I think to get to the level of impact we want to have, we've got to find this problem, see here. So you probably have a loop, not a funnel, and it might be hiding in plain sight or it might require invention. That's the bounder dance and the fun of it, but finding it, writing it down I think is really helpful. Second part... Oh, how do we organize team?

**中文翻译:**
我的观点是，在我们称之为“全能文档”的这个类别中，这一点将至关重要。我不认为有足够多的人在寻找一个新的、通用的“闪烁光标”（指空白文档）。虽然这类人确实存在，你也可以通过这种方式获得前一百万用户，但要达到我们想要的影响力，我们必须发现并解决这些具体问题。所以，你可能拥有的是一个循环而非漏斗，它可能就隐藏在显眼的地方，也可能需要你去发明。这就是创业者的博弈和乐趣所在，但找到它并写下来是非常有帮助的。第二部分……噢，我们如何组织团队？

---

### [00:17:18] Lenny Rachitsky

**English:**
Yeah, but let me ask one quick question. You said this, I think it was a data scientist that first imagined and diagram this out because I'm curious, as a founder listening, they're like, "Oh, how do I find something like this?" I imagined part of this was, "Oh, this person brought you this interesting way of thinking." And there's this process of, "Oh wow, this is cool. Let's think about this." What was that like? Just over high level, that process.

**中文翻译:**
是的，但在那之前我想追问一个小问题。你提到最初是一个数据科学家构思并画出了这个图表。我很好奇，作为听众中的创始人，他们会想：“噢，我该如何找到这样的东西？”我猜过程的一部分是：“噢，这个人带给你这种有趣的思考方式。”然后有一个“哇，这很酷，让我们研究一下”的过程。那个过程大概是什么样的？

---

### [00:17:41] Shishir Mehrotra

**English:**
He currently runs data and finance for us. He's actually one of the early founding members of the team, Matt Hudson. So he is getting every job here around the go to market team. Very insightful. But honestly, the idea can come from anywhere. I mean there's a really famous loop diagram for Uber that I think one of the board members drew it or Travis drew it.

**中文翻译:**
他目前负责我们的数据和财务。他实际上是团队早期的创始成员之一，Matt Hudson。他在进入市场团队中做过各种工作，非常有洞察力。但老实说，想法可以来自任何地方。比如 Uber 有一个非常著名的循环图，我想是某位董事会成员画的，或者是 Travis（Uber 创始人）画的。

---

### [00:17:59] Lenny Rachitsky

**English:**
Built early.

**中文翻译:**
很早就画好了。

---

### [00:18:01] Shishir Mehrotra

**English:**
Yeah, right. Yeah, that napkin sketch, who knows how true that is. Probably lots of dispute on that. I think Airbnb had a similar diagram. I'm trying to remember.

**中文翻译:**
是的，没错。那个餐巾纸草图，谁知道真实性如何，可能有很多争议。我想 Airbnb 也有类似的图表，我正努力回忆。

---

### [00:18:12] Lenny Rachitsky

**English:**
We tried, we had some sketches.

**中文翻译:**
我们尝试过，确实有一些草图。

---

### [00:18:15] Shishir Mehrotra

**English:**
Right. So it can come from anywhere. I do find that the most natural place to see it is just when you're talking about your business to someone, when you're pitching a customer or a candidate, I actually think candidate... I think we're going to talk a little bit about energy, but I think talking to candidates is one of the best ways to hone what your business is about. Because those people are in some ways even more critical than investors. I mean they're investing their time, not just their money. And so your ability to get across to them why this thing is going to be interesting and how it'll grow.

**中文翻译:**
对。所以它可能来自任何地方。我发现最自然能看到它的地方，就是当你向别人谈论你的业务时——当你向客户或应聘者做宣讲（Pitch）时。我其实认为应聘者……我们待会可能会聊到能量的话题，但我认为与应聘者交谈是磨练业务核心的最佳方式之一。因为在某些方面，这些人比投资者更关键。他们投入的是时间，而不仅仅是金钱。因此，你向他们传达这件事为什么有趣以及它将如何增长的能力至关重要。

---

### [00:18:50] Shishir Mehrotra

**English:**
And they're the most discerning investors out there in a lot of ways. And they're actually not that easily confused by metrics and so on that could be temporary. And they put themselves in that picture like, "Can I see that happening?" And so for us, the black loop part is pretty obvious, but the blue loop part, you had to squint a little bit to think, "Will people really do that? Will people come and publish these documents like some hybrid between websites and blog posts and templates? What are they going to going to do and why?" And so it required a little bit of creativity, which forced me to get better and better at pitching why that's going to happen and what that role is going to feel like. And this analogy of halfway between Medium and an app store is that helped people crystallize what that promise has to feel like. So I think that... And this idea can come from anywhere, but if you want mine for your own loops, go look at what you told the last few candidates you talked to.

**中文翻译:**
在很多方面，他们是眼光最犀利的投资者。他们其实没那么容易被那些可能是暂时的指标所迷惑。他们会把自己代入那个画面：“我能预见到那发生吗？”对我们来说，黑环部分很明显，但蓝环部分，你得稍微眯起眼睛想象一下：“人们真的会那么做吗？人们真的会来发布这些介于网站、博客文章和模板之间的混合体文档吗？他们会做什么，为什么要这么做？”这需要一点创造力，也迫使我越来越擅长宣讲为什么这会发生，以及那个角色会是什么感觉。而“介于 Medium 和应用商店之间”这个类比，帮助人们具体化了那种承诺的感觉。所以我觉得……想法可以来自任何地方，但如果你想挖掘自己的循环，去看看你对最后谈过的几个应聘者说了什么。

---

### [00:19:48] Lenny Rachitsky

**English:**
I like that. And then just take some attempts at drawing some kind of diagrams. That's how I thought about that when I was thinking about it. Do you find that the quality of user is different amongst the loops? I imagine one is like 80% of the growth, but maybe the other is a different type of user, maybe higher quality. I think about a little bit with Airbnb referrals drove higher quality hosts, even though it was still a small portion of all hosts. And so it was a really lucrative and interesting channel. Do you find anything like that?

**中文翻译:**
我喜欢这个建议。然后尝试画一些图表，我当时也是这么想的。你是否发现不同循环中的用户质量有所不同？我猜其中一个可能贡献了 80% 的增长，但另一个可能是不同类型的用户，也许质量更高。我想到了 Airbnb 的推荐机制，它带来了更高质量的房东，尽管这只占所有房东的一小部分，但它是一个非常有利可图且有趣的渠道。你有类似的发现吗？

---

### [00:20:14] Shishir Mehrotra

**English:**
So I mean quality and activation are a little bit different. I mean the Blue Loop definitely, there's actually three entry points on that diagram. Those people come through the Blue Loop, those people get shared through the Black Loop and those people come through the top of the funnel. There has to be like your seat population, somebody starts with blinking cursor. Nobody shared anything with them. Either a Blue Loop, a template to document or Black Loop a way the team is running. If you look at activation, retention, so on, certainly the highest is the black share. Somebody shares the document and says, "Hey, this is how we're running the staff meeting." You're just going to use it. So the job or retention there is a all different, and actually one thing that is... Actually, let me come back to that evolution. Second best is through the blue loop and then the third, the worst, the hardest is activating through the very top. And from there, roughly one in five people make it to what we think of as our activation moment, which is hard.

**中文翻译:**
质量和激活（Activation）是两个略有不同的概念。在那个图表中其实有三个入口：通过蓝环进来的，通过黑环分享进来的，以及从漏斗顶部直接进来的。必须有一群“种子用户”，他们面对的是闪烁的光标，没人给他们分享过东西。要么是蓝环（通过模板文档），要么是黑环（团队运行方式）。如果你看激活率、留存率等，最高的肯定是黑环分享。有人分享一个文档说：“嘿，这就是我们开员工会议的方式。”你直接用就行了。所以那里的留存工作完全不同。第二好的是通过蓝环，第三好——也是最差、最难的——是从最顶部激活。在那里，大约只有五分之一的人能达到我们认为的激活时刻，这很难。

---

### [00:21:14] Shishir Mehrotra

**English:**
It's like you're going to hand somebody a new product that they didn't start with a problem on and nobody handed them a document to say, "Just work in." That's hard now. Now all our flows are really important and so on. But if you think about these three different dynamics from how you asked about how you struck your team, they're incredibly different mindsets. Because coming to the top of that diagram, we get to own the conversation. We have our opportunity to tell you what the product's about, what you should do with it, here's the minimal set of things you need to know in order to be productive and gradually reveal the other things that you might need to know, meaning the order of those things wrong, real trouble. But it's actually a minority of how people get exposed to Coda because in the black loop, the person who owns that conversation, the person sharing the document with you. If that person does it and mispositions it or doesn't just makes a crappy document or so we have to help them onboard their users, which become our users.

**中文翻译:**
这就像你把一个新产品交给一个并没有带着具体问题来的人，而且也没人给他一个现成的文档说“就在这儿工作”。这很难。现在我们所有的流程都变得非常重要。但如果你思考这三种不同的动力机制，以及你问到的如何构建团队，它们的思维方式是截然不同的。因为从图表顶部进来，我们可以掌控对话。我们有机会告诉你产品是关于什么的，你应该用它做什么，为了提高效率你需要知道的最少知识是什么，并逐渐揭示你可能需要的其他功能。如果顺序错了，麻烦就大了。但实际上只有少数人是通过这种方式接触 Coda 的，因为在黑环中，掌控对话的是分享文档给你的人。如果那个人定位错了，或者只是做了一个很烂的文档，我们就必须帮助他们引导他们的用户（这些用户随后变成了我们的用户）。

---

### [00:22:11] Shishir Mehrotra

**English:**
Same thing in the Blue Loop, that conversation is now owned by the publisher. They're really not that interested in teaching anybody about Coda. They're emotional interested in here's this really cool way to do Orange Theory, or here's this interesting way to run a meeting. And so, one of the interesting things about building platforms, which I think is a little bit different than products that get to be direct. For better or worse, most of the products I've gotten to work on are platform products. And I find that there's two very different kinds of people that like that challenge. So some people, and I think Steve Jobs was the quintessential example, if he didn't really like being a platform, the iPhone ship without an app store, they locked down the screws on the back on all the devices that nobody could open them. And his viewpoint was, " I'm going to control every element of what my users see." And on...

**中文翻译:**
蓝环也是一样，对话由发布者掌控。他们其实对教别人用 Coda 没多大兴趣，他们感兴趣的是“这里有一个超酷的做 Orange Theory 的方法”或者“这是一个有趣的开会方式”。所以，构建平台的一个有趣之处在于，它与直接触达用户的产品不同。无论好坏，我参与过的大多数产品都是平台型产品。我发现有两种截然不同的人喜欢这种挑战。有些人，我想史蒂夫·乔布斯就是典型的例子，他其实并不喜欢做平台——iPhone 发布时没有应用商店，他们锁死了所有设备背面的螺丝，没人能打开。他的观点是：“我要控制用户看到的每一个元素。”而另一方面……

---

### [00:23:00] Shishir Mehrotra

**English:**
I'm going to control every element of what my users see. And on the other hand, platform thinkers, you sort of assume that my connection to my eventual user is through someone else. Like YouTube, regularly they come to work at YouTube and somebody would say, "Well, here's what happened last night." And sometimes it's heartwarming, like, oh, my gosh, this kid bit this other kid's finger and it took off like crazy and this Korean pop star just broke through the billion view mark before everybody else did. And sometimes it was not heartwarming and you don't get to control that because that's part of being a platform.

**中文翻译:**
我要控制用户看到的每一个细节。而另一方面，平台思维者会假设：我与最终用户的连接是通过其他人实现的。就像 YouTube，员工经常来上班时会听到有人说：“瞧瞧昨晚发生了什么。”有时是温馨的，比如“天哪，这个小孩咬了另一个小孩的手指，视频疯传”；或者是“这个韩国流行歌星先于所有人突破了十亿播放量”。有时则不那么温馨，你无法控制这些，因为这就是平台的一部分。

---

### [00:23:37] Shishir Mehrotra

**English:**
And so it does change how you think about the way you run the team because if you have a loop where your community ecosystem users on control that narrative, then you have to incorporate that. Another close analogy I think is Airbnb and the famous story of them taking pictures of people's apartments. It's like they had to reach out and try to control that and eventually you can't do that. You had to sit back and let people market their hotels. And thankfully the ecosystem got good at it, but they kind of had a similar dynamic, I think.

**中文翻译:**
所以这确实改变了你运营团队的方式，因为如果你有一个由社区生态系统用户控制叙事的循环，你就必须把这一点纳入考虑。我认为另一个贴切的类比是 Airbnb，以及他们为人们的公寓拍照的著名故事。他们最初不得不伸手去尝试控制，但最终你无法一直这样做。你必须退后一步，让人们自己去推销他们的“酒店”。幸运的是，生态系统变得擅长于此，但我认为他们也有类似的动力机制。

---

### [00:24:12] Lenny Rachitsky

**English:**
Absolutely. With Airbnb, pricing is even more of a challenge where a lot of hosts don't really know what to price. They think their place is worth a lot more and we can't tell them the price. There's laws around that. And so it's like, hey, maybe you want to price it at this rate if you know what's good for you. So it's a lot of encouraging. So yeah, I've seen that in action. So you talked about teams and how you think about structuring them a bit and that's a good segue to our second topic, which is around a book that I hear you're writing called The Rituals of Great Teams.

**中文翻译:**
绝对是。在 Airbnb，定价甚至是一个更大的挑战，很多房东不知道该定什么价。他们觉得自己的房子值更多钱，而我们不能直接告诉他们价格，这涉及法律问题。所以我们只能说：“嘿，如果你知道什么对你有利，也许你想按这个价格定。”所以这更多是鼓励。是的，我见过这种运作方式。你谈到了团队以及如何构建他们，这很好地引出了我们的第二个话题，关于你正在写的一本书，听说叫《优秀团队的仪式感》（The Rituals of Great Teams）。

---

### [00:24:40] Lenny Rachitsky

**English:**
And I think what you're doing there is exploring rituals that have emerged at some of the more successful companies. And so just a question there, one, how'd you get interested in rituals, so much so that you decided to write a book, which is such a trudge and endless amount of work? And just yeah, where is it at, how's it going? And then I'll ask you a few more questions there.

**中文翻译:**
我想你是在书中探索一些成功公司中出现的仪式。我想问的是：第一，你是如何对仪式产生如此浓厚的兴趣，以至于决定写一本书的？写书可是件苦差事，工作量无穷无尽。目前进度如何？进展怎么样？之后我还会再问几个相关的问题。

---

### [00:24:59] Shishir Mehrotra

**English:**
The writing a book, so I'm writing this book, it's called Rituals of Great Teams. And when I signed up to do it, I thought it was going to take six months. I'm now almost two years in [inaudible 00:25:11] my manuscript in four months and I am probably half done. So there's a lot of work ahead of us in building, but it's one of the most fun projects I've ever done. So the history behind this was, as in many cases, is a lot of sort of odd luck and happenstance. I got hosted right at the start of the pandemic. I was interviewed for a different podcast called Masters of Scale by Reid Hoffman. And the way Reid records, which I'm not sure I would recommend this, but he does it a little bit differently than you do. You sit down with no idea what you're going to talk about and you talk for three hours.

**中文翻译:**
关于写书，是的，我正在写这本《优秀团队的仪式感》。当我签约时，我以为只要六个月。现在快两年了，我计划在四个月内交稿，但目前大概只完成了一半。所以还有很多工作要做，但这是我做过的最有趣的项目之一。这背后的历史，像很多情况一样，充满了奇妙的运气和巧合。大流行刚开始时，我接受了 Reid Hoffman 的播客《规模大师》（Masters of Scale）的采访。Reid 录制的方式——我不确定是否推荐这种方式——但他和你有点不同：你坐下来，完全不知道要聊什么，然后聊上三个小时。

---

### [00:25:49] Shishir Mehrotra

**English:**
And then he has a group of editors, the same group that actually at its head, and they come in and they pick 20 minutes of it and they turn and one episode. And you have no idea what it's going to be, so you talk and talk and talk and gets 20 minutes out and they're pretty good at getting to a nugget. So they picked out of this whole discussion this part that I thought was really small and it was Reid had asked me for one of my favorite quotes and I talked about this quote from a guy named Bing Gordon. People don't know Bing. Bing was one of the founders of Electronic Arts. He's a famous investor, Amazon, Zynga, so owns lots of great companies. And I happened to sit on a board with Bing and he used this line. I think Bing's one of the best non-linear thinkers in The Valley. Always learned something with Bing.

**中文翻译:**
然后他有一群编辑，他们会从这三小时里挑出 20 分钟，做成一集节目。你完全不知道最终会呈现什么，所以你就一直聊，最后浓缩成 20 分钟，他们非常擅长挖掘精华。他们从整个讨论中挑出了我认为非常小的一个部分：Reid 问我最喜欢的名言，我提到了 Bing Gordon 的一句话。有些人可能不认识 Bing，他是 EA（艺电）的创始人之一，也是著名的投资者，投资过亚马逊、Zynga 等很多伟大的公司。我碰巧和 Bing 在同一个董事会，他说了句让我印象深刻的话。我认为 Bing 是硅谷最好的非线性思考者之一，总能从他身上学到东西。

---

### [00:26:29] Shishir Mehrotra

**English:**
And he used this line that really stuck with me. He said great companies has a very small list of golden rituals. And there are three rules of golden rituals. Number one, they're named. Number two, every employee knows them by their first Friday and, number three, they're templated. And he has great examples. Amazon has six pagers and Google has OKRs and Salesforce has V2MOM and there's all these different rituals that people do. And I ended up sharing on the podcast a little bit about what Coda's golden ritual is. If you were to ask a set of Coda employees on their first Friday what Coda's golden ritual is, they would almost certainly tell you about this thing we do called Dory/Pulse. It's sort of the key of how we run meetings and do write-ups and so on. It's a pretty simple idea, is that in our write-ups and in our meetings, instead of going around the room and hearing what everybody thinks, we do this thing called Pulse.

**中文翻译:**
他说的这句话深深吸引了我。他说：“伟大的公司都有一份非常短的‘黄金仪式’清单。”黄金仪式有三个规则：第一，它们有名字；第二，每个员工在入职后的第一个周五前都会知道它们；第三，它们是模板化的。他举了很多例子：亚马逊有“六页纸报告”（Six-pagers），Google 有 OKR，Salesforce 有 V2MOM，还有人们执行的各种不同仪式。我在播客中分享了 Coda 的黄金仪式。如果你在第一个周五问 Coda 的员工什么是 Coda 的黄金仪式，他们几乎肯定会告诉你一个叫“Dory/Pulse”的东西。这是我们开会、写报告等的关键。这是一个很简单的想法：在我们的报告和会议中，我们不采用轮流发言听取每个人意见的方式，而是做一个叫“Pulse”（脉搏）的环节。

---

### [00:27:26] Shishir Mehrotra

**English:**
Everybody writes down what they think and we hide everybody else's until you're done writing. So you force yourself to be eloquent about your opinion, on the record about it, and unbiased. And then the second thing we do is called Dory, which is instead of randomly asking questions, we ask people to put the questions on the table and then we take a round of up quoting and down voting them to actually figure out what we're going to talk about. Dory's named after the fish who asks all the questions. It's a tool we use a lot at Google that we kind of turned into this mini tool. If you were to ask a set of Coda employees on the first Friday about Coda's golden rituals with Bing's three tests, they'll certainly talk about Dory and Pulse. And it's not because they're meeting wonks. It's because it's indicative of the culture of the team.

**中文翻译:**
每个人写下自己的想法，在写完之前，其他人的内容是隐藏的。这样你就被迫清晰地表达自己的观点，留下记录，且不受他人偏见的影响。第二件事叫“Dory”（多莉），我们不随机提问，而是让大家把问题摆在桌面上，然后进行一轮点赞和点踩，以此决定我们要讨论什么。Dory 是以那个总是问问题的鱼命名的（《海底总动员》里的角色）。这是我们在 Google 经常使用的一个工具，我们把它变成了一个小工具。如果你用 Bing 的三个标准去问 Coda 员工，他们肯定会提到 Dory 和 Pulse。这并不是因为他们是“会议狂人”，而是因为这代表了团队的文化。

---

### [00:28:08] Shishir Mehrotra

**English:**
And so I'll regularly hear employees say things like, "I just joined Coda. It's been a week. It's amazing. The culture is so open that I got to ask a question in a meeting and it outvoted the CEOs." Or they'll say, "I got asked for my contribution to this really hard decision we're making and it was thoughtfully presented. I had space to be able to do it well without bias and it was actually read and considered as part of the decision making process." Reid's podcast did pretty well and I got all these questions about rituals and so I decided to do a dinner which turned into a dinner series. And basically every third Wednesday we would host a group of people to share the rituals with each other. And I learned a bunch of stuff in this process.

**中文翻译:**
所以我经常听到员工说：“我刚加入 Coda 一周，太神奇了。这里的文化非常开放，我在会上提了一个问题，结果票数超过了 CEO 的问题。”或者他们会说：“在一个非常艰难的决策中，公司征求了我的意见，我得以深思熟虑地表达，有空间在不受偏见影响的情况下做好，而且我的意见真的被阅读并纳入了决策过程。”Reid 的播客反响很好，我收到了很多关于仪式的问题，所以我决定办一场晚宴，后来演变成了一个晚宴系列。基本上每个月的第三个周三，我们都会邀请一群人互相分享仪式。在这个过程中我学到了很多东西。

---

### [00:28:54] Shishir Mehrotra

**English:**
I've now interviewed over 1,000 people for this book and There's lots of really interesting rituals that come out of it, but first thing I learned is people love sharing their rituals. I've interviewed people from many companies that everybody's heard of, Nike, Disney, New York Times. It's all the way down to many startups that maybe people haven't heard of or companies in industries that people don't talk a lot about. Book authors, pundits, lots of different people that have come through this process. Everybody loves sharing their rituals. Everybody has little secrets to how they run their business, but for some reason the how we work part everybody's very willing to share. People also love hearing about them. And I was like, "Is this going to be interesting for a dinner, geeking out about how a team works?" And it turns out not only do people like hearing about it, it's the littlest details that matter. It's like, yeah, we kind of do that, too, but we have this issue.

**中文翻译:**
为了这本书，我已经采访了 1000 多人，从中发现了很多非常有趣的仪式。我学到的第一件事是：人们热爱分享他们的仪式。我采访过很多知名公司的人，比如耐克、迪士尼、《纽约时报》，也采访过很多名不见经传的初创公司，或者人们不常谈论的行业里的公司。作家、专家，各种各样的人都参与了进来。每个人都喜欢分享他们的仪式。每个人都有经营业务的小秘密，但出于某种原因，关于“我们如何工作”的部分，大家都非常愿意分享。人们也喜欢听这些。我曾想：“在晚宴上钻研团队如何工作会很有趣吗？”事实证明，人们不仅喜欢听，而且最微小的细节才最重要。大家会说：“是的，我们也这么做，但我们遇到了这个问题。”

---

### [00:29:46] Shishir Mehrotra

**English:**
How'd you get past this? And you start discovering that actually those little details are what would make or break a thing, that you can't quite do it the exact same way. And then the other thing I realized, which is probably the most important point, is that rituals are, I like to say that they are, a mirror of culture. That one of the attendees, Dharmesh Shah, founder of HubSpot and very thoughtful person, he talked a lot about this thing that is virtually presented as something called flash tags, which is a really cool example. But Dharmesh talked about how when we're building companies, we actually build two products. We build one for our customers and we build another one for our employees. That's actually how we work part of it. That's the term he uses for that, is culture. That's the product we build for our employees.

**中文翻译:**
“你是怎么解决这个问题的？”你会发现，正是那些小细节决定了一件事的成败，你不能完全照搬。我意识到的另一件事，可能也是最重要的一点，就是：仪式是文化的镜子。其中一位参与者，HubSpot 的创始人 Dharmesh Shah（一个非常有思想的人），谈到了一个叫“Flash tags”的东西，这是一个很酷的例子。但 Dharmesh 谈到，当我们建立公司时，实际上是在构建两个产品：一个是给客户的，另一个是给员工的。给员工的产品就是“我们如何工作”，他称之为“文化”。文化就是我们为员工构建的产品。

---

### [00:30:29] Shishir Mehrotra

**English:**
I think it's a very interesting way to define what culture is. Interestingly, when you ask people about their culture, hey, what's the culture of Google, or Airbnb, or so on, the way they'll answer the question is through rituals. They'll say here's what we do and the way you know this is what we do is through this ritual that's in place. So I thought that was pretty interesting. Started off just building a little listicle of here's all the great rituals and then I started realizing that actually the comparison between them is kind of interesting. And so I started sort of filling in the gaps between them of like when would you do X versus Y and what did I learn through that process? Publisher asked if I would turn it into a book and I agreed without really contemplating how hard it would be. And it's become what most of my evenings end up being on this.

**中文翻译:**
我认为这一定义文化的方式非常有趣。有趣的是，当你问别人他们的文化是什么——比如 Google 或 Airbnb 的文化——他们回答的方式通常是通过仪式。他们会说：“这就是我们所做的，而你知道我们这么做的原因是因为有这个仪式。”我觉得这很有意思。起初我只是想列个清单，记录所有伟大的仪式，后来我意识到它们之间的对比很有趣。于是我开始填补它们之间的空白，比如什么时候该做 X 而不是 Y，以及我在这个过程中学到了什么。出版商问我是否愿意把它写成书，我没怎么想写书有多难就答应了。现在，我大部分的晚上都花在这上面了。

---

### [00:31:17] Shishir Mehrotra

**English:**
I have a wonderful co-writer, Erin Dame, who's incredibly gracious with her time and helping me sort through the best ideas and the worst ideas, but it's a really fun project.

**中文翻译:**
我有一位很棒的合著者 Erin Dame，她非常慷慨地抽出时间帮我筛选最好的和最差的想法，这是一个非常有趣的项目。

---

### [00:31:29] Lenny Rachitsky

**English:**
What are some of the more wacky and/or impactful rituals that you've come across that you can share?

**中文翻译:**
你能分享一些你遇到的比较古怪或者影响力很大的仪式吗？

---

### [00:31:36] Shishir Mehrotra

**English:**
Boy. I'd sort it down the list. I'll tell you some that are interesting and recognizable. One of the most fun ones is from Arianna Huffington and she shared a ritual called Reset. And there's a bit of background on Arianna, she's well known for Huffington Post. She now runs Thrive. She had an accident a few years back and ended up going through a period of doing a lot of research on how the brain works and ended up coming to this set of conclusions about how you can affect your own brain chemistry. And one of the things she does as a sort of personal ritual is I think called a reset.

**中文翻译:**
天哪，清单很长。我给你讲几个有趣且有辨识度的。最有趣的一个来自 Arianna Huffington，她分享了一个叫“Reset”（重置）的仪式。Arianna 的背景大家可能知道，她因《赫芬顿邮报》成名，现在经营 Thrive。几年前她出了一次意外，之后花了很多时间研究大脑如何运作，并得出了一系列关于如何影响自身大脑化学反应的结论。她做的一件事，作为一种个人仪式，就叫“Reset”。

---

### [00:32:13] Shishir Mehrotra

**English:**
It's basically the ritual is you make a one minute video that is personal. And they have a little template for doing it, but it's a breathing exercise. It's like you are supposed to play it while you do this breathing exercise, but it's personal. So it's like her video, you go search YouTube for Arianna's reset, you'll find it. It has pictures of her kids, it has quotes she loves, it has videos of her hometown in Greece and so on, but the way she brought it to the team was they start meetings by randomly picking someone. They call it spin the wheel. They randomly pick someone and they play their reset. And the idea is you get this two for one where everybody gets a little bit the brain chemistry rewiring of 60 second breathing exercise. Everybody gets back into that sort of zen state a little bit and you learn a little bit about each other.

**中文翻译:**
这个仪式基本上是让你制作一个一分钟的个人视频。他们有一个小模板，但核心是一个呼吸练习。你应该在做呼吸练习时播放它，但它是个人化的。比如她的视频（你可以在 YouTube 上搜“Arianna's reset”），里面有她孩子的照片、她喜欢的名言、她希腊家乡的视频等等。她把这个带到团队中的方式是：会议开始时随机挑选一个人（他们称之为“转动轮盘”），然后播放那个人的 Reset 视频。这个想法是一举两得：每个人都通过 60 秒的呼吸练习重塑大脑化学反应，回到某种“禅定”状态，同时大家也能多了解彼此一点。

---

### [00:33:05] Shishir Mehrotra

**English:**
And she was saying that the pictures people pick and so are interesting, but actually the music people pick is probably the most interesting. A lot of people pick calm music, some people will pick something they rock out to, but everybody does their reset a little bit differently. So that was a really fun one. Another really fun one that I was surprised by, Gusto does this thing in their hiring calls. So you get an offer from Gusto and apparently when you get on the offer call of congratulations, you got an offer, instead of just meeting the recruiter, which is what most companies do, they have the entire group of people that interviewed you join the call and they all say something about why you're amazing and you should join Gusto.

**中文翻译:**
她说人们选的照片很有趣，但其实选的音乐可能最有趣。很多人选平静的音乐，有些人选摇滚，每个人的 Reset 都略有不同。这是一个非常有趣的。另一个让我惊讶的有趣仪式是 Gusto 在录用电话（Hiring calls）中做的。当你拿到 Gusto 的录取通知（Offer）时，在祝贺你拿到 Offer 的电话里，不仅仅是招聘人员在场（大多数公司都是这样），而是所有面试过你的人都会加入通话，每个人都会说一些关于你为什么很棒以及你为什么应该加入 Gusto 的话。

---

### [00:33:46] Shishir Mehrotra

**English:**
And it's such an interesting ritual in so many ways. For the candidate, obviously what an amazing experience. To use an Airbnb term, that's like a level 11 experience of what that feels like, but also for the company. One of the questions I get asked, "What if I voted no? What if I'd said this person is a no hire?" And I said, "It doesn't matter. You're on the call, you're going to work with this person, you're going to help them feel welcome and you're going to help them understand where they stand." I think it obviously takes a bunch of time, but it also is a signal to the company of how important hiring is and something that obviously we all prioritize. Those are maybe a couple of the maybe different ones that people might not have heard of before.

**中文翻译:**
在很多方面这都是一个非常有趣的仪式。对于候选人来说，这显然是极好的体验。用 Airbnb 的术语来说，这就是“11 级体验”。但对于公司来说也是如此。有人问我：“如果我投了反对票呢？如果我说这个人不该招呢？”我说：“没关系。你也在通话中，你将来要和这个人共事，你要帮他们感到受欢迎，帮他们了解自己的定位。”我认为这显然很花时间，但它也向公司发出了一个信号：招聘是多么重要，这是我们所有人的优先事项。这些可能是人们以前没听说过的一些不同的仪式。

---

### [00:34:31] Lenny Rachitsky

**English:**
Those are amazing examples. Have you integrated any of these rituals from other companies doing this research into Coda?

**中文翻译:**
这些例子太棒了。在做这些研究的过程中，你有没有把其他公司的这些仪式引入到 Coda？

---

### [00:34:37] Shishir Mehrotra

**English:**
All the time and it's the cheapest form of research. I mean, I get to borrow all these great ideas from all these companies. We just added one to our decision making process. This is a good example of a little detail that really matters, is Coinbase has a ritual that's formed around ... This is a decision-making ritual they call ... It's actually amazing how many companies have a decision-making ritual with a name, with a bur. So at Square, Vocal called them Spades. He kind of verbified it. There's a template, but you use Bing's three tenants. It's got to be named, every employee knows it by the first Friday and it's templated.

**中文翻译:**
一直在做，这是最廉价的研究形式。我是说，我可以从所有这些公司借用这些伟大的想法。我们刚刚在决策过程中增加了一个。这是一个关于“细节决定成败”的好例子：Coinbase 有一个围绕决策的仪式……令人惊讶的是，竟然有这么多公司拥有带名字、带动词的决策仪式。在 Square，他们称之为“Spades”（黑桃）。他把它变成了一个动词。有一个模板，但你得遵循 Bing 的三个原则：必须有名字，每个员工在第一个周五前都知道，且必须模板化。

---

### [00:35:18] Shishir Mehrotra

**English:**
So Coinbase does a thing they call rapids and rapid is a framing around what the roles in it are, the responsible approver, participating, informed and decider, but their technique of doing it was really interesting. They have this subtle nudge thing that we weren't doing that I've now incorporated at Coda. So at Coda we have Dory and Pulse, like a very common ritual. It spread through a lot of different companies that use Coda. You don't really have to use Coda to do it, but I think Coda is pretty good at it. But one of the things we were facing was that you would do this pulse and so you'd have a meeting. And if you did it wrong, it could feel like voting and it could feel like consensus building.

**中文翻译:**
Coinbase 做了一个叫“RAPID”的东西，RAPID 是关于角色分配的框架：负责者（Responsible）、批准者（Approver）、参与者（Participating）、被告知者（Informed）和决策者（Decider）。但他们执行的技术非常有趣。他们有一种微妙的“助推”（Nudge），我们以前没做，现在我把它引入了 Coda。在 Coda，我们有 Dory 和 Pulse，这是一个非常普遍的仪式，它已经传播到了很多使用 Coda 的公司。你其实不需要用 Coda 也能做，但我认为 Coda 做得很好。但我们面临的一个问题是，当你做 Pulse 环节开会时，如果做得不对，它可能感觉像是在投票，或者像是在达成共识。

---

### [00:36:04] Shishir Mehrotra

**English:**
And so we would get this, people would talk about it and every ritual has its pro and con, but people would look at it and say very open culture, you're allowed to share whatever you want. But on the other side for the person that's trying to make a decision, it can feel like, oh, my god, I now have 30 pieces of feedback. Am I supposed to wait for all 30 of them to be yes? Am I supposed to wait for it to be a majority and how do I know? What am I supposed to do here? And so Coinbase had this really simple idea that we sort of smushed together, which was at the top of their rapids they named who all the people were and then next to each one they put a little box that said what is the decision from that person?

**中文翻译:**
所以我们会遇到这种情况：人们讨论它，每个仪式都有优缺点。人们会觉得文化非常开放，你可以分享任何你想分享的东西。但另一方面，对于那个试图做决策的人来说，感觉就像：“天哪，我现在有 30 条反馈。我是不是得等这 30 个人都说‘是’？我是不是得等大多数人同意？我该怎么判断？我到底该怎么办？”Coinbase 有一个非常简单的想法，我们把它融合了进来：在他们的 RAPID 顶部，他们列出了所有相关人员，然后在每个人名旁边放一个小框，写明那个人的决定是什么。

---

### [00:36:44] Shishir Mehrotra

**English:**
They just organized. It's very similar to Pulse, but they kind of organized them and said everybody that's in the inform bucket, they can comment, that's totally fine, but we really care about the approvers, the responsible and then of course the decider, the one that really matters. And so we just added a column to our Pulse, which is what is the role? And we grouped the table by that. And the other thing that Coinbase does, which it sounds really subtle and small, but really in detail it really matters, is the person running the meeting pre-fills that with what they want from that person. You are an approver. Maybe I have three approvers because I have a budget approver and I have a marketing approver and I have a sales approver, whatever it might be, and I need you to give me this answer. I don't need you to comment on everything I'm doing, but I need you to tell me do we have the budget or not?

**中文翻译:**
他们只是把信息组织了一下。这和 Pulse 很像，但他们进行了分类：所有在“被告知”（Informed）桶里的人，他们可以评论，这完全没问题；但我们真正关心的是批准者、负责者，当然还有最重要的决策者。所以我们在 Pulse 中增加了一列：“角色是什么？”，并按此对表格进行分组。Coinbase 做的另一件事听起来很微妙、很小，但在细节上非常重要：会议召集人会预填他们希望从那个人那里得到什么。比如：“你是一个批准者。我可能有三个批准者：预算批准者、营销批准者和销售批准者。我需要你给我这个答案。我不需要你对我做的每件事都发表评论，但我需要你告诉我：我们到底有没有预算？”

---

### [00:37:31] Shishir Mehrotra

**English:**
Or I need you to tell me am I authorized to make this change in this part of the product that we generally don't change, or can I change the onboarding flow, or whatever it might be? And we took a process that I think was doing a pretty good job of getting rid of groupthink, which is really the heart of what we were doing with Pulse, but had this danger of being overly leaning towards consensus building to a fault. I think consensus building is a good thing, but consensus building to a fault is not. And we sort of stole this one from Coinbase and we switched it in and it got better. And that's a good example very recently.

**中文翻译:**
或者：“我需要你告诉我，我是否有权在产品中这个通常不改动的部分做变更？我能不能改动新手引导流程？”我们采用了一个我认为在消除“群体思维”（Groupthink）方面做得很好的流程（这正是 Pulse 的核心），但它曾面临过度倾向于达成共识的危险。我认为达成共识是好事，但过度追求共识则不然。我们从 Coinbase 那里“偷”了这个方法，把它换了进来，效果变好了。这就是最近的一个好例子。

---

### [00:38:05] Lenny Rachitsky

**English:**
I feel like you have a clear bestseller on your hands here and I can't wait to read this. I almost feel like you have an unfair advantage right now having all these insights before you share them, being able to execute so much more efficiently.

**中文翻译:**
我觉得你手里有一本准畅销书，我等不及要读了。我甚至觉得你现在拥有某种“不公平竞争优势”，因为你在分享这些见解之前就已经掌握了它们，能够更高效地执行。

---

### [00:38:17] Shishir Mehrotra

**English:**
Well, yeah, it's interesting. I'm obviously not trying to keep any of it a secret, so the whole point of publishing it is because I think other people will enjoy it and can get benefit out of it. But if people are interested, one of the other choices I made in writing this book is I decided to do it somewhat in the open. So there's what I call the rituals of great teams brain trust. And so if you just search for me and Rituals of Great Teams, you'll find it. And I'm sure we can add the link to the show notes, but you can sign up. And basically, as I finish a chapter, I put it out to the group and there's now a few hundred people that are helping me co-edit this thing.

**中文翻译:**
嗯，是的，这很有趣。我显然没打算保密，出版的初衷就是我认为其他人会喜欢并从中受益。如果大家感兴趣，我在写这本书时做的另一个选择是：我决定以某种“公开”的方式来写。我建立了一个叫“优秀团队仪式感智囊团”（Rituals of Great Teams Brain Trust）的东西。如果你搜我的名字和书名就能找到。我们可以把链接放在节目介绍里。你可以报名加入。基本上，我每写完一章，就会发给这个小组，现在有几百人在帮我共同编辑。

---

### [00:38:55] Shishir Mehrotra

**English:**
Some of them just because some of them come in and give me help on storytelling, grammar, so on, but a lot of them are contributing where they show up and they say, "Hey, you missed this one. We actually do that, but we do this other thing a little bit differently and you should really talk about that." Because I kind of view it as it started as a dinner series. It started with everybody's going to give to each other. And so I kind of wanted to bring that into the writing process. It's also a cheap way to get some pretty good editors and it pretty helpful.

**中文翻译:**
有些人是来帮我处理叙事、语法之类的，但很多人是在贡献内容，他们会说：“嘿，你漏掉了这个。我们其实也那么做，但我们在另一件事上的做法略有不同，你应该聊聊那个。”因为我把它看作是晚宴系列的延续——始于大家互相给予。所以我希望把这种精神带入写作过程。这也是一种获得优秀编辑的廉价方式，非常有帮助。

---

### [00:39:23] Lenny Rachitsky

**English:**
I love that. That is really smart. This episode is brought to you by Eppo. Eppo is a next generation AB testing platform built by Airbnb alums for modern growth teams. Companies like Netlify, Contentful and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to wasted time building internal tools or trying to run your experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved about our experimentation platform was being able to easily slice results by device, by country and by user stage. Eppo does all that and more, delivering results quickly, avoiding annoying prolonged analytic cycles and helping you easily get to the root cause of any issue you discover.

**中文翻译:**
我喜欢这个。这真的很聪明。本期节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 AB 测试平台。像 Netlify、Contentful 和 Cameo 这样的公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有能与现代增长团队技术栈集成的商业工具。这导致人们要么浪费时间构建内部工具，要么试图通过笨重的营销工具运行实验。当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，能够轻松地按设备、国家和用户阶段切分结果。Eppo 实现了这一切甚至更多，它能快速交付结果，避免烦人的漫长分析周期，并帮你轻松找到发现的任何问题的根本原因。

---

### [00:40:14] Lenny Rachitsky

**English:**
Eppo lets you go beyond basic click-through metrics and instead use your north star metrics like activation, retention, subscriptions and payments. And Eppo supports tests on the front end, the backend, email marketing and even machine learning clients. Check out Eppo at geteppo.com, get E-P-P-O.com and 10X your experiment velocity.

**中文翻译:**
Eppo 让你超越基础的点击率指标，转而使用你的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、邮件营销甚至机器学习客户端的测试。请访问 geteppo.com（G-E-T-E-P-P-O.com）查看 Eppo，让你的实验速度提升 10 倍。

---

### [00:40:36] Lenny Rachitsky

**English:**
And How have you found these rituals form for someone that's listening and are like, "We need some rituals, we need to move more effectively." How do these come up? Are they just organically organized? Do they come in from other and they evolve? Is it founder driven? What have you found so far? I know you're still working on the book, but curious.

**中文翻译:**
对于正在听节目并觉得“我们需要一些仪式，我们需要更有效地行动”的人，你发现这些仪式是如何形成的？它们是自然产生的吗？是从别处引入并演化的吗？是创始人驱动的吗？到目前为止你发现了什么？我知道你还在写书，但我很好奇。

---

### [00:40:53] Shishir Mehrotra

**English:**
There's a whole section of the book on ... I get this question a lot of how do I find the rituals we have? How do I adjust the rituals to match? Are they supposed to change? There's lots of things you see because some rituals are great when you're 100 people and they're terrible when you're 1,000. And you should actively change those things. Some are great in what sometimes people call peacetime versus wartime. You should do this during this time, but you should actively not do it when you're in this other time. And actually, that in itself is a ritual. I mean, every company has some form of a war room ritual that is ... I guess Facebook I was learning. We did a dinner last night, so I learned a little bit about it. Facebook apparently calls them lockdowns, which is a term I hadn't heard before, but apparently it's well understood. When they say lockdown, everybody knows exactly what it means.

**中文翻译:**
书中有一整个章节是关于这个的……我经常被问到：我该如何发现我们已有的仪式？我该如何调整仪式以匹配现状？仪式应该改变吗？你会看到很多情况，因为有些仪式在你只有 100 人时很棒，但在 1000 人时就很糟糕。你应该主动改变这些。有些仪式在所谓的“和平时期”与“战争时期”表现不同。你应该在这段时间做这个，但在另一段时间主动不做。实际上，这本身也是一种仪式。我是说，每家公司都有某种形式的“作战室”（War room）仪式。我昨晚参加晚宴时了解到，Facebook 显然称之为“封锁”（Lockdowns），这是我以前没听过的词，但显然大家都懂。当他们说“封锁”时，每个人都确切知道这意味着什么。

---

### [00:41:37] Shishir Mehrotra

**English:**
It's like we no longer do the goal setting process, you drop this type of work and everybody just knows this is what it means. But I would say that when we talk to people about rituals, a set of rituals that happen organically. I mean, those are the easiest. Dory and Pulse for us was one of the product managers running a meeting just thought it was we're a distributed first culture, but hadn't really adapted to it properly. And this product manager is just annoyed at waiting around on Zoom for everybody to go around and say their piece and it just took forever. And by the end everybody's like, "Can we just pause? Everybody just write down what you think." And he just happened to do it in this thoughtful way and it just took off. And so some rituals grow organically and you just got to wait for them to do it.

**中文翻译:**
这意味着我们不再进行目标设定流程，你放下这类工作，大家都知道这意味着什么。但我要说，当我们谈论仪式时，有一组仪式是自然发生的。这些是最容易的。对我们来说，Dory 和 Pulse 就是其中之一：当时一位产品经理在主持会议，他觉得我们虽然是“分布式优先”的文化，但还没完全适应。这位产品经理只是对在 Zoom 上等着每个人轮流发言感到厌烦，那太花时间了。最后大家说：“能不能停一下？每个人直接写下你的想法。”他恰好以这种深思熟虑的方式做了，然后就火了。所以有些仪式是自然生长的，你只需要等待它们出现。

---

### [00:42:24] Shishir Mehrotra

**English:**
But there are cases where companies actively form a ritual to drive a certain behavior. And the best advice I've given on this topic is to read one of my other favorite books. It's a book called Switch. It's by Chip and Dan Heath. All their books are amazing, but they also wrote Decisive and Made to Stick and Moments and so on. But this one is, if I could recommend five books, this would take two slots on the list. And the subtitle of the book is How to Change Things When Change is Hard. And the basic idea of the book is they use this analogy of a writer on an elephant on a path. And when you're trying to change things, you have three options for what you can do and it actually kind of maps to Bing's analogy. So you can direct the writer, so you can tell people what to do.

**中文翻译:**
但也有些情况，公司会主动建立一个仪式来驱动某种行为。关于这个话题，我能给出的最好建议是去读我最喜欢的另一本书，叫《瞬变》（Switch），作者是 Chip 和 Dan Heath。他们所有的书都很棒，他们还写过《决断力》、《粘性》和《峰值体验》等。但这一本，如果让我推荐五本书，它会占两个名额。书的副标题是“当改变很难时如何改变”。书的基本思想是他们使用了“路径上的大象和骑象人”这个类比。当你试图改变事物时，你有三个选择，这实际上与 Bing 的类比相对应。你可以“指挥骑象人”，也就是告诉人们该做什么。

---

### [00:43:13] Shishir Mehrotra

**English:**
You can motivate the elephant, so you can give this thing a kick in the butt and it's going to move. You don't know exactly where it's going to move, but it's going to move. And you can shape the path. Shape the path is I'm going to set this way up so that you can only do these things. The way I think about it is direct the writer, tell people what to do. That's why if you look at Bing's tests, that's why you teach employees this before the first writing. You tell people this is what we do. And so some rituals, how do you get this ritual to work? You put it in your new hire onboarding and you make it work that way. Motivate the elephant, a lot of that's about branding. So what do you do with rituals? It's an amazing number of rituals where I'll tell people that seems like a great ritual.

**中文翻译:**
你可以“激励大象”，也就是踢这家伙的屁股让它动起来。你不知道它具体会往哪儿动，但它会动的。你还可以“塑造路径”，即我把路设好，让你只能做这些事。我的理解是：指挥骑象人就是告诉人们该做什么。这就是为什么在 Bing 的测试中，你要在第一个周五前教给员工，你告诉他们“这就是我们的做法”。所以对于某些仪式，你如何让它运转？你把它放进新员工引导中。激励大象很大程度上关乎品牌化。那么你对仪式做了什么？有很多仪式，我会告诉人们那看起来是个很棒的仪式。

---

### [00:43:51] Shishir Mehrotra

**English:**
I would highly encourage you to give it a name. Give it something that lets people anchor ideas to. Names a very powerful thing. If I said, "Yeah, at Coda we do voting and sentiment writing or something," I don't even know what you would say. It would sound boring. It wouldn't sound like something you could brag about, something you could form identity around. And so it's very important to give it a name. And then finally, why do you shape the path or you set things up? You templatize, make it as easy as possible to follow this ritual. And make it just a part of what we do enough, then if you're at Gusto and you're like, "I don't really understand that hiring cult thing," where it's like guess what? You're going to be invited to one soon.

**中文翻译:**
我强烈建议你给它起个名字。给它一个能让人们锚定想法的东西。名字是非常强大的。如果我说：“在 Coda，我们做投票和情感写作之类的，”我都不知道该怎么说，听起来很无聊。它听起来不像你可以炫耀的东西，也不像你可以围绕它形成身份认同的东西。所以起名非常重要。最后，为什么要塑造路径或设定环境？你要模板化，让遵循这个仪式变得尽可能简单。让它成为我们工作的一部分，如果你在 Gusto 说“我不太理解那个招聘电话的事”，猜猜怎么着？你很快就会被邀请参加一个。

---

### [00:44:28] Shishir Mehrotra

**English:**
You're going to see it and then you're going to have to do it. Or if you're at Square, you're going to see the spade template and you're going to learn how to do it. So I think Switch is ... I recommend this book for lots of purposes, but as you're thinking about rituals for your teams, it's a particularly relevant frame.

**中文翻译:**
你会亲眼看到，然后你就不得不去做。或者如果你在 Square，你会看到 Spade 模板，然后学会怎么做。所以我认为《瞬变》……我出于很多目的推荐这本书，但当你思考团队仪式时，它是一个特别相关的框架。

---

### [00:44:45] Lenny Rachitsky

**English:**
I love that. By the way, that's a little plug for the YouTube version of this podcast, which is now a thing we do. So if you're like, hey, I don't see what you're talking about, just search for Lenny's podcast, YouTube, and I think you'll find it and we'll probably link to the ad in the show notes. I'm also reminded of Airbnb's rituals, which you probably already know about, but they're kind of all hilarious and weird. One is formal Friday, where people dress up in suits and gowns on Fridays. Another is a human tunnel for all new employees, where every new employee has to run through a human tunnel and jump into a beanbag or something. And then there's a new hire tea time, where new hires drink some tea with some veterans and chat about where they're from and things like that. There's a bunch more, but those are the ones that are my favorite.

**中文翻译:**
我喜欢这个。顺便说一下，顺便给本播客的 YouTube 版打个广告，这是我们现在在做的事。所以如果你觉得“嘿，我没看到你在说什么”，只需在 YouTube 搜索“Lenny's podcast”，我想你能找到，我们也会在节目介绍里放链接。我也想到了 Airbnb 的仪式，你可能已经知道了，它们都挺搞笑且奇怪的。一个是“正式周五”（Formal Friday），大家在周五穿西装和礼服。另一个是为新员工准备的“人体隧道”，每个新员工都要穿过一个人体隧道，然后跳进豆袋沙发之类的。还有“新员工茶歇时间”，新员工和老员工一起喝茶，聊聊来自哪里之类的话题。还有很多，但这些是我最喜欢的。

---

### [00:45:27] Shishir Mehrotra

**English:**
Those are great. I also included some of the level 11 thinking as well. I think that's also a good Chesky favorite. Brian also has another one that's in the book that's about how to rank your to-do list by finding leverage. That's a really fun one as well. They're like don't rank your to-do list, but a lot of people do importance versus urgency or so on. And I guess he sorts his by which of these is most likely to create leverage of getting rid of the rest of my lists, which I thought was very ... I started doing that in my to- do list and it's very interesting and impactful.

**中文翻译:**
那些都很棒。我也把一些“11 级思维”放进去了，我想那也是 Brian Chesky（Airbnb CEO）的最爱。Brian 还有一个故事在书里，是关于如何通过寻找杠杆来给待办事项排序。那也非常有趣。通常人们按重要性或紧急程度排序，但他排序的标准是：哪一项最有可能产生杠杆作用，从而让我可以划掉清单上的其他所有项。我觉得这非常……我开始在我的待办清单里这么做了，非常有趣且有效。

---

### [00:46:02] Lenny Rachitsky

**English:**
That's actually an incredible segue to our next topic, which are eigenquestions.

**中文翻译:**
这实际上是引出我们下一个话题——“特征问题”（Eigenquestions）——的一个绝佳过渡。

---

### [00:46:06] Shishir Mehrotra

**English:**
Ah, yes.

**中文翻译:**
啊，是的。

---

### [00:46:08] Lenny Rachitsky

**English:**
And so eigenquestions, one of your most classic posts, you mentioned this at the top, maybe your one of the most liked posts, other than maybe bundling. It sounds like some kind of German game show, eigenquestions. Can you tell us what eigenquestions are, and then I'm going to ask you a few more questions around that?

**中文翻译:**
特征问题，你最经典的文章之一，你开头也提到了，可能是除了捆绑销售外你最受欢迎的文章。Eigenquestions 听起来像某种德国游戏节目。你能告诉我们什么是特征问题吗？然后我会围绕它再问几个问题。

---

### [00:46:22] Shishir Mehrotra

**English:**
I've thought about the German game question.

**中文翻译:**
我也想过那个德国游戏节目的梗。

---

### [00:46:26] Lenny Rachitsky

**English:**
Yeah, sorry [inaudible 00:46:27].

**中文翻译:**
哈哈，抱歉。

---

### [00:46:29] Shishir Mehrotra

**English:**
I didn't know this would be a very interesting game, but we could try to create one. Okay, so I'll describe what eigenquestions are, but maybe I'll start by telling you a little bit about where the concept came from. And, this is actually a YouTube-ism that... Maybe just to place ourselves in history, so in 2008 I joined YouTube. And many people don't remember this, but YouTube at the time was seen as a mistake. It was seen as Google's first bad acquisition, everything else had worked, but this thing kind of seemed like a disaster. It was grainy videos, we were losing lots of money, we had billions of dollars in lawsuits, none of it really seemed that obvious. There's lots of discussion on how to reorient it, fix it, and so on. And so everybody outside, that's what they saw.

**中文翻译:**
我不知道这会不会是个有趣的游戏，但我们可以试着做一个。好，我来描述一下什么是特征问题，但我先从这个概念的来源讲起。这实际上是一个“YouTube 主义”……让我们回到历史背景：2008 年我加入 YouTube。很多人不记得了，但当时 YouTube 被视为一个错误。它被看作是 Google 的第一次失败收购，其他收购都成功了，唯独这个看起来像场灾难。视频画质很差，我们在亏大钱，还有数十亿美元的诉讼，前途未卜。外界看到的都是这些，关于如何调整、修复它有很多讨论。

---

### [00:47:14] Shishir Mehrotra

**English:**
If you stepped inside a YouTube staff meeting in 2008, actually one of the toughest questions we were answering was this question we called the Modern Family question. And it may sound small, but it actually was very perplexing. And the question was pretty simple, the question was if you looked at our search traffic at YouTube, one of the top five queries basically every week was for a show called Modern Family. And Modern Family was number one show on television at the time, by far the most popular. And we were second-biggest search engine in the world behind our parent company Google, so search traffic was very important. There was one big problem, people would come search for Modern Family, one big problem, we didn't have Modern Family on YouTube. And so we'd give them some pretty crappy responses. And the question was... And by the way, ABC.com had decided to post every episode of Modern Family live on their website.

**中文翻译:**
如果你走进 2008 年 YouTube 的员工会议，实际上我们面临的最棘手问题之一是所谓的“《摩登家庭》问题”（Modern Family question）。这听起来很小，但其实非常令人困惑。问题很简单：如果你看 YouTube 的搜索流量，每周排名前五的查询词中基本都有《摩登家庭》。那是当时最火的电视剧，没有之一。我们是仅次于母公司 Google 的全球第二大搜索引擎，所以搜索流量非常重要。但有一个大问题：人们来搜《摩登家庭》，但 YouTube 上根本没有。所以我们只能给他们一些很烂的搜索结果。问题是……顺便说一下，ABC.com 当时决定在他们的网站上直播《摩登家庭》的每一集。

---

### [00:48:06] Shishir Mehrotra

**English:**
Which nowadays is kind of typical, but in 2008 that was not typical, no is it kind of a big gamble they made, and they're going to post all these shows. So the question was, should we answer the query Modern Family by linking off to ABC.com? Do we link out or not? And the company basically divided. And so there's half the company, mostly the product team, vantage team and so on kind of aligned around a viewpoint that was, "That's what the user wants, link them off to ABC.com. We're not owned by Google, Google tries hard to prioritize, do right by the user, the rest will follow. That seems like the right thing to do, so let's do that." And then the other half of the company, most of the business function, sales, marketing, especially content partnership said, "Please, please, please don't do that. If you do that and you start linking off to all these other places, nobody's ever going to put good content on YouTube, and we're just going to get the stuff that doesn't deserve to live anywhere else. And that's not a very good path to be."

**中文翻译:**
这在今天很平常，但在 2008 年并非如此，那是他们的一场豪赌。所以问题是：我们是否应该通过链接到 ABC.com 来回答“摩登家庭”的搜索请求？我们要不要链接出去？公司基本上分成了两派。一半人（主要是产品和技术团队）认为：“这是用户想要的，把他们链接到 ABC.com 吧。我们被 Google 收购了，Google 的信条就是优先考虑用户，其他一切水到渠成。这看起来是正确的事，那就做吧。”而另一半人（主要是业务部门、销售、营销，特别是内容合作伙伴团队）说：“求求你们千万别这么做。如果你开始链接到其他地方，就没人会把优质内容放在 YouTube 上了，我们最终只会得到那些在别处待不下去的垃圾内容。这不是一条好路。”

---

### [00:48:59] Shishir Mehrotra

**English:**
And you can imagine that those two mindsets, it's almost like it was good versus evil debate, which is do right by the user or the business. These are all almost impossible to solve problems. And this would happen meeting after meeting after meeting, did we make a decision yet? Modern Family, what are we going to do? So we had this offsite, we said we're going to spend the whole day, and we're going to figure this problem. And we went up to this hotel in Half Moon Bay, and the executive team all sat down, and I was asked to frame the discussion, go collect everybody's opinions, and collect all the data, and just ground it all in facts. And then we're going to have a discussion, we're going to reach a decision. And so the night before I'm sitting and thinking about, how the hell we going to have this discussion not just be a shouting match of this good versus evil position?

**中文翻译:**
你可以想象，这两种心态就像是“善与恶”的辩论：是为用户做正确的事，还是为业务做正确的事？这些几乎都是无解的问题。会议开了一次又一次：“我们做决定了吗？《摩登家庭》到底怎么办？”于是我们搞了一次团建（Offsite），决定花一整天时间解决这个问题。我们去了半月湾的一家酒店，高管团队坐下来，我被要求主持讨论，收集所有人的意见和数据，并以事实为基础。然后我们将进行讨论并做出决定。前一天晚上我坐在那儿想：我们到底该怎么讨论，才能不让它变成一场关于“善恶立场”的对骂？

---

### [00:49:46] Shishir Mehrotra

**English:**
And I happened to read a analysis that was being done by a different team at Google, the Google shopping team, where they were facing this interesting challenge of they were in this deep fight with Amazon, and they were getting their butts kicked, and they were trying to figure out why. And the walking in theory was, the Google shopping team's view was why would anybody ever go in to Amazon? You could come to Google, and we had indexed all of Amazon and the entire internet, why would you ever pick Amazon? And the feedback that was coming back from users was they'd say, "I picked Amazon because I value consistency over comprehensiveness." They would say things like, "I really value that I go to amazon.com and I understand how the reviews work and how the ratings work, and I know that the returns work the way I want and I understand the shipping is going to work. And it just felt consistent. I know it doesn't have everything, but it has enough. And I value consistency over comprehensiveness."

**中文翻译:**
我碰巧读到了 Google 另一个团队（Google 购物团队）的一份分析报告。他们当时正面临与亚马逊的激战，而且被打得很惨，他们正试图找出原因。当时的理论是，Google 购物团队认为：为什么会有人去亚马逊？你可以来 Google，我们索引了整个互联网，包括亚马逊，你为什么要选亚马逊？而用户反馈回来的信息是：“我选亚马逊是因为我更看重**一致性**（Consistency）而非**全面性**（Comprehensiveness）。”他们会说：“我非常看重在亚马逊购物时，我知道评论和评分是怎么运作的，我知道退货流程符合预期，我知道物流是怎么回事。这感觉很一致。我知道它没有所有的东西，但它有的已经足够了。我宁要一致性，不要全面性。”

---

### [00:50:43] Shishir Mehrotra

**English:**
And the night before this YouTube meeting, I decided to reframe the question and say, let's not have the discussion about linking out at all. We're going to start by having a theoretical discussion about, in a decade from now, is the online video market more likely to be about consistency or about comprehensiveness? And that is a question that you can have a very reasonable debater. What are the reasons why a market evolves towards consistency over comprehensiveness? And we basically have this discussion and we all came to the conclusion this market is going to value consistency over comprehensiveness.

**中文翻译:**
在 YouTube 会议的前一天晚上，我决定重新定义问题。我说：我们根本不要讨论“链接出去”的问题。我们先来一场理论讨论：从现在起十年后，在线视频市场更可能是关于“一致性”还是“全面性”？这是一个可以进行理性辩论的问题。市场向一致性而非全面性演进的原因是什么？我们进行了讨论，最终大家都得出了结论：这个市场将更看重一致性而非全面性。

---

### [00:51:17] Shishir Mehrotra

**English:**
And by the way, I think, I mean now almost 15 years later, I think we're right. If you go look at video market obviously it exploded. There's so many great video properties out there, none of them are comprehensive. There is no one-stop shop or a place where all the video exists. And so I think we were right. But what happened was by answering that question, the link out question all of a sudden became super easy. We value consistency over comprehensive. We definitely don't need to link out. In fact, we should make a whole bunch of other decisions as well. So we went and at the time we used to, this was the days of flashed players and so on, we embedded other people's players on YouTube. We stopped doing that as well. Probably the most famous decision we made was with the iPhone.

**中文翻译:**
顺便说一下，快 15 年过去了，我认为我们是对的。看看现在的视频市场，它爆炸式增长，有很多伟大的视频平台，但没有一个是“全面”的。没有一个一站式商店能包含所有的视频。所以我觉得我们是对的。但结果是，通过回答那个问题，“链接出去”的问题突然变得超级简单：我们看重一致性而非全面性，所以我们绝对不需要链接出去。事实上，我们还因此做了一系列其他决定。比如当时还是 Flash 播放器的时代，我们会在 YouTube 上嵌入别人的播放器，我们也停止了这种做法。可能我们做的最著名的决定是关于 iPhone 的。

---

### [00:51:56] Shishir Mehrotra

**English:**
As I mentioned earlier, the iPhone when it first shipped had no app store. And so they built all the first few apps including YouTube. And so here we were a few years later, iPhone the most popular phone on the planet and the YouTube app on the iPhone was built by a team at Apple and they had not been able to keep up with what we were doing. Almost half the catalog didn't play back on the iPhone, they were missing a bunch of features and so on.

**中文翻译:**
正如我之前提到的，iPhone 最初发布时没有应用商店。所以他们自己开发了最初的几个应用，包括 YouTube。几年后，iPhone 成了地球上最流行的手机，但 iPhone 上的 YouTube 应用是由 Apple 的团队开发的，他们跟不上我们的步伐。几乎一半的内容在 iPhone 上无法播放，还缺失了很多功能。

---

### [00:52:17] Shishir Mehrotra

**English:**
So I drove down to Cupertino and I sat down with Scott and Phil and said, "Hey, we're going to have to take back the YouTube app." And they said, "I don't understand. Why would you do that? You have default distribution on, as far as they were concerned, the most important operating system in the world. Why would you do that? You're going to have to rebuild all this from scratch and it just seems like a really bad choice." And I said, "No, no, it's actually quite an easy choice. We value consistency over comprehensiveness. We would much rather be on fewer phones with a more consistent experience than be on all of them with an inconsistent experience." So what, this is a choice we're making and it worked out fairly well.

**中文翻译:**
于是我开车去库比蒂诺，和 Scott（Forstall）以及 Phil（Schiller）坐下来谈。我说：“嘿，我们要收回 YouTube 应用的开发权。”他们说：“我不明白。你为什么要这么做？你在全球最重要的操作系统上拥有默认分发权。你为什么要放弃？你得从头开始重写，这看起来是个非常糟糕的选择。”我说：“不，不，这其实是个很简单的选择。我们看重一致性而非全面性。我们宁愿在较少的手机上提供一致的体验，也不愿在所有手机上提供不一致的体验。”这就是我们做的选择，结果证明效果非常好。

---

### [00:52:51] Shishir Mehrotra

**English:**
So this decision, the Modern Family question ended up becoming named as the example for a term called eigenquestion. So eigenquestions, it's not a German game show, it is a made up word and it's named after a math concept called eigenvectors. And the math is not really necessary, but for people who are curious, go back to linear algebra, eigenvectors are in a multidimensional space. They're the most discriminating vectors of the vectors in that space, the dimensions of that space, it's a concept that gets used a lot in machine learning and so on, but actually the math doesn't really matter. The eigenquestion, the simplest definition of eigenquestion, it's the question that when answered also answers the most subsequent questions.

**中文翻译:**
所以这个决定，即《摩登家庭》问题，最终成为了一个术语的范例，这个术语叫“特征问题”（Eigenquestion）。Eigenquestions 不是德国游戏节目，它是一个合成词，取自数学概念“特征向量”（Eigenvectors）。不需要懂数学，但好奇的人可以回顾一下线性代数：特征向量在多维空间中是该空间中最具辨识度的向量。这个概念在机器学习中用得很多，但数学本身不重要。特征问题最简单的定义是：**那个一旦被回答，就能同时回答最多后续问题的核心问题。**

---

### [00:53:35] Shishir Mehrotra

**English:**
And it's a very simple idea that when you sit down and you say, hey, here's all these questions we ought to answer, how do we all usually rank them? Sometimes we rank them just by what order we came up with them. Sometimes we rank them by importance, which is the most impactful decision we're going to make. But this methodology says don't rank them that way. Rank them, like you said, [inaudible 00:53:53] thing about about leverage, same idea, rank them by which ones would eliminate the most other questions of the list. So you take that list and you said, should we link out to Modern Family? Should we own the YouTube iPhone app? Should we do... mind you, those were really hard questions to answer. But turns out if you answered just one question, do we value consistency over comprehensiveness, you answer all the others. They all of a sudden become very simple.

**中文翻译:**
这是一个非常简单的想法：当你坐下来列出所有需要回答的问题时，我们通常如何排序？有时按想到的顺序，有时按重要性（哪个决策影响最大）。但这种方法论说：不要那样排序。要像你提到的杠杆原理一样，按“哪个问题能消除清单上最多的其他问题”来排序。你拿着清单问：我们要链接到《摩登家庭》吗？我们要自主开发 iPhone 应用吗？我们要……提醒你，这些都是很难回答的问题。但事实证明，如果你只回答一个问题——“我们看重一致性还是全面性？”——你就回答了所有其他问题。它们突然间变得非常简单。

---

### [00:54:13] Shishir Mehrotra

**English:**
And so this idea of eigenquestion became part of our vocabulary, became a clear ritual for YouTube, that is, what is the eigenquestion, here at Dish for Coda as well, it sort of spread through other places, but that's the basic idea.

**中文翻译:**
所以“特征问题”这个概念成为了我们词汇表的一部分，成了 YouTube 的一个明确仪式，即“特征问题是什么？”在 Coda 也是如此，它也传播到了其他地方，这就是基本思想。

---

### [00:54:26] Lenny Rachitsky

**English:**
Amazing. What a baller move with Apple.

**中文翻译:**
太牛了。对 Apple 采取那样的行动真是霸气。

---

### [00:54:30] Shishir Mehrotra

**English:**
Pretty scary move, yeah.

**中文翻译:**
确实挺吓人的。

---

### [00:54:31] Lenny Rachitsky

**English:**
Yeah. But I was just going to say, I think YouTube's probably in the top five, 10 most downloaded apps. So it worked out.

**中文翻译:**
是的。但我正想说，我想 YouTube 现在可能是下载量前五或前十的应用。所以结果证明是对的。

---

### [00:54:38] Shishir Mehrotra

**English:**
We'd go for that meeting and I bring along the product manager for the iPhone app named Andrey Doronichev, and he's the one having to explain what we're going to do and so on. And it's a hard contentious meeting. And as we're leaving the meeting, he says, "Hey, can I get a selfie with Bill and Scott?" Andrey, what are you doing? There's this great picture of him with us asking for, take this back. And clearly he's very starstruck. There's a lot of people with view as like, Apple would do a better job of building the YouTube app than us. Who are we to tell them to not do that? Of course, in retrospect, that was a silly way to think about it.

**中文翻译:**
我们去开那个会，我带上了 iPhone 应用的产品经理 Andrey Doronichev，他负责解释我们要怎么做。那是一场艰难且充满争论的会议。当我们离开会议室时，他说：“嘿，我能和 Phil 和 Scott 合个影吗？”我说：“Andrey，你在干嘛？”有一张很棒的照片，是他和我们在一起，而我们刚刚要求收回开发权。显然他当时追星心切。当时很多人认为 Apple 开发 YouTube 应用会比我们做得更好，我们凭什么叫他们别做了？当然，回过头来看，那种想法很愚蠢。

---

### [00:55:17] Lenny Rachitsky

**English:**
Wow. I would do the same thing. That's amazing. Who's this person? Because that's awesome. I love that as a leader you bring the PM of the team working on it versus just the big shots at the top.

**中文翻译:**
哇。我也会做同样的事。太棒了。那个人是谁？这太酷了。我喜欢你作为领导者会带上负责该项目的 PM，而不仅仅是高层大人物。

---

### [00:55:29] Shishir Mehrotra

**English:**
Yeah, Andrey, he's now a founder. He started a company called OPTIC, basically building content ID for NFTs, which is a much needed thing in the Web3 world. But yeah, I mean the team building it, I mean, that meeting I brought my partnerships lead and I brought the ENCH lead that was covering the area too. And yeah, I think that some of it is, if I had to be honest, some of it is like they really wanted to come and meet with Apple. Some of it is like, for my own sake, I kind of wanted some backup. I'm about to make this kind of bold ass... And to Apple's credit, I mean they could have been pretty bad about it. I mean they could have not allowed us on the store and so on.

**中文翻译:**
是的，Andrey，他现在是个创始人。他创办了一家叫 OPTIC 的公司，基本上是为 NFT 构建内容识别（Content ID），这在 Web3 世界非常需要。那次会议我还带了我的合作伙伴负责人和负责该领域的工程负责人。老实说，部分原因是他们真的很想见见 Apple 的人；部分原因是我自己也想要点支持，因为我正要做一个非常大胆的决定……公平地说，Apple 本可以表现得很差，比如不让我们上架商店之类的。

---

### [00:56:09] Shishir Mehrotra

**English:**
And they said, "Okay, well we don't like it, but we understand your choice. You have to know that you're going to start from zero. We're not giving you a single download for free. You're going to have to start from zero and we will brick the current app right on the agreed upon date." And the negotiation was can you please just tell those people that there's a new app? And so that's what we negotiated out of it and they eventually did that and that was fine. And in the end, YouTube is now one of the top downloaded apps on iPhones I think. I mean, it was like six months after launch, we had like 80% share. Everybody downloaded the app. And so it kind of ended up not being that much of a comprehensiveness choice, but it was a clearly hard decision made much easier by asking the right eigenquestion first.

**中文翻译:**
他们说：“好吧，我们不喜欢这个决定，但我们理解。你必须知道你将从零开始。我们不会免费给你任何下载量。你得从零开始，我们会在约定的日期停掉现在的应用。”我们的谈判点是：能不能请你们告诉用户有一个新应用？这就是我们谈下来的结果，他们最终也这么做了。最后，YouTube 现在是 iPhone 上下载量最高的应用之一。我想在发布六个月后，我们就占领了 80% 的份额，每个人都下载了应用。所以这最终并没有牺牲太多的全面性，但通过先问对“特征问题”，一个艰难的决定变得容易多了。

---

### [00:56:55] Lenny Rachitsky

**English:**
Wow. Speaking of eigenquestions, are there other examples of eigenquestions that come to mind to make this even more concrete in people's minds? I don't know if that's the right way to frame it or is it more just when you have a list of questions, look for the one that'll answer the most. How do you operationalize this concept?

**中文翻译:**
哇。说到特征问题，你还能想到其他例子让大家理解得更具体吗？我不确定这么问对不对，或者只是当你有一堆问题时，寻找那个能回答最多的问题。你如何将这个概念付诸实践？

---

### [00:57:13] Shishir Mehrotra

**English:**
There's lots of them. I mean for Coda, the sort of most conceptual eigenquestion for Coda was, we use a line a lot for Coda, that Coda allows anyone to make a doc as powerful as an app. You can reverse that statement and say, allow anyone to make an app as easily as a doc. And those two sound similar, but they're not. They're actually quite different statements. And so our most commonly debated eigenquestion is, are we more committed to being a doc or being an app? And which way do we want people, if people are going to misunderstand Coda, would we rather them perceive it as a document or perceive it as an app? And we decided on doc, which is actually... And the way I cemented that decision when we made it was I named the company that way, where Coda is a doc backwards.

**中文翻译:**
有很多。对 Coda 来说，最核心的特征问题是：我们常说 Coda 让任何人都能做出像应用一样强大的文档。你可以反过来说，让任何人都能像做文档一样轻松地做出应用。这两句话听起来很像，但其实不是。它们是完全不同的陈述。所以我们最常辩论的特征问题是：我们更致力于成为一个“文档”还是一个“应用”？如果人们会误解 Coda，我们宁愿他们把它看作文档还是应用？我们决定是“文档”。为了巩固这个决定，我给公司起名 Coda，因为 Coda 就是“A doc”倒过来写。

---

### [00:57:56] Shishir Mehrotra

**English:**
I said, "Well, we're definitely not revisiting this one. Coda is a doc first." That's a good example. I mean, another one, by the way, I would say eigenquestions is a term that a guy could resonance itself, but it's a hard technique. It's not always easy to know how to do it. And one of the things I get asked a lot it's like, is it a skill you can learn? I absolutely think it's a skill you can learn. It's a thing that once you observe it, you get better at it, you can learn it, but it's not easy to learn it. And one of my observations by learning skills like these is, you want to learn them in non-pressure filled environment. To use an analogy, if you were trying to learn a sport or learn an instrument or so on, imagine if you never did practice, every time you played basketball was in a real basketball game and every time you played the piano was in a recital, you probably would never get better.

**中文翻译:**
我说：“好吧，我们绝对不会再讨论这个问题了，Coda 首先是一个文档。”这是一个好例子。顺便说一下，特征问题这个词本身很有共鸣，但它是一项很难的技术。知道怎么做并不总是那么容易。我经常被问到：这是一种可以习得的技能吗？我绝对认为是可以学习的。一旦你观察到它，你就会变得更擅长，但学习过程并不容易。我观察到，学习这类技能时，你需要在没有压力的环境中学习。打个比方，如果你想学运动或乐器，想象一下如果你从不练习，每次打篮球都是正式比赛，每次弹钢琴都是独奏会，你可能永远不会进步。

---

### [00:58:50] Shishir Mehrotra

**English:**
And I think one of the troubles with the concept like eigenquestions is, we tend to only practice it in real world scenarios that are high stakes. And so one of the things I encourage people to do is to practice eigenquestion in completely almost frivolous situations. So I have an interview question I ask, which I think, and maybe we'll get to this a little bit later as well, but it's a very simple question and it's a coded eigenquestion test. And the question is, a group of scientists have invented a teleportation device. They've hired you, Lenny, to be their sort of business counterpart, bring this to market product... Well, this question actually worked well for any role. But say you could be a product manager for this thing, bring it to market and what do you do? That's the whole question.

**中文翻译:**
我认为特征问题这类概念的一个麻烦在于，我们往往只在利益攸关的现实场景中练习。所以我鼓励人们在完全无关紧要、甚至有点轻率的场景中练习。我有一个面试题，我想这可能也是一个隐蔽的特征问题测试。问题是：一群科学家发明了一个瞬间移动装置（Teleportation device）。他们雇了你，Lenny，作为他们的业务伙伴，把这个产品推向市场……这个题其实适用于任何角色。假设你是这个产品的 PM，你要把它推向市场，你会怎么做？这就是全部问题。

---

### [00:59:40] Shishir Mehrotra

**English:**
Usually people will start asking a bunch of questions and say, "Well, tell me more about this device. What does it do? How does it work? And is it big? Is it small? Is it vast? Does it disintegrate things or not? Does it need a receiver and a sender? It's safe?" And all these different questions come out and at some point I'll just let those questions come out and at some point I'll say, " Okay, nice job generating all the questions." Turns out these scientists, they kind of hate talking to people and they're kind of annoyed by all your questions. And so they've decided that they will answer only two of your questions and after that they expect a plan. What two questions do you ask?

**中文翻译:**
通常人们会开始问一大堆问题：“告诉我更多关于这个装置的信息。它是怎么工作的？大还是小？是瞬间移动还是分解再重组？需要接收端和发送端吗？安全吗？”各种问题都会出来。我会让他们问，然后说：“好，问题提得不错。但事实证明，这些科学家讨厌和人打交道，他们被你的问题烦透了。所以他们决定只回答你两个问题，之后他们就要看到计划。你会问哪两个问题？”

---

### [01:00:16] Shishir Mehrotra

**English:**
And interestingly, all of a sudden the sharp product managers, engineers, so basically every role, they very quickly find what are the one or two eigenquestions on this topic. And there's no right answer, but I'll tell you one of my favorite ones is as a product manager said, "Okay, if I had to ask two questions, the two question I would ask, one is, is it safe enough for humans or not?" And I would say a very crisp way to get to just safety, how reliable it is, they didn't ask how reliable it is, how many bits in middle, just tell me is it safe enough for humans or not? And the second one is, is it more expensive CapEx or OpEx? Is it more expensive to buy them or to run them?

**中文翻译:**
有趣的是，那些敏锐的 PM、工程师（基本上是所有角色）会非常迅速地找到这个话题的一两个特征问题。没有标准答案，但我告诉你我最喜欢的一个回答。一位 PM 说：“好，如果只能问两个，第一个是：它对人类是否足够安全？”这是一个非常干脆的切入点，不问可靠性或技术细节，只问能不能传人。第二个是：“它的成本主要是资本支出（CapEx）还是运营支出（OpEx）？是买它贵，还是运行它贵？”

---

### [01:00:39] Shishir Mehrotra

**English:**
And then he took those two questions and he said, "Just with those two questions, I can form these quadrants." And you can say, oh, it's safe enough for humans and they're very cheap to buy, but expensive to run. Then you probably run them like human fax machines. You put them everywhere you can and you say, "Hey look, it's expensive to use, but you'll have the ability to teleport anywhere you want and this is how we're going to run it." On the other hand, they're very expensive to buy, but cheap to run. You probably have to place them very strategically, in which case what you'd probably do is replace airports. Because airports are pretty strategically placed in places where people are trying to get around places.

**中文翻译:**
然后他拿着这两个问题说：“仅凭这两个问题，我就可以构建出象限。”你可以说：如果对人安全，购买便宜但运行贵，那你可能会像“人体传真机”一样运营它。你把它放得随处可见，然后说：“虽然用起来贵，但你可以随时随地瞬间移动。”另一方面，如果购买极贵但运行便宜，你可能需要非常有策略地放置它们，在这种情况下，你可能会取代机场。因为机场已经策略性地放置在人们需要远行的地方了。

---

### [01:01:17] Shishir Mehrotra

**English:**
If it's not safe enough for humans, then you've got a whole different class of use cases where you go value what goods are transported in very costly ways. And people come up with, do you do the most expensive things or is teleporting people's replacement hearts, is that a really demanding thing? But these two questions kind of get to the heart of it. The question's totally made up. No teleportation device exists, at least not yet. And I find that people's ability to learn the method is significantly higher if it's low stakes.

**中文翻译:**
如果对人不安全，那你就有了一套完全不同的用例，你会去研究哪些货物的运输成本极高。人们会想到：是运送最昂贵的东西，还是运送移植用的心脏？那可是非常紧迫的需求。这两个问题触及了核心。这个问题完全是虚构的，瞬间移动装置还不存在。但我发现，在低风险的情况下，人们学习这种方法的能力会显著提高。

---

### [01:02:05] Shishir Mehrotra

**English:**
That question by the way, if you ask a kid that question, the hey new teleportation device, you get to ask two questions, almost every kid will quickly get to two pretty good eigenquestions. Again, kids are incredibly good at simplifying these things down. It's actually a skill we remove from ourselves. I'll hear candidates tell me things like, well, I guess I would ask them what size it is. And they're like, "Why would you ask them what size, what decision is that going to allow you to make, to know what size it is?" And sometimes I can explain it, but sometimes not, don't get hired.

**中文翻译:**
顺便说一下，如果你问一个孩子这个问题，几乎每个孩子都能迅速找到两个很棒的特征问题。孩子们非常擅长简化事物，这其实是我们成年后逐渐丧失的技能。我会听到应聘者说：“我想我会问它有多大。”我会问：“你为什么要问大小？知道大小能帮你做哪个决策？”有时他们能解释，有时不能，不能的就没被录用。

---

### [01:02:36] Shishir Mehrotra

**English:**
But then actually the thing I'd say about it is there are eigenquestions everywhere. You can take any product out there. I'll do it with my kids a lot and they'll say, I was just riding with my younger daughter and she said, "How come there's three gas stations in the same corner? Why do people do that?" That's a really insightful observation. What's the eigenquestion? How do you place a gas station? And it's like a bread nose. And you can almost take anything and say, what is the question that really drives this answer?

**中文翻译:**
其实我想说的是，特征问题无处不在。你可以拿任何产品来练习。我经常和孩子们一起做这个。有一次我和小女儿开车，她说：“为什么同一个路口有三家加油站？人们为什么要这么做？”这是一个非常有洞察力的观察。特征问题是什么？如何选址加油站？你几乎可以拿任何事情来问：真正驱动这个答案的问题是什么？

---

### [01:03:08] Lenny Rachitsky

**English:**
I love that. Do you actually still ask this question because you're sharing it in all the answers?

**中文翻译:**
我喜欢这个。既然你已经分享了答案，你现在还问这个问题吗？

---

### [01:03:13] Shishir Mehrotra

**English:**
No, I don't. And I have a new one that I can't share, but we've written about it. In fact, one of big debates about publishing the eigenquestions thing is, in order to bring this to life, I needed to answer your question, how do I test this? How do I practice this? And it is much easier, nobody can repeat the YouTube one. Nobody has that choice sitting in front of them. So it's kind of a useless, it's entertaining, but as a teaching tool, it's kind of useless because you can't really go reinvent history and decide consistent versus comprehensive.

**中文翻译:**
不，我不问了。我有一个新的，不能分享，但我们已经写过相关的文章了。事实上，关于发布“特征问题”文章的一个大争论是：为了让它生动起来，我需要回答你的问题——我该如何测试它？如何练习它？用虚构的例子更容易，因为没人能重复 YouTube 的那个案例，没人面临那个选择。所以 YouTube 的案例虽然有趣，但作为教学工具用处不大，因为你无法重塑历史去决定“一致性 vs 全面性”。

---

### [01:03:40] Lenny Rachitsky

**English:**
Yeah, had to sacrifice one.

**中文翻译:**
是的，总得牺牲一个案例。

---

### [01:03:42] Shishir Mehrotra

**English:**
We sacrifice one, yeah.

**中文翻译:**
我们牺牲了一个，是的。

---

### [01:03:44] Lenny Rachitsky

**English:**
So pull on that threat further and dive a little deeper into evaluating talent and product talent. I hear this is one of your superpowers and so I'd love to learn from you and what you've seen around how to evaluate talent. So you talked a little about interview questions you ask, so maybe we could either go in that direction or just what do you look for in people that you're hiring, interviewing that maybe other people aren't?

**中文翻译:**
那我们顺着这个思路，深入探讨一下如何评估人才，尤其是产品人才。我听说这是你的超能力之一，所以我很想向你学习你是如何评估人才的。你刚才提到了一些面试题，我们可以继续聊那个方向，或者聊聊你在招聘和面试时会看重哪些别人可能没注意到的特质？

---

### [01:04:05] Shishir Mehrotra

**English:**
I have a technique for it. I'll show a quick picture.

**中文翻译:**
我有一套技术。我展示一张简图。

---

### [01:04:09] Lenny Rachitsky

**English:**
YouTube plug?

**中文翻译:**
YouTube 广告位？

---

### [01:04:10] Shishir Mehrotra

**English:**
Yeah, YouTube plug. I mentioned it before the call, you can put video on Spotify now too, but the-

**中文翻译:**
是的，YouTube 广告。我之前提过，现在 Spotify 也可以放视频了，但是……

---

### [01:04:16] Lenny Rachitsky

**English:**
Spotify plug. All your platforms that you've worked on now can plug my videos.

**中文翻译:**
Spotify 广告。你工作过的所有平台现在都能给我的视频打广告了。

---

### [01:04:21] Shishir Mehrotra

**English:**
That's right. So I'll talk through this diagram that has two axes scope, this acronym, PSHE, and this line. So I'll stop sharing and describe it and we can come back to it. But I'll tell a little bit of this technique sort of changed how I think about evaluating not only product talent, but it actually turns out you can use the same set of rules for evaluating basically every role. But I'll tell it from how you asked it about product talent.

**中文翻译:**
没错。我会讲解这张图，它有两个轴：范围（Scope）和缩写词 PSHE，还有一条线。我停止分享并描述它。这套技术改变了我评估人才的方式，不仅是产品人才，事实上这套规则可以用于评估几乎所有角色。但我会根据你问的产品人才角度来讲。

---

### [01:04:44] Shishir Mehrotra

**English:**
So 2011, Larry Page took over at Google and he made a bunch of changes to the company, mostly quite positive. And one of the ones he did was he moved us from being a functional organization to being a business unit organization. We call them product units, but roughly the same thing. And there were eight product units set at Google, YouTube and Search and Ads and Chrome and Maps and so on. And that's very positive. It's hard to believe that we were already like 20,000 people were still functional, like all of engineering, all the products on reported into the CEO just seems like totally crazy with the breadth of products that we covered.

**中文翻译:**
2011 年，Larry Page 接管 Google，他做了一系列变动，大多非常积极。其中之一是将公司从职能型组织（Functional organization）转变为事业部型组织（Business unit organization）。我们称之为产品单元，意思差不多。Google 设立了八个产品单元：YouTube、搜索、广告、Chrome、地图等等。这非常积极。很难想象当时我们已经有 2 万人，却还是职能型的，所有的工程、产品都直接向 CEO 汇报，考虑到我们产品的广度，这简直疯了。

---

### [01:05:16] Shishir Mehrotra

**English:**
One of the downsides of it was, like in any functional to business unit switch, as you lose some of that what does the function mean. And in particular things like what is a good product manager was a question we were at risk of losing. So at the time I was running product for YouTube, the group of the eight product leaders around the company got together and said, "Hey, we need to keep some level of consistency amongst how we think about what's a great product manager or it's all going to diverge and it's not going to mean anything anymore."

**中文翻译:**
但缺点是，就像任何从职能型到事业部型的转变一样，你会失去一些对“职能”含义的统一理解。特别是“什么是优秀的产品经理”这个问题，我们面临失去统一标准的风险。当时我负责 YouTube 的产品，全公司的八位产品负责人聚在一起说：“嘿，我们需要在‘什么是优秀的产品经理’的认知上保持一致，否则标准会分化，这个头衔就没意义了。”

---

### [01:06:08] Shishir Mehrotra

**English:**
Actually, as a fun aside, we did a ritual that I've repeated a few times, but it isn't done often enough is, we said, "So who's going to drive this process?" And we did it in an election. I don't know why we do elections in the public world, but not in the private world, but it's actually quite effective. We used to do them on YouTube where we would elect into certain roles and you got a one-year term, you gave a little speech you like [inaudible 01:06:08]. We did an election. Anyway, so I got chosen to be the first sort of leader of this challenge, keeping the product management function together at Google. And the most obvious job we had to do was come up with a speech for the Calibration Committee.

**中文翻译:**
顺便说个趣事，我们举行了一个仪式，我后来重复过几次，但做得还不够多：我们问“谁来推动这个过程？”，然后我们进行了选举。我不知道为什么我们在公共世界选举，在私人公司却不选，但它其实很有效。我们在 YouTube 也会选举某些角色，任期一年，你要发表竞选演说。总之，我被选为应对这个挑战的第一任领导者，负责维系 Google 的产品管理职能。我们最明显的任务是为“定级委员会”（Calibration Committee）准备一份演讲稿。

---

### [01:06:32] Shishir Mehrotra

**English:**
So Google does calibration a little bit different or promotion a little bit different than most companies. Most companies your boss decides you get promoted or not. At Google, there's a committee that decides, and it's supposed to be a committee that doesn't actually work directly with the person, so it can be a little unbiased and so on. And it gets done. The ritual was to do it in a hotel near the airport here in San Francisco and everybody get in these different rooms. And there was always a speech given at the beginning that used to be given by Jonathan Rosenberg who ran product for Google for many years. And now it had to be given by somebody. So I'm going to give this speech, now I've got to figure out what the hell am I going to say, what's a good product manager.

**中文翻译:**
Google 的定级或晋升机制与大多数公司不同。大多数公司是老板决定你是否晋升，而在 Google，是由一个委员会决定的，而且这个委员会成员通常不直接与候选人共事，以保持公正。这个仪式的传统是在旧金山机场附近的一家酒店举行，大家分在不同的房间。开始时总会有一段演讲，以前是由领导 Google 产品多年的 Jonathan Rosenberg 讲的，现在得由别人来讲。所以我要去做这个演讲，我得想清楚我到底要说什么，到底什么是优秀的产品经理。

---

### [01:07:02] Shishir Mehrotra

**English:**
And as I was going through this, I decided to run this little exercise. So this group of eight product leaders, we took the level guides, we had a level guide for product managers, every company does, and we took it, we printed out a sheet of paper, cut it into little slices, one per level, and we cut off the title and the number and I handed them out and I said, "Can you reverse identify what level you're holding?" Then turns out nobody could do it. And it's not easy to do. The level guide had been kind of added to over time and not really that refined. And so it would say things like, this person can manage a medium-sized project and they interview at least three people a week and they always send the notes out on time and their expense reports are always filed. And it'd be like, oh, that's a director. And it's just whatever we were trying to incent was sort of stuck in this thing.

**中文翻译:**
在准备过程中，我决定做一个小练习。我们这八位产品负责人拿来了职级指南（Level guides），每家公司都有。我们打印出来，剪成小纸条，每一级一条，剪掉职级名称和数字，然后发给大家说：“你们能反向识别出你手里拿的是哪一级吗？”结果没人能做到。这确实不容易。职级指南是随着时间推移不断添加的，并不精炼。它会写：“此人能管理中型项目，每周至少面试三个人，总是按时发送会议纪要，报销单总是及时提交。”然后大家猜：“噢，这一定是总监。”这只是把我们当时想激励的所有事情都塞了进去。

---

### [01:08:12] Shishir Mehrotra

**English:**
But we noticed that if you took all these sheets of paper and laid them out side by side, you could order them by exactly one statement, which was one that corresponded to scope. And so there's some word in there that was an escalating adjective that mostly correlated to how big is the thing you run. And so we decided, okay, well we're going to standardize. We're just going to focus on making that clear. And so we said we're going to define scope and so that we all use it the same way. And we came up with some stopping points and basically said, you own a feature, you own a group of features, you own a sub area of a product. You own multiple sub areas of product, you own an entire product, or you own multiple products, you own a product line. And that's going to be how we think about scope, go forth and evaluate your teams.

**中文翻译:**
但我们注意到，如果你把所有纸条并排摆放，你可以根据唯一一个陈述来排序，那就是关于“范围”（Scope）的描述。里面会有一些递进的形容词，主要与你负责的事物规模有关。于是我们决定：好，我们要标准化，重点把这个讲清楚。我们定义了 Scope，让大家统一使用。我们设定了一些节点：你负责一个功能，你负责一组功能，你负责产品的一个子领域，你负责多个子领域，你负责整个产品，或者你负责多个产品/产品线。这就是我们对 Scope 的定义，去评估你们的团队吧。

---

### [01:09:00] Shishir Mehrotra

**English:**
We had the next meeting a couple weeks later and everybody comes back upset. It's like, this didn't work at all. Why? What happened? And said, "Well, the search team is super mad at the ads team because search is one product, the entire thing is one product. The ads team, they went and invented all these products, because it's like every little thing you do in the ads platform has a SKU, has a P&L, has a... Because you have lots of products, so [inaudible 01:09:11] worked. The second issue was they said the scope is actually an input, not an output. We're talking to our manager and said, "Well, this person should get promoted. They've managed this huge scope." And then they would say, "But you gave them that scope. We should be judging you, not the person. How do we judge what they're doing with the scope?" It's actually very different.

**中文翻译:**
两周后开会，大家都垂头丧气地回来了。标准根本行不通。为什么？发生了什么？他们说：“搜索团队对广告团队非常生气，因为搜索就是一个产品，整个就是一个。而广告团队发明了无数个‘产品’，因为广告平台里的每个小功能都有 SKU、有损益表……因为产品多，所以晋升快。第二个问题是，他们说 Scope 实际上是‘投入’而非‘产出’。我们跟经理说：‘这个人应该晋升，他管理了这么大的范围。’经理会说：‘但那个范围是你给他的啊。我们应该评判你，而不是他。我们该如何评判他在这个范围内做了什么？’这完全是两码事。”

---

### [01:09:52] Shishir Mehrotra

**English:**
And the third issue was in almost every team, some of our best people were working on things with odd scope. They were risky projects. We didn't yet know is this thing going to work or not work, is Mike canceled. And if we put in place a system that only rewarded scope, we would heavily disincent people from working on these riskier, more creative things. So we were stuck. And then we ended up settling on this one called PSHE, and it comes from old mentor of mine, Quentin Clark, who's my boss at Microsoft for a number of years. And it stands for Problem, Solution, How, Execution, PSHE. And I will say it's a... I've tried many times to come up with a better acronym and I have not been able to come up with one. So it's push. That's the word. That's as good as I can get. But here's how... It works good enough. So push, that's all you have to remember. It doesn't roll off the tongue, but maybe... I did better with [inaudible 01:10:28] questions I think, but...

**中文翻译:**
第三个问题是，几乎每个团队中，一些最优秀的人都在负责“范围奇特”的项目。那是风险项目，我们还不知道能不能成。如果我们建立一个只奖励 Scope 的系统，就会严重打击人们去尝试这些高风险、高创意项目的积极性。所以我们卡住了。最后我们采用了 PSHE 框架，这来自我的导师 Quentin Clark（他在微软当了我多年的老板）。PSHE 代表：问题（Problem）、方案（Solution）、方法（How）、执行（Execution）。我试过很多次想找个更好的缩写，但没成功。所以就叫“Push”吧，这是我能想到的最好的了。它虽然不怎么朗朗上口，但足够好用。

---

### [01:11:03] Shishir Mehrotra

**English:**
So here's how it works. So if you're a junior product manager, what happens? You get handed a problem. You get handed a solution. You get handed the how. "Go talk to this person. Write this document. Run this meeting," so on. And all you have to do is execute, run that playbook, and that's all we expect out of you. You can become a little more senior. We hand you a problem. We hand you a rough solution. You figure out the how. You figure out the, "How are we going to organize this? What are the milestones? How are we going to get it to market? How are we going to do the meetings? What are the rituals?" All those things show up in the H.

**中文翻译:**
它是这样运作的：如果你是一个初级 PM，会发生什么？别人交给你一个问题，交给你一个方案，交给你方法（“去跟这个人谈，写这个文档，开这个会”等等）。你只需要执行，按照剧本走，这就是我们对你的全部期望。当你变得资深一点，我们交给你一个问题，交给你一个粗略的方案，你来搞定“方法”（How）：我们如何组织？里程碑是什么？如何推向市场？如何开会？仪式感是什么？这些都属于 H。

---

### [01:11:27] Shishir Mehrotra

**English:**
At some point you become a little more senior. We hand you a problem and you come back with the solutions. You come up and we judge you on the creativity and the effectiveness of the solutions. And at some point you're senior enough that you tell us the problems and you say, "Hey. I know you told me to go work on activation, but actually I think our issue is brand," or, "I think our issue is quality," or, "I think our issue is..." whatever it might be. And that's the pinnacle of this way of thinking about it.

**中文翻译:**
再资深一点，我们交给你一个问题，你带着方案回来。我们根据方案的创意和有效性来评判你。最后，当你足够资深时，是你来告诉我们问题是什么。你会说：“嘿，我知道你让我去负责激活，但其实我觉得我们的问题出在品牌上，”或者“我觉得问题在质量上”。这就是这种思维方式的巅峰。

---

### [01:12:14] Shishir Mehrotra

**English:**
Now just back to this picture for a moment, one of the interesting things that happened was that the teams went and they evaluated their teams on these two axes and they end up with this curved line between them. It's not linear as you work your way through. And what happens is early in people's career, they mostly sit at that E point. You get handed a problem and handed a solution, handed a how and you just execute, and they gradually grow in scope. Later in people's careers, similarly, you're at that P level. You just do bigger and bigger products. And the job of being an entrepreneur or CEO or an owner or so on is just do bigger and bigger projects. But in the middle, the slope changes and all of a sudden, it's not really about scope. It's about PSHE. And there's a circle drawing in here for what I like to call the trough of dissolution.

**中文翻译:**
回到那张图，有趣的是，当团队在这两个轴上评估成员时，会得到一条曲线。它不是线性的。在职业生涯早期，人们大多处于 E 点：被交给问题、方案和方法，然后执行，Scope 逐渐扩大。在职业生涯后期，你处于 P 级：负责越来越大的产品。企业家、CEO 或负责人的工作就是做越来越大的项目。但在中间阶段，斜率改变了，突然间，重点不再是 Scope，而是 PSHE。图中画了一个圈，我称之为“幻灭的低谷”（Trough of dissolution）。

---

### [01:12:56] Shishir Mehrotra

**English:**
And the reason... I'll stop sharing so we can talk about it, but what happens in that phase, and I was talking to the calibration committees about this, the reason we call it the trough of dissolution meant is for the employee, for the person, this is a confusing time. Everything about leading up to this moment from high school and college has been about scope. And at this point you're all of a sudden told, "We're not judging you on scope anymore. We're judging you on this PSHE thing that's very confusing." To the calibrator or to the manager, it's also very confusing because all of a sudden, the difference... The way I would put it is the difference between a level three and a level seven may not be scope. They may do the exact same job. It's how they do the job that matters and here's some language for how they do the job.

**中文翻译:**
我停止分享来聊聊这个。在那个阶段（我也跟定级委员会聊过），之所以叫它“幻灭的低谷”，是因为对员工个人来说，这是一个困惑期。从高中到大学，再到职业生涯初期，一切都关乎 Scope（规模）。但到了这个点，你突然被告知：“我们不再根据 Scope 评判你了，我们要根据这个令人困惑的 PSHE 来评判你。”对于评定者或经理来说，这也很困惑，因为突然间，3 级和 7 级的区别可能不在于 Scope。他们可能做着完全相同的工作，区别在于他们“如何”做这份工作，而 PSHE 为这种“如何做”提供了语言描述。

---

### [01:13:45] Shishir Mehrotra

**English:**
And so PSHE became a very sticky way of thinking about it. It turns out that this way of evaluating people is actually not that specific to product management. It's really easy to see why you do the exact same thing for engineers and designers and so on, but to pick one that may not be as obvious, I'll pick salespeople. A very common thing people do with salespeople is they evaluate them based on quota attainment. It's the easiest thing to do is take the salespeople and rank them by who hit their quota and who didn't. You go ask the sales team who's the best salesperson, and what you'll realize is they'll say quota attainment is just a signal for how good you negotiated your quota and picked the right territory. Really, you want to know who's a best salesperson, they say, "Well, so and so, I mean she can sell anything and she can be in the region that's growing or the region that's shrinking or the new product or the old product or..."

**中文翻译:**
所以 PSHE 变成了一种非常有生命力的思维方式。事实证明，这种评估人的方式并不局限于产品管理。工程师、设计师也是如此。举个不那么明显的例子：销售人员。人们通常根据“业绩指标达成率”来评估销售，这最简单。但如果你问销售团队谁才是最顶尖的销售，你会发现他们说：“指标达成率只能说明你多会谈指标、多会挑地盘。真正厉害的销售，是那种能卖掉任何东西的人，无论是在增长还是萎缩的地区，无论是新产品还是旧产品……”

---

### [01:14:06] Shishir Mehrotra

**English:**
And if you think about that terminology, it's very similar to PSHE thinking. This is the person who can come into a new space, identify the right problems and solve them. That's what makes a really great salesperson. So it could become my framework for evaluating talent in all sorts of ways. And you might recognize a pattern of being a great P thinker is very correlated with being good with [inaudible 01:14:06] questions. Can you spot the right problems? It's very similar to can you spot the right questions? Can you decide what's important? And so that's been my main framework for value.

**中文翻译:**
如果你思考这种表述，它与 PSHE 思维非常相似：这个人能进入一个新领域，识别出正确的问题并解决它们。这才是伟大的销售。所以这成了我评估各种人才的核心框架。你可能会发现，成为一个优秀的 P（问题）思考者，与擅长提出“特征问题”高度相关。你能发现正确的问题吗？这与你能发现正确的（特征）问题、能决定什么是重要的非常相似。这就是我的主要价值评估框架。

---

### [01:14:15] Lenny Rachitsky

**English:**
Wow. There's so much there. A couple quick questions. Is this basically your calibration ladder framework for PMs at this point? And then is this also just like your interview guide, just interview at each of these pieces to level the person?

**中文翻译:**
哇。信息量太大了。有两个小问题：这基本上就是你目前对 PM 的定级阶梯框架吗？另外，这是否也是你的面试指南——通过面试这些环节来给候选人定级？

---

### [01:14:29] Shishir Mehrotra

**English:**
Yeah. So it's definitely how we do. Our version of leveling is PSHE, and we use a set of Radford levels. Radford has this really interesting way of describing that as you grow in a profession... He uses the analogy of someone, of a sailor and that a junior sailor is learning to tie knots and then you gradually can tie all the standard knots and then you can tie the advanced knots and so on, and so you work your way up and at some point the way you're judged is you invented nylon and there's list between there. It's like a way to evaluate every role. It's very similar to PSHE. And so we look at a similar list. But yeah, basically all of our roles are evaluated on something that corresponds with PSHE.

**中文翻译:**
是的，我们确实是这么做的。我们的定级版本就是 PSHE，并结合了 Radford 职级。Radford 有一种很有趣的描述职业成长的方式：他用海员做类比，初级海员学习打结，然后逐渐学会打所有标准结，再到高级结，以此类推。当你升到一定高度，评判你的标准是你发明了尼龙绳。这是一种评估所有角色的方式，与 PSHE 非常相似。所以我们基本上所有的角色都是根据与 PSHE 对应的标准来评估的。

---

### [01:15:17] Shishir Mehrotra

**English:**
And in terms of interviews, yeah, you look for the same thing. And by the way, I should say interviewing is one part of this. And you talk about interviewing. You talk about calibration. There's one other really important one which is reference checking. And I think the best way to assess PSHE is actually through references. And so the most important guide we write isn't the interview guide. When we call this person's references, what do you ask to actually get at these questions? Because people can often confuse them.

**中文翻译:**
至于面试，是的，我们也看这些。顺便说一下，面试只是其中的一部分。你谈到了面试和定级，但还有一个非常重要的环节：背景调查（Reference checking）。我认为评估 PSHE 最好的方式其实是通过背景调查。所以我们写的最重要的指南不是面试指南，而是：当我们给候选人的证明人打电话时，该问什么才能真正触及这些核心？因为人们经常会混淆这些特质。

---

### [01:15:46] Shishir Mehrotra

**English:**
Just to pick product managers as an example. We all know some really amazing H level product managers. And one of the rules, one of the hallmarks, of an H level product manager is that their counterparts usually love them and they'll say things like, "Oh, my gosh. The person runs such efficient meetings and all the communication is always clear. [inaudible 01:16:07] always buttoned up. Execs know what we're doing. The market knows what we're doing. Sales team know what we're doing." That's great H. And then you'll ask them a question about, "Okay. So when you're deciding which problem to solve, who is the leader of that? And are they picking the right problems? Or when there's a hard problem, who is regularly coming up with the best solutions for them? Who do you turn to? Who is the most obvious person to turn to say, 'This is really hard problem. What's the right solution?'?"

**中文翻译:**
以产品经理为例。我们都认识一些非常出色的“H 级”（方法级）PM。H 级 PM 的标志是：他们的合作伙伴通常非常喜欢他们，会说：“天哪，这个人开会效率极高，沟通清晰，一切都井井有条。高层知道我们在做什么，市场知道我们在做什么，销售团队也知道。”这就是优秀的 H。但接着你会问证明人：“好，那么在决定解决哪个问题时，谁是领导者？他们选对问题了吗？或者当遇到难题时，谁经常能拿出最好的方案？你会找谁？谁是那个最明显的‘遇到难题找他准没错’的人？”

---

### [01:16:31] Shishir Mehrotra

**English:**
An amazing number of people will tell you, "No, they run a great meeting but actually solving the problem, designer does that," or, "What are the problems? No. The CEO tells us what to do. That's not what this person's really good at. Yeah. I'm not sure we're solving the right problem, but boy, we run a great meeting." And it's not meant to diminish any of that. I mean, we spent a while talking about rituals, which mostly happen at that H level, so I don't think it's unimportant, but it's actually quite hard to assess in an interview but incredibly easy to assess in a reference check. And I think getting good at that is really important.

**中文翻译:**
令人惊讶的是，很多人会告诉你：“不，他们会议开得很好，但解决问题其实是设计师做的，”或者“问题是什么？不，那是 CEO 告诉我们该做什么。那不是这个人的强项。我不确定我们是否在解决正确的问题，但天哪，我们的会议开得真棒。”这并不是要贬低 H。我们刚才聊了很久仪式感，那大多发生在 H 层面，所以它并非不重要。只是这在面试中很难评估，但在背景调查中却极其容易。我认为擅长这一点非常重要。

---

### [01:17:01] Lenny Rachitsky

**English:**
You may have mentioned this, but what's the question there? Is there a question that you could recommend?

**中文翻译:**
你可能提到过，但具体的提问方式是什么？有没有你可以推荐的问题？

---

### [01:17:05] Shishir Mehrotra

**English:**
The absolute ideal case is you get to the person that you're doing the reference check with and you don't even tell them who you're asking about and you just say, "When you think of your teams, who is best at..." And this obviously only works in cases where you have a pretty deep relationship with the person you're getting referenced from and so on. So you can't always do that. But ideally you want to mimic that behavior. One of the things I think that's hard about reference checks is people have... They have perverse incentives in a reference check. They're not really... Some of it is for good reason. Some of it is for bad reason. People generally don't like criticizing people and they also feel judged themselves and they don't want... There's legal reasons that things can blow back and so on.

**中文翻译:**
最理想的情况是，你找到证明人，甚至不告诉他你在问谁，直接问：“在你的团队中，谁最擅长……”这显然只适用于你与证明人关系非常深厚的情况。所以你不能总是这么做。但理想情况下，你想模拟这种行为。背景调查的一个难点是人们有“反向激励”：他们不一定说真话。部分是出于好意，部分不是。人们通常不喜欢批评别人，他们也觉得自己被评判，而且还有法律风险等等。

---

### [01:17:55] Shishir Mehrotra

**English:**
And so what I try really hard to do is to draw contrasts. So you try to say things... There's a couple of techniques I've used for this. In the best case you say, "I'm not going to even tell you who I'm asking about, but when you think about this team who regularly identifies what problems they should focus on? Who is most reliable at coming up with the solutions to the hardest problems?" And you work your way through it. The other way I like to do it is to provide contrast to give the person an out to not make it obvious to them that I have this ranking. And so I'll say things like, "When you think about this person, and I'll give you four different personas. Someone who's regularly coming up with the problems that the team should be focused on. Someone who given a set of problems is constantly solving them in this really creative way. The person that is just really good at getting a team moving. Or the person who can take a playbook and execute it with high precision and high quality and stuff."

**中文翻译:**
所以我努力尝试的是“引入对比”。我用过几种技巧。最好的情况是：“我甚至不告诉你我在问谁，但当你想到这个团队时，谁经常能识别出团队应该关注的问题？谁在为最难的问题提供方案时最可靠？”另一种方式是提供对比，给证明人一个台阶，不让他们觉得我有某种高低排序。我会说：“当你想到这个人时，我给你四个不同的角色描述：一个经常提出团队应关注问题的人；一个在给定问题下总能以创意方式解决问题的人；一个非常擅长推动团队行动的人；或者一个能拿着剧本高精度、高质量执行的人。”

---

### [01:18:47] Shishir Mehrotra

**English:**
And I won't tell them that I have a qualitative judgment that one is better than the other, but you want them... Because you just want your reference check to talk and you want them to say what's on their mind of... You want to give them an opening to not feel like they're judging. Obviously, another question I always ask people is, "Would you hire this person again? Or how excitedly would you hire this person again?" I always ask them, "What questions should I have asked that I didn't?" Another key technique for reference checks is you just need people to... Once they start talking, they'll reveal what they really feel and often the little things will come out. But for this particular thing, if I want to know where they stand on this axis, don't tell people what you value. By the way, I will say I value P over S over H over E. I've seen many companies that would reverse that scale. And by the way, there's industries where it's very required. You don't want a bunch of people running around and constantly telling you to solve some different problem. I just need people that can do this job that we give them super, super well. And it depends a bit what your personality is and what your company's culture is and so on. So it's not actually that unbelievable that I might value the E over the P. Anybody who knows me, that's probably not true, but for a reference check, you can probably not give that away.

**中文翻译:**
我不会告诉他们我心中有优劣之分。你只是想让证明人开口，说出他们的真实想法。你要给他们一个开口的机会，让他们不觉得自己在做道德评判。当然，我必问的问题还有：“你会再次雇佣这个人吗？你再次雇佣他的兴奋程度如何？”我还会问：“还有哪些我该问但没问的问题？”背景调查的另一个关键技巧是让人们开口，一旦他们开始说，就会透露真实感受，小细节就会浮出水面。但针对 PSHE，如果你想知道他们在轴上的位置，千万不要告诉对方你更看重什么。顺便说一下，我个人认为 P > S > H > E，但我见过很多公司会反过来。在某些行业，这是必须的：你不需要一群人跑来跑去告诉你去解决别的问题，你只需要有人能把交给他们的工作做得超级好。这取决于你的性格和公司文化。所以，如果有人更看重 E 而非 P，这并不奇怪。了解我的人知道我不是那样，但在背景调查时，你最好别泄露你的偏好。

---

### [01:20:04] Lenny Rachitsky

**English:**
Wow. That was gold. I hadn't heard these reference check insights. And so I'm really happy we got to that. Maybe one last question on reference checks. How often do you find that a reference check leads to you not hiring someone, just ballpark? Or is that hard to say?

**中文翻译:**
哇。这太宝贵了。我以前没听过这些关于背景调查的见解。很高兴我们聊到了这个。关于背调最后一个问题：你发现背调导致最终不录用一个人的频率大概是多少？或者这很难说？

---

### [01:20:19] Shishir Mehrotra

**English:**
All the time. And I will say I try to do them as early in the process as practical if it's possible. Because I think it's actually the worst feeling for an interviewee to go through a process and then get dinged at the reference check stage. It's a really crappy experience for the candidate. And obviously you have to be careful about not ruining anything for them. You can't always do the reference check as early as you can. When you're inside a company, when you're inside Google or Facebook or so on, you can generally do them even before you enter. It's an expectation of we're going to hear a little bit about people in that process. And I generally value the reference check over interview signals. If I had to stack rank in interviews what is the best signal, the reference check is the top of the list. Those people, they worked with this person sometimes for years, their knowledge, what you're going to get out of 30 minutes of artificial scenarios, it's just never going to compare with what a good reference check will give you.

**中文翻译:**
经常发生。而且我会说，只要可行，我尽量在流程早期就做背调。因为我认为对面试者来说，走完所有流程最后在背调阶段被刷掉，感觉是最糟糕的。这对候选人来说体验很差。当然，你得小心不要搞砸他们现状。你并不总能尽早做背调。但如果你在公司内部（比如在 Google 或 Facebook 内部转岗），你通常可以在面试前就做。我通常认为背调的价值高于面试信号。如果要给面试信号排个序，背调绝对是第一。那些人曾与候选人共事多年，他们的了解程度，绝非你在 30 分钟的人为设定场景面试中能得到的。

---

### [01:21:12] Shishir Mehrotra

**English:**
And then the second best thing I value is anything that feels like a real work exercise, which is also... Even that is hard because some people, their skillset doesn't naturally lead to a compressed time work exercise. But we do a thing for basically all our roles where at the start of the interview loop, the candidate presents to everyone on the loop and we invite some other people in the company to attend too. For a while it was open the whole company. Now we're big enough where that's not practical. But the original is very simple. At the beginning of the loop, the person presents. And generally for most roles, there's a exercise that they do, but about half the time is spent on them presenting whatever they want. They can talk about themselves. They can teach us something and then another half is we've given them a prompt, something that we want to direct.

**中文翻译:**
我第二看重的是任何感觉像“实际工作练习”的东西。虽然这也很难，因为有些人的技能不适合在压缩的时间内展示。但我们对几乎所有角色都会做一件事：在面试环节开始时，候选人要向面试小组的所有人做演示，我们还会邀请公司其他成员参加。有一段时间是向全公司开放的，现在公司大了，这不太现实。但初衷很简单：在面试开始时，候选人做演示。通常会有一个练习，但大约一半的时间由他们自由发挥：可以谈论自己，可以教我们一些东西；另一半时间是我们给出的特定题目。

---

### [01:21:58] Shishir Mehrotra

**English:**
One of the things that I think when you're doing interviewing, one way to think about it, I call it home court, away court, neutral court, you want interviews to balance in all those different spheres. So a common mistake people make is they do all questions in home court. "Hey. If you're joining Airbnb, what would you do about X?" And what is the candidate going to say? They clearly can't be as thoughtful as you. They haven't thought about it nearly as much as you have. So really what you're testing is, "Did they come to the same answer that we did?" which is a pretty crappy way to judge someone. Home court questions tend to be tough. You have to be very careful about how you do them. Away court questions can also be tough. This person, you say, "How did you solve this problem?" And they say, "Well, we did this thing." And you don't really know was that problem actually hard? Was it somebody else was telling them what to do? Are they just not telling you the whole story of what happened and so on?

**中文翻译:**
在面试时，我有一种思考方式，我称之为“主场、客场、中立场”。你希望面试在这些领域达到平衡。人们常犯的一个错误是所有问题都在“主场”：比如“如果你加入 Airbnb，你会怎么处理 X？”候选人能说什么？他们显然没你考虑得周全，也没你思考的时间长。所以你实际上是在测试“他们是否得出了和我们一样的答案”，这是一种很烂的评判方式。主场问题很难把握。而“客场”问题也可能很难：你问“你是如何解决这个问题的？”，他们说“我们做了这个”。你其实不知道那个问题到底难不难，是不是别人告诉他们怎么做的，或者他们是不是没告诉你全貌。

---

### [01:22:50] Shishir Mehrotra

**English:**
So you try really hard to make... Most of our interviews are done neutral court. So the vast majority [inaudible 01:22:54] teleporter question is a very neutral question. You don't have to know anything about Coda. I don't have to know anything about Airbnb or wherever. I can just ask you this question. But this one thing, the presentation is the away court question. You now have an opportunity to talk about yourself in this new way. And it's super interesting what people do. I mean, I've seen people use that time... I often tell people it's the brag session, but this is like... And for product managers... We do it for every role, but it's like recruiters, salespeople, marketers.

**中文翻译:**
所以我们努力让大多数面试在“中立场”进行。比如那个“瞬间移动装置”的问题就是一个非常中立的问题。你不需要了解 Coda，我也不需要了解 Airbnb，我可以直接问。但那个“演示环节”就是“客场”问题：你现在有机会以一种全新的方式谈论你自己。人们的表现非常有趣。我常告诉候选人这是“吹牛环节”，但其实……我们对每个角色都这么做，包括招聘人员、销售、市场人员。

---

### [01:23:23] Shishir Mehrotra

**English:**
We tell them, "We're going to go through this whole interview process. And at most companies you talk to six different people and six little segments. And at the end of the day you say, 'Gosh. I really wish they had learned this about me.'" And I tell them, "Don't leave this with that feeling. What do you want us to know about you? All our questions are... In some cases we're trying to lower bound you, like, 'How bad could this be?' I want you to upper bound us. I want you to tell us what's really amazing here." And so we'll have the presenter go through that process. And what they choose to talk about is very important. How they choose to present it is very important. But I do it as upper bounding. But if I had to stack rank in interviewing, what do I look for? Reference check at the top, work, product and presentation next, and then all the interviews. When they disagree, that's the order we judge.

**中文翻译:**
我们告诉他们：“我们要进行整个面试流程。在大多数公司，你会和六个不同的人谈六个小片段。到头来你会想：‘天哪，我真希望他们了解我的这一面。’”我告诉他们：“别带着那种遗憾离开。你想让我们了解你什么？我们的所有问题在某种程度上都是在测试你的‘下限’（Lower bound），比如‘这人最差能有多差？’。我希望你向我们展示你的‘上限’（Upper bound），告诉我你真正厉害的地方。”所以我们会让候选人进行演示。他们选择谈论什么、如何呈现都非常重要。我把它看作是上限测试。如果非要给面试信号排个序：背调第一，实际工作产出和演示第二，最后才是所有的面试。当信号不一致时，我们按这个顺序来判断。

---

### [01:24:12] Lenny Rachitsky

**English:**
Shishir, I feel like you have five books in you that you need to write on so many of these topics. This is such good stuff. I wish I could keep going. I know you have to run. So we have this final lightning round. So I'm going to ask you five questions. There's one at the end I didn't tell you about ahead of time, so it's going to be a surprise. And so I'm just going to ask you these quick questions. Let me know what comes to mind. Okay. First question, just what are two, three books that you find that you recommend most to other people? Oh, pulling out the bookshelf.

**中文翻译:**
Shishir，我觉得你肚子里至少有五本书要写。这些内容太棒了。我真希望能继续聊下去，但我知道你得走了。所以我们进入最后的“闪电轮”环节。我会问你五个问题，最后一个我没提前告诉你，是个惊喜。我会快速提问，你告诉我想到了什么。好，第一个问题：你最常向别人推荐的两三本书是什么？噢，你把书架都搬出来了。

---

### [01:24:40] Shishir Mehrotra

**English:**
Pull up [inaudible 01:24:40]. One I already said and we talked about. So this would take two of the slots. The next one on my list is Switch by Chip and Dan Heath, How to Change Things When Change Is Hard. The other one, this is probably a surprising one, it's called Understanding Comics by Scott McCloud.

**中文翻译:**
我拿几本。一本我已经说过了，就是《瞬变》（Switch），它占两个名额。下一本是 Scott McCloud 的《理解漫画》（Understanding Comics），这本可能让人意外。

---

### [01:24:53] Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:24:54] Shishir Mehrotra

**English:**
Super fun book. It's a comic book about comic books and you don't have to like comic books at all to love this book. It's basically... The starting point is over time communication has drifted at two extremes. So one is we've gotten very good at written form and the other is we've gotten very good at art, single pieces of art. And comics are the hybrid. They are drawing mixed with writing. Sometimes I think he calls it... Oh, God. He had a good term for it that I'm now forgetting, but he describes comics really well and he goes through the actual reasoning of why comics are structured the way they are. And one of the reasons it's so important to me is, and you could probably tell from how we talked about different things, is often a diagram that crystallizes something. The art of storytelling, diagramming, so on, I think is so critical for basically any part of life. And this book, it's so thought-provoking on how to do it. Understanding Comics by Scott McCloud.

**中文翻译:**
超级有趣的一本书。这是一本关于漫画的漫画书，你完全不需要喜欢漫画也会爱上它。它的出发点是：随着时间的推移，沟通走向了两个极端——一个是极其发达的文字形式，另一个是极其发达的艺术（单幅艺术）。而漫画是两者的混合体，是绘画与文字的结合。他很好地描述了漫画，并解释了漫画结构背后的逻辑。它对我如此重要的原因之一（你可能从我们刚才的谈话中也能看出来）是，一个图表往往能让事物变得清晰。讲故事的艺术、绘图的艺术等等，我认为对生活的任何部分都至关重要。这本书在“如何做”方面非常有启发性。

---

### [01:25:48] Lenny Rachitsky

**English:**
Understanding Comics. Wow. Good choice. Okay. Favorite recent movie or TV show?

**中文翻译:**
《理解漫画》，哇，好选择。好，最近最喜欢的电影或电视节目？

---

### [01:25:52] Shishir Mehrotra

**English:**
Okay. Couple that come to mind. Only Murders in the Building is a really fun one. And my family got really into the Marvel series during the pandemic. And so WandaVision, if anybody hasn't seen that. If you're not into superhero stuff and so on, which I'm not really that... I'm actually more of a DC comics person. I like Superman. But WandaVision is one of the best pieces of art that I've seen done in a very long time. Very well done show.

**中文翻译:**
好，想到几个。《大楼里的谋杀案》（Only Murders in the Building）非常有趣。大流行期间我们全家都迷上了漫威系列，所以是《旺达幻视》（WandaVision）。如果你不喜欢超级英雄题材（其实我也不太感冒，我更喜欢 DC 的超人），但《旺达幻视》是我很久以来见过的最棒的艺术作品之一，制作非常精良。

---

### [01:26:19] Lenny Rachitsky

**English:**
I feel with that show I had to... I gave up initially. I'm like, "What the hell is this? What is going on?"

**中文翻译:**
那部剧我一开始差点放弃了，我想：“这到底是什么鬼？发生了什么？”

---

### [01:26:19] Shishir Mehrotra

**English:**
I know.

**中文翻译:**
我知道。

---

### [01:26:23] Lenny Rachitsky

**English:**
And then it gets good.

**中文翻译:**
然后它就开始变精彩了。

---

### [01:26:24] Shishir Mehrotra

**English:**
It gets good. Yeah.

**中文翻译:**
是的，渐入佳境。

---

### [01:26:25] Lenny Rachitsky

**English:**
And on the flip side, Only Murders in the Building. I don't know if you've seen the second season yet, but I'm just like... I'm done with it. I'm just tired of it now. I don't know what they're doing.

**中文翻译:**
反过来说，《大楼里的谋杀案》，我不知道你看了第二季没，但我已经……我受够了，现在觉得有点腻了，不知道他们在搞什么。

---

### [01:26:33] Shishir Mehrotra

**English:**
Oh, yeah? We're only one episode into the second season, so we'll see. Maybe we'll give up too.

**中文翻译:**
噢，是吗？我们第二季才看了一集，走着瞧吧，也许我们也会放弃。

---

### [01:26:33] Lenny Rachitsky

**English:**
Good luck. Okay.

**中文翻译:**
祝你好运。好。

---

### [01:26:40] Shishir Mehrotra

**English:**
The preseason was so good. [inaudible 01:26:43]. And it's all about podcasters.

**中文翻译:**
第一季太棒了，而且它讲的都是关于播客主的事。

---

### [01:26:45] Lenny Rachitsky

**English:**
It's like so meta around podcasters. Oh, man. Okay. Good segue. Okay. Favorite interview question/ you may have already answered this.

**中文翻译:**
对播客主来说太“元”了。好，过渡得不错。最喜欢的面试题？你可能已经回答过了。

---

### [01:26:53] Shishir Mehrotra

**English:**
The teleporter one is definitely my favorite. My second favorite one, if I was going to give you a different one, is I have a series of questions around... Let me pull it here so I give you what the real question is, but is basically around a dashboard prompt. And the starting point of the question is, "Pick a product." I [inaudible 01:27:15] say, "Your favorite technical product." And the constraint is, "It can't be something that you built, worked on or competed with. It's got to be in the space that you're not an expert in." And I generally ask people why, which is actually a really interesting passion test. And then I'll ask people, "Design the one- page dashboard for that product. If you're the CEO, general manager, whatever, you run that product, what's on the dashboard? Why?" It's an interesting [inaudible 01:27:39] question, E type question of like, "Can you tell what's important for this product or not?"

**中文翻译:**
“瞬间移动装置”那个绝对是我的最爱。如果非要说第二个，我有一系列关于“仪表盘”的问题。问题的起点是：“选一个产品”，通常是“你最喜欢的科技产品”。限制条件是：“不能是你参与构建、工作过或竞争过的产品，必须是你非专家领域的空间。”我通常会问为什么，这其实是一个很有趣的热情测试。然后我会问：“为那个产品设计一个单页仪表盘。如果你是 CEO 或总经理，你管理那个产品，仪表盘上会有什么？为什么？”这是一个有趣的特征问题，也是一种 E 型（执行/判断）问题，看你能不能判断出对这个产品来说什么是重要的。

---

### [01:27:43] Shishir Mehrotra

**English:**
And then I ask them to basically redesign the product. And the way I do it is, "You've been hired by a competitor to design a me too version of product. I'm going to leave aside for a moment that why you would want to build a me too version. What is the bare minimum of what you need to build?" And then I tell them, "You ran out of resources. You get a quarter of the scope and a quarter of the..." Or, "You get quarter of the time and a quarter of the team. What do you actually build?" And then I get down to the other side of, "You've decided you can differentiate in only one place. What do you do to differentiate?" And so there are a series of questions that are basically a form of PSHE, but just formed around a new problem space that lets people wander a little bit. I've seen some really amazing answers to that.

**中文翻译:**
然后我会让他们重新设计产品。方式是：“你被竞争对手雇佣去设计一个‘我也是’（Me-too）版本的产品。先不谈为什么要模仿，你需要构建的最基本功能是什么？”然后我告诉他们：“你资源耗尽了，你只有四分之一的范围和四分之一的时间/团队，你到底会构建什么？”最后我问：“你决定只在一个地方做差异化，你会怎么做？”这是一系列基本上是 PSHE 形式的问题，只是围绕一个新的问题空间展开，让人们发挥。我见过一些非常惊艳的回答。

---

### [01:28:27] Lenny Rachitsky

**English:**
There's also a lot of [inaudible 01:28:28] question elements to this sequence. Wow. Excellent. Okay. Who else in the industry do you respect as a thought leader? Who comes to mind?

**中文翻译:**
这一系列问题里也有很多特征问题的元素。哇，太棒了。好，行业里你还尊敬哪些思想领袖？谁会浮现在脑海中？

---

### [01:28:37] Shishir Mehrotra

**English:**
Other than you? I have to ask. Present company excluded?

**中文翻译:**
除了你吗？我得问清楚，不包括在座的各位？

---

### [01:28:40] Lenny Rachitsky

**English:**
Yeah. That's great. [inaudible 01:28:41].

**中文翻译:**
是的，哈哈。

---

### [01:28:43] Shishir Mehrotra

**English:**
By the way, your newsletter is one of my top reads.

**中文翻译:**
顺便说一下，你的邮件通讯（Newsletter）是我必读的内容之一。

---

### [01:28:45] Shishir Mehrotra

**English:**
I think that yours and Ben Thompson from Stratechery are two of the ones that... I think you both have a very natural instinct for writing and synthesizing things that people are feeling with a clarity that's really helpful. So I really appreciate that.

**中文翻译:**
我认为你和 Stratechery 的 Ben Thompson 是我最欣赏的两位……我觉得你们都有一种天生的直觉，能清晰地写作并总结人们的感受，这非常有帮助。我非常感激这一点。

---

### [01:29:05] Lenny Rachitsky

**English:**
Appreciate that.

**中文翻译:**
谢谢。

---

### [01:29:06] Shishir Mehrotra

**English:**
I mean, I think the rituals process has exposed me to some really amazing leaders. Talked about Ariana. I always learn a lot when I talk to Ariana. [inaudible 01:29:14] has contributed a bunch. I think he's really helpful and is... And I can't believe he basically had no Twitter followers at the beginning of the pandemic. And his tweet are just total gold and so insightful and well put together. Fidji Simo is someone that I learned a lot from. She now runs Instacart. Daniel from Spotify, Daniel Ek. I think he's got this really unique way of thinking about the world, and he's also one of the few people that can hold a very long-term view and a very short-term view at the same time. Fantastic ethics. I'd also say my entire board, Reid, Reid Hoffman, [inaudible 01:29:51], Mamoon Hamid, Quentin Clark, Sarah Guo. I think they're all amazing and I'm super lucky to have a group of people I can call with questions.

**中文翻译:**
在研究仪式的过程中，我接触到了一些非常了不起的领导者。比如 Arianna，每次和她聊天我都能学到很多。还有一些人贡献了很多见解。我不敢相信某位领袖在大流行开始时几乎没有 Twitter 粉丝，而他的推文简直是金子，非常有洞察力。Fidji Simo（现任 Instacart CEO）也是我学到很多的人。还有 Spotify 的 Daniel Ek，他思考世界的方式非常独特，他是少数能同时持有长期愿景和短期视角的人之一，职业道德也极佳。还有我的整个董事会：Reid Hoffman、Mamoon Hamid、Quentin Clark、Sarah Guo。他们都很棒，我很幸运有一群可以随时请教的人。

---

### [01:30:00] Lenny Rachitsky

**English:**
Awesome. Someone's going to have a lot of work on these show notes. That list. Okay. Final question. What's your go-to karaoke song or dance move at a wedding?

**中文翻译:**
太棒了。看来整理节目介绍的人要辛苦了，名单真长。好，最后一个问题：你必唱的卡拉 OK 歌曲或在婚礼上的招牌舞步是什么？

---

### [01:30:09] Shishir Mehrotra

**English:**
Karaoke song is If I Had $1000000 by the Barenaked Ladies, and it's a... If people don't remember the song, part of the reason it's my favorite is I'm a very mediocre singer and you don't have to be that good a singer and everybody can sing along so you can bring everybody into it. And it's just such a fun song, If I Had $1000000.

**中文翻译:**
卡拉 OK 歌曲是 Barenaked Ladies 的《If I Had $1,000,000》。如果大家不记得这首歌，我喜欢它的部分原因是我唱歌水平很一般，而这首歌不需要唱得很好，大家都可以跟着唱，能带动全场。这首歌真的很有趣。

---

### [01:30:28] Lenny Rachitsky

**English:**
You're as thoughtful about your karaoke songs as you are about everything else you're doing. Shishir, thank you so much for being on this podcast. You've set a really high bar for CO guests, so we'll see who comes up next. Two final questions. Where can folks find you online if they want to reach out or learn more? And how can listeners be useful to you?

**中文翻译:**
你对卡拉 OK 歌曲的选择和你做的其他事情一样深思熟虑。Shishir，非常感谢你参加本播客。你为 CEO 嘉宾设定了一个非常高的标准，看看接下来谁会来。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？听众能为你做点什么？

---

### [01:30:44] Shishir Mehrotra

**English:**
Okay. I'll give the same answer to both. Well, I'm easy to find, one of the benefits of having a not very common name. It's easy to find me on basically every platform so you can find me on Twitter. It's easy to DM me, Shishir@Coda.io. It'll get to right to me. But in terms of being useful to me and also finding me, I would highly recommend joining the Rituals of Great Teams Braintrust. And I think it's a pretty fun experience to get a chance to contribute to a book like that. And hopefully if you've made it this far in the episode, then you probably are interested. And so I think you'll find it interesting. And I'm having a lot of fun with the people in that Braintrust.

**中文翻译:**
好，这两个问题我给同一个答案。我很容被找到，名字不常见的好处就在这。在几乎所有平台上都能找到我，比如 Twitter。也可以直接给我发邮件：Shishir@Coda.io。至于如何帮到我以及找到我，我强烈建议加入“优秀团队仪式感智囊团”。能为这样一本书贡献力量是一段非常有趣的经历。如果你已经听到了这里，那你很可能感兴趣。我觉得你会发现它很有趣，我也和智囊团里的人相处得很愉快。

---

### [01:31:18] Lenny Rachitsky

**English:**
Amazing. I'm definitely going to join. Thank you, Shishir.

**中文翻译:**
太棒了，我肯定会加入。谢谢你，Shishir。

---

### [01:31:22] Shishir Mehrotra

**English:**
Yeah. All right. Thank you so much, Lenny. That was really fun.

**中文翻译:**
好的，非常感谢，Lenny。聊得很开心。

---

### [01:31:24] Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。