# Sri Batchu - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Sri Batchu.

---

### [00:00:00] Sri Batchu

**English:**
I do think there's actually a general path that most B2B companies take and should take. My view is you start off with founder-led sales, the early team needs to know how to actually sell. Then you hire your first couple of salespeople, then you start some very low cost targeted marketing efforts. So whether it's content, community, small scale events, and then PR, after all of that is when you start paid and brand effort and then SEO probably start around the same time that you start paid marketing efforts. The reason for the progression the way I've described it is the channels get more expensive as you go farther along and they get more effective as you understand more about your customers.

**中文翻译:**
我认为大多数 B2B 公司实际上都有一条普遍且应该遵循的发展路径。我的观点是，你首先要从“创始人主导的销售”开始，早期团队必须知道如何实际完成销售。然后，你雇佣前几个销售人员，接着开始一些极低成本的针对性营销尝试。无论是内容、社区、小规模活动，还是公关（PR）。在完成这些之后，才开始投入付费营销和品牌建设，而 SEO（搜索引擎优化）可能在开始付费营销的同时启动。我之所以这样描述这个进阶过程，是因为随着业务的深入，渠道会变得越来越贵，但随着你对客户了解的加深，它们的效率也会变得更高。

---

### [00:00:43] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hard one experiences building and growing today's most successful products. Today my guest is Sri Batchu. Sri was VP of Ops at Opendoor, then head of growth at Instacart, and currently he's the head of growth at Ramp, which as you'll hear at the top of the episode, is the fastest growing SaaS business and the fastest growing FinTech business in history. They hit a hundred million dollar yearly run rate in two years, which is absurd, and in the last year grew 4X during a period where most companies barely grew at all. I recently did a newsletter post on how Ramp builds product with their VP of product, Geoff Charles. And in this episode, we zeroed in on Ramp's approach to growth. We chat about what Ramp did in the early days to kickstart growth, how they mostly grow these days, how their growth team is structured, their prioritization framework plus their north star metrics.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品负责人和增长专家，学习他们在构建和发展当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Sri Batchu。Sri 曾任 Opendoor 的运营副总裁，随后担任 Instacart 的增长负责人，目前他是 Ramp 的增长负责人。正如你在本集开头听到的，Ramp 是历史上增长最快的 SaaS 企业和金融科技（FinTech）企业。他们在两年内就达到了 1 亿美元的年化收入运行率（run rate），这简直不可思议；而且在去年大多数公司几乎停滞不前的情况下，他们实现了 4 倍的增长。我最近在时事通讯中与他们的产品副总裁 Geoff Charles 合作发表了一篇关于 Ramp 如何构建产品的文章。而在本集节目中，我们将重点讨论 Ramp 的增长方法。我们会聊到 Ramp 早期是如何启动增长的、目前主要的增长方式、增长团队的架构、优先级框架以及他们的北极星指标（North Star metrics）。

---

### [00:01:37] Lenny

**English:**
Also, how they operationalize velocity, which is at the core of their team culture. Ramp is a really special company that is clearly on an incredible journey and I am really excited to share this glimpse into how they operate. Enjoy this episode with Sri Batchu after a short word from our sponsors. This episode is brought to you by Attio, a new type of CRM that's powerful, flexible, and built around your data. Traditional CRMs were built for a different era with totally different speed, scale, and data demands. Attio is different. It allows you to quickly build a CRM that matches your unique workflows and data structures. Within minutes of connecting your email and calendar, you'll have a CRM that's already set up complete with customer profiles and automatic data enrichment. You'll also have realtime dynamic reporting at your fingertips. No more slow deployments, outdated user experiences or tedious manual data input.

**中文翻译:**
此外，我们还会讨论他们如何将“速度”（velocity）运营化，这是他们团队文化的核心。Ramp 是一家非常特别的公司，正处于一段不可思议的旅程中，我非常激动能分享他们运作方式的内幕。在听完赞助商的简短介绍后，请欣赏与 Sri Batchu 的这一集。本集由 Attio 为您呈现，这是一种新型 CRM，功能强大、灵活且围绕您的数据构建。传统的 CRM 是为不同时代构建的，其速度、规模和数据需求完全不同。Attio 则不同，它允许您快速构建一个匹配您独特工作流和数据结构的 CRM。在连接您的电子邮件和日历后的几分钟内，您就能拥有一个配置完成的 CRM，包含客户档案和自动数据增强功能。您还可以随时掌握实时动态报告。不再有缓慢的部署、过时的用户体验或繁琐的手动数据输入。

---

### [00:02:32] Lenny

**English:**
With Attio, you can build and adapt your CRM on the fly, no matter your business model or company stage. Attio is the CRM for fast-growing startups. Get started today and get 15% off your first year at attio.com/lenny. That's A-T-T-I-O.com/lenny. This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it all together and how can help your team run smoother and be more efficient. I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors.

**中文翻译:**
无论您的业务模式或公司阶段如何，使用 Attio，您都可以随时构建和调整您的 CRM。Attio 是为快速增长的初创公司设计的 CRM。立即开始，在 attio.com/lenny 享受首年 85 折优惠。地址是 A-T-T-I-O.com/lenny。本集由 Coda 为您呈现。您听我多次提到过 Coda 是一个能将所有内容整合在一起的文档，它能帮助您的团队运行得更顺畅、更高效。我有切身体会，因为 Coda 就在为我做这些。我每天都用 Coda 来管理我的时事通讯内容日历、播客采访笔记以及协调我的赞助商。

---

### [00:03:11] Lenny

**English:**
More recently, I actually wrote a whole post on how Coda's product team operates and within that post they shared a dozen templates that they use internally to run their product team, including managing the roadmap, their OKR process, getting internal feedback, and essentially their whole product development process is done within Coda. If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda.

**中文翻译:**
最近，我写了一篇关于 Coda 产品团队如何运作的完整文章，在那篇文章中，他们分享了十几个内部用于管理产品团队的模板，包括路线图管理、OKR 流程、获取内部反馈，基本上他们的整个产品开发流程都是在 Coda 中完成的。如果您的团队工作分散在不同的文档、电子表格和一堆工作流工具中，那么这就是您需要 Coda 的原因。

---

### [00:03:36] Lenny

**English:**
Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down. Coda allows your team to operate on the same information and collaborate in one place. Take advantage of this special limited time offer just for startups. Plan up today at coda.io/lenny and get a thousand dollars startup credit on your first statement. That's C-O-D-A.io/lenny to sign up and get a startup credit of $1,000. Coda.io/lenny.

**中文翻译:**
无论格式如何，Coda 都能将数据放在一个中心位置，消除可能拖慢团队进度的障碍。Coda 让您的团队能够在同一信息基础上进行协作。请利用这个专门针对初创公司的限时特惠。今天就在 coda.io/lenny 注册，您的第一份账单即可获得 1000 美元的初创公司抵扣额度。注册地址是 C-O-D-A.io/lenny，领取 1000 美元抵扣额。Coda.io/lenny。

---

### [00:04:10] Lenny

**English:**
Sri, welcome to the podcast.

**中文翻译:**
Sri，欢迎来到播客。

---

### [00:04:12] Sri Batchu

**English:**
Thank you, Lenny. Thanks for having me. I'm a huge fan and I've been following the podcast and the newsletter. So excited to be on here.

**中文翻译:**
谢谢你，Lenny。感谢邀请。我是你的忠实粉丝，一直关注你的播客和时事通讯。很高兴能来到这里。

---

### [00:04:18] Lenny

**English:**
Really appreciate that. So let's talk about Ramp. So Ramp where you lead growth is apparently one of the fastest growing products in history. I believe it's the fastest growing SaaS product and business and also the fastest growing FinTech business. So first of all, is that generally true and correct?

**中文翻译:**
非常感谢。那我们来聊聊 Ramp 吧。你负责增长的 Ramp 显然是历史上增长最快的产品之一。我相信它是增长最快的 SaaS 产品和业务，也是增长最快的金融科技业务。首先，这大致属实吗？

---

### [00:04:38] Sri Batchu

**English:**
Yeah, I mean I'm sure you know of Packy and he's done a great analysis where he shared this work and compared us to a bunch of other companies and when he released this a year ago, we were the fastest growing company to a hundred million dollars of annualized revenue at the time. I don't know if there's been others since, but certainly not in the FinTech category as far as I know.

**中文翻译:**
是的，我想你肯定知道 Packy（Packy McCormick），他做过一个非常棒的分析，将我们与许多其他公司进行了对比。当他一年前发布这个分析时，我们是当时达到 1 亿美元年化收入最快的公司。我不确定之后是否还有其他公司打破纪录，但据我所知，在金融科技领域肯定没有。

---

### [00:04:58] Lenny

**English:**
Okay. So you said the fastest growing to a hundred million. I think it took two years to get to a hundred million and run rate, right?

**中文翻译:**
好。你说是达到 1 亿收入最快的。我记得达到 1 亿年化运行率用了两年时间，对吧？

---

### [00:05:03] Sri Batchu

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:05:03] Lenny

**English:**
That's insane because rarely is there all of this money sitting around for a company to just come in and accumulate and grab from people and provide that amount of value. So that's an insane stat. Maybe another question along these lines, is there any other just stats you could share, but just the scale of Ramp or just the speed that Ramp has grown?

**中文翻译:**
这太疯狂了，因为很少有这么多钱摆在那里，等着一家公司进来积累、从人们手中赚取并提供同等价值。这是一个惊人的数据。沿着这个思路，还有其他关于 Ramp 的规模或增长速度的数据可以分享吗？

---

### [00:05:23] Sri Batchu

**English:**
We publicly disclosed that last year we grew Forex on top of that, very sizable based from the year prior and Okta actually released some recent stats on fastest growing software companies among SMB and mid-market and Ramp was by far the fastest growing despite the fact that a bunch of others on the list were materially smaller. The company's still very lean for the amount of growth. We're under 500 people roughly today at that scale and that's definitely have a much higher revenue per employee than some of our other competitors and others in the space. And yeah, I mean we've got a very thoughtful and smart finance team that I've worked with actually closely our old head of strategic finance at Instacart and they set ambitious goals for us on growth and I'm happy to say we've consistently beat those ambitious goals over the last 16 months or 18 months since I've joined.

**中文翻译:**
我们公开披露过，去年我们在前一年已经非常庞大的基础上又增长了 4 倍。Okta 最近发布了一些关于中小企业（SMB）和中型市场中增长最快的软件公司的数据，Ramp 遥遥领先，尽管名单上的其他公司规模明显更小。相对于这种增长规模，公司依然非常精简。目前我们大约不到 500 人，这使得我们的人均创收（revenue per employee）远高于该领域的其他竞争对手。另外，我们有一支非常周密且聪明的财务团队，我与他们合作非常紧密——我们的战略财务负责人曾是我在 Instacart 的老同事。他们为我们设定了极具野心的增长目标，我很自豪地说，自加入以来的 16 到 18 个月里，我们一直都在超越这些宏伟目标。

---

### [00:06:16] Lenny

**English:**
Which is especially challenging in this environment. So it's extra meaningful. Okay, so here's the big question I want to start off with. I know you weren't there at the beginning of Ramp's journey, but from what you know, what do you think the team did early on to seed this level of growth and success other than just building an awesome product that people really love? And if that's the answer, that's fine, but usually that's part of it. I'm curious just like is there some clever unique tactics that they used to help create that incredible growth from the beginning?

**中文翻译:**
在当前这种环境下，这尤其具有挑战性，所以意义非凡。好，我想从这个大问题开始。我知道你并没有参与 Ramp 创业初期的旅程，但据你所知，除了打造一个人们真心喜爱的优秀产品之外，你认为团队在早期做了什么来播下这种增长和成功的种子？如果答案就是“产品好”，那也没问题，但通常这只是部分原因。我很好奇，他们是否使用了一些聪明、独特的策略来从一开始就创造出那种惊人的增长？

---

### [00:06:49] Sri Batchu

**English:**
I think you're certainly right on the product side. Obviously you've recently written about Ramp's product engine with Geoff and that there's been incredible product market fit because of the product team that deeply understood the customer experience and I think that's certainly helped initial word of mouth. One thing that I did want to point out that Ramp did that was interesting is obviously Eric and Karim, the co-founders of Ramp, were previous founders of another company that they had a successful exit on.

**中文翻译:**
我觉得你在产品方面的看法当然是对的。显然，你最近和 Geoff 一起写了关于 Ramp 产品引擎的文章，由于产品团队深刻理解客户体验，产品与市场的契合度（PMF）非常惊人，这无疑有助于初期的口碑传播。我想指出 Ramp 做的一件很有趣的事：Ramp 的联合创始人 Eric 和 Karim 之前创办过另一家公司并成功退出。

---

### [00:07:15] Sri Batchu

**English:**
So they had a strong reputation as founders and came in with the right set of experience to build Ramp and one of the things that they did is what I call cap table as a growth strategy where they did a great job of getting a large number of early stage founders and other influential operators and advisors onto the cap table at the company. And many of our initial customers were these companies that were on the cap table or the founders were on the cap table for. And Ramp today is actually not majority startups or tech companies anymore. The vast majority of our customers are mid-market and enterprise. That's where our revenue comes from. But there's a lot of love among the tech founder community because of the early days, both the product quality as well as all of these investors that Ramp got.

**中文翻译:**
因此，他们作为创始人拥有极高的声誉，并带着构建 Ramp 所需的丰富经验。他们做的一件事，我称之为“将股权结构表（cap table）作为增长策略”——他们非常出色地邀请了大量早期创始人、其他有影响力的运营者和顾问进入公司的股权结构表。我们的许多初始客户正是这些在股权表上的公司，或者是那些创始人在股权表上的公司。虽然今天的 Ramp 已经不再以初创公司或科技公司为主（绝大部分收入来自中型市场和企业级客户），但在科技创业者社区中，Ramp 依然备受推崇，这归功于早期的产品质量以及 Ramp 吸引到的这些投资者。

---

### [00:08:08] Lenny

**English:**
Wow. I have not heard of this strategy before and I didn't know this was actually a big part of the initial story. So is there examples of folks that they had on their cap table that are examples of folks that helped them grow initially like this?

**中文翻译:**
哇，我以前没听说过这种策略，也不知道这竟然是早期故事的重要组成部分。那么，股权结构表中有哪些人是帮助他们实现初期增长的典型例子吗？

---

### [00:08:20] Sri Batchu

**English:**
One example that I can think of is Eight Sleep founder, he's been very close to the Ramp team, same with the Pod founder and then a bunch of VC firms that are investors in the company are also customers of the company.

**中文翻译:**
我能想到的一例子是 Eight Sleep 的创始人，他一直与 Ramp 团队关系密切；还有 Pod 的创始人。此外，许多投资该公司的风投机构（VC）本身也是公司的客户。

---

### [00:08:32] Lenny

**English:**
Do you know if the strategy there was VCs who connect them to small companies that would use Ramp or is it directly founders of companies that would immediately use Ramp?

**中文翻译:**
你是否知道当时的策略是让风投把他们引荐给可能使用 Ramp 的小公司，还是直接让那些公司的创始人立即开始使用 Ramp？

---

### [00:08:43] Sri Batchu

**English:**
Yeah, I'll say it was more founders and executives of customers that can use Ramp. Certainly we have a fantastic group of very sophisticated investors who have made introductions to Ramp as well and that helped. But I will say that is not as big of a channel as one might expect because companies have their own decision making frameworks for selecting a product like Ramp and the investor opinion and recommendation matters, but turns out it doesn't matter maybe as much as another customer who's actually used the product that they know or are actually experiencing the product.

**中文翻译:**
我会说更多是那些可以直接使用 Ramp 的客户的创始人和高管。当然，我们有一群非常优秀的资深投资者，他们也为 Ramp 做了引荐，这确实有帮助。但我必须说，这并不像人们想象的那么大，因为公司在选择像 Ramp 这样的产品时有自己的决策框架。投资者的意见和推荐固然重要，但事实证明，其影响力可能不如另一个他们认识的、真正使用过或正在体验该产品的客户。

---

### [00:09:17] Lenny

**English:**
Amazing, awesome tactic. I've not heard of that before. In terms of growth, how much of growth of early Ramp was new customers versus expansion within existing customers? Because what's cool about credit card is people spend more, you make more money because you're taking a piece of that. So roughly how much of the growth insanity over the first couple of years was from expansion within existing customers?

**中文翻译:**
太棒了，非常有意思的策略。关于增长，早期 Ramp 的增长中有多少来自新客户，又有多少来自现有客户的扩张？因为信用卡业务的酷点在于，人们花得越多，你赚得就越多，因为你会从中抽成。那么，头几年那种疯狂的增长中，大约有多少是来自现有客户的消费扩张？

---

### [00:09:39] Sri Batchu

**English:**
Obviously many of our early customers have grown quite a bit and our whole strategy is to save companies time and money so they can redeploy that in other ways for their own growth or other objectives. And we obviously are growing our product suite as well like BillPay, Flex, et cetera, where our customers can spend more money on Ramp and get more value out of Ramp. Having said all of that, what's interesting is that the vast majority of our growth back then and even to this day is via new customer acquisition. It's just we are adding so many more customers that the growth of our customers while strong and important part of our growth lever is not nearly as material as you might think.

**中文翻译:**
显然，我们的许多早期客户自身也增长了很多。我们的整体策略是为公司节省时间和金钱，以便他们可以将这些资源重新投入到自身的增长或其他目标中。同时，我们也在扩展产品线，比如 BillPay（账单支付）、Flex 等，让客户可以在 Ramp 上花更多钱并获得更多价值。尽管如此，有趣的是，无论是当时还是现在，我们绝大部分的增长都来自于“新客户获取”。仅仅是因为我们增加的客户数量实在太多了，以至于现有客户的增长（虽然强劲且是重要的增长杠杆）在整体占比中并没有你想象的那么大。

---

### [00:10:21] Lenny

**English:**
Okay, awesome. So that's a good segue to the next question I had, which is if you're going to create a pie chart of how Ramp grows and ideally if you could even share early on and then now, how does that pie chart look? What are the slices of that pie and then what are the rough percentages of where growth comes from for Ramp?

**中文翻译:**
太好了。这正好引出了我的下一个问题：如果你要为 Ramp 的增长方式画一个饼图，理想情况下如果能分享早期和现在的对比就更好了，那个饼图长什么样？饼图的各个切片是什么？Ramp 的增长来源大致百分比是多少？

---

### [00:10:37] Sri Batchu

**English:**
Rather than going into the specifics, one thing I'll say about the growth system today is if you were to look at what percentage of our business comes from outbound sales, paid marketing, field, and then a bunch of other channels and then you compare it against industry benchmarks, I think the secret sauce of Ramp is not that we've found a channel that's unique and that we've over-invested or under-invested. I don't think our distribution would be not that far off from looking at other companies at our size and stage.

**中文翻译:**
与其深入细节，关于现在的增长体系，我想说的一点是：如果你观察我们的业务有多少比例来自主动推销（outbound sales）、付费营销、实地营销（field marketing）以及其他渠道，并将其与行业基准进行比较，你会发现 Ramp 的“秘诀”并不在于我们找到了某个独特的渠道，或者我们在某些渠道上过度投资或投资不足。我认为我们的分发比例与同等规模和阶段的其他公司相比，差别并不会太大。

---

### [00:11:10] Sri Batchu

**English:**
I think what we've done differently is we've really focused on making all of those investments very much driven by technology and data. And so one example that I'll give you is that our sales teams are actually incredibly efficient by any metric that we look at and we obviously benchmark them. And the reason for that is because we actually have a growth engineering team that's dedicated to supporting that efficiency but including adjusting third party data and using AI to automate much of their workflow, et cetera. And we've been doing this well before AI has become the buzzword for a lot of folks, but this is something we've had this team for almost two years now that that's been working on sales automation and data to just make our sales teams more efficient. That's just one example, but we've got similar types of mandates for every channel that we invest in and thinking about how do we inform this better customer and prospect data and how do we automate and technologize it so that we can build that competitive mode for each channel.

**中文翻译:**
我认为我们做得不同的是，我们非常专注于让所有这些投资都由技术和数据驱动。举个例子，无论用什么指标衡量，我们的销售团队效率都极高，我们也确实对他们进行了基准测试。原因在于我们拥有一支专门支持这种效率的“增长工程团队”，包括整合第三方数据、利用 AI 自动化大部分工作流等。早在 AI 成为大众热词之前，我们就已经在这么做了。这支团队已经运作了快两年，专注于销售自动化和数据，以提高销售团队的效率。这只是一个例子，我们对投入的每一个渠道都有类似的使命：思考如何获取更好的客户和潜在客户数据，以及如何将其自动化和技术化，从而为每个渠道建立竞争护城河。

---

### [00:12:13] Lenny

**English:**
I'd love to learn more about this growth eng team that works with sales. How is that structured maybe as the first question and then just what are their goals? How do you measure their progress and success?

**中文翻译:**
我很想多了解一下这支配合销售工作的增长工程团队。首先，它的架构是怎样的？其次，他们的目标是什么？你们如何衡量他们的进度和成功？

---

### [00:12:24] Sri Batchu

**English:**
A lot of companies do it differently. I think what works really well with Ramp is that we have the same shared goal, which is the pipeline driven and the payback period of the channel. It's unique to Ramp where the engineers feel ownership of the quota. They're not owning product metrics or what have you, they're obviously of course interim and input metrics that are important, but they really do feel accountable for the pipeline driven and the efficiency driven by that team. And I think that naturally allows them bottom up to come with the right projects that they think will have maximal impact on efficiency and top line.

**中文翻译:**
很多公司的做法各不相同。我认为 Ramp 行之有效的原因在于我们拥有共同的目标，即渠道驱动的“销售漏斗”（pipeline）和“回本周期”（payback period）。Ramp 的独特之处在于，工程师们对销售配额（quota）有主人翁意识。他们负责的不是产品指标之类的，虽然中间指标和投入指标也很重要，但他们真的觉得自己对团队驱动的漏斗量和效率负有责任。我认为这自然而然地让他们能够自下而上地提出那些他们认为对效率和营收影响最大的项目。

---

### [00:13:04] Lenny

**English:**
So what are the sorts of things they do for a sales team? Is it like they help them prioritize leads or is it they help craft their messaging? Which parts are maybe most important?

**中文翻译:**
那么他们具体为销售团队做些什么？是帮助他们对潜在客户进行优先级排序，还是帮助他们撰写沟通话术？哪些部分最重要？

---

### [00:13:15] Sri Batchu

**English:**
All of the above, helping find the right prospects, sending them the right messaging as well as prioritizing responses and drafting potential responses for the team as well.

**中文翻译:**
以上全部。帮助寻找合适的潜在客户，发送精准的信息，以及对回复进行优先级排序，甚至为团队起草潜在的回复内容。

---

### [00:13:26] Lenny

**English:**
Fascinating. How much impact have you seen that has on sales?

**中文翻译:**
太有意思了。你观察到这对销售产生了多大的影响？

---

### [00:13:30] Sri Batchu

**English:**
It's incredibly helpful to our sales team and it's one of our most efficient channels as I've mentioned. So I think that there is something unique about our ability to bring technology to every channel.

**中文翻译:**
这对我们的销售团队非常有帮助。正如我提到的，这是我们效率最高的渠道之一。所以我认为，我们将技术引入每个渠道的能力确实非常独特。

---

### [00:13:41] Lenny

**English:**
Super interesting. Maybe on that topic, can you just talk about how your growth team is structured at Ramp? What are the kind of sub-teams and how do you think about?

**中文翻译:**
非常有趣。关于这个话题，你能谈谈 Ramp 的增长团队是如何构成的吗？有哪些子团队？你们是如何考虑的？

---

### [00:13:50] Sri Batchu

**English:**
We've got an organization today that might evolve and if we get to that topic we can talk about it, but historically the way we've been organized is we've got channel based teams that are deploying spend in a given channel. So we've got a paid marketing team, a lifecycle CRM team, we've got a field marketing team, et cetera. And then we've got a product engineering team that is supporting growth and sales and helping each of these channels be more effective that's dedicated to growth. And then separate from that, we've got a small kind of what I call an innovation or skunk work type of team that works on cross-channel. Just things that don't neatly fit into a box that we think could be cool or fun to try to just do more experimentation that is cross-channel, cross-team.

**中文翻译:**
我们现在的组织架构可能会演变，如果聊到那个话题我们可以再细说。但从历史上看，我们的组织方式是：拥有基于渠道的团队，负责在特定渠道投入预算。所以我们有付费营销团队、生命周期 CRM 团队、实地营销团队等。然后，我们有一支专门负责增长的产品工程团队，支持增长和销售，帮助每个渠道提高效率。除此之外，我们还有一支规模较小的、我称之为“创新”或“秘密项目”（skunk works）的团队，负责跨渠道的工作。就是那些无法简单归类、但我们认为很酷或很有趣、值得尝试的跨渠道、跨团队实验。

---

### [00:14:37] Lenny

**English:**
Definitely sounds like the most fun team. What are some of the things they've done or work on in the skunk works team?

**中文翻译:**
听起来这绝对是最有趣的团队。这个秘密项目团队做过或正在做哪些事情？

---

### [00:14:42] Sri Batchu

**English:**
They've done testing of new channels that don't necessarily fit into very... And that includes new online platforms. They've done some interesting stuff on TikTok and Reddit and other places, things like that. They've focused on referrals and how to make that a more delightful experience for the customers, first party events, things like that. Things that are often smaller scale and if they work we can invest more and make them larger scale later.

**中文翻译:**
他们测试了一些不一定能归入常规类别的新渠道，包括新的在线平台。他们在 TikTok、Reddit 等地方做过一些有趣的尝试。他们还专注于推荐机制（referrals）以及如何让客户的推荐体验更愉快，还有第一方活动等等。这些通常是小规模的尝试，如果行得通，我们以后会加大投入并扩大规模。

---

### [00:15:16] Lenny

**English:**
I love it. So the teams roughly is there's a paid growth team that just works on paid growth optimization, lifecycle CRM team basically it's like emails I imagine is a big part of that.

**中文翻译:**
太棒了。所以团队大致分为：负责付费增长优化的付费增长团队；生命周期 CRM 团队，我猜电子邮件是其中的重要部分。

---

### [00:15:26] Sri Batchu

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:15:27] Lenny

**English:**
Then there's a field sales support team and then there's the sales team, kind of eng sales team that you talked about and then I also imagine there's like a self-serve.

**中文翻译:**
然后是实地销售支持团队，接着是你提到的那种工程销售团队，我猜还有负责“自助服务”（self-serve）的团队。

---

### [00:15:37] Sri Batchu

**English:**
Yeah, exactly. There's a self-serve activation eng team as well. And then of course there's SEO and website and bound lead channel management team.

**中文翻译:**
对，没错。还有一个自助服务激活工程团队。当然，还有 SEO、网站和入站线索（inbound lead）渠道管理团队。

---

### [00:15:47] Lenny

**English:**
And then this awesome skunk works team. I love it. Okay, so shifting a little bit, something that comes across often and consistently with Ramp, and this came across very clearly in the post that I did on how Ramp builds product with Geoff is velocity and how important velocity is at Ramp. There's this awesome quote that I'll read here from Keith Rabois who I think led many of the rounds of Ramp. He started Founders Fund, famous investor. He said that, "Ramp's product velocity is absolutely unprecedented in my 21 years working with technology businesses." So here's my question to you. Can you just talk about what that actually looks like and feels like working inside Ramp with this intense velocity?

**中文翻译:**
还有那个超酷的秘密项目团队。太棒了。好，稍微换个话题。关于 Ramp，有一个经常被提及且始终如一的特点，在我与 Geoff 合作的那篇关于 Ramp 如何构建产品的文章中也体现得很清楚，那就是“速度”（velocity）以及速度在 Ramp 有多重要。我想读一段 Keith Rabois 的精彩语录，他领投了 Ramp 的多轮融资，是 Founders Fund 的创始人，也是著名的投资者。他说：“在我从事科技行业的 21 年里，Ramp 的产品迭代速度绝对是前所未有的。”所以我的问题是：在 Ramp 内部这种极速环境下工作，实际情况和感受是怎样的？

---

### [00:16:30] Sri Batchu

**English:**
Yeah, it is a great question and Keith is amazing and then probably one of the smartest investors that I've ever had a good fortune of working with both here as well as at Opendoor, and I'll say he's absolutely right about that. And what you see internally is what I'll say is razor-sharp focus on reducing cycle time and bias to action and how do we reduce cycle time. I think it's basically the core of it culturally to me is getting people to think about smaller units of time for decision making. It seems obvious but I think you really have to reinforce it culturally. So one thing that Eric, our CEO, does, which I don't know if you've heard externally, is we have days.ramp.com where we can see how many days it's been since the founding of Ramp internally and it's day 1,529 at Ramp. He has that number of days at every board meeting, at every all hands.

**中文翻译:**
这是一个好问题。Keith 非常了不起，他可能是我有幸在 Ramp 和 Opendoor 合作过的最聪明的投资者之一。我想说，他的评价完全正确。在公司内部，你会看到一种对“缩短周期时间”和“行动导向”的极度关注。我认为其文化核心是让人们在决策时考虑更小的时间单位。这听起来显而易见，但你必须在文化上不断强化它。我们的 CEO Eric 做了一件事，我不确定外界是否听说过：我们有一个内部网站 days.ramp.com，可以看到 Ramp 成立以来的天数，今天是 Ramp 的第 1529 天。他在每次董事会会议、每次全员大会上都会提到这个天数。

---

### [00:17:28] Sri Batchu

**English:**
It's just to remind people that we don't work in years, quarters, weeks, we work in days. Each day matters and so never put out something tomorrow that you know can get done today. And that bias to action really permeates not just in the product teams but everywhere. So our growth team, which as I've just described, is extremely cross-functional, a lot of marketing folks and other expertise on the team, but we work a lot like a product team, we work on two-week sprints, we cross-prioritize across these teams and we work all together rather than in separate silos within the growth team.

**中文翻译:**
这只是为了提醒大家，我们不是按年、季度或周来工作，而是按天工作。每一天都很重要，所以如果今天能完成的事，绝不要拖到明天。这种行动导向不仅渗透在产品团队中，而是无处不在。我们的增长团队正如我刚才描述的，是高度跨职能的，团队中有很多营销人员和其他领域的专家，但我们的运作方式非常像产品团队：我们按两周一个冲刺（sprint）工作，在这些团队之间进行交叉优先级排序，大家作为一个整体协作，而不是在增长团队内部各自为政。

---

### [00:18:08] Lenny

**English:**
So I pulled up the site you just mentioned, days.ramp.com, and not only is it days since launch, which is 1,529 when I'm looking at it, there's a many decimal points that are counting up. 1,529.43453142. Oh my god. Okay. Is that a new addition, the decimal points?

**中文翻译:**
我打开了你刚才提到的网站 days.ramp.com，不仅显示了自成立以来的天数（我看到的是 1529 天），后面还有很多位正在跳动的小数点：1529.43453142……天呐。好吧，那些小数点是新加的吗？

---

### [00:18:29] Sri Batchu

**English:**
No, I think that's always been there. It's just amping it up, how much time is passing. It could be stressful at times, but I think that the mitigating factor is that it's been able, as you know, A players want to work with A players attract A players and retain A players, and Ramp has done a really great job of hiring people that are fantastic that can work in this environment well and are motivated by the success and the winning from this sort of culture.

**中文翻译:**
不，我想一直都有。它只是在强调时间流逝得有多快。有时这确实会让人感到压力，但我认为缓解因素在于，正如你所知，顶尖人才（A players）渴望与顶尖人才共事，顶尖人才也会吸引并留住顶尖人才。Ramp 在招聘方面做得非常好，招到了一群能在这种环境下表现出色，并被这种文化带来的成功和胜利所激励的优秀人才。

---

### [00:18:58] Lenny

**English:**
Yeah, I was actually talking to Eric about it for another piece I'm working on and he was showing me some early board decks in every deck as you said has day 544 of Ramp. So it's very real what you're talking about. Is there anything else that just as someone that came into Ramp from other traditional companies that also move really fast, Instacart and Opendoor, that is just like holy moly, this is velocity? You talked about a few things but is there anything just like holy shit?

**中文翻译:**
是的，我为了另一篇文章和 Eric 聊过，他给我看了一些早期的董事会报告，正如你所说，每份报告都写着“Ramp 第 544 天”之类的。所以你说的非常真实。作为从 Instacart 和 Opendoor 这种同样节奏极快的公司来到 Ramp 的人，还有什么让你觉得“天呐，这才是真正的速度”的事情吗？你提到了一些，但还有没有什么让你感到“卧槽”的瞬间？

---

### [00:19:26] Sri Batchu

**English:**
You can see the cycle time thing in terms of responsiveness from everybody at Ramp and I think typically what you tend to see is as companies get bigger, they evolve off of Slack to email and everything just moves a little bit slower and there's process and then there's obviously a lot of good parts of that but Ramp, what I noticed when I joined and true to this day is how quickly people will respond on Slack and jump on things and even if they don't complete it, there's very clear action item on who the owner will be and what the deadline will be even if it's not. And that to me was always very impressive just about... And I think it's one of those things we build in public, so everything is very visible so you can see how this is working across teams and I'm glad that we've been able to maintain that culture even as we've gotten much bigger.

**中文翻译:**
你可以从 Ramp 每个人的响应速度中看到这种“周期时间”意识。通常你会发现，随着公司变大，沟通会从 Slack 转向电子邮件，一切都会变慢，流程变多——当然流程也有其好处。但在 Ramp，我加入时注意到并延续至今的一点是，人们在 Slack 上的响应速度极快，会迅速处理事情。即使不能立即完成，也会有非常明确的行动项，指明负责人是谁、截止日期是什么。这对我来说一直印象深刻。而且我认为这是“公开构建”（build in public）的一部分，一切都非常透明，你可以看到跨团队的运作情况。我很庆幸即使公司规模扩大了很多，我们依然保持了这种文化。

---

### [00:20:21] Lenny

**English:**
There's two effects of that I imagine. One is how do you stay in the flow and get work done if you're just expected to constantly respond? How does that actually work?

**中文翻译:**
我能想象这会产生两个影响。第一，如果被期望不断做出响应，你如何保持“心流”并完成工作？这在实际中是如何运作的？

---

### [00:20:31] Sri Batchu

**English:**
I don't think the expectation is necessarily that one constantly responds, but it is something that I have seen people are good at. And so I think one of the things that, again, not like a novel productivity tool, but something that Ramp does do is just trying to think about focus time and response times and using calendar blocking to really effectively manage your time that way. And then doing calendar audits of yourself as well as of your team to say, okay, what are your highest priorities for this week, this day, this month? And how does your calendar reflect your priorities? Because in many ways you ship your calendar and so thinking about how are you spending your time and then blocking your time accordingly.

**中文翻译:**
我不认为公司一定要求每个人时刻响应，但我确实看到大家都很擅长这一点。所以，虽然不是什么新奇的生产力工具，但 Ramp 确实在做的一件事是：思考“专注时间”与“响应时间”，并利用“日历锁定”（calendar blocking）来有效地管理时间。此外，还会对自己和团队进行“日历审计”，问自己：这周、今天、这个月最高优先级的事情是什么？你的日历是否反映了这些优先级？因为在很多方面，你的产出取决于你的日历。所以要思考你如何分配时间，并相应地锁定时间段。

---

### [00:21:15] Lenny

**English:**
And is this mostly a cultural just this is how we operate or is there a principles or sorts of processes that are set up to help people do those sorts of things?

**中文翻译:**
这主要是一种“这就是我们的运作方式”的文化，还是有一套原则或流程来帮助人们做到这些？

---

### [00:21:24] Sri Batchu

**English:**
Yeah, it's cultural in terms of how we operate, but we also have templates. Our people team has a template on how to do a calendar audit properly and things like that. So we've tried to create some learning materials as well for folks that are new to get into the flow of way of working.

**中文翻译:**
是的，在运作方式上它是文化性的，但我们也有模板。我们的人力团队有一份关于如何正确进行日历审计的模板之类的。所以我们也尝试为新加入的同事提供一些学习材料，帮助他们进入这种工作节奏。

---

### [00:21:45] Lenny

**English:**
Awesome. Okay, so then the other elephant in the room with talking about working really fast and hard and responding really quickly is work-life balance and burnout and things like that. One thing I'll say is I believe in working really hard and working long hours as a important ingredient to success. I know there's been a bit of a backlash against that and just like, no, you shouldn't work really hard, you can be successful without doing that. I don't think that's true. So with that said, I guess what have you learned and what do you think Ramp has learned about how to find that balance and not just-

**中文翻译:**
太棒了。那么，谈到快速、努力工作和快速响应，另一个避不开的话题就是“工作与生活的平衡”以及“职业倦怠”之类的问题。我想说的是，我相信努力工作和长时间投入是成功的重要因素。我知道现在有一些反对的声音，认为不应该太努力，不努力也能成功。我不认为那是真的。话虽如此，关于如何找到平衡而不至于崩溃，你学到了什么？你认为 Ramp 学到了什么？

---

### [00:22:17] Sri Batchu

**English:**
Yeah. I completely agree with you. I do think, especially earlier in your career, hard work is so important both for learning but also impact and it's a tough balance that a lot of successful companies struggle with. I think my biggest learnings is it's, A, some of it is like self-selection, right? You're hiring people that are excited about doing this work and this way of working, but at least I tend to find the people that I've worked with that are highly successful, ours are not the problem. It's really autonomy, flexibility, and mission alignment and the general happiness they get from their work. And so that's what I try to focus on, which is not the hours that someone's put in, but quality of the work and the impact. And I think a big part of the push to having great results and working hard is really being grateful and appreciating the team when they do push themselves and celebrating wins.

**中文翻译:**
是的，我完全同意你的看法。我认为，尤其是在职业生涯早期，努力工作对于学习和产生影响力都至关重要。这是一个很多成功公司都在努力寻找的艰难平衡。我最大的感悟是：首先，这在一定程度上是“自我筛选”，对吧？你雇佣的是那些对这份工作和这种工作方式感到兴奋的人。但至少我发现，与我共事过的那些非常成功的人，工作时长并不是问题所在。真正关键的是自主权、灵活性、使命感的一致性，以及他们从工作中获得的整体幸福感。所以这也是我努力关注的重点：不是某人投入了多少小时，而是工作的质量和影响力。我认为，推动产生卓越成果和努力工作的很大一部分原因在于，当团队成员挑战自我时，要真心表达感激和赞赏，并庆祝每一个胜利。

---

### [00:23:23] Sri Batchu

**English:**
And I think we could always be doing a better job, but I think we've historically done a great job at that, at celebrating wins big and small. And I think part of the culture of building in public and open internally helps with that. So people are always sharing their wins. And then it's a very one funny stat that I don't know if other companies track is we track engagement during all hands on the Zoom to see what percentage people participate. And it's usually close to a hundred percent, like people are talking, the entire company is talking on the Zoom chat because they're excited about the wins that their friends and colleagues are shipping and the things that we're talking about in the audience.

**中文翻译:**
我觉得我们总能做得更好，但从历史上看，我们在庆祝大小胜利方面做得非常出色。我认为“公开构建”和内部透明的文化对此很有帮助，大家总是在分享自己的成果。还有一个很有趣的数据，我不知道其他公司是否也统计：我们会统计全员大会期间 Zoom 上的互动率，看看参与百分比。通常接近 100%，大家都在 Zoom 聊天框里发言，整个公司都在讨论，因为他们为朋友和同事发布的成果以及我们在会上讨论的事情感到兴奋。

---

### [00:24:05] Lenny

**English:**
How do you actually track engagement? Someone sitting there watching who's in the chat?

**中文翻译:**
你们具体是怎么追踪互动率的？是有人坐在那儿盯着看谁在聊天吗？

---

### [00:24:08] Sri Batchu

**English:**
No, it must be some tool our IT team can do it. It can say what percentage of participants chatted or something like that.

**中文翻译:**
不，应该是我们 IT 团队使用的某种工具。它可以显示有多少比例的参与者发过言之类的。

---

### [00:24:15] Lenny

**English:**
I see. So it's not like who's looking at the screen, it's like who's talking in the chat?

**中文翻译:**
明白了。所以不是看谁在盯着屏幕，而是看谁在聊天框里说话？

---

### [00:24:18] Sri Batchu

**English:**
Yeah, exactly. Or reacting in the chat, et cetera.

**中文翻译:**
对，没错。或者是发表情互动等等。

---

### [00:24:21] Lenny

**English:**
That's awesome. And it's not like you must engage, it's more just like are we delivering the content.

**中文翻译:**
太棒了。这并不是强制要求互动，更多是衡量“我们提供的内容是否吸引人”。

---

### [00:24:26] Sri Batchu

**English:**
No. And by the way, this is probably the first time I'm sharing this. I don't think brand employees necessarily know this. I don't think we've actually shared this. I just heard it from our IT person recently and I thought that was a fun stat.

**中文翻译:**
是的。顺便说一下，这可能是我第一次分享这个。我不认为 Ramp 的员工一定知道这件事，我们其实还没公开分享过。我最近刚从 IT 人员那里听说，觉得这是个很有趣的数据。

---

### [00:24:38] Lenny

**English:**
I love that because it's more just like are we providing value to people or are they actually excited and interested in this sort of thing? I was going to add onto your point about how working hard and working long hours can be seen as this like, "Oh, this sucks. I wish I was at home watching Netflix," but I find that the most fulfilling parts of my career or where I was just working insanely hard for a long time, as long as that work was meaningful, exactly like you said, it was something that mattered and came out and shipped and people were excited about it and if it wasn't like, "Oh, that was a waste of my life." So that super resonates.

**中文翻译:**
我喜欢这个点，因为它更多是关于“我们是否在为员工提供价值”，或者“他们是否真的对这些事情感到兴奋和感兴趣”。我想补充一下你关于努力工作的观点。长时间工作常被看作是“噢，这太糟了，我真想在家看 Netflix”，但我发现我职业生涯中最有成就感的部分，往往是我长时间疯狂工作的时候——只要那份工作是有意义的。正如你所说，只要那是重要的、能发布出来的、能让人们兴奋的事情，而不是那种让你觉得“噢，这简直是在浪费生命”的事情。这让我非常有共鸣。

---

### [00:25:09] Sri Batchu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:25:10] Lenny

**English:**
I want to come back to growth for a moment. I had a couple more questions I wanted to ask here. You talked about some of these teams that you have around ways you're driving growth. Is there an area you think you're going to be investing more in over time or that you feel is working better? I know there's trade secrets here that you don't want to share necessarily, but just anything that you feel is people are maybe under-appreciating or under-investing in that you think you might invest in more?

**中文翻译:**
我想回到增长的话题。我还有几个问题。你提到了你们驱动增长的一些团队。有没有哪个领域是你认为随着时间的推移会加大投入的，或者你觉得效果更好的？我知道这里面涉及商业机密，你不一定想分享，但有没有什么你觉得大家可能低估了或投入不足、而你认为值得更多投入的领域？

---

### [00:25:34] Sri Batchu

**English:**
What I'll say on that front is, look, we, like everybody else, are always focused on driving more efficiency in our growth engine. There are some channels that, and we have a diversified portfolio of bets, right? One thing that's interesting about the world of growth today is I think historically people that used to run growth were folks that had a marketing or a product background. And what you're seeing these days I think are more folks like me who actually come from an investor and analytics background to lead growth teams because growth has become more and more about a diversified portfolio of bets at a reasonable ROI and building a system that's designed around experimentation and data-oriented.

**中文翻译:**
关于这一点，我想说的是，和所有人一样，我们始终专注于提高增长引擎的效率。我们拥有一个多元化的“赌注组合”。当今增长领域一个有趣的现象是：过去负责增长的人通常具有营销或产品背景。而现在，你会看到越来越多像我这样具有投资和分析背景的人在领导增长团队。因为增长已日益演变为在合理的投资回报率（ROI）下进行多元化的赌注组合，并构建一个围绕实验和数据导向的体系。

---

### [00:26:22] Sri Batchu

**English:**
So the reason I say all of that is our goal is to over time, of course, make all of our channels more efficient, but also allocate more to channels that are more efficient as long as they're scalable. And so the more that we can push customer awareness via owned and earned media, the better for us. And so we've got a few different strategies on that front, but we're also working on making our other channels more efficient by the day.

**中文翻译:**
我之所以说这些，是因为我们的目标当然是随着时间的推移让所有渠道都更高效，但同时也会向那些更高效且具备可扩展性的渠道分配更多资源。因此，我们越能通过自有媒体（owned media）和赚得媒体（earned media，如口碑、报道）来提升客户认知，对我们就越有利。在这方面我们有几种不同的策略，同时我们也在致力于让其他渠道日益高效。

---

### [00:26:54] Lenny

**English:**
So mysterious, but I appreciate you sharing what you can. The point about the portfolio of bets is interesting because if you think about it, most companies initially grow from one. You talked about growth engines, that's the same term I use. Usually there's just one thing that helps you grow initially like SEO or word of mouth or maybe paid. And then eventually every single company basically ends up doing all the growth channels and then has a team dedicated to just keep optimizing SEO, keep optimizing referrals. So I think that's a very typical path. And then it's exactly said, how do we make each of these as efficient as possible?

**中文翻译:**
真神秘，但我很感谢你分享了能分享的部分。关于“赌注组合”这一点很有趣，因为如果你仔细想想，大多数公司最初都是靠单一渠道增长的。你提到了“增长引擎”，这也是我用的词。通常最初只有一件事能帮你增长，比如 SEO、口碑或者付费广告。最终，几乎每家公司都会尝试所有的增长渠道，并设有专门的团队来持续优化 SEO、优化推荐机制等。我认为这是一条非常典型的路径。然后就像你说的，关键在于如何让每一个渠道都尽可能高效。

---

### [00:27:28] Sri Batchu

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:27:29] Lenny

**English:**
Maybe as another last question around Ramp's growth. Is there any other just really surprising, interesting, really effective tactics that helped Ramp grow over time?

**中文翻译:**
关于 Ramp 的增长，最后一个问题：还有没有其他非常令人惊讶、有趣且极其有效的策略，在过去这段时间里帮助了 Ramp 的增长？

---

### [00:27:41] Sri Batchu

**English:**
I think one thing that's been interesting is Ramp's ability to leverage PR as a growth machine. And as you've seen, we've got a fantastic PR and comms team and we get a lot of deserved good press through that. And one thing that's been interesting is our fundraising also as a growth strategy not obviously explicitly we've got very clear goals for our fundraising, but what we have seen is anytime that we've been fundraising and we've been using that as an effective way of creating a market moment, it's driven actually a non-trivial amount of top funnel for us.

**中文翻译:**
我认为很有趣的一点是 Ramp 将公关（PR）作为增长机器的能力。如你所见，我们有一支非常出色的 PR 和沟通团队，我们也因此获得了很多应得的正面报道。另一件有趣的事是，我们的融资也被当作一种增长策略——虽然融资本身有非常明确的财务目标，但我们发现，每当我们融资并将其作为创造“市场时刻”的有效手段时，它实际上为我们带来了相当可观的漏斗顶端（top funnel）流量。

---

### [00:28:22] Lenny

**English:**
People always talk about PR being like, people over overinvest in PR, they think PR is going to be this magical growth lever, but it actually works sometimes and in my opinion, you have to have something really interesting for it to work and obviously you guys do, the company's growing like crazy, which is innately an interesting story. The founders are really important and rarely is funding like an event anymore for most companies. So I mean this says a lot that people care about your funding.

**中文翻译:**
人们总说大家在 PR 上投入过度，总觉得 PR 会是一个神奇的增长杠杆，但它有时确实有效。在我看来，PR 要奏效，你必须有真正有趣的东西，而你们显然有——公司增长得像疯了一样，这本身就是一个有趣的故事。创始人也非常关键。而且现在对大多数公司来说，融资已经不再算是什么大新闻了。所以，人们关心你们的融资，这本身就很说明问题。

---

### [00:28:51] Sri Batchu

**English:**
What you say it is exactly right is you have to be thoughtful about your PR moments. Everybody wants to announce things about themselves that's not necessarily interesting for the press or for an audience. And so thinking about how do you compile enough value to the general audience. So our fundraising announcements usually also have some additional color on something unique about the business that we share to provide more value to readers.

**中文翻译:**
你说的完全正确，你必须深思熟虑地选择 PR 时机。每个人都想发布关于自己的消息，但那些消息对媒体或受众来说不一定有趣。所以要思考如何为普通受众提供足够的价值。因此，我们的融资公告通常还会包含一些关于业务独特性的额外信息，通过分享这些内容为读者提供更多价值。

---

### [00:29:20] Lenny

**English:**
And then there's also newsletter people like me and Packy you mentioned who wrote about Ramp because it's also just so interesting. What's your sense of that versus traditional PR? There's this, I don't know, big debate of just traditional media's no longer relevant. All these other people will go through newsletters and podcasts and things like that. What's your sense there?

**中文翻译:**
还有像我这样的时事通讯作者，以及你提到的 Packy，我们写 Ramp 是因为这事儿太有意思了。你觉得这种形式与传统 PR 相比如何？现在有一个大争论，说传统媒体不再重要了，大家都会通过时事通讯、播客之类的渠道获取信息。你怎么看？

---

### [00:29:38] Sri Batchu

**English:**
It's what are the audiences that you get with each of these tactics. And so we do both obviously get some earned coverage in these newsletters and other tactics and we pay for some and we advertise in other cases. And what we tend to find is these are great reach, but they tend to work very well for actually hiring. It improves Ramp's reputation as a company for recruiting and hiring, which helps and they help with certain audience of customers, which is typically tech founders and folks close to the tech ecosystem. But as I mentioned, the vast majority of the world is not startups and the majority of Ramp's customers are no longer tech and startups. And so as we're thinking about ways to grow. I think channels like these are one piece of the equation, but I think traditional PR will remain another really important piece because they just target a different audience.

**中文翻译:**
这取决于你通过每种策略触达的受众是谁。显然我们两者都做——我们在这些时事通讯和其他渠道中获得一些免费报道，有时也会付费投放广告。我们发现，这些渠道的触达效果很好，但它们对“招聘”特别有效。它提升了 Ramp 作为一家公司的声誉，有助于招人；同时它们也能触达特定的客户群体，通常是科技创始人以及接近科技生态系统的人。但正如我提到的，世界上绝大多数公司并不是初创公司，Ramp 的大多数客户也不再是科技初创公司。所以当我们思考增长方式时，这类渠道只是方程式的一部分，传统 PR 依然是另一个非常重要的部分，因为它们针对的是不同的受众。

---

### [00:30:38] Lenny

**English:**
As you're talking, I'm watching the days count up on the days that Ramp page still and stressing me out. I feel like keeping you from doing work to keep growing Ramp, but let's keep going. I'm going to close this tab. You talked about growth engines. I'm curious what you've learned about building a growth engine in a company. And another way to put it is just a repeatable scalable growth process, whether it's at Ramp or Opendoor, Instacart,

**中文翻译:**
你说话的时候，我还在盯着 Ramp 那个天数统计页面，看着数字不断跳动，搞得我压力好大。我觉得我耽误了你工作，耽误了 Ramp 的增长，咱们继续吧，我要关掉那个标签页了。你谈到了增长引擎。我很想知道你在公司构建增长引擎方面学到了什么。换句话说，就是一种可重复、可扩展的增长流程，无论是在 Ramp、Opendoor 还是 Instacart。

---

### [00:31:03] Sri Batchu

**English:**
People talk a lot about what should the right design of the team be or profiles of people on the team, et cetera. And I'm happy to talk about what are the right profiles of people. I think that's an important conversation. But I think design of the team, people often... I think it's a red herring about team structure and team design and what's the right one, et cetera. I think most of that is irrelevant. What actually matters is culture and rituals and cadences rather than the team itself.

**中文翻译:**
人们经常讨论团队应该如何设计，或者团队成员应该是什么样的背景等等。我很乐意聊聊合适的人才画像，那确实很重要。但我认为关于团队结构和设计的讨论往往是“红鲱鱼”（误导性信息）。我觉得大部分结构问题并不重要，真正重要的是文化、仪式感和节奏，而不是团队结构本身。

---

### [00:31:35] Sri Batchu

**English:**
And so what a great growth engine and a great growth team is one that where you set the culture, set very simple north star metrics, usually one, at most two. And you've created a culture of defining hypotheses that are data driven and a culture where that can be executed quickly and have an MVP mentality for product and non-product projects where people can fail and learn quickly and iterate quickly. So I think that part of it is more important than the specific people or their functions in many ways to me, especially when you're starting to build a growth engine. It's like can you build a set of people that can generate new ideas and evaluate them effectively and move quickly is really what you're trying to design for.

**中文翻译:**
因此，一个优秀的增长引擎和增长团队，是那种你设定了文化、设定了非常简单的北极星指标（通常一个，最多两个）的团队。你创造了一种基于数据定义假设的文化，一种能够快速执行的文化，并且对产品和非产品项目都持有 MVP（最小可行性产品）心态，让人们能够快速失败、快速学习并快速迭代。对我来说，在很多方面，这部分比具体的人选或职能更重要，尤其是在开始构建增长引擎时。你真正想要设计的，是能否建立一群能够产生新想法、有效评估并快速行动的人。

---

### [00:32:29] Lenny

**English:**
Let's unpack some of this because this is great. So in terms of north star metrics, what are some examples in your experience of good north star metrics? Revenue is obviously a very common one, but often it is too high level. Do you have a sense of what a good north star metric is?

**中文翻译:**
我们来拆解一下，这太棒了。关于北极星指标，根据你的经验，有哪些好的例子？收入显然很常见，但通常太宏观了。你觉得什么是好的北极星指标？

---

### [00:32:43] Sri Batchu

**English:**
I like having two. One is something around volume and growth and you want that to be, A, very motivating and intuitive for people to understand and also, B, something that the growth teams can directly impact, right? Revenue is, for better or worse, more important to the company, but also much farther down the line of whether or not the growth team can impact that. And so at Instacart, for example, our north star metric for growth was monthly active orders. And that's what we all rallied around and looked at every day, how are now doing? And then obviously we had a large growth in consumer engineering team at Instacart, 300 plus people. And so there are people working on every single corner of the app and outside of the app on acquisition to drive growth. And it's like some of the stuff is minutia, right? It's making the checkout flow slightly better or faster or something like that.

**中文翻译:**
我喜欢设定两个指标。一个是关于规模和增长的，你希望它：A，非常具有激励性且直观，让大家都能理解；B，增长团队能够直接影响。无论好坏，收入对公司来说更重要，但它处于增长团队能否直接影响的下游。例如在 Instacart，我们的增长北极星指标是“月活跃订单量”（MAO）。这是我们所有人团结一致并每天关注的指标：我们现在做得怎么样？当时我们在 Instacart 有一支庞大的增长和消费者工程团队，超过 300 人。有人负责 App 的每一个角落，也有人负责外部的获客。有些工作非常细碎，比如让结账流程稍微好一点或快一点。

---

### [00:33:42] Sri Batchu

**English:**
So that's a good example. It's like, okay, well, so we're going to goal that team on MAO, how are they going to move monthly active orders by making the checkout flow slightly better? Maybe they can have an impact or maybe not. And so one of the things that we did is the actual local team has their own metric that they can directly influence. You want to actually hold people accountable for things that they can influence. And then we created via the finance and data team, a translation layer for every team's metric into MAO.

**中文翻译:**
这是一个很好的例子。如果我们要让那个团队对 MAO 负责，他们怎么通过优化结账流程来影响月活跃订单量呢？也许有影响，也许没有。所以我们做的一件事是：让具体的执行团队拥有他们能直接影响的指标。你必须让人们对他们能掌控的事情负责。然后，我们通过财务和数据团队，为每个团队的指标创建了一个转换到 MAO 的“翻译层”。

---

### [00:34:13] Sri Batchu

**English:**
It would be like if you got one extra weekly order because of your checkout flow from the same customer, it would have point X impact on the company's MAO and then you would just roll up all project plans as well as project impact back into this singular MAO metric. And the other benefit of doing something like that is that it also helps you cross-prioritize much easier. Should we add more engineering to this team? Should we add more budget to that team? It's like, okay, well what's the MAO map? Where is there a more MAO per dollar or per engineer being built? And it just really helped us unify and move together.

**中文翻译:**
比如，如果你因为优化了结账流程，让同一个客户每周多下了一个订单，那么它对公司 MAO 的影响就是 0.X。然后你会将所有项目计划和项目影响都汇总到这个单一的 MAO 指标中。这样做另一个好处是，它让交叉优先级排序变得容易得多。我们应该给这个团队增加工程师吗？应该给那个团队增加预算吗？看看 MAO 映射图就知道了：哪里每投入一美元或每个工程师能产生更多的 MAO？这真的帮助我们统一思想，共同前进。

---

### [00:34:52] Lenny

**English:**
I have questions about this. This is great. By the way, why is it monthly active orders versus just monthly orders? How can you be an inactive order?

**中文翻译:**
我对此有疑问。这太棒了。顺便问一下，为什么是“月活跃订单量”而不是“月订单量”？订单怎么会有“不活跃”的？

---

### [00:35:00] Sri Batchu

**English:**
Sorry, orderer.

**中文翻译:**
抱歉，是“月活跃下单用户”。

---

### [00:35:02] Lenny

**English:**
Oh, okay.

**中文翻译:**
噢，好的。

---

### [00:35:03] Sri Batchu

**English:**
So monthly active users basically is what it is, but we call them orders because users can just log in and not order, right.

**中文翻译:**
基本上就是“月活跃用户”，但我们称之为“下单者”，因为用户可能只是登录而不下单，对吧。

---

### [00:35:08] Lenny

**English:**
Got it.

**中文翻译:**
明白了。

---

### [00:35:09] Sri Batchu

**English:**
You're actually ordering on the platform.

**中文翻译:**
他们是在平台上真正下单的人。

---

### [00:35:11] Lenny

**English:**
Yeah, I think there was this backlash against users at Facebook. I think it's monthly active people and so I get it. Okay, understood. Interesting. So you find that instead of sub-teams having a different metric that we just know is good. That's one of the variables in the formula of monthly active orders. You actually have a translation that converts that specific metric moving to the north star metric.

**中文翻译:**
是的，我记得 Facebook 之前也对“用户”这个词有抵触，改成了“月活跃人数”，我理解了。很有趣。所以你发现，与其让子团队拥有一个我们公认是好的不同指标（作为 MAO 公式中的变量之一），不如建立一个转换机制，将该特定指标的变动直接折算成北极星指标。

---

### [00:35:36] Sri Batchu

**English:**
The team on their day-to-day for their sprints, whatever are looking at their own metric. But for the purpose of planning and resource allocation and reporting, we would use the translation layers to actually just look at everything on a MAO basis.

**中文翻译:**
团队在日常冲刺中关注的是他们自己的指标。但为了规划、资源分配和汇报，我们会使用翻译层，统一以 MAO 为基准来审视所有工作。

---

### [00:35:49] Lenny

**English:**
Knowing those sorts of formulas are often not perfect, how much weight do you put into that formula specifically?

**中文翻译:**
考虑到这类公式通常并不完美，你具体会给这个公式多少权重？

---

### [00:35:56] Sri Batchu

**English:**
Yeah. And I think in general the planning process is not perfect. You can have a financial plan in Excel and the reality can diverge quite a bit. The only thing you can be certain of is that you're not going to accomplish exactly the plan. So we did a couple of things to that. One is setting a culture of we know this isn't perfect, this is like 70/30, 80/20, it's to guide. So we wouldn't use the translation factor to make a marginal decision if something is five or 10% off.

**中文翻译:**
是的。我认为总的来说，规划过程是不完美的。你可以在 Excel 里做一个财务计划，但现实可能会有很大偏差。唯一能确定的就是你不可能完全按计划实现。所以我们做了几件事：一是建立一种文化，即我们知道这不完美，它大概是 70/30 或 80/20 的准确度，主要是起引导作用。因此，如果某项决策只有 5% 或 10% 的差别，我们不会仅靠转换系数来做边际决策。

---

### [00:36:29] Sri Batchu

**English:**
Those are done based on judgment because at the end of the day, regardless of what metric framework you use, marginal decisions are marginal for a reason. They're really hard things to decide. And so the framework helped with just reducing the cognitive overload of decision making to only those that are marginal. So the ones that are obvious that are going to have big impact becomes clear even if the measurement framework isn't perfect. And so that's what we use. And the other thing that we just had as cadence is we would actually update all of the translations every six months for the new planning cycle based on new information that we knew on how moving X impacts MAO.

**中文翻译:**
那些决策是基于判断做出的，因为归根结底，无论你使用什么指标框架，边际决策之所以是边际的，是因为它们真的很难决定。这个框架的作用是减少决策时的认知负荷，让我们只需关注那些边际案例。对于那些显而易见会有巨大影响的项目，即使衡量框架不完美，结论也是清晰的。这就是我们的用法。另一件事是我们的节奏：我们每六个月会根据关于“移动 X 如何影响 MAO”的新信息，为新的规划周期更新所有的转换系数。

---

### [00:37:10] Lenny

**English:**
Just to make it even more real, what are some examples of those lower level metrics? Is it increased conversion of sign up by X percent?

**中文翻译:**
为了更具体一点，那些底层指标有哪些例子？是“注册转化率提高 X%”吗？

---

### [00:37:17] Sri Batchu

**English:**
Any number of things. It would be actually load time of the app on open. There's a team that's trying to make that faster or more efficient because we know that that impacts whether or not the person actually ends up ordering if it takes five seconds to load versus two seconds to load. And so the full customer experience were all segregated into different teams that were optimizing just like how long does it take to open, number of searches that a user does on the app. We know the people... And number of items that are put into cart, like amount of time from cart to check out, things like that we literally just map out any user's journey throughout the app and have separate engineering teams that are focused on that.

**中文翻译:**
各种各样。实际上包括 App 打开时的加载时间。有一个团队专门负责让加载更快，因为我们知道，如果加载需要 5 秒而不是 2 秒，会直接影响用户最终是否下单。所以整个客户体验被拆分给不同的团队，分别优化诸如打开时长、用户在 App 上的搜索次数等。我们知道……还有加入购物车的商品数量、从购物车到结账的时间等等。我们基本上映射出了用户在 App 中的完整旅程，并设有专门的工程团队专注于每一个环节。

---

### [00:38:04] Lenny

**English:**
And there's essentially some kind of regression analysis that tells you here's load times impact on MAOs.

**中文翻译:**
所以基本上会有某种回归分析告诉你，加载时间对 MAO 的具体影响。

---

### [00:38:10] Sri Batchu

**English:**
Exactly. And the other thing that we did is just so we would've these translation factors, but we could also just see what the cumulative impact of all of the work is that Facebook did this too, which is just long-term holdouts for each surface area. So the checkout experience team that I've been talking about a lot for some reason would have their own holdout. And so we could see what the cumulative impact of monthly active orders on the people that got last half's experience versus this half's experience on the holdout. And that would make it very clear. So regression is one way to do it. And then basically effective A/B test, but was a small holdout.

**中文翻译:**
没错。我们做的另一件事是，除了这些转换系数，我们还会观察所有工作的累积影响——Facebook 也这么做，就是针对每个功能区域设置“长期对照组”（long-term holdouts）。比如我刚才一直提到的结账体验团队，他们会有自己的对照组。这样我们就能看到，在对照组中，体验上一半版本的人与体验这一半版本的人在月活跃订单量上的累积差异。这会让结果非常清晰。所以，回归分析是一种方法，另一种基本上就是有效的 A/B 测试，只是用了一个很小的对照组。

---

### [00:38:46] Lenny

**English:**
Is there a holdout for the performance team where someone just has a really slow version of Instacart?

**中文翻译:**
性能团队也有对照组吗？就是让某些人一直用着一个特别慢的 Instacart 版本？

---

### [00:38:51] Sri Batchu

**English:**
I wonder actually, but there's holdout for almost everything. There's a holdout for ads, for example. So there are some lucky Instacart users out there that are not getting ads and they've never gotten ads because they've always been part of Instacart's advertising holding.

**中文翻译:**
我也在想，但几乎所有东西都有对照组。比如广告就有对照组。所以有一些幸运的 Instacart 用户是看不到广告的，而且从来没看过，因为他们一直被分在 Instacart 广告业务的对照组里。

---

### [00:39:08] Lenny

**English:**
That'll be a great revenue boost whenever they want to kill that holdout.

**中文翻译:**
等他们哪天想取消那个对照组时，收入肯定会大涨。

---

### [00:39:13] Sri Batchu

**English:**
Can you imagine was a conversation internally on should there be a permanent holdout? Should it be last year's experience? How should we think about, especially because it's such a important driver of modernization?

**中文翻译:**
你能想象内部关于是否应该设立永久对照组的讨论吗？应该是去年的体验吗？我们该如何思考这个问题，尤其是考虑到它是变现（modernization）如此重要的驱动力？

---

### [00:39:24] Lenny

**English:**
This episode is brought to you by Eppo. Eppo's a next generation A/B testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern growth team stack. This leads to waste of time building internal tools or trying to run your own experiments through a clunky marketing tool.

**中文翻译:**
本集由 Eppo 为您呈现。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。DraftKings、Zapier、ClickUp、Twitch 和 Cameo 等公司都依赖 Eppo 来驱动他们的实验。无论您在哪里工作，运行实验都变得越来越重要，但目前还没有能与现代增长团队技术栈无缝集成的商业工具。这导致人们要么浪费时间构建内部工具，要么试图通过笨重的营销工具来运行实验。

---

### [00:39:51] Lenny

**English:**
When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more delivering results quickly, avoiding knowing prolonged analytic cycles and helping you easily get to the root cause of any issue you discover. EPO lets you go beyond basic clickthrough metrics and instead use your north star metrics like activation, retention, subscription and payments. Eppo supports, test on the front end, on the backend, email marketing, even machine learning claims. Check out Eppo at getE-P-P-O.com. That's geteppo.com and 10X your experiment velocity.

**中文翻译:**
当我在 Airbnb 时，我最喜欢的工作内容之一就是我们的实验平台，我可以在那里按设备类型、国家、用户阶段对数据进行切片分析。Eppo 具备所有这些功能，甚至更多，它能快速交付结果，避免漫长的分析周期，并帮助您轻松找到发现的任何问题的根本原因。Eppo 让您超越基本的点击率指标，转而使用您的北极星指标，如激活、留存、订阅和支付。Eppo 支持前端、后端、电子邮件营销甚至机器学习声明的测试。请访问 getE-P-P-O.com 了解 Eppo。即 geteppo.com，让您的实验速度提升 10 倍。

---

### [00:40:31] Lenny

**English:**
Maybe just one last question along this specific thread is this framework of having everything translated into a north star metric something you bring to every place you work now? And is this just something you recommend? For example, does Ramp approach things this way as well?

**中文翻译:**
关于这个话题的最后一个问题：这种“将一切转换为北极星指标”的框架，是你现在每到一个地方工作都会带去的吗？这是你推荐的做法吗？例如，Ramp 也是这样处理问题的吗？

---

### [00:40:44] Sri Batchu

**English:**
I think it depends on the size of the company. I think this actually becomes much more important as companies get bigger because there's more teams to prioritize and more resources to cross-allocate. And having a common currency makes that a lot easier. And so we do something similar at Ramp as well where we have translation factors for all of the various things that the teams are doing that translate back to the north star for Ramp.

**中文翻译:**
我认为这取决于公司的规模。随着公司变大，这实际上变得越来越重要，因为有更多的团队需要排序优先级，有更多的资源需要交叉分配。拥有“通用货币”会让这一切变得容易得多。所以我们在 Ramp 也在做类似的事情，我们为团队正在做的各种事情设定了转换系数，最终折算回 Ramp 的北极星指标。

---

### [00:41:07] Lenny

**English:**
Cool. And then are you up for sharing the Ramp's north star metric or do you want to keep that part?

**中文翻译:**
酷。那你愿意分享 Ramp 的北极星指标吗，还是想保密？

---

### [00:41:12] Sri Batchu

**English:**
Yeah, I mean I can tell you what we used to do in the recent past we're evolving some things and in the recent past it was for the growth team, the north star was dollars of SQL pipeline. So anything anybody did, we would try to estimate the impact into what would be the dollars of sales qualified lead pipeline generated for Ramp. So if the website team wanted to change language on the card's landing page, their direct impact would be conversion rate of email submission or something like that would be what they would be optimizing for. And then we would have, okay, what does two bips of conversion rate mean for dollars of SQL pipeline? A lot or not a lot? And depending on that, it's like, "All right, don't waste your time doing that project. Let's do something else instead." So that just helps us score and prioritize efforts.

**中文翻译:**
我可以告诉你我们最近的做法（我们正在演进一些东西）。在最近这段时间，增长团队的北极星指标是“SQL 漏斗金额”（销售合格线索的金额）。因此，无论任何人做任何事，我们都会尝试估算其对 Ramp 产生的销售合格线索（SQL）漏斗金额的影响。比如，如果网站团队想修改信用卡落地页的文案，他们的直接影响可能是电子邮件提交的转化率。然后我们会计算：转化率提升两个基点（bips）意味着多少 SQL 漏斗金额？是很多还是很少？根据结果，我们可能会说：“好吧，别在这个项目上浪费时间了，我们去做别的。”这能帮助我们对各项工作进行评分和优先级排序。

---

### [00:42:03] Lenny

**English:**
Here's a fun story. I actually tried to sign up for Ramp when I was starting this newsletter and business and it didn't let me because I had a Gmail-

**中文翻译:**
这有个有趣的故事。我刚开始做这个时事通讯和业务时，曾尝试注册 Ramp，但它没让我注册，因为我用的是 Gmail——

---

### [00:42:09] Sri Batchu

**English:**
For Gmail, yeah.

**中文翻译:**
因为是 Gmail，是的。

---

### [00:42:13] Lenny

**English:**
So I moved on and that would've been such a huge revenue opportunity. I'm just joking.

**中文翻译:**
所以我只好放弃了，那本该是一个巨大的收入机会。开个玩笑。

---

### [00:42:18] Sri Batchu

**English:**
I know, I know. And I'm glad you brought that up because we are obviously aware of it and we are working on something for users that have put in a personal email address. in terms of how to reengage that.

**中文翻译:**
我知道，我知道。很高兴你提到这个，因为我们显然意识到了这个问题，我们正在针对输入个人邮箱地址的用户开发一些功能，研究如何重新吸引他们。

---

### [00:42:30] Lenny

**English:**
You're about to 5X growth because I had no other domain at that point. Now I have Lenny's newsletter and stuff, so it's like, "Shit, I'm stuck."

**中文翻译:**
你们的增长快要翻 5 倍了，因为我当时没有别的域名。现在我有 Lenny's newsletter 之类的了，所以感觉就像，“该死，我被卡住了。”

---

### [00:42:39] Sri Batchu

**English:**
By the way, for anybody else that has that problem, they can just reach out to me, we'll figure it out. The reason we don't allow personal emails is because it's just typically very low in tech users that are coming to the website that are putting in personal emails.

**中文翻译:**
顺便说一下，如果其他人也有这个问题，可以直接联系我，我们会解决的。我们不允许个人邮箱的原因是，通常来到网站并输入个人邮箱的用户，其意向度（intent）往往非常低。

---

### [00:42:51] Lenny

**English:**
Makes sense. I totally get it. I was not offended. I just like, all right. I had no way around it. That's the problem. So I like that you guys are adding some path around it and you're saying email you or reach out to you.

**中文翻译:**
有道理。我完全理解，并没有觉得被冒犯。我只是觉得，好吧，我没法绕过它，这就是问题所在。所以我很高兴你们正在增加一些解决路径，而且你说可以给你发邮件或联系你。

---

### [00:43:02] Sri Batchu

**English:**
You can find me on Twitter or email me. I'm just as sribatchu@ramp.

**中文翻译:**
你可以在 Twitter 上找到我，或者给我发邮件。我的邮箱是 sribatchu@ramp。

---

### [00:43:06] Lenny

**English:**
All right. You're going to have the most sales leads of any person at Ramp when this comes up. Okay. One other thing I wanted to touch on is success metrics. You talked about one of the keys to success and this repeatable growth engine is clear success metrics. Is there any just learnings and tips you have for people when they're thinking about success metrics?

**中文翻译:**
好极了。这期节目播出后，你可能会成为 Ramp 获得销售线索最多的人。好，我还想谈谈“成功指标”。你提到成功的关键之一以及这个可重复增长引擎的核心是清晰的成功指标。关于人们在思考成功指标时，你有什么心得和建议吗？

---

### [00:43:26] Sri Batchu

**English:**
Finding the right success metric, there usually should be two. There should be one on volume and another one on efficiency. And we can talk about what are good efficiency metrics and what are good volume metrics. On volume, I think the right success metric has a couple things that are important. One is there's a clear linkage to value creation for the business. So if I move this metric that will drive revenue and which will drive equity value for the business or whatever it is that this particular. Metrics and for Facebook it was MAU, for Instacart, it was effectively monthly active orders, and it's something that we know is important that will really drive the value for the business, but it needs to have the other component of it, which is it's very intuitive for all of the people working internally to the company.

**中文翻译:**
寻找正确的成功指标，通常应该有两个：一个关于“规模”（volume），另一个关于“效率”（efficiency）。我们可以聊聊什么是好的效率指标和规模指标。关于规模，我认为正确的成功指标有几个要点：第一，与业务价值创造有明确的联系。也就是说，如果我提升了这个指标，它会驱动收入，进而驱动公司的股权价值。对于 Facebook 来说是 MAU，对于 Instacart 来说实际上是月活跃订单量。这是我们知道的能真正驱动业务价值的重要因素。但它还需要另一个要素：对于公司内部的所有工作人员来说，它必须是非常直观的。

---

### [00:44:17] Sri Batchu

**English:**
And it's also clear, if they're working on some minutiae, how that can impact and actually move the main metric. So it's usually you have to find something that's somewhere in between, not too far, too lag, towards revenue and value creation, but also not something that's actually translatable to the efforts of various teams.

**中文翻译:**
而且必须清晰地显示，如果他们在做一些细微的工作，那将如何影响并最终推动主指标。所以通常你必须找到一个中间地带：既不能离收入和价值创造太远（太滞后），又要能与各个团队的努力相挂钩。

---

### [00:44:39] Lenny

**English:**
Is there an example of a good success metric that just comes to mind to make this a little bit concrete for people?

**中文翻译:**
有没有什么好的成功指标的例子，能让大家听起来更具体一点？

---

### [00:44:44] Sri Batchu

**English:**
It just depends on what goal at any given time is. Sometimes you're trying to drive more users, sometimes you're trying to drive more engagement and you can reorient the company on what you're trying to do as the north star for growth during that period of time. So users, obviously we've talked about as a good one. For engagement, I've often found what really helps is, and you've done actually really good benchmarking at some point, the escape velocity metric for growth for a company, I think.

**中文翻译:**
这取决于任何特定时期的目标是什么。有时你想增加用户，有时你想增加参与度，你可以根据那个阶段的增长北极星指标来重新调整公司的方向。用户数显然是一个很好的指标。对于参与度，我发现非常有帮助的是——你之前也做过非常棒的基准测试——我称之为公司的“逃逸速度指标”（escape velocity metric）。

---

### [00:45:15] Sri Batchu

**English:**
I don't think you phrased it that way, but that's [inaudible 00:45:18] for a given user, which is what does it take for somebody to become an engaged and active user or customer of a platform? And at Facebook, it was 10 friends the first seven days. At Instacart, it was three orders in the first month. And at Ramp, for our activation, I mean it's very specific to Ramp, but we've got four events that the customer needs to do in the first 30 days. And if they do that, they have a high likelihood of being activated and successful. So our activation team focuses on that.

**中文翻译:**
我不记得你是不是这么称呼它的，但它指的是针对特定用户，需要发生什么才能让他们成为平台的深度活跃用户或客户？在 Facebook，是“前 7 天加 10 个好友”；在 Instacart，是“第一个月下 3 笔订单”；而在 Ramp，对于我们的激活指标（这是 Ramp 特有的），我们设定了客户在头 30 天内需要完成的 4 个事件。如果他们做到了，他们就有极高的概率被激活并获得成功。所以我们的激活团队就专注于此。

---

### [00:45:49] Lenny

**English:**
The framework you just described reminds me Gibson Biddle has this really simple framework of gem where you can basically prioritize one of three things, growth, engagement, or monetization. And his advice is always just all of them are great, just make sure you're all aligned on which one matters most at the time.

**中文翻译:**
你刚才描述的框架让我想起了 Gibson Biddle 的那个非常简单的 GEM 框架，即你基本上可以在增长（Growth）、参与（Engagement）或变现（Monetization）这三者中优先选择一个。他的建议总是：这三者都很棒，只要确保你们在特定时间内对哪一个最重要达成一致即可。

---

### [00:46:06] Sri Batchu

**English:**
Yeah. And it is very similar to, we used to have this at Opendoor, and I think DoorDash also uses a similar framework, which is speed, quality, and cost. All three are important, but it's very hard to optimize all three at the same time. So you need to have a particular prioritization. And I think growth teams can also use that as, okay, I think the way I about the growth team's journey is step one is build a system that can move fast and then work on improving the quality and then work on optimization of cost after. So you pick which phase you're on because you can't do all three at the same time, whether it's growth, engagement, monetization, or just the other way of framing on it.

**中文翻译:**
是的。这非常类似于我们在 Opendoor 曾使用的框架，我想 DoorDash 也在用类似的框架，即：速度、质量和成本。这三者都很重要，但很难同时优化。所以你需要有一个特定的优先级。我认为增长团队也可以借鉴：增长团队旅程的第一步是建立一个能快速运转的系统，然后致力于提高质量，最后再进行成本优化。你得选好自己处于哪个阶段，因为你无法同时兼顾三者，无论你是用增长、参与、变现来划分，还是用其他方式来界定。

---

### [00:46:49] Lenny

**English:**
Speaking of metrics, I have this note here that you're a big fan of payback period for measuring investment ROI versus CAC. Can you talk about why that is?

**中文翻译:**
说到指标，我这里记了一笔，说你非常推崇用“回本周期”（payback period）而不是 CAC（获客成本）来衡量投资回报率（ROI）。你能谈谈为什么吗？

---

### [00:47:02] Sri Batchu

**English:**
Yeah. CAC obviously gets thrown around a lot and a lot of people are like, "Okay, you have to be reducing your CAC, CAC, CAC, CAC." There's a fundamental flaw to it which obviously is that you're focusing on cost and not the value derived. And so when you focus on CAC and reducing CAC, what tends to happen is you actually might be doing something very damaging where you're succeeding in reducing CAC, but you're actually bringing in customers that are less valuable because those are the ones that you're able to attract with a lower CAC. And so reframing it away from CAC towards LTV is helpful and that's better. So thinking about for better customers that are bigger, we want to spend more. So you might think, okay, well, LTV to CAC might be a better way of looking at that. I think the challenge with LTV to CAC especially for a lot of, even Ramp, it's only four years old, is it's really hard to predict LTV.

**中文翻译:**
是的。CAC 显然被讨论得太多了，很多人会说：“好吧，你必须降低你的 CAC、CAC、CAC。”但它有一个根本性的缺陷，那就是你只关注成本而忽视了产生的价值。当你专注于降低 CAC 时，往往会发生一些极具破坏性的事情：你成功降低了 CAC，但你招揽来的客户价值却更低，因为低 CAC 往往只能吸引到这类客户。因此，将视角从 CAC 转向 LTV（终身价值）是有帮助的，这更好。考虑到对于更大、更好的客户，我们愿意花更多钱。所以你可能会想，LTV/CAC 比例可能是一个更好的衡量方式。但我认为 LTV/CAC 的挑战在于，尤其是对于像 Ramp 这样只有四岁（当时）的公司来说，预测 LTV 非常困难。

---

### [00:47:57] Sri Batchu

**English:**
It's like a DCF, it's extremely assumption laden and it's hard to know what the final value will be. And especially if you think your churn is low and your LTV is very high, you might end up spending a lot of money because you're like, "Oh, my LTV to CAC is great." And then a year or two into the business, you realize actually your churn is higher than you thought. Your initial customers aren't representative of your long-term retention and all of a sudden you've destroyed a lot of value by looking at LTV to CAC, which is why I'm a big, big fan of payback period and actually being really thoughtful about that using contribution margin, not revenue or gross margin, like how long of contribution margin from this customer does it take to payback their cost? And setting this obviously is typically a mandate from the executive and board level on what is the payback period that we're comfortable with, and then just orienting everybody towards driving that blended payback period down as much as possible.

**中文翻译:**
它就像现金流折现（DCF）模型，充满了各种假设，很难知道最终价值是多少。特别是如果你认为流失率很低、LTV 很高，你可能会花很多钱，因为你觉得“噢，我的 LTV/CAC 比例太棒了”。但经营一两年后，你发现流失率其实比预想的高，初始客户并不能代表长期留存情况，突然之间你发现盯着 LTV/CAC 实际上损毁了大量价值。这就是为什么我非常推崇“回本周期”，并且非常严谨地使用“边际贡献”（contribution margin）而不是收入或毛利来计算：这个客户产生的边际贡献需要多久才能抵消其获客成本？通常由高管和董事会设定一个我们可以接受的回本周期，然后让所有人朝着尽可能降低这个综合回本周期的方向努力。

---

### [00:48:56] Lenny

**English:**
For folks that aren't familiar with the concept of payback period or contribution margin, could you just briefly describe what those mean for listeners?

**中文翻译:**
对于那些不熟悉“回本周期”或“边际贡献”概念的听众，你能简要描述一下它们的含义吗？

---

### [00:49:01] Sri Batchu

**English:**
Yeah, so contribution margin is basically the profit that you make on a given customer after you take into account all of the variable costs. So including the cost of production as well as any other variable costs to serve that customer. So that might include support and other things that scale with your revenue. And then payback period is literally just how many months of that profit would it take to pay for? Let's say it costs you $5,000 to acquire this customer and your estimated profit per month on the customer is 500. That is a 10-month payback period. So as I say that, I'm sure you've heard, you still have to make assumptions for payback period, but at least they're more based in recency and you can evaluate them more quickly.

**中文翻译:**
好的。边际贡献基本上是指在扣除所有变动成本后，你从特定客户身上赚取的利润。这包括生产成本以及服务该客户的任何其他变动成本，比如随收入增长而增加的客户支持等。而回本周期字面上就是指需要多少个月的这种利润才能抵消获客成本。假设获取这个客户花了 5000 美元，而你估计每月从该客户身上获得的利润是 500 美元，那么回本周期就是 10 个月。正如我所说，计算回本周期依然需要做假设，但至少这些假设更基于近期数据，你可以更快地对其进行评估。

---

### [00:49:49] Lenny

**English:**
Awesome. Thank you for doing that. Just a couple more questions around growth specifically. So there's a lot of ways to grow through the history of a company. You can invest in SEO, you can invest in paid and sales and referrals and influencer marketing, brand marketing, billboards, all these things. Do you have an opinion on how to sequence these sorts of bets for a company, especially in B2B?

**中文翻译:**
太棒了，谢谢你的解释。关于增长还有最后几个问题。在公司的发展历程中有很多增长方式：SEO、付费广告、销售、推荐、红人营销、品牌营销、广告牌等等。对于一家公司（尤其是 B2B 公司），关于如何安排这些“赌注”的先后顺序，你有什么看法吗？

---

### [00:50:10] Sri Batchu

**English:**
Of course, a lot depends on who your customers are, what your unique value propositions are and how competitive the space that you're in. But I do think there's actually a general path that most B2B companies take and should take frankly, which is my view is you start off with founder-led sales, like the early team needs to know how to actually sell, then you hire your first couple of salespeople, then you start some very low cost targeted marketing efforts. So whether it's like content, community, small scale events, and then PR. After all of that is when you start paid and brand efforts. And then SEO probably start around the same time that you start paid marketing efforts.

**中文翻译:**
当然，这很大程度上取决于你的客户是谁、你的独特价值主张是什么，以及你所处行业的竞争程度。但我确实认为大多数 B2B 公司实际上有一条普遍的路径，坦白说也应该遵循这条路径。我的观点是：首先从“创始人主导的销售”开始，早期团队必须学会如何实际销售；然后雇佣前几个销售人员；接着开始一些极低成本的针对性营销，比如内容、社区、小规模活动，然后是 PR。在这些之后，才开始投入付费营销和品牌建设。而 SEO 可能在开始付费营销的同时启动。

---

### [00:50:56] Sri Batchu

**English:**
The reason for the progression the way I've described it is the channels get more expensive as you go farther along and they get more effective as you understand more about your customers and they're more scalable as well as you go farther along the list that I've described. And so that's the intention behind sequencing in that way. SEO is a bit unique. The reason I recommend it later rather than earlier, even though it's not necessarily that expensive, is just take some time to build. And without domain authority or backlinking or any media presence, you can end up just flailing with SEO, creating content and not getting any actual traction for a long time. So there's usually a good inflection point for your company to double down on SEO efforts. And it's somewhat a little bit later than some of the other times.

**中文翻译:**
我之所以这样描述这个进阶过程，是因为随着列表的深入，渠道会变得越来越贵，但随着你对客户了解的加深，它们的效率也会更高，且更具扩展性。这就是这种排序背后的意图。SEO 比较特殊。虽然它不一定很贵，但我建议稍晚再做，是因为它需要时间积累。如果没有域名权重（domain authority）、反向链接或任何媒体曝光，你做 SEO 可能只是在瞎忙活，写了内容却长期得不到实际流量。所以通常公司会有一个合适的拐点来加倍投入 SEO，这通常比其他一些手段要晚一点。

---

### [00:51:43] Lenny

**English:**
This touches on a great line that you have around experimentation where you talk about how you don't want to just fail fast with an experiment. You want to fail conclusively, if that's the word. Is that right? And then can you talk about that?

**中文翻译:**
这触及了你关于实验的一个精彩观点。你说过，做实验不应该只是“快速失败”，而是要“彻底地失败”（fail conclusively）。是这个词吗？你能谈谈这个吗？

---

### [00:51:57] Sri Batchu

**English:**
Yeah, I talk a lot about that with my teams both here and other places, which is we celebrate failure. Growth experiments in my history are typically 30%-ish success rate. So the vast majority of things that you try don't work. And so you want to create a culture where people aren't afraid to take risks and aren't afraid to fail. And for me, failure is not that you didn't drive revenue, failure is not learning. So it's really important that you learn when you fail. And so we celebrate failure as long as you're learning and you can only learn if you've designed the right test and you failed conclusively because otherwise, I think many of us have been in situations where there's intuition that something might work and it doesn't work, and then you end up doing it over and over for years because every time a new executive or somebody else has the same idea, you try it again and it's because you haven't been able to design the test to fail conclusively, and it's hard to do.

**中文翻译:**
是的，我经常和团队讨论这个。我们庆祝失败。在我的经历中，增长实验的成功率通常只有 30% 左右。也就是说，你尝试的大多数事情都是行不通的。所以你要创造一种文化，让人们不害怕冒险，也不害怕失败。对我来说，失败不是指没有带来收入，失败是指“没有学到东西”。所以失败时的学习至关重要。只要你在学习，我们就庆祝失败。而只有当你设计了正确的测试并“彻底地失败”时，你才能学到东西。否则，我想很多人都遇到过这种情况：凭直觉觉得某件事可行，结果没成，然后接下来的几年里你反反复复地做这件事，因为每来一个新高管或其他人有同样的想法，你就会再试一次。这是因为你没能设计出一个能让你“彻底死心”的测试，而这确实很难做到。

---

### [00:53:00] Sri Batchu

**English:**
But at the end of the day, there's only two ways to make an experiment successful. Either you have a very large M or have a very significant treatment, which is what you're doing in the experiment itself. And in B2B, you don't usually have the luxury of large M, which you do in consumer. Facebook can get stats taken in two hours. A B2B company could take two years to get the same number of touch points. And so to counteract that, I recommend people just trying to maximize the treatment effect, which is if you have a hypothesis that you're testing, just throw all of the possible tactics and resources that you think would move that needle because you can always cost rationalize later if it works.

**中文翻译:**
归根结底，让实验成功的途径只有两条：要么你有极大的样本量（N），要么你有极显著的实验干预（treatment）。在 B2B 领域，你通常没有 C 端产品那种庞大样本量的奢侈。Facebook 可以在两小时内获得统计结果，而 B2B 公司可能需要两年才能获得同等数量的触点。为了抵消这一点，我建议大家尝试“最大化干预效果”。也就是说，如果你在测试一个假设，就把所有你认为能推动指标的手段和资源都投进去。如果行得通，你以后总可以再进行成本优化。

---

### [00:53:49] Sri Batchu

**English:**
And so just maximize the treatment effect. And if with all of that it didn't work, then you can say, "Hey, we're not going to try this again because we literally did try everything that we could to test this hypothesis." And if it doesn't work in the best version and it's expensive as it is, this is not worth spending more time on. But if it does work, great, then you do another version of the test with half the tactics or whichever tactics you think work better or worse and you optimize over time.

**中文翻译:**
所以，就是要最大化干预效果。如果在这种情况下还是不行，你就可以说：“嘿，我们以后别再试这个了，因为我们已经尝试了所有可能的方法来测试这个假设。”如果最强力的版本都不奏效，而且成本还这么高，那就不值得再花时间了。但如果奏效了，太棒了，你可以再做一个版本，减掉一半的手段，或者保留你认为效果更好的手段，随着时间的推移进行优化。

---

### [00:54:17] Lenny

**English:**
Is there an example you could share when you did that?

**中文翻译:**
你能分享一个你这样做的例子吗？

---

### [00:54:19] Sri Batchu

**English:**
I mean, account based marketing is something that is very common in enterprise software where you've selected certain customers that you think are high priority and you're saying, "I want to touch them in as many nuanced ways possible to see if that drives conversion." And this is something I've seen tried many times where people do it, but they do it halfway where they're like, "Okay, tried these three things. Conversion of the control group wasn't higher. And so we think this is not going to work."

**中文翻译:**
比如“基于账户的营销”（ABM），这在企业软件中非常常见。你选择了一些高优先级的客户，然后说：“我想用尽可能多、尽可能细致的方式触达他们，看看是否能驱动转化。”我见过很多人尝试这个，但他们做得半途而废，比如：“好吧，试了这三件事，转化率没比对照组高，所以我们觉得这行不通。”

---

### [00:55:00] Sri Batchu

**English:**
And then a new go-to market executive comes and they have to do it again. They have to do it again. They have to do it again. It's a very common one wherever this happens. And so when we did it at Ramp, we did exactly what I just described, which is let's really be thoughtful about the experiment design, both in terms of maximizing the number of people as well as maximizing the number of ways and types of ways that we're effectively touching these target customers to show the value one way or the other.

**中文翻译:**
然后新来一个市场负责人，他们又得重做一遍，再重做一遍。这种情况非常普遍。所以当我们在 Ramp 做这件事时，我们采取了刚才描述的方法：非常周密地设计实验，既要最大化覆盖的人数，也要最大化触达这些目标客户的方式和类型，从而彻底证明其价值。

---

### [00:55:31] Lenny

**English:**
So what it sounds like is the hypothesis isn't like this email will have a big impact on conversion. It's like this strategy of coming after customers is what we're testing.

**中文翻译:**
所以听起来，假设并不是“这封邮件会对转化产生巨大影响”，而是“这种获取客户的策略”才是我们要测试的对象。

---

### [00:55:43] Sri Batchu

**English:**
That's the example there. And I think for example, this kind of framework is more important for cross-functional, larger scale, bigger tests rather than an email modification. But we could even use it on a micro example, like an email modification where you are like, okay, I think this particular email is underperforming because it's not talking to this part of the customer's pain point or journey or what have you. And the simplest test would be, okay, let me make some tweaks to the text and edit that, and that could be the end of that test.

**中文翻译:**
这就是那个例子。我认为这种框架对于跨职能、大规模的测试比对一封邮件的修改更重要。但我们甚至可以把它用在微观例子上，比如邮件修改。如果你觉得某封邮件表现不佳，是因为它没触及客户的某个痛点或旅程阶段。最简单的测试是改改文案，测试就结束了。

---

### [00:56:24] Sri Batchu

**English:**
And if that doesn't work, you're like, "Oh, maybe those weren't the right text edits. Let me do a different text edits or whatever." And that's fine, that's low cost. It's not the end of the world for you to be wrong there. But an alternative that you could do is like, oh, what are all of the things that I could change about this email in the same test? Is it the trigger of the email? Is it the text content of the email? Is it additional personalization? Is it the design of the email? Trying to think of what are all of the various levers that you think could be wrong and put them all together to test your hypothesis of this touchpoint is wrong and how do I improve that.

**中文翻译:**
如果没效果，你会想：“噢，也许是文案改得不对，我再换个写法。”这没问题，成本很低，错了也不是世界末日。但另一种做法是：在同一个测试中，我能改变这封邮件的所有哪些方面？是触发机制吗？是正文内容吗？是增加个性化吗？还是邮件设计？思考所有可能出问题的杠杆，把它们组合在一起，去测试你的假设——即“这个触点有问题”，以及“我该如何改进它”。

---

### [00:57:02] Lenny

**English:**
Well, obviously the downside of that is if it doesn't work, you don't know if it's like, oh, maybe it was this thing could have worked in the subject-

**中文翻译:**
显然，这种做法的缺点是，如果它不起作用，你不知道是不是因为……比如，也许标题里的某个东西本来是有效的——

---

### [00:57:08] Sri Batchu

**English:**
Yeah. So there's always trade-offs on this. But what you're hoping is you've done a complete refresh where you did all the things that you thought were intuitive that should work. And if it doesn't work, then you're like, "Okay, maybe my hypothesis is wrong." But you're right. There's always going to be a challenge if maybe the execution is wrong and I did too many things potentially in that case.

**中文翻译:**
是的。这总是有权衡的。但你希望的是，你已经做了一次彻底的更新，把所有你直觉上认为应该有效的事情都做了。如果还是不行，那你就可以说：“好吧，也许我的假设本身就是错的。”但你是对的，如果执行有误，或者我在那个案例中做得太多，确实会带来挑战。

---

### [00:57:29] Lenny

**English:**
How does that go with the velocity culture? Is it just do those things real fast even though it's not like micro optimize, it's like go bigger but do them fast?

**中文翻译:**
这如何与“速度文化”结合？是即使不进行微观优化，也要快速完成这些事情吗？也就是“做大，但要做快”？

---

### [00:57:39] Sri Batchu

**English:**
Yeah. Yeah. So that's why I think it's important to frame where this matters. And so I think I'm less worried about failing conclusively for things that you can fail really, really fast and just redo, right? Things like website conversion, email, et cetera. I'm more worried about that for things that take a while to plan and cost money, et cetera.

**中文翻译:**
是的。所以我觉得明确这种方法在什么时候重要是很关键的。对于那些可以极速失败并重做的事情（比如网站转化、邮件等），我不太担心是否“彻底失败”。我更担心的是那些需要很长时间规划且耗费大量资金的事情。

---

### [00:58:05] Lenny

**English:**
Got it. Okay. Great. Maybe one last question around growth specifically. What are some of your favorite tools for the growth team, either internally, whatever you can share, or externally that just allow you to operate efficiently and effectively?

**中文翻译:**
明白了。太棒了。关于增长的最后一个问题：你最喜欢的增长团队工具有哪些？无论是内部的（只要能分享的）还是外部的，只要是能让你们高效运作的。

---

### [00:58:19] Sri Batchu

**English:**
A couple of things that we've used, I mean, one simple thing is for sprint planning, actually, we use Airtable because the planning process and the scoring is so much more analytical and the translation layer. So we've got a template on how we do our sprint planning and how we translate the various impact metrics into the common currency, which I enjoy, but I don't see it has to be Airtable. It's just some form of organization that works well for that. In terms of a very tactical growth tool that we've enjoyed recently is we used this company called Mutiny, which is also around customer, which is a tool for website copy, personalization. So they hook up with our third party data sources that we pay for, and based on what we know about the customer as they're landing on our page, we can personalize, copy, and design based on that. And that's had material impact and allowed us to scale website experimentation.

**中文翻译:**
我们用过几样东西。一个简单的例子是冲刺规划，我们实际上用 Airtable，因为规划过程和评分非常需要分析性，还有那个翻译层。我们有一套关于如何进行冲刺规划以及如何将各种影响指标转换为“通用货币”的模板，我很喜欢。当然不一定非得是 Airtable，只要是适合这种组织形式的工具就行。至于最近我们很喜欢的战术性增长工具，是一家叫 Mutiny 的公司，它是一个网站文案个性化工具。它能连接我们付费购买的第三方数据源，根据客户登陆页面时的信息，我们可以个性化文案和设计。这对我们产生了实质性的影响，并让我们能够规模化地进行网站实验。

---

### [00:59:18] Lenny

**English:**
Amazing. And then are there internal tools you've built to help with experimentation or I don't know, sharing data, dashboard? I don't know, is there anything else that's just like, wow, this really helps us move fast?

**中文翻译:**
太棒了。那你们有没有构建什么内部工具来辅助实验，或者分享数据、仪表盘之类的？有没有什么让你觉得“哇，这真的帮我们跑得很快”的东西？

---

### [00:59:27] Sri Batchu

**English:**
Eric, our CEO, has publicly talked about this. I think we as a company are very thoughtful about what we build in-house versus what we buy externally. I think a lot of engineering teams are often excited about building things in-house where there's off the shelf products that could basically work externally. And Ramp has historically been good at not falling into that trap. And we use third party tools for a lot of our growth and experimentation for things that are not proprietary, strategic, et cetera, obviously. Some of the automation stuff that we've talked about, we've built all of that in-house in terms of prospecting, lead scoring, and how we talk to our customers. But for the most part, we use external tools. Instacart and Opendoor were not like that. We built our own internal experiment tracking systems, A/B testing frameworks and all of that in-house.

**中文翻译:**
我们的 CEO Eric 公开谈论过这一点。我认为我们公司在“自建还是外购”上考虑得非常周全。很多工程团队往往热衷于自建，即使外部已经有现成的产品可用。Ramp 历来很擅长避开这个陷阱。对于非专利、非战略性的增长和实验需求，我们显然会使用第三方工具。至于我们谈到的一些自动化工作，比如潜在客户挖掘、线索评分以及我们与客户沟通的方式，这些都是我们自建的。但大部分情况下，我们使用外部工具。Instacart 和 Opendoor 则不同，我们当时在内部构建了自己的实验跟踪系统、A/B 测试框架等。

---

### [01:00:25] Lenny

**English:**
That's what I would've guessed about Ramp that it's with speed, you got to not build stuff you don't have to build. So that makes a lot of sense. Okay. Maybe one last topic to talk about. I want to talk about hiring. You have some really interesting approaches to how to think about hiring. One is I think you have a really interesting strategy for how to find the best companies and also the best people at each of those companies to go after if you're hiring for specific role. Can you talk about how you think about that?

**中文翻译:**
这正是我对 Ramp 的猜测——为了速度，你绝不能去造那些不必造的轮子。这很有道理。好，最后一个话题，我想聊聊招聘。你对招聘有一些非常有趣的见解。其中一个是，当你为特定职位招聘时，你有一套非常有趣的策略来寻找最好的公司，以及这些公司里最好的人才。你能谈谈你是怎么考虑的吗？

---

### [01:00:51] Sri Batchu

**English:**
Gokul on Twitter has talked about some of those, which is there's two ways to go about hiring great people. One way is basically a very thoughtful and tactical network search where let's say you're hiring for a head of SEO, you go ask your network of who is the best SEO person you know, get introduction to each of those folks, and then ask them who the best person that they know is. And you have a mapping of where are the best SEO teams and why. If you can't get one of those people, 20, 30 people on your target list, you go down the list of, okay, what is the next best person? And you typically want to limit it to companies that are one to two stages of growth after you. So you want somebody that has seen your stage of growth and beyond at a company that has a reputation for craft and the field that you're looking for. So that's a very classic way of doing that, and I think that works really well for people and companies that are really well-connected.

**中文翻译:**
Gokul 在 Twitter 上也谈到过一些。招聘优秀人才主要有两种方式。一种是深思熟虑且具战术性的“网络搜索”。假设你要招 SEO 负责人，你去问你的社交圈：“你认识的最厉害的 SEO 是谁？”获得引荐后，再问那些人：“你们认识的最厉害的人是谁？”这样你就映射出了哪里有最好的 SEO 团队以及原因。如果你无法从目标名单上的 20、30 人中招到人，就顺着名单找下一个最优秀的人。通常你会把范围限制在比你领先一两个增长阶段的公司。你想要的是那些在以专业技能著称的公司里，经历过你当前阶段及更高阶段的人。这是一种非常经典的方法，对于人脉广泛的人和公司非常有效。

---

### [01:01:56] Sri Batchu

**English:**
So there another approach that I've actually used successfully is much more kind of data driven and external and not as network based, which is you can often look up data. [inaudible 01:02:14] is a lot of it is somewhat public, right? So you can look up information on which companies might be doing well. So for example, I'll just pick like if you're looking for great email marketing folks like CRM marketing lead or something like that, you can actually look up on similar web, what percentage of traffic shows up via email to companies websites. So you've got your target list of companies that are one or two stage beyond you that you respect as general companies. And you can go and see, okay, which ones of these are actually really effective at driving web traffic or app traffic or app downloads via their email. And then go try to source from those teams and companies. And I think people under-utilize that even though it's very intuitive, it's just not something that occurs to people to do.

**中文翻译:**
我成功使用过的另一种方法更偏向数据驱动和外部化，而不是基于人脉。你可以查阅很多半公开的数据。你可以查到哪些公司做得好。例如，如果你想找优秀的邮件营销人才（比如 CRM 营销主管），你可以在 SimilarWeb 上查到哪些公司的网站流量中邮件占比很高。你已经有了领先你一两个阶段的目标公司名单，你可以去看看其中哪些公司通过邮件驱动网站流量、App 流量或下载的效果特别好。然后，尝试从这些团队和公司中挖掘人才。我认为人们低估了这种方法，尽管它非常直观，但大家往往想不到去这样做。

---

### [01:03:03] Lenny

**English:**
I love that. I've not heard that tip right there. The first piece, Google definitely recommends this, and I think the core part of that is the core theme here is find the companies that are the best at the thing you're trying to hire for, and then figure out who at the company is the best once you start talking to people. I love it. Another strong opinion that I think you have is around paying people and how much to pay the best. Can you talk about that?

**中文翻译:**
我太喜欢这个建议了，以前没听过。第一部分，Google 肯定也推荐这样做。核心主题是：找到在你想招聘的领域做得最好的公司，然后通过交流找出那家公司里最厉害的人。太棒了。我知道你还有另一个强烈的观点，是关于给员工发工资以及给顶尖人才发多少工资。你能谈谈吗？

---

### [01:03:30] Sri Batchu

**English:**
Yeah, I think there's a lot of conversation around compensation is very much focused on equality and narrowing the gap and bands for compensation. And I think personally, I know it's a bit of a spicy take maybe, but I think it's the exact opposite direction of the conversation that companies should be having about compensation, which is I strongly, strongly believe that small teams of successful people can drive a lot more impact than larger teams of mediocre people.

**中文翻译:**
是的。我认为现在关于薪酬的讨论大多集中在公平性、缩小差距和设定薪酬职级（bands）上。我个人认为——我知道这可能是一个有点争议的观点——这与公司应该进行的薪酬讨论方向完全相反。我非常、非常坚信，由成功人士组成的小型团队所能产生的影响力，远大于由平庸人士组成的大型团队。

---

### [01:04:05] Sri Batchu

**English:**
And so I strongly believe you have to design a system where you're able to reward 10X operators with 10X the comp. You certainly see that at the executive level. So if you look at the same executive at different companies at similar stages, the comp can be widely different based for a variety of reasons. But one of them is the perception of performance and potential by the management team. And I think people need to be thinking about how to do that across more levels, which is if you can do that, and if you do that well, I think you're able to differentially hire and retain the best talent. And that'll be a great competitive advantage for companies that can do that well.

**中文翻译:**
因此，我坚信你必须设计一个系统，能够以 10 倍的薪酬奖励那些“10 倍效率的执行者”（10X operators）。在管理层级别，你肯定能看到这一点：同一级别的不同公司高管，薪酬可能因各种原因大相径庭，其中之一就是管理层对其绩效和潜力的认知。我认为人们需要思考如何在更多层级上实现这一点。如果你能做到并做好，你就能差异化地招聘并留住最顶尖的人才。对于能做到这一点的公司来说，这将是一个巨大的竞争优势。

---

### [01:04:48] Lenny

**English:**
And do you think about this within a team pay the best people the most, or is it more only hire these 10X people and then pay everyone the most?

**中文翻译:**
你是认为在一个团队内部给最优秀的人发最高的工资，还是说只雇佣这些 10 倍效率的人，然后给所有人发最高工资？

---

### [01:04:58] Sri Batchu

**English:**
People think of the talent density of your company as dependent on hiring. And that's obviously true. It's an important part of the ecosystem and the first part, but it's equally dependent on retention and performance management. A lot of companies can be good at hiring, but hiring has pretty high rate of false positive. Interview is the worst, best way to hire somebody. And then there's lots of ways you can make the interviewing process better, make it more interactive, make it more effective, but at the end of the day, you still don't know about someone until you really work closely with the new team, with the new mandate at your company.

**中文翻译:**
人们认为公司的“人才密度”取决于招聘。这显然是对的，它是生态系统的重要组成部分，也是第一步。但它同样取决于留存和绩效管理。很多公司可能擅长招聘，但招聘的“假阳性”（看走眼）概率相当高。面试是雇佣某人最糟糕但也最好的方式。你可以通过很多方法让面试过程更好、更具互动性、更有效，但归根结底，在你真正与新团队、在新任务中密切合作之前，你还是不完全了解一个人。

---

### [01:05:40] Sri Batchu

**English:**
So I think it's not about necessarily hiring [inaudible 01:05:44] operators, obviously you're looking for that, but it's also about investing in people that are doing really well and accelerating their growth and rewards based on impact once they're there and as well as managing out people directly that didn't work out. And I typically think it's almost never when I've had to part ways with people is because someone's a bad actor. It's almost always that it just wasn't the right fit for whatever reason, for their skillset, for their life goals or whatever it may be. And it just wasn't a fit for that role. And I think a lot of companies are hesitant to make those changes, and I think that's how they bring their talent bar down, frankly.

**中文翻译:**
所以我觉得不一定非要只招 10 倍效率的人（当然你要寻找这样的人），更重要的是投资于那些表现出色的人，加速他们的成长，并根据他们入职后的影响力给予奖励；同时，也要果断地请走那些不合适的人。通常当我不得不与人分道扬镳时，几乎从不是因为对方人品不好，几乎总是因为某种原因不匹配——无论是技能组合、人生目标还是其他。他们只是不适合那个职位。我认为很多公司在做出这些改变时犹豫不决，坦白说，这正是他们拉低人才门槛的原因。

---

### [01:06:28] Lenny

**English:**
Absolutely agree. Sri, is there anything else that you wanted to touch on before we get to our very exciting lightning round?

**中文翻译:**
完全同意。Sri，在进入我们非常精彩的闪电轮环节之前，还有什么想聊的吗？

---

### [01:06:35] Sri Batchu

**English:**
I don't know how many people will use this. I'm still surprised when new folks come to me and it's like I need to write, by the way, a document of how do you work with me? Because I know it's a lot of people have been talking about, I think [inaudible 01:06:51] Johnson's talked about it too, but I say that my love languages are spreadsheets and frameworks. And one very simple one that I've always liked that sometimes people surprised to hear, but it's most consultants know is what we call MECE, mutually exclusive, collectively exhausted set of things. So whenever you're trying to attack a problem and trying to brainstorm solutions or what have you, I really like to remind the teams to think about MECE because when you think about that and evaluate your set of solutions with that framework in mind, I think you tend to find that you've catch more potential solutions and also you'll feel comfortable that you've been comprehensive in your solution development. So anyway, just a little thing for people that are earlier in their careers to not forget.

**中文翻译:**
我不知道会有多少人用这个。当新人来找我时，我仍然会感到惊讶，顺便说一下，我需要写一份“如何与我共事”的文档。我知道很多人都在谈论这个。我说我的“爱之语”是电子表格和框架。我一直很喜欢一个非常简单的概念，有时人们听到会感到惊讶，但大多数顾问都知道，那就是 MECE（相互独立，完全穷尽）。每当你试图解决一个问题、头脑风暴解决方案时，我非常喜欢提醒团队考虑 MECE。因为当你带着这个框架去思考和评估解决方案时，你会发现你能捕捉到更多潜在方案，并且会对方案的全面性感到踏实。总之，这是给职业生涯早期的人们的一点小建议，不要忘记它。

---

### [01:07:46] Lenny

**English:**
So let's make it a little bigger than a little thing. So MECE, mutually exclusive, collectively exhaustive. Is there an example of what that may look like and or visualize for people to think about what this means in practice?

**中文翻译:**
那我们就把它说得更详细一点。MECE，相互独立，完全穷尽。有没有什么例子可以形象化地说明这在实践中意味着什么？

---

### [01:08:00] Sri Batchu

**English:**
Yeah. I mean, I'll give it really dumb example, but that will make the point hopefully. It's like, okay, our profitability or our revenue growth has slowed down is the problem that you're trying to solve. And so okay, you start with, okay, what does this mean? You've got revenue per user has gone down, or customer has gone down, or number of customers have slowed down. Okay, that's step one of the MECE framework. Then it's like, okay, where does the revenue come from? What are all the various products that revenue could be coming from? Has it changed on any one of them? And then customers, why have customers gone down? Is it new customer acquisition? Is it activation of customers that have signed up? Is it retention? And just breaking that problem. So at each layer you've collectively exhausted all of the possible ways that this problem could have arrived. And just having that framework whenever you approach every problem will prevent you from missing something important. And also just more generally give you an others' confidence that you're being comprehensive in your solution development.

**中文翻译:**
好的。我举个很简单的例子，希望能说明问题。假设你要解决的问题是“我们的利润率或收入增长放缓了”。那么，你首先开始分析：这意味着什么？是人均收入下降了，还是客户数量减少了，或者是客户增长速度放缓了？这是 MECE 框架的第一步。接着：收入从哪里来？可能产生收入的所有各种产品有哪些？其中任何一个发生变化了吗？然后是客户：为什么客户减少了？是新客户获取出了问题？是已注册客户的激活出了问题？还是留存出了问题？就这样拆解问题。在每一层，你都穷尽了导致该问题的所有可能原因。每当你处理问题时带着这个框架，就能防止遗漏重要信息，也能让别人相信你的解决方案是全面的。

---

### [01:09:11] Lenny

**English:**
Got it. So one way to think about this in this specific case is just make a formula of all of the variables that play into the question you're trying to answer.

**中文翻译:**
明白了。所以在这种特定情况下，一种思考方式就是为你试图回答的问题列出所有相关变量的公式。

---

### [01:09:19] Sri Batchu

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [01:09:20] Lenny

**English:**
Awesome. Well, Sri, with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。Sri，到此我们进入了非常令人兴奋的闪电轮环节。准备好了吗？

---

### [01:09:26] Sri Batchu

**English:**
Yeah, let's do it.

**中文翻译:**
准备好了，开始吧。

---

### [01:09:28] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:09:32] Sri Batchu

**English:**
I tend to find most business books can be decks, but one that I really like actually is Never Split The Difference by Chris Voss. It's a negotiation book, find it super helpful for negotiation, but also for a lot of business decision making generally, to be honest, and life. And then I'm a big fan of sci-fi short stories, so anything by Ted Chiang or Ken Liu, I highly recommend.

**中文翻译:**
我发现大多数商业书其实都可以缩减成 PPT，但我非常喜欢的一本是 Chris Voss 的《掌控谈话》（Never Split The Difference）。这是一本关于谈判的书，我发现它不仅对谈判超级有用，对一般的商业决策甚至生活也很有帮助。另外，我是科幻短篇小说的忠实粉丝，特德·姜（Ted Chiang）或刘宇昆（Ken Liu）的作品我都强烈推荐。

---

### [01:09:57] Lenny

**English:**
I love those both. On the first one I'm actually in the process of listening to it on audio and every time I'm in a place where I can negotiate something, I never remember anything that I've learned. Is there one thing that you've taken away from that book that stuck with you of like I use this?

**中文翻译:**
这两类我都喜欢。关于第一本，我正在听有声书，但每当我处于可以谈判的场合时，我总是不记得学过什么。那本书里有没有哪一点让你印象深刻，让你觉得“我一直在用这个”？

---

### [01:10:11] Sri Batchu

**English:**
I think that the core of the book really is about listening behind the problem of negotiation and what is the person really asking for. So his example of if you're always trying to split things evenly, you'll end up with one brown shoe, one black shoe, where neither of you are happy. And so rather than thinking about BATNA and ZOPA and all the other business school frameworks on negotiation, I think focus on deep down what does this other person want and how can I change the conversation about that rather than the thing that we're arguing over.

**中文翻译:**
我认为这本书的核心在于倾听谈判问题背后的东西，即对方真正想要的是什么。他举过一个例子：如果你总是试图平分，最后你可能得到一只棕色鞋子和一只黑色鞋子，谁都不会开心。所以，与其去想 BATNA（谈判协议的最佳替代方案）或 ZOPA（协议可能达成区域）等商学院的谈判框架，不如专注于对方内心深处想要什么，以及我如何改变关于那个目标的对话，而不是纠结于我们正在争论的具体事物。

---

### [01:10:47] Lenny

**English:**
Awesome. Great. Next question. What's a favorite recent movie or TV show?

**中文翻译:**
太棒了。下一个问题：最近最喜欢的电影或电视节目是什么？

---

### [01:10:51] Sri Batchu

**English:**
I mean, obviously it won the Oscar, but I really enjoyed Everything Everywhere All at Once. I thought it was such a wonderful story and really I think it's one of those... It's funny. The movie can also be, I think, everything because there are just so many different reads that you can get about that. It's about family, it's about immigration, it's about love. There's a lot of really interesting themes explored via one movie.

**中文翻译:**
虽然它得了奥斯卡，但我真的很喜欢《瞬息全宇宙》（Everything Everywhere All at Once）。我觉得这是一个非常精彩的故事。有趣的是，这部电影本身就像它的名字一样，包罗万象，你可以从很多不同的角度去解读：关于家庭、关于移民、关于爱。一部电影探讨了这么多非常有趣的主题。

---

### [01:11:19] Lenny

**English:**
What's a favorite interview question you like to ask?

**中文翻译:**
你最喜欢问的面试问题是什么？

---

### [01:11:21] Sri Batchu

**English:**
I was going to say, oh, I like to ask other people.

**中文翻译:**
我刚才想说，噢，我喜欢问别人的问题。

---

### [01:11:24] Lenny

**English:**
You like to ask. What did you think I was going to ask?

**中文翻译:**
就是你喜欢问别人的。你以为我要问什么？

---

### [01:11:26] Sri Batchu

**English:**
Oh, I thought what was my favorite interview question that you've asked or others have asked?

**中文翻译:**
噢，我以为你问的是“你问过我的或别人问过我的问题中，我最喜欢哪一个”。

---

### [01:11:30] Lenny

**English:**
Oh, I got to clarify this. Both are acceptable answers.

**中文翻译:**
噢，我得澄清一下，两个答案都可以。

---

### [01:11:37] Sri Batchu

**English:**
I was going to cheat on that one and say the one that you asked me right before, because I'm a big fan of actually movies and TV shows and people rarely ask about that interviews like this, but favorite interview that I'd like to ask candidates actually is what's something that you're really bad at but you still do and why?

**中文翻译:**
那我就耍个赖，说你刚才问我的那个（关于电影的），因为我真的很喜欢影视剧，很少有人在这样的采访中问这个。不过，我最喜欢问应聘者的问题其实是：“有什么事情是你做得很糟糕但仍然在坚持做的，为什么？”

---

### [01:11:58] Lenny

**English:**
What do you look for in their answer when you ask them?

**中文翻译:**
当你问这个问题时，你希望从他们的回答中听到什么？

---

### [01:12:01] Sri Batchu

**English:**
Yeah, a lot of people actually struggle with that question and can't answer anything that they do that they're bad at, which is a little bit of a yellow flag, which means that they're only used to doing things that they're successful at and they haven't cultivated interests that are not correlated to their own success at doing something. And they haven't taken the time to do that. And folks like that are going to run at the first sign of trouble and be like, "Oh, I'm not successful at this, so I'm going to move on." And what I really want to see is people that show examples of things that they're not successful at that they do for other motivations and goals and interests. And so if you can tell me a compelling story like that, it's usually a winning answer so to speak.

**中文翻译:**
是的，很多人其实很难回答这个问题，说不出任何一件他们做得不好但仍在做的事。这其实是一个小小的警示信号（yellow flag），意味着他们只习惯于做那些能成功的事，没有培养过与成功无关的兴趣，也没有为此花过时间。这类人往往一遇到困难就会想：“噢，我在这方面不成功，我要换个事做。”我真正想看到的是，人们能举出一些他们并不擅长、但出于其他动机、目标或兴趣仍在坚持的事。如果你能给我讲一个这样引人入胜的故事，那通常就是一个“满分答案”。

---

### [01:12:43] Lenny

**English:**
What is a favorite product or two that you've recently discovered that you love?

**中文翻译:**
你最近发现并喜爱的一两个产品是什么？

---

### [01:12:46] Sri Batchu

**English:**
Carrie mentioned Eight Sleep once in this call. I love my Eight Sleep. I'm a big fan and they're Ramp customers as well. And so that's been a great pandemic purchase. So I guess maybe not as recent. And then maybe another one is Fellow coffee, their kettles I think just designed so beautifully. I don't drink coffee, I drink tea, but I use my Fellow kettle for tea, and I think it's just a delightful product to use.

**中文翻译:**
刚才提到了 Eight Sleep。我非常喜欢我的 Eight Sleep 智能床垫。我是它的忠实粉丝，他们也是 Ramp 的客户。那是我在疫情期间买的一件很棒的东西，所以可能不算太“近期”。另一个可能是 Fellow 咖啡，我觉得他们的水壶设计得太漂亮了。我不喝咖啡，我喝茶，但我用 Fellow 的水壶泡茶，我觉得那是一个用起来让人心情愉悦的产品。

---

### [01:13:15] Lenny

**English:**
I got a Fellow kettle from my tea also, and I found that the flow of the water was too slow and it's just standing here pouring this pour over.

**中文翻译:**
我也买了一个 Fellow 水壶泡茶，但我发现水流太慢了，感觉就像一直站在那儿做手冲咖啡一样。

---

### [01:13:24] Sri Batchu

**English:**
Yeah. Yeah. So they do have a non-pour over kettle, which is what I have, which makes it easier.

**中文翻译:**
是的，他们确实有一款非手冲式的水壶，我用的就是那个，倒水更容易。

---

### [01:13:29] Lenny

**English:**
Okay. My mistake. Next question. What is something relatively minor you've changed in your product development process that you found to have a big impact on your ability to execute?

**中文翻译:**
好吧，我的错。下一个问题：在你的产品开发流程中，有没有什么相对较小的改动，却对你的执行能力产生了巨大的影响？

---

### [01:13:42] Sri Batchu

**English:**
Yeah, I mean, I don't know if this is minor or not, but one of the things that on the growth side, we used to have separate sprint planning for the product team, for the marketing teams, and each team had their own planning cycles. And one of the things that we did is we brought them all together into one. So the lifecycle marketers joined the product activation team sprint cycles, and so their projects and work are very tightly aligned and work in the same pace and system as the rest of the product team. And that's had tremendous impact in our ability to work together.

**中文翻译:**
我不确定这算不算小改动，但在增长方面，我们以前会为产品团队和营销团队分别进行冲刺规划，每个团队都有自己的规划周期。我们做的一件事是把它们合并为一个。让生命周期营销人员加入产品激活团队的冲刺周期，这样他们的项目和工作就能紧密结合，并与产品团队的其他成员保持相同的节奏和系统。这对我们的协作能力产生了巨大的影响。

---

### [01:14:19] Lenny

**English:**
Final question, Ramp is all about helping people save money. I'm curious if you have any tips on just saving money.

**中文翻译:**
最后一个问题，Ramp 的核心就是帮人们省钱。我很好奇你有没有什么关于省钱的小贴士？

---

### [01:14:26] Sri Batchu

**English:**
I mean, it seems obvious, and I think I feel like negotiation's already been the theme of this lightning round, but everything is negotiable when it comes to contracts. People think contracts are standardized for software and usually not. People are trying to sell you something they're trying to grow too. They have their quotas to meet, they have their goals to hit. So I mean, Ramp obviously has a service for this if you wanted to scale these Ramps, but you can do this on your own. Always try to negotiate, be mindful of quarter ends for salespeople. And so if you can push something out till near the end of the quarter, you can ask for, "Hey, I'll sign it by the end of the month if you give me a 10% discount," will often work. So there's tips like that you can do, but remember that you can always negotiate.

**中文翻译:**
这似乎显而易见，而且我觉得“谈判”已经成了这轮闪电战的主题。但涉及到合同时，一切都是可以商量的。人们认为软件合同是标准化的，但通常并非如此。别人想卖给你东西，他们也想增长。他们有销售配额要完成，有目标要达成。Ramp 显然有专门的服务来帮你规模化地处理这些，但你自己也可以做。永远尝试去谈判，留意销售人员的季度末。如果你能把事情拖到季度末附近，你可以说：“嘿，如果你给我 10% 的折扣，我就在月底前签字。”这通常很管用。你可以尝试这类技巧，但请记住，一切皆可谈判。

---

### [01:15:10] Sri Batchu

**English:**
And then the second one is, I would say is just hire slower. I'm a big believer in, and Geoff talks about this too in your other interview, hiring based on slope rather than intercept, I think will work well for you and only hiring when people and teams are really stretched. I think this will serve you well both on cost and on impact. There'll be plenty of scope for the people that you hire, and as I said, I'm a big believer in small teams accomplishing more like Ramp being like a fraction of the size of some of our competitors with similar orders of revenue.

**中文翻译:**
第二点，我想说的是“慢点招人”。我非常相信——Geoff 在你的另一次采访中也提到了——根据“斜率”而不是“截距”来招聘（即看重潜力而非当前水平）。我认为只有当人员和团队真的忙不过来时再招人，这对成本和影响力都有好处。这样你招来的人会有足够的发展空间。正如我所说，我坚信小团队能成就大事业，就像 Ramp 的规模只有收入相近的竞争对手的一小部分。

---

### [01:15:47] Lenny

**English:**
Sure. We've covered velocity, growth, hiring. So many topics, everything I was hoping we touch on. Two final questions, where can folks find you if they want to reach out and learn more and how can listeners be useful to you?

**中文翻译:**
当然。我们涵盖了速度、增长、招聘等这么多话题，全都是我希望能聊到的。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？听众们能为你做些什么？

---

### [01:15:59] Sri Batchu

**English:**
Yeah, I'm a big fan of the fun place of the cesspool of Twitter, so I have a public Twitter account that you can DM me. My DMs are open, it's just my name's sri_batchu. And in terms of listeners can be useful, honestly, I think I really enjoy meeting like-minded folks, and as I may have mentioned in other places, Ramp is growing incredibly well and we're constantly looking to hire and we're still hiring. So if you know best in class growth in marketing folks that they can recommend that we hire at Ramp, I'd love to hear.

**中文翻译:**
我是 Twitter 那个有趣又混乱的地方的粉丝，所以我有一个公开的 Twitter 账号，你可以给我发私信。我的私信是开放的，账号就是我的名字 sri_batchu。至于听众能帮上什么忙，坦白说，我非常喜欢结识志同道合的人。正如我可能在其他地方提到的，Ramp 增长得非常好，我们一直在招人。如果你认识顶尖的增长和营销人才并愿意推荐给 Ramp，我非常乐意倾听。

---

### [01:16:40] Lenny

**English:**
And I think the URL is ramp.com/careers. I just pulled it up.

**中文翻译:**
我想网址应该是 ramp.com/careers。我刚查了一下。

---

### [01:16:43] Sri Batchu

**English:**
Yep, that's it. Thank you.

**中文翻译:**
是的，就是那个。谢谢。

---

### [01:16:47] Lenny

**English:**
All right, Sri, well thank you again so much for being here and for sharing so much.

**中文翻译:**
好的，Sri，再次感谢你来到这里并分享了这么多。

---

### [01:16:49] Sri Batchu

**English:**
Yeah, of course. Thank you.

**中文翻译:**
不客气，谢谢你。

---

### [01:16:52] Lenny

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。