# Sriram and Aarthi - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Sriram Krishnan and Aarthi Ramamurthy.

---

### [00:00:00] Sriram Krishnan

**English:**
I hate Jobs-to-be-Done, I think it is a terrible framework, I think no successful company has ever been built on top of JTBD and if you pick JTBD, you're probably doomed and I'll give you an example. When you sign up for Instagram right now, when you sign up for Facebook for many, many years, Facebook knew that it needed to get you to 10 friends in 14 days. If you got your 10 friends in 14 days, you were probably going to use Facebook. So it'd be like, "Well, we're going to throw every tool we have at our disposal to get you to 10 friends and 14 days."

**中文翻译:**
我讨厌“待办任务”（Jobs-to-be-Done，简称 JTBD）框架，我觉得它是个糟糕的框架。我认为没有任何一家成功的公司是建立在 JTBD 之上的，如果你选择了 JTBD，你可能注定要失败。我给你举个例子。现在你注册 Instagram，或者过去很多年里你注册 Facebook 时，Facebook 都知道它需要让你在 14 天内交到 10 个朋友。如果你在 14 天内有了 10 个朋友，你大概率会持续使用 Facebook。所以他们会想：“好吧，我们要动用一切手段让你在 14 天内交到 10 个朋友。”

---

### [00:00:23] Sriram Krishnan

**English:**
So if you signed up for Facebook for many, many years, you'll get this little thing called People You May Know. Then you'll have this person who just signed up for Facebook, you go, "Why I'm seeing this person?" It's not because you need a friend, because they need a friend. So what Facebook did was it made your experience slightly worse to make that person's experience slightly better. This was performing no job for you, it was trying to perform a job for them.

**中文翻译:**
所以如果你在过去很多年里注册 Facebook，你会看到一个叫“你可能认识的人”的小功能。你会看到一个刚注册 Facebook 的人，然后纳闷：“为什么我会看到这个人？”这不是因为你需要朋友，而是因为**他们**需要朋友。所以 Facebook 所做的是让你的体验稍微变差一点，从而让那个人的体验变好一点。这对你来说没有完成任何“任务”（Job），它是在试图为他们完成任务。

---

### [00:00:49] Lenny

**English:**
Welcome to Lenny's Podcast where I interview world-class product leaders and growth experts to learn from their hardware and experiences building and growing today's most successful products. Today for the first time ever, I've got two guests, Aarthi Ramamurthy and Sriram Krishnan, both former product managers who between them worked at basically every major tech company including Netflix, Meta, Snap, Twitter, Microsoft, even Clubhouse. Sriram is now a partner at a16z. They're actually married and both individually amazing. Together they host the Aarthi and Sriram Good Time Show, which started on Clubhouse, it's now on YouTube and famously they had Elon Musk on back in the day, which led to Clubhouse's crazy rocket ship growth, which we definitely touch on.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，从他们打造和增长当今最成功产品的实战经验中学习。今天，我第一次同时邀请到了两位嘉宾：Aarthi Ramamurthy 和 Sriram Krishnan。他们两位都是前产品经理，两人加起来几乎在所有主流科技公司工作过，包括 Netflix、Meta、Snap、Twitter、微软，甚至还有 Clubhouse。Sriram 现在是 a16z 的合伙人。他们其实是一对夫妻，而且个人能力都非常出众。他们共同主持《Aarthi and Sriram Good Time Show》，这个节目始于 Clubhouse，现在在 YouTube 上播出。最出名的是他们当年邀请到了埃隆·马斯克，这直接导致了 Clubhouse 疯狂的火箭式增长，我们稍后一定会聊到这一点。

---

### [00:01:32] Lenny

**English:**
This episode is definitely the most fun conversation I have had yet on this podcast. We cover all kinds of areas, including this trend of techno optimism, building your network, creating content online and how to go about doing that, becoming a product leader, community building and a hilarious rant at the end about why the Jobs-to-be-Done framework does not work. I had such a good time chatting with these two and I know you'll enjoy this episode. With that, I bring you Aarthi and Sriram after a short word from our select sponsors.

**中文翻译:**
这一集绝对是我在这个播客上进行过的最有趣的对话。我们涵盖了各种领域，包括“技术乐观主义”趋势、建立人脉、在线创作内容及其实操方法、成为产品领导者、社区建设，以及最后关于为什么 JTBD 框架行不通的一段搞笑吐槽。和他们两位聊天非常愉快，我知道你们也会喜欢这一集的。在听完赞助商的简短介绍后，让我们欢迎 Aarthi 和 Sriram。

---

### [00:02:02] Lenny (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If your business stores any data in the cloud, then you've likely been asked or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company is taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements. Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals or it can put your business on hold.

**中文翻译:**
本集节目由 Vanta 赞助播出，Vanta 帮助您简化安全合规流程，加速业务增长。如果您的企业在云端存储任何数据，那么您很可能已经被问到或即将被问到 SOC 2 合规性问题。SOC 2 是证明您的公司正在采取适当安全措施保护客户数据的一种方式，它能建立客户和合作伙伴（尤其是那些有严格安全要求的客户）的信任。此外，如果您想向企业级客户销售产品，证明安全性至关重要。SOC 2 既能为您开启更大、更好的交易大门，也可能让您的业务陷入停滞。

---

### [00:02:37] Lenny (Sponsor: Vanta)

**English:**
If you don't have a SOC 2, there's a good chance you won't even get a seat at the table beginning. Getting a SOC 2 report can be a huge burden, especially for startups. It's time-consuming, tedious and expensive. Enter Vanta. Over 3,000 fast-growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time, Lenny's Podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
如果你没有 SOC 2 报告，很有可能连谈判桌都上不去。获取 SOC 2 报告可能是一个巨大的负担，尤其是对于初创公司来说。它耗时、繁琐且昂贵。这就是 Vanta 的用武之地。超过 3,000 家快速增长的公司使用 Vanta 来自动完成高达 90% 的 SOC 2 相关工作。Vanta 可以在几周内（而不是几个月）让您准备好接受安全审计，时间不到通常所需的三分之一。在限定时间内，Lenny 播客的听众可以享受 1,000 美元的 Vanta 优惠。只需访问 vanta.com/lenny 了解更多信息并领取折扣。今天就开始吧。

---

### [00:03:20] Lenny (Sponsor: Dovetail)

**English:**
This episode is brought to you by Dovetail, the customer insights platform for teams that gets you from data to insights fast, no matter the method. There's so much customer data to get through, from user interviews to NPS, sales calls, usability tests, support tickets, app reviews, it's a lot. And you know that if you're building something, hidden in that data are the insights that will lead you to building better products and that's where Dovetail can help. Dovetail allows you to quickly analyze customer data from any source and transform it into evidence-based insights that your whole team can access.

**中文翻译:**
本集节目由 Dovetail 赞助播出。Dovetail 是一个为团队打造的客户洞察平台，无论采用何种方法，都能让您快速从数据中获得洞察。有太多的客户数据需要处理，从用户访谈到 NPS、销售电话、可用性测试、支持工单、应用评论，内容非常多。你知道，如果你在打造产品，那些能引导你做出更好产品的洞察就隐藏在这些数据中，而这正是 Dovetail 可以提供帮助的地方。Dovetail 允许您快速分析来自任何渠道的客户数据，并将其转化为整个团队都可以访问的、基于证据的洞察。

---

### [00:04:00] Lenny (Sponsor: Dovetail)

**English:**
If you're a product manager who needs insights to motivate your team, a designer validating your next big feature or researcher who needs to analyze fast, Dovetail is the collaborative insights platform your whole team can use. Go to dovetailapp.com/lenny to get started today for free. That's dovetailapp.com/lenny. Aarthi and Sriram, welcome to the podcast.

**中文翻译:**
如果你是需要洞察来激励团队的产品经理，或是正在验证下一个重大功能的设计师，亦或是需要快速分析的研究员，Dovetail 都是你整个团队可以使用的协作洞察平台。访问 dovetailapp.com/lenny 即可免费开始使用。网址是 dovetailapp.com/lenny。Aarthi 和 Sriram，欢迎来到我的播客。

---

### [00:04:20] Aarthi Ramamurthy

**English:**
Thank you. Thanks so much for having us, Lenny. This is a bucket list thing because we are on Lenny's Podcast.

**中文翻译:**
谢谢。非常感谢你邀请我们，Lenny。这绝对是人生清单上的一项，因为我们终于上了 Lenny 的播客。

---

### [00:04:27] Sriram Krishnan

**English:**
I know. Longtime subscriber, listener and now here. Wow. I don't want to screw this up.

**中文翻译:**
没错。我是你的长期订阅者和听众，现在居然坐在这里。哇，我可不想把这搞砸了。

---

### [00:04:36] Aarthi Ramamurthy

**English:**
First time caller.

**中文翻译:**
第一次连线。

---

### [00:04:37] Sriram Krishnan

**English:**
Yeah, first time caller. Yeah, let's not screw this up.

**中文翻译:**
是的，第一次连线。对，咱们别搞砸了。

---

### [00:04:39] Lenny

**English:**
You guys are hilarious. I appreciate it and feel very flattered. You two are the first duo on this podcast and I couldn't think of a better two people to start this podcast with. I have so much stuff I want to dig into. I think we're going to have a lot of fun, so again, thanks for joining me here.

**中文翻译:**
你们太幽默了。非常感谢，我感到受宠若惊。你们两位是这个播客的第一对组合嘉宾，我想不出比你们更合适的人选来开启这种形式了。我有太多的内容想深入探讨。我想我们会聊得很开心，再次感谢你们加入。

---

### [00:04:54] Aarthi Ramamurthy

**English:**
It's awesome. Big fan. Yeah, honestly, this just... I'm excited.

**中文翻译:**
太棒了。我是你的铁粉。说实话，我真的很兴奋。

---

### [00:05:00] Lenny

**English:**
So I don't know if you remember this, I was thinking about this story, back when you were doing the Good Time Show, you invited me on the Good Time Show and I was thinking, hesitating, like, "I don't know, that's kind of scary." And then the next day, Elon came on and then it just blew up and I was like, "Shit, I missed my chance." And then became really fancy people and I was like, "I'm not ever going to make it back on there." And so I look back at that as like, "Oh, I hesitated too long. That's a lesson."

**中文翻译:**
我不知道你们是否还记得，我一直在想这个故事：当年你们在做《Good Time Show》的时候，你们邀请过我，我当时还在犹豫，觉得“哎呀，这有点吓人”。结果第二天，埃隆（马斯克）就上了节目，然后节目彻底爆火。我当时心想：“该死，我错失良机了。”然后你们就成了大红人，我觉得自己再也没机会上你们节目了。所以回想起来，我觉得“噢，我犹豫太久了，这是个教训”。

---

### [00:05:22] Sriram Krishnan

**English:**
Well, the way you should interpret that is, "They couldn't get me on, so their backup choice was Elon. I would've been the main event and they were like, 'Well, oh, we couldn't get Lenny, we'll get... No, but seriously, we've been a huge fan and those are just the fun times. We used to do the show obviously on just Clubhouse and now we do the show on YouTube, wherever you can listen to our podcast. And a lot of people remember us for the Elon episode, but I will tell you this, it is often the folks who were working technology, who were not as famous, you're obviously very famous now, but who really connected with the audience. But you know what, that's why we have you back on the show now.

**中文翻译:**
好吧，你应该这样解读：“他们请不到我，所以备选方案是埃隆。我本该是主咖，结果他们只能说‘噢，请不到 Lenny，那咱们请那个谁吧……’”不，说认真的，我们一直是你的超级粉丝，那段时光很有趣。我们以前只在 Clubhouse 上做节目，现在在 YouTube 和各大播客平台都有。很多人因为埃隆那一集记住我们，但我告诉你，真正能引起观众共鸣的，往往是那些在科技领域深耕、虽然没那么出名（当然你现在非常出名了）的人。不过没关系，这就是为什么我们现在要把你请回来。

---

### [00:06:01] Aarthi Ramamurthy

**English:**
Opening act, yeah.

**中文翻译:**
（埃隆只是）开场表演，没错。

---

### [00:06:07] Lenny

**English:**
Speaking of Elon, I was always curious, how did you actually get him on the show? I remember that was back before he was very vocal in the world and he was hard to learn from and hear from. How did you actually pull that off?

**中文翻译:**
说到埃隆，我一直很好奇，你们到底是怎么请到他的？我记得那是他还没像现在这样在全世界频繁发声的时候，当时很难有机会听到他的分享。你们是怎么做到的？

---

### [00:06:18] Sriram Krishnan

**English:**
Well, I think it's actually similar to how a lot of good things in my career have happened, which is I just had a conversation on the internet. I have this whole thing where I do think a lot of people trying to get ahead in their career, especially in technology, should just write cold emails, cold DMs, notes, put out content, et cetera and that leads to good things.

**中文翻译:**
嗯，我觉得这和我职业生涯中很多好事发生的路径很像，就是我在网上发起了一段对话。我一直认为，很多想在职业生涯中取得进步的人，尤其是在科技行业，应该多写冷邮件（cold emails）、发私信、写笔记、发布内容等等，这些都会带来好结果。

---

### [00:06:39] Sriram Krishnan

**English:**
In Elon's case actually, what wound up happening was a few years ago, he DMed me out of the blue. At the time, I was working at Twitter and I think he saw something I'd written and wanted something from the company and I think he went through the org chart and he DMed me. And I was like, "Well, I'd love to help you," and he sent me his phone number. And I called him and I was like, "Is this [inaudible 00:07:00] and we had a conversation and we built up a relationship after that. This was when Clubhouse first came on the scene and I was like, "Well, who do we get on?" and Elon hadn't done a lot of press appearances, I think he's done a lot more since then obviously, and I texted him and he was like, "I'm game," and the rest is history.

**中文翻译:**
至于埃隆，实际情况是几年前，他突然给我发了私信。当时我在 Twitter 工作，我想他看到了我写的某些东西，或者想从公司得到某些支持，他可能翻了组织架构图，然后私信了我。我说：“我很乐意帮你。”然后他把电话号码发给了我。我打给他，确认是他本人后，我们聊了聊，之后就建立起了联系。当 Clubhouse 刚兴起时，我在想：“我们该请谁呢？”当时埃隆还没做过太多的媒体出镜（显然之后多得多了），我给他发了短信，他说：“我加入。”剩下的就是大家知道的历史了。

---

### [00:07:20] Lenny

**English:**
Amazing. I love that Elon just DMed you. Sriram-

**中文翻译:**
太神奇了。我喜欢埃隆直接私信你这个细节。Sriram——

---

### [00:07:25] Aarthi Ramamurthy

**English:**
Slid into his DMs.

**中文翻译:**
直接溜进了他的私信列表。

---

### [00:07:26] Sriram Krishnan

**English:**
The crazy part of that story was I had texted him saying, "You should come on the show," and he said, "Sure," and then he tweeted about it. And I will tell you that when Elon tweets about you and well, even maybe more so now, your phone just melts. And then for the entire afternoon, I had hundred thousands of people asking me what's going to happen, the Clubhouse people-

**中文翻译:**
那个故事最疯狂的部分是，我发短信跟他说：“你应该来上节目。”他说：“好啊。”然后他就发了推特。我告诉你，当埃隆发推特提到你时——现在可能更夸张——你的手机会直接“融化”。整个下午，成千上万的人在问我发生了什么，Clubhouse 的人也找过来了——

---

### [00:07:46] Aarthi Ramamurthy

**English:**
But also on Clubhouse, if you open the Clubhouse app that day, there were so many rooms that were trying to collect questions for us and help us prepare. There was so much pressure just scrolling through the hallway and trying to look through, it's like, "Oh my God, is this real? We are the people that they're talking about here. This is crazy." I don't know if you've listened to the actual thing, but it was pretty cool because we got to ask him questions we've always wanted to ask on like, "When do we get to Mars?" it was kind of fun. And then after that, again it was this, we got a bunch of people reaching out and being like, "You should have asked this question. You guys are not professional journalists." And we are like, "No, we're not. What gave it away?" We are just random two people who are just talking to this guy, so it was really fun.

**中文翻译:**
而且在 Clubhouse 上，如果你那天打开 App，会发现到处都是房间在帮我们收集问题、帮我们做准备。压力太大了，刷着动态心想：“天哪，这是真的吗？我们就是他们讨论的对象，这太疯狂了。”我不知道你有没有听过那一集，但真的很酷，因为我们问了一些一直想问他的问题，比如“我们什么时候能上火星？”挺有意思的。在那之后，又有一堆人找过来说：“你们应该问那个问题的，你们不是专业的记者。”我们心想：“对啊，我们不是，你是怎么看出来的？”我们只是两个普通人，在和这家伙聊天，所以过程非常有趣。

---

### [00:08:33] Lenny

**English:**
Yeah, I remember that. I remember journalists were like, "They're not actually asking him hard questions. How dare they have him on, give him a platform to share things without any criticism?"

**中文翻译:**
是的，我记得。我记得记者们当时说：“他们根本没问他尖锐的问题。他们怎么敢邀请他，给他一个平台让他毫无批判地分享观点？”

---

### [00:08:39] Aarthi Ramamurthy

**English:**
And we were like, "We are not those people that you think we are, that's just never been our job."

**中文翻译:**
我们的反应是：“我们不是你们想象中的那种人，那从来就不是我们的工作。”

---

### [00:08:46] Lenny

**English:**
Yeah. I have so many questions that spiral from this discussion, but I want to ask one quick Clubhouse question. So Aarthi, you worked at Clubhouse for a while. Very tactically, I feel like they're really smart initially with their growth strategy of just getting fancy, smart people in there talking and pontificating. They had Naval and Marc Andreessen and then eventually, you want other people. And that was such a smart way to get people to get in there and want to get in there to listen to them, to engage with them. What's your take on that as just a growth strategy to get a social network bootstrapped? And then just generally, I guess any thoughts on the journey of Clubhouse? It's had a big rise, it's kind of [inaudible 00:09:22].

**中文翻译:**
是的。从这段讨论中我延伸出了很多问题，但我先问一个关于 Clubhouse 的小问题。Aarthi，你在 Clubhouse 工作过一段时间。从战术上讲，我觉得他们最初的增长策略非常聪明，就是邀请那些厉害的、聪明的人在里面谈笑风生。他们请到了 Naval 和 Marc Andreessen，然后慢慢吸引其他人。这是一种非常聪明的冷启动社交网络的方式，让人们想进去听他们说话、与他们互动。你如何看待这种作为社交网络冷启动的增长策略？另外，对于 Clubhouse 的历程你有什么看法？它经历了大起大落，现在有点……

---

### [00:09:21] Aarthi Ramamurthy

**English:**
Yeah. I mean, all good questions here. I think growth strategy, that's a great way to acquire people right at the top of the funnel. Once you've done this a few times, you kind of see everything as a funnel and you're like, "Well, are you retaining people? Are you not? Is it top of the funnel impressions or do they stick around?" So I think having people like Marc Andreessen and people like Naval and they were not doing this out of any... they were really, really interested. When we got invited by Marc and Marc was like, "Check out... this was way before a16z even invested in it, was like, "This product is amazing. These folks are doing something really cool, this is going to be the future, it's amazing." So it gave them a platform to go speak out and live social audio just made a ton of sense. I will say, Clubhouse, I feel like they get this unfair attention and criticism. It's a what, three-year-old startup?

**中文翻译:**
是的，这些都是好问题。我认为从增长策略来看，这是在漏斗顶端获取用户的一种极佳方式。当你做过几次产品后，你会把一切都看作漏斗，你会问：“用户留存了吗？还是流失了？这只是漏斗顶端的曝光，还是他们真的留下来了？”我觉得邀请 Marc Andreessen 和 Naval 这样的人，他们并不是出于什么目的，而是真的感兴趣。当 Marc 邀请我们时——那是在 a16z 投资之前——他说：“看看这个，这个产品太棒了。这些人正在做一些非常酷的事情，这将是未来。”所以这给了他们一个发声的平台，实时社交音频在当时非常有意义。我想说，Clubhouse 承受了一些不公平的关注和批评。它才是一个成立三年的初创公司吧？

---

### [00:10:17] Aarthi Ramamurthy

**English:**
And I've done two startups. The second one I did, three years in, we still sort of were struggling and trying to figure out what we were doing. So I mean, I feel like founders just need some time to breathe in and figure out what to go do. So I'm bullish on Clubhouse, I think they'll figure it out and Paul and Rohan are great founders. They've been doing social stuff for over a decade plus and so they've got to figure it out. And I know that it's like, they get this thing on, "Oh, they were really hot during the pandemic. Is this a pandemic fad versus not?" I don't know, it's a product at the end of the day and you're going to have to find product market fit and I think they'll figure it out.

**中文翻译:**
我自己做过两家初创公司。我做的第二家，到了第三年我们还在挣扎，试图搞清楚我们在做什么。所以我觉得创始人只需要一些喘息的时间来思考下一步。我对 Clubhouse 持乐观态度，我觉得他们会找到出路的，Paul 和 Rohan 是非常优秀的创始人。他们做社交产品已经超过十年了，所以他们肯定能搞定。我知道有人会说：“噢，他们只是在疫情期间火了一把，这只是疫情红利吗？”我不知道，归根结底它是一个产品，你必须找到产品市场契合度（PMF），我相信他们会做到的。

---

### [00:10:56] Sriram Krishnan

**English:**
Yeah. The broader question of how do social products acquire the users is super interesting. One of my favorite pieces written on this is Eugene Wei's Status as a Service. Eugene should absolutely be on your podcast someday. It's a 10,000 word piece, which is amazing and highly suggest people read it. But one of the key takeaways from that piece is the idea that when you have a new network, think of it as a new country, you want the high status people and high status mean they're interesting, people want to be where they are in some shape or form because they have money, they're smart, they're cool, they're good-looking, whatever it may be and you want to get them onto your network. And there's exactly an interesting corollary that they're often underserved by other existing platforms. And because if they're already well-served, they wouldn't want to move to you.

**中文翻译:**
是的。关于社交产品如何获取用户的更广泛问题非常有趣。关于这一点，我最喜欢的文章之一是 Eugene Wei 写的《地位即服务》（Status as a Service）。Eugene 某天绝对应该上你的播客。那是一篇一万字的长文，非常精彩，强烈建议大家阅读。那篇文章的一个核心观点是：当你建立一个新网络时，把它想象成一个新国家，你需要高地位的人。高地位意味着他们很有趣，人们想以某种形式出现在他们所在的地方，因为他们有钱、聪明、酷、长得好看等等。你想把他们吸引到你的网络中。这里有一个有趣的推论：这些人往往在现有平台上没有得到很好的服务。因为如果他们已经得到了很好的服务，他们就不会想迁移到你的平台。

---

### [00:11:43] Sriram Krishnan

**English:**
And Eugene doesn't talk about it, but if I look at say the history of all the three, four large social media companies, you've seen this pattern. For example, they've often each had a breakout set of stars who are unique to the platform. For example, if you look at say Snapchat, you had folks like Kylie Jenner who really broke out first. If you look at Instagram, I would think The Rock, Cristiano Ronaldo, a lot of others are organic to Instagram. But let's say you get to TikTok. One of the things you'll see is a lot of the folks from the Instagram world rarely move to TikTok and there's a couple of reasons. One, they didn't really need to because they were already popular on some of these other existing platforms, but two, TikTok actually took advantage of a different set of skillsets. People who are really good on video, people who could dance, be funny. And so you saw the rise of Charli D'Amelio and Addison and so many others who are different.

**中文翻译:**
Eugene 没提到这一点，但如果我看那三四家大型社交媒体公司的历史，你会发现这种模式。例如，它们通常都有各自独特的、在该平台上爆发的明星。比如 Snapchat，有像 Kylie Jenner 这样最先爆发的人。Instagram 的话，我觉得巨石强森、C罗等很多人都是在 Instagram 上原生发展起来的。但到了 TikTok，你会发现很多 Instagram 的红人很少迁移到 TikTok，原因有二：第一，他们没必要，因为他们在现有平台上已经很火了；第二，TikTok 实际上利用了一套不同的技能点——擅长视频、会跳舞、幽默的人。所以你看到了 Charli D'Amelio、Addison Rae 以及许多其他完全不同类型的人的崛起。

---

### [00:12:31] Sriram Krishnan

**English:**
So every single time, I think you need to go after a set of people who are high status who are also underserved. So coming back to Clubhouse, I think one of the interesting things is I think these celebrities are super interesting, but what is more interesting for me is all the homegrown folks. I actually consider us as a part of that, we would not be here doing the show if it wasn't for Clubhouse. There are many folks who had that original launch using the platform, so I think for folks here who are thinking about social platforms, it's interesting about okay, you need interesting people from elsewhere, but you also need homegrown talent. And by the way, you are a perfect example of this phenomenon because you are Substack's homegrown talent and I think you bring a lot of value to Substack. And there are a lot of people with huge newsletters, et cetera, but I think your rise and your popularity is so tied to Substack now and that's actually a great example of all of this.

**中文翻译:**
所以每一次，我认为你都需要去争取那一群既有高地位又未被充分服务的人。回到 Clubhouse，我觉得那些名人的加入很有趣，但对我来说更有趣的是那些“土生土长”的用户。我实际上把我们也看作其中的一部分，如果没有 Clubhouse，我们今天就不会在这里做节目。有很多人的事业是从这个平台起步的。所以对于正在思考社交平台的人来说，有趣的一点是：你需要从别处引进有趣的人，但你也需要培养本土人才。顺便说一下，你就是这种现象的完美例子，因为你是 Substack 的本土人才，你为 Substack 带来了巨大的价值。虽然有很多拥有庞大订阅量的人，但我觉得你的崛起和知名度与 Substack 紧密相连，这正是这种模式的绝佳案例。

---

### [00:13:25] Lenny

**English:**
Yeah. It reminds me, the founder of Musical.ly who turned into TikTok has a great story. I think you've heard his talk about this, how the way he thought about it is there's all these successful people on Instagram, that's Europe, and the people you can convince to come to America are not the kings of Europe, but they're the peasants that are like, "Oh, we have a new opportunity to rise and become a king or a queen." And so those are the people you pull in, the people not doing well on another platform that want to do well versus the people already killing it.

**中文翻译:**
是的。这让我想起 Musical.ly（后来变成了 TikTok）创始人的一个精彩故事。我想你们听过他的演讲，他认为 Instagram 上那些成功的人就像是“欧洲”，而你能说服他们来到“美洲”的人，不是欧洲的国王，而是那些觉得“噢，我们有一个崛起并成为国王或女王的新机会”的平民。所以你要吸引的是那些在其他平台上表现一般但渴望成功的人，而不是那些已经功成名就的人。

---

### [00:13:53] Sriram Krishnan

**English:**
Lenny just called himself the king of Substack right there.

**中文翻译:**
Lenny 刚才就在那儿自封为 Substack 之王了。

---

### [00:13:55] Aarthi Ramamurthy

**English:**
Yes, I know. You're the king, you're the king of Americas.

**中文翻译:**
是的，我知道。你是国王，你是美洲之王。

---

### [00:13:58] Sriram Krishnan

**English:**
I'm just trying to give you clippable moments on video.

**中文翻译:**
我只是在帮你制造一些可以剪辑成短视频的高光时刻。

---

### [00:14:00] Lenny

**English:**
I did just find out that I think I have the fourth-largest Substack newsletter on all of Substack which is ridiculous-

**中文翻译:**
我刚发现，我的 Substack 订阅量在全平台排名第四，这简直不可思议——

---

### [00:14:05] Aarthi Ramamurthy

**English:**
That's amazing, wow. That's amazing.

**中文翻译:**
太棒了，哇。太了不起了。

---

### [00:14:08] Sriram Krishnan

**English:**
Yeah. Number three, number two, number one, Lenny is coming after you, better watch out.

**中文翻译:**
没错。第三名、第二名、第一名，Lenny 追上来了，你们最好小心点。

---

### [00:14:12] Lenny

**English:**
Yeah. They're up there. So you mentioned the chat with Elon and how you're very tech positive and I think that's something that you two are at the forefront of, is this trend, I don't know if it's called techno-optimism or maybe there's another term for it and I'd love to hear just like why? Because I know that's important to you too, why that's important to you and just what is this movement of techno-optimism-

**中文翻译:**
是的，他们在前面。你们提到了和埃隆的聊天，以及你们非常看好技术，我觉得你们两位处于这种趋势的前沿。我不知道这是否被称为“技术乐观主义”（techno-optimism），或者有别的称呼，我很想听听为什么？因为我知道这对你们很重要，为什么它对你们很重要，以及这种“技术乐观主义”运动到底是什么？

---

### [00:14:32] Aarthi Ramamurthy

**English:**
Let me take a small stab at it. Look, I think it's also very personal to our context and our upbringing. For us, Sriram and I came from a fairly middle class family in India, this city in India that most people here won't probably know. And we grew up really liking computers but didn't have access to a computer for a longest time. In both our cases, our parents bought us our first computers after saving money for it and it was a hard thing. And when we eventually got onto it and started learning to write code, we met each other online. We're dating ourselves now, but we met on Yahoo Messenger back in the day and we worked on this nerdy coding project, that's how we connected. So technology and computers have given us everything.

**中文翻译:**
让我来试着回答一下。听着，我觉得这与我们的背景和成长经历非常相关。我和 Sriram 都来自印度一个普通的中产阶级家庭，那个城市可能这里的大多数人都没听说过。我们从小就非常喜欢电脑，但很长一段时间都接触不到。我们两家的情况都是父母攒了很久的钱才给我们买了第一台电脑，那是一件很不容易的事。当我们终于用上电脑并开始学习写代码时，我们在网上相遇了。这暴露了我们的年龄，但我们当年是在 Yahoo Messenger 上认识的，我们一起做一个很宅的编程项目，就是这样建立联系的。所以，技术和电脑给了我们一切。

---

### [00:15:19] Aarthi Ramamurthy

**English:**
Our first jobs were at Microsoft, we built developer tools and platforms. If you were in our shoes, you would feel the same way too. Tech has given us so much. And so for us to come here all the way from India, through multiple cities, we lived in Seattle and then here, the Bay Area, I've started tech companies, it is a bit frustrating to see the other viewpoint because you can see how much it has uplifted people, careers, lives, but also just from what we've been able to work on, what we've seen our friends work on and ship and put out there, it has dramatically moved the needle. And so for us, we are the living testament of tech actually helping us and help us do better, so I don't even see the other viewpoint from like, why wouldn't you be optimistic about technology? I don't get it.

**中文翻译:**
我们的第一份工作都在微软，开发开发者工具和平台。如果你处在我们的位置，你也会有同样的感觉。技术给了我们太多。我们从印度一路走来，经过多个城市，住过西雅图，然后来到湾区，我创办了科技公司。看到另一种（悲观的）观点会让人感到有些沮丧，因为你可以看到技术如何提升了人们的地位、职业和生活。而且从我们参与的工作、我们看到朋友们开发并发布的产品来看，它极大地改变了现状。所以对我们来说，我们是技术真正帮助我们变得更好的活生生的见证。我甚至无法理解另一种观点——为什么会有人不对技术感到乐观？我不明白。

---

### [00:16:10] Sriram Krishnan

**English:**
Yeah. I think the personal part was really core. I think there's generally two schools of thought. One school of thought, I would broadly write up as things are getting worse, technology is making things worse and we should all do less, build less. And then the other school of thought, which I think I subscribe to, is technology is not perfect, the impact technology is definitely uneven, but pretty much most of the good things in the world over the last 100, 200 years are responsible for it. And we can have a whole long discussion about the evidence why and we have lots of very fancy sounding intellectual theories as to why, but at the heart of it is what Aarthi said, if it wasn't for tech, we wouldn't be here, we wouldn't be doing this.

**中文翻译:**
是的，我觉得个人经历是核心。通常有两种流派：一种流派大致认为事情正在变糟，技术让情况恶化，我们应该少做点、少建点。另一种流派——也是我认同的——认为技术并不完美，技术的影响确实是不均衡的，但过去 100 到 200 年里，世界上绝大多数美好的事物都要归功于它。我们可以就证据进行长篇大论，也有很多听起来很高大上的理论，但核心就是 Aarthi 说的：如果没有技术，我们今天就不会在这里，也不会在做这些事。

---

### [00:16:45] Sriram Krishnan

**English:**
I suspect a lot of folks who are listening to this wouldn't be able to listen to it, wouldn't have the opportunities they have or have the opportunities we have. It is a great level up. My dad pretty much had the same job for his entire life, essentially from age 25 till the time he retired and there was really no easy path out for him. And I imagine like, "Hey, if he was born 40 years later and he had a laptop and an internet connection and could get on GitHub, here are opportunities that would be just impossible, even 30, 40 years ago and that's all from technology." So I think that's at the heart of it, it's the best thing we have of getting ahead.

**中文翻译:**
我怀疑很多正在听这个节目的听众，如果没有技术，可能根本没法听到它，也不会拥有他们现在的机会，或者我们拥有的机会。这是一个巨大的阶层跃迁。我父亲一辈子几乎都在做同一份工作，从 25 岁一直到退休，他真的没有什么轻松的出路。我想，如果他晚出生 40 年，拥有一台笔记本电脑和网络连接，能上 GitHub，那么他将拥有 30、40 年前根本不可能实现的机会，而这一切都源于技术。所以我觉得这就是核心：技术是我们实现跨越式发展的最佳工具。

---

### [00:17:21] Lenny

**English:**
It's such a refreshing perspective on tech. In traditional media, all you ever hear about is all the problems that tech is causing and all the dangers and how we're all screwed. And so it's like you almost forget that there could be really positive stories about what's happening with tech and it feels like there's a small number of people that are doing this at scale and-

**中文翻译:**
这种对技术的看法真是令人耳目一新。在传统媒体中，你听到的全是技术带来的问题、各种危险以及我们如何完蛋了。所以你几乎会忘记技术也有非常积极的一面。感觉只有少数人在大规模地传播这种积极的声音……

---

### [00:17:40] Sriram Krishnan

**English:**
Oh, yeah. I'll give you one small example. You made a joke about kings from Europe, et cetera. If we just go back 100 years, the piece of hardware that a king or a royalty would use or a rich person would use would be so different from what a peasant would use, but you know what? I suspect the phone that you and I have is probably the same phone that... actually I know it's the same phone that Elon Musk uses, the richest person in the world. I know a lot of folks in India who have very high end Android device, they have access to the same internet. You go to google.com, google.com doesn't know your net worth, it gives you the same results. Chat GPT doesn't know how rich you are. It may not like you, but it doesn't know how rich you are. If you just think of all these constructs, they're were just impossible technology. But anyway, that's a whole other conversation.

**中文翻译:**
噢，是的。我给你举个小例子。你刚才开了个关于欧洲国王的玩笑。如果回到 100 年前，国王或皇室成员使用的硬件，或者富人使用的东西，会和农民使用的完全不同。但你知道吗？我怀疑你我手里拿的手机，和……事实上我知道，和世界首富埃隆·马斯克用的是同一款手机。我知道印度很多拥有高端安卓设备的人，他们访问的是同一个互联网。你访问 google.com，谷歌不知道你的净资产，它给你同样的结果。ChatGPT 不知道你多有钱。它可能不喜欢你，但它不知道你多有钱。如果你思考这些架构，在没有技术的情况下它们是不可能实现的。不过，那是另一个话题了。

---

### [00:18:24] Lenny

**English:**
Yeah, I love that the richest people have the same phone as me and nothing they can do about it. Something else you two are really good at is building a network, building community, building personal brands. I know a lot of people listening are either often told, "You need to build a audience online, you build a brand, you got to build a network," and all these things. So I guess I'd love to know just what advice do you give people that come to you and like, "Hey, I want to build a personal brand, I want to build the network"? Just how to go about doing that, what's worked well for you two?

**中文翻译:**
是的，我喜欢这种“最富有的人和我用一样的手机，而且他们对此无能为力”的感觉。你们两位还非常擅长另一件事：建立人脉、建立社区、建立个人品牌。我知道很多听众经常被告知：“你需要在网上建立受众，建立品牌，建立人脉”等等。所以我很想知道，对于那些来找你们说“嘿，我想建立个人品牌，我想建立人脉”的人，你们会给什么建议？具体该怎么做？对你们两位来说，哪些方法最有效？

---

### [00:18:54] Aarthi Ramamurthy

**English:**
Sriram has way more structured thoughts on this and honestly, he's way better at this than I've ever been. He's basically slowly corrupted me and brought me to the dark side. But what I have come to believe and this differs from what I used to believe is especially if you're working in a big company, you are one of the many thousands of employees in there. Generally what you get told is, "Hey, just ship really good products, put your head down, go to work. The products will speak for themselves. That's just how it's going to work. Don't do this whole personal branding and all of that stuff. It's such a distraction," and that's generally what you're told.

**中文翻译:**
Sriram 对此有更系统化的想法，老实说，他在这方面比我强得多。他基本上是慢慢“腐蚀”了我，把我带到了这一边。但我现在所相信的——这与我过去的看法不同——是：特别是如果你在大公司工作，你只是成千上万名员工中的一员。通常人们会告诉你：“嘿，只要做出好产品，埋头苦干就行。产品自己会说话。事情就是这样运作的。别搞什么个人品牌之类的，那太让人分心了。”这通常是你听到的建议。

---

### [00:19:34] Aarthi Ramamurthy

**English:**
Most of my career I was like, "Yeah, of course that makes sense, that's kind of what you do." But I've come to realize that that is just not true and this might be a controversial opinion, but you have to get out there and build your own brand. You have to figure out what you stand for, what your core values are, what you believe in, what you think you want to do, what your next career trajectory is going to look like. All of that is just up to you. It's not up to the company to figure it out for you, it's not up to anybody else, it's just up to you.

**中文翻译:**
在我职业生涯的大部分时间里，我都觉得：“是的，当然有道理，大家都是这么做的。”但我后来意识到，那根本不是真的。这可能是一个有争议的观点，但你必须走出去建立自己的品牌。你必须搞清楚你代表什么，你的核心价值观是什么，你相信什么，你想做什么，你下一个职业轨迹是什么样的。所有这些都取决于你自己。公司不会帮你搞清楚，别人也不会，只能靠你自己。

---

### [00:20:05] Aarthi Ramamurthy

**English:**
And I think building a personal brand is looked down upon so much that people think of it as a dirty word. It's like, "No, you can't do that." "Oh, look at this person who's branding themselves," kind of thing. But I almost see it as what distinguishes you from everybody else and that is not so much saying something that you're not good at or touting yourself more, it's really about highlighting, "I'm really good at this thing and I want to talk about this thing and I want to do videos about it or write about it or tweet about it." Whatever is your forum, you have to put yourself out there.

**中文翻译:**
我觉得“建立个人品牌”现在被贬低得太厉害了，以至于人们觉得它是个贬义词。就像是，“不，你不能那样做”，“噢，看那个人在自我营销”之类的。但我几乎把它看作是让你脱颖而出的东西。这并不是说要去吹嘘你不擅长的事，或者过度夸大自己，而是要强调：“我非常擅长这件事，我想聊聊这件事，我想为此拍视频、写文章或发推特。”无论你的平台是什么，你都必须展示自己。

---

### [00:20:43] Sriram Krishnan

**English:**
I mean this is probably one of the most important things that somebody can do and I spent... no, we spent years slowly climbing the corporate ranks. We were junior product managers, IC product managers, senior product managers, slowly climbed the ranks and ran teams, et cetera. And I spent years just thinking that all I need to do is put my head down, do my job really well and that was it. But then I looked around and I suspect a lot of listeners here probably have the same feeling that some sort of people were getting way more opportunities, some sort of people are way farther ahead even though I was mostly sure that somebody else was doing a better job and I was trying to understand why. And I think building a network, which I'll try and define because I think a lot of people have assumption of what it is, is at the heart of this. So building a network is very simply having relationships with human beings. And let's start off by saying first of all, these have to be authentic, genuine relationships.

**中文翻译:**
我的意思是，这可能是一个人能做的最重要的事情之一。我花了……不，我们花了多年时间在公司阶梯上慢慢攀爬。我们当过初级产品经理、一线产品经理（IC）、高级产品经理，慢慢晋升并带领团队等等。我花了多年时间认为，我只需要埋头苦干，把工作做好就行了。但后来我环顾四周，我怀疑这里的很多听众可能也有同样的感觉：某些人似乎得到了更多的机会，某些人走得更远，尽管我基本确定有其他人工作做得更好。我试图理解为什么。我认为建立人脉是核心，我想试着定义一下“人脉”，因为很多人对它有误解。建立人脉其实非常简单，就是与人建立关系。首先要说的是，这些必须是真实、真诚的关系。

---

### [00:21:29] Sriram Krishnan

**English:**
One thing, it drives me crazy when somebody will come and say, "I'm here to network." I'm like, "I don't know what that word means." So all you're trying to do is have authentic, genuine relationship with people and expecting nothing in return, so that's great. And then people are like, "Oh, well that's awesome, but I'm a senior... for example, I was a senior PM at Microsoft for a bunch of time and then kind of similar at Facebook for a bunch of time, you're like, "Well, what does it mean? I'm here, I'm going to my meetings, I'm doing my day, its only so many hours." I'll be like, "Well, let's start off with go and meet every single peer that you have you don't directly meet with. Go get coffee with them and ask them, 'Hey.' Have no agenda. Just ask them what's going on in their life, who are they, what their life story is and then who are a couple of interesting people that you should meet with? Go talk to your manager and go talk to their peers."

**中文翻译:**
有一件事让我很抓狂，就是有人过来说：“我是来社交（network）的。”我会想：“我不知道那个词是什么意思。”你真正要做的是与人建立真实、真诚的关系，并且不求回报，这才是最棒的。然后人们会说：“噢，那很好，但我只是个高级……比如，我在微软当了很久的高级产品经理，在 Facebook 也是，你会想：‘那意味着什么？我每天开会、工作，时间就那么多。’”我会说：“好吧，让我们从去见每一个你不直接共事的同事开始。去和他们喝杯咖啡，打个招呼。不要带着目的。只是问问他们生活怎么样，他们是谁，他们的故事是什么，然后问问还有哪些有趣的人是你应该认识的？去和你的经理聊聊，也去和他们的同级聊聊。”

---

### [00:22:14] Sriram Krishnan

**English:**
Super important, by the way, your manager, peer relations are super important. Go have a coffee with them and they'd be like, "Great, I'm love to meet this person." Then when I joined at Facebook, I was notorious for being the person who sent a cold email to every single Facebook leader. And I'd be like, "Hey, I'm new here, I want to meet. Let's grab coffee," and everybody will say as everyone is a new person and always asking the same thing, which I'll be like, I show up, I'll tell them my story, I'll ask for their story. I'll be like, "What are you folks focused on? How can I help?" Again, no expectation of anything in return. And then I'll be like, "Who else should I talk to?"

**中文翻译:**
顺便说一下，你经理的同级关系非常重要。去和他们喝杯咖啡，他们会觉得：“太好了，我很想认识这个人。”当我加入 Facebook 时，我因为给每一位 Facebook 领导层发冷邮件而“臭名昭著”。我会说：“嘿，我是新来的，我想见见你。咱们喝杯咖啡吧。”大家都会说，每个新人都会问同样的事。但我会准时出现，告诉他们我的故事，询问他们的故事。我会问：“你们现在关注什么？我能帮上什么忙？”再次强调，不求回报。然后我会问：“我还应该和谁聊聊？”

---

### [00:22:42] Sriram Krishnan

**English:**
You do this, you do two coffees a week and literally just ask me two hours a week, everyone has two hours a week, it'll start compounding over overtime and time. And then as the years go by, you keep in touch with the people you used to work with you, these folks will go to other places, five years, six years go by, you start in your mid-20s or late 20s and you know hundreds of people all over. And the important thing about this is that it is a resource in so many different places. For example, one, if you ever need help, you're trying to look for a new role or you're trying to be like, "Hey, I want to hire this person, who knows something about this person?" or, "I want a new role. Who's looking for something?" that network becomes your key resource.

**中文翻译:**
你这样做，每周喝两次咖啡，真的只需要每周花两小时，每个人都有两小时，随着时间的推移，这会产生复利效应。几年后，你与曾经共事过的人保持联系，这些人会去其他地方。五年、六年过去了，你从 20 多岁开始积累，现在你到处都认识几百个人。这件事的重要性在于，它在很多不同的地方都是一种资源。例如，如果你需要帮助，想找新工作，或者想招聘某人并打听一下他的情况，或者你想换个环境问问谁在招人，那个人脉网就成了你的核心资源。

---

### [00:23:21] Sriram Krishnan

**English:**
Now what I think a lot of people don't do, it's just simple things. Number one is often people just have a great meeting with a peer and then they will never ever follow up. I'm sure a lot of us have the amazing first introduction email they never followed up, don't do that. I try and make it a point to make sure I always meet them once a year, once every six months. I'll just leave a note, "Hey, what's up?" And the other key part is expecting nothing in return. And generally people are very good at reading other people and if you go and being like, "Hey, I just want to meet you because I want a job or I'm here to network," whatever that means, they don't want to meet you. Just go and be very curious about who they are and try and help them. And you'll be surprised wherever you start, within a year, two years, you'll know hundreds of people who you can tap into, so I think that is super powerful. That's just building relationships.

**中文翻译:**
我觉得很多人没做到的其实是一些简单的小事。第一，人们经常在和同事聊得很愉快后，就再也不跟进了。我相信我们很多人都发过很棒的第一封介绍邮件，然后就没下文了，千万别那样。我努力做到每年或每半年见他们一次。我会留个便条：“嘿，最近怎么样？”另一个关键点是不求回报。通常人们很擅长看穿别人，如果你去见某人是因为“嘿，我想见你是因为我想要份工作”或者“我是来社交的”，不管那是什么意思，他们都不会想见你。只要对他们是谁充满好奇，并试着帮助他们。你会惊讶地发现，无论你从哪里开始，一两年内，你就能认识几百个可以联系的人。我觉得这非常强大。这就是建立关系。

---

### [00:24:05] Sriram Krishnan

**English:**
The other part is brand building. Both Aarthi and I at different points in our career have gotten feedback in our job saying, "Oh, with Sriram and Aarthi, it's brand build too much, et cetera." I have learned that that is terrible feedback and to totally ignore that and if anybody hears anything like that, just totally ignore that. The things that work well for me and a lot of others is putting yourself out there and that can be anything. That can be like you make a presentation internally, you write tweets, you're prolific on GitHub, you make a YouTube video, it doesn't really matter, but put yourself out there because the internet rewards people being out there. And what happens when you put yourself out there? It's a Bat-Signal. It's telling people that, "Hey, I'm here, this is my body of work," and you know what the internet does? It'll send amazing people to you.

**中文翻译:**
另一部分是品牌建设。Aarthi 和我在职业生涯的不同阶段都收到过这样的反馈：“噢，Sriram 和 Aarthi 搞个人品牌搞得太过火了”等等。我学到的是，那是极其糟糕的反馈，完全可以忽略它。如果有人听到类似的话，直接无视。对我及许多其他人有效的方法就是展示自己，形式不限。可以是做内部演示、写推特、在 GitHub 上保持活跃、拍 YouTube 视频，这都不重要，重要的是展示自己，因为互联网会奖励那些敢于展示自己的人。当你展示自己时会发生什么？就像发出了“蝙蝠信号”。它在告诉人们：“嘿，我在这里，这是我的作品。”你知道互联网会怎么做吗？它会把优秀的人带到你面前。

---

### [00:24:45] Sriram Krishnan

**English:**
You'd be amazed how often somebody just have a random great Twitter thread with no followers and somebody super interesting will email them and that leads to amazing things happening, it encourages serendipity. So over the years, I wish I had listened less to people who said I should not do this and listened more to the people who said I should do this more.

**中文翻译:**
你会惊讶地发现，经常有人只是发了一串很棒的推特（Twitter thread），虽然没什么粉丝，但会有非常有趣的人给他们发邮件，从而引发奇妙的事情。这会鼓励“不期而遇的惊喜”（serendipity）。所以这些年来，我真希望我当初少听那些叫我别这么做的人，多听那些叫我多这么做的人。

---

### [00:25:02] Aarthi Ramamurthy

**English:**
I also think, Sriram keeps saying, "Expect nothing in return," I think the other way I see it is this is again an extension of optimism for us. Generally, we think people like to help each other out, that is just in their true nature. It's not meant to be transactional, it's not meant to be, "If I know them, they will somehow do something for me down the road," it's not that. Just the way we are all building communities and are a part of this broader community, the way we work is we all want to help each other and help them be successful. And if that is in your nature, it's hard to not feel like, "Yeah, of course I want to reach out to them. I want to see what I can do to help them. Maybe something good will happen, we'll collaborate on a project together," whatever. The core tenant being don't expect stuff in return, don't do it on a transactional basis, I think is really important.

**中文翻译:**
我还觉得，Sriram 一直在说“不求回报”，我从另一个角度看，这又是我们乐观主义的一种延伸。通常我们认为人们喜欢互相帮助，这是人的天性。这不应该是交易性的，不是说“如果我认识他们，以后他们就会为我做点什么”，不是那样的。就像我们都在建立社区并成为这个更广泛社区的一部分一样，我们的运作方式是大家都想互相帮助，帮助彼此成功。如果这是你的天性，你很难不觉得：“是的，我当然想联系他们。我想看看我能帮上什么忙。也许会有好事发生，我们会一起合作一个项目”之类的。核心原则是不求回报，不要基于交易去做事，我认为这非常重要。

---

### [00:25:53] Lenny

**English:**
What this reminds me of is Naval has this tweet that proved to be so true, which is don't network, instead create amazing things, create value, do good work and then people will want to network with you. And that's really stuck with me and it saves you from going to network events. Instead just go work hard, do awesome stuff and people are going to want to meet you.

**中文翻译:**
这让我想起了 Naval 的一条推特，事实证明那是真理：不要去社交（network），而是去创造惊人的东西，创造价值，做好工作，然后人们就会想来结识你。这句话深深地印在我的脑海里，它让你免于参加那些无聊的社交活动。相反，只要努力工作，做出很棒的东西，人们自然会想见你。

---

### [00:26:12] Aarthi Ramamurthy

**English:**
I mean you will not believe the number of times I've shown up to some meetup or some founder thing or something and then somebody would come up and be like, "I'm here to network, what's your name?" And I'm like, "What? No, you can't do that. Not how that works."

**中文翻译:**
我的意思是，你简直不敢相信有多少次我参加一些聚会或创始人活动，有人走过来直接说：“我是来社交的，你叫什么名字？”我心想：“什么？不，你不能那样做。社交不是那样运作的。”

---

### [00:26:26] Sriram Krishnan

**English:**
I actually say I disagree with Naval on this because often, when you're part of a large organization, it's really hard to do great work and get recognized for it. You're part of a team, which is great, but it's not the same as saying having a newsletter by yourself or having a piece of content by yourself. So when I was younger, I'd be like, "Great, I'm part of a large part-

**中文翻译:**
实际上，我在这一点上不同意 Naval。因为通常当你身处一个大型组织时，很难做出伟大的工作并因此获得认可。你是团队的一员，这很好，但这和你自己写一份时事通讯或自己创作一份内容是不一样的。所以当我年轻的时候，我会觉得：“太好了，我是大公司的一部分——”

---

### [00:26:48] Aarthi Ramamurthy

**English:**
I don't know, I mean you guys are saying the same thing, he's just saying create value and put it out there. I don't think it's-

**中文翻译:**
我不知道，我觉得你们说的是一回事，他只是说创造价值并把它展示出来。我不觉得这有什么——

---

### [00:26:53] Sriram Krishnan

**English:**
Yeah, I think the putting it out there part is super interesting. And also I would just say, don't wait to create amazing things. Often just the act of putting yourself out there can just spur amazing things in itself.

**中文翻译:**
是的，我觉得“展示出来”这一部分非常有趣。而且我还想说，不要等到创造出惊人的东西才开始。往往“展示自己”这个行为本身就能激发惊人的事情发生。

---

### [00:27:05] Lenny

**English:**
Yeah. And I think especially early in your career, you're not going to create amazing things immediately, so there's a lot of value to reaching out and meeting people. There's a couple of directions I want to go here. One is, so you gave this, I don't know, just mini masterclass on building a network and networking and things like that. I think what'll get people to rewind and listen to that again is I don't think people realize just how connected you two are. You're at the center of so many micro communities of the most incredible people. I don't know if you talk about this, but you run all these micro communities of incredible people in, I don't know, creator land and investors and product people and all these people and so it actually has worked. You may be the most networked person there is and I don't know if people know that.

**中文翻译:**
是的。而且我认为特别是在职业生涯早期，你不可能立即创造出惊人的东西，所以主动出击去结识他人非常有价值。我想从几个方向深入探讨。第一，你刚才进行了一场关于建立人脉和社交的小型大师课。我觉得会让人们倒回去重听的原因是，大家可能没意识到你们两位的关系网有多广。你们处于这么多由顶尖人才组成的微型社区的中心。我不知道你们是否聊过这个，但你们管理着这些由创作者、投资者、产品人等组成的微型社区，所以这套方法确实奏效了。你可能是人脉最广的人之一，我不知道大家是否了解这一点。

---

### [00:27:47] Sriram Krishnan

**English:**
Oh, wow. Is that a good thing? I don't know. Is that-

**中文翻译:**
噢，哇。那是好事吗？我不知道。那是——

---

### [00:27:47] Aarthi Ramamurthy

**English:**
It's a good thing.

**中文翻译:**
是好事。

---

### [00:27:51] Sriram Krishnan

**English:**
It's a good thing. Okay, I like that, I'll go with that.

**中文翻译:**
是好事。好吧，我喜欢这个说法，就这么定了。

---

### [00:27:53] Aarthi Ramamurthy

**English:**
I think the thing that, well at least with Sriram, outside of all of the masterclass stuff which I think he's particularly good at, I think the thing that Sriram, people don't realize about him is he's just inherently incredibly curious about people. He's just really just wants to know what somebody else does, who they are, what their story is. And this is not some like, "Oh, I'm going to spend 10 minutes letting them talk, I'm going to spend... he often never lets the other person talk, but when he does, he's truly-

**中文翻译:**
我觉得，至少对于 Sriram 来说，除了那些他特别擅长的大师课内容外，人们没意识到的一点是：他天生对人充满极强的好奇心。他真的很想知道别人在做什么，他们是谁，他们的故事是什么。这不只是那种“噢，我要花 10 分钟听他们说话”，他经常不让别人说话，但当他听的时候，他是真的——

---

### [00:28:26] Aarthi Ramamurthy

**English:**
... but he is truly curious about who they are, what their story is. By now, we've known each other for 20-ish years and this is every dinner, every event, this is just how he's wired and so you just can't fake that in building out a network. He builds a network by just wanting to know who these people are.

**中文翻译:**
……但他真的对他们是谁、他们的故事是什么感到好奇。到目前为止，我们已经认识 20 多年了，每一次晚餐、每一次活动，他都是这样的。所以在建立人脉时，这种特质是装不出来的。他建立人脉的方式就是单纯地想了解这些人。

---

### [00:28:49] Sriram Krishnan

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [00:28:50] Lenny

**English:**
That's beautiful.

**中文翻译:**
真美好。

---

### [00:28:51] Sriram Krishnan

**English:**
The woman I married, ladies and gentlemen, right there. You marry the right person, everything else becomes [inaudible 00:28:56]. I haven't really talked about this before and I'll keep some of this slightly hidden, but I think the heart of it is I'm just curious about people, I'm just dumb about a lot of things. And I don't mean it as this false modesty way, I know a lot of folks are smarter than me. Lenny obviously is so much smarter than me at writing a Substack newsletter, it's just evident, Andrew Huberman is great at... Brian Armstrong great at building a crypto company, all these folks just evident. But what I realized is a lot of folks sometimes just want to be with other amazing peers. And one sort of hack I built over the years, I was like, "All right, let me just bring interesting people together."

**中文翻译:**
女士们先生们，这就是我娶的女人。娶对了人，其他一切都变得……我以前没怎么聊过这个，我会保留一点神秘感，但我觉得核心是我对人充满好奇，而且我在很多事情上都很“笨”。我不是在假装谦虚，我知道很多人比我聪明。Lenny 在写 Substack 方面显然比我聪明得多，这是显而易见的；Andrew Huberman 擅长……Brian Armstrong 擅长建立加密货币公司，这些人都很厉害。但我意识到，很多优秀的人有时只是想和同样优秀的同伴待在一起。所以我这些年总结出的一个“黑客技巧”就是：“好吧，让我把有趣的人聚在一起。”

---

### [00:29:34] Sriram Krishnan

**English:**
So I bring them in, let's just say various kinds of online communities, they're probably over 100 at this point. And I say, "Okay. You trust me, you trust me and I make the rules." Everyone keeps some level of confidence, everyone is a peer, they're all accomplished in their own way, no one is rude or mean or goes off the rails. So I'm a party host, so I'm like, "Okay listen, nobody is going to get super crazy over here," but I'm also curating. I'm like, "Well, I need somebody super thoughtful, I need somebody who's a little controversial, I need somebody who's funny, I need somebody who's like the celebrity... I'm trying to put together, engineer the right vibe or the right atmosphere, but digitally, I'm very anti-social in person. And some of these just happen over time. You put together the group of people and they hang out online and over times, you have a very famous CEO becoming best friends with somebody in their early 20s who's just getting started just because they're in the same space together.

**中文翻译:**
所以我把他们带进各种在线社区，目前可能已经超过 100 个了。我会说：“好吧，你们信任我，我也信任你们，规矩由我定。”每个人都保持一定程度的私密性，每个人都是同龄人/同级别的人，他们都在各自的领域有所成就，没有人会粗鲁、刻薄或失控。我就像一个派对主人，我会说：“听着，这里没人会乱来。”但我也会进行筛选。我会想：“我需要一个非常有思想的人，我需要一个有点争议的人，我需要一个幽默的人，我需要一个像名人一样的人……”我试图在数字空间里策划出正确的氛围，虽然我在现实生活中其实挺社恐的。其中一些关系是随着时间推移自然发生的。你把一群人聚在一起，他们在网上交流，久而久之，你会看到一位非常著名的 CEO 和一个刚起步的 20 出头的年轻人成了好朋友，仅仅是因为他们处于同一个空间。

---

### [00:30:35] Sriram Krishnan

**English:**
So I love creating those online spaces and I think it's something anybody here listening can do. Just take some of your favorite people, stick them in a WhatsApp group or a Telegram group or a Slack channel... which is by the way, Lenny's Slack, highly, highly recommend it. Lenny is great at that. But yours has hundreds of thousands of people and I think sometimes there's an intimacy from having smaller groups, like 5 people, 10 people like a shared space and then kick it off. And you'll be amazed of after a year or two, of how much intimacy and how much connection where sometimes people open up about losing their jobs or having a divorce or something really personal and intense just because of the shared trust. And I think there's something very heartwarming and fulfilling about being able to facilitate some of that.

**中文翻译:**
所以我喜欢创建这些在线空间，我觉得任何听众都可以做到。只需找一些你最喜欢的人，把他们拉进一个 WhatsApp 群、Telegram 群或 Slack 频道……顺便说一下，Lenny 的 Slack 频道，我非常非常推荐，Lenny 很擅长这个。但你的频道有成千上万的人，我觉得有时小群组更有亲密感，比如 5 到 10 个人的共享空间。你会惊讶地发现，一两年后，大家会建立起深厚的亲密感和联系，有时人们会因为这种共同的信任而敞开心扉，聊聊失业、离婚或一些非常私人且沉重的话题。我觉得能够促成这些事情是非常温馨且有成就感的。

---

### [00:31:22] Lenny

**English:**
I want to dig into that a little bit more. You've built these incredible communities and you talked about a couple, and Aarthi, I know you also built Facebook's early community products and Clubhouse. Obviously if you had to pick one or two things you got to get right with a new community that you're just forming, what do you think those two things are or one or two things?

**中文翻译:**
我想再深入探讨一下。你们建立了这些不可思议的社区，刚才也提到了几个。Aarthi，我知道你也参与过 Facebook 早期社区产品的开发，还有 Clubhouse。显然，如果你必须选出一两件在组建新社区时必须做对的事情，你认为那一两件事是什么？

---

### [00:31:38] Aarthi Ramamurthy

**English:**
Find the niche, start really small and find the niche. I think oftentimes I've seen other startup founders and I invest and advise in a lot of early stage companies. I went through Y Combinator, so I go back to YC as much as I can and go help out folks. But oftentimes I'll see people starting companies or founders coming in and being like, "I'm going to build this product that is going to cater to this community. I'm going to build this world's largest community off this kind of thing," and it almost starts at this super scaled version and then they set themselves up for failure.

**中文翻译:**
寻找利基（niche），从小处着手并找到那个利基。我经常看到其他初创公司创始人——我也投资和指导很多早期公司。我参加过 Y Combinator，所以我经常回 YC 帮大家。但我经常看到人们在创业时说：“我要做一个面向这个社区的产品。我要建立全球最大的关于某某东西的社区。”他们几乎是从一个超级规模化的愿景开始的，这往往注定了失败。

---

### [00:32:14] Aarthi Ramamurthy

**English:**
You're almost better off doing these small, niche, non-scalable things to go find these oddball set of people who are doing this, who are really interested in this one thing and kind of scale from there and grow from there. And I think that's one big thing that when you're starting to build a community, don't start to build this super scaled community. Start with few people who are passionate about a particular problem and want to get together kind of thing. Start there. Two, I think people, and this might be a controversial thing, but I often think people don't think through monetization. If you're a community builder early on, start thinking about, if you're truly focused on this as a business, how would you actually make money off of it?

**中文翻译:**
你最好去做那些小的、利基的、不可规模化的事情，去寻找那些对某件事非常感兴趣的“怪咖”，然后从那里开始扩展和增长。我觉得这是很重要的一点：当你开始建立社区时，不要试图建立一个超级规模的社区。从几个对特定问题充满热情并想聚在一起的人开始。这是第一点。第二点，这可能有点争议，但我认为人们往往没有想清楚变现（monetization）的问题。如果你在早期建立社区，并且真的想把它当成一门生意，那就开始思考：你到底打算怎么从中赚钱？

---

### [00:32:55] Aarthi Ramamurthy

**English:**
Oftentimes they hit some sort of scale and be like, "Crap, now what do I do? And then they're try all these options, they will have some churn and then they're like, "Oh no, but I thought this was a very sticky community." I'm like, "Yes, but it's not as sticky as this particular price tag." And so you have to start thinking through, if we hit a particular velocity, what is that going to look like? What are the things that I'm going to unlock. And think through monetization a little bit ahead of time before it comes in and becomes a crutch rather than a weapon that you can go leverage.

**中文翻译:**
通常他们达到一定规模后会说：“糟糕，现在我该怎么办？”然后他们尝试各种方案，结果出现用户流失，他们会说：“噢不，我以为这是一个粘性很强的社区。”我会说：“是的，但它的粘性还没强到能抵消这个价格标签。”所以你必须开始思考：如果我们达到一定的增长速度，情况会是怎样的？我会解锁哪些功能？在变现变成一种负担而不是你可以利用的武器之前，提前考虑一下它。

---

### [00:33:24] Sriram Krishnan

**English:**
But I want to say, Aarthi is kind of the creator of Facebook Stars and of so much of the thinking there and I can see her go super deep on this. Of course on everything she said, I have a slightly different framework. First of all, I really don't like the word community because the word community, the word networking, the word platform is a little abstract and it can mean a lot of things. And I like to think of things like a dinner party or church or things that seem more tangible and people know, "Okay, I know exactly what that is." So when I think of a community or starting one, I think first of all, it's a party. And you're first starting off, you're like, "All right, what is a vibe?"

**中文翻译:**
我想说，Aarthi 是 Facebook Stars 的创造者，也是那里很多想法的源头，我能看出她在这一领域钻研得很深。当然，对于她说的每一句话，我有一个略微不同的框架。首先，我真的很不喜欢“社区”这个词，因为“社区”、“社交”、“平台”这些词太抽象了，可以指代很多东西。我喜欢把它想象成晚宴派对、教堂或一些更具体的东西，人们一听就知道：“好的，我明白那是什么。”所以当我想到一个社区或开始建立一个社区时，我首先想到的是：这是一个派对。当你刚开始时，你会想：“好吧，氛围是什么样的？”

---

### [00:33:57] Sriram Krishnan

**English:**
For example and this is also true for every social media platform where if you can be a crazy, people are dancing on bars, having a great time, getting really drunk party or you can have a really formal dinner where everyone is seated, there is plates with name tags and there's a clinking of glasses and you have to dress up. And they're both fine, they're both fun in their own way, but you need to tell people, as the host, which one it is. And by the way, I think one of the things that Twitter didn't get right in the original days which some of the other apps did, it never told people what kind of party it was. It like, "Are we going to Michelin star restaurant where sit down or it's a sports bar after the Super Bowl and you can go crazy?" And if you don't do that, people make up their own rules. That's number one.

**中文翻译:**
例如，这对每个社交媒体平台也适用：你可以是一个疯狂的派对，人们在吧台上跳舞、尽情狂欢、喝得烂醉；或者你也可以是一个非常正式的晚宴，每个人都坐好，盘子上有名字卡片，杯子叮当响，你必须盛装出席。这两种形式都很好，都有各自的乐趣，但作为主人，你需要告诉大家这是哪一种。顺便说一下，我觉得 Twitter 早期没做对的一件事（而其他一些 App 做到了），就是它从未告诉人们这到底是什么样的派对。是“我们要去一家米其林餐厅坐下来吃”，还是“这是超级碗之后的运动酒吧，你可以尽情撒野”？如果你不明确这一点，人们就会自定规则。这是第一点。

---

### [00:34:37] Sriram Krishnan

**English:**
The second part is as the host, you have to curate the original set of people and you need a mix, this is super important. I think sometimes people do this thing where they either optimize for "interesting famous people" or they get the most talkative lot of people. And I actually read a bunch of books on hosting great dinner parties, I actually have some interesting suggestions there and it'll say like, "Well, you need a mix." For example, in any organization, let's say you're the VP that everyone knows about, but that VP doesn't have the time to maybe participate on a WhatsApp channel or a Slack channel and chit-chat all the time or show up for everything. And then maybe you need the really boisterous young BD exec who's out and about and meeting everybody. You need that person, you need somebody who's quiet and thoughtful. You need to merge different kinds of energy and that's almost an alchemy and that's more art than science. You have to start there.

**中文翻译:**
第二部分是作为主人，你必须筛选最初的一批人，而且你需要一种混合，这非常重要。我觉得有时人们要么只追求“有趣的名人”，要么只找那些最爱说话的人。我读过很多关于如何举办完美晚宴派对的书，我有一些有趣的建议，书里会说：“你需要一种混合。”例如，在任何组织中，假设你是大家都知道的副总裁（VP），但那个 VP 可能没时间在 WhatsApp 或 Slack 频道里一直闲聊，或者参加每一场活动。那么你可能需要一个非常活跃的年轻业务发展（BD）主管，他到处跑，认识所有人。你需要那样的人，也需要安静、有思想的人。你需要融合不同类型的能量，这几乎是一种炼金术，更多是艺术而非科学。你必须从那里开始。

---

### [00:35:27] Sriram Krishnan

**English:**
Third I think is as the host, you have to have a sixth sense of how is a community feeling at any given point in time? Are two people dominating the conversation? That person hasn't said anything in a while. One of the things I like to when somebody joins a group or one of these places, I try and get them into a question which they will feel happy about because you know what happens the very first time you walk into a party? You look around, you're like, "I don't know anybody here. Oh gosh, okay. I know this one person and I'm going to go talk to them," and you just feel nervous. I'm trying to break that. For example, if you walk in a place and you didn't know anybody, Lenny is actually very good at being social, but I'd be like, "Hey. Lenny has one of the most popular things on Substack and he just wrote [inaudible 00:36:04]. I'm just giving you an opening, you to feel comfortable and that's another part.

**中文翻译:**
第三，我认为作为主人，你必须有一种第六感，能感知社区在任何特定时刻的情绪。是不是有两个人主导了对话？那个人是不是很久没说话了？当有人加入群组或这类场所时，我喜欢做的一件事是抛出一个让他们乐于回答的问题。因为你知道第一次走进派对时会发生什么吗？你环顾四周，心想：“这里我一个人都不认识。噢天哪，好吧，我认识那个人，我去找他聊聊。”你会感到紧张。我试图打破这种局面。例如，如果你走进一个陌生的地方，Lenny 其实很擅长社交，但我会说：“嘿，Lenny 在 Substack 上有最受欢迎的专栏之一，他刚写了……”我只是给你一个开口的机会，让你感到自在，这是另一部分。

---

### [00:36:08] Sriram Krishnan

**English:**
The third part I love is rituals and religions do a great job of this, which is do something every month. There's a little group I hosted some of my friends and during all of COVID, we did a Zoom meeting every Tuesday evening. And that was a ritual, it had nothing, it's just Zoom meeting with a bunch of friends, people can share-

**中文翻译:**
我喜欢的第三部分是仪式感（rituals），宗教在这方面做得很好，那就是每月做点什么。我曾为一些朋友组织过一个小群组，在整个疫情期间，我们每个周二晚上都会开 Zoom 会议。那是一种仪式，没什么特别的，就是一群朋友开 Zoom 会议，大家可以分享——

---

### [00:36:23] Aarthi Ramamurthy

**English:**
And people would just bring their glass of wine or bring their kids in and there's no structured agenda. But people started looking forward to it through the pandemic and stuff and we would be like, "Oh my God, it's Tuesday. You know this evening, we are going to go do this thing." And it was a really great way to go build that community and I totally agree with that.

**中文翻译:**
大家会端着酒杯，或者带着孩子进来，没有固定的议程。但在疫情期间，人们开始期待这件事，我们会说：“天哪，周二到了。你知道今晚我们要去做那件事。”这是建立社区的一种非常棒的方式，我完全同意。

---

### [00:36:43] Sriram Krishnan

**English:**
Yeah, well Lenny has done an amazing job on it on his Slack, I see it.

**中文翻译:**
是的，Lenny 在他的 Slack 上做得非常出色，我看到了。

---

### [00:36:46] Lenny

**English:**
You're so sweet.

**中文翻译:**
你太客气了。

---

### [00:36:47] Sriram Krishnan

**English:**
The other interesting tension and challenge is how to grow it because I think there are... Interesting point, a four person dinner, very different from an eight person dinner, very different from a 20 person thing where people hang out, very different from, once you start getting hundreds of thousands, the things you're willing to share, worrying about being judged. So I'm always trying to create more intimate different spaces and that's a whole other topic. So I think if you're trying to start a community though, I would say picking the right people, setting the tone, being really part of it yourself, that's most of it.

**中文翻译:**
另一个有趣的张力和挑战是如何扩大规模。因为我觉得……有趣的一点是，四个人的晚餐和八个人的晚餐非常不同，和 20 个人的聚会也非常不同。一旦规模达到成千上万，你愿意分享的东西、对被评判的担忧都会改变。所以我总是试图创造更多亲密的不同空间，那是另一个话题了。所以我觉得如果你想开始建立一个社区，我会说：选对人、定好基调、自己真正参与其中，这就是大部分秘诀了。

---

### [00:37:21] Lenny

**English:**
Amazing. There's so many little nuggets of advice there. I feel like we could do a whole other episode on just community building strategy.

**中文翻译:**
太棒了。这里面有很多真知灼见。我觉得我们可以专门做一集关于社区建设策略的节目。

---

### [00:37:30] Lenny (Sponsor: LMNT)

**English:**
Today's episode is brought to you by LMNT. I just recently discovered the stuff, actually from another podcast and it is such sweet, salty goodness. LMNT is a tasty electrolyte drink mix with a science-backed electrolyte ratio. And unlike most electrolyte drinks, there's no sugar, coloring, artificial ingredients, gluten or any other BS. Getting enough electrolytes helps prevent and eliminate headaches, muscle cramps, fatigue, sleeplessness and other common symptoms of electrolyte deficiency.

**中文翻译:**
今天的节目由 LMNT 赞助播出。我最近刚发现这个东西，其实是从另一个播客听到的，它真是又甜又咸的美味。LMNT 是一种美味的电解质饮料冲剂，具有科学支持的电解质比例。与大多数电解质饮料不同，它不含糖、色素、人工成分、麸质或其他任何乱七八糟的东西。摄入足够的电解质有助于预防和消除头痛、肌肉抽搐、疲劳、失眠以及其他常见的电解质缺乏症状。

---

### [00:38:00] Lenny (Sponsor: LMNT)

**English:**
LMNT is the exclusive hydration partner to Team USA Weightlifting and many other Olympic athletes, also dozens of NBA and NFL teams and players rely on LMNT to stay hydrated, along with Navy SEAL teams, FBI sniper teams and the Marines. You can try LMNT totally risk-free. If you don't like it, you can share it with a salty friend and they'll give you your money back, no questions asked. To give it a shot, go to drinklmnt.com/lenny and you'll get a free sample pack with any purchase, which includes one packet of every flavor. My favorite is Watermelon Salt. You won't find this offer publicly available, so you have to head to drinklmnt.com/lenny to take advantage of this offer, stay salty.

**中文翻译:**
LMNT 是美国国家举重队和许多其他奥运选手的独家补水合作伙伴，数十支 NBA 和 NFL 球队及球员也依靠 LMNT 保持水分，此外还有海豹突击队、FBI 狙击小组和海军陆战队。您可以完全无风险地尝试 LMNT。如果您不喜欢，可以分享给朋友，他们会全额退款，不问任何问题。想要尝试的话，请访问 drinklmnt.com/lenny，任何购买都将获赠免费样品包，包含每种口味的一小包。我最喜欢的是西瓜盐味。您在公开渠道找不到这个优惠，所以必须前往 drinklmnt.com/lenny 才能享受此优惠。保持活力（Stay salty）。

---

### [00:38:36] Lenny

**English:**
I want to go back to a topic we touched on that I think is really interesting which is building a brand and putting content out and that kind of thing. I think a lot of times people hear that, like a first-year PM and they're like, "Yes, I'm going to start tweeting." And then it's such cringey useless stuff and nobody needs to hear from them because they haven't done anything. And I guess I'd be curious for your take on, at what point should people start to put things out? How do you know if this is cringey and nobody wants to hear this stuff like, "Great PM-ship," these very cliche things come out. There's like hundreds of Twitter accounts, people are just tweeting these things like, "All right." How do you think about that?

**中文翻译:**
我想回到我们刚才提到的一个非常有趣的话题，那就是建立品牌和发布内容之类的事情。我觉得很多时候人们听到这个，比如一个入职第一年的产品经理（PM），他们会想：“太好了，我要开始发推特了。”然后发出来的都是些让人尴尬（cringey）且无用的东西，没人想听他们说话，因为他们还没做出过任何成绩。我很想听听你们的看法：人们应该在什么时候开始发布内容？你怎么知道自己发的东西是不是很尴尬，或者没人想听那些比如“优秀 PM 的自我修养”之类的陈词滥调？现在有成百上千个推特账号都在发这些东西。你们怎么看？

---

### [00:39:14] Sriram Krishnan

**English:**
I actually disagree with you and I actually think everyone should... well disclaimer, I work for firm which has invested in Twitter, but I swear that's not why I'm saying this, people have heard me say this for years-

**中文翻译:**
实际上我不同意你的看法，我认为每个人都应该……好吧，免责声明：我工作的公司投资了 Twitter，但我发誓我这么说不是因为这个，人们听我这么说已经很多年了——

---

### [00:39:24] Sriram Krishnan

**English:**
And Substack. Everyone should tweet or everyone should post on YouTube or post Instagram and it doesn't matter how young you are. Because I actually disagree with the few things, which actually is a great point which I think a lot of people feel this, one is that you need to have hit a certain bar of accomplishment or interestingness to say something, strongly disagree with that. Second, that things are cringey. I don't think anything is cringey, I strongly disagree with that too. And I think these are both interesting-

**中文翻译:**
还有 Substack。每个人都应该发推特，或者在 YouTube、Instagram 上发布内容，无论你多年轻。因为我不同意你提到的几点，虽然那是很多人都有的感觉：第一，你必须达到一定的成就或趣味性门槛才能发言，我强烈反对这一点。第二，内容很尴尬。我不认为有什么东西是尴尬的，我也强烈反对这一点。我觉得这两点都很有趣——

---

### [00:39:51] Lenny

**English:**
Aarthi's face is great.

**中文翻译:**
Aarthi 的表情太精彩了。

---

### [00:39:53] Aarthi Ramamurthy

**English:**
Wait, I feel like Sriram's bar is so low for-

**中文翻译:**
等等，我觉得 Sriram 的门槛定得太低了——

---

### [00:39:55] Sriram Krishnan

**English:**
Dude, no, this is really important because I think what stops a lot of people is, I've had probably 100 plus conversations where somebody who's incredibly accomplished will come to me and they'll be like, "Hey, I want to get on Twitter, I want write content or I want to Substack or I want to do a podcast." I'm like, "Great." They're like, "But I don't know what to say, I look dumb, I don't want to get judged." But I'm like, "No, you're so accomplished," and it is the fear of being judged that so often stops people. So whenever I hear that word cringe, I'm like, "No, no, no, that's actually fine, you're fine. You'll figure it out," and here's why I say that.

**中文翻译:**
伙计，不，这真的很重要。因为我觉得阻碍很多人的原因是——我大概进行过 100 多次这样的对话，一些非常有成就的人来找我说：“嘿，我想上 Twitter，我想写内容，或者做 Substack，或者做播客。”我说：“太棒了。”他们说：“但我不知道该说什么，我看起来很蠢，我不想被评判。”但我会说：“不，你已经很有成就了。”正是这种对被评判的恐惧阻碍了人们。所以每当我听到“尴尬”这个词，我都会说：“不不不，那其实没关系，你没问题的。你会搞清楚的。”这就是我这么说的原因。

---

### [00:40:30] Sriram Krishnan

**English:**
Number one is what the most important thing and even, listen, if you just remember one thing from this whole thing is just get started and do something every single day. And this sounds so basic, like Aarthi and I have is a running joke where it's like it's diet and exercise is what we say. It's like we are talking to people about how do you get healthy and you have the 100 different things you can do or podcasts you can listen to, but most of it's like, "Well, diet and exercise." And with creating content, diet and exercise, you just write a piece of content every single day because what's going to happen is it builds muscle, it gets you familiar with the medium and you start understanding what works in that medium and what doesn't and you start building reps.

**中文翻译:**
第一，最重要的事情是——听着，如果你从这整件事中只记住一件事，那就是：开始做，并且每天都做。这听起来非常基础，就像 Aarthi 和我常开的一个玩笑，我们管这叫“饮食和运动”。就像我们在和人们讨论如何变得健康，你可以做 100 种不同的事情，或者听各种播客，但核心其实就是“饮食和运动”。对于创作内容来说，“饮食和运动”就是每天写一点东西。因为这样做会锻炼你的“肌肉”，让你熟悉媒介，让你开始理解在这个媒介中什么有效、什么无效，你开始积累练习次数。

---

### [00:41:08] Sriram Krishnan

**English:**
You know who never works out in my opinion? Is somebody who'll think for weeks, build up an amazing tweetstorm, blog post, newsletter, whatever it may be and then stops because the effort is so high. So I'm like, "One, do something every single day." The second part of it is, I actually think you don't have to talk about what you accomplish, you only have to talk about you. And by the way, this is going to sound very froufrou, but you are the best you out there. So for example-

**中文翻译:**
在我看来，谁永远练不出效果？是那些思考好几周，憋出一个惊人的推特长文、博客文章或时事通讯，然后就停下来的人，因为付出的精力太大了。所以我的建议是：第一，每天做点什么。第二部分是，我其实认为你不需要谈论你的成就，你只需要谈论你自己。顺便说一下，这听起来可能很虚，但你就是世界上最好的“你”。所以，例如——

---

### [00:41:33] Aarthi Ramamurthy

**English:**
Wow, okay.

**中文翻译:**
哇，好吧。

---

### [00:41:36] Sriram Krishnan

**English:**
... let's say you are a 21-year-old PM, fresh out of school, first year... by the way, we were all that. I was a 21-year-old PM at one time, Lenny would've been too, lots of others. First you'll see a lot of people who have been through journey and there are others like you. Second is you just talk about your journey, talk about what you're doing, talk about what you're learning. Because what often you're trying to do when you're creating content is to build a relationship with people. So when Charli D'Amelio dances on TikTok, she's not saying she's a professional dancer, she's saying, "I'm relatable, I'm just like somebody you would be friends with next door, I'm just like you." And so then people start connecting with you on that front, if you're authentic and you're doing a good job, and so everybody listening to this should be able to create content.

**中文翻译:**
……假设你是一个 21 岁的产品经理，刚毕业，第一年工作——顺便说一下，我们都经历过那个阶段。我也曾是一个 21 岁的 PM，Lenny 也是，还有很多人。首先，你会看到很多经历过这段旅程的人，也会看到和你一样的人。其次，你只需要谈论你的旅程，谈论你在做什么，谈论你在学什么。因为当你创作内容时，你通常是在试图与人建立关系。当 Charli D'Amelio 在 TikTok 上跳舞时，她并不是在说她是专业舞者，她是在说：“我很亲切，我就像你隔壁的朋友，我和你一样。”所以人们开始在那方面与你建立联系。如果你很真实并且做得不错，那么每个听众都应该能够创作内容。

---

### [00:42:17] Aarthi Ramamurthy

**English:**
Okay, so the only place where I disagree, I think this is all right, but this is a bit like, we are Asian, we have this very Asian parent thinking, there are no participation trophies, so if it is cringey, you should at least acknowledge that it is cringey. I think at the end of the day, you have to persevere, I think I give a lot more words to people who are just persevering and showing up every day, but I do think there should be a level of self-awareness for people where it's like, "Man, this is not great. I'm not getting any traction. I need to improve on things and keep building on it," as opposed to being like, "I am the best me ever," and just keep putting out garbage, don't do that. Improve on stuff because there is such a thing as bad content-

**中文翻译:**
好吧，我唯一不同意的地方是——我觉得这都没错，但这有点像……我们是亚洲人，我们有那种非常典型的亚洲父母思维：没有“参与奖”。所以如果内容很尴尬，你至少应该承认它很尴尬。我认为归根结底你必须坚持，我非常敬佩那些坚持不懈、每天都出现的人，但我确实认为人们应该有一定的自我意识，意识到：“天哪，这写得不好。我没有获得任何关注。我需要改进并继续努力。”而不是在那儿自我感觉良好地说“我是最好的自己”，然后一直产出垃圾。别那样。要改进，因为确实存在“烂内容”这回事。

---

### [00:43:03] Sriram Krishnan

**English:**
I agree with you, but I think when people mean cringey... okay, I'll see this. What people think they say cringey, it's like our peer group thinks that this content is too basic-

**中文翻译:**
我同意你的看法，但我认为当人们说“尴尬”时……好吧，我是这么看的。人们所谓的“尴尬”，通常是指我们的同行圈子觉得这些内容太基础了——

---

### [00:43:11] Aarthi Ramamurthy

**English:**
But everybody has that, whether you say it out loud or not.

**中文翻译:**
但每个人都有那种感觉，无论你是否说出来。

---

### [00:43:15] Sriram Krishnan

**English:**
Well, I'll give you a story. So I spent years, I'd be like, "I'm a PM leader, I run organization, I should write smart PM things. I should write the kinds of things that Lenny writes." For example, I'll say that, "Lenny's Post the other week from Duolingo is... I was so jealous. I was like, "Man, this is the kind of content... I would be like, "It's amazing, banger post." But the problem was when you start doing that, you start censoring yourself. And I'll say, I've written a lot of posts over the years and I'll try and sound smart, I have a great intellectual framework in some of this work, but you know what my most popular post and tweetstorm of all time is? It is how to write a cold email.

**中文翻译:**
好吧，我给你讲个故事。我花了很多年想：“我是一个 PM 领导者，我管理组织，我应该写一些高深的产品经理内容。我应该写 Lenny 写的那种东西。”例如，我会说：“Lenny 前几周关于 Duolingo 的那篇文章……我太嫉妒了。我心想：‘天哪，这才是那种内容……’我会觉得‘太棒了，爆款文章’。”但问题是，当你开始那样做时，你就会开始自我审查。我要说的是，这些年来我写了很多文章，试图让自己听起来很聪明，在某些工作中运用了很棒的知识框架，但你知道我史上最受欢迎的文章和推特长文是什么吗？是《如何写一封冷邮件》。

---

### [00:43:48] Sriram Krishnan

**English:**
And when I wrote that tweetstorm, I was like, "Man, I'm going to sound so dumb," because Lenny doesn't need to know how to write a cold email and neither does the VCs I work with, everyone knows that. But the thing is, what is obvious to you and may seem cringey to your peers is definitely not obvious to a lot of people and they will connect to you, they will relate to you. When somebody says like, "Well, is it too basic? How do I get started with my job?" I'm like, "No, there's a lot of people who this is not obvious to," and I'll just put myself out there and what's the worst thing? Somebody thinks you're moron? That's fine. You put some new piece of content out there the next day and they'll fix it or you can just ignore that.

**中文翻译:**
当我写那篇推特长文时，我想：“天哪，我听起来会很蠢。”因为 Lenny 不需要知道怎么写冷邮件，和我共事的风投们也不需要，大家都知道。但问题在于，对你来说显而易见、对你的同行来说可能显得“尴尬”的东西，对很多人来说绝对不是显而易见的，他们会因此与你建立联系，产生共鸣。当有人问：“这会不会太基础了？我该如何开始我的工作？”我会说：“不，对很多人来说这并不显而易见。”我只是展示自己，最坏的情况是什么？有人觉得你是白痴？没关系。你第二天再发点新内容，他们就会改观，或者你干脆无视他们。

---

### [00:44:23] Lenny

**English:**
I think there's a lot of really good nuggets here. I think the only area maybe we disagree and we should move on, but this is [inaudible 00:44:29].

**中文翻译:**
我觉得这里有很多非常有价值的观点。我想我们唯一可能存在分歧的地方是——我们应该继续下一个话题了，但这是……

---

### [00:44:30] Sriram Krishnan

**English:**
Listen to me, Lenny, come on. Your podcast is too friendly otherwise, let's listen.

**中文翻译:**
听我说，Lenny，别这样。否则你的播客就显得太客气了，让我们听听看。

---

### [00:44:34] Lenny

**English:**
My feeling is I think for helping you do better work kind of content, like entertainment anyone could do no problem, you could be awesome at it, is I feel like you need to do something in your career first before you can start speaking to, "Here's things I've learned and here's what works and here's what doesn't work." I think I wouldn't spend a lot of time sharing all your wisdom before you've done a thing and been successful in some way.

**中文翻译:**
我的感觉是，对于那种“帮助你更好地工作”的内容——如果是娱乐内容，任何人都可以做，而且可以做得很好——我觉得你需要在职业生涯中先做出点成绩，然后才能开始谈论“这是我学到的东西，这是有效的，这是无效的”。我认为在你真正做成一件事并取得某种成功之前，不应该花太多时间去分享所谓的“智慧”。

---

### [00:44:53] Sriram Krishnan

**English:**
Yeah. I actually think you make a very interesting point, which is I think a lot of people online LARP, live action role-play, as somebody else which is like you trying to project a persona or a career point that you are not at and you know it, we know it, you probably admit you know it-

**中文翻译:**
是的。我觉得你提出了一个非常有趣的观点。我认为网上很多人都在“实况角色扮演”（LARP），扮演成别人，试图塑造一个你尚未达到的职业高度或人设。你自己知道，我们也知道，你可能也承认你知道——

---

### [00:45:14] Aarthi Ramamurthy

**English:**
And also for that kind of content, everyone can tell. I think it just comes off as not authentic. I mean I feel like the universe figures itself out over time, but I do think there is a level of, just because Sriram thinks no content is cringey does not mean people all feel that way. You can't just magically just wipe that out. I feel like everyone just feels that way, whether or not you say it out loud. I do think there is a process of iteration and acknowledging that, "Yeah, okay, this is bad, but I'm going to put this out there anyway and we'll just keep working on this," and coming back to it.

**中文翻译:**
而且对于那种内容，每个人都能看出来。我觉得那显得很不真实。我的意思是，我觉得随着时间的推移，一切都会水落石出。但我确实认为，仅仅因为 Sriram 觉得没有什么内容是尴尬的，并不代表所有人都有同感。你不能就这么神奇地抹杀掉那种感觉。我觉得每个人都会有那种感觉，无论你是否说出来。我确实认为有一个迭代的过程，并承认：“是的，好吧，这写得挺烂，但我还是要发出来，我会继续努力改进。”

---

### [00:45:46] Aarthi Ramamurthy

**English:**
I really appreciate people who would just do that and just keep coming back to it every day and like Rocky style, chip away at things. I really have appreciation for those folks because it's hard. I've realized over time that everyone is deeply feeling as if they're imposters and we talked about this. Imposter syndrome is so real, it is so gut-wrenchingly real that it's not just every one person, it's most people I think. So to be able to overcome that threshold and look at your amazing peers and your seniors and everybody else and then still be able to put yourself out there, I think we have to really appreciate that and help them go iterate and just get better over time.

**中文翻译:**
我非常欣赏那些敢于这样做并每天坚持的人，就像洛奇（Rocky）一样，一点点磨练。我真的很敬佩这些人，因为这很难。随着时间的推移，我意识到每个人内心深处都觉得自己是个“骗子”，我们聊过这个。冒充者综合征（Imposter syndrome）是如此真实，真实得令人心碎，我觉得不只是某个人，而是大多数人都有。所以，能够克服那个门槛，看着你优秀的同行、前辈和所有人，却依然能够展示自己，我认为我们必须由衷地赞赏这一点，并帮助他们不断迭代，随着时间的推移变得更好。

---

### [00:46:27] Sriram Krishnan

**English:**
Yeah, I agree. One tiny story before we wrap on this topic, which is I was talking to somebody who's four or five years into their career as a PM and they'd written this post on LinkedIn which is full of cringey content, by the way. Okay, let me say it, LinkedIn has a lot of cringey PM content-

**中文翻译:**
是的，我同意。在结束这个话题前讲一个小故事：我曾和一个工作了四五年的产品经理聊天，他在 LinkedIn 上发了一篇帖子，顺便说一下，那里面全是让人尴尬的内容。好吧，我直说了，LinkedIn 上有很多让人尴尬的 PM 内容——

---

### [00:46:42] Sriram Krishnan

**English:**
... I'm sorry LinkedIn folks. And it was one of the things about how do you set product strategy as an organization and I was like, I called them, I was like, "Dude, come on. You're four years into your role, nobody believes that you actually are driving this from a place of actually really knowing it. And that is fine if you're learning, but you are trying to project this person you're not." But the thing which I was talking to him, I was like, "I know you've done this amazing deep dive on this other niche topic. You've gone out, you read all the posts, go write about that because you are an expert legitimately in something you think is niche, as opposed to a fake expert on this other thing you want to be."

**中文翻译:**
……对不起，LinkedIn 的朋友们。那篇帖子是关于“如何制定组织级的产品策略”，我打电话给他，我说：“伙计，别这样。你才工作四年，没人相信你真的从实战经验中深刻理解了这些。如果你在学习，那没问题，但你是在试图扮演一个你还不是的人。”我跟他聊的时候说：“我知道你在另一个小众话题上做了非常深入的研究。你查阅了所有资料，读了所有文章，去写那个吧。因为你在那个你认为很小众的领域是真正的专家，而不是在你想要成为的另一个领域当一个伪专家。”

---

### [00:47:17] Sriram Krishnan

**English:**
He went and wrote this follow-up post on something very niche and that went really popular because the truth is, there's not a lot of great content out there, especially great content from people who actually done the thing. You'd be surprised how niche you can be, but if you actually done the work, talk to a people, aggregated some posts, people come seek you out and you don't have to do it. So anyway, so lots of LARPing, lots of cringey LinkedIn content for sure.

**中文翻译:**
他后来写了一篇关于那个非常小众话题的后续帖子，结果大受欢迎。因为事实是，市面上并没有太多优质内容，尤其是那些真正做过实事的人写出的优质内容。你会惊讶地发现，无论你多么小众，只要你真正做过工作、和人聊过、整合过信息，人们就会主动找上门来。所以，确实有很多在“演戏”的人，LinkedIn 上也确实有很多让人尴尬的内容。

---

### [00:47:43] Lenny

**English:**
Just to close this out, I 100% agree with the idea that people should be just trying stuff, writing, sharing stuff on Twitter, LinkedIn, just get it out of there, don't be afraid because that's how you start down this road. I was going to go in a different direction, but you mentioned imposter syndrome and I'm curious, have you two dealt with imposter syndrome and-

**中文翻译:**
最后总结一下，我 100% 同意人们应该去尝试、去写作、在 Twitter 和 LinkedIn 上分享，尽管发出来，不要害怕，因为那是开启这段旅程的方式。我本想聊聊别的，但你提到了冒充者综合征，我很想知道，你们两位是否经历过冒充者综合征？

---

### [00:48:01] Aarthi Ramamurthy

**English:**
Oh, yeah. We have and I still, I don't know about Sriram. Sriram comes off as so much more confident and has so much gravitas that nobody ever thinks of it, but we both do, we both deeply have imposter syndrome. Every single day, anything we do, we look at ourselves, we are creators, we have this show on YouTube and then we look around at everybody else who have millions of subscribers and followers and everything and we are like, "Why are we creators? This is not a thing. We should not be doing this stuff. I just think people haven't been honest with us on how much we suck."

**中文翻译:**
噢，是的。我们经历过，而且我现在依然有，我不知道 Sriram 怎么样。Sriram 看起来非常自信，很有威严，没人会想到他也有，但我们两个都有，而且是非常严重的冒充者综合征。每一天，无论我们做什么，我们看着自己——我们是创作者，我们在 YouTube 上有节目——然后我们看看周围那些拥有数百万订阅者和粉丝的人，我们会想：“为什么我们是创作者？这不对劲。我们不该做这些。我觉得大家只是没对我们说实话，没告诉我们我们有多烂。”

---

### [00:48:48] Aarthi Ramamurthy

**English:**
It's like you have these loops in your head and then every once in a while, you'll see a comment being like, "This was amazing. I just had to stop doing what I was doing to listen to this whole thing. It was so valuable for me." And you're like, "Oh, okay. We are not all the bad. That's, I think, okay." So we go through this a lot. For the longest time, I had really severe imposter syndrome through school, college, getting into Microsoft. Even after I got through the Microsoft, which we were one of the youngest product managers there, I still was like, "Oh, someday they're going to figure out that this was all... they'll know the real me and they'll be like, 'Oh man, we made this mistake with her.'" And it was just such a real crippling thing for me. Even now I feel like maybe it's not 100% true, but I can kind of see the gradients there, so very real thing.

**中文翻译:**
就像你脑子里一直在循环这些念头，然后偶尔你会看到一条评论说：“这太棒了。我不得不放下手头的事来听完整个节目，对我来说太有价值了。”然后你会想：“噢，好吧。我们也没那么差。我觉得还行。”所以我们经常经历这些。在很长一段时间里，从上学、大学到进入微软，我都有非常严重的冒充者综合征。甚至在我进入微软（我们当时是那里最年轻的产品经理之一）之后，我依然觉得：“噢，总有一天他们会发现这一切都是……他们会看到真实的我，然后会说：‘天哪，我们招她真是个错误。’”这对我来说真的是一种令人瘫痪的感觉。即使是现在，我觉得虽然不完全是那样，但我能感觉到那种心态的起伏，所以这是非常真实的事情。

---

### [00:49:27] Sriram Krishnan

**English:**
Yeah, it's so true. I have a hack or a technique of how to get over imposter syndrome. But I'll just say, and this is just if folks here feel it, every new job I've been in, I have always felt that I didn't deserve to be there and I mean I genuinely. When I joined Microsoft, I was a young student, I was like, "I don't know anything. These folks are professional, they've been doing this job for years." When I moved to the US I said, "Look, my accent is super intense, I'm Indian, these folks have been doing this for many years, they have very different lifestyles, I don't know what I'm doing here."

**中文翻译:**
是的，太真实了。我有一个克服冒充者综合征的小技巧。但我先说一下，如果这里的听众也有这种感觉：我每换一份新工作，都觉得自己不配待在那里，我是认真的。当我加入微软时，我还是个年轻的学生，我想：“我什么都不懂。这些人都是专业人士，他们做这份工作已经很多年了。”当我搬到美国时，我说：“看，我的口音非常重，我是印度人，这些人在这里生活了很多年，他们的生活方式完全不同，我不知道我在这里干什么。”

---

### [00:50:07] Sriram Krishnan

**English:**
When I move to Silicon Valley, I got no hired by probably four or five different companies and one of them told me, "You work for Microsoft so you can't really cut it in Silicon Valley because you're from Seattle," which I'll never forget. And I look at the person from LinkedIn from time to time, I'm very typically like, "Well, I've cut it now," and I'm very petty that way. And then of course and then when I start running large organizations, several hundred people or more, I was like, "I've never done this before." I'm in a meeting, everyone is looking to me, "Do they know that I've not done this before? Because I haven't done this before and can they tell?" And it's every step of the way.

**中文翻译:**
当我搬到硅谷时，大概有四五家公司拒绝了我，其中一家告诉我：“你在微软工作，所以你无法在硅谷立足，因为你来自西雅图。”我永远不会忘记这句话。我偶尔会在 LinkedIn 上看看那个人，我会想：“好吧，我现在立足了。”在这方面我挺记仇的。当然，后来当我开始管理几百人甚至更多的大型组织时，我会想：“我以前从未做过这个。”我在开会，每个人都看着我，我想：“他们知道我以前没做过吗？因为我确实没做过，他们能看出来吗？”每一步都是如此。

---

### [00:50:45] Sriram Krishnan

**English:**
So it just pushes every step of the way and in the beginning, it was quite crippling, but over time, you build things to help you. And I think for those listening, if you feel this way, the thing I've learned to do is you have to retreat to a place where you feel real mastery of. So for example, when I was at Microsoft, I was like, "Well, I don't speak the language very well, English," and I had an accent, et cetera, but I knew that I was the most online developer person out there. I knew every single online community, I was very plugged into open source, so in every meeting when the topic would come to, "Hey, what is happening with Ruby on Rails?" I was like, "I know this better than everybody else," and I learned to put together a presentation.

**中文翻译:**
所以这种感觉伴随着每一步，起初它确实让人很痛苦，但随着时间的推移，你会建立一些机制来帮助自己。我想对听众说，如果你也有这种感觉，我学到的一点是：你必须退回到一个你感到真正精通（mastery）的领域。例如，当我在微软时，我想：“好吧，我的英语说得不太好，”而且我有口音等等，但我知道我是最活跃的在线开发者。我了解每一个在线社区，我深入参与开源项目。所以每次开会提到“嘿，Ruby on Rails 最近怎么样？”时，我会想：“我比这里任何人都了解这个。”于是我学会了如何做演示。

---

### [00:51:39] Sriram Krishnan

**English:**
Because then you start with the base of something that you feel super comfortable in and you build from that. And what you realize when you build from that is you are like, "Oh, actually you know what? People really respect that and they react to that." And I also learned not to do other things. For example, for them for years where I would listen to people from a certain academic background or I'll be like, "I wish I could do slide decks like they could," or, "I wish I could have these intentional... but I was like, "That doesn't really matter. You just need to come from a place where you are confident you've done the work."

**中文翻译:**
因为当你从一个让你感到超级舒适的基础开始时，你就可以以此为基点进行构建。当你这样做时，你会意识到：“噢，其实你知道吗？人们真的很尊重这一点，并且会有所回应。”我也学会了不去纠结其他事情。例如，多年来我会听那些有特定学术背景的人说话，或者想：“我希望我能像他们那样做幻灯片，”或者“我希望我能有那种刻意的……”但我后来觉得：“那并不重要。你只需要从一个你确信自己已经做过功课的立场出发。”

---

### [00:51:54] Sriram Krishnan

**English:**
So if you folks are listening and you feel imposter syndrome, next time you walk into a meeting, just think about, "Okay, this is a place where I know I spend so many nights and weekends," and it can be super tiny, it can be one little button, one customer, but you've done the work, you've had multiple conversations, it is [inaudible 00:51:54]. And you start from there, you talk about that and you build out from that and you will feel comfortable. So I've done that in pretty much every role now and I still catch myself doing-

**中文翻译:**
所以如果听众们感到冒充者综合征，下次你走进会议室时，就想：“好吧，在这个领域，我知道我花了多少个夜晚和周末去研究。”它可以是非常微小的事情，比如一个按钮、一个客户，但你确实做过功课，你进行过多次对话。你从那里开始，谈论那个话题，并以此为基础展开，你就会感到自在。我现在几乎在每个角色中都这样做，但我仍然会发现自己——

---

### [00:52:03] Aarthi Ramamurthy

**English:**
Yeah, I think for me, when I was a first time founder, I definitely felt that way and there was all this, at that time, which was conventional wisdom. Nobody we knew at that time were founders, it's not our friend circle, they all worked in medium to big companies. My family, nobody has ever been a founder, entrepreneur, it's not a thing. And so when I started this I was like, "Oh my God, I'm making a mistake." But then you read all these people tweeting or writing posts, being like, "If you're a founder you'll be really good at fundraising. Best founders learn how to... I sucked at fundraising. I was so bad at it. It was just like, "Oh, you have to be able to tell your story."

**中文翻译:**
是的，对我来说，当我第一次创业时，我绝对有那种感觉。当时有很多所谓的“常识”。我们当时认识的人里没有一个是创始人，在我们的朋友圈里，大家都在中大型公司工作。我的家人里也从来没有人创过业，那根本不是我们的生活。所以当我开始创业时，我想：“天哪，我犯了个错误。”然后你会读到那些人发的推特或文章，说：“如果你是创始人，你一定会很擅长融资。最好的创始人会学习如何……”但我融资做得烂透了。我非常不擅长，就像是，“噢，你必须能够讲好你的故事。”

---

### [00:52:41] Aarthi Ramamurthy

**English:**
I tried. I email like 250 founders, took 85 meetings and 50 plus second meetings and then got 30 checks. This was my seed round which took eight months to close or something and I was like, "Oh my God, I'm so bad at this. I should just give up right now." And then I started building this startup and I was like, "Actually I'm really, really good at understanding customer acquisition and really trying to find creative ways to cheaply acquire customers." And I kind of started putting together playbooks on it, what I can go do there and I tried this, I tried this, then I started talking to few for our own investors and I'm like, "I don't know if your portfolio companies are finding this useful, but I tried these tactics."

**中文翻译:**
我尝试了。我给大约 250 位创始人发了邮件，参加了 85 场会议和 50 多场复试，最后拿到了 30 张支票。那是我的种子轮，花了八个月才完成，我当时想：“天哪，我太不擅长这个了，我现在就该放弃。”但后来我开始建立这家初创公司，我发现：“其实我非常擅长理解客户获取，并且非常擅长寻找低成本获取客户的创意方法。”我开始为此编写实战手册（playbooks），尝试各种方法。然后我开始和我们的一些投资者聊天，我说：“我不知道你们投资的其他公司是否觉得这有用，但我尝试了这些策略。”

---

### [00:53:28] Aarthi Ramamurthy

**English:**
And they were like, "Oh my God, I'd never heard of that." And so I realized that that's the one place I could be really good at and I can grow my business in a really profitable way very quickly. And then investors started talking to me about other companies and all of that stuff and it became a thing and that helped me get more confidence over time. It was like, who cares if I can't do these other things? I can do these few things and this is really, really important to build a sustainable business and I think I can do that. And that for me kind of helped me get over it. It's not anyone telling me, "Don't worry, you'll be good at it," that never helped, it was just I had to do it myself to figure it out.

**中文翻译:**
他们说：“天哪，我从未听说过那种方法。”于是我意识到，这就是我非常擅长的地方，我可以以一种非常盈利的方式快速增长业务。然后投资者开始找我聊其他公司的事情，这成了一项专长，随着时间的推移，这帮我建立了信心。就像是，谁在乎我不会做其他事？我会做这几件事，而这对于建立一家可持续发展的企业非常重要，我觉得我能做到。这帮我克服了那种心态。不是别人告诉我“别担心，你会做好的”，那从来没用，我必须亲自去做并搞清楚。

---

### [00:54:02] Lenny

**English:**
It's interesting both of your pieces of advice is find the thing you're actually good at and then just lean into that as much as possible. That's something I learned from an executive coach I worked with once that you have strengths, you have weaknesses, you can accomplish almost all the things you want accomplish through the lens of the strengths without using those weaknesses as much and that really was pretty transformative.

**中文翻译:**
很有趣，你们两位的建议都是：找到你真正擅长的事，然后尽可能地发挥它。这是我从一位合作过的高管教练那里学到的：你有长处，也有短处，你几乎可以完全通过长处的视角来实现你想达到的所有目标，而不需要过多地使用那些短处。这对我来说真的是一种蜕变。

---

### [00:54:21] Sriram Krishnan

**English:**
That's actually such a profound point and I wish somebody had told me that earlier in my career because early in my career, I would get all this advice like, "Oh, Sriram is too loud and too boisterous." And the thing is, nobody I know has ever become successful by trying to fix their weaknesses, it's just impossible. The only way you succeed is one, you might need to mitigate some of them, especially if they're really, really holding you back. But you have to lean into your strengths, which is a weird thing because I think when we do performance feedback, it's feedback and so much time we are like, "Well, these are all the good things and then let's talk about the ways you know can improve."

**中文翻译:**
这确实是一个非常深刻的观点，我真希望在我职业生涯早期有人告诉我。因为早期我收到的建议全是：“噢，Sriram 太吵了，太活跃了。”事实是，我认识的人里没有一个是靠修复弱点成功的，那是不可能的。成功的唯一途径是：第一，你可能需要减轻一些弱点的影响，特别是如果它们真的阻碍了你；但你必须发挥你的长处。这很奇怪，因为当我们做绩效反馈时，大部分时间都在说：“好吧，这些是做得好的地方，然后让我们谈谈你可以改进的地方。”

---

### [00:54:53] Sriram Krishnan

**English:**
It's almost the flip time and I think if you're doing performance feedback, you'll be like, "Well, these are things you're really good at, let's make you even much better at that. Let's make you fly faster, run harder, close the deal, write better code." Oh yeah, and some people are mad at you for these things. You should watch it and maybe fix some if it's really bad, but that's not what's going to pull you ahead. It's the superpowers that's going to really pull you ahead, so let's focus on that.

**中文翻译:**
这几乎应该是反过来的。我觉得如果你在做绩效反馈，你应该说：“这些是你非常擅长的事，让我们让你在这些方面变得更强。让你飞得更快、跑得更远、谈成更多单子、写出更好的代码。”噢对了，有些人因为这些事对你有意见，你应该注意一下，如果真的很糟糕就改改，但那不是让你领先的原因。真正让你领先的是你的“超能力”，所以让我们专注于此。

---

### [00:55:15] Lenny

**English:**
Yeah. The way I think about that is the weaknesses can't be liabilities, you can't just get on stage and melt and explode, but you don't have to be amazing. As long as you can email really well, write documents really well, communicate in other ways if that's a strength. One last trick while we're on this topic, I was just reading Hunter Walk's blog and he shared a cool trick for imposter syndrome where you just have to ask yourself, "Am I so good at pretending that people don't see what's actually happening? Am I actually that good to being this imposter? Probably not, the people can tell," and it's really unlikely you're actually an imposter.

**中文翻译:**
是的。我的看法是，弱点不能成为致命伤（liabilities），你不能一上台就崩溃，但你不需要在每方面都很出色。只要你能写好邮件、写好文档，或者以其他方式沟通（如果那是你的长处）。关于这个话题最后一个技巧：我刚读了 Hunter Walk 的博客，他分享了一个应对冒充者综合征的酷技巧，你只需要问自己：“我真的那么擅长伪装，以至于大家都没发现真相吗？我当‘骗子’真的有那么厉害吗？”大概率不是，大家能看出来。所以你其实不太可能真的是个骗子。

---

### [00:55:46] Sriram Krishnan

**English:**
Also, by the way, the reality is and this a cliche is people are just not thinking about you.

**中文翻译:**
顺便说一下，现实情况是——虽然这是陈词滥调——人们根本没在想你。

---

### [00:55:51] Lenny

**English:**
Right.

**中文翻译:**
没错。

---

### [00:55:52] Aarthi Ramamurthy

**English:**
That's true. Yeah, you're giving other people too much credit that they're focused on somebody else. Everyone is so busy focusing on themselves and their own insecurities and fear and just living life. And think about ourselves, when was the last time we thought about somebody else and were like, "That person, probably an imposter"? We just don't have the time for it.

**中文翻译:**
确实如此。你太看得起别人了，以为他们都在关注别人。每个人都忙着关注自己、自己的不安全感、恐惧和生活。想想我们自己，上一次我们想到别人并觉得“那个人大概是个骗子”是什么时候？我们根本没那个闲工夫。

---

### [00:56:15] Sriram Krishnan

**English:**
Yeah, I've been thinking about me this whole time.

**中文翻译:**
没错，我这一整天都在想我自己的事。

---

### [00:56:18] Aarthi Ramamurthy

**English:**
I am not surprised.

**中文翻译:**
我一点都不意外。

---

### [00:56:20] Lenny

**English:**
You guys are hilarious. There's something I actually along these lines I was going to ask about. I remember, Sriram, when you were just getting out of the companies you worked at, you made this point that you were an IC and you were in these meetings where people are reviewing your work and they're making decisions and you're the person presenting. And then all of a sudden, you're the person reviewing all their work and making the decisions and no one trained you to be that person where you're like, "Oh my God, I'm that person they're all looking for for all these answers?" And I'm curious just how you worked through that and what advice you'd have for people that are maybe going through that transition?

**中文翻译:**
你们太逗了。顺着这个思路，我其实想问一件事。我记得 Sriram，当你刚离开之前工作的公司时，你提到过：你曾是一名一线员工（IC），参加会议时别人评审你的工作、做决定，而你是演示的人。然后突然之间，你变成了那个评审所有人工作并做决定的人，没人训练过你如何成为那个“天哪，我就是大家都在寻找答案的那个人”。我很想知道你是如何度过那个阶段的，对于正在经历这种转变的人，你有什么建议？

---

### [00:56:49] Sriram Krishnan

**English:**
Yeah, it's a good question. First of all, it's kind of a jarring change because you realize, "Well, I have power, but I'm also called upon to do a bunch of things," because no meeting, let's call it an exec review, let's say and you're the exec they're presenting too. It doesn't really matter what your title is. All of a sudden, you're having to do a bunch of things. You're making decisions, but you're also providing feedback, sometimes explicitly, sometimes implicitly.

**中文翻译:**
是的，这是个好问题。首先，这是一种很剧烈的变化，因为你意识到：“好吧，我有权力了，但我也被要求去做一堆事。”因为在任何会议中——假设是一个高管评审会（exec review），而你就是那个被演示的高管。不管你的头衔是什么，突然之间，你得做很多事。你在做决定，但你也在提供反馈，有时是显性的，有时是隐性的。

---

### [00:57:10] Sriram Krishnan

**English:**
You might piss off somebody by naming somebody and not naming the other person, you might piss off somebody by not inviting them to the meeting. You might have to feel like, "Well, I really want to overrule this person, but if I do, they might get mad at me." And there are so many different things which you have to keep in your head as well as like, "Is this the right path for the team, for the company," or whatever the situation is and it can be really overwhelming. And I learned a lot of how to do great exec reviews from my time at Facebook, from Zuck and from Andrew Bosworth. Andrew Bosworth, Boz, has some great posts on his site, boz.com, about how to do reviews and-

**中文翻译:**
你可能会因为提到了某人而没提到另一人而惹恼某人，也可能因为没邀请某人参加会议而惹恼他。你可能会觉得：“好吧，我真的很想否决这个人的提议，但如果我这么做，他可能会生我的气。”你脑子里得装这么多事，同时还得考虑：“这对团队、对公司来说是正确的道路吗？”无论情况如何，这都可能让人不知所措。我在 Facebook 工作期间，从扎克伯格（Zuck）和 Andrew Bosworth（Boz）那里学到了很多关于如何做高管评审的经验。Boz 在他的网站 boz.com 上写过一些关于如何做评审的精彩文章。

---

### [00:57:40] Lenny

**English:**
I'm trying to get him on this podcast by the way.

**中文翻译:**
顺便说一下，我正试着邀请他上我的播客。

---

### [00:57:42] Aarthi Ramamurthy

**English:**
Oh, that sounds good. He's great.

**中文翻译:**
噢，那太好了。他很棒。

---

### [00:57:43] Sriram Krishnan

**English:**
He's great, he's fantastic. Let me know when you have him, I have some questions I want to get you to ask him. But Boz had a few ways of thinking. First of all, let's start with Zuck. Thing I loved about Zuck's exec reviews was that it was clear when you walked into the room that you are talking to one of the most powerful people on the planet. But what he did which not a lot of other people in this position do, is he would tell you what the rules of engagement were for every meeting or [inaudible 00:58:08]. He'd be like, "Look, I'm going to give you a spectrum of A, how much I care about this topic. Everything from I don't care, I don't know why you're talking to me, do I care kind of care little? I kind of care so I'm happy you're getting this update, do I really want you to do this? But you know what, if you overrule me, that's fine. All the way to I'm the founder, I'm the CEO, just do this." But he will make it clear where he stood on the spectrum.

**中文翻译:**
他非常出色。你请到他时告诉我，我有几个问题想让你帮我问他。Boz 有几种思考方式。首先，从扎克伯格说起。我喜欢扎克伯格高管评审的一点是：当你走进房间时，你很清楚自己是在和地球上最有权势的人之一交谈。但他做了一件很多处于这个位置的人不会做的事：他会告诉你每次会议的“参与规则”（rules of engagement）。他会说：“听着，我会给你一个光谱，关于我对这个话题的关注程度。从‘我不在乎，不知道你为什么要跟我说这个’，到‘我有点在乎，很高兴听到这个进展’，再到‘我真的希望你这么做，但如果你否决我的意见也没关系’，一直到‘我是创始人，我是 CEO，就按我说的做’。”他会明确告诉你他在光谱的哪个位置。

---

### [00:58:27] Sriram Krishnan

**English:**
The second thing he would make clear is why he believed the things he did. For example, the very first time I pitched him on what is the Facebook Audience Network which grew into probably one of the largest ad networks on mobile, he had all these sort of ideas, he was like, "We shouldn't do an ad network because," and he had all these opinions on, "Well, mobile ads all look terrible, they are spammy, X, Y and Z." But he was really good at articulating those to you and also saying, "Well, if you can prove me wrong on these legs of my logic tree, I will let you overrule me, unless I have a strong opinion." So when you walk in a meeting, you're like, "Well, I know the framework, I know what the dance is, do you convince him?" Or maybe there's no shot to convince him and that's fine. He's the CEO and that's fine too.

**中文翻译:**
第二件事是他会明确解释他为什么相信他所相信的事。例如，我第一次向他推销 Facebook Audience Network（后来发展成为移动端最大的广告网络之一）时，他有很多想法，他说：“我们不应该做广告网络，因为……”他有一堆观点，比如“移动广告看起来都很糟糕、很垃圾”等等。但他非常擅长向你阐述这些观点，并说：“如果你能在我的逻辑树中证明我是错的，我会让你否决我的意见，除非我有非常强烈的坚持。”所以当你走进会议室时，你会觉得：“好吧，我知道框架是什么，我知道该怎么‘跳这支舞’，我能说服他吗？”或者也许根本没机会说服他，那也没关系。他是 CEO，这很正常。

---

### [00:59:10] Sriram Krishnan

**English:**
So I really learnt that it's so important to clarify for your team the framework you're operating in with you. And it's also maybe a clarifying function for yourself as so how do you actually feel about this and why do you feel like that? That's number one. The second part of it is inside a meeting, there's a few things I think you need to do which is clarify what kind of meeting is it. Is it just an update? "Great. We're just going to get an update? I'm going to listen to you, I'm going to applaud you for a job well done, I'm going to send you on your way." Or is it a decision in which case, what are the pros, cons, et cetera? There are some real big failure modes where one kind of meeting slides into another kind of meeting where somebody is like, "Why are we doing that? Is that a thing?"

**中文翻译:**
所以我真的学到了，向你的团队明确你所处的框架是非常重要的。这对自己也是一种理清思路的过程：你到底对这件事怎么看？为什么这么看？这是第一点。第二部分是，在会议内部，我认为你需要做几件事：明确这是什么样的会议。只是一个进展更新（update）吗？“太好了，只是更新一下？我会听你说，为你做得好而鼓掌，然后让你继续工作。”还是一个决策会议？如果是决策，那么优缺点是什么？有些非常严重的失败模式就是一种会议滑向了另一种会议，有人会问：“我们为什么要那样做？那是怎么回事？”

---

### [00:59:46] Sriram Krishnan

**English:**
And then somebody will start fighting on and people are like, "Oh gosh, we shouldn't have brought this topic at all." And everyone listening to this has probably been to one of those meetings. There's also something else which teams sometimes like to do, which is they'd be like, "Hey, we have a hard problem. We don't know what to do." They're trying to kind of push the responsibility of the [inaudible 01:00:02] from them to you which may be fine, but you should be like, "Hey, are you saying that you can't make up your mind and you want me to make up your mind for you?" You want to be very explicit because often I've seen this when there are hard decisions, teams are like, "The exec feels strongly, we don't want to know what to do," and they kind of want to push the accountability to you and here, we watch out for that a lot.

**中文翻译:**
然后有人就开始争论，大家心想：“天哪，我们根本不该提这个话题。”每个听众可能都参加过这种会议。还有一种情况，团队有时喜欢说：“嘿，我们遇到了一个难题，不知道该怎么办。”他们试图把责任推给你。这可能没问题，但你应该明确问：“嘿，你是说你拿不定主意，想让我帮你拿主意吗？”你必须非常明确，因为我经常看到在面临艰难决策时，团队会觉得“高管态度很强硬，我们不知道该怎么办”，他们想把责任推给你，我们要非常警惕这一点。

---

### [01:00:25] Sriram Krishnan

**English:**
There are a lot of hygiene things we think are very important. For example, send out a pre-read before, make sure it's the right people in the room, not everybody, but not missing out key people. Make sure you're paying complete attention, make sure everyone gets a chance to talk which by the way, I was really bad at. And those things go a really long way. Oh, and one final thing, have a regular rhythm to those, so you're doing this every month, et cetera. What I hate, I stole this line from Gokul Rajaram, is the phrase, "Hero meetings." All of us have been this which is there's a big thing, there's a big review, it's probably a go/no-go, maybe it's career limiting, maybe it'll get our team funded and everyone is stressed out. You spent two weeks working on a deck and the first 20 minutes of conversation goes totally sideways because the exec thought of something. Every one of us has been one of those. Those are bad.

**中文翻译:**
我们认为有很多“会议卫生”习惯非常重要。例如，提前发送预读材料；确保参会人员合适，不是所有人，但不能漏掉关键人物；确保你全神贯注；确保每个人都有机会发言（顺便说一下，我以前在这方面做得非常差）。这些细节非常重要。噢，最后一件事，要有规律的节奏，比如每月一次。我最讨厌的一种形式——我从 Gokul Rajaram 那里借用了这个词——叫“英雄会议”（Hero meetings）。我们都经历过：有一件大事，有一个重大的评审，可能是决定项目生死（go/no-go）的时刻，可能关乎职业前途，或者关乎团队能否拿到预算，每个人都压力山大。你花了两个星期做 PPT，结果会议的前 20 分钟就因为高管想到了某件事而彻底跑偏了。我们都经历过，那太糟糕了。

---

### [01:01:11] Sriram Krishnan

**English:**
The way to fix that is to have a regular check in, so you have meeting every single week and becomes like you're not spending weeks, it a muscle, it's a rhythm of what you do and those are reason. Sorry, I went on a bit of a speech there.

**中文翻译:**
解决办法是进行定期的沟通，比如每周开一次会，这样你就不用花好几周去准备，它变成了一种“肌肉记忆”，一种工作的节奏。抱歉，我刚才说得有点多了。

---

### [01:01:21] Lenny

**English:**
What I was thinking about is you two have worked at basically all the big consumer companies and coming back to imposter syndrome briefly, what's the worst product you've built or the biggest failure you've each built and what did you learn?

**中文翻译:**
我在想，你们两位几乎在所有大型消费级科技公司都工作过。回到刚才提到的冒充者综合征，你们各自做过的最差的产品或最大的失败是什么？你们从中学到了什么？

---

### [01:01:34] Aarthi Ramamurthy

**English:**
Oh, man. At a startup, I tried all kinds of things. We kind of grasp at straws and build whatever. And also I think I fell victim to, a lot of startups do this where they'll see some theme that has become a meme with investors and they'll be like, "I'm going to go build that company. I'm just going to take that technology, adopt it." You're kind of start of seeing that with AI now where it's like everything is now an AI company. Of course everyone has incorporated AI part of it is you get it, you kind of want to be in the game and be cool, but if it doesn't really fit with your product hypothesis and thesis and what your customers are asking for, don't fall for that fad.

**中文翻译:**
噢，天哪。在创业公司，我尝试过各种各样的事情。我们有点像病急乱投医，什么都做。而且我觉得我成了某种趋势的受害者——很多初创公司都会这样，看到某个在投资者圈子里火起来的主题，就说：“我要去开那样的公司，我要采用那种技术。”现在在 AI 领域也能看到这种情况，好像每家公司现在都是 AI 公司。当然，每个人都把 AI 整合进去，这可以理解，你想参与其中，想显得很酷。但如果它不符合你的产品假设、论点或客户的需求，千万别盲目跟风。

---

### [01:02:18] Aarthi Ramamurthy

**English:**
And I did stuff where I totally fell for the fad. I think I had a consumer electronics e-commerce, like a machine learning model where we rent and then recommend the right things to go buy. But then we were like, "Oh, Uber is doing this whole UberX thing where it was people having their cars and they could do this thing." And at that time, I think this whole shared ownership of stuff became such a big thing and I was like, "Oh, I'm going to do that exact thing where it's like it's less-

**中文翻译:**
我确实做过一些完全盲目跟风的事。我当时做了一个消费电子产品的电商，用机器学习模型来租赁并推荐合适的商品。但后来我们想：“噢，Uber 正在搞 UberX，让人们用自己的车来提供服务。”当时“共享所有权”的概念非常火，我想：“噢，我也要做同样的事，让它变得更轻量——”

---

### [01:02:51] Aarthi Ramamurthy

**English:**
At that time, we were partnering with Best Buy and we were like, "Well, we should do this other side product," which is people's own stuff that they could put up on the site. Total disaster because there is a lot totally different company logistics, everything. You could build it out as a different business, but we had a small team which was heavily focused on this business, was already doing pretty well and then we had to fork all of that effort to go build this other thing which required different skillset, different fulfillment technology and all of that. And so we were like, "Okay, disaster." So we pull the plug on it many months in, but we should have done it a lot sooner.

**中文翻译:**
当时我们正和百思买（Best Buy）合作，我们想：“好吧，我们应该做另一个副产品”，就是让人们把自己的东西放到网站上。结果彻底失败了，因为这涉及完全不同的公司物流和一切流程。你可以把它作为一个独立的业务来做，但我们当时是一个专注于现有业务的小团队，现有业务已经做得不错了，然后我们不得不分散精力去做这个需要不同技能、不同履行技术的东西。所以我们觉得：“好吧，这是场灾难。”我们在几个月后停止了那个项目，但我们本该更早止损的。

---

### [01:03:26] Lenny

**English:**
What you learn from that experience other than pulling the plug sooner?

**中文翻译:**
除了“应该更早止损”之外，你还从那次经历中学到了什么？

---

### [01:03:30] Aarthi Ramamurthy

**English:**
Yeah, don't fall for fads. It's do the thing that your customers are asking for and are willing to pay for. Or not even what your customers are asking for, but if you have something that is working, don't get distracted. It's very easy to be like, "I'm going to build this five other things and it's all going to accrue value." And I literally talked to another founder last week where they're like, "But I'm building this consumer thing, but I'm also going to do this SDK so I can go partner with these other companies and do this B2B thing." And I'm like, "But you are four people. Why are you doing that? That's crazy."

**中文翻译:**
是的，不要盲目跟风。要做客户真正需要并愿意付费的事情。或者甚至不是客户要求的，但如果你手头有行之有效的东西，就不要分心。人很容易想：“我要再做五件其他的事，它们都会产生价值。”我上周刚和另一位创始人聊过，他说：“我在做这个 C 端产品，但我还打算做一个 SDK，这样我就可以和其他公司合作做 B 端业务。”我说：“但你们只有四个人，为什么要那样做？太疯狂了。”

---

### [01:04:10] Aarthi Ramamurthy

**English:**
"But imagine catering to 10X the market." I'm like, "Well, but you're going from a consumer payments thing to something like Stripe and that's a very different business, so do you want to go do that and go have that trade-off conversation?" So that was one big learning. At Netflix, we tried this out, we knew it was an experiment. This was before Netflix was cool like 10, 11 years ago, where [inaudible 01:04:27].

**中文翻译:**
他说：“但想象一下，这能覆盖 10 倍的市场。”我说：“好吧，但你正在从一个 C 端支付产品转向像 Stripe 那样的东西，那是完全不同的业务，你真的想做那个权衡吗？”所以那是很大的一个教训。在 Netflix 时，我们也尝试过一些东西，我们知道那是实验。那是 10、11 年前，在 Netflix 还没现在这么酷的时候。

---

### [01:04:27] Lenny

**English:**
Like DVD place?

**中文翻译:**
还是租 DVD 的时候？

---

### [01:04:28] Aarthi Ramamurthy

**English:**
Yeah. So my job was to build the streaming player software that goes-

**中文翻译:**
是的。我当时的工作是开发流媒体播放器软件，用于——

---

### [01:04:34] Lenny

**English:**
No big deal.

**中文翻译:**
没什么大不了的（反讽）。

---

### [01:04:36] Aarthi Ramamurthy

**English:**
Yeah. My job was to go partner with Samsung and Sony and Panasonic and build a software, the SDK that goes into TVs and set-top boxes and Blu-ray players. This is before international, Netflix and original content like House of Cards and all of that, but one of the experiments we tried back then was Netflix 3D. Total disaster.

**中文翻译:**
是的。我的工作是与三星、索尼、松下合作，开发内置在电视、机顶盒和蓝光播放器中的软件 SDK。那是在 Netflix 走向国际化、推出《纸牌屋》等原创内容之前。我们当时尝试的一个实验是 Netflix 3D。彻底失败。

---

### [01:04:36] Lenny

**English:**
Like on 3D TVs? That was another fad issue. Oh, no.

**中文翻译:**
是在 3D 电视上吗？那是另一个跟风的问题。噢，不。

---

### [01:05:02] Aarthi Ramamurthy

**English:**
Exactly, yeah. But we had a lot of OEMs who were like, "3D is going to be really big and you have to go invest in that." So I spent months trying to do this left eye, right eye codec and trying to make this whole thing work with these odd glasses, sitting in your living room trying to do 3D content, which is really hard. I think we tried seven movie titles over, imported it over to 3D and they're like, "I don't think this is such a great experience," and we ended up pulling the plug on it. We knew it was an experiment going in, we knew there was a good exit criteria, but it was kind of a failure.

**中文翻译:**
没错。当时有很多设备制造商（OEM）说：“3D 会火得一塌糊涂，你们必须投资。”所以我花了几个月时间研究左眼、右眼的编解码器，试图让这整套东西配合那些奇怪的眼镜工作。坐在客厅里看 3D 内容，这真的很难。我想我们尝试了七部电影，把它们转成 3D，结果大家觉得：“我觉得这体验不怎么样。”最后我们停止了这个项目。我们开始时就知道这是个实验，也设定了退出标准，但它确实算是个失败。

---

### [01:05:35] Sriram Krishnan

**English:**
All my products were huge successes, so I have nothing.

**中文翻译:**
我做的所有产品都取得了巨大的成功，所以我没什么可说的。

---

### [01:05:40] Lenny

**English:**
Okay, [inaudible 01:05:40] other way it's going to go.

**中文翻译:**
好吧，我就知道会这样。

---

### [01:05:41] Sriram Krishnan

**English:**
Yeah, what are you talking about? No, I'll say part of the very first thing I worked on and it's complicated because I love the team and I think we did some great work, was we work on something called Visual Studio for Devices. And the idea was-

**中文翻译:**
是的，你在说什么呢？不，我要说我参与的第一个项目，这有点复杂，因为我热爱那个团队，我觉得我们做了一些很棒的工作，那个项目叫 Visual Studio for Devices。它的想法是——

---

### [01:05:52] Lenny

**English:**
What was it? Wishlist for what?

**中文翻译:**
那是什么？什么的愿望清单？

---

### [01:05:54] Sriram Krishnan

**English:**
Oh, sorry. Visual Studio for Devices. This was in 2005-

**中文翻译:**
噢，抱歉。是 Visual Studio for Devices。那是 2005 年——

---

### [01:05:58] Lenny

**English:**
Oh, like coding on your phone?

**中文翻译:**
噢，就像在手机上编程？

---

### [01:05:59] Sriram Krishnan

**English:**
Well, coding for your phone. And the idea was this was before iPhone it, this was the era of Windows Mobile Pocket PCs and Windows Mobile smartphones, so-

**中文翻译:**
嗯，是为手机编程。想法是，那是在 iPhone 出现之前，那是 Windows Mobile Pocket PC 和 Windows Mobile 智能手机的时代，所以——

---

### [01:06:08] Aarthi Ramamurthy

**English:**
Man, the kids listening to this like, "What's he talking about? What was before iPhone?"

**中文翻译:**
天哪，听这个节目的孩子们会想：“他在说什么？iPhone 之前还有时代？”

---

### [01:06:14] Sriram Krishnan

**English:**
Yeah. And this was 2005/2006, so right before the iPhone came out, the two years and we were fresh out of school, both of us worked on this. And there was basically an ID, Visual Studio, and we had an extension where you could write code on a slimmed down version of the .NET Framework and you would run apps on these small phones and these small Pocket PCs. And the team was fantastic, we're all still friends and without that, we wouldn't have our jobs or careers, so that's not the point. The point is we all knew these phones were terrible and slow and awful, but what we were told all the time was, "Listen, nobody can change this because the carriers control this market. They determined what software goes on a phone, goes on a device, so this entire ecosystem is all about competing with Blackberry."

**中文翻译:**
是的。那是 2005、2006 年，就在 iPhone 问世前的两年，我们刚毕业，我们两个都参与了这个项目。基本上有一个 IDE（集成开发环境）叫 Visual Studio，我们有一个扩展，你可以在精简版的 .NET 框架上写代码，然后在那些小手机和小 Pocket PC 上运行 App。团队非常棒，我们现在还是朋友，没有那个项目就没有我们的职业生涯，但这不重要。重点是，我们都知道那些手机很糟糕、很慢、很烂，但我们一直被告知：“听着，没人能改变现状，因为运营商控制着这个市场。他们决定手机上装什么软件，所以整个生态系统都是为了和黑莓（Blackberry）竞争。”

---

### [01:06:53] Sriram Krishnan

**English:**
In fact, the codename for Windows Mobile 5.0 was Crossbow and kind of a little secret which I think is kind of public now, Crossbow was a weed killer, it killed blackberries. And so the whole idea was how do you kind go after the enterprise market Blackberry and work with the carriers? And then in 2007, Steve Jobs comes out and says, "I have three launches for you, actually it's one thing." I remember texting my manager, I was like, "You have to see this keynote," because it was so obvious that this thing was going to change everybody. And everyone in Microsoft was like, "No, it's the carriers who have all the control. They will never let these devices [inaudible 01:07:32]. But actually, it turns out that's not true.

**中文翻译:**
事实上，Windows Mobile 5.0 的代号是 Crossbow（十字弓），这算是个小秘密，我想现在已经公开了。Crossbow 是一种除草剂，专门杀黑莓（Blackberry）的。所以整个想法就是如何去抢占黑莓的政企市场，并与运营商合作。然后在 2007 年，史蒂夫·乔布斯走出来说：“我有三个产品要发布，其实它们是一个东西。”我记得我给经理发短信说：“你一定要看这场发布会。”因为很明显，这东西将改变所有人。但微软的每个人都说：“不，运营商掌控着一切，他们绝不会让这些设备……”但事实证明，那不是真的。

---

### [01:07:34] Sriram Krishnan

**English:**
I learned two lessons from that. One is the market is bigger than all of you. You can work with the amazing team, you can work with the A plus team, A plus company, but if the market shifts, you can't overcome a bad market or a bad space. The second part is at the heart of it, if you feel some product is bad and if you feel like this new thing, it's just better to use and you can just feel it instinctly, you have to follow the instinct. Because I remember being like, "Yeah, the iPhone is cool, it feels so much better, but okay, maybe they're right, maybe it is the-

**中文翻译:**
我从中吸取了两个教训。第一，市场比你们所有人都大。你可以和最顶尖的团队、最顶尖的公司合作，但如果市场发生了转移，你无法战胜一个糟糕的市场或领域。第二，核心在于，如果你觉得某个产品很烂，而你觉得这个新东西更好用，你能直觉地感受到它，你就必须追随这种直觉。因为我记得当时我想：“是的，iPhone 很酷，感觉好多了，但好吧，也许他们是对的，也许运营商才是——”

---

### [01:08:04] Aarthi Ramamurthy

**English:**
All these people are so much more senior than us, clearly they've put so much more thought into this, clearly what do I know kind of thing. And you realize that now, I think over, what, we've done product for 15, 16 years now, and we look at it and go, "We now have these patterns to go match against." We know when something is better, when something is working, when something feels like it's intuitive, you follow that intuition now then and not try and fight it and be like, "But here are all these things where this is not going to get there," kind of thing. It just doesn't work that way, the market ultimately wins.

**中文翻译:**
当时觉得“这些人比我们资深得多，显然他们考虑得更周全，我懂什么呢”。现在你意识到，我们做产品已经 15、16 年了，我们回头看会觉得：“我们现在有了这些可以匹配的模式。”我们知道什么时候东西更好，什么时候东西奏效，什么时候东西感觉很直观。你现在会追随那种直觉，而不是试图对抗它，说“但是还有这么多理由说明它行不通”。事情不是那样运作的，市场最终会获胜。

---

### [01:08:40] Sriram Krishnan

**English:**
And I think when you're younger, you should really trust your instincts. And instincts can mean, "I just hear people talking about this other thing a lot," or, "I hear that other company's name come up a lot," or, "I tried this thing and... And you may not have the framework to articulate it and you may not trust your instincts, but there's something there and you should learn to listen to that voice. You're like, "Why is that? Why are we talking about it? Maybe they're doing better marketing, maybe their CEO is better on Twitter or they have Lenny Rachitsky as an angel investor or they advertise on your podcast," there we go. I tried to get a plug in there, Lenny. But you have to listen to your instinct because there's usually something there to follow.

**中文翻译:**
我认为当你年轻时，你应该真正信任你的直觉。直觉可能意味着：“我经常听到人们在谈论另一件事”，或者“我经常听到另一家公司的名字”，或者“我尝试了那个东西，然后……”你可能还没有框架来表达它，你可能不信任你的直觉，但那里一定有什么东西，你应该学会倾听那个声音。你会问：“为什么会这样？为什么我们在谈论它？也许他们营销做得更好，也许他们的 CEO 更擅长发推特，或者他们有 Lenny Rachitsky 作为天使投资人，或者他们在你的播客上打广告。”看吧，Lenny，我试着植入了一个广告。但你必须倾听你的直觉，因为通常那里有值得追随的东西。

---

### [01:09:22] Lenny

**English:**
I only have two more questions, one is you mentioned framework. I know you have strong opinions on a very specific framework, Jobs-to-be-Done and I know you're not a fan. What do you want to share about why you don't like Jobs-to-be-Done as a framework?

**中文翻译:**
我最后还有两个问题。一个是关于框架。我知道你对一个特定的框架有很强烈的看法，那就是“待办任务”（Jobs-to-be-Done，JTBD），我知道你不是它的粉丝。关于为什么你不喜欢 JTBD 框架，你想分享些什么？

---

### [01:09:37] Sriram Krishnan

**English:**
All right, I knew you were going to ask me this and I was thinking how do I be kind of balanced in-

**中文翻译:**
好吧，我就知道你会问我这个。我一直在想该如何平衡地——

---

### [01:09:46] Aarthi Ramamurthy

**English:**
Bombastic?

**中文翻译:**
夸张地？

---

### [01:09:47] Sriram Krishnan

**English:**
No, balanced and give measured answer and say, "Well, every framework has good and bad ways and there are good things and bad things," and I could probably given one of those answers. No, I actually think the more fun thing to do is I'm going to say I hate Jobs-to-be-Done, I think it's a terrible framework, I think no successful company has ever been built on top of JTBD and if you pick JTBD, you're probably doomed and here's why. Let's go back to the canonical example. And there's nothing Clayton Christensen who was a legend, amazing, the milkshake, what is the idea of being the milkshake? You are a person, you go into a commute and you're like, "Hey, I'm going to get this milkshake because it's the exact right quantity and save me on my commute." But they changed it up and all of a sudden, boom, it was not serving the job and look into the thing that actually it is serving the customer for.

**中文翻译:**
不，是平衡且克制地回答，说：“嗯，每个框架都有优缺点，都有好的一面和坏的一面。”我本可以给出那样的回答。不，我觉得更有趣的做法是直接说：我讨厌 JTBD，我觉得它是个糟糕的框架，我认为没有任何一家成功的公司是建立在 JTBD 之上的。如果你选择了 JTBD，你可能注定要失败。原因如下：让我们回到那个经典的例子。克莱顿·克里斯坦森（Clayton Christensen）是个传奇，非常了不起，他提出了“奶昔”的例子。奶昔的理念是什么？你是一个通勤的人，你想：“嘿，我要买这杯奶昔，因为它的量正好，能陪我度过通勤时间。”但他们改变了思路，突然之间，重点不再是奶昔本身，而是它实际上在为客户完成什么“任务”。

---

### [01:10:39] Sriram Krishnan

**English:**
I'll tell you that's not how actual real companies work because in real companies there are so many different parameters. For example, maybe it is really, really hard to go build that milkshake. Maybe there's another person who opens up across the street who builds a better milkshake than you do. Maybe the cup configuration in the car changes, maybe the supply chain for milkshake changes. But in my world, let me make this more concrete, when you work in social media, there are often so many other agents in the system where you can't focus on one person's equation. I'll give you an example. When you sign up for Instagram right now, when you sign up for Facebook for many, many years, Facebook knew that it needed to get you to 10 friends in 14 days.

**中文翻译:**
我要告诉你，现实中的公司不是那样运作的，因为在现实公司中，有太多不同的参数。例如，也许制作那杯奶昔真的非常非常难。也许街对面开了另一家店，做的奶昔比你的好。也许汽车里的杯架设计变了，也许奶昔的供应链变了。在我的世界里，让我说得更具体点：当你从事社交媒体工作时，系统中通常有太多的其他参与者，你不能只关注一个人的等式。我给你举个例子。现在你注册 Instagram，或者过去很多年里你注册 Facebook 时，Facebook 都知道它需要让你在 14 天内交到 10 个朋友。

---

### [01:11:14] Sriram Krishnan

**English:**
If you got your 10 friends in 14 days, you were probably going to use Facebook. So it'd be like, "Well, we're going to throw every tool we have at our disposal to get you to 10 friends and 14 days." So if you signed up for Facebook for many, many years, you'll get this little thing called People You May Know. Then you'll have this person who just signed up for Facebook, you go, "Why I'm seeing this person?" It's not because you need a friend, because they need a friend. So what Facebook did was it made your experience slightly worse to make that person's experience slightly better. This was performing no job for you, it was trying to perform a job for them. Was the right trade-off or not? I don't know.

**中文翻译:**
如果你在 14 天内有了 10 个朋友，你大概率会持续使用 Facebook。所以他们会想：“好吧，我们要动用一切手段让你在 14 天内交到 10 个朋友。”所以如果你在过去很多年里注册 Facebook，你会看到一个叫“你可能认识的人”的小功能。你会看到一个刚注册 Facebook 的人，然后纳闷：“为什么我会看到这个人？”这不是因为你需要朋友，而是因为**他们**需要朋友。所以 Facebook 所做的是让你的体验稍微变差一点，从而让那个人的体验变好一点。这对你来说没有完成任何“任务”，它是在试图为他们完成任务。这个权衡对不对？我不知道。

---

### [01:11:53] Sriram Krishnan

**English:**
We had this problem at Twitter. The single best product launched for the last five years at Twitter was the introduction of the algorithmic ranking and-

**中文翻译:**
我们在 Twitter 也遇到过这个问题。Twitter 过去五年发布的最好的产品就是引入了算法排序，而且——

---

### [01:11:53] Aarthi Ramamurthy

**English:**
God, hearsay. Oh my God.

**中文翻译:**
天哪，异端邪说。噢我的天。

---

### [01:11:53] Sriram Krishnan

**English:**
... and it saved the company and power users hated it. They're like, "I know how to control my timeline, I know who to follow," et cetera, et cetera. It turns out though, this is not built for power users. It was really built for a regular person when they sign up for Twitter to be able to give them a great experience because we knew the power users, they already have. And by the way, TikTok really great example of that. So how do you make the trade-off? Do you pick power users or do you pick a regular person? What is the trade-off between them? Jobs-to-be-Done does not tell you that.

**中文翻译:**
……它拯救了公司，但核心用户（power users）讨厌它。他们说：“我知道怎么控制我的时间线，我知道该关注谁”等等。但事实证明，这并不是为核心用户设计的。它是为普通人设计的，让他们在注册 Twitter 时能获得良好的体验，因为我们知道核心用户已经留下来了。顺便说一下，TikTok 也是一个绝佳的例子。那么你如何做权衡？你是选择核心用户还是选择普通人？他们之间的权衡是什么？JTBD 框架不会告诉你这些。

---

### [01:12:22] Sriram Krishnan

**English:**
Let me tell you this. If you go order a package from Amazon right now, five years ago or three years ago, you would've gotten an email, it'll tell you what is that package, what is in it and when it's showing up doorstep. Last couple of years, it doesn't, why? Because Amazon doesn't want Google to have that data inside Gmail system. So it is, for very, very valid competitive reasons, made your experience worse because that's the right thing do for a company. So real life and real product is all about these trade-offs and whenever I've seen people trot out JTBD, it's a tell that they actually haven't dealt with a trade-off, where you have to make one person's life slightly worse in one situation for some other interesting dynamic. Okay, I'll stop with my mini speech.

**中文翻译:**
我再告诉你一件事。如果你现在在亚马逊订一个包裹，五年前或三年前，你会收到一封邮件，告诉你包裹里是什么，什么时候送到门口。过去几年，它不再这么做了。为什么？因为亚马逊不想让谷歌在 Gmail 系统里拥有这些数据。所以，出于非常合理的竞争原因，它让你的体验变差了，因为这对公司来说是正确的做法。所以现实生活和真实产品充满了这些权衡。每当我看到有人搬出 JTBD，我就知道他们其实还没处理过真正的权衡——即在某种情况下为了另一种有趣的动态而让一个人的生活稍微变差一点。好吧，我的简短演讲到此结束。

---

### [01:13:02] Lenny

**English:**
This is my favorite part of the podcast so far. I'm hoping people listen to the end here because this is-

**中文翻译:**
这是到目前为止我最喜欢的部分。我希望大家能听到最后，因为这——

---

### [01:13:07] Aarthi Ramamurthy

**English:**
Yeah, I think JTPD, the problem with that is it's just too idealistic. And most frameworks are, but this one just takes it up a notch where it's like it's almost meant for people who are so naive about product building and especially product building at scale. I think it might work for the V1 or just a hypothesis that you're trying to go test out, where it's like, "What is the core value that we are trying to serve for this user," kind of thing. But really V2, V3, it kind of falls apart because you have these super hard trade-offs that you have to make and every company goes through that. So it's almost a little too idealistic in its thinking. I think that's the biggest problem with it.

**中文翻译:**
是的，我觉得 JTBD 的问题在于它太理想化了。大多数框架都是如此，但这个框架更甚，它几乎是为那些对产品构建（尤其是大规模产品构建）非常天真的人准备的。我觉得它可能适用于 V1 版本，或者只是你想测试的一个假设，比如“我们要为这个用户提供的核心价值是什么”。但到了 V2、V3 版本，它就分崩离析了，因为你必须做出极其艰难的权衡，每家公司都会经历这些。所以它的思维方式有点太理想化了。我觉得这是它最大的问题。

---

### [01:13:44] Sriram Krishnan

**English:**
Yeah, and look, I was being a bit bombastic obviously and it does have some [inaudible 01:13:48].

**中文翻译:**
是的，看，我刚才显然有点夸张了，它确实有一些……

---

### [01:13:47] Lenny

**English:**
We're going to edit this part out. This is [inaudible 01:13:49].

**中文翻译:**
我们会把这部分剪掉的。这是……

---

### [01:13:50] Sriram Krishnan

**English:**
Yeah, blah, blah, blah, blah, blah, blah. It's may be useful in some niche case which nobody has ever heard about-

**中文翻译:**
是的，吧啦吧啦吧啦。它可能在某些没人听说过的小众案例中有用——

---

### [01:13:55] Aarthi Ramamurthy

**English:**
For milkshakes.

**中文翻译:**
比如卖奶昔。

---

### [01:13:55] Sriram Krishnan

**English:**
Right, for milkshakes. Yeah, if you're starting a milkshake company, go for it. But I'll say, so people have good [inaudible 01:14:01] what is the alternate, would involve not JTBD, how do we actually figure this out? And I think a much better way and I really understand the early Facebook years, which is systems thinking. Think of all the players in the system, think of all of their incentives and how they interact with each other. So in that milkshake example, your car, the person, the competitor across the road, the supply chain, the profit margin of each person, the podcast they have to listen to, what is each person's incentives that you're trying to drive and look at how they all work together.

**中文翻译:**
对，卖奶昔。如果你要开一家奶昔公司，那就用它吧。但我想说，如果不用 JTBD，替代方案是什么？我们到底该如何思考？我认为一种更好的方式——我也非常理解 Facebook 早期的做法——就是“系统思维”（systems thinking）。考虑系统中的所有参与者，考虑他们所有的激励机制（incentives）以及他们如何相互作用。在奶昔的例子中，你的车、买奶昔的人、路对面的竞争对手、供应链、每个人的利润率、他们要听的播客，你试图驱动的每个人的激励机制是什么，并观察它们是如何共同运作的。

---

### [01:14:31] Sriram Krishnan

**English:**
So for example, so then when you look at the algorithmic rankings case, sure it kind of deprioritized a certain set of people, but it prioritized the other set of people and you could then have a much more rational discussion about whether that trade-off is worth it. Maybe it is, maybe it's not, but it's a much better discussion that, "Well, that person wanted milkshake, we're not giving them milkshake," what do you do? That doesn't help you at all. And yes, it may be a good tool in ways that I absolutely have not seen so far, but-

**中文翻译:**
例如，当你审视算法排序的案例时，它确实降低了某些人的优先级，但它提高了另一群人的优先级。然后你就可以进行更理性的讨论：这种权衡是否值得？也许值得，也许不值得。但这比讨论“那个人想要奶昔，我们没给他奶昔，该怎么办？”要好得多。后者对你一点帮助都没有。是的，它可能在某些我目前还没看到的地方是个好工具，但是——

---

### [01:14:55] Aarthi Ramamurthy

**English:**
Yeah, also the other tool I think I really like is first principles thinking. Everyone throws it out there, it's kind of become this cliche now, but really think about it as if your product didn't exist and if you had to start over from scratch, would you build it the exact same way for these set of customers? How would you think about it? Oftentimes people hyper-focused on competition and what other company is doing. That almost never matters. Other companies are probably looking at you and going, "What are these guys doing?" And you have to look at it as all of these systems, as Sriram said, but also really think about it as if you had to do this all over again, how would you do this? Is this the right way or are you just inheriting decisions over time and just trying to make incremental changes and trade-offs and stuff like that? I like that way more than trying to think of it as a job that a customer hires you to go do. It just sounds like really naive.

**中文翻译:**
是的，我非常喜欢的另一个工具是“第一性原理思维”（first principles thinking）。每个人都在说这个词，它现在已经成了陈词滥调，但你真的要思考：如果你的产品不存在，如果你必须从零开始，你会为这群客户以完全相同的方式构建它吗？你会怎么想？通常人们过度关注竞争，关注其他公司在做什么。那几乎从来都不重要。其他公司可能也在看着你，想：“这些家伙在干什么？”正如 Sriram 所说，你必须把这一切看作系统，但也要真正思考：如果你必须重来一次，你会怎么做？这是正确的方式吗？还是你只是在继承过去的决定，并试图做一些增量式的改变和权衡？我更喜欢这种方式，而不是把它想象成客户雇佣你去做的一项“任务”。那听起来真的很天真。

---

### [01:15:51] Sriram Krishnan

**English:**
It makes you sound smart, I think. But I'll give you an example. Sorry, I have to-

**中文翻译:**
我觉得它只是让你听起来很聪明。但我给你举个例子。抱歉，我必须——

---

### [01:15:55] Aarthi Ramamurthy

**English:**
Stop. You just gave so many examples.

**中文翻译:**
停。你已经举了太多例子了。

---

### [01:15:55] Lenny

**English:**
Examples is good. Let's do one more example.

**中文翻译:**
例子很好。再来一个例子。

---

### [01:16:00] Sriram Krishnan

**English:**
One last example, okay. One of my favorite posts from Lenny in the recent times, I don't know when this episode going to go out, is the Duolingo growth post. I've been sharing it all the time, it's exactly one of the best posts I've seen recently. What is the job that people are hiring Duolingo to go do? Help teach them a new language, right? That sounds about right, some version of that. But if you look at that post, what actually saved the company?

**中文翻译:**
最后一个例子，好吧。Lenny 最近写的一篇我最喜欢的文章（我不知道这一集什么时候播出）是关于 Duolingo 增长的那篇。我一直在分享它，那绝对是我最近看到的最好的文章之一。人们“雇佣”Duolingo 是为了完成什么任务？教他们一门新语言，对吧？听起来没错，大概就是这样。但如果你读了那篇文章，真正拯救公司的是什么？

---

### [01:16:21] Sriram Krishnan

**English:**
So they tried dozens of different things, found their North Star metric, the current user retention rate, then they tried leaderboards, realized why leaderboards don't work. Then ultimately, it is streaks that worked up. Tell me how do you use Jobs-to-be-Done to get to a world where, "Hey, we really going to show these fire emojis and you need to kind of get that fire emoji every day. Because what it's really getting at is the sense of [inaudible 01:16:45] so there is no JTBD brainstorming offsite that'll ever get you there. What I've seen quickly, is almost always when you get a great product breakthrough like that, it comes from one person usually having a product intuition about something, about the psychological thing the product delivers and systems thinking. Those are the only two places I've ever seen it up. Okay, I'll stop now.

**中文翻译:**
他们尝试了几十种不同的方法，找到了他们的北极星指标（North Star metric）——当前用户留存率，然后他们尝试了排行榜，意识到为什么排行榜不起作用。最后，真正起作用的是“连胜”（streaks）。告诉我，你怎么用 JTBD 框架推导出：“嘿，我们要展示这些火焰表情符号，你每天都得拿到那个火焰表情符号。”因为它真正触及的是一种心理层面的东西。没有任何一场 JTBD 的头脑风暴会议能带你达到那个境界。我所看到的伟大的产品突破，几乎总是源于某个人对某种心理需求的直觉，以及系统思维。这是我见过的仅有的两种产生突破的方式。好了，我不说了。

---

### [01:17:08] Lenny

**English:**
No, that example is amazing. I was going to talk about how I've actually found it a little useful in my life, but I think that's just going to keep us going-

**中文翻译:**
不，那个例子太棒了。我本想说我在生活中其实觉得它有一点用，但我觉得那只会让我们继续聊下去——

---

### [01:17:16] Aarthi Ramamurthy

**English:**
I was just going to ask you, are you now convinced Lenny, because Sriram has spent 45,000 minutes just trying to tell you why you should not be using JTBD-

**中文翻译:**
我正想问你，Lenny，你现在被说服了吗？因为 Sriram 已经花了 45,000 分钟试图告诉你为什么不应该使用 JTBD——

---

### [01:17:24] Sriram Krishnan

**English:**
I'm just going to get canceled by Lenny's audience. Lenny's audience is like, "This is a reasonable podcast." They're like, "I now hate this guy."

**中文翻译:**
我肯定会被 Lenny 的听众“取消”的。Lenny 的听众会想：“这本来是个挺理性的播客。”现在他们会说：“我现在讨厌这家伙了。”

---

### [01:17:30] Lenny

**English:**
It. I think the JTBD industrial complex is going to come after you.

**中文翻译:**
我觉得“JTBD 工业复合体”会来找你麻烦的。

---

### [01:17:35] Sriram Krishnan

**English:**
It's all mafia.

**中文翻译:**
那全是黑手党。

---

### [01:17:36] Aarthi Ramamurthy

**English:**
I think if you see a bunch of mass unsubscribes, I just want to say this is not on Lenny, this is on Sriram.

**中文翻译:**
我想说，如果你看到一大波退订潮，那不是 Lenny 的错，是 Sriram 的错。

---

### [01:17:41] Lenny

**English:**
[inaudible 01:17:41] from your podcast.

**中文翻译:**
（笑声）从你的播客里。

---

### [01:17:43] Sriram Krishnan

**English:**
Yeah, I'm going to get attacked by a bunch of people who are really good at holding offsites and framework thinking.

**中文翻译:**
是的，我会被一群擅长开场外会议和框架思维的人攻击。

---

### [01:17:50] Lenny

**English:**
Yeah. I find it useful in specific cases, not as a scaled product development process, I think which you've run into or just the whole company is run by Job-to-be-Done. One paper was like, "What is the job?" And you're like, "The job is to get them to open that up three times more each day." Yeah. Okay, I know you guys have to run so I have one more question. I have this saying in my family that whenever we do something well, I'm like, "We're making it in America," because we also immigrated from the Ukraine. And as immigrants, you talked about your story of coming to America and clearly making it. You're both at the center of, I don't know, what's happening in tech, which is also at the center of the world in many ways. I'm curious what advice you would give to immigrants and people that have moved here recently or even a while ago, just how to make it and be successful in the US, especially in tech?

**中文翻译:**
是的。我发现它在特定情况下有用，但不是作为一种规模化的产品开发流程，我想你遇到的是那种整个公司都由 JTBD 驱动的情况。有一篇论文写道：“任务是什么？”你会觉得：“任务就是让他们每天多打开三次 App。”好吧，我知道你们得走了，所以我最后一个问题。我们家有个说法，每当我们做得很好时，我会说：“我们在美国成功了（We're making it in America）”，因为我们也是从乌克兰移民过来的。作为移民，你们谈到了来到美国并显然取得成功的故事。你们两位都处于科技发展的中心，而科技在很多方面也处于世界的中心。我很想知道，你们会给那些最近或很久以前搬到这里的移民什么建议？如何在美国取得成功，特别是在科技行业？

---

### [01:18:38] Aarthi Ramamurthy

**English:**
Some of it Sriram covered before, it's put yourself out there, don't be afraid to put yourself out there. Oftentimes, for us, it took us a decade plus to feel comfortable doing that because we came in, we look different, we sound different, we have strong accents, the number of times I got told at both startups and before then, "Oh my God, your accent, it's so difficult, I can't hear you," or, "I don't understand what you're saying." I got told before fundraising that nobody will be able to invest in my company because the accent is too strong. You already have these virtual barriers in your own head and then you have people coming and telling you actively that you are different and you can't succeed.

**中文翻译:**
Sriram 之前提到过一些：展示自己，不要害怕展示自己。通常对我们来说，花了十多年时间才感到自在，因为我们刚来时，长相不同，声音不同，口音很重。在创业公司和那之前，我无数次被告知：“噢天哪，你的口音太难懂了，我听不清你在说什么，”或者“我不明白你在说什么。”在融资前，有人告诉我没人会投资我的公司，因为口音太重了。你脑子里已经有了这些无形的障碍，然后还有人主动跑来告诉你，你与众不同，你无法成功。

---

### [01:19:24] Aarthi Ramamurthy

**English:**
Now if I had to do it all over again, I almost think these differences are what sets us apart and makes us unique. And you can do really interesting things with them because you are going to a place where you are rare and that's, I think, a really good thing. So you should sharpen that rareness and do really interesting things with it, whatever that might be. We have this show called Good Time Show, it's Aarthi and Sriram's Good Time Show and we focus a lot on outsiders being insiders or how you started out as... For us, we are quintessential examples of that where we're outsiders to tech, to Silicon Valley, to being in this world and we kind of "made it" to being here. And we often talk about what it takes to do that and whatever your version of being outsider and becoming an insider means. And for us, part of it is not being afraid to put yourself out there, power of cold emails, networking and being really proactive about that. What would you add to that or how do you think about it?

**中文翻译:**
现在如果让我重来一次，我几乎认为这些差异正是让我们脱颖而出、让我们变得独特的原因。你可以利用这些差异做非常有趣的事情，因为你来到了一个你很稀缺的地方，我认为这是一件非常好的事情。所以你应该磨练这种稀缺性，并用它做有趣的事。我们的节目叫《Good Time Show》，我们非常关注“局外人变成局内人”的话题。对我们来说，我们是典型的例子：我们曾是科技界、硅谷、这个世界的局外人，而我们现在“成功”地留在了这里。我们经常讨论实现这一目标需要什么，以及你心目中“从局外人变成局内人”意味着什么。对我们来说，其中一部分就是不害怕展示自己、冷邮件的力量、建立人脉以及保持积极主动。你会补充什么，或者你怎么看？

---

### [01:20:25] Sriram Krishnan

**English:**
I think everything Aarthi said, I don't have much to add. I'll just say if you're listening to this and you're immigrant, A, you're in the right place, B, you're listening to this podcast, reading this newsletter which is probably not your day-to-day today job, so you're already doing something right, so you're going to make it. You're already putting yourself out, you're doing the right things, you're going to make it.

**中文翻译:**
我觉得 Aarthi 说的很全面，我没什么要补充的。我只想说，如果你正在听这个节目并且你是一名移民：第一，你来对地方了；第二，你在听这个播客、读这份时事通讯，这可能不是你的日常工作，所以你已经在做正确的事了，你一定会成功的。你已经在展示自己，你在做正确的事，你一定会成功的。

---

### [01:20:42] Lenny

**English:**
What a beautiful way to end it. Two final questions, where can folks find you online, the Good Time Show, when you on Twitter, wherever? And then how can listeners be useful to you too?

**中文翻译:**
多么美好的结尾。最后两个问题：大家可以在哪里找到你们？《Good Time Show》、Twitter 还是其他地方？另外，听众们能为你们做些什么？

---

### [01:20:51] Sriram Krishnan

**English:**
They can find us online on JTBD sucks... No, sorry. That's my alt account. Well, we are on pretty much every platform. We are aarthiandsriram.com. That's kind of a home for our podcast, our show, so go subscribe there, but you can find us everywhere. We are on YouTube at again, Aarthi and Sriram, you can find us on Spotify podcast, wherever you get your daily milkshake/podcast and also on Twitter @aarthir and sriramk.

**中文翻译:**
他们可以在“JTBD 真烂”网站找到我们……不，抱歉，那是我的小号。好吧，我们几乎在所有平台上。我们的网站是 aarthiandsriram.com，那是我们播客和节目的主页，去那里订阅吧。你也可以在任何地方找到我们：YouTube 搜索 Aarthi and Sriram，Spotify 播客，或者任何你获取日常“奶昔/播客”的地方。Twitter 账号是 @aarthir 和 @sriramk。

---

### [01:21:24] Lenny

**English:**
Amazing.

**中文翻译:**
太棒了。

---

### [01:21:25] Aarthi Ramamurthy

**English:**
And how can people be useful?

**中文翻译:**
人们能帮上什么忙？

---

### [01:21:26] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:21:28] Sriram Krishnan

**English:**
I would say, this is going to sound like a cliche, but my job is fantastic in a way where if people are building amazing things, I benefit. Because if you build amazing things, odds are you're going to build a great company and then odds are that I'll have the chance to maybe invest or one of my partners will have the chance to invest and hopefully you make a bunch of money out of it. So just go out there and build things, tell me about the things you're building and also just reach out-

**中文翻译:**
我想说，这听起来可能像陈词滥调，但我的工作非常奇妙：如果人们在创造惊人的东西，我就能受益。因为如果你创造了惊人的东西，你很有可能建立一家伟大的公司，然后我就有机会投资，或者我的合伙人有机会投资，希望你能从中赚大钱。所以，尽管去创造吧，告诉我你在做什么，也可以随时联系我——

---

### [01:21:55] Aarthi Ramamurthy

**English:**
Yeah, just reach out, say hi.

**中文翻译:**
是的，尽管联系我们，打个招呼。

---

### [01:21:58] Sriram Krishnan

**English:**
Okay, let me put it, if you listen to this, send me a DM, send us a DM and send us an email and we will respond and-

**中文翻译:**
好吧，我这么说吧：如果你听了这集节目，给我发私信，给我们发私信或发邮件，我们会回复的——

---

### [01:22:04] Aarthi Ramamurthy

**English:**
If it is JTPD hate, just send it to him, not me. Just keep me out of it. But for everything else, if it's a nice note especially, send it to me, I will read it.

**中文翻译:**
如果是关于讨厌 JTBD 的内容，发给他，别发给我，让我置身事外。但对于其他所有事情，特别是友善的留言，发给我，我会读的。

---

### [01:22:12] Sriram Krishnan

**English:**
Yeah.

**中文翻译:**
没错。

---

### [01:22:13] Lenny

**English:**
All right. I hope you're ready for some DMs, both of you. Thank you again for being here. You've set the bar high for our first duo guest. Thank you again and goodbye everyone.

**中文翻译:**
好了，我希望你们两位已经准备好迎接私信轰炸了。再次感谢你们来到这里。你们为我们的第一组双人嘉宾设定了很高的标准。再次感谢，大家再见。

---

### [01:22:24] Aarthi Ramamurthy

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:22:24] Sriram Krishnan

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:22:27] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify or your favorite podcast app. Also, please consider giving us a rating or a leaving review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这集节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。