# Tamar Yehoshua - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Tamar Yehoshua.

---

### [00:00:00] Tamar Yehoshua

**English:**
Make sure you go somewhere where you have a good engineering partner. Because if you have great ideas of what to build but you can't get them built, then you go nowhere. So that has to be part of your evaluation criteria that you meet and value your engineering partner before you join. And then I think what's really important is that you're aligned. You understand your roles and responsibilities and where you're going to divide and conquer and where you're going to be aligned. You don't want any of this ... Like people in the organization, they ask mom, they asked dad and they got different opinions and playing one against the other. That doesn't work.

**中文翻译:**
一定要去一个能让你拥有优秀工程合作伙伴的地方。因为如果你对要构建的东西有伟大的想法，但却无法把它们造出来，那你将一事无成。所以，在你加入之前，会见并评估你的工程合作伙伴必须成为你衡量标准的一部分。此外，我认为非常重要的一点是你们要达成共识（aligned）。你们要明确各自的角色和职责，知道哪里需要分工协作（divide and conquer），哪里需要保持一致。你不希望看到这种情况：组织里的人去问“妈妈”，又去问“爸爸”，结果得到不同的意见，然后让他们互相博弈。那是行不通的。

---

### [00:00:36] Lenny Rachitsky

**English:**
Today, my guest is Tamar Yehoshua. Tamar is currently president of product and technology at Glean, one of the most successful enterprise AI companies out there right now. Prior to joining Glean, Tamar was chief product officer at Slack for four years where she led product design and research as the company scaled 10Xed their revenue, went through IPO and then got bought by Salesforce. Tamar also led product and engineering teams at Google, where for many years she was responsible for the Google search experience. She also spent five years at Amazon as director of engineering and vice president at A9.com. She was also a venture partner at IVP and has been on board of directors for ServiceNow, Snyk, RetailMeNot, and Yext. In our conversation, we get into all kinds of juicy advice, including why companies don't have to be run well to win, why you don't need a career plan, the two habits she credits most for helping her succeed throughout her career, what she learned from Jeff Bezos and Stewart Butterfield and Marc Benioff, how to build stronger cross-functional relationships and a bunch of advice on AI including how it will likely change your jobs, examples of how she and her colleagues are already using AI to be more productive in their work and what she's learned about building AI-based products that are non-deterministic and can be very unpredictable.

**中文翻译:**
今天的嘉宾是 Tamar Yehoshua。Tamar 目前是 Glean 的产品与技术总裁，Glean 是目前最成功的企业级 AI 公司之一。在加入 Glean 之前，Tamar 在 Slack 担任了四年的首席产品官（CPO），期间她领导了产品设计和研究，见证了公司收入增长 10 倍、完成 IPO 并最终被 Salesforce 收购。Tamar 还曾在 Google 领导产品和工程团队，多年来负责 Google 搜索体验。她还在 Amazon 工作了五年，担任工程总监以及 A9.com 的副总裁。她曾是 IVP 的风险合伙人，并担任过 ServiceNow、Snyk、RetailMeNot 和 Yext 的董事会成员。在我们的对话中，我们探讨了各种干货建议，包括为什么公司不一定要管理得井井有条也能获胜、为什么你不需要职业规划、她认为对她职业生涯成功贡献最大的两个习惯、她从杰夫·贝佐斯（Jeff Bezos）、斯图尔特·巴特菲尔德（Stewart Butterfield）和马克·贝尼奥夫（Marc Benioff）身上学到了什么、如何建立更强大的跨职能关系，以及大量关于 AI 的建议，包括 AI 将如何改变你的工作、她和同事如何利用 AI 提高工作效率的实例，以及她在构建基于 AI 的、具有非确定性（non-deterministic）且难以预测的产品方面的经验。

---

### [00:01:51] Lenny Rachitsky

**English:**
This episode is for anyone looking to level up as a leader and get a better sense of how AI will change your job. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you Tamar Yehoshua. Tamar, thank you so much for being here and welcome to the podcast.

**中文翻译:**
这一集适合任何想要提升领导力并深入了解 AI 将如何改变工作的人。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对播客有很大帮助。现在，让我们欢迎 Tamar Yehoshua。Tamar，非常感谢你能来，欢迎来到本播客。

---

### [00:02:15] Tamar Yehoshua

**English:**
Thank you so much for having me.

**中文翻译:**
非常感谢邀请我。

---

### [00:02:17] Lenny Rachitsky

**English:**
I've had so many people recommend you coming on this podcast. I'm really happy that we're finally doing this. I want to start with a question that I've started to ask people who have had extraordinarily successful careers, which you've had. So let me ask you, what are one or two specific skills or mindsets or habits that you think most contributed to your success during the course of your career that you think might be helpful to people who are trying to figure out how to accelerate their career or just be more successful in their career?

**中文翻译:**
有很多人向我推荐邀请你来。我很高兴我们终于成行了。我想从一个问题开始，这个问题我最近开始问那些事业极其成功的人，而你就是其中之一。那么我想问，在你职业生涯中，你认为哪一两个具体的技能、心态或习惯对你的成功贡献最大，且你认为对那些想要加速职业发展或在事业上更成功的人会有所帮助？

---

### [00:02:47] Tamar Yehoshua

**English:**
One of the things that I think is overlooked is do a really good job at whatever your job is at that point. People have a tendency ... Especially product managers are very ambitious and they want to get to the next level and they're always eyeing the next job, but you're not going to get the next job unless you do really well at the job that you're in. Knock it out of the park. However simple, however easy it may be to you, do a great job. And in tech jobs, there's table stakes. There's table stakes of you need to be technical, you need to know the latest technology, you need to understand your product, the product you're working on. No matter what your role is. You have to understand it deeply. You need to understand metrics. So especially product managers have a wide breadth of things that they need to understand. So those are a given. You need to do that.

**中文翻译:**
我认为被忽视的一点是：无论你当时在做什么工作，都要把它做得非常出色。人们往往……尤其是产品经理，非常有野心，想要晋升到下一个级别，总是盯着下一份工作。但除非你把当下的工作做得非常好，否则你无法获得下一份工作。要把它做到极致（Knock it out of the park）。无论它对你来说多么简单、多么容易，都要做得出色。在科技行业，有一些“准入门槛”（table stakes）。比如你需要懂技术，需要了解最新的技术，需要了解你的产品，也就是你正在负责的产品。无论你的角色是什么，你都必须深入理解它。你还需要理解指标（metrics）。特别是产品经理，需要理解的东西非常广泛。这些都是前提，你必须做到。

---

### [00:03:40] Lenny Rachitsky (Ad Segment - Explo)

**English:**
This episode is brought to you by Explo, a game changer for customer facing analytics and data reporting... [Ad content omitted for brevity but translated below]

**中文翻译:**
本集节目由 Explo 赞助，它是面向客户的分析和数据报告领域的游戏规则改变者。你的用户是否渴望在你的产品中看到更多的仪表盘、报告和分析？你是否厌倦了尝试自己构建这些功能？作为产品负责人，你可能在路线图中安排了这些需求，但权衡优先级确实很困难。从头开始构建分析功能既耗时又昂贵，而且极具挑战性。试试 Explo 吧。Explo 是一个完全白标（white labeled）的嵌入式分析解决方案，完全以用户为中心设计。上手非常简单。Explo 可以连接到任何关系型数据库或数据仓库，凭借其低代码功能，你可以在几分钟内构建并设计仪表盘样式。准备就绪后，只需通过一小段代码将仪表盘或报告嵌入到你的应用程序中即可。最棒的是，你的最终用户可以使用 Explo 的 AI 功能生成自己的报告和仪表盘，从而减少对支持团队的数据请求。在几天内即可构建并嵌入完整的白标分析体验。在 explo.co/lenny 免费试用。

---

### [00:04:52] Lenny Rachitsky (Ad Segment - Sprig)

**English:**
This episode is brought to you by Sprig. What if product teams knew exactly what to build to reach their goals?... [Ad content omitted for brevity but translated below]

**中文翻译:**
本集节目由 Sprig 赞助。如果产品团队确切地知道该构建什么来实现目标，会怎样？从提高转化率到增强参与度，这些挑战都需要对用户有深入的了解，而这仅仅依靠产品分析是无法获得的。认识一下 Sprig，这是一个产品体验平台，它能生成 AI 驱动的机会，持续大规模地改进你的产品。首先，Sprig 通过热力图、录屏、调查和反馈研究实时捕捉你的产品体验，然后 Sprig 行业领先的 AI 会立即分析所有产品体验数据，生成实时洞察。Sprig AI 甚至更进一步，提供可操作的产品建议，以推动收入、留存和用户满意度。加入 Figma 和 Notion 的产品团队，大规模发现 AI 驱动的产品机会。访问 sprig.com/lenny 预约演示并获取 75 美元的礼品卡。

---

### [00:05:55] Tamar Yehoshua

**English:**
So now the question is the difference in leadership and executive roles and when you're getting there. So how do you start transitioning? So after you've done a great job at everything and you understand the core skills that you need, another thing you really need to know is understanding people and motivations. And when you're building products, you have to understand why does somebody want to use your product? What problem are they solving? Why do they want to click on that button? What's going to make them feel good when they click on it? What's going to give them delight and what's also going to make them feel bad and frustrated and what do they not want to do? So you need to understand motivations in people for building products and for building teams and organizations. So just like why does somebody want to click on a button, why does somebody want to join your team? Why do they want to work hard? What are they trying to accomplish? What's the goal for their career? So you have to be able to read people, ask lots of questions to understand them. And I'll say one thing that really helped me, this is a strange segue, but my father was a psychiatrist and when I was growing up, we would have family occasions, go to events, whatever, and afterwards in the car ride back, he would always give his perspective of analyzing what happened at the event. What this person was thinking. Why did they say this? And then he would quiz me of, "Why do you think they did that?" And it was really interesting because it taught me to see the whole room. To see how people react. Like Lenny, if you say something and somebody else is there, look at the other person. What's their face saying? You can understand so much if you're paying attention. So I think when you want to build for people and lead organizations, it is about the people and understanding them and motivating them.

**中文翻译:**
所以现在的问题是领导层和高管职位的区别，以及当你达到那个阶段时该怎么办。你如何开始转型？当你把每件事都做得很好，并掌握了所需的核心技能后，另一件你真正需要了解的事情是理解人和动机。当你构建产品时，你必须理解：为什么有人想用你的产品？他们在解决什么问题？他们为什么要点击那个按钮？点击它时什么会让他们感觉良好？什么会给他们带来愉悦感，什么又会让他们感到糟糕和沮丧，以及他们不想做什么？因此，为了构建产品、团队和组织，你需要理解人的动机。就像理解为什么有人想点一个按钮一样，你也要理解为什么有人想加入你的团队？他们为什么要努力工作？他们想要达成什么目标？他们的职业目标是什么？所以你必须能够洞察人心，通过大量提问来理解他们。我要说一件对我帮助很大的事，这可能是一个奇怪的转折，但我父亲是一名精神科医生。在我成长的过程中，我们会参加家庭聚会、活动等等，之后在回程的车里，他总是会给出他的分析视角，分析活动中发生了什么，那个人在想什么，为什么他们会那样说。然后他会考我：“你觉得他们为什么要那样做？”这非常有趣，因为它教会了我观察整个房间，观察人们的反应。比如 Lenny，如果你说了什么，而旁边还有别人，看看另一个人，他们的表情在表达什么？如果你留心观察，你能理解很多东西。所以我认为，当你想要为人们构建产品并领导组织时，核心在于人，在于理解他们并激励他们。

---

### [00:07:58] Lenny Rachitsky

**English:**
I love this advice. I feel like we could do a whole podcast on just this topic. So on this last point about understanding people, is there an example of this in either a product you built of just like, "Oh, here's something I noticed about someone using Slack or Google or Amazon that changed the way I think about building this specific feature."?

**中文翻译:**
我非常喜欢这个建议。我觉得我们可以专门就这个话题做一期播客。关于理解人这一点，在你构建的产品中是否有这样的例子？比如，“哦，这是我在某人使用 Slack、Google 或 Amazon 时注意到的细节，它改变了我对构建这个特定功能的看法。”

---

### [00:08:17] Tamar Yehoshua

**English:**
One of the things that I caution product managers about is that you don't want to be too overly reliant on metrics and you want to also have an intuition. You want product managers who understand intuitively their customers and their product and sometimes you'll make decisions because you just know it's the right thing to do because it feels right and it usually is right if you understand your product well enough. How do you get good at it? Ask a lot of questions. Don't assume you know. Marc Benioff would always say, "Have a beginner's mind. Go in assuming that you know nothing and listen to your customers, listen to the people." Because I also see this as you're building a feature and you think it's the best thing. Because of course everyone's going to want it because you worked on it and you're going to put it front and center in the interface where everybody's going to see it. Well, no, you got to earn that right. And that is another thing that people do is they want the thing they worked on to be right there, but it might not be the most important thing that a person needs at that point. So have perspective. Have perspective of what your users are actually trying to achieve.

**中文翻译:**
我提醒产品经理的一点是：你不能过度依赖指标，你还需要有直觉。你需要那些能凭直觉理解客户和产品经理，有时你会做决定仅仅是因为你知道那是正确的事，因为感觉是对的。如果你足够了解你的产品，这种直觉通常是正确的。如何变得擅长此道？多问问题。不要假设你已经知道了。马克·贝尼奥夫（Marc Benioff）总是说：“保持初心（beginner's mind）。带着‘我一无所知’的假设去倾听你的客户，倾听人们的声音。”因为我也见过这种情况：你正在开发一个功能，你觉得它是最棒的，因为是你开发的，所以理所当然地认为每个人都会想要它，于是你把它放在界面最显眼的位置，让所有人都能看到。不，你必须赢得那个权利。这是人们常犯的另一个错误：他们想把自己做的东西放在最前面，但那可能并不是用户在那一刻最需要的东西。所以要有全局观，要看清用户真正想要达成的是什么。

---

### [00:09:33] Lenny Rachitsky

**English:**
Going back to your first point about doing a great job at the job you have, I imagine some people hear this and the advice is do a great job at the job you're already doing, and they may feel like they are, and there's other reasons they aren't being promoted. Is there an example from your career or a story you could tell of just like to clarify what doing a great job look like where it's not just like I hit my goals. It's like, here's what it looks like. Here's how you actually get ahead.

**中文翻译:**
回到你说的第一点，即做好当下的工作。我想有些人听到“做好你正在做的工作”这个建议时，可能会觉得自己已经做得很好了，但因为其他原因没被提拔。在你的职业生涯中，有没有一个例子或故事可以澄清“出色完成工作”到底是什么样子的？它不仅仅是“我达成了目标”，而是更深层次的东西。真正的脱颖而出是什么样的？

---

### [00:10:00] Tamar Yehoshua

**English:**
Are you helping the business move forward? So it's not about I achieve what I was asked to do, but did you build something that people actually used? It's not about just launching something and did you do the right thing for the company? And that is different. It's a different mindset. Did you enable the entire organization to be more productive despite you? I remember very early in my career I was working as an engineer and I was offered a job to manage a team that was across different programs. I took a vacation, I came back and I said, "I don't think this team should exist." It was my first management job and I wanted to be a manager. And I said, "Here's why I don't think that this team should exist. It's not the right thing for the company. It's not going to be productive." And my manager was so stunned. He was like, "Wait. You're saying no?" I'm like, "Yeah, because here's how you should organize it." And then he's like, "You're right, and I'll find you something else," and he did.

**中文翻译:**
你是否在推动业务向前发展？所以这不在于“我完成了被要求做的事”，而在于“你是否构建了人们真正会用的东西？”这不仅仅是发布了某个功能，而是“你是否为公司做了正确的事？”这是一种不同的心态。你是否让整个组织变得更高效，哪怕没有你也能行？我记得职业生涯早期，我当时是一名工程师，有人给我提供了一个管理跨不同项目团队的职位。我休了个假回来后说：“我认为这个团队不应该存在。”那是我的第一份管理工作，我也很想当经理。但我说：“这就是为什么我认为这个团队不该存在的原因。这对公司来说不是正确的事，也不会有产出。”我的经理惊呆了，他说：“等等，你是说不干？”我说：“是的，因为你应该这样组织它。”然后他说：“你是对的，我会给你找点别的活儿。”他确实找了。

---

### [00:11:15] Lenny Rachitsky

**English:**
If I were to put this into one word, it's impact. Drive impact.

**中文翻译:**
如果用一个词来概括，那就是“影响力”（impact）。驱动影响力。

---

### [00:11:18] Tamar Yehoshua

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:11:19] Lenny Rachitsky

**English:**
Amazing. Okay. Going in a different direction, we were chatting before we started recording this and something that you shared with me, and some people may be really surprised to hear this, but I completely agree with this take, is that you don't need to be a well-run business to win. I've seen this myself. I'd love to hear your insights here and especially where you notice this. What parts of your career noticed this to be true?

**中文翻译:**
太棒了。好，换个方向。我们在录音前聊天时，你跟我分享了一些观点，有些人听到可能会很惊讶，但我完全同意：你不需要成为一家管理良好的公司也能获胜。我也亲眼见过这种情况。我很想听听你的见解，尤其是你在哪里观察到这一点的？你职业生涯的哪些阶段让你发现这是事实？

---

### [00:11:45] Tamar Yehoshua

**English:**
I love working at well-run companies. It's more fun, your people are happier. I like running a well-run team, so I aspire to have a very well run team and to work at a well run company. But what I've seen is when a company isn't well run like IT isn't working, marketing is broken, there are not enough people in HR, there's a lot of turnover. All of these things I've seen that they're not correlated to the company being successful. So I can think of a couple examples right now of companies I know ... Not Glean, where I'm working today. Where there's high executive turnover. Where people get yelled at. There are lots of people fired. There's reorgs all the time. People I talk to are super unhappy, but the numbers are amazing. They're growing like crazy. And the opposite sit is also true. I can think of one company I know really well, amazing, CEO, well run, well oiled machine, everything. Hired good executives and they flat lined. So you just see it. You see it over and over again and people get very upset about these things that aren't working. And one of the things that I try and do is give a perspective of what matters and what doesn't. And it might even be to the sales team because you get all these requests for features all the time. If you did every single one, it would be impossible. Even if you did, 80, 90% of them won't matter for the success of the company. But then there are some that really matter. So what are the things that really matter? We always talk about product market fit. Nobody really knows what product market fit is. Everybody has a different explanation, but it means people want to use your product. That they're clamoring for it. So you've built something that people value and that people value and that solves a problem for them, but that's also not good enough. You need to build a great product, but you also have to have distribution and you need to have a sales team that works. And you have to have enough money in the bank to get there. So those are probably the things that are the most important. I might be missing something. And then within each of those, there's the things that really mattered and there's so many features that we built at Slack that were the most important features ever that failed and nobody used so it clearly didn't have an impact. And you can see that in retrospect, but I think after being at multiple different big companies and small companies, I have that perspective of let's just make sure that we do the right things and don't get too worked up about all the things that are broken because every startup has so many things that are broken.

**中文翻译:**
我喜欢在管理良好的公司工作。那更有趣，员工更快乐。我也喜欢管理一支高效的团队，所以我渴望拥有一支管理良好的团队并在管理良好的公司工作。但我所看到的是，当一家公司管理不善时——比如 IT 系统不行、营销一团糟、HR 人手不足、人员流动率很高——我发现所有这些事情与公司的成功并不相关。我现在就能想到几个例子……不是我现在的公司 Glean。在那些公司里，高管变动频繁，员工会被吼，很多人被解雇，一直在重组。我交流过的人都非常不开心，但数据却惊人地好，增长极其疯狂。反之亦然，我认识一家公司，CEO 很棒，管理得像一台精密运转的机器，雇佣了优秀的高管，但业绩却停滞不前。所以你会反复看到这种情况，人们会因为那些运行不畅的事情而感到沮丧。我尝试做的一件事是提供一个视角，说明什么是重要的，什么是不重要的。这甚至适用于销售团队，因为你会一直收到各种功能请求。如果你每一个都做，那是不可能的。即使你做了，其中 80% 到 90% 对公司的成功也毫无影响。但有些功能确实至关重要。那么，真正重要的是什么？我们总在谈论“产品市场匹配”（PMF）。没人真正知道 PMF 是什么，每个人都有不同的解释，但它的核心意思是人们想用你的产品，他们渴望得到它。你构建了人们看重的东西，解决了他们的问题。但这还不够。你需要构建伟大的产品，但你还必须有分销渠道（distribution），需要一支有效的销售团队，而且银行里得有足够的钱支撑你走到那一步。这些可能是最重要的。我也许漏掉了一些。在这些大项中，还有些细节至关重要。我们在 Slack 构建过很多号称“史上最重要”的功能，结果失败了，没人用，显然没有产生影响力。回过头看你能看清这一点。但在经历过多家大公司和创业公司后，我有了这种视角：让我们确保做正确的事，不要对那些出故障的事情太焦虑，因为每家创业公司都有无数出故障的地方。

---

### [00:14:29] Lenny Rachitsky

**English:**
So I think a really interesting insight here is that if you're working at a company that is just chaotic and it feels like we don't know what we're doing, I don't know how this thing is running, I don't know how this will continue to be successful, your experience is it ... Is it that most of the successful companies you've been at are just chaotic internally and aren't incredibly run and that's normal, that's very typical?

**中文翻译:**
所以这里有一个非常有趣的洞察：如果你在一家混乱的公司工作，感觉“我们不知道自己在做什么”、“我不知道这玩意儿是怎么运转的”、“我不知道这怎么能持续成功”，根据你的经验……是不是你待过的大多数成功公司内部其实都很混乱，管理得并不出色，而这其实是常态，非常典型？

---

### [00:14:51] Tamar Yehoshua

**English:**
Until they get to a certain scale. Now, once you reach a certain scale and you've already conquered the market, then you need to be well run. Then you bring in professional managers and things are about the cost and executing and getting all the ... Once you get to over 5,000 people or 10,000 people, you got to have things that ... Then you're a growth engine. You have to know what phase you're in and what's important at that phase. So it isn't that at every phase, chaos is okay, and also some chaos is okay and some chaos is not okay. If you're changing your strategy all the time and you're changing your direction and you're changing projects on people all the time so that they can't actually achieve anything ... So this is again, so you can't simplify it that some chaos is okay and some isn't. And also some chaos is right for you as a person. There are some really great companies I would never work at because they don't fit me. They're not a company I would enjoy going to work in the morning or they're not aligned with what I'm good at. So just because a company is doing well, if the chaos is chaos and something that's going to make you upset and unhappy don't work there.

**中文翻译:**
直到它们达到一定的规模。一旦你达到一定规模并占领了市场，你就需要管理得井井有条。那时你会引入职业经理人，关注成本、执行力等等。一旦公司超过 5000 人或 10000 人，你就必须……那时你就是一个增长引擎。你必须知道自己处于哪个阶段，以及该阶段什么最重要。所以并不是说在每个阶段混乱都是可以接受的，而且有些混乱可以接受，有些则不行。如果你一直在改变战略、改变方向、频繁更换员工的项目，导致他们实际上什么也做不成……所以这不能简单化。此外，某些混乱可能适合你，而另一些则不适合。有些非常优秀的公司我永远不会去，因为它们不适合我。它们不是那种让我早上乐意去上班的公司，或者它们与我的擅长领域不匹配。所以，仅仅因为一家公司业绩好，如果那种混乱让你感到沮丧和不快乐，那就不要在那里工作。

---

### [00:16:11] Lenny Rachitsky

**English:**
Is there a correlation there? Just like companies that have strong product market fit, things are just breaking as they're going through hyper growth? Just thoughts on why this is the case.

**中文翻译:**
这其中有相关性吗？是不是那些具有强大 PMF 的公司，在经历超速增长（hyper growth）时，东西就是会不断崩坏？关于为什么会这样，你有什么想法？

---

### [00:16:21] Tamar Yehoshua

**English:**
A lot of it is that because if you are in hyper growth, you've got customers coming at a really fast pace, you're growing your company really quickly and the number of employees and it's just really hard to keep up. Because things in the infrastructure break, things in the communication breakdown. You've got at any given point 50% of the company has been there less than six months. But you have to grow really fast because once you hit product market fit, if you don't, then your growth will stop. So if you're suddenly growing, especially if you're an enterprise company, you have to have salespeople, if you're a consumer company or systems have to keep running as you scale. And look at companies like MySpace, well, they died because their product got too slow. And so some companies have initial product market fit and then they don't keep up. So I do think a lot of it is it's very hard to grow that fast. And so things really do start breaking, but then once you get all the right leadership in place, processes in place, then it starts to get better. So it goes through ups and downs in level of chaos.

**中文翻译:**
很大程度上是因为如果你处于超速增长中，客户涌入的速度极快，公司规模和员工人数增长也极快，很难跟上节奏。基础设施会出问题，沟通会断层。在任何时间点，公司可能有 50% 的人入职不到六个月。但你必须快速增长，因为一旦达到 PMF，如果你不快跑，增长就会停止。如果你突然增长，特别是作为一家企业级公司，你必须配备销售人员；如果你是消费级公司，系统必须在扩张时保持运行。看看像 MySpace 这样的公司，它们倒闭是因为产品变得太慢了。有些公司最初有 PMF，但后来没跟上。所以我认为很大程度上是因为增长太快确实很难，东西确实会开始崩坏。但一旦你有了合适的领导层和流程，情况就会好转。所以混乱程度会经历起伏。

---

### [00:17:28] Lenny Rachitsky

**English:**
There's one takeaway here that product market fit solves a lot of problems. Strong product market fit.

**中文翻译:**
这里有一个结论：PMF 能解决很多问题。强大的 PMF。

---

### [00:17:33] Tamar Yehoshua

**English:**
Well, no product market fit is a death sentence. I would say it more like that. If you built a product that people aren't really excited to use, then you don't have a company because it's very hard to do that unless you have distribution machine and then you catch up over time. But we will not name companies like that. So there are other ways of doing it, but yeah, that is the most important thing.

**中文翻译:**
嗯，没有 PMF 就是死刑。我会这么说。如果你构建了一个人们并不兴奋去使用的产品，那你就不算拥有一家公司，因为这很难维持，除非你有强大的分销机器，然后随着时间推移慢慢赶上。但我们就不点名那样的公司了。所以还有其他方法，但没错，PMF 是最重要的。

---

### [00:18:00] Lenny Rachitsky

**English:**
Yeah. I will say during my experience at Airbnb, I absolutely saw this. It was just nonstop chaos. And I always felt like, well, how is this continuing to operate and succeed? Things are just out of control. Everything's changing every six months. I don't know what's happening here. And I think a lesson here is just that's normal for a hyper growth business that has strong product market fit. But again, not a good excuse to just allow chaos. And it's not like chaos means success, right?

**中文翻译:**
是的。我在 Airbnb 的经历中绝对看到了这一点。那是持续不断的混乱。我总在想：这玩意儿是怎么维持运营并成功的？事情完全失控，每六个月一切都在变，我不知道发生了什么。我认为这里的教训是，对于一家拥有强大 PMF 的超速增长企业来说，这很正常。但同样，这并不是允许混乱的借口。混乱并不等同于成功，对吧？

---

### [00:18:30] Tamar Yehoshua

**English:**
And it's not a good excuse to not have an organization that's functioning. You should still strive to have an organization that's functioning and keep people happy and motivated and all that.

**中文翻译:**
而且这也不是组织功能失调的借口。你仍然应该努力让组织正常运转，让员工保持快乐和动力。

---

### [00:18:39] Lenny Rachitsky

**English:**
Great. Okay. Another maybe contrarian opinion that you hold along the career track is that you don't need to plan your career. I also 100% agree with this. I had no plan for my career. I never knew where the hell I was going to go. I never had this vision of here's what I want to do. I just followed things that were pulling me and things that seemed interesting. I love that you also tell people this. I'd love to hear your insights here. Especially for someone that's either struggling with their career or just stressed. They don't have a plan or their plan's not working the way they wanted it to.

**中文翻译:**
太好了。关于职业路径，你还有一个可能比较反直觉的观点：你不需要规划职业生涯。我也 100% 同意这一点。我对自己职业生涯没有任何规划，从来不知道自己到底要去哪儿，也没有“这就是我想做的事”这种愿景。我只是追随那些吸引我的、看起来有趣的事情。我很喜欢你也告诉人们这一点。我很想听听你的见解，特别是对于那些在职业生涯中挣扎或感到压力的人，他们可能没有计划，或者计划没有按预期进行。

---

### [00:19:12] Tamar Yehoshua

**English:**
Really recently I was talking to somebody in their twenties who was asking me for career advice. Should I be a product manager, et cetera. And I'm trying to put together my five-year plan and I said, "I never had a five-year plan." So to be clear, some people need that. That's the kind of people they are. They want the planning. I said, "It's great if you want that, but I never had it." And the person I was talking to just relaxed and they're like, "Oh my God, that's so great to hear because I have no idea what I want to do in five years." I'm like, "I still have no idea what I want to do in five years. I've never had an idea what I want to do in five years." Early in your career you have a lot more angst about it because the forks in the road are more significant because they can go, do I go get an MBA or do I go work for somebody? Do I be a product manager or an engineer? And those really take you in very different paths. And I meet a lot of kids in their ... I shouldn't call them kids. My kids are my kids' friends. But a lot of people who are younger in their career who are struggling with this a little bit. So what I believe, and I've always believed is that you follow people. You learn the most from people. I don't look for domains. Some people have a domain, like I'm super interested in climate or whatever and they really want to work in that area and that's fine so maybe within that area. But you follow people who are the best at what they do. So it's not good enough to follow somebody who you like. You want to follow somebody who's either the best product thinker or the best engineer or the best salesperson. And so that you will learn the skill of how to be the best at that. So you follow people where you're going to learn the most. And a way to do that also is you look at where the great people are going. So you want to go to companies where there's also a nexus of great people because they together will do great things. And even if the company fails or succeeds, but not as much as you'd like, you still have those connections. Everybody talks about the PayPal Mafia and how they've gone on to do things. I was super lucky to be at Google for so many years and I spent a lot of time with Googlers that I met and that are all working in different companies now because you build those relationships by working together. So if you follow people and where you're going to learn the most and you go step by step, I think that's a great way of progressing in your career.

**中文翻译:**
就在最近，我跟一个二十多岁的人聊天，他向我咨询职业建议：我该做产品经理吗，等等。他说他正试图制定五年计划，我说：“我从来没有过五年计划。”明确地说，有些人确实需要计划，那是他们的性格。我说：“如果你想要计划，那很好，但我从来没有过。”那个人听完立刻放松了，他说：“天哪，听到这个太好了，因为我完全不知道五年后我想做什么。”我说：“我现在也还是不知道五年后我想做什么，从来都不知道。”在职业生涯早期，你会有更多的焦虑，因为路口的选择更重大：我是去读 MBA 还是去给别人打工？我是做产品经理还是工程师？这些选择会带你走向完全不同的道路。我遇到很多年轻人……我不该叫他们孩子，他们是我孩子的同龄人。很多职场新人都在为此纠结。我一直相信的是：追随人。你从人身上学到的最多。我不看领域。有些人有特定领域，比如对气候变化感兴趣，想在那个领域工作，那没问题。但你要追随那些在各自领域做得最好的人。仅仅追随你喜欢的人是不够的，你要追随那些最顶尖的产品思想家、最顶尖的工程师或最顶尖的销售人员。这样你才能学会如何成为那个领域的顶尖人才。所以，去追随那些能让你学到最多东西的人。另一种方法是看优秀的人都去了哪里。你想去那些优秀人才聚集的公司，因为他们在一起会成就伟业。即使公司失败了，或者没有达到预期的成功，你仍然拥有那些人脉。大家都谈论“PayPal 黑手党”以及他们后来的成就。我很幸运在 Google 待了这么多年，我和当时结识的 Google 同事保持着紧密联系，他们现在都在不同的公司工作，这些关系是通过共同工作建立的。所以，如果你追随人，去能学到最多东西的地方，一步一个脚印，我认为这是职业发展的绝佳方式。

---

### [00:21:53] Lenny Rachitsky

**English:**
That's such tactical advice. And I've seen this work for a lot of people that just go where their favorite former employees work. And not favorite to your point, but the people that they most respect and have been most impressed by. And I think it's such an easy thing to do. It's a really easy heuristic for understanding where to go. There's something Marc Andreessen once shared that I'm reminded of when you say this. There's a term for this, I forget the actual term, but there's certain companies have this gravitational pull where they are acquiring all the best talent. They're currently the gravity in the space and everyone awesome is going there. And you have to, as a company, know you're one of those companies or you're the opposite. You're losing all the people and they're all going to this other company. I guess any thoughts on that?

**中文翻译:**
这建议非常有实操性。我见过很多人就是跟着他们最敬佩的前同事走。不是因为私交好，而是因为对方是他们最尊重、最令他们印象深刻的人。我认为这很容易做到，是判断去向的一个非常简单的启发式方法。你这么说让我想起了马克·安德森（Marc Andreessen）分享过的一些东西。有个专门的术语，我忘了具体叫什么，但某些公司确实有这种“引力”，它们能吸引所有顶尖人才。它们是该领域的引力中心，所有厉害的人都往那儿跑。作为一家公司，你必须清楚自己是引力中心，还是反面——正在流失人才，而他们都去了另一家公司。对此你有什么看法？

---

### [00:22:43] Tamar Yehoshua

**English:**
Yeah. And it's really bad when you don't have a gravitational pull. It's super hard. I would say that one thing that if you're a manager, I always advise managers, go somewhere where you can recruit. I got a piece of advice from a friend that I thought was amazing advice as a leader. She said to me, "Take a job where if you hire people, it's going to make their careers." I was like, "Whoa." Because I was getting offers for some turnaround jobs. And if you think you can turn around, great. But if you're going to hire the best people, you want to make sure that it's going to be a good place for them and that they're going to learn and they're going to grow. And so you want to do right by them. And you really earnestly want to say you can make your career by coming here. And I thought that gave such a higher bar for every job I was looking at as a leader that I thought it was just amazing advice. And then on the flip side, on the negative side, some people are putting too much emphasis on where will I get a big financial return? And I've found that financial returns are the hardest to predict. You know who's good. You know who you want to work with. You can predict where you're going to learn. Because even if a company fails, you learn a lot. But predicting financial success is so hard because you don't know what's going to happen with the market, with the world, with crypto, and Meta AI. And people who do that and say ... I had one person say, "I took this job because I'm a mercenary. They just paid me a ton." Did not work out for him. And I feel really bad when people do that, but I think that it's a dangerous thing to do.

**中文翻译:**
是的，没有引力是非常糟糕的，处境会非常艰难。如果你是一名管理者，我总是建议：去一个你能招到人的地方。我从一位朋友那里得到过一条作为领导者的绝佳建议。她对我说：“找一份这样的工作：如果你雇佣了别人，这份工作能成就他们的职业生涯。”我当时心想：“哇。”因为当时我收到了一些“扭转局面型”（turnaround）工作的邀约。如果你觉得你能扭转乾坤，那很好。但如果你要雇佣最优秀的人，你要确保这对他们来说是个好地方，他们能学习、能成长。你要对得起他们。你要能真诚地说：“来这里能成就你的事业。”我认为这为我作为领导者寻找的每一份工作设定了更高的标准，这建议太棒了。另一方面，从负面来看，有些人太看重“哪里能给我巨大的财务回报”。我发现财务回报是最难预测的。你知道谁厉害，你知道想和谁共事，你能预测在哪里能学到东西——因为即使公司失败了，你也能学到很多。但预测财务上的成功太难了，因为你不知道市场、世界、加密货币或 Meta AI 会发生什么。那些说“我接这份工作是因为我是个雇佣兵，他们给的钱多”的人，我见过一个，结果并不好。当人们这样做时我感到很遗憾，我认为这很危险。

---

### [00:24:40] Lenny Rachitsky

**English:**
I imagine some people hearing this advice are going to feel like, "I'm not going to get a job at OpenAI or Glean or other awesome companies that everyone wants to go work at." Any advice to those folks?

**中文翻译:**
我想有些人听到这个建议会觉得：“我又进不去 OpenAI 或 Glean 这种人人都想去的牛逼公司。”对这些人你有什么建议吗？

---

### [00:24:52] Tamar Yehoshua

**English:**
There's lots of good companies and there's lots of smart people. You don't have to be at the top brand. And if you go somewhere where you're going to learn and it's going to get you there. I made mistakes. I went to some companies, multiple companies that failed or stopped growing and didn't do well or didn't have all the right people. Careers you don't make every step is to the right place. You remember in what you cited, all the companies I went to that did well, you left out all the ones that I went to that didn't do well. And so then people will assume that every time I made a job change, it was to a company that did well. No. That was not the case. So if you focus on that learning bit, you will get there. And there are lots of paths. There isn't just the OpenAI or Glean or Anthropic.

**中文翻译:**
有很多好公司，也有很多聪明人。你不必非得在顶级品牌工作。只要你去一个能学到东西的地方，它最终会带你到达目的地。我也犯过错，去过几家倒闭或停止增长、表现不佳、或者人才配置不对的公司。职业生涯中，并不是每一步都能走对。你刚才提到的都是我待过的成功的公司，你漏掉了那些不成功的。所以人们会假设我每次跳槽都去了成功的公司。不，事实并非如此。所以，如果你专注于学习，你最终会成功的。路有很多条，不只有 OpenAI、Glean 或 Anthropic。

---

### [00:25:42] Lenny Rachitsky

**English:**
Awesome. And again, I love how tactical this is. If someone is trying to figure out where to go work if they're unhappy in their current job or don't have a job right now is just make a list of the people you most respect that are the best at the thing they do, see where they work and there's your list of companies to potentially go after. There's a lot of benefits to this as you shared. It's not just helping you pick the place to work, it's the network. It'll level you up. Is there anything else along those lines that is helpful for people to think about why this is a really good strategy?

**中文翻译:**
太棒了。我再次感叹这建议的实操性。如果有人对现状不满或正在找工作，只需列出你最尊敬、在各自领域最顶尖的人，看看他们在哪里工作，那就是你的目标公司清单。正如你分享的，这样做有很多好处：不仅能帮你选公司，还能建立人脉，提升你的水平。关于为什么这是一个好策略，还有什么值得思考的吗？

---

### [00:26:10] Tamar Yehoshua

**English:**
Skills can't be taken away. A company can fail, but if you learn a skill, you will always have that skill.

**中文翻译:**
技能是带不走的。公司可能会倒闭，但如果你学会了一项技能，它永远属于你。

---

### [00:26:15] Lenny Rachitsky

**English:**
I love that. And I've totally seen this to work, so I really love that you're focusing on this advice. You've mentioned places you've worked and folks you've worked with. You worked with folks like Jeff Bezos, Stewart Butterfield, some of the top product thinkers, leaders in the world. So let me just ask, what's one thing you learned from Jeff Bezos and Stewart Butterfield?

**中文翻译:**
我喜欢这句话。我确实见过这种策略奏效，所以我很高兴你强调了这一点。你提到了你工作过的地方和合作过的人，比如杰夫·贝佐斯、斯图尔特·巴特菲尔德，这些都是世界上顶尖的产品思想家和领导者。那么我想问，你从贝佐斯和巴特菲尔德身上学到的一件事是什么？

---

### [00:26:37] Tamar Yehoshua

**English:**
Probably can't narrow it down to one, but I'll talk about Bezos first. I was very lucky to join Amazon early when I still ... I had quarterly meetings with Jeff Bezos. And this was before AWS launched, so it was before Amazon was known in the Valley. This is another example. I went there because I went to work for Udi Manbe who started A9 and he was talking to me one night trying to recruit me and he spent two hours on the phone with me telling me how amazing Jeff Bezos was. And this was before there were any books on him. And that really convinced me to go there. So there's a lot written on Bezos. Read his shareholder letters, read the books about him, read Colin Bryar's Working Backwards. The Everything Box I think it's called or The Everything Store.

**中文翻译:**
可能很难只说出一件，但我先说贝佐斯。我很幸运在早期加入 Amazon，那时我每季度还会和贝佐斯开会。那是在 AWS 发布之前，Amazon 在硅谷还没那么出名。这是另一个例子：我去那儿是因为我去为创办 A9 的 Udi Manbe 工作。有一天晚上他试图招募我，在电话里跟我聊了两个小时，告诉我贝佐斯有多了不起。那是还没人写关于贝佐斯的书的时候。这真的说服了我去那里。现在关于贝佐斯的资料很多，读读他的股东信，读读关于他的书，读读 Colin Bryar 的《逆向工作法》（Working Backwards），还有《一网打尽》（The Everything Store）。

---

### [00:27:27] Tamar Yehoshua

**English:**
There's so many good books and there's so much to learn about how he works. So I won't try and cover those things. The things that stood out to me from the meetings I had with him were a couple of things. One, a lot of people have written about these six pagers, so he doesn't believe in PowerPoint. You write a six pager about ... It's like studying for the final exam is writing these six pagers. So you go into the meeting and there's the people around the table, his executive team and him. First he does not speak until everybody around the table speaks. So he goes around to all his leads and said, "What do you think? What do you think? What do you think?" And I'm sitting there like, "I don't care what anyone think. I just want to hear what Bezos thinks." But he wants to make sure that it's a team effort and that he's listening to what everybody in his organization thinks. And he always spoke last. He is by far the smartest person I've ever met in my life. I've worked with a lot of smart people. But his ability to go deep in any domain and nail the core issue, and remember. We would've quarterly meetings and from quarter to quarter he would remember things that he had talked about before and then he would go into the architecture of search and why are you doing it this way or that way? And you're just blown away that he knows that. For me, the biggest takeaway from those meetings was his consistency, which is he had principles that it made it easier for you to operate in his company because you knew what he cared about because he always had these principles. Everything had to be customer driven, everything had to be relevant for the customer. He hated icons. That was just the thing. You had to write what they were because people couldn't figure out what they are. So anytime you showed an icon, he would get annoyed. But you would go in and after a couple of meetings you're like, "Okay. I know what he's going to ask about. I know how he's thinking and I know what his principles are." And I think that consistency enables you to operate a large organization more effectively. And then there's one other thing that I really remember was one of the few really small meetings I was in with him and we were presenting working on a new product, and I was like, "Our competitors have 10 times as many people as we do on this." And he looks at me and he said, "That is your advantage." And then he goes into his talk about how it's a hill and it takes seven years to build a product. You can't look at it in the near term. You have to be in it for the long term. You can be sure I never went in and said, "I need a lot more resources." So that was Bezos.

**中文翻译:**
有很多好书，关于他的工作方式有很多值得学习的地方，我就不一一赘述了。在与他的会议中，有几件事让我印象深刻。第一，很多人写过“六页纸备忘录”（six pagers），他不相信 PowerPoint。写这六页纸就像在为期末考试做准备。开会时，他和他的高管团队围坐在桌旁。首先，在桌旁所有人发言之前，他绝不开口。他会询问所有的负责人：“你怎么看？你怎么看？”我当时坐在那儿想：“我不在乎别人怎么想，我只想听贝佐斯怎么想。”但他想确保这是一种团队努力，他想听取组织中每个人的意见。他总是最后一个发言。他是我这辈子见过最聪明的人，我合作过很多聪明人，但他深入任何领域并直击核心问题的能力，以及他的记忆力，都令人惊叹。我们每季度开一次会，他能记住上季度谈过的事情，然后深入探讨搜索架构，问你为什么要这样做或那样做。你会惊讶于他竟然懂这些。对我来说，从这些会议中得到的最大收获是他的“一致性”（consistency）。他有一套原则，这让你在他的公司里更容易开展工作，因为你知道他看重什么。一切必须以客户为驱动，一切必须对客户有价值。他讨厌图标（icons），这是他的一个怪癖。你必须写出文字说明，因为他觉得人们看不懂图标。所以任何时候你展示图标，他都会不高兴。但开过几次会后，你就会觉得：“好吧，我知道他会问什么，我知道他在想什么，我知道他的原则是什么。”我认为这种一致性使你能够更有效地运营一个大型组织。还有一件事我记得很清楚，那是和他开的一次小型会议，我们正在展示一个新产品，我说：“我们的竞争对手在这个项目上的人手是我们的 10 倍。”他看着我说：“那是你的优势。”然后他开始讲他的理论：这就像爬山，开发一个产品需要七年时间，你不能只看短期，必须长期投入。你可以肯定，从那以后我再也没进去说过“我需要更多资源”。这就是贝佐斯。

---

### [00:30:14] Lenny Rachitsky

**English:**
Awesome.

**中文翻译:**
太棒了。

---

### [00:30:17] Tamar Yehoshua

**English:**
Stewart. Again, I went to Slack because I wanted to work with Stewart Butterfield. I think he is the best product thinker in the Valley. He's not working in product right now. He's taking time off. But he's got this combination of long-term thinking and in the details. So in 2014, he wrote a master plan for Slack, which was build a product people love, build a network. That's Slack Connect. Build a platform that makes all of your other SaaS products more valuable. That's Slack Platform. And then do some magic AI stuff. Magic AI stuff took a lot longer, but-

**中文翻译:**
斯图尔特（Stewart Butterfield）。同样，我去 Slack 是因为我想和斯图尔特共事。我认为他是硅谷最顶尖的产品思想家。他现在没在做产品，正在休假。但他兼具长期思维和对细节的把控。2014 年，他为 Slack 写了一个宏伟蓝图：构建一个人们喜爱的产品；构建一个网络（即后来的 Slack Connect）；构建一个平台，让所有其他 SaaS 产品更有价值（即 Slack 平台）；然后做一些神奇的 AI 玩意儿。AI 玩意儿花的时间长得多，但是……

---

### [00:30:54] Lenny Rachitsky

**English:**
That was part of his plan early on is magic AI stuff.

**中文翻译:**
“神奇的 AI 玩意儿”早就是他计划的一部分了？

---

### [00:30:55] Tamar Yehoshua

**English:**
It literally was. There was a grid with four boxes in 2014 and it never changed. That was his master plan and what we worked on each year changed. But somebody recently asked me, "You guys did Slack Connect much later?" I'm like, "Yeah, but it was always part of the plan." It was always part of his vision. So he saw forward in the vision, but he also was very much into the details. And I think the thing that I learned from him the most was the power of prototyping. And that even though he was such a great product thinker, he would always say, "I can't tell you if this is going to work. I have to feel it. I have to try it. And a mock-up doesn't tell you what it's going to feel like." And he would push people to do prototypes, not incremental of just to get a feature out, but really to think. Very soon after I started, we launched ... I hired a design lead, Ethan Eismannn, and he led a redesign of the new information architecture for Slack.

**中文翻译:**
确实如此。2014 年就有一个四格矩阵，从未变过。那是他的宏伟蓝图，虽然我们每年做的事情在变。最近有人问我：“你们 Slack Connect 做得这么晚？”我说：“是的，但它一直在计划中。”这始终是他愿景的一部分。他既有远见，又非常关注细节。我认为我从他身上学到最多的是“原型设计”（prototyping）的力量。尽管他是一个伟大的产品思想家，但他总是说：“我没法告诉你这行不行，我得感受它，我得试用它。静态模型（mock-up）没法告诉你它的手感。”他会推动人们去做原型，不是为了发布某个小功能的增量更新，而是为了真正的思考。我入职后不久，我们启动了……我雇了一位设计主管 Ethan Eismann，他领导了 Slack 新信息架构的重新设计。

---

### [00:31:59] Lenny Rachitsky

**English:**
I worked with Ethan at Airbnb.

**中文翻译:**
我在 Airbnb 和 Ethan 共事过。

---

### [00:32:00] Tamar Yehoshua

**English:**
Oh yeah.

**中文翻译:**
噢，是吗。

---

### [00:32:01] Lenny Rachitsky

**English:**
He was head of design for the search experience and the search team.

**中文翻译:**
他是搜索体验和搜索团队的设计负责人。

---

### [00:32:04] Tamar Yehoshua

**English:**
Yeah. Ethan is awesome. And he came in and his first task was to work with Stewart on this redesign. And Stewart came in and said, "I want you to take everything in the interface and put it behind one button." And everyone's like, "That's never going to work." And he's like, "Do it. Just do it." And so we had our prototypers ... We had also engineers, front-end engineers who were really good at prototyping, literally took everything in the interface and put it behind one button and he said, "This is how you're going to see what you really need in the interface." So we were never going to ship that, but it was the beginning of the redesign.

**中文翻译:**
是的，Ethan 很棒。他进来后的第一个任务就是和斯图尔特一起做这个重新设计。斯图尔特进来说：“我要你们把界面上的所有东西都藏到一个按钮后面。”大家都说：“这绝对行不通。”他说：“做吧，尽管去做。”于是我们的原型师……我们还有一些非常擅长做原型的工程师、前端工程师，真的把界面上的所有东西都放到了一个按钮后面。斯图尔特说：“这样你就能看清界面里真正需要的是什么了。”我们当然没打算发布那个版本，但那是重新设计的开始。

---

### [00:32:43] Lenny Rachitsky (Ad Segment - Sidebar)

**English:**
Let me tell you about a product called Sidebar. The most successful people that I know surround themselves with incredible peers... [Ad content omitted for brevity but translated below]

**中文翻译:**
让我给你介绍一个叫 Sidebar 的产品。我认识的最成功的人都会让自己身边围绕着优秀的同行。当你拥有一群值得信赖的同行时，你可以讨论面临的挑战，获得职业建议，并审视你对工作、职业和生活的思考。这不仅能让你领先一步，更能让你实现跨越式发展。拥有一群值得信赖且优秀的同行是我职业成长的关键。这就是 Sidebar 的宗旨，但靠自己建立这样一个群体很难。Sidebar 是一个面向高级技术专业人士（总监级到 C 级）的平台，旨在助力职业发展。成员会被匹配到同行小组中，获得公正的意见、多元的视角和坦诚的反馈。在世界级的项目和引导下，Sidebar 的技术能让你在职业生涯的每一步获得专注且具实操性的反馈。如果你是这个播客的听众，说明你已经致力于成长。Sidebar 是催化你职业生涯的最后一块拼图。93% 的成员表示 Sidebar 帮助他们在职业生涯中实现了显著的积极变化。在 sidebar.com/lenny 了解更多。

---

### [00:34:08] Lenny Rachitsky

**English:**
As a product leader, how do you think about just the time it takes to create a prototype in something like this? As a pm I'm just like a lot of times we don't have time to build this whole prototype. We got to ship stuff, we got to hit these calls, we got experiments to run, we'll just build it and see how it goes. How do you think about making time for something like that?

**中文翻译:**
作为产品领导者，你如何看待创建这类原型所需的时间？作为产品经理，我常觉得我们没时间构建完整的原型。我们要发布东西，要达成指标，要跑实验，我们只想直接做出来看看效果。你如何考虑为这种事腾出时间？

---

### [00:34:38] Tamar Yehoshua

**English:**
If you're doing it right, it'll be faster and you need to have an engineering infrastructure that enables prototyping. So some engineering infrastructures are too heavy and they don't actually enable prototyping. We had a problem with our mobile apps that it was too hard to prototype and we actually redesigned our mobile apps until we got to the point where it was easier because our desktop app was pretty easy to prototype. But you have to have a layer of abstraction that enables you to do that, and you have to have engineers who have a prototyping mindset, and if you build multiple things and you have this mindset as I'm willing to throw it away, you write code that is never going to make it to production so you can just crank it out much faster and then you can see what works and then you build the production code. Until you actually get to your end goal of something working faster. But you need the engineering team to have the same mindset. The product and engineering have to work together and design because design is just in it. Sometimes you can get design engineers who are doing the prototyping. So your first prototypes are like Figma prototypes, and then you get prototypes on real data. When I was at Google, one of our teams, a front-end team, I remember we hired a bunch of prototypers and our head of front-end engineering said to me one day, this is my secret weapon. This is how we move faster. So I do think it's a mindset shift and a tech stack shift.

**中文翻译:**
如果你方法得当，它反而会更快。你需要一个支持原型设计的工程基础设施。有些工程架构太重了，实际上无法支持快速原型。我们的移动应用曾遇到过这个问题，原型设计太难了，所以我们重新设计了移动应用，直到它变得像桌面应用一样容易做原型。你必须有一个抽象层来支持这一点，而且你需要有具备“原型思维”的工程师。如果你构建了多个东西，并且抱着“我愿意把它扔掉”的心态，你写的代码永远不会进入生产环境，这样你就能快得多地把它搞出来，看看什么有效，然后再写生产代码。最终你会更快地达成目标。但这需要工程团队有同样的心态。产品、工程和设计必须紧密合作。有时你可以找“设计工程师”来做原型。最初的原型可能是 Figma 模型，然后是基于真实数据的原型。我在 Google 时，有一个前端团队雇了一群原型师，我们的前端工程主管有一天对我说：“这是我的秘密武器，这就是我们跑得更快的原因。”所以我认为这既是心态的转变，也是技术栈的转变。

---

### [00:35:39] Lenny Rachitsky

**English:**
We're going to talk about AI later, but it's also getting easier to build prototypes with AI. There's this video recently that went around on Twitter where an eight-year-old girl was building an app and in like 45 minutes, she built a chatbot using this product called Cursor. So I think that'll unlock a lot of great product on opportunities and just accelerate this sort of work. I asked about Jeff Bezos and Stewart Butterfield. I'm curious if there's another leader you've worked with that maybe is less known that you also learned a ton from that might be worth talking about.

**中文翻译:**
我们稍后会谈到 AI，但现在用 AI 构建原型也变得越来越容易了。最近 Twitter 上有个视频，一个八岁女孩用一个叫 Cursor 的产品在 45 分钟内构建了一个聊天机器人。我认为这会释放很多伟大的产品机会，并加速这类工作。我问过贝佐斯和巴特菲尔德了，我很好奇你合作过的领导者中，是否还有一些没那么出名、但你也从他们身上学到很多、值得聊聊的人？

---

### [00:36:12] Tamar Yehoshua

**English:**
I think that there are people who are really, really good at what they do. So Marc Benioff is an amazing marketeer. His marketing mind ... After the acquisition, I got the opportunity to onstage with him at Dreamforce for ... Because Slack was a new shiny thing so of course Slack was going to be in the keynote. And so I was in the Benioff's keynote two years in a row. And so I watched how he approaches his keynote and the whole thing around Dreamforce. Dreamforce is incredible at the impact that it has on the ecosystem. And so I think that as a product, people don't think of him as much, but as his marketing abilities are amazing what he's done.

**中文翻译:**
我认为有些人确实在自己的领域做到了极致。比如马克·贝尼奥夫（Marc Benioff），他是一个了不起的营销天才。他的营销头脑……在收购之后，我有机会和他一起登上 Dreamforce 的舞台，因为 Slack 是当时的新宠，理所当然会出现在主题演讲中。我连续两年参加了他的主题演讲。我观察了他如何准备演讲以及围绕 Dreamforce 开展的一切。Dreamforce 对生态系统的影响力是惊人的。我认为在产品方面，人们可能没那么关注他，但他的营销能力以及他所成就的事业确实令人惊叹。

---

### [00:37:07] Lenny Rachitsky

**English:**
I've written posts about how various companies got started in Salesforce history. Always comes to mind where they go to conferences where's there's no software mascot walking around. And I remember they did something around one of their competitors where they just created some real controversy around someone.

**中文翻译:**
我写过关于 Salesforce 创业史的文章。总能想到他们去参加那些没有“软件吉祥物”走来走去的会议。我记得他们针对一个竞争对手做了一些事，制造了一些真正的争议。

---

### [00:37:22] Tamar Yehoshua

**English:**
Well, they went into their competitor's conference and stood outside their competitor's conference.

**中文翻译:**
没错，他们跑到竞争对手的发布会门口去抗议。

---

### [00:37:27] Lenny Rachitsky

**English:**
Mm-hmm. Right. That's what it was.

**中文翻译:**
嗯，对，就是那件事。

---

### [00:37:29] Tamar Yehoshua

**English:**
This is in the Beyond Software. This is in his book that he wrote about the early phases of Salesforce. And it takes his guts. He pushes the envelope.

**中文翻译:**
这在《超越软件》（Beyond Software）里有记载，那是他写的关于 Salesforce 早期阶段的书。这需要胆量，他总是在挑战极限。

---

### [00:37:40] Lenny Rachitsky

**English:**
I love that. It's a really good point that people don't think of Marc Benioff as a marketer. And that's interesting that that's maybe the main thing you took away from him is just the power of marketing and the skill.

**中文翻译:**
我喜欢这一点。人们不常把贝尼奥夫看作营销人员，这很有趣。也许你从他身上学到的最主要的东西就是营销的力量和技巧。

---

### [00:37:49] Tamar Yehoshua

**English:**
He approaches his marketing presentations like a product person approaches their building their product.

**中文翻译:**
他对待营销演示的方式，就像产品人对待构建产品一样。

---

### [00:37:58] Lenny Rachitsky

**English:**
Amazing. Okay. Speaking of former colleagues, I asked one of your former colleagues, his name is Fuzzy Khos. He's now the CTO of Notion. You worked with him, I believe at Slack.

**中文翻译:**
太棒了。说到前同事，我问了你的一位前同事 Fuzzy Khos，他现在是 Notion 的 CTO。我相信你们在 Slack 共事过。

---

### [00:37:59] Tamar Yehoshua

**English:**
And at Google.

**中文翻译:**
还有在 Google。

---

### [00:38:10] Lenny Rachitsky

**English:**
And at Google. Wow. Okay. So I asked him what to ask you, and he said that you're amazing at building strong cross-functional relationships, especially with engineers. I know you used to be an engineer, so I get where that skill come from. What can you teach people about building stronger cross-functional relationships, especially PMs to build better relationships with their engineers, designers, other folks on their team?

**中文翻译:**
还有 Google，哇。我问他该问你什么，他说你非常擅长建立强大的跨职能关系，尤其是与工程师的关系。我知道你以前是工程师，所以我明白这技能从哪儿来。关于建立更强大的跨职能关系，你能教给人们什么？特别是产品经理如何与工程师、设计师及团队其他成员建立更好的关系？

---

### [00:38:34] Tamar Yehoshua

**English:**
Probably the most important thing that a product leader does because if you have great ideas of what to build, but you can't get them built, then you go nowhere. So one, make sure somewhere where you have a good engineering partner. So Henderson was the co-founder and CTO of Slack, and I couldn't have asked for a better engineering partner. He's just awesome. And that has to be part of your evaluation criteria that you meet and value your engineering partner before you join or you know that it's not the right one and the organization is willing to make a change. So that can happen too. You can go in and understand that something has to change, but that is a very, very important thing of what you're doing and what you're assessing when you go in. And then I think what's really important is that you're aligned. You understand your roles and responsibilities and where you're going to divide and conquer and where you're going to be aligned. You don't want any of this ... People in the organization, they asked Mom, they asked dad and they got different opinions and playing one against the other, that doesn't work. So one, you have to know that you're not going to do that. So if somebody would ask me something that it was in Cal's domain, I'd be like, "Did you talk to Cal?" I would never try and go around him. So we were very clear on, you're going to drive this, I'm going to drive this. And if it was unclear, we'd talk and we would say, "Okay. Who's going to take this one?" And we would do all our reviews together. And so all of the OKR reviews, we had weekly exec reviews, we had the updates on our OKRs, so we did them all together, but I knew here's the things that he was going to ask the questions on and dig deep. And then when I was, he would take a back seat, but of course we could ask questions in each other things, but I knew that he was taking ownership and he knew what I was taking ownership of. But I think the bottom line was respect. Is that you have to respect and trust that they actually will follow up on what they say they will. In Cal and Fuzzy were amazing at that. I would go to Fuzzy and be like, "Hey, we need more mobile engineers because this one product is not going to ship." And he's like, "I'm on it. Got it." And that was all I needed to do. And obviously if he couldn't do it, he'd come back to me and, "Hey, there's going to be a problem." But it was like just things got done. That's the best part of it.

**中文翻译:**
这可能是产品领导者做的最重要的事情，因为如果你有伟大的想法但造不出来，那就毫无意义。第一，确保你在一个有优秀工程合作伙伴的地方。Cal Henderson 是 Slack 的联合创始人兼 CTO，我找不到比他更好的工程伙伴了，他太棒了。这必须成为你入职前评估标准的一部分：去见见并评估你的工程伙伴。或者如果你发现人选不对，而组织愿意做出改变，那也可以。你可以进去后意识到必须有所改变，但这是你入职时非常重要的评估项。其次，我认为非常重要的一点是“达成共识”（aligned）。你们要明确各自的角色和职责，知道哪里需要分工协作，哪里需要保持一致。你不希望看到组织里的人去问“妈妈”，又去问“爸爸”，得到不同意见后让他们互相博弈，那是行不通的。所以，你必须明确自己不会那样做。如果有人问我属于 Cal 领域的事情，我会说：“你问过 Cal 了吗？”我绝不会绕过他。我们非常明确：你负责这个，我负责那个。如果不明确，我们会商量：“好，这个谁来牵头？”我们会一起进行所有的评审。所有的 OKR 评审、每周高管评审、OKR 更新，我们都一起做。但我知道哪些问题他会深挖，而当我发言时，他会退居二线。当然我们可以互相提问，但我知道他在负责什么，他也知道我在负责什么。但归根结底是“尊重”。你必须尊重并信任他们会落实自己说过的话。Cal 和 Fuzzy 在这方面做得非常好。我会去找 Fuzzy 说：“嘿，我们需要更多移动端工程师，否则这个产品发不了。”他会说：“交给我，没问题。”我只需要做这些。显然如果他做不到，他会回来跟我说：“嘿，会有麻烦。”但结果就是事情总能办成。那是合作中最棒的部分。

---

### [00:40:56] Lenny Rachitsky

**English:**
You talked about being aligned, which I love and I fully have seen that power of that of you and your engine manager, design manager being aligned on ... And you tell me if I'm wrong, but specifically on what goals you're trying to achieve, what success looks like, things like that. Are there any tactics you found to create that alignment? And also if there's anything else you want to add to the point I just made about what it is you're specifically aligned on, that'd be great.

**中文翻译:**
你谈到了达成共识，我非常喜欢这一点，也完全见识过你与工程经理、设计经理达成共识的力量……如果我说错了请纠正我，这种共识具体是指：你们要实现什么目标、成功是什么样子的，等等。你有没有发现什么建立这种共识的策略？另外，关于我们具体在哪些方面需要达成共识，你还有什么想补充的吗？

---

### [00:41:19] Tamar Yehoshua

**English:**
One, you got to spend a lot of time together. There isn't a way around that. And you have to document things and make sure that you've talked it through. And if you don't agree with something and you're not sure it's a priority, you have to speak up and you can't just be like, "Okay, whatever.", and then go to somebody in your team and be like, "Oh God, that that CTO, why did he make this decision?" That just doesn't work. So I'm a very direct person. So if I don't think that something is the right priority or is working, I will be very clear. We had different forms, so I'll be very tactical here on the forms that Cal and I had together.

**中文翻译:**
第一，你们必须花大量时间待在一起，这没有捷径。你们必须把事情记录下来，确保已经沟通透彻。如果你不同意某件事，或者不确定它是否是优先级，你必须说出来。你不能表面上说“好吧，随你”，然后跑去跟团队成员抱怨：“天哪，那个 CTO 为什么要这么决定？”那是行不通的。我是一个非常直接的人，如果我认为某件事优先级不对或行不通，我会说得很清楚。我们有不同的沟通形式，我在这里具体分享一下 Cal 和我共同采用的形式。

---

### [00:41:56] Lenny Rachitsky

**English:**
Perfect.

**中文翻译:**
太好了。

---

### [00:42:00] Tamar Yehoshua

**English:**
We used OKRs to drive our processes and we would have the teams present OKRs to us. When the team got too large, it got to be too much time to go through every team's OKR review so we had a Slack channel for each team, their OKRs, a planning channel for each one. And people would post a doc and then a Slack video of going through the major points. And we had a time limit of how long they were allowed to be. And they would say, "Here's our OKRs, here's the things that you would pay attention to." And then Cal and I would do a marathon and we would watch them all together. And-

**中文翻译:**
我们用 OKR 来驱动流程，让团队向我们展示 OKR。当团队变得太大时，逐个进行 OKR 评审太耗时了。于是我们为每个团队建立了一个 Slack 频道，专门用于 OKR 和规划。大家会发布一个文档，然后配上一段 Slack 视频（Slack Clips）讲解要点。我们对视频时长有限制。他们会说：“这是我们的 OKR，这是你们需要关注的地方。”然后 Cal 和我会进行一场“马拉松”，一起观看所有的视频。

---

### [00:42:36] Lenny Rachitsky

**English:**
In a room sitting there watching them together?

**中文翻译:**
坐在房间里一起看？

---

### [00:42:38] Tamar Yehoshua

**English:**
Correct. And then we would say, "Do we have any follow-up questions?" And we put in channel our follow-up questions to the team. And sometimes there'd be five to 10 teams that we would then have a follow-up meeting with. We would say that this is a really high priority project or there are a lot of questions that we have, and then we would do a meeting but we were always doing those meetings together. So that was the OKR reviews of getting the alignment. And by asking the questions, we could then ... By it just being us, we could dig into the team. And we each had a chief of staff, so it was the two of us plus our two chiefs of staff, and which they also did a divide and conquer and they worked really well together. They were both long time Slack employees. So for years they had ... One had been an engineering director and one had been a TPM. And then every Monday we had a Monday meeting where we reviewed the progress on the top OKRs and red, yellow, green and don't talk through the green ones, only talk through the red ones and what are the issues. And again, both there. And then we had a weekly meeting with the four of us where we would just go through any issues in the organization, what's going on, what's not.

**中文翻译:**
没错。然后我们会问：“我们有后续问题吗？”并在频道里向团队提出。有时会有 5 到 10 个团队需要我们开后续会议。我们会说这是一个优先级非常高的项目，或者我们有很多疑问，然后开会，但我们总是共同参加。这就是通过 OKR 评审达成共识的过程。通过提问，我们可以……因为只有我们两个，我们可以深入了解团队。我们每人都有一个幕僚长（Chief of Staff），所以是我们两个加两个幕僚长。幕僚长之间也分工明确，配合默契。他们都是 Slack 的老员工，一个是工程总监出身，一个是 TPM（技术项目经理）出身。每周一我们有一个周会，评审核心 OKR 的进展，用红黄绿标示。不讨论绿色的，只讨论红色的以及存在的问题。同样，我们两个都在场。然后我们四个每周开一次会，梳理组织中的任何问题，哪些进展顺利，哪些不顺利。

---

### [00:43:50] Lenny Rachitsky

**English:**
And the four of us is you, the CTO, the chiefs of staff.

**中文翻译:**
“我们四个”是指你、CTO 和两位幕僚长。

---

### [00:43:54] Tamar Yehoshua

**English:**
Yep. And sometimes we would invite people. Like there's an issue with QA, so we'd have the QA leader come in and present to us. But we tried to limit the number of meetings with teams. So it'd be like the Monday meeting was the big meeting that you had to be there and you had to be able to talk to your project and that was it.

**中文翻译:**
是的。有时我们会邀请其他人。比如 QA 出了问题，我们会请 QA 负责人来向我们汇报。但我们尽量限制与团队开会的次数。周一的会议是必须参加的大会，你必须能汇报你的项目，仅此而已。

---

### [00:44:13] Lenny Rachitsky

**English:**
There's so much awesomeness here. I love the idea of this Async share your plan in a video instead of meetings with everyone in real time. And you could just do a lot of the stuff Async.

**中文翻译:**
这太棒了。我喜欢这种用视频异步分享计划，而不是所有人实时开会的想法。很多事情都可以异步完成。

---

### [00:44:22] Tamar Yehoshua

**English:**
We iterated every quarter, just like you iterate on a product. So every quarter we would say did the OKR planning work or not, and then we would adjust. So we got to the point where at one point we added up all the hours of OKR reviews and all the people in them and it was some insane number, like 300 and something and we're like, "This has gotten out of hand." So then we're like, "We have to do something drastic." And that's when we moved them to Async. It was also right after Slack Clips launched.

**中文翻译:**
我们每季度都会迭代流程，就像迭代产品一样。每季度我们都会评估 OKR 规划是否有效，然后进行调整。有一次我们统计了所有 OKR 评审的总时长和参与人数，结果是一个惊人的数字，大概 300 多个小时。我们觉得“这已经失控了”，必须采取激进措施。于是我们转向了异步模式。那正好是在 Slack Clips 功能发布之后。

---

### [00:44:51] Lenny Rachitsky

**English:**
Got it. That's the video feature. Very cool. Then I know you launched huddles, right? Slack Huddles? Did you use that as a part of this or eventually you just get people into a little huddle asynchronously and talk-

**中文翻译:**
明白了，就是那个视频功能。很酷。我知道你们还发布了 Huddles（抱团），对吧？Slack Huddles？你们在流程中使用了它吗？或者最终只是让大家异步进入一个小 Huddle 聊天？

---

### [00:45:01] Tamar Yehoshua

**English:**
Sometimes. Absolutely. We would be in the reviews and we would huddle with somebody to ask a quick question. We use Huddled all the time. I still do. I love Huddles.

**中文翻译:**
有时会。绝对的。我们在评审时会找某人开个 Huddle 问个简短的问题。我们一直在用 Huddles，我现在也还在用，我非常喜欢这个功能。

---

### [00:45:09] Lenny Rachitsky

**English:**
I love it. One crazy thing about Slack is people in Slack don't actually use email internally. It's like all in Slack. It's like the actual vision of Slack working within Slack.

**中文翻译:**
我喜欢这个。Slack 有件很疯狂的事：Slack 内部的人其实不用邮件进行内部沟通，全在 Slack 里。这就像是 Slack 的愿景在 Slack 内部真实上演。

---

### [00:45:18] Tamar Yehoshua

**English:**
No email unless you're dealing with somebody external. And no, it's mostly Slack Connect anyway.

**中文翻译:**
除非是处理外部事务，否则没有邮件。而且现在大部分外部事务也通过 Slack Connect 搞定了。

---

### [00:45:24] Lenny Rachitsky

**English:**
Anyway. Wow, that's amazing. Okay. I have one more question around product stuff and then I want to talk about AI. So I was reading your newsletter on Substack, which we'll link to and you share this really interesting insight that I've experienced myself that I'll quote you here. One of the mistakes that I see a lot of product managers make is they over index on people who are going to be unhappy with the products they're launching. And basically your advice is not to worry so much about making users unhappy, which I think is counterintuitive to some people. Can you just talk about this lesson and I'd love to hear what product you launched that made people unhappy that you realized, oh, maybe we don't need to worry about this as much.

**中文翻译:**
不管怎样，哇，太神奇了。好，关于产品我还有一个问题，然后我想聊聊 AI。我读了你在 Substack 上的时事通讯（我们会附上链接），你分享了一个非常有趣的见解，我也深有体会。我引用一下你的话：“我看到很多产品经理犯的一个错误是，他们过度关注那些会对即将发布的产品感到不满的人。”基本上你的建议是不要太担心让用户不开心，我认为这对某些人来说很反直觉。你能谈谈这个教训吗？我很想听听你发布过什么让人们不开心、但后来你意识到“也许我们不需要那么担心”的产品。

---

### [00:46:04] Tamar Yehoshua

**English:**
I saw it more when you unlaunch things, you take things away there's always some set of users that are using a feature that nobody else does, and then you take it away and they're super unhappy, but there are more people you're going to make happy. So a product manager gets caught in this trap of the vocal minority and the number of people using your product ... Depends on what phase. Are you a Google? Are you Slack? Are you a Glean? But the number of people using your product today is usually unless you're a Google far smaller than the number of people who are going to be using your product tomorrow. So design it for the bigger number of people who are going to be using it tomorrow. If you have to redo the UI and the Who Moved My Cheese, people will be unhappy, but all the new people are going to be like, "This is so much easier." Then do it and deal with the people who are unhappy. But the trick is you have to be respectful and you have to be transparent and you have to explain. You have to go to people and say, "This is why we made this change." And you have to be authentic. You can't be dismissive and you can't have marketing speak. You have to really say, "Here's for real why." And you have to listen to your audience. You don't want to alienate your early users because most people ... If you made a good decision on why you moved this or why we stopped using Slack calls and moved to Huddles and you have to do it over time and give people choice and then give them enough time to move. So you have to do it in the right way. But if people feel heard, it makes a difference. I have an example that's not a product example, but I think is a really good one. It's a leadership example. So when I was at Google, there was always a controversy about something, but there was a controversy about ... It was Blogger or something. I can't even remember what it was. It was like we made a change. We were like 50,000 people at the time. There was an engineer in my team, an IT engineer that was super unhappy about the change. And I knew Rachel Whetstone, she was in charge of all of PR and global policy at Google. So huge job. And I emailed Rachel and I'm like, "Hey, do you have an FAQ or something that can help me? Because I don't know why you made this change and that I can help explain to the engineer in my team." She did not respond to my email. She picked up the phone and she called him. I had no idea she did this. She just called this IT engineer and she listened to him and she heard why he was upset and she explained her reasoning. He was so blown away that she called him that he completely changed his opinion and then he told everyone else in the org. And so it had this effect. And I learned a lot from watching her do that. She never even told me she did it later. She just did it. You just act. You're authentic. You listen to people and you're transparent.

**中文翻译:**
我更多是在“下线”产品或取消功能时看到这种情况。总有一小部分用户在使用某个没人用的功能，当你取消它时，他们会非常不爽。但你会让更多的人感到快乐。产品经理常陷入“声音很大的少数派”（vocal minority）的陷阱。你现在的用户数量——取决于你在哪个阶段，是 Google、Slack 还是 Glean——通常（除非你是 Google）远小于你未来的用户数量。所以，要为未来更多的用户设计产品。如果你必须重新设计 UI，搞一次“谁动了我的奶酪”，老用户会不开心，但所有新用户会觉得：“这简单多了。”那就去做吧，然后去处理那些不开心的人。但诀窍在于：你必须尊重他们，必须透明，必须解释。你得告诉大家：“这就是我们做此改变的原因。”你必须真诚，不能敷衍，不能用营销辞令，要说出真实的原因。你必须倾听你的受众。你不想疏远早期用户，所以如果你做了一个明智的决定（比如为什么移动某个功能，或者为什么停用 Slack 通话转用 Huddles），你必须循序渐进，给人们选择，并给他们足够的时间迁移。你必须用正确的方式去做。如果人们觉得自己的声音被听到了，情况就会大不相同。我有一个非产品的例子，但我认为非常好，这是一个领导力的例子。我在 Google 时，总会有各种争议。当时关于 Blogger 还是什么的有个争议，我不记得具体是什么了，总之我们做了一个改动。当时公司有 5 万人，我团队里有个 IT 工程师对这个改动非常不满。我认识 Rachel Whetstone，她当时负责 Google 全球所有的公关和政策，职位很高。我给 Rachel 发邮件说：“嘿，你有没有 FAQ 之类的东西能帮帮我？因为我不知道你们为什么要改，我想向我团队的工程师解释一下。”她没有回我邮件，而是直接拿起电话打给了他。我完全不知道她这么做了。她直接打给那个 IT 工程师，听他倾诉，听他为什么不爽，然后解释了她的理由。那个工程师被她亲自打电话的行为惊呆了，完全改变了看法，然后告诉了组织里的所有人。这产生了一种连锁反应。我从她身上学到了很多。她事后甚至没告诉我她这么做了，她只是去做了。你只需行动，保持真诚，倾听他人并保持透明。

---

### [00:49:12] Lenny Rachitsky

**English:**
It's so funny. This reminds me of a parenting book I'm reading right now that a former guest recommended called Listen. And the core thesis of the book is when your kids are acting up or they're getting off track, so much of what they need is a sense that you're connected to them, a connection which is rooted in you listening to them. And so all-

**中文翻译:**
太有意思了。这让我想起我正在读的一本育儿书，是一位前嘉宾推荐的，叫《倾听》（Listen）。书的核心论点是：当孩子闹脾气或不听话时，他们最需要的是一种与你的连接感，而这种连接根植于你对他们的倾听。所以……

---

### [00:49:34] Tamar Yehoshua

**English:**
My favorite parenting book ... I don't know if this is the same one or a different one, it's How to Talk so Your Kids Will Listen & How to Listen so Your Kids Will Talk. Maybe it's the new name of that book, but it's so good and it's so true in everything and also in products. So whether you're in a forum and explaining to customers, whether you're enterprise customers, you're explaining, you're hearing them out, people want to understand.

**中文翻译:**
我最喜欢的育儿书……我不知道是不是同一本，叫《如何说孩子才会听，怎么听孩子才肯说》。也许那是它的新名字，但它写得太好了，在任何事情上都适用，包括产品。无论你是在论坛上向客户解释，还是面对企业客户，你解释并听取他们的意见，人们是渴望被理解的。

---

### [00:49:58] Lenny Rachitsky

**English:**
Amazing. There's so many applications of just the power of listening. Okay. Well, not quite a segue, but let's talk about AI. You're at the epicenter of AI now with Glean. How do you anticipate AI will change our jobs and product? What do you think people may be aren't recognizing it, realizing it? What have you seen?

**中文翻译:**
太棒了。倾听的力量有这么多应用场景。好，虽然转折有点生硬，但让我们聊聊 AI。你现在在 Glean，处于 AI 的中心。你预见 AI 将如何改变我们的工作和产品？你认为人们可能还没意识到什么？你看到了什么？

---

### [00:50:21] Tamar Yehoshua

**English:**
I'm going to give you a little bit of my history with AI to get to that point. When AI was a completely different technology stack ... I have a master's in AI. So I started working in AI when ... It's evolved so much. And then of course at Google using it for auto complete and search. It's transformed so many times. But then with this last transformation of GenAI ... And that's what brought me to Glean of seeing this, meeting lots of AI companies and like, "Wow. This is really going to transform how we work." And it's just fascinating seeing these products. I was one of those people like, "Oh yeah, it's going to be so far away." Until I saw GPT3. And I think AI, we are underestimating how much it's going to change how we work. It's not going to be sudden from today to tomorrow because people haven't figured it out yet. They haven't figured out how exactly to leverage it. But the people who have are going to be so far ahead. They're going to be far ahead of everyone else because they're going to be working faster, they're going to be working better. And in five to 10 years, I think the lines between product managers and engineers and designers are going to blur because AI will enable product managers to build prototypes, to build designs. Designers to build a pro like Figma already has their Figma AI. You can press a button and you can get your initial prototype working. You've got all the co-pilots. So they're not quite there. You still, like with Copilot or with Cursor, you need to be an experienced engineer to know when it's getting it wrong, but they're going to keep getting better. I think people have to be careful about not getting left behind, but their jobs aren't going to go away. They're just going to change. I'm of the believer that we're just going to have a lot more software. But I talked to engineers and to PMs saying, "Yeah, I tried that. It doesn't really work." And then go back to how I worked before. And that's a dangerous spot to be in I think.

**中文翻译:**
为了说明这一点，我先简单讲讲我的 AI 背景。当 AI 还是完全不同的技术栈时……我有 AI 硕士学位。我开始从事 AI 工作时……它已经进化了太多。后来在 Google，我们把它用于自动补全和搜索。它经历了很多次转型。但随着这次生成式 AI（GenAI）的变革……这正是我加入 Glean 的原因。在见了很多 AI 公司后，我心想：“哇，这真的会改变我们的工作方式。”看到这些产品非常令人着迷。我曾是那种觉得“噢，那还很遥远”的人，直到我看到了 GPT-3。我认为我们低估了 AI 对工作方式的改变程度。它不会一夜之间发生，因为人们还没搞清楚如何精准地利用它。但那些已经搞清楚的人将遥遥领先，因为他们工作得更快、更好。在 5 到 10 年内，我认为产品经理、工程师和设计师之间的界限会变得模糊，因为 AI 会让产品经理能构建原型和设计，让设计师能构建……比如 Figma 已经有了 Figma AI，按个按钮就能让初始原型跑起来。还有各种 Copilot。虽然现在还不完美，比如用 Copilot 或 Cursor，你仍需要经验丰富的工程师来判断它什么时候出错，但它们会越来越好。我认为人们必须小心不要掉队，但工作不会消失，只是会发生变化。我相信未来会有更多的软件。但我听到一些工程师和产品经理说：“是的，我试过了，不太好用。”然后就回到了以前的工作方式。我认为那是一个危险的处境。

---

### [00:52:34] Lenny Rachitsky

**English:**
For people that get anxiety hearing this where they're feeling they're going to be left behind and like, "Oh my God, I don't know enough time to do this or I don't know what I'm doing here." Do you have any advice for what's something someone can do to not fall behind?

**中文翻译:**
对于那些听到这些感到焦虑、觉得自己会掉队的人，比如“天哪，我没时间学这个”或者“我不知道该怎么做”，你有什么建议能让他们不掉队吗？

---

### [00:52:48] Tamar Yehoshua

**English:**
Use the products. This is what good PMs should do period. Always be using new products. It's not a unique thing for AI. When mobile came out, PMs needed to be using mobile apps all the time to try them out, see what the UIs are, see what's working and what isn't. And the same goes even more for AI. Use ChatGPT. If your organization has Glean, use Glean. Use Claude. Try them all. Try them and see what they do. I was talking to a product manager I know who is more forward-thinking and loves playing with new products and he had this use case that blew me away. So he said ... And this was a couple of months ago, so before ... It was right when Gemini had expanded the context window. So his product had a Discord channel and he took the transcript from the Discord channel, which was huge. And he fed it into Gemini the entire channel and then used it to ask questions. Like what is the sentiment of my product? What is the most requested feature? What are the things people are unhappy with? This never would've occurred to me. It's like, that is so smart. And he's like, "It was like a goldmine." Do you know how long it would've taken him to read? And he just wouldn't have done it. So think about for the argument, oh, I'm too busy. Well, if you use these products it's going to be a leverage on your time. So you get a lot of articles sent to you, summarize them, use AI to summarize the articles. We use Gong at Glean to record all our sales calls. We have a Glean app that will read all the Gong transcripts, put them in a spreadsheet in a certain format of who the AE is, etc. And then summarize all the top requested features from all the Gong calls. And it took a while to get it right. At first the summarization, the prompt wasn't good enough and would give us features that our salespeople would recommend and didn't distinguish that this was actually the customer. So you have to tweak it. It's not going to work out of the box. But then we got it to the point where it worked and these things really save time and you have to use your creative juices as a PM to figure out how it can help you and have patience to iterate and keep trying because the models that we have today can do a lot already.

**中文翻译:**
去用这些产品。这是优秀产品经理必须做的事，句号。永远保持试用新产品的习惯。这不只是针对 AI。当移动互联网兴起时，产品经理需要一直试用各种 App，看 UI，看什么行得通，什么行不通。AI 更是如此。用 ChatGPT，如果你们公司有 Glean 就用 Glean，用 Claude。全都试一遍，看看它们能做什么。我认识一个思想超前、喜欢玩新产品的产品经理，他有个案例让我大吃一惊。那是几个月前，就在 Gemini 扩大上下文窗口（context window）的时候。他的产品有一个 Discord 频道，他把整个频道的聊天记录导出来——量非常大——然后全部喂给 Gemini，接着开始提问：我的产品口碑（sentiment）如何？被要求最多的功能是什么？人们对什么不满意？我压根没往这方面想过，这太聪明了。他说这简直是个金矿。你知道如果靠人工读要花多久吗？他根本不会去读。所以，别再说“我太忙了”。如果你使用这些产品，它们会成为你时间的杠杆。如果你收到很多文章，用 AI 总结它们。在 Glean，我们用 Gong 记录所有的销售电话。我们有一个 Glean 应用会读取所有的 Gong 转录文本，按特定格式（比如 AE 是谁等）填入表格，然后总结所有通话中客户最想要的功能。起初效果并不好，提示词（prompt）不够精准，它会把销售人员建议的功能也算进去，没能区分出哪些是客户说的。所以你必须调整，它不是开箱即用的。但当我们把它调优到好用时，它真的非常省时间。作为产品经理，你必须发挥创造力，思考它如何能帮到你，并有耐心去迭代尝试，因为现在的模型已经能做很多事了。

---

### [00:55:22] Lenny Rachitsky

**English:**
Yeah. I love your example of the PM and what they did with the Discord channel. Is there anything else along those lines that either you've done to leverage some AI tool to be more productive or folks in your team have done to be more productive youth, either your product leaders or other folks?

**中文翻译:**
是的，我非常喜欢那个产品经理处理 Discord 频道的例子。还有类似的例子吗？无论是你利用 AI 工具提高效率，还是你团队里的产品负责人或其他成员的做法？

---

### [00:55:38] Tamar Yehoshua

**English:**
So many examples. So one that I did really recently is I wrote a prompt in Glean to help me get the status of features. And we have a Launch Cal, and you can look at Launch Cal it'll say a date. But then is it really the date? What are the outstanding issues? So it will look at our Launch Cal and it will see if there are any open year tickets, what the Slack conversations are and the customers who are beta testing it, bring all these together to tell me, okay, launch date is this according to Launch Cal, but here are all the open issues and here are the open conversations that people are talking about. So then it can give me the confidence level of the future looking. So I can run the prompt, just put in the name of the feature. So I don't have to read all of these channels. So this is a prompt that I built two weeks ago because we're advancing our prompting capabilities. And so I was testing it out and I was like, "Ooh, I could do this." So that's another example and engineers are using it for automating part of the incident management of I got an incident, how do I see were their previous incidents that were similar to it, where they're not. And so these are the type of things you can look at to help you. But the simplest, simplest is there's so much news. Let me just paste in all of these things and summarize them. As a product manager at Gleam, here are all the latest news. What do I have to care about? What's impacting me and potentially competitive to any of the products that I have?

**中文翻译:**
例子太多了。我最近做的一个是，我在 Glean 里写了一个提示词来帮我获取功能的最新状态。我们有一个发布日历（Launch Cal），上面会写一个日期。但那是真的发布日期吗？还有哪些未解决的问题？这个提示词会查看发布日历，检查是否有未关闭的 Jira 工单，查看相关的 Slack 对话，以及参与 Beta 测试的客户反馈，把这些整合在一起告诉我：日历上说是这个日期，但这里有这些未解决的问题，大家正在讨论这些事。这样它就能给我一个关于未来进度的信心指数。我只需运行提示词，输入功能名称即可，不用去翻所有的频道。这是我两周前写的提示词，因为我们正在提升提示词能力。我测试时心想：“噢，我还能这么干。”工程师们也在用它来自动化部分故障管理（incident management）：我遇到了一个故障，如何查看以前是否有类似的故障？这些都能帮到你。但最最简单的用法是：新闻太多了，我把这些东西全贴进去总结一下。作为 Glean 的产品经理，面对这些最新新闻，我需要关注什么？哪些会影响我，或者可能对我现有的产品构成竞争？

---

### [00:57:22] Lenny Rachitsky

**English:**
And putting that into say Claude or ChatGPT you're saying.

**中文翻译:**
你是说把这些放进 Claude 或 ChatGPT 里。

---

### [00:57:25] Tamar Yehoshua

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:57:26] Lenny Rachitsky

**English:**
Yeah. I think that beginning of the prompt is something a lot of people don't know is the power of just giving it a role like you are a product manager at Gleam. From that perspective, give me this summary versus just summarize this and that ends up being really powerful right.

**中文翻译:**
是的。我认为提示词的开头很重要，很多人不知道给它设定一个角色的威力，比如“你现在是 Glean 的产品经理”。从这个视角给我总结，比单纯说“总结一下”要强大得多，对吧？

---

### [00:57:42] Tamar Yehoshua

**English:**
A hundred percent. And you can compare what is Claude's PR saying that ... They just launched Claude Enterprise. How is Claude Enterprise different from OpenAI Enterprise? Again, you can do it yourself, but these micro improvements in your productivity help. For my newsletter, I interviewed Claire Vo who came out with ChatPRD. And so product managers are using is. We're just starting to evaluate it internally, so I haven't personally used it yet, but it's super cool and you can use ChatGPT to do a PRD. And ChatPRD, it's more templatized and more frameworks of how to do that. And again, these things are going to keep getting better.

**中文翻译:**
百分之百正确。你还可以对比：Claude 的公关稿说他们刚发布了 Claude 企业版，那它和 OpenAI 企业版有什么区别？同样，你可以自己查，但这些生产力上的微小改进很有帮助。在我的时事通讯中，我采访了开发 ChatPRD 的 Claire Vo。产品经理们正在使用它。我们内部刚开始评估，所以我还没亲自用过，但它非常酷。你可以用 ChatGPT 写 PRD（产品需求文档），而 ChatPRD 提供了更多的模板和框架。这些工具会持续进化。

---

### [00:58:33] Lenny Rachitsky

**English:**
Claire's been on the podcast, she's going to be speaking at the Lenny and Friends Summit coming up October 24th.

**中文翻译:**
Claire 来过这个播客，她也会在 10 月 24 日的 Lenny and Friends 峰会上演讲。

---

### [00:58:37] Tamar Yehoshua

**English:**
Oh, cool.

**中文翻译:**
噢，太酷了。

---

### [00:58:38] Lenny Rachitsky

**English:**
Yeah. A crazy stat she shared. She's making six figures off this product that she builds on the weekends ChatPRD.

**中文翻译:**
是的。她分享了一个疯狂的数据：她利用周末开发的 ChatPRD 已经让她获得了六位数的收入。

---

### [00:58:45] Tamar Yehoshua

**English:**
So cool.

**中文翻译:**
太酷了。

---

### [00:58:45] Lenny Rachitsky

**English:**
Incredible.

**中文翻译:**
不可思议。

---

### [00:58:46] Tamar Yehoshua

**English:**
But it also shows what you can build with AI.

**中文翻译:**
这也展示了利用 AI 你能构建出什么。

---

### [00:58:49] Lenny Rachitsky

**English:**
Right. It's just her. I think she just recently hired some engineers to help because she has three kids CTO at LaunchDarkly and just is building this on the side making a hundred thousand plus dollars. Incredible. I want to add a couple of things here. So one is for folks looking for ideas for how to use AI tooling for their PM job. There's a couple of posts I've written that I'll link to in the show notes just to put that out there of just a bunch of PM sharing, here's what I've done with these various tools. Another thought I'd love to get your take on. There's a lot of fear that the PM job be replaced by AI. And I've recently realized that it's the opposite. I think the PM role is the best positioned to thrive in the world of AI because if you just think about you have a tool that can just build a thing for you, just like you're staring at this blank thing that can build anything for you, which function would you think would have the best chance of asking it of what to build and how to articulate what to build best? To me, it's clearly Product People. They're best at figuring out what to build, what matters most, where the impact's going to be what customers need. Not to say other functions don't also have the skills, but I feel like of all functions, PMs have the most of that specific skill. I'd love to get your take on that.

**中文翻译:**
没错，就她一个人。我想她最近才雇了几个工程师帮忙，因为她有三个孩子，还是 LaunchDarkly 的 CTO，只是利用业余时间做这个，就赚了十多万美元。太不可思议了。我想补充两点：第一，对于想知道如何在产品经理工作中使用 AI 工具的人，我写过几篇文章，我会把链接放在节目介绍里，里面有很多产品经理分享他们如何使用这些工具。第二，我想听听你的看法。很多人担心产品经理会被 AI 取代，但我最近意识到情况恰恰相反。我认为产品经理是最能在 AI 世界中蓬勃发展的角色。因为如果你有一个能为你构建任何东西的工具，面对一个可以随心所欲构建的空白画布，你认为哪个职能最擅长决定“构建什么”以及如何清晰地表达需求？对我来说，显然是产品人。他们最擅长弄清楚该构建什么、什么最重要、影响力在哪里、客户需要什么。并不是说其他职能没有这些技能，但我觉得在所有职能中，产品经理拥有最深厚的这种特定技能。你对此怎么看？

---

### [01:00:01] Tamar Yehoshua

**English:**
That. I think that AI, the one thing it's not good at is being creative. So if you're a PM who's doing the grout work, it's going to take your job away. But if you're a PM who actually is strategic and can pull the pieces together and be creative and think how you do something that it's going to differentiate. Because it's not going to give you that leak. It'll say, here's what customers are asking for, here are the problems today, but you have to figure out how to solve it. So in some ways it might weed out the good from the bad PMs. Because there are a significant number of PMs who are more just execution. And I think that part of the job hopefully will be lowered because I hope a lot more of the execution will be able to automate updating Jira and all these things that just take time and creating even little Launch Cals, which PMs have to do manually now. So hopefully a lot of that work goes away and then people can be more creative. And I think designers and PMs are going to blend because the best designers I've worked with are product thinkers and a lot of really good PMs can also design. It depends on what kind of product you're PMing for. So I agree with the caveat that it will become harder to be a great PM.

**中文翻译:**
我同意。我认为 AI 唯一不擅长的是“创意”。所以，如果你是一个只做琐碎执行工作（grout work）的产品经理，AI 会抢走你的饭碗。但如果你是一个有战略眼光、能整合资源、有创意并能思考如何做出差异化的产品经理，你就不会被取代。因为 AI 不会给你那种跨越式的灵感。它会告诉你客户在要求什么，现在的问题是什么，但你必须想出如何解决它。所以从某种程度上说，它可能会优胜劣汰，淘汰平庸的产品经理。因为有相当一部分产品经理其实只是在做执行。我希望那部分工作能减少，希望更多的执行工作——比如更新 Jira、制作发布日历这些耗时的手动工作——能够自动化。这样人们就能更有创意。我认为设计师和产品经理会融合，因为我合作过的最优秀的设计师都有产品思维，而很多优秀的产品经理也能做设计。这取决于你负责什么样的产品。所以我同意你的看法，但有一个前提：成为一名“伟大”的产品经理会变得更难。

---

### [01:01:20] Lenny Rachitsky

**English:**
Wait, say more about that. It'll be harder to be a great PM because many PMs are doing things that are mostly project management and that's the stuff that-

**中文翻译:**
等等，再多说一点。是因为很多产品经理现在做的事其实更偏向项目管理，而那是会被……

---

### [01:01:30] Tamar Yehoshua

**English:**
Yeah. Let me rephrase. It's not going to be harder to be a great PM, but to be a PM, the not so good PMs jobs will go away. The great PMs will still have great jobs.

**中文翻译:**
是的。让我换个说法：成为伟大的产品经理本身不会变难，但“产品经理”这个门槛会变高，那些不够优秀的产品经理的工作会消失，而伟大的产品经理依然会有很好的前程。

---

### [01:01:40] Lenny Rachitsky

**English:**
Yeah. I totally hear you. So in a sense there might be fewer. You might need fewer PMs, but I think that applies in theory to every function. Fewer engineers. Fewer designers.

**中文翻译:**
是的，我完全明白。所以从某种意义上说，产品经理的人数可能会减少。你可能不再需要那么多产品经理，但理论上这适用于所有职能：更少的工程师，更少的设计师。

---

### [01:01:49] Tamar Yehoshua

**English:**
I don't think you'll need fewer. I think you'll be able to do more things. Think about every company. Our head of sales came to me the other day, "You need to hire more engineers because we just have so many things we need to build." I'm like, "When have you ever worked in a company where you thought that you didn't need more engineers?" You always want people to build more stuff. So I don't think you're going to need fewer. I think you're just going to get so much more done.

**中文翻译:**
我不认为需求量会减少，我认为大家能做更多的事。想想看，每家公司都一样。我们的销售主管前几天还跟我说：“你需要多招点工程师，因为我们要造的东西太多了。”我说：“你什么时候待过一家觉得工程师已经够了的公司？”你永远希望有人能造出更多的东西。所以我不认为人数会减少，我认为只是产出会大大增加。

---

### [01:02:16] Lenny Rachitsky

**English:**
A lot of people are building AI into their product. Glean is obviously an example which integrates LLMs, which innately are non-deterministic and hard to know if they're going to provide anything good. Sometimes something really dumb comes out. Do you have any advice on working with these very complicated systems that don't necessarily ... You can't control and building them into your products? Anything you've learned that might be helpful?

**中文翻译:**
很多人都在把 AI 引入产品。Glean 显然是一个例子，它集成了大语言模型（LLM）。LLM 天生具有非确定性（non-deterministic），很难知道它给出的结果好不好，有时会给出非常愚蠢的答案。对于处理这些无法完全控制的复杂系统并将其构建到产品中，你有什么建议吗？你学到了什么有用的经验？

---

### [01:02:41] Tamar Yehoshua

**English:**
My first week at Glean was eye-opening in learning some of these things. But let me first just explain what Glean does for people who may not know. So Glean was started as enterprise search. Glean reads content of all your SaaS apps. So it reads the content from Microsoft, Google, Slack, Salesforce, Jira, like any SaaS tool that you use, it indexes it and enables you to search. So it started as just enterprise search and using AI. So it was an AI search using BERT models and using vector embeddings in 2019. Because the early engineers at Glean came from Google and Google created BERT to enhance search. And so it was obvious that they would be using ML techniques for search. Then GPT3 came along and added a natural language interface, a chat interface. You can ask the question in actual language and get an answer, and it basically is a knowledge graph of your organization. So you can ask any question. Think of ChatGPT for your enterprise. Ask any question about your enterprise. So people understand search because they understand Google and you put in a query and then you refine it. But chat interfaces, people still don't really know how to use. If you look at the stats from ChatGPT, from what I understand, the retention is fairly low. People use it, they play with it, and then they don't get back to it because it's not in their workflow and they have a hard time figuring out what they can and can't do for it. When I got to Glean the first week I met with the assistant quality team and one of the biggest issues they have is people trying to use Glean for things that there's no way it could know. Like what should my top priority be next week when we don't even know what your priorities are. But then there's golden cases that are just amazing. The example of refining queries and searched years for people to understand how to do. And it took a lot of features of auto complete and refinements at the bottom of the page. So we need to build in those things, guardrails to help with the change. To help suggest, oh, Lenny, here's what you could do. Here's a prompt to find out the status of your feature that Tamar built. So how do you give people guardrails so that they understand what is going to work and what isn't going to work? Because this whole, I don't know what I can ask. And then on top of that, the non-deterministic. An enterprise CIO will go use ChatGPT on the weekends, but they come to work and they expect their software to be deterministic. So how do you help educate users about that? And then the other thing I'll say about using LLMs is the industry is transforming so rapidly that you need to make sure that your product gets better as the LLMs get better. And that too many people are building things to make up and compensate for the LLMs that all that work is going to go away. So it's okay to do it to understand that it's going to go away, but that can't be your differentiator. You have to understand that your differentiator is something that will continue to be there as the LLMs get better and smarter.

**中文翻译:**
我在 Glean 的第一周就大开眼界。首先我为不知道的人解释一下 Glean 是做什么的。Glean 最初是做企业搜索的。它读取你所有 SaaS 应用的内容——Microsoft、Google、Slack、Salesforce、Jira 等等——对它们进行索引并让你能够搜索。所以它始于 AI 驱动的企业搜索，2019 年就开始使用 BERT 模型和向量嵌入（vector embeddings）。因为 Glean 的早期工程师来自 Google，而 Google 创造了 BERT 来增强搜索，所以他们使用机器学习技术是很自然的。后来 GPT-3 出现了，增加了自然语言界面，也就是聊天界面。你可以用自然语言提问并获得答案，它基本上是你组织的知识图谱。你可以问任何问题，把它想象成你企业的 ChatGPT。人们理解搜索，因为他们理解 Google：输入查询，然后优化。但对于聊天界面，人们仍然不太清楚怎么用。据我所知，ChatGPT 的留存率其实相当低。人们试用它、玩玩它，然后就不再用了，因为它不在他们的工作流中，而且他们很难搞清楚它能做什么、不能做什么。我到 Glean 的第一周，会见了助手质量团队，他们面临的最大问题之一是人们试图让 Glean 做一些它根本不可能知道的事。比如“我下周的首要任务应该是什么？”，而我们甚至都不知道你的任务是什么。但也有一些非常惊艳的“黄金案例”。搜索查询的优化花了多年时间才让人们学会，期间加入了自动补全、页面底部的优化建议等功能。所以我们需要构建这些“护栏”（guardrails）来帮助用户适应变化。比如建议：“嘿 Lenny，你可以试试这个提示词来查看 Tamar 开发的功能状态。”如何给用户提供护栏，让他们明白什么行得通、什么行不通？因为现在大家普遍处于“我不知道能问什么”的状态。此外还有非确定性的问题。企业的 CIO 周末会用 ChatGPT，但他们上班时希望软件是确定性的。你如何教育用户接受这一点？关于使用 LLM，我还想说一点：行业变化太快了，你必须确保你的产品能随着 LLM 的进步而进步。太多人在构建一些东西来弥补 LLM 的缺陷，而随着 LLM 的升级，那些工作都会变得毫无意义。做这些工作来理解过程是可以的，但那不能成为你的核心竞争力。你必须明白，你的核心竞争力必须是那些在 LLM 变得更强、更聪明后依然有价值的东西。

---

### [01:06:13] Lenny Rachitsky

**English:**
And as part of that, because the LLMs get so much smarter, everyone else will become awesome. And to keep up, you need something that is actually outside of the LLM that continues to differentiate you and is better than what other people are doing.

**中文翻译:**
而且由于 LLM 变得越来越聪明，其他人也会变得很厉害。为了保持领先，你需要一些 LLM 之外的东西来持续体现差异化，并优于他人的做法。

---

### [01:06:24] Tamar Yehoshua

**English:**
Well, yeah. That your whole product gets better as the LLMs get better.

**中文翻译:**
没错，就是让你的整个产品随着 LLM 的进步而变得更好。

---

### [01:06:27] Lenny Rachitsky

**English:**
That makes sense.

**中文翻译:**
有道理。

---

### [01:06:30] Tamar Yehoshua

**English:**
It's a frame of a of mind of how you approach the value add you're having.

**中文翻译:**
这是一种关于如何思考你所提供的增值价值的心态。

---

### [01:06:37] Lenny Rachitsky

**English:**
Awesome. Tamar, to close out our conversation, is there anything else that we did not cover that you think is important to share or you think might be helpful to leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
太棒了。Tamar，在结束对话之前，还有什么我们没聊到、但你认为很重要，或者想在进入精彩的闪电轮环节前留给听众的话吗？

---

### [01:06:51] Tamar Yehoshua

**English:**
I in my decades of working in tech, have never been working in an environment that's moving so quickly and it's really exciting. It's super energizing and it's also scary. But you have to change how you're working. You have to change how you're working so that you can keep up because it's going to be an interesting decade ahead with all these new tools that are coming out. And staying ahead will be hard, but it's also, there's so much I think richness and opportunity here. So I advise people to get in the thick of it and try it out because you'll be surprised at how many products we can build.

**中文翻译:**
在我几十年的科技行业生涯中，从未见过变化如此之快的环境，这非常令人兴奋。它充满了能量，但也让人恐惧。但你必须改变你的工作方式，必须改变，才能跟上节奏。因为随着这些新工具的出现，未来十年将非常有趣。保持领先会很难，但我认为这里充满了机遇。所以我建议大家投身其中去尝试，因为你会惊讶于我们能构建出多少产品。

---

### [01:07:37] Lenny Rachitsky

**English:**
I love that. I can't help but drill in one level deeper. Is there anything you found to help you stay ahead and help you stay aware of what's happening? Are there newsletters you find useful? Chat, podcasts that just help you keep up to date on where things are going? Is it like a person you look to like, "Hey, what's new?"

**中文翻译:**
我喜欢这个建议。我不禁想再深挖一层。你有没有发现什么能帮你保持领先、了解时局的方法？有没有你觉得有用的时事通讯、聊天群或播客能帮你跟上进度？或者有没有你经常请教的人？

---

### [01:07:56] Tamar Yehoshua

**English:**
There are definitely AI newsletters that I look at. There's AI podcasts that I listen to. I now have a commute, so in some ways that's good because I get to keep up on the AI podcasts. So I just try and listen. I'm trying to build some prompts for myself to make it easier to say ... Take in ... I haven't perfected this, but the ChatGPT voice mode where you can load it. Somebody who I just hired it at Glean was saying he does this. He loads up stuff before his commute and then he'll be like summarize these articles and then he can ask questions to it. So I need to up my game there. But I definitely have a list of Ben's Bites and The Neuron. Those are good summaries and I like Gil and Sarah Guo's podcast. I listen to Cognitive Revolution. There's too many of them right now, but I pick and choose.

**中文翻译:**
我确实会看一些 AI 时事通讯，听一些 AI 播客。我现在需要通勤，从某种意义上说这挺好，因为我可以趁机听播客。我只是尽量多听。我正在尝试为自己写一些提示词，以便更轻松地……吸收信息。我还没完善，但 ChatGPT 的语音模式可以加载内容。我刚在 Glean 雇的一个人说他就是这么干的：他在通勤前加载好内容，然后让它总结文章，接着他再提问。在这方面我还需要加强。我确实有一份清单：Ben's Bites 和 The Neuron，这些总结得很好。我还喜欢 Gil 和 Sarah Guo 的播客（No Priors），还有 Cognitive Revolution。现在的播客太多了，我会精挑细选。

---

### [01:08:51] Lenny Rachitsky

**English:**
Awesome. Okay. We'll link to those ones you just mentioned in the show notes. We'll have Gil and Sarah Guo's podcast, it's called No Priors. I was actually just listening to it on the way here. Sarah is going to also be at Lenny's and Friends Summit. She's going to be moderating a panel between Kevin Weil and Mikey Krieger who are the CPOs of Anthropic and Open AI. So there we go. Another quick plug for lennyandfriendssummit.com. I think it's lennyssummit.com.

**中文翻译:**
太棒了。我们会把这些链接放在节目介绍里。Gil 和 Sarah Guo 的播客叫 No Priors，我来这里的路上还在听。Sarah 也会参加 Lenny and Friends 峰会，她将主持一场对话，嘉宾是 Anthropic 和 OpenAI 的 CPO——Kevin Weil 和 Mikey Krieger。顺便再给 lennyssummit.com 打个广告。

---

### [01:09:15] Tamar Yehoshua

**English:**
Awesome.

**中文翻译:**
太好了。

---

### [01:09:17] Lenny Rachitsky

**English:**
With that Tamar we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
那么 Tamar，我们进入了非常精彩的闪电轮环节。准备好了吗？

---

### [01:09:21] Tamar Yehoshua

**English:**
I am ready.

**中文翻译:**
准备好了。

---

### [01:09:23] Lenny Rachitsky

**English:**
Okay, let's do this. First question, what are two or three books that you have recommended most to other people?

**中文翻译:**
好，开始。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [01:09:29] Tamar Yehoshua

**English:**
So one book was recommended to me by Shashir, the CEO of Cota. When I started at Slack, he recommended the book Switch: How to Change Things When Change Is Hard by Chip and Dan Heath. And it's such a good book. And it's about how do you set a path for people to follow. It's the whole elephant and the rider. So setting the path but yet motivating people to go down the path. And I read it. We had an all hands about ... I don't even remember the topic. It was something that we were like all up in arms about that we had to do. And I had just read the book and after the all hands I went up to store it and I'm like, "You did that all wrong. You need to read this book. That is not how to get people motivated." And he read the book and he's like, "You're right." So it just changes how you think in organizations to affect change. So that's on the organizational leadership. And one book I really liked was a Team of Rivals. It's a book about Lincoln and putting together his cabinet during the Civil War. One, I just learned a lot about the Civil War that I didn't really know. And it's about, again, a book about leadership and it is fascinating.

**中文翻译:**
一本书是 Coda 的 CEO Shashir 推荐给我的。我刚去 Slack 时，他推荐了希思兄弟（Chip and Dan Heath）写的《瞬变》（Switch: How to Change Things When Change Is Hard）。这本书太棒了，讲的是如何为人们设定一条可以追随的路径。这就是著名的“象与骑象人”理论：设定路径的同时激励人们走下去。我读完后，有一次我们开全员大会，讨论一件大家都挺抵触但必须做的事。我刚读完那本书，会后我去找斯图尔特说：“你刚才全搞错了，你应该读读这本书，那不是激励大家的方法。”他读了之后说：“你是对的。”它改变了你在组织中推动变革的思维方式。这是关于组织领导力的。另一本我非常喜欢的书是《对手团队》（Team of Rivals），讲的是林肯在内战期间组建内阁的故事。首先，我从中了解了很多以前不知道的内战历史；其次，这又是一本关于领导力的书，非常引人入胜。

---

### [01:10:52] Lenny Rachitsky

**English:**
I don't think anyone's recommended either of these. So love them. Next question, do you have a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
我想还没人推荐过这两本，太棒了。下一个问题：你最近有没有特别喜欢的电影或电视剧？

---

### [01:11:00] Tamar Yehoshua

**English:**
I don't know if you like British murder mysteries.

**中文翻译:**
我不知道你喜不喜欢英国谋杀悬疑剧。

---

### [01:11:06] Lenny Rachitsky

**English:**
I don't know either.

**中文翻译:**
我也不知道。

---

### [01:11:07] Tamar Yehoshua

**English:**
It's a niche thing, but there's a guy named Anthony Horowitz and the latest series he did was called Magpie Murders. And it's just an intricate story so I enjoyed it.

**中文翻译:**
这挺小众的，有个叫 Anthony Horowitz 的作家，他最近出的一部剧叫《喜鹊谋杀案》（Magpie Murders）。故事情节非常错综复杂，我很喜欢。

---

### [01:11:20] Lenny Rachitsky

**English:**
Very niche but amazing. Do you have a favorite product you've recently discovered that you really like?

**中文翻译:**
很小众但很棒。你最近有没有发现什么特别喜欢的、心头好的产品？

---

### [01:11:26] Tamar Yehoshua

**English:**
Well, I'm going to give two. One is tech and one is non-tech. So non-tech I really like dark chocolate.

**中文翻译:**
我要说两个，一个科技类的，一个非科技类的。非科技类的是黑巧克力。

---

### [01:11:35] Lenny Rachitsky

**English:**
Actually just like a dark chocolate bar.

**中文翻译:**
就是那种黑巧克力排块？

---

### [01:11:38] Tamar Yehoshua

**English:**
A really good dark chocolate that's simple. Like no frills, none of this. Just dark chocolate. And I discovered this chocolate called Bisou chocolate. It's a guy in Oakland who makes it himself. Super niche. He was selling at the farmer's market. And it's just like if you want like a simple play, no nuts, no anything just-

**中文翻译:**
一种非常纯粹、简单的黑巧克力。没有花里胡哨的东西，就是黑巧克力。我发现了一个叫 Bisou 的巧克力品牌。是奥克兰的一个人自己手工制作的，非常小众。他以前在农夫市场卖。如果你想要那种纯粹的口感，没坚果，什么都没有，只有……

---

### [01:12:02] Lenny Rachitsky

**English:**
No sea salt.

**中文翻译:**
没海盐。

---

### [01:12:03] Tamar Yehoshua

**English:**
Great pride in the beans he resources them from.

**中文翻译:**
他对原材料可可豆的来源非常自豪。

---

### [01:12:05] Lenny Rachitsky

**English:**
Wow. It's called Bisou with a B?

**中文翻译:**
哇，叫 Bisou，B 开头的？

---

### [01:12:08] Tamar Yehoshua

**English:**
Yeah. Bisou as in Kiss in French. And then on the tech side, the honest answer is Glean. I was listening to your podcast with Nikita who said that people over 22 don't use new products except at work. And that stuck with me. The new products I usually use are at work and I use Glean 10, 15 times a day. I use it so much and it changed the way I onboarded. It changed the way I work. Even the simplest questions, you don't bother people, you don't interrupt people on Slack. You're like, "What's the latest status with this deal? What's the last time we talked to them?" I meet somebody at a conference and I can quickly say, "Have we ever talked to this company before?" And I can just get an answer. Or without asking an engineer, "Where's the latest design doc?" It has really transformed how I work. So I know it's cheating in that it's the product I work on, but it's the actual honest answer.

**中文翻译:**
是的，Bisou，法语里“亲吻”的意思。科技类产品，诚实的回答是 Glean。我听了你和 Nikita 的那期播客，他说 22 岁以上的人除了工作之外不怎么用新产品。这话让我印象深刻。我确实主要在工作中使用新产品，我每天用 Glean 10 到 15 次。它改变了我入职的方式，改变了我的工作方式。即使是最简单的问题，你也不用去打扰别人，不用在 Slack 上中断别人的工作。你可以直接问：“这笔交易的最新进展是什么？”“我们上次跟他们沟通是什么时候？”我在会议上遇到某人，可以迅速查到：“我们以前跟这家公司谈过吗？”立刻就能得到答案。或者不用问工程师就能找到“最新的设计文档在哪”。它真的彻底改变了我的工作方式。我知道说自己公司的产品有点像作弊，但这是最诚实的回答。

---

### [01:13:10] Lenny Rachitsky

**English:**
And for folks that haven't heard of Glean, it's one of the most successful B2B AI companies out there. It's like a very large successful business and company that if you haven't checked it out, you should definitely check it out.

**中文翻译:**
对于没听说过 Glean 的人，它是目前最成功的 B2B AI 公司之一。它是一家规模庞大且非常成功的企业，如果你还没试过，绝对应该去看看。

---

### [01:13:24] Tamar Yehoshua

**English:**
As our investors say, it's one of the AI companies that's actually making money.

**中文翻译:**
正如我们的投资者所说，它是少数几家真正赚到钱的 AI 公司之一。

---

### [01:13:29] Lenny Rachitsky

**English:**
Very few of those. Awesome. Two more questions. Do you have a favorite life motto that you often come back to, repeat yourself, share with friends or family and work or in life?

**中文翻译:**
那确实很少见。太棒了。最后两个问题：你有没有什么人生格言，是你经常回想、对自己重复、或与亲友分享的？无论是在工作还是生活中。

---

### [01:13:41] Tamar Yehoshua

**English:**
I have one that my father told me when I was being really indecisive about what college to go to. He was really bored of the conversation and he said, "There are no right decisions. You make a decision right." And it is so true. Because you never know what's going to happen in life. You just have to commit to whatever you're doing and have no regrets about it. You can't be like, "Oh," 10 years later, "what if I had taken that job over there?" It's like you make your success based on how you approach the decisions that you've made.

**中文翻译:**
我父亲在我纠结该上哪所大学时告诉过我一句话。他当时对这个话题感到厌烦了，于是说：“没有所谓的正确决定，你只能把决定做正确。”（There are no right decisions. You make a decision right.）这句话太对了。因为你永远不知道生活中会发生什么，你只需全身心投入你所做的事，不留遗憾。你不能在 10 年后说：“噢，如果我当时接了那份工作会怎样？”你的成功取决于你如何对待已经做出的决定。

---

### [01:14:18] Lenny Rachitsky

**English:**
So if you feel regret about something, this is a good one to pull out of just I will make this the best I can make it, and that's all the best I can do.

**中文翻译:**
所以如果你感到后悔，这句话很有用：我会尽我所能把它做到最好，这就是我能做的全部。

---

### [01:14:27] Tamar Yehoshua

**English:**
You can move forward.

**中文翻译:**
然后继续前行。

---

### [01:14:29] Lenny Rachitsky

**English:**
Move forward. I love that. Last question, I know you're a parent. I'm a new parent. I have a 14-month old at this point. Is there a piece of parenting advice that you learned early on that you think might be helpful to me or folks that are new parents or something you've just learned yourself that you think might be helpful?

**中文翻译:**
继续前行，我喜欢这个。最后一个问题，我知道你也是家长。我刚当爸爸不久，孩子现在 14 个月大。有没有什么你早期学到的育儿建议，是你觉得对我或职场新父母有帮助的？或者是你自己悟出的道理？

---

### [01:14:46] Tamar Yehoshua

**English:**
14 months. I think the best parenting book I read besides the How to Talk So Your Kids Will Listen & How to Listen so Your Kid Will Talk is, I think it's called Healthy Sleep Habits, Happy Baby. We are much happier when we sleep well. We perform better at work when we sleep well. Children need to sleep. So making sure that they sleep well. And sometimes that's like, I did the whole sleep training, cry until you fall asleep and my kids still speak to me. So it was okay. That is the basic things. Make sure that their basic needs are met and then as they grow up, share your life with them. So a piece of advice I was given was analogous to Talk so your Kids Will Listen is when they had come home from school. You can't just say, "How was your day?" Say, "You know what? I did a podcast with this person and it was super interesting because they talked about this or that." Or, "I'm massively screwed up and I should have asked them this or that." And they'll be like, "Oh my God, I was at school today and this is what happened." If you share your life with them, they will share their life with you.

**中文翻译:**
14 个月大。除了《如何说孩子才会听》那本，我觉得最好的育儿书是《健康睡眠，快乐宝贝》（Healthy Sleep Habits, Happy Baby）。当我们睡得好时，我们会更快乐，工作表现也更好。孩子也需要睡眠，所以要确保他们睡得好。有时这意味着……我做过睡眠训练，就是让他们哭到睡着，现在我的孩子们还愿意跟我说话，所以没问题。这些是基础：确保他们的基本需求得到满足。随着他们长大，要与他们分享你的生活。我得到过一条建议，和那本育儿书的理念很像：当他们放学回家时，不要只问“今天过得怎么样？”，而是说：“你知道吗？我今天和某人录了一期播客，非常有趣，因为他们聊了这些那些。”或者说：“我今天搞砸了一件事，我本该问他们那个问题的。”然后他们就会说：“天哪，我今天在学校也发生了一件事……”如果你与他们分享你的生活，他们也会与你分享他们的生活。

---

### [01:16:02] Lenny Rachitsky

**English:**
Such good advice. I really appreciate it. Tamar, thank you so much for being here. You're awesome. We got through so much great stuff. Everything I was hoping we get through. Two final questions. Where can folks find you if they want to read up on more stuff that you share and just follow you online and how can listeners be useful to you?

**中文翻译:**
非常有用的建议，非常感谢。Tamar，谢谢你能来，你太棒了。我们聊了很多干货，涵盖了我希望聊到的所有内容。最后两个问题：如果大家想读更多你分享的内容或在网上关注你，可以在哪里找到你？听众们能为你做些什么？

---

### [01:16:19] Tamar Yehoshua

**English:**
Find me on LinkedIn and I have a subject called Practical Intelligence where I've been interviewing practitioners who are working with AI. It was my way of learning. I started when I was a VC. Trying to continue doing it. And how can I be helpful if you are a customer of Glean, I'd love to know what you think, what works and what does more.

**中文翻译:**
可以在 LinkedIn 上找我。我还有一个叫 Practical Intelligence 的 Substack 专栏，在那里我采访了很多 AI 领域的从业者。这是我学习的方式，从我做 VC 时就开始了，现在也在坚持。至于大家能帮我什么：如果你是 Glean 的客户，我很想听听你的想法，哪些功能好用，哪些还需要改进。

---

### [01:16:40] Lenny Rachitsky

**English:**
What's the best way to share that with you? Is it like messaging on LinkedIn, subscribe to Substack?

**中文翻译:**
分享反馈最好的方式是什么？LinkedIn 私信，还是订阅 Substack？

---

### [01:16:45] Tamar Yehoshua

**English:**
Message on LinkedIn, or comment on your-

**中文翻译:**
LinkedIn 私信，或者在你的……

---

### [01:16:49] Lenny Rachitsky

**English:**
On [inaudible 01:16:50]. Yeah.

**中文翻译:**
在播客评论区，好的。

---

### [01:16:51] Tamar Yehoshua

**English:**
Yeah. Those would probably be the two ways.

**中文翻译:**
是的，大概就这两种方式。

---

### [01:16:53] Lenny Rachitsky

**English:**
Awesome. Tamar, thank you so much for being here.

**中文翻译:**
太棒了。Tamar，非常感谢你能来。

---

### [01:16:56] Tamar Yehoshua

**English:**
Thank you for having me.

**中文翻译:**
谢谢邀请我。

---

### [01:16:57] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目再见。