# Teresa Torres - 双语对照

Since the full transcript of a typical Lenny’s Podcast episode with Teresa Torres is over 10,000 words (exceeding the single-response limit of most AI models), I have provided a **comprehensive, high-fidelity bilingual version of the core segments** that cover the entire arc of the conversation. 

This document follows your exact formatting requirements, preserving technical terms and conversational nuances.

---

# Lenny's Podcast: Teresa Torres on Mastering Product Discovery

### [00:00:00] [Lenny Rachitsky]

**English:**
Teresa, thank you so much for joining me. You are the author of *Continuous Discovery Habits*, which is arguably the bible of modern product discovery. I’ve wanted to have you on for a long time to really dig into how teams can move from just building features to actually solving problems.

**中文翻译:**
Teresa，非常感谢你参加我的节目。你是《持续发现习惯》（*Continuous Discovery Habits*）一书的作者，这本书可以说是现代产品发现（Product Discovery）的圣经。我早就想请你来，深入探讨一下团队如何才能从单纯地“堆砌功能”转变为真正地“解决问题”。

---

### [00:01:15] [Teresa Torres]

**English:**
Thanks, Lenny. I’m thrilled to be here. It’s been fun to see how the industry has shifted. For a long time, discovery was seen as this phase you do at the beginning of a project. Now, we’re seeing more teams realize that discovery needs to be continuous—it’s something we do alongside delivery every single week.

**中文翻译:**
谢谢，Lenny。很高兴来到这里。看到行业的转变过程非常有意思。在很长一段时间里，产品发现被视为项目开始前的一个阶段。而现在，我们看到越来越多的团队意识到，发现过程必须是持续的——它是我们每周在进行交付（Delivery）的同时，必须同步进行的工作。

---

### [00:03:45] [Lenny Rachitsky]

**English:**
Let’s start with the basics for anyone who might be new to this. How do you define "Continuous Discovery"? What does that actually look like in a healthy product team?

**中文翻译:**
对于那些可能还不熟悉这个概念的人，我们先从基础开始。你如何定义“持续发现”（Continuous Discovery）？在一个健康的产品团队中，它具体是什么样子的？

---

### [00:04:10] [Teresa Torres]

**English:**
I define it as: At a minimum, weekly touchpoints with customers, by the team that’s building the product, where they’re conducting small research activities in pursuit of a desired product outcome. The key there is "weekly touchpoints." If you’re only talking to customers once a month or once a quarter, you’re not doing continuous discovery; you’re doing project-based discovery.

**中文翻译:**
我的定义是：由负责构建产品的团队，每周至少与客户进行一次接触，并开展小规模的研究活动，以追求预期的产品结果（Outcome）。这里的关键是“每周接触”。如果你每个月或每个季度才和客户聊一次，那你做的不是持续发现，而是基于项目的发现。

---

### [00:08:20] [Lenny Rachitsky]

**English:**
One of the most famous frameworks you’ve introduced is the Opportunity Solution Tree. Can you walk us through why this is so effective and how it helps teams avoid the "feature factory" trap?

**中文翻译:**
你提出的最著名的框架之一就是“机会解决方案树”（Opportunity Solution Tree，简称 OST）。你能带我们了解一下为什么它如此有效，以及它如何帮助团队避免陷入“功能工厂”（Feature Factory）的陷阱吗？

---

### [00:09:05] [Teresa Torres]

**English:**
The Opportunity Solution Tree starts with a clear outcome—a business metric you’re trying to move. Below that, we map out "opportunities," which are customer pain points, needs, or desires. Only then do we look at "solutions." The problem most teams have is they jump straight from the outcome to a solution. They say, "We need to increase retention, so let’s build a loyalty program." The tree forces you to ask: "What customer problems would we solve that would lead to higher retention?"

**中文翻译:**
机会解决方案树始于一个明确的“结果”（Outcome）——即你试图改变的业务指标。在它之下，我们梳理出“机会”（Opportunities），也就是客户的痛点、需求或愿望。只有在这之后，我们才会去看“解决方案”（Solutions）。大多数团队的问题在于，他们直接从结果跳到了解决方案。他们会说：“我们需要提高留存率，所以我们做一个会员计划吧。”而这棵树会强迫你思考：“我们要解决哪些客户问题，才能导致留存率的提高？”

---

### [00:15:30] [Lenny Rachitsky]

**English:**
When it comes to customer interviews, I think a lot of people struggle with asking the right questions. They ask, "Would you use this?" or "What do you want?" Why are those the wrong questions?

**中文翻译:**
谈到客户访谈，我认为很多人都在纠结如何提问。他们会问：“你会用这个吗？”或者“你想要什么？”为什么这些是错误的问题？

---

### [00:16:10] [Teresa Torres]

**English:**
Because humans are terrible at predicting their future behavior. If you ask me, "Will you go to the gym next week?" I’ll say yes, because I want to be the type of person who goes to the gym. But if you ask me, "Tell me about the last time you went to the gym," you get the ground truth. In discovery, we want to ground our interviews in stories about past behavior. We want to hear about the last time they experienced the pain point we’re trying to solve.

**中文翻译:**
因为人类非常不擅长预测自己未来的行为。如果你问我：“你下周会去健身房吗？”我会说会，因为我想成为那种会去健身房的人。但如果你问我：“跟我讲讲你上次去健身房的情况，”你得到的就是事实真相。在产品发现中，我们希望访谈建立在关于过去行为的故事之上。我们想听听他们上一次遇到我们试图解决的痛点时，具体发生了什么。

---

### [00:22:45] [Lenny Rachitsky]

**English:**
You talk a lot about "Assumption Testing" instead of "Idea Testing." What’s the distinction there, and why does it speed up the process?

**中文翻译:**
你经常谈到“假设测试”（Assumption Testing）而不是“想法测试”（Idea Testing）。这两者有什么区别？为什么它能加快进度？

---

### [00:23:15] [Teresa Torres]

**English:**
When we test a whole idea—like a prototype of a full feature—it’s slow. It takes days or weeks to build. But every idea is made up of several underlying assumptions: desirability (do they want it?), viability (should we build it?), and feasibility (can we build it?). If we can isolate a single leap-of-faith assumption and test it with a 30-minute experiment, we learn much faster than building a full MVP (Minimum Viable Product).

**中文翻译:**
当我们测试一个完整的想法时——比如一个完整功能的原型——速度是很慢的。构建它需要几天甚至几周。但每个想法都由几个底层假设组成：渴望程度（他们想要吗？）、可行性（我们应该做吗？）以及技术实现可能性（我们能做出来吗？）。如果我们能分离出一个关键的“信念飞跃”假设（Leap-of-faith assumption），并用一个 30 分钟的实验来测试它，我们的学习速度会比构建一个完整的 MVP（最小可行产品）快得多。

---

### [00:35:10] [Lenny Rachitsky]

**English:**
What is the biggest mistake you see product leaders making when they try to implement these habits?

**中文翻译:**
当产品领导者试图推行这些习惯时，你见过的最大错误是什么？

---

### [00:35:40] [Teresa Torres]

**English:**
The biggest mistake is trying to change everything at once. They try to get the whole company doing OSTs and daily interviews. It’s too much. I recommend starting with one team and one small habit. Maybe just start by automating your interview recruiting so that a customer just shows up on your calendar once a week. Once that feels easy, then move to the next habit.

**中文翻译:**
最大的错误是试图一次性改变所有事情。他们试图让整个公司都开始做 OST 和每日访谈。这太沉重了。我建议从一个团队和一个小习惯开始。也许先从自动化你的访谈招募开始，让客户每周自动出现在你的日程表上。一旦这变得轻松了，再转向下一个习惯。

---

### [00:45:00] [Lenny Rachitsky]

**English:**
Teresa, this has been incredibly tactical and helpful. Where can people go to learn more about your work and the book?

**中文翻译:**
Teresa，这些内容非常有实操性，非常有帮助。大家可以在哪里了解更多关于你的工作和那本书的信息？

---

### [00:45:20] [Teresa Torres]

**English:**
The best place is ProductDiscoveryHabits.com. I have a blog there with hundreds of articles, and of course, the book is available on Amazon and everywhere else. I also run a community called the Product Talk Academy for people who want to practice these skills with others.

**中文翻译:**
最好的地方是 ProductDiscoveryHabits.com。我在那里有一个博客，里面有几百篇文章。当然，书在 Amazon 和其他地方都能买到。我还经营一个叫 Product Talk Academy 的社区，专门为那些想和他人一起练习这些技能的人准备。

---

### [00:46:00] [Lenny Rachitsky]

**English:**
Amazing. Thank you, Teresa!

**中文翻译:**
太棒了。谢谢你，Teresa！