# Tim Holley - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Tim Holley, VP of Product at Etsy.

---

### (00:00:00) Tim Holley

**English:**
When the CDC mandated face masks in early April 2020, that's when essentially we went to sleep one day with our typical April traffic, typical April sales, and then it was Black Friday overnight. And in part, because nobody knew where to find face masks. Our sellers are incredibly astute business people. And if you had been making wedding dresses, and you know how to sew, and you've got material, and you've got a bit of time, making a mask is quite a simple task. And so we just saw this huge surge of demand, and then supply rising to meet it.

**中文翻译:**
当美国疾控中心（CDC）在 2020 年 4 月初强制要求佩戴口罩时，基本上我们前一天睡觉时还是典型的 4 月流量和销售额，第二天醒来就变成了“黑色星期五”般的景象。部分原因是当时没人知道去哪里买口罩。我们的卖家是非常敏锐的商人。如果你以前是做婚纱的，你会缝纫，有材料，还有点时间，那么做个口罩其实是非常简单的任务。于是我们看到了需求的巨大激增，随后供应也迅速跟进以满足需求。

---

### (00:00:37) Tim Holley

**English:**
And we did something that as far as I know, we've never done in Etsy's past, which is we put out a call to our sellers to say, "Now's the time. Now's the time to make face masks if you can." And so it felt like this is our time to shine, to really help sellers continue to make sales, to help buyers find this critical item that they were looking for. And then from there, things kept going, and we really worked hard to make sure that the story was not just about face masks for our buyers, that they understood that Etsy's a place for so many different categories and so many different items.

**中文翻译:**
我们做了一件据我所知在 Etsy 历史上从未做过的事，那就是向我们的卖家发出号召说：“现在是时候了。如果你能做口罩，现在就是行动的时候。”所以感觉这是我们大放异彩的时刻，真正帮助卖家继续获得销售额，同时也帮助买家找到他们急需的关键物品。从那时起，业务持续增长，我们努力确保对买家而言，故事不仅仅关乎口罩，让他们明白 Etsy 是一个拥有众多不同品类和商品的平台。

---

### (00:01:12) Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard win experiences, building and growing today's most successful products. Today my guest is Tim Holley. Tim is VP of product at Etsy, where he's been for over 10 years, and has helped grow Etsy from around 500 million in GMV to over 13 billion in GMV. This episode is for anyone working on marketplace, or looking for ideas to increase growth, or looking for advice on how to change your internal culture. We get into the big cultural transition that Etsy went through that took them to the next level. Lots of examples of product changes that helped them with conversion, acquisition, and retention. Plus how Etsy organizes their teams, thinks about supply versus demand dynamics, how Etsy got started with growing their initial supply, and also their initial demand. Plus a bunch of frameworks and hiring advice, and so much more. Enjoy this episode with Tim Holley after a short word from our sponsors.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在打造和发展当今最成功产品过程中辛苦换来的经验。今天的嘉宾是 Tim Holley。Tim 是 Etsy 的产品副总裁，他在那里工作了 10 多年，见证并帮助 Etsy 的 GMV（商品交易总额）从约 5 亿美元增长到超过 130 亿美元。这一集适合任何从事双边市场（Marketplace）工作、寻找增长思路或寻求如何改变内部文化建议的人。我们会深入探讨 Etsy 经历的重大文化转型，正是这次转型将他们推向了新的高度。我们还会分享许多帮助提升转化、获客和留存的产品变更案例。此外，还会聊到 Etsy 如何组织团队、如何思考供需动态、Etsy 最初是如何增长供应和需求的，以及一系列框架、招聘建议等等。在听完赞助商的简短介绍后，请尽情欣赏与 Tim Holley 的这一集。

---

### (00:02:07) Lenny

**English:**
This episode is brought to you by productroadmap.ai and Ignition. Productroadmap.ai is the first AI roadmapping suite. It helps ensure roadmaps drive revenue, by instantly aligning product with your sales and marketing teams to capture upsell opportunities. Built by early leaders from [inaudible] and Craft, it automatically identifies feature gaps from your CRM data and your customer conversations, adds them to shareable roadmaps, easily prioritized by revenue impact, and then seamlessly closes the loop with sales reps via targeted notifications when feature gaps are closed. As part of Ignition's broader go-to-market operating system, productroadmap.ai can also help create better handoffs and collaboration with product marketing teams, by giving both teams the tools to research, plan, orchestrate, and measure the process of building products and going to market. Packed with integrations, AI automation, and communication tools, it's truly a one-stop shop for product and marketing to bring things from concept to launch. To sign up, go to productroadmap.ai, and use promo code Lenny to get 75% off your first year.

**中文翻译:**
本集由 productroadmap.ai 和 Ignition 赞助播出。productroadmap.ai 是首个 AI 路线图套件。它通过即时对齐产品与销售及营销团队，捕捉增销机会，确保路线图能够驱动收入增长。它由来自 [听不清] 和 Craft 的早期领导者打造，能自动从你的 CRM 数据和客户对话中识别功能差距，并将其添加到可共享的路线图中，根据收入影响轻松排列优先级。当功能差距被弥补时，它会通过定向通知与销售代表无缝完成闭环。作为 Ignition 更广泛的 GTM（进入市场）操作系统的一部分，productroadmap.ai 还能通过为产品和营销团队提供调研、规划、编排和衡量产品构建及上市流程的工具，帮助双方实现更好的交接与协作。它集成了多种功能、AI 自动化和沟通工具，是产品和营销团队从概念到发布的真正一站式平台。注册请访问 productroadmap.ai，使用优惠码 Lenny 即可享受首年 2.5 折优惠。

---

### (00:03:14) Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B testing platform built by Airbnb alums for modern growth teams. Companies like DraftKings, Zapier, ClickUp, Twitch, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern growth team stack. This leads to wasted time building internal tools, or trying to run your own experiments through a clunky marketing tool. When I was at Airbnb, one of the things that I loved most about working there was our experimentation platform, where I was able to slice and dice data by device types, country, user stage. Eppo does all that and more, delivering results quickly, avoiding annoying prolonged analytic cycles, and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click through metrics, and instead use your north star metrics like activation, retention, subscription, and payments. Eppo supports tests on the front end, on the backend, email marketing, even machine learning claims. Check out Eppo at geteppo.com. That's geteppo.com, and 10X your experiment velocity.

**中文翻译:**
本集由 Eppo 赞助播出。Eppo 是由 Airbnb 前员工为现代增长团队打造的下一代 A/B 测试平台。像 DraftKings、Zapier、ClickUp、Twitch 和 Cameo 这样的公司都依赖 Eppo 来驱动他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈完美集成。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具运行实验。我在 Airbnb 工作时，最喜欢的一点就是我们的实验平台，我可以在那里按设备类型、国家、用户阶段对数据进行多维分析。Eppo 不仅能做到这些，还能快速交付结果，避免令人烦恼的漫长分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而使用激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、邮件营销甚至机器学习声明的测试。请访问 geteppo.com 查看 Eppo，让你的实验速度提升 10 倍。

---

### (00:04:24) Lenny

**English:**
Tim, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
Tim，非常感谢你能来。欢迎来到我们的播客。

---

### (00:04:28) Tim Holley

**English:**
Thank you for having me on, Lenny, really appreciate it. Looking forward to it.

**中文翻译:**
谢谢你的邀请，Lenny，非常感激。我很期待这次对话。

---

### (00:04:30) Lenny

**English:**
I'm looking forward to it even more. So you've been at Etsy for I think over 10 years, although I did notice that you left for a year and ended up leading product at SoulCycle. So first of all, what is that about? What happened there?

**中文翻译:**
我更期待。你在 Etsy 待了大概 10 多年，但我注意到你曾离开过一年，去 SoulCycle 担任产品负责人。所以首先，那是怎么回事？那里发生了什么？

---

### (00:04:43) Tim Holley

**English:**
Yeah, at the time, I'd been at Etsy for over six years, and I just had the itch. I wanted to go work on a different product, build different things, experience different industry. Along, had a theory that working on the proactive side of healthcare, meaning fitness and wellness, is how you achieve better outcomes. And it felt like SoulCycle was a really interesting way to do that. Pretty well-known brand, high street presence in many cities. Could you affect change through that? Ultimately realized it wasn't a place that I wanted to spend a ton of time and energy. And so through a lot of soul-searching, grown, I know I found my way back to Etsy, really anchoring on three things. One, working on a product that you care about that adds value to other people's lives. And so what we do every day at Etsy is we help our sellers make sales, and that's really meaningful for the vast majority of them. It's reaching an audience that they wouldn't be able to reach. And so that feels like a really great thing to get up every morning and work on.

**中文翻译:**
是的，当时我在 Etsy 已经待了六年多，我只是有点“心痒”。我想去尝试不同的产品，构建不同的东西，体验不同的行业。我一直有一个理论，认为从事预防性医疗（即健身和健康领域）是实现更好结果的方式。SoulCycle 似乎是一个非常有趣的切入点。它是一个知名品牌，在许多城市都有实体店。你能通过它带来改变吗？最终我意识到，那并不是我想投入大量时间和精力的地方。经过一番深刻的反思，我回到了 Etsy，主要基于三点：第一，从事一个你真正关心且能为他人生活增值的产品。在 Etsy，我们每天都在帮助卖家实现销售，这对绝大多数卖家来说非常有意义。这让他们接触到了原本无法触及的受众。所以，每天早上起床为之奋斗是一件非常棒的事情。

---

### (00:05:46) Tim Holley

**English:**
And so that's maybe the business and the product side, and the other side is people. It might sound a little twee, but just working with people who you can learn from and who you respect, and ultimately can have fun working with, it matters a ton. We spend a lot of time of our days and our lives at work, and so doing it with people who you really value, it's awesome. I have one memory that we used to have an engineer who used to be a standup comedian, and so that really pushed the boundaries of what a standup meant every day. And it was always a little fun, a little exciting. You never quite knew what you were going to get. And so just little things like that, they make the work life really, really great.

**中文翻译:**
这可能是业务和产品方面的原因，另一方面是人。这听起来可能有点矫情，但能与那些你可以向其学习、你所尊敬且能一起愉快工作的人共事，这非常重要。我们生命中大部分时间都在工作，所以和那些你真正看重的人在一起工作是很棒的。我记得我们曾有一位工程师以前是脱口秀演员，这真的打破了每天“站会”（Standup）的定义。那总是很有趣，有点令人兴奋，你永远不知道会发生什么。正是这些小事让工作生活变得非常精彩。

---

### (00:06:25) Lenny

**English:**
That's hilarious. I never thought it that way. I feel like every standup needs a standup comedian in their standup. Sounds like that should be part of agile. We should need to change the manifesto. So I've always seen the Etsy journey from the outside, and so there's a few things that I've always wanted to dig into. One is I just remember this New York Times story back in the day when your current CEO Josh Silverman joined, and it felt like a huge moment in the history of Etsy, where it feels like it just kind of transitioned from this touchy feely, everyone loves each other moment to just like, "Hey guys, we got to build a real business here that's sustainable." And it feels like many startups have to go through that transition where it's like, "Nothing's ever going to change. It's going to be so we're all family here," to just, "Things have to change. This isn't working." I'm curious what that was like living through that.

**中文翻译:**
太搞笑了。我从没那样想过。我觉得每个“站会”都需要一个脱口秀演员。听起来这应该成为敏捷开发（Agile）的一部分，我们应该修改敏捷宣言。我一直从外部观察 Etsy 的历程，有几件事我一直想深入了解。其中之一是，我记得现任 CEO Josh Silverman 加入时《纽约时报》的一篇报道。那感觉是 Etsy 历史上的一个重大时刻，公司从那种“感性、大家互亲互爱”的状态转变为“嘿伙计们，我们需要建立一个可持续的真实业务”。感觉许多初创公司都要经历这种转型：从“一切都不会改变，我们都是一家人”到“必须做出改变，现在的模式行不通了”。我很想知道身处其中的感受是怎样的。

---

### (00:07:15) Tim Holley

**English:**
Yeah, I mean the first thing I'll say is it was a hard transition, and I was personally fortunate in the sense that the transition you're speaking of in 2017 also happened to coincide with rounds of layoffs. And I was super fortunate that I didn't lose my job, so I don't want to presuppose that my version of hard is the same as another person's version of hard. But I think a lot of us, and myself included, we had a lot of our identity tied up in Etsy and what we're doing, a really deep passion for the mission of the business and what we're trying to achieve. I just mentioned helping small independent sellers. And just to be clear, that hasn't gone away. I think that that's something we've been really successful at pulling through as a line that was true 10 years ago and is still true today. But it was a time when we were really forced to rethink a lot of how we worked and what we worked on.

**中文翻译:**
是的，首先我想说那是一次艰难的转型。我个人比较幸运，因为你提到的 2017 年那次转型恰好伴随着几轮裁员。我非常幸运没有丢掉工作，所以我不想假设我所经历的“艰难”与别人的“艰难”是一样的。但我想我们中的许多人，包括我自己，都把个人身份与 Etsy 以及我们所做的事情紧紧联系在一起，对公司的使命和目标有着极深的热情。我刚才提到了帮助独立小卖家，需要明确的是，这一点从未改变。我认为我们非常成功地延续了这一主线，它在 10 年前是真实的，今天依然如此。但在那个时期，我们确实被迫重新思考我们的工作方式和工作内容。

---

### (00:08:12) Tim Holley

**English:**
Just to use a small example, we had had a pretty entrenched consensus-based culture, where we would really debate a lot of decisions and a lot of features. And on the one hand, I think that that does lead to good outcomes, right? Thoughtful products that have a lot of viewpoints really baked into the core of the thinking. On the other hand, not fast. When you have your identity tied up in the company and what you do, and then you're kind of being asked or you realize that you need to change how you're working, it can feel pretty existential. It's really cutting to the core of who you are and things that you hold really true. The reality is it's a business, and we needed to get faster at launching features, improving the experience, and ultimately, having a predictable way to drive GMS, gross merchandise sales, which is our north star KPI. And so it definitely took some time to work through that, but we got to a good place, and the results over the last few years to some degree speak for themselves. But it was a testing and trying time for sure.

**中文翻译:**
举个小例子，我们曾有一种根深蒂固的“共识驱动”文化，我们会对许多决策和功能进行激烈的辩论。一方面，我认为这确实能带来好的结果，对吧？产品经过深思熟虑，核心理念中融入了多种观点。但另一方面，速度不快。当你把个人身份与公司和工作绑定，然后被要求或者意识到需要改变工作方式时，这会让人感到一种“存在危机”。这触及了你作为一个人的核心以及你所坚信的价值观。但现实是，这是一家企业，我们需要更快地发布功能、改善体验，并最终以一种可预测的方式驱动 GMS（商品交易总额），这是我们的北极星 KPI。所以确实花了一些时间才度过那个阶段，但我们最终达到了一个很好的状态，过去几年的成果在某种程度上说明了一切。但那确实是一段充满考验和艰辛的时期。

---

### (00:09:20) Lenny

**English:**
I'm always curious how these changes play out and what works in making change. Is there something that you remember that Josh did well or that leaders did well to help that transition?

**中文翻译:**
我一直很好奇这些变革是如何展开的，以及什么样的方法在推动变革中有效。你是否记得 Josh 或其他领导者在帮助转型方面做得特别好的地方？

---

### (00:09:29) Tim Holley

**English:**
One thing that is just such a standout is having... And I mentioned GMS as our north star KPI, just having that, being absolutely front and center, being the drumbeat that we talk about in every meeting, the measuring stick that we measure the success of launches against. And maybe it's a bit surprising, but we didn't have that type of clarity in the past. And so rallying everyone around that. And you might not pay into it directly. You might pay into it through one or two levels of abstraction, but you're still clearly aligned with what the company's trying to achieve. And that was something that was a really stark difference, and I think that helped. It helped the prioritization discussion a lot. If you can't really articulate why this thing matters to driving GMS and the type of timeframe that we're talking about, be it a quarter or 12 months out, and different projects will contribute in different ways. But that was just one huge standout, and that's been a drumbeat over the years that let's continue to stay focused on that as a metric.

**中文翻译:**
最突出的一点就是……我提到过 GMS 是我们的北极星 KPI，让它绝对处于核心地位，成为每次会议都会讨论的主旋律，成为衡量每次发布是否成功的标尺。这可能有点令人惊讶，但我们过去并没有这种清晰度。所以，让每个人都围绕这个目标团结起来。你可能不是直接贡献于它，而是通过一两个抽象层级间接贡献，但你依然清晰地与公司的目标保持一致。这是一个非常显著的变化，我认为它很有帮助。它极大地辅助了优先级的讨论。如果你无法清晰说明某件事为什么对驱动 GMS 重要，以及在什么时间范围内（是一个季度还是 12 个月）起作用，那么它就很难排上优先级。不同项目贡献方式不同，但坚持以 GMS 为核心指标是这些年来的主旋律，让我们能持续保持专注。

---

### (00:11:04) Tim Holley

**English:**
The other thing to me is bringing an outside in perspective, really benchmarking against your competitors and your competitive set. Don't get me wrong, I think Etsy is a unique marketplace. Our sellers are independent sellers. They sell unique items. The reality though is that our buyers are shopping all over the internet. They're shopping on High Street, they're shopping in different places. And so we have to be aware of the broader context of where they're spending their dollars helps us make better decisions over time. And so on the one hand, there is no one-to-one direct competitor to Etsy. But there are other businesses and other brands that are competing for eyeballs or wallets that we need to be aware of. And bringing that into the discussion was a really helpful one that helped ground us in the overall dynamics of what buyers are doing, where they're spending their money, and how they think about us.

**中文翻译:**
对我来说，另一件事是引入“由外而内”的视角，真正与竞争对手和竞争环境进行基准对比。别误会，我认为 Etsy 是一个独特的市场。我们的卖家是独立的，卖的是独特的商品。但现实是，我们的买家在整个互联网上购物。他们在商业街购物，在不同的地方购物。因此，我们必须意识到买家消费的大背景，这有助于我们做出更好的决策。虽然一方面 Etsy 没有一对一的直接竞争对手，但还有其他企业和品牌在争夺用户的注意力和钱包，我们需要意识到这一点。将这些引入讨论非常有帮助，让我们能够立足于买家行为、消费去向以及他们如何看待我们的整体动态。

---

### (00:11:28) Lenny

**English:**
Is there anything else you took away as a leader from watching that shift, that you bring to making change, transitioning people to working in a different way?

**中文翻译:**
作为一名领导者，从那次转型中你还学到了什么可以用于推动变革、引导人们以不同方式工作的经验吗？

---

### (00:11:36) Tim Holley

**English:**
Definitely focus on a clear KPI that the teams can rally around. That's one. The other is... And I respect Josh immensely on his ability to tell a really clear narrative and use that consistently over time. The old adage of you need to say something three times before people understand it. I would wager you need to say it another three times before they internalize it. And having that be part of the day-to-day conversation, it seems like such a small thing, but it adds up to having clarity on goal, the KPI point, and then clarity on why, the narrative point. If you can marry those two things, I think that's an incredibly powerful combination.

**中文翻译:**
首先一定要专注于一个团队可以围绕其团结起来的清晰 KPI。其次是……我非常敬佩 Josh 讲述清晰叙事并长期坚持使用的能力。俗话说，一件事你得说三遍别人才能理解；我敢打赌，你得再说三遍他们才能内化。让这些内容成为日常对话的一部分，这看起来是件小事，但它能累积成对目标的清晰认识（KPI 点）以及对原因的清晰认识（叙事点）。如果你能将这两者结合起来，我认为那将是一个极其强大的组合。

---

### (00:12:15) Lenny

**English:**
While we're on this topic, I'm curious what Etsy's values are. I imagine you've codified a few, we call them core values at are Airbnbs or something like that at Etsy. And if so, I'm curious what they are.

**中文翻译:**
既然聊到这个话题，我很想知道 Etsy 的价值观是什么。我猜你们已经将其成文化了，在 Airbnb 我们称之为核心价值观，在 Etsy 叫什么？如果是的话，它们是什么？

---

### (00:12:26) Tim Holley

**English:**
We call them guiding principles at Etsy. We have a few of them, and I won't go through all of them, but just to give you a flavor, one of them is around digging deeper, and that really speaks to aiming to really understand the why behind a change, to really push on the insights that we're learning through qual or quant research, or other inputs that we might be looking at in order to make the best decision possible with the information we have at the time. Another example of a principle is minimizing waste. It aligns with how we think about product development, which is, we want to know, is the work we're doing adding value to the customer and the business? And so something that isn't working out a lot of times in product development we're wrong. And so being able to say, "No, this is no longer valuable, we need to move on to the next thing," has been something that's served us really well. Ultimately, we are quite a small team. There's just over 2,000 people in the business, and if you then scale back to engineering and product, we're not big. And so we have to be really diligent about how we're investing our time and our resources in order to be successful.

**中文翻译:**
在 Etsy，我们称之为“指导原则”。我们有几条原则，我不一一列举了，但可以给你举几个例子。其中一个是“深入挖掘”（Digging Deeper），这指的是旨在真正理解变革背后的原因，深入挖掘我们通过定性或定量研究以及其他输入信息获得的洞察，以便利用当时掌握的信息做出最佳决策。另一个原则是“减少浪费”（Minimizing Waste）。这与我们对产品开发的思考一致：我们想知道，我们正在做的工作是否为客户和业务增加了价值？在产品开发中，很多时候我们是错误的。因此，能够果断地说“不，这不再有价值了，我们需要转向下一件事”，这对我们非常有帮助。归根结底，我们是一个相当小的团队。全公司只有 2000 多人，如果缩减到工程和产品部门，规模并不大。所以我们必须非常勤勉地投入时间和资源，才能取得成功。

---

### (00:13:31) Lenny

**English:**
Awesome. Okay, so another big moment as an outsider that it feels like Etsy went through is during Covid. There's this huge transition to e-commerce, and I think Etsy was a big beneficiary of that. People wanting to buy more stuff online, go to stores less. And it feels like it was a huge accelerant for the business. I'm curious just what that experience was like leading the product team through that.

**中文翻译:**
太棒了。作为一个局外人，我觉得 Etsy 经历的另一个重大时刻是在新冠疫情期间。当时出现了一个向电子商务的巨大转型，我认为 Etsy 是其中的大受益者。人们想在网上买更多东西，减少去实体店。这感觉像是业务的巨大加速器。我很想知道带领产品团队度过那个时期的经历是怎样的。

---

### (00:13:51) Tim Holley

**English:**
It was quite wild, I'll say that. And to be more specific, as many or all of us did in probably the world of tech at least, we went home not knowing what the next weeks or weeks as we thought would bring, turns out years. But when the CDC mandated face masks in, I think it was early April 2020, that's when essentially we went to sleep one day with our typical April traffic, typical April sales, and then it was Black Friday overnight. And in part because nobody knew where to find face masks. Our sellers are incredibly astute business people. And if you had been making wedding dresses, and you know how to sew, and you've got material, and you've got a bit of time, making a mask is quite a simple task. And so we just saw this huge surge of demand, and then supply rising to meet it.

**中文翻译:**
那非常疯狂，我得这么说。具体来说，就像当时科技界（或者说全世界）的许多人一样，我们回家时并不知道接下来的几周会发生什么，结果变成了几年。但当 CDC 在 2020 年 4 月初强制要求戴口罩时，基本上我们前一天还是正常的 4 月流量和销售，一夜之间就变成了“黑色星期五”。部分原因是当时没人知道去哪买口罩。我们的卖家是非常敏锐的商人。如果你以前是做婚纱的，会缝纫，有材料，还有点时间，做个口罩其实很简单。于是我们看到了需求的爆发式增长，供应也随之跟上。

---

### (00:14:47) Tim Holley

**English:**
And we did something that far as I know we've never done an Etsy's past, which is we put out a call to our sellers to say, "Now's the time. Now's the time to make face masks if you can." And so it felt like this is our time to shine, to really help sellers continue to make sales, to help buyers find this critical item that they were looking for. So it was a very, very exciting couple of weeks while we were kind of adapting to that change. And we were just really... Every day there would be standups. "What's happening? What do we need to change?" I remember distinctly, we were worried about certain sellers not being able to meet the demand that they were seeing. And so we did the old-fashioned thing, of not personally, but we called them and we said, "How are you guys doing? What can we do to help?" And some people said, "We've got this, don't worry. This is squarely in our wheelhouse. We can absolutely meet the supply." And others said, "Actually, we need a little bit of help. We need to take a pause for a moment while we catch up with all these orders, and then we can come back to taking more." And so just getting back to good old-fashioned know your customer, what do they need from you at that moment was just a really kind of powerful thing that took away from that time.

**中文翻译:**
我们做了一件据我所知在 Etsy 历史上从未做过的事，那就是向卖家发出号召：“现在是时候了。如果你能做口罩，现在就行动吧。”感觉这是我们大显身手的时刻，真正帮助卖家维持销售，帮助买家找到急需的物品。在适应那种变化的几周里，一切都非常令人兴奋。每天都有站会：“发生了什么？我们需要改变什么？”我清楚地记得，我们担心某些卖家无法满足他们面临的需求。于是我们采取了传统的方式——虽然不是我亲自打，但我们给他们打电话问：“你们还好吗？我们能帮上什么忙？”有些人说：“没问题，别担心。这完全在我们的能力范围内，我们绝对能供应。”另一些人则说：“实际上，我们需要一点帮助。我们需要暂停一下来处理这些订单，然后再继续接单。”所以，回归到最传统的“了解你的客户”，了解他们在那个时刻需要你做什么，是那段时期带给我的非常有力量的感悟。

---

### (00:16:03) Tim Holley

**English:**
And then from there, things kept going, and we really worked hard to make sure that the story was not just about face masks for our buyers, that they understood that Etsy's a place for so many different categories and so many different items. And that was then the next phase of the challenge. We got a huge influx of new or reactivated buyers. How do we keep them around? How do we make sure that the product does a little bit more work to retain them, and can really have hooks that bring them back time and again? And so that was kind of the journey that we then went on mid-2020, to probably the subsequent 18 months or so.

**中文翻译:**
从那以后，业务持续推进，我们非常努力地确保对买家来说，故事不仅仅是关于口罩的，让他们明白 Etsy 是一个拥有众多品类和商品的平台。那是挑战的下一个阶段。我们迎来了大量新买家或重新激活的买家。我们如何留住他们？我们如何确保产品在留存方面做得更多，并真正拥有能让他们一次又一次回来的“钩子”？这就是我们在 2020 年中期到随后的 18 个月左右所经历的历程。

---

### (00:16:39) Lenny

**English:**
Is there anything you learned as a leader working in leading teams through that time? It must've been a pretty surreal experience, a lot of stress, people worrying about their own health.

**中文翻译:**
作为一名领导者，在那个时期带领团队你学到了什么吗？那一定是一段非常超现实的经历，压力巨大，人们还担心自己的健康。

---

### (00:16:46) Tim Holley

**English:**
I was one of the fortunate ones back then. No kids, worked in an industry that was clearly critical at the time. So I am in awe of how parents worked through that time. So stressful yes, but not to the extent that other people experienced the stress of Covid. We just tried a lot of stuff. I remember early on, I think we had maybe even daily, but at least three times a week coffee chats with the team, just like, "How are you guys doing? What's going on?" And at a certain point we realized all we're talking about is exactly the same things. Nobody wants to be on more calls and more video video chats. And so we just continued to evolve, and really try to keep a pulse on what the team needs. And that, like I said, given context of being parents or whatever, differed pretty dramatically person to person. So definitely wasn't a one size fits all solution. That's more on the people side.

**中文翻译:**
我当时是幸运儿之一。没有孩子，而且在当时显然至关重要的行业工作。所以我非常敬佩那些度过那段时期的父母们。压力确实有，但没有其他人经历的那种新冠压力那么大。我们尝试了很多方法。我记得早期，我们甚至每天，或者至少每周三次和团队进行咖啡聊天，问问“你们怎么样？发生了什么？”但在某个时刻，我们意识到大家聊的都是同样的事情。没人想参加更多的电话会议和视频聊天。于是我们不断演变，努力把握团队的需求。正如我所说，考虑到是否是父母等背景，每个人的需求差异很大。所以绝对没有“一劳永逸”的解决方案。这更多是关于人的方面。

---

### (00:17:40) Tim Holley

**English:**
I think on the product side, as I mentioned, we were really starting to get focused on driving retention, or maybe said slightly differently, driving frequency. And that was a newer topic for us. We've long at Etsy been a really, and maybe rose-tinted glasses speaking a little bit, but a really great experiment, A/B testing driven culture. And so when you think about things like retention, you can absolutely test, course I'm not saying you can't, but you're looking at a different time horizon. Instead of someone making a purchase in that visit or in a week, you're looking at do they come back in 30 days, in 60 days, in 90 days? And so that forced us out of our comfort zone to some degree in terms of how we understand, how we measure change, how long we're willing to wait to see it show up. Back to the incrementality point on minimizing waste, is this actually adding value to the business? And so those were great challenges to tackle, of course on a pretty heightened degree of intensity and focus from the business. But that was an exciting time.

**中文翻译:**
在产品方面，正如我提到的，我们开始真正专注于驱动留存，或者换句话说，驱动购买频率。这对我们来说是一个较新的课题。在 Etsy，我们长期以来一直拥有非常棒的实验和 A/B 测试驱动文化（可能带有一点滤镜）。当你考虑留存之类的事情时，你当然可以测试，但我说的是你观察的时间跨度不同了。你不再是看某人是否在本次访问或一周内购买，而是看他们是否在 30 天、60 天或 90 天后回来。这在某种程度上迫使我们走出舒适区，去思考如何理解和衡量变化，以及我们愿意等待多久看到结果。回到“减少浪费”的增量点：这是否真的为业务增加了价值？这些都是需要应对的巨大挑战，当然，业务的强度和专注度也非常高。但那是一段令人兴奋的时光。

---

### (00:18:46) Lenny

**English:**
Okay. So speaking of that, I want to chat about the marketplace and the marketplace you've built and things you've learned from building. I think it's one of the, I don't know, maybe top 10 marketplace businesses in the world, somewhere in there. And first of all, I'm curious just broadly, what have you learned is really important to just building a really successful thriving marketplace? And then I'll dig into more details. But just broadly, is there anything that comes to mind?

**中文翻译:**
好的。说到这个，我想聊聊你们建立的双边市场以及你从中学习到的经验。我认为它是世界上排名前十左右的市场业务之一。首先，我很好奇从宏观上看，你认为建立一个真正成功、繁荣的市场最重要的是什么？稍后我会深入细节，但宏观上有什么想法吗？

---

### (00:19:09) Tim Holley

**English:**
This narrative is still there, but I think we really focused heavily on the seller side, so the supply side of the business early on. And we really immersed ourselves in who sellers are, what they need, and how what they need maybe differs from what the solutions that they can find elsewhere. Back in the day, we were doing studio visits with sellers. We were going to their workshops, we were going to their homes. We were seeing how they make items, we were seeing how they package and ship them out. We were bringing them into the office when we were running hack weeks to say, "Hey, we've got this crazy idea. Is this interesting?" So trying to involve them in the product development process to the extent that it was reasonable or feasible.

**中文翻译:**
这种叙事依然存在，但我认为早期我们非常侧重于卖家端，也就是业务的供应端。我们真正沉浸在了解卖家是谁、他们需要什么，以及他们的需求与在别处能找到的解决方案有何不同。早些时候，我们会对卖家进行工作室访问。我们会去他们的车间，去他们的家。我们观察他们如何制作商品，观察他们如何包装和发货。在举办黑客周（Hack Weeks）时，我们会把他们请到办公室说：“嘿，我们有个疯狂的想法，这有趣吗？”我们试图在合理且可行的范围内，让他们参与到产品开发过程中。

---

### (00:19:57) Tim Holley

**English:**
And so I think that served us really well. We have a very deep and rich understanding of our sellers. And then the next phase and the more recent phase has been, how do we create a world-class buyer experience that ultimately drives sales for our sellers? Because when you have over 100 million items, all of which are unique, you've got a different challenge than when you have 10,000 SKUs that you could kind of find anywhere or on many retailers. And so topics like structured data, topics like how do we help you gain confidence? Buyer this thing will meet your needs from a seller who you may never have heard of. They don't have a brand that you you've ever encountered before. And so we have some kind of somewhat unique challenges on that front where we need to lean into themes that other marketplaces absolutely touch on. For example, customer reviews play a big role in our experience, but they play a heightened role given the things I mentioned, right? Unique inventory from a seller that is maybe an independent person who is a single entrepreneur, it's one person.

**中文翻译:**
我认为这让我们受益匪浅。我们对卖家有着非常深刻且丰富的理解。接下来的阶段，也是最近的阶段，是：我们如何创造世界级的买家体验，从而最终为卖家驱动销售？因为当你拥有超过 1 亿件商品，且每一件都是独特的，你面临的挑战与拥有 1 万个随处可见的 SKU 是完全不同的。因此，像结构化数据、如何帮助买家建立信心等课题就变得非常重要。买家需要相信，这个来自一个从未听说过、没有任何知名品牌的卖家的东西能满足他们的需求。在这方面，我们面临一些独特的挑战，需要深入研究其他市场也会涉及的主题。例如，客户评价在我们的体验中起着重要作用，但考虑到我提到的因素，它们的作用被放大了，对吧？因为那是来自一个可能是独立创业者的卖家的独特库存。

---

### (00:21:04) Lenny

**English:**
So you mentioned that initially, the focus was on sellers, which is really interesting because a lot of marketplaces, first of all need to figure out which side do we focus on? Who do we cater to most? And the way you described it is initially it was how do we make sure the sellers that are joining at Etsy are most well-served? And then later on it became more of a focus on the buyer side?

**中文翻译:**
你提到最初的重点是卖家，这很有趣，因为很多双边市场首先需要弄清楚：我们应该关注哪一端？我们最应该迎合谁？按照你的描述，最初是确保加入 Etsy 的卖家得到最好的服务，后来才更多地转向买家端？

---

### (00:21:22) Tim Holley

**English:**
Yeah, I guess I'm painting it as a linear approach. It certainly was not. Because if you've got supply without demand, then you don't really have a marketplace. If you've got demand and no supply to meet it, then you also don't have a marketplace. So there's this flip-flop between, do you have enough supply to satiate the demand you have? And playing that out is certainly, I feel like art, not necessarily strictly science.

**中文翻译:**
是的，我想我把它描述成了一个线性过程，但事实并非如此。因为如果你有供应没有需求，你就没有真正的市场；如果你有需求没有供应，你也没有市场。所以这是一种在“你是否有足够的供应来满足需求”之间的反复权衡。我觉得处理这种关系更像是一门艺术，而不一定是严谨的科学。

---

### (00:21:48) Lenny

**English:**
Yeah. So I'm curious how you all think about that actually. So at Airbnb, there's always this thinking of, who do we prioritize if we have to make a decision? is it host or guest? And it's shifted over the years at Airbnb. How do you all think about that as a, "Here's who we're going to prioritize if we really have to make a decision"?

**中文翻译:**
是的。我很好奇你们到底是怎么想的。在 Airbnb，我们总是在思考：如果必须做决定，我们优先考虑谁？是房东还是房客？在 Airbnb，这种优先级这些年来一直在变化。你们是如何思考“如果必须做决定，我们将优先考虑谁”的？

---

### (00:22:06) Tim Holley

**English:**
And maybe to your point, that's also evolved at Etsy. And the place we're in at the moment is the job of a marketplace, even pre the technology definition of a marketplace is a seller will go there to make sales. And if they're not making sales, they probably won't go to that marketplace. And so we really see it as paramount that we have a qualified set of buyers who are looking for the items, the type of items our sellers are selling, and that we can help them make a purchase decision, and therefore a seller maker sale. That doesn't mean that every single team is working on building features for buyers because it doesn't work. Not least because you have a limited piece of real estate marketplace. And if you have too many teams working on it at one time, you'll end up getting in each other's way, and you won't be that productive. And so of course, we have a team that's laser focused on improving the seller experience. How do they list their inventory? How do they manage their sales? How do they fulfill their items? As one example.

**中文翻译:**
也许正如你所说，这在 Etsy 也在演变。我们目前的立场是，一个市场的职责（甚至在技术定义出现之前）就是卖家去那里是为了卖东西。如果他们卖不出去，他们可能就不会去那个市场。因此，我们认为至关重要的是拥有一群合格的买家，他们正在寻找我们卖家所销售的那类商品，并且我们能帮助他们做出购买决定，从而让卖家实现销售。这并不意味着每个团队都在为买家构建功能，因为那行不通。尤其是因为市场的展示空间（Real Estate）有限。如果同时有太多团队在上面工作，最终会互相干扰，效率低下。所以当然，我们有一个团队专门负责改善卖家体验。例如：他们如何列出库存？如何管理销售？如何履行订单？

---

### (00:23:08) Tim Holley

**English:**
But really back to the GMS is the north star, GMS represents a buyer buying from a seller. So it doesn't necessarily say build only for one of your audiences or one of your customers, but it says that that's really the job to be done here is helping facilitate that transaction.

**中文翻译:**
但回到 GMS 作为北极星指标这一点，GMS 代表买家从卖家那里购买商品。所以它并不一定意味着只为某一类受众或客户构建产品，而是说这里的核心任务是帮助促成交易。

---

### (00:23:24) Lenny

**English:**
That's exactly the same transition Airbnb went through. Initially it was focus on hosts, make sure hosts are the happiest people, and do everything we need to make them happy. And then eventually the business is the customers buying the product, and you have to make sure that they're the happy people. And sometimes you have to push hosts to do things they're not as excited to do for the good of the guest side.

**中文翻译:**
这和 Airbnb 经历的转型完全一样。最初是关注房东，确保房东是最快乐的人，做一切能让他们开心的事。但最终，业务核心是购买产品的客户，你必须确保他们是快乐的。有时为了房客端的利益，你不得不推动房东去做一些他们并不那么兴奋的事情。

---

### (00:23:47) Tim Holley

**English:**
And I think it's also the fact that we as the marketplace, and I'm curious if this was true at Airbnb as well, but we have the insight into information, into data, that an individual seller won't. And so we can help them make hopefully better decisions that lead to sales, leveraging the insights that we have. If you put an item on sale during this time period, chances are it's going to resonate with buyers, and you might get an incremental sale. And so trying to be really data-driven in how we help and guide sellers to take actions that we really believe will be valuable for them and their business, because simply, they're either a small business owner and so they don't have time to do that level of digging. Or it's simply not accessible to them because they have the worldview of their business, and we're looking at the entirety of the marketplace.

**中文翻译:**
我认为还有一个事实，作为平台方（我也很好奇 Airbnb 是否也是这样），我们拥有个体卖家无法获得的对信息和数据的洞察。因此，我们可以利用这些洞察帮助他们做出更好的决策，从而带来销售。比如，如果你在这段时间打折，很有可能会引起买家的共鸣，你可能会获得增量销售。所以我们尝试以数据驱动的方式帮助和引导卖家采取行动，因为他们要么是小企业主，没时间进行深度的挖掘，要么是他们只能看到自己业务的局部，而我们看到的是整个市场的全貌。

---

### (00:24:37) Lenny

**English:**
Maybe on this thread going a little nerdier, how do you think about supply constraint versus demand constraint? Is that something that comes up? I imagine maybe it's per category.

**中文翻译:**
在这个话题上再深入一点，你们如何看待供应受限与需求受限？这是经常讨论的问题吗？我猜可能是按品类划分的。

---

### (00:24:45) Tim Holley

**English:**
At the high level, we have 100 million items. So if you take that number at face value, you would think we do not have a supply constraint. We want to drive buyers to that supply. When you dig in maybe a more category, subcategory, sub subcategory level, that's where we do start to see pockets where, maybe we want to increase the type and the amount of inventory we have in wall decor. Seeing something behind you, that might not be the right example. But that's where we then start to focus and say, are there areas where we want to lean in? Ultimately, really thinking about, how do we help buyers choose? Because that's when you have 100 million items and even in a sub subcategory or for a specific search query, you still generally have a lot of results to choose from. How do you distinguish one item or one seller from another, based on the needs that you have? When is it going to arrive? How much does it cost? Is it this size or that size? So really trying to lean into those types of things. And again, to some degree that's econ 101. But given the scale we're at, it is a pretty unique challenge.

**中文翻译:**
从宏观上看，我们有 1 亿件商品。如果你只看这个数字，你会认为我们没有供应限制，我们只想把买家引向这些供应。但当你深入到品类、子品类甚至更细分的层级时，我们确实会看到一些“缺口”，比如我们可能想增加墙面装饰类商品的种类和数量。看到你身后的东西，这可能不是个好例子。但这就是我们开始关注的地方：是否有我们想要深入发展的领域？归根结底，我们思考的是如何帮助买家做出选择。因为当你拥有 1 亿件商品时，即使是在一个极细分的子品类或特定的搜索查询下，通常仍有大量结果可供选择。你如何根据自己的需求区分不同的商品或卖家？什么时候到货？多少钱？是这个尺寸还是那个尺寸？所以我们努力深入研究这些细节。这在某种程度上是经济学入门知识，但考虑到我们的规模，这是一个非常独特的挑战。

---

### (00:25:55) Lenny

**English:**
What are ways you encourage your sellers to offer the things that you think you're lacking?

**中文翻译:**
你们通过什么方式鼓励卖家提供你们认为缺乏的商品？

---

### (00:26:01) Tim Holley

**English:**
Back to that data-driven point, right? If we can clearly articulate that if you show more photos, you will help buyers understand your item in new ways, in deeper ways, then you're more likely to make a sale. That's maybe a somewhat reductive example, but those are the types of things where we generally know either through the data that we observe based on activity on the marketplace, and/or through the research we're doing, that this will be valuable. The challenge is often, we have so many things that we want our sellers to do. What's the most important thing for them to do right now? And that maybe changes somewhat seasonally. We're slowly starting to get towards the holiday season. And that just has a heightened purchase. It's a heightened time of purchasing. And contrast that with when it's around Mother's Day, maybe different type of inventory works really well. And so we need different inputs from our sellers. Because ultimately, they're business people. They have limited time in the day, and they want to spend time making. So how can we make sure that the time they spend on Etsy, managing their inventory, offering customer support is as valuable as possible?

**中文翻译:**
回到数据驱动那一点。如果我们能清晰地说明，如果你展示更多照片，就能帮助买家以更新、更深的方式理解你的商品，从而更有可能实现销售。这可能是一个简化的例子，但这类事情我们通常通过观察市场活动数据或通过调研得知其价值。挑战往往在于，我们想让卖家做的事情太多了。现在对他们来说最重要的事情是什么？这可能会随季节变化。我们正慢慢进入假日季，那是购物的高峰期。相比之下，母亲节前后，可能不同类型的库存效果更好。因此，我们需要卖家提供不同的输入。因为归根结底，他们是商人，每天时间有限，他们想把时间花在制作上。那么，我们如何确保他们在 Etsy 上管理库存、提供客户支持所花费的时间尽可能有价值呢？

---

### (00:27:09) Lenny

**English:**
So essentially in product messaging and recommendations that you're showing to the sellers is the way you communicate to them?

**中文翻译:**
所以本质上，你是通过向卖家展示产品内消息和建议来与他们沟通的？

---

### (00:27:16) Tim Holley

**English:**
Yeah. And to some degree, we use the buyer experience to kind of signal what matters, right? When we're clearly highlighting photos, then that's obviously a very overly simple example.

**中文翻译:**
是的。在某种程度上，我们利用买家体验来发出“什么才是重要的”信号，对吧？当我们清晰地突出照片时，这显然是一个非常简单的例子。

---

### (00:27:29) Lenny

**English:**
Sellers [inaudible] here's what the search experience is highlighting.

**中文翻译:**
卖家 [听不清] 看到搜索体验正在突出显示什么。

---

### (00:27:33) Tim Holley

**English:**
As an example, yeah. And then really thinking about some of the signals or the snippets of information that we highlight. What goes into that? We know that great customer service a seller, they'll be responding to... We call them convos, but messages on our platform. They'll be responding really quickly. And that's something that we then highlight in the experience, and that if you're meeting that criteria, then we can start to signal to a buyer that, yes, this person offers really excellent customer service, and we can set your expectations accordingly.

**中文翻译:**
举个例子，是的。然后真正思考我们突出显示的那些信号或信息片段。其中包含什么？我们知道，如果一个卖家有出色的客户服务，他们会回复……我们称之为 Convos，也就是平台上的消息。他们会回复得非常快。这就是我们在体验中会突出的内容。如果你达到了这些标准，我们就可以向买家发出信号：是的，这个人提供非常出色的客户服务，我们可以据此设定你的期望。

---

### (00:28:06) Lenny

**English:**
Awesome. Yeah, we saw the same thing at Airbnb. One of the things that I worked on, that was one of the bigger shifts in the marketplace was shifting Airbnb to an instant buying experience. And many hosts didn't want that, because they really wanted to vet the guest and make sure they are happy with them. But it ended up being so important to conversion that we just encouraged them to turn it on. And one of the ways that worked best is exactly what you shared, where in the search experience, when someone came and searched, we just defaulted the search results to only show you instantly bookable listings. And hosts started to realize, "Oh shit, this is where things are going. I think I got to really take this seriously." And that worked really well.

**中文翻译:**
太棒了。我们在 Airbnb 也看到了同样的情况。我参与的工作之一，也是市场最大的转变之一，就是将 Airbnb 转向“即时预订”体验。很多房东不想要这个功能，因为他们想审核房客，确保对房客满意。但事实证明，这对转化率太重要了，所以我们鼓励他们开启。最有效的方法之一正是你分享的：在搜索体验中，当有人搜索时，我们默认搜索结果只显示“即时预订”的房源。房东们开始意识到：“噢，天哪，趋势就是这样，我得认真对待了。”这招非常管用。

---

### (00:28:42) Tim Holley

**English:**
Yeah, interesting.

**中文翻译:**
是的，很有趣。

---

### (00:28:43) Lenny

**English:**
Pulling that thread a little bit more, I'm curious what you've seen as some of the bigger conversion wins on the buyer's side in terms of experiments you've run that have had some of the bigger impact.

**中文翻译:**
再深入探讨一下，我很想知道在买家端，你所运行的实验中，哪些带来了比较大的转化率提升？

---

### (00:28:53) Tim Holley

**English:**
I won't say we're consistently, because that suggests that we don't know what we're doing we do. We're often surprised by what works in an outsized way and what we think is going to be a knock it out of the park success, ends up being of minimal value. But coming back to maybe some of the themes alluded to earlier, reviews have long been really important. And when you're reviewing an item like I said, that's unique, that's from an independent seller, the type of information that another buyer is looking for is maybe a little different than other marketplaces, or even platforms that they might be shopping on. And so really trying to lean into, well, what does it look like in a buyer's hand, in a buyer's home? Maybe that gives the next purchaser a bit more confidence that it's the right size, it's the right color, whatever it might be. And so that's long been a track that has been very fruitful for us, and continues to be something that we iterate on, that we focus on.

**中文翻译:**
我不会说我们“总是”感到惊讶，因为那意味着我们不知道自己在做什么，其实我们知道。但我们经常对那些效果出奇好的东西感到惊讶，而有些我们认为会大获全胜的东西，最后价值却微乎其微。回到之前提到的一些主题，评价一直非常重要。当你评价一件独特的、来自独立卖家的商品时，另一位买家寻找的信息可能与其他市场甚至其他购物平台略有不同。所以我们努力研究：这件东西在买家手里是什么样？在买家家里是什么样？也许这能给下一位购买者更多信心，让他们相信尺寸合适、颜色正确等等。这一直是我们非常有成效的一个方向，也是我们持续迭代和关注的重点。

---

### (00:29:47) Lenny

**English:**
Just I understand, that essentially it's recommending to sellers, "Here's the photos you should have on your list."

**中文翻译:**
我理解一下，这本质上是建议卖家：“这是你应该在列表中包含的照片。”

---

### (00:29:52) Tim Holley

**English:**
Rather, collecting from buyers. So a seller will give us the photos that they're going to take, and then we can augment those with the, we call them buyer review photos. But ultimately, the experience the purchaser is having either through photo or video is super, super valuable.

**中文翻译:**
更确切地说，是从买家那里收集。卖家会提供他们拍的照片，然后我们可以用我们称之为“买家评价照片”的内容来补充。归根结底，购买者通过照片或视频分享的体验是非常非常有价值的。

---

### (00:30:12) Lenny

**English:**
Great. Okay, cool. So adding specific photos that you find help buyers convert. Keep going.

**中文翻译:**
太好了。好的，酷。所以添加你发现能帮助买家转化的特定照片。请继续。

---

### (00:30:18) Tim Holley

**English:**
And then the other side is really leaning into maybe more the behavioral economic tactics of just helping buyers make decisions. Signals and nudges is how you'll see it referred to in literature. And we've seen great success in elevating little snippets of information that really help a buyer understand, "There is actually only one of these. Well, that's good information to know." It's something that then fits into their decision-making process that might've otherwise been buried. And so really leaning into the quick summaries, the easy glanceable information that enables a buyer to gain enough confidence to say, "Yep, out of these 100 million items or the results for this search query, this is the one that I feel best about buying." We've seen lots of success on that track as well.

**中文翻译:**
另一方面是更多地利用行为经济学策略来帮助买家做决定。在文献中，这被称为“信号与助推”（Signals and Nudges）。我们在提升一些小信息片段的可见度方面取得了巨大成功，这些信息能真正帮助买家理解：“实际上这件商品只有一件了。嗯，这是个很有用的信息。”这些信息会进入他们的决策过程，否则可能会被埋没。所以，真正专注于快速摘要、一目了然的信息，让买家能获得足够的信心说：“是的，在这 1 亿件商品或这个搜索结果中，这就是我最想买的那件。”我们在这一方向上也看到了很多成功案例。

---

### (00:31:10) Lenny

**English:**
That was a track at Airbnb as well. One of the ways they did this is they called it a rare gem, which is something that's available right now, that's very popular, and they created this kind of iconography for it. And engineers on the team ended up for Halloween dressing up as a rare gem. It became a whole thing at the company. And what's funny about Airbnb is every home is a one of a kind. There's only one left always, and there's always jokes about, "We should always be one left, you better book now."

**中文翻译:**
这也是 Airbnb 的一个方向。他们的方法之一是称之为“稀有宝石”（Rare Gem），指现在可以预订且非常受欢迎的房源，并为此设计了一种图标。团队里的工程师甚至在万圣节打扮成“稀有宝石”。这成了公司的一件大事。Airbnb 有趣的地方在于，每个房子都是独一无二的，永远只剩一个，所以总有笑话说：“我们应该永远显示只剩一个，你最好现在就订。”

---

### (00:31:36) Tim Holley

**English:**
I believe it was introduced... I don't believe. I know it was introduced as issue or a bug. But we ended up showing four stars and the fifth star when it was a half star, got rendered as a horse emoji. And so for a second there on Etsy, we had four stars and a horse showing up for some of our review ratings. And that spawned a huge amount of internal fun. And then back to your point around Halloween, we had a few teams being four stars and a horse. It was pretty interesting.

**中文翻译:**
我相信它最初是作为……不，我知道它最初是作为一个问题或 Bug 引入的。我们原本要显示四颗星，而当第五颗星是半星时，它被渲染成了一个马的表情符号（Horse Emoji）。所以在 Etsy 上有一段时间，部分评价等级显示为“四颗星和一匹马”。这在公司内部引发了巨大的乐趣。回到你说的万圣节，我们有几个团队打扮成了“四颗星和一匹马”。非常有趣。

---

### (00:32:15) Lenny

**English:**
Was it like five people were four people were a star and there's a horse person?

**中文翻译:**
是像五个人一组，其中四个是星星，一个是马吗？

---

### (00:32:18) Tim Holley

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### (00:32:21) Lenny

**English:**
Today's episode is brought to you by OneSchema, the embeddable CSV importer for SaaS. Customers always seem to want to give you their data in the messiest possible CSV file, and building a spreadsheet importer becomes a never ending sync for your engineering and support resources. You keep adding features to your spreadsheet importer, the customers keep running into issues. Six months later, you're fixing yet another date conversion edge case bug. Most tools aren't built for handling messy data, but OneSchema is. Companies like Scale AI and Pave are using OneSchema to make it fast and easy to launch delightful spreadsheet import experiences from embeddable CSV import to importing CSVs from an SFTP folder on a recurring basis. Spreadsheet import is such an awful experience in so many products. Customers get frustrated by useless messages like error on line 53, and never end up getting started with your product. OneSchema intelligently corrects messy data so that your customers don't have to spend hours in Excel just to get started with your product. For listeners of this podcast, OneSchema is offering a $1,000 discount. Learn more at oneschema.co/lenny.

**中文翻译:**
本集由 OneSchema 赞助播出，它是面向 SaaS 的可嵌入式 CSV 导入器。客户似乎总是想给你最混乱的 CSV 文件，而构建电子表格导入器会成为工程和支持资源的无底洞。你不断为导入器添加功能，客户却不断遇到问题。六个月后，你还在修复另一个日期转换的边缘案例 Bug。大多数工具并非为处理混乱数据而生，但 OneSchema 是。像 Scale AI 和 Pave 这样的公司都在使用 OneSchema，从而快速轻松地发布令人愉悦的电子表格导入体验，从可嵌入的 CSV 导入到定期从 SFTP 文件夹导入 CSV。在许多产品中，电子表格导入体验都非常糟糕。客户会被“第 53 行错误”这种无用的消息搞得心烦意乱，最终根本无法开始使用你的产品。OneSchema 能智能纠正混乱数据，让你的客户不必为了开始使用你的产品而在 Excel 中耗费数小时。对于本播客的听众，OneSchema 提供 1000 美元的折扣。欲了解更多信息，请访问 oneschema.co/lenny。

---

### (00:33:27) Lenny

**English:**
So going down this track a little bit more, one of the biggest wins for Airbnb's search experience was this very small idea of just, what if you open each listing in the search results in a new tab, and ended up converting 1%, like increasing conversion by 1%? Is there anything like that that you remember that you've done of just like, "Holy moly, that was so simple, but such a big win"?

**中文翻译:**
再沿着这个思路走，Airbnb 搜索体验中最大的胜利之一是一个非常小的想法：如果让搜索结果中的每个列表都在新标签页中打开会怎样？结果转化率提高了 1%。你还记得有什么类似的事情吗？就是那种“天哪，这么简单，却带来了这么大的胜利”的事情？

---

### (00:33:47) Tim Holley

**English:**
Yeah, we have similar learnings around that exact example. Oftentimes I think about effort and reward. So it might be a smallish GMS win or conversion rate win, but it was a one line text change. And we've seen those where we add a small snippet of, maybe we feel like it's almost marketing copy, and it ends up having an outsized impact. We had one example where we added some text to the cart experience, and we just saw huge uplift that we really, really didn't expect. It was more us communicating our values as a business, and it was something that really seemed to resonate with our buyers. And so that drove conversion. We've got examples where it's a one line copy change, and it's quite shocking the impact that that can have.

**中文翻译:**
是的，关于那个例子我们也有类似的经验。我经常思考“投入与回报”。有时可能只是一个较小的 GMS 增长或转化率提升，但它只是改了一行文字。我们见过这样的情况：添加一小段我们觉得几乎像是营销文案的内容，结果产生了巨大的影响。我们有一个例子，在购物车体验中添加了一些文字，结果看到了完全出乎意料的巨大提升。那更多是我们作为一家企业在传达价值观，而这似乎真的引起了买家的共鸣。于是转化率提高了。我们有很多这种只改一行文案却产生惊人影响的例子。

---

### (00:34:37) Lenny

**English:**
I'm curious what that change actually was, the text change that had that much impact, if you can recall.

**中文翻译:**
我很想知道那个改动具体是什么，如果你还记得的话，那行产生巨大影响的文字改动是什么？

---

### (00:34:42) Tim Holley

**English:**
We've long and continued to invest in sustainability, and the text change was in our cart where we call out Etsy offsets carbon emissions from every delivery. And just adding that simple line of text was something that, like I said, really resonated with our buyers and the type of customer that comes to Etsy, and really drove conversion.

**中文翻译:**
我们长期以来一直持续投资于可持续发展，那行文字改动是在购物车里，我们写道：“Etsy 抵消了每一次配送产生的碳排放。”正如我所说，仅仅添加这一行简单的文字，就引起了买家和 Etsy 典型客户的强烈共鸣，并真正推动了转化。

---

### (00:35:03) Lenny

**English:**
I had Ronny Kohavi on the podcast who's one of the lead experts on experimentation, and he had the stat that 80% of experiments fail at each company on average. Does that sound about right in terms of how you guys find experiments working out?

**中文翻译:**
我曾邀请过实验领域的顶尖专家 Ronny Kohavi 来播客，他提到一个统计数据：平均而言，每个公司 80% 的实验都会失败。这听起来符合你们实验的情况吗？

---

### (00:35:18) Tim Holley

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:35:18) Lenny

**English:**
Awesome. Okay. What is your just general philosophy and experimentation? Does everything run as an experiment? Do things sometimes not run an experiment? How do you think about that at Etsy?

**中文翻译:**
太棒了。好的。你们对实验的总体哲学是什么？每件事都作为实验运行吗？有时会有不运行实验的情况吗？在 Etsy 你们是怎么考虑的？

---

### (00:35:28) Tim Holley

**English:**
Right now, the vast majority of our changes do. And to be perfectly candid, I think that's one of our growth edges as a product org, and maybe even as a company, is bringing in different ways to validate changes. Because to some degree, or maybe the way I think about experimentation, that's the highest bar. That proves with near absolute certainty that there's a causal relationship between the change you made and the KPI that you want to move. But I think that it maybe misses the point in some changes or some areas where you are working towards a bigger net new thing or this specific change won't really be indicative of the greater whole you're building towards.

**中文翻译:**
目前，我们绝大多数的改动都会进行实验。坦率地说，我认为这是我们作为产品组织、甚至作为一家公司的成长空间之一，即引入不同的方式来验证改动。因为在某种程度上，或者按照我对实验的理解，那是最高标准。它以近乎绝对的确定性证明了你所做的改动与你想改变的 KPI 之间存在因果关系。但我认为，对于某些改动或某些领域，如果你正在朝着一个更大的全新事物努力，或者这个特定的改动并不能真正代表你正在构建的整体，那么实验可能会偏离重点。

---

### (00:36:14) Tim Holley

**English:**
So like I said, I mentioned earlier, we've long been a very A/B testing driven organization, not least because Etsy's background and history has deep, deep roots in an incredible engineering culture. And so that's really tried and true. So the vast majority of things are tested in that way. We're expanding how we think about looking at cohorts over time. I mentioned retention earlier, that to some degree, it necessitates a different type of test. When we look at our SEO work, you can't think about it in exactly the same ways. But the through line is, is the change that we're making adding value? And that's what we want to try to understand. A/B testing is a great way to do that. There are others, some of which we're starting to employ, others that we we'll continue to investigate and think about how we can leverage.

**中文翻译:**
正如我之前提到的，我们长期以来一直是一个非常由 A/B 测试驱动的组织，这在很大程度上是因为 Etsy 的背景和历史深深植根于卓越的工程文化。所以这是经过验证的方法，绝大多数事情都以这种方式测试。我们正在扩展对长期留存分析（Cohorts）的思考。我之前提到了留存，在某种程度上，它需要一种不同类型的测试。当我们看 SEO 工作时，你不能用完全相同的方式去思考。但核心逻辑是：我们所做的改动是否增加了价值？这就是我们想要了解的。A/B 测试是实现这一目标的好方法，但也有其他方法，其中一些我们已经开始采用，另一些我们将继续研究并思考如何利用。

---

### (00:37:02) Lenny

**English:**
Is there an example of anything? And if there's not, that's totally cool, of something that you shipped that was maybe negative on an experiment results, or you just didn't want to write as an experiment.

**中文翻译:**
有没有什么例子（如果没有也没关系），是你发布了但在实验结果中显示是负面的，或者你根本不想把它作为实验来运行的东西？

---

### (00:37:12) Tim Holley

**English:**
When we're collecting inputs from sellers, we just simply don't feel it's appropriate to not either show or honor. We talk about a tried and true practice of sales and discounting. If a seller offers something on sale, then we need to show that. We are really curious about how that actually drives buyer behavior. And there's ways that we can kind of construct pre-post analysis and things like that to try to understand the impact. But ultimately, those are the kind of areas where we err on the side looking at our data in different ways. And so we have maybe a slightly different degree of confidence in the value, but we're still confident that it does help the marketplace as a whole.

**中文翻译:**
当我们从卖家那里收集输入信息时，我们觉得不展示或不尊重这些信息是不合适的。比如促销和打折这种经过验证的做法。如果卖家提供打折商品，我们就必须展示出来。我们非常好奇这实际上如何驱动买家行为，我们可以通过构建“前后对比分析”（Pre-post analysis）之类的方法来尝试理解其影响。但最终，在这些领域，我们倾向于以不同的方式查看数据。因此，我们对价值的信心程度可能略有不同，但我们仍然相信它对整个市场是有帮助的。

---

### (00:37:55) Lenny

**English:**
That's a great example. Yeah, I'm not sure what I do there. That is tricky. So we've been talking about conversion. I'm curious in terms of acquisition, what you've seen work. And just generally, how do people find Etsy? How do you drive top of funnel for Etsy?

**中文翻译:**
这是一个很好的例子。是的，我也不确定在那儿该怎么做，这确实很棘手。我们一直在谈论转化，我很想知道在获客（Acquisition）方面，你看到什么方法有效？通常人们是怎么发现 Etsy 的？你们如何驱动 Etsy 的漏斗顶端（Top of funnel）？

---

### (00:38:06) Tim Holley

**English:**
Yes. There's two sides to Etsy, right? There's the seller and the buyer. Getting in the Wayback Machine, on the seller side, we would be at craft fairs like Renegade and other places where our sellers were selling in person and really letting them know that Etsy exists. And so that was very boots on the ground, let's get out and try to acquire sellers into the marketplace. Some of that predates me to some degree. We were probably doing it on the tail end when I joined.

**中文翻译:**
是的。Etsy 有两端：卖家和买家。回到过去，在卖家端，我们会去像 Renegade 这样的手工艺品博览会以及其他卖家亲自售卖的地方，让他们知道 Etsy 的存在。那是非常接地气的工作，走出去尝试把卖家吸引到市场中来。其中一些做法在某种程度上早于我加入公司，我加入时可能正处于尾声。

---

### (00:38:37) Tim Holley

**English:**
And then we have a lot of great word of mouth through our sellers. A seller probably knows other people who are similarly inclined to be incredible craftspeople, who want to sell their items. And so we've seen some success with our... We have a Teams platform where sellers can come together, ask each other questions, and the word of mouth type of growth through that. On the buyer side, we really leveraged the fact that we have a ton of inventory. And to some degree, it ends up being quite a long tail of inventory where we can meet really niche and specific needs. And so that lends itself really well to thinking about SEO, lends itself really well to thinking about Google Shopping, where someone is not on Etsy, but is often looking for something either somewhat or very specific. And we can really meet their needs in a really meaningful way by showing them not only just a single item, but maybe that and then other options that they might find that are of a similar vein, in a similar, sub categories in some cases. And so those have been long tried and true areas that we've invested in, and we've seen really great success in driving new buyers to Etsy.

**中文翻译:**
此外，我们通过卖家获得了大量的口碑传播。一个卖家可能认识其他同样出色的手工艺人，他们也想卖东西。我们在“团队”（Teams）平台上看到了一些成功，卖家可以在那里聚集、互相提问，并通过这种方式实现口碑增长。在买家端，我们充分利用了拥有海量库存的事实。在某种程度上，这形成了非常长尾的库存，可以满足非常小众和特定的需求。这非常适合 SEO（搜索引擎优化），也非常适合 Google Shopping。当某人不在 Etsy 上，但正在寻找某种非常具体的东西时，我们可以通过向他们展示不仅是单件商品，还有其他类似风格或子品类的选项，以一种非常有意义的方式满足他们的需求。这些都是我们长期投入且行之有效的领域，在为 Etsy 吸引新买家方面取得了巨大成功。

---

### (00:39:44) Lenny

**English:**
I've researched and written about that story of how Etsy started with sellers and craft fairs. And so that's a really classic story. And I think there's also an element of the early sellers drove the early buyers, because they're just advertising their listing page, "Here's where you could go buying," which is a really unfair rare, opportunity to grow the marketplace by just focusing on sellers.

**中文翻译:**
我研究并写过关于 Etsy 如何从卖家和手工艺博览会起步的故事，那是一个非常经典的案例。我认为还有一个因素是早期卖家驱动了早期买家，因为他们会宣传自己的商品页面说“你可以去这里买”，这是一种非常难得的、通过只关注卖家就能发展市场的机会。

---

### (00:40:04) Tim Holley

**English:**
I mean, yes, and a seller is a buyer. And so if they're making something that they've poured their heart into, chances are they will value that exact same behavior in someone else. And so if they're selling an item, they're looking for other things in maybe not their exact category, but in adjacent categories, and they become buyers. So it is a nice dynamic when that starts to work.

**中文翻译:**
我的意思是，是的，而且卖家本身也是买家。如果他们倾注心血制作某样东西，很有可能他们也会欣赏别人的这种行为。所以如果他们在卖东西，他们也会在其他（也许不是完全相同但相关的）品类中寻找东西，从而变成买家。当这种动态开始运作时，效果非常好。

---

### (00:40:29) Lenny

**English:**
Yeah. So many natural advantages to getting this marketplace off the ground. How cool is that? You mentioned word of mouth as a big part of how Etsy started spreading. I imagine even today there's a lot of just, "Hey, you should check out Etsy." Is there anything you've done that accelerates word of mouth or build on word of mouth, referrals comes to mind? Is there anything along those lines?

**中文翻译:**
是的。启动这个市场有这么多天然优势，太酷了。你提到口碑是 Etsy 开始传播的重要部分。我猜即使在今天，也有很多“嘿，你应该去看看 Etsy”的情况。你们有没有做过什么来加速口碑传播或基于口碑进行构建？我想到的是推荐计划（Referrals），有类似的东西吗？

---

### (00:40:46) Tim Holley

**English:**
Yeah, we dabbled with referral programs a while ago, probably eight some years ago. What we saw, it was a different time. And so I think we maybe didn't value a new buyer, for example, in the way we do today. Because to some degree, you're unlocking future value. They make a single purchase, and then the bet is over time they'll go on to make subsequent purchases. We didn't necessarily have that as deep an understanding then as we do now. So our buyer referral program ultimately wasn't a huge success.

**中文翻译:**
是的，我们很久以前尝试过推荐计划，大概是八年前。当时情况不同。我想那时我们可能没有像今天这样重视一个新买家的价值。因为在某种程度上，你是在解锁未来价值：他们进行一次购买，然后赌注是随着时间推移，他们会继续购买。我们当时对这一点的理解没有现在这么深刻。所以我们的买家推荐计划最终并没有取得巨大的成功。

---

### (00:41:15) Tim Holley

**English:**
But on the seller side, this was back in the days of Dropbox referral program being a huge, huge driver of their growth, and the whole get concept that was really prevalent back then. And on the seller side, one of the things that we really leaned into was, on Etsy, for those who aren't familiar, it costs 20 cents to list an item. And that may seem like a very small financial outlay to get started, but it's a little bit of a barrier. And the more we can do to remove those, the higher chance that someone will either become a seller or list more items.

**中文翻译:**
但在卖家端，那是 Dropbox 推荐计划成为其增长巨大驱动力的时代，当时那种“获取”概念非常流行。在卖家端，我们真正投入的一点是：在 Etsy 上（对于不熟悉的人来说），列出一件商品需要 20 美分。这看起来是一笔很小的开支，但它确实是一个小障碍。我们越能消除这些障碍，某人成为卖家或列出更多商品的可能性就越高。

---

### (00:41:51) Tim Holley

**English:**
So we really leaned into that as the currency for the seller referral program. And coming back to what I said around Teams, that was a really great way to supercharge some of that activity that was either happening, but more of it could happen, or really helping a seller understand, "Oh yeah, there is a hook here. If I offer this person, I refer them, they'll get some listing credits. It'll be easier for them to open their shop. And then when I need to list more items, I also have credits that I can apply." So that was one small area. I wouldn't say it was a huge driver of growth. But in certain markets, in certain pockets, we saw it work pretty well.

**中文翻译:**
所以我们真正把这作为卖家推荐计划的“货币”。回到我说的“团队”（Teams），这是一个非常好的方式，可以增强那些正在发生或可能发生的活动，或者真正帮助卖家理解：“噢是的，这里有个诱饵。如果我推荐这个人，他们会得到一些上架额度（Listing credits），开店会更容易。而当我需要列出更多商品时，我也有可以使用的额度。”所以这是一个小领域。我不会说它是增长的巨大驱动力，但在某些市场、某些群体中，我们看到它运作得相当好。

---

### (00:42:27) Lenny

**English:**
Awesome. That also helps with fraud, which is a huge problem with referral programs where the credit is just, you can list on Etsy. It's not like you can steal a lot of money away from the business. So that's clever.

**中文翻译:**
太棒了。这也有助于防止欺诈，欺诈是推荐计划的一个大问题。如果奖励只是“你可以在 Etsy 上架商品”，那就不会像直接给钱那样让业务损失大量资金。这很聪明。

---

### (00:42:39) Tim Holley

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:42:40) Lenny

**English:**
Okay. I want to talk about one other part of the funnel, retention. Is there anything you've learned that has been really effective to help with the retention?

**中文翻译:**
好的。我想谈谈漏斗的另一个部分：留存。你有没有学到什么对提升留存非常有效的方法？

---

### (00:42:46) Tim Holley

**English:**
We have long had features that are retentive in their nature. Things like, on Etsy, we call them favorites. That might be liking or a similar action on other places. But how do we think about the habit loop of if you take an action, what's the trigger and then what's the reward? And so using a favorite as an example, you favorite an item. That's a pretty strong ish... Of course, adding it to your cart or maybe purchasing it, that's the strongest of signals, but you've shown intent.

**中文翻译:**
我们长期以来一直拥有本质上具有留存作用的功能。比如在 Etsy，我们称之为“收藏”（Favorites）。这在其他地方可能叫“点赞”或类似动作。但我们如何思考习惯回路（Habit loop）：如果你采取了一个行动，触发因素是什么，奖励又是什么？以收藏为例，你收藏了一件商品。这是一个相当强的……当然，加入购物车或购买是最强的信号，但收藏已经显示了意图。

---

### (00:43:21) Tim Holley

**English:**
So what can we do with that information? We can then say, "The seller put it on sale. You should come back and check it out. This is selling out. There's only one of this item left. You showed some intent, you might want to come back and get it." And that's just one example of trying to close those loops. And that's where we've worked on things like, we call it the updates feed, essentially a feed of activity that you've taken, that we're demonstrating how it's changed, what's new, and then pulling in the tried and true tactic of push notifications to make you aware of that, such that you're using your phone all the time. You see that show up. That's a pretty great notification to get right. "The thing that I really liked is now on sale. I want to check that out." And so those are examples where really leaning into that habit loop framework has helped us understand, we've got a lot of this activity. How do we close the loop? How do we make it really valuable for our buyers?

**中文翻译:**
那么我们可以利用这些信息做什么呢？我们可以说：“卖家打折了，你应该回来看看。这件快卖完了，只剩最后一件了。你之前表达过意图，可能想回来买下它。”这只是尝试完成闭环的一个例子。为此，我们开发了诸如“更新动态”（Updates feed）之类的功能，本质上是你所采取行动的动态流，我们展示了它的变化和新动态，然后引入经过验证的推送通知（Push notifications）策略让你意识到这一点。既然你一直在用手机，看到通知弹出，那是一个很棒的体验：“我非常喜欢的东西现在打折了，我想去看看。”这些例子说明，深入研究习惯回路框架帮助我们理解了：我们有很多这类活动，我们该如何闭环？如何让它对买家真正有价值？

---

### (00:44:11) Lenny

**English:**
Zooming out a little bit, it's kind of wild that Etsy can exist in a world of eBay and Amazon. And I'm just curious what it is that you think the founders and the team did early on to carve out this space of, I know you could buy things from people, you can buy things on Amazon really quickly, to create a world where Etsy builds this massive business that continues to thrive. What do you think was done so well to carve out the space?

**中文翻译:**
稍微放大一点来看，Etsy 能在 eBay 和亚马逊的世界里生存下来，这挺不可思议的。我很想知道，你认为创始人团队早期做了什么，才在“你可以从个人那里买东西”和“你可以在亚马逊上快速买东西”之间开辟出这个空间，创造了一个让 Etsy 建立起如此庞大且持续繁荣业务的世界？你认为他们在开辟这个空间方面做得最好的是什么？

---

### (00:44:36) Tim Holley

**English:**
I think that to some degree, resolves down to... And maybe that's a little too extreme, but a key component is the brand. The brand stands for something in people's minds. And that helps understand you're not going to get the same inventory on Etsy. You shouldn't expect the same inventory on Etsy as you might be looking for on eBay. It doesn't make sense to our buyers. The items that our sellers sell are unique. And so I think that as the core nugget, combined with how we think about policies, and our way to some degree, maintain the integrity of the marketplace, those two things combined do set us apart. And I think if you ask many people, certainly here in the US, what they think of Etsy, a very specific image will be conjured up. That may be one that we want to evolve and build on, but it feels quite distinct. And it's not the same as eBay and it's not the same as Amazon. And I think there's real deep value in that. And I wasn't here at the very beginning, but it's certainly something that was there at the very beginning of Etsy, that is still a through line to where we are today.

**中文翻译:**
我认为在某种程度上，这归结为……也许这有点极端，但一个关键因素是品牌。品牌在人们心中代表着某种东西。这有助于人们理解，你在 Etsy 上买不到和别处一样的库存。你不应该期望在 Etsy 上找到你在 eBay 上寻找的那种商品，这对我们的买家来说没有意义。我们卖家销售的商品是独特的。我认为这是核心所在，再加上我们对政策的思考，以及我们在某种程度上维护市场完整性的方式，这两者结合确实让我们脱颖而出。我想如果你问很多人（尤其是在美国），他们对 Etsy 的看法，脑海中会浮现出一个非常具体的形象。这可能是我们想要演变和发展的形象，但它感觉非常独特。它不同于 eBay，也不同于亚马逊。我认为其中蕴含着深刻的价值。虽然我最初不在公司，但这肯定是 Etsy 创立之初就存在的特质，并且一直延续到今天。

---

### (00:45:53) Lenny

**English:**
That makes absolute sense to me. On the other hand, I also don't know how that happens. Is there anything that you think about, of how the team did that and how they built that brand? What are some of the important elements? Is that a specific aesthetic? Is it a certain type of supply that you stuck to? What do you think was so important to building that brand?

**中文翻译:**
这对我来说完全说得通。但另一方面，我也不知道这是如何实现的。你有没有想过团队是如何做到这一点的，他们是如何建立那个品牌的？有哪些重要元素？是特定的审美吗？还是你们坚持的某种类型的供应？你认为建立那个品牌最重要的是什么？

---

### (00:46:12) Tim Holley

**English:**
I think it is the supply. If you think about the marketplace, the vast majority of content is maybe what we might consider UGC. It's either the item is from the seller. Or as was mentioning before, the buyer review is from the buyer. And so just being really clear about what's okay to sell and what's not okay, I think does really differentiate us. I also think over the years, our brand, and our aesthetic, and how we position ourselves has evolved, will continue to evolve as it should. But to the point where we are now, the statement we have is keep commerce human. And that feels really simple, super pithy, easy to remember, but has lineage when you go all the way back to where we started in terms of really valuing the unique, valuing the handmade. And so that does permeate decision making, how we show up, the type of features we work on, the things we would prioritize. Maybe never say never, but an item getting dropped off by a drone and a person never touches it, that doesn't feel very Etsy. That's not something that we might lean into.

**中文翻译:**
我认为是供应。如果你思考这个市场，绝大多数内容可以被视为 UGC（用户生成内容）。要么商品来自卖家，要么如前所述，评价来自买家。因此，明确规定什么是可以卖的，什么是不可以卖的，我认为这确实让我们与众不同。我也认为这些年来，我们的品牌、审美和定位已经演变，并将继续按应有的方式演变。但就目前而言，我们的口号是“保持商业的人性化”（Keep Commerce Human）。这听起来非常简单、精炼、易记，但它有着深厚的渊源，可以追溯到我们最初对独特、对手工价值的重视。这渗透到了决策中，包括我们的形象、我们开发的功能类型以及我们优先考虑的事情。也许永远不要说永远，但一件商品由无人机投递且从未经过人手，这感觉不太符合 Etsy 的风格。那不是我们会倾向于去做的事情。

---

### (00:47:22) Lenny

**English:**
It's interesting how many parallels Etsy has to Airbnb, because Airbnb is the same general idea. People's homes, people making things. And then also, I think the tagline for Airbnb early on was travel like a human. So it was actually a really similar concept.

**中文翻译:**
有趣的是，Etsy 和 Airbnb 有很多相似之处，因为 Airbnb 的总体理念也是一样的：人们的家，人们创造的东西。而且，我记得 Airbnb 早期的口号是“像人类一样旅行”（Travel like a human）。所以这实际上是一个非常相似的概念。

---

### (00:47:35) Tim Holley

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:47:36) Lenny

**English:**
Which touches on a question I wanted to talk about, which is many marketplaces as they grow, become supply constrained. And then there's this pressure to add different types of supply. In Airbnb's case, it was, "We should add hotels, we should add property management, vacation rental companies on here. We should have everything people want to book, because we're losing business. They could book anything here, they should be able to." But the tension is, then we become like everyone else. And then what is Airbnb in that case? And I think you went through that experience where there was a lot of cheap products from overseas, and it was kind of being flooded. Is that true, I guess? And then just how do you think about that limit, and where you draw that line?

**中文翻译:**
这触及了我想要讨论的一个问题：许多双边市场在发展过程中都会面临供应受限的问题。然后就会有压力去增加不同类型的供应。在 Airbnb 的案例中，压力是：“我们应该加入酒店，加入物业管理公司和度假租赁公司。我们应该提供人们想预订的一切，因为我们在流失生意。他们本可以在这里预订任何东西。”但矛盾在于，那样我们就变得和别人一样了。在那之后，Airbnb 还是 Airbnb 吗？我想你们也经历过类似的情况，当时有很多来自海外的廉价产品涌入。这是真的吗？你们如何考虑这个界限，在哪里划线？

---

### (00:48:17) Tim Holley

**English:**
Yeah, I think it does come back to some degree to the brand and the policy point from just before. And we take enforcing our policies really seriously. It's not an easy job at our scale, and that means we need to continue to invest and continue to make sure that only the best items, the most relevant items are on Etsy. That job is never done. The team that that works super, super hard, and is always looking for new signals to understand what maybe doesn't meet our criteria. Generally speaking, supply is something that we have in spades for the most part. Back to the point we talked about earlier, one of the things that we grappled with was around, how can we help sellers scale? They sell great inventory, but maybe they just don't have enough of it, or they can't meet the demand, because they're making everything by hand.

**中文翻译:**
是的，我认为这在某种程度上回到了刚才提到的品牌和政策点。我们非常认真地执行我们的政策。在我们的规模下，这不是一项容易的工作，这意味着我们需要持续投入，确保只有最好的、最相关的商品留在 Etsy 上。这项工作永无止境。团队工作非常非常努力，一直在寻找新的信号来识别可能不符合我们标准的商品。总的来说，我们在大部分时间里都有充足的供应。回到我们之前讨论的点，我们面临的一个难题是：我们如何帮助卖家扩大规模？他们卖的东西很好，但可能数量不够，或者因为全是手工制作而无法满足需求。

---

### (00:49:10) Tim Holley

**English:**
So one of the things that there was an evolution, was leaning into what today we call production assistance. And the way I think about that is you still need to understand the provenance of your item. If you are saying, "I have this design, I'm just going to throw it over the fence to a manufacturer that I've never met, that I don't know. I don't understand their processes, I may not agree with them," that doesn't meet our criteria. You need to understand how it's being made, who is making it, have a relationship with the person who's helping you scale your business. But that's something that we saw from people who maybe gravitate more towards being designers than being able to actually make the thing. They have this excellent idea, they just can't see it come to life. And so they need some help. And that was something we leaned into to be able to, like I said, help sellers that maybe weren't able to make a thing and sell it on Etsy. Or for sellers who were reaching the limits of what they could supply, really take it to the next level, and make more items such that they could make more sales.

**中文翻译:**
因此，我们经历的一个演变是转向我们今天所说的“生产协助”（Production Assistance）。我的理解是，你仍然需要了解商品的来源。如果你说：“我有这个设计，我打算把它扔给一个我从未见过、不认识的制造商。我不了解他们的流程，我可能也不认同他们，”那就不符合我们的标准。你需要了解它是如何制造的、谁在制造，并与帮助你扩大业务的人建立关系。但我们从那些可能更倾向于做设计师而不是亲手制作的人身上看到了这种需求。他们有绝佳的创意，但无法亲手实现。所以他们需要帮助。正如我所说，这是我们投入的一个方向，旨在帮助那些可能无法亲手制作但在 Etsy 上销售的卖家，或者帮助那些达到供应极限的卖家提升到下一个层次，制作更多商品，从而实现更多销售。

---

### (00:50:10) Lenny

**English:**
So it sounds like essentially, this is just evolving definition of what a supplies allowed on Etsy, a team that stays on top of that. Imagine there was just a hard decision at one point of just, "We will limit supply, and here's the supply that we want on the platform. Everything else we're going to take off."

**中文翻译:**
所以听起来本质上，这只是在不断演变 Etsy 允许的供应定义，并有一个团队专门负责此事。我猜在某个时刻肯定有一个艰难的决定：“我们要限制供应，这是我们想要在平台上的供应，其他的我们都要撤掉。”

---

### (00:50:25) Tim Holley

**English:**
We would limit the type of items, the number of those items, that as we talked about, there's a lot of them. But really having that clear definition. In some cases, it's easy. Some things, they violate legal definitions. And those things, that's the easy stuff to think about. It's where it's a little more gray, that it gets a little trickier.

**中文翻译:**
我们会限制商品的类型和数量，正如我们讨论过的，商品非常多。但关键是要有清晰的定义。在某些情况下这很容易，比如有些东西违反了法律定义，那些是容易处理的。但在一些灰色地带，事情就会变得棘手。

---

### (00:50:47) Lenny

**English:**
That reminds me, so my wife is actually a designer, and she produces these hilarious charts about life stuff. And people take her designs and just sell them on every platform on Zazzle, and probably Etsy, but everywhere. And she's always trying to hunt them down and get them to take them off. But it's such a pain for a small designer. It's not an Etsy problem, it's just a general internet problem.

**中文翻译:**
这让我想起，我妻子其实是个设计师，她制作了一些关于生活琐事的搞笑图表。人们拿走她的设计，然后在 Zazzle、可能还有 Etsy 等各个平台上售卖。她总是试图追踪这些人并让他们下架。但对于一个小设计师来说，这太痛苦了。这不是 Etsy 的问题，而是一个普遍的互联网问题。

---

### (00:51:08) Tim Holley

**English:**
Yeah. And back to the, we have teams hard at work thinking about IP, and how to police it, how to enforce it.

**中文翻译:**
是的。回到刚才说的，我们有团队在努力思考 IP（知识产权）问题，以及如何监管和执行。

---

### (00:51:16) Lenny

**English:**
It's tough.

**中文翻译:**
这很难。

---

### (00:51:17) Tim Holley

**English:**
Not a domain I will suggest I'm an expert in, really, really tricky stuff, but we've got to be beyond that.

**中文翻译:**
这不是我敢自称专家的领域，确实非常棘手，但我们必须去应对。

---

### (00:51:23) Lenny

**English:**
Yeah. Another I think problem that's sort of unique to Etsy, something that I think people call the graduation problem. Which is where you join Etsy, things start to grow, you become really successful. And then you're like, "Why am I paying Etsy all these fees? Why don't I just make my own website and just sell it directly, and not pay any fees?" And I think you guys went through that. And so if that's true, is there anything you've learned about just how to avoid getting people to want to leave?

**中文翻译:**
是的。我认为另一个 Etsy 特有的问题是人们常说的“毕业问题”（Graduation Problem）。也就是你加入 Etsy，业务开始增长，你变得非常成功。然后你会想：“我为什么要付给 Etsy 这么多费用？为什么我不自己建个网站直接卖，不用付任何费用？”我想你们也经历过这种情况。如果是真的，关于如何避免人们想要离开，你学到了什么吗？

---

### (00:51:48) Tim Holley

**English:**
I think the core thought there is, our fees are generally low and highly competitive. So from that perspective, there's a reason to stay on Etsy. What we've seen and what we know, our sellers are really smart business people. And so if they can distribute their products through another channel, that might be their own website, another marketplace in person. Probably going to try to do that. They want to make more sales. Not all, but many of them are wired to want to grow their business.

**中文翻译:**
我认为核心想法是，我们的费用通常较低且极具竞争力。所以从这个角度看，有理由留在 Etsy。我们所看到和了解的是，我们的卖家是非常聪明的商人。如果他们可以通过另一个渠道分销产品，无论是自己的网站、另一个市场还是线下，他们可能都会去尝试。他们想获得更多销售额。虽然不是全部，但他们中的许多人天生就想发展业务。

---

### (00:52:21) Tim Holley

**English:**
And so really understanding the role that we play in that construct of distribution channels to make it a little reductive is really helpful to understand. And to some degree, we want to be the place that not only they make sales on, but they love to sell on, because our tools are really catered to the needs that they have. So there is some degree of stickiness. I mentioned Teams earlier. There are places where sellers go to congregate, share ideas, share grievances in some cases, but ultimately support each other. And so there are reasons to stick around. I'm sure there certainly sellers who scale out of Etsy who realize, "I want to build my own website," to the example you cited. The reality is that's neither cheap nor fast. It's hard work. It's hard work to build, hard work to maintain, expensive to drive traffic to. And so that may be a part of the way they want to take their business, but oftentimes, Etsy still does play a role in how they're thinking, about where they make sales, and ultimately where they're going to see growth from.

**中文翻译:**
因此，真正理解我们在分销渠道结构中所扮演的角色（虽然这有点简化）是非常有帮助的。在某种程度上，我们希望成为一个不仅能让他们实现销售，而且让他们热爱在上面销售的地方，因为我们的工具是真正迎合他们需求的。所以存在一定程度的粘性。我之前提到了“团队”（Teams），那是卖家聚集、分享想法、有时分享不满但最终互相支持的地方。所以有理由留下来。我确信肯定有卖家在规模扩大后离开 Etsy 去建自己的网站。但现实是，那既不便宜也不快。那是艰苦的工作：构建难，维护难，引流贵。所以这可能是他们发展业务的一种方式，但通常情况下，Etsy 在他们的思考中、在他们考虑销售来源和增长点时，仍然扮演着重要角色。

---

### (00:53:24) Lenny

**English:**
The cool thing that I saw online about you, is that you built a marketplace essentially within Etsy called Etsy Studio. And I'm not sure if that's around anymore, but I'm curious what the story there was, and what you learned from that experience, and current status.

**中文翻译:**
我在网上看到关于你的一件很酷的事，就是你在 Etsy 内部建立了一个名为 Etsy Studio 的市场。我不确定它是否还在，但我很好奇那里的故事是什么，你从那次经历中学到了什么，以及现在的状态如何。

---

### (00:53:40) Tim Holley

**English:**
Yeah, well researched. Because no, it is no longer around. The white space we saw with studio was essentially saying, on the one hand you've got Pinterest fails, right? You've got all these great inspiring items or projects on Pinterest, and then you have people who've no idea how to make them, and they get so frustrated. And then on the other hand, you've got a marketplace like Michael's, or these other places where you might go for craft supplies. They have stuff, but they don't necessarily have inspiration. And how can we play in that intersection of the idea and the items and the tutorials to see that idea come to life?

**中文翻译:**
是的，调研得很充分。因为它已经不在了。我们通过 Studio 看到的空白点本质上是：一方面你有“Pinterest 上的失败案例”，对吧？你在 Pinterest 上看到所有这些伟大的、鼓舞人心的项目，但人们不知道怎么做，感到很沮丧。另一方面，你有像 Michael's 这样的市场，或者其他买手工材料的地方。他们有东西，但不一定有灵感。我们如何能在创意、物品和教程的交汇点上发挥作用，让创意变为现实？

---

### (00:54:21) Tim Holley

**English:**
So the genesis of the idea, felt from a brand perspective, super aligned. We stand for creativity, we stand for makers. And so we saw it as a big opportunity. The launch happened to coincide with the pivot in 2017, to really focusing on the core marketplace or refocusing on the core marketplace, maybe I should say. And so it became clear that when we laid out what we're optimizing for, which is driving sales in the short term, marketing dollars being as ROI positive as possible, having teams focused on the core marketplace, it didn't check any of those boxes. And so really, really tough decision and hard to manage through, but that was ultimately the right call for the business to say, "This no longer makes sense given the new constraints that we're operating in, given the new goals that we have."

**中文翻译:**
所以这个想法的初衷从品牌角度来看是非常契合的。我们代表创造力，代表创作者。所以我们认为这是一个巨大的机会。但它的发布恰好赶上了 2017 年的转型，即重新专注于核心市场。很明显，当我们列出我们要优化的目标时——即短期内驱动销售、营销资金尽可能实现正向 ROI（投资回报率）、让团队专注于核心市场——Studio 并不符合其中任何一项。所以这是一个非常艰难的决定，执行起来也很难，但对业务来说，最终是正确的决策，即：“考虑到我们现在面临的新约束和新目标，这不再有意义了。”

---

### (00:55:10) Lenny

**English:**
Makes sense. Also something that happened to Airbnb a lot, trying new things that they didn't work out, had to move on.

**中文翻译:**
明白。Airbnb 也经常发生这种事，尝试新事物但没成功，不得不继续前进。

---

### (00:55:15) Tim Holley

**English:**
Yep.

**中文翻译:**
是的。

---

### (00:55:16) Lenny

**English:**
That's how it goes.

**中文翻译:**
就是这样。

---

### (00:55:17) Tim Holley

**English:**
Yep.

**中文翻译:**
是的。

---

### (00:55:18) Lenny

**English:**
Shifting a little bit to just product leadership and writing the product team, and just a few more questions, what's something that you've found to be really important to having a productive, well run, well executing product team?

**中文翻译:**
稍微转向产品领导力和管理产品团队的话题，还有几个问题：你认为拥有一个高效、运作良好、执行力强的产品团队最重要的是什么？

---

### (00:55:31) Tim Holley

**English:**
Yeah. One of the things that's certainly not completely novel but I think we have a pretty unique interpretation of is how we collaborate between functions. You'll often hear the three legs of the stool where you've got product and engine design, and we've evolved that to five legs of the stool. And I fully recognize that a five legged stool probably is not a very stable thing, but go with the analogy for a second-

**中文翻译:**
是的。有一件事虽然不完全是首创，但我认为我们有非常独特的解读，那就是我们跨职能协作的方式。你经常听到“三条腿的凳子”，即产品、工程和设计。我们将其演变为“五条腿的凳子”。我完全意识到五条腿的凳子可能不太稳，但请先听听这个类比——

---

### (00:55:56) Lenny

**English:**
I think it's even more stable. Is that the most stable stool or is it less stable with five legs?

**中文翻译:**
我觉得它甚至更稳。五条腿的凳子是最稳的还是更不稳？

---

### (00:56:00) Tim Holley

**English:**
You probably need a really flat surface.

**中文翻译:**
你可能需要一个非常平整的表面。

---

### (00:56:02) Lenny

**English:**
That makes sense.

**中文翻译:**
有道理。

---

### (00:56:03) Tim Holley

**English:**
Regardless, of course we've got product eng design and we've got our insights partners. So research and analytics, and we've got our marketing partners really working in a tight team to build the best products possible. And so I think that we can continue to get better absolutely, at how we make decisions and how we bring the various viewpoints together. So to some degree it's not the easiest path, but it's the best path I think, where you're really incorporating different viewpoints, different constraints, different considerations into the features and the products that we're building. And treating that as the core leadership team I think is really valuable.

**中文翻译:**
不管怎样，除了产品、工程、设计，我们还有“洞察伙伴”（Insights partners），即研究和分析团队，以及我们的营销伙伴。大家在一个紧密的团队中工作，以构建最好的产品。我认为我们在如何做决策以及如何整合各种观点方面绝对可以做得更好。在某种程度上，这不是最容易的路，但我认为这是最好的路，因为你真正将不同的观点、约束和考量融入到了我们正在构建的功能和产品中。将这五方视为核心领导团队，我认为非常有价值。

---

### (00:56:45) Tim Holley

**English:**
And maybe that's partly because generally, we don't subscribe to this idea of PM as the mini CEO. You're up there directing from on high that we're going to build that feature and we're going to do that. And that's just not the type of culture that we have, and generally speaking from what I've seen, doesn't lead to good decisions or the best features or product being built. And so collaboration is something we really value and that we try to live through how we structure our teams, how we make our decisions. Is it perfect? Like I said, absolutely not. I think it's the way that we've found being really successful building product.

**中文翻译:**
这可能部分是因为，通常我们不认同“PM 是迷你 CEO”的想法。即你高高在上地指挥说我们要建那个功能、要做那件事。那不是我们的文化。总的来说，根据我的观察，那并不能带来好的决策，也无法构建出最好的功能或产品。因此，协作是我们非常看重的东西，我们试图通过团队结构和决策方式来践行这一点。它完美吗？正如我所说，绝对不完美。但我认为这是我们发现的构建产品非常成功的方式。

---

### (00:57:21) Lenny

**English:**
Do you give the PM just a little more say in decision making and ask? Because with five people in the leadership team, you talked about how back in the day, it was like too consensus driven maybe, and I wonder how you navigate that with five decision makers.

**中文翻译:**
你会给 PM 更多的决策权吗？因为领导团队有五个人，你提到过以前可能太过于共识驱动，我想知道在有五个决策者的情况下，你如何处理这个问题。

---

### (00:57:35) Tim Holley

**English:**
Yeah, we're always looking to clarify, or re-clarify, or restate who ultimately is accountable. And in many cases it is the PM, right? You are the one who Nick, our CPO like to say you don't have to have the best ideas, but you have to choose the best ideas. And so really figuring out how you're selecting what you're going to build and then living with the consequences. Of course ideally, successful. In many cases, back to your 80% stat that 80% of experiments don't work, owning what's next, right? Okay, did we learn from that? If we did, what are we going to do about it? That definitely does fall to the PM. It doesn't give you the permission to ignore other viewpoints or make decisions in a vacuum. It's certainly not that. But ultimately, when we need to move forward, it is the PM that is on the hook for those things.

**中文翻译:**
是的，我们一直在寻求明确、重新明确或重申谁是最终负责人。在许多情况下，那个人就是 PM。正如我们的 CPO Nick 喜欢说的，你不必拥有最好的主意，但你必须选择最好的主意。所以，真正弄清楚你如何选择要构建的内容，并承担后果。当然，理想情况下是成功的。但在很多情况下（回到你说的 80% 实验失败的统计数据），PM 需要负责下一步：“好吧，我们从中学习到了什么？如果学到了，我们该怎么办？”这绝对落在 PM 身上。这并不意味着你可以忽视其他观点或在真空中做决定，绝对不是那样。但最终，当我们需要前进时，是 PM 在负责这些事情。

---

### (00:58:26) Lenny

**English:**
Awesome. So essentially, the PM can make the call if there's an unclear consensus?

**中文翻译:**
太棒了。所以本质上，如果没有明确的共识，PM 可以做决定？

---

### (00:58:33) Tim Holley

**English:**
And given so many places are, but we're so heavily led by the insights either qual or quant. The decision in many instances is clear. When it's not, that's when we need the product person to step forward and say, "We're going in this direction." Don't know if it's going to work out, but we'll certainly learn and we'll move forward.

**中文翻译:**
考虑到很多地方都是如此，但我们非常依赖定性或定量的洞察。在许多情况下，决策是显而易见的。当不明显时，我们就需要产品人员站出来说：“我们要往这个方向走。”不知道是否会成功，但我们肯定会学习并继续前进。

---

### (00:58:50) Lenny

**English:**
Awesome. And then just to go on this topic a little bit more, your teams are cross-functional dedicated teams. I imagine it sounds like there's these five leads for each team. Is that roughly how you organize?

**中文翻译:**
太棒了。再深入一点，你们的团队是跨职能的专属团队。我猜听起来每个团队都有这五个负责人。你们大致是这样组织的吗？

---

### (00:59:01) Tim Holley

**English:**
Yeah. And the fifth leg, if you will, of marketing, that might be product marketing in some cases, that might be brand marketing in others. And so there's kind of different flavors of marketing that we pull in, based on the specific needs of the project. But that's generally speaking how we try to structure our teams from kind of the group level all the way down to the individual squad. We can't always have a dedicated research, and a dedicated analyst, and a dedicated product marketer to every single team. So it's certainly not perfect, but that's where we aspire to having at least coverage on those roles.

**中文翻译:**
是的。至于营销这第五条腿，在某些情况下可能是产品营销（PMM），在另一些情况下可能是品牌营销。我们会根据项目的具体需求引入不同类型的营销。但总的来说，这就是我们尝试构建团队的方式，从部门级别一直到具体的执行小组（Squad）。我们无法为每个团队都配备专门的研究员、分析师和产品营销人员，所以这当然不完美，但我们的目标是至少在这些角色上实现覆盖。

---

### (00:59:37) Lenny

**English:**
Got it. So most teams have dedicated marketing person or a product marketing person. That's crazy. That's really rare, but interesting.

**中文翻译:**
明白了。所以大多数团队都有专门的营销人员或产品营销人员。这太疯狂了，非常罕见，但很有趣。

---

### (00:59:43) Tim Holley

**English:**
Some teams-

**中文翻译:**
某些团队——

---

### (00:59:43) Lenny

**English:**
Some teams that I imagine are most in need of marketing support. Got it. Are you able to just paint a rough picture of the way the teams are laid out at Etsy? I imagine there's a buyer side and a seller side. How does that look for people to make sense-

**中文翻译:**
我猜是那些最需要营销支持的团队。明白了。你能大致描述一下 Etsy 团队的布局吗？我猜有买家端和卖家端，具体是怎么划分的？

---

### (00:59:57) Tim Holley

**English:**
Yeah. The way that we think about the structure right now, and the org design should ideally follow strategy. And if your strategy is always evolving, then your org design is always evolving. We call it the product stack. And so we've got our core customer teams, who are unsurprisingly thinking about buyers and sellers. And so they're the ones on the front lines with the customers.

**中文翻译:**
是的。我们目前对结构的看法是，组织设计理想情况下应该追随战略。如果你的战略在不断演变，那么你的组织设计也在不断演变。我们称之为“产品栈”（Product Stack）。我们有核心客户团队，不出所料，他们负责思考买家和卖家。他们是处于客户第一线的人。

---

### (01:00:26) Tim Holley

**English:**
Then we have, we call them our partner teams, and so they are working directly with the end customer. So think an organization like payments where they have clearly a way to capture payment from a buyer to remit funds to a seller, so they're really on the front lines with the customer. They also have other constraints working with the payment networks, and card providers, and things like that, so they just have a slightly different model. So core customer, partner teams, enablement teams that are really in service of helping deliver the best possible experience. That might be through our recommender systems or through our design system, in order to make developing that little bit easier, a little bit faster, a little bit more standardized in some cases. And then the foundation of it all sits with infrastructure, and the teams that you might expect that are much more technical in nature, that really, without that, we wouldn't have a website.

**中文翻译:**
然后我们有“伙伴团队”（Partner teams），他们也直接与终端客户打交道。比如支付团队，他们显然有从买家那里收取款项并汇给卖家的途径，所以他们也在一线。但他们还有与支付网络、卡组织合作的其他约束，所以模式略有不同。总结一下：核心客户团队、伙伴团队、赋能团队（Enablement teams，服务于提供最佳体验，比如推荐系统或设计系统，让开发更简单、更快、更标准化），最后是这一切的基础——基础设施团队，也就是那些技术性更强的团队，没有他们我们就没有网站。

---

### (01:01:20) Lenny

**English:**
When you're hiring a product manager, is there anything that you found to be really important or interesting, or maybe a unique insight into hiring teams?

**中文翻译:**
当你招聘产品经理时，你发现有什么是非常重要或有趣的，或者在招聘团队方面有什么独特的见解吗？

---

### (01:01:28) Tim Holley

**English:**
The three things that I come back to time and again, is one, the collaboration piece that we talked about earlier. Not only a willingness, but a real excitement to do that. It's not everyone's bag. I get that. Some people just want to be in a make fast decisions and move forward place. We aim to make fast decisions, but you need to consult. That's one. Two is being decisive. We have tons of data, but it's not always clear exactly what to do with that, or we're using a new input. Maybe back to the point mentioned earlier of looking at competitive insights, let's make a decision, let's move forward. Let's ideally learn. Even if we're not making progress against our goals, we're at a minimum learning.

**中文翻译:**
我反复强调的三点是：第一，我们之前谈到的协作。不仅要有意愿，还要对协作感到兴奋。这并不适合所有人，我明白。有些人只想在一个快速决策并前进的地方工作。我们的目标是快速决策，但你需要进行咨询。这是第一点。第二是果断。我们有海量数据，但并不总是清楚该怎么做，或者我们正在使用新的输入。回到之前提到的竞争洞察，让我们做个决定，继续前进。理想情况下是学习，即使我们没有朝着目标取得进展，至少我们在学习。

---

### (01:02:10) Tim Holley

**English:**
And then the third point is just curiosity. Because we're a relatively small organization with... Everyone says, "If only we had more people," but we are quite small. So there is a lot of change. There's a lot of new priorities that crop up, and that means there's a lot of opportunity for the right folks, right? If I want to be in this space, and only this space, and this is my specific domain, and I just want to be in it forever more, that might be a little more challenging, because you might be asked to work on something net new. And so just having that curiosity mindset of saying, or maybe said differently growth mindset of, "Okay, there's something to learn from the thing I'm being asked to do, let me really lean into that." And to some degree, I'm not describing anything that's atypical of great product people overall. But I think we have either a slightly different flavor or we need it in a slightly different way here at Etsy.

**中文翻译:**
第三点就是好奇心。因为我们是一个相对较小的组织……虽然每个人都会说“要是人再多点就好了”，但我们确实规模不大。所以会有很多变化，会有很多新的优先级出现，这意味着对合适的人来说有很多机会。如果我只想待在这个领域，而且只待在这个领域，这是我的专属领地，我想永远待下去，那可能会有点挑战，因为你可能会被要求去做全新的事情。所以，拥有一种好奇心，或者说成长型思维：“好吧，从我被要求做的事情中可以学到一些东西，让我全身心投入其中。”在某种程度上，我描述的并不是优秀产品经理所不具备的特质，但我认为在 Etsy，我们需要一种略微不同的风格或方式。

---

### (01:02:59) Lenny

**English:**
Awesome. Last question, before we get to our very exciting lightning round. Is there a framework or a process that you find really useful, that you find yourself coming back to, that you think listeners would potentially find really valuable?

**中文翻译:**
太棒了。在进入令人兴奋的闪电轮环节之前，最后一个问题：有没有什么你觉得非常有用、经常使用，且认为听众可能会觉得非常有价值的框架或流程？

---

### (01:03:11) Tim Holley

**English:**
I won't pretend to know whether listeners find it valuable. But the thing that I do a lot, that we do as my team, that others do to some degree is a simple exercise of weekly focus. What are you focused on this week? And then reflecting on, did you get done the things you were focused on last week? Seems super simple, but just the exercise of thinking about what matters, writing it down, and having a little bit of social proof or articulating it out to others creates some degree of accountability, is something that is very, very easy and simple to do. And if you do it consistently, you start to see some really great patterns of, "Those types of focus areas take me longer than I think. I should budget more time." Or, "These are the type of things that crop up. At this time of year, I might need to start thinking about making some space for them." So I've just found that to be really, really, really helpful in the day-to-day.

**中文翻译:**
我不敢假装知道听众是否会觉得它有价值。但我经常做的一件事，我的团队也在做，其他人也在某种程度上在做，就是一个简单的“每周重点”（Weekly Focus）练习。你这周的重点是什么？然后反思：你上周关注的事情完成了吗？这看起来超级简单，但思考什么重要、写下来、并向他人表达出来（这提供了一点社交证明），会产生某种程度的责任感。这是一件非常非常容易且简单的事。如果你坚持做，你会发现一些很棒的模式，比如：“那类重点工作花费的时间比我想象的要长，我应该预留更多时间。”或者“每年的这个时候都会出现这类事情，我可能需要开始考虑为它们留出空间。”我发现这在日常工作中非常非常有帮助。

---

### (01:04:06) Lenny

**English:**
I love that. How do you operationalize that? Is it like a Slack channel people post these in, is it a Docs?

**中文翻译:**
我喜欢这个。你们如何操作？是在 Slack 频道里发布，还是在文档里？

---

### (01:04:11) Tim Holley

**English:**
Yeah. In our buyer experience product channel, on Mondays, everyone's kind of sharing what they're focused on. How last week panned out, was it done? Is it still in progress? Things like that. It's very, very lo-fi, but it worked pretty well.

**中文翻译:**
是的。在我们的买家体验产品频道，每周一，大家都会分享自己的重点。上周进展如何？完成了吗？还在进行中吗？诸如此类。这非常低技术含量（Lo-fi），但效果很好。

---

### (01:04:25) Lenny

**English:**
So it's kind of like a standup that happens once a week, and it's higher level essentially is what it sounds like?

**中文翻译:**
所以这有点像每周一次的站会，而且本质上是更高层级的，听起来是这样吗？

---

### (01:04:30) Tim Holley

**English:**
Exactly, exactly. Trying to think about the priorities and not tasks. And that is a blurry line. I fully recognize that. But anchoring in those I think is certainly for me, personally more helpful.

**中文翻译:**
没错，没错。试着去思考优先级而不是具体的任务。虽然这两者界限模糊，我完全承认这一点，但锚定在优先级上对我个人来说更有帮助。

---

### (01:04:41) Lenny

**English:**
And is the comedian person in these and sharing funny things in the standup-

**中文翻译:**
那个脱口秀演员也在其中并分享有趣的事情吗？

---

### (01:04:46) Tim Holley

**English:**
No, unfortunately, or fortunately, he's now actually a comedian.

**中文翻译:**
不，不幸的是（或者说幸运的是），他现在真的是一名脱口秀演员了。

---

### (01:04:52) Lenny

**English:**
Are you serious he became a full time comedian? That’s amazing. And with that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
你是认真的吗？他成了全职脱口秀演员？太神奇了。那么，我们进入了非常刺激的闪电轮环节。准备好了吗？

---

### (01:04:58) Tim Holley

**English:**
Hit me.

**中文翻译:**
来吧。

---

### (01:04:59) Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### (01:05:03) Tim Holley

**English:**
Couple that come to mind Team of Teams by Stanley McChrystal has been, I think is just A, really fascinating read, and B, helped me think a lot about how you trust teams and how you think about disseminating decision-making to the right folks, tech language, push decisions to the edges. But thinking about it in the context that he describes there is really fascinating, and it just shows that it can work even in the most egregious world of military, which you think is top-down command and control, shows that there's a different way to approach problems.

**中文翻译:**
我想到的几本：Stanley McChrystal 的《赋能》（Team of Teams）。我认为它首先读起来非常引人入胜，其次它帮助我思考如何信任团队，以及如何将决策权下放到合适的人手中（用技术术语说就是“决策边缘化”）。在他描述的背景下思考这些问题非常有趣，它展示了即使在最极端的军事世界（你认为那是自上而下的命令与控制），也存在不同的解决问题的方式。

---

### (01:05:42) Lenny

**English:**
I was actually a fan favorite at Airbnb also.

**中文翻译:**
这本书在 Airbnb 也很受欢迎。

---

### (01:05:45) Tim Holley

**English:**
Oh, cool. Other is back all the way to the top to what I love to do. Surfing and being outdoors. Let My People Go Surfing by Yvon Chouinard, the Patagonia founder. Incredibly fascinating read of someone who just had a deep, deep passion, turned it into a business, struggled, iterated, came out the other side really successful. So the business side, but also just how they think about treating their employees and the culture that they've built I think is to me personally, really inspiring. There's a theme here around trust and how you engage with people to make their day-to-day work lives, is really fulfilling. So that's another favorite. And then in a super different direction, Power Broker by Robert Caro. That is an absolute tone. It is huge. It took me probably an entire year to read because I'm an extremely slow reader and/or I fell asleep a lot. But it is so fascinating, especially living in New York, of how one human had such an incredibly outsized and probably terrible impact on the city. Access to waterfronts, really thinking about communities and tearing them apart. Just such a fascinating read.

**中文翻译:**
噢，酷。另一本回到了我热爱的事情：冲浪和户外。Patagonia 创始人 Yvon Chouinard 的《员工出海，我去冲浪》（Let My People Go Surfing）。这是一个极其迷人的故事，讲述了一个拥有极深热情的人如何将其转化为业务，经历挣扎、迭代，最终获得巨大成功。不仅是业务方面，他们对待员工的方式和建立的文化对我个人来说非常有启发。这里有一个关于信任以及如何与人互动让日常工作生活变得充实的主题。所以这是另一个最爱。还有一个完全不同的方向，Robert Caro 的《权力经纪人》（The Power Broker）。那是一本巨著，非常厚。我大概花了一整年才读完，因为我阅读速度极慢，而且经常读着读着就睡着了。但它非常迷人，尤其是住在纽约，你会看到一个人如何对这座城市产生如此巨大且可能极其糟糕的影响。包括滨水区的开发、对社区的思考以及对它们的拆解。真是一本引人入胜的书。

---

### (01:06:56) Lenny

**English:**
I have that book, and I've never read it. It's very long and intimidating. I think it might be back there, maybe in a different-

**中文翻译:**
我有那本书，但我从未读过。它太长了，让人望而生畏。我想它可能就在后面，也许在不同的——

---

### (01:07:01) Tim Holley

**English:**
I would chunk it out. Do a couple of chapters at a time, otherwise it feels insurmountable.

**中文翻译:**
我会把它拆开读。一次读几章，否则会觉得无法逾越。

---

### (01:07:07) Lenny

**English:**
It's like infinite Infinite Jest where you're intimidated. Amazing. Okay, next question. Favorite recent movie or TV show?

**中文翻译:**
就像《无尽的玩笑》（Infinite Jest）一样让人望而生畏。太棒了。好的，下一个问题。最近最喜欢的电影或电视节目？

---

### (01:07:15) Tim Holley

**English:**
So my wife and I talk about this a lot. I think we're Western Files, if that's a thing. I'm from Europe and so it's a whole new world, different world for me. We've loved Yellowstone and all of the, I guess they're prequels. They've been just really, really fun to watch for people who are curious about that culture and that world.

**中文翻译:**
我和妻子经常聊这个。我想我们是“西部片迷”（Western Files），如果真有这个词的话。我来自欧洲，所以这对我来说是一个全新的、不同的世界。我们非常喜欢《黄石》（Yellowstone）以及所有的前传。对于好奇那种文化和世界的人来说，这些剧集真的非常好看。

---

### (01:07:35) Lenny

**English:**
Awesome. It's also been hard to find where to even watch it. It's on the weirdest channels.

**中文翻译:**
太棒了。不过找在哪儿看都挺难的，它在一些很奇怪的频道上。

---

### (01:07:39) Tim Holley

**English:**
It is one of those where the old world of, we cut all our cords and we only needed Netflix. Suddenly you need all these really random providers of content that you're like, "I have to subscribe to that now to watch this show?"

**中文翻译:**
确实。以前我们剪掉电缆，只需要 Netflix。现在突然间你需要所有这些随机的内容提供商，你会想：“为了看这个剧，我现在必须订阅那个？”

---

### (01:07:51) Lenny

**English:**
Don't understand where this even is. Just take my money. Favorite interview question you like to ask candidates?

**中文翻译:**
搞不懂在哪儿，直接拿走我的钱吧。你最喜欢问应聘者的面试问题是什么？

---

### (01:07:58) Tim Holley

**English:**
I'm a big fan of case studies, live case studies. I think you learn a whole boatload about how someone thinks on the fly, how they react to constraints. So we use those. I've used those a ton. We use them pretty heavily in product interviews. So I love those modulated for the type of business you're in, what you're actually trying to understand. The other one I like to ask is around something that people have taught themselves, tried to get at a growth mindset. I think Julia, who was on the podcast a while ago, said something similar. But you get a ton of insight into someone. Ideally, you get a bit of passion and you often get something to go research. She's like, "I don't know anything about that topic. I want to learn a little more."

**中文翻译:**
我非常喜欢案例分析，即兴的案例分析。我认为你可以学到很多关于一个人如何即兴思考、如何应对约束的知识。我们经常使用这些，我在产品面试中大量使用。我喜欢根据业务类型和你真正想了解的内容来调整这些案例。另一个我喜欢问的问题是关于人们自学的东西，试图了解他们的成长型思维。我想不久前上过播客的 Julia 也说过类似的话。你可以从中获得对一个人的大量洞察。理想情况下，你会看到一点热情，而且通常你会得到一些值得去研究的东西。比如：“我对那个话题一无所知，我想多了解一点。”

---

### (01:08:40) Lenny

**English:**
What is a favorite product that you've recently discovered that you love?

**中文翻译:**
你最近发现并喜爱的产品是什么？

---

### (01:08:44) Tim Holley

**English:**
You as a new parent maybe resonates when... So it's not new, because our kids too. But when I was looking, being in product, of course you want to track data. And so I was looking for apps that would be good at doing that, and they nearly all look like hideous medical charts where I just don't want to engage with that. I found this one app, I think it's called Nara Baby or Nara something. Super simple, allows both parents to enter information. Probably grandparents too. We only tested it with two people. Seamlessly syncs. Really easy to use. So at 4:00 AM when you can't see and you just want to say, "I fed the baby," you can do that really easily. Just really, really simple, fit for purpose product. So that resonated with me.

**中文翻译:**
作为一个新手父母，你可能会有共鸣……虽然它不新了，因为我们的孩子都两岁了。但当我寻找时，作为产品人，你当然想追踪数据。我当时在找好用的 App，但它们几乎看起来都像丑陋的医疗图表，我根本不想用。我发现了一个 App，我想叫 Nara Baby 或者 Nara 什么的。超级简单，允许父母双方输入信息，可能祖父母也可以，我们只测试了两个人。无缝同步，非常好用。所以在凌晨 4 点，当你眼睛都睁不开，只想记录“我喂了孩子”时，你可以非常轻松地完成。非常简单、切合需求的产品，这引起了我的共鸣。

---

### (01:09:31) Lenny

**English:**
I'm going to be downloading that right now. I've been using Huckleberry, which is both awesome and not awesome, and so awesome tip. Great. What is a favorite life motto that you like to repeat often or share with other people, either in work or in life?

**中文翻译:**
我现在就去下载。我一直在用 Huckleberry，它既好用又不好用，所以这个建议太棒了。太好了。你经常重复或与他人分享的人生格言是什么，无论是在工作中还是生活中？

---

### (01:09:44) Tim Holley

**English:**
One of the things I talk about maybe internally more than anything else, but all or nothing. Go all in. Go do the thing. In German [German 01:10:08]. I grew up in Germany, so that's something I say to myself a lot is if you're going to do it, do it properly. I think those are often helpful words to live by.

**中文翻译:**
我在内部说得最多的可能是“要么不做，要么全做”（All or nothing）。全力以赴，去做那件事。德语里有一句 [德语 01:10:08]。我在德国长大，所以我经常对自己说：如果你要做，就把它做好。我认为这些话通常是很有帮助的人生准则。

---

### (01:10:04) Lenny

**English:**
I love that. Final question, what's a favorite item you recently discovered on Etsy?

**中文翻译:**
我喜欢这个。最后一个问题，你最近在 Etsy 上发现的最喜欢的商品是什么？

---

### (01:10:10) Tim Holley

**English:**
I recently bought an engraved whiskey decanter for my wife and myself, or for the home. Super beautiful, so cool. Got it personalized with our names. Just such a cool, cool item, that I wasn't expecting to find that kind of thing. I'm not even sure exactly how you engrave a whiskey decanter, but it was really cool. And the other thing, I'm always on the lookout for greeting cards. If anyone has great greeting card seller recommendations, I'm all ears. I love giving out physical greetings cards to folks, so that's another always on Etsy favorite of mine.

**中文翻译:**
我最近为我妻子和我自己（或者说为家里）买了一个刻字的威士忌醒酒器。非常漂亮，非常酷。上面刻了我们的名字。真是个非常酷的商品，我没预料到能找到这种东西。我甚至不确定威士忌醒酒器是怎么刻字的，但真的很酷。另一件事是，我一直在寻找贺卡。如果有人有好的贺卡卖家推荐，我洗耳恭听。我喜欢给人们送纸质贺卡，所以那是我的另一个 Etsy 常青最爱。

---

### (01:10:51) Lenny

**English:**
Tim, we've talked about growth, culture, surfing, cabins, leadership. Thank you so much for being here. I'm downloading the Nara app right now as we speak. Two final questions. Where can folks find you online if they want to reach out and maybe learn more, and how can listeners be useful to you?

**中文翻译:**
Tim，我们聊了增长、文化、冲浪、木屋、领导力。非常感谢你能来。就在我们说话的时候，我正在下载 Nara App。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？听众能为你提供什么帮助吗？

---

### (01:11:06) Tim Holley

**English:**
Yeah, yeah, find me on LinkedIn. That's probably... Well, not probably, is my most professional platform. Instagram, like I said, is a farce. And being useful. Yeah, send me things that you're excited about in the Etsy product. Send me feedback. We're always really keen to learn how folks are experiencing the things that we build.

**中文翻译:**
是的，在 LinkedIn 上找我。那可能……不，那确实是我最专业的平台。Instagram 就像我说的，只是个消遣。至于帮助，是的，把你在 Etsy 产品中感到兴奋的东西发给我。给我反馈。我们一直非常渴望了解大家对我们构建的东西的体验。

---

### (01:11:26) Lenny

**English:**
Amazing. Tim, thank you so much for being here.

**中文翻译:**
太棒了。Tim，非常感谢你能来。

---

### (01:11:28) Tim Holley

**English:**
Thank you for having me, Lenny. Appreciate it.

**中文翻译:**
谢谢你的邀请，Lenny。非常感激。

---

### (01:11:30) Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这一集有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。