# Timothy Davis - 双语对照

以下是 Lenny Rachitsky 对话 Timothy Davis 关于绩效营销与付费增长的完整双语访谈记录。

---

### [00:00:00] Lenny Rachitsky

**English:**
Is performance marketing just something every company should be doing?

**中文翻译:**
绩效营销（Performance Marketing）是每个公司都应该做的事情吗？

---

### [00:00:02] Timothy Davis

**English:**
Hot take, paid is for everyone. If you look at the way each platform is doing, Google, you have to scroll pretty far down to get to an organic listing. Meta, it's almost a pay for play now.

**中文翻译:**
我的观点可能比较激进：付费推广适合所有人。如果你看看各个平台的现状，在 Google 上，你得往下翻好久才能看到自然搜索结果；而在 Meta 上，现在几乎已经是“付费才能参与”的游戏了。

---

### [00:00:13] Lenny Rachitsky

**English:**
When you take over for an agency at a company, you crush their performance within a month. I'm curious to what you find they are doing wrong?

**中文翻译:**
当你接手一家公司的代理机构业务时，你通常能在一个月内大幅提升他们的业绩。我很想知道，你发现他们通常哪里做错了？

---

### [00:00:20] Timothy Davis

**English:**
Instead of thinking about being on top of the page, and that's like ego marketing, I want to be number one. I want to be there all the time. It's about showing to the right person as often as possible.

**中文翻译:**
很多人只想着排在页面顶端，那更像是“自尊心营销”（Ego Marketing）——我必须拿第一，我必须时刻出现在那里。但真正的关键在于，尽可能频繁地向“正确的人”展示广告。

---

### [00:00:31] Lenny Rachitsky

**English:**
Any other tips for people just to experiment with the platform?

**中文翻译:**
对于那些刚开始在平台上做实验的人，还有什么建议吗？

---

### [00:00:33] Timothy Davis

**English:**
Each platform is different. The user behavior is different. Make sure you're not too hard on yourself if it doesn't work. It's okay to fail because we're either winning or we're learning.

**中文翻译:**
每个平台都不同，用户行为也不同。如果实验没成功，别对自己太苛刻。失败没关系，因为我们要么是在赢，要么是在学习。

---

### [00:00:45] Lenny Rachitsky

**English:**
Today, my guest is Timothy Davis. Timothy has led performance marketing for all of Shopify for the past two and a half years, and as a consultant has helped companies like Pinterest, LinkedIn, Redfin, and Eventbrite kickstart and scale the performance marketing teams. In our conversation, we get incredibly tactical on all things to performance marketing and paid growth, when to start investing, how to run signs of life tests on each platform, what platforms to investigate and what platforms to bet big on, what types of companies are best suited to invest big on paid growth whether you should invest pre-product market fit or not, what agencies often get wrong and what to look for in your investment when you're just getting started? Plus, what your first three hires should look like, tips for which platforms are most interesting right now, a peek at Timothy's actual reports that he runs to judge performance, if you're watching this on YouTube and so much more.

**中文翻译:**
今天的嘉宾是 Timothy Davis。Timothy 在过去两年半里一直领导 Shopify 全球的绩效营销工作。作为顾问，他曾帮助 Pinterest、LinkedIn、Redfin 和 Eventbrite 等公司启动并扩大了绩效营销团队。在我们的对话中，我们将深入探讨绩效营销和付费增长的所有实操细节：何时开始投入、如何在各平台运行“生命迹象”（Signs of Life）测试、哪些平台值得调研、哪些值得重仓、什么样的公司最适合大规模投入付费增长、在达到产品市场契合（PMF）之前是否应该投入、代理机构经常犯什么错，以及刚起步时该如何衡量投入？此外，我们还会聊到前三名员工该招什么样的人、目前最值得关注的平台建议，如果你在 YouTube 上观看，还能看到 Timothy 用来评判业绩的真实报告等等。

---

### [00:01:37] Lenny Rachitsky

**English:**
This episode is for anyone who's trying to figure out how to kickstart or improve their performance marketing investment, and I guarantee you'll get something out of this that'll make your life better. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you Timothy Davis. Timothy, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
这一集是为那些想要启动或优化绩效营销投入的人准备的，我保证你会从中受益匪浅。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过后续节目的最好方式，也对我们很有帮助。现在，让我们欢迎 Timothy Davis。Timothy，非常感谢你能来，欢迎来到本节目。

---

### [00:02:04] Timothy Davis

**English:**
Yeah, thanks for having me. A long time coming.

**中文翻译:**
谢谢邀请，期待已久了。

---

### [00:02:06] Lenny Rachitsky

**English:**
Yeah, I'm really excited we're finally doing this. I actually posted on Twitter for people to suggest questions for this topic and there's just so much interest in what we're going to be talking about, which essentially we're going to be diving deep into all things paid growth, all things performance marketing. By the way, I have a cold. For people, if in case you wonder why I sound a little weird, but the show must go on. I want to start with just setting a little context for folks that aren't super familiar with performance marketing and paid growth. When we talk about performance marketing/paid growth, first of all, are those two terms interchangeable to you? And second of all, what falls under the umbrella of performance marketing/paid growth?

**中文翻译:**
是的，我也很兴奋。我之前在 Twitter 上征集过相关问题，大家对我们要聊的话题非常感兴趣，也就是深入探讨付费增长和绩效营销。顺便说一下，我感冒了，如果听起来声音有点怪请见谅，但节目还得继续。我想先为不太熟悉这些概念的听众做个铺垫。当我们谈论绩效营销和付费增长时，首先，这两个词对你来说是可以互换的吗？其次，绩效营销/付费增长具体涵盖哪些内容？

---

### [00:02:42] Timothy Davis

**English:**
Paid can be a lot of things. It can be online, it can be offline, it can also even be affiliates. Typically, when I talk about performance marketing, it's about online only, but you could argue offline could be performing and affiliates could be performing and stuff like that. They can be interchangeable, but I would recommend if you are talking about it, to specify which one you're talking about. Because when you do say paid, because I'm in the industry, I would just, "Oh, they do Google Search and they do Meta and they do things like that." But if you do offline and you just say paid, we may be talking about things, but missing each other on two ships passing in the night. So I think historically, people, when they have said paid growth, have been fully focused on just online.

**中文翻译:**
“付费”（Paid）包含很多东西。它可以是线上的、线下的，甚至可以是联盟营销（Affiliates）。通常当我谈论“绩效营销”时，指的是纯线上部分，但你也可以争论说线下和联盟营销也可以是看绩效的。这两个词可以互换，但我建议在讨论时最好明确具体指哪一个。因为作为业内人士，当你提到“付费”时，我会自动联想到 Google 搜索广告、Meta 广告之类的。但如果你做的是线下却只说“付费”，我们可能聊不到一块儿去，就像黑夜中错过的两艘船。我认为从历史上看，人们说“付费增长”时，通常完全聚焦于线上。

---

### [00:02:43] Lenny Rachitsky

**English:**
Just online. Okay. Got it.

**中文翻译:**
只是线上。好的，明白了。

---

### [00:03:31] Timothy Davis

**English:**
But I would argue in the last couple of years, you could definitely roll offline into that conversation as well.

**中文翻译:**
但我认为在过去几年里，你绝对也可以把线下部分纳入这个讨论范畴。

---

### [00:03:38] Lenny Rachitsky

**English:**
Okay. So performance marketing, when someone hears that term, it's essentially marketing that you can measure the performance up.

**中文翻译:**
明白。所以“绩效营销”，顾名思义，本质上就是你可以衡量其效果（Performance）的营销。

---

### [00:03:43] Timothy Davis

**English:**
Correct. Yes, nail on the head.

**中文翻译:**
没错，一针见血。

---

### [00:03:46] Lenny Rachitsky
*(Note: This segment is a sponsor advertisement for BuildBetter.ai and OneSchema. I will provide the translation for completeness.)*

**English:**
This episode is brought to you by buildbetter.ai... [Ad content omitted for brevity but translated below]

**中文翻译:**
本集节目由 buildbetter.ai 赞助。早在 2020 年 AI 还是个玩具时，BuildBetter 就赌它能减少产品团队的运营琐事。快进到今天，已有 23,000 个产品团队每天使用 BuildBetter 的定制 AI。首先，它能将产品调用、销售电话、支持工单等非结构化数据转化为结构化洞察。其次，它能将这些洞察转化为工作流。使用代码 LENNY 可获得 100 美元抵扣。此外，感谢 OneSchema 的支持，他们帮助产品团队轻松导入复杂的 CSV 数据，如 ERP 系统数据。

---

### [00:06:32] Lenny Rachitsky

**English:**
Is performance marketing just something every company should be doing or is there certain business models where it's like, "No, you're probably going to grow through other channels mostly like SEO or sales or word of mouth."

**中文翻译:**
绩效营销是每家公司都应该做的事情吗？还是说某些商业模式更适合通过 SEO、销售或口碑等其他渠道增长？

---

### [00:06:42] Timothy Davis

**English:**
Hot take. I would say, paid is for everyone. If you look at the way each platform is doing, Google introducing AI, plus with paid taking up the first four spots, you have to scroll pretty far down to get to an organic listing. Meta, it's almost a pay for play now. You have to do promoted posts for people to even see your content. I would say it does depend on the industry you're in. If you're say, leaning heavily into influencer marketing, that is still a paid component. You may not be doing Meta ads, you may not be doing paid search, but that is a paid component. But I would say at baseline, everyone should be doing paid search. The way I usually explain it to people is paid search is user driven. You have to type in a relevant keyword for your ad to show. Anything else is more disruptive media.

**中文翻译:**
激进观点：我认为付费推广适合所有人。看看现在的平台趋势，Google 引入了 AI，加上付费广告占据了前四个位置，你得翻很久才能看到自然排名。Meta 几乎成了“付费玩家”的天下，你必须投流推广，别人才能看到你的内容。当然，这取决于你所在的行业。如果你重度依赖红人营销，那其实也是付费的一部分。你可能没投 Meta 广告或搜索广告，但那依然是付费组件。但我认为最起码，每个人都应该做付费搜索广告。我通常这样解释：付费搜索是“用户驱动”的，用户必须输入相关的关键词，你的广告才会显示。除此之外的其他形式大多属于“干扰式媒体”（Disruptive Media）。

---

### [00:07:36] Timothy Davis

**English:**
You're on Meta and you're looking at pictures of babies and cats, and then all of a sudden, you see an ad for Shopify. You're watching a YouTube video, maybe a YouTube podcast, and then in between, you get advertisements maybe for Shopify, maybe for Pinterest, maybe for Eventbrite. So all of that being disruptive media may not make a whole lot of sense for where you are as a business, but I would say paid search being user-driven, having to type in a relevant keyword for your ad to show, should pretty much be for just about everybody.

**中文翻译:**
比如你在 Meta 上看婴儿和猫的照片，突然看到 Shopify 的广告；或者你在看 YouTube 视频，中间插播了 Shopify 或 Pinterest 的广告。这些干扰式媒体可能并不适合你业务所处的阶段，但付费搜索是用户主动寻找的，只要用户输入相关关键词广告才出现，这几乎适合所有人。

---

### [00:08:11] Lenny Rachitsky

**English:**
Everyone should do it. Super interesting. There's also the most companies grow through one growth engine primarily, say word of mouth, or SEO, or sales or paid. So for some companies, paid will be most of how they grow like say, I always think of Booking.com and Credit Karma and just like most of their growth came from paid growth online, paid growth. For some companies, it's just like a layer, a small 10, 20% of their growth. What are signs that you have the potential for paid/performance marketing to be most of your growth, like say 70, 80%?

**中文翻译:**
每个人都该做，这很有趣。大多数公司主要通过一个增长引擎发展，比如口碑、SEO、销售或付费。对某些公司来说，付费是主要的增长方式，比如 Booking.com 和 Credit Karma，他们大部分增长来自线上付费。但对另一些公司，付费只是锦上添花，占 10-20%。有哪些迹象表明，一家公司有潜力让付费/绩效营销成为增长的主力（比如占 70-80%）？

---

### [00:08:47] Timothy Davis

**English:**
I always say, where are your users? You will have some data that will allow you to understand that say right now, you're doing really well on TikTok. Some would argue that's an emerging channel right now. Great. If that's doing really well for you, maybe you take... Because that content could be used on something similar like Snap, see how that does for you. You could also lean into your Google Analytics or whatever analytics tool you are using and see if you're already getting users from that platform. If you're currently managing that, if you don't have a profile on there and obviously, you don't have a presence, it would be really hard for users to find you and get there. But always look at the data that's available to you within your analytics platforms and say, "Users are already finding us here. How can we turn that knob up to 11?" And you can do that with paid.

**中文翻译:**
我总是问：你的用户在哪里？你可以通过数据了解到，比如你现在在 TikTok 上表现很好。有人会说那是新兴渠道，太棒了，既然表现好，也许你可以把这些内容用到类似的平台（如 Snap）上试试。你也可以查看 Google Analytics 或其他分析工具，看看是否已经有用户从某个平台过来了。如果你在某个平台上完全没有账号或存在感，用户很难找到你。但一定要看现有数据：“用户已经在这里发现我们了，我们怎么能把这个旋钮拧到最大（Turn it up to 11）？”通过付费手段，你就能做到这一点。

---

### [00:09:46] Lenny Rachitsky

**English:**
Is there an example of a company you worked with that's known that as an example of that, where you're like, "Oh, I see everyone's looking, finding them on Google. Let's go turn it to 11."

**中文翻译:**
有没有你合作过的公司例子？比如你发现大家都在 Google 上找他们，然后你说：“咱们把它开到最大吧。”

---

### [00:09:55] Timothy Davis

**English:**
Yeah. So there was a company I worked with a couple of years ago called, Hairstory and IPSY. I know, very funny. Guy with no hair working on a company called Hairstory, but they were doing really well from a Google shopping standpoint. But when I started consulting with them, we looked at the analytics and we actually saw that they were getting a lot of people from Meta and TikTok at the time. And TikTok was very, very new and they didn't really know what to do with it. So said, "We'll do a small test." We can start on Meta with just some customer testimonials. Let's see how that does. We'll get interest in, build a funnel, get retargeting, and hopefully get conversions. TikTok was so new at the time that it was like, "We don't know what's going to work. Let's just try with what is currently available."

**中文翻译:**
有的。几年前我合作过 Hairstory 和 IPSY。我知道这挺好笑的，一个没头发的人在一家叫 Hairstory（头发故事）的公司工作。当时他们在 Google Shopping 上表现很好。但我开始为他们提供咨询时，我们查看了分析数据，发现当时有很多用户来自 Meta 和 TikTok。那时 TikTok 还非常新，他们不知道该怎么办。于是我说：“我们做个小测试。”我们先在 Meta 上投放一些客户证言广告，看看效果。建立漏斗，做再营销（Retargeting），争取转化。当时 TikTok 太新了，我们不知道什么会奏效，就决定用现有的素材先试试。

---

### [00:10:47] Timothy Davis

**English:**
Then once we started doing it, we started noticing, "Hey, this doesn't make a whole lot of sense from a creative standpoint." We were missing the mark of what we were using on Meta was working, was not working on TikTok. So you can't always just take what is currently working on one platform and apply it to another because it is a different user experience. It is a different mindset that the user has when they're on there. So that was an example of where we were able to take those instances, look at their data and say, "They're already finding us here. How can we turn this up a little bit?" And I don't remember the numbers exactly, but it was pretty exponential.

**中文翻译:**
一旦开始做，我们就发现：“嘿，从素材（Creative）角度来看，这不太对劲。”我们在 Meta 上奏效的东西，在 TikTok 上完全不行。所以你不能直接把一个平台的成功经验生搬硬套到另一个平台，因为用户体验和用户心态完全不同。这就是一个例子：我们观察数据，发现用户已经在那里了，然后决定加大投入。我不记得确切数字了，但增长是指数级的。

---

### [00:11:24] Lenny Rachitsky

**English:**
Okay. So the core advice here so far, is look for where people are coming to you from today, and then that gives you a sign of where you should start to think about running paid ads, performance marketing on those platforms.

**中文翻译:**
明白。所以到目前为止的核心建议是：观察现在人们是从哪里找到你的，这会给你一个信号，告诉你应该开始考虑在哪些平台上投放付费广告或做绩效营销。

---

### [00:11:38] Timothy Davis

**English:**
Yeah. And also, there's a saying that my current director likes to use, which is signs of life. You can always do a very, very small test. You can just put a little money into a platform, see if there's a sign of life. If there is, then you can pull back and say, "Okay, we have signs of life. Now let's build a campaign around that." There's no reason to say, "All right, we have a signs of life. Let's now turn it up all the way." Do we have the right creative? Do we have the right campaign? Do we have the right messaging for the users on this platform? Then let's take that approach, as opposed to just, "Hey, signs of life, great, go run a hundred miles an hour." Make sure you're doing the right thing when you get into those platforms.

**中文翻译:**
没错。我现在的总监喜欢用一个词叫“生命迹象”（Signs of Life）。你总是可以先做一个极小的测试，投入一点点钱，看看有没有反应。如果有，再退回来想：“好，有戏了，现在我们围绕这个构建一个完整的营销活动。”没必要一看到苗头就立刻全速前进。我们要思考：素材对吗？活动设置对吗？针对该平台用户的信息传递对吗？要采取这种稳扎稳打的方法，而不是一看到“生命迹象”就盲目狂奔。进入新平台时，确保每一步都走得正确。

---

### [00:12:22] Lenny Rachitsky

**English:**
Let's follow that thread. A lot of people run little experiments on say, TikTok, and Snap, and Twitter, and things like LinkedIn, and they often don't see a lot of results and it's always like, "Hey, did we do it wrong or is it the platform's not working?" I know it's a very difficult question to give like, "Here's how you do a sign of life test correctly," But what are some things that you think either people do often wrong when they're trying to experiment with the platform or that you just think they should do when they're trying to look for signs of life?

**中文翻译:**
顺着这个话题聊聊。很多人在 TikTok、Snap、Twitter 或 LinkedIn 上做小实验，往往看不到什么结果，然后就会纠结：“是我们做错了，还是平台不行？”我知道很难给出一个标准答案，但你认为人们在寻找“生命迹象”时，通常哪些地方做错了？或者你认为他们应该怎么做？

---

### [00:12:49] Timothy Davis

**English:**
The number one thing I tell people all the time is use your own data, start with your own data. So take the existing customer base you have, load that up into the platform to build lookalikes. From there, you can do... And I'll use Meta as the example. You can do a 1%, all the way up to a 10%. So 1% match, 2%, 3%, so on and so forth. What I tend to do is build ad sets, one at 1% because we know that one's going to be highly correlated to what we're looking for. Then a two to four, and then a five to seven, and then an eight plus. More times than not, the eight plus does not work, but there have been times where it has, so it's, "Hey, let's do it. Let's try it." But if you also have a very limited budget because some people don't have the luxury of having an unlimited budget like we do in some of these other companies I've worked at, just start with the 1%. See what that sign of life is because you already know that this is so tied to your existing customer base.

**中文翻译:**
我一直强调的第一件事是：利用你自己的数据，从自有数据开始。把你现有的客户群数据上传到平台，建立“类似受众”（Lookalikes）。以 Meta 为例，你可以设置 1% 到 10% 的相似度。我通常会建立不同的广告组：一个 1% 的，因为我们知道这部分人与目标高度相关；然后是 2-4%，5-7%，以及 8% 以上。大多数情况下，8% 以上的效果不好，但偶尔也会有惊喜。如果你的预算非常有限（不像我待过的一些大公司那样预算充足），那就从 1% 开始。看看这部分的“生命迹象”，因为这部分受众与你现有客户最接近。

---

### [00:14:02] Lenny Rachitsky

**English:**
What are these percentages referring to? You may have mentioned it, but when you say 1%, 2%, 3%.

**中文翻译:**
这些百分比具体指什么？你刚才提到了，但能详细解释下 1%、2%、3% 的含义吗？

---

### [00:14:07] Timothy Davis

**English:**
Yeah, yeah. So that is how closely tied they are to that user's behavior on the platform. So they're 1% tied to what they're doing. They're visiting similar pages or they have similar behavior on the platform, so they're more than likely going to be tied to what that user... They're not going to be that user exactly, but they're going to be very correlated to them where 10% is pretty wide base that you're going hit.

**中文翻译:**
是的。这代表了这些受众与你现有用户在平台行为上的接近程度。1% 意味着他们与你用户的行为高度一致，比如访问类似的页面或有类似的操作，所以他们极有可能产生关联。他们不是原用户本人，但相关性极高。而 10% 则是一个非常广泛的受众群。

---

### [00:14:35] Lenny Rachitsky

**English:**
I see. So the smaller the percentage, the closer they are, the closer it will look like there.

**中文翻译:**
明白了。百分比越小，受众就越精准，看起来就越像你的现有客户。

---

### [00:14:39] Timothy Davis

**English:**
Yep, there you go.

**中文翻译:**
没错，就是这样。

---

### [00:14:40] Lenny Rachitsky

**English:**
How do you know if it's the creative that is failing versus it's just never going to work? Is there something that tells you that's what's not working?

**中文翻译:**
你怎么判断是“素材”不行，还是这个渠道“根本行不通”？有什么指标能告诉你到底是哪里出了问题吗？

---

### [00:14:47] Timothy Davis

**English:**
It's a million-dollar question, to be honest with you. Because you could look at some of the metrics that currently exist in the platform. Click-through rate basically just tells you, are the users engaged? Because start with the target. You're getting the impressions are there. Is the target right? That should be your first thing. Yes, the target is correct. Users that we want to see are seeing our ads, but they're not engaging with it. That would be the first thing. But the part that I think you're really trying to ask is creative versus the content. Because sometimes depending on the ad unit, you could have a story creative that is literally the creative has to stand on its own, not necessarily the content that's in it, but something like an in-feed creative has a headline, a primary, a description, and a creative.

**中文翻译:**
老实说，这是一个价值百万美元的问题。你可以看平台现有的指标。点击率（CTR）基本上告诉你用户是否参与了。首先看目标受众：展示量（Impressions）有了，受众对吗？这是第一步。如果受众是对的，我们想找的人看到了广告但没点击，这就是个信号。但我认为你真正想问的是“视觉素材”与“内容”的区别。因为根据广告形式的不同，比如 Story 广告，素材本身必须能独立吸引人；而 Feed 流广告则包含标题、正文、描述和素材。

---

### [00:15:15] Timothy Davis

**English:**
That's where honestly, the only way you're going to get an answer to that outside of the data that's available to you like click-through rate, reach, frequency and all those things to pull in more metrics, is a focus group to understand, "Hey, when you saw this image with this content, what was your result from it?" Now, you can build a test within the platform to do a control versus a test where say, you take the creative with the same primary and the same description versus a creative that's just your logo with the headline and the description and see what the results are. But more times than not, you're not getting the understanding from the user of, well, why doesn't that creative resonate with you? And they'll give you suggestions in the focus group. Why does that work better for you than not? So that's a really, really hard question to answer without having those dialogue with the user to understand that.

**中文翻译:**
说实话，除了点击率、触达率、频次等数据外，唯一能得到答案的方法就是通过焦点小组（Focus Group）去了解：“当你看到这张图片配上这段文字时，你有什么感觉？”当然，你可以在平台内做 A/B 测试，比如用同样的文案配不同的图片，或者配一个只有 Logo 的图片看结果。但大多数时候，你无法从数据中得知用户“为什么”没产生共鸣。焦点小组能告诉你原因。如果不与用户直接对话，这确实是一个很难回答的问题。

---

### [00:16:34] Lenny Rachitsky

**English:**
Yeah, that makes a lot of sense. How long do you recommend these tests run for these signs of life tests? And I like this term, by the way. I haven't heard this before.

**中文翻译:**
很有道理。你建议这些“生命迹象”测试运行多久？顺便说一下，我很喜欢这个词，以前没听过。

---

### [00:16:40] Timothy Davis

**English:**
Ideally, in a perfect world, you're going to hear the word, statistical relevance. Mathematicians will tell you exactly what that number is. And I'm not going to pretend like a mathematician, but a lot of times, it's budget constraint. So there could be a VP finance. Anyone like that could just come to you and just say, "Hey, do you have $25,000 for this test?" You only have 5,000. Just get that information, get that data. You can then also build an off size off of that. Hey guys, we worked with our Meta partners, we worked with our Google partners. We put $1,000 behind this test. We know that our impression share was this, our reach was this. If we were to put $10,000 into it, this is the expected return we can get from it based on the click-through rate, the conversion rate that we got from the test that we ran.

**中文翻译:**
理想情况下，你会听到“统计学显著性”（Statistical Relevance）这个词。数学家会告诉你确切的数字。我不想冒充数学家，但现实中往往取决于预算限制。财务副总裁可能会问你：“这个测试要 2.5 万美元吗？”而你只有 5000 美元。那就用这 5000 美元去获取数据。然后你可以基于此做推演：我们投入了 1000 美元，展示份额和触达率是多少，如果投入 1 万美元，基于目前的点击率和转化率，预期的回报会是多少。

---

### [00:17:34] Lenny Rachitsky

**English:**
Got it. Basically, we have limited number of dollars to spend. That'll tell you how long you could run one of these for.

**中文翻译:**
明白了。基本上，预算决定了你能跑多久。

---

### [00:17:41] Timothy Davis

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:17:42] Lenny Rachitsky

**English:**
Any other tips for someone that's trying to experiment with a platform early on for these signs of life tests? So one is try a lookalike that is the most targeted version of the lookalike. So 1% you said, and then incrementally grown and incrementally increase that percentage as you spend more. Any other tips, I guess, for people just to experiment with the platform?

**中文翻译:**
对于那些早期尝试“生命迹象”测试的人，还有什么建议吗？第一条是尝试最精准的类似受众（1%），然后随着投入增加逐渐扩大比例。还有别的吗？

---

### [00:18:04] Timothy Davis

**English:**
Make sure you're not too hard on yourself if it doesn't work. A lot of times, companies I've either consulted with or worked at, there was always pressure or there was always a need to succeed at whatever experiment we put into market. I believe in creating an environment where it's okay to fail because we're either winning or we're learning. And more times than not, if we put something new into a platform that we know nothing about, we're learning the bells and whistles, we're learning the functionality of it. Just know there's going to be things you're not going to understand because each platform is unique, each platform is different, the user behavior is different. So give yourself some grace, understand that this may not work. And as long as you're learning from it, you're going to be okay.

**中文翻译:**
如果没成功，别对自己太苛刻。我咨询过或工作过的很多公司，总是有一种必须成功的压力。但我相信应该创造一个“允许失败”的环境，因为我们要么是在赢，要么是在学习。当我们进入一个陌生的新平台时，我们是在学习它的各种功能和门道。要明白每个平台都是独特的，用户行为也不同。给自己一点宽容，接受可能失败的现实。只要你能从中学习，就没问题。

---

### [00:18:56] Lenny Rachitsky

**English:**
I love that. In terms of which platforms people should explore, obviously there's Google, there's Facebook, Instagram, what are the platforms people should seriously consider at this point?

**中文翻译:**
太棒了。关于平台选择，除了 Google、Facebook、Instagram，现在大家还应该认真考虑哪些平台？

---

### [00:19:09] Timothy Davis

**English:**
Google for sure. And when we say Google, let's make sure everyone understands what Google entails. Google is YouTube, Google is Google search, GDN, Google Display Network. There's a lot of things in Google that you can do. I always say, if you have the creative available, you should really, really be looking at doing video because video is one of those things that I'm very bullish on. It is doing really well when you measure it the right way. And as long as you can get that creative and get it consistently just because you have one piece of creative, if it's doing well, you do need to have that creative refresh, kind of that flywheel going. Make sure you're doing Google Search, again, user-driven, YouTube, and Meta, and Meta contains both Facebook and Instagram. And then based on the data available to you, if you do see users on TikTok, definitely go after those. But if you're just starting out and you just want to get your feet wet into something, I would say start with Google Search, then get into Meta. And if you have video available, definitely get into YouTube.

**中文翻译:**
Google 肯定要投。我们要明确 Google 包含什么：YouTube、Google 搜索、GDN（谷歌展示广告网络）。Google 有很多玩法。我总是说，如果你有素材，一定要看视频广告，我非常看好视频。只要衡量得当，视频表现非常好。但你不能只有一条素材，如果效果好，你需要持续更新素材，形成“素材飞轮”。确保你做了 Google 搜索（用户驱动）、YouTube 和 Meta（包含 Facebook 和 Instagram）。然后根据数据，如果你发现用户在 TikTok 上，那就去投 TikTok。但如果你刚起步想试水，我会建议先从 Google 搜索开始，然后是 Meta，如果有视频素材，一定要投 YouTube。

---

### [00:20:19] Lenny Rachitsky

**English:**
Awesome. Okay. So Google Search, YouTube, Facebook, Instagram, TikTok. What about LinkedIn? Do you see things happening there for say, B2B companies?

**中文翻译:**
太好了。Google 搜索、YouTube、Facebook、Instagram、TikTok。那 LinkedIn 呢？你觉得它对 B2B 公司有用吗？

---

### [00:20:30] Timothy Davis

**English:**
Yeah. LinkedIn is very expensive in comparison. So just know if you're going into LinkedIn, it's going to look almost three times more expensive than other channels. The targeting that's available on LinkedIn, knowing job titles, industries, actually targeting people at certain companies is very powerful. The example I always tend to use is that I worked at a company called SoftLayer. SoftLayer was acquired by IBM because they were trying to build out their cloud portfolio, couldn't do it. So they're like, "Hey, let's do the next best thing and buy this company." But when we were just SoftLayer, we were trying to get Coca-Cola as one of our clients. And you know those Coke freestyles where you can pick whatever drink you want and put the flavor in it?

**中文翻译:**
是的。相比之下 LinkedIn 非常贵。你要知道，LinkedIn 的成本可能是其他渠道的三倍。但它的定向功能非常强大：你可以根据职位、行业，甚至直接针对特定公司的员工。我常举的一个例子是我在 SoftLayer 工作时。SoftLayer 后来被 IBM 收购了，因为 IBM 想构建云业务但没成功，就决定买下我们。当时我们还是 SoftLayer，正试图拿下可口可乐这个大客户。你知道那种可乐自助机（Coke Freestyle）吗？就是你可以选饮料并加口味的那种。

---

### [00:21:21] Lenny Rachitsky

**English:**
No, that's awesome.

**中文翻译:**
知道，那太酷了。

---

### [00:21:22] Timothy Davis

**English:**
Oh man, these are great. Maybe it's a cell thing, but basically, you go up to a Coke freestyle and say, "I want Dr. Pepper and I want cherry flavor in it." Or you want Coke Zero with cherry and vanilla in it, you can do that. It's the freestyle you get to pick. The reason they wanted it to be cloud-based is because there's a ton of drinks in there. So you need to be able to efficiently and effectively say, "This store needs more Sprite or this store needs more Sprite Zero." Because you have your whole portfolio in this one machine, so you want to be able to update things more readily. And it was between us, AWS and Microsoft. And met with the sales team and said, "What do we need to do to win this?" Because it was a big ticket item for us.

**中文翻译:**
太棒了。基本上你可以选 Dr. Pepper 加樱桃味，或者可乐加樱桃和香草。可口可乐希望这些机器是基于云端的，因为饮料种类太多了，他们需要高效地监控：“这家店需要更多雪碧，那家店需要零度雪碧。”因为所有产品都在一台机器里，他们需要随时更新。当时竞争对手是 AWS 和微软。我问销售团队：“我们要怎么做才能赢？”因为这对我们来说是个大单。

---

### [00:22:14] Timothy Davis

**English:**
And what we found out was they had two concerns about us: it was recency and private security. So what we did was we found out where the decision makers were. So A, in LinkedIn, we took the anyone who works at Coca-Cola, we want you to see ads about security and recency. Outside of that, we also geo-fenced it because you would think Coca-Cola Atlanta, that's where the decision maker sits, but they were actually in LA. So in LA, we geo-fenced them, and we knew that they worked at Coca-Cola. The next time the salesperson got on the call with the team to say, "Hey, just wanted to check in." He was like, "Hey, hey, I get it. Security is fine. Recency is fine. We hear you." That was great to hear because it was something we were able to do on LinkedIn and we did it in other platforms as well. But we knew we were able to get not only to the decision maker, but everyone around that decision maker to say, "Hey, these guys may be the ones we need to go with."

**中文翻译:**
我们发现他们有两个顾虑：技术的新颖性（Recency）和私有安全性。于是我们做了两件事：第一，在 LinkedIn 上，我们针对所有可口可乐的员工投放关于安全性和新颖性的广告。第二，我们做了地理围栏（Geo-fencing）。你可能以为决策者在亚特兰大总部，但其实他们在洛杉矶。于是我们在洛杉矶做了定向。下次销售打电话过去时，对方说：“嘿，我明白了，安全性没问题，新颖性也没问题，我们收到你们的信息了。”这太棒了，因为我们在 LinkedIn 上不仅触达了决策者，还触达了决策者周围的所有人，让他们觉得“这家公司可能就是我们要找的”。

---

### [00:23:16] Lenny Rachitsky

**English:**
Okay. So just to mirror back what you're saying, you're saying you ran ads on LinkedIn targeting the execs at Coca-Cola, trying to influence them to overcome these barriers they had to buying to working with you guys. Amazing. I've seen people do that on Google Search, but I've never heard of... It makes so much sense to do on LinkedIn and it worked. And did they know that you did this or they're just like, "Oh, I just changed my mind"?

**中文翻译:**
明白。所以你的意思是，你在 LinkedIn 上针对可口可乐的高管投放广告，试图影响他们，消除他们与你们合作的障碍。太神奇了。我见过有人在 Google 搜索上这么干，但在 LinkedIn 上这么做非常有道理，而且奏效了。他们知道是你干的吗？还是觉得“哦，我只是改变主意了”？

---

### [00:23:42] Timothy Davis

**English:**
One of them was like, "We get it. We're seeing it everywhere." We actually tried because at the time, we didn't have an offline team. We actually tried to buy the billboards around the office as well, but I didn't know enough at the time from an offline perspective of the right people to talk to, how long it would take to do it. So we were trying to pour it on hard.

**中文翻译:**
其中一个人说：“我们明白了，到处都能看到你们。”当时我们甚至想买下他们办公室周围的广告牌，但那时我不懂线下广告的操作流程。总之，我们当时是火力全开。

---

### [00:24:03] Lenny Rachitsky

**English:**
That's incredible. I could see why LinkedIn is more expensive. That's incredibly powerful. And is the advice then that LinkedIn makes more sense for higher LTV, higher CB type of products?

**中文翻译:**
太不可思议了。我明白为什么 LinkedIn 更贵了，这功能太强大了。所以建议是，LinkedIn 更适合高终身价值（LTV）、高客单价的产品？

---

### [00:24:15] Timothy Davis

**English:**
Yeah, exactly. I would not recommend getting into LinkedIn and my LinkedIn reps may kill me for this. I would not recommend getting into LinkedIn until you've tested Google and Meta first. Now, you could be an enterprise level company and it does make sense to start with LinkedIn for sure, but depending on your audience, I would say more times than not, it would be a Google, Meta discussion before going to LinkedIn.

**中文翻译:**
没错。虽然 LinkedIn 的客户经理可能会想杀了我，但我建议在测试完 Google 和 Meta 之前，不要轻易碰 LinkedIn。当然，如果你是做企业级服务的公司，从 LinkedIn 开始是有道理的。但对于大多数人，在去 LinkedIn 之前，应该先讨论 Google 和 Meta。

---

### [00:24:40] Lenny Rachitsky

**English:**
Okay. So just generally, start with Google and Meta. Is there one or the other usually? I guess, yeah, which one would you start with if you had to pick one?

**中文翻译:**
好，通常从 Google 和 Meta 开始。如果非要选一个，你会先选哪个？

---

### [00:24:49] Timothy Davis

**English:**
Always Google Search. I'm always going to say, start with Google search, but it's also creative dependent. If you don't have the right creative for Facebook, it's going to be really hard to convert because users are just going to either be turned off by what you're putting out there. And then also, depending on where your user base is. If they're not on Facebook, it's kind of a moot point. But if they're browsing around on GDN or YouTube, it makes more sense to go there.

**中文翻译:**
永远是 Google 搜索。我会一直建议从 Google 搜索开始。但这也取决于素材。如果你没有适合 Facebook 的素材，很难转化，用户会被你的广告劝退。此外还要看用户在哪里，如果他们不在 Facebook 上，那就没意义。但如果他们在看 YouTube，那去 YouTube 更有意义。

---

### [00:25:15] Lenny Rachitsky

**English:**
And then you said this insight about video is performing super well right now and you're recommending people use video. And the key there is you need to be able to make videos, video ads.

**中文翻译:**
你提到视频广告现在表现非常好，建议大家使用。关键在于你得有能力制作视频广告。

---

### [00:25:25] Timothy Davis

**English:**
Yeah. You got to make sure you have that flywheel.

**中文翻译:**
是的，你得确保有那个“素材飞轮”。

---

### [00:25:27] Lenny Rachitsky

**English:**
And the flywheel is just people internally or some company agency that can make video ads for you?

**中文翻译:**
这个飞轮是指内部团队或者能为你制作视频广告的代理机构？

---

### [00:25:32] Timothy Davis

**English:**
Correct. Yep.

**中文翻译:**
没错。

---

### [00:25:33] Lenny Rachitsky

**English:**
Cool. I guess, is there any advice there of just how to do that or what ads work well or anything there for someone else-

**中文翻译:**
关于如何制作视频，或者什么样的视频广告效果好，有什么建议吗？

---

### [00:25:39] Timothy Davis

**English:**
So yeah. The thing with YouTube is I always say, start with emotion. If you can have an emotional connection with the user, is going to be way more impactful and way more powerful than anything else. And to take that further, when I say emotion, I'm talking about comedy, I'm talking about... happiness. It's not necessarily just, "Oh, we need an emotional connection with the brand." It is just making sure the user feels something after seeing your ad. Because then, they're more times not going to remember it, which then they will take a favorable action after the fact.

**中文翻译:**
关于 YouTube，我总是说：从“情感”开始。如果你能与用户建立情感连接，效果会比任何东西都强大。进一步说，我指的情感包括幽默、快乐等等。不一定非要是“品牌情感连接”，只要确保用户看完广告后有某种“感觉”就行。因为这样他们更容易记住你，随后产生转化行为。

---

### [00:26:21] Lenny Rachitsky

**English:**
That is super interesting. One last question about platforms. Are there any other platforms you see working for people that are emerging maybe that people aren't thinking about, Reddit, or Snap, or X, or I don't know, anything along those lines?

**中文翻译:**
很有意思。关于平台的最后一个问题：有没有其他你觉得有效的新兴平台，比如 Reddit、Snap、X 之类的？

---

### [00:26:34] Timothy Davis

**English:**
When you say emerging channels, my brain kind of goes to connected TV, podcast, VR, advertising, audio/voice search, and even AI stuff right now. I can tell you podcasts are doing really well for the people that I know are able to measure it correctly. Connected TV is also doing really well. You can take the, again, you're doing YouTube right now, being able to take that creative and repurpose it. But the VR stuff and the AI stuff, that is stuff that is, I would say, very emerging right now. Because to be completely transparent, I haven't experimented with those things yet. I kind of like letting other people be the guinea pig and learning from them.

**中文翻译:**
说到新兴渠道，我会想到联网电视（CTV）、播客、VR 广告、语音搜索，甚至现在的 AI 广告。我可以告诉你，对于那些能正确衡量效果的人来说，播客广告表现非常好。联网电视也不错，你可以把 YouTube 的素材拿去复用。至于 VR 和 AI 广告，目前还处于非常早期的阶段。坦白说，我还没尝试过这些，我喜欢让别人先当小白鼠，然后我再学习。

---

### [00:27:34] Lenny Rachitsky

**English:**
Awesome. Podcast ads. I'm glad you suggested that. I'm a huge fan. Thank you. They're working really well for a lot of our sponsors and I'm very biased, so you don't need to pay attention to me. But I also think there's a lot of opportunity there. Okay. Let's talk about when to start investing in performance marketing/paid growth. So, say, you're a startup, do you have any advice for when it's time to start, signs of life test or even... And then also, just when is it time to scale to go like, "Okay, let's go big on this."

**中文翻译:**
太棒了，播客广告。很高兴你提到这个，我是播客广告的死忠粉。它们对我们的很多赞助商效果都很好，当然我有立场，大家可以不听我的。但我确实认为那里有很多机会。好，聊聊什么时候开始投入绩效营销/付费增长。假设是一家初创公司，你对什么时候开始做“生命迹象”测试有什么建议？什么时候又该大规模投入？

---

### [00:28:08] Timothy Davis

**English:**
If you are a startup, typically, whenever I consulted with them, it was what are the goals, what are we trying to achieve, and when? Because if you're looking for something quick, paid needs to start immediate. And paid [inaudible 00:28:24] started yesterday because SEO takes time. SEO, depending on the market you're getting into, if it's emerging, people may not even know your product exists.

**中文翻译:**
如果你是初创公司，我通常会问：目标是什么？想实现什么？什么时候实现？如果你追求快速见效，付费推广必须立即开始。事实上，付费推广应该“昨天”就开始，因为 SEO 太慢了。而且取决于你进入的市场，如果是新兴市场，人们甚至不知道你的产品存在。

---

### [00:29:08] Timothy Davis

**English:**
You don't want to build awareness through search. You build awareness through display media-based type media. When we transitioned all of their money over at the time, and this will age me, before Meta was a thing, when we transitioned everything over to GDN, that's when the company started really reaping the rewards. Because we were building the awareness around the product. So, it depends on what is the demand of your product and market. If you're doing something that is similar to another product and market, you could do competitor, I call it coattail riding. Say, Lenny, you and I create a product that is similar to monday.com. We can go out there and just start bidding on monday.com and say, "See why Lenny and Tim are better than monday.com."

**中文翻译:**
你不想通过搜索来建立知名度，你应该通过展示类媒体。在 Meta 还没出现的时候（这暴露了我的年龄），我们把所有资金转到 GDN（谷歌展示网络），公司才真正开始获益，因为我们在建立产品知名度。所以，这取决于市场对你产品的需求。如果你做的是成熟市场的类似产品，你可以做竞品拦截，我称之为“搭便车”（Coattail riding）。比如 Lenny，咱俩做一个类似 monday.com 的产品，我们可以直接竞标 monday.com 的关键词，广告语写：“看看为什么 Lenny 和 Tim 比 monday.com 更好。”

---

### [00:30:33] Lenny Rachitsky

**English:**
Some people use paid ads to drive early growth to bring customers, to help them figure out what to build kind of pre-product market fit growth. Is that something you recommend? Is that something you'd advise against? Is that strategy that you've seen work?

**中文翻译:**
有些人用付费广告来驱动早期增长，获取客户以帮助他们弄清楚该做什么产品，也就是“前 PMF 阶段”的增长。你推荐这种做法吗？还是反对？你见过这种策略奏效吗？

---

### [00:30:48] Timothy Davis

**English:**
Yeah. Product market fit is a huge thing. We've run into some of this at Shopify, and we definitely ran into this at IBM. So, for the longest time, IBM is, "We're a global company, we should be everywhere." But when we started looking at the data, it was, "Should we be everywhere?" For example, Africa, we were in the whole continent. We weren't just in, say, South Africa, or Egypt, or something like that. And the more we dug into it, the more we realized the biggest issue wasn't necessarily that users weren't interested in our product and weren't purchasing it, it was because we didn't have a product market fit mainly from an operation standpoint.

**中文翻译:**
是的，PMF 非常关键。我们在 Shopify 遇到过，在 IBM 也遇到过。长期以来，IBM 的想法是：“我们是全球化公司，我们应该无处不在。”但看数据时，我们会问：“真的该无处不在吗？”比如在非洲，我们覆盖了整个大陆。但深入研究后发现，最大的问题不是用户没兴趣，而是我们在运营层面没有达到 PMF。

---

### [00:31:33] Timothy Davis

**English:**
In Africa, there are multitudes of different types of currency. There's the franc, there's the rand, there's the shill, and we were just, "Hey, USD, thank you." So, of course, they weren't converting unless they were going out of their way to make a way to convert that. So, when we took a step back and we said, "Okay, where do we want to start?" It was South Africa. That's really where we were trying to get, quote, unquote, "stronghold" in, so we had to make sure we had the rand available. Once we did that, we started doing tremendously better because we had a product market fit. They had demand for our product, and now we were able to serve them, meet them where they were.

**中文翻译:**
非洲有很多种货币，而我们当时只收美元。所以除非用户费尽心思去换汇，否则他们不会转化。当我们退一步说：“好，我们从哪儿开始？”答案是南非。我们想在南非建立据点，所以必须支持南非兰特。一旦支持了本地货币，业绩立刻好转，因为我们达到了 PMF。他们有需求，而我们现在能以他们的方式服务他们。

---

### [00:32:19] Lenny Rachitsky

**English:**
So essentially, you're saying probably not smart to run a bunch of ads if it's not working, if you don't have something people actually want yet in that market?

**中文翻译:**
所以本质上，如果产品还没做对，或者在那个市场还没人想要，大规模投广告是不明智的？

---

### [00:32:28] Timothy Davis

**English:**
Right. Or able to convert.

**中文翻译:**
对，或者无法转化。

---

### [00:32:31] Lenny Rachitsky

**English:**
Because conversion is going to end up being really low, no one actually cares about what you're doing.

**中文翻译:**
因为转化率会非常低，没人真的在乎你在做什么。

---

### [00:32:35] Timothy Davis

**English:**
All you're going to do is really annoy the users. Because, say, in the future they are, "Hey, I'm still interested, but I don't want to use that product because I already tried." It's like, "No, no, you can totally use it now." "I already tried. I had a bad experience with them." And some users will hold you accountable to that. One bad experience and I'm just never giving you my business.

**中文翻译:**
你只会惹恼用户。假设以后他们真的有需求了，可能会想：“我虽然有兴趣，但我不想用那家，因为我试过，体验很差。”即便你现在改好了，他们也不想再试。有些用户会记一辈子：一次糟糕的体验，就永远不再往来。

---

### [00:32:56] Lenny Rachitsky

**English:**
Interesting. So, is that generally your advice if you're startup, you're not feeling like you actually have product market fit yet, should you even experiment with and do signs of life tests, or should you hold off until it's like, "Okay, it's actually working, let's go."

**中文翻译:**
有趣。所以你的建议是，如果是一家初创公司，还没感觉到 PMF，是应该做“生命迹象”测试，还是应该等到“确实行得通”了再开始？

---

### [00:33:10] Timothy Davis

**English:**
From an operation standpoint, I always want to make sure those things are tied off. Yeah, it doesn't make sense to, again, if you have a major budget and you're trying to get awareness into a market, great, yeah, you can go after a market. But just know that it's probably not going to convert very well.

**中文翻译:**
从运营角度看，我希望先解决基础问题。如果你预算充足想做品牌知名度，可以去投。但要明白，转化率可能不会太好看。

---

### [00:33:29] Lenny Rachitsky

**English:**
Got it. So-

**中文翻译:**
明白了。所以——

---

### [00:33:31] Timothy Davis

**English:**
I wouldn't recommend it.

**中文翻译:**
我不推荐这么做。

---

### [00:33:31] Lenny Rachitsky

**English:**
Okay, great. Awesome. Very clear answer. Let's talk about the mistakes that you see companies make when they're investing in performance marketing. We got introduced through Casey Winters's illustrious former podcast guest, two-time podcast guest and asked them about you. And he told me that when you take over for an agency at a company that you've worked with, you crush their performance within a month. I'm curious to what you see and find they are doing wrong that allows you to be such a hero when you come in and take over.

**中文翻译:**
好，非常清晰的回答。聊聊公司在投入绩效营销时常犯的错误。我是通过 Casey Winters 认识你的，他是我节目的常客。他告诉我，当你接手一家公司的代理机构业务时，你通常能在一个月内让业绩翻倍。我很想知道，你发现他们到底哪里做错了，让你一接手就能成为“救世英雄”？

---

### [00:34:03] Timothy Davis

**English:**
I think agencies have playbooks. Now I've worked at agencies, I did consulting for a long period of time and it was never an approach I took. I looked at each account and each company as its own thing. But I think a lot of agencies just come in and they go, "Oh, this is like AB&C company. And this is what we're doing. Copy, paste, done, move on." And they're also not willing to get deep, deep, deep into the weeds of stuff. I may get a little too far into data than some other people. For example, I have ops cadence that myself and my team follow. So, within that ops cadence, we have things like finance, performance, structure, keywords, ad copy, quality score, targeting, et cetera, et cetera. And then, within each of those we have specifics. For example, the keyword subsection is keyword granularity, brand versus non-brand, search query reports, negative, so on so forth.

**中文翻译:**
我认为代理机构通常有一套“剧本”（Playbooks）。我也在代理机构待过，也做过很久咨询，但我从不套用剧本。我把每个账户、每家公司都当作独立的个体。但很多代理机构进来后会想：“哦，这公司跟 ABC 公司差不多，直接复制粘贴就行了。”而且他们不愿深入细节。我可能比别人更钻研数据。比如，我和团队有一套“运营节奏”（Ops Cadence），涵盖财务、表现、结构、关键词、广告文案、质量得分、定向等等。每个环节都有细项，比如关键词部分包括粒度、品牌词 vs 非品牌词、搜索查询报告、否定词等等。

---

### [00:35:06] Timothy Davis

**English:**
I feel like agencies don't necessarily get into all of those things every single month where some of those we're doing weekly, some of those we're doing biweekly, and some of those we're doing monthly. But they touch the things that they think they need to touch. They turn on automated bidding, they're doing their search query reports, and then they just kind of move on with their day because they have 50 other clients they have to get to. Well, what about looking at your conversions? Where are we converting? Have we tested different landing pages? What is a better user experience that we could be getting users right now? It's a five-step process, can we get it to a three? Partnering with PMMs to say, "Hey, here's something that I think could help improve our lead to conversion." Just stuff like that, that they're too busy with too many other things to focus really, really deep into those.

**中文翻译:**
我觉得代理机构不会每个月都深入这些细节，而我们有些是每周做，有些是每两周做。他们只碰那些不得不碰的东西：开启自动竞价，跑跑搜索报告，然后就忙别的去了，因为他们还有 50 个客户要应付。但转化情况呢？我们在哪里转化的？测试过不同的落地页吗？现在的用户体验能优化吗？五步流程能不能缩减到三步？与产品市场经理（PMM）合作改进转化率。他们太忙了，没时间深入研究这些。

---

### [00:36:03] Timothy Davis

**English:**
And typically, whenever I managed an agency in the past and I consulted, I made sure that you weren't stretched thin enough that you couldn't do those things. Because I'm a firm believer in hiring smart people and then getting out of their way. But each week having one-on-ones with them, just spot checking things, just saying, "Hey, I looked at this. This doesn't look right. What's going on there?" "Oh yeah, I do that on this day." "Okay, great. Just making sure you're covered." Because sometimes people won't scream uncle when they should be screaming uncle because they think it's a sign of weakness.

**中文翻译:**
过去我管理代理机构或做咨询时，我会确保团队不会因为太忙而顾不上这些。我坚信要雇佣聪明人，然后放手让他们干。但每周我会和他们 1 对 1，抽查一些细节：“嘿，我看这个数据不太对，怎么回事？”“哦，我打算那天处理。”“好，确保你跟进了就行。”因为有时候人们即便忙不过来也不愿求助（Scream uncle），觉得那是软弱的表现。

---

### [00:37:08] Lenny Rachitsky

**English:**
So it sounds like basically they just don't have the time to care and spend on all the things that they need to be doing. And when you've held companies, you actually go deep and you have the time to do it well. I guess, when someone's trying to find an agency or someone like you, I know you don't do this much anymore. Any advice for just how to know if they're going to be great? Is it just agencies in general probably not a good choice? Is it hire someone in-house? I guess, what advice do you offer people that are like, "Oh man, I want to avoid this."

**中文翻译:**
所以听起来，他们只是没时间去关注和投入所有该做的事。而你接手时，你会深入钻研并花时间做好。如果有人想找代理机构或像你这样的人，你有什么建议来判断他们是否优秀？是说代理机构通常不是好选择吗？还是应该招内部员工？

---

### [00:37:43] Timothy Davis

**English:**
Agencies are a good place to get things started. Even when I was consulting, I would, honestly, I'm a big believer in forward thinking, backwards planning. So, if I'm taking this contract on with this new client, what's the end goal for you? If your end goal is to have this at performing in $100 million spend, there's no way one person can do that. So let's create milestones along the way of making sure we're checking in and saying, when is the right time to hire? Whether that's a data scientist, whether that's a creative person in-house or replacing me full time. There's no reason that you should be holding a company back. If anything, you should be helping them get to that milestone.

**中文翻译:**
代理机构是起步的好地方。即便我做咨询时，我也信奉“前瞻思考，倒推计划”。如果我接了一个新客户，我会问：你的终极目标是什么？如果你的目标是每年花 1 亿美元且有效果，那一个人肯定干不来。所以我们要设定里程碑：什么时候该招数据科学家？什么时候该招内部素材人员？或者什么时候该招全职人员来替换我？你没理由拖公司的后腿，相反，你应该帮他们达到那个里程碑。

---

### [00:38:47] Timothy Davis

**English:**
I would say, agency consultant is a good way to start. Because if you as a business owner, you shouldn't have to log into, "Oh, I haven't logged into Google in three weeks to look at stuff because I'm doing payroll, I'm doing HR stuff, and I'm meeting with clients, and I'm doing sales." Start there, get it to a good place. Create that milestone of, "Hey, when we're spending 50K a month, I need to hire somebody full time to take this over." And just have that conversation with your agency and your consultant. I think more times than not, you will have a positive reaction to that. But if you don't, I would say that's a major red flag and probably someone you shouldn't be partnering with.

**中文翻译:**
代理机构或顾问是很好的起点。作为老板，你不应该因为忙着发工资、搞 HR、见客户和跑销售，就三周没登录 Google 广告后台。先找外援把事情带上正轨，然后设定目标：“当我们每月花 5 万美元时，我就得招个全职的人来接手。”直接和你的代理机构或顾问谈这个。大多数时候，他们会有积极的反应。如果他们不乐意，那就是个巨大的警示信号（Red flag），说明他们不值得长期合作。

---

### [00:39:52] Lenny Rachitsky

**English:**
I want to talk about the team that you build over time, but later. But specifically, for this first person that you hire, what sort of person is this person? Is it like a data person? Is it a person that's just done specific performance marketing on channel? Or what do you look for ideally?

**中文翻译:**
我们稍后再聊团队构建。但具体到“第一个员工”，应该招什么样的人？是数据型人才？还是在某个渠道有经验的绩效营销人员？你理想中的人选是什么样的？

---

### [00:40:55] Timothy Davis

**English:**
I'm a big believer in... There was a book written by Nate Silver called The Signal and the Noise. Are you familiar with it? So, Nate Silver is the guy who created FiveThirtyEight. And in the book, he basically... I'm going to use the word art, detailed the art of probability statistics and applied him to real world circumstances. I liked that book. It's kind of dense. But the thing I liked the most about it was the title. And just changing the title ever so slightly to signal not noise. So typically, whenever I hire people, I want to hire smart people and kind of get out of their way. But the biggest thing I want to focus on is what is your thought process when it comes to data?

**中文翻译:**
我很推崇 Nate Silver 的那本书《信号与噪声》（The Signal and the Noise）。他是 FiveThirtyEight 的创始人。他在书中详细阐述了概率统计的艺术，并将其应用于现实世界。那本书有点深奥，但我最喜欢它的标题。我把它稍微改了一下：要“信号”不要“噪声”。我招人时，想招聪明人并给他们空间。但我最看重的是：你处理数据的思维过程是怎样的？

---

### [00:42:05] Timothy Davis

**English:**
Because I can teach anyone how to do Google ads. I can teach anyone how to do Meta ads. That is not the hard part. It is the data part that is the hard part because there is so much noise going on in those accounts. They give you everything, which is great. But you can have someone that's "Oh, but look at the reach, look at the frequency, look at the CPMs, look at the CPC, look at the conversion rate. Look at the cost per lead. Look at the cost per MQL. Look at this." Hold on, that's a lot of noise you just said. So what is the signal and what is the noise? And let's make sure we're focusing on the right signal versus the right noise. And that has to be a data person because there's a lot of data in these platforms.

**中文翻译:**
因为我可以教任何人怎么操作 Google 广告或 Meta 广告，那不难。难的是数据部分，因为账户里有太多“噪声”。平台会给你所有数据，这很好，但有人会说：“看这触达，看这频次，看这 CPM、CPC、转化率、CPL、MQL 成本……”等等，你说的全是噪声。什么是信号？什么是噪声？我们要确保关注的是正确的信号。所以第一个人必须是懂数据的人，因为平台里的数据实在太多了。

---

### [00:42:51] Lenny Rachitsky
*(Note: Sponsor ad for Eppo omitted but translated below)*

**中文翻译:**
本集由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 校友为现代增长团队打造的下一代 A/B 测试平台。Twitch、Miro 等公司都在使用它。Eppo 能帮你加快实验速度，并提供严谨的深度分析。

---

### [00:44:10] Lenny Rachitsky

**English:**
Everyone I talked to that's worked with you is just like, "Timothy is incredible at working with tons of data and finding the things that matter." Someone told me that it actually comes from your love of baseball, that you just go crazy with stats and spreadsheets of baseball games, and players, and things like that. Is there something there that you could share that is interesting?

**中文翻译:**
每个和你合作过的人都说：“Timothy 处理海量数据并找到关键点的能力简直不可思议。”有人告诉我，这其实源于你对棒球的热爱，你会为了棒球比赛、球员数据和表格而疯狂。有什么有趣的故事可以分享吗？

---

### [00:44:28] Timothy Davis

**English:**
Yeah. So I played baseball my whole life, but when you blow out your arm and you're as fast as a sea otter, it's not very conducive for you to continue chasing that dream. But the one thing I always liked was the stats. Even as a kid when I would watch baseball games on TV, it's like, what's this guy batting? How often is he getting on base? How many RBIs? Like, "Oh, this guy is terrible average, but he has a lot of RBIs, so that means if there's a runner on base, he may not get a hit, but he's going to get that guy in." I could talk about that for hours. But again, that could be another thing where there's a lot of data available, which one should you focus on?

**中文翻译:**
是的。我打了一辈子棒球，但当你手臂受伤，而且跑得像海獭一样慢时，就很难继续追梦了。但我一直喜欢数据。小时候看电视转播，我会关注：这家伙打击率多少？上垒率多少？打点（RBI）多少？比如：“这家伙打击率很烂，但打点很高，这意味着只要垒上有人的时候，他虽然不一定能击出安打，但能把队友送回来。”我可以聊这个聊上好几个小时。但这又回到了那个问题：面对海量数据，你应该关注哪一个？

---

### [00:45:16] Timothy Davis

**English:**
And ultimately, what is the optimization you're going to make to the lineup or to where you place fielders on the field to ensure that we're doing the right thing and becoming as efficient and effective as possible? As far as dealing with all that data, that is just, I would say, a skill I've learned over time. Early in my career, whenever someone was like, "Oh, we have this new project. Who wants to work on it?" "I'll do it." I was always just eager like a sponge. I wanted to get in as much stuff as possible. I did SEO for a portion of my career. I did email marketing. I did affiliates. And then, eventually, I remember the first time I saw paid, because again, I was doing SEO where I was like, "Yeah, we're going to do this and we think it's going to work." But we won't know for about six months.

**中文翻译:**
最终，你该如何优化阵容或防守位置，以确保效率最大化？处理数据是我多年积累的技能。职业生涯早期，只要有新项目，我总是像海绵一样吸收一切。我做过 SEO、邮件营销、联盟营销。后来我第一次接触付费广告，当时我还在做 SEO，心想：“我们要这么做，觉得会有效，但得等六个月才知道结果。”

---

### [00:46:12] Timothy Davis

**English:**
Someone showed me the paid platform. I was like, "Wait, you know this is the keyword you're bidding on. This is how many times the ad was shown, how many people clicked on it? How many... Wow, this is amazing. I need to get more into this." And that's just kind of where it started. And when I usually hire people and we go through the interview process, I make sure that they can be data focused. Really, it's just ensuring that we're focusing on that signal and not the noise. And one of the interview questions I usually ask is I throw a bunch of data points at them and then say, "Out of all that, what would you do to optimize the account?" And more times than not that they're just overwhelmed. But the people that I like are like, " Well, what's the purpose of the campaign?"

**中文翻译:**
结果有人给我看了付费广告后台，我惊呆了：“等等，你知道竞标的是哪个词，知道展示了多少次，多少人点了，多少人……哇，这太神奇了，我要深入研究这个。”这就是一切的开始。现在我招人面试时，会确保他们是数据导向的。我会扔给他们一堆数据点，问：“基于这些，你会如何优化账户？”大多数人会不知所措。但我喜欢的人会问：“这个营销活动的目标是什么？”

---

### [00:47:02] Timothy Davis

**English:**
"The purpose of the campaign is to drive conversions." "Okay, well, I would focus here, focus on how many clicks we're getting, and how many conversions, are we targeting the right people?" Because who cares about how many impressions you're getting? Who cares about the reach? Who cares about the frequency? If the goal of the campaign is to get the conversions, that's what we should be doing. If it was awareness, it's how many people saw it. If it was a consideration, how many people were getting into the funnel and are considering us from a white paper download or a demo as the product solution that they're looking for.

**中文翻译:**
“目标是驱动转化。”“好，那我会关注点击量、转化量，以及我们是否找对了人。”因为如果目标是转化，谁在乎展示量、触达率或频次？如果是为了知名度，那就看多少人看到了；如果是为了考虑度（Consideration），那就看多少人进入了漏斗，比如下载了白皮书或预约了演示。

---

### [00:47:34] Lenny Rachitsky

**English:**
That's a great segue to the next question I wanted to ask you, which is just metrics that you love to focus on, pay attention to when you're helping people with paid ads. A lot of people think about CAC, a lot of people think about return on ad spend, LTV to CAC. I know it really depends on the goals as you said, but I guess, is there anything that you find is like, forget these metrics, these are kind of the bucket that you focus on most?

**中文翻译:**
这正好引出了我想问的下一个问题：你最关注的指标是什么？很多人看获客成本（CAC）、广告支出回报率（ROAS）、LTV/CAC。我知道这取决于目标，但有没有哪些指标是你觉得可以忽略的，而哪些是你最看重的？

---

### [00:48:01] Timothy Davis

**English:**
Yeah, so for those metrics, I would say, I really hope you have a great finance partner. Shout out to Courtney and Nick the fantastic finance partners I have at Shopify. Courtney, we're able to collaborate on those things. Understand, this is the investment we're putting in, this is the expected return, this is the CAC that we can basically put a guardrail on. You have to be within. So, hopefully you have a really strong financial partner you can use for those. But as far as the stuff that I focus on, there are things that whenever we're looking at accounts, we'll kind of hyperfocus on. For example, Google will give you information about what is going on with your ad copy and how to ultimately show as often as possible.

**中文翻译:**
关于这些指标，我希望你有一个优秀的财务伙伴。感谢我在 Shopify 的财务伙伴 Courtney 和 Nick。我们可以协作：投入多少，预期回报多少，CAC 的红线在哪里。至于我个人关注的，我们会超常规关注一些细节。比如，Google 会提供关于广告文案的信息，告诉你如何尽可能频繁地展示。

---

### [00:49:08] Timothy Davis

**English:**
What I'm showing here is a visual of brand versus non-brand when it comes to expected click-through rate, landing page experience, and ad relevance. The reason I like building reports like this is because it'll kind of show you where your hole in the ship is. If you look on the left side expected click-through rate, 75% above average. Landing page experience, 84% above average. Then you get down to ad relevance, a lot more colors than there are green, only 35% above average. So, for your brand ad copy, the clear direction you have from the data that's available to you is jump into the account and make it more relevant. That will improve your ad strength. And once you improve your ad strength, that will improve your quality score.

**中文翻译:**
我现在展示的是品牌词 vs 非品牌词在预期点击率、落地页体验和广告相关性方面的可视化图表。我喜欢做这种报告，因为它能告诉你“船上的洞在哪里”。如果你看左边，预期点击率 75% 高于平均水平，落地页体验 84% 高于平均。但看到广告相关性时，绿色很少，只有 35% 高于平均。所以，对于品牌词广告，明确的方向就是：进入账户，提高相关性。这会提升广告效力（Ad Strength），进而提升质量得分（Quality Score）。

---

### [00:50:13] Timothy Davis

**English:**
And more times than, I think, it's a 12% increase in the number of impressions you can get if you increase from a below average to an above average for the data that's available here. And then, on the non-brand side, clear expected click-through rate, you really need to be working on. And that data is also available here that you can kind of see. I put in red the one for brand, your quality score being at a nine, but your average CPC is $8. That is very interesting. It should be, the higher your CPC is, the lower your CPC should be. So that is an investigation that's like, "Hey, here's a signal, let's go do a deep dive."

**中文翻译:**
如果你能从低于平均提升到高于平均，展示量通常能增加 12%。在非品牌词方面，显然你需要优化预期点击率。我用红色标出了品牌词的部分：质量得分是 9，但平均 CPC 竟然要 8 美元。这很有趣，通常质量得分越高，CPC 应该越低才对。这就是一个信号，提示我们要去做深度调查。

---

### [00:51:19] Timothy Davis

**English:**
So just turning that ad off by itself, not only will... I'm a firm believer in that there's an account level quality score, not just necessarily a keyword or an ad quality score. So, just turning this one off and removing it from the account, this one ad could dramatically improve your performance. And then, Google actually tells you what you need to do to increase those strength things. So this report is ultimately powered by this one. So for your ad strength improvements, they'll tell you, "Try adding a few more unique headlines or unpinning some of the ad sets. Try including more keywords in your descriptions or your headlines."

**中文翻译:**
仅仅关掉这一个广告，不仅会……我坚信存在“账户级”的质量得分，而不只是关键词或广告级的。所以，关掉这个表现差的广告，可能会大幅提升整体表现。Google 实际上会告诉你怎么做：增加一些独特的标题，或者在描述中加入更多关键词。

---

### [00:52:24] Lenny Rachitsky

**English:**
That was amazing. For folks not watching on YouTube, you pulled up actual reports from, I think, imagine, past clients, is that what the data was from?

**中文翻译:**
太棒了。对于没看 YouTube 的听众，你刚才展示的是过去客户的真实报告数据，对吧？

---

### [00:52:32] Timothy Davis

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:52:38] Lenny Rachitsky

**English:**
Google Ads data. Incredible. Okay. And so within those reports, you had poor, excellent. How do you determine when something is going great? Is that something you set, like if it's above this threshold? Is that a benchmark you have, or is that Google telling you, "This is poor, or this..."

**中文翻译:**
Google Ads 数据，太棒了。在这些报告里有“差”和“优”。你怎么判断什么时候表现算好？是你设定的阈值，还是 Google 告诉你的？

---

### [00:52:54] Timothy Davis

**English:**
Yeah, so that's Google telling you. There's sometimes where you'll work really, really hard to take that poor to an average, that average to an excellent, and there's just not a whole lot you can do sometimes. It kind of is what it is. But I would argue more times than not, people are not doing those things to improve their ad strength. So just if you have the change history available in every account, in Meta, in Google, if people are doing the test to try and improve and get better, great. You have the right people working. But if not, that's a clear indication that there's definitely room for improvement.

**中文翻译:**
那是 Google 告诉你的。有时候你拼命想把“差”变成“中”，把“中”变成“优”，但有时就是无能为力。但我认为，大多数时候人们根本没去尝试提升广告效力。如果你查看账户的操作历史，发现有人在不断测试和改进，那说明你找对人了。如果没有，那就说明绝对有提升空间。

---

### [00:53:40] Lenny Rachitsky

**English:**
Something that someone asked on Twitter is for benchmarks around any of the stuff. How do you know when your CPC is good? I guess you just look at... Do you look at Google telling you it's excellent versus poor? How do you know if your conversion rate is good? How do you know if your CAC is good?

**中文翻译:**
Twitter 上有人问关于基准值（Benchmarks）的问题。你怎么知道你的 CPC 算不算好？是看 Google 说的“优”或“差”吗？你怎么知道转化率或 CAC 算不算好？

---

### [00:53:54] Timothy Davis

**English:**
Yeah, every industry and every company is going to be different, healthcare, lawyers, those are some of the highest cost and average CPCs I've seen. If I was to compare that industry, say to a B2B industry, it would not be very good at all. Honestly, what I would tell the user to do, every single platform has partners available, more times than not, they're kind of like salespeople. I actually really like the partners that we have at Shopify, because I do feel that they are partners. Shout out to Francisco at Google, and Sami and Alana at Meta. And Nick, and Sam, and Brian at LinkedIn.

**中文翻译:**
每个行业和公司都不同。医疗、法律行业的 CPC 是我见过最高的。如果拿这些行业去跟 B2B 比，数据会很难看。老实说，我会建议用户去找平台的合作伙伴（客户经理）。虽然他们有时像销售，但我很喜欢 Shopify 的那些伙伴，比如 Google 的 Francisco，Meta 的 Sami 和 Alana，LinkedIn 的 Nick、Sam 和 Brian。

---

### [00:54:44] Timothy Davis

**English:**
They will actually say, "If you give me the five people you consider to be your top competitors, I will tell you if you are above or below a certain threshold." Now they can't tell you CAC because they would have to have transparency into conversions. But click-through rate, conversion rate, cost per click, things like that, they will give you that information because they will anonymize it, so you won't know who is who. If you say, "My competitor's monday.com," they won't say, "monday.com has a click-through rate of 5%." They won't tell you that. But they will tell you, "Of the competitors you gave us, you are on par with the industry."

**中文翻译:**
他们会说：“如果你给我五个你认为最主要的竞争对手，我会告诉你你的数据是在门槛之上还是之下。”他们不能告诉你 CAC，因为他们看不到转化数据。但点击率、转化率、CPC 等，他们可以提供脱敏后的匿名数据。他们不会直接说 monday.com 的点击率是 5%，但会告诉你：“在你提供的这些竞争对手中，你的表现处于行业平均水平。”

---

### [00:56:02] Lenny Rachitsky

**English:**
Got it. So the advice is, don't seek generic benchmarks for any of these metrics. You can talk to your rep at Google, Facebook, LinkedIn, et cetera. And they'll give you essentially the numbers-

**中文翻译:**
明白了。所以建议是：不要寻找通用的基准值。去跟 Google、Facebook、LinkedIn 的客户经理聊，他们会给你更有参考价值的数字。

---

### [00:56:13] Timothy Davis

**English:**
Great summary. Yes, yes.

**中文翻译:**
总结得很好，没错。

---

### [00:56:14] Lenny Rachitsky

**English:**
Amazing. Okay, going back to the report you just showed, is that a report you developed custom that gives you, here's the most important stuff to pay attention to? Or is it basically an export from Google Ad Manager, and...

**中文翻译:**
太棒了。回到你刚才展示的报告，那是你自定义开发的吗？还是直接从 Google Ad Manager 导出的？

---

### [00:56:26] Timothy Davis

**English:**
So these are all exports, so that this is just the visualization of the data that's available. This all data is available in every account. Now in saying that, there are more reports that we get into, like impression sharing frequency. This is something I tend to look at, that not a lot of other people do. It's not about showing as often as possible because that's what impression share tells you, and that's kind of like ego marketing. I want to be number one, I want to be there all the time. It's about showing to the right person as often as possible.

**中文翻译:**
这些都是导出的数据，只是做了可视化。所有数据在每个账户里都能找到。除此之外，我们还会看展示份额（Impression Share）和频次。这是我关注但很多人忽略的一点。重点不在于“尽可能频繁地展示”（那是展示份额告诉你的，也是自尊心营销），而在于“尽可能频繁地向正确的人展示”。

---

### [00:57:06] Timothy Davis

**English:**
Instead of thinking about being on top of the page, you should think about serving the right user, which can be measured with our click share. And then Google will put us on top of the page, which we can see through our top impression share. That's what this whole visualization is here for, where I feel like a lot of people don't do this type of visualization. And this can be done by leveraging all the user data available on Google, such as demographics, locations, if any audiences, in-market audiences. Testing different bid strategies and more.

**中文翻译:**
与其想着排在页面顶端，不如想着服务正确的用户，这可以通过“点击份额”（Click Share）来衡量。只要用户找对了，Google 自然会把我们排在顶端。这就是这套可视化的目的。你可以利用 Google 提供的所有用户数据：人口统计、地理位置、兴趣受众、意向受众，并测试不同的竞价策略。

---

### [00:57:40] Timothy Davis

**English:**
So the data's readily available, but it's just making the visualization a little bit more digestible. And the reason that I actually have two here to show is because this is an example of when I was working on an account back in 2023, where we started making some changes. And you can see that, clearly, our impression share, I would say was baseline. It didn't really change too much, but look at our click share going up. Because now again, we're talking more to the right people, not necessarily just everyone, generic people.

**中文翻译:**
数据是现成的，只是让可视化更易懂。我这里展示两个例子：这是 2023 年的一个账户，我们做了一些调整。你可以看到，展示份额基本没变，但点击份额明显上升了。因为我们现在更多是在跟“正确的人”对话，而不是泛泛而谈。

---

### [00:58:41] Lenny Rachitsky

**English:**
This is super cool. I love that you're showing this. And again, plug for YouTube to actually see the charts you're talking about. I see one more slide on this deck. I'm curious, what's there?

**中文翻译:**
太酷了，我很喜欢这些展示。再次提醒大家去 YouTube 看图表。我看到 PPT 里还有一张幻灯片，那是什么？

---

### [00:58:49] Timothy Davis

**English:**
Yeah, so this one, I'm hoping you have show notes that we can give a shout-out to somebody. There's a website called PPC Hero. What I usually tell people is, "Terrible name, great content." The actual website used to be a little bit more cartoonish with superheroes on it, but now it's, they've refined it. But the writer there, his name's Jacob Brown. This is what he calls the true competition metric.

**中文翻译:**
是的，我希望你在节目介绍里能提到这个。有一个网站叫 PPC Hero。我常说：“名字很烂，内容很赞。”那个网站以前有很多超级英雄漫画，现在改版了。那里的作者 Jacob Brown 提出了一个概念，叫“真实竞争指标”（True Competition Metric）。

---

### [00:59:56] Timothy Davis

**English:**
And again, this is why I highly recommend we give people the link to the article because this does get a little dense. So what he does is that he creates four new metrics with the Auction Insights that are available. And two of those metrics are position above rate when we show, and amount of times they show and we don't. Added together, and it will show how often a competitor ranks above you in all auctions you're available for. Using this type of lens is an effective way to identify genuine threats.

**中文翻译:**
我强烈建议大家看那篇文章，因为内容有点硬核。他利用现有的“竞价分析”（Auction Insights）创建了四个新指标。其中两个是：当我们展示时对方排在我们上面的比例，以及对方展示而我们没展示的次数。加在一起，就能显示在所有你有资格参与的竞价中，竞争对手排在你上面的频率。这才是识别真正威胁的有效方法。

---

### [01:00:25] Timothy Davis

**English:**
Not that just, this data can be used to gain comprehensive insights like determining your position and impression share, but by creating a baseline that you can see how this data changes over time through different bid strategies, keyword ad copy optimizations and more. This is a very, very powerful one, because I do know a lot of people are always concerned about, "What are my competitors doing? How are they doing it? Why are they doing it?" And with all the smart bidding currently available...

**中文翻译:**
这不仅能帮你确定位置和展示份额，还能建立一个基准，观察数据如何随竞价策略、关键词优化等而变化。这非常强大，因为我知道很多人整天担心：“竞争对手在干嘛？他们怎么做的？为什么要这么做？”在现在的智能竞价环境下……

---

### [01:01:09] Timothy Davis

**English:**
Using this report will actually identify a true threat, as opposed to making an assumption based on personalization that maybe you're seeing when you Google a keyword, or using a tool like Semrush that ultimately is saying, "Oh, this person's appearing above you. Well, let's run this report and see if it's a genuine threat," as opposed to just maybe ego marketing going on.

**中文翻译:**
使用这份报告能识别真正的威胁，而不是基于你自己在 Google 搜关键词时看到的个性化结果，或者用 Semrush 之类的工具看到的表面现象。与其纠结“那个人排在我上面”，不如跑一下这份报告，看看是不是真的构成了威胁，还是只是你的自尊心在作祟。

---

### [01:01:09] Lenny Rachitsky

**English:**
Super cool. And this comes from PPC Hero, is this what you're saying?

**中文翻译:**
太酷了。这是来自 PPC Hero，对吧？

---

### [01:01:13] Timothy Davis

**English:**
Yep.

**中文翻译:**
是的。

---

### [01:01:13] Lenny Rachitsky

**English:**
Cool. We'll definitely link to that. Are there any other tools or workflows that you find really helpful in analyzing this endless amount of data?

**中文翻译:**
好，我们一定会把链接放上去。在分析这些无穷无尽的数据时，还有其他你觉得非常有用的工具或工作流吗？

---

### [01:01:24] Timothy Davis

**English:**
Please, audience, if you are using AI in this way, let me know because a lot of this stuff I do can be a little manual and can be a little time-consuming. If they've found ways to automate through AI where I can provide the information that isn't sensitive, that they will make it a lot cleaner, and a lot more digestible, let me know. But a lot of the things, I have templates that you can load the data into, and it will just automatically give you the result from it. But yeah, right now, it is a little manual, but if there's a way to automate this through AI, please, users, contact me on LinkedIn and let me know.

**中文翻译:**
各位听众，如果你正在用 AI 做这些事，请告诉我。因为我做的很多工作还是比较手动的，很耗时。如果有人找到了用 AI 自动处理非敏感信息的方法，让数据更整洁、更易懂，请务必告诉我。目前我有很多模板，把数据导进去就能出结果，但过程还是有点繁琐。如果有 AI 自动化的方案，请在 LinkedIn 上联系我。

---

### [01:02:09] Lenny Rachitsky

**English:**
Sounds like a startup opportunity right there.

**中文翻译:**
听起来这本身就是一个创业机会。

---

### [01:02:11] Timothy Davis

**English:**
Yeah.

**中文翻译:**
没错。

---

### [01:02:12] Lenny Rachitsky

**English:**
Sweet. Okay, let's move in a slightly different direction. Attribution, what a sexy, exciting topic. So attribution, basically it's how do you assign credit to a channel and to a campaign, so that you know where growth is coming from, what's working? What's the state of attribution today? What do you find is helpful? How do people do attribution well in today's world?

**中文翻译:**
好，换个话题。归因（Attribution），一个既性感又令人兴奋的话题。归因本质上是如何将功劳分配给某个渠道或活动，从而知道增长来自哪里。现在的归因现状如何？你觉得什么方法有效？大家该如何做好归因？

---

### [01:02:35] Timothy Davis

**English:**
Yeah, I'm a big believer and proponent in multi-touch. I fall into the camp of more time decay. Historically, the research I've done, users tend to forget very quickly where they first found your brand. Yes, you should get credit because this is the first time they saw your brand or the first time they interacted with it, for sure, let's give you some credit for that. But definitely not the reason that they ultimately converted. Linear is fine as well, but overall, I do think attribution by itself is biased. It does not answer the question of whether the person clicking on or seeing an ad would've converted anyways, even in the absence of that ad.

**中文翻译:**
我是多触点归因（Multi-touch）的坚定支持者。我倾向于“时间衰减”（Time Decay）模型。根据我的研究，用户很快就会忘记他们最初是在哪里发现你的品牌的。当然，第一触点应该分到功劳，但它绝对不是最终导致转化的唯一原因。线性归因也可以，但总的来说，我认为归因本身是有偏差的。它无法回答一个核心问题：如果没看到这个广告，这个用户是不是本来也会转化？

---

### [01:03:24] Timothy Davis

**English:**
This is why numerous companies like Netflix and eBay have done studies to get an understanding of the incrementality of paid advertising campaigns, whether that's conducting GeoX or Conversion Lift tests at important slices of the marketing channel. I know eBay was very popular when they did that experiment. I think it was like 2012. Where they ultimately decided to cut almost all of their brand spend, because they found that users were already going to find them through organic anyway, so they were just kind of throwing money out the window.

**中文翻译:**
这就是为什么 Netflix 和 eBay 等公司会做“增量性”（Incrementality）研究，比如进行地理实验（GeoX）或转化提升（Conversion Lift）测试。eBay 在 2012 年做的那个实验非常出名，他们最终决定削减几乎所有的品牌词广告支出，因为他们发现用户无论如何都会通过自然搜索找到他们，投广告纯粹是浪费钱。

---

### [01:04:07] Lenny Rachitsky

**English:**
Okay, so multi-touch is the way you like to think about it. Basically give credits to all of the channels that you detected the user saw your ad on, and less credit if it was further back in time.

**中文翻译:**
明白，所以你喜欢多触点归因。给所有触达过用户的渠道分配功劳，时间越久远的分配得越少。

---

### [01:04:19] Timothy Davis

**English:**
Right, yep.

**中文翻译:**
对，没错。

---

### [01:04:20] Lenny Rachitsky

**English:**
And in terms of tooling, is there tools you love? Is it stuff you build in-house generally? How do people go about doing this sort of stuff?

**中文翻译:**
关于工具，你有推荐的吗？通常是内部自研吗？大家一般怎么操作？

---

### [01:04:28] Timothy Davis

**English:**
Yeah, I don't know if I want to say I have been fortunate or not, but most of the companies I've worked with, like the big companies of the world, the Pinterests, the Shopifys, the IBMs of the world tend to build things in-house. So from a third-party tool, unfortunately, I don't have a whole lot of go-tos for that. So again, either that's a, I've been fortunate or I've been sheltered.

**中文翻译:**
我不知道该说幸运还是不幸，我待过的大公司——Pinterest、Shopify、IBM——通常都是自研工具。所以关于第三方工具，我没有太多推荐。可能是我一直待在温室里吧。

---

### [01:05:00] Timothy Davis

**English:**
Yeah, none that I've seen that's like, "Oh wow, that's amazing." I will always say, make sure you're trying to leverage the in-platform tools because the biggest thing with performance marketing is the signal you're sending the platform. Because if you are telling the platform, "Oh, I want to get more of the users that are doing this action," it's going to do a really good job of giving you that. But if that action doesn't equal business results, you're not helping yourself at the end of the day. You're giving it, again, a lot of noise instead of the right signal. So try and leverage the in-platform tools. Or if there is a tool you're using, make sure it does allow third-party integration through the Google, Meta, TikToks of the world.

**中文翻译:**
我还没见过哪个第三方工具让我觉得“哇，太神奇了”。我总是建议尽量利用平台自带的工具，因为绩效营销的关键在于你传给平台的“信号”。如果你告诉平台：“我要更多做这个动作的用户”，平台会帮你找到。但如果那个动作不等于业务结果，你就是在帮倒忙。你传给平台的是噪声而不是信号。所以，尽量利用平台原生工具，或者确保你的第三方工具能与 Google、Meta、TikTok 深度集成。

---

### [01:05:51] Lenny Rachitsky

**English:**
Then let's talk about incrementality. You mentioned this idea of how do you know if the money you spent led to incremental growth that wouldn't have happened if you didn't run that ad. Is there any advice there, anything you've seen about just how to think about incrementality correctly, and not just give yourself all this credit for stuff that would've happened anyway?

**中文翻译:**
那聊聊增量性（Incrementality）。你提到如何知道花的钱是否带来了“如果不投广告就不会发生”的增长。关于如何正确思考增量性，而不是把本来就会发生的增长归功于自己，你有什么建议吗？

---

### [01:06:09] Timothy Davis

**English:**
Yeah, I mean, there are many ways to judge the effectiveness of growth overall. Like some of the stuff we talked about before, brand metrics, awareness, recall, things along those lines. There are also, I know some companies look at leading indicators like visits, and clicks, or tribute, which of the efforts are linked to or perceived drivers of actions. Like leads, conversions to prospect, prospect to scale. But really the results should be coming from either that GeoX or Geo experiment or Conversion Lift. The results of those experiments should ultimately fuel the plans for what we call IAF, incrementality adjusted factor, and will allow you to be more precise and how efficient each channel is.

**中文翻译:**
衡量增长有效性的方法有很多。比如我们之前聊的品牌指标、知名度、回想度等。有些公司看领先指标，如访问量、点击量。但真正的结果应该来自地理实验（GeoX）或转化提升（Conversion Lift）测试。这些实验的结果最终会转化为我们所说的 IAF（增量调整系数），让你更精准地了解每个渠道的效率。

---

### [01:07:03] Timothy Davis

**English:**
Ideally, by region, sometimes you just have a holistic of like, "This is how Meta is, this is how YouTube is." But if you don't have it by region, don't fret, it's fine, just have it by platform. And kind of like what does that look in practice? When you're running a Conversion Lift test, you intentionally do not show your ad to some users when you win an auction, and instead Google shows the next bidders' ad. This is your control group, and adds up to some opportunity costs that is estimated in terms of impression share percentage, as well as spend holdback.

**中文翻译:**
理想情况下按地区划分，如果没有，按平台划分也行。实际操作中，当你运行转化提升测试时，你会故意不向某些用户展示广告（即使你赢得了竞价），Google 会展示下一个竞价者的广告。这就是你的对照组。这会产生一些机会成本，体现在展示份额的损失和预算的预留上。

---

### [01:07:42] Timothy Davis

**English:**
And all of the platforms are willing to partner with you on this, because Facebook knows this, LinkedIn knows this. All of them know that they are very visually-based creative assets that are not getting as much credit as they deserve. So if you go to any of them, if say you don't have a dedicated rep you can call, and if you ask for this, more times than not, they are willing to partner with you in saying that, if you're not spending enough, they probably will not help you with this. Because there are certain spend thresholds you do need to meet. But I would say at least start there. And also if you're not spending more than I would say 50K a month in the platform, doing this is going to be a lot more work than you're going to get result from, you're just not going to have enough signal there.

**中文翻译:**
所有平台都愿意在这方面与你合作，因为 Facebook、LinkedIn 都知道，很多视觉素材带来的功劳被低估了。如果你去找他们，即便没有专属客户经理，只要你提出要求，他们通常愿意配合。当然，如果你花钱太少，他们可能不会理你，因为这有最低消费门槛。如果你在某个平台的月消耗不到 5 万美元，做这个可能得不偿失，因为信号不够强。

---

### [01:08:36] Lenny Rachitsky

**English:**
So basically don't worry about running incrementality tests when you're starting out.

**中文翻译:**
所以基本上，刚起步时不用担心增量性测试。

---

### [01:08:39] Timothy Davis

**English:**
Yeah, when you're starting out.

**中文翻译:**
对，刚起步时不用。

---

### [01:08:42] Lenny Rachitsky

**English:**
Got it. Okay. And so basically to understand actual incrementality, every platform has a way for you to actually test it on the platform, and the team there can help you run it.

**中文翻译:**
明白。所以要了解真实的增量性，每个平台都有自己的测试方法，平台团队可以帮你运行。

---

### [01:08:51] Timothy Davis

**English:**
Yep.

**中文翻译:**
没错。

---

### [01:08:52] Lenny Rachitsky

**English:**
Awesome. Okay. Let's go back to talking about team structure and how to build your own performance marketing team. So we talked about the first person that you hire and the advice there was someone that's very, understands how to find signal in noise. So there's that one person, and your advice there was maybe around like 50K. Was that like an actual threshold that you usually recommend, or is that just like an example?

**中文翻译:**
太好了。回到团队结构和如何组建绩效营销团队的话题。我们聊了第一个员工应该是懂“信号与噪声”的人。你建议在月消耗达到 5 万美元左右时招人，这是一个通用的门槛吗？还是只是个例子？

---

### [01:09:14] Timothy Davis

**English:**
Every business is slightly different. I mean, if they're well funded, 50K may not... the threshold may be higher. But yeah, everyone's different. 50K may be, like if somebody said... If you were to just say, "Hey, give me a number," I would say, "50K to start having those conversations." Because if you're at 50K, say for the month of June, great, it's going to take us three months to hire someone anyway, so at least start the conversations now.

**中文翻译:**
每家公司都不同。如果融资充足，门槛可能会更高。但如果你非要我给个数字，我会说 5 万美元。因为如果你 6 月份花到了 5 万，招人还得花三个月，所以现在就该开始考虑了。

---

### [01:09:39] Lenny Rachitsky

**English:**
Awesome. Okay. What do the first three to five hires look like generally, that you recommend for scaling internally from its marketing?

**中文翻译:**
明白。如果要扩大内部绩效营销团队，你推荐的前 3 到 5 个职位分别是什么？

---

### [01:09:48] Timothy Davis

**English:**
So the first thing, like we said, someone data-driven that can get into the platforms. The next is going to be creative. Because I need those two now working hand-in-hand, making sure the creative is matching the tone and also the performance that we're trying to achieve as a business. And then third would be a dedicated data scientist, a fully dedicated person. Because they can help you with things like the incrementality testing. They can help create reports that will ultimately make everyone's lives better. They will be able to build analyses that as a generalist will not be able to do yourself.

**中文翻译:**
第一，如前所述，一个懂数据、能上手操作平台的人。第二，素材人员（Creative）。我需要这两个人紧密配合，确保素材既符合品牌调性，又能达到业务所需的绩效。第三，专职的数据科学家。因为他们能帮你做增量性测试，建立让所有人工作更轻松的报告，并进行通才无法完成的深度分析。

---

### [01:10:54] Lenny Rachitsky

**English:**
And in terms of the creative person, is that like a graphic designer? Is it like a marketing person? What's the actual skill set there?

**中文翻译:**
关于素材人员，是指平面设计师？还是营销人员？具体的技能要求是什么？

---

### [01:11:02] Timothy Davis

**English:**
It would be more graphic design/branding. The reason for that is because if you have a good marketing mix, you're going to have... If we keep it to a three-step funnel of awareness, consideration, purchase, you're going to need to build some brand equity in a specific direction. You're going to need to make sure you're communicating value, which now you're not being as creative, you're being more directional. And then ultimately the purchase is like, "Hey, click here, convert now." So you do want to give them the ability to still be creative.

**中文翻译:**
更倾向于平面设计和品牌建设。因为在一个三步漏斗（知名度、考虑度、购买）中，你需要建立品牌资产，传达价值。在购买阶段，广告语可能是“点击这里，立即转化”，但在之前的阶段，你需要创意。我雇你是为了你的审美和创意，但你也得能执行出能让用户转化的素材。

---

### [01:11:54] Lenny Rachitsky

**English:**
And they're also writing the copy, I imagine for the Google Ads.

**中文翻译:**
我猜他们也要写 Google 广告的文案。

---

### [01:11:59] Timothy Davis

**English:**
I usually say that should be collaborative. The performance marketer should be able to write most of the ads, but I can't tell you how many times in my career where I've written an ad and I'm like, "This is the greatest ad ever written known to man." And it flops because I'm not the target audience. So I think it should be collaborative, and no idea should be left on the cutting room floor.

**中文翻译:**
我通常认为这应该是协作的。绩效营销人员应该能写大部分广告，但我职业生涯中无数次觉得自己写出了“人类历史上最伟大的广告”，结果却惨败，因为我不是目标受众。所以协作很重要，任何想法都不应该被轻易否定。

---

### [01:12:50] Timothy Davis

**English:**
Perfect example. I was working with ADT, the security company. We wrote the most perfect ad when Google Ads only allowed a headline and two descriptions. We got every single value prop in there somehow, it was amazing. And the ad that it was going against was dollar sign, zero setup fee, dollar sign, zero install fee. That ad won. It was like that is... No, how did that... It barely uses any of the characters, and it tells you almost nothing, but it won. Had more conversions, a higher click-through rate. So we took that, and we applied that with the value props, and it did better. So it should never be like, unless the idea is don't buy our product, it shouldn't be left on the cutting room floor. Always test it.

**中文翻译:**
举个完美的例子。我曾为安保公司 ADT 工作。我们写了一个完美的广告，把所有价值主张都塞进去了。而对比的广告只写了：“$0 启动费，$0 安装费”。结果那个简单的广告赢了。它几乎没用什么字符，也没说什么，但转化率和点击率更高。于是我们把这个思路和价值主张结合，效果更好了。所以，除非你的创意是“别买我们的产品”，否则都应该拿去测试。

---

### [01:13:34] Lenny Rachitsky

**English:**
For this first hire, what's the title of this person, usually in your experience?

**中文翻译:**
根据你的经验，这第一个员工的职位头衔通常叫什么？

---

### [01:13:38] Timothy Davis

**English:**
Lately, it's been growth marketing specialist, growth marketing manager, because they're going to wear multiple hats. Like at any startup that you're at, you're going to be asked one day to, "Hey, I want you to do performance ads," and then tomorrow it's like, "Hey, I need you to help me build out this spreadsheet for a spec sheet that you have no idea what you're doing." So you're always going to wear multiple hats, so just having a general title like that to start out with.

**中文翻译:**
最近通常叫“增长营销专员”或“增长营销经理”，因为他们要身兼数职。在初创公司，你今天可能在投广告，明天可能在帮着做你完全不懂的规格表。所以先给一个通用的头衔，等团队壮大了再细分专业。

---

### [01:14:38] Lenny Rachitsky

**English:**
At Shopify, we call it GSD, getting shit done. I'm a firm believer in getting shit done. You should be in the account, like I mentioned earlier with that ops cadence, we have stuff we need to be doing weekly, bi-weekly, monthly. The bigger the company gets, the [inaudible 01:14:55] you wind up in more and more meetings talking about the things you want to do, and how you're going to do it and stuff like that. But keeping those people kind of sheltered away from that and focused on those things, are going to drive the best results for you, you possibly can get.

**中文翻译:**
在 Shopify，我们管这叫 GSD（把事儿办成）。我坚信 GSD。你应该深入账户操作，就像我之前说的运营节奏，每周、每两周、每月都有活儿。公司越大，会议越多，大家都在讨论“想做什么”和“怎么做”。但让这些人远离会议，专注于实操，才能为你带来最好的结果。

---

### [01:15:47] Lenny Rachitsky

**English:**
I love that. In terms of how this team grows, you mentioned when we were chatting, that you wait for someone to cry uncle, to hire more and to add to the team to kind of avoid bloat. Talk about that.

**中文翻译:**
太棒了。关于团队如何壮大，你之前提到你会等到有人“求饶”（Cry uncle）才招新人，以避免组织臃肿。聊聊这个。

---

### [01:16:02] Timothy Davis

**English:**
Unfortunately, we've seen a lot in the news lately with a lot of tech companies letting go of some really talented people, and that is, I feel like just created bloated organizations. We, every month, my current manager, Dean, created this calculator that we look at that says, "How much time are you spending in meetings?" If you have any PTO coming up, put that in there. Optimizations, reporting, stuff like that to basically add up to how many days are in the quarter?

**中文翻译:**
不幸的是，最近新闻里有很多科技公司裁员，我觉得那是之前组织太臃肿了。每个月，我的经理 Dean 会让我们用一个计算器：你花了多少时间开会？有没有休假？优化、报告各花多少时间？最后算出这一个季度你到底有多少天在干活。

---

### [01:16:59] Timothy Davis

**English:**
Oh, we're in the red right now for these two to five people. How many quarters has it been that way? Okay, it's only this quarter. This quarter, we have a summit coming up, or we have a lot of travel because we're meeting with partners, so on and so forth. So maybe this is an isolated thing, let's go ahead and wait till next quarter. All right, next quarter, it's red again. All right, now maybe we need to start having the conversation of, what this new hire will take over, what they will be responsible for, and how much work they'll be taking on and doing, to replace some of this red that is going on.

**中文翻译:**
如果这几个人现在处于“红色”预警状态（超负荷），我们会看持续了几个季度。如果只是这一个季度，因为有峰会或出差，那可以再等等。如果下个季度还是红色，那我们就得讨论招人了：新员工负责什么？能分担多少工作量？从而消除这些“红色”区域。

---

### [01:18:00] Lenny Rachitsky

**English:**
And red means they have more work?

**中文翻译:**
“红色”意味着工作量超标？

---

### [01:18:09] Timothy Davis

**English:**
Yeah. More days than there are in the quarter.

**中文翻译:**
是的，工作天数超过了季度实际天数。

---

### [01:18:12] Lenny Rachitsky

**English:**
And so they basically estimate, "Here's how many days I need to do the things I've committed to for the quarter." And then it's like, "How many actual days do you have this quarter?"

**中文翻译:**
所以他们会估算：“完成本季度承诺的事情需要多少天”，然后对比“本季度实际有多少天”。

---

### [01:18:20] Timothy Davis

**English:**
Yeah.

**中文翻译:**
没错。

---

### [01:18:31] Lenny Rachitsky

**English:**
That is very cool. Is that a Shopify thing or is that something you do at your team?

**中文翻译:**
这太酷了。是 Shopify 的制度，还是你团队自己的做法？

---

### [01:18:36] Timothy Davis

**English:**
I've done stuff like that at other companies before, but kind of bringing it forward again, I don't want to take the credit for it. Dean was the one that brought it back up. It was like, "Oh yeah, I used to do this. I don't know why I stopped doing it."

**中文翻译:**
我以前在别的公司也这么干过，但我不想独占功劳。是 Dean 重新提出来的，我当时想：“对哦，我以前也这么干，怎么后来忘了呢。”

---

### [01:18:52] Lenny Rachitsky

**English:**
That is super cool. You mentioned this opps cadence. Is that something you can describe just what this cadence looks like of how you run?

**中文翻译:**
太酷了。你提到的“运营节奏”（Ops Cadence），能描述一下具体是什么样的吗？

---

### [01:18:59] Timothy Davis

**English:**
Yeah. So I love me a spreadsheet. So it's just a spreadsheet. Let's say column A has those buckets I was talking about a finance, performance structure, keywords, so on and so forth. And then within those buckets ... Or let's call those ... Everyone loves rocks and pebbles right now, right? So that's your big rock. Your big rock is keywords. Then within that you have pebbles. Keyword granularity, brand versus non-brand, search query reports, negatives, so on, so forth. And then within that we say how often we're doing it.

**中文翻译:**
我超爱表格。它就是一个电子表格。A 列是大的类别：财务、表现结构、关键词等等。我们管这些叫“大石头”（Rocks）。大石头下面有“小石子”（Pebbles），比如关键词粒度、搜索报告、否定词。然后我们会标注执行频率：每周、每两周还是每月。

---

### [01:20:19] Timothy Davis

**English:**
And it allows us to ... If anyone in the organization's like, "Hey, how often are you guys updating ad copy?" Easy answer. "How often are you guys doing search query reports?" Easy answer. And it allows us to make sure we hold ourselves accountable to those things. So it's a way to hold yourself accountable, but it's also a way for me as a manager to go in and kind of spot check that and make sure that they're doing the things that need to be done in the account.

**中文翻译:**
这样如果公司里有人问：“你们多久更新一次广告文案？”或者“多久跑一次搜索报告？”，我们能立刻给出答案。这不仅让我们自我负责，也方便我作为经理进行抽查，确保账户里该做的事都做了。

---

### [01:20:46] Lenny Rachitsky

**English:**
In terms of the team, something else folks told me about you is that you're very hardcore about training new people that you hire. What does people mean by that?

**中文翻译:**
关于团队，有人告诉我你对新人的培训非常“硬核”。这是什么意思？

---

### [01:20:56] Timothy Davis

**English:**
Yeah. There's a book called ... I think it's The First 90 Days, and in it actually has a graph that shows when the person starts having impact and how many days it's been. And more times than not, it takes about ... We've all heard it. 90 days for someone to have impact. I want to try and make that 45 days, if not 30. Most of the time it has to do with learning the culture, learning the people understanding, "Yes, you've done paid before at this other job, but this is how we do it here."

**中文翻译:**
有一本书叫《最初的 90 天》，里面有一张图显示员工什么时候开始产生影响力。通常大家都说要 90 天。我想把它缩短到 45 天甚至 30 天。这主要涉及学习文化、熟悉同事，以及明白：“虽然你以前做过付费推广，但在我们这儿，规矩是这样的。”

---

### [01:21:47] Timothy Davis

**English:**
And also giving them responsibility early on for something. For example, Kat on my team was hired 8ish months ago. She was thrown into the fire very quickly. It was like, "Hey, we have this campaign coming up called additions. Here's everything we did last additions. This is the results. These are your responsibilities, these are the expectations. Go. Go forth and conquer."

**中文翻译:**
还要尽早给他们责任。比如我团队的 Kat，8 个月前刚入职就被“扔进了火坑”。我说：“嘿，我们要搞个叫 Additions 的活动，这是上次的数据和结果，这是你的职责和预期。去吧，去征服它。”

---

### [01:22:24] Timothy Davis

**English:**
But what I've noticed is twofold. One, when you're clear in what is expected of them, like, "You are expected to do this when and you already know how to do it. Great." Or also in one-on-ones, I'll just open up the account and say, "Hey, this is how I do it. Let me show you the way I'm doing it and how quick it is for me. And you can learn, even though we're remote, I'm showing you as if you're sitting right over my shoulder."

**中文翻译:**
我发现两点：第一，明确预期非常重要。第二，在 1 对 1 时，我会直接打开账户演示：“看，我是这么操作的，这样很快。”虽然是远程办公，但我演示得就像你坐在我肩膀后面看一样。

---

### [01:23:13] Timothy Davis

**English:**
So making sure that they're efficient and effective with their time, they're focusing on that signal versus that noise and giving them responsibility early on to really take ownership of something. You can see that people are a lot more quicker to pick up things and start getting that flywheel going. Versus, "Oh, hey, go read this handbook week one. Week two, let me introduce you to the team. Week three." It's like slow rolling. "We can speed this up guys."

**中文翻译:**
确保他们高效利用时间，关注信号而非噪声，并尽早让他们产生主人翁意识。你会发现人们上手快得多，飞轮很快就能转起来。而不是第一周看手册，第二周介绍同事，第三周才开始。那太慢了，我们可以快得多。

---

### [01:24:41] Lenny Rachitsky

**English:**
ATT, there was a huge change to the way cookies and attribution and tracking worked online and it felt like paid ads kind of like, "Oh, shit. That's not going to work anymore. It's over. Facebook is dead." Clearly that hasn't happened at this point. Just what is the impact that ATT has had on paid ads and performance marketing?

**中文翻译:**
ATT（苹果的 App 跟踪透明度框架）对线上的 Cookie、归因和追踪产生了巨大影响。当时大家觉得：“完蛋了，付费广告没戏了，Facebook 要死了。”显然现在还没死。ATT 对付费广告和绩效营销到底产生了什么影响？

---

### [01:25:02] Timothy Davis

**English:**
We were just talking about this the other day because we have ... Full transparency, we have people fully dedicated to mobile on the team, and I had reached out to Sasha who's on the team and said, "Hey, what are we doing with ATT? What are we doing scan? All those things? Because has any of our tactics really changed because of say, low opt-in rates?" And the direct answer I got from her was, "As long as we can use SKAdNetwork to provide attribution and measurement for iOS, we're fine."

**中文翻译:**
我们前几天刚聊过这个。我们团队有专门负责移动端的人。我问 Sasha：“关于 ATT 和 SKAN（苹果的归因框架），我们的策略因为用户授权率低而改变了吗？”她给我的直接回答是：“只要我们能利用 SKAdNetwork 为 iOS 提供归因和衡量，我们就没问题。”

---

### [01:26:10] Lenny Rachitsky

**English:**
Creatives, how impactful are creative in the performance of ads generally? Is that like, "Holy shit. People are way under estimating the power of a creative." Or is it like, "Okay, it's like a fringe impact?"

**中文翻译:**
素材（Creatives）对广告表现的影响有多大？是“天呐，大家严重低估了素材的力量”，还是说它只是边缘影响？

---

### [01:26:10] Timothy Davis

**English:**
Way underestimating the power of creative. The best example I can give ... Do you remember Dollar Shave Club? All right. There you go. You remember it. That was creative. Now the person buying it may have done a really good job of just targeting males, but I would argue girlfriends at the time probably would've been aware of it as well. Really good creative should be doing a really good job of telling a story. And if it does that ... Again, going back to what we talked about at the very beginning, if you get that emotion with users, whether that's pulling at the hard strings or comedy, it's going to have a lasting impact.

**中文翻译:**
严重低估。最好的例子就是 Dollar Shave Club。你看，你现在还记得它，那就是素材的力量。虽然投放的人可能只是精准定向了男性，但我敢说当时很多女性也知道它。好的素材应该讲好一个故事。回到我们开头聊的：如果你能触动用户的情感——无论是戳中泪点还是幽默感——它都会产生持久的影响。

---

### [01:27:07] Lenny Rachitsky

**English:**
Chuck on Twitter asked, "When someone steals your traffic, say in Google search results and buying up keywords around your companies, what should you do? Any advice?"

**中文翻译:**
Twitter 上的 Chuck 问：“如果有人在 Google 搜索结果里抢你的流量，买你公司的关键词，该怎么办？有什么建议吗？”

---

### [01:27:07] Timothy Davis

**English:**
Yeah. So that actually goes back to the visual that we showed. The biggest thing is just know that anyone can do that. You can do it too. But a lot of times competitors could be doing it on accident. And what I mean by accident is within Google, if you're bidding on keywords, Google will do what's called a close variant. If you were to do say e-commerce solution, I bet you Shopify shows up as a close variant at some point. So they could just be mismanaging their account. Don't give them that much credit that they're doing this maliciously.

**中文翻译:**
这又回到了我们刚才看的图表。首先要明白，任何人都可以这么做，你也可以。但很多时候竞争对手是无意的。在 Google 里，如果你竞标某个词，Google 会匹配“紧密变体”（Close Variant）。比如你搜“电商解决方案”，Shopify 可能会作为变体出现。所以他们可能只是没管理好账户，别觉得他们都是故意的。

---

### [01:28:15] Timothy Davis

**English:**
You cannot be, if the brand is trademarked within Google, they cannot use your name within the ad copy. Google more times than not will disallow it, but they could misspell it. I can't tell you how many times I've seen Shopify spelled with two I's because Google isn't catching it, but we can always put in a claim to say, "Hey Google, please remove this."

**中文翻译:**
如果你的品牌在 Google 注册了商标，他们不能在广告文案里用你的名字。Google 通常会禁止，但他们可能会故意拼错。我见过无数次把 Shopify 拼成两个 i 的，因为 Google 没抓到。我们可以向 Google 申诉要求移除。

---

### [01:29:46] Lenny Rachitsky

**English:**
AI. You mentioned AI. You're looking for AI tools to help you with your workflows and analyze data. I guess is there anything you've seen AI impact in the work of paid growth and performance marketing?

**中文翻译:**
AI。你提到在找 AI 工具来辅助工作流和分析数据。你觉得 AI 对付费增长和绩效营销产生了什么实质影响吗？

---

### [01:30:06] Timothy Davis

**English:**
As always, I go to the partners and I say, "Hey, what are we doing about this?" And Francisco at Google, actually, he made a really good point. "You guys have been using AI for years now. Smart Bidding is AI. All of the recommendations within Google Ads is AI. Ad copy recommendations is AI." So it was kind of like, let's reset the conversation of, "Hey, this has been here. We have been using it." I do think it's having a huge impact from a content standpoint and a creative standpoint.

**中文翻译:**
我问过合作伙伴。Google 的 Francisco 提醒了我一点：“你们已经用 AI 很多年了。智能竞价（Smart Bidding）就是 AI，Google Ads 里的所有建议、文案推荐都是 AI。”所以我们要重新审视：AI 早就存在了，我们也一直在用。但我认为它现在对内容和素材制作产生了巨大的影响。

---

### [01:32:34] Lenny Rachitsky

**English:**
You mentioned creative. It actually came back to question I forgot to ask. Going back to the team that you hired to run this sort of stuff, you hire this one person, growth marketer, specialist type of person, and the next hire is a creative. What's a sign that it's time to hire the creative person?

**中文翻译:**
提到素材，我想起一个刚才忘了问的问题。你招了第一个增长营销人员后，第二个是素材人员。什么时候是招素材人员的最佳时机？

---

### [01:33:00] Timothy Davis

**English:**
Yeah, if you're using a creative agency and they're getting you everything you want and you're happy with it, then it may not make sense to hire a creative. But more times not what I've noticed from creative ... Creative independence tend to do better than an agency. The biggest difference I see is that matching the right tone, matching the right creative look and feel that you're going for is accomplished way better in-house, and also coming up with new ideas that you can test quickly and iterate on versus, "We only have so many hours with the agency this month."

**中文翻译:**
如果你用着素材代理机构且很满意，那可能不需要招人。但根据我的经验，内部素材人员通常比代理机构做得好。最大的区别在于：内部人员能更精准地把握品牌调性和视觉风格，而且能快速测试新想法并迭代。你不需要担心“这个月代理机构的时间额度用完了”。

---

### [01:34:45] Lenny Rachitsky

**English:**
Timothy, we've covered so much ground. Before we get to our very exciting lightning round, is there anything else that you think would be important or valuable for listeners when they're trying to do this stuff on their own?

**中文翻译:**
Timothy，我们聊了非常多。在进入激动人心的闪电轮问答之前，对于那些尝试自己动手做这些事的听众，还有什么重要的建议吗？

---

### [01:35:05] Timothy Davis

**English:**
Yeah. I said it at one point, but I'll reiterate it. I'm always forward thinking, backwards planning. Just as you're going through it, "Where do you want to be and ultimately how do you think you're going to get there?" Because say your goal is to be on all platforms. "Okay, forward think. That's where you want to be. Now let's backwards plan. "What can we do right now? We can do search because that's only content and that's keywords. We can do that. All right, now we need creative, but where do we start?" And then make iterations along the way.

**中文翻译:**
我再说一遍：永远要“前瞻思考，倒推计划”。问问自己：“你想达到什么目标？你打算怎么做？”假设你的目标是覆盖所有平台。好，这是前瞻目标。现在倒推：“现在能做什么？我们可以先做搜索广告，因为只需要文字和关键词。然后我们需要素材，从哪里开始？”一路上不断迭代。

---

### [01:37:16] Lenny Rachitsky

**English:**
Got it. Well, with that, we reached our very exciting lightning round. Are you ready? First question. What are two or three books that you've recommended most to other people?

**中文翻译:**
明白了。现在进入闪电轮问答。准备好了吗？第一题：你向别人推荐最多的两三本书是什么？

---

### [01:37:28] Timothy Davis

**English:**
Daily Stoic by far. A book I read every day. Great By Choice is another good one. And Deep Work.

**中文翻译:**
首推《每日斯多葛》（Daily Stoic），我每天都读。还有《选择卓越》（Great By Choice）和《深度工作》（Deep Work）。

---

### [01:37:45] Lenny Rachitsky

**English:**
Favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
最近喜欢的电影或电视剧？

---

### [01:37:49] Timothy Davis

**English:**
X-Men '97. Thoroughly enjoyed that. I actually never watched RRR when it first came out. Highly recommend that. The Playlist, which is about Spotify, Welcome to Wrexham and Billion Dollar Code, also on Netflix, about Google Earth.

**中文翻译:**
《X战警 '97》，非常好看。还有《RRR》，强烈推荐。关于 Spotify 的《串流先锋》（The Playlist）、《欢迎来到雷克瑟姆》（Welcome to Wrexham），还有 Netflix 上关于 Google Earth 的《亿万代码》（Billion Dollar Code）。

---

### [01:38:31] Lenny Rachitsky

**English:**
Favorite recent product you've recently discovered that you really love?

**中文翻译:**
最近发现并喜爱的产品？

---

### [01:38:31] Timothy Davis

**English:**
I drink too much caffeine and I've been trying to cut it out and I kind of circled back to this product I used to use called Magic Mind. It's a little shot every single day. Tastes really good and it does help with focus I find.

**中文翻译:**
我咖啡因摄入太多了，正试着戒掉。我重新开始喝一种叫 Magic Mind 的产品。每天一小瓶，味道很好，而且我发现它确实有助于集中注意力。

---

### [01:39:15] Lenny Rachitsky

**English:**
Do you have a favorite life motto that you often come back to share with friends or family?

**中文翻译:**
有没有经常分享给亲友的人生格言？

---

### [01:39:15] Timothy Davis

**English:**
Happiness is dictated by expectations. That can't be more true more times than not. And this one's similar to it: You won't see it for what it is until you stop looking through the lens of what you want it to be.

**中文翻译:**
“幸福取决于预期。”这在大多数时候都是真理。还有一个类似的：“除非你停止用‘你希望它是什么样’的滤镜去看待事物，否则你永远看不清它的真面目。”

---

### [01:40:36] Lenny Rachitsky

**English:**
Is there something about Casey Winters that people may not know?

**中文翻译:**
关于 Casey Winters，有什么大家不知道的趣事吗？

---

### [01:40:44] Timothy Davis

**English:**
Casey is really good at tennis, like insanely good at tennis. In high school, he hadn't played in a year, maybe a year plus. He was still ranked top 10 in the state of Louisiana for tennis players. Insane.

**中文翻译:**
Casey 网球打得超级好，简直是疯狂的好。高中时他有一年多没打球，结果在路易斯安那州依然排名前十。太离谱了。

---

### [01:41:15] Lenny Rachitsky

**English:**
Timothy, this was incredible. I think this is going to help a lot of people figure out marketing, run more paid growth ads, figure out who to bring in to help them do this. Thank you so much for sharing and for being here.

**中文翻译:**
Timothy，这太精彩了。我相信这会帮助很多人理清营销思路，跑好付费广告，并知道该招什么样的人。非常感谢你的分享和到来。

---

### [01:41:36] Timothy Davis

**English:**
Of course. Appreciate the time.

**中文翻译:**
不客气，很开心能来。

---

### [01:41:38] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. See you in the next episode.

**中文翻译:**
大家再见。感谢收听，下期见。