# Tobi Lutke - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Tobi Lütke, CEO of Shopify.

---

### [00:00:00] Tobi Lütke

**English:**
Your podcast is a podcast by a builder for other builders. Here's the most interesting question I think people can ask builders, what is your energy source? My energy source is dissatisfaction with status quo. There are so many books are about this ... Technology leading to dystopia. Like no one who really thinks about this would want to be born into a world 20 years before today. I think today is the dystopia of the future. It behooves us to try to build the kinds of products that leads in ... Towards progress.

**中文翻译:**
你的播客是一个由建设者（builder）为其他建设者制作的播客。我认为人们能问建设者最有趣的问题是：你的能量来源是什么？我的能量来源是对现状的不满。有很多书都在讨论这个……比如技术导致反乌托邦。但凡真正思考过这个问题的人，都不会想出生在 20 年前的世界。我认为今天就是未来的“反乌托邦”。我们有责任努力打造那些能够引领……走向进步的产品。

---

### [00:00:28] Lenny Rachitsky

**English:**
There's a couple quotes along these lines I've seen that describe the way you think about this stuff. "If most people are doing it a certain way I by default don't want to do it that way."

**中文翻译:**
我看到过几句类似的话，描述了你思考这些问题的方式：“如果大多数人都以某种方式做事，我默认就不想那样做。”

---

### [00:00:34] Tobi Lütke

**English:**
There's an aesthetic in the world that exists which is that business people dress in suit and tie, they are speaking much more sophisticated than I do, usually without an accent. They usually have a stick and show dramatically at the chart that is behind them. How much is that aesthetic overlapped with outperformance? Pessimism sounds extremely sophisticated. Optimism always sounds dumb or at least naive. The most powerful unquantifiable things in the word of business are fun and delight.

**中文翻译:**
世界上存在一种审美，即商务人士西装革履，说话比我老练得多，通常没有口音。他们通常拿着指挥棒，戏剧性地指着身后的图表。这种审美与卓越表现之间有多少重叠？悲观主义听起来极其深奥，而乐观主义总是听起来很蠢，或者至少很天真。但在商业世界中，最强大的不可量化因素是“乐趣”和“愉悦”。

---

### [00:01:04] Lenny Rachitsky

**English:**
I don't know of any other company that operates where the founder has this 100-year vision of where the product needs to go and working backwards from that.

**中文翻译:**
我不知道还有哪家公司的运作方式是创始人对产品的发展有着“百年愿景”，并以此进行倒推。

---

### [00:01:11] Tobi Lütke

**English:**
I talk about look in the future and then think backwards a lot, right? It's like what would we want to have done 20 years ago on this? We have very long-term plans. At 100 years you can't talk about this software project but you can talk about the mission itself, whatever things that will survive for 80 years that are left on this particular timeframe. Entrepreneurship is just precious. Shopify exists, basically, to make entrepreneurship more common.

**中文翻译:**
我经常谈论展望未来然后倒推思考，对吧？就像是：针对这件事，我们希望自己在 20 年前做了什么？我们有非常长期的计划。在 100 年的时间跨度上，你不能只谈论这个软件项目，但你可以谈论使命本身，谈论在这个特定时间框架内能存活 80 年的那些东西。创业精神是极其珍贵的。Shopify 的存在，基本上就是为了让创业变得更加普遍。

---

### [00:01:35] Lenny Rachitsky

**English:**
Is there anything you want to leave listeners with?

**中文翻译:**
有什么想留给听众的话吗？

---

### [00:01:37] Tobi Lütke

**English:**
I really, really, really think that there is not a single person on this planet who is even close to being at their maximum potential. Reminding people of their own potential constantly is actually a wonderful thing to do.

**中文翻译:**
我真的、真的、真的认为，这个星球上没有一个人接近发挥出了他们的最大潜力。不断提醒人们他们自身的潜力，实际上是一件非常美妙的事情。

---

### [00:01:54] Lenny Rachitsky

**English:**
Today my guest is Tobi Lütke. Toby is a man who needs no introduction so I'm going to keep this very short and get you right to this jam-packed conversation. If you enjoy this podcast don't forget to subscribe and follow it in your favorite podcasting app or YouTube, it's the best way to avoid missing future episodes and it helps the podcast tremendously. With that I bring you Tobi Lütke. 

This episode is brought to you by Sinch, the customer communications cloud. Here's the thing about digital customer communications. Whether you're sending marketing campaigns, verification codes, or account alerts you need them to reach users reliably, that's where Sinch comes in. Over 150,000 businesses including eight of the top 10 largest tech companies globally use Sinch's API to build messaging, email, and calling into their products.

(00:02:42):
And there's something big happening in messaging that product teams need to know about, Rich Communication Services or RCS. Think of RCS as SMS 2.0. Instead of getting texts from a random number your users will see your verified company name and logo without needing to download anything new. It's a more secure and branded experience. Plus, you get features like interactive carousels and suggested replies. And here's why this matters. US carriers are starting to adopt RCS. Sinch is already helping major brands send RCS messages around the world. And they're helping Lenny's Podcast listeners get registered first before the rush hits the US market. Learn more at getstarted@sinch.com/Lenny. That's S-I-N-C-H.com/Lenny. 

Today's episode is brought to you by Liveblocks, the platform that turns your product into a place that users want to be. With ready-made collaborative features you can supercharge your product with experiences that only top-tier companies have been able to perfect until now. Think AI copilots like Notion, multiplayer like Figma, comments and notifications like Linear, and even collaborative editing like Google Docs. And all of that with minimal configuration or maintenance required. Companies from all kinds of industries and stages count on Liveblocks to drive engagement and growth in their products. Join them today and give your users an experience that turns them into daily active users. Sign up for a free account today at Liveblocks.io/Lenny. Tobi, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Tobi Lütke。Tobi 是一个不需要介绍的人，所以我将长话短说，直接带大家进入这场干货满满的对话。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注，这是避免错过未来节目的最好方式，也对我们有很大帮助。下面，有请 Tobi Lütke。

本集节目由客户沟通云平台 Sinch 赞助。关于数字客户沟通：无论你是发送营销活动、验证码还是账户提醒，你都需要它们可靠地送达用户，这就是 Sinch 的用武之地。全球超过 15 万家企业，包括全球前十大科技公司中的八家，都在使用 Sinch 的 API 将短信、邮件和通话功能集成到他们的产品中。

(00:02:42):
短信领域正在发生一件产品团队需要了解的大事：富通信服务（RCS）。你可以把 RCS 看作短信 2.0。用户收到的不再是来自随机号码的文本，而是能看到你经过验证的公司名称和 Logo，且无需下载任何新应用。这是一种更安全、更具品牌感的体验。此外，你还可以获得交互式轮播图和建议回复等功能。这之所以重要，是因为美国运营商正开始采用 RCS。Sinch 已经在帮助各大品牌在全球范围内发送 RCS 消息。他们正在帮助 Lenny's Podcast 的听众在美国市场爆发前优先注册。欲了解更多信息，请访问 getstarted@sinch.com/Lenny。

今天的节目还由 Liveblocks 赞助，这个平台能将你的产品变成用户想待的地方。通过现成的协作功能，你可以为产品注入顶级公司才能完善的体验。想想 Notion 的 AI 副驾驶、Figma 的多玩家模式、Linear 的评论和通知，甚至是 Google Docs 的协作编辑。所有这些都只需要极少的配置或维护。各行各业、各个阶段的公司都依靠 Liveblocks 来推动产品参与度和增长。今天就加入他们，给你的用户一种能让他们变成日活用户的体验。今天就在 Liveblocks.io/Lenny 注册免费账号。Tobi，非常感谢你能来。欢迎来到本播客。

---

### [00:04:24] Tobi Lütke

**English:**
I'm glad to be here. I'm excited for our conversation.

**中文翻译:**
很高兴来到这里。我很期待我们的对话。

---

### [00:04:26] Lenny Rachitsky

**English:**
I've listened to so many of your other interviews, I've talked to a bunch of people that work for you. I want to try to do something a little different. There's basically two themes that emerged over and over and over as I've listened to you share advice, and interview, and in talking to people that work for you. One is thinking from first principles, the other is maximizing human potential. I'm just going to plant these seeds for now. I'm going to not ask about these directly, I'm going to come at these from the side with the many questions that I have for you. Something that I've heard people describe at Shopify called the Tobi tornado.

**中文翻译:**
我听过很多你的其他采访，也和一群为你工作的人聊过。我想尝试做一些不同的事情。在我听你分享建议、采访以及与你的员工交谈时，有两个主题反复出现：一个是“第一性原理思考”，另一个是“最大化人类潜力”。我现在先埋下这些种子，不直接问，而是通过我为你准备的许多问题从侧面切入。我听 Shopify 的人描述过一个叫“托比龙卷风”（Tobi tornado）的东西。

---

### [00:05:01] Tobi Lütke

**English:**
Oh, wow. Okay, that's a start. I like it.

**中文翻译:**
噢，哇。好吧，这是个开始。我喜欢。

---

### [00:05:06] Lenny Rachitsky

**English:**
What is the Tobi tornado?

**中文翻译:**
什么是“托比龙卷风”？

---

### [00:05:08] Tobi Lütke

**English:**
A Tobi tornado, I would say, is a whole lot of change management or a conversation or conflict or real talk compressed into a very short timeframe. I see something it doesn't ... It's not good, I have a conversation. I have learned something very quickly about hey, I need to update my priors, or cool, let's do it differently. At which point a project might be stopped and we get back together in a room and then we start a new version of a product. And everyone who's currently on the team, of that particular project, is no longer on the project but they are the founders of the next version which is built differently. And that might be a bit whiplashy for people. I mean, I certainly hope that's true, it's certainly what people tell me. It's also what they appreciate about the company. It's like what is best ends up mattering a lot.

**中文翻译:**
我会说，“托比龙卷风”就是将大量的变更管理、对话、冲突或真心话压缩在极短的时间内。我看到一些不好的东西，然后发起对话。我会很快学到一些东西，比如“嘿，我需要更新我的先验认知”，或者“酷，让我们换个方式做”。在那一刻，一个项目可能会被叫停，我们重新聚在一个房间里，开始产品的新版本。而该项目原有的团队成员虽然不再负责原项目，但他们成了以不同方式构建的下一版本的“创始人”。这对人们来说可能有点像“挥鞭伤”（whiplash，指突然的剧烈变动）。我当然希望这是真的，这确实是人们告诉我的。这也是他们欣赏这家公司的地方：追求“最好”最终变得至关重要。

---

### [00:06:08] Lenny Rachitsky

**English:**
Basically, it's you going into a chat room being like "Hey, this" ... "We're going to end this project we're" ... "Let's try something else" because you've discovered or realized this is a bad idea. Some people complain about this practice of like "Oh, Tobi kills the we've been working on." My lens is, you realize we're just wasting time on this thing that is not going to work and we shouldn't do it. Is there anything there along those lines?

**中文翻译:**
基本上，就是你进到一个聊天室说：“嘿，这个项目我们要停掉，让我们试试别的”，因为你发现或意识到这是一个坏主意。有些人会抱怨这种做法，比如“噢，托比杀掉了我们一直在做的东西”。我的视角是，你意识到我们只是在浪费时间做一个行不通的东西，我们不应该继续。是这样吗？

---

### [00:06:32] Tobi Lütke

**English:**
No. This is everything. Again, once I imagine something might be not the right thing to work on I'm either incorrect at which point this is super important that I understand why or I'm correct at which point it's super unfair for letting people work on something that isn't going to make it. There's a third wave which is I could also ignore it but that's an abjection of my CEO and founder responsibility that I'm absolutely not willing to make so that's just not a path forward that I see valid. I understand that's what a lot of people choose to do. So yeah, compressing time is important. We have a fairly limited time in our careers, right? Our careers are not that long. If you're lucky you have 40 years in the industry. Most people spent more time in school and then maybe leave later if they're so lucky that they can. So it's not even that.

(00:07:33):
I think you want to do the maximum amount of things you can be proud of at the end of your career. When you look back you want to be saying, "Hey, holy shit, we shipped this thing which was absolutely an incredible contribution to a mission I cared about at a company that was full of other people who cared as much as I did." And also are very proud of working. And maybe even thinking of working with me and being really, really glad that we spent time on projects together. Yeah, none of this happens if everyone's sort of optimizing a thing that probably shouldn't be there, right? And, therefore, I think it's the better thing to do.

**中文翻译:**
不，这就是全部。再说一次，一旦我觉得某件事可能不是正确的工作方向，要么是我错了，这时理解我为什么错就变得极其重要；要么我是对的，这时让人们继续做一个注定失败的东西是非常不公平的。还有第三种选择，就是我可以忽略它，但那是对我作为 CEO 和创始人职责的亵渎，我绝对不愿意这样做，所以那不是一条我认为有效的道路。我知道很多人会选择那样做。所以，压缩时间很重要。我们的职业生涯时间相当有限，对吧？职业生涯并不长。如果你幸运的话，在行业里有 40 年。大多数人在学校待的时间更长，如果足够幸运能晚点退休的话。所以甚至不止于此。

(00:07:33):
我认为你想在职业生涯结束时，尽可能多地做一些让你感到自豪的事情。当你回首往事时，你想说：“嘿，天哪，我们发布了这个东西，它对我关心的使命做出了不可思议的贡献，而且公司里到处都是和我一样关心这件事的人。” 并且也为在这里工作感到自豪。甚至可能会想到和我一起工作，并为我们一起在项目上花费的时间感到非常、非常高兴。如果每个人都在优化一个本不该存在的东西，这一切都不会发生，对吧？因此，我认为这是更好的做法。

---

### [00:08:16] Lenny Rachitsky

**English:**
And, by the way, I love this way of describing ... Of compressing it in time to just make a decision, not focus on making it come across the most kind, nicest, sweetest way. When you give feedback to people when something is not the way that you think it could be or as good as you could be it's often very direct and often hard to hear. To me this comes across as you're trying to maximize their potential, you're trying to push them to do something better. Is there anything there that you think is a way of approaching feedback?

**中文翻译:**
顺便说一下，我喜欢这种描述方式……在时间上压缩它以迅速做出决定，而不是专注于用最仁慈、最友善、最甜美的方式表达。当你给人们反馈，说某些东西不如预期或不够好时，通常非常直接，往往很难听。对我来说，这给人的感觉是你正在努力最大化他们的潜力，试图推动他们做得更好。关于这种反馈方式，你有什么看法吗？

---

### [00:08:49] Tobi Lütke

**English:**
I really, really, really think that there is not a single person on this planet who is even close to being at their maximum potential. I just think everyone is way, way, way, way, way better than they think. And the reason why we're not performing at this level is a series of ideas, maybe certain approaches for cultivating our skills and our crafts that have not yet been discovered and, therefore, we could not take advantage of them. It's an environment that just narrows the focus on fairly unambitious things at which point you get stuck competing with literally everyone else in the world because everyone's unambitious.

(00:09:33):
I have found that reminding people of their own potential constantly is actually a wonderful thing to do. And I have a history of being right about people's potential more than they are themselves. Now, in a way, this dooms me fairly often to be disappointed, right, in myself. By the way, I'm talking about myself here too. I think I have way more potential than what I bring to bear and I hate that so I'm trying to cultivate the skills that I need for tomorrow and constantly challenge myself. I'm harder on myself than on anyone else. By some discount rate act equally to the people around me, especially the ones who just so, obviously, are brilliant.

(00:10:23):
Spending time and longer time in careers with people and then holding them to a high standard means that they accomplish very often things that just they didn't imagine they could. To me this is the most wonderful thing to see. And frankly this is a throughline for all of my career because this ... My product is that. I want my product to cause people to be more successful than they thought they could. And, in fact, become more ambitious about what they are building with their online stores and their businesses than they are actually initially set out to do.

(00:10:56):
Because something like this happened to me, right? I started a snowboard store at some point. I didn't set out to build Shopify. If you are committed to following your curiosity as to the next step, and optimize for maximum amount of learning when you choose these steps, it takes you from one place to another and you actually realize the world's full of lies about human potential and progress. Maybe people are not malicious about it but they're definitely confused about it. School teaches you that you have to learn this particular piece of math in this 12 month period, and it doesn't matter how much you understand it. It's like the outcome can be variable and will grade you on a variable outcome for a fixed amount of time which has nothing to do with anything I've ever seen or learned or see ... Or witnessed about how to actually learn things. You follow that thread and you just find that there is no speed limit for personal growth. In a way Shopify has been a wonderful experimental lab for this sort of conviction. I've just seen this to come to be true. And, of course, hearing from someone that you respect that "Hey, I think you had it in you to do this thing significantly better because I think you probably saw fairly early in the project this sort of path A path B. You chose path B potentially out of convenience even though you knew that wasn't the right thing. And I actually expected better of you and I expected" ... "I think the next time this happens in your career you should go path A because" ... "Based on your conviction." And, therefore, that's hard to hear, right, because it's right. But it's also extremely valuable, right? What I love is an environment of people who are holding each other accountable to the actual potential rather than sort of their current level plus or ... Plus some, I don't know, a little bit extra.

**中文翻译:**
我真的、真的、真的认为，这个星球上没有一个人接近发挥出了他们的最大潜力。我只是觉得每个人都比他们想象的要好得多得多。我们之所以没有表现出这种水平，是因为一系列观念，或者某些培养技能和手艺的方法尚未被发现，因此我们无法利用它们。这是一个只关注平庸事物的环境，在那一点上，你会被困在与世界上几乎所有人的竞争中，因为每个人都缺乏雄心。

(00:09:33):
我发现，不断提醒人们他们自身的潜力实际上是一件美妙的事情。而且我过去对他人潜力的判断往往比他们自己更准确。现在，在某种程度上，这注定了我经常会对自己感到失望。顺便说一下，我也在说我自己。我认为我的潜力远超我目前表现出来的，我讨厌这一点，所以我正努力培养明天所需的技能，并不断挑战自己。我对自己比对任何人都狠。以某种折现率来看，我对周围人的要求也是一样的，尤其是那些显而易见才华横溢的人。

(00:10:23):
在职业生涯中与人们共度更长的时间，并以高标准要求他们，意味着他们经常能完成自己从未想象过的事情。对我来说，这是最美妙的一幕。坦率地说，这是我整个职业生涯的主线，因为我的产品就是这样。我希望我的产品能让人们比他们想象的更成功。事实上，让他们对自己通过网店和业务所构建的东西变得比最初设想的更有野心。

(00:10:56):
因为类似的事情发生在我身上，对吧？我最初开了一家滑雪板店。我并没打算建立 Shopify。如果你致力于跟随好奇心迈出下一步，并在选择这些步骤时优化学习量，它会带你从一个地方到另一个地方，你会发现世界充满了关于人类潜力和进步的谎言。也许人们并非恶意，但他们肯定对此感到困惑。学校教你必须在 12 个月内学会这道特定的数学题，不管你理解了多少。结果是可变的，他们会在固定的时间内根据可变的结果给你评分，这与我所见、所学或见证的关于如何真正学习事物的任何事情都无关。你顺着这条线索走下去，就会发现个人成长没有速度限制。在某种程度上，Shopify 一直是这种信念的绝佳实验实验室。我亲眼见证了这一切成真。当然，从你尊敬的人那里听到：“嘿，我认为你有能力把这件事做得更好，因为我认为你在项目早期可能就看到了路径 A 和路径 B。你出于方便选择了路径 B，尽管你知道那不是正确的。我其实对你有更高的期望。” “我认为下次在你的职业生涯中发生这种情况时，你应该走路径 A，因为……基于你的信念。” 这种话很难听，对吧？因为它是对的。但它也极其宝贵，对吧？我喜欢的是这样一种环境：人们互相要求对方对实际潜力负责，而不是仅仅满足于当前水平或……稍微多一点点。

---

### [00:13:19] Lenny Rachitsky

**English:**
There's so many threads I want to follow here. The example of the school is such a pertinent one. To me right now we're looking at preschools for our son and I'm ... They're describing their education philosophy I'm like, I don't know why I should believe this is the right approach. And it makes me just want to spend all this time researching what education approach works. I know it's just preschool and maybe not as critical yet.

**中文翻译:**
这里有很多我想深入探讨的线索。学校的例子非常贴切。对我来说，现在我们正在为儿子找幼儿园，他们描述他们的教育理念时，我在想，我不知道为什么要相信这是正确的方法。这让我只想花所有时间去研究什么样的教育方法有效。我知道这只是幼儿园，可能还没那么关键。

---

### [00:13:38] Tobi Lütke

**English:**
Did you have a bet yet? I have three kids too and this is sort of a decision that every parent faces, right? So many of your listeners are probably product managers of machine learning products that maybe this resonates. So there's a funny thing about machine learning which you're just like ... You train on a lot of data, and, hopefully, you get something that predicts the thing you want it to predict correctly out of it. The biggest problem of this is overfitting, right? What does good look like, a loss function? Which is a heuristic because it's not the actual task that the thing will do in the future it's something that proxies to the task that you want the thing to do in the future. Predict fraud, predict the next word, whatever. So overfitting is basically model learning how to cheat on the benchmark or on the fitness function.

(00:14:39):
So there's a business analogy of this which is that ... It's called Goodhart's law. It's literally the same thing as overfitting just for businesses. Goodhart's law just says, "Any metric that becomes a goal ceases to be a good metric." Same exact thing. The universal truths are things that almost any competitive field will invent for itself by different terminology often. And I think this is also, by the way, why it's so interesting to focus on personal growth and learning a lot about a lot because you end up finding these sort of hidden harmonies behind things, the things that are clearly enduring correct insights. So overfitting, Goodhart's law are the same thing. School optimizes for what? Marks supposedly, right? In fact, overfitting in school is literally the kids cheating to get marks, right? You get another analogy. What is however the right loss function for children? Have you made a decision yet?

**中文翻译:**
你决定了吗？我也有三个孩子，这是每个父母都会面临的决定，对吧？你的很多听众可能是机器学习产品的产品经理，也许这会引起共鸣。机器学习有一件有趣的事情：你在大量数据上进行训练，希望从中得到能正确预测你想要预测的东西的模型。最大的问题是“过拟合”（overfitting），对吧？什么是“好”？损失函数（loss function）？这是一种启发式方法，因为它不是该事物未来要执行的实际任务，而是代表你希望该事物未来执行任务的代理指标。预测欺诈、预测下一个词，等等。所以过拟合基本上就是模型学会了如何在基准测试或适应度函数上“作弊”。

(00:14:39):
商业上也有一个类似的类比，叫做“古德哈特定律”（Goodhart's law）。它本质上和商业中的过拟合是一回事。古德哈特定律说：“任何指标一旦成为目标，就不再是一个好指标了。” 完全一样。普遍真理是几乎任何竞争领域都会为自己发明的东，只是术语不同。顺便说一下，我认为这也是为什么专注于个人成长和博学多才如此有趣的原因，因为你最终会发现事物背后隐藏的和谐，那些显然持久且正确的洞见。所以过拟合和古德哈特定律是一回事。学校优化的是什么？理应是分数，对吧？事实上，学校里的过拟合就是孩子们为了拿高分而作弊。再举个类比：对于孩子来说，正确的“损失函数”是什么？你做决定了吗？

---

### [00:15:53] Lenny Rachitsky

**English:**
No, I have not we just started down this path. You told me-

**中文翻译:**
不，我还没有，我们才刚刚开始。你告诉我——

---

### [00:15:55] Tobi Lütke

**English:**
It's the kind of thing [inaudible 00:15:57]. You have to actually go fairly deep in philosophy to figure this out. And then again afterwards you can build, you can find the schools that you like. For us it was just maintaining curiosity. This is a completely different goal from being good at marks. But I just think everyone's born extremely curious and school has a habit of getting it out of kids. Literally, there's a foundation model of a child, and you fine-tune it at school, and it just loses the neurons of curiosity because it's actually discouraged to meander into other topics and explore them just because they're interesting. I don't know. This is sort of not the beat of a podcast but I just think about this a lot. It's funny how these things just recur constantly.

**中文翻译:**
这是那种……（听不清）。你实际上必须深入哲学才能弄清楚这一点。然后你才能建立、找到你喜欢的学校。对我们来说，目标就是保持好奇心。这与拿高分是完全不同的目标。但我认为每个人天生都极具好奇心，而学校有一种把这种好奇心从孩子身上磨掉的习惯。字面上看，孩子有一个“基础模型”，你在学校对他进行“微调”，结果他失去了好奇心的神经元，因为漫游到其他话题并仅仅因为有趣而探索它们实际上是被阻碍的。我不知道。这可能不是播客的主题，但我经常思考这个问题。有趣的是，这些事情总是不断重演。

---

### [00:16:48] Lenny Rachitsky

**English:**
So when Archie was on the podcast, he's the head of growth at Shopify ... I don't know if that's his official role. Basically drives a lot of the growth. He talked about how the core product team, outside of the growth team, operates without KPIs, without specific goals. And decisions are driven by taste and intuition primarily you, and Glen, and some other leaders. And a lot of people heard that and they're like "I" ... "First, I don't believe that. Second of all, how does one operate that way when there's no data to tell us exactly what is right and good?" So the question I have is just how does one operate in that way successfully? What does it take for a company to work that way because a lot of people will try it and fail?

**中文翻译:**
当 Archie 上播客时——他是 Shopify 的增长负责人……我不确定那是他的正式头衔，基本上他推动了很多增长。他谈到核心产品团队（增长团队之外）在没有 KPI、没有具体目标的情况下运作。决策主要由品味和直觉驱动，主要是你、Glen 和其他一些领导者。很多人听到后会说：“首先，我不相信。其次，如果没有数据告诉我们什么是正确和好的，一个人怎么能那样运作？” 所以我的问题是，如何成功地以这种方式运作？一家公司要这样运作需要具备什么条件？因为很多人尝试后都失败了。

---

### [00:17:25] Tobi Lütke

**English:**
This is very close to what I just talked about before with [inaudible 00:17:28]. Goodhart's law is real. The moment a metric becomes a goal it's no longer a useful metric, right? I think that's more or less a precise wording. Why? Because no metric by itself is a complete heuristic for a complex business because business are complex. There's a million of different tensions in a company and you can't all keep them in harmony by optimizing for one fix. It's true that we don't have KPIs and we don't have at least OKRs in the Silicon Valley sense but we are extremely data-informed. We have invested enormous amounts of money and time into systems that give us basically everything at our fingertips. I sent this demo to other founders and they're completely bowled over by the way we can dig into basically every constituent atomic bit part that makes up the cohort that just got formed 15 minutes ago by the end of a ... At the end of a quarter or month or week.

(00:18:39):
In a lot of different places, this is one of them but also in its products, it's just not overfitting for the quantifiable. Everyone competes for everything but it's highly quantifiable because it's ... It's fun, it's like a game. You tweak a number and 0.1 more is better than 0.1 less. That's an immediate gratification thing. But I just think the overlap of most valuable things you can do with a product, and for things that happen to be fully quantifiable, it's like maybe 20% which leaves 80% of a value space unaddressable by the people who will only look at quantifiable things. Shopify is comfortable with the unquantifiable things such as tastes, quality, passion, love, hate. It's with the strong emotions that people have.

(00:19:49):
The sort of deep satisfaction that a craftsperson feels when they've done a job well is actually better proxy if you allow it to be then the ... Do a unit test pass. A unit tests might not pass. And the unit tests will pass 15 minutes later because we already fix them or adjust the one or two things so they support us. We have systems that tell us exactly if something goes the wrong way. There's an extremely sophisticated rollout system in Shopify that forever holdouts and correlates everything with everything for ... In every experiment and so on and so on and so on. But if you think about it as a cockpit for a pilot. The decisions are still made by pilots and we think this leads to better results. It's just the same with our product. There's plenty of A/B testing tools and all these things for commerce, and it's, of course, really important to figure out what your conversion rates are. But are you representing your brand is an unquantifiable question? Are you proud of the thing that you have built? Do you feel it's your own, right?

(00:21:03):
And so I think there needs to be more acceptance in businesses or for unquantifiable things. The most powerful, not unquantifiable things in the world of business are fun and delight. If people have fun when they're doing something that is just upstream from so ... Sorry, downstream from so many other things. I think that if all the metrics are pointing down but everyone says, "My God, I'm having so much more fun," I think that the very next thing that will happen with some time delay is all metrics will start going up. And if that doesn't happen then we adjust course.

(00:21:51):
The reason why we specifically don't have OKRs and these things is because ... If you want to hold the unquantifiable as things that are stable and exist ... That people actually do really defer to them and really actually learn to be okay with someone just saying, "Hey, this is actually just really great and they're shipping this" then you need to make certain edits to a business that don't remind everyone too much of the companies they might have come from which the only way to get promoted is by driving the metric up. It's a bit of a [inaudible 00:22:24] conversation I suppose. Good on the fortune cookies saying, "Shopify doesn't do OKRs or doesn't do metrics" and so on. But it's actually just because the metrics take us [inaudible 00:22:37] function where we often defer to just more ... Sometimes a little bit emotional but generally less quantifiable things.

**中文翻译:**
这与我之前谈到的非常接近。古德哈特定律是真实的。一旦指标成为目标，它就不再是有用的指标了，对吧？我认为这或多或少是准确的措辞。为什么？因为没有任何单一指标能成为复杂业务的完整启发式方法，因为业务是复杂的。公司里有成千上万种不同的张力，你无法通过优化一个固定指标来让它们全部保持和谐。确实，我们没有 KPI，至少没有硅谷意义上的 OKR，但我们是极度“数据驱动”的。我们投入了大量资金和时间建立系统，让一切信息触手可及。我把这个演示发给其他创始人，他们对我们能够深入挖掘 15 分钟前刚刚形成的群组（cohort）的每一个原子组成部分感到震惊。

(00:18:39):
在很多地方，包括产品中，我们只是不对可量化的东西进行“过拟合”。每个人都在竞争，但如果竞争是高度可量化的，那就像游戏一样。你调整一个数字，多 0.1 就比少 0.1 好。这是一种即时满足。但我认为，你能对产品做的最有价值的事情，与那些恰好完全可量化的事情之间的重叠，可能只有 20%。这意味着 80% 的价值空间是那些只看量化指标的人无法触及的。Shopify 对不可量化的东西感到自在，比如品味、质量、激情、爱、恨。这些都是人们拥有的强烈情感。

(00:19:49):
如果允许的话，工匠在做好工作时感受到的那种深度满足感，实际上是比“单元测试是否通过”更好的代理指标。单元测试可能没通过，但 15 分钟后就会通过，因为我们已经修复了它们或调整了一两处。我们有系统能准确告诉我们是否有事情出了差错。Shopify 有一个极其复杂的发布系统，在每个实验中都会进行长期的对照和关联分析。但如果你把它想象成飞行员的驾驶舱，决策仍然是由飞行员做出的，我们认为这会带来更好的结果。我们的产品也是如此。电商领域有很多 A/B 测试工具，弄清楚转化率当然非常重要。但“你是否代表了你的品牌”是一个不可量化的问题。“你是否为你构建的东西感到自豪？” “你是否觉得它是你自己的？”

(00:21:03):
所以我认为企业需要对不可量化的事物有更多的接受度。商业世界中最强大的不可量化因素是“乐趣”和“愉悦”。如果人们在做某件事时感到快乐，那是许多其他事情的下游结果。我认为，如果所有指标都在下降，但每个人都说：“天哪，我玩得开心多了”，那么在一段时间延迟后，接下来的事情就是所有指标都会开始上升。如果没发生，那我们就调整方向。

(00:21:51):
我们之所以不设 OKR 之类的东西，是因为……如果你想把不可量化的东西作为稳定存在的事物，让人们真正尊重它们，并真正学会接受某人说“嘿，这真的很棒，我们要发布它”，那么你需要对业务进行某些修改，不要让每个人都想起他们可能来自的那些公司——在那些公司里，晋升的唯一途径就是拉升指标。这有点像……（听不清）的对话。那些“锦囊妙计”说“Shopify 不做 OKR 或指标”等等，其实是因为指标带我们进入了一个函数，在这个函数中，我们经常转向更……有时带点情感，但通常较少可量化的事物。

---

### [00:22:48] Lenny Rachitsky

**English:**
I imagine if someone were to hear you describe this of focus on joy, and fun, and love, and delight, maybe ... It's easy to dismiss that.

**中文翻译:**
我想如果有人听到你描述关注快乐、趣味、爱和愉悦，也许……很容易对此不屑一顾。

---

### [00:22:58] Tobi Lütke

**English:**
It sounds completely idiotic, right? Again, there's an aesthetic in the world that exists which is that business people dress in suit and tie, they are speaking much more sophisticated than I do usually without an accent, have a full head of hair. They talk about metrics, they are in front of PowerPoint presentations, they usually have a stick and show dramatically at the pie chart that is behind them. And highly charismatic, highly ... So that's our aesthetic. How much is that aesthetic overlapped with our performance? I don't know but some of them ... Some people pull it off who are like this. I think the world is sort of stacked to lead us astray based on our stories about what optimal looks like are just so incorrect in so many ways. Optimism always sounds dumb, or at least naive. Pessimism sounds extremely sophisticated. Metrics driven sounds extremely sophisticated. Talking about fun sounds like naive.

(00:24:14):
Well, first of all, I've always ignored what people think generally. That came pretty natively to me somehow which I'm very lucky about. But I've now actually learned that almost all of the alpha in the world is now in the ... Exactly the things that are unobvious but true. And the things that people dismiss as naive or so. The most successful business person on planet Earth is Elon and he conforms to no idea of what the most sophisticated business person ought to be like in any which way you can imagine. I think we live in a world where the counterfactuals are winning because our ... Because aesthetics are just leading us astray.

**中文翻译:**
听起来完全像个白痴，对吧？再说一次，世界上存在一种审美：商务人士西装革履，说话比我老练得多，通常没有口音，头发浓密。他们谈论指标，站在 PPT 前，通常拿着指挥棒戏剧性地指着身后的饼图。极具魅力，极具……这就是我们的审美。这种审美与表现有多少重叠？我不知道，但有些人确实能做到。我认为世界在某种程度上误导了我们，因为我们关于“最优”长什么样的故事在很多方面都是错误的。乐观主义听起来总是很蠢，或者至少很天真。悲观主义听起来极其深奥。指标驱动听起来极其深奥。谈论乐趣听起来很天真。

(00:24:14):
首先，我通常总是忽略别人的想法。这对我来说是天生的，我很幸运。但我现在实际上学到，世界上几乎所有的“超额收益”（alpha）现在都存在于……那些不明显但正确的事情中。以及那些被人们斥为天真或类似的东西中。地球上最成功的商人是埃隆（马斯克），他在任何你能想象的方面都不符合人们对“最老练商人”应有样子的定义。我认为我们生活在一个“反事实”正在获胜的世界，因为我们的审美正在误导我们。

---

### [00:25:02] Lenny Rachitsky

**English:**
This is an awesome segue to the other theme that I wanted to spend some time on which is thinking from first principles, Elon is the classic example of that. Honestly, I think you're the other most classic example of that these days. And we'll keep talking about all the ways you operate very differently from other companies which are examples of this. But I want to read a quote from Glen Coates, he shared with me, of how he sees you that gives an interesting lens into your first principles thinking. So here's what he said about you. "Tobi is at his heart a true futurist, he's obsessed with the way things should be in the future. Being data-driven is innately being anchored in the way users and technology are behaving today. He's never really said this to me explicitly, but knowing him I think any design that is drawn primarily from the way things are or were is one that he sees as inferior to one that is skating to the puck of the way things could or should be." Does that resonate?

**中文翻译:**
这是一个很好的过渡，引出了我想花时间探讨的另一个主题，即“第一性原理思考”，埃隆是这方面的经典例子。老实说，我认为你是当今另一个最经典的例子。我们将继续讨论你与其它公司运作方式迥异的各种案例。我想读一段 Glen Coates 跟我分享的关于他如何看待你的话，这为你的第一性原理思考提供了一个有趣的视角。他是这样评价你的：“Tobi 内心深处是一个真正的未来主义者，他痴迷于未来事物应有的样子。‘数据驱动’本质上是锚定在用户和技术今天的行为方式上。他从未明确对我这么说过，但了解他之后，我认为任何主要基于现状或过去的设计，在他看来都逊色于那种‘滑向冰球未来位置’（skating to the puck，意指预判未来）的设计。” 这能引起你的共鸣吗？

---

### [00:25:55] Tobi Lütke

**English:**
Yeah. I mean, I think that's correct. That's actually really interesting. Your podcast is a podcast by a-

(00:26:01):
Your podcast is a podcast by a builder for other builders. Here's the most interesting question I think people can ask builders is like, "What is your energy source? Where are you getting energy from?" I think fundamentally the world exists at room temperature. Almost all companies are running at that, humming along, doesn't do anything. There are certain individuals who can inject heat into businesses. Founders do this very well. All the startups anyone's ever heard of have people who are injecting heat because if no one would inject heat into the business, at room temperature, you cannot outperform anyone else. You can't be hotter than everyone else if no one's injecting heat into the concern. So fundamentally, there is a injection of energy into companies that comes from founders and the best leaders, like all the people you've had on the podcast from Shopify have a perfect set of cast of characters of people who are just exothermic. They are just like wellsprings of energy that leads to all the amazing results that we get to enjoy.

(00:27:21):
So the question is where does energy comes from? And that's another one of our discussions which very quickly goes into the emotions. Actually, there's a really... So I watched The Last Dance, the Netflix special of Michael Jordan a while ago, of course, but there was one scene where he just, I'm sure this is a super famous story and he just made up an insight that someone told him so that he would then go and just want to destroy them afterwards, which he then of course proceeded to do because it's hard to imagine anyone more exothermic than him. So we know what his energy source is. It's rivalry. It's potentially it's insight or it's anger, something like this.

(00:28:06):
I am not... My energy source is dissatisfaction with status quo. My fundamental belief is all this talk about technology where all... So many books are about just technology leading to dystopia. You know what dystopia is? Today, compared to what it will be in 20 years ago or any. And you can play this for any part of human history. I'm not making a future statement. I'm making a almost totalical statement about the experience on planet Earth. No one who really thinks about this would want to be born into a world 20 years before today rather than today. And so I think today is the dystopia of future, and I think it behooves us to try to build the kinds of products that lead in towards progress in a small way or a big way. But yes, I think if someone comes to me and says, "Hey, let's go do this thing. And we've looked around and here's how people solve this problem, let's make a good version of that," I'm like, "That was not the job." Because everything that you encounter, that every solution, every product, everything that exists is path-dependent, highly, highly, highly path-dependent, and often path-dependent based on having to make compromises, based on things that were true at the time a decision was made but are no longer true.

(00:29:38):
The entire field of... What was it? I forgot the name of a field. Chomsky's field, the linguistic research field. It's cool. We now have autoregressive models that are just like, we don't actually need to set up a complete... We don't need to research the structure of grammar to be able to make machines also engage in the spoken word. We actually can just train on the internet, it turns out. So that was not possible back then because you didn't have the right architecture for this, but now it is. So I think what you have to do is to actually have, when you come up with a new product or you discuss a new product, you have to derive it from first principles. You have to say, "How would we solve this problem given every fundamental building block that we have available right now?"

(00:30:25):
For that, to do that, you actually have to understand the power and the composability of all the building blocks that exist right now, which is a tall order and no one is perfect at this. But so this way, you go ahead and say, "Okay, cool, so this is how we are implementing this thing. This is how it will be implemented today." And now we can talk ourselves in taking shortcuts. "Maybe we should actually start up doing it the way everyone else does. Maybe we derived exactly what everyone else does as the correct thing to do."

(00:30:56):
Sometimes there was a lot more wisdom encoded in the status quo than you expect, which is I think is super delightful. Then you figure that out and so when you act on it. But what isn't okay is skipping the exercise and doing the same thing everyone else does because that is again a abdication of product leadership. And so yeah, I would say I become extremely suspicious if I get a pitch to do a good version of the same thing everyone else does because I just find that in our space specifically very rarely to be the best solution.

**中文翻译:**
是的。我认为那是正确的。这真的很有趣。你的播客是一个由……

(00:26:01):
你的播客是一个由建设者为其他建设者制作的播客。我认为人们能问建设者最有趣的问题是：“你的能量来源是什么？你从哪里获得能量？” 我认为从根本上说，世界是以“室温”存在的。几乎所有的公司都在这个温度下运行，平稳运转，不产生任何波澜。但某些特定的个体可以为业务注入“热量”。创始人在这方面做得很好。所有人们听说过的初创公司都有注入热量的人，因为如果没有人注入热量，在室温下，你无法超越任何人。如果没有人注入热量，你不可能比别人更“热”。所以从根本上说，注入公司的能量来自创始人。最好的领导者，就像你在播客中采访过的所有 Shopify 员工一样，他们是一群“放热型”（exothermic）的人。他们就像能量的源泉，带来了我们所享受的所有惊人结果。

(00:27:21):
所以问题是，能量从哪里来？这是我们讨论的另一个话题，很快就会涉及到情感。实际上，有一个非常……我前段时间看了 Netflix 关于迈克尔·乔丹的纪录片《最后一舞》，当然，其中有一幕，他编造了一个别人对他说的见解，这样他之后就会想去摧毁他们，他当然也确实这么做了，因为很难想象有谁比他更“放热”。所以我们知道他的能量来源是什么：是竞争，可能是洞察力，或者是愤怒，诸如此类的东西。

(00:28:06):
我不是……我的能量来源是对现状的不满。我的基本信念是，所有关于技术的讨论……很多书都在讲技术如何导致反乌托邦。你知道什么是反乌托邦吗？今天，相对于 20 年后或任何未来的样子，就是反乌托邦。你可以把这套逻辑应用到人类历史的任何阶段。我不是在做未来的预言，我是在对地球上的体验做一个几乎是恒真命题的陈述。任何真正思考过这个问题的人，都不会想出生在 20 年前的世界，而不是今天。所以我认为今天就是未来的反乌托邦，我认为我们有责任尝试打造那些能以微小或巨大的方式引领进步的产品。但是，如果有人来找我说：“嘿，让我们去做这件事。我们观察了一下，别人是这样解决这个问题的，让我们做一个更好的版本吧”，我会觉得：“那不是我们要干的活。” 因为你遇到的每一件事、每一个解决方案、每一个产品、每一个存在的事物都是“路径依赖”的，高度、高度、高度路径依赖，而且往往是基于不得不做出的妥协，基于决策时正确但现在已不再正确的前提。

(00:29:38):
整个领域……叫什么来着？我忘了那个领域的名字。乔姆斯基的领域，语言学研究领域。现在很酷，我们有了自回归模型，我们实际上不需要建立一个完整的……我们不需要研究语法的结构就能让机器参与口语交流。事实证明，我们只需要在互联网上进行训练。这在当时是不可能的，因为没有合适的架构，但现在有了。所以我认为你必须做的是，当你构思一个新产品或讨论一个新产品时，你必须从第一性原理出发。你必须问：“给定我们现在可用的每一个基础构建块，我们会如何解决这个问题？”

(00:30:25):
要做到这一点，你实际上必须理解目前存在的所有构建块的力量和可组合性，这是一个很高的要求，没有人是完美的。但通过这种方式，你会说：“好，酷，这就是我们实现这个东西的方式。这就是它在今天被实现的方式。” 现在我们可以讨论是否要走捷径。“也许我们实际上应该开始像其他人那样做。也许我们推导出的正确做法恰好就是其他人正在做的。”

(00:30:56):
有时现状中蕴含的智慧比你预期的要多得多，我认为这非常令人愉悦。然后你弄清楚了，并据此行动。但不可接受的是跳过这个推导过程，直接做别人都在做的事情，因为那又是对产品领导力的放弃。所以，如果我收到一个提案，说要做一个别人都在做的东西的“好版本”，我会变得极其怀疑，因为我发现在我们的领域，这极少是最佳解决方案。

---

### [00:31:33] Lenny Rachitsky

**English:**
There's a couple quotes along these lines I've seen that describe the way you think about this stuff. "If most people are doing it a certain way, I, by default, don't want to do it that way. And if you want to do something world-class, you can't do it like everyone else."

**中文翻译:**
我看到过几句描述你思考方式的话：“如果大多数人都以某种方式做事，我默认就不想那样做。如果你想做世界级的事情，你就不能像其他人那样做。”

---

### [00:31:46] Tobi Lütke

**English:**
Yeah. I don't even think that's an opinion that I hold. I think that's actually... We are basically in axiom territory here. If you want to do something better than what exists, you have to do it differently. That does not make a statement about if it will be better in the end after you do it. It could also be worse. But you can't get something better done if you do the same thing. It's like axiomatically not possible to do. It's fails Archimedean logic, yet it's something... You would be amazed how many business plans are actually failing Archimedean logic in this way like, "Let's do a good version of this thing that we've already been doing and we will capture 1% of the market," and just like this stuff. It's like, "Trust me." I find it kind of cute.

**中文翻译:**
是的。我甚至不认为这只是我的一个观点。我认为这实际上……我们已经进入了“公理”范畴。如果你想做出比现有事物更好的东西，你必须做得不一样。这并不是说你做了之后最终一定会更好，也可能会更糟。但如果你做同样的事情，你就不可能做得更好。这在公理上是不可能的。这违背了阿基米德逻辑，然而……你会惊讶于有多少商业计划实际上是以这种方式违背逻辑的，比如“让我们做一个我们已经在做的东西的好版本，然后我们将占领 1% 的市场”，诸如此类的东西。就像在说“相信我”。我觉得这挺可爱的。

---

### [00:32:36] Lenny Rachitsky

**English:**
Is there an example that you can share of you approaching the problem this way? I imagine it's constantly happening. You also mentioned you're born this way. So I think it's hard for someone to just sit down, learn, think the way Tobi thinks, but I'd love to help people start to approach problems this way, so maybe an example might help.

**中文翻译:**
你能分享一个你以这种方式处理问题的例子吗？我想这经常发生。你也提到你天生如此。所以我认为让某人坐下来学习像 Tobi 那样思考很难，但我很想帮助人们开始以这种方式处理问题，所以也许一个例子会有所帮助。

---

### [00:32:54] Tobi Lütke

**English:**
I think this is entirely learnable, I think. And so I encourage people to just have a practice of think step by step essentially and just do it. It'll become a habit pretty quickly because it just, it also just outperforms.

(00:33:09):
Examples. The very first example is Shopify itself. It's cool. So there was lots of e-commerce software and it was all the way it was because of path dependence because everyone who want it in 2004, 2005, e-commerce was an existing retailer and therefore they had complex businesses that needed to be ported online, including all of their somewhat Byzantine business logic. "I wanted to make e-commerce software that would do very well on the internet of the future and I believe that we can make it easier to start new businesses online than it is in a physical world because the physical world is encumbered by a lot of regulations and also upfront costs for leases and so on. So let's optimize for that case and build something that is so intuitive to use that frustrated people in dead-end careers can spend their lunch breaks making progress towards building their own business, which then eventually allows them to do it on their own way."

(00:34:25):
And so being fortune was biased, eventually it turns out to be a much better prep for also solving all the enterprise cases because no one had to... Enterprise software is overfit to the sales process, which is that it wins the RFPs because it has every feature ever or at least a way of putting a checkbox next to every RFP line ever. But they're not good, right? An RFP is a great example of overfitting in the world of procurement because it tells you nothing about the quality of software behind it. But honestly, this happens all the time. It is just like here, we are setting the stage for much more, much higher quality retrieval for the products on Shopify and across Shopify. I think we've been in a local maxima on search and we think that, especially with the advances of the new models, certain things are now possible to do that could not have been done yet because again of these layers and layers of path dependence and no one coming and saying, "Is that the best way to do and maybe we should rebuild this component periodically?" We can now do a better job if search that will leads to much more delightful experiences. And so this is a fun project that this happening right now in.

**中文翻译:**
我认为这完全是可以习得的。所以我鼓励人们养成“逐步思考”的习惯并付诸实践。它很快就会变成一种习惯，因为它表现得更好。

(00:33:09):
例子。第一个例子就是 Shopify 本身。当时有很多电商软件，它们之所以是那个样子是因为路径依赖——因为在 2004、2005 年，想要电商软件的人都是现有的零售商，因此他们有复杂的业务需要搬到网上，包括他们那些有些拜占庭式（复杂且陈旧）的业务逻辑。“我想做一款在未来的互联网上表现出色的电商软件，我相信我们可以让在线创业比在物理世界更容易，因为物理世界受到大量法规以及租赁等前期成本的束缚。所以让我们针对这种情况进行优化，构建一个使用起来非常直观的东西，让那些在职业生涯中感到沮丧的人可以利用午休时间朝着建立自己的业务迈进，最终让他们能以自己的方式做事。”

(00:34:25):
事实证明，这种偏向最终成为了解决所有企业级案例的更好准备，因为没有人必须……企业级软件是对销售过程的“过拟合”，也就是说，它赢得 RFP（征求建议书）是因为它拥有所有功能，或者至少有办法在每个 RFP 条目旁边打勾。但它们并不好用，对吧？RFP 是采购领域过拟合的一个绝佳例子，因为它完全没有告诉你软件背后的质量。但老实说，这种情况一直在发生。就像现在，我们正在为 Shopify 内部及跨平台的产品搜索搭建更高质量的检索阶段。我认为我们在搜索方面一直处于局部最优解（local maxima），我们认为，特别是随着新模型的进步，某些事情现在已经可以实现了，而以前由于层层路径依赖，且没有人站出来说“这是最好的方式吗？也许我们应该定期重建这个组件？”而无法实现。我们现在可以把搜索做得更好，从而带来更令人愉悦的体验。这是一个正在进行的有趣项目。

---

### [00:35:50] Lenny Rachitsky

**English:**
I think this is really interesting because what I'm looking for is like the Tobi algorithm of first principles thinking. Elon's got these famous ways of thinking he shared. One is start with the cost of metal to help you understand how much a rocket should cost. And then he's got this five-step. First, decide, do we need this thing? Then figure out how to optimize it, then automate it. What I'm hearing so far, and I'm curious if you've thought about this? And if not, this feels like a really good blog post in your futures, the Tobi first principles algorithm, but I'll share a couple of things I've heard so far as you've described it.

(00:36:24):
One is analyze the path that existing solution has relied on, almost like the assumptions that were true for it to be built back and it was built. And the other is this overfit, what is it overfit for? What is it over solving that maybe isn't necessary? Is there anything along those lines of just how you approach problems?

**中文翻译:**
我觉得这非常有趣，因为我正在寻找类似“托比第一性原理思考算法”的东西。埃隆分享过一些著名的思考方式。一个是“从金属成本开始”，以帮助你理解一枚火箭应该花多少钱。然后他有一个五步法：首先，决定我们是否需要这个东西？然后想办法优化它，最后自动化。到目前为止我听到的，我很好奇你是否思考过这个？如果没有，这感觉会是你未来一篇很好的博客文章——“托比第一性原理算法”。但我会分享一些到目前为止我听到的你描述的东西。

(00:36:24):
一个是分析现有解决方案所依赖的路径，就像是它构建之初所基于的那些假设。另一个是这种“过拟合”——它针对什么进行了过拟合？它过度解决了哪些可能并不必要的问题？关于你处理问题的方式，还有什么类似的吗？

---

### [00:36:43] Tobi Lütke

**English:**
This is probably too nerdy technical. You are right, but I should figure myself out a little bit. My brain runs on a meter language but isn't directly something I can translate into words, I suppose. I think more about things like this in terms of programming constructs, pure functions, overstate. And I think in any moment, the best decision to do is I think the perfect product lead is almost like a thermostat for high quality product. It's like you're setting, saying, "I would like to build something really, really great and I'm going to go through a series which is much, much more complex than what a thermostat does," which basically checks the temperature and then makes a decision of air con or heating. You make you re-derive literally every decision that is valuable, every foundational assumption, every foundational ABC direction. And you want to see the observation you've made in the meantime since you last derived the next step. Re-running the entire function over the state that is now updated, the higher fidelity information, would you come to the very same thing?

(00:38:08):
Sometimes fairly early in the construct in the tree of foundational assumptions, change is made. An example we all had was beginning of COVID when we suddenly had shelter in place. So Shopify has that incredibly good office spaces and we were very in-person company and we've... Our floor plans because I think we really added something to the understanding of how to put great... I got a lot of founder energy from my co-founder, Daniel, to build great collaborative spaces for creative work with lots of happy accidents, people running into each other and so on.

(00:38:46):
Anyway, we were very, very, very, very determined on doing that. But somewhere in this construct of nesting functions, you have to rerun and foundational assumptions. It's in the stack is the fairly basic Boolean of are people allowed to leave a house? Which was yes. The moment that flips, it's not that just like, "Okay, over here let's do the best what we can do." It's actually that the entire tree now moves into a different place. And it can be a very far place, different, that you land because you will make the same quality of decision on every step, but you need to rerun something that takes you to a completely different landing zone. And so then this is also easy for us to say, "Cool, we are going to be remote only forever? Let's go." And because we realized that the temporal shelter in place would cause a series of events that would make that for optimal best set of trade-offs for the company. And so I think this is... Can I put this into a piffy five-step? I wouldn't know, but maybe it resonates with someone who can help me figure out the coded English language for this because it has been nerdy way the I explained it, even to me.

**中文翻译:**
这可能太技术宅了。你是对的，但我应该稍微理清一下自己的思路。我的大脑运行在一种元语言（meta language）上，我想这并不是能直接翻译成文字的东西。我更多地从编程结构、纯函数（pure functions）、状态（state）的角度来思考这类事情。我认为在任何时刻，最佳的决策是……我认为完美的产品负责人几乎就像高质量产品的“恒温器”。就像你在设置，说：“我想打造一些非常非常棒的东西，我将经历一系列比恒温器复杂得多的过程”，恒温器基本上只是检查温度，然后决定是开空调还是加热。你会重新推导每一个有价值的决策，每一个基础假设，每一个基础的 ABC 方向。你想看看自上次推导下一步以来你所做的观察。在现在已经更新的状态（更高保真度的信息）上重新运行整个函数，你会得到同样的结果吗？

(00:38:08):
有时在基础假设树的结构中，很早就会发生变化。我们都经历过的一个例子是 COVID 初期，当时我们突然被要求居家隔离。Shopify 拥有非常棒的办公空间，我们曾是一家非常强调面对面工作的公司，我们的楼层设计……因为我认为我们确实对如何打造伟大的……我从我的联合创始人 Daniel 那里得到了很多能量，去建立伟大的创意工作协作空间，创造很多“美丽的意外”，让人们互相偶遇等等。

(00:38:46):
总之，我们当时非常、非常、非常坚定地要那样做。但在嵌套函数的结构中，你必须重新运行基础假设。在堆栈中有一个相当基础的布尔值（Boolean）：“人们被允许离开家吗？” 之前是“是”。当它翻转的那一刻，不仅仅是说“好吧，那我们就在这方面尽力而为”。实际上是整棵决策树现在移动到了一个不同的地方。你最终落脚的地方可能非常遥远且不同，因为你在每一步都会做出同样质量的决策，但你需要重新运行一些东西，带你进入一个完全不同的着陆区。所以，对我们来说，说“酷，我们要永远远程办公了？走起”也很容易。因为我们意识到，暂时的居家隔离会引发一系列事件，使得远程办公成为公司最优的权衡方案。所以我觉得……我能把它写成精炼的五步法吗？我不知道，但也许这能引起某些人的共鸣，帮我弄清楚这种“编码后的英语”，因为即使对我来说，我刚才的解释方式也太宅了。

---

### [00:40:05] Lenny Rachitsky

**English:**
This remote work example is something I definitely wanted to touch on, which is I'm glad you got there. So in this decision, is there anything more you could share about how you got to that place of like, "Oh this Boolean changed so we should rethink this?" Because I know you probably, you weren't... I don't know. Were you in the shower and just like, "Oh wow, we should really go remote because of this"? How did that actually come about? And then I wanted to ask on another part-

**中文翻译:**
远程办公的例子是我绝对想触及的，很高兴你提到了。那么在这个决定中，关于你是如何到达那个“噢，这个布尔值变了，所以我们应该重新思考”的境地的，还有什么可以分享的吗？因为我知道你可能不是……我不知道，你是在洗澡时突然想到“噢哇，因为这个我们真的应该远程办公”吗？那是怎么发生的？然后我还想问另一个部分——

---

### [00:40:27] Tobi Lütke

**English:**
Yeah, pretty much actually yes because again, I rerun over all the inputs and figure out what happens. And here's a couple of other things that were starting to fray on the decision to be in person as well. We started in Ottawa, Canada, which is a city of a million people, and it has some tech heritage and good universities. But at a million people, it's just not population dense enough and has a depth of talent pool that it can support a company that is going to 10,000 people. So anyone who runs this optimization function I'm talking about here about location strategy for a new startup will come to the conclusion if they do it right that everyone should be sitting around the same table. Only if you can't do that, do you say, "Okay, let's be all in the same couple of rooms." Only if that doesn't work anymore, you say, "Okay, let's be spread over one floor." If that doesn't work, in the same building. If that doesn't work, in the same city. If that doesn't work, at least stay in the same time zones or make sure that there's good hub connections between.

(00:41:39):
This is how it works. It's just like some assumption somewhere along the line is invalidated. You end up in a different side of a decision tree. But what was happening to us was we already were in four or five cities. We were adhering to the same time zone at this point. But my experience was I went through, sometimes at the Ottawa office, through an entire day where I had 10 hours of meetings, which is fairly normal, but I do every single... I don't think I had a single other person sometimes with me because every one of them was with people in another office. Some people are dialing in remote and so on. So there was an awkward hybrid-ness which we ended up in making only good decisions along the way.

(00:42:29):
This is actually the most dangerous thing. Most of the time you end up in a bad part of a tree, in a local maxima of a path-dependent environment, by only making good choices. People think that making a good choice inoculates you from making mistakes or that the presence of a downside of an idea ends up disqualifying the idea. Both of those things are incorrect. So what you need to do then is... So that was an overlay to decision.

(00:42:59):
The moment COVID started, then we also had this thing of shoppers exploding because we were actually an asset to people during COVID, e-commerce for the local businesses. And we took that very, very seriously trying to make more businesses survive COVID, small businesses survive this particular calamity than otherwise won't which is important because small businesses tend to be wiped out first anytime the times turn fragile. And so we needed to staff up. And so there's a very weird question about where to staff up. So clearly the better input there would be if you could hire people everywhere. And so once that decision flipped, you can see how this is actually now super easy to say, "We are going to remote," because there is no turning back. There is no... Even with this decision, it's a better set of trade-offs for the future is to accept the vast additional difficulty of building a remote company. It's way harder.

(00:44:03):
It's not something you should recommend to anyone to do this because it's the same as trying to run a world record marathon run in Aspen, Colorado. It's like there's not enough oxygen up there to do that. But if you end up pulling it off, you're a real Chad. That's very cool. So I find difficulty itself interesting. And again, I spent enough of my teenage years on the internet to know that there's amazing cultures that can be put together purely remote like, I don't know, Wikipedia, World of Warcraft, Raiding Guilds can at least have excellent cultures. And so we are like, "Okay, cool. Let's come to a new stable part." That stable part was don't port the office online. Let's port the internet into a company and then we are like, "Let's go."

**中文翻译:**
是的，实际上差不多就是那样，因为我再次运行了所有的输入并计算结果。还有其他几件事也开始让“面对面办公”的决定产生裂痕。我们始于加拿大渥太华，那是一个拥有 100 万人口的城市，有一些技术底蕴和不错的大学。但在 100 万人口的规模下，人口密度不够，人才池的深度不足以支撑一家发展到 1 万人的公司。所以，任何运行我在这里谈论的关于新创业公司选址策略优化函数的人，如果做得对，都会得出结论：每个人都应该坐在同一张桌子旁。只有当你做不到这一点时，你才会说：“好吧，让我们都在同一个房间里。” 只有当那也不行时，你才会说：“好吧，让我们分布在同一层楼。” 如果那还不行，就在同一栋楼。如果那还不行，就在同一个城市。如果那还不行，至少留在同一个时区，或者确保之间有良好的枢纽连接。

(00:41:39):
这就是它的运作方式。就像沿途的某个假设失效了，你最终进入了决策树的另一侧。但当时发生在我们身上的是，我们已经分布在四五个城市了。当时我们还坚持在同一个时区。但我的体验是，有时在渥太华办公室，我开了一整天 10 小时的会（这很正常），但我发现……有时我身边一个其他人都没有，因为每一个会议都是和另一个办公室的人开的。有些人是远程拨入等等。所以出现了一种尴尬的“混合状态”，而我们一路上做的每一个决定都是“正确”的。

(00:42:29):
这实际上是最危险的事情。大多数时候，你之所以最终落在决策树的一个糟糕分支上，落入路径依赖环境的局部最优解中，正是因为你只做“正确”的选择。人们认为做一个正确的选择就能让你免于犯错，或者认为一个想法存在缺点就足以否定它。这两者都是错误的。所以你当时需要做的是……那是决策的一个背景。

(00:42:59):
COVID 开始的那一刻，购物者激增，因为在 COVID 期间我们实际上成了人们的资产，为当地企业提供电商服务。我们非常认真地对待这件事，努力让更多的企业在 COVID 中生存下来，让小企业度过这场灾难，否则它们可能无法幸存。这很重要，因为每当时代变得脆弱，小企业往往最先被淘汰。所以我们需要扩充人员。于是出现了一个非常奇怪的问题：在哪里扩充人员？显然，更好的输入是如果你可以在任何地方雇人。所以一旦那个决定翻转了，你可以看到，现在说“我们要转为远程”其实超级容易，因为没有回头路了。即使有了这个决定，对未来更好的权衡也是接受建立远程公司的巨大额外难度。这要难得多。

(00:44:03):
这不是你应该推荐给任何人去做的事情，因为这就像尝试在科罗拉多州的阿斯彭（高海拔地区）跑出马拉松世界纪录。那里的氧气不足以支撑你这样做。但如果你最终做到了，那你就是个真正的“硬汉”（Chad）。这非常酷。所以我发现困难本身很有趣。再说一次，我的青少年时期有足够的时间是在互联网上度过的，我知道纯远程也可以建立惊人的文化，比如维基百科、魔兽世界的公会，至少可以拥有卓越的文化。所以我们想：“好，酷。让我们进入一个新的稳定状态。” 那个稳定状态不是把办公室搬到网上，而是把互联网搬进公司，然后我们就说：“出发吧。”

---

### [00:45:00] Lenny Rachitsky

**English:**
This episode is brought to you by Loom. Loom lets you record your screen, your camera, and your voice to share video messages easily. Record a Loom and send it out with just a link to gather feedback, add context, or share an update. So now you can delete that novel-length email that you are writing. Instead, you can record your screen and share your message faster. Loom can help you have fewer meetings and make the meetings that you do have much more productive. Meetings start with everyone on the same page and end early. Problem solved, time saved. We know that everyone is in a one-take wonder when it comes to recording videos. So Loom comes with easy editing and AI features to help you record once and get back to the work that counts. Save time, align your team, stay connected, and get more done with Loom. Now, part of Atlassian, the makers of Jira. Try Loom for free today at loom.com/lenny. That's L-O-O-M.com/lenny. 

I want to talk about this talent stack concept that you've touched on a couple of times that I think so much. But before we get there, I want to go in a different direction, which I think is an interesting foundational element to your ability to be successful in your first principles thinking, which is you getting to the metal, to the core of the problems you're solving by actually spending a lot of time coding. And I actually heard a story about how you all had this huge all-hands summit. You flew everyone in. You're all together. There was a three-day hackathon. And the way it was described is you're sitting at a table with headphones in, coding, just like any IC engineer. No one would've known you're the CEO of this company, the founder of this company. Why is coding and working in the code to you still so important?

**中文翻译:**
本集节目由 Loom 赞助。Loom 让你能轻松录制屏幕、摄像头和声音，分享视频消息。录制一段 Loom，只需一个链接即可发送，用于收集反馈、增加背景信息或分享更新。现在你可以删掉正在写的长篇大论的邮件了，取而代之的是录制屏幕并更快地分享信息。Loom 可以帮你减少会议，并让你参加的会议更高效。会议开始时大家达成共识，结束得更早。问题解决了，时间节省了。我们知道录视频时并非人人都能一次成功，所以 Loom 配备了简单的编辑和 AI 功能，帮你录制一次就能搞定，然后回到重要的工作中。使用 Loom 节省时间、对齐团队、保持联系并完成更多工作。Loom 现在是 Atlassian（Jira 的开发者）的一部分。今天就在 loom.com/lenny 免费试用。

我想谈谈你多次提到的“人才栈”（talent stack）概念，我思考了很多。但在那之前，我想转向另一个方向，我认为这是你能够成功运用第一性原理思考的一个有趣的基石，那就是你通过实际花费大量时间写代码，深入到“底层”（metal），深入到你所解决问题的核心。我听过一个故事，你们举办了一次巨大的全员峰会，把所有人都接了过来。大家聚在一起，有一个为期三天的黑客松。据描述，你戴着耳机坐在一张桌子旁写代码，就像任何一名 IC（独立贡献者）工程师一样。没人会知道你是这家公司的 CEO，是创始人。为什么写代码和深入代码对你来说仍然如此重要？

---

### [00:46:46] Tobi Lütke

**English:**
It's so funny that that's the way the story goes. It's right, but I don't know why that is surprising. That's my happy place, being able to clear out free days of my calendar and being there till midnight with all these remarkable people who join us on journey, just building stuff. It's like, I do my job so that that is the jobs that exist for other people. That's a job I actually want. That's the one I couldn't find because no one did a company for me. But at least back in most days, I think still not really.

(00:47:26):
And so I just love coding. It's one of the greatest, I don't know, hobbies and pursuits. I've done it for a very long time. I came across it very, very early. It fits my brain like a glove. I appreciate so much of the craft behind coding. I am a trained apprentice in... Sorry, I've apprenticed as a programmer in Germany, which has a dual education system that you can do such things. So I've been professionally in companies spending all day. And I really mean it, programming ever since I just turned 16. I think first day was just before I turned 16 when I started my apprenticeship.

(00:48:18):
And so I love it. I have a view on my screen left of you is a cursor right now, which is opened to a Juniper notebook where I'm working on some projection stuff that I'm playing with. I try to sanity-check as much as I can of what I get. I try to find... It's a game for me to find new insights in data. And I just think, I don't know, it was cool. Maybe this is the picture you talk about. There is a picture that someone captured, which is really fun where I'm on my laptop with a bunch of engineers and then Harley, so president, is on stage DJing. This was taken at 1:00 AM or something like this. It's a picture which actually really precious to two of us because it perfectly summarizes our relationship in a way which these happy accidents are wonderful and these long journeys, I've been doing Shopify for 20 years now, so I appreciate these artifacts. But yeah, so...

**中文翻译:**
故事传成这样真有意思。它是真的，但我不知道为什么这会让人惊讶。那是我的“快乐星球”，能把日程表清空几天，和这些加入我们旅程的杰出人士一起待到半夜，只是为了构建一些东西。就像是，我做我的工作，是为了让这种工作能为其他人存在。那才是我真正想要的工作。那是我找不到的工作，因为没有人为我开这样一家公司。至少在过去的大部分日子里是这样，我想现在依然如此。

(00:47:26):
所以我就是热爱编程。它是最伟大的爱好和追求之一。我已经做了很长时间了。我很早很早就接触到了它。它就像手套一样契合我的大脑。我非常欣赏编程背后的手艺。我在德国接受过专业的程序员学徒培训，德国有一种双元制教育体系可以让你做这种事。所以我从刚满 16 岁起就一直在公司里全天候专业地编程。我是认真的，我开始学徒生涯的第一天就在我 16 岁生日前夕。

(00:48:18):
所以我热爱它。在我的屏幕上，就在你左边，现在有一个光标，打开了一个 Jupyter Notebook，我正在处理一些我正在玩的预测模型。我尽可能地对我得到的东西进行“常识检查”（sanity-check）。对我来说，在数据中寻找新见解就像一场游戏。我觉得，我不知道，这很酷。也许这就是你说的照片。有人拍了一张很有趣的照片，我正和一群工程师一起用笔记本电脑工作，而总裁 Harley 正在台上当 DJ。那是凌晨 1 点左右拍的。这张照片对我们两个来说真的很珍贵，因为它完美地总结了我们的关系，这些美丽的意外很美妙，这些漫长的旅程——我已经做 Shopify 20 年了，所以我很珍惜这些记忆。但是，是的，所以……

---

### [00:49:32] Lenny Rachitsky

**English:**
To be clear, the reason this is unusual is, and why someone told me this story, is most CEOs do not do this, don't just sit there and code along with the team. And the reason I thought this story was important is and the reason I think your first principle approach works is you're actually in the engineering details, similar to Elon if you think about it, of just in the weeds doing the thing, understanding how the thing works, not just coming up with ideas out of pontifications. And so I guess is there anything there of just how important it is, if you want to approach thinking from first principles, it is to be really close to the metal, to the bare metal?

**中文翻译:**
需要澄清的是，这件事之所以不寻常，也是为什么有人告诉我这个故事的原因，是因为大多数 CEO 不会这样做，不会坐在那里和团队一起写代码。我认为这个故事很重要的原因，以及我认为你的第一性原理方法奏效的原因，是因为你实际上深入到了工程细节中，如果你仔细想想，这和埃隆很像——深入一线亲自动手，理解事物是如何运作的，而不仅仅是靠空谈想出主意。所以我想问，如果你想运用第一性原理思考，接近“底层”（bare metal）到底有多重要？

---

### [00:50:11] Tobi Lütke

**English:**
Well, yeah. First principles thinking starts from, I think Elon puts it as physics, which I think is a little bit atoms-coded. I think just from the atomic building blocks really is a right starting point. Atomic building blocks are the computers we are using. Computers are our instruments. We use them to create the music that when people appreciate to receive in the form of software. So you've got to understand how they work, at least to work the way I do.

(00:50:48):
Now, is the way I work optimal? Of course not. This is my point about the aesthetics of how to behave, how to work. I probably don't conform to the traditional view of what the most of public companies should be like or even should spend their time, but I think I'm successful because I don't try to conform to anything other than what I've learned works. And so what I learned works is be in as many details as you can. Really, really, really just understand the stuff that we are making decisions about and be willing to don't put too much stake into the sunk cost fallacy. Try to inoculate business or your parts of a company from a sunk cost fallacy as much as possible because that allows you to just see better solutions and so on.

(00:51:45):
And I think what we were doing, if I remember right, is at hack dates is we were working through pros or cons of just merging all of Shopify into one huge monorepo and we are sketching out directory structures and tooling that we would need, and...

**中文翻译:**
嗯，是的。第一性原理思考始于……我想埃隆把它归结为物理学，我觉得这有点偏向“原子”（物理世界）。我认为从“原子级构建块”出发确实是正确的起点。原子级构建块就是我们正在使用的计算机。计算机是我们的乐器。我们用它们来创作音乐，而人们则以软件的形式欣赏这些音乐。所以你必须了解它们是如何工作的，至少要像我这样工作的话必须如此。

(00:50:48):
那么，我的工作方式是最优的吗？当然不是。这就是我关于行为审美、工作审美的观点。我可能不符合传统观念中上市公司 CEO 应有的样子，甚至不符合他们应该如何分配时间的观念。但我认为我之所以成功，是因为我不尝试顺从任何东西，除了我学到的行之有效的方法。我学到的有效方法就是：尽可能深入细节。真的、真的、真的去理解我们正在做决策的那些东西，并且愿意不被“沉没成本谬误”所困扰。尽可能让业务或你负责的公司部分免受沉没成本谬误的影响，因为这能让你看到更好的解决方案等等。

(00:51:45):
如果我没记错的话，我们在黑客日（hack dates）所做的是，权衡将 Shopify 的所有代码合并到一个巨大的单体仓库（monorepo）中的利弊，我们正在勾勒所需的目录结构和工具，以及……

---

### [00:52:00] Tobi Lütke

**English:**
... tooling that we would need and... Again, monorepo, now for companies, it's a very much one of those door A, door B kind of things. It's a very consequential choice that is incorrect to go say yes to at a certain size, and then it becomes very correct in my mind to say yes to, but at that point it's an enormous amount of effort. So, it's a kind of thing that actually is something I'm uniquely positioned to be involved with because it's actually a business strategy thing as well. That's an investment, a very real investment to say, "Hey, let's change the way we are building system. Let's figure out what the best way is."

(00:52:47):
There's going to be change management. There's going to be some people that have very strong opinions on yes or no. And frankly, "Tobi said so.", helps. It also compresses a lot of time, because everyone knows the way I book. Everyone can come to me with better ideas about anything, and if you're right, I will change my mind. But I will hold my opinions very strongly until the point of being convinced that they're not the correct ideas. Maybe that's another aspect of this Tobi Tornado thing you talked about earlier, people do fight.

(00:53:27):
Again, the aesthetics of our times put a lot of stake into consistency. I remember various politicians losing campaigns because they were called flip-floppers at times, which I... Although, I'm more of a Maynard Keynes school of... "When the facts change, I change my opinion. What do you do, sir?" It sounds like a better OS to go by.

**中文翻译:**
……以及我们需要的工具。再说一次，单体仓库（monorepo）对于公司来说，非常像是那种“A 门或 B 门”的选择。这是一个影响深远的抉择，在某个规模下说“是”是错误的，但在我看来，到了另一个阶段说“是”就变得非常正确，但到那时这需要巨大的努力。所以，这类事情实际上是我处于独特位置可以参与的，因为它实际上也是一个业务战略问题。这是一个投资，一个非常真实的投资，去说：“嘿，让我们改变构建系统的方式。让我们找出最好的方式。”

(00:52:47):
这会涉及到变更管理。会有一些人对“是”或“否”持有非常强烈的意见。坦率地说，“托比这么说的”会有所帮助。这也能压缩大量时间，因为大家都知道我的风格。任何人都可以带着关于任何事情的更好主意来找我，如果你是对的，我会改变主意。但在被说服这些想法不正确之前，我会非常强烈地坚持我的观点。也许这就是你之前提到的“托比龙卷风”的另一个方面——人们确实会争论。

(00:53:27):
再说一次，我们时代的审美非常看重“一致性”。我记得有些政治家因为被指责为“立场摇摆者”（flip-floppers）而输掉竞选，而我……虽然我更倾向于梅纳德·凯恩斯那一派：“当事实改变时，我改变我的观点。先生，你呢？” 这听起来像是一个更好的运行系统（OS）。

---

### [00:53:52] Lenny Rachitsky

**English:**
It's awesome, because I'm extracting more of your algorithm of how you think about stuff. A few things you just shared are, ( 1.), you need to be in the details. This is thinking about to be successful as a first principles thinker is (B.), you need to be in the details in your case code. In Elon's case, it's like, build the thing and be at the factory, sleeping on the floor. As you said, he's very Adams based. You're more digitally native. And then also, don't be so reliant on some costs. Like you said in this Tobi Tornado case, "I know you've been working on this project, we're going to kill it, because it's not going to work better if we do that now versus this. Just keep going, because we've been going." And then, coming back to the stuff you've shared previously is, analyze the path that you've been on, that the previous products and solutions have assumed the path dependence of them, and then don't look at what they've overfit potentially, that isn't correct. Love it. Okay. This actually is a good segue to something else that someone that you work with suggested I ask you, Farhan, your head of engineering. I asked him, "What's the best way to get a glimpse into Tobi's mind?" And it's actually along the lines of what you just described, which is, the question is just, what's the best way to disagree with you?

**中文翻译:**
太棒了，因为我正在提取更多关于你如何思考的“算法”。你刚才分享的几点是：(1) 你需要深入细节。要成为一个成功的第一性原理思考者，(B) 你需要深入细节，在你的案例中是代码。在埃隆的案例中，是制造东西、待在工厂、睡在地板上。正如你所说，他非常基于“原子”（物理世界），而你更偏向数字原生。然后，不要太依赖沉没成本。就像你在“托比龙卷风”案例中说的：“我知道你们一直在做这个项目，但我们要杀掉它，因为现在做这个不如做那个。不能仅仅因为我们一直在做就继续做下去。” 然后，回到你之前分享的内容：分析你所走的路径，分析之前的产品和解决方案所假设的路径依赖，然后不要看它们可能过拟合的地方，因为那是不正确的。太棒了。这实际上是一个很好的过渡，引出了你的同事——工程负责人 Farhan 建议我问你的另一个问题。我问他：“了解托比思想的最好方式是什么？” 实际上这和你刚才描述的非常一致，问题就是：反驳你的最好方式是什么？

---

### [00:55:02] Tobi Lütke

**English:**
I think just disagree with me. I immediately love it, honestly. I really crave it. It's very funny. I know how this really surprises people. And I actually appreciate it even more because it requires courage, and frankly, I actually do find that... But it also makes me immediately trust the person more, partly because I, first of all, think they will do what they think is right rather than what is convenient. Agreeing with a group tends to be much more convenient. But more than that actually, that they're courageous enough to do it right then. I think courage is really, really rare. I found a lot more high IQ in industry than courage. I found a lot more maybe even genius than courage. I like that. I wish it wouldn't require that. This is why I try to be very inviting of it.

(00:56:08):
When someone disagrees with me, I tend to immediately stop and say, "Cool, let's figure out why there's disagreement." And it's almost never, I find, in the, "I just feel like we should do this differently." What I'm looking for is offer unstated foundational assumptions. What is our divergence point? Because you might be right. In fact, people often are, when it gets to this point, I found. Sometimes it's an unstated foundational assumption that I hold that is incorrect. People tell me and then I'm so glad we talked about it, because I will stop forever nagging on this thing because now I know we can't do it because of Sarbanes-Oxley or something like this. It's just like, "Well, cool." My mental model of Sarbanes-Oxley, which is regulation for public companies, is not perfect. I have not in-depth studied all the details for it, so I will not consult this in my mind when I am saying, hey, we should solve the task at hand in a certain way. So, this is very good.

(00:57:24):
How to disagree? I really like debate. I will play devil's advocate actively if everyone agrees on something. Again, especially if a proposal is something that feels like I could have predicted would be a proposal before it got into the meeting and there was nothing surprising in it, I will make myself an end boss of a level and just say, "I'm going to say this is just not that good. I think we could do way better." I want people to then argue more in-depth for the veracity of the decisions, and that leads to a form of disagreement. I think all these things end up building trust.

**中文翻译:**
我认为直接反驳我就行。老实说，我立刻就会喜欢上这种感觉。我真的很渴望这个。很有趣，我知道这会让人们感到惊讶。我实际上更欣赏这一点，因为它需要勇气，坦率地说，我确实发现……但这也会让我立刻更加信任这个人，部分原因是我首先认为他们会做他们认为正确的事，而不是方便的事。随大流往往要方便得多。但更重要的是，他们有足够的勇气当场反驳。我认为勇气真的、真的非常罕见。我在行业中发现高智商的人比有勇气的人多得多。我发现天才甚至都比有勇气的人多。我喜欢勇气。我希望反驳不需要勇气，这就是为什么我努力表现得非常欢迎反驳。

(00:56:08):
当有人不同意我的观点时，我倾向于立即停下来并说：“酷，让我们弄清楚为什么会有分歧。” 我发现，分歧几乎从来不是因为“我只是觉得我们应该换个方式做”。我寻找的是那些“未言明的基础假设”。我们的分歧点在哪里？因为你可能是对的。事实上，我发现当谈到这一点时，人们往往是对的。有时是我持有的某个未言明的基础假设是错误的。人们告诉我，然后我很高兴我们谈到了它，因为我将永远停止在这个问题上纠缠，因为现在我知道由于《萨班斯-奥克斯利法案》（Sarbanes-Oxley）或类似法规的原因，我们不能这样做。就像是：“好吧，酷。” 我对《萨班斯-奥克斯利法案》（针对上市公司的监管）的心理模型并不完美。我没有深入研究过它的所有细节，所以当我提议以某种方式解决手头的任务时，我脑子里不会考虑到这一点。所以，这非常好。

(00:57:24):
如何反驳？我非常喜欢辩论。如果每个人都同意某件事，我会主动扮演“魔鬼代言人”（devil's advocate）。再说一次，特别是如果一个提案感觉是我在进会议室之前就能预料到的，而且里面没有任何令人惊讶的东西，我会把自己变成关卡的“最终大 Boss”，然后说：“我要说这还不够好，我认为我们可以做得更好。” 我希望人们随后能更深入地论证决策的真实性，这就会导致某种形式的分歧。我认为所有这些最终都会建立信任。

---

### [00:58:08] Lenny Rachitsky

**English:**
I like that that touches also on this idea of, again, maximizing potential, the potential of the teams, the potential of the employees

**中文翻译:**
我喜欢这一点，因为它再次触及了最大化潜力的想法——团队的潜力，员工的潜力。

---

### [00:58:14] Tobi Lütke

**English:**
Because of course, the really important decisions, we don't talk about. This is the most important thing. Shopify probably makes... What?... millions of decisions every day, like, write this code this way, yes, I'm going to add this unit test, maybe I'm skipping a unit test. Might be the difference between a future production audit. Millions and millions of these tiny decisions. So, you're not hiring engineers primarily or accountants, you're hiring people who make excellent decisions, given their specialization and areas they're overseeing. And given that, decision making as a concept is actually really understudied, I find.

(00:58:59):
I think these are instances where we can just learn to make decision making together. Because I think while a lot of decisions are made independently, we are a product company, we are on a mission, and we want our product to feel like something that a single person made, in the same way how any author tries to write a book that clearly reads that it came from one mind. Because people can see and spot this, if this doesn't happen. You end up with something that looks like a television remote, where there's a Netflix button over here... It's like you can reverse [inaudible 00:59:41] from the remote control. That's important.

(00:59:48):
Using these moments and also bringing decision making inwards to go and say, hey, let's have very efficient opportunities for as many people that can possibly get together, make decisions together, not as a democracy but with clear who needs to convince who. That because otherwise this ends up just taking way too long. Give a opportunity for everyone to change my mind over Glenn's mind, and so on, is an excellent practice, I find. I think this is a more optimal way of going about it.

**中文翻译:**
因为当然，那些真正重要的决定，我们并不讨论。这是最重要的。Shopify 每天可能做出……多少？数百万个决定，比如：以这种方式写代码，是的，我要添加这个单元测试，也许我跳过一个单元测试。这可能是未来生产审计的区别。数以百万计的这些微小决定。所以，你雇佣的不仅仅是工程师或会计师，你雇佣的是在他们的专业领域和负责范围内能做出卓越决策的人。考虑到这一点，我发现“决策”作为一个概念实际上被研究得太少了。

(00:58:59):
我认为在这些情况下，我们可以学习共同决策。因为我认为虽然很多决定是独立做出的，但我们是一家产品公司，我们肩负着使命，我们希望我们的产品感觉像是出自一人之手，就像任何作者都试图写出一本读起来显然来自一个大脑的书一样。因为如果不是这样，人们是能看出来的。你最终会得到一个看起来像电视遥控器的东西，这里有一个 Netflix 按钮……就像你可以从遥控器反推（听不清）。这很重要。

(00:59:48):
利用这些时刻，也将决策过程引入内部，去说：嘿，让我们为尽可能多的人提供非常高效的机会，让他们聚在一起共同决策，不是以民主的方式，而是明确谁需要说服谁。因为否则这最终会耗时太长。给每个人一个机会来改变我的想法，或者改变 Glenn 的想法等等，我发现这是一种极好的实践。我认为这是一种更优的处理方式。

---

### [01:00:22] Lenny Rachitsky

**English:**
Speaking of disagreeing, it reminded me of a story I heard, about the Tobi Tornado actually, the way you operate that. I love it. It ends up being this interesting microcosm of your first principle's way of thinking. The story is, I think you've said at one point that the best way to get people to give you insights is to say something they disagree with on the internet.

**中文翻译:**
说到反驳，这让我想起了一个我听过的故事，实际上是关于“托比龙卷风”的，关于你运作它的方式。我喜欢它。它最终成了你第一性原理思考方式的一个有趣缩影。故事是，我想你曾在某个时刻说过，让人们给你提供见解的最好方式，就是在互联网上说一些他们不同意的话。

---

### [01:00:42] Tobi Lütke

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:00:44] Lenny Rachitsky

**English:**
That's often the way you approach this is, you post in a Slack group, "Hey, I don't think this product is going to work, and here's why." And that ends up creating the most information for you. Is there anything along those lines that might be helpful to share?

**中文翻译:**
这通常是你处理问题的方式：你在 Slack 群组里发帖说：“嘿，我不认为这个产品能行，原因如下。” 这最终为你创造了最多的信息。关于这一点，有什么有用的可以分享吗？

---

### [01:00:56] Tobi Lütke

**English:**
I don't think that's one of my better ways of doing that. I have to be somewhat careful. The people I worked with a lot, I will do this, just because it's funny. But even I can see that that would seriously stress out the interns.

**中文翻译:**
我不认为那是我的好方法之一。我必须稍微小心一点。对于那些经常和我一起工作的人，我会这样做，纯粹是因为有趣。但即使是我也能看出，这会让实习生们压力巨大。

---

### [01:01:16] Lenny Rachitsky

**English:**
You guys have a lot of interns. I think you have 1,000 interns this coming year, is what Farhan shared.

**中文翻译:**
你们有很多实习生。Farhan 分享说，你们明年将有 1000 名实习生。

---

### [01:01:20] Tobi Lütke

**English:**
Yeah, we just started. I was in the office yesterday and it's absolutely full of interns. It's great.

**中文翻译:**
是的，我们刚开始。我昨天在办公室，到处都是实习生。太棒了。

---

### [01:01:25] Lenny Rachitsky

**English:**
Oh, man. Love interns, so much energy. This idea that you shared about building one product, building towards one vision, this actually reminds me of something that came up basically every time I had someone from Shopify on, which is this idea of a 100-year vision that you keep. I don't know of any other company that operates in this way, where the founder has this 100-year vision of where the product needs to go and working backwards from that.

(01:01:48):
Can you just speak to that, of that way of operating, why you find that helpful, how that actually works?

**中文翻译:**
噢，天哪。我喜欢实习生，非常有活力。你分享的关于构建一个产品、朝着一个愿景努力的想法，实际上让我想起了基本上每次我请 Shopify 的人上节目都会提到的事情，那就是你坚持的“百年愿景”。我不知道还有哪家公司是以这种方式运作的——创始人对产品的发展方向有一个百年愿景，并以此进行倒推。

(01:01:48):
你能谈谈那种运作方式吗？为什么你觉得它有帮助？它实际上是如何运作的？

---

### [01:01:54] Tobi Lütke

**English:**
I talk about look in the future and then think backwards a lot. What would we want to have done 20 years ago on this, or 10 or 5 years ago? What's the decision our future selves would want us to make, is useful. I find future casting to be generally extremely valuable. I definitely did not build Shopify to flip. I had lots of opportunities to sell Shopify to various people. I didn't consider it, because it's just too interesting of a journey and I think that's too... If a endpoint [inaudible 01:02:34] all companies is a convergence on a set of four or five people who can afford them, that just creates too much of a monoculture, I think, in thinking.

(01:02:43):
I like that Shopify is different. I think this is good. I think it's a terrible place to work for many, many, many people. It's the best place in the world to work for some people. That's so good. That's what we want, I think. We want more of this. We want people to be able to window-shop for a place where they can be enormously successful, because the place's set of beliefs just fits you like a glove.

(01:03:14):
100 years. We have very long-term plans. 100 years, you can't talk about this software product, but you can talk about the mission itself, whatever things that will survive for 80 years that are left on this particular timeframe. Entrepreneurship is just precious. Shopify exists, basically you make entrepreneurship more common. That is the thing we wanted to cause in the world. We have had, I think, success doing this already, but again, there's no speed limit and no stopping point for this. As I keep saying, the word's unbelievably path dependent. And therefore, if we are part of a path, we can cause it to be more in adherence to the things that we value and would like to see. This is the wonderful thing about company building. They can have lasting impact.

(01:04:16):
We are making decisions based on all the things that we can do. What are the things that will be most long-term valuable for the long-term pursuits we are on, and how can we normalize entrepreneurship? It's a thing that's really important to me, just because people don't spend enough time on it. It's all economics. Our [inaudible 01:04:44] living entirely depends on businesses. We are all part and tag of an environment that is extremely entrepreneurial and actually celebrates entrepreneurship as a courageous act and a glorious act even.

(01:05:02):
But that's not true in most of the world. In fact, most people never encounter anyone who engages in doing that. It's not something people see as one of their options. I want us to make these choices. And I think the long-term focus matters. It's also really powerful for decision making. And I know this is potentially intuitive to most, but also rarely practiced. You've had a lot of people from Stripe on here. Stripe and Shopify have had a very long-term partnership. Stripe and Shopify had potentially the most valuable partnership, or at least one of the top ones in history, of technology, because we were both very small companies and we decided, hey, let's work on an assumption that both of us are going to win our markets, and work together. So, Stripe's [inaudible 01:06:02] for payments and we're allowed a part of Stripe and so on.

(01:06:07):
When you're in a partnership like this, you play basically iterated prisoner's dilemma. Every instance, every turn you can make a choice: coordinate or defect, defecting if the other person collaborates, collaborator effect. If both collaborate, everyone gets a point. If one defects and the other one collaborates, you get a lot of points, all at one moment. Being a good partner in business is like this corporate marshmallow test that companies tend to fail in a very funny way.

(01:06:44):
If you see the videos of kids doing actual actual marshmallow tests, the smart ones actually turn the chair around, look away from the marshmallow, and sit on their hands, and just go vibrating. Because they know it's the right thing to wait for getting two marshmallows in the future, but man, if they just look at a marshmallow, they'll just eat it. Most CEOs, most companies can't even successfully do that and just engage in pulling future profits forward at a discount or even defecting on partnerships that would be much more long-term valuable.

(01:07:16):
If you're talking about long timeframes, like 100 years, there is no question. But clearly, the correct way to play iterated prisoner's dilemma is coordinate for both sides. It's way more valuable [inaudible 01:07:27] doing that over long periods of time than any momentary defection could possibly be convenient at a moment. It's a huge amount of product decisions. When we are deciding roadmap, end up being very influenced by this, because I get pitches for things we should do and why don't we do this kind of change to the system, there's so much money in it, and all these kind of things. I'm like, cool, but almost always come in a form of putting future profits forward at a discount.

(01:08:08):
But we have a long time horizon. Let's not take the discount, let's... Also, you often compromise the entire business after a while because you end up just... Your customers notice if you're going into value extraction. The best companies, I believe, at least from a perspective of a leader, resemble some kind of cockpit, or maybe a room full of dials or levers for monetization. My job is adding as many of these levers as possible to the room, and then not pulling any of them. Because I think we do best if we are on the same side of a table of our customers and we had them become entrepreneurs, which is a mission, and we want to support them to be more successful, which is the business model we are in. We get a very, very small stake of the sales in our monetization system. And therefore, we are incentivized to make everyone as successful as possible.

(01:09:11):
Again, when I get a PowerPoint from investment bankers or so, where they tell me I have enormous pricing power and I could massively change the prices, I'm like, "Yeah, but I'd leave Shopify if that happens to me, so how is that good?" He's just like, "Why?" It just goes like that.

**中文翻译:**
我经常谈论展望未来然后倒推思考。针对这件事，我们希望自己在 20 年前、10 年前或 5 年前做了什么？未来的我们会希望现在的我们做出什么样的决定？这很有用。我发现“未来预测”通常极具价值。我绝对不是为了把 Shopify 卖掉（flip）而创建它的。我有很多机会把 Shopify 卖给各种人，但我没考虑过，因为这段旅程太有趣了，而且我认为……如果所有公司的终点都是汇聚到四五个买得起它们的人手中，那就会在思维上造成太多的“单一文化”。

(01:02:43):
我喜欢 Shopify 的与众不同。我认为这很好。我认为对很多、很多、很多人来说，这里是一个糟糕的工作场所；但对某些人来说，它是世界上最好的工作场所。这太棒了。我认为这就是我们想要的。我们希望有更多这样的地方。我们希望人们能够像逛橱窗一样寻找一个能让他们获得巨大成功的地方，因为那个地方的信念体系就像手套一样契合你。

(01:03:14):
100 年。我们有非常长期的计划。在 100 年的时间里，你不能谈论这个软件产品，但你可以谈论使命本身，谈论在这个特定时间框架内能存活 80 年的那些东西。创业精神是极其珍贵的。Shopify 的存在，基本上是为了让创业变得更加普遍。这就是我们想在世界上引发的事情。我认为我们已经在这方面取得了成功，但同样，这没有速度限制，也没有终点。正如我一直说的，世界是难以置信的路径依赖。因此，如果我们是路径的一部分，我们可以让它更符合我们重视并希望看到的东西。这就是公司建设的美妙之处：它们可以产生持久的影响。

(01:04:16):
我们正在根据我们能做的所有事情做出决策。对于我们正在进行的长期追求，哪些事情最具长期价值？我们如何让创业常态化？这对我来说非常重要，因为人们在这上面花的时间不够。这全是经济学。我们的生活完全取决于企业。我们都是一个极具创业精神的环境的一部分，这个环境实际上将创业颂扬为一种勇敢的行为，甚至是一种光荣的行为。

(01:05:02):
但在世界大部分地区并非如此。事实上，大多数人从未遇到过从事创业的人。这不是人们认为的选择之一。我希望我们做出这些选择。我认为长期关注很重要。它对决策也非常强大。我知道这对大多数人来说可能是直觉，但很少付诸实践。你这里请过很多 Stripe 的人。Stripe 和 Shopify 有着非常长期的合作伙伴关系。Stripe 和 Shopify 拥有科技史上可能最有价值的合作伙伴关系之一，或者至少是顶级之一，因为我们当时都是非常小的公司，我们决定：嘿，让我们基于“我们双方都会赢得各自市场”的假设来共同努力。所以，Stripe 负责支付，我们是 Stripe 的一部分，等等。

(01:06:07):
当你处于这样的合作关系中时，你基本上是在玩“迭代囚徒困境”。在每一个实例、每一个回合中，你都可以做出选择：协作或背叛。如果对方协作而你背叛，或者双方都协作。如果双方都协作，每个人都得一分。如果一个人背叛而另一个人协作，背叛者会在那一瞬间得到很多分。在商业中做一个好的合作伙伴就像是“企业版棉花糖测试”，公司往往会以一种非常滑稽的方式失败。

(01:06:44):
如果你看孩子们做棉花糖测试的视频，聪明的孩子实际上会转过椅子，不去看棉花糖，坐在自己的手上，身体微微颤抖。因为他们知道为了将来得到两个棉花糖而等待是正确的，但天哪，如果他们盯着棉花糖看，他们就会把它吃掉。大多数 CEO、大多数公司甚至无法成功做到这一点，他们只是忙于以折扣价预支未来的利润，甚至背叛那些更具长期价值的合作伙伴关系。

(01:07:16):
如果你谈论的是 100 年这样的长周期，那就毫无疑问了。显然，玩迭代囚徒困境的正确方式是双方协作。长期协作的价值远高于任何一时的背叛所能带来的便利。这影响了大量的产品决策。当我们决定路线图时，会深受此影响。因为我会收到关于我们应该做某事的提案，比如为什么我们不对系统做这种改变，里面有很多钱，诸如此类的。我会说，酷，但这几乎总是以折扣价预支未来利润的形式出现。

(01:08:08):
但我们有很长的时间跨度。让我们不要打折，让我们……而且，你经常会在一段时间后损害整个业务，因为你最终只是……你的客户会注意到你是否进入了“价值榨取”模式。我相信，最好的公司（至少从领导者的角度来看）类似于某种驾驶舱，或者一个装满了货币化刻度盘或杠杆的房间。我的工作是在房间里增加尽可能多的杠杆，然后一个也不拉。因为我认为，如果我们和客户站在桌子的同一边，帮助他们成为企业家（这是使命），并支持他们变得更成功（这是我们的商业模式），我们就能做得最好。在我们的货币化系统中，我们只从销售额中提取极小的一部分。因此，我们有动力让每个人都尽可能成功。

(01:09:11):
再说一次，当我收到投资银行家之类的 PPT，他们告诉我我拥有巨大的定价权，可以大规模改变价格时，我会说：“是的，但如果那样发生在我身上，我会离开 Shopify，所以那有什么好的？” 他只会问：“为什么？” 事情就是这样。

---

### [01:09:30] Lenny Rachitsky

**English:**
There's a quote that you wrote somewhere that, to me, identifies this point so succinctly, "On a long enough timeline, playing positive-sum games with your customers is the ultimate growth hack." Yeah, beautiful.

**中文翻译:**
你在某个地方写过一句话，对我来说，它非常简洁地说明了这一点：“在足够长的时间线上，与你的客户玩正和博弈（positive-sum games）是终极的增长黑客手段。” 是的，太美妙了。

---

### [01:09:46] Tobi Lütke

**English:**
I think that's pretty piffy and it's also just... Try to argue with it.

**中文翻译:**
我认为这很精辟，而且……试着反驳它看看。

---

### [01:09:53] Lenny Rachitsky

**English:**
That's true.

**中文翻译:**
确实。

---

### [01:09:54] Tobi Lütke

**English:**
Positive-sum games have incredible returns, especially in the worlds of software, where you can experience exponentials very easily. I see company building as... I wish there would be better analogy than chess, because chess is a game of perfect information, which is totally incorrect. But one thing which I like about chess as an analogy for business is that it basically is two games, that you have to be good at at both. There's a positional game that you learn: Develop your pieces, gain influence by your pieces over the board. That's really, really important. And then there's tactics, which you learn tactic training. You go get a puzzle trainer and you drill tactics and you learn the intuition to sports tactics, sense them. Both of them are actually super independent of each other.

(01:10:53):
The business world only talks about tactics. It only talks about the conversion of we did this thing. We did an A/B test and we changed the color of blue, and conversion red went up. We lionize the easy hack. I don't think that's important, honestly. You need to be good enough at tactics to not go out of business. You can't get margin code, sure. But the sum total of all the value of a potential tactics that you could employ stays with you if you are actually are doing the positional game.

(01:11:36):
The positional game is like, what is the territory on the map that you are taking? What role do you play? How much trust do you have of merchants? Do merchants want more from you or less? Are you the kind of thing they're trying to optimize out of their software spend, or the one that they ask to subsume all other software spend? Do they rely on you? Are you part of a team, or are you used as a tool in the toolbox, usually forgotten, sometimes coming out when certain task is being done? What does your product cover? What industries are you addressing? And so on, so on, so on. This is the positional game. How well do pieces fit together? Do people like relying even deeper on you?

(01:12:25):
If you do that well, the tactics are yours and you can hire a lot of people who are extraordinarily good at spotting tactics and using them. But if you do it too much, you end up extracting through tactics the entirety of the value that you have created and that is yours to take through a positional game. And if you do that, you have nothing left in the tank. That's for companies that we all see, that just got to a point and then just fade. Those are the companies that got tacticked out of their position.

**中文翻译:**
正和博弈具有惊人的回报，特别是在软件世界中，你可以非常容易地体验到指数级增长。我把公司建设看作……我希望有比国际象棋更好的类比，因为国际象棋是一个完全信息博弈，这（对商业来说）是完全不准确的。但国际象棋作为商业类比有一点我喜欢，那就是它基本上是两场游戏，你必须精通这两场。一场是你学习的“布局博弈”（positional game）：开发你的棋子，通过棋子在棋盘上获得影响力。这非常、非常重要。另一场是“战术”（tactics），你通过战术训练学习。你去用解谜训练器钻研战术，学习感知战术的直觉。这两者实际上是高度独立的。

(01:10:53):
商业世界只谈论战术。它只谈论“我们做了这件事”的转化率。我们做了一个 A/B 测试，改变了蓝色的色调，转化率就上升了。我们崇拜简单的“黑客手段”。老实说，我不认为那很重要。你需要在战术上做得足够好，以至于不倒闭。当然，你不能被强行平仓（margin call）。但是，如果你真的在玩布局博弈，那么你可能采用的所有潜在战术的总价值都会留在你身边。

(01:11:36):
布局博弈就像是：你在地图上占据了什么领土？你扮演什么角色？商户对你有多少信任？商户是想要你提供更多还是更少？你是他们试图从软件支出中优化掉的东西，还是他们要求合并所有其他软件支出的那个平台？他们依赖你吗？你是团队的一员，还是只是工具箱里的一个工具（通常被遗忘，只有在执行特定任务时才拿出来）？你的产品涵盖了什么？你针对的是哪些行业？等等。这就是布局博弈。棋子之间的契合度如何？人们喜欢更深地依赖你吗？

(01:12:25):
如果你做得好，战术就尽在掌握，你可以雇佣很多极其擅长发现和使用战术的人。但如果你做得太过火，你最终会通过战术榨取掉你所创造的全部价值，而这些价值本该是通过布局博弈获得的。如果你那样做，你的油箱里就什么都不剩了。这就是我们都见过的那些公司，它们发展到一定程度就消失了。那些就是被“战术”挤出了原有位置的公司。

---

### [01:13:01] Lenny Rachitsky

**English:**
The skill, obviously, is finding the balance between these two things of short-term, not get margin calls, as you described, but also think ahead.

(01:13:09):
Is there any kind of heuristic for founders listening to this who are like, "How do I do this? How much should I be thinking about the future versus now?", I guess? How do you try to create this pie chart of driving goals immediately and show investors we're killing it, while also thinking ahead?

**中文翻译:**
显然，技能在于在这两件事之间找到平衡：短期内不被“强行平仓”（如你所述），同时也要展望未来。

(01:13:09):
对于正在听节目的创始人来说，有什么启发式的方法吗？比如“我该怎么做？我应该花多少精力思考未来，花多少精力关注现在？” 你如何尝试创建这个“饼图”——既要立即推动目标并向投资者展示我们表现优异，又要展望未来？

---

### [01:13:09] Tobi Lütke

**English:**
Is there a good heuristic? Objective number one is: Don't die. Again, in the end, for companies that become historic companies are the ones which did not die. It also sounds very basic, but actually it's more actionable than it might seem. Past that point, I would argue: Just focus on the positional game. I think this is where a bit of a discrepancy of the founder and the rest of the company sometimes lies. I think the founders create finite, winnable games for people, that are very much serving the infinite game of developing, that the mission implies, the quality of position on the board.

(01:14:14):
By the way, it's an infinite board. Just picture the chess board as the initial terrain, but there's, I don't know, fog on the board and it's a terrain that's much larger that you will explore over time. I think that's the most prettiest way of mentally thinking about the experience of building a company. It's an exploration and a collaborative inquiry into a question that is implied by the mission. And you will get to explore how correct your mission is and how good your decision making is along the way. And you get to learn a lot, and this is why I think it's a valuable thing to do.

(01:14:55):
But they often, the founders, and the mission of a company are in alignment, but they are, again, non-quantifiable things. They are pursuits. Maybe as time horizons that go past, all of our time horizons of our careers, therefore that makes it hard for people to care deeply yet. But they do care about the instances, the games along the way, the [inaudible 01:15:24] that have to be done to explore a part of a map, the tactics that have to be executed.

**中文翻译:**
有什么好的启发式方法吗？第一目标是：别死掉。再说一次，最终成为历史性公司的，都是那些没死掉的公司。这听起来很基础，但实际上它比看起来更有操作性。过了那一点，我会认为：只需专注于布局博弈。我认为这就是创始人与公司其他成员之间有时存在分歧的地方。我认为创始人为员工创造了有限的、可获胜的游戏，而这些游戏在很大程度上是为使命所隐含的“无限游戏”服务的，即提升在棋盘上的布局质量。

(01:14:14):
顺便说一下，这是一个无限的棋盘。把国际象棋棋盘想象成初始地形，但棋盘上有迷雾，而且地形比你想象的要大得多，你会随着时间的推移去探索。我认为这是思考公司建设体验最美妙的方式：它是一场探索，是对使命所隐含问题的协作探究。在这个过程中，你将探索你的使命有多正确，以及你的决策有多明智。你会学到很多东西，这就是为什么我认为这是一件有价值的事情。

(01:14:55):
创始人通常与公司的使命保持一致，但这些又是不可量化的东西。它们是追求。也许时间跨度超过了我们所有人的职业生涯，因此人们很难立即产生深刻的共鸣。但他们确实关心具体的实例，关心沿途的游戏，关心为了探索地图的一部分而必须完成的任务，关心必须执行的战术。

---

### [01:15:29] Lenny Rachitsky

**English:**
I'm not going to take us here, but I know you're a big fan of this book, Finite and Infinite Games. I actually had it once at a book club and it blew my mind open. I'm going to link to it. People should check it out. You've talked about this on another podcast. I'm not going to [inaudible 01:15:40].

**中文翻译:**
我不打算深入讨论这个，但我知道你是《有限与无限的游戏》（Finite and Infinite Games）这本书的忠实粉丝。我曾在读书会上读过它，它彻底开启了我的思维。我会放个链接，大家应该去看看。你在其他播客上也谈过这个。

---

### [01:15:40] Tobi Lütke

**English:**
Yeah, it's a lovely book. James Carse did an incredible, underappreciated... I think they essentially wrote one of the best business books. They is trying to write a hard philosophy book. I don't know if it works for its intended purpose, but I think there's more value in what he actually accomplished. Maybe, sadly, it may be that he didn't know before he died, which would be very sad.

**中文翻译:**
是的，这是一本很棒的书。詹姆斯·卡斯（James Carse）做了一件不可思议且被低估的事情……我认为他本质上写出了最好的商业书之一。他原本是想写一本深奥的哲学书。我不知道它是否达到了预期的目的，但我认为他实际成就的价值更高。遗憾的是，也许他在去世前都不知道这一点，那会非常令人难过。

---

### [01:16:08] Lenny Rachitsky

**English:**
It's a little hard to read for people...

**中文翻译:**
对人们来说读起来有点难……

---

### [01:16:09] Tobi Lütke

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:16:09] Lenny Rachitsky

**English:**
... so just stick with it and just try to wrap your head around what he's trying to say, is my advice.

**中文翻译:**
……所以我的建议是坚持读下去，努力理解他想表达的意思。

---

### [01:16:14] Tobi Lütke

**English:**
I think reading... I don't know how many it is, but... the first couple of chapters really helps you get your arms around the story, his insight. The rest of the book are examples of his ideas applied. My takeaway from reading his examples is that he did not fully appreciate the insight of his own idea. It just ends up being very locally limited and very narrow-focused. It's a much grander idea than I think he really... This is why I say I don't think he fully appreciated quality of his own idea, which...

**中文翻译:**
我认为读……我不知道具体多少，但前几章真的能帮你理解这个故事和他的洞见。书的其余部分是他思想的应用实例。我读那些例子的感受是，他并没有完全领会自己思想的深刻内涵。它最终变得非常局限且关注点狭窄。这是一个比他真正意识到的要宏大得多的想法……这就是为什么我说我不认为他完全理解了自己想法的质量。

---

### [01:16:58] Lenny Rachitsky

**English:**
I think we need a Tobi version of this book, with a foreword, and...

**中文翻译:**
我认为我们需要一个“托比版”的这本书，配上序言，还有……

---

### [01:17:02] Tobi Lütke

**English:**
I heard Simon Sinek... wrote a book of a similar title. I've actually never gotten around to read it, but I think he would be very good at interpreting this if that's what he did.

**中文翻译:**
我听说西蒙·斯涅克（Simon Sinek）写了一本题目类似的书。我还没来得及读，但如果那是他写的，我想他会非常擅长解读这个。

---

### [01:17:11] Lenny Rachitsky

**English:**
That's what it sounds like. I feel like his book is that book, written in a different way.

(01:17:15):
I want to come back to something you talked about, which is focusing on entrepreneurship and the merchants that you all work with. To me, this is another example of maximizing human potential. The way I think about this, people always talk about Y Combinator and Stanford and all these places that create all these companies and founders. If you think about it, Shopify does this orders of magnitude beyond, and I don't think you guys get enough credit for that, the amount of businesses you create, the amount of lives you change.

**中文翻译:**
听起来确实是那样。我觉得他的书就是那本书的另一种写法。

(01:17:15):
我想回到你谈到的一件事，即关注创业精神和你们合作的商户。对我来说，这是最大化人类潜力的另一个例子。我的想法是，人们总是在谈论 Y Combinator、斯坦福以及所有这些创造公司和创始人的地方。但如果你仔细想想，Shopify 做到的规模比它们大几个数量级，我认为你们在这方面没有得到足够的认可——你们创造的企业数量，你们改变的生活数量。

---

### [01:17:43] Tobi Lütke

**English:**
That's because we don't want the credit. That's the point.

**中文翻译:**
那是因为我们不想要那份功劳。这就是重点。

---

### [01:17:46] Lenny Rachitsky

**English:**
Is there a platform?

**中文翻译:**
这是一个平台吗？

---

### [01:17:47] Tobi Lütke

**English:**
We don't want the credit.

**中文翻译:**
我们不想要这份功劳。

---

### [01:17:47] Lenny Rachitsky

**English:**
No.

**中文翻译:**
不。

---

### [01:17:48] Tobi Lütke

**English:**
I mean, maybe if you wanted it, you could also not get it, but we don't need to explore that because we actually, literally don't want the credit. Shopify is a company that pushes from behind. We don't want to be written into the story. We want to just...

(01:18:00):
... want to be written into the story, we want to just kind of have you do your thing. There's just too much grandeur in wanting to front it all. This is also what caused us to go and help people build their own things rather than start with a marketplace that everyone gets to lease a little component of at prices that corresponds to magically exactly your margin, as this usually goes in marketplaces. And so yeah, I think we don't want it. I'm proud of it, but that's intrinsic. I don't need very extrinsic appreciation for it, I suppose. There's millions, millions and millions of people that use Shopify daily and that represents the business and it causes major amount of employment around the world actually, definitely in North America specifically and Europe. And so I think that's really gratifying. I'm sure there's a way of saying that many of us businesses might actually have existed without Shopify.

(01:19:18):
I also think you can make a case that a good number exists because of Shopify, because what we've observed is that this was actually, it's my favorite thing in the entire Shopify journey that we sort of rigorously determined, which is that because I really, really, really prioritize good UX, legible interfaces. You can tame enormous complexity with great UX in a way that makes sense to people. I think this is actually almost a moral obligation to do for software because when software goes bad, it makes people feel dumb and machines do not get to negatively influence people in my mind. That is the inversion of the priority of the hierarchy of how machines are tools wielded by people to be more powerful at the things that they're already great at than they might imagine. That's when this all needs to fit together, but beyond the moral point, which is 10 years, and you could definitely take the other side of what we have determined is that every single time we make a complex thing simpler. It is actually that more businesses will exist on a platform.

(01:20:38):
So I think this is intuitive or at least directional, but sometimes people are not like, "Well, don't you just need to have all these features?" This is the RFP view of a world of software, right? "Don't you need to just have all the features then people can implement their plan?" Well, no. Think about the mental state and entrepreneurship entrepreneurs, they are, I mean especially if you're first entrepreneurs, they're unsophisticated. They don't know what to do. They're kind of scared. By the way, engaging in building something again is an act of pure courage and usually one which is very hard to hide from others. The people around you will know that you're doing this thing. Ask any entrepreneur. The amount of people who tell you to not do this is actually stunning. People do not want people to just step out of a box that exists that they sort of explain to themselves around them and have a chance of reaching higher because that would sort of invalidate their own life story in some meaningful way.

(01:21:38):
So there's a situation where people are telling you to quit potentially, you don't have a lot of money presumably, you're asking yourself, are you even doing the right thing? Hopefully there's some elements of encouragement. Hopefully there's a passion. Hopefully you're trying to create a thing. Then comes to a situation that stuns you in some way, somewhere where suddenly the software starts talking about APIs where this is something you've never encountered in your life before or that just the option that you think it should have on the text configuration screen doesn't make sense given what we know about local taxes and so on. Here's the thing that happens. So the beautiful thing with Shopify is there's basically no tax configuration screen. It's just correct. The amazing thing about software is we can actually just overtake this piece of complexity.

(01:22:53):
We know what the taxes are everywhere and we are just doing it for you. You don't have to think about taxes. In this case we have someone encountered something that stunned them, that stopped them in their tracks. On the wrong day, what that means, it's like they are going to close a browser and they say, "You know what? Fuck it. I'm not cut out for this." Or, "This piece of software I use sucks and it's too dumb for understanding the thing I have in my head," or something else. Everyone has a different rendering of the same thing, but just like progress stops. It is not just the businesses that shouldn't exist anyway that stop in this way. In fact, it's actually, and this is again what the data says, so many businesses get very close to this point many, many times. I can tell you Shopify did many times and I have more tools on entrepreneurial journey than most. I'm a computer programmer and I love those things. You tell me I can spend 14 hours programming for the next couple of years. I'm like, "Holy shit, let's go."

(01:24:01):
Most people aren't like that. So I've had unfair advantages that allowed me to overcome very technical climbs on this learning curve, but I know that's like most people can't have these advantages and therefore will churn out of a test. And so in other words, lowering complexity, making good UX, creating software that just autopilots taxes or payments or any of these kinds of things, fraud, actually causes more entrepreneurship. That is the best thing, the best answer to the most important question of my life that I've encountered because up to this point it was an intuition that doing the Shopify thing would be valuable in absolute sense, in a hundred-year sense. Afterwards I knew, right? And so that also just means now seeing things that are overly complex or shouldn't even be there, it's just physically painful because I know, it's like all these business that are trying to get somewhere and could exist and could now employ people and delight customers just died along the way because of something we did wrong or poorly and so on. And so this is a great source of energy for me to keep going.

**中文翻译:**
我的意思是，也许即使你想要这份功劳，你也得不到，但我们不需要探讨那个，因为我们实际上真的不想要这份功劳。Shopify 是一家从背后推动的公司。我们不想被写进故事里。我们只想……

(01:18:00):
……不想被写进故事，我们只想让你做你自己的事。想要站在台前太过于虚荣了。这也是为什么我们选择去帮助人们建立自己的事业，而不是建立一个每个人都只能租赁一小部分的“市场”（marketplace），而且价格还被精准地设定在刚好榨干你利润的水平——这通常是市场平台的做法。所以是的，我认为我们不想要那份功劳。我为此感到自豪，但那是内在的。我想我不需要太多外在的赞赏。每天有数以百万计的人使用 Shopify，这代表了业务，它实际上在世界范围内创造了大量的就业机会，特别是在北美和欧洲。所以我认为这真的很令人欣慰。当然，也可以说很多企业即使没有 Shopify 也会存在。

(01:19:18):
但我也认为，你可以论证很大一部分企业是因为 Shopify 才存在的。因为我们观察到——这是我在整个 Shopify 旅程中最喜欢的事情，也是我们严格确定的——因为我非常、非常、非常看重良好的用户体验（UX）和清晰的界面。你可以通过出色的 UX 以一种人们能理解的方式驯服巨大的复杂性。我认为这实际上几乎是软件的一种道德义务，因为当软件变得糟糕时，它会让人们觉得自己很笨。在我的观念里，机器不应该对人产生负面影响。机器应该是人使用的工具，让人在他们已经擅长的事情上变得比想象中更强大。这就是一切需要契合的地方。除了道德层面，我们确定的另一件事是：每当我们把一件复杂的事情变简单，平台上就会产生更多的企业。

(01:20:38):
我认为这是直观的，或者至少是方向性的。但有时人们会问：“难道你不需要拥有所有这些功能吗？” 这是软件世界的“RFP 视角”，对吧？“难道你不需要拥有所有功能，然后人们才能实施他们的计划吗？” 不。想想创业者的心理状态，特别是第一次创业的人，他们并不老练。他们不知道该做什么。他们有点害怕。顺便说一下，投身于构建某样东西是一种纯粹的勇气行为，而且通常很难向他人隐瞒。你周围的人会知道你在做这件事。问问任何创业者，告诉他们不要这样做的人多得惊人。人们不希望看到有人跳出既有的框框，去尝试达到更高的高度，因为那会在某种意义上否定他们自己的生活故事。

(01:21:38):
所以你面临的情况是：可能有人劝你放弃，你可能没多少钱，你在问自己：我做的事情对吗？希望能有一些鼓励，希望能有激情，希望能创造一个东西。然后遇到了一些让你不知所措的情况，比如软件突然开始谈论 API（你这辈子都没接触过），或者你认为文本配置屏幕上应该有的选项在当地税收逻辑下讲不通。这就是发生的事情。Shopify 的美妙之处在于，基本上没有“税收配置屏幕”。它就是正确的。软件的神奇之处在于，我们实际上可以接管这部分复杂性。

(01:22:53):
我们知道各地的税率，我们直接为你处理好。你不需要思考税收。在这种情况下，如果有人遇到了让他们不知所措、让他们停滞不前的事情，在糟糕的一天，这意味着他们会关掉浏览器说：“去他的，我不适合干这个。” 或者“我用的这个软件太烂了，它太笨了，理解不了我脑子里的想法。” 每个人对同一件事的表达不同，但结果就是：进步停止了。不仅仅是那些本来就不该存在的企业会这样停止。事实上，数据告诉我们，很多企业曾多次非常接近这个放弃点。我可以告诉你，Shopify 也经历过很多次，而且我在创业旅程中拥有的工具比大多数人都多。我是一个程序员，我热爱这些东西。你告诉我未来几年我可以每天花 14 小时编程，我会说：“太棒了，走起。”

(01:24:01):
大多数人不是那样的。所以我拥有不公平的优势，让我能克服学习曲线上非常陡峭的技术难关。但我知道大多数人没有这些优势，因此会在测试中流失。换句话说，降低复杂性、打造良好的 UX、创建能自动处理税收、支付、欺诈等事务的软件，实际上促进了更多的创业。这是我遇到的生命中最重要问题的最佳答案。因为在此之前，这只是一种直觉，认为做 Shopify 在绝对意义上、在百年意义上是有价值的。后来我知道了，它是真的。所以，现在看到那些过于复杂或根本不该存在的东西，我感到生理上的痛苦。因为我知道，所有这些试图有所成就、本可以存在、本可以雇佣员工并取悦客户的企业，仅仅因为我们做得不好或做错了，就在半路夭折了。这是我继续前进的巨大能量来源。

---

### [01:25:26] Lenny Rachitsky

**English:**
I feel that, I feel that pain of the idea of anytime a button's broken or it's not as... the button's wrong color and more people would be converting means that you're not creating as many businesses, many entrepreneurs. The feeling you described of being scared to launch something, I exactly felt that when I started the newsletter. And my solution to that as I launched it is, "I'm just launching this as an experiment. We'll see where it goes, just don't worry about it. I might blog once in a while." And that really helped just lowering the stakes and I could see how just things like that and advice that can help someone get over that hump.

**中文翻译:**
我能感受到那种痛苦。每当一个按钮坏了，或者颜色不对，导致转化率下降，就意味着你没能创造出那么多的企业和创业者。你描述的那种害怕发布某样东西的感觉，我在开始写这份时事通讯时也深有体会。我发布时的解决方案是：“我只是把它作为一个实验来发布。看看它会走向何方，别担心。我可能只是偶尔写写博客。” 这真的很有帮助，降低了心理预期。我能看到这类事情和建议是如何帮助某人度过难关的。

---

### [01:26:01] Tobi Lütke

**English:**
Yes, and I think this is an under explored thing in the word of UX. Random example, I was absolutely delighted by, maybe TikTok has the same thing, I don't know, but I was posting a video to Instagram and it allowed me to run a try run of the reel. It just seems like a new feature and just saying it shows it to a couple hundred people out of network and if they like it then it's going to post to my profile. I'm like, "I don't need that." But I thought that was one of the more... I honestly just closed Instagram and was like, "Holy shit, this is probably one of the most profound insightful pieces of software I've encountered. And as a connoisseur of good ideas, I've never had this as a valuable thing." It feels like a step function upgrade to the traditional A-B test as a concept because it's so understandable and I'm like, "What else in the world should have try runs that run out of network?" Basically everything, isn't it?

(01:27:03):
This is an amazing thing. Like I said, the rarest thing in the world, it's not even creativity or genius, it's courage. So let's lower the net amount of courage needed. Honestly, that's one of those things you can probably run an entire career or reinvent an industry on. These things unfurl into incredible amounts of value if you really pursue them and come at them from first principles rather than how can I do the things I want to do anyway slightly better because of insight. That's good and people should always do it, but not usually where most of the value ends up becoming, like manifests when a new idea comes around. So I talk radically about an Instagram feature. That's a weird thing to do, but I was actually just really to delighted because again, it just came up a few days ago.

**中文翻译:**
是的，我认为这是 UX 领域一个尚未被充分探索的东西。举个随机的例子，我感到非常惊喜——也许 TikTok 也有类似的功能，我不知道——我在 Instagram 上发布视频时，它允许我运行一个 Reel 的“试运行”（try run）。这似乎是一个新功能，它会把视频展示给网络之外的几百个人，如果他们喜欢，它才会发布到我的个人主页上。我想：“我不需要这个。” 但我觉得这是最……老实说，我关掉 Instagram 后心想：“天哪，这可能是我见过的最深刻、最有见地的软件功能之一。作为一个好主意的鉴赏家，我以前从未意识到这有多大价值。” 它感觉像是对传统 A/B 测试概念的一次阶跃式升级，因为它非常易于理解。我在想：“世界上还有什么东西应该有这种‘网络外试运行’？” 基本上所有东西都应该有，不是吗？

(01:27:03):
这是一件了不起的事情。就像我说的，世界上最稀缺的不是创意或天才，而是勇气。所以，让我们降低所需的“净勇气量”。老实说，这可能是你可以投入整个职业生涯或重塑一个行业的事情。如果你真的追求这些东西，并从第一性原理出发，而不是仅仅想“我如何能因为一点洞察力把我本来就想做的事情做得稍微好一点”，它们就会释放出巨大的价值。后者也很好，人们应该一直这样做，但当一个新想法出现时，大部分价值通常不会在那里体现。所以我大谈特谈一个 Instagram 的功能，这有点奇怪，但我真的很开心，因为它几天前才刚刚出现。

---

### [01:27:54] Lenny Rachitsky

**English:**
I love this thread of courage. The example you gave reminds me also of I feel like going on a dating app at a different city for the first time is another example of this where it's a dry run, nobody knows you.

**中文翻译:**
我喜欢关于“勇气”的这个思路。你举的例子也让我想起，第一次去另一个城市使用约会软件也是一个例子——那是一次“试运行”，没人认识你。

---

### [01:28:06] Tobi Lütke

**English:**
But even then, shouldn't there be like, "Hey, post my profile to a different city for telling me if it's any good."

**中文翻译:**
但即便如此，难道不应该有一个功能说：“嘿，把我的资料发到另一个城市，告诉我它好不好用”吗？

---

### [01:28:14] Lenny Rachitsky

**English:**
SO people like it.

**中文翻译:**
这样人们就会喜欢它。

---

### [01:28:14] Tobi Lütke

**English:**
I mean I've never dated basically so I mean at least not in the last 25 years.

**中文翻译:**
我的意思是，我基本上没约过会，至少在过去的 25 年里没有。

---

### [01:28:19] Lenny Rachitsky

**English:**
Yeah, of the podcast.

**中文翻译:**
是的，在播客里说这个。

---

### [01:28:20] Tobi Lütke

**English:**
So I'm pre swipe left and right dating, so my conception is very low of this. Maybe I should look more at dating apps. I'm pretty sure there's some amazing UX in most things.

**中文翻译:**
所以我是在“左滑右滑”约会时代之前的人，所以我对这个概念很模糊。也许我应该多看看约会软件。我敢肯定大多数东西里都有一些惊人的 UX。

---

### [01:28:34] Lenny Rachitsky

**English:**
I imagine. I feel like dating is going offline more and more. I'm feeling like that's what people are trying to do. They're tired of the swipe, but anyway, going to go in that direction. Maybe a couple more questions while I have you here. One is this idea of the talent stack. You've mentioned this concept before and this is the term that I've seen you describe it as of this idea of the power of focusing on your unique talents and curiosity and that leading you to the biggest opportunities, especially early in your career. Can you just talk about what your insight there.

**中文翻译:**
我想也是。我觉得约会正越来越多地转向线下。我感觉人们正试图这样做，他们厌倦了滑动。但无论如何，不往那个方向说了。趁你还在，再问几个问题。一个是“人才栈”（talent stack）的想法。你以前提到过这个概念，我看到你用这个词来描述：专注于你独特的天赋和好奇心，并以此引导你走向最大的机会，尤其是在职业生涯早期。你能谈谈你在这方面的见解吗？

---

### [01:29:04] Tobi Lütke

**English:**
Yeah, again, I only lived one life, so I can't Monte Carlo all the decisions I make and just figure out which ones ended up being load baring, right? I'm at this point pretty amused by the following thing which keeps happening. But I am getting curious about some absolutely random thing and it really is fairly far-flung stuff and like magic it becomes the way that ends up allowing me to make a very important choice a year later. It's ends up being a better analogy that I've learned or a different way to see something or another idea that I found being represented in this area of expertise that is actually just again, another repackaging of another foundational idea, which allows me to go and look for more examples.

(01:29:57):
And it's just funny this way. So even early in career just I followed my curiosity. I love programming and I love computers and I loved the internet when it came along and I just like, "Cool, I'm going to find a task that I find valuable," which I was always engaged in retail and I have a lot to say about how retail should be brought by the internet to people. But this is a beautiful intersection of all the things that I find interesting. And then on top of it, I found Ruby, which I loved as a technology and then just now I was highly motivated to tinker, explore a space that was clearly emerging but just felt very obviously of value in the future.

(01:30:44):
But I didn't do it because I was following money. I did it because I like learning by doing stuff and I like tinkering the things and so this was a way of financing my tinkering by selling snowboards and then it led to other things. And I've kind of been doing that thing all along. It's great fun, great fun for me. I don't know how much of a advice that is, but maybe a proof point that can work really well. I sometimes worry though that things like this end up being a little bit like all you need to do is buy a lottery ticket, set for lottery ticket winner, right? So it's, who knows?

**中文翻译:**
是的，再说一次，我只活了一辈子，所以我不能对我做的所有决定进行蒙特卡洛模拟（Monte Carlo），看看哪些决定最终成了“承重墙”，对吧？到目前为止，我对不断发生的以下事情感到非常有趣：我对一些完全随机的事情产生好奇，真的是一些非常遥远的东西，然后像变魔术一样，它成了让我一年后做出非常重要选择的关键。它最终成了我学到的一个更好的类比，或者一种看待事物的不同方式，或者我在这个专业领域发现的另一个想法，而它实际上只是另一个基础想法的重新包装，这让我可以去寻找更多的例子。

(01:29:57):
这很有趣。所以即使在职业生涯早期，我也只是跟随我的好奇心。我热爱编程，热爱计算机，当互联网出现时我也热爱它，我只是想：“酷，我要找一个我认为有价值的任务。” 我一直从事零售业，对于互联网应该如何将零售带给人们，我有很多话要说。这是我感兴趣的所有事物的完美交集。除此之外，我发现了 Ruby，我热爱这项技术，当时我非常有动力去钻研、探索一个显然正在兴起、但在未来显然极具价值的领域。

(01:30:44):
但我这样做不是因为追逐金钱。我这样做是因为我喜欢通过实践来学习，喜欢钻研事物。所以卖滑雪板成了资助我钻研的一种方式，然后它引向了其他事情。我一直都在做这样的事情。这很有趣，对我来说很有趣。我不知道这算不算建议，但也许是一个可以运作良好的证明。不过我有时担心，这类事情最终听起来有点像“你只需要买张彩票”，这是中奖者的幸存者偏差，对吧？所以，谁知道呢？

---

### [01:31:30] Lenny Rachitsky

**English:**
It does resonate. It reminds me of something Brian Armstrong once shared, which is the reason that he-

**中文翻译:**
这确实能引起共鸣。这让我想起 Brian Armstrong 曾经分享过的一些东西，他之所以——

---

### [01:31:37] Tobi Lütke

**English:**
He's also, by the way, you have to add him to the set of first principle thinkers if you're starting to cultivate one. And I think there's plenty of startup success, successful founders, CEOs, especially for public companies are surprisingly alike in this projecting slightly different, maybe coming from different backgrounds, but Brian is extraordinarily strong at this [inaudible 01:32:06] by the way.

**中文翻译:**
顺便说一下，如果你要列一个“第一性原理思考者”名单，你必须把他加进去。我认为有很多成功的初创公司创始人、CEO，特别是上市公司的，在这一点上惊人地相似，尽管表现形式略有不同，背景也不同。顺便说一下，Brian 在这方面非常强。

---

### [01:32:06] Lenny Rachitsky

**English:**
Okay, here's to the next nominated for the podcast, Brian. We'll get on it. But interestingly, he had basically exact same advice for what allowed him to create Coinbase is his background was economics, coding and cryptography or something along those lines. And it's the Venn diagram, is like, "This is the thing I'm uniquely strong at and have an opportunity to win it."

**中文翻译:**
好的，下一位播客候选人：Brian。我们会安排的。但有趣的是，他对于是什么让他创建了 Coinbase 基本上有着完全相同的建议：他的背景是经济学、编程和密码学，或者是类似的领域。这就是那个韦恩图（Venn diagram）：“这是我独特擅长的事情，我有机会赢得它。”

---

### [01:32:29] Tobi Lütke

**English:**
Yeah. So this is what we very actively tell our customers, right? There's a 2005 essay by Kevin Kelly saying, "In the future on the internet you just need a thousand true fans." It's what the internet and I think what Shopify celebrates, that instead of trying to create toothpaste, which is of course a huge term but hard to differentiate. It's much better to figure out a triplicate intersection of three different things and nail it. We took a winter vacation with my boys and my family in the Caribbean and I like playing poker with them. I like playing poker and it's great limited information game. I think this were valuable for kids and so I found this, I might have mentioned this in some place, but I found this pirate gold I think it's called.

(01:33:32):
It's just amazing poker set, poker chips that look like they come right out of the treasure chest or in Pirates of the Caribbean. Think about just the intersection, so this is online Texas Hold'em, quality poker set instead of... because you can play with just anything, right? People were in the market for spending money on something like this and pirate themed. You're like, " But I'm such a big fan, I'm telling you about it and people might actually purchase it because I'm enthusiastic about it." And because enthusiasm is actually the best marketing and they have at least a thousand true fans, and it's just better to make amazing things for some people than make something that everyone wants maybe or would tolerate. And I think that's really, really good. So I think that works for your career too because by the way, we are all entrepreneurs so we're ready to think about any career.

(01:34:36):
If you actually ask me for career advice is we are products, we are engaged in entrepreneurship, we are basically software as a service if you want, or talent as a service. We are selling a subscription in the form of our employment we call it, but it's actually just rebranded the subscription frankly because it comes some extra protection, which is very good, but it's still the same thing, it's a double opt-in company. Like you would say, I can do these things and I will be of significantly more value to the company than you will have to spend on me. There's like a positive ROI ideally for a company and a company either says, "I agree or I don't agree with you." And that's actually what employment is. So I think people should think about themselves as a product. Your career is not based on mentors you find or getting a promotion or not.

(01:35:34):
It's about what are you too good to ignore in? How good can you be? Can you be absolutely work? Can you be excellent? I mean you don't have to be work class and stuff, but you have to... Ideally you find a thing where you are just in this sort of tiny space of five intersections or so versus we just know more than everyone else and then everyone calls you. Like I said, we use Ruby. Ruby was not that fast. Shopify would rather have it very fast. We found people who got PhDs in dynamic language, garbage collection dynamic language, just in time compilation to make Ruby fast. And they're having delightful time at Shopify and Shopify is now very fast and it's very good. And everyone gets to profit from us needing this because we merged it back into Ruby Core and now everyone can have a JIT compiler. So it's great.

**中文翻译:**
是的。所以这也是我们非常积极地告诉客户的，对吧？凯文·凯利（Kevin Kelly）在 2005 年写过一篇文章说：“在未来的互联网上，你只需要一千个铁杆粉丝。” 这就是互联网，也是 Shopify 所推崇的——与其尝试制造牙膏（这是一个巨大的品类但很难差异化），不如找出三个不同事物的交集并把它做到极致。我和我的孩子们以及家人在加勒比海度寒假，我喜欢和他们玩扑克。扑克是一场很棒的不完全信息博弈，我认为这对孩子很有价值。我找到了一个叫“海盗金币”（Pirate Gold）的东西，我可能在别处提到过。

(01:33:32):
那是一套惊人的扑克套装，筹码看起来就像直接从《加勒比海盗》的宝箱里拿出来的一样。想想这个交集：在线德州扑克、高品质扑克套装（而不是随便拿个东西玩）、海盗主题。你会觉得：“我是它的超级粉丝，我正在告诉你，人们可能会因为我的热情而购买它。” 因为热情实际上是最好的营销，他们至少有一千个铁杆粉丝。为某些人制造惊人的东西，比制造一个每个人都想要或者说能容忍的东西要好。我认为这非常棒。我认为这也适用于你的职业生涯，因为顺便说一下，我们都是创业者，所以我们要准备好思考任何职业。

(01:34:36):
如果你真的问我职业建议，那就是：我们是产品，我们正在从事创业，如果你愿意，我们基本上是“软件即服务”（SaaS），或者“人才即服务”。我们以“雇佣”的形式出售订阅，但坦率地说，这只是重新包装后的订阅，因为它带有一些额外的保护（这很好），但本质是一样的，这是一个双向选择的过程。就像你会说：“我能做这些事，我对公司的价值将远超你花在我身上的钱。” 理想情况下，对于公司来说有一个正的投资回报率（ROI），公司要么说“我同意”，要么说“我不同意”。这就是雇佣的本质。所以我认为人们应该把自己看作一个产品。你的职业生涯不是基于你找到的导师，也不是基于是否获得晋升。

(01:35:34):
而是关于：你在什么方面优秀到让人无法忽视？你能有多好？你能达到卓越吗？我的意思是，你不必非得是世界级的，但你必须……理想情况下，你找到一个五个领域交集的微小空间，在那里你比其他任何人都懂得多，然后所有人都会来找你。就像我说的，我们使用 Ruby。Ruby 以前没那么快，Shopify 希望它非常快。我们找到了在动态语言、垃圾回收、即时编译（JIT）方面获得博士学位的人，让他们把 Ruby 变快。他们在 Shopify 过得很愉快，现在的 Shopify 非常快，非常好。每个人都从我们的需求中获益，因为我们将代码合并回了 Ruby 核心，现在每个人都可以拥有 JIT 编译器。这太棒了。

---

### [01:36:40] Lenny Rachitsky

**English:**
I feel like every story is a fractal into other hours of other podcast conversation we can have. I know you have to go run this nine, 10, 10,000 person company and do real work. So I am going to end it there. We got through almost everything I was hoping to get through, but there's infinitely more questions I still have. Just to maybe end it, is there anything you want to leave listeners with? Any last nugget that maybe you didn't mention?

**中文翻译:**
我觉得每一个故事都是一个分形，可以引申出好几个小时的播客对话。我知道你得去管理这家九千、一万人的公司，去做真正的活儿了。所以我们就聊到这里。我们几乎涵盖了我希望涵盖的所有内容，但我还有无限多的问题。在结束之前，有什么想留给听众的吗？还有什么没提到的最后一点干货吗？

---

### [01:37:03] Tobi Lütke

**English:**
If I get to talk to again people who look at product and product management, here's my thing that I think maybe only implicitly came through in all this. Every product in the world, the quality at the end of the day is simply a reflection of how much the people who created it gave a shit about the product. And it is not possible to make great products if the people work on it do not give a shit about the product. And I actually think this is a very important role for product leaders to make sure that the team gives a shit. And I think this is something that can be done with building empathy for people using it, but also it can be done infectiously by the product leader. The product leader has to give a shit. Do not engage in product work on product that you don't care about because you cannot produce the thing that the person will give you a task is looking for.

(01:38:04):
And I think again, so much goes into this unquantifiable conversation which we already had, but boy is that important because it just isn't about the brief document, it isn't about the aligning stakeholders. Sometimes in some places some of those things are aspects of it and I think they correlate sometimes with people. But I think the higher order bit is if you are in product, you have basically free roads. You have to have the team sits, look around corners that they don't see. You just have to understand this thing that's being done better than everyone else because that's a role. Now, you don't have to do this by yourself. Everyone on the team is of a resource to you and you can query them and therefore determine what is around the corners and so on. But in engineering and UX and so on, but that's very important. Second is you've got to be exothermically infectious with actually caring about this thing because just that one thing alone will make a 10 times better product. It's crazy how much of a change this makes.

**中文翻译:**
如果我能再次与关注产品和产品管理的人交流，我想说的是——也许在刚才的谈话中这只是隐含表达出来的：世界上任何产品的质量，归根结底只是反映了创造它的人对这个产品有多么“在乎”（give a shit）。如果工作的人根本不在乎这个产品，就不可能做出伟大的产品。我实际上认为，产品负责人的一个非常重要的职责就是确保团队“在乎”。我认为这可以通过建立对用户的同理心来实现，也可以由产品负责人通过感染力来实现。产品负责人必须非常在乎。不要从事你不在乎的产品工作，因为你无法做出布置任务的人所期待的东西。

(01:38:04):
我想再次强调，这又回到了我们之前谈过的“不可量化”的对话，天哪，这太重要了，因为它不仅仅关乎需求文档，不仅仅关乎对齐利益相关者。有时在某些地方，这些是其中的一部分，我认为它们有时与人相关。但更高阶的准则是：如果你从事产品工作，你基本上有三条路。你必须让团队坐下来，观察他们看不到的死角。你必须比任何人都更了解正在做的事情，因为这就是你的角色。现在，你不需要独自完成，团队中的每个人都是你的资源，你可以询问他们，从而确定死角里有什么。在工程、UX 等方面也是如此，这非常重要。第二点是，你必须以“放热”的方式感染他人，表现出你真的很在乎这件事，因为仅仅这一件事就能让产品好上 10 倍。这种改变是惊人的。

---

### [01:39:25] Lenny Rachitsky

**English:**
I feel like honestly what you're describing here is like founder mode, what the outputs are. Giving a shit, being exothermic excited and looking around corners. I feel like this is its own conversation here.

**中文翻译:**
老实说，我觉得你描述的就像是“创始人模式”（founder mode）的产出：极度在乎、充满热情的兴奋以及预见死角。我觉得这本身就可以开启另一场对话。

---

### [01:39:25] Tobi Lütke

**English:**
Yeah, I agree. I don't think founder mode, so I mean I think, yeah, founder mode is a super valuable term, but I actually do think that I answered the question about what I think about founder mode in the discussion about pumping heat into systems. That's what I do. It's just that founder mode in a founder run company, I think this has an easier time existing because people dislike the people who are pumping heat into a thing. People fight them, people probably take them out, and if the boss is like this, boss can protect the other people like this. And therefore I think founder run companies can be innovative longer because there's a substrate by which this can stay a thing for a long time. So anyway, that's my tear down on the founder mode discussion, which I think is a really fascinating recent discussion. I find it's very valuable. I'm sure it's misunderstood in all sorts of ways, but I think it's more actionable than people think.

**中文翻译:**
是的，我同意。我认为“创始人模式”是一个非常有价值的词，但我实际上认为，我在关于“向系统注入热量”的讨论中已经回答了关于我对创始人模式看法的问题。那就是我所做的。只是在创始人经营的公司里，创始人模式更容易存在，因为人们往往不喜欢那些向系统注入热量的人。人们会反抗他们，甚至可能把他们踢出局。但如果老板是这样的人，老板就可以保护其他同样注入热量的人。因此，我认为创始人经营的公司可以保持更长时间的创新，因为有一种基质可以让这种模式长期存在。总之，这就是我对创始人模式讨论的拆解，我认为这是最近一个非常迷人的讨论。我觉得它非常有价值。我敢肯定它在各种方面都被误解了，但我认为它比人们想象的更具操作性。

---

### [01:40:40] Lenny Rachitsky

**English:**
Tobi, I appreciate you continuing to drop nuggets, even though I know you have to go, by the way, your video looks incredible right now. This is amazing editing, we're doing like a rainbow streaming across your body.

**中文翻译:**
Tobi，我很感激你即使在要走的时候还在分享干货。顺便说一下，你的视频现在看起来棒极了。这剪辑太神了，就像一道彩虹流过你的身体。

---

### [01:40:53] Tobi Lütke

**English:**
Yeah, we really hit the rainbows here like, "Let's go and invent." I hope you've got to gold that you were hoping and-

**中文翻译:**
是的，我们真的撞上了彩虹，就像在说“让我们去发明吧”。我希望你得到了你想要的“金子”，并且——

---

### [01:41:00] Lenny Rachitsky

**English:**
So much gold.

**中文翻译:**
全是金子。

---

### [01:41:00] Tobi Lütke

**English:**
... I was sufficient leprechaun here to deliver.

**中文翻译:**
……我在这里充当了合格的“爱尔兰小矮人”（传说中彩虹尽头守金币的小精灵）来交付这些金子。

---

### [01:41:05] Lenny Rachitsky

**English:**
What a metaphor. Okay, Tobi, thank you so much for doing this. This was incredible. I feel like this is going to help so many people build great companies and thank you from first principles.

**中文翻译:**
多棒的比喻。好的，Tobi，非常感谢你参加节目。这太不可思议了。我觉得这会帮助很多人建立伟大的公司，感谢你分享的第一性原理。

---

### [01:41:13] Tobi Lütke

**English:**
Okay, I got to run. Bye-bye.

**中文翻译:**
好了，我得走了。拜拜。

---

### [01:41:15] Lenny Rachitsky

**English:**
Okay, bye.

(01:41:18):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
好的，再见。

(01:41:18):
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，因为这能极大地帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。