# Todd Jackson - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Todd Jackson on the framework for finding Product-Market Fit (PMF).

---

### [00:00:00] Todd Jackson

**English:**
Finding product-market fit is the single most important thing that your startup does in the first three years, and it's just underexplored and it's just underexplained as a topic.

**中文翻译:**
在创业的前三年里，寻找产品市场匹配（Product-Market Fit, PMF）是你的初创公司所做的唯一最重要的事情。然而，作为一个课题，它一直缺乏深入的探讨和清晰的解释。

---

### [00:00:08] Lenny Rachitsky

**English:**
You've been working on a product-market fit framework.

**中文翻译:**
你一直在研究一套关于产品市场匹配的框架。

---

### [00:00:11] Todd Jackson

**English:**
We've published dozens of articles on the First Round Review, and we have found a very consistent set of patterns, demand satisfaction, and efficiency. But the interesting thing is that you don't go for all three of them from the very beginning.

**中文翻译:**
我们在《First Round Review》上发表了数十篇文章，发现了一套非常一致的模式：需求（Demand）、满意度（Satisfaction）和效率（Efficiency）。但有趣的是，你并不是从一开始就同时追求这三点。

---

### [00:00:22] Lenny Rachitsky

**English:**
There's essentially four levels of product-market fit: nascent, developing, strong, extreme.

**中文翻译:**
产品市场匹配基本上分为四个等级：萌芽期（Nascent）、发展期（Developing）、强劲期（Strong）和极致期（Extreme）。

---

### [00:00:27] Todd Jackson

**English:**
Roughly, 60% are never going to get past L2.

**中文翻译:**
大约有 60% 的公司永远无法突破第二级（L2）。

---

### [00:00:29] Lenny Rachitsky

**English:**
These four Ps is essentially what you should try to change if you're stuck.

**中文翻译:**
如果你陷入困境，这“四个 P”基本上就是你应该尝试改变的东西。

---

### [00:00:34] Todd Jackson

**English:**
You've got the persona, the problem, the promise, and the product. Lattice kept the first one but changed the others. Vanta changed all four.

**中文翻译:**
这四个 P 分别是：用户画像（Persona）、问题（Problem）、承诺（Promise，即价值主张）和产品（Product）。Lattice 保留了第一个，但改变了其他三个；而 Vanta 则把四个全改了。

---

### [00:00:41] Lenny Rachitsky

**English:**
Hearing level three tells me level two is basically your pivot from: I'm just grinding, selling, pitching.

**中文翻译:**
听到第三级的情况让我明白，第二级基本上是你从“苦哈哈地磨合、销售、推销”状态中转型的阶段。

---

### [00:00:47] Todd Jackson

**English:**
This is where it starts to get fun.

**中文翻译:**
从这里开始，事情变得有趣起来了。

---

### [00:00:53] Lenny Rachitsky

**English:**
Today my guest is Todd Jackson. Todd is a partner at the legendary VC firm, First Round Capital. I rarely have VCs on this podcast, but as Todd shares at the top of this episode, Todd is a very special VC. Prior to moving into venture, he was product lead for Gmail for four years. He was product manager of Facebook's newsfeed, photos and groups, including leading a major redesign of the newsfeed. He's also a director of product management at Twitter and VP of product and design at Dropbox.

**中文翻译:**
今天的嘉宾是 Todd Jackson。Todd 是传奇风投公司 First Round Capital 的合伙人。我很少邀请风投人上这个播客，但正如 Todd 在本集开头所分享的，他是一位非常特别的风投人。在进入风投领域之前，他曾担任 Gmail 的产品负责人长达四年。他曾是 Facebook 动态消息（Newsfeed）、照片和小组的产品经理，并领导了动态消息的一次重大重新设计。他还曾担任 Twitter 的产品管理总监以及 Dropbox 的产品与设计副总裁。

---

### [00:01:21] Lenny Rachitsky

**English:**
He's also a founder and sold his company to Twitter. This episode is a very different and special kind of episode. Todd and the team at First Round have spent the last year looking at all of their data and the journeys of the hundreds of startups that they've worked with over the years. And through that, have put together a very practical and very actionable framework to help founders find product-market fit. They're turning this framework into a three-month program for founders, and in this conversation, Todd shares an exclusive peek into the program, in particular, the stages of product-market fit.

**中文翻译:**
他也是一名创业者，曾将自己的公司卖给了 Twitter。这一集非常不同且特别。Todd 和 First Round 的团队在过去一年里研究了他们所有的历史数据，以及多年来合作过的数百家初创公司的历程。通过这些研究，他们总结出了一套非常实用且具有可操作性的框架，旨在帮助创始人寻找产品市场匹配。他们正将这一框架转化为一个为期三个月的创始人项目。在这次对话中，Todd 将独家分享该项目的内幕，特别是关于 PMF 的各个阶段。

---

### [00:01:55] Lenny Rachitsky

**English:**
We talk about how to know which stage you're in, what to do if you're stuck in that stage, and also what you can change in order to get unstuck. If you're a founder or building a new product within a company and feeling like you're not making as much progress as you'd hope, you will find tremendous value in this conversation. With that, I bring you Todd Jackson after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing feature episodes and it helps the podcast tremendously.

**中文翻译:**
我们将讨论如何判断你处于哪个阶段，如果卡在某个阶段该怎么办，以及你可以通过改变什么来摆脱困境。如果你是一名创始人，或者正在公司内部开发新产品，并且觉得进展不如预期，你会在这次对话中发现巨大的价值。在听完赞助商的简短介绍后，我们将正式开始与 Todd Jackson 的对话。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过后续节目的最佳方式，也对本播客有很大帮助。

---

### [00:02:26] Lenny Rachitsky (Sponsor: WorkOS)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point, your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. And hundreds of other companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow and Loom.

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，你的客户迟早会开始要求企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业级功能。他们的 API 易于理解，让你能快速交付并重新投入到其他功能的开发中。已有数百家公司由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。

---

### [00:02:56] Lenny Rachitsky (Sponsor: WorkOS)

**English:**
WorkOS also recently launched AuthKit, a complete authentication and user management service. It's essentially a modern alternative to Auth0, but with better pricing and more flexible APIs. AuthKit's design is stunning out of the box, and you can also fully customize it to fit your app's brand. It's an effortless experience from your first user, all the way to your largest enterprise customer. Best of all, AuthKit is free for any developer up to one million users. Check it out at workos.com/lenny to learn more. That's workos.com/lenny.

**中文翻译:**
WorkOS 最近还推出了 AuthKit，这是一项完整的身份验证和用户管理服务。它本质上是 Auth0 的现代替代方案，但价格更优，API 更灵活。AuthKit 的设计开箱即用，非常精美，你也可以完全自定义以符合你的应用品牌。从第一个用户到最大的企业客户，它都能提供轻松的体验。最棒的是，AuthKit 对任何开发者免费开放，支持多达 100 万用户。访问 workos.com/lenny 了解更多信息。

---

### [00:03:32] Lenny Rachitsky (Sponsor: Eppo)

**English:**
This episode is brought to you by Eppo. Eppo is a next-generation A/B testing and feature management platform built by alums of Airbnb and Snowflake for modern growth teams. Companies like Twitch, Miro, ClickUp and DraftKings rely on Eppo to power their experiments. Experimentation is increasingly essential for driving growth and for understanding the performance of new features. And Eppo helps you increase experimentation velocity while unlocking rigorous deep analysis in a way that no other commercial tool does.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 和 Snowflake 的校友为现代增长团队打造的下一代 A/B 测试和功能管理平台。Twitch、Miro、ClickUp 和 DraftKings 等公司都依赖 Eppo 来驱动他们的实验。实验对于推动增长和了解新功能表现变得越来越重要。Eppo 能帮助你提高实验速度，同时解锁其他商业工具无法提供的严谨深度分析。

---

### [00:04:12] Lenny Rachitsky (Sponsor: Eppo)

**English:**
When I was at Airbnb, one of the things that I loved most was our experimentation platform where I could set up experiments easily, troubleshoot issues, and analyze performance all on my own. Eppo does all that and more with advanced statistical methods that can help you shave weeks off experiment time, and accessible UI for diving deeper into performance, and out-of-the-box reporting that helps you avoid annoying, prolonged analytic cycles. Eppo also makes it easy for you to share experiment insights with your team, sparking new ideas for the A/B testing flywheel. Eppo powers experimentation across every use case, including product, growth, machine learning, monetization, and email marketing. Check out Eppo at geteppo.com/lenny and 10 X your experiment velocity. That's geteppo.com/lenny. Todd, thank you so much for being here and welcome to the podcast.

**中文翻译:**
我在 Airbnb 时，最喜欢的东西之一就是我们的实验平台，在那里我可以轻松设置实验、排除故障并独立分析表现。Eppo 不仅能做到这些，还拥有先进的统计方法，可以帮你缩短数周的实验时间，其易用的 UI 方便深入研究表现，开箱即用的报告能帮你避免烦人且漫长的分析周期。Eppo 还能让你轻松与团队分享实验洞察，激发 A/B 测试飞轮的新创意。Eppo 支持各种场景的实验，包括产品、增长、机器学习、变现和邮件营销。访问 geteppo.com/lenny，让你的实验速度提升 10 倍。Todd，非常感谢你能来，欢迎来到本播客。

---

### [00:04:56] Todd Jackson

**English:**
Lenny, I'm excited to be here. Thank you for having me.

**中文翻译:**
Lenny，很高兴来到这里。谢谢你的邀请。

---

### [00:04:58] Lenny Rachitsky

**English:**
So first of all, just to mention you're a VC, which is very rare for this podcast. But you're a very special VC, you have a deep background in product, and I thought it might be helpful just to give a little bit of context on your product background, your product bona fides so people will get a real sense of just how legit you are as a product thinker.

**中文翻译:**
首先，我想提一下你是一名风投（VC），这在我的播客中非常少见。但你是一位非常特别的风投，你有深厚的产品背景。我想如果能介绍一下你的产品背景和资历会很有帮助，这样大家就能真正感受到你在产品思维方面有多么专业。

---

### [00:05:17] Todd Jackson

**English:**
Yeah, you got it. So I am a VC. I'm a partner at First Round Capital now, and I've been at First Round for four years. But I was not a VC before First Round. So I started a company in 2013 called Cover, and that was actually funded by First Round 11 years ago. That's how I got to know First Round. And before that, I had worked on Gmail as the product lead in the early days, early 2000s and at Facebook.

**中文翻译:**
没问题。我现在确实是一名风投，是 First Round Capital 的合伙人，已经在那儿待了四年。但在加入 First Round 之前，我并不是风投。我在 2013 年创办了一家名为 Cover 的公司，那家公司其实在 11 年前就获得了 First Round 的投资，我就是这样认识他们的。在那之前，我在 2000 年代初期担任过 Gmail 的早期产品负责人，后来又去了 Facebook。

---

### [00:05:39] Todd Jackson

**English:**
And then I started Cover, and we ended up selling Cover to Twitter in 2014. And I worked on a bunch of different products at Twitter. And then I was the VP of product and design at Dropbox. That was 2015 to 2018. So I have always loved product, and that's actually the reason now that I love being a seed stage VC because I love investing at the early stage founders who are pre-product-market fit and then helping them get there. And I just love doing that over and over again.

**中文翻译:**
接着我创办了 Cover，并在 2014 年将其卖给了 Twitter。我在 Twitter 负责过很多不同的产品。之后，我在 2015 年到 2018 年间担任 Dropbox 的产品与设计副总裁。我一直非常热爱产品，这其实也是我现在喜欢做种子轮风投的原因，因为我喜欢投资那些处于 PMF 之前的早期创始人，并帮助他们实现匹配。我非常享受一遍又一遍地重复这个过程。

---

### [00:06:07] Lenny Rachitsky

**English:**
I feel like we could have a whole other podcast episode on why you decided to move into venture versus staying in product.

**中文翻译:**
我觉得我们可以专门再录一集，聊聊你为什么决定转行做风投而不是继续留在产品领域。

---

### [00:06:12] Todd Jackson

**English:**
We can do it.

**中文翻译:**
没问题，我们可以聊。

---

### [00:06:13] Lenny Rachitsky

**English:**
But we're going to stay focused. So the reason we're here is that for over a year, you've been working on a product-market fit framework, essentially, a framework to help founders and product teams find product-market fit, which we should talk about this. But this is the most important thing you've got to get right as a founder in a product team is finding product-market fit. I got a peek at this framework. I love it. I love the way you've structured it, the way you're thinking about it.

**中文翻译:**
但我们还是先回到主题。我们今天聚在一起的原因是，一年多来你一直在研究一套产品市场匹配框架，基本上是帮助创始人和产品团队寻找 PMF 的工具。我们确实该好好聊聊这个。作为创始人和产品团队，寻找 PMF 是你必须做对的最重要的事情。我预览过这个框架，非常喜欢。我喜欢你构建它的方式以及你的思考逻辑。

---

### [00:06:36] Lenny Rachitsky

**English:**
So what we're going to do today is walk through this framework in depth. First, I just want to spend a few minutes on setting a little context just so people understand who this is for and how to think about this. So maybe a first question is just why do you believe people need a framework for finding product-market fit? And just also, if you want to touch on why is product-market fit so important? Why is that something people should even be thinking about?

**中文翻译:**
所以我们今天的计划是深入探讨这个框架。首先，我想花几分钟设定一下背景，让大家了解这个框架是为谁准备的，以及该如何看待它。第一个问题是：你为什么认为人们需要一个寻找 PMF 的框架？另外，如果你愿意，也可以谈谈为什么 PMF 如此重要？为什么人们甚至应该去思考它？

---

### [00:06:57] Todd Jackson

**English:**
The thing about product-market fit is that I find it's mysterious to a lot of people, and people tend to think about it purely as an art rather than a science. And all the advice that you find out there on the internet is very general when it comes to product-market fit. You'll know it when you see it, you'll know it when you have it. It's not specific. And there's so many other startup topics where there is good content on the internet like hiring your first salesperson, running board meetings, stuff that is specific and tactical. But there isn't that much content around product-market fit that is that specific.

**中文翻译:**
关于 PMF，我发现它对很多人来说都很神秘，人们倾向于认为它纯粹是一门艺术而非科学。你在网上能找到的所有关于 PMF 的建议都非常笼统，比如“当你看到它时你就会知道”、“当你拥有它时你就会感觉到”。这些都不够具体。互联网上有很多关于创业其他主题的优质内容，比如如何雇佣第一名销售、如何主持董事会会议，这些都很具体且具有战术性。但在 PMF 方面，却很少有如此具体的内容。

---

### [00:07:33] Todd Jackson

**English:**
And so I think that's actually why Rahul from Superhuman is well-known for his approach to finding product-market fit. That was published on the First Round Review in 2018, and it was immediately popular and interesting to people. And I think the reason is because it was specific and because it was tactical and it brought a little bit of the science to something that people thought was just an art. And I think it's why your content is really popular too, Lenny.

**中文翻译:**
所以我认为这就是为什么 Superhuman 的 Rahul 因其寻找 PMF 的方法而闻名。那篇文章 2018 年发表在《First Round Review》上，立刻引起了轰动。我认为原因在于它很具体、很有战术性，为人们原本认为只是艺术的东西注入了一些科学成分。Lenny，我想这也是为什么你的内容如此受欢迎的原因。

---

### [00:07:57] Todd Jackson

**English:**
You and I worked on this product validation article together a little while back, and the seven part series that you did on B2B SaaS companies and the PMF benchmarking data that you had, I think it was how long it took to get to a product and a customer and to product-market fit, that was super well-read. And there just isn't that much good specific content about this. But like you said, product-market fit is the single most important thing that your startup does in the first three years and it's just underexplored, it's underexplained as a topic.

**中文翻译:**
不久前我们一起合作过那篇关于产品验证的文章，还有你做的关于 B2B SaaS 公司的七部分系列文章，以及你掌握的 PMF 基准数据（比如开发出产品、获得客户并达到 PMF 需要多长时间），那些文章的阅读量都非常高。关于这个话题，确实没有太多优质且具体的内容。但正如你所说，PMF 是初创公司在前三年里做的唯一最重要的事情，而这个话题却一直缺乏深入探讨和解释。

---

### [00:08:28] Todd Jackson

**English:**
So we felt this was a very important thing to do, something worth focusing on. And I've personally talked to hundreds of founders about this topic. We've published dozens of articles on the First Round Review. We call this our Paths to Product-Market Fit Series where we interview founders about the early days. And I'm just always interested in what are the patterns. If you talk to enough successful founders, and in this case, it can be enterprise founders, and you ask them, "What did you do in the first six to nine months of running your company, of starting your company? What patterns emerged from that?" And we have found a very consistent set of patterns, and that's what we decided to base our framework around.

**中文翻译:**
所以我们觉得这是一件非常重要、值得关注的事情。我个人曾与数百位创始人讨论过这个话题。我们在《First Round Review》上发表了数十篇文章，称之为“通往 PMF 之路”系列，采访创始人们关于公司早期的故事。我一直对其中的模式很感兴趣。如果你和足够多成功的创始人交流（在这里主要是企业服务领域的创始人），问他们：“在公司成立的前六到九个月里，你都做了什么？从中总结出了什么模式？”我们发现了一套非常一致的模式，这就是我们决定构建这套框架的基础。

---

### [00:09:07] Lenny Rachitsky

**English:**
Amazing. And I think you're at such an interesting Venn diagram of exposure to develop something like this. One, you have a deep product background, you started a company, you see tons of startups going through the journey, many succeeding, many not. So I get why one, you wanted to do this and why I think this is going to be so valuable to a lot of people. You talked briefly about why product-market fit is so important, and maybe it might be helpful just to share a little bit more just why is this something people should be so obsessed with and why did you spend so much time developing this?

**中文翻译:**
太棒了。我觉得你正处于一个非常有趣的“交集”中，非常适合开发这样的东西：首先你有深厚的产品背景，创办过公司，又见证了无数初创公司的历程，有的成功，有的失败。所以我理解你为什么要这么做，也相信这对很多人来说非常有价值。你简要提到了 PMF 为什么重要，也许可以再多分享一点：为什么人们应该对此如此痴迷？为什么你花了这么多时间来开发它？

---

### [00:09:40] Todd Jackson

**English:**
I think as a founder, there are so many things you have to do. You have to pick a market, you have to find a co-founder, you have to hire a team, you have to raise funding, you have to build a product, you have to sell a product. And so sometimes it gets lost that actually, the only thing that matters in the first couple years is finding product-market fit and actually, what we define as extreme product-market fit, and I'll go into that. Because if you find extreme product-market fit, the momentum just carries you, and the market pulls you along. It's easy to know what to build because you're building the thing that your customers want and it's motivating as a team. It's easy to hire people, everything becomes easier if you find product-market fit, it is the thing that propels the company.

**中文翻译:**
我认为作为创始人，有太多的事情要做：选择市场、寻找合伙人、组建团队、融资、开发产品、销售产品。因此，有时人们会忽略这一点：在最初的几年里，唯一重要的事情就是寻找 PMF，准确说是我们定义的“极致 PMF”（我稍后会详细说明）。因为如果你找到了极致 PMF，势能就会推着你走，市场会拉着你前进。你会很容易知道该开发什么，因为你正在开发客户想要的东西，这会让团队充满动力。招人也会变得容易，一旦找到 PMF，一切都会变得简单，它是推动公司前进的引擎。

---

### [00:10:25] Todd Jackson

**English:**
And so we are a seed stage venture firm. We tend to work with very early founders who are pre-product-market fit. And the hard truth about it is that most of them don't get past the first couple levels of it. The majority of startups do not get past, what we call, level one product-market fit or level two product-market fit. And I'll go through and define all that stuff. They get stuck at one of those first couple levels. And if they can unlock the right product and the right way to explain it to a customer and make a customer deeply satisfied, and there's enough customers out there like that, it just pulls the whole thing along.

**中文翻译:**
我们是一家种子轮风投公司，通常与处于 PMF 之前的极早期创始人合作。残酷的现实是，大多数公司都无法突破前两个阶段。大多数初创公司都无法跨越我们所说的第一级或第二级 PMF（我稍后会定义这些）。他们卡在了最初的几个阶段。但如果他们能解锁正确的产品，找到向客户解释产品的正确方式，并让客户深感满意，且市场上有足够多这样的客户，那么整个公司就会被顺势带动起来。

---

### [00:11:02] Lenny Rachitsky

**English:**
Who is this framework for specifically? And for people that are listening, how do they know if this is for them or not?

**中文翻译:**
这套框架具体是为谁准备的？听众该如何判断这是否适合他们？

---

### [00:11:07] Todd Jackson

**English:**
This is for early B2B founders, and specifically founders who are doing something that is more sales-led than bottom-up. I think bottom-up is its own world. It's closer to consumer product development in my mind. And I have done consumer products. Consumer product, I think there is a little bit more alchemy involved. It's about having great taste and finding the right thing at the right time and it's like catching lightning in a bottle.

**中文翻译:**
这是为早期 B2B 创始人准备的，特别是那些采用销售驱动（Sales-led）而非自下而上（Bottom-up）模式的创始人。我认为自下而上是另一个领域，在我看来它更接近消费级产品的开发。我也做过消费级产品，我觉得那里面有更多的“炼金术”成分——关乎品味、在正确的时间找到正确的东西，就像把闪电装进瓶子里一样难得。

---

### [00:11:36] Todd Jackson

**English:**
I think the good thing about enterprise, and specifically sales-led B2B, is that there is more science to it. And so it is for sales-led B2B founders who are in, let's call it, the first six to nine months of starting their company and want to set the foundation for product-market fit right from the beginning.

**中文翻译:**
我认为企业服务，特别是销售驱动的 B2B，其优势在于它更有科学性。所以，这套框架是为那些处于创业前六到九个月、希望从一开始就为 PMF 打好基础的销售驱动型 B2B 创始人准备的。

---

### [00:11:53] Lenny Rachitsky

**English:**
Awesome. Okay. So B2B founders, sales-led in the first six to nine months of their journey. Awesome.

**中文翻译:**
太好了。所以是针对创业前六到九个月、销售驱动型的 B2B 创始人。明白了。

---

### [00:11:59] Todd Jackson

**English:**
That's right. Yes.

**中文翻译:**
没错。

---

### [00:12:00] Lenny Rachitsky

**English:**
You talked about the science of this. I imagine you don't want to overpromise this is going to help you find product-market fit, step one, two, three profit. How do you think about just what the benefits of this are and how people should think about the chance that they will find product-market fit at the end of this journey following this framework?

**中文翻译:**
你谈到了这其中的科学性。我想你并不想过度承诺说这能保证帮你找到 PMF，然后第一步、第二步、第三步就盈利了。你认为这套框架的好处是什么？人们应该如何看待遵循这套框架后找到 PMF 的几率？

---

### [00:12:16] Todd Jackson

**English:**
We can't guarantee success here. I just want to contextualize that finding extreme product-market fit is very, very hard. And what we are trying to do is increase your odds, increase the odds, reduce the role of luck, give you a framework and way of thinking about the things that you need to do. And I think that that can increase the odds. Like I said earlier, the majority of startups are getting stuck at these first couple levels. I think if you know what the path looks like and you know what the levers are at your disposal and you know what you need to aim for, I think we can get more of these companies to level three and level four product-market fit, which is where you really want to be and where you have a very valuable company.

**中文翻译:**
我们无法保证成功。我只想说明，寻找极致 PMF 是非常、非常困难的。我们尝试做的是提高你的胜算，减少运气成分，为你提供一个框架和思考方式来处理你需要做的事情。我认为这可以提高成功率。正如我之前所说，大多数初创公司都卡在了前几个阶段。如果你知道路径是什么样的，知道你可以利用哪些杠杆，知道你的目标是什么，我认为我们可以让更多的公司达到第三级和第四级 PMF，那才是你真正想去的地方，也是公司变得非常有价值的阶段。

---

### [00:12:54] Lenny Rachitsky

**English:**
Perfect. Okay, final question. You launched a whole program for founders to go through and learn all of this in depth, many week kind of program. We're going to be covering a lot of it here for folks that want to go a lot deeper and actually go through this program. Talk about how they find this and how this program works.

**中文翻译:**
太棒了。好，最后一个问题。你为创始人推出了一个完整的项目，让他们深入学习这一切，这是一个为期数周的项目。我们今天会涵盖其中的很多内容，但对于那些想要更深入并实际参与该项目的人，请谈谈他们如何找到这个项目以及它是如何运作的。

---

### [00:13:11] Todd Jackson

**English:**
So we launched a new program, and we call it Product-Market Fit Method. It is designed, like I said, to help early B2B founders increase the odds of finding product-market fit. It's totally free, it's a very intensive program. You can see all the details at pmf.firstround.com, and the application deadline is May 7th. The program starts on May 29th. And we actually ran a beta version, a test version of this late last year with 11 founders, I think probably some you know, Lenny, from Stripe and Plaid and Airbnb and Twitter. And the feedback, it was great. It made me feel very good.

**中文翻译:**
我们推出了一个新项目，叫做“PMF 方法论”（Product-Market Fit Method）。正如我所说，它旨在帮助早期 B2B 创始人提高找到 PMF 的几率。它是完全免费的，而且是一个非常高强度的项目。你可以在 pmf.firstround.com 查看所有细节，申请截止日期是 5 月 7 日，项目将于 5 月 29 日开始。去年年底我们运行了一个测试版，有 11 位创始人参加，Lenny，我想其中一些你可能认识，他们来自 Stripe、Plaid、Airbnb 和 Twitter。反馈非常好，这让我感觉很棒。

---

### [00:13:47] Todd Jackson

**English:**
One of the founders was like, "I feel like these 14 weeks saved me two years of time in what would've been wandering through the desert." And so there's eight sessions in the full program, and the first one is the one we're going to do today. So the first session is on what we call the levels of product-market fit. The second one is on customer discovery, and we actually refer to it as dollar-driven discovery. We get very specific about not just the normal way of doing customer conversations and customer discovery, but how do you find that a customer is willing to pay money for this thing and a lot of money?

**中文翻译:**
其中一位创始人说：“我觉得这 14 周帮我节省了两年的时间，否则我可能会在沙漠中徘徊。”整个项目共有八个环节，第一个环节就是我们今天要聊的内容：PMF 的等级。第二个环节是关于客户调研（Customer Discovery），我们称之为“金钱驱动的调研”（Dollar-driven discovery）。我们不仅讨论常规的客户访谈，还会非常具体地探讨：你如何发现客户愿意为此付钱，而且是付很多钱？

---

### [00:14:22] Todd Jackson

**English:**
We talk about market validation, product positioning. We do a section on design partners because I think a lot of founders have questions about that. How do I find the right design partners? What's the right way to structure an agreement with them? How do I convert them to paying customers? All that stuff. We talk about product iteration and pivots, and I refer to this stage as the grind, the grind of product iteration. And then we spend a ton of time on founder-led sales.

**中文翻译:**
我们会讨论市场验证、产品定位。我们还有一个关于“设计合作伙伴”（Design Partners）的章节，因为很多创始人对此都有疑问：如何找到合适的设计合作伙伴？如何与他们签订协议？如何将他们转化为付费客户？诸如此类。我们还会讨论产品迭代和转型（Pivots），我把这个阶段称为“磨合期”，即产品迭代的艰苦过程。最后，我们会花大量时间讨论“创始人驱动的销售”。

---

### [00:14:47] Todd Jackson

**English:**
And the reason that we do that is we really like working with very technical founders, builders, people that are either engineering background, product design, data science, people who are builders. So that's the program in a nutshell. And like I said, any founder working on a new B2B SaaS company, welcome to apply. And then bonus points if you are technical, like I said, if you have a clear product idea or a hypothesis, but that you're less than six to 12 months into building the company.

**中文翻译:**
我们之所以这样做，是因为我们非常喜欢与技术型创始人、构建者（Builders）合作，他们可能具有工程背景、产品设计或数据科学背景。这就是该项目的概况。正如我所说，欢迎任何正在开发 B2B SaaS 新公司的创始人申请。如果你是技术背景，或者你有一个明确的产品想法或假设，但公司成立还不到 6 到 12 个月，那会有加分。

---

### [00:15:19] Lenny Rachitsky

**English:**
I love how incentives are so aligned here. You help companies find product-market fit. If First Round does great, everyone does great. It makes so much sense to build something like this. One thing I can't help but mention or ask about is you said it's an intensive program. How do you find founders have time to do something like this and also be building their company? I know this helps them build, but how do you just think about they have so much to do, they have time to do a program like this?

**中文翻译:**
我喜欢这种激励机制的一致性。你们帮助公司寻找 PMF，如果 First Round 表现出色，大家都会受益。建立这样的项目非常有意义。我忍不住想问的是，你提到这是一个高强度的项目。创始人如何腾出时间来参加这个项目，同时还要经营公司？我知道这能帮助他们构建公司，但考虑到他们有那么多事情要做，他们真的有时间参加这样的项目吗？

---

### [00:15:41] Todd Jackson

**English:**
The way that we think about it is that the program roughly takes about 10 hours a week for each founder, and it's 10 hours of work that you were going to be doing anyway. It is literally you're talking to customers, you're improving your positioning, you're doing critical thinking about your market and what you should be building. And so the way I think about it, and the way I've heard from the 11 founders that went through it is it just added structure to what I was doing anyway and it actually made me more efficient.

**中文翻译:**
我们的想法是，这个项目每周大约占用创始人 10 小时，而这 10 小时的工作是你本来就要做的。你本来就要和客户交流、优化定位、对市场和产品方向进行批判性思考。所以我认为，正如参加过测试的 11 位创始人所反馈的，它只是为你本来就在做的事情增加了结构性，实际上让你变得更高效了。

---

### [00:16:10] Lenny Rachitsky

**English:**
Last question, you mentioned that it's free. How does that work? How does that work for everyone?

**中文翻译:**
最后一个问题，你提到它是免费的。这是怎么运作的？对各方有什么好处？

---

### [00:16:14] Todd Jackson

**English:**
So it's 100% free and literally, it costs you $0. We give you $0, we own 0% of your company. And it's pretty different than I think a lot of other programs out there. And this is just something we do. Over the years, we've run First Round Angel Track, which I know you were in, Lenny. We've run the First Round Review for 10 years. We make these things free and our belief is that you have to create value in the ecosystem.

**中文翻译:**
它是 100% 免费的，字面意思就是你不需要花一分钱。我们不给你钱，也不占你公司的股份。这与市面上很多其他项目非常不同。这是我们的一贯做法。多年来，我们运行过 First Round Angel Track（Lenny，我知道你也参加过），我们经营《First Round Review》已经 10 年了。我们把这些东西做成免费的，因为我们相信必须在生态系统中创造价值。

---

### [00:16:36] Todd Jackson

**English:**
You have to put stuff out in the world that is useful, and if you can create that value, create enough value with the audience, then you'll be able to capture that value at some point. And so we think there's a win-win here. We get an inside look at some of tomorrow's great companies and they get an inside look at First Round.

**中文翻译:**
你必须向世界输出有用的东西。如果你能创造价值，在受众中创造足够的价值，那么在未来的某个时刻，你就能捕获这些价值。所以我们认为这是一个双赢：我们可以近距离观察未来伟大的公司，而他们也可以近距离了解 First Round。

---

### [00:16:49] Lenny Rachitsky

**English:**
Got it. So companies don't have to take money from you guys to be a part of this program.

**中文翻译:**
明白了。所以公司不需要拿你们的钱也能参加这个项目。

---

### [00:16:53] Todd Jackson

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:16:54] Lenny Rachitsky

**English:**
Okay, let's get into it. Let's talk about this framework. Maybe just as a broad strokes overview, how does this framework work? How do companies find product-market fit?

**中文翻译:**
好，让我们开始吧。聊聊这个框架。能不能先大概概述一下，这个框架是如何运作的？公司是如何寻找 PMF 的？

---

### [00:17:03] Todd Jackson

**English:**
So the framework starts with a very simple idea that is product-market fit is not a one-size-fits-all thing, and it doesn't just happen overnight. And for B2B companies, specifically, it does tend to follow a repeatable pattern. And so we start with defining the ultimate goal. The ultimate goal is to get to extreme product-market fit. And we have a precise definition for this. Let me read it to you. So extreme product-market fit is a state of widespread demand for a product that satisfies a critical need and crucially can be delivered repeatably and efficiently to each customer.

**中文翻译:**
这个框架始于一个非常简单的理念：PMF 不是一种通用的东西，也不会一夜之间发生。特别是对于 B2B 公司，它往往遵循一种可重复的模式。所以我们首先定义最终目标。最终目标是达到“极致 PMF”。我们对此有一个精确的定义，我读给你听：极致 PMF 是指一种状态，即市场对某款产品有广泛的需求，该产品满足了某种关键需求，且至关重要的是，它能够重复且高效地交付给每一位客户。

---

### [00:17:40] Todd Jackson

**English:**
And so there's three key ideas in there: demand, satisfaction and efficiency. And I think efficiency is worth highlighting because that's what most people would leave out of their definition. You talk about like, "Oh, it's a product, people like it. That's good, that's product-market fit." But if you look, there's products out there. I was a big fan of WeWork, as a customer of WeWork. And I'm a fan of Casper and these other products. Those products managed to achieve customer satisfaction and demand, but they never got the efficiency right, and so the whole business just never worked at scale.

**中文翻译:**
这里面有三个核心概念：需求（Demand）、满意度（Satisfaction）和效率（Efficiency）。我认为效率特别值得强调，因为大多数人在定义 PMF 时会忽略这一点。人们通常会说：“哦，这是一款产品，人们喜欢它，这很好，这就是 PMF。”但你看，有些产品，比如我是 WeWork 的忠实客户，我也喜欢 Casper 等产品。这些产品成功实现了客户满意度和需求，但它们从未解决效率问题，因此整个业务在规模化时根本行不通。

---

### [00:18:18] Todd Jackson

**English:**
And my partner, Brett Berson, at First Round, he gives this example of the $100 vending machine, and I really like this example, which is imagine I built a vending machine and I stuck it in the middle of San Francisco. And you walk up to this vending machine and you put a dollar in and $100 bill comes out. And that's the product. That would have insane demand. There would be a line at that vending machine. I think people would be extremely satisfied. They'd be like, "This is awesome." The retention would be very good. I'm sure they would come back tomorrow. But the whole thing is it's ridiculous. The whole metaphor is ridiculous because it's just not viable to do something like that.

**中文翻译:**
我在 First Round 的合伙人 Brett Berson 举过一个“100 美元自动售货机”的例子，我非常喜欢这个例子：想象一下我造了一台自动售货机，放在旧金山市中心。你走过去，投入 1 美元，它就吐出一张 100 美元的钞票。这就是产品。这会有疯狂的需求，售货机前会排起长队。我想人们会非常满意，觉得“这太棒了”。留存率也会非常好，我敢肯定他们明天还会再来。但整件事是荒谬的，这个比喻之所以荒谬，是因为这样做根本无法持续。

---

### [00:18:59] Todd Jackson

**English:**
And yet you see a lot of startups kind of do this. They're basically with their products, giving away $2 for $1 and it gets them pretty far. But that's not real product-market fit. And so that's one of the reasons that we think efficiency and how you think about the economic model of what you're doing is very important. And then this other aspect that I like, which is we have this concept that we call the marginal customer, and the next incremental customer you're going to get for your company, for your product. And if you have product-market fit, and as you are progressing along this journey, the marginal customer should be getting easier and easier and easier to get, easier to acquire them, easier to give them good service with a good product.

**中文翻译:**
然而，你会看到很多初创公司就在做这种事。他们基本上是在用产品以 1 美元的价格卖出 2 美元的价值，这能让他们走得很远。但这并不是真正的 PMF。这就是为什么我们认为效率以及你如何思考业务的经济模型非常重要的原因之一。另一个我喜欢的方面是我们称之为“边际客户”（Marginal customer）的概念，即你为公司或产品获取的下一个新增客户。如果你拥有 PMF，并且正在这一旅程中前进，那么获取边际客户应该变得越来越容易——更容易获取他们，更容易用好的产品为他们提供好的服务。

---

### [00:19:42] Todd Jackson

**English:**
And that means your efficiency is increasing along the way and your product-market fit is strengthening. So you've got to have all three of those things: demand, satisfaction, efficiency. But the interesting thing is that you don't go for all three of them at once from the very beginning. And so product-market fit, it happens in the sequence of levels, it happens over multiple years. And for the best enterprise companies, I would say they tend to reach extreme product-market fit in roughly four to six years. There's some variance, but roughly four to six years. And so we label these four levels. We say level one product-market fit is nascent product-market fit. Level two is developing, level three is strong, and level four is extreme. And that's where you want to get.

**中文翻译:**
这意味着你的效率在过程中不断提高，你的 PMF 也在不断加强。所以你必须同时具备这三点：需求、满意度和效率。但有趣的是，你并不是从一开始就同时追求这三点。PMF 是按等级顺序发生的，跨越多年。对于最优秀的企业服务公司，我可以说他们通常在大约四到六年内达到极致 PMF。虽然会有差异，但大致是四到六年。因此我们将这四个等级标记为：第一级是萌芽期 PMF，第二级是发展期，第三级是强劲期，第四级是极致期。这就是你想达到的目标。

---

### [00:20:26] Todd Jackson

**English:**
Along the way, you're trading off these three dimensions: satisfaction, demand, and efficiency because they're intertwined. You could spend a bunch of money on marketing, and that's going to increase your demand, but you're decreasing your efficiency if you do that. You can invest a bunch in efficiency and automating a whole bunch of stuff, but that actually might harm the customer experience and you're reducing satisfaction. So that's an interesting thing, I think, is you're actually making trade-offs at each level and what you should optimize for at each level is different. And so we talk about all these signs, whether you're getting stuck at a given level, how do you get unstuck and how do you progress along this path.

**中文翻译:**
在这个过程中，你需要在满意度、需求和效率这三个维度之间进行权衡，因为它们是交织在一起的。你可以花大笔钱做营销，这会增加需求，但会降低效率。你可以投入大量资金提高效率并实现自动化，但这可能会损害客户体验，降低满意度。所以有趣的是，你在每个级别都在做权衡，每个级别应该优化的重点也不同。我们会讨论所有这些迹象：你是否卡在了某个级别，如何摆脱困境，以及如何沿着这条路径前进。

---

### [00:21:01] Lenny Rachitsky

**English:**
Amazing. And we're going to go through each of these. And the idea, as a listener, what I'm thinking is you're probably in one of these buckets. What we're trying to do is help you out of that bucket and help you move further up the ladder to the next level. So just to summarize, I have my notes here. So there's essentially four levels of product-market fit, basically, the strength of product-market fit that you have: nascent, developing, strong, extreme.

**中文翻译:**
太棒了。我们将逐一讨论这些。作为听众，我想你可能正处于其中一个阶段。我们要做的是帮你跳出那个阶段，帮你向更高一级迈进。总结一下，我这里有笔记：PMF 基本上有四个等级，代表了你拥有的 PMF 强度：萌芽期、发展期、强劲期和极致期。

---

### [00:21:24] Todd Jackson

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:21:25] Lenny Rachitsky

**English:**
Okay. And then you have three dimensions within each of these levels: satisfaction, demand, and efficiency. We're going to talk about what all these mean and how you use these. Let's talk about level one, nascent product-market fit. What does that look like? What do you do when you're there if you're stuck? And what are some examples of companies that felt nascent product-market fit?

**中文翻译:**
好。在每个等级中，你都有三个维度：满意度、需求和效率。我们将讨论这些维度的含义以及如何使用它们。让我们先聊聊第一级：萌芽期 PMF。它看起来是什么样的？如果你卡在那里该怎么办？有哪些公司经历过萌芽期 PMF 的例子？

---

### [00:21:44] Todd Jackson

**English:**
Yeah. Okay, level one, nascent. So at this point, you're probably like a pre-seed or seed stage company. You've got less than 10 people on your team. And at level one, your job is to find three to five customers that have a particular problem that is worth solving and to deliver them a satisfying solution. And you got to pick a problem that is both important and urgent to them.

**中文翻译:**
好的，第一级，萌芽期。在这个阶段，你可能是一家种子前轮（Pre-seed）或种子轮公司，团队人数不到 10 人。在第一级，你的任务是找到 3 到 5 个面临特定且值得解决的问题的客户，并为他们提供满意的解决方案。你必须选择一个对他们来说既重要又紧急的问题。

---

### [00:22:08] Todd Jackson

**English:**
And the solution that you deliver needs to satisfy some kind of promise that they care deeply about. So of the three dimensions that you just recapped, Lenny, it's satisfaction first, demand second, efficiency last when you're at level one. It's actually okay to be inefficient at this stage if it helps you uncover something that delivers an insanely good customer satisfaction. And so I think that one of the best examples I can think of that is this company called Vanta.

**中文翻译:**
你提供的解决方案需要兑现某种他们深切关注的承诺。所以，Lenny，在你刚才总结的三个维度中，第一级是：满意度第一，需求第二，效率最后。在这个阶段，如果低效率能帮你发现一些能带来极佳客户满意度的东西，那是完全可以接受的。我想到的最好的例子之一就是 Vanta。

---

### [00:22:37] Lenny Rachitsky

**English:**
Love Vanta. Also, a happy sponsor and I'm an investor. What a great example.

**中文翻译:**
我喜欢 Vanta。它也是本播客的赞助商，而且我是它的投资者。真是个绝佳的例子。

---

### [00:22:42] Todd Jackson

**English:**
What a great example. So Vanta was founded in 2016 by Christina Cacioppo, and she had come from Dropbox and we got to work at Dropbox together, which was awesome. She was the PM of Dropbox Paper at that time. And so Vanta, it's a company that does compliance automation, continuous monitoring. And most startups think of Vanta is how you get a SOC 2, but they didn't do that at first.

**中文翻译:**
确实是个好例子。Vanta 由 Christina Cacioppo 于 2016 年创立，她来自 Dropbox，我们曾在 Dropbox 共事过，那段经历很棒。当时她是 Dropbox Paper 的产品经理。Vanta 是一家做合规自动化和持续监控的公司。大多数初创公司认为 Vanta 是获取 SOC 2 认证的工具，但他们起初并不是做这个的。

---

### [00:23:03] Todd Jackson

**English:**
And I remember in 2018, Christina and I went on a walk around the South Park neighborhood in San Francisco. And this was the first time I heard the idea of Vanta. And she had actually, in 2016, 2017, tried a few other ideas. She had this smart speaker that would record meetings and it would send meeting summaries over Slack.

**中文翻译:**
我记得在 2018 年，Christina 和我在旧金山的南公园（South Park）附近散步，那是我第一次听说 Vanta 的构思。实际上，她在 2016、2017 年尝试过其他几个想法。她曾做过一个智能音箱，可以记录会议并通过 Slack 发送会议摘要。

---

### [00:23:24] Lenny Rachitsky

**English:**
B2B Alexa is what she called it. I remember.

**中文翻译:**
她管它叫“B2B 版 Alexa”。我记得。

---

### [00:23:25] Todd Jackson

**English:**
B2B Alexa. And she had this other idea, something about dropshipping, but she didn't know anything about dropshipping. And she had just been in this mode of like, "We're building stuff and then we're seeing if anybody wants it." And then she realized that wasn't working and she changed what she was doing. And she started talking to potential customers, and she was very interested in the idea of security and why a lot of startups didn't use any security products.

**中文翻译:**
B2B Alexa。她还有过另一个关于代发货（Dropshipping）的想法，但她对代发货一无所知。她当时一直处于“我们先造出东西，再看有没有人想要”的模式。后来她意识到这行不通，于是改变了做法。她开始与潜在客户交谈，她对安全领域以及为什么很多初创公司不使用任何安全产品非常感兴趣。

---

### [00:23:48] Todd Jackson

**English:**
And she was talking to security engineers and CISOs and just CTOs and startups. And she would ask them, "What is the thing you hate most about your job as it relates to security?" And over and over and over they would say, "I hate filling out the security questionnaires. I hate doing the compliance audits. It's so much grungy manual work. I'm in there filling out spreadsheets and taking screenshots of my AWS account. And the whole thing just doesn't make sense." And she had actually felt this herself when she was on Dropbox Paper and the experience of getting a SOC 2 was onerous.

**中文翻译:**
她与安全工程师、首席信息安全官（CISO）以及初创公司的 CTO 们交谈。她会问他们：“在安全相关的工作中，你最讨厌什么？”他们一遍又一遍地回答：“我讨厌填写安全问卷。我讨厌做合规审计。那有太多肮脏的体力活了。我得不停地填电子表格，给我的 AWS 账户截图。整件事简直不可理喻。”她在负责 Dropbox Paper 时也亲身感受过这一点，当时获取 SOC 2 认证的过程极其繁琐。

---

### [00:24:26] Todd Jackson

**English:**
And the reason that she needed to get it is because we wanted to start selling Dropbox Paper into enterprise. And so she said to me, "There's this pain out there, I think I can solve it, and I think there might be a revenue unlock." And I was like, "What do you mean by that?" And she was like, "Well, I've got these first few customers or design partner, pseudo customers. It's Segment and Front and Figma." And this is 2017, '18. So these companies were smaller at the time, not the big companies they are now. And she was like, "Yeah, they're trying to sell into Fortune 500 companies. One of them is actually trying to land a Fortune 10 right now. And they said the thing that's holding them back is they don't have compliance certification, they don't have a SOC 2.

**中文翻译:**
她之所以需要这个认证，是因为我们想开始向企业销售 Dropbox Paper。于是她对我说：“外面有这种痛点，我觉得我能解决，而且我认为这可能会解锁收入。”我问：“你这是什么意思？”她说：“我有第一批客户，或者说设计合作伙伴、准客户，比如 Segment、Front 和 Figma。”那是 2017、2018 年，这些公司当时规模还比较小，不像现在这么大。她说：“是的，他们正试图向财富 500 强公司销售产品，其中一家甚至在争取一家财富 10 强的客户。他们说阻碍成交的原因是他们没有合规认证，没有 SOC 2。”

---

### [00:25:08] Todd Jackson

**English:**
"And I told them, 'Hey, what if I do that for you?' And they were like, 'Oh, you can just do that?'" And she was like, "Yeah." And she did it, and they landed the deal. And it's one of the clearest examples to me of a product that satisfies a promise, but this product is going to unlock revenue for you. You are going to be able to land this enterprise deal. And so I think they just did a phenomenal job of that. And that's what you're looking for when you're at level one, a problem that really matters to three to five customers.

**中文翻译:**
“我告诉他们：‘嘿，如果我帮你们搞定这个呢？’他们说：‘噢，你真的能搞定？’她说：‘是的。’”她做到了，他们也谈成了生意。对我来说，这是最清晰的例子之一：一个产品兑现了一个承诺，而这个承诺能为你解锁收入——让你能够谈成这笔企业级交易。我认为他们在这一点上做得非常出色。这就是你在第一级所寻找的东西：一个对 3 到 5 个客户来说真正重要的问题。

---

### [00:25:41] Lenny Rachitsky

**English:**
That specific example, I think she delivered a spreadsheet. There was no product, she just manually filled out a spreadsheet and gave it to them.

**中文翻译:**
在那个具体的例子中，我记得她交付的是一个电子表格。当时根本没有产品，她只是手动填好表格然后交给他们。

---

### [00:25:49] Todd Jackson

**English:**
Completely manual. She was the one behind the email address posing as the AI, but doing it herself. And I think that's revealing of it's okay to be inefficient at level one, as long as you are delivering incredible satisfaction.

**中文翻译:**
完全是手动的。她躲在电子邮件地址后面假装是 AI，其实是自己在干活。我认为这说明了在第一级，低效率是可以接受的，只要你能提供极高的满意度。

---

### [00:26:03] Lenny Rachitsky

**English:**
Yeah, I was just going to say that. This is the ultimate example of efficiency is not important, which I love, is what you're pointing out at this step. I know you're going to share another example, but just to summarize what this stage feels like from earlier when you talked about, essentially, of less than 10 people, you're trying to find three to five customers. I think that's so important. You're not trying to find tens or hundreds, you're just like, "Three to five people." And the customer element, I imagine, you're implying they're paying you money.

**中文翻译:**
是的，我正想说这个。这是“效率不重要”的终极案例，我非常喜欢你在这一步指出的这一点。我知道你还要分享另一个例子，但先总结一下这个阶段的感觉：正如你之前提到的，团队不到 10 人，你正试图寻找 3 到 5 个客户。我觉得这非常重要——你不是在找几十个或几百个，只是“3 到 5 个人”。而且关于客户这个要素，我想你的意思是他们得付你钱。

---

### [00:26:29] Todd Jackson

**English:**
Yes, they're paying you money and you're delivering a product that solves a problem for them.

**中文翻译:**
是的，他们付你钱，而你交付一个能为他们解决问题的产品。

---

### [00:26:33] Lenny Rachitsky

**English:**
And the product could be potentially a spreadsheet or super Wizard of Oz at this point even.

**中文翻译:**
而且在这个阶段，产品甚至可能只是一个电子表格，或者是超级“绿野仙踪”式的（人工伪装自动化）。

---

### [00:26:37] Todd Jackson

**English:**
Yeah, that's okay at this level.

**中文翻译:**
是的，在这个级别没问题。

---

### [00:26:39] Lenny Rachitsky

**English:**
I know RAMP actually had barely a product when they started selling. Initially, they had someone just updating things behind the scenes on these dashboards. And then you talked about the problem needs to be important and urgent, which connects to people paying attention to a startup that they don't trust or know anything about because the problem is that important and urgent. And you also mentioned it has to satisfy a promise you're giving them, "We'll solve SOC 2 for you," and then you actually accomplish that.

**中文翻译:**
我知道 RAMP 在开始销售时也几乎没有产品。最初，他们只是让人在后台手动更新仪表盘上的数据。接着你提到问题必须是重要且紧急的，这解释了为什么人们会关注一家他们不信任、甚至一无所知的初创公司，因为那个问题实在太重要、太紧急了。你还提到它必须兑现你给他们的承诺，比如“我们会为你解决 SOC 2 问题”，然后你确实做到了。

---

### [00:27:03] Todd Jackson

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:27:03] Lenny Rachitsky

**English:**
Is there anything else maybe as a benchmark that tells you you're at this step of product-market fit?

**中文翻译:**
还有什么其他的基准可以告诉人们正处于 PMF 的这个阶段吗？

---

### [00:27:10] Todd Jackson

**English:**
Yeah. So like I said, you're pre-seed less than 10 people. Probably, your demand source at this stage is mostly people you know. It's friends and family, it's your network, maybe it's VCs. You haven't probably done a lot of cold outreach at this point, and it's hard to find customers. You're trying to get three to five. It probably takes you 20 warm intros to get one, something along those lines. So maybe to get to three to five, it's at least 50 conversations. That's very normal at this stage because you're just trying to find the right problem and find customers who have it. You're probably in the $0 to 500K ARR, somewhere in that zone. I would say that you're at level one.

**中文翻译:**
有的。就像我说的，你是种子前轮，不到 10 人。在这个阶段，你的需求来源可能大多是你认识的人：朋友、家人、你的人脉，或者是风投。此时你可能还没做太多的冷启动外联（Cold outreach），而且很难找到客户。你正努力争取 3 到 5 个客户，可能需要 20 个熟人介绍才能成交一个。所以要得到 3 到 5 个客户，至少需要 50 次谈话。在这个阶段这很正常，因为你只是在寻找正确的问题和拥有该问题的客户。你的 ARR（年度经常性收入）可能在 0 到 50 万美元之间。我会说这就是第一级。

---

### [00:27:48] Todd Jackson

**English:**
And then there are metrics to track efficiency, things like burn multiple, gross margin, NRR all of these things. All of them are just not applicable at this stage. It's too early and you shouldn't be worrying about that stuff. And so you want to be feeling this sense of progress that there are customers who need what you are building and the thing you're building works. And so conversely, the signs that we see a lot of founders get stuck, and this is a very common level to get stuck. And so if you're hanging out here for six months, nine months, 12 months, and there's yellow flags that are appearing, you're starting to feel stuck.

**中文翻译:**
至于衡量效率的指标，比如烧钱倍数（Burn multiple）、毛利率、NRR（净收入留存率）等等，在这个阶段都不适用。现在还太早，你不该担心这些。你应该感受到一种进展感，即有客户需要你正在构建的东西，而且你构建的东西确实有效。反过来说，我们看到很多创始人卡在这里，这是非常常见的卡壳阶段。如果你在这里徘徊了 6 个月、9 个月甚至 12 个月，并且出现了一些黄牌警告，你就开始感到被困住了。

---

### [00:28:24] Todd Jackson

**English:**
And so the yellow flags are something like, let's say, your product disappeared overnight, your customers wouldn't be super disappointed. Let's say you have a handful of happy customers. Let's say you've got four or five customers, but the most important feature is actually different for each one of them. That starts to look a little bit more like a consulting business than a product business. Or it just feels incredibly hard to find the marginal customer, the next new customer. Or your usage is low. The product is in their hands, but the usage is low, it's not growing that much. It lasts for six months.

**中文翻译:**
这些黄牌警告包括：比如，如果你的产品一夜之间消失了，你的客户并不会感到非常失望。或者，虽然你有几个满意的客户，比如 4 到 5 个，但对他们每个人来说，最重要的功能竟然都不一样——这看起来更像咨询业务而非产品业务。再或者，获取边际客户（即下一个新客户）感觉异常艰难。又或者，使用率很低——产品在他们手里，但使用率不高，增长也不明显，这种情况持续了半年。

---

### [00:28:55] Todd Jackson

**English:**
And I think, there's a really good example, Jack Altman, who's the founder of Lattice, he founded Lattice in 2015. We've talked to him a bunch on the First Round Paths to Product-Market Fit and other things. So for those who don't know, Lattice is a people management platform, but it didn't start that way. And most people don't know about this, Lattice actually started as an OKR tool back in 2015.

**中文翻译:**
我想到了一个很好的例子，Lattice 的创始人 Jack Altman，他在 2015 年创办了 Lattice。我们在《First Round Paths to Product-Market Fit》等节目中多次采访过他。对于那些不了解的人，Lattice 现在是一个人力管理平台，但它起初并不是这样的。大多数人不知道，Lattice 在 2015 年其实是从一个 OKR 工具起步的。

---

### [00:29:15] Lenny Rachitsky

**English:**
Oh, didn't know.

**中文翻译:**
噢，我还真不知道。

---

### [00:29:16] Todd Jackson

**English:**
Yeah. And so Jack had just seen this at other companies. He's like, "Okay, companies are doing OKRs, but they're not very good at it and it causes a lot of arguments among the executive team and employees are noncompliant. They think the whole thing's dumb. So I can fix that with software." And so the original version of Lattice was for managing OKRs. And he was able to sell it. And so his buyer was the head of HR, and they said, "Okay, yeah, we'll give this a shot." And he had a couple companies using it, and they would use it for one quarter. And then the next quarter would come around, and they were like, "Didn't go that well last time. I don't know, the employees don't seem to like it. I don't know."

**中文翻译:**
是的。Jack 在其他公司见过这种情况，他觉得：“好吧，公司都在推行 OKR，但做得并不好，这导致管理层之间有很多争论，员工也不配合，觉得整件事很蠢。我可以用软件来解决这个问题。”所以 Lattice 的最初版本是用来管理 OKR 的。他成功卖出去了，买家是人力资源负责人，他们说：“好吧，我们试试看。”他有几家公司在用，他们用了一个季度。到了下一个季度，他们说：“上次效果不太好。我不知道，员工们似乎不太喜欢。我也拿不准。”

---

### [00:29:59] Todd Jackson

**English:**
And then the quarter after that, they were like, "No, we're not buying this, we're not using this." And so Jack pulled off the pivot to people management. And the way that he did it was he actually kept the persona. And so this gets into the ideas of the four Ps, and I'll talk about this a little bit more. This is our version of the four Ps. You've got the persona, the problem, the promise, and the product. And all four of these things have to line up. Your product has to deliver a promise that solves the problem of your persona. And so Jack actually kept the persona. He was like, "I've gotten to know these heads of HR really well over the last six to nine months. I text with them, I go out to coffee with them, I'm friends with them, I know them really well. This OKR thing just doesn't seem to be a big deal for them, but they've got other problems that I could look at solving."

**中文翻译:**
再过一个季度，他们就说：“不，我们不买了，也不用了。”于是 Jack 完成了向人力管理的转型。他转型的方式其实是保留了“用户画像”（Persona）。这涉及到了“四个 P”的概念，我再详细说一下。这是我们版本的四个 P：用户画像（Persona）、问题（Problem）、承诺（Promise）和产品（Product）。这四件事必须对齐：你的产品必须兑现一个承诺，从而解决你目标画像的问题。Jack 保留了画像，他觉得：“在过去的六到九个月里，我已经非常了解这些 HR 负责人了。我跟他们发短信，一起喝咖啡，成了朋友。OKR 这件事对他们来说似乎不是什么大事，但他们还有其他我可以尝试解决的问题。”

---

### [00:30:53] Todd Jackson

**English:**
And the interesting thing was that timing, it was mid-2010s, performance management had started to come back in favor. It was like this pendulum. There was a period of time where performance management was really important, and then all these companies were like, "We're not doing this anymore." And then the pendulum swung back, and around 2015, 2016 was that time. And so Jack literally showed them Figma mock-ups. There was no product, but he's like, "What if I could solve performance management for you in a way that is much more modern and much more employee-friendly and manager-friendly and the whole thing's just going to work better?"

**中文翻译:**
有趣的是时机，那是 2010 年代中期，绩效管理（Performance management）开始重新受到青睐。这就像一个钟摆：曾有一段时间绩效管理非常重要，后来所有公司都说“我们不再搞这个了”，接着钟摆又荡了回来，2015、2016 年正是那个时候。Jack 直接给他们看了 Figma 原型图。当时根本没有产品，但他问：“如果我能以一种更现代、对员工和经理都更友好、整体运作更顺畅的方式帮你解决绩效管理问题呢？”

---

### [00:31:25] Todd Jackson

**English:**
And the response was off the charts. And people wanted this thing. And I believe he sold his first five or 10 customers with Figma mock-ups. Before, he hadn't built anything really. And so that, I think, is an interesting example of he was stuck in the zone of people didn't love what he was doing. He kept the persona, but he changed the problem that he was solving and the promise he was delivering through the product. And we do a whole section on pivots and when to pivot and how to pivot. And I think this is actually the best framework for this, is the four Ps. Lattice kept the first one but changed the others. Vanta changed all four.

**中文翻译:**
反应非常热烈，人们想要这个东西。我相信他是靠着 Figma 原型图卖出了前 5 到 10 个客户。在那之前，他其实什么都没造出来。我认为这是一个有趣的例子：他曾卡在“人们并不爱他的产品”的区域。他保留了用户画像，但改变了他要解决的问题以及通过产品交付的承诺。我们有一个专门讨论转型、何时转型以及如何转型的章节。我认为“四个 P”是处理转型的最佳框架。Lattice 保留了第一个 P，改变了其他三个；Vanta 则把四个全改了。

---

### [00:32:08] Todd Jackson

**English:**
There are other products like Plaid that actually kept elements of the product they were doing. So I don't know if you know the story of Plaid, but Zach Perret was building... Plaid started out not as like a API for bank accounts. It started out as a consumer budgeting app. It was a consumer app. And it just was supposed to help you save money and budget and stuff. And it just wasn't that popular. And the founders were frustrated, but they had built this part of the product that enabled the app to connect to your bank accounts, and had solved all the nitty-gritty issues with that. And then they found that their friends wanted to license it from them.

**中文翻译:**
还有像 Plaid 这样的产品，它们保留了正在开发的产品中的某些元素。我不知道你是否听过 Plaid 的故事，Zach Perret 最初做的并不是银行账户 API。Plaid 起初是一款面向消费者的记账应用。它是一款消费级应用，旨在帮助你省钱、做预算等等。但它并不怎么受欢迎。创始人很沮丧，但他们已经开发出了产品中能够让应用连接到银行账户的部分，并解决了其中的所有细节问题。后来他们发现，他们的朋友想向他们购买这部分的授权。

---

### [00:32:46] Todd Jackson

**English:**
So Zach had a friend at Venmo who wanted to license this, and they got Robinhood at some point, they got Coinbase at some point. So that's an example of they actually kept a lot of the code that they had written. They kept the product, but they completely changed the other three Ps. Instead of solving for consumers who have a problem with budgeting, we are going to solve for developers at fintech companies who have a problem connecting to bank accounts. And it was a total flip of the four Ps. But that's why I really like this framework because I think it really helps founders think in a structured way about this.

**中文翻译:**
Zach 在 Venmo 的一个朋友想获得这个授权，后来他们又拿下了 Robinhood 和 Coinbase。这就是一个例子：他们实际上保留了大量已经写好的代码，保留了产品，但完全改变了其他三个 P。不再是为有预算问题的消费者解决问题，而是为金融科技公司的开发者解决连接银行账户的问题。这是对四个 P 的彻底翻转。这就是为什么我非常喜欢这个框架，因为它能帮助创始人以结构化的方式思考这些问题。

---

### [00:33:15] Lenny Rachitsky

**English:**
Todd, this is amazing. I'm so happy we're doing this. I think this is going to help a lot of people. I want to move on to level two, but first let me try to summarize some of these key elements. So these four Ps is essentially what you should try to change if you're stuck in this level or any level. And just to summarize, you can change who you're targeting, the persona, you can change the problem you're solving, you could change the way you're pitching it, which is the promise is how you describe it, basically positioning. And then you could also just change your product. You mentioned Vanta changed all four, some companies change just one. Any advice for how to know which of these to change? What points you to change this versus change that? Is there anything that you've seen?

**中文翻译:**
Todd，这太棒了。我很高兴我们能聊这个，我相信这会帮助很多人。我想进入第二级，但首先让我尝试总结一下这些关键要素。这“四个 P”基本上就是如果你卡在这一级或任何一级时应该尝试改变的东西。总结一下：你可以改变你的目标受众（用户画像），改变你正在解决的问题，改变你推销它的方式（承诺，即你如何描述它，基本上就是定位），最后你也可以直接改变产品。你提到 Vanta 改了全部四个，有些公司只改了一个。关于如何判断该改哪一个，你有什么建议吗？是什么指引你改这个而不是改那个？你见过什么规律吗？

---

### [00:33:55] Todd Jackson

**English:**
I think different founders approach this differently. And I've seen a lot of founders who are build first and then sell, and I've seen a lot of founders who are sell first and then build. And they can both work. I tend to gravitate towards the, "I want to sell it before I build it," because I really want the signal from customers and I want that to be the guide and the oxygen that drives what I'm building. I find that very motivating. I also find it easier, honestly.

**中文翻译:**
我认为不同的创始人有不同的处理方式。我见过很多创始人是“先造后卖”，也见过很多是“先卖后造”。这两种方式都行得通。我个人更倾向于“在造之前先卖”，因为我非常渴望得到客户的信号，我希望那能成为指引和驱动我构建产品的氧气。我觉得这非常有动力，而且坦白说，我觉得这样更容易。

---

### [00:34:25] Todd Jackson

**English:**
Rather than guessing like, "Oh, I'm going to write 50,000 lines of code and then see if somebody wants this thing," I think it's better to talk to a bunch of customers, know that, "Hey, if I had this thing, if I could build this thing, I know it would sell. I know these people want this thing." So I tend to approach it from that point of view and therefore, I focus on the persona and the problem and the promise. What is the promise that is really going to click for that buyer, for that persona? And then the product's job is to satisfy those first three Ps really.

**中文翻译:**
与其瞎猜“噢，我要写 5 万行代码，然后看看有没有人想要这玩意儿”，我认为更好的做法是去和一群客户聊聊，确定“嘿，如果我有这个东西，如果我能造出这个东西，我知道它能卖出去。我知道这些人想要这个”。所以我倾向于从这个角度切入，因此我会专注于用户画像、问题和承诺。什么样的承诺能真正打动那个买家、那个画像？然后，产品的任务其实就是去满足前三个 P。

---

### [00:34:55] Lenny Rachitsky

**English:**
And obviously, those are much easier to change and play with versus rebuilding your product. So if nothing else, you should probably start there. I actually have a post with a bunch of awesome examples of changing the positioning, changing the persona, and so we'll link to that in show notes if people want more examples. Finally, let me try to summarize the stage. So I think it's important to note at this nascent stage, it's not roaring product-market fit. It's, as you described, very nascent. You're getting customers, but it's hard. You said it's 20 introductions to one sale, but you're getting them.

**中文翻译:**
显然，改变前三个 P 比重新开发产品要容易得多。所以，至少你应该从那里开始。我其实发过一篇文章，里面有很多关于改变定位、改变画像的绝佳例子，如果大家想要更多案例，我们会把链接放在节目简介里。最后，让我试着总结一下这个阶段。我觉得重要的一点是，在萌芽阶段，PMF 并不是那种“势如破竹”的状态。正如你所描述的，它非常稚嫩。你能获得客户，但过程很艰难。你说过大约 20 个介绍才能成交一单，但你确实在成交。

---

### [00:35:25] Lenny Rachitsky

**English:**
I know Retool has a great quote. David has this quote of, "Every customer he got early on, he felt it was the last customer he was ever going to get. No more people want this thing and it's always a struggle." So I think that's very normal, is what you're describing. The beginnings are rarely off and to the right. And it's okay if this takes a while. You said that if you spent 12 months at this stage, you're probably stuck in the stage, and signs that you're stuck in this nascent stage versus this is actually normal. Signs you mentioned are if you ask people if this went away and they wouldn't be disappointed, they'd be like, "Nah, all right. It's cool."

**中文翻译:**
我知道 Retool 有句名言，David 说过：“早期获得的每一个客户，他都觉得那是他能得到的最后一个客户。再也不会有人想要这东西了，每一步都是挣扎。”所以我认为你所描述的情况非常正常。起步阶段很少是一帆风顺、一路向上的。如果这需要一段时间，也没关系。你说过如果你在这个阶段待了 12 个月，你可能就卡住了。判断是“卡在萌芽期”还是“处于正常起步期”的迹象包括：如果你问人们如果这个产品消失了会怎样，他们如果不感到失望，只是说“噢，好吧，没关系”，那就是个信号。

---

### [00:36:01] Lenny Rachitsky

**English:**
You have many customers, but they're using different features of the product. So to you, the way you described it, essentially, you're professional services for them. You're not actually building a product. You consult a lot of people. And then they're actually not using it often. They're buying, they're paying for it, like the last example, but they're not necessarily using it and they're going to churn pretty quickly.

**中文翻译:**
或者你有很多客户，但他们使用的产品功能各不相同。所以对你来说，正如你描述的，你本质上是在为他们提供专业服务，而不是在构建产品，你更像是在为很多人做咨询。还有就是他们实际上并不经常使用它。他们买了，也付了钱（就像上一个例子），但不一定在用，而且很快就会流失。

---

### [00:36:19] Todd Jackson

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:36:20] Lenny Rachitsky

**English:**
Anything else you wanted to touch on there before we get to level two?

**中文翻译:**
在进入第二级之前，还有什么想补充的吗？

---

### [00:36:23] Todd Jackson

**English:**
The last thing that I'd add at level one is there's this founder from a company called Persona, his name is Rick Song. He's super awesome. Persona is a First Round company. They do identity verification. And Rick's analogy, I just love it for level one, is you don't want to get friend-zoned by your customers, where your customers like you, but they don't love you and they don't need you. And he was super paranoid about this in the early days of Persona. And his technique for doing this, which I really like, is super simple, was he was very close with his first five or 10 customers.

**中文翻译:**
在第一级我想补充的最后一件事是，有一家叫 Persona 的公司的创始人 Rick Song，他非常出色。Persona 是 First Round 投资的公司，做身份验证。Rick 有个关于第一级的比喻我非常喜欢：你不想被客户“发好人卡”（Friend-zoned），即客户喜欢你，但不爱你，也不需要你。在 Persona 早期，他对此非常偏执。他处理这件事的方法我非常喜欢，而且超级简单：他与前 5 到 10 个客户保持非常紧密的关系。

---

### [00:37:00] Todd Jackson

**English:**
And he would go to them and sit them down one-on-one and say, "I need your help. It is very important to me that this company succeeds and does not fail. So I don't want you to be nice to me. I want you to tell me is Persona a necessity for your company? If we went away, how painful would that be? If a competitor came along that charged half as much as us, would you switch to them?" And he's really trying to get to the essence of: is Persona critical for you or am I in the friend zone? And I just think that's a really great way of thinking about this.

**中文翻译:**
他会去找他们，一对一地坐下来谈，说：“我需要你的帮助。这家公司能否成功对我来说至关重要。所以请不要对我客气。我想请你告诉我，Persona 对你的公司来说是必需品吗？如果我们消失了，会有多痛苦？如果出现一个价格只有我们一半的竞争对手，你会换成他们吗？”他是在试图触及本质：Persona 对你来说是关键的，还是我只是在你的“好人区”里？我认为这是一种非常棒的思考方式。

---

### [00:37:35] Lenny Rachitsky

**English:**
I love that story. It's like in a relationship, it's the talk.

**中文翻译:**
我喜欢这个故事。就像在一段感情里，双方要“摊牌”谈谈。

---

### [00:37:37] Todd Jackson

**English:**
It's the talk.

**中文翻译:**
就是摊牌。

---

### [00:37:38] Lenny Rachitsky

**English:**
"Are we a thing?" I love that. That's so good. The sooner you know the truth, the better. And it's hard to hear bad news, but I love that, just advice of just sit them down one-on-one. Let me tell you about CommandBar. If you're like me and most users I've built product for, you probably find those little in-product pop-ups really annoying, "Want to take a tour?" "Check out this new feature." And these pop-ups are becoming less and less effective since most users don't read what they say. They just want to close them as soon as possible.

**中文翻译:**
“我们这算是在交往吗？”我喜欢这个。太棒了。越早知道真相越好。虽然听坏消息很难受，但我喜欢这个建议，就是找他们一对一坐下来谈。让我来介绍一下 CommandBar。如果你像我以及我曾为其开发产品的多数用户一样，你可能会觉得那些应用内弹窗非常烦人，比如“要来个导览吗？”“看看这个新功能”。这些弹窗正变得越来越低效，因为大多数用户根本不看内容，只想尽快关掉它们。

---

### [00:38:08] Lenny Rachitsky (Sponsor: CommandBar)

**English:**
But every product builder knows that users need help to learn the ins and outs of your product. We use so many products every day and we can't possibly know the ins and outs of everyone. CommandBar is an AI-powered toolkit for product growth, marketing and customer teams to help users get the most out of your product without annoying them. They use AI to get closer to user intent. So they have search and chat products that let users describe what they're trying to do in their own words, and then see personalized results like customer walkthroughs or actions.

**中文翻译:**
但每个产品构建者都知道，用户需要帮助来了解产品的方方面面。我们每天使用这么多产品，不可能了解每一个产品的细节。CommandBar 是一个由 AI 驱动的工具包，供产品增长、营销和客户团队使用，旨在帮助用户充分利用你的产品，同时又不打扰他们。他们利用 AI 来更贴近用户意图。他们拥有搜索和聊天产品，让用户可以用自己的语言描述想做的事情，然后看到个性化的结果，如客户操作指南或具体动作。

---

### [00:38:36] Lenny Rachitsky (Sponsor: CommandBar)

**English:**
And they do pop-ups too, but their nudges are based on in-product behaviors like confusion or intent classification, which makes them much less annoying and much more impactful. This works for web apps, mobile apps and websites, and they work with industry-leading companies like Gusto, Freshworks, HashiCorp and LaunchDarkly. Over 15 million end-users have interacted with CommandBar. To try out CommandBar, you can sign up at commandbar.com/lenny and you can unlock an extra 1,000 AI responses per month for any plan. That's commandbar.com/lenny. Let's talk about level two. So what does level two look like? And what should founders be focusing on when they're in level two?

**中文翻译:**
他们也做弹窗，但他们的“轻推”（Nudges）是基于应用内行为的，比如用户表现出困惑或意图分类，这使得它们不那么烦人，且更具影响力。这适用于 Web 应用、移动应用和网站。他们与 Gusto、Freshworks、HashiCorp 和 LaunchDarkly 等行业领先公司合作。已有超过 1500 万终端用户与 CommandBar 进行过交互。要试用 CommandBar，可以在 commandbar.com/lenny 注册，任何方案都可以每月额外解锁 1000 条 AI 回复。让我们来聊聊第二级。第二级是什么样的？创始人在第二级应该关注什么？

---

### [00:39:19] Todd Jackson

**English:**
Yeah. So level two is developing product-market fit, and your job at level two is now you've got to go from five satisfied customers to 25 satisfied customers. And so now you've got to start thinking about demand in addition to satisfaction. Because it is very hard to just grind your way all the way to 25 customers with sheer willpower, but you can do that to five, maybe 10. And we see some founders who just have phenomenal willpower and grit and grind their way to five or 10 customers. To get to 25 and to get beyond 25, the product has to be doing a lot of the heavy lifting for you. And so that is the essence of this level.

**中文翻译:**
好的。第二级是“发展期 PMF”，你在这一级的任务是从 5 个满意客户增加到 25 个满意客户。所以现在除了满意度，你还必须开始考虑需求。因为仅凭意志力很难一路硬磨到 25 个客户，但磨到 5 个甚至 10 个是有可能的。我们见过一些拥有惊人意志力和毅力的创始人，硬生生磨出了 5 到 10 个客户。但要达到 25 个并超越这个数字，产品本身必须为你承担大部分的重任。这就是这一级的本质。

---

### [00:39:58] Todd Jackson

**English:**
So if you're at this level, now you're seed or Series A style company, maybe you've got up to 20 people at the company. And you're starting to work on this demand source where you have the early signs of a scalable channel, and it's not just warm intros from your VCs or from your friends. You're maybe investing in cold outreach and getting that tuned and humming. You might be investing in content, you might be doing community events, but the whole idea is you're trying to scale the demand source. It's still not easy. A benchmark, we would say, is that your sales conversion without a warm intro is still probably 10%, something like that.

**中文翻译:**
如果你处于这个级别，你现在可能是一家种子轮或 A 轮规模的公司，团队可能有 20 人左右。你开始研究需求来源，出现了可扩展渠道的早期迹象，而不仅仅是来自风投或朋友的熟人介绍。你可能在投入冷启动外联并使其步入正轨。你可能在投入内容创作，或者举办社区活动，核心思想是你在尝试扩大需求来源。这依然不容易。一个基准是：在没有熟人介绍的情况下，你的销售转化率可能仍然只有 10% 左右。

---

### [00:40:38] Todd Jackson

**English:**
First call to close one is around 10%. If you get higher than that, that's great, but that sort of benchmark for this level. You're in anywhere from the 500K to five million ARR zone, that's a hallmark of level two. And you're actually starting to think about efficiency metrics and sales metrics. You might starting to be thinking about magic number, which is a new ARR that you take in in a period divided by the CAC you spend in that period, so something in the 0.5 to 0.75 range. You want to get higher eventually, but that's pretty reasonable for this level.

**中文翻译:**
从第一次通话到成交的转化率大约是 10%。如果能更高那太好了，但这是该级别的基准。你的 ARR 处于 50 万到 500 万美元之间，这是第二级的标志。你实际上开始考虑效率指标和销售指标了。你可能开始考虑“魔法数字”（Magic Number），即某一时期内获得的新 ARR 除以该时期的获客成本（CAC），通常在 0.5 到 0.75 之间。你最终会希望它更高，但对于这个级别来说，这个范围是合理的。

---

### [00:41:10] Todd Jackson

**English:**
You're just starting to think about retention. You've been around for a year, so you've got renewals and you want those renewals renewing. Maybe something like 10%, 20% regretted churn is okay. You don't want to be higher than that, and you want your NRR to be at least 100%. And then things like gross margin and burn multiple, they're still not the focus. Those are the classic efficiency metrics. They're not the focus right now.

**中文翻译:**
你刚开始考虑留存。公司已经成立一年了，所以你有了续约，你希望这些客户能续约。大约 10% 到 20% 的“遗憾流失率”（Regretted churn）是可以接受的，你不希望比这更高。你希望 NRR 至少达到 100%。至于毛利率和烧钱倍数等经典的效率指标，它们现在还不是重点。

---

### [00:41:30] Todd Jackson

**English:**
But we would say you want your gross margin to be not worse than 50%, and you'd want your burn multiple to be not worse than five X. Your burn multiple, by the way, is just how much you burn in a current period versus how much new ARR comes in. So if you burn $5 million and you take in one, then you've got to burn multiple of five. And you don't want to be worse than that at this stage.

**中文翻译:**
但我们会说，你希望毛利率不低于 50%，烧钱倍数不高于 5 倍。顺便说一下，烧钱倍数就是你在当前时期的支出与新增 ARR 的比例。如果你烧了 500 万美元只换来 100 万美元收入，那烧钱倍数就是 5。在这个阶段，你不希望比这更糟。

---

### [00:41:51] Lenny Rachitsky

**English:**
Amazing. There's a lot of these benchmarks which I love. I imagine not everyone's going to hit each of them exactly. These are just rough guidelines of like, "You're probably in this stage if you're in this level," right?

**中文翻译:**
太棒了。这些基准非常有用。我想并不是每个人都能精准达到每一项，这些只是粗略的指导方针，用来判断“如果你处于这个水平，你可能就在这个阶段”，对吧？

---

### [00:42:03] Todd Jackson

**English:**
Yeah, exactly. There's some wide bars around these metrics. It's just representative of, generally, the stage of five to 25 customers.

**中文翻译:**
是的，没错。这些指标有一定的波动范围，它只是代表了拥有 5 到 25 个客户的普遍阶段。

---

### [00:42:10] Lenny Rachitsky

**English:**
I love it. And it's so interesting that people think of product-market fit, as you said, as this binary, "I have it or I don't." And the way you're talking about this is in this level to developing product-market fit, a company has 25 satisfied customers, they're over five million in ARR, a lot of cases they have 20 employees.

**中文翻译:**
我喜欢这个观点。很有趣的是，正如你所说，人们通常把 PMF 看作是非黑即白的——“我有”或者“我没有”。而按照你的说法，在第二级“发展期 PMF”，一家公司已经有了 25 个满意客户，ARR 超过 500 万美元，通常还有 20 名员工。

---

### [00:42:28] Todd Jackson

**English:**
Between 500K and five million. Yeah.

**中文翻译:**
是在 50 万到 500 万美元之间。是的。

---

### [00:42:31] Lenny Rachitsky

**English:**
500K and five million. They have 20 employees. In theory, you would think this is a roaring success. They're killing it, they have all these customers, they're growing. But it's still just level two of product-market fit. So I think this has a really interesting insight, and it reminds me of when I did a bunch of research on product-market fit.

**中文翻译:**
50 万到 500 万。有 20 名员工。理论上，你会认为这已经是非常大的成功了。他们做得风生水起，有这么多客户，还在增长。但即便如此，这仍然只是 PMF 的第二级。我觉得这是一个非常有趣的洞察，这让我想起我做过的一系列关于 PMF 的研究。

---

### [00:42:49] Lenny Rachitsky

**English:**
So many founders are like, "I never felt that product-market fit. I didn't have it. It was always, 'I don't know, maybe when we get to 100 million ARR, I'll really feel like we got this.'" So I think this is a really good reminder that a lot of times you're not actually going to feel so confident this will last, and you're going to get to lasting durable product-market fit. So I think that a really great insight here.

**中文翻译:**
很多创始人会说：“我从未感觉到那种 PMF。我总觉得还没达到。总是在想‘我不知道，也许等我们达到 1 亿 ARR 时，我才会真正觉得我们做到了’。”所以我觉得这是一个很好的提醒：很多时候你实际上并不会感到非常有信心这种状态能持续下去，直到你达到持久稳固的 PMF。这是一个非常棒的见解。

---

### [00:43:12] Todd Jackson

**English:**
Yeah. And the thing that's really, I think, the hallmark of level two is you've got a product that a handful of people like. It's satisfying a critical need for them. Now you've got to open the demand floodgates so that we can get to 25 customers and beyond. And different companies do this in very different ways. It's much easier said than done. Looker is an example. So Looker is a First Round company founded in 2012 by Lloyd Tabb. They do business intelligence. And Looker is interesting because they spent actually a long time at level one, but then flew through level two.

**中文翻译:**
是的。我认为第二级的标志是：你有一款产品，有一小部分人喜欢它，它满足了他们的关键需求。现在你必须打开需求的闸门，以便获得 25 个及更多的客户。不同的公司做法迥异，说起来容易做起来难。Looker 就是一个例子。Looker 是 First Round 投资的公司，由 Lloyd Tabb 于 2012 年创立，做商业智能（BI）。Looker 很有趣，因为他们在第一级待了很长时间，但随后飞速跨越了第二级。

---

### [00:43:59] Todd Jackson

**English:**
And the reason is because Lloyd, the founder, the first five customers of Looker, he was basically going in and doing consulting for them. And the reason is because of the nature of the product. People don't get Looker until they see their own data in it, and their data is modeled and they see the dashboards and they're like, "Oh, my God. Wow, I didn't realize these insights." So Lloyd understood Looker is not a product you could sell with Figma mock-ups. And so what happened was Lloyd would go into these customers, spend 20, 30, 40 hours before they were even a customer, modeling their data, teaching them how to use it, showing more people within the organization the power of the data and the dashboards.

**中文翻译:**
原因是创始人 Lloyd 为 Looker 的前五个客户提供了大量的咨询服务。这是由产品性质决定的：人们在 Looker 中看到自己的数据、数据被建模并看到仪表盘之前，是无法理解 Looker 的价值的。他们会惊呼：“天哪，哇，我以前没发现这些洞察。”所以 Lloyd 明白 Looker 不是那种靠 Figma 原型图就能卖出去的产品。于是，Lloyd 会在这些公司还没成为客户之前，就花 20、30、40 个小时为他们建模数据，教他们如何使用，向组织内的更多人展示数据和仪表盘的力量。

---

### [00:44:32] Todd Jackson

**English:**
And later, they called this their forward deploy process. This is how they figured out sales. And so it actually took them a long time in level one to get this right, but then they were able to do this repeatably. And so they went from five to 25 fairly quickly, and a lot of amazing... 75% close rate because they were only selling customers who were already using it. There was zero churn. And Lloyd explains once he got to 20 customers, he's like, "I know I'm onto something. And I think I figured out a model."

**中文翻译:**
后来，他们把这称为“前置部署流程”（Forward deploy process）。这就是他们摸索出销售方式的过程。所以他们实际上在第一级花了很长时间才把这件事做对，但一旦做对，他们就能重复执行。于是他们很快从 5 个客户增长到 25 个，而且数据惊人——成交率高达 75%，因为他们只向已经在使用的客户销售。流失率为零。Lloyd 解释说，一旦他有了 20 个客户，他就知道：“我发现了一些门道，我想我摸索出了一套模型。”

---

### [00:45:03] Todd Jackson

**English:**
And the model stayed the same until they ended up selling to Google. And so they did these other things too. They started focusing on demand channels. They got a couple SDRs who were prospecting. I think they did some partner marketing with AWS Redshift. They did these look-and-tell customer events in San Francisco where they got Looker customers together to talk about what they were doing in Looker and how they built the product. But really, the groundwork was set at level one and then they moved really quickly through level two.

**中文翻译:**
这套模型一直沿用到他们最终卖给谷歌。他们还做了其他事情：开始专注于需求渠道，雇了几个销售开发代表（SDR）进行拓客。我想他们还与 AWS Redshift 做了联合营销。他们在旧金山举办了“Look-and-tell”客户活动，让 Looker 的客户聚在一起分享他们如何使用 Looker 以及如何构建产品。但实际上，基础是在第一级打下的，然后他们非常迅速地通过了第二级。

---

### [00:45:32] Lenny Rachitsky

**English:**
So again, the way to think about this phase, is this is when you're starting to scale a way to drive demand. You're not just grinding sales, cold outreach. There's a way you're starting to bring in customers that are more efficient. And in Looker's case, they just started coming because I imagine there's word of mouth and people started to talk about it.

**中文翻译:**
所以，理解这个阶段的方式是：这是你开始规模化驱动需求的时候。你不再只是苦哈哈地跑销售、做冷启动外联。你开始有一种更高效的方式来获取客户。在 Looker 的案例中，客户开始主动找上门，我想是因为有了口碑，人们开始谈论它。

---

### [00:45:50] Todd Jackson

**English:**
Yeah. Let me do another example. A really different example is a company called Ironclad. Ironclad, it's legal. It's a legal tech company founded in 2015. Jason Jason Boehmig is the founder. AI-powered contract management software. So this was interesting because Jason, he started out calling this an AI legal assistant. And in 2024, people are like, "Oh, AI legal assistant. Yeah, that's awesome." But in 2014, people were like, "What?" And he found it really hard to sell. No one was looking for an AI legal assistant. And so he told us this story.

**中文翻译:**
是的。我再举一个例子。一个完全不同的例子是 Ironclad。这是一家成立于 2015 年的法律科技公司，创始人是 Jason Boehmig。他们做的是 AI 驱动的合同管理软件。有趣的是，Jason 最初把这称为“AI 法律助手”。在 2024 年，人们会觉得“噢，AI 法律助手，太棒了”。但在 2014 年，人们的反应是“啥？”他发现这非常难卖，没人会去寻找“AI 法律助手”。他给我们讲了这样一个故事。

---

### [00:46:29] Todd Jackson

**English:**
There was an email address on the Ironclad homepage, hello@ironclad.com. This is in 2015. And he doesn't get very much email, but Jason is checking the email. And one day he gets this one line email, and he almost archives it because he doesn't know who it's from and it's one line. But he sees that it's from a person at a publicly-traded company, and so he's like, "Oh, maybe there's something here." And the one line email is just, "Are you a CLM?" And he was like, "What is a CLM?" And he Googles for it. A CLM is a contract lifecycle management platform. And he's reading up about CLMs, and he's like, "Oh, we do that. Yeah."

**中文翻译:**
2015 年，Ironclad 的官网上有一个邮箱地址 hello@ironclad.com。Jason 负责查看邮件，虽然邮件不多。有一天他收到一封只有一行的邮件，他差点把它归档了，因为他不认识发件人，而且内容只有一行。但他看到发件人来自一家上市公司，于是想：“噢，也许有点意思。”那封只有一行的邮件写着：“你们是 CLM 吗？”他心想：“什么是 CLM？”于是他去谷歌搜了一下。CLM 是“合同生命周期管理平台”。他读了关于 CLM 的介绍，心想：“噢，我们确实在做这个。是的。”

---

### [00:47:08] Todd Jackson

**English:**
And so he replies to the email, "Yes, we are a CLM." And the customer gets them on the phone. And the customer says, "Oh, I'm in the market for a CLM. I'm looking at 10 or 12 different vendors, but you guys look pretty cool because there's some automation and some AI stuff going on. Can I check this out?" And Jason's like, "Of course." So he and his co-founder take the train from San Francisco down to San Jose. And on the train, Jason is telling his co-founder, Cai, "Hey, I need you to code this up right now to make it look like what this customer is expecting."

**中文翻译:**
于是他回复邮件说：“是的，我们是 CLM。”客户随后给他们打了电话，说：“噢，我正在市场上寻找 CLM。我看了 10 到 12 家不同的供应商，但你们看起来挺酷的，因为有一些自动化和 AI 的东西。我能看看吗？”Jason 说：“当然可以。”于是他和合伙人坐火车从旧金山去圣何塞。在火车上，Jason 对合伙人 Cai 说：“嘿，我需要你现在就把代码写出来，让它看起来像客户期待的那样。”

---

### [00:47:42] Todd Jackson

**English:**
And they get to the meeting, and they do the demo. And the customer has no idea that they just made this demo on the train, and they're a very small company. And they win the contract against these 10 or 12 other established bases, because Ironclad, it's more modern, it's automated, it's got this AI stuff. It's just a better product, or the demo looks like it's going to be a better product. And so Jason reflects on this and he's like, "Yeah, the thing for us is we had been trying to create this new category of AI legal assistant, and it was just a slog.

**中文翻译:**
他们赶到会议现场做了演示。客户完全不知道这个演示是他们在火车上现做的，也不知道他们只是一家很小的公司。最终他们击败了那 10 到 12 家老牌供应商赢得了合同，因为 Ironclad 更现代、更自动化，还有 AI 功能。它就是一个更好的产品，或者说演示看起来会是一个更好的产品。Jason 后来反思道：“是的，对我们来说，关键在于我们之前一直试图创造‘AI 法律助手’这个新类别，那简直是举步维艰。”

---

### [00:48:10] Todd Jackson

**English:**
"And instead, when we changed our positioning to play in an existing category of CLM, but a much better CLM, but customers are already looking for a CLM, they're already looking to spend money on a CLM, and just expand the definition of what that category is, things just started to click." And that's how they got through that zone of 10, 20, 30 customers. And even if you look at the Ironclad website today, it says AI-Powered Contract Management Software. That really is the key idea still.

**中文翻译:**
“相反，当我们改变定位，进入现有的 CLM 类别，但做一个好得多的 CLM 时——因为客户已经在寻找 CLM，已经在计划为 CLM 掏钱了——我们只是扩展了这个类别的定义，事情就开始变得顺理成章了。”这就是他们如何突破 10、20、30 个客户阶段的。即使你今天看 Ironclad 的官网，上面写的依然是“AI 驱动的合同管理软件”。这依然是核心理念。

---

### [00:48:38] Lenny Rachitsky

**English:**
Awesome. So this is an awesome example of positioning/promise is the lever they pull here. I love the point about category design. That's one of the ongoing debates on this podcast, whether you should try to create a category.

**中文翻译:**
太棒了。这是一个关于“定位/承诺”作为杠杆的绝佳例子。我喜欢关于类别设计的那一点。那是本播客一直在争论的话题之一：你是否应该尝试创造一个新类别。

---

### [00:48:50] Todd Jackson

**English:**
I know, it's a hot topic.

**中文翻译:**
我知道，这是个热门话题。

---

### [00:48:51] Lenny Rachitsky

**English:**
Hot topic. Sounds like you're in the boat of probably better not to create your own category.

**中文翻译:**
热门话题。听起来你倾向于“最好不要创造自己的类别”这一派。

---

### [00:48:56] Todd Jackson

**English:**
I think it's hard to create a category. It certainly works in some cases, but if you actually have a really interesting spin on an existing category, there's already buyers spending money on that thing. They're already looking for something to buy. So if you can do it, I do actually think that way is easier.

**中文翻译:**
我认为创造一个类别很难。在某些情况下确实有效，但如果你能对现有类别提出一个非常有趣的切入点，那里已经有买家在花钱了，他们已经在寻找购买对象了。所以如果你能做到这一点，我确实认为这种方式更容易。

---

### [00:49:13] Lenny Rachitsky

**English:**
Before we get to level three, what are signs that you're maybe stuck at level two, and what should one do about that?

**中文翻译:**
在进入第三级之前，有哪些迹象表明你可能卡在第二级了？该怎么办？

---

### [00:49:21] Todd Jackson

**English:**
Yeah. So the whole idea of level two is this thing that the marginal customer is getting easier. And so you've got to be focusing on demand and the repeatability of demand while you maintain satisfaction. So the yellow flags are things that are the opposite of that. Your current customers are pretty happy, but you're just having trouble opening the floodgates. As you're getting to the top end of level two, you should start to hear some startups know who you are like, "Oh, you need a SOC 2, you're a startup. Oh, Vanta." "Oh, you need AI-powered contract management software. Oh, Ironclad." You start to get known for a thing.

**中文翻译:**
好的。第二级的核心理念是获取边际客户变得越来越容易。所以你必须在保持满意度的同时，专注于需求及其可重复性。黄牌警告就是与此相反的情况：你现有的客户挺满意，但你就是无法打开需求的闸门。当你接近第二级的顶端时，你应该开始听到一些初创公司知道你是谁，比如：“噢，你需要 SOC 2？你是初创公司？找 Vanta。”“噢，你需要 AI 合同管理软件？找 Ironclad。”你开始因某件事而闻名。

---

### [00:49:59] Todd Jackson

**English:**
And so if you're having trouble opening those floodgates, and you're sitting there for, I don't know, 12 months, 18 months, that's a problem. Or you have things like your regretted churn is greater than 20%. That's a satisfaction warning sign. And again, you have to maintain the satisfaction as you work on these other things. Every level just gets more things you have to do. Or you could be finding that the sales cycle's taking too long, you're losing deals late in the funnel, you're losing the competitors. You're just not feeling the urgency from customers or you're struggling to hit the price point that you want.

**中文翻译:**
所以如果你在打开闸门方面遇到困难，并且在那里待了 12 个月、18 个月，那就是个问题。或者你的遗憾流失率大于 20%，这是满意度的警示信号。再次强调，你在处理其他事情时必须维持满意度。每一级需要做的事情都会变多。或者你发现销售周期太长，在漏斗后期丢掉订单，输给竞争对手。你感受不到客户的紧迫感，或者很难达到你想要的价位。

---

### [00:50:33] Todd Jackson

**English:**
And the way that customers will say this to you because customers are nice, right? They'll say, "Oh, we don't have the budget." Or, "Oh, it's just not the right time for us. We'd love to talk again next year." That means no, when you're hearing that from customers. You want customers who are like, "Oh, of course. Yeah, this is expensive, but I'm going to make this work because I need this." And so if you're seeing any of those signs, those are the signs that you maybe are stuck or plateauing at this level. And I really think it's important to think about the four Ps and think about: how am I going to pivot my way out of this? Jack Altman, who I mentioned earlier from Lattice, he's got a great quote on this.

**中文翻译:**
客户对你说这些话的方式通常很委婉，因为客户人都很好，对吧？他们会说：“噢，我们没有预算。”或者“噢，现在对我们来说时机不对，我们明年再聊。”当你听到这些话时，它的意思就是“不行”。你想要的客户应该是：“噢，当然。虽然有点贵，但我会想办法搞定，因为我需要这个。”如果你看到了上述任何迹象，说明你可能卡在这一级或进入了瓶颈期。我认为思考“四个 P”并思考“我该如何通过转型摆脱困境”非常重要。我之前提到的 Lattice 的 Jack Altman 对此有一句名言。

---

### [00:51:14] Todd Jackson

**English:**
It's up in a video on the website. What did he say? He said, "Most founders do a 10% pivot, and what they need to be doing is a 200% pivot." Jack didn't say this, but I think part of my interpretation of this is it's psychologically hard as a founder. You've gotten to this many customers, you're starting to plateau, but you're like, "I don't want to throw this whole thing away." But you have to be willing to let go and really focus on nailing the four Ps at this point.

**中文翻译:**
那是在网站的一个视频里。他是怎么说的？他说：“大多数创始人只做了 10% 的转型，而他们真正需要做的是 200% 的转型。”Jack 没说后面这段，但我对此的部分解读是：作为创始人，这在心理上很难。你已经有了这么多客户，开始进入瓶颈期，你会想：“我不想把这一切都扔掉。”但你必须愿意放手，并在此时真正专注于搞定那四个 P。

---

### [00:51:46] Lenny Rachitsky

**English:**
And in your experience, do you find, essentially, pivoting is the answer if you're stuck?

**中文翻译:**
根据你的经验，你是否认为如果卡住了，转型基本上就是答案？

---

### [00:51:52] Todd Jackson

**English:**
I think sometimes it's nice when it's the Ironclad thing, right?

**中文翻译:**
我觉得有时候像 Ironclad 那样就很幸运，对吧？

---

### [00:51:56] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:51:57] Todd Jackson

**English:**
It's nicest when it's the Looker thing of you don't have to change anything. It just starts working and basically, the whole thing works the whole time. That's not common. It's nice when it's the Ironclad thing when you just change one of them, or maybe two of them. Starting over with all four of these is hard at level two, but oftentimes, it's what's required. I was mentioning earlier, level two is the second most common level to get stuck.

**中文翻译:**
最理想的是像 Looker 那样，你什么都不用改，它就开始起效，而且基本上一直都有效。但这不常见。像 Ironclad 那样只改一个或两个 P 也很不错。在第二级要重新审视全部四个 P 很难，但通常这又是必须的。我之前提到过，第二级是第二常见的卡壳阶段。

---

### [00:52:20] Todd Jackson

**English:**
A big chunk of companies are going to get stuck at level one, and the second biggest is at level two. So sometimes it's hard. I think the trap is not doing enough to realize that you're actually not progressing to product-market fit in the way that you need to and just starting to burn money and not make progress. And you've seen many startups struggle with this. I think it's the hardest part of it.

**中文翻译:**
很大一部分公司会卡在第一级，第二大群体卡在第二级。所以有时这很难。我认为陷阱在于没有意识到你实际上并没有按照需要的方式向 PMF 迈进，而只是在烧钱却毫无进展。你见过很多初创公司为此挣扎，我认为这是最难的部分。

---

### [00:52:42] Lenny Rachitsky

**English:**
Yeah. Especially once they're a million, two million, three million ARR and they're like, "Look, we're making all this money." And they don't necessarily realize that they've been stuck at this stage for so long. So just to summarize flags that something is wrong and that you should probably think about changing your persona, your problem, your promise or your product, is it's been 12 to 18 months at this stage of product-market fit. You are churning about 20% of customers. And these are logo churn, I imagine, just like businesses stop using you.

**中文翻译:**
是的。特别是当他们的 ARR 达到 100 万、200 万或 300 万美元时，他们会觉得：“看，我们赚了这么多钱。”他们不一定意识到自己已经在这一阶段卡了很久。总结一下出问题的信号，以及你应该考虑改变画像、问题、承诺或产品的情况：在这一 PMF 阶段停留了 12 到 18 个月；客户流失率约为 20%（我想这是指客户数流失，即企业停止使用你的产品）。

---

### [00:53:14] Todd Jackson

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:53:14] Lenny Rachitsky

**English:**
Your sales cycles are really slow. Is there a sense of what slow means? Just a rough heuristic. What should it...

**中文翻译:**
销售周期非常缓慢。关于“缓慢”有什么具体的概念吗？有没有什么粗略的启发式标准？应该是……

---

### [00:53:20] Todd Jackson

**English:**
Well, some sales cycles are slow. If you're selling to companies that are big, you're selling to government, that type of thing. I don't know. Rough rule of thumb is... There's different ACVs also. If you're the kind of product that is 20K, 30K annual contracts, that was Looker, right? But they were able to do the sales cycle very repeatedly because they closed so often. There are some contracts that are 100K, 200K, six figure contracts. Those can take a long time. Those can take three to six months. You can't basically be in the worst of both worlds where you've got a slow sales cycle and a low ACV. That is the quadrant of death basically.

**中文翻译:**
有些销售周期天生就慢，比如你卖给大公司或政府。粗略的经验法则是……这还取决于 ACV（平均合同价值）。如果你是那种年合同额 2 万、3 万美元的产品（比如早期的 Looker），但他们能非常重复地完成销售周期，因为成交频率很高。有些合同是 10 万、20 万美元的六位数合同，那可能需要很长时间，比如 3 到 6 个月。你不能处于“最糟糕的两难境地”：销售周期又长，ACV 又低。那基本上就是“死亡象限”。

---

### [00:53:57] Lenny Rachitsky

**English:**
Awesome. Okay. And then the other sign is just you're not finding demand starting to come to you. You're not finding a channel to drive demand. And is a big part of this inbound? You're supposed to start seeing more inbound coming at you? Or is it more just sales becomes easier?

**中文翻译:**
明白了。另一个迹象是你没有发现需求开始主动找上门，你没有找到驱动需求的渠道。这很大程度上是指“入站”（Inbound）吗？你应该开始看到更多的入站咨询？还是仅仅指销售变得更容易了？

---

### [00:54:12] Todd Jackson

**English:**
It's both. So sales becomes easier, but I think if you are starting to get to level three, which is where we're getting to next, you've probably got 10%, 20% of your inbound coming or completely organic inbound.

**中文翻译:**
两者兼有。销售变得更容易，但我认为如果你开始进入第三级（也就是我们接下来要聊的），你可能有 10% 到 20% 的咨询是主动找上门的，或者是完全有机的入站流量。

---

### [00:54:25] Lenny Rachitsky

**English:**
Awesome. Okay. So again, if you're stuck at this stage, and these are signs that are like, "Oh, man, this sounds familiar," your advice is find one of these things to shift the person you're going after, the problem you're solving, the way you position it and/or your product if you have to.

**中文翻译:**
太好了。所以再次强调，如果你卡在这个阶段，并且觉得这些迹象听起来很耳熟，你的建议是：找出一个 P 进行调整——改变目标受众、解决的问题、定位方式，或者在必要时改变产品。

---

### [00:54:41] Todd Jackson

**English:**
Yeah. And probably just look for something that is a lot more of a burning pain. It's usually that the problem is not significant enough, important enough to people, or the promise is not valuable enough. It's usually one of those [inaudible 00:54:54] assuming you have a reasonable persona.

**中文翻译:**
是的。可能还要寻找更迫切的痛点。通常是因为问题不够重大、对人们不够重要，或者承诺的价值不够高。假设你的用户画像是合理的，通常就是其中之一出了问题。

---

### [00:54:56] Lenny Rachitsky

**English:**
Awesome. And the reason I am spending so much time here, as you said, most companies get stuck here, like B2B SaaS companies. So I think it's really important to make sure people have something to go with. And in the course and in the post you put out, there's more examples of companies going through this and what they did. Let's talk about level three. What does level three look like? What should you be focusing on there?

**中文翻译:**
太棒了。我之所以在这里花这么多时间，是因为正如你所说，大多数公司（尤其是 B2B SaaS 公司）都会卡在这里。所以确保大家有章可循非常重要。在你发布的课程和文章中，有更多公司经历这一阶段及其做法的例子。让我们聊聊第三级。第三级是什么样的？在那里应该关注什么？

---

### [00:55:16] Todd Jackson

**English:**
Yeah. So level three is strong product-market fit. This is where I think it starts to get fun. This is where all the product-market fit adages come in, "The fish are jumping into the boat. The rock is rolling down the hill and I'm trying to chase it instead of pushing it up the hill." And keep in mind, for most enterprise founders, we're now three, four or five years into the company, so it's not easy to get here. And to get to L3 here, you are looking for repeatability. The marginal customer has become much easier.

**中文翻译:**
好的。第三级是“强劲期 PMF”。我认为从这里开始事情变得有趣了。所有关于 PMF 的谚语都在这里应验了：“鱼儿正往船里跳”、“石头正往山下滚，而我是在后面追它，而不是费力把它往山上推”。请记住，对于大多数企业服务创始人来说，此时公司已经成立三、四或五年了，所以达到这一步并不容易。要达到 L3，你追求的是可重复性。获取边际客户已经变得容易得多。

---

### [00:55:48] Todd Jackson

**English:**
And so you mentioned, Lenny, this quote from David Hsu from Retool, which I love too, and I'll read it again. He said, "We talked to someone who said that finding product-market fit was so visceral, you immediately felt it like a geyser." And we honestly never felt that in the first couple years. At Retool, every customer we got, whether that was number four or number 14, felt like the last customer we were ever going to find. It felt like rolling the stone uphill, and if you stop pushing, it's going to roll back on you and crush you.

**中文翻译:**
Lenny，你提到了 Retool 的 David Hsu 的那段话，我也非常喜欢，我再读一遍。他说：“我们听人说寻找 PMF 是非常直观的，你会立刻感觉到它像喷泉一样爆发。但老实说，我们在头几年从未有过那种感觉。在 Retool，我们获得的每一个客户，无论是第 4 个还是第 14 个，感觉都像是我们能找到的最后一个。那感觉就像把石头推上山，如果你停止推，它就会滚回来把你压扁。”

---

### [00:56:15] Todd Jackson

**English:**
And that's how it felt until we had a few million in ARR. That's when the boulder went down the other side and we had to chase it to keep up. And you mentioned earlier, founders were like, "I'm not sure I ever felt product-market fit." This is when you start to feel it. And Jack Altman, again, from Lattice said, "The biggest shift was in the ease of getting leads." I remember thinking, "I don't even know where these leads are coming from, just more and more of them are showing up each month."

**中文翻译:**
“直到我们的 ARR 达到几百万美元，这种感觉才消失。那时石头才滚向了山的另一边，我们不得不追着它跑才能跟上。”你之前提到创始人说“我不确定我是否感受过 PMF”，这就是你开始感受到它的时候。Lattice 的 Jack Altman 也说过：“最大的转变在于获取销售线索（Leads）变得容易了。我记得当时在想，我甚至不知道这些线索是从哪儿来的，只是每个月出现的线索越来越多。”

---

### [00:56:43] Todd Jackson

**English:**
But that is a great feeling. That is a great feeling. Filip Kaliszan from Verkada, he's in some of the videos on our website too. His quote, I'll read it, was, "After our first year of sales in 2018, those next two years were crazy. We were barely keeping up with production. We had to scale all the systems. A lot of things had to happen in the span of 12 to 18 months in order to deliver on everything that customers were hoping the solution was going to do for them. And that in itself was a very formative and tricky part of the journey."

**中文翻译:**
那是一种很棒的感觉。Verkada 的 Filip Kaliszan（他也出现在我们网站的一些视频中）曾说过：“在 2018 年第一年销售之后，接下来的两年简直疯了。我们几乎跟不上生产进度。我们必须扩展所有系统。在 12 到 18 个月的时间里，必须完成很多事情，才能兑现客户对解决方案的所有期望。这本身就是旅程中一个非常重要且棘手的阶段。”

---

### [00:57:11] Todd Jackson

**English:**
So the benchmarks when you are at level three are now you're probably 30 to 100 people inside your company. You're probably at Series B-ish territory in terms of venture, maybe late Series A, maybe early Series C, but probably around Series B. You've really cracked a demand channel. You've cracked marketing and sales. You've got at least one channel that is very scalable. And probably 10% or more of your inbound is coming from just referrals and word of mouth and you're getting known, like we talked about.

**中文翻译:**
所以当你处于第三级时，基准是：公司规模可能在 30 到 100 人之间。在融资方面，你可能处于 B 轮左右的水平，也许是 A 轮后期或 C 轮早期，但通常是 B 轮。你已经真正攻克了一个需求渠道，攻克了营销和销售。你至少拥有一个非常可扩展的渠道。正如我们讨论过的，可能 10% 或更多的入站咨询来自推荐和口碑，你开始小有名气。

---

### [00:57:45] Todd Jackson

**English:**
ACV ranges are very high. Very wide, I should say. I'd say where you want to get to with level three is 100 customers. And so if you're approaching 100 customers and maybe you have 75K average ACV, that would be strong. You're in this wide zone of five million, all the way up to 25 million ARR. That is very level three. And you're actually starting now to think about some of these efficiency metrics. Remember, we've been punting efficiency. We were saying it shouldn't be worse than a certain number, but it's not a focus. Now, it's got to come into focus.

**中文翻译:**
ACV 的范围非常广。我想说，在第三级你想达到的目标是 100 个客户。如果你接近 100 个客户，平均 ACV 约为 7.5 万美元，那就是强劲的表现。你的 ARR 处于 500 万到 2500 万美元这个宽广的区间。这就是典型的第三级。现在你实际上开始考虑一些效率指标了。记住，之前我们一直在推迟考虑效率，只是说它不应低于某个数值，但不是重点。现在，它必须成为焦点。

---

### [00:58:20] Todd Jackson

**English:**
Because the way that we get to level four is we keep ripping on the satisfaction and the demand, and we tune this thing to get very efficient. So we're talking about our gross margin needs to be above 60%, hopefully above 70%. Our burn multiple is now below three. Ideally, we're close to one. Burn multiple in the one to three zone is where we want to be at level three. Regretted churn's less than 10%, NRR is greater than 110%. These are good benchmarks for this level.

**中文翻译:**
因为达到第四级的方法是：在继续保持满意度和需求的同时，对业务进行微调以实现高效。所以我们讨论的是：毛利率需要超过 60%，最好超过 70%。烧钱倍数现在应低于 3，理想情况下接近 1。在第三级，我们希望烧钱倍数在 1 到 3 之间。遗憾流失率低于 10%，NRR 大于 110%。这些都是该级别的良好基准。

---

### [00:58:50] Lenny Rachitsky

**English:**
Hearing level three again tells me level two is basically your pivot from: I'm just grinding, selling, pitching.

**中文翻译:**
再次听到第三级的情况让我明白，第二级基本上是你从“苦哈哈地磨合、销售、推销”状态中转型的阶段。

---

### [00:59:11] Lenny Rachitsky

**English:**
So essentially, you found a demand channel. You found a way to get people to come to you. A lot of them are just hearing about you from other people, you don't even know where they're coming from. 10% you said are coming from referrals and you're getting to 100 customers. I actually have another quote from David Hsu at Retool, and he actually said even at 100 customers, he still felt like every customer he was getting was the last one.

**中文翻译:**
所以本质上，你找到了一个需求渠道。你找到了一种让人们主动找你的方法。很多人只是从别人那里听说你，你甚至不知道他们是从哪儿冒出来的。你说 10% 来自推荐，并且你正达到 100 个客户。我还有一段 Retool 的 David Hsu 的话，他说即使有了 100 个客户，他仍然觉得获得的每一个客户都像是最后一个。

---

### [00:59:33] Todd Jackson

**English:**
Oh, wow.

**中文翻译:**
噢，哇。

---

### [00:59:33] Lenny Rachitsky

**English:**
He's like, "I can't believe we got DoorDash. That's incredible. Okay. I think there's no more. That's it."

**中文翻译:**
他说：“我不敢相信我们拿下了 DoorDash。太不可思议了。好吧，我想再也没有了，到此为止了。”

---

### [00:59:39] Todd Jackson

**English:**
He is a critical person and critical of himself, but a very high expectations person, let's say.

**中文翻译:**
他是一个很有批判精神的人，对自己也很苛刻，或者说是一个期望值非常高的人。

---

### [00:59:43] Lenny Rachitsky

**English:**
Yeah. Actually, another quote from Ali Ghodsi from Databricks actually said even at 100 million, he wasn't sure they had product-market fit.

**中文翻译:**
是的。实际上，Databricks 的 Ali Ghodsi 也说过，即使 ARR 达到 1 亿，他也不确定他们是否拥有 PMF。

---

### [00:59:50] Todd Jackson

**English:**
I mean, come on.

**中文翻译:**
我是说，得了吧。

---

### [00:59:54] Lenny Rachitsky

**English:**
Because he's like, "I don't know." I don't know. He felt like, "This is it. Okay, we're done. We're going to cap out here." And I get that.

**中文翻译:**
因为他觉得：“我不知道。”他觉得：“就这样了，好吧，我们到头了，我们要触及天花板了。”我能理解那种感觉。

---

### [00:59:58] Todd Jackson

**English:**
I think if you told many, many pre-seed founders that they'd be able to get to 100 million and not know whether they had product-market fit, they'd probably take that.

**中文翻译:**
我想如果你告诉很多种子前轮的创始人，他们能做到 1 亿收入却还不知道自己是否有 PMF，他们大概会欣然接受这种“烦恼”。

---

### [01:00:05] Lenny Rachitsky

**English:**
But I think that's maybe an interesting insight. It's often good to be really paranoid and not feel like, "Okay, we're on our way. Let's start pouring in money. Let's do it."

**中文翻译:**
但我认为这可能是一个有趣的见解：保持偏执通常是好事，而不是觉得“好吧，我们上路了，开始砸钱吧，大干一场”。

---

### [01:00:13] Todd Jackson

**English:**
I think that's what makes a lot of the best founders the best.

**中文翻译:**
我认为这正是许多顶尖创始人之所以优秀的原因。

---

### [01:00:16] Lenny Rachitsky

**English:**
Indeed. Okay, so level three, anything else that would be useful here? Maybe what are signs that you're struggling at level three, you're stuck?

**中文翻译:**
确实。好，关于第三级，还有什么有用的信息吗？比如，在第三级挣扎或卡住的迹象是什么？

---

### [01:00:25] Todd Jackson

**English:**
Yeah. So level three problems. And again, it's hard to get to level three, so awesome work for getting here. But the problems that might start to emerge are you've got a leaky bucket, your NRR is below 90%, or your regretted churn's greater than 10%. Maybe growth is just slowing down. You grew three X each of the prior two years, but you're struggling to do a two X this year. At level three, or five years into the company or so, there's probably a lot of competition. If you've gotten here, you've got something that's working, and people are starting to notice and there's going to be competitors.

**中文翻译:**
好的。关于第三级的问题。再次强调，达到第三级很难，能到这一步已经很了不起了。但可能出现的问题包括：你遇到了“漏水桶”问题，NRR 低于 90%，或者遗憾流失率大于 10%。也许增长正在放缓：前两年每年增长 3 倍，但今年连 2 倍都很吃力。在第三级，或者说公司成立五年左右，竞争可能会非常激烈。如果你到了这一步，说明你已经有了行之有效的东西，人们开始注意到你，竞争对手也会随之而来。

---

### [01:01:01] Todd Jackson

**English:**
And they could be the big competitors, they could be the new startups, but you're going to have to figure out how to navigate probably a tougher market than you entered five years ago. And so maybe you found your first scalable channel, but it's getting saturated, you got to find a new channel. These are the level three problems. Or you're growing, but like I said, with efficiency, you're spending too much money to grow. So you feel like, "Okay, yeah, we can grow at three X year over year, two X year over year, but that's going to push our burn multiple above three again." And that's a little bit of a pickle to be in when you have to trade off growth and spend like that.

**中文翻译:**
他们可能是巨头，也可能是新初创公司，你必须学会在一个比五年前更严酷的市场中航行。也许你找到了第一个可扩展渠道，但它正趋于饱和，你必须寻找新渠道。这些都是第三级的问题。或者你在增长，但正如我提到的效率问题，你为了增长花了太多的钱。你会觉得：“好吧，我们可以实现同比 3 倍或 2 倍的增长，但这会让我们的烧钱倍数再次超过 3。”当你必须在增长和支出之间做这种权衡时，处境会有点尴尬。

---

### [01:01:37] Lenny Rachitsky

**English:**
You make it sound like life's great, level three people are coming at us. I think it's important to note never is it easy, never is it like, "Okay, we're good. Let's just ride this wave. Life's going to get so much easier from now on." It's never easy. As you said, there's all these things, you're always still juggling, you still aren't sure it's going to keep going.

**中文翻译:**
你听起来好像第三级的生活很美好，大家都在找我们。我觉得有必要指出，这从来都不容易，从来不会是“好吧，我们稳了，顺着浪潮走就行，生活从此会变得轻松”。正如你所说，总有这么多事情要处理，你总是在不停地“转盘子”（Juggling），你依然不确定这种势头能否持续。

---

### [01:01:55] Todd Jackson

**English:**
No, I agree. It's like you're spinning plates, and the higher levels you get, there's more plates. You have to keep spinning. And so at level three and getting to level four, we've got to maintain satisfaction and demand. We cannot let them regress in a market that's getting harder, and we have to really start focusing on efficiency. And the companies that can maintain satisfaction and demand and continue to grow and become really efficient, now we're at level four.

**中文翻译:**
不，我同意。这就像在转盘子，等级越高，盘子越多，你必须不停地转。在第三级向第四级迈进的过程中，我们必须维持满意度和需求，不能让它们在日益艰难的市场中倒退，同时我们必须真正开始关注效率。那些能够维持满意度和需求、持续增长并变得非常高效的公司，就进入了第四级。

---

### [01:02:21] Lenny Rachitsky

**English:**
Let's talk about level four. What does that look like? What are some problems people run into there?

**中文翻译:**
让我们聊聊第四级。它是什么样的？人们在那里会遇到什么问题？

---

### [01:02:26] Todd Jackson

**English:**
So first of all, congrats. If you get to level four, you have a valuable company. You are probably already a unicorn, and you're starting to think about, "Can I become a decacorn?" And so you've reached the highest levels of satisfaction, demand, and efficiency. And so the benchmarks at level four are like, "Okay, now your team is probably bigger than 100 people, you're Series C, Series D or beyond. You've got more than 100 customers and you're starting to figure out, 'How do I get to 200, 300, eventually 1,000 customers?'"

**中文翻译:**
首先，恭喜你。如果你达到了第四级，你就拥有一家非常有价值的公司。你可能已经是一家独角兽了，并开始思考“我能成为十角兽（Decacorn，估值百亿美元）吗？”你已经达到了满意度、需求和效率的最高水平。第四级的基准是：团队规模可能超过 100 人，处于 C 轮、D 轮或更后期。你拥有超过 100 个客户，并开始思考“如何达到 200、300 甚至 1000 个客户？”

---

### [01:03:13] Todd Jackson

**English:**
You're beyond 25 million in ARR, so 25 million and up, I think in ARR, it qualifies as level four. And your other metrics are looking really good too. Your sales conversion first call to close one is probably better than 15%, your magic number is greater than one, your tax payback is less than 12 months. All these things are super awesome. And finally, now you've got your gross margin above 80%. Your burn multiple's ideally less than one at this point, you've got less than 10% churn. You've got greater than 120% NRR.

**中文翻译:**
你的 ARR 超过 2500 万美元，我认为 2500 万美元以上就可以算作第四级。你的其他指标看起来也非常棒：从第一次通话到成交的销售转化率可能超过 15%，魔法数字大于 1，获客成本回收期（CAC Payback）少于 12 个月。这些都非常出色。最后，你的毛利率现在超过 80%。此时烧钱倍数理想情况下应小于 1，流失率低于 10%，NRR 大于 120%。

---

### [01:03:55] Todd Jackson

**English:**
And so now the whole thing is like, "Well, how do I keep growing?" This thing's gotten pretty big. And this is generally when we get to 100 million, especially and beyond, the stage that founders are thinking about, "How do I keep growing by expanding TAM, by expanding total addressable market?" And to expand TAM, I can usually take my product and bring it into new markets, or I start to think about multiple products as a way to expand TAM.

**中文翻译:**
现在整个问题变成了：“好吧，我该如何保持增长？”公司已经变得相当庞大了。通常当我们达到 1 亿收入，尤其是超过这个数字时，创始人会思考：“我如何通过扩大 TAM（潜在市场总量）来保持增长？”为了扩大 TAM，我通常可以将产品推向新市场，或者开始考虑通过多产品策略来扩大 TAM。

---

### [01:04:40] Todd Jackson

**English:**
And so this is where you see all the truly great companies, the legendary companies are all able to do that. Vanta has begun to do this. They have the Vanta trust management平台, they've got security questionnaires, they've got vendor risk management. So they're starting to do this. You think of Verkada, who I mentioned before. They started with cloud security cameras, now they do alarms, now they do smoke detectors, now they do badge readers. Stripe has classic Stripe, but they've got Stripe Radar, Stripe Atlas. Square has the Square Stand, Cash App, Square Checking, Square Loans.

**中文翻译:**
你会看到所有真正伟大的公司、传奇的公司都能做到这一点。Vanta 已经开始这么做了：他们有了 Vanta 信任管理平台、安全问卷、供应商风险管理。他们开始多元化。想想我之前提到的 Verkada，他们从云安全摄像头起步，现在做警报器、烟雾探测器、读卡器。Stripe 除了经典的支付，还有 Stripe Radar、Stripe Atlas。Square 有 Square Stand、Cash App、Square Checking、Square Loans。

---

### [01:05:22] Todd Jackson

**English:**
All the companies that are tens of billions of dollars of value have figured out a way to do this. And it's like the never-ending journey that you said before, Lenny. Like, "Congrats, you got to level four." But there's just this endless thirst for continued growth. And the interesting thing about that is that it requires finding product-market fit over and over again. Just because you got to level four on your main product doesn't mean product-market fit is free on all these new products.

**中文翻译:**
所有价值数百亿美元的公司都找到了实现这一目标的方法。这就像你之前说的，Lenny，这是一场永无止境的旅程。就像在说：“恭喜你达到了第四级。”但对持续增长的渴望是无止境的。有趣的是，这需要一遍又一遍地寻找 PMF。仅仅因为你的主产品达到了第四级，并不意味着所有这些新产品都能自动获得 PMF。

---

### [01:05:22] Todd Jackson

**English:**
And you've been inside Airbnb and I've been inside Dropbox and Twitter. Getting new products to be successful is hard and it requires this mindset of like, "Yeah, we've got a little bit of advantage because people know who we are, and we have a customer set that hopefully we can layer on new products to. But it's not easy." You have to get into this mindset of product-market fit is never easy, and if we want to continue to grow, we got to find it again and again and maintain that mindset.

**中文翻译:**
你在 Airbnb 待过，我在 Dropbox 和 Twitter 待过。让新产品获得成功很难，它需要这样一种心态：“是的，我们有一点优势，因为人们知道我们是谁，我们有一群客户，希望我们能在他们身上叠加新产品。但这并不容易。”你必须建立这样一种心态：PMF 从来都不容易，如果我们想继续增长，就必须一次又一次地寻找它，并保持这种心态。

---

### [01:05:22] Lenny Rachitsky

**English:**
Casey Winters has this great point also that expectations of customers ever increase. And so you have product-market fit today, but there's going to be better products coming out, they're changing, the world changes. And so not only do you have to worry about competitors, there's just expectations continue to rise. So it's a never-ending battle. To give people a little bit of a broader sense here, what percentage of companies do you find make it through each of these stages in your experience, what are rough numbers you may have in your head?

**中文翻译:**
Casey Winters 也提出了一个很好的观点：客户的期望值在不断提高。所以你今天拥有 PMF，但未来会有更好的产品出现，客户在变，世界也在变。所以你不仅要担心竞争对手，还要面对不断攀升的期望值。这是一场永无止境的战斗。为了让大家有一个更宏观的认识，根据你的经验，你觉得有多少比例的公司能走完这些阶段？你脑子里大概的数字是多少？

---

### [01:05:52] Todd Jackson

**English:**
The majority of companies, so greater than 50%, probably closer to 60 or 70%, are going to get stuck at L1 or L2. And so that leaves, roughly, let's say, 30% make it to L3 or L4 just in our experience looking broadly. And that's our entire goal. Because again, once you get to L3, you've got a real shot, you've got a real shot at building an awesome company. And so if we get that number, help founders get that number above 30%, imagine if that was 50/50 and half the companies that we were working with at seed were able to get to level three strong product-market fit. I think that would be epic. And I think our founders would... There'd be incredible benefits to the ecosystem from that.

**中文翻译:**
大多数公司，超过 50%，可能接近 60% 或 70%，都会卡在 L1 或 L2。根据我们的广泛观察，大约只有 30% 的公司能达到 L3 或 L4。这就是我们的全部目标。因为再次强调，一旦你达到 L3，你就真正有机会建立一家伟大的公司。所以如果我们能把这个数字提高，帮助创始人把这个比例提高到 30% 以上，想象一下如果这个比例是 50/50，我们合作的一半种子轮公司都能达到第三级强劲 PMF，那将是史诗级的成就。我认为这对创始人以及整个生态系统都会带来巨大的好处。

---

### [01:06:36] Lenny Rachitsky

**English:**
Okay. So essentially, 60% ish of companies don't make it past L2. And I love the way you're framing it of just, "If we can just get a few more companies further, that makes a massive dent both in the world and the lives of founders and people that want to use products." Another question I wanted to talk about briefly is just again, the timelines of each of these levels. Just in your rough experience, how long do each of these levels roughly take so people can get a sense of like, "Oh, it's taken a lot longer. Maybe there's a problem"?

**中文翻译:**
好的。所以基本上 60% 左右的公司无法突破 L2。我喜欢你的这种表述：“如果我们能让更多的公司走得更远，那将对世界、对创始人的生活以及产品使用者产生巨大的影响。”我想简要讨论的另一个问题是每个级别的时间线。根据你的经验，每个级别大致需要多长时间，这样大家可以有个概念，比如“噢，我花的时间长得多，也许出问题了”？

---

### [01:07:10] Todd Jackson

**English:**
So again, this whole thing probably takes four to six years, and so let's just pick five years as the number to get to level four. I think the way this works, ideally, is you probably take 12 to 18 months to do level one, because that is the most important level, honestly, in my mind because that's where you're really choosing the right persona and the right problem to focus on. And I think just that choice is one of the most important choices that founders make.

**中文翻译:**
再次强调，整个过程可能需要四到六年，所以我们取五年来作为达到第四级的平均时间。我认为理想的运作方式是：你可能需要 12 到 18 个月来完成第一级。老实说，在我心中那是最重要的级别，因为那是你真正选择正确画像和正确问题去关注的时候。我认为这个选择本身就是创始人所做的最重要的决定之一。

---

### [01:07:53] Todd Jackson

**English:**
And the interesting thing, my partner, Josh Kopelman, talks about this all the time, is that founders spend 99% of their time building because that's what they've done. And they spend 1% of their time picking, in picking the market, picking the problem, picking the customer. And in reality, it's that pick that determines the constraints and the boundaries of where you're going to be working for the next, hopefully, 10 years of your life. So there's a real imbalance there.

**中文翻译:**
有趣的是，我的合伙人 Josh Kopelman 经常提到：创始人把 99% 的时间花在“构建”上，因为那是他们的本行；而只花 1% 的时间在“选择”上——选择市场、选择问题、选择客户。但现实中，正是这个“选择”决定了你未来（希望是）10 年工作生活的约束条件和边界。所以这里存在严重的失衡。

---

### [01:08:28] Todd Jackson

**English:**
So I would actually like to spend, let's say, somewhere 12 to 18 months in level one, just really figuring that out and figuring out my four Ps. And then, hopefully, I move very quickly. It takes me a while to get to my first five satisfied customers, but they love it. And then I go quickly through L2, maybe that takes about a year. This is like the Looker path, the happy path. And then L3 is long just because we're going all the way from five million in revenue up to 25, and that might take a year or two, probably two years even in a good case.

**中文翻译:**
所以我实际上希望在第一级花费大约 12 到 18 个月，真正把事情搞清楚，搞定我的四个 P。然后，希望我能进展神速。虽然花了一段时间才获得前五个满意客户，但他们非常喜欢。接着我快速通过 L2，可能需要一年左右。这就是 Looker 的路径，也是理想路径。然后 L3 会比较漫长，因为我们要从 500 万收入一路做到 2500 万，这可能需要一两年，即使在顺利的情况下也可能需要两年。

---

### [01:08:53] Todd Jackson

**English:**
And then getting from 25 to 100 million is hard, obviously very hard. And then that probably takes a couple years. And then you're figuring out all of these things. You're growing your team and your company's got a lot more moving parts and functions, and there's a demand generation side of the house and sales and there's engineering and the whole thing just gets more complicated with a lot more people. But I think that if you set the foundation really nicely at level one and level two that hopefully the whole thing... The boulder is rolling down the hill and it's carrying you forward and you don't just feel like you're pushing this rock uphill for five years. That's not a fun place to be.

**中文翻译:**
接着从 2500 万做到 1 亿很难，显然非常难，这可能需要几年时间。然后你要处理所有这些事情：团队在壮大，公司的组件和职能变得更多，有了需求生成部门、销售部门、工程部门，随着人员增多，整件事变得更加复杂。但我认为，如果你在第一级和第二级打好了基础，希望整个过程就像石头滚下山一样带着你前进，而不是让你觉得这五年一直在费力地把石头往山上推。后者可不是什么好玩的处境。

---

### [01:09:22] Lenny Rachitsky

**English:**
There's a lot of founders in that place and I know a few, so this is really interesting. So you're roughly saying that maybe spend a year, year and a half on level one, which is you're just grinding, cold emailing, reaching out, selling customers, and maybe getting to five customers in the first year and a half. That's at the extreme, but that's a good outcome. And then maybe another year trying to get to... What was it? 20? 25 customers.

**中文翻译:**
有很多创始人正处于那种境地，我也认识几个，所以这非常有趣。所以你大致是说，在第一级花一年到一年半的时间，也就是苦干、发冷启动邮件、外联、向客户推销，可能在头一年半里获得 5 个客户。虽然这听起来很极端，但其实是个不错的结果。然后再花一年时间尝试达到……多少来着？20 到 25 个客户。

---

### [01:09:45] Todd Jackson

**English:**
Going from five to 25 quickly. Yeah, if I see a company go from five customers to 25 in a year, that is almost always a sign that there's some pretty strong product-market fit there.

**中文翻译:**
快速从 5 个增加到 25 个。是的，如果我看到一家公司在一年内从 5 个客户增长到 25 个，这几乎总是表明他们拥有相当强劲的 PMF。

---

### [01:09:56] Lenny Rachitsky

**English:**
Awesome. So many companies don't go through that, and they have the funding to keep iterating, exploring, trying to figure things out. I don't know if you have the answer here, but just what's your advice of if it's been four years and demand is not starting to come to them, they don't have 25 customers? Is it, "Wait until you run out of money, just give it a shot"? Or is it, "Let's just give the money back and move on to something else"?

**中文翻译:**
太棒了。很多公司并没有经历过这些，他们有资金支持，可以不断迭代、探索、尝试搞清楚状况。我不知道你是否有答案，但你的建议是什么：如果已经过了四年，需求还没有主动找上门，他们也没有 25 个客户？是“等到钱烧光为止，再搏一把”？还是“干脆把钱退回去，换个别的事情做”？

---

### [01:10:21] Todd Jackson

**English:**
Well, that's a personal decision for founders. I do think if you've been going at it for four to five years and you haven't started to find anything that you're really feeling pull from the market on, I don't know, you've done it for four to five years, what are the chances that you're going to magically find something? I think there are probably a handful of startups that do it that figure it out and get back on an amazing growth curve, but that's the exception rather than the rule.

**中文翻译:**
嗯，这是创始人的个人决定。我确实认为，如果你已经努力了四五年，却还没有感受到任何来自市场的拉力，那么在坚持了四五年之后，你奇迹般发现新大陆的机会有多大呢？我想可能有极少数初创公司能做到这一点，摸索出路径并重回惊人的增长曲线，但那是例外而非普遍规律。

---

### [01:10:46] Todd Jackson

**English:**
So if a founder wants to return the money to investors, if a founder wants to look for a soft landing, there's no shame in that. Product-market fit is very, very hard. That's why we're doing this. It's why we're trying to increase the odds. And we're also trying to make it clear what it looks like and what it doesn't look like. And everybody knows when they do a startup that the odds are that you will not get there. So there's no shame in that, and I would completely be supportive of any founder who wants to take that path.

**中文翻译:**
所以，如果创始人想把钱退给投资者，或者想寻求软着陆，这并不可耻。PMF 非常、非常难。这就是我们做这个项目的原因，也是我们试图提高胜算的原因。我们也在努力明确 PMF 到底长什么样，不长什么样。每个人在创业时都知道，无法成功的概率很大。所以这并不可耻，我会完全支持任何想走这条路的创始人。

---

### [01:11:18] Lenny Rachitsky

**English:**
I love that advice. I think that was a really important point to make. Let's quickly summarize the levels and then I want to also summarize the four Ps again, because I think that's the thing you can actually do. And so I think I just want to reinforce, "Here's the four things you should play with if things aren't going in the direction." So first of all, let's summarize the levels, what it looks like and what you should be focusing on there.

**中文翻译:**
我喜欢这个建议。我认为这是一个非常重要的观点。让我们快速总结一下各个等级，然后我还想再次总结一下“四个 P”，因为我认为那是你真正可以操作的东西。我想强化这一点：“如果事情进展不顺，这就是你应该尝试调整的四件事。”首先，总结一下等级、现状以及应该关注的重点。

---

### [01:11:38] Todd Jackson

**English:**
Okay. So level one, nascent product-market fit. You're just trying to get three to five customers and you're focused on satisfaction first and foremost. Level two is developing. This is where you're going from five to 25 customers, and you're really starting to focus on demand. Level three is strong product-market fit. You're going from 25 customers up to 100 or more, and you've got to start thinking about efficiency at that scale. And then level four is extreme, you're more than 100 customers, your company's awesome. You got to keep doing all three of those things well, and you have to start looking for ways to expand your total addressable market.

**中文翻译:**
好的。第一级，萌芽期 PMF：你正努力获得 3 到 5 个客户，首要关注点是满意度。第二级，发展期：你正从 5 个客户增长到 25 个，开始真正关注需求。第三级，强劲期 PMF：你正从 25 个客户增长到 100 个或更多，在这个规模上你必须开始考虑效率。第四级，极致期：你拥有超过 100 个客户，公司表现卓越。你必须继续做好这三件事，并开始寻找扩大 TAM 的方法。

---

### [01:12:14] Lenny Rachitsky

**English:**
Okay, perfect. And then let's come back to the four Ps. I have the draft. I have your post up here, so I have the detailed version of each of these things. But could you just talk through these four things? What is it you should be thinking about changing if things aren't working, the four Ps basically?

**中文翻译:**
好的，完美。让我们回到“四个 P”。我这里有你的文章草稿，上面有每一项的详细版本。你能再详细讲讲这四件事吗？如果事情进展不顺，基本上应该考虑改变这四个 P 中的哪一个？

---

### [01:12:30] Todd Jackson

**English:**
Yeah. So the four Ps again are: persona, problem, promise, and product. And the persona is interesting because in some ways, it's synonymous with the market. A lot of people think of the market in this macroeconomic way where it's like, "Oh, it's this category of ERP software or whatever." I think it's much more tangible for a founder to think of the market as a collection of people. Jack Altman was thinking about his market as all of the HR leaders out there, and he was thinking about how many of them are there and what are the problems they have and how much money are they willing to spend on solving those problems.

**中文翻译:**
好的。再次强调，四个 P 是：用户画像（Persona）、问题（Problem）、承诺（Promise）和产品（Product）。画像很有趣，因为在某种程度上它等同于市场。很多人从宏观经济的角度看待市场，比如“噢，这是 ERP 软件类别”之类的。我认为对于创始人来说，将市场视为“一群人的集合”会更具体。Jack Altman 将他的市场视为所有的 HR 负责人，他思考的是有多少这样的人，他们有什么问题，以及他们愿意花多少钱来解决这些问题。

---

### [01:13:12] Todd Jackson

**English:**
It's a collection of people who have money to pay for a product or pay for a service. And so that's really the first piece, find the persona and really try to get into the mind of the persona. That's another thing I was amazed about spending time with Zach from Plaid, and Lloyd from Looker, and Jack from Lattice. They had all of these people, they were text messaging with all of their customers and they're meeting them on the weekends and stuff. They really, really knew their customer well. They were friends with their customers.

**中文翻译:**
市场就是一群有钱支付产品或服务的人。所以第一步是找到画像，并真正尝试进入画像的内心。这是我与 Plaid 的 Zach、Looker 的 Lloyd 以及 Lattice 的 Jack 相处时感到惊讶的另一件事：他们会和所有的客户发短信，在周末见面等等。他们非常、非常了解他们的客户，和客户成了朋友。

---

### [01:13:45] Todd Jackson

**English:**
And so you've got to get so deep into the mind of the persona and: what are their challenges? What are their goals? How do you help them succeed at their job? That's the stuff that earns you the right to get the rest of the Ps right. And so the problem, obviously, comes next. And I think about this, and I can actually get into, Lenny, a little bit if you want to get into some of the customer discovery stuff because that's the second session.

**中文翻译:**
所以你必须深入了解画像的内心：他们的挑战是什么？他们的目标是什么？你如何帮助他们在工作中取得成功？这些东西能让你有资格把剩下的 P 做对。接下来显然就是“问题”。Lenny，如果你想聊聊客户调研的内容，我可以深入讲一点，因为那是项目的第二个环节。

---

### [01:14:13] Lenny Rachitsky

**English:**
Perfect segue.

**中文翻译:**
完美的衔接。

---

### [01:14:14] Todd Jackson

**English:**
And I was talking a little bit about we think of it as dollar-driven customer discovery. And I think a lot of founders are familiar with customer discovery. I think they at least talk to customers, which is good. I don't think most of them do it in the highest signal way because again, the customers, they're people, they're nice, they're going to be polite. They're also not good at predicting things that they will use or buy or want.

**中文翻译:**
我刚才提到我们称之为“金钱驱动的客户调研”。我想很多创始人都熟悉客户调研，他们至少会和客户交流，这很好。但我认为大多数人并没有以“最高信号”的方式进行调研，因为客户也是人，他们很友善，会很有礼貌。而且，他们并不擅长预测自己将来会使用、购买或想要什么。

---

### [01:14:41] Todd Jackson

**English:**
They're very good at talking about their problems, but they're not necessarily good at predicting their own behavior. So we think about it in terms of dollar-driven discovery, which is how do you test the dollar potential of a hypothesis? And this is a whole two-hour session, but I'll try to do it briefly here just to give you a sense of it.

**中文翻译:**
他们非常擅长谈论自己的问题，但不一定擅长预测自己的行为。所以我们从“金钱驱动的调研”角度来思考，即：你如何测试一个假设的变现潜力？这是一个长达两小时的环节，但我会在这里简要介绍一下，让你有个概念。

---

### [01:15:00] Lenny Rachitsky

**English:**
No, let's get into it. Let's keep going. I'm just joking.

**中文翻译:**
不，让我们深入聊聊。继续吧。开个玩笑。

---

### [01:15:02] Todd Jackson

**English:**
So you've got to identify extreme value. This is independent of what I'm building, Lenny. I want to hear about your problems and your challenges and what is most important to you. And so I need to do it in this non-leading way and I need to avoid the trap that we call happy years. Because I found a lot of founders, "I want to build this thing, I want you to like my thing." And so I look for the things that you say that support what I'm doing. That's the trap. And so I could just try it on you, Lenny. Yeah, I might say...

**中文翻译:**
所以你必须识别出“极致价值”。Lenny，这与我正在构建的东西无关。我想听听你的问题、你的挑战以及对你来说最重要的事情。我需要以一种非引导性的方式来做这件事，并且需要避开我们所谓的“顺风耳”陷阱（Happy ears）。因为我发现很多创始人会想：“我想造这个东西，我希望你喜欢它。”于是我就只听那些支持我做法的话。这就是陷阱。Lenny，我可以拿你试一下。我会说……

---

### [01:15:35] Lenny Rachitsky

**English:**
Let's do it.

**中文翻译:**
来吧。

---

### [01:15:36] Todd Jackson

**English:**
Okay, Lenny, so you're doing Lenny's Newsletter and you're building Lenny's Podcasts. When you think about we're sitting here in April, over the next three months, let's say, what are your top three goals for Lenny's Newsletter and Lenny's Podcast?

**中文翻译:**
好的，Lenny，你正在经营 Lenny's Newsletter 并制作 Lenny's Podcast。现在是四月，假设在接下来的三个月里，你对 Newsletter 和播客的前三大目标是什么？

---

### [01:15:53] Lenny Rachitsky

**English:**
Oh, wow, interesting. I'm trying to find a more scalable way to do this newsletter long-term. It's basically something I have to do for the rest of my life, in theory. I don't know if there's an exit path for this newsletter career, so I'm trying to find ways to scale this over time. That's one. Two is just up-leveling the quality of each podcast episode in terms of visuals and audio and trailers and things like that. And then three is make the community more valuable to everyone that listens that's in the newsletter community. Those are top of mind.

**中文翻译:**
噢，哇，有意思。我正试图为这份 Newsletter 寻找一种更具长期扩展性的方式。理论上，这基本上是我余生都要做的事情。我不知道这份 Newsletter 事业是否有退出路径，所以我正试图寻找随时间推移而规模化的方法。这是第一点。第二点是提升每一集播客的质量，包括视觉、音频、预告片等等。第三点是让 Newsletter 社区对每一位听众和成员都更有价值。这些是目前最重要的。

---

### [01:16:26] Todd Jackson

**English:**
Okay, awesome. And so what's hard about those three things? You said you want to scale the newsletter, you want to increase quality, you want to make the community awesome. What's hard about those things? Or what's standing in your way of doing those?

**中文翻译:**
好的，太棒了。那么这三件事难在哪里？你说你想规模化 Newsletter、提高质量、让社区变得更棒。这些事情的难点是什么？或者说，阻碍你实现这些目标的是什么？

---

### [01:16:39] Lenny Rachitsky

**English:**
I don't have the answer yet, I guess is the answer. I don't know exactly how to do this yet.

**中文翻译:**
我想答案是我还没有答案。我还不确切知道该怎么做。

---

### [01:16:44] Todd Jackson

**English:**
You don't know how to do it. Okay. It's probably a service in this case, not a product. What if I was able to give you a service that said, "Lenny, you're going to be able to scale this podcast. We are going to help you find the 500 best guests in the world that are really excellent. We're going to guarantee they show up. You're going to have endless content on your podcast, in your newsletter"? What do you think about that? What do you think about that idea?

**中文翻译:**
你不知道该怎么做。好的。在这种情况下，这可能是一项服务，而不是一个产品。如果我能为你提供一项服务，说：“Lenny，你将能够规模化这个播客。我们将帮你找到世界上最优秀的 500 位嘉宾，并保证他们会出席。你的播客和 Newsletter 将拥有源源不断的内容。”你觉得怎么样？你觉得这个主意如何？

---

### [01:17:16] Lenny Rachitsky

**English:**
I'd pay a lot of money for that.

**中文翻译:**
我会为此付很多钱。

---

### [01:17:18] Todd Jackson

**English:**
Okay. So that's an example of a wow statement. And you probably had in the back of your mind, "How are you going to do that? Is that actually going to work?"

**中文翻译:**
好的。这就是一个“哇（Wow）”式陈述的例子。你脑子里可能还在想：“你打算怎么做？这真的行得通吗？”

---

### [01:17:27] Lenny Rachitsky

**English:**
That's right.

**中文翻译:**
没错。

---

### [01:17:28] Todd Jackson

**English:**
In my experience, that's a good thing and an exciting thing. If I'm pitching a product idea to somebody and they are like, "Wow, does that really work? And if that thing works, I'd sign up for the wait list today." That to me is like, "Okay, now I got to figure out how to build that thing, but I know if I am able to build it and deliver on that promise, they are going to want it." Or you would maybe say signs like you would demonstrate a behavior that shows that you're interested in. You'd be like, "Oh, Todd, can we meet again next week to talk about this?" Or like, "Hey Todd, I actually would love to show this to the people I work with. Can you send me the deck?"

**中文翻译:**
根据我的经验，这是一件好事，也是令人兴奋的事。如果我向某人推销一个产品创意，他们说：“哇，这真的行得通吗？如果行得通，我今天就加入等待名单。”对我来说，这意味着：“好吧，现在我得想办法把这玩意儿造出来，但我知道如果我能造出来并兑现那个承诺，他们一定会想要。”或者你可能会表现出一些感兴趣的行为，比如：“噢，Todd，我们下周能再见一面聊聊这个吗？”或者“嘿 Todd，我其实很想把这个展示给我的同事看，你能把 PPT 发给我吗？”

---

### [01:18:06] Todd Jackson

**English:**
Those are the signs that I'm looking for. If you had reacted like, "Yeah, that sounds kind of interesting," that's a no, right? That is a no. The word interesting is a polite way of saying no, right? And so I'm either looking for wow statements or I'm looking for demonstrated behavior that shows interest. I then would probably, if I want to keep going with this, and this is all in the identifying extreme value, I'd ask you, "Well, what stands out as valuable here to you?" And I want to hear you answer quickly. You mentioned it's either going to make my products so much better, it's going to drive success for my business, or it's going to save me a bunch of money or something. Save me a bunch of risk." But something where you would very quickly be able to identify why that's valuable to you.

**中文翻译:**
这些就是我正在寻找的迹象。如果你反应是“嗯，听起来挺有意思的”，那就是拒绝，对吧？那就是“不行”。“有意思”这个词只是拒绝的一种礼貌说法。所以我寻找的要么是“哇”式陈述，要么是表现出兴趣的具体行为。如果我想继续深入（这都属于识别极致价值的过程），我会问你：“那么，你觉得这里面最有价值的是什么？”我想听到你快速回答。你可能会提到它能让我的产品变得更好、推动业务成功，或者能帮我省下一大笔钱或规避风险。总之，是一些你能迅速识别出对你有价值的东西。

---

### [01:18:51] Todd Jackson

**English:**
So that part one is extreme value. Then I got to figure out ability to pay and willingness to pay. And for you, this is easy because you're not a 5,000 person company and you're the boss. So this is probably pretty streamlined. There's no procurement function at Lenny's Newsletter. So let's say I'm going after a bigger company. The questions I'd ask on confirming the ability to pay are: are you currently looking for a product like this? Or are you building something internally?

**中文翻译:**
所以第一部分是极致价值。接着我得搞清楚“支付能力”和“支付意愿”。对你来说这很容易，因为你不是一家 5000 人的公司，而且你是老板，所以流程非常简练，Lenny's Newsletter 也没有采购部门。但假设我面对的是一家大公司，确认支付能力的问题会是：你目前在寻找这类产品吗？或者你们内部正在开发类似的东西？

---

### [01:19:24] Todd Jackson

**English:**
This is the Ironclad thing where Jason was like, "Oh, you're looking for a CLM already." Another way I think about it is if a customer has a problem, and I really think they have a problem, and they know they have the problem and they're looking for a solution for the problem. Or they've even tried to build their own solution to it and failed, that's the best customer. They want this thing badly. They've demonstrated that and they've actually failed at building it because they underestimated how hard it was. So are you currently looking for building a solution here?

**中文翻译:**
这就是 Ironclad 的情况，Jason 发现：“噢，你已经在寻找 CLM 了。”另一种思考方式是：如果一个客户有问题，我也认为他们有问题，他们自己也知道有问题并正在寻找解决方案，甚至他们曾尝试自己构建解决方案但失败了——那就是最好的客户。他们极度渴望这个东西，他们已经证明了这一点，并且因为低估了难度而失败了。所以，你目前是否正在寻找或构建解决方案？

---

### [01:19:57] Lenny Rachitsky

**English:**
Essentially, there's a budget. You're looking for, "Is there money to go towards this problem"?

**中文翻译:**
本质上就是看有没有预算。你在寻找“是否有资金专门用于解决这个问题”？

---

### [01:20:01] Todd Jackson

**English:**
That's the next question I was going to say is where would a budget for this come from? And the best answer is that there's an existing budget. Either we already spend money in some way for a competing tool, or something that can be displaced by you, or we're spending, we put five engineers together to help build this thing. There's some source of budget that I can get. Then the question is, "Well, how does your team make decisions on third-party tools to bring on?" And you're never going to get the cleanest answer here. In larger companies, you might get semi-clean answers, but it's something like, "Okay, this manager can approve it directly up to a certain dollar amount. If not, it goes to this next level up of manager. And if we're going to spend more than 50K on it, we actually have to compare three different alternatives."

**中文翻译:**
这就是我正要说的下一个问题：这笔预算会从哪里来？最好的答案是已经有现成的预算了。要么是我们已经在为某个竞争工具花钱（你可以取代它），要么是我们正投入 5 名工程师来开发这个东西。总之，有一个我可以获取的预算来源。接下来的问题是：“那么，你们团队如何决定引入第三方工具？”在大公司里，你可能得不到非常清晰的答案，但通常是：“好吧，这位经理可以直接批准一定金额以下的支出，否则就要报给上一级经理。如果支出超过 5 万美元，我们实际上必须对比三个不同的方案。”

---

### [01:20:47] Todd Jackson

**English:**
But whatever, there's some known process. That's what I'm looking for rather than just a bunch of ambiguity. So that's ability to pay. And then I'm going into willingness to pay. I don't want to try to quantify that. That's where I go, "What's your budget for solving this? What are you paying for this other tool? Let me show you mine. You think that you'd pay less for that or you'd pay more for that? Can you replace this other thing with the thing I have?" And then I love this question. I think you've had Madhavan Ramanujam on the show, right?

**中文翻译:**
但无论如何，总有一个已知的流程。这就是我寻找的东西，而不是一堆模糊不清的信息。这就是支付能力。接着我进入支付意愿。我不想尝试量化它，我会问：“你解决这个问题的预算是多少？你为另一个工具付多少钱？让我给你看看我的。你觉得你会付更少的钱还是更多的钱？你能用我的东西替换掉那个东西吗？”然后我非常喜欢下面这个问题。我想你邀请过 Madhavan Ramanujam 上节目，对吧？

---

### [01:21:16] Lenny Rachitsky

**English:**
Mm-hmm.

**中文翻译:**
嗯。

---

### [01:21:17] Todd Jackson

**English:**
He has this question, he's from Simon-Kucher. I love his thing of like, "Lenny, what is a fair price you would pay for this thing that I just described to you?" And then you say your thing. And then I go, "Okay. Well, what would be an expensive price?" And then I say, "Okay, what would be a prohibitively expensive price?" And you ask those three questions. And generally, when people tell you the fair price, it's a little bit of like they're trying to get a deal. And if the product's good, the expensive price is the one that they would actually pay.

**中文翻译:**
他来自 Simon-Kucher。我非常喜欢他的那套问法：“Lenny，对于我刚才向你描述的东西，你觉得付多少钱是合理的？”然后你说一个数字。接着我问：“好吧，那多少钱算贵？”然后我再问：“好吧，那多少钱会贵到让你完全无法接受？”你问这三个问题。通常，当人们告诉你“合理价格”时，他们其实是想讨价还价。如果产品真的好，“觉得贵的价格”才是他们实际上愿意支付的价格。

---

### [01:21:47] Todd Jackson

**English:**
Where they're saying it feels expensive, but you put it in front of them, and you say, "It costs this much," and if it's really good, they want it. And the prohibitively expensive one is the one that's too expensive and they'd have to just, "I just can't do that." So I love these style of questions. I think they're just a lot more specific than what I see most founders doing, which is just chatting with customers. You really want to try to put them to some questions where you know they're going to answer honestly because you're asking them questions. You're not asking them to speculate and you're asking them fairly concrete stuff.

**中文翻译:**
虽然他们说感觉贵，但当你把它摆在他们面前并报出那个价格时，如果产品真的很好，他们还是会想要。而“无法接受的价格”则是真的太贵了，他们只能说“我真的做不到”。我喜欢这种风格的问题。我认为它们比大多数创始人做的“找客户随便聊聊”要具体得多。你真的要尝试抛出一些能让他们诚实回答的问题，因为你问的是具体的事情，而不是让他们去推测，你问的是相当具体的东西。

---

### [01:22:18] Todd Jackson

**English:**
Oh, and the thing I should say is it's a two-hour session, like I mentioned. It's one thing to explain this stuff, but it's another thing to see it. And so we show tons of Zoom recordings from founders who have gone through the program, and we actually do this thing where all the founders who are going through the program, they recorded all their videos, their customer discovery videos, and then our team watches all of the videos and creates highlight reels.

**中文翻译:**
噢，我该说的是，正如我提到的，这是一个两小时的环节。解释这些东西是一回事，亲眼看到又是另一回事。所以我们会展示大量参加过该项目的创始人的 Zoom 录音。我们实际上会要求所有参加项目的创始人都录下他们的客户调研视频，然后我们的团队会观看所有视频并制作精彩集锦。

---

### [01:22:45] Todd Jackson

**English:**
And we sit around in a room and watch them together and we say like, "Oh, look at these questions that Lenny asked. And did you see how the customer responded? Wow, that's an eyes-light-up moment." Or, "Todd asked these questions, he's leading the witness a little bit and the customer didn't seem that interested." So the thing that's interesting is as a founder, you never see anybody else's version of this. You only have your own experience. And so just seeing how other founders do this in a real live setting is super. People love it.

**中文翻译:**
我们坐在一起观看，然后点评：“噢，看 Lenny 问的这些问题。你看到客户是怎么反应的吗？哇，那是‘眼睛放光’的时刻。”或者：“Todd 问的这些问题有点诱导性，客户看起来并没那么感兴趣。”有趣的是，作为创始人，你永远看不到别人的调研过程，你只有自己的经验。所以，看到其他创始人在真实场景下是如何操作的，非常有帮助。大家都很喜欢这个环节。

---

### [01:23:13] Lenny Rachitsky

**English:**
And it's always easy to hear these things. It's much harder to be the person asking these questions to a potential customer you're trying to sell. And it's just asking, "How much would you pay for this?" So I love that you kind of force people through the actual practice of it. Todd, you're going to get a lot of applicants for this program. This sounds amazing. I know you're giving a peek at the stuff that we haven't really talked about. On this point you just shared, which is essentially trying to get real skin in the game insight into how big of a problem this is, I love that you just basically shared a bunch of questions.

**中文翻译:**
听这些道理总是很容易，但要成为那个向你试图推销的潜在客户抛出这些问题的人，却难得多。比如直接问：“你会为此付多少钱？”所以我喜欢你强迫大家进行实际练习的做法。Todd，你这个项目肯定会有很多申请者，听起来太棒了。我知道你正在展示一些我们还没聊到的内容。关于你刚才分享的这一点——本质上是试图获得关于问题严重程度的真实、切身利益（Skin in the game）的洞察——我非常喜欢你分享的那一连串问题。

---

### [01:23:43] Lenny Rachitsky

**English:**
Someone could just rewind right now and just write down all these questions that you shared and use them when you're talking to customers. Obviously, the classic problem is they tell you they're going to buy it but they don't. And all the stuff you shared is, "Here's ways to get at: will they actually buy it before they have the actual product?" Is there anything else you want to say on that? Just tips for not being tricked and people just saying, "Oh, yeah, I love this thing"? I know you talked through a lot of this, but anything else?

**中文翻译:**
听众现在就可以倒回去，把分享的这些问题都记下来，然后在和客户交流时使用。显然，经典的问题是客户口头上说会买，但实际上并不买。你分享的所有内容都是关于：“在产品还没出来之前，如何探究他们是否真的会买？”关于这一点你还有什么想说的吗？有没有什么诀窍可以防止被那些随口说“噢，是的，我喜欢这东西”的人误导？我知道你已经讲了很多，还有别的吗？

---

### [01:24:06] Todd Jackson

**English:**
Yeah, I think there's a couple of things. One is you have to know what to show people when you're actually showing them something. Lattice is the kind of product I mentioned that could be sold with Figma mock-ups. Looker couldn't be sold that way. Looker, you actually had to do a demo with their real data. So it required a lot more work to do that. Vanta was neither like a demo or a mock-up, it was actually doing the work. And Pilot was like that. There's a bunch of companies like that. So you have to figure out what is my product and how does it solve the problem? And therefore, what fidelity does my early product or early demo have to be at in order to land the sale?

**中文翻译:**
是的，我想有几点。第一，当你向人们展示东西时，你必须知道该展示什么。Lattice 是那种可以用 Figma 原型图卖出去的产品。Looker 就不行，Looker 必须用客户的真实数据做演示，所以需要更多的工作。Vanta 既不像演示也不像原型，它实际上是直接上手干活。Pilot 也是如此，还有很多类似的公司。所以你必须搞清楚：我的产品是什么？它是如何解决问题的？因此，为了达成销售，我的早期产品或早期演示需要达到什么样的保真度？

---

### [01:24:44] Todd Jackson

**English:**
And then I think you have to know when you've talked to enough people. It takes time to talk to people. And the rule of thumb is if you talk to enough people and you can predict 70 to 80% of what the next person is going to say to you, because you've just talked to so many people and you've heard the pattern so clearly, that's when you've talked to enough people. But these are all things you got to learn. And that's why doing it experientially in the way that we do the program we think was best.

**中文翻译:**
第二，我认为你必须知道什么时候算聊够了。和人交流需要时间。经验法则是：如果你聊了足够多的人，以至于你能预测下一个人 70% 到 80% 的谈话内容（因为你已经听过太多次，模式已经非常清晰了），那就是聊够了。但这些都是需要学习的。这就是为什么我们认为以项目中那种体验式的方式来学习是最好的。

---

### [01:25:10] Lenny Rachitsky

**English:**
Is there anything that we haven't covered that you wanted to touch on before we let you go?

**中文翻译:**
在结束之前，还有什么我们没涵盖到但你想聊聊的吗？

---

### [01:25:15] Todd Jackson

**English:**
No. If you're listening, if you're a B2B founder in those early days of starting your company, or you know anyone who fits that description, and you have an appreciation for just how hard it is to find product-market fit and you don't want to go it alone, then please apply to this program or share the application. Like we promise, we will review every single application. And I'm just really looking forward to working with a group of 20 or so amazing founders, and helping them navigate these early days of product-market fit finding. It's what I love to do.

**中文翻译:**
没有了。如果你正在听，如果你是一位处于创业早期的 B2B 创始人，或者你认识符合这一描述的人，并且你深知寻找 PMF 有多难且不想孤军奋战，那么请申请这个项目或分享申请链接。我们承诺会审核每一份申请。我非常期待与 20 位左右优秀的创始人合作，帮助他们度过寻找 PMF 的早期阶段。这就是我热爱做的事情。

---

### [01:25:43] Lenny Rachitsky

**English:**
So just to make sure the right people apply, remind people who is a great fit. So it's B2B founders, and you said they've been at it for six to nine months, something like that?

**中文翻译:**
为了确保合适的人申请，请再提醒一下什么样的人最适合。是 B2B 创始人，你说他们已经做了六到九个月左右？

---

### [01:25:52] Todd Jackson

**English:**
Yeah, something in that zone or earlier. You have an idea of what your product is. You have a hypothesis about what it is and who it's for, but you probably haven't started writing any code yet.

**中文翻译:**
是的，那个阶段或更早。你对产品是什么有了想法，对它是做什么的以及给谁用的有了假设，但你可能还没开始写代码。

---

### [01:26:01] Lenny Rachitsky

**English:**
And if they've been at it for four years and haven't found success, this is not a fit.

**中文翻译:**
如果他们已经做了四年还没成功，那就不适合。

---

### [01:26:07] Todd Jackson

**English:**
I could try to help them one-on-one, but no, that's not a fit for this program.

**中文翻译:**
我可以尝试一对一地帮助他们，但那个阶段不适合这个项目。

---

### [01:26:10] Lenny Rachitsky

**English:**
And then how do they apply and when are their applications due?

**中文翻译:**
他们如何申请？截止日期是什么时候？

---

### [01:26:13] Todd Jackson

**English:**
Yeah. So you go to pmf.firstround.com. Applications are open. They're going to go till May 7th, and then the program starts on May 29th. And if you want to reach out to me specifically, you can find me on Twitter. I'm @tjack, T-J-A-C-K. You can follow me, DM me. And yeah, I'm looking forward to working with some amazing founders that I know are listening right now.

**中文翻译:**
访问 pmf.firstround.com。申请现已开放，截止日期为 5 月 7 日，项目将于 5 月 29 日开始。如果你想直接联系我，可以在 Twitter 上找到我，账号是 @tjack。你可以关注我或给我发私信。是的，我期待着与正在收听节目的优秀创始人们合作。

---

### [01:26:34] Lenny Rachitsky

**English:**
Amazing. I'm so happy we did this. I feel like this conversation is going to help a ton of founders, and they're going to come back to it again and again. Todd, thank you so much for being here.

**中文翻译:**
太棒了。我很高兴我们聊了这些。我觉得这次对话会帮助很多创始人，他们会一遍又一遍地回来听。Todd，非常感谢你能来。

---

### [01:26:43] Todd Jackson

**English:**
Lenny, it's been a pleasure.

**中文翻译:**
Lenny，这是我的荣幸。

---

### [01:26:44] Lenny Rachitsky

**English:**
It's been my pleasure. Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
也是我的荣幸。大家再见。非常感谢收听。如果你觉得内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。