# Tom Conrad - 双语对照

# Lenny's Podcast: Tom Conrad (Bilingual Transcript)
## 嘉宾：Tom Conrad (Pandora 前 CTO, Snap 前产品副总裁, Zero 现任 CEO)

---

### [00:00:00] Tom Conrad

**English:**
There's this belief that everybody needs to be a founder. I think, in some ways, our industry would be much better off if there were fewer founders. There's an entire category of smart, creative, hardworking, talented, borderline visionary people who can raise that $2 million seed and go off and build some stupid company that's never going to go anywhere. That would be so much better off finding a team that needs their skillset and working on a problem that has a mathematical formula that's going to win on any metric. Whatever metric you care about. You want the acclaim of your peers, you want financial reward, you want outside impact on culture, whatever the thing is that gets you out of bed every morning, you can achieve that in collaboration with others. You don't have to be the person that raises the seed round.

**中文翻译:**
现在有一种信念，认为每个人都必须成为创始人。我认为，在某些方面，如果创始人少一些，我们的行业会发展得更好。有一大批聪明、有创意、勤奋、有才华、甚至近乎有远见的人，他们能筹集到 200 万美元的种子轮资金，然后去创办一些永远不会有出路的愚蠢公司。如果这些人能找到一个需要他们技能的团队，去解决一个在任何指标上都有获胜“数学公式”的问题，他们的处境会好得多。无论你关心什么指标——是同行的赞誉、经济回报，还是对文化的外部影响力，无论是什么让你每天早上起床动力十足，你都可以通过与他人协作来实现。你并不一定要成为那个筹集种子轮资金的人。

---

### [00:00:52] Speaker 1 (Intro)

**English:**
Today, my guest is Tom Conrad. Tom was an engineer at Apple, CTO of Pandora, which he helped take from zero to 80 million users. He's also VP of product at Snap, where he was the right-hand man to Evan Spiegel for two years. He's been on the Board of Sonos for over seven years. He was also part of two infamous product failures, Quibi, where he was chief product officer, which raised over $2 billion and died less than a year after launch.
(00:01:17):
He was also a senior engineering leader at Pets.com, which famously went from nothing to a public company, to completely out of business in 19 months. Today, Tom is the CEO of Zero Longevity Science, which is on a mission to extend the lifespan and the health span of the human race. In our conversation, we dig into what Tom's learned from these famous product failures, also, what he's learned from the many product successes. Tom also shares what he's learned about how to pick where to go work and what to avoid. How important understanding the math formula of the business model is. Also, lessons on burnout and health and leadership and contrarian corner. With that, I bring you Tom Conrad, after a short word from our sponsors.

**中文翻译:**
今天的嘉宾是 Tom Conrad。Tom 曾是苹果公司的工程师，也是 Pandora 的首席技术官（CTO），他帮助 Pandora 实现了从零到 8000 万用户的增长。他曾任 Snap 的产品副总裁，在那里的两年间他是 Evan Spiegel 的得力助手。他担任 Sonos 董事会成员已超过七年。他还参与了两个著名的产品失败案例：一个是 Quibi，他当时担任首席产品官，该公司筹集了超过 20 亿美元，但在上线不到一年后就倒闭了。
(00:01:17):
他还是 Pets.com 的高级工程负责人，这家公司著名的经历是在 19 个月内从无到有，再到上市，最后彻底倒闭。如今，Tom 是 Zero Longevity Science 的首席执行官（CEO），该公司的使命是延长人类的寿命和健康寿命（Health span）。在我们的对话中，我们将深入探讨 Tom 从这些著名的产品失败中学到了什么，以及他从众多成功案例中获得的经验。Tom 还分享了关于如何选择工作地点、避开哪些坑、理解商业模式“数学公式”的重要性，以及关于职业倦怠、健康、领导力和“非共识观点”的教训。在听完赞助商的简短介绍后，让我们欢迎 Tom Conrad。

---

### [00:02:01] Lenny (Sponsor: Coda)

**English:**
This episode is brought to you by Coda. You've heard me talk about how Coda is the doc that brings it all together and how it can help your team run smoother and be more efficient. I know this firsthand because Coda does that for me. I use Coda every day to wrangle my newsletter content calendar, my interview notes for podcasts, and to coordinate my sponsors. More recently, I actually wrote a whole post on how Coda's product team operates.
(00:02:25):
Within that post, they shared a dozen templates that they use internally to run their product team. Including managing the roadmap, their OKI process, getting internal feedback, and essentially their whole product development process is done within Coda. If your team's work is spread out across different documents and spreadsheets and a stack of workflow tools, that's why you need Coda. Coda puts data in one centralized location regardless of format, eliminating roadblocks that can slow your team down.
(00:02:52):
Coda allows your team to operate on the same information and collaborate in one place. Take advantage of this special limited time offer just for startups. Sign up today at coda.io/lenny and get a thousand dollars startup credit on your first statement. That's C-O-D-A.io/lenny to sign up and get a startup credit of $1,000. Coda.io/lenny.

**中文翻译:**
本期节目由 Coda 赞助。你听我多次提到 Coda 是一款能将一切整合在一起的文档工具，它能帮助你的团队运行得更顺畅、更高效。我有切身体会，因为 Coda 确实帮到了我。我每天都用 Coda 来整理我的时事通讯内容日历、播客采访笔记以及协调赞助商。最近，我还专门写了一篇关于 Coda 产品团队如何运作的文章。
(00:02:25):
在那篇文章中，他们分享了十几个内部用于管理产品团队的模板，包括路线图管理、OKI 流程（目标与关键指标）、获取内部反馈，基本上他们的整个产品开发流程都是在 Coda 中完成的。如果你的团队工作分散在不同的文档、电子表格和一堆工作流工具中，那么你正需要 Coda。Coda 将数据集中在一个地方，无论格式如何，消除了可能拖慢团队进度的障碍。
(00:02:52):
Coda 让你的团队能够基于相同的信息在同一个地方协作。现在有针对初创公司的限时特惠：立即访问 coda.io/lenny 注册，首张账单即可获得 1000 美元的初创公司抵扣额度。地址是 C-O-D-A.io/lenny。

---

### [00:03:17] Speaker 1 (Sponsor: Jira Product Discovery)

**English:**
You fell in love with building products for a reason, but sometimes the day-to-day reality is a little different than you imagined. Instead of dreaming up big ideas, talking to customers and crafting a strategy, you're drowning in spreadsheets and roadmap updates, and you're spending your days basically putting out fires. A better way is possible. Introducing Jira Product Discovery, the new prioritization and road mapping tool built for product teams by Atlassian.
(00:03:44):
With Jira Product Discovery, you can gather all your product ideas and insights in one place and prioritize confidently, finally replacing those endless spreadsheets. Create and share custom product roadmaps with any stakeholder in seconds. It's all built on Jira where your engineering team's already working. True collaboration is finally possible. Great products are built by great teams, not just engineers. Sales support, leadership, even Greg from Finance.
(00:04:12):
Anyone that you want can contribute ideas, feedback, and insights in Jira Product Discovery for free. No catch. It's only $10 a month for you. Say goodbye to your spreadsheets and the never ending alignment efforts. The old way of doing product management is over. Rediscover what's possible with Jira product discovery. Try it for free at atlassian.com/lenny. That's atlassian.com/lenny.

**中文翻译:**
你爱上打造产品是有原因的，但有时日常现实与你的想象大相径庭。你没有在构思伟大的创意、与客户交谈或制定战略，而是淹没在电子表格和路线图更新中，整天都在“救火”（处理紧急突发状况）。其实有更好的方法。向你介绍 Jira Product Discovery，这是由 Atlassian 为产品团队打造的新型优先级排序和路线图工具。
(00:03:44):
通过 Jira Product Discovery，你可以将所有的产品创意和洞察集中在一处，并自信地进行优先级排序，最终取代那些没完没了的电子表格。只需几秒钟即可创建并与任何利益相关者分享自定义的产品路线图。它完全构建在你的工程团队已经在使用的 Jira 之上，真正的协作终于成为可能。伟大的产品是由伟大的团队打造的，而不仅仅是工程师。销售支持、领导层，甚至是财务部的 Greg。
(00:04:12):
你想要的任何人都可以免费在 Jira Product Discovery 中贡献创意、反馈和见解。没有套路，你每月只需支付 10 美元。告别电子表格和永无止境的对齐工作。旧的产品管理方式已经结束。通过 Jira Product Discovery 重新发现可能性。访问 atlassian.com/lenny 免费试用。

---

### [00:04:40] Lenny

**English:**
Tom, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Tom，非常感谢你能来，欢迎来到本播客。

---

### [00:04:44] Tom Conrad

**English:**
Thank you. It's so fun that I get to be a part of this.

**中文翻译:**
谢谢。能参与其中真是太开心了。

---

### [00:04:46] Lenny

**English:**
I thought it'd be fun to start with a story about your time at Apple and you building this now very ubiquitous feature of dragging and dropping something into a folder. Which I saw you tweet about or talk about at a talk and the fact that it's still around. Can you just share that story and maybe a lesson from that experience that you've taken away?

**中文翻译:**
我想以你在苹果工作时的一个故事开始，这很有趣。你开发了一个现在非常普遍的功能：将东西拖放到文件夹中。我看到你在推特上提过，或者在演讲中谈过，而且这个功能至今依然存在。你能分享一下那个故事，以及你从那次经历中吸取的教训吗？

---

### [00:05:05] Tom Conrad

**English:**
Sure. Let's see. I was 15 years old when the Macintosh came out. I remember really clearly my entire teenage years. All I wanted to do was to move from Columbus, Ohio to Cupertino and work for Apple. My heroes were that team of people that had written their signatures on the inside of the Macintosh. We cracked open the first Macintosh case. You would find the signatures of the 20 people or so who worked on the Mac. That was my only ambition, truly.
(00:05:40):
This was a period where no one wanted to work for Apple. That wasn't a thing. It seems like maybe a little obvious today, but it wasn't an obvious ambition at all back then. Anyway, I went to college. It's all I wanted to do. Studied computer engineering at University of Michigan, and as we talk about my career, it is just over and over and over. I'm going to say an incredibly lucky thing happened. The first incredibly lucky thing that happened for me in my career probably was that University of Michigan happened to be a place that Apple recruited from.
(00:06:08):
I didn't know that when I chose the school, but it made it reasonably easy to connect to a hiring manager at Apple. I wrote an actual letter and put it in an actual envelope and put it in the mail and got an internship and drove out in my dad's Pontiac from the Midwest to California. Spent a summer interning and my last day of the internship, I was thinking about really what I wanted to do when I came back. Hopefully came back to Apple after I graduated.
(00:06:39):
I had worked on a product that became shipped. It was called the QuickDraw GX. It was earlier second generation rendering system for the Mac. I'd been that team's intern for the summer. But what I really wanted to do is I wanted to work on the Finder. This is the only thing in the whole world I really wanted to do. I went and found Ron Lichty, who is the manager of the Finder team and said, "I graduate in 10 months. I'd love to be a part of your team."
(00:07:06):
I think he was like, why are you coming and talking to me now? You're literally going back to Michigan tomorrow. I go back to Michigan in May, the phone rings and Ron says, "The college recruiting department just told me that I have a college hiring rep and if I don't use it by tomorrow, I lose it." He's like, "I can't even interview you, you can't meet the team, but you're basically a freebie for me. Do you want this job?"
(00:07:38):
Just insanely lucky moment, got this job. I get to Apple in the summer of 1992 and I have a laundry list of things that I would like to do to make the Finder more usable. I remember sitting in Ron's office and saying, "At the grocery store, when you're carrying bags of groceries out, the door's automatically open for you? I think the Finder should do the same thing. When you're dragging an icon around and you want to put it in a folder, you should be able to hover maybe over the folder icons and drill down into the file system to get to where you're going.
(00:08:20):
Then when you drop the file, all of the folders that opened up between you and your source and your destination would close for you." Ron thought that was a fine idea, so that was the way Apple worked in those days. I just went off and started coding that up. I got to the point late one night, two in the morning at Apple, no one else was there, where I needed some kind of animation to indicate that the folder was about to open.
(00:08:48):
I'm certainly not an animator and I certainly wasn't going to do anything thoughtful in the middle of the night. I just wrote some code that blinked the folder, like selected unselected, selected unselected five times and thought, oh, I'll email one of the really talented visual designers to do something much more interesting. Long story short, apple finally shipped that feature four years later. Sat in the source code repository forever while we did other things.
(00:09:21):
When it shipped four years later, it blinked five times. Roll the clock forward six or seven years, Mac plus 10 comes out, entirely new Finder rewritten from scratch. No spring-loaded folders anywhere to be seen. People complained about it. It got re-implemented. All of the code, brand new. Folder blinks five times when you hover over it. Roll the clock forward another decade, IOS comes along and they added folders. When you drag an icon around, it blinks a few times.
(00:09:51):
I'm not sure what the point of this story is other than maybe it's something about, I think we all do this as designers and product people. We take these shortcuts that we think that we'll go back later and clean up. Sometimes, it's literally been 30 years that little design detail lingers three implementations later and now it's just a part of the way that these Apple products work. Pretty bizarre.

**中文翻译:**
当然可以。让我想想。麦金塔（Macintosh）问世时我 15 岁。我清晰地记得我的整个青少年时期，我唯一想做的就是从俄亥俄州的哥伦布搬到库比蒂诺为苹果工作。我的英雄是那群在麦金塔外壳内侧刻下签名的人。如果你打开第一台麦金塔的机壳，你会发现大约 20 个参与研发的人的签名。那真的是我唯一的志向。
(00:05:40):
那是苹果公司没人想去的时期。这在今天看来可能显而易见，但在当时绝对不是一个普遍的志向。总之，我上了大学，一心想进苹果。我在密歇根大学学习计算机工程。回顾我的职业生涯，我不得不说，发生了一连串极其幸运的事情。第一件幸运的事可能是密歇根大学恰好是苹果招聘的目标院校。
(00:06:08):
我选学校时并不知道这一点，但这让我联系苹果的招聘经理变得相对容易。我写了一封真正的信，装进信封寄了出去，得到了一份实习机会，然后开着我父亲的庞蒂亚克车从中西部一路开到了加州。我实习了一个夏天，在实习的最后一天，我在想毕业后回来想做什么。
(00:06:39):
我当时参与了一个后来发布的产品，叫 QuickDraw GX，是 Mac 早期的第二代渲染系统。我是那个团队的夏季实习生。但我真正想做的是开发 Finder（访达）。这是全世界我唯一想做的事。我去找了 Finder 团队的经理 Ron Lichty，说：“我 10 个月后毕业，希望能加入你的团队。”
(00:07:06):
他当时的反应大概是：你现在来找我干嘛？你明天就要回密歇根了。到了 5 月我回到密歇根，电话响了，Ron 说：“大学招聘部门刚告诉我，我有一个应届生招聘名额，如果明天不用就作废了。”他说：“我甚至没法面试你，你也没法见团队，但你对我来说基本上是白送的名额。你想要这份工作吗？”
(01:07:38):
真是疯狂的幸运时刻，我得到了这份工作。1992 年夏天我来到苹果，我有一长串想做的事情来让 Finder 更好用。我记得坐在 Ron 的办公室里说：“在超市里，当你拎着购物袋出来时，门会自动为你打开。我觉得 Finder 也应该这样。当你拖动一个图标想放进文件夹时，你应该能悬停在文件夹图标上，然后自动钻进文件系统到达目的地。
(00:08:20):
当你放下文件时，所有在源地址和目的地之间打开的文件夹都会自动为你关闭。”Ron 觉得这个主意不错，那是当时苹果的工作方式。于是我就开始写代码。有一天深夜两点，苹果办公室没别人，我需要某种动画来暗示文件夹即将打开。
(00:08:48):
我显然不是动画师，半夜三更也不打算做什么深思熟虑的设计。我随手写了几行代码，让文件夹闪烁——选中、取消选中、选中、取消选中，一共闪了五次。我想，以后发邮件给那些天才视觉设计师，让他们做点更有趣的效果。长话短说，苹果在四年后终于发布了这个功能。在我们忙别的事情时，它一直躺在源代码库里。
(00:09:21):
四年后发布时，它依然闪烁五次。再过六七年，Mac OS X 问世，Finder 完全从头重写。最初找不到“弹簧文件夹”（spring-loaded folders）功能。人们抱怨后，它被重新实现了。代码全是新的，但当你悬停时，文件夹依然闪烁五次。又过了十年，iOS 出现了并加入了文件夹功能。当你拖动图标时，它也会闪烁几次。
(00:09:51):
我不确定这个故事的重点是什么，也许是关于我们作为设计师和产品人都会做的事：我们会采取一些捷径，心想以后再去清理。有时，这个小小的设计细节竟然在 30 年后、历经三次重写后依然存在，现在它已成为苹果产品运作方式的一部分。挺不可思议的。

---

### [00:10:16] Lenny

**English:**
As you were talking, I'm on a Mac right now recording this and I just did it just to make sure it's still there and it is indeed still there. I think it blinks three times and then just opens up for you.

**中文翻译:**
你说话的时候，我正用 Mac 录音，我试了一下，确认它还在，确实还在。我觉得它闪了三次，然后就为你打开了。

---

### [00:10:25] Tom Conrad

**English:**
There you go.

**中文翻译:**
就是这样。

---

### [00:10:26] Lenny

**English:**
Full engineers got royalties on features they build that continue to live on in our product.

**中文翻译:**
如果工程师能从他们开发的、并一直存在于产品中的功能里拿版税就好了。

---

### [00:10:30] Tom Conrad

**English:**
Okay, I'll tell you just one other little thing to center you in time about what the Finder was like in 1992. We didn't get royalties, but our names were in the About box. You would go to About the Finder and the seven of us, there were seven engineers at Apple that worked on The Finder. Our names would scroll by the Finder, copyright 1992, yada, yada, yada, one name after another. Totally different era.

**中文翻译:**
好，我再告诉你一件小事，让你感受一下 1992 年的 Finder 是什么样的。我们没有版税，但我们的名字在“关于”对话框里。你点击“关于 Finder”，我们七个人的名字就会滚动显示——当时苹果只有七个工程师负责 Finder。名字一个接一个滚过：Finder 版权所有 1992，等等等等。那完全是另一个时代。

---

### [00:10:55] Lenny

**English:**
It feels like you got what you wanted with the name scribbled on the motherboard.

**中文翻译:**
感觉你实现了愿望，就像名字刻在主板内侧一样。

---

### [00:10:59] Tom Conrad

**English:**
For sure. I've gotten a lot of the things I wanted as a kid.

**中文翻译:**
确实。我小时候想要的很多东西都实现了。

---

### [00:11:05] Lenny

**English:**
Along the same lines, I want to talk a bit about picking where to go work. Clearly you had a sense you wanted to go work at Apple. Over your career, you've landed at a lot of really successful places. You've also landed at a lot of very famous failures that we're going to talk about. What advice would you give people for helping them pick where to go work based on your experience?

**中文翻译:**
顺着这个话题，我想聊聊如何选择工作。显然你当时很清楚自己想去苹果。在你的职业生涯中，你加入过很多非常成功的公司，也经历过一些非常著名的失败案例，我们稍后会聊到。根据你的经验，你会给人们什么建议来帮助他们选择工作地点？

---

### [00:11:25] Tom Conrad

**English:**
When I was a kid, my ambition to work at Apple was entirely about the product, so probably that version of me would say, find a product that you're passionate about and go spend your time and energy on that thing. Pretty quickly you learn that an awful lot of your development and day-to-day satisfaction really comes from the people that you get to collaborate with. Can you learn from them? Do you like them? Do they challenge you in the right ways?
(00:11:53):
Do they give you latitude in the right ways? It's so much about not just what, but who. For a very long time, my advice would've been entirely in the category of life, find something that you love with people that you think are amazing and the rest will take care of itself. Interestingly, I have been lucky enough to have some things that were successful on the metrics, get talked about the most, big audiences, big financial return, et cetera, et cetera. I've also worked on some things that were really notable disasters. When I look back on my career and think about the things that I've done, my professional satisfaction is not well correlated with those external metrics and very, very coordinated with do I love the thing we were building and do I love the people I was working with?

**中文翻译:**
当我还是个孩子时，我想去苹果完全是为了产品。所以那个版本的我会说：找一个你充满热情的产品，把你的时间和精力投入其中。但很快你会发现，你职业发展中很大一部分以及日常的满足感其实来自于与你协作的人。你能从他们身上学到东西吗？你喜欢他们吗？他们是否以正确的方式挑战你？
(00:11:53):
他们是否给了你适当的自主空间？这不仅关乎“做什么”，更关乎“和谁做”。很长一段时间，我的建议完全属于生活范畴：找一件你热爱的事，和一群你认为很棒的人一起做，剩下的自然会水到渠成。有趣的是，我很幸运地参与了一些在指标上非常成功、被广泛讨论、拥有庞大受众并带来巨大财务回报的项目。但我也参与过一些著名的灾难性失败。当我回顾职业生涯时，我发现我的职业满足感与那些外部指标的相关性并不高，而与“我是否热爱我们正在打造的东西”以及“我是否热爱与我共事的人”高度相关。

---

### [00:12:43] Lenny

**English:**
Following the thread of the people. I think one of the hardest things is really knowing what the people are like until you join. I think as a chief product officer joining or VP of product, you have a lot of time that you spend with the team. Most people don't. They have an interview and then they're like, all right, I got to make a decision. Do you have any advice for how to help people get a sense if the people are the kind of people they want to work with?

**中文翻译:**
顺着“人”这个话题。我觉得最难的事情之一就是在加入之前真正了解那些人是什么样的。作为首席产品官或产品副总裁加入时，你会有很多时间与团队相处。但大多数人没有这种机会，他们参加完面试就得做决定。你有什么建议能帮助人们判断那些人是否是他们想要共事的人吗？

---

### [00:13:03] Tom Conrad

**English:**
I think people are really, really good at this. Every single time I've taken a job where it turned out that I was working with people who had a different set of values or working styles than I had, I knew. You tell yourself that, at least in my case, I tell myself a story about why the thing I suspect might be the case isn't the case. But you do this in your personal life all the time. You meet people out at dinner, so you get seated next to them at some industry event or something, and sometimes you come home and say to your partner, oh my gosh, the person next to me was just the worst. Then sometimes you're like, I think I made a permanent lifelong connection with this total stranger who just happened to sit next to me.

**中文翻译:**
我认为人们其实非常擅长这一点。每当我接受一份工作，结果发现共事的人与我的价值观或工作风格迥异时，其实我早就有预感。你会告诉自己——至少我是这样——编造一个故事来解释为什么我怀疑的情况可能并不存在。但你在个人生活中一直在做这种判断。你在外面吃饭，或者在行业活动中坐在某人旁边，有时你回家会跟伴侣说：“天哪，坐我旁边那个人简直糟透了。”而有时你会觉得：“我觉得我和那个恰好坐在我旁边的陌生人建立了一种终身的联系。”

---

### [00:13:55] Lenny

**English:**
It's a very simple piece of advice that I think people don't fully appreciate is just trust your instinct, trust your gut. Just pay attention to what comes up when you're around people at a certain company. Okay, you brought up this phrase of notable disasters, and I want to talk about that. You've worked at two of the most famous notable disasters of product companies, pets.com and Quibi. I think it's really rare someone sees the inside of so much hype and then such a fall at a company. I just want to spend some time in these two areas. Maybe the way to set it up is, what's a lesson you took away from each of these two experiences that you've taken with you to future work and maybe advice you share with people?

**中文翻译:**
这是一个非常简单但我觉得人们没有充分重视的建议：相信你的直觉，相信你的本能。留意你在某家公司的人身边时的感受。好，你提到了“著名的灾难性失败”这个词，我想聊聊这个。你曾在两家最著名的失败案例公司工作过：Pets.com 和 Quibi。我觉得很少有人能亲历如此巨大的炒作，然后又目睹公司如此惨烈的垮台。我想在这两个案例上多花点时间。也许可以这样开始：你从这两次经历中分别学到了什么教训，并带到了未来的工作中？你会给别人什么建议？

---

### [00:14:37] Tom Conrad

**English:**
Probably the biggest lesson, it's not really about the specifics of the business. The biggest lesson really is these things make you better. In some instances, actually, I think in both instances they became dominoes that opened doors for me in my own ambition and my own professional life that maybe just wouldn't have opened at all if I hadn't gone to those companies and learned those things and had those experiences. Frankly, even in the case of pets.com, even the high profile nature of it.
(00:15:09):
I could have worked at one of a thousand E-commerce websites in 1999. When I went on to some subsequent job interview or something and talked about my experience, they were like, I never heard of the thing that you worked on. But everybody certainly heard about pets.com. It's a pretty funny example too, of how some struggles are timeless. That was 23, 24 years ago now. While as a leadership team, we made I'm sure all kinds of mistakes.
(00:15:39):
One of the things that happened was that there were three overfunded pet E-commerce sites. We all raised in excess of $50 million, which is a tremendous amount of money now. It was a tremendous amount of money then. We all thought it was a zero-sum game. That as one player started to spend on promotion or to spend irrationally on national broadcast television advertising, we all did. It became this unwinnable arms race. There is, I think, a fundamental lesson about having an excess of investment can be its own albatross. Or lead you to make decisions that maybe would be unwise. Then of course, it's just like timing is really important. Chewy is a online pet store worth $9 billion today. They were a private company and bought by PetSmart and then spun back out. But when they were bought by PetSmart, they were acquired for three billion dollars. Biggest E-commerce acquisition of all time. Well, I think it's probably unfair to compare Chewy who executed exceptionally well over a decade, grew their business brick by brick and turned it into something really remarkable.
(00:17:07):
To pets.com, which was in a very, very different moment in time and tried to go to market in a really different way. The critique that is often leveled at pets.com, or at least at the time, was like, this is just a stupid business. They're shipping dog food around. You could never make that work. That's just wrong. You absolutely can make it work. Probably can't make it work when 80% of the country on the internet is still on dial up. It was really, really early.

**中文翻译:**
最大的教训可能并不关乎具体的业务细节。真正的教训是：这些经历会让你变得更好。在某些情况下，实际上在这两个案例中，它们都成了多米诺骨牌，为我的抱负和职业生涯打开了大门。如果我没去那些公司、没学到那些东西、没经历过那些事，这些门可能永远不会打开。坦白说，即使是 Pets.com，它的高知名度也帮到了我。
(00:15:09):
1999 年我本可以去一千家电商网站中的任何一家。如果我去参加随后的面试，谈论我的经验，他们可能会说：“我从没听说过你做的那玩意儿。”但每个人肯定都听说过 Pets.com。这也是一个有趣的例子，说明有些挣扎是永恒的。那是 23、24 年前的事了。虽然作为领导团队，我确信我们犯了各种错误。
(00:15:39):
当时的情况是，有三家资金过剩的宠物电商网站。我们都筹集了超过 5000 万美元，这在现在是一笔巨款，在当时更是天文数字。我们都认为这是一场零和博弈。当一个玩家开始疯狂投入促销，或者不理智地在全国广播电视上打广告时，我们都跟进了。这变成了一场无法获胜的军备竞赛。我认为这里有一个根本性的教训：过剩的投资本身可能成为一种负担（Albatross），或者导致你做出不明智的决定。当然，时机也非常重要。Chewy 是一家如今价值 90 亿美元的在线宠物商店。他们曾是一家私营公司，被 PetSmart 收购后又独立出来。被收购时的价格是 30 亿美元，是当时史上最大的电商收购案。我觉得把 Chewy 与 Pets.com 相比可能不太公平，Chewy 在十多年里执行得异常出色，一砖一瓦地建立起业务，将其变成了非凡的事业。
(00:17:07):
而 Pets.com 处于一个完全不同的时代背景，尝试了完全不同的进入市场方式。当时对 Pets.com 的批评通常是：“这业务太蠢了，运送狗粮根本赚不到钱。”这种说法是错的，你绝对可以让它盈利。只是当全国 80% 的上网用户还在用拨号上网时，你可能做不成。它出现得太早了。

---

### [00:17:33] Lenny

**English:**
I saw a stat, I think you shared somewhere, that you took pets.com from nothing to a public company to completely out of business in 19 months.

**中文翻译:**
我看到一个数据，好像是你分享过的：你见证了 Pets.com 在 19 个月内从无到有，到上市，再到彻底倒闭。

---

### [00:17:40] Tom Conrad

**English:**
Yeah, I think that's about right. The other thing that's forgotten in the tale is that we actually didn't go bankrupt. We shut the company down and returned the remaining balance to the investors, which no public company had ever done before. The leadership team just reached the conclusion that given the way market conditions had evolved, there was just no way we were going to be able to get more capital into the company. It was a company that required additional investment to get to profitability. It was better to wind down early, take the money that we had in the bank and get it back to investors than to just spend every last penny on what was a fruitless attempt to salvage it.

**中文翻译:**
是的，差不多是这样。故事中常被遗忘的一点是，我们其实并没有破产。我们关闭了公司，并将剩余资金退还给了投资者，这在当时的上市公司中是前所未有的。领导团队得出的结论是，鉴于市场环境的变化，我们根本无法再为公司注入更多资金。而这是一家需要持续投资才能实现盈利的公司。与其把最后一分钱都花在徒劳的挽救尝试上，不如早点收场，把银行里的钱还给投资者。

---

### [00:18:40] Lenny

**English:**
Did not know that. Let's talk about Quibi. What went wrong there? Do you think there was a path to Quibi having worked out? Any big lessons that you took away from that experience that you bring with you?

**中文翻译:**
这我还真不知道。那聊聊 Quibi 吧。那里出了什么问题？你觉得 Quibi 当时有成功的可能吗？你从那次经历中带走了什么重要的教训？

---

### [00:18:40] Tom Conrad

**English:**
The miraculous thing about Quibi for me was it re-lit my enthusiasm for the industry for doing this work. I had left in, I think it was December of 2018, and I thought that maybe I was just done making software. I had done it for a really long time, for 25 years or something. I had changed a lot. The industry had changed a lot. I thought maybe I just didn't have the same passion for it that I had a decade before. It also seemed like maybe it'd be fun to have another chapter of my life that was just completely different.
(00:19:23):
I had a whole list of things that I thought I might want to do. They're ridiculous. It's like maybe I want to be a pastry chef. Maybe I want to be a landscape photographer. Maybe I want to learn to make bad music to put up on SoundCloud or something. Really the only thing they had in common were they all things that I knew nothing about. People would be like, "Oh you think you might want to be a pastry chef? Do you like to bake?"
(00:19:42):
I'd be like, "No, I don't know anything about baking." "Oh, you like landscape photography. Do you take photos?" "No, I don't take photos." But I was committed to the bit, actually to the point where when Techwrench interviewed me about my departure from Snapchat, I was like, I'm out. I'm going to do something else entirely. That story is very much out there. But a few months after my last day at Snap, I got a call from Meg Whitman and Jeffrey Katzenberg who were starting up, it was for New TV at the time.
(00:20:15):
The pitch was, we're going to try to take the best of mobile and Silicon Valley and consumer tech and weld it to the best of Hollywood style content production. To build something completely bespoke and purpose made for consumption on the phone. They were looking for both technology leadership and product leadership and wanted to know if I was interested in one or both. I took the meeting, even though I wasn't really taking these kinds of calls from anybody, it just seemed like who's going to pass up the opportunity to have lunch with the two of them?
(00:20:50):
I listened to the pitch and politely declined and told them that I was going to be a pastry chef or something. We kept doing that every couple of months for seven months. We'd go to lunch, they would give me an update on the progress they were making, and I would decline the invitation to get involved somehow. Then late in that year, I went to lunch one more time, and Meg explained that they brought on someone to lead technology and they brought another person to lead product.
(00:21:26):
Both of them really truly for reasons that are completely disconnected from Quibi itself. Both of them had left after about six weeks. Meg's like, "We've raised all this money and we told the world that we're shipping this product in about a year. We got an awful lot to do, and I really could use some help. I would consider it a personal favor if you were to come and spend just a couple of days a week helping." She's like, "I'll continue to look for someone who actually wants the job, but it'd be great if you could help me get this off the ground." My wife is a freelance writer, marketing strategist, and loves her life as a freelance contributor. She's like, "You should do this. Why not? It's two days a week. It's just a few months. What's the worst thing that could happen? Maybe you'll like it?" I'm like, "No. Here's the thing that will happen. I won't do it two days a week. It will immediately be three days, then four days, then five days, then six days. I just know myself."
(00:22:27):
She's like, "No." She's like, "Just on Wednesday night at six o'clock, close your Quibi laptop and be like, all they're paying me for is for Tuesday and Wednesday and then open it back up on Tuesday morning. That's all you've got to do." Well, she's right about most things and she's wrong about this. I fell deeply into it right away. It was just so fun to get to build a team from scratch and to design and build a product from scratch.
(00:22:58):
To take advantage of all of the modern software architecture stuff that had come into being over the course of the 15 years since we had started Pandora. I'm embarrassed about some of what happened with Quibi for sure, but I'm super grateful for the experience. I just really fell in love with the industry again, and was reminded of just how rewarding it can be to build something and to try to put it out there even if you stumble pretty mightily along the way.

**中文翻译:**
Quibi 对我来说最神奇的地方在于，它重新点燃了我对这个行业、对这份工作的热情。我在 2018 年 12 月离开（Snap），当时我觉得自己可能再也不想做软件了。我已经做了很久，大概 25 年。我变了很多，行业也变了很多。我觉得自己可能不再拥有十年前那种激情了。我也觉得开启一段完全不同的人生篇章可能会很有趣。
(00:19:23):
我列了一长串我想做的事，都很离谱。比如我想当个点心厨师，或者风光摄影师，或者学着做点烂音乐发到 SoundCloud 上。这些事的共同点是我对它们一窍不通。人们会问：“你想当点心厨师？你喜欢烘焙吗？”
(00:19:42):
我会说：“不，我对烘焙一无所知。”“你喜欢风光摄影？你拍照片吗？”“不，我不拍。”但我当时很认真，甚至在 TechCrunch 采访我离开 Snapchat 的原因时，我说我要彻底退出，去做点别的。那个故事传得很广。但在我离开 Snap 几个月后，我接到了 Meg Whitman 和 Jeffrey Katzenberg 的电话，他们当时正在筹备 New TV（Quibi 的前身）。
(00:20:15):
他们的核心理念是：把移动端、硅谷和消费科技的精华，与好莱坞风格的内容制作结合起来，打造完全定制化、专为手机消费而生的内容。他们正在寻找技术负责人和产品负责人，想知道我是否感兴趣。我参加了会面，虽然当时我基本不接这类电话，但谁会拒绝和他们两位共进午餐的机会呢？
(00:20:50):
我听了他们的构想，礼貌地拒绝了，告诉他们我要去当点心厨师。接下来的七个月里，我们每隔几个月就吃顿饭。他们会告诉我进度，而我会拒绝加入。直到那年年底，我又去吃了一次午餐，Meg 解释说他们招到了技术负责人和产品负责人。
(00:21:26):
但由于一些与 Quibi 本身无关的原因，那两个人在六周后都离开了。Meg 说：“我们筹了这么多钱，告诉全世界一年后要发布产品。我们有很多工作要做，我真的需要帮助。如果你能来每周帮两天忙，我会觉得欠你一个人情。”她说：“我会继续找全职的人，但如果你能帮我把项目启动起来就太好了。”我妻子是一名自由撰稿人和营销策略师，她很喜欢自由职业的生活。她说：“你应该去，为什么不呢？每周两天，就几个月。最坏的情况能怎样？万一你喜欢呢？”我说：“不，情况会是这样：我不会只做两天。它会立刻变成三天、四天、五天、六天。我了解自己。”
(00:22:27):
她说：“不会的。只要在周三晚上六点关掉 Quibi 的电脑，心想他们只付了我周二周三的钱，然后周二早上再打开。你只需要做到这一点。”好吧，她在大多数事情上都是对的，但在这一件上错了。我立刻深陷其中。从零开始组建团队、设计和构建产品真的太有趣了。
(00:22:58):
而且能利用自 Pandora 创立以来 15 年间出现的所有现代软件架构。虽然我对 Quibi 发生的一些事情感到尴尬，但我非常感激那段经历。它让我重新爱上了这个行业，并提醒我，即使一路上跌跌撞撞，亲手打造并发布一些东西是多么有成就感。

---

### [00:23:35] Lenny

**English:**
Is there something that you took away from that experience that taught you what to try to avoid? What to try to pull towards?

**中文翻译:**
你从那次经历中吸取了什么教训，教你该避开什么，或者该追求什么？

---

### [00:23:43] Tom Conrad

**English:**
I think I misunderstood or misjudged companies sometimes by thinking about them really focused on the product execution. If you find an interesting problem that people care about and you solve that problem in a really beautiful, elegant, delightful way, that's 10 times better than anything else that they can get in that same space, they'll tell their friends and all the rest will take care of itself. That was always my ambition.
(00:24:16):
Find a thing that I cared about building, do a great job building it really delightful way. Go really deep on listening to people and their feedback and iterate your way to success and breaking through that membrane that we all strive to get across. The really great word of mouth. But I think the thing I've come to better appreciate is that companies are also like a math problem that describes how you take investment and pour them into the equation and out the other side comes returns on some time horizon.
(00:24:54):
Yes, there are variables in that equation that are influenced by the product that you build and all of the little details and decisions that you make about making that product great. But if the equation is fundamentally broken or a big swing in and of itself, no amount of iteration and execution can get you out of the failed outputs of the broken equation. I think Quibi made a bet that you could build an entirely bespoke content library that was sufficiently scaled to get people to subscribe and retain for a couple billion dollars. It was a huge amount of money. But we made 70 shows in 18 months, which is more content than all of the major broadcast networks combined made in a single year. It was a pretty major accomplishment. We made a bet that we would augment those sort of-

**中文翻译:**
我想我有时会误解或误判公司，因为我太专注于产品执行了。我曾认为：如果你发现一个人们关心的有趣问题，并以一种优美、优雅、令人愉悦的方式解决它，比同领域的其他任何东西好上 10 倍，人们就会告诉朋友，剩下的自然会解决。这曾一直是我的志向。
(00:24:16):
找一件我关心的事，把它做得非常出色、非常讨喜。深入倾听人们的反馈，通过迭代走向成功，冲破我们都渴望跨越的那层膜——也就是真正的口碑传播。但我现在更深刻地意识到，公司也像一个数学题，描述了你如何将投资投入等式，并在某个时间范围内从另一端获得回报。
(00:24:54):
是的，等式中确实有变量受你打造的产品以及你为使产品卓越而做的细节决策影响。但如果等式本身从根本上就是错的，或者本身就是一个巨大的豪赌，那么再多的迭代和执行也无法挽救错误等式带来的失败结果。我认为 Quibi 当时押注的是：你可以花几十亿美元建立一个完全定制的内容库，其规模足以吸引人们订阅并留存。那是一笔巨款。我们在 18 个月内制作了 70 部剧集，这比所有主要广播网络一年制作的内容总和还要多。这是一个巨大的成就。我们押注我们会增强那些——

---

### [00:26:00] Tom Conrad

**English:**
And we made a bet that we would augment those sort of episodic and serialized or Hollywood style shows with a bunch of daily content that we produce at the level of network television, nightly news, and so forth, that would be an alternative to some of the sort of daily content that you might otherwise get on YouTube. And that was going to be about a third of the content spend.
(00:26:26):
One super interesting thing that no one talks about is that all of that content was designed to be made day of or day before it aired, so there was no back catalog of it. And it was all designed to be shot in these professional studios that we built out. It was really expensive, like I said, it was like a third of the investment we were going to making content, almost half the investment we were going to be making content.
(00:26:51):
And we launched two weeks into Covid and we couldn't make any of that content, except literally in the garages of the host's homes. And so we had this thing that was supposed to seem really set apart from YouTube, that literally now was being made exactly YouTube content, which is sort of like self-produced at home with very little sort of the support infrastructure of Hollywood. Now, you can argue, I think the content on YouTube is really, really exceptional in this category, and maybe we were never going to do better than that.
(00:27:26):
But I think what was really fundamentally broken with Quibi was that the actual foundational equation of can you make enough premium content that's totally bespoke and made for the service and takes advantage of the nature of the phone, it is enough content to get people to sign up and retain, and can you do that for a couple billion dollars? And I think the answer is no. The library has to be much, much bigger, and you have to have, like any company, you have to have sufficient time and energy to iterate on the content format itself, because our roadmap really wanted to innovate on the content format.
(00:28:06):
And so I think part of what happened is pretty quickly it became clear that the math was just wrong. It wasn't going to take 2 billion, it was going to take 6 or 8 or 10 billion. And the risk reward profile of betting 10 billion on the format was just more than anyone could stomach.

**中文翻译:**
我们押注我们会用一系列每日更新的内容来增强那些剧集式、连载式或好莱坞风格的节目。这些每日内容的制作水平相当于网络电视、晚间新闻等，旨在替代你可能在 YouTube 上看到的日常内容。这部分占了内容支出的约三分之一。
(00:26:26):
一件没人提过的非常有趣的事是：所有这些内容都设计为在播出当天或前一天制作，所以没有“过往内容库”（Back catalog）。而且它们都设计在我们在各地建立的专业工作室里拍摄。这非常昂贵，正如我所说，占了内容投资的三分之一，甚至接近一半。
(00:26:51):
结果我们在新冠疫情爆发两周后上线，我们根本无法制作那些内容，除非是在主持人家里的车库里拍。所以我们这个原本应该与 YouTube 截然不同的东西，现在做出来的东西看起来和 YouTube 内容一模一样——在家自制，几乎没有好莱坞的支撑基础设施。现在你可以争辩说，YouTube 在这类内容上做得非常出色，也许我们永远做不到更好。
(00:27:26):
但我认为 Quibi 真正根本性的问题在于那个基础等式：你是否能制作足够的、完全定制的、专为该服务打造并利用手机特性的优质内容，其数量足以让人们注册并留存，且成本控制在几十亿美元内？我认为答案是否定的。内容库必须大得多，而且像任何公司一样，你必须有足够的时间和精力去迭代内容格式本身，因为我们的路线图非常想在内容格式上创新。
(00:28:06):
所以我觉得情况是，很快大家就发现数学模型错了。这不需要 20 亿，而是需要 60 亿、80 亿甚至 100 亿。而在这种格式上赌 100 亿的风险回报比，超出了任何人的承受能力。

---

### [00:28:27] Lenny

**English:**
Wow. I really like this metaphor and this mental model of the math formula of the entire business and thinking of it that way. I knew Covid changed the way people consumed content and that hurt. Quibi I think it was meant to be on the go, not sitting at home where you could watch anything you want. But also the fact that the content couldn't be made as well, as you were hoping to make.

**中文翻译:**
哇。我非常喜欢这个关于整个业务“数学公式”的比喻和思维模型。我知道新冠改变了人们消费内容的方式，这打击很大。Quibi 本意是让人们在碎片时间观看，而不是坐在家里看。但内容无法达到预期的制作水平也是一个重要因素。

---

### [00:28:46] Tom Conrad

**English:**
Yeah, for sure.

**中文翻译:**
是的，确实如此。

---

### [00:28:49] Lenny

**English:**
As a CPO, one of the biggest challenges is pushing back, trying to convince the founders of their mistakes, of doing what they want and just powering through it and dealing with it sometimes I guess is there anything you think you could have done looking back, or was the math formula set up for failure from the beginning and it's probably just not going to work out almost no matter what you did?

**中文翻译:**
作为首席产品官（CPO），最大的挑战之一就是推翻或说服创始人意识到他们的错误，而不是仅仅按他们的意愿硬推下去。回过头来看，你觉得有什么是你本可以做的吗？还是说那个数学公式从一开始就注定了失败，无论你怎么做都行不通？

---

### [00:29:10] Tom Conrad

**English:**
One of the bets was that we weren't going to just use the apparatus of Hollywood to make the content. In part, we are going to use the apparatus of Hollywood to market the content. So Jeffrey had recruited this incredible Rolodex of literally the world's most famous celebrities to make shows for Quibi. We kind of had everyone either made something for launch or was going to make something.
(00:29:42):
And part of what they're going to do is turn up in culture and talk about their shows. We've heard a lot in the last six months about how hard it's to market movies because the stars can't go out and talk about the movies during the strike.
(00:29:54):
There was this theory that you could apply the marketing technique of Hollywood to get 20, 30 million people into the theater on opening weekend for Quibi. And that was always a very, very audacious take, I thought. Uber has all the money in the world to experiment with paid user acquisition, and they're not consistently a top 10 most downloaded app in the app store.
(00:30:26):
But the theory of Quibi, the math of Quibi, did require us to from day one land in the top 10 and stay there forever. The model would have worked if we could do that. And to the Hollywood marketing apparatus, the numbers that it takes to get there felt kind of small. If you can get 20 million people in to see Shrek on opening night new IP, surely you can get them to take their phone out of their pocket and download this thing and start a free trial.
(00:30:54):
Now, those of us who have spent our life in Silicon Valley making software and really, really tried to get people to show up and download new IP in large numbers know just how hard that is.
(00:31:09):
So maybe if I critique my own contribution to the math equation, maybe I should have beat the drum a little harder about just how unlikely it was that we were going to land the kind of distribution in month one that the model sort of required. If I had to go back and do it again, I think I would spend maybe more time investing and illuminating that aspect of the digital universe.

**中文翻译:**
当时的赌注之一是，我们不仅要利用好莱坞的机制来制作内容，还要利用好莱坞的机制来营销内容。Jeffrey 动用了他那惊人的“人脉网”（Rolodex），招揽了几乎全世界最著名的明星为 Quibi 制作节目。基本上每个人要么在首发时有作品，要么正准备做。
(00:29:42):
他们的任务之一就是出现在文化视野中谈论他们的节目。过去六个月我们听到了很多关于电影营销有多难的消息，因为罢工期间明星不能出来宣传。
(00:29:54):
当时有一种理论认为，你可以应用好莱坞的营销手段，让 2000 万、3000 万人在首周末“进入剧场”（下载 Quibi）。我觉得这一直是一个非常、非常大胆的想法。Uber 有全世界最充足的资金来尝试付费获客，但他们也不是一直都能排在应用商店下载榜的前 10 名。
(00:30:26):
但 Quibi 的理论和数学模型要求我们从第一天起就进入前 10 名并永远留在那里。如果能做到，模型就能跑通。对于好莱坞的营销机器来说，达到这个数字所需的努力似乎并不大。如果你能让 2000 万人在首映当晚去看《怪物史莱克》这个新 IP，那你肯定能让他们从兜里掏出手机，下载这个东西并开始免费试用。
(00:30:54):
然而，我们这些在硅谷做了一辈子软件、拼命想让人们大规模下载新 IP 的人知道，这有多难。
(00:31:09):
所以，如果我要反思自己对那个数学公式的贡献，也许我应该更用力地敲响警钟，告诉大家在第一个月就达到模型所需的那种分发量是多么不可能。如果让我重来一次，我想我会花更多时间去阐明数字世界的这一面。

---

### [00:31:42] Lenny

**English:**
That is such a good takeaway of just showing the leaders, here's the data, here's the assumptions that we're all betting on, and do you believe this can happen? And they probably would've said, "Yes, this will happen. I'm so confident."

**中文翻译:**
这是一个非常好的总结：向领导者展示数据，展示我们都在押注的假设，并问：“你相信这能发生吗？”他们可能会说：“是的，会发生的，我非常有信心。”

---

### [00:31:55] Tom Conrad

**English:**
What made it hard was, it wasn't structurally impossible. If you had to be bigger than any app that had ever been made, then you could probably make the case it's impossible. But since you only sort of had the land in the top 10, you couldn't quite say it was impossible, you could just say it was highly improbable.
(00:32:18):
And maybe one of my mistakes was, I guess I imagined that we would launch, and when the likely thing happened that we got millions of people to download the app, which we did, and then when we inevitably struggled to retain those users at high percentages, and we retained at what I think of as a good industry starting point, but we weren't setting any records on retention. I just imagined that what would happen next is the thing that happens in all young companies, you would iterate. You would grind on the funnel until a year later, two years later, six months later, whatever it is. You figured the formula out to get people in and get them to stay and get them to retain.
(00:33:12):
And what I didn't appreciate was just how quickly you go back to the foundational math and then the math really says you just can't. You can't spend two years iterating your way on optimizing the funnels like you would in a startup that had a different cost structure. In a world where you have to spend a billion dollars a year of making content, you just can't afford to not be a hit.

**中文翻译:**
难点在于，这在结构上并非不可能。如果你必须比史上任何应用都大，那你可以说不可能。但既然只是进入前 10 名，你不能说不可能，只能说极度不可能（Highly improbable）。
(00:32:18):
也许我的错误之一是，我设想我们上线后，会有数百万人下载应用（我们也确实做到了），然后不可避免地在留存率上挣扎。我们的留存率在行业初期水平来看还算不错，但并没有创造纪录。我当时以为接下来会发生所有年轻公司都会经历的事：迭代。你会不断打磨漏斗，直到一年后、两年后或六个月后，你找到了让人们进来并留下的公式。
(00:33:12):
但我没意识到的是，你会非常快地回到基础数学模型上，而数学模型会告诉你：你做不到。你不能像其他成本结构不同的初创公司那样花两年时间去优化漏斗。在一个每年必须花 10 亿美元制作内容的世界里，你输不起，你必须一炮而红。

---

### [00:33:40] Lenny

**English:**
I think it's also important to just remind us, it's okay for these things to happen. People take a bet, as you said, we're going to try this thing, here's our bet, here's our experiment. We're betting on this sort of format in this business. We're going to raise money from investors that know they might lose all their money. And it sometimes doesn't work out. It's part of the game.

**中文翻译:**
我觉得提醒大家这一点也很重要：发生这些事是可以接受的。人们进行押注，就像你说的，我们尝试这个东西，这是我们的赌注，这是我们的实验。我们在这种业务中押注这种格式。我们从知道可能会血本无归的投资者那里筹钱。有时它就是行不通。这是游戏的一部分。

---

### [00:33:56] Tom Conrad

**English:**
It's certainly painful to take money from investors even if they know what they're doing and to not get them a return. I feel a real responsibility to investors to do better than we did at Quibi.
(00:34:08):
But yeah, I mean, there is a risk reward thing that goes along with these investments, and part of the reason they get all the riches on the upside is that they're going to bet on some Quibis along the way too.

**中文翻译:**
从投资者那里拿钱却没能给他们回报，这当然是痛苦的，即使他们知道自己在做什么。我感到对投资者负有真正的责任，应该比我们在 Quibi 做得更好。
(00:34:08):
但是，投资本身就有风险回报比，他们之所以能在成功时获得巨额财富，部分原因也是因为他们一路上也会投中一些像 Quibi 这样的项目。

---

### [00:34:18] Lenny

**English:**
So as you were talking, you said that it was called NewTV, and that sparked a memory, and I searched my email. And I actually got an email from a recruiter in 2018, we just kicked off a very special executive opportunity, the CPO at NewTV, a new venture in Los Angeles, with Jeffrey Katzenberg and Meg Whitman, raising a billion dollars, working with top talent. Are you interested in exploring this opportunity?

**中文翻译:**
你刚才提到它叫 NewTV，这勾起了我的回忆。我搜了一下邮件，发现 2018 年我确实收到过猎头的邮件：“我们刚刚启动了一个非常特别的高管机会，NewTV 的首席产品官（CPO）。这是 Jeffrey Katzenberg 和 Meg Whitman 在洛杉矶的新项目，筹资 10 亿美元，与顶尖人才共事。你有兴趣了解一下吗？”

---

### [00:34:41] Tom Conrad

**English:**
Lenny, Lenny, Lenny. Your story could have been so much different.

**中文翻译:**
Lenny，Lenny，Lenny。你的故事本来会完全不同。

---

### [00:34:46] Lenny

**English:**
This could have been Thomas podcast. Lenny, tell me about what happened at Quibi.

**中文翻译:**
那现在可能就是 Tom 的播客了：“Lenny，告诉我 Quibi 到底发生了什么。”

---

### [00:34:51] Tom Conrad

**English:**
I would take that free.

**中文翻译:**
我愿意免费上那个节目。

---

### [00:34:54] Lenny

**English:**
I don't know. There's pros and cons. They even sent this whole PDF, a TV in your pocket, NewTV. Amazing. All right. I'm going to read through this and see what they pitched back in the day.
(00:35:05):
Okay, let's move on to things that worked out really well, let's call it notable successes, other products you worked on that worked out great. So I'll list a few of them. And maybe what might be helpful is just we'll just go through each one and share what you took away from that experience, a lesson you learned from working on those products.
(00:35:23):
The ones that come to mind for me are Snap, Pandora, Apple if we want to go there. Also, you built, I don't know exactly what you did there, but you worked on You Don't Know Jack, this game that I loved. I think if you're an elder millennial, you're just going to like, "Oh my God, I love that game." I don't even remember it exactly, but I just remember the visceral feeling of playing that game and it was so much fun. So that's cool. I didn't know that you worked on that. And then there's also Sonos, which you're on the board.
(00:35:49):
So whatever order you think might be most interesting, just going through those and what did you learn from that experience?

**中文翻译:**
我不知道，凡事都有利弊。他们甚至发了一个完整的 PDF，标题是“口袋里的电视，NewTV”。太神奇了。好，我会读读这个，看看他们当年是怎么推销的。
(00:35:05):
好，让我们聊聊那些非常成功的案例，也就是“著名的成功”。我列举几个你参与过且表现出色的产品。也许我们可以逐一过一遍，分享你从这些经历中学到了什么。
(00:35:23):
我想到的是 Snap、Pandora，如果愿意的话还有苹果。另外，你还参与过《你不了解杰克》（You Don't Know Jack），那是我非常喜欢的一款游戏。如果你是“老千禧一代”，你肯定会感叹：“天哪，我爱死那款游戏了。”我不记得细节了，但我记得玩那款游戏时那种直观的快感，非常有趣。这太酷了，我以前不知道你参与过。还有 Sonos，你是董事会成员。
(00:35:49):
按照你觉得最有趣的顺序，聊聊你从这些经历中学到了什么？

---

### [00:35:56] Tom Conrad

**English:**
I worked at Apple in the interval where Steve was gone, John Skelly, that kind of period, so System 7, System 8, Power Macintosh, that whole era. And we were doing a lot. We shipped a bunch of great hardware. We transitioned the company from Motorola 68,000 CPUs to the Power PC architecture.
(00:36:19):
But, particularly in that transition, we really struggled to ship consumer software features. I mentioned that I wrote three LAN folders and some other consumer features in my first six months at Apple, and they shipped four years later, actually after I'd left the company. I was a little surprised they were still in the software repository even, candidly.
(00:36:40):
But I'll tell you that one of the things culturally about Apple in that moment was, at least I felt like, a person was really rewarded if they could make a kind of broad contribution across functions. So if you were a talented software engineer, but also a thoughtful product designer, and maybe also had interesting input on product marketing, that you could build a really great reputation inside the company by playing all of those positions a little bit day to day.
(00:37:19):
And so when I left Apple after four years, I look back on my time, I didn't ship as much software as I had hoped, and I felt like a little bit like a professional gadfly. I was six miles wide and a centimeter deep.
(00:37:36):
And I went to work for this company called Berkeley Systems. In addition to You Don't Know Jack, they made a flying toaster screensaver, if you remember. You remember the nineties?

**中文翻译:**
我在苹果工作的时期是乔布斯离开后，John Sculley 掌权的那个阶段，也就是 System 7、System 8、Power Macintosh 那个时代。我们当时做了很多事，发布了一堆很棒的硬件。我们将公司从摩托罗拉 68000 CPU 转型到了 Power PC 架构。
(00:36:19):
但是，特别是在那个转型期，我们在发布消费者软件功能方面非常吃力。我提到过，我在苹果的前六个月就写好了弹簧文件夹和其他一些功能，但它们在四年后才发布，那时我已经离开公司了。坦白说，我很惊讶它们居然还留在代码库里。
(00:36:40):
但我告诉你，当时苹果的一种文化是，至少我觉得，如果一个人能跨职能做出广泛贡献，就会得到奖励。如果你是一个天才软件工程师，同时也是一个深思熟虑的产品设计师，甚至在产品营销上也有有趣的见解，你就可以通过每天在这些岗位上都参与一点，在公司内部建立起极好的声誉。
(00:37:19):
所以当我工作四年离开苹果时，回顾那段时光，我发现我发布的软件没有预想的多，我觉得自己有点像个“职业牛虻”（Professional gadfly，指到处插手但不深入的人）。我的知识面有六英里宽，但深度只有一厘米。
(00:37:36):
然后我去了一家叫 Berkeley Systems 的公司。除了《你不了解杰克》，他们还做了那个著名的“飞行烤面包机”屏幕保护程序，如果你还记得的话。你记得 90 年代吗？

---

### [00:37:48] Lenny

**English:**
How could you forget that?

**中文翻译:**
怎么可能忘得了那个？

---

### [00:37:50] Tom Conrad

**English:**
And when I met them, they were picking off this game development for this trivia game, and were looking for someone to lead the technical team. And so I joined as technical director for the You Don't Know Jack franchise, managed a team of engineers, and it was a completely different culture than what I was used to at Apple.
(00:38:11):
It was certainly the case that I was welcome to weigh in on the game design or the marketing or some other aspect of the deliverables, but my job was to build the software on time with high quality, period. And if I did those things, I'd be rewarded. And if I didn't, I would not be successful. And no amount of insightful feedback on the gameplay or the packaging, or whatever else I might want to do, was going to benefit me and my career at all.
(00:38:48):
And it was such a blessing to be forced to go deep on something, because I spent a lot of time developing chops as an engineering manager, but I also wrote a ton of software. And that's really honestly when I became a software engineer. My college education was insufficient to get me there, and the amount of software I wrote at Apple was insufficient to get me there. But I came out of my Berkeley Systems You Don't Know Jack experience feeling like I could really hold my own technically in a way that just wouldn't have happened.
(00:39:20):
And so I do think that there's something to be said for a culture where there are swim lanes and people are encouraged to be really, really exceptional in their lane. And so I feel really lucky that I stumbled into You Don't Know Jack When I did.
(00:39:36):
And it was also, I mean, it was the first thing that I worked on that had just huge cultural awareness for a couple of years. I mean, it's crazy, they're still making sequels. It has been nearly 30 years, and there are versions of You Don't Know Jack that are in all of the stores, in the PlayStation store, in the Xbox store, in the iOS store. You can play new versions of You Don't Know Jack to this day. It's crazy.

**中文翻译:**
当我见到他们时，他们正在开发这款问答游戏，寻找技术团队负责人。于是我加入并担任了《你不了解杰克》系列的技术总监，管理一个工程师团队。那里的文化与我在苹果习惯的完全不同。
(00:38:11):
在那里，虽然欢迎我对游戏设计、营销或其他方面发表意见，但我的核心工作是：按时、高质量地构建软件，仅此而已。如果我做到了，就会得到奖励；如果没做到，我就不算成功。无论我对游戏玩法或包装有多少深刻的见解，都对我的职业生涯毫无帮助。
(00:38:48):
被迫深入钻研某件事真是一种福气。我花了很多时间培养作为工程经理的能力，同时也写了大量的代码。老实说，那才是我真正成为软件工程师的时候。我的大学教育不足以让我达到那个水平，在苹果写的代码量也不够。但在 Berkeley Systems 的经历让我觉得自己在技术上真正立住了脚，这是以前从未有过的。
(00:39:20):
所以我认为，一种拥有明确“泳道”（Swim lanes，指职责范围）并鼓励人们在自己的领域做到极致的文化是非常有价值的。我很幸运在那个时候遇到了《你不了解杰克》。
(00:39:36):
而且，那是我参与的第一个在几年内拥有巨大文化影响力的项目。疯狂的是，他们现在还在出续集。快 30 年了，各个商店里都有它的版本：PlayStation、Xbox、iOS。直到今天你还能玩到新版。太不可思议了。

---

### [00:40:07] Lenny

**English:**
Did not know that. I see the website now and it's a little different, but basically the same.

**中文翻译:**
我以前不知道。我现在看它的网站，虽然有点变化，但核心还是一样的。

---

### [00:40:13] Tom Conrad

**English:**
So I'd say my lesson from You Don't Know Jack was definitely, it really does pay to get good at something and not just be a generalist.
(00:40:24):
And then, I mean Pandora, it wasn't quite the next thing that happened. After You Don't Know Jack was Pets.com, and then after Pets.com there was nuclear winter in the industry and I worked in enterprise software for a while.
(00:40:37):
And after nuclear winter I had this idea that I was going to build a destination for music discovery on the web. And I've been doing enterprise software, the consumer intranet was non-existent for those years, early aughts.
(00:40:54):
But around 2004, things started to thaw a little bit and you started to hear the first signs of the companies that we came to call Web 2.0, Flickr would've been one of the early examples. And one of the enterprise software things I did was a personalization recommendation engine that used a vector space. It's like a lot of the things that we're talking about now in AI, albeit 20 years ago.
(00:41:21):
And so I knew something about recommendation systems in the enterprise space, and I was super passionate about music. I'm not a musician, but I was that kid in college who would corner you and be like, oh, if you like this band, I got to play this for you and [inaudible 00:41:37] with stereo until you would beg to leave.
(00:41:40):
And so I had this idea that maybe I can use the internet to do that at scale, not with just one person, but with hundreds of thousands of people or millions of people maybe. Introduce them to music that they would love but otherwise would miss out on.
(00:41:53):
And I promised that I was going to tell stories about luck in my career, there's been a gazillion of them. But one really dramatic incidence of that is I was sort of biding my time to exit this enterprise software company. I was VP of engineering, a whole team that reported to me. I felt a lot of responsibility to exit in a responsible way. But I was really excited about this digital music company that I was going to start. But I wasn't telling anyone at all because I didn't want ti to get back to the team.
(00:42:25):
So I flew down to Los Angeles to go out to Coachella in the spring of 2004, and completely randomly physically bumped into a guy that I had gone to high school with on the polo field, and hadn't seen him in a decade. And the thing that we had in common in high school was we loved music. And so I tell them the story of, I'm going to start this company to do personalized digital music on the internet. And he said, there's this woman I work with who just left our company to move to Oakland to work for this little company called Savage Beast that are also doing something in music recommendation. Do you want to talk to them? And I said, "Sure, why not?"
(00:43:11):
So I got introduced to Tim Westergren, who was the founder of Savage Beast. Savage Beast was like a seven or eight full-time employees at that point. They made a music recommendation engine that they licensed to other companies to put in consumer products. So Savage Beast's customers were Best Buy, who put it in kiosks, and AOL, who used it on the AOL Music website. And they were looking for a VP of engineering. And I got the offer, thought about it a little bit. I declined because it was kind of this B2B2C thing and I really wanted to do something consumer and I had an idea about the app.
(00:43:49):
And a month later, they called again and said, "We keep talking to people. We really think that you're the person." And interestingly, one of the reasons they thought that I was the person is they were really impressed by the fact that I had run engineering at Pets.com. So I mean, it's just one of those things where these things do pay dividends, even when they're a disaster.
(00:44:07):
And honestly, what I would really say was almost like a lapse in judgment, I said yes, even though it wasn't the product that I wanted to build. And I won't bore you with all of the details, but 90 days later, after some typical early stage founder drama stuff, the founding head of technology and product had resigned completely unrelated to my arrival. And the company had a new CEO, Joe Kennedy, and Joe had this idea for what he called the 1-Click Personal Radio. And Joe is a product marketer and just the best CEO in the whole world. We spent 10 years together building Pandora.
(00:44:51):
And he sort of gave me the keys and just said, "As long as it fits the brief for 1-Click Personal Radio, it's all yours." And I got to build the team and the culture, in collaboration with him and Tim the founder, over the course of the next 10 years, and just every good thing.
(00:45:14):
So I mean, there's just a million billion lessons from Pandora, and everything I am as a product leader and then an engineering leader comes from things that happen at Pandora.
(00:45:24):
But maybe the thing that I think of first is, I think we met our early audience in an incredibly genuine way. For example, when we launched the support@pandora.com was an alias for all@pandora.com. So if you sent a customer service request to Pandora, every single person in the company received it. And because we made a decision to have no customer support team in the first year, the expectation was that whoever sees the request first should respond to it.
(00:46:01):
And so you would write to us and you would get the founder or you'd get me or you'd get the engineer who wrote the feature or you'd get the CEO. And there were no macros to respond to commonly asked question. There was no read the FAQ. And there were no rules about what you could and couldn't say. If the person's like, "I think this feature is stupid and broken," we would encourage people to say, "You know what? I think you're right and I'm really struggling to get our stupid head of product to agree with me. I'm going to CC Tom and maybe we can convince him that this was a bad decision."
(00:46:35):
And we did all of that because we thought one of our superpowers as a young company was that we could just engage with our audience as real human beings, not as a shiny brand that was trying to be something that we could just never be. This period is where the iPod and iTunes are at the peak of their powers. And so there was no way we could sort of out-Apple Apple on the brand front.
(00:47:02):
And so we were just ourselves, and I think it really, really was a catalyst for the word of mouth that developed around Pandora. And we never spent any money on paid user acquisition, literally no dollars in the entire time I was there, because people loved the product and they told their friends about it and that's how it grew.

**中文翻译:**
所以我从《你不了解杰克》中学到的教训是：精通某件事确实是有回报的，而不仅仅是做一个通才。
(00:40:24):
然后是 Pandora。在那之后并不是立刻发生的。在《你不了解杰克》之后是 Pets.com，然后行业进入了“核冬天”（Nuclear winter），我做了一段时间的企业软件。
(00:40:37):
核冬天过后，我萌生了一个想法：在网上建立一个发现音乐的平台。当时我一直在做企业软件，21 世纪初那几年消费级互联网几乎不存在。
(00:40:54):
但到了 2004 年左右，情况开始回暖，你开始听到后来被称为 Web 2.0 的公司初露头角，Flickr 就是早期例子之一。我当时做的一个企业软件项目是一个使用“向量空间”（Vector space）的个性化推荐引擎。这很像我们现在讨论的 AI 技术，只不过是在 20 年前。
(00:41:21):
所以我对企业领域的推荐系统有所了解，而且我对音乐充满热情。我不是音乐家，但我就是大学里那种会把你逼到墙角说：“如果你喜欢这个乐队，我一定要放这个给你听”的人，直到你求着要走。
(00:41:40):
于是我产生了一个想法：也许我可以利用互联网大规模地做这件事，不是针对一个人，而是针对成千上万甚至数百万人。向他们介绍他们会喜欢但可能会错过的音乐。
(00:41:53):
我承诺过要讲讲职业生涯中的运气故事，真的有无数个。其中一个非常戏剧性的是：当时我正打算离开那家企业软件公司。我是工程副总裁，管理着整个团队，我觉得有责任以负责任的方式离开。但我对我准备创办的数字音乐公司感到非常兴奋，但我没告诉任何人，因为我不想传到团队耳朵里。
(00:42:25):
2004 年春天，我飞到洛杉矶去参加 Coachella 音乐节，在马球场上完全随机地撞见了一个高中同学，我已经十年没见过他了。我们高中的共同点就是热爱音乐。于是我告诉他我要创办一家做个性化数字音乐的公司。他说：“我有一个同事刚离职搬去奥克兰，加入了一家叫 Savage Beast 的小公司，他们也在做音乐推荐。你想和他们聊聊吗？”我说：“好啊，为什么不呢？”
(00:43:11):
于是我被引荐给了 Savage Beast 的创始人 Tim Westergren。当时公司只有七八个全职员工。他们做了一个音乐推荐引擎，授权给其他公司放在消费产品里。他们的客户包括 Best Buy（放在自助终端里）和 AOL（用在 AOL 音乐网站上）。他们正在寻找工程副总裁。我拿到了 Offer，考虑了一下后拒绝了，因为那是 B2B2C 模式，而我真正想做的是直接面向消费者的应用。
(00:43:49):
一个月后，他们又打电话来说：“我们一直在面试，但真的觉得你就是那个人。”有趣的是，他们觉得我是合适人选的原因之一是，他们对我曾在 Pets.com 负责工程感到印象深刻。所以你看，即使是灾难性的经历，有时也会带来回报。
(00:44:07):
老实说，我当时可能有点判断失误，我答应了，尽管那不是我想做的产品。我不想细说所有细节，但 90 天后，经历了一些典型的早期创始人纠纷，创始技术和产品负责人辞职了（与我的到来无关）。公司迎来了一位新 CEO Joe Kennedy。Joe 提出了一个叫“一键个性化电台”（1-Click Personal Radio）的想法。Joe 是个产品营销天才，也是世界上最好的 CEO。我们一起花了 10 年时间打造 Pandora。
(00:44:51):
他基本上把钥匙交给了我，说：“只要符合‘一键个性化电台’的大纲，一切由你决定。”在接下来的 10 年里，我与他和创始人 Tim 合作，建立了团队和文化，经历了一切美好的事物。
(00:45:14):
Pandora 给了我无数教训。我作为产品领导者和工程领导者的一切能力，都源于在 Pandora 发生的点点滴滴。
(00:45:24):
但也许我首先想到的是，我们以一种极其真诚的方式对待早期受众。例如，我们上线时，support@pandora.com 是 all@pandora.com 的别名。这意味着如果你给客服发邮件，公司里的每一个人都会收到。因为我们决定第一年不设客服团队，所以默认谁先看到谁就回复。
(00:46:01):
所以你写信过来，可能会收到创始人、我、写那个功能的工程师或者 CEO 的回复。没有回复常见问题的宏命令，没有“请阅读常见问题解答”，也没有关于什么能说、什么不能说的规定。如果有人说：“我觉得这个功能很蠢，坏掉了”，我们会鼓励员工回复：“我觉得你说得对，我正努力说服我们那个愚蠢的产品负责人呢。我会抄送给 Tom，也许我们能说服他这个决定是错的。”
(00:46:35):
我们这样做是因为我们认为，作为一家年轻公司，我们的超能力之一就是能像真实的人一样与受众互动，而不是做一个高高在上、试图伪装成某种大品牌的形象。那个时期 iPod 和 iTunes 正处于巅峰，我们在品牌形象上不可能赢过苹果。
(00:47:02):
所以我们选择做自己。我认为这确实是 Pandora 口碑传播的催化剂。我在那里的整个时间里，我们从未在付费获客上花过一分钱，真的是零投入。因为人们热爱这个产品，他们告诉了朋友，公司就是这样成长起来的。

---

### [00:47:21] Lenny

**English:**
I saw a stat that you grew Pandora from 0 to 80 million users, from 10 employees to 3000 employees, from 0 basically to a multi-billion dollar company.

**中文翻译:**
我看到一个数据：你见证了 Pandora 从 0 增长到 8000 万用户，从 10 名员工增长到 3000 名员工，从零开始变成了一家价值数十亿美元的公司。

---

### [00:47:34] Tom Conrad

**English:**
We did those things. We did.
(00:47:34):
Also, I think my product stewardship in some ways set the scene for Spotify to walk through the digital streaming door and show us the exit. So Pandora is, again, such a privilege to be able to work on something that touched and continues to touch tens of millions of people's lives every month. But it's bittersweet from the standpoint that I think we had an opportunity that in some ways we misplayed.

**中文翻译:**
我们确实做到了。
(00:47:34):
同时，我也认为我在产品上的管理在某种程度上为 Spotify 铺平了道路，让他们推开数字流媒体的大门，并把我们送出了场。Pandora 让我感到荣幸，因为它曾触动并继续每月触动数千万人的生活。但从某种角度看，这也是苦乐参半的，因为我觉得我们曾有机会，但在某些方面我们失误了。

---

### [00:48:06] Lenny

**English:**
My mom is still a huge fan of Pandora, uses it every day for whatever choice.

**中文翻译:**
我妈妈现在依然是 Pandora 的忠实粉丝，每天都在用。

---

### [00:48:10] Tom Conrad

**English:**
I mean, it's still going. And the numbers are still tens of millions of people in the US listen every month. So it's a thing. But yeah, it's a little sad that it didn't have quite the staying power that some of these other things that have come along since have.

**中文翻译:**
它还在运行。在美国，每月仍有数千万人在听。所以它依然存在。但确实有点遗憾，它没有像后来出现的其他一些产品那样拥有持久的生命力。

---

### [00:48:25] Lenny

**English:**
Just on that topic, do you think there something that you could have done, someone could have done? Do you think there was an opportunity to become Spotify? Or is it the business model and the math formula was set up in such a way that it was near impossible?

**中文翻译:**
就这个话题，你觉得有什么是你本可以做的，或者别人本可以做的吗？你觉得当时有机会成为 Spotify 吗？还是说商业模式和数学公式注定了这几乎是不可能的？

---

### [00:48:37] Tom Conrad

**English:**
One of the things that was tough for Pandora was that when we started it, digital music was a category that no investor wanted to touch. It was lawsuits. There was no money to be made. There were relationships with the labels that were completely impossible to nurture. And there had been no big outcomes. I think the biggest exit in digital music when we got going was I think Yahoo had bought Musicmatch for like $400 million. And so that was seen as kind of the ceiling on the opportunity.
(00:49:08):
And along the way we found investors who believed in our vision and invested ultimately hundreds of millions of dollars in the company over its pre-public years. But there was never investor enthusiasm for the company in the category that was anything like the investor enthusiasm that a company like Spotify enjoyed just six, seven years later, Snap enjoyed for its pre-public tenure.
(00:49:35):
And I think part of what was different for Spotify is that the comps were not... Musicmatch was 400 million, they were Pandora at 8 billion, but even above that they were Netflix at 100 billion. And so investors just had this new sort of optimism about what you could do in subscription and in streaming, and Spotify really played that to their advantage in a way that we couldn't because we had gone public and the public market investors were still trying to figure us out. So we didn't have access to capital. It was very hard for us to take the same kind of risks that Spotify took.
(00:50:17):
But then I think we just completely misjudged one really important thing, which is that we were really inspired by disrupting terrestrial radio. Terrestrial radio is the predominant form of music consumption in the country. People spend, I can't remember the exact stats, but by minutes consumed, it's something like 10 times more music minutes a month on radio in the aughts and early tens than on owned music. And the advertising supported sort of radio market was a $30 billion category, and recorded music was $8 billion.
(00:50:57):
And so we had this idea that we're going to reinvent radio, and Spotify and Rdio and Apple Music and the 14 others, Rhapsody, which was Spotify before Spotify, they were all going to chase this smaller owned recorded music opportunity, and that we could be left relatively alone over here going after the less sexy but actually bigger market. And I think we just got it wrong. It should have been obvious that inevitably all of your music in any format was going to be delivered as a stream from the cloud. And that the record labels in particular, they were going to set the terms on what the structure was. And the structure that they preferred was the Spotify structure. And we operated under a different licensing...

**中文翻译:**
Pandora 当时面临的一个困境是：当我们开始做的时候，数字音乐是一个没有任何投资者愿意碰的领域。到处是诉讼，赚不到钱，与唱片公司的关系根本无法维系。而且当时还没有成功的先例。我们起步时，数字音乐领域最大的退出案例大概是雅虎以 4 亿美元收购了 Musicmatch。所以那被视为这个领域的上限。
(00:49:08):
一路上我们找到了相信我们愿景的投资者，在上市前几年最终投入了数亿美元。但投资者对这家公司和这个领域的狂热，远不及六七年后 Spotify 所享有的，也不及 Snap 在上市前所享有的。
(00:49:35):
我认为 Spotify 的不同之处在于，参照物变了。以前是 4 亿的 Musicmatch，后来是 80 亿的 Pandora，甚至还有 1000 亿的 Netflix。所以投资者对订阅和流媒体能做成什么样有了一种全新的乐观态度。Spotify 充分利用了这一点，而我们做不到，因为我们已经上市了，公开市场的投资者还在试图看透我们。所以我们无法获得那样的资本，很难像 Spotify 那样去冒险。
(00:50:17):
但我觉得我们还完全误判了一件非常重要的事：我们当时一心想颠覆传统广播（Terrestrial radio）。传统广播是当时美国最主要的音乐消费形式。我不记得确切数据了，但按消费时长算，21 世纪头十年人们在广播上听音乐的时间大约是听自有音乐的 10 倍。广告支持的广播市场是一个 300 亿美元的类别，而录制音乐市场只有 80 亿美元。
(00:50:57):
所以我们当时的想法是：我们要重新发明广播。而 Spotify、Rdio、Apple Music 以及其他十几家公司（比如 Spotify 之前的 Rhapsody）都会去争夺那个较小的录制音乐市场。我们可以独占这个虽然不那么光鲜、但实际上更大的市场。我觉得我们想错了。当时本该显而易见的是：不可避免地，所有格式的音乐最终都会以云端流媒体的形式交付。而且唱片公司会决定游戏规则，他们更倾向于 Spotify 的模式。而我们是在另一种授权模式下运作的……

---

### [00:52:01] Tom Conrad

**English:**
And we operated under a different licensing regime that they hated, that was a statutory license that we got from the government. And it would've been exceptionally risky for us to come out from under the statutory license and do direct deals with the labels, but it was a requirement to play in the world that they imagined as the future, and we should have imagined as the future, too. And eventually, the company got around to it, but it was too late.

**中文翻译:**
我们当时是在一种唱片公司非常讨厌的授权制度下运作的，那是我们从政府获得的“法定许可”（Statutory license）。对我们来说，脱离法定许可去和唱片公司直接谈协议是非常冒险的，但那是进入他们所设想的未来世界的门票，而我们也本该预见到那个未来。最终公司确实转过弯来了，但为时已晚。

---

### [00:52:29] Lenny

**English:**
It's interesting that so much of this was rooted in that original vision that you shared of Pandora of the radio, smart radio in your pocket, [inaudible 00:52:37] personal radio that you just stayed on that track, even though there was this other track. But I think it's important to point out, you said it was seven years later. And I feel like there's this interesting trend with the companies you've worked at, pets.com and Pandora, that it's too early, you just come too early at these ideas. And I feel like that tells me Quibi might still happen. There's a Quibi coming seven years from now.

**中文翻译:**
很有趣，这么多问题都根植于你分享的 Pandora 最初愿景——口袋里的智能电台、个人电台。尽管有另一条路，你们还是坚持走这一条。但我觉得有一点很重要：你提到 Spotify 是七年后出现的。我发现你工作过的公司（Pets.com 和 Pandora）都有一个有趣的趋势：太超前了。你总是太早提出这些想法。这让我觉得 Quibi 可能还会发生，也许七年后会出现另一个 Quibi。

---

### [00:52:59] Tom Conrad

**English:**
You know what's really funny about that? Just today, there's a headline about a Hollywood-produced show that's launching on Instagram Reels and TikTok that was shot vertical. And the headline is literally something like, "Is TikTok the new TV?" And it's pretty funny that literally, that's what Jeffrey and Meg called it when they were incubating the idea. I mean, I think it's pretty clear that purpose-built video for mobile looks a lot like TikTok. And I don't want to take anything away from all of the innovation in that space that they and the other players are driving that Quibi didn't capture in its initial product definition. But I mean, obviously, we stare at our phones consuming video of all kinds all day every day. So there there's definitely something there.

**中文翻译:**
你知道最逗的是什么吗？就在今天，有一个头条新闻说一部好莱坞制作的剧集要在 Instagram Reels 和 TikTok 上发布，而且是竖屏拍摄的。标题大概是：“TikTok 是新型电视吗？”有趣的是，这正是 Jeffrey 和 Meg 在孵化这个想法时给它起的名字。我的意思是，很明显，专为移动端打造的视频看起来非常像 TikTok。我不想抹杀 TikTok 和其他玩家在那个领域所做的创新，那是 Quibi 在最初的产品定义中没能捕捉到的。但显然，我们每天都在盯着手机消费各种视频。所以那个方向绝对是有戏的。

---

### [00:53:53] Lenny

**English:**
The PDF that I mentioned that I got from the recruiter, the first page again says, "You have a TV in your pocket." So it's exactly what they're pitching. That's amazing. All right. I'm going to read through this and see what they pitched back in the day.
(00:54:07):
This episode is brought to you by HelpBar by Chameleon, the free in-app universal search solution built for SaaS. Your help content lives outside your app and is scattered in many places, forcing users to waste time hunting for answers. HelpBar solves this. It delivers answers directly inside your app and eliminates context switching. Users can search or ask questions to get AI- generated answers and lists of the most relevant documentation from all of your help sources, including your knowledge base, docs, blog, and video libraries. You can also use HelpBar to navigate your app and launch actions, such as scheduling a meeting or viewing an interactive demo.
(00:54:45):
The best products today use command-K for in-app search and navigation. HelpBar makes that readily available within your app without engineering or new code. Give users a faster and more delightful self-serve experience that reduces friction and increases in-app engagement. Upgrade your user experience with this modern component and supercharge your product-led motion. Sign up for HelpBar today. It's free and easy to set up in minutes. Check it out at helpbar.ai/lenny. That's helpbar.ai/lenny.

**中文翻译:**
我提到的那份猎头发来的 PDF，第一页写的又是：“你口袋里有一台电视。”这正是他们当时推销的内容。太神奇了。好，我会读完它，看看他们当年是怎么说的。
(00:54:07):
本期节目由 HelpBar by Chameleon 赞助。这是为 SaaS 打造的免费应用内通用搜索解决方案。你的帮助内容通常散落在应用之外的各处，迫使用户浪费时间寻找答案。HelpBar 解决了这个问题。它直接在应用内提供答案，消除了上下文切换。用户可以搜索或提问，从你的知识库、文档、博客和视频库等所有来源中获取 AI 生成的答案和最相关的文档列表。你还可以使用 HelpBar 在应用内导航并启动操作，如预约会议或查看互动演示。
(00:54:45):
如今最优秀的产品都使用 Command-K 进行应用内搜索和导航。HelpBar 让你的应用无需工程开发或新代码即可实现这一功能。为用户提供更快、更愉悦的自助服务体验，减少摩擦并增加应用内参与度。通过这个现代组件升级你的用户体验，增强你的产品驱动增长（PLG）势头。立即注册 HelpBar，免费且几分钟即可完成设置。访问 helpbar.ai/lenny。

---

### [00:55:18] Lenny

**English:**
Let's talk about Snap briefly, and then I want to have a couple more questions.

**中文翻译:**
简短聊聊 Snap，然后我还想问几个问题。

---

### [00:55:21] Tom Conrad

**English:**
At Pandora, I was the head of product and was head of engineering. And our CEO was brilliant, but he was a product marketer. I mean, Joe was all things. He was an engineer by education, and a great marketer, and a great finance person, and just such a utility player at a very, very high level across every discipline. But he was also really, really good at letting his team do their jobs. He really let me run product and engineering. And so not only did I have tremendous latitude to make good and bad decisions about product, I also really got a seat at the table to help lead the company. So rewarding, so gratifying. Best professional experience that one could have.
(00:56:05):
So I leave Pandora after a decade. I take a year trying to figure out what I'm going to do next. But after about a year, I got introduced to Evan. And it's kind of a funny story. A mutual friend sent this introduction over. Evan immediately responded and said, "Why don't you come down to Los Angeles and have a coffee with me?" So I fly down. It's not clear if it's a job interview or what it is really. I mean, I was just lightly exploring things that were out there and was a big fan of what he was doing with Snapchat. So I spent 45 minutes with him, and then I spent 45 minutes with the head of engineering, and another 45 minutes with the head of legal, and then they tossed me into a conference room with a dozen product designers, all in their mid to late 20s, many of which had gone to school at Stanford with Evan.
(00:57:01):
I would come to learn all really, really, really impressive super, super talented people, but it was just 10 of us sitting around a conference table. And it wasn't really clear that they knew why they were talking to me, but we had an hour long free ranging conversation. And so I left, and I thought it was a totally fascinating morning, but I wasn't sure what had happened, really. It was like "Well, with these interviews, it all seemed very ad hoc. Is there a job opening?" It was a little odd. And I went to lunch on Abbott Kinney and got a text from Evan's admin saying, "Can you come back to the office? Have you gotten on your plane yet?" I was like, "I was just ordering lunch. I'll just come back right away."
(00:57:49):
So I go back. Now, it's one o'clock in the afternoon. This entire thing started at nine o'clock in the morning. I sit down in the conference room. Evan comes in with a manila envelope and says, " We loved you. We'd like for you to be our VP of product," and handed me a written offer, all the terms, the stock compensation, the whole thing. I'm gobsmacked. I'm flattered, that this is really playing to my ego. I can't believe that this company that feels like maybe the most interesting thing that's happening in consumer tech, that their notoriously brilliant and mercurial founder has taken enough of a shine to me that he wants to give at least some of the keys to the product kingdom over after such a short courtship.
(00:58:34):
So I leave, and when some of that buzz wears off, I start to wonder if there's some red flags here maybe. So I tell Evan, "Listen, I'd like to come back and meet more of the leadership team and spend more time with you, go a little deeper on what this means." And so we extend our courtship by another week or so, and I'm super impressed by the rest of the leadership team and the product thinkers and the designers and things that I was going to get to work with on a daily basis. And so I take the job full knowing that it's going to be wildly different than Pandora, where I had all of this latitude to do whatever I might want to do, and in the context of Snapchat, at best, I was going to be Evan's right hand, a person that principally executed his vision.
(00:59:29):
And that's certainly what it was. I mean, Evan and I ended up having a really great collaboration, but it was certainly most days, I was executing on his vision, both at a high level, and very much in the details. And Evan's truly brilliant, I mean, and he's also actually a really nice guy. I think in some ways, he gets a bad rep for... He has very high standards, but he's a very kind person, in my experiences with him. But it was a super exhausting job and not as soul satisfying as I wanted it to be. And after a couple of years, like I said, I thought maybe I just wanted to make croissants or something.
(01:00:14):
But one really, really big important lesson that I learned at Snap is about risk taking. And when you have the financial support and the foundational relationship with your investors that Evan has, it really allowed him to take these really big swings, acquire a technology that he thought was game changing, build features speculatively that maybe would be pruned in any other product roadmap planning process because the odds of them having an outsized impact were modest. And it just allowed him time after time to make bets that paid off, and we forget about the ones that don't work when there are so many home runs in those years. And we didn't have... Environmentally, we weren't set up for that at Pandora, but I think in some ways, I wasn't temperamentally inclined to those kinds of big swings. And I think I take bigger risks and encourage bigger swings now because of things I learned from Evan and Snap.

**中文翻译:**
在 Pandora 时，我是产品负责人也是工程负责人。我们的 CEO 非常出色，但他是个产品营销人员。Joe 是个全才，他学工程出身，又是伟大的营销人员和财务专家，在各个领域都是高水平的“全能选手”。但他也非常擅长放手让团队去做。他真的让我全权负责产品和工程。所以我不仅在产品决策上有巨大的自主权，还能参与公司领导层决策。那段经历非常有成就感，是职业生涯中最好的体验。
(00:56:05):
在 Pandora 待了十年后我离开了。我花了一年时间思考下一步做什么。大约一年后，我被引荐给了 Evan（Spiegel）。故事挺有趣的，一个共同的朋友发了引荐信，Evan 立即回复说：“你为什么不来洛杉矶和我喝杯咖啡？”于是我飞了过去。当时不清楚这算不算面试。我只是在随便看看机会，而且我很喜欢他在 Snapchat 做的事。我先和他聊了 45 分钟，然后和工程负责人聊了 45 分钟，再和法务负责人聊了 45 分钟，最后他们把我扔进一个会议室，里面坐着十几个二十多岁的产品设计师，很多是 Evan 在斯坦福的同学。
(00:57:01):
后来我发现他们都是非常厉害、极具才华的人。当时我们 10 个人围坐在会议桌旁，他们似乎也不太清楚为什么要和我聊，但我们进行了一小时漫无边际的交谈。离开时我觉得那个上午非常有趣，但我不确定发生了什么。感觉面试非常随意，甚至不知道有没有职位空缺。我去 Abbott Kinney 吃午饭，收到了 Evan 秘书的短信：“你能回办公室一趟吗？你上飞机了吗？”我说：“我刚点好菜，马上回去。”
(00:57:49):
我回去了。当时是下午一点，整个过程从早上九点开始。我坐进会议室，Evan 拿着一个牛皮纸信封进来，说：“我们很喜欢你。我们希望你担任产品副总裁。”然后递给我一份书面 Offer，包含所有条款、股票补偿等。我惊呆了，也感到受宠若惊，这极大地满足了我的虚荣心。我不敢相信这家当时消费科技领域最有趣的公司，其著名的天才且“喜怒无常”（Mercurial）的创始人，在这么短的接触后就想把产品王国的钥匙交给我一部分。
(00:58:34):
离开后，当那种兴奋感消退，我开始怀疑这里是否有“红旗”（潜在问题）。于是我告诉 Evan：“我想再回来见见更多的领导团队，和你多待些时间，深入了解这意味着什么。”于是我们将接触期延长了一周左右。我对领导团队的其他成员、产品思想家和设计师印象深刻。于是我接受了这份工作，尽管我清楚这会和 Pandora 完全不同。在 Pandora 我有绝对的自主权，而在 Snapchat，我充其量是 Evan 的副手，主要负责执行他的愿景。
(00:59:29):
事实也确实如此。我和 Evan 最终合作得很好，但大多数时候我是在执行他的愿景，无论是宏观层面还是细节层面。Evan 真的很聪明，而且他其实是个很好的人。我觉得他在某些方面名声不好是因为他标准极高，但在我的经历中，他是个很善良的人。但那份工作极其耗人，并没有像我希望的那样让灵魂感到满足。两年后，就像我说的，我觉得自己可能想去烤牛角面包之类的。
(01:00:14):
但在 Snap 我学到了一个非常重要的教训：关于冒险。当你有 Evan 那样的财务支持和与投资者的基础关系时，他可以进行巨大的豪赌——收购他认为能改变游戏规则的技术，投机性地开发一些在其他公司可能会被砍掉的功能（因为产生巨大影响的概率很小）。这让他一次又一次地赌赢了，而当那几年有那么多“全垒打”时，人们会忘记那些没成功的尝试。在 Pandora，我们的环境不允许这样，而且我当时在性格上也不倾向于这种豪赌。现在，因为从 Evan 和 Snap 学到的东西，我愿意承担更大的风险，鼓励更大的尝试。

---

### [01:01:18] Lenny

**English:**
That is an awesome story. It resonates a lot with what Brian shared about how he thinks about product now and just telling people what to build versus very bottom up, "Tell us ideas you have." That impact, the way you run, we're going to talk a bit about you as CEO now, but I guess, do you have a place that you try to be of CEO as, "Here's what we're building"?

**中文翻译:**
这是一个很棒的故事。这与 Brian（Airbnb CEO）分享的关于他现在如何思考产品的观点非常契合——直接告诉人们要建造什么，而不是完全自下而上地问“你们有什么想法”。这种管理方式的影响，我们稍后会聊聊你作为 CEO 的情况，但我想问，你现在作为 CEO，是否也会采取“这就是我们要建造的东西”这种姿态？

---

### [01:01:40] Tom Conrad

**English:**
As a product-oriented CEO, how much you should lean in to the details versus set direction and create an environment where great people can do great work, I suspect there's not one answer that applies to every company stage. When I was at Apple, one of the reasons that we struggled to ship things is that Apple did a great job of assembling incredibly, incredibly smart and talented people. Just everyone around me at that early stage in my career was so, so inspiring. But one of the side effects of that is we would get in a room and we would turn over some problem or opportunity, and we would talk ourselves out of every good solution because it wasn't perfect. I used to joke that Apple was the only place in the world where a vote of a thousand to one was a tie because that one person would be so thoughtful in their critique that the other thousand people would be like, "Hmm, that's right, that's right." And even though there's been this huge consensus of what the right answer was, we would talk ourselves out of making decisions.

**中文翻译:**
作为一名产品导向的 CEO，你应该在多大程度上深入细节，还是仅仅设定方向并创造一个让优秀人才发挥的环境？我怀疑没有一个适用于所有公司阶段的标准答案。我在苹果时，我们难以发布产品的原因之一是，苹果汇聚了极其聪明和有才华的人。在我职业生涯早期，身边的每个人都非常令人振奋。但副作用是，当我们聚在一起讨论问题或机会时，我们会因为方案不够完美而否定每一个好的解决方案。我曾开玩笑说，苹果是世界上唯一一个“1000 比 1 的投票结果算平局”的地方，因为那一个人的批评可能非常深刻，以至于其他 1000 个人会觉得：“嗯，他说得对。”尽管已经有了巨大的共识，我们还是会因为过度讨论而无法做出决定。

---

### [01:02:50] Lenny

**English:**
That one wasn't Steve Jobs, necessarily? It could be somebody else?

**中文翻译:**
那个人不一定是史蒂夫·乔布斯吧？也可能是别人？

---

### [01:02:53] Tom Conrad

**English:**
He wasn't there.

**中文翻译:**
他当时不在公司。

---

### [01:02:55] Lenny

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:02:56] Tom Conrad

**English:**
So I think what broke Apple out of that mode was Steve came back and they didn't vote anymore. Steve was just making the call. And so I have some sympathy for Brian and Evan, who have these big, thousands of people working for them. And as they delegate, they grow frustrated that there's not progress at the pace that they're looking for, and that there's indecision, and the people on the teams report that there's just churn and no progress, and there's fiefdoms and politics and all the rest, and that as the CEO, as a brilliant product-oriented CEO, they are uniquely situated to come in and cut through all of that garbage and get the trains running on time again.
(01:03:49):
Having said all of that, I also think that it can be a mistake to be that kind of leader in a smaller org because part of the opportunity in a small org is to assemble a group of people that are incredibly talented that believe in your mission and where who you can easily influence with a much lighter touch and set them up to build a culture in an organization that can execute. And so I see my job as CEO is to try to surf that edge of I'm really in the details. So I deeply understand the business and the product decisions that we're making and the processes that we're using to run the business, but not overplay my hand with respect to dictating outcomes.
(01:04:40):
The one thing you'll always have as CEO is, no matter how much you tell the team that when I swing by their virtual desk and say, "I've been thinking about this little detail that's not important right now, but what do you think?" It's like nine out of 10 times, that person is going to go and start working on that thing. And so you do have to be just really careful about the way you engage in some of those details, I think.

**中文翻译:**
所以我认为打破苹果那种模式的原因是史蒂夫回来了，他们不再投票了，史蒂夫直接做决定。所以我对 Brian 和 Evan 有些同情，他们手下有成千上万的人。当他们授权时，他们会因为进度达不到预期而感到沮丧，因为存在犹豫不决，团队成员报告说只有内耗没有进展，还有势力范围（Fiefdoms）和政治斗争等等。作为才华横溢的产品导向型 CEO，他们处于一个独特的位置，可以介入并扫除所有垃圾，让火车重新准点运行。
(01:03:49):
话虽如此，我也认为在较小的组织中做这种领导者可能是一个错误。因为小组织的机会在于聚集一群相信你使命的天才，你可以用更轻微的影响力去引导他们，让他们建立起一个能够执行的文化和组织。所以我认为我作为 CEO 的工作是努力在两者之间平衡：我深入细节，以便深刻理解业务、产品决策和运行业务的流程，但在决定结果方面不过度干预。
(01:04:40):
作为 CEO，有一件事是无法避免的：无论你如何告诉团队，当你路过他们的虚拟桌面说“我一直在想这个现在不重要的小细节，你觉得呢？”时，十有八九那个人会立刻放下手头的工作去钻研那个细节。所以，在参与这些细节时，你必须非常小心。

---

### [01:05:06] Lenny

**English:**
There's a really good episode I had with Lane Shackleton from Coda, and he shared this framework called flash tags that they use at Coda, and I think it comes from HubSpot, of you tell people, "Here's what the subpoena is. Is it an FYI? Is it a suggestion? Is it a do this?" There's four of them and one's like, "I will die on this hill. You need to do this."

**中文翻译:**
我曾和 Coda 的 Lane Shackleton 录过一期很棒的节目，他分享了一个叫“Flash tags”的框架，源自 HubSpot。你告诉人们你的意见是什么性质：是“仅供参考”（FYI）？是“建议”？还是“必须执行”？一共有四种，其中一种是“我会为此死战到底，你必须这么做”。

---

### [01:05:27] Tom Conrad

**English:**
I try to do a lot of that. I wish I could say that in my experience that that pays off. I spend an awful lot of time, even the stuff I say very clearly, just one person's opinion, focus group of one, "Don't change your priorities to go work on this," it has more of an outsized impact on people's behavior than I intended.

**中文翻译:**
我也经常尝试这样做。但我希望我能说这很奏效。事实上，我花了很多时间强调“这只是我个人的意见”、“样本量为 1 的焦点小组”、“不要为了这个改变你的优先级”，但它对人们行为的影响依然比我预想的要大得多。

---

### [01:05:49] Lenny

**English:**
Yeah. Easier said than done. Coming back to your journey, we've talked through the story up until getting to Quibi, but two years ago, you went in a whole new direction, and you're now the CEO of a company called Zero. What is it like to move from just being a product leader or engi leader at a company to being the CEO for the first time? Why did you choose Zero as that role? And what have you learned as CEO that you wish you knew as a product leader or engi leader at a company that listeners might find useful?

**中文翻译:**
是的，说起来容易做起来难。回到你的历程，我们聊到了 Quibi 之后。两年前，你转向了一个全新的方向，现在是 Zero 公司的 CEO。从产品负责人或工程负责人转变为第一次担任 CEO 是什么感觉？为什么选择 Zero？作为 CEO，你学到了哪些是你以前作为产品或工程负责人时希望知道的、且对听众有用的东西？

---

### [01:06:19] Tom Conrad

**English:**
It's been a really, really incredible couple of years. In the aftermath of Quibi, I spent a lot of time, as we all do, soul-searching about what I learned and what I might want to do next. And as I thought about it, I realized that I really wanted to move on to something where I can have a direct impact on the culture and values of the company that I was involved in. I really got that opportunity at Pandora in a big way. And I had spent the five years of Snapchat and Quibi working for Evan and Meg and Jeffrey who are all incredible business leaders, but have their own very specific style and approach, and that leaves a mark on the culture that's unique to the founder.
(01:07:04):
And then as we've discussed, I'm always really interested in building things that are near and dear to me, and I was particularly thinking about what can I do that could have a really positive impact on the world in my next chapter. I've built an awful lot of media stuff through the years, video games and streaming services and so forth, and it seemed like maybe there was something that had a little bit more weight to it that I could spend my time on. And so my first thought was I would start something, a company idea I was quietly workshopping for some months. And completely independent from all of that, it's eight months into the pandemic, and my own personal health was at an all time low. I was 50 or 60 pounds overweight, my cholesterol was in the red zone. I mean, I was out of breath climbing stairs, which is something that I had never encountered in my life before.
(01:07:59):
I'm a bit of a yo-yo dieter and I'm always critical of looking in the mirror, but I was never ever really worried about my health, my longevity, and suddenly, I was. And so my solution to that was to go really deep on metabolic health, just thousands of hours of podcasts and videos and glucose monitoring patches and Oura Rings and digital fitness gear and just to try to understand the things that impact health and longevity. And as much as I would like to report that what I learned is that there's some magic pill that you can take, maybe some off label rapamycin or something, the truth is, is that to live a longer and healthier life, you really have to attack what I would call metabolic disease, which will manifest in overweight and obesity and pre-diabetes and diabetes and high cholesterol and all of these things that impact your long-term health.
(01:08:59):
And so I found Zero in this path and was using it to help with my own health journey. And Mike Maser founded the company four and a half years ago, and he and I were talking in this interval about my own experience with the product. I was just giving him product feedback and so forth, and he was telling me a little bit about his own entrepreneurial journey. And somewhere in the conversation, Mike said, "My intention is to step up into the executive chair role and to find a CEO for the company." So again, in my story, just over and over and over, this incredibly fortuitous thing happened. I just knew immediately that it ticked all the boxes, "Here's a chance to lead something that already had some momentum to impact the culture and values in a really direct way and was really, really close to my own personal journey."
(01:09:50):
And so we know we've got a great little company and 27 people, we've got more than a million users on the platform every month. Over a hundred thousand of them pay us with tens of millions of dollars of revenue through the years, and have had double-digit growth even coming out of the pandemic when lots of health and fitness companies saw retreats. And most importantly, it actually works. 75% of the people who use the platform lose weight. People lose, on average, five to 10% of their body weight in the first 60 days. And because of the success that people have, we grow just completely organically. We have no paid user acquisition at all. It's really a word of mouth business.
(01:10:31):
But that's not to say that it's not challenging. All startups are challenging. And what we've really focused on for the last couple of years is we've been really focused on unit economics, really trying to understand how much value can we derive and deliver for every person who downloads and installs the app, how do we convert them through all of the funnels efficiently and get them engaged with the product and get them to retain and drive that up in a really systematic way. And with my whole career, I'm definitely a person who started off thinking software development was mostly an art form, you find brilliant visionaries who have a deep understanding of human behavior, and they craft solutions for problems that other people don't see, and they make them delightful, and they get all the little details right. And when you found product market fit for the art, then you optimize them through a really quantitative take.
(01:11:34):
And so I'm definitely a person that sees both sides of that left brain and right brain equation that's important in software. But here's the thing my eyes have really opened to in the last two years. While companies are definitely the software that they make and the products that they deliver and that there is an art and science to that, as I described, there is also, if you step back, there is an equation that describes the business. It talks about how you turn investment into returns. And I suppose if I had come up with finance and been a business major that maybe that's the way that I would've conceived of companies to begin with. So maybe it's a little embarrassing that I had to be 53 years old before, I think, the scales fell through my eyes and I was like, "Oh, companies are equations."
(01:12:24):
And so when we first started talking about lifetime value and customer acquisition costs and getting those two things balanced and just the thinking about the unit economics of the business, my natural instinct was to go immediately to the leaf nodes of the equation like, "Oh, what percentage of people do we convert from install to registered and from registered to trial," and these very way down at the bottom of all the funnels and to ask the product team like, "Let's try to optimize these." And in the process though of trying to understand where we could take the business as we optimize those various dimensions and trying to understand too which of the dimensions had the most leverage, I started building these ever more sophisticated models that describe the whole business.
(01:13:16):
I mean, in startups, you get to wear a lot of hats. And definitely a hat that I'm wearing that I didn't anticipate at all is I'm the full-time FP&A guy for Zero. And so I built this spreadsheet that aggregates data from all of our business intelligence tools and raw data from our subscription transactions and looks at all of our historical results and all of our expenses and spend and then could use that to predict future scenarios by manipulating all of these variables. And it's just not at all the way I ever thought about products before. And I know that you've got lots of listeners like, "This guy's an idiot. This is a fundamental way to contemplate product work."
(01:14:05):
But if there's anybody out there like me who thought of it as art first and then optimization in the details, it is really, really powerful to spend the time to create the model that describes the whole thing so you can identify what are the high leverage points to focus on. So been doing a lot of that at the company in the last two years and it's really starting to deliver incredible results. Like everything in life, I mean, you sign up for things so you can learn, and that's the big one for me in the last year.

**中文翻译:**
这两年真的非常不可思议。Quibi 结束后，我花了很多时间进行灵魂拷问，思考我学到了什么以及下一步想做什么。我意识到，我真的很想加入一家我能直接影响其文化和价值观的公司。我在 Pandora 曾有过这样的机会。而在 Snapchat 和 Quibi 的五年里，我为 Evan、Meg 和 Jeffrey 工作，他们都是了不起的商业领袖，但都有自己非常独特的风格，这会在文化上留下创始人的烙印。
(01:07:04):
正如我们讨论过的，我总是对打造与我个人息息相关的东西感兴趣。我特别在想，在人生的下一个篇章，我能做些什么对世界产生积极影响的事？这些年来我做了很多媒体相关的东西——视频游戏、流媒体服务等等，我觉得也许我可以把时间花在更有分量的事情上。起初我想自己创业，一个想法已经在脑子里构思了好几个月。与此同时，在疫情爆发八个月后，我的个人健康状况跌到了谷底。我超重了五六十磅，胆固醇亮起红灯，爬楼梯都会喘气，这是我以前从未经历过的。
(01:07:59):
我以前经常反复节食，对镜子里的自己很挑剔，但我从未真正担心过健康和长寿。突然间，我开始担心了。我的解决方案是深入研究代谢健康，听了几千小时的播客和视频，戴上血糖监测贴片、Oura 戒指和数字健身器材，试图理解影响健康和长寿的因素。虽然我很想报告说我发现了一种神奇的药丸（比如雷帕霉素之类的），但事实是，要活得更久、更健康，你必须解决我所谓的“代谢疾病”，它表现为超重、肥胖、糖尿病前期、糖尿病和高胆固醇。
(01:08:59):
在这个过程中我发现了 Zero，并用它来辅助我的健康之旅。Mike Maser 在四年前创立了这家公司，我们聊到了我对产品的使用体验。我当时只是给他一些产品反馈，他则告诉我他的创业历程。聊着聊着，Mike 说：“我打算转任执行主席，为公司找一位 CEO。”于是，我故事中那种极其偶然的幸运又发生了。我立刻意识到它符合所有条件：“这是一个领导已经有一定势头、能直接影响文化价值观、且与我个人经历紧密相关的机会。”
(01:09:50):
我们现在有一家很棒的小公司，27 名员工，每月有超过 100 万活跃用户。超过 10 万付费用户，多年来创造了数千万美元的收入。即使在疫情后期许多健身公司业绩下滑时，我们依然保持了两位数的增长。最重要的是，它真的有效。75% 的用户成功减重，前 60 天平均减重 5% 到 10%。因为效果好，我们的增长完全是自发的，没有任何付费获客，完全靠口碑。
(01:10:31):
但这并不是说没有挑战。所有初创公司都有挑战。过去两年我们真正关注的是“单位经济效益”（Unit economics），试图理解我们能为每个下载安装应用的人创造和提供多少价值，如何高效地引导他们通过漏斗，让他们参与产品并留存。在我的职业生涯中，我起初认为软件开发主要是一门艺术：你找到有远见的、深刻理解人类行为的人，他们为别人看不见的问题打造解决方案，把细节做完美。当艺术找到了“产品市场契合度”（PMF），你再通过定量分析去优化。
(01:11:34):
我确实是一个能看到软件中“左脑”和“右脑”两面的人。但过去两年我的眼界大开。虽然公司确实是由软件和产品构成的，且其中包含艺术和科学，但如果你退后一步看，还有一个描述业务的等式。它讲述了你如何将投资转化为回报。我想如果我是学财务或商科出身，我可能一开始就会这样看待公司。所以，直到 53 岁我才真正看透这一点，意识到“公司就是等式”，这可能有点令人尴尬。
(01:12:24):
当我们开始讨论终身价值（LTV）和获客成本（CAC）的平衡，以及单位经济效益时，我的本能是立即去看等式的“叶子节点”，比如：“从安装到注册的转化率是多少？”、“从注册到试用的转化率是多少？”。我要求产品团队去优化这些漏斗底部的指标。但在试图理解业务走向以及哪些维度杠杆最大的过程中，我开始构建描述整个业务的、日益复杂的模型。
(01:13:16):
在初创公司，你要身兼数职。我完全没预料到的一点是，我现在是 Zero 的全职财务规划与分析（FP&A）人员。我建立了一个电子表格，汇总了所有商业智能工具的数据和订阅交易的原始数据，查看历史结果、所有支出，然后通过操纵这些变量来预测未来的场景。这完全不是我以前思考产品的方式。我知道很多听众会想：“这家伙是个白痴，这是思考产品工作的基本方式。”
(01:14:05):
但如果有人像我一样，先把它看作艺术，然后再看细节优化，那么花时间创建一个描述全局的模型是非常强大的，这样你就能识别出哪些是值得关注的高杠杆点。过去两年我在公司做了很多这样的工作，它开始带来惊人的结果。就像生活中的一切一样，你加入是为了学习，这是我去年最大的收获。

---

### [01:14:36] Lenny

**English:**
I really love that takeaway of as a CEO coming back to share, here's what you should be thinking about that the CEO is probably thinking about, as a product leader, you may not be, of trying to actually spend the time to think about the business model and understand it deeply because your founders are thinking about it all the time. And so if you're not, you're missing out on here's a way to influence them, here's a way to...

**中文翻译:**
我非常喜欢这个总结：作为 CEO 回来分享，你应该思考那些 CEO 正在思考、而你作为产品负责人可能没想到的东西。去花时间思考商业模式并深刻理解它，因为你的创始人一直在想这些。如果你不想，你就错过了影响他们的机会。

---

### [01:14:57] Tom Conrad

**English:**
It's so funny too because it's a thing I suddenly understand something that mystified me through my entire career, which was I'd go to board meetings and the investors would ask these probing questions, but they were really never about the product and what the product did and what the product roadmap was and what the features were and what this... It all seemed to operate at this level that was almost completely independent of the details of the "what is the solution you put into the world", which as a product-oriented thinker, was just completely baffling to me. And I now realize that they were tilling the soil that I'm talking about, they were tilling.
(01:15:39):
It doesn't really matter what the screens are and what the features are. I mean, it certainly matters, but that there's another higher order way to look at a company, which is really about the optimization of this equation. And I think particularly, if you sit on 25 boards, it's probably a much more efficient way to evaluate how your companies are doing and where to spend your time and how to help by thinking about them abstracted up at that layer. So I will never stop thinking about software development as being an art form and I will never stop enjoying the days when I get to lean in on the details, but it's been pretty eyeopening.

**中文翻译:**
这很有趣，因为我突然理解了一件困惑了我整个职业生涯的事。以前我去参加董事会，投资者会问一些深入的问题，但几乎从不关乎产品本身、产品功能、路线图或具体特性。它似乎运行在一个完全独立于“你向世界提供了什么解决方案”的细节之外的层面。作为一个产品导向的思考者，我以前觉得这不可理喻。现在我意识到，他们正是在耕耘我刚才提到的那片土壤。
(01:15:39):
屏幕长什么样、有什么功能，虽然重要，但还有一种更高阶的视角来看待公司，那就是优化这个等式。我想，如果你同时担任 25 个董事会成员，从那个抽象层面去思考可能是评估公司表现、决定时间分配和提供帮助的最有效方式。我永远不会停止将软件开发视为一种艺术，也永远会享受深入细节的日子，但这确实让我大开眼界。

---

### [01:16:18] Lenny

**English:**
The other thing that stands out here, one is I think this is especially true for consumer subscription apps, which I've done some research on. And basically, they never work. There's Duolingo, there's Zero, which I didn't know how much scale you guys reached. My math here real quick. So you have a million users, a hundred thousand paying users. You charge at 10 bucks a month. I know there's a discount for an annual plan, but basically, you're making somewhere around a million dollars a month, which you don't have to confirm or deny it, but that's the math I just did, and that's crazy. So congrats. That's a rare successful consumer subscription app. It never happens.

**中文翻译:**
另一件引人注目的事是，我认为这对于消费级订阅应用尤其真实。我做过一些研究，基本上这类应用很难成功。除了 Duolingo，就是 Zero 了。我之前不知道你们达到了这种规模。我快速算了一下：100 万用户，10 万付费用户，每月收 10 美元（我知道年费有折扣），但基本上你们每月的收入在 100 万美元左右。你不需要确认或否认，这是我刚算的，这太疯狂了。恭喜你，这是一个罕见的成功的消费级订阅应用，这种成功并不常见。

---

### [01:16:53] Tom Conrad

**English:**
And like I said, every startup is hard, and I never stop being surprised at the new hard things that pop up every day. But we're on a really great run. We've had a tremendous year, and I'm just so, so proud of the team we've assembled. They're incredible for the last.

**中文翻译:**
正如我所说，每个初创公司都很艰难，我每天都会被新出现的难题震惊。但我们现在跑得很顺，今年表现非常出色，我为我们组建的团队感到非常自豪。

---

### [01:17:08] Lenny

**English:**
Part of the reason you're so successful is exactly what you said. There's a huge focus on LTV/CAC, the math formula, because for these sorts of businesses, the crux of it is can you acquire people for less money than you need to spend?

**中文翻译:**
你之所以如此成功，部分原因正是你所说的：对 LTV/CAC（终身价值/获客成本）和数学公式的高度关注。因为对于这类业务，核心在于你获取用户的成本是否低于你能从他们身上赚到的钱。

---

### [01:17:21] Tom Conrad

**English:**
One thing that's really fortunate for Zero is Mike Maser, who founded the company, and I have both been around the block long enough and enough times that we remember 2008, we remember 2000. And so in these moments in the pandemic, there were companies in our category that were raising hundreds of billions of dollars with the intention of throwing it at paid user acquisition. And we made a conscious decision to optimize the value of the organic traffic that we were getting and to drive our growth through LTV expansion rather than top of funnel expansion, which was candidly not in fashion in 2021, 2022.

**中文翻译:**
Zero 非常幸运的一点是，创始 Mike Maser 和我都经历过足够多的风浪，我们记得 2008 年，也记得 2000 年。所以在疫情期间，我们这个领域有些公司筹集了数亿美元，打算全砸在付费获客上。而我们做了一个清醒的决定：优化我们获得的自然流量的价值，通过提升 LTV（终身价值）而不是扩大漏斗顶部来驱动增长。坦白说，这在 2021、2022 年并不流行。

---

### [01:18:00] Tom Conrad

**English:**
... in 2021, 2022. It turns out it's much more in fashion these days as companies are called upon to be much more capital efficient than they were during the pandemic era. I guess I feel somewhat fortunate that my natural inclination as an entrepreneur is more in sync with the expectations of the market than it was for a while.

**中文翻译:**
……在 2021、2022 年。事实证明，现在这种做法更流行了，因为公司被要求比疫情期间具备更高的资本效率。我觉得有些庆幸，作为一名创业者，我的本能倾向现在与市场的预期更加同步了。

---

### [01:18:27] Lenny

**English:**
Okay. So you've probably had the longest career arc of anyone I've had on this podcast. You've worked at all of these different companies in a lot of different phases. You're still at it. And I'm curious what you've learned about how to maintain your mental health and avoid burnout essentially through this journey. You mentioned you take some time off. Is there anything else you found or is that a trick of just how to not burnout?

**中文翻译:**
好。你可能是我这个播客中职业生涯跨度最长的人了。你在这么多不同的阶段、这么多不同的公司工作过，现在依然在奋斗。我很想知道，在这一路走来，你学到了什么关于维持心理健康和避免职业倦怠的方法？你提到过会休息一段时间，还有别的秘诀吗？

---

### [01:18:51] Tom Conrad

**English:**
Do you know this Japanese concept called Ikigai?

**中文翻译:**
你知道日本那个叫“Ikigai”（生之意义）的概念吗？

---

### [01:18:55] Lenny

**English:**
Mm-hmm. Yeah, but share it. Share it for folks that may not be familiar.

**中文翻译:**
嗯，知道，但请分享一下，给那些不熟悉的听众听听。

---

### [01:18:59] Tom Conrad

**English:**
So the idea is it's a Venn diagram and there are four spheres. There's a sphere that's labeled what you love. There's a sphere labeled what you're good at. There's a sphere labeled what the world needs, and there's a sphere called what you can be paid for, and where they all intersect is this Japanese idea, Ikigai. It's the intersection of what you're good at, what you love, what the world needs, and what you can be paid for. If you find that, it's Ikigai. And interestingly, your listeners should go and find this because there are interesting ways to label the other intersections, the intersections where all four don't come together. And what's really interesting is that the ones that are three but not four, I think because they're the ones that are close but not quite to this really satisfying thing. And so it's like when you find those, it's really easy to choose a job or to choose a path where you have three but not four, which is a really great recipe if you're feeling like there's something just out of your reach that's really important.
(01:20:09):
Anyway, it's a great framework to think about your life and your career. So to start, I'm incredibly lucky that it's all Ikigai for me. What I'm good at, what I love, what the world needs, what I get paid for, they have always overlapped. And a big part of it is just what I love is this world. I love software, I love building software, I love writing software, I love using software. People are like, "What are your hobbies?" I don't think I have any hobbies and I think about, "Well, what kinds of things do I do on the weekend for fun?" And it's like I'm teaching myself After Effects or something, which I will immediately forget, but it's just fun to go really deep on some piece of interesting software.
(01:21:02):
So I'm very lucky. And so I think that has been super sustaining for me. One of the reasons I've been able to do it as long as I have without really burning out is that just, it's what I do. And in some ways it's why I come back to it. It's easy to say, "I'm going to become a pastry chef," but left to my own devices, I use software, I make software. It's my hobby, it's my passion, it's all the things.
(01:21:29):
But a couple of thoughts about how one engages with their work. One thing is I'm really not a #hustling kind of leader. There was a woman that I worked with on the Finder just out of college that left a really big mark on me. My own style of work then, I think I mentioned my memory of flashing, blinking the folder animation was a 2: 00 AM kind of thing. I was 23 years old. I woke up at 11 o'clock in the morning. I went to the office, I screwed around and played video games in the Apple Arcade and went to a couple of meetings and had lunch and stood at the whiteboard and pontificated about some nonsense. And then about four o'clock every day I would start writing software and I would write software until 2:00 or 3:00 in the morning and then I would go out to dinner with people from the team in the middle of it and whatever.
(01:22:29):
And so it kind of looked like I spent 14 hours a day, six or seven days a week at Apple, and I was celebrated for this. There was lots of nights where I would work clear through the night and my boss would come in the next morning, he'd be like, "Are you still here?" And I'm like, "I'm still here. Look at this cool thing I did." And I got a lot of attention for that. And then there's this woman on the team who showed up every single morning at 8:30, sat at her desk, wrote a ton of great software, and every night packed her stuff up and left. And she contributed more than I ever did. And I don't think she got the same kind of recognition that I got because of the way she did the work.
(01:23:11):
And when we were building the team and culture at Pandora, I thought about her a lot and really made a point of saying that I just wasn't interested in performative contribution, that it's the work that matters and what I want to celebrate is if you can show up and do it and go home and have other things in your life, because I think that's a recipe for being able to do it on a sustained basis rather than burning yourself out.
(01:23:38):
I think there's some nuance in this. I think 22 year old me was always going to want to work through the night. And so I think creating space that that's okay too is important. And I think maybe in some ways at Pandora it was almost like that wasn't okay. It was like, "You should be taking more breaks. Why are you going this hard?" But I do try to create environments where people have a reasonable balance between their regular life and their technology life or room for that if they choose it. And I do think that that has through the years, has helped me keep at it, but I still work a lot of nights and weekends because I love it. It's what I do.
(01:24:16):
Here's the other thing. I got very, very lucky with the Pandora experience and got this outsized, probably inappropriate financial reward for being a part of it and gave me options that I never imagined that I would have. And so after 10 years I left and I didn't know what I would do, but I did really need a break. It was a really hard job and that was definitely a moment where I needed some time to recover. But I think if you had asked me on that first day, I would say, "I don't know why these people find success and then start another company right away. Why? There's so many things you could do in the world, why would you start another company? It's so hard."
(01:25:02):
And I was particularly in love with the idea that I had access to experience. I didn't really care about things, I didn't want a fancy watch or whatever, a car, but I wanted to see the world. And so I thought, "I'm going to just go and I'm going to live in London for three months, then I come back to San Francisco for a month. I'm going to go live in Mexico City for three months and I'm going to just have this life where I'm soaking up experiences." And after doing that for six months, the thing that I came to realize is that what I care about way more than experiences is relationships. If you're the person who is constantly on a plane seeking out some new experience, it's really hard to form and maintain intimate, satisfying relationships.
(01:25:47):
So I went back to San Francisco, I'm like, "I can't be all over the world if I want to be engaged with friends and like-minded people." And you know what people do on Monday morning? They go to work. And so if you want to be engaged with humanity, where they are on Monday morning is at work. And so more than I had the itch to build things, which I do very much have, I had the itch to collaborate, to be in the game with other people. So that was what took me to Snapchat, took me out of chasing experiences and took me back to building again. And then as we've already described, at a point I thought, "Well, I care about this collaboration, but maybe it doesn't need to be software that I'm creating in the world." And Quibi gave me a chance to fall back in love with that process again. And here we are, more software.

**中文翻译:**
这是一个文氏图，有四个圆圈。一个圆圈是你热爱的，一个圆圈是你擅长的，一个圆圈是世界需要的，还有一个圆圈是能让你获得报酬的。这四个圆圈交汇的地方就是日本人的概念——Ikigai。如果你找到了它，那就是 Ikigai。有趣的是，听众可以去查查，其他交汇点（只有三个圆圈重合的地方）也有有趣的标签。那些只有三项而缺一项的情况，往往让你觉得接近但并不完全满足。如果你觉得生活中有些重要的东西总是触不可及，那往往是因为你处于三缺一的状态。
(01:20:09):
总之，这是一个思考人生和职业的极好框架。首先，我非常幸运，对我来说这一切都是 Ikigai。我擅长的、热爱的、世界需要的、能赚钱的，它们一直重合。很大一部分原因是我热爱的就是这个世界：我热爱软件，热爱构建软件，热爱写代码，热爱使用软件。人们问我：“你有什么爱好？”我觉得我没有爱好。我想：“周末我为了好玩会做什么？”结果是我在自学 After Effects 之类的软件，虽然很快会忘掉，但深入钻研有趣的软件本身就是乐趣。
(01:21:02):
所以我很幸运。我认为这对我来说是超级持久的动力。我能坚持这么久而不倦怠的原因之一是：这就是我的生活。在某种程度上，这也是我回归的原因。说“我要去当点心厨师”很容易，但一旦闲下来，我还是会用软件、做软件。这是我的爱好，我的激情，我的一切。
(01:21:29):
关于如何对待工作，我有几点想法。首先，我不是那种推崇“拼命文化”（#hustling）的领导者。刚毕业在 Finder 团队工作时，一位女同事给我留下了深刻印象。我当时的工作风格是——我提到过凌晨两点写动画代码——我 23 岁，上午 11 点起床，去办公室，在苹果游戏厅玩游戏，开几个会，吃午饭，在白板前高谈阔论。下午四点才开始写代码，一直写到凌晨两三点，中间还会和团队出去吃晚饭。
(01:22:29):
所以看起来我每天在苹果工作 14 小时，每周六七天，我也因此受到赞赏。有很多次我通宵达旦，老板第二天早上进来问：“你还在呢？”我说：“是啊，看我做的这个酷东西。”我因此得到了很多关注。但团队里有一位女性，她每天早上 8:30 准时出现，坐在桌前写出大量优秀的软件，每天晚上准时收拾东西回家。她做出的贡献比我多得多。但我觉得她没有得到和我一样的认可，仅仅因为她的工作方式。
(01:23:11):
在 Pandora 建立团队和文化时，我经常想到她。我明确表示我不对“表演性贡献”感兴趣。重要的是工作成果。我想赞赏的是：你能按时完成工作，然后回家过自己的生活。我认为这是能够长期坚持而不至于崩溃的秘诀。
(01:23:38):
这其中也有细微差别。22 岁的我总是想通宵工作，所以创造一个允许这种行为的空间也很重要。在 Pandora，有时甚至有点矫枉过正，好像通宵是不对的，大家会说：“你应该多休息，为什么要这么拼？”但我确实努力创造一种环境，让人们在正常生活和技术生活之间保持合理的平衡。我觉得这多年来帮我坚持了下来，但我现在依然经常在晚上和周末工作，因为我热爱它。
(01:24:16):
还有一件事。我在 Pandora 的经历中非常幸运，获得了一笔巨大的、甚至可能是不相称的经济回报，这给了我以前从未想象过的选择权。十年后我离开时，我不知道该做什么，但我确实需要休息。那是一份非常辛苦的工作，我需要时间恢复。但如果你在第一天问我，我会说：“我不明白为什么这些人成功后会立刻创办另一家公司。为什么？世界上有那么多事可以做，为什么要再开一家公司？太辛苦了。”
(01:25:02):
我当时特别迷恋“体验”。我不在乎物质，不想要名表或豪车，我想看世界。我想：“我要去伦敦住三个月，回旧金山待一个月，再去墨西哥城住三个月，过一种沉浸在各种体验中的生活。”做了六个月后，我意识到：我真正在乎的不是体验，而是关系。如果你是一个整天飞来飞去寻找新体验的人，你很难建立和维持亲密、令人满意的关系。
(01:25:47):
于是我回到旧金山，我想：“如果我想和朋友及志同道合的人在一起，我就不能满世界跑。”你知道人们周一早上在做什么吗？他们在工作。如果你想参与人类社会，周一早上他们就在工作岗位上。所以，比起“想造东西”的冲动（我确实有），我更有“想与人协作、与他人同场竞技”的冲动。这就是为什么我去了 Snapchat，停止了对体验的追逐，回到了构建者的行列。正如我们所说，后来我想：“我关心协作，但也许我不一定要做软件。”Quibi 让我重新爱上了那个过程。现在，我又在做软件了。

---

### [01:26:48] Lenny

**English:**
Plus being on a board of a hardware company. What you just shared reminds me of Mark Manson's book, The Subtle Art of Not Giving a Fuck. Have you read this book?

**中文翻译:**
再加上你还在一家硬件公司的董事会。你刚才分享的内容让我想起了 Mark Manson 的书《精微的放手艺术》（The Subtle Art of Not Giving a Fuck）。你读过这本书吗？

---

### [01:26:58] Tom Conrad

**English:**
I have not.

**中文翻译:**
还没读过。

---

### [01:26:59] Lenny

**English:**
Okay. It sold a bazillion copies, and the core of it is that we get joy out of solving problems and we think we'll be happy when we have freedom to do nothing. But it turns out freedom is only helpful to help us discover the problems we just want to keep solving.

**中文翻译:**
好。它卖了无数本，核心观点是：我们从解决问题中获得快乐。我们以为拥有“无所事事的自由”会幸福，但事实证明，自由的唯一用处是帮助我们发现那些我们愿意一直解决下去的问题。

---

### [01:27:16] Tom Conrad

**English:**
Yeah, totally. I think that's exactly right. Yeah.

**中文翻译:**
是的，完全正确。

---

### [01:27:20] Lenny

**English:**
It sounds like that's the experience you went on. Last question, this new segment, I'm going to call Contrarian Corner. And the question is, is there something that you have a contrarian opinion about, something that you believe that most other people don't?

**中文翻译:**
听起来这就是你的经历。最后一个问题，这是一个新环节，我称之为“非共识角落”（Contrarian Corner）。问题是：你有什么非共识的观点吗？也就是你相信但大多数人不相信的事情。

---

### [01:27:35] Tom Conrad

**English:**
There's a segment in our industry that believes this very intensely, which is there's this belief that everybody needs to be a founder. And I think in some ways our industry would be much better off if there were fewer founders. I use an entire category of smart, creative, hardworking, talented, borderline visionary people who can raise that $2 million seed and go off and build some stupid company that's never going to go anywhere, that would be so much better off finding a team that needs their skillset and working on a problem that has, as I described, the mathematical formula that's going to win, that has the market opportunity that's the right size, that has the 10X thinking that can really... And I'm a little biased here because while I am a CEO for the first time now, I've never been a founder and I've been lucky enough to find a bunch of young teams that could benefit from my skills and enthusiasms, and sometimes to some success and sometimes to some embarrassment, but always really, really interesting.
(01:28:53):
Yeah. If you're out there and you think that the only possible way you can be successful in this industry on any metric, whatever metric you care about: you want the acclaim of your peers, you want financial reward, you want any of the things that people aspire to, outside impact on culture, whatever the thing is that gets you out of bed every morning, you can achieve that in collaboration with others. You don't have to be the person that raises the seed round.

**中文翻译:**
我们行业里有一部分人对此深信不疑，即认为每个人都需要成为创始人。我认为在某些方面，如果创始人少一些，我们的行业会好得多。有一大批聪明、有创意、勤奋、有才华、甚至近乎有远见的人，他们能筹集到 200 万美元的种子轮，然后去创办一些永远不会有出路的小公司。如果这些人能找到一个需要他们技能的团队，去解决一个拥有获胜“数学公式”、市场规模合适、具备 10 倍增长思维的问题，他们的处境会好得多。我在这里可能有点偏见，因为虽然我现在是第一次当 CEO，但我从未当过创始人。我很幸运地找到了一群能从我的技能和热情中获益的年轻团队，有时获得了成功，有时遭遇了尴尬，但过程总是非常有趣。
(01:28:53):
是的。如果你觉得在这个行业里，要在任何指标上获得成功——无论是同行的赞誉、经济回报，还是人们向往的任何东西，比如对文化的外部影响，无论是什么让你每天早上起床动力十足——唯一的途径就是当创始人，那你就错了。你可以通过与他人协作来实现这些。你并不一定要成为那个筹集种子轮资金的人。

---

### [01:29:24] Lenny

**English:**
I 100% agree with that. I'm always telling people, "Don't start a company. It's super painful, very rarely works out. It's so hard." I don't know what's harder, being a product manager or being a founder, probably being a founder. They're both very hard.

**中文翻译:**
我百分之百同意。我总是告诉人们：“不要创业。这极其痛苦，极少成功，太难了。”我不知道是当产品经理更难还是当创始人更难，可能还是创始人吧。两者都非常难。

---

### [01:29:37] Tom Conrad

**English:**
Yeah, it is quite hard too. Yeah. Yeah. And just to be perfectly clear, there's something really special about founders. At both Pandora and now at Zero, the actual founders have from time to time said, "Well, you're like a founder." And I'm like, "I'm nothing like a founder. You took all the risk. When I showed up, there was a team and there was momentum and there was money in the bank. I appreciate your desire to say complimentary things, but 'You're like a founder' is not one that I'll take."

**中文翻译:**
是的，确实很难。而且要说明一点，创始人身上确实有一些非常特别的东西。在 Pandora 和现在的 Zero，真正的创始人们偶尔会说：“嗯，你就像个创始人。”我会说：“我一点也不像创始人。你们承担了所有的风险。当我出现时，已经有了团队、有了势头，银行里也有了钱。我感谢你们想说赞美的话，但‘你像个创始人’这一条我不接受。”

---

### [01:30:08] Lenny

**English:**
With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
说到这，我们进入了非常刺激的闪电问答环节。准备好了吗？

---

### [01:30:11] Tom Conrad

**English:**
I am ready.

**中文翻译:**
准备好了。

---

### [01:30:13] Lenny

**English:**
What are two or three books that you've recommended most to other people?

**中文翻译:**
你向别人推荐最多的两三本书是什么？

---

### [01:30:17] Tom Conrad

**English:**
I really love Elad Gil's High Growth Handbook. It's organized into chapters about foundational company building, building a leadership team, building a board, and in addition to the thoughtful synthesis on that topic from Elad, he has an interview of someone that he does relevant to that section on each of the chapters. Really, really great read and super actionable if you're a leader in a young company. In a completely different end of the spectrum, I love big, complicated science fiction and there's a lot of garbage science fiction out there to be sure, but when you find something special, it's the best. So probably through the years in that category, there's a book called Hyperion by Dan Simmons. That's just a total classic. Everybody should read it.

**中文翻译:**
我非常喜欢 Elad Gil 的《高增长手册》（High Growth Handbook）。它分为公司基础建设、组建领导团队、组建董事会等章节。除了 Elad 对这些话题的深刻总结外，每一章他都会采访一位相关领域的专家。如果你是一家年轻公司的领导者，这本书非常值得一读，且极具操作性。在另一个完全不同的领域，我喜欢宏大、复杂的科幻小说。当然，市面上有很多垃圾科幻，但当你发现特别的作品时，那是无与伦比的。这些年来，我最推荐的是丹·西蒙斯的《海伯利安》（Hyperion）。那是绝对的经典，每个人都应该读读。

---

### [01:31:08] Lenny

**English:**
I read that. I think I read the first couple in the first one.

**中文翻译:**
我读过。我想我读了第一本的前几章。

---

### [01:31:08] Tom Conrad

**English:**
Yeah. There is a sequel that's exceptional as well. And it's probably worth warning your readers that Hyperion is quite long and has an absolute cliffhanger.

**中文翻译:**
是的，续集也非常出色。不过可能得提醒读者，《海伯利安》非常长，而且结尾留了一个巨大的悬念。

---

### [01:31:21] Lenny

**English:**
I think they're making a show out of it, which is going to be wild. I don't know how they do a show around that book. I thought you were going to say this other book, A Fire Upon the Deep. Have you heard of this book?

**中文翻译:**
我想他们正在把它改编成剧集，那一定会很疯狂。我不知道他们怎么围绕那本书拍剧。我以为你会说另一本书，《深渊上的火》（A Fire Upon the Deep）。你听过这本书吗？

---

### [01:31:29] Tom Conrad

**English:**
Oh, that's so good too.

**中文翻译:**
噢，那本也非常棒。

---

### [01:31:31] Lenny

**English:**
Okay. That's also very complicated, but incredible.

**中文翻译:**
是的，也非常复杂，但很精彩。

---

### [01:31:34] Tom Conrad

**English:**
Yeah, I had completely forgotten about that. That's a very special book. There's a couple in that series too.

**中文翻译:**
是的，我完全忘了那一本。那是一本非常特别的书，那个系列也有好几本。

---

### [01:31:40] Lenny

**English:**
Yeah, I think I only read the first one. Also, Three-Body Problem is the other one that I always think about. It's come up a couple of times on this podcast. Let's move on to the next question. Do you have a favorite recent movie or a TV show?

**中文翻译:**
是的，我想我只读了第一本。另外，《三体》也是我经常想到的，在本播客中出现过好几次。下一个问题：你最近有喜欢的电影或电视剧吗？

---

### [01:31:53] Tom Conrad

**English:**
I consume a lot of video content, both stuff that I'm very proud to talk about and stuff that I'm less proud to talk about, but I really liked the new Damon Lindelof show that's on Peacock called Mrs. Davis. So Lindelof, of course, from Lost and the new Watchmen on HBO, and Mrs. Davis is about an AI that you wear in your ear, like the HER AI and a nun that is hell-bent on the AI's destruction, and it reads like an early Coen brothers movie. It's super darkly funny and really, really thoughtful and unlike too much streaming, I think it's seven episodes, and it is a perfectly encapsulated story that has a beginning, middle, and an end and doesn't need to ever have another episode. It's amazing. Get yourself a Peacock subscription for at least a month to watch Mrs. Davis.

**中文翻译:**
我消费大量的视频内容，有些我很乐意谈论，有些则没那么自豪。但我非常喜欢 Damon Lindelof 在 Peacock 上的新剧《戴维斯夫人》（Mrs. Davis）。Lindelof 曾制作过《迷失》和 HBO 的新版《守望者》。《戴维斯夫人》讲的是一个戴在耳朵里的 AI（类似电影《她》里的 AI）和一个一心想摧毁这个 AI 的修女的故事。它看起来像早期的科恩兄弟电影，充满了黑色幽默，非常有深度。而且不像很多流媒体剧集，它只有七集，是一个非常完整的故事，有始有终，不需要续集。太棒了，为了看《戴维斯夫人》，值得去订阅一个月 Peacock。

---

### [01:32:56] Lenny

**English:**
Favorite interview question you like to ask candidates that you're interviewing?

**中文翻译:**
你面试候选人时最喜欢问的问题是什么？

---

### [01:32:59] Tom Conrad

**English:**
There are two things about interviews. The first is I always encourage people when they're thinking about their interview questions to take any question that they're tempted to pull from their own current experience with the goal of trying to, how would this person solve this thing that I'm working through right now? Because just causing the other person to speculate and oftentimes about your own business, I think you know really well that they don't actually know anything about, it creates this imbalance between the interviewer and the interviewee that feels out of sync with how I think about the collaborative nature of a great interview. So I tell people that almost every interview question should start with, "Tell me about a time in your career when..." to give them permission or to set their expectation that I'm asking them to tell me about something they've actually done that is relevant to the topic that I'm probing.
(01:33:59):
So that's just a structural thing that I try to do. And then usually towards the end of the interview, I ask almost everybody, "Imagine that you had a really great day at work. What was it that you did on that day?" Because what I'm trying to figure out is left to their own devices, what do they go to naturally because it rewards them? Because I think it's really important to find the highest best use of everyone you hire. And sometimes you can get a little bit to the bottom of what's the highest best use if you understand the things where there's a natural reward mechanism because it's like, "Well, I had this great day. I'm going to do more of that tomorrow." "What was the thing?" And it's just pretty illuminating.

**中文翻译:**
关于面试有两点。第一，我总是鼓励人们在构思面试问题时，不要问那些试图让对方解决你目前正在处理的问题。因为让对方去推测——而且往往是推测他们并不真正了解的你的业务——会在面试官和应聘者之间造成一种不平衡，这与我认为的优秀面试的协作性质不符。所以我告诉人们，几乎每个面试问题都应该以“告诉我你职业生涯中曾经……”开头，这给了他们许可，也设定了预期，即我是在要求他们讲述一件他们真正做过的、与我正在探究的话题相关的事。
(01:33:59):
这只是我尝试做的一个结构性调整。然后，通常在面试快结束时，我会问几乎所有人：“想象你在工作中度过了非常棒的一天。那一天你具体做了什么？”因为我想弄清楚，在没有外界压力的情况下，他们会自然而然地去做什么，因为那能给他们带来成就感。我认为找到每个员工的“最高最佳用途”非常重要。如果你了解那些能给他们带来自然奖励机制的事情，你就能在一定程度上摸清他们的最高最佳用途。这非常具有启发性。

---

### [01:34:45] Lenny

**English:**
Is there a favorite product you've recently discovered that you really love?

**中文翻译:**
你最近有没有发现什么非常喜欢的、心头好的产品？

---

### [01:34:49] Tom Conrad

**English:**
I have bought every pair of headphones on the planet, in part because Apple's headphones do not stay in my ears. I've sneezed one across the room, I've lost one down a drainpipe. They don't stay, none of them, the wired ones, the not wired ones, the in-ear ones, and it's left me feeling honestly like I am some kind of anatomical freak. I look at other people wearing them, I'm like, "What is going on with their ear that it's just staying there perfect?" It seems inconceivable to me. Nonetheless, I have a pair of AirPods Pro's that I want to love and put up with the fact that I'm going to drop them, lose them, sneeze them across the room.
(01:35:32):
But recently I came across this product from a company called Eartune that they're replacement tips and they just have the littlest bit of compression foam on them. They don't make the AirPods so big that they won't fit in the recharging case or anything, and they work. Miraculously, they stay in my ear. And Apple has this feature called Size Fit or something, go in settings, find your AirPods, scroll all the way down in the settings, and you can run this test where they play some audio and they tell you how good the seal is. And that revealed that my right ear is weirder than my left ear. So I actually have to use different tips in either sizes. Suddenly this sounds like a vaguely disgusting conversation that we're having. Anyway, I'm just really thrilled about my ability to wear Apple's AirPods after all these years.

**中文翻译:**
我买过地球上所有的耳机，部分原因是苹果的耳机在我耳朵里根本待不住。我曾打个喷嚏就把耳机喷飞到房间另一头，还曾把一只掉进排水管。不管是线控的、无线的还是入耳式的，都待不住。这让我觉得自己像个解剖学上的怪胎。我看别人戴着，心想：“他们的耳朵到底是怎么长的，能让耳机待得那么完美？”这对我来说不可思议。尽管如此，我还是有一副 AirPods Pro，我努力想爱上它，并忍受它随时会掉落、丢失或被喷飞的风险。
(01:35:32):
但最近我发现了一家叫 Eartune 的公司的产品，那是替换耳塞套，上面有一点点压缩海绵。它们不会让 AirPods 大到放不进充电盒，而且真的有效。奇迹般地，它们能留在我的耳朵里。苹果有一个叫“耳塞贴合度测试”的功能，在设置里找到 AirPods，拉到底就能运行。测试显示我的右耳比左耳更奇怪，所以我两边得用不同尺寸的耳塞套。突然间我觉得我们的谈话变得有点恶心了。总之，我真的很兴奋，这么多年后我终于能戴住苹果的 AirPods 了。

---

### [01:36:32] Lenny

**English:**
I think what we're learning is you are a mutant, your ears are different. Cool. We'll link to that product in the show notes.

**中文翻译:**
我想我们了解到的是：你是个变异人，你的耳朵与众不同。酷，我们会在节目介绍里附上那个产品的链接。

---

### [01:36:40] Tom Conrad

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:36:41] Lenny

**English:**
Do you have a favorite life motto that you often come back to or share with friends, either in work or in life that you find useful?

**中文翻译:**
你有没有什么最喜欢的人生格言，是你经常回想或与朋友分享的，无论是在工作还是生活中？

---

### [01:36:48] Tom Conrad

**English:**
You can't be a product person without having an eye rolly Charles Eames quote that's at the center of your existence. And for me, the Charles Eames quote is, "The details are not the details. They make the design." And I just really absolutely believe that, that the devil is in the details when you're a product designer and be uninterested in nuance at your peril.

**中文翻译:**
作为一个产品人，你的核心信念里总会有一句让人想翻白眼的查尔斯·伊姆斯（Charles Eames）的名言。对我来说，那句话是：“细节不仅仅是细节，细节成就设计。”我对此深信不疑。当你是一名产品设计师时，魔鬼就在细节中，如果你对细微差别不感兴趣，后果自负。

---

### [01:37:14] Lenny

**English:**
Final question. You worked with the creator of the GIF format. How does he pronounce, giff or jiff?

**中文翻译:**
最后一个问题。你曾与 GIF 格式的创造者共事。他怎么发音？是 Giff 还是 Jiff？

---

### [01:37:22] Tom Conrad

**English:**
Yeah. So before all of this, I worked at a company called CompuServe when I was in high school.

**中文翻译:**
是的。在这一切之前，我高中时在一家叫 CompuServe 的公司工作过。

---

### [01:37:29] Lenny

**English:**
CompuServe, I used CompuServe. I didn't know that. That's amazing.

**中文翻译:**
CompuServe！我用过 CompuServe。我以前不知道你在那儿，太神奇了。

---

### [01:37:33] Tom Conrad

**English:**
There was a guy on the team named Steve Wilhite who invented Graphics Interchange Format, GIF, and he was a straight out of central casting, 1960s neck beard programmer type, and the first I had ever encountered and very prickly. And it's crazy, but at the time, Steve would take all comers in the fight that it was pronounced jiff. Now he's obviously wrong. It's obviously pronounced giff. It's crazy to me now 35 years later, this is still a topic that pops up on the internet every once in a while. It's somehow like Zelig, I cross paths with the guy who created Graphics Interchange Format and I know his opinion on the topic even though it's an unpopular one.

**中文翻译:**
团队里有个叫 Steve Wilhite 的人，他发明了图形交换格式（GIF）。他是个典型的 60 年代那种留着络腮胡的程序员，是我见过的第一个这类人，性格非常古怪。疯狂的是，当时 Steve 会和任何争论发音的人开战，他坚持认为应该读作“Jiff”。现在看来他显然错了，显然应该读作“Giff”。让我觉得疯狂的是，35 年后，这依然是互联网上偶尔会冒出来的话题。我就像电影里的 Zelig 一样，竟然和发明 GIF 的人有过交集，而且知道他那个非主流的观点。

---

### [01:38:35] Lenny

**English:**
Got it. So he likes jiff, but you agree it's giff?

**中文翻译:**
明白了。他喜欢读 Jiff，但你认为应该是 Giff？

---

### [01:38:38] Tom Conrad

**English:**
It's definitely giff. It's obviously giff.

**中文翻译:**
绝对是 Giff。显而易见是 Giff。

---

### [01:38:40] Lenny

**English:**
Okay, great. We're on the same page. We've decided. Let it be known.

**中文翻译:**
太好了，我们达成共识了。就这么定了，昭告天下吧。

---

### [01:38:44] Tom Conrad

**English:**
Let it be known.

**中文翻译:**
昭告天下。

---

### [01:38:45] Lenny

**English:**
Tom, we've talked about successes, we've talked about failures, mental health, general health, all kinds of awesome stories. Two final questions. Where can folks find you online if they want to reach out and maybe ask some other questions that I didn't ask, and how can listeners be useful to you?

**中文翻译:**
Tom，我们聊了成功、失败、心理健康、身体健康，还有各种精彩的故事。最后两个问题：如果听众想联系你或者问一些我没问到的问题，在哪里可以找到你？以及，听众可以为你做些什么？

---

### [01:39:00] Tom Conrad

**English:**
I'm @tconrad on all the socials, from Twitter to Threads to Instagram. My DMs are open everywhere, and I would absolutely be delighted to hear from any of your listeners on any topic that they choose. And what can you do for me? I would love for folks to download Zero and give it a try and send me some feedback about what we're doing right and what we're doing wrong, and we'd love to have our little product be part of your life.

**中文翻译:**
我在所有社交平台上都叫 @tconrad，包括 Twitter、Threads 和 Instagram。我的私信是开放的，我非常乐意听取听众关于任何话题的想法。至于能为我做什么？我希望大家能下载 Zero 试用一下，并给我一些反馈，告诉我们哪里做得对、哪里做得不对。我们很希望我们的小产品能成为你生活的一部分。

---

### [01:39:32] Lenny

**English:**
Awesome. Tom, thank you so much for being here.

**中文翻译:**
太棒了。Tom，非常感谢你能来。

---

### [01:39:35] Tom Conrad

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:39:36] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。另外，请考虑给我们评分或留下评论，这能帮助更多听众发现这个播客。你可以在 lennyspodcast.com 找到往期所有节目或了解更多信息。下期节目见。