# Tomer Cohen 2.0 - 双语对照

This is the complete bilingual transcript of Lenny’s Podcast featuring Tomer Cohen (CPO of LinkedIn).

---

### [00:00:00] Tomer Cohen

**English:**
When we look at the skills required to do your job, by 2030, it will change by 70%. So whether or not you're looking to change your job, your job is changing. In order to stay competitive, you actually have to go back to some first principles, go back to the drawing board and reimagine what it means to be building.

**中文翻译:**
当我们审视完成工作所需的技能时，到 2030 年，这些技能将发生 70% 的变化。所以，无论你是否打算换工作，你的工作本身都在发生变化。为了保持竞争力，你实际上必须回归一些第一性原理（first principles），回到绘图板前，重新构想“构建（building）”的真正含义。

---

### [00:00:15] Lenny Rachitsky

**English:**
You're experimenting with a very different way of building product at LinkedIn that fully embraces what AI unlocks.

**中文翻译:**
你正在 LinkedIn 尝试一种截然不同的产品构建方式，这种方式全面拥抱了 AI 所释放的潜力。

---

### [00:00:24] Tomer Cohen

**English:**
We call it the full stack builder model. The goal itself is to empower great builders to take their idea and to take it to market, regardless of their role and the stack and which team they're on. It's really fluid interaction between human and machine.

**中文翻译:**
我们称之为“全栈构建者模型（full stack builder model）”。其目标是赋能优秀的构建者，让他们能够将自己的想法推向市场，而无需受限于他们的角色、技术栈或所属团队。这实际上是人与机器之间一种非常流动的交互。

---

### [00:00:37] Lenny Rachitsky

**English:**
This feels like this could be a model for how a lot of companies operate and how product ends up being built in the future.

**中文翻译:**
这听起来像是未来许多公司运作以及产品最终构建方式的一个典范。

---

### [00:00:42] Tomer Cohen

**English:**
Change management here is going to be a critical part, but it's not enough to give them the tools. You have to build the incentives programs, the motivation, the examples to how you do it. I see a lot of companies roll out their agents and just expecting companies to adopt. It doesn't work this way.

**中文翻译:**
变革管理（Change management）将是其中的关键部分，但仅仅给他们工具是不够的。你必须建立激励机制、动力以及如何操作的范例。我看到很多公司推出了他们的智能体（agents），就指望公司内部会自动采用。事实并非如此。

---

### [00:00:56] Lenny Rachitsky

**English:**
There's always been this question, is AI going to just make people that are not amazing, more amazing, or is it going to make amazing people even more amazing?

**中文翻译:**
一直以来都有这样一个疑问：AI 是会让平庸的人变得优秀，还是会让优秀的人变得更加卓越？

---

### [00:01:01] Tomer Cohen

**English:**
Top talent has this tendency of continuously trying to get better at their craft. The key trait that I'm emphasizing for builders is...

**中文翻译:**
顶尖人才往往会不断尝试精进自己的手艺。我为构建者强调的关键特质是……

---

### [00:01:11] Lenny Rachitsky

**English:**
Today, my guest is Tomer Cohen, longtime chief product officer at LinkedIn, who is piloting a new way of building that I think will become a model for how companies operate in the future. It's called the Full Stack Builder Program, and essentially the idea is to enable anyone, no matter their function, to take products from idea to launch. They've scrapped their APM program and replaced it with an associate full stack builder program. They've introduced a new career path with the title Full Stack Builder that anyone from any function can become. And as you'll hear in the conversation, they've built a bunch of internal tools and agents and processes to basically build a human plus AI product team that can move really fast, adjust to change quickly, and do a lot more with a lot less. If you're looking for inspiration for how to rethink how your team operates and to lean into what AI is unlocking for teams and companies, this episode is for you.

**中文翻译:**
今天的嘉宾是 Tomer Cohen，他是 LinkedIn 资深的首席产品官（CPO）。他正在试点一种全新的构建方式，我认为这将成为未来公司运作的模式。这被称为“全栈构建者计划（Full Stack Builder Program）”，其核心理念是让任何人，无论其职能如何，都能将产品从创意推向发布。他们已经取消了原有的 APM（助理产品经理）项目，取而代之的是“助理全栈构建者项目”。他们引入了一条全新的职业路径，职称为“全栈构建者”，任何职能的人都可以转型。正如你在对话中将听到的，他们开发了一系列内部工具、智能体和流程，基本上打造了一支“人类+AI”的产品团队，能够极速行动、快速适应变化，并以更少的资源完成更多的工作。如果你正在寻找灵感，想要重新思考团队的运作方式，并拥抱 AI 为团队和公司带来的新机遇，那么这一集就是为你准备的。

---

### [00:02:06] Lenny Rachitsky (Continued)

**English:**
(00:02:06): A huge thank you to Shira Gasarch for suggesting topics for this conversation. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It helps tremendously. And if you become an annual subscriber of my newsletter, you get a year free of a bunch of incredible products, including a year free of Devin, Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, [inaudible 00:02:29], Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD, Mobbin and Stripe Atlas. Head on over to lennysnewsletter.com and click product pass. With that, I bring you Tomer Cohen after a short word from our sponsors.

**中文翻译:**
非常感谢 Shira Gasarch 为本次对话提供的选题建议。如果你喜欢这个播客，请不要忘记在常用的播客应用或 YouTube 上订阅和关注。这对我们帮助巨大。如果你成为我时事通讯（newsletter）的年度订阅者，你将免费获得一年的一系列优秀产品，包括 Devin, Lovable, Replit, Bolt, n8n, Linear, Superhuman, Descript, Gamma, Perplexity, Warp, Granola, Magic Patterns, Raycast, ChatPRD, Mobbin 和 Stripe Atlas。请访问 lennysnewsletter.com 并点击“product pass”。下面，在听完赞助商的简短介绍后，我们将请出 Tomer Cohen。

---

### [00:02:42] Lenny Rachitsky (Sponsorships)

**English:**
My podcast guests and I love talking about craft and taste and agency and product market fit. You know what we don't love talking about? SOC 2. That's where Vanta comes in. Vanta helps companies of all sizes get compliant fast and stay that way with industry-leading AI, automation, and continuous monitoring. Whether you're a startup tackling your first SOC 2 or ISO 27001 or an enterprise managing vendor risk, Vanta's trust management platform makes it quicker, easier, and more scalable. Vanta also helps you complete security questionnaires up to five times faster so that you can win bigger deals sooner. The result? According to a recent IDC study, Vanta customers slashed over $500,000 a year and are three times more productive. Establishing trust isn't optional. Vanta makes it automatic. Get $1,000 off at vanta.com/lenny.

**中文翻译:**
我的播客嘉宾和我喜欢谈论手艺、品味、主观能动性（agency）和产品市场契合度（PMF）。你知道我们不喜欢谈论什么吗？SOC 2 合规。这就是 Vanta 大显身手的地方。Vanta 利用行业领先的 AI、自动化和持续监控，帮助各种规模的公司快速实现并保持合规。无论你是正在处理第一个 SOC 2 或 ISO 27001 的初创公司，还是管理供应商风险的大型企业，Vanta 的信任管理平台都能让合规变得更快捷、更简单、更具扩展性。Vanta 还能帮你完成安全问卷的速度提高五倍，让你更快赢得大单。结果如何？根据 IDC 最近的一项研究，Vanta 的客户每年节省超过 50 万美元，生产力提高了三倍。建立信任不是可选项，Vanta 让它变成自动化。在 vanta.com/lenny 获取 1000 美元优惠。

---

### [00:03:36] Lenny Rachitsky (Sponsorships)

**English:**
This episode is brought to you by Figma, makers of Figma Make. When I was a PM at Airbnb, I still remember when Figma came out and how much it improved how we operated as a team. Suddenly, I could involve my whole team in the design process, give feedback on design concepts really quickly, and it just made the whole product development process so much more fun. But Figma never felt like it was for me. It was great for giving feedback and designs, but as a builder, I wanted to make stuff. That's why Figma built Figma Make. With just a few prompts, you can make any idea or design into a fully functional prototype or app that anyone can iterate on and validate with customers. Figma Make is a different kind of vibe coding tool. Because it's all in Figma, you can use your team's existing design building blocks, making it easy to create outputs that look good and feel real and are connected to how your team builds. Stop spending so much time telling people about your product vision, and instead show it to them. Make code-backed prototypes and apps fast with Figma Make. Check it out at figma.com/lenny.

**中文翻译:**
本集节目由 Figma 赞助，他们是 Figma Make 的创造者。当我在 Airbnb 担任产品经理时，我仍然记得 Figma 问世的情景，以及它如何极大地改善了我们团队的运作方式。突然间，我可以让整个团队参与到设计过程中，快速对设计概念给出反馈，这让整个产品开发过程变得有趣得多。但 Figma 以前感觉并不完全是为我准备的。它非常适合反馈和设计，但作为一个构建者，我想亲手做出东西。这就是为什么 Figma 开发了 Figma Make。只需几个提示词（prompts），你就可以将任何想法或设计变成功能齐全的原型或应用，任何人都可以对其进行迭代并向客户验证。Figma Make 是一种不同寻常的“氛围编程（vibe coding）”工具。因为它完全集成在 Figma 中，你可以使用团队现有的设计组件，轻松创建出看起来美观、感觉真实且与团队构建方式相连的产出。别再花那么多时间向人们描述你的产品愿景了，直接展示给他们看。使用 Figma Make 快速制作由代码驱动的原型和应用。请访问 figma.com/lenny 查看。

---

### [00:04:42] Lenny Rachitsky

**English:**
Tomer, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Tomer，非常感谢你能来到这里，欢迎来到本播客。

---

### [00:04:45] Tomer Cohen

**English:**
Thank you. It's great to be back.

**中文翻译:**
谢谢，很高兴能再次回来。

---

### [00:04:47] Lenny Rachitsky

**English:**
It's great to have you back. I'm really excited to be chatting because you're experimenting with a very different way of building product at LinkedIn that fully embraces what AI unlocks, kind of leans into what is now possible, and to me, this feels like this could be a model for how a lot of companies operate and how product ends up being built in the future. There's a lot of product leaders that are talking about AI, what they can do. It feels like you're actually doing this in a really, really radical way, and so I'm excited to learn from you to hear about this for listeners to understand what you're seeing, what you've learned. Let me start with just why did you decide this was necessary? Why are you rethinking all of these things about how product has been built for a long time? AKA, why do people need to pay attention to what we're about to be talking about?

**中文翻译:**
很高兴你能回来。我非常期待这次聊天，因为你正在 LinkedIn 尝试一种截然不同的产品构建方式，它全面拥抱了 AI 释放的潜力，顺应了当下的可能性。对我来说，这感觉像是未来许多公司运作和产品构建的典范。很多产品领导者都在谈论 AI 及其用途，但感觉你正在以一种非常激进的方式付诸实践。所以我很兴奋能向你学习，听听你的见解，让听众了解你的所见所学。首先我想问，为什么你认为这是必要的？为什么你要重新思考这些长期以来的产品构建方式？换句话说，为什么人们需要关注我们接下来要讨论的内容？

---

### [00:05:34] Tomer Cohen

**English:**
It really starts with kind of the basics. For me, technology has always been about empowerment. It's not about what it does for us. It's about what enables us to do. And now we have this amazing opportunity in my mind to make it about meritocracy, and I think it's an opportunity, but it's also a necessity right now, and I want to put this in context where we're entering this phase where the time constant of change is far greater than the time constant of response. Basically means that change is happening faster than we're able to respond to it. Now, LinkedIn has this unique view of the world of work. So we actually have some pretty, in my mind, mind-blowing stats to put this in perspective. When we look at the skills required to do your job, by 2030, which is literally four years from now, sounds a long time, but four years from now, it will change by 70%.
(00:06:25): So whether or not you're looking to change your job, your job is changing. The only question is, do you keep it? And then we look at organizationally, the fastest growing jobs right now, the most in demand jobs in the market are growing by north of 70% from last year's fastest growing job. So there's a new kind of iteration of what you need as an organization to thrive. And then you apply that to building products and you realize that in order to stay competitive, you actually have to go back to some first principles, go back to the drawing board and reimagine what it means to be building. And what I love about this is when you think about the role of a builder, which the builder is at the heart of company, the goal is actually quite simple. The builder takes an ADN, she brings it to life. That's really the process, right?
(00:07:11): And we all build those, let's call them best practices. You research the problem really well, you spec it out, you design it, you code it, you launch it, and you iterate. That's basically it. But what happens at many at scale companies, LinkedIn included and many other companies, over time that process became very complex very quickly. So what happened? We took every step and we expanded it to a lot of sub-steps. Researching, the problem became looking at for us 10 to 15 sources of information, obviously talking to customers about doing data pools, looking at feedback tickets in multiple sources, social media, interactions with customers. We probably have 10 to 15 sources of information we go for before we feel like we have research department really, really well.
(00:07:58): Think about reviews for product. There is design reviews, privacy reviews, security reviews. I can go on and on and on. And each one of those substeps actually has a valid reason to exist. But when you add a whole thing together, you're like, "Oh my God. This is why it takes, to build a small feature, multiple teams, multiple code bases, multiple sprints just to get it out to launch," and not talk about iterating, which is actually where you seek success. You never see success in the launch itself. So really the work itself is not complex, but the process we made very complex. And when I was digging in, I found it doesn't end there because somebody has to do all those substeps, so what happened is you actually move from process complexity to organizational complexity as well.
(00:08:41): And then you actually led to microspecialization. All those subsets are doing by somebody specific. So from one builder, we have multiple functions. Obviously we have engineering, product and design, and you can start questioning those lines. At least I am internally. And from there, we have a lot of subspecialties. It happens in every one of those functions, but imagine design. We have interaction design, animation design, content design, research. There's so many aspects to that. So they're all valid, but they all have people, and that entire process basically means a lot of... It's basically bloating. It's complexity. And then without noticing, you end up with this massively complex... We actually have this diagram that basically shows the process complexity, organizational complexity together.
(00:09:26): And usually people are mind blown because they're working on one thing very specific, but when you zoom out, you have this overwhelming experience you're kind of thinking about. And now we have this real opportunity to collapse the stack backup, go back to craftsmanship, rethink the product development lifecycle, which is where the full stack builder model comes to life.

**中文翻译:**
这确实要从最基础的谈起。对我来说，技术的核心始终在于赋能。它不在于它为我们做了什么，而在于它让我们能够做什么。在我看来，现在我们有一个绝佳的机会，让技术服务于“唯才是举（meritocracy）”。我认为这既是机遇，也是当下的必然。我想把这放在一个大背景下：我们正进入一个“变化的常数时间远大于响应的常数时间”的阶段。简单来说，就是变化发生的速度超过了我们的响应能力。LinkedIn 对职场世界有着独特的视角，我们有一些在我看来非常惊人的数据可以说明这一点。当我们观察完成工作所需的技能时，到 2030 年（也就是短短四年后，听起来很远，其实只有四年），这些技能将发生 70% 的变化。
无论你是否打算换工作，你的工作都在发生变化。唯一的问题是，你还能保住它吗？从组织层面看，目前增长最快、市场需求最大的职位，其增长率比去年的热门职位高出 70% 以上。因此，组织若想蓬勃发展，就需要一种全新的迭代方式。当你把这一点应用到产品构建上时，你会意识到，为了保持竞争力，你必须回归第一性原理，重新构想“构建”的含义。我喜欢这一点的原因是，当你思考“构建者（builder）”的角色时（构建者是公司的核心），目标其实很简单：构建者拿出一个想法，并将其变为现实。这就是整个过程，对吧？
我们都建立了一套所谓的“最佳实践”：深入研究问题、编写规格说明（spec）、设计、编码、发布、迭代。基本就是这样。但在许多规模化公司（包括 LinkedIn 和许多其他公司），随着时间的推移，这个过程很快变得非常复杂。发生了什么？我们将每一个步骤都拆解成了大量的子步骤。研究问题变成了查看 10 到 15 个信息源，包括与客户交谈、数据提取、查看多个渠道的反馈单、社交媒体、客户互动。在觉得研究透彻之前，我们可能要查阅 10 到 15 个信息源。
再想想产品评审：设计评审、隐私评审、安全评审，等等。每一个子步骤都有其存在的合理理由。但当你把所有这些加在一起时，你会感叹：“天哪，这就是为什么开发一个小功能需要多个团队、多个代码库、多个冲刺（sprints）才能发布。”更不用说迭代了，而迭代才是成功的关键。成功从来不在于发布本身。所以，工作本身并不复杂，是我们把流程搞复杂了。当我深入研究时，我发现问题不止于此，因为每个子步骤都得有人去做，于是流程的复杂性演变成了组织的复杂性。
这导致了“微专业化（microspecialization）”。每个子步骤都由特定的人负责。于是，从一个构建者演变成了多个职能部门。显然，我们有工程、产品和设计，你甚至可以开始质疑这些界限——至少我在内部是这么做的。在此基础上，我们还有很多细分专业。每个职能部门都有，以设计为例：交互设计、动画设计、内容设计、研究。方方面面都有。它们都很重要，但都有专人负责，整个过程意味着大量的……基本上就是臃肿和复杂。在不知不觉中，你面对的是一个极其复杂的系统。我们有一张图表，展示了流程复杂性和组织复杂性交织在一起的样子。
通常人们会感到震惊，因为他们平时只负责非常具体的一小块，但当你放大视角，你会感到这种体验是压倒性的。现在，我们有一个真正的机会来“折叠”这个技术栈，回归匠心，重新思考产品开发生命周期，这就是“全栈构建者模型”诞生的背景。

---

### [00:09:47] Lenny Rachitsky

**English:**
Wow. Okay. And there's so much here. We're going to be showing the visuals as you talk to help people see what you're explaining here. And all of this is very rational. If you have 15 sources of information, why not pull from it? Why miss out on that stuff? And what you're describing here is as you get more power and more specialized... It all makes sense rationally, but when you start to step back and look at this like, holy shit, it takes six months to launch one feature. I want to ask about the stat you shared. I think this is an incredibly powerful stat and you have very unique data here to tell you this sort of stuff. So you said that something like 70% of the skills that people will need in the future are going to change.

**中文翻译:**
哇，信息量很大。在你说话的时候，我们会展示一些视觉图表，帮助大家理解。这一切听起来都很合理：如果有 15 个信息源，为什么不利用呢？为什么要错过那些信息？你描述的是随着能力增强和专业化加深……从理性上讲都说得通，但当你退后一步看，会发现：“天哪，发布一个功能竟然要六个月。”我想问问你分享的那个数据。我觉得这是一个非常有力量的数据，而且你有独特的数据源来支撑。你说到 2030 年，人们未来所需的技能约有 70% 会发生变化。

---

### [00:10:28] Tomer Cohen

**English:**
To do their current job.

**中文翻译:**
是完成他们“当前”工作所需的技能。

---

### [00:10:29] Lenny Rachitsky

**English:**
To do their current job. And what is this looking at? Is this just based on historical data or how do you find that?

**中文翻译:**
完成当前工作。这是基于什么的观察？是基于历史数据，还是你们如何发现这一点的？

---

### [00:10:36] Tomer Cohen

**English:**
Yeah. To be fair, there was always a change, right? So it was never about just keep the skills you have today, but we've never seen such a dramatic part of your role today. So whether you are a marketer right now or a seller, a recruiter, an engineer. Engineering is where a lot of the investment is going in right now in terms of agents. Those jobs will change dramatically. I remember I said my role, my life as an engineer and even then it's changed materially after 10 years, and then the change we're seeing right now, just thinking about in four years, what did it take to actually engineer really, really well would be dramatically different, or to build software, to build an artifact of some sort. But it's true for almost every function. It's not equal. Some job like nurses will see less impact, but some jobs will see 90%, 95% impact.

**中文翻译:**
是的。公平地说，变化一直存在，对吧？从来不是说只守着今天的技能就行。但我们从未见过对当前角色如此剧烈的影响。无论你现在是营销人员、销售、招聘人员还是工程师。工程领域目前是智能体（agents）投资最集中的地方。这些工作将发生翻天覆地的变化。我记得我作为工程师的职业生涯，即便在当时，10 年后也发生了实质性的变化。而我们现在看到的这种变化，想想四年后，要成为一名极其优秀的工程师，或者构建软件、构建某种产出物，所需的条件将大不相同。这几乎适用于所有职能，虽然程度不一。像护士这样的工作受影响较小，但有些工作受影响程度会达到 90% 甚至 95%。

---

### [00:11:28] Lenny Rachitsky

**English:**
There's also a stat that I don't think you mentioned here that I saw on the post when you first talked about this program is that 70% of today's fastest growing jobs were not even on the list of jobs a year ago.

**中文翻译:**
还有一个数据你刚才没提到，但我看到你在最初谈论这个计划的帖子中写过：当今增长最快的职位中，有 70% 在一年前甚至都不在职位列表上。

---

### [00:11:39] Tomer Cohen

**English:**
Yeah. No, so this is the fastest growing job on the list were not there a year ago, and then many of them don't even exist a decade or two ago. There's actually some pretty amazing stats across the board.

**中文翻译:**
没错。列表上增长最快的职位一年前还不存在，其中许多在十年前或二十年前甚至根本没有。各方面都有一些非常惊人的统计数据。

---

### [00:11:52] Lenny Rachitsky

**English:**
Okay. So let's talk about this program that you built. Tell us the name and then tell us the gist of what it is today and the vision of where you want it to be.

**中文翻译:**
好，那我们来聊聊你建立的这个计划。告诉我们它的名字，以及它目前的要点和你对它未来的愿景。

---

### [00:12:03] Tomer Cohen

**English:**
Yeah. So we call it the full stack builder model. And the goal, always start with the goal. The goal itself is to empower great builders to take their idea and to take it to market, regardless of their role and the stack and specifically which team they're on. And the idea ultimately is to be able for that builder is to develop experiences end to end, to combine skills and expertise across what was traditionally distinct domains to bring it all together. And it's not a sequence of steps. It's really a fluid interaction between human and machine. That's how the way I see it. And then when you look back at that product development life cycle from the idea, the insight all the way to launch, the key trait that I'm emphasizing for builders is where I want them to spend their time is where I think great builders should shine in.
(00:12:54): So the idea of vision. Coming up with a compelling sense about the future. Empathy, super critical, right? Having a profound understanding of an unmet need. Communication is critical. And we see this a lot in job descriptions right now for almost every role, but ability for you to align and rally others around an idea. Creativity, which for me is about coming up with possibilities beyond the obvious. For example, I don't think AI yet is great at creativity. I think it's kind of, in many ways, brings back the things you might not know about, but it's not the kind of next level creativity, which I think still humans are much better at.
(00:13:33): And then ultimately what I think is the most important trait for a builder is judgment. Some people call it test making, but it's making high quality decisions in what is complex ambiguous situations. Everything else, I'm working really hard to automate. Really, really hard. And then when you think about the outcome, it's not just about having more shots at the goal, which I think people go like, "Oh, the iteration speed is going to be very high." Yes, but what you're really doing to an organization of at scale organizations is they're a lot more nimble, a lot more adaptive, a lot more resilient. They can navigate the future. They can actually match the pace of change to the pace of response.
(00:14:13): And an analogy I have in mind is kind of Navy SEALs. You come to training, they're all kind of learning, they're cross-trained, across multiple areas. What they specialize in is the mission and they operate in small pods and they're very nimble and you can assemble them very quickly. And I think that's going to be the organization that will win in the future.

**中文翻译:**
好的。我们称之为“全栈构建者模型（full stack builder model）”。目标，永远要从目标开始。目标本身是赋能优秀的构建者，让他们能把想法推向市场，无论其角色、技术栈或所属团队。最终的设想是，构建者能够端到端地开发体验，将传统上属于不同领域的技能和专业知识融合在一起。这不是一系列死板的步骤，而是人与机器之间流动的交互。这就是我的看法。回顾从创意、洞察到发布的整个产品开发生命周期，我强调的构建者关键特质，也就是我希望他们投入时间的地方，正是优秀构建者应该发光发热的地方：
首先是“愿景（Vision）”：对未来有令人信服的感知。其次是“同理心（Empathy）”：这至关重要，对未满足的需求有深刻理解。然后是“沟通（Communication）”：这很关键，现在几乎所有职位的描述中都能看到，即围绕一个想法对齐并号召他人的能力。接着是“创造力（Creativity）”：对我来说，这意味着想出超越显而易见之物的可能性。例如，我不认为 AI 目前在创造力方面表现出色。它在很多方面能找回你可能不知道的信息，但它不是那种更高层次的创造力，我认为人类在这方面仍然更胜一筹。
最后，我认为构建者最重要的特质是“判断力（Judgment）”。有些人称之为“品味决策（taste making）”，即在复杂模糊的情况下做出高质量决策的能力。除了这五点，我正在努力实现其他所有环节的自动化。非常努力。当你思考结果时，这不仅仅是增加“射门次数”（虽然人们会觉得迭代速度会变快），更重要的是，对于规模化组织来说，这让他们变得更加敏捷、更具适应性和韧性。他们可以驾驭未来，让响应速度跟上变化的速度。
我脑海中的一个类比是“海豹突击队（Navy SEALs）”。你参加训练，大家都在学习，接受跨领域培训。他们专精的是“任务”，以小分队（pods）的形式运作，非常灵活，可以快速组建。我认为这就是未来能够胜出的组织形式。

---

### [00:14:33] Lenny Rachitsky

**English:**
Okay. So the simple idea, if you're just to boil it down to a sentence, the idea here is there's a builder who goes through the entire product development process essentially on their own. They have an idea, they research, they do data, they prototype design ship. That's kind of like the vision of where this goes?

**中文翻译:**
好。如果用一句话概括，这个理念就是：一个构建者基本上独立完成整个产品开发过程。他们有想法，做研究，处理数据，制作原型，设计并发布。这就是未来的愿景吗？

---

### [00:14:50] Tomer Cohen

**English:**
Yes, but it doesn't have to be on their own. It's not like... I still believe in teams.

**中文翻译:**
是的，但不一定非要单打独斗。我仍然相信团队的力量。

---

### [00:14:51] Lenny Rachitsky

**English:**
Got it. So smaller teams.

**中文翻译:**
明白了，是更小的团队。

---

### [00:14:55] Tomer Cohen

**English:**
Just smaller teams. Smaller teams and much more focused on the problem, the mission, per say, versus... Actually, one of the things we've done as an example, we started to do the idea of pods. We're no longer large teams. We assemble a team, ideally a full stack builders coming together and it's less about can I have an engineer design PM working together and trying to combine this trio looking at folks who can flex across and then they tackle something for a quarter or so and then we reassemble those two different pods. That's one example of an manifestation we're doing right now and seeing actually some great success in both in terms of velocity, but also in terms of that focus and nimbleness of that team.

**中文翻译:**
就是更小的团队。更小的团队，更专注于问题和任务本身，而不是……实际上，我们做的一件事就是引入“小分队（pods）”的概念。我们不再组建大团队。我们组建一个团队，理想情况下是由全栈构建者组成的。这不再仅仅是让一个工程师、一个设计师和一个产品经理（PM）组成“铁三角”，而是寻找能够跨职能灵活运作的人。他们针对某个项目攻关一个季度左右，然后我们再重新组合成不同的小分队。这是我们目前实践的一个例子，在速度、专注度和团队灵活性方面都取得了巨大的成功。

---

### [00:15:37] Lenny Rachitsky

**English:**
And it feels like the goal here, what you're trying to adjust and that broke as teams bloated as speed and adaptability and flexibility, because going back to your original point that change is happening so much more quickly now that companies that have been building in this traditional way just can't compete.

**中文翻译:**
感觉这里的目标是修复那些因团队臃肿而丧失的速度、适应性和灵活性。回到你最初的观点，现在的变化发生得太快了，以传统方式构建产品的公司根本无法竞争。

---

### [00:15:56] Tomer Cohen

**English:**
Yeah. It's not that you have to break the model. I think the model is broken. It's just this pace of change is helping us realize it.

**中文翻译:**
是的。不是说你必须打破这个模型，我认为这个模型本身已经坏了。只是现在的变化速度让我们意识到了这一点。

---

### [00:16:03] Lenny Rachitsky

**English:**
Okay. So then going back to the things that these builders still do versus what you want to automate. So the list you shared is they're responsible for the vision, empathy, communication, creativity, and judgment.

**中文翻译:**
好。回到构建者仍然需要做的事情与你想要自动化的事情。你列出的清单是：他们负责愿景、同理心、沟通、创造力和判断力。

---

### [00:16:16] Tomer Cohen

**English:**
Yes. Yeah. And I would put a lot of the focus on the latter. I think if you ask me at the end of the day, what's the kind of most important trait? I would say it's that judgment, test making ability.

**中文翻译:**
是的。我会把重点放在最后一项。如果你问我最终最重要的特质是什么，我会说是判断力，即品味决策的能力。

---

### [00:16:27] Lenny Rachitsky

**English:**
And then in terms of what you're automating, what are some of the areas you've seen a lot of success in actually automating and where do you think this goes?

**中文翻译:**
那么在自动化方面，你在哪些领域看到了显著的成功？你认为未来的发展方向在哪里？

---

### [00:16:35] Tomer Cohen

**English:**
Yeah. So I think just to kind of break it to pieces, and I think this is... If you were a startup right now, in many ways you can start this way. There's no legacy code, there's no legacy structure you run. And in fact, a lot of the startups I talked to that are built AI natively, they're just working at full stack builders. That's the way they start. If you're at a company at a scale of ours and many others in the market, you're like, this is almost like a new production function and mindset that you have to do. And there's really three components that we're working on. One is platform. The second one is the tools and the agents. And lastly is the culture.
(00:17:17): The platform one, this is the kind of level of investment you have to do before, before this actually starts, you start to see all the benefits accrue. But the platform for us as an example is rearchitecting all of our core platforms so AI can reason over it. So we're building kind of this composable UI components with server side that we actually build. We're basically building for AI to be ready to bring it in. So you can't just go and bring a third party tool and have it work on the LinkedIn stack. In fact, that's one of our biggest learnings. It never works. Never works. You have to bring it in and customize a lot of it, working almost in alpha mode with those companies to make it work internally.

**中文翻译:**
好的。为了拆解来看，我认为……如果你现在是一家初创公司，在很多方面你可以直接这样开始。没有遗留代码，没有遗留的组织结构。事实上，我聊过的很多 AI 原生初创公司，他们本身就是以全栈构建者的模式在工作。这就是他们的起点。但如果你在像我们这样规模的公司，或者市场上许多其他大公司，这几乎就像是你必须建立的一种新的生产职能和思维方式。我们正在推进的组件主要有三个：一是平台（Platform），二是工具和智能体（Tools and Agents），三是文化（Culture）。
关于平台，这是你必须预先投入的，只有这样你才能看到收益的累积。对我们来说，平台的一个例子是重新架构我们所有的核心平台，以便 AI 能够对其进行推理（reason over it）。所以我们正在构建这种带有服务器端支持的可组合 UI 组件。我们基本上是在为 AI 的接入做准备。你不能直接拿一个第三方工具就让它在 LinkedIn 的技术栈上运行。事实上，这是我们最大的教训之一：直接拿来用行不通，永远行不通。你必须引入它并进行大量定制，几乎是以 Alpha 模式与那些公司合作，才能让它在内部跑通。

---

### [00:17:59] Lenny Rachitsky

**English:**
So this is essentially re-architecting your code base to work more efficiently with AI. Is that one way to think about it?

**中文翻译:**
所以这本质上是重新架构你的代码库，以便更高效地与 AI 协作。可以这样理解吗？

---

### [00:18:04] Tomer Cohen

**English:**
Yes. And in many ways, working with those companies to adjust something in their stack to work with our stack as well.

**中文翻译:**
是的。而且在很多方面，要与那些公司合作，调整他们技术栈中的某些部分，以适配我们的技术栈。

---

### [00:18:12] Lenny Rachitsky

**English:**
When you say those companies, meaning the development agents like Cursors and [inaudible 00:18:16] and such?

**中文翻译:**
你说的“那些公司”，是指像 Cursor 这样的开发智能体公司吗？

---

### [00:18:16] Tomer Cohen

**English:**
Yes. Or Figma on design. Or you can think about design systems is another example of that. But you have to have that back and forth because they're not... In many ways, we haven't seen anybody be able to work off the shelf immediately on our code-based design systems and unique context we have.

**中文翻译:**
是的。或者是设计领域的 Figma。你也可以把设计系统（design systems）看作另一个例子。你必须进行这种反复的沟通，因为在很多方面，我们还没见过有谁能直接在我们的代码库、设计系统和独特的业务语境下开箱即用。

---

### [00:18:34] Lenny Rachitsky

**English:**
Just to follow that thread briefly, so there's Figma. That's interesting. So basically the way Figma exports and keeps your design system, that has to change to work better with AI is what I'm hearing.

**中文翻译:**
顺着这个话题聊一下，Figma 很有意思。所以我听到的是，Figma 导出和维护设计系统的方式必须改变，才能更好地与 AI 协作。

---

### [00:18:41] Tomer Cohen

**English:**
They first need to know how to work with our design systems, which is something, in many ways a lot of those companies are working on. Same with coding. It doesn't work that you just bring it in and it just reasons over your code base really well. We tried. We are building that layer that basically allows it to do so, whether it's Copilot or Cursor, Windsurf and so on.

**中文翻译:**
他们首先需要知道如何与我们的设计系统协作，这正是许多公司正在努力的方向。编程也是一样。你不能直接把它拿进来，就指望它能很好地推理你的代码库。我们尝试过。我们正在构建一个中间层，基本上让它能够做到这一点，无论是 Copilot、Cursor 还是 Windsurf 等等。

---

### [00:19:02] Lenny Rachitsky

**English:**
Got it. Oh yeah, Copilot. Microsoft. I get it. I get it. Okay. Okay. So that's the platform. So that's an investment that you guys have to make to make AI effective at building and doing all these things.

**中文翻译:**
明白了。哦对，Copilot，微软。我懂了。好，这就是平台。这是你们为了让 AI 在构建和执行这些任务时发挥效力而必须做的投入。

---

### [00:19:17] Tomer Cohen

**English:**
And then you have tools. So tools is where you really build the agents. I mentioned I want to automate everything outside of those five trades that we talked about, and then we're building the tools for that. And then for that, actually very similarly, I can't just bring a tool from the outside and work. So I'll give you an example. One of our biggest things is building a trust agent. Trust is really important for us at LinkedIn. There's a lot of unique vectors which trust plays at LinkedIn doesn't place it anywhere else. So we need to bring all of that know how and context and information base into that agent. So we ended up building our own trust agent at LinkedIn.

**中文翻译:**
然后是工具。工具是你真正构建智能体的地方。我提到过，我想把那五项特质之外的所有事情都自动化，我们正在为此构建工具。同样地，我不能直接从外部引入一个工具就用。举个例子：我们最重要的一项工作是构建“信任智能体（trust agent）”。信任对 LinkedIn 来说至关重要。LinkedIn 的信任维度非常独特，与其他地方不同。因此，我们需要将所有的专业知识、语境和信息库都注入到这个智能体中。所以我们最终在 LinkedIn 内部构建了自己的信任智能体。

---

### [00:19:53] Lenny Rachitsky

**English:**
And so what is this trust agent doing? Telling you when you're maybe exposing information that you shouldn't be?

**中文翻译:**
那么这个信任智能体具体做什么？是提醒你是否泄露了不该泄露的信息吗？

---

### [00:19:58] Tomer Cohen

**English:**
So when you build a spec, you build an idea, you walk through the trust agent and it'll basically tell you what are your vulnerabilities, what harm vectors potentially you're introducing or will be introduced as a result of that. And I had our head of trust build it. So the head of craft for every area is building their own agent. As an example, we have one of our features for job seekers is called Open to Work. If you're looking for a job, you can put an open to work.

**中文翻译:**
当你编写规格说明或构思一个想法时，你会通过信任智能体运行一遍，它会告诉你存在哪些漏洞，或者你可能引入了哪些潜在的危害向量（harm vectors）。我是让我们的信任部门负责人来构建它的。也就是说，每个领域的专业负责人都在构建他们自己的智能体。举个例子，我们有一个针对求职者的功能叫“Open to Work”。如果你正在找工作，你可以设置这个状态。

---

### [00:20:24] Lenny Rachitsky

**English:**
Yeah, a little green loading thing on the circle.

**中文翻译:**
是的，头像圆圈上那个绿色的小标志。

---

### [00:20:25] Tomer Cohen

**English:**
Exactly. And actually it's a great signal. I've seen some great success from it. People are helping each other. The community really thrives around helping each other. But at the same time, it introduces a trust vector for bad actors because they're open to work. People who are looking for a job are potentially more vulnerable to scams than other folks. So being able to think about how do we prevent all of those ahead of time. So we walked that spec from a couple of years ago through the trust agent. Not only was it able to find all the stuff we initiated at the beginning, but all the holes that we did not catch until later. So that's a great example of something that actually worked really well.
(00:21:03): That's one. The other one is a growth agent, as an example. Again, LinkedIn has a very unique... Actually, we have an incredible growth team, growth process. We've kind of funneled all of our unique loops, our funnels, our tests of the past, everything into this growth agent, and now you can basically rock your respect for it, your idea for it. And it would not just allow you to do it better. It would actually critique how good is your idea. This is something you cannot bring off the shelf. It's very unique to LinkedIn. So we had to invest dramatically in it. And one team which is using it right now, which is almost... I wasn't thinking about it at the beginning, but our UXR team, our UER team, the user research team is usually using that growth agent to understand out of all the things that are basically surfacing for members, which one has the biggest growth opportunity to have the biggest impact? That was not in the cards when we thought about that idea, but teams are basically funneling those ideas into this one.
(00:22:05): An example is our research agent. So research agent basically is trained on the personas of our members. You can think about a small business owner, a job seeker and so on. And it's using not just world knowledge, it's using all the research we've done in the past, all the support tickets coming in. So it's pretty good at understanding that persona at LinkedIn. So one examples we had is a team came out with a spec. They weren't aware we had the research agent yet. I asked the research agent for a small business owner, wanted to think about the marketing spec we had, and it critiqued it extremely well. Actually, in many ways shifted the direction of the team to focus on other integrations tools we can focus on, but it's very hard to have that visibility all to all that corpus of knowledge inside of the company.
(00:22:56): That's another example. We have an analyst agent trained on all how you basically can query the entire LinkedIn graph, which is enormous. And instead of relying on your SQL queries or data science teams, you can use the analyst agent. All of those I would say are, I would call them still MVP+. The goal for us in the next couple of months to basically roll them out externally. Externally, I mean, internally at LinkedIn.

**中文翻译:**
没错。这其实是一个很好的信号，我看到了它带来的巨大成功。人们互相帮助，社区因互助而繁荣。但与此同时，它也为不法分子引入了一个信任风险点，因为这些人处于“找工作”状态。找工作的人可能比其他人更容易受到诈骗。所以我们要思考如何提前预防。我们将几年前的那个功能规格说明通过信任智能体跑了一遍，它不仅找到了我们最初发现的所有问题，还发现了我们直到很晚才察觉的漏洞。这是一个非常成功的例子。
这是其一。另一个例子是“增长智能体（growth agent）”。LinkedIn 有非常独特的……实际上我们有一支不可思议的增长团队和流程。我们将所有独特的循环（loops）、漏斗、过去的测试，所有东西都注入了这个增长智能体。现在你可以把你的想法交给它，它不仅能帮你做得更好，还会批判你的想法有多好。这是你无法从市面上买到的，它对 LinkedIn 来说非常独特，所以我们必须投入巨资。目前有一个团队正在使用它，这甚至超出了我最初的预想：我们的用户体验研究（UXR）团队正在使用增长智能体来分析，在所有呈现给会员的功能中，哪一个具有最大的增长潜力并能产生最大影响。这在最初构思时并没考虑到，但团队现在正把想法汇聚到这里。
还有一个例子是“研究智能体（research agent）”。它基本上是基于我们会员的角色（personas）进行训练的，比如小企业主、求职者等。它不仅利用世界知识，还利用我们过去做的所有研究、所有的客服工单。所以它非常了解 LinkedIn 的用户画像。有一个例子：一个团队拿出了一个规格说明，他们当时还不知道有研究智能体。我让研究智能体以小企业主的身份去审视那个营销方案，它给出了极其出色的批判。实际上，它在很多方面改变了团队的方向，让他们转而关注其他集成工具。在公司内部，个人很难拥有对如此庞大知识库的全局视野。
再举个例子，我们有一个“分析师智能体（analyst agent）”，它经过训练，知道如何查询整个 LinkedIn 的图谱（graph），那是海量的数据。你不再需要依赖 SQL 查询或数据科学团队，可以直接使用分析师智能体。我会说所有这些目前还处于“MVP+”阶段。我们未来几个月的目标是把它们推向“外部”——我指的是在 LinkedIn 内部全面推广。

---

### [00:23:20] Lenny Rachitsky

**English:**
Not as new product lines.

**中文翻译:**
不是作为新的产品线发布。

---

### [00:23:22] Tomer Cohen

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:23:22] Lenny Rachitsky

**English:**
Okay. So many questions. One is just how are you building this? Is there a platform you're using? What does it take to build an agent at LinkedIn? Is it all internal tools or is there third party use?

**中文翻译:**
好，我有很多问题。一个是，你们是怎么构建这些的？使用了什么平台吗？在 LinkedIn 构建一个智能体需要什么？全是内部工具，还是使用了第三方服务？

---

### [00:23:31] Tomer Cohen

**English:**
It's a great call. So I think we've been experimenting with a lot of tools. And I would say for a lot of those kind of knowledge corpus agents, we're using everything from Copilot Enterprise to ChatGPT Enterprise. By far though, the most important part was basically our own customization of it. That's been where we saw the biggest gains. Even building the orchestrator across those because you want the agents to start following to each other, the trust agent should work with the growth agent and go do a back and forth versus doing what more sequentially. So we've done a lot of work internally to make it happen. This is why I think it does require that level of investment.
(00:24:09): And then in some cases, let's talk about the design agent that we're working with. We're working with multiple companies to try and understand which product works best for us. Interestingly enough, and this is another learning, different teams gravitate to different products. So that's something we'll have to resolve and think about how we do this really well, because ultimately we were trying to simplify the process as much as possible, but that was a big learning for us and which tools we use and how we basically integrate them in.

**中文翻译:**
问得好。我们一直在尝试很多工具。对于那些知识库类型的智能体，我们使用了从 Copilot 企业版到 ChatGPT 企业版的所有工具。但到目前为止，最重要的部分基本上是我们自己的定制化。这是我们看到收益最大的地方。甚至包括构建跨智能体的“编排器（orchestrator）”，因为你希望智能体之间能互相协作——信任智能体应该与增长智能体配合，进行反复沟通，而不是简单的线性执行。我们在内部做了大量工作来实现这一点。这就是为什么我认为这需要相当程度的投入。
在某些情况下，比如我们正在开发的“设计智能体”，我们正与多家公司合作，试图了解哪种产品最适合我们。有趣的是（这也是另一个教训），不同的团队倾向于不同的产品。这是我们需要解决的问题，要思考如何做好，因为最终我们是想尽可能简化流程。但在选择哪些工具以及如何集成它们方面，我们学到了很多。

---

### [00:24:39] Lenny Rachitsky

**English:**
Got it. So you might have an amazing Figma agent, but some teams want to use a different design tool.

**中文翻译:**
明白了。所以你可能有一个很棒的 Figma 智能体，但有些团队想用不同的设计工具。

---

### [00:24:44] Tomer Cohen

**English:**
Yeah. So we've kind of experimented with Figma and Subframe and Magic Patterns and so on, and we saw people gravitating depending on the function, their level of visibility, their know how of the tool before, they're gravitating to different tools. And ultimately, I don't want to have eight design agents in the company, so we have to converge into at least a few. And I think it's similar across many areas because the appeal of those, a lot of those agents are trying to solve similar end goal, but they're doing it very differently. And what you'll see that ultimately, I don't think there's going to be a winner takes all because the starting point of the customer or the user will dictate a lot how simple they are for that use case.

**中文翻译:**
是的。我们尝试了 Figma, Subframe, Magic Patterns 等等。我们发现人们会根据职能、对工具的熟悉程度以及之前的经验而倾向于不同的工具。最终，我不希望公司里有八个设计智能体，所以我们必须收敛到少数几个。我认为很多领域都是如此，因为这些智能体大多试图解决相似的最终目标，但实现方式迥异。你会发现，最终可能不会出现“赢家通吃”的局面，因为用户的使用起点在很大程度上决定了该工具在特定场景下的易用性。

---

### [00:25:28] Lenny Rachitsky

**English:**
Super interesting. The other interesting takeaway here is you're designing very specific agents that are one job to be done. Is that a very intentional decision? Did you try an agent that just is super intelligent on all these things?

**中文翻译:**
非常有意思。另一个有趣的发现是，你正在设计非常具体的、针对单一任务（one job to be done）的智能体。这是刻意为之的决定吗？你有没有尝试过一个在所有这些方面都超级智能的通用智能体？

---

### [00:25:41] Tomer Cohen

**English:**
Ultimately, they will do an orchestrator. We're going to really orchestrator across, but we did want to be able to rate and grade those agents really well on how they're doing. And I think there is a level of expertise. Now, we're kind of building this in a way where we'll be able to mask a lot of those. You might not know that there's a trust agent. You might have, we call this internally the product jammer agent that basically does your product jam, which is a process we do internally. You might just use the product jam engine, and that product jam agent will work with all the other agents. But now we're starting with that building blocks until we build the orchestrating layer across.

**中文翻译:**
最终，它们会通过一个编排器来运作。我们会实现跨领域的编排，但我们确实希望能够很好地评估和分级这些智能体在各自领域的表现。我认为这涉及专业深度。现在，我们正在以一种可以“掩盖”这些细节的方式来构建。你可能不知道背后有一个信任智能体。你可能只是在使用我们内部称为“产品头脑风暴智能体（product jammer agent）”的东西，它负责处理我们内部的“产品头脑风暴”流程。你只需使用这个引擎，它就会自动与其他所有智能体协作。但目前我们是从这些基础模块开始的，直到我们构建出完整的编排层。

---

### [00:26:20] Lenny Rachitsky

**English:**
Another interesting takeaway from what you've been sharing is that so much of the work has gone into the beginning of the product development process, just like helping you craft the right requirements, clarify trust, and then here's product jam and here's the research we've done. And I imagine it's because coding has already been accelerated with all these IEE tools. Talk about just why that's maybe where most of the investment's gone and where you've seen the most impact so far.

**中文翻译:**
从你的分享中得到的另一个有趣结论是，大量的工作都投入到了产品开发过程的“前端”，比如帮助制定正确的决策需求、明确信任问题、进行产品头脑风暴和研究。我猜这是因为编码环节已经通过各种 IDE 工具得到了加速。能谈谈为什么大部分投资都投向了前端，以及到目前为止你在哪里看到了最大的影响吗？

---

### [00:26:43] Tomer Cohen

**English:**
Well, 100% our coding investment has gone, started a while back, and those are fall into place. We have our coding agent. In fact, we've kind of staged it into two parts of it. There is the idea to design part, and then let's call it the code to launch part. The code to launch part has gotten a lot of attention and we're making some big inroads there. Everything from the coding agent to what we call the maintenance agent when you have a failed build, it will do it for you. In fact, I think we're close to 50% of all those builds being done by the maintenance agent and a QA agent.

**中文翻译:**
没错，我们对编码的投入 100% 是从很久以前就开始的，现在已经步入正轨。我们有自己的编码智能体。事实上，我们把它分成了两个阶段：一个是“从创意到设计”阶段，另一个是“从代码到发布”阶段。“从代码到发布”阶段已经得到了很多关注，我们取得了重大进展。从编码智能体到我们所谓的“维护智能体（maintenance agent）”——当构建失败时，它会自动为你修复。事实上，我认为目前接近 50% 的构建工作是由维护智能体和 QA 智能体完成的。

---

### [00:27:19] Lenny Rachitsky

**English:**
Wow. So this is when a break builds instead of engineers hopping on the issues that an agent fix.

**中文翻译:**
哇。所以当构建出错时，不再需要工程师亲自去排查，而是由智能体来修复。

---

### [00:27:24] Tomer Cohen

**English:**
You can still go and finish your coffee before you have to go and redo the build again.

**中文翻译:**
你甚至可以先喝完咖啡，然后再回来重新构建。

---

### [00:27:27] Lenny Rachitsky

**English:**
Extremely cool.

**中文翻译:**
太酷了。

---

### [00:27:28] Tomer Cohen

**English:**
But we haven't had much investment until we kind of launched this program in the idea to design area. And that's a material part of work. It's also where the quality a lot of the work comes from, at least before you start to go into the coding phase. The idea is to empower everybody. So if you're an engineer, you can basically use all those tools at the front of the process and be able to be a full stack builder.

**中文翻译:**
但在启动这个计划之前，我们在“从创意到设计”领域的投入并不多。而这正是工作的实质部分，也是决定工作质量的关键，至少在进入编码阶段之前是这样。我们的想法是赋能每一个人。所以如果你是一名工程师，你基本上可以使用流程前端的所有这些工具，从而成为一名全栈构建者。

---

### [00:27:51] Lenny Rachitsky

**English:**
How long did it take to get this kind of in place for you to actually form your first team to build these, the initial agents and some of this backend, redo the code base sort of thing?

**中文翻译:**
为了让这一切就绪，从组建第一支团队来构建这些初始智能体、后端以及重做代码库之类的工作，花了多长时间？

---

### [00:27:59] Tomer Cohen

**English:**
I announced this internally end of last year, we really kind of started working, but it was more setting up the teams and the processes internally. We had our first MVPs of those agents I think like four to five months after it was really trained, I would say. But really the work itself has been kind of couple of months of dedicated work. A lot of it has been getting all the corpus of data together, cleaning it up. And that's actually a good learning as well. It's not great to just give it access to your drive and say, "Reason all over this knowledge base." It actually does a very poor job understanding importance of the past and putting weights on stuff. You actually want to think about specifically what the context when do you want to give it to and what's the knowledge base that you want to have it focused on. So even cleaning up, let's call them gold examples or golden examples to learn from, has been one of the biggest learnings. Just reasoning over your entire knowledge base did not work.

**中文翻译:**
我是去年年底在内部宣布的，然后真正开始投入工作，但更多是建立内部团队和流程。我想在经过真正的训练后，大约四到五个月我们就拿出了这些智能体的第一个 MVP。但真正的核心工作是几个月的专注投入。其中很大一部分是收集所有数据语料库并进行清理。这其实也是一个很好的教训：仅仅给它访问你云端硬盘的权限并说“去推理这个知识库吧”是不行的。它在理解过去信息的重要性以及分配权重方面表现得很差。你必须仔细思考要给它什么样的语境，以及你希望它专注于哪个知识库。所以，即使是清理出所谓的“黄金示例（golden examples）”供其学习，也是最大的收获之一。仅仅对整个知识库进行推理是行不通的。

---

### [00:28:54] Lenny Rachitsky

**English:**
Yeah, that makes sense. There may be just like a researcher with a strong opinion about something that you disagree with and it wouldn't know. It's like, oh, of course, this is data, this is fact.

**中文翻译:**
是的，有道理。可能某个研究员对某件事有很强的个人观点，而你并不同意，但 AI 无法分辨。它会觉得：“哦，当然，这是数据，这是事实。”

---

### [00:29:03] Tomer Cohen

**English:**
Exactly. And then it doesn't always understand ties to original specs to success. You have to actually build... This is a really interesting way. When you think about how you bring those tools in, you can't just bring them in. You have to know what you feed them with. And what you feed them with is not just access. I see a lot to just focus on the connectivity and integration and it reminds me of the... This is almost like, this is actually more than 10 years ago when I was co-rebuilding the team, co-rebuilding the feed at LinkedIn and we started from scratch and I had to literally sit down and filter through examples of what is a good professional post on LinkedIn and what is not. And this was like weeks of work getting up that golden sample of examples, but it wasn't... The most important part was feeding at the right data, not all the data.
(00:29:57): So it requires work. This is where I would say for many companies who are thinking about this phase, and I do a lot of sessions today with CPOs and COs on this process. You have to put this initial work to get the gains after. When I think about it, I think there's a takeaway there in generally with AI, even if you're learning it for the first time and so on, whether it's Cursor or whether it's design, if it's Figma or other tools or Lovable, you should be ready to invest those hours before you start seeing yourself pick up in velocity and quality, which will come up, but you have to invest that time.

**中文翻译:**
没错。而且它并不总能理解原始规格说明与最终成功之间的联系。你必须构建……这是一种非常有趣的方式。当你思考如何引入这些工具时，你不能只是把它们拿进来。你必须知道喂给它们什么。喂给它们的不只是“访问权限”。我看到很多人只关注连接性和集成，这让我想起……这几乎就像是 10 多年前，当我共同重建 LinkedIn 的 Feed 团队和 Feed 流时，我们从零开始，我不得不亲自坐下来，筛选什么是 LinkedIn 上的优质专业帖子，什么不是。那是长达数周的工作，为了建立那套“黄金样本”。最关键的部分是喂给它“正确”的数据，而不是“所有”的数据。
所以这需要下功夫。对于许多正在考虑这个阶段的公司（我目前经常与 CPO 和 COO 们就此进行交流），我想说：你必须先投入这些初始工作，才能在以后获得收益。我认为这在 AI 领域是一个普遍的教训，即使你是第一次学习使用 Cursor、Figma 或 Lovable 等工具，你也应该准备好先投入这些时间，然后才能看到速度和质量的提升。提升一定会到来，但你必须先投入时间。

---

### [00:30:35] Lenny Rachitsky (Sponsorships)

**English:**
This episode is brought to you by Miro. Every day, new headlines are scaring us about all the ways that AI is coming for our jobs, creating a lot of anxiety and fear. But a recent survey for Miro tells a different story. 76% of people believe that AI can benefit their role, but over 50% of people struggle to know when to use it. Enter Miro's innovation workspace, an intelligent platform that brings people and AI together in a shared space to get great work done. Miro has been empowering teams to transform bold ideas into the next big thing for over a decade. Today, they're at the forefront of bringing products to market even faster by unleashing the combined power of AI and human potential. Guests of this podcast often share Miro templates. I use it all the time to brainstorm ideas with my team. Teams especially can work with Miro AI to turn to unstructured data like sticky notes or screenshots into usable diagrams, product briefs, data tables, and prototypes in minutes. You don't have to be an AI master or to toggle yet another tool. The work you're already doing in Miro's Canvas is the prompt. Help your teams get great work done with Miro. Check it out at miro.com/lenny. That's M-I-R-O.com/lenny.

**中文翻译:**
本集节目由 Miro 赞助。每天，新的头条新闻都在恐吓我们 AI 将如何取代我们的工作，制造了大量的焦虑和恐惧。但 Miro 最近的一项调查显示了不同的情况：76% 的人相信 AI 能使他们的角色受益，但超过 50% 的人不知道何时该使用它。欢迎使用 Miro 的创新工作空间，这是一个将人类与 AI 聚集在共享空间中以完成出色工作的智能平台。十多年来，Miro 一直在赋能团队将大胆的想法转化为下一个大事件。今天，他们通过释放 AI 与人类潜力的结合力量，走在让产品更快推向市场的最前沿。本播客的嘉宾经常分享 Miro 模板。我也一直用它和团队一起头脑风暴。团队特别可以利用 Miro AI，在几分钟内将便签或截图等非结构化数据转化为可用的图表、产品简报、数据表和原型。你不需要成为 AI 大师，也不需要切换到另一个工具。你在 Miro 画布上已经进行的工作就是提示词。使用 Miro 帮助你的团队完成出色工作。请访问 miro.com/lenny 查看。

---

### [00:31:46] Lenny Rachitsky

**English:**
What's the current state of the pilot? How large is it? How many teams are doing it? What kind of stuff have you shipped? Just give us a sense of today's world.

**中文翻译:**
试点的现状如何？规模有多大？有多少团队在参与？你们已经发布了什么东西？请让我们了解一下现状。

---

### [00:31:54] Tomer Cohen

**English:**
Yeah. I wouldn't say we are yet at a very high sample rate where it's kind of a high percentage of the organization, but we have a substantial part of the organization already using it to provide a lot of the feedback. We're seeing a lot of great examples. So the way I think about the benefits is a function of experimentation volume multiplied by quality. How good are those experiments divided by the time it takes to actually pull them out, like idea to launch. On saving times, we're seeing, whether it's PMs, designers, engineers, saving hours of work a week right now, whether it's the analyst agent we talked about or the prototyping really quickly or the product jamming experience has been a big part of that. On the quality side, we're seeing insights discussions just be much, much better. And by the way, quality and time, sometimes they help each other because it's high quality, you don't have to spend as much time on something.
(00:32:52): So we are seeing that applied in. And the volume, I wouldn't say we had a rate where I'm seeing a high percentage organization doing it yet, but this will come once we... We haven't GA'd this internally. That will come in the next couple of months once we have all the stuff in place. But we're seeing designers and PMs picking up bugs directly from Jira tickets, pushing them in, something we haven't seen before, and there's just an appetite for everybody to just join. So in fact, the biggest thing right now is everybody wants access. Everybody wants access to the tools to be able to do it together, and we just want to make sure it's good enough to make sure the whole organization can do it really well.

**中文翻译:**
好的。我不会说我们已经达到了很高的覆盖率，或者说组织中很大比例的人都在用，但已经有相当一部分人在使用并提供大量反馈。我们看到了很多优秀的案例。我衡量收益的方式是一个函数：实验量乘以质量（实验有多好），再除以实际产出的时间（从创意到发布）。在节省时间方面，我们看到无论是 PM、设计师还是工程师，现在每周都能节省数小时的工作时间，无论是通过我们提到的分析师智能体、快速原型制作，还是产品头脑风暴体验。在质量方面，我们看到洞察讨论变得更深入、更优质。顺便说一下，质量和时间有时是相辅相成的，因为质量高，你就不需要在某件事上花费那么多时间。
所以我们看到了这些应用。至于规模，我还没看到组织中极高比例的人在做，但这会在我们……我们还没有在内部正式全面发布（GA）。一旦所有准备就绪，未来几个月就会实现。但我们已经看到设计师和 PM 直接从 Jira 工单中提取 Bug 并提交修复，这是以前从未见过的。现在大家都有加入的渴望。事实上，目前最大的情况是每个人都想要访问权限。每个人都想获得这些工具以便协同工作，而我们只想确保工具足够好，能让整个组织都运作良好。

---

### [00:33:32] Lenny Rachitsky

**English:**
So how is it that you're piling it? Is it some number of people have access to these agents and they just work the way they've worked with access to these tools? Or is there a team dedicated, this is the way you work now and this is it, and we'll see what happens.

**中文翻译:**
那么你们是如何进行试点的？是给一部分人这些智能体的访问权限，让他们像往常一样工作？还是有一支专门的团队，规定“这就是你们现在的工作方式”，然后观察结果？

---

### [00:33:47] Tomer Cohen

**English:**
So that's a great call. So basically we have a team building. It's the core team building the FSB track across all of R&D, FSB, full stack builder. And then there are pockets and pods of teams using it. So basically we are looking at specific areas that we're basically giving it to. The condition there is they give feedback. As a response for that, they make the tool better, so it's not just access. We want people who will use it. So one of your early adopters would be the ones who help [inaudible 00:34:15] up the product really well. So we're doing this in a pod model right now.

**中文翻译:**
问得好。基本上我们有一支核心团队在构建横跨整个研发部门的 FSB（全栈构建者）轨道。然后有一些小范围的团队和小分队在使用它。我们选择特定的领域开放权限，条件是他们必须提供反馈。作为回报，他们帮助改进工具，所以这不仅仅是开放访问。我们需要真正会使用它的人。早期的采用者就是那些帮助打磨产品的人。所以我们目前采用的是小分队模式。

---

### [00:34:19] Lenny Rachitsky

**English:**
So it's like a pod within a larger team, like a designer, PM, engineer kind of group within... Is there an example? You have a part of LinkedIn that's trying this out?

**中文翻译:**
所以就像是大团队中的一个小分队，比如由设计师、PM、工程师组成的小组……有具体的例子吗？LinkedIn 的哪个部门正在尝试这个？

---

### [00:34:27] Tomer Cohen

**English:**
Yeah. So if I think about some of our teams, whether it's... Actually, we just launched Semantic People Search and the Semantic Job Search as well. That team was using part of those tools to actually help build it. So that team actually, this was PMs building their own dashboards with those tools without waiting for design resources to come in. Then we have a design team who is now... This started really from the manager rolling this out. And in many ways, what I tell this team is, "Don't wait for the official GA. Start doing it. Start leaning in." We're seeing designers of that team starting to push PRs, which never happened before. And now other teams, they want to do this as well. So it's starting with this kind of grassroots experience. I would say the places have been very formal. I would say the beginning has been the top.
(00:35:22): The product executive teams, basically we move from functional leaders, design, PM, BD, and so on to product areas leaders, and they basically rock across the stack and they also go for a 360 with all of those functions to see if they're really able to do a full stack building experience. Then we're also launching at the junior side a new program called the Associate Product Builder Program, where basically we used to have our APM program, which this is about it's ending this year. And then starting January, we're going to start having our APB program and they're going to come into LinkedIn. We're going to teach them how to code, design and PM at LinkedIn. They're going to go through a pretty rigorous training process, and then they're going to join those pods, and gradually we're going to grow that program to be a material part of LinkedIn as well.

**中文翻译:**
有的。比如我们刚刚推出的“语义化人物搜索”和“语义化职位搜索”团队。那个团队就在使用这些工具来辅助构建。实际上，那个团队的 PM 们利用这些工具自己构建了仪表盘，而没有等待设计资源到位。另外我们还有一个设计团队……这最初是由经理发起的。在很多方面，我告诉这个团队：“不要等官方正式发布，现在就开始做，开始投入。”我们看到那个团队的设计师开始提交代码合并请求（PRs），这在以前从未发生过。现在其他团队也想效仿。所以这是从一种草根式的体验开始的。虽然有些地方很正式，但我会说最初是从高层开始的。
产品执行团队基本上从职能领导（设计、PM、业务开发等）转变为产品领域领导，他们横跨整个技术栈。他们还会与所有职能部门进行 360 度评估，看看是否真的能实现全栈构建体验。此外，我们还在初级人才端启动了一个名为“助理产品构建者（Associate Product Builder, APB）”的新项目。我们以前有 APM 项目，该项目将于今年结束。从明年一月开始，我们将启动 APB 项目，招募人才进入 LinkedIn。我们将教他们如何在 LinkedIn 进行编码、设计和产品管理。他们将接受非常严格的培训，然后加入那些小分队。逐渐地，我们将把这个项目发展成为 LinkedIn 的重要组成部分。

---

### [00:36:14] Lenny Rachitsky

**English:**
Wow. So this might be the future of the APM program is this full stack builder APM-ish program.

**中文翻译:**
哇。所以这可能是 APM 项目的未来——这种全栈构建者式的 APM 项目。

---

### [00:36:21] Tomer Cohen

**English:**
In many ways, we've built some pretty amazing... I'm really excited for that group. I wish I could join it. But we build amazing training for them. And in many ways, we're going to use that training to think about how we roll it across the organization. We're kind of using the lens of you have great technical skills, but you're not an engineer at a company yet, or you have great design taste, but you haven't designed at scale in company yet, and we're going to teach you how to do it at LinkedIn, but the training we're going to use a lot to extend across the company as well.

**中文翻译:**
在很多方面，我们构建了一些非常棒的……我为那个群体感到兴奋，我都想加入了。我们为他们准备了精彩的培训。在很大程度上，我们将利用这些培训来思考如何在全公司推广。我们的视角是：你拥有出色的技术技能，但你还不是公司的工程师；或者你有极佳的设计品味，但你还没有在公司进行过规模化设计。我们将教你如何在 LinkedIn 做到这些，而这些培训也将被广泛用于扩展到整个公司。

---

### [00:36:51] Lenny Rachitsky

**English:**
Okay. So you have these programs, these pilots and these pods, and you said what you're looking at to see if this is something you roll out is experiment velocity times quality times time.

**中文翻译:**
好。所以你有这些项目、试点和小分队。你说你衡量是否全面推广的标准是：实验速度乘以质量乘以时间。

---

### [00:37:01] Tomer Cohen

**English:**
Divided by time.

**中文翻译:**
是除以时间。

---

### [00:37:02] Lenny Rachitsky

**English:**
Divided by time. Okay.

**中文翻译:**
除以时间，明白了。

---

### [00:37:03] Tomer Cohen

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:37:04] Lenny Rachitsky

**English:**
Got it. And I guess I know it's early, but just you said you're seeing that it's saving teams a few hours a week at this point, something like that?

**中文翻译:**
明白。我知道现在还很早，但你刚才说目前看到它每周能为团队节省几个小时，是这样吗？

---

### [00:37:11] Tomer Cohen

**English:**
Yeah. And I think the feedback has been the most important part. Right? The way to think about this is just like you build a product. So we're building this product internally and you want to experiment with some kind of early adopters who will give you feedback, and the feedback has been amazing. In fact, our top talent are the ones who are using this the most at LinkedIn. And the feedback from them has been incredible in terms because they're also willing to spend the time and give the feedback as well. And the response from them has been incredible in terms of like the quality of their output, the time they're spending on this to get the value back, their desire to be part of this and actually scale this and make this even better. So that's where a lot of the excitement has been from how they're using it and the quality we've seen there. I would say in six months or so, we'll be able to see a lot more of the organization use it and you'll start seeing those top line numbers will build as well.

**中文翻译:**
是的。我认为反馈是最重要的部分。你可以把它看作是在构建一个产品。我们在内部构建这个产品，并希望通过早期采用者进行实验，让他们提供反馈。反馈非常棒。事实上，LinkedIn 的顶尖人才正是使用这些工具最多的人。他们的反馈非常惊人，因为他们也愿意花时间提供反馈。他们的反应在产出质量、投入产出比、参与意愿以及推动规模化和改进方面都非常出色。所以，兴奋点主要来自于他们的使用方式和我们看到的质量。我想在大约六个月后，我们将能看到组织中更多的人使用它，到那时你也会看到整体数据的增长。

---

### [00:38:12] Lenny Rachitsky

**English:**
That is a really interesting insight that the top performers are finding the most success, because there's always been this question, is AI going to just make people that are not amazing, more amazing, or is it going to make amazing people even more amazing? And it sounds like it's likely the latter.

**中文翻译:**
这是一个非常有趣的洞察：顶尖人才获得的成功最大。因为一直以来都有个疑问：AI 是会让平庸的人变得优秀，还是会让优秀的人变得更卓越？听起来更像是后者。

---

### [00:38:24] Tomer Cohen

**English:**
Yes. And in many ways, it's surprising, it's not surprising. I've seen this also when we were... It's surprising because you want everybody else to be part of this and lean in. I think top talent has this tendency of continuously trying to get better at their craft and this innate need to be at the cutting edge of how you build, and I think we're seeing this here as well. This is why I had this phrase I say with the team that if we build all those tools, will they use it? And I know right now the answer is no. It's not enough to give them the tools to use it. You have to build the incentives programs, the motivation, the examples to how you do it. They need to see other people being successful as well.
(00:39:11): And I've seen this also when we're shifting LinkedIn from a desktop company into a mobile company. It was a very similar process. It's very hard. Change management here is going to be a critical part. I think I see a lot of companies roll out their agents and just expecting companies to adopt. It doesn't work this way. Some will adopt. That tends to be your cutting edge 5% of talent that just wants new tools and they have a bias for change. But the vast majority needs to work for change management in how they do it, and that requires being a lot more thoughtful about the cultural aspect of it, which is by far from me the biggest and most important thing to do.

**中文翻译:**
是的。在很多方面，这既令人惊讶又不令人惊讶。我在我们……这令人惊讶是因为你希望每个人都能参与并投入。但我认为顶尖人才有一种不断精进手艺的倾向，以及一种处于构建方式最前沿的内在需求，我想我们在这里也看到了这一点。这就是为什么我常对团队说：如果我们构建了所有这些工具，他们会用吗？我知道现在的答案是“不一定”。仅仅提供工具是不够的，你必须建立激励机制、动力和操作范例。他们需要看到别人也取得了成功。
我也曾见证 LinkedIn 从一家桌面端公司转型为移动端公司，过程非常相似。这很难。变革管理将是关键部分。我看到很多公司推出了智能体，就指望员工会自动采用。事实并非如此。有些人会采用，那通常是那 5% 追求新工具、有变革偏好的尖端人才。但绝大多数人需要通过变革管理来引导，这需要对文化层面有更深入的思考，这对我来说是目前最大、最重要的事情。

---

### [00:39:48] Lenny Rachitsky

**English:**
Yeah. I want to spend time there. And it makes a lot of sense why people don't spend time here because they have so much to do. They got to ship things. Their days are already busy. You have to now carve out time to learn this new tool that'll not pay off for a while. So I get why people are like, "Okay, okay, I'll get there. I'll use it someday," but they don't. This idea of culture, when I saw you share this initially, this is the third piece of making this successful. So there's the platform of getting the code base ready for people for AI to work with. Then there's the tool, like the agents you've talked about, and then there's the culture. Is there more there that you can share of just what has actually worked in helping get people on board? One thing I heard is creating a little bit of FOMO of like, okay, only a few people can use this and you have to sign up to get access. What's worked in getting people to get on board?

**中文翻译:**
是的，我想深入聊聊这个。人们不花时间在这上面很正常，因为他们有太多事要做，要发布产品，每天都很忙。现在你还得挤出时间学习这个新工具，而且短期内可能看不到回报。所以我理解为什么人们会说：“好好好，我会学的，总有一天会用的”，但他们其实不会。关于文化的理念，当我最初看到你分享时，它是成功的第三块拼图。首先是让代码库准备好与 AI 协作的平台，然后是智能体工具，最后是文化。关于如何帮助人们加入，你还有什么可以分享的成功经验吗？我听说的一点是制造一些“错失恐惧（FOMO）”，比如只有少数人能用，必须申请才能获得权限。还有什么方法奏效了？

---

### [00:40:39] Tomer Cohen

**English:**
Yeah. I think this is where I emphasize to people that getting everything done, the platforms, the tools is not going to be sufficient. It's a prerequisite for this to work, but not sufficient for this to work because it really requires you to invest a lot in the cultural aspects of how do you get people to lean into this one. And this one might feel slow at first, but I've seen this before with our transformation of thinking from desktop to mobile. And once it picks up, it actually maintains very high velocity. One, people are really incentivized by how you define expectations for them. So to think about what is the expectation of somebody in the role, whatever-

**中文翻译:**
是的。这就是我向人们强调的地方：搞定平台和工具是不够的。它们是必要条件，但不是充分条件，因为这确实需要你在文化层面投入大量精力，引导人们投入其中。起初可能会觉得进展缓慢，但我以前在从桌面端到移动端的思维转型中见过这种情况。一旦势头起来，它实际上会保持极高的速度。第一，人们会受到你对他们角色期望定义的激励。所以要思考对某个角色的人有什么期望，无论——

---

### [00:41:21] Lenny Rachitsky

**English:**
So like changing performance review sort of things.

**中文翻译:**
比如改变绩效评估之类的事情。

---

### [00:41:23] Tomer Cohen

**English:**
Very much so. So everything from how you hire to calibration and evaluation. And one thing I want to see there early is this kind of AI agency and fluency. Like I mentioned, the tools are there. The question is, would you use them? Because the tools will be good enough, but not great at the beginning. That's the classic thing of every good MVP tool. They're good enough, but they're not great. And then you kind of want to build that agency to make the tool better. We're in this kind of notion of we're going to make this better for LinkedIn together. Two is piloting success inside of your organization. That's the pod model where you're showing that not only this could work, it's actually having success. So we have even our partnerships team, our BD team, being able to go instead of relying on waiting for an engineer to help build the developer portal and build the connectors there.
(00:42:17): Literally one of our head of partnerships just went and did it himself. Didn't even delegate to his team. And their goal is to say like, "Hey, I can do it. You can do it as well." Those examples are really, really powerful. I talked about the associate product builder program where we are going to be very focused on training. I think that will send a really strong message across the organization. People will see this talent and what they can do, and I think that will create that movement. But celebrating wins in all hands, highlighting people and showing those examples. One example we've seen recently, people really looked at it in a surprise lens, but then it kind of, I think, really opened up a lens for them. We had somebody in our user research team. We had an opening for a PM on the growth team, and that role was open for a while, and she said that, "I think I can do it."
(00:43:11): And she used all these tools. This is a user researcher becoming a growth PM, not usually the career path you see, but she was excited about the area. She used all those tools, and she's now a growth PM on the team. And really, you can start thinking about her more as a full stack builder ultimately. But seeing those openings and then highlighting those two people, actually people who are doing this have been a great example of it. And then just making sure that those tools are accessible. People can provide feedback, you share a lot, has been an incredible part of this. It's not enough to be top-down directive that this is how we want to work. People want to feel like there are success stories. They feel like it's worth their time. It feels it's a movement they want to be part of, and then ultimately they can see successes in how they do it.

**中文翻译:**
非常正确。从招聘到校准和评估的方方面面。我希望在早期看到的是一种“AI 主观能动性（agency）”和“熟练度（fluency）”。正如我提到的，工具就在那里，问题是你是否会使用它们？因为工具在开始时会“足够好”但并不“完美”。这是每个优秀 MVP 工具的典型特征。你需要建立那种主观能动性去让工具变得更好。我们秉持着“我们要一起为 LinkedIn 改进它”的理念。第二是在组织内部试点成功。这就是小分队模式，你要展示这不仅可行，而且已经取得了成功。比如我们的合作伙伴团队、业务开发（BD）团队，他们不再坐等工程师来帮他们构建开发者门户或连接器。
字面意义上，我们的一位合作伙伴负责人亲自去做了，甚至没有委派给他的团队。他们的目标是说：“嘿，我能做到，你也能做到。”这些榜样非常强大。我提到了助理产品构建者项目，我们将非常专注于培训。我认为这会向整个组织传递一个强烈的信号。人们会看到这些人才及其能力，这将引发一场变革。此外，在全员大会上庆祝胜利、表彰个人并展示案例也很重要。最近有一个例子让大家很惊讶，但也打开了视野：我们用户研究团队的一位成员，看到增长团队有一个 PM 职位空缺了很久，她说：“我觉得我能行。”
她使用了所有这些工具。这是一个用户研究员转型为增长 PM 的故事，这通常不是常见的职业路径，但她对这个领域充满热情。她利用这些工具，现在已经是团队的一名增长 PM 了。最终，你可以把她看作是一个全栈构建者。看到这些机会并向大家展示这些成功转型的案例，是非常好的示范。最后，确保工具易于获取，让人们能提供反馈，多分享，这些都是不可或缺的部分。仅仅靠自上而下的指令是不够的。人们需要看到成功案例，觉得值得投入时间，觉得这是一个他们想要参与的运动，并最终看到自己也能成功。

---

### [00:44:02] Lenny Rachitsky

**English:**
I love this kind of comparison to the shift to mobile. We all went through that and there's all these stories of companies requiring you to show mobile mocks. That's the only way we're going to operate. Now everything you have to ship has to be on mobile, and it's interesting how similar this is to them, to that experience. And so a few things you just shared here just to kind of summarize some of the things that have worked for you. Showing wins, celebrating wins, showing people what other folks are doing with AI tools, creating a program that people enroll into and make it a little bit exclusive. This performance review piece is really interesting because that really will change people's behaviors. Here's how we get promoted. Have you actually already made that change to the PM? I guess it's every track, I imagine, not just product management. Have you already made that change or is it kind of like a work in progress?

**中文翻译:**
我非常喜欢你把这比作向移动端的转型。我们都经历过那个阶段，有很多故事讲到公司要求必须展示移动端原型，否则就不予通过。现在你发布的任何东西都必须支持移动端。很有趣，现在的经历与当时如此相似。总结一下你分享的几点成功经验：展示胜利、庆祝胜利、展示他人在用 AI 工具做什么、创建一个需要申请且带有一点稀缺性的项目。绩效评估这一块非常有趣，因为这确实会改变人们的行为——“这就是我们获得晋升的方式”。你是否已经对 PM 职级（或者我猜是所有职级）做出了这种改变？是已经实施了，还是仍在进行中？

---

### [00:44:45] Tomer Cohen

**English:**
So there was two aspects to it. Once I moved my team, my directs, we did 360 for them. So their 360 was, if you came from PM, you had the designers on your team rate you. And so that had its own, and then we shared those with them, and that had its own kind of motivation. But then we broadly took it across. So when we hire right now, we look for those. And then this upcoming cycle, we do a bi-annual. That's going to be part of the performance evaluation piece and we announce it to everybody. And for what, it's where people are excited to show. And they're excited to know how they're going to be... It's always about, like, "I want to know how I'm being rated or evaluated." So just being able to show those examples has been a big part of it.
(00:45:31): The other thing I would say, it takes time for this program and its formality to roll out across the entire organization, and I was intentionally not trying to be quick at rolling this out to everybody because I think that just dilutes the value of it really quickly because it's not about... I could care less about your title. I care about how you work. So calling you a full stack builder is not what I'm looking for. Changing your mindset to a full stack mindset is what I'm looking for. You're thinking you can do the whole thing. You're looking at those tools and looking at how to do it.
(00:46:07): So one of the things I've said is if you're looking for a formal reorg or declaration to start building differently, you're waiting too long. Look, my biggest thing is here's a permission for me to just not wait and just go. So whether or not you have the right tools or not, go build the tool, use a tool from the outside, bring it in, show those examples. In many ways, prove that you are a full stack builder in mindset before anything else come to mind. And that just naturally will happen, and that's also where we've seen some of our best talent just goes and leans a lot into.

**中文翻译:**
有两个方面。首先，我调整了我的直接下属团队，为他们做了 360 度评估。如果你的背景是 PM，那么你团队中的设计师会为你打分。我们与他们分享了这些反馈，这产生了一种动力。然后我们将其推广开来。现在我们在招聘时就会考察这些特质。在即将到来的半年一度的考核周期中，这将成为绩效评估的一部分，我们已经向所有人宣布了。人们对此感到兴奋，想要展示自己的成果。他们也想知道自己将如何被评估——人们总是想知道评价标准。所以，展示这些范例是很大的一部分。
另一件事我想说的是，这个计划及其正式化在全公司推广是需要时间的。我刻意没有试图快速推向所有人，因为我觉得那会很快稀释它的价值。我并不在乎你的头衔，我在乎的是你的工作方式。所以，把你称为“全栈构建者”并不是我的目的，我想要的是改变你的思维方式，转变为“全栈思维”。你认为自己可以搞定全流程，你会寻找工具并研究如何实现。
所以我说过一句话：如果你在等待正式的重组或宣言才开始以不同的方式构建，那你等得太久了。我能给出的最大支持就是：允许你不再等待，直接行动。无论你是否有合适的工具，去构建工具，或者从外部引入工具，展示那些案例。在很多方面，在其他任何事情发生之前，先证明你在心态上是一个全栈构建者。这会自然而然地发生，这也是我们看到最优秀的人才正在全力投入的方向。

---

### [00:46:41] Lenny Rachitsky

**English:**
I love that. I was going to actually mention that quote. Someone you shared, you work with told me exactly that quote you just shared, so I'm glad you brought it up of just if you're waiting for a reorg, you're not thinking about it the right way. How do you encourage people to actually play with these tools on their own? Are you just like, "Go take a few days to play with AI?" Is it just try it? Or is there anything formal you've seen of just getting people to more try this on their own without joining this program?

**中文翻译:**
我喜欢这句话。我正打算提呢，你的一位同事曾跟我说过一模一样的话，很高兴你提到了——如果你在等重组，那你的思路就不对。你如何鼓励人们在工作之余自己去尝试这些工具？你会说“去花几天时间玩玩 AI”吗？只是让他们尝试？还是有什么正式的方式让人们在不加入这个计划的情况下更多地自主尝试？

---

### [00:47:05] Tomer Cohen

**English:**
A lot of the tools we've made, we've been sharing them regularly. A few of my all hands have been all about how to use those tools. But then at the same time, we're kind of inviting, have you found a new tool that works really well for you? Share it, show it. Again, it could be Slack, could be Messages, Teams and so on, how you do it. But the idea is really to start getting that investment in how things work. Actually, I think in general, you can feel overwhelmed by tools right now, by recipes and how to do things like what's your prompt and what's my prompt. But really it's finding something that kind of works really well, that can gravitate around and really invest in that's been those areas. But I think we've had this invitation to go and explore and go and bring in stuff that you think are great. And in many ways, bring others along on the journey. It's one good way to make the influence much bigger than a few folks who are doing really well with this.

**中文翻译:**
我们制作的很多工具都会定期分享。我的几次全员大会专门讲如何使用这些工具。但与此同时，我们也发出邀请：你是否发现了对你非常有用的新工具？分享出来，展示出来。无论是在 Slack、Messages 还是 Teams 上。核心理念是开始投入精力去研究事物是如何运作的。实际上，我认为大家现在可能会被各种工具、各种“提示词秘籍”搞得应接不暇。但真正的关键是找到一些确实好用的东西，围绕它深入研究并真正投入。我们一直邀请大家去探索，带回你认为很棒的东西。在很多方面，带着其他人一起踏上这段旅程，是让影响力超越少数几个先行者的好方法。

---

### [00:48:00] Lenny Rachitsky

**English:**
Are there any surprises on the negative side that have come out of this, of PRD is just feeling like AI driven, people slowing down unexpectedly? Is there anything that surprised you of just like, "Okay, this is actually not great"?

**中文翻译:**
在这个过程中有没有什么负面的意外？比如 PRD（产品需求文档）感觉太像 AI 生成的，或者人们意外地变慢了？有没有什么让你觉得“好吧，这其实不太妙”的事情？

---

### [00:48:12] Tomer Cohen

**English:**
Yeah, we mentioned a few of them. I was hoping for some tools to work off the shelf really well. It was never the case because we had to invest quite a lot.

**中文翻译:**
有的，我们提到过一些。我曾希望有些工具能开箱即用，但事实并非如此，我们必须投入大量精力。

---

### [00:48:21] Tomer Cohen (Continued)

**English:**
Never the case. We had to invest quite a lot. And again, part of it is we just have a lot of legacy information and code based and knowledge and designs and so on. So a lot of the companies we work with are seeing this as a great growth opportunity for them as well to invest, but I do think it's a big area of investment as well. We talked about not just giving access to all of your context which we started with, and we were like, "Oh, here's access to all the drive, all information," failed miserably and hallucinates like crazy." People gravitating towards different tools, like our goal was to converge on tools, but that was pretty hard.
(00:48:58): And then I think in terms of quality, we've just seen better quality, but I think it's because, again, where we are in the stage is still the early adopters and they're doing a few iterations in terms of how to do it. But I would say the tooling adoption is hard. And then I think for some people, this is important for me to kind of state, some people do not want to be full-stack builders, and that's completely okay. Some people see themselves in specialization, and I think specialization has a place and a role. So I didn't want the message to be across the organization I expect everybody to be a full-stack builder. I do not. I think there are system builders that empower full-stack builders, and then you have people who are specialized. But I don't think we need as many specialized people as we did in the past.

**中文翻译:**
从来没有开箱即用的。我们必须投入很多。部分原因是我们有大量的遗留信息、代码库、知识和设计等等。与我们合作的很多公司也把这看作是他们投资增长的好机会，但我确实认为这是一个巨大的投资领域。我们谈到过，不能直接开放所有语境的访问权限——我们一开始就是这么做的，结果惨败，AI 疯狂产生幻觉。还有人们倾向于不同的工具，虽然我们的目标是收敛工具，但这很难。
在质量方面，我们看到了提升，但我认为这是因为目前还处于早期采用者阶段，他们会进行多次迭代。但我会说，工具的采用过程很艰难。另外，有一点对我来说很重要：有些人并不想成为全栈构建者，这完全没问题。有些人更看重专业化，我认为专业化有其地位和作用。所以我不想向全组织传递“我期望每个人都成为全栈构建者”的信息。我并不这么期望。我认为有“系统构建者”来赋能“全栈构建者”，也有专门的人才。但我认为我们不再像过去那样需要那么多专业化的人才了。

---

### [00:49:46] Lenny Rachitsky

**English:**
I didn't actually realize this until just now. So is this their title now instead of product manager engineer, they're full stack builder?

**中文翻译:**
我刚才才意识到这一点。所以这现在是他们的头衔吗？不再是产品经理或工程师，而是“全栈构建者”？

---

### [00:49:52] Tomer Cohen

**English:**
We have a full stack builder title formally inside the organization, and we are gradually putting people in that bucket.

**中文翻译:**
我们在组织内部正式设立了“全栈构建者”头衔，并正逐渐将人们归入这一类。

---

### [00:49:59] Lenny Rachitsky

**English:**
So there's a whole career ladder that's forming. There's a whole... Okay. That's a bigger deal than I even thought. So where are you finding these folks mostly coming from, like product, engineering, design? I imagine it's a mix, but just is there a most common trend?

**中文翻译:**
所以有一套完整的职业阶梯正在形成。这比我想象的还要重大。那么这些人主要来自哪里？产品、工程还是设计？我猜是混合的，但有没有什么普遍的趋势？

---

### [00:50:13] Tomer Cohen

**English:**
It's a mix. People listening, I would just think about just go over your org and imagine who can do it, who can right now flex across those functions, whether it is engineering, design, product, even BD, and what you'll find is there's already quite a few that can flex across.

**中文翻译:**
是混合的。听众们可以审视一下自己的组织，想象一下谁能胜任，谁现在就能在工程、设计、产品甚至业务开发这些职能之间灵活切换。你会发现，已经有不少人具备这种跨职能的能力了。

---

### [00:50:34] Lenny Rachitsky

**English:**
Interesting. Are there any functions you think are especially successful at this? Not to play any favorites, but I don't know. Are you finding like, okay? Or you could also not highlight any specific.

**中文翻译:**
有趣。你认为哪些职能在这方面特别成功？不是要偏袒谁，但你有没有发现某些职能表现更好？或者你也可以不点名。

---

### [00:50:45] Tomer Cohen

**English:**
No, I think it's a mental model of how you do it. I think if I were to play what's the hardest craft to potentially learn, I think design has a lot more work to get the design agents to be really, really good. So I think designers have a little bit of a leg up in terms of others learning their craft than the vice versa. But I honestly think it's a mindset. I've seen designers code, I've seen PMs kind of design and do well. And this is why I think when you kind of step back and you think about people in your organization and who can flex, I think you'll see them show up in many areas. And what I think you'll find there is they have the agency, they're leaning into new things, they have the fluency, like they're already building new experiences and they have that growth mindset that they just want to get better, so it doesn't matter what they learn at school or what label somebody put in them when they join the company.

**中文翻译:**
不，我认为这更多是一种做事的心智模型。如果非要说哪种手艺最难学，我认为设计领域还有很多工作要做，才能让设计智能体变得非常出色。所以我觉得设计师在学习他人手艺方面可能比其他人学习设计手艺稍微有一点优势。但我真心认为这是一种心态。我见过设计师写代码，也见过 PM 做设计且做得很好。这就是为什么当你退后一步观察组织中的人，看看谁能灵活切换时，你会发现他们出现在各个领域。你会发现他们拥有主观能动性，愿意尝试新事物，拥有熟练度，并且拥有那种只想变得更好的成长型思维。所以，他们在学校学了什么，或者入职时被贴了什么标签，其实并不重要。

---

### [00:51:44] Lenny Rachitsky

**English:**
What I love about a lot of this is it's the easiest time to transition between different product roles than it's ever been. Design's moving to PM, and sure, or just moving to this new role, it makes it so much easier to, like you said, that researcher became a growth PM.

**中文翻译:**
我非常喜欢的一点是，现在是不同产品角色之间转型最容易的时期。设计师转 PM，或者直接转到这个新角色。正如你所说，研究员转成增长 PM 变得容易得多了。

---

### [00:51:58] Tomer Cohen

**English:**
And this is probably my biggest advice slash motivation I give to the team because what I tell them is ultimately... By the way, this is for me as well. I think about it the same way. The incentives for you are so aligned with your organization of what we're asking for, right? Because we need you to change. We want to be a more agile, adaptive, resilient organization that can deal with the pace of change, but you want as well for your own career. You want to be at the cutting edge of how you build. So the incentives are really aligned between what you need for your own career and what the organization needs you to do. So there's that permission to go and do it for me is ideally kind of a tailwind in what they want to do more than anything else.

**中文翻译:**
这可能是我给团队最大的建议和动力。我告诉他们，最终……顺便说一下，对我自己也是一样。你的个人激励与组织对你的要求是高度一致的。因为我们需要你改变，我们想成为一个更敏捷、更具适应性、更有韧性的组织来应对变化；而对于你自己的职业生涯，你也想站在构建方式的最前沿。所以，你个人职业发展的需求与组织对你的要求是完全吻合的。这种“被允许去尝试”的许可，对他们来说就像是顺风，助推他们去做自己想做的事。

---

### [00:52:46] Lenny Rachitsky

**English:**
Maybe a last question for people that are inspired and like, "Okay, this is what we need to be doing," any just tips for someone starting down this road to be successful at trying something like this at their company?

**中文翻译:**
最后一个问题，对于那些受到启发并觉得“这就是我们需要做的”的人，对于想要在自己公司成功尝试这种模式的人，你有什么建议吗？

---

### [00:52:58] Tomer Cohen

**English:**
I would say I would start with the notion of how do you want to bring this just structure. I would think about the platform you need to build, the tools you want to bring, and then I would spend a lot of time on the culture. Platform and tools I think would be, again, a prerequisite, but not sufficient, and the cultural aspect is really important. I would think a lot about how you bring people along. So for one of the learnings we had that probably able to do it differently right now, if I were to redo this program was, for a while I was working very closely with my core team on it, the core kind of full stack building team that were in charge of building all this material, but the organization was always asking questions. "What's going on? Who is doing it? What are the tools?" And in retrospect, we could have done a lot more in the flow to just show them and get them to already use early tools or be aware of it versus doing a small team on the side.
(00:53:49): So it is okay to start with a small team. I think it's really important. But at the same time, just making sure there's visibility across the whole thing is really powerful. Being patient and being willing to invest. I always give this example of, we always give this example of like, "Oh, look at this startup. They built this in a week." Yes, you can build lifestyle in a week right now if you start from scratch. It's actually not hard. But when you are trying to transform a large organization, you want to have this impatient about the goal and you have to have a high ambition, but being very thoughtful and patient about how you bring it to life and the key things you have to invest in. If you don't invest in your platform, I just don't see how this could be a successful outcome. If you don't invest in customizing the tools for you, then you're just going to get vanilla generic agents from the outside.
(00:54:39): So being aware of the investment and making sure you actually allocate resource to it, this is kind of the classic, be willing to invest upfront so you can reap the benefit after, versus saying, "Hey, why am I not seeing us moving into 2X the productivity in a week?" That's not going to be this way. You can see it with some people, but starting to collect those examples and starting to really think about the transformation is really key.

**中文翻译:**
我会说，首先要考虑如何建立这种结构。思考你需要构建的平台、你想引入的工具，然后花大量时间在文化上。平台和工具是前提，但不是充分条件，文化层面至关重要。要多思考如何带动大家。我们学到的一个教训是（如果现在重做，我会采取不同的方式）：有一段时间我只和核心团队密切合作，让他们负责构建所有材料，但组织里的其他人一直在问：“发生了什么？谁在做？工具有哪些？”回想起来，我们本可以在流程中做更多工作，向他们展示并让他们尽早使用早期工具或了解进展，而不是只让一个小团队在旁边闭门造车。
所以，从小团队开始是可以的，也很重要。但同时，确保整个过程的透明度是非常有力量的。要保持耐心，并愿意投入。我们总爱举例说：“看那个初创公司，他们一周就做出来了。”是的，如果你从零开始，现在一周确实能做出个东西，这并不难。但当你试图转型一个大型组织时，你对目标要保持紧迫感，要有远大的抱负，但在执行过程和关键投入上要非常周密且有耐心。如果你不投资平台，我看不到成功的可能。如果你不投资于工具的定制化，你只会得到外部那些平庸通用的智能体。
所以要意识到投入的必要性，并确保分配资源。这是经典的“先投入后收获”，而不是抱怨“嘿，为什么我们一周内没有看到生产力翻倍？”事情不会是那样的。你可能会在某些人身上看到这种效果，但开始收集案例并真正思考转型才是关键。

---

### [00:55:05] Lenny Rachitsky

**English:**
This is so incredibly cool. I know that a lot of CPOs and heads of product and all kinds of leaders are reaching out to you trying to figure out what you've learned how to do this. So I love that we went deep on all these things. Just final question, is there anything else that we haven't shared that you think might be helpful for listeners to hear or maybe just to double down on before we get to our very exciting lightning round?

**中文翻译:**
这真的太酷了。我知道很多 CPO、产品负责人和各种领导者都在联系你，想了解你是如何做到的。我很高兴我们深入探讨了这些。最后一个问题：在进入精彩的闪电轮环节之前，还有什么我们没聊到、但你认为对听众有帮助的，或者你想再次强调的吗？

---

### [00:55:26] Tomer Cohen

**English:**
Whether you're in an organization, you're waiting for your leader to roll this out or you're a leader trying to roll this out, I would not wait. The first thing I've done, which I thought in retrospect was very hopeful is I did announce this upfront we are going to this mode. We're starting in pockets, we're starting in pods, we're building the tools, but this is the mountain we're going to go after, and in many ways, we're going to make it great. I also announced that this is not just an end state, it's a kind of continuous progress. There's no state we're going to get to as much as continuously just trying to be better. And in many ways, to compete, you just want to be better than others in how you build because the version of building will completely just transform itself every few years or so.
(00:56:13): So do not wait. Really focus on the progress you're making, over communicate with your team, not just the vision, but also the progress you're making, almost like holding yourself responsible. If you're a leader, give yourself KPIs you share with your own teams or OKRs. And if you're inside of the organization, and I would say whether or not or not your CPO or your CEO is announcing this type of program, go do it or join an organization that does it so you can be at the cutting edge of how you build in the future.

**中文翻译:**
无论你是在组织中等待领导推行，还是你本身就是想推行的领导者，我都建议不要等待。我做的第一件事（回想起来非常有帮助）就是提前宣布我们要进入这种模式。我们从小范围开始，从分队开始，构建工具，但这就是我们要攀登的高山，我们要把它做好。我也宣布了这不仅仅是一个终点，而是一个持续的过程。没有所谓的最终状态，只有不断的精进。在竞争中，你只需要在构建方式上比别人做得更好，因为构建的版本每隔几年就会彻底转型。
所以，不要等待。专注于你正在取得的进展，与团队进行过度沟通（over-communicate），不仅是愿景，还有进度，就像对自己负责一样。如果你是领导者，给自己设定 KPI 或 OKR 并与团队分享。如果你在组织内部，无论你的 CPO 或 CEO 是否宣布了这类计划，去实践它，或者加入一个正在实践的组织，这样你才能站在未来构建方式的最前沿。

---

### [00:56:43] Lenny Rachitsky (Lightning Round)

**English:**
Tomer, with that, we've reached our very exciting lightning round. I've got five questions for you. Are you ready?

**中文翻译:**
Tomer，现在进入我们非常精彩的闪电轮环节。我有五个问题要问你，准备好了吗？

---

### [00:56:48] Tomer Cohen

**English:**
I'm ready.

**中文翻译:**
准备好了。

---

### [00:56:49] Lenny Rachitsky

**English:**
First question, what are two or three books you find yourself recommending most to other people?

**中文翻译:**
第一个问题：你最常向别人推荐的两三本书是什么？

---

### [00:56:54] Tomer Cohen

**English:**
I love to give trios of books that I really like. So my current trio is, they're very diverse in topics, so apologies if it's not falling all into tech. But the first one is called Why Nations Fail. It's a book I read a decade ago even more and the authors of it just won the Nobel Prize last year. And it basically talks about why does some nations succeed and some fail? And it's not the usual explanations we go for, which is, oh, it's culture, it's natural resources, it's the kind of religion. A lot of those tends to be the kind of immediate excuses people have. It kind of falls into two camps. Are there extractive or inclusive institutions? Can people participate broadly and opportunities shared or there are institutions that basically are supposed to be attracting from many and give to some.
(00:57:48): So it's just an incredible way to just think about how you build a nation. And for us at LinkedIn, we think a lot about the idea of opportunities, so how you build a product as well. And it's just a good way to move away from easy explanations into what really makes a country really successful as well. Second book, it's called Outlive. It's really about the idea, it's kind of like the author, Peter Attia talks about the idea of medicine 3.0, which is really the notion of building personalized medicine, which I think in the world of AI will become incredible in the future. But it's all those, let's call those categories that you should think about for your life so you can just optimize your health as much as possible and goes for everything through fitness to diet to the biggest health factors you should think about. But it's a great long book. Then lastly-

**中文翻译:**
我喜欢推荐我钟爱的“三部曲”。我目前的推荐组合主题非常多样，如果没全落在科技领域请见谅。第一本是《国家为什么会失败》（Why Nations Fail）。我十多年前读过，作者去年刚获得了诺贝尔奖。它主要探讨为什么有些国家成功而有些失败。它没有采用常见的解释（如文化、自然资源或宗教），那些往往是人们随口找的借口。它将其归为两类：是“榨取型（extractive）”还是“包容型（inclusive）”的制度？是人们能广泛参与、机会共享，还是制度旨在从多数人手中榨取并给予少数人。
这是一种思考如何建设国家的绝佳方式。在 LinkedIn，我们也经常思考“机会”的理念，以及如何构建产品。这是一种摆脱简单解释、深入探究国家成功真谛的好方法。第二本书是《长寿》（Outlive）。作者 Peter Attia 谈到了“医学 3.0”的概念，即构建个性化医学，我认为在 AI 时代这会变得非常不可思议。书中列出了你应该为生活考虑的各种类别，以便尽可能优化健康，涵盖了从健身、饮食到各种重大健康因素。这是一本很棒的长篇著作。最后——

---

### [00:58:41] Lenny Rachitsky

**English:**
The one in my bookshelf behind me.

**中文翻译:**
就在我身后的书架上。

---

### [00:58:42] Tomer Cohen

**English:**
There you go.

**中文翻译:**
没错。

---

### [00:58:43] Lenny Rachitsky

**English:**
It's up top. You can't actually see it, I think.

**中文翻译:**
在最上面，我想你可能看不见。

---

### [00:58:47] Tomer Cohen

**English:**
And then lastly, it's a book that also came out many years ago, but it's called The Beginning of Infinity, which I really like, by Deutsche. It wasn't an easy read for me, but I love the idea. In fact, especially in products, I love the idea of cause and effect, like really finding great explanations for why things happen and then building on top of that your next iterations. And this book really pushes on the idea of explanations that only once we have a clear understanding of what things happens, then we can have breakthroughs on top of that. But until we get to a point of clear scientific breakthroughs, we are not going to make significant progress. But when you do that, it's really almost like infinite progress you can make on top of that.

**中文翻译:**
最后一本也是多年前出版的，叫《无穷的开始》（The Beginning of Infinity），作者是 David Deutsch。对我来说读起来并不容易，但我很喜欢其中的理念。事实上，特别是在产品领域，我喜欢因果关系的理念——真正找到事情发生的原因，并在此基础上进行下一次迭代。这本书强调“解释”的力量：只有当我们对发生的事情有了清晰的理解，我们才能在此基础上取得突破。在达到科学突破点之前，我们不会取得重大进展；但一旦做到，你就能在此基础上取得近乎无限的进步。

---

### [00:59:33] Lenny Rachitsky

**English:**
Naval's always talking about that last book. I think I bought it and it was just hard reading this.

**中文翻译:**
Naval 经常提到最后那本书。我想我买过，但读起来确实很难。

---

### [00:59:39] Tomer Cohen

**English:**
It's not an easy read, at least for me. It wasn't an easy read, but it's a very powerful read.

**中文翻译:**
至少对我来说不容易读，但它非常有力量。

---

### [00:59:41] Lenny Rachitsky

**English:**
Awesome. Is there a favorite recent movie or TV show you really enjoyed?

**中文翻译:**
太棒了。最近有没有什么你非常喜欢的电影或电视剧？

---

### [00:59:46] Tomer Cohen

**English:**
Can I do a podcast?

**中文翻译:**
我可以推荐播客吗？

---

### [00:59:48] Lenny Rachitsky

**English:**
Absolutely.

**中文翻译:**
当然可以。

---

### [00:59:50] Tomer Cohen

**English:**
So there's a podcast in, it's in Hebrew, it's called One Song, and it takes a song that generally is ideally popular and then goes really deep on the origin and the history of the song, and I love it. I love music and just dissects songs so well. It does a great job also in bringing to life the story behind it. So for me, it just goes back to you thought the song was about something, but then it goes really deep into the actors behind the song, and sometimes it's the words chosen or it's how the lyrics match the music itself, and I just really enjoy that one.

**中文翻译:**
有一个希伯来语播客叫《一首歌》（One Song）。它选取一首流行的歌曲，然后深入挖掘其起源和历史。我非常喜欢它。我热爱音乐，它对歌曲的剖析非常到位，生动地讲述了背后的故事。对我来说，它让你发现原本以为理解的歌曲，背后其实有更深层的人物故事，有时是遣词造句的考究，有时是歌词与旋律的契合。我非常享受这个播客。

---

### [01:00:30] Lenny Rachitsky

**English:**
There's a podcast called Song Exploder, I believe, that is a similar concept that's not in Hebrew, in English, that I'll point people to if you love that one.

**中文翻译:**
有一个叫《Song Exploder》的播客，概念很相似，是英语的。如果大家喜欢这个概念可以去听听。

---

### [01:00:39] Tomer Cohen

**English:**
That's awesome.

**中文翻译:**
太好了。

---

### [01:00:40] Lenny Rachitsky

**English:**
Is there a product you've recently discovered that you really love? Could be an app, could be some clothing, could be a kitchen gadget, type gadget.

**中文翻译:**
你最近有没有发现什么特别喜欢的产品？可以是 App、衣服、厨房用具或某种小玩意。

---

### [01:00:48] Tomer Cohen

**English:**
Can it can be a product I want to have, which I think is actually really easy to do?

**中文翻译:**
可以是我“想要拥有”的产品吗？我觉得实现它其实很容易。

---

### [01:00:53] Lenny Rachitsky

**English:**
I love that. This is a product thinking 101 and just the vision of what you want to see.

**中文翻译:**
我喜欢这个。这是典型的产品思维，即对未来愿景的构想。

---

### [01:00:58] Tomer Cohen

**English:**
So in my car right now, there's Alexa built-in, which is great because the kids can ask for songs all day long and it's a whole show inside of the car. But one of my favorite things to do when this has been doing it for well over two years is I go in and I go into voice mode.

**中文翻译:**
我现在的车里内置了 Alexa，这很棒，因为孩子们可以整天点歌，车里就像个小剧场。但过去两年多我最喜欢做的一件事是，进入车内并开启语音模式。

---

### [01:01:17] Lenny Rachitsky

**English:**
ChatGPT.

**中文翻译:**
ChatGPT 吗？

---

### [01:01:18] Tomer Cohen

**English:**
Yeah, ChatGPT, and then just have a conversation, and that's just friction. I would love to have on my steering wheel a button that invokes my AI friend that can sit next to me in the passenger seat, and I just think that would be such a... I actually think it would [inaudible 01:01:36] rides for people. Just that movement, that's just like elimination of friction will transform the experience for me.

**中文翻译:**
是的，ChatGPT。直接和它对话。但现在还有摩擦力。我希望方向盘上有一个按钮，可以直接唤醒我的“AI 朋友”，就像它坐在副驾驶座上一样。我觉得这会彻底改变人们的驾驶体验。仅仅是消除那一点点操作摩擦，就能让体验焕然一新。

---

### [01:01:43] Lenny Rachitsky

**English:**
On that note, I recently discovered Teslas actually do this now. If you hold the right wheel, Grok appears and you could talk to Grok. So it's here. The AI has arrived. Yeah. I just did it by accident and then it's, "Okay, cool."

**中文翻译:**
说到这个，我最近发现特斯拉现在确实能做到。如果你按住右侧滚轮，Grok 就会出现，你可以和它对话。所以它已经实现了，AI 已经到来了。我只是偶然发现的，感觉“好吧，真酷”。

---

### [01:02:01] Tomer Cohen

**English:**
Great. So for me, if anybody from Rivian is listening, please bring this in the car.

**中文翻译:**
太好了。所以，如果 Rivian 的人在听，请把这个功能也装进车里。

---

### [01:02:06] Lenny Rachitsky

**English:**
Rivian's falling behind. Yeah. And you have to use Grok. It'd be cool if you could switch to different AIs because it has a personality. Just give me information. I don't need you to laugh and give me jokes.

**中文翻译:**
Rivian 落后了。而且你必须用 Grok。如果能切换不同的 AI 就酷了，因为 Grok 有自己的个性。有时我只需要信息，不需要它在那儿笑或者讲笑话。

---

### [01:02:20] Tomer Cohen

**English:**
Did you need to spend some time with it before or did it have any memory from... Did you bring any memory into it?

**中文翻译:**
你之前需要花时间调教它吗？它有记忆吗？你有没有把之前的记忆导入进去？

---

### [01:02:27] Lenny Rachitsky

**English:**
There's a logged out version and then you could just log in and it connects to your account. Yeah, it's extremely cool. No one's talking about it. It's crazy because I don't know if they launched it fully, but it just appeared.

**中文翻译:**
有一个未登录版本，你也可以登录并连接到你的账户。是的，非常酷。没人谈论这个。很疯狂，我不知道他们是否全面发布了，但它就这么出现了。

---

### [01:02:38] Tomer Cohen

**English:**
Do you talk in the car a lot to it?

**中文翻译:**
你在车里经常和它说话吗？

---

### [01:02:41] Lenny Rachitsky

**English:**
I don't use it that much, to be honest, but I should. My wife just doesn't love Grok. I think the brand of Grok is a specific brand. And so she's like, "Don't talk to Grok in here with me."

**中文翻译:**
老实说我用得不多，但我应该多用用。我妻子不太喜欢 Grok。我觉得 Grok 的品牌调性很特别，所以她说：“别当着我的面跟 Grok 说话。”

---

### [01:02:52] Tomer Cohen

**English:**
I love voice mode, so I use it all the time.

**中文翻译:**
我喜欢语音模式，所以我一直在用。

---

### [01:02:55] Lenny Rachitsky

**English:**
Yeah, I love voice mode too. It just interrupts too often. That's the issue there, right? It's just it stops.

**中文翻译:**
我也喜欢语音模式，但它打断得太频繁了。这是个问题，对吧？它总是停下来。

---

### [01:02:59] Tomer Cohen

**English:**
By the way, you can set it up. You can basically say like, "Hey, just let me finish."

**中文翻译:**
顺便说一下，你可以设置。你可以直接说：“嘿，让我说完。”

---

### [01:03:03] Lenny Rachitsky

**English:**
I now know that. I'm learning so much. Okay. Two more questions. Do you have a life motto that you often find useful in work or in life?

**中文翻译:**
我现在知道了，学到了很多。好，最后两个问题。你有没有什么在工作或生活中非常有用的座右铭？

---

### [01:03:11] Tomer Cohen

**English:**
I think last time I talked about it, I most associated here with, I might be wrong, but I'm not confused, although I don't say it as much anymore. But I think the one I love, growth mindset is a second religions for us at home. And one thing I love about, there's a phrase there that is becoming is better than being, which I think ties into the FSB mode a little bit, which is you're always in progress mode, iteration mode. It's not about reaching a state. It's about the journey, the process. That's what you should fall in love with. It's about continuously growing and evolving without the negativity of it or there's no sense of FOMO there. It's just this continuous thing. If I look back a year from now and I look back, how much did I grow? How much do I know? What skills to do that again? Where are I becoming better? Do I feel like Tomer version 2026 versus 2025? What's the delta there? And I kind of love that as a way of thinking.

**中文翻译:**
我想上次我提到过，我最认同的是“我可能错了，但我并不困惑”，虽然我现在不怎么说了。但我最喜欢的一个是——“成长型思维”在我们家就像第二宗教。我非常喜欢的一句话是：“成长胜于成就（Becoming is better than being）”。我觉得这与 FSB（全栈构建者）模式有点契合，即你永远处于“进行中”和“迭代中”。重点不在于达到某种状态，而在于旅程和过程。你应该爱上这个过程。它是关于持续的成长和进化，没有负面情绪，也没有错失恐惧。它就是一种持续的状态。如果一年后我回头看，我会问：我成长了多少？我知道了多少？我掌握了哪些新技能？我哪里变得更好了？2026 版的 Tomer 比起 2025 版有什么进步？我非常喜欢这种思维方式。

---

### [01:04:13] Lenny Rachitsky

**English:**
A great segue to our final question. By the time this episode comes out, it won't be a secret that you're leaving LinkedIn after 14 years. Legendary run. You joined way before the acquisition, you helped them integrate. Just like the way LinkedIn was perceived 14 years ago is so radically different from the way it is today. It's actually really fun and interesting to be there versus how people for a long time felt about LinkedIn. So I guess the question just how you feeling and what's next? I imagine you're going to get a lot of calls from a lot of people, but what are you planning?

**中文翻译:**
这为最后一个问题做了很好的铺垫。当这一集播出时，你在 LinkedIn 效力 14 年后即将离职的消息已经不再是秘密了。这是一段传奇的历程。你在被收购前很久就加入了，并帮助完成了整合。14 年前人们对 LinkedIn 的看法与今天截然不同。现在的 LinkedIn 真的很有趣，很有吸引力，而以前人们对它的感觉完全不同。所以我想问，你现在感觉如何？下一步打算做什么？我猜你会接到很多人的电话，但你有什么计划吗？

---

### [01:04:48] Tomer Cohen

**English:**
Yeah, so I feel proud. It's been an incredible ride at LinkedIn. The way I've got to know about LinkedIn deeply the very first time was when I moved to the Valley and I went to a lecture at Stanford about social networks in 2008 and Reid was there and he talked about the power of being a professional communities online, and I was very nerdy about it and thought it was incredible vision, had no plans to join and actually started my own company after. But as luck would have it, found myself joining a few years after and just thought the mission was incredible. So in many ways it aligned with my purpose and just was an incredible ride to be here.
(01:05:32): And I also feel very grateful. I shared this with the company recently. I was starting to take learnings from my experiences here. A lot of it was from tough situations. We had a lot of tough situations at LinkedIn and hard calls and late nights, but you learn so much from those and I'm just incredibly grateful. And I'm excited. I have a bias for change. I have a bias for kind of positioning myself in a place where I can learn the most and learn a lot. And it's an incredible time to build, so I'm just excited to be thinking of new problem sets and new areas where I can go deep on and invest the next decade in.

**中文翻译:**
是的，我感到很自豪。在 LinkedIn 的这段旅程非常不可思议。我第一次深入了解 LinkedIn 是在 2008 年搬到硅谷后，去斯坦福听了一场关于社交网络的讲座。Reid Hoffman 也在场，他谈到了在线职业社区的力量。我当时对此非常着迷，觉得那是一个不可思议的愿景。当时我并没打算加入，后来还创办了自己的公司。但机缘巧合，几年后我加入了，并觉得这个使命非常伟大。在很多方面，它与我的目标一致，在这里工作的经历非常棒。
我也感到非常感激。我最近在公司分享过，我开始总结在这里的经验教训。很多都来自于艰难的处境。我们在 LinkedIn 经历过很多困难时期、艰难的决策和无数个深夜，但你从中学到了太多，我对此心存感激。我也很兴奋。我天生喜欢变革，喜欢把自己放在能学到最多东西的地方。现在是一个伟大的构建时代，所以我很兴奋能思考新的问题集和新领域，并为之投入下一个十年。

---

### [01:06:13] Lenny Rachitsky

**English:**
I think it's going to take a long time for you to not feel like you're working on LinkedIn and to forget about all the things that you have been worrying about for so many years.

**中文翻译:**
我想你需要很长时间才能摆脱“还在 LinkedIn 工作”的感觉，并忘掉那些你担心了这么多年的事情。

---

### [01:06:20] Tomer Cohen

**English:**
After you build something for such a long time, and I think you and I talked about it at one point, that I think one of the best traits for a builder is to become very passionate with what they're building. Really care. Not about the job. It's really care about the product. When you feel the pain when somebody complains and you kind of have this continuous discontent, and it's like for me, it's the notion of raising a baby. So yeah, it's hard. It will be hard. I will always think of LinkedIn as one of the babies I helped grow.

**中文翻译:**
当你长期构建某样东西后（我想我们曾聊过这一点），我认为构建者最好的特质之一就是对所构建的东西充满激情。真正去在意，不是在意这份工作，而是真正关爱这个产品。当有人抱怨时你会感到心痛，你会有一种持续的不满足感。对我来说，这就像抚养一个孩子。所以，是的，这很难，离别会很难。我永远会把 LinkedIn 看作是我参与抚养长大的孩子之一。

---

### [01:06:53] Lenny Rachitsky

**English:**
Well, I'm excited to have you back someday when you figure out what you want to do next and or start whatever you're doing. I love that this was an excuse to get to know you. Tomer, thank you so much for being here.

**中文翻译:**
好的，我很期待有一天当你决定了下一步计划或开始新事业时，能再次请你回来。很高兴能借此机会深入了解你。Tomer，非常感谢你能来。

---

### [01:07:03] Tomer Cohen

**English:**
It was great to be here. Thanks, Lenny.

**中文翻译:**
很高兴来到这里。谢谢，Lenny。

---

### [01:07:04] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得本期内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅本节目。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目再见。