# Tomer Cohen - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Tomer Cohen, Chief Product Officer at LinkedIn.

---

### [00:00:00] Lenny Rachitsky

**English:**
I think it's so underappreciated, the turnaround that has happened within LinkedIn. I check it at least 10 times a day. What was the strategy behind it?

**中文翻译:**
我认为 LinkedIn 内部发生的华丽转身被严重低估了。我每天至少查看 10 次。这背后的战略是什么？

---

### [00:00:06] Tomer Cohen

**English:**
I start backwards. It's like what is the potential here? If you start from the premise that LinkedIn ultimately is a platform for economic opportunity that sits on top of a very strong social graph. Almost every aspect of economic transaction is possible.

**中文翻译:**
我习惯倒着推导。我会问：这里的潜力是什么？如果你从这样一个前提开始——即 LinkedIn 最终是一个建立在极强社交图谱（Social Graph）之上的经济机会平台，那么几乎所有层面的经济交易都是可能的。

---

### [00:00:20] Lenny Rachitsky

**English:**
Is there anything tactically that would just like, wow, that really made a big dent in people wanting to come here and post, share interesting content?

**中文翻译:**
在战术层面上，有没有什么举措让你觉得“哇，这真的极大地改变了局面”，让人们愿意来到这里发布和分享有趣的内容？

---

### [00:00:25] Tomer Cohen

**English:**
To really set the new purpose for it, which was this is not a springboard for other products. This is not a traffic jumpstart, it's not an upsell feed. It's really about people that matter, talking about things that I care about professionally. The first thing we did was really making AI first.

**中文翻译:**
关键在于为其设定新的目标：它不再是其他产品的跳板，不是流量的助推器，也不是为了追加销售的信息流。它真正的核心在于“重要的人在谈论我关心的职业话题”。我们做的第一件事就是确立“AI 优先”（AI first）的原则。

---

### [00:00:39] Lenny Rachitsky

**English:**
How do you actually on the ground help people shift their perspective and think AI first?

**中文翻译:**
在实际操作中，你如何帮助团队转变观念，让他们真正做到以“AI 优先”的方式思考？

---

### [00:00:43] Tomer Cohen

**English:**
So it wasn't like, "Oh, we have this cool technology, what can we do with it?" It was like, "Let go of what you've built. Go back to the objectives you were trying to solve and now with this technology, how can you do that objective better?"

**中文翻译:**
所以这并不是说，“噢，我们有这项酷炫的技术，能拿它做点什么？”而是说，“放下你已经构建的东西。回到你最初想要解决的目标上，思考有了这项技术，你如何能更好地实现那个目标？”

---

### [00:00:52] Lenny Rachitsky

**English:**
There's so much I want to dig into here. Is there anything else that you think would be interesting or useful for folks?

**中文翻译:**
这里有很多我想深入挖掘的内容。关于这一点，你觉得还有什么对大家来说有趣或有用的吗？

---

### [00:00:57] Tomer Cohen

**English:**
AI is the ultimate matchmaker. It's underutilized, it's misunderstood, it's really about...

**中文翻译:**
AI 是终极的“红娘”（匹配者）。它被低估了，也被误解了，它真正的核心在于……

---

### [00:01:07] Lenny Rachitsky

**English:**
Today my guest is Tomer Cohen. Tomer is chief product officer at LinkedIn overseeing all teams responsible for building and creating LinkedIn products and experiences, including product development, design, business development, content creation, and customer operations. During his tenure at LinkedIn, Tomer was head of the mobile team, led the effort to revamp the LinkedIn feed and to many people surprised, made it extremely interesting in a place I check regularly. And he was also at the center of shifting LinkedIn to an AI first mindset, which started way before AI became cool. In our conversation, Tomer goes inside the strategy behind the transformation of LinkedIn's feed and how they approached making it a place that people wanted to check and make it much more social.

**中文翻译:**
今天的嘉宾是 Tomer Cohen。Tomer 是 LinkedIn 的首席产品官（CPO），负责监督所有负责构建和创建 LinkedIn 产品与体验的团队，包括产品开发、设计、业务发展、内容创作和客户运营。在 LinkedIn 任职期间，Tomer 曾担任移动团队负责人，领导了 LinkedIn 动态消息（Feed）的改造工作，令许多人惊讶的是，他将其变得极其有趣，成了我经常查看的地方。他还是推动 LinkedIn 转向“AI 优先”思维的核心人物，而这一进程早在 AI 流行之前就开始了。在我们的对话中，Tomer 深入探讨了 LinkedIn 动态消息转型背后的策略，以及他们如何将其打造为一个人们愿意主动查看且更具社交属性的场所。

---

**English:**
(00:01:49): We also get into the one mindset that Tomer credits for helping him rise so quickly within LinkedIn. Also, why Tomer's most repeated mantra is, "We might be wrong, but we are not confused." And so much more. This episode is for anyone wanting to see what great product leadership looks like and wants to be inspired to think bigger. A big thank you to Shira Gasarch, Dan Roth, Josh Redfern, and Sparsh Argawal for question suggestions that made this episode so interesting. With that, I bring you Tomer Cohen.

**中文翻译:**
(00:01:49): 我们还将探讨 Tomer 认为帮助他在 LinkedIn 内部迅速晋升的一种心态。此外，还会聊到为什么 Tomer 最常重复的口头禅是：“我们可能会错，但我们并不混乱（思路清晰）。”还有更多精彩内容。这一集适合任何想要了解卓越的产品领导力是什么样，并希望受到启发去思考更宏大目标的人。非常感谢 Shira Gasarch、Dan Roth、Josh Redfern 和 Sparsh Argawal 提供的提问建议，让这一集变得如此有趣。下面，让我们欢迎 Tomer Cohen。

---

### [00:02:24] Lenny Rachitsky

**English:**
Tomer, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Tomer，非常感谢你能来到这里，欢迎来到播客。

---

### [00:02:27] Tomer Cohen

**English:**
Thank you for having me.

**中文翻译:**
谢谢你的邀请。

---

### [00:02:28] Lenny Rachitsky

**English:**
Absolutely, my pleasure. So as I was preparing for this podcast, I reached out to a bunch of people that have worked with you and asked them what I should ask you on this podcast, and interestingly, every single one of them said this one thing that I need to ask you, which is about this phrase that apparently you use all the time. So first of all, can you guess what this phrase might be?

**中文翻译:**
绝对是我的荣幸。在准备这期播客时，我联系了一群曾与你共事过的人，问他们我该问你什么。有趣的是，他们每一个人都提到了一件事，说我一定要问你，那就是你显然经常挂在嘴边的一句话。首先，你能猜到这句话是什么吗？

---

### [00:02:47] Tomer Cohen

**English:**
I have a few. Sometimes people call them Tomerisms.

**中文翻译:**
我有好几句。有时候人们管它们叫“Tomer 主义”（Tomerisms）。

---

### [00:02:49] Lenny Rachitsky

**English:**
Tomerisms.

**中文翻译:**
Tomer 主义。

---

### [00:02:50] Tomer Cohen

**English:**
But probably I might be wrong but not confused.

**中文翻译:**
但大概是“我们可能会错，但我们并不混乱（思路清晰）”。

---

### [00:02:54] Lenny Rachitsky

**English:**
That's the one. Amazing. Okay, so let's talk about this phrase.

**中文翻译:**
就是这句。太棒了。好，那我们来聊聊这句话。

---

### [00:02:58] Tomer Cohen

**English:**
I don't say it so much anymore. I think it's ingrained into the cultures.

**中文翻译:**
我现在不怎么说了。我觉得它已经深深植根于文化中了。

---

### [00:03:02] Lenny Rachitsky

**English:**
I was going to say that.

**中文翻译:**
我正想这么说。

---

### [00:03:03] Tomer Cohen

**English:**
When they think of me, they think of this sentence already.

**中文翻译:**
当他们想到我时，脑海里已经浮现出这句话了。

---

### [00:03:04] Lenny Rachitsky

**English:**
Those are the ultimate things where you don't need to say them as much anymore. Okay, so the phrase again is, "We might be wrong but we're not confused."

**中文翻译:**
这正是最高境界——你不再需要频繁提起它。好，再说一遍这句话：“我们可能会错，但我们并不混乱。”

---

### [00:03:10] Tomer Cohen

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:03:11] Lenny Rachitsky

**English:**
Let's talk about this. So what does this phrase mean and why do you find it so powerful and important to say often?

**中文翻译:**
我们聊聊这个。这句话是什么意思？为什么你觉得它如此有力，以至于经常提起它很重要？

---

### [00:03:17] Tomer Cohen

**English:**
Yeah, by the way, it's a simple phrase, but it has in my opinion, so much depth into that and ultimately something I really believe in. It's rooted in clarity and principles that ultimately lead to leadership. And the first time I got the inspiration from it was from a startup founder I met many, many years ago. Their company was on the brink of failure. They had their last attempt and they decided on a path forward and after they decided on a path forward, he was still seeing people hedging in different directions and it led into this confusion in the system where we decided people are still hedging, they're still trying out things they thought could work, and he realized that unless they basically all pull through in the same direction, there is no chance they'll be able to be successful.

**中文翻译:**
是的，顺便说一下，这是一个简单的短语，但在我看来，它蕴含着极深的意义，也是我深信不疑的东西。它植根于清晰的思路和原则，而这些最终会转化为领导力。我第一次从中获得灵感是很多年前遇到的一位创业公司创始人。当时他们的公司濒临倒闭，正在做最后的尝试。他们决定了一条前进的道路，但在决定之后，他仍然看到人们在不同的方向上摇摆不定（hedging）。这导致了系统内部的混乱：明明决定了方向，大家却还在观望，还在尝试自己认为可能有效的东西。他意识到，除非所有人基本上都朝着同一个方向发力，否则他们绝无成功的可能。

---

**English:**
(00:04:04): Now, pulling through in the same direction doesn't mean you're going to be successful, but this gives you a chance of success and that confusion, the system only luck and save you. So that was when he shared that, that was very impactful for me. I think it's a good one for life as well. And for me it comes down to two main parts. One is clarity of thought and clarity of execution, and they're both equally important.

**中文翻译:**
(00:04:04): 诚然，朝着同一个方向努力并不意味着你一定会成功，但这给了你成功的机会；而如果系统处于混乱中，那就只能靠运气拯救你了。所以当他分享这一点时，对我影响很大。我认为这对生活也很有帮助。对我来说，这归结为两个主要部分：一是思维的清晰，二是执行的清晰，两者同样重要。

---

### [00:04:29] Lenny Rachitsky (Ad Break)

**English:**
This episode is brought to you by Gamma, an entirely new way to present your ideas powered by AI. If you hate designing slides and dread that feeling of staring at a blank slide, Gamma is here to help. Just upload your PRD and turn it into a beautiful ready-to-present presentation in seconds. Gamma works with all types of formats from Google Docs, PDFs to PowerPoint. You can even drop in a link to your favorite Lenny's newsletter post and turn it into a presentation for your team. Gamma has become one of the fastest growing AI web products in the world, adding 20 million new users just this past year and is setting its sights on becoming the modern alternative to PowerPoint. Whether you have design skills or not, Gamma can save you hours of time synthesizing your ideas and shaping your content. Visit Gamma.app and use promo code Lenny to get a free month of Gamma Pro. That's G-A-M-M-A dot app.

**中文翻译:**
本集节目由 Gamma 赞助播出，这是一种由 AI 驱动的展示创意的全新方式。如果你讨厌设计幻灯片，害怕盯着空白页发愁，Gamma 可以帮到你。只需上传你的 PRD（产品需求文档），几秒钟内就能将其转化为精美且可直接演示的幻灯片。Gamma 支持各种格式，从 Google Docs、PDF 到 PowerPoint。你甚至可以放入你最喜欢的 Lenny 通讯文章链接，为你的团队生成演示文稿。Gamma 已成为全球增长最快的 AI 网页产品之一，仅去年就增加了 2000 万新用户，其目标是成为 PowerPoint 的现代替代品。无论你是否有设计技能，Gamma 都能为你节省数小时提炼想法和塑造内容的时间。访问 Gamma.app 并使用促销代码 Lenny 即可获得一个月的免费 Gamma Pro 会员。即 G-A-M-M-A dot app。

---

### [00:05:28] Lenny Rachitsky (Ad Break)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercell, Webflow and Loom. WorkOS also recently acquired Warrant, the fine-grained authorization service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on SCIM or user management, you should consider WorkOS, it's a drop-in replacement for Auth0 and supports up to one million monthly active users for free. Check it out at WorkOS.com to learn more, that's WorkOS.com.

**中文翻译:**
本集节目由 WorkOS 赞助播出。如果你正在构建 SaaS 应用，迟早你的客户会要求提供企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速、无痛地为应用添加企业功能。他们的 API 易于理解，让你能快速发布并回到其他功能的开发中。如今，数百家公司已由 WorkOS 提供支持，包括你可能熟悉的 Vercell、Webflow 和 Loom。WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的突破性授权系统，该系统最初是为 Google 设计的，用于支持 Google Docs 和 YouTube。这使得在大规模环境下进行快速授权检查成为可能，同时保持了能够适应最复杂用例的灵活模型。如果你目前正在寻求构建基于角色的访问控制（RBAC）或其他企业功能（如单点登录 SSO、SCIM 或用户管理），你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 WorkOS.com 了解更多信息。

---

### [00:06:46] Tomer Cohen

**English:**
On the clarity of thought. What I find people to be attached to, especially when you build an environment with a lot of alpha types is that they get attached to being right or wrong and that really creates a lot of lingering in the system, a lot of confusion and they're still stuck to their ideas. And for me, I get attached to clarity and focus. I think that's much more important. That's why I think when I say I don't mind being wrong, it really comes from a humble place. I would rather go forward with everybody in the same direction than necessarily try to hedge all the time, which will give me no chance of success. The way we start, we do this in our product gens right now, is we actually spend some significant time on what is the problem we're trying to solve for, but not high level, not like, hey, we want to launch this product, we want to launch a video product.

**中文翻译:**
关于思维的清晰。我发现人们往往执着于对错，尤其是在一个充满“强势型人格”（alpha types）的环境中，他们非常在意自己是对是错，这会导致系统内部出现大量的停滞和混乱，大家仍然固守自己的想法。而对我来说，我执着于“清晰”和“专注”。我认为这重要得多。这就是为什么我说我不介意犯错，这其实源于一种谦逊。我宁愿和所有人一起朝着同一个方向前进，也不愿总是试图对冲风险（hedge），因为后者会让我毫无成功的机会。我们现在在产品研讨中采用的方式是，花大量时间明确我们要解决的问题是什么，而且不是高层面的笼统描述，不是说“嘿，我们要发布这个产品”或“我们要发布一个视频产品”。

---

**English:**
(00:07:35): It's exactly what type of video you're trying to launch for which audience, what is your unique criteria, what are you trying, what is very nuanced about what you're trying to solve for? Ideally, once the time you see the problem, you know exactly the problem you're trying, you actually can imagine that mountain. It's not just a mountain, you can see exactly the road, you can see exactly the end of the base camp. But then when you move to solution, I love solutions that are based on first principles. That they have, there's a principle thinking about it, there's opinions about it. If you talk to folks who work with me, they'll tell you, I push a lot for what is actually your opinion, what is your potentially controversial opinion and the best principles have teeth.

**中文翻译:**
(00:07:35): 而是具体到你要为哪类受众发布哪种类型的视频，你的独特标准是什么，你尝试解决的问题中那些非常微妙的细节是什么？理想情况下，一旦你看清了问题，你就确切地知道自己在挑战什么，你甚至能想象出那座山——不只是一座山，你能看清路，看清大本营的终点。而当你转向解决方案时，我喜欢基于“第一性原理”（first principles）的方案。这些方案背后有原则性的思考，有明确的观点。如果你问和我共事的人，他们会告诉你，我经常逼问：“你真实的观点是什么？你那些可能有争议的观点是什么？”最好的原则是“带刺的”（have teeth，即有约束力且明确的）。

---

**English:**
(00:08:18): So saying that we should build a simple product for me is useless. Who doesn't want to build a simple product? But saying that I'm willing to sacrifice or trade off this, that's where I get excited. I'm like, okay, that's a very strong opinion. Let's go into that. Why were you willing to trade off those type of vectors to make it happen? And one thing that I saw also in clarity of thought was this, is I came to the US in 2008, I came from Israel. Our hobby in Israel is to argue. So we argue a lot, it's our love language in many ways. And I come to the US and I notice people say a lot like I don't exactly understand or I'm not exactly clear on this, and it took me a long time to realize they're actually disagreeing.

**中文翻译:**
(00:08:18): 比如，对我说“我们应该打造一个简单的产品”是没用的，谁不想做简单的产品呢？但如果你说“我愿意牺牲或权衡掉这个功能”，那我就兴奋了。我会觉得，好，这是一个非常强有力的观点。让我们深入探讨一下：为什么你愿意为了实现目标而权衡掉这些维度？关于思维清晰，我还观察到一点：我是 2008 年从以色列来到美国的。在以色列，我们的爱好就是争论。我们争论很多，在很多方面那是我们的“爱之语”。但我来到美国后，发现人们经常说“我不太理解”或者“我对此不太清楚”，过了很久我才意识到，他们其实是在表达反对。

---

**English:**
(00:09:03): They're just masking it with a layer of misunderstanding and a good mentor of mine said, "Hey, just push back. Are you disagreeing or misunderstanding? If you're misunderstanding, let's spend the night. Let's get to a point where you can articulate my point of view in your words and I can do the same, but if we're disagreeing, let's stop. Why are we spending? Why wasting time just arguing it through?" So those became really powerful. That's on the clarity of thought, clarity of execution is even more important because many organizations actually reach a decision, they don't act on it, which it's one of those shocking things. They decide this is a top priority, but it doesn't make its way into the organization. And I'll give you an example. Somebody will say, "Hey, my top priority for my business is this initiative." And then I'll say, "But most of your engineers are working on this migration." And they'll say, "Yeah, we have to finish that." I'm like, "So why don't you say the migration is my number one priority?" It's like, "Yeah."

**中文翻译:**
(00:09:03): 他们只是用“误解”这层外壳掩盖了“不同意”。我的一位良师益友曾对我说：“嘿，直接顶回去。你是在反对还是没听懂？如果你是没听懂，那我们可以聊个通宵，直到你能用你的话复述我的观点，我也能复述你的；但如果我们是观点不合，那就停下来。为什么要浪费时间一直争论呢？”这些方法变得非常有效。以上是关于思维的清晰，而执行的清晰甚至更重要，因为许多组织实际上达成了决策，却不付诸行动，这很令人震惊。他们决定这是最高优先级，但这个决策并没有渗透到组织中。举个例子，有人会说：“嘿，我业务的最高优先级是这个项目。”然后我会说：“但你大部分工程师都在做那个系统迁移。”他们会说：“是的，我们必须完成那个。”我会说：“那你为什么不直接说‘系统迁移是我的第一优先级’呢？”他们就会：“呃……”

---

**English:**
(00:10:09): It's like, but that's exactly what you're doing. You have to make sure that what you're sharing as a priority is actually manifested in your resourcing. Then I'm like, "Hey, this is your top talent. Why is your top talent working on some moonshots that are not in your number one priority?" And they're like, "Yeah." This is where you start finding that really it doesn't really translate into execution as well and you can solve so much by just making that sure that focus is there.

**中文翻译:**
(00:10:09): 事实就是，那才是你真正在做的事。你必须确保你口中的优先级真正体现在你的资源分配上。然后我会问：“嘿，这是你的顶尖人才，为什么你的顶尖人才在做一些不在你第一优先级里的‘登月计划’？”他们又会：“呃……”这就是你会发现目标并没有真正转化为执行的地方，而只要确保“专注”到位，你就能解决很多问题。

---

### [00:10:36] Lenny Rachitsky

**English:**
So the big lesson here is to push for clarity and push out anything that is unclear, confusion either in thought and also in execution. One of the folks that I talked to that worked with you about this phrase, Josh Redfern, he said that this phrase became really liberating for him, which is really interesting to hear because it forces you to make a call and to be aligned and make sure everyone is on the same page. I guess thoughts on just why this concept is so liberating.

**中文翻译:**
所以这里的核心教训是追求清晰，排除任何不明确、混乱的思维和执行。我采访过一位曾与你共事的 Josh Redfern，他说这句话对他来说非常“解脱”（liberating），这听起来很有趣，因为它强迫你做出决定并达成一致，确保每个人都在同一频道上。你觉得为什么这个概念会让人感到如此解脱？

---

### [00:11:04] Tomer Cohen

**English:**
It goes back to little alpha types or type A folks who are just so attached to not getting it wrong. When you need to move forward and it's not about being right or wrong, it's really about not being confused and making sure everybody's pulling in the same direction. That is actually really liberating. And when you know that the whole idea is to have a Socratic conversation about what you're trying to do, then coming to the table with some kind of half-baked ideas or actually not an opinion, I think actually brings into a conversation of feedback.

**中文翻译:**
这又回到了那些强势型或 A 型人格的人身上，他们太执着于“不犯错”了。当你需要前进时，重点不在于对错，而在于不混乱，并确保每个人都往一个方向使劲。这确实让人解脱。当你明白整个核心是就你正在做的事情进行一场“苏格拉底式对话”时，带着一些不成熟的想法或者甚至没有明确观点来到桌前，我认为反而能引发反馈式的对话。

---

**English:**
(00:11:39): But you have to manifest it through, if you just play this through but then you potentially playing the right or wrong game, that's really poor. I also think it's the best way to learn. If you don't know exactly what you're doing, how can you learn back from why you made that decision? So if you had a clear understanding, ultimately it's a growing organization. This is not a one-off project. We're going to build many projects in the future. So if you're not sure about what we're trying to accomplish, how can you know what you learned from it?

**中文翻译:**
(00:11:39): 但你必须贯彻到底。如果你只是表面应付，内心还在玩“对错游戏”，那就太糟糕了。我也认为这是最好的学习方式。如果你不确切知道自己在做什么，你怎么能从决策中复盘学习呢？如果你有清晰的理解，最终这会成为一个成长的组织。这不是一锤子买卖，我们未来还要构建很多项目。所以如果你不确定我们要实现什么，你怎么知道你从中学习到了什么？

---

### [00:12:09] Lenny Rachitsky

**English:**
I love that. So the idea here is make it very okay to be wrong, but make it not okay to be confused and not clear about here's what we're doing, here's why we're doing it. Everyone's aligned exactly on the same idea.

**中文翻译:**
我喜欢这个观点。所以这里的核心是：犯错没关系，但绝不允许混乱，不允许对“我们在做什么”和“为什么这么做”模糊不清。每个人必须完全对齐同一个想法。

---

### [00:12:19] Tomer Cohen

**English:**
How can I have a product conversation if I'm not sure what you stand for? It's really hard to have a Socratic conversation, really hard to have. If you ask folks how many time you left a meeting in corporate, it could be a startup or larger companies and you are not sure exactly what was the problem discussed or what are next steps. More often than not, they'll raise their hand. That for me is a waste of building time. So actually that agitates me in another great way, but when I come in and I'm proven wrong or there's a strong challenge or argument, again that's a little bit my love language, I actually enjoy those. I think we leave the conversation much better.

**中文翻译:**
如果我不确定你的立场，我怎么能进行产品对话？很难进行苏格拉底式的对话。如果你问大家，有多少次在公司开完会（无论是创业公司还是大公司），你却不确定讨论的具体问题是什么，或者下一步该做什么？大多数人都会举手。对我来说，那是对构建时间的极大浪费。这确实会让我感到焦虑，但如果我加入对话并被证明是错的，或者遇到了强有力的挑战或争论——再说一次，那是我的“爱之语”——我其实很享受。我认为这样结束对话时，我们的状态会更好。

---

### [00:13:09] Lenny Rachitsky

**English:**
You said there's some other Tomerisms, what are some others just that you can share?

**中文翻译:**
你说还有其他的“Tomer 主义”，能分享一些吗？

---

### [00:13:14] Tomer Cohen

**English:**
This is, again, this is classic to building large organizations, but I actually believe in, especially when it comes to products, to really set ambitious goals but then try to over-deliver on them, really set what are you trying to, there's almost like the opposite where people are underplaying it and over delivering, I don't understand what you're trying to do. For me it's like we are here to make an impact. We're here to really set our goals to something really massive. And when I'm trying to visualize this, I see a mountain, you see the peak and the peak exactly how it looks like, you see base camp, you know how to start and maybe the middle of the mountain is kind of blurry, but you'll figure this out. But at least you know the peak you're trying to share, share the peak, share where you're headed to and I think it's just a much more exciting way to build product. It's a much more inspirational way for folks to be part of the product process kind of thing.

**中文翻译:**
这又是构建大型组织的经典做法，但我深信，特别是在产品方面，要设定宏大的目标，然后努力“超额交付”（over-deliver）。有些人喜欢故意压低预期再超额交付，我不理解这种做法。对我来说，我们是为了产生影响力而来的。我们要把目标设定得非常宏大。当我试图将其可视化时，我看到的是一座山，你能看到山峰，看清它的样子；你能看到大本营，知道如何开始；也许山腰部分有点模糊，但你会搞定的。但至少你知道你要分享的山峰在哪里。分享那个巅峰，分享你的去向，我认为这是一种更令人兴奋的产品构建方式，也能更有效地激励大家参与到产品流程中。

---

### [00:14:35] Lenny Rachitsky

**English:**
I was just chatting with Vlad who worked at Airbnb for many years. He was actually my former manager at Airbnb and he reported to Brian for a long time and we talked about this trait that Brian also is really good at, is just setting crazy high goals. 10 X the goal that you thought you had and what would it take and it worked really well for Airbnb. So I love that you're doubling down on the same idea. Is there an example that comes to mind of one that you, some ambitious goal you set internally at LinkedIn that people are like, "No way," and then it ended up being effective?

**中文翻译:**
我刚和在 Airbnb 工作多年的 Vlad 聊过。他曾是我在 Airbnb 的经理，长期向 Brian（Airbnb CEO）汇报。我们聊到 Brian 也非常擅长设定疯狂的高目标——把你认为的目标扩大 10 倍，然后思考需要付出什么。这对 Airbnb 非常奏效。所以我很喜欢你也坚持同样的理念。你能想到一个例子吗？比如你在 LinkedIn 内部设定了一个雄心勃勃的目标，当时人们觉得“不可能”，但最后证明非常有效？

---

### [00:14:35] Tomer Cohen

**English:**
Actually there's a lot, when I think about our LinkedIn feed and thinking about when you started off, it was hard to imagine what that product could be because it was more of a promotional in nature product and I was like, no, is going to be a place where millions of people and not just tens of millions will come daily. And that's insane. That makes no sense based on the numbers today, but I don't start building from the numbers today. I start from [inaudible 00:15:04] I start backwards. I'm like, what this could be, what is the potential here? So how many professionals exist in their role? How many of them would love to find a place to share and engage with content? And this is my starting point. I start from there. So I don't start from the existence to set my ambition. I start from what this could be like based on really inspiration and excitement.

**中文翻译:**
其实有很多。当我想到我们的 LinkedIn 动态消息（Feed）时，回想刚开始的时候，很难想象这个产品能变成什么样，因为它本质上更像是一个推广性质的产品。但我当时想，不，它将成为一个每天有数亿人（而不仅仅是数千万）访问的地方。这在当时听起来很疯狂，根据当时的数字来看毫无逻辑。但我构建产品不是从今天的数字开始的，我是倒着推导的。我会想：它能变成什么样？这里的潜力是什么？全球有多少职场人士？其中有多少人希望找到一个分享和参与内容的地方？这就是我的起点。我不是根据现状来设定雄心，而是根据灵感和兴奋感来设想它可能的样子。

---

**English:**
(00:15:30): Again, it's not detached from reality completely, but it's also not hooked to it. But then Basecamp could be a good start. You're not asking you to make it the next day, but if you don't have that ambition, there's no way you're going to hit that. There's just no way. And there's so many products across LinkedIn. LinkedIn is a 20 plus year old company that many folks did not give it a chance in almost every phase of it. And I think if anything, it's one of those that just keeps getting better and better every year. And part of it is you keep the landmark on. This really has the potential to do so much for so many people. It's really an economic platform. So if you play from that, one billion members, that's actually pretty small where we can actually go.

**中文翻译:**
(00:15:30): 同样，这并非完全脱离现实，但也不被现实束缚。大本营（Basecamp）可以是一个好的开始，你不需要第二天就登顶，但如果你没有那个雄心，你绝不可能达到那里。绝无可能。LinkedIn 有很多产品。LinkedIn 是一家拥有 20 多年历史的公司，很多人在它的几乎每个阶段都不看好它。但我认为，LinkedIn 是那种每年都在变得越来越好的公司。部分原因是你始终盯着那个地标。它真的有潜力为这么多人做这么多事。它是一个真正的经济平台。如果你从这个角度出发，10 亿会员其实只是我们能达到的规模中很小的一部分。

---

### [00:16:17] Lenny Rachitsky

**English:**
I'm so happy you went to this example. This is exactly where I wanted to take the conversation. I was very much in the camp you described of LinkedIn, how could LinkedIn possibly become a place that I want to go and browse a feed and post content? As you probably know, for the longest time it was felt like this cringey place as you said, where everyone comes and promotes themselves, "Hey, I got a promotion or here's my company's new launch." And I think it's so underappreciated the turnaround that has happened within LinkedIn. I use it, I'm a multi-day, multi-Dow user. I check it at least 10 times a day. Most of my traffic to my newsletter comes from LinkedIn, not Twitter where people think, it's absurdly underappreciated and it's I think underappreciated what it took to make this happen.

**中文翻译:**
我很高兴你举了这个例子。这正是我想要引导对话的方向。我以前完全属于你描述的那种阵营：LinkedIn 怎么可能成为一个我想去浏览动态并发布内容的地方？正如你所知，很长一段时间里，它让人觉得有点“尴尬”（cringey），大家只是来推销自己，“嘿，我升职了”或者“这是我们公司的新发布”。我认为 LinkedIn 发生的转变被严重低估了。我现在是它的重度用户，每天至少看 10 次。我通讯的大部分流量来自 LinkedIn，而不是人们通常认为的 Twitter。这被极度低估了，而且我认为实现这一转变所付出的努力也被低估了。

---

**English:**
(00:17:02): And when I saw you guys starting to try to make it a place people post content, I was like, no way, this is not going to work. Why would people want to share stuff on LinkedIn? And it's working, it's amazing. So I want to spend some time here and just try to go inside the strategy that you guys put together to here's how we're going to make this happen. Come, we've shared, you have this peak of here's what we could become. How did you actually turn this around? What was the strategy behind it?

**中文翻译:**
(00:17:02): 当我看到你们开始尝试让它成为人们发布内容的地方时，我想，不可能，这行不通，为什么人们会想在 LinkedIn 上分享东西？但它成功了，这太神奇了。所以我想在这里花点时间，深入了解一下你们制定的策略。既然你已经分享了那个“巅峰”愿景，那么你们具体是如何扭转局面的？背后的战略是什么？

---

### [00:17:26] Tomer Cohen

**English:**
Yeah, by the way, I'm glad you're finding great audience and traffic on LinkedIn. I think your content, actually, your content is exactly what we're trying to build for, it's expertise, it's advice, it's people you can learn from and it's also the views that really matter, not just the volume that matters. I think if we take a step back, there's so much conversation about zero to one products or scaling products, but you don't have much conversations about minus one to one products, like turnaround products. And I think there's obviously the perception of the market you have to deal with, but people I think in minus to one products, at least from my experience and we had a few at LinkedIn, pages is another one, helping businesses build their presence on LinkedIn. What you find is it's actually, most of the time it's internally harder to do because there's so much entrenched flows and processes and metrics that people are using on that specific area.

**中文翻译:**
是的，顺便说一下，我很高兴你在 LinkedIn 上找到了优秀的受众和流量。我认为你的内容正是我们努力构建的目标：专业知识、建议、值得学习的人，而且真正重要的是那些“有价值的观看”，而不仅仅是播放量。如果我们退一步看，关于“从 0 到 1”或“规模化”产品的讨论很多，但关于“从 -1 到 1”的产品（即转型产品）的讨论并不多。显然你需要应对市场的认知，但在我看来，处理“从 -1 到 1”的产品——至少在 LinkedIn 的经验中，比如“公司主页”（Pages）也是一个例子——你会发现，大多数时候内部阻力更大，因为在那个特定领域，人们已经习惯了太多根深蒂固的流程、程序和指标。

---

**English:**
(00:18:21): So you almost have to change the inner workings of the system to make it work. Going back to the analogy of the mountain, if you start from the premise that I deeply believe in is that LinkedIn ultimately is a platform for economic opportunity that sits on top of a very strong social graph. Then really almost every aspect of economic transaction is possible and knowledge transaction is one of the most powerful economic transactions you can have. It's the biggest accelerant for an experience and we were always very strong at helping people get a job. We have seven hires per minute, but as we were building more and more knowledge and part of it was we bought LinkedIn, we bought Lynda to make it LinkedIn Learning a while back. Today we had 140 hours of learning every minute on LinkedIn happening across the feed and LinkedIn Learning, it's pretty powerful.

**中文翻译:**
(00:18:21): 所以你几乎必须改变系统的内部运作方式才能奏效。回到大山的类比，如果从我深信的前提开始——即 LinkedIn 最终是一个建立在强大社交图谱之上的经济机会平台，那么几乎所有层面的经济交易都是可能的，而“知识交易”是你能拥有的最强大的经济交易之一。它是经验积累的最大加速器。我们一直擅长帮人找工作，现在每分钟有 7 人被录用。但随着我们构建越来越多的知识内容——部分原因是我们很久以前收购了 Lynda 并将其转变为 LinkedIn Learning。如今，LinkedIn 上每分钟会产生 140 小时的学习时长，分布在动态消息和 LinkedIn Learning 中，这非常强大。

---

**English:**
(00:19:13): And the transformation to the LinkedIn feed was exactly like you said. We actually were the first company to have a social feed, but I think we started wrong. So we started with basically activity feed. So it was like who changed what, who changed the job, who connected to who. It was more of like a tracking your network feed and it became more promotional in nature. So in a way just letting that be just naturally just moved into more of a promotional type of feed. And what we've done is we've shifted dramatically into building, actually this was one of the things I was excited about. So after I was leading the mobile team, there was no feed team, there was no unified feed team, there was no feed PM to an extent, I asked to do this role, nobody cared about it. I really believed in it.

**中文翻译:**
(00:19:13): LinkedIn 动态消息的转型正如你所说。我们其实是第一家拥有社交动态的公司，但我认为我们起步错了。我们最初做的是“活动动态”（Activity Feed），比如谁改了什么，谁换了工作，谁和谁建立了联系。它更像是一个追踪人脉网的动态，本质上变得更具推广性。所以，任其自然发展，它就变成了一种推广型的动态。我们所做的是剧烈地转向构建——这实际上是我最兴奋的事情之一。在我领导移动团队之后，当时还没有专门的动态消息团队，没有统一的团队，甚至在某种程度上没有专门的动态消息 PM。我主动要求担任这个角色，当时没人关心这个，但我深信它的潜力。

---

**English:**
(00:20:07): I have strong conviction about what I could do there. And I asked to do this role and we assembled the team around it and one of the main things we've done was to really set the new purpose for it, which was this is not a springboard for other products, this is not a traffic jumpstart for, it's not an app self feed, it's really about people that matter talking about things that I care about professionally. It's about knowledge exchange. It's about how can I get the right views to the right experts in a way that actually helps them build a reputation and build their business. And then we started from there backwards. So it was basically setting that ground for that mountain peak that was nowhere to be imagined at the beginning and making our way backwards.

**中文翻译:**
(00:20:07): 我对自己能在那里做成的事有很强的信念。我申请了这个职位，并围绕它组建了团队。我们做的最主要的事情之一就是为它设定新的目标：它不是其他产品的跳板，不是流量助推器，也不是应用内的推销工具，它真正关乎“重要的人在谈论我关心的职业话题”。它是关于知识交换，关于如何将正确的观看量引导给正确的专家，从而真正帮助他们建立声誉和业务。然后我们从那里开始倒推。这基本上是为那个最初无法想象的山峰奠定基础，并一步步往回走。

---

**English:**
(00:20:55): The first thing we did was really making AI first. So the AI team back then was completely centralized. It was not part of any product team and we brought it together with one unified AI first team. And the belief I had was ultimately the engine of the car was AI and that was almost like de-prioritized or delegated to a team that was not unified in objectives. So bring that in. And then I spent most of my time on objectives and algorithm features and data training, which led me into my passion about training product people to be a first product people. And that was a big transformation there, really shifting and we had incredible AI team, but they were completely, actually, it was a confused operation. They were building something for a whole different purpose and we were trying to aim to that mountain peak and they were putting in a different direction. No bad intent, that's what they were told to do.

**中文翻译:**
(00:20:55): 我们做的第一件事就是实现“AI 优先”。当时的 AI 团队是完全中心化的，不属于任何产品团队。我们将他们整合进一个统一的“AI 优先”团队。我的信念是：汽车的引擎最终是 AI，而当时 AI 几乎被边缘化了，或者被委托给了一个目标不统一的团队。所以我们把它整合进来。然后我把大部分时间花在目标设定、算法特征和数据训练上，这引导我开始热衷于培训产品经理成为“AI 优先”的产品人。那是一个巨大的转变。我们当时有非常出色的 AI 团队，但他们的运作其实很混乱——他们在为一个完全不同的目的构建东西，而我们正试图瞄准那个山峰，他们却在往另一个方向使劲。没有恶意，只是他们被告知要那样做。

---

**English:**
(00:21:56): So bringing it together into this SWAT team was the first thing that actually was extremely powerful, but then became the hard work. You have a product that works in a certain way and you almost want to change its DNA altogether. And it was very hard because whenever we were trying to run experiments that were mass in scale, I told you everybody was relying on the feed for their traffic. It just scared the whole system because numbers were shifting up and down and teams were freaking out about meeting their goals. And then I realized that was just spending my time in escalations instead of actually building a great product. So what I did was I carved out two million members and I said, "Those are my members. I'm going to focus on building that mountain peak. I'm going to build for them."

**中文翻译:**
(00:21:56): 所以，将他们整合进这个“特种部队”（SWAT team）是第一步，这非常有力，但接下来的工作很艰巨。你有一个以某种方式运行的产品，而你几乎想彻底改变它的 DNA。这非常困难，因为每当我们尝试大规模实验时——正如我说的，所有人都在依赖动态消息获取流量——这吓坏了整个系统，因为数据上下波动，各团队都在为能否达成目标而抓狂。然后我意识到，我把时间都花在处理投诉和升级（escalations）上了，而不是在打造好产品。于是我做了一件事：我划出了 200 万会员，我说：“这些是我的会员。我要专注于为他们打造那个‘巅峰’体验。”

---

**English:**
(00:22:45): Full liberty and doing whatever, it doesn't hurt numbers, giving the scale and really focus on building a great experience for them. And it wasn't overnight and it wasn't over a week, but over the course of months we've seen dramatic behavior change for those members, almost like secluded, like a country of people that were seeing a different experience of LinkedIn. And once we saw that you actually had strong evidence that wow, if I bring this in, we don't need to spend time talking about how this pie gets slotted between different teams. We can actually grow the pie. The experience just manifests itself in a whole different way and that was a big change internally. It wasn't overnight, but it was really powerful in getting everybody around to see, wow, we have this cohort that is doing extremely well, which was a randomized cohort and then how we can bring it out.

**中文翻译:**
(00:22:45): 我拥有完全的自由去做任何事，这不会影响大盘数据，我可以专注于为他们打造卓越的体验。这不是一夜之间发生的，也不是一周就能完成的，但在几个月的时间里，我们看到这些会员的行为发生了剧变，他们就像生活在一个与世隔绝的国度，体验着完全不同的 LinkedIn。一旦我们看到了这一点，就有了强有力的证据：哇，如果我把这个推向全量，我们就不需要再讨论如何在这块饼里分蛋糕了，我们可以把饼做大。这种体验以一种完全不同的方式呈现出来，这在内部是一个巨大的转变。虽然不是一蹴而就，但它非常有说服力，让所有人看到：哇，我们有一个表现极佳的随机样本组，接下来我们该如何推广它。

---

**English:**
(00:23:39): I've also done some crazy things. We've done some negative tests to prove some stuff out, test for the sake of learning. When you run something that you can show that if it's just a promotional feed and you played it out organically over time, engage with the tier rates. We ran some really important ad tests as well, but we're really shown separate, almost like we carved out the different product and we showed that this could work and then we brought it out to the main experience for everybody else. And then that was, I would say the inner workings of minus one to one. Then the scanning part really became when we started to focus on professional opportunities. So when people actually share, how do they get the right views into the experience?

**中文翻译:**
(00:23:39): 我还做了一些疯狂的事。我们做了一些负面测试来证明某些观点，纯粹为了学习而测试。当你运行一些实验，证明如果只是一个推广型动态，随着时间推移，参与率会如何变化。我们还做了一些非常重要的广告测试，但我们是分开展示的，几乎就像我们划出了一个不同的产品，证明了它可行，然后才把它带入主体验。这就是我所说的“从 -1 到 1”的内部运作方式。接下来的规模化阶段，真正始于我们开始关注职业机会。所以当人们分享内容时，他们如何获得正确的观看体验？

---

**English:**
(00:24:19): We don't compete for volume, we're not in the same category of Meta in terms of the skill there, but we will compete all day long for the right people seeing your content. In fact, I think in many ways that's the most powerful part of LinkedIn. How do we make sure that it's professionally productive and safe conversations? How do we trade off bad engagement all day long? In fact, when we started shifting the AI objective from click through into more downstream conversations, spammers actually took notice as well. So they were jumping over the LinkedIn bandwagon, so we had to spend a lot of time removing bad activity from LinkedIn, but that's been the evolution of this process.

**中文翻译:**
(00:24:19): 我们不竞争流量规模，在规模上我们和 Meta 不在一个量级，但我们会全力竞争“让正确的人看到你的内容”。事实上，我认为这在很多方面是 LinkedIn 最强大的部分。我们如何确保对话是职业化、高效且安全的？我们如何整天权衡掉那些糟糕的互动？事实上，当我们开始将 AI 目标从“点击率”转向更深层的“下游对话”时，垃圾信息发送者也注意到了。他们开始涌向 LinkedIn，所以我们不得不花大量时间清除 LinkedIn 上的不良活动，这就是这个过程的演变。

---

### [00:25:02] Lenny Rachitsky

**English:**
That is amazing. There's so much I want to dig into here. Okay, so this two million user carve out that you did, basically everyone was just like, what the hell are you doing to our metrics and goals? You're causing all this trouble for the business. Why is this team hurting our metrics? So that was basically a group that those two million users are the only ones that saw this new updated feed and were they removed from everyone else's metrics so they weren't fluctuated as much or was it just?

**中文翻译:**
太棒了。这里有很多我想挖掘的内容。好，关于你做的那个 200 万用户的隔离区，当时大家是不是都在说：“你到底在对我们的指标和目标做什么？你给业务带来了这么多麻烦。为什么这个团队在损害我们的指标？”所以基本上，只有这 200 万用户看到了更新后的动态消息，他们是否从其他人的指标统计中剔除了，以免造成太大波动？

---

### [00:25:26] Tomer Cohen

**English:**
They could be kept in the overall because it wasn't as important.

**中文翻译:**
他们可以保留在大盘数据里，因为比例没那么大。

---

### [00:25:29] Lenny Rachitsky

**English:**
It was a small percent?

**中文翻译:**
比例很小？

---

### [00:25:30] Tomer Cohen

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:25:30] Lenny Rachitsky

**English:**
Okay. Got it.

**中文翻译:**
好，明白了。

---

### [00:25:30] Tomer Cohen

**English:**
But for us, they were like the world we were basically able to prove with them.

**中文翻译:**
但对我们来说，他们就是我们的整个世界，我们基本上靠他们来证明可行性。

---

### [00:25:34] Lenny Rachitsky

**English:**
Got it. Okay. That's so smart. Okay, so basically you just decided we're only going to move your metrics a little bit, worst case if we stick to it.

**中文翻译:**
明白了。这太聪明了。所以基本上你决定了，最坏的情况也就是稍微影响一点大家的指标。

---

### [00:25:41] Tomer Cohen

**English:**
I felt that I tried for a few months to play on the overall experience with everybody, but it was really hard, almost like impossible because you have an organization that is so tied into how things work that I was just hitting walls after walls after escalations and it was just unproductive.

**中文翻译:**
我感觉我尝试了几个月在全量体验上做文章，但太难了，几乎不可能。因为整个组织与现有的运作方式结合得太紧密了，我只是在一次又一次的投诉和升级中碰壁，效率极低。

---

### [00:26:00] Lenny Rachitsky

**English:**
And this is before you were a chief product officer where you could have just said, "We will take this bet. We know this might hurt metrics short-term"?

**中文翻译:**
这是在你成为首席产品官之前吗？那时你还不能直接说：“我们要打这个赌，我们知道这可能会短期损害指标”？

---

### [00:26:06] Tomer Cohen

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:26:07] Lenny Rachitsky

**English:**
Okay, got it. That makes sense. Okay, the other piece, so just like lessons I'm taking away from trying something like this that's an ambitious bet within a company, is put a PM and a team on it with a goal that feels like a core part of the success of just like somebody's ass is on the line to doing this thing.

**中文翻译:**
好，明白了。这很有道理。关于在公司内部进行这种雄心勃勃的尝试，我总结出的教训是：指派一名 PM 和一个团队，设定一个感觉像是成功核心部分的目标，就像是必须有人为此负责到底。

---

### [00:26:24] Tomer Cohen

**English:**
Always.

**中文翻译:**
一向如此。

---

### [00:26:24] Lenny Rachitsky

**English:**
Always, with focus on this one problem. And then there's the way you described there's this goal for this feed, but how did you actually try to turn that into a goal or metric or a KPI, what was that in the end, was there something there?

**中文翻译:**
始终专注于这一个问题。然后，你描述了动态消息的目标，但你最终是如何将其转化为具体目标、指标或 KPI 的？最后那个指标是什么？

---

### [00:26:35] Tomer Cohen

**English:**
Yeah, this is an interesting one, one thing we've done actually because the feed is the first thing you land on. I can't just count how many folks engage with the feed because then I'm counting bypassers kind of thing and bystanders that are actually coming into the experience. So we actually started to look at the more, we go a lot into active, engaged and high value engagement. So we go downstream, we kind of put the onus on looking at more downstream engagement there and we build that as the feed engagement. So really trying to show that we're not just counting some overall whatever it is [inaudible 00:27:09] or sessions at the top level. That's not really helpful because any shifts can help there, but really setting targets for that. There's obviously it's a marketplace, so there's the creation side, there's the consumption side's, there's making sure that's healthy and engaging.

**中文翻译:**
是的，这很有趣。实际上我们做的一件事是，因为动态消息是你落地的第一个页面，我不能只计算有多少人参与了动态消息，因为那样我就是在统计路过的人和旁观者。所以我们开始关注更深层的指标，我们非常看重“活跃参与”和“高价值参与”。我们关注下游（downstream），把重点放在观察更多的下游互动上，并将其定义为“动态消息参与度”。所以我们努力证明，我们不只是在统计顶层的会话数或类似指标。那没用，因为任何变动都能影响那些数字。我们为深层互动设定了目标。显然这是一个市场，有创作端，有消费端，我们要确保它是健康且引人入胜的。

---

**English:**
(00:27:23): There was so much we went into that, but I think the best thing was it's almost like you carve out. I think when you do minus one to one, it's really hard unless the CEO says I don't care about how the company performs for the next two years, we're going to go for it. If you want to keep the site keep growing and the experience keep growing, carving out and almost like sending very specific unique metrics but then could easily be extended out once you show it was in retrospect the right way to do it.

**中文翻译:**
(00:27:23): 我们在这方面投入了很多。但我认为最好的做法就是这种“隔离”。我认为当你做“从 -1 到 1”的事情时，除非 CEO 说“我不在乎公司未来两年的表现，我们要放手一搏”，否则很难。如果你想让网站和体验持续增长，隔离出一块区域，设定非常具体且独特的指标，一旦你证明了这是正确的道路，就可以轻松推广开来。

---

### [00:27:52] Lenny Rachitsky

**English:**
And to give people a glimpse into the way your brain works to identify this is a big opportunity. So you talk about just like I see there's a lever that we're not investing enough in and I see this big opportunity to grow of LinkedIn. How did you decide I need to go and bet on this thing and lead this team and I think feed is a huge opportunity?

**中文翻译:**
为了让大家了解你是如何识别大机会的：你提到你看到一个我们投入不足的杠杆，看到 LinkedIn 增长的巨大机会。你是如何决定“我需要去赌这一把并领导这个团队”，并且认为动态消息是一个巨大机会的？

---

### [00:28:10] Tomer Cohen

**English:**
I start from beliefs a lot. So I start from what do I believe this could be or where I actually came to LinkedIn this way. In fact my biggest change in my career was when I moved here and I shifted to more like what do I care about? What am I excited about? What do I have conviction on? I think it's really hard to be a strong product leader without having strong conviction about something. So I start there and in fact coming to LinkedIn as an example, when I came into lead mobile, LinkedIn was a desktop first company, then mobile team was an offshoot of entrepreneurs. I came from a startup that I ran and it wasn't a big, it wasn't, it was like, okay, I want to do mobile, I guess fine. It's like noise at this point. Same with feed. And same when I shifted into ads, I felt really strong about the ability to flip that into a great way for companies to grow.

**中文翻译:**
我经常从“信念”出发。我从“我相信这能变成什么样”开始。事实上，我职业生涯最大的转变就是来到这里，转向思考：我关心什么？什么让我兴奋？我对什么有坚定的信念？我认为，如果没有坚定的信念，很难成为一名强大的产品领导者。所以我从那里开始。以加入 LinkedIn 为例，当我来领导移动端时，LinkedIn 还是一个“桌面优先”的公司，移动团队只是创业者们的一个分支。我来自自己经营的一家创业公司，当时移动端并不被看重，大家觉得“好吧，你想做移动端，随你便”，当时那就像是背景噪音。动态消息也是如此。当我转向广告业务时，我也强烈感觉到有能力将其转变为公司增长的绝佳方式。

---

**English:**
(00:29:04): For me it starts with a conviction of where things could go, what do I believe in? I believe LinkedIn can be an incredible superpower and daily use case for every professional in the world. I believe knowledge sharing and knowledge exchange is the most amazing way to grow your career and to grow your business. So that needs to be a strong pillar of the experience, what didn't exist before and what is better than the feed experience, the home [inaudible 00:29:32] to actually build it. So I don't get attached to what did not work in the past. That's not, I don't know, maybe it's a mistake sometimes, but that doesn't stop me from thinking about the future.

**中文翻译:**
(00:29:04): 对我来说，一切始于对事物走向的信念。我相信什么？我相信 LinkedIn 可以成为全球每一位职场人士不可思议的超能力和日常工具。我相信知识分享和交换是职业成长和业务增长最神奇的方式。所以这必须成为体验的一个强大支柱，而这在以前是不存在的。还有什么比动态消息体验、首页更适合构建它的地方呢？所以我不会纠结于过去行不通的东西。我不知道，也许有时这是个错误，但这并不妨碍我思考未来。

---

### [00:29:44] Lenny Rachitsky

**English:**
How do you actually make time to think like this? A lot of people are listening. They're just like, "Okay, I want to think about what could this become?" Is this just the way brain works? You're always thinking what could this be? Do you set time aside to think quarterly or yearly, what could this be if we really made this amazing?

**中文翻译:**
你实际上是如何腾出时间这样思考的？很多人在听，他们会想：“好，我也想思考‘这能变成什么样’。”这是你大脑的运作方式吗？你总是思考“这能变成什么样”吗？你会专门留出季度或年度时间来思考“如果我们真的把它做得很棒，它会变成什么样”吗？

---

### [00:30:02] Tomer Cohen

**English:**
It's a good question. I haven't thought about it. It's like a process I do. I don't sit time aside for this, but I'm very reflective. I try to focus, love the conversations on the dream, what ultimately are we trying to achieve? I think LinkedIn has a great process called vision to values that started from our former CEO, Jeff Winner, which is like if you said this is for company or for a product, which is if you're successful, what change would happen in the world? Which I love. It's just a great phrase. It's just a great empowering phrase. So I actually tend to spend a lot of my time there. I'm also very optimistic in nature. Again, sometimes it's probably, I'm not best for any role perspective. You want somebody a bit more pessimistic about the future, but I tend to lead with beliefs versus evidence. I try to prove my beliefs with evidence, but I don't lead with evidence.

**中文翻译:**
好问题。我没想过。这就像是我的一种习惯。我不会专门为此留出时间，但我非常喜欢反思。我试着专注于关于“梦想”的对话：我们最终想要实现什么？LinkedIn 有一个很棒的流程叫“从愿景到价值”（Vision to Values），由前任 CEO Jeff Weiner 发起。它会问：如果你成功了，世界会发生什么变化？我非常喜欢这个。这是一个非常有力量的短语。所以我实际上倾向于把很多时间花在那上面。我天生也非常乐观。当然，有时从某些角色的角度来看，我可能不是最佳人选，因为你可能需要一个对未来更悲观一点的人，但我倾向于用“信念”而不是“证据”来领导。我尝试用证据来证明我的信念，但我不会被证据牵着鼻子走。

---

### [00:31:21] Lenny Rachitsky

**English:**
I think the lesson would be, for me that was the biggest learning going into AI first that gave me the why is AI so core and why I got to make it a priority all the way to my role today to make sure the rest of the organization thinks AI first. The understanding is is that in a marketplace, if I'm able to satisfy your need on the other side, then it's magic. So ultimately it came down to AI is the ultimate matchmaker. It's underutilized, it's misunderstood, it's run separate from the team. And in a marketplace it's all about value exchange. And if I'm able to do value exchange really well, then people will come back and they do and they engage and actually they come back even more and they spend more time. So for me it was that depth into AI first as the engine that moves the whole organization forward.

**中文翻译:**
我认为教训在于——对我来说，转向“AI 优先”最大的收获是让我明白了为什么 AI 如此核心，以及为什么我必须将其作为优先级，直到我今天的职位，确保整个组织都以“AI 优先”的方式思考。理解的核心在于：在一个市场中，如果我能满足你另一端的需求，那就是奇迹。所以最终归结为：AI 是终极的“红娘”。它被低估、被误解，且曾与团队脱节。在市场中，一切皆关乎价值交换。如果我能把价值交换做得很好，人们就会回来，他们确实回来了，并且参与其中，甚至回来得更频繁，停留时间更长。所以对我来说，深入“AI 优先”就是推动整个组织前进的引擎。

---

### [00:32:21] Tomer Cohen

**English:**
On both sides. If you are the creator, if you're the person sharing, remember this was a while back, I think it was about the former Olympics and person shared an article on LinkedIn about how they should not call it Olympics, they should call it the commercial Olympics because it's all about commercials and less Olympics. And then they sent me this amazing screenshot about how NBC execs who were covering the Olympics were rearing the post, this first to them was gold. It was like, "Oh my god, my content is influencing, people are seeing it, people that matter." So that was really key. Making sure that when you share something, you share your expertise. The right people on the other side are relevant to your content and they see it. That could make your day or your week or actually it could make your living in many ways. And then on the receiving side, when I come in, it's the things I'm excited about seeing.

**中文翻译:**
在供需两端都是如此。如果你是创作者，是分享内容的人——记得那是很久以前，大概是前几届奥运会期间，有人在 LinkedIn 上分享了一篇文章，说不应该叫它奥运会，应该叫“商业奥运会”，因为全是广告。然后他们给我发了一张神奇的截图，显示负责报道奥运会的 NBC 高管们正在阅读这条帖子。对创作者来说，这简直是无价之宝。他们会觉得：“天哪，我的内容正在产生影响，人们在看它，而且是重要的人在看。”所以这是关键：确保当你分享专业知识时，另一端正确且相关的人能看到它。这能让你开心一整天甚至一周，甚至在很多方面能维持你的生计。而在接收端，当我进入应用时，我看到的是我感兴趣的东西。

---

**English:**
(00:33:17): It's the things that are relevant, the reason your content resonates so much with other people, I can actually take your podcasts and I can apply them at work. What could be a better way to learn? I'll give you another example, which was very, very recent. I met with a known professor in this field and he shared with me how over the last year and a half he started using LinkedIn because somebody told him, "You have a great content, why don't you just post it?" I was like, "I don't want to post on social media." I'm like, "Oh, LinkedIn is different, share on LinkedIn." And he was like, "I post daily. I have so much content over the years, I post daily."

**中文翻译:**
(00:33:17): 那些相关的东西，正是你的内容能引起他人共鸣的原因。我可以直接听你的播客并应用到工作中，还有比这更好的学习方式吗？再举个最近的例子：我遇到了一位该领域的知名教授，他分享说在过去一年半里他开始使用 LinkedIn，因为有人告诉他：“你有这么棒的内容，为什么不发出来？”他起初说：“我不想在社交媒体上发东西。”那人说：“噢，LinkedIn 不一样，在 LinkedIn 上分享吧。”于是他说：“我现在每天都发。我积攒了多年的内容，现在每天发一条。”

---

**English:**
(00:33:51): And he was like, he basically told me this is unbelievable in terms of economic opportunity I'm getting. He's like, "I'm getting speaking engagements that are roughly half the salary I make in a year here at the university. Just by people seeing this content and getting to the right people. I was invited to advise prime ministers on their investment strategy for the country and I've been teaching for 20 years, but this platform just completely elevated my ability to reach and influence people." That's the magic and that's the value exchange and that's the kind of matchmaking at scale.

**中文翻译:**
(00:33:51): 他告诉我，就他获得的经济机会而言，这简直不可思议。他说：“我得到的演讲邀约收入大约相当于我在大学一年薪水的一半。仅仅是因为人们看到了这些内容，并且传达到了正确的人手中。我被邀请为多国总理提供国家投资战略建议，我教了 20 年书，但这个平台彻底提升了我触达和影响他人的能力。”这就是魔力，这就是价值交换，这就是规模化的“红娘”匹配。

---

### [00:34:29] Lenny Rachitsky (Ad Break)

**English:**
This episode is brought to you by Merge, product leaders. Yes, like you, cringe when they hear the word integration, they're not fun for you to scope, build, launch or maintain, and integrations probably aren't what led you to product work in the first place. Lucky for you, the folks at Merge are obsessed with integrations. Their single API helps SaaS companies launch over 200 product integrations in weeks, not quarters. Think of Merge like Plaid, but for everything B2B SaaS, organizations like Ramp, Dorada and Electric use Merge to access their customer's accounting data to reconcile bill payments, file storage data to create searchable databases in their product or HRIS data to auto-provision and deprovision access for their customer's employees. And yes, if you need AI ready data for your SaaS product, then Merge is the fastest way to get it. So want to solve your organization's integration dilemma once and for all? Book and attend a meeting at merge.dev/lenny and receive a $50 Amazon gift card. That's merge.dev/lenny.

**中文翻译:**
本集节目由 Merge 赞助。产品领导者们，是的，就像你们一样，听到“集成”（integration）这个词就会感到头大。确定范围、构建、发布或维护集成一点都不好玩，而且集成可能根本不是你最初从事产品工作的初衷。幸运的是，Merge 的团队对集成非常痴迷。他们的统一 API 帮助 SaaS 公司在几周内（而不是几个季度）发布 200 多个产品集成。把 Merge 想象成 B2B SaaS 领域的 Plaid。像 Ramp、Dorada 和 Electric 这样的组织使用 Merge 来访问客户的会计数据以对账、访问文件存储数据以创建可搜索数据库，或访问 HRIS 数据以自动为客户员工配置权限。是的，如果你的 SaaS 产品需要 AI 就绪的数据，Merge 是最快获取它的方式。想一劳永逸地解决组织的集成难题吗？在 merge.dev/lenny 预约并参加会议，即可获得 50 美元的亚马逊礼品卡。即 merge.dev/lenny。

---

### [00:35:38] Lenny Rachitsky

**English:**
I want to shift a little bit in talking about this AI first mindset that you've touched on a lot. So you talked about how at the beginning of this investment, you've already been focused on AI before it was as hot as it is today, and I've heard from many people that you're really big on getting people to shift to this mindset of being very AI first. Clearly it's worked really well at LinkedIn. I'm curious just what that actually looks like. I know you could be like, "Hey guys, we got to be AI first, AI, AI, AI." But it's different to actually make people really think differently. How do you actually on the ground help people shift their perspective and think AI first?

**中文翻译:**
我想稍微转向聊聊你多次提到的“AI 优先”思维。你谈到在 AI 像今天这样火爆之前，你就已经开始关注它了。我听很多人说，你非常热衷于让人们转向这种“AI 优先”的思维。显然这在 LinkedIn 效果很好。我很好奇这具体是什么样子的。我知道你可以只是喊口号：“嘿伙计们，我们要 AI 优先，AI，AI，AI。”但真正让人们改变思考方式是另一回事。你如何在实际工作中帮助人们转变视角，做到 AI 优先？

---

### [00:36:14] Tomer Cohen

**English:**
I can spend days on this. This is so important. It's actually so important for me, it's a key focus for me. Actually to your point, long before it became cool to talk about AI in the last two years, and in fact I think I've learned this on myself. So when it comes to the feed, I took the role of the AI product leader, it didn't exist in the company. There was no person that was ever from a product perspective thinking about AI. I think it start with the belief, like we talked about before, I think every technological revolution has dramatically changed the way we build. And AI arguably is the biggest one in our lifetimes. And when I say AI first, it's not about a tech, it's a mindset. It's a start with strategy. It is rare. Maybe now you'll see it, but it was rare two years ago to see anybody in their strategy talk about the role of AI and how they build with AI.

**中文翻译:**
这个话题我可以聊上好几天。这太重要了，对我来说是核心关注点。事实上，正如你所说，早在过去两年 AI 变得流行之前，我就在思考这个了。其实我是从自己身上学到的。在动态消息方面，我承担了 AI 产品领导者的角色，而这个职位当时在公司里并不存在。以前没有任何人从产品的角度去思考 AI。我认为这始于信念，就像我们之前聊过的，每一次技术革命都极大地改变了我们的构建方式。而 AI 可能是我们这辈子见过的最大的一次。当我谈论“AI 优先”时，它不是关于技术，而是一种心态。它始于战略。这很罕见，也许现在你能看到，但两年前很少有人在战略中谈论 AI 的角色以及如何利用 AI 构建产品。

---

**English:**
(00:37:02): Then it goes to the product and then the talent itself you hire, do they actually think this way? The analogy I would give to people is imagine a river rafting boat and you have everybody on the sides holding the pedals and adding accuracy, adding speed, but there's the guide on the back and they're holding those two pedals. Those two pedals navigate pretty much the boat and those pedals are AI and the guide better be you. And in most cases in companies the guide was somebody else, it wasn't the product leader. So then the question is, if AI actually is directing your product or success and it's the biggest factor and you as the product leader is not the one holding those two pedals, what are you doing? And then I realized that it was a bit of a lack of education in that, there was actually most product users used to think of AI as this black box, magic spells that they don't know how it's working so they're delegating.

**中文翻译:**
(00:37:02): 然后是产品，接着是你雇佣的人才，他们是否真的这样思考？我给大家打个比方：想象一艘漂流船，两边的人都在划桨，增加准确性和速度，但船尾有一个向导，手里握着两个舵柄。这两个舵柄控制着船的方向，而这两个舵柄就是 AI，那个向导最好是你。但在大多数公司里，向导是别人，而不是产品领导者。那么问题来了：如果 AI 实际上在引导你的产品或成功，它是最大的影响因素，而你作为产品领导者却没有握着那两个舵柄，你在干什么？我意识到这方面缺乏教育，大多数产品人过去常把 AI 看作一个黑匣子，一种不知道原理的魔法，所以他们选择了授权给别人。

---

**English:**
(00:38:01): And obviously that's as far from the truth as possible, but there's so many ways to unpack it. When it came to the feed where I push for example, more specifically for the teams, he doesn't stay as an AI first, there's the objective. I would ask him, "What is the objective of the algorithm?" I would challenge you to ask folks more in the folks who are leading products specifically with algorithms inherited built into them, what is the objective of the algorithm and can you write it down for me on a board? They should be able to do so, ultimately it's a mathematical formula and then it's like what features have you added to the algorithm? And this is not user features, this is specifically what parameters to learn on and then what investment do you have in data collections and fine-tuning?

**中文翻译:**
(00:38:01): 显然，这与事实相去甚远，但有很多方法可以拆解它。以动态消息为例，我具体要求团队：不要只停留在“AI 优先”的口号上，要看目标。我会问：“算法的目标是什么？”我建议你去问问那些领导内置算法产品的人：“算法的目标是什么？你能把它写在白板上吗？”他们应该能做到，因为最终它是一个数学公式。然后是：“你为算法添加了哪些特征（features）？”这不是指用户功能，而是指具体的学习参数。接着是：“你在数据收集和微调（fine-tuning）上投入了多少？”

---

**English:**
(00:38:49): Now everybody talks a big game about fine-tuning but again, two years ago, fine-tuning was something that the product folks thought the engineering team was supposed to do. No, it's the whole organization. In fact, you can build a whole strategy just on data collection and fine-tuning and your product will see tremendous success or you can delegate it and it will never happen. So in many ways that was bringing into the fold, in our phase one, which really started around 2016 for me and every team I went to, the AI component was the area I spent most of my time on. I hired people for that. Product leaders, I spent most of my, back to how do I spend my resources, most of my resources there. And it was my top priority all the way from strategy to talent. And ultimately with the last couple of years we've seen this metamorphosis of AI and this incredible new wave and we've done a pretty big change there as well over the last two years.

**中文翻译:**
(00:38:49): 现在每个人都在大谈特谈微调，但两年前，产品人员认为微调是工程团队的事。不，那是整个组织的事。事实上，你可以仅围绕数据收集和微调制定一整套战略，你的产品就会获得巨大的成功；或者你可以把它委派出去，但那样它永远不会发生。所以，在很多方面，这就是将其纳入核心。在我们的第一阶段（对我来说始于 2016 年左右），无论我去哪个团队，AI 部分都是我花费时间最多的领域。我为此雇人。作为产品领导者，回到资源分配问题上，我把大部分资源都投在了那里。从战略到人才，这都是我的最高优先级。最终，在过去的几年里，我们看到了 AI 的蜕变和这股不可思议的新浪潮，我们在过去两年也做出了巨大的改变。

---

### [00:40:13] Lenny Rachitsky

**English:**
I love this. So I took some notes on what you're talking about. So the big message that I'm taking away so far is as a product leader, you need to think about things that you thought the engineering leader had to think about or the ML engineer was thinking about things like what is the objective of our algorithm? What are the features that we're building into it? What is the data collection strategy? How are we fine-tuning it? As a PM, you should be asking these questions.

**中文翻译:**
我太喜欢这段了。我记了一些笔记。到目前为止，我得到的最大信息是：作为产品领导者，你需要思考那些你以前认为该由工程负责人或机器学习（ML）工程师思考的事情，比如：我们算法的目标是什么？我们正在构建哪些特征？数据收集策略是什么？我们如何进行微调？作为 PM，你应该问这些问题。

---

### [00:40:13] Tomer Cohen

**English:**
In fact, you should go all the way to infrastructure. You can have massive lifts in your product outcomes and goals if you probably enhance your infrastructure. How many product people talk about the infrastructure they have? Not many. Influencers, those are things ultimately your goal is to win with your products and build a much more experience to your members and customers. Literally just changing the infrastructure on top of what you build. That could be the biggest lever than you building another button or experience for your members on the top of it.

**中文翻译:**
事实上，你应该一直深入到基础设施层面。如果你能增强基础设施，你的产品结果和目标可能会获得巨大的提升。有多少产品人会谈论他们的基础设施？并不多。但最终你的目标是让产品获胜，为会员和客户打造更好的体验。仅仅改变你所构建的东西之上的基础设施，可能比你在上面多做一个按钮或一个功能更有效。

---

### [00:40:57] Lenny Rachitsky

**English:**
So say the PMs at LinkedIn, are you encouraging them all to, how is AI integrating into what you're doing? How do you just set this up so that teams do this well within LinkedIn?

**中文翻译:**
那么对于 LinkedIn 的 PM 们，你是否在鼓励他们所有人思考：AI 是如何整合进你的工作中的？你如何建立这种机制，让团队在 LinkedIn 内部做好这件事？

---

### [00:40:57] Tomer Cohen

**English:**
Yeah. So coming into this role in early 2020, we basically established an AI academy. Every PM had to go through training just like we did mobile in 2014, we moved the whole organization to be mobile first, so everybody had to go through this process. I spent a lot of time in my reviews on the AI strategy, the objectives. We make sure there's actually AI practitioners on the product side who are strong, who can teach. So we in waves started to build more of expertise and distinguished leaders across that can actually bring this learning across the board. And then in fall 2022, when we all know what happened, at least a few months after, but we started early, we completely changed our entire almost product operations and portfolio so we can focus on this new wave of AI with LLMs in the front.

**中文翻译:**
是的。在 2020 年初担任这个职位后，我们基本上建立了一个“AI 学院”。每个 PM 都必须接受培训，就像我们在 2014 年做移动端转型时一样，我们将整个组织转向“移动优先”，所以每个人都必须经历这个过程。在我的评审中，我花了很多时间在 AI 战略和目标上。我们确保产品端确实有强大的 AI 实践者可以进行教学。因此，我们分阶段开始培养更多的专业知识和卓越的领导者，让他们能够全面推广这些学习成果。然后在 2022 年秋天——大家都知道发生了什么（指 ChatGPT 发布），虽然那是几个月后的事，但我们起步很早——我们彻底改变了几乎所有的产品运作和组合，以便专注于以大语言模型（LLMs）为核心的新一波 AI 浪潮。

---

**English:**
(00:42:35): LinkedIn has been working with AI very closely since the early days, but mostly as a matchmaker. So it was the matchmaker for our marketplaces. Somebody looks to hire this dream candidate and then you have a candidate looking for the dream job and AI would be the one doing the matchmaking. We talked about the knowledge sharing on the feed. It happens in our commerce platform as well. But AI, I was in the background so I never saw it, it was making those matches. And then with the new level of AI, we actually brought AI from the back of our marketplaces really as the matchmaker to the front. And one of the things we've done there was really asking the teams to completely revisit their entire roadmap.

**中文翻译:**
(00:42:35): LinkedIn 从早期开始就与 AI 紧密合作，但主要作为“红娘”。它是我们市场的匹配者：有人想招聘理想的候选人，候选人想找理想的工作，AI 负责匹配。我们谈到了动态消息上的知识分享，这在我们的商业平台中也同样存在。但 AI 以前是在后台，你看不见它，它只是在做匹配。而随着新一代 AI 的出现，我们实际上将 AI 从市场的后台推向了前台。我们做的其中一件事就是要求团队彻底重新审视他们的整个路线图（roadmap）。

---

**English:**
(00:43:03): This is fall of 2022, the world will learn about ChatGPT for several in March 2023. So we had a nice beginning there in terms of getting started. And the goal there was let go of what you've built, let go of your roadmap, go back to the drawing board with what are you trying to solve for, back to that idea of clarity on your problem statement and now tell me what's the solution. That's very much AI first.

**中文翻译:**
(00:43:03): 那是 2022 年秋天，世界在 2023 年 3 月才真正了解 ChatGPT。所以我们在起步阶段有一个很好的开端。当时的目标是：放下你已经构建的东西，放下你的路线图，回到绘图板前，思考你到底想解决什么问题——回到清晰定义问题陈述的思路上——然后告诉我现在的解决方案是什么。这正是非常典型的“AI 优先”。

---

### [00:43:27] Lenny Rachitsky

**English:**
It reminds me, so one of the folks I pinged about you, Shira Gasarch, she used this quote about you, "Maybe you were made for such a time as this." And it connects to a lot what you're talking about where you've been thinking a lot about. And back then it was called machine learning. It wasn't called AI for a long time and now it's AI. The fact that you've been on this so long is just a perfect synergy for now. It's working its way into everything.

**中文翻译:**
这让我想起我联系过的一位 Shira Gasarch，她用了一句话形容你：“也许你就是为了这样一个时代而生的。”这与你一直在思考的内容紧密相连。那时候它还叫“机器学习”，很久之后才叫 AI。你在这个领域深耕这么久，与现在的时机完美契合。它正在渗透进一切。

---

### [00:43:27] Tomer Cohen

**English:**
Here's an example that I think sometimes to bring it to people in a more visceral way if you've been building products, product leaders are used to very much dictate the experience they're building. I want this experience to be exactly like this. I want the member to come from here and this is the options they have and I want them to be able to select this and this will be my default and I want the onboarding to progress this way. And I think this is one of the biggest shifts with this when you become an AI first leader, is that there's a realization that you don't control the experience anymore, you control the ingredients. It's almost like being a chef at the restaurant and you're used to deciding every part of the dish. You're deciding everything from the ambiance to the temperature of the broccoli and then this new technology comes in and say, just give me the ingredients, give me the guidelines of how you cook and now I'll take care of it. I'll take care of it for you.

**中文翻译:**
举个例子，为了让产品人有更直观的感受：产品领导者习惯于主宰他们构建的体验。我希望体验完全是这样的，我希望会员从这里进入，这是他们的选项，我希望他们能选这个，这是我的默认设置，我希望入职引导（onboarding）这样进行。我认为当你成为“AI 优先”的领导者时，最大的转变之一就是意识到：你不再控制体验，你控制的是“食材”。这就像在餐厅当厨师，你习惯于决定菜肴的每一个部分，从氛围到西兰花的温度。然后这项新技术进来说：“把食材给我，给我烹饪指南，剩下的我来搞定。我会为你处理好一切。”

---

**English:**
(00:44:24): For many folks, this is a very scary feeling, they're not used to letting go of the control. Obviously you build safety guards and responsible AI around it and that's super critical. But at the essence of it, AI is not deterministic. So giving it the rope to learn and do that experience for you ultimately would become much, much better. You have to have that belief going into it.

**中文翻译:**
(00:44:24): 对很多人来说，这是一种非常可怕的感觉，他们不习惯放权。显然，你需要围绕它建立安全护栏和负责任的 AI，这至关重要。但本质上，AI 是非确定性的。所以，给它学习的空间，让它为你打造体验，最终结果会变得好得多。你必须带着这种信念去做。

---

### [00:45:11] Lenny Rachitsky

**English:**
Along those lines, I'm curious if there's anything you do to avoid, everyone's like, cool AI into everything and then all these stupid things ship, then no one wants. I saw this hilarious meme of like, oh wait, we built a kind of dumb artificial person. Let's integrate it into everything. Now it's everywhere. Is there anything you've learned about just how not to ship stuff that isn't great?

**中文翻译:**
顺着这个思路，我很好奇你如何避免这种情况：大家都在喊“酷，把 AI 加进所有东西”，然后发布了一堆没人想要的愚蠢功能。我看到过一个搞笑的梗图：噢等等，我们造了一个有点笨的人造人，让我们把它整合进所有东西吧，现在它无处不在。关于如何不发布那些糟糕的东西，你学到了什么？

---

### [00:45:11] Tomer Cohen

**English:**
I can tell you what we've done here and we've failed a lot, but we learned so much along the way. When we started it in fall 2022, literally started with me calling the leaders coming to the room and we talked about, okay, let go of your roadmaps, like what we've done, great, but I want to let go of the roadmaps and I want to instead go back to what you're trying to solve for and let's meet in a couple of weeks and tell me how you're thinking differently about what you're trying to solve for knowing we have this technology in a role for us. So that was a starting point around just setting out some ground and principles around it. But we didn't start with new objectives to solve. So it wasn't like, "Oh, we have this cool technology, what can we do with it?" It was like go back to the objectives you were trying to solve and now with this technology, how can you do that objective better?

**中文翻译:**
我可以告诉你我们是怎么做的。我们失败了很多次，但也学到了很多。2022 年秋天开始时，我把领导层召集到房间里，我们谈到：好，放下你们的路线图，我们过去做的很棒，但我希望放下路线图，回到你们试图解决的问题上。两周后我们再见，告诉我既然有了这项技术，你们对要解决的问题有什么不同的思考。所以那是设定基础和原则的起点。但我们并不是从“寻找新目标”开始的。不是说“噢，我们有这项酷技术，能拿它干嘛？”而是说“回到你原本要解决的目标，现在有了这项技术，你如何能更好地实现它？”

---

**English:**
(00:46:00): The second part is we actually allowed teams to run to really inspire creativity. I didn't want to contain them. I wanted to get them really excited about the potential here. And even some things we're building duplicates for a while of similar ideas but done differently because part of it was I was learning. I was very excited to see what people would come up with and see how they can do it. And there was no playbook for building this really, really well. And in many ways we were writing the playbook. Prompt engineering became a playbook internally for us, which every day was amazing. How do you cognitively reverse engineer the brain a little bit? That was incredible. In fact, a lot of things we've learned so much ahead of the market and even shared with OpenAI and shared with Microsoft. But then after that period of just everybody getting excited and building, we basically brought it down and we did top-down got it.

**中文翻译:**
(00:46:00): 第二部分是我们允许团队放手去跑，以激发创造力。我不想限制他们，我想让他们对这里的潜力感到兴奋。甚至有一段时间，我们针对类似的想法构建了重复的功能，但实现方式不同，因为部分原因是我也在学习。我很兴奋看到人们会想出什么，以及他们如何实现。当时并没有如何把这件事做好的现成手册。在很多方面，我们是在边做边写手册。提示词工程（Prompt engineering）成了我们内部的手册，每天都让人惊叹。你如何从认知上对大脑进行一点逆向工程？这太不可思议了。事实上，我们学到的很多东西都远超市场，甚至与 OpenAI 和微软分享了。但在那段大家都兴奋构建的时期之后，我们基本上收拢了，转为自上而下的管理。

---

**English:**
(00:46:53): So we basically picked back to the objectives we had out of everything that we've seen, those for us look like the best four biggest best we want to want to aim for and we want to converge resourcing across it. So no more everybody's building whatever they want. We also, capacity is also constraint. Cost is a constraint. We want to start bringing them together. So we really much allowed people to, I would say in many words, diverge. But then I would say several weeks after converge, but we had a lot more excitement and understanding about how this thing works and what we can actually do with it.

**中文翻译:**
(00:46:53): 我们基本上从所见的一切中重新挑选了目标，选出了我们想要瞄准的四个最大的赌注，并开始整合资源。不再是每个人想造什么就造什么。我们也有容量限制，成本也是限制。我们要开始整合。所以，我允许大家先“发散”（diverge），然后在几周后“收敛”（converge）。但经过这个过程，我们对这项技术的工作原理以及能用它做什么有了更多的兴奋感和理解。

---

### [00:47:30] Lenny Rachitsky

**English:**
Love that advice. Basically give people a bunch of time and space to explore and experiment R and D and then as a top-down strategy, pick through this.

**中文翻译:**
非常棒的建议。基本上是给人们大量的时间和空间去探索、实验和研发，然后作为自上而下的战略，从中进行筛选。

---

### [00:47:40] Tomer Cohen

**English:**
The top-down, we were like, there was literally, usually I do product jams for every multiple topics we have throughout the quarter. I just did every week. I just reviewed the five bets we had on a reputed basis, nothing else. Because it was so important for them to understand that this is what I care about and we had to be focused about it.

**中文翻译:**
关于自上而下，通常我每季度会针对多个主题进行产品研讨（product jams）。但那段时间我每周都做，只是重复审查那五个赌注，没别的。因为让他们明白这就是我关心的重点，并且我们必须保持专注，这非常重要。

---

### [00:48:00] Lenny Rachitsky

**English:**
It feels like that space to explore and go crazy is important because otherwise people at the company are going to be like, "Oh, I wish, there's so many, this thing I want to try with AI, we should try it." And they'll just be pissed because they don't have time to work on it.

**中文翻译:**
感觉那种探索和“疯狂”的空间很重要，否则公司里的人会想：“噢，我真希望……有这么多我想用 AI 尝试的东西，我们应该试试。”如果他们没时间去做，就会感到很恼火。

---

### [00:48:11] Tomer Cohen

**English:**
It's a great point. It wasn't my intention, but I love that you're saying it. It's a great point because I think it gives them that. I was actually, for me sometimes almost in a, maybe too much, but I try to focus on learning. I was trying. I knew just going like this, we weren't going to learn a lot, but having people come back and trying different things and slightly going crazy and pushing the boundaries, we would learn so much. So for me it was learning, but I love the motivation around, also allowing them to have the energy.

**中文翻译:**
说得太对了。虽然这不是我的初衷，但我很喜欢你这么说。这确实给了他们空间。对我来说，有时我可能过于关注学习了。我知道如果只是按部就班，我们学不到太多；但让人们回来尝试不同的东西，稍微疯狂一点，挑战极限，我们会学到很多。所以对我来说那是为了学习，但我很喜欢这种激发动力、让他们保持能量的做法。

---

### [00:48:39] Lenny Rachitsky

**English:**
It relates to another point that a recent podcast episode I had with Brian Chesky where he introduces chaos sometimes when things are feeling too comfortable, when roadmaps, everything's calm, everything's on schedule. He's just like, "How do we do this in one day versus in two weeks? Let's just see what happens."

**中文翻译:**
这让我想起最近与 Brian Chesky 录制的一集播客，他说当事情感觉太舒服、路线图太稳、一切都按计划进行时，他有时会引入一些“混乱”。他会问：“我们如何用一天而不是两周完成这件事？让我们看看会发生什么。”

---

### [00:48:56] Tomer Cohen

**English:**
Yeah, because I think people get, there is just inertia, people get into their, it's human behavior, people get into their lanes, they start to feel really comfortable within the lanes, and then they don't know that there's a different way to do things and you have to almost externally invoke that or trigger that.

**中文翻译:**
是的，因为我认为人们会有惯性。这是人类行为，人们会进入自己的轨道，并在轨道内感到非常舒适，然后他们就不知道还有另一种做事方式，你必须几乎从外部去唤醒或触发这种改变。

---

### [00:49:13] Lenny Rachitsky

**English:**
If we think about just your career arc, I'm zooming out a little bit. You helped create the mobile experience on LinkedIn. You built the feed initially and now you're in front of AI. I could see why you're so successful at LinkedIn. I was talking to folks about your career arc at LinkedIn and you basically went from senior PM to senior PM number two, to group PM to director, to senior director to VP, to CPO in not that many years, it's a pretty meteoric rise. I wanted to spend a little time here and I want to maybe start with the question of just if you could give one specific piece of advice for someone looking to advance in their career based on what you found to be really effective, what would that be?

**中文翻译:**
如果我们回顾你的职业生涯弧线，放大来看：你帮助创建了 LinkedIn 的移动端体验，最初构建了动态消息，现在又站在了 AI 的前沿。我能看出你为什么在 LinkedIn 如此成功。我和一些人聊过你在 LinkedIn 的晋升之路，你基本上在没多少年的时间里，从高级 PM 到高级 PM 二级，到 Group PM，到总监，到高级总监，到 VP，最后到 CPO，这简直是火箭般的晋升。我想在这里花点时间，也许先从这个问题开始：如果让你给那些想要在职业生涯中晋升的人一条基于你认为非常有效的具体建议，那会是什么？

---

### [00:49:53] Tomer Cohen

**English:**
I realized everybody's in every stage in their career and they have different ways to think about the role then what they need. Maybe I'll just share about my journey, what worked for me instead of giving more of a general advice. First of all, I feel super fortunate I'm building. That's what I love doing. I love building, I love working with builders. Sometimes I'm like, I get paid for this, this is insane. But I love my craft and I love getting deep into it. So in many ways I think the things I'm excited about is the things I'm doing. When people are starting off, I usually really focus on learning from great people. People you talk to or have amazing mentors and managers. Some of them don't even know there were every mentors. It's not like a mentor officially. I try to pick up things from people all the time, and that's been just a remarkable experience working with great people.

**中文翻译:**
我意识到每个人都处于职业生涯的不同阶段，他们对角色和需求的思考方式也不同。也许我只是分享一下我的历程，分享对我有效的方法，而不是给出一个通用的建议。首先，我感到超级幸运，因为我一直在“构建”。这是我热爱的事。我喜欢构建，喜欢和构建者一起工作。有时我会想，我做这个居然还有工资拿，这太疯狂了。但我热爱我的手艺，喜欢深入钻研。所以从很多方面来说，让我兴奋的事就是我正在做的事。当人们刚起步时，我通常建议专注于向优秀的人学习。那些你交谈过的人，或者优秀的导师和经理。有些人甚至不知道他们曾是我的导师，不是那种正式的导师。我一直在尝试从他人身上汲取养分，与优秀的人共事是一段非凡的经历。

---

**English:**
(00:50:50): And in many ways, a lot of those great people actually allowed me or empowered me to take on some bigger challenges. So I can see forks in the road where if it wasn't for that person saying something very specific, probably would've done something differently. And it just made me think a lot. So I really tried to absorb learning from great people. But by far, for me personally, again, this is very personal versus generic advice, it was when I moved here, I was an engineer for many years before I moved here for graduate school in 2008. And I always loved building, that was there from a young age but when I moved here, I realized my career path was very much dictated by one thing. It was like, what's most in demand? What's most challenging? And how do I do that? It was very childish in many ways.

**中文翻译:**
(00:50:50): 在很多方面，这些优秀的人实际上允许或授权我去接受一些更大的挑战。我能看到人生道路上的分叉口，如果不是那个人说了某些非常具体的话，我可能会做出不同的选择。这让我思考了很多。所以我真的努力从优秀的人那里吸收学习。但到目前为止，对我个人而言——再说一次，这是非常个人的建议，不是通用的——是当我搬到这里时。在 2008 年来这里读研之前，我做了很多年工程师。我从小就热爱构建，但当我搬到这里时，我意识到我的职业路径在很大程度上是由一件事决定的：什么是需求量最大的？什么是挑战性最大的？我该如何做到？在很多方面，这其实很幼稚。

---

**English:**
(00:51:42): It was not dictated by me, it was in a way dictated by society. So what's the toughest engineering role? What's the best company to go into? What's the best army unit to serve in? And I fell a lot along the way, but I always kept going. And then when I came here, there was a really big challenging for me personally around what do I care about? What matters most to me? And that was, again, it's very personal in many ways. It was very much for me, an impact on learning and actually how do I create impact more broadly? And I shifted 180 in how my thought process used to go. It was less about what was out there and exciting and in demand and challenging and it was more about where did I have strong conviction on, what was I passionate about and where did I feel I could make a dent and learn?

**中文翻译:**
(00:51:42): 那不是由我决定的，而是在某种程度上由社会决定的。比如：最难的工程职位是什么？最好的公司是哪家？最好的部队是哪支？一路上我摔了很多跤，但我始终坚持。当我来到这里时，我个人面临一个巨大的挑战：我关心什么？对我来说最重要的是什么？这在很多方面又是非常个人的。对我来说，那是关于对学习的影响，以及我如何更广泛地产生影响。我的思维过程发生了 180 度大转弯。我不再关注外界什么是兴奋的、有需求的、有挑战的，而是更多地关注：我对什么有坚定的信念？我对什么充满热情？我觉得我在哪里可以有所作为（make a dent）并学到东西？

---

**English:**
(00:52:35): And that was my path forward. So after school with a student visa and massive school debt, I decided to start a company which was not a very intelligent decision based on my economic circumstances, but I didn't care. I was like, this is my new path. And then I got into LinkedIn. I didn't apply for a job. I met with who was in my role today, Deep Nishar, at that time and we talked and I said, "This is how I think this is how LinkedIn mobile should be built." And he was like, "Okay, how about you come and build it?" I was like, "Amazing." So I didn't apply to LinkedIn and then at LinkedIn I was always like, this is what I want to do, this is what's exciting for me and this is the dent I think I can make and this is my plan for it.

**中文翻译:**
(00:52:35): 这就是我的前进之路。所以毕业后，拿着学生签证，背负着巨额学债，我决定创办一家公司。根据我的经济状况，这并不是一个明智的决定，但我不在乎。我想，这是我的新路。然后我进入了 LinkedIn。我没有申请工作。我见到了当时担任我今天这个职位的 Deep Nishar，我们聊了聊，我说：“我认为 LinkedIn 的移动端应该这样构建。”他说：“好啊，那你来构建它怎么样？”我说：“太棒了。”所以我没有申请 LinkedIn，而在 LinkedIn 内部，我总是表现出：这是我想做的，这是让我兴奋的，这是我认为我可以有所作为的地方，这是我的计划。

---

**English:**
(00:53:21): I don't know if this is a recommendation for everybody, but for me it's worked really, really well. It was really pursuing the conviction I had and my excitement and bring that to the fold with people. I do think that in products, in building product, if you're not genuinely excited about what you want to build, you don't have conviction about it, it's going to be very hard for you to make a big impact.

**中文翻译:**
(00:53:21): 我不知道这是否适合所有人，但对我来说非常有效。那就是追求我的信念和兴奋感，并将其带给他人。我确实认为，在产品领域，在构建产品时，如果你对自己要构建的东西没有发自内心的兴奋感，没有坚定的信念，你很难产生巨大的影响。

---

### [00:53:45] Lenny Rachitsky

**English:**
That's also a similar theme from my most recent podcast with Vlad of just, if you don't actually buy into the mission of the place you're working on, you're not going to have a good time.

**中文翻译:**
这也是我最近与 Vlad 录制的播客中的一个类似主题：如果你不真正认同你工作地方的使命，你就不会过得很愉快。

---

### [00:53:54] Tomer Cohen

**English:**
Yeah. Say for product people, it's a very fortunate position. I always tell people, if you're in one of the most fortunate positions you can have, because if you just measure thing, for you, just measure based on your career and so on, people are going to evaluate you based on your actual work. It's a very special place. Nobody cares about your title, who cares? It's not. Maybe the company name for some people matters, but for the most part, it's about the impact you created with the products you've built. If I think about somebody's resume, I think if it was a product resume, it would be the products you built and the impact you had with it. I don't care about the companies you worked at, I don't care about the logos, I don't care about the titles. Slightly, again, not to overextend, but somebody, it's almost like an artist, right? It's like whatever, a musician, it's the albums you took out and how well they did. And I think for product people, it's a very fortunate place to be that you get measured based on the impact you had.

**中文翻译:**
是的。对于产品人来说，这是一个非常幸运的职位。我总是告诉人们，你处于最幸运的位置之一，因为如果你只衡量职业生涯之类的事情，人们会根据你的实际工作来评估你。这是一个非常特殊的地方。没人关心你的头衔，谁在乎呢？也许公司名称对某些人很重要，但在大多数情况下，重要的是你通过构建的产品所产生的影响。如果我考虑某人的简历，我认为如果是一份产品简历，它应该是你构建的产品以及你产生的影响。我不在乎你工作过的公司，不在乎那些 Logo，也不在乎头衔。稍微夸张一点说，这几乎就像艺术家，对吧？就像音乐家，重要的是你出的专辑以及它们的表现。我认为对于产品人来说，能根据你产生的影响来被衡量是非常幸运的。

---

### [00:54:53] Lenny Rachitsky

**English:**
It sounds like a LinkedIn feature idea right there. I feel like if there's any company that could make that happen, it'd be you guys. So some of the takeaways here essentially is try to index towards what are you actually excited about and motivated to work on and driven by versus where it's the most amazing company to work at are the most challenging problem.

**中文翻译:**
这听起来就像是一个 LinkedIn 的功能创意。我觉得如果有哪家公司能实现这一点，那一定是你们。所以这里的核心收获是：尝试向你真正兴奋、有动力去工作和被驱动的方向靠拢，而不是仅仅看哪家公司最棒或哪个问题最具挑战性。

---

### [00:55:17] Tomer Cohen

**English:**
Yeah, I think sometimes great companies have great opportunities for you to have dent at scale, but you need to be the one doing it. If you are thinking about, I don't know, a title or that did not, once I did the change into my excitement around impact, that's been at least my yardstick. When I look at people that I talk to or interview internally, the first thing to my mind to me is like, "What did you build and what did you learn and how well did they do?" That's what I care about.

**中文翻译:**
是的，我认为有时伟大的公司会给你提供大规模施展才华的机会，但你必须是那个亲自动手的人。如果你考虑的是头衔之类的，那没用。一旦我转向关注“影响力带来的兴奋感”，那至少成了我的衡量标准。当我观察我交谈的人或内部面试的人时，我脑海中浮现的第一件事就是：“你构建了什么？你学到了什么？它们的表现如何？”这就是我关心的。

---

### [00:55:50] Lenny Rachitsky

**English:**
I imagine there's also people on the other side where all they do is work on things that really exciting to them and they could use a little pushing towards the other direction of what's actually important in the world.

**中文翻译:**
我猜也有另一类人，他们只做自己觉得兴奋的事，他们可能需要被推向另一个方向——即世界上真正重要的事情。

---

### [00:55:59] Tomer Cohen

**English:**
100%. If you tell me, again, everybody has their different, if you tell me, "Hey, you can work on something super exciting, but it's on the fringes of the company or you can work on something which is a bit more grindy, but it's on the core of the company." The latter, no doubt, for me, impact first.

**中文翻译:**
100%。如果你告诉我——每个人都有不同的选择——如果你说：“嘿，你可以做一个超级令人兴奋但处于公司边缘的项目，或者你可以做一个有点枯燥但处于公司核心的项目。”毫无疑问，我会选后者。对我来说，影响力第一。

---

### [00:56:19] Lenny Rachitsky

**English:**
And just listening to the story you've told of the things you decided to focus on as a clear example that you saw, hey, there's this huge opportunity in the feed, I'm going to go tackle that or mobile. So I think there's a lot of, it's kind of this Venn diagram is what I'm taking away of just what's important, what am I excited about?

**中文翻译:**
听了你决定关注的那些事情的故事，这是一个清晰的例子：你看到动态消息或移动端有巨大的机会，于是你去攻克它。所以我总结出这有点像一个维恩图（Venn diagram）：什么是重要的，什么是让我兴奋的？

---

### [00:56:52] Tomer Cohen

**English:**
Yeah. One thing that actually I've now built it into a podcast, but something I'm really excited about is I don't think there's one way of building. Remember when the Steve Jobs biography came out, everybody read it. Oh, that's the way to build and that was unique to him. And one of the things I love a lot is when I look at great builders, they're all very distinct, they're all different. And I used to do this thing internally, I used to invite product builders of different disciplines and have a fireside chat with them. And I saw people across the company join not just PMs or designers, but folks across and I build that into a podcast.

**中文翻译:**
是的。有一件事我把它做成了一个播客，我对此非常兴奋：我不认为构建产品只有一种方式。记得史蒂夫·乔布斯的传记出版时，每个人都在读，觉得“噢，这就是构建产品的方法”，但那是他独有的。我非常喜欢的一点是，当我观察伟大的构建者时，他们都非常独特，各不相同。我以前在内部经常做一件事：邀请不同学科的产品构建者，与他们进行炉边谈话。我看到全公司的人都来参加，不只是 PM 或设计师，还有各行各业的人。于是我把这做成了一个播客。

---

**English:**
(00:57:34): I love your podcast. Mine is very different. It's more around what is their edge a little bit. This is from the co-founder of Pixar, Ed Catmull, to the CPO of Canva or Spotify, Roblox, but all the way to a chef, Dan Barber, who's the number one chef in the US for many years. And it's just everybody has their craft and they do it differently. It's called BuildingOne, I'm excited about it. It's a little bit of a plug right now, Lenny.

**中文翻译:**
(00:57:34): 我很喜欢你的播客。我的播客非常不同，它更多是关于“他们的优势是什么”。嘉宾从皮克斯的联合创始人 Ed Catmull，到 Canva、Spotify、Roblox 的 CPO，甚至还有多年蝉联美国第一大厨的 Dan Barber。每个人都有自己的手艺，且方式各异。它叫《BuildingOne》，我对此很兴奋。Lenny，这算是一个小广告。

---

### [00:58:03] Lenny Rachitsky

**English:**
Please. Yeah. Where do people find it? Let's blow it up. It's called BuildingOne?

**中文翻译:**
请便。大家在哪里能找到它？让我们帮它火起来。叫《BuildingOne》？

---

### [00:58:07] Tomer Cohen

**English:**
BuildingOne on Apple or Spotify.

**中文翻译:**
在 Apple 或 Spotify 上搜索《BuildingOne》。

---

### [00:58:11] Tomer Cohen

**English:**
It's short and it's really about showing you different disciplines from a chef to an animation director. And really the main learning there is everybody builds differently and you can be very successful, but it's very authentic to how they are personally, and it's how they push their craft to the limit. It's how well they've done their craft.

**中文翻译:**
它很短，旨在向你展示从厨师到动画导演的不同学科。核心教训是：每个人的构建方式都不同，你都可以非常成功，但这必须符合你的个性，以及你如何将手艺推向极限。这关乎他们把手艺做得有多好。

---

### [00:58:29] Lenny Rachitsky

**English:**
I love that. And something I super believe is just the power of focusing on your strengths and the things that make you a little different versus trying to become good at everything.

**中文翻译:**
我喜欢这个。我深信的一点是：专注于你的优势以及让你与众不同的地方，其力量远大于试图在所有事情上都做得很好。

---

### [00:58:43] Lenny Rachitsky

**English:**
BuildingOne. BuildingOne. Okay. Amazing. And it's on all the podcasting platforms. Okay, great. With that, we've reached a very exciting lightning round. Are you ready?

**中文翻译:**
《BuildingOne》。好，太棒了。各大播客平台都有。好，接下来进入激动人心的闪电提问环节。准备好了吗？

---

### [00:58:50] Tomer Cohen

**English:**
Yes.

**中文翻译:**
准备好了。

---

### [00:58:51] Lenny Rachitsky

**English:**
All right. First question is, what are two or three books that you recommended most to other people?

**中文翻译:**
好。第一个问题：你向别人推荐最多的两三本书是什么？

---

### [00:58:57] Tomer Cohen

**English:**
So I have this [inaudible 00:58:58] continuously, actually it's these three. I love fundamentals. I love studying from fundamentals. So if you're somebody who starts in your career, my fundamental books is One Mindset. It's about growth mindset. It's about basically the ability to continuously grow over time in one sentence is the whole idea is our skills, our abilities are malleable, we can completely develop them, we can build expertise and craft and mastery and it's really a mindset change. And Carol Dweck wrote the book, was also my wife's manager, and that's how we got into that.

**中文翻译:**
我手头一直有这三本。我喜欢基础，喜欢从基础开始学习。如果你是刚开启职业生涯的人，我的基础读物第一本是《终身成长》（Mindset）。它是关于成长型思维的。用一句话概括就是：我们的技能和能力是可塑的，我们可以完全开发它们，建立专业知识、手艺和精通，这本质上是一种心态的转变。作者 Carol Dweck 曾是我妻子的经理，这就是我们接触到这本书的原因。

---

**English:**
(00:59:38): So that's like our second religion at home. Second book is Thinking, Fast and Slow by Daniel Kahneman. I love behavioral economics. When I think about products, I think I always start from people, what is the member expectation? What are they trying to do? And this is the Bible for behavior. So if you're building front end products or even you're thinking about how you rally organization, it's an incredible book. Every page is like a stopper. You have to stop and think. And then lastly, and on the fundamental side is High Output Management by Andy Grove. It's like there's so much basics to doing good manager. It's like I think after you read this book, your managerial skills should start from a B. and then you can over time become an A. But beginning to a B is just a level of putting the effort in and knowing the best practices. So I think those are all fundamentally great books that I really like to give to people.

**中文翻译:**
(00:59:38): 这就像我们家的第二宗教。第二本书是丹尼尔·卡尼曼的《思考，快与慢》。我热爱行为经济学。当我思考产品时，我总是从人开始：会员的期望是什么？他们想做什么？这是行为学的圣经。如果你在构建前端产品，或者在思考如何动员组织，这是一本不可思议的书。每一页都值得停下来思考。最后，在基础管理方面，是安迪·格鲁夫的《高产出管理》。做一名优秀的经理有很多基础知识。我认为读完这本书后，你的管理技能应该能从 B 级起步，然后随着时间推移变成 A 级。但达到 B 级只需要付出努力并了解最佳实践。我认为这些都是非常棒的基础书籍，我非常喜欢送给别人。

---

### [01:00:41] Lenny Rachitsky

**English:**
That's awesome. I love that they're right there behind you. Is there a favorite recent movie or TV show you've really enjoyed?

**中文翻译:**
太棒了。我喜欢它们就在你身后。最近有没有什么你非常喜欢的电影或电视剧？

---

### [01:00:47] Tomer Cohen

**English:**
Yesterday I saw Bluey, you know Bluey? I love Bluey. So Bluey is this animation series from Australia and what's beautiful about it's, I can watch it with my six-year-old, nine-year-old and 12-year-old, and we're all going to enjoy it. We're all going to laugh at the same point but at the nuance of the jokes. It's like when I think about a product, the way Bluey is built, it's built for the whole family, but it's built as layers. There's layers of dialogue and points that they're trying to get across, and it's all packaged together into one experience. So for me, it's amazing that I could sit next to my six-year-old daughter, we would both laugh at this, it's a sweet animation kind of thing, it's like a family of dogs. And she would laugh at the nuance of the point, at a different nuance. For me it's like that's a genius creation of how you build a product.

**中文翻译:**
昨天我看了《布鲁伊》（Bluey），你知道吗？我超爱《布鲁伊》。这是一部来自澳大利亚的动画系列，它的美妙之处在于，我可以和 6 岁、9 岁和 12 岁的孩子一起看，我们都会乐在其中。我们会在同一个点大笑，但笑的是笑话中不同的微妙之处。当我思考产品时，《布鲁伊》的构建方式就像是分层的。它有不同层次的对话和想要传达的观点，全部打包成一个体验。对我来说，能和 6 岁的女儿坐在一起，我们都对着这个关于狗狗一家的温馨动画大笑，这太神奇了。她笑的是一个点，我笑的是另一个层面的微妙之处。对我来说，这就是如何构建产品的天才之作。

---

### [01:02:10] Lenny Rachitsky

**English:**
Do you have a favorite product that you've recently discovered that you really love, whether it's physical or in digital?

**中文翻译:**
你最近有没有发现什么非常喜欢的物理或数字产品？

---

### [01:02:17] Tomer Cohen

**English:**
So I like playing guitar. It's amateur, I'm not that good, but I love playing it. And there is a combination I've done recently I really like, there's a Spark Amp I have, which allows me to play with effects easily, but that's not what I use it for. I can tune my guitar based on the specific song I like. See, if I want to do Pink Floyd or Metallica or Nirvana or David Bowie, I can get that tune easily. I don't have to be an expert. I can just download the tune to my guitar, which is so great. And then I couple that with the, it's called the Ultimate Guitar app, and basically it doesn't give me the chords and the tabs, it gives me the other instruments, so I can get the drums going. I can get the, it's a violin going, whatever that is that's going in the band. As somebody who does not play so well and plays for itself and nobody's supposed to listen to how I'm playing because it's really just a way for me to enjoy my time. It's just an amazing, I would never get into any band, so this is the closest I can get to get to a band. So I love that combination.

**中文翻译:**
我喜欢弹吉他。我是业余的，弹得不算好，但我很喜欢。最近我尝试了一个非常喜欢的组合：我有一个 Spark 音箱（Amp），它让我能轻松使用各种音效，但我主要不是用它来调音效。我可以根据我喜欢的特定歌曲来调音。比如我想弹平克·弗洛伊德、金属乐队、涅槃乐队或大卫·鲍伊，我可以轻松获得那种音色。我不需要成为专家，只需把音色下载到吉他上，这太棒了。然后我把它和《Ultimate Guitar》App 结合使用，它不仅给我和弦和六线谱，还提供其他乐器的伴奏，所以我可以有鼓点、小提琴，或者乐队里的任何乐器。作为一个弹得一般、纯属自娱自乐的人，这太神奇了。我永远进不了真正的乐队，所以这是我能体验到的最接近乐队的感觉。我非常喜欢这个组合。

---

### [01:03:38] Lenny Rachitsky

**English:**
Do you have a favorite life motto that you often repeat yourself, find really useful in work or in life, share with folks?

**中文翻译:**
你有没有什么经常对自己重复、觉得在工作或生活中非常有用的座右铭？

---

### [01:03:38] Tomer Cohen

**English:**
From growth mindset there's a motto that I really like. It's called becoming is better than being. It's like the moment you think you achieved something is the moment you start to deteriorate down. It's like we're really trying to grow as human beings. We're trying to learn, we're trying to evolve. Product is a good example. I think the moment you think you actually mastered it is the moment that you become obsolete. So I love the idea that becoming is a better goal than continuously trying to reach some kind of level.

**中文翻译:**
在成长型思维中，有一句我非常喜欢的座右铭：“成长胜于成就”（Becoming is better than being）。就像你认为自己已经取得成就的那一刻，就是你开始走下坡路的那一刻。我们作为人类一直在努力成长、学习和进化。产品也是一个很好的例子：我认为当你觉得自己已经完全掌握它的那一刻，就是你变得过时的时候。所以我喜欢这个理念：不断成长是一个比不断试图达到某种水平更好的目标。

---

### [01:04:19] Lenny Rachitsky

**English:**
Final question, just to come back to LinkedIn. Is there a fun feature of LinkedIn people don't know about or should check out? Is there anything new that's like, oh, that's something you should try or that's something that might surprise you about LinkedIn these days?

**中文翻译:**
最后一个问题，回到 LinkedIn。有没有什么人们不知道或者应该去看看的有趣功能？有没有什么新东西让你觉得“噢，你应该试试这个”，或者现在 LinkedIn 有什么会让人感到惊讶的地方？

---

### [01:04:19] Tomer Cohen

**English:**
Maybe I'll give a couple so I don't have to pick the best right off the bat. But one right now, we're heavily invested in video and it's doing so well for those creators. We talked about it like immersive video we can actually come in. We talked about for us, video is obviously a best practice right now in the industry, but on LinkedIn, the right views really matter. So highly encourage creators to think about their video play at LinkedIn. And then I think what we call our coach experience in some cases is so powerful. For job seekers out there, we have people hired on LinkedIn, there's like seven folks hired every minute. Job seeking is a lonely journey.

**中文翻译:**
也许我多说几个，这样我就不用非得选出一个最好的。首先，我们现在在视频领域投入巨大，这对创作者来说效果非常好。我们谈到了沉浸式视频。对我们来说，视频显然是目前行业的最佳实践，但在 LinkedIn 上，“正确的观看”非常重要。所以我强烈建议创作者考虑在 LinkedIn 上发布视频。其次，我认为我们所谓的“教练体验”（Coach experience）在某些情况下非常强大。对于求职者来说——LinkedIn 上每分钟有 7 人被录用——求职是一段孤独的旅程。

---

**English:**
(01:05:02): I was actually in a session recently meeting with job seekers and I was talking to them and one started crying midway into the session because they said, "I cannot share my journey with anybody because I feel like I'm alone in this. People don't get how hard it is. I feel very accomplished, but I can't get the job. And I wish there was a buddy, I wish there was something that I could talk to brainstorm with who wouldn't judge me, who would just be trying to help me without paying hundreds of dollars to a coach of some sort. I don't have that money."

**中文翻译:**
(01:05:02): 我最近参加了一个求职者见面会，在交流中，一个人中途哭了起来，因为他们说：“我无法向任何人分享我的心路历程，因为我觉得只有我一个人在战斗。人们不理解这有多难。我觉得自己很有成就，但我就是找不到工作。我希望有一个伙伴，一个可以交流、头脑风暴且不会评判我的人，他只是想帮我，而不需要我支付几百美元去请教练。我没那么多钱。”

---

**English:**
(01:05:38): And in many ways, when we walked him through the job seeking experience, the coach experience, we build this coach aspect where you can go to any job and you can riff on the job with this really new realities LLM that is tailored to you, personalized to you, private to you, everything from your fit to how to best apply, to consulting about different opportunities, to comparing this to others, to feeling supported. So when we talk to people around, we always, I love to measure the impact of our work by emotion, when we talk to job seekers after that, it was basically the sense of I felt supported. In many ways, getting to that ability to remove the loneliness is amazing. It's a little bit like people need to, we're making it more and more visible and more and more ramped to everybody to a certain point. But that's a really powerful way to just humanize the job seeking experience for everybody.

**中文翻译:**
(01:05:38): 在很多方面，当我们带他体验求职流程和“教练体验”时，我们构建了这个教练功能：你可以查看任何职位，并利用这个为你量身定制、个性化且私密的全新大语言模型（LLM）来探讨该职位。从你的匹配度到如何最佳申请，从咨询不同机会到与其他职位进行比较，让你感到被支持。当我们与周围的人交谈时，我喜欢用情感来衡量工作的影响。在那之后与求职者交谈时，他们最基本的感觉是“我感到了支持”。在很多方面，能够消除孤独感是件了不起的事。我们正在让这个功能变得越来越可见，并逐步推广给所有人。这是一种让每个人的求职体验更具人性化的强大方式。

---

### [01:06:37] Lenny Rachitsky

**English:**
Awesome. And to find that it's just, is it called LinkedIn Coach or?

**中文翻译:**
太棒了。要找到它，它是叫“LinkedIn Coach”吗？

---

### [01:06:40] Tomer Cohen

**English:**
It's in the job. So if you go to the job tab on LinkedIn, actually just a few weeks ago, we just put it on the top. So you don't have to go to the specific job and find it, you can just start there and engage with it.

**中文翻译:**
它就在职位功能里。如果你去 LinkedIn 的“职位”选项卡，实际上几周前我们刚把它放在顶部。所以你不需要去特定的职位页面找它，直接在那里就可以开始互动。

---

### [01:07:01] Tomer Cohen

**English:**
Yeah. When I think about the future of AI in the sense of belief, that relationship is going to be sacred, the relationship between AI and the human is going to be [inaudible 01:07:10]. Do you know what Nomophobia means? It's the anxiety of being away from your phone. I think we all. I think we're in for AI-nophobia at that point, where you're going to get to a point where AI is going to feel so intimate, so personal that it would actually feel concerning to you to be away from it.

**中文翻译:**
是的。当我思考 AI 的未来信念时，那种关系将是神圣的，AI 与人类之间的关系将是……你知道“无手机恐惧症”（Nomophobia）是什么意思吗？就是离开手机产生的焦虑。我想我们都有。我认为到那时我们会面临“无 AI 恐惧症”，AI 会让你感到如此亲密、如此个性化，以至于离开它会让你感到不安。

---

### [01:08:07] Tomer Cohen

**English:**
Awesome. So obviously I'm on LinkedIn, reach out anytime. I read everything people send to me. I don't always reply to everything, but I read everything sent to me. And then if you want to go deep on AI first, I have two courses, they're free. I think it's a phenomenal way for you to build or starting to build your expertise, especially if you're in product. It's a great way to go deeper and not just stay on the high level parts of things.

**中文翻译:**
太棒了。显然我一直在 LinkedIn 上，随时联系。我会阅读人们发给我的所有内容。我不一定每条都回，但我都会看。如果你想深入了解“AI 优先”，我有两门免费课程。我认为这是建立或开始建立专业知识的绝佳方式，特别是如果你从事产品工作。这是一个深入钻研而不仅仅停留在表面层面的好方法。

---

### [01:08:36] Lenny Rachitsky

**English:**
Amazing. We'll link to all those things in the show notes. Tomer, thank you so much for being here.

**中文翻译:**
太棒了。我们会在节目介绍中附上所有链接。Tomer，非常感谢你能来。

---

### [01:08:40] Tomer Cohen

**English:**
Lenny. Thank you. It's our pleasure.

**中文翻译:**
Lenny，谢谢。这是我们的荣幸。

---

### [01:08:42] Lenny Rachitsky

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcasts.com. See you in the next episode.

**中文翻译:**
大家再见。非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现这个播客。你可以在 Lennyspodcasts.com 找到所有往期节目或了解更多信息。下期节目见。