# Tristan de Montebello - 双语对照

# Lenny's Podcast: Tristan de Montebello (Bilingual Transcript)

---

### [00:00:00] Tristan de Montebello

**English:**
People tend to get into a public speaking voice. We'll be in a class and they'll be chatting normally and look super normal. And then we'll say, "Okay, now just a timer, I'm just going to give you a speech. Just speak for 60 seconds so we get a baseline," and I click play, and suddenly I say, "The important part about doing this," and they enter into a different version of themselves, a professional version, whatever that would mean. It's so much more freeing, powerful, connecting, and effective to speak conversation. So the cue I often give people is—

**中文翻译:**
人们往往会陷入一种“演讲腔”。在课堂上，大家聊天时表现得非常自然。但当我们说：“好，现在计时开始，请做一个演讲。只需说 60 秒，我们要留个底稿（基准数据）。”当我按下播放键，他们突然就开始说：“关于这件事的重要部分是……”他们进入了另一个版本的自我，一个所谓的“专业版本”。其实，用谈话的方式去交流会让你感到更自在、更有力量、更有连接感且更有效。所以我经常给人们的提示是——

---

### [00:00:36] Lenny Rachitsky

**English:**
Today my guest is Tristan de Montebello. Tristan is the co-Creator of Ultraspeaking, which is the best public speaking workshop I have ever come across. In 2017, Tristan became the fastest competitor to reach the finals of the world championship of public speaking. And based on that experience, built a very unique course that helps you quickly build the skills to become better and to become more comfortable speaking in public, and especially speaking on the spot.

I'd like to spend time on this topic on this podcast because becoming a better speaker is such an accelerant of your professional life. And in this episode, we delve into a bunch of tactics and also misconceptions about how to become a better speaker, and to make it even more fun and interesting, we go through a few of the exercises that Tristan and his team have developed live on the podcast.

**中文翻译:**
今天的嘉宾是 Tristan de Montebello。Tristan 是 Ultraspeaking 的联合创始人，这是我见过的最好的演讲工作坊。2017 年，Tristan 成为世界演讲锦标赛历史上晋级决赛最快的选手。基于那段经历，他创建了一门非常独特的课程，帮助人们快速提升技能，在公众演讲、尤其是即兴演讲（speaking on the spot）时变得更加从容。

我之所以想在播客中讨论这个话题，是因为成为一名优秀的演说家是你职业生涯的“加速器”。在本期节目中，我们将深入探讨提升演讲能力的策略以及常见的误区。为了增加趣味性，我们还会在播客中现场演示 Tristan 和他的团队开发的一些练习。

---

### [00:01:51] Lenny Rachitsky

**English:**
So I took an abridged version of this speaking course that you teach called Ultraspeaking, and it immediately made me feel more comfortable public speaking, which I've never felt doing any other course. Public speaking is something it's just is very scary to me as it is for a lot of people, but it's just something I really dread. Even doing these podcast episodes, every time I get nervous before doing these things, as much as it may not seem that way. So this is not my natural habitat speaking, being in public. It may not seem that way to people, but it's true.

**中文翻译:**
我参加了你教的 Ultraspeaking 课程的精简版，它立刻让我对公众演讲感到更自在了，这是我在其他课程中从未有过的体验。公众演讲对我来说非常可怕，对很多人也是如此，但我真的是心存畏惧。即使是录制这些播客节目，每次开始前我都会紧张，尽管外人可能看不出来。所以，在公众面前讲话并不是我的“自然栖息地”（舒适区）。别人可能不这么认为，但事实确实如此。

---

### [00:05:49] Tristan de Montebello

**English:**
I actually think that the biggest misconception with tackling your speaking is that people grossly underestimate just how transformative it could be to your life. And the reason it's so transformative is because speaking is not a specialized skill, it's a meta skill. That means that the better you get at speaking, the better your life gets.

An example of a meta skill is fitness, for example. If you were to start saying, "Okay, I'm going to transform my fitness," and you start lifting weights and you start going on runs, obviously your muscles are going to get bigger... but that's actually only a sliver of the impact it's going to have on your life because you're going to start feeling more energy... For speaking, it's the same thing.

**中文翻译:**
我认为在应对演讲问题时，最大的误区是人们严重低估了它对生活的改变程度。之所以具有如此大的变革性，是因为演讲不是一项专门的技能，而是一项“元技能”（meta skill）。这意味着你的演讲能力越强，你的生活质量就越高。

元技能的一个例子是健身。如果你开始说：“我要改变我的身体素质”，然后开始举重、跑步，显然你的肌肉会变大……但这只是对生活影响的一小部分，因为你会感到精力更充沛。演讲也是一样的道理。

---

### [00:08:12] Tristan de Montebello

**English:**
The thing is, over the course of our life, because of all these little situations that happen, we start getting bugs in the software and we're not really upgrading our software. The moment you get the bugs and things start working, not working, we start avoiding, and suddenly it's like we're not upgrading our software anymore. So we're stuck on old, buggy software. But the reality is, let's not forget that we have incredible software that were evolved for this. So all we need to do is some debugging and some upgrading of the software and suddenly your entire life can change.

**中文翻译:**
问题在于，在我们的成长过程中，由于经历的各种小状况，我们的“软件”开始出现漏洞（bugs），而我们并没有真正去升级它。一旦出现漏洞，事情变得不顺，我们就开始逃避，突然间我们就不再升级软件了。于是我们被困在了陈旧且充满漏洞的软件中。但现实是，别忘了我们拥有为了沟通而进化的卓越“硬件”。所以我们只需要进行一些调试（debugging）和软件升级，突然间你的整个生活都会随之改变。

---

### [00:09:26] Tristan de Montebello

**English:**
I see enjoyment as a barometer, if I'm doing things right, I'm probably enjoying myself. If I'm doing things wrong, particularly with speaking, because again, this is something we're naturally evolved to do. So if we're naturally evolved to do it, it's not something that we dislike doing. It has to be something that rewards us. So as soon as things start not feeling enjoyable, it's a sign, hey, I'm probably doing this wrong, guy. There's something here that I'm doing that is making this unenjoyable that's probably not helping me.

**中文翻译:**
我把“享受”看作一个晴雨表（衡量标准）。如果我做对了，我可能会乐在其中。如果我做错了，特别是在演讲方面，因为这是我们天生进化的本能。既然是天生的，那就不应该是我们讨厌的事，它必须是能给我们带来回报的事。所以，一旦你觉得过程不快乐，这就是一个信号：嘿，伙计，我可能做错了。我做的某些事情让这件事变得无趣，而且可能对我没有帮助。

---

### [00:12:25] Tristan de Montebello

**English:**
The day I understood that speaking was a subconscious flow-oriented process and not a conscious process, completely changed the way I approached it. So instead of thinking tactics and frameworks and adding more to the outside of the things I need to think about, when I realized when I speak best, I'm actually not thinking about speaking. It's the last thing I think about is the speaking part. I'm completely in tune with whatever it is I'm trying to convey to my audience or the person in front of me. And the goal is to get into a flow state and stay in that flow state all the way through the finish line.

**中文翻译:**
当我意识到演讲是一个潜意识的、心流导向（flow-oriented）的过程，而不是一个意识控制的过程时，我对待它的方式彻底改变了。我不再去想战术、框架，或者在脑子里增加更多负担。我意识到，当我表现最好时，我其实根本没在想“演讲”这件事。演讲本身是我最后才会考虑的事。我完全沉浸在想要传达给观众或面前那个人的内容中。目标是进入“心流状态”，并一直保持这种状态直到结束。

---

### [00:15:47] Tristan de Montebello (Tactics: Think Up)

**English:**
The first makes you look better... when I am trying to gather my thoughts or think, people tend to look down. And if you're looking down on Zoom, it's three times as bad because it looks like you're looking at your phone... If instead you switch that up and you start thinking up. I think up into the right... as long as you're looking up, you actually look thoughtful by default. That means you look more confident because anybody who'd be willing to pause in their speaking is somebody who's confident.

**中文翻译:**
第一个技巧能让你看起来更好……当我试图理清思绪或思考时，人们往往会向下看。如果你在 Zoom 会议上向下看，效果会差三倍，因为看起来像是在看手机。相反，如果你换个方式，开始“向上思考”。我习惯向右上方看。只要你向上看，你默认就会显得很有深度。这意味着你看起来更自信，因为任何愿意在演讲中停顿思考的人都是自信的人。

---

### [00:18:53] Tristan de Montebello (Tactics: End Strong)

**English:**
In speaking, it's the same thing. People tend to give a great answer and then either they kind of taper off at the end, which doesn't leave you with a good impression, or they'll actively say the doubts that are coming up in their mind... "I don't really know if that makes sense."

A simple tactic here is, anticipate that as you get to the end... some of those uncertainties are going to pop up. Know that it's coming and make sure you land the plane. You can use summary prompts... "So to wrap up..." and your brain's going to fill in the gap. Or, "In summary, so my point here is..." and your brain's naturally going to do the work of closing it for you.

**中文翻译:**
演讲也是如此。人们往往给出了精彩的回答，但最后要么声音越来越小（虎头蛇尾），没留下好印象；要么会主动说出脑子里冒出的疑问，比如：“我不太确定这是否有意义。”

这里有一个简单的策略：预见到当你接近尾声时，不确定感会冒出来。知道它会来，并确保“让飞机稳稳落地”。你可以使用总结性提示词，比如：“所以总结一下……”你的大脑会自动补全后面的内容。或者说：“总而言之，我的观点是……”你的大脑会自然地帮你完成收尾工作。