# Uri Levine 2.0 - 双语对照

This is the complete bilingual transcript for **Lenny’s Podcast** featuring **Uri Levine**.

---

### [00:00:00] Lenny Rachitsky

**English:**
Let's talk about crisis. I think it might be helpful to do a quick taxonomy of the types of crisis founders face.

**中文翻译:**
我们来聊聊危机。我想对创始人面临的危机类型做一个快速的分类（taxonomy）可能会很有帮助。

---

### [00:00:05] Uri Levine

**English:**
So two, abstractly, two types of crisis. One is I would call that a cash crisis. All of a sudden, your cash program or plan is being jeopardized, losing a customer, disappearing investor. And the other one is lose of product market fit. When product market fit disappear, you actually need to go back to square one. Then you basically say everything that I know so far is irrelevant anymore.

**中文翻译:**
从抽象层面来说，有两种类型的危机。一种我称之为“现金危机”。突然之间，你的现金计划或方案受到了威胁，比如失去了一个大客户，或者投资人撤资了。另一种是失去“产品市场契合度”（Product Market Fit, PMF）。当 PMF 消失时，你实际上需要回到原点。那时你基本上得承认，到目前为止我所知道的一切都不再适用了。

---

### [00:00:31] Lenny Rachitsky

**English:**
You also talk along these lines of never give up in a crisis and throughout your journey.

**中文翻译:**
你也提到过，在危机中以及整个创业过程中，都要坚持“永不言弃”。

---

### [00:00:35] Uri Levine

**English:**
Always keep on looking for ways to make it work. Never give up is the most important behavior of successful CEOs of startup. The second one, by the way, is making decisions with conviction. If you don't make them with conviction, then the team is not going to follow. If the team is not going to follow, then you are not going to be successful.

**中文翻译:**
要永远寻找让事情转危为安的方法。“永不言弃”是成功的初创公司 CEO 最重要的行为特质。顺便说一下，第二个特质是“带着坚定的信念做决定”。如果你做决定时没有信念，团队就不会跟随你。如果团队不跟随你，你就不会成功。

---

### [00:00:52] Lenny Rachitsky

**English:**
The core part of your advice on crisis, it's always the founders fault if things don't work out.

**中文翻译:**
你关于危机的核心建议之一是：如果事情进展不顺利，那永远是创始人的错。

---

### [00:00:57] Uri Levine

**English:**
At the end of the day, you cannot rely on someone else, you have only one company, you need to make sure that this company is successful. When you assume responsibility, you're basically saying, "You know what, I control my own destiny."

**中文翻译:**
归根结底，你不能指望别人。你只有这一家公司，你需要确保这家公司获得成功。当你承担起责任时，你基本上是在说：“听着，我掌控着自己的命运。”

---

### [00:01:11] Lenny Rachitsky

**English:**
Any advice for how to avoid falling into a crisis as a founder?

**中文翻译:**
对于创始人如何避免陷入危机，你有什么建议吗？

---

### [00:01:14] Uri Levine

**English:**
Number one answer is no, don't worry, you will face crisis.

**中文翻译:**
头号答案是：没办法避免。别担心，你肯定会遇到危机的。

---

### [00:01:21] Lenny Rachitsky

**English:**
Today, my guest is Uri Levine. Uri is the co-founder of Waze, along with nine other companies. He's sold two companies for over a billion dollars, he's been on 20 different startup boards, has been an advisor to over 50 different startups. And even more impressively, this is his second time on the podcast.
(00:01:39):
In our first conversation, we walked through the biggest lessons that he's learned over the course of working with all of these different startups that he chronicled in his beloved book, Fall in Love with the Problem, Not the Solution. In this conversation, we go deep on one very specific topic, crisis. As Uri shares in his book, building a startup is a journey from one crisis to the next. And my goal with this conversation is to give you tools to handle the next crisis and the next crisis and the next crisis that you face as a founder. This topic is so important that Uri decided to update and re-release his book with a whole new chapter dedicated to managing crisis. And this new edition is actually going to launch right around the time this episode launches.
(00:02:17):
If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube, it's the best way to avoid missing future episodes and it helps the podcast tremendously. With that, I bring you Uri Levine.

**中文翻译:**
今天的嘉宾是 Uri Levine。Uri 是 Waze 的联合创始人，此外还创办了另外九家公司。他以超过 10 亿美元的价格卖掉了两家公司，曾担任 20 家不同初创公司的董事，并担任过 50 多家初创公司的顾问。更令人印象深刻的是，这是他第二次来到本播客。
(00:01:39):
在我们的第一次对话中，我们梳理了他从这些初创公司中学到的最深刻教训，这些内容都记录在他备受推崇的著作《爱上问题，而非解决方案》（Fall in Love with the Problem, Not the Solution）中。在这次对话中，我们将深入探讨一个非常具体的话题：危机。正如 Uri 在书中所分享的，创办一家公司就是从一个危机走向下一个危机的旅程。我希望通过这次对话，能为你提供工具，去应对作为创始人将面临的一个又一个危机。这个话题非常重要，以至于 Uri 决定更新并重新发行他的书，专门增加了一个关于危机管理的全新章节。新版本实际上将在本集节目发布前后推出。
(00:02:17):
如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注，这是避免错过未来节目的最好方式，也对我们帮助巨大。下面，让我们欢迎 Uri Levine。

---

### [00:02:30] Lenny Rachitsky (Ad Segment - WorkOS)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning... [Ad content continues]

**中文翻译:**
本集节目由 WorkOS 赞助。如果你正在构建 SaaS 应用，你的客户迟早会要求 SAML 身份验证和 SCIM 配置等企业级功能…… [广告内容省略，主要介绍 WorkOS 的企业级 API 和最近收购的 Warrant 授权服务]

---

### [00:03:49] Lenny Rachitsky (Ad Segment - Rippling)

**English:**
This episode is brought to you by Rippling, a single platform to build and scale your startup on. Rippling handles all the can't get it wrong admin work of payroll and benefits... [Ad content continues]

**中文翻译:**
本集节目由 Rippling 赞助，这是一个用于构建和扩展初创公司的统一平台。Rippling 处理所有不容出错的薪酬和福利行政工作…… [广告内容省略，主要介绍 Rippling 在入职、IT 管理和人力资源方面的自动化功能]

---

### [00:05:03] Lenny Rachitsky

**English:**
Uri, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Uri，非常感谢你能来，欢迎来到播客。

---

### [00:05:06] Uri Levine

**English:**
Thank you. I'm really happy to be here.

**中文翻译:**
谢谢，很高兴来到这里。

---

### [00:05:08] Lenny Rachitsky

**English:**
I should have said welcome back to the podcast, this is your second time here, which is a pretty rare feat. And the reason that you're back is, the first time we chatted in depth about your amazing book. I have it right here, Fall in Love with the Problem, Not the Solution. And you decided to re-release the book recently with a new chapter about something that every single founder is going to go through. You actually have this quote I'll read that I think is a good summary of why this is so important. "That building a startup is a journey from one crisis to the next." Let me just start with this question of why did you decide to add this chapter, why is it so important to update your book?

**中文翻译:**
我应该说欢迎回到播客，这是你第二次来，这可是个罕见的成就。你再次回来的原因是，上次我们深入探讨了你那本精彩的著作。我手里就拿着这本《爱上问题，而非解决方案》。你最近决定重新发行这本书，并增加了一个每个创始人都会经历的新章节。你有一句名言，我觉得很好地总结了其重要性：“创办初创公司是从一个危机走向下一个危机的旅程。”我想先问一下，你为什么决定增加这一章？为什么更新这本书如此重要？

---

### [00:05:43] Uri Levine

**English:**
End of the day, recent years have demonstrated major significant crisises throughout the world, from Covid to interest rate, to inflation, to wars. And then I realized that wait a minute, this is something that I haven't spoke about during my first book and it's time to write a new edition to that or a new chapter that will be added into the new release. And so this is about crisis. And in addition, my publisher told me that, "Oh, you should have a paperback, it's going to sell more and more people are going to read it because it's easier to read." So I do have the new edition already.

**中文翻译:**
归根结底，最近几年全世界都经历了重大危机，从新冠疫情到利率上升，再到通货膨胀和战争。我意识到，等一下，这是我在第一版书中没有谈到的内容，是时候写一个新版本或增加一个新章节了。所以这就是关于危机的。此外，我的出版商告诉我：“你应该出一个平装本，它会卖得更好，更多人会读，因为读起来更方便。”所以我已经准备好了新版本。

---

### [00:06:25] Lenny Rachitsky

**English:**
There is?

**中文翻译:**
已经有了？

---

### [00:06:26] Uri Levine

**English:**
It will be published in about a month and it does include a new chapter. And it's a paperback.

**中文翻译:**
大约一个月后出版，包含新章节，而且是平装本。

---

### [00:06:34] Lenny Rachitsky

**English:**
I love that you're solving the jobs to be done, make it easier to read, we'll make it paperback. I also, as you described it, it made me realize the reason your book is so great is it's basically a step-by-step guide of all the things you need to know about building a successful company. And what it feels like is you just realize, oh, I forgot this step that every founder goes through, which is crisis.

**中文翻译:**
我喜欢你这种解决“待办任务”（jobs to be done）的方式——为了让阅读更轻松，就出平装本。正如你所描述的，我意识到你的书之所以伟大，是因为它基本上是一份关于建立成功公司的分步指南。感觉就像是你突然意识到：“噢，我漏掉了每个创始人都会经历的一步，那就是危机。”

---

### [00:06:54] Uri Levine

**English:**
Multiple crisis.

**中文翻译:**
是多次危机。

---

### [00:06:55] Lenny Rachitsky

**English:**
Multiple crisis, we'll get into that. Also, I love that you can actually update a book. Usually people are like, "Oh, books, done." You move on. I love that you have the opportunity actually to update a book. That's inspiring.

**中文翻译:**
多次危机，我们待会儿细聊。另外，我很喜欢你可以更新一本书这一点。通常人们觉得“书写完了就完了”，然后就去做别的事了。我很喜欢你有机会去更新它，这很令人振奋。

---

### [00:07:08] Uri Levine

**English:**
I'm already thinking of the next one.

**中文翻译:**
我已经在考虑下一本了。

---

### [00:07:11] Lenny Rachitsky

**English:**
The next book or the next update to the book?

**中文翻译:**
是下一本书，还是这本书的下一次更新？

---

### [00:07:15] Uri Levine

**English:**
Not sure yet, not sure. Look, at the end of the day, there is a reason for me to write the book. I wrote the book in order to make a bigger impact. I'm an entrepreneur and everyone knows that, so I built Waze and Moovit and dozens of other startups, but I'm also a teacher. So I feel equally rewarded when I build something myself or I guide someone to build it. And the book is fulfilling my destiny as a teacher, sharing my know-how with entrepreneurs, with business people, with pretty much everyone to help them to become more successful.
(00:07:50):
So the realization that what I really want is people to take out of the book is something that will increase their likelihood of being successful. And the next book is going to be pretty much the same, with the same philosophy of wait a minute, if I can make a bigger impact, I would like to make a bigger impact.

**中文翻译:**
还不确定。听着，归根结底，我写书是有原因的。我写书是为了产生更大的影响力。我是个创业者，大家都知道这一点，我创办了 Waze、Moovit 和几十家其他初创公司，但我也是一名老师。所以，当我亲手建立一些东西，或者指导别人去建立时，我感到的成就感是一样的。这本书履行了我作为老师的使命，向创业者、商务人士以及几乎所有人分享我的诀窍，帮助他们变得更成功。
(00:07:50):
所以我意识到，我真正希望人们从书中获得的是能增加他们成功概率的东西。下一本书也会差不多，秉持同样的哲学：如果我能产生更大的影响，我就想去尝试。

---

### [00:08:13] Lenny Rachitsky

**English:**
It's a beautiful mission. I think we're going to do that. Let's talk about crisis. Maybe to make this very real and visceral for people to get a sense of, you hear the word crisis, you're like, oh yeah, sure. Can you maybe share a story of a crisis that you experienced that might be illustrative of the types of crisis that founders face across the many companies you've started and advised, what comes to mind?

**中文翻译:**
这是一个美好的使命。我想我们会实现的。让我们来谈谈危机。为了让大家有更真实、更直观的感受——毕竟听到“危机”这个词，大家可能只是觉得“哦，当然”。你能分享一个你经历过的危机故事吗？这个故事可以说明创始人在你创办和指导的众多公司中可能面临的危机类型。你首先想到的是什么？

---

### [00:08:34] Uri Levine

**English:**
Covid was an excellent example. And one of my startups back then, called Order.chat, and actually it was the first AI chat back in 2020. And that was meant to help people to make reservations to restaurants. As simple as, "Oh, I would like to make a reservations for six people for tomorrow night at XYZ restaurant." And that chat was actually very, very successful in Israel. And the reason is that we actually built an engine that had facing the user with a chat but also facing the restaurant with a chat. So we did not require any integration, we could go online anywhere and actually cover all the restaurants in no time. And that turned out to be pretty successful and then Covid hit. And guess what? All the restaurants were shut down for hosting guests and there were no more reservations for restaurants.
(00:09:41):
Now we were really good at that, but we did not have enough funding to actually pivot into something completely different. And the result is that we had to shut it down. And still people still ask me what happened to that? What happened to that was Covid.

**中文翻译:**
新冠疫情就是一个极好的例子。我当时创办的一家公司叫 Order.chat，实际上它是 2020 年时最早的 AI 聊天机器人之一。它的目的是帮助人们预订餐厅。就像说一句“我想预订明天晚上 XYZ 餐厅六个人的位子”那么简单。这个机器人在以色列非常成功。原因是我们的引擎不仅面向用户提供聊天界面，也面向餐厅提供聊天界面。所以我们不需要任何系统集成，可以随时上线并迅速覆盖所有餐厅。这原本非常成功，直到疫情爆发。你猜怎么着？所有餐厅都停止堂食了，再也没有餐厅预订这回事了。
(00:09:41):
虽然我们在这方面做得很好，但我们没有足够的资金转型（pivot）去做完全不同的事情。结果就是我们不得不关闭它。现在还有人问我那家公司怎么了？答案就是：遇到了新冠。

---

### [00:10:13] Lenny Rachitsky

**English:**
I feel like Covid happened to a lot of companies. And it feels like that's kind of an impetus to this chapter. I think you even said that, it created so many crisis across so many companies you were involved with, helped you realize a lot of companies and founders are just not prepared.

**中文翻译:**
我觉得很多公司都遭遇了新冠。这似乎是你写这一章的动力。你甚至说过，它在你参与的众多公司中引发了如此多的危机，让你意识到很多公司和创始人根本没有准备好。

---

### [00:10:39] Uri Levine

**English:**
So by and large I would say end of the day, we look at the global crisises and we say, "Oh, this is going to impact an industry." But as an entrepreneur, you don't care about the industry, you care about your own startup, that's it. And if the rest of the world is suffering from the same problem, doesn't help you, not even a single bit. So your problem is your problem, that's it.
(00:10:39):
And then you need to abstract that and basically realize, okay, wait a minute, I will define a crisis as something that you already had that is significant, disappears. So let's say that you already have millions of dollars in revenues and all of a sudden your biggest customer decide not to continue and you lose half of your revenues. All of a sudden you basically say, "Wait a minute, I have to adapt, something significant happened."
(00:11:10):
And that something significant is that your revenues disappear or maybe your funding disappeared or maybe ... So in general, the first type of crisis will be around cash. All of a sudden your cash is not the same as you expected, something happened, maybe funding, maybe revenues, maybe projection, maybe you lost a big customers, a cash crisis. And then you need to adapt.

**中文翻译:**
总的来说，当我们看全球性危机时，我们会说：“哦，这会影响整个行业。”但作为一名创业者，你不关心行业，你只关心你自己的初创公司，仅此而已。如果全世界都在遭受同样的问题，那对你一点帮助也没有。所以，你的问题就是你的问题。
(00:10:39):
然后你需要将其抽象化并意识到：我将危机定义为“你已经拥有的重要东西消失了”。假设你已经有了数百万美元的收入，突然间你最大的客户决定不再续约，你失去了一半的收入。突然之间你会说：“等一下，我必须做出调整，发生了重大的事情。”
(00:11:10):
这个“重大的事情”可能是收入消失，也可能是融资断裂，或者……总之，第一类危机是围绕“现金”的。突然间你的现金状况和预期不一样了，出事了，可能是融资、收入、预测出了问题，或者是失去了一个大客户。这就是现金危机，然后你需要做出调整。

---

### [00:11:43] Uri Levine

**English:**
The second one, which is even more significant, is that you lost product market fit. And that might happen, it might happen because of regulations, because of competition, because of something dramatic happened that there is no more value into your product. And we are going back to basic, product market fit is very simple. That means that you create value to your customers, this is what it is. And you never heard of a company that did not figure out product market fit. They simply died, that's it.
(00:12:20):
And by the way, product market fit in general have only one metric, only one metric, retention. Look, it's really simple, if you create value, they will come back, that's it. If they are not coming back, that means that you are not creating value. And so in your startup journey, this is going to be the first phase, and it's going to require a lot of iterations and it's a journey of failures. So we're going to try something and it doesn't work, we're going to try something else. And we keep on trying until we find one thing that does work.
(00:12:54):
But once you figure that out, you're ready to move to the next part of your journey. But what if it's all disappeared? What if all of a sudden someone changed their regulation? Someone you rely on, a very unique data, that you were able to build and all of a sudden someone create a way to access this data for everyone. What if there is a competitor that makes you irrelevant?

**中文翻译:**
第二种危机甚至更严重，那就是你失去了“产品市场契合度”（PMF）。这可能会发生，原因可能是监管变化、竞争，或者发生了某些戏剧性的事情，导致你的产品不再有价值。我们回到最基本的概念：PMF 非常简单，就是你为客户创造了价值。你从未听说过哪家公司没搞定 PMF 还能活下来的，它们直接就倒闭了。
(00:12:20):
顺便说一下，PMF 通常只有一个衡量指标：留存率（retention）。这很简单，如果你创造了价值，用户就会回来。如果他们不回来，说明你没有创造价值。在你的创业旅程中，这是第一阶段，需要大量的迭代，这是一个充满失败的旅程。我们会尝试一些东西，不行，再试别的。我们不断尝试，直到找到行得通的那一个。
(00:12:54):
一旦你搞定了这一点，就可以进入旅程的下一阶段。但如果这一切都消失了呢？如果突然有人改变了监管政策呢？或者你依赖的某种独特数据，突然有人发明了一种让所有人都能访问这些数据的方法。如果出现了一个让你变得无足轻重的竞争对手呢？

---

### [00:13:22] Uri Levine

**English:**
I'm using iPhone, obviously a lot of people using iPhone and I'm using that for a long while. iPhone is born in 2007. Before that we used to have different phones with keypads. And when iPhone was introduced, Microsoft basically say this will never work. They were in a position of a market leader, they own Windows mobile operating system that was running on pretty much all the phones in the world. All the smartphones in the world, from Nokia to Motorola, to Samsung, to pretty much everything. And they look at it and say this will never work. They haven't realized how impactful it is. So this is a competition coming out to the market with something that is completely different. And not only disrupt the market but actually create crisis for pretty much everyone else.
(00:14:15):
And the result is that today Microsoft is not a player in the mobile operating system and Nokia disappeared or pretty much disappeared and Motorola disappeared and pretty much everyone that was really significant in this industry, they were not adapted fast enough to the change. And the change was that their product market fit disappeared. Now it's not that their product all of a sudden become irrelevant, people simply wanted something else.

**中文翻译:**
我用的是 iPhone，显然很多人都在用，我也用了很久。iPhone 诞生于 2007 年。在那之前，我们用的是带键盘的各种手机。当 iPhone 推出时，微软基本上说“这行不通”。他们当时是市场领导者，拥有 Windows Mobile 操作系统，运行在当时世界上几乎所有的手机上。从诺基亚到摩托罗拉，再到三星，几乎涵盖了所有智能手机。他们看着 iPhone 说这行不通，没意识到它的影响力有多大。这就是竞争对手带着完全不同的产品进入市场，不仅颠覆了市场，还给几乎所有人带来了危机。
(00:14:15):
结果是，今天微软在移动操作系统领域已经出局了，诺基亚消失了（或者说基本消失了），摩托罗拉也消失了，几乎所有在这个行业曾经举足轻重的人，都没有足够快地适应变化。而这个变化就是他们的 PMF 消失了。并不是说他们的产品突然变得一无是处，而是人们想要别的东西了。

---

### [00:15:25] Uri Levine

**English:**
It can be also a matter of regulation change. One of my startups called Fibo died because of change in regulation. So Fibo was doing tax returns, something that everyone hates, but we have to do that. And when we started we basically say wait a minute, when I speak with people and ask them how is tax returns being done in your country, what I heard was pretty consistent, it's either complex or expensive or both, that's it. And I said wait a minute, what if I can simplify that? What if we can make it really, really simple?
(00:16:08):
And we define simplification by filing in less than five minutes. Whatever you do, if you can do that in less than five minutes, it's simple enough. And we ended up with building a platform in Israel that people were able to file in less than three minutes. And that was actually pretty amazing. Now the result was that in about ... In Israel filing is not mandatory. So we actually enable people that were not filing up until now to file because it's simple. And we increased the size of the market by 25% over one year.

**中文翻译:**
危机也可能是监管变化引起的。我的一家名为 Fibo 的初创公司就因为监管变化而倒闭了。Fibo 做的是退税业务，这是每个人都讨厌但又不得不做的事。当我们开始时，我问人们在你们国家退税是怎么做的，听到的回答非常一致：要么复杂，要么昂贵，或者两者兼而有之。我说，等一下，如果我能简化它呢？如果能把它变得非常非常简单呢？
(00:16:08):
我们将“简化”定义为在五分钟内完成申报。无论你怎么做，只要能在五分钟内完成，就足够简单。我们最终在以色列建立了一个平台，人们可以在不到三分钟内完成申报。这真的很了不起。结果是……在以色列，申报并不是强制性的。所以我们实际上让那些以前不申报的人开始申报了，因为太简单了。我们在一年内将市场规模扩大了 25%。

---

### [00:16:42] Lenny Rachitsky

**English:**
Of people filing taxes?

**中文翻译:**
申报税款的人数增加了 25%？

---

### [00:16:43] Uri Levine

**English:**
Yep. Because it was simple. So you go into the platform, you realize that wait a minute, I actually entitled to get a return, so let me file. If I'm not entitled to get a return, then I'm not going to file because it's not mandatory. And the result is that we increased the load of the taxation system. And all of a sudden the Israeli tax authority didn't like us anymore and they basically shut us down. So changing the regulation and we lost product market fit overnight. They basically say, "Oh, we are going to shut you down and that's tomorrow." And that's it.
(00:17:22):
Now we did not have enough run rate to actually ... because the company was about break even, so we did not have enough funding to go and try to find something else. And we tried to fight the regulator, but fighting regulator requires a long period of time and a lot of funding and we did not have that.

**中文翻译:**
是的。因为简单。你进入平台，发现“等一下，我其实有资格获得退税，那我就申报吧”。如果没资格退税，因为不是强制的，我就不申报。结果是我们增加了税务系统的负荷。突然之间，以色列税务局就不喜欢我们了，他们基本上把我们关停了。监管一变，我们一夜之间失去了 PMF。他们基本上说：“我们要关掉你们，就在明天。”就这样结束了。
(00:17:22):
当时我们没有足够的资金跑道（run rate）去……因为公司刚达到盈亏平衡，我们没有足够的资金去尝试别的东西。我们试过和监管机构抗争，但那需要很长时间和大量资金，而我们没有。

---

### [00:17:49] Uri Levine

**English:**
So regulation might be a reason why you lose product market fit. And you need to go back to square one. And what we decided is that, okay, what I decided on a personal level is that I'm not going deal with the regulation anymore. I don't want to rely on a regulator to allow me or not allow me to do what I want to do.
(00:18:16):
By the way, with Waze, in the early days we thought that the business model is going to be selling data to authorities, to municipalities, to maybe public transportation systems and so forth. And we basically say wait a minute, we have the best traffic information in the world, I can go to a municipality and tell them how long does it take to make a left turn in each and every traffic light in the city every day of the week, every hour of the day. And therefore they can recalibrate the traffic control system and enable better utilization of the entire road system. And it turns out that this is really, really, really slow business development process. They didn't really care. And that was frustrating. Even if you offer that for free they still don't care. And the result is that we changed the business model and we ended up with advertisement. But the reality is that I don't like to work with regulators, that is all.

**中文翻译:**
所以监管可能是你失去 PMF 的原因，你需要回到原点。我们当时的决定是——或者说我个人决定——我再也不想和监管打交道了。我不想依赖监管机构来允许或不允许我做我想做的事。
(00:18:16):
顺便说一下，在 Waze 早期，我们以为商业模式是向政府部门、市政当局或公共交通系统出售数据。我们当时想，我们拥有世界上最好的交通信息，我可以去市政厅告诉他们，在这个城市的每一个红绿灯处，在一周的每一天、一天的每一个小时，左转需要多长时间。这样他们就可以重新校准交通控制系统，提高整个道路系统的利用率。结果发现，这是一个极其缓慢的业务开发过程。他们根本不在乎。这很令人沮丧，即使你免费提供，他们还是不在乎。结果我们改变了商业模式，最终转向了广告。但现实就是，我不喜欢和监管者打交道，仅此而已。

---

### [00:19:20] Lenny Rachitsky

**English:**
Okay. There's so much here I want to dig into. One is this example, this story about losing product market fit, it reminds me of, I had Drew Houston on the podcast, the founder of Dropbox, and he described a moment where when Apple launched Apple Photos or iCloud, I think it was iCloud, he's like, "It's as if there's this mushroom cloud exploding far in the distance that you don't hear for a long time and we didn't necessarily see exactly how much this will have impacted our business." And I think that's what happens a lot of cases. You see something happen and you're like, "No, this is no problem, we're going to win anyway." Like Blackberry I think did the same thing with iPhone.

**中文翻译:**
好的，这里有很多我想深入探讨的内容。首先是关于失去 PMF 的例子，这让我想起我曾邀请 Dropbox 创始人 Drew Houston 上节目，他描述过一个时刻：当苹果推出 Apple Photos 或 iCloud（我想是 iCloud）时，他说：“就像远处有一朵蘑菇云爆炸了，你很久都听不到声音，我们当时并没有完全意识到这会对我们的业务产生多大的影响。”我觉得很多情况都是这样。你看到某些事情发生，然后想：“没问题，我们还是会赢的。”我想黑莓对 iPhone 的反应也是如此。

---

### [00:20:01] Uri Levine

**English:**
We had the same thing with Waze, because when we started Waze was free and it was the only one that was offering turn-by-turn navigation free. And the reason is that we created our own maps. And then one day in 2010, Google announced their free turn-by-turn navigation. Turns out that they were working for the last two years in building maps of the US. And they enabled that on Google Maps, turn-by-turn navigation with audio guidance to turn right, turn left and so forth.
(00:20:38):
And two companies were actually shocked, the entire industry, but two companies were impacted. The first one is actually TomTom. TomTom was the provider of the maps for Google to do navigation. And they basically say, "No, we have our own maps, we are going to terminate the contract." And TomTom said, "Wait a minute, you are paying us $18 million a year and we have five years contract." And Google say, "Yeah, we will keep on paying you that amount of money that we are committed, but we are not going to use your product anymore."
(00:21:11):
And that one was Waze because basically everyone in the industry told us that we are doomed. Our own investors told us that, "Look, if we can sell the company for $20 or $30 million today, do it because you are not going to be successful."

**中文翻译:**
Waze 也遇到过同样的情况。我们刚开始时 Waze 是免费的，而且是唯一提供免费语音导航（turn-by-turn navigation）的产品，因为我们创建了自己的地图。然后在 2010 年的某一天，谷歌宣布了他们的免费语音导航。原来他们在过去两年里一直在构建美国地图。他们在谷歌地图上启用了语音引导的导航功能，比如右转、左转等。
(00:20:38):
当时有两家公司被震惊了——其实是整个行业，但有两家受影响最大。第一家是 TomTom。TomTom 曾是谷歌导航地图的供应商。谷歌基本上说：“不，我们有自己的地图了，我们要终止合同。”TomTom 说：“等一下，你们每年付给我们 1800 万美元，我们有五年的合同。”谷歌说：“是的，我们会继续支付承诺的金额，但我们不再使用你们的产品了。”
(00:21:11):
另一家就是 Waze，因为当时行业里几乎所有人都告诉我们，我们完蛋了。我们自己的投资者也告诉我们：“听着，如果今天能以 2000 万或 3000 万美元的价格把公司卖掉，那就卖吧，因为你们不会成功的。”

---

### [00:21:27] Uri Levine

**English:**
Now obviously we turned the corner and turned out to be very successful. And to that level that eventually Google acquired us. And the reason is that the use case was different. Waze was focusing on the daily commuters. So we wanted people to use our application twice a day, when you go to the office and when you come back home. And Google Maps is something that you are being used not that frequent, you are in general I would say if I ask a hundred people how often they use Waze, they will tell me every day. If I ask them how often they use Google Maps, they will tell me, "When I need it." So a different use case and obviously different product that is built for the specificity of the use case. So Waze is way simpler and the map looks almost abstractive, they're not, but looks like abstractive and way less details. And the result is the ability to create something that is simpler and people are using every day.
(00:22:34):
But when Google announced turn-by-turn navigation, all the investors in the world turn their back on us. And that was 2010. We were looking for new funding. I remember that night, because we were just about to go and meet with all partners meeting at Khosla Ventures. And we had multiple meetings beforehand and that was like, okay, this is the final seal.

**中文翻译:**
显然，我们后来反败为胜，变得非常成功，最终甚至被谷歌收购了。原因是使用场景（use case）不同。Waze 专注于日常通勤者。我们希望人们每天使用两次我们的应用：上班时和回家时。而谷歌地图是你不会那么频繁使用的东西。总的来说，如果我问 100 个人他们多久用一次 Waze，他们会说“每天”。如果问他们多久用一次谷歌地图，他们会说“需要的时候才用”。所以这是不同的使用场景，显然产品也是针对特定场景构建的。Waze 要简单得多，地图看起来几乎是抽象的（其实不是，但看起来是），细节少得多。结果就是我们创造了一个更简单、人们每天都在用的东西。
(00:22:34):
但当谷歌宣布语音导航时，全世界的投资者都背弃了我们。那是 2010 年，我们正在寻找新一轮融资。我记得那个晚上，因为我们正准备去参加 Khosla Ventures 的合伙人全体会议。在那之前我们已经开过多次会了，那次会议本应是最后的敲定。

---

### [00:23:07] Uri Levine

**English:**
And the evening before we had dinner with the partners that was promoting us at Khosla Ventures and he told us, "Look, I have a lot of relationship in the industry, and I spoke with my friends at Google and they told me that they are at least two years away from building their own maps." And the next morning they simply announced this turn-by-turn navigation. Going to that meeting was a waste of time already. And we had very, very hard time to raise capital because of that.
(00:23:38):
But eventually we were lucky in the sense that once Google announced their turn-by-turn navigation, turns out that the rest of the industry were took by surprise. And Microsoft decided that wait a minute, we don't have our own maps, so let's invest in Waze. So we ended up getting investment from someone that we did not expect.

**中文翻译:**
就在前一天晚上，我们和在 Khosla Ventures 推荐我们的合伙人一起吃晚饭，他告诉我们：“听着，我在行业里有很多关系，我问过谷歌的朋友，他们说离建成自己的地图至少还有两年时间。”结果第二天早上，他们就宣布了语音导航。去参加那个会议简直是浪费时间。因为这件事，我们当时融资非常非常困难。
(00:23:38):
但最终我们很幸运，因为谷歌宣布语音导航后，行业里的其他人也措手不及。微软意识到：“等一下，我们没有自己的地图，那我们投资 Waze 吧。”所以我们最终从一个意想不到的对象那里获得了投资。

---

### [00:23:59] Lenny Rachitsky

**English:**
Okay. So first of all, you've shared all these types of crisis, I think it might be helpful to do a quick taxonomy of the types of crisis founders face. You shared regulation changes, competitors coming at you, investors not wanting to invest.

**中文翻译:**
好的。首先，你分享了这么多类型的危机，我想对创始人面临的危机做一个快速分类可能会很有帮助。你提到了监管变化、竞争对手的冲击、投资者不愿投资。

---

### [00:24:14] Uri Levine

**English:**
So two types of, abstractly, two types of crisis. One is that I would call that a cash crisis. So all of a sudden your cash program or plan is being jeopardized, for losing a customer, disappearing investor, not meeting your expectation, dramatic price change in the market and so forth. And the other one is lose of product market fit. So all of a sudden whatever you have is irrelevant anymore and you actually need to go back to square one.
(00:24:54):
For the first type of crisis, if this is a cash crisis, then what you really need to ask yourself, and in any type crisis, first of all is what is actually being impacted? Is that my run rate, is that my product, is that my revenue stream? If I'm still relevant?
(00:25:19):
With Order.chat, we were irrelevant, that's it. And so the first thing that you need to do is what is really being impacted? And then the second thing is how long it's going to last? Is that a temporary thing? Is that forever? Is that the new future? And then you ask yourself, okay, so how much run rate do I have? And you re-plan accordingly.

**中文翻译:**
抽象地说，有两种类型的危机。一种我称之为“现金危机”。突然间你的现金计划受到了威胁，比如失去客户、投资人消失、未达预期、市场价格剧变等等。另一种是失去 PMF。突然间你拥有的一切都变得无关紧要，你实际上需要回到原点。
(00:24:54):
对于第一种危机，如果是现金危机，你真正需要问自己的是（其实在任何危机中都要先问）：到底什么受到了影响？是我的资金跑道（run rate），是我的产品，还是我的收入流？我是否仍然具有相关性？
(00:25:19):
在 Order.chat 的案例中，我们变得无关紧要了，就是这样。所以你要做的第一件事是：到底什么受到了影响？第二件事是：这会持续多久？是暂时的吗？是永久的吗？这是未来的新常态吗？然后你问自己：好吧，我还有多少资金跑道？并据此重新制定计划。

---

### [00:25:52] Uri Levine

**English:**
And I'll give you some examples, and this is really important, because let's say that you're a company that we have $5 million of revenues a year, say 400,000 per month, and your burn rate, your net burn rate is 200,000. So you actually at the end of the year, in order to run for a year, you need about two and a half million dollars to run. If you lose half of your revenues, and you only had two and a half million in the bank, you now have six month to run. So obviously you need to re-adapt.
(00:26:58):
Whatever you are going to decide, you are going to decide, you need to decide today, right now. And the reason is very simple, if you want to reduce the burn, the expenses in order to extend the run rate, if you wait two more month, then it's going to become nearly impossible to do. If you wait six more month, then obviously this is impossible to do. So the longer that you wait, you actually lose options. The only ability to choose is today. This is one of the most challenging part of a crisis. You actually need to make a decision rapidly, like today.

**中文翻译:**
我给你举个例子，这非常重要。假设你公司年收入 500 万美元，也就是每月约 40 万美元，而你的净亏损额（burn rate）是每月 20 万美元。为了维持一年的运营，你大约需要 250 万美元。如果你失去了一半的收入，而银行里只有 250 万美元，你现在只能维持六个月了。显然你需要重新调整。
(00:26:58):
无论你决定做什么，你都必须今天、现在就做决定。原因很简单：如果你想通过减少开支来延长资金跑道，如果你多等两个月，这件事就会变得几乎不可能完成。如果你等六个月，那显然已经不可能了。所以你等得越久，失去的选择就越多。唯一的选择权就在今天。这是危机中最具挑战性的部分之一：你需要迅速做出决定，就在今天。

---

### [00:27:41] Uri Levine

**English:**
There are few reasons to that. Number one is that if you don't then you might lose options. Number two, and this is about communicating within the organization that decision. Look, if there is a crisis everyone knows, everyone knows, and you don't do anything about it, this is not a good practice. Now you might want to decide, no, we're going to keep on running full steam ahead until we hit the wall because by that we increase the likelihood that we will have enough velocity to bypass the wall. But you need to communicate that with your team because the one that is really suffer is not just you, it's the entire team. They know that there is a crisis and they want to know that someone that holds the steering wheel is making the decisions. And if you don't, then guess what? You are then a sinking ship. And what's going to happen is that the top performing people, they would leave.

**中文翻译:**
这有几个原因。第一，如果不迅速行动，你会失去选择权。第二，这关乎在组织内部沟通这个决定。听着，如果发生了危机，每个人都知道，如果你什么都不做，这不是好的做法。你可能决定：“不，我们要全速前进直到撞墙，因为这样我们更有可能获得冲破障碍的速度。”但你需要和团队沟通，因为受苦的不只是你，而是整个团队。他们知道有危机，他们想知道掌握方向盘的人正在做决定。如果你不做决定，猜猜会发生什么？你就是一艘正在下沉的船，结果就是顶尖人才会离开。

---

### [00:28:46] Lenny Rachitsky

**English:**
Let me do a quick summary of what you've shared to give people a landscape and then let's keep going down this route. So there's basically two types of crisis. And there's small crisis, I imagine someone's pissed off at something. These are how you describe major crisis, like existential crisis for your startup. Is that the way to think about it?

**中文翻译:**
让我快速总结一下你分享的内容，给大家一个全景图，然后我们继续深入。基本上有两种危机。当然也有小危机，比如某人对某事感到生气。但你描述的是重大危机，比如初创公司的生存危机。是这样理解吗？

---

### [00:29:10] Uri Levine

**English:**
Right. Because if an A-player leaves, I hate it, but it's not a crisis.

**中文翻译:**
没错。因为如果一个顶尖人才（A-player）离开了，我很讨厌这种情况，但这不叫危机。

---

### [00:29:10] Lenny Rachitsky

**English:**
Yeah. Okay, cool. So there's two, cash crisis, which is either a bunch of revenue disappears or investors bail or don't want to keep supporting you. Those are the two major buckets. And then there's product market fit crisis, could be a competitor launches, could be the market changes, things like that.
(00:29:28):
And within the cash crisis, so say you realize we don't have as much cash as we planned or need, the three steps you just described, what is really being impacted? Just be really real with what is the impact to our business with this change. How long do we think this cash crisis will last? And how long do we have before we run out of cash essentially?

**中文翻译:**
好的。所以有两种：现金危机，要么是大量收入消失，要么是投资者撤资或不愿继续支持。这是两大类。然后是 PMF 危机，可能是竞争对手发布新产品，或者是市场发生了变化等等。
(00:29:28):
在现金危机中，假设你意识到现金不如计划的多或不够用，你刚才描述了三个步骤：到底什么受到了影响？（真实面对这种变化对业务的影响）；我们认为这种现金危机会持续多久？以及在资金耗尽前我们还有多少时间？

---

### [00:29:51] Uri Levine

**English:**
Yep. And then you need to decide, and then you need to decide on your action and your new plan and maybe it's a new strategy. If all of a sudden I would say if this is about product market fit disappeared, then this is a new strategy. And maybe it's about deciding on extending the run rate or keep on trying or whatever. And this is something that is really interesting.

**中文翻译:**
是的。然后你需要做决定，决定你的行动和新计划，也许是一个新战略。如果突然之间 PMF 消失了，那就是新战略的问题。也许是决定延长资金跑道，或者继续尝试，或者其他什么。这真的很有趣。

---

### [00:30:17] Uri Levine

**English:**
And we go back to Covid and I look at two of my startups that were in the travel space, one of them is WeSki, and it's essentially the booking.com of ski vacations. And guess what? Covid started. And there was no more ski trips to Europe. Europe were shut down completely. And all the ski areas were shut down. And you know that I'm an avid skier? For me that was a disaster on a personal level. And eventually by the way, what happened is that I was back in Tel Aviv and I was unable to travel to Europe, and it was only somewhere in 2022 that I was able to travel to the US after vaccination and so forth. And in March, 2022, I actually moved myself to Utah to Salt Lake City and I basically say, "No, I'm going to ski every day that I'm not busy." And I skied until the end of the season.

**中文翻译:**
回到新冠疫情，我当时有两家旅游领域的初创公司，其中一家叫 WeSki，它基本上是滑雪度假领域的 booking.com。结果疫情爆发了，再也没有去欧洲的滑雪旅行了。欧洲完全封锁，所有滑雪场都关闭了。你知道我是个滑雪爱好者吗？对我个人来说，那简直是场灾难。顺便说一下，后来我回到了特拉维夫，无法去欧洲旅行，直到 2022 年接种疫苗后才能去美国。2022 年 3 月，我搬到了犹他州的盐湖城，我对自己说：“不，只要不忙，我每天都要去滑雪。”我一直滑到了雪季结束。

---

### [00:31:54] Uri Levine

**English:**
Now that was supposed to be the first year that we were profitable. So we did not have a lot of cash in the bank because we expected to become profitable this year. And we basically told our ourself, okay, this season is over, next season is not going to happen. We don't know, but we need to plan for something that is going to last longer than that. And then we basically say, okay, how can we deal with it?
(00:32:21):
Now, because of WeSki had a lot of strategic investors from the travel industry, in the travel industry, they didn't really care about WeSki, they care about their own product. If you are a hotel chain, then guess what? You have no travelers. If you're an airline, guess what? You have no flyers. So anyone in the travel industry suffered from the same problem. And the last thing on earth that they care about is a startup that they invested at. And we realized that, okay, wait a minute, we don't have enough cash to survive for two seasons without revenues, we need to raise additional capital.

**中文翻译:**
那一年本应是我们盈利的第一年。所以我们银行里没有太多现金，因为我们预期今年就能盈利。我们告诉自己：好吧，这个雪季结束了，下个雪季可能也没戏。我们不知道，但我们需要做一个更长期的计划。然后我们说：好吧，我们该怎么应对？
(00:32:21):
WeSki 有很多来自旅游行业的战略投资者，但在旅游行业，他们当时根本不关心 WeSki，他们只关心自己的产品。如果你是一家连锁酒店，你没有游客了；如果你是一家航空公司，你没有乘客了。旅游行业的每个人都在遭受同样的问题。他们最不关心的就是他们投资的一家初创公司。我们意识到：等一下，我们没有足够的现金在没有收入的情况下维持两个雪季，我们需要筹集额外资金。

---

### [00:33:00] Uri Levine

**English:**
Now, no one, no new investor is going to speak with us, because there's no ski, so what are you talking about? And we approached the existing investor, and by the way I'm one of them, and we basically say, "Okay, you know what? We need your help." And everyone told us, "Oh, we are busy. We have other problems to deal with. We have our own problems. I don't see how is that going to become a good investment and so forth." And then we basically decided that, okay, wait a minute, we're going to do a pay to play.
(00:33:37):
The pay to play is actually sort of forcing new investors at the expense of the existing one. So for example, doing a major down round is sort of pay to play, because if you're not participate your position in the company is going to be diluted severely. And this is what we decided to do. And that was way more complex, I describe that in the book, way more complex than that because we also had safe instruments that we need to convert before we can actually do something like that. And that was really complex. But we ended up doing that. And today the company is actually very successful.

**中文翻译:**
当时，没有新的投资者愿意和我们谈，因为滑雪都没了，还有什么好谈的？我们去找现有的投资者（顺便说一下，我也是其中之一），我们说：“我们需要你们的帮助。”每个人都告诉我们：“哦，我们很忙。我们有其他问题要处理。我们有自己的麻烦。我不觉得这会是一笔好的投资。”然后我们决定：等一下，我们要搞“参与即参与”（pay to play，一种强制现有股东继续投资否则将被大幅稀释的机制）。
(00:33:37):
Pay to play 实际上是在牺牲现有投资者的利益来强制注资。例如，进行一次重大的“降估值融资”（down round）就是一种 pay to play，因为如果你不参与，你在公司的股份将被严重稀释。这就是我们决定做的。这非常复杂，我在书里有描述，比这还要复杂得多，因为我们还有需要转换的 SAFE 协议。虽然很复杂，但我们最终做到了。今天，这家公司实际上非常成功。

---

### [00:34:20] Uri Levine

**English:**
After Covid, we used the time of Covid to actually improve the product, and as soon as Covid was over then we started to grow rapidly. And the company is profitable, is growing rapidly, is actually providing very, very good service to its customers. To a certain extent I would say we ended up getting out of this crisis successfully.
(00:34:49):
But if you are in the middle of it and you ask yourself, so what are the chances that we will end up being successful? It looks way smaller. Way smaller. So what happened here is that you realize that, okay, this is not forever, so ski is going to come back but we don't know how long and therefore we assume that it's going to be for two seasons until it's coming back, until 2022. And for that we need to adapt. And so we resized the company to be very, very lean and small and we raise just enough capital to survive those two years. And it ended up to be working very well.

**中文翻译:**
疫情期间，我们利用这段时间改进了产品，疫情一结束，我们就开始了快速增长。现在公司已经盈利，增长迅速，为客户提供非常好的服务。在某种程度上，可以说我们成功地走出了这场危机。
(00:34:49):
但如果你身处危机之中，问自己：“我们最终成功的概率有多大？”看起来会小得多，小得多。所以当时的情况是，你意识到这不会是永远的，滑雪总会回来，但不知道要多久，所以我们假设要等两个雪季，直到 2022 年。为此我们需要做出调整。于是我们将公司规模缩减到非常精简，并筹集了刚好够维持这两年的资金。结果证明这非常奏效。

---

### [00:35:43] Uri Levine

**English:**
I think that I heard ... maybe the most significant real estate developers in New York is Silverstein, and he built the World Trade Center and pretty much everything on the Hudson. And he was asked how he becomes such a successful developer and he said, "Tell you the truth, this is 85% luck and 15% skills and know-how and so forth." And then he was asked if he can change one thing, what exactly it's going to be, and he said, "You know what? I'm going to replace the 15% skills with additional 15% luck." So luck is good. For me luck, I will define luck as opportunity meets readiness. Readiness is up to you; opportunity, not always.

**中文翻译:**
我想起我听过……纽约最著名的房地产开发商之一 Silverstein，他建造了世贸中心和哈德逊河畔的几乎所有建筑。有人问他如何成为如此成功的开发商，他说：“实话告诉你，85% 靠运气，15% 靠技能和诀窍等等。”然后有人问他如果能改变一件事，那会是什么，他说：“你知道吗？我想把那 15% 的技能也换成 15% 的运气。”所以运气很好。对我来说，我将运气定义为“机会遇到了准备”。准备取决于你，而机会并不总是如此。

---

### [00:36:32] Lenny Rachitsky

**English:**
Beautifully said. I also agree with luck being so core to most people's success, most company's success. But I feel like you're not giving people enough credit for the hard work that's also involved in the skills and timing and stuff.

**中文翻译:**
说得太好了。我也同意运气是大多数人和公司成功的核心。但我觉得你没有给人们在技能、时机和努力工作方面足够的肯定。

---

### [00:36:47] Uri Levine

**English:**
On the readiness. That's the readiness. Of being ready to take advantage of opportunity.

**中文翻译:**
那就在“准备”里。这就是准备——准备好抓住机会。

---

### [00:37:18] Lenny Rachitsky

**English:**
One is, and this is something, it's kind of a tangent, but I think it's a core part of your advice on crisis, which is that it's always the founder's fault if things don't work out, even if they're completely out of your control, even if the whole world is changing, it's still your responsibility and your fault if things don't work out.

**中文翻译:**
有一点，这虽然有点偏离主题，但我认为这是你关于危机建议的核心部分：如果事情进展不顺利，那永远是创始人的错。即使事情完全超出了你的控制，即使整个世界都在发生变化，如果事情没成，仍然是你的责任，是你的错。

---

### [00:37:18] Uri Levine

**English:**
I wouldn't say fault, I would say responsibility. It might not end up beautiful, in some cases you will die. But at the end of the day you cannot rely on someone else. The fact that the interest rate is going up and the result is that it's becoming very, very hard to raise capital, the fact that this is industry-wide, so what? You have only one company, you need to make sure that this company is successful. And later on if you fail, then you can rely to then basically say, "This is my excuse, it was not just me." Not just me is not going to help you to become successful. Just me is going to help you to become successful. When you assume responsibility, then you are able to ... you're basically saying, "You know what? I control my own destiny. I'm going to make the decisions and I control my own destiny." When this happens, you increase the likelihood of being successful regardless what happen to the rest of the market, and you don't really care.

**中文翻译:**
我不会说是“错”，我会说是“责任”。结果可能并不美好，在某些情况下你会失败（公司倒闭）。但归根结底，你不能依赖别人。利率上升导致融资变得非常困难，这是全行业的问题，那又怎样？你只有这一家公司，你需要确保这家公司成功。如果你失败了，你可以找借口说：“这不是我的错，大家都不行。”但“不只是我”并不能帮你成功，“只有靠我”才能帮你成功。当你承担起责任时，你实际上是在说：“我掌控自己的命运。我要做决定，我掌控自己的命运。”当这种情况发生时，无论市场其他部分发生了什么，你都会增加成功的可能性，而且你根本不在乎外界如何。

---

### [00:38:58] Uri Levine

**English:**
I heard of cases that you basically say our underlining assumptions didn't work out and our thesis is wrong and therefore we would like to return the investors their money. But entrepreneurs never give up. And this is the most successful behavior of startup CEO, never give up, always keep on looking for ways to make it work. And so it is going to be a journey of failures, and in particular during crisis, but you still need to keep on trying to make it work even though it's way harder. So never give up is the most important behavior of successful CEO of startup.
(00:39:41):
The second one, by the way, is making decisions with conviction. This is true for all CEOs or for all companies, not just startups. Now startups, those decisions are probably more frequent and there are a lot of them. But during crisis, all CEOs in the world need to make hard decisions. And you need to make them with conviction because if you don't make them with conviction, then what will happen is that the team is not going to follow. If the team is not going to follow, then you are not going to be successful.

**中文翻译:**
我听说过有些案例，你基本上会说我们的底层假设行不通，我们的论点是错误的，因此我们想把钱退给投资者。但创业者永不言弃。这是初创公司 CEO 最成功的行为特质：永不言弃，永远寻找让事情运转的方法。这注定是一个充满失败的旅程，尤其是在危机期间，但即使困难重重，你仍需不断尝试。所以“永不言弃”是成功的初创公司 CEO 最重要的行为。
(00:39:41):
顺便说一下，第二个特质是“带着坚定的信念做决定”。这对所有 CEO 或所有公司都适用，不只是初创公司。在初创公司，这些决定可能更频繁，数量也更多。但在危机期间，世界上所有的 CEO 都需要做出艰难的决定。你必须带着信念去做决定，因为如果你没有信念，团队就不会跟随。如果团队不跟随，你就不会成功。

---

### [00:40:14] Uri Levine

**English:**
But never give up. You ask entrepreneurs what will happen and they will basically tell you, "No, we keep on fighting." One of my other startups in the travel industry called Oversee, back then they called FairFly. And the CEO told me that a cat might have nine souls. We are a cat in that sense, we have nine souls. And the reason that I know that is that we already died nine times or almost died nine times. And so the reality is that you don't give up, you keep on as long as ...
(00:40:56):
And for a second I would say, look, there are only two reasons that you would like to give up. One is that your mission is wrong. So the problem disappears. And if the problem disappears, your mission is no longer relevant or no longer valid, and you might want to consider to give up.
(00:41:19):
The other one is that if the team is not right and you are unable to change it. So you brought toxic investors into the board and they started to control the company and obviously in many cases they create more damage than help. And you're unable to change that anymore, then this is a good reason to give up.

**中文翻译:**
但永不言弃。你问创业者会发生什么，他们基本上会告诉你：“不，我们会继续战斗。”我另一家旅游行业的初创公司叫 Oversee（当时叫 FairFly）。CEO 告诉我，猫有九条命，从这个意义上说我们就是一只猫，我们有九条命。我知道这一点的原因是我们已经死过九次，或者说差点死过九次。现实就是你不会放弃，只要……
(00:40:56):
我想说，只有两个原因会让你想要放弃。一是你的使命错了。也就是说，问题消失了。如果问题消失了，你的使命就不再相关或不再有效，这时你可以考虑放弃。
(00:41:19):
另一个原因是团队不对，且你无法改变。比如你把有毒的投资者带进了董事会，他们开始控制公司，显然在很多情况下，他们造成的伤害大于帮助。如果你无法再改变这种状况，那么这就是放弃的好理由。

---

### [00:42:06] Lenny Rachitsky (Ad Segment - OneSchema)

**English:**
I'm excited to chat with Christina Gilbert, the founder of OneSchema... [Ad content continues]

**中文翻译:**
很高兴能与 OneSchema 的创始人 Christina Gilbert 交谈…… [广告内容省略，主要介绍 OneSchema 的 CSV 导入和数据验证功能]

---

### [00:43:45] Lenny Rachitsky

**English:**
This idea of never give up, it's very similar to Dalton Caldwell was on the podcast, he's a partner at YC, and his whole ... he has a famous talk, I guess, at YC, and this was the title of this podcast episode, is just don't die. That's his main advice to a startup, just don't die.

**中文翻译:**
这种“永不言弃”的想法与 Dalton Caldwell（YC 合伙人）在播客中分享的非常相似。他在 YC 有个著名的演讲，也是那集播客的标题：就是“别死掉”。这是他对初创公司的主要建议：只要不死掉就行。

---

### [00:43:45] Uri Levine

**English:**
Never give up. You might die by the way, you might die, you'll never give up.

**中文翻译:**
永不言弃。顺便说一下，你可能会死掉，但你永远不会主动放弃。

---

### [00:43:57] Lenny Rachitsky

**English:**
And to be clear, the way a startup dies is they run out of money, is that the simplest way to think about that?

**中文翻译:**
明确一下，初创公司死掉的方式就是钱花光了，这是最简单的理解方式吗？

---

### [00:43:57] Uri Levine

**English:**
That's the only way that they die. By the way, all the companies in the world, they are unable to pay their bills and therefore they die.

**中文翻译:**
那是它们死掉的唯一方式。顺便说一下，世界上所有的公司都是因为付不起账单而倒闭的。

---

### [00:44:24] Uri Levine

**English:**
In many cases, we had to engage the employees, "No, we don't have cash." So what we did is that we diluted all shareholders in order to give employees way more equity. So five times more equity than they had before. And we told them, we need you to trust us and believe in the cause and believe in our ability to recover. And if we don't, then everyone loses. But if we do, then everyone wins big time. And so this will be a way to actually reengage employees if you are unable to pay them their regular pay. And that was the case in most of the startups that almost run out of cash.
(00:45:08):
Occasionally you can do, if you will tell me that you're going to run out of cash next month and therefore you need to shut down, I would like to imagine that you have at least six more month of run rate. You don't know that, but this is through leadership. So you basically tell your people, "Stay with me, you believed in the cause, you believed in my leadership, I still believe in the cause and I still believe in you. And maybe we are going to have some hard time, maybe we are going to have some month that unable to pay, but eventually we will get out of that." And in many cases, most people will stay.

**中文翻译:**
在很多情况下，我们不得不动员员工：“不，我们没现金了。”所以我们做的是稀释所有股东，给员工更多的股权。比他们以前拥有的多出五倍。我们告诉他们：我们需要你们信任我们，相信我们的事业，相信我们恢复的能力。如果我们没恢复，大家都会输；如果我们恢复了，大家都会大赢。如果你无法支付正常工资，这就是重新动员员工的一种方式。大多数差点耗尽现金的初创公司都是这么做的。
(00:45:08):
偶尔你可以这样做：如果你告诉我下个月现金就要用完了，因此需要关闭公司，我希望你能想象自己还有至少六个月的资金跑道。你虽然不知道未来，但这就是真正的领导力。你告诉你的员工：“留下来陪我，你们曾相信这项事业，相信我的领导，我依然相信这项事业，也依然相信你们。也许我们会有一段艰难时期，也许有几个月发不出工资，但最终我们会走出来的。”在很多情况下，大多数人会选择留下。

---

### [00:46:53] Uri Levine

**English:**
So during crisis, people will appreciate more than anything else transparency. And if you hide information from them, then they would leave, they don't trust you anymore. But if there is a crisis, and look, if there is a crisis then everyone knows that there is a crisis, it's not surprising for anyone. And this is where they expect your leadership the most. This is where they expect you to be there for them. And tell them that this is what we're going to do. And if ABC happens, then we will be successful. And if it's not, then we will die. And I want you to believe that we can deliver A, B and C, and I want you to stay here for that part of the journey. And this is really, really dramatic, this is perhaps the most important part. Look, during crisis, the team is the one that is going to take you out of the crisis, and you need them more than ever. And guess what? They need you.

**中文翻译:**
在危机期间，人们最看重的是透明度。如果你向他们隐瞒信息，他们就会离开，不再信任你。如果有危机，听着，每个人都会知道有危机，这对谁都不是秘密。这正是他们最期待你展现领导力的时候。他们期待你站在他们身边，告诉他们：“这就是我们要做的。如果 A、B、C 发生了，我们就会成功；如果没有，我们就会失败。我希望你们相信我们能实现 A、B 和 C，我希望你们留下来走完这段旅程。”这非常具有戏剧性，也许是最重要的部分。听着，在危机中，是团队带你走出困境，你比以往任何时候都更需要他们。而且，猜猜怎么着？他们也需要你。

---

### [00:48:19] Uri Levine

**English:**
So number one, don't sugarcoat. So you basically you don't need to share all the feedbacks from all the investors. You can tell them, "Look, I met dozens of investors in the last couple of weeks and they're all saying no." Or we had a signed term sheet and the investor disappeared. Okay, that's fine. It is what it is. Look, the fact that it's ugly, if you don't tell that it's ugly, it's still ugly.
(00:48:49):
And so I would share the essence. And if we have metrics, then what I would like to do is believe that everyone is aware of the metrics, of the key metrics of the company. This is something that in general I would say, "Oh, in the lobby of the office, we should have the key metrics displayed for everyone to understand this is what we stand for, this is how well we are executing anyhow." And so when they will see the numbers drop, they know that the numbers drop. And this is something that I will in general I would say, look, key metrics, they should be shared anyhow. And so in particular during crisis, we should keep on sharing them. Definitely not hiding information.

**中文翻译:**
首先，不要粉饰太平。你不需要分享所有投资者的反馈，但你可以告诉他们：“听着，过去几周我见了打几十个投资者，他们都拒绝了。”或者“我们签了投资意向书（term sheet），但投资者消失了”。没关系，事实就是如此。听着，事实很糟糕，即使你不说它糟糕，它依然糟糕。
(00:48:49):
所以我会分享核心情况。如果我们有数据指标，我希望每个人都了解公司的关键指标。通常我会说：“在办公室大厅里，我们应该展示关键指标，让每个人都明白我们的目标是什么，以及我们执行得如何。”这样当他们看到数字下降时，他们就知道出问题了。我认为关键指标无论如何都应该共享。尤其是在危机期间，我们应该继续分享，绝对不能隐瞒信息。

---

### [00:50:42] Uri Levine

**English:**
So I'll give you an example. So let's say that you are almost run out of cash and you believe that you're going to raise capital in the next two month. And if not, then you run out of cash. One of the things that you might want to do is extend the run rate. One other thing that you might want to do is actually tell the people that we will be running out of cash in two month. And number one, I want you to help me even if we run out of cash because there are good chances that we eventually will be able to raise capital and recover that. And number two, in order to get your support and belief in the company I am going to offer you more equity.
(00:52:35):
The other example is about calculating end of cash. And this is really, really important. So let's say that you have run rate of X month, six month. If you reduce burn by 50% today, then you simply increase your run rate to a year. If you don't do it today and you wait three more month, then you only can do that for the ... so the first three month you burn the same way that you did up until now, and now you reduce that to half, so you have six more month, total of nine month. If you decided today that you need 12 month, and you don't act today, you will never have 12 month.

**中文翻译:**
我给你举个例子。假设你快没钱了，你相信未来两个月能融到资，否则现金就断了。你想做的一件事是延长资金跑道。另一件事是告诉员工，我们两个月后会没钱。第一，我希望即使没钱了你们也能帮我，因为我们很有可能最终融到资并弥补回来。第二，为了获得你们的支持和对公司的信心，我会给你们更多股权。
(00:52:35):
另一个例子是关于计算现金耗尽的时间。这非常非常重要。假设你还有 6 个月的资金跑道。如果你今天减少 50% 的开支，你的跑道就延长到了一年。如果你今天不做，而是等三个月再做，那么前三个月你还是按原来的速度烧钱，剩下的钱减半花，你只能再撑 6 个月，总共 9 个月。如果你今天决定需要 12 个月，但今天不采取行动，你永远也得不到 12 个月。

---

### [00:56:06] Uri Levine

**English:**
So in that sense, I would say there are multiple ways of reducing the cost. But in general, this is always about impacting people. If you look at the startup and you look at the budget, 70% of the budget is people, maybe 75% of the budget is people. Everything else is nickels and dimes. If you're going to tell me, "Oh no, we are going to start the supply of coffee to the office and this is how we are going to reduce cost." No, this is how you create dissatisfaction with the team and you would reduce costs because some people would leave because of that, not because of lack of coffee, but because of inability to determine and to make hard decisions. So end of the day, if you need to reduce costs that means people.

**中文翻译:**
从这个意义上说，降低成本有很多方法。但总的来说，这总是会影响到人。如果你看一家初创公司的预算，70% 甚至 75% 都是人力成本。其他一切都是零头。如果你告诉我：“哦不，我们要停止供应办公室咖啡来降低成本。”不，这只会让团队感到不满，你确实降低了成本，但那是因为有人因此离职了——不是因为没咖啡喝，而是因为你没有能力做出果断而艰难的决定。所以归根结底，如果你需要降低成本，那就意味着要动人。

---

### [00:57:32] Lenny Rachitsky

**English:**
In the product market fit route, is it essentially if you've lost product market fit, it's to pivot, is that basically the question? And then it's a question of where to pivot and what to do?

**中文翻译:**
在 PMF 危机这条路上，如果失去了 PMF，本质上就是要转型（pivot），是这样吗？然后问题就变成了往哪儿转，以及该做什么？

---

### [00:57:32] Uri Levine

**English:**
So the first question is, am I still relevant? And probably the answer is no. And then the next question that you basically say, "Okay, do I want to pivot?" And for that I will say, "If I would start today, is this is what I'm going to do?" And if the answer is yes, then do it.
(00:58:44):
And the assets could be technology that you already developed, could be the team that you already built, could be the know-how that you have in that specific market that gives you a significant advantage. And if any of those is really, really significant, then it's possible that you want to pivot. Pivot basically say major fuck up, all of our underlining assumptions have gone.

**中文翻译:**
第一个问题是：我还有相关性吗？答案很可能是“没有”。接下来的问题是：“我想转型吗？”对此我会问：“如果我今天重新开始，我会做这件事吗？”如果答案是肯定的，那就去做。
(00:58:44):
你的资产可能是已经开发的技术，可能是已经建立的团队，也可能是你在特定市场拥有的能给你带来显著优势的诀窍。如果其中任何一项非常重要，那么你可能想要转型。转型基本上意味着：出了大乱子，我们所有的底层假设都失效了。

---

### [01:00:59] Uri Levine

**English:**
And then the administration have changed and now it's going to change again. And they changed the regulation. And overnight we figured out that ... And we were actually on being a successful path. And we had to reinvent ourself. Now, what we basically said is, "Look, we have the energy to keep on going, we have something, a thesis that we believe might be relevant for us. We have the technology that can serve the thesis and we have enough cash to try it out." And we went back to the board and we offered them two options. Number one, we give you your money back. And number two, this is what we're going to try.
(01:01:43):
And the interesting part is that investors don't want their money back. They did not invest in order to have their money back, they invest in order to make a significant impact. And obviously they don't want to go back to their investors and tell them, guess what? And so we had all the support to keep trying something else.

**中文翻译:**
（提到 Pontera/FeeX 的例子）然后政府换届了，现在又要换了。他们改变了监管政策。一夜之间我们发现……我们原本正走在成功的道路上，却不得不重塑自我。当时我们基本上是说：“听着，我们还有继续前进的精力，我们有一个相信可能相关的论点。我们有可以支持这个论点的技术，也有足够的现金去尝试。”我们回到董事会，给了他们两个选择：第一，把钱退给你们；第二，这是我们要尝试的新方向。
(01:01:43):
有趣的是，投资者并不想要回他们的钱。他们投资不是为了拿回本金，而是为了产生重大影响。显然，他们也不想回去告诉他们的出资人（LP）说投资失败了。所以我们得到了所有的支持，继续尝试别的东西。

---

### [01:03:17] Lenny Rachitsky

**English:**
That's such an important point. It came up, I just had Toby from Shopify on the podcast, and he said exactly the same thing. That just like the number of times Shopify almost died, people have no idea. It's important to know, that's very common.

**中文翻译:**
这是一个非常重要的观点。我刚邀请了 Shopify 的 Tobi 上节目，他也说了完全一样的话。Shopify 差点死掉的次数，人们根本无法想象。知道这一点很重要，这非常普遍。

---

### [01:03:57] Uri Levine

**English:**
So going back to basic, but now you are already running, so you probably have already validated the problem or the value proposition. About pivoting, so when you start you think that, okay, I have this brilliant idea. And what I really encourage people is first of all, go and validate the problem, speak with people, understand their perception of the problem. And only then start to think about the solution. Now, this is still not the case in most startups. And this is fall in love with the problem, not the solution.

**中文翻译:**
回到基本点，但现在你已经在运营了，所以你可能已经验证了问题或价值主张。关于转型，当你开始时，你觉得“我有这个绝妙的主意”。但我真正鼓励人们的是：首先，去验证问题，与人交谈，了解他们对问题的看法。只有在那之后，才开始思考解决方案。现在大多数初创公司还没做到这一点。这就是“爱上问题，而非解决方案”。

---

### [01:08:40] Lenny Rachitsky

**English:**
I like this algorithm. I was writing it down as you're talking. So basically when you're deciding to pivot, looking for opportunities to pivot, step one is find a problem, validate there's a problem that exists. Step two is figure out if you have the tech, team or know-how that gives you an advantage to win at solving this problem. Then ask yourself, do you have the passion and energy to be spending your life and the many number of years attacking this problem? Then validate your team, wants to also go after this problem. And then check with your investors and try to get money to fund you going after this problem.

**中文翻译:**
我喜欢这个算法。你说话时我一直在记。基本上，当你决定转型、寻找转型机会时：第一步，找到一个问题，验证该问题确实存在。第二步，弄清楚你是否拥有技术、团队或诀窍，让你在解决这个问题上具有获胜优势。然后问自己，你是否有激情和精力投入生命中的多年时间去攻克这个问题？接着验证你的团队是否也想追求这个问题。最后，与投资者沟通，尝试获得资金支持。

---

### [01:11:40] Lenny Rachitsky

**English:**
There was a quote I wrote down as you were talking earlier that I think is really great. It's kind of a framework for ... the way you used it is to help you pick which direction to go. But I think it's a useful framework in general for companies and founders is ask yourself, if I were to start today, what would I have done and what would I do if I were to start this company again today? I think that's such a powerful thing to always think about even when everything's going great.

**中文翻译:**
你之前说的一句话我记下来了，我觉得非常棒。这是一种框架……你用它来帮助选择方向。但我认为这对公司和创始人来说是一个通用的有用框架：问问自己，如果我今天重新开始，我会怎么做？如果我今天重新创办这家公司，我会做什么？我认为即使在一切顺利的时候，经常这样思考也是非常有力量的。

---

### [01:12:03] Uri Levine

**English:**
I agree. Today is the first day of the rest of your life. And this is pretty much everything in your life. So ask yourself, knowing what I know today, would I do something different? Now, if the answer is yes, then do something different today. Don't wait until next life or next company or next relationship or next something. If you basically know today that you should be doing something different, then change.

**中文翻译:**
我同意。今天是你余生的第一天。你生活中的几乎所有事情都是如此。所以问问自己，基于我今天所知道的一切，我会做些不同的事情吗？如果答案是肯定的，那么今天就做出改变。不要等到下辈子、下一家公司、下一段关系或下个什么机会。如果你今天明确知道应该做些不同的事，那就改变。

---

### [01:13:57] Uri Levine

**English:**
We didn't change. Back in 2010, we were simply not good enough, we were still in the product market fit iterations and iterations and iterations, and we were not good enough. And we kept on building and we kept on iterating and iterating and iterating. But we almost ran out of cash. And then we had this lucky day that Microsoft decided to invest, and so did Qualcomm. The funny part is that I had this dialogue with Qualcomm Ventures and they told me that they're not sure why is that important for them. And I read someplace that they did not invest at Twitter at $55 million. And this is exactly what I told them, "May I remind you that you did not invest in Twitter at $55 million valuation. This is where Waze is today." And obviously different story, but that was the fear of missing out, the FOMO.

**中文翻译:**
（关于 Waze 面对谷歌竞争时）我们没有改变方向。2010 年时，我们只是还不够好，我们还在进行 PMF 的一次次迭代，我们还不够优秀。我们继续构建，继续迭代。但我们差点耗尽现金。然后我们遇到了幸运的一天，微软决定投资，高通也跟进了。有趣的是，我当时与高通创投对话，他们说不确定这为什么对他们重要。我曾在某处读到他们错过了 Twitter 5500 万美元估值时的投资。我就是这么告诉他们的：“我可以提醒你们吗，你们曾错过了 5500 万美元估值的 Twitter，而这正是 Waze 今天的估值。”显然这是不同的故事，但那就是“错失恐惧症”（FOMO）在起作用。

---

### [01:17:17] Uri Levine

**English:**
Number one answer is no. Don't worry, you will face crisis. And if you worry, you're still going to face crisis. Number two is that, look, it's way easier to deal with a crisis if you have plenty of cash in the bank. So if you can raise capital and maintain higher level of cash in the bank, it will help you to go through the next crisis, but it's not going to avoid it. So always be funded is a good advice. But in general, look, you do not prepare for the next crisis because you don't know what kind of crisis it's going to be next.

**中文翻译:**
头号答案是：不能避免。别担心，你肯定会遇到危机的。即使你担心，危机还是会来。第二点是，听着，如果银行里有充足的现金，处理危机要容易得多。所以如果你能融资并保持较高的现金储备，它会帮你度过下一个危机，但不能避免危机。所以“始终保持资金充足”是个好建议。但总的来说，你无法为下一个危机做具体准备，因为你不知道下一个危机是什么样的。

---

### [01:18:44] Uri Levine

**English:**
My general rule will be around 18 month. Are you okay with 12 month? Yeah, if you risk taker, bigger risk taker then you can survive with 12 month. But the challenge is that, look, if you have shorter period of time, then you don't have enough time to execute, you need to focus on fundraising all the time. And you want to focus on creating value and not just bringing cash into the company.

**中文翻译:**
我的通用规则是保持 18 个月的资金。12 个月行吗？行，如果你是风险承担者，甚至更大的风险承担者，你可以靠 12 个月生存。但挑战在于，如果时间太短，你就没有足够的时间去执行业务，你必须一直专注于融资。而你本应该专注于创造价值，而不仅仅是为公司找钱。

---

### [01:20:13] Uri Levine

**English:**
Yeah. It goes back into how ... the other three dimensions of a startup, it's a roller coaster journey with ups and downs and ups and downs, and it's a journey of failures because we are trying to build something new that no one did before so we tried multiple things. For that, Albert Einstein used to say that if you haven't failed that because you haven't tried new things before. And it's a long journey, it's a very long journey. In particular, the longest part is until you figure out product market fit. And now I add the fourth dimension of that, that this is a journey from one crisis to the next one.

**中文翻译:**
是的。这回到了初创公司的另外三个维度：它是一个起伏不定的过山车旅程；它是一个充满失败的旅程，因为我们在尝试前人未竟的事业，所以会尝试很多东西（爱因斯坦曾说，如果你没失败过，那是因为你没尝试过新事物）；它是一个漫长的旅程，尤其是找到 PMF 之前的阶段最漫长。现在我增加了第四个维度：这是一个从一个危机走向下一个危机的旅程。

---

### [01:21:36] Uri Levine

**English:**
And hopefully, in my mind, this is my mindset of a teacher, my destiny is about value creation, and if this podcast or this book, this one, can help people to become more successful, then I fulfill my destiny.

**中文翻译:**
希望如此。在我心中，这是我作为老师的心态：我的使命是创造价值。如果这个播客或这本书能帮助人们变得更成功，那我就履行了我的使命。

---

### [01:22:32] Lenny Rachitsky

**English:**
Uri, thank you so much for being here.

**中文翻译:**
Uri，非常感谢你能来。

---

### [01:23:15] Uri Levine

**English:**
Thank you, appreciate it.

**中文翻译:**
谢谢，非常感激。

---

### [01:23:21] Lenny Rachitsky

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app... See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得内容有价值，可以在 Apple Podcasts、Spotify 或您喜爱的播客应用中订阅本节目……我们下期再见。