# Uri Levine - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Uri Levine.

---

### [00:00:00] Lenny Rachitsky

**English:**
You've co-founded 10 different companies. You've been on the board of 20. You've also built two unicorns including Waze. The biggest startup lesson you seem to have taken out of that is to—

**中文翻译:**
你共同创立了 10 家不同的公司，担任过 20 家公司的董事。你还打造了两家独角兽企业，其中包括 Waze。你从中总结出的最大的创业教训似乎是——

---

### [00:00:09] Uri Levine

**English:**
Fall in love, fall in love, fall in love, fall in love with the problem, and then actually what you're trying to do is engage everyone else to fall in love with the same problem, to go into this journey, into this path and follow your leadership there.

**中文翻译:**
爱上、爱上、爱上、爱上那个“问题”。实际上，你真正要做的是吸引其他人也爱上同一个问题，共同踏上这段旅程，沿着这条路径追随你的领导。

---

### [00:00:20] Lenny Rachitsky

**English:**
Anything you wanted to share around hiring and firing?

**中文翻译:**
关于招聘和解雇，你有什么想分享的吗？

---

### [00:00:23] Uri Levine

**English:**
Every time that you hire someone new, mark your calendars for 30 days down the road and ask yourself one question, knowing what I know today, would I hire this person? If the answer is no, fire them immediately.

**中文翻译:**
每次你雇佣新员工时，在日历上标注出 30 天后的日期，然后问自己一个问题：基于我今天所了解的情况，我还会雇佣这个人吗？如果答案是否定的，请立即解雇他们。

---

### [00:00:36] Lenny Rachitsky

**English:**
Let's actually talk about fundraising.

**中文翻译:**
我们来聊聊融资吧。

---

### [00:00:37] Uri Levine

**English:**
Most people are missing the most important slide of their presentation is the first slide. This slide is going to be presented for the longest period of time. This is the place that you're going to put your strongest point. Now the second most important slide is the last one.

**中文翻译:**
大多数人都忽略了演示文稿中最重要的一张幻灯片，那就是第一张。这张幻灯片展示的时间最长。这里应该是你展示最强有力观点的地方。而第二重要的幻灯片是最后一张。

---

### [00:00:56] Lenny Rachitsky

**English:**
Today my guest is Uri Levine. Uri is the co-founder of Waze and nine other companies. He sold two companies for over a billion dollars. He's also been on 20 different startup boards, including a dozen he's still currently on. He's also advised over 50 founders and startups over his career. More recently, he wrote a book that summarizes all of his advice for founders called *Fall in Love with the Problem, Not the Solution, A Handbook for Entrepreneurs*. In the foreword to the book, Steve Wozniak said, "This book will change your life and become your Bible if you are an entrepreneur," and I cannot disagree with that. This book is very tactical with amazing stories and walks you through the ideation phase all the way to exiting your company.

(00:01:39):
In my conversation with Uri, we chat about many of my favorite chapters, including why falling in love with the problem is so important, how to find product market fit, a really clever tactic for firing people who aren't a fit for your company, a ton of really genius tactical advice for improving your fundraising pitch and so much more. With that, I bring you Uri Levine, and if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously. Uri, thank you so much for being here. Welcome to the podcast.

**中文翻译:**
今天的嘉宾是 Uri Levine。Uri 是 Waze 和其他九家公司的联合创始人。他以超过 10 亿美元的价格卖掉了两家公司。他还担任过 20 个不同的初创公司董事会席位，目前仍担任其中十几个。在他的职业生涯中，他还为 50 多位创始人和初创公司提供过咨询。最近，他写了一本书，总结了他对创始人的所有建议，书名叫做《爱上问题，而非解决方案：创业者手册》。在书的序言中，史蒂夫·沃兹尼亚克（Steve Wozniak）说：“如果你是一名创业者，这本书将改变你的生活，并成为你的圣经。”我完全同意。这本书非常具有战术性，充满了精彩的故事，引导你从构思阶段一直走到公司退出。

(00:01:39):
在与 Uri 的交谈中，我们聊到了许多我最喜欢的章节，包括为什么爱上问题如此重要、如何找到产品市场契合点（PMF）、一个解雇不合适员工的聪明策略、大量提升融资演讲水平的天才战术建议等等。下面，让我们欢迎 Uri Levine。如果你喜欢这个播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本节目有很大帮助。Uri，非常感谢你能来，欢迎来到本播客。

---

### [00:02:17] Uri Levine

**English:**
Thank you. Happy to be here.

**中文翻译:**
谢谢，很高兴来到这里。

---

### [00:02:18] Lenny Rachitsky

**English:**
Okay, so here's what I've gathered about your career, and let me know if I've missed anything. You've co-founded 10 different companies, including four you're still operating. You've been on the board of 20 companies. You've advised 50, maybe more, companies. You've also built two unicorns, including Waze, which you sold for over a billion dollars, which back then was an astronomical amount of money. It still is. So does that all sound right? Is there anything big I missed about your career?

**中文翻译:**
好，这是我收集到的关于你职业生涯的信息，如果有遗漏请告诉我。你共同创立了 10 家不同的公司，其中 4 家目前仍在运营。你担任过 20 家公司的董事，为 50 多家（甚至更多）公司提供过咨询。你还打造了两家独角兽公司，包括以超过 10 亿美元出售的 Waze，这在当时是一笔天文数字，现在依然是。这些都对吗？关于你的职业生涯，我有什么重大的遗漏吗？

---

### [00:02:48] Uri Levine

**English:**
That sounds about right.

**中文翻译:**
听起来差不多。

---

### [00:02:49] Lenny Rachitsky

**English:**
I think what's really interesting to me is that from all of that experience, the biggest startup lesson you seem to have taken out of that is to fall in love with the problem. It's what your book is called. You have a T-shirt that you're wearing right now that you wear on every podcast that says that exactly. Clearly this lesson has struck a big chord with you. I'm curious if there's a moment where you realize that that's the core and that's something that every founder needs to get right. Is there an aha moment or is it kind of this progressive like, "Oh, wow, maybe this is the secret."

**中文翻译:**
我觉得非常有趣的是，从所有这些经验中，你总结出的最大的创业教训似乎就是“爱上问题”。这也是你书的名字。你现在穿的 T 恤上就印着这句话，而且你每次上播客都穿它。显然，这个教训引起了你强烈的共鸣。我很好奇，是否有一个特定的时刻让你意识到这就是核心，是每个创始人必须做对的事情？是有一个“顿悟时刻”，还是一个循序渐进的过程，比如“噢，哇，也许这就是秘诀”？

---

### [00:03:19] Uri Levine

**English:**
I'm not sure that this is a certain moment. I think that that was evolving over time and realizing that, look, at the end of the day, the entrepreneurship journey is about value creation. The simplest way to create value is solve a problem. That's the simplest way. And in my background, I'm an engineer always looking for the simplest way, and solve a problem is the simplest way, and so this is where fall in love with the problem coming from, and people occasionally would confuse the T-shirt with the book, and now the T-shirt is about 10 or even more years old and the book is only two years old, and so I was wearing those T-shirts for a long while before I wrote the book and when I wrote the book that was obvious that this is going to be the name of the book, but they are way more into that, right?

(00:04:06):
So when you fall in love with the problem, then what happened is that the problem is going to serve as the North Star of your journey, and when you have a North Star, you're going to make less deviation from the course and you are way more likely to become successful. But also the story that you are about to tell is way more compelling. Just imagine that we will be here in 2007, just before I started Waze, and I will tell you I'm going to build an AI crowd-source based navigation system and you're going to say, "Oh, yeah, very interesting," but you don't care. If I will tell you I'm going to help you to avoid traffic jams, then you do care, and when your customer cares, they want you to be successful, and when they want you to be successful, they are going to help you to become successful.

(00:04:56):
And so in that sense, fall in love with the problem is really a key to increase the likelihood of being successful. So in general, all of my startups start with a problem. Think of a problem, a big problem, something that it's worth solving, something that the world will become a better place if you solve that and then ask yourself, so who has this problem? If you happen to be the only person on the planet with this problem, I can recommend you a therapist. Don't build a startup. It's way more expensive and takes way longer period of time to build a startup. But if a lot of people actually have this problem, what you really want to do next is go and speak with those people and understand their perception of the problem and only then start to build the solution. If you follow this path and your solution works, it's guaranteed that you're creating value.

(00:05:47):
If you start with a solution, you might be building something that no one cares and that's really frustrating. So fall in love with the problem. This is where you want to start. Now this is really hard because I am getting tons of emails every week from entrepreneurs and they all start with what we are doing and I don't really care what you're doing. What I really care about is why you are doing that, and this is the problem that you solve or the value that you create or the value that you create for me. This is what really matters, right? And so if you start your story with, "Our company is," or, "Our system is," and in the recent year everything is, "Our AI system is," or, "Our AI company is." But generally speaking, if you start your story with that, you focus on your solution. If you start with the story with, "The problem we are solving is," Then you focus on the problem. If your story start with, "The value that we create for you is," then you focus on the user. The last two are way better than focus on the solution.

**中文翻译:**
我不确定是否有一个特定的时刻。我认为这是一个随着时间推移而演变的过程，我意识到，归根结底，创业之旅就是关于价值创造。创造价值最简单的方法就是解决一个问题。这是最简单的路径。我的背景是一名工程师，总是在寻找最简单的方法，而解决问题就是最简单的方法，这就是“爱上问题”的由来。人们偶尔会把 T 恤和书搞混，其实这件 T 恤已经有 10 多年历史了，而书才出版两年。在写书之前，我已经穿了很久这种 T 恤了，所以写书时，书名自然而然就定了。但其中的含义远不止于此。

(00:04:06):
当你爱上问题时，这个问题就会成为你创业旅程中的“北极星”。有了北极星，你就不会轻易偏离航向，成功的可能性也会大大增加。此外，你讲的故事也会更有说服力。想象一下，如果我们在 2007 年，就在我创办 Waze 之前，我告诉你我要建立一个基于 AI 众包的导航系统，你会说：“哦，挺有意思的”，但你并不真的在乎。但如果我告诉你，我要帮你避开交通拥堵，那你就在乎了。当你的客户在乎时，他们就希望你成功；当他们希望你成功时，他们就会帮助你成功。

(00:04:56):
所以从这个意义上说，爱上问题确实是提高成功概率的关键。总的来说，我所有的初创公司都始于一个问题。思考一个问题，一个大问题，一个值得解决的问题，一个如果你解决了它，世界会变得更美好的问题。然后问自己：谁有这个问题？如果你是地球上唯一有这个问题的人，我建议你去找心理医生，而不是去创业。创业要贵得多，耗时也长得多。但如果很多人都有这个问题，你接下来要做的就是去和这些人交流，了解他们对这个问题的看法，然后才开始构建解决方案。如果你遵循这条路径且方案奏效，那么你创造价值就是板上钉钉的事。

(00:05:47):
如果你从解决方案开始，你可能会造出一个没人关心的东西，那是非常令人沮丧的。所以，爱上问题，这是你的起点。但这其实很难，因为我每周都会收到大量创业者的邮件，他们开头总是说“我们在做什么”，但我并不关心你在做什么。我真正关心的是你“为什么”要做这件事，也就是你解决的问题、你创造的价值，或者你为“我”创造的价值。这才是真正重要的。所以，如果你的故事开头是“我们的公司是……”或“我们的系统是……”（最近一年全是“我们的 AI 系统是……”），那么你关注的是解决方案。如果你的开头是“我们要解决的问题是……”，那么你关注的是问题。如果开头是“我们为你创造的价值是……”，那么你关注的是用户。后两者比关注解决方案要好得多。

---

### [00:06:59] Lenny Rachitsky

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now you can assess risk, secure the trust of your customers and automate compliance For SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risk, plus you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to Vanta.com/Lenny. That's V-A-N-T-A.com/Lenny.

(00:07:52):
This episode is brought to you by Mercury. Mercury knows your financial operations are complex. It doesn't have to be this way. I've been a super happy customer of Mercury for over a year now and it's honestly hard to imagine a better online banking experience can exist. Most founders and finance teams have to couple together a patchwork of tools to reconcile transactions from different sources, work extra hard just to get a holistic view of cashflow and have maps to company priorities and struggle to get answers from platforms that all speak different languages. Mercury knows that there's an art to simplifying this complex patchwork. With new bill pay and accounting capabilities, you can pay bills faster, stay in control of company spend and speed up reconciliation. The end result is the precision control and focus that startups need to transform how they operate. Apply in minutes at Mercury.com and join over 200,000 ambitious startups like mine that trust Mercury to get them to perform at their best. Mercury, the art of simplified finances. Mercury is a financial technology company, not a bank. Banking services provided by Choice Financial Group and Evolve Bank & Trust. Members FDIC.

**中文翻译:**
本期节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，事情很快就会变得复杂。现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险，此外，你还可以通过 Vanta AI 完成安全问卷，节省数小时的时间。加入成千上万家使用 Vanta 自动收集证据、统一风险管理并简化安全审查的全球公司吧。访问 Vanta.com/Lenny 即可享受 1000 美元的优惠。网址是 V-A-N-T-A.com/Lenny。

(00:07:52):
本期节目由 Mercury 赞助。Mercury 知道你的财务运营很复杂，但其实不必如此。我已经做了一年多 Mercury 的忠实客户了，老实说，很难想象还有比这更好的在线银行体验。大多数创始人和财务团队不得不拼凑各种工具来对账、费力地获取现金流的全景视图、将其与公司优先级挂钩，并挣扎着从各种语言不通的平台获取答案。Mercury 知道简化这种复杂拼凑是一门艺术。凭借全新的账单支付和会计功能，你可以更快地支付账单，掌控公司支出并加速对账。最终结果是初创公司转型运营方式所需的精准控制和专注。只需几分钟即可在 Mercury.com 申请，加入超过 20 万家像我一样信任 Mercury 的雄心勃勃的初创公司，让他们助你发挥最佳水平。Mercury，简化财务的艺术。Mercury 是一家金融科技公司，而非银行。银行服务由 Choice Financial Group 和 Evolve Bank & Trust 提供。FDIC 成员。

---

### [00:09:02] Lenny Rachitsky

**English:**
I want to follow a couple threads here because I imagine there's certain problems people fall in love with. "Amazing. I want to solve this very obscure problem for my family or a friend of mine," and then they realize this is never going to be a huge venture scale business, if that's a goal of theirs. You talked about like, make sure enough people have this problem versus just getting a therapist that's going to help you with this problem. What are some signals and heuristics folks can use to help them understand this is a big enough problem that it's really worth their time?

**中文翻译:**
我想顺着这个思路聊聊，因为我能想象到人们会爱上某些特定的问题。比如“太棒了，我想为我的家人或朋友解决这个非常冷门的问题”，然后他们意识到这永远不会成为一个巨大的风险投资规模的业务（如果那是他们的目标的话）。你提到过要确保足够多的人有这个问题，而不是只找个心理医生帮你解决。人们可以使用哪些信号和启发式方法来帮助他们理解这是一个足够大、值得投入时间的问题？

---

### [00:09:30] Uri Levine

**English:**
So people ask me, "So you send me to speak with users. How many?" And I will tell them a hundred. You don't need a hundred, but the hundred basically say you need to get out of your comfort zone. It's not just your close friends and family that you need to discuss that. You need to discuss that with people that you don't know. And usually what happen is, and the validation is in most cases is really clear, right? If you tell someone, "This is the problem I'm going to address," and they will tell you, "Oh, I know someone that has this problem," it's not a real problem. If they will tell you, "No, no, no, no, no. This is not the problem. The problem is," and they will give you their description of the problem. This is something that you really want to follow. So if you speak with a hundred people, but if you actually speak with 20 people that you don't know, you will get validated whether or not this problem is real or not.

(00:10:23):
And look, it's not the only way to become successful, right? You look at one of the most successful products in the world, the iPhone, right? And you ask yourself, what was exactly the problem when they started? And the answer is that there was no problem when they started. There were smartphones and people were actually very happy with them. And so occasionally we need to invent something completely new, but solving a problem is simply the simplest way to create value.

**中文翻译:**
人们会问我：“你让我去和用户交流，要找多少个？”我会告诉他们 100 个。你其实不需要 100 个，但“100”这个数字基本上是在说你需要走出舒适区。你不能只和亲朋好友讨论，你需要和陌生人讨论。通常情况下，验证过程在大多数时候是非常清晰的。如果你告诉某人：“这是我要解决的问题”，而他们回答：“哦，我认识的人里有人有这个问题”，那这通常不是一个真正的问题。如果他们说：“不不不，那不是问题所在，真正的问题是……”，并给出他们对问题的描述，这才是你真正需要关注的。所以，如果你和 100 个人交流，或者哪怕只是和 20 个陌生人交流，你就能验证这个问题是否真实存在。

(00:10:23):
而且，这并不是成功的唯一途径。看看世界上最成功的产品之一——iPhone。你会问，他们开始时到底要解决什么问题？答案是，开始时并没有什么迫切的问题。当时已经有智能手机了，人们用得也挺开心。所以偶尔我们需要发明全新的东西，但解决问题依然是创造价值最简单的方法。

---

### [00:10:53] Lenny Rachitsky

**English:**
Another element of picking a problem to work on, so you say you fall in love with a problem. Is being excited to work on this problem. There's oftentimes problems you find that aren't that exciting to you or you're not excited to work on real estate software, but you find there's a big problem. How important is it that you're personally passionate and excited to work on this thing versus like, "Oh, wow. This is a huge business opportunity. I got to go after it. It doesn't matter if I'm not that passionate about it."

**中文翻译:**
选择问题的另一个要素是，你刚才说要“爱上”一个问题。也就是对解决这个问题感到兴奋。很多时候你发现的问题可能并不让你兴奋，比如你对开发房地产软件没兴趣，但你发现那里有个大问题。个人热情和兴奋感有多重要？相比于仅仅觉得“哇，这是一个巨大的商业机会，我必须抓住它，即使我没那么有热情也没关系”？

---

### [00:11:20] Uri Levine

**English:**
Fall in love, right? This is really passionate. Really, really passionate. Look, the journey is really hard and complex and long and so you have to be in love in order to go into this journey because otherwise it's not going to be successful. You really want to be passionate. If you're not passionate about the problem, even though that the problem might be real and big and significant, there is not enough drive, there is not enough internal drive to take you through the hardship of the journey, and so you need to be passionate. You need to fall in love. You personally need to fall in love with the problem. And then actually what you're trying to do is engage everyone else to fall in love with the same problem, to go into this journey, into this path and follow your leadership there.

**中文翻译:**
是“爱上”，对吧？这代表着极大的热情。非常、非常强烈的热情。听着，创业旅程非常艰难、复杂且漫长，所以你必须深爱它才能走下去，否则不会成功。你真的需要充满激情。如果你对这个问题没有热情，即使问题真实、巨大且意义深远，你也没有足够的动力，没有足够的内在驱动力带你度过旅程中的艰难困苦。所以你需要充满激情，你需要爱上它。你个人必须爱上这个问题。然后，你实际上要做的是吸引其他人也爱上同一个问题，共同踏上这段旅程，追随你的领导。

---

### [00:12:05] Lenny Rachitsky

**English:**
Is there an example of a pivot that you maybe went through where you realized the problem was not as big as you thought or you realized there's a bigger problem?

**中文翻译:**
有没有什么转型的例子？比如你意识到问题没有你想象的那么大，或者你发现了一个更大的问题？

---

### [00:12:13] Uri Levine

**English:**
So actually there are many, right? So Oversee deals with maybe biggest secret in travel industry. What happened to airfare after you booked your flight? Now you have no idea because you never compare prices after you met the reservation. But you know that airfare is going up and down all the time. It's going up and down before you are making the reservation and keep on going up and down after you're making the reservation. So if this is the price that you paid and this is cancellation fees, if the price drops here, you can rebook the same flight at the cheaper price.

**中文翻译:**
实际上有很多。比如 Oversee 这家公司，它处理的是旅游业最大的秘密：你订完机票后，票价会发生什么变化？你通常不知道，因为订完后你从不比价。但你知道机票价格一直在波动。订票前在波动，订票后依然在波动。所以，如果你支付了某个价格，而取消手续费是这么多，如果价格跌到了这里，你就可以以更便宜的价格重新预订同一航班。

---

### [00:12:48] Lenny Rachitsky

**English:**
Genius.

**中文翻译:**
天才的想法。

---

### [00:12:49] Uri Levine

**English:**
If you would only keep on comparing prices after that, right? So we started this company that is actually monitoring your own itinerary and we realized that this is going to be huge benefits to travelers and we started that as a B2C company, direct to consumers, and we realized that even though the people really care, they are not willing to take the action that is required, and we ended up with doing that for corporates, and in corporates there are very simple ways for them to engage that automatically, so automatic rebooking and so forth, and we can save corporates about 10% of the travel budget that goes directly to bottom line. So we started that as a B2C and then we realized that this is way harder than we think it is, and we ended up with converting that into B2B, which turns out to be very successful for us. And so occasionally there are companies that you start your journey with one perception and you change that and that will happen multiple times.

**中文翻译:**
只要你在订票后继续比价就行，对吧？所以我们创办了这家公司，专门监控你的行程。我们意识到这对旅客有巨大好处，于是最初作为一家 B2C（直接面向消费者）公司启动。但我们发现，尽管人们很在乎，但他们不愿意采取必要的行动。最后我们转向了为企业服务。在企业内部，有非常简单的方法可以自动执行，比如自动重新预订等。我们可以为企业节省大约 10% 的差旅预算，这直接转化成了利润。所以我们从 B2C 开始，意识到这比想象中难得多，最后转成了 B2B，结果证明对我们非常成功。所以偶尔有些公司，你带着一种认知开始旅程，然后改变它，这种情况会发生多次。

---

### [00:14:00] Lenny Rachitsky

**English:**
That's an awesome example. I want to, before I move on to, I'm kind of thinking about this in the phases of starting a company. So we're talking right now about coming up with the idea that you want to commit to. A lot of people that want to start companies are not sure how to find a great idea, so the core advice you're sharing is find something, find a problem, and fall in love with solving that problem in whatever way you can. Do you have any other advice for helping somebody find a problem and finding a startup idea? Where do you find startup ideas? What do you find? What does work for you mostly?

**中文翻译:**
这是一个很棒的例子。在继续之前，我在思考公司起步的各个阶段。我们现在讨论的是确定一个你想投入的想法。很多想创业的人不知道如何找到好点子，所以你分享的核心建议是：找个东西，找个问题，并爱上用各种可能的方式解决它。对于帮助别人发现问题和寻找创业点子，你还有其他建议吗？你从哪里发现创业点子？什么对你最有效？

---

### [00:14:30] Uri Levine

**English:**
So for me, it's usually personal frustration that leads me to start to think about it, whether or not we can change it. I hate traffic jams, right? I hate leaving money on the table, right? So there are many things that I ran into and I get frustrated and I tell myself, "No, no, no. There must be a different way to do that." But in general, look, the problem itself needs to start from you, right? Something that really bothers you, something that you care about, and then it's the validations of the problem that you speak with many people, try to realize. Now if you'll tell me, oh, this is a B2B, then speak with many businesses, right? Speak with those that you believe actually do have this problem and I understand their perception.

(00:15:13):
Once you validate that, then there are few things that you need to realize. One is about the journey itself. This is going to be a multi-dimensional journey. It's going to be at least three dimensions and maybe fourth, right? So the three dimensions, one of them is it's going to be a roller coaster journey with ups and downs and ups and downs. And look, if you'll tell me that all the businesses in the world have ups and downs, I agree, but the frequency of those when you are building a startup? Way higher. I think that I heard the best quote on that from Ben Horowitz, Ben Horowitz from Andreessen Horowitz venture capital firm, and before that he used to be a CEO of a startup and he was asked whether or not he was sleeping well at night and he said, "Oh, yeah, I slept like a baby. I woke up every two hours and cried." And that's really the reality of that. The frequency of the differences are so dramatic that there is nothing compared to that, a roller coaster journey.

(00:16:17):
It's also a journey of failures. Look, we are trying to build something new that no one did before, and even though that we think that we know exactly what we are doing, we don't. So we try. We try one thing and it doesn't work. We try another thing and it doesn't work. Or if we keep on trying different things until we find one thing that does work. Now, if you realize that this is going to be a journey of failures, then there are two immediate conclusions. The first one is that if you're afraid to fail, then in reality you already failed because you are not going to try. Albert Einstein used to say that if you haven't failed, that because you haven't tried new things before. If you're going to try new things, you will fail. Michael Jordan used to say that, "I've failed over and over and over and over again and this is what made me successful." And so this is the first conclusion.

(00:17:07):
The second conclusion is that you really want to fail fast. Just think about it, right? If you fail fast, you still have plenty of time to try another attempt and build another version of the product. Try another go-to-market approach. Try a different business model so you still have plenty of time to make more and more and more attempts, and the more attempts that you have, you simply increase the likelihood of being successful. Just think that you play basketball, right, and you try to score from half court. If you have one shot and you are not Steph Curry, you are very likely to miss. But if you actually have a lot of shots, one of them you're going to make. That's it. Just think about it. The biggest enemy of good enough is perfect. You don't need to be perfect. You need to be good enough in order to win the market, and the way that you are going to become good enough, by the way, is really simple. You start with not good enough and you iterate and iterate and iterate until you become good enough and then you'll win.

(00:18:10):
The third dimension is that this is going to be long journey. Very long. Way longer than you think it is. And the longest part of it is until you figure out product market fit, and product market fit goes into the different phases of building a company. To a certain extent, I would say, look, the difference between a corporate and a startup is that a corporate knows this is our value proposition, this is the product that we are selling, this is the pricing of this product that we are selling, this is the target audience, this is how we are going to sell them, this is how we going to the market, and all we have to do is keep on executing and hopefully nothing will change over the period of time. When you start as a startup, you don't have a product. You don't know what's the business model. You don't know what people are going to pay you for. You don't know how to grow your business, and you need to figure out all of those, and this is going to be a long journey.

(00:19:11):
Now, the longest part is usually figuring out product market fit and product market fit is really simple. That means that you create value to your customers. If you do not figure out product market fit, you will die. As simple as that. You never heard of a company that did not figure out product market fit. They simply died. That's it. Now, once they do, and for a second I want you to think of, with all the applications that you're using every day, right? From searching Google, using Waze, WhatsApp, Facebook, Netflix, Uber, whatever it is, and ask yourself what is the difference between any of those today and the first time that you have used that? And the answer is that there is no difference. We are searching Google today the same way that we searched Google for the first time in our life. We're using Waze today the same way that we used Waze for the first time in their life. So once a company figure out product market fit, they don't change their product anymore because this is the value that they created to the customers and you don't want to change that.

(00:20:14):
What we don't know is how long did it take them to get to this point, right? Beforehand we never heard of them and after that they don't change that anymore. It's a matter of years. For Waze, it was four years. For Microsoft, it was five years. For Netflix, it was 10 years. Now if you'll tell me, "Oh, today is very different. ChatGPT just started a year ago." No, they're seven years old. It took them six years until you heard about them for the first time in your life. So it does take time to create value and this is something that is really significant. Now, at the end of the day, product market fit have one metric. One metric. That's it. Retention. That's really simple. If you create value, they will come back. If they're not coming back, that means that you are not creating value. Now think about your episodes, right, of this podcast, right? Most of your listeners are returning, right? Because you create value for them and they are coming back. That's it.

**中文翻译:**
对我来说，通常是个人挫败感引导我开始思考是否可以改变现状。我讨厌堵车，对吧？我讨厌白白浪费钱，对吧？所以我遇到了很多让我沮丧的事情，我会告诉自己：“不不不，一定有不同的方法来做这件事。”但总的来说，问题本身需要从你开始，也就是真正困扰你、你真正关心的事。然后是验证问题，去和很多人交流。如果你说这是 B2B，那就去和很多企业交流，找那些你认为确实有这个问题的人，了解他们的看法。

(00:15:13):
一旦你验证了这一点，你需要意识到几件事。一是关于旅程本身。这将是一个多维度的旅程，至少有三个维度，也许还有第四个。这三个维度中，一个是它将是一段过山车般的旅程，起起伏伏。如果你告诉我世界上所有的生意都有起伏，我同意，但在创办初创公司时，这种起伏的频率要高得多。关于这一点，我听过最精彩的引用来自 Ben Horowitz（Andreessen Horowitz 风险投资公司的合伙人），他以前是初创公司的 CEO。有人问他晚上睡得好吗，他说：“噢，是的，我睡得像个婴儿——每两个小时醒来哭一次。”这就是现实。起伏的频率如此剧烈，没有什么能与之相比，这就是一段过山车之旅。

(00:16:17):
这同时也是一段失败之旅。听着，我们试图创造前所未有的新事物，尽管我们认为自己清楚在做什么，但其实并不清楚。所以我们尝试。尝试一件事，行不通；再试另一件，还是行不通。我们会不断尝试不同的东西，直到找到行得通的那一个。如果你意识到这是一段失败之旅，那么会有两个直接的结论。第一，如果你害怕失败，那么实际上你已经失败了，因为你根本不会去尝试。爱因斯坦曾说，如果你从未失败过，那是因为你从未尝试过新事物。如果你尝试新事物，你就会失败。迈克尔·乔丹也说过：“我一次又一次地失败，这正是我成功的原因。”这就是第一个结论。

(00:17:07):
第二个结论是，你真的需要“快速失败”。想想看，如果你失败得快，你就有充足的时间进行另一次尝试，构建另一个版本的产品，尝试另一种进入市场的方法，尝试不同的商业模式。你尝试的次数越多，成功的可能性就越大。就像打篮球，你尝试从中场投篮，如果你只有一次机会且你不是库里，你很可能会投丢。但如果你有很多次机会，总有一个会进。就是这样。想想看，“完美”是“足够好”的最大敌人。你不需要完美，你只需要“足够好”就能赢得市场。顺便说一下，变得足够好的方法很简单：从“不够好”开始，不断迭代、迭代、再迭代，直到变得足够好，然后你就赢了。

(00:18:10):
第三个维度是，这将是一段漫长的旅程。非常长，比你想象的要长得多。其中最长的部分是直到你找到“产品市场契合点”（PMF）。PMF 贯穿于公司建设的不同阶段。在某种程度上，我会说，大公司和初创公司的区别在于：大公司知道自己的价值主张、销售的产品、产品的定价、目标受众、销售方式以及如何进入市场，他们要做的就是不断执行，并希望在一段时间内一切保持不变。而当你开始创业时，你没有产品，不知道商业模式，不知道人们会为什么付钱，不知道如何发展业务，你需要弄清楚所有这些，这将是一段漫长的旅程。

(00:19:11):
通常最长的部分是弄清楚 PMF，而 PMF 其实很简单：这意味着你为客户创造了价值。如果你没弄清楚 PMF，你就会死掉。就这么简单。你从未听说过哪家公司没弄清楚 PMF 还能活下来，他们只是死掉了。一旦他们找到了 PMF——我想让你思考一下你每天使用的所有应用，从谷歌搜索、Waze、WhatsApp、Facebook、Netflix 到 Uber——问问自己，这些应用今天和你第一次使用时有什么区别？答案是：没有区别。我们今天搜索谷歌的方式和我们生命中第一次搜索谷歌的方式是一样的。我们今天使用 Waze 的方式和第一次使用时也是一样的。所以一旦一家公司找到了 PMF，他们就不再改变产品了，因为这就是他们为客户创造的价值，你不想改变它。

(00:20:14):
我们不知道的是，他们花了多长时间才达到这一点。在那之前我们从未听说过他们，在那之后他们就不再改变了。这通常需要数年时间。Waze 花了 4 年，微软花了 5 年，Netflix 花了 10 年。如果你告诉我：“哦，现在不一样了，ChatGPT 一年前才开始。”不，他们已经 7 岁了。他们花了 6 年时间才让你第一次听说他们。所以创造价值确实需要时间，这是非常重要的。归根结底，PMF 只有一个指标：留存率。就这么简单。如果你创造了价值，他们就会回来；如果他们不回来，说明你没有创造价值。想想你这档播客的节目，你大多数听众都是回头客，对吧？因为你为他们创造了价值，所以他们会回来。就是这样。

---

### [00:21:24] Lenny Rachitsky

**English:**
100%. Every single one, every episode.

**中文翻译:**
100%。每一位听众，每一集节目。

---

### [00:21:29] Uri Levine

**English:**
Occasionally there are new one, right?

**中文翻译:**
偶尔也会有新听众，对吧？

---

### [00:21:30] Lenny Rachitsky

**English:**
And there's new ones coming in all the time.

**中文翻译:**
是的，一直有新听众加入。

---

### [00:21:32] Uri Levine

**English:**
[inaudible 00:21:32]. By the way, this is one thing that some businesses don't realize, whether or not their customers are going to be new customers or returning customers, and in many cases they simply fail to realize that upfront and the result is that they are not building the right go-to-market strategy.

**中文翻译:**
顺便说一下，这是有些企业没有意识到的事情：他们的客户到底是新客户还是回头客。在很多情况下，他们未能在前期意识到这一点，结果就是他们没有制定正确的进入市场策略。

---

### [00:22:09] Lenny Rachitsky

**English:**
We covered a lot of ground there. That was amazing. I'm going to follow a number of threads of things you just touched on. You talked about product market fit briefly. What was the moment you felt product market fit with Waze? I don't know if I've ever heard that story.

**中文翻译:**
我们聊了很多内容，太精彩了。我想顺着你刚才提到的几点继续。你简要谈到了产品市场契合点（PMF）。你在 Waze 的哪个时刻感受到了 PMF？我不记得听过这个故事。

---

### [00:22:09] Uri Levine

**English:**
We started in Israel and Israel is a small place and we ended up with being very successful in Israel and then we said, "Wait a minute. Waze crowdsource all the data, right?" Not just the traffic information and speed cams and so forth, but also the map data itself, so we can start from a blank page. And the users while they drive, they create the map and they create traffic information and so forth. And so we figure out that we can start anywhere and we made Waze global at the end of 2009 and we expect that to work the same way that it did in Israel, but it didn't. It was not good enough. It was not good enough in the U.S. It was not good enough in Western Europe. It was not good enough in Latin America, it was not good enough in Asia. It was not good enough anywhere that matters, right?

(00:22:57):
It was actually good enough in about four places. In the Czech Republic, in Slovakia, in Latvia and Ecuador, and that's about it. Rest of the world not good enough. So what we did is we spoke with the drivers. Look, they wanted us to be successful. We basically said the drivers are going to fight traffic jams together, so common enemy, togetherness, all goodness. Everyone wanted that to work, right? So people downloaded the app and it simply was not good enough. So they churned, right, because if it's not good enough, you're not coming back. We spoke with them. We asked them what didn't work for them. They told us because they wanted it to work, and we built the next version addressing everything that they've told us, and we know that this is it, and it's not. So we doing it all over again. We speak with the drivers. We ask them what didn't work for them, they tell us. Now we build the next version and now we have the conviction that it's going to work and it's not. Journey of failures.

(00:23:58):
Iteration after iteration after iteration after iteration. More than a year of iterations until beginning of 2011 that we actually started to see that working, and then it's in multiple places. In the U.S., one metropolitan after the other, right? Los Angeles first and then San Francisco and then Washington D.C. and Chicago and New York and Atlanta and so forth. In Europe, one country after the other. Italy first and then France and Netherlands and Sweden and Spain and one country after the other. In Latin America, one country after the other. Colombia first and then Chile and then Brazil and then Mexico and then rest of Latin America. In Asia, multiple countries one after the other. Not all of them, by the way. Not all of them. Japan is a very good example where it didn't work and it will never work. Waze crowdsourced the information, right? Which basically says that as soon as we get to the level of good enough, then we are good enough.

(00:25:01):
House numbering plan. In the U.S., it's really simple, right? Every block is a hundreth numbers, right? And so if I have the map, I can actually count the number of blocks and take you to approximate the right location even if I don't have exactly all the house numbers there. Most of the western world, it's a geographical order. So in Israel, this is going to be sequential order, odd number on one side of the street, even number on the other side of the street starting from one until the end of the street and so forth, so it's enough that I will have few house numbers that I can actually take you to the right place.

(00:25:38):
In the UK, house number starts on one side off the street and then on the other side they are coming back, right? And so there is an order. In Japan, it's chronological order. The oldest house in the neighborhood is house number one.

(00:25:54):
And then the house number two can be miles away, but it's the second oldest house in the neighborhood and so you have to have all the house numbers unless... Until then you are not good enough. And crowdsource is, if you need perfect information, crowdsource may not be the right way to do that.

**中文翻译:**
我们从以色列开始，以色列很小，我们在那里非常成功。然后我们想：“等一下，Waze 的所有数据都是众包的，对吧？”不仅是交通信息和测速摄像头，连地图数据本身也是。所以我们可以从白纸开始，用户在驾驶时创建地图、生成交通信息等等。于是我们意识到可以从任何地方开始。2009 年底，我们将 Waze 推向全球，期望它能像在以色列那样运作，但事实并非如此。它不够好。在美国不够好，在西欧不够好，在拉美、在亚洲都不够好。在任何重要的地方都不够好。

(00:22:57):
实际上，它只在四个地方表现得足够好：捷克、斯洛伐克、拉脱维亚和厄瓜多尔。仅此而已，世界其他地方都不行。于是我们去和司机交流。听着，他们希望我们成功。我们基本上是在说“司机们要团结起来对抗交通拥堵”，共同的敌人、团结一致、美好的愿景，大家都希望这能成。人们下载了应用，但它就是不够好。所以用户流失了，因为如果不够好，你就不会再回来。我们和他们交流，问他们哪里不好。他们告诉了我们，因为他们希望它好用。我们根据反馈构建了下一个版本，我们觉得这次肯定行了，结果还是不行。于是重头再来。再找司机聊，再听反馈。构建新版本，满怀信心地认为这次稳了，结果还是不行。这就是失败之旅。

(00:23:58):
一次又一次的迭代。迭代了一年多，直到 2011 年初，我们才真正看到它开始起作用。然后它在多个地方爆发。在美国，一个大都市接着一个：先是洛杉矶，然后是旧金山、华盛顿、芝加哥、纽约、亚特兰大等等。在欧洲，一个国家接着一个：意大利、法国、荷兰、瑞典、西班牙。在拉美，哥伦比亚、智利、巴西、墨西哥，然后是整个拉美。在亚洲，也是一个接一个。顺便说一下，并不是所有地方都行。日本就是一个典型的例子，它在那里行不通，也永远行不通。Waze 依靠众包信息，这意味着只要达到“足够好”的水平，我们就行。

(00:25:01):
但看看门牌号方案。在美国很简单，每个街区大约 100 个号，所以我只要有地图，数街区就能把你带到大致正确的位置，即使没有精确的门牌号。西方大部分地区是地理顺序。在以色列是连续顺序，街道一侧是奇数，另一侧是偶数，从 1 号开始到结尾。所以我只要有几个门牌号，就能带你去正确的地方。

(00:25:38):
在英国，门牌号从街道一侧开始编，然后从另一侧绕回来，也是有顺序的。但在日本，是按年代顺序编的。社区里最老的房子是 1 号。

(00:25:54):
2 号房子可能在几英里外，因为它只是社区里第二老的房子。所以你必须拥有所有的门牌号数据，否则你就达不到“足够好”。而众包这种方式，如果你需要完美无缺的信息，可能并不是最合适的方法。

---

### [00:26:32] Lenny Rachitsky

**English:**
Just to close the loop on this question, when you were launching these markets and it wasn't working, were you actually looking at retention at that point, and if so, was there a number you were looking for? Or was it more qualitative like it's just taken off off into the right. Like where were you actually watching back in the early days?

**中文翻译:**
为了结束这个话题，当你启动这些市场但效果不佳时，你当时真的在看留存率吗？如果是的话，你当时在追求哪个数字？还是说更多是定性的观察，比如“它正在向右上方增长”？在早期，你到底在关注什么？

---

### [00:26:32] Uri Levine

**English:**
That was easier for us because we tried to compare everything to Israel, so we looked at the frequency of use or when our people are coming back. How long does it take them until the next try and until the next try. And in generally speaking, if you look at something that have high frequency of use, then you will be looking at three-month retentions of 30, 40, 50% is actually pretty good indication. But usually what would happen is that you would know when they convert and that's going to be after the third or the fourth time, and if they're not getting to the fourth time, then they are basically saying, "Okay. We gave it a try. We really like this story. We gave it another try, and it's not good enough."

**中文翻译:**
这对我们来说比较容易，因为我们把一切都和以色列做对比。所以我们观察使用频率，或者人们什么时候回来。他们下一次尝试和再下一次尝试之间隔了多久。一般来说，如果你看的是高频使用的产品，三个月留存率达到 30%、40% 或 50% 就是非常好的迹象。但通常情况下，你会发现他们在第三次或第四次使用后才会真正转化。如果他们没用到第四次，他们基本上就是在说：“好吧，我们试过了，我们很喜欢这个故事。我们又试了一次，但它还是不够好。”

---

### [00:27:20] Lenny Rachitsky

**English:**
That's a cool heuristic. Do you find that that is useful for other startups, consumer-type startups or is that just something you think specific to Waze at that point, this idea of coming back for the third time?

**中文翻译:**
这是一个很酷的启发式方法。你觉得这对其它的初创公司，尤其是消费类初创公司有用吗？还是说你觉得这只是当时 Waze 特有的情况，即“必须回来用第三次”这个想法？

---

### [00:27:29] Uri Levine

**English:**
It's really depending on the frequency of use, right? If I will tell you that I have a startup that helps you to file your tax returns in three minutes, then okay, that's absolutely amazing, but you are only going to do that, next time is next year. By the way, we did have a startup that was doing that. It's still a little bit up and running, but that was really frustrating because the tax authority shut us down.

**中文翻译:**
这真的取决于使用频率。如果我告诉你我有一家初创公司可以帮你 3 分钟报完税，那太棒了，但你下一次用得等到明年。顺便说一下，我们确实有过这样一家公司。它现在还在运行，但过程很令人沮丧，因为税务局把我们关停了。

---

### [00:27:58] Lenny Rachitsky

**English:**
You got to fall in with the problem. You got to power through that. Just change the government. Just kidding. The story you told of Waze and iterating is a really good example of falling in love with the problem. You're really passionate about. I want to solve traffic, I hate traffic. By the way, what it made me think about a little bit is Elon, when he hated traffic, he built the boring company and built tunnels underground, and your solution to hate traffic is I'm going to build Waze in a soft wrap.

**中文翻译:**
你得爱上那个问题，得挺过去。干脆换个政府算了（开玩笑）。你讲的 Waze 迭代的故事是“爱上问题”的一个极好例子。你对此充满激情：我想解决交通问题，我讨厌堵车。顺便说一下，这让我想到了埃隆·马斯克，当他讨厌堵车时，他创办了 Boring Company 去挖地下隧道；而你解决讨厌堵车的方法是开发了 Waze 这个软件。

---

### [00:28:29] Uri Levine

**English:**
We start Waze with the vision that we are going to help people to avoid traffic jams. Now the reality is that there are more traffic jams today than there were in 2007. Obviously, number one, I'm not done. And number two, if you ask people what is the value of Waze, then it's not about avoiding traffic. It's about creating certainty and certainty is way higher value than saving time. So you know exactly when you're going to get there and this is a way higher value. And by the way, we learned that in the U.S. market when we spoke with people. They told us, "If I am living in Cupertino and I need to drive up to San Francisco and I can take 101 or 280, I don't really want to change my route unless there is something dramatic, but what I really want to know is how long it's going to take me. So I'm going to stay on the 101. I'm not going to get into service road. I'm not going to take El Camino Real. I'm not going to try something else. I'm going to stay on the 101. Just let me know how long it's going to take." So certainty creates way more value than saving time.

**中文翻译:**
我们创办 Waze 的愿景是帮助人们避开交通拥堵。现实是，今天的交通拥堵比 2007 年还要严重。显然，第一，我还没做完；第二，如果你问人们 Waze 的价值是什么，其实不在于避开拥堵，而在于创造“确定性”。确定性的价值远高于节省时间。你能确切知道什么时候到达，这价值更高。顺便说一下，这是我们在美国市场与人交流时学到的。他们告诉我们：“如果我住在库比蒂诺，需要开车去旧金山，我可以走 101 或 280 公路。除非发生重大意外，否则我并不想换路线。我真正想知道的是要花多长时间。我会一直走 101，不去辅路，不去 El Camino Real，不去试别的路。我就待在 101 上，只要告诉我还要多久能到就行。”所以，确定性创造的价值远超节省时间。

---

### [00:29:44] Lenny Rachitsky

**English:**
I want to talk through a couple other of the chapters in your book. So chapter four is around the different phases of a startup journey and your core advice is that it's important to focus on one thing at a time in each of these phases, and the first phase, you call it the all over the place phase, I think, or yeah, the all over phase, and the idea is you need to get out of that as soon as you can and then focus. Can you just kind of talk through these different phases and what you think people do wrong along the phases? Maybe they get them wrong or they focus on the wrong things in each phase.

**中文翻译:**
我想聊聊你书里的其他几个章节。第四章是关于初创公司旅程的不同阶段，你的核心建议是在每个阶段一次只专注一件事。第一阶段你称之为“到处乱撞”阶段（all over the place phase），你的观点是需要尽快摆脱这个阶段，然后开始专注。你能谈谈这些不同的阶段吗？以及你认为人们在这些阶段中容易犯什么错？也许是搞错了阶段，或者在每个阶段关注了错误的事情。

---

### [00:30:17] Uri Levine

**English:**
So initially you think about your new idea from multiple perspective, right? This is the problem. This is how this solution is going to look like. This is what I'm going to do next year. This is my 10 years vision. This is my business model and so forth. So you think about everything, but you actually need to execute only one thing. Now this one thing is figuring out product market fit. It's not one thing, right? Wait a minute. You also need to build an organization and you want that organization to be something that you really like and so there are a lot of operational stuff, but you need to figure out product market fit. As we said earlier, if you don't figure out product market fit, you will die. If you do, then you get to live and die another day and the other day is whether or not you're going to figure out how to grow your business and whether or not you're going to figure out your business model.

(00:31:11):
Now the good news is that I will tell you that if you create value, you will figure out a business model, at least for the people that you create value for them. They are most likely willing to pay. Now in general, I'm not saying that this is the only business model that is viable, but if you create value, you will figure out a business model. But figuring out a business model is a journey by itself, and guess what? It's going to be a long roller coaster journey of failures. When we started Waze, we thought that we're going to sell map data and traffic information and we ended up with doing advertisement. Very different business model. Because we realized that it's not for us. It's too long sales cycles. We were very mobile internet dynamic company and selling to government is not exactly what we wanted to do, and so we ended up with a different business model, but with a lot of reasoning why this is the right business model for us.

(00:32:14):
And figuring out growth, look, if I would ask a hundred people on the street, how did you hear about Waze? They, 95 of them, if not 99 of them, will tell me, "Someone told me." Word-of-mouth, right? So everyone wants to have word-of-mouth. Word-of-mouth you can only have if you have high frequency of use. If you're doing tax returns once a year, even if you really like the experience, then once a year you're going to tell someone else. If you're using Waze every day, then every day you have an opportunity to tell someone else. So word-of-mouth, even though that everyone would like that, it's only going to happen if you have high frequency of use.

(00:33:01):
So those phases requires different focus of the company, right? Initially if you focus on product market fit, then you don't need sales. You have no product to sell. You don't need business development. You don't need even marketing. You need product. You need developers and you need product lead to define the product and lead through the iterations of the product until we get to the level that it's good enough. Once you get there, you shift gears. If the product doesn't change, if we search Google the same way that we searched Google for the first time in our life, then the product development is now not going to be focused about value creation. It's going to be focused about either figuring out business model or figuring out scale, and the entire company shift gears and move to a different phase.

(00:33:54):
Now, this is really hard. Just think about it. If up until now the product development group was the only things that matters, all of a sudden we think about marketing now because we are now in the go-to-market phase that this is the most important thing of the company. Occasionally I found companies that have challenging and shifting gears so they didn't figure out where the clutch is and you have to because otherwise you're stuck in the previous phase that you kind of finished that journey. This journey is nearly done and you need to shift gears, and if you don't do that, then you get stuck. If you do that, if you try to do multiple things at the same time, you will fail. Focus is not about what we are doing, it's about what we are not doing. These are the hard decisions.

**中文翻译:**
最初，你会从多个角度思考你的新点子：这是问题，这是解决方案的样子，这是我明年要做的事，这是我的十年愿景，这是我的商业模式等等。你考虑了一切，但实际上你只需要执行一件事。这件事就是弄清楚“产品市场契合点”（PMF）。等一下，这不只是一件事，你还需要建立一个组织，而且你希望这个组织是你真正喜欢的，所以有很多运营方面的事情。但你必须弄清楚 PMF。正如我们之前所说，如果你没弄清楚 PMF，你就会死掉。如果你弄清楚了，你就能活下来，并在以后面临生死考验——那个考验就是你是否能弄清楚如何发展业务，以及是否能弄清楚商业模式。

(00:31:11):
好消息是，我会告诉你，如果你创造了价值，你就能找到商业模式，至少对于那些你为其创造价值的人来说，他们很可能愿意付钱。总的来说，我并不是说这是唯一可行的商业模式，但只要有价值，商业模式总会有的。但弄清楚商业模式本身就是一段旅程，而且你猜怎么着？这将是一段漫长的、充满失败的过山车之旅。当我们创办 Waze 时，我们以为会出售地图数据和交通信息，结果我们做的是广告。完全不同的商业模式。因为我们意识到前者不适合我们，销售周期太长。我们是一家非常动态的移动互联网公司，向政府销售并不是我们想做的。所以我们最终选择了不同的商业模式，但有很多理由证明为什么这对我们是正确的。

(00:32:14):
至于弄清楚增长，听着，如果我问街上的 100 个人：你是怎么听说 Waze 的？其中 95 个甚至 99 个会告诉我：“有人告诉我的。”这就是口碑传播。每个人都想要口碑传播，但只有在高频使用的情况下才会有口碑。如果你一年只报一次税，即使你非常喜欢那个体验，你一年也只会告诉别人一次。如果你每天都用 Waze，那你每天都有机会告诉别人。所以，虽然大家都想要口碑，但它只会在高频使用的情况下发生。

(00:33:01):
所以这些阶段需要公司有不同的侧重点。最初，如果你专注于 PMF，你就不需要销售，因为你没有产品可卖；你不需要业务开发，甚至不需要营销。你需要的是产品，需要开发人员和产品负责人来定义产品，并引导产品进行迭代，直到达到“足够好”的水平。一旦达到那里，你就得换挡。如果产品不再改变（就像我们今天搜索谷歌的方式和第一次一样），那么产品开发就不再专注于价值创造，而是专注于弄清楚商业模式或规模化。整个公司都要换挡，进入不同的阶段。

(00:33:54):
这其实非常难。想想看，如果到目前为止产品开发团队是唯一重要的事情，突然间我们要考虑营销了，因为我们进入了“进入市场”（go-to-market）阶段，这是公司最重要的事情。我偶尔会发现有些公司在换挡时遇到困难，他们找不到离合器在哪。但你必须换挡，否则你就会被困在已经接近完成的旧阶段。如果你不换挡，你就会停滞不前。如果你试图同时做多件事，你就会失败。专注不在于“我们在做什么”，而在于“我们不做什么”。这些才是艰难的决定。

---

### [00:34:50] Lenny Rachitsky

**English:**
I like that. So the four phases, just to briefly summarize, it's kind of like come up with the idea, find product market fit, then it's a question of should you keep focusing on growth or should you figure out the business model before focusing heavily on growth? In your advice, it sounds like if it's high frequency, word-of-mouth driven, focus on growth and then you figure out business model later. If not, figure out how you're going to make money and then figure out growth.

**中文翻译:**
我喜欢这个观点。所以这四个阶段简要总结一下就是：构思点子、寻找 PMF，然后是决定应该继续专注于增长，还是在重金投入增长前先弄清楚商业模式。根据你的建议，听起来如果是高频、口碑驱动的产品，就先专注增长，然后再弄清楚商业模式；如果不是，就先弄清楚怎么赚钱，然后再考虑增长。

---

### [00:35:14] Uri Levine

**English:**
Exactly. Because if you have high frequency of use, you will end up with growth coming by itself, right, for word-of-mouth, and therefore you should do that at the beginning. If you don't have high frequency of use, you are sentenced to acquire users or customers all of your lifetime. If this is the case, then you really want to figure out the business model before you start and go and do that.

**中文翻译:**
没错。因为如果你有高频使用，增长会通过口碑自然而然地到来，所以你应该在开始时就这样做。如果你没有高频使用，你就注定要一辈子花钱获取用户或客户。如果是这种情况，你真的想在开始大规模行动之前先弄清楚商业模式。

---

### [00:35:41] Lenny Rachitsky

**English:**
That's really helpful. I think actually a counter example to your point about how frequency of use is necessary for word-of-mouth growth is Airbnb. Something like 70% of Airbnb growth is word-of-mouth and frequency of use is actually really low. It's like once or twice a year. I wonder if it's because the experience is so unique and special that it still works and enough people travel enough times, slash if it was a higher frequency, it would've grown even faster, I imagine.

**中文翻译:**
这很有帮助。我觉得针对你说的“高频使用是口碑增长的必要条件”，Airbnb 算是一个反例。Airbnb 大约 70% 的增长来自口碑，但使用频率其实很低，一年也就一两次。我在想，是不是因为体验太独特、太特别了，所以依然有效，而且有足够多的人出差旅行。我想如果频率更高，它会增长得更快。

---

### [00:36:09] Uri Levine

**English:**
High frequency of use is the simplest way for word-of-mouth. The other thing is coolness. If it's really cool, then you'll tell more people, and Airbnb was really cool at the beginning of the journey, so now everyone knows about Airbnb, but when they started that was way cheaper and really unique experience than hotels.

**中文翻译:**
高频使用是口碑传播最简单的途径。另一件事是“酷”。如果它真的很酷，你就会告诉更多人。Airbnb 在创业初期非常酷，虽然现在人尽皆知，但刚开始时，它比酒店便宜得多，体验也极其独特。

---

### [00:36:36] Lenny Rachitsky

**English:**
It's still actually mostly word-of-mouth. I think it was probably higher initially, but it's still almost 70, 80% driven by word-of-mouth. So it's still cool enough. Good for them. You have a couple of quotes that I wanted to share, which are along the lines of things you shared. One is just, you have this kind of, what's the most important stage at a company? They all are, but one at a time. I love that line. The other is the main thing is to keep the main thing the main thing. The same advice you just shared. Just like focus. So you're in the PM, product market fit phase. Focus on that. Don't think about growth yet. Don't think about business model yet necessarily. I know investors are going to push you to figure these things out and you'll have to have some story of like, "Here's how it might make money. Here's how we think we're going to grow." Right? You need to think about that a little bit, but maybe don't make that the focus.

**中文翻译:**
现在其实主要还是靠口碑。我想最初可能更高，但现在依然有近 70-80% 是口碑驱动的。所以它依然足够酷，真为他们高兴。我想分享几句你的名言，和刚才聊的很像。一句是关于“公司最重要的阶段是什么？”答案是：“每个阶段都很重要，但一次只专注一个。”我太喜欢这句了。另一句是“最重要的事情就是让最重要的事情保持最重要。”这和你刚才分享的建议一样，就是专注。如果你处于 PMF 阶段，就专注那个。先别想增长，也未必非得想商业模式。我知道投资者会逼你弄清楚这些，你得有个故事，比如“这是它可能赚钱的方式，这是我们认为的增长方式”，对吧？你需要稍微思考一下，但也许不该把它作为重点。

---

### [00:37:22] Uri Levine

**English:**
So this is one of the areas that investors don't like to hear the truth, right? The truth is that I don't know how I'm going to bring the users. I will figure that out once I get there, but the reality is that right now I don't know, but they don't want to hear that. What they want to hear is that, "Oh, I know exactly how I'm going to bring them." And what I will say is that I know exactly where I'm going to start my experiments, but most of the investors would like to see a coherent story that makes sense, right? This is our business model. This is how we going to make money. This is what we're going to sell. This is how much they're going to pay. This is why it's a simple business model and these are the comparable to this business model.

**中文翻译:**
这是投资者不喜欢听真话的领域之一。真相是：我不知道我该如何吸引用户，等我到了那个阶段我会弄清楚的。但现实是，我现在确实不知道。可他们不想听这个，他们想听的是：“哦，我完全知道该怎么吸引用户。”而我会说的是，我完全知道从哪里开始我的实验。但大多数投资者希望看到一个合乎逻辑、说得通的故事：这是我们的商业模式，这是我们赚钱的方式，这是我们要卖的东西，这是价格，为什么这是一个简单的模式，以及有哪些可参考的同类模式。

---

### [00:38:03] Lenny Rachitsky

**English:**
Yeah. But investors have the final word, unfortunately. They decide if they want to invest or not, and so if your story is not compelling, they're going to be like, "All right. We'll find someone else."

**中文翻译:**
是的。但不幸的是，投资者拥有最终决定权。他们决定是否投资，所以如果你的故事不够吸引人，他们就会说：“好吧，我们去找别人。”

---

### [00:38:13] Uri Levine

**English:**
You know, it's seasonality, right? There are periods of time that raising capital is easier and then many of the entrepreneurs will be choosers are not beggars, and there are periods of time that is that way around, and most of the entrepreneurs will be beggars and not choosers.

**中文翻译:**
你知道，这有周期性。有些时期融资比较容易，很多创业者是挑选者而不是乞求者；而有些时期则相反，大多数创业者是乞求者而不是挑选者。

---

### [00:38:33] Lenny Rachitsky

**English:**
Imagine a place where you can find all your potential customers and get your message in front of them in a cost-efficient way. If you're a B2B business, that place exists, and it's called LinkedIn. LinkedIn Ads allows you to build the right relationships, drive results, and reach your customers in a respectful environment. Two of my portfolio companies, Webflow and Census are LinkedIn success stories. Census had a 10x increase in pipeline with the LinkedIn startup team. For Webflow, after ramping up on LinkedIn in Q4, they had the highest marketing source revenue quarter to date. With LinkedIn Ads, you'll have direct access to and can build relationships with decision makers including 950 million members, 180 million senior execs and over 10 million C-level executives. You'll be able to drive results with targeting and measurement tools built specifically for B2B.

(00:39:24):
In tech, LinkedIn generated two to five x higher return on ad spend than any other social media platforms. Audiences on LinkedIn have two times the buying power of the average web audience, and you'll work with a partner who respects the B2B world you operate in. Make B2B marketing everything it can be and get $100 credit on your next campaign. Just go to LinkedIn.com/podLenny to claim your credit. That's LinkedIn.com/podLenny. Terms and conditions apply.

**中文翻译:**
想象一个地方，你可以找到所有潜在客户，并以极具成本效益的方式将你的信息展示在他们面前。如果你是一家 B2B 企业，这个地方确实存在，它就是 LinkedIn。LinkedIn 广告允许你在一个相互尊重的环境中建立正确的关系、推动成果并触达客户。我的两家投资组合公司 Webflow 和 Census 都是 LinkedIn 的成功案例。Census 通过 LinkedIn 创业团队实现了销售线索（pipeline）10 倍的增长。对于 Webflow，在第四季度加大 LinkedIn 投入后，他们获得了迄今为止最高的营销来源收入季度。通过 LinkedIn 广告，你可以直接接触并与决策者建立关系，包括 9.5 亿会员、1.8 亿高级管理人员和超过 1000 万名 C 级高管。你将能够利用专为 B2B 设计的定位和衡量工具来推动成果。

(00:39:24):
在科技领域，LinkedIn 产生的广告支出回报率（ROAS）比任何其他社交媒体平台高出 2 到 5 倍。LinkedIn 上的受众购买力是普通网络受众的两倍，而且你将与一个尊重你所处 B2B 领域的伙伴合作。让 B2B 营销发挥最大潜力，并在你的下一次活动中获得 100 美元的抵用金。只需访问 LinkedIn.com/podLenny 即可领取。网址是 LinkedIn.com/podLenny。受条款和条件约束。

---

### [00:39:52] Lenny Rachitsky

**English:**
Let's actually talk about fundraising as a topic I wanted to spend a little time on. How much money have you raised for the companies that you've started total, roughly?

**中文翻译:**
我们来聊聊融资吧，这是我想花点时间讨论的话题。你为你创办的所有公司总共筹集了多少资金，大概是多少？

---

### [00:40:02] Uri Levine

**English:**
So Waze raised about $50 million throughout the entire journey. We started by raising 12. That was the first investment round, and then we raised the 30, and then there was the last round that we raised actually not a lot.

**中文翻译:**
Waze 在整个历程中筹集了大约 5000 万美元。我们第一轮融了 1200 万，然后融了 3000 万，最后一轮其实融得不多。

---

### [00:40:23] Lenny Rachitsky

**English:**
That's a surprising small amount of money to raise for the outcome.

**中文翻译:**
相对于最终的结果，这个融资额小得令人惊讶。

---

### [00:40:28] Uri Levine

**English:**
In general, I would say Israeli startups are leaner than American startups, so you can raise less money.

**中文翻译:**
总的来说，我会说以色列的初创公司比美国的更精简，所以你可以用更少的钱。

---

### [00:40:36] Lenny Rachitsky

**English:**
Yeah, that's amazing.

**中文翻译:**
是的，太了不起了。

---

### [00:40:37] Uri Levine

**English:**
At way lower valuation, unfortunately, and end up with pretty successful results.

**中文翻译:**
不幸的是，估值也低得多，但最终取得了非常成功的结果。

---

### [00:40:44] Lenny Rachitsky

**English:**
That's amazing.

**中文翻译:**
太棒了。

---

### [00:40:45] Uri Levine

**English:**
Raising capital, it's a journey by itself and different from the other journeys that you need only once. Raising capital is going to happen multiple times. And if we say that building a startup is a roller coaster journey, then I will say raising capital is a roller coaster journey in the dark.

**中文翻译:**
筹集资金本身就是一段旅程，而且不同于其他只需要经历一次的旅程，融资会发生多次。如果我们说创办公司是过山车之旅，那么我会说筹集资金是“在黑暗中”坐过山车。

---

### [00:41:07] Lenny Rachitsky

**English:**
It's like Space Mountain.

**中文翻译:**
就像迪士尼的飞越太空山（Space Mountain）。

---

### [00:41:09] Uri Levine

**English:**
Yeah, sort of. And one of the reason is that this is a different ballgame and you don't know how to play at the beginning. I would say a few things about raising capital for the first time. Number one, I spoke with many investors and one of the conversations that I had that they really, really resonate with me was when I spoke with one of the leading VC in Israel and asked their partner, "How long does it take you to decide if you like the entrepreneur or not?" And he asked me, "Do you want the right answer or the real answer?" Say, "You know, I heard the right answer so many times, give me the real answer." And we were sitting in a small meeting room, so the guy is looking at me and then looking at the door and looking at me again and say, "It's before they sit down." Say, "Oh, no, no, no. Say that again, right?"

(00:42:02):
That's the first impression. Now we all have first impression. How long does it take you to decide if you like a candidate or not? Second, you go on a date. How long does it take you to decide if you like the date? Seconds. And then maybe there are a few more minutes that you allow yourself to either change your mind or let that first impression solidifies. Now if this is the case and you're looking to raise capital, start with the strongest point at the beginning. Whatever it is, and I don't care if this is the size of the problem. This is the faction that you have. This is the team that you have built. I don't care what it is, start with that, because by the time you'll get there, they might be already setting up their mind. Then start with the strongest point at the beginning. And by the way, finish with that as well.

(00:42:53):
So this is the first conclusion. The second conclusion is that I spoke with early stage investors, those that invest the first money in. So company has a story to tell. That's about it, right? No traction, nothing yet is built and so forth, and I asked him, "Why did you decide to invest in this company and this company and this company?" And I spoke with many investors, and what I heard was actually pretty consistent. I like the CEO. I like the story. That's it. I like the CEO. I like the story. Now if this is the case, then there are two immediate conclusions. The first one is that the CEO goes alone to the meeting. I need the headlight on me. I don't need any distractions. I don't need my team members. I don't need anything else in the room, just me. Because if I bring other people, then at the end of the day they might say, "Yeah, I like the team, but the CEO was not specific, right? Was not unique. Was not jumping out of the pages." So CEO goes along and tell the story.

(00:44:02):
The other part is that they need to tell a good story, and good story is not about facts. It's about creating emotional engagement. It's about creating the sense that the listener would like to be part of this story. And for investor, it's two things. Number one is that they want to believe that this is usable, and number two, they want to believe that you can build it and this is the story that you need to tell. Now, I would say always start with the problem, right? Because guess what? Investors are also users. If they don't think that they're going to use it, so it's relevant for them, and they don't think that they're going to use it? They will basically dismiss that. They will basically say the market is not there.

(00:44:52):
So these are two main things. The third thing is it's a different ball game, right? So if you have product and you tell the story to potential customers, the right order of magnitude is that about one third of the listeners will buy. So in a more mature company, their pipeline is going to be three eggs in order to sell at the end of the year one eggs. One third are going to say yes. In investors, it's 1%. Not one third, 1%. So you're going to hear a hundred times no until you hear one yes. And that a hundred times no is something that you need to understand from the beginning because that's really discouraging, right? You go and speak with investors and they tell you... I call that they open up the big book of excuses why not. But in general, they are not going to invest, right?

(00:45:54):
Now you look at it from the other side, a venture capital partner is likely to see between a hundred and 200 companies a year and invest in one or two. 1%. That's it. So if this is the case, then it's going to be the same case for you. One out of a hundred. If you want to increase the likelihood, learn how to tell a good story, start at the strongest point at the beginning, remember that they are users, too, so their emotional engagement is going to come through the usage, the use case, and not through how big the business is.

**中文翻译:**
是的，有点像。原因之一是这是一个完全不同的游戏，你一开始不知道怎么玩。关于第一次融资，我想说几点。第一，我和很多投资者聊过，其中一次对话让我非常有共鸣。我问以色列一家顶级风投的合伙人：“你花多长时间决定是否喜欢一个创业者？”他问我：“你想听标准答案还是真实答案？”我说：“标准答案我听腻了，给我真实答案。”我们当时坐在一个小会议室里，他看着我，又看看门，再看着我说：“在他们坐下之前。”我说：“噢，不不不，再说一遍？”

(00:42:02):
这就是第一印象。我们都有第一印象。你决定是否喜欢一个应聘者需要多久？几秒。你去约会，决定是否喜欢对方需要多久？几秒。然后可能再花几分钟让自己改变主意，或者让第一印象固化。既然如此，如果你要融资，开头就要抛出你最强有力的观点。不管那是什么，我不在乎是问题的规模、你拥有的数据，还是你组建的团队。我不在乎是什么，从那开始，因为等你讲到后面时，他们可能已经下定决心了。所以，开头要强，结尾也要强。

(00:42:53):
这是第一个结论。第二个结论是，我曾和早期投资者（投第一笔钱的人）聊过。当时公司只有一个故事，没有增长数据，什么都没造出来。我问他们：“你为什么决定投这家、那家和那家公司？”我问了很多人，听到的回答非常一致：“我喜欢这个 CEO，我喜欢这个故事。”就这两点。既然如此，就有两个直接的结论。第一，CEO 应该独自去开会。我需要聚光灯打在我身上，不需要任何干扰，不需要团队成员，房间里只要我一个人。因为如果我带了别人，最后他们可能会说：“嗯，团队不错，但 CEO 没什么特色，不够独特，没能脱颖而出。”所以 CEO 独自去讲故事。

(00:44:02):
另一部分是他们需要讲一个好故事。好故事不在于事实，而在于建立情感连接，在于让听众产生“我也想成为这个故事一部分”的感觉。对于投资者来说，有两点：第一，他们要相信这东西有用；第二，他们要相信你能把它造出来。这就是你需要讲的故事。我会说，永远从问题开始。因为你猜怎么着？投资者也是用户。如果他们觉得自己不会用，觉得这跟他们没关系，他们就会否定它，他们会说市场不存在。

(00:44:52):
这是两个要点。第三点是，这是一个完全不同的游戏。如果你有产品并向潜在客户推销，大约三分之一的听众会买。所以在成熟公司，销售线索（pipeline）通常是 3 倍，以便在年底卖出 1 倍。三分之一的人会说“好”。但在投资者这里，这个比例是 1%。不是三分之一，是 1%。所以你会听到 100 次“不”，直到听到一个“好”。这 100 次拒绝是你从一开始就需要理解的，因为这真的很打击人。你去见投资者，他们会打开那本厚厚的“为什么不投的借口大全”。但总之，他们就是不投。

(00:45:54):
从另一面看，一个风投合伙人一年可能会看 100 到 200 家公司，最后只投 1 到 2 家。1%，就是这样。所以对你来说也是一样，百分之一的概率。如果你想增加可能性，学会讲好故事，开头抛出最强观点，记住他们也是用户，所以他们的情感投入会来自于使用场景，而不是业务规模有多大。

---

### [00:46:34] Lenny Rachitsky

**English:**
I love the summary at the end. I love that you summarized your points, because I try to do that. You did my job. I love this phrase you have in your book, "The dance of 100 nos."

**中文翻译:**
我喜欢最后的总结。我喜欢你总结自己的观点，因为我也试着这么做，你抢了我的活。我非常喜欢你书里的那个短语：“百次拒绝之舞”。

---

### [00:46:44] Uri Levine

**English:**
At the beginning you look at it and you say, "Okay, they say they decided not to invest because of X, Y, Z," right? Whatever it is, right? Google can do that in no time or the market is not big enough or the market is complex or whatever it is, and then you try to argue, and you don't know that it's useless, right? It's like you go on a date and she said no, and you try to argue, right? No, there is nothing to argue anymore, right? That's no.

**中文翻译:**
刚开始你会看着拒绝信说：“好吧，他们说不投是因为 X、Y、Z”，对吧？不管是什么理由，比如“谷歌分分钟就能做出来”、“市场不够大”或者“市场太复杂”。然后你试图去争辩，但你不知道那是徒劳的。就像你去约会，对方说“不”，你还想争辩？没戏了，不就是不。

---

### [00:47:16] Lenny Rachitsky

**English:**
Yeah. I look at a lot of startups too. I do a bunch of angel investing, and yeah, if it's not going to be a fit, it's just not going to work, and I could spend all this time trying to explain it to you, but nothing's going to change. And because there's other startups out there is a big part of it, right? You just want to pick the things you can that are the best, not necessarily things that are good ideas. I really like this idea of starting with your strongest point. That's such an important tactical piece of advice. To your point, investors make decisions really quickly, and so starting with something that really catches their attention, it makes so much sense because once you feel like, "Oh, wow, maybe this is a thing," your whole brain is starting to look at it from a, oh, yeah, okay, like you have a positive bend on everything you're hearing versus like, "No, no, no, this is never going to work and everything is already biased."

**中文翻译:**
是的。我也看很多初创公司，我做不少天使投资。如果觉得不合适，那就是不行。我可以花很多时间向你解释，但结果不会改变。很大一部分原因是因为外面还有很多其他初创公司，对吧？你只想挑选那些你能选到的最好的，而不一定是那些听起来不错的点子。我非常喜欢“从最强点开始”这个想法。这是一个非常重要的战术建议。正如你所说，投资者做决定非常快，所以用一些真正能吸引他们注意力的东西开头非常有意义。因为一旦他们觉得“噢，哇，这可能成”，他们的大脑就会开始带着积极的倾向去听接下来的内容；反之，如果开头没吸引住，他们就会觉得“不不不，这行不通”，然后接下来的每一句话都会被戴上有色眼镜来看待。

---

### [00:48:00] Uri Levine

**English:**
So I would add here another very strong advice. Most people are missing the most important slide of their presentation. The most important slide of your presentation is the first slide, not the one that you think about it. The first slide. The one that says Company XYZ intro. This slide is going to be presented for the longest period of time.

**中文翻译:**
我想在这里再增加一个非常有力的建议。大多数人都忽略了演示文稿中最重要的一张幻灯片。你演示文稿中最重要的一张是第一张，不是你以为的那张。就是第一张，写着“XYZ 公司介绍”的那张。这张幻灯片展示的时间是最长的。

---

### [00:48:29] Lenny Rachitsky

**English:**
Wow, that's a good point.

**中文翻译:**
哇，这观点太棒了。

---

### [00:48:31] Uri Levine

**English:**
The longest period of time in the presentation, this slide is going to be presented on the screen and you didn't say anything there. This is the place that you're going to put your strongest point.

**中文翻译:**
在整个演示过程中，这张幻灯片停留在屏幕上的时间最长，而你却在那上面什么都没说。这里才是你应该放最强有力观点的地方。

---

### [00:48:45] Lenny Rachitsky

**English:**
I love that. Is there an example of someone that did that or did you do that, one of your startups? What do you put there?

**中文翻译:**
我喜欢这个。有没有谁这么做过的例子？或者你在自己的初创公司里这么做过吗？你会在那上面放什么？

---

### [00:48:51] Uri Levine

**English:**
I do that all the time.

**中文翻译:**
我一直都这么做。

---

### [00:48:52] Lenny Rachitsky

**English:**
What's an example of something you put on that slide that's such a good idea?

**中文翻译:**
能不能举个例子，你在那张幻灯片上放过什么好点子？

---

### [00:48:56] Uri Levine

**English:**
Maybe size of the market. Maybe description of the problem. Whatever it is, right, the strongest point is there. Now the second most important slide is the last one. Not the summary. The one that says thank you. That's the time to repeat that. So most of their presentations will end up with thank you and my email, right, and this is going to be the last slide, right? Which makes sense. You just missed the opportunity. This is going to be the second-longest displayed slide of the presentation. Maybe the first.

**中文翻译:**
可能是市场规模，也可能是对问题的描述。不管是什么，最强的一点就放在那。而第二重要的幻灯片是最后一张。不是总结页，而是写着“谢谢”的那张。那是重复核心观点的时候。大多数人的演示文稿最后都是“谢谢”和“我的邮箱”，对吧？这作为最后一张幻灯片很合理，但你错失了机会。这将是演示中展示时间第二长的幻灯片，甚至可能是第一长。

---

### [00:49:39] Lenny Rachitsky

**English:**
Yeah. Everyone's sitting there chatting, asking you questions. That's so smart. Are there any more of these tips sitting in your head to share, because these are awesome.

**中文翻译:**
是的，大家坐在那聊天、问你问题时，那张幻灯片就一直亮着。太聪明了。你脑子里还有更多这类建议吗？因为这些真的太棒了。

---

### [00:49:48] Uri Levine

**English:**
I do a lot of public speaking and usually my last slide says one more story and I decide on the story based on the audience and the dialogue so far and so forth. But I have many of stories, many last stories that I would like to tell. The important part is that no one is going to cut you off the stage if you have just one more story, and so this is where you can recap everything. This is where you can do whatever you want, right? Because no one is going to tell you, "Okay, time is up."

**中文翻译:**
我做过很多公开演讲，通常我的最后一张幻灯片写着“还有一个故事”。我会根据观众和之前的对话来决定讲哪个故事。我有许多故事，许多想讲的“最后一个故事”。重点是，如果你说“还有一个故事”，没人会把你赶下台。所以你可以在这里回顾一切，在这里做任何你想做的事，因为没人会告诉你“好了，时间到”。

---

### [00:50:26] Lenny Rachitsky

**English:**
Right, and they're not impatient because they're like, "Okay, it's almost over. Let's just let him finish."

**中文翻译:**
对，而且他们不会不耐烦，因为他们会想：“好吧，快结束了，让他讲完吧。”

---

### [00:50:30] Uri Levine

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:50:31] Lenny Rachitsky

**English:**
Yeah. I love that. Speaking of stories, what's the wildest fundraising story that you've been through? Is there one that comes to mind of like, "Holy shit. I can't believe that happened," or, "I can't believe that worked out"?

**中文翻译:**
是的，我喜欢这个。说到故事，你经历过的最疯狂的融资故事是什么？有没有哪个让你觉得“天哪，不敢相信发生了这种事”或者“不敢相信居然成了”？

---

### [00:50:43] Uri Levine

**English:**
One of the earlier startups that I was guiding was about, eventually rolled into gift cards, but in Israel, when you return something to the store, you don't get your money back. What you get is a gift card for that particular store, right, and obviously if you return something, then it's not necessarily that you have something to buy in the store and you ended up with having a gift card that is never being used, and so why not sell this gift card? What happened is that I heard the story of the CEO and I thought that the story is not good enough, and I told him, "Look, you have to tell a better story," and asked, "Can you give me an example?" And I said, "Yeah, just imagine that," and then there was a long story about the microwave stuff working, and I bought a new one and really long, long, long story about with the details, right? How do you make a story make believe? With details. Right? The more details people think that this is real. Right?

(00:51:48):
If there are no details, then this is not real. So I told him this story that was like five minutes explaining, trying to fit the microwave into the closet and it didn't fit in into the cabinet, and it didn't fit in, and I had to return it to the box and so forth and whole story. And then I spoke with an investor in Israel and I told him about this new company that I'm going to invest, and I told him the same story about this microwave, right, and he said, "This is interesting. I would like to meet the CEO." Then he met the CO and CEO told him exactly the same story about the microwave. When I tell that, this is my microwave, right?This is personal. This has happened to me. And so he told me, the investor called me up later, he said, "He told me exactly the same story." So that was really funny.

(00:52:44):
But at the end of the day, one of the things that makes story authentic is details, because otherwise it's not, right? If you're going to tell me, okay, this is the use case of the product and you end up with explaining a use case in three lines, this is not authentic. If you watch your real users, then what happens is that you actually, and you speak with them, then you have the audacity to tell a good story. Really, really critical. If you want to tell user story, these needs to be, real or you have to learn how to tell a story with many details.

**中文翻译:**
我指导过的一家早期初创公司，后来业务转向了礼品卡。在以色列，当你去商店退货时，你拿不回现金，只能拿到该商店的礼品卡。显然，如果你退货，说明你未必想在那家店买东西，结果你就拿着一张永远用不掉的礼品卡。所以，为什么不把这张卡卖掉呢？当时我听了那个 CEO 讲的故事，觉得不够好。我告诉他：“听着，你得讲个更好的故事。”他问：“能给我举个例子吗？”我说：“好，想象一下……”然后我讲了一个很长的故事，关于微波炉坏了，我买了个新的，故事非常非常长，充满了细节。如何让故事令人信服？靠细节。细节越多，人们越觉得是真的。

(00:51:48):
如果没有细节，那就不是真的。我给他讲了这个故事，花了大约 5 分钟解释如何试图把微波炉塞进橱柜，结果塞不进去，不得不装回盒子里等等。后来我跟以色列的一个投资者聊，告诉他我要投这家新公司，并给他讲了那个微波炉的故事。他说：“很有趣，我想见见这个 CEO。”然后他见了 CEO，CEO 给他讲了完全一模一样的微波炉故事。当我讲的时候，那是“我的”微波炉，是我的亲身经历。结果那个投资者后来给我打电话说：“他给我讲了完全一模一样的故事。”这真的很有趣。

(00:52:44):
但归根结底，让故事真实的关键在于细节，否则就不真实。如果你告诉我产品的某个使用场景，只用三行字解释完，那就不真实。如果你观察真实用户并与他们交谈，你就有底气讲出一个好故事。这非常关键。如果你想讲用户故事，它必须是真实的，或者你必须学会如何用大量细节来讲述。

---

### [00:53:29] Lenny Rachitsky

**English:**
But interestingly, it sounds like the story itself doesn't have to have happened to you in real life. It could be a made-up story, but with a lot of details is the lesson there. Interesting.

**中文翻译:**
有趣的是，听起来故事本身不一定非得是你亲身经历的。它可以是编出来的，但教训是必须有大量细节。有意思。

---

### [00:53:38] Uri Levine

**English:**
Yep. If you tell it very briefly, then it doesn't sound right.

**中文翻译:**
是的。如果你讲得很简略，听起来就不对劲。

---

### [00:53:46] Lenny Rachitsky

**English:**
Amazing. Any other advice along those lines? I want to talk about two more chapters before we wrap up. Is there anything else around fundraising that you think is important for people to know?

**中文翻译:**
太棒了。还有其他类似的建议吗？在结束前我还想聊两个章节。关于融资，你觉得还有什么重要的事情是大家需要知道的吗？

---

### [00:53:54] Uri Levine

**English:**
So I will tell you which chapters I would like to speak about.

**中文翻译:**
那我告诉你我想聊哪几个章节。

---

### [00:53:57] Lenny Rachitsky

**English:**
Let's do it. I wonder what they are. I wonder if they're the same.

**中文翻译:**
来吧。我想知道是哪几个，看看是不是跟我选的一样。

---

### [00:54:02] Uri Levine

**English:**
Understanding users and firing and hiring.

**中文翻译:**
“了解用户”以及“解雇与招聘”。

---

### [00:54:04] Lenny Rachitsky

**English:**
Okay, firing and hiring. That was on my list. Okay. Let's start there and then understanding users wasn't, but I'm excited to hear what you have to say there.

**中文翻译:**
好，“解雇与招聘”在我的清单上。那我们先从这个开始。虽然“了解用户”不在我的清单上，但我很期待听听你怎么说。

---

### [00:54:14] Uri Levine

**English:**
So I send the book proposal to many publisher, and there is one chapter that says firing and hiring, and many of them came back and say, "Oh, it should be hiring and firing." And I said, "No. Firing is hard decision. Hiring is easy decisions." You have to first of all learn how to make the hard decisions. Now, the inspirations for this chapter came from many dialogues that I had with entrepreneurs that their startup failed, and I asked them, "Why, what happened?" And about half told me the team was not right, and I kept on asking, "Okay, what do you mean the team was not right?" And what I heard the most is, "We had this guy not good enough and this guy not good enough." So this is what I heard the most.

(00:54:58):
Another thing that I heard quite often is that we had communication issues, right? Something that I actually called ego management issues. And then asked them the most interesting question, "When did you know that the team is not right?" Now the answer was actually rather scary. All of them told me within the first month. Then you said, "Wait a minute. If you knew within the first month that the team is not right and you didn't do anything, the problem was not that the team was not right. The problem was that the CEO did not make hard decision." Making hard decisions is hard. Making easy decisions. This is why no one likes to make the hard decisions, because you need to live with the consequences. In a small place like a startup, the hard decisions will always go to the top. Now, if the CEO does not make that hard decisions, the result is always the same. The top performing people would leave. Now, they would leave because they don't want to be in a place that is unable to make hard decisions and they have a choice.

(00:56:02):
The nature of the beast is different. Startup is a small organization. Just imagine that you are a small organization, like could be a team, whatever it is, right? 10, 20, 30 people, and there is someone that shouldn't be there, and I don't care if that someone shouldn't be there because they are way underperforming or because they are assholes. I don't really care. They shouldn't be there. Everyone knows. Everyone knows and the CEO doesn't do anything. That's the nature of the beast and this is why top performing people would leave. Now, building a startup is really, really hard, right? It's hard if you have the right team, but if you have people that shouldn't be there that are still there and the top performing people are leaving, then it's going to be mission impossible. The conclusion of this chapter is really, really interesting. If everyone knows within a month and every time that you hire someone new, what I really want you to do is mark your calendars for 30 days down the road and ask yourself one question, "Knowing what I know today, would I hire this person?"

(00:57:16):
At the end of the day, I'd like to nail that into yes or no, right? Because this is where decisions are being made easily. If you ask yourself that question, if the answer is yes, then go to this person and tell them that you are really excited that they've joined, they are exceeding your expectations, and give them more equity, and you buy their loyalty for life. If the answer is no, fire them immediately. They're already set on a trajectory of not being successful and they're creating damage to you, to the rest of the team and to themselves, right? They deserve to be successful, but it's not going to happen here. They deserve to find someplace else that they can be successful, but it's not going to happen here, and that decision is really, really dramatic.

(00:58:08):
Now, in many cases with hard decisions, we know what is the right decisions. We are looking for confirmation. If you look for confirmation, then go and speak with the top performing people and tell them, ask them the following, right? "Assuming XYZ person is going to leave, how sore are you going to feel?" And you will be surprised that they are going to tell you, "Oh, it's not a big deal." This is your confirmation.

**中文翻译:**
我把书稿发给很多出版商，其中有一章叫“解雇与招聘”。很多人回复说：“哦，应该是‘招聘与解雇’吧。”我说：“不，解雇是艰难的决定，招聘是容易的决定。”你首先得学会如何做艰难的决定。这一章的灵感来自我与许多创业失败者的对话。我问他们：“为什么失败了？发生了什么？”大约一半的人告诉我团队不对。我接着问：“团队不对是什么意思？”我听得最多的是：“那个人不够好，那个人也不够好。”

(00:54:58):
我还经常听到的是沟通问题，我称之为“自我管理问题”（ego management issues）。然后我问了他们一个最有趣的问题：“你什么时候知道团队不对的？”答案其实挺吓人的。所有人都告诉我：在第一个月内。那你就会想：“等一下，如果你在第一个月就知道团队不对却什么也没做，那问题就不在于团队不对，而在于 CEO 没有做出艰难的决定。”做艰难的决定很难，做容易的决定很简单。这就是为什么没人喜欢做艰难的决定，因为你必须承担后果。在初创公司这样的小地方，艰难的决定总是会上报到最高层。如果 CEO 不做决定，结果总是一样的：表现最优秀的人会离开。他们离开是因为不想待在一个无法做出艰难决定的地方，而且他们有选择权。

(00:56:02):
初创公司的本质不同，它是一个小组织。想象一下你身处一个小组织，可能是一个团队，10、20、30 个人，里面有一个不该待在那儿的人。我不在乎那个人是因为表现太差还是因为人品太烂，总之他不该在那儿。每个人都知道，大家都心知肚明，但 CEO 却无动于衷。这就是问题的本质，也是为什么优秀人才会离开。创办公司已经非常非常难了，即便有正确的团队也很难；但如果那些不该留的人还在，而优秀的人却在流失，那简直是“不可能完成的任务”。这一章的结论非常有趣：既然大家在一个月内就能看出来，那么每次你雇佣新员工时，我希望你在日历上标注出 30 天后的日期，并问自己一个问题：“基于我今天所了解的情况，我还会雇佣这个人吗？”

(00:57:16):
归根结底，我希望把答案简化为“是”或“否”，因为这样决策最容易。如果你问自己这个问题，答案是“是”，那就去找那个人，告诉他你非常高兴他的加入，他的表现超出了你的预期，并给他更多期权，以此买下他一辈子的忠诚。如果答案是“否”，请立即解雇他。他已经走在了一条注定不会成功的轨道上，他正在对你、对团队、也对他自己造成伤害。他值得获得成功，但不会是在这里。他值得去别的地方寻找成功，但不会是在这里。这个决定是非常具有戏剧性的。

(00:58:08):
在很多情况下，面对艰难决定，我们其实知道正确答案是什么，只是在寻找确认。如果你需要确认，那就去和表现最优秀的人聊聊，问他们：“假设 XYZ 要离职了，你会觉得多难受？”你会惊讶地发现他们会告诉你：“噢，没什么大不了的。”这就是你的确认。

---

### [00:58:40] Lenny Rachitsky

**English:**
Yeah. We had Elizabeth Stone from Netflix, the CTO of Netflix on, and she talked about this thing they called a keeper test, which is exactly that, where every manager is always asking themselves, "If this person were to leave tomorrow and tell me they're leaving, would I fight to keep them? And if not, I should just, I need to let them go," and that's always top of mind for managers there.

**中文翻译:**
是的。我们请过 Netflix 的 CTO Elizabeth Stone，她谈到了他们所谓的“留任测试”（keeper test），跟你说的一模一样。每个经理都要不断问自己：“如果这个人明天告诉我他要离职，我会努力挽留他吗？如果不会，那我就应该让他走。”那是他们经理脑子里时刻紧绷的一根弦。

---

### [00:58:59] Uri Levine

**English:**
You know, one of my companies had a pretty good year and they decided to have an annual bonuses by and large to nearly all of the employees. And then I asked the CEO, "So how did you end up with the list?" And he said, "Okay. We had these people that getting twice as much the others, and then the others, and then there are four people that are not going to get anything." And I asked them, "Are they still here?" They shouldn't be here, right? If they are so much underperforming, then they shouldn't be here. But generally you need the time to ask yourself the tough questions because only then you can answer them, right? If you don't ask the tough questions, then you don't answer them.

**中文翻译:**
你知道，我的一家公司有一年业绩很好，他们决定给几乎所有员工发年终奖。我问 CEO：“你是怎么定名单的？”他说：“好，有些人拿双倍，有些人拿普通奖金，还有四个人什么都拿不到。”我问他：“那四个人还在公司吗？”他们不该在那儿，对吧？如果他们表现差到那种程度，就不该留着。但通常你需要花时间问自己这些难题，因为只有问了，你才能回答。如果你不问难题，你就永远得不到答案。

---

### [00:59:49] Lenny Rachitsky

**English:**
Yeah. I really love this very tactical piece of advice, which I was definitely going to touch on, of putting a calendar entry into your calendar when you hire someone 30 days in to remind yourself, asking yourself, "Would I hire this person knowing what I know now? And if not, you should probably let them go."

**中文翻译:**
是的。我非常喜欢这个极具战术性的建议，我刚才正想提这点：在雇人 30 天后在日历上设个提醒，问自己：“基于现在了解的情况，我还会雇这个人吗？如果不会，可能就该让他走了。”

---

### [01:00:06] Uri Levine

**English:**
By the way, I can tell you that for everything in your life, right? Everything in your life, ask yourself, "Knowing what you know today, would you do something different?"

**中文翻译:**
顺便说一下，这适用于你生活中的一切，对吧？生活中的每一件事，问问自己：“基于你今天所了解的情况，你会做出不同的选择吗？”

---

### [01:00:16] Lenny Rachitsky

**English:**
Wow.

**中文翻译:**
哇。

---

### [01:00:17] Uri Levine

**English:**
If the answer is yes, then do something different today. Today is the first day of the rest of your life.

**中文翻译:**
如果答案是肯定的，那么今天就做出改变。今天是你余生的第一天。

---

### [01:00:23] Lenny Rachitsky

**English:**
That is powerful advice. So what I'm thinking there is if I bought something, maybe return it. What else have you applied that to in your life?

**中文翻译:**
这是非常有力的建议。我在想，如果我买了什么东西（不满意），也许该退了。你还在生活的哪些方面应用过这个原则？

---

### [01:00:31] Uri Levine

**English:**
Relationship in general. Directions that you're going, right? Do you still like that? I have five children and they're all in their twenties and beginning of thirties and they struggle with their career path, and I basically tell them, "Look, if you are going to work in a place and you don't like it, then what I want you to do is ask yourself why you are not liking it and whether or not there is something that you can change, and I'm going to ask you the same question in 90 days from now, and if this still is the case, then quit."

**中文翻译:**
通常是人际关系，还有你前进的方向，对吧？你还喜欢现在做的事吗？我有五个孩子，都在二十多岁到三十出头，他们也在为职业道路挣扎。我基本上告诉他们：“听着，如果你在某个地方工作但不喜欢，我希望你问问自己为什么不喜欢，以及是否有你可以改变的地方。90 天后我会再问你同样的问题，如果情况依然如此，那就辞职。”

---

### [01:01:14] Lenny Rachitsky

**English:**
It's interestingly you make that 90 days, which it kind of applies some decisions. You need to wait a little bit more. You need more data. You need more time than necessarily 30 days, but set some kind of timeline.

**中文翻译:**
很有意思你定的是 90 天，这适用于某些决定。你需要多等一会儿，需要更多数据，需要比 30 天更长的时间，但关键是要设定一个时间表。

---

### [01:01:24] Uri Levine

**English:**
If you don't set a timeline, it'll never happen.

**中文翻译:**
如果你不设定时间表，改变就永远不会发生。

---

### [01:01:28] Lenny Rachitsky

**English:**
I think the other really interesting implication here is most decisions are a two-way door. Most decisions, you can change your mind. You can quit. You can leave a relationship. I was thinking you were going to say with your five kids 30 days after they're born, "Do I still want this kid 30 days with knowing what I know now?" I'm glad you didn't go there.

**中文翻译:**
我认为这里另一个有趣的含义是，大多数决定都是“双向门”。大多数决定你都可以改变主意。你可以辞职，可以结束一段关系。我刚才还在想你会不会说，在五个孩子出生 30 天后问：“基于我现在了解的情况，我还要这个孩子吗？”很高兴你没往那儿说。

---

### [01:01:52] Uri Levine

**English:**
No, this is different, right? You go into this journey of having children with the understanding that this is long journey. Go into this journey of building a startup with the understanding that this is a long journey, right? The fact that it's going to be hard? Okay, so it's hard. It is hard, by the way. But yeah, the decisions that obviously they need to be relative to their duration, right? So yeah, raising kids is a long journey.

**中文翻译:**
不，那是不同的。你决定生孩子时就知道这是一段漫长的旅程。你决定创业时也知道这是一段漫长的旅程，对吧？事实是它会很艰难，确实很艰难。但是，决定显然需要与其持续时间相匹配。所以，养孩子是一段长跑。

---

### [01:02:29] Lenny Rachitsky

**English:**
And a one-way door, also. Is there anything else you wanted to say around the hiring and firing concept? Clearly firing is the main lesson here, is get really good at firing, firing quickly and decisively.

**中文翻译:**
而且那是扇“单向门”。关于招聘和解雇，你还有什么想说的吗？显然，解雇是这里的主要教训：要擅长解雇，要快速且果断地解雇。

---

### [01:02:41] Uri Levine

**English:**
You know, there are tons of advices in the book and eventually I will tell, even in the hiring process, right, most of us are going to interview candidates and then decide that they like or dislike the candidate, but they don't know. Then speak with someone that does know. Speak with the reference.

**中文翻译:**
书里有大量的建议。最后我想说，即使在招聘过程中，我们大多数人面试完候选人后，只是决定喜不喜欢他，但其实并不真正了解他。那就去问了解他的人，去做背景调查（reference check）。

---

### [01:03:02] Lenny Rachitsky

**English:**
Do you have a favorite question you like to ask references? Is there something that you find is really helpful to tell you? Give you honest insight?

**中文翻译:**
你有没有最喜欢问背调人的问题？有没有什么问题你觉得特别有效，能让你获得诚实的见解？

---

### [01:03:09] Uri Levine

**English:**
For reference?

**中文翻译:**
针对背调人？

---

### [01:03:10] Lenny Rachitsky

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:03:11] Uri Levine

**English:**
That's really simple. Would you hire him? Or would you hire her, right? So essentially at the end of the day you want to nail it into yes or no.

**中文翻译:**
非常简单：“你还会雇佣他/她吗？”本质上，你最终还是想把答案锁定在“是”或“否”上。

---

### [01:03:26] Lenny Rachitsky

**English:**
Yeah. And hope that they're being honest. That's sometimes a challenge.

**中文翻译:**
是的，并希望他们能诚实。这有时是个挑战。

---

### [01:03:31] Uri Levine

**English:**
No, if they will tell me yes, then I would ask them, "Why didn't you?" Someone asked me for a reference on someone that I really enjoyed working with. I really think highly of them, and he asked me if they can schedule a call for half an hour and I said, "Look, I'm traveling. I don't really have time. But if you want an email in one word, take the guy." And then he was trying to outsmart and ask me back, "Can I have that in two words?" And I said, "Yeah, take the guy fast." When you know, you know. That's it.

**中文翻译:**
不，如果他们告诉我“会”，我会问：“那你为什么没雇？”有人曾找我给一个我很喜欢共事、评价很高的人做背调。他问能不能约半小时电话，我说：“听着，我在出差，没时间。但如果你想要一个单词的邮件回复，那就是：‘录用’（Take）。”然后他想耍点小聪明，回问：“能给我两个单词的回复吗？”我说：“好，‘赶快录用’（Take fast）。”当你确定的时候，你就知道了。就是这样。

---

### [01:04:07] Lenny Rachitsky

**English:**
I like that. That's what you want to be looking for. Okay. Amazing. So let's do one more chapter. The one I was going to pick, you choose what you're more excited about, is selling a company. Your last chapter exit. The one you were thinking about going to is talking to users. I imagine that's much more applicable to more people, so that's probably the better choice, but your choice.

**中文翻译:**
我喜欢这个，这就是我们要找的状态。太棒了。那我们再聊一个章节。我本来想选的是关于卖掉公司，也就是最后一章“退出”。而你想聊的是“与用户交流”。我想后者对更多人适用，所以可能是更好的选择，但听你的。

---

### [01:04:28] Uri Levine

**English:**
Okay, then let's stick with understanding users. Steve Wozniak, co-founder of Apple, wrote the foreword to my book and he called it the Bible for entrepreneurs, and when I sent him the first chapter, he said, "Wow, I wish I had that When I started." I met Steve Wozniak for the first time about 10 years ago. We spoke at the same conference in Guatemala, and look, when I grew up, Steve Wozniak was my technological guru, right so he was the most important person in the technology space in my mind. And then we spoke at the same conference and we had dinner the night before, and the only thing that actually was really important for me is to have a selfie with my idol, right? And so I took up my iPhone and with the iPhone you can take pictures by clicking here on the screen or using the volume button on the side, right?

(01:05:34):
And so I took a selfie with him holding the phone like that and clicking on the volume button and he said, "Finally." And I said, "Finally what?" "Finally someone using it the way that I meant it to be." Now you realize that there is no right or wrong. There are different people that are using different products in different ways, and occasionally if I would have large audience, then I would ask the people, "Okay, how do you use Waze?" Right? "So you go to your destination and you enter destination, and then Waze guides you through the screen with the display of the maneuvers that needs to be made or with the audio guidance of turn right, turn left and so forth. If you are watching the screen, raise your hand." And then I would have about 70% of the people raise their hand." Then I ask people to watch around them and see those people. Then I ask, "If you are listening to the audio prompt, raise your hand." Then I have about 20 or 30 more percent of the people raising their hand. And again, I send people to watch around and see those hands.

(01:06:41):
There is no right or wrong. Different people are using it differently. Now, if you are using Waze in a certain way, up until this moment, you didn't know that there are other people that are using it differently, and to be frank, you don't care. You getting your own value the way that you get it, then you don't really care that there are other people that are getting it differently. But if you are building a product and you don't know that, then you are building the wrong product. You don't know that there are other people that are not like you, and you think that you're building the product for yourself, then you're making a big mistake. And the way to figure it out is, by the way, two things. Number one, watch new users. Simply watch users and see what they're doing. And number two, if they're not doing what you expect them to do, then ask them why, because this why is the one that is going to make your product successful. You understand the why and the next version you're going to address that.

(01:07:42):
Now, this is in particular when it comes to understanding users. Obviously there are a lot of users, but we can group them into several groups of their ability to adapt something new, and something new is not necessarily new technology. We think about it as a new technology, but it's not necessarily about technology. It's about new behavior, right? And then we look at the entire population and every time that we look into large numbers, they will have normal distribution, right? So the bell curve of the distribution, and then we will have about 2% of the populations that they're the innovatives. The innovatives are going to use something new because it's new. That's it. They care about this subject and they going to be the first one to hear about it and they're going to try that out because it's new. The second group is usually what we will get to see as the first users are the early adapters. As soon as they realize that there is value, they're going to give it a try. And if there is value, then they will keep on using it, and if there is no value, then they will quit. Right?

(01:08:55):
The third group is the most important group. This is where market leaders are, right? This is called the early majority. This is about one third of the population, and the one that wins the early majority wins the market. The challenge with this group, with the people in this group, is that they're afraid of change. So their state of mind is, don't rock the boat. Whatever I'm currently doing is good enough for me. So if you have Salesforce.com, which is absolutely amazing, their reaction is going to be, "What's wrong with Excel?" And because they're afraid of change, they are not going to try something new. Now the reason is that at the end of the day, they're afraid that this is going to be too complex for them and they will not get it, and they don't want to be embarrassed and they don't want to feel like idiots. And guess what? People don't like to feel like idiots, and so they are not going to try. And you need to see those people to understand their barriers for starting to use your service.

(01:10:02):
And by the way, the solution is always the same. Simplicity. Leonardo da Vinci said that simplicity is the ultimate sophistication. If you want to make it simple, in your journey of building a product, we basically say this is iteration to iteration to iteration. In many of those you add features and you add features and you add features until you all of a sudden you add the features that people are using. What you really want to do next is remove the rest of the features that people are not using because they're adding complexity. Now, most of the product owners, they're either innovators or early adopters. You cannot understand an early majority person. If you belong to one group, you cannot understand a person from that group unless you watch them and [inaudible 01:10:57]. So the most important part of understanding users is actually seeing those users. And they are not wrong. This is how they behave.

**中文翻译:**
好，那我们就聊“了解用户”。苹果联合创始人史蒂夫·沃兹尼亚克为我的书写了序言，称之为创业者的圣经。当我把第一章发给他时，他说：“哇，真希望我创业时就有这本书。”我第一次见沃兹尼亚克是大约 10 年前，我们在危地马拉的一个会议上演讲。听着，在我成长的过程中，沃兹尼亚克是我的技术偶像，在我心中他是技术领域最重要的人。前一天晚上我们一起吃晚饭，对我来说唯一重要的事情就是和偶像合影。于是我拿出 iPhone，你知道 iPhone 可以点击屏幕拍照，也可以按侧面的音量键拍照，对吧？

(01:05:34):
我拿着手机那样跟他合影，按下了音量键。他说：“终于等到了。”我问：“终于等到什么？”他说：“终于有人按照我设计的方式使用它了。”这时你就会意识到，没有对错之分，不同的人会以不同的方式使用不同的产品。偶尔面对大量观众时，我会问：“你们怎么用 Waze？”“你输入目的地，Waze 引导你，屏幕上显示路线，语音提示左转右转。如果你是看屏幕的，请举手。”大约 70% 的人会举手。我让他们看看周围。然后我问：“如果你是听语音提示的，请举手。”又有大约 20-30% 的人举手。我再次让他们看看周围。

(01:06:41):
没有对错，不同的人用法不同。如果你一直以某种方式使用 Waze，直到这一刻你才知道别人用法不同，而且坦白说，你并不在乎。你以自己的方式获得价值，你不在乎别人怎么用。但如果你在开发产品却不知道这一点，你就在开发错误的产品。你不知道还有和你不一样的人，如果你认为你是在为自己开发产品，那你就犯了大错。弄清楚这一点的方法有两点：第一，观察新用户，看他们在做什么；第二，如果他们没按你预期的做，问他们为什么。因为这个“为什么”才是让产品成功的关键。理解了原因，你就能在下一个版本中解决它。

(01:07:42):
特别是在了解用户方面，用户有很多，但我们可以根据他们接受新事物的能力将其分组。新事物不一定是新技术，也可以是新行为。如果我们看整个人群，大样本通常呈正态分布，也就是钟形曲线。大约 2% 的人是“创新者”（innovators），他们用新东西纯粹是因为它新，他们关注这个领域，会第一时间尝试。第二组通常是我们看到的第一批用户，叫“早期采用者”（early adopters）。只要他们意识到有价值，就会尝试；有价值就继续用，没价值就放弃。

(01:08:55):
第三组是最重要的，这是市场领导者所在的地方，叫“早期大众”（early majority）。这部分人约占总人口的三分之一，谁赢得了早期大众，谁就赢得了市场。这组人的挑战在于他们害怕改变。他们的心态是“别自找麻烦”，我现在用的东西对我来说已经足够好了。如果你向他们推销 Salesforce，虽然它很棒，他们的反应会是：“Excel 有什么不好吗？”因为害怕改变，他们不会尝试新东西。究其原因，是因为他们担心这太复杂，自己搞不定，他们不想感到尴尬，不想觉得自己像个白痴。猜猜看？没人喜欢觉得自己像白痴，所以他们干脆不试。你需要观察这些人，了解他们开始使用你服务的障碍。

(01:10:02):
顺便说一下，解决方案永远只有一个：简单。达芬奇说过，简单是终极的复杂。如果你想让产品变简单，在构建产品的过程中，我们说要不断迭代。在很多次迭代中，你会不断增加功能，直到你终于加了一个大家都在用的功能。接下来你真正要做的是删掉其他没人用的功能，因为它们增加了复杂性。大多数产品负责人要么是创新者，要么是早期采用者，你无法凭直觉理解一个早期大众。如果你属于其中一组，除非你亲眼观察他们，否则你无法理解另一组人。所以了解用户最重要的部分就是亲眼看他们如何操作。他们没有错，这就是他们的行为方式。

---

### [01:11:09] Lenny Rachitsky

**English:**
So a couple of threads there I'll pull out. One is look for surprising uses of your product because, as you said, you'll realize, "Oh, some people are using this in a way that I didn't expect," and it'll remind you people are not the way you are and don't assume that they're going to want exactly what you're building, so pay attention to things that surprise you. We had Jeffrey Moore on the podcast and he talked through a lot of this stuff, and one of the lessons there to help you bridge that gap from, to the, what is it, the third group? How did you describe it? The late majority?

**中文翻译:**
我总结出几点。一是寻找产品中令人惊讶的用法，因为正如你所说，你会意识到：“噢，有些人以我没想到的方式使用它。”这会提醒你别人和你不一样，不要假设他们想要的就是你正在造的东西。所以要关注那些让你惊讶的事。我们请过 Jeffrey Moore（《跨越鸿沟》作者），他也聊过很多这类内容。其中一个教训是帮助你跨越鸿沟，进入……那是第几组来着？你怎么描述的？晚期大众？

---

### [01:11:42] Uri Levine

**English:**
The early majority.

**中文翻译:**
早期大众。

---

### [01:11:42] Lenny Rachitsky

**English:**
The early majority.

**中文翻译:**
早期大众。

---

### [01:11:44] Uri Levine

**English:**
Late majority will never use the product. They will use your product only if they have to.

**中文翻译:**
晚期大众永远不会主动用你的产品。他们只有在不得不用的情况下才会用。

---

### [01:11:45] Lenny Rachitsky

**English:**
Yeah. The laggards, I think he calls it. They look for basically references. People telling them, "Hey, you really need to use this." A lot of people, just like basically word-of-mouth is the way you described it.

**中文翻译:**
是的，他称之为“落后者”（laggards）。他们基本上在寻找参考，寻找别人告诉他们：“嘿，你真的得用用这个。”很多人就像你描述的那样，主要靠口碑。

---

### [01:11:58] Uri Levine

**English:**
No, not just word-of-mouth. Even occasionally someone to show them how to use it.

**中文翻译:**
不，不只是口碑。甚至偶尔需要有人亲自演示给他们看怎么用。

---

### [01:12:03] Lenny Rachitsky

**English:**
Yeah. That makes sense. Just like, "Here, check out Waze. Here's how it works." Yeah, that makes a lot of sense. Okay. Amazing. Is there anything else along those lines as you're talking to customers and understanding what you're looking for that you want to share?

**中文翻译:**
是的，有道理。就像是：“嘿，看看 Waze，它是这么用的。”这很有道理。太棒了。关于与客户交谈并了解你在寻找什么，还有什么想分享的吗？

---

### [01:12:17] Uri Levine

**English:**
Occasionally what happens is that we speak with the wrong customers. So just imagine that we have what I call funnel of use, right? So on top of the funnel, we have people that are download the app, let's say, or have entered their website, and then the next phase is that they registered and the next phase that they're trying to use it for the first time and then the next phase is that they're getting the value and they're coming back, right? In this funnel, what we usually try to do is speak with the users at the bottom of the funnels, those that were successful. But in order to improve, we need to speak with those that fail, those that were unsuccessful, those that did not register, or they did register and did not use, or they did use and did not come back, because they know something that we really need to know. Why? This why is what makes a great product.

**中文翻译:**
偶尔会发生的情况是我们找错了客户。想象一下我所谓的“使用漏斗”：漏斗顶部是下载应用或进入网站的人；下一阶段是注册；再下一阶段是尝试第一次使用；最后阶段是获得价值并再次回来。在这个漏斗中，我们通常倾向于和漏斗底部的人交流，也就是那些成功使用的用户。但为了改进，我们需要和那些失败的人交流——那些没注册的、注册了没用的、或者用了没再回来的。因为他们知道一些我们迫切需要知道的事情。为什么？这个“为什么”才是成就伟大产品的关键。

---

### [01:13:19] Lenny Rachitsky

**English:**
Interesting. I imagine you could also fall into danger there if people that just aren't a fit for your product, there's just no point wasting your time on people that are just not going to be a fit. So is the idea there find people that are really far down the funnel but still bounced and churned?

**中文翻译:**
有意思。我能想象这也有风险，如果有些人根本就不是你的目标用户，那在他们身上浪费时间就没意义。所以你的意思是找那些已经进入漏斗很深、但最终还是流失了的人？

---

### [01:13:34] Uri Levine

**English:**
Yep.

**中文翻译:**
没错。

---

### [01:13:34] Lenny Rachitsky

**English:**
Awesome. Amazing. Okay. So we've gone through all the chapters I was hoping to go through, plus the ones you were excited about. Final thing before we get to our very exciting lightning round, we have a segment on this podcast called Fail Corner, where I ask a guest to share a time they failed in their career and what they learned from that experience, and I'm curious if there is a story that comes to mind of a time that you failed either in a startup or as you were an employee somewhere and how that was important to you.

**中文翻译:**
太棒了。我们已经聊完了我想聊的所有章节，还有你感兴趣的那些。在进入激动人心的闪电轮问答之前，最后一件事：我们播客有一个叫“失败角落”的环节，我会请嘉宾分享职业生涯中的一次失败经历以及从中吸取的教训。我很好奇，你脑海中是否有一个关于失败的故事——无论是在创业过程中还是作为员工时——以及它对你有多重要？

---

### [01:14:05] Uri Levine

**English:**
So number one, I reserve the right for my biggest failure yet to come. And look, I keep on trying new things. I keep on doing things, and so eventually I will fail as much as... Maybe I'm more successful statistically than others, but I will fail, and this is very, very important part to realize. Don't be afraid to fail, right? In your journey, you're going to fail multiple times, and when you fail and get up, you get up stronger. This is maybe something that I will tell all the parents in the world. The biggest advice that I can give you is teach your children to fail. Because when they get up, they get up stronger, and when they know that they will get out of their comfort zone and they will eventually discover what makes them happy. At the end of the day, as parents, there's only one thing that we really like. We want our kids to be happy in their own way. We don't know what it is. They don't know what it is. We want them to explore, and they will only explore if they are not afraid to fail.

**中文翻译:**
首先，我保留“最大的失败尚未到来”的权利。听着，我一直在尝试新事物，一直在行动，所以最终我也会失败。也许从统计学上讲我比别人更成功，但我依然会失败，意识到这一点非常非常重要。不要害怕失败。在你的旅程中，你会失败多次，而当你失败后站起来，你会变得更强大。这也许是我会对全世界父母说的话：我能给出的最大建议就是教会你的孩子如何失败。因为当他们站起来时，他们会变得更强大；当他们知道自己可以走出舒适区，他们最终会发现什么能让他们快乐。归根结底，作为父母，我们真正想要的只有一件事：希望孩子以自己的方式获得快乐。我们不知道那是什么，他们也不知道。我们希望他们去探索，而只有不害怕失败，他们才会去探索。

---

### [01:15:18] Lenny Rachitsky

**English:**
Yeah. This is a very timely advice for me because our kid is always falling down and it's always this balance between helping them not fall and letting them figure things out.

**中文翻译:**
是的，这对现在的我来说是非常及时的建议，因为我的孩子总是在摔倒，我总是在“帮他不摔倒”和“让他自己摸索”之间寻找平衡。

---

### [01:15:27] Uri Levine

**English:**
Let them fall. There is a Japanese saying, fall seven times and get up eight.

**中文翻译:**
让他们摔吧。日本有一句谚语：跌倒七次，爬起来八次。

---

### [01:15:36] Lenny Rachitsky

**English:**
Uri, is there anything else that you wanted to share or leave listeners with before we get to our very exciting lightning round?

**中文翻译:**
Uri，在进入闪电轮之前，你还有什么想分享或留给听众的吗？

---

### [01:15:43] Uri Levine

**English:**
No, I think that was actually, I really enjoyed it.

**中文翻译:**
没有了，我觉得刚才聊得很开心。

---

### [01:15:45] Lenny Rachitsky

**English:**
Amazing. Well, we're not done yet. We've reached our very exciting lightning round. Are you ready?

**中文翻译:**
太棒了。不过我们还没结束，现在进入激动人心的闪电轮。准备好了吗？

---

### [01:15:50] Uri Levine

**English:**
Yep.

**中文翻译:**
准备好了。

---

### [01:15:51] Lenny Rachitsky

**English:**
All right. First question, what are two or three books that you recommended most to other people other than your own book?

**中文翻译:**
好。第一个问题：除了你自己的书，你向别人推荐最多的两三本书是什么？

---

### [01:15:58] Uri Levine

**English:**
Mark Randolph of Netflix. *That Will Never Work*, right? And by the way, it's funny. Mark Randolph wrote endorsement to my book and I reached out to him because I read someplace that he's answering all of his emails, and I reached, I sent him an email and said, "Look, we have at least three things in common. Number one, I do answer all of my emails as well. Number two, I'm using your product, you are using mine. And number three, I heard more time that will never work than you did." And I think that understanding this journey is really, really important, so this is definitely a book that I would recommend. *Atomic Habits*. Getting habits and improving them, measuring and improving, is really, really important.

**中文翻译:**
Netflix 的 Marc Randolph 写的《那行不通》（*That Will Never Work*）。顺便说一下，很有趣，Marc Randolph 为我的书写了推荐语。我联系他是因为我在哪里读到他会回复所有的邮件。我给他发了封邮件说：“听着，我们至少有三个共同点：第一，我也回复所有邮件；第二，我在用你的产品，你也在用我的；第三，我听到的‘那行不通’比你听到的还要多。”我认为理解这段旅程非常非常重要，所以这绝对是我推荐的一本书。还有《原子习惯》（*Atomic Habits*）。养成习惯并改进它们，衡量并改进，这非常重要。

---

### [01:16:55] Lenny Rachitsky

**English:**
Very cool choices. Do you have a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
很棒的选择。你最近有没有特别喜欢的电影或电视剧？

---

### [01:17:02] Uri Levine

**English:**
I don't watch a lot.

**中文翻译:**
我不怎么看电视。

---

### [01:17:05] Lenny Rachitsky

**English:**
Easy, then. Do you have a favorite product that you've recently discovered that you really love?

**中文翻译:**
那好办。你最近有没有发现什么特别喜欢的、让你爱不释手的产品？

---

### [01:17:11] Uri Levine

**English:**
So I can bet that most of the people say the ChatGPT, but actually no. I recently downloaded the Chess App and I returned to play chess with the computer or something that I haven't done for so many years, and I really enjoy that.

**中文翻译:**
我敢打赌大多数人会说 ChatGPT，但我不是。我最近下载了一个国际象棋应用，重新开始和电脑下棋，这是我很多年没做过的事了，我非常享受。

---

### [01:17:30] Lenny Rachitsky

**English:**
Amazing. It's actually, I don't think ChatGPT has ever been recommended. Recent choices have been a beautiful Persian rug, a Rivian, a very nice Mercedes, and I think recently it was a course on nervous system regulation.

**中文翻译:**
太神奇了。其实我觉得还没人推荐过 ChatGPT。最近的选项有一块精美的波斯地毯、一辆 Rivian 电动车、一辆很棒的奔驰，最近还有一个关于神经系统调节的课程。

---

### [01:17:48] Uri Levine

**English:**
Cool.

**中文翻译:**
酷。

---

### [01:17:49] Lenny Rachitsky

**English:**
All over the place. Two final questions. Do you have a favorite life motto that you find really useful in work, your own life? It may be the one on your shirt, but is there any other that you come back to often and find useful?

**中文翻译:**
五花八门。最后两个问题。你有没有什么人生格言，觉得在工作或生活中非常受用？也许就是你 T 恤上那句，但还有没有其他的你经常想起并觉得有用的？

---

### [01:18:03] Uri Levine

**English:**
Don't be afraid to fail. I think that in many cases we need to accept the fact that we don't know.

**中文翻译:**
不要害怕失败。我认为在很多情况下，我们需要接受“我们不知道”这个事实。

---

### [01:18:10] Lenny Rachitsky

**English:**
Important words. Final question, is there a problem you're starting to fall in love with more recently, maybe tinkering with a new startup idea? Or are you done with starting companies?

**中文翻译:**
至理名言。最后一个问题：你最近有没有开始爱上什么新问题？也许是在琢磨一个新的创业点子？还是说你已经不再创业了？

---

### [01:18:21] Uri Levine

**English:**
I probably will never be done. I have 10 different startups in multiple areas. One of them, Pontera helps people to retire richer, which is one of the biggest challenges in the world in general, but also in the U.S. If I would ask a hundred people on the street that have 401k plans, "What is your 401k plan invested at?" 95% of them will tell me, "I don't know." I do know, by the way. In the default. Whatever was the default when they joined, right? Now obviously if you didn't do anything and you think it's right, no, it's not right. It's probably simply not enough. So this is a big problem. I have one in the medical space that is trying to create, I would call that the AI of the medical knowledge, so trying to improve doctors, and in particular in clinical decisions. That is going to change the world.

(01:19:27):
But if you would ask me, then I will give you some examples, right? So mobility is still a problem, right? You look at many areas in our lifetime and mobility is still, every year it's, instead of getting better, it's getting lesser. So mobility is still a problem. And medical services, right? U.S. medical services are five to 10 times more expensive than they are in Germany. Now, it's not that they're better. They're simply more expensive. So obviously you ask yourself, "Okay, where is this inefficiency? Where is it?" Right? A lot of places of inefficiency in the medical services if they're so expensive. Education. Okay. Anything that I will tell you that we are still doing the same way that our parents did is probably something that we need to revisit.

**中文翻译:**
我可能永远不会停止。我有 10 家不同领域的初创公司。其中一家叫 Pontera，帮助人们更富有地退休，这是全球（尤其是美国）面临的最大挑战之一。如果我问街上 100 个有 401k 计划的人：“你的 401k 投在什么地方了？”95% 的人会说：“我不知道。”顺便说一下，我知道答案：投在默认选项里了。就是他们入职时的那个默认设置。显然，如果你什么都不做并认为那是对的，其实不对，那可能根本不够。所以这是一个大问题。我还有一家医疗领域的公司，试图创建我所谓的“医学知识 AI”，旨在帮助医生，特别是在临床决策方面。这将改变世界。

(01:19:27):
如果你问我，我会给你举些例子。比如出行（mobility）依然是个问题。你看我们生活中的许多领域，出行每年不仅没变好，反而变差了。所以出行依然是个问题。还有医疗服务，美国的医疗服务比德国贵 5 到 10 倍。并不是因为更好，只是更贵。所以你显然会问：“低效在哪里？到底在哪儿？”如果医疗这么贵，肯定有很多低效的地方。还有教育。总之，任何我告诉你在以和我们父母辈相同的方式运作的事情，可能都值得我们重新审视。

---

### [01:20:22] Lenny Rachitsky

**English:**
I feel like I nerd sniped you with falling in love with problems. Clearly fall in love with a lot of problems. You want to solve them all. You're addicted to startups.

**中文翻译:**
我觉得我用“爱上问题”这个话题把你给“套住”了。显然你爱上了很多问题，你想把它们全解决了。你对创业上瘾了。

---

### [01:20:29] Uri Levine

**English:**
The good news is that there are a lot of problems and the bad news that there are lots of problems.

**中文翻译:**
好消息是有很多问题，坏消息也是有很多问题。

---

### [01:20:34] Lenny Rachitsky

**English:**
And you're there to solve it. I love it. Uri, your book is amazing. It's incredibly practical, full of tons of advice that every founder should read, and it goes from idea all the way to exit. So basically, no matter where you're on the journey, the book is going to be useful to you. Tell people where to find it and where they can follow you for more stuff that you share over time, and then how can listeners be useful to you?

**中文翻译:**
而你就在那儿解决它们。我喜欢这个。Uri，你的书太棒了。它非常实用，充满了每个创始人都该读的建议，涵盖了从点子到退出的全过程。所以基本上，无论你处于旅程的哪个阶段，这本书都会对你有用。告诉大家在哪里可以买到，以及在哪里可以关注你以获取更多分享。另外，听众们可以为你做些什么？

---

### [01:20:56] Uri Levine

**English:**
So obviously this is the book. Amazon, Barnes & Noble, basically places that you can find it. You can follow me on LinkedIn. This is pretty much the only network that I'm actually engaged. If you read the book, then you will find my email in the book and then you can email me, as well. And I do answer all of my emails. I want you to read the book. I don't want you to buy the book. I want you to read the book. And the reason is that I have a purpose in life and this is creating value, and I believe that this book is going to be the best return on investment that you ever made. Not the $20 or $30 that it costs, but the time that you're going to spend on reading it, and therefore, I can be valuable for you, and if I can be valuable for you, then I serve my purpose.

**中文翻译:**
显然，这就是那本书。亚马逊、Barnes & Noble，基本上到处都能买到。你可以在 LinkedIn 上关注我，那几乎是我唯一活跃的社交网络。如果你读了这本书，你会发现我的邮箱就在书里，你也可以给我发邮件。我确实会回复所有邮件。我希望你“读”这本书，而不仅仅是“买”这本书。原因是我的人生目标是创造价值，我相信这本书将是你做过的最好的投资回报——不是那 20 或 30 美元的书价，而是你花在阅读上的时间。如果我能对你有价值，那我就实现了我的目标。

---

### [01:21:53] Lenny Rachitsky

**English:**
Amazing. If you weren't on YouTube watching this, the book is called *Fall in Love with the Problem, Not the Solution*, if you're trying to Google it and find that on Amazon. And Uri, thank you so much for being here.

**中文翻译:**
太棒了。如果你没在 YouTube 上看视频，这本书的名字叫《爱上问题，而非解决方案》（*Fall in Love with the Problem, Not the Solution*），你可以在亚马逊上搜到。Uri，非常感谢你能来。

---

### [01:22:05] Uri Levine

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:22:06] Lenny Rachitsky

**English:**
Bye, everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at Lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢收听。如果你觉得本期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现本播客。你可以在 Lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。