# Varun Parmar - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Varun Parmar, Chief Product Officer at Miro.

---

### [00:00:00] Varun Parmar

**English:**
Every single day, every single time somebody is pushing your code to production and you're releasing a feature or an enhancement, you are making the product better or you're making the product worse, but the products never remain same. So with every release that your competitor is making and every release that you're making, you are either making chess points, moves against them, positive points, or you're going negative. I think that framework, it actually drives an insane amount of clarity in terms of what you're doing and what the impact is going to be.

**中文翻译:**
每一天，每当有人将代码推送到生产环境，每当你发布一个新功能或改进时，你都在让产品变得更好或者变得更差，产品永远不会停留在原地。因此，随着竞争对手的每一次发布和你自己的每一次发布，你就像在下棋，要么是在针对他们得分（正向移动），要么就是在失分（负向移动）。我认为这个框架能让你对自己在做什么以及会产生什么影响产生极大的清晰度。

---

### [00:00:33] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard-won experiences building and growing today's most successful products. Today my guest is Varun Parmar. Varun is chief product Officer at Miro, and prior to Miro, he was senior vice president and chief product officer at Box. As I share with Varun at the start of our chat, I've always been really curious about the product culture at Miro, partly because everyone I've ever met from Miro has been super interesting and super smart, and partly because they've been able to grow as a business and a product in an incredibly competitive market.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我会采访世界级的产品领导者和增长专家，学习他们在构建和增长当今最成功产品过程中积累的宝贵经验。今天的嘉宾是 Varun Parmar。Varun 是 Miro 的首席产品官（CPO），在加入 Miro 之前，他曾担任 Box 的高级副总裁兼首席产品官。正如我在聊天开始时向 Varun 提到的，我一直对 Miro 的产品文化非常好奇，部分原因是我遇到的每个 Miro 员工都非常有趣且聪明，另一部分原因是他们能够在一个竞争极其激烈的市场中实现业务和产品的持续增长。

---

### [00:01:07] Lenny

**English:**
In our conversation, we get really deep into the product values and principles at Miro, their product development process, how Varun approaches competitive threats, how a bimonthly company-wide product demo ritual led to saving months of engineering work on a feature, plus insights into how Miro got started, how they grow today, and what their product team has learned about working with a large sales org. Varun is amazing, I learned a lot, and I hope you find it as interesting as I did. With that, I bring you Varun Parmar after a short word from our sponsors.

**中文翻译:**
在我们的对话中，我们深入探讨了 Miro 的产品价值观和原则、他们的产品开发流程、Varun 如何应对竞争威胁、一个每两周一次的全公司产品演示仪式如何为一个功能节省了数月的工程工作量，此外还分享了关于 Miro 如何起步、如今如何增长，以及他们的产品团队在与大型销售团队合作中学到了什么。Varun 非常出色，我学到了很多，希望你们也能像我一样觉得有趣。在听完赞助商的简短介绍后，让我们欢迎 Varun Parmar。

---

### [00:01:39] Lenny (Sponsorship Message)

**English:**
Today's episode is brought to you by Miro, an online collaborative whiteboard that's designed specifically for teams like yours. I have a quick request. Head on over to my Miro board at miro.com/lenny and let me know which guests you'd want me to have on this year. I've already gotten a bunch of great suggestions, which you'll see when you go there, so just keep it coming. While you're on the Miro board, I encourage you to play around with the tool. It's a great shared space to capture ideas, get feedback, and collaborate with your colleagues on anything that you're working on. For example, with Miro, you can plan out next quarter's entire product strategy. You can start by brainstorming, using sticky notes, live reactions, a voting tool, even an estimation app to scope out your team's sprints. Then your whole distributed team can come together around wire frames, draw ideas with a pen tool, and then put full mocks right into the Miro board.

**中文翻译:**
本期节目由 Miro 赞助。Miro 是一款专为像你们这样的团队设计的在线协作白板。我有一个小请求：请访问我的 Miro 看板 miro.com/lenny，告诉我你希望我今年邀请哪些嘉宾。我已经收到了很多很棒的建议，你可以在那里看到，请继续留言。当你访问 Miro 看板时，我鼓励你试用一下这个工具。它是一个极佳的共享空间，可以捕捉创意、获取反馈，并与同事协作处理任何工作。例如，你可以用 Miro 规划下个季度的整个产品战略。你可以从头脑风暴开始，使用便签、实时反应、投票工具，甚至是用估算应用来确定团队 Sprint（冲刺）的范围。然后，你整个分布式的团队可以围绕线框图聚在一起，用画笔工具勾勒创意，并将完整的原型图直接放入 Miro 看板中。

---

### [00:02:29] Lenny (Sponsorship Message Continued)

**English:**
With one of Miro's ready-made templates, you can go from discovery and research to product roadmaps to customer journey flows to final mocks, all in Miro. Head on over to miro.com/lenny to leave your suggestions. That's M-I-R-O.com/lenny. This episode is brought to you by Braintrust, where the world's most innovative companies go to find talent fast so that they can innovate faster. Let's be honest, it's a lot of work to build a company and if you want to stay ahead of the game, you need to be able to hire the right talent quickly and confidently. Braintrust is the first decentralized talent network where you can find, hire and manage high quality contractors in engineering, design and product for a fraction of the cost of agencies. Braintrust charges a flat rate of only 10%, unlike agency fees of up to 70%, so you can make your budget go four times further.

**中文翻译:**
借助 Miro 现成的模板，你可以完成从发现和研究到产品路线图、客户旅程图再到最终原型的全过程。请访问 miro.com/lenny 留下你的建议。本期节目还由 Braintrust 赞助，全球最具创新精神的公司都在这里快速寻找人才，以便更快地进行创新。坦白说，创办一家公司需要做大量工作，如果你想保持领先地位，你需要能够快速且自信地聘请到合适的人才。Braintrust 是首个去中心化的人才网络，你可以在这里以中介机构一小部分的成本寻找、聘用和管理工程、设计和产品领域的高质量承包商。Braintrust 仅收取 10% 的固定费率，而中介机构的费用高达 70%，因此你可以让你的预算发挥四倍的作用。

---

### [00:03:22] Lenny (Sponsorship Message Continued)

**English:**
Plus they're the only network that takes 0% of what the talent makes, so they're able to attract and retain the world's best tech talent. Take it from DoorDash, Airbnb, Plaid, and hundreds of other high growth startups that have shaved their hiring process from months to weeks at less than a quarter of the cost by hiring through Braintrust network of 20,000 high quality vetted candidates ready to work. Whether you're looking to fill in gaps, upskill your staff or build a team for that dream project that finally got funded, contact Braintrust and you'll get matched with three candidates in just 48 hours. Visit useBraintrust.com/lenny or find them in my show notes for today's episode. That's usebraintrust.com/lenny for when you need talent yesterday. Varun, welcome to the podcast.

**中文翻译:**
此外，他们是唯一一个不从人才收入中抽成的网络，因此能够吸引并留住全球顶尖的科技人才。DoorDash、Airbnb、Plaid 以及数百家其他高增长初创公司都通过 Braintrust 拥有 2 万名经过审核的高质量候选人网络，将招聘流程从数月缩短至数周，且成本不到原来的四分之一。无论你是想填补职位空缺、提升员工技能，还是为那个终于获得资金的梦想项目组建团队，联系 Braintrust，你将在 48 小时内匹配到三名候选人。访问 useBraintrust.com/lenny 或在今天的节目笔记中找到他们。当你急需人才时，就找 usebraintrust.com/lenny。Varun，欢迎来到播客。

---

### [00:04:10] Varun Parmar

**English:**
Thank you, Lenny. So excited to be here. Thanks for having me.

**中文翻译:**
谢谢你，Lenny。很高兴来到这里，感谢你的邀请。

---

### [00:04:13] Lenny

**English:**
I'm really excited to have you here. I've been looking forward to having a chance to dig into Miro's product culture and the way Miro works for a while. We've actually had a few guests, ex-Miro... Mironeers, is that what you call yourselves?

**中文翻译:**
我也非常激动。我一直期待有机会深入了解 Miro 的产品文化和运作方式。我们实际上已经邀请过几位前 Miro 员工……Mironeers（Miro 人），你们是这么称呼自己的吗？

---

### [00:04:25] Varun Parmar

**English:**
Yes, Mironeers.

**中文翻译:**
是的，Mironeers。

---

### [00:04:27] Lenny

**English:**
Okay. Mironeers. So we had Elena Verna on the podcast, who's amazing, and Barbara who I think worked in marketing and everyone I've always met from Miro has been just really smart and really interesting and it just feels like you guys have a really interesting product culture that I haven't felt like has been shared a lot, and so I have a bunch of stuff I want to dig into there. One question I have at the bat, you guys have a really interesting history and specifically the way your company's structured, which is that you're collocated in Amsterdam and San Francisco. First of all, is that correct?

**中文翻译:**
好的，Mironeers。我们之前请过 Elena Verna，她非常棒，还有 Barbara，我记得她是在市场部工作的。我遇到的每一个 Miro 员工都非常聪明且有趣，感觉你们拥有一种非常独特的产品文化，但似乎并没有被广泛分享过，所以我有很多东西想深入挖掘。首先我想问一个问题，你们公司的历史很有趣，特别是结构方面，你们在阿姆斯特丹和旧金山都有总部。首先，这是正确的吗？

---

### [00:05:00] Varun Parmar

**English:**
The company is a global company, so we've got 12 different hubs. We have multiple offices in US, four different offices, and then multiple hubs in Europe as well, and presence in AsiaPac as well. I think by now we have a global footprint, yeah.

**中文翻译:**
公司是一家全球化公司，我们有 12 个不同的中心（hubs）。我们在美国有多个办公室（四个不同的办公室），在欧洲也有多个中心，在亚太地区也有业务。我想现在我们已经拥有了全球足迹。

---

### [00:05:17] Lenny

**English:**
Got it. A question I wanted to ask off the bat is just how has that cross-cultural approach to product teams impacted the way that you guys built product and the way the company operates?

**中文翻译:**
明白了。我想问的第一个问题是，这种跨文化的产品团队模式如何影响了你们构建产品的方式以及公司的运作方式？

---

### [00:05:30] Varun Parmar

**English:**
The one thing that's really interesting, Lenny, around the way Miro is set up is that our product organization is actually based in Europe and our go-to-market organization is worldwide. Our product management team, our designers, our engineers are located across three different hubs in Europe. What that sort of leads to is a couple of practices that we have as part of our culture. The first one is practicing empathy to gain insights. It's not just practicing empathy in terms of customers and figuring out what customer pain points and problems we can solve, but given our distributed nature in terms of having a global footprint and a lot of our go to market teams, folks in sales and marketing and customer success are in different continents or geographies, we have to make sure that we actually practice that internally.

**中文翻译:**
Lenny，关于 Miro 的设置，有一点非常有趣：我们的产品组织实际上设在欧洲，而我们的 GTM（市场进入）组织则是全球性的。我们的产品管理团队、设计师和工程师分布在欧洲的三个不同中心。这导致了我们文化中的几种实践。第一种是“通过同理心获取洞察”。这不仅仅是指对客户的同理心，去弄清楚我们可以解决哪些客户痛点和问题；而且考虑到我们的分布式性质——拥有全球足迹，且许多 GTM 团队（销售、市场、客户成功）分布在不同的洲或地理区域——我们必须确保在内部也践行这种同理心。

---

### [00:06:43] Varun Parmar

**English:**
When we are interacting with folks, let's say in San Francisco, and those folks are out there meeting some of our large customers and stuff, how do we, in the product organization, understand their perspective, and bring that perspective into how we design, prioritize and build products? I think that's one thing that's unique. I would say the other thing that's less to do with the location, but I think is sort of the core cultural value or philosophy that Andre, who's the founder and CEO has instilled in all of us, is practicing teamwork, how do we actually come together as a team, and bring down the silos that might exist across functions? I'll talk a little bit around how we are structured in the product organization so that it's a cross-functional perspective we bring to everything that we're doing because we believe the best work happens when we bring different diverse perspectives to the problem and then co-create the outcome that the customer is looking for.

**中文翻译:**
当我们与旧金山的同事互动时，比如他们正在外面会见我们的一些大客户，我们产品组织如何理解他们的视角，并将这种视角带入我们设计、优先级排序和构建产品的方式中？我认为这是很独特的一点。另一件事与地理位置关系不大，但我觉得是创始人兼 CEO Andre 灌输给我们的核心文化价值观或哲学，那就是“践行团队合作”——我们如何真正作为一个团队聚在一起，打破可能存在于职能部门之间的孤岛？稍后我会谈谈我们产品组织的结构，我们如何为所做的每一件事引入跨职能视角，因为我们相信，当我们将不同的、多元的视角带到问题面前，然后共同创造客户所期望的结果时，最好的工作才会产生。

---

### [00:07:20] Lenny

**English:**
I want to pull on these threads actually real quick. You talked about this value of empathy and the importance of having empathy across... because you guys are located in different locations and have different cultures, and also this idea of teamwork. What's something that you've done that helps you do that, either build empathy and maintain empathy across teams or make sure that people work in teams and not like, "Hey, there's this other team over there doing something else"?

**中文翻译:**
我想顺着这些线索深入探讨一下。你谈到了同理心的价值，以及在不同地点、不同文化背景下保持同理心的重要性，还有团队合作的理念。你们具体做了什么来帮助实现这一点？是建立并维持跨团队的同理心，还是确保人们以团队形式工作，而不是那种“嘿，那边有另一个团队在做别的事”的状态？

---

### [00:07:45] Varun Parmar

**English:**
One of the most powerful things that I've seen work is the questions that you ask, the questions that you ask when you're going through product review or you are going to sit down and talk to someone and trying to understand why did they prioritize something over the other and was it something that was done through interactions they've had with folks internally or externally? I think it's the set of questions to ask in terms of how did they get to where they are today and was it informed by understanding of the insights that collectively the organization has? Was it informed by their understanding of where the market is evolving, where the competition is going.

**中文翻译:**
我见过的最有效的方法之一就是“你提出的问题”。当你进行产品评审，或者坐下来与某人交谈，试图理解为什么他们将某件事的优先级排在另一件事之上时，你问的问题至关重要。这是通过与内部或外部人员的互动得出的结论吗？我认为关键在于问出一系列问题：他们是如何走到今天这一步的？这是否基于对组织集体拥有的洞察的理解？这是否基于他们对市场演变和竞争走向的理解？

---

### [00:08:31] Varun Parmar

**English:**
Was it informed through the series of insights they have, either through inbound feedback that's coming through our different channels where customers are giving feedback or some outbound interactions that they've had? I think just trying to double click and getting to the details in terms of what insight led them to recommend certain things or make a left turn or a right turn is where I think is the most powerful way to make sure that those things are informed through practicing empathy internally and externally.

**中文翻译:**
这些决策是否源于他们获得的一系列洞察，无论是通过我们不同渠道收集的客户反馈（inbound feedback），还是他们进行的一些外部互动（outbound interactions）？我认为，通过深入挖掘细节，了解究竟是什么洞察促使他们建议某些事情，或者做出转向决策，是确保这些决策通过对内对外的同理心实践而产生的最有力方式。

---

### [00:08:59] Lenny

**English:**
Got it. There's this kind of cultural value of just assuming good intention and asking questions to understand where someone came from. I don't know if you'll have something off the top of your head, but is there a story or an example of that comes to mind where that was done well or not done well, I don't know, in something you recently were building?

**中文翻译:**
明白了。这是一种“假设对方是好意”并提问以了解其出发点的文化价值观。我不知道你是否能立刻想到，但在你最近构建的产品中，有没有什么故事或例子能说明这一点做得好或不好的地方？

---

### [00:09:16] Varun Parmar

**English:**
Maybe there are certain things, for example, anytime we're trying to build a new experience, one of the approach we want to take is very quickly validate that our original hypothesis, is that sound or not. We are big fans of the Design Sprint framework, what Jake Knapp has done I think is really amazing. In a short five-day window, you can get a small set of people to quickly mock up a concept, convert it into some sort of a prototype and then go out there and get some sort of a validation. Oftentimes when we are working on some of these new things, we have our product teams that are focused on zero to one initiatives, run this five-day initiative, and at the end of it we say, "Oh, this is great. Who did you get insight from?" There's a capability that we recently released, it's called Miro Talktrack, which essentially allows you to asynchronously do asynchronous collaboration by recording audio video on top of a Miro board.

**中文翻译:**
也许有一些具体的事情。例如，每当我们尝试构建一种新体验时，我们采取的方法之一就是非常快速地验证我们的原始假设是否成立。我们是 Design Sprint（设计冲刺）框架的忠实粉丝，我认为 Jake Knapp 所做的工作非常了不起。在短短五天的时间里，你可以让一小群人快速勾勒出一个概念，将其转化为某种原型，然后去进行验证。通常当我们处理这些从 0 到 1 的新项目时，我们的产品团队会运行这个为期五天的计划，结束时我们会问：“这太棒了，你是从谁那里获得洞察的？”我们最近发布了一个功能叫 Miro Talktrack，它允许你通过在 Miro 看板上录制音频和视频来进行异步协作。

---

### [00:10:16] Varun Parmar

**English:**
We had two fundamental choices we could make. One, we could go down the path of what everyone's doing where you could do a screen recording and then spit out a series of videos, like pixels being captured. Or what we did was we actually went down a different path and the path that we went down was we basically synchronized the movement of the board. Let's say Lenny's presenting a board, some template he's created in terms of best practices for PMs, but he wants to have some sort of a talk track on top of it, an audio video feed. What we are doing is we're actually capturing the movement of the board that Lenny's going through along with the video talk track that's on top. The reason why we did that was because we had an insight that came through some of our interviews.

**中文翻译:**
当时我们有两个根本性的选择。第一，我们可以走大家都在走的老路，即进行屏幕录制，然后生成一系列视频（捕捉像素）。但我们实际上走了一条不同的路：我们同步了看板的移动。假设 Lenny 正在演示一个看板，那是他创建的关于 PM 最佳实践的模板，但他想在上面添加一段讲解（talk track），即音视频流。我们所做的是捕捉 Lenny 操作看板的动作，同时叠加顶部的视频讲解。我们之所以这样做，是因为我们从一些访谈中获得了一个洞察。

---

### [00:10:56] Varun Parmar

**English:**
What our users want to do is they want to use Miro for collaboration. While communication is an important aspect of how teams come together, where we believe our sweet spot is that we want people to use Miro for collaboration. By making sure that they could actually use a video recording and while the video recording is playing, they could add in a sticky note, they could add in a comment, they could actually give a reaction. We were able to develop this insight by practicing empathy as part of the Design Sprint framework when we went and started to show our original concept and we walled and built on top of that.

**中文翻译:**
我们的用户希望使用 Miro 进行协作。虽然沟通是团队聚在一起的重要方面，但我们认为我们的核心优势（sweet spot）是让人们使用 Miro 进行协作。通过确保他们可以使用视频录制，并且在视频播放时，他们可以添加便签、添加评论，甚至做出反应。我们是在 Design Sprint 框架下，通过践行同理心，在展示原始概念并在此基础上不断迭代时，开发出这一洞察的。

---

### [00:11:31] Lenny

**English:**
That is a really cool story. That came out of this Sprint framework, these five-day sprint approach.

**中文翻译:**
这真是一个很酷的故事。这竟然源于这个 Sprint 框架，这种五天的冲刺方法。

---

### [00:11:36] Varun Parmar

**English:**
Yes, that's right. Yeah.

**中文翻译:**
是的，没错。

---

### [00:11:37] Lenny

**English:**
That is cool. I got to have that guy on this podcast. Jake Knapp, you said, right?

**中文翻译:**
太酷了。我得请那个人上我的播客。你说是 Jake Knapp，对吧？

---

### [00:11:41] Varun Parmar

**English:**
Yes, yes, yes. I can text him right now and I can make the introductions, yes.

**中文翻译:**
是的，没错。我现在就可以给他发短信，帮你们引荐。

---

### [00:11:45] Lenny

**English:**
Let's pull him right into this podcast live, tell us how the Sprint process works. That is awesome. This connects a little bit to another question I wanted to ask around the top is, you guys are in a really competitive space and it feels like Miro was very early in online collaborative whiteboarding space and then I think during COVID it just became huge, with the remote work exploding. Like, "Holy shit, everyone needs this immediately." Over the years, many companies have come into the space that you are all in and it feels like Miro continues to do extremely well. I remember when Figma launched FigJam, there was a lot of just like, "Miro's dead. Figma's getting into the space, they're juggernaut, game over." Clearly that's not been the case and it just feels like, I don't know what it is internally that you all do that continues to allow you to compete and continue to innovate in the space. I'm curious just like is there something to how Miro approaches competition and also just, I don't know, the way they approach these sorts of challenges that is unique or interesting that you can share?

**中文翻译:**
让我们直接把他拉进播客直播，告诉我们 Sprint 流程是如何运作的。太棒了。这引出了我想问的另一个核心问题：你们处于一个竞争非常激烈的领域。感觉 Miro 在在线协作白板领域起步非常早，然后在疫情期间，随着远程办公的爆发，它变得非常庞大。就像，“天哪，每个人现在都需要这个。”这些年来，许多公司进入了你们所在的领域，但 Miro 似乎一直表现得非常好。我记得当 Figma 推出 FigJam 时，很多人都在说：“Miro 完蛋了。Figma 进入了这个领域，他们是巨头，游戏结束了。”显然事实并非如此。我很好奇你们内部到底做了什么，让你们能够在这个领域持续竞争并不断创新。我想知道 Miro 在对待竞争方面是否有独特之处，或者在应对这类挑战时是否有独特且有趣的策略可以分享？

---

### [00:12:45] Varun Parmar

**English:**
If you look at the mission for Miro, we empower teams to create the next big thing and our focus is to enable teams that are innovating, and generally innovation happens at the intersection of a bunch of cross-functional folks coming together. Like we discussed, folks in product management or design or engineering or analytics or product marketing or research. What we find, Lenny, is that there are a lot of tools out there and those tools are generally sort of focused on a particular persona and maybe they're trying to solve the needs of a designer and a designer has a workflow that they're trying to do and they're using a specific tool and they sit at the adjacency of extending that core use case. The fundamental value that Miro provides is that we enable teams. I think what's unique about our product, and we can talk about the capabilities and roadmaps and use cases that we are investing in and we already have as part of the product, is that we take a team-centric lens.

**中文翻译:**
如果你看 Miro 的使命，我们是“赋能团队创造下一个大事件”，我们的重点是赋能那些正在创新的团队。通常，创新发生在跨职能人员聚集的交汇点。就像我们讨论过的，包括产品管理、设计、工程、分析、产品营销或研究人员。Lenny，我们发现市面上有很多工具，但这些工具通常专注于特定的角色（persona），比如它们可能在解决设计师的需求，而设计师有特定的工作流并使用特定的工具，这些工具只是在延伸那个核心用例。Miro 提供的根本价值在于我们赋能“团队”。我认为我们产品的独特之处在于——我们可以讨论我们正在投资以及产品中已有的功能、路线图和用例——我们采用的是“以团队为中心”的视角。

---

### [00:13:50] Varun Parmar

**English:**
So we're not saying, "Hey, we're building a tool that just works for designers," or "Hey, we're building a tool that just works for engineers." Because we fundamentally believe that innovation happens when cross-functional teams come together. When you look at the problem through that lens, you realize that you have to actually architect your solution. You have to think about the use cases and you have to go and prioritize certain experiences that are different and our customers see value in that, right? I think that's probably one sort of big macro aspect of how we think about our capabilities and products and why our customers think of us differently. I'd say that's say one point.

**中文翻译:**
所以我们不会说，“嘿，我们正在构建一个只适合设计师的工具”，或者“嘿，我们正在构建一个只适合工程师的工具”。因为我们从根本上相信，当跨职能团队聚在一起时，创新才会发生。当你通过这个视角看问题时，你会意识到你必须真正地构建你的解决方案。你必须考虑用例，并且必须优先考虑那些与众不同的体验，而我们的客户从中看到了价值，对吧？我认为这可能是我们思考功能和产品的一个宏观方面，也是为什么客户对我们的看法不同的原因。这是第一点。

---

### [00:14:27] Varun Parmar

**English:**
I think the second thing is Miro is actually used obviously by teams that are creating these innovative products and we actually have broad applicability across industries and verticals. While some tools might be hyper-focused on digital experiences and Miro's has great offerings there in terms of core capabilities, what we find is that Miro is used equally by companies in manufacturing, by companies in healthcare, by companies in architecture and engineering and construction functions, by companies that are in aerospace, governmental agencies and medical agencies and so on and so forth. I think the platform is actually much more agnostic in terms of its capabilities and what we offer that actually makes it more accessible and appealing to organizations that want to go beyond just digital experiences.

**中文翻译:**
第二点是，Miro 显然被那些创造创新产品的团队所使用，而且我们在各个行业和垂直领域都有广泛的适用性。虽然有些工具可能过度专注于数字体验（digital experiences），而 Miro 在核心功能方面也有出色的表现，但我们发现，Miro 同样被制造业、医疗保健、建筑工程和施工（AEC）、航空航天、政府机构和医疗机构等公司所使用。我认为这个平台在功能和产品提供方面其实更加通用（agnostic），这使得它对于那些想要超越单纯数字体验的组织更具可及性和吸引力。

---

### [00:15:26] Varun Parmar

**English:**
Then I would say finally there are capabilities that are available very, very uniquely to Miro that are valued by our users. That again is a big reason people come to Miro. For example, if Lenny's trying to conduct a big workshop with a bunch of product folks and he wants to facilitate that workshop and wants to have certain folks focus on one part of the board and while others focus on the other part, then there are some advanced capabilities that enable certain use cases like workshops. Or if you want to use Miro for some team rituals or from some agile practices, there are core set of capabilities that you could use the product for that are missing in some of the other capabilities. I would say a combination of all of those three things continue to drive differentiation. I would say on top of that, we are a big fan of our community and we believe that community love is what drives us. That's the fuel that keeps us going every single day.

**中文翻译:**
最后我想说，Miro 拥有一些非常独特的功能，深受用户青睐。这也是人们选择 Miro 的一个重要原因。例如，如果 Lenny 想要和一群产品人员举办一场大型工作坊，他想要引导这场工作坊，并让某些人专注于看板的一部分，而其他人专注于另一部分，那么我们有一些高级功能可以支持像工作坊这样的特定用例。或者，如果你想将 Miro 用于某些团队仪式（team rituals）或敏捷实践，我们有一套核心功能可以支持这些用途，而其他产品可能缺乏这些功能。我认为这三点的结合持续推动了我们的差异化。除此之外，我们非常重视我们的社区，我们相信社区的热爱是驱动我们的动力。那是让我们每天坚持下去的燃料。

---

### [00:16:31] Lenny

**English:**
Awesome. Just to summarize and I was taking notes as you're chatting, just thinking about what allows you all to continue to do well in the market, considering all the competition constantly coming at you. One, as you mentioned, just there's kind of like a innate multi-functional architecture which is hard for someone to copy if they weren't built from that without the start. Two, it sounds like you are focusing on a wide spectrum of personas and it's not just tech employees basically. Also, just there's specific features that end up being really important that maybe people have a hard time building and then this last piece of the community. Awesome.

**中文翻译:**
太棒了。总结一下，你在聊天时我一直在做笔记，思考是什么让你们在竞争不断涌现的情况下依然表现出色。第一，如你所说，有一种天生的多职能架构，如果不是从一开始就以此构建，别人很难复制。第二，听起来你们关注的是广泛的角色，基本上不仅仅是科技行业的员工。此外，还有一些最终变得非常重要的特定功能，其他公司可能很难构建。最后一点是社区。太棒了。

---

### [00:17:08] Varun Parmar

**English:**
Yep.

**中文翻译:**
是的。

---

### [00:17:09] Lenny

**English:**
Let's dig into the product team a little bit and understand how you all build product and structure product team. How many PMs are there at Miro? Then just broadly, how many employees, just to give people a set of, little bit of context?

**中文翻译:**
让我们深入了解一下产品团队，看看你们是如何构建产品和组织产品团队的。Miro 有多少名 PM（产品经理）？另外，大致有多少名员工？给听众提供一点背景信息。

---

### [00:17:20] Varun Parmar

**English:**
Give or take about 1,800 employees at Miro globally across all of the 12 hubs, and specifically in terms of the number of product managers, there are over 450 PMs in the team.

**中文翻译:**
Miro 全球 12 个中心大约有 1800 名员工。具体到产品经理的人数，团队中有超过 450 名 PM。

---

### [00:17:34] Lenny

**English:**
Then how's the product team structured? Is it like outcome oriented? Is it product area oriented? Is it user persona oriented? Is it something else? How do you think about the structure of the product team?

**中文翻译:**
那么产品团队是如何构架的？是结果导向（outcome oriented）？产品领域导向（product area oriented）？还是用户角色导向（user persona oriented）？或者是别的什么？你是如何考虑产品团队结构的？

---

### [00:17:46] Varun Parmar

**English:**
Yeah, so I would say it's maybe a hybrid structure that we have, but the foundation of the team setup is around persona. We have what we refer to as streams, some companies refer to as domains, but essentially it's a set of individuals that are focused on solving the problems for a key persona. Just to give you an example, we have a stream that's focused on enterprise, and in enterprise we are looking at the IT admin persona, we're looking at the security persona or the compliance persona. There are a set of folks who are creating a roadmap and innovating for that audience. There's another stream which is called platform where we are going after the developer install base, folks that want to use Miro as a platform and build apps that they can actually make available either on the marketplace for everyone to use or they could be developers that are inside of a large organization and they're trying to integrate Miro with their specific use cases and workflows and business systems. That's another sort of stream that's focused on that, and there are a couple of other streams like that.

**中文翻译:**
是的，我想说我们采用的是一种混合结构，但团队设置的基础是围绕“角色”（persona）。我们称之为“流”（streams），有些公司称之为“领域”（domains），但本质上是一群专注于为核心角色解决问题的人。举个例子，我们有一个专注于“企业”（enterprise）的流，在企业领域，我们关注 IT 管理员角色、安全角色或合规角色。有一群人正在为这些受众制定路线图并进行创新。另一个流叫“平台”（platform），我们针对的是开发者群体，即那些想把 Miro 作为平台并构建应用的人，这些应用既可以发布在市场上供所有人使用，也可以是大型组织内部的开发者，试图将 Miro 与其特定的用例、工作流和业务系统集成。这是另一个专注于此的流，还有几个类似的流。

---

### [00:18:53] Varun Parmar

**English:**
Then finally there are some just horizontal sort of streams, if you will. We have a big focus given that we are a PLG-led company around growth and self-serve business. We've got a stream that's actually focused on our core internal infrastructure. We've got a stream that's actually focused on data science that's doing all of the magic that we started to release in terms of Miro AI, et cetera, et cetera. I would say it's a combination of those. At the heart of it is we are focused on personas and we are sort of aligning people around solving problems and creating value for that persona.

**中文翻译:**
最后，还有一些横向的流。鉴于我们是一家 PLG（产品驱动增长）主导的公司，我们非常关注增长和自助服务业务。我们有一个专门负责核心内部基础设施的流。我们还有一个专注于数据科学的流，负责我们开始发布的 Miro AI 等所有神奇的功能。我会说这是这些流的结合。核心在于我们专注于角色，并将人员对齐到为该角色解决问题和创造价值的目标上。

---

### [00:19:24] Lenny

**English:**
That is really interesting. One of the downsides of a persona-based approach I imagine is that features keep getting added that solve that user's pain points. What have you learned about keeping the product consistent and having a holistic perspective on the experience? How do you address Those challenges?

**中文翻译:**
这很有趣。我能想到基于角色的方法的一个缺点是，功能会不断增加以解决该用户的痛点。关于保持产品一致性和拥有整体体验视角，你学到了什么？你是如何应对这些挑战的？

---

### [00:19:43] Varun Parmar

**English:**
Architecturally, there are two sort of things that we have done that allow us to not pigeonhole ourselves into that specific way of working. I completely agree with you, you could lead to that. The first one is actually when we think about the product org, we call our org, it's called AMPED, A-M-P-E-D. This is actually going back to our earlier point, Lenny, we had around what's unique about the product culture, what's unique about Miro, and we talked about teams coming together, removing barriers or silos cross-functionally. AMPED stands for analytics, marketing, product, engineering and design. And everything that we do in the product org, when we say the product org, we actually don't meet product managers. We actually don't mean product managers, designers and engineers. What we mean by product org in Miro is this AMPED function. By having this cross-functional representation where product marketing team is deeply, deeply embedded inside of each of these streams, what we do is that we have different perspectives that come in where they say, "Oh, wait a second, did you think about the end user experience?"

**中文翻译:**
在架构上，我们做了两件事，让我们不会陷入那种特定的工作模式。我完全同意你的看法，确实可能会导致那种结果。第一件事是，当我们思考产品组织时，我们称之为 AMPED（A-M-P-E-D）。Lenny，这回到了我们之前讨论的关于 Miro 产品文化独特性的观点，即团队聚在一起，打破跨职能的障碍或孤岛。AMPED 代表分析（Analytics）、营销（Marketing）、产品（Product）、工程（Engineering）和设计（Design）。在 Miro，当我们说“产品组织”时，我们指的不是产品经理，也不是产品经理、设计师和工程师的组合，我们指的是这个 AMPED 职能。通过这种跨职能代表制，产品营销团队深度嵌入到每一个流中，我们引入了不同的视角，他们会问：“噢，等一下，你考虑过最终用户体验吗？”

---

### [00:20:49] Varun Parmar

**English:**
If you think about the end user experience, you know have someone on the team that says, "Wait a second, did you actually think about the enterprise requirements or what's needed in the largest corporation?" I think the unique setup of bringing these cross-functional folks allows us to sort of course correct. The second thing is the ways of working that we have. We have these product reviews that happen. We generally classify anything that we are doing in terms of its complexity around a small, medium or high complexity, and anything that's being worked on is actually being shared with the entire organization. If it's something that's small to medium, it's actually shared with the entire product org. In fact, if you are non-product, you can actually subscribe to that Slack channel as well. Everybody sees what the product org is working on, everybody sees what the core hypothesis is, "What is the solution for that, what is the proposed design for it, how are we thinking about the capabilities?"

**中文翻译:**
如果你只考虑最终用户体验，团队中会有人说：“等一下，你真的考虑过企业级需求或者大型公司需要什么吗？”我认为这种引入跨职能人员的独特设置让我们能够进行航向修正。第二件事是我们的工作方式。我们会进行产品评审。我们通常根据复杂程度将正在做的任何事情分为低、中、高三类，并且任何正在进行的工作都会与整个组织共享。如果是中低复杂度的项目，它会与整个产品组织共享。事实上，如果你不是产品部门的，你也可以订阅那个 Slack 频道。每个人都能看到产品组织在做什么，每个人都能看到核心假设是什么，“解决方案是什么，建议的设计是什么，我们如何考虑这些功能？”

---

### [00:21:49] Varun Parmar

**English:**
Then anything that's big actually goes through a formal process like a product review where there's a meeting and a bunch of us are in there and it's up to us, including the product leaders, to basically make sure that we are connecting the dots in terms of having a much more holistic perspective. I would say lastly, as Miro has sort of scaled the spectrum of companies all the way from a team that might have two or three people and might be taking out their credit card and using Miro for their own team all the way to a large corporation that might have 50,000, 80,000 employees, all of them are using Miro. We've come to realize that at some point the deep enterprise requirements need to be encapsulated in a set of requirements or best practices and we need to make sure that those get democratized across all of the feature teams.

**中文翻译:**
然后，任何重大的项目都会经过正式的流程，比如产品评审会议，我们一群人聚在一起，包括产品领导者在内，我们要确保能够“连接点滴”，从而拥有一个更整体的视角。最后我想说，随着 Miro 的规模覆盖了从两三个人刷信用卡为自己团队使用的初创团队，一直到拥有 5 万、8 万名员工且全员使用 Miro 的大型企业，我们意识到，在某些时候，深度的企业级需求需要被封装成一套需求或最佳实践，我们需要确保这些内容在所有功能团队中得到普及。

---

### [00:22:36] Varun Parmar

**English:**
When I'm thinking about building a new feature, I have a checklist in front of me where I can say, "Here are the 10 things that I need to think of that I need to incorporate early on in my thinking in the architecture, in the definition of the process, so that it doesn't come downstream." I would say that's an area where we're still working on and more recently we put more focus and energy and there's a product manager who's now leading that particular charter.

**中文翻译:**
当我考虑构建一个新功能时，我面前有一个清单，上面写着：“这是我在构思初期、架构设计和流程定义中需要考虑的 10 件事，这样后续就不会出问题。”我会说这是我们仍在努力的一个领域，最近我们投入了更多的精力和关注，现在有一位产品经理专门负责这一特定领域。

---

### [00:22:57] Lenny

**English:**
I love all these details. This AMPED structure, I love that. There's analytics, you said product marketing, analyst marketing and then product engineering design. It's rare that you see marketing as a part of teams, as a leadership, kind of part of the leadership group. Do you have a sense of what impact adding that had on the team or where that came from? Or is that just historically been something Miro has prioritized, marketing and product marketing?

**中文翻译:**
我喜欢这些细节。AMPED 结构太棒了。包括分析、产品营销、分析营销，然后是产品、工程和设计。很少见到营销作为团队的一部分，甚至作为领导层的一部分。你觉得加入这一项对团队产生了什么影响？或者这是从哪里演变而来的？还是说 Miro 历来就非常重视营销和产品营销？

---

### [00:23:25] Varun Parmar

**English:**
This was done before I got here and I wish I could take credit for it, but I can't. I think this was the result of an observation, which is quite similar to what you're saying, which is while we might be developing a lot of features and PMs or thinking bottoms-up in terms of what we are building, we might find that what we have built might not be able to capture the imagination of what we originally thought it would. A big part of that is how are you going to think about positioning, how are you going to think about competitive differentiation? How are you going to package it up so that the sellers that are out there are able to position it in a way that the customer, in this case the buyer, might be an IT professional, might a line business leader, can basically see the full vision of where we are going? I think by having product marketing as part of AMPED, we now bring that unique perspective that may be missing in certain teams.

**中文翻译:**
这是在我加入之前就定下的，我希望能揽功，但我不能。我认为这是观察的结果，和你说的很像：虽然我们可能开发了很多功能，PM 们也在自下而上地思考我们要构建什么，但我们可能会发现，我们构建的东西可能无法达到我们最初设想的效果。其中很大一部分原因在于：你如何考虑定位？你如何考虑竞争差异化？你如何进行包装，以便外面的销售人员能够以一种让客户（在这种情况下，买家可能是 IT 专业人士或业务线领导者）能够看到我们未来愿景的方式来进行定位？我认为通过将产品营销作为 AMPED 的一部分，我们现在引入了某些团队可能缺失的独特视角。

---

### [00:24:24] Varun Parmar

**English:**
PMs are more acting as product owners or more focused on core problem and solution but not thinking about positioning, because that's so important, especially when you're thinking about a market that we are increasingly in that there is competition there. That's one of the first things we started off with and that's top of mind for you as well, is that everything that we are doing has to be looked through that lens. One of the core philosophies that I have, Lenny, is that the success of a company is a direct relation of what the competition allows you to do. I feel like not many people talk about that, but in many cases in my professional career, and I've been at it for close to 24, 25 years, is that every single instance when I looked at a company accelerated their growth or there was a deceleration of growth, it was a direct relation to what the competition allowed you to do. Obviously, you have to do everything that you should be doing, but competition is the biggest variable that allows you to figure that out.

**中文翻译:**
PM 更多地扮演产品负责人的角色，或者更专注于核心问题和解决方案，但没有考虑定位。定位非常重要，尤其是当你考虑到我们所处的市场竞争日益激烈时。这是我们最先开始做的事情之一，也是你最关心的，即我们所做的一切都必须通过这个视角来看待。Lenny，我的核心哲学之一是：一家公司的成功与竞争对手允许你做的事情直接相关。我觉得没多少人谈论这一点，但在我近 24、25 年的职业生涯中，很多情况下，当我观察一家公司增长加速或减速时，这都与竞争对手允许你做的事情直接相关。显然，你必须做所有你应该做的事，但竞争是让你弄清楚这一点的最大变量。

---

### [00:25:24] Lenny

**English:**
I want to hear more about your core product philosophies, but let me dig into the one you just shared. What you find is that the way you grow or stop growing is often a direct result of your competition. Is there an example of that that comes to mind? I'm guessing maybe Box versus Dropbox is an experience you had there, or if not, what's an example of that that you've experienced, to make it a little more concrete even?

**中文翻译:**
我想听听更多关于你的核心产品哲学，但让我先深入探讨一下你刚才分享的那个。你发现增长或停止增长的方式往往是竞争的直接结果。你能想到什么例子吗？我猜 Box 对阵 Dropbox 可能是你经历过的一个例子，或者如果不是，你经历过的其他例子是什么？让它更具体一点。

---

### [00:25:50] Varun Parmar

**English:**
For those of us who've been in the collaboration space, and I've been doing collaboration and productivity apps for over 20 years, over two decades, at some point, you have companies like Microsoft that get really attracted to a space and you can see the trajectory of a business that's growing at a certain clip and then all of a sudden there's a competitive product that enters that has the might of distribution and the might of pricing, and that's just a direct example. I think I've seen that multiple times, first at Adobe where I was part of the document cloud business, clearly saw that at Box as well.

**中文翻译:**
对于我们这些在协作领域工作的人来说（我已经做协作和生产力应用超过 20 年了），在某些时候，你会遇到像微软这样的公司，他们对某个领域产生了浓厚的兴趣。你可以看到一个业务以一定的速度增长，然后突然间，一个拥有强大分发能力和定价能力的竞争产品进入了市场，这就是一个直接的例子。我想我见过很多次这种情况，首先是在 Adobe，当时我是文档云业务的一员，在 Box 也清楚地看到了这一点。

---

### [00:26:27] Varun Parmar

**English:**
I think you can, in general, sort of look at every single category and you can say that there was a category leader and they were growing at a certain clip or a certain pace and all of a sudden there were a bunch of entrants that get in and what happens to your growth rate? It's all dependent on how strong is the competitor in terms of providing a good enough solution? That's one. The second is how strong is the competition in terms of their distribution outreach? Then the third thing is how strong is the competition in terms of the pricing and packaging?

**中文翻译:**
我认为，总的来说，你可以观察每一个类别，你会发现曾经有一个类别领导者，他们以一定的速度增长，突然间有一群竞争者进入，你的增长率会发生什么变化？这完全取决于竞争对手在提供“足够好”的解决方案方面有多强。这是第一点。第二点是竞争对手在分发渠道方面有多强？第三点是竞争对手在定价和包装方面有多强？

---

### [00:26:55] Lenny

**English:**
I really like this discussion, especially because often the advice is, "Don't worry about the competition, just focus on the customer, it's going to be fine." Which what you're saying is that's not right, and I agree. What do you do with that in mind? How does that impact the way you build product or strategy? Is there some you could share that maybe tactically someone could leverage to how they're approaching their product strategy?

**中文翻译:**
我很喜欢这个讨论，特别是因为通常的建议是：“别担心竞争对手，只管关注客户，一切都会好起来的。”而你所说的是那并不正确，我同意。考虑到这一点，你会怎么做？这如何影响你构建产品或制定战略的方式？你有没有什么战术上的建议，可以让别人在制定产品战略时借鉴？

---

### [00:27:18] Varun Parmar

**English:**
It depends on who the competition is and what is their unfair advantage here. We talked about one specific competitor and I have a lot of respect for them, by the way, and I learn a lot from them every single day in terms of how they make bets and how they enter markets and stuff. At some point I'm going to write a book on them, I feel.

**中文翻译:**
这取决于竞争对手是谁，以及他们的“不公平优势”是什么。我们谈到了一个特定的竞争对手，顺便说一下，我非常尊重他们，每天都在学习他们如何下注、如何进入市场等等。我觉得总有一天我会写一本关于他们的书。

---

### [00:27:35] Lenny

**English:**
Ooh. We'll have to come back to talk about that.

**中文翻译:**
噢，那我们以后得专门回来聊聊这个。

---

### [00:27:38] Varun Parmar

**English:**
That's right, yeah. I think it sort of comes down to how do you think about your unique place relative to all of these players, and in your customer's mind are they able to clearly understand what is the unique value that you deliver relative to everything else? Part of that is the unique capabilities you provide. Part of that is how you're packaging those unique capabilities to them, and making sure that they in their mind can see how you coexist in this overall sort of tech ecosystem that they might be investing in, to enable their employees or to enable them to operate. So I think it's sort of looking at that from that lens, yeah.

**中文翻译:**
没错。我认为这归结为：相对于所有这些玩家，你如何思考自己的独特地位？在客户心中，他们能否清楚地理解你相对于其他所有产品所提供的独特价值？这部分源于你提供的独特功能，部分源于你如何向他们包装这些独特功能，并确保他们在脑海中能看到你如何共存于他们可能正在投资的整个技术生态系统中，从而赋能他们的员工或运营。所以，我认为应该从这个视角来看待。

---

### [00:28:26] Lenny

**English:**
Got it. So what I'm hearing is be very clear about your differentiator and continue to invest there and then make sure your positioning is clear around why you're... just identifying, "Here's why we're different and we're not just a better or worse version of this thing" or "Here's why we're different" and making sure that's really clear.

**中文翻译:**
明白了。所以我听到的是：要非常明确你的差异化因素并持续投资，然后确保你的定位清晰，明确指出“这就是我们不同的原因，我们不仅仅是这个东西的更好或更差的版本”，并确保这一点非常明确。

---

### [00:28:43] Varun Parmar

**English:**
Exactly. I think the other thing I would say, there's another core philosophy I have, which is products either get better over a period of time or they get worse. Products never remain the same. I think you can take that philosophy to a bunch of things in life, but I'm going to take the lens of products, which is my core philosophy is every single day, every single time somebody is pushing your code to production and you're releasing a feature or an enhancement, you are making the product better or you're making the product worse, but the products never remain same. The lens for this, Lenny, is actually from a customer's perspective, from the end user perspective. The thing is that if you are a player where there's no one else in the market, that's one thing, so that's great. Kudos to you for actually identifying a blue ocean strategy and sort of executing to that. But most markets, most products, actually have either direct or indirect competitors that are available.

**中文翻译:**
没错。我想说的另一件事是，我还有另一个核心哲学：产品要么随着时间的推移变得更好，要么变得更差。产品永远不会保持不变。你可以把这个哲学应用到生活中的很多事情上，但我会从产品的视角来看。我的核心哲学是：每一天，每当有人将代码推送到生产环境，每当你发布一个功能或改进时，你都在让产品变得更好或更差，但产品永远不会保持不变。Lenny，这个视角实际上是从客户、从最终用户的角度出发的。如果你是市场上唯一的玩家，那是一回事，那太棒了，为你识别出蓝海战略并执行到位而喝彩。但大多数市场、大多数产品实际上都有直接或间接的竞争对手。

---

### [00:29:40] Varun Parmar

**English:**
From the customer's mind, you're doing something, the competitor is doing something, so in their mind they're looking at these products and they're looking at these companies and they're saying, "Which is better versus not?" So with every release that your competitor is making and every release that you're making, you're either making chess points, moves against them, positive points, or you're going negative. I think that framework, if you have in mind, it actually drives an insane amount of clarity in terms of what you're doing and what the impact is going to be. Because every single move that you're making, the customer has that sort of in their mind, if not explicitly, implicitly that they're actually comparing these things. I think it brings a level of focus in terms of where you need to invest and why you need to invest and why this is going to make those decisions.

**中文翻译:**
在客户看来，你在做一些事，竞争对手也在做一些事，所以他们在脑海中观察这些产品和公司，并问：“哪个更好？”因此，竞争对手的每一次发布和你自己的每一次发布，你要么是在针对他们得分，要么就是在失分。如果你脑子里有这个框架，它实际上会让你对自己在做什么以及会产生什么影响产生极大的清晰度。因为你做的每一个动作，客户在脑海中（如果不是显性地，也是隐性地）实际上都在进行比较。我认为这带来了一种专注力，让你知道需要在哪里投资、为什么要投资，以及为什么这些决定是正确的。

---

### [00:30:28] Varun Parmar

**English:**
I think it allows at least for product leaders to make some high quality decisions around the bets that they're making and how they're going to play out in terms of eventual once the dust settles and the market at large is going to say, "I'm going to standardize on something and now I feel I need to go get it for everyone." Or "This is the tool that I want to use for this particular use case." That all of these decisions that you are making ladder up to that final sort of play that you have to do in terms of the market consolidation that eventually happens.

**中文翻译:**
我认为这至少能让产品领导者围绕他们所做的赌注做出一些高质量的决策，并思考当尘埃落定、大市场说“我要在某件事上标准化，现在我觉得我需要为每个人都买这个”或者“这就是我想用于这个特定用例的工具”时，这些赌注将如何发挥作用。你所做的所有这些决定最终都会汇聚到那个最终的博弈中，即最终发生的市场整合。

---

### [00:30:59] Lenny

**English:**
This is so interesting. Essentially what you're saying is that you find that being very close to and understanding the competition really well is really essential, versus this kind of the other end of the spectrum almost from just like, "Don't worry about the competition, don't pay attention." I like this point, metaphor of just like, "Are we moving ahead or further behind?" Is that where you operationalize that to track that? Then also just how do you not over-obsess with, "Let's just catch up, get more features," that kind of thing? How do you find that balance?

**中文翻译:**
这太有趣了。本质上你是在说，非常贴近并深入了解竞争对手是至关重要的，这几乎与那种“别担心竞争，别关注它”的观点截然相反。我喜欢这个比喻：“我们是在前进还是在落后？”你是通过这种方式将其操作化并进行跟踪的吗？另外，你如何避免过度痴迷于“让我们赶快追赶，增加更多功能”这类事情？你如何找到那个平衡点？

---

### [00:31:28] Varun Parmar

**English:**
I'll be honest, I don't think we've figured it out. We haven't cracked the nut in terms of how to operationalize this, but I know you are way smarter than me on some of these things, so maybe we can-

**中文翻译:**
老实说，我不认为我们已经完全弄清楚了。在如何将其操作化方面，我们还没有攻克这个难题，但我知道你在这些事情上比我聪明得多，所以也许我们可以——

---

### [00:31:39] Lenny

**English:**
Unlikely.

**中文翻译:**
不太可能。

---

### [00:31:39] Varun Parmar

**English:**
... partner on this and come up with something.

**中文翻译:**
……在这方面合作，想出点办法。

---

### [00:31:43] Lenny

**English:**
All right, that'll be something we work on. Any other product philosophies that you want to share? That was awesome.

**中文翻译:**
好，那是我们可以努力的方向。还有其他想分享的产品哲学吗？刚才那个很棒。

---

### [00:31:52] Varun Parmar

**English:**
This is all sort of related to it. It's like a string of pearls. I think there's maybe one more pearl we can actually thread into the needle right here.

**中文翻译:**
这些都是相关的。就像一串珍珠。我想也许我们现在可以再穿上一颗珍珠。

---

### [00:31:59] Lenny

**English:**
Let's do it.

**中文翻译:**
来吧。

---

### [00:32:00] Varun Parmar

**English:**
Which is we talked about how do you ladder this up and stuff, and then the question is, okay, how do you know that everything that you're doing, is that in the right direction or not? Should you move slow and be much more mindful about the things that you're doing or should you move fast and make certain bets and then decide certain things and stuff? I think there are two views that are out there. My personal perspective on this is that what you want to do is that you want to be the first one to hit the brick wall. This is particularly true when you are in a market that is competitive. The reason for that is that if you consider yourself as an innovation-centric company and you believe that you are building experiences that fundamentally don't exist anywhere else and you're sort of paving the way for the rest of the folks to basically get inspired with how you are building these experiences, speed is the single biggest determinant, in my experience, in terms of who ends up being more successful versus not.

**中文翻译:**
我们谈到了如何将这些事情串联起来，接下来的问题是：你如何知道你所做的一切是否方向正确？你应该慢下来，更谨慎地对待你所做的事情，还是应该快速行动，进行某些赌注，然后决定某些事情？我认为目前有两种观点。我个人的看法是：你想要做的是成为“第一个撞上砖墙的人”。当你处于一个竞争激烈的市场时，这一点尤为正确。原因在于，如果你认为自己是一家以创新为中心的公司，并且相信你正在构建根本不存在于其他任何地方的体验，并且你正在为其他人铺路，让他们从你构建这些体验的方式中获得灵感，那么根据我的经验，速度是决定谁最终更成功的最大因素。

---

### [00:33:14] Varun Parmar

**English:**
I don't know, maybe this is a little bit controversial where people say, Go slow to actually go fast." I think I have a lot of respect for that and there's certain areas you should do that, but when you are trying to figure out new experiences and stuff and you don't know if it's going to resonate or not, speed is something that you should accelerate for the organization. I think Frank Slootman talks about this a lot in his book and how can you accelerate? I think for me from a product perspective, the fundamental concept is can you be the first one to hit the brick wall where you have the learning faster than anyone else in the market so that you can decide, "Oh my god, the path that I was going was not the right path. I need to do 10 degrees west or I need to do 30 degrees east." I think as long as you're one or two or three steps ahead of everyone else in terms of uncovering or discovering those insights, then I think you can continue to be ahead of the pack in terms of building your product in business.

**中文翻译:**
我不知道，也许这有点争议，人们常说“欲速则不达（Go slow to actually go fast）”。我非常尊重这一点，在某些领域你应该这样做，但当你试图摸索新体验，并且不知道它是否会引起共鸣时，速度是你应该为组织加速的东西。我认为 Frank Slootman 在他的书中经常谈到这一点，以及你如何加速。对我来说，从产品的角度来看，核心概念是：你能不能成为第一个撞上砖墙的人，从而比市场上任何人都更快地获得教训，这样你就可以决定，“天哪，我走的路不对。我需要向西转 10 度，或者向东转 30 度。”我认为，只要你在揭示或发现这些洞察方面领先于其他人一两步或三步，那么在构建产品和业务方面，你就能继续保持领先地位。

---

### [00:34:21] Lenny

**English:**
You're talking about urgency. I've never met a founder or a product leader who doesn't want their team to move faster. They're always encouraging their team, "How do we move faster?" I'm curious if there's something you've learned tactically about helping your team move more quickly. You mentioned Frank Slootman's book. Amp It Up is what it's called, by the way, in case folks want to check it out and he's big on just like creating a sense of urgency, constant urgency, and we'll link to that and share notes. But yeah, what have you found helps create urgency and generally helps your teams move faster other than just like, "Move faster, everyone"?

**中文翻译:**
你谈论的是紧迫感。我从未见过哪个创始人或产品领导者不希望自己的团队行动得更快。他们总是鼓励团队：“我们如何才能行动得更快？”我很好奇，在帮助团队更快行动方面，你是否学到了什么战术上的东西。你提到了 Frank Slootman 的书，顺便说一下，那本书叫《Amp It Up》，如果大家想看的话可以去查一下，他非常推崇创造一种紧迫感，一种持续的紧迫感，我们会附上链接并分享笔记。但是，除了说“大家快点”之外，你发现还有什么能帮助创造紧迫感并让团队整体行动得更快？

---

### [00:34:52] Varun Parmar

**English:**
My fundamental belief here, Lenny, is that every product manager... I can talk to product managers because there is reason certain ones, someone wants to be a product manager, because in my view it's one of the most thankless jobs, like you get to do a lot of [inaudible 00:35:10] and it's like, "Why you have to do this?" But it attracts a certain personality and that personality is driven by challenge and that personality wants to prove that they can solve this challenge and do something amazing. I think fundamentally the product persona actually wants to move fast. I think the reason why in some cases we are not able to move fast is because of roadblocks that we run into and those roadblocks can manifest themselves into technical challenges, they can manifest them in cells of organizational challenges, they could be priority challenges and so on and so forth.

**中文翻译:**
Lenny，我的基本信念是，每一个产品经理……我可以和产品经理们聊聊，因为某人想成为产品经理是有原因的。在我看来，这是最吃力不讨好的工作之一，你得做很多杂事，人们会问：“你为什么要干这个？”但它吸引了某种特定性格的人，这种性格是由挑战驱动的，这种性格想要证明他们可以解决这个挑战并做出一些了不起的事情。我认为从根本上说，产品人的特质实际上是想要快速行动的。我认为在某些情况下我们无法快速行动的原因是我们遇到了障碍，这些障碍可能表现为技术挑战、组织挑战、优先级挑战等等。

---

### [00:35:52] Varun Parmar

**English:**
My fundamental approach to solving that is to ensure that the product leads who are working on these capabilities can instantly raise their hand and call out that there are challenges that they are running into. Then the job of the leadership team, the product management team, is to essentially go and quickly resolve those issues. I think if you are able to resolve those issues, then what it does is it actually starts a virtuous cycle where you can actually start to see those wins. Once you see those wins, you actually create that courage to do more things. Maybe because you've seen how that specific roadblock was solved and you have a pattern matching that you've developed now, you can solve a lot of those things on your own and it's the next level of challenge that you now going to raise your hand.

**中文翻译:**
我解决这个问题的基本方法是确保负责这些功能的产品负责人能够立即举手，指出他们遇到的挑战。然后，领导团队和产品管理团队的工作就是去快速解决这些问题。我认为，如果你能够解决这些问题，它实际上就会开启一个良性循环，让你开始看到那些胜利。一旦你看到了胜利，你就会产生做更多事情的勇气。也许是因为你已经看到了那个特定的障碍是如何被解决的，你现在已经形成了一种模式匹配，你可以靠自己解决很多这类问题，然后你会为下一个级别的挑战再次举手。

---

### [00:36:41] Varun Parmar

**English:**
What that does is it starts to build this organizational competency in terms of how you can figure out what to build. We all find these people in our organizations where there's someone somehow is able to do certain things in one-tenth the time that it would take a normal person. It's not that they are 10 times faster, it's just that in my observation that they've figured out which part of the core base they should build in versus not, who should be part of their team and who should not be, how they need to define that from a scope perspective, what does success look like, and it's the architecture of bringing all of these things together that actually brings that magic formula line in terms of "Hey, we are able to deliver faster."

**中文翻译:**
这样做会开始建立一种组织能力，即如何弄清楚该构建什么。我们都会在组织中发现这样的人：某人不知何故能够用普通人十分之一的时间完成某些事情。并不是说他们快 10 倍，只是根据我的观察，他们弄清楚了应该在核心库的哪一部分构建，哪些人应该加入团队，哪些人不应该，他们如何从范围的角度定义任务，成功是什么样子的。正是这种将所有这些因素结合在一起的架构，才带来了“嘿，我们能够交付得更快”的神奇公式。

---

### [00:37:19] Lenny

**English:**
I really like this topic. What I'm hearing is one of the biggest roots of slowdown in a company and product development is blockers not being unblocked, and I always feel the same thing. I feel like a PM's number one job is to unblock their team because their job is basically make the most out of their team that they're marshaling towards some outcome. The way you do that is just figure out what's slowing them down. You just talked about this idea of a PM raises their hand to leadership, "Hey, we're blocked by this thing." Is there a process you've come up with there that helps you do that, it's connected to-

**中文翻译:**
我很喜欢这个话题。我听到的是，公司和产品开发变慢的最大根源之一是障碍没有被清除，我一直有同感。我觉得 PM 的头号工作就是为团队扫清障碍，因为他们的工作本质上是让正在朝着某个目标前进的团队发挥出最大的效能。而做到这一点的方法就是弄清楚是什么减慢了他们的速度。你刚才谈到了 PM 向领导层举手说“嘿，我们被这件事卡住了”的想法。你有没有想出什么流程来帮助实现这一点？它是否连接到——

---

### [00:37:51] Varun Parmar

**English:**
Yeah, I would say we are trying to sort of systematically ingrain this in the culture of the organization. We have a motto in the product org, it's very simple, single sentence, deliver customer value faster with high quality. That's it. Everything that we do, and when I say everything, everything, Lenny, from performance and reward system and measurements, everything is based on this one single statement and it has three attributes. The first one is deliver customer value, and we believe customer value is only delivered when customers use it. Anytime as a PM at Miro, when you ship something, we are looking at, "Well, what was the metric you were going to move and how much did it move?" We have some original targets that we can go back to. That's the first aspect of what we're doing, deliver customer value.

**中文翻译:**
是的，我想说我们正试图系统地将这一点植入组织的文化中。我们在产品组织中有一个座右铭，非常简单，只有一句话：以高质量更快地交付客户价值。就这一句。我们所做的一切，Lenny，我说的是一切，从绩效和奖励制度到衡量标准，一切都基于这一句话，它包含三个属性。第一个是“交付客户价值”，我们相信只有当客户使用它时，客户价值才算交付。在 Miro，每当 PM 发布某些东西时，我们都会看：“你要移动的指标是什么，它移动了多少？”我们有一些可以追溯的原始目标。这是我们工作的第一个方面：交付客户价值。

---

### [00:38:35] Varun Parmar

**English:**
The second one is move faster, and there are certain cycle times that we are measuring across the organization. From the time you came up with the idea to the time that you actually pitched a solution to the time you actually shipped it, to the time we actually moved the metric, it's information that has been collected and is being made available to the organization. You can say, "Hey, if it was a small, medium or large, what's the average? What's the medium, what's the variance?" And you can say, "Hey, looking at this data, what can be improved?" That's on the faster aspect of it. Then the last one is around high quality, which is we want to build best in class collaboration experiences, so we are always getting inspired by what we find in applications and experiences that we see around us and we are saying, "Hey, when it comes to designing, sharing flows, we believe that these are the three apps that have best in class sharing flows when it comes to designing some synchronous capabilities like this. These are the best in class apps that we should look at."

**中文翻译:**
第二个是“行动更快”，我们在整个组织中衡量某些周期时间（cycle times）。从你产生想法，到你实际提出解决方案，到你实际发布，再到我们实际移动指标的时间，这些信息都被收集起来并提供给组织。你可以说：“嘿，如果是小型、中型或大型项目，平均值是多少？中位数是多少，方差是多少？”你可以说：“嘿，看看这些数据，哪些地方可以改进？”这是关于“更快”的方面。最后一个是关于“高质量”，我们想要构建一流的协作体验，所以我们总是从周围的应用和体验中汲取灵感，我们会说：“嘿，在设计分享流程时，我们认为这三款应用拥有一流的分享流程；在设计这类同步功能时，这些是我们应该参考的一流应用。”

---

### [00:39:31] Varun Parmar

**English:**
We are always trying to make sure that we are benchmarking ourselves against that and we have our design team. On a regular basis, like when we ship stuff on a monthly basis, our design leadership team does a triage of everything that got shipped into high quality or not high quality. It's just like a binary function, and we're doing that and we're saying, "Hey, the reason why we believe it's not high quality is because A, B, C, D, E and we're making it available to other designers so they can actually start to build that telemetry in terms of some things are more subjective." But you can start to see some patent matching and say like, "Hey, this is what great looks like."

**中文翻译:**
我们总是试图确保以此为基准。我们有设计团队，在定期（比如每月发布东西时），我们的设计领导团队会对所有发布的东西进行分类（triage）：高质量或非高质量。这就像一个二元函数，我们这样做并说：“嘿，我们认为它质量不高的原因是 A、B、C、D、E”，我们将这些反馈提供给其他设计师，这样他们就可以开始建立那种遥测感（telemetry），尽管有些东西比较主观。但你可以开始看到一些模式匹配，并说：“嘿，这就是优秀的样子。”

---

### [00:40:06] Lenny (Sponsorship Message)

**English:**
This episode is brought to you by Linear. Let's be honest, the issue tracker that you're using today isn't very helpful. Why is it that always seems to be working against you instead of working for you? Why does it feel like such a chore to use? Well, Linear is different. It's incredibly fast, beautifully designed, and it comes with powerful workflows that streamline your entire product development process, from issue tracking all the way to managing product roadmaps. Linear's designed for the way modern software teams work. What users love about linear are the powerful keyboard shortcuts, efficient GitHub integrations, cycles that actually create progress, and built-in project updates that keep everyone in sync. In short, it just works. Linear is the default tool of choice among startups and it powers a wide range of large established companies such as Vercel, Retool and Cash App. See for yourself why product teams describe using linear as magical. Visit linear.app/lenny to try Linear for free with your team and get 25% off when you upgrade. That's linear.app/lenny.

**中文翻译:**
本期节目由 Linear 赞助。坦白说，你今天使用的工单追踪工具（issue tracker）可能并不好用。为什么它总是感觉在和你作对，而不是在帮你？为什么用起来感觉像是在做苦差事？Linear 则不同。它速度极快，设计精美，并配有强大的工作流，可以简化你的整个产品开发流程，从工单追踪一直到管理产品路线图。Linear 是为现代软件团队的工作方式而设计的。用户喜爱 Linear 的原因包括强大的键盘快捷键、高效的 GitHub 集成、真正能推动进度的周期（cycles），以及让每个人保持同步的内置项目更新。简而言之，它就是好用。Linear 是初创公司的默认首选工具，它也为 Vercel、Retool 和 Cash App 等众多大型成熟公司提供支持。亲自去看看为什么产品团队将使用 Linear 描述为“神奇”。访问 linear.app/lenny 免费试用，升级时可享受 25% 的折扣。

---

### [00:41:15] Lenny

**English:**
Okay, so every month or so the design team looks at everything that's shipped and puts things into a bucket. Either this is... It's like a binary thing, high quality or not high quality.

**中文翻译:**
好的，所以大约每个月，设计团队会查看所有发布的东西，并将它们归类。这就像一个二元选择：高质量或非高质量。

---

### [00:41:24] Varun Parmar

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:41:24] Lenny

**English:**
Wow, that is so cool. Then, one, what do they do with that? Do they send it out to the product team? Then two, is this just like FYI or is it like, "We need to fix all these low quality things going back"? Or is it more just like, "For the future, please be aware these are not high quality"?

**中文翻译:**
哇，这太酷了。那么，第一，他们拿这些结果做什么？会发给产品团队吗？第二，这只是一个“供参考（FYI）”，还是说“我们需要回头修复所有这些低质量的东西”？或者更多只是“以后请注意，这些不属于高质量”？

---

### [00:41:39] Varun Parmar

**English:**
Yeah, so it's actually both. Generally what happens is that the design leadership team is doing this and there's one particular design leader who's the designated person to make sure that this is happening on a regular basis. Right now the way we're using it is that we are actually using it to calibrate and align around the design leadership around what we mean by high quality. Because it's one of those things, it's like if you've never seen colors and I ask you, "Lenny, describe pink and compare that to red," and if you haven't seen colors, how do you describe colors? You can't. But if I show you and I say, "Lenny, these are three examples of what pink is and these are three examples of red is," then you're like, "Oh, I get pink and I get red." There are certain things that you just like when you write it's very, very hard to describe it, but if you show specific examples, it's very clear, "Oh, I get it. I get how pink is different than red." But if I try to describe it, it's going to be very hard.

**中文翻译:**
是的，实际上两者都有。通常情况是设计领导团队在做这件事，有一位特定的设计领导者被指定负责确保这件事定期发生。目前我们的使用方式是，利用它在设计领导层之间进行校准和对齐，明确我们所说的“高质量”到底是什么意思。因为这就像是，如果你从未见过颜色，而我让你“Lenny，描述一下粉红色并将其与红色进行比较”，如果你没见过颜色，你怎么描述？你做不到。但如果我展示给你看，说：“Lenny，这是三个粉红色的例子，这是三个红色的例子”，你就会说：“噢，我明白什么是粉红，什么是红了。”有些东西当你写下来时很难描述，但如果你展示具体的例子，就会非常清晰：“噢，我懂了。我明白粉红和红的区别了。”但如果我试图用语言描述，那会非常困难。

---

### [00:42:35] Varun Parmar

**English:**
So we got into these endless conversations at some point about a year ago where we were saying, "We need high quality, we need high quality." And people are like, "Let's just go and define this thing." We had a bunch of our leaders go and write documents, really long documents in terms of what are the attributes and how do we define those attributes and how do we measure those attributes and how do we enable people to do that? It felt like it's a good thing because we are trying to codify it, but it also felt like it was a very heavy way of solving that problem. Then we just came up with this approach, which is like, "What's great versus not great" and just start classifying it. As you know, it's like modern AI systems are classification systems and we [inaudible 00:43:12]-

**中文翻译:**
大约一年前，我们陷入了无休止的争论，我们一直在说：“我们需要高质量，我们需要高质量。”然后人们说：“那我们就去定义这个东西吧。”我们让一群领导者去写文档，写了非常长的文档，关于属性是什么、如何定义这些属性、如何衡量这些属性以及如何赋能人们去实现。感觉这是一件好事，因为我们在尝试将其规范化，但也感觉这是一种非常沉重的解决问题的方式。然后我们就想出了这个方法，即“什么是优秀的 vs 什么是不优秀的”，并开始进行分类。如你所知，现代 AI 系统本质上就是分类系统，而我们——

---

### [00:43:12] Lenny

**English:**
Yeah, I was going to say, sounds like reinforcement learning approach here.

**中文翻译:**
是的，我正想说，这听起来像是强化学习的方法。

---

### [00:43:14] Varun Parmar

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:43:14] Lenny

**English:**
Defining cost.

**中文翻译:**
定义成本。

---

### [00:43:15] Varun Parmar

**English:**
That's right. That's right. I think it's worked decently well. I would say with most things we need to operationalize it and we need to make sure that now we are democratizing it and everybody has access to it and so on and so forth. But I think it's been a good start and now we are sharing this more openly with others in the org.

**中文翻译:**
没错。我认为这运作得相当不错。我会说，对于大多数事情，我们需要将其操作化，并确保现在我们正在将其普及化（democratizing），让每个人都能访问它等等。但我认为这是一个很好的开始，现在我们正在更公开地与组织中的其他人分享。

---

### [00:43:37] Lenny

**English:**
When I said that, I imagined you... From the outside, you have a very unique culture and approach your product. That's a great example of that. I've never heard of a process like this. What I'm hearing is essentially you're trying to build the muscle within the organization of what is quality. It's like this continued heuristic of, "Okay, I get it." So PMs on the team start to understand in their head what that means.

**中文翻译:**
当我听到这个时，我心想……从外部看，你们拥有一种非常独特的文化和产品方法。这就是一个很好的例子。我从未听说过这样的流程。我听到的是，本质上你们是在组织内部建立一种关于“什么是质量”的肌肉记忆。这就像是一种持续的启发式学习，“噢，我懂了”。这样团队中的 PM 们就开始在脑海中理解那意味着什么。

---

### [00:43:56] Varun Parmar

**English:**
Right.

**中文翻译:**
对。

---

### [00:43:57] Lenny

**English:**
Super cool. You also talked about, in the middle part of that sentence, of moving faster and that you track and measure that somehow. Can you talk more about that? Because that's something every product team is always trying to understand. "How do we know if we're going faster, if we're going as fast as we could?" How do you actually do that? How do you measure these things?

**中文翻译:**
超级酷。你刚才还提到了“行动更快”，并且你们以某种方式对其进行跟踪和衡量。你能多谈谈这一点吗？因为这是每个产品团队都想了解的事情。“我们怎么知道自己是否变快了，是否已经达到了最快速度？”你具体是怎么做的？如何衡量这些事情？

---

### [00:44:13] Varun Parmar

**English:**
The core philosophy there is velocity is more like the game of golf where you're just playing against yourself. It's not like if Lenny and Varun are out at the golf course, it doesn't matter. I'm not competing against you, I'm just competing against myself because that's the only... I'm going to just hit the ball, so it's like how much better can we get? I think our core philosophies around that and what we're trying to do is that on all the product teams, the feature teams that we have, we're just collecting all the information and we are making it available to everyone so that they can actually see what the cycle times are. What we are interested in is from the time that you have an insight, from the time you believe "I can do something unique for my user, for my persona," how long does it take for you to actually deliver that value?

**中文翻译:**
核心哲学是：速度更像是一场高尔夫球赛，你只是在和自己比赛。这不像 Lenny 和 Varun 在高尔夫球场上，谁赢谁输并不重要。我不是在和你竞争，我只是在和自己竞争，因为那是唯一的……我只是去击球，所以关键是我们能变得多好？我们的核心哲学围绕着这一点，我们正在做的是在所有的产品团队、功能团队中收集所有信息，并将其提供给每个人，这样他们就能看到周期时间是多少。我们感兴趣的是：从你获得洞察的那一刻起，从你相信“我可以为我的用户、我的角色做一些独特的事情”那一刻起，你实际交付那个价值需要多长时间？

---

### [00:45:04] Varun Parmar

**English:**
We have a product process that we follow, which starts with a P-strat, which is a strategy, and then we go into P0, which is definition of the problem, then we go into P1, which is definition of the solution, and then we go into P2, which is once the solution is shipped, are we hitting the metrics that we originally had defined upfront before we decided to work on this. You have all of these stage gates and then we basically classify everything that we are doing in small, medium, large. You can go in and you can say, "Hey, I thought this was a small thing," and small thing is something you can get it done in less than a month, and so on and so forth. There are 50 other product teams that are shipping these features, and what's the average, what's the variance, what's the median?

**中文翻译:**
我们遵循一套产品流程，从 P-strat（战略）开始，然后进入 P0（问题定义），接着进入 P1（解决方案定义），最后进入 P2（一旦解决方案发布，我们是否达到了在决定做这件事之前预先定义的指标）。你有所有这些阶段关卡（stage gates），然后我们基本上将我们正在做的所有事情分为小型、中型、大型。你可以进去说：“嘿，我以为这是一件小事”，而小事是指你可以在不到一个月内完成的事情，以此类推。还有 50 个其他产品团队正在发布这些功能，平均值是多少，方差是多少，中位数是多少？

---

### [00:45:48] Varun Parmar

**English:**
"Oh, wait a second, actually it seems like I took way more time in the problem definition stage. Let me actually try to go talk to this other product team that actually did it much faster," or "Oh, I actually did it really, really fast, and the reason why I did it fast was because of this. Let me go share this out with the broader team." Usually the product ops function, we call it product excellence internal, sort of product excellence function, is recording some of these things. I would say getting reliable data, and then because we have some things that are going through meetings and there are some things that are going through Slack, we could do better on some of those dimensions, but all of this data is available and we provided it openly and folks can benchmark themselves against that.

**中文翻译:**
“噢，等一下，实际上我在问题定义阶段花的时间多得多。让我去和那个做得快得多的产品团队聊聊”，或者“噢，我实际上做得非常非常快，原因是因为这个。让我去和更广泛的团队分享一下。”通常产品运营职能（我们内部称之为产品卓越职能）会记录这些事情。我会说，获取可靠的数据，然后因为我们有些事情是通过会议进行的，有些是通过 Slack 进行的，我们在某些维度上可以做得更好，但所有这些数据都是可用的，我们公开提供这些数据，大家可以以此为基准进行自我衡量。

---

### [00:46:34] Lenny

**English:**
So cool. Okay, so you have this P-strat, you called it, document which is kind an initial concept and then it's interesting you use the P0, P1, which is often for bugs, but it's cool that you use it for defining your products. So P-strat is just an idea pitch. P0 is a spec, basically, like a one-pager for the product, and then P1 and P2 are basically getting to "Here's the actual product we're building." And you basically track time per step and map it to, "Here's how large this project should be." Over time you track per person, it sounds like, just like are you matching the benchmarks of how long a small project should take across each step?

**中文翻译:**
太酷了。好，所以你们有这个叫 P-strat 的文档，它有点像初始概念，有趣的是你们使用了 P0、P1，这通常用于 Bug 分级，但你们用它来定义产品，这很酷。所以 P-strat 只是一个创意提案（pitch）。P0 基本上是规格说明书（spec），就像产品的单页文档。然后 P1 和 P2 基本上是进入“这就是我们要构建的实际产品”阶段。你们基本上跟踪每一步的时间，并将其映射到“这个项目应该有多大”。听起来随着时间的推移，你们会跟踪到个人，看你是否符合“一个小项目在每一步应该花多长时间”的基准？

---

### [00:47:13] Varun Parmar

**English:**
Yeah, exactly.

**中文翻译:**
是的，没错。

---

### [00:47:14] Lenny

**English:**
Wow, that is extremely cool. Whatever templates you can share, these things that we can include in the show notes would be awesome.

**中文翻译:**
哇，这非常酷。如果你能分享任何模板，我们可以把它们放在节目笔记里，那就太棒了。

---

### [00:47:21] Varun Parmar

**English:**
Yes.

**中文翻译:**
好的。

---

### [00:47:22] Lenny

**English:**
Because people are always looking for just like, "Ah, I want do some of this stuff." If they can just plug and play, the more, the merrier.

**中文翻译:**
因为人们总是在寻找，“啊，我也想做这些事”。如果他们能直接即插即用，那就再好不过了。

---

### [00:47:28] Varun Parmar

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:47:29] Lenny

**English:**
Shifting a little bit, it sounds like you guys are doing Scrum in some form. Can you just talk about just broadly the product development process? How long you or your sprints, how long do you plan for in the future, in detail specifically just like high level, how does the product development process work?

**中文翻译:**
稍微换个话题，听起来你们在以某种形式运行 Scrum。你能大致谈谈产品开发流程吗？你们的 Sprint（冲刺）有多长？你们对未来的规划有多长？具体来说，从高层面上看，产品开发流程是如何运作的？

---

### [00:47:43] Varun Parmar

**English:**
There are certain things that I learned at Box and that inspired some things that we do at Miro, and there are certain things that we've evolved. One of the things that we've instituted is our roadmap process, so that's sort of the first thing around how the different teams are looking at the things that they're going to work on. We have a rolling six month roadmap, it seems large, but we've got, like I mentioned, a number of enterprise customers. If I've learned one thing that large enterprises is asking for a roadmap review. That tends to be my favorite meeting of sitting down with the enterprise leaders and walking through what we are working on. What we've done is we've tried to architect something which actually allows our customers to get what they're looking for, but at the same time does not remove the agility that is so important for us to deliver value faster.

**中文翻译:**
我在 Box 学到了一些东西，这些东西启发了我们在 Miro 做的一些事情，当然我们也演变出了一些新东西。我们建立的一项制度是路线图流程，这是不同团队审视他们将要开展的工作的第一步。我们有一个滚动的六个月路线图，看起来时间很长，但正如我提到的，我们有很多企业客户。如果说我学到了一件事，那就是大型企业总是要求进行路线图评审。那往往是我最喜欢的会议——与企业领导者坐在一起，梳理我们正在做的工作。我们所做的是尝试构建一种架构，既能让客户得到他们想要的信息，同时又不会消除对我们快速交付价值至关重要的敏捷性。

---

### [00:48:41] Varun Parmar

**English:**
What we do is we have a rolling six month roadmap that gets updated every three months and the first three months of that roadmap, we have a 80% position level, which means that 80% of the things that we claim to be on the roadmap will get done. That's the target. For the next three months, because it's six months, so the first three months is 80%, the next three months is 50%, so we have a much lower level of resolution in the next three months after that. What that allows the product teams to do is actually have flexibility, which is based on what the customers are asking for and based on what the competitive moves are, based on some technology breakthroughs that happen around large language models, they can pivot and they can pivot and move towards that and they won't get penalized either by the customer or internally in terms of doing that. That's what we do and that's all at on the backdrop of an annual strategy that we publish.

**中文翻译:**
我们做的是：拥有一个每三个月更新一次的滚动六个月路线图。在这个路线图的前三个月，我们有 80% 的确定性水平，这意味着我们声称在路线图上的事情有 80% 会完成。这是目标。对于接下来的三个月（因为总共是六个月），前三个月是 80%，后三个月是 50%，所以后三个月的清晰度要低得多。这让产品团队拥有了灵活性，可以根据客户的需求、竞争对手的动作，或者大语言模型等技术突破进行转型（pivot），他们可以转向这些方向，而不会因此受到客户或内部的惩罚。这就是我们的做法，而这一切都是在我们发布的年度战略背景下进行的。

---

### [00:49:34] Varun Parmar

**English:**
Every year we publish a strategy white paper that it gets published internally available to every single Mironeer across all functions that clearly articulates the key bets that we want to make. Why do we want to make those bets? What is the expected outcome and how does that ladder up into the overall business outcomes that we are trying to drive from an OKR perspective as well as the overall business strategy that we have. So people take that product strategy, white paper or artifact, and then against that they're building their roadmaps which get updated every three months. Then inside of the teams, we enable teams to be quite autonomous in terms of some of the rituals that they're doing. We want them to obviously embrace best practices. We've got a team of agile coaches that share best practices or are available to help if there's certain specific needs that teams have.

**中文翻译:**
每年我们都会发布一份战略白皮书，在内部面向所有职能部门的每一位 Mironeer 公开，清晰地阐述我们想要进行的重点赌注。我们为什么要进行这些赌注？预期的结果是什么？以及这些结果如何从 OKR 的角度以及我们的整体业务战略出发，汇聚到整体业务成果中。因此，人们拿着这份产品战略白皮书或成果物，据此构建他们每三个月更新一次的路线图。在团队内部，我们允许团队在执行某些仪式（rituals）方面保持相当大的自主权。我们显然希望他们采用最佳实践。我们有一支敏捷教练团队，他们会分享最佳实践，或者在团队有特定需求时提供帮助。

---

### [00:50:31] Varun Parmar

**English:**
Then I think on top of that, there are certain key, I would say, rituals that we do that maybe are unique. For example, we have something called as Miro Connect, which happens every other Friday. Every other Friday, for example, in our Amsterdam office, you can go in there and at 4:00 in the afternoon, 4:00 to 7:00 or 8:00, and sometimes it goes really late, you've got a bunch of product teams sitting around tables and it feels like, "Oh, it's like a pitch or something." And people are coming in, they're having a good time, you've got a drink in your hand, there's maybe some light music playing in the background and you're going from table to table and you have teams that are actually showing all the amazing work that... If done right, it happens once in a while, but if done right, it's magical in terms of the outcomes that you can get.

**中文翻译:**
此外，我认为我们还有一些独特的关键仪式。例如，我们有一个叫 Miro Connect 的活动，每隔一个周五举行一次。比如在我们的阿姆斯特丹办公室，每隔一个周五的下午 4 点到 7、8 点（有时会持续到很晚），你会看到一群产品团队围坐在桌子旁，感觉就像是在进行某种提案演示。人们走进来，玩得很开心，手里拿着饮料，背景里可能放着轻音乐，你从一张桌子走到另一张桌子，团队正在展示他们所做的了不起的工作……如果做得好（虽然只是偶尔发生），它在产出结果方面简直是神奇的。

---

### [00:51:20] Varun Parmar

**English:**
I'll tell you, there was a team that actually was presenting at our Berlin hub and they were saying, "We're working on this feature, and there's an engineer who walks over to that desk and says, 'What are you working on?'" The team describes it, "Oh, we are trying to do something like this." And this engineer had actually worked on that particular problem in their prior life, literally they had implemented this. So he says, "So how are you going to implement this?" And the team, the engineer that's sitting there, says, "This is the approach I'm going to take and it's going to take me three months." He's like, "Oh, would you mind if I go and help you with this?" They're like, "Sure, more the merrier. Go ahead." So this person puts down their beer and says, "Okay, I'm having a good time. Let me just head back to my home." And in the next three or four hours goes and codes the entire thing, makes a poll request.

**中文翻译:**
我给你讲个故事，有一个团队在我们的柏林中心进行演示，他们说：“我们正在开发这个功能。”这时有一位工程师走到那张桌子旁问：“你们在做什么？”团队描述道：“噢，我们正尝试做这样一个东西。”而这位工程师在之前的工作中实际上处理过这个特定问题，字面意义上他曾经实现过这个功能。于是他问：“那你们打算怎么实现它？”坐在那里的团队工程师说：“这是我打算采取的方法，大概需要三个月时间。”他说：“噢，介意我帮你们弄一下吗？”他们说：“当然，人多力量大，请便。”于是这个人放下啤酒说：“好，我玩得很开心，我现在回家弄一下。”在接下来的三四个小时里，他编写了整个功能的代码，并提交了一个 Pull Request（合并请求）。

---

### [00:52:10] Varun Parmar

**English:**
Next day in the morning one of the engineers from this core team that was exhibiting at Miro Connect looks at the poll request, reviews the code and says, "Yes, something that would have taken three months for this core team because they didn't have the expertise literally got done in three hours because there was another engineer that ran into them and said, "I know how this is done. I can actually help you here," and went ahead and did the right thing. We are trying to create these magic moments. It happens once in a while, but we have one success story and I like to tell that in every opportunity that I get. But that's another sort of unique thing that we've done in terms of book-ending things around how we operate here.

**中文翻译:**
第二天早上，在 Miro Connect 上展示的那个核心团队的一名工程师看到了 Pull Request，审查了代码并说：“天哪，对于这个核心团队来说，因为缺乏专业知识原本需要三个月才能完成的工作，竟然在三小时内就完成了。因为另一位工程师偶遇了他们并说‘我知道怎么做，我可以帮你们’，然后就动手做好了。”我们正努力创造这些神奇时刻。虽然只是偶尔发生，但我们有这样一个成功案例，我喜欢在每一个机会中讲述它。这是我们在运营方式上的另一个独特之处。

---

### [00:52:50] Lenny

**English:**
That story is like a dream for any PM. Just imagine saving months of work with one conversation. I imagine people were like, "How do we replicate this often?" I love that. With these meetings, just to understand, if their team is in Berlin, let's say, there's a screen there in front of a table and they're talking through a screen, like a video conference?

**中文翻译:**
这个故事对任何 PM 来说都像梦一样。想象一下，通过一次谈话就节省了几个月的工作量。我猜人们肯定在想：“我们如何经常复制这种成功？”我喜欢这个。关于这些会议，我想了解一下，如果团队在柏林，桌子前会有一个屏幕，他们是通过屏幕交谈吗，就像视频会议那样？

---

### [00:53:12] Varun Parmar

**English:**
Yeah. I mean, right now what we've figured out is that it is really hard to do these events over audio-video conferencing and stuff. So generally what happens is that you have an audio-video bridge that's playing, but mostly it's people walking up to the respective teams and then having a live conversation. That's usually how these things are operated. Yeah.

**中文翻译:**
是的。我的意思是，目前我们发现通过音视频会议来举办这类活动非常困难。所以通常情况是，会有一个音视频连接桥接各处，但主要是人们走到各自的团队面前进行面对面的交流。这通常是这些活动的运作方式。

---

### [00:53:34] Lenny

**English:**
Got it. Okay, so you have six month rolling roadmaps. You have a yearly vision strategy for the company, two week sprints. Is there also a quarterly OKR sort of process or is it-

**中文翻译:**
明白了。好，所以你们有六个月的滚动路线图，有公司的年度愿景战略，有两周一次的 Sprint。是否还有季度的 OKR 流程，还是说——

---

### [00:53:48] Varun Parmar

**English:**
Yeah.

**中文翻译:**
有的。

---

### [00:53:48] Lenny

**English:**
... those or not? There is, okay.

**中文翻译:**
……没有？有的，好的。

---

### [00:53:49] Varun Parmar

**English:**
There is, yeah.

**中文翻译:**
有的，没错。

---

### [00:53:51] Varun Parmar

**English:**
Yes, yes, yes. At Miro, we practice OKRs and it starts off at the company level, and then those company level OKRs are taken by the AMPED organization. Like we describe, it's the AMPED organization, and then we break it up and I would say we have refined it over the period of time, the two years that I've been at Miro. Early on we were doing OKRs on a quarterly basis, and I would say more recently we've actually evolved to six month KRs. What we found was that six month was the right cadence in terms of giving enough time for teams to basically push forward in executing these KRS and minimizing the "overhead" of doing replan every single quarter. We found that it was much more effective and efficient for the entire organization to do it on a six-month basis. However, we are doing traction on a monthly basis. So every four weeks, as AMPED, we are looking at our KRS for the AMPED organization on a monthly basis doing traction. However, the planning, the targets, are done on a six-month basis.

**中文翻译:**
是的。在 Miro，我们践行 OKR，它从公司层面开始，然后由 AMPED 组织承接这些公司级 OKR。就像我们描述的，它是 AMPED 组织，然后我们将其拆解。在我加入 Miro 的这两年里，我们不断对其进行完善。早期我们是按季度进行 OKR 的，而最近我们实际上演变为六个月一次的 KR（关键结果）。我们发现，六个月是一个合适的节奏，既能给团队足够的时间去推进这些 KR 的执行，又能最大限度地减少每个季度重新规划的“管理开销”。我们发现，对于整个组织来说，以六个月为周期进行规划更加有效且高效。不过，我们每月都会进行进度跟踪（traction）。因此，作为 AMPED，我们每四周会查看一次 AMPED 组织的 KR 进度。但是，规划和目标的设定是每六个月进行一次。

---

### [00:55:06] Lenny

**English:**
I love how OKRs could just be anything, could be every six months, could have objectives, could have key results. It's just such a term that just applies to anything that people do with goals, basically.

**中文翻译:**
我喜欢 OKR 可以是任何形式，可以是每六个月一次，可以有目标，可以有关键结果。它基本上就是一个适用于人们处理目标的任何事情的术语。

---

### [00:55:17] Varun Parmar

**English:**
That's true.

**中文翻译:**
确实如此。

---

### [00:55:18] Lenny

**English:**
And it works. It's great.

**中文翻译:**
而且它很有效，非常棒。

---

### [00:55:19] Varun Parmar

**English:**
That is so true.

**中文翻译:**
太对了。

---

### [00:55:21] Lenny

**English:**
Again, if there's any templates that your team could share of the way you do that stuff, that would be amazing, and we'll include that in the show notes.

**中文翻译:**
再次强调，如果你们团队能分享任何关于你们如何做这些事情的模板，那就太棒了，我们会把它们包含在节目笔记中。

---

### [00:55:27] Varun Parmar

**English:**
Yeah, absolutely. Because I think, as you would expect, we run Miro on Miro, so there's a lot of things that we could share as templates in terms of how we are running things on Miro, not just as OKRs, but in terms of product reviews. We have ways of how we are doing asynchronous reviews combined with synchronous reviews and there's this blended experiences that we have, and so we can definitely share out with the community how we do some of these things.

**中文翻译:**
没问题。因为正如你所料，我们在 Miro 上运行 Miro，所以有很多东西我们可以作为模板分享，关于我们如何在 Miro 上运行业务，不仅是 OKR，还有产品评审。我们有结合异步评审和同步评审的方法，这是一种混合体验，我们绝对可以向社区分享我们是如何做这些事情的。

---

### [00:55:55] Lenny

**English:**
Awesome. That's a great segue to another question I was going to ask is just what other tools, what's in the stack of the product team's workflow? So Miro, obviously. Maybe talk about what use Miro for, but then what else is in there? What do you use for task management, bug tracking, things like that? Design?

**中文翻译:**
太棒了。这正好引出了我想问的另一个问题：产品团队的工作流中还有哪些其他工具？显然有 Miro。也许可以谈谈你们用 Miro 做什么，但除此之外还有什么？你们用什么进行任务管理、Bug 跟踪之类的事情？设计呢？

---

### [00:56:12] Varun Parmar

**English:**
Starting from the bottom-up infrastructure view, so all of our tickets are handled in Jira and we are using some of the newer capabilities in Jira in terms of coming up with roadmaps and coming up with the priorities and stuff. On top of that, all of the specs generally get recorded in Confluence. Having said that, we're actually a big fan of tools like Google Docs as well as Coda that allows us to track our KRs in a pretty effective way. On top of that, obviously we use Miro a lot, I would say for a lot of our things, especially on the product and design side of the team. Generally all of our insights get captured inside of Miro board, so when we are going and conducting user experience interviews and stuff, we will record those and then those recordings get added to a Miro board, so Miro access the content hub or a team hub for a particular project.

**中文翻译:**
从底层的基础设施视角来看，我们所有的工单（tickets）都在 Jira 中处理，我们正在使用 Jira 的一些新功能来制定路线图和确定优先级等。除此之外，所有的规格说明（specs）通常都记录在 Confluence 中。话虽如此，我们实际上也是 Google Docs 和 Coda 的忠实粉丝，它们能让我们非常有效地跟踪 KR。当然，我们大量使用 Miro，我会说在很多事情上都用，尤其是产品和设计团队。通常我们所有的洞察都会捕捉在 Miro 看板中，所以当我们进行用户体验访谈时，我们会录音，然后将这些录音添加到 Miro 看板中，因此 Miro 充当了特定项目的内容中心或团队中心。

---

### [00:57:20] Varun Parmar

**English:**
Once you capture all of those insights, then generally all of the brainstorming and team ideation happens on the Miro board as well, so Miro's actually also used as a tool to facilitate meetings and workshops. Once all of that is synthesized into a set of recommendations and outcomes, so when we go into these product reviews that we were talking about, Lenny, the same Miro board then gets manifested into a set of presentations, so we use Miro for presentations. We've actually made some really amazing updates in terms of our capabilities there and if folks haven't checked them out, I would strongly encourage them. There's a capability called Showtime that basically abstracts out the UI and lets people focus on the content, but do it in a way that it's interactive so everyone that's on the call can have reactions, can share their comments and leave comments while the presentation is happening without actually disrupting any of the flow for the user, so we use that a lot for presentations as well.

**中文翻译:**
一旦你捕捉到所有这些洞察，通常所有的头脑风暴和团队构思也会在 Miro 看板上进行，所以 Miro 实际上也被用作促进会议和工作坊的工具。当所有这些都被综合成一套建议和结果后，当我们进入刚才提到的产品评审时，Lenny，同一个 Miro 看板就会变成一套演示文稿，所以我们用 Miro 进行演示。实际上我们在演示功能方面做了一些非常了不起的更新，如果大家还没看过，我强烈建议去看看。有一个叫 Showtime 的功能，它基本上抽象掉了 UI，让人们专注于内容，但它是以一种交互式的方式进行的，这样通话中的每个人都可以在演示进行时做出反应、分享评论并留下评论，而不会真正干扰用户流程，所以我们也经常用它来进行演示。

---

### [00:58:15] Varun Parmar

**English:**
I would say more recently what we've started to do is that we've started to move some of our synchronous meetings into asynchro view. I talked about this Talktrack feature that we have, and a lot of teams, what they would do is that they would actually send you five minute, 10 minute Talktrack in advance and it's just a link to a Miro board, you click on it and then you just sit back and relax. Then you have this magical experience where you're sitting back and the Miro board is automatically moving because Lenny was recording it like that. Then you have the video play and then you can pause it anytime, you can add in your comments and stuff so that the next time when you meet, instead of actually providing context to everyone, those synchronous sessions are lot more deliberate and focused on driving outcomes or achieving consensus, so people are just focusing on the comments that were added as part of a async product review so that when they meet synchronously they can use that. Miro boards are used for that as well.

**中文翻译:**
我会说最近我们开始做的是将一些同步会议转为异步查看。我提到过我们的 Talktrack 功能，很多团队会提前发给你一个 5 分钟或 10 分钟的 Talktrack，它只是一个 Miro 看板的链接，你点击它，然后坐下来放松。接着你会有一种神奇的体验：你坐着，Miro 看板会自动移动，因为 Lenny 就是那样录制的。视频播放时，你可以随时暂停，添加评论等，这样下次开会时，就不用再向每个人介绍背景了，那些同步会议会变得更加深思熟虑，专注于推动结果或达成共识。人们只需关注作为异步产品评审一部分添加的评论，以便在同步会议中使用。Miro 看板也被用于此。

---

### [00:59:06] Varun Parmar

**English:**
I would say now a lot of our dashboarding shows up in Miro boards now. We recently released data visualization capabilities around most popular VI tools. At Miro we use Google Looker a lot, so a lot of our dashboards are in Looker, and what you would typically find is that our analyst team and product teams will just grab a link to a Looker dashboard, put it on a Miro board, and it unfolds into a full visualization. Unlike a screen grab, you never have to go update it because right there on the Miro board, it's always updated and you can refresh that, so you basically have this experience where Miro acts as that single source of truth for a lot of the teams across the entire journey of product development where a single Miro board is meeting the needs of multiple use cases there.

**中文翻译:**
我想说，现在我们的很多仪表盘（dashboarding）也都显示在 Miro 看板上了。我们最近发布了针对最流行 BI 工具的数据可视化功能。在 Miro，我们经常使用 Google Looker，所以我们的很多仪表盘都在 Looker 中。你通常会发现，我们的分析团队和产品团队只需抓取一个 Looker 仪表盘的链接，把它放在 Miro 看板上，它就会展开成一个完整的可视化图表。与屏幕截图不同，你永远不需要去更新它，因为就在 Miro 看板上，它始终是实时更新的，你可以随时刷新。所以你基本上拥有了这样一种体验：在整个产品开发过程中，Miro 充当了许多团队的单一事实来源（single source of truth），一个 Miro 看板就能满足那里的多个用例需求。

---

### [00:59:51] Lenny

**English:**
Then for the road-mapping, is that in Miro, each team's roadmap, or do you use something like Jira?

**中文翻译:**
那么关于路线图（road-mapping），每个团队的路线图是在 Miro 中，还是使用像 Jira 这样的工具？

---

### [00:59:57] Varun Parmar

**English:**
Yeah, so I think we've got a couple of tools for road-mapping, and our observation is that while those tools are great for the unique needs that they're solving, we haven't found a universal solution for road-mapping. So there are some teams that use Miro for road-mapping and they would use the Kanban widget in Miro for that. What are they working on? What's coming next? What's in the backlog? But I would say it is a problem that is not completely solved in terms of how do we actually bring these artifacts together at scale.

**中文翻译:**
是的，我想我们有几种用于路线图的工具。我们的观察是，虽然这些工具在解决特定需求方面很出色，但我们还没有找到一个通用的路线图解决方案。所以有些团队使用 Miro 进行路线图规划，他们会使用 Miro 中的看板（Kanban）组件。他们在做什么？接下来要做什么？积压的工作（backlog）里有什么？但我想说，在如何大规模地将这些成果物整合在一起方面，这仍然是一个尚未完全解决的问题。

---

### [01:00:27] Varun Parmar

**English:**
What we are starting to see, and this is actually a unique use case of Miro, is that we actually enable our entire field organization using Talktracks. What happens is that we have our entire roadmap published out as a Miro board for enablement purposes, so that that's a artifact that is approved to be shown to a customer. What you will see is that you'll see five or six recordings in there, and the leader for enterprise has done a five-minute recording on everything they're working on. The leader for platform has done that. The leader for end user experience has done that. The person who's driving some of our AI experience has done that. So you can go in and you can just click on that video and you can meet your needs by using Miro and this capability that we have.

**中文翻译:**
我们开始看到的是——这实际上是 Miro 的一个独特用例——我们通过 Talktracks 赋能我们的整个外勤组织（field organization）。具体情况是，我们将整个路线图作为一个 Miro 看板发布出来用于赋能，这是一个被批准展示给客户的成果物。你会看到里面有五六个录音，企业级业务负责人就他们正在做的一切做了一个 5 分钟的录音。平台负责人也做了录音。最终用户体验负责人也做了录音。负责推动 AI 体验的人也做了录音。所以你可以进去点击那个视频，通过使用 Miro 和我们拥有的这项功能来满足你的需求。

---

### [01:01:09] Lenny

**English:**
That's awesome. It sounds like each team can basically choose the tools they want to use. There's no standardized, everyone needs to use Jira or Miro for their roadmap. I like that. I like how teams do that often. Maybe one last question around the product org, and then I want to shift a little bit to growth and how Miro grows and things you have learned about growing. Question I always try to get to is how do you think about balancing new bets and innovation with maintenance and just general incremental work? Do you have some sort of philosophy as a product leader broadly, and then maybe at Miro specifically, of just how to balance investments in these two buckets and maybe three buckets, bugs, incremental work, and then just big bet? How do you think about that?

**中文翻译:**
太棒了。听起来每个团队基本上可以选择他们想用的工具。没有标准化的规定说每个人都必须用 Jira 或 Miro 来做路线图。我喜欢这样，我喜欢团队经常这样做。关于产品组织，也许最后一个问题，然后我想转向增长，聊聊 Miro 如何增长以及你在增长方面学到的东西。我一直想问的问题是：你如何考虑平衡新的赌注和创新与维护以及一般的增量工作？作为一名产品领导者，你是否有一种广泛的哲学，或者特别是在 Miro，关于如何平衡这两个桶（甚至三个桶：Bug、增量工作和重大赌注）的投资？你是怎么想的？

---

### [01:01:55] Varun Parmar

**English:**
We have some rule of thumbs in terms of how we want to allocate our investments across these buckets. I would say a lot of it, Lenny, actually depends on the state of the team. There are certain teams that have more tech debt than others. There are certain teams that are actually working on some really big zero to one features than other teams, and so I think there is a variance. The standard deviation actually is dependent on which part of the spectrum that you're in, which is are you a team that we believe needs to create the next generation experience on the platform and hence we have to prioritize innovative work or are you the team that's actually so critical to actually meeting our objective around better board performance or any of the other things that we believe are important and hence we need to invest in those critical areas?

**中文翻译:**
关于如何在这些桶之间分配投资，我们有一些经验法则。Lenny，我想说这在很大程度上取决于团队的状态。有些团队的技术债比其他团队多。有些团队正在开发一些非常重大的从 0 到 1 的功能。因此我认为存在差异。标准差实际上取决于你处于光谱的哪一端：你是我们认为需要创建平台下一代体验的团队，因此我们必须优先考虑创新工作；还是你是一个对实现我们关于更好看板性能或其他重要目标至关重要的团队，因此我们需要投资于这些关键领域？

---

### [01:02:41] Varun Parmar

**English:**
But I would say in general innovation versus not, varies on a spectrum of anywhere from 60 to 80%. I would say about 20 to 40% of the available capacity at any given time is either getting allocated to architectural initiatives. There's a technology roadmap that our CTO is driving that we believe is extremely important as the platform scales, and now as we have over 50 million people on the platform, so we continuously have to invest in making sure that the platform can scale. There are certain teams that probably have 40 to 50% of their allocation towards that because they're a critical part of the component. There are other teams that are maybe more end user focused and are more UI focused where that allocation is lower. But I think general rule of thumb is 20% is always a given, but it can go as high as 40 to 50%.

**中文翻译:**
但我会说，总的来说，创新与非创新的比例在 60% 到 80% 之间波动。我会说，在任何给定时间，大约 20% 到 40% 的可用容量要么分配给架构计划。我们的 CTO 正在推动一个技术路线图，我们认为随着平台规模的扩大（现在平台上已有超过 5000 万用户），这极其重要，所以我们必须持续投资以确保平台能够扩展。有些团队可能有 40% 到 50% 的分配用于此，因为他们是组件的关键部分。其他团队可能更关注最终用户或 UI，那里的分配比例会更低。但我认为一般的经验法则是 20% 是保底的，但最高可以达到 40% 到 50%。

---

### [01:03:30] Lenny

**English:**
On bigger bets and longer-term thinking?

**中文翻译:**
是用于重大赌注和长期思考吗？

---

### [01:03:33] Varun Parmar

**English:**
Yeah, 20 to 40% goes on the technology-related initiatives and maintenance and stuff.

**中文翻译:**
是的，20% 到 40% 用于技术相关的计划、维护等。

---

### [01:03:38] Lenny

**English:**
Oh, got it. Infrastructure, maintenance, making sure everything's there. Got it.

**中文翻译:**
噢，明白了。基础设施、维护，确保一切正常运行。明白了。

---

### [01:03:44] Varun Parmar

**English:**
[inaudible 01:03:44] Exactly, yeah.

**中文翻译:**
没错。

---

### [01:03:44] Lenny

**English:**
Then what about just big, long-term bets that you're not expecting to pay off anytime soon? Do you have a heuristic of just what percentage of, say, total resources you put there?

**中文翻译:**
那么，对于那些你不期望很快就能获得回报的重大长期赌注呢？你是否有一个启发式标准，比如你会投入总资源的百分之几？

---

### [01:03:53] Varun Parmar

**English:**
You've probably seen this, the framework of three horizon, it's quite popular in McKinsey and Harvard [inaudible 01:04:01] school and so on and so forth, is horizon one business, which is the thing that's delivering food on the table. Generally there's about a 70% allocation of resources that we have, give or take. Then there is horizon two, which is an adjacent thing. With the next 12 to 36 months we believe it's material. Usually that tends to be around 20% of the allocation. Then there's horizon three, which is three years out, three to five years, next generation things, and that's about 10% of the ratio. So it's like 70/20/10 across horizon one, two, and three.

**中文翻译:**
你可能见过这个“三地平线（Three Horizons）”框架，它在麦肯锡和哈佛商学院等地非常流行。地平线 1（Horizon 1）业务是维持生计的东西，通常我们分配大约 70% 的资源。然后是地平线 2（Horizon 2），它是相邻领域的东西，我们认为在未来 12 到 36 个月内会变得重要，通常占 20% 的分配。最后是地平线 3（Horizon 3），那是三年后、三到五年的下一代产品，比例大约是 10%。所以地平线 1、2、3 的比例是 70/20/10。

---

### [01:04:30] Lenny

**English:**
Awesome. Any other thoughts along the lines of just how you think about product before we shift? I only have a few questions around the growth story of Miro and what you've learned about growing.

**中文翻译:**
太棒了。在转向增长话题之前，关于你对产品的思考还有什么想法吗？关于 Miro 的增长故事以及你在增长方面学到的东西，我只有几个问题。

---

### [01:04:41] Varun Parmar

**English:**
In terms of product leadership and what we believe is the way we want product leaders to be developed and I think it's more of a people philosophy. We have our product leadership which constitutes of all of the folks who are running all of these streams, and I always tell them that you have two personas that you have to think about. Everyone who's on the product leadership team is a product leadership team member. The fundamental thing that you have to do is drive accountability. The number one thing that a product leader on the product leadership team needs to do is drive accountability with others in the product leadership team. The other persona that they have is that they are a stream leader. They're actually responsible for delivering value for the respective persona and respective customers and stuff. So when you put on the persona hat of a stream leader, which is different than the persona or of a product leader, your number one metric, the number one goal that you have, is drive improvement.

**中文翻译:**
关于产品领导力以及我们认为产品领导者应该如何培养，我认为这更多是一种人才哲学。我们的产品领导层由所有负责这些“流”的人员组成，我总是告诉他们，你必须考虑两个角色。产品领导团队中的每个人都是产品领导团队成员。你必须做的根本事情是“推动问责（drive accountability）”。产品领导团队中的产品领导者需要做的头等大事是与团队中的其他人共同推动问责。他们的另一个角色是“流负责人（stream leader）”。他们实际上负责为各自的角色和客户交付价值。所以当你戴上流负责人的帽子时（这与产品领导者的角色不同），你的头号指标、头号目标就是“推动改进（drive improvement）”。

---

### [01:05:42] Varun Parmar

**English:**
When you go back and you work with your team, always have the lens are you improving things and whatever you want to improve, but you always have to ask yourself, "Today compared to yesterday, tomorrow compared to today, have I improved things? That's the yardstick you should think about. When you go sit in the product leadership team every Monday afternoon at 1:00 in the afternoon when we meet together, your number one goal is actually to drive accountability around this and are you making sure that we as leaders in the organization are doing the right thing for the company?" I think that's a philosophical construct that I always remind people in terms of what they should be doing. As an example, tomorrow we have calibrations, we have our annual review cycle happening in the company.

**中文翻译:**
当你回到团队中工作时，始终要带着“你是否在改进事物”的视角，无论你想改进什么，你总是要问自己：“今天比昨天有进步吗？明天比今天会有进步吗？”这就是你应该考虑的衡量标准。而当你每周一下午 1 点参加产品领导团队会议时，你的头号目标实际上是围绕这一点推动问责，并确保我们作为组织的领导者正在为公司做正确的事情。我认为这是一个哲学构架，我总是提醒人们应该做什么。举个例子，明天我们要进行绩效校准，公司正在进行年度评估周期。

---

### [01:05:42] Lenny

**English:**
Good times. Always a blast.

**中文翻译:**
好时光，总是很刺激。

---

### [01:06:23] Varun Parmar

**English:**
Yes, exactly, always fun and so critical as a leader, because it sets the tone for everything that you're going to do. In my opening remarks, the only thing I'm going to remind everyone in the room is that "Your number one goal here is to be a product leader and accountability is what you have to write. That's it. Just hold each other as accountable, including myself in terms of making sure that as we go in, that's the key thing." I think once people understand the duality of how they need to operate across those two specific goals, it actually leads to really high-performing teams and teams that actually are able to create somewhat of a magic if they are open and there is trust that has been built in the team.

**中文翻译:**
是的，没错，总是很有趣，而且作为领导者非常关键，因为它为你将要做的一切奠定了基调。在我的开场白中，我唯一要提醒房间里每个人的就是：“你们在这里的头号目标是成为一名产品领导者，而问责制就是你们要写的。就是这样。互相问责，包括对我自己，确保我们在推进过程中做到这一点，这是关键。”我认为，一旦人们理解了在这两个特定目标之间运作的双重性，它实际上会产生真正高效的团队，如果团队是开放的且建立了信任，他们就能创造出某种奇迹。

---

### [01:07:07] Lenny

**English:**
When you say accountability, what does that look like? Is it pointing out, "Hey, you didn't achieve this thing we were trying to achieve" or "You didn't do a great job leading this meeting"? Is it just direct feedback often or is there some other way you see that manifested, and what do you like to see?

**中文翻译:**
当你提到“问责”时，它具体是什么样子的？是指出“嘿，你没有实现我们试图实现的目标”或者“你主持这次会议做得不够好”吗？是经常性的直接反馈，还是有其他表现形式？你希望看到什么？

---

### [01:07:24] Varun Parmar

**English:**
Yeah, I think it's basically practicing feedback in a very open and constructive way and focusing on what is important for the business and not shying away from having some of those observations and conversations, not shying away from them. But it's all in the lens of what is the right thing to do for the business, and if you feel that that one or more members of the leadership team are not living up to what needs to be done, then just voicing it. It's not like you're complaining or anything, it's just like, "I have this perspective. Is this the right perspective or not?" Because actually it ties very well with the overall cultural values that we have.

**中文翻译:**
是的，我认为这基本上是以一种非常开放和建设性的方式进行反馈，专注于对业务重要的事情，不回避那些观察和对话。但这一切都是从“对业务来说什么是正确的事”的角度出发的。如果你觉得领导团队中的一个或多个成员没有达到应有的要求，那就说出来。这不像是在抱怨，而更像是：“我有这个看法。这个看法对不对？”因为这实际上与我们的整体文化价值观非常契合。

---

### [01:08:02] Varun Parmar

**English:**
If you do things with the lens that you are being empathetic, then you pose it as a question as opposed to a statement. I think that's one of the things that we practice a lot at Miro is that I believe that I am seeing there are certain things that are happening that it could be just me that I'm not seeing the other things. "But what is it? Can you help me understand? Can you help me figure out that why certain things are happening? Because I might just be missing the perspective." But because you bring it up, and that's part of practicing accountability in an empathetic way, it actually gets the entire team in the right mindset in terms of how they operate.

**中文翻译:**
如果你带着同理心的视角去做事，你会把它作为一个问题而不是一个陈述提出来。我认为这是我们在 Miro 经常练习的一点：我相信我看到了一些正在发生的事情，但也可能只是我没看到其他方面。“但那是什么？你能帮我理解吗？你能帮我弄清楚为什么某些事情会发生吗？因为我可能只是漏掉了某种视角。”但正因为你提出来了，而这正是以同理心践行问责制的一部分，它实际上让整个团队在运作方式上处于正确的心态。

---

### [01:08:39] Lenny

**English:**
Has anyone given you some sort of direct feedback recently or pointed out something you didn't do well that held you accountable that you can share?

**中文翻译:**
最近有人给你提供过某种直接反馈，或者指出你做得不好的地方，从而对你进行问责吗？能分享一下吗？

---

### [01:08:47] Varun Parmar

**English:**
All the time. Yeah, all the time. When we do our offsites, this is actually a fun thing, is that every offsite that I do with my leadership team, usually there is a one to two hour session where it is feedback to Varun, and I actually do it openly. I will have about eight to 10 people in the room and I will force people to be very honest and I want to show my vulnerabilities to everyone, that I am not perfect and I have lots of areas to improve. Every time people do it, it's interesting that they open up in very amazing ways and I think I love it because it helps me become better. It helps me identify my blind spots. But what it does is, because I do it in an open way, it brings a lot of trust. It brings trust that I do it openly and I'm an open book and they can share whatever they want, not just with me but openly in front of everyone.

**中文翻译:**
一直都有。是的，一直都有。当我们进行团建（offsites）时，这实际上是一件很有趣的事：我与领导团队进行的每一次团建，通常都会有一个一到两小时的环节，专门是“给 Varun 的反馈”，而且我是公开进行的。房间里会有大约 8 到 10 个人，我会强迫大家保持诚实，我想向每个人展示我的脆弱，展示我并不完美，我有很多需要改进的地方。每次大家这样做时，有趣的是他们会以非常令人惊叹的方式敞开心扉。我喜欢这样，因为它能帮我变得更好，帮我识别盲点。但更重要的是，因为我以公开的方式进行，它带来了很多信任。它让大家相信我是公开透明的，我是一本打开的书，他们可以分享任何想分享的东西，不仅是对我，而且是在所有人面前公开分享。

---

### [01:09:43] Lenny

**English:**
Are you willing to share one thing they suggested that they pointed out that they wish you did differently or better?

**中文翻译:**
你愿意分享一件他们建议的、指出的希望你做得不同或更好的事情吗？

---

### [01:09:48] Varun Parmar

**English:**
Yeah, I think in general, finding time with me tends to be a bit of a hard thing, and generally there's always this feedback, which is need more time, maybe more responsiveness over email or Slack or something like that. That's an area that I'm constantly working on and improving, so yeah.

**中文翻译:**
是的，我认为总的来说，找我腾出时间往往有点难。通常总会有这样的反馈：需要更多时间，或者在邮件、Slack 上的响应速度需要更快。这是我一直在努力改进的领域。

---

### [01:10:11] Lenny

**English:**
That feels like a cop out. That doesn't feel too painful to hear. I'm like, "Yeah, yeah, I know. I don't have a lot of time. I'm sorry." But I get it, and that comes back to your point about blockers and how important it's to unblock teams because that leads to a lot faster progress.

**中文翻译:**
这听起来像是在找借口（笑）。听起来并不太痛苦。我会说：“是啊，我知道，我没那么多时间，对不起。”但我明白，这回到了你关于障碍的观点，以及为团队扫清障碍是多么重要，因为这会带来更快的进展。

---

### [01:10:26] Varun Parmar

**English:**
That's true, that's true.

**中文翻译:**
没错，没错。

---

### [01:10:28] Lenny

**English:**
Okay, so let me shift a little bit to Miro's growth and I only have a few questions here. I know it's getting late on your side so I don't want to keep you too long.

**中文翻译:**
好，让我稍微转向 Miro 的增长话题，我只有几个问题。我知道你那边已经很晚了，所以我不想耽误你太久。

---

### [01:10:34] Varun Parmar

**English:**
Sure.

**中文翻译:**
没问题。

---

### [01:10:35] Lenny

**English:**
The first is something I'm on this constant quest to understand how companies got their first users, and I haven't actually heard the story of how Miro got its first thousand users or customers. I know you weren't there in the early days, but you happen to know how Miro initially grew and got their first thousand users and customers?

**中文翻译:**
第一个问题是我一直在探寻的：公司是如何获得第一批用户的。我还没听过 Miro 是如何获得前一千名用户或客户的故事。我知道你早期不在那里，但你恰好知道 Miro 最初是如何增长并获得前一千名用户和客户的吗？

---

### [01:10:53] Varun Parmar

**English:**
I think the fundamental thing there is that we always had user first approach and reaching out to certain communities that were relevant to what was a key part of lighting the fire, if you will, the proverbial way people start to talk about the product. Given the collaborative nature of the product, some of the early adopters invited people who were also early adopters and the flywheel started to work. I've heard that we did a fair amount of content marketing and listing the product on sites like Capterra sort of helped. There was some early investments in terms of SEO and organic growth, so there was a focus there, which was the main source of driving traffic. The top of the funnel came through that.

**中文翻译:**
我认为根本原因在于我们始终坚持“用户第一”的方法，并接触那些相关的特定社区，这是“点燃火种”的关键部分，也就是人们开始谈论产品的众所周知的方式。鉴于产品的协作性质，一些早期采用者邀请了同样是早期采用者的人，飞轮开始转动。我听说我们做了大量的内营销，并在 Capterra 等网站上列出产品也有所帮助。在 SEO 和有机增长方面也有一些早期投资，所以那是当时的重点，也是流量的主要来源。漏斗顶部就是通过这些渠道建立的。

---

### [01:11:43] Varun Parmar

**English:**
The product teams were very intensely focused on building vital loops as a key mechanism of driving growth, once the traffic came in. Every interaction that actually introduced barrier, they looked at it and they looked at the data and they said, "Let's reduce this barrier. Let's remove this thing so that the product could be effectively embraced." It was an evolution over a period of time. There was also the fact that early on in the journey, some of the features were presented on a trial basis and then later on the model was evolved from a trial basis, time limited to a premium model that further accelerated the growth for the business. I would say those were some of the approaches that were taken to get to the first thousand users or so.

**中文翻译:**
一旦流量进来，产品团队就非常专注于构建病毒循环（viral loops）作为驱动增长的关键机制。对于每一个引入障碍的交互，他们都会观察数据并说：“让我们减少这个障碍。让我们移除这个东西，以便产品能被有效地接受。”这是一个随时间演变的过程。还有一个事实是，在发展初期，一些功能是以试用形式提供的，后来模式从限时试用演变为免费增值（freemium）模式，这进一步加速了业务的增长。我会说这些就是获得前一千名左右用户所采取的一些方法。

---

### [01:12:34] Lenny

**English:**
You talked about how Miro grows, where it has this magical loop of "I use Miro to for myself, then I share it with my team in whatever way I'm using it." They're like, "Oh, Miro, this is cool." Then they start using it and then they share it with people that they want to work with, and it creates this loop of growth." I imagine that's how Miro mostly grew initially and continues to grow. Is there anything surprising or unintuitive about how Miro grows that is beyond that? I imagine sales is a part of it and we can talk about that, but is there anything else that is interesting that is worth mentioning?

**中文翻译:**
你谈到了 Miro 是如何增长的，它有一个神奇的循环：“我为自己使用 Miro，然后以我使用的任何方式将其分享给我的团队。”他们会说：“噢，Miro，这很酷。”然后他们开始使用它，接着又分享给他们想合作的人，从而创造了这个增长循环。我猜这就是 Miro 最初的主要增长方式，并且现在仍在继续。除此之外，关于 Miro 的增长，还有什么令人惊讶或不直观的地方吗？我猜销售也是其中的一部分，我们可以聊聊那个，但还有什么其他值得一提的有趣之处吗？

---

### [01:13:07] Varun Parmar

**English:**
No, I think that's the key of the growth. I think there are specific use cases where they are uniquely sort of geared towards inviting a lot of new people. For example, Miro is loved as a workshopping tool, and so generally one person is using Miro, but they invite 10, 15, 20, 50, 200, 300 people to that workshop. There are specific use cases where people get introduced to the product and then go and sign up for it and then start to use it for that use case or other use cases. I think the other accelerant in all of this is the templates that we have, in particular the role that Miroverse plays in all of this.

**中文翻译:**
不，我认为那是增长的关键。我认为有一些特定的用例，它们天生就适合邀请大量新人。例如，Miro 作为工作坊工具深受喜爱，通常一个人在使用 Miro，但他们会邀请 10、15、20、50、200 甚至 300 人参加那个工作坊。在这些特定的用例中，人们被介绍给产品，然后去注册，并开始将其用于该用例或其他用例。我认为另一个加速器是我们拥有的模板，特别是 Miroverse 在其中扮演的角色。

---

### [01:13:49] Varun Parmar

**English:**
Just to give you an example here, there was a template which was created around FIFA World Cup, so there was a FIFA World Cup diagram. Cornelius, he's the founder and managing director of a Canadian strategic service design consultancy firm. He created this Miroverse template and it had over 100,000 views and about 15,000 copies were made of the single template. Given the popularity of all of this, it actually got indexed by Google. When you went in the search, you actually saw the Miroverse FIFA template show up when you were trying to search for FIFA World Cup, and that was another sort of acquisition channel top of funnel that actually drew a lot of users to it. So I think I would say the Miroverse is also a key accelerant to this.

**中文翻译:**
举个例子，有一个围绕 FIFA 世界杯创建的模板，也就是一个 FIFA 世界杯图表。Cornelius 是一家加拿大战略服务设计咨询公司的创始人兼董事总经理，他创建了这个 Miroverse 模板，它获得了超过 10 万次浏览，单个模板被复制了约 1.5 万次。鉴于其受欢迎程度，它实际上被 Google 索引了。当你搜索“FIFA 世界杯”时，你实际上能看到 Miroverse 的 FIFA 模板出现，那是另一个漏斗顶部的获客渠道，吸引了大量用户。所以我会说 Miroverse 也是一个关键的加速器。

---

### [01:14:45] Lenny

**English:**
If you had to think about the pie chart of how Miro grows, what percentage roughly would you say is word of mouth, organic, versus what you just described, which is essentially a CO versus sales, outbound sales? How do you think about that? Is there a way to model that simply?

**中文翻译:**
如果你必须考虑 Miro 增长的饼图，你会说口碑、有机增长大约占百分之几，而你刚才描述的（本质上是 SEO）以及销售、主动销售又占百分之几？你是怎么考虑的？有没有一种简单的建模方式？

---

### [01:15:02] Varun Parmar

**English:**
Without getting into specific numbers and stuff, I would say fundamentally Miro is a product-led growth company and product channels are one of the highest contributors for growth of users. As the business has evolved to serve the needs of some of the largest corporations in the world, the enterprise segment and the enterprise persona when they're trying to provision Miro for tens of thousands of users who then go conduct hundreds of thousands of workshops on Miro that invite millions of users on the platform, is a key part of the flywheel that we are seeing. I would say product channels are probably very strong and increasingly enterprise is a key part of that acceleration.

**中文翻译:**
在不涉及具体数字的情况下，我会说从根本上讲，Miro 是一家产品驱动增长（PLG）公司，产品渠道是用户增长的最大贡献者之一。随着业务的发展，为了满足全球一些最大型企业的需求，企业细分市场和企业角色（当他们尝试为数万名用户配置 Miro，而这些用户随后在 Miro 上进行数十万场工作坊，邀请数百万用户进入平台时）成为了我们所看到的飞轮的关键部分。我会说产品渠道非常强大，而且企业级业务正日益成为这种加速的关键部分。

---

### [01:15:53] Lenny

**English:**
A great segue to our final question, which is the idea that you started a product growth, sounds like clearly it's a big part of growth today, but as every product growth company does eventually you have a large sales team, I imagine, what have you learned as a product leader working with sales, especially at a product growth company about how to make that relationship work and have a product work effectively with a sales org?

**中文翻译:**
这很好地引出了我们的最后一个问题：你们以产品驱动增长起步，显然这在今天仍是增长的重要部分，但正如每家 PLG 公司最终都会经历的那样，我猜你们现在也有一支庞大的销售团队。作为一名在 PLG 公司工作的产品领导者，在与销售团队合作方面，你学到了什么？如何让这种关系发挥作用，并让产品与销售组织有效地协作？

---

### [01:16:15] Varun Parmar

**English:**
There are a few learnings and I would say maybe this is one area where we are working on how we could be doing better in terms of bringing ourselves closer to our high-touch and bringing high-touch closer to self-serve, in terms of how we operate overall. It's a lot of hard work, I would say first of all, basically, to bring both of these organizations together and you have to be very deliberate around the points of intersection and you have to make sure that these organizations don't consider themselves as competition. It's one product, one company, just two channels of how we are serving our customers. There's some things that we've done which is have the product marketing team that basically works across both of these functions and make sure that they are bridging what we are hearing from the sales organization in terms of what directly customers need on the enterprise side, and then what do we need on the self-serve side.

**中文翻译:**
有一些心得。我会说，这可能是我们正在努力做得更好的一个领域，即在整体运作方面，如何让我们自己更接近“高接触（high-touch，指大客户销售）”，并让高接触更接近“自助服务（self-serve）”。首先，将这两个组织结合在一起需要大量艰苦的工作，你必须对交汇点非常深思熟虑，并且必须确保这些组织不认为彼此是竞争关系。这是同一个产品，同一家公司，只是服务客户的两个渠道。我们做了一些事情，比如让产品营销团队跨这两个职能工作，确保他们能够架起桥梁，将我们从销售组织听到的企业端客户直接需求，与自助服务端的需求结合起来。

---

### [01:17:23] Varun Parmar

**English:**
There's a full process in terms of how the handoff happens across the maturity of the account. It can start as a self-serve, it drives adoption, and once there's adoption, there's a hand raiser that happens and then there's a sales rep that gets engaged and you go through the qualification process and then you have an opportunity to expand the account. We've over the years sort of architected and built the entire funnel and what the process is, and that's also sort of a key part of how all of this operates. But like I said, I think there are a few areas where we could further streamline how we operate and think of it as one single unit.

**中文翻译:**
关于账户成熟度如何进行交接，有一套完整的流程。它可以从自助服务开始，驱动采用率，一旦有了采用率，就会出现“举手者（hand raiser）”，然后销售代表介入，进行资格审核流程，接着你就有机会扩展该账户。这些年来，我们构建并完善了整个漏斗和流程，这也是这一切运作的关键部分。但正如我所说，我认为在某些领域我们可以进一步简化运作方式，并将其视为一个统一的整体。

---

### [01:18:05] Lenny

**English:**
I imagine that is true for every company out there.

**中文翻译:**
我想对每家公司来说都是如此。

---

### [01:18:07] Varun Parmar

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:18:09] Lenny

**English:**
One maybe final question before we get to our very exciting lightning round. What are some features that people could look forward to that are coming with Miro?

**中文翻译:**
在进入非常令人兴奋的闪电轮提问之前，还有一个最后的问题。人们可以期待 Miro 即将推出的哪些功能？

---

### [01:18:19] Varun Parmar

**English:**
We recently, about a month ago, announced Miro AI, the backdrop of all the amazing work that's happening around generative AI and large language models and stuff. I think it was really, really exciting to see all of the community enthusiasm around the use cases that we launch. So we're going to be taking it across the finish line and doing a general availability in the coming weeks and months. I think that's one big thing and we'll be adding more capabilities there. Just today we actually announced a bunch of really deep enhancements and updates around how Miro can be used for team rituals and agile practices. Now you can actually do retrospectives in Miro where you can have a private mode where while Lenny's typing his feedback during retrospective, nobody else can see it and then one click you can reveal it. I just saw some of the results of the feedback and it was rated as the number one feature people saw.

**中文翻译:**
大约一个月前，我们在生成式 AI 和大语言模型等了不起的工作背景下发布了 Miro AI。看到社区对我们推出的用例表现出的极大热情，真的非常令人兴奋。因此，我们将在未来几周和几个月内完成最后的工作并正式发布（GA）。我认为这是一件大事，我们将增加更多功能。就在今天，我们实际上发布了一系列关于如何将 Miro 用于团队仪式和敏捷实践的深度增强和更新。现在你可以在 Miro 中进行回顾会议（retrospectives），你可以开启私密模式，当 Lenny 在回顾期间输入反馈时，其他人看不到，然后点击一下即可公开。我刚看到一些反馈结果，它被评为人们最看好的头号功能。

---

### [01:19:14] Varun Parmar

**English:**
There's also some deeper integrations in terms of bringing an entire program board from Jira to start to do dependency mapping inside of Miro in a fun and collaborative way, to use this dependency mapping along with program board to start to do program increment planning, which is essentially scrum of scrums or big room planning that's happening. There's some really amazing capabilities that we've added there, which is on the backdrop of some of the updates we've made in terms of estimation of sprint story points and so on and so forth. Now there's a whole plethora of capabilities and apps that are available as part of the platform that allow you to have your entire team conduct your team rituals in Miro and you can automate certain things, you can streamline things, you can do certain things in async and then do the rest in synchronous ways, so I think that's been a big update as well.

**中文翻译:**
还有一些更深层次的集成，比如从 Jira 引入整个程序板（program board），开始在 Miro 中以有趣且协作的方式进行依赖关系映射（dependency mapping），利用这种映射和程序板开始进行程序增量规划（PI planning），这本质上是“Scrum of Scrums”或正在进行的大型会议规划。我们在那里增加了一些非常惊人的功能，这是在我们对 Sprint 故事点估算等方面进行更新的背景下完成的。现在，作为平台的一部分，有大量的能力和应用可供使用，允许你的整个团队在 Miro 中进行团队仪式，你可以自动化某些事情，简化流程，异步完成某些部分，然后以同步方式完成其余部分。我认为这也是一个重大的更新。

---

### [01:20:12] Lenny

**English:**
Amazing. With that, we've reached our very exciting lightning round. I've got six questions for you. Are you ready?

**中文翻译:**
太棒了。至此，我们进入了非常令人兴奋的闪电轮。我有六个问题要问你。准备好了吗？

---

### [01:20:19] Varun Parmar

**English:**
Yes.

**中文翻译:**
准备好了。

---

### [01:20:20] Lenny

**English:**
All right, let's do it. What are two or three books that you have recommended most to other people?

**中文翻译:**
好，开始吧。你向别人推荐最多的两三本书是什么？

---

### [01:20:26] Varun Parmar

**English:**
One is, I love this, When Breath Becomes Air by Paul Kalanithi. It's one of those really emotional books that at the end of it, you might have tears in your eyes, but really, really amazing. We talked about Frank Slootman's Amp It Up, and then Satya Nadella's Hit Refresh. I think philosophically some of the things that we talked about today are inspirations that I found in some of these books.

**中文翻译:**
一本是我非常喜欢的 Paul Kalanithi 的《当呼吸化为空气》（When Breath Becomes Air）。这是一本非常感人的书，读完后你可能会热泪盈眶，但真的非常了不起。还有我们谈到的 Frank Slootman 的《Amp It Up》，以及萨提亚·纳德拉的《刷新》（Hit Refresh）。我认为我们今天谈到的一些哲学层面的东西，灵感就来自这些书。

---

### [01:20:49] Lenny

**English:**
What's a recent favorite movie or TV show?

**中文翻译:**
最近最喜欢的电影或电视剧是什么？

---

### [01:20:52] Varun Parmar

**English:**
Ted Lasso. I don't know if it's a recent one or not, but something-

**中文翻译:**
《足球教练》（Ted Lasso）。我不知道它算不算最近的，但——

---

### [01:20:55] Lenny

**English:**
It's a new season.

**中文翻译:**
它出新一季了。

---

### [01:20:57] Varun Parmar

**English:**
Yeah, I've enjoyed a lot. I think it's a very positive and uplifting message. I think the performance is huge. It's humorous, the characters are well-developed, so I think overall it's a treat, at least for, me to watch.

**中文翻译:**
是的，我非常喜欢。我认为它传递了非常积极和令人振奋的信息。表演非常出色，幽默感十足，角色塑造得很丰满。总的来说，至少对我来说，观看它是一种享受。

---

### [01:21:13] Lenny

**English:**
What's a favorite interview question you like to ask?

**中文翻译:**
你最喜欢问的面试问题是什么？

---

### [01:21:16] Varun Parmar

**English:**
I actually ask a math problem. For those of you who interviewed with me, I have this math problem, which is based on how Adobe created its first Creative Suite bundle. I was actually part of the team that came up with the pricing and packaging for the first Creative Suite post-acquisition of Macromedia. It's a math problem that allows you very quickly to figure out people in terms of their problem-solving skills. Usually I give that problem to people. I've given it to, I don't know, 700, 800 people, so I now have a very, very well established standard distribution of how long it takes for people, where do they get stuck and where they've gotten stuck, for those people I've hired, what evidence do I have in terms of using that as a framework in terms of them being able to solve things? So that's my favorite question.

**中文翻译:**
我实际上会问一个数学题。对于那些参加过我面试的人来说，我有这样一个数学题，它是基于 Adobe 如何创建其第一个 Creative Suite 捆绑包的。我实际上是 Adobe 收购 Macromedia 后为第一个 Creative Suite 制定定价和包装的团队成员。这是一个数学题，可以让你非常快速地了解一个人的问题解决能力。通常我会把这个问题给面试者。我已经把它给过大概七八百人了，所以我现在有一个非常完善的标准分布，知道人们通常花多长时间、在哪里会卡住。对于那些我雇佣的人，我有证据表明使用这个框架可以衡量他们解决问题的能力。所以这是我最喜欢的问题。

---

### [01:22:08] Lenny

**English:**
So you're saying you've mapped back people that have done a certain way on the problem with their success and you've kind of found that it's a good signal of their performance?

**中文翻译:**
所以你是说，你已经将人们解决这个问题的方式与其后的成功进行了映射，并发现这是一个衡量他们表现的良好信号？

---

### [01:22:17] Varun Parmar

**English:**
Yes. Not directly, but yes, correlation and stuff.

**中文翻译:**
是的。不是直接的因果，但存在相关性。

---

### [01:22:21] Lenny

**English:**
That's amazing. That's one of the biggest problems with interviewing. You think you're asking all these amazing questions and it's such a good signal, you have no idea. No one goes back and is like, "Oh, this person sucked. This person didn't... " That's really cool to get that much data on that one question. Two more questions for you. What's something relatively minor that you've changed in how you do product development that has had a tremendous impact on your team's ability to execute?

**中文翻译:**
太神奇了。这是面试中最大的问题之一：你以为你问了所有这些了不起的问题，它们是很好的信号，但你其实根本不知道。没人会回头去想，“噢，这个人表现很差，那个人没……”能在一个问题上获得这么多数据真的很酷。还有两个问题。在产品开发方式上，你做了哪些相对较小的改变，却对团队的执行能力产生了巨大影响？

---

### [01:22:44] Varun Parmar

**English:**
We talked about some of that, sort of removing the roadblocks. I think having this motto of great customer value faster with high quality, just the simplicity of that and it's actually part of our evaluation rubric, it's part of how we measure ourselves and stuff. So I think just coming up with these simple concepts that you can rally the organization around, and I think it's still a work in progress, but something that I believe is leading to positive outcomes.

**中文翻译:**
我们谈到了一些，比如扫清障碍。我认为拥有“以高质量更快交付客户价值”这个座右铭，它的简洁性，以及它实际上是我们评估准则的一部分，是我们衡量自己的一部分。所以，我认为提出这些简单的概念，并让组织围绕它们团结起来，虽然这仍是一项正在进行的工作，但我相信它正在带来积极的结果。

---

### [01:23:07] Lenny

**English:**
Final question. What's your favorite Miro template?

**中文翻译:**
最后一个问题。你最喜欢的 Miro 模板是什么？

---

### [01:23:10] Varun Parmar

**English:**
It's the FIFA World Cup actually. I am so fascinated with what was done. Yeah, it's the latest one, but I think there's a bunch of them in terms of retros as well, and I think... like your template as well.

**中文翻译:**
实际上是 FIFA 世界杯那个。我对它的制作过程非常着迷。是的，那是最近的一个，但我认为在回顾会议（retros）方面也有很多很棒的模板，还有……比如你的模板也很棒。

---

### [01:23:21] Lenny

**English:**
Amazing. We will link to all of those. Varun, this was amazing. Everything I expected and more, your team is as interesting and unique as I thought, and I am excited for people to learn from you and we're going to share a lot of links alongside this episode in the show notes. Two final questions, where can folks find you online if they want to reach out and learn more, and how can listeners be useful to you?

**中文翻译:**
太棒了。我们会附上所有这些链接。Varun，这次谈话太精彩了。超出了我的预期，你们的团队确实如我想象的那样有趣且独特。我很高兴大家能向你学习，我们会在本期节目的笔记中分享很多链接。最后两个问题：如果大家想联系你并了解更多信息，可以在哪里找到你？以及听众可以为你提供什么帮助？

---

### [01:23:43] Varun Parmar

**English:**
Thank you, Lenny. It was a lot of fun. I enjoyed our interaction. You folks can find me online on LinkedIn. I think that's probably the best way to connect with me. I think in terms of one or two things I can ask everyone is that, one is if you are an existing Miro user and you use the product for something interesting, I highly encourage you to contribute it as a template as part of Miroverse. There's a lot of folks who use that and we would love for you to contribute there. The second thing is, I know a lot of product development teams, PMs and designers are big fans of you, Lenny, so those are also the users that use Miro. If there's anything we could do to make the product better, if there's things that you feel like we can expand the platform into, we would love to hear from you and just reach out to me directly over LinkedIn, direct message or connect with me there and yeah, and let us know. We're here to serve.

**中文翻译:**
谢谢你，Lenny。这很有趣，我很享受我们的互动。大家可以在 LinkedIn 上找到我，那可能是联系我的最好方式。关于我可以向大家请求的一两件事：第一，如果你是现有的 Miro 用户，并且你将产品用于一些有趣的事情，我强烈鼓励你将其作为模板贡献给 Miroverse。有很多人在使用它，我们非常希望你能参与贡献。第二件事是，我知道很多产品开发团队、PM 和设计师都是你的忠实粉丝，Lenny，他们也是 Miro 的用户。如果我们能做些什么让产品变得更好，或者你觉得我们可以将平台扩展到哪些领域，我们很想听听你的意见。请直接通过 LinkedIn 私信我或在那里与我联系，告诉我们。我们随时准备为大家服务。

---

### [01:24:40] Lenny

**English:**
Amazing. Varun, thank you again for being here.

**中文翻译:**
太棒了。Varun，再次感谢你的到来。

---

### [01:24:43] Varun Parmar

**English:**
Thanks, Lenny. Awesome.

**中文翻译:**
谢谢，Lenny。太棒了。

---

### [01:24:45] Lenny

**English:**
Bye everyone. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
再见，各位。非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用上订阅。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。