# Vikrama Dhiman - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Vikrama Dhiman.

---

### (00:00:00) Lenny Rachitsky

**English:**
Your name has come up more times than almost any other product person when I ask people for their favorite product leaders in Asia.

**中文翻译:**
当我询问大家谁是他们心目中亚洲最出色的产品领导者时，你的名字被提及的次数几乎比其他任何产品人都多。

---

### (00:00:07) Vikrama Dhiman

**English:**
I created a career growth framework for product managers, which comprises of three things. What you produce, what you bring to the table, and what's your operating model.

**中文翻译:**
我为产品经理创建了一个职业成长框架，它由三部分组成：你的产出（What you produce）、你带来的价值（What you bring to the table）以及你的运作模式（What's your operating model）。

---

### (00:00:18) Lenny Rachitsky

**English:**
Your advice is early in your career, focus on just getting stuff out and done.

**中文翻译:**
你的建议是，在职业生涯早期，要专注于把事情做出来并完成。

---

### (00:00:22) Vikrama Dhiman

**English:**
Can you show me your last PRD? Can you show me the last product note that you sent? Can you show me the product strategy doc? You must have that impact through the artifacts that you work on.

**中文翻译:**
你能给我看看你最近的一份 PRD（产品需求文档）吗？你能给我看看你发出的最后一份产品简报吗？你能给我看看产品战略文档吗？你必须通过你所创作的这些交付物（artifacts）来体现你的影响力。

---

### (00:00:32) Lenny Rachitsky

**English:**
I'm curious what you found most impedes people's career growth.

**中文翻译:**
我很想知道，你发现最阻碍人们职业成长的是什么。

---

### (00:00:37) Vikrama Dhiman

**English:**
How you view change, whether you are focusing on things you control, and third is how you see yourself. The moment you are able to correct those stories, you may be back on the growth path again.

**中文翻译:**
首先是你如何看待变化，其次是你是否专注于你能控制的事情，第三是你如何看待自己。一旦你能够修正你内心对自己设定的这些“故事”，你可能就会重新回到成长的轨道上。

---

### (00:00:52) Lenny Rachitsky

**English:**
Today, my guest is Vikrama Dhiman. Vikrama heads all things product at Gojek, including product management, design, program management, research and insights with teams across India, Singapore and Indonesia. He has previously worked at companies like Directi, Airtel, MakeMyTrip and WizIQ and is among the most well-known product leaders in Asia. When I asked people who their favorite product leader is in Asia, Vikrama's name has come up almost more than anyone else's. We chat about how to move into product management, how to be a great product manager, how product managers often shoot themselves in the foot, and so much more. With that, I bring you Vikrama Dhiman after a short word from our sponsors. And if you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. It's the best way to avoid missing future episodes and it helps the podcast tremendously.

**中文翻译:**
今天的嘉宾是 Vikrama Dhiman。Vikrama 在 Gojek 负责所有产品相关事务，包括产品管理、设计、项目管理、研究和洞察，团队遍布印度、新加坡和印度尼西亚。他曾任职于 Directi、Airtel、MakeMyTrip 和 WizIQ 等公司，是亚洲最知名的产品领导者之一。当我问及亚洲最受欢迎的产品领导者时，Vikrama 的名字被提到的次数几乎是最多的。我们聊到了如何转型进入产品管理领域、如何成为一名优秀的产品经理、产品经理常犯的错误等等。在听完赞助商的简短介绍后，我们将迎来 Vikrama Dhiman。如果你喜欢这个播客，别忘了在你的播客应用或 YouTube 上订阅和关注。这是避免错过未来节目的最好方式，也对本播客有巨大的帮助。

---

### (00:01:45) Lenny Rachitsky

**English:**
This episode is brought to you by Uizard, empowering product leaders to ideate and iterate faster than ever before with the power of AI. As a product manager, I often spend hours taking screenshots and then annotating them with feedback for my team. With Uizard, I can simply upload my screenshot and Uizard's AI will turn them into a fully editable UI design that I can then take, make tweaks to, and then share with my teams in minutes. And when I want to get really creative and explore totally new ways to improve our product experience, I can use Uizard's AI to generate new design concepts from simple text prompts and turn them into interactive prototypes effortlessly. There's a reason that over 2.6 million people have trusted Uizard to accelerate every phase of their product life cycle and speed up time to market. Developers can even export UI components to React and CSS to speed up their development. Uizard's drag and drop editor is super easy to use and you can collaborate in real time with your entire team. Even your CEO and customer service teams can contribute. Unlock all of Uizard's game-changing AI-powered features and more with 25% off Uizard's Pro annual plan. Visit U-I-Z-A-R-D.io/lenny and use code Lenny to check out today. That's U-I-Z-A-R-D.io/lenny.

**中文翻译:**
本集节目由 Uizard 赞助。Uizard 利用 AI 的力量，助力产品领导者以前所未有的速度进行构思和迭代。作为一名产品经理，我经常花几个小时截屏，然后为团队标注反馈。有了 Uizard，我只需上传截图，它的 AI 就能将其转化为完全可编辑的 UI 设计，我可以在几分钟内进行微调并分享给团队。当我想要发挥创意、探索改进产品体验的全新方式时，我可以使用 Uizard 的 AI 根据简单的文本提示生成新的设计概念，并毫不费力地将其转化为交互式原型。超过 260 万人信任 Uizard 来加速产品生命周期的每个阶段并缩短上市时间，这是有原因的。开发人员甚至可以将 UI 组件导出为 React 和 CSS，以加快开发速度。Uizard 的拖放式编辑器非常易于使用，你可以与整个团队实时协作，甚至你的 CEO 和客服团队也可以参与其中。现在访问 U-I-Z-A-R-D.io/lenny 并使用代码 Lenny，即可享受 Uizard Pro 年度计划 75 折优惠，解锁所有颠覆性的 AI 功能。

---

### (00:02:48) Lenny Rachitsky

**English:**
This episode is brought to you by Webflow. We're all friends here, so let's be real for a second. We all know that your website shouldn't be a static asset, it should be a dynamic part of your strategy that drives conversions. That's business 101. But here's a number for you. 54% of leaders say web updates take too long, that's over half of you listening right now. That's where Webflow comes in. Their visual-first platform allows you to build, launch, and optimize web pages fast. That means you can set ambitious business goals and your site can rise to the challenge. Learn how teams like Dropbox, Ideo and Orangetheory trust Webflow to achieve their most ambitious goals today at webflow.com.

**中文翻译:**
本集节目由 Webflow 赞助。大家都是朋友，咱们实话实说。我们都知道网站不应该是一个静态资产，它应该是你驱动转化的动态战略的一部分。这是商业常识。但这里有一个数据：54% 的领导者表示网站更新耗时太长，这涵盖了现在正在收听节目的一半以上的人。这就是 Webflow 的用武之地。他们的视觉优先平台让你能够快速构建、发布和优化网页。这意味着你可以设定宏大的业务目标，而你的网站能够应对挑战。立即访问 webflow.com，了解 Dropbox、Ideo 和 Orangetheory 等团队如何信任 Webflow 来实现他们最宏伟的目标。

---

### (00:03:56) Lenny Rachitsky

**English:**
Vikrama, thank you so much for being here and welcome to the podcast.

**中文翻译:**
Vikrama，非常感谢你能来到这里，欢迎参加我们的播客。

---

### (00:04:00) Vikrama Dhiman

**English:**
Thank you for inviting me, Lenny. I'm very excited to be here.

**中文翻译:**
谢谢你的邀请，Lenny。我很高兴能来到这里。

---

### (00:04:03) Lenny Rachitsky

**English:**
So as you know and hopefully as listeners know, I'm on this quest to meet the most insightful product leaders from all over the world and your name has come up more times than almost any other product person when I ask people for their favorite product leaders in Asia. And you're also the third guest from Gojek, so there's definitely something in the water over there and I want to talk about that. To just dive right in, you have a very strong reputation for building incredibly strong product talent and also design talent, and also helping people transition from other roles into product management, which a lot of people listening to this podcast dream to do. So I'm going to ask a bunch of questions around this area. How does that sound?

**中文翻译:**
如你所知，也希望听众们知道，我一直在寻找全球最有见地的产品领导者。当我询问大家亚洲最受欢迎的产品领导者时，你的名字出现的次数几乎比其他任何人都多。你也是来自 Gojek 的第三位嘉宾，所以那里的“水”一定有什么特别之处（指公司文化或人才密度），我想聊聊这个。直接进入正题，你在培养顶尖产品人才和设计人才方面享有盛誉，同时也擅长帮助人们从其他岗位转型到产品管理，这是很多听众梦寐以求的事情。所以我会围绕这个领域问一系列问题，你觉得怎么样？

---

### (00:04:47) Vikrama Dhiman

**English:**
Sounds good.

**中文翻译:**
听起来不错。

---

### (00:04:48) Lenny Rachitsky

**English:**
Okay. First question is just when you think back to the people that have done best in the product management role and have had a rapid career rise, what are some of the most common traits or behaviors or habits that you find in these people?

**中文翻译:**
好的。第一个问题是，当你回想那些在产品管理岗位上表现最出色、职业生涯晋升最快的人时，你发现这些人身上有哪些共同的特质、行为或习惯？

---

### (00:05:05) Vikrama Dhiman

**English:**
Over the last decade and a half, I've had the opportunity to work with some really strong product managers, learn from strong product managers, and some of them have had rapid career growth. When I was younger and I was starting off, I used to think it's all about the product. If you've got a really cool product to work on, your growth's guaranteed. And if you got really a product which no one cares about or a stream which no one cares about, then your growth is going to be slightly slower. But as I started seeing more and more product managers at their craft, I saw that working on a cool product area is not the only thing. In fact, sometimes some product managers would come back and complain that despite their product doing really well, they've not really grown.
(00:05:51):
And while some other product managers whose product didn't have the impact really grew. And as I started looking at it and as I started making notes, as I started talking to other product leaders, what I discovered was that the really strong product managers who were also growing in their careers did some things differently. And based on that, I created a career growth framework for product managers, which comprises of three things, and I call it three W's. So what you produce, what you bring to the table, and what's your operating model? The really strong product managers are good at usually two of the three things. The ones who rise and when they are rising, they are performing well on all the three access. So if you would like, let's talk a little bit more about each one of these W's.

**中文翻译:**
在过去的十五年里，我有机会与一些非常优秀的产品经理共事，向他们学习，其中一些人的职业生涯增长非常迅速。当我年轻刚起步时，我曾认为一切都取决于产品。如果你负责一个非常酷的产品，你的成长就有保障；如果你负责一个没人关心的产品或业务流，你的成长就会慢一些。但随着我观察到越来越多的产品经理磨练他们的技艺，我发现负责酷的产品领域并不是唯一的事情。事实上，有时一些产品经理会抱怨，尽管他们的产品表现很好，但他们自己并没有真正成长。
(00:05:51):
而另一些产品经理，尽管他们的产品影响力一般，却获得了巨大的成长。当我开始观察、做笔记并与其他产品领导者交流时，我发现那些职业生涯不断晋升的顶尖产品经理在某些事情上的做法与众不同。基于此，我为产品经理创建了一个职业成长框架，包含三个方面，我称之为“3W”。即：你的产出（What you produce）、你带来的价值（What you bring to the table）以及你的运作模式（What's your operating model）。非常优秀的产品经理通常擅长这三点中的两点。而那些能够快速晋升的人，在晋升期间通常在这三个维度上都表现出色。如果你愿意，我们可以详细聊聊这每一个 W。

---

### (00:06:49) Lenny Rachitsky

**English:**
Yeah, I would love to. I love that you put the word what at the top and that makes it the three W's, which is clever because I find even if the acronym is not necessary, it's really helpful to help people remember so I totally respect what you did there. So the three is what you produce, what you bring to the table and what your operating model is. Is that right?

**中文翻译:**
是的，我很想听。我喜欢你把 "What" 放在首位，构成了 3W，这很聪明，因为我发现即使缩写不是必须的，但它确实有助于人们记忆，所以我非常认可你的做法。那么这三点是：你的产出、你带来的价值以及你的运作模式。对吗？

---

### (00:07:09) Vikrama Dhiman

**English:**
Yes, absolute.

**中文翻译:**
是的，完全正确。

---

### (00:07:09) Lenny Rachitsky

**English:**
Okay, cool. Yeah, let's talk about these.

**中文翻译:**
好的，太棒了。那我们来聊聊这些。

---

### (00:07:11) Vikrama Dhiman

**English:**
So what you produce, a lot of people index on the impact while and they start thinking about goals, they start thinking about direction and they start thinking about strategy. While it is important to know at what stage of the career you are and what kind of a product that you are working on, the very first thing that anyone, when you're starting off, produces is outputs, okay? The output can be launching a product, it can be analyzing and running an experiment, and it could even be just being a part of the team and contributing to a go-to market strategy. So focus on that output significantly. As you get comfortable with output and you start getting comfortable with working with different stakeholders, you start controlling what outputs are necessary, which is when you move to the outcomes. Outcomes are product areas, goals that you can own and or collaborate with other stakeholders on.
(00:08:14):
And when you start figuring out which outcomes are necessary, that is when you move to the leadership and directional areas. The mistake that I see a lot of product managers make is they start operating in either output or outcomes. And when you are transitioning to outcomes, it's very important that you continue to still hone your craft on outputs. For instance, do you just give up on the go-to-market strategy or do you start making product nodes which are then picked up by marketing people and are able to be used to create that go-to-market strategy? You always, always have to have the output and outcome even when you're moving up the so-called career management ladder. So that is very, very critical that as you are producing, even when you are at the senior most levels, don't forget your IC roots, don't forget the IC component. And sometimes it is necessary to just pull up your sleeves and go back and keep working on those things. That also gives you a lot of creds with others in the team as well.

**中文翻译:**
关于“你的产出（What you produce）”，很多人会过度关注影响力（impact），他们开始思考目标、方向和战略。虽然了解自己处于职业生涯的哪个阶段以及负责什么样的产品很重要，但任何人在起步阶段产出的第一样东西就是“产出物（outputs）”。产出物可以是发布一个产品，可以是分析并运行一个实验，甚至可以只是作为团队的一员为进入市场（GTM）战略做出贡献。所以要重点关注这些产出物。当你对产出物驾轻就熟，并开始习惯与不同利益相关者合作时，你开始控制哪些产出是必要的，这时你就转向了“成果（outcomes）”。成果是你能够独立负责或与其他利益相关者协作的产品领域目标。
(00:08:14):
当你开始弄清楚哪些成果是必要的，那就是你转向领导力和方向性领域的时候。我看到很多产品经理犯的错误是，他们要么只停留在产出物层面，要么只关注成果。当你向成果转型时，继续磨练产出物的技艺非常重要。例如，你是直接放弃 GTM 战略，还是开始撰写产品笔记，让市场人员能够据此制定 GTM 战略？即使你在所谓的职业阶梯上不断攀升，你也必须始终兼顾产出物和成果。这一点非常关键：即使你处于最高级别，也不要忘记你的 IC（独立贡献者）根基。有时有必要卷起袖子，回去继续做那些具体的工作。这也会让你在团队中赢得很多信誉。

---

### (00:09:20) Lenny Rachitsky

**English:**
So highlighting one insight here is that a lot of advice you hear about how to do well in your career, which you pointed out at the beginning here, is it's not just not immediately drive impact. That's not necessarily what you need to obsess over, which is actually what I recommend to people is just find ways to have impact. So this is really interesting. Your advice is early in your career, focus on just getting stuff out and done. Don't so obsess with the impact. Can you talk more about just what, when you say output, what are you describing there? Is it just ship products and be helpful and produce something?

**中文翻译:**
这里强调一个见解：正如你开头指出的，关于如何做好职业生涯的很多建议，并不只是让你立即产生影响力。那不一定是你要痴迷的东西，而我通常建议人们寻找产生影响力的方法。所以这很有趣。你的建议是，在职业生涯早期，专注于把事情做出来并完成，不要太纠结于影响力。你能多谈谈你所说的“产出物（output）”具体指什么吗？是仅仅发布产品、提供帮助并产出一些东西吗？

---

### (00:09:51) Vikrama Dhiman

**English:**
Absolutely. So outputs is shipping products, but it also comes in smaller things. For instance, if you are sourcing content for your homepage, what are the different avenues that you can source content from? What is the easiest to source? What is the most difficult to source? Just ranking it all in that order goes a long way. And one of the product managers actually did that yesterday and I went, wow, it just made my life so much simpler. And not just my life but so many other people's lives so much simpler, and we were able to take that specific output and use it as part of our overall strategy. If that PM would have obsessed about the overall content strategy, overall how we are going to do it versus just how we are going to be sourcing it, they would have indexed on something bigger and maybe would have not even been able to make that impact. But now, they were able to show something which was a small part, which was an output, but it fell into the overall outcome.

**中文翻译:**
当然。产出物包括发布产品，但也体现在更小的事情上。例如，如果你正在为首页寻找内容来源，有哪些不同的渠道？哪个最容易？哪个最难？仅仅按顺序对它们进行排名就大有裨益。昨天就有一位产品经理这么做了，我当时心想：哇，这让我的工作简单多了。不仅是我，很多人的工作都变简单了，我们能够把这个具体的产出物作为整体战略的一部分。如果那个 PM 纠结于整体内容战略、整体方案，而不是仅仅关注如何获取内容，他们可能会把精力放在更大的事情上，甚至可能无法产生任何影响。但现在，他们展示了一个小部分，这是一个产出物，但它融入了整体成果中。

---

### (00:10:54) Lenny Rachitsky

**English:**
The way I think about what you're describing, which I actually 100% agree with, is when you're starting out in your careers, execution is where you need to deliver. People just want you to get stuff done when you're just starting out. It's not like help us define our strategy and vision for the next three years. We just have stuff we need done. Can you help us get it done? Well, yes. And then essentially the advice is as you get more senior, you'll have more opportunity to think about strategy and what to build versus just how to build it and actually execute on it.

**中文翻译:**
我对你所描述的内容的理解是（我百分之百同意），当你刚开始职业生涯时，执行力是你需要交付的东西。当你刚起步时，人们只想让你把事情办成。他们不会说“帮我们定义未来三年的战略和愿景”，他们只是有事情需要完成。你能帮我们搞定吗？能。本质上的建议是，随着你变得更资深，你将有更多机会思考战略以及“该建造什么”，而不仅仅是“如何建造”并实际执行。

---

### (00:11:25) Vikrama Dhiman

**English:**
Absolutely. So focus on outputs at the start of your careers and don't forget outputs even when you grow in your career.

**中文翻译:**
没错。所以在职业生涯初期要专注于产出物，即使在职业生涯成长后也不要忘记产出物。

---

### (00:11:33) Lenny Rachitsky

**English:**
So along those lines, just to close the thread on this idea, it's still helpful if you work on something that does have impact that matters, right? How important is that? And you said that you've seen successful product managers work on things that aren't as impactful and still do really well, but I guess would your advice be tried [inaudible 00:11:52] be in a place that is going to drive more impact versus it's not actually that important in the early career?

**中文翻译:**
顺着这个思路，为了结束这个话题，如果你负责的事情确实有重大影响力，那还是很有帮助的，对吧？这有多重要？你说过你见过成功的产品经理负责一些影响力不大的事情，但依然表现出色。但我想问，你的建议是尽量去一个能产生更多影响力的地方，还是说在职业生涯早期这其实并不那么重要？

---

### (00:11:58) Vikrama Dhiman

**English:**
So I'll give you my example. In one of my previous roles, there were two product areas that were important for the organization. My product area ended up being the center and focus of the organization, yet the product manager who was chosen to lead the area when it became big wasn't me. It was someone else. At that time, I really felt very bad that okay, why did that happen? But now when I look back, I can see why that happened because that product manager was so much better at the overall craft of output, yet when they were focusing on outcome, we're not forgetting the output as well. So they were just better at me on launching products, they were better at me on working with design, in producing design artwork, and they were definitely better than me in running the experiments as well.

**中文翻译:**
我给你举个我自己的例子。在我之前的一个职位中，组织有两个重要的产品领域。我的产品领域最终成为了组织的中心和焦点，然而，当这个领域变大时，被选中领导该领域的产品经理并不是我，而是别人。当时我感觉非常糟糕，心想：为什么会这样？但现在回过头来看，我明白了原因。因为那位产品经理在产出物的整体技艺上比我强得多，而且当他们关注成果时，也没有忘记产出物。他们在发布产品、与设计团队合作产出设计稿，以及运行实验方面都明显比我更出色。

---

### (00:12:49) Lenny Rachitsky

**English:**
I love that. Yeah, basically when you're just starting out, just execute well, execute smoothly, ship things on time. I'm going to say a few things, but I'm curious what else comes to mind here of just what does good output look like? Is it do things that are helpful to your team and manager, ship things on time, bug-free, have a clean road map, everyone's aligned behind, [inaudible 00:13:11] deadlines, things like that. I guess what else along those lines should people be like, "Okay, here's what I should be doing to have good outputs?"

**中文翻译:**
我喜欢这个观点。基本上当你刚起步时，只要执行得好、执行得顺畅、按时交付就行。我列举几点，但我很好奇你还能想到什么：优秀的产出物长什么样？是做对团队和经理有帮助的事、按时交付、没有 Bug、有一份清晰且大家都认同的路线图、遵守截止日期之类的吗？除此之外，人们还应该做些什么来拥有“优秀的产出物”？

---

### (00:13:16) Vikrama Dhiman

**English:**
Some of the things that I think are useful. So first, what's output? Output is something which is very tangibly defined, which doesn't take too much of your time, effort, and energy to visualize and think and strategize over and you are able to quickly get moving on. Go and ask your product leader, go and ask other leaders on what are the areas they are blocked on. Sometimes they will be blocked on, "Hey, I need to prepare this brief for this particular summit", "I need to prepare this particular slide for a leadership review", "I need to prepare a review, I need to prepare a review which has to be done with the legal." You can volunteer and definitely own and deliver the first drafts of those even if the final draft is not something that you own. That's a simple example of an output, which I feel a lot of people miss because they want to be focusing on the bigger strategic pieces.

**中文翻译:**
我认为有一些事情很有用。首先，什么是产出物？产出物是定义非常具体的东西，不需要你花费太多时间、精力和能量去构思、思考和制定战略，你可以迅速行动。去问问你的产品领导或其他领导，他们在哪些方面遇到了阻碍。有时他们会卡在：“嘿，我需要为这个峰会准备一份简报”，“我需要为领导层审查准备这张幻灯片”，“我需要准备一份需要法务审核的审查报告”。你可以主动请缨，负责并交付这些文件的初稿，即使最终定稿不归你管。这是一个产出物的简单例子，我觉得很多人都忽略了这一点，因为他们只想关注更大的战略层面。

---

### (00:14:16) Lenny Rachitsky

**English:**
It's basically be useful. That's the way I always like to talk about this, just like your job as a PM is be useful, make your team more effective, help your company be more successful. Just find ways to be useful to everyone around you.

**中文翻译:**
基本上就是“变得有用”。我总是喜欢这样描述：作为 PM，你的工作就是变得有用，让你的团队更高效，帮助你的公司更成功。只要想办法对周围的每个人都有用就行了。

---

### (00:14:27) Vikrama Dhiman

**English:**
Absolutely. And be useful in doing the small things which make an impact and also contribute to your learning versus being useful in areas which you think the mini CEO should be working on.

**中文翻译:**
没错。在做那些能产生影响并有助于你学习的小事上变得有用，而不是在你认为“迷你 CEO”应该负责的领域里表现得有用。

---

### (00:14:44) Lenny Rachitsky

**English:**
Right. There's all this talk about being an empowered product manager, building empowered product teams. I think there's an important nuance. When you're just starting out, you haven't earned the right to inform strategy and vision people. Why would people follow you at this point? We just need to get stuff done, so that comes over time.

**中文翻译:**
对。现在有很多关于“赋能型产品经理（empowered PM）”和建立“赋能型产品团队”的讨论。我认为这里有一个重要的细微差别。当你刚起步时，你还没有赢得主导战略和愿景的权利。这时候人们为什么要追随你？我们只需要把事情办好，那些权利是随着时间推移而获得的。

---

### (00:15:01) Vikrama Dhiman

**English:**
Absolutely. And it's not just when you are starting off or when you are young. Even with if you are senior and you're starting off with a new team, even if you're starting with a new company, you need to have that mindset. And sometimes you will not know the best. And we'll talk more about how to, what is your operating model, which is how you work with others. It's a very, very important thing for you to know that you are one part of the cog wheel, you're not the entire wheel yourself. And a lot of the folklore around product managers can make you confused, especially when you're starting off in your career.

**中文翻译:**
完全正确。而且这不仅仅针对起步阶段或年轻人。即使你很资深，当你加入一个新团队或新公司时，你也需要这种心态。有时你并不了解最优秀的方法。我们稍后会详细讨论“运作模式”，即你如何与他人合作。让你意识到自己只是齿轮的一部分，而不是整个轮子本身，这非常重要。关于产品经理的很多传闻（比如迷你 CEO）可能会让你感到困惑，尤其是在职业生涯初期。

---

### (00:15:40) Lenny Rachitsky

**English:**
I love it. Okay, let's keep going. Number two.

**中文翻译:**
太棒了。好的，我们继续。第二点。

---

### (00:15:43) Vikrama Dhiman

**English:**
Number two is what you bring to the table. Now, I think how I describe that is what is your impact on impact? So the first access is impact, but you also need to have an impact on impact. And this is what I had missed a lot in my early career, that you put the coolest product areas, your product area is successful and that automatically guarantees your growth. It doesn't. You have to also show that yes, you were a useful contributor to having that particular impact. The simplest thing on this is that is your PRD quality good enough? Are you writing that the draft notes that go and circulate to the care teams, to the marketing teams and so on? Are you making sure that you are deriving from the strategy that has been shaped or you're constantly just pushing back on the strategy? Similarly, you also how you are drafting the north stars, how you are working on the experiments, how you're working on the data, how you're working on the metrics.
(00:16:43):
All these things take time, effort, and energy. And I know there is some literature and there are some operating models where people are working only at strategy levels while all of these execution of these artifacts is being done by some other people. I don't think, especially when you are starting off, that's a very, very good thing. Even when you are mid-senior, I don't think that's a very, very good thing. You have to have to be able to produce these artifacts which are product artifacts. Even if there are people in strategy creating their artifacts, even if design is coming up with a design brief, you need to have a cohesive product strategy or product PRD and work backwards from PRD and product knows yourself. These things are important to show you are progressing on four pillars, which is data and metrics, design and research, technology skills, and strategy.
(00:17:41):
Product managers constantly are evaluated on this when you interview, but you also have to demonstrate these on the jobs. And the best way to demonstrate these is through the artifacts, through the notes that you are sending. So you must have that impact to impact through the artifacts that you work on. For a lot of product managers, when I ask, "Hey, I was working on this very impactful area. I'm not able to have the impact on my career, what is missing?" And when I go and ask, "Can you show me your last PRD? Can you show me the last product note that you sent? Can you show me the product strategy doc that you have or collaborated on? Can you show me the brief that you sent to the design team on the problems and the ranking of those problems?" Usually, you'll find something or the other missing.
(00:18:31):
In cases that those are bad, you will find that the pre-iteration planning, pre-sprint plannings are not running properly. You will find that the Jira storyboards are very empty and there's just a title in the subject and nothing gets described and so on. So you'll miss all these pieces. So these are the things which you bring to the table and it's very, very important that you work on these aspects as well. Finally, we have what's your operating model, which I feel is the most important thing which you have to have to focus if you are going from mid-senior to senior level. This is essentially about communication, collaboration, organizational skills and community skills.
(00:19:16):
And across product managers, again, because of the folklore of mini CEO and others, I see that a lot of people get carried away in the way they operate as product managers with other stakeholders. There are three tenets that I define in working well as a product manager with others. Number one is raise difficult issues without being difficult to work with. Bring out important topics without drawing importance to yourself. And finally, you are in charge of getting the decisions made and not making all the decisions yourself. I think as long as you follow these three tenets, you will have a successful relationship across stakeholders. These three tenets are easy to say, but they become very, very hard to embody and display on a day-to-day basis. But this is essentially going to be your struggle no matter at what level of product management you are operating at in your career or within your company.

**中文翻译:**
第二点是“你带来的价值（What you bring to the table）”。我将其描述为：你对“影响力”的影响力是什么？第一个维度是影响力，但你还需要对影响力产生影响。这是我职业生涯早期忽略的一点：你负责最酷的产品领域，产品成功了，这并不能自动保证你的成长。你还必须证明，你是产生该影响力的有用贡献者。最简单的一点是：你的 PRD 质量够好吗？你写的那些传阅给客服团队、市场团队的草案笔记质量如何？你是在确保自己遵循既定战略，还是在不断地抵触战略？同样，你如何起草北极星指标（North Stars）、如何进行实验、如何处理数据、如何处理指标？
(00:16:43):
所有这些都需要时间、精力和能量。我知道有些理论和运作模式认为人们应该只在战略层面工作，而所有这些交付物的执行都由别人完成。我不认为这在起步阶段是一件好事，即使是中高级别，我也不认为这是好事。你必须能够产出这些产品交付物。即使有战略人员在创建他们的交付物，即使设计团队在制定设计简报，你也需要有一个连贯的产品战略或产品 PRD，并从 PRD 和产品笔记中反向推导。这些对于展示你在四个支柱上的进步至关重要：数据与指标、设计与研究、技术技能以及战略。
(00:17:41):
产品经理在面试时经常被评估这些能力，但你也必须在工作中展示它们。展示这些能力的最佳方式就是通过你发送的交付物和笔记。所以你必须通过你负责的交付物来产生这种“对影响力的影响力”。对于很多产品经理，当我问：“嘿，我负责这个非常有影响力的领域，但我的职业生涯却没有受到影响，缺了什么？”当我问：“能给我看看你最近的 PRD 吗？能给我看看你发的最后一份产品笔记吗？能给我看看你撰写或协作的产品战略文档吗？能给我看看你发给设计团队的关于问题及其排序的简报吗？”通常你会发现总有缺失。
(00:18:31):
如果这些做得不好，你会发现迭代前计划、冲刺前计划运行不顺。你会发现 Jira 看板非常空，只有标题，没有描述等等。你会错过所有这些环节。所以这些就是你带来的价值，在这些方面下功夫非常重要。最后，是“你的运作模式（What's your operating model）”，我觉得如果你想从中高级晋升到高级水平，这是你必须关注的最重要的事情。这本质上关乎沟通、协作、组织能力和社区能力。
(00:19:16):
在产品经理中，再次因为“迷你 CEO”等传闻，我看到很多人在与其他利益相关者合作时有些忘乎所以。我定义了产品经理与他人良好合作的三个准则。第一：提出困难的问题，但不要成为一个难以共事的人。第二：提出重要的话题，但不要把重点引向你自己。第三：你负责推动决策的达成，而不是由你一个人做所有的决定。我认为只要你遵循这三个准则，你就能与利益相关者建立成功的关系。这三个准则说起来容易，但在日常工作中体现出来却非常难。但无论你处于职业生涯的哪个阶段或在公司的哪个级别，这本质上都将是你需要努力的方向。

---

### (00:20:28) Lenny Rachitsky

**English:**
First of all, can you just repeat them? Because I think this is... Essentially, it's like a mantra that PMs can think back to of, "Am I doing these things?"

**中文翻译:**
首先，你能重复一下那三点吗？因为我觉得这本质上就像 PM 可以回想的口诀：“我做到这些了吗？”

---

### (00:20:36) Vikrama Dhiman

**English:**
So the three things which are very important for product managers to work with others and other stakeholders are raise difficult issues without being difficult to work with, bring out important topics without drawing importance to yourself, and be able to get decisions made without having to make all the decisions yourself.

**中文翻译:**
产品经理与他人及利益相关者合作非常重要的三件事是：提出困难的问题，但不要成为一个难以共事的人；提出重要的话题，但不要把重点引向你自己；能够推动决策达成，而不必由你一个人做所有决定。

---

### (00:21:02) Lenny Rachitsky

**English:**
I like this list a lot. It reminds me, there's this product leader I worked with who their team got pushed to do a bunch of stupid stuff. And he realized later that, "Hey, it's actually my job to have pushed back on doing this stuff." He was the head of product for this business unit and he realized, "Oh, I see. That's actually what I should be doing now that I'm in this role." And you sometimes forget that one, you have that influence. And two, that's something you should be doing.

**中文翻译:**
我很喜欢这张清单。这让我想起我曾共事过的一位产品领导者，他的团队被迫做了一堆蠢事。他后来意识到：“嘿，拒绝做这些事其实是我的职责。”他是那个业务单元的产品负责人，他意识到：“哦，我明白了，既然在这个职位上，这正是我应该做的。”你有时会忘记：第一，你有这种影响力；第二，那是你应该做的事。

---

### (00:21:33) Vikrama Dhiman

**English:**
Absolutely, absolutely. It's always within your control and it's always the things that are within your control that you should be controlling rather than focusing on the things that are not within your control and obsessing about those.

**中文翻译:**
没错，完全正确。这始终在你的控制范围内，你应该控制那些你能控制的事情，而不是把精力放在你无法控制的事情上并为此纠结。

---

### (00:21:49) Lenny Rachitsky

**English:**
I'm so aligned with the way you think about all these things. Coming back to the second actually, just to give people something they can do with this trait. So the way I think about what you described, and correct me if I'm misinterpreting it, is there's a detail-oriented-ness, high quality-ness to the way that you should be crafting all the documents/artifacts you're creating, your one-pagers/PRDs, your roadmaps, your strategy docs, just like they should be really high quality. So along those lines, if you're an ICPM trying to get better at this stuff, how have you found is the best way to level up in these things? Is it working with your manager and getting feedback? Is it peers? What helps somebody get better at the quality and yeah, the quality of these documents?

**中文翻译:**
我非常认同你对这些事情的看法。回到第二点，为了给人们一些实际可操作的建议。我对你所描述的内容的理解是（如果我理解错了请纠正我）：在你创作的所有文档/交付物（如 One-pagers、PRD、路线图、战略文档）中，应该体现出一种对细节的关注和高质量。那么，如果你是一名想要在这些方面提升的 IC PM（独立贡献者 PM），你发现提升这些能力的最佳途径是什么？是与经理合作并获取反馈吗？还是通过同事？什么能帮助一个人提高这些文档的质量？

---

### (00:22:34) Vikrama Dhiman

**English:**
What you bring to the table is one of the most misunderstood attributes and aspects of product management. On one end, you could get around and say, "Here is my PRD, here is my JIRA board, here are my stories, here is my pre-sprint planning or pre-iteration planning document" and go. It's not just about the spread and the width of the things that you're doing, but it's also about the depth of those things as well. Some product managers, what they bring to the table is arguments, what they bring to the table are debates, what they bring to the table are pushbacks, while others are able to channelize the questions, channelize the inputs, channelize the direction and convert that into strategic choices which can then shape discussions, which can then shape direction. Be the latter and you will rise faster in your career.

**中文翻译:**
“你带来的价值”是产品管理中最容易被误解的属性和方面之一。一方面，你可以只是说：“这是我的 PRD，这是我的 JIRA 看板，这是我的 User Stories，这是我的冲刺前或迭代前计划文档”，然后就完事了。但这不仅仅关乎你所做事情的广度，更关乎深度。有些产品经理带到桌面上的是争吵、辩论和抵触；而另一些人则能够引导问题、引导输入、引导方向，并将其转化为战略选择，从而塑造讨论和方向。成为后者，你的职业生涯会晋升得更快。

---

### (00:23:26) Lenny Rachitsky

**English:**
So you have these three buckets of what you produce, what you bring to the table, and what your operating model is, the three W's. So let try to summarize and see what I missed and then we'll move on. So one is just focus on executing, getting things done that are helpful to your team, your company, your manager, and focus on just getting stuff out. Not so much in necessarily in strategy. Even when you're a manager and a leader and a VP, just like you're still responsible for producing things, not just telling people and being wise. Two, what you bring to the table, my takeaway here is produce high quality artifacts that raise the bar.
(00:24:05):
The way I think about this is as a PM, you want to have this aura of I got this. People put something on your plate, you want to feel like Lenny's got this, I'm not going to have to worry. It's going to be forgotten and I know it's going to be done well. And then the third piece is this idea of an operating model. Basically just make sure decisions are being made. It's not about you that you're pushing back on bad ideas. Is there anything else I missed before we move on?

**中文翻译:**
所以你有这三个维度：你的产出、你带来的价值以及你的运作模式，即 3W。让我试着总结一下，看看我漏掉了什么，然后我们继续。第一，专注于执行，完成对团队、公司和经理有帮助的事情，专注于把东西做出来。不一定非要纠结于战略。即使你是经理、领导或 VP，你仍然有责任产出具体的东西，而不仅仅是发号施令或表现得很睿智。第二，关于你带来的价值，我的理解是产出高质量的交付物来提高标准。
(00:24:05):
我的想法是，作为一名 PM，你希望拥有一种“我能搞定”的气场。当人们把事情交给你时，他们会觉得“Lenny 能搞定，我不用担心了”。事情交给你后就可以放心，而且我知道它会被做得很好。第三点是运作模式。基本上就是确保决策得以制定。重点不在于你，而在于你拒绝了坏主意。在我们继续之前，还有什么我漏掉的吗？

---

### (00:24:31) Vikrama Dhiman

**English:**
No. I think the art of pushback is another important factor because if you're pushing back a lot and the way you are pushing back matters a lot as well. Just don't be someone who's seen as an obstacle and a hindrance and as someone who's just very difficult to work with, but rather see as someone who's able to actually add value to whatever your leader, your stakeholders, your product area demands and you are able to advance the product and the direction and execution forward. Once you do that, I think keeping that as the intent and ensuring that your team is getting unblocked and not getting to do work on anything which is stupid or is likely to be changed, then you've really got it.

**中文翻译:**
没有。我认为“拒绝的艺术（art of pushback）”是另一个重要因素，因为如果你经常拒绝，拒绝的方式也非常重要。不要成为一个被视为障碍、阻力或难以共事的人，而要成为一个能够为领导、利益相关者或产品领域的需求真正增加价值的人，并且能够推动产品、方向和执行向前发展。一旦你做到了这一点，并以此为初衷，确保你的团队不再受阻，不再做愚蠢或可能被更改的工作，那么你就真正掌握了精髓。

---

### (00:25:23) Lenny Rachitsky

**English:**
Do you have any advice for how to pushback in a way, the way you describe it is not to be difficult to work with or without seeking importance? I guess is there words or phrases or approaches you found are effective for pushing back against ideas that you disagree with?

**中文翻译:**
关于如何以一种“不难共事”或“不显摆自己重要性”的方式进行拒绝，你有什么建议吗？有没有什么词汇、短语或方法是你发现对于拒绝你不同意的想法特别有效的？

---

### (00:25:38) Vikrama Dhiman

**English:**
What I've seen that people who do pushback very successfully and are still considered not difficult to work with, they are also able to bring the tempo of the conversation to a more logical space from an emotional space. I think that's such a useful skill and I sometimes am guilty of operating on a slightly emotional note, which is useful. Sometimes you need a war cry, you need a high pitch, you need execution on war footing. All that is fine, but it's only fine in some cases. In other cases, it's always very important that you're able to bring it down to the logical space so that a logical and a little more equal footing of the discussion can happen. And a lot of this is something that leaders need to ensure is happening, but product managers and product leaders who are working with executives who are able to bring this tempo down and bring it to a little more logical space will also do far better in their careers and they'll also have a lot more rapid career growth.

**中文翻译:**
我观察到，那些能够成功拒绝且不被认为难共事的人，通常能够将对话的基调从感性空间带回到更理性的空间。我认为这是一项非常有用的技能。有时我也会犯带有一点情绪的错误，虽然情绪有时有用——比如你需要战斗口号、需要高昂的士气、需要进入战时状态的执行力。这些在某些情况下是可以的，但在其他情况下，能够将对话拉回到理性空间非常重要，这样才能进行逻辑清晰且地位平等的讨论。很多时候这需要领导者去确保发生，但那些能够降低情绪热度、将对话带入理性空间的产品经理和产品领导者，在职业生涯中会表现得更好，晋升也会更迅速。

---

### (00:26:55) Lenny Rachitsky

**English:**
So let talk about the flip side of rapid career growth, which is career growth that stalls. And I'm curious what you've found most impedes people's career growth. What do PMs do that shoot themselves in the foot and slow their career? Any pitfalls do you find are important to try to watch out for?

**中文翻译:**
那我们来聊聊快速成长的反面，即职业成长停滞。我很想知道你发现什么最阻碍人们的职业成长。PM 做了什么“搬起石头砸自己脚”的事情，从而减缓了他们的职业发展？你觉得有哪些重要的陷阱需要注意？

---

### (00:27:15) Vikrama Dhiman

**English:**
I think part of it is on a lot of us in product leadership space. We've not done a very good job in defining rubrics, growth frameworks and so on. But even in places where growth frameworks exist, like three W's, what I've seen is that clean mindset shifts and changes can enable faster growth, but those mindset and changes also can hinder your growth, right? So the first thing is whether you are focusing on things you control or whether you're focusing on things that are beyond your control. Second, what's your relationship with change? And third is how you see yourself. The third is very, very powerful and we'll talk about that as well. The first is what you control. If you drew an access of what you control and what you cannot control, as you're starting your career, most of the work that you're doing is in what you control, right?
(00:28:15):
You are very obsessed with feedback, you're very obsessed with, "Okay, can I do this?" "Can I do this?" "Okay, I'll probably not do this. I'll probably do this", and so on. You're not worrying about the overall corporate strategy, you're not looking at what the competitors are doing, what is their market cap and all those things. You're focused a lot on your craft, you're focused on a lot on your output and you're focused on how you are growing. As you start becoming mid-senior, I see the conversation shifts from what can I do, how am I learning, how am I growing, to why is the organization not doing this for me? Why can that stakeholder not change this thing about themselves? Why do I not get to work on projects like this? Things which start going outside your control. And it is very, very important that you keep your focus no matter what stage of career you get into what you can control.
(00:29:16):
And again, it's easy to say that everything in universe should be in your control. It doesn't happen like that, but a large number of things that impact your career are within your control. And go back to the three W's that we spoke about, what you work on, what you produce or what do you bring to the table, and what's your operating model? And there is tons to do on data, tons to do on technology, tons to do on communication, collaboration, design and research, strategy and community. And you can spend years and years and years crafting those things. Focus on those things, growth will happen at every single stage. The second aspect of it is your relationship with change. Again, when you are younger, when you're starting off, rate of change is crazy. You are growing almost every six months. You are picking up skills and experimentation, you're picking up skills in how to analyze.
(00:30:15):
You're picking up skills in how to work with different kind of stakeholders. And since the rate of change of your skills is high, your rate of growth is also high. Again, as you start becoming mid-senior, I start seeing conversations on, "Okay, maybe I should not do that. Maybe I should not take on this product. I don't know what it means for my career. I don't know what it means for my growth" and so on. So your rate of change slows down. So it's very important that as you get to mid-senior level, you are constantly checking on what you can do to keep increasing your rate of change. And one of the simplest things that you can do is if you think you are four on data, figure out who. And you may be four on data out of five in data. Within your organization, start benchmarking yourself with the best in the industry.
(00:31:13):
You'll automatically see that your scale drops and as your scale drops, you start seeing what you need to improve and do. If you start seeing that on communication and collaboration, you're reaching four out of five within the PMR, start mapping yourself to other stakeholders in other functions. Again, your score will fall in your eyes and you will start figuring out what are the things that you can do as well. So keep your focus on rate of change and rate of growth will automatically take care of itself. Sometimes it also involves changing your team or even changing your company, but those should be the last results. There are significant things that you can do within that as well. One of the final things that I see which limits you, especially as you start growing in your career and you reach mid-senior levels is how you see yourself.
(00:32:04):
I see a lot of product... And I've been guilty of that. When I see that a lot of product managers, that's included me at some stage, doing these things, people will come back and say, "Oh, I am a very high agency PM" or, "I'm a very collaborative PM." Earlier on, I used to think that okay, I need to give this kind of work to these product managers. I need to fit them with these kind of team, these kind of work areas, these kind of opportunities. But then I started understanding these things are not just signaling, they are also anti-signaling. They are like, "Oh, I'm high agency. So it's sometimes okay if I'm little brash, if I cut corners somewhere, if I sometimes come across as a little rude to some people" and so on, right?
(00:32:55):
Similarly, if I'm seen as a hyper-collaborative person, so it's okay if sometimes I'm not very decisive, if I'm not moving fast and so on because I'm this kind of a PM. So it's very important that you check for what are the stories that you're telling yourself because those stories are defining you at a basic level, which is then very hard to correct through frameworks and structures. So figure out what is the story that you are telling yourself. If you are not able to figure that out, talk to the people you trust so that they can tell you that as well, and then correct those stories. And the moment you are able to correct those stories, you may be back on the growth path again.

**中文翻译:**
我认为部分原因在于我们这些产品领导者。我们在定义评估标准、成长框架等方面做得不够好。但即使在有成长框架（如 3W）的地方，我发现清晰的心态转变和变化可以促进更快的成长，但这些心态和变化也可能阻碍你的成长。第一点是你是否专注于你能控制的事情，还是专注于你无法控制的事情。第二点是你与“变化”的关系。第三点是你如何看待自己。第三点非常强大，我们也会聊到。首先是你能控制的事情。如果你画一个坐标轴，一边是你能控制的，一边是你不能控制的。在职业生涯初期，你做的大部分工作都在你能控制的范围内，对吧？
(00:28:15):
你非常痴迷于反馈，痴迷于“我能做这个吗？”“我能做那个吗？”“好吧，我可能不做这个，我去做那个”等等。你不会担心整体公司战略，不会看竞争对手在做什么，他们的市值是多少。你非常专注于你的技艺、产出以及你如何成长。当你进入中高级阶段，我看到对话发生了转变，从“我能做什么、我如何学习、我如何成长”变成了“为什么组织不为我做这件事？”“为什么那个利益相关者不能改变他们的做法？”“为什么我不能负责这样的项目？”这些事情开始超出你的控制范围。非常重要的一点是，无论处于职业生涯的哪个阶段，你都要专注于你能控制的事情。
(00:29:16):
当然，说“宇宙中的一切都应该在你的控制之下”很容易，但现实并非如此。然而，影响你职业生涯的大部分事情确实在你的控制范围内。回到我们说的 3W：你做什么、你产出什么（或你带来的价值）以及你的运作模式。在数据、技术、沟通、协作、设计与研究、战略和社区方面，有无数事情可以做。你可以花很多很多年去磨练这些。专注于这些，成长在每个阶段都会发生。第二个方面是你与变化的关系。当你年轻起步时，变化率是疯狂的。你几乎每六个月都在成长。你在学习实验技能、分析技能。
(00:30:15):
你在学习如何与不同类型的利益相关者合作。因为你的技能变化率高，你的成长率也高。同样，当你进入中高级阶段，我开始听到这样的对话：“好吧，也许我不该做那个。也许我不该接手这个产品。我不知道这对我的职业生涯意味着什么，不知道这对我的成长意味着什么”等等。所以你的变化率降低了。因此，当你达到中高级水平时，不断检查你能做些什么来保持变化率的增长是非常重要的。最简单的一件事是：如果你认为你的数据能力是 4 分（满分 5 分），在你的组织内，开始与行业顶尖水平对标。
(00:31:13):
你会自动发现你的评分下降了，而随着评分下降，你会看到你需要改进和做的事情。如果你发现自己在沟通和协作方面达到了 4 分，那就开始把自己与跨职能的其他利益相关者进行对比。同样，你的自我评分会下降，你会开始弄清楚你还能做些什么。所以，保持对变化率的关注，成长率自然会随之而来。有时这还涉及更换团队甚至更换公司，但那应该是最后的手段。在现有环境下，你依然可以做很多重要的事情。最后一点限制你成长的因素（尤其是当你达到中高级水平时）是你如何看待自己。
(00:32:04):
我见过很多产品经理（包括某个阶段的我）会这样做，人们会说：“哦，我是一个极具自主性（high agency）的 PM”或者“我是一个非常协作型的 PM”。早些时候，我曾认为我需要把某种类型的工作交给这些 PM，需要让他们适应某种团队、某种工作领域、某种机会。但后来我开始明白，这些标签不仅是信号，也是“反信号”。他们会觉得：“哦，我是 high agency，所以有时我表现得有点鲁莽、投机取巧，或者有时对人有点粗鲁，这都是可以接受的”，对吧？
(00:32:55):
同样，如果我被视为一个极度协作的人，那么有时我不够果断、行动不快也是可以的，因为我就是这种类型的 PM。所以，检查你告诉自己的那些“故事”非常重要，因为这些故事在基础层面定义了你，而这通过框架和结构是很难纠正的。弄清楚你告诉自己的故事是什么。如果你弄不清楚，找你信任的人谈谈，让他们告诉你，然后纠正这些故事。一旦你能够纠正这些故事，你可能就会重新回到成长的道路上。

---

### (00:33:39) Lenny Rachitsky

**English:**
Wow, there's so much meat and wisdom in what you just shared. I want to go in so many different directions. Maybe just to follow on this last thread, did you go through something like that yourself where you have this sense of yourself that hindered you? Okay, awesome. You're nodding your head, if you're not on YouTube. Can you share that?

**中文翻译:**
哇，你刚才分享的内容里有太多的干货和智慧了。我想从很多不同的方向深入探讨。也许我们可以顺着最后一个话题聊聊，你自己经历过类似的事情吗？即你对自己的一种认知阻碍了你的发展？太棒了，你在点头（如果你没在看 YouTube 视频的话）。你能分享一下吗？

---

### (00:33:57) Vikrama Dhiman

**English:**
Yeah. So I'll give an example of when I joined Gojek. The very first thing that I learned in my career was SQL and Oracle. And I was very proud of the fact that my data skills are awesome and I know several frameworks and I know several tools and so on. And when I joined Gojek and I saw one of your guests, Crystal, and I saw the work that she was doing and her team was doing and I just immediately was like, "Yeah, no, this is not... I'm nowhere near", right? And similarly, I also thought that my communication skills are really good and my product strategy skills are very good, but then I worked with people like Dito and people like Sidu who was so good at their craft that it challenged me to see that okay, what is it that I am missing? What is it that I am doing wrong?
(00:34:57):
And it auto-calibrated me in my eyes on where it was, but that also created a hunger in me that this is what I need to fix. And I immediately corrected my assessment of myself that I'm not the strongest product manager on data. I'm not the one who knows all the strategy pieces or even strategy frameworks or how to bring everything to a strategy point of view or communicate it from an effective perspective. And then I started framing I'm still in a learning phase. When I see that I'm not in that phase now, I try and make myself humble by interacting with people who are far smarter than me on different scale or reading different books, or watching podcasts like yourselves. And that keeps you grounded on the fact that okay, you are always learning. And I also found that seeing yourself as someone who's a learner is an enabling story to tell yourself, okay?
(00:35:58):
It may not be the most exciting story, it may not be the most memorable story about yourself, but it is definitely one of the enabling stories as well. Similarly, I think one other thing that I used to say about myself was more that I'm very high agency PM. But as I started working more in Southeast Asia, I learned that mindfulness is also very, very important, that not every team, not every culture will work with you in a very hyper aggressive style. But you still need to get the work done. And I'm still learning on that and therefore, I've started using a word, I don't want to be a high agency person, I want to be a mindful agency person. And so these terms are very important because these are the stories that you keep telling yourself and these also then start shaping your behavior. I do feel that I have a lot to do, I have a lot to learn on these skills, but these things definitely keep you grounded and you keep coming back to the learning phase again.

**中文翻译:**
是的。我举个加入 Gojek 时的例子。我职业生涯学到的第一样东西就是 SQL 和 Oracle。我曾为自己的数据技能感到非常自豪，我觉得自己很棒，掌握了各种框架和工具。但当我加入 Gojek，看到你之前的嘉宾 Crystal 以及她和她的团队所做的工作时，我立刻意识到：“不，这完全不是一回事……我差远了”，对吧？同样，我也曾认为我的沟通能力和产品战略能力非常好，但后来我与 Dito 和 Sidu 这样的人共事，他们在自己的领域非常出色，这挑战了我，让我看到：我到底缺失了什么？我哪里做错了？
(00:34:57):
这在我心中自动校准了我的位置，但也激发了我的一种渴望：这就是我需要修复的地方。我立即修正了对自己的评估：我不是数据方面最强的 PM，我也不是那个了解所有战略细节、战略框架，或者知道如何将一切转化为战略观点并进行有效沟通的人。然后我开始给自己设定：我仍处于学习阶段。即使现在我觉得自己不在那个阶段了，我也会通过与在不同维度上比我聪明得多的人交流、阅读不同的书籍或观看像你这样的播客来保持谦逊。这让你脚踏实地，意识到你永远在学习。我还发现，把自己看作一个学习者是一个能赋予自己力量的故事。
(00:35:58):
这可能不是最令人兴奋的故事，也不是关于你自己最难忘的故事，但它绝对是一个能让你不断进步的故事。同样，我以前常说自己是一个极具自主性（high agency）的 PM。但随着我在东南亚工作的时间变长，我学到“觉知（mindfulness）”也非常重要，并非每个团队、每种文化都能接受那种极度激进的风格。但你仍然需要把工作完成。我还在学习这一点，因此我开始使用一个词：我不想做一个 high agency 的人，我想做一个“觉知型自主（mindful agency）”的人。这些术语非常重要，因为它们是你不断告诉自己的故事，也会开始塑造你的行为。我确实觉得在这些技能上我还有很多要做、很多要学，但这些想法确实能让你保持清醒，让你不断回到学习阶段。

---

### (00:37:09) Lenny Rachitsky

**English:**
It's interesting that when you saw Crystal being incredibly good at working with data, you just realized, "Hey, maybe I'm actually not very good at this." And your reaction wasn't, "God damn it, I'm really screwed and this is really depressing me", it's, "No, instead I'm going to try to get better at this." And that reminds me some of the feedback I get with this podcast, those people are like, "Man, these people are so good, I'm never going to be this good. It discourages me from thinking I will ever be super successful in this career." Clearly, you have a different approach. Do you have advice or guidance to folks that are sometimes discouraged seeing people being so incredible and helping them actually continue to level up in this rate of change you talked about versus just like, "Nope, I'm never going to be that good?"

**中文翻译:**
很有趣，当你看到 Crystal 在处理数据方面极其出色时，你意识到：“嘿，也许我其实并不擅长这个。”而你的反应不是“该死，我完蛋了，这太让人沮丧了”，而是“不，我要努力变得更好”。这让我想起我收到的关于这个播客的一些反馈，有些人会说：“天哪，这些人太优秀了，我永远不可能这么好。这让我怀疑自己是否能在职业生涯中取得巨大成功。”显然，你有一套不同的方法。对于那些看到别人如此优秀而感到气馁的人，你有什么建议或指导，能帮助他们在你提到的“变化率”中继续提升，而不是直接放弃说“不，我永远不会那么好”？

---

### (00:37:54) Vikrama Dhiman

**English:**
I think as product managers it becomes difficult because a lot of your growth is being determined because of feedback of others. And because product management is so ambiguous and still not defined, the stakeholders can also give feedback on variety of dimensions. Some of them may not even be important enough to give feedback on, but they are important enough for them and so therefore, they give you feedback. And therefore, you have to shape that feedback in. But you also have to consider that there are these eight access that we spoke about, the data access, the design and research access, the technology access, the strategy access, communication access, collaboration access, organizational skills access, and the community access. You need to channelize feedback into okay, is this an area that you are targeting for growth or not?
(00:38:51):
And one of the most important things that I learned was that when I joined Gojek or even earlier, there would be so many different areas that I needed to improve on and still need to improve on. You can't improve on every single area. That's what overwhelms you. You need to pick which is the area which is the maximum leverage for you and improve on that particular aspect and then move on to the next area, then move on to the next area and so on. Obviously, if you are floundering in something, if you're really negative in something, then you fix that first because that will give you the highest leverage. But if you are picking up data and design and strategy and technology all at the same time, that's when you'll overwhelm you.

**中文翻译:**
我认为作为产品经理，这确实很难，因为你的很多成长是由他人的反馈决定的。由于产品管理非常模糊且尚未明确定义，利益相关者可以从各种维度给出反馈。其中一些维度可能甚至不值得反馈，但对他们来说很重要，所以他们会给你反馈。因此，你必须吸收这些反馈。但你也要考虑到我们谈到的这八个维度：数据、设计与研究、技术、战略、沟通、协作、组织能力和社区。你需要将反馈引导到：这是否是你目标成长的领域？
(00:38:51):
我学到的最重要的事情之一是，当我加入 Gojek 甚至更早的时候，有很多不同的领域我需要改进，而且现在仍然需要改进。你不可能在每个领域都同时改进，那会让你崩溃。你需要挑选出对你来说杠杆率最高的领域，在那个特定方面进行改进，然后再转向下一个领域，以此类推。显然，如果你在某方面表现得很挣扎，或者有明显的负面表现，那就先解决它，因为那会给你带来最高的杠杆。但如果你同时想提升数据、设计、战略和技术，那你肯定会感到不堪重负。

---

### (00:39:33) Lenny Rachitsky

**English:**
So to summarize the advice there is one, be actually very open to feedback you're getting. It's easy to say that, it's hard to actually listen to people criticizing you and act on it. So I think that's an important takeaway here is just actually, feedback is a gift and actually understand that and try to act on it. I have a great interview with Jules Walter who's a PM at Google now, and he has this awesome quote about how whenever people give him hard feedback, it's like internally he's just melting, but that's externally he's like, "Thank you so much for that feedback, I really appreciate it. It's very valuable."
(00:40:10):
And so that's a good way to get people to keep giving feedback. Okay. And then the other piece of advice you just shared there is pick a focus area. Like say you're getting all this feedback, your strategy isn't amazing, your PRDs aren't great, just find one thing to focus on. And I don't know, do you try to do somewhat quarter? Somewhat year? Do you have a heuristic of how long to spend on one thing?

**中文翻译:**
总结一下你的建议：第一，要对收到的反馈保持非常开放的态度。说起来容易，但真正听取别人的批评并付诸行动很难。所以我认为这是一个重要的收获：反馈是一份礼物，要真正理解这一点并努力行动。我曾对现任 Google PM 的 Jules Walter 做过一次精彩的采访，他有一句名言：每当别人给他严厉的反馈时，他内心其实在崩溃，但外表上他会说：“非常感谢你的反馈，我真的很感激，这非常有价值。”
(00:40:10):
这是让别人愿意继续给你反馈的好方法。好的。你分享的另一条建议是挑选一个重点领域。比如你收到了很多反馈，说你的战略不够好，PRD 也不行，那就找出一件事来专注。我不确定，你是按季度还是按年来做？你有没有一个经验法则，规定在一件事上花多长时间？

---

### (00:40:31) Vikrama Dhiman

**English:**
So different skills take different time and how you are progressing also depends a lot as well. For skills which are softer in nature like communication and collaboration and community, those are skills that you will work on all your life. You'll never achieve anywhere near two or five on five on those ever. There'll always be something that you will miss, there will always be a new context, there'll always be a new set of stakeholders, new company cultures that you have to adapt to. For others, you have to see that what gives you the maximum leverage in your career. When you're starting off, my recommendation is that you pick between data and tech one, and definitely one on design and research and strategy.
(00:41:18):
So usually, that's the combo that I recommend. My advice is if you're coming from design and research background, then you pick data or tech. If you're coming from a data or tech background, then you pick design and research, and that gives you the maximum leverage because that's a skill that you will necessarily not have developed over the years. Once you've demonstrated on two of these three, between data, tech and design and research, then you start focusing on strategy. We've had great success at Gojek in transitioning a lot of product managers, especially in Indonesia, using this framework. And it's produced a lot of good product managers for us.

**中文翻译:**
不同的技能需要不同的时间，你的进步程度也取决于很多因素。对于沟通、协作和社区等软技能，这些是你一辈子都要磨练的。你永远无法在这些方面达到完美的 5 分。总会有你疏忽的地方，总会有新的语境，总会有新的利益相关者，以及你必须适应的新公司文化。对于其他技能，你得看什么能给你的职业生涯带来最大杠杆。当你起步时，我的建议是在数据和技术中选一个，然后在设计、研究和战略中选一个。
(00:41:18):
这通常是我推荐的组合。我的建议是，如果你有设计和研究背景，那就选数据或技术。如果你有数据或技术背景，那就选设计和研究，这会给你带来最大杠杆，因为那是你多年来未必培养过的技能。一旦你在数据、技术、设计与研究这三项中的两项证明了自己，你就可以开始专注于战略。我们在 Gojek 使用这个框架成功转型了很多产品经理，尤其是在印度尼西亚，这为我们培养了很多优秀的产品经理。

---

### (00:41:59) Lenny Rachitsky

**English:**
Well, let's actually follow that thread. That's really interesting. And so the approach is you have this access of skillsets and you pick, for this person moving from say customer service to product, here's the two things you need to focus on. Can you talk more about that?

**中文翻译:**
那我们顺着这个话题聊聊。这很有趣。所以方法是，你有一套技能维度，然后针对某个从客服转型到产品的人，你会选出两件他们需要专注的事情。你能多谈谈这个吗？

---

### (00:42:15) Vikrama Dhiman

**English:**
Yeah. For instance, we recently had two PMs, one who came from a growth background. This is actually [inaudible 00:42:24]'s team. And one from a research background. And with both of them, we use very different tactics. So we gave one of finding driver redesign, which was very much a very design-focused product, but we still had them leverage their data skills because we were able to create a PRD with incredible amount of data on exactly what different segments of customers we're doing. And that then we worked with designers on what the designs and the framework for that will be. And even now, Lenny, if you will come and see our finding driver redesign next time you are in Asia, it's a piece of art. And if you would see that that was worked on by a product manager who actually came from a growth and data background, that makes it even more special.
(00:43:13):
Similarly, the PM who transitioned from research, I kept giving feedback on technology and data skills are the ones that we need to check. And I need to hear from engineers that yes, they're able to work with her very strongly. And once she was able to do that, she's recently turned a very heated question on one of the features that we were doing into a full-blown solution with designs, with trade-offs and everything, and able to now convert it into a question for leadership on how we should be approaching this particular product and direction. So I think that's proven successful as well. Similarly, there's another person who took risk who was originally from research and again, worked a lot on our products, including our enterprise product. And she's doing an amazing job as well. Again, going through that path of okay, these are the things that you need to leverage.
(00:44:14):
The only watch-out is that it doesn't work out always. In some cases, some PMs will pick these things up fast, and it also makes a big difference if you are transitioning when you are slightly younger in your career. If you are already senior in a function and then you are transitioning, sometimes it can take a lot of time in transitioning and picking up those skills. But it's definitely doable if you get a very strong product leader working with you who's able to shape those skills for you. So it's sometimes okay to go a little slow when you're transitioning so that you're able to go faster later rather than getting faster somewhere and then being stuck there for a while.

**中文翻译:**
好的。例如，我们最近有两个 PM，一个来自增长背景，另一个来自研究背景。针对他们，我们使用了截然不同的策略。我们让那个有增长背景的 PM 负责“寻找司机”页面的重新设计，这是一个非常注重设计的产品，但我们仍然让他们发挥数据技能，因为我们创建了一份包含海量数据的 PRD，详细说明了不同细分客户的行为。然后我们与设计师合作确定设计方案和框架。Lenny，下次你来亚洲看我们重新设计的“寻找司机”页面，它简直是一件艺术品。如果你知道它是由一个增长和数据背景的 PM 完成的，你会觉得它更特别。
(00:43:13):
同样，对于那个从研究背景转型的 PM，我不断反馈说我们需要考察她的技术和数据技能。我需要听到工程师们说他们能与她紧密配合。一旦她做到了这一点，她最近将一个关于我们正在开发的功能的激烈争论转化为了一个包含设计、权衡和所有细节的完整解决方案，并将其转化为一个提交给领导层的问题，探讨我们应该如何处理这个特定的产品和方向。所以我认为这也是成功的。同样，还有另一个原本从事研究的人，她也负责了很多产品，包括我们的企业级产品，表现也非常出色。这再次证明了：明确你需要利用哪些技能。
(00:44:14):
唯一的注意事项是，这并不总是奏效。在某些情况下，有些 PM 学习这些东西很快。此外，如果你在职业生涯较早阶段转型，情况会有很大不同。如果你已经在某个职能部门做到了资深级别再转型，有时转型和学习这些技能会花费很长时间。但如果你有一个非常强大的产品领导者指导你，帮助你塑造这些技能，这绝对是可行的。所以有时在转型时慢一点是可以接受的，这样以后才能跑得更快，而不是在某处跑得很快然后被困在那里很长时间。

---

### (00:45:00) Lenny Rachitsky

**English:**
This episode is brought to you by Coda, and I mean that literally. I use Coda every day to help me plan each episode of this very podcast. It's where I keep my content calendar, my guest research, and also the questions that I plan to ask each guest. Also, during the recording itself, I have a Coda page up to remind myself what I want to talk about. Coda is an all-in-one platform that combines the best of documents, spreadsheets, and apps to help you and your team get more done. Now is the perfect time to get started with Coda, especially its extensive planning capabilities. With Coda, you can stay aligned and ship faster by managing your planning cycles in one location. You can set and measure OKRs with full visibility across teams and stakeholders. You can map dependencies, create progress visualizations, and identify risk areas. Plus, you can access hundreds of pressure-tested templates for everything from roadmap strategy to final decision-making to PRDs.
(00:45:56):
If you want a platform that empowers your team to strategize, plan and track goals together, you can get started with Coda today for free. And if you want to see for yourself why product teams at high-growth companies like Pinterest, Figma and Qualtrics run on Coda, take advantage of the special limited-time offer just for startups. Head over to coda.io/lenny to sign up and get $1,000 in credit. That's C-O-D-A.io/lenny to sign up and get $1,000 in credit. Coda.io/lenny.

**中文翻译:**
本集节目由 Coda 赞助，我是认真的。我每天都用 Coda 来规划这个播客的每一集。我在那里记录内容日历、嘉宾研究以及我计划问每个嘉宾的问题。在录音过程中，我也会打开一个 Coda 页面来提醒自己要聊什么。Coda 是一个全能平台，它结合了文档、电子表格和应用的优点，帮助你和你的团队完成更多工作。现在是开始使用 Coda 的绝佳时机，尤其是它强大的规划功能。通过 Coda，你可以在一个地方管理规划周期，从而保持步调一致并加快发布速度。你可以设定并衡量 OKR，让团队和利益相关者拥有完整的可见性。你可以映射依赖关系、创建进度可视化并识别风险区域。此外，你还可以访问数百个经过实战测试的模板，涵盖从路线图战略到最终决策再到 PRD 的方方面面。
(00:45:56):
如果你想要一个能赋能团队共同制定战略、规划和跟踪目标的平台，今天就可以免费开始使用 Coda。如果你想亲眼看看为什么 Pinterest、Figma 和 Qualtrics 等高增长公司的产品团队都在使用 Coda，请利用这个专门针对初创公司的限时优惠。前往 coda.io/lenny 注册即可获得 1000 美元的抵用金。

---

### (00:46:29) Lenny Rachitsky

**English:**
Something that you mentioned earlier that I wanted to come back to is this confusion about what the PM role is and how that trips people up in being successful in the role and continuing to thrive in the role. You mentioned this to me offline too, that this is just something you deal with a lot, just this frustration of what the hell is this job? What am I actually responsible for? What am I not? What do you find is helpful in helping people work through that, get past that, not make that a big blocker in their career, not knowing exactly what the PM role is?

**中文翻译:**
你之前提到的一点我想再聊聊，就是关于 PM 角色定义的困惑，以及这种困惑如何阻碍人们在岗位上取得成功并持续发展。你在私下也跟我提过，这是你经常处理的事情——那种“这到底是个什么工作？”的挫败感。我到底负责什么？我不负责什么？你发现什么方法能有效帮助人们理清这些、跨过这个坎，不让“不清楚 PM 角色定义”成为职业生涯的巨大障碍？

---

### (00:46:56) Vikrama Dhiman

**English:**
I think we've been in technology product for several decades now, but we are still figuring out what an exact definition of product management is. And even the strongest definitions are slightly principled and philosophical in nature, they're not very concrete, and that also means that every and different technology companies have gone through different journeys and they've defined the roles very, very differently. And even within a very large company, you will see that different teams, different divisions are approaching the roles very, very differently as well.
(00:47:34):
And on top of that, what that does is that not only internally the product managers are figuring this out, their managers, their leaders are figuring these things out for them, but the other stakeholders who have to work with these product managers are also confused and they don't know what to expect. And the number one question I get from stakeholders is, is a product manager expected to do this? Because they also don't know, okay, is this expected from a product manager or not? And my general answer to that is, if this is something which is blocking the progress on the product, then yes, the product manager should work on that.

**中文翻译:**
我认为虽然我们进入科技产品领域已经几十年了，但我们仍在摸索产品管理的准确定义。即使是最有力的定义，在本质上也带有一点原则性和哲学色彩，不够具体。这也意味着不同的科技公司经历了不同的历程，他们对角色的定义大相径庭。甚至在一家大公司内部，你也会看到不同的团队、不同的部门对这个角色的理解完全不同。
(00:47:34):
除此之外，这导致不仅内部的产品经理在摸索，他们的经理和领导也在为他们摸索，甚至必须与这些产品经理合作的其他利益相关者也很困惑，不知道该期待什么。我从利益相关者那里收到的头号问题是：“产品经理应该做这个吗？”因为他们也不知道这是否在产品经理的职责范围内。我通常的回答是：如果这件事阻碍了产品的进展，那么是的，产品经理应该去做。

---

### (00:48:09) Lenny Rachitsky

**English:**
Love that.

**中文翻译:**
太棒了。

---

### (00:48:09) Vikrama Dhiman

**English:**
But that works if the product managers have had some training and they have had some training in working with different stakeholders and they have had something on the job. What I've figured out is that there are certain functions and there are certain disciplines which you can't define, but you can only become better at with practice. For instance, what is an actor or what is a dancer? Right? So these are things that you will get better at as you become skilled at it. And earlier, these things used to be looked at as something which is very artistic, only the people who are talented or only specific kind of people can do it. But now, each one of those has become [inaudible 00:48:57] and frameworks as well. So there are courses on filmmaking, there are courses on acting, there are courses on dancing and so on. And similarly, product management is that space as well.
(00:49:08):
So you have to understand there's an art to it and there's a science to it, but you can use the science to figure out the art. So that's the philosophical side of it. The second side of it is what we spoke about earlier that instead of figuring out what is product management, figure out what's your contribution, what's your output and figure out are you contributing on these access on data, on design, on technology and on strategy. And one of my favorite things is that if you created these four circles of strategy, of technology, of design and of data, and you created a product management circle which encircles each one of these, so you are the only discipline, which is the co-collaborator for all of these disciplines and tying all these things out.
(00:49:59):
So it's not about you standing alone, it's you always collaborating and pairing with someone else. But you are the only one who's pairing with everyone else and therefore, you have that unique insight which no one else in the team will have. That role can be played by someone else, it doesn't necessarily need to be called a product manager. But if you are being called a product manager, you figure out the [inaudible 00:50:24] the time piece that you are. And when you are added to the team, you must dream the team's overall contribution, overall energy and overall output up and not down.

**中文翻译:**
但这只有在产品经理接受过一些培训，包括如何与不同利益相关者合作以及一些在职培训的情况下才有效。我发现有些职能和学科是你无法定义的，只能通过实践变得更好。例如，什么是演员？什么是舞者？对吧？这些是你随着技能熟练而变得更好的事情。以前，这些被视为非常艺术化的东西，只有有天赋或特定类型的人才能做。但现在，每一项都有了框架。有电影制作课程、表演课程、舞蹈课程等等。同样，产品管理也是这样一个领域。
(00:49:08):
所以你必须理解，这其中既有艺术也有科学，但你可以利用科学来理解艺术。这是哲学的一面。另一面就是我们之前谈到的：与其纠结什么是产品管理，不如弄清楚你的贡献是什么、你的产出是什么，并弄清楚你是否在数据、设计、技术和战略这些维度上做出了贡献。我最喜欢的比喻之一是：如果你画出战略、技术、设计和数据这四个圆圈，然后画一个产品管理圆圈把它们都包围起来——你就是唯一的那个与所有这些学科协作并将它们串联起来的学科。
(00:49:59):
所以这不是关于你独立存在，而是关于你始终在与他人协作和配对。但你是唯一一个与每个人都配对的人，因此，你拥有团队中其他任何人都不会有的独特见解。这个角色可以由别人来扮演，不一定非要叫产品经理。但如果你被称为产品经理，你就要弄清楚自己是那个连接各方的纽带。当你加入团队时，你必须提升团队的整体贡献、整体能量和整体产出，而不是拉低它们。

---

### (00:50:37) Lenny Rachitsky

**English:**
I love that. Something I always tell people is the PM doesn't necessarily have the magical skills other team members don't have, it's that they don't also have another job. Engineers may do a great job at being the PM, they just also have to build and code. And they don't have time to do all the things that a PM has to do, and a designer is in the same way, a researcher or data person. And so oftentimes, that's just like there's this person that has the time to do all these glue, work things between teams. And the great PMs also are very good at these skills that help you do these things, but it doesn't mean other people can't do them.

**中文翻译:**
我喜欢这个观点。我总是告诉人们，PM 并不一定拥有其他团队成员没有的神奇技能，只是他们没有“另一份工作”。工程师可能也能胜任 PM 的工作，但他们还得负责构建和编码，没时间做 PM 必须做的所有事情。设计师、研究员或数据人员也是如此。所以通常情况下，PM 就是那个有时间去做团队之间所有“胶水工作”的人。优秀的 PM 也非常擅长这些帮助你完成工作的技能，但这并不意味着别人做不了。

---

### (00:51:19) Vikrama Dhiman

**English:**
You see yourself as playing a role and not your title and not your function, and that just clarifies a lot of things for people. And different people will play different roles. And depending on the kind of a PM you are, are you in a specific domain or you are slightly generalist, the role that you will be playing in different teams can be different and the variety of roles that you can play makes you a better product manager.

**中文翻译:**
你要把自己看作是在扮演一个角色，而不是一个头衔或职能，这能为人们理清很多事情。不同的人会扮演不同的角色。根据你是哪种 PM（是深耕特定领域还是全才型），你在不同团队中扮演的角色可能不同，而你能扮演的角色越多样，你就越能成为一名优秀的产品经理。

---

### (00:51:47) Lenny Rachitsky

**English:**
I love that. You've mentioned these four access attributes of great product managers, overall product managers. Let's just spend a little time here. So you say basically the things you need to be doing and good at, data, design/research technology, strategy, and then you also mentioned collaboration and communication. Maybe you're-

**中文翻译:**
太棒了。你提到了优秀产品经理的四个核心维度属性。我们在这里多花点时间。你基本上说你需要做并擅长的事情是：数据、设计/研究、技术、战略，然后你还提到了协作和沟通。也许你还想——

---

### (00:51:47) Vikrama Dhiman

**English:**
Yeah, organizational skills and community. I think those are very, very important because one of the things and one of the things which one of the product managers works with me continues to say, and I really plus on that a lot, is that product manager is the all community enabler in the team, in the organization. And that community is the software aspect which ties everyone together towards a common mission of delivering an output. And that I think is a very, very important goal in today's context, especially for teams which are becoming more remote or teams where people are not co-located or they're distributed. That community aspect becomes a very, very important part that product managers need to focus on and bring and channelize as well.

**中文翻译:**
是的，还有组织能力和社区能力。我认为这些非常重要，因为跟我共事的一位产品经理经常说（我非常赞同）：产品经理是团队和组织中全方位的“社区赋能者”。这种“社区”是软件层面的纽带，它将每个人联系在一起，朝着交付产出的共同使命迈进。我认为在当今背景下，这是一个非常重要的目标，尤其是对于远程办公、非同地办公或分布式团队。社区维度已成为产品经理需要关注、引入和引导的一个非常重要的部分。

---

### (00:53:05) Lenny Rachitsky

**English:**
So let's just quickly describe each of these attributes. I imagine people might be thinking, "Okay, what should I get better at as a PM?" And this is an awesome list. Each company has their own career ladders and attributes and things like that, but not a lot of companies don't. So I think for people that are trying to figure out where do I need to get better, I think this is a really cool list. Can you just maybe just a sentence explanation of each of these attributes and skillsets that a PM needs?

**中文翻译:**
那我们快速描述一下每一个属性。我想听众可能会想：“好吧，作为 PM 我应该在哪些方面提升？”这是一个很棒的清单。每家公司都有自己的职业阶梯和属性定义，但很多公司并没有。所以对于那些想弄清楚自己需要在哪里提升的人来说，这是一个非常酷的清单。你能用一句话解释一下 PM 需要的这些属性和技能组吗？

---

### (00:53:31) Vikrama Dhiman

**English:**
So each one of those skills, like the most growth ladders, what they will do, is they will have say for data, they will have level one, exhibits these traits. Level two, exhibits this trait. Level three, exhibits this trait. Level four and level five and so on. That's how they'll describe it. But five is absolute ninja level data quality, like you could probably do a data startup of your own.

**中文翻译:**
这些技能就像大多数成长阶梯一样，会分等级。比如数据能力，会有 1 级展示这些特质，2 级展示那些特质，一直到 4 级、5 级。5 级就是绝对的“忍者级”数据水平，你甚至可以自己开一家数据初创公司。

---

### (00:53:55) Lenny Rachitsky

**English:**
Like Crystal basically?

**中文翻译:**
基本上就像 Crystal 那样？

---

### (00:53:57) Vikrama Dhiman

**English:**
Crystal. And level zero is someone who cannot even basically define the basic metrics for this particular product and won't be able to figure out is this particular thing impacting orders or users or revenue. And so you'll really not be able to figure even that piece out. Similarly, on design and research, for product managers, we focus a lot more on problems and are you able to identify problems from a user's perspective. That's at level zero. And level five will be somebody who's able to define the user problems but is also able to tie them to business roles as well. So that makes it the holistic. Similarly, on technology, it's one of the skills which is relatively easier to define where you don't have any tech understanding. If somebody asked you what is HTTP or API or internet and you'll be like, "Okay, I don't know what it is."
(00:54:55):
And while on the other end, you are able to have deep debates and could probably write technology design documents yourself as well. I think sometimes people get confused between data science. And in different organizations, I see data science bucketed either in data or in technology. Either is fine as long as you are clear on what your organization's framework is. Similarly then, there is strategy. Strategy is I think another area in product management which gets very confusing because there is obviously corporate strategy, there is business strategy, there's pricing strategy, there's strategy everywhere. Product strategy for me is where you are able to define that while somebody defines that this is the mountain that you're going to climb, but okay, how are you going to climb that mountain is basically the product strategy piece.
(00:55:47):
So you are not in charge of okay, are you focused on growth? Are you focused on revenue? Are you focused on profitability? That's someone's choice. Are you going to pick this country? Are you going to pick that country? But once that is picked, what are the user segments that you're going to focus on? What are the needs of those user segments? How are we going to figure out what the right product for them will be? What is the order in which we are going to work on that? That whole piece of product strategy is with the product managers. And again, in the first case, you are basically going to rely on everyone to tell you, do this, do this, do this. In second and in the level five cases, you are able to articulate a very coherent product strategy at a broad level as well.

**中文翻译:**
对，像 Crystal。而 0 级就是那些甚至无法为特定产品定义基本指标，也弄不清楚某件事是影响了订单、用户还是收入的人。同样，在设计与研究方面，对于产品经理，我们更多关注问题：你是否能从用户的角度识别问题？这是 0 级。5 级则是能够定义用户问题，并能将其与业务角色联系起来的人，这使其变得完整。在技术方面，这相对容易定义。0 级是你没有任何技术理解，如果有人问你什么是 HTTP、API 或互联网，你会说：“我不知道”。
(00:54:55):
而另一端，你能够进行深入的技术辩论，甚至可能自己编写技术设计文档。我认为有时人们会混淆数据科学。在不同的组织中，我看到数据科学要么被归入数据类，要么被归入技术类。只要你清楚自己组织的框架，哪种都可以。接下来是战略。战略是产品管理中另一个让人困惑的领域，因为有公司战略、业务战略、定价战略，到处都是战略。对我来说，产品战略是：当有人定义了“我们要爬哪座山”之后，你来定义“我们要如何爬上那座山”。
(00:55:47):
所以你不负责决定是关注增长、收入还是盈利，那是别人的选择。你也不负责决定选哪个国家。但一旦选定，你要关注哪些用户细分？这些用户的需求是什么？我们如何确定适合他们的产品？我们工作的先后顺序是什么？这整块产品战略都属于产品经理。在初级阶段，你基本上依赖别人告诉你做什么；而在 5 级水平，你能够在宏观层面阐述一个非常连贯的产品战略。

---

### (00:56:33) Lenny Rachitsky

**English:**
Amazing, thanks for sharing that. I think for people that are trying to craft career ladder for product managers, this could help inform the way they think about this. By the way, when we mentioned Crystal, for folks that have no idea who we're talking about, she was a early head of growth at Gojek back in the day. She was a previous guest on the podcast. I always forget how to pronounce her last name exactly, but I think it's Widjaja, Crystal Widjaja.

**中文翻译:**
太棒了，谢谢分享。我认为对于那些正在制定产品经理职业阶梯的人来说，这能为他们的思考提供参考。顺便提一下，对于不知道 Crystal 是谁的听众，她是 Gojek 早期的增长负责人，也是本播客之前的嘉宾。我总是忘了她姓氏的准确读音，我想应该是 Widjaja，Crystal Widjaja。

---

### (00:56:33) Vikrama Dhiman

**English:**
Widjaja.

**中文翻译:**
Widjaja。

---

### (00:56:54) Lenny Rachitsky

**English:**
Widjaja? Okay, okay. Great. Going in a different direction, we're going to move to contrarian corner. I'm curious if there's anything that you believe that other people wouldn't agree with or generally just don't believe?

**中文翻译:**
Widjaja？好的。太棒了。换个方向，我们进入“非共识角落（contrarian corner）”。我很好奇，有没有什么事情是你相信但其他人可能不同意，或者通常不相信的？

---

### (00:57:12) Vikrama Dhiman

**English:**
I used to think intent is the most important thing, right? And when I was starting off, that used to be the advice that as long as your intent is right, even if some of your words are not landing, even if some of the comms are not landing, that will work out. What I've seen is that it's not enough. Your actions, your behavior, and the way you communicate, the way you collaborate, that also has to communicate and show who you are as well. So intent is not enough. And that's a thing which I think a lot of people in my age group just don't get, but people who are slightly starting off their career, it resonates well with them. Second thing I think where I feel that it's become, I don't know, is it contrarian or it's become politically incorrect, is that you still need to put in the effort and our number of hours is effort.
(00:58:23):
And I think that's one thing which has become very politically incorrect to say over the years when I was younger, it was the norm that yes, you will have to put in the effort, you will have to put in the hours to grow and improve your skills. And it's not even about your growth in the company, it's just your own growth. You have to spend the time, effort, and energy into growing. I think a lot of that is getting lost in the debates between complete workaholism and just being not very serious about your growth at all. So I think those are the two that I find myself having to explain myself again and again and why I feel this way.

**中文翻译:**
我以前认为“意图（intent）”是最重要的。当我刚起步时，得到的建议通常是：只要你的意图是好的，即使你说的话不中听，即使沟通不顺畅，最终也会解决。但我发现这还不够。你的行动、你的行为、你沟通和协作的方式，也必须传达并展示你是谁。所以光有意图是不够的。我觉得很多和我同龄的人并不理解这一点，但对于刚开始职业生涯的人来说，这能引起很好的共鸣。第二点，我觉得这已经变得……我不知道这算不算非共识，或者说变得“政治不正确”了，那就是：你仍然需要付出努力，而工作时长就是努力的一种体现。
(00:58:23):
我认为这些年来，说这句话变得非常政治不正确。但在我年轻的时候，为了成长和提升技能，你必须付出努力、投入时间，这是常态。这甚至不是为了你在公司的成长，而是为了你个人的成长。你必须投入时间、精力和能量去成长。我认为在“完全的工作狂”和“对成长完全不认真”之间的争论中，很多东西都丢失了。所以这是我发现自己必须一次又一次解释的两点，以及我为什么这么想。

---

### (00:59:14) Lenny Rachitsky

**English:**
I completely agree with that. I find a hugely strong correlation between hours you put into the work you do and success. And I think there's been a return to okay, working hard is really important and you shouldn't be afraid of promoting working really hard. So we've actually gone through everything that I wanted to ask you. Before we get to our very exciting lightning round, is there anything else you wanted to share or is there anything you want to leave listeners with?

**中文翻译:**
我完全同意。我发现投入的工作时长与成功之间存在极强的相关性。我认为现在有一种回归：努力工作非常重要，你不应该害怕提倡努力工作。我们已经聊完了我想问的所有内容。在进入令人兴奋的闪电轮环节之前，你还有什么想分享的，或者有什么想留给听众的吗？

---

### (00:59:41) Vikrama Dhiman

**English:**
No, I think it has been great talking to. I hope it was useful to people. I've tried to keep it real, but also in takeaway format. And if there are any questions that you have that I feel I have not answered, I'm happy to answer them.

**中文翻译:**
没有了，我觉得这次谈话非常愉快。我希望这对大家有用。我试着保持真实，同时也提供了一些可借鉴的模式。如果你觉得还有什么问题我没回答，我很乐意解答。

---

### (01:00:01) Lenny Rachitsky

**English:**
Okay, amazing. Well, we'll have people post in the comments if there's anything else they would love to ask you. With that, we've reached our very exciting lightning round. Are you ready?

**中文翻译:**
好的，太棒了。如果大家还有什么想问的，可以在评论区留言。那么，我们进入了非常刺激的闪电轮环节。准备好了吗？

---

### (01:00:12) Vikrama Dhiman

**English:**
Yes.

**中文翻译:**
准备好了。

---

### (01:00:14) Lenny Rachitsky

**English:**
First question, what are two or three books that you've recommended most to other people?

**中文翻译:**
第一个问题：你向别人推荐最多的两三本书是什么？

---

### (01:00:19) Vikrama Dhiman

**English:**
The first book is a book which I feel is not quoted enough in product management community, is a book called Small Data by Martin Lindstrom. This is a person who was an advertiser or marketeer who would go and make campaigns for big brands in different countries, and so would have usually very short time to get the pulse of that space and design a campaign around it. And how he got insights very quickly from, and what are some of the takeaways that are there for people working in product space, not just product managers, but designers, researchers, strategy people, anyone really, I can't recommend that book more. And I've cited that book a lot internally.
(01:01:09):
The second book that I recommend is Adam Grant's Originals. I think it's a very important book. It changed a lot of things. When I spoke about that I was going through this crisis of, oh, I'm behind so many things after joining Gojek, Originals was one book that I read which really, really helped me think about my growth and how I see myself. And anyone who is stuck or anyone who feels they are superstars, they are the innovators of the century kind of a thing, it's a book that gives you a very good reality check. And the third book that I recommend is definitely Daniel Kahneman's Thinking, Fast and Slow. I think especially the thinking slow part becomes very, very important piece as well.
(01:02:11):
And the reason why change is hard, the reason why feedback is hard is because we are used to thinking fast and we are not used to thinking slow. While if you actually think slow, you'll actually welcome change and growth.

**中文翻译:**
第一本书我觉得在产品管理界被引用得不够多，是 Martin Lindstrom 的《小数据》（Small Data）。作者是一名广告商或营销人员，他会去不同国家为大品牌策划活动，通常只有很短的时间来把握当地脉搏并设计方案。他如何快速获取洞察，以及这些经验对产品领域的人（不仅是 PM，还有设计师、研究员、战略人员等）有什么启发，我再怎么推荐这本书都不为过。我在公司内部经常引用它。
(01:01:09):
第二本推荐的是 Adam Grant 的《离经叛道》（Originals）。我认为这是一本非常重要的书，它改变了很多事情。当我提到加入 Gojek 后经历的那种“天哪，我落后了这么多”的危机感时，《离经叛道》是我读过的一本真正帮助我思考成长和自我认知的书。对于任何感到迷茫的人，或者任何觉得自己是超级巨星、世纪创新者的人，这本书都能给你一个很好的现实检验。第三本推荐的绝对是丹尼尔·卡尼曼的《思考，快与慢》（Thinking, Fast and Slow）。我认为尤其是“慢思考”部分变得非常重要。
(01:02:11):
改变之所以难、反馈之所以难，是因为我们习惯了快思考，而不习惯慢思考。如果你真的学会慢思考，你实际上会欢迎变化和成长。

---

### (01:02:26) Lenny Rachitsky

**English:**
Amazing. That book's come up a bunch actually recently on the podcast and it is always sitting under my laptop, holding up my laptop for these interviews. So I fully agree. Next question, do you have a favorite recent movie or TV show that you've really enjoyed?

**中文翻译:**
太棒了。那本书最近在播客中被提到了好几次，而且它现在就垫在我的笔记本电脑下面，支撑着电脑做这次采访。所以我完全同意。下一个问题：你最近有没有特别喜欢的电影或电视剧？

---

### (01:02:41) Vikrama Dhiman

**English:**
I haven't seen a lot of movies recently, I think. But while I was on the flight back from Dubai, I saw Miss Congeniality again and I really, really enjoyed it. I thought it's a very fun movie, but also had a pretty good message. I know it's probably not the movie which anyone would want to cited, but I think it's sometimes good to just watch good entertainment.

**中文翻译:**
我最近没怎么看电影。但在从迪拜回程的飞机上，我又看了一遍《选美小姐》（Miss Congeniality），我真的很喜欢。我觉得这是一部很有趣的电影，而且传达的信息也不错。我知道这可能不是大家会引用的那种电影，但我觉得有时看看纯粹的娱乐片也挺好。

---

### (01:03:18) Lenny Rachitsky

**English:**
That's quite the contrarian pick. Yeah, nobody has cited this movie, Miss Congeniality. This is a first, but I love it. It's way out there. I would never would've expected this.

**中文翻译:**
这确实是个非常“非共识”的选择。是的，从来没有人引用过《选美小姐》这部电影。这是第一次，但我很喜欢。这太出人意料了，我完全没想到。

---

### (01:03:27) Vikrama Dhiman

**English:**
In terms of TV shows, I think the show that I really go back to all the time is Schitt's Creek. I think it's a show which operates at so many different levels without taking itself that seriously, and it just lands. And especially as a product manager and as a leader who obsesses a lot about diversity, I think it did a fantastic job in showing different sides of motherhood, of the LGBTQIA communities, and also teenage girls figuring themselves out as well. I think it did a fantastic job.

**中文翻译:**
在电视剧方面，我一直会重温的是《富家穷路》（Schitt's Creek）。我认为这部剧在很多不同层面上运作，却又不把自己看得太重，而且非常接地气。尤其是作为一名关注多样性的产品经理和领导者，我认为它在展示母亲的不同侧面、LGBTQIA 群体以及青春期女孩探索自我方面做得非常出色。我认为它完成得太棒了。

---

### (01:04:07) Lenny Rachitsky

**English:**
Do you have a favorite interview question that you like to ask candidates when you're hiring product managers especially?

**中文翻译:**
你有没有最喜欢的面试问题，尤其是当你招聘产品经理时喜欢问的？

---

### (01:04:13) Vikrama Dhiman

**English:**
So it's not really one question, but what I like to do with them is to brainstorm choices on an actual product. And I'll typically pick up a product that they use most often and then I will be like, "Okay, what if this product were to do this? Then what do you think, it makes sense? Don't think it makes sense? What about this? Okay, how would it evolve in six months? What would happen in 12 months and so on?" I think it gives you a far better insight into how would it be on working with them on a real case. And you also keep... And what I like about it is that you can keep going back deeper into it and develop it together. So I typically try and pick product that I will also not have very strong opinions on so that it can become a two-way conversation.

**中文翻译:**
其实不是一个具体的问题，但我喜欢做的是针对一个实际产品进行选择上的头脑风暴。我通常会选一个他们最常用的产品，然后问：“如果这个产品要做这个功能，你觉得有意义吗？为什么？那如果做那个呢？它在 6 个月后会如何演变？12 个月后会发生什么？”我认为这能让你更好地洞察与他们合作处理实际案例会是什么样子。我喜欢的一点是，你可以不断深入探讨并共同完善。我通常会选一个我也没有太强主观偏好的产品，这样就能变成一场双向的对话。

---

### (01:05:14) Lenny Rachitsky

**English:**
What do you actually look for in an answer that tells you, "Okay, this candidate is amazing" versus flags that are like, "Hmm, maybe not?"

**中文翻译:**
在回答中，你具体看重什么来判断“这个候选人太棒了”，或者有哪些信号让你觉得“嗯，可能不行”？

---

### (01:05:21) Vikrama Dhiman

**English:**
There are some obvious check marks that are they able to first abstract out and figure out what the overall goals for the product are, who the users for that product are, what would they be focusing on right now, whether this will align with that or not. And then a reason backwards that okay, maybe this may not work, but something on these lines. Are you obsessed about this feature or are you obsessed about okay, what this enables you to do? So if this is what it enables you to do, then are you okay with considering some other options and so on? So I think that's the direction which usually goes in the right way.

**中文翻译:**
有一些明显的考察点：他们能否首先进行抽象，弄清楚产品的整体目标是什么、用户是谁、目前应该关注什么、这个功能是否与之匹配。然后进行反向推导：好吧，也许这个行不通，但类似这样的思路可以。你是痴迷于这个功能本身，还是痴迷于它能带来的价值？如果这是它能带来的价值，你是否愿意考虑其他方案？我认为朝着这个方向思考通常是正确的。

---

### (01:06:04) Lenny Rachitsky

**English:**
Is there a favorite product you've recently discovered that you really love?

**中文翻译:**
你最近有没有发现什么特别喜欢的产品？

---

### (01:06:08) Vikrama Dhiman

**English:**
So the reason why I've not watched a lot of drama or TV recently is because I've discovered these short video apps through Instagram and all of these apps, they dub Chinese TV serials into English or there will be subtitles in English and they are delivered in TikTok style two-minute videos. And it's a masterstroke in how the series are constructed. The first few episodes, which is like 10 episodes which is about 10 to 15 minutes, sets up the story in such a way that you have to unlock the next 10.
(01:06:47):
And these videos are quite expensive. They end up, one series takes more than the entire cost of monthly cost of Netflix to view. But it's just amazing how the whole product has been put, how all these products have been put together on unlocking the lamification aspects of it, the storytelling aspects of it, the content cutting part of it, and even the selection of the stories part of it. And what I'm told is that once I've learned about it, I've also been reading about it, they're actually companies which are able to give you tools of where you can construct this app yourself. And multiple people, two-people, three-people companies are churning these out and earning a lot of profit from it as well.

**中文翻译:**
我最近没怎么看正经电视剧的原因是，我在 Instagram 上发现了这些短剧应用。这些应用把中国的电视剧配上英文音轨或英文字幕，以 TikTok 风格的 2 分钟短视频形式呈现。这些剧集的构建方式简直是神来之笔。前几集（大约 10 集，10 到 15 分钟）就把故事铺垫得让你欲罢不能，必须解锁接下来的 10 集。
(01:06:47):
这些视频其实挺贵的。看完一整部剧花的钱比 Netflix 的月费还多。但令人惊叹的是这些产品是如何整合在一起的——包括解锁机制、游戏化元素、讲故事的方式、内容剪辑，甚至是故事题材的选择。据我了解，现在甚至有公司提供工具让你自己构建这种应用。很多只有两三人的小公司正在批量生产这些内容，并赚取了丰厚的利润。

---

### (01:07:41) Lenny Rachitsky

**English:**
What is this called for people that want to check this out?

**中文翻译:**
想去看看的人应该搜什么名字？

---

### (01:07:43) Vikrama Dhiman

**English:**
So you can start with DramaBox, you can start with [inaudible 01:07:47] Reels and so on. And there are multiple of these. And those of you who are very familiar with TikTok, you would've seen that some of these show you the first 10 episodes on TikTok and then they take you to their app to view the rest.

**中文翻译:**
你可以从 DramaBox 开始，或者 [某某] Reels 等等。有很多这类应用。熟悉 TikTok 的人可能见过，他们会在 TikTok 上放前 10 集，然后引导你去他们的 App 看剩下的内容。

---

### (01:08:01) Lenny Rachitsky

**English:**
Wow. I love so many unusual contrarian pieces of advice here, I love it. Two more questions. Do you have a favorite life motto that you often come back to, share with friends or family, either in work or in life?

**中文翻译:**
哇。我喜欢这里这么多不寻常且非共识的建议。最后两个问题。你有没有最喜欢的人生格言，是你经常回想并与亲友分享的，无论是在工作还是生活中？

---

### (01:08:15) Vikrama Dhiman

**English:**
For me, the most important thing has been that I started my career very late in tech. I was already 25. For the first several years, I worked in a small [inaudible 01:08:32] town in India. I came to Delhi only in 2013, and I joined Gojek in 2018. I think I've done reasonably well for myself. And it's never late to do or what do you want to do and what do you want to be. I think that's the thing that I really, really believe in and I also advise in. Especially as the world is aging and a lot of people are thinking about it, I would say that it's not too late ever. You can be and do what you want right now.

**中文翻译:**
对我来说，最重要的一点是我进入科技行业非常晚，当时我已经 25 岁了。头几年，我在印度的一个小镇工作。我直到 2013 年才去德里，2018 年才加入 Gojek。我觉得我做得还算不错。所以，做你想做的事、成为你想成为的人，永远都不晚。这是我深信不疑并经常给出的建议。尤其是随着世界老龄化，很多人都在思考这个问题，我想说：永远都不晚，你现在就可以去做你想做的事。

---

### (01:09:17) Lenny Rachitsky

**English:**
So good. It's not too late. I really, really like that advice. My wife is an illustrator designer. She has a book she put out called Am I Overthinking This? It's in my background somewhere there. And she has a chart that communicates that exact message in a really cute way, and we'll try to link to it in the show notes. Final question. You live in Singapore, I know you travel a lot. But if someone were to come to Singapore, is there a food that you think they need to try that's unique to Singapore?

**中文翻译:**
太棒了，“永远不晚”。我真的很喜欢这个建议。我妻子是一名插画设计师，她出了一本书叫《我是不是想多了？》（Am I Overthinking This?），就在我身后的某个地方。她有一张图表用非常可爱的方式传达了同样的信息，我们会尝试在节目介绍里放上链接。最后一个问题：你住在新加坡，我知道你经常出差。但如果有人来新加坡，你觉得有什么新加坡特有的美食是他们必须尝试的？

---

### (01:09:45) Vikrama Dhiman

**English:**
Singapore? There are multiple. So Singapore is a melting pot of different cultures. There are four official languages. And the only thing I will advise is depending on your taste buds, whatever you want to do, you should go and visit a Hawker Center. And it's an amazing experience in itself. And those of you who've seen Crazy Rich Asians, the first thing they do when they land in Singapore is go to the Hawker Center. So it's an experience of its kind. And if you are looking for a specific recommendation, go to Lau Pa Sat. If you are a fan of Indian, you'll get that. If you're a fan of Malay cuisine, you'll get that. If you're a fan of Singaporean Chinese, you'll get that. So you pick what works for you.

**中文翻译:**
新加坡？有很多。新加坡是不同文化的熔炉，有四种官方语言。我唯一的建议是，根据你的口味，无论你想吃什么，都应该去逛逛“小贩中心（Hawker Center）”。这本身就是一种奇妙的体验。看过《摘金奇缘》（Crazy Rich Asians）的人都知道，他们降落新加坡后的第一件事就是去小贩中心。这是一种独特的体验。如果你想要具体的推荐，可以去老巴刹（Lau Pa Sat）。如果你喜欢印度菜、马来菜或新加坡中餐，那里应有尽有。选你喜欢的就好。

---

### (01:10:36) Lenny Rachitsky

**English:**
I love that. Vikrama, feel like we've produced both a lot of output and we're going to have really great outcomes from our conversation. Thank you so much for being here. Two final questions. Where can folks find you online if they want to reach out and follow-up on any of the stuff we talked about? And how can listeners be useful to you?

**中文翻译:**
我喜欢这个。Vikrama，我觉得我们的谈话既产生了很多“产出（output）”，也会带来非常棒的“成果（outcomes）”。非常感谢你能来。最后两个问题：如果大家想联系你或跟进我们聊的内容，可以在哪里找到你？以及，听众可以为你做些什么？

---

### (01:10:53) Vikrama Dhiman

**English:**
Thank you, Lenny. It's been great talking to you as well. Hopefully, this turns out well. You can reach out to me either on LinkedIn, Vikrama Dhiman, or you can reach out on Twitter. Twitter works better. And the listeners can be useful to me by, well, just sharing whatever they feel. And I continuously follow a lot of people, a lot of people who are not yet famous. Just tell me what your story is, just tell me what you are working on. And as long as you are passionate about it, I will try and find time. Maybe I cannot talk to everyone, but I'll definitely try and find to chat with you and listen out and support or connect you to someone who can help support you.

**中文翻译:**
谢谢你，Lenny。和你聊天也非常愉快。希望这期节目效果不错。你可以在 LinkedIn 上找到我（Vikrama Dhiman），或者在 Twitter 上联系我，Twitter 效果更好。至于听众能为我做什么，嗯，只要分享你们的感受就好。我一直在关注很多人，很多还没成名的人。告诉我你的故事，告诉我你在做什么。只要你对此充满热情，我会尽量抽时间。也许我不能和每个人都聊，但我一定会努力尝试和你交流、倾听并提供支持，或者把你介绍给能帮助你的人。

---

### (01:11:44) Lenny Rachitsky

**English:**
That's a very generous offer, I think a lot of people are going to take you up on that. Vikrama, thank you so much for being here.

**中文翻译:**
这是一个非常慷慨的提议，我想很多人会联系你的。Vikrama，非常感谢你能来。

---

### (01:11:51) Vikrama Dhiman

**English:**
Thank you so much, Lenny.

**中文翻译:**
非常感谢，Lenny。

---

### (01:11:53) Lenny Rachitsky

**English:**
Bye, everyone.
(01:11:55):
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
大家再见。
(01:11:55):
非常感谢收听。如果你觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能极大地帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。