# Wes Kao 2.0 - 双语对照

This is the complete bilingual transcript for Lenny’s Podcast featuring Wes Kao.

---

### [00:00:00] Wes Kao

**English:**
I often see operators who explain things poorly and then are shocked and horrified when people are confused or there's skepticism, there's apathy. I'm a big proponent of asking myself, if I'm not getting the reaction that I'm looking for, how might I be contributing? How could I explain this more clearly? How can I be more compelling? How can I anticipate any questions that they might have?

**中文翻译:**
我经常看到一些运营者（operators）表达得不清不楚，然后当人们感到困惑、怀疑或冷漠时，他们又感到震惊和恐惧。我非常提倡反思：如果我没有得到预期的反应，我可能在哪些方面做得不够？我该如何解释得更清楚？我怎样才能更有说服力？我该如何预判他们可能提出的任何问题？

---

### [00:00:22] Lenny Rachitsky

**English:**
You are one of the best teachers of communication I've ever come across. I made a list of people's favorite tactics and frameworks and approaches that you teach in writing. Any tactics you can share for someone to be a little more concise?

**中文翻译:**
你是我见过的最出色的沟通老师之一。我列了一份清单，收集了大家最喜欢的、你教过的写作技巧、框架和方法。关于如何让表达更简洁，你有什么可以分享的技巧吗？

---

### [00:00:35] Wes Kao

**English:**
I think the blast radius of a poorly written memo is way bigger than most people think. If you are just shooting off a message in a Slack channel with 15 other people, and it's confusing, you didn't include information you should have included, there's going to be a bunch of back and forth. Whereas if you had just taken another look at it, those 15 people would be off to the races.

**中文翻译:**
我认为一份写得很烂的备忘录，其“爆炸半径”（blast radius，指负面影响范围）比大多数人想象的要大得多。如果你只是在有 15 个人的 Slack 频道里随手发一条消息，内容混乱且缺少关键信息，那么接下来就会产生大量的反复沟通。反之，如果你能再检查一遍，那 15 个人就能立刻各就各位，高效开展工作了。

---

### [00:00:52] Lenny Rachitsky

**English:**
You have an awesome framework called MOO.

**中文翻译:**
你有一个非常棒的框架叫 MOO。

---

### [00:00:54] Wes Kao

**English:**
MOO stands for Most Obvious Objection. A lot of times we're surprised by the questions that we get especially in meetings, we feel blindsided. When really, if you thought for even two minutes about what are obvious objections that I'm likely to get, you often immediately come up with what some of those things are. Are you going to be able to anticipate every single objection? No. But can you anticipate the obvious ones? Absolutely.

**中文翻译:**
MOO 代表“最显而易见的异议”（Most Obvious Objection）。很多时候，我们会被收到的问题吓一跳，尤其是在会议中，感觉被打了个措手不及。但实际上，如果你哪怕只花两分钟思考一下“我可能会遇到的显而易见的异议是什么”，你通常能立刻想到其中的一些。你能预判每一个异议吗？不能。但你能预判那些显而易见的吗？绝对可以。

---

### [00:01:22] Lenny Rachitsky

**English:**
Today my guest is Wes Kao. Wes co-created the Alt-MBA program with Seth Godin. She Co-Founded a company called Maven, which I often collaborate with, which makes it easy for people to host live cohort-based courses. She recently left Maven to launch her own course on Executive Communication and Influence. There's a quote that came to mind after I stopped recording this conversation with Wes by George Bernard Shaw, "The single biggest problem in communication is the illusion that it has taken place."

**中文翻译:**
今天的嘉宾是 Wes Kao。Wes 曾与 Seth Godin 共同创立了 Alt-MBA 项目。她还联合创立了 Maven 公司（我也经常与该公司合作），该公司让人们能够轻松举办直播式的训练营课程（cohort-based courses）。她最近离开了 Maven，推出了自己关于“高管沟通与影响力”的课程。在结束与 Wes 的对话后，我想起了萧伯纳的一句话：“沟通中最大的问题，在于人们幻想沟通已经发生了。”

---

### [00:01:51] Lenny Rachitsky (Continued)

**English:**
By the end of this podcast if you listen to what Wes suggests, you'll be a lot closer to becoming a world-class communicator. If you enjoy this podcast, don't forget to subscribe and follow it in your favorite podcasting app or YouTube. Also, if you become a yearly subscriber of my newsletter, you get a year free of Perplexity Pro, Superhuman, Notion, Linear and Granola. Check it out at lennysnewsletter.com. With that, I bring you Wes Kao.

**中文翻译:**
在听完这期播客并采纳 Wes 的建议后，你将离成为世界级沟通者更近一步。如果你喜欢这期播客，别忘了在常用的播客应用或 YouTube 上订阅和关注。此外，如果你成为我时事通讯（newsletter）的年度订阅者，你将免费获得一年的 Perplexity Pro、Superhuman、Notion、Linear 和 Granola 会员。详情请访问 lennysnewsletter.com。下面，让我们欢迎 Wes Kao。

---

### [00:02:18] Lenny Rachitsky (Sponsorship)

**English:**
This episode is brought to you by WorkOS. If you're building a SaaS app, at some point your customers will start asking for enterprise features like SAML authentication and SCIM provisioning. That's where WorkOS comes in, making it fast and painless to add enterprise features to your app. Their APIs are easy to understand so that you can ship quickly and get back to building other features. Today, hundreds of companies are already powered by WorkOS, including ones you probably know like Vercel, Webflow, and Loom.

**中文翻译:**
本期节目由 WorkOS 赞助。如果你正在开发 SaaS 应用，迟早会有客户要求提供企业级功能，如 SAML 身份验证和 SCIM 配置。这就是 WorkOS 的用武之地，它能让你快速且无痛地为应用添加企业级功能。他们的 API 易于理解，让你能快速交付并专注于开发其他功能。如今，已有数百家公司由 WorkOS 提供支持，包括你可能熟悉的 Vercel、Webflow 和 Loom。

---

### [00:02:50] Lenny Rachitsky (Sponsorship Continued)

**English:**
WorkOS also recently acquired Warrant, the Fine Grained Authorization Service. Warrant's product is based on a groundbreaking authorization system called Zanzibar, which was originally designed for Google to power Google Docs and YouTube. This enables fast authorization checks at enormous scale while maintaining a flexible model that can be adapted to even the most complex use cases. If you're currently looking to build role-based access control or other enterprise features like single sign-on, SCIM or user management, you should consider WorkOS. It's a drop-in replacement for Auth0 and supports up to 1 million monthly active users for free. Check it out at workos.com to learn more. That's workos.com.

**中文翻译:**
WorkOS 最近还收购了细粒度授权服务 Warrant。Warrant 的产品基于名为 Zanzibar 的突破性授权系统，该系统最初是为 Google 设计的，用于支持 Google Docs 和 YouTube。这使得在大规模环境下进行快速授权检查成为可能，同时保持了能够适应最复杂用例的灵活模型。如果你目前正寻求构建基于角色的访问控制（RBAC）或其他企业功能（如单点登录 SSO、SCIM 或用户管理），你应该考虑 WorkOS。它是 Auth0 的即插即用替代方案，并免费支持多达 100 万月活跃用户。访问 workos.com 了解更多信息。

---

### [00:03:36] Lenny Rachitsky (Sponsorship Continued)

**English:**
This episode is brought to you by Vanta. When it comes to ensuring your company has top-notch security practices, things get complicated fast. Now you can assess risk, secure the trust of your customers, and automate compliance for SOC 2, ISO 27001, HIPAA and more with a single platform, Vanta. Vanta's market-leading trust management platform helps you continuously monitor compliance alongside reporting and tracking risks. Plus, you can save hours by completing security questionnaires with Vanta AI. Join thousands of global companies that use Vanta to automate evidence collection, unify risk management, and streamline security reviews. Get $1,000 off Vanta when you go to vanta.com/lenny. That's V-A-N-T-A.com/lenny. Wes, thank you so much for being here and welcome back to the podcast.

**中文翻译:**
本期节目由 Vanta 赞助。在确保公司拥有顶尖安全实践方面，情况往往会迅速变得复杂。现在，你可以通过 Vanta 这一个平台来评估风险、赢得客户信任，并自动完成 SOC 2、ISO 27001、HIPAA 等合规认证。Vanta 市场领先的信任管理平台可帮助你持续监控合规性，同时报告和跟踪风险。此外，你还可以通过 Vanta AI 完成安全问卷，从而节省数小时的时间。加入全球数千家使用 Vanta 自动化证据收集、统一风险管理并简化安全审查的公司吧。访问 vanta.com/lenny 即可享受 1000 美元的优惠。Wes，非常感谢你的到来，欢迎回到播客。

---

### [00:04:36] Wes Kao

**English:**
Thanks, Lenny. I'm very honored to be a second-time guest.

**中文翻译:**
谢谢，Lenny。我很荣幸能第二次担任嘉宾。

---

### [00:04:40] Lenny Rachitsky

**English:**
Very rare honor. No pressure, but I think this is going to be one of the highest leverage episodes I've done and let me tell you why I think that's the case in the newsletter and on the podcast, I often talk about just how important and how high leverage the skill of communication is to product leaders, to leaders, just to people in general. There's this quote that Boz, the CTO of Meta, he's been on the podcast, he wrote this famous blog post, "Communication is the job." And I think that's true for product people, but it's true for basically any sort of leadership role. Anyone trying to get ahead. And you are one of the best communicators I've ever met. You are one of the best teachers of communication I've ever come across. You have one of the most popular courses on Maven, on executive communication, so I'm really excited to have you here and to help people become better communicators, better at influence and all these things. So thank you again for being here.

**中文翻译:**
这是非常罕见的荣誉。虽然不想给你压力，但我认为这将是我做过的杠杆率最高（highest leverage）的节目之一。让我告诉你原因：在我的 newsletter 和播客中，我经常谈到沟通技巧对于产品领导者、管理者以及普通人来说是多么重要，杠杆作用有多大。Meta 的 CTO Boz（他也上过这个播客）曾写过一篇著名的博文，标题是“沟通就是工作本身”。我认为这对产品人来说是真理，对任何领导角色或想要出人头地的人来说也是如此。你是我见过的最优秀的沟通者之一，也是我遇到过的最好的沟通老师。你在 Maven 上有一门关于高管沟通的极受欢迎的课程，所以我非常激动能请你来，帮助大家成为更好的沟通者，提升影响力。再次感谢你的到来。

---

### [00:05:32] Wes Kao

**English:**
Absolutely.

**中文翻译:**
当然，这是我的荣幸。

---

### [00:05:34] Lenny Rachitsky

**English:**
Okay. So something that I often do with guests on the podcast, not even often, always, I ping people that the guests have worked with and ask them, "What should I ask Wes? What should I know about Wes?" Let me read a few quotes about you in regards to your communication skills from folks that have worked with you-

**中文翻译:**
好的。我经常对播客嘉宾做的一件事——其实不是经常，是每次都会做——就是联系那些与嘉宾共事过的人，问他们：“我该问 Wes 什么？关于 Wes 我该了解些什么？”让我读几段与你共事过的人对你沟通能力的评价：

---

### [00:05:51] Lenny Rachitsky (Continued)

**English:**
And these are three different people. Okay, so first, "Wes single handedly raised the quality of the entire company's writing by like two X across the board. I always say the best writing course I ever took was working with Wes for a year."

**中文翻译:**
这是来自三个不同的人。首先，“Wes 凭一己之力将整个公司的写作质量全面提升了两倍。我常说，我上过最好的写作课就是与 Wes 共事的一年。”

---

### [00:06:07] Wes Kao

**English:**
Wow.

**中文翻译:**
哇。

---

### [00:06:09] Lenny Rachitsky

**English:**
Okay. That's one. "Wes never just throws things out there, she's precise with her use of language, meticulous about examining her own ideas before bringing them in front of others and knows how to make her points in a way that people will understand them and buy into them." Okay. And third, "Wes includes a reasoning with every proposal in the context behind all of her recommendations so that everyone around her learns in order of magnitude faster. This also makes her an exceptional teacher because she can clearly define what excellence is and why something is the goal, and then break down the steps and principles involved." Okay, reactions.

**中文翻译:**
好，这是第一个。第二个：“Wes 从不随意抛出想法，她用词精准，在向他人展示想法之前会细致地审视自己的观点，并且知道如何以一种让人理解并认可的方式表达观点。”第三个：“Wes 在每个提案中都会包含推理过程和建议背后的背景，这让周围的人学习速度提升了一个数量级。这也使她成为一名卓越的老师，因为她能清晰地定义什么是优秀，为什么某个目标是核心，然后拆解其中的步骤和原则。”好，你有什么反应？

---

### [00:06:46] Wes Kao

**English:**
Those are really nice things. That's amazing. Yeah, thank you so much.

**中文翻译:**
这些评价太棒了。太惊人了。是的，非常感谢。

---

### [00:06:52] Lenny Rachitsky

**English:**
And these are people across different companies, so.

**中文翻译:**
而且这些人来自不同的公司。

---

### [00:06:55] Lenny Rachitsky (Continued)

**English:**
Okay, so that was just to highlight of how good you are at this stuff. And what we're going to be doing with our chat is going through a bunch of your tactics that you teach and that have helped people become better communicators, executive communicators, better at influence. Before we get into the specific tactics, is there anything that you think is important for people to understand just broadly around the skill of becoming a better communicator?

**中文翻译:**
好，这只是为了强调你在这些方面有多厉害。我们接下来的对话将深入探讨你教授的一系列技巧，这些技巧曾帮助人们成为更好的沟通者、高管沟通者，并提升影响力。在我们进入具体技巧之前，你认为在提升沟通能力这个大课题下，有哪些基础观念是大家必须理解的？

---

### [00:07:17] Wes Kao

**English:**
I often see operators who explain things poorly and then are shocked and horrified when people are confused or there's skepticism, there's apathy, there's a lot of avoidable questions, and I'm a big proponent of asking myself, "If I'm not getting the reaction that I'm looking for, how might I be contributing to that?" So, you know, instead of blaming other people for not understanding me, I think about how could I explain this more clearly? How can I be more compelling? How can I anticipate any questions that they might have? So I'm a big proponent of agency. And realizing that we can only control our own behavior. And so the best place to start, if you're not getting the reaction you're looking for, is reflecting on how can I get better at the skill of communicating? And it absolutely is a skill.

**中文翻译:**
我经常看到一些执行者解释得一塌糊涂，然后当别人感到困惑、怀疑、冷漠，或者问出一堆本可以避免的问题时，他们又感到震惊和愤慨。我非常主张问自己：“如果我没有得到想要的反应，我可能在其中起到了什么作用？”所以，与其责怪别人不理解我，我会思考：我怎样才能解释得更清楚？我怎样才能更有说服力？我该如何预判他们可能有的疑问？我非常看重“主体性”（agency），并意识到我们只能控制自己的行为。因此，如果你没有得到预期的反应，最好的切入点就是反思：我该如何提升沟通这项技能？而这绝对是一项可以习得的技能。

---

### [00:08:11] Lenny Rachitsky

**English:**
So what I'm hearing is if you're having a hard time people buying into what you're trying to convince them to do or you're finding people are doing not what you asked them to do, it's likely an issue with your ability to communicate, it's probably not their fault.

**中文翻译:**
所以我听到的是：如果你很难让别人认同你的想法，或者发现别人做的事和你要求的完全不同，这很可能是你的沟通能力出了问题，而不是他们的错。

---

### [00:08:28] Wes Kao

**English:**
Yeah, I would say so. You can't solve everything with improving your communication, but you can increase the likelihood of getting what you want.

**中文翻译:**
是的，我会这么说。提升沟通能力不能解决所有问题，但它能增加你获得想要结果的可能性。

---

### [00:08:39] Wes Kao (Continued)

**English:**
I think another big one that I teach in my course and really kick off with is practicing like it's game day, playing like it's game day. So I see a lot of operators who save their best behavior for executives only. So you know, they want to shine when they're presenting to senior leadership, but with everyone else, they're kind of calling it. And I just don't think that you're going to be able to get enough reps to actually get good at executive communication if you are only doing it with executives. Because many of us only present to execs once a month, right? Or a couple of times a quarter. And that's just not a lot of chance to practice. So really treating every single stakeholder as if they are important because they are, and you shouldn't be if you don't want to waste your CEO's time, you also shouldn't waste your cross-functional team members' time or your manager's time or your direct reports' time. So that's something else that I ask to keep in mind.

**中文翻译:**
我在课程中教授并作为开篇的另一个重点是：像正式比赛一样去练习，像正式比赛一样去表现（practicing like it's game day）。我看到很多执行者只在面对高管时才表现出最好的一面。他们想在向高级领导层汇报时大放异彩，但在面对其他人时就敷衍了事。我认为，如果你只在面对高管时才练习，你根本无法获得足够的练习次数（reps）来真正掌握高管沟通技巧。因为我们大多数人可能一个月才向高管汇报一次，或者一个季度才几次。这练习机会太少了。所以，要真正把每一位利益相关者都当作重要人物来对待，因为他们确实很重要。如果你不想浪费 CEO 的时间，你同样也不应该浪费跨职能团队成员、你的经理或你的下属的时间。这是我希望大家记住的另一点。

---

### [00:09:39] Lenny Rachitsky

**English:**
And maybe a last question before we get into the tactics. When people think communication, they think email, they think meeting presentations, things like that. How do you think about, when you talk about executive communication and communication in general, what's kind of the umbrella of things that includes?

**中文翻译:**
在进入具体技巧之前，还有一个最后的问题。当人们想到沟通时，会想到电子邮件、会议演示之类的。当你谈论高管沟通和广义的沟通时，这个范畴里包含哪些内容？

---

### [00:09:53] Wes Kao

**English:**
Yeah, I would say broadly the two mediums are verbal communication and written. So verbal being meetings, conversations, presentations. And written being emails, strategy docs, notion docs, Slack messages, text messages, those two categories broadly. And I also think about communication as more of a means to an end, which might be interesting for some people because I teach a course on communication. So you would think that's like the end in and of itself, but I really see it as a means to an end where the end is getting the ideal outcome you're looking for. So whether that is buy-in or making a good decision as a team or moving to the next step, whatever that might be, communication is really in service of that end goal.

**中文翻译:**
广义上讲，沟通有两种媒介：口头沟通和书面沟通。口头沟通包括会议、对话、演示；书面沟通包括电子邮件、战略文档、Notion 文档、Slack 消息、短信。我也认为沟通更多是一种达到目的的手段，这对某些人来说可能很有趣，因为我教的是沟通课，你可能会觉得沟通本身就是目的。但我认为沟通是手段，目的是获得你想要的理想结果。无论是获得认可、团队做出正确决策，还是推进到下一步，沟通都是为那个最终目标服务的。

---

### [00:10:58] Lenny Rachitsky

**English:**
Okay. So I made a list of people's favorite tactics and frameworks and approaches that you teach, and talking to folks that you've taught and folks that you've worked with. So I'm just going to go through a bunch and let's just help people get better at these things.

**中文翻译:**
好的。我根据你教过的人和共事过的人的反馈，列出了一份大家最喜欢的技巧、框架和方法清单。我会逐一过一遍，让我们一起帮助大家提升这些能力。

---

### [00:11:00] Wes Kao

**English:**
All right, let's do it.

**中文翻译:**
太好了，开始吧。

---

### [00:11:07] Wes Kao (Continued)

**English:**
Yes. So a common mistake that I see is overestimating the amount of buy-in that you have from your audience. So that looks like jumping straight into talking about the logistics, the details of the how to do something, of the process. When in reality your audience has not yet decided if they even want to do the thing. So what I see operators do in response then is go even deeper into the logistics and the how, thinking that, "Oh, if I just explain this more than that person will want to do it." When really a sales note is different than a logistics note. A sales note is meant to get people excited to do the thing you want them to do, and to agree to do it. And only then after they have bought in, does it make sense to share the logistics.

**中文翻译:**
是的。我看到的一个常见错误是高估了听众对你的认可程度。这表现为直接跳到谈论执行细节（logistics）、如何做的细节或流程。而实际上，你的听众甚至还没决定是否要做这件事。我看到执行者的反应是进一步深入细节和方法，心想：“噢，如果我解释得更详细，那个人就会想做了。”但实际上，“推销型信息”（sales note）和“执行型信息”（logistics note）是不同的。推销型信息是为了让人们对你想让他们做的事感到兴奋并同意去做。只有在他们认可之后，分享执行细节才有意义。

---

### [00:11:57] Wes Kao (Continued)

**English:**
So there's an order of operations here. If you switch the order of operations, you will likely get a slow response or just no response, right? We've all put a Slack message in a channel and got crickets and tumbleweed. So really starting off with selling the person and making sure that they know why we're doing this, why this matters to the company, why now, and then sharing the logistics tends to be a lot more effective.

**中文翻译:**
所以这里有一个操作顺序。如果你搞反了顺序，很可能会得到缓慢的反应甚至根本没有反应。我们都经历过在 Slack 频道发了消息却无人理睬的情况。因此，先“推销”给对方，确保他们知道我们为什么要这么做、这对公司为什么重要、为什么是现在，然后再分享执行细节，这样做往往有效得多。

---

### [00:12:22] Lenny Rachitsky

**English:**
Is there an example of that that might help illustrate that point or that approach?

**中文翻译:**
有没有什么例子可以帮助说明这个观点或方法？

---

### [00:12:27] Wes Kao

**English:**
Yeah. So one of my clients is a head of operations and she was trying to get the rest of her executive team, which she was a part of, to fill in some wins for the week so that they could share this out with the whole company. And this was going to be motivating, it was going to shine a light on folks. And she led with the logistics of which document to send, to put the details in, what time to put it in by, the format that you should put these wins and didn't really get much of a response from the leadership team, which makes sense, right? Because this totally sounds like one of those things that's another item to check off on your list when you already have so many other things to do and here's this other process that like we're all supposed to do now, like yay, right? And so she wasn't really getting response. And that's because she dove straight into logistics.

**中文翻译:**
有的。我的一个客户是运营负责人，她当时想让高管团队的其他成员（她也是其中一员）填写本周的一些“战果”（wins），以便向全公司分享。这本该是件激励人心、让大家露脸的事。但她一开始就谈执行细节：发哪个文档、把细节填在哪、截止时间是什么、填写的格式是什么。结果高管团队没什么反应。这很正常，对吧？因为这听起来就像是待办清单上又多了一项任务，在你已经忙得不可开交的时候，又来了一个“大家现在都得做”的新流程，谁会高兴呢？所以她没得到回应，因为她直接扎进了执行细节。

---

### [00:13:20] Wes Kao (Continued)

**English:**
Whereas what she could have done is start by selling folks, selling the other executives on why are we doing this? Well, we're doing this because this is a chance to shine a light on your team members who are doing amazing work, for them to feel motivated and to feel like the rest of the company really sees them and understands what they're doing. And this is all something that is going to motivate your team, right? So sharing why this is helpful and useful and how this is in service of you and your team versus like, "Oh, this is a favor that you're doing for me to fill out this form and fill it out this way and by this date," et cetera, et cetera.

**中文翻译:**
相反，她本可以先向其他高管“推销”：我们为什么要这么做？我们这么做是因为这是一个让你那些表现卓越的团队成员发光发热的机会，让他们感到受激励，感到公司看到了并理解他们的工作。这最终会激励你的团队。所以，分享为什么这很有帮助、很有用，以及它是如何为你和你的团队服务的，而不是说：“噢，请帮我个忙填一下这个表，按这个格式，在这个日期前填好。”

---

### [00:14:00] Lenny Rachitsky

**English:**
I know that execs often want the opposite where they're just like, "Okay, I know, just tell me what you want to do. Just like, okay, just get to the point. I don't want time for all this context and background." Any advice on when to spend any time on the sales? Like what are signs that, okay, maybe you don't have them sold yet, or what are maybe contexts where you should probably still try to sell them first?

**中文翻译:**
我知道高管们往往想要相反的方式，他们会说：“行了，我知道了，直接告诉我你想做什么。直接切入正题，我没时间听这些背景和上下文。”关于什么时候该花时间“推销”，你有什么建议吗？比如，有哪些迹象表明他们还没被说服？或者在哪些情境下，你仍然应该尝试先推销？

---

### [00:14:20] Wes Kao

**English:**
Yeah. So I actually think that you should always do a little bit of selling even for situations where people have generally bought in. Because most of us have a lot going on and we're not actively thinking about whatever you're talking about. So even though I agreed to something two weeks ago, by the time you're telling me about it again, like I thought about a billion other things since then, right? So reminding me of why are we talking about this? Why does this matter? And then getting into it and framing that conversation upfront is way more likely for us to not get stuck in a cold start and not kind of go two steps back one step forward.

**中文翻译:**
是的。实际上我认为，即使在大家普遍已经认可的情况下，你也应该总是做一点点“推销”。因为我们大多数人都很忙，不会一直主动思考你正在谈论的事情。所以，即使我两周前同意了某件事，当你再次提起时，我已经考虑过成千上万件其他事了。因此，提醒我：我们为什么要谈论这个？这为什么重要？然后在开始之前先对对话进行铺垫（framing），这样我们就不太可能陷入“冷启动”，也不会出现退两步进一名的尴尬局面。

---

### [00:14:55] Wes Kao (Continued)

**English:**
The other thing is, you can frame a conversation and sell a bit at the beginning very concisely. So I'm not talking about spending 15 minutes out of a 30 minute meeting selling, I'm talking about one to two minutes, even a couple sentences, and then transitioning into the main thing you want to talk about. So I'm a huge proponent of doing that and basically reminding people, why are we doing this? Why are we here today? Why does this matter? And then getting into the meat.

**中文翻译:**
另一件事是，你可以在开始时非常简洁地铺垫对话并做一点推销。我不是说在 30 分钟的会议里花 15 分钟去推销，我说的是一两分钟，甚至几句话，然后过渡到你想谈的核心内容。我非常提倡这样做，基本上就是提醒大家：我们为什么要这么做？我们今天为什么聚在这里？这为什么重要？然后再进入实质内容。

---

### [00:15:24] Lenny Rachitsky

**English:**
I love that. So basically you can do this really briefly, it doesn't have to be a whole pitch for half an hour. It's just a reminder, "Here's why we think this is important." And I think that's such a good point because a lot of times it's like a leader is looking at this thing you're asking them to do and they're like, "Why are we even, why am I spending time on this?" And just a reminder of like, "Okay, I see, I forgot this was going to be, this a part of our strategy, this has this much impact potential or here's how it could help our team be more efficient."

**中文翻译:**
我太喜欢这个建议了。基本上你可以做得非常简短，不需要半小时的完整宣讲。只是一个提醒：“这就是为什么我们认为这很重要。”我觉得这点非常好，因为很多时候领导看着你要求他们做的事，心里在想：“我们为什么要搞这个？我为什么要在这上面花时间？”而一个提醒能让他们想起：“噢，我明白了，我忘了这是我们战略的一部分，它有这么大的潜在影响力，或者它能如何帮助我们的团队提高效率。”

---

### [00:15:52] Wes Kao

**English:**
Yeah. And you can really do that in like 30 seconds.

**中文翻译:**
是的，你真的可以在 30 秒内完成。

---

### [00:15:56] Lenny Rachitsky

**English:**
Is there like a, I don't know, structure to this? Is it just like why? Is there a kind of a template you like or some way you recommend of selling first? Is it like, "Here's why we're doing this." Starting like that? Anything along those lines?

**中文翻译:**
这有什么结构吗？就是说“为什么”吗？有没有你喜欢的模板，或者你推荐的先推销的方法？比如以“这就是我们做这件事的原因”开头？诸如此类的。

---

### [00:16:09] Wes Kao

**English:**
Yeah. I think explaining why we're doing this, why this benefits the business, what problem this is solving. Again, you can do a lot of this in a couple of sentences. And then I also like asking or stating what I need from the other person upfront. So saying, "Hey, we're here today because two weeks ago we were reviewing the product flow and realized that there were a couple of parts that were kind of confusing. So I took a stab at fixing those areas, rewriting the microcopy, and I want to present them to you today, see if you agree with these changes, and then we're going to roll them out. What I'm looking for from you is feedback on the changes and if you agree." So like that was like 15 seconds, right? Super fast. And then now we're all on the same page about why we're here. And you can listen more intently knowing that I'm looking for a certain kind of feedback.

**中文翻译:**
是的。我认为要解释我们为什么要这么做，这对业务有什么好处，解决了什么问题。同样，几句话就能搞定。然后，我也喜欢在一开始就提出或说明我需要对方做什么。比如：“嘿，我们今天聚在这里是因为两周前我们在审查产品流程时，发现有几个地方比较令人困惑。所以我尝试修复了这些区域，重写了微文案（microcopy），今天我想向你展示一下，看你是否同意这些改动，然后我们就发布。我需要你对这些改动提供反馈，并确认你是否同意。”看，这大概只花了 15 秒，非常快。现在大家对我们为什么聚在这里达成了一致，你也能更专注地听，因为你知道我需要哪种反馈。

---

### [00:17:01] Lenny Rachitsky

**English:**
I would love to hear it that way. I think there's like an implication here that maybe is worth sharing of just, a lot of this is about communicating effectively to execs, which will make you communicate better to most people. But especially with folks up the ladder. They don't have a lot of time, they have a million things in their head. Maybe just share like why this is so important, like what the state of mind of a leader is that you need to kind of break through.

**中文翻译:**
我很喜欢这种沟通方式。我觉得这里有一个隐含的意义值得分享：很多内容是关于如何有效地与高管沟通，这也会让你与大多数人的沟通变得更好。但特别是对于那些职位更高的人，他们没有太多时间，脑子里装着成千上万件事。也许你可以分享一下为什么这如此重要，比如领导者的心态是怎样的，你需要突破什么样的心理防线？

---

### [00:17:25] Wes Kao

**English:**
Yeah. So I call it the yes, yes, yes, next, next, next mindset where if I'm listening to direct reports present something to me, very often I find myself thinking, "Got it. All right, yes, let's keep going." Right? And you know, on the other side of that, I've often presented to executives where I had a 15 slide deck and execs would do that and I'd be like, whoa, whoa, whoa. Like I have a whole sequence, I have a whole order, you know? And sometimes they would give me buy or make the decision by slide four, you know? And I'd be like, "Okay, well you know, slide 13, I want to show you this great graph I put together." Right? And what was really helpful for me was realizing that I should take the win. Okay, if five seconds already agreed, take the win and keep it moving, move on.

**中文翻译:**
是的。我称之为“是、是、是，下一个、下一个、下一个”的心态。当我听下属向我汇报时，我经常发现自己在想：“懂了，行，好，继续。”而在另一面，我也经常向高管汇报，我准备了 15 页的 PPT，高管们表现出那种心态时，我会想：“喔，等等，我有一整套逻辑顺序呢。”有时他们在第 4 页就同意了或做出了决定，我会想：“好吧，但第 13 页我还有个很棒的图表想给你看呢。”对我来说，真正有帮助的是意识到我应该“见好就收”。如果 5 秒钟内他们就同意了，那就接受这个胜利，继续推进，进入下一项。

---

### [00:18:13] Lenny Rachitsky

**English:**
Yeah. What's that quote like? "If you've sold them, stop talking."

**中文翻译:**
是的。那句话是怎么说的来着？“如果你已经说服了他们，就闭嘴。”

---

### [00:18:16] Wes Kao

**English:**
Right. Yes. Yeah, you might talk them out of agreeing.

**中文翻译:**
没错。是的，你可能会因为说得太多反而让他们反悔。

---

### [00:18:20] Lenny Rachitsky

**English:**
Yeah. Okay. You mentioned being concise. Let's talk about that. You have some really good advice on just how to effectively be concise and not too concise. What's your advice there?

**中文翻译:**
好。你提到了简洁。我们来聊聊这个。关于如何有效地保持简洁而又不过于简略，你有一些非常好的建议。你的建议是什么？

---

### [00:18:31] Wes Kao

**English:**
Yes. One of my pet peeves is when people are too concise and they equate being concise with brief, being brief. And being concise is not about absolute word count, it's about economy of words. It's about the density of the insight that you're sharing. And so you can have a 300 word memo that's meandering and long-winded and a thousand word memo that is tight and concise. And so not equating concision with briefness I think is a really big one to understand.

**中文翻译:**
是的。我最受不了的事情之一就是人们过于简洁，并把“简洁”（concise）等同于“简短”（brief）。简洁不在于绝对的字数，而在于用词的经济性，在于你分享的洞察的密度。你可以有一份 300 字却废话连篇、不知所云的备忘录，也可以有一份 1000 字却逻辑严密、言简意赅的备忘录。所以，不要把简洁等同于简短，我认为这是非常重要的一点。

---

### [00:19:05] Wes Kao (Continued)

**English:**
The second thing is a lot of advice about being concise, I think misses an important point. So we've all heard, "Don't bury the lead, cut to the chase." Main point, put the main point at the top, bottom line up front, right? And all of these pithy aphorisms assume that you actually know what your core point is. So you can't cut to the chase unless you know what the chase is. You can't unbury the lead unless you know what the lead is. And so that I found is the bottleneck to being concise. It's actually not really being clear of what you are thinking, that's what's leading to being long-winded.

**中文翻译:**
第二点是，很多关于简洁的建议都忽略了一个重点。我们都听过“不要埋没重点（lead），开门见山（cut to the chase）”。核心观点放在开头，结论先行（bottom line up front），对吧？所有这些精辟的格言都假设你其实知道自己的核心观点是什么。但如果你不知道“山”在哪，你就没法“开门见山”。如果你不知道重点是什么，你就没法把它挖出来。所以我发现，保持简洁的瓶颈在于：你其实并不清楚自己在想什么，这才是导致啰嗦的原因。

---

### [00:19:49] Wes Kao (Continued)

**English:**
And you can kind of test this theory because most of us have a go-to story that we've told a bunch of times, right? We're like, you know exactly when people are going to laugh, you know when they're going to gasp or hold their breath, right? And why are you so good at telling that story and why are you so concise about it? Because you've told it a bunch of times, you know all of the beats. So in meetings though, at work, we are very rarely talking about the same thing that many times it's always something new. It's something that we are also probably likely processing ourselves and are in the midst of processing as we are in a quick turnaround time, telling someone else about it, telling our team about it. And so you are basically asking your brain to do a lot of different processes, especially in a real time conversation. You're listening to the other person absorbing, making sense of it, processing it, figuring out what you think and how you would react.

**中文翻译:**
你可以测试一下这个理论：我们大多数人都有一个讲过很多次的拿手故事，对吧？你清楚地知道人们什么时候会笑，什么时候会惊呼或屏住呼吸。为什么你讲那个故事讲得那么好、那么简洁？因为你讲过很多次，你熟悉所有的节奏。但在工作中，在会议上，我们很少会把同一件事讲那么多遍，总是有新东西。这些东西可能我们自己还在消化中，就在这紧迫的时间里，我们要把它告诉别人，告诉团队。所以你基本上是在要求大脑同时处理很多不同的过程，尤其是在实时对话中。你在听对方说话、吸收信息、理解含义、处理信息、思考自己的观点以及如何反应。

---

### [00:20:39] Wes Kao (Continued)

**English:**
And then trying to say something cohesive that makes sense, right? And then trying to be concise about it. So it's just a lot of different processes. And so the only solution I found consistently to being concise is preparation. It's not a very glamorous solution by any means, but the clearer I am going into a meeting, going into a conversation, going into a pitch, the better I am at being concise and being able to bring the conversation back to the most important points at being able to stay flexible, but also firm and preparation. I don't mean spending hours and hours preparing for a weekly meeting, even a couple of minutes really makes a huge difference.

**中文翻译:**
然后你还要尝试说出一些连贯、有意义的话，并且还要保持简洁。这涉及太多不同的过程了。因此，我发现能始终保持简洁的唯一方法就是准备。这绝不是一个多么光鲜亮丽的解决方案，但我在进入会议、对话或提案之前思路越清晰，我就越能保持简洁，越能将对话引回最重要的点，越能保持灵活而坚定。我说的准备不是指花好几个小时准备周会，哪怕只是几分钟也会产生巨大的差异。

---

### [00:21:25] Wes Kao (Continued)

**English:**
Most of us are so back to back in meetings that we're doing zero preparation. It's like the meeting has started 30 seconds in and you're still unwinding from the last Zoom call that you were on, right? So most of us are in that mental state. So if you even take 30 seconds to one minute to ground yourself on why am I in this meeting? What do I want to share and make sure I get across in the time that we have, you're going to go in there so much more focused and so much more able to be concise.

**中文翻译:**
我们大多数人的会议都是一个接一个的，根本没有准备。会议开始了 30 秒，你还在从上一个 Zoom 电话中回过神来，对吧？大多数人都处于这种心理状态。所以，如果你能花 30 秒到 1 分钟让自己定下心来：我为什么要参加这个会议？在有限的时间里，我想分享什么并确保传达清楚？你进去之后会专注得多，也更能保持简洁。

---

### [00:21:51] Lenny Rachitsky

**English:**
So the advice there, so this is for meetings and I want to talk about writing also, but for meetings, the advice here is before you get into a meeting, actually think about why am I in this meeting? What do I want to get out of it? Instead of in the meeting figuring out a lot as you go, which to your point, you're just going to ramble and be like, "Oh, okay, here's what I actually want to say."

**中文翻译:**
所以这里的建议是——这是针对会议的，稍后我也想聊聊写作——在进入会议之前，真正思考一下：我为什么要参加这个会议？我想从中得到什么？而不是在会议中边走边想，那样的话就像你说的，你会胡言乱语，然后突然意识到：“噢，好吧，这才是我想说的。”

---

### [00:22:10] Wes Kao

**English:**
Yeah. And what might I want to share in the meeting too? You know, especially for more introverted folks. Sometimes you need to decide beforehand that you want to speak and you want to make sure you get a certain point across. So even deciding that beforehand makes a huge difference.

**中文翻译:**
是的。还有我在会议中可能想分享什么？你知道，尤其是对于性格内向的人。有时你需要提前决定自己要发言，并确保传达出某个特定的观点。哪怕只是提前做这个决定，也会产生巨大的影响。

---

### [00:22:25] Lenny Rachitsky

**English:**
Yeah, I found this extremely powerful just like five minutes before you get into a meeting. And it could happen earlier in the day, right? It doesn't have to happen right before the meeting, or worst case, it's right before the meeting. Just, "Okay, what do I want to get out of this? What am I here? What do I want to say?" And just like giving your brain a little bit of time to prepare. Super powerful. In writing, is there like any tactics you can share for someone to be a little more concise?

**中文翻译:**
是的，我发现这非常有效，就在开会前五分钟。也可以在当天的早些时候做，对吧？不一定要在会议紧接之前，或者最坏的情况是在会议开始前一刻。只需想：“好，我想从中得到什么？我为什么在这？我想说什么？”给大脑一点时间准备。非常强大。在写作方面，你有什么技巧可以让表达更简洁吗？

---

### [00:22:50] Wes Kao

**English:**
I think the main tactic is to remind yourself to be concise. And usually when I do that, I end up trimming 20% at least of what I wrote, tightening up some sentences. I also ask myself, how might I be adding cognitive load to whatever it is that I'm saying? So is there a tighter, clearer, cleaner way that I can ask what I'm asking or present the information I'm presenting or make the recommendation that I'm making? And usually if you even ask yourself that, your brain automatically comes up with stuff. You just see whatever you wrote differently and you're like, "Oh shit, I could trim this entire paragraph because that's secondary." And maybe you have your primary message in Slack, and then within the thread add some of the secondary stuff, right? So I find that most of us, it's reminding yourself to be concise. And once you think of it, your brain naturally will see places where you can trim.

**中文翻译:**
我认为主要的技巧是提醒自己要简洁。通常当我这么做时，我最终会删减掉至少 20% 的内容，并精简句子。我还会问自己：我所说的话是否增加了对方的认知负荷（cognitive load）？有没有更精炼、更清晰、更干净的方式来提出我的问题、展示我的信息或给出我的建议？通常只要你问自己这个问题，你的大脑就会自动想出办法。你会以不同的眼光看待自己写的东西，然后心想：“噢，该死，我可以删掉这一整段，因为那是次要的。”也许你可以在 Slack 里发主消息，然后在回复线（thread）里添加次要内容，对吧？所以我发现，对大多数人来说，关键是提醒自己要简洁。一旦你有了这个念头，你的大脑自然会发现可以删减的地方。

---

### [00:24:00] Lenny Rachitsky

**English:**
There's a layer of advice under this that you're not saying that I'm going to say, which is actually look at the thing you wrote at least once before you share it. Because I used to be really bad at this. I just like, "Okay, I don't have time. I wrote this doc, send it, get feedback. All right. Send this email. I don't have time to read this email." And I find just forcing yourself to look at it solves so much of this.

**中文翻译:**
这下面还有一层你没说但我一定要说的建议，那就是：在分享之前，至少把你自己写的东西看一遍。因为我以前在这方面做得非常糟糕。我总是想：“好，我没时间了。文档写好了，发出去，等反馈。行，邮件发了，我没时间读这封邮件。”我发现，仅仅是强迫自己看一遍，就能解决大部分问题。

---

### [00:24:10] Wes Kao

**English:**
Oh, yes, yes, definitely. I was assuming before doing that, but you're right, some people might not be. And yes, definitely reading your own message first is huge. And yeah, I find that even doing that you can often spot a lot of low-hanging fruit.

**中文翻译:**
噢，是的，绝对是。我刚才假设大家都会这么做，但你是对的，有些人可能不会。是的，先读一遍自己的消息非常重要。而且我发现，即使只是读一遍，你通常也能发现很多显而易见的改进点（low-hanging fruit）。

---

### [00:24:51] Lenny Rachitsky

**English:**
Right. You'll find the typos and grammar issues and you'll be like, "Oh, I don't need this word." Along those lines, let me share two books. People always ask me, "How did you learn to write?" I'm like, "I'm not a writer, I don't know what I'm doing." But two books really helped me write more effectively. And one is specifically to help you write more concisely called On Writing Well. I don't know if you've read that.

**中文翻译:**
没错。你会发现错别字和语法问题，你会想：“噢，我不需要这个词。”顺便分享两本书。人们总问我：“你是怎么学习写作的？”我说：“我不是作家，我也不知道自己在干嘛。”但有两本书确实帮我提高了写作效率。其中一本专门教你如何写得更简洁，叫《论写作》（On Writing Well）。不知道你读过没。

---

### [00:25:12] Wes Kao

**English:**
Is this by Sol Stein or another author?

**中文翻译:**
是 Sol Stein 写的还是别的作者？

---

### [00:25:19] Lenny Rachitsky

**English:**
I don't have it... It's somewhere in my bookshelf. So we'll look it up. There's also Writing Well I think by Stephen King, that's another one that people love, but there On Writing Well is the one I really loved because it's very tactical.

**中文翻译:**
我手头没有……在我的书架某处。我们会查一下。还有一本 Stephen King 写的《写作这回事》（On Writing），那本也很受欢迎，但我真的很喜欢《论写作》（On Writing Well），因为它非常具有实操性。

---

### [00:25:37] Wes Kao

**English:**
Going back to something that you were saying earlier with rereading what you wrote, I think the blast radius of a poorly written memo is way bigger than most people think. So if you're just shooting off a message in a Slack channel with 15 other people and it's confusing and you didn't include information you should have included, there's going to be a bunch of back and forth. All 15 of these people are reading this being like, "Okay, what do I do with this?" Whereas if you had just taken another look at it, those 15 people would be off to the races. They would've read your message and then known exactly what to do next or what their part was or what you were looking for from them. So I think about that a lot too. It's not just me writing this and sending it off. It's, "Who are all the people who are going to come in contact with this message who are going to refer to it and use it? And if I just take 30 more seconds to make sure that it's clean, how much can I unblock from their work?"

**中文翻译:**
回到你之前说的重读自己写的内容，我认为一份写得很烂的备忘录的“爆炸半径”比大多数人想象的要大得多。如果你只是在有 15 个人的 Slack 频道里随手发一条消息，内容混乱且缺少关键信息，那么就会产生大量的反复沟通。这 15 个人读到消息时都会想：“好吧，我该拿这个怎么办？”而如果你能再检查一遍，那 15 个人就能立刻行动起来。他们读完你的消息，就会确切地知道下一步该做什么，自己的职责是什么，或者你需要他们提供什么。我也经常思考这个问题：这不仅仅是我写完发出去就了事了。而是“所有会接触到这条消息、会引用和使用它的人是谁？如果我多花 30 秒确保它清晰明了，我能为他们的工作扫除多少障碍？”

---

### [00:26:34] Lenny Rachitsky

**English:**
That's such a good point. I like that, I love that term blast radius. It's such a good point. Just like there's so much negative leverage in writing inefficiently and inconcisely. If you spend like... Inconcisely? I don't know the word is there, but if you just spend three minutes spending a little more time making it more clear just like the impact and leverage that has, that's such a good point. I looked up the books, it's so funny. Okay, so there's On Writing Well by William Zinsser. There's Stein On Writing by Sol Stein, which is what you said you were talking about. And then Stephen King has a book called On Writing. Everyone's got the same.

**中文翻译:**
说得太好了。我喜欢“爆炸半径”这个词。这确实是个好观点。低效且不简洁的写作会产生巨大的负面杠杆。如果你花三分钟多一点时间让它更清晰，那产生的影响和杠杆作用是巨大的。我查了一下那些书，太搞笑了。好，有一本 William Zinsser 写的《论写作》（On Writing Well），有一本 Sol Stein 写的《斯坦谈写作》（Stein On Writing），也就是你提到的那本。然后 Stephen King 有一本叫《写作这回事》（On Writing）。大家的书名都差不多。

---

### [00:27:12] Lenny Rachitsky (Continued)

**English:**
Not ideal for SEO but On Writing Well is the one that I love by William Zinsser. There's also one called A Series Of Short Sentences if you haven't seen that one. It's a really good rate too. It's just how to write short sentences and just the power of just keeping sentences short, which I struggle with.

**中文翻译:**
虽然对 SEO 不太友好，但我最喜欢的是 William Zinsser 的《论写作》。还有一本叫《短句系列》（A Series Of Short Sentences），如果你没看过的话，那本也很棒。它讲的是如何写短句，以及保持句子简短的力量，这正是我所纠结的。

---

### [00:27:27] Wes Kao

**English:**
Yeah. Yeah, I like that.

**中文翻译:**
是的，我喜欢那个。

---

### [00:27:28] Lenny Rachitsky

**English:**
Okay. Back to our agenda. There's another framework/tactic that I've heard you recommend. It's called signposting. What is signposting?

**中文翻译:**
好，回到我们的议程。我听过你推荐的另一个框架/技巧，叫“路标引导”（signposting）。什么是路标引导？

---

### [00:27:38] Wes Kao

**English:**
Signposting is using certain words, phrases, formatting, and an overall structure in your writing that helps guide your reader and signals what is coming in the rest of the post. So, this is especially helpful if you have a long memo. It adds structure to where are we going and what certain sections of paragraphs are about. So some of my favorite signposting words are, "for example," shows that you're about to show an example because shows that you're about to share your logic and rationale behind something. "As a next step," is a great one. People's eyes automatically zoom to, "as a next step." Even "First, second, third," kicking off a paragraph with that, you're not needing to rely on rich text formatting with bolding, italics, underlines and all that craziness. If you kick off sentences with signposting words, you can often signal, "Here's what I'm about to talk about in this paragraph."

**中文翻译:**
路标引导是指在写作中使用特定的词汇、短语、格式和整体结构，来引导读者并预示文章接下来的内容。如果你有一份很长的备忘录，这尤其有用。它为“我们要去向何方”以及“段落的特定部分是关于什么的”增加了结构感。我最喜欢的一些路标词包括：“例如”（for example），表示你要举例了；“因为”（because），表示你要分享某事背后的逻辑和理由。“作为下一步”（as a next step）也是个很棒的词，人们的目光会自动聚焦到这个词上。甚至在段落开头使用“第一、第二、第三”，你就不需要依赖加粗、斜体、下划线等各种复杂的富文本格式了。如果你用路标词开启句子，你就能发出信号：“这就是我在这段话中要谈论的内容。”

---

### [00:28:41] Lenny Rachitsky

**English:**
These are power words for clarity. There's this whole concept of power words like, "free." "A gift." For copywriting and these are basically power words for helping your brain see the structure and get to the thing you want to pay attention to. So I'll read back the words you just used. "For example," " because," "as a next step," and then, "first, second, third."

**中文翻译:**
这些是提升清晰度的“能量词”（power words）。文案写作中有一整套关于能量词的概念，比如“免费”、“礼物”。而这些词基本上是帮助大脑看清结构并引导注意力到重点上的能量词。我重复一下你刚才用的词：“例如”、“因为”、“作为下一步”，以及“第一、第二、第三”。

---

### [00:29:05] Wes Kao

**English:**
Yeah. Yeah. You can use signposting in writing and verbally too. So if you're doing a product demo, you might say something like, "The most important part to pay attention to is, blank." Or, "The part that we were most surprised by is, blank." Or, "The part that customers are," et cetera. Right? So it's, you're signaling that whatever comes after this thing is something that you may want to pay attention to. So it's a great way not only to add structure, but to also grab people's attention back if it has strayed some time as they were either listening to you or reading.

**中文翻译:**
是的。你可以在书面和口头表达中都使用路标引导。比如你在做产品演示时，可以说：“最需要注意的部分是……”或者“最让我们感到惊讶的部分是……”或者“客户最关心的部分是……”等等。对吧？你是在发出信号，告诉对方接下来的内容值得关注。这不仅是增加结构的好方法，也是在对方听讲或阅读走神时重新抓回注意力的好方法。

---

### [00:29:42] Lenny Rachitsky

**English:**
Along those lines, I find I find formatting really helpful here, just bold and bullets. I know you have a pet peeve with too much formatting. How much is too much formatting?

**中文翻译:**
顺着这个话题，我发现格式化非常有帮助，比如加粗和项目符号。我知道你很反感过多的格式化。那多少算过多？

---

### [00:29:51] Wes Kao

**English:**
I really hate excessive formatting. So, I've seen memos where 30% of the note was bolded. And that just negates the entire point of bolding because if everything is bolded then nothing is being highlighted, right? So I think using formatting in general more sparingly than you think you have to is probably a good rule of thumb. I also dislike when people overuse bullets and sentence fragments, phrases in bullets when they should use complete sentences that actually show the connected tissue between ideas, that show the logical flow of what it is that you're saying.

**中文翻译:**
我真的很讨厌过度的格式化。我见过一些备忘录，30% 的内容都加粗了。这完全抵消了加粗的意义，因为如果所有东西都加粗，那就等于没有重点，对吧？所以我认为，一个好的经验法则是：使用格式要比你认为需要的更克制。我也反感人们过度使用项目符号和句子碎片。当他们应该使用完整的句子来展示观点之间的联系（connected tissue）和逻辑流时，他们却在项目符号里放一些短语。

---

### [00:30:33] Wes Kao (Continued)

**English:**
And it feels faster and more concise to put bullets and fragments, but a lot of times your reader on the other end of that is needing to decipher and interpret and guess what you actually meant. So it net, net takes longer. And I also think that it can be a little bit of a crutch, it can be a little bit lazy because you are telling yourself that you're being concise when really, if you had to turn your sentence fragment into a full sentence, a lot of times it actually is harder than you think because you realize that you actually didn't really know exactly what you meant. So as you're trying to turn it into a full sentence, you're actually needing to use brainpower.

**中文翻译:**
使用项目符号和碎片化表达看起来更快、更简洁，但很多时候，另一端的读者需要去破译、解释和猜测你到底是什么意思。所以最终耗时反而更长。而且我认为这可能是一种依赖，甚至有点偷懒，因为你告诉自己这叫简洁，但实际上，如果你必须把句子碎片变成完整的句子，很多时候你会发现这比想象中要难，因为你意识到自己其实并不完全清楚想表达什么。当你试图把它变成完整的句子时，你实际上需要动脑筋。

---

### [00:31:15] Wes Kao (Continued)

**English:**
So that's I think a great litmus test of, "Was that idea fully thought out?" Because if it was, you should be able to really quickly turn it into a complete sentence. And many times, you actually aren't. So I see people like basically think, "Oh, I want to make this easier to read, more skimmable. I'm just going to throw a bunch of formatting and bullets and turn everything into bullets." And it's not quite that easy of a solution.

**中文翻译:**
所以我认为这是一个很好的试金石：“这个想法考虑周全了吗？”因为如果考虑周全了，你应该能很快把它变成一个完整的句子。而很多时候，你其实做不到。所以我看到人们基本上在想：“噢，我想让这个更容易读，更适合扫读。我就随便加点格式和项目符号，把所有东西都变成项目符号。”但这并不是一个那么简单的解决方案。

---

### [00:31:41] Lenny Rachitsky

**English:**
This is very much along the lines of the whole Amazon six-page memo where Jeff Bezos just realized, "If you can't write it out as a long memo and explain yourself in prose, you don't actually know what you're saying." And it's a really good filter for helping people actually crystallize and know themselves, "Okay, I see. I don't actually know what I'm doing here." And I love this is a microcosm of that. Can you just make a bullet point a real sentence versus a fragment of a sentence?

**中文翻译:**
这非常符合亚马逊著名的“六页纸备忘录”的精神。杰夫·贝佐斯意识到：“如果你不能写出一份长篇备忘录并用散文体解释清楚，你其实并不知道自己在说什么。”这是一个非常好的过滤器，能帮助人们理清思路并自省：“好吧，我明白了，我其实还没想清楚这件事。”我喜欢这个微观的例子：你能不能把一个项目符号变成一个真正的句子，而不是一个句子碎片？

---

### [00:32:06] Lenny Rachitsky (Continued)

**English:**
I'm thinking about as a listener being like, "Okay, how do I actually get better at this?" So maybe let's take a tangent. I know that you teach a whole course, you do all this stuff hands-on with people to help them actually build these skills. For someone that hasn't taken the course or isn't taking it, what's a good way to start practicing these skills and know if what you're writing is getting better, is good. Is it find a mentor, find someone that you think is a great writer and have them review stuff? Any tips there?

**中文翻译:**
我在想，作为一个听众，可能会问：“好，我到底该怎么提高呢？”也许我们可以岔开一下话题。我知道你教一整门课，手把手地教大家建立这些技能。对于那些没上过或没打算上这门课的人，有什么好的方法可以开始练习这些技能，并知道自己的写作是否在变好、是否足够优秀？是找个导师，找个你认为写作很棒的人来审阅你的东西吗？有什么建议吗？

---

### [00:32:34] Wes Kao

**English:**
Yeah. So I have a pretty first principles driven approach for this, which is to think about how long does it take me right now to get to the reaction I'm looking for from my recipient? If it takes a bunch of back and forth and a bunch of friction, then that's my baseline. And once you start practicing some of these communication skills, how does that speed up? If you would have had seven different touch points of back and forth, does that shrink to two to three?

**中文翻译:**
是的。我对此有一个非常基于“第一性原理”（first principles）的方法，那就是思考：现在我需要多长时间才能从接收者那里得到我想要的反应？如果需要大量的反复沟通和摩擦，那就是我的基准线。一旦你开始练习这些沟通技巧，这个过程是如何加速的？如果以前需要七次反复沟通，现在是否缩减到了两三次？

---

### [00:33:08] Wes Kao (Continued)

**English:**
Not every point of friction is going to be avoidable, but a lot of it is if you get better at communicating. So I like watching for the reaction and how quickly and how enthusiastically I'm able to get that reaction. And for the things that are working, do more of that. For things that are not working, adjust your execution because it might not be that the tactic doesn't work, it might be your execution of it wasn't great. And keep trying, basically.

**中文翻译:**
并不是所有的沟通摩擦都是可以避免的，但如果你能更好地沟通，很多摩擦是可以消除的。所以我喜欢观察对方的反应，以及我能多快、多热情地得到那个反应。对于有效的方法，就多做；对于无效的方法，调整你的执行方式，因为可能不是策略本身没用，而是你的执行不到位。基本上就是要不断尝试。

---

### [00:33:35] Lenny Rachitsky

**English:**
So the advice here is just see how well you're writing/meeting/suggestion goes, how well it does. And if it's not like there's the ideal immediately, "Yes, let's do it." And then there's the, "I don't really understand." There's the spectrum of response. And what I'm hearing is just pay attention to if the speed to getting what you want is increasing in general.

**中文翻译:**
所以这里的建议是：观察你的写作、会议或建议的效果如何。反应是有光谱的，理想情况是立刻得到“好，就这么办”，但也可能是“我不太明白”。我听到的是，要关注你获得想要结果的速度是否在整体提升。

---

### [00:33:59] Wes Kao

**English:**
Yeah, yeah. I don't think that there's any single shortcut on how to get better besides that. I do think that being fascinated by a topic and being excited about it makes it more likely that you're going to find it fun to try all these different things and try different ways to get through to people. So, I would approach it with a hypothesis-driven experimental mindset and almost like a game. Like, "When I do this, how does that other person react? If I frame it this way, do I get a different reaction? When I try this, am I able to cut through the noise more?"

**中文翻译:**
是的。除此之外，我不认为有任何单一的捷径。我确实认为，对一个话题着迷并感到兴奋，会让你更有可能觉得尝试各种方法、尝试不同方式与人沟通是件有趣的事。所以，我会以一种假设驱动的实验心态来对待它，几乎把它当作一个游戏。比如：“当我这样做时，对方会有什么反应？如果我这样铺垫，反应会不同吗？当我尝试这个时，我能更好地穿透噪音吗？”

---

### [00:34:39] Wes Kao (Continued)

**English:**
Yeah. So I really think it's about practicing. And I will say that the way not to do it is to try to incorporate 30 different tactics at the same time and then beat yourself up when you don't remember to do them. It's really easy when you are learning a new field or function to get overwhelmed when you're learning a new skill. And the way to build a habit is usually not changing so many different things at once. It's picking one thing that you want to try and keeping that top of mind, trying it in a bunch of different settings in different ways. And getting it better at that thing before moving on to the next thing.

**中文翻译:**
是的。所以我真的认为关键在于练习。我要说的是，错误的做法是试图同时运用 30 种不同的技巧，然后当你记不住怎么做时又责怪自己。当你学习一个新领域或新功能、掌握一项新技能时，很容易感到不知所措。建立习惯的方法通常不是一次改变太多事情，而是挑选一件你想尝试的事并时刻记在心里，在不同的场景下以不同的方式尝试它。在掌握这件事之后，再转向下一件事。

---

### [00:35:19] Wes Kao (Continued)

**English:**
So that's like a really common thing I see in my course is people feeling overwhelmed. And I always remind folks that, "You are building a new habit here. And be patient with yourself, take it step by step."

**中文翻译:**
这是我在课程中经常看到的现象：人们感到压力很大。我总是提醒大家：“你正在建立一个新习惯。对自己要有耐心，一步一步来。”

---

### [00:35:31] Lenny Rachitsky

**English:**
There's a lot of stuff we're talking about here that a lot of people might be like, "This is so minor. What? I just bullet point sentences, be a little... Tell them the why at the beginning." And I just want to share in my experience the biggest jump I made in my career was actually getting better at these very specific skills. I had this manager, Vlad, who's been on the podcast and I talk about him regularly, who was such a stickler about communicating well and being very clear and concise and thinking and just spending more time on documents and emails, on strategy docs. Just like, "No, this isn't ready. Spend more time, here's something that's not clear." And just doing that was such an accelerant for me.

**中文翻译:**
我们在这里谈论的很多东西，很多人可能会觉得：“这太微不足道了。什么？我只是把句子变成项目符号，稍微……在开头告诉他们原因。”但我只想分享我的经验：我职业生涯中最大的飞跃，实际上是来自于这些非常具体的技能的提升。我曾有一位经理叫 Vlad（他也上过这个播客，我经常提到他），他非常执着于良好的沟通，要求非常清晰、简洁、有深度，并要求在文档、邮件和战略文件上投入更多时间。他会说：“不，这还没准备好。再多花点时间，这里说得不清楚。”仅仅是这样做，就成了我职业生涯的助推器。

---

### [00:36:12] Lenny Rachitsky (Continued)

**English:**
And it's all these little things. That's what's interesting about it. It's like everything seems really minor but it all adds up to a lot of impact because to your point, people see it, "Okay, cool, I get it, let's go." Versus like, "I don't like this idea." And then it's like it all falls apart. So I guess any reactions to that?

**中文翻译:**
这就是有趣的地方：所有这些小事加在一起，会产生巨大的影响。因为正如你所说，人们看到它会想：“好，酷，我懂了，开始吧。”而不是：“我不喜欢这个主意。”然后一切就分崩离析了。你对此有什么反应？

---

### [00:36:29] Wes Kao

**English:**
Yeah. All these little things compound and make a big difference. I often hear people think, "Well, this individual instance, this individual email, the Slack message is not worth spending a couple more minutes on. It's just an email or it's just a Slack message." The problem with that line of thinking is that no one instance of something is ever going to feel important enough to spend a little bit more time on that. And then, but when you zoom out, that's like, "Well that's all your work then. This is literally everything you've touched. This is all your work output then." because any piece of that process you thought wasn't worth spending time on and now this is just the quality of your work and it's not as good as it could be.

**中文翻译:**
是的。所有这些小事都会产生复利效应，并带来巨大的差异。我经常听到人们想：“哎呀，就这一次，这一封邮件，这条 Slack 消息，不值得多花几分钟。它只是一封邮件或一条消息而已。”这种思维方式的问题在于，没有任何一个单一的案例会让你觉得重要到值得多花时间。但当你放大来看，你会发现：“好吧，那就是你全部的工作了。这是你接触过的每一件事。这就是你所有的工作产出。”因为你认为流程中的任何一部分都不值得花时间，结果这就是你工作的整体质量，而它本可以更好。

---

### [00:37:15] Wes Kao (Continued)

**English:**
So yes, these might seem minor but A, it compounds. And also B, all the "big things," everyone else is already doing. So, there's not a lot of alpha in that. Whereas if you are paying attention to skills that people think are boring or too basic and realizing that's a lever that you can pull, that someone else thought, "Oh, we're hitting diminishing returns on that. I'm not going to spend more time on that." But you realize that there's actually more juice left to squeeze there and you decide to squeeze that juice. Well, now, you have extra juice that the other person doesn't have.

**中文翻译:**
所以，是的，这些看起来可能很微小，但首先，它会产生复利。其次，所有“大事”别人也都在做，所以那里没有太多的“超额收益”（alpha）。而如果你关注那些人们认为无聊或太基础的技能，并意识到那是一个你可以拉动的杠杆——别人可能觉得“那件事的边际收益在递减，我不打算再花时间了”，但你意识到那里其实还有更多的“果汁”可以榨取，并且你决定去榨取它。那么，现在你就拥有了别人没有的额外“果汁”。

---

### [00:38:19] Wes Kao (Continued)

**English:**
I'm not saying that everything has to work for you but for you to claim, "This thing just doesn't work," feels a little bit intellectually dishonest. It's more likely that your skill level, your creativity, your execution ability was not good enough. And that's fine. Let's admit that to ourselves because if we admit that, then we can do the hard work of getting better at those things.

**中文翻译:**
我不是说每件事都必须对你有效，但如果你断言“这东西就是没用”，感觉有点不够诚实。更有可能的是你的技能水平、创造力或执行能力还不够好。这没关系。让我们对自己诚实，因为如果我们承认这一点，我们就能努力在这些方面做得更好。

---

### [00:38:42] Lenny Rachitsky

**English:**
It feels like if you really boil this down, all the advice comes down to just spend a little more time on all these things you're putting out.

**中文翻译:**
感觉如果真的归纳起来，所有的建议最终都归结为：在你产出的所有这些东西上多花一点点时间。

---

### [00:38:51] Wes Kao

**English:**
I like thinking about it as a little bit more upfront investment. And it is an investment. It's not just time. It's an investment because yes, it takes a little bit longer to make a Slack message a little bit better, but net, net if you save a bunch of questions and back and forth and people asking you things that you don't think they should be asking, then by investing a little bit of upfront effort, you've prevented all that from happening. So yeah, it is a little bit more time in the moment but reaps a lot of benefits down the line.

**中文翻译:**
我喜欢把它看作是一点点“前期投资”。这确实是一项投资，而不仅仅是时间。因为它是一项投资，虽然把 Slack 消息写得更好一点确实需要更长的时间，但从长远来看，如果你能省去一堆问题、反复沟通以及人们问你一些本不该问的事，那么通过投入一点点前期努力，你就防止了所有这些麻烦的发生。所以，是的，当下多花了一点时间，但长远来看收益颇丰。

---

### [00:39:25] Lenny Rachitsky (Sponsorship)

**English:**
Today's episode is brought to you by Coda. I personally use Coda every single day to manage my podcast and also to manage my community. It's where I put the questions that I plan to ask every guest that's coming on the podcast. It's where I put my community resources, it's how I manage my workflows. Here's how Coda can help you. Imagine starting a project at work and your vision is clear. You know exactly who's doing what and where to find the data that you need to do your part. In fact, you don't have to waste time searching for anything because everything your team needs from project trackers and OKRs to documents and spreadsheets lives in one tab all in Coda.

**中文翻译:**
今天的节目由 Coda 赞助。我个人每天都使用 Coda 来管理我的播客和社区。我会把计划问每位嘉宾的问题放在那里，也会把社区资源放在那里，它是我管理工作流的方式。以下是 Coda 能如何帮助你：想象一下在公司启动一个项目，你的愿景很清晰。你确切地知道谁在做什么，以及在哪里可以找到你所需的数据。事实上，你不需要浪费时间寻找任何东西，因为团队需要的一切——从项目跟踪器和 OKR 到文档和电子表格——都存在于 Coda 的一个标签页中。

---

### [00:40:42] Lenny Rachitsky

**English:**
You mentioned Slack. I have a great quote also about you that I didn't read that I'm just going to read right now from someone that worked with you. She said she searched the Slack channel at the company you worked at for old posts from Wes for inspiration for what to ask you. And she said you had zero half-baked thoughts, 100% complete sentences, perfect punctuation, clear takeaways at the top of every message. It's the kind of thing you don't notice in isolation, but once you see everyone else's messages in a remote-first company, it's a stark contrast.

**中文翻译:**
你提到了 Slack。我这里还有一段关于你的精彩评价，刚才没读，现在读一下，是来自一位曾与你共事的人。她说她曾在你工作过的公司的 Slack 频道里搜索 Wes 以前的帖子，想找找灵感看该问你什么。她说你没有任何“半成品”的想法，100% 的完整句子，完美的标点符号，每条消息顶部都有清晰的要点（takeaways）。这种事单独看可能不会注意到，但一旦你在一家远程优先的公司看到其他人的消息，就会发现鲜明的对比。

---

### [00:41:14] Wes Kao

**English:**
Yeah, thank you. I will also say that as someone who tries to walk the talk, I feel like I get a pretty good response rate pretty quickly for the things that I ask for, for the recommendations I'm making. It's not instant, it's not 100%, but over time I've realized that improving my communication has led to people receiving my ideas better. Ideas that used to be locked in my head that I would get frustrated that no one else understood. People were now understanding and that feels really good. That's very, very exciting and it made me want to do it more and pay more attention to that. So that's going back to what I said earlier about watching for what's working. There's momentum is really encouraging.

**中文翻译:**
是的，谢谢。我还要说，作为一个努力言行一致的人，我发现对于我提出的要求或建议，我能很快得到相当不错的回应率。虽然不是瞬间完成，也不是 100%，但随着时间的推移，我意识到提升沟通能力让人们更好地接受了我的想法。以前那些锁在脑子里、因为没人理解而让我感到沮丧的想法，现在人们能理解了，这种感觉非常好。这非常令人兴奋，让我想要做得更多，并更加关注这一点。这又回到了我之前说的，观察什么样的方法有效。这种势头非常令人鼓舞。

---

### [00:42:01] Lenny Rachitsky

**English:**
And I totally feel that. If you start getting the things you want, that feels great. I'd be like, "Okay, cool. Let's do more of that." Yeah, and again, it's like very minor things. It's like a couple more minutes on the Slack message, a couple more minutes on email.

**中文翻译:**
我完全能理解。如果你开始得到你想要的东西，那种感觉太棒了。我会想：“好，酷，多来点。”是的，再次强调，这都是些非常微小的事情。比如在 Slack 消息上多花几分钟，在邮件上多花几分钟。

---

### [00:42:17] Lenny Rachitsky (Continued)

**English:**
Yeah, which everyone can do. There's no magic here, it's just spend a little more time and use some of these tactics that we're talking about. Speaking of that, let me talk about another tactic. Apparently you have some really good advice on finding the right level of confidence in what you're saying. There's always this question of, "I come to this leader. How confident should I be about, 'This is the answer,' versus, 'Here's a bunch of ideas'?" What do you think? What's your advice there?

**中文翻译:**
是的，这是每个人都能做到的。这里没有什么魔法，只是多花一点时间并运用我们讨论的这些技巧。说到这，让我聊聊另一个技巧。显然，关于如何在表达中找到合适的自信度，你有一些非常好的建议。总会有这样的疑问：“我去见领导，我该表现得多么自信？是说‘这就是答案’，还是说‘这里有一堆想法’？”你怎么看？你的建议是什么？

---

### [00:42:41] Wes Kao

**English:**
I find that people tend to naturally be on the spectrum a little bit too confident as a baseline or not confident enough. So people who are too confident might state hypotheses as if they are fact. So that really bothers me. That's another one of my pet peeves, where if you say, "This is X," or, "This will X," that is different than saying, "This could X," or, "This might X," or, "This will increase the likelihood of X."

**中文翻译:**
我发现人们天生倾向于处于两个极端：要么基准自信度过高，要么不够自信。自信过头的人可能会把假设当作事实来说。这真的很困扰我。这是我的另一个雷点：如果你说“这就是 X”或“这将会导致 X”，这与说“这可能是 X”、“这或许会 X”或“这将增加 X 的可能性”是完全不同的。

---

### [00:43:12] Wes Kao (Continued)

**English:**
So I'm a big proponent of speaking accurately. You can avoid a lot of problems if you speak accurately about your level of conviction and about the actual amount of evidence that you have for something. It's okay for something to be an initial hunch. Say, "It's an initial hunch." Don't act like this is something that you are super sure about. You've proven out that this is absolutely this way because the rest of your team is listening to you at face value. And y'all might spend real headcount and dollars pursuing something that you have advocated for in a way where you overreached with your level of confidence.

**中文翻译:**
所以我非常主张“准确表达”。如果你能准确地表达你的确信程度以及你拥有的实际证据量，你就能避免很多问题。如果只是初步的直觉，没关系，就说“这是初步的直觉”。不要表现得好像你超级确定、已经证明了绝对是这样，因为团队的其他成员会按字面意思听你的。你们可能会投入真实的人力和资金去追求某件事，而这仅仅是因为你在提议时过度表现了自信。

---

### [00:43:52] Wes Kao (Continued)

**English:**
So, that's for people who are overconfident. It's equally a problem if you're under-confident. So I have some clients who their CEO asked them to share some recommendations with another team because they've run something before and so they share all this amazing information and at the end they're like, "Oh, but you can ignore everything I just said. Obviously, make your own decision. Do what you think is best. And if you want to just ignore everything, that's totally cool too." And it's like you just didn't have to say that. You could say, "Make your own decision, take all this into account," but you don't have to diminish to that degree.

**中文翻译:**
这是针对过度自信的人。不自信同样是个问题。我有些客户，他们的 CEO 要求他们向另一个团队分享一些建议，因为他们以前做过类似的项目。于是他们分享了所有这些很棒的信息，但最后却说：“噢，不过你可以忽略我刚才说的一切。显然，你自己做决定，做你认为最好的。如果你想完全忽略这些，也没问题。”其实你完全没必要这么说。你可以说“请根据这些信息自行决定”，但你不需要贬低自己到那种程度。

---

### [00:44:31] Wes Kao (Continued)

**English:**
And so again, speaking accurately, if you have really strong reasons to recommend something to the cross-functional team, it's almost irresponsible to act like you are not really sure and it's just this random idea, "Hey, try it if you want to." We might lose a lot of money and time if we don't take this idea, right? So again, speaking accurately is so, so important.

**中文翻译:**
所以再次强调，要准确表达。如果你有非常充分的理由向跨职能团队推荐某件事，表现得好像你不太确定、只是个随机的想法（“嘿，想试就试吧”）几乎是不负责任的。如果我们不采纳这个想法，可能会损失大量的金钱和时间，对吧？所以，准确表达真的非常、非常重要。

---

### [00:44:56] Lenny Rachitsky

**English:**
Is a simple way to think about then the right balance is have a point of view, have a recommendation, present accurate facts, and be clear when you are not? "It's not actually 100% true, but here's a hunch I have, or here's a theory we have."

**中文翻译:**
那么，思考这种平衡的一个简单方法是不是：有观点，有建议，展示准确的事实，并在不确定时明确说明？比如：“这不一定是 100% 正确的，但我有一个直觉，或者我们有一个理论。”

---

### [00:45:11] Wes Kao

**English:**
Yeah, I think sharing a point of view, sharing a recommendation, and then backing it up with evidence, with logic, with first principles, with examples, with data, if you have it. Not every situation you're going to have data for, especially if you're building something new. So this is where first principles comes in. Even explaining how you got to where you got to and why you think this is going to work, that all gives your team, your manager, something to push back on, to poke holes on or to align on and say, "Yeah, I agree here, but I disagree on this part."

**中文翻译:**
是的。我认为要分享观点、分享建议，然后用证据、逻辑、第一性原理、例子，如果有数据的话也加上数据来支持它。并不是每种情况都有数据，尤其是当你正在构建新事物时。所以这就是第一性原理发挥作用的地方。哪怕只是解释你是如何得出这个结论的，以及为什么你认为这会奏效，这都能给你的团队和经理提供一些可以反驳、找漏洞或达成一致的基础，让他们能说：“是的，我同意这里，但我不同意那部分。”

---

### [00:45:44] Wes Kao (Continued)

**English:**
So you can talk about ideas with a lot more specificity when you share your thought process. And you can frame it all kicking off saying, "My initial thinking is," or, "Based on what we know, my hunch is, blank." So speaking accurately and then still bringing up those facts so that we can all make as informed of a decision as we can make given what we know.

**中文翻译:**
所以当你分享思考过程时，你可以更具体地讨论想法。你可以这样开头：“我最初的想法是……”或者“基于我们已知的情况，我的直觉是……”。准确地表达，同时仍然提出那些事实，这样我们就能在已知信息的基础上，做出尽可能明智的决定。

---

### [00:46:07] Lenny Rachitsky

**English:**
Advice I got that really helped here for me was to try not to be biased with how you frame everything. You have your suggestion for how to do something. It's easy to just bias all of the data to point in that direction. And if people notice that, they're like, "Oh, okay. Well, I can't really trust this because I see you're just like, you clearly have an agenda." So it's a little bit like having an agenda and a POV, but be clear about what is actually true. Be accurate.

**中文翻译:**
我得到过一个非常有帮助的建议：尽量不要在铺垫（framing）时带有偏见。你对如何做某事有自己的建议，很容易就会让所有数据都指向那个方向。如果人们注意到这一点，他们会想：“噢，好吧，我不能完全信任这个，因为我看得出你显然有自己的目的（agenda）。”所以，这有点像既要有目的和观点，又要对事实保持清晰。要准确。

---

### [00:46:36] Wes Kao

**English:**
Yeah. I think anytime people have to discount what you're saying because you are biased in this way is not great.

**中文翻译:**
是的。我认为任何时候如果人们因为你的偏见而不得不对你的话打折扣，那都不是什么好事。

---

### [00:46:49] Wes Kao (Continued)

**English:**
Yeah, so in my course I talk about not being a single-minded martyr. So single-minded martyr is someone who very much has an agenda, who wants the recommendation to go through and is presenting a bunch of evidence, supporting that direction. And then gets really frustrated when other people are not seeing it or are skeptical. And so one of my clients was a single-minded martyr in a recommendation she was making. So she was on the growth acquisition side of her company. And was having trouble with cross-functional team members lending headcount to her project. And so everyone would say like, " Oh, yes, we believe in this, this is important," but wouldn't want to actually give her half of their engineer for two weeks.

**中文翻译:**
是的，在我的课程中，我谈到了不要做一个“死脑筋的殉道者”（single-minded martyr）。死脑筋的殉道者是指那些非常有目的性的人，他们一心想让建议通过，并展示一堆支持该方向的证据。当别人看不出其价值或表示怀疑时，他们会感到非常沮丧。我的一个客户在提出建议时就表现得像个死脑筋的殉道者。她在公司的增长获客部门工作，在争取跨职能团队成员为她的项目提供人力支持时遇到了困难。每个人都会说：“噢，是的，我们相信这个，这很重要。”但没人愿意真的把他们的工程师借给她半个，用上两周。

---

### [00:47:36] Wes Kao (Continued)

**English:**
And we were talking about it and as we were talking, she revealed that the CEO had at the beginning of the year said that the company-wide goal is retention that year. That their biggest challenges and areas of opportunity were in retention, not necessarily in growth. And once she zoomed out and realized this, she was able to put her recommendation in context. And realized that it's not just I'm the only one who cares about this company. Everyone is a hypocrite. They say they believe this, but don't actually want to work on it. Before that was kind of her narrative, but once she zoomed out and realized she was being a single [inaudible 00:48:16], she could better fit her proposal in the context of what else was happening in the organization.

**中文翻译:**
我们聊这件事时，她透露 CEO 在年初曾说过，那一年的全公司目标是“留存”（retention）。他们最大的挑战和机会点在于留存，而不一定是增长。一旦她放大视角并意识到这一点，她就能把她的建议放在大背景下考虑。她意识到，并不是“只有我一个人关心这家公司，其他人都是伪君子，嘴上说相信却不愿出力”。在那之前，那是她的心理叙事。但一旦她跳出来，意识到自己太死脑筋，她就能更好地将提案融入到组织中正在发生的其他事情中。

---

### [00:48:42] Wes Kao (Continued)

**English:**
I think actually this is a really big difference between more junior people versus more senior people. More junior people are like, "I need to win. I need to get a yes for this proposal and I'm going to keep advocating for it until I get a yes." Whereas really sometimes the best decision for the company is not right now. This doesn't actually fit our priorities right now, right? Or maybe yes, but let's right size the level of investment. So it might look like half whatever the size of what that recommendation actually was, and having the maturity to realize that, to put your idea into context is huge. That took me a really long time to learn and I think that goes under the umbrella of always do what's best for the company, not necessarily what's best for me, my career, my team, my wins. If you prioritize what's best for the company, that helps you have a more right-sized way of still advocating for your ideas, but doing it with a bit more equanimity.

**中文翻译:**
我认为这实际上是资历较浅的人与资深人士之间的一个巨大区别。资历浅的人会想：“我必须赢。我必须让这个提案通过，我会一直游说到通过为止。”而实际上，有时对公司最好的决定是“现在不做”。这并不符合我们现在的优先级，对吧？或者也许可以做，但让我们调整投资规模。比如把建议的规模减半。拥有这种成熟度去意识到这一点，并将你的想法置于大背景中，是非常重要的。我花了很长时间才学会这一点，我认为这属于“始终做对公司最好的事”这一范畴，而不一定是做对我、我的职业生涯、我的团队或我的战绩最好的事。如果你优先考虑对公司最好的事，这能帮助你以更合适的方式继续倡导你的想法，但心态会更加平和。

---

### [00:49:26] Lenny Rachitsky

**English:**
And also just connecting to what the company is. Just this idea of if the thing you're pitching is not aligned with what is important to the company right now, it's unlikely to be prioritized. It makes sense. This is why leaders choose, here's what matters most. We got to do the things that are going to help us drive this thing right now, like retention or revenue. And so that's just, I think, a sub tactic there is just whenever you're pitching something, connect that to the goal of the person you're pitching to so that they're like, "Oh, I see how this is going to help me. That's great. Let's do it. Great advice."

**中文翻译:**
还有就是与公司的现状挂钩。如果你推销的东西与公司目前的重点不一致，它就不太可能被优先考虑。这很合理。这就是为什么领导者会选择“什么最重要”。我们必须做那些现在能推动核心指标的事情，比如留存或收入。所以，我认为这里的一个子技巧是：每当你推销某件事时，把它与你推销对象的目标联系起来，这样他们就会想：“噢，我明白这能怎么帮到我了。太棒了，开始吧。”非常棒的建议。

---

### [00:50:01] Lenny Rachitsky (Continued)

**English:**
And I think this is something a lot of people run into. It's just, "Why aren't they listening to me? Why don't they want... That's such a good idea. They hate me." It's something, "Oh, I bet they hate me. They don't trust me." When it's just like, okay, this isn't a priority right now. Let's come back to it another time. Okay. I'm going to get to a couple more tactics and then I'm going to shift directions to talk about managers and being manager. You have an awesome framework called MOO. What is MOO? What does it stand for and what is it all about?

**中文翻译:**
我想这是很多人都会遇到的问题。他们会想：“为什么他们不听我的？为什么他们不想要……这主意多好啊。他们肯定讨厌我。”或者“我敢打赌他们讨厌我，他们不信任我。”而实际上，情况可能只是：好吧，这现在不是优先级。我们换个时间再谈。好，我再聊几个技巧，然后我会转向讨论经理以及如何当经理。你有一个很棒的框架叫 MOO。MOO 是什么？它代表什么，核心内容是什么？

---

### [00:50:26] Wes Kao

**English:**
MOO stands for Most Obvious Objection. M-O-O. And the thought there is that a lot of times we're surprised by the questions that we get, especially in meetings where we feel blindsided, that was unexpected, and then we're on our back foot. When really, if you thought for even two minutes about what are obvious objections that I'm likely to get when I share this, you often immediately come up with what some of those things are. So are you going to be able to anticipate every single objection? No. But can you anticipate the obvious ones? Absolutely. And so this is where knowing your own argument in and out, including counterarguments becomes so important. So knowing your counterarguments as well as you know the arguments for doing the thing. When you do that, when you have prepared in that way, you're less likely to feel caught off guard.

**中文翻译:**
MOO 代表“最显而易见的异议”（Most Obvious Objection）。核心思想是，很多时候我们会被收到的问题吓一跳，尤其是在会议中，感觉被打了个措手不及，那是意料之外的，然后我们就陷入了被动。但实际上，如果你哪怕只花两分钟思考一下“当我分享这个时，我可能会遇到的显而易见的异议是什么”，你通常能立刻想到其中的一些。你能预判每一个异议吗？不能。但你能预判那些显而易见的吗？绝对可以。所以，透彻了解你自己的论点（包括反论点）变得非常重要。了解反论点要像了解支持论点一样清楚。当你以这种方式准备时，你就没那么容易感到措手不及。

---

### [00:51:31] Lenny Rachitsky

**English:**
When you hear you talk about this, it's like, obviously I shouldn't do this, but very few people actually do this, actually spend a couple minutes, " Okay, here's what I'm going to pitch." Even a couple seconds, really. Really, even a couple seconds, your brain will think of something.

**中文翻译:**
听你谈论这个，感觉“显然我应该这么做”，但实际上很少有人真的会花几分钟想：“好，这就是我要提案的内容。”其实哪怕只是几秒钟，真的，哪怕几秒钟，你的大脑也会想到些什么。

---

### [00:51:43] Wes Kao

**English:**
I use MOO multiple times a day, every day, every single day. Literally whatever I'm about to say I think how might someone disagree with this or what might an objection be? So whatever it is I'm writing, saying, it's a really good mental filter because it encourages you to think a couple steps ahead in kind of a structured way, right? If I'm about to say this, the person may then say this to me. Well, if I take that into account, I can volunteer that information upfront or I can frame it in a way where they're less likely to think that that's an issue.

**中文翻译:**
我每天、每时每刻都会多次使用 MOO。字面上，无论我要说什么，我都会想：别人可能会怎么反对？或者异议可能是什么？所以无论我在写什么、说什么，这都是一个非常好的思维过滤器，因为它鼓励你以一种结构化的方式提前思考几步。如果我要说这个，对方可能会对我提出那个。那么，如果我考虑到这一点，我可以提前主动提供信息，或者以一种让他们不太可能认为那是问题的方式来进行铺垫。

---

### [00:52:19] Wes Kao (Continued)

**English:**
And so it's muscle memory for me at this point, and this might be something we include at the end is something to start with. But putting MOO on a post-it, Most Obvious Objection, what is someone likely to object about? And then just keeping that top of mind. It's a great way to train yourself to empathize with your audience and with your recipient. We all say that and we all know we should do it, but for me this is a really tactical concrete way to do it.

**中文翻译:**
所以对我来说，这已经成了肌肉记忆。这可能是我们最后可以建议大家开始尝试的一件事。把 MOO 写在便利贴上——“最显而易见的异议”，别人可能会反对什么？然后时刻记在心里。这是训练自己与听众和接收者产生共情的好方法。我们都说要共情，也知道该这么做，但对我来说，这是一个非常具有战术性、具体的方法。

---

### [00:52:50] Lenny Rachitsky

**English:**
I think what's great about a lot of the tactics you're sharing is not only is it going to help you communicate it better, but it helps you actually think and crystallize it better for yourself because you may realize, oh, that's a really good objection. Like, oh, the objection's probably going to be this. Will it drive enough impact for the business? Oh, that's a great point. Maybe I should not pitch this right now.

**中文翻译:**
我认为你分享的很多技巧最棒的地方在于，它不仅能帮你更好地沟通，还能帮你更好地思考和理清思路。因为你可能会意识到：“噢，那确实是个很好的异议。异议可能是：这能为业务带来足够的冲击力吗？噢，好点子，也许我现在不该提这个案。”

---

### [00:53:10] Wes Kao

**English:**
Yeah. It definitely helps shape your own thinking. I think communication and thinking are so much more interrelated than we think. I think people think there's a thinking as phase one and then communicating the thinking, and the reality is a lot more intertwined. And I loved your example there that thinking ahead to what might be the most obvious objection actually then prompts you to realize that maybe there was a gap in what you were planning to present and then you now have an opportunity to strengthen that pitch before you say it out loud.

**中文翻译:**
是的。它绝对有助于塑造你自己的思维。我认为沟通和思考之间的关联比我们想象的要紧密得多。人们通常认为第一阶段是思考，然后是沟通思考的结果，而现实中两者是交织在一起的。我很喜欢你刚才的例子：提前思考最显而易见的异议，实际上会促使你意识到你计划展示的内容中可能存在漏洞，这样你就有机会在说出口之前加强你的提案。

---

### [00:53:45] Lenny Rachitsky

**English:**
There's a quote I have highlighted on this podcast a number of times that I love that is exactly along these lines by Joan Didion. "I don't know what I think until I write it down." I know exactly that feeling. Okay. So there's a couple more things that people have shared that you are amazing at helping them get better at. One is just keeping your cool and staying calm during very high stakes, real-time conversations when things maybe aren't going your way or if you disagree with someone, any advice on that, it feels like you're really good at this.

**中文翻译:**
我在这个播客中多次强调过一句我非常喜欢的名言，是 Joan Didion 说的，正好符合这一点：“在写下来之前，我不知道自己在想什么。”我太理解那种感觉了。好，还有几件事是大家反馈说你非常擅长帮助他们提高的。其中之一就是在高风险、实时的对话中保持冷静，尤其是当事情进展不如意或者你与某人意见相左时。关于这一点你有什么建议吗？感觉你在这方面非常厉害。

---

### [00:54:17] Wes Kao

**English:**
I think one thing that tends to throw people off is putting a lot of pressure on themselves to get the exact right answer. So if they are asked a question and they don't know the answer, a lot of people will then kind of freak out. And I was taught early in my career that if you don't know the answer, you should say, "Let me look into it, I'll get back to you." So that's a fine approach. It's definitely better than making something up, right? So definitely don't make something up. But if you are more experienced and have some confidence in your subject matter area, just saying I'll get back to you, is sometimes a missed opportunity. You can ask for a bit more information to be able to continue the conversation in that moment.

**中文翻译:**
我认为有一件事往往会让人们自乱阵脚，那就是给自己施加了太大的压力，非要给出一个完全正确的答案。所以如果被问到一个不知道答案的问题，很多人就会抓狂。在我职业生涯早期，我被教导说如果不知道答案，应该说：“让我查一下，然后再回复你。”这是一个不错的做法，绝对比瞎编要好，对吧？千万不要瞎编。但如果你更有经验，并且对你的专业领域有一定信心，仅仅说“我会再回复你”有时会错失良机。你可以要求更多信息，以便在那个当下继续对话。

---

### [00:55:20] Wes Kao (Continued)

**English:**
Let's say that your exec says what percentage of users came from mobile last month and you don't have that number off the top of your head. So person A says, "Let me look into it and I'll get back to you." Person B might say, "I don't have that number off the top of my head, but in the last quarter the number has been 60 to 70% and it's grown in the past year, so mobile is now a bigger part of our business, et cetera. Are you wondering if we are investing in mobile appropriately or where's that commission coming from, basically? Right? And so being able to answer a similar question in the direction you think the person is asking about and then validating why they're asking that question allows you to still continue that conversation in the moment.

**中文翻译:**
假设你的高管问：“上个月有多少比例的用户来自移动端？”而你脑子里没有那个确切数字。A 可能会说：“让我查一下，然后再回复你。”B 可能会说：“我脑子里没有确切数字，但在上个季度，这个比例一直在 60% 到 70% 之间，而且过去一年一直在增长，所以移动端现在是我们业务中更大的一部分。您是想知道我们对移动端的投入是否合适，还是想了解这个数据的来源？”对吧？能够朝着你认为对方提问的方向回答一个类似的问题，然后确认他们提问的原因，这能让你在当下继续对话。

---

### [00:56:10] Wes Kao (Continued)

**English:**
I call it the question behind the question, sometimes you get a question, but underneath there's a deeper underlying concern. And many times people don't even know that it's there, right? Subconscious. So it's not nefarious, they're not withholding anything from you. But when you are explaining something and you're kind of getting multiple questions on the same thing, it's a good sign that there might be a deeper question behind the question and it's our responsibility to figure out what might that be. And so probing, asking for a bit more information, answering in that general direction and then validating these are all techniques you can use when you are in the moment without feeling like, oh, I must have every single thing prepared and the moment that I'm caught off guard, everything goes to shit.

**中文翻译:**
我称之为“问题背后的问题”。有时你收到一个问题，但其底层隐藏着更深层的担忧。很多时候人们甚至不知道它的存在，对吧？那是潜意识的。所以这并不是恶意的，他们不是在对你隐瞒什么。但当你解释某件事时，如果你反复收到关于同一件事的多个问题，这是一个信号，表明可能存在一个“问题背后的问题”，而我们的责任是弄清楚那是什么。所以，试探、询问更多信息、朝着大致方向回答并进行确认，这些都是你在当下可以使用的技巧，而不会让你觉得“噢，我必须准备好每一件事，一旦被打乱，一切就完蛋了”。

---

### [00:56:49] Lenny Rachitsky

**English:**
Another tactic along these lines that's very similar to what you're describing, but I'll share that I learned that was really helpful is just if you're not sure what to say, basically just reflecting back their question and just being like, let me just make sure I understand what you're looking for. You want to understand monthly retention for, and then maybe clarify. And that one gives you time to think about it as you're talking. Two, it helps the person recognize, "Oh, he hears me. Great. Okay, this is good. He's thinking about this." And then at the end of that you could be like, "Okay. I don't actually have that specific number. Let me think about it." Or, "I have the quarterly number. Okay. That's what I know." So there's an interim step almost that I'll add into your piece of advice of just reflect back their question, just better understand what they're looking for.

**中文翻译:**
顺着这个思路，还有一个与你描述的非常相似的技巧，我学到后觉得非常有帮助：如果你不确定该说什么，基本上就是把他们的问题反射回去，说：“让我确认一下我是否理解了您的需求。您是想了解月留存率……”然后进行澄清。第一，这给了你边说边思考的时间。第二，这能让对方意识到：“噢，他听进去了。太好了，他在思考这个问题。”最后你可以说：“好，我手头确实没有那个具体的数字，让我考虑一下。”或者“我有季度的数字，这是我目前了解的情况。”所以，在你建议的基础上，我增加了一个中间步骤：反射他们的问题，以便更好地理解他们的需求。

---

### [00:57:34] Lenny Rachitsky (Continued)

**English:**
Awesome. Okay, let's go back to what I said we do. Let's pick one tactic that you think people should try first, maybe one or two. So let me read the ones we've gone through and then see what you think would be a good first step. So one is starting with sales, before getting to logistics and giving people the why signposting using specific words to help people guide the doc and not get overwhelmed. Finding the right level of confidence, having a POV, that sort of thing. Getting better, being concise, MOO, not overusing formatting, something else you shared. And then this idea of when you don't know the answer, not saying I'll get back to you as the default, maybe giving them a different answer, maybe asking them more questions. Across those, which do you think someone should try to like, "Okay. Let me start here."

**中文翻译:**
太棒了。好，回到我之前说的。让我们选一个你认为大家应该首先尝试的技巧，或者一两个。让我读一下我们刚才过了一遍的：1. 先推销，后谈执行细节，并给出原因。2. 使用特定的路标词引导文档，避免让人感到不知所措。3. 找到合适的自信度，有自己的观点（POV）。4. 变得更简洁。5. MOO（最显而易见的异议）。6. 不要过度使用格式。7. 当不知道答案时，不要默认说“我会再回复你”，而是尝试给出相关答案或询问更多问题。在这些技巧中，你认为大家应该从哪一个开始尝试？

---

### [00:58:25] Wes Kao

**English:**
I would start with Most Obvious Objection and also framing your conversation up front. And that kind of relates to using signposting words if needed to help you frame that conversation.

**中文翻译:**
我会从 MOO（最显而易见的异议）开始，同时在开始时对对话进行铺垫（framing）。这在某种程度上也涉及到在需要时使用路标词来帮助你进行铺垫。

---

### [00:58:37] Lenny Rachitsky

**English:**
Sweet. That's such an easy one to remember. Just MOO. Okay. So stick a post it somewhere when you're about to share something in Slack and ask someone for something, present in a meeting, send a strategy, and just think about for a few seconds what might be the most obvious objection to what I'm trying to ask them to do. Great.

**中文翻译:**
太棒了。这太容易记住了，就是 MOO。好，在某处贴个便利贴，当你准备在 Slack 上分享东西、向某人提要求、在会议上演示或发送战略文档时，花几秒钟想一想：对于我要求他们做的事，最显而易见的异议可能是什么。太好了。

---

### [00:58:46] Lenny Rachitsky (Continued)

**English:**
Okay. So let's talk about management. And there's kind of two sides to it. Being a manager and being a person reporting to a manager, you have a bunch of really good advice here. One is there around managing up. One of my most popular posts in the early days was advice for managing up and just how important it is. What advice do you have for someone to get better at managing up? Why is that even so important? Why do you think people may be under appreciating how important it is to manage your manager, let's say.

**中文翻译:**
好，让我们聊聊管理。这有两个方面：当经理和当下属。你在这方面有很多非常好的建议。其中一个是关于“向上管理”（managing up）。我早期最受欢迎的文章之一就是关于向上管理的建议及其重要性。关于如何更好地向上管理，你有什么建议？为什么这如此重要？你认为为什么人们可能会低估管理你的经理的重要性？

---

### [00:59:18] Wes Kao

**English:**
One of the most common myths about managing up that I definitely felt early on in my career was that I would have to manage up if I were more junior, but eventually I would outgrow it, that I would get senior enough that I would no longer have to do it. And it was a rude awakening that no matter how senior I got, managing up, I not only had to manage up, it actually became more important. So I think managing up is one of those skills that if you invest in learning it, it serves you now and for the rest of your career.

**中文翻译:**
关于向上管理，最常见的误区之一（也是我职业生涯早期深有感触的）是：只有在资历浅的时候才需要向上管理，等我变得足够资深，我就不再需要做了。然而现实给了我沉重一击：无论我变得多么资深，我不仅仍然需要向上管理，而且它实际上变得更加重要了。所以我认为向上管理是那种一旦你投入精力去学习，就能在当下乃至整个职业生涯中让你受益匪浅的技能。

---

### [01:00:09] Wes Kao (Continued)

**English:**
And I realize that many senior people are actually the best at managing up. That's partially how they got to be so senior in the first place. But also, the more senior you get, the less likely that your manager is going to give you really well-defined tasks and problems on a silver platter and ask you to solve them. You are going to be dealing with more ambiguity and you're going to be dealing with sometimes a mandate like make this number go up or create this division, right? Where you need to manage up and make sure that your leader, your manager, is in the loop about what you are about to try and what you're about to do and make sure that they're aligned.

**中文翻译:**
我意识到，许多资深人士实际上是向上管理的高手。这在一定程度上也是他们能晋升到高位的原因。而且，你越资深，你的经理就越不可能把定义清晰的任务和问题“双手奉上”让你去解决。你将面临更多的模糊性，有时收到的指令只是“让这个数字涨上去”或“组建这个部门”。在这种情况下，你需要向上管理，确保你的领导、你的经理了解你打算尝试什么、打算做什么，并确保他们与你保持一致。

---

### [01:00:44] Lenny Rachitsky

**English:**
Just that even if you become even a VP, if you become a director and still something you want to invest in, any specific tactic or advice for how to manage up well.

**中文翻译:**
所以即使你成了副总裁或总监，这仍然是值得投入的事。关于如何做好向上管理，有没有具体的技巧或建议？

---

### [01:00:54] Wes Kao

**English:**
The biggest one is to share your point of view. So this some people are surprised by because they think I'm going to say do a weekly recap of the tasks that you worked on or what you contributed. And that is a good idea, if you want to do it, you can do it. But I think the more highly leveraged way to contribute and manage up is by being more vocal about sharing your point of view. When you just ask your manager, "Hey manager, what should we do?" You're putting a lot of cognitive load on your manager to need to think about the problem, think about potential solutions, craft the solution, and then tell you what to do.

**中文翻译:**
最重要的一点是分享你的观点。有些人对此感到惊讶，因为他们以为我会说“每周总结一下你完成的任务或贡献”。那确实是个好主意，如果你想做可以做。但我认为，更有杠杆作用的贡献和向上管理方式是更积极地分享你的观点。当你只是问经理：“嘿，经理，我们该怎么办？”你是在给经理施加巨大的认知负荷，让他们去思考问题、思考潜在方案、制定方案，然后告诉你该做什么。

---

### [01:01:54] Wes Kao (Continued)

**English:**
Whereas if you instead said, "Hey manager, here's what I think we should do. How does that sound? Where do you see gaps? Am I thinking in the right direction?" You give them something to build off of and that reduces the amount of mental lift that they have to put forth. And so sharing your point of view more readily, backing it up with evidence, that's a wonderful way of making your manager's life easier. And also showing that you are an active rigorous thinker who is thinking strategically about the business. You're not just waiting to be told what to do, you're not expecting them to figure things out and then tell you you are actively looking around the corner trying to solve problems, forming hypotheses in your mind, observing and noticing things.

**中文翻译:**
相反，如果你说：“嘿，经理，这是我认为我们该做的。您觉得怎么样？您觉得哪里有漏洞？我的思路对吗？”你给了他们一个可以作为基础的东西，这减少了他们需要付出的心力。因此，更主动地分享观点并辅以证据，是让经理的工作变得更轻松的绝佳方式。同时，这也能展示你是一个积极、严谨的思考者，在对业务进行战略性思考。你不仅仅是在等待指令，也不是指望他们解决问题后再告诉你，而是在主动观察、发现问题、形成假设并尝试解决问题。

---

### [01:03:04] Lenny Rachitsky

**English:**
I was going to say exactly that. I think not only is it something junior people can do, this is a really good way to get promoted and to take on more leadership opportunities. You coming to your manager with, "Here's something I think we should do. Here's a perspective I have. Here's an opportunity." If you were in charge, you're like, how awesome would it be for people to come to me with amazing ideas and have clear recommendations? That sounds great. Everyone wants that. So if you can do that, amazing. Who wouldn't want that? But then what's interesting is similar to how writing helps you crystallize your thinking, you coming in with a recommendation forces you to really think deeply about it because that's putting your reputation on the line. So there's a second order effect of it makes you actually spend more time on the thing and be clear about why you think this is a good idea and do more research. So a lot of wins here.

**中文翻译:**
我正想说这个。我认为这不仅是资历浅的人可以做的事，也是获得晋升和承担更多领导机会的绝佳途径。你带着“这是我认为我们该做的”、“这是我的看法”、“这是一个机会”去找经理。如果你是领导，你会想：如果有人带着绝妙的主意和清晰的建议来找我，那该多棒啊！听起来太好了，每个人都想要这样的下属。所以如果你能做到这一点，那就太棒了。谁不想要呢？有趣的是，就像写作能帮你理清思路一样，带着建议去找领导会迫使你深入思考，因为你是在拿自己的声誉做担保。所以这有一个二阶效应：它让你真正花更多时间在事情上，弄清楚为什么这是个好主意，并做更多研究。所以这是多赢。

---

### [01:03:53] Wes Kao

**English:**
There are a lot of situations where you might have the most visibility into a problem. You might have the most proximity into an issue. And so if you're not speaking up about it and sharing what you're observing, sharing what you're noticing, your manager doesn't necessarily have visibility into that. And so I've heard so many managers say that they want their junior people to speak up more because their junior people have often close contact with customers, with support tickets, with cleaning data, with a bunch of things where the manager would love to hear insights from that.

**中文翻译:**
在很多情况下，你可能对某个问题看得最清楚，或者离问题最近。如果你不开口分享你的观察和发现，你的经理不一定能看到。我听过很多经理说，他们希望初级员工能多发言，因为初级员工通常与客户、支持工单、数据清洗等工作接触最紧密，经理非常渴望听到来自这些方面的洞察。

---

### [01:04:32] Lenny Rachitsky

**English:**
If you're not having success with this, if you're hearing this and be like, but it never worked, my manager doesn't listen to me, listen to the rest of this podcast we just did, which is basically advice on how to effectively convince someone of a thing. It's like, tell them why this is a problem, be really concise about it, sign post words, all these things. That's exactly what this whole conversation's been about. Okay. Let's see. We have a couple more really cool tactics that people have suggested we talk about. One is how to give feedback well, how to do better, how to be more effective at giving feedback. What's your advice there?

**中文翻译:**
如果你在这方面没成功，如果你听了这些觉得“但这根本没用，我的经理不听我的”，那就听听我们刚才做的这期播客的其他部分，那基本上就是关于如何有效说服别人的建议。比如：告诉他们为什么这是个问题，保持简洁，使用路标词，等等。这正是我们整个对话的主题。好，让我们看看，还有几个大家建议讨论的非常酷的技巧。其中一个是关于如何给好反馈，如何做得更好，如何更有效地提供反馈。你有什么建议？

---

### [01:05:05] Wes Kao

**English:**
I have a framework called strategy, not self-expression. And so the idea here is that most of the time, by the time we are giving feedback to someone, we have been frustrated for a while. I used to be very conflict diverse, so I would wait and try to convince myself that I wasn't bothered by something until I really couldn't hold it in anymore. Then I would schedule a one-on-one with a coworker to tell them the feedback and it would inevitably turn into a venting session where I was in the name of sharing the impact of what they did would share all my frustrations and all the ways that they have basically harmed me and made my life difficult.

**中文翻译:**
我有一个框架叫“策略，而非自我表达”（strategy, not self-expression）。核心思想是：大多数时候，当我们向某人提供反馈时，我们已经沮丧了一段时间了。我以前非常回避冲突，所以我会一直等，试图说服自己我并没被某事困扰，直到我真的憋不住了。然后我会约同事进行 1 对 1 面谈来提供反馈，结果不可避免地变成了发泄大会。我打着“分享其行为影响”的旗号，分享了我所有的沮丧，以及他们如何伤害了我、让我的生活变得艰难。

---

### [01:05:59] Wes Kao (Continued)

**English:**
And this would be very counterproductive because the person would either feel like and feel really demoralized or they'd get really defensive and they'd want to argue with me about how what they did actually was not that bad or it was partially my fault too or whatever. And so I realized that a better way of giving feedback is thinking about motivating the person's behavior change. The goal is behavior change. So if that's the goal, trim everything else that you were about to say that does not actually contribute to that goal and only keep the part that will make the person want to change, help them understand the benefit to them as well as to the people around them. And so usually for me, that's trimming 90% of the initial stuff that I want to say and really keeping only that 10%. And that's made a really big difference. Whenever I am giving constructive feedback of any kind, I always keep that in mind. And when I don't do it, I almost always regret it.

**中文翻译:**
这会产生非常大的负面效果，因为对方要么感到非常沮丧、士气低落，要么会变得非常有防御性，想跟我争论他们做的事其实没那么糟，或者那也有一部分是我的错，等等。所以我意识到，给反馈更好的方式是思考如何激励对方改变行为。目标是行为改变。如果那是目标，那就删掉所有对实现该目标没有贡献的话，只保留那些能让对方想要改变、帮助他们理解这对他们自己以及周围的人有什么好处的部分。所以通常对我来说，这意味着删掉最初想说的 90% 的内容，只保留那 10%。这产生了巨大的差异。每当我提供任何形式的建设性反馈时，我都会牢记这一点。如果我不这样做，我几乎总是会后悔。

---

### [01:06:46] Lenny Rachitsky

**English:**
Someone close to me in my life is working on the skill, which is there's just, "I want people to know how they messed up. Justice. I need this to be fair." And what I always recommend is just think about what you want to get out of this conversation, what do you want from them? And then, okay, what's the best way to get that? Versus just making sure they hear you and making sure they understand how screwed up this was. And that's basically what you're saying is focus on the outcome you want to achieve, not something that's useful, something that will make you just feel better.

**中文翻译:**
我生活中有一个亲近的人正在练习这项技能，他总是想：“我要让人们知道他们搞砸了。这是正义，我需要公平。”而我总是建议：想想你想从这次对话中得到什么？你想要他们做什么？然后，好，得到那个结果最好的方式是什么？而不是仅仅确保他们听到了你的声音，确保他们理解了这有多糟糕。这基本上就是你说的：专注于你想要实现的结果，而不是那些仅仅让你感觉好受一点但没用的东西。

---

### [01:07:23] Wes Kao

**English:**
Yeah. I definitely think that having a space to vent and to share those frustrations is important. So you want to get that out before you go into the conversation with your counterpart. So whether it's talking to your therapist or your partner or friend, you want to basically get all that energy out because otherwise you bring it into the conversation and it doesn't take much to set you off. You might have a whole script, you're controlled, you're calm, and then you start talking and the other person raises an eyebrow and is acting a little incredulous at what you're saying, and that's all it takes for you to snap and be like, "You're surprised? You're incredulous? Why are you incredulous?" Right? And then you're off, right?

**中文翻译:**
是的。我绝对认为拥有一个发泄和分享沮丧的空间很重要。所以你想在与对方对话之前把这些情绪发泄出来。无论是找心理医生、伴侣还是朋友，你基本上要把那种负能量排空，否则你会把它带进对话中，而且一点点小事就能让你爆发。你可能准备好了剧本，表现得很克制、很冷静，但当你开始说话时，对方挑了挑眉，对你说的表现出一点怀疑，这就足以让你崩溃并反击：“你很惊讶？你很怀疑？你凭什么怀疑？”对吧？然后你就失控了。

---

### [01:08:23] Wes Kao (Continued)

**English:**
Yeah. Getting that energy out, I would say step one, so that you can go into the conversation clear, grounded, setting that emotional tone that is more positive and that allows you to stay focused on only the part that will get them to behave in the way you want them to behave.

**中文翻译:**
是的。排空那种负能量是第一步，这样你才能在对话中保持清醒、理智，设定一个更积极的情绪基调，让你能专注于那些能让对方按你期望的方式行事的内容。

---

### [01:08:42] Lenny Rachitsky

**English:**
Such good advice. And I think we come back to are you getting the outcomes you want? If you're not, this is another reason it might be the case is you just need them to hear your mind. I just need you to know. And I think a lesson here is that may not be the best path to getting what you want, but it may feel good. Maybe people are like, "Ah, but I really want them to know this."

**中文翻译:**
非常好的建议。我想我们又回到了：你得到想要的结果了吗？如果没有，这可能是另一个原因：你只是想让他们听到你的心声。“我只是需要让你知道。”我认为这里的教训是：那可能不是获得你想要结果的最佳路径，尽管它可能让你感觉很爽。也许人们会想：“啊，但我真的想让他们知道这个。”

---

### [01:09:19] Wes Kao

**English:**
There's that great Einstein quote about insanity being repeating things that you're doing expecting a different outcome. And I feel like that applies so much to the workplace and to communication. Most of us have certain patterns that we are used to and certain ways of responding, and if you believe that there is untapped upside that whatever you are at is kind of a local maximum and that there's better out there, then that's where switching things up could be useful and not just doing everything that you've been doing and getting the same result that you might be getting.

**中文翻译:**
爱因斯坦有一句名言：疯狂就是重复做同样的事却期待不同的结果。我觉得这非常适用于职场和沟通。我们大多数人都有习惯性的模式和回应方式，如果你相信还有未被挖掘的潜力，相信你现在的状态只是一个“局部最大值”（local maximum），外面还有更好的可能，那么尝试改变就是有用的，而不是一直重复老一套并得到同样的结果。

---

### [01:10:04] Lenny Rachitsky

**English:**
Two more things I want to talk about real quick. One is your advice on delegating, but also continuing to have high standards. This is something I spent a lot of time on because a lot of people don't delegate because they're afraid it's not going to be as great. I just want this to be really good. I don't trust that it's going to go as well. If I did it my way, it'd be great. So just advice on how to delegate effectively while maintaining high standards.

**中文翻译:**
还有两件事我想快点聊聊。一个是关于授权（delegating）同时保持高标准的建议。这是我花了很多时间思考的问题，因为很多人不愿授权，是因为担心结果不够好。“我只想把这件事做好。我不相信别人能做得同样好。如果按我的方式做，肯定很棒。”所以，关于如何在保持高标准的同时有效授权，你有什么建议？

---

### [01:10:08] Wes Kao

**English:**
Yeah. I have a framework called CEDAF. C-E-D-A-F. It's kind of like Cedar, but with an F at the end. I need acronyms for myself. All of these are really reminders for myself because I need a short way to remind myself. So CEDAF stands for the C is comprehension. Have I given this person that I'm delegating to everything that they need to understand what it is that I want them to do. That includes more simple things like logins to all the right software tools that they need to look up, whatever you need to look up. And understanding what the end result should look like, right? So that's all under C for comprehension.

**中文翻译:**
有的。我有一个框架叫 CEDAF。C-E-D-A-F。听起来有点像 Cedar（雪松），但结尾是 F。我需要首字母缩略词来提醒自己，这些都是我自己的备忘录。CEDAF 代表：C 是理解（Comprehension）。我是否给了被授权人所需的一切，让他们理解我想让他们做什么？这包括一些简单的事情，比如所需软件工具的登录账号，以及理解最终结果应该是什样的。这些都属于 C。

---

### [01:11:06] Wes Kao (Continued)

**English:**
E is excitement. Am I explaining this in a way that is making this as exciting as it could be? There are a lot of tasks that aren't inherently that exciting, but by explaining the why behind we're doing this or why it's important to the project we're working on, that makes people more likely to understand and be excited about how this fits into everything. So E is for excitement.

**中文翻译:**
E 是兴奋（Excitement）。我解释这件事的方式是否尽可能地让人感到兴奋？有很多任务本身并不那么令人兴奋，但通过解释我们为什么要这么做，或者为什么它对我们正在做的项目很重要，能让人们更容易理解并对它如何融入大局感到兴奋。所以 E 代表兴奋。

---

### [01:11:06] Wes Kao (Continued)

**English:**
D is for de-risk. Am I de-risking any obvious risks from delegating this? So usually when I ask clients this, they immediately think of something. They're like, "Oh yeah, I wouldn't want my direct report to spend a ton of time going in the wrong direction, filling out a hundred rows of the spreadsheet if actually it took longer than we expected." Okay, great. If that's a risk, then maybe you have them do 10 rows, see how long it takes, see if we need all the information that they're actually gathering, and then regroup, right? So what's an obvious risk? Another might be I can see this person misunderstanding and thinking I'm looking for this where I'm really looking for that. Okay, perfect. Just tell them, "When I explain this, you might think I mean this, but really I don't want that. I actually want this," right? So just vocalize it.

**中文翻译:**
D 是去风险（De-risk）。我是否降低了授权这件事带来的显而易见的风险？通常当我问客户这个问题时，他们会立刻想到一些事。他们会说：“噢，是的，我不希望我的下属花大量时间往错误的方向走，如果填 100 行表格比预期时间长得多的话。”好，太棒了。如果那是风险，那就让他们先填 10 行，看看花多长时间，看看我们是否真的需要他们收集的所有信息，然后再重新评估。这就是显而易见的风险。另一个风险可能是：我预见到这个人可能会产生误解，以为我想要 A，其实我想要 B。好，完美。直接告诉他们：“当我解释这个时，你可能会以为我的意思是 A，但其实我不要那个，我真正想要的是 B。”把它说出来。

---

### [01:12:00] Wes Kao (Continued)

**English:**
The A is for align. So am I giving the other person a chance to speak up and make sure we are actually aligned, that they're picking up what I'm putting down? Because you might be explaining a bunch of stuff, but how much are they actually absorbing? You won't ever know if you wrap up your little spiel and then say, "Okay, go off. Come back to me when you're done." So give people a chance to ask questions to see what parts are resonating, what parts they might be a little bit confused on. Usually, when I do this, it's amazing. Because my team member will say, "What did you mean by this part? How does this part fit in?" I'm like, "Oh my God, I totally forgot to mention this thing." Or, "Oh yeah, I didn't even really explain that well."

**中文翻译:**
A 是对齐（Align）。我是否给了对方发言的机会，以确保我们真的达成了一致，确保他们理解了我的意思？因为你可能解释了一大堆，但他们到底吸收了多少？如果你说完你的长篇大论后只是说“好，去吧，做完再来找我”，你永远不会知道。所以给人们提问的机会，看看哪些部分引起了共鸣，哪些部分让他们感到困惑。通常当我这样做时，效果惊人。因为我的团队成员会说：“你说的这部分是什么意思？这部分是怎么关联的？”我会想：“天哪，我完全忘了提那件事。”或者“噢，是的，我确实没解释清楚。”

---

### [01:13:24] Wes Kao (Continued)

**English:**
And then F is feedback. How can you have the shortest feedback loop possible? I am a huge fan of shorting the feedback loop as much as possible and then shortening it again. So even within that initial conversation where I'm delegating something, instead of waiting a week, what if we waited a day and checked in on the initial direction that person was going? And let's do it even more. What if after I finished explaining, at the end of that conversation, we brainstormed a couple things that, that person wants to do? So within this same conversation, I'm delegating, I'm already getting a sense of, where do you want to go with this? Once you start, do you see any bottlenecks?

**中文翻译:**
最后 F 是反馈（Feedback）。你如何能拥有尽可能短的反馈循环？我非常推崇尽可能缩短反馈循环，然后再缩短一点。所以，即使是在授权的最初对话中，与其等一周，不如等一天就检查一下对方最初的方向是否正确。甚至可以更进一步：在我解释完之后，在对话结束时，我们一起头脑风暴一下对方想做的几件事。所以就在同一次对话中，我授权的同时，已经了解了：“你打算怎么做？一旦开始，你预见会有什么瓶颈吗？”

---

### [01:13:49] Lenny Rachitsky

**English:**
So much of your advice comes back to this idea that we've touched on a couple of times. We just spend a little bit more time upfront. Is that how you described it, a little more time upfront?

**中文翻译:**
你的很多建议都回到了我们提到过几次的那个观点：在前期多花一点点时间。你是这么描述的吗，前期多花一点时间？

---

### [01:13:56] Wes Kao

**English:**
Yeah, a little bit more of an investment upfront.

**中文翻译:**
是的，前期多一点点投入。

---

### [01:13:59] Lenny Rachitsky

**English:**
Upfront to save you tons of time later. Okay. So as you described this, I don't know if you're realizing this, but you're basically just helping people work better with AI and agents. This framework is exactly I think what people need to effectively delegate to this future world of this agent world of society of agents doing work for us. Basically, you're going to be delegating to these agents in the future, and this framework is a really cool way to frame it.

**中文翻译:**
前期投入是为了以后节省大量时间。好。当你描述这些时，我不知道你是否意识到，你基本上是在帮助人们更好地与 AI 和智能体（agents）合作。我认为这个框架正是人们在未来的“智能体世界”中有效地向替我们工作的智能体授权所需要的。基本上，未来你将向这些智能体授权，而这个框架是一个非常酷的构架方式。

---

### [01:15:58] Wes Kao

**English:**
Yeah, I found that AI will often shorten the feedback loop and align with you as well. When you prompt it, when it comes back, it will not do the entire task for me, sometimes. It'll say, "I've done the first part of this. Does this sound right? Is this what you're looking for? If so, I will complete the next section." And then sometimes I'm like, "Do the whole thing. Just stop trying to conserve energy and just do. I want you to do the whole thing." But that's what it's doing, it's breaking it into smaller chunks to de-risk that it's going to use all this bandwidth to process this thing and I'm going to say, "Oh, that's not what I was looking for."

**中文翻译:**
是的，我发现 AI 经常会缩短反馈循环并与你对齐。当你给它提示词（prompt）时，它有时不会直接完成整个任务。它会说：“我已经完成了第一部分。听起来对吗？这是你想要的吗？如果是，我再完成下一部分。”有时我会想：“把全部都做了。别再试图节省能量了，直接做完。我要你做全部。”但这就是它在做的：把它拆成小块，以降低“消耗了所有带宽处理完后，我却说这不是我想要的”这种风险。

---

### [01:17:03] Wes Kao

**English:**
Yeah. So swipe files are really common for marketers, and I think other functions haven't caught on as much, but I think it is really, really useful. And basically a swipe file is collecting inspiration that you can refer back to later on. So some marketers will collect examples of copy, landing pages, ads, et cetera. For me, I have a file, an Apple Notes, file called Smart Things People Have Said, where I will basically paste in phrases, words, things people have said that I thought were well articulated or sounded really intelligent or sounded strategic.

**中文翻译:**
是的。灵感库（swipe files）在营销人员中非常普遍，我认为其他职能部门还没怎么跟上，但我认为它真的非常有用。基本上，灵感库就是收集灵感，以便日后参考。一些营销人员会收集文案、落地页、广告等的案例。对我来说，我在 Apple Notes 里有一个文件，叫“聪明人说过的话”，我会把那些我觉得表达得很好、听起来很睿智或很有战略眼光的短语、词汇和话语粘贴进去。

---

### [01:18:01] Wes Kao (Continued)

**English:**
And I don't actually go back and look through my swipe file very often, I think other people do, but for me, even the act of adding it to my swipe file, I've already gotten value from it because it's training me to be more alert to noticing when something is working well. I think there's so much happening around us all the time that your coworker says something smart and you're like, "Oh, that was nice," and then you keep moving on. But when you stop and pause and think, oh, that was really effective, let me add it to my file, and also think about, why was that effective and is that something I can borrow?

**中文翻译:**
实际上我并不经常回头翻看我的灵感库，我想其他人可能会。但对我来说，仅仅是把它加入灵感库这个动作，就已经让我获益了，因为它在训练我更敏锐地察觉到什么时候某件事做得很好。我认为我们周围时刻发生着很多事，你的同事说了一些聪明的话，你可能会想“噢，那挺棒的”，然后就继续忙别的了。但当你停下来思考“噢，那真的很有效，让我把它加进文件里”，并思考“为什么那很有效，我能借鉴吗？”，这就不一样了。

---

### [01:20:18] Wes Kao

**English:**
Yeah. I love Claude. There are days when I talk to Claude for three or four hours prompting as a thought partner. So yeah, I think that AI is really helpful for an initial draft of something to bounce off of. Sometimes I'll paste in an email that I am not quite sure how to respond to and ask Claude, "Tell me draft reply." And I'll usually give it some direction. So I found that sharing my point of view makes the output way better.

**中文翻译:**
是的。我喜欢 Claude。有时候我会和 Claude 聊上三四个小时，把它当作“思考伙伴”（thought partner）。所以我认为 AI 对于生成初稿、进行思想碰撞非常有帮助。有时我会粘贴一封我不确定该如何回复的邮件，问 Claude：“帮我起草一份回复。”我通常会给它一些方向。我发现，分享我的观点会让输出结果好得多。

---

### [01:21:19] Wes Kao (Continued)

**English:**
If I just give it something and say, "What would you say?" It's just not as good. Whereas if I say, "I am not sure about how to tell this person no, because I previously said yes and so I feel on the hook, but history has changed and so is there a nice way where I can be really respectful of our relationship and also make them feel seen and heard, but decline?" So if I explain, "That's the problem I'm dealing with and here's what I would ideally like to be able to do," Claude comes back to something that's pretty good.

**中文翻译:**
如果我只是给它一些东西并问“你会怎么说？”，效果就没那么好。但如果我说：“我不确定该如何拒绝这个人，因为我之前答应过，所以我觉得有责任，但情况发生了变化。有没有一种委婉的方式，既能尊重我们的关系，让他们感到被重视和被倾听，但又能拒绝？”如果我解释清楚“这就是我面临的问题，这是我理想中想达到的效果”，Claude 给出的回复通常都很棒。

---

### [01:22:46] Wes Kao

**English:**
One is High Output Management by Andy Grove, which is a classic. Another one is Your Brain At Work by Dr. David Rock. And that one is all about better understanding your own brain and attention span so that you can allocate your mental resources appropriately. So that one's great. Ever since reading that, I hide my phone from view because there have been studies that show that even seeing your phone in the corner of your eye, it's distracting.

**中文翻译:**
一本是安迪·格鲁夫的《高产出管理》（High Output Management），那是经典。另一本是 David Rock 博士的《大脑工作法》（Your Brain At Work）。那本书是关于如何更好地了解自己的大脑和注意力跨度，以便合理分配心理资源。那本书非常棒。自从读了那本书，我就会把手机藏起来，不让它出现在视线里，因为有研究表明，即使手机只是出现在你的余光里，也会分散注意力。

---

### [01:26:51] Wes Kao

**English:**
Yes. I actually have many, but I'll share two. One is everything takes longer than you think. So this applies whether you are calling customer support for something or running an errand or building your career, building skills. I find it's useful to add buffers for yourself. This applies for launches too. Just assume it will take longer than you think and you'll be less stressed. The other one is a riff on always be closing, like Glengarry Ross. "It's always be selling." This does not mean pawning your wares, but rather putting forth effort into convincing the other person of whatever your recommendation is.

**中文翻译:**
是的。我其实有很多座右铭，但分享两个。一个是“任何事花费的时间都比你想象的要长”。这适用于任何事，无论是给客服打电话、办私事，还是建立职业生涯、培养技能。我发现为自己留出缓冲时间（buffers）很有用。这也适用于产品发布。只要假设它会比你预想的要慢，你的压力就会小很多。另一个是对《格伦加里·格伦·罗斯》中“永远在成交”的改编：“永远在推销”（Always be selling）。这不意味着兜售商品，而是指努力说服对方接受你的任何建议。

---

### [01:32:33] Wes Kao

**English:**
You can find out more at weskao.com. I linked my course to my coaching from my main page. I also post on LinkedIn as well, so you can follow me there. And I'm always looking to meet fellow operators who out about communication. So if you put any of these principles into practice, I would love to hear about it.

**中文翻译:**
你可以在 weskao.com 了解更多信息。我在主页上链接了我的课程和教练服务。我也会在 LinkedIn 上发帖，你可以在那里关注我。我一直期待结识那些对沟通充满热情的同行。所以，如果你将这些原则付诸实践，我很想听听你的反馈。