# Yuhki Yamashata - 双语对照

This is the complete bilingual transcript of Lenny's Podcast featuring Yuhki Yamashita, Chief Product Officer at Figma.

---

### [00:00:00] Lenny

**English:**
There's something controversial about this idea that everyone can see what you're doing or that multiple designers can be in the file at the same time. We like to say that one of the first responses we saw Lenny [inaudible 01:08:35] Figma was, if this is the future of design, I'm quitting, right? I'm changing careers.

**中文翻译:**
这种“每个人都能看到你在做什么”或者“多个设计师可以同时在一个文件里操作”的想法，在当时是很有争议的。我们常说，看到对 Figma 最早的反馈之一是：“如果这就是设计的未来，那我不干了，我要转行。”

---

### [00:00:17] Lenny

**English:**
And there's that tension of that narrative tension, but that is signal that you're part of this revolution and you're trying to change something. And when it equips your customers or user base with that, then I think that's something that they can really get behind and champion.

**中文翻译:**
这种叙事上的张力其实是一种信号，表明你正处于一场变革之中，你正在试图改变一些现状。当你赋予客户或用户群这种力量时，我认为他们会真正支持并拥护这种变革。

---

### [00:00:35] Lenny

**English:**
So it's not just that they're championing for a tool, they're also championing for a new way of working. Obviously, that's a tall order or don't want to come up with that, but hopefully, if you're a founder and you're working on something, your vision is so big that you have those kind of ideas and it's like, how do you actually equip your customers to want to talk about that?

**中文翻译:**
所以，他们不仅仅是在支持一个工具，他们还在支持一种全新的工作方式。显然，这是一个很高的要求，不容易实现，但如果你是一位创始人，正在开发某个产品，我希望你的愿景足够宏大，能包含这类想法，并且思考：你如何真正让你的客户愿意去谈论和传播它？

---

### [00:00:58] Lenny

**English:**
Welcome to Lenny's podcast. I'm Lenny, and my goal here is to help you get better at the craft of building and growing products, interview world class product leaders and growth experts to learn from their hard won experiences, building and scaling today's most successful companies.

**中文翻译:**
欢迎来到 Lenny 的播客。我是 Lenny，我的目标是帮助你提升构建和增长产品的能力，通过采访世界级的产品领导者和增长专家，学习他们在打造和扩展当今最成功公司过程中积累的宝贵经验。

---

### [00:01:12] Lenny

**English:**
Today my guest is Yuhki Yamashita. Yuhki is Chief Product Officer at Figma, where he's been for almost four years. Prior to Figma, he was at Uber, both as a Product Leader and also, interestingly, as Head of Design for one of their bigger product teams. Before Uber, Yuhki spent time at Google and Microsoft, even taught an introductory computer science course at Harvard.

**中文翻译:**
今天的嘉宾是 Yuhki Yamashita。Yuhki 是 Figma 的首席产品官（CPO），他在那里工作了近四年。在加入 Figma 之前，他在 Uber 工作，既担任过产品负责人，有趣的是，还担任过其中一个大型产品团队的设计负责人。在 Uber 之前，Yuhki 曾在谷歌和微软工作，甚至还在哈佛大学教过计算机科学入门课程。

---

### [00:01:33] Lenny

**English:**
In our conversation, we explore Figma's product development philosophy, how they build such consistently great products, how they hire, what habit Yuhki has found to be the most instrumental in his success in his career, and also what Yuhki and his product team have learned by building a product led growth business.

**中文翻译:**
在我们的对话中，我们将探讨 Figma 的产品开发哲学、他们如何持续打造出如此优秀的产品、他们如何招聘、Yuhki 认为对他职业生涯成功最有帮助的习惯是什么，以及 Yuhki 和他的产品团队在构建产品驱动增长（PLG）业务中学到了什么。

---

### [00:01:50] Lenny

**English:**
This episode builds on a newsletter post where I interview Yuhki about how Figma builds product. So if you enjoy this episode, or even while you're listening to it, I highly recommend you check it out. It's currently my fourth most popular newsletter post of all time. You can find it at lennysnewsletter.com. With that, I bring you Yuhki Yamashita, after a short word from our wonderful sponsors.

**中文翻译:**
本期节目基于我之前对 Yuhki 的一次采访文章，主题是 Figma 如何构建产品。如果你喜欢这期节目，或者在收听过程中感兴趣，我强烈建议你去看看那篇文章。它目前是我有史以来第四受欢迎的通讯文章。你可以在 lennysnewsletter.com 找到它。在听完赞助商的简短介绍后，我们将正式开始与 Yuhki Yamashita 的对话。

---

### [00:02:15] Lenny (Sponsor: Notion)

**English:**
This episode is brought to you by Notion. If you haven't heard of Notion, where have you been? I use Notion to coordinate this very podcast, including my content calendar, my sponsors, and prepping guests for launch of each episode. Notion is an all-in-one team collaboration tool that combines note-taking, document sharing, wikis, project management, and much more into one space that's simple, powerful and beautifully designed.

**中文翻译:**
本期节目由 Notion 赞助。如果你还没听说过 Notion，那你可能落伍了。我用 Notion 来协调这个播客的所有工作，包括内容日历、赞助商管理以及每期节目的嘉宾准备。Notion 是一款全能的团队协作工具，它将笔记、文档共享、维基（Wiki）、项目管理等功能整合在一个简洁、强大且设计精美的空间里。

---

### [00:02:40] Lenny (Sponsor: Notion)

**English:**
And not only does it allow you to be more efficient in your work life, but you can easily transition to using it in your personal life, which is another feature that truly sets Notion apart. The other day, I started a home project and immediately opened up Notion to help me organize it all. Learn more and get started for free. At notion.com/lennyspod, take the first step towards an organized happy team today. Again, at notion.com/lennyspod.

**中文翻译:**
它不仅能提高你的工作效率，还能轻松过渡到个人生活中使用，这是 Notion 脱颖而出的另一个特点。前几天我开始了一个家庭项目，立刻就打开 Notion 来整理一切。访问 notion.com/lennyspod 了解更多并免费开始使用，今天就迈出通往高效快乐团队的第一步。网址是 notion.com/lennyspod。

---

### [00:03:08] Lenny (Sponsor: Vanta)

**English:**
This episode is brought to you by Vanta, helping you streamline your security compliance to accelerate growth. If you're business stores any data in the cloud, then you've likely been asked, or you're going to be asked about your SOC 2 compliance. SOC 2 is a way to prove your company's taking proper security measures to protect customer data and builds trust with customers and partners, especially those with serious security requirements.

**中文翻译:**
本期节目由 Vanta 赞助，帮助你简化安全合规流程以加速增长。如果你的业务在云端存储数据，那么你很可能已经被问到，或者即将被问到关于 SOC 2 合规性的问题。SOC 2 是证明公司采取了适当安全措施来保护客户数据的一种方式，有助于建立客户和合作伙伴的信任，特别是那些有严格安全要求的客户。

---

### [00:03:33] Lenny (Sponsor: Vanta)

**English:**
Also, if you want to sell to the enterprise, proving security is essential. SOC 2 can either open the door for bigger and better deals, or it can put your business on hold. If you don't have a SOC 2, there's a good chance you won't even get a seat at the table. Beginning a SOC to your port can be a huge burden, especially for startups. It's time consuming, tedious and expensive.

**中文翻译:**
此外，如果你想向企业级客户销售产品，证明安全性至关重要。SOC 2 既可以为你打开通往更大订单的大门，也可能让你的业务停滞不前。如果你没有 SOC 2，很可能连谈判桌都上不去。获得 SOC 2 报告可能是一个巨大的负担，尤其是对初创公司而言，既耗时、繁琐又昂贵。

---

### [00:03:55] Lenny (Sponsor: Vanta)

**English:**
Enter Vanta. Over 3000 fast growing companies use Vanta to automate up to 90% of the work involved with SOC 2. Vanta can get you ready for security audits in weeks instead of months, less than a third of the time that it usually takes. For a limited time. Lenny's podcast listeners get $1,000 off Vanta. Just go to vanta.com/lenny, that's V A N T A.com/lenny to learn more and to claim your discount. Get started today.

**中文翻译:**
Vanta 应运而生。超过 3000 家快速增长的公司使用 Vanta 来自动完成高达 90% 的 SOC 2 相关工作。Vanta 可以让你在几周内（而不是几个月）做好安全审计准备，时间不到通常所需的三分之一。在限定时间内，Lenny 播客的听众可以享受 1000 美元的 Vanta 优惠。只需访问 vanta.com/lenny 即可了解更多并领取折扣。今天就开始吧。

---

### [00:04:28] Lenny

**English:**
Yuhki, welcome to the podcast.

**中文翻译:**
Yuhki，欢迎来到播客。

---

### [00:04:30] Yuhki Yamashita

**English:**
Thank you for having me, Lenny.

**中文翻译:**
谢谢你的邀请，Lenny。

---

### [00:04:32] Lenny

**English:**
I'm quite honored to have you on this podcast. For folks who don't know, we actually collaborated already on a newsletter post that has quickly become my fourth most popular post of all time, which you can find if you search for how Figma builds product. And so I am really excited to dig into a lot of the stuff that we, maybe, didn't cover in that newsletter. Also, just like how product works at Figma in more depth, how the PM team works, how you think about product, and things like that. So again, thank you for joining me.

**中文翻译:**
能邀请到你我感到非常荣幸。对于还不了解的听众，我们之前合作过一篇通讯文章，它迅速成为了我历史上第四受欢迎的文章，搜索“Figma 如何构建产品”就能找到。所以我非常兴奋能深入探讨一些我们在那篇文章中没涵盖的内容，比如 Figma 产品运作的深度细节、PM 团队的工作方式、你对产品的思考等等。再次感谢你的加入。

---

### [00:05:00] Yuhki Yamashita

**English:**
Hi, team, as a huge fan of this podcast, so really honored to be here.

**中文翻译:**
大家好，我是这个播客的忠实粉丝，所以能来到这里真的很荣幸。

---

### [00:05:04] Lenny

**English:**
Wow, that means a lot. I really appreciate that. So you are currently Chief Product Officer at Figma, which is such an epic role. It's such an epic company. Could you take just, maybe, a minute or two to high level share your career arc, how you got to where you're today as CPO at Figma?

**中文翻译:**
哇，这对我意义重大，非常感谢。你目前是 Figma 的首席产品官，这是一个非常了不起的角色，Figma 也是一家伟大的公司。你能花一两分钟时间简要分享一下你的职业生涯轨迹，以及你是如何走到今天 Figma CPO 这个位置的吗？

---

### [00:05:22] Yuhki Yamashita

**English:**
My first job out of college is actually at Microsoft, and I was the Product Manager on Hotmail. If anyone, any listener remembers Hotmail, and I didn't really know what product management was at the time, and I mute it as a interdisciplinary function that will give me exposure to all my other functions so that I can actually decide which function's interesting to me.

**中文翻译:**
我大学毕业后的第一份工作是在微软，担任 Hotmail 的产品经理。如果听众里有人还记得 Hotmail 的话。当时我并不真正了解什么是产品管理，我把它看作一个跨学科的职能，可以让我接触到所有其他职能，从而决定哪个职能对我更有吸引力。

---

### [00:05:48] Yuhki Yamashita

**English:**
And so, spent a couple years at Microsoft. Through that, also, moved on to Hotmail to Windows. And at the time, they were working on Windows 8 and Windows 8 was really interesting because it's a very touch forward version of Windows. And so there's just a lot of conversations about UI and UX, and that was really fun for me.

**中文翻译:**
我在微软待了几年。期间从 Hotmail 转到了 Windows 部门。当时他们正在开发 Windows 8，Windows 8 非常有趣，因为它是一个非常强调触控体验的版本。因此有很多关于 UI 和 UX 的讨论，这对我来说非常有意思。

---

### [00:06:07] Yuhki Yamashita

**English:**
And as I was thinking about what's next, I really felt the draw of Silicon Valley and I ended up at YouTube, and I believe Shishir has been on this podcast before?

**中文翻译:**
当我思考下一步该做什么时，我感受到了硅谷的吸引力，最终去了 YouTube。我相信 Shishir（YouTube 前高管）之前也上过你的播客吧？

---

### [00:06:19] Lenny

**English:**
[inaudible 00:06:19] you.

**中文翻译:**
是的。

---

### [00:06:19] Yuhki Yamashita

**English:**
Yeah, so Shishir was leading YouTube at the time, and he continues to be a great mentor of mine, but had the opportunity to lead the YouTube app on iOS over there. And it was really funny because I had never touched the iPhone before my first day, so my manager, on my first day, just sent me to the Apple Store to buy an iPhone. But that was my next job and that was a really interesting change for me, too, of, and we can talk about this later, as well as different companies and different styles of product management and really figuring out, I think it was a place that taught me a lot about some of my product last weeks to date.

**中文翻译:**
是的，Shishir 当时领导 YouTube，他一直是我的良师益友。我有机会在那里领导 iOS 版 YouTube 应用。很有趣的是，在入职第一天之前我从未碰过 iPhone，所以我经理在第一天就直接把我送到苹果零售店去买了一部 iPhone。那是我的下一份工作，对我来说也是一个非常有趣的转变。我们可以稍后讨论不同公司和不同风格的产品管理，我认为那段经历教会了我很多关于产品哲学的知识。

---

### [00:06:58] Yuhki Yamashita

**English:**
And this is also around a time where there are a lot of interesting companies that were working in the physical and digital space. And so Airbnb was one of them, Uber was another. So I felt this draw just because it seemed just a really interesting space to be in. So eventually, ended up at Uber. Uber was another company where I feel like a lot of my philosophy that, hopefully we can get into today, around how to build products, how to build products in the kind of environment that's really fast moving. And so that I learned a lot from there.

**中文翻译:**
那段时间也有很多有趣的公司在探索物理空间和数字空间的结合，比如 Airbnb 和 Uber。我被这种领域吸引，因为这看起来非常有趣。最终我去了 Uber。在 Uber，我形成了许多关于如何构建产品、如何在快速变化的环境中构建产品的哲学，希望我们今天能深入探讨这些。我在那里学到了很多。

---

### [00:07:33] Yuhki Yamashita

**English:**
To date, all those companies has really been focusing on the core experiences on consumer products, and that's really been most of my career. And as part of that, worked with a lot of amazing designers. But at Uber, I realized that I wanted to dip my toes into design directly. For the tail end, I actually switched from PM to design and managed a few design teams working on our bikes and scooter efforts just to understand what that's like. And it was around this time, around my Uber career, where we encountered this tool called Figma.

**中文翻译:**
到目前为止，我待过的所有公司都非常关注消费级产品的核心体验，这也是我职业生涯的大部分重点。在此期间，我与许多优秀的设计师合作。但在 Uber 时，我意识到我想直接尝试设计工作。在后期，我实际上从 PM 转到了设计岗位，管理了几个负责自行车和滑板车业务的设计团队，只是为了了解那是种什么体验。正是在 Uber 工作的这段时间，我们遇到了 Figma 这个工具。

---

### [00:08:08] Yuhki Yamashita

**English:**
I'd happened to be working on a project that experimentally brought Figma into the company. It was a time in the company where we were trying to transform our culture to be much more transparent and inclusive, and Figma was the perfect fit for that. So, I got to watch how Figma changed the way it worked, how it's spread within the company. We got to know the Figma team a little bit, as well. And yeah, I was really drawn to that mission and as a product manager who's been straddling that boundary between design and products for all my career, I really loved how Figma proactively blurred that boundary and opened up that process of participating in design. So I really got behind that mission and that's how I ended up here, at Figma.

**中文翻译:**
我当时恰好负责一个实验性地将 Figma 引入公司的项目。那时公司正试图将文化转型得更加透明和包容，而 Figma 完美契合这一点。于是，我目睹了 Figma 如何改变工作方式，以及它如何在公司内部传播。我们也开始了解 Figma 团队。作为一个职业生涯一直游走在设计和产品边界的产品经理，我非常喜欢 Figma 主动模糊这一边界并开放设计参与过程的方式。我非常认同这个使命，这就是我最终来到 Figma 的原因。

---

### [00:08:49] Lenny

**English:**
It's so fascinating that you moved into design from product, and then back into product. At Uber, were, what was the role? You were Head of Design for the mobility team?

**中文翻译:**
从产品转到设计，然后再回到产品，这太迷人了。在 Uber 时，你的角色是什么？你是移动出行团队的设计负责人吗？

---

### [00:08:59] Yuhki Yamashita

**English:**
Yeah, it's called New Mobility, focused on just our micro mobility efforts, basically. Yeah.

**中文翻译:**
是的，叫“新移动出行”（New Mobility），基本上专注于我们的微型出行（如单车、滑板车）业务。

---

### [00:09:05] Lenny

**English:**
Do you recommend this path for PMs to switch into design? I know it's not something anyone can do, but do you feel like that is an important skill role to experience as a PM, you encourage people to try that?

**中文翻译:**
你推荐 PM 转行做设计的这条路径吗？我知道这不是每个人都能做到的，但你觉得作为 PM，去体验这个角色是一种重要的技能锻炼吗？你会鼓励人们尝试吗？

---

### [00:09:16] Yuhki Yamashita

**English:**
Well, I decided it's not for everyone, but I think that it's, first of all, a really great empathy building exercise of understanding that point of view, and also pushing yourself to push on the product from a different angle. Because I think as a PM, you're in the center facilitating all these different trade offs, and when you go into design, you have to ignore some of those other aspects to really be insistent on pushing on the best experience possible. Just suspend everyone's disbelief in business feasibility or engineering feasibility to push on a vision. And that's just an interesting exercise to do.

**中文翻译:**
我觉得这并不适合所有人，但我认为，首先，这是一个非常好的建立同理心的练习，能让你理解那个视角，并迫使你从不同的角度去推动产品。因为作为 PM，你处于中心位置，协调各种权衡；而当你进入设计领域，你必须忽略其中一些方面，坚持推动最佳体验。为了实现愿景，你得暂时抛开大家对商业可行性或工程可行性的怀疑。这是一个非常有趣的练习。

---

### [00:10:00] Yuhki Yamashita

**English:**
And then, I think the last thing is, I actually think it's an opportunity for in design and PM to learn from each other. When I became manager of design teams, one of the things that I coach designers on, are how to win over PMs, and how to speak in PM's language, and likewise, it's important for PMs to understand that, as well. So those are some of the things that I thought were helpful, but again, it has to come from a place of passion that you know you really want to do this.

**中文翻译:**
最后一点是，我认为这是设计和 PM 互相学习的机会。当我成为设计团队的经理时，我辅导设计师的一件事就是如何赢得 PM 的支持，以及如何用 PM 的语言交流；同样，PM 理解这一点也很重要。这些都是我认为有帮助的地方，但再次强调，这必须源于你内心真正的热忱。

---

### [00:10:29] Lenny

**English:**
Which job would you say is harder; design or product management?

**中文翻译:**
你觉得哪份工作更难：设计还是产品管理？

---

### [00:10:32] Yuhki Yamashita

**English:**
They're hard for different reasons. I would say managing designers is harder than managing product managers.

**中文翻译:**
它们难在不同的地方。我会说，管理设计师比管理产品经理更难。

---

### [00:10:38] Lenny

**English:**
Interesting.

**中文翻译:**
有趣。

---

### [00:10:39] Yuhki Yamashita

**English:**
And I think part of it is that designers are, it's really important to focus on growing their craft and helping them develop as designers. So it might not be that the company's biggest problem is one where you can actually learn this new thing you're trying to learn as a designer, and this probably happened for engineers, too, right? You could be working on the onboarding funnel, and that might not be the best place to be learning micro interactions, or maybe it is, but those aren't always aligned.

**中文翻译:**
我认为部分原因是，对于设计师来说，专注于提升他们的手艺（Craft）并帮助他们成长为设计师非常重要。但公司目前最大的问题，可能并不是一个能让你学到你想学的新设计技能的问题。工程师可能也有类似情况，对吧？你可能在负责新用户引导流程（Onboarding funnel），但这可能不是学习微交互（Micro interactions）的最佳场景，或者也许是，但这两者并不总是对齐的。

---

### [00:11:10] Yuhki Yamashita

**English:**
Whereas, with Pms, it's a little bit more like PMs are just hungry for impact, and so you can point them to the biggest problems a company has. And while PMs also do want to understand different kinds of problems or have the experience working on different kinds of problems, at the end of the day, I feel they want to be working on the thing that matters most in the company. So from that perspective, it's easy.

**中文翻译:**
相比之下，PM 更多是渴望产生影响力，所以你可以指引他们去解决公司面临的最大问题。虽然 PM 也想了解不同类型的问题或获得不同领域的经验，但归根结底，我觉得他们最想做的是对公司最重要的事情。从这个角度来看，管理 PM 相对容易。

---

### [00:11:31] Yuhki Yamashita

**English:**
But as you know, and the reason this podcast exists is because PM isn't easy. And so the discipline, I think, is harder in a sense that it's sometimes hard on a day-to-day pace to know if you're doing the best thing you could possibly be doing. And so I think that makes it a little bit harder as a PM, as well.

**中文翻译:**
但如你所知，这个播客存在的原因就是因为 PM 并不容易。我认为这个学科更难的地方在于，在日常节奏中，你有时很难知道自己是否正在做最正确的事情。所以我觉得作为 PM，这方面会更难一些。

---

### [00:11:52] Lenny

**English:**
I had a designer friend who moved into a PM role, I had a product role at a startup and she's like, "Holy shit, I had no idea how hard being a product manager was, and a product leader. I have so much more empathy for the PM role." And so, it's interesting, it works in both ways. Similarly, I was actually a manager of engineers, at one point, and I felt the same way where managing PMs was a lot easier than managing engineers. So, translates to a lot of different roles.

**中文翻译:**
我有一个设计师朋友转到了 PM 岗位，在一家初创公司负责产品，她说：“天哪，我以前根本不知道做产品经理和产品领导者有多难。我现在对 PM 这个角色充满了同理心。”所以这很有趣，这种同理心是双向的。同样，我曾经管理过工程师，我也有同感，觉得管理 PM 比管理工程师容易得多。所以这种感觉在很多不同角色间都是通用的。

---

### [00:12:19] Yuhki Yamashita

**English:**
Yeah, I can see that.

**中文翻译:**
是的，我能理解。

---

### [00:12:20] Lenny

**English:**
Folks listening to your career arc and just all the places you've been, all the wonderful things you've done. Imagine many people are like, wow, how do I have a career like that? Microsoft, Google, Figma, Uber. If you had to think back and identify maybe one habit, or one skill, or behavior that you think has most contributed to your success as a leader, as a product leader, what do you think that would be?

**中文翻译:**
听众们听到你的职业轨迹，你去过的那些地方，做过的那些精彩的事情，肯定很多人在想：哇，我怎样才能拥有那样的职业生涯？微软、谷歌、Figma、Uber。如果你回过头来，找出一种对你作为产品领导者的成功贡献最大的习惯、技能或行为，你觉得会是什么？

---

### [00:12:45] Yuhki Yamashita

**English:**
People who work with me know that I often talk about storytelling and, in fact, if you've ever reported to me, storytelling has showed up in some kind of performance review, I feel, and that's how much I care about it. And I actually think that a lot of being a great product manager is being a great storyteller. And I know a lot of us have already talked about it out there. I think the importance of storytelling is understood, but maybe I would share two things that are specific about it that I think are interesting.

**中文翻译:**
和我一起工作的人都知道我经常谈论“讲故事”（Storytelling）。事实上，如果你曾是我的下属，我觉得“讲故事”肯定出现在你的绩效评估里过，这就是我重视它的程度。我真的认为，成为一名优秀的产品经理，很大程度上在于成为一名优秀的讲故事的人。我知道很多人都讨论过这一点，讲故事的重要性是不言而喻的，但我可以分享两个我认为很有趣的具体方面。

---

### [00:13:13] Yuhki Yamashita

**English:**
One is to understanding the power of synthesis and it's this idea that maybe even as a early career PM, you're inside some of these reviews and a lot of people say, "Hey, at least you could take some notes for the meeting so that you're adding value." And so that's common advice, here, but I think the most powerful part of that is that in some ways, you can synthesize what happened. And a lot of things are said in a review and there's still this bring it all together into a distillation of a message. And even that's like, that's a lot of power, I think. And what do you take away from all these different opinions that all these leaders had, and how do you push that, push the project forward from there? So that's one example.

**中文翻译:**
第一是理解“综合”（Synthesis）的力量。即使是职业生涯早期的 PM，在参加评审会议时，很多人会建议：“嘿，你至少可以做会议记录，这样你就在创造价值。”这是很常见的建议，但我认为其中最强大的部分是，你可以对发生的事情进行综合。评审会上会说很多东西，而你需要将所有这些信息提炼成一个核心信息。我认为这本身就蕴含着巨大的力量。你从领导者们提出的所有不同意见中提取了什么？你如何以此为基础推动项目前进？这是一个例子。

---

### [00:14:02] Yuhki Yamashita

**English:**
Or another example is, I really love thinking through frameworks and offering ways of talking about a problem or ways of thinking about a problem. And that's synthesis, too, of figuring out all these different disparate parts and coming up with a way to a lens to look at something. And I feel like it's something that was, I learned, mostly through literature classes almost, where you're doing literary commentary and you're reading a William Yates poem and you're trying to, you observe all these interesting things, but then you have to take those different observations and distill it into a thesis, into something cohesive. And I think that's what a good PM can do. All these different ideas, and opinions, and problems, and how do you distill it down? And so I think that's one aspect of storytelling that's really important.

**中文翻译:**
另一个例子是，我非常喜欢通过框架来思考，并提供讨论或思考问题的方法。这也是一种综合——理清所有零散的部分，并找到一个观察事物的视角。我觉得这种能力主要是在文学课上学到的，就像做文学评论，读叶芝的诗，你观察到很多有趣的细节，但你必须把这些观察提炼成一个论点，一个连贯的东西。我认为这就是优秀 PM 能做的事：面对所有不同的想法、意见和问题，你如何将它们提炼出来？我认为这是讲故事中非常重要的一个方面。

---

### [00:14:54] Yuhki Yamashita

**English:**
And the other aspect of storytelling, of course, is a story is only as good as the action that it's capable of driving. And a lot of times that I often coach my product managers are on, we're living in a world where everyone is constantly distracted, and you get these 30 seconds of attention at a time. And so, just the ability to really tell something powerful that sticks is really important, the memorability of it.

**中文翻译:**
讲故事的另一个方面当然是：一个故事的好坏取决于它能驱动多少行动。我经常辅导我的产品经理：我们生活在一个每个人都不断分心的世界，你一次只能获得 30 秒的注意力。因此，讲述一些强大且能让人记住的东西的能力非常重要，也就是它的“可记忆性”。

---

### [00:15:21] Yuhki Yamashita

**English:**
And I often talk about memification, which is this idea that I found this out most at Uber, I feel, where there's certain insights, data insights, research insights that were memmified to the point where someone like Travis or Dara would just cite this insight in the middle of a meeting, and you know that you've really done your job as, maybe, a researcher or a data scientist or product manager if people are able to do that and draw from that in that way. And that's what, ultimately, sticks.

**中文翻译:**
我经常谈论“模因化”（Memification，或称迷因化）。我觉得这是我在 Uber 发现的最深刻的一点：某些洞察（数据洞察、研究洞察）被模因化到了某种程度，以至于像 Travis（Uber 创始人）或 Dara（Uber 现任 CEO）会在会议中随口引用。如果你作为研究员、数据科学家或产品经理，能让人们以这种方式引用你的洞察，那说明你的工作真的做到了位。这才是最终能留存下来的东西。

---

### [00:15:52] Yuhki Yamashita

**English:**
And so when you start thinking about it from that perspective, it's really powerful because it's the way in which knowledge is transferred within the company and you compel action for it. Or when I'm being, maybe, asked questions by other leaders or stakeholders, the thing that's going through my head is, okay, there's this story that, that leader is trying to develop, or a meme about what this project is about or what the biggest problem is. And so, what story are they trying to create in their head so that they can remember or talk about what's happened?

**中文翻译:**
当你从这个角度思考时，它会变得非常强大，因为这是公司内部知识传递的方式，也是你促成行动的方式。或者当我被其他领导者或利益相关者问到问题时，我脑子里想的是：这位领导者正在试图构建一个什么样的故事，或者关于这个项目或最大问题的“模因”是什么？他们试图在脑海中创造什么样的故事，以便他们能记住或谈论发生的事情？

---

### [00:16:28] Yuhki Yamashita

**English:**
And if you take that mindset, you just realize that it's a really useful way to think about everything.

**中文翻译:**
如果你带着这种心态，你会发现这是一种思考所有事情的非常有效的方式。

---

### [00:16:35] Lenny

**English:**
I'm really excited to chat about this idea because it comes up a lot. The power of storytelling, it's similar to being good at vision. It's like PMs are always told, "Hey, you got to improve in vision." Here's a skill the great PMs are really strong at. And I feel like storytelling is similar. It's this vague cloud of a skill that you build over time. And you mentioned a few things that you recommend to people that you work with. Think of it as a meme, maybe.

**中文翻译:**
我很兴奋能聊聊这个想法，因为它经常被提及。讲故事的力量类似于拥有愿景的能力。PM 总是被告知：“嘿，你需要提升愿景能力。”这是优秀 PM 非常擅长的技能。我觉得讲故事也是类似的，它是一种随着时间推移而建立的、像云一样模糊但重要的技能。你提到了一些给同事的建议，比如把它看作一个“模因”。

---

### [00:17:01] Lenny

**English:**
Is there anything else? When you're doing a performance review with a PM and one of their skill gaps is storytelling, is there anything else you recommend they specifically do to get better at the skill, or is it just do it again and again and watch me do it, watch other people do it and you'll learn?

**中文翻译:**
还有别的吗？当你给 PM 做绩效评估，发现他们的短板是讲故事时，你会建议他们具体做些什么来提升这项技能？还是说只是反复练习，观察你和其他人是怎么做的，然后慢慢学习？

---

### [00:17:16] Yuhki Yamashita

**English:**
Yeah, I think of it as resetting the internal computer of my brain a little bit so that I start from scratch again. And when I'm starting from no context at all, can I build up the story from bare and explain what's happening? And oftentimes, you're just caught in the middle of everything and you have all this context that might not be obvious if you step away from it for just a second.

**中文翻译:**
是的，我把它看作是稍微重置一下大脑里的“内部计算机”，让自己从零开始。当我完全没有背景信息时，我能否从头构建这个故事并解释发生了什么？通常你深陷其中，拥有所有这些背景信息，但如果你抽离出来一秒钟，你会发现这些信息对别人来说并不显而易见。

---

### [00:17:39] Yuhki Yamashita

**English:**
I guess the way to think about it is, put yourself in another user's shoes, and that user is someone who has no idea what's happening and still wants to understand, in a nuanced enough way, what you're grappling with. And so, that reset moment, and to pull yourself out helps you tell a better story, in many cases. So that's one thing that comes to mind, yeah.

**中文翻译:**
我想思考的方式是：把自己放在另一个用户的立场上，这个用户完全不知道发生了什么，但仍想以足够细腻的方式理解你正在解决的问题。这种“重置”和“抽离”的时刻，在很多情况下能帮你讲出一个更好的故事。这是我想到的一点。

---

### [00:18:03] Lenny

**English:**
Got it. So it's escape the curse of knowledge a little bit and just assume people don't know anything about the context, the background, why this is important, come back to the beginning.

**中文翻译:**
明白了。所以就是稍微摆脱“知识的诅咒”，假设人们对背景、来龙去脉以及为什么这很重要一无所知，回到原点。

---

### [00:18:12] Yuhki Yamashita

**English:**
Yeah, I think another thing that where I learned storytelling is through teaching. So when I was a course assistant for a computer science class and I had to explain pointers, you're like, okay, I really have to borrow on real world metaphors or something that is much more grounding because if you assume a lot of knowledge, then it can be inaccessible to a lot of people. And so if you can tell a story that any student can understand, then you've really done your job. And once you've learn that skill of being able to tell anyone who has no context, then it becomes much easier to turn to these other audiences that are closer and closer.

**中文翻译:**
是的，我学习讲故事的另一个途径是通过教学。当我担任计算机科学课的助教，必须解释“指针”（Pointers）时，你会发现：好吧，我真的得借用现实世界的比喻或一些更接地气的东西，因为如果你假设对方有很多背景知识，那么很多人就听不懂。如果你能讲一个任何学生都能听懂的故事，那你才算完成了任务。一旦你学会了向完全没有背景的人解释清楚，那么转向那些背景越来越接近的受众就会变得容易得多。

---

### [00:18:51] Lenny

**English:**
When I asked you in our newsletter interview what one of the core philosophies of product managers is, in the way you think about product and the role of PM at Figma, an interesting thing that you highlighted is that to you, it's really important that PMs own the why of a product and an idea. And I think it connects to what you're talking about, now. I'm curious just why you think that's so important for product managers and why that's so core to the way you think about product, and at Figma.

**中文翻译:**
在我们的通讯采访中，当我问你关于产品经理的核心哲学，以及你如何看待 Figma 的产品和 PM 角色时，你强调了一个有趣的观点：对你来说，PM 必须对产品和想法的“为什么”（Why）负责，这非常重要。我觉得这和你刚才谈到的内容有关。我很好奇，为什么你认为这对产品经理如此重要，为什么这是你和 Figma 产品思维的核心？

---

### [00:19:17] Yuhki Yamashita

**English:**
I really can't remember why I heard this, but it really stuck with me because oftentimes, there's this debate about well, is a PM the person who comes up with the idea. And the answer is usually no, it doesn't have to be at all. And in many cases, in our case, your customers come up with a ton of different ideas and certainly, the what and how are things that are shared within the company and not something that PM uniquely drives. But I do think the why is something that I really always hold the PM uniquely responsible for.

**中文翻译:**
我记不清是在哪听到的了，但它深深印在了我的脑海里。因为通常会有争论：PM 是那个想出点子的人吗？答案通常是否定的，完全不必如此。在很多情况下，比如我们，客户会提出大量的想法。当然，“做什么”（What）和“怎么做”（How）是公司内部共享的，并不是 PM 唯一驱动的事情。但我确实认为，PM 应该对“为什么做”（Why）负有独特的责任。

---

### [00:19:48] Yuhki Yamashita

**English:**
And I think the place where I learned this, the importance of this the most, was actually first, at YouTube. I had been working at Microsoft for a long time and I was early in my career, so I was just really focused on my, what we called, our feature crew, our engineer designer, our tester, and just writing specs that really specified exactly how everything works. And so that was the Microsoft culture back then, and your specs had to be perfect, right?

**中文翻译:**
我认为我学到这一点、意识到其重要性的地方，最初是在 YouTube。我曾在微软工作了很长时间，当时处于职业生涯早期，所以我非常专注于我们所谓的“功能小组”（Feature crew）——工程师、设计师、测试员，只是写那些详细规定一切如何运作的规格说明书（Specs）。那是当时的微软文化，你的规格说明书必须完美，对吧？

---

### [00:20:19] Yuhki Yamashita

**English:**
Then moved over to YouTube, and all of a sudden, you're responsible for an entire app, and you have a pretty big team, and you cannot specify everything that happens. And so, naturally, designers and engineers are just making their own choices. Made is an error handling situation, and in Microsoft culture, you would've had a table that specifies exactly what happens during that error. But in Google culture, it's like, okay, well the engineers and designers, they can figure it out.

**中文翻译:**
后来搬到了 YouTube，突然之间，你要负责整个 App，团队规模很大，你无法规定发生的每一件事。所以，设计师和工程师自然会做出自己的选择。比如遇到错误处理的情况，在微软文化中，你会有一个表格精确规定错误发生时该怎么办；但在谷歌文化中，则是：“好吧，工程师和设计师，他们能搞定。”

---

### [00:20:47] Yuhki Yamashita

**English:**
So then it's like, how do they make a really great decision? How do they make all these local decisions that you're not a part of, how do you make it so that a great decision's made? And if everyone has an understanding of why we're doing this, what problem we're solving, then people can make really great decisions. It's the only way you can really scale. So that's where it came from.

**中文翻译:**
那么问题来了：他们如何做出伟大的决定？在那些你没有参与的局部决策中，你如何确保他们能做出正确的选择？如果每个人都理解我们“为什么”要做这件事，我们要解决什么问题，那么人们就能做出伟大的决定。这是实现规模化的唯一途径。这就是这个想法的由来。

---

### [00:21:06] Yuhki Yamashita

**English:**
And then since then, I've started to realize, also, that there are other functions that do this well. So for example, our engineering team at Figma, whenever we do a retro or postmortem, we do this thing called five why's. And it's the idea behind it, it's like, well, why did this happen, outage happen, okay, and why did that thing happen? And go deep enough where you can find the root cause and go fix all those things.

**中文翻译:**
从那以后，我也开始意识到其他职能部门也做得很好。例如，我们在 Figma 的工程团队，每当我们进行回顾（Retro）或复盘（Postmortem）时，我们会做“五个为什么”（Five Whys）。其背后的理念是：为什么会发生这个故障？好吧，那为什么那件事会发生？深入挖掘直到找到根本原因并修复所有问题。

---

### [00:21:28] Yuhki Yamashita

**English:**
And I think a PM can do this, too, which is a customer is asking for a feature, but then you would say, okay, why are they asking for it, and back up the problem. But I think there's one more step you can take, which is, why do they have that problem in the first place? And maybe there's something there, and that could be an opportunity to make a bigger product impact by fixing that underlying condition that created the problem in the first place.

**中文翻译:**
我认为 PM 也可以这样做：当客户要求一个功能时，你会问，好吧，他们为什么要这个功能？然后追溯问题。但我认为还可以再进一步：他们最初为什么会有那个问题？也许那里隐藏着机会，通过修复产生问题的底层状况，从而产生更大的产品影响力。

---

### [00:21:55] Lenny

**English:**
That's so cool that you actually do the five whys. I hear people talking about the five whys all the time, and I don't know, I haven't heard people actually using it. So you actually do this at your post-mortems, you said?

**中文翻译:**
你们真的在用“五个为什么”，这太酷了。我总听人提起它，但还没听说谁真的在用。你说你们在复盘时真的会这么做？

---

### [00:22:03] Yuhki Yamashita

**English:**
Yes. Engineering team that's accepting them, yeah.

**中文翻译:**
是的，工程团队非常接受这种方式。

---

### [00:22:07] Lenny

**English:**
That's so interesting. Can you talk a bit more about these postmortems? Is this just when something goes wrong or is this just every project you retrospective postmortem thing?

**中文翻译:**
很有趣。你能多谈谈这些复盘吗？是只有出问题时才做，还是每个项目都会进行回顾复盘？

---

### [00:22:14] Yuhki Yamashita

**English:**
As it relates to five whys, it's more when something went wrong. But I do think we have a retro culture, [inaudible 00:22:24], where there's always opportunity to make things better. And if you don't create the environments to talk about it, then some of those will go unaddressed forever, so.

**中文翻译:**
就“五个为什么”而言，更多是在出问题的时候。但我确实认为我们有一种回顾文化，总是有改进的机会。如果你不创造一个讨论这些问题的环境，那么有些问题可能永远得不到解决。

---

### [00:22:33] Lenny

**English:**
Cool. Okay.

**中文翻译:**
好的。

---

### [00:22:34] Lenny

**English:**
Another attribute of the product team and how you build product at Figma that you shared that was really interesting is you mentioned that you just have an obsession with a proximity to customers, that you make sure your PMs and product team are really close to customers. When you hear that, you're just, imagine everyone listening is like, oh yeah, we're really close to customers, we talk to customers all the time. Of course you got to talk to customers. I'm curious what it is that, maybe, you think sets you apart, in terms of how you think about being close to customers, and if there's a story, maybe, of just, wow, this is how close we are to customers and maybe something that emerged out of that, that'd be really cool to hear.

**中文翻译:**
你分享的关于 Figma 产品团队和构建产品的另一个非常有趣的特质是，你提到你们痴迷于“贴近客户”，确保 PM 和产品团队与客户保持极近的距离。听到这个，我想每个听众都会想：“哦，我们也离客户很近，我们经常和客户交流。”当然，大家都得和客户交流。我很好奇，在你看来，你们在“贴近客户”方面的思考有什么独特之处？有没有什么故事能体现“哇，我们离客户竟然这么近”，或者由此产生了一些成果？

---

### [00:23:07] Yuhki Yamashita

**English:**
Well, I think a lot of it starts with our origin story in many ways, which is that way back when, when Dylan, the small group of people were building Figma, this is the time when no one believed it was possible to have a design editor in the browser. And so it just seemed like science fiction, almost. And yet, what Dylan did consistently throughout, was just put the product in front of designers, ask them for feedback, come back to them the next time with that feedback implemented, and it becomes better and better and better.

**中文翻译:**
我认为这在很大程度上源于我们的创业故事。很久以前，当 Dylan 和那一小群人构建 Figma 时，没有人相信在浏览器中运行设计编辑器是可能的。那简直就像科幻小说。然而，Dylan 一直在做的事情就是把产品推到设计师面前，征求反馈，下次再见他们时已经落实了这些反馈，产品就这样变得越来越好。

---

### [00:23:40] Yuhki Yamashita

**English:**
At no moment was there a tentative expectation that the designer suddenly turns around and implements that tool in their organization. It was really just about listening really carefully to what the community had to say, and through that process, making them evangelists. And that's where a lot of how Figma came to be and why we have such a strong connection with our community where we've actually, they've really helped shape the product to date, and there's a deep belief in that, and they're the ones in that are now advocating for Figma and helping us spread within the community and within their company.

**中文翻译:**
当时并没有指望设计师会突然转身就在他们的组织里推行这个工具。那真的只是为了仔细倾听社区的意见，并在这个过程中让他们成为“布道者”。这就是 Figma 诞生的过程，也是为什么我们与社区有如此深厚的联系——他们确实帮助塑造了今天的产品。我们对此深信不疑，而他们现在正是那些为 Figma 呐喊、帮助我们在社区和公司内部传播的人。

---

### [00:24:20] Yuhki Yamashita

**English:**
So that's the backdrop for why we have such a strong connection with our customers, and there's a lot of things that you see. So for example, maybe someone on my team Sho, and oftentimes, Sho will tweet out to the community, here's what we're thinking, or we're actually thinking about focusing a lot more in prototyping. What are the top problems you're seeing? And people come back with all these different answers because everyone's passionate. And we go in there and just look at all the feedback and understand what people are saying and just have a stronger pulse on how people are feeling. And that's not to say that everything is then implemented verbatim, but we really find it useful to feel like we have a sense of what people are thinking.

**中文翻译:**
这就是我们与客户建立紧密联系的背景。你随处可见这种联系。比如我团队里的 Sho（Sho Kuwamoto），他经常会发推特问社区：“这是我们的想法”，或者“我们正考虑加大对原型的投入，你们遇到的最大问题是什么？”人们会给出各种各样的答案，因为大家都很有热情。我们会去查看所有反馈，理解大家在说什么，从而更准确地把握用户的感受。这并不是说我们会逐字逐句地照搬所有建议，但我们确实觉得了解大家的想法非常有用。

---

### [00:25:05] Yuhki Yamashita

**English:**
And I think the most crazy version of it, maybe, is Dylan's always reading customer feedback. In fact, has reads the most customer feedback of all of us and has been doing that for a decade. And oftentimes, there used to be this thing where he would drop in tweets that he sees into different Slack channels to be like, hey, this seems concerning, or we're getting this feedback. And it got to a point where we got big enough where people would feel like they had to drop everything and deal with that tweet.

**中文翻译:**
最疯狂的一点可能是 Dylan 一直在阅读客户反馈。事实上，他是我们所有人中阅读反馈最多的人，而且已经坚持了十年。过去常有这样的情况：他在推特上看到一些内容，就会丢进不同的 Slack 频道说：“嘿，这看起来令人担忧”，或者“我们收到了这个反馈”。随着公司规模变大，这演变成了一个问题：大家觉得必须放下手头的一切去处理那条推特。

---

### [00:25:31] Yuhki Yamashita

**English:**
So Chris, our CTO, and I intervened. We created this new channel, private channel called Concerning Tweets, and it just, we're this small group of us that Dylan can drop us in. And these are tweets that aren't going viral, by any means. They're just things that you see is with one like, sometimes zero likes, but he feels there's an essence of truth to them and we make sure that we look at what's going on there and see if there isn't something much bigger that we should be focusing on. But that's the extent to which someone like Dylan, from top down, implements this idea that we need to be staying close to what our users are saying.

**中文翻译:**
于是，我们的 CTO Chris 和我介入了。我们创建了一个名为“令人担忧的推文”（Concerning Tweets）的私密频道，只有我们几个人，Dylan 可以把推文丢进来。这些推文绝不是什么爆火的内容，有时只有一个赞，甚至零个赞，但他觉得其中包含某种真相。我们会确保查看这些内容，看看背后是否有更重大的问题需要关注。这就是 Dylan 如何自上而下地贯彻“必须紧跟用户心声”这一理念的程度。

---

### [00:26:13] Lenny

**English:**
That's an awesome idea for a channel, a way to contain that potential madness that it creates. Is there anything else you've learned around hearing feedback like that in a tweet, let's say, or just a few loud voices and deciding what to actually work on? Do you have an approach there? Just deciding what's worth paying attention to?

**中文翻译:**
这个频道的主意太棒了，能有效控制这种反馈可能引发的混乱。关于如何处理推特上的反馈，或者如何从少数几个响亮的声音中决定真正该做什么，你还学到了什么吗？你有什么方法论来决定哪些值得关注吗？

---

### [00:26:31] Yuhki Yamashita

**English:**
As we built out our research and data functions, it's really important to balance out the vocal minority with what's actually happening. So I really view some of those tweets more as canaries in the coal mine, in a way, and inputs into, many inputs we have around everything our customers could possibly be experiencing. And it's important to realize that we have certain forums, like our support tickets, where customers are, tend to be much more dissatisfied. And we have other kinds of inputs that are sales conversations with prospects, where it's really more about perceptions around Figma, in some cases.

**中文翻译:**
随着我们建立起研究和数据职能，平衡“发声的少数派”与“实际发生的情况”变得非常重要。我更多地将这些推文视为“煤矿里的金丝雀”（预警信号），它们只是我们了解客户体验的众多输入源之一。重要的是要意识到，我们有不同的渠道：比如支持工单（Support tickets），那里的客户往往更不满意；还有销售与潜在客户的对话，那更多是关于对 Figma 的认知。

---

### [00:27:11] Yuhki Yamashita

**English:**
And I think it's just important, especially as a product manager, to feel like you have this balanced portfolio of different kinds of feedback to know that you don't have any blind spots. So I think that's one of the things that I focused a lot on when I came in, which is the Figma team is very good at Twitter and staying on top of the sentiments. And luckily for us, a lot of designers are on Twitter, but the reality is that most of our audience, at this point, probably aren't. And so building our capabilities to extract feedback or more insight from those other sources, as well.

**中文翻译:**
我认为，特别是作为 PM，拥有一套平衡的不同类型反馈组合非常重要，这样你才能确保没有盲点。我刚加入时重点关注的一件事就是：Figma 团队非常擅长玩转推特并把握情绪。幸运的是，很多设计师都在推特上，但现实是，我们目前的大多数受众可能并不在推特上。因此，我们需要建立从其他来源提取反馈或洞察的能力。

---

### [00:27:46] Lenny

**English:**
That reminds me, I think Twitter was really instrumental to the beginnings of Figma. I believe Dylan made this social graph of the most influential designers on Twitter, and that was his go-to market strategy, get those designers on Figma, and then I think he open sourced his code to do that. Is that right?

**中文翻译:**
这让我想起，推特对 Figma 的早期发展确实起到了关键作用。我记得 Dylan 曾制作过一个推特上最有影响力的设计师社交图谱，那是他的进入市场（Go-to-market）策略：让这些设计师使用 Figma。我记得他后来还开源了实现这个功能的代码，对吗？

---

### [00:28:02] Yuhki Yamashita

**English:**
Yeah, that sounds right to me. And he is very intentional about which designers we need to win over. I think it was very novel at time.

**中文翻译:**
是的，听起来没错。他对于需要争取哪些设计师非常有针对性。我认为这在当时是非常新颖的做法。

---

### [00:28:11] Lenny

**English:**
What is it like to work with Dylan Field? As an outsider, he's a legend, feels like he's an incredibly smart, talented, hardworking, CO. There's always tension a little bit between a Chief Product Officer and a CO, and so I'm just curious, what do you like to work with as a product leader? And then, is there, I don't know, a memory that comes to mind of just a way that encapsulates what it's like to work with Dylan?

**中文翻译:**
和 Dylan Field 一起工作是什么感觉？在外界看来，他是个传奇，极其聪明、有才华且勤奋。CPO 和 CEO 之间总会有些张力，所以我很好奇，作为产品领导者，你觉得和他共事怎么样？有没有什么回忆能概括与 Dylan 共事的感觉？

---

### [00:28:32] Yuhki Yamashita

**English:**
We're very different, actually. And Dylan is very, he's very based on intuition and instinct. And that intuition is actually built off of thousands and hundreds of thousands of customer interactions where he might look at something and be like, "You know what? This isn't going to land well," or, "Here's the biggest problem right now." And you're like, well, how does it conclude that? And part of my job is to build out that logic streak for him of how did you arrive at that conclusion so that people can understand that at scale, in a way. But he's very much about that.

**中文翻译:**
实际上我们非常不同。Dylan 非常依赖直觉和本能。而这种直觉实际上是建立在成千上万次客户互动的基础上的。他可能会看着某个东西说：“你知道吗？这个效果不会好，”或者“现在最大的问题在这里。”你会想：他是怎么得出这个结论的？我的部分工作就是为他梳理逻辑链条——你是如何得出这个结论的——以便让大家能理解。但他确实非常看重直觉。

---

### [00:29:09] Yuhki Yamashita

**English:**
Or I think there's a way which, sometimes, it's a product manager, you want to lay out a problem and say, okay, we're going to first focus on this problem, and then [inaudible 00:29:21] these three approaches. We're going to take this approach and have a review at every step along the way. But for Dylan, I think, it's very hard for him to really fully get bought into it until he sees the end implementation to viscerally feel if this is a good solution or not. And so I think that's the kind of thinker he is where he really needs to see it to feel it. But it's not totally random. It's based on all these interactions with customers and somehow encoded in him to build up some of those intuitions.

**中文翻译:**
或者作为 PM，你可能想陈述一个问题，然后说：“我们要先关注这个问题，然后有这三种方案，我们选这一种，并且每一步都要评审。”但对于 Dylan 来说，除非他看到最终的实现，从直觉上感受到这是否是一个好的解决方案，否则他很难完全认同。他就是那种需要“眼见为实”的思考者。但这并非随机，而是基于与客户的互动，并以某种方式编码在他体内，形成了这些直觉。

---

### [00:29:55] Yuhki Yamashita

**English:**
And I think one of the things that's really interesting about him is that he actually really cares very deeply about any given user and how they're feeling about Figma. I remember when, during the height of the pandemic, we were doing a one-on-one walking around Delores Park, because this is the era where you would take meetings, if you take meetings, they're all outside, and then he needed to use the bathroom. So he came out to my house in the Castro, he used the bathroom, and then he met my partner, and my partner was on Figma, had Figma pulled up because he is just doing work. And then Dylan just went straight in there and wanted to ask what the biggest problems were or what's not working, and they started geeking out on some issue around Google fonts, and this is the first major interaction between the two of them.

**中文翻译:**
我觉得他非常有趣的一点是，他真的非常关心每一个用户对 Figma 的感受。我记得在疫情最严重的时候，我们在 Delores 公园散步进行 1 对 1 会议，因为那时候开会都在户外。后来他想上厕所，就去了我位于 Castro 的家。他在那见到了我的伴侣，当时我伴侣正开着 Figma 在工作。Dylan 直接走过去问他最大的问题是什么，或者哪里不好用，然后他们就开始钻研起关于 Google 字体的一些技术细节。那是他们第一次深入交流。

---

### [00:30:45] Yuhki Yamashita

**English:**
But it's one of those things where that's how much Dylan cares. And on one level it's just easy to say, "Hey, this is a single user who just happens to be using your product," and be dismissive with it or not care that deeply because you think you already know all the biggest problems, but that's not his attitude. And so that's the level of, I guess, customer obsession, if you will, that he exhibits and then, in turn, informs his intuitions.

**中文翻译:**
这就是 Dylan 关心的程度。在某种程度上，你很容易说：“嘿，这只是一个恰好在用你产品的普通用户”，然后不屑一顾，或者不那么在意，因为你觉得自己已经知道所有大问题了。但他不是这种态度。这就是他表现出的“客户痴迷”程度，而这反过来又塑造了他的直觉。

---

### [00:31:16] Lenny

**English:**
That's amazing. Figma is 10 years old at this point. He's been at this for a long time, like a decade. And the fact that he's still so obsessed with just a random person just using Figma and he's taken the opportunity to experience it in real time every chance he gets, sounds like.

**中文翻译:**
太神奇了。Figma 已经成立 10 年了，他坚持了十年。他依然如此痴迷于一个普通用户使用 Figma 的体验，并且听起来他会抓住每一个机会去实时观察这种体验。

---

### [00:31:31] Yuhki Yamashita

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:31:33] Lenny (Sponsor: Flatfile)

**English:**
Hey, Ashley, Head of Marketing at Flatfile, how many B2B SaaS companies would you estimate need to import CSP files from their customers?

**中文翻译:**
嘿，Ashley（Flatfile 营销负责人），你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### [00:31:41] Ashley

**English:**
At least 40%.

**中文翻译:**
至少 40%。

---

### [00:31:42] Lenny

**English:**
And how many of them screw that up, and what happens when they do?

**中文翻译:**
其中有多少公司搞砸了这件事？搞砸了会发生什么？

---

### [00:31:45] Ashley

**English:**
Well, based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSP importer doesn't work right, which is super common, considering a customer files are chalk full of unexpected data and formatting, they'll leave.

**中文翻译:**
根据我们的数据，大约三分之一的人在入职引导（Onboarding）过程中只要有一次糟糕的体验，就会考虑更换服务商。所以如果你的 CSV 导入器不好用（这很常见，因为客户文件充满了意外的数据和格式），他们就会流失。

---

### [00:32:05] Lenny

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup conversion and increasing long-term retention. Getting people to your a-ha moment more quickly and reliably is so incredibly important.

**中文翻译:**
我一点也不意外。我一直发现，优化入职引导是提高注册转化率和长期留存率的最有效手段之一。让用户更快速、更可靠地达到“A-ha 时刻”极其重要。

---

### [00:32:19] Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify and Zora are able to grow their businesses on top of Flatfile. It's because Wallace data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zora 这样的客户如何在 Flatfile 之上实现业务增长，真是令人惊叹。这是因为无缝的数据入职引导就像催化剂，让他们和他们的客户能更快地达到目标。

---

### [00:32:36] Lenny

**English:**
If you'd like to learn more or get started, check out Flatfile at flatfile.com/lenny.

**中文翻译:**
如果你想了解更多或开始使用，请访问 flatfile.com/lenny。

---

### [00:32:44] Lenny

**English:**
As an outsider, it feels like Figma is just always firing in all cylinders, shipping the best product. People love it. I use it, I should've mentioned this, but I use it probably every day for my newsletter for illustrations and banners and all this stuff. Yeah, I don't know what I do without it. And it always feels like Figma is just killing it. I know that's never the reality. I'm curious, is there a story of something that just, maybe, didn't work out the way you hoped? Whether it's a feature, a launch, or something like that that just shows people that it's, not everything always works out.

**中文翻译:**
作为一个局外人，感觉 Figma 总是全速前进，发布最好的产品。人们热爱它。我也在用，我应该提一下，我几乎每天都用它来做通讯文章的插图、横幅之类的。没有它我真不知道该怎么办。感觉 Figma 总是无往不利。但我知道现实并非总是如此。我很好奇，有没有什么故事是关于某些事情没能如你所愿发展的？比如某个功能、某次发布，能让大家看到并不是所有事情都一帆风顺。

---

### [00:33:14] Yuhki Yamashita

**English:**
We run experiments all the time that don't come back with winning results, and we certainly have built a lot of more complex features that took a while to take off. A good example of this is in the design system space, we have something called branching and merging. And branching and merging is this workflow of maybe you're building a really complex design system, and then you don't want anyone ever randomly touching your components that are used by thousands of other projects, so you create this workflow of, someone, maybe, effectively suggesting a change, you're reviewing it and then pushing it in.

**中文翻译:**
我们经常进行实验，但结果并不理想；我们也确实构建过许多复杂的、需要很长时间才能普及的功能。一个很好的例子是设计系统（Design System）领域的“分支与合并”（Branching and Merging）。这是一种工作流：当你构建一个非常复杂的设计系统时，你不希望任何人随意改动那些被成千上万个项目引用的组件，所以你创建了这个流程——有人提议修改，你评审，然后合并进去。

---

### [00:33:48] Yuhki Yamashita

**English:**
And so, in theory, makes a lot of sense and things that our customers asked us for, but once we built it, in the initial stages, just didn't really see that much adoption and didn't feel great because it's a really big investment for us. It's a lot of work that we put into it and there's just many different reasons. Some of it was performance, some of it was, this is a foreign workflow and it just takes time, and us helping customers implement some of those workflows, we realized some gaps because we don't really use it that much ourselves.

**中文翻译:**
理论上这非常有意义，也是客户要求的。但我们做出来后，初期并没有看到太多的采用，这感觉并不好，因为我们投入了巨大的精力和工作。原因有很多：有些是性能问题，有些是因为这种工作流对用户来说很陌生，需要时间适应。在帮助客户实施这些工作流的过程中，我们发现了一些差距，因为我们自己其实并不怎么用这个功能。

---

### [00:34:20] Yuhki Yamashita

**English:**
And so, I think as we're getting bigger, one of the things that I'm realizing is that we're starting to build a lot of features that are not, necessarily, for organizations like ours. And when we do that, we really need to be creative about how we understand how effective those are because we've had such a strong culture of internal testing and dogfooding, and those are the things that really helped make sure the quality of our product was good enough. But now we're working with really new types of customers and needing to push ourselves and build that muscle, as well.

**中文翻译:**
所以，随着公司规模变大，我意识到的一点是：我们开始构建许多并不一定适合像我们这样规模的组织的功能。当我们这样做时，我们需要创造性地去理解这些功能的有效性。因为我们一直有很强的内部测试和“吃自家狗粮”（Dogfooding）的文化，这曾是确保产品质量的关键。但现在我们面对的是全新的客户类型，我们需要逼自己一把，建立起这方面的能力。

---

### [00:34:54] Lenny

**English:**
Speaking of high quality software, again, I'll repeat, I think Figma is one of the most beloved software products. It's become central to a lot of the ways people work. It's also, I think, one of the fastest growing SaaS products, in general. And I don't know, this is maybe the ultimate softball question, but I'm just curious, what is it that you do at Figma to build such high quality software? Because it's rare for B2B software, especially. What do you do as a product leader, as a product team to just set this high bar, make sure that the stuff that you put out is great consistently, and the more tactical the better?

**中文翻译:**
说到高质量软件，我再重复一遍，我认为 Figma 是最受喜爱的软件产品之一。它已成为许多人工作方式的核心。它也是增长最快的 SaaS 产品之一。这可能是一个非常简单的问题，但我很好奇，你们在 Figma 内部到底做了什么来打造如此高质量的软件？因为这在 B2B 软件中非常罕见。作为产品领导者和产品团队，你们如何设定这个高标准，确保产出的东西始终如一地优秀？越具体越好。

---

### [00:35:27] Yuhki Yamashita

**English:**
It's so important that you're using your own products. And I think we're in a very lucky position where all of us can get creative around using Figma in some way. And obviously, designers are the, internally within Figma, are the most vocal and the ones who are in the product six hours a day, essentially. But even for PMs, one of the first things I did when I arrived was we were a little bit more of a memo culture, and I was like, you know what? We should be a deck culture because we can build those decks in Figma, and just that act alone allows you to encounter a lot of issues and for you to get familiar with it.

**中文翻译:**
使用自己的产品非常重要。我们处于一个非常幸运的位置，所有人都能以某种方式创造性地使用 Figma。显然，Figma 内部的设计师是最敢于发声的，他们每天基本有六个小时泡在产品里。但即使是 PM，我刚来时做的一件事就是改变文化：我们当时更倾向于文档（Memo）文化，我说：“不，我们应该变成幻灯片（Deck）文化”，因为我们可以在 Figma 里做幻灯片。仅仅是这个举动，就能让你遇到很多问题，并让你熟悉产品。

---

### [00:36:06] Yuhki Yamashita

**English:**
And so I think there are ways in which, sometimes, you have to get creative to enable your company, your entire company to use a product more. Or as an example, recently, we just did calibrations for performance reviews in FigJam, and our Head of Design, Noah, came up with this amazing template and we distributed it through HR and that was another reason for everyone to use FigJam. And so that's the biggest thing. The more hours people are spending inside your product, internally, I think, just naturally becomes better. Because a lot of times, it's not just about people raising their hands and saying this is the problem, it's more about you just want to make your own workflows, your own day-to-day better, and derive satisfaction from improving that.

**中文翻译:**
所以我觉得有时你得发挥创意，让整个公司更多地使用产品。比如最近，我们在 FigJam 中进行了绩效评估的校准（Calibrations），我们的设计负责人 Noah 设计了一个很棒的模板，我们通过 HR 分发下去，这成了大家使用 FigJam 的另一个理由。这就是最关键的一点：内部人员在产品里花的时间越多，产品自然会变得越好。因为很多时候，这不仅仅是有人举手说“这是个问题”，更多的是你想让自己的工作流、自己的日常生活变得更好，并从这种改进中获得满足感。

---

### [00:36:50] Lenny

**English:**
So the takeaway there is get your product teams to use the product as often as possible. That is a really clever way of doing that at Figma. I know you mentioned in our newsletter interview that you switch from memos to decks. Usually, it goes the other way around, and now I get the second order effects of that where people are building their decks in Figma. That is very clever, and not everyone's building collaboration software, but that is a really clever idea. And I think there's probably a bit of trickle down from Dylan's obsession with the product in making it, just continuing to just be obsessed with making a great experience combined with that, people using the product and this trickle down of we really need to make this as awesome as possible.

**中文翻译:**
所以结论是：让你的产品团队尽可能频繁地使用产品。在 Figma 这么做真的很聪明。我记得你在采访中提到你们从文档转向了幻灯片。通常情况是反过来的，现在我明白了其中的二阶效应——大家都在 Figma 里做幻灯片。这非常聪明，虽然不是每个人都在做协作软件，但这确实是个好主意。而且我觉得这可能也源于 Dylan 对产品的痴迷，这种对极致体验的追求，结合大家都在用产品，形成了一种“我们必须把它做得尽可能棒”的渗透效应。

---

### [00:37:27] Yuhki Yamashita

**English:**
There are other companies, for example, when I was at Uber, especially working on the driver's side, of course we went out and driving, and that speaks to some aspects of it. But one of the things that I've realized is when you are logging a bug and you add some engineers to it, to have them look into it, the degree of motivation is so different if that engineer has, somehow, experienced a problem in some way.

**中文翻译:**
其他公司也有类似做法。比如我在 Uber 时，特别是在负责司机端时，我们当然会亲自去开车，这体现了某些方面。但我意识到的一点是：当你记录一个 Bug 并让工程师查看时，如果那个工程师曾亲身经历过那个问题，他的动力会完全不同。

---

### [00:37:51] Yuhki Yamashita

**English:**
So for example, everyone at Uber would take Ubers into work, and if an engineer working a driver app saw a driver struggling with something, they would find it embarrassing and feel personally accountable to go and fix that. And when you can create that sense of personal accountability, then all these crazy things happen and all this progress happens. So I think for us, as getting creative at Uber about, okay, well how do we increase those interaction points at the point where, if someone building feels like they have some kind of personal relationship with the end user, and this is what happens, at Figma, too, where a lot of our designers feel personally accountable, in a way, because all their customers are people they already know in the community on Twitter and all those kinds of things, so they feel like they have to put something out there that's defensible or that they're really proud of. So I think that personal accountability can really make a difference.

**中文翻译:**
例如，Uber 的员工都会打车上班，如果一个负责司机端 App 的工程师看到司机在某个操作上很挣扎，他会觉得很尴尬，并感到有个人责任去修复它。当你能建立这种个人责任感时，奇迹就会发生，进步也会随之而来。在 Uber，我们想方设法增加这些互动点；在 Figma 也是如此，我们的许多设计师感到一种个人责任，因为他们的客户很多都是他们在推特社区里认识的人。他们觉得必须做出一些站得住脚、让自己引以为豪的东西。所以这种个人责任感真的能改变很多。

---

### [00:38:48] Lenny

**English:**
That begs a question of, I imagine this engineer at Uber coming back to their desk and like, I've got to fix this bug. And then their PM's like, no, we got goals to hit, here's our priorities, we got this roadmap, we don't have time to fix this right now. It's just one random bug. And so there's a two part question, just like you have a approach to that, do you encourage engineers, designers just fix stuff that seems broken/you mentioned that you have a fun experience with OKRs and how you've approached OKRs at Figma, and you've gone back and forth a little bit. And so maybe, as a second part, just talking about your experience with OKRs at Figma.

**中文翻译:**
这引出了一个问题：我能想象那个 Uber 工程师回到座位想：“我得修好这个 Bug。”但 PM 却说：“不行，我们有目标要达成，这是优先级，这是路线图，我们现在没时间修这个，这只是个随机的小 Bug。”所以这是一个两部分的问题：你如何处理这种情况？你会鼓励工程师和设计师直接去修复那些看起来坏掉的东西吗？另外，你提到过关于 OKR 的有趣经历，以及你们在 Figma 是如何处理 OKR 的（你们曾反复调整过），所以第二部分请谈谈你在 Figma 的 OKR 经验。

---

### [00:39:21] Yuhki Yamashita

**English:**
The first part, I would say that I think one of the most powerful things, especially for startups, is that bottoms up energy, and maybe a developer noticing something is wrong and just going off and fixing it. And for the most part, I try not to get in the way of that because if people are doing that constantly, and everyone the company is trying to make the product better, that is sometimes a way more effective way to improve the quality of experience than this top down of, oh, let's define this quality experience metric and try to change all the things, because you might miss these things. So that's one aspect.

**中文翻译:**
关于第一部分，我认为特别是对于初创公司，最强大的力量之一就是这种“自下而上”的能量——开发者注意到不对劲，然后直接去修复它。在大多数情况下，我尽量不去阻碍这种行为。如果每个人都在不断尝试让产品变得更好，这有时比自上而下地定义一个“质量体验指标”并试图改变一切要有效得多，因为指标可能会漏掉这些细节。这是其中一方面。

---

### [00:40:01] Yuhki Yamashita

**English:**
And the second thing is, I think a lot of PMs have grown to realize this, which is, if you ask an engineer about how much time it'll cost to go and build something, and it's something that they came up with or they're advocating for, it's almost always half the time as something that you are asking for, as a PM. And that motivation is so different.

**中文翻译:**
第二点是，很多 PM 慢慢都会意识到：如果你问一个工程师开发某个东西需要多长时间，如果是他自己想出来的或者他极力主张的，所花的时间几乎总是你作为 PM 要求他做的一半。那种动力是完全不同的。

---

### [00:40:24] Yuhki Yamashita

**English:**
And that's why getting the buy-in of developers is really important, because you want to feel like they're personally vested in this problem, and then, all of a sudden, their willingness or their creativity, or all these things spike. And so when you think about all those things, when there's a situation where an engineer or a designer's trying to fix a real custom problem, I'm like, by all means. So that's on that.

**中文翻译:**
这就是为什么获得开发者的认同非常重要，因为你希望他们觉得自己在亲自解决这个问题，然后突然之间，他们的意愿、创造力等各方面都会激增。所以考虑到这些，如果工程师或设计师想去修复一个真实的客户问题，我会说：尽管去做。这就是我的看法。

---

### [00:40:50] Yuhki Yamashita

**English:**
OKR is totally bigger topic, and maybe I'll set the conflicts of why I have such this love-hate relationship with it, which is that a lot of my career, I've actually just worked on core experiences, and OKRs were the bane of my existence, in a way. Because when you're working on a core experience, sometimes you're just, I'm just trying to make the experience better. And sure, I can come up with this BS way to measure what that looks like, but that's not what I'm thinking about every day, anyway. So it just seems very performative, and there's just a lot of work that goes into it.

**中文翻译:**
OKR 是个大得多的话题。我先解释一下为什么我对它又爱又恨：在我职业生涯的大部分时间里，我都在负责核心体验，而 OKR 在某种程度上简直是我的克星。因为当你负责核心体验时，有时你只是想让体验变得更好。当然，我可以编造一些胡扯的指标来衡量它，但那根本不是我每天真正在思考的事情。所以它看起来非常像在演戏，而且还要投入大量精力。

---

### [00:41:26] Yuhki Yamashita

**English:**
And you encounter one of two situations. One is, you come up with some secondary metric that nobody actually cares about that, technically, you can measure and, technically, you can move, but you haven't actually proven that it really matters. So maybe it is some satisfaction metric that you have on some survey, but you haven't actually done the work to show that, that actually has correlations with retention or anything that actually "matters for real" in the business, or it's some weird usage metric or something like that.

**中文翻译:**
你会遇到两种情况之一。第一种是，你提出了一个没人真正关心的次要指标，技术上你可以衡量它，也可以提升它，但你并没有证明它真的很重要。也许是某个调查里的满意度指标，但你并没有做功课去证明它与留存率或任何对业务“真正重要”的事情有相关性；或者是一些奇怪的使用量指标之类的。

---

### [00:42:00] Yuhki Yamashita

**English:**
And then the other extreme is to say, no, we're going to be ambitious and we're going to send it for business goals. So for example, even if I was the PM for the rider experience at Uber, I'd be like, you know what? We're going to contribute incremental trips because the experience is going to be so good that we can get more people to come back. And I think the reality for a lot of that is, it's a metric that you don't have full control over or there are many hops until it can affect it, and okay, well maybe we can make the experience better and maybe that improves your attention and maybe this. And by the time you get there, you actually can't even prove that you moved the top level metrics. So either you anchor something that matters, but you can't move, or you anchor something that you can't move but doesn't actually matter. So that's the relationship I've had with [inaudible 00:42:45], so even it's really frustrating.

**中文翻译:**
另一个极端是说：“不，我们要有野心，我们要锚定业务目标。”例如，如果我是 Uber 乘客体验的 PM，我会说：“我们要增加行程数，因为体验太棒了，能吸引更多人回来。”但现实是，这是一个你无法完全控制的指标，中间隔了太多环节。也许我们改善了体验，也许这提高了留存，也许……等你推导到那儿，你甚至无法证明是你拉动了顶层指标。所以，要么你锚定了一个重要但拉不动的指标，要么你锚定了一个拉得动但不重要的指标。这就是我与 OKR 的关系，真的很令人沮丧。

---

### [00:42:47] Yuhki Yamashita

**English:**
So when I write that thinking about, one of the things I realized is that we had OKRs, but people were treating it almost as a to-do list or a task list of, okay, here's how, by the end of quarter, I need to complete these tasks and then I'll feel like I did my job, kind of thing. And we would have these dreadful meetings where we go through these spreadsheets and have people stand up in front of everyone and talk about those commitments, or those key results, rather. But they were dreadful for a reason, which is that you just couldn't really understand what the team actually really cared about. And it got to this point where we had all these, and this is similar to the secondary metric problem, but either you couldn't approve that you actually moved it, or you're trying to work on something that I don't actually understand why it's useful.

**中文翻译:**
当我思考这些时，我意识到我们虽然有 OKR，但大家几乎把它当成了待办事项清单：好吧，到季度末我需要完成这些任务，然后我就觉得我完成工作了。我们会开那些可怕的会议，过一遍电子表格，让大家站在所有人面前谈论这些“承诺”或者说“关键结果”。这些会议之所以可怕，是因为你根本无法理解团队真正关心的是什么。这又回到了次要指标的问题：要么你无法证明你真的拉动了它，要么你在做一些我根本不理解有什么用的事情。

---

### [00:43:39] Yuhki Yamashita

**English:**
And so that was when I deprecated it and said, "I just want to understand your headline. What are you trying to do, philosophically?" And just don't stress about whether you can measure it or not. I just don't understand what you're optimizing for, and let's first have that to date. And then once we get there, then let's talk about, okay, well what are some ways that you can measure it? And some of it's qualitative, so it's quantitative, and that's fine. And I almost feel like sometimes, it's better to take the report card approach of saying, Hey, just give yourself a score, tell me how you derive that score, let's all understand that the metrics and those inputs that go into it can change over time, and we're going to get more sophisticated about how we measure it. But at least everyone understands what on earth you're trying to go for.

**中文翻译:**
于是我废除了它，并说：“我只想知道你们的‘头条新闻’（Headline）。从哲学上讲，你们想做什么？”不要纠结于是否能衡量它。我只想理解你们在优化什么，让我们先达成共识。一旦达成共识，我们再讨论：好吧，有哪些衡量方式？有些是定性的，有些是定量的，这没关系。我甚至觉得有时采取“成绩单”模式更好：嘿，给自己打个分，告诉我你是怎么得出这个分的。让我们都明白，指标和输入可能会随时间变化，我们会变得越来越专业。但至少每个人都明白你到底想达到什么目标。

---

### [00:44:29] Yuhki Yamashita

**English:**
So that's where I moved in my first year, I would say, and then we hired a Head of Data who is a friend of mine from Uber, too. And one of the things she felt was, okay, but it's still very loosey goosey, and super subjective, so let's just try to bring OKRs back and see if we can just do them better next time. And so we've done that, and they were definitely better than when I first arrived just because we had a data science team and we had more rigor around metrics and things like that. But again, this time it was less about not understanding what people were doing, but more not understanding if teams are actually committed to moving those OKRs. And one of the problems that you find is we have these OKRs, but they feel like these post-rationalizations of the projects that you're working on, anyway.

**中文翻译:**
这是我第一年的做法。后来我们聘请了一位数据负责人，她也是我在 Uber 的朋友。她觉得：“好吧，但这还是太松散、太主观了，让我们尝试把 OKR 带回来，看看下次能不能做得更好。”于是我们这么做了，效果确实比我刚来时好，因为我们有了数据科学团队，对指标的要求更严谨了。但这一次，问题不再是不理解大家在做什么，而是不理解团队是否真的致力于拉动这些 OKR。你会发现一个问题：这些 OKR 感觉像是对你已经在做的项目的“事后合理化”。

---

### [00:45:17] Yuhki Yamashita

**English:**
And at the end the quarter, you come back and see if those OKRs move, fingers crossed. But if you stop an engineer in the middle of the hallway or the virtual hallway, so to speak, and ask them, okay, what are your team's biggest goals or OKRs? [inaudible 00:45:31], they wouldn't be able to say it. They're just like, well, I'm working on this project that's really important. And so it's, well, what's the point of publishing this OKR if you're actually not thinking about moving it on a daily basis almost, right?

**中文翻译:**
到了季度末，你回来看看这些 OKR 是否达标，祈祷好运。但如果你在走廊（或虚拟走廊）拦住一个工程师问：“你们团队最大的目标或 OKR 是什么？”他们可能答不上来。他们会说：“我在做一个非常重要的项目。”那么，如果你几乎每天都不考虑去拉动这个 OKR，发布它的意义又在哪里呢？

---

### [00:45:46] Yuhki Yamashita

**English:**
And so that's when we've tried to experiment with this terminology, well, maybe if we should call it commitments instead, people would take it a little bit more seriously. And it's my belief that oftentimes, commitments are this care between the why and the what, and sometimes the face of the commitment is the what.

**中文翻译:**
所以我们尝试实验一些新术语，也许我们应该称之为“承诺”（Commitments），这样大家会更严肃地对待它。我坚信，承诺往往是连接“为什么”和“做什么”的纽带，有时承诺的表现形式就是“做什么”。

---

### [00:46:05] Yuhki Yamashita

**English:**
It's a project and there are many why's behind it, or it's the why and there are many projects behind it. So that what's trying to formalize that idea, but it definitely felt a little bit complicated, a little bit. Sometimes people are like, well, OKRs exist for a reason and this is, basically, an OKR with just a different name. So my honest sense is we still haven't figured it out and we're still iterating on a bunch of different things, but I think I've developed some philosophies around it, which is, no matter what you call it, because it doesn't matter as much.

**中文翻译:**
一个项目背后有很多“为什么”，或者一个“为什么”背后有很多项目。我们试图将这个想法正式化，但确实感觉有点复杂。有时人们会说：“OKR 的存在是有原因的，这基本上就是换了个名字的 OKR。”坦白说，我觉得我们还没完全搞定，还在不断迭代。但我形成了一些哲学：不管你叫它什么，因为名字没那么重要。

---

### [00:46:38] Yuhki Yamashita

**English:**
I think that, for me, there are three things that really matter about a good OKR, and one is legibility. People look at it and understand what it is, and it's not some weird obfuscated metric that doesn't mean anything to anyone. I think actionability, I want OKR to inspire action. You look at that and you're like, it's stirs action, makes me want to do something differently. And the third one is authenticity, which is, does this actually, honestly depict what you're doing, what you're trying to do on a day-to-day basis? Because if it doesn't, then it's hard for me to trust that, that it matters. Or if that's something that just happens to describe what you're doing but isn't really connected in a meaningful way, then I question the value of it all.

**中文翻译:**
对我来说，一个好的 OKR 有三点至关重要。第一是“易读性”（Legibility）：人们一看就明白是什么，而不是一些对谁都没有意义的、晦涩难懂的指标。第二是“可行动性”（Actionability）：我希望 OKR 能激发行动。你看着它会想：“这能促使我采取行动，让我想要做些不同的尝试。”第三是“真实性”（Authenticity）：这是否真实、诚实地描述了你每天正在做和试图做的事情？如果不是，我很难相信它真的重要。或者如果它只是恰好描述了你在做的事，但没有实质性的联系，那么我会质疑它的价值。

---

### [00:47:28] Yuhki Yamashita

**English:**
So that's why I am in the process. But I definitely am all ears to advice around this kind of stuff, because I feel like we haven't quite cracked the code.

**中文翻译:**
这就是我目前所处的过程。我非常愿意听取关于这方面的建议，因为我觉得我们还没完全破解这个难题。

---

### [00:47:38] Lenny

**English:**
I love hearing that. That whole journey. I feel like you always hear from product teams, here's what we do now. You never hear, here's the experiments we've been through, here's what we've tried, here's what worked for a while, here's what doesn't work now, and here's what we're doing now. So it's really cool just to hear all the experimentation you've done. Clearly, Figma is a company where you encourage experimentation and trying new things that aren't working, and it's cool they have the flexibility to just like, let's just do headlines for now, and no more specific goal metrics. We're just going to build things that we think are important.

**中文翻译:**
我喜欢听这些。这整个心路历程。我感觉你总是听到产品团队说：“这是我们现在的做法。”你从来听不到：“这是我们经历过的实验，这是我们尝试过的，这是曾经有效但现在无效的，这是我们现在的做法。”所以听到你做的所有实验真的很酷。显然，Figma 是一家鼓励实验和尝试新事物的公司，而且你们有灵活性，比如可以说“现在只做头条新闻，不再设定具体的指标”。我们只做我们认为重要的事情。

---

### [00:48:09] Lenny

**English:**
And in the newsletter post, for folks that are listening, you actually show the templates that you're using these days for planning your projects and laying out your OKRs, so folks can check those out if they're interested in seeing how you're doing that, now. You also mentioned you've hired this awesome data scientist, and maybe just expanding that further, I imagine a lot of the success of Figma and the product that you built is the people that you hire. At Figma, I believe you have 22 product managers, which sounds very small for a company like Figma, and I imagine they're all amazing. I'm curious what you look for in product leaders and product managers that you hire that, maybe, other folks aren't as focused on, and just what does the interview process look like at Figma?

**中文翻译:**
在通讯文章中（听众们可以去看看），你展示了你们现在用于项目规划和 OKR 布局的模板。你还提到聘请了一位出色的数据科学家。进一步扩展一下，我想 Figma 的成功很大程度上归功于你们招聘的人才。在 Figma，我相信你们只有 22 名产品经理，对于 Figma 这样规模的公司来说，这听起来非常精简，我想他们一定都很优秀。我很好奇，在招聘产品领导者和 PM 时，你会看重哪些别人可能不太关注的特质？Figma 的面试流程又是怎样的？

---

### [00:48:51] Yuhki Yamashita

**English:**
Yeah, I shared some of these things. I really feel passionately about storytelling, and not to give it away or anything, but one of my favorite interview questions is asking, "describe to me a time when you're part of controversial product decision, and what did you do," and all those things. And I think it's really revealing because if they can set up this conflict and understand why this problem was really important and represent both sides in such that you can understand why that conflict existed in the first place, then they can do it in this even-keeled way, where you realize that they can take on these different perspectives. You start to learn a lot about that person, I think.

**中文翻译:**
是的，我分享过一些。我非常看重“讲故事”的能力。为了不剧透太多，我最喜欢的面试问题之一是：“描述一次你参与的有争议的产品决策，你当时做了什么？”我认为这非常有启发性，因为如果他们能描述出这种冲突，理解为什么这个问题很重要，并能客观地呈现双方观点，让你明白冲突最初为何存在，那么你就能看出他们具备多维视角。我觉得这能让你非常了解一个人。

---

### [00:49:35] Yuhki Yamashita

**English:**
Or sometimes, I just ask them for basic things, okay, talk about a big problem that you worked on. And the thought experiment, for me, is always coming out of that, do I feel compelled to work on that problem? And no matter how boring it sounds on the surface, I think a really great product manager can cash something, it's like, well, this is why it's so existential for us, and this why it's so interesting, and really rally the troops up. So that's one big thing of storytelling communication because at the end of the day, so much of our job, it's around that.

**中文翻译:**
或者有时我只问一些基础的问题，比如：“谈谈你处理过的一个大问题。”对我来说，思想实验的结果总是：听完之后，我是否也想去解决那个问题？无论表面上听起来多么枯燥，我认为一个伟大的 PM 都能把它讲得引人入胜：“这就是为什么它对我们生死攸关，这就是为什么它如此有趣”，并真正动员起大家。所以讲故事和沟通是一件大事，因为归根结底，我们的很多工作都是围绕这个展开的。

---

### [00:50:07] Yuhki Yamashita

**English:**
I think other than that, some of the things that I value or things I think about as, hi Dan with UX conversations, it's like we talk about problem, and I think about when you're exploring solutions, it's this tree of, okay, there's just these branches of explorations and you finally arrive at these solutions. And a ton of people who can go up and down branches really quickly, have a really high command of all these different altitudes, as well, so that we can talk through a lot of things at the end of the day, feel like we walk away with some progress.

**中文翻译:**
除此之外，我非常看重在 UX（用户体验）对话中的表现。当我们讨论问题时，我会思考：在探索解决方案时，这就像一棵树，有很多探索的分支，最终到达解决方案。我喜欢那些能快速在不同分支间切换、并能自如掌控不同深度（Altitudes）的人，这样我们就能深入讨论很多事情，并感到取得了进展。

---

### [00:50:43] Yuhki Yamashita

**English:**
And I think that at Uber, our first two Product Officer, Jeff Holden, was someone who often talked about fast forwarding to the future and this idea that, okay, let's just pretend we ran that experiment. What do you think it'll come back with? Or let's pretend we ran that, you just use a study. And the PMs who have the ability to imagine those outcomes, I think, it helps us be much more efficient, too, because we're like, well, if we all think that it's going to go there and that's not going to compel us to take any action, why do it at all?

**中文翻译:**
在 Uber 时，我们的前产品官 Jeff Holden 经常谈论“快进到未来”：好吧，让我们假设我们已经做了那个实验，你觉得结果会是什么？或者假设我们已经做了用户研究。我认为那些有能力想象这些结果的 PM 能帮我们提高效率，因为我们会想：“如果我们都认为结果会是那样，而且那不会促使我们采取任何行动，那为什么还要做呢？”

---

### [00:51:17] Yuhki Yamashita

**English:**
And so I think a lot of PM is about those shortcuts that you have to take. And it's not just about what we build, it's about building the right things. And sometimes, it's just as important to decide not to build something, but it's all only possible if you can have that kind of imagination or that ability to see around corners.

**中文翻译:**
所以我认为 PM 的很多工作在于寻找那些必须采取的捷径。这不仅仅关乎我们构建了什么，更关乎构建正确的东西。有时，决定“不建什么”同样重要，但只有当你拥有那种想象力或预见未来的能力时，这才是可能的。

---

### [00:51:37] Lenny

**English:**
I love that. I was going to ask you for your favorite interview questions in our lightning round and you jumped ahead, which is great. And those are really good examples. Hopefully, they don't give too much away. I want to chat a bit about growth and how Figma grows. If you ask people about product led growth, and just whenever people talk about product led growth, they're always companies like Figma, Slack... Figma is always seen as a model of product led growth and a product that grew through product.

**中文翻译:**
我喜欢这个。我本来打算在闪电轮环节问你最喜欢的面试问题，你提前说了，这很好。这些例子非常棒。希望它们不会透露太多。我想聊聊增长以及 Figma 是如何增长的。如果你问人们关于产品驱动增长（PLG），大家总会提到 Figma、Slack……Figma 一直被视为 PLG 的典范，一个通过产品本身实现增长的产品。

---

### [00:52:04] Lenny

**English:**
I imagine now, there's a very robust sales team, and I imagine, even earlier than people, probably, imagined there was a sales team. I'm curious, as a product leader, what you've learned about how to effectively work with sales and what you teach your product managers about how to work with sales to collaborate effectively.

**中文翻译:**
我想现在你们已经有一支非常强大的销售团队了，而且我猜销售团队的建立可能比大家想象的还要早。我很好奇，作为产品领导者，你学到了哪些与销售团队有效合作的经验？你会教你的 PM 们如何与销售协作？

---

### [00:52:24] Yuhki Yamashita

**English:**
We're really lucky to have a sales team that understands their product really well and can hold their own with customers who are often also design leaders, product leaders and things like that. And I think that kind of credibility goes a really long way. One of the things that we all are collectively realizing is, we talk about product like growth, but in some ways, I like to think about it more as community led growth or there are certain people inside a company that feel so strongly about Figma and that they're helping push for it in these advocates and evangelizing for Figma.

**中文翻译:**
我们非常幸运拥有一支非常懂产品的销售团队，他们能与那些通常也是设计领导者、产品领导者的客户平等对话。我认为这种公信力非常有帮助。我们共同意识到的一点是：虽然我们谈论产品驱动增长，但在某种程度上，我更愿意将其视为“社区驱动增长”。公司内部总有一些人对 Figma 感情深厚，他们作为拥护者在内部推动并宣传 Figma。

---

### [00:53:03] Yuhki Yamashita

**English:**
And so oftentimes, what the sales team does is really empower those individuals to make a stronger case or connect them to the rest of the company so that we can get a wider deployment or more leadership buying and things like that. And so oftentimes, a sales team is playing that role of creating those human connections and helping equip designers that feel passionately inside a company with the data, with the stories and all those things to help make a case. And I think that's the most powerful way in which we can spread where the space of Figma is not the sales team, but in fact, it's the internal designer.

**中文翻译:**
因此，销售团队通常做的是赋能这些个人，让他们能更有力地游说，或者将他们与公司的其他部门联系起来，从而实现更广泛的部署或获得更多领导层的认可。销售团队扮演的是建立人际联系的角色，帮助公司内部那些充满热情的设计师准备数据、故事和所有必要的素材来支持他们的主张。我认为这是我们传播最有力的方式——Figma 的“代言人”不是销售团队，而是公司内部的设计师。

---

### [00:53:47] Yuhki Yamashita

**English:**
And so that is the mental model that I think we've been using it. We're fortunate enough to have people inside companies who are so passionate to want to play that role. And so when you take that lens on, then you start to understand, okay, how can we help set this person up for success? And the sales team has different ways to do it. The product team can help, in terms of giving them visibility into how we're thinking about evolving the product or what other customers might be doing. And so, I really see it as this partnership to enable that much as possible. And I think that's what, to me, product growth looks like at Figma, is that.

**中文翻译:**
这就是我们一直在使用的思维模型。我们很幸运，公司内部有这么多人充满热情并愿意扮演这个角色。当你从这个视角看问题时，你就会开始理解：好吧，我们如何帮助这个人获得成功？销售团队有不同的方法，产品团队也可以提供帮助，比如让他们了解我们对产品演进的想法，或者其他客户在做什么。我真的把它看作是一种伙伴关系，尽可能地赋能。对我来说，这就是 Figma 的产品增长模式。

---

### [00:54:29] Lenny

**English:**
That is really interesting. Basically, making your champion inside the company a superhero, helping them be more effective at what they're already doing, which is evangelizing this product that they really love. Interesting. Is there anything that you think Figma did early on that you think was really important for it to start to grow, either in this way or in a different way? Imagine there's just a lot of product led growth founders that are trying to create a product led growth product, and they fail. And so I'm curious, just what do you think people often miss and what do you think Figma did right that got it going?

**中文翻译:**
这很有趣。基本上就是把你公司内部的拥护者变成“超级英雄”，帮助他们更有效地做他们已经在做的事——也就是宣传他们热爱的产品。很有意思。你认为 Figma 早期做了哪些对增长至关重要的事情？无论是这种方式还是其他方式。我想有很多 PLG 创始人试图打造 PLG 产品却失败了。我很好奇，你认为人们通常忽略了什么？Figma 做对了什么才让它运转起来的？

---

### [00:55:02] Yuhki Yamashita

**English:**
I think a lot of it was about the level of intention around building community. And the more there are organic conversations happening about Figma, the better. And one of the nice things about Figma is you can share out a file that you've been working on, and effectively open source something, but it's your way of showing, here's how we do it at so X, Y, Z company, and sharing that with the rest of the community. And when people see that and when people feel like they have this insider view in how other companies work, that's where there's a lot of interest.

**中文翻译:**
我认为很大程度上在于对构建社区的重视程度。关于 Figma 的自发讨论越多越好。Figma 的一个优点是你可以分享你正在处理的文件，实际上是“开源”了一些东西。这是你展示“我们在某某公司是这么做的”并与社区分享的方式。当人们看到这些，并觉得自己获得了其他公司运作方式的内部视角时，就会产生巨大的兴趣。

---

### [00:55:38] Yuhki Yamashita

**English:**
And more recently, over the last few years, we've really been focused on a program called Friends of Figma where we have people who are passing about Figma, and all our different geographies come together in a Discord channel. They meet regularly and are helping us evangelize. And again, that's that human connection between users, and then between us and the users is something that really helps build that kind of loyalty, which is the thing that, then, fuels all the champions to really push for it, internally, and give people the enthusiasm and courage to do that inside their organization.

**中文翻译:**
最近几年，我们重点关注一个名为“Friends of Figma”的项目。我们将不同地区对 Figma 充满热情的人聚集在 Discord 频道中。他们定期见面并帮助我们宣传。再次强调，这种用户之间、以及我们与用户之间的人际联系，真的有助于建立忠诚度。而这种忠诚度又激励了所有的拥护者在内部大力推动，并赋予人们在组织内部这样做的热情和勇气。

---

### [00:56:16] Lenny

**English:**
It's interesting how many corollaries there are to Notion and how they got started. I recently chatted with Camille, I don't know if you heard that episode, but there's a lot of similarities with how Notion use their community to help jumpstart growth and continue to grow.

**中文翻译:**
有趣的是，这与 Notion 的起步方式有很多相似之处。我最近和 Camille 聊过（不知道你听没听过那集），Notion 利用社区启动增长并持续增长的方式与此非常相似。

---

### [00:56:29] Yuhki Yamashita

**English:**
Totally.

**中文翻译:**
完全正确。

---

### [00:56:30] Lenny

**English:**
It's interesting that you can call that community growth, product growth. There's a lot of overlap there, potentially.

**中文翻译:**
有趣的是，你可以称之为社区增长，也可以称之为产品增长，两者之间有很多重叠。

---

### [00:56:36] Yuhki Yamashita

**English:**
For sure.

**中文翻译:**
确实如此。

---

### [00:56:37] Lenny

**English:**
What advice would you have for folks that are, I don't know, maybe you already shared this, but just if you're a product led growth founder listening to this, do you have any other piece of advice to that founder about how to get started with their product, their community, their growth strategy? Anything else you'd want to share there?

**中文翻译:**
你对那些正在收听的 PLG 创始人有什么建议吗？关于如何开始他们的产品、社区和增长策略，你还有什么想分享的吗？

---

### [00:56:52] Yuhki Yamashita

**English:**
Maybe a different way to talk about what we just talked about, is just, there has to be this, almost irrational, this emotional response to your product and this like love for it. First, it has to be cultivated internally, too. People, internally, have to authentically love something to really stand behind it. But then, externally, too, if people are loving something to the point where they can sing at the top of their lungs and just really talk about how Figma's, great, if we can get there, that's a wonderful place to be.

**中文翻译:**
也许可以用另一种方式来表达：用户对你的产品必须有一种近乎非理性的情感反应和热爱。首先，这种热爱也必须在内部培养。内部人员必须发自内心地热爱某个东西，才能真正支持它。其次，在外部，如果人们热爱到愿意大声歌颂、不停谈论 Figma 有多棒，如果我们能达到那种程度，那就太棒了。

---

### [00:57:27] Yuhki Yamashita

**English:**
And I think that's both a combination of you've really solved their problems well, but you also equip people with a philosophy around a different way of working. And I think that's what worked well for Figma, too, which is, there's something controversial about this idea that everyone can see what you're doing, or that multiple designers can be in the file at the same time. We like to say that one of the first responses we saw [inaudible 00:57:51] Figma was, if this is a future of design, I'm quitting. I'm changing careers. And there's that tension of that narrative tension, but that is signal that you're part of this revolution and you're trying to change something. And when it can equips your customers or user base with that, and I think that's something that they can really get behind and champion, so it's not just that they're championing for a tool, they're also championing for a new way of working.

**中文翻译:**
我认为这结合了两点：你确实很好地解决了他们的问题，同时你也赋予了人们一种关于不同工作方式的哲学。我认为这对 Figma 也很有效：这种“每个人都能看到你在做什么”或“多个设计师同时操作文件”的想法在当时是有争议的。我们常说，对 Figma 最早的反馈之一是：“如果这就是设计的未来，那我不干了，我要转行。”这种叙事上的张力是一个信号，表明你正在参与一场革命，你正在试图改变一些东西。当你赋予客户这种力量时，他们会真正支持并拥护它。所以他们不仅是在支持一个工具，还在支持一种新的工作方式。

---

### [00:58:20] Yuhki Yamashita

**English:**
Obviously, that's a tall order or [inaudible 00:58:23] come up with that. But hopefully, if your a founder, you're working on something, your mission is so big that you have those kind of ideas, and it's how do you actually equip your customers to want to talk about that?

**中文翻译:**
显然，这是一个很高的要求。但希望如果你是一位创始人，你的使命足够宏大，能产生这类想法，那么关键就在于：你如何真正让你的客户想要去谈论它？

---

### [00:58:35] Lenny

**English:**
That's awesome. Reminds me of a quote and a tagline that the Airbnb's first growth team had for a long time. Love drives growth, not the other way around. They made posters of this, put it all over the product teams.

**中文翻译:**
太棒了。这让我想起 Airbnb 第一支增长团队长期使用的一句名言：“热爱驱动增长，而非增长驱动热爱。”他们把这句话印成海报，贴满了产品团队的办公室。

---

### [00:58:48] Yuhki Yamashita

**English:**
I love that.

**中文翻译:**
我喜欢这句话。

---

### [00:58:49] Lenny

**English:**
Part of the office and seemed to have worked for Airbnb, clearly working for Figma. One last question feels like a question we have to touch on. I don't know how much you can say about all this stuff, but with the potential acquisition with Adobe, which I know isn't done, yet, but I'm just curious, what do you think will change, may change, you're hoping will change, you're hoping won't change in how you build product at Figma within Adobe?

**中文翻译:**
这对 Airbnb 有效，显然对 Figma 也有效。最后一个问题，我觉得我们必须谈谈。我不知道你能透露多少，但关于 Adobe 对 Figma 的潜在收购（我知道还没最终完成），我很好奇：在 Adobe 内部，你认为 Figma 构建产品的方式会有什么变化？你希望什么改变？又希望什么保持不变？

---

### [00:59:12] Yuhki Yamashita

**English:**
Totally. Yeah. As you said, it hasn't closed, yet, and so we're still independent companies, but when we think about that theoretical future, I think about people often ask me, so what's going to happen, in terms of the products that you work on, and how is that going to influence Figma? And the answer is, we don't know, yet, but I get excited about two avenues. One is just really continuing our current mission of making product design better. And the reality is we look at product design, a lot of people are still using both Adobe and Figma alongside each other. And maybe you're creating that micro interaction in After Effects, or maybe you're doing that intricate illustration in Illustrator, or editing Raster in Photoshop, and then you're bringing some of those things into Figma. But when you think about the end product development process, there's so many ways in which, if we can make all those things seamless so that you're not juggling a bunch of apps, or maybe you can have one single source of truth, that's really exciting to me to think about. So concretely what that means, I don't know, yet, but as thinking through those journeys, that gets exciting for me.

**中文翻译:**
当然。如你所说，交易还没完成，我们仍是独立公司。但当我们思考那个理论上的未来时，人们常问我：你们负责的产品会发生什么？这会如何影响 Figma？答案是：我们还不知道。但我对两个方向感到兴奋。一是继续我们目前的使命，让产品设计变得更好。现实是，很多人仍然同时使用 Adobe 和 Figma。也许你在 After Effects 里做微交互，在 Illustrator 里做复杂的插画，在 Photoshop 里编辑位图，然后把这些带入 Figma。如果我们能让这些过程变得无缝，让你不再需要在多个 App 间跳来跳去，或者能有一个“单一事实来源”（Single source of truth），那对我来说非常令人兴奋。具体意味着什么我还不知道，但思考这些旅程让我很兴奋。

---

### [01:00:22] Yuhki Yamashita

**English:**
And the other thing is really collaborating with the rest of Adobe and thinking about, we've figured out something really interesting in the form of realtime multiplayer collaboration, and that, as a platform. Adobe has a much broader set of use cases that they've been pursuing, and what do those two things together, what could that enable? And that gets exciting for me to think about all the creative tools that I've used in the past, be it video editing or 3D objects or things like that where it's, okay, if we can bring in the power of the browser, of multiplayer, of this feeling of openness, would that make it way easier for people? Would it make it much easier for people to share work or get involved?

**中文翻译:**
另一件事是与 Adobe 的其他部门合作。我们已经在“实时多用户协作”方面探索出了一些非常有趣的东西，并将其作为一个平台。Adobe 拥有更广泛的使用场景，这两者结合能开启什么可能？想到我过去用过的所有创意工具，无论是视频编辑还是 3D 建模，如果我们能引入浏览器的力量、多用户协作的力量以及这种开放感，是否会让人们的工作变得更容易？是否会让分享作品或参与其中变得更简单？

---

### [01:01:04] Yuhki Yamashita

**English:**
So those are the things that go through my heads, in terms of what's possible. In terms of what I don't want change. I really think that we've figured out something really amazing, in terms of our relationship with the community. We talked about proximity to community and our users. Those are things that we intend to keep and keep doubling down on. And I think it's such an important part of the magic of how Figma works. So it's something that, I think, I will continue to do and that's what I draw a lot of motivation from in the first place.

**中文翻译:**
这些是我脑海中关于可能性的思考。至于我不希望改变的：我真的认为我们在与社区的关系方面做得非常出色。我们谈到了贴近社区和用户，这些是我们打算保留并加倍投入的东西。我认为这是 Figma 运作魔力的重要组成部分。所以这是我会继续坚持的事情，也是我最初动力的源泉。

---

### [01:01:34] Lenny

**English:**
Awesome. You also get to work with Scott Belsky, which is going to be pretty sweet and hoping to get Scott on this podcast at some point, too.

**中文翻译:**
太棒了。你还能和 Scott Belsky 一起工作，那一定很棒。我也希望以后能邀请 Scott 来上这个播客。

---

### [01:01:41] Yuhki Yamashita

**English:**
That'll be awesome.

**中文翻译:**
那太好了。

---

### [01:01:42] Lenny

**English:**
Any closing thoughts before we get to our very exciting lightning round?

**中文翻译:**
在进入精彩的闪电轮环节之前，还有什么总结性的想法吗？

---

### [01:01:46] Yuhki Yamashita

**English:**
It's really easy to listen to some of these podcasts and feel like, oh, these people have kind of figured everything out. But the reality is, we haven't, and we're still experimenting with a lot of things. OKRs is a really good example of that, but a lot of other things. And so, just the other day I wrote about this idea of us living in a work in progress world, and I was talking about more from the context of we live in a world where all of our products, our product players, our strategies are work in progress, and how do you work in a world like that, when what you're reviewing can change the next day.

**中文翻译:**
听这些播客很容易让人觉得：“哦，这些人已经把一切都搞清楚了。”但现实是，我们并没有，我们仍在很多事情上进行实验。OKR 就是一个很好的例子，还有很多其他事情。就在前几天，我写到了“我们生活在一个‘半成品’（Work in progress）世界”的想法。我是在说，我们的产品、产品参与者、策略都是半成品。在这样一个你今天评审的东西明天就可能改变的世界里，你该如何工作？

---

### [01:02:23] Yuhki Yamashita

**English:**
But in a similar way, I think the way we work, the way we run product processes as product managers is, itself, very much a work in progress. So I would love to encourage this kind of conversation, Lenny, that you're facilitating just because you have so much to learn from each other. And I'd love to continue to learn more from all of you on interesting ways that you grapple with these age old problems around things like how to set goals, or how to review work, or how to plan.

**中文翻译:**
同样地，我认为我们作为 PM 的工作方式、运行产品流程的方式，本身也是一个“半成品”。所以我非常鼓励 Lenny 你发起的这种对话，因为我们可以互相学习。我也希望能继续从大家那里学习如何处理那些古老的问题，比如如何设定目标、如何评审工作或如何制定计划。

---

### [01:02:54] Yuhki Yamashita

**English:**
So anyway, just wanted to signal that we are very far from perfect, and I really eager to learn from everyone else, as well.

**中文翻译:**
总之，我只是想表达我们远非完美，我也非常渴望向大家学习。

---

### [01:03:04] Lenny

**English:**
I love that. That also reminds me of something the Airbnb founders always came back to. Joe and Brian were both designers, and as you learn to be a designer, you are taught that everything around you is designed by someone. Someone just decided this webcam's going to look this way and work in this way, this chair, somebody decided very specifically, it's going to be like this. And we assume the things that we are working within are just, they're figured out. Someone much smarter than me figure this out. But it's usually just someone just like you that had to figure something out quickly, and then that's what you're doing now. And so they always encouraged everyone to just remember someone designed this, doesn't mean it's the perfect solution, and you should always rethink things like that and not assume.

**中文翻译:**
我喜欢这个观点。这让我想起 Airbnb 创始人经常提到的一点。Joe 和 Brian 都是设计师，当你学习成为设计师时，你会学到：你周围的一切都是由某人设计的。有人决定了这个摄像头长这样、这么用；有人决定了这把椅子长这样。我们总假设我们所处的环境是“已经被搞定了”的，是比我聪明得多的人想出来的。但通常，那只是一个像你一样的人不得不快速想出一个办法，然后就成了现在的样子。所以他们总是鼓励大家记住：这是某人设计的，并不意味着它是完美的解决方案，你应该始终重新思考，而不是盲目假设。

---

### [01:03:44] Yuhki Yamashita

**English:**
Yep.

**中文翻译:**
没错。

---

### [01:03:44] Lenny

**English:**
Well, with that, we've reached our very exciting lightning round. I've got six short quick questions for you. I'll just go through them pretty quick, whatever comes to mind, share, and we'll see how it all goes. Sound good? All right.

**中文翻译:**
好了，现在进入精彩的闪电轮环节。我有六个简短的问题。我会快速过一遍，你想起什么就分享什么。准备好了吗？

---

### [01:03:56] Yuhki Yamashita

**English:**
Sounds great.

**中文翻译:**
准备好了。

---

### [01:03:56] Lenny

**English:**
Awesome. What are two or three books that you've most recommended to other folks?

**中文翻译:**
太棒了。你向别人推荐最多的两三本书是什么？

---

### [01:04:02] Yuhki Yamashita

**English:**
First one that comes to mind is Switch, and it's really about how to affect organizational change, something that's Shishir recommended to me and we have the difficulty of affecting change in a large organization, basically, and how to overcome that.

**中文翻译:**
我首先想到的是《瞬变》（Switch），它是关于如何影响组织变革的。这是 Shishir 推荐给我的，主要讲在大型组织中推动变革的困难以及如何克服。

---

### [01:04:16] Yuhki Yamashita

**English:**
The second one I would say is my favorite book of all time is one called The Story of the Stone, and it's a Chinese novel, one of the most famous Chinese novels of all time. And it's thousands of pages. It all takes place in a garden, but it's one of the most beautiful piece of work I've read, so I like to recommend that, even though it's nothing to do with PM.

**中文翻译:**
第二本是我有史以来最喜欢的书，叫《石头记》（即《红楼梦》）。这是一部中国小说，也是中国历史上最著名的小说之一。它有几千页，故事都发生在一个大观园里，但它是我读过的最美的作品之一。所以我喜欢推荐它，尽管它和产品管理没关系。

---

### [01:04:38] Lenny

**English:**
Did you say thousands of pages?

**中文翻译:**
你是说几千页吗？

---

### [01:04:39] Yuhki Yamashita

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:04:41] Lenny

**English:**
About a stone. Wow. I will check this out. I love it. I've not heard this one before. Favorite other podcast, other than the one you're currently on?

**中文翻译:**
关于一块石头。哇，我会去看看的。我喜欢这个推荐，以前没听过。除了你现在参加的这个，你最喜欢的播客是什么？

---

### [01:04:49] Yuhki Yamashita

**English:**
Well, I'll have to admit, I'm actually much more of a visual learner, not a listener, and so I rarely listen to podcasts, but the two that I have listened to, in earnest, was first one was Serial a long time ago, and then yours. So I think some of the best, actually, but otherwise, more into reading.

**中文翻译:**
好吧，我得承认，我其实更倾向于视觉学习，而不是听觉学习，所以我很少听播客。但我认真听过的两个，一个是很久以前的《Serial》，另一个就是你的。我觉得这些都是最棒的，除此之外我更喜欢阅读。

---

### [01:05:04] Lenny

**English:**
Awesome. This show's also on YouTube, for folks that don't listening and like watching things. Plug, plug. Favorite recent movie or TV show?

**中文翻译:**
太棒了。这个节目也有 YouTube 版，适合那些不喜欢听而喜欢看的人。顺便打个广告。最近最喜欢的电影或电视节目？

---

### [01:05:18] Yuhki Yamashita

**English:**
The last movie I watched was called The Good Nurse, and it was about a serial killer working in a hospital, but it was a very different take on it. It was very human. It wasn't grotesque at all, and was talking about how broken our system was. So, highly recommend it. Quite sad, but yeah.

**中文翻译:**
我最近看的一部电影叫《良心护士》（The Good Nurse），讲的是一个在医院工作的连环杀手，但视角非常独特。它非常人性化，一点也不恐怖，讨论的是我们的系统有多么破碎。非常推荐，虽然挺悲伤的。

---

### [01:05:37] Lenny

**English:**
Okay, good tip. What are some SaaS products that you love that you, maybe, use at Figma or that you just discovered that you find very useful?

**中文翻译:**
好的，不错的建议。有哪些你喜爱的 SaaS 产品？可能是你们在 Figma 使用的，或者是你刚发现觉得非常有用的。

---

### [01:05:45] Yuhki Yamashita

**English:**
Kind of cheating, but as I mentioned earlier, we're starting to use FigJam for everything from calibrations, to interview debriefs, to product reviews, to everything. So that's thoroughly started to dominate our usage. It's been cool to see. And then we have our usual suspects like Slack and Asana, and then we're all over the place on the rest. Some of us use Notions, some of these use Dropbox Paper, some of these uses Koda, and so we're still figuring that one, out, I'd say.

**中文翻译:**
有点像在作弊，但正如我之前提到的，我们开始在所有事情上使用 FigJam，从绩效校准到面试复盘，再到产品评审。它已经彻底主导了我们的使用。这很酷。然后我们还有常用的 Slack 和 Asana。其他的就比较杂了，有人用 Notion，有人用 Dropbox Paper，有人用 Coda，我们还在摸索中。

---

### [01:06:16] Lenny

**English:**
Dropbox Paper. Very cool.

**中文翻译:**
Dropbox Paper，很酷。

---

### [01:06:17] Yuhki Yamashita

**English:**
Yeah.

**中文翻译:**
是的。

---

### [01:06:18] Lenny

**English:**
I love that product, but I feel like no one uses it anymore, but it's cool that you guys do. Final question, favorite FigJam or Figma plugin or template?

**中文翻译:**
我喜欢那个产品，但感觉现在没人用了，你们还在用真酷。最后一个问题，最喜欢的 FigJam 或 Figma 插件或模板？

---

### [01:06:27] Yuhki Yamashita

**English:**
We have this one called the Alignment Scale, which is a widget that you can insert into FigJam or Figma Design, actually. And we use it all the time. So basically, it's just a simple scale and whenever people click it, their face appears on one end of the spectrum or the other. And so it's our quick way of being like, we're doing a product review, we on a pulse check, we drop it in and we're like, how are people feeling aligned, not aligned?

**中文翻译:**
我们有一个叫“对齐标尺”（Alignment Scale）的小组件，可以插入 FigJam 或 Figma 设计稿中。我们一直在用。它就是一个简单的标尺，人们点击它，他们的头像就会出现在光谱的一端或另一端。这是我们快速进行“脉搏检查”的方式：在产品评审时丢进去，看看大家是觉得对齐了，还是没对齐？

---

### [01:06:52] Yuhki Yamashita

**English:**
And if people are aligned, we just move on. If not, then you know that it's worth a discussion. So it's just a fast way to figure out where all the hotspots are.

**中文翻译:**
如果大家都对齐了，我们就继续。如果没有，那你就知道这值得讨论。这是一种快速找出争议点的方法。

---

### [01:07:01] Lenny

**English:**
Awesome. And if folks want to find that, they can actually go to the newsletter interview that we did. I think if you just Google how Figma builds product, it comes up number one, and then there's a link to actual template, so you can plug that right in. Yuhki, thank you so much for being here. I am going to go play with Figma and FigJam right after this. Two final questions. Where can folks find you online, if they want to reach out, learn more? Are you guys hiring, anything there? And then, two, how can listeners be useful to you?

**中文翻译:**
太棒了。如果大家想找那个组件，可以去我们做的通讯采访文章。谷歌搜索“Figma 如何构建产品”排在第一位，里面有模板链接。Yuhki，非常感谢你来到这里。录完这个我立刻就去玩玩 Figma 和 FigJam。最后两个问题：如果大家想联系你或了解更多，可以在哪里找到你？你们在招人吗？另外，听众能为你做些什么？

---

### [01:07:30] Yuhki Yamashita

**English:**
Yes, you can find me online on Twitter or LinkedIn. Feel free to reach out there. In terms of how you can be useful to us? We're really starting to build a lot of products for this audience, for product managers. FigJam is one example of this, so definitely try it out, give us the feedback, tell me all about all the cool things that you're doing or you wish you could do on FigJam or Figma. And you can tweet at me, you can find me anywhere. And, of course, we're also hiring, so if you know great people or are interested, yeah, there's a lot of roles, so please get in touch.

**中文翻译:**
是的，你可以在推特或 LinkedIn 上找到我。欢迎随时联系。至于大家能为我们做什么？我们正开始为 PM 这个群体构建很多产品，FigJam 就是一个例子。所以请务必试用它，给我们反馈，告诉我你在 FigJam 或 Figma 上做的酷事，或者你希望实现的功能。你可以发推特给我。当然，我们也在招人，如果你认识优秀的人才或者自己感兴趣，我们有很多职位，请联系我们。

---

### [01:08:06] Lenny

**English:**
Awesome. Yuhki, thank you so much for being here.

**中文翻译:**
太棒了。Yuhki，非常感谢你的到来。

---

### [01:08:08] Yuhki Yamashita

**English:**
Thank you so much for having me, Lenny.

**中文翻译:**
非常感谢你的邀请，Lenny。

---

### [01:08:11] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcast, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢大家的收听。如果你觉得这期节目有价值，可以在 Apple Podcast、Spotify 或你喜欢的播客应用中订阅。此外，请考虑给我们评分或留下评论，这能帮助其他听众发现这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。