# Yuriy Timen - 双语对照

This is the complete bilingual (English-Chinese) transcript for Lenny's Podcast featuring Yuriy Timen.

---

### (00:00:00) Yuriy Timen

**English:**
The only thing that's worse than a channel or a tactic that you tried not working. The only thing that's worse now is when you didn't give it the appropriate shot, right? And you prematurely were erroneously concluded that it doesn't work and it's remarkable how often you find that to be the case when I talk to companies, "Oh, YouTube, we tried it. It doesn't work." I'm like, "Okay, can I see what you've tried?" And then you look at it and you're like, "Oh, this thing was not designed to even have a shot at working from the get go."

**中文翻译:**
比你尝试过的渠道或策略不起作用更糟糕的事情只有一件。现在唯一更糟的情况是，你根本没有给它一个合适的机会，对吧？你过早地、错误地断定它行不通。当我与公司交流时，发现这种情况发生的频率高得惊人。他们会说：“哦，YouTube，我们试过了，没用。”我会说：“好，能让我看看你们尝试了什么吗？”然后你一看，就会发现：“哦，这东西从一开始就不是为了能起作用而设计的。”

---

### (00:00:40) Lenny

**English:**
Yuriy Timen is a full-time advisor to companies looking to figure out their growth strategy. He's worked with companies like Canva, Airtable, Otter, Whimsical, Hims, Flow Health, and a dozen others. I know a number of founders who have worked with Yuriy and they all tell me that he transformed how they think about their growth. Before becoming an advisor, he spent nine years at Grammarly where he led growth in marketing and helped turn that into the household name that it is today.

**中文翻译:**
Yuriy Timen 是一位全职顾问，专门帮助公司制定增长策略。他曾与 Canva、Airtable、Otter、Whimsical、Hims、Flow Health 等数十家公司合作。我认识许多与 Yuriy 合作过的创始人，他们都告诉我，Yuriy 彻底改变了他们对增长的思考方式。在成为顾问之前，他在 Grammarly 工作了九年，负责增长和营销，并帮助将其打造成为家喻户晓的品牌。

---

### (00:01:07) Lenny

**English:**
In our chat, we get incredibly tactical about all of the ways that you can grow your product, including when and how to invest in virality, SEO, and paid growth. What's changing across each of those channels and the most common failure modes for B2C startups. This is the most tactical and actionable conversation I have had yet on how to grow your product, particularly a subscription product. And I'm really excited for you to hear it. With that I bring you Yuriy Timen.

**中文翻译:**
在我们的对话中，我们非常深入地探讨了增长产品的所有战术方法，包括何时以及如何投资于病毒式传播（Virality）、SEO（搜索引擎优化）和付费增长。我们还讨论了这些渠道正在发生的变化，以及 B2C 初创公司最常见的失败模式。这是我目前为止进行过的关于如何增长产品（尤其是订阅类产品）最具战术性和可操作性的对话。我非常期待你们能听到这些内容。下面，让我们欢迎 Yuriy Timen。

---

### (00:01:36) Lenny

**English:**
Hey, Ashley, head of marketing and Flat File. How many B2B SAS companies would you estimate B to import CSV files from their customers?

**中文翻译:**
嘿，Ashley，Flat File 的营销负责人。你估计有多少 B2B SaaS 公司需要从客户那里导入 CSV 文件？

---

### (00:01:44) Ashley

**English:**
At least 40%?

**中文翻译:**
至少 40% 吧？

---

### (00:01:46) Lenny

**English:**
And how many of them screw that up and what happens when they do?

**中文翻译:**
那其中有多少公司把这件事搞砸了？搞砸后会发生什么？

---

### (00:01:49) Ashley

**English:**
Well, based on our data, about a third of people will consider switching to another company after just one bad experience during onboarding. So if your CSV importer doesn't work right, which is super common, considering customer files are chalk full of unexpected data and formatting they'll leave.

**中文翻译:**
嗯，根据我们的数据，大约三分之一的人在入职引导（Onboarding）过程中只要有一次糟糕的体验，就会考虑更换公司。所以，如果你的 CSV 导入器运行不正常（这非常普遍，因为客户文件充满了意想不到的数据和格式），他们就会流失。

---

### (00:02:08) Lenny

**English:**
I am 0% surprised to hear that. I've consistently seen that improving onboarding is one of the highest leverage opportunities for both signup, conversion and increasing long term retention. Getting people to your aha moment more quickly and reliably is so incredibly important.

**中文翻译:**
听到这个我一点也不意外。我一直认为，改善入职引导是提高注册转化率和增加长期留存率的最高杠杆机会之一。让用户更快速、更可靠地体验到你的“顿悟时刻”（Aha Moment）是极其重要的。

---

### (00:02:23) Ashley

**English:**
Totally. It's incredible to see how our customers like Square, Spotify, and Zuora are able to grow their businesses on top of flat file. It's because flawless data onboarding acts like a catalyst to get them and their customers where they need to go faster.

**中文翻译:**
完全正确。看到像 Square、Spotify 和 Zuora 这样的客户能够在 Flat File 的基础上发展业务，真是令人赞叹。这是因为完美的数据入职引导就像催化剂一样，让他们和他们的客户能更快地达到目标。

---

### (00:02:40) Lenny

**English:**
If you'd like to learn more or get started, check out Flat File at flatfile.com/lenny.

**中文翻译:**
如果你想了解更多信息或开始使用，请访问 flatfile.com/lenny 查看 Flat File。

---

### (00:02:47) Lenny

**English:**
This episode is brought to you by Modern Treasury. Modern Treasury is a next generation operating system for moving and tracking money. They're modernizing the developer tools and financial processes for companies managing complex payment flows. Think digital wallets via crypto on ramps, ride sharing, marketplaces, instant lending, and more. They work with high growth companies like Gusto, Pipe, Class Pass and Marketa. Modern Treasuries robust APIs allow engineering to build payment flows right into your product while finance can monitor and approve everything through a sleek and modern web dashboard. Enabling real time payments, automatic reconciliation, continuous accounting and compliance solutions. Modern Treasuries platform is used to reconcile over $3 billion per month. They're one of the hottest young FinTech startups on the market today. Having raised funding from top firms like Benchmark Altimeter, SB Capital, Salesforce Ventures, and Y Combinator. Check them out at moderntreasury.com.

**中文翻译:**
本集节目由 Modern Treasury 赞助。Modern Treasury 是用于资金移动和追踪的下一代操作系统。他们正在为管理复杂支付流的公司实现开发工具和财务流程的现代化。想想通过加密货币入口的数字钱包、网约车、市场平台、即时贷款等等。他们与 Gusto、Pipe、Class Pass 和 Marketa 等高增长公司合作。Modern Treasury 强大的 API 允许工程团队直接在产品中构建支付流，而财务团队则可以通过简洁现代的 Web 仪表板监控和批准一切。它支持实时支付、自动对账、持续会计和合规解决方案。Modern Treasury 的平台每月处理超过 30 亿美元的对账。他们是当今市场上最热门的年轻金融科技初创公司之一，已从 Benchmark、Altimeter、SB Capital、Salesforce Ventures 和 Y Combinator 等顶级机构筹集了资金。请访问 moderntreasury.com 了解他们。

---

### (00:03:50) Lenny

**English:**
Yuriy, welcome to the podcast.

**中文翻译:**
Yuriy，欢迎来到播客。

---

### (00:03:52) Yuriy Timen

**English:**
Thanks for having me man. This is great.

**中文翻译:**
谢谢邀请，伙计。这太棒了。

---

### (00:03:55) Lenny

**English:**
It's even better for me.

**中文翻译:**
对我来说更棒。

---

### (00:03:57) Yuriy Timen

**English:**
All right.

**中文翻译:**
好的。

---

### (00:03:58) Lenny

**English:**
So I'm going to give a quick bio. Let me know if I missed anything really important. You were head of growth at Grammarly. You spent nine years there kind of doing all the things that helped turn that company into the killer product that it is today. You left that I think a couple years ago. Now you're advising companies mostly full-time. I think mostly on growth strategy. I think mostly consumer startups, is that about right?

**中文翻译:**
我先简单介绍一下你的背景。如果我漏掉了什么重要的信息，请告诉我。你曾是 Grammarly 的增长负责人。你在那里工作了九年，做了很多事情，帮助那家公司变成了今天这样一款杀手级产品。我想你是几年前离开的。现在你几乎全职担任公司顾问，主要负责增长策略，而且大多是针对消费级初创公司，对吗？

---

### (00:04:21) Yuriy Timen

**English:**
A couple of super critical corrections. Number one, it was only eight and a half years.

**中文翻译:**
有几个非常关键的修正。第一，只有八年半。

---

### (00:04:26) Lenny

**English:**
Okay. Usually people round those up. I'm impressed that you get-

**中文翻译:**
好吧。通常人们都会四舍五入。我很惊讶你居然——

---

### (00:04:31) Yuriy Timen

**English:**
I think eight and a half is long enough. Yeah, not sure I want to round up. I know, but I'm kidding obviously. Yeah. That's largely it. Grammarly was a hell of a run and trying to take a step back from that, and stepping back has kind of taken on a life of its own vis a vis advising.

**中文翻译:**
我觉得八年半已经够长了。是的，我不确定我想不想四舍五入。我知道，但我显然是在开玩笑。是的，基本就是这样。在 Grammarly 的经历是一段了不起的历程，我试着从中抽身，而这种“退一步”的状态在顾问工作中逐渐形成了它自己的节奏。

---

### (00:04:54) Lenny

**English:**
How many companies have you worked with at this point advised and what are some examples, just like companies people would know.

**中文翻译:**
到目前为止，你已经为多少家公司提供过咨询？能举几个大家可能知道的例子吗？

---

### (00:05:01) Yuriy Timen

**English:**
It's now been about, I guess two years and three months since my last day at Grammarly in an operating capacity. I've probably worked with maybe 15 companies in the last two and a little bit of years. Obviously, not all at once. It's usually four to five at any given point in time. But some of the ones that I've been really lucked out with in terms of getting aligned with companies like Canva, Airtable, Hims and Hers in the personal care space, there is otter.ai. Who else? Flow Health, the world's most downloaded period tracker.

**中文翻译:**
从我离开 Grammarly 的运营岗位到现在，大概已经过了两年零三个月。在过去的两年多时间里，我可能合作过 15 家公司。显然不是同时进行的，通常在任何特定时间点会有四到五家。我很幸运能与一些公司达成合作，比如 Canva、Airtable、个人护理领域的 Hims & Hers，还有 otter.ai。还有谁呢？Flow Health，全球下载量最高的经期追踪应用。

---

### (00:05:47) Lenny

**English:**
I used that for my wife. It's handy.

**中文翻译:**
我给我妻子用过那个，很方便。

---

### (00:05:49) Yuriy Timen

**English:**
Good, good. Yeah. I was trying to get my wife to try it out, but been unsuccessful.

**中文翻译:**
好，很好。我也想让我妻子试试，但没成功。

---

### (00:05:59) Lenny

**English:**
You're failing in your growth.

**中文翻译:**
你的增长策略失败了。

---

### (00:06:01) Yuriy Timen

**English:**
She was like, "Are you trying to push me to having a third kid?" I was like, "No, no, I swear." This is just product testing.

**中文翻译:**
她当时说：“你是不是想逼我生第三个孩子？”我说：“不，不，我发誓。”这只是产品测试。

---

### (00:06:08) Lenny

**English:**
Clever. So I've had Casey Winters on this podcast and Elena Verna. It's kind of like the three of you that it feels like have worked with the most companies as advisors. I don't know if there's some kind of contest y'all have or anything, but do you think about that at all? Is there anyone else out there that you think is in the running?

**中文翻译:**
聪明。我之前邀请过 Casey Winters 和 Elena Verna 来这个播客。感觉你们三位是作为顾问合作过最多公司的人。我不知道你们之间是不是有什么比赛之类的，但你会考虑这个吗？你觉得还有其他人也在这个行列中吗？

---

### (00:06:26) Yuriy Timen

**English:**
First of all, just being mentioned the same breath as those two is an accolade in and of itself. I mean, I look up to both of them. They've gone first. Also, I credit a lot of my getting started to both of them because they've been very generous with their time when I was just kind of considering advising, especially Casey, if they listen to this. Huge shine out to both of them, but Casey especially. He's such immense when it comes to just being generous with his time. So no, there is no competition, but had there been one, I suspect I'd be in lead right now because I've done it. I've done it in a shorter period of time. I'm much newer to advising than both of those, but no, I have a ton of aberration respect both of them. They're phenomenal what they do and I learned a ton from them.

**中文翻译:**
首先，能与他们两位相提并论本身就是一种荣誉。我很敬佩他们，他们是先行者。而且，我把我的起步很大程度上归功于他们，因为当我刚开始考虑做顾问时，他们非常慷慨地抽出时间指导我，尤其是 Casey。如果他们听到这个，我要向他们致敬，特别是 Casey。在慷慨分享时间方面，他真的很了不起。所以，没有竞争，但如果有的话，我怀疑我现在可能处于领先地位，因为我在更短的时间内完成了这些。我做顾问的时间比他们短得多，但我对他们充满敬意。他们在各自的领域都非常出色，我从他们身上学到了很多。

---

### (00:07:24) Lenny

**English:**
I love that acceleration is fastest. Wow, sweet. So we're going to talk a lot about consumer growth strategies and your experience working with companies and a bunch of insights on things you've learned from working with companies. Before we get there just one quick question in your advising. I'm curious how many companies do you work with at once normally?

**中文翻译:**
我喜欢“加速度最快”这个说法。哇，太棒了。我们将深入探讨消费级增长策略、你与公司合作的经验，以及你从中学到的一系列见解。在那之前，关于你的顾问工作，我有一个小问题：你通常同时与多少家公司合作？

---

### (00:07:43) Yuriy Timen

**English:**
Yeah, so I play around with different quantities. So a couple of things. So you mentioned, you alluded to earlier that I advise full time. What I'll say is that mostly the only thing that I do right now professionally is advising, but it's not quite full time. I hard count my week at about three to three and a half days a week worth of work, which is a personal choice. And so that is a hard constraint that I'm working with. And within that constraint, I also feel like for me to do my best work and the work that I also enjoy the most and find the most fulfilling four to five companies is probably the max. If I try to go beyond that, the overhead that it creates in terms of the cost of context switching just becomes overwhelming. I feel like I'm not showing up as best as I can with each individual company.

**中文翻译:**
是的，我会尝试不同的数量。有几点，你刚才提到我是在全职做顾问。我想说的是，虽然目前顾问是我唯一的职业活动，但并不是完全意义上的“全职”。我严格控制每周的工作时间在大约三到三天半，这是个人选择。这是一个硬性约束。在这个约束下，我也觉得为了发挥最佳水平，并做我最喜欢、最有成就感的工作，四到五家公司大概就是极限了。如果超过这个数量，上下文切换（Context Switching）带来的成本就会变得难以承受。我会觉得我无法在每家公司面前都展现出最好的状态。

---

### (00:08:53) Lenny

**English:**
As early plug or anti plug, depending on how you answer this. Are you looking for more companies to work with right now or are you just like, "Don't even try. I am so at capacity right now."?

**中文翻译:**
这算是一个提前的广告（或反向广告），取决于你怎么回答。你现在还在寻找更多的合作公司吗？还是说“别试了，我已经满负荷了”？

---

### (00:08:53) Yuriy Timen

**English:**
I'm so at capacity right now. I've also just been very fortunate to always be at capacity. But I think for every four to five companies that I'm working with, think of it as a concentric circles, right? There are another, maybe 10 to a dozen companies that we're actively exploring if we want to work together in the future. And then there is another concentric circle so maybe 30 plus companies that I'm just friends with. So I'll take the plug. I'm always up for meeting Austin founders working on important problems.

**中文翻译:**
我现在确实满负荷了。我也很幸运一直处于满负荷状态。但我觉得，对于我正在合作的每四到五家公司，可以把它们看作是同心圆，对吧？还有另外大约 10 到 12 家公司，我们正在积极探讨未来合作的可能性。然后还有另一个圈子，大约 30 多家公司，我和他们只是朋友。所以，我接受这个广告机会：我一直很乐意结识那些正在解决重要问题的优秀创始人。

---

### (00:09:31) Lenny

**English:**
Cool. Well, we're in the plug I guess. How do people find you online? What's your Twitter?

**中文翻译:**
酷。那就算是个广告吧。人们怎么在网上找到你？你的 Twitter 是什么？

---

### (00:09:34) Yuriy Timen

**English:**
I mean, honestly, probably throw Lenny's podcast. That's one, but honestly LinkedIn is really the only place I'm pretty low key otherwise.

**中文翻译:**
说实话，可能就是通过 Lenny 的播客。这是一个渠道，但除此之外，LinkedIn 真的是唯一的地方，我平时比较低调。

---

### (00:09:45) Lenny

**English:**
Okay, great. That was a lot of Meta stuff. So let's get into some meat stuff here. So you talked to a lot of consumer startups. You help them figure out how to grow, how to evolve their product, something I'm always curious about and I love your thoughts on is when you look at a consumer startup, I imagine there's a few archetypes of how they grow. I'm curious if that's a mental model you use when you're like, "Oh, I see company X. They're probably going to grow this way, and here's what they should focus on." How do you see that?

**中文翻译:**
好的，太棒了。刚才聊了很多形而上的东西。现在让我们进入实质内容。你接触过很多消费级初创公司，帮助他们弄清楚如何增长、如何演进产品。我一直很好奇并想听听你的看法：当你观察一家消费级初创公司时，我想他们增长的方式应该有几种原型。我很想知道这是否是你使用的一种心智模型，比如当你看到 X 公司时，你会想：“哦，他们可能会以这种方式增长，这是他们应该关注的重点。”你是怎么看的？

---

### (00:10:11) Yuriy Timen

**English:**
Great question. I think there are ways to answer that. My sweet spot is subscription properties and it's not just consumer. I do work with a lot of B2B companies. It's just that most of them, but what they all have in common is they lean into consumerized type of growth loops and growth motions. So they're very kind of self-serve nature or have meaningful self-serve engines. So if I think about subscription companies, I think there are probably a couple of buckets that I see them falling into. If you were able to nail your unit economics and you have really strong consumer LTVs, think Grammarly, think Canva. The single player LTVs for those companies are very, very high. They're kind of average S&B LTVs for B2B companies.

**中文翻译:**
好问题。我觉得有几种回答方式。我的擅长领域是订阅类资产，而且不仅仅是消费级。我也和很多 B2B 公司合作。只是他们中的大多数都有一个共同点，那就是他们倾向于使用“消费化”的增长循环（Growth Loops）和增长动作。所以他们具有很强的自助服务（Self-serve）性质，或者拥有显著的自助服务引擎。如果我思考订阅型公司，我觉得我看到的它们大概可以分为几个类别。如果你能搞定单位经济效益（Unit Economics），并且拥有非常强大的消费者 LTV（终身价值），比如 Grammarly 或 Canva。这些公司的单用户 LTV 非常高，几乎相当于 B2B 公司中普通中小企业（SMB）的 LTV。

---

### (00:11:03) Lenny

**English:**
What's a number there just for folks to have a little context?

**中文翻译:**
能给个具体的数字吗，好让大家有个参考？

---

### (00:11:06) Yuriy Timen

**English:**
I'm not a liberty to speak to those, but we're talking in the hundreds of dollars. Most consumer subscription companies that are $5 to $7 a month. Their LTVs typically cap out at 50 to 60 bucks.

**中文翻译:**
我不便透露具体数字，但我们谈论的是数百美元。大多数每月 5 到 7 美元的消费级订阅公司，其 LTV 通常上限在 50 到 60 美元左右。

---

### (00:11:25) Lenny

**English:**
Cool.

**中文翻译:**
酷。

---

### (00:11:26) Yuriy Timen

**English:**
And so if you have really healthy LTVs, and that usually means that you're attracting a proconsumer buyer, so they may be single player, but they're using it for work. And so maybe they're dispensing it or just the perceived value so much higher that they're willing to bear that $120 and $130 a year subscription. If I'm seeing things like that and I'm seeing that you're converting seven, like five plus percent of your free users to a paid subscriber, then there is a big opportunity to play paid and lean into paid growth loops and paid acquisition loops. There is another archetype, which is if there are network effects for instance, you don't find that as much with single player consumer subscription companies, but obviously social media, consumer companies.

**中文翻译:**
所以，如果你有非常健康的 LTV，这通常意味着你吸引的是“专业消费者”（Prosumer）买家。他们可能是个人用户，但他们将其用于工作。因此，他们可能报销这笔费用，或者仅仅是因为感知价值太高，以至于他们愿意承担每年 120 到 130 美元的订阅费。如果我看到这样的情况，并且看到你将 5% 以上（甚至 7%）的免费用户转化为付费订阅者，那么就有很大的机会去尝试付费渠道，并投入到付费增长循环和付费获客循环中。还有另一种原型，就是如果存在网络效应（Network Effects）。在单人消费级订阅公司中不常见，但在社交媒体和消费级公司中显然存在。

---

### (00:12:17) Yuriy Timen

**English:**
There may be a strong referral viral loop angle if the utility increases, the utility of the product increases, the more users are using it. Another archetype I see are companies that can lead into SEO very heavily, especially if there is a long tail programmatic angle. Take Canva for instance, their biggest initial growth loop and I think this is public knowledge was their long tail SEO strategy where any kind of design project that you could think of would search for designing. It's kind of two categories of keywords, make keywords and template keywords. So if you're searching for a template of any kind, a wedding invitation, yada yada, they had incredibly strong SEO and they were just capitalizing on all the long tail traffic. Not every product is going to lend itself to that, but I always look for that early on, because you can build incredible mold with that kind of strategy.

**中文翻译:**
如果产品的效用随着用户数量的增加而增加，那么可能会有一个强大的推荐病毒循环（Referral Viral Loop）切入点。我看到的另一种原型是那些可以重度依赖 SEO 的公司，特别是如果存在长尾程序化（Long-tail Programmatic）切入点。以 Canva 为例，他们最初最大的增长循环（我认为这是公开的秘密）是他们的长尾 SEO 策略。任何你能想到的设计项目，人们都会搜索。它主要分为两类关键词：“制作”类关键词和“模板”类关键词。所以如果你在搜索任何类型的模板，比如婚礼邀请函等等，他们都有极强的 SEO，并且一直在利用所有的长尾流量。并非每个产品都适合这种方式，但我总是在早期寻找这种机会，因为这种策略可以建立起令人难以置信的护城河。

---

### (00:13:47) Lenny

**English:**
That makes sense. There's kind of like these three engines that you can tap into. I imagine the preference would be word of mouth reality and then if that isn't going to work SEO, and if that is going to work paid, maybe just to simplify it for listeners, what are kind of signals you can go after virality and invest in that and think that could work because every founder would be like, "Yes, virality. That's how I'm going to grow." Yeah.

**中文翻译:**
有道理。这就像是可以利用的三种引擎。我猜首选应该是口碑和病毒式传播，如果行不通就选 SEO，如果那也不行就选付费。为了给听众简化一下，有哪些信号表明你可以追求病毒式传播并对其进行投资，且认为它能奏效？因为每个创始人都想说：“是的，病毒式传播，这就是我要增长的方式。”

---

### (00:13:47) Yuriy Timen

**English:**
Yeah. Honestly, the first thing you look for is that, is there inherent product network effects? It's something that it's either there, or isn't from inception from my experience. I think it's very difficult to manufacture. You'd only study when... It's very hard to manufacture product network effects if they aren't there from the get go. So Airbnb from your days, obviously marketplace very strong product network effect dynamics. You think of collaboration tools, Airtable, monday.com, Whimsical, whom we both know very strong inherent product network effects, contrast that with a company like Grammarly. It just wasn't there. It's not an inherently multiplayer task constructed communication. And so you can try to engineer that, but from my experience, it is an uphill battle. So if you have inherent product network effects, that's when I think layering on referral loops and viral loops. You think about what Dropbox has done around file sharing. That's an iconic example.

**中文翻译:**
是的。老实说，你首先要看的是：是否存在内在的产品网络效应？根据我的经验，这东西要么从一开始就有，要么就没有。我认为很难人为制造。你只能研究……如果从一开始就没有，很难制造出产品网络效应。比如你待过的 Airbnb，显然市场平台具有非常强大的产品网络效应动态。再想想协作工具，Airtable、monday.com、Whimsical（我们都熟悉），它们都有非常强大的内在产品网络效应。相比之下，像 Grammarly 这样的公司，它就不具备这种效应。沟通并不是一种天生的多玩家任务构建。所以你可以尝试去设计它，但根据我的经验，这是一场艰苦的战斗。所以，如果你有内在的产品网络效应，那时我认为可以叠加推荐循环和病毒循环。想想 Dropbox 在文件共享方面所做的，那是一个标志性的例子。

---

### (00:15:02) Yuriy Timen

**English:**
Then it's really powerful. I think that there is another case where referral and viral loops could work even when there are inherent network effects. If you have a really beloved product, beloved brand. There's a company out of Australia that I have opportunity to invest it called Laika. They do fresh dog food subscriptions and incredibly beloved brand, a premium product. And so they're able to lean into a give one, get one referrals, even though there isn't inherent product network effects, they're still able to generate meaningful results off of the, and incentivize referring program.

**中文翻译:**
那真的非常强大。我认为还有另一种情况，即使没有内在的网络效应，推荐和病毒循环也能奏效。那就是如果你有一个深受喜爱的产品和品牌。我曾有机会投资一家名为 Laika 的澳大利亚公司。他们做新鲜狗粮订阅，品牌深受喜爱，产品也很高端。因此，即使没有内在的产品网络效应，他们也能通过“买一赠一”式的推荐计划产生显著的效果，并激励推荐行为。

---

### (00:15:45) Lenny

**English:**
When you talk about network effects, what does that mean to you? How would you define that briefly?

**中文翻译:**
当你谈论网络效应时，它对你意味着什么？你会如何简要定义它？

---

### (00:15:45) Yuriy Timen

**English:**
Yeah, to me, I mean, honestly I define it I think probably a pretty quintessential way, which is for every individual user, the utility that they derive from the product increases the more users there are on the platform. The expanded version of that is in a case of marketplaces. It may not be the bore users broadly speaking, but the more users in the markets that you care about, in the case of collaboration tools, it's not the more users in abstract terms. It's the more users within your team, the more users within your company, right? That correlates with your kind of the rise in your utility curve.

**中文翻译:**
是的，对我来说，老实说，我的定义可能非常经典：对于每一个个体用户来说，随着平台上用户数量的增加，他们从产品中获得的效用也会增加。在市场平台的情况下，它的扩展版本是：广义上可能不是用户越多越好，而是你关心的特定市场中的用户越多越好。在协作工具的情况下，不是抽象意义上的用户越多越好，而是你的团队内、你的公司内的用户越多越好，对吧？这与你效用曲线的上升直接相关。

---

### (00:16:50) Lenny

**English:**
Awesome. So if you have network effects, AKA if the product becomes more useful with more people or there's amazing word of mouth already, or there's collaboration, probably a good sign that you could lean into virality or maybe referrals. What about SEO?

**中文翻译:**
太棒了。所以如果你有网络效应，也就是说如果产品随着人数增多变得更有用，或者已经有了极佳的口碑，或者存在协作性，这可能是一个很好的信号，表明你可以倾向于病毒式传播或推荐。那 SEO 呢？

---

### (00:17:10) Yuriy Timen

**English:**
Oh, that's a good one. It's a very timely question because I actually in a process of helping a couple of my companies figure out if it's the right time to invest in SEO. So I've been sort of a forefront of taking exploratory meetings with agencies and SEO consultants and things like that. I mean, I would say the first thing to figure... I mean, there are a couple of pillars, because obviously we all know that SEO has a different return horizon than say paid acquisition. It's longer out. It's maybe six months is the earliest you can see results. Even then it's going to be a small trickle that compounds over time, if you're successful or you may spend three to six months leaning into an SEO strategy and then realize that it's not going to back out typically at least in historically a company probably isn't like Series B before it starts feeling like it passed a luxury of making these kind of medium to long term investments.

**中文翻译:**
哦，问得好。这是一个非常及时的问题，因为我实际上正在帮助我的几家公司弄清楚现在是否是投资 SEO 的正确时机。所以我一直处于前沿，与代理机构和 SEO 顾问进行探索性会议。我想说，首先要弄清楚的是……这里有几个支柱。因为显然我们都知道，SEO 的回报周期与付费获客不同。它更长。你最早可能在六个月后才能看到结果。即便如此，如果你成功了，起初也只是细水长流，随着时间的推移而产生复利。或者你可能花了三到六个月投入 SEO 策略，然后发现它根本无法收回成本。通常情况下，至少在历史上，一家公司可能要到 B 轮融资之后，才会觉得有余力进行这种中长期的投资。

---

### (00:18:54) Yuriy Timen

**English:**
But I think that's shifting right now, but that's maybe a topic for later or even for another bot but a lot of the strategies that I think we're reserved for Series B are trickling down to Series A companies because they have to diversify way for pay, but maybe more on that later. So I think with SEO, it's like the first pillar I would say is, do you have a unique angle when you take a look at the SEO landscape today, you look at editorial, the landscape, which is to how to searches and who are the players there and what kind of information is being offered? Do you have something unique to contribute to that conversation? Another thing if I have to do an audit checklist, another thing is, do you have a unique programmatic angle, right? For instance, Canva did dealt with templates. Who else is programmatic?

**中文翻译:**
但我认为这种情况现在正在发生变化，这可能是稍后甚至另一个话题，但很多我认为原本属于 B 轮公司的策略正在下沉到 A 轮公司，因为他们必须从付费渠道中实现多样化。不过这可以稍后再谈。所以对于 SEO，我认为第一个支柱是：当你观察今天的 SEO 格局时，你是否有独特的切入点？你观察编辑类内容（Editorial）的格局，即“如何做”类的搜索，谁是那里的玩家，提供了什么样的信息？你是否有独特的东西可以贡献给那个对话？如果我要做一个审计清单，另一件事是：你是否有独特的程序化（Programmatic）切入点？例如，Canva 处理的是模板。还有谁是程序化的？

---

### (00:19:00) Lenny

**English:**
Saint Pier. (Note: Likely referring to Zapier)

**中文翻译:**
Zapier。

---

### (00:19:01) Yuriy Timen

**English:**
Saint Pier, right. So do you have a programmatic angle and then understanding the competitive landscape or the other one is, do you have a unique data angle? So for instance, a company I work with called Monarch Money, which is in the personal finance management space. Think of it as a new and improved version of MIT. There is a lot of users are connecting accounts and you have a sense percenting patterns and things like that. Clearly there is a unique data, and so it's a question of, can you turn it into some kind of valuable organic search experience?

**中文翻译:**
Zapier，没错。所以你是否有程序化的切入点，然后了解竞争格局。或者另一个是：你是否有独特的数据切入点？例如，我合作的一家名为 Monarch Money 的公司，它属于个人财务管理领域。把它想象成 Mint 的升级版。有很多用户连接账户，你可以感知到消费模式之类的信息。显然这里有独特的数据，所以问题在于：你是否能将其转化为某种有价值的自然搜索体验？

---

### (00:19:39) Yuriy Timen

**English:**
I won't go into too much detail in terms of what we're thinking of there, but that's another checkbox. If you can check two of those three boxes as a back of the envelope framework, you may be in good shape. And then it's a question of like, "How can you lower the cost of experimentation SEO as much as possible?" I think as a rule of thumb, if you can time box it to three months, what can I do at the end of three months? Is this likely to work or not?

**中文翻译:**
我不会详细说明我们在那方面的具体想法，但那是另一个勾选项。作为一个粗略的框架，如果你能勾选这三个选项中的两个，那么你的情况可能还不错。然后问题就是：“如何尽可能降低 SEO 实验的成本？”我认为一个经验法则是，如果你能将其时间限制在三个月内，看看三个月结束时我能做到什么？这是否可能奏效？

---

### (00:20:16) Lenny

**English:**
Awesome. Couple follow up questions. One is SEO feels like this dark art where you need some SEO wizard to come help you through this. Do you suggest companies find somebody or work with an agency or something else? What's your general feeling on SEO versus some other route?

**中文翻译:**
太棒了。有几个后续问题。一是 SEO 感觉像是一种“黑魔法”，你需要一些 SEO 大师来帮你。你建议公司找个人，还是和代理机构合作，或者其他方式？你对 SEO 与其他路径相比的总体感觉是什么？

---

### (00:20:33) Yuriy Timen

**English:**
I think SEO is pretty specialized skill set. There are some basic principles that always hold like best content wins and don't do shady back linking and make sure that you're on page. SEO is good and your pages are easily crawl, but I feel like everybody knows that. And where the winners are determined are between the lines. Better than a sports' analogy? Maybe you can.

**中文翻译:**
我认为 SEO 是一项非常专业的技能。有一些基本原则始终适用，比如“内容为王”、不要做阴暗的反向链接、确保你的页面 SEO 良好且易于抓取，但我觉得大家都知道这些。而胜负往往决定在细微之处（Between the lines）。比体育类比更好吗？也许你可以。

---

### (00:21:10) Lenny

**English:**
Between the lines. I don't know what that comes from.

**中文翻译:**
“Between the lines”。我不知道这个词源自哪里。

---

### (00:21:15) Yuriy Timen

**English:**
But anyway, what I mean is that there is a lot of more nuance, SEO developments and angles, where I think is where the opportunity really lies to differentiate yourself. And that requires keeping up with the latest algorithm changes. It's very hard to do that unless you are specializing in the art where the black magic of SEO, and so that's why I think getting an outside resource at least for an audit is really helpful. Now, whether it's a boutique agency or a solo consultant, I think that's more circumstantial, but I've found at least with the companies that I've worked with, if we wanted to quickly vet the SEO opportunity, I can do it in a very kind of amateur, at an amateur level.

**中文翻译:**
但无论如何，我的意思是，SEO 的发展和切入点有很多细微差别，我认为这才是真正能让你脱颖而出的机会所在。这需要紧跟最新的算法变化。除非你专门研究 SEO 的艺术或“黑魔法”，否则很难做到这一点。这就是为什么我认为寻求外部资源（至少进行一次审计）非常有帮助。至于选择精品代理机构还是独立顾问，我认为这取决于具体情况。但我发现，至少在我合作过的公司中，如果我们想快速评估 SEO 机会，我可以以一种非常业余的水平来做。

---

### (00:22:02) Yuriy Timen

**English:**
Plug things into similar web and try to figure out the right option is there, but you can get these relatively inexpensive audits done from companies that you can then choose. Do I hire them to help with my SEO or not? But I think that audit is usually a very good use of time because they have templates. So what they can turn around for five to 10K would take you many, many human hours to try to pull together yourself.

**中文翻译:**
把东西输入 SimilarWeb，试着找出合适的选项，但你可以从一些公司那里获得相对便宜的审计服务，然后你可以选择：我是雇佣他们来帮我做 SEO 还是不雇？但我认为审计通常是非常值得花时间的，因为他们有模板。他们花 5000 到 10000 美元就能搞定的东西，如果你自己去弄，可能需要花费无数的人力工时。

---

### (00:22:35) Lenny

**English:**
Are there agencies that you want to name that people can go check out or would you prefer just to keep it from having-

**中文翻译:**
有没有你想点名的代理机构让大家去了解一下？还是你更愿意保持——

---

### (00:22:37) Yuriy Timen

**English:**
I'll give one plug. I think one of the most innovative, disciplined first principles SEO thinkers and I have met is Ethan Smith from Graphite. It's not for everyone. It's a pretty high end SEO shell. So I wouldn't send the Series a company there, but Ethan also produces a lot of resources and what they've been focusing on at Graphite lately has been actually automating a lot of their work and turning it into SAS. So I don't know how far along they are, but you could probably already get into some of the betas from the tools that they're offering.

**中文翻译:**
我推荐一个。我认为我见过的最创新、最严谨、最坚持第一性原理的 SEO 思想家之一是来自 Graphite 的 Ethan Smith。它并不适合所有人，是一个相当高端的 SEO 机构。所以我不会把 A 轮公司送到那里，但 Ethan 也制作了很多资源。Graphite 最近一直专注于将他们的许多工作自动化，并将其转化为 SaaS 产品。所以我不知道他们进展到什么程度了，但你可能已经可以试用他们提供的一些工具的测试版了。

---

### (00:23:18) Lenny

**English:**
Sweet. I'm going to try to get Ethan on this podcast.

**中文翻译:**
太棒了。我会试着邀请 Ethan 来这个播客。

---

### (00:23:20) Yuriy Timen

**English:**
Yeah.

**中文翻译:**
好的。

---

### (00:23:21) Lenny

**English:**
I've seen his stuff and it's awesome.

**中文翻译:**
我看过他的东西，非常棒。

---

### (00:23:23) Yuriy Timen

**English:**
Yeah. He is a math scientist when it comes to SEO. Yeah.

**中文翻译:**
是的。在 SEO 方面，他简直是个“疯狂科学家”。

---

### (00:23:28) Lenny

**English:**
We need those. We need math scientist on ship. Okay. So we've talked about virality talked about SEO, paid. Imagine that's pretty straightforward if your LTV are high enough and you can pay back ads on those, then that's where you go. Imagine everyone can try it. Doesn't work for everyone. What if yeah, anything you want to add there?

**中文翻译:**
我们需要这样的人。我们需要科学家在船上。好了，我们谈过了病毒式传播，谈过了 SEO，现在谈谈付费。我想如果你的 LTV 足够高，并且能通过广告收回成本，那么这就是你的方向。我想每个人都可以尝试，但并不是对每个人都有效。关于这一点，你有什么想补充的吗？

---

### (00:23:43) Yuriy Timen

**English:**
I mean, there's a lot. There's a lot. I mean, I don't know how deep you want to go down the paid rabbit hole because it's changing. It's probably the most affected growth bucket in light of the market turbulence, the venture sentiment shifting. I've seen paying acquisition strategies at budgets. They are at the brunt of that fallout. And so the question is where do you want to go there?

**中文翻译:**
我是说，这里面有很多内容。我不知道你想在付费这个“兔子洞”里钻多深，因为它正在发生变化。鉴于市场动荡和风投情绪的转变，这可能是受影响最大的增长类别。我看到付费获客策略和预算正处于这种冲击的最前沿。所以问题是，你想往哪个方向聊？

---

### (00:24:16) Lenny

**English:**
Yeah. That's a really good topic. I was saving that for later, but let's chat it better right now.

**中文翻译:**
是的。这是一个非常好的话题。我本来打算留到后面再说，但现在聊聊更好。

---

### (00:24:19) Lenny

**English:**
I imagine part of this is Apple's tracking changes too.

**中文翻译:**
我猜这其中一部分原因也是苹果的追踪政策变化。

---

### (00:24:22) Lenny

**English:**
So I guess my big question is paid still lucrative and a good path for many companies is like 50% of the time less effective. How do you see that shifting recently? And how should people think about paid in the consumer subscription startup?

**中文翻译:**
所以我最大的问题是，付费渠道对许多公司来说是否仍然有利可图且是一条好路径？是不是有一半的时间效果变差了？你如何看待最近的这种转变？消费级订阅初创公司应该如何看待付费渠道？

---

### (00:24:38) Yuriy Timen

**English:**
Well, I think in the short term, let's break it down into phases. I think in the short term paid acquisition and just paid media dollars are contracted and we're seeing it already with Metas advertising revenue, Snaps advertising revenue. There's clearly a global contraction happening to paid media budgets. A big part of it is because all of a sudden the definition of efficient acquisition and good payback windows is shifting. So before for a consumer subscription company, 12 month payback was decent. Now it's like, you better pay back your paid media in six months or less. That's the sentiment.

**中文翻译:**
嗯，我认为短期内，我们可以把它分为几个阶段。短期内，付费获客和付费媒体支出正在收缩，我们已经从 Meta 和 Snap 的广告收入中看到了这一点。付费媒体预算显然正在发生全球性的收缩。很大一部分原因是，突然之间，“高效获客”和“良好回本周期”的定义发生了变化。以前对于一家消费级订阅公司来说，12 个月的回本周期（Payback Window）还算不错。现在，感觉是你最好在 6 个月或更短的时间内收回付费媒体成本。这就是目前的情绪。

---

### (00:25:23) Yuriy Timen

**English:**
So the thought is reaction is like anything that's more than six months we're well board of six months, we're cutting that and so there's that. Then there is just less tolerance for ambiguity and attribution when the sentiment is like, "Let's grow at [inaudible 00:25:38]. Grow at all costs." If you can't attribute things perfectly, that's okay. Now it's like, especially with venture back companies, you have to have two plus years of runway, managers burn a lot more diligently now. And so whatever you can't attribute to sales sue like, "That shits got to go." I don't know if we can curse on the pod or not.

**中文翻译:**
所以现在的反应是，任何超过 6 个月回本的东西，我们都要砍掉。此外，人们对归因（Attribution）模糊性的容忍度也降低了。以前的情绪是“不惜一切代价增长”，如果你不能完美地归因，那也没关系。现在，特别是对于有风投背景的公司，你必须有两年以上的现金流跑道（Runway），管理者现在对资金消耗（Burn）要勤勉得多。因此，任何无法明确归因为销售的东西，就像是：“那玩意儿得滚蛋。”我不知道在播客里能不能说脏话。

---

### (00:25:59) Lenny

**English:**
Only available-

**中文翻译:**
只有在——

---

### (00:026:03) Yuriy Timen

**English:**
Well, I've been holding back for the last 30 minutes. No, I'm kidding.

**中文翻译:**
好吧，过去 30 分钟我一直在克制。不，开玩笑的。

---

### (00:26:03) Lenny

**English:**
At least.

**中文翻译:**
至少。

---

### (00:26:04) Yuriy Timen

**English:**
All right.

**中文翻译:**
好的。

---

### (00:26:05) Lenny

**English:**
We're not kid friendly, but nobody's cursed yet. So this could be okay. So you'll be the first.

**中文翻译:**
我们这节目不是针对儿童的，但目前还没人说过脏话。所以没关系，你可以做第一个。

---

### (00:26:09) Yuriy Timen

**English:**
All right. Way loud. All right. But anyways, yeah. So I think there is a short term contraction. However, that opens up an opportunity for smart kind of attribution investments. So you're seeing an emergence of some interesting attribution related attribution for incrementality related products. A couple that I personally started exploring and looking into, and then you just see a lot more heads of growth, heads of user acquisition, thinking about attribution in building their attribution stacks. And so I think that once we settle into some kind of new normal, which is going to be a combination of just better attribution stack on average for companies combined with just the level of acceptance, that attribution will never be as good as it maybe once was. We're going to probably get hit. Come out of that and you'll see paid budgets start making their way back. But even right now, during contraction, there are going to be some winners.

**中文翻译:**
好吧，大声说出来。无论如何，我认为短期内会有收缩。然而，这为智能归因投资打开了机会。你会看到一些有趣的、与增量性（Incrementality）相关的归因产品出现。我个人也开始探索和研究其中的几个。你会看到更多的增长负责人、用户获取负责人开始思考如何构建他们的归因技术栈（Attribution Stacks）。我认为，一旦我们进入某种“新常态”——即公司平均拥有更好的归因技术栈，同时接受归因永远不会像以前那样完美——我们可能会经历一段冲击，然后你会看到付费预算开始回升。但即使是现在，在收缩期间，也会有一些赢家。

---

### (00:27:26) Yuriy Timen

**English:**
The companies that had strong cash positions, have strong unit economics, strong paid back periods already like Grammarly, Canva to name two that I know personally. A couple of others or many others probably, they're going to be winners because all of a sudden, if previously they were competing with companies who were nowhere as efficient as them, but for whatever reason had the green light to keep spending, now all of those are going to pull back their budgets. And so those that have been disciplined, have the instrumentation to track things better than average. They're going to benefit from decreased competition on app platforms, decreasing CPMs, et cetera. So they're going to do winners for sure.

**中文翻译:**
那些拥有强大现金头寸、强大单位经济效益和良好回本周期的公司，比如我个人了解的 Grammarly 和 Canva。可能还有其他很多公司，他们将成为赢家。因为突然之间，如果以前他们是在与那些效率远不如他们、但出于某种原因获准继续砸钱的公司竞争，现在那些公司都会削减预算。因此，那些一直保持克律、拥有比平均水平更好的追踪手段的公司，将从广告平台竞争减少、CPM（千次展示成本）下降中受益。所以他们肯定会成为赢家。

---

### (00:28:09) Lenny

**English:**
Wow. Haven't heard this perspective. It's so interesting that the fact that it's gotten harder, it's creating new opportunities for companies to do it better and more intelligently. You said you mentioned a couple tools products that you found to be potentially helpful in this. Is there anything you could mention there?

**中文翻译:**
哇。还没听过这个观点。很有趣，环境变难了，反而为那些做得更好、更智能的公司创造了新机会。你刚才提到了一些可能在这方面有帮助的工具或产品，能具体说说吗？

---

### (00:28:22) Yuriy Timen

**English:**
Yeah. Yeah. I mentioned a couple that I've kind of connected with in the last couple of months. So first of all, Media Mix Modeling is making a comeback, which is something that kind of got popularized in the math meant kind of advertising era of the fifties, pre-digital, and that's how that was the piece of the methodology. I can't speak of the specifics there. The science is a little bit out of depth there, but it was basically a way to use some data to determine a budget allocation across channels at the time was probably newspapers and billboards, et etcetera.

**中文翻译:**
是的。我提到了几个过去几个月接触过的。首先，媒介组合模型（Media Mix Modeling, MMM）正在卷土重来。这在 50 年代前数字化时代的广告界非常流行。我无法详述细节，那里的科学原理有点深奥，但它基本上是一种利用数据来确定跨渠道预算分配的方法，当时可能主要是报纸和广告牌等等。

---

### (00:29:03) Yuriy Timen

**English:**
It was leveraging data to some extent. You would were doing it maybe on a quarterly basis. And then you would only update it every quarter. There was no way with media mix modeling. There was no way to adjust budget in quarter because you weren't getting the data feedback loop that frequently. But media mix modeling is now making a comeback because there are so many offline channels that are part of folks channel portfolio today and that plus a lot of the online channels are becoming less trackable like Meta for instance, with the iOS 14 shift. And so Media Mix Modeling is going to comeback and the company that's leading the charge of bringing the Media Mix Modeling methodology of the traditional advertising era and ushering it into the digital world is a company called the Recast.

**中文翻译:**
它在某种程度上利用了数据。你可能每季度做一次，然后每季度更新一次。使用传统的媒介组合模型，你无法在季度内调整预算，因为你获得数据反馈循环的频率没那么高。但媒介组合模型现在正在回归，因为今天人们的渠道组合中有很多线下渠道，加上很多线上渠道变得越来越难以追踪（比如受 iOS 14 变化影响的 Meta）。因此，媒介组合模型将会回归，而引领这一趋势、将传统广告时代的 MMM 方法论引入数字世界的公司是一家名为 Recast 的公司。

---

### (00:29:48) Lenny

**English:**
Recast.

**中文翻译:**
Recast。

---

### (00:29:48) Yuriy Timen

**English:**
Recast. Yeah. So I've heard really good things. I haven't tried them with any of my companies yet, but there are a couple that are on the horizon hopefully.

**中文翻译:**
Recast，没错。我听到了很多好评。我还没在我的任何合作公司中尝试过，但希望很快会有几家开始尝试。

---

### (00:29:58) Lenny

**English:**
Double click there for a moment. Is that still useful if you're not doing TV and other forms of advertising?

**中文翻译:**
深入探讨一下。如果你不做电视或其他形式的广告，这东西还有用吗？

---

### (00:30:04) Yuriy Timen

**English:**
I think it's still-

**中文翻译:**
我认为仍然——

---

### (00:30:04) Lenny

**English:**
You're just doing-

**中文翻译:**
你只是在做——

---

### (00:30:04) Yuriy Timen

**English:**
Yeah, I think it's useful if you're spending a considerable amount, what's considerable, I'd say worth of a hundred thousand a month update media. And if you have some level of channel complexity, so you're not just like a Google Go or a Facebook, but maybe you're on three plus the channels. Then I think it still makes sense. The other ones in the incremental space, they have very different methodologists actually, because at end of the day, this might be obvious to folks, but maybe some will find value.

**中文翻译:**
是的，我认为如果你每月的媒体支出达到一定规模（比如每月 10 万美元以上），它就是有用的。而且如果你有一定的渠道复杂性，比如你不只是投 Google 或 Facebook，而是投了三个以上的渠道，那么我认为它仍然有意义。其他在增量性（Incrementality）领域的公司实际上有非常不同的方法论，因为归根结底，这对某些人来说可能显而易见，但也许有些人会发现其价值。

---

### (00:30:34) Yuriy Timen

**English:**
Click based attribution or the digital attribution were all fawning over cookie based and click based, a real parameter based attribution. It never demonstrated a causal relationship between our media spend and business results. It was only good for correlative insights. And the only way to determine causality is through real controlled experiments, randomized control experiments through incrementality testing, which is typically really hard to do cleanly and also companies have always been often wary about doing it because you have to turn off a channel potentially in a key demo and you're like, "Yeah." The benefit is to learning of whether it's actually incremental, but the cost or the sales that I will lose today. But the only way to really know how effective your paid media is through ongoing incrementality testing. So there are two companies that are addressing that. Two that I'm excited about. One is measured, can be found, measured.call, amazing domain name.

**中文翻译:**
基于点击的归因或数字归因，大家都曾迷恋基于 Cookie 和点击的、基于真实参数的归因。但它从未证明过我们的媒体支出与业务结果之间的因果关系。它只对相关性见解有用。而确定因果关系的唯一方法是通过真实的受控实验，即通过增量性测试进行的随机对照实验。这通常很难做得干净利落，而且公司往往对这样做持谨慎态度，因为你可能需要关闭某个关键受众群体的渠道，你会想：“好处是能学到它是否真的有增量，但代价是我今天会损失销售额。”但真正了解付费媒体效果的唯一方法是进行持续的增量性测试。有两家公司正在解决这个问题，我对此很兴奋。一个是 Measured，可以在 measured.com 找到，域名很棒。

---

### (00:31:44) Lenny

**English:**
Amazing domain name, go with that.

**中文翻译:**
很棒的域名，继续。

---

### (00:31:45) Yuriy Timen

**English:**
And then the other one is incremental, but incremental-

**中文翻译:**
另一个是 Incremental，但是 Incremental——

---

### (00:31:50) Lenny

**English:**
Outcome.

**中文翻译:**
Outcome。

---

### (00:31:51) Yuriy Timen

**English:**
... no vows except the last A between the T and the L.

**中文翻译:**
……除了 T 和 L 之间的最后一个 A 之外，没有元音。

---

### (00:31:57) Lenny

**English:**
Excellent, great job.

**中文翻译:**
太棒了，干得好。

---

### (00:31:58) Yuriy Timen

**English:**
So many free plugs today.

**中文翻译:**
今天做了这么多免费广告。

---

### (00:32:00) Lenny

**English:**
Yeah. I love it. That's great. This is what people need. They're just like, "Okay, what do I actually do"? And so the more it's clear what to actually try and how to solve these problems. The more people can actually make change. I had a couple questions here that I wanted to follow up on. One is founders might be listening to this and they're like, "Amazing. Okay, we're going to grow. There's three ways to grow. Let's do it all. Get someone on SEO to get Jane on paid. Let's get Fred on virality."

**中文翻译:**
是的，我喜欢。这很好。这就是人们需要的。他们会想：“好吧，我到底该怎么做？”所以，越清楚该尝试什么以及如何解决这些问题，人们就越能真正做出改变。我有几个问题想跟进。一是创始人听了这些可能会想：“太棒了。好，我们要增长。有三种增长方式，让我们全做。找个人做 SEO，让 Jane 负责付费，让 Fred 负责病毒式传播。”

---

### (00:32:32) Yuriy Timen

**English:**
Yeah.

**中文翻译:**
是的。

---

### (00:32:32) Lenny

**English:**
So in your experience, is it smart to focus on one and then expand down the road or try them all see which one works best? How do you advise companies think about these options?

**中文翻译:**
那么根据你的经验，是先专注于一个然后逐步扩展比较聪明，还是全部尝试看看哪个效果最好？你如何建议公司思考这些选择？

---

### (00:32:44) Yuriy Timen

**English:**
I would say focus paired with rapid iterations, right? With limited resources. Naturally you have to practice some form of essentialism and ruthless prioritization, but at the same time, the clock is always ticking. You can not burn. That there is a finite number of tries that you have at finding what works, right? What's going to help you unlock the next level of growth, get to the next funding round, extend your runway. And so I think either one taking to an extreme focus or trying multiple things is not a good thing. And just in case, it's not obvious if you focus on one thing and it ends up being the wrong thing, you've wasted really valuable time and now you have so much less time left to find something that does work. Spreading yourself very thin oftentimes in the early stage companies, it's one person who's in charge of all of growth, but they also have some other kind of responsibilities like maybe ops and customer success.

**中文翻译:**
我会说，专注配合快速迭代，对吧？在资源有限的情况下，你自然必须实践某种形式的“精要主义”（Essentialism）和无情的优先级排序。但与此同时，时钟一直在滴答作响。你不能白白烧钱。你寻找有效方法的尝试次数是有限的，对吧？什么能帮你开启下一阶段的增长、进入下一轮融资、延长你的现金流跑道？所以我认为，无论是极端专注还是尝试太多事情都不是好事。万一不明显的话：如果你专注于一件事，结果证明那是错的，你就浪费了极其宝贵的时间，现在你寻找有效方法的时间就更少了。在早期公司，精力分散是很常见的，通常是一个人负责所有的增长，但他们还有其他职责，比如运营和客户成功。

---

### (00:33:54) Yuriy Timen

**English:**
If you get them to try five different things, they may not try them anyone individually fully enough, because I like to say the only thing that's worse than a channel or a tactic that you tried not working. The only thing that's worse now is when you didn't give it the appropriate shot and you pretty much surely or erroneously concluded that it doesn't work. And it's remarkable how often you find that to be the case when I talk to companies, "Oh, YouTube, we tried it doesn't work." I'm like, "Okay, can I see what you've tried?" And then you look at it and you're like, "Oh, this thing was not designed to even have a shot at working from the get go." So to answer your question, I think it's focus with some guard rails so that you know exactly when it's time to move on to the next thing.

**中文翻译:**
如果你让他们尝试五种不同的事情，他们可能无法对其中任何一个进行充分的尝试。因为我常说，比你尝试的渠道或策略不起作用更糟糕的唯一一件事，就是你没有给它一个合适的机会，就过早或错误地断定它行不通。当我与公司交流时，发现这种情况发生的频率高得惊人。“哦，YouTube，我们试过了，没用。”我会说：“好，能让我看看你们尝试了什么吗？”然后你一看，就会发现：“哦，这东西从一开始就不是为了能起作用而设计的。”所以回答你的问题，我认为是带有“护栏”（Guard Rails）的专注，这样你就清楚地知道什么时候该转向下一件事。

---

### (00:34:51) Lenny

**English:**
This episode is brought to you by Eppo. Eppo is a next generation A/B Testing platform built by Airbnb alums for Modern Growth Teams. Companies like Netlify, Contentful, and Cameo rely on Eppo to power their experiments. Wherever you work, running experiments is increasingly essential, but there are no commercial tools that integrate with a modern grow team stack. This leads to waste of time building internal tools or trying to run your experiments through a clunky marketing tool.

**中文翻译:**
本集节目由 Eppo 赞助。Eppo 是由 Airbnb 校友为现代增长团队打造的下一代 A/B 测试平台。Netlify、Contentful 和 Cameo 等公司都依赖 Eppo 来支持他们的实验。无论你在哪里工作，运行实验都变得越来越重要，但目前还没有商业工具能与现代增长团队的技术栈集成。这导致人们浪费时间构建内部工具，或者试图通过笨重的营销工具来运行实验。

---

### (00:35:21) Lenny

**English:**
When I was at Airbnb, one of the things that I love about our experimentation platform was being able to easily slice results by device, by country, and by user stage. Eppo does all that and more. Delivering results quickly, avoiding annoying prolonged analytics cycles and helping you easily get to the root cause of any issue you discover. Eppo lets you go beyond basic click-through metrics and instead you turn north star metrics like activation, retention, subscriptions and payments. Eppo supports test on the front end, the back end, email marketing and even machine learning clients. Check out Eppo at geteppo.com. Geteppo.com and 10X your experiment velocity.

**中文翻译:**
当我在 Airbnb 时，我最喜欢我们的实验平台的一点是，能够轻松地按设备、国家和用户阶段对结果进行切片分析。Eppo 也能做到这些，甚至更多。它能快速交付结果，避免恼人的漫长分析周期，并帮助你轻松找到发现的任何问题的根本原因。Eppo 让你超越基本的点击率指标，转而关注激活、留存、订阅和支付等北极星指标。Eppo 支持前端、后端、电子邮件营销甚至机器学习客户端的测试。请访问 geteppo.com 查看 Eppo。访问 geteppo.com，让你的实验速度提升 10 倍。

---

### (00:36:01) Lenny

**English:**
This might be too hard to answer in a chat like this, but do you have any guidance for how to know when you've gone far enough? I imagine there's a lot nuance and detail there. Is there anything that you could share?

**中文翻译:**
在这样的聊天中，这可能很难回答，但你有没有什么指导建议，告诉我们如何知道什么时候已经尝试得足够多了？我想这其中有很多细微差别和细节。有什么可以分享的吗？

---

### (00:36:12) Yuriy Timen

**English:**
Love the question. It's very thought provoking. I think with some tactics and some channels you can fairly objectively create some test guard rails where it's like, if it's YouTube, we know kind of minimum number of impressions that you got to get. Try two to three creative angles. Here's the click through rates range that you're looking for. If you get within these ranges on these KPIs, keep going. If you don't, abandon.

**中文翻译:**
很喜欢这个问题，非常发人深省。我认为对于某些策略和渠道，你可以相当客观地创建一些测试“护栏”。比如 YouTube，我们知道你必须获得的最少展示次数。尝试两到三个创意角度。这是你期望的点击率范围。如果你在这些 KPI 上达到了这些范围，就继续；如果没有，就放弃。

---

### (00:36:48) Yuriy Timen

**English:**
I think that's important to also know that abandonment doesn't mean we will never revisit it again, right? It just means that because every time you're evaluating, the concept of sunk cost. So you have these periodic, I think periods of reevaluation where it's like, "Okay, did we try enough? Is this more art than science frankly." It's like, "What's the incremental lift for us as a team to try to experiment with the next phase of this channel or this tactic? What is the opportunity cost of that? What are the other high profile things that we could be trying?" You were right and save this topic too hard to answer in this format, but I would break things down maybe into two types. There are some channels or tactics where you can objectively figure out som guard rails for when it's showing promise or not, because you can pull benchmarks on good click through rates and things like that. Then there are other tactics where you just have to exercise more judgment outside of benchmarks.

**中文翻译:**
我认为同样重要的是要明白，放弃并不意味着我们永远不会再尝试，对吧？这只是因为每次评估时都要考虑沉没成本（Sunk Cost）。所以会有周期性的重新评估期，你会想：“好吧，我们尝试得够多了吗？坦白说，这更多是艺术还是科学？”比如：“我们团队尝试实验这个渠道或策略的下一阶段，能带来多少增量提升？其机会成本是多少？我们还可以尝试哪些其他高价值的事情？”你说得对，这个话题在这种形式下很难回答，但我可能会将其分为两类。有些渠道或策略你可以客观地制定一些护栏，判断它是否有前景，因为你可以参考良好点击率之类的基准（Benchmarks）。而对于其他策略，你必须在基准之外运用更多的判断力。

---

### (00:37:54) Lenny

**English:**
Yeah. Yeah. That was actually really valuable and very challenging question to try to summarize quickly so thank you. One more quick question along these lines. So you talked about these three broad ways companies grow. Oftentimes a couple of them work, something I've seen and I'm curious if you agree, usually one is like 80% of your growth and then you layer on a couple more to optimize. Is that what you see?

**中文翻译:**
是的。这确实非常有价值，而且是一个很难快速总结的挑战性问题，谢谢。沿着这个思路再问一个小问题。你谈到了公司增长的三种主要方式。通常其中一两个会起作用。我观察到的一点是（我也很好奇你是否同意），通常其中一个占了增长的 80%，然后你再叠加几个来优化。你看到的是这样吗？

---

### (00:38:18) Yuriy Timen

**English:**
Yes. I think companies that we know and admire and reference in case studies or in podcast, such as this one. From the outside looking in, you oftentimes assume that it's a highly diversified growth engine. I have to say it's often not the case. Definitely the 80/20 applies. There is a kind of strategy that's working overwhelmingly well, and there is a scramble internally to minimize reliance on that one thing. And on the discover slash on the walk, the next step function, the next growth horizon. In the case of Grammarly, it was performance marketing kind of over reliance on performance marketing during part of the company's life cycle. And so it was like, "Okay, this thing is working." It's efficient so you don't want to stop pouring fire on it, but you're also thinking months and years ahead, what kind of risk does it open you up to?

**中文翻译:**
是的。我认为那些我们熟知、钦佩并在案例研究或此类播客中引用的公司，从外部看，你经常会假设它有一个高度多样化的增长引擎。但我必须说，事实往往并非如此。80/20 法则绝对适用。通常有一种策略效果极好，而内部则在忙于减少对这一种方式的依赖，并探索下一个阶梯式增长点、下一个增长地平线。以 Grammarly 为例，在公司生命周期的某个阶段，是效果营销（Performance Marketing），甚至有点过度依赖。当时的情况是：“好吧，这东西有效。”它很高效，所以你不想停止投入，但你也会思考未来几个月和几年，这会给你带来什么样的风险？

---

### (00:39:35) Yuriy Timen

**English:**
And so there is a scramble to fight and at Grammarly, it's been successful there. With Canva, it was the SEO angle. So for them, that was working really well, which is more defensible than paid. That's sort of long tail programmatic SEO angle, but look, you're always susceptible to Google algorithm updates and so how do you derisk yourself from that? But to your point, yes. And I think that surprising thing to people probably is that it's also the case with some later stage companies. It's not just early stage companies that are kind of one trick pulleys. Sometimes it's later stage companies as well.

**中文翻译:**
所以大家会努力去突破，在 Grammarly，这方面做得很成功。对于 Canva，则是 SEO 角度。对他们来说，SEO 效果非常好，而且比付费渠道更具防御性。那是某种长尾程序化 SEO 的角度，但你看，你总是容易受到 Google 算法更新的影响，那么你如何降低这种风险呢？但就你的观点而言，是的。我认为让人们感到惊讶的可能是，一些后期阶段的公司也是如此。不仅仅是早期公司只有“三板斧”，有时后期公司也是一样。

---

### (00:40:11) Lenny

**English:**
This makes me think about is there's kind of these three phases to growth. There's the kickstart phase where you're just doing a bunch of stuff, trying to get things moving. Then there's that you discover your first main growth engine and then there's layer on additional engines because you want to diversify.

**中文翻译:**
这让我想到增长大概有三个阶段。首先是启动阶段，你只是做一堆事情，试图让事情运转起来。然后是你发现了你的第一个主要增长引擎。最后是叠加额外的引擎，因为你想要实现多样化。

---

### (00:40:25) Yuriy Timen

**English:**
Yep. And one interesting, what I believe is an interesting period and a lot of it is gut feel, right? And I try to direct companies. I encounter sometimes early stage companies is when one thing is working well and they're already worried about over reliance and they're starting to talk about diversification and I come in all the times and I see showing up in their OKRs. I come, "No, no. Too early. I'm glad that you're such a forward thinker. Put all of your energy. Sure, this one tactic is accounting for say 80 plus percent of your new user acquisition, but your user acquisition is still small. So don't get distracted with diversification. We'll get there. Lean more into this, hit this growth rates, stand this up. Build this into a real strategic advantages thing that's working."

**中文翻译:**
没错。一个有趣的时期（很大程度上凭直觉）是我有时会遇到一些早期公司，当一件事进展顺利时，他们就已经开始担心过度依赖，并开始谈论多样化。我经常看到这出现在他们的 OKR 中。我会说：“不，不，太早了。我很高兴你这么有远见。但请把所有精力都放在这上面。当然，这一种策略占了你新用户获取的 80% 以上，但你的用户获取总量仍然很小。所以不要被多样化分散注意力。我们会达到那个阶段的。现在要加大投入，达到这个增长率，把它建立起来。把这个有效的东西打造成真正的战略优势。”

---

### (00:41:17) Yuriy Timen

**English:**
So I actually have to talk them out, focusing on diversification too early. Contrast that with some later stage companies for who are... At scale, I know 50 plus million ARR, 90 plus percent reliant on a single acquisition channel, which just mire with risk and diversification is a blind spot for them. And then with those, I have to be like, "Hey y'all. Here's the risk that you're carrying. Let's start carving out bandwidth resources to try to go and explore these other channels with tactics."

**中文翻译:**
所以我实际上不得不劝说他们不要过早关注多样化。相比之下，一些后期公司……在规模上，我知道有些公司 ARR（年度经常性收入）超过 5000 万美元，但 90% 以上依赖于单一获客渠道，这充满了风险，而多样化对他们来说是一个盲点。对于这些公司，我必须说：“嘿，各位，这是你们承担的风险。让我们开始划出带宽和资源，去尝试探索其他渠道和策略。”

---

### (00:41:49) Lenny

**English:**
That's such an important point. It reminds me Casey has this hilarious line that he uses that the money's always in the banana stand or there's always more money in the banana stand from [inaudible 00:41:59] development. That basically your growth is probably going to come from the same place it's already come from.

**中文翻译:**
这是一个非常重要的观点。这让我想起 Casey 有句很搞笑的话，他引用《发展受阻》（Arrested Development）里的台词说“钱总是在香蕉摊里”（The money's always in the banana stand）。意思基本上是，你的增长很可能仍然来自它已经产生的地方。

---

### (00:42:03) Yuriy Timen

**English:**
Yep.

**中文翻译:**
没错。

---

### (00:42:04) Lenny

**English:**
And that you shouldn't take that for granted. And you should put most of your efforts into continuing to optimize that versus being distracted by, "Oh, let's do SEO now."

**中文翻译:**
你不应该认为那是理所当然的。你应该把大部分精力放在继续优化它上，而不是被“哦，让我们现在做 SEO 吧”之类的事情分散注意力。

---

### (00:42:11) Yuriy Timen

**English:**
I see that argument for sure.

**中文翻译:**
我完全理解那个论点。

---

### (00:42:13) Lenny

**English:**
So you mentioned at this point about how later stage growth strategies are starting to move earlier into growth strategy planning. I'd love to hear more on that.

**中文翻译:**
你刚才提到，后期增长策略现在开始提前进入早期增长策略规划中。我很想听听更多关于这方面的内容。

---

### (00:42:22) Yuriy Timen

**English:**
Yeah. Let me expand on that in the world that we lived in last 18 months, or let's say up until say three to five months ago. We were living in a world where funding was abundant and plentiful, startups were conditions to think that they could raise twice a year. Valuations were quite toppling within a year. You raise in January and then you raise in November and your valuation five X. And so companies were coming off of these ridiculous Series As of 15 to 25 million dollar As and they were like, "We got to grow as quickly as possible. What can we activate to give us immediate return?" And the answer is almost always paid. That one going to give you, especially if you're think you want to go back to raising less than 12 months later, that forces you to focus on very kind of short term tactics, short payoff tactics.

**中文翻译:**
是的。让我详细说明一下。在过去 18 个月，或者说到三五个月前，我们生活在一个资金极其充裕的世界。初创公司习惯于认为他们一年可以融资两次。估值在一年内翻天覆地。你 1 月份融资，11 月份再融，估值就翻了 5 倍。所以公司在拿到 1500 万到 2500 万美元这种离谱的 A 轮融资后，会想：“我们必须尽快增长。我们能启动什么来获得即时回报？”答案几乎总是付费渠道。那会给你回报，特别是如果你打算在不到 12 个月内再次融资，这会迫使你专注于非常短期的策略和短期见效的策略。

---

### (00:43:28) Yuriy Timen

**English:**
And so things that SEO, there was no room to think about that for early stage companies. Because payoff is going to come maybe in 12 months in terms of meaningful payoff. We care about getting to the next round and maximizing our valuation between now and then. SEO is for the grown up companies. When we're that we could think about it. And they were getting the reinforcement from everywhere, from peers, from VCs. It's like it's growth, growth, growth. The growth at any cause.

**中文翻译:**
因此，对于早期公司来说，根本没有空间去考虑 SEO 之类的事情。因为有意义的回报可能要 12 个月后才会到来。我们关心的是进入下一轮融资，并在那之前最大化我们的估值。SEO 是给“成年”公司做的，等我们长大了再考虑。而且他们从各处得到这种强化——来自同行，来自风投。就像是“增长、增长、增长”，不惜一切代价的增长。

---

### (00:44:02) Yuriy Timen

**English:**
I think what happened now and we'll see where things stabilized because I think we're still in the midst of a little bit of chaos. What's happening now is the same VCs are saying, "Okay, it's now survival." You have to extend your runway, minimize burn, high burning if you have to. And all of a sudden growth, whether explicitly or via inference becomes kind of a secondary objective, especially for all these companies that are far from being cash flow positive. They have to figure out how to stay alive, but not have to go back to the market and be sort of a victim of shitty terms. And so I feel this is me extrapolating because venture capitalist didn't actually tell me this, but I'm extrapolating that growth is a secondary objective now. It's really focusing on sustainability due to economics, accepting your runway control your destiny, getting to default life.

**中文翻译:**
我认为现在发生的情况（我们将看看局势会在哪里稳定下来，因为我认为我们仍处于一点混乱之中）是，同样的一批风投现在在说：“好吧，现在是生存模式。”你必须延长现金流跑道，减少支出，必要时停止招聘。突然之间，增长（无论是明确的还是暗示的）变成了次要目标，特别是对于那些远未实现现金流正向的公司。他们必须弄清楚如何活下去，而不必回到市场并成为糟糕条款的受害者。我觉得这是我的推断，因为风投并没有真的告诉我这些，但我推断增长现在是次要目标。现在的重点是单位经济效益的可持续性，控制自己的现金流跑道，掌控自己的命运，达到“默认存活”（Default Alive）的状态。

---

### (00:45:00) Yuriy Timen

**English:**
And all of a sudden it's like, "Okay. Plus paid is a lot less attractive now. Can't afford to be acquiring users at like LTV cap one to one." That's now a no-no. And so SEO is now becoming more attractive because once you got your burn under control and you're thinking, "Okay, we saved all this money by reducing our paid budget. We're cutting it entirely. How do we put some of those resources back to work?" And all of a sudden SEO starts looking a lot more lucrative because it's almost like you took the urgency of grow at any cost in the next six months, you took that out of the equation. So now it's like we're in a position where we don't have to go back to raising 12, 18, 24 months. We have 18, 24 months worth of runway and now companies are starting to think more in terms of building more sort of sustainable and defensible growth initiatives.

**中文翻译:**
突然之间，“好吧，加上付费渠道现在吸引力大减。我们负担不起以 1:1 的 LTV 比例获取用户了。”这现在是禁忌。因此，SEO 现在变得更有吸引力，因为一旦你控制了支出，你会想：“好吧，我们通过削减付费预算省下了这么多钱。我们完全砍掉了它。我们如何让这些资源重新发挥作用？”突然间，SEO 看起来更有利可图了，因为你把“未来六个月不惜代价增长”的紧迫感从等式中剔除了。所以现在的情况是，我们不需要在 12、18 或 24 个月内再次融资，我们有 18 到 24 个月的跑道，现在公司开始更多地考虑建立更具可持续性和防御性的增长计划。

---

### (00:46:02) Lenny

**English:**
Fascinating. And as much as people may want to do SEO, like we talked about earlier, doesn't mean they will be able to pull it off because there's these things that have to be approved for your type of company and-

**中文翻译:**
引人入胜。尽管人们可能想做 SEO，就像我们之前谈到的，并不意味着他们一定能成功，因为有些事情必须符合你的公司类型，并且——

---

### (00:46:12) Yuriy Timen

**English:**
Yes.

**中文翻译:**
是的。

---

### (00:46:12) Lenny

**English:**
Yeah. Going back to point you made earlier about paid being a really interesting opportunity right now because it's become harder. Would you say generally you're kind of like pro, tri paid, go paid be in this time because I'm finding a lot of startups are like, "Oh, we can't do paid anymore. We're trying all these other approaches to grow." Is that like alpha right now? Start thinking about paid in a creative way and maybe this is going to be a huge advantage.

**中文翻译:**
是的。回到你之前提到的观点，即付费渠道现在是一个非常有趣的机会，因为它变得更难了。你会说你总体上是支持在这个时期尝试付费渠道的吗？因为我发现很多初创公司都在说：“哦，我们不能再做付费了，我们正在尝试所有这些其他的增长方法。”这在现在算是一种“超额收益”（Alpha）机会吗？开始以创造性的方式思考付费渠道，也许这会成为一个巨大的优势。

---

### (00:46:35) Yuriy Timen

**English:**
So there are two pieces to do paid. I mean I'm oversimplifying, but I think people will hopefully appreciate the over the oversimplification. Number one, because it actually drives returns at efficient unit economic, whatever that may mean for your company, your business, your industry. The other way to do it is because it's a very quick way to get learnings on messaging and positioning on designs on features. You're thinking of launching et cetera, right? It's hard to get faster learnings at scale than A/B testing headlines, Google search or whatever. I think the problem that I find is when a company can't have which camper in or where they try to say that they're in both, but really it's like, "Okay, you're funneling a hundred K a month." It's super inefficient and they're not even running experiments to actually get the learnings. I can assess the company, even if I don't download the industry as well, based on just seeing their funnel performance, their conversion rates, their retention curves, their LTDs, understanding their churn.

**中文翻译:**
做付费渠道有两个组成部分。我是说我在过度简化，但我希望大家能理解这种简化。第一，因为它确实能在高效的单位经济效益下带来回报（无论这对你的公司、业务或行业意味着什么）。另一种方式是，它是获取关于消息传递、定位、设计或你打算推出的功能等方面的反馈的一种非常快速的方式，对吧？很难有比在 Google 搜索或其他平台上进行大规模 A/B 测试标题更快的学习方式了。我认为我发现的问题是，当一家公司不知道自己属于哪个阵营，或者他们试图说自己两者兼顾，但实际上是：“好吧，你每月投入 10 万美元。”这超级低效，而且他们甚至没有运行实验来真正获取学习成果。即使我不了解那个行业，我也能通过观察他们的漏斗表现、转化率、留存曲线、LTV 以及了解他们的流失率来评估这家公司。

---

### (00:47:43) Yuriy Timen

**English:**
I could say whether they stand the chance at making paid work as a former strategy. So not just the learning mechanism, not just the kind of a feedback engine, but actually a profitable at delivering acquisition channel or strategy. And if I see that they're not there because the funnel doesn't convert well, the users don't retain the LTDs are too low. Then I say, "Hey, it's not time for paid. Maybe car on a little bit of budget if you want to quickly test positioning and things like that. But it's just too soon." But instead I encounter a company that's really healthy conversion rates, strong LTDs. I do a little bit of competitor research and I can see where the opportunities are, which channels are less saturated than others. Then I may say, "Hey, it's worth it. It's worth a go." And also just seeing the bigger picture of their financial health, how much runway do you have? What does your monthly burn look like?

**中文翻译:**
我可以判断他们是否有机会让付费渠道成为一种正式策略。所以不仅仅是作为一种学习机制或反馈引擎，而是作为一个真正能盈利的获客渠道或策略。如果我看到他们还没达到那个水平，因为漏斗转化不好，用户留存不住，LTV 太低，那么我会说：“嘿，现在还不是做付费的时候。如果你想快速测试定位之类的内容，也许可以留一点点预算，但现在真的太早了。”但相反，如果我遇到一家转化率非常健康、LTV 强大的公司，我会做一点竞争对手研究，看看机会在哪里，哪些渠道比其他渠道更不饱和。然后我可能会说：“嘿，值得一试。”同时也要看他们财务状况的大局：你有多少现金流跑道？你每月的资金消耗是多少？

---

### (00:48:41) Lenny

**English:**
Right? Because paids like cash going out the door and it will return hopefully at some point might be six months might be a year, and so that's a real constraint. You mentioned onboarding and funnel conversion. Two questions there. One, do you have a heuristic of here's good for conversion rates? Is there something that you think about there that you could share or is it very case dependent?

**中文翻译:**
对吧？因为付费就像现金流出门外，希望它能在某个时间点回来，可能是六个月，也可能是一年，所以这是一个真实的约束。你提到了入职引导和漏斗转化。有两个问题。第一，你有没有关于“什么是好的转化率”的经验法则？有没有什么你可以分享的思考，还是说这非常取决于具体情况？

---

### (00:49:03) Yuriy Timen

**English:**
I think it's case dependent, but yeah, it is. It's not case dependent. It's category dependent. So it's not that every company is so case, but it's like, we got to know about what buckets we're talking about. I will say that... Let's say we talk about prosumer premium SAS, ala Grammarly, ala Canva, Whimsical, InVideo, things like that. Yeah. I can confidently say a healthy website visit to a free user, a free account creation conversion rate. It's probably in that 20 to 35% range.

**中文翻译:**
我认为这取决于具体情况，但也不完全是。它是取决于类别的。并不是每家公司都完全不同，但我们得知道我们在讨论哪个范畴。我会说……假设我们讨论的是“专业消费者”高端 SaaS，比如 Grammarly、Canva、Whimsical、InVideo 之类的。是的，我可以自信地说，一个健康的“网站访问到免费用户”（即免费账户创建）的转化率，大概在 20% 到 35% 之间。

---

### (00:49:43) Lenny

**English:**
From landing on the site to signing up?

**中文翻译:**
从进入网站到注册？

---

### (00:49:45) Yuriy Timen

**English:**
From landing on site to a free user at scale. Earlier stage, you have strong product market fit with some kind of small audience segment that conversion can be 40 to 50%, but as you go broader, it'll probably asymptote at like 25, 30%. What about a conversion if you're premium from a free user to a premium account or paying account? I think anything under 5% is not going to work long term, regardless of how big your top of funnel is. You may get the soft point, but for you to remain an independent company continuously growing pre IPO, I don't think it's going to happen. It's got to be north of 5%, ideally like more than 7%.

**中文翻译:**
在大规模情况下，从进入网站到成为免费用户。在早期阶段，如果你在某个细分受众群体中拥有强大的产品市场匹配度（PMF），转化率可以达到 40% 到 50%，但随着你向更广泛的市场扩展，它可能会逐渐稳定在 25% 到 30% 左右。那么，如果你是高级版（Premium），从免费用户到高级账户或付费账户的转化率呢？我认为任何低于 5% 的转化率从长期来看都是行不通的，无论你的漏斗顶部有多大。你可能会达到某个平衡点，但如果你想保持作为一家独立公司在 IPO 前持续增长，我认为那是不可能的。它必须高于 5%，理想情况下要超过 7%。

---

### (00:50:39) Lenny

**English:**
Wow. Super handy. On the onboarding point, what's your thoughts on investing in onboarding and that part foe of how often is that a fruitful area of investment?

**中文翻译:**
哇，非常实用。关于入职引导这一点，你对投资入职引导有什么看法？那个环节作为投资领域，其成效如何？

---

### (00:50:49) Yuriy Timen

**English:**
Almost always. A lot of my work is in that sort of a prosumer space. So the products tend to be more complex. Airtable, whimsical, Canva, InVideo. They're very robust products. And so it's very easy to get lost in their editors. I think what all of those companies are trying to do for their respective verticals and use cases is they're trying to democratize access to fades that previously you have to rely on professionals for. Maybe in the case of bayer team bot, it's your engineers. In the case of PM bot, it is professional graphic designers. In the case of a video, it's professional video editors. So when they're trying to democratize access, but they're also trying to make the products robust enough to be comparable to a professional great quality. And it's a very difficult place to play it, right? It's like, how do you make it simple enough where a nonprofessional can use it, but robust enough where they go and say, "Oh yeah, this is as good as if I would've hired a professional fill in the blank."

**中文翻译:**
几乎总是卓有成效。我的很多工作都在这种“专业消费者”领域。所以产品往往更复杂。Airtable、Whimsical、Canva、InVideo，它们都是非常强大的产品。因此，用户很容易在它们的编辑器中迷失方向。我认为所有这些公司在各自的垂直领域和用例中所做的，都是试图将以前必须依赖专业人士才能完成的事情“民主化”。在某些情况下，以前你得靠工程师；在 Canva 的情况下，以前得靠专业平面设计师；在视频领域，以前得靠专业视频剪辑师。所以当他们试图实现访问民主化时，他们也试图让产品足够强大，以达到专业级的质量。这是一个非常难平衡的点，对吧？就像是：你如何让它足够简单，让非专业人士也能使用，但又足够强大，让他们能说：“哦，这和我雇一个专业人士做出来的效果一样好。”

---

### (00:52:19) Yuriy Timen

**English:**
And that's where onboarding, sorry for the long answer. That's where onboarding is really, really important because there's such a huge difference between landing someone on that initial editor page, be it Airtable, Canva having that left to their own devices versus getting as much information or as much relevant information front and then customizing that landing experience for them. So that if they're there to do X and we know XYZ about them, we're able to guide them and not expose them to the robustness of the product all at once. So the short answer is almost all the time onboarding is a big opportunity.

**中文翻译:**
这就是入职引导的作用，抱歉回答得有点长。入职引导之所以非常非常重要，是因为让某人直接进入初始编辑器页面（无论是 Airtable 还是 Canva）并让他们自生自灭，与预先获取尽可能多的相关信息并为他们定制着陆体验之间，存在着巨大的差异。这样，如果他们来是为了做 X，而我们了解他们的 XYZ 信息，我们就能引导他们，而不是一次性把产品的所有复杂功能都推到他们面前。所以简短的回答是：几乎在所有时候，入职引导都是一个巨大的机会。

---

### (00:53:04) Lenny

**English:**
Awesome. That's what I was expecting to hear, to give folks some context. What's kind of an order magnitude that you've seen improvement on onboarding and maybe impact on a company improving onboarding.

**中文翻译:**
太棒了。这正是我预料中会听到的。为了给大家一些参考，你见过的改善入职引导所带来的提升数量级大概是多少？或者说改善入职引导对一家公司的影响有多大？

---

### (00:53:15) Yuriy Timen

**English:**
Earlier stage companies where still haven't really approached the local maximal, but you haven't experimented with a ton of things. I mean, you can two to four X activation rates easily through onboarding. I think later stage companies like maybe Series B beyond, I think you can still probably get to 20 to 30% lift at activations. It depends on how many low hanging fruit are left to tackle.

**中文翻译:**
对于尚未真正达到局部最大值、且还没尝试过太多东西的早期公司，通过入职引导，你可以轻松地将激活率（Activation Rates）提高 2 到 4 倍。我认为对于后期公司（比如 B 轮及以后），你可能仍然可以获得 20% 到 30% 的激活率提升。这取决于还剩下多少“低垂的果实”（容易实现的目标）可以挖掘。

---

### (00:53:46) Lenny

**English:**
That makes sense. Yeah. Till the onboarding, there's always money in the onboarding banana stand. On that kind of same idea, do you have a general feeling of investments in this stuff often pays off and helps you grow and is often higher ROI and investments in bucket B are rarely successful. What would those two buckets be?

**中文翻译:**
有道理。是的，入职引导里总是有钱赚（引用香蕉摊的梗）。基于同样的思路，你是否有一种普遍的感觉，即投资于某些方面通常会有回报并帮助增长，且 ROI（投资回报率）更高，而投资于“B 类”领域则很少成功？这两类分别是什么？

---

### (00:54:07) Yuriy Timen

**English:**
So thinking of investments rawly, right? Not just monetarily.

**中文翻译:**
所以是广义上的投资，对吧？不仅仅是金钱上的。

---

### (00:54:13) Lenny

**English:**
Yeah. Yeah. Time and resources.

**中文翻译:**
是的，时间和资源。

---

### (00:54:15) Yuriy Timen

**English:**
Yeah. I mean, I would say that getting to know your customer always pays off. So it's user interviews and getting to know your market, your customers, and your prospects always pays off. Customer research, inside surveying, interviewing panels incredibly useful. And I found that to be very especially early stages. The amount of clarity at momentum that it can create inside of a seed Series A up to Series B company when you first do some proper research push. The way it can galvanize the team and give them focus and clarity and purpose is remarkable. So that always pays off. What doesn't pay off? I mean, I think over reliance on paid, it comes to bite you in the rear end. When I think about tracking an attribution, I think it's a question of the right level of investment at the right stage.

**中文翻译:**
是的。我想说，了解你的客户总是会有回报的。所以，用户访谈、了解你的市场、你的客户和你的潜在客户总是值得的。客户研究、内部调查、访谈小组都极其有用。我发现这在早期阶段尤其重要。当你第一次进行适当的研究推进时，它能为种子轮、A 轮甚至 B 轮公司内部创造出巨大的清晰度和动力。它激励团队、赋予他们专注力、清晰度和目标感的方式是显著的。所以那总是有回报的。什么没有回报？我认为是过度依赖付费渠道，这最终会让你自食其果。当我思考追踪和归因时，我认为这是一个在正确阶段进行正确水平投资的问题。

---

### (00:55:19) Yuriy Timen

**English:**
Rarely do companies get it right. They usually fall into one of two buckets where they underinvest in attribution and they are now, their budgets are up high. They have a broad channel portfolio and they have a hard time figuring out what's working, what isn't and they just get into this inertia. It's like, "Well, overall, the company's been growing and it's been growing roughly over the same time that we've been increasing our spend. We're scared to break it. So we're just going to keep spending." Or companies that read horror stories about other companies overspending. They sometimes try to invest in attribution too much, believe it or not where they're trying to get everything perfect and scientifically pure. But what they don't realize is that the payoff may not always be there. And so how do I fit this into your question of, I think tracking attribution incrementality is definitely a worthwhile investment arena, but it could both be a good or bad depending on the level. So you got to make sure the level investment is appropriate for your stage when you stand to aim for-

**中文翻译:**
很少有公司能做对。他们通常会掉进两个坑之一：要么是对归因投资不足，而现在他们的预算很高，渠道组合很广，却很难弄清楚什么是有效的，什么不是，于是陷入了一种惯性。就像是：“嗯，总的来说公司一直在增长，而且增长的时间点大致和我们增加支出的时间点吻合。我们害怕打破这种状态，所以就继续花钱吧。”或者是那些听过其他公司过度支出鬼故事的公司，他们有时会过度投资于归因（信不信由你），试图让一切都变得完美且具有科学纯洁性。但他们没有意识到，回报并不总是存在的。所以回到你的问题，我认为追踪归因的增量性绝对是一个值得投资的领域，但根据投资水平的不同，它可能变好也可能变坏。所以你必须确保投资水平与你所处的阶段相匹配。

---

### (00:56:35) Lenny

**English:**
Awesome. You're such a good interviewee that you come back to the question.

**中文翻译:**
太棒了。你真是一个优秀的受访者，总能绕回到问题本身。

---

### (00:56:39) Yuriy Timen

**English:**
No, that I promise.

**中文翻译:**
不，我保证。

---

### (00:56:40) Lenny

**English:**
That was great. Okay. One last question. Before we get to our very exciting lightning round. I'd love you to get your thoughts on advertising on TikTok and YouTube and broadly is there any other tactics, avenues that you think are kind of underutilized or emerging that folks should be thinking about?

**中文翻译:**
太好了。好，最后一个问题。在我们进入非常令人兴奋的闪电轮（Lightning Round）之前。我想听听你对在 TikTok 和 YouTube 上做广告的看法，以及广义上，你认为还有哪些被低估或新兴的策略和渠道是大家应该考虑的？

---

### (00:56:58) Yuriy Timen

**English:**
Yeah. So TikTok, one thing I'll say about TikTok is I'm seeing it come up more and more as a channel that works well. And sometimes even the most efficient channel, most efficient digital channel for some brands. But I think that the thing about TikTok that oftentimes I was surprised about is you often hear, "Oh, TikTok that's for the 15 to 22 year olds." I'm bad with my gens Z and oh, my audience is different. So I'm just going to ignore the champ. TikTok has so many users and it's still so relatively unsaturated with advertisers that your audience is on there. You'd be surprised.

**中文翻译:**
是的。关于 TikTok，我想说的一点是，我看到它越来越多地作为一个有效的渠道出现。有时对于某些品牌来说，它甚至是最高效的渠道，最高效的数字渠道。但我认为关于 TikTok，经常让我感到惊讶的是，你经常听到人们说：“哦，TikTok 是给 15 到 22 岁的人玩的。”我对 Z 世代不太了解，或者觉得“我的受众不同，所以我打算忽略这个渠道”。TikTok 拥有如此多的用户，而且广告商相对来说仍然不算饱和，你的受众就在那里。你会感到惊讶的。

---

### (00:57:46) Yuriy Timen

**English:**
I've worked with brands that their core demo is like 40 plus married making 200K plus in household annual income. And you wouldn't think that demo is on TikTok and it is. So what point about TikTok? Other channels, I think out at home is still not getting enough love. Podcasts? Okay. Yep, yep.

**中文翻译:**
我合作过的一些品牌，其核心受众是 40 岁以上、已婚、家庭年收入 20 万美元以上的人群。你可能觉得这类人群不在 TikTok 上，但他们确实在。所以这是关于 TikTok 的一点。其他渠道方面，我认为户外广告（Out-of-home, OOH）仍然没有得到足够的重视。播客？好的，没错，没错。

---

### (00:58:14) Lenny

**English:**
Spots through this one. I recall you heard it from Yuriy.

**中文翻译:**
通过这个节目投放。我记得你是从 Yuriy 那里听到的。

---

### (00:58:17) Yuriy Timen

**English:**
Direct mail, what has happened? They've gotten better with attribution because before a lot of those channels were written off as sort of attribution is just too hard on there and attribution is so good and reliable on digital. So that's that gap that canyon that existed in attribution capabilities of online and offline, deterred a lot of people from offline. Today offline has gotten better and actually positioning themselves as being able to do attribution, but also online attribution is deteriorated. So all of a sudden that argument kind of slimmed out a little bit and I'm seeing offline get a lot more traction and in podcasts, especially are actually very, very performant for a lot of brands. Those are a couple of things that come to mind.

**中文翻译:**
直邮（Direct Mail），发生了什么变化？他们的归因做得更好了。因为以前很多这类渠道被放弃了，理由是归因太难，而数字渠道的归因又好又可靠。线上和线下归因能力之间存在的这种鸿沟，让很多人对线下渠道望而却步。今天，线下渠道已经进步了，实际上他们把自己定位为能够进行归因，而线上归因却在退化。所以突然之间，那个论点就变得站不住脚了，我看到线下渠道获得了更多的关注，尤其是播客，对很多品牌来说实际上表现非常非常出色。这些是我能想到的一些点。

---

### (00:59:11) Lenny

**English:**
Those are great. Happy to hear the podcast piece. Excellent. And then I actually, I'm an investor in a startup that Databig at a home campaign and they just told me that it was a 10 to one positive ROI on the deals that they got out of it. So I've been seeing that too, and that's such a good point that the measurement and attribution online has come down where it maybe makes more sense to try stuff like that. Amazing. All right. Are you ready for our very exciting lightning round? I'm going to ask you five questions I think, and then just, yeah, let's go through it quick.

**中文翻译:**
这些都很棒。很高兴听到关于播客的部分。太好了。实际上，我投资了一家初创公司，他们做了一次户外广告活动，他们告诉我，从那次活动中获得的交易 ROI 是 10:1。所以我也看到了这一点。你说的线上衡量和归因能力下降，使得尝试这类东西变得更有意义，这真是一个很好的观点。太棒了。好了，你准备好进入我们非常令人兴奋的闪电轮了吗？我会问你大约五个问题，然后我们就快速过一遍。

---

### (00:59:44) Yuriy Timen

**English:**
Let's do it.

**中文翻译:**
开始吧。

---

### (00:59:45) Lenny

**English:**
Let's do it. Okay. What are two or three books that you recommend most to other people?

**中文翻译:**
开始。好，你最推荐给别人的两三本书是什么？

---

### (00:59:50) Yuriy Timen

**English:**
Ooh, that's something that I think is very wrong to recency bias, right? It's like, what are some of the books you've read recently that you've enjoyed? But I would say there are a couple of books that stuck with me over the years. I think on the business side, where on the business side productivity side, it's a book called Essentialism. I forget the author's name. I think his last name is McKeown or something. And it's basically the book about cutting out the noise and finding a singular focus and doing that really well. It's a book that was a game changer for me at Grammarly being sort of new in my career, having really aggressive goals, not being scared to say no. Taking on a lot, just feel it thinking like, "Well, I'm only working 12 hours a day. There's 12 more left. I can do it."

**中文翻译:**
哦，我觉得这很容易受到“近因偏差”的影响，对吧？就像是你最近读了哪些喜欢的书。但我会说有几本书多年来一直影响着我。在商业和生产力方面，有一本书叫《精要主义》（Essentialism）。我忘了作者的名字，我想他姓 McKeown 之类的（注：Greg McKeown）。这本书基本上是关于排除噪音、寻找单一焦点并把它做好的。这本书在 Grammarly 时期改变了我的职业生涯，当时我刚起步，有着非常激进的目标，学会了不害怕说“不”。以前我会承担很多，想着：“好吧，我一天只工作 12 小时，还有 12 小时，我能行。”

---

### (01:00:45) Yuriy Timen

**English:**
And then when you end up stepping into a leadership role, which happened for me, I mean, that happened prior to grounded, but really I was able to grow into that role at Grammarly. That book was incredible and I used it a lot. I pretty much got copies for everybody on the team, like 40 plus people. So that is a book I swear by. I read a lot outside of work and business. So I don't know if it's appropriate, but I'll say that. It's Frankl's, A Man's Search for Meaning is just a remarkable memoir on perseverance and I think that biggest takeaway is you can't control what's happening around you, but you can control your reaction to it.

**中文翻译:**
后来当我进入领导岗位时（这在 Grammarly 之前就发生了，但我确实是在 Grammarly 真正成长为那个角色的），那本书非常了不起，我经常用到它。我几乎给团队里的每个人都买了一本，大概 40 多个人。所以那是我非常推崇的一本书。在工作和商业之外我也读很多书。我不知道这是否合适，但我会说：弗兰克尔的《活出生命的意义》（A Man's Search for Meaning）是一部关于毅力的卓越回忆录。我认为最大的收获是：你无法控制周围发生的事情，但你可以控制你对它的反应。

---

### (01:01:50) Yuriy Timen

**English:**
And then I'd say the book that I read recently, because I was very affected by the Russia invasion of Ukraine. I'm originally from Ukraine. I believe you are as well. So it hit very close to home and there have been a lot of references drawn between the President's Zelensky and his response in the war and Winston Churchill's response in 1941 when Hitler started marching through Europe. And so I read a book called I think The Splendid and the Vile by Eric Larson.

**中文翻译:**
然后我想说一本我最近读的书，因为我深受俄罗斯入侵乌克兰的影响。我原籍乌克兰，我相信你也是。所以这对我来说感触很深。人们经常把泽连斯基总统在战争中的反应与温斯顿·丘吉尔在 1941 年希特勒横扫欧洲时的反应相提并论。所以我读了一本埃里克·拉森写的书，我想叫《辉煌与邪恶》（The Splendid and the Vile）。

---

### (01:02:02) Lenny

**English:**
Yeah. I read that. I read that.

**中文翻译:**
是的，我读过，我读过。

---

### (01:02:03) Yuriy Timen

**English:**
Did you also read it since the invasion?

**中文翻译:**
你也是在入侵发生后读的吗？

---

### (01:02:06) Lenny

**English:**
No, it was before that, but I totally get that now.

**中文翻译:**
不，是在那之前，但我现在完全能理解那种感觉。

---

### (01:02:09) Yuriy Timen

**English:**
Reading it right now because I've been following the conflict very closely, but for people who haven't followed the conflict or maybe have only followed the rush, the war kind of in a cursory way, you can put what's happening into historical context remarkably well. So I feel like that book accomplishes two things. Number one, it's like you learned something about not so distant history that maybe you didn't know, which was about Great Britain and Winston Churchill kind of courageous response in the face of Hitler's invasion of Europe. But you also can draw so many parallels to what's happening today. And hopefully that helps us understand what's at stake, not to end on two grandiose of a note.

**中文翻译:**
我现在正在读，因为我一直密切关注这场冲突。但对于那些没有关注冲突，或者只是走马观花了解战争的人来说，你可以非常出色地将正在发生的事情放入历史背景中。我觉得这本书实现了两件事。第一，你了解了一些你可能不知道的、并不遥远的历史，那是关于英国和温斯顿·丘吉尔在面对希特勒入侵欧洲时表现出的英勇反应。但你也可以发现很多与今天发生的事情相似的地方。希望这能帮助我们理解其中的利害关系，不想以太宏大的基调结束。

---

### (01:02:57) Lenny

**English:**
We'll go less grandiose quickly, but I will add one thing that stood out in that book that is also true in the Ukraine is how during the fire bombing of Britain, people are just going out every day, going to clubs, still having-

**中文翻译:**
我们会很快转到没那么宏大的话题，但我还要补充一点书中让我印象深刻的地方，这在乌克兰也是事实：在英国遭受大轰炸期间，人们每天照样出门，去俱乐部，依然过着——

---

### (01:03:09) Yuriy Timen

**English:**
I know. Steal them their life.

**中文翻译:**
我知道。过着他们自己的生活。

---

### (01:03:11) Lenny

**English:**
And same thing even today in Ukraine is.

**中文翻译:**
即使在今天的乌克兰也是一样。

---

### (01:03:14) Yuriy Timen

**English:**
And not just keep, but it's very life.

**中文翻译:**
不仅仅是生存，而是真实的生活。

---

### (01:03:17) Lenny

**English:**
I love that. Okay. We'll move on to less, less serious stuff maybe. What a transition to, what's your favorite other podcast?

**中文翻译:**
我喜欢这一点。好了，我们转到一些没那么严肃的话题。这个过渡有点跳跃：你最喜欢的其他播客是什么？

---

### (01:03:27) Yuriy Timen

**English:**
Honestly, there's only one other podcast that I'll listen to right now because I've just been so consumed. I listened to a lot of live streams and read a lot about the conflict, which has taken up so much of my head space. That's not work related, but I would say that the All in Pod. I feel like it's a cool way for me to just catch up on everything that's going on through their unique filter.

**中文翻译:**
老实说，我现在只听另一个播客，因为我太忙了。我看了很多直播，读了很多关于冲突的报道，这占据了我太多的精力。那与工作无关，但我会说是《All-In Pod》。我觉得通过他们独特的视角来了解正在发生的一切，是一种很酷的方式。

---

### (01:03:50) Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### (01:03:50) Lenny

**English:**
I learned a lot from that one. That's so much drama on that show. Okay. Great. Favorite recent movie or TV show. Anything stand out.

**中文翻译:**
我从那个播客里学到了很多。那个节目里的戏剧性冲突太多了。好，太棒了。最近最喜欢的电影或电视节目？有什么脱颖而出的吗？

---

### (01:04:00) Yuriy Timen

**English:**
So that's another thing. Since February I've watched nothing. My Netflix skew just keeps growing because they keep emailing me saying this new season is out. I'm like, "Oh yeah. I used to that show. Let me add it to the queue." I mean, recently I had some downtime. The kids were with grandma, so I watch movie Hustle with Adam Sandler.

**中文翻译:**
这也是另一回事。自二月以来我什么也没看。我的 Netflix 待看列表一直在增加，因为他们不断给我发邮件说新一季上线了。我会想：“哦对，我以前看那个，加进列表吧。”我是说，最近我有一点空闲时间，孩子们在奶奶家，所以我看了亚当·桑德勒的电影《必胜球探》（Hustle）。

---

### (01:04:22) Lenny

**English:**
Love that. So good.

**中文翻译:**
喜欢那部，非常棒。

---

### (01:04:23) Yuriy Timen

**English:**
Yeah. It was good. It was it's very light. It's not like a movie that's going to make you think a lot, but it was just good old entertainment. Yeah.

**中文翻译:**
是的，很不错。它很轻松，不是那种会让你思考很多的电影，但就是那种纯粹的娱乐。是的。

---

### (01:04:31) Lenny

**English:**
I like that. I like that summary. Yeah, it was so delightful. Maybe one more question. Who else in the industry do you most respect as a thought leader? Maybe someone people may not know or if anyone else comes to mind.

**中文翻译:**
我喜欢那个总结。是的，非常令人愉快。再问一个问题：在业内你最尊敬的意见领袖是谁？也许是大家不太熟悉的人，或者任何你想到的人。

---

### (01:04:43) Yuriy Timen

**English:**
That's a very good question. So I would say first off, I do believe that some of the brightest minds, honestly, in any craft are people that you never hear because it takes a certain personality, energy, and probably a lot of other circumstances to invest in your personal brand. And also it's very hard to do that while still staying relevant as a practitioner. I mean, when I think about myself two years ago before starting advising, I was just kind of living in my Grammarly cave. And I felt like I was probably at the top of my craft, but I didn't have time to pick my head up or not, maybe not even just tie, but I didn't know where to start to pick my head up and do something like this. I would say some people that, I mean, I mentioned Ethan in terms of SEO. SEO and just organic growth loops and content as a growth engine, he is best in class.

**中文翻译:**
这是一个非常好的问题。首先我想说，我真的相信在任何领域，一些最聪明的大脑可能是你从未听说过的人。因为投资个人品牌需要特定的性格、精力以及很多其他环境因素。而且，在保持作为从业者的专业性的同时做到这一点非常困难。我是说，回想两年前我开始做顾问之前，我只是住在我的“Grammarly 洞穴”里。我觉得我当时可能处于专业巅峰，但我没有时间抬头看，甚至不知道从哪里开始抬头去做像现在这样的事情。我会说，我提到的 Ethan 在 SEO 方面，以及自然增长循环和以内容为增长引擎方面，他是顶尖的。

---

### (01:05:49) Yuriy Timen

**English:**
Who else? So Mark Fisk, he shows up in the Reforge chats a lot. He was leading growth and marketing at Credit Karma for a while. And right now he's an investor I think at the HRG Capital, but he is a really, really strong thought leader on all things, performance marketing attribution, and just kind of paid acquisition at large. Those are two people that I make sure I... And there are others of course, but those are two who I make sure I stay in touch with at least on a quarterly basis because any casual catch up just yield so many unique nuggets.

**中文翻译:**
还有谁呢？Mark Fisk，他经常出现在 Reforge 的讨论中。他曾在 Credit Karma 负责增长和营销。现在我想他是 H.I.G. Capital 的投资者，但他在效果营销、归因以及广义的付费获客方面是一位非常非常强大的意见领袖。这两个人是我一定会……当然还有其他人，但这两个人是我确保至少每季度保持联系的，因为任何随意的叙旧都能带来很多独特的真知灼见。

---

### (01:06:25) Lenny

**English:**
Where can folks find you online if they want to reach out, learn more and how can listeners be useful to you?

**中文翻译:**
如果大家想联系你或了解更多，可以在哪里找到你？听众们能为你做些什么？

---

### (01:06:31) Yuriy Timen

**English:**
Honestly, I don't have a very strong online presence. I would say LinkedIn is probably the only place where I seek things the recent, so folks can find me there. They can also find me inside of Lenny's Newsletter. I do. I do. I do, but you can appearance there once in a while and on that's odd.

**中文翻译:**
老实说，我没有很强的网络存在感。我会说 LinkedIn 可能是唯一能找到我近况的地方。大家也可以在 Lenny 的时事通讯（Newsletter）里找到我。我偶尔会在那里露面。

---

### (01:06:53) Lenny

**English:**
True.

**中文翻译:**
没错。

---

### (01:06:54) Yuriy Timen

**English:**
How folks can be helpful to me, honestly, promote and shout out of Lenny's Newsletter and Lenny's Pod and that if you're building awesome things, come talk to me. I always carve out some amount of time in my life just for noncommercial things, just to have conversations with founders and spent 30 minutes with them on a phone, expecting nothing in return and maybe save them some time from making some of the mistakes that I've made and help direct them on a more path. So it's about it.

**中文翻译:**
大家能怎么帮我？老实说，去宣传和支持 Lenny 的时事通讯和播客。另外，如果你正在打造很棒的东西，来找我聊聊。我总会在生活中留出一些时间做非商业性的事情，只是为了和创始人交流，花 30 分钟通个电话，不求回报，也许能帮他们少走一些我走过的弯路，引导他们走向更正确的道路。大概就是这些。

---

### (01:07:27) Lenny

**English:**
Amazing. You are awesome. Thank you so much for making the time to do this. I learned a ton. I can't wait to get this episode out. There's just so much meat to this thing,

**中文翻译:**
太棒了。你太出色了。非常感谢你抽时间做这个。我学到了很多。我迫不及待想发布这一集了，内容实在太充实了。

---

### (01:07:36) Yuriy Timen

**English:**
Dude this was good.

**中文翻译:**
伙计，这真的很棒。

---

### (01:07:37) Yuriy Timen

**English:**
I feel like my nervousness was unfounded. This was super organic. You are just as welcoming as you are outside of the pod. So yeah. Thanks for having me.

**中文翻译:**
我觉得我的紧张是多余的。这次对话非常自然。你在播客里和在现实中一样平易近人。所以，是的，谢谢邀请我。

---

### (01:07:50) Lenny

**English:**
Thanks Yuriy. Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also please consider giving us a rating or leaving a review as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
谢谢 Yuriy。非常感谢大家的收听。如果你觉得这些内容有价值，可以在 Apple Podcasts、Spotify 或你喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众找到这个播客。你可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。