# Zoelle Egner - 双语对照

This is the complete bilingual transcript for Lenny's Podcast featuring Zoelle Egner.

---

### [00:00:00] Zoelle Egner

**English:**
There is sometimes a recommendation or an instinct just like, "Ship things super, super quickly and get them out there." And I'm not saying don't move fast. Obviously you need to move fast in the early days, but make sure someone rereads your email so that it sounds good. Invest in having a decent photo or a decent illustration. If you have sample content, this is actually a big one, sample content for your productivity app as an example. Take the time to not have it be like Jane Doe 12 times in the name list. Have it be references to your industry so that people are like, "Oh, hey. That's a joke about Steve Jobs. I'm a designer. This person is thinking about me."

**中文翻译:**
有时候人们会有一种建议或本能，觉得“只要飞快地把东西做出来并发布出去就行”。我不是说不要快，初创阶段显然需要快，但请确保有人重读一遍你的邮件，让它听起来得体。投入一点精力弄张像样的照片或插画。如果你有示例内容——这其实非常重要，比如你的生产力工具里的示例——花点时间，别让名单里出现 12 个“张三”。让它和你的行业相关，这样人们会觉得：“噢，嘿，这是个关于史蒂夫·乔布斯的梗。我是个设计师，这家伙懂我。”

---

### [00:00:35] Zoelle Egner

**English:**
It's small stuff, but it tells that person, like, "The people who worked on this were thinking about me as a customer, they built it with me in mind, and that means that it is more likely that this is going to fit my needs than something generic." And that builds up both the brand trust that we've talked about, but also the personality of the company, and makes people want to root for you. And frankly, when you are small, you need everyone rooting for you that you can possibly get.

**中文翻译:**
这些都是小细节，但它在告诉用户：“开发这个产品的人在考虑我这个客户，他们是为我而造的，这意味着它比那些通用的东西更可能满足我的需求。”这不仅建立了我们谈到的品牌信任，还塑造了公司的个性，让人们想要支持你。坦白说，当你还很弱小时，你需要尽可能争取到每一个支持你的人。

---

### [00:01:02] Lenny

**English:**
Welcome to Lenny's Podcast, where I interview world-class product leaders and growth experts to learn from their hard won experiences building and scaling today's most successful companies. Today my guest is Zoelle Egner. Zoelle was one of the earliest employees at Airtable, where she led their early marketing and customer success teams, and generally just helped Airtable grow into the legendary business that it is today. She also spent time in Box. She's advised dozens of startups on marketing and growth, and is now head of marketing and growth at a startup called Block Party.

**中文翻译:**
欢迎来到 Lenny 的播客。在这里，我采访世界级的跨国产品领导者和增长专家，学习他们在构建和扩展当今最成功公司过程中获得的宝贵经验。今天的嘉宾是 Zoelle Egner。Zoelle 是 Airtable 最早期的员工之一，她领导了早期的营销和客户成功团队，并助力 Airtable 成长为今天的传奇企业。她还曾在 Box 工作过，为数十家初创公司提供过营销和增长咨询，目前在一家名为 Block Party 的初创公司担任营销与增长负责人。

---

### [00:01:32] Lenny

**English:**
In our conversation, Zoelle shares how to punch above your weight as a startup, the most effective and impactful growth and marketing tactics throughout Airtable's history, including their use of billboards, marketing investments that are often high ROI, and those that are rarely a good use of time, why PR and launches are actually useful to startups, and also when they aren't, and a lot more. It was so much fun chatting with Zoelle, and I'm really excited for you to learn from her. With that, I bring you Zoelle Egner after a short word from our wonderful sponsors.

**中文翻译:**
在我们的对话中，Zoelle 分享了初创公司如何“以小博大”（punch above your weight）、Airtable 历史上最有效且最具影响力的增长和营销策略（包括他们对广告牌的使用）、哪些营销投入通常具有高投资回报率（ROI）而哪些往往是浪费时间、为什么公关（PR）和发布活动对初创公司确实有用（以及什么时候没用）等等。和 Zoelle 聊天非常愉快，我很期待大家能从她身上学到东西。在听完赞助商的简短介绍后，让我们欢迎 Zoelle Egner。

---

### [00:02:03] Lenny

**English:**
Today's episode is brought to you by OneSchema, the embeddable CSV importer for SaaS. Customers always seem to want to give you their data in the messiest possible CSV file. And building a spreadsheet importer becomes a never ending sync for your engineering and support resources. You keep adding features to your spreadsheet importer, the customers keep running into issues. Six months later, you're fixing yet another date conversion edge case bug. Most tools aren't built for handling messy data, but OneSchema is. Companies like Scale AI and Pave are using OneSchema to make it fast and easy to launch delightful spreadsheet import experiences, from embeddable CSV import to importing CSVs from an SMTP folder on a recurring basis. Spreadsheet import is such an awful experience in so many products. Customers get frustrated by useless messages like, "Error on line 53." And never end up getting started with your product. OneSchema intelligently corrects messy data so that your customers don't have to spend hours in Excel just to get started with your product. For listeners of this podcast, OneSchema is offering a $1,000 discount. Learn more at oneschema.co/lenny.

**中文翻译:**
本期节目由 OneSchema 为您带来，它是面向 SaaS 的可嵌入式 CSV 导入器。客户似乎总是想把数据放在最乱的 CSV 文件里给你。而构建电子表格导入器会变成工程和支持资源的无底洞。你不断给导入器加功能，客户却不断遇到问题。六个月后，你还在修复另一个日期转换的边缘案例 Bug。大多数工具不是为了处理乱数据而生的，但 OneSchema 是。像 Scale AI 和 Pave 这样的公司都在使用 OneSchema，从而快速轻松地推出令人愉悦的表格导入体验，包括可嵌入的 CSV 导入以及从 SMTP 文件夹定期导入 CSV。在很多产品中，表格导入体验都很糟糕。客户会被“第 53 行错误”这种没用的提示搞崩溃，最终放弃使用你的产品。OneSchema 能智能纠正混乱数据，让你的客户不必为了开始使用你的产品而在 Excel 中耗费数小时。对于本播客的听众，OneSchema 提供 1000 美元的折扣。更多信息请访问 oneschema.co/lenny。

---

### [00:03:10] Lenny

**English:**
This episode is brought to you by Pando, the always on employee performance platform. How much do you love the performance review process? Yeah, it's time consuming, subjective, biased, and there's rarely any transparency. With the rapid shift to distributed work, it's a struggle to create the structure and transparency that you want to help your employees have the highest impact and growth in their careers. Pando is disrupting the old paradigm of performance management, including a continuous employee-centric approach, so employees stay engaged, see their progression in real time, and know exactly when and how they can level up. With Pando, managers can leverage competency based frameworks to effectively coach and develop their teams and align on consistent growth standards resulting in higher quality feedback and higher performing teams. Visit pando.com/lenny for more info and get a special discount when you sign out and reference this podcast. That's pando.com/lenny. Zoelle, welcome to the podcast.

**中文翻译:**
本期节目由 Pando 赞助，它是全天候的员工绩效平台。你有多喜欢绩效评估流程？是的，它耗时、主观、有偏见，而且几乎没有透明度。随着向分布式办公的快速转变，建立结构和透明度来帮助员工实现最高影响力和职业成长变得非常困难。Pando 正在颠覆旧的绩效管理范式，采用以员工为中心的持续方法，让员工保持投入，实时看到自己的进步，并确切知道何时以及如何晋升。通过 Pando，经理可以利用基于能力的框架来有效地指导和培养团队，并统一增长标准，从而获得更高质量的反馈和更高绩效的团队。访问 pando.com/lenny 了解更多信息，并在签约时提到本播客以获得特别折扣。Zoelle，欢迎来到播客。

---

### [00:04:12] Zoelle Egner

**English:**
Hi, thanks for having me.

**中文翻译:**
嗨，谢谢邀请我。

---

### [00:04:14] Lenny

**English:**
It's very much my pleasure. Something that is pretty cool is that we actually met in my newsletter Slack community. I actually looked this up of how we actually started chatting, and it was me cold DMing you to get a discount on Airtable for the newsletter subscribers. And you very happily got me that, hooked us up, and then you became a go-to Airtable person for advice on what Airtable did right and wrong over the years. And so thank you for being that person and also I'm really excited to have you on this podcast and to learn from you.

**中文翻译:**
这是我的荣幸。挺酷的一件事是，我们其实是在我的 newsletter Slack 社区认识的。我特意查了一下我们是怎么开始聊天的，当时是我直接私信你，想为 newsletter 的订阅者争取 Airtable 的折扣。你非常爽快地帮我搞定了，把我们对接上了。之后，你就成了我关于 Airtable 经验教训的咨询首选。所以，感谢你一直以来的帮助，我也非常激动能邀请你来播客，向你学习。

---

### [00:04:43] Zoelle Egner

**English:**
I am super excited to chat.

**中文翻译:**
我也非常期待这次交流。

---

### [00:04:45] Lenny

**English:**
Awesome. You're probably best known for your time at Airtable, which, correct me if I'm wrong, you're employee number 11.

**中文翻译:**
太棒了。你最出名的经历可能是在 Airtable，如果我没记错的话，你是第 11 号员工？

---

### [00:04:53] Zoelle Egner

**English:**
That's right.

**中文翻译:**
没错。

---

### [00:04:55] Lenny

**English:**
Okay, and at Airtable you led marketing, you led the customer success teams, so we're going to chat about all that stuff. But before we get into that, I want to chat briefly about this other project that you worked on, that from the outside felt like a really fascinating thing, and a really impactful project, and a really cool team. And it's called Vaccinate California, I think, is that how you pronounce it?

**中文翻译:**
好的，在 Airtable 你领导过营销和客户成功团队，这些我们待会儿都会聊。但在那之前，我想简短聊聊你参与的另一个项目。从外界看来，那是一个非常迷人、极具影响力且团队很酷的项目。它叫 Vaccinate California（接种加州），我是这么读的吗？

---

### [00:05:13] Zoelle Egner

**English:**
Mm-hmm. VaccinateCA.

**中文翻译:**
嗯，VaccinateCA。

---

### [00:05:15] Lenny

**English:**
VaccinateCA. Okay. Could you just talk a little bit about what this was? What were you trying to do? What was the impact you had? How did it all go?

**中文翻译:**
VaccinateCA，好的。你能简单说说这是个什么项目吗？你们当时想做什么？产生了什么影响？进展如何？

---

### [00:05:21] Zoelle Egner

**English:**
Yeah, absolutely. So VaccinateCA existed to help people in California find and get a COVID vaccine as quickly as possible, and that sounds really trivial right now, but you have to wind back to January of 2020, when vaccines were first coming out, and it was really hard. So just as a reminder, because most of us have blocked that from our memory.

**中文翻译:**
当然可以。VaccinateCA 的存在是为了帮助加州人尽可能快地找到并接种新冠疫苗。现在听起来可能觉得没什么，但你得回想一下 2020 年 1 月（注：应为 2021 年初），疫苗刚出来的时候，那真的非常困难。提醒一下大家，因为我们大多数人都把那段记忆封存了。

---

### [00:05:40] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:05:41] Zoelle Egner

**English:**
The federal and state systems didn't really exist yet, and so everything was this horrible hodgepodge, where eligibility depended on not only what state you were in, it was down to the county, and even sometimes the individual facility. You would be at a Walgreens, and talk to them, and they'd be like, "Oh, you have to be over 65, and also in one of these 12 categories of employment in order to get the vaccine." And then you'd go a mile away and they would tell you something totally different. So people would stand in line for hours. There were phones going off the hook, utterly madness, and really, really scary for a lot of people who were trying to figure out how to keep themselves safe.

**中文翻译:**
当时联邦和州的系统还没真正建立起来，所以一切都是一团糟。接种资格不仅取决于你在哪个州，还细化到县，甚至有时取决于具体的接种点。你在一家 Walgreens 药店，他们会说：“噢，你必须年满 65 岁，且属于这 12 类职业之一才能接种。”然后你走到一英里外的另一家店，他们告诉你的完全不同。所以人们会排队好几个小时。电话被打爆了，完全是疯狂的状态，对于很多想方设法保命的人来说，那真的非常可怕。

---

### [00:06:17] Lenny

**English:**
Yeah, I remember those days well.

**中文翻译:**
是的，我清楚地记得那些日子。

---

### [00:06:19] Zoelle Egner

**English:**
Yeah. So this organization was founded essentially by a tweet by Patrick McKenzie, for those of you who are on Hacker News Patio11. And he had basically this really simple premise, which is, "If you call a pharmacist, and you ask them who they can give a vaccine to, and what vaccine they have, and then you put that answer on a map, someone else doesn't have to make the same phone call. And that takes lots of pressure also as a healthcare system and also helps people to match supply and demand."

**中文翻译:**
是的。这个组织基本上是因为 Patrick McKenzie（Hacker News 上的 Patio11）的一条推文而成立的。他的初衷非常简单：“如果你给药剂师打电话，问他们可以给谁打疫苗，有什么疫苗，然后把答案标在地图上，别人就不用再打同样的电话了。这减轻了医疗系统的压力，也帮助人们匹配供需。”

---

### [00:06:47] Zoelle Egner

**English:**
(00:06:47):
Surprisingly, somehow, that tweet, which is essentially like, "Call people, put in spreadsheet, put online," turned into an entire, full nonprofit that was mostly on Discord, Zoom, Airtable, and not only had this entire hundreds of volunteers who were making phone calls in the state of California and eventually, actually, nationally, we became Vaccinate The States eventually, we were also doing this thing called web banking. So we would go and scrape all the official sources as they started coming out, and then validate them because they were not always correct. And eventually we had the most comprehensive database and map of locations in the entire country, including more comprehensive than the federal government and most of the states because they had really complicated limitations on what they could and couldn't publish based on some relationships they had. We didn't have those limitations.

**中文翻译:**
令人惊讶的是，这条本质上是“打电话、填表、上网”的推文，竟然演变成了一个完整的非营利组织，主要在 Discord、Zoom 和 Airtable 上运作。我们不仅有数百名志愿者在加州（后来扩展到全国，改名为 Vaccinate The States）打电话，还做了一件叫“网络银行”（web banking）的事。我们会抓取所有官方来源的信息，然后进行验证，因为官方信息并不总是准确的。最终，我们拥有了全国最全面的接种点数据库和地图，甚至比联邦政府和大多数州的还要全面，因为他们在发布信息时受到各种复杂关系的限制，而我们没有。

---

### [00:07:37] Zoelle Egner

**English:**
So it meant that we became this clearing house, essentially, for this information and we built an API. We were working directly with Google. And if you ever looked up vaccine locations on Google Maps, that was us feeding that to them, which was really cool. And we also made maps you could see on county websites, so it would help you understand what was available in your area. One of the coolest things that I've ever worked on.

**中文翻译:**
这意味着我们成了这些信息的“结算中心”，我们还构建了一个 API。我们直接与 Google 合作。如果你曾在 Google 地图上查找过疫苗接种点，那就是我们在为他们提供数据，这真的很酷。我们还制作了可以在县政府网站上查看的地图，帮助你了解所在地区的供应情况。这是我参与过的最酷的项目之一。

---

### [00:08:01] Lenny

**English:**
Okay, exactly. That's exactly I imagined how epic this was. Just to make sure people understand what you're describing, basically you had hundreds of people sitting there on phones calling vaccine locations, getting the specifics of who is able to get a vaccine there, and then just giving people a pointer of where they can get a vaccine.

**中文翻译:**
好的，没错。这正是我想象中的那种壮举。为了确保大家理解，基本上就是有几百人坐在电话旁，给各个接种点打电话，确认谁能在那儿打针，然后给大众提供一个明确的指引。

---

### [00:08:18] Zoelle Egner

**English:**
Exactly. So I came in initially, a colleague of mine at Airtable had been helping out with the building out of the backend. And they started getting media attention. And they thought, "Oh, well this will help more people understand that this resource is available." So I got brought in to do some PR help, basically help them figure out how to get the word out, and then ended up actually quitting my job at Airtable to work on it full-time.

**中文翻译:**
没错。我最初加入是因为我在 Airtable 的一位同事一直在帮忙构建后端。后来他们开始受到媒体关注，他们觉得：“噢，这能让更多人知道这个资源的存在。”于是我被请去帮忙做公关，帮他们想办法宣传，最后我竟然辞掉了 Airtable 的工作，全职投入到这个项目中。

---

### [00:08:40] Lenny

**English:**
Oh wow.

**中文翻译:**
噢，哇。

---

### [00:08:41] Zoelle Egner

**English:**
Yeah, I was on the board and also managing all outreach and other stuff. So we did lots of really cool education, helping people understand their eligibility at all. Built a bunch of fun tools for that as well, but it was a pretty incredible six months, where we filled a really critical gap in the infrastructure of the country.

**中文翻译:**
是的，我是董事会成员，还负责所有的对外联络和其他事务。我们做了很多很酷的科普工作，帮助人们了解自己是否符合接种资格。还为此开发了一系列有趣的工具。那是非常不可思议的六个月，我们填补了国家基础设施中一个非常关键的空白。

---

### [00:08:58] Lenny

**English:**
It's wild that was the best solution, is just call people and create your own.

**中文翻译:**
太疯狂了，当时最好的解决方案竟然是“自己打电话去建库”。

---

### [00:09:03] Zoelle Egner

**English:**
You know?

**中文翻译:**
是吧？

---

### [00:09:03] Lenny

**English:**
I imagine there was, at Airtable, were you using to store the data?

**中文翻译:**
我猜在 Airtable，你们是用它来存储数据的吗？

---

### [00:09:07] Zoelle Egner

**English:**
Oh yes. We built an entire insane database, and then eventually custom software on top of that, to make the people who are making the phone calls more easily get the information in. It was a whole thing. Very cool to see, though, not just tech people get involved. We had, in our volunteer base, people from absolutely every walk of life, not just in California, globally. I remember there was a volunteer who said that he decided to join, he was based in Israel, and he had had no trouble getting the vaccine whatsoever, but seen something on Twitter about it, and just decided he wanted to make sure that people were able to get the vaccine as easily as he did. And he spent dozens of hours calling folks, even though he was in a totally different time zone. But really lovely to see all these different people, retired teachers. I think we had a bunch of 12 year olds who were helping out on the code, of all things, all who just really wanted to make sure that they could keep their community safe.

**中文翻译:**
噢是的。我们建立了一个极其庞大的数据库，最后还在上面开发了定制软件，让打电话的人能更轻松地录入信息。这是一项大工程。不过，看到不仅仅是技术人员参与进来真的很酷。我们的志愿者来自各行各业，不仅在加州，而是全球。我记得有一位志愿者在以色列，他接种疫苗完全没遇到困难，但在 Twitter 上看到了这个项目，就决定要确保其他人也能像他一样轻松接种。尽管有时差，他还是花了数十个小时打电话。看到这么多不同的人——退休教师，甚至还有一群 12 岁的孩子在帮忙写代码——真的非常感人，他们都只是想确保社区的安全。

---

### [00:10:02] Lenny

**English:**
What happened with this organization? It's a nonprofit that now continues to run or what's happening?

**中文翻译:**
这个组织后来怎么样了？它现在还在作为非营利组织运行吗？

---

### [00:10:06] Zoelle Egner

**English:**
No, we did something which is not common. We actually decided to shut it down after six months. Partially, that's because the existing system finally caught up. And frankly we didn't want to be in a place where we were pulling away resources that could be put towards other things that are going to be more impactful. We always saw ourselves as a stop gap, and once we got to the place where we felt like we weren't really being additive, we wanted to get people's time back, so they could work on other things. So it doesn't exist anymore. I think you can still go check out the archive. We found some researchers who are doing interesting research on it, because there's very fascinating data in there about the equitability of some of the distribution of the vaccine based on where it was available, but the organization is gone. We had that beautiful moment in time and have all moved on. Hoping we don't have to get the band back together, because hopefully it's not necessary anymore.

**中文翻译:**
不，我们做了一件不寻常的事。我们实际上在六个月后决定关闭它。部分原因是官方系统终于跟上了。坦白说，我们不想占用那些本可以投入到其他更有影响力的事情上的资源。我们一直把自己定位为“权宜之计”，一旦我们觉得不再能提供额外价值，我们就想把时间还给志愿者，让他们去做别的事。所以它现在不存在了。我想你仍然可以查看存档。我们发现一些研究人员正在对此进行有趣的研究，因为其中关于疫苗分配公平性的数据非常迷人。但组织已经解散了。我们拥有过那段美好的时光，现在都继续前行了。希望我们不需要再次“重组乐队”，因为希望那不再必要了。

---

### [00:10:58] Lenny

**English:**
Oh, man. I'm watching The Last of Us right now about this mushroom based disease, and that scares me now.

**中文翻译:**
噢，伙计。我最近在看《最后生还者》，讲的是那种真菌引起的疾病，现在听你这么说我有点害怕。

---

### [00:11:02] Zoelle Egner

**English:**
Mushroom people.

**中文翻译:**
真菌人。

---

### [00:11:03] Lenny

**English:**
Yep. Anyway, on this podcast I try to get to things people learn from these experiences, and so I have to ask what you learn about forming something like this, just ad hoc, pulling a bunch of people together, and having them focus, and get things done, or just scaling it, or even shutting down. I guess what have you taken away from that experience that you maybe will bring to either future one-off things like this or even just your work in general?

**中文翻译:**
是的。总之，在这个播客中，我试图挖掘人们从这些经历中学到的东西。所以我必须问，关于临时组建这样一个组织、把一群人聚在一起并让他们专注地完成任务、或者关于规模化甚至关闭它，你学到了什么？你从这段经历中带走了什么，可以应用到未来类似的临时项目或者你的日常工作中？

---

### [00:11:31] Zoelle Egner

**English:**
Yeah, I'd say probably three things. One, the incredible power of a simple idea to bring people together. One of the reasons why VaccinateCA was so powerful and got so many people to help is everybody immediately understood why it would be useful and how they specifically could be making a difference. And combining those two things was an incredible way to bring a lot of people on board very quickly, because from a messaging perspective, messaging, something very important to me as a marketer, it was so concise. Like, "Pick up phone, help save lives." Really straightforward. People really, really got that. It allowed them to feel like they had agency in a time when everything felt really, really out of control. I think there's a lot of opportunities we have to activate our communities and give people that sense of control that are both going to be helpful more broadly for society, but also just for those individuals as well to make them feel a little bit more safe, a little bit more like they can actually have a difference in things.

**中文翻译:**
我想大概有三点。第一，一个简单的想法在凝聚人心方面具有惊人的力量。VaccinateCA 如此强大并能吸引这么多人帮忙的原因之一是，每个人都能立刻理解它为什么有用，以及他们具体能如何做出贡献。将这两点结合起来，是快速吸引大量人员加入的绝佳方式。从营销人员非常看重的“信息传递”（messaging）角度来看，它非常简洁：“拿起电话，拯救生命。”非常直白。人们完全理解了。这让他们在一切都感觉失控的时候，感到自己还有主动权。我认为我们有很多机会去激活社区，给人们这种掌控感，这既对社会有益，也能让个人感到更安全，觉得他们真的能改变现状。

---

### [00:12:34] Zoelle Egner

**English:**
I think in tech we often don't jump into these problems. This was not sophisticated technology. It was phones, Discord, and Airtable mostly being used like a spreadsheet. It wasn't anything wild. Even that very simple infrastructure was enough to make a huge difference. And we have some evidence that we saved a lot of lives as a result of it, which is pretty special. I think part of it is also just saying, "We don't have to be hesitant to jump into these problems. It's important to engage with experts in the field, is not to say that tech solutionism is always the answer." And again, this is not super sophisticated technology, but because we were able to go in and talk to the people who are actually affected, get into the system that already existed, and make something really simple, really fast, it actually did have a huge difference and that's really exciting.

**中文翻译:**
我认为在科技界，我们往往不会涉足这些问题。这并不是什么尖端技术。它就是电话、Discord 和主要被当成表格用的 Airtable。没什么疯狂的东西。即使是这样简单的基础设施也足以产生巨大的影响。我们有一些证据表明，我们因此挽救了很多生命，这非常特别。我认为部分原因在于，我们不必犹豫是否要介入这些问题。与领域专家交流很重要，这并不是说“技术解决主义”永远是答案。再次强调，这技术含量不高，但因为我们能够深入其中，与受影响的人交谈，进入现有的系统，并快速做出简单的东西，它确实产生了巨大的影响，这非常令人兴奋。

---

### [00:13:24] Lenny

**English:**
Just to double-click on that one, actually reminds me, some founders of companies I've invested in, I often hear how much easier it is for companies that have a mission that people are excited about for them to hire versus companies that don't. And so it's a really good reminder of just the power of having a mission and a vision that is really compelling to people versus some B2B software that people aren't [inaudible 00:13:47] excited about, even though there's a great reason to have great B2B software. Love B2Bs.

**中文翻译:**
深入探讨一下这一点，这让我想起我投资的一些公司的创始人。我经常听到，拥有一个让人兴奋的使命的公司比没有使命的公司更容易招聘。这是一个很好的提醒：一个引人入胜的使命和愿景的力量是巨大的，相比之下，某些 B2B 软件可能没那么让人兴奋，尽管拥有优秀的 B2B 软件也有充分的理由。我热爱 B2B。

---

### [00:13:50] Zoelle Egner

**English:**
There are. I love great B2B software. I've spent most of my career on it. But I agree with you. I think if you have an authentic mission and people aren't just like, "Oh, sure, okay. You're connecting the world." But really it's some telephony startup. Like, "Okay." If people feel like it's genuinely authentic to what you're building, it can be incredibly meaningful.

**中文翻译:**
确实如此。我热爱优秀的 B2B 软件，我的职业生涯大部分时间都花在上面。但我同意你的看法。如果你有一个真实的使命，而不是那种“噢，当然，我们在连接世界”但实际上只是个做电话业务的初创公司。如果人们觉得使命与你所构建的东西高度契合，那将非常有意义。

---

### [00:14:11] Lenny

**English:**
Yeah. I just remember a founder who, he is a second company, because the first company did not have an amazing mission. The second one did. And like, "Wow. So much easier to hire for this new startup." So totally get that.

**中文翻译:**
是的。我记得一位创始人，这是他的第二家公司，因为第一家公司没有一个了不起的使命，而第二家有。他说：“哇，这家新公司招人容易多了。”所以我完全理解。

---

### [00:14:22] Lenny

**English:**
Okay, number two and three.

**中文翻译:**
好的，第二点和第三点呢？

---

### [00:14:23] Zoelle Egner

**English:**
Number two and three, I'll try and be more brief. Number two, I would say just the importance of relentlessly repeating the exact same stuff over and over again, even if you feel like everyone definitely knows. This is something that I've seen play out in every single leadership role that I've had, but it was never more acute than here, particularly because we had this broad coalition of hundreds of people with very different backgrounds. Some people coming to the meeting, some people not, whatever else. I think I repeated the same three talking points about why what we were doing mattered 5,000 times. Cannot overemphasize how many times I said the same stuff, and so did every other member of the board. It really is important and people will fill in the blanks with totally wild things if you don't continuously have that discipline of repeating yourself. You just have to get used to saying the same stuff. And if you do it correctly, it's super motivating. Even if you're sitting there being like, oh my gosh, "I have to say it again." it's worth it.

**中文翻译:**
第二点和第三点，我尽量简短些。第二点，我会说是“不厌其烦地重复同样的事情”的重要性，即使你觉得每个人肯定都知道了。这是我在担任过的每一个领导职位中都见证过的事情，但在这次经历中尤为突出。特别是当我们拥有这样一个由数百名背景迥异的人组成的广泛联盟时。有些人来开会，有些人不来。我想我把“我们做的事为什么重要”这三个要点重复了 5000 遍。我无法强调我说了多少遍同样的话，董事会的其他成员也是如此。这真的很重要，如果你不坚持重复，人们就会用各种离谱的想法来填补空白。你必须习惯于说同样的话。如果你做得对，它会非常有激励作用。即使你坐在那儿想：“天哪，我又要说一遍了”，它也是值得的。

---

### [00:15:22] Lenny

**English:**
This reminds me, I don't know where I saw this, it's just in my head right now, that the CEO and founder's job, their actual title is repeater in chief.

**中文翻译:**
这让我想起，我不记得在哪儿看到的了，CEO 和创始人的真实头衔应该是“首席重复官”（repeater in chief）。

---

### [00:15:22] Zoelle Egner

**English:**
It absolutely should be. I've worked with some leaders who never wanted to. They're like, "No, this is going to be boring for people." And you just have to be like, "Honestly, most people are never listening as much as you think that they are. We wish that they would. But you have to say it 12 different ways in writing, and out loud, and all this other stuff. You're never as important as you think you are, unfortunately, when it comes to that."

**中文翻译:**
绝对应该是。我合作过一些领导者，他们从不想重复。他们觉得：“不，这会让大家觉得无聊。”你只能告诉他们：“老实说，大多数人听进去的远没有你想象的那么多。我们也希望他们听，但你必须用 12 种不同的方式，通过书面、口头等各种途径去说。不幸的是，在这方面，你永远没有你想象的那么重要。”

---

### [00:15:51] Zoelle Egner

**English:**
I think my last learning was really about the power of having a laughably small MVP for something. By the end of this, we were covering the entire United States. We had an API, we had custom software on the front end, this whole behemoth of stuff that we got to in four months or something. In the beginning it was truly, basically, a spreadsheet, and phones, and that was it. Even that, for the first few weeks while we were getting the rest of the infrastructure really going, not only had tremendous impact at one of the most important parts in the pandemic, but also gave us so much information about we actually needed to build that was going to be helpful. And I remember having all of these assumptions about what was going to be necessary to manage this coalition of people to make sure that we had really good data quality.

**中文翻译:**
我想我最后的感悟是关于拥有一个“小得可笑”的 MVP（最小可行性产品）的力量。到项目结束时，我们的业务覆盖了全美。我们有 API，有定制的前端软件，在四个月左右的时间里搞出了这么个庞然大物。但在最开始，它真的基本上就是一个电子表格和几部电话，仅此而已。即便如此，在最初几周我们完善基础设施的同时，它不仅在疫情最关键的时刻产生了巨大影响，还为我们提供了大量关于“到底需要构建什么才有用”的信息。我记得当时对管理这个联盟、确保数据质量所需的东西做了各种假设。

---

### [00:16:41] Zoelle Egner

**English:**
Because one of the most important things you can do if you're trying to be a trusted source of truth is actually have the correct information. Sounds trivial, it's not at all at that scale. And I was totally wrong about all my assumptions. I thought we were going to have to have totally different types of oversight. I thought we were going to have totally different tooling. And it turned out we could do something way lighter weight that would allow us to move much faster as the regulatory landscape kept changing, as all the rule making at individual places kept changing. And that agility, that willingness to do just the smallest possible thing is obviously a little bit of a trope in the industry.

**中文翻译:**
因为如果你想成为一个值得信赖的信息源，最重要的事情之一就是拥有正确的信息。听起来微不足道，但在那种规模下一点也不简单。而我的所有假设完全错了。我以为我们需要完全不同类型的监督，以为我们需要完全不同的工具。结果证明，我们可以用更轻量级的方式来做，这让我们在监管环境和各地规则不断变化时能跑得更快。这种敏捷性，这种只做“最小可行之事”的意愿，显然是行业内的一个老生常谈了。

---

### [00:17:15] Zoelle Egner

**English:**
People talk about it a lot, but it's never been driven home to me so much, because we're talking about something that had incredibly high stakes as people's health, and we're still able to do it in that context. So if we could do it there, you can imagine that the applications of that in other industries are just tremendous. So yeah, if you're listening to this, and you were thinking maybe you needed to add more stuff, I bet you could prune.

**中文翻译:**
人们经常谈论它，但从未像这次这样让我刻骨铭心，因为我们谈论的是关乎人们健康的高风险事件，而我们依然能在这种背景下做到这一点。所以，如果我们能在那里做到，你可以想象它在其他行业的应用前景是多么巨大。所以，如果你正在听这段音频，并且觉得可能需要增加更多功能，我敢打赌你其实可以精简。

---

### [00:17:39] Lenny

**English:**
And it's nice to have the forcing function where the world is changing so quickly and the team's probably small, where you are forced to build small. Which I think is why this reminder is so important. Oftentimes you have more resources, and you end up building more just because you can. And yeah, what you're saying is oftentimes, "It'll shoot you in the foot."

**中文翻译:**
而且有一种“强制机制”挺好的，即世界变化太快，团队可能很小，你被迫只能做小。我认为这就是为什么这个提醒如此重要。通常当你拥有更多资源时，你会因为“有能力做”而做得更多。正如你所说，这往往会“搬起石头砸自己的脚”。

---

### [00:17:56] Lenny

**English:**
Amazing. I didn't expect to get into this much detail with VaccinateCA and so I'm glad we did. Let's zoom out a little bit, and just fill in some gaps on your background, briefly. Can you just highlight some of the other wonderful things you've done in career? Airtable, we talked about, VaccinateCA, just broadly, what else have you been up to?

**中文翻译:**
太棒了。我没想到会聊这么多关于 VaccinateCA 的细节，很高兴我们聊了。让我们稍微拉远一点，简要补充一下你的背景。你能介绍一下你职业生涯中其他精彩的经历吗？Airtable 我们聊过了，VaccinateCA 也聊了，除此之外你还做了什么？

---

### [00:18:13] Zoelle Egner

**English:**
Yeah, absolutely. Okay, so I'll try and be brief. I worked in tech for more than a decade, mostly marketing and customer success, a little bit of ops. Before I got into tech, I was a little bit of a dilettante, so some non-profit, healthcare, dying big box retail, because I graduated right into the recession and I was certain no one would hire me. Turns out that was actually wrong. But on the plus side, now I know what dysfunction looks like at great scale, which is actually quite an education and very useful. But I always knew I wanted to get into tech, partially because I'm from the Bay area, and partially because I had been obsessively power mapping the industry, and looking at its flocking patterns, and who had what types of influence, because I'm a nerd. And I really wanted to see if I could get in, in the first place. Because-

**中文翻译:**
好的，我尽量简短。我在科技行业工作了十多年，主要是营销和客户成功，还有一点运营。在进入科技圈之前，我有点像个“杂家”，做过非营利组织、医疗保健，甚至在垂死挣扎的大型零售店工作过，因为我毕业时正好赶上经济衰退，我确信没人会雇我。结果证明我错了。但从好的方面看，我现在知道大规模的功能失调是什么样子的，这其实是一次非常有用的教育。但我一直知道我想进入科技行业，部分原因是我来自湾区，部分原因是我一直痴迷于对这个行业进行“权力图谱分析”，观察它的“群聚模式”（flocking patterns）以及谁拥有什么样的影响力，因为我是个书呆子。我真的很想看看自己最初能不能挤进去。因为——

---

### [00:18:59] Lenny

**English:**
Wait, can you talk about this, which, what is it you did? What did you call, a flocking pattern?

**中文翻译:**
等等，你能聊聊这个吗？你做了什么？你叫它什么？群聚模式？

---

### [00:19:05] Zoelle Egner

**English:**
Sure. You can imagine in any community, there are nodes of influence, people who know a lot of folks, they have money, whatever it might be. And they're able to direct how that community or that ecosystem evolves. In the tech industry, typically VCs will often play a role in this, but so will certain types of executives. And you can follow how they move between different companies, and who they worked with, and then see that influences who gets investment in the future. It influences the different partnerships that evolve. It influences the assumed wisdom in various different careers. And because I'm a big old nerd, I was literally drawing diagrams based on reading people's blog posts of who was influential in what way? Because I was non-technical. I tried programming, and I hated it, frankly. And so I was like, "Okay, it's 2010, it's 2011. There's not clear ways to get into the industry as a non-technical person. I need to figure out how to do this with people. Because otherwise I'm not sure why someone would take a chance on me with what I have done historically. And that sounds a little insane, but it's very effective. And I ended up getting my start in tech basically by identifying a company where I thought I had a unique set of connections or understanding of the space that they were working in, where I thought I could maybe email the CEO and be helpful.

**中文翻译:**
当然。你可以想象在任何社区中都有影响力节点，即那些认识很多人、有钱或者拥有其他资源的人。他们能够引导社区或生态系统的演变。在科技行业，通常 VC 会扮演这个角色，某些类型的高管也是如此。你可以追踪他们在不同公司之间的流动，他们曾与谁共事，然后观察这如何影响未来的投资流向、合作伙伴关系的演变以及各种职业中的“公认智慧”。因为我是个超级书呆子，我真的会根据人们的博客文章画图表，分析谁在哪些方面有影响力。因为我是非技术背景，我尝试过编程，坦白说我讨厌它。所以我当时想：“好吧，现在是 2010、2011 年，作为非技术人员进入这个行业没有明确的路径。我需要通过‘人’来搞定这件事。否则，我不确定为什么有人会根据我过去的经历给我机会。”这听起来有点疯狂，但非常有效。我进入科技圈的第一步，基本上是锁定了一家公司，我觉得我对他们所处的领域有独特的联系或理解，我觉得我可以给 CEO 发邮件并提供帮助。

---

### [00:20:29] Lenny

**English:**
And did this connect to that diagram you drew? Did this help you point in that direction?

**中文翻译:**
这和你画的那个图表有关联吗？它是否帮你指明了方向？

---

### [00:20:34] Zoelle Egner

**English:**
Yeah, absolutely. So I was closely tracking YCombinator and that whole ecosystem. So I knew I wanted to find a smaller company, where they maybe were having more difficulty hiring, because they were less well known or a little bit less, I don't know, sexy. But while they were still connected into that broader group, because it has with a pedigree that people would take you seriously if you had worked at a YC backed startup. Anyway, I got really pointy hat strategic about this, but it was effective.

**中文翻译:**
是的，绝对有。我当时密切关注 YCombinator 及其整个生态系统。我知道我想找一家规模较小的公司，他们可能招聘比较困难，因为知名度不高或者没那么“性感”。但他们仍然与那个大群体保持联系，因为那种背景（pedigree）意味着如果你在 YC 支持的初创公司工作过，人们会认真对待你。总之，我在这方面做得非常有策略性，而且很奏效。

---

### [00:21:00] Lenny

**English:**
Do you still have this diagram, by the way? It'd be so funny to look at it right now.

**中文翻译:**
顺便问一下，你还有那个图表吗？现在看一定很有趣。

---

### [00:21:03] Zoelle Egner

**English:**
No, I don't think I have it anymore. I might be able to dig it up, but alas, I think it may have been lost in one of my many moves since then. It's been more than a decade.

**中文翻译:**
不，我想我没有了。我也许能翻出来，但唉，我想它可能在我后来的多次搬家中弄丢了。毕竟已经过去十多年了。

---

### [00:21:18] Lenny

**English:**
No problem.

**中文翻译:**
没关系。

---

### [00:21:20] Zoelle Egner

**English:**
Yeah, ended up using my studies of the space to get into a role as employee one at a developer focus YC backed startup. And the funny story on that is that I got that role by cold emailing the CEO while I was still in college. And then he actually followed up with me almost immediately, because I'd offered to introduce him to some professors, which was useful for the type of business. And then I ignored him for two years because I got busy with my thesis, and got other jobs, and whatever, came back to it and wrote this ridiculous apology email, being like, "I promise I respond to emails faster. I see that you're hiring. Would you give me a second chance? Please, can I come work for you? I have no experience that's useful, but I work really hard." And I figured he would either laugh me off of the internet or give me a job, and very fortunately for me, he gave me a job. So thanks, Ryan. Appreciate that. That was how I got into tech.

**中文翻译:**
是的，我最终利用对这个领域的研究，在一家面向开发者的 YC 初创公司获得了“1 号员工”的职位。有趣的是，我是大四时通过给 CEO 发冷启动邮件（cold email）得到那个职位的。他几乎立刻回复了我，因为我提出可以介绍一些教授给他认识，这对他的业务很有帮助。然后我竟然“晾”了他两年，因为我忙着写论文、找其他工作之类的。后来我回过头来写了一封荒唐的道歉信，说：“我保证以后回邮件会快点。我看到你们在招人，能给我第二次机会吗？求求了，我能去为你工作吗？我虽然没有有用的经验，但我工作非常努力。”我想他要么会把我当成笑话，要么会给我一份工作。非常幸运，他给了我工作。所以，谢谢 Ryan，非常感激。这就是我进入科技圈的经过。

---

### [00:22:11] Lenny

**English:**
Thanks, Ryan.

**中文翻译:**
谢谢 Ryan。

---

### [00:22:12] Zoelle Egner

**English:**
Yes, we appreciate it. So that startup got acquired by Box. And when I went over to Box, they had never had paying developers before. So we were bringing over seven figure contracts. So I started developer success programs there. And then in a totally wild shift, I ended up moving over to run their social media editorial and internal comms, which doesn't sound related to developer success, but I had always been a writer, and I wrote this blog post about what it was like to be an early stage non-technical employee. There was a little spicy, talking about some of the challenges, and I didn't tell anyone I was going to do it. And I got this email from PR being like, "We need to have a meeting." And I was like, "Oh, they're going to fire me. I went too far." I thought I was being circumspect, that I went too far. And in the meeting they were like, "Hey, we really think you should apply for this job. We would love to have you run social media." Which is not the outcome I expected.

**中文翻译:**
是的，我们很感激。那家初创公司后来被 Box 收购了。当我加入 Box 时，他们以前从未有过付费开发者。我们带去了七位数的合同。于是我在那里启动了“开发者成功”（developer success）计划。然后发生了一个非常疯狂的转变，我最终转去负责他们的社交媒体编辑和内部沟通。这听起来和开发者成功没关系，但我一直是个作家，我写了一篇关于作为早期非技术员工是什么感受的博客。内容有点“辛辣”，谈到了一些挑战，而且我没告诉任何人我要写。结果我收到了公关部门的邮件，说：“我们需要开个会。”我想：“噢，他们要开除我了，我写得太过火了。”我本以为自己很谨慎，结果还是过火了。但在会上他们说：“嘿，我们觉得你应该申请这个职位，我们很想让你来负责社交媒体。”这完全出乎我的意料。

---

### [00:23:05] Lenny

**English:**
That's a cool learning, there. Just like, "Do stuff." You know? "Don't be afraid."

**中文翻译:**
这是一个很酷的教训。就是“去做事”，别害怕。

---

### [00:23:08] Zoelle Egner

**English:**
Yeah, it was definitely not the expected outcome, but one that was very exciting. So got to go run those programs for a couple years through the IPO, which is a whole education in and of itself, to see how comms changes when you become a public company. And then I was on Hacker News obsessively at the time, and I saw the beta for Airtable come out. Immediately signed up, and became obsessed with the product, and evangelizing it to everybody that I knew and ultimately ended up figuring out a way to finagle my way into that role as employee 11 there.

**中文翻译:**
是的，这绝对不是预期的结果，但非常令人兴奋。于是我负责了几年这些项目，经历了 IPO，这本身就是一次完整的教育，让你看到成为上市公司后沟通方式的变化。当时我正痴迷于刷 Hacker News，看到了 Airtable 的测试版发布。我立刻注册了，并对这个产品着了迷，向我认识的每一个人宣传它，最终想方设法“混”进了公司，成为了那里的第 11 号员工。

---

### [00:23:43] Zoelle Egner

**English:**
And it sounds like we're going to talk about Airtable more, so I won't belabor that, but marketing and customer success stuff, ended up leaving for VaccinateCA, and then the last little bit here is just when that ended, I really thought I wanted to start my own company. So I gave myself a certain window in which to try out different ideas, and at the same time was advising and consulting. Ultimately didn't end up finding anything that I felt so much conviction that it was worth blowing up absolutely everything else about my life in order to go heads down on a company. So eventually decided to go in-house with one of the companies I've been advising, Block Party, and now I run marketing and growth there.

**中文翻译:**
听起来我们待会儿会多聊聊 Airtable，所以我就不赘述了。负责营销和客户成功事务后，我离开去做了 VaccinateCA。最后一点是，当那个项目结束时，我真的想过自己创业。所以我给自己留了一段时间来尝试不同的想法，同时也做咨询。最终我没有发现任何让我有足够信念值得牺牲生活中其他一切去全身心投入的项目。所以最终决定加入我一直担任顾问的一家公司 Block Party，现在我在那里负责营销和增长。

---

### [00:24:19] Lenny

**English:**
Can you just explain Block Party briefly?

**中文翻译:**
你能简要解释一下 Block Party 吗？

---

### [00:24:21] Zoelle Egner

**English:**
Absolutely. We're an online safety company. We help users have more control over their digital experience. And our first product is anti-harassment and anti-spam tools for Twitter.

**中文翻译:**
当然。我们是一家在线安全公司。我们帮助用户更好地控制他们的数字体验。我们的第一款产品是针对 Twitter 的反骚扰和反垃圾邮件工具。

---

### [00:24:30] Lenny

**English:**
So you've worked at Box, Airtable, now Block Party. You've advised a lot of companies around marketing product growth. I'm curious if there's a thread that has maintained through all of those experiences in terms of what works well for marketing, and growth, and things you've learned that just consistently-

**中文翻译:**
所以你曾在 Box、Airtable 工作，现在在 Block Party。你还为很多公司提供过营销和产品增长方面的建议。我很好奇，在这些经历中，是否有一条贯穿始终的主线，关于营销和增长中哪些是有效的，以及你学到的那些始终如一的东西？

---

### [00:24:52] Zoelle Egner

**English:**
A few pieces that go into how I choose companies that create that thread. And part of this is about me wanting to match what I think I'm really good at with what will have the greatest leverage for a company that I work at. I've mentioned I'm a writer, really care about telling stories, and helping people to understand new or novel things. I also really care about product quality. I'm a little bit of a product snob. And one of my strengths is enthusiasm. So if I can't genuinely go to a customer and tell them, "This product is going to solve a real problem for you and it's going to be amazing." I can't do my job. So all of the companies that I've chosen to go to have had this foundation of an incredible product experience that maybe people didn't fully understand, and where I could come in and help connect the dots between that amazing product that's going to be really, really helpful and the opportunities for a much wider range of people to benefit from that.

**中文翻译:**
在我选择公司时，有几点构成了这条主线。部分原因是我希望将我擅长的东西与能为公司带来最大杠杆作用的东西相匹配。我提到过我是个作家，非常看重讲故事，帮助人们理解新奇的事物。我也非常看重产品质量，在产品方面有点“势利眼”。我的强项之一是热情。如果我不能真诚地对客户说：“这个产品将为你解决一个真实的问题，它会非常棒”，那我就没法工作。所以我选择的所有公司都有一个共同的基础：拥有令人惊叹的产品体验，但人们可能还没完全理解它。而我可以介入，帮助人们在“这个非常有用的产品”和“更广泛人群受益的机会”之间建立联系。

---

### [00:25:46] Zoelle Egner

**English:**
So in practice, what that means is I often end up working at companies that are in a position to really punch above their weight from a brand perspective. They're typically much lower headcount than you would ever expect. They're typically way earlier stage than you would expect, but I've been able to put together a brand or an experience that allows people to invest themselves into the company with a high level of trust, I guess. I'll be more specific because that's really ambiguous. Airtable, it manages mission critical workflows, highly sensitive data. It's super important. You only use tools you can trust for that type of thing. The same thing is true at Block Party, online safety. You have to trust the company that you're entrusting your safety to. In my experience, people, and especially founders really underestimate how much every single touchpoint a customer has from word of mouth or the ad that brings them in the door, landing pages, signup flows, customer service experiences. Every single one of those moments is building a brand that is adding or removing trust.

**中文翻译:**
在实践中，这意味着我最终往往会在那些能够从品牌角度“以小博大”的公司工作。它们的员工人数通常比你预想的要少得多，阶段也比你预想的要早得多，但我能够打造出一种品牌或体验，让人们能够带着高度的信任投入到这家公司中。我具体说明一下，因为这听起来很模糊。Airtable 管理着关键任务的工作流和高度敏感的数据，这非常重要。你只会使用你信任的工具来处理这类事情。Block Party 也是如此，在线安全。你必须信任那家你托付安全的公司。根据我的经验，人们，尤其是创始人，真的低估了客户接触到的每一个触点的重要性——从口碑、带他们进门的广告、落地页、注册流程到客户服务体验。每一个瞬间都在构建品牌，要么增加信任，要么减少信任。

---

### [00:26:48] Zoelle Egner

**English:**
So for me in the early days, that means thinking about like, "What are the signals that I can provide to future customers that say, 'We understand you specifically, and our solution is designed for a person like you.' And two, that will say, 'Hey, we're actually operating on a much higher level than you might expect for a company of our size or our stage. We take this really seriously. We have all the things in place to take care of you. So you shouldn't be afraid to spend six figures or put your safety in our hands because we've got your back. We're doing this the right way.'" Has tremendous dividends when you're in a business that is often driven by word of mouth. Because if you take care of people and you follow up that brand experience with a product experience that is really powerful and actually does the things that says it's going to do, then your word of mouth can become a huge driver of growth for the company.

**中文翻译:**
所以对我来说，在早期阶段，这意味着要思考：“我能向未来的客户提供什么样的信号，告诉他们：‘我们特别了解你，我们的解决方案就是为你这样的人设计的’？其次，如何传达：‘嘿，我们的运营水平其实比你对这种规模或阶段的公司的预期要高得多。我们非常认真地对待这件事。我们有一切到位的措施来照顾你。所以你不必害怕花六位数或者把你的安全交给我们，因为我们是你的后盾。我们在以正确的方式做事。’”当你处于一个通常由口碑驱动的行业时，这会带来巨大的红利。因为如果你照顾好用户，并用一个真正强大、言行一致的产品体验来跟进品牌体验，那么口碑就会成为公司增长的巨大驱动力。

---

### [00:27:40] Zoelle Egner

**English:**
Of course, the outcome of this in practice is really funny. So I remember really distinctly having to invite customers to go out to lunch with us when they would come to San Francisco back in the Airtable days, because we had 15 people in a teeny tiny office. It's not that I wanted to mislead anyone, but I didn't need to reinforce the fact that they were spending six figures with us when we had 15 people. If they had gone to look on LinkedIn, they could have figured that out, but we didn't need to remind them that we were so small, and they were running some of their most important processes with our product. I think I was on the phone with Slack at one point. And they were like, "Oh, well you guys are probably about the same size company as we are, right?" And I was like, "Not quite. A little smaller, just an entire order of magnitude, no big deal, it's totally fine. We're all smooth. We'll take care of you. It's going to great." But it really makes a difference, all of those little things.

**中文翻译:**
当然，这在实践中的结果非常有趣。我清楚地记得在 Airtable 早期，当客户来到旧金山时，我不得不邀请他们出去吃午饭，因为我们当时只有 15 个人，挤在一个极小的办公室里。我并不是想误导任何人，但我没必要去强化“你们在一家只有 15 个人的公司身上花了六位数”这个事实。如果他们去查 LinkedIn，他们能查出来，但我们没必要提醒他们我们规模这么小，而他们却在用我们的产品运行一些最重要的流程。我记得有一次和 Slack 通电话，他们说：“噢，你们公司的规模大概和我们差不多吧？”我说：“不完全是，小一点，也就差了一个数量级吧，没大事，完全没问题。我们运行很稳，会照顾好你们的，一切都会很棒。”但这些小细节真的能产生大影响。

---

### [00:28:31] Lenny

**English:**
That reminds me, I heard stories of very early Airbnb days where they had to take meetings in a bathroom, or in the hallway, and they did interviews, I think in the hallway because there was no space.

**中文翻译:**
这让我想起我听过的 Airbnb 早期的故事，他们不得不在洗手间或走廊里开会，甚至在走廊里做面试，因为根本没有空间。

---

### [00:28:41] Zoelle Egner

**English:**
We did a lot of calling from the hallway at Airtable, also from this weird internal patio you could only get to through climbing through a window. The window kept breaking. And so I, at one point, remember someone getting stuck outside trying to interview someone with the windows closed. Utter, utter ridiculous nonsense. But you know, that's all the fun things that happened in the early days before you become bigger.

**中文翻译:**
在 Airtable，我们也经常在走廊里打电话，还有一个奇怪的内部露台，只能爬窗户过去。那个窗户老是坏。我记得有一次，有人被关在外面，隔着关上的窗户试图面试别人。简直是荒谬透顶。但你知道，这些都是变大之前早期阶段发生的趣事。

---

### [00:29:06] Lenny

**English:**
Yeah, I love those early day stories.

**中文翻译:**
是的，我喜欢这些早期的故事。

---

### [00:29:08] Zoelle Egner

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:29:09] Lenny

**English:**
I really love the concept of punching above your weight as a startup. What else did you do at Air Table or other places that help you do that? One is just don't let them see how small you are, necessarily. Are there any other technical things you recall that like, "Oh, here's things that really worked really well for punching above our weight as a small company at that point."

**中文翻译:**
我非常喜欢初创公司“以小博大”这个概念。在 Airtable 或其他地方，你还做了什么来帮助实现这一点？一个是不要让他们看到你有多小。你还记得其他什么具体的方法吗？比如：“噢，这些方法对于当时作为一家小公司超水平发挥非常有效。”

---

### [00:29:29] Zoelle Egner

**English:**
A couple of these things are very unsexy, but very useful. One, make sure that your landing pages, and your emails, and other things have a level of polish that makes them feel a little bit more done. I think there is sometimes a recommendation or an instinct just like, "Ship things super, super quickly and get them out there." And I'm not saying don't move fast. Obviously you need to move fast in the early days, but make sure someone rereads your email so that it sounds good. Invest in having a decent photo or a decent illustration. If you have sample content, this is actually a big one, sample content for your productivity app as an example. Take the time to not have it be like Jane Doe 12 times in the name list. Have it be references to your industry so that people are like, "Oh, hey. That's a joke about Steve Jobs. I'm a designer. This person is thinking about me."

**中文翻译:**
有几件事非常“不性感”，但非常有用。第一，确保你的落地页、邮件和其他东西有一定的精致度，让它们看起来更完整。我认为有时候人们有一种建议或本能，觉得“只要飞快地把东西做出来并发布出去就行”。我不是说不要快，初创阶段显然需要快，但请确保有人重读一遍你的邮件，让它听起来得体。投入一点精力弄张像样的照片或插画。如果你有示例内容——这其实非常重要，比如你的生产力工具里的示例——花点时间，别让名单里出现 12 个“张三”。让它和你的行业相关，这样人们会觉得：“噢，嘿，这是个关于史蒂夫·乔布斯的梗。我是个设计师，这家伙懂我。”

---

### [00:30:20] Zoelle Egner

**English:**
It's small stuff, but it tells that person, like, "The people who worked on this were thinking about me as a customer, they built it with me in mind, and that means that it is more likely that this is going to fit my needs than something generic." And that builds up both the brand trust that we've talked about, but also the personality of the company, and makes people want to root for you. And frankly, when you are small, you need everyone rooting for you that you can possibly get.

**中文翻译:**
这些都是小细节，但它在告诉用户：“开发这个产品的人在考虑我这个客户，他们是为我而造的，这意味着它比那些通用的东西更可能满足我的需求。”这不仅建立了我们谈到的品牌信任，还塑造了公司的个性，让人们想要支持你。坦白说，当你还很弱小时，你需要尽可能争取到每一个支持你的人。

---

### [00:30:45] Zoelle Egner

**English:**
Those little bits of polish that don't take a ton of time are absolutely worth it. The last thing I would say is making sure that in your public communications launches, if you ever talk to press, which some companies can and some companies can't, having more of a point of view than just about your product, you can try and say, like, "We are part of something bigger. Here's the broader circle or movement that we are a part of." It makes it feel more inevitable and more like you're not just self servingly talking about your tiny corner of the world, but that it's actually part of this much bigger trend. It will be more compelling and it feels like you're operating at a different level of sophistication that can be really helpful.

**中文翻译:**
这些不需要花费大量时间的小修小补绝对是值得的。最后我想说的是，在你的公开沟通或发布活动中，如果你要和媒体打交道（有些公司可以，有些不行），要表达出超越产品本身的观点。你可以试着说：“我们是更大事业的一部分。这是我们所属的更广泛的圈子或运动。”这会让你的产品显得更具必然性，让你看起来不只是在自私地谈论自己那一小块领地，而是大趋势的一部分。这会更有说服力，让人觉得你的运营水平更高，这非常有帮助。

---

### [00:31:28] Lenny

**English:**
I love that. On the first point, basically, it's attention to detail and obsession with quality is what I'm hearing.

**中文翻译:**
我喜欢这一点。关于第一点，我听到的是对细节的关注和对质量的执着。

---

### [00:31:34] Zoelle Egner

**English:**
Yes.

**中文翻译:**
是的。

---

### [00:31:34] Lenny

**English:**
Just to make it clear, this isn't just a tiny team just pushing the stuff out. I imagine most founders would be like, "Yes, I would love, we are going to focus on quality. We'll make sure everything looks great." In reality it always is this trade off against other things they could be doing.

**中文翻译:**
明确一下，这不仅仅是一个小团队在往外推东西。我能想象大多数创始人都会说：“是的，我愿意，我们会专注于质量，我们会确保一切看起来都很棒。”但在现实中，这总是要与他们可以做的其他事情进行权衡。

---

### [00:31:50] Zoelle Egner

**English:**
Yep.

**中文翻译:**
没错。

---

### [00:31:50] Lenny

**English:**
What do you think folks can do to help keep that level of quality high? Is it just one person being obsessed and just reviewing everything like a founder? Is having someone like you that's just very detail oriented, just review everything? How do you actually execute that when you have 1,000 things to do?

**中文翻译:**
你认为大家可以做些什么来保持高质量水平？是靠一个人像创始人一样执着地审查所有内容吗？还是找一个像你这样非常注重细节的人来审查一切？当你有一千件事要做时，你如何实际执行这一点？

---

### [00:32:05] Zoelle Egner

**English:**
100%. I'd say there's one of two approaches and you articulated them here. One is you can have the founder that is the avatar of quality, who is just relentlessly being like, "Hey, we're going to do the 15 minute check. Yes, we're going through it. Yes, I'm going to send you a copy of this email, and someone else going to click every link in it, and make sure they're not broken." Or, you can have someone else be the avatar of that who is in the company. I would say in many of the companies I have worked at, that has been me, because I've been the marketing human who cares. But it doesn't have to be a marketing person, it can be someone on product. It can be, honestly, even someone on customer success if you're willing to let them provide their feedback on the way that you're showing up in the world, which you should because they have fantastic insight. There just needs to be someone.

**中文翻译:**
百分之百同意。我会说有两种方法，你刚才都提到了。一种是让创始人成为“质量的化身”，他不厌其烦地坚持：“嘿，我们要进行 15 分钟的检查。是的，我们要过一遍。是的，我会发给你这封邮件的副本，然后让另一个人点击里面的每一个链接，确保没有坏链。”或者，你可以让公司里的其他人充当这个角色。在我工作过的许多公司里，那个人就是我，因为我是那个在乎这些的营销人员。但不一定非得是营销人员，也可以是产品人员。老实说，甚至可以是客户成功人员，如果你愿意让他们对公司呈现给世界的方式提供反馈的话——你应该这样做，因为他们有极佳的洞察力。总之，必须得有这么一个人。

---

### [00:32:50] Zoelle Egner

**English:**
And I think building that into how you interview can be very helpful, as well. So finding people who understand those trade-offs and that balance, and who are willing to put in the extra 15 minutes, but aren't going to spend an extra week trying to obsessively QA everything. You don't want to go that far. Just who has that bent towards detail can be very helpful. Also, just make yourself a checklist. It doesn't have to be complicated. "Every time we put out a blog post, these are the three things we're going to do. Every time we send out an email, it needs to be seen by at least one other person." None of this is rocket science. You just need to make a little process for yourself, and then it can be very fast and lightweight, but the dividends are worth it, I think.

**中文翻译:**
我认为把这一点融入到面试中也会非常有帮助。寻找那些理解权衡和平衡的人，他们愿意多花 15 分钟，但不会花一整周时间去偏执地对所有内容进行 QA（质量保证）。你不想走得那么极端。只要有这种注重细节的倾向就会很有帮助。另外，给自己列个清单。不需要很复杂。“每次发布博客，我们要做的三件事。每次发送邮件，必须至少由另一个人看过。”这些都不是什么高深科学。你只需要为自己建立一个小流程，它可以非常快速和轻量，但我认为带来的回报是值得的。

---

### [00:33:31] Lenny

**English:**
I like how simple this is, just to look like a bigger company, is just pay attention and focus on the little things. It's not a big, whole thing.

**中文翻译:**
我喜欢这种简单的方法，为了看起来像一家大公司，只需关注并聚焦于小事。这并不是什么宏大的工程。

---

### [00:33:39] Zoelle Egner

**English:**
There are some bigger things you can do if you really need to. My favorite silly example of this is Airtable, back in the day, got roasted on Twitter for having billboards that were not super specific about a specific problem or whatever. They were just billboards that we had out. And everyone was like, "This makes no sense. Why are you doing this? We don't understand." They were actually super effective for us because we had a different goal than everyone thought that we did.

**中文翻译:**
如果真的需要，你也可以做一些更大的动作。我最喜欢的“傻瓜式”例子是 Airtable。当年我们在 Twitter 上因为投放广告牌被嘲讽，因为那些广告牌并没有针对某个具体问题。它们就是我们挂在那里的广告牌。大家都说：“这毫无意义，你们为什么要这么做？我们看不懂。”但实际上它们对我们非常有效，因为我们的目标和大家想的完全不一样。

---

### [00:34:03] Zoelle Egner

**English:**
For us, it was all about signaling to some very large companies that we were a legitimate and large enough company that they could trust, and we had geographical concentration in specific areas, because we were in the fashion industry, the media industry in New York, we knew exactly where all of their offices were and we knew if they saw our billboards, walking to work, and then got the request to IT for the budget in order to pay six figures for Airtable, they were more likely to be like, "Oh, it's not just some weird startup we never heard of." Like, "Oh, I've seen that billboard, they must be legitimate." And that sounds really silly, but it wasn't actually that expensive.

**中文翻译:**
对我们来说，这完全是为了向一些大公司发出信号，表明我们是一家合法且规模足够大、值得信赖的公司。我们在特定区域有地理上的集中投放，比如纽约的时尚业和媒体业，我们确切知道他们的办公室在哪里。我们知道，如果他们在上班路上看到我们的广告牌，然后收到向 IT 部门申请六位数预算购买 Airtable 的请求时，他们更有可能觉得：“噢，这不只是个没听说过的奇怪初创公司。”而是：“噢，我见过那个广告牌，他们一定是正规公司。”这听起来很傻，但其实并没那么贵。

---

### [00:34:40] Zoelle Egner

**English:**
We got mostly remnant inventory, which is at the end of a particular buying cycle. Sometimes they haven't fully sold everything, and you can get the slightly less good ones that are still maybe where you want them for really cheap. And everyone thinks that you only buy billboards if you're huge. So that small signaling thing was a way for us to make sure that we remove some of the risk of not being able to close deals because we were so small. So you can get creative about it. Most of the time you're not going to do that. Most of the time it's like, "Reread your emails." But you could also push it even further if you need to.

**中文翻译:**
我们买的大多是“剩余库存”（remnant inventory），也就是在特定购买周期结束时剩下的。有时候他们没卖完，你可以用非常便宜的价格买到那些位置稍差但依然符合你要求的广告位。大家都觉得只有巨头才会买广告牌。所以这种小小的信号传递方式，让我们消除了因为规模太小而无法成交的部分风险。所以你可以发挥创意。大多数时候你不需要这么做，大多数时候只需要“重读邮件”。但如果需要，你也可以做得更进一步。

---

### [00:35:12] Lenny

**English:**
What is that full rough cost of billboards like? Because I think people think about billboards and it's hard to even know what they cost. What's a number?

**中文翻译:**
广告牌的大致总成本是多少？因为我觉得人们想到广告牌时，很难想象它们到底要花多少钱。能给个数字吗？

---

### [00:35:20] Zoelle Egner

**English:**
It really, really depends, so I'm hesitant to give you a number because which metro you're in, it ranges vastly. I would say you can expect that some of that inventory is in the low thousands of dollars, which is way lower than you might expect.

**中文翻译:**
这真的非常取决于具体情况，所以我不太敢给你一个确切数字，因为不同城市的差异巨大。我想说的是，你可以预期某些库存的价格在几千美元左右，这比你想象的要低得多。

---

### [00:35:34] Lenny

**English:**
For one billboard.

**中文翻译:**
是一个广告牌的价格吗？

---

### [00:35:36] Zoelle Egner

**English:**
Yeah. So you don't need to get a million. And I'm not suggesting you go get one on 101. Good luck to you on that. That's expensive. But you can get one in a reasonable neighborhood in New York for way less money than you might expect, if you're willing to do remnant.

**中文翻译:**
是的。所以你不需要买一百个。我不是建议你去 101 公路边买一个，祝你好运，那非常贵。但如果你愿意买剩余库存，你可以在纽约一个不错的地段以远低于预期的价格买到一个。

---

### [00:35:52] Lenny

**English:**
Are you hiring? Or on the flip side, are you looking for a new opportunity? Well, either way, check out lennysjobs.com/talent. If you're a hiring manager, you can sign up and get access to hundreds of hand curated people who are open to new opportunities. Thousands of people apply to join this collective, and I personally review and accept just about 10% of them. You won't find a better place to hire product managers and growth leaders. Join almost 100 other companies who are actively hiring through this collective.

**中文翻译:**
你正在招聘吗？或者反过来，你正在寻找新机会吗？无论哪种情况，请查看 lennysjobs.com/talent。如果你是招聘经理，你可以注册并接触到数百名经过人工筛选、正在寻找新机会的人才。成千上万的人申请加入这个人才库，而我个人只审核并接受其中约 10% 的人。你找不到比这更好的地方来招聘产品经理和增长领导者了。加入近 100 家正在通过这个人才库积极招聘的公司吧。

---

### [00:36:22] Lenny

**English:**
And if you're looking around for a newer opportunity actively or passively join the collective, it's free. You can be anonymous and you can even hide yourself from specific companies. You can also leave any time and you'll only hear from companies that you want to hear from. Check out lennysjobs.com/talent.

**中文翻译:**
如果你正在主动或被动地寻找新机会，请加入这个人才库，它是免费的。你可以保持匿名，甚至可以对特定公司隐藏自己。你也可以随时退出，并且只会收到你感兴趣的公司的消息。请访问 lennysjobs.com/talent。

---

### [00:36:41] Lenny

**English:**
Following this thread a bit, my next question is, and this may be the answer, is when you think about Airtable's growth strategy, growth tactics over time, what would you say are one, or two, or three of the most impactful marketing or growth tactics that work best over time? And maybe billboards are one of them.

**中文翻译:**
顺着这个思路，我的下一个问题是（也许刚才那个就是答案）：当你回顾 Airtable 历年来的增长策略和战术时，你会说哪一两个或三个营销/增长战术在长期内效果最好、影响最大？也许广告牌就是其中之一。

---

### [00:37:02] Zoelle Egner

**English:**
I wouldn't say they were the highest ROI, but they're certainly one of the more interesting things that we did. They were useful, don't get me wrong. But I think maybe some other ones are more interesting. The boring answer that I will caveat this with is that one of the pieces of our acquisition playbook, it was very standard, that did work quite well, was some unconventionally targeted Facebook ads. That era is over. So don't expect that that is going to work for your B2B business now because that that's totally changed.

**中文翻译:**
我不会说它们的 ROI 最高，但它们肯定是我们做过的更有趣的事情之一。别误会，它们很有用。但我认为其他一些可能更有趣。我要先说明一个枯燥的答案：我们获客手册中有一个非常标准但确实效果很好的部分，那就是一些“非传统定向”的 Facebook 广告。那个时代已经结束了。所以不要指望这现在还能在你的 B2B 业务中奏效，因为情况已经完全变了。

---

### [00:37:29] Lenny

**English:**
And when you say unconventional, what do you mean?

**中文翻译:**
你说的“非传统”是指什么？

---

### [00:37:31] Zoelle Egner

**English:**
We spent a lot of time thinking about a psychographic profile for our users. So the challenge of Airtable is that you can use it for anything. It can be used in every department within an organization. It can be used for personal stuff, you name it, it has a use, because you're functionally building your own software and you can build software for anything. Unfortunately, if you go out to the market with a message of, like, "Build your own software." The vast majority of people are like, "I want to do that. That sounds hard. That sounds stupid. No."

**中文翻译:**
我们花了很多时间思考用户的“心理特征画像”（psychographic profile）。Airtable 的挑战在于你可以用它做任何事。它可以用于组织内的每个部门，可以用于个人事务，只要你能想到的都有用，因为你实际上是在构建自己的软件，而你可以为任何事情构建软件。不幸的是，如果你带着“构建你自己的软件”这样的信息走向市场，绝大多数人的反应是：“我才不想做那个，听起来很难，听起来很蠢。不。”

---

### [00:38:01] Zoelle Egner

**English:**
And we couldn't really use super generic messaging, but to go really specific into verticals, which we did end up ultimately doing, didn't give us the broad coverage to go find new opportunities. You go really deep into one particular vertical or two particular verticals at a time with a small team, but then we weren't surfacing new opportunities that might be even more important. So we tried to balance that vertical specific work that we did with also trying to find this type of person who we had discovered was going to be the best champion for us.

**中文翻译:**
我们不能使用超级通用的信息，但如果走得太垂直（我们最终确实这么做了），又无法提供广泛的覆盖面去寻找新机会。如果你让一个小团队一次只深耕一两个特定垂直领域，我们就无法发现那些可能更重要的新机会。所以我们试图在垂直领域的工作与寻找“那种我们发现会成为我们最佳拥护者的人”之间取得平衡。

---

### [00:38:33] Zoelle Egner

**English:**
And this is a tinkerer persona, someone who likes new technology, they like putting together the Lego building blocks of things, and you couldn't really find Tinkerer's Magazine. There's not like a place those people hang out. They don't just have one title. It's a psychographic profile as a type of person that could have many, many different roles. And so instead-

**中文翻译:**
这是一种“捣鼓者”（tinkerer）人格，这种人喜欢新技术，喜欢把乐高积木一样的东西拼凑在一起。你找不到《捣鼓者杂志》，没有一个专门供这些人聚集的地方。他们不只有一种头衔。这是一种心理特征画像，这种人可能担任许多不同的角色。所以，我们没有——

---

### [00:38:56] Lenny

**English:**
And Facebook doesn't let you do that anymore, right?

**中文翻译:**
Facebook 现在不让你这么做了，对吧？

---

### [00:38:59] Zoelle Egner

**English:**
No. You can't target based on-

**中文翻译:**
是的，你不能基于——

---

### [00:39:01] Lenny

**English:**
[inaudible 00:39:01] go.

**中文翻译:**
（听不清）

---

### [00:39:02] Zoelle Egner

**English:**
... like, "They have a tinkerer mentality," unfortunately.

**中文翻译:**
……不幸的是，你不能基于“他们有捣鼓者心态”来定向。

---

### [00:39:04] Lenny

**English:**
Okay, got it.

**中文翻译:**
好的，明白了。

---

### [00:39:05] Zoelle Egner

**English:**
It's so sad.

**中文翻译:**
太遗憾了。

---

### [00:39:05] Lenny

**English:**
Okay. I see that it's not possible.

**中文翻译:**
好的，我明白现在不可能了。

---

### [00:39:07] Zoelle Egner

**English:**
Yeah. But what you can do is you can say, "That type of person often likes these types of media. We've heard that they often are really into these podcasts, so they're really into reading about this type of personal development." And often that is associated with people who have these broad set of roles but have this typical mentality. So we would find clusters of interests that people might have, that often were shared by those people, and do targeting around that. And then when that worked, they'll look alike based on it.

**中文翻译:**
是的。但你可以说：“那类人通常喜欢这些类型的媒体。我们听说他们通常很迷这些播客，或者很喜欢读这类个人成长的文章。”通常这些兴趣与那些拥有广泛角色但具备这种典型心态的人相关联。所以我们会寻找人们可能拥有的兴趣集群（这些兴趣通常由那类人共享），并围绕这些进行定向。一旦奏效，就基于此进行类似受众（lookalike）扩展。

---

### [00:39:38] Lenny

**English:**
Did not expect Facebook ads as one of these answers. So that's interesting.

**中文翻译:**
没想到 Facebook 广告会是答案之一。这很有趣。

---

### [00:39:42] Zoelle Egner

**English:**
No, and it's not a good idea anymore. Don't do it now.

**中文翻译:**
是的，而且现在这不是个好主意了。现在别这么做。

---

### [00:39:44] Lenny

**English:**
Disclaimer.

**中文翻译:**
免责声明。

---

### [00:39:44] Zoelle Egner

**English:**
Back in the day, it was great. Now I would not recommend. But I have some unconventional ones that I can suggest that are not Facebook. There's a few different things, but I want to give some context first for people who are not as familiar with Airtable's business, because I do think these are really helpful pieces of context. The first is because of the types of industries that we are often very successful in, had a very similar network effect that we would see, where basically it was within specific professions, we would see people who, in order to distinguish themselves in that job market, would build a brand around the tools that they used, essentially.

**中文翻译:**
当年它很棒，现在我不推荐。但我可以建议一些非 Facebook 的非传统方法。有几件不同的事，但我想先为那些不太熟悉 Airtable 业务的人提供一些背景，因为我认为这些背景非常有帮助。第一，由于我们经常取得成功的行业类型，我们看到了一种非常相似的网络效应：基本上在特定的职业中，我们会看到人们为了在就业市场中脱颖而出，会围绕他们使用的工具建立个人品牌。

---

### [00:40:46] Zoelle Egner

**English:**
We found different ways to accelerate their process of identifying those roles, where it was really, really helpful to build a brand for yourself so that you could hop around to different jobs more quickly, accelerate your process, et cetera, and thus bring along a tool with you and evangelize for it a lot. So that's one set of things we were trying to achieve. The second set of things we were trying to achieve that's also useful context here, is although industry virality was really important for us, even more important was inside of company virality, that was the real superpower of Airtable. We'd go from 10 people to 1,000 people a year. And so we were always looking for ways to make that happen within companies in more and more efficient ways.

**中文翻译:**
我们发现了不同的方法来加速他们识别这些角色的过程。在这些角色中，建立个人品牌非常有帮助，这样你就可以更快地跳槽到不同的工作，加速你的职业进程等等，从而随身携带一个工具并大量宣传它。这是我们试图实现的一组目标。第二组目标（也是有用的背景）是：虽然行业病毒式传播对我们很重要，但更重要的是“公司内部的病毒式传播”，那是 Airtable 真正的超能力。我们会从 10 个人一年增长到 1000 个人。所以我们一直在寻找以越来越高效的方式在公司内部实现这种增长的方法。

---

### [00:41:08] Zoelle Egner

**English:**
And then the third piece here is no one had a good generic explanation of Airtable that worked for everybody. This is perhaps partially my fault as marketing, but it's also the fault of the fact that the market was not ready for the good, generic explanation to mean anything, like I mentioned before, people just did not care about the generic explanation. And the magic of Airtable was always seen in its specificity.

**中文翻译:**
第三点是，没有人能给出一个适用于所有人的、好的通用解释。这可能部分是我作为营销人员的错，但也归因于市场还没准备好接受通用的解释，就像我之前提到的，人们根本不在乎通用的解释。Airtable 的魔力总是体现在它的具体性上。

---

### [00:41:32] Zoelle Egner

**English:**
So we knew if we can get to the right people and we can connect the dots to them to the correct use case, so they want to go and evangelize to improve their careers, they will do that both externally and within their companies, and more importantly within the companies, they'll be able to go to their friends and say, "Hey, I'm using Airtable as a content calendar, but you have a UX research problem. And I understand Airtable enough that I can help you build a system. And now I'm a superhero internally because I helped you build this whole new thing. Look at me, I'm amazing." And they suddenly have fully done a sales pitch for Airtable without us having to do any work or understand their use case, which is great and very necessary when you are as horizontal as we are. So we had to figure out essentially, "How do we catalyze that word of mouth and build champions at scale?"

**中文翻译:**
所以我们知道，如果我们能找到正确的人，并为他们连接到正确的使用场景，让他们为了提升职业生涯而愿意去宣传，他们就会在外部和公司内部都这么做。更重要的是在公司内部，他们能去找朋友说：“嘿，我把 Airtable 当作内容日历用，但你有个用户体验研究的问题。我对 Airtable 足够了解，可以帮你建立一个系统。现在我在公司内部成了超级英雄，因为我帮你建立了一套全新的东西。看我多厉害。”他们突然间就为 Airtable 完成了一次完整的销售推介，而我们不需要做任何工作，也不需要了解他们的使用场景。当你像我们这样属于“横向产品”（horizontal product）时，这是非常棒且必要的。所以我们必须弄清楚：“我们如何催化这种口碑并大规模培养拥护者（champions）？”

---

### [00:42:21] Zoelle Egner

**English:**
All of that is to say the two interesting things that we did were all around that. In the very early days, what that meant in practice was we literally had a Slack integration that we pulled in a whole bunch of information about anyone who signed up for Airtable, including their title, the company that they worked at, et cetera. And literally would sit there and had a little button in each of the records that came in that would allow us to email them immediately if we had decided that they might be someone we want to talk to. And we set up this whole automated system so that it would take two seconds to reach out to a ton of different people, being like, "Hey, we'd really love to get your feedback and help make sure you're as successful as possible on Airtable."

**中文翻译:**
所有这些都是为了说明，我们做的两件有趣的事都是围绕这一点展开的。在非常早期，实践中的做法是：我们真的有一个 Slack 集成，它会抓取任何注册 Airtable 的人的大量信息，包括他们的头衔、所在公司等等。我们就坐在那儿，每条进入的记录都有一个小按钮，如果我们觉得这可能是我们想聊聊的人，就可以立即给他们发邮件。我们建立了一整套自动化系统，只需两秒钟就能联系到一大群不同的人，内容大概是：“嘿，我们非常想听听你的反馈，并确保你在 Airtable 上尽可能获得成功。”

---

### [00:43:02] Zoelle Egner

**English:**
This is not scalable in the long term because there's a whole bunch of sending emails and doing meetings. But what it meant is that we were able to start building our mental model for what these champions looked like in practice by finding the patterns across them. And building the foundation is what ultimately became our customer success motion very early. And then we were able to say, "Okay, we found five people who have a content calendar use case with this type of title. And now we'll be able to go run an ad campaign based on that. We can build a bunch of templates based on that. Here's all these different hooks we can use, because we know this is what a champion can look like," in a way that was not going to be obvious if we hadn't talked to a ton of people. So it seems really unobvious as an investment, per se, but tremendous number of human hours going into just having an efficient way to talk to as many people as possible to build those mental models. That's number one.

**中文翻译:**
从长期来看，这不可扩展，因为涉及大量的邮件发送和会议。但它的意义在于，我们能够通过寻找跨用户的模式，开始构建关于这些“拥护者”在实践中是什么样子的心理模型。建立这个基础最终成为了我们非常早期的“客户成功”动作。然后我们就能说：“好吧，我们找到了五个拥有这种头衔、使用内容日历场景的人。现在我们可以基于此运行广告活动，可以基于此构建一堆模板。这里有所有我们可以使用的‘钩子’，因为我们知道一个拥护者可能长什么样。”如果不和大量的人交谈，这些是不会显而易见的。所以，作为一项投资，它本身看起来并不明显，但为了建立这些心理模型，我们投入了巨大的人力工时，只为了拥有一种高效的方式与尽可能多的人交谈。这是第一点。

---

### [00:43:57] Lenny

**English:**
That is fascinating. Essentially, you weren't even sure who would be excited about Airtable. Part of this is like, "Figure out the personas and groups of people that we believe are the right target to encourage and help support." And then part of that is, "Get it spreading within a company once you figure out these folks within a company." It's such a cool idea to just have a feed of ... I imagine the squad had certain attributes of the person, like, "Here's the company they work. Here's how big it is." And then they talk about, there's a mention of what they're using it for. Is that part of this?

**中文翻译:**
这太迷人了。本质上，你甚至不确定谁会对 Airtable 感兴趣。这部分工作就像是：“找出我们认为值得鼓励和支持的正确目标画像和人群。”然后另一部分是：“一旦在公司内部找到这些人，就让它在公司内部传播开来。”这个想法太酷了，就像一个信息流……我猜那个小组能看到这个人的某些属性，比如：“这是他们工作的公司，规模有多大。”然后他们会提到他们用它来做什么。这是其中的一部分吗？

---

### [00:44:31] Zoelle Egner

**English:**
Ideally. Though we were always very privacy minded, so we couldn't actually get much information about what they were doing in Airtable. We could never see their data, because that would be a tremendous failure of trust, to go back to what we were talking about before. So a lot of this, we would have guesses, and maybe we could see that they'd use certain templates but we didn't otherwise really know. And that was part of the reason why we wanted to talk to them in the first place.

**中文翻译:**
理想情况下是这样。虽然我们一直非常注重隐私，所以我们实际上无法获得太多关于他们在 Airtable 中具体操作的信息。我们永远看不到他们的数据，因为那将是信任的巨大崩塌，回到我们之前谈论的话题。所以很多时候我们只是猜测，也许我们能看到他们使用了某些模板，但除此之外我们真的不知道。这也是我们最初想和他们交谈的部分原因。

---

### [00:44:54] Zoelle Egner

**English:**
The second reason is that if we could talk to them early, we could help them build their first space, and from there, if they were successful, they would have the tools to go and help other people within their organization. So if we catch them at the beginning, make sure one person was successful by over investing in them, then they essentially became support for everybody else. I should also clarify, these were not necessarily people who were going to be the buyers. The buyers and the champions here look very, very different for Airtable, which is a really an interesting dynamic that many companies do not have. But for us, the person who is going to sit down with a glass of wine on a Friday and build an Airtable base was not the person who had the budget who was going to pay for this thing.

**中文翻译:**
第二个原因是，如果我们能尽早与他们交谈，我们就能帮助他们建立第一个空间（base）。从那里开始，如果他们成功了，他们就有了去帮助组织内其他人的工具。所以如果我们能在开始时抓住他们，通过过度投入确保一个人成功，那么他们本质上就成了其他所有人的支持者。我还应该澄清一点，这些人不一定是“买家”。在 Airtable，买家和拥护者的形象非常不同，这是一种很多公司都没有的有趣动态。对我们来说，那个会在周五晚上端着一杯红酒坐下来构建 Airtable 库的人，并不是那个掌握预算、准备为这件东西付钱的人。

---

### [00:45:36] Zoelle Egner

**English:**
And so we weren't initially looking for buyers, we were looking for champions, in part so that we could then go to IT six months down the line and be like, "Look, you have 500 people using this product, it's been very useful for them. It is time for you to pay now." Not sure IT loved those conversations, but they were really effective for us and meant that it was very, very easy to sell.

**中文翻译:**
所以我们最初寻找的不是买家，而是拥护者。部分原因是为了六个月后我们可以去找 IT 部门说：“看，你们有 500 人在使用这个产品，对他们非常有用。现在是你们付钱的时候了。”我不确定 IT 部门是否喜欢这种对话，但对我们来说非常有效，这意味着销售变得非常、非常容易。

---

### [00:45:57] Lenny

**English:**
Fascinating. It makes me think a lot about the product led sales movement and how this is essentially that, but even earlier, because it's people just signed up and they're just helping them be successful, versus like, "This company's got 14 people using it. You should go try to sell them on an enterprise contract." Essentially this was a tool to help you figure out how to, basically scaling customer success and helping you prioritize who to go after, and being very hands-on with the strongest potential future big buyers.

**中文翻译:**
太迷人了。这让我想起很多关于“产品驱动销售”（product-led sales）运动的事情，这本质上就是那个，但甚至更早。因为人们才刚注册，你们就在帮助他们成功，而不是说：“这家公司有 14 个人在用，你应该去试着卖给他们企业级合同。”本质上，这是一个帮助你弄清楚如何规模化客户成功、并帮助你确定优先跟进对象的工具，让你能对最有潜力的未来大买家进行非常深入的指导。

---

### [00:46:24] Zoelle Egner

**English:**
Exactly. And I think what's interesting here is it helped us bootstrap two things. One was, to your point, building out the personas, and champions, and so on. And ultimately there's more scalable ways to reach those people in the long run. But secondarily, it also helped us deal with a real product education problem that we had in the early days. Because it was really complicated. Airtable, unfortunately, has two education issues that it needs to solve. It's not just, "How do I put the Lego blocks together?" It is also, "How do I design a piece of software and a workflow?"

**中文翻译:**
没错。我认为有趣的是，它帮助我们冷启动了两件事。第一是如你所说，构建了用户画像、拥护者等等。从长远来看，最终会有更具扩展性的方式来触达这些人。但其次，它还帮助我们处理了早期遇到的真实的产品教育问题。因为它真的很复杂。不幸的是，Airtable 需要解决两个教育问题。不仅仅是“我如何把乐高积木拼在一起？”，还有“我如何设计一个软件和一套工作流？”

---

### [00:47:01] Zoelle Egner

**English:**
And unfortunately if you're selling to content marketing manager or a UX researcher, there's no guarantee that they know how to make a workflow. Most software is opinionated, and it does that work for you, and you're like, "It either works for you or it doesn't." And maybe you're frustrated about what it forces you to do in order to work, but you can't really control it, which means when suddenly, you have the ability to create whatever workflow that you want, there's actually some education that needs to go into it in order to be able to make that successful.

**中文翻译:**
不幸的是，如果你卖给内容营销经理或用户体验研究员，不能保证他们知道如何制作工作流。大多数软件都是“有主见的”（opinionated），它为你做好了那部分工作，你只能觉得“要么适合你，要么不适合”。也许你会对它强迫你做的事情感到沮丧，但你无法真正控制它。这意味着当你突然拥有了创建任何你想要的工作流的能力时，实际上需要进行一些教育才能使其获得成功。

---

### [00:47:28] Zoelle Egner

**English:**
It's not enough to just make an Airtable base that's pretty or that functions. You can't get your team to use it effectively if it doesn't fit into the broader context of the organization. It's still going to fail. And so a lot of this was us figuring out, like, "Okay, how do we help these people not only use our product but build something that is going to be durable, so that we do see that growth, so they don't see it as a failure, so it doesn't fail at that second order moment when it starts to get spread out to more people?"

**中文翻译:**
仅仅制作一个漂亮或功能齐全的 Airtable 库是不够的。如果它不符合组织的更广泛背景，你就无法让团队有效地使用它。它仍然会失败。所以很多工作是我们在摸索：“好吧，我们如何帮助这些人不仅使用我们的产品，而且构建出持久的东西，从而让我们看到增长，让他们不觉得这是个失败，让它在开始传播给更多人的那个‘二阶时刻’不会崩掉？”

---

### [00:47:53] Lenny

**English:**
It's a really good tactic for any SaaS product that just is hard to understand and needs, Airtable had both problems. Like, "I don't know what this is for and I don't know exactly how it's going to fit into my workflow." Imagine most companies still have to deal with both those problems.

**中文翻译:**
对于任何难以理解且需要引导的 SaaS 产品来说，这都是一个非常好的策略。Airtable 当时两个问题都有：“我不知道这是干什么用的”以及“我不知道它到底该如何融入我的工作流”。我想大多数公司仍然需要处理这两个问题。

---

### [00:48:05] Zoelle Egner

**English:**
No, hopefully not. Hopefully not.

**中文翻译:**
不，希望不是，希望不是。

---

### [00:48:07] Lenny

**English:**
Yeah.

**中文翻译:**
是的。

---

### [00:48:08] Zoelle Egner

**English:**
But once you actually get in with folks, it's very difficult to remove it. So suddenly your retention rates are incredible, your word of mouth is incredible, if you're willing to do that initial work. A lot of people think that Airtable was a pure product led growth company, and missed that huge customer success component that was always very, very important in the early days. And that helped us ultimately move more towards that PLG motion for a while, but was essential to getting it set up in the first place.

**中文翻译:**
但一旦你真正深入到用户中，就很难被取代了。所以如果你愿意做那些初始工作，突然间你的留存率会变得惊人，口碑也会变得惊人。很多人认为 Airtable 是一家纯粹的“产品驱动增长”（PLG）公司，却忽略了早期一直非常、非常重要的巨大的“客户成功”组成部分。这帮助我们最终在一段时间内更多地转向 PLG 模式，但对于最初的建立至关重要。

---

### [00:48:35] Lenny

**English:**
Fascinating.

**中文翻译:**
太迷人了。

---

### [00:48:36] Zoelle Egner

**English:**
The other one that we did related to this champions at scale was we spent a hilarious amount of money on really fancy swag. I know this sounds silly, but branded AirPods level of fancy swag. Admittedly more people were in the office back then. Now they are more remote and this would not work as well. But back in the day, if you gave people something really good, not a pen or a sticker, really good, they would show it off to absolutely everyone that they talked to, because they were so excited they got branded AirPods. People would ask about it, walking by their desks. It sounds so like trivial. But for that couple hundred bucks that we spent knowing like, "Hey, this person's already a champion and if someone asks them, they're going to give a really good pitch." Totally worth it. Sometimes better to not skimp on swag. Hard to measure, very effective.

**中文翻译:**
另一件与“大规模培养拥护者”相关的事是，我们在非常高档的周边（swag）上花了多得离谱的钱。我知道这听起来很傻，但那是印有品牌 Logo 的 AirPods 级别的周边。诚然，那时候更多人在办公室上班，现在大家更倾向于远程办公，这可能没那么奏效了。但在当年，如果你给人们一些真正好的东西——不是笔或贴纸，而是真正的好东西——他们会向每一个交谈的人炫耀，因为他们为得到印有 Logo 的 AirPods 而兴奋不已。人们走过他们的办公桌时会问起。这听起来很琐碎，但对于我们花的那几百美元来说，知道“嘿，这个人已经是拥护者了，如果有人问起，他们会做一次非常棒的推介”，这完全值得。有时候最好不要在周边上省钱。虽然难以衡量，但非常有效。

---

### [00:49:27] Lenny

**English:**
That's a great tip. And it connects to the general idea of find your champions and just do a lot to make sure they're successful, excited, want to evangelize, and an AirPod here and there feel like a really good ROI investment.

**中文翻译:**
这是一个很好的建议。它契合了“寻找你的拥护者并尽一切努力确保他们成功、兴奋、想要宣传”的总思路。偶尔送个 AirPods 感觉是一项投资回报率非常高的投资。

---

### [00:49:40] Zoelle Egner

**English:**
Was for us.

**中文翻译:**
对我们来说确实如此。

---

### [00:49:41] Lenny

**English:**
Anything else along those lines?

**中文翻译:**
还有其他类似的吗？

---

### [00:49:42] Zoelle Egner

**English:**
I think those are the big ones that I would highlight. The only other small note I would make from a process perspective is if you are going to overinvest in customer success, which I recommend, make sure that you have also set up a process to take the insights that your customer success people are coming up with and turn them into as much content as you can. Because that's where you're going to find scale in the long run. So for us, what that meant was we would talk to a bunch of customers and then customer success would have helped them build bases, and then we would create templates. So were not exact copies, because we're not trying to steal their intellectual property. We would say, "What is the fundamental workflow here, that other companies might have? How do we make a template that is useful from this?" And some blog posts that explain it, whatever else, that we can then put out into the market.

**中文翻译:**
我想这些是我要强调的重点。从流程角度来看，我唯一想补充的一点是：如果你打算在客户成功上过度投入（我推荐这样做），请确保你也建立了一套流程，将客户成功人员获得的洞察转化为尽可能多的内容。因为那是你长期实现规模化的地方。对我们来说，这意味着我们会和一群客户交谈，客户成功人员会帮助他们建立库，然后我们会创建模板。这些不是完全的复制，因为我们不想窃取他们的知识产权。我们会问：“这里的基础工作流是什么，其他公司可能也会有吗？我们如何制作一个基于此的有用模板？”再加上一些解释它的博客文章之类的，然后推向市场。

---

### [00:50:25] Zoelle Egner

**English:**
And the next time a smaller company that's not a Fortune 500 wants this sort of thing, someone can just email them that template and we don't have to go through this whole build process, they have something to start with. If you can find those insights and put them genuinely into use as a little conveyor belt, it will be much easier to scale. It will be much easier to come up with genuinely compelling content because it's coming from your customers, so they already care about it. You have strong signal that's going to be valuable if you already built it for them. Use that to your advantage, make that into a little machine. And it makes all of the go-to market that you need to do later easier.

**中文翻译:**
下一次，当一家非财富 500 强的小公司想要这类东西时，有人可以直接给他们发那个模板邮件，我们就不必经历整个构建过程，他们也有了起步的东西。如果你能发现这些洞察并将其真正投入使用，像一条小传送带一样，规模化就会容易得多。产出真正引人入胜的内容也会容易得多，因为它来自你的客户，所以他们已经在乎了。如果你已经为他们构建了它，你就有了它会产生价值的强烈信号。利用这个优势，把它变成一台小机器。这会让你以后需要做的所有“进入市场”（GTM）工作变得更容易。

---

### [00:50:57] Lenny

**English:**
I know that you have the strong opinion that customer success and marketing are basically the same thing and should be maybe one team. Can you speak to that?

**中文翻译:**
我知道你有一个强烈的观点，认为客户成功和营销本质上是同一件事，也许应该合并为一个团队。你能谈谈这个吗？

---

### [00:51:05] Zoelle Egner

**English:**
Yeah. This is my spicy opinion, but both of them have to do the same things. They have to identify customer needs. They have to help the customers see your product as a solution to those needs. They need to remove friction from the process of getting value. They are hopefully both encouraging those customers to share with other people, and both of them should be engaged in translating insights from those individuals into resources that can help everybody. They use different tactics. Marketing is going to use more scalable tactics. Customer success is going to be in the weeds, really talking to individual people, but all of the things they care about are actually the same thing. They just use different ways to do it.

**中文翻译:**
是的。这是我的“辛辣”观点，但两者确实都在做同样的事情。他们必须识别客户需求。他们必须帮助客户将你的产品视为这些需求的解决方案。他们需要消除获取价值过程中的摩擦。希望他们都在鼓励客户与他人分享，并且两者都应该致力于将个人的洞察转化为能帮助所有人的资源。他们使用不同的战术。营销会使用更具扩展性的战术。客户成功会深入细节，真正与个人交谈，但他们关心的所有事情实际上是同一件事。他们只是使用不同的方式来实现。

---

### [00:51:31] Zoelle Egner

**English:**
And if you, as a marketer, are not pretty confident in being able to say, like, "What I'm doing is getting the right people to get genuine value from this product," so much so that they want to tell other people about it because it's going to make them look good, then maybe figure out if there's ways to bring more of that to your process, because it will make what you are doing more effective. And frankly, there's not a better evangelist than a person whose career you have materially helped to improve based on matching the right person to the solution so that they can have more impact at their company. So much said, one of my unofficial metrics for both marketing and customer success at Airtable, unofficial, was how many people we'd gotten promoted for using the product. I had a running tally of those people, and I knew if we were getting those at the major accounts we were trying to win, something good was happening and we were going to be successful with really large deals.

**中文翻译:**
如果你作为一个营销人员，不能很有信心地说：“我正在做的事情是让正确的人从这个产品中获得真正的价值”，以至于他们想告诉别人，因为这会让他们显得很优秀，那么也许该想想办法在你的流程中增加更多这样的环节，因为这会让你所做的事情更有效。坦白说，没有比一个因为你把正确的解决方案匹配给正确的人、从而在公司产生更大影响力、职业生涯得到实质性提升的人更好的宣传者了。说了这么多，我在 Airtable 时对营销和客户成功的一个非正式指标（非正式的！）就是：有多少人因为使用该产品而获得了晋升。我有一个这些人的滚动统计表，我知道如果我们能在试图赢取的主要大客户中看到这些人，那么好事正在发生，我们将成功签下真正的大单。

---

### [00:52:36] Lenny

**English:**
So curious how you tracked that. I guess you just check in with them occasionally?

**中文翻译:**
很好奇你是怎么追踪这个的。我猜你只是偶尔跟进一下？

---

### [00:52:40] Zoelle Egner

**English:**
No, I had my CSMs literally, they had really strong relationships. We were actually tracking it. It was a little embarrassing, but it worked really well.

**中文翻译:**
不，我让我的 CSM（客户成功经理）去跟进，他们有非常牢固的关系。我们真的在追踪。虽然有点不好意思，但效果非常好。

---

### [00:52:47] Lenny

**English:**
I love it, with the great KPI. It's like dating apps and how many people get married, I guess.

**中文翻译:**
我喜欢这个，伟大的 KPI。我想这就像约会软件追踪有多少人结婚了一样。

---

### [00:52:52] Zoelle Egner

**English:**
Exactly.

**中文翻译:**
没错。

---

### [00:52:53] Lenny

**English:**
Zooming out a little bit, you advise a lot of companies on marketing, customer success, growth, and things like that. Maybe there's a two part question, and see where you want to take it. One is just what are activities that marketing, and growth, and customer success teams often do that are impactful and consistently impactful, things that you think startups should invest in that maybe they aren't, or they already aren't and they should definitely keep doing this. And on the flip side, things that don't work, things that maybe they should avoid. So maybe let's start there and there's going to be a followup.

**中文翻译:**
稍微拉远一点，你为很多公司提供营销、客户成功、增长等方面的咨询。也许这是一个由两部分组成的问题，看你想怎么回答。第一，营销、增长和客户成功团队经常做的哪些活动是具有影响力且持续有效的？你认为初创公司应该投入但可能还没投入的，或者已经在做且绝对应该坚持下去的是什么？反过来说，哪些是不起作用的，哪些是他们可能应该避免的？我们先从这里开始，稍后会有跟进。

---

### [00:53:26] Zoelle Egner

**English:**
Cool. Okay. I'm going to start with things to avoid, because I try and not to make too many blanket statements on this, but I have a couple that I am willing to make. So this is all with the caveat that channel market fit is really real, and sometimes these things might work for you. Don't discount just because I say that they don't work for me. There are certain types of flashy event marketing and sponsorships that you will get relentlessly invited to do, that will seem like they're going to be really great for signaling purposes, or for leads, or whatever.

**中文翻译:**
酷，好的。我先从应该避免的事情开始，因为我尽量不对这类事情做太多一概而论的陈述，但我有几个愿意分享。当然，前提是“渠道市场契合度”（channel market fit）是真实存在的，有时候这些事情可能对你有效。不要仅仅因为我说它们对我无效就全盘否定。你会不断被邀请参加某些类型的花哨活动营销和赞助，它们看起来似乎对传递信号、获取线索或其他什么非常有好处。

---

### [00:53:55] Zoelle Egner

**English:**
And they're almost always a waste of your time, unless you are in an industry where you desperately need to get to a trade show, because that's where everyone hangs out. At that point, yeah, of course you're going to have to go do that. But if you're in more standard B2B SaaS, or that's not really a thing, there are better ways to get in front of those people than having your logo out there. That doesn't tell them anything. Maybe you get a branded session at the conference or whatever, but who's going to go to that branded session? Probably not that many people. And then you will have spent so much money and gotten nothing for it. Go to the event, do not fund your money on the sponsorship. It's stupid. And then the second one, which is definitely a very spicy opinion, but I'm going to go there.

**中文翻译:**
但它们几乎总是浪费时间，除非你所在的行业迫切需要参加贸易展，因为那是所有人聚集的地方。在那时，是的，你当然得去。但如果你是在更标准的 B2B SaaS 领域，或者那不是什么大事，那么除了把你的 Logo 挂在那儿，还有更好的方法出现在那些人面前。Logo 告诉不了他们任何信息。也许你在会议上得到了一个品牌专场之类的，但谁会去参加那个品牌专场？可能没多少人。然后你会花了很多钱却一无所获。去参加活动，但不要把钱花在赞助上。那很愚蠢。第二个，这绝对是一个非常辛辣的观点，但我还是要说。

---

### [00:54:40] Lenny

**English:**
Go there.

**中文翻译:**
说吧。

---

### [00:54:41] Zoelle Egner

**English:**
A lot of people think that the epitome of product marketing is creating your own category. And while I agree that it is useful to have strong differentiators, because it is, I think creating a category, getting a new thing in Gartner or whatever, is often a waste of your time. It is a huge lift, absolutely enormous, particularly in B2B SaaS, and I'm not always sure that it's helpful to have your super teeny tiny, little niche over here where you're like, "Oh, we have no competitors." That's not actually how buyers work. It's not really worth it.

**中文翻译:**
很多人认为产品营销的极致是“创建你自己的类别”。虽然我同意拥有强大的差异化因素很有用，但我认为创建一个类别、在 Gartner 报告中搞出一个新东西之类的，往往是浪费时间。这是一项巨大的工程，绝对巨大，特别是在 B2B SaaS 领域。而且我不确定拥有一个超级微小的利基市场（然后说“噢，我们没有竞争对手”）是否真的有帮助。买家实际上不是那样运作的。这真的不值得。

---

### [00:55:21] Zoelle Egner

**English:**
That said, there are things you can do that feel like category creation that are actually effective, and that I do think make more sense. And specifically if you can elevate a profession instead of a category, that can make way more sense. So the great example of this is that Gainsight creating customer success or many companies altogether carving out DevOps, or rebranding DevOps, to be a thing that was suddenly a sexy job to have.

**中文翻译:**
话虽如此，有些事情做起来感觉像是在创建类别，而且确实有效，我认为更有意义。具体来说，如果你能提升一个“职业”而不是一个“类别”，那会更有意义。一个很好的例子是 Gainsight 创建了“客户成功”这个职业，或者许多公司共同开辟了 DevOps，或者重新定义了 DevOps，使其突然变成了一份很酷的工作。

---

### [00:55:47] Zoelle Egner

**English:**
And I think that's valuable because a job is an identity and people will fight for an identity. A category of software is a line item on your budget. No one is excited about that. But people are very excited about their job being meaningful, and their job being important, and being taken seriously. And so if you could hold up either an existing or a brand new job and say, "This is really important for much broader business metrics, whatever else. We're going to create community for those people to come together and it's all about the job," and not about you. That can be very powerful and they'll take them with you. You become part of the identity of that career. Amazing. Do that, for sure. But like the Gartner Square, there's some opportunities for that where it makes sense. A lot of the times it doesn't. Don't do that.

**中文翻译:**
我认为这很有价值，因为一份工作是一种身份，人们会为身份而战。而一个软件类别只是你预算中的一个条目，没人会为此感到兴奋。但人们会对自己的工作有意义、重要并被认真对待感到非常兴奋。所以，如果你能举起一份现有的或全新的工作并说：“这对更广泛的业务指标非常重要。我们要为这些人创建一个聚在一起的社区，一切都围绕这份工作展开”，而不是围绕你。这会非常强大，他们会追随你。你成为了那个职业身份的一部分。太棒了。一定要这样做。但像 Gartner 魔力象限那种，只有在极少数情况下才有意义。大多数时候都没意义。别那样做。

---

### [00:56:34] Lenny

**English:**
Amazing. I love that. Is there more you wanted to add, there?

**中文翻译:**
太棒了。我喜欢这个。还有什么想补充的吗？

---

### [00:56:34] Zoelle Egner

**English:**
No.

**中文翻译:**
没有了。

---

### [00:56:39] Zoelle Egner

**English:**
I think that's enough on not to do.

**中文翻译:**
我想关于“不要做什么”说这些就够了。

---

### [00:56:40] Lenny

**English:**
What this reminds me of broadly is just, "Stay focused on the customer and their problems. Don't obsess with who you are, who are you selling to and how will you make their life better." Reminds me of this old idea from Kathy Sierra. Does that ring a bell?

**中文翻译:**
这让我广泛地想起：“专注于客户及其问题。不要痴迷于你是谁，而要关注你在卖给谁，以及你将如何让他们的生活变得更好。”这让我想起 Kathy Sierra 的一个老观点。你有印象吗？

---

### [00:56:55] Zoelle Egner

**English:**
Yeah. Oh totally.

**中文翻译:**
是的，完全有。

---

### [00:56:56] Lenny

**English:**
Where you make your customer a superhero, you want them to feel like a superhero. And if they feel like a superhero. And yeah, that sounds like that's essentially what you did with Airtable, a lot of these companies you worked with.

**中文翻译:**
就是把你的客户变成超级英雄，你想让他们觉得自己像个超级英雄。如果他们觉得自己像超级英雄……是的，听起来这本质上就是你在 Airtable 以及你合作过的许多公司所做的事情。

---

### [00:57:05] Zoelle Egner

**English:**
That that is always the goal. Like, "How can you make them the hero of the story and not you? Because no one cares about your company, what they care about is themselves, frankly."

**中文翻译:**
那始终是目标。比如：“你如何让他们成为故事的主角，而不是你？因为坦白说，没人关心你的公司，他们关心的是他们自己。”

---

### [00:57:12] Lenny

**English:**
Are there any products or companies you think of off the top of your head that are really good at this, that are just like they nailed this?

**中文翻译:**
你脑海中能立刻想到哪些产品或公司在这方面做得非常好，简直是教科书级别的？

---

### [00:57:18] Zoelle Egner

**English:**
Yeah, that's a good question. Certainly the two that I mentioned, that helped rebrand some of the professions, so like the Gainsights of the world. I'm blanking a little bit on the ones that have done this for DevOps really effectively, but there's certainly some that have.

**中文翻译:**
是的，好问题。当然是我提到的那两个，它们帮助重塑了一些职业，比如 Gainsight。我一时想不起哪些公司在 DevOps 领域做得非常有效，但肯定有一些。

---

### [00:57:32] Lenny

**English:**
Maybe Datadog?

**中文翻译:**
也许是 Datadog？

---

### [00:57:33] Zoelle Egner

**English:**
Yeah, Datadog has done a pretty good job of that. I think where I get excited is when the companies do this in a way that feels less self-serving, or less obviously self-serving. And that means that sometimes you have to be willing to invest in things that will not have super obviously immediate ROI for you, but they will for the community, and for building the community. Oh, actually one really good example, I think Notion has actually done a pretty good job of this. People are really, really invested in the templates that they create, because it feels like you're not pushing Notion, you're pushing the beautiful creation that you have to solve a problem. I think they've done a really nice job on that process, and several of their competitors, I think have done a pretty decent job as well, but they certainly come to mind.

**中文翻译:**
是的，Datadog 在这方面做得不错。我认为让我感到兴奋的是，当公司以一种不那么“自私”或不那么明显自私的方式来做这件事时。这意味着有时你必须愿意投资于那些对你没有超级明显、即时 ROI，但对社区和社区建设有好处的事情。噢，其实有一个非常好的例子，我认为 Notion 在这方面做得非常好。人们非常投入于他们创建的模板，因为感觉你不是在推销 Notion，而是在推销你为了解决问题而做出的精美创作。我认为他们在那个流程上做得非常好，他们的几个竞争对手我认为也做得不错，但 Notion 肯定是我首先想到的。

---

### [00:58:18] Lenny

**English:**
Thinking of templates, I know Airtable, known for templates, and you've mentioned this being a big part of the success, and I imagine a lot of companies now are just creating templates left, because they imagine that's the core, what helped a lot of these companies, Notion being an example. What is your take on the power and importance of templates for software?

**中文翻译:**
说到模板，我知道 Airtable 以模板著称，你也提到过这是成功的很大一部分原因。我猜现在很多公司都在疯狂创建模板，因为他们认为这是核心，是帮助这些公司（比如 Notion）成功的关键。你对软件模板的力量和重要性有什么看法？

---

### [00:58:38] Zoelle Egner

**English:**
I think they can be tremendously helpful if you are horizontal because they help to narrow the surface area for a user, so they understand how to connect the dots between their problem and your product. And if it is not obvious to someone how they can solve a specific problem, they're going to be like, "Oh, hey, that seems really cool. When I think of something I'll definitely come back." And then you have lost them. And so if you can be like, "Here are three templates that a person you might be excited about." That can be really helpful. Where people sometimes get confused about templates, or have the wrong expectations about templates, is when they think that templates are going to be an acquisition mechanism, and they don't build in the foundation that is necessary for that to be true. So a lot of people think that templates were what drove Airtable's top of funnel. That is not the case.

**中文翻译:**
我认为如果你做的是横向产品，模板会非常有帮助，因为它们有助于缩小用户的“认知范围”（surface area），让他们明白如何将自己的问题与你的产品联系起来。如果一个人看不出如何解决特定问题，他们会说：“噢，嘿，这看起来很酷。等我想出点什么时，我一定会回来的。”然后你就失去他们了。所以如果你能说：“这里有三个你可能会感兴趣的模板”，那会非常有帮助。人们有时会对模板产生困惑或错误的预期，是因为他们认为模板会成为一种“获客机制”，但他们却没有建立起实现这一目标所需的基础。很多人认为模板驱动了 Airtable 的漏斗顶端（获客），事实并非如此。

---

### [00:59:27] Zoelle Egner

**English:**
I was having a conversation with someone who worked a lot on SEO at Airtable in the much later days, and laughing over the fact that people thought that was a big source of traffic, because it was not. We did not optimize them for that. Good luck finding them in search most of the time. Not at all useful. Where they were helpful, narrowing that surface area, helping with matching patterns, helping people understand how the product worked, super helpful. Expansion within companies, tremendously useful.

**中文翻译:**
我曾与一位在 Airtable 后期负责 SEO 的同事交谈，我们都在笑，因为人们竟然认为那是流量的主要来源，其实根本不是。我们并没有为此对模板进行优化。大多数时候你在搜索中很难找到它们。在那方面一点用都没有。它们有用的地方在于：缩小认知范围、帮助匹配模式、帮助人们理解产品如何运作，这些都超级有用。在公司内部的扩张中，也极其有用。

---

### [00:59:55] Zoelle Egner

**English:**
But they were not a top of funnel mechanism for us, because we didn't put the work in to do that. We did not have an SEO engine. We weren't Zapier. Zapier has done a great job with that. They get a ton of traffic because they built it as a programmatic SEO play, but you have to be clear about what your goals are and what problem they're solving, because otherwise it is very easy to be like, "I'll just build a bunch of templates, and then all of the leads will appear," And that's not going to happen unless you invest in a lot more than at least Airtable did. So it can be useful to build them, know what you're doing it for, and how you're going to measure it, or otherwise you'll waste your time.

**中文翻译:**
但它们对我们来说不是漏斗顶端的机制，因为我们没有投入精力去做那件事。我们没有 SEO 引擎。我们不是 Zapier。Zapier 在这方面做得非常好，他们获得了大量流量，因为他们将其作为一种“程序化 SEO”策略来构建。但你必须清楚你的目标是什么，以及它们在解决什么问题。否则，很容易变成：“我只要建一堆模板，然后所有的线索就会出现。”除非你投入比 Airtable 更多的精力，否则那是不会发生的。所以，构建模板是有用的，但要清楚你为什么这么做，以及你将如何衡量它，否则你会浪费时间。

---

### [01:00:29] Lenny

**English:**
Do you think Airtable could have taken advantage of that top of funnel approach if they invested from an SEO perspective or do you think it wasn't an opportunity that worked?

**中文翻译:**
你认为如果 Airtable 从 SEO 的角度进行投资，是否本可以利用那种漏斗顶端的方法？还是你认为那根本不是一个行得通的机会？

---

### [01:00:37] Zoelle Egner

**English:**
I think it could have been. We would've needed to hire more humans. Airtable was an incredibly lean team for a very, very long time. From 2015, when I joined, until 2017 or 2018, we had barely 50 people. It was small for many, many years and so we had to make really difficult choices about what to prioritize and what not to prioritize. Should we have hired more people and done more things? I would argue in retrospect, absolutely, yes, there were opportunities that were left on the table, but in early days you leave good opportunities because you have to focus on other things.

**中文翻译:**
我认为本可以。但我们需要雇佣更多的人。Airtable 在很长一段时间内都是一支极其精简的团队。从 2015 年我加入到 2017 或 2018 年，我们只有不到 50 人。很多年来规模都很小，所以我们不得不对优先处理什么和不优先处理什么做出非常艰难的选择。我们是否应该雇佣更多人并做更多事？回想起来，我会说：绝对应该，是的，确实有一些机会被错过了。但在早期，你会放弃好的机会，因为你必须专注于其他事情。

---

### [01:01:13] Lenny

**English:**
Got it. And so a takeaway here is templates could be really useful for customer success versus SEO top of funnel. Right? That's where they became powerful.

**中文翻译:**
明白了。所以这里的结论是：模板对于“客户成功”非常有用，而不是对于“SEO 漏斗顶端”。对吧？那是它们发挥威力的地方。

---

### [01:01:21] Zoelle Egner

**English:**
Yeah. Still maybe helpful. Maybe for you, it makes sense to do the SEO play, just know that that is not a small play. It is an investment. It is not and not just like, "Have some people make some templates." You got to do way more than just that. It's not going to be sufficient.

**中文翻译:**
是的。可能仍然有帮助。也许对你来说，做 SEO 策略是有意义的，但要明白那不是一个小动作。那是一项投资。不仅仅是“让几个人做几个模板”那么简单。你必须做得远不止这些，光靠模板是不够的。

---

### [01:01:35] Lenny

**English:**
Final potential question, depending on where this goes, and I'm curious how spicy this answer gets, and it's around launches and PR. You work with a lot of startups, I imagine founders are always trying to plan a launch, get PR. I'm curious your take on the value of investing a bunch of resources in a big launch, the value of just getting PR as an early stage startup.

**中文翻译:**
最后一个潜在问题，取决于对话的走向，我很好奇这个回答会有多“辛辣”。它是关于“发布”和“公关”（PR）的。你和很多初创公司合作，我猜创始人总是试图策划发布会、搞公关。我很想听听你对投入大量资源进行大型发布的看法，以及作为早期初创公司，仅仅获得公关报道的价值。

---

### [01:01:56] Zoelle Egner

**English:**
Yeah, just getting PR is not a good goal. I know that's been well stated in the market, but just to reiterate it, most of the time PR is not going to get you leads or users, it's just not. And you have to think about when you are creating a launch or doing a piece of PR, what are the breadcrumbs that bring someone back to something that can actually convert? If you have your big tech crunch piece and it's super exciting, it says all these great things about you, and it maybe links to you once, somewhere in the 12th paragraph or whatever, how many people are actually going to click on that link? Not that many people. How many people are going to read that and remember to go Google it? Not as many as you want. Okay? There's going to be so much coming out of the funnel, it is not a useful acquisition mechanism.

**中文翻译:**
是的，仅仅获得公关报道并不是一个好目标。我知道市场上已经有很多这种说法了，但我还是要重申：大多数时候，公关不会为你带来线索或用户，真的不会。你必须思考，当你策划发布或做公关时，引导人们回到能产生实际转化的页面的“面包屑”（路径）是什么？如果你在 TechCrunch 上有一篇大报道，非常令人兴奋，把你夸得天花乱坠，但可能只在第 12 段左右链接了你一次，实际上会有多少人点击那个链接？没多少人。会有多少人读完后还记得去 Google 搜你？没你想象的那么多。明白吗？漏斗中会有大量的流失，它不是一个有效的获客机制。

---

### [01:02:43] Zoelle Egner

**English:**
What it is good for is credibility. And that's where, if you have really clear goals, and you know how you are ready to leverage the asset of a piece of PR coverage, then it can be helpful to you. So the two goals I always recommend to founders when thinking about using PR, are either hiring or maybe improving the response rate for your cold outbound. Those are the two that I think make the most sense, because in both cases they have a different distribution mechanism. In hiring, you're going to include that in an email that you're sending to a candidate. And so it's going to increase the likelihood that they take you seriously, and get excited about the company, and maybe actually end up ultimately joining your team.

**中文翻译:**
公关真正有用的是“公信力”。如果你有非常明确的目标，并且知道如何利用公关报道这一资产，那么它对你是有帮助的。在考虑使用公关时，我总是向创始人推荐两个目标：要么是为了招聘，要么是为了提高冷启动外呼（cold outbound）的回复率。我认为这两个目标最有意义，因为在这两种情况下，它们都有不同的分发机制。在招聘中，你会把报道链接放在发给候选人的邮件里。这会增加他们认真对待你、对公司感到兴奋并最终加入你团队的可能性。

---

### [01:03:22] Zoelle Egner

**English:**
Cold outbound, you're using it as credibility to say, "Hey, we're a real company you can trust." Great. Both of those things are all emails that you are proactively sending. You know exactly who they're going to, and you know that asset is going to have, hopefully, the impact that you're looking for, and you can measure whether it makes a difference or not. But just getting a piece of PR, to get a piece of PR is like it'll help with your internal morale, but I'm not sure it's going to do much help for you. So have really clear goals and have realistic goals, or you will be disappointed.

**中文翻译:**
在冷启动外呼中，你用它作为公信力来证明：“嘿，我们是一家你可以信任的正规公司。”太棒了。这两件事都是你主动发送的邮件。你确切地知道发给了谁，你也知道这项资产有望产生你想要的影响，而且你可以衡量它是否起到了作用。但仅仅为了公关而搞公关，可能只会对内部士气有所帮助，我不确定它能给你带来多大实质性帮助。所以，要有非常明确且现实的目标，否则你会失望的。

---

### [01:03:51] Zoelle Egner

**English:**
Launches however, do not need to just be about PR. In fact, in many cases PR is a distraction, and instead you can have not just one big launch but a series of launches that allow you to stay top of mind, to create momentum with your users, and to show up in lots of different places because audiences respond to novelty, it gives them a reason to care about your company. And so have your big, annual launch or whatever, but also have one two months from then, and another one, and another one. Find ways to use that novelty to your advantage and to get into communities that you think are going to be good fits for your company.

**中文翻译:**
然而，发布活动不一定非得围绕公关展开。事实上，在很多情况下，公关是一种干扰。相反，你可以不只搞一次大发布，而是搞一系列发布，让你能始终留在用户脑海中，创造用户势能，并在许多不同的地方出现。因为受众对新鲜感有反应，这给了他们关注你公司的理由。所以，搞你的年度大发布吧，但在那之后两个月再搞一个，然后再搞一个。想办法利用这种新鲜感作为你的优势，进入你认为适合你公司的社区。

---

### [01:04:26] Lenny

**English:**
I love that advice. Any final thoughts before we get to our very exciting lightning round?

**中文翻译:**
我喜欢这个建议。在进入我们非常令人兴奋的闪电轮提问之前，还有什么最后的想法吗？

---

### [01:04:34] Zoelle Egner

**English:**
Mostly just all of this is easier if you talk to your customers more. Build a system for yourself that will allow you to have those touchpoints. That's not just making everyone answer customer support tickets, though I do think that is a great idea, because it gives so much empathy and it's really helpful. You as a founder, if you're a founder, or a product manager, or whatever else, should find a way to get that on your calendar weekly or monthly. Go talk to people, it makes it better. You will have a better mental model. The other thing is strongly consider investing in customer success if you are a B2B company, early. Airtable had it before sales, which is a very unconventional approach, but early is worth it. It has huge dividends if you actually listen to them. If you're not going to listen to them, though, don't hire them, because that's sad.

**中文翻译:**
主要是，如果你多和客户交谈，这一切都会变得更容易。为自己建立一个系统，让你拥有这些触点。这不仅仅是让每个人都去回答客户支持工单（虽然我认为那是个好主意，因为它能带来同理心，非常有帮助）。作为创始人、产品经理或其他角色，你应该想办法把它列入你的每周或每月日程。去和人交谈，这会让事情变得更好。你会拥有更好的心理模型。另一件事是，如果你是一家 B2B 公司，请强烈考虑尽早投资于“客户成功”。Airtable 在有销售之前就有客户成功了，这是一种非常非传统的方法，但早期投入是值得的。如果你真的听取他们的意见，它会带来巨大的红利。但如果你不打算听他们的，就别雇他们，因为那很可悲。

---

### [01:05:22] Lenny

**English:**
I have followup questions on the customer success piece, say someone wants to invest in customer success, is there a resource, or person, or anything that you could point folks to, to understand and think about how to do this well?

**中文翻译:**
关于客户成功，我有后续问题。假设有人想投资客户成功，有没有什么资源、人或任何东西可以推荐给大家，让他们了解并思考如何做好这件事？

---

### [01:05:36] Zoelle Egner

**English:**
There's a lot for people within that profession. There's not as much for founders out there right now, unfortunately. This is an area that I very eagerly am looking for more resources to share with people. Minimally. I'll say, if you care about this, send me a message. I will give you some advice. All of our industry will be better if there are more people working on customer success. So I will help you. Send me a note. Otherwise, I'll try and dig out some other things and maybe you can share them, but there's not a ton. So people in customer success, please share your learnings more with founders. All of us would like to see it.

**中文翻译:**
对于这个职业内部的人来说有很多资源，但遗憾的是，目前针对创始人的资源并不多。这是我非常渴望寻找更多资源与大家分享的一个领域。至少我会说，如果你关心这个，给我发消息，我会给你一些建议。如果更多的人致力于客户成功，我们的整个行业都会变得更好。所以我会帮你，给我发个便条。除此之外，我会试着挖掘一些其他东西，也许你可以分享它们，但真的不多。所以，从事客户成功的人，请多向创始人分享你们的经验。我们大家都想看。

---

### [01:06:09] Lenny

**English:**
Yeah, I've actually been looking for someone to write a guest post in the newsletter, about just how to set up a customer success team. And so if you're listening, you think you could be that person. Let me know. Let's make this happen.

**中文翻译:**
是的，我其实一直在找人给 newsletter 写一篇客座文章，专门讲如何组建客户成功团队。所以如果你正在听，并且觉得自己可以胜任，请告诉我。让我们促成这件事。

---

### [01:06:28] Zoelle Egner

**English:**
Yeah.

**中文翻译:**
好的。

---

### [01:06:29] Lenny

**English:**
And then I wanted to ask you a question on the first piece of advice, which is, "Founders talk to the customers more often." Is there one tactical piece of advice you could recommend for how to do that? How to find a customer, how to set it up consistently?

**中文翻译:**
然后我想问你关于第一条建议的一个问题，即“创始人要更频繁地与客户交谈”。你能推荐一个具体的战术建议吗？如何找到客户，如何持续地安排这种交谈？

---

### [01:06:40] Zoelle Egner

**English:**
Totally. The simplest way to do this is to write a template email for yourself that you can send out very easily, that essentially says like, "Hey, thank you so much for using the product. I would really love to hear about your experience so far and get your feedback. Do you have 10 minutes to talk on the phone?" I know it is important that it's on the phone and not a survey because you get way more instinct from unstructured conversation than you're going to get from sending them three things in a Google survey.

**中文翻译:**
当然。最简单的方法是为自己写一封邮件模板，可以非常容易地发出去，内容基本上是：“嘿，非常感谢你使用我们的产品。我很想听听你到目前为止的使用体验并获取你的反馈。你有 10 分钟时间通个电话吗？”我知道通电话而不是发问卷很重要，因为从非结构化的对话中获得的直觉，远比在 Google 问卷中发三个问题要多得多。

---

### [01:07:05] Zoelle Egner

**English:**
Set it up, come up with a hypothesis of the type of person that you want to talk to and then run a query against your database, find someone and send three of those emails a week. And it's not exciting, but you can automate most of it and it will be helpful. None of this stuff has to be complicated. You just got to have a system.

**中文翻译:**
安排好它，先对你想交谈的人群类型提出一个假设，然后在你的数据库中运行查询，找到符合的人，每周发三封这样的邮件。这并不令人兴奋，但你可以自动化其中的大部分，而且会很有帮助。这些事都不需要很复杂，你只需要有一个系统。

---

### [01:07:23] Lenny

**English:**
Great advice. With that, we've reached our very exciting lightning round.

**中文翻译:**
很棒的建议。至此，我们进入了非常令人兴奋的闪电轮环节。

---

### [01:07:27] Zoelle Egner

**English:**
Yes.

**中文翻译:**
好的。

---

### [01:07:27] Lenny

**English:**
I've got six questions for you. I'm going to go through them pretty quick. Whatever comes to mind, let's see where it goes.

**中文翻译:**
我有六个问题要问你。我会很快过一遍。想到什么就说什么，看看会聊到哪儿。

---

### [01:07:34] Zoelle Egner

**English:**
Okay.

**中文翻译:**
好的。

---

### [01:07:34] Lenny

**English:**
Question number one. What are two or three books that you recommend most to other people?

**中文翻译:**
第一个问题：你最推荐给别人的两三本书是什么？

---

### [01:07:40] Zoelle Egner

**English:**
Okay, I hate this question because I take pride in making highly targeted recommendations, but I will do it anyway. I'm pretty sure you mostly talk to product and growth people. Right now, obviously, AI is a big topic of conversation, so here are two books that will enrich your mental model for artificial intelligence and encourage you to think about it from different perspectives. The first one, a little bit academic, highly recommend it, though. It's a book called Computing Taste by Nick Seaver.

**中文翻译:**
好吧，我讨厌这个问题，因为我以提供高度针对性的建议为荣，但我还是会回答。我很确定你主要和产品及增长人员交流。现在，显然 AI 是一个热门话题，所以这里有两本书可以丰富你对人工智能的心理模型，并鼓励你从不同角度思考它。第一本有点学术性，但强烈推荐，叫 Nick Seaver 写的《Computing Taste》（计算品味）。

---

### [01:08:09] Zoelle Egner

**English:**
He's a professor of anthropology and he did this study of people and companies who build music recognition algorithms. And it's a really interesting book for a bunch of reasons, including that it's a academic take on both tech culture, and more specifically, the unspoken and underlying assumptions that many workers who are building in this space have. It can be a little spicy and uncomfortable for a person in tech to read, but I think it is a fascinating perspective and very relevant to the stuff that's going on in AI right now. So go check it out. Computing Taste by Nick Seaver.

**中文翻译:**
他是一位人类学教授，他对构建音乐识别算法的人和公司进行了研究。这是一本非常有趣的书，原因有很多，包括它从学术角度审视了科技文化，更具体地说，是审视了许多在该领域工作的员工所持有的那些潜移默化的底层假设。对于科技圈的人来说，读起来可能会有点“辛辣”和不舒服，但我认为这是一个迷人的视角，而且与目前 AI 领域发生的事情非常相关。去看看吧，《Computing Taste》，Nick Seaver 著。

---

### [01:08:42] Zoelle Egner

**English:**
The second is a fiction book, but the Ancillary Justice series by Anne Leckie, about a spaceship AI that ends up separated from its ship and trapped in a body. I'm going to leave it at that. Worth reading for a different way of thinking about AI.

**中文翻译:**
第二本是小说，Anne Leckie 的《Ancillary Justice》（辅助正义）系列，讲述了一个飞船 AI 最终与飞船分离并被困在人类身体里的故事。我就说这么多。为了获得一种思考 AI 的不同方式，这本书值得一读。

---

### [01:08:56] Lenny

**English:**
I think we need a Zoelle full episode on book recommendations. These are amazing. Let's keep going.

**中文翻译:**
我觉得我们需要专门做一期 Zoelle 推荐书单的节目。这些太棒了。我们继续。

---

### [01:08:56] Zoelle Egner

**English:**
So fair.

**中文翻译:**
有道理。

---

### [01:09:02] Lenny

**English:**
What other podcast of yours that you love to listen to other than this podcast?

**中文翻译:**
除了本播客，你还喜欢听哪些播客？

---

### [01:09:07] Zoelle Egner

**English:**
Probably either Happiness Lab or Gastropod. I love food and also psychology, one of those two.

**中文翻译:**
可能是《Happiness Lab》或者《Gastropod》。我热爱美食，也热爱心理学，二选一吧。

---

### [01:09:13] Lenny

**English:**
Interesting. Okay, we'll keep going. Favorite recent movie or TV show?

**中文翻译:**
有趣。好的，继续。最近最喜欢的电影或电视剧？

---

### [01:09:17] Zoelle Egner

**English:**
Movie, Everything Everywhere All at Once. And TV show, there's a Korean drama called Extraordinary Attorney Woo. That, I really enjoyed.

**中文翻译:**
电影是《瞬息全宇宙》（Everything Everywhere All at Once）。电视剧的话，有一部韩剧叫《非常律师禹英禑》（Extraordinary Attorney Woo），我很喜欢。

---

### [01:09:26] Lenny

**English:**
Favorite interview question that you like to ask?

**中文翻译:**
你最喜欢问的面试问题是什么？

---

### [01:09:29] Zoelle Egner

**English:**
Yeah. Okay, so this one is related to customer success. It's my favorite question of all. People hate it, sorry. But I like to ask anyone who's going to be in a customer facing role, who needs to be able to keep their cool, and also learn stuff on the fly, and respond to customers, to solve an unfamiliar problem using Zapier. And they can use the internet to look things up, whatever, but I basically lay out for them a problem that I, as the customer want to solve, and have them build it for me live. This both is surprising for most people, so you get to see how they respond to an unfamiliar situation, which every client will give you at some point, and it shows how they learn things in a very concrete way, which is really interesting. So check it out. It works really well for customer success.

**中文翻译:**
好的，这个问题与客户成功有关。这是我最喜欢的问题。抱歉，大家都很讨厌它。我喜欢让任何应聘面对客户岗位的人（他们需要保持冷静、快速学习并回应客户）使用 Zapier 解决一个陌生的问题。他们可以上网查资料，但我基本上会给他们布置一个我作为客户想要解决的问题，让他们现场为我构建。这对大多数人来说都很意外，所以你可以看到他们如何应对陌生情况（每个客户迟早都会给你出难题），而且它以一种非常具体的方式展示了他们是如何学习新事物的，这非常有趣。试试看吧，它对客户成功岗位非常有效。

---

### [01:10:10] Lenny

**English:**
I've not heard that one before. Fascinating. Top five SaaS products that you enjoy and an Airtable cannot be one?

**中文翻译:**
我以前没听过这个。太迷人了。你最喜欢的五个 SaaS 产品（不能包括 Airtable）？

---

### [01:10:18] Zoelle Egner

**English:**
Ugh. Okay, then I'll try and avoid any company that I have worked for. I really like using Figma. It's nice when designers let me play with things. I've been really enjoying working with Webflow, also means that I can do stuff on my own. This is maybe spicy, but I actually love Google Docs. I'm not a Notion's fan stand, sorry. But Google Docs is like my best friend.

**中文翻译:**
呃，好吧，那我会尽量避开我工作过的任何公司。我非常喜欢用 Figma，设计师让我摆弄东西时感觉很好。我一直很喜欢用 Webflow，这意味着我可以自己动手。这可能有点“辛辣”，但我其实很喜欢 Google Docs。我不是 Notion 的死忠粉，抱歉。但 Google Docs 就像我最好的朋友。

---

### [01:10:37] Lenny

**English:**
Google Docs is great.

**中文翻译:**
Google Docs 确实很棒。

---

### [01:10:38] Zoelle Egner

**English:**
Yeah. And then there is a personal CRM company that I invested in, so sorry, maybe this is not allowed, but called Clay, and it is the only way I've ever been able to keep track of my relationships in a real way.

**中文翻译:**
是的。然后还有一家我投资的个人 CRM 公司（抱歉，也许这不被允许），叫 Clay。这是我唯一能真正追踪我的人际关系的方式。

---

### [01:10:48] Lenny

**English:**
Clay's great product.

**中文翻译:**
Clay 是个伟大的产品。

---

### [01:10:49] Zoelle Egner

**English:**
They're the best. And then I don't know if I love it, but I use Zoom so much that I feel like I must say it, because I spend so much of my time on it and it's categorically better than Google Meet.

**中文翻译:**
他们是最棒的。最后，我不确定我是否“爱”它，但我用 Zoom 太多了，我觉得必须得提它，因为我大部分时间都花在上面，而且它绝对比 Google Meet 好用。

---

### [01:11:01] Lenny

**English:**
Final question, favorite book, course, article, any resource on marketing that non marketers can learn from?

**中文翻译:**
最后一个问题：有没有什么非营销人员也能学习的关于营销的最喜欢的书、课程、文章或任何资源？

---

### [01:11:10] Zoelle Egner

**English:**
Okay, it's a newsletter. Does that work?

**中文翻译:**
好，是一个 newsletter。可以吗？

---

### [01:11:12] Lenny

**English:**
Absolutely.

**中文翻译:**
当然可以。

---

### [01:11:13] Zoelle Egner

**English:**
Amazing. Okay, so there is a specialist VC firm called MKT1. It's run by Emily Kramer and Kathleen Estreich, sorry if I pronounced your last name, there, wrong, Kathleen. It's all about marketing. They are marketing experts and operators who now invest, but they make the best frameworks that you can immediately apply. And there's templates and all sorts of super, super tactical stuff, which a lot of tactical marketing content is terrible because it's actually content marketing for some bad platform. Theirs is not. It is genuinely good. Go check it out.

**中文翻译:**
太棒了。有一家专门的 VC 机构叫 MKT1。它由 Emily Kramer 和 Kathleen Estreich 运营（Kathleen，如果我读错你的姓了，抱歉）。它完全是关于营销的。他们是现在转做投资的营销专家和运营者，但他们制作了可以立即应用的最好的框架。那里有模板和各种超级、超级实操的东西。很多实操性的营销内容都很糟糕，因为它们实际上是为某些烂平台做的内容营销。但他们的不是，是真心好。去看看吧。

---

### [01:11:43] Lenny

**English:**
A huge fan. Emily has been on the podcast.

**中文翻译:**
我是铁粉。Emily 曾经来过这个播客。

---

### [01:11:47] Lenny

**English:**
Yeah. And I look at that newsletter as the Lenny's newsletter of marketing, and it's exactly how you described.

**中文翻译:**
是的。我把那个 newsletter 看作是营销界的“Lenny's newsletter”，正如你描述的那样。

---

### [01:11:53] Zoelle Egner

**English:**
It's the best.

**中文翻译:**
它是最棒的。

---

### [01:11:53] Lenny

**English:**
Huge fan. Great recommendation. With that, Zoelle, thank you so much for being here. This was a lot of fun. And we got through a lot of stuff, which makes me really happy. Two final questions, where can folks find you online if they want to reach out, learn more, and how can listeners be useful to you?

**中文翻译:**
铁粉。很棒的推荐。Zoelle，非常感谢你能来。这次聊天非常愉快，我们聊了很多内容，这让我很开心。最后两个问题：如果大家想联系你或了解更多信息，可以在哪里找到你？听众能为你做些什么？

---

### [01:12:09] Zoelle Egner

**English:**
I am on Twitter @Zoelle. I'm also on LinkedIn, so I live there, come find me there. Otherwise, how can you be useful to me? Mostly like go forth and believe in customer success, and talk to your users, number one, because I am an avid user of technology, and I want it all to be better. Number two, no, that's all I got. Just go do those things and I will be so happy. Also, if you want to talk about customer success, anytime, hit me up. I'm here.

**中文翻译:**
我的 Twitter 账号是 @Zoelle。我也在 LinkedIn 上，我常在那儿，去那儿找我。至于大家能为我做什么？主要是：第一，去相信客户成功，并与你的用户交谈。因为我是一个狂热的技术用户，我希望一切都能变得更好。第二……没了，就这些。只要去做这些事，我就会非常开心。另外，如果你想聊聊客户成功，随时联系我，我都在。

---

### [01:12:35] Lenny

**English:**
I'm going to add a couple more things, which you mentioned to me offline, that you're hiring at Block Party.

**中文翻译:**
我要补充几件事，是你在线下跟我提到的：Block Party 正在招聘。

---

### [01:12:39] Zoelle Egner

**English:**
Yes.

**中文翻译:**
是的。

---

### [01:12:39] Lenny

**English:**
You're hiring growth people, PMs, engineers, and then you're also advising on the side with marketing customer success. Anything else you want to add, there?

**中文翻译:**
你们在招增长人员、产品经理、工程师。此外，你还在兼职做营销和客户成功的咨询。还有什么要补充的吗？

---

### [01:12:48] Zoelle Egner

**English:**
Yeah, absolutely. Love advising early stage companies. I'm especially helpful for pre seed and seed, usually, anything PLG, positioning, messaging, figuring out your channels, experimentation, all that early, fun stuff. I love it. Happy to help anytime. And we are hiring across all of the teams, but especially mine. So if you would like to come and do all sorts of fun experimentation, and also help keep people online safe, come look up, Block Party. I'd love to have you on my team.

**中文翻译:**
是的，没错。我喜欢为早期公司提供咨询。我通常对种子前（pre-seed）和种子轮（seed）阶段最有帮助，涉及 PLG、定位、信息传递、确定渠道、实验等所有早期有趣的事务。我热爱这些，随时乐意提供帮助。我们所有团队都在招聘，尤其是我的团队。所以，如果你想来做各种有趣的实验，并帮助保护人们的在线安全，请关注 Block Party。我很想让你加入我的团队。

---

### [01:13:18] Lenny

**English:**
Blockpartyapp.com.

**中文翻译:**
Blockpartyapp.com。

---

### [01:13:19] Zoelle Egner

**English:**
Did not get blockparty.com.

**中文翻译:**
没拿到 blockparty.com 这个域名。

---

### [01:13:19] Lenny

**English:**
You didn't. Zoelle, thank you. Very good.

**中文翻译:**
你确实没拿到。Zoelle，谢谢你。非常棒。

---

### [01:13:23] Zoelle Egner

**English:**
Thank you.

**中文翻译:**
谢谢。

---

### [01:13:28] Lenny

**English:**
Thank you so much for listening. If you found this valuable, you can subscribe to the show on Apple Podcasts, Spotify, or your favorite podcast app. Also, please consider giving us a rating or leaving a review, as that really helps other listeners find the podcast. You can find all past episodes or learn more about the show at lennyspodcast.com. See you in the next episode.

**中文翻译:**
非常感谢您的收听。如果您觉得这期节目有价值，可以在 Apple Podcasts、Spotify 或您喜欢的播客应用上订阅本节目。此外，请考虑给我们评分或留下评论，这能真正帮助其他听众发现本播客。您可以在 lennyspodcast.com 找到所有往期节目或了解更多信息。下期节目见。