# -*- coding: utf-8 -*-
"""
Flet兼容层 - 支持flet 0.21.x和0.28.x
"""

import flet as ft

# Icons兼容
if hasattr(ft, 'Icons'):
    Icons = ft.Icons
elif hasattr(ft, 'icons'):
    Icons = ft.icons
else:
    # 创建一个空类作为后备
    class Icons:
        MIC = "mic"
        MIC_OFF = "mic_off"
        REFRESH = "refresh"
        PLAY_ARROW = "play_arrow"
        STOP = "stop"
        SETTINGS = "settings"
        INFO = "info"
        WARNING = "warning"
        ERROR = "error"
        CHECK_CIRCLE = "check_circle"
        CLOSE = "close"
        MINIMIZE = "minimize"
        CROP_SQUARE = "crop_square"
        LIGHT_MODE = "light_mode"
        DARK_MODE = "dark_mode"
        HOME = "home"
        RECORD_VOICE_OVER = "record_voice_over"
        SMART_TOY = "smart_toy"
        VIDEOCAM = "videocam"
        LIVE_TV = "live_tv"
        FOLDER = "folder"
        FILE_DOWNLOAD = "file_download"

# Colors兼容
if hasattr(ft, 'Colors'):
    Colors = ft.Colors
elif hasattr(ft, 'colors'):
    Colors = ft.colors
else:
    class Colors:
        GREEN = "green"
        RED = "red"
        ORANGE = "orange"
        GREY = "grey"
        WHITE = "white"
        BLACK = "black"
        BLUE = "blue"
