# -*- coding: utf-8 -*-
"""
弹幕获取模块
支持直连和代理两种模式
"""

from .base import BaseDanmakuClient
from .direct_client import DirectDanmakuClient
from .proxy_client import ProxyDanmakuClient


def create_danmaku_client(
    room_id: str,
    mode: str = "direct",
    proxy_ws_url: str = "ws://127.0.0.1:8888"
) -> BaseDanmakuClient:
    """
    创建弹幕客户端
    
    Args:
        room_id: 直播间ID
        mode: 模式 "direct"(直连) 或 "proxy"(代理)
        proxy_ws_url: 代理WebSocket地址（仅proxy模式）
    
    Returns:
        BaseDanmakuClient: 弹幕客户端实例
    """
    if mode == "proxy":
        return ProxyDanmakuClient(room_id, proxy_ws_url)
    else:
        return DirectDanmakuClient(room_id)


__all__ = [
    'BaseDanmakuClient',
    'DirectDanmakuClient', 
    'ProxyDanmakuClient',
    'create_danmaku_client'
]
