# -*- coding: utf-8 -*-
"""
TTS语音合成模块
"""

from .base import BaseTTS
from .edge_tts_engine import EdgeTTSEngine


def create_tts_engine(
    engine: str = "edge",
    output_dir: str = "./output",
    **kwargs
) -> BaseTTS:
    """
    创建TTS引擎
    
    Args:
        engine: 引擎类型 "edge"
        output_dir: 输出目录
        **kwargs: 引擎特定参数
    
    Returns:
        BaseTTS: TTS引擎实例
    """
    if engine == "edge":
        return EdgeTTSEngine(
            output_dir=output_dir,
            voice=kwargs.get("voice", "zh-CN-XiaoxiaoNeural"),
            rate=kwargs.get("rate", "+0%"),
            volume=kwargs.get("volume", "+0%"),
            proxy=kwargs.get("proxy")
        )
    elif engine == "volcengine":
        from .volc_tts import VolcEngineTTS
        return VolcEngineTTS(
            app_id=kwargs.get("app_id"),
            access_token=kwargs.get("access_token"),
            voice_type=kwargs.get("voice_type", "BV001_streaming"),
            cluster=kwargs.get("cluster", "volcano_tts"),
            output_dir=output_dir
        )
    else:
        raise ValueError(f"不支持的TTS引擎: {engine}")


__all__ = [
    'BaseTTS',
    'EdgeTTSEngine',
    'create_tts_engine'
]
