# -*- coding: utf-8 -*-
"""
TTS语音合成基类
"""

from abc import ABC, abstractmethod
from typing import Optional
from pathlib import Path


class BaseTTS(ABC):
    """TTS基类"""
    
    def __init__(self, output_dir: str = "./output"):
        self.output_dir = Path(output_dir)
        self.output_dir.mkdir(parents=True, exist_ok=True)
    
    @abstractmethod
    async def synthesize(self, text: str, filename: str = None) -> Optional[str]:
        """
        合成语音
        
        Args:
            text: 要合成的文本
            filename: 输出文件名（可选）
        
        Returns:
            str: 音频文件路径，失败返回None
        """
        pass
    
    def _generate_filename(self, prefix: str = "tts") -> str:
        """生成唯一文件名"""
        import time
        timestamp = int(time.time() * 1000)
        return f"{prefix}_{timestamp}.mp3"
